/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 465
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EJoinType yy42;
  int8_t yy113;
  int64_t yy159;
  SToken yy179;
  EOperatorType yy290;
  EFillMode yy324;
  SDataType yy394;
  ENullOrder yy487;
  SNode* yy602;
  bool yy767;
  int32_t yy820;
  SAlterOption yy845;
  SNodeList* yy874;
  EOrder yy878;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             733
#define YYNRULE              554
#define YYNTOKEN             326
#define YY_MAX_SHIFT         732
#define YY_MIN_SHIFTREDUCE   1084
#define YY_MAX_SHIFTREDUCE   1637
#define YY_ERROR_ACTION      1638
#define YY_ACCEPT_ACTION     1639
#define YY_NO_ACTION         1640
#define YY_MIN_REDUCE        1641
#define YY_MAX_REDUCE        2194
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2883)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1914, 1784,  474, 2170,  475, 1677,  377, 2165, 1994, 1841,
 /*    10 */  1843, 1780,   45,   43, 1567, 1912,  609,   35,  284, 1990,
 /*    20 */   372,  621, 1416, 2169, 1914, 1848, 1786, 2166, 2168, 2008,
 /*    30 */  1842, 1843,  340, 1497, 1994, 1414,  363, 1990,  480, 1911,
 /*    40 */   609, 1846,   38,   37,  476, 1990,   44,   42,   41,   40,
 /*    50 */    39, 1986, 1992,  354,  164,  417,  597, 1441, 1492, 1749,
 /*    60 */  2026,  173,  632,  483,   18,  475, 1677,   84,  600, 1986,
 /*    70 */  1992, 1422,  622, 1976, 1639,  638,  621, 1986, 1992,  367,
 /*    80 */   632,  134,  343, 1897,   45,   43,  130,  138,  632,  621,
 /*    90 */  1790,  266,  372,  513, 1416,  326,   14,   48,  336,  411,
 /*   100 */   585,  622, 2007, 1795, 2165, 1497, 2043, 1414, 1773,  107,
 /*   110 */  2009,  642, 2011, 2012,  637,  130,  632,  607,  729,  584,
 /*   120 */   179,  176,  518, 2096, 2166,  586, 1442,  366, 2092,   60,
 /*   130 */  1492,   90, 1795, 1499, 1500, 1441,   18,  524,  523, 1526,
 /*   140 */   387,  181,  561, 1422, 1963, 1136, 2165, 1135,  608, 2122,
 /*   150 */   263, 2104,  596,  473,  131,  595,  478, 1683, 2165,  175,
 /*   160 */   217, 2171,  179, 1472, 1482,   48, 2166,  586,   14, 1498,
 /*   170 */  1501,  492, 1835,  584,  179, 1441, 1137,  364, 2166,  586,
 /*   180 */   528,  527,  526,  561, 1417,  161, 1415, 2165,  135,  522,
 /*   190 */   729, 1117,  394,  521, 1797,  490, 1527, 1907,  520,  525,
 /*   200 */  1342, 1343, 2171,  179,  519, 1499, 1500, 2166,  586, 1420,
 /*   210 */  1421,   60, 1471, 1474, 1475, 1476, 1477, 1478, 1479, 1480,
 /*   220 */  1481,  634,  630, 1490, 1491, 1493, 1494, 1495, 1496,    2,
 /*   230 */  1119, 2111, 1122, 1123,  482, 1472, 1482,  478, 1683, 1287,
 /*   240 */  1288, 1498, 1501,  120,    8, 2170,  119,  118,  117,  116,
 /*   250 */   115,  114,  113,  112,  111,  347, 1417, 2108, 1415,   38,
 /*   260 */    37,  173, 1443,   44,   42,   41,   40,   39,   34,  370,
 /*   270 */  1521, 1522, 1523, 1524, 1525, 1529, 1530, 1531, 1532,  492,
 /*   280 */   182, 1420, 1421, 1898, 1471, 1474, 1475, 1476, 1477, 1478,
 /*   290 */  1479, 1480, 1481,  634,  630, 1490, 1491, 1493, 1494, 1495,
 /*   300 */  1496,    2,   60,   11,   45,   43,  603,   44,   42,   41,
 /*   310 */    40,   39,  372, 1441, 1416, 2026,  182,  348, 1473,  346,
 /*   320 */   345, 2008,  515,  579,   84, 1497,  517, 1414, 1244,  664,
 /*   330 */   663,  662, 1248,  661, 1250, 1251,  660, 1253,  657, 1627,
 /*   340 */  1259,  654, 1261, 1262,  651,  648, 1771, 1791,  516,  561,
 /*   350 */  1492,  597, 2026, 2165, 1848, 2170,   18,  233,  418, 2165,
 /*   360 */   639,  352,  182, 1422,  580, 1976,  578,  638, 2171,  179,
 /*   370 */  1846,  419,  542, 2166,  586, 2169,   45,   43, 1502, 2166,
 /*   380 */  2167,  622,  138,  608,  372,  540, 1416,  538,   14,  410,
 /*   390 */  2008,  409, 1204,   64, 2007,   54,  676, 1497, 2043, 1414,
 /*   400 */   455,  107, 2009,  642, 2011, 2012,  637,  265,  632,  676,
 /*   410 */   729,  141, 1795,  147, 2067, 2096, 1443,  622,  218,  366,
 /*   420 */  2092, 2026, 1492, 1393, 1394, 1499, 1500, 1634, 1206,  639,
 /*   430 */   606,  184, 1907,  168, 1976, 1422,  638, 1440,  622,  509,
 /*   440 */   505,  501,  497,  215,  599,  177, 2104, 2105, 1795,  136,
 /*   450 */  2109, 1560,  415,  182,  575, 1472, 1482, 1710,  195,  194,
 /*   460 */    46, 1498, 1501, 2007, 1136,  622, 1135, 2043,  597, 1795,
 /*   470 */   108, 2009,  642, 2011, 2012,  637, 1417,  632, 1415,  416,
 /*   480 */    85,  454,  729,  213, 2096,   60,   38,   37, 2095, 2092,
 /*   490 */    44,   42,   41,   40,   39, 1137, 1795, 1499, 1500,  138,
 /*   500 */   667, 1420, 1421,   60, 1471, 1474, 1475, 1476, 1477, 1478,
 /*   510 */  1479, 1480, 1481,  634,  630, 1490, 1491, 1493, 1494, 1495,
 /*   520 */  1496,    2, 1633,  528,  527,  526, 2008, 1472, 1482,  622,
 /*   530 */  1848,  135,  522, 1498, 1501, 1422,  521,  360,  581,  576,
 /*   540 */   570,  520,  525,  425,   49,  161, 1846,  519, 1417,  608,
 /*   550 */  1415,  212,  206, 1772, 1798, 1442,  211, 2026,   11,  488,
 /*   560 */  1795,  265,  178, 2104, 2105,  600,  136, 2109, 1664,  163,
 /*   570 */  1976, 1653,  638, 1420, 1421,  204, 1471, 1474, 1475, 1476,
 /*   580 */  1477, 1478, 1479, 1480, 1481,  634,  630, 1490, 1491, 1493,
 /*   590 */  1494, 1495, 1496,    2,   45,   43,  617,  688, 1907, 2007,
 /*   600 */   275,  276,  372, 2043, 1416,  274,  107, 2009,  642, 2011,
 /*   610 */  2012,  637, 1976,  632, 1654, 1497,  533, 1414,  176,  104,
 /*   620 */  2096, 1893,   38,   37,  366, 2092,   44,   42,   41,   40,
 /*   630 */    39,  543,  187,  139, 1444, 1425,  182, 1528,  585,  556,
 /*   640 */  1492, 1787, 2165,   38,   37,  231, 2123,   44,   42,   41,
 /*   650 */    40,   39, 1782, 1422,  182, 2008,  375,  584,  179,  385,
 /*   660 */   536,  674, 2166,  586,  161,  530,   45,   43, 1359, 1360,
 /*   670 */   230,   13,   12, 1797,  372,  406, 1416,  622,   46,   27,
 /*   680 */   152,  151,  671,  670,  669,  149, 2026, 1497,  624, 1414,
 /*   690 */  2068,  440, 1571,   71,  639,  182,  408,  404, 1441, 1976,
 /*   700 */   729,  638,  561,  622, 1358, 1361, 2165,   67, 1795,   32,
 /*   710 */    66,   98, 1492, 1848, 1848, 1499, 1500,  441, 2111, 1533,
 /*   720 */   365, 2171,  179, 1636, 1637, 1422, 2166,  586, 2007, 1846,
 /*   730 */  1847, 1594, 2043, 1788, 1795,  107, 2009,  642, 2011, 2012,
 /*   740 */   637, 1848,  632,   79, 2107, 1472, 1482, 2185,  376, 2096,
 /*   750 */    14, 1498, 1501,  366, 2092,   38,   37, 1846, 1778,   44,
 /*   760 */    42,   41,   40,   39, 2130, 1444, 1417, 1540, 1415,  384,
 /*   770 */    38,   37,  729,  238,   44,   42,   41,   40,   39,  243,
 /*   780 */   572, 1592, 1593, 1595, 1596, 1663, 1428, 1499, 1500, 1662,
 /*   790 */   191, 1420, 1421,  150, 1471, 1474, 1475, 1476, 1477, 1478,
 /*   800 */  1479, 1480, 1481,  634,  630, 1490, 1491, 1493, 1494, 1495,
 /*   810 */  1496,    2,  561,  329,  633, 1439, 2165, 1472, 1482,   41,
 /*   820 */    40,   39,  448, 1498, 1501,  462, 1642,   81,  461, 1976,
 /*   830 */    80, 2171,  179, 1976, 1564, 2111, 2166,  586, 1417, 1707,
 /*   840 */  1415, 1473,  666,  431, 1604,  463,   53,  120,  433, 1661,
 /*   850 */   119,  118,  117,  116,  115,  114,  113,  112,  111, 1583,
 /*   860 */  1660, 2106,  234, 1420, 1421, 1825, 1471, 1474, 1475, 1476,
 /*   870 */  1477, 1478, 1479, 1480, 1481,  634,  630, 1490, 1491, 1493,
 /*   880 */  1494, 1495, 1496,    2, 2169,   31,  378,  700,  698, 1659,
 /*   890 */   344,   38,   37, 1976,  161,   44,   42,   41,   40,   39,
 /*   900 */  1122, 1123,  421, 1797, 1976,  706,  705,  704,  703,  382,
 /*   910 */   188,  702,  701,  142,  696,  695,  694,  693,  692,  691,
 /*   920 */   690,  154,  686,  685,  684,  381,  380,  681,  680,  679,
 /*   930 */   678,  677,  459, 1976, 2008,  453,  452,  451,  450,  447,
 /*   940 */   446,  445,  444,  443,  439,  438,  437,  436,  328,  428,
 /*   950 */   427,  426, 1878,  423,  422,  342,  162, 1641, 1658, 1657,
 /*   960 */   232,  304, 1750,   38,   37, 2026, 1995,   44,   42,   41,
 /*   970 */    40,   39,  674,  639, 2136,  302,   70, 1990, 1976,   69,
 /*   980 */   638,  129,  128,  127,  126,  125,  124,  123,  122,  121,
 /*   990 */  1893,  152,  151,  671,  670,  669,  149,  200,  470,  468,
 /*  1000 */   465,  189, 1976, 1976,   11, 1656,    9, 2007, 2008, 1986,
 /*  1010 */  1992, 2043, 2116, 1560,  107, 2009,  642, 2011, 2012,  637,
 /*  1020 */   632,  632,  622,   87,  331, 1655, 2185,  546, 2096,  544,
 /*  1030 */  1652,  260,  366, 2092,   60, 1893,  491,  597,  626, 2026,
 /*  1040 */  2068,  622, 1507, 2143,  622,  622,  193,  639, 1441, 1976,
 /*  1050 */    33,  622, 1976, 1795,  638, 1792,   38,   37,  235,  557,
 /*  1060 */    44,   42,   41,   40,   39,  285,  622, 1651,  138, 1976,
 /*  1070 */   622, 1444, 1795,  106, 1976, 1795, 1795, 1650, 1563, 2008,
 /*  1080 */   601, 2007, 1795, 1649,  605, 2043, 1648,  592,  107, 2009,
 /*  1090 */   642, 2011, 2012,  637,  241,  632,  140, 1795,  589, 2067,
 /*  1100 */  2185, 1795, 2096,  689,  435, 1765,  366, 2092,  622,  668,
 /*  1110 */  2026, 1976, 1839,  434,   78,   77,  414,  568,  639,  186,
 /*  1120 */   160, 1976,  279, 1976, 1770,  638, 2008, 1976,  369,  368,
 /*  1130 */  1976,  180, 2104, 2105,   88,  136, 2109,  327, 1430, 1795,
 /*  1140 */   402, 1424,  400,  396,  392,  389,  386,  588, 1647, 1497,
 /*  1150 */  1646, 1423, 2007,  622, 1645,  622, 2043, 2026, 1644,  107,
 /*  1160 */  2009,  642, 2011, 2012,  637,  639,  632,  619,   52,  620,
 /*  1170 */  1976, 2185,  638, 2096, 1492,  560,  672,  366, 2092, 1839,
 /*  1180 */   673,   13,   12, 1839, 1795,  182, 1795, 1422, 2159,  629,
 /*  1190 */   622, 1473, 1976,  298, 1976,  549, 1825, 2008, 1976, 2007,
 /*  1200 */   517, 1416, 1976, 2043,  379,  573,  107, 2009,  642, 2011,
 /*  1210 */  2012,  637,  150,  632, 1414,   50,  242,    3, 2185,  216,
 /*  1220 */  2096, 1795,  516,  223,  366, 2092,  221,  144, 2026,  132,
 /*  1230 */   225,  254,  674,  224,  628, 2115,  639,  227,  561, 1697,
 /*  1240 */   226, 1976, 2165,  638,  229, 1690, 1688,  228,   62, 2027,
 /*  1250 */  1422,  152,  151,  671,  670,  669,  149, 2171,  179,  247,
 /*  1260 */  1997,  529, 2166,  586,  682, 1391,  150,  531,  534,  383,
 /*  1270 */  2007,   47, 2008,  103, 2043,  272, 1902,  107, 2009,  642,
 /*  1280 */  2011, 2012,  637,  100,  632,  683, 1185, 1166, 1836, 2071,
 /*  1290 */  1678, 2096, 1427,   68, 2126,  366, 2092,  729,  148, 1684,
 /*  1300 */  1431, 1591, 1426, 2026,  598,   47,  262, 1183,  150, 1999,
 /*  1310 */     1,  639,  249,  593,  259,    4, 1976,  388,  638,  604,
 /*  1320 */   341, 1378,  590, 1167, 1356, 1434, 1436,   62,  277, 2008,
 /*  1330 */   393,  292, 1444,  192, 1518, 1439,  420,   47,  630, 1490,
 /*  1340 */  1491, 1493, 1494, 1495, 1496, 2007,  614, 1903,  724, 2043,
 /*  1350 */   424,  281,  107, 2009,  642, 2011, 2012,  637,  297,  632,
 /*  1360 */  2026, 1237,  732, 1417, 2069, 1415, 2096,  646,  639,  148,
 /*  1370 */   366, 2092,  150, 1976,  457,  638,  291,  429,  442,  133,
 /*  1380 */  1534, 1895,  148,  456,  449,  458,  464,  467, 1420, 1421,
 /*  1390 */  1483,  172,  466,  197,  469,  471, 1445,  722,  718,  714,
 /*  1400 */   710,  289, 2007, 2008,  472, 1447, 2043,  481,  484,  107,
 /*  1410 */  2009,  642, 2011, 2012,  637,  203,  632, 1442,  205, 1446,
 /*  1420 */  1265,  625, 1269, 2096,  486, 1276, 1448,  366, 2092,  489,
 /*  1430 */   485,  487, 1274,  208, 2026,  153,  210,   82,  105,   83,
 /*  1440 */   493,  282,  639,  214, 1139,  510,  512, 1976,  511,  638,
 /*  1450 */   110,  330, 1953, 1952,  548,  514,   86, 1785,  220, 1781,
 /*  1460 */   550,  222,  155,  146,  156,  293,  551, 2008,  236, 1783,
 /*  1470 */  1779,  157,  158,  239,  618,  552, 2007,  558,  574, 2142,
 /*  1480 */  2043,  612,  555,  108, 2009,  642, 2011, 2012,  637,  583,
 /*  1490 */   632, 2008,  565,    7, 2118, 2141,  255, 2096, 2026,  571,
 /*  1500 */  2127,  627, 2092,  566, 2137,  169,  639,  355,  577,  269,
 /*  1510 */   245, 1976,  253,  638,  268,  563,  248,  564,  258,  356,
 /*  1520 */   256,  261, 2026,  257,  594, 2188, 2164,  591,  137, 1443,
 /*  1530 */   636, 1385, 1560,  237,  602, 1976,  359,  638, 1449, 2112,
 /*  1540 */   640,  267,   93, 1908, 2043,  610,  294,  108, 2009,  642,
 /*  1550 */  2011, 2012,  637,  295,  632, 2008,  611, 1922,  615, 1921,
 /*  1560 */  1920, 2096,  362,  616, 2007,  335, 2092,  296, 2043,   95,
 /*  1570 */    97,  320, 2009,  642, 2011, 2012,  637,  635,  632,  623,
 /*  1580 */  2061,   59, 1796,   99,  644, 2077, 2026, 1766,  725, 1840,
 /*  1590 */   728,  288,  323, 1970,  639,  299,  332,   51,  726, 1976,
 /*  1600 */  1969,  638, 2008,  303,   75, 1968,  333, 1967,   76,  301,
 /*  1610 */  1964,  308,  390,  391, 1408, 1409,  322,  312,  185, 2008,
 /*  1620 */   395, 1962,  397,  398,  399, 1961,  401, 1960, 2007,  403,
 /*  1630 */  1959,  405, 2043, 2026, 1958,  165, 2009,  642, 2011, 2012,
 /*  1640 */   637,  639,  632,  407, 1381, 1380, 1976, 1933,  638, 1932,
 /*  1650 */  2026,  412,  413, 1931, 1930, 1886, 1885, 1883,  639, 1333,
 /*  1660 */   143, 1882, 1881, 1976, 1884,  638, 1880, 1879, 1877, 1876,
 /*  1670 */  1875,  190,  430, 1874,  432, 2007,  562, 2133, 1888, 2043,
 /*  1680 */   145, 1858,  166, 2009,  642, 2011, 2012,  637, 1873,  632,
 /*  1690 */  1872, 1871, 2007, 1870, 2008, 1869, 2043, 1335, 1853,  108,
 /*  1700 */  2009,  642, 2011, 2012,  637, 1868,  632, 1867, 1866, 1865,
 /*  1710 */  1864, 1863, 1862, 2096, 1861, 1860, 1859, 1857, 2093, 1856,
 /*  1720 */  1887, 1855, 1854, 1852, 1851, 2026,  460, 1850, 1849, 1713,
 /*  1730 */   196, 1212, 1712,  639,  587, 2186, 1711,  198, 1976, 1709,
 /*  1740 */   638, 2008,  199, 1673,  201,   73, 1996,  174, 1125, 1124,
 /*  1750 */  1672,  477, 1946, 1940, 1929, 1928,  209, 2008,  202, 1906,
 /*  1760 */   479, 1774, 1708, 1706,   74,  207, 1159, 2007,  494,  496,
 /*  1770 */  1704, 2043, 2026, 1702,  165, 2009,  642, 2011, 2012,  637,
 /*  1780 */   639,  632,  498,  500,  502, 1976,  495,  638, 2026,  499,
 /*  1790 */   503, 1700,  506,  507, 1687,  504,  639, 1686, 1669,  508,
 /*  1800 */  1776, 1976, 1281,  638, 1280,   61, 1775, 1203,  697, 1202,
 /*  1810 */   699, 1201, 1200, 1197, 2007, 2008, 2134, 1195, 2043, 1196,
 /*  1820 */  1194,  314, 2009,  642, 2011, 2012,  637, 1698,  632,  349,
 /*  1830 */  2007, 2008, 1691,  350, 2043, 1689,  532,  166, 2009,  642,
 /*  1840 */  2011, 2012,  637,  219,  632,  351, 2026,  535, 1668,  537,
 /*  1850 */  1667,  361,  539, 1666,  639,  541,  109, 1945, 1939, 1976,
 /*  1860 */  1398,  638, 2026, 1397,   26,  582, 1400,  545,  553, 1387,
 /*  1870 */   636, 1927,  159, 1925,   19, 1976,  567,  638, 1606, 2170,
 /*  1880 */    16,  569,   58,   28,  244,  251,  246, 1590, 2007,  167,
 /*  1890 */  2187, 2008, 2043, 1582,   20,  321, 2009,  642, 2011, 2012,
 /*  1900 */   637,  250,  632,    5, 2007,   29,  252, 2008, 2043, 1997,
 /*  1910 */   559,  320, 2009,  642, 2011, 2012,  637,   89,  632,   30,
 /*  1920 */  2062, 1626, 2026,    6,   63,   21, 1627,  371,   17, 1621,
 /*  1930 */   639, 1620,  240,  357, 1625, 1976,   55,  638, 2026, 1624,
 /*  1940 */   358, 1557, 1556,  373,  554,  353,  639,  264,  170, 1926,
 /*  1950 */    57, 1976, 1924,  638, 1923, 1905,   91,   92,  270,   22,
 /*  1960 */   613,  271, 2008, 1588, 2007,  273,  278, 1904, 2043,   94,
 /*  1970 */    65,  321, 2009,  642, 2011, 2012,  637,   23,  632,  280,
 /*  1980 */  2007,   96,  283,  100, 2043,   12, 1432,  321, 2009,  642,
 /*  1990 */  2011, 2012,  637, 2026,  632,  171, 1464,  183, 2046,  643,
 /*  2000 */  1487,  639, 1258,  631,  645,   36, 1976, 1485,  638, 2008,
 /*  2010 */  1484,   15, 1519,   24,  374,  641, 1456, 1266,   25,  647,
 /*  2020 */   649, 1263,  650,  652, 1260,  653, 2008,  655,   56, 1509,
 /*  2030 */   658, 1254, 1508,   10,  656,  547, 1252,  659, 1243, 2043,
 /*  2040 */  2026,  101,  316, 2009,  642, 2011, 2012,  637,  639,  632,
 /*  2050 */   665, 1257, 1256, 1976,  102,  638,  286, 2026, 1275,   72,
 /*  2060 */  1255, 1271, 1157,  675, 1191,  639, 1190, 1189, 1188, 1187,
 /*  2070 */  1976, 1186,  638, 1184, 1210, 1182, 1181, 1180, 1178,  687,
 /*  2080 */  1177,  287, 2007, 1176, 1175, 1174, 2043, 2008, 1173,  305,
 /*  2090 */  2009,  642, 2011, 2012,  637, 1172,  632, 1207, 1205, 2007,
 /*  2100 */  1169, 1168, 1165, 2043, 2008, 1164,  306, 2009,  642, 2011,
 /*  2110 */  2012,  637, 1163,  632, 1162, 1705,  707,  708, 2026,  709,
 /*  2120 */  1703,  711,  712,  713, 1701,  716,  639,  715,  717, 1699,
 /*  2130 */   719, 1976,  721,  638, 1685, 2026,  720,  723, 1114, 1665,
 /*  2140 */   290, 1418,  727,  639,  300, 1640,  730,  731, 1976, 1640,
 /*  2150 */   638, 2008, 1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640,
 /*  2160 */  2007, 1640, 1640, 1640, 2043, 1640, 1640,  307, 2009,  642,
 /*  2170 */  2011, 2012,  637, 1640,  632, 1640, 2008, 2007, 1640, 1640,
 /*  2180 */  1640, 2043, 2026, 1640,  313, 2009,  642, 2011, 2012,  637,
 /*  2190 */   639,  632, 1640, 1640, 1640, 1976, 1640,  638, 1640, 1640,
 /*  2200 */  1640, 1640, 1640, 1640, 1640, 1640, 1640, 2026, 1640, 1640,
 /*  2210 */  1640, 1640, 1640, 1640, 1640,  639, 1640, 1640, 1640, 1640,
 /*  2220 */  1976, 1640,  638, 1640, 2007, 1640, 1640, 1640, 2043, 1640,
 /*  2230 */  1640,  317, 2009,  642, 2011, 2012,  637, 2008,  632, 1640,
 /*  2240 */  1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640, 2007,
 /*  2250 */  1640, 1640, 1640, 2043, 1640, 1640,  309, 2009,  642, 2011,
 /*  2260 */  2012,  637, 1640,  632, 1640, 2008, 1640, 1640, 2026, 1640,
 /*  2270 */  1640, 1640, 1640, 1640, 1640, 1640,  639, 1640, 1640, 1640,
 /*  2280 */  1640, 1976, 1640,  638, 1640, 1640, 1640, 1640, 1640, 1640,
 /*  2290 */  1640, 1640, 1640, 1640, 1640, 1640, 2026, 1640, 1640, 1640,
 /*  2300 */  1640, 1640, 1640, 1640,  639, 1640, 1640, 1640, 1640, 1976,
 /*  2310 */  2007,  638, 1640, 1640, 2043, 1640, 1640,  318, 2009,  642,
 /*  2320 */  2011, 2012,  637, 2008,  632, 1640, 1640, 1640, 1640, 1640,
 /*  2330 */  1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640, 2007, 2008,
 /*  2340 */  1640, 1640, 2043, 1640, 1640,  310, 2009,  642, 2011, 2012,
 /*  2350 */   637, 1640,  632, 1640, 2026, 1640, 1640, 1640, 1640, 1640,
 /*  2360 */  1640, 1640,  639, 1640, 1640, 1640, 1640, 1976, 1640,  638,
 /*  2370 */  2026, 1640, 1640, 1640, 1640, 1640, 1640, 1640,  639, 1640,
 /*  2380 */  1640, 1640, 1640, 1976, 1640,  638, 1640, 1640, 1640, 1640,
 /*  2390 */  1640, 1640, 1640, 1640, 1640, 1640, 2007, 1640, 1640, 1640,
 /*  2400 */  2043, 1640, 2008,  319, 2009,  642, 2011, 2012,  637, 1640,
 /*  2410 */   632, 1640, 2007, 1640, 1640, 1640, 2043, 1640, 1640,  311,
 /*  2420 */  2009,  642, 2011, 2012,  637, 1640,  632, 1640, 1640, 1640,
 /*  2430 */  1640, 1640, 1640, 2026, 2008, 1640, 1640, 1640, 1640, 1640,
 /*  2440 */  1640,  639, 1640, 1640, 1640, 1640, 1976, 1640,  638, 1640,
 /*  2450 */  1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640,
 /*  2460 */  1640, 1640, 1640, 1640, 1640, 2026, 1640, 1640, 1640, 1640,
 /*  2470 */  1640, 1640, 1640,  639, 1640, 2007, 1640, 1640, 1976, 2043,
 /*  2480 */   638, 2008,  324, 2009,  642, 2011, 2012,  637, 1640,  632,
 /*  2490 */  1640, 1640, 1640, 1640, 1640, 1640, 1640, 2008, 1640, 1640,
 /*  2500 */  1640, 1640, 1640, 1640, 1640, 1640, 1640, 2007, 1640, 1640,
 /*  2510 */  1640, 2043, 2026, 1640,  325, 2009,  642, 2011, 2012,  637,
 /*  2520 */   639,  632, 1640, 1640, 1640, 1976, 1640,  638, 2026, 1640,
 /*  2530 */  1640, 1640, 1640, 1640, 1640, 1640,  639, 1640, 1640, 1640,
 /*  2540 */  1640, 1976, 1640,  638, 1640, 1640, 1640, 1640, 1640, 1640,
 /*  2550 */  1640, 1640, 2008, 1640, 2007, 1640, 1640, 1640, 2043, 1640,
 /*  2560 */  1640, 2020, 2009,  642, 2011, 2012,  637, 1640,  632, 1640,
 /*  2570 */  2007, 1640, 1640, 1640, 2043, 1640, 1640, 2019, 2009,  642,
 /*  2580 */  2011, 2012,  637, 2026,  632, 1640, 1640, 1640, 1640, 1640,
 /*  2590 */  1640,  639, 1640, 1640, 1640, 1640, 1976, 1640,  638, 1640,
 /*  2600 */  1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640,
 /*  2610 */  1640, 2008, 1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640,
 /*  2620 */  1640, 1640, 1640, 1640, 1640, 2007, 1640, 1640, 1640, 2043,
 /*  2630 */  1640, 1640, 2018, 2009,  642, 2011, 2012,  637, 1640,  632,
 /*  2640 */  1640, 2008, 2026, 1640, 1640, 1640, 1640, 1640, 1640, 1640,
 /*  2650 */   639, 1640, 1640, 1640, 1640, 1976, 1640,  638, 1640, 1640,
 /*  2660 */  1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640, 2008,
 /*  2670 */  1640, 1640, 2026, 1640, 1640, 1640, 1640, 1640, 1640, 1640,
 /*  2680 */   639, 1640, 1640, 1640, 2007, 1976, 1640,  638, 2043, 1640,
 /*  2690 */  1640,  337, 2009,  642, 2011, 2012,  637, 1640,  632, 2008,
 /*  2700 */  2026, 1640, 1640, 1640, 1640, 1640, 1640, 1640,  639, 1640,
 /*  2710 */  1640, 1640, 1640, 1976, 2007,  638, 1640, 1640, 2043, 1640,
 /*  2720 */  1640,  338, 2009,  642, 2011, 2012,  637, 1640,  632, 1640,
 /*  2730 */  2026, 1640, 1640, 1640, 1640, 1640, 1640, 1640,  639, 1640,
 /*  2740 */  1640, 1640, 2007, 1976, 1640,  638, 2043, 1640, 1640,  334,
 /*  2750 */  2009,  642, 2011, 2012,  637, 1640,  632, 1640, 1640, 1640,
 /*  2760 */  1640, 1640, 1640, 2008, 1640, 1640, 1640, 1640, 1640, 1640,
 /*  2770 */  1640, 1640, 2007, 1640, 1640, 1640, 2043, 1640, 1640,  339,
 /*  2780 */  2009,  642, 2011, 2012,  637, 1640,  632, 1640, 1640, 1640,
 /*  2790 */  1640, 1640, 1640, 1640, 2026, 2008, 1640, 1640, 1640, 1640,
 /*  2800 */  1640, 1640,  639, 1640, 1640, 1640, 1640, 1976, 1640,  638,
 /*  2810 */  1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640,
 /*  2820 */  1640, 1640, 1640, 1640, 1640, 1640, 2026, 1640, 1640, 1640,
 /*  2830 */  1640, 1640, 1640, 1640,  639, 1640,  640, 1640, 1640, 1976,
 /*  2840 */  2043,  638, 1640,  316, 2009,  642, 2011, 2012,  637, 1640,
 /*  2850 */   632, 1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640,
 /*  2860 */  1640, 1640, 1640, 1640, 1640, 1640, 1640, 1640, 2007, 1640,
 /*  2870 */  1640, 1640, 2043, 1640, 1640,  315, 2009,  642, 2011, 2012,
 /*  2880 */   637, 1640,  632,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   375,  361,  333,  435,  335,  336,  371,  439,  362,  374,
 /*    10 */   375,  361,   12,   13,   14,  390,  391,  424,  425,  373,
 /*    20 */    20,   20,   22,  455,  375,  360,  362,  459,  460,  329,
 /*    30 */   374,  375,  367,   33,  362,   35,  387,  373,   14,  390,
 /*    40 */   391,  376,    8,    9,   20,  373,   12,   13,   14,   15,
 /*    50 */    16,  405,  406,  407,  344,  337,  337,   20,   58,  349,
 /*    60 */   360,  360,  416,  333,   64,  335,  336,  343,  368,  405,
 /*    70 */   406,   71,  337,  373,  326,  375,   20,  405,  406,  407,
 /*    80 */   416,  357,  381,  382,   12,   13,  351,  368,  416,   20,
 /*    90 */   366,   58,   20,  358,   22,  377,   96,   96,   64,  392,
 /*   100 */   435,  337,  402,  368,  439,   33,  406,   35,    0,  409,
 /*   110 */   410,  411,  412,  413,  414,  351,  416,   20,  118,  454,
 /*   120 */   455,  421,  358,  423,  459,  460,   20,  427,  428,   96,
 /*   130 */    58,   98,  368,  133,  134,   20,   64,  346,  347,  105,
 /*   140 */   392,  441,  435,   71,    0,   20,  439,   22,  337,  449,
 /*   150 */   431,  432,  433,  334,  435,  436,  337,  338,  439,  359,
 /*   160 */    35,  454,  455,  163,  164,   96,  459,  460,   96,  169,
 /*   170 */   170,   63,  372,  454,  455,   20,   51,  352,  459,  460,
 /*   180 */    66,   67,   68,  435,  184,  360,  186,  439,   74,   75,
 /*   190 */   118,    4,   48,   79,  369,  384,  162,  386,   84,   85,
 /*   200 */   163,  164,  454,  455,   90,  133,  134,  459,  460,  209,
 /*   210 */   210,   96,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */    43,  408,   45,   46,  334,  163,  164,  337,  338,  133,
 /*   240 */   134,  169,  170,   21,   39,    3,   24,   25,   26,   27,
 /*   250 */    28,   29,   30,   31,   32,   37,  184,  434,  186,    8,
 /*   260 */     9,  360,   20,   12,   13,   14,   15,   16,  234,  235,
 /*   270 */   236,  237,  238,  239,  240,  241,  242,  243,  244,   63,
 /*   280 */   247,  209,  210,  382,  212,  213,  214,  215,  216,  217,
 /*   290 */   218,  219,  220,  221,  222,  223,  224,  225,  226,  227,
 /*   300 */   228,  229,   96,  231,   12,   13,  392,   12,   13,   14,
 /*   310 */    15,   16,   20,   20,   22,  360,  247,   99,  163,  101,
 /*   320 */   102,  329,  104,  368,  343,   33,  108,   35,  109,  110,
 /*   330 */   111,  112,  113,  114,  115,  116,  117,  118,  119,   97,
 /*   340 */   121,  122,  123,  124,  125,  126,    0,  366,  130,  435,
 /*   350 */    58,  337,  360,  439,  360,  435,   64,  127,   22,  439,
 /*   360 */   368,  367,  247,   71,   20,  373,  411,  375,  454,  455,
 /*   370 */   376,   35,   21,  459,  460,  455,   12,   13,   14,  459,
 /*   380 */   460,  337,  368,  337,   20,   34,   22,   36,   96,  183,
 /*   390 */   329,  185,   35,    4,  402,  351,   63,   33,  406,   35,
 /*   400 */    80,  409,  410,  411,  412,  413,  414,  165,  416,   63,
 /*   410 */   118,  419,  368,  421,  422,  423,   20,  337,   33,  427,
 /*   420 */   428,  360,   58,  193,  194,  133,  134,  176,   71,  368,
 /*   430 */   384,  351,  386,   48,  373,   71,  375,   20,  337,   54,
 /*   440 */    55,   56,   57,   58,  430,  431,  432,  433,  368,  435,
 /*   450 */   436,  246,  351,  247,  168,  163,  164,    0,  138,  139,
 /*   460 */    96,  169,  170,  402,   20,  337,   22,  406,  337,  368,
 /*   470 */   409,  410,  411,  412,  413,  414,  184,  416,  186,  351,
 /*   480 */    95,  161,  118,   98,  423,   96,    8,    9,  427,  428,
 /*   490 */    12,   13,   14,   15,   16,   51,  368,  133,  134,  368,
 /*   500 */   107,  209,  210,   96,  212,  213,  214,  215,  216,  217,
 /*   510 */   218,  219,  220,  221,  222,  223,  224,  225,  226,  227,
 /*   520 */   228,  229,  271,   66,   67,   68,  329,  163,  164,  337,
 /*   530 */   360,   74,   75,  169,  170,   71,   79,  367,  252,  253,
 /*   540 */   254,   84,   85,  351,   96,  360,  376,   90,  184,  337,
 /*   550 */   186,  166,  167,    0,  369,   20,  171,  360,  231,  174,
 /*   560 */   368,  165,  431,  432,  433,  368,  435,  436,  329,  328,
 /*   570 */   373,  330,  375,  209,  210,  190,  212,  213,  214,  215,
 /*   580 */   216,  217,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   590 */   226,  227,  228,  229,   12,   13,  384,   71,  386,  402,
 /*   600 */   127,  128,   20,  406,   22,  132,  409,  410,  411,  412,
 /*   610 */   413,  414,  373,  416,  330,   33,    4,   35,  421,  341,
 /*   620 */   423,  368,    8,    9,  427,  428,   12,   13,   14,   15,
 /*   630 */    16,   19,  379,  355,   20,   35,  247,  162,  435,  396,
 /*   640 */    58,  363,  439,    8,    9,   33,  449,   12,   13,   14,
 /*   650 */    15,   16,  361,   71,  247,  329,  352,  454,  455,  392,
 /*   660 */    48,  108,  459,  460,  360,   53,   12,   13,  133,  134,
 /*   670 */    58,    1,    2,  369,   20,  179,   22,  337,   96,   44,
 /*   680 */   127,  128,  129,  130,  131,  132,  360,   33,  420,   35,
 /*   690 */   422,  351,   14,  107,  368,  247,  200,  201,   20,  373,
 /*   700 */   118,  375,  435,  337,  169,  170,  439,   95,  368,  234,
 /*   710 */    98,  341,   58,  360,  360,  133,  134,  351,  408,  244,
 /*   720 */   367,  454,  455,  133,  134,   71,  459,  460,  402,  376,
 /*   730 */   376,  209,  406,  363,  368,  409,  410,  411,  412,  413,
 /*   740 */   414,  360,  416,  157,  434,  163,  164,  421,  367,  423,
 /*   750 */    96,  169,  170,  427,  428,    8,    9,  376,  361,   12,
 /*   760 */    13,   14,   15,   16,  438,   20,  184,   97,  186,  392,
 /*   770 */     8,    9,  118,  361,   12,   13,   14,   15,   16,  165,
 /*   780 */   258,  259,  260,  261,  262,  329,  186,  133,  134,  329,
 /*   790 */    58,  209,  210,   44,  212,  213,  214,  215,  216,  217,
 /*   800 */   218,  219,  220,  221,  222,  223,  224,  225,  226,  227,
 /*   810 */   228,  229,  435,   18,  361,   20,  439,  163,  164,   14,
 /*   820 */    15,   16,   27,  169,  170,   30,    0,   95,   33,  373,
 /*   830 */    98,  454,  455,  373,    4,  408,  459,  460,  184,    0,
 /*   840 */   186,  163,  361,   48,   97,   50,   97,   21,   53,  329,
 /*   850 */    24,   25,   26,   27,   28,   29,   30,   31,   32,   97,
 /*   860 */   329,  434,  353,  209,  210,  356,  212,  213,  214,  215,
 /*   870 */   216,  217,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   880 */   226,  227,  228,  229,    3,    2,  352,  346,  347,  329,
 /*   890 */    95,    8,    9,  373,  360,   12,   13,   14,   15,   16,
 /*   900 */    45,   46,  107,  369,  373,   66,   67,   68,   69,   70,
 /*   910 */   165,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   920 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   930 */    91,   92,  137,  373,  329,  140,  141,  142,  143,  144,
 /*   940 */   145,  146,  147,  148,  149,  150,  151,  152,  153,  154,
 /*   950 */   155,  156,    0,  158,  159,  160,   18,    0,  329,  329,
 /*   960 */   128,   23,  349,    8,    9,  360,  362,   12,   13,   14,
 /*   970 */    15,   16,  108,  368,  383,   37,   38,  373,  373,   41,
 /*   980 */   375,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   990 */   368,  127,  128,  129,  130,  131,  132,   59,   60,   61,
 /*  1000 */    62,  379,  373,  373,  231,  329,  233,  402,  329,  405,
 /*  1010 */   406,  406,  245,  246,  409,  410,  411,  412,  413,  414,
 /*  1020 */   416,  416,  337,  191,  192,  329,  421,  195,  423,  197,
 /*  1030 */   329,  463,  427,  428,   96,  368,  351,  337,  420,  360,
 /*  1040 */   422,  337,   14,  438,  337,  337,  379,  368,   20,  373,
 /*  1050 */     2,  337,  373,  368,  375,  351,    8,    9,  351,  351,
 /*  1060 */    12,   13,   14,   15,   16,  351,  337,  329,  368,  373,
 /*  1070 */   337,   20,  368,  135,  373,  368,  368,  329,  248,  329,
 /*  1080 */   351,  402,  368,  329,  351,  406,  329,   44,  409,  410,
 /*  1090 */   411,  412,  413,  414,   58,  416,  419,  368,   44,  422,
 /*  1100 */   421,  368,  423,  348,  152,  350,  427,  428,  337,  370,
 /*  1110 */   360,  373,  373,  161,  176,  177,  178,  438,  368,  181,
 /*  1120 */   165,  373,  351,  373,    0,  375,  329,  373,   12,   13,
 /*  1130 */   373,  431,  432,  433,   98,  435,  436,  199,   22,  368,
 /*  1140 */   202,   35,  204,  205,  206,  207,  208,  266,  329,   33,
 /*  1150 */   329,   35,  402,  337,  329,  337,  406,  360,  329,  409,
 /*  1160 */   410,  411,  412,  413,  414,  368,  416,  351,  165,  351,
 /*  1170 */   373,  421,  375,  423,   58,  172,  370,  427,  428,  373,
 /*  1180 */   370,    1,    2,  373,  368,  247,  368,   71,  438,   64,
 /*  1190 */   337,  163,  373,  353,  373,  392,  356,  329,  373,  402,
 /*  1200 */   108,   22,  373,  406,  351,  452,  409,  410,  411,  412,
 /*  1210 */   413,  414,   44,  416,   35,   42,  165,   44,  421,  339,
 /*  1220 */   423,  368,  130,  100,  427,  428,  103,   42,  360,   44,
 /*  1230 */   100,  446,  108,  103,  118,  438,  368,  100,  435,    0,
 /*  1240 */   103,  373,  439,  375,  100,    0,    0,  103,   44,  360,
 /*  1250 */    71,  127,  128,  129,  130,  131,  132,  454,  455,   44,
 /*  1260 */    47,   22,  459,  460,   13,   97,   44,   22,   22,  339,
 /*  1270 */   402,   44,  329,   96,  406,   44,  383,  409,  410,  411,
 /*  1280 */   412,  413,  414,  106,  416,   13,   35,   35,  372,  421,
 /*  1290 */   336,  423,  186,   44,  383,  427,  428,  118,   44,    0,
 /*  1300 */   184,   97,  186,  360,  437,   44,  456,   35,   44,   96,
 /*  1310 */   440,  368,   97,  270,  429,  249,  373,  404,  375,   97,
 /*  1320 */   403,  182,  268,   71,   97,  209,  210,   44,   97,  329,
 /*  1330 */    48,  394,   20,   42,  209,   20,  380,   44,  222,  223,
 /*  1340 */   224,  225,  226,  227,  228,  402,   97,  383,   49,  406,
 /*  1350 */   380,   97,  409,  410,  411,  412,  413,  414,   97,  416,
 /*  1360 */   360,   97,   19,  184,  421,  186,  423,   44,  368,   44,
 /*  1370 */   427,  428,   44,  373,  162,  375,   33,  378,  337,   44,
 /*  1380 */    97,  337,   44,  378,  380,  378,  337,  345,  209,  210,
 /*  1390 */    97,   48,   94,  337,  337,  337,   20,   54,   55,   56,
 /*  1400 */    57,   58,  402,  329,  331,   20,  406,  331,  398,  409,
 /*  1410 */   410,  411,  412,  413,  414,  343,  416,   20,  343,   20,
 /*  1420 */    97,  421,   97,  423,  338,   97,   20,  427,  428,  338,
 /*  1430 */   375,  393,   97,  343,  360,   97,  343,  343,   95,  343,
 /*  1440 */   337,   98,  368,  343,   52,  340,  331,  373,  340,  375,
 /*  1450 */   337,  331,  373,  373,  198,  360,   96,  360,  360,  360,
 /*  1460 */   401,  360,  360,  400,  360,  398,  189,  329,  341,  360,
 /*  1470 */   360,  360,  360,  341,  131,  397,  402,  337,  257,  445,
 /*  1480 */   406,  256,  375,  409,  410,  411,  412,  413,  414,  175,
 /*  1490 */   416,  329,  373,  263,  448,  445,  444,  423,  360,  373,
 /*  1500 */   383,  427,  428,  265,  383,  445,  368,  373,  373,  166,
 /*  1510 */   388,  373,  447,  375,  171,  250,  388,  264,  404,  272,
 /*  1520 */   443,  457,  360,  442,  269,  464,  458,  267,  368,   20,
 /*  1530 */   368,  188,  246,  190,  337,  373,  338,  375,   20,  408,
 /*  1540 */   402,  341,  341,  386,  406,  373,  388,  409,  410,  411,
 /*  1550 */   412,  413,  414,  388,  416,  329,  373,  373,  167,  373,
 /*  1560 */   373,  423,  373,  385,  402,  427,  428,  356,  406,  341,
 /*  1570 */   341,  409,  410,  411,  412,  413,  414,  415,  416,  417,
 /*  1580 */   418,   96,  368,   96,  364,  426,  360,  350,   36,  373,
 /*  1590 */   331,  341,  399,    0,  368,  337,  389,  395,  332,  373,
 /*  1600 */     0,  375,  329,  327,  191,    0,  389,    0,   42,  342,
 /*  1610 */     0,  354,   35,  203,   35,   35,  354,  354,   35,  329,
 /*  1620 */   203,    0,   35,   35,  203,    0,  203,    0,  402,   35,
 /*  1630 */     0,   22,  406,  360,    0,  409,  410,  411,  412,  413,
 /*  1640 */   414,  368,  416,   35,  186,  184,  373,    0,  375,    0,
 /*  1650 */   360,  180,  179,    0,    0,    0,    0,    0,  368,   47,
 /*  1660 */    42,    0,    0,  373,    0,  375,    0,    0,    0,    0,
 /*  1670 */     0,  152,   35,    0,  152,  402,  450,  451,    0,  406,
 /*  1680 */    42,    0,  409,  410,  411,  412,  413,  414,    0,  416,
 /*  1690 */     0,    0,  402,    0,  329,    0,  406,   22,    0,  409,
 /*  1700 */   410,  411,  412,  413,  414,    0,  416,    0,    0,    0,
 /*  1710 */     0,    0,    0,  423,    0,    0,    0,    0,  428,    0,
 /*  1720 */     0,    0,    0,    0,    0,  360,  136,    0,    0,    0,
 /*  1730 */    58,   35,    0,  368,  461,  462,    0,   58,  373,    0,
 /*  1740 */   375,  329,   58,    0,   42,   39,   47,   44,   14,   14,
 /*  1750 */     0,   47,    0,    0,    0,    0,  175,  329,   40,    0,
 /*  1760 */    47,    0,    0,    0,   39,   39,   65,  402,   35,   39,
 /*  1770 */     0,  406,  360,    0,  409,  410,  411,  412,  413,  414,
 /*  1780 */   368,  416,   35,   39,   35,  373,   48,  375,  360,   48,
 /*  1790 */    48,    0,   35,   48,    0,   39,  368,    0,    0,   39,
 /*  1800 */     0,  373,   35,  375,   22,  105,    0,   35,   44,   35,
 /*  1810 */    44,   35,   35,   35,  402,  329,  451,   22,  406,   35,
 /*  1820 */    35,  409,  410,  411,  412,  413,  414,    0,  416,   22,
 /*  1830 */   402,  329,    0,   22,  406,    0,   50,  409,  410,  411,
 /*  1840 */   412,  413,  414,  103,  416,   22,  360,   35,    0,   35,
 /*  1850 */     0,  365,   35,    0,  368,   22,   20,    0,    0,  373,
 /*  1860 */    35,  375,  360,   35,   96,  453,   97,  196,   22,   35,
 /*  1870 */   368,    0,  187,    0,   44,  373,  230,  375,   97,    3,
 /*  1880 */   251,  255,   44,   96,   96,   44,   97,   97,  402,   96,
 /*  1890 */   462,  329,  406,   97,  251,  409,  410,  411,  412,  413,
 /*  1900 */   414,   96,  416,  172,  402,   96,   47,  329,  406,   47,
 /*  1910 */   173,  409,  410,  411,  412,  413,  414,   96,  416,   44,
 /*  1920 */   418,   97,  360,  172,    3,   44,   97,  365,  251,   35,
 /*  1930 */   368,   35,  167,   35,   35,  373,  165,  375,  360,   35,
 /*  1940 */    35,   97,   97,  365,  165,  165,  368,   47,   47,    0,
 /*  1950 */    44,  373,    0,  375,    0,    0,   96,   39,   47,   96,
 /*  1960 */   168,   97,  329,   97,  402,   96,   96,    0,  406,   39,
 /*  1970 */    96,  409,  410,  411,  412,  413,  414,   44,  416,  166,
 /*  1980 */   402,   96,   47,  106,  406,    2,   22,  409,  410,  411,
 /*  1990 */   412,  413,  414,  360,  416,   47,   22,   47,   96,  107,
 /*  2000 */    97,  368,  120,   96,   35,   96,  373,   97,  375,  329,
 /*  2010 */    97,   96,  209,   96,   35,  211,   97,   97,   96,   96,
 /*  2020 */    35,   97,   96,   35,   97,   96,  329,   35,  245,  230,
 /*  2030 */    35,   97,  230,  232,   96,  402,   97,   96,   22,  406,
 /*  2040 */   360,   96,  409,  410,  411,  412,  413,  414,  368,  416,
 /*  2050 */   108,  120,  120,  373,   96,  375,   44,  360,   35,   96,
 /*  2060 */   120,   22,   65,   64,   35,  368,   35,   35,   35,   35,
 /*  2070 */   373,   35,  375,   35,   71,   35,   35,   35,   35,   93,
 /*  2080 */    35,   44,  402,   35,   22,   35,  406,  329,   35,  409,
 /*  2090 */   410,  411,  412,  413,  414,   35,  416,   71,   35,  402,
 /*  2100 */    35,   35,   35,  406,  329,   35,  409,  410,  411,  412,
 /*  2110 */   413,  414,   22,  416,   35,    0,   35,   48,  360,   39,
 /*  2120 */     0,   35,   48,   39,    0,   48,  368,   35,   39,    0,
 /*  2130 */    35,  373,   39,  375,    0,  360,   48,   35,   35,    0,
 /*  2140 */    22,   22,   21,  368,   22,  465,   21,   20,  373,  465,
 /*  2150 */   375,  329,  465,  465,  465,  465,  465,  465,  465,  465,
 /*  2160 */   402,  465,  465,  465,  406,  465,  465,  409,  410,  411,
 /*  2170 */   412,  413,  414,  465,  416,  465,  329,  402,  465,  465,
 /*  2180 */   465,  406,  360,  465,  409,  410,  411,  412,  413,  414,
 /*  2190 */   368,  416,  465,  465,  465,  373,  465,  375,  465,  465,
 /*  2200 */   465,  465,  465,  465,  465,  465,  465,  360,  465,  465,
 /*  2210 */   465,  465,  465,  465,  465,  368,  465,  465,  465,  465,
 /*  2220 */   373,  465,  375,  465,  402,  465,  465,  465,  406,  465,
 /*  2230 */   465,  409,  410,  411,  412,  413,  414,  329,  416,  465,
 /*  2240 */   465,  465,  465,  465,  465,  465,  465,  465,  465,  402,
 /*  2250 */   465,  465,  465,  406,  465,  465,  409,  410,  411,  412,
 /*  2260 */   413,  414,  465,  416,  465,  329,  465,  465,  360,  465,
 /*  2270 */   465,  465,  465,  465,  465,  465,  368,  465,  465,  465,
 /*  2280 */   465,  373,  465,  375,  465,  465,  465,  465,  465,  465,
 /*  2290 */   465,  465,  465,  465,  465,  465,  360,  465,  465,  465,
 /*  2300 */   465,  465,  465,  465,  368,  465,  465,  465,  465,  373,
 /*  2310 */   402,  375,  465,  465,  406,  465,  465,  409,  410,  411,
 /*  2320 */   412,  413,  414,  329,  416,  465,  465,  465,  465,  465,
 /*  2330 */   465,  465,  465,  465,  465,  465,  465,  465,  402,  329,
 /*  2340 */   465,  465,  406,  465,  465,  409,  410,  411,  412,  413,
 /*  2350 */   414,  465,  416,  465,  360,  465,  465,  465,  465,  465,
 /*  2360 */   465,  465,  368,  465,  465,  465,  465,  373,  465,  375,
 /*  2370 */   360,  465,  465,  465,  465,  465,  465,  465,  368,  465,
 /*  2380 */   465,  465,  465,  373,  465,  375,  465,  465,  465,  465,
 /*  2390 */   465,  465,  465,  465,  465,  465,  402,  465,  465,  465,
 /*  2400 */   406,  465,  329,  409,  410,  411,  412,  413,  414,  465,
 /*  2410 */   416,  465,  402,  465,  465,  465,  406,  465,  465,  409,
 /*  2420 */   410,  411,  412,  413,  414,  465,  416,  465,  465,  465,
 /*  2430 */   465,  465,  465,  360,  329,  465,  465,  465,  465,  465,
 /*  2440 */   465,  368,  465,  465,  465,  465,  373,  465,  375,  465,
 /*  2450 */   465,  465,  465,  465,  465,  465,  465,  465,  465,  465,
 /*  2460 */   465,  465,  465,  465,  465,  360,  465,  465,  465,  465,
 /*  2470 */   465,  465,  465,  368,  465,  402,  465,  465,  373,  406,
 /*  2480 */   375,  329,  409,  410,  411,  412,  413,  414,  465,  416,
 /*  2490 */   465,  465,  465,  465,  465,  465,  465,  329,  465,  465,
 /*  2500 */   465,  465,  465,  465,  465,  465,  465,  402,  465,  465,
 /*  2510 */   465,  406,  360,  465,  409,  410,  411,  412,  413,  414,
 /*  2520 */   368,  416,  465,  465,  465,  373,  465,  375,  360,  465,
 /*  2530 */   465,  465,  465,  465,  465,  465,  368,  465,  465,  465,
 /*  2540 */   465,  373,  465,  375,  465,  465,  465,  465,  465,  465,
 /*  2550 */   465,  465,  329,  465,  402,  465,  465,  465,  406,  465,
 /*  2560 */   465,  409,  410,  411,  412,  413,  414,  465,  416,  465,
 /*  2570 */   402,  465,  465,  465,  406,  465,  465,  409,  410,  411,
 /*  2580 */   412,  413,  414,  360,  416,  465,  465,  465,  465,  465,
 /*  2590 */   465,  368,  465,  465,  465,  465,  373,  465,  375,  465,
 /*  2600 */   465,  465,  465,  465,  465,  465,  465,  465,  465,  465,
 /*  2610 */   465,  329,  465,  465,  465,  465,  465,  465,  465,  465,
 /*  2620 */   465,  465,  465,  465,  465,  402,  465,  465,  465,  406,
 /*  2630 */   465,  465,  409,  410,  411,  412,  413,  414,  465,  416,
 /*  2640 */   465,  329,  360,  465,  465,  465,  465,  465,  465,  465,
 /*  2650 */   368,  465,  465,  465,  465,  373,  465,  375,  465,  465,
 /*  2660 */   465,  465,  465,  465,  465,  465,  465,  465,  465,  329,
 /*  2670 */   465,  465,  360,  465,  465,  465,  465,  465,  465,  465,
 /*  2680 */   368,  465,  465,  465,  402,  373,  465,  375,  406,  465,
 /*  2690 */   465,  409,  410,  411,  412,  413,  414,  465,  416,  329,
 /*  2700 */   360,  465,  465,  465,  465,  465,  465,  465,  368,  465,
 /*  2710 */   465,  465,  465,  373,  402,  375,  465,  465,  406,  465,
 /*  2720 */   465,  409,  410,  411,  412,  413,  414,  465,  416,  465,
 /*  2730 */   360,  465,  465,  465,  465,  465,  465,  465,  368,  465,
 /*  2740 */   465,  465,  402,  373,  465,  375,  406,  465,  465,  409,
 /*  2750 */   410,  411,  412,  413,  414,  465,  416,  465,  465,  465,
 /*  2760 */   465,  465,  465,  329,  465,  465,  465,  465,  465,  465,
 /*  2770 */   465,  465,  402,  465,  465,  465,  406,  465,  465,  409,
 /*  2780 */   410,  411,  412,  413,  414,  465,  416,  465,  465,  465,
 /*  2790 */   465,  465,  465,  465,  360,  329,  465,  465,  465,  465,
 /*  2800 */   465,  465,  368,  465,  465,  465,  465,  373,  465,  375,
 /*  2810 */   465,  465,  465,  465,  465,  465,  465,  465,  465,  465,
 /*  2820 */   465,  465,  465,  465,  465,  465,  360,  465,  465,  465,
 /*  2830 */   465,  465,  465,  465,  368,  465,  402,  465,  465,  373,
 /*  2840 */   406,  375,  465,  409,  410,  411,  412,  413,  414,  465,
 /*  2850 */   416,  465,  465,  465,  465,  465,  465,  465,  465,  465,
 /*  2860 */   465,  465,  465,  465,  465,  465,  465,  465,  402,  465,
 /*  2870 */   465,  465,  406,  465,  465,  409,  410,  411,  412,  413,
 /*  2880 */   414,  465,  416,
};
#define YY_SHIFT_COUNT    (732)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2139)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   938,    0,   72,    0,  292,  292,  292,  292,  292,  292,
 /*    10 */   292,  292,  292,  292,  292,  364,  582,  582,  654,  582,
 /*    20 */   582,  582,  582,  582,  582,  582,  582,  582,  582,  582,
 /*    30 */   582,  582,  582,  582,  582,  582,  582,  582,  582,  582,
 /*    40 */   582,  582,  582,  582,  582,  582,  582,  582,   69,  115,
 /*    50 */     1,  206,   33,  407,  448,  407,    1,    1, 1116, 1116,
 /*    60 */   407, 1116, 1116,  389,  407,  535,   56,   56,  535,  187,
 /*    70 */   187,   37,  106,   24,   24,   56,   56,   56,   56,   56,
 /*    80 */    56,   56,   97,   56,   56,  216,  293,   56,   56,  344,
 /*    90 */    56,  293,   56,   97,   56,   97,  293,   56,   56,  293,
 /*   100 */    56,  293,  293,  293,   56,  333,  795,   34,   34,  222,
 /*   110 */   114, 1179, 1179, 1179, 1179, 1179, 1179, 1179, 1179, 1179,
 /*   120 */  1179, 1179, 1179, 1179, 1179, 1179, 1179, 1179, 1179, 1179,
 /*   130 */   218,  242,   37,  106,  108,  357,  396,  396,  396,  346,
 /*   140 */   773,  773,  357,  417,  417,  417,  393,  327,  293,  464,
 /*   150 */   293,  464,  464,  393,  526,  219,  219,  219,  219,  219,
 /*   160 */   219,  219, 1343,  826,  457,  614,  251,  522,  125,  286,
 /*   170 */   678, 1028,  444,  745,  855, 1092, 1051,  767,  205,  881,
 /*   180 */   767, 1173,  830,  155, 1066, 1282, 1139, 1291, 1312, 1291,
 /*   190 */  1212, 1315, 1315, 1291, 1212, 1212, 1315, 1298, 1315, 1315,
 /*   200 */  1315, 1376, 1376, 1385,  216, 1397,  216, 1399, 1406,  216,
 /*   210 */  1399,  216,  216,  216, 1315,  216, 1392, 1392, 1376,  293,
 /*   220 */   293,  293,  293,  293,  293,  293,  293,  293,  293,  293,
 /*   230 */  1315, 1376,  464,  464, 1256, 1360, 1385,  333, 1277, 1397,
 /*   240 */   333, 1315, 1312, 1312,  464, 1221, 1225,  464, 1221, 1225,
 /*   250 */   464,  464,  293, 1230, 1314, 1221, 1238, 1253, 1265, 1066,
 /*   260 */  1247, 1255, 1260, 1286,  417, 1509, 1315, 1399,  333,  333,
 /*   270 */  1518, 1225,  464,  464,  464,  464,  464, 1225,  464, 1391,
 /*   280 */   333,  393,  333,  417, 1485, 1487,  464,  526, 1315,  333,
 /*   290 */  1552, 1376, 2883, 2883, 2883, 2883, 2883, 2883, 2883, 2883,
 /*   300 */  2883,  839,  385,  957,  612,  747,  635,  762,  553,  883,
 /*   310 */  1048,  955, 1124,  478,  478,  478,  478,  478,  478,  478,
 /*   320 */   478,  478,  864,  832,  295,  295,  320,  496,  952,  732,
 /*   330 */   351,  230,  473,  473,  805,  670,  475,  805,  805,  805,
 /*   340 */   749,  144,  336, 1185,  586, 1123, 1130, 1137, 1144, 1239,
 /*   350 */  1245, 1246, 1168, 1036, 1204, 1215,  590, 1054, 1043, 1003,
 /*   360 */  1222, 1227, 1231, 1249, 1254, 1264, 1180, 1283,  600, 1106,
 /*   370 */  1125, 1293, 1213, 1261, 1323, 1325, 1328, 1335, 1338, 1177,
 /*   380 */  1251, 1272, 1252, 1299, 1593, 1600, 1413, 1605, 1607, 1566,
 /*   390 */  1610, 1577, 1410, 1579, 1580, 1583, 1417, 1621, 1587, 1588,
 /*   400 */  1421, 1625, 1423, 1627, 1594, 1630, 1609, 1634, 1608, 1458,
 /*   410 */  1461, 1647, 1649, 1471, 1473, 1653, 1654, 1612, 1655, 1656,
 /*   420 */  1657, 1618, 1661, 1662, 1664, 1666, 1667, 1668, 1669, 1670,
 /*   430 */  1519, 1637, 1673, 1522, 1678, 1688, 1690, 1691, 1693, 1695,
 /*   440 */  1705, 1707, 1708, 1709, 1710, 1711, 1712, 1714, 1715, 1716,
 /*   450 */  1638, 1681, 1717, 1719, 1720, 1721, 1722, 1675, 1698, 1723,
 /*   460 */  1724, 1590, 1727, 1728, 1729, 1672, 1696, 1732, 1679, 1736,
 /*   470 */  1684, 1739, 1743, 1702, 1706, 1703, 1699, 1734, 1704, 1735,
 /*   480 */  1713, 1750, 1718, 1725, 1752, 1753, 1754, 1726, 1581, 1755,
 /*   490 */  1759, 1761, 1701, 1762, 1763, 1733, 1738, 1730, 1770, 1747,
 /*   500 */  1741, 1744, 1773, 1749, 1742, 1756, 1791, 1757, 1745, 1760,
 /*   510 */  1794, 1797, 1798, 1800, 1700, 1740, 1767, 1782, 1806, 1772,
 /*   520 */  1774, 1776, 1777, 1764, 1766, 1778, 1784, 1795, 1785, 1827,
 /*   530 */  1807, 1832, 1811, 1786, 1835, 1823, 1812, 1848, 1814, 1850,
 /*   540 */  1817, 1853, 1833, 1836, 1825, 1828, 1671, 1769, 1768, 1857,
 /*   550 */  1771, 1834, 1858, 1685, 1846, 1779, 1765, 1871, 1873, 1780,
 /*   560 */  1737, 1876, 1830, 1629, 1787, 1781, 1788, 1731, 1646, 1751,
 /*   570 */  1626, 1789, 1838, 1790, 1793, 1805, 1809, 1796, 1841, 1859,
 /*   580 */  1862, 1821, 1875, 1643, 1824, 1829, 1921, 1881, 1677, 1894,
 /*   590 */  1896, 1898, 1899, 1904, 1905, 1844, 1845, 1900, 1783, 1906,
 /*   600 */  1901, 1949, 1952, 1954, 1955, 1860, 1918, 1699, 1911, 1863,
 /*   610 */  1864, 1866, 1869, 1870, 1792, 1874, 1967, 1930, 1813, 1885,
 /*   620 */  1877, 1699, 1935, 1933, 1799, 1801, 1802, 1983, 1964, 1803,
 /*   630 */  1902, 1903, 1907, 1910, 1909, 1913, 1948, 1915, 1917, 1950,
 /*   640 */  1919, 1974, 1804, 1922, 1892, 1920, 1969, 1979, 1923, 1924,
 /*   650 */  1985, 1926, 1927, 1988, 1929, 1934, 1992, 1938, 1939, 1995,
 /*   660 */  1941, 1882, 1931, 1932, 1940, 2016, 1942, 1945, 2012, 1958,
 /*   670 */  2023, 1963, 2012, 2012, 2039, 1997, 1999, 2029, 2031, 2032,
 /*   680 */  2033, 2034, 2036, 2038, 2040, 2041, 2042, 2003, 1986, 2037,
 /*   690 */  2043, 2045, 2048, 2062, 2050, 2053, 2060, 2026, 1764, 2063,
 /*   700 */  1766, 2065, 2066, 2067, 2070, 2090, 2079, 2115, 2081, 2069,
 /*   710 */  2080, 2120, 2086, 2074, 2084, 2124, 2092, 2077, 2089, 2129,
 /*   720 */  2095, 2088, 2093, 2134, 2102, 2103, 2139, 2118, 2121, 2119,
 /*   730 */  2122, 2125, 2127,
};
#define YY_REDUCE_COUNT (300)
#define YY_REDUCE_MIN   (-432)
#define YY_REDUCE_MAX   (2466)
static const short yy_reduce_ofst[] = {
 /*     0 */  -252, -300,   -8,  197,  326,  605,  679,  750,  797,  868,
 /*    10 */   943, 1000,   61, 1074, 1138, 1162, 1226, 1273, 1290, 1365,
 /*    20 */  1412, 1428, 1486, 1502, 1562, 1578, 1633, 1680, 1697, 1758,
 /*    30 */  1775, 1822, 1847, 1908, 1936, 1994, 2010, 2073, 2105, 2152,
 /*    40 */  2168, 2223, 2282, 2312, 2340, 2370, 2434, 2466, -281, -335,
 /*    50 */    14, -293,  -86,  267,  377,  803,  131,  700, -354, -328,
 /*    60 */   203, -336,  604, -432,  -80, -351, -265, -236, -375, -331,
 /*    70 */  -270, -299, -365, -181, -100,   44,   80,  101,  128,  192,
 /*    80 */   340,  366, -189,  685,  704, -276,   -6,  707,  708,  -45,
 /*    90 */   729,  170,  733,   46,  771,  212, -175,  816,  818,  353,
 /*   100 */   714,  304,  381,  534,  853,  278, -282, -407, -407,  241,
 /*   110 */  -290,  239,  456,  460,  520,  531,  560,  629,  630,  676,
 /*   120 */   696,  701,  738,  748,  754,  757,  819,  821,  825,  829,
 /*   130 */  -200, -177,  -99, -344,  -19, -209, -177,  310,  427,  370,
 /*   140 */   268,  618,  541,  253,  622,  667,  509,  677,  185,  739,
 /*   150 */   354,  806,  810,  840,  755, -360, -350,  291,  397,  412,
 /*   160 */   453,  481,  243,  284,  613,  591,  568,  753,  880,  785,
 /*   170 */   889,  889,  930,  893,  954,  916,  911,  867,  867,  850,
 /*   180 */   867,  885,  870,  889,  913,  917,  937,  956,  964,  970,
 /*   190 */   999, 1041, 1044, 1004, 1005, 1007, 1049, 1042, 1056, 1057,
 /*   200 */  1058, 1073, 1076, 1010, 1072, 1055, 1075, 1086, 1038, 1090,
 /*   210 */  1091, 1093, 1094, 1096, 1103, 1100, 1105, 1108, 1115, 1095,
 /*   220 */  1097, 1098, 1099, 1101, 1102, 1104, 1109, 1110, 1111, 1112,
 /*   230 */  1113, 1120, 1079, 1080, 1059, 1063, 1067, 1127, 1078, 1107,
 /*   240 */  1132, 1140, 1117, 1121, 1119, 1034, 1122, 1126, 1050, 1128,
 /*   250 */  1134, 1135,  889, 1046, 1065, 1060, 1052, 1077, 1081, 1114,
 /*   260 */  1061, 1068, 1064,  867, 1160, 1131, 1197, 1198, 1200, 1201,
 /*   270 */  1157, 1158, 1172, 1183, 1184, 1186, 1187, 1165, 1189, 1178,
 /*   280 */  1228, 1211, 1229, 1214, 1159, 1220, 1216, 1237, 1258, 1250,
 /*   290 */  1266, 1259, 1202, 1193, 1207, 1217, 1257, 1262, 1263, 1267,
 /*   300 */  1276,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*    10 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*    20 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*    30 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*    40 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*    50 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*    60 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*    70 */  1638, 1896, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*    80 */  1638, 1638, 1638, 1638, 1638, 1717, 1638, 1638, 1638, 1638,
 /*    90 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   100 */  1638, 1638, 1638, 1638, 1638, 1715, 1889, 2098, 1638, 1638,
 /*   110 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   120 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   130 */  1638, 2110, 1638, 1638, 1717, 1638, 2110, 2110, 2110, 1715,
 /*   140 */  2070, 2070, 1638, 1638, 1638, 1638, 1824, 1638, 1638, 1638,
 /*   150 */  1638, 1638, 1638, 1824, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   160 */  1638, 1638, 1941, 1638, 1638, 2135, 2189, 1638, 1638, 2138,
 /*   170 */  1638, 1638, 1638, 1901, 1638, 1777, 2125, 2102, 2116, 2173,
 /*   180 */  2103, 2100, 2119, 1638, 2129, 1638, 1934, 1894, 1638, 1894,
 /*   190 */  1891, 1638, 1638, 1894, 1891, 1891, 1638, 1768, 1638, 1638,
 /*   200 */  1638, 1638, 1638, 1638, 1717, 1638, 1717, 1638, 1638, 1717,
 /*   210 */  1638, 1717, 1717, 1717, 1638, 1717, 1695, 1695, 1638, 1638,
 /*   220 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   230 */  1638, 1638, 1638, 1638, 1956, 1947, 1638, 1715, 1943, 1638,
 /*   240 */  1715, 1638, 1638, 1638, 1638, 2146, 2144, 1638, 2146, 2144,
 /*   250 */  1638, 1638, 1638, 2158, 2154, 2146, 2162, 2160, 2131, 2129,
 /*   260 */  2192, 2179, 2175, 2116, 1638, 1638, 1638, 1638, 1715, 1715,
 /*   270 */  1638, 2144, 1638, 1638, 1638, 1638, 1638, 2144, 1638, 1638,
 /*   280 */  1715, 1638, 1715, 1638, 1638, 1793, 1638, 1638, 1638, 1715,
 /*   290 */  1670, 1638, 1936, 1949, 1919, 1919, 1827, 1827, 1827, 1718,
 /*   300 */  1643, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   310 */  1638, 1638, 1638, 2157, 2156, 2025, 1638, 2074, 2073, 2072,
 /*   320 */  2063, 2024, 1789, 1638, 2023, 2022, 1638, 1638, 1638, 1638,
 /*   330 */  1638, 1638, 1910, 1909, 2016, 1638, 1638, 2017, 2015, 2014,
 /*   340 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   350 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 2176, 2180, 1638,
 /*   360 */  1638, 1638, 1638, 1638, 1638, 1638, 2099, 1638, 1638, 1638,
 /*   370 */  1638, 1638, 1998, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   380 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   390 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   400 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   410 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   420 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   430 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   440 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   450 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   460 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   470 */  1638, 1638, 1638, 1638, 1638, 1675, 2003, 1638, 1638, 1638,
 /*   480 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   490 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   500 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   510 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   520 */  1638, 1638, 1638, 1756, 1755, 1638, 1638, 1638, 1638, 1638,
 /*   530 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   540 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 2007, 1638, 1638,
 /*   550 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   560 */  1638, 2172, 2132, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   570 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   580 */  1998, 1638, 2155, 1638, 1638, 2170, 1638, 2174, 1638, 1638,
 /*   590 */  1638, 1638, 1638, 1638, 1638, 2109, 2105, 1638, 1638, 2101,
 /*   600 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 2006, 1638, 1638,
 /*   610 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   620 */  1638, 1997, 1638, 2060, 1638, 1638, 1638, 2094, 1638, 1638,
 /*   630 */  2045, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   640 */  2007, 1638, 2010, 1638, 1638, 1638, 1638, 1638, 1821, 1638,
 /*   650 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   660 */  1638, 1806, 1804, 1803, 1802, 1638, 1799, 1638, 1834, 1638,
 /*   670 */  1638, 1638, 1830, 1829, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   680 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1736,
 /*   690 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1728, 1638,
 /*   700 */  1727, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   710 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   720 */  1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638, 1638,
 /*   730 */  1638, 1638, 1638,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
  273,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*      START => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  273,  /*      AFTER => ABORT */
  273,  /*     ATTACH => ABORT */
  273,  /*     BEFORE => ABORT */
  273,  /*      BEGIN => ABORT */
  273,  /*     BITAND => ABORT */
  273,  /*     BITNOT => ABORT */
  273,  /*      BITOR => ABORT */
  273,  /*     BLOCKS => ABORT */
  273,  /*     CHANGE => ABORT */
  273,  /*      COMMA => ABORT */
  273,  /*     CONCAT => ABORT */
  273,  /*   CONFLICT => ABORT */
  273,  /*       COPY => ABORT */
  273,  /*   DEFERRED => ABORT */
  273,  /* DELIMITERS => ABORT */
  273,  /*     DETACH => ABORT */
  273,  /*     DIVIDE => ABORT */
  273,  /*        DOT => ABORT */
  273,  /*       EACH => ABORT */
  273,  /*       FAIL => ABORT */
  273,  /*       FILE => ABORT */
  273,  /*        FOR => ABORT */
  273,  /*       GLOB => ABORT */
  273,  /*         ID => ABORT */
  273,  /*  IMMEDIATE => ABORT */
  273,  /*     IMPORT => ABORT */
  273,  /*  INITIALLY => ABORT */
  273,  /*    INSTEAD => ABORT */
  273,  /*     ISNULL => ABORT */
  273,  /*        KEY => ABORT */
  273,  /*    MODULES => ABORT */
  273,  /*  NK_BITNOT => ABORT */
  273,  /*    NK_SEMI => ABORT */
  273,  /*    NOTNULL => ABORT */
  273,  /*         OF => ABORT */
  273,  /*       PLUS => ABORT */
  273,  /*  PRIVILEGE => ABORT */
  273,  /*      RAISE => ABORT */
  273,  /*    REPLACE => ABORT */
  273,  /*   RESTRICT => ABORT */
  273,  /*        ROW => ABORT */
  273,  /*       SEMI => ABORT */
  273,  /*       STAR => ABORT */
  273,  /*  STATEMENT => ABORT */
  273,  /*     STRICT => ABORT */
  273,  /*     STRING => ABORT */
  273,  /*      TIMES => ABORT */
  273,  /*     UPDATE => ABORT */
  273,  /*     VALUES => ABORT */
  273,  /*   VARIABLE => ABORT */
  273,  /*       VIEW => ABORT */
  273,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "COMPACT",
  /*   63 */ "IF",
  /*   64 */ "NOT",
  /*   65 */ "EXISTS",
  /*   66 */ "BUFFER",
  /*   67 */ "CACHEMODEL",
  /*   68 */ "CACHESIZE",
  /*   69 */ "COMP",
  /*   70 */ "DURATION",
  /*   71 */ "NK_VARIABLE",
  /*   72 */ "MAXROWS",
  /*   73 */ "MINROWS",
  /*   74 */ "KEEP",
  /*   75 */ "PAGES",
  /*   76 */ "PAGESIZE",
  /*   77 */ "TSDB_PAGESIZE",
  /*   78 */ "PRECISION",
  /*   79 */ "REPLICA",
  /*   80 */ "VGROUPS",
  /*   81 */ "SINGLE_STABLE",
  /*   82 */ "RETENTIONS",
  /*   83 */ "SCHEMALESS",
  /*   84 */ "WAL_LEVEL",
  /*   85 */ "WAL_FSYNC_PERIOD",
  /*   86 */ "WAL_RETENTION_PERIOD",
  /*   87 */ "WAL_RETENTION_SIZE",
  /*   88 */ "WAL_ROLL_PERIOD",
  /*   89 */ "WAL_SEGMENT_SIZE",
  /*   90 */ "STT_TRIGGER",
  /*   91 */ "TABLE_PREFIX",
  /*   92 */ "TABLE_SUFFIX",
  /*   93 */ "NK_COLON",
  /*   94 */ "MAX_SPEED",
  /*   95 */ "TABLE",
  /*   96 */ "NK_LP",
  /*   97 */ "NK_RP",
  /*   98 */ "STABLE",
  /*   99 */ "ADD",
  /*  100 */ "COLUMN",
  /*  101 */ "MODIFY",
  /*  102 */ "RENAME",
  /*  103 */ "TAG",
  /*  104 */ "SET",
  /*  105 */ "NK_EQ",
  /*  106 */ "USING",
  /*  107 */ "TAGS",
  /*  108 */ "COMMENT",
  /*  109 */ "BOOL",
  /*  110 */ "TINYINT",
  /*  111 */ "SMALLINT",
  /*  112 */ "INT",
  /*  113 */ "INTEGER",
  /*  114 */ "BIGINT",
  /*  115 */ "FLOAT",
  /*  116 */ "DOUBLE",
  /*  117 */ "BINARY",
  /*  118 */ "TIMESTAMP",
  /*  119 */ "NCHAR",
  /*  120 */ "UNSIGNED",
  /*  121 */ "JSON",
  /*  122 */ "VARCHAR",
  /*  123 */ "MEDIUMBLOB",
  /*  124 */ "BLOB",
  /*  125 */ "VARBINARY",
  /*  126 */ "DECIMAL",
  /*  127 */ "MAX_DELAY",
  /*  128 */ "WATERMARK",
  /*  129 */ "ROLLUP",
  /*  130 */ "TTL",
  /*  131 */ "SMA",
  /*  132 */ "DELETE_MARK",
  /*  133 */ "FIRST",
  /*  134 */ "LAST",
  /*  135 */ "SHOW",
  /*  136 */ "PRIVILEGES",
  /*  137 */ "DATABASES",
  /*  138 */ "TABLES",
  /*  139 */ "STABLES",
  /*  140 */ "MNODES",
  /*  141 */ "QNODES",
  /*  142 */ "FUNCTIONS",
  /*  143 */ "INDEXES",
  /*  144 */ "ACCOUNTS",
  /*  145 */ "APPS",
  /*  146 */ "CONNECTIONS",
  /*  147 */ "LICENCES",
  /*  148 */ "GRANTS",
  /*  149 */ "QUERIES",
  /*  150 */ "SCORES",
  /*  151 */ "TOPICS",
  /*  152 */ "VARIABLES",
  /*  153 */ "CLUSTER",
  /*  154 */ "BNODES",
  /*  155 */ "SNODES",
  /*  156 */ "TRANSACTIONS",
  /*  157 */ "DISTRIBUTED",
  /*  158 */ "CONSUMERS",
  /*  159 */ "SUBSCRIPTIONS",
  /*  160 */ "VNODES",
  /*  161 */ "ALIVE",
  /*  162 */ "LIKE",
  /*  163 */ "TBNAME",
  /*  164 */ "QTAGS",
  /*  165 */ "AS",
  /*  166 */ "INDEX",
  /*  167 */ "FUNCTION",
  /*  168 */ "INTERVAL",
  /*  169 */ "COUNT",
  /*  170 */ "LAST_ROW",
  /*  171 */ "TOPIC",
  /*  172 */ "WITH",
  /*  173 */ "META",
  /*  174 */ "CONSUMER",
  /*  175 */ "GROUP",
  /*  176 */ "DESC",
  /*  177 */ "DESCRIBE",
  /*  178 */ "RESET",
  /*  179 */ "QUERY",
  /*  180 */ "CACHE",
  /*  181 */ "EXPLAIN",
  /*  182 */ "ANALYZE",
  /*  183 */ "VERBOSE",
  /*  184 */ "NK_BOOL",
  /*  185 */ "RATIO",
  /*  186 */ "NK_FLOAT",
  /*  187 */ "OUTPUTTYPE",
  /*  188 */ "AGGREGATE",
  /*  189 */ "BUFSIZE",
  /*  190 */ "STREAM",
  /*  191 */ "INTO",
  /*  192 */ "TRIGGER",
  /*  193 */ "AT_ONCE",
  /*  194 */ "WINDOW_CLOSE",
  /*  195 */ "IGNORE",
  /*  196 */ "EXPIRED",
  /*  197 */ "FILL_HISTORY",
  /*  198 */ "SUBTABLE",
  /*  199 */ "KILL",
  /*  200 */ "CONNECTION",
  /*  201 */ "TRANSACTION",
  /*  202 */ "BALANCE",
  /*  203 */ "VGROUP",
  /*  204 */ "MERGE",
  /*  205 */ "REDISTRIBUTE",
  /*  206 */ "SPLIT",
  /*  207 */ "DELETE",
  /*  208 */ "INSERT",
  /*  209 */ "NULL",
  /*  210 */ "NK_QUESTION",
  /*  211 */ "NK_ARROW",
  /*  212 */ "ROWTS",
  /*  213 */ "QSTART",
  /*  214 */ "QEND",
  /*  215 */ "QDURATION",
  /*  216 */ "WSTART",
  /*  217 */ "WEND",
  /*  218 */ "WDURATION",
  /*  219 */ "IROWTS",
  /*  220 */ "ISFILLED",
  /*  221 */ "CAST",
  /*  222 */ "NOW",
  /*  223 */ "TODAY",
  /*  224 */ "TIMEZONE",
  /*  225 */ "CLIENT_VERSION",
  /*  226 */ "SERVER_VERSION",
  /*  227 */ "SERVER_STATUS",
  /*  228 */ "CURRENT_USER",
  /*  229 */ "CASE",
  /*  230 */ "END",
  /*  231 */ "WHEN",
  /*  232 */ "THEN",
  /*  233 */ "ELSE",
  /*  234 */ "BETWEEN",
  /*  235 */ "IS",
  /*  236 */ "NK_LT",
  /*  237 */ "NK_GT",
  /*  238 */ "NK_LE",
  /*  239 */ "NK_GE",
  /*  240 */ "NK_NE",
  /*  241 */ "MATCH",
  /*  242 */ "NMATCH",
  /*  243 */ "CONTAINS",
  /*  244 */ "IN",
  /*  245 */ "JOIN",
  /*  246 */ "INNER",
  /*  247 */ "SELECT",
  /*  248 */ "DISTINCT",
  /*  249 */ "WHERE",
  /*  250 */ "PARTITION",
  /*  251 */ "BY",
  /*  252 */ "SESSION",
  /*  253 */ "STATE_WINDOW",
  /*  254 */ "EVENT_WINDOW",
  /*  255 */ "START",
  /*  256 */ "SLIDING",
  /*  257 */ "FILL",
  /*  258 */ "VALUE",
  /*  259 */ "NONE",
  /*  260 */ "PREV",
  /*  261 */ "LINEAR",
  /*  262 */ "NEXT",
  /*  263 */ "HAVING",
  /*  264 */ "RANGE",
  /*  265 */ "EVERY",
  /*  266 */ "ORDER",
  /*  267 */ "SLIMIT",
  /*  268 */ "SOFFSET",
  /*  269 */ "LIMIT",
  /*  270 */ "OFFSET",
  /*  271 */ "ASC",
  /*  272 */ "NULLS",
  /*  273 */ "ABORT",
  /*  274 */ "AFTER",
  /*  275 */ "ATTACH",
  /*  276 */ "BEFORE",
  /*  277 */ "BEGIN",
  /*  278 */ "BITAND",
  /*  279 */ "BITNOT",
  /*  280 */ "BITOR",
  /*  281 */ "BLOCKS",
  /*  282 */ "CHANGE",
  /*  283 */ "COMMA",
  /*  284 */ "CONCAT",
  /*  285 */ "CONFLICT",
  /*  286 */ "COPY",
  /*  287 */ "DEFERRED",
  /*  288 */ "DELIMITERS",
  /*  289 */ "DETACH",
  /*  290 */ "DIVIDE",
  /*  291 */ "DOT",
  /*  292 */ "EACH",
  /*  293 */ "FAIL",
  /*  294 */ "FILE",
  /*  295 */ "FOR",
  /*  296 */ "GLOB",
  /*  297 */ "ID",
  /*  298 */ "IMMEDIATE",
  /*  299 */ "IMPORT",
  /*  300 */ "INITIALLY",
  /*  301 */ "INSTEAD",
  /*  302 */ "ISNULL",
  /*  303 */ "KEY",
  /*  304 */ "MODULES",
  /*  305 */ "NK_BITNOT",
  /*  306 */ "NK_SEMI",
  /*  307 */ "NOTNULL",
  /*  308 */ "OF",
  /*  309 */ "PLUS",
  /*  310 */ "PRIVILEGE",
  /*  311 */ "RAISE",
  /*  312 */ "REPLACE",
  /*  313 */ "RESTRICT",
  /*  314 */ "ROW",
  /*  315 */ "SEMI",
  /*  316 */ "STAR",
  /*  317 */ "STATEMENT",
  /*  318 */ "STRICT",
  /*  319 */ "STRING",
  /*  320 */ "TIMES",
  /*  321 */ "UPDATE",
  /*  322 */ "VALUES",
  /*  323 */ "VARIABLE",
  /*  324 */ "VIEW",
  /*  325 */ "WAL",
  /*  326 */ "cmd",
  /*  327 */ "account_options",
  /*  328 */ "alter_account_options",
  /*  329 */ "literal",
  /*  330 */ "alter_account_option",
  /*  331 */ "user_name",
  /*  332 */ "sysinfo_opt",
  /*  333 */ "privileges",
  /*  334 */ "priv_level",
  /*  335 */ "priv_type_list",
  /*  336 */ "priv_type",
  /*  337 */ "db_name",
  /*  338 */ "topic_name",
  /*  339 */ "dnode_endpoint",
  /*  340 */ "force_opt",
  /*  341 */ "not_exists_opt",
  /*  342 */ "db_options",
  /*  343 */ "exists_opt",
  /*  344 */ "alter_db_options",
  /*  345 */ "speed_opt",
  /*  346 */ "integer_list",
  /*  347 */ "variable_list",
  /*  348 */ "retention_list",
  /*  349 */ "alter_db_option",
  /*  350 */ "retention",
  /*  351 */ "full_table_name",
  /*  352 */ "column_def_list",
  /*  353 */ "tags_def_opt",
  /*  354 */ "table_options",
  /*  355 */ "multi_create_clause",
  /*  356 */ "tags_def",
  /*  357 */ "multi_drop_clause",
  /*  358 */ "alter_table_clause",
  /*  359 */ "alter_table_options",
  /*  360 */ "column_name",
  /*  361 */ "type_name",
  /*  362 */ "signed_literal",
  /*  363 */ "create_subtable_clause",
  /*  364 */ "specific_cols_opt",
  /*  365 */ "expression_list",
  /*  366 */ "drop_table_clause",
  /*  367 */ "col_name_list",
  /*  368 */ "table_name",
  /*  369 */ "column_def",
  /*  370 */ "duration_list",
  /*  371 */ "rollup_func_list",
  /*  372 */ "alter_table_option",
  /*  373 */ "duration_literal",
  /*  374 */ "rollup_func_name",
  /*  375 */ "function_name",
  /*  376 */ "col_name",
  /*  377 */ "db_name_cond_opt",
  /*  378 */ "like_pattern_opt",
  /*  379 */ "table_name_cond",
  /*  380 */ "from_db_opt",
  /*  381 */ "tag_list_opt",
  /*  382 */ "tag_item",
  /*  383 */ "column_alias",
  /*  384 */ "full_index_name",
  /*  385 */ "index_options",
  /*  386 */ "index_name",
  /*  387 */ "func_list",
  /*  388 */ "sliding_opt",
  /*  389 */ "sma_stream_opt",
  /*  390 */ "func",
  /*  391 */ "sma_func_name",
  /*  392 */ "query_or_subquery",
  /*  393 */ "cgroup_name",
  /*  394 */ "analyze_opt",
  /*  395 */ "explain_options",
  /*  396 */ "agg_func_opt",
  /*  397 */ "bufsize_opt",
  /*  398 */ "stream_name",
  /*  399 */ "stream_options",
  /*  400 */ "col_list_opt",
  /*  401 */ "subtable_opt",
  /*  402 */ "expression",
  /*  403 */ "dnode_list",
  /*  404 */ "where_clause_opt",
  /*  405 */ "signed",
  /*  406 */ "literal_func",
  /*  407 */ "literal_list",
  /*  408 */ "table_alias",
  /*  409 */ "expr_or_subquery",
  /*  410 */ "pseudo_column",
  /*  411 */ "column_reference",
  /*  412 */ "function_expression",
  /*  413 */ "case_when_expression",
  /*  414 */ "star_func",
  /*  415 */ "star_func_para_list",
  /*  416 */ "noarg_func",
  /*  417 */ "other_para_list",
  /*  418 */ "star_func_para",
  /*  419 */ "when_then_list",
  /*  420 */ "case_when_else_opt",
  /*  421 */ "common_expression",
  /*  422 */ "when_then_expr",
  /*  423 */ "predicate",
  /*  424 */ "compare_op",
  /*  425 */ "in_op",
  /*  426 */ "in_predicate_value",
  /*  427 */ "boolean_value_expression",
  /*  428 */ "boolean_primary",
  /*  429 */ "from_clause_opt",
  /*  430 */ "table_reference_list",
  /*  431 */ "table_reference",
  /*  432 */ "table_primary",
  /*  433 */ "joined_table",
  /*  434 */ "alias_opt",
  /*  435 */ "subquery",
  /*  436 */ "parenthesized_joined_table",
  /*  437 */ "join_type",
  /*  438 */ "search_condition",
  /*  439 */ "query_specification",
  /*  440 */ "set_quantifier_opt",
  /*  441 */ "select_list",
  /*  442 */ "partition_by_clause_opt",
  /*  443 */ "range_opt",
  /*  444 */ "every_opt",
  /*  445 */ "fill_opt",
  /*  446 */ "twindow_clause_opt",
  /*  447 */ "group_by_clause_opt",
  /*  448 */ "having_clause_opt",
  /*  449 */ "select_item",
  /*  450 */ "partition_list",
  /*  451 */ "partition_item",
  /*  452 */ "fill_mode",
  /*  453 */ "group_by_list",
  /*  454 */ "query_expression",
  /*  455 */ "query_simple",
  /*  456 */ "order_by_clause_opt",
  /*  457 */ "slimit_clause_opt",
  /*  458 */ "limit_clause_opt",
  /*  459 */ "union_query_expression",
  /*  460 */ "query_simple_or_subquery",
  /*  461 */ "sort_specification_list",
  /*  462 */ "sort_specification",
  /*  463 */ "ordering_specification_opt",
  /*  464 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "cmd ::= COMPACT DATABASE db_name",
 /*  73 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  74 */ "not_exists_opt ::=",
 /*  75 */ "exists_opt ::= IF EXISTS",
 /*  76 */ "exists_opt ::=",
 /*  77 */ "db_options ::=",
 /*  78 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  79 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  80 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  81 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  83 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  84 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  86 */ "db_options ::= db_options KEEP integer_list",
 /*  87 */ "db_options ::= db_options KEEP variable_list",
 /*  88 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  89 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  91 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  92 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  93 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  94 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  95 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  96 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 107 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 108 */ "alter_db_options ::= alter_db_option",
 /* 109 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 110 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 111 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 112 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 113 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 114 */ "alter_db_option ::= KEEP integer_list",
 /* 115 */ "alter_db_option ::= KEEP variable_list",
 /* 116 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 117 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 118 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 119 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 120 */ "integer_list ::= NK_INTEGER",
 /* 121 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 122 */ "variable_list ::= NK_VARIABLE",
 /* 123 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 124 */ "retention_list ::= retention",
 /* 125 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 126 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 127 */ "speed_opt ::=",
 /* 128 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 129 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 130 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 131 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 132 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 133 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 134 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 135 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 136 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 137 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 138 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 139 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 140 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 141 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 142 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 143 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 144 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 145 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 146 */ "multi_create_clause ::= create_subtable_clause",
 /* 147 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 148 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 149 */ "multi_drop_clause ::= drop_table_clause",
 /* 150 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 151 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 152 */ "specific_cols_opt ::=",
 /* 153 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 154 */ "full_table_name ::= table_name",
 /* 155 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 156 */ "column_def_list ::= column_def",
 /* 157 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 158 */ "column_def ::= column_name type_name",
 /* 159 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 160 */ "type_name ::= BOOL",
 /* 161 */ "type_name ::= TINYINT",
 /* 162 */ "type_name ::= SMALLINT",
 /* 163 */ "type_name ::= INT",
 /* 164 */ "type_name ::= INTEGER",
 /* 165 */ "type_name ::= BIGINT",
 /* 166 */ "type_name ::= FLOAT",
 /* 167 */ "type_name ::= DOUBLE",
 /* 168 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 169 */ "type_name ::= TIMESTAMP",
 /* 170 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 171 */ "type_name ::= TINYINT UNSIGNED",
 /* 172 */ "type_name ::= SMALLINT UNSIGNED",
 /* 173 */ "type_name ::= INT UNSIGNED",
 /* 174 */ "type_name ::= BIGINT UNSIGNED",
 /* 175 */ "type_name ::= JSON",
 /* 176 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 177 */ "type_name ::= MEDIUMBLOB",
 /* 178 */ "type_name ::= BLOB",
 /* 179 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 180 */ "type_name ::= DECIMAL",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 182 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 183 */ "tags_def_opt ::=",
 /* 184 */ "tags_def_opt ::= tags_def",
 /* 185 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 186 */ "table_options ::=",
 /* 187 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 188 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 189 */ "table_options ::= table_options WATERMARK duration_list",
 /* 190 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 191 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 192 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 193 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 194 */ "alter_table_options ::= alter_table_option",
 /* 195 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 196 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 197 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 198 */ "duration_list ::= duration_literal",
 /* 199 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 200 */ "rollup_func_list ::= rollup_func_name",
 /* 201 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 202 */ "rollup_func_name ::= function_name",
 /* 203 */ "rollup_func_name ::= FIRST",
 /* 204 */ "rollup_func_name ::= LAST",
 /* 205 */ "col_name_list ::= col_name",
 /* 206 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 207 */ "col_name ::= column_name",
 /* 208 */ "cmd ::= SHOW DNODES",
 /* 209 */ "cmd ::= SHOW USERS",
 /* 210 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 211 */ "cmd ::= SHOW DATABASES",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 214 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 215 */ "cmd ::= SHOW MNODES",
 /* 216 */ "cmd ::= SHOW QNODES",
 /* 217 */ "cmd ::= SHOW FUNCTIONS",
 /* 218 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 219 */ "cmd ::= SHOW STREAMS",
 /* 220 */ "cmd ::= SHOW ACCOUNTS",
 /* 221 */ "cmd ::= SHOW APPS",
 /* 222 */ "cmd ::= SHOW CONNECTIONS",
 /* 223 */ "cmd ::= SHOW LICENCES",
 /* 224 */ "cmd ::= SHOW GRANTS",
 /* 225 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 226 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 227 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 228 */ "cmd ::= SHOW QUERIES",
 /* 229 */ "cmd ::= SHOW SCORES",
 /* 230 */ "cmd ::= SHOW TOPICS",
 /* 231 */ "cmd ::= SHOW VARIABLES",
 /* 232 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 233 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 234 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 235 */ "cmd ::= SHOW BNODES",
 /* 236 */ "cmd ::= SHOW SNODES",
 /* 237 */ "cmd ::= SHOW CLUSTER",
 /* 238 */ "cmd ::= SHOW TRANSACTIONS",
 /* 239 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 240 */ "cmd ::= SHOW CONSUMERS",
 /* 241 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 242 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 244 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 245 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 246 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 247 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 248 */ "db_name_cond_opt ::=",
 /* 249 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 250 */ "like_pattern_opt ::=",
 /* 251 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 252 */ "table_name_cond ::= table_name",
 /* 253 */ "from_db_opt ::=",
 /* 254 */ "from_db_opt ::= FROM db_name",
 /* 255 */ "tag_list_opt ::=",
 /* 256 */ "tag_list_opt ::= tag_item",
 /* 257 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 258 */ "tag_item ::= TBNAME",
 /* 259 */ "tag_item ::= QTAGS",
 /* 260 */ "tag_item ::= column_name",
 /* 261 */ "tag_item ::= column_name column_alias",
 /* 262 */ "tag_item ::= column_name AS column_alias",
 /* 263 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 264 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 265 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 266 */ "full_index_name ::= index_name",
 /* 267 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 268 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 269 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 270 */ "func_list ::= func",
 /* 271 */ "func_list ::= func_list NK_COMMA func",
 /* 272 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 273 */ "sma_func_name ::= function_name",
 /* 274 */ "sma_func_name ::= COUNT",
 /* 275 */ "sma_func_name ::= FIRST",
 /* 276 */ "sma_func_name ::= LAST",
 /* 277 */ "sma_func_name ::= LAST_ROW",
 /* 278 */ "sma_stream_opt ::=",
 /* 279 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 280 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 281 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 282 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 283 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 284 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 285 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 286 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 287 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 288 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 289 */ "cmd ::= DESC full_table_name",
 /* 290 */ "cmd ::= DESCRIBE full_table_name",
 /* 291 */ "cmd ::= RESET QUERY CACHE",
 /* 292 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 293 */ "analyze_opt ::=",
 /* 294 */ "analyze_opt ::= ANALYZE",
 /* 295 */ "explain_options ::=",
 /* 296 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 297 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 298 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 299 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 300 */ "agg_func_opt ::=",
 /* 301 */ "agg_func_opt ::= AGGREGATE",
 /* 302 */ "bufsize_opt ::=",
 /* 303 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 304 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tags_def_opt subtable_opt AS query_or_subquery",
 /* 305 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 306 */ "col_list_opt ::=",
 /* 307 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 308 */ "stream_options ::=",
 /* 309 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 310 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 311 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 312 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 313 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 314 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 315 */ "subtable_opt ::=",
 /* 316 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 317 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 318 */ "cmd ::= KILL QUERY NK_STRING",
 /* 319 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 320 */ "cmd ::= BALANCE VGROUP",
 /* 321 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 322 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 323 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 324 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 325 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 326 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 327 */ "cmd ::= query_or_subquery",
 /* 328 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 329 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 330 */ "literal ::= NK_INTEGER",
 /* 331 */ "literal ::= NK_FLOAT",
 /* 332 */ "literal ::= NK_STRING",
 /* 333 */ "literal ::= NK_BOOL",
 /* 334 */ "literal ::= TIMESTAMP NK_STRING",
 /* 335 */ "literal ::= duration_literal",
 /* 336 */ "literal ::= NULL",
 /* 337 */ "literal ::= NK_QUESTION",
 /* 338 */ "duration_literal ::= NK_VARIABLE",
 /* 339 */ "signed ::= NK_INTEGER",
 /* 340 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 341 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 342 */ "signed ::= NK_FLOAT",
 /* 343 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 344 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 345 */ "signed_literal ::= signed",
 /* 346 */ "signed_literal ::= NK_STRING",
 /* 347 */ "signed_literal ::= NK_BOOL",
 /* 348 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 349 */ "signed_literal ::= duration_literal",
 /* 350 */ "signed_literal ::= NULL",
 /* 351 */ "signed_literal ::= literal_func",
 /* 352 */ "signed_literal ::= NK_QUESTION",
 /* 353 */ "literal_list ::= signed_literal",
 /* 354 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 355 */ "db_name ::= NK_ID",
 /* 356 */ "table_name ::= NK_ID",
 /* 357 */ "column_name ::= NK_ID",
 /* 358 */ "function_name ::= NK_ID",
 /* 359 */ "table_alias ::= NK_ID",
 /* 360 */ "column_alias ::= NK_ID",
 /* 361 */ "user_name ::= NK_ID",
 /* 362 */ "topic_name ::= NK_ID",
 /* 363 */ "stream_name ::= NK_ID",
 /* 364 */ "cgroup_name ::= NK_ID",
 /* 365 */ "index_name ::= NK_ID",
 /* 366 */ "expr_or_subquery ::= expression",
 /* 367 */ "expression ::= literal",
 /* 368 */ "expression ::= pseudo_column",
 /* 369 */ "expression ::= column_reference",
 /* 370 */ "expression ::= function_expression",
 /* 371 */ "expression ::= case_when_expression",
 /* 372 */ "expression ::= NK_LP expression NK_RP",
 /* 373 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 374 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 375 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 376 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 377 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 378 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 379 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 380 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 381 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 382 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 383 */ "expression_list ::= expr_or_subquery",
 /* 384 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 385 */ "column_reference ::= column_name",
 /* 386 */ "column_reference ::= table_name NK_DOT column_name",
 /* 387 */ "pseudo_column ::= ROWTS",
 /* 388 */ "pseudo_column ::= TBNAME",
 /* 389 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 390 */ "pseudo_column ::= QSTART",
 /* 391 */ "pseudo_column ::= QEND",
 /* 392 */ "pseudo_column ::= QDURATION",
 /* 393 */ "pseudo_column ::= WSTART",
 /* 394 */ "pseudo_column ::= WEND",
 /* 395 */ "pseudo_column ::= WDURATION",
 /* 396 */ "pseudo_column ::= IROWTS",
 /* 397 */ "pseudo_column ::= ISFILLED",
 /* 398 */ "pseudo_column ::= QTAGS",
 /* 399 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 400 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 401 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 402 */ "function_expression ::= literal_func",
 /* 403 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 404 */ "literal_func ::= NOW",
 /* 405 */ "noarg_func ::= NOW",
 /* 406 */ "noarg_func ::= TODAY",
 /* 407 */ "noarg_func ::= TIMEZONE",
 /* 408 */ "noarg_func ::= DATABASE",
 /* 409 */ "noarg_func ::= CLIENT_VERSION",
 /* 410 */ "noarg_func ::= SERVER_VERSION",
 /* 411 */ "noarg_func ::= SERVER_STATUS",
 /* 412 */ "noarg_func ::= CURRENT_USER",
 /* 413 */ "noarg_func ::= USER",
 /* 414 */ "star_func ::= COUNT",
 /* 415 */ "star_func ::= FIRST",
 /* 416 */ "star_func ::= LAST",
 /* 417 */ "star_func ::= LAST_ROW",
 /* 418 */ "star_func_para_list ::= NK_STAR",
 /* 419 */ "star_func_para_list ::= other_para_list",
 /* 420 */ "other_para_list ::= star_func_para",
 /* 421 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 422 */ "star_func_para ::= expr_or_subquery",
 /* 423 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 424 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 425 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 426 */ "when_then_list ::= when_then_expr",
 /* 427 */ "when_then_list ::= when_then_list when_then_expr",
 /* 428 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 429 */ "case_when_else_opt ::=",
 /* 430 */ "case_when_else_opt ::= ELSE common_expression",
 /* 431 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 432 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 433 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 434 */ "predicate ::= expr_or_subquery IS NULL",
 /* 435 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 436 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 437 */ "compare_op ::= NK_LT",
 /* 438 */ "compare_op ::= NK_GT",
 /* 439 */ "compare_op ::= NK_LE",
 /* 440 */ "compare_op ::= NK_GE",
 /* 441 */ "compare_op ::= NK_NE",
 /* 442 */ "compare_op ::= NK_EQ",
 /* 443 */ "compare_op ::= LIKE",
 /* 444 */ "compare_op ::= NOT LIKE",
 /* 445 */ "compare_op ::= MATCH",
 /* 446 */ "compare_op ::= NMATCH",
 /* 447 */ "compare_op ::= CONTAINS",
 /* 448 */ "in_op ::= IN",
 /* 449 */ "in_op ::= NOT IN",
 /* 450 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 451 */ "boolean_value_expression ::= boolean_primary",
 /* 452 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 453 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 454 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 455 */ "boolean_primary ::= predicate",
 /* 456 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 457 */ "common_expression ::= expr_or_subquery",
 /* 458 */ "common_expression ::= boolean_value_expression",
 /* 459 */ "from_clause_opt ::=",
 /* 460 */ "from_clause_opt ::= FROM table_reference_list",
 /* 461 */ "table_reference_list ::= table_reference",
 /* 462 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 463 */ "table_reference ::= table_primary",
 /* 464 */ "table_reference ::= joined_table",
 /* 465 */ "table_primary ::= table_name alias_opt",
 /* 466 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 467 */ "table_primary ::= subquery alias_opt",
 /* 468 */ "table_primary ::= parenthesized_joined_table",
 /* 469 */ "alias_opt ::=",
 /* 470 */ "alias_opt ::= table_alias",
 /* 471 */ "alias_opt ::= AS table_alias",
 /* 472 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 473 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 474 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 475 */ "join_type ::=",
 /* 476 */ "join_type ::= INNER",
 /* 477 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 478 */ "set_quantifier_opt ::=",
 /* 479 */ "set_quantifier_opt ::= DISTINCT",
 /* 480 */ "set_quantifier_opt ::= ALL",
 /* 481 */ "select_list ::= select_item",
 /* 482 */ "select_list ::= select_list NK_COMMA select_item",
 /* 483 */ "select_item ::= NK_STAR",
 /* 484 */ "select_item ::= common_expression",
 /* 485 */ "select_item ::= common_expression column_alias",
 /* 486 */ "select_item ::= common_expression AS column_alias",
 /* 487 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 488 */ "where_clause_opt ::=",
 /* 489 */ "where_clause_opt ::= WHERE search_condition",
 /* 490 */ "partition_by_clause_opt ::=",
 /* 491 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 492 */ "partition_list ::= partition_item",
 /* 493 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 494 */ "partition_item ::= expr_or_subquery",
 /* 495 */ "partition_item ::= expr_or_subquery column_alias",
 /* 496 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 497 */ "twindow_clause_opt ::=",
 /* 498 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 499 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 500 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 501 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 502 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 503 */ "sliding_opt ::=",
 /* 504 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 505 */ "fill_opt ::=",
 /* 506 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 507 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 508 */ "fill_mode ::= NONE",
 /* 509 */ "fill_mode ::= PREV",
 /* 510 */ "fill_mode ::= NULL",
 /* 511 */ "fill_mode ::= LINEAR",
 /* 512 */ "fill_mode ::= NEXT",
 /* 513 */ "group_by_clause_opt ::=",
 /* 514 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 515 */ "group_by_list ::= expr_or_subquery",
 /* 516 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 517 */ "having_clause_opt ::=",
 /* 518 */ "having_clause_opt ::= HAVING search_condition",
 /* 519 */ "range_opt ::=",
 /* 520 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 521 */ "every_opt ::=",
 /* 522 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 523 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 524 */ "query_simple ::= query_specification",
 /* 525 */ "query_simple ::= union_query_expression",
 /* 526 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 527 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 528 */ "query_simple_or_subquery ::= query_simple",
 /* 529 */ "query_simple_or_subquery ::= subquery",
 /* 530 */ "query_or_subquery ::= query_expression",
 /* 531 */ "query_or_subquery ::= subquery",
 /* 532 */ "order_by_clause_opt ::=",
 /* 533 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 534 */ "slimit_clause_opt ::=",
 /* 535 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 536 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 537 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 538 */ "limit_clause_opt ::=",
 /* 539 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 540 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 541 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 542 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 543 */ "subquery ::= NK_LP subquery NK_RP",
 /* 544 */ "search_condition ::= common_expression",
 /* 545 */ "sort_specification_list ::= sort_specification",
 /* 546 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 547 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 548 */ "ordering_specification_opt ::=",
 /* 549 */ "ordering_specification_opt ::= ASC",
 /* 550 */ "ordering_specification_opt ::= DESC",
 /* 551 */ "null_ordering_opt ::=",
 /* 552 */ "null_ordering_opt ::= NULLS FIRST",
 /* 553 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 326: /* cmd */
    case 329: /* literal */
    case 342: /* db_options */
    case 344: /* alter_db_options */
    case 350: /* retention */
    case 351: /* full_table_name */
    case 354: /* table_options */
    case 358: /* alter_table_clause */
    case 359: /* alter_table_options */
    case 362: /* signed_literal */
    case 363: /* create_subtable_clause */
    case 366: /* drop_table_clause */
    case 369: /* column_def */
    case 373: /* duration_literal */
    case 374: /* rollup_func_name */
    case 376: /* col_name */
    case 377: /* db_name_cond_opt */
    case 378: /* like_pattern_opt */
    case 379: /* table_name_cond */
    case 380: /* from_db_opt */
    case 382: /* tag_item */
    case 384: /* full_index_name */
    case 385: /* index_options */
    case 388: /* sliding_opt */
    case 389: /* sma_stream_opt */
    case 390: /* func */
    case 392: /* query_or_subquery */
    case 395: /* explain_options */
    case 399: /* stream_options */
    case 401: /* subtable_opt */
    case 402: /* expression */
    case 404: /* where_clause_opt */
    case 405: /* signed */
    case 406: /* literal_func */
    case 409: /* expr_or_subquery */
    case 410: /* pseudo_column */
    case 411: /* column_reference */
    case 412: /* function_expression */
    case 413: /* case_when_expression */
    case 418: /* star_func_para */
    case 420: /* case_when_else_opt */
    case 421: /* common_expression */
    case 422: /* when_then_expr */
    case 423: /* predicate */
    case 426: /* in_predicate_value */
    case 427: /* boolean_value_expression */
    case 428: /* boolean_primary */
    case 429: /* from_clause_opt */
    case 430: /* table_reference_list */
    case 431: /* table_reference */
    case 432: /* table_primary */
    case 433: /* joined_table */
    case 435: /* subquery */
    case 436: /* parenthesized_joined_table */
    case 438: /* search_condition */
    case 439: /* query_specification */
    case 443: /* range_opt */
    case 444: /* every_opt */
    case 445: /* fill_opt */
    case 446: /* twindow_clause_opt */
    case 448: /* having_clause_opt */
    case 449: /* select_item */
    case 451: /* partition_item */
    case 454: /* query_expression */
    case 455: /* query_simple */
    case 457: /* slimit_clause_opt */
    case 458: /* limit_clause_opt */
    case 459: /* union_query_expression */
    case 460: /* query_simple_or_subquery */
    case 462: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy602)); 
}
      break;
    case 327: /* account_options */
    case 328: /* alter_account_options */
    case 330: /* alter_account_option */
    case 345: /* speed_opt */
    case 397: /* bufsize_opt */
{
 
}
      break;
    case 331: /* user_name */
    case 334: /* priv_level */
    case 337: /* db_name */
    case 338: /* topic_name */
    case 339: /* dnode_endpoint */
    case 360: /* column_name */
    case 368: /* table_name */
    case 375: /* function_name */
    case 383: /* column_alias */
    case 386: /* index_name */
    case 391: /* sma_func_name */
    case 393: /* cgroup_name */
    case 398: /* stream_name */
    case 408: /* table_alias */
    case 414: /* star_func */
    case 416: /* noarg_func */
    case 434: /* alias_opt */
{
 
}
      break;
    case 332: /* sysinfo_opt */
{
 
}
      break;
    case 333: /* privileges */
    case 335: /* priv_type_list */
    case 336: /* priv_type */
{
 
}
      break;
    case 340: /* force_opt */
    case 341: /* not_exists_opt */
    case 343: /* exists_opt */
    case 394: /* analyze_opt */
    case 396: /* agg_func_opt */
    case 440: /* set_quantifier_opt */
{
 
}
      break;
    case 346: /* integer_list */
    case 347: /* variable_list */
    case 348: /* retention_list */
    case 352: /* column_def_list */
    case 353: /* tags_def_opt */
    case 355: /* multi_create_clause */
    case 356: /* tags_def */
    case 357: /* multi_drop_clause */
    case 364: /* specific_cols_opt */
    case 365: /* expression_list */
    case 367: /* col_name_list */
    case 370: /* duration_list */
    case 371: /* rollup_func_list */
    case 381: /* tag_list_opt */
    case 387: /* func_list */
    case 400: /* col_list_opt */
    case 403: /* dnode_list */
    case 407: /* literal_list */
    case 415: /* star_func_para_list */
    case 417: /* other_para_list */
    case 419: /* when_then_list */
    case 441: /* select_list */
    case 442: /* partition_by_clause_opt */
    case 447: /* group_by_clause_opt */
    case 450: /* partition_list */
    case 453: /* group_by_list */
    case 456: /* order_by_clause_opt */
    case 461: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy874)); 
}
      break;
    case 349: /* alter_db_option */
    case 372: /* alter_table_option */
{
 
}
      break;
    case 361: /* type_name */
{
 
}
      break;
    case 424: /* compare_op */
    case 425: /* in_op */
{
 
}
      break;
    case 437: /* join_type */
{
 
}
      break;
    case 452: /* fill_mode */
{
 
}
      break;
    case 463: /* ordering_specification_opt */
{
 
}
      break;
    case 464: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  326,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  326,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  327,    0 }, /* (2) account_options ::= */
  {  327,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  327,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  327,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  327,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  327,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  327,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  327,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  327,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  327,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  328,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  328,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  330,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  330,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  330,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  330,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  330,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  330,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  330,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  330,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  330,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  330,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  326,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  326,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  326,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  326,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  326,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  332,    0 }, /* (29) sysinfo_opt ::= */
  {  332,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  326,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  326,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  333,   -1 }, /* (33) privileges ::= ALL */
  {  333,   -1 }, /* (34) privileges ::= priv_type_list */
  {  333,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  335,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  335,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  336,   -1 }, /* (38) priv_type ::= READ */
  {  336,   -1 }, /* (39) priv_type ::= WRITE */
  {  334,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  334,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  334,   -1 }, /* (42) priv_level ::= topic_name */
  {  326,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  326,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  326,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  326,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  326,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  326,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  326,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  326,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  339,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  339,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  339,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  340,    0 }, /* (54) force_opt ::= */
  {  340,   -1 }, /* (55) force_opt ::= FORCE */
  {  326,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  326,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  326,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  326,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  326,   -2 }, /* (68) cmd ::= USE db_name */
  {  326,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  326,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  326,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  326,   -3 }, /* (72) cmd ::= COMPACT DATABASE db_name */
  {  341,   -3 }, /* (73) not_exists_opt ::= IF NOT EXISTS */
  {  341,    0 }, /* (74) not_exists_opt ::= */
  {  343,   -2 }, /* (75) exists_opt ::= IF EXISTS */
  {  343,    0 }, /* (76) exists_opt ::= */
  {  342,    0 }, /* (77) db_options ::= */
  {  342,   -3 }, /* (78) db_options ::= db_options BUFFER NK_INTEGER */
  {  342,   -3 }, /* (79) db_options ::= db_options CACHEMODEL NK_STRING */
  {  342,   -3 }, /* (80) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  342,   -3 }, /* (81) db_options ::= db_options COMP NK_INTEGER */
  {  342,   -3 }, /* (82) db_options ::= db_options DURATION NK_INTEGER */
  {  342,   -3 }, /* (83) db_options ::= db_options DURATION NK_VARIABLE */
  {  342,   -3 }, /* (84) db_options ::= db_options MAXROWS NK_INTEGER */
  {  342,   -3 }, /* (85) db_options ::= db_options MINROWS NK_INTEGER */
  {  342,   -3 }, /* (86) db_options ::= db_options KEEP integer_list */
  {  342,   -3 }, /* (87) db_options ::= db_options KEEP variable_list */
  {  342,   -3 }, /* (88) db_options ::= db_options PAGES NK_INTEGER */
  {  342,   -3 }, /* (89) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  342,   -3 }, /* (90) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  342,   -3 }, /* (91) db_options ::= db_options PRECISION NK_STRING */
  {  342,   -3 }, /* (92) db_options ::= db_options REPLICA NK_INTEGER */
  {  342,   -3 }, /* (93) db_options ::= db_options VGROUPS NK_INTEGER */
  {  342,   -3 }, /* (94) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  342,   -3 }, /* (95) db_options ::= db_options RETENTIONS retention_list */
  {  342,   -3 }, /* (96) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  342,   -3 }, /* (97) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  342,   -3 }, /* (98) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  342,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  342,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  342,   -3 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  342,   -4 }, /* (102) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  342,   -3 }, /* (103) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  342,   -3 }, /* (104) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  342,   -3 }, /* (105) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  342,   -3 }, /* (106) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  342,   -3 }, /* (107) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  344,   -1 }, /* (108) alter_db_options ::= alter_db_option */
  {  344,   -2 }, /* (109) alter_db_options ::= alter_db_options alter_db_option */
  {  349,   -2 }, /* (110) alter_db_option ::= BUFFER NK_INTEGER */
  {  349,   -2 }, /* (111) alter_db_option ::= CACHEMODEL NK_STRING */
  {  349,   -2 }, /* (112) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  349,   -2 }, /* (113) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  349,   -2 }, /* (114) alter_db_option ::= KEEP integer_list */
  {  349,   -2 }, /* (115) alter_db_option ::= KEEP variable_list */
  {  349,   -2 }, /* (116) alter_db_option ::= PAGES NK_INTEGER */
  {  349,   -2 }, /* (117) alter_db_option ::= REPLICA NK_INTEGER */
  {  349,   -2 }, /* (118) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  349,   -2 }, /* (119) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  346,   -1 }, /* (120) integer_list ::= NK_INTEGER */
  {  346,   -3 }, /* (121) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  347,   -1 }, /* (122) variable_list ::= NK_VARIABLE */
  {  347,   -3 }, /* (123) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  348,   -1 }, /* (124) retention_list ::= retention */
  {  348,   -3 }, /* (125) retention_list ::= retention_list NK_COMMA retention */
  {  350,   -3 }, /* (126) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  345,    0 }, /* (127) speed_opt ::= */
  {  345,   -2 }, /* (128) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  326,   -9 }, /* (129) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  326,   -3 }, /* (130) cmd ::= CREATE TABLE multi_create_clause */
  {  326,   -9 }, /* (131) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  326,   -3 }, /* (132) cmd ::= DROP TABLE multi_drop_clause */
  {  326,   -4 }, /* (133) cmd ::= DROP STABLE exists_opt full_table_name */
  {  326,   -3 }, /* (134) cmd ::= ALTER TABLE alter_table_clause */
  {  326,   -3 }, /* (135) cmd ::= ALTER STABLE alter_table_clause */
  {  358,   -2 }, /* (136) alter_table_clause ::= full_table_name alter_table_options */
  {  358,   -5 }, /* (137) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  358,   -4 }, /* (138) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  358,   -5 }, /* (139) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  358,   -5 }, /* (140) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  358,   -5 }, /* (141) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  358,   -4 }, /* (142) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  358,   -5 }, /* (143) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  358,   -5 }, /* (144) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  358,   -6 }, /* (145) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  355,   -1 }, /* (146) multi_create_clause ::= create_subtable_clause */
  {  355,   -2 }, /* (147) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  363,  -10 }, /* (148) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  357,   -1 }, /* (149) multi_drop_clause ::= drop_table_clause */
  {  357,   -2 }, /* (150) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  366,   -2 }, /* (151) drop_table_clause ::= exists_opt full_table_name */
  {  364,    0 }, /* (152) specific_cols_opt ::= */
  {  364,   -3 }, /* (153) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  351,   -1 }, /* (154) full_table_name ::= table_name */
  {  351,   -3 }, /* (155) full_table_name ::= db_name NK_DOT table_name */
  {  352,   -1 }, /* (156) column_def_list ::= column_def */
  {  352,   -3 }, /* (157) column_def_list ::= column_def_list NK_COMMA column_def */
  {  369,   -2 }, /* (158) column_def ::= column_name type_name */
  {  369,   -4 }, /* (159) column_def ::= column_name type_name COMMENT NK_STRING */
  {  361,   -1 }, /* (160) type_name ::= BOOL */
  {  361,   -1 }, /* (161) type_name ::= TINYINT */
  {  361,   -1 }, /* (162) type_name ::= SMALLINT */
  {  361,   -1 }, /* (163) type_name ::= INT */
  {  361,   -1 }, /* (164) type_name ::= INTEGER */
  {  361,   -1 }, /* (165) type_name ::= BIGINT */
  {  361,   -1 }, /* (166) type_name ::= FLOAT */
  {  361,   -1 }, /* (167) type_name ::= DOUBLE */
  {  361,   -4 }, /* (168) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  361,   -1 }, /* (169) type_name ::= TIMESTAMP */
  {  361,   -4 }, /* (170) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  361,   -2 }, /* (171) type_name ::= TINYINT UNSIGNED */
  {  361,   -2 }, /* (172) type_name ::= SMALLINT UNSIGNED */
  {  361,   -2 }, /* (173) type_name ::= INT UNSIGNED */
  {  361,   -2 }, /* (174) type_name ::= BIGINT UNSIGNED */
  {  361,   -1 }, /* (175) type_name ::= JSON */
  {  361,   -4 }, /* (176) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  361,   -1 }, /* (177) type_name ::= MEDIUMBLOB */
  {  361,   -1 }, /* (178) type_name ::= BLOB */
  {  361,   -4 }, /* (179) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  361,   -1 }, /* (180) type_name ::= DECIMAL */
  {  361,   -4 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  361,   -6 }, /* (182) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  353,    0 }, /* (183) tags_def_opt ::= */
  {  353,   -1 }, /* (184) tags_def_opt ::= tags_def */
  {  356,   -4 }, /* (185) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  354,    0 }, /* (186) table_options ::= */
  {  354,   -3 }, /* (187) table_options ::= table_options COMMENT NK_STRING */
  {  354,   -3 }, /* (188) table_options ::= table_options MAX_DELAY duration_list */
  {  354,   -3 }, /* (189) table_options ::= table_options WATERMARK duration_list */
  {  354,   -5 }, /* (190) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  354,   -3 }, /* (191) table_options ::= table_options TTL NK_INTEGER */
  {  354,   -5 }, /* (192) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  354,   -3 }, /* (193) table_options ::= table_options DELETE_MARK duration_list */
  {  359,   -1 }, /* (194) alter_table_options ::= alter_table_option */
  {  359,   -2 }, /* (195) alter_table_options ::= alter_table_options alter_table_option */
  {  372,   -2 }, /* (196) alter_table_option ::= COMMENT NK_STRING */
  {  372,   -2 }, /* (197) alter_table_option ::= TTL NK_INTEGER */
  {  370,   -1 }, /* (198) duration_list ::= duration_literal */
  {  370,   -3 }, /* (199) duration_list ::= duration_list NK_COMMA duration_literal */
  {  371,   -1 }, /* (200) rollup_func_list ::= rollup_func_name */
  {  371,   -3 }, /* (201) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  374,   -1 }, /* (202) rollup_func_name ::= function_name */
  {  374,   -1 }, /* (203) rollup_func_name ::= FIRST */
  {  374,   -1 }, /* (204) rollup_func_name ::= LAST */
  {  367,   -1 }, /* (205) col_name_list ::= col_name */
  {  367,   -3 }, /* (206) col_name_list ::= col_name_list NK_COMMA col_name */
  {  376,   -1 }, /* (207) col_name ::= column_name */
  {  326,   -2 }, /* (208) cmd ::= SHOW DNODES */
  {  326,   -2 }, /* (209) cmd ::= SHOW USERS */
  {  326,   -3 }, /* (210) cmd ::= SHOW USER PRIVILEGES */
  {  326,   -2 }, /* (211) cmd ::= SHOW DATABASES */
  {  326,   -4 }, /* (212) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  326,   -4 }, /* (213) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  326,   -3 }, /* (214) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  326,   -2 }, /* (215) cmd ::= SHOW MNODES */
  {  326,   -2 }, /* (216) cmd ::= SHOW QNODES */
  {  326,   -2 }, /* (217) cmd ::= SHOW FUNCTIONS */
  {  326,   -5 }, /* (218) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  326,   -2 }, /* (219) cmd ::= SHOW STREAMS */
  {  326,   -2 }, /* (220) cmd ::= SHOW ACCOUNTS */
  {  326,   -2 }, /* (221) cmd ::= SHOW APPS */
  {  326,   -2 }, /* (222) cmd ::= SHOW CONNECTIONS */
  {  326,   -2 }, /* (223) cmd ::= SHOW LICENCES */
  {  326,   -2 }, /* (224) cmd ::= SHOW GRANTS */
  {  326,   -4 }, /* (225) cmd ::= SHOW CREATE DATABASE db_name */
  {  326,   -4 }, /* (226) cmd ::= SHOW CREATE TABLE full_table_name */
  {  326,   -4 }, /* (227) cmd ::= SHOW CREATE STABLE full_table_name */
  {  326,   -2 }, /* (228) cmd ::= SHOW QUERIES */
  {  326,   -2 }, /* (229) cmd ::= SHOW SCORES */
  {  326,   -2 }, /* (230) cmd ::= SHOW TOPICS */
  {  326,   -2 }, /* (231) cmd ::= SHOW VARIABLES */
  {  326,   -3 }, /* (232) cmd ::= SHOW CLUSTER VARIABLES */
  {  326,   -3 }, /* (233) cmd ::= SHOW LOCAL VARIABLES */
  {  326,   -5 }, /* (234) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  326,   -2 }, /* (235) cmd ::= SHOW BNODES */
  {  326,   -2 }, /* (236) cmd ::= SHOW SNODES */
  {  326,   -2 }, /* (237) cmd ::= SHOW CLUSTER */
  {  326,   -2 }, /* (238) cmd ::= SHOW TRANSACTIONS */
  {  326,   -4 }, /* (239) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  326,   -2 }, /* (240) cmd ::= SHOW CONSUMERS */
  {  326,   -2 }, /* (241) cmd ::= SHOW SUBSCRIPTIONS */
  {  326,   -5 }, /* (242) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  326,   -7 }, /* (243) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  326,   -3 }, /* (244) cmd ::= SHOW VNODES NK_INTEGER */
  {  326,   -3 }, /* (245) cmd ::= SHOW VNODES NK_STRING */
  {  326,   -3 }, /* (246) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  326,   -3 }, /* (247) cmd ::= SHOW CLUSTER ALIVE */
  {  377,    0 }, /* (248) db_name_cond_opt ::= */
  {  377,   -2 }, /* (249) db_name_cond_opt ::= db_name NK_DOT */
  {  378,    0 }, /* (250) like_pattern_opt ::= */
  {  378,   -2 }, /* (251) like_pattern_opt ::= LIKE NK_STRING */
  {  379,   -1 }, /* (252) table_name_cond ::= table_name */
  {  380,    0 }, /* (253) from_db_opt ::= */
  {  380,   -2 }, /* (254) from_db_opt ::= FROM db_name */
  {  381,    0 }, /* (255) tag_list_opt ::= */
  {  381,   -1 }, /* (256) tag_list_opt ::= tag_item */
  {  381,   -3 }, /* (257) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  382,   -1 }, /* (258) tag_item ::= TBNAME */
  {  382,   -1 }, /* (259) tag_item ::= QTAGS */
  {  382,   -1 }, /* (260) tag_item ::= column_name */
  {  382,   -2 }, /* (261) tag_item ::= column_name column_alias */
  {  382,   -3 }, /* (262) tag_item ::= column_name AS column_alias */
  {  326,   -8 }, /* (263) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  326,   -9 }, /* (264) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  326,   -4 }, /* (265) cmd ::= DROP INDEX exists_opt full_index_name */
  {  384,   -1 }, /* (266) full_index_name ::= index_name */
  {  384,   -3 }, /* (267) full_index_name ::= db_name NK_DOT index_name */
  {  385,  -10 }, /* (268) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  385,  -12 }, /* (269) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  387,   -1 }, /* (270) func_list ::= func */
  {  387,   -3 }, /* (271) func_list ::= func_list NK_COMMA func */
  {  390,   -4 }, /* (272) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  391,   -1 }, /* (273) sma_func_name ::= function_name */
  {  391,   -1 }, /* (274) sma_func_name ::= COUNT */
  {  391,   -1 }, /* (275) sma_func_name ::= FIRST */
  {  391,   -1 }, /* (276) sma_func_name ::= LAST */
  {  391,   -1 }, /* (277) sma_func_name ::= LAST_ROW */
  {  389,    0 }, /* (278) sma_stream_opt ::= */
  {  389,   -3 }, /* (279) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  389,   -3 }, /* (280) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  389,   -3 }, /* (281) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  326,   -6 }, /* (282) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  326,   -7 }, /* (283) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  326,   -9 }, /* (284) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  326,   -7 }, /* (285) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  326,   -9 }, /* (286) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  326,   -4 }, /* (287) cmd ::= DROP TOPIC exists_opt topic_name */
  {  326,   -7 }, /* (288) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  326,   -2 }, /* (289) cmd ::= DESC full_table_name */
  {  326,   -2 }, /* (290) cmd ::= DESCRIBE full_table_name */
  {  326,   -3 }, /* (291) cmd ::= RESET QUERY CACHE */
  {  326,   -4 }, /* (292) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  394,    0 }, /* (293) analyze_opt ::= */
  {  394,   -1 }, /* (294) analyze_opt ::= ANALYZE */
  {  395,    0 }, /* (295) explain_options ::= */
  {  395,   -3 }, /* (296) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  395,   -3 }, /* (297) explain_options ::= explain_options RATIO NK_FLOAT */
  {  326,  -10 }, /* (298) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  326,   -4 }, /* (299) cmd ::= DROP FUNCTION exists_opt function_name */
  {  396,    0 }, /* (300) agg_func_opt ::= */
  {  396,   -1 }, /* (301) agg_func_opt ::= AGGREGATE */
  {  397,    0 }, /* (302) bufsize_opt ::= */
  {  397,   -2 }, /* (303) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  326,  -12 }, /* (304) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tags_def_opt subtable_opt AS query_or_subquery */
  {  326,   -4 }, /* (305) cmd ::= DROP STREAM exists_opt stream_name */
  {  400,    0 }, /* (306) col_list_opt ::= */
  {  400,   -3 }, /* (307) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  399,    0 }, /* (308) stream_options ::= */
  {  399,   -3 }, /* (309) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  399,   -3 }, /* (310) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  399,   -4 }, /* (311) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  399,   -3 }, /* (312) stream_options ::= stream_options WATERMARK duration_literal */
  {  399,   -4 }, /* (313) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  399,   -3 }, /* (314) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  401,    0 }, /* (315) subtable_opt ::= */
  {  401,   -4 }, /* (316) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  326,   -3 }, /* (317) cmd ::= KILL CONNECTION NK_INTEGER */
  {  326,   -3 }, /* (318) cmd ::= KILL QUERY NK_STRING */
  {  326,   -3 }, /* (319) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  326,   -2 }, /* (320) cmd ::= BALANCE VGROUP */
  {  326,   -4 }, /* (321) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  326,   -4 }, /* (322) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  326,   -3 }, /* (323) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  403,   -2 }, /* (324) dnode_list ::= DNODE NK_INTEGER */
  {  403,   -3 }, /* (325) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  326,   -4 }, /* (326) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  326,   -1 }, /* (327) cmd ::= query_or_subquery */
  {  326,   -7 }, /* (328) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  326,   -4 }, /* (329) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  329,   -1 }, /* (330) literal ::= NK_INTEGER */
  {  329,   -1 }, /* (331) literal ::= NK_FLOAT */
  {  329,   -1 }, /* (332) literal ::= NK_STRING */
  {  329,   -1 }, /* (333) literal ::= NK_BOOL */
  {  329,   -2 }, /* (334) literal ::= TIMESTAMP NK_STRING */
  {  329,   -1 }, /* (335) literal ::= duration_literal */
  {  329,   -1 }, /* (336) literal ::= NULL */
  {  329,   -1 }, /* (337) literal ::= NK_QUESTION */
  {  373,   -1 }, /* (338) duration_literal ::= NK_VARIABLE */
  {  405,   -1 }, /* (339) signed ::= NK_INTEGER */
  {  405,   -2 }, /* (340) signed ::= NK_PLUS NK_INTEGER */
  {  405,   -2 }, /* (341) signed ::= NK_MINUS NK_INTEGER */
  {  405,   -1 }, /* (342) signed ::= NK_FLOAT */
  {  405,   -2 }, /* (343) signed ::= NK_PLUS NK_FLOAT */
  {  405,   -2 }, /* (344) signed ::= NK_MINUS NK_FLOAT */
  {  362,   -1 }, /* (345) signed_literal ::= signed */
  {  362,   -1 }, /* (346) signed_literal ::= NK_STRING */
  {  362,   -1 }, /* (347) signed_literal ::= NK_BOOL */
  {  362,   -2 }, /* (348) signed_literal ::= TIMESTAMP NK_STRING */
  {  362,   -1 }, /* (349) signed_literal ::= duration_literal */
  {  362,   -1 }, /* (350) signed_literal ::= NULL */
  {  362,   -1 }, /* (351) signed_literal ::= literal_func */
  {  362,   -1 }, /* (352) signed_literal ::= NK_QUESTION */
  {  407,   -1 }, /* (353) literal_list ::= signed_literal */
  {  407,   -3 }, /* (354) literal_list ::= literal_list NK_COMMA signed_literal */
  {  337,   -1 }, /* (355) db_name ::= NK_ID */
  {  368,   -1 }, /* (356) table_name ::= NK_ID */
  {  360,   -1 }, /* (357) column_name ::= NK_ID */
  {  375,   -1 }, /* (358) function_name ::= NK_ID */
  {  408,   -1 }, /* (359) table_alias ::= NK_ID */
  {  383,   -1 }, /* (360) column_alias ::= NK_ID */
  {  331,   -1 }, /* (361) user_name ::= NK_ID */
  {  338,   -1 }, /* (362) topic_name ::= NK_ID */
  {  398,   -1 }, /* (363) stream_name ::= NK_ID */
  {  393,   -1 }, /* (364) cgroup_name ::= NK_ID */
  {  386,   -1 }, /* (365) index_name ::= NK_ID */
  {  409,   -1 }, /* (366) expr_or_subquery ::= expression */
  {  402,   -1 }, /* (367) expression ::= literal */
  {  402,   -1 }, /* (368) expression ::= pseudo_column */
  {  402,   -1 }, /* (369) expression ::= column_reference */
  {  402,   -1 }, /* (370) expression ::= function_expression */
  {  402,   -1 }, /* (371) expression ::= case_when_expression */
  {  402,   -3 }, /* (372) expression ::= NK_LP expression NK_RP */
  {  402,   -2 }, /* (373) expression ::= NK_PLUS expr_or_subquery */
  {  402,   -2 }, /* (374) expression ::= NK_MINUS expr_or_subquery */
  {  402,   -3 }, /* (375) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  402,   -3 }, /* (376) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  402,   -3 }, /* (377) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  402,   -3 }, /* (378) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  402,   -3 }, /* (379) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  402,   -3 }, /* (380) expression ::= column_reference NK_ARROW NK_STRING */
  {  402,   -3 }, /* (381) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  402,   -3 }, /* (382) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  365,   -1 }, /* (383) expression_list ::= expr_or_subquery */
  {  365,   -3 }, /* (384) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  411,   -1 }, /* (385) column_reference ::= column_name */
  {  411,   -3 }, /* (386) column_reference ::= table_name NK_DOT column_name */
  {  410,   -1 }, /* (387) pseudo_column ::= ROWTS */
  {  410,   -1 }, /* (388) pseudo_column ::= TBNAME */
  {  410,   -3 }, /* (389) pseudo_column ::= table_name NK_DOT TBNAME */
  {  410,   -1 }, /* (390) pseudo_column ::= QSTART */
  {  410,   -1 }, /* (391) pseudo_column ::= QEND */
  {  410,   -1 }, /* (392) pseudo_column ::= QDURATION */
  {  410,   -1 }, /* (393) pseudo_column ::= WSTART */
  {  410,   -1 }, /* (394) pseudo_column ::= WEND */
  {  410,   -1 }, /* (395) pseudo_column ::= WDURATION */
  {  410,   -1 }, /* (396) pseudo_column ::= IROWTS */
  {  410,   -1 }, /* (397) pseudo_column ::= ISFILLED */
  {  410,   -1 }, /* (398) pseudo_column ::= QTAGS */
  {  412,   -4 }, /* (399) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  412,   -4 }, /* (400) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  412,   -6 }, /* (401) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  412,   -1 }, /* (402) function_expression ::= literal_func */
  {  406,   -3 }, /* (403) literal_func ::= noarg_func NK_LP NK_RP */
  {  406,   -1 }, /* (404) literal_func ::= NOW */
  {  416,   -1 }, /* (405) noarg_func ::= NOW */
  {  416,   -1 }, /* (406) noarg_func ::= TODAY */
  {  416,   -1 }, /* (407) noarg_func ::= TIMEZONE */
  {  416,   -1 }, /* (408) noarg_func ::= DATABASE */
  {  416,   -1 }, /* (409) noarg_func ::= CLIENT_VERSION */
  {  416,   -1 }, /* (410) noarg_func ::= SERVER_VERSION */
  {  416,   -1 }, /* (411) noarg_func ::= SERVER_STATUS */
  {  416,   -1 }, /* (412) noarg_func ::= CURRENT_USER */
  {  416,   -1 }, /* (413) noarg_func ::= USER */
  {  414,   -1 }, /* (414) star_func ::= COUNT */
  {  414,   -1 }, /* (415) star_func ::= FIRST */
  {  414,   -1 }, /* (416) star_func ::= LAST */
  {  414,   -1 }, /* (417) star_func ::= LAST_ROW */
  {  415,   -1 }, /* (418) star_func_para_list ::= NK_STAR */
  {  415,   -1 }, /* (419) star_func_para_list ::= other_para_list */
  {  417,   -1 }, /* (420) other_para_list ::= star_func_para */
  {  417,   -3 }, /* (421) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  418,   -1 }, /* (422) star_func_para ::= expr_or_subquery */
  {  418,   -3 }, /* (423) star_func_para ::= table_name NK_DOT NK_STAR */
  {  413,   -4 }, /* (424) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  413,   -5 }, /* (425) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  419,   -1 }, /* (426) when_then_list ::= when_then_expr */
  {  419,   -2 }, /* (427) when_then_list ::= when_then_list when_then_expr */
  {  422,   -4 }, /* (428) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  420,    0 }, /* (429) case_when_else_opt ::= */
  {  420,   -2 }, /* (430) case_when_else_opt ::= ELSE common_expression */
  {  423,   -3 }, /* (431) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  423,   -5 }, /* (432) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  423,   -6 }, /* (433) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  423,   -3 }, /* (434) predicate ::= expr_or_subquery IS NULL */
  {  423,   -4 }, /* (435) predicate ::= expr_or_subquery IS NOT NULL */
  {  423,   -3 }, /* (436) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  424,   -1 }, /* (437) compare_op ::= NK_LT */
  {  424,   -1 }, /* (438) compare_op ::= NK_GT */
  {  424,   -1 }, /* (439) compare_op ::= NK_LE */
  {  424,   -1 }, /* (440) compare_op ::= NK_GE */
  {  424,   -1 }, /* (441) compare_op ::= NK_NE */
  {  424,   -1 }, /* (442) compare_op ::= NK_EQ */
  {  424,   -1 }, /* (443) compare_op ::= LIKE */
  {  424,   -2 }, /* (444) compare_op ::= NOT LIKE */
  {  424,   -1 }, /* (445) compare_op ::= MATCH */
  {  424,   -1 }, /* (446) compare_op ::= NMATCH */
  {  424,   -1 }, /* (447) compare_op ::= CONTAINS */
  {  425,   -1 }, /* (448) in_op ::= IN */
  {  425,   -2 }, /* (449) in_op ::= NOT IN */
  {  426,   -3 }, /* (450) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  427,   -1 }, /* (451) boolean_value_expression ::= boolean_primary */
  {  427,   -2 }, /* (452) boolean_value_expression ::= NOT boolean_primary */
  {  427,   -3 }, /* (453) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  427,   -3 }, /* (454) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  428,   -1 }, /* (455) boolean_primary ::= predicate */
  {  428,   -3 }, /* (456) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  421,   -1 }, /* (457) common_expression ::= expr_or_subquery */
  {  421,   -1 }, /* (458) common_expression ::= boolean_value_expression */
  {  429,    0 }, /* (459) from_clause_opt ::= */
  {  429,   -2 }, /* (460) from_clause_opt ::= FROM table_reference_list */
  {  430,   -1 }, /* (461) table_reference_list ::= table_reference */
  {  430,   -3 }, /* (462) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  431,   -1 }, /* (463) table_reference ::= table_primary */
  {  431,   -1 }, /* (464) table_reference ::= joined_table */
  {  432,   -2 }, /* (465) table_primary ::= table_name alias_opt */
  {  432,   -4 }, /* (466) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  432,   -2 }, /* (467) table_primary ::= subquery alias_opt */
  {  432,   -1 }, /* (468) table_primary ::= parenthesized_joined_table */
  {  434,    0 }, /* (469) alias_opt ::= */
  {  434,   -1 }, /* (470) alias_opt ::= table_alias */
  {  434,   -2 }, /* (471) alias_opt ::= AS table_alias */
  {  436,   -3 }, /* (472) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  436,   -3 }, /* (473) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  433,   -6 }, /* (474) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  437,    0 }, /* (475) join_type ::= */
  {  437,   -1 }, /* (476) join_type ::= INNER */
  {  439,  -12 }, /* (477) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  440,    0 }, /* (478) set_quantifier_opt ::= */
  {  440,   -1 }, /* (479) set_quantifier_opt ::= DISTINCT */
  {  440,   -1 }, /* (480) set_quantifier_opt ::= ALL */
  {  441,   -1 }, /* (481) select_list ::= select_item */
  {  441,   -3 }, /* (482) select_list ::= select_list NK_COMMA select_item */
  {  449,   -1 }, /* (483) select_item ::= NK_STAR */
  {  449,   -1 }, /* (484) select_item ::= common_expression */
  {  449,   -2 }, /* (485) select_item ::= common_expression column_alias */
  {  449,   -3 }, /* (486) select_item ::= common_expression AS column_alias */
  {  449,   -3 }, /* (487) select_item ::= table_name NK_DOT NK_STAR */
  {  404,    0 }, /* (488) where_clause_opt ::= */
  {  404,   -2 }, /* (489) where_clause_opt ::= WHERE search_condition */
  {  442,    0 }, /* (490) partition_by_clause_opt ::= */
  {  442,   -3 }, /* (491) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  450,   -1 }, /* (492) partition_list ::= partition_item */
  {  450,   -3 }, /* (493) partition_list ::= partition_list NK_COMMA partition_item */
  {  451,   -1 }, /* (494) partition_item ::= expr_or_subquery */
  {  451,   -2 }, /* (495) partition_item ::= expr_or_subquery column_alias */
  {  451,   -3 }, /* (496) partition_item ::= expr_or_subquery AS column_alias */
  {  446,    0 }, /* (497) twindow_clause_opt ::= */
  {  446,   -6 }, /* (498) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  446,   -4 }, /* (499) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  446,   -6 }, /* (500) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  446,   -8 }, /* (501) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  446,   -7 }, /* (502) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  388,    0 }, /* (503) sliding_opt ::= */
  {  388,   -4 }, /* (504) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  445,    0 }, /* (505) fill_opt ::= */
  {  445,   -4 }, /* (506) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  445,   -6 }, /* (507) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  452,   -1 }, /* (508) fill_mode ::= NONE */
  {  452,   -1 }, /* (509) fill_mode ::= PREV */
  {  452,   -1 }, /* (510) fill_mode ::= NULL */
  {  452,   -1 }, /* (511) fill_mode ::= LINEAR */
  {  452,   -1 }, /* (512) fill_mode ::= NEXT */
  {  447,    0 }, /* (513) group_by_clause_opt ::= */
  {  447,   -3 }, /* (514) group_by_clause_opt ::= GROUP BY group_by_list */
  {  453,   -1 }, /* (515) group_by_list ::= expr_or_subquery */
  {  453,   -3 }, /* (516) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  448,    0 }, /* (517) having_clause_opt ::= */
  {  448,   -2 }, /* (518) having_clause_opt ::= HAVING search_condition */
  {  443,    0 }, /* (519) range_opt ::= */
  {  443,   -6 }, /* (520) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  444,    0 }, /* (521) every_opt ::= */
  {  444,   -4 }, /* (522) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  454,   -4 }, /* (523) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  455,   -1 }, /* (524) query_simple ::= query_specification */
  {  455,   -1 }, /* (525) query_simple ::= union_query_expression */
  {  459,   -4 }, /* (526) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  459,   -3 }, /* (527) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  460,   -1 }, /* (528) query_simple_or_subquery ::= query_simple */
  {  460,   -1 }, /* (529) query_simple_or_subquery ::= subquery */
  {  392,   -1 }, /* (530) query_or_subquery ::= query_expression */
  {  392,   -1 }, /* (531) query_or_subquery ::= subquery */
  {  456,    0 }, /* (532) order_by_clause_opt ::= */
  {  456,   -3 }, /* (533) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  457,    0 }, /* (534) slimit_clause_opt ::= */
  {  457,   -2 }, /* (535) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  457,   -4 }, /* (536) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  457,   -4 }, /* (537) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  458,    0 }, /* (538) limit_clause_opt ::= */
  {  458,   -2 }, /* (539) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  458,   -4 }, /* (540) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  458,   -4 }, /* (541) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  435,   -3 }, /* (542) subquery ::= NK_LP query_expression NK_RP */
  {  435,   -3 }, /* (543) subquery ::= NK_LP subquery NK_RP */
  {  438,   -1 }, /* (544) search_condition ::= common_expression */
  {  461,   -1 }, /* (545) sort_specification_list ::= sort_specification */
  {  461,   -3 }, /* (546) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  462,   -3 }, /* (547) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  463,    0 }, /* (548) ordering_specification_opt ::= */
  {  463,   -1 }, /* (549) ordering_specification_opt ::= ASC */
  {  463,   -1 }, /* (550) ordering_specification_opt ::= DESC */
  {  464,    0 }, /* (551) null_ordering_opt ::= */
  {  464,   -2 }, /* (552) null_ordering_opt ::= NULLS FIRST */
  {  464,   -2 }, /* (553) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,327,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,328,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,327,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,329,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,330,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,328,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,330,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,329,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy179, &yymsp[-1].minor.yy0, yymsp[0].minor.yy113); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy179, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy179, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy179, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy179); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy113 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy113 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy159, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy179); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy159, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy179); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy159 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy159 = yymsp[0].minor.yy159; }
  yymsp[0].minor.yy159 = yylhsminor.yy159;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy159 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy159 = yymsp[-2].minor.yy159 | yymsp[0].minor.yy159; }
  yymsp[-2].minor.yy159 = yylhsminor.yy159;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy159 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy159 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy179 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy179 = yylhsminor.yy179;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy179 = yymsp[-2].minor.yy179; }
  yymsp[-2].minor.yy179 = yylhsminor.yy179;
        break;
      case 42: /* priv_level ::= topic_name */
      case 273: /* sma_func_name ::= function_name */ yytestcase(yyruleno==273);
      case 470: /* alias_opt ::= table_alias */ yytestcase(yyruleno==470);
{ yylhsminor.yy179 = yymsp[0].minor.yy179; }
  yymsp[0].minor.yy179 = yylhsminor.yy179;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy179, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy767); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy179, yymsp[0].minor.yy767); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 274: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==274);
      case 275: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==275);
      case 276: /* sma_func_name ::= LAST */ yytestcase(yyruleno==276);
      case 277: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==277);
      case 355: /* db_name ::= NK_ID */ yytestcase(yyruleno==355);
      case 356: /* table_name ::= NK_ID */ yytestcase(yyruleno==356);
      case 357: /* column_name ::= NK_ID */ yytestcase(yyruleno==357);
      case 358: /* function_name ::= NK_ID */ yytestcase(yyruleno==358);
      case 359: /* table_alias ::= NK_ID */ yytestcase(yyruleno==359);
      case 360: /* column_alias ::= NK_ID */ yytestcase(yyruleno==360);
      case 361: /* user_name ::= NK_ID */ yytestcase(yyruleno==361);
      case 362: /* topic_name ::= NK_ID */ yytestcase(yyruleno==362);
      case 363: /* stream_name ::= NK_ID */ yytestcase(yyruleno==363);
      case 364: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==364);
      case 365: /* index_name ::= NK_ID */ yytestcase(yyruleno==365);
      case 405: /* noarg_func ::= NOW */ yytestcase(yyruleno==405);
      case 406: /* noarg_func ::= TODAY */ yytestcase(yyruleno==406);
      case 407: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==407);
      case 408: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==408);
      case 409: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==409);
      case 410: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==410);
      case 411: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==411);
      case 412: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==412);
      case 413: /* noarg_func ::= USER */ yytestcase(yyruleno==413);
      case 414: /* star_func ::= COUNT */ yytestcase(yyruleno==414);
      case 415: /* star_func ::= FIRST */ yytestcase(yyruleno==415);
      case 416: /* star_func ::= LAST */ yytestcase(yyruleno==416);
      case 417: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==417);
{ yylhsminor.yy179 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy179 = yylhsminor.yy179;
        break;
      case 54: /* force_opt ::= */
      case 74: /* not_exists_opt ::= */ yytestcase(yyruleno==74);
      case 76: /* exists_opt ::= */ yytestcase(yyruleno==76);
      case 293: /* analyze_opt ::= */ yytestcase(yyruleno==293);
      case 300: /* agg_func_opt ::= */ yytestcase(yyruleno==300);
      case 478: /* set_quantifier_opt ::= */ yytestcase(yyruleno==478);
{ yymsp[1].minor.yy767 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 294: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==294);
      case 301: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==301);
      case 479: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==479);
{ yymsp[0].minor.yy767 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy767, &yymsp[-1].minor.yy179, yymsp[0].minor.yy602); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy767, &yymsp[0].minor.yy179); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy179); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy179, yymsp[0].minor.yy602); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy179); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy179, yymsp[0].minor.yy820); }
        break;
      case 72: /* cmd ::= COMPACT DATABASE db_name */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[0].minor.yy179); }
        break;
      case 73: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy767 = true; }
        break;
      case 75: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy767 = true; }
        break;
      case 77: /* db_options ::= */
{ yymsp[1].minor.yy602 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 78: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 79: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 80: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 81: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 82: /* db_options ::= db_options DURATION NK_INTEGER */
      case 83: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==83);
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 84: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 85: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 86: /* db_options ::= db_options KEEP integer_list */
      case 87: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==87);
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_KEEP, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 88: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 89: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 90: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 91: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 92: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 93: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 94: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 95: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_RETENTIONS, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 96: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 97: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 98: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-3].minor.yy602, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-3].minor.yy602, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 103: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 104: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 105: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 106: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 107: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy602 = setDatabaseOption(pCxt, yymsp[-2].minor.yy602, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 108: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy602 = createAlterDatabaseOptions(pCxt); yylhsminor.yy602 = setAlterDatabaseOption(pCxt, yylhsminor.yy602, &yymsp[0].minor.yy845); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 109: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy602 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy602, &yymsp[0].minor.yy845); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 110: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy845.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy845.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy845.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy845.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy845.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy845.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy845.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy845.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= KEEP integer_list */
      case 115: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==115);
{ yymsp[-1].minor.yy845.type = DB_OPTION_KEEP; yymsp[-1].minor.yy845.pList = yymsp[0].minor.yy874; }
        break;
      case 116: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy845.type = DB_OPTION_PAGES; yymsp[-1].minor.yy845.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy845.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy845.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy845.type = DB_OPTION_WAL; yymsp[-1].minor.yy845.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy845.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy845.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy874 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 121: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 325: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==325);
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 122: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy874 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 123: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 124: /* retention_list ::= retention */
      case 146: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==146);
      case 149: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==149);
      case 156: /* column_def_list ::= column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name */ yytestcase(yyruleno==205);
      case 256: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==256);
      case 270: /* func_list ::= func */ yytestcase(yyruleno==270);
      case 353: /* literal_list ::= signed_literal */ yytestcase(yyruleno==353);
      case 420: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==420);
      case 426: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==426);
      case 481: /* select_list ::= select_item */ yytestcase(yyruleno==481);
      case 492: /* partition_list ::= partition_item */ yytestcase(yyruleno==492);
      case 545: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==545);
{ yylhsminor.yy874 = createNodeList(pCxt, yymsp[0].minor.yy602); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 125: /* retention_list ::= retention_list NK_COMMA retention */
      case 157: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==157);
      case 201: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==201);
      case 206: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==206);
      case 257: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==257);
      case 271: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==271);
      case 354: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==354);
      case 421: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==421);
      case 482: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==482);
      case 493: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==493);
      case 546: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==546);
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, yymsp[0].minor.yy602); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 126: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy602 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 127: /* speed_opt ::= */
      case 302: /* bufsize_opt ::= */ yytestcase(yyruleno==302);
{ yymsp[1].minor.yy820 = 0; }
        break;
      case 128: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 303: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==303);
{ yymsp[-1].minor.yy820 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 129: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 131: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==131);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy767, yymsp[-5].minor.yy602, yymsp[-3].minor.yy874, yymsp[-1].minor.yy874, yymsp[0].minor.yy602); }
        break;
      case 130: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy874); }
        break;
      case 132: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy874); }
        break;
      case 133: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy767, yymsp[0].minor.yy602); }
        break;
      case 134: /* cmd ::= ALTER TABLE alter_table_clause */
      case 327: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==327);
{ pCxt->pRootNode = yymsp[0].minor.yy602; }
        break;
      case 135: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy602); }
        break;
      case 136: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy602 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy602, yymsp[0].minor.yy602); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 137: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy602 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy602, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy179, yymsp[0].minor.yy394); }
  yymsp[-4].minor.yy602 = yylhsminor.yy602;
        break;
      case 138: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy602 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy602, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy179); }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 139: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy602 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy602, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy179, yymsp[0].minor.yy394); }
  yymsp[-4].minor.yy602 = yylhsminor.yy602;
        break;
      case 140: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy602 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy602, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy179, &yymsp[0].minor.yy179); }
  yymsp[-4].minor.yy602 = yylhsminor.yy602;
        break;
      case 141: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy602 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy602, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy179, yymsp[0].minor.yy394); }
  yymsp[-4].minor.yy602 = yylhsminor.yy602;
        break;
      case 142: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy602 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy602, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy179); }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 143: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy602 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy602, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy179, yymsp[0].minor.yy394); }
  yymsp[-4].minor.yy602 = yylhsminor.yy602;
        break;
      case 144: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy602 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy602, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy179, &yymsp[0].minor.yy179); }
  yymsp[-4].minor.yy602 = yylhsminor.yy602;
        break;
      case 145: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy602 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy602, &yymsp[-2].minor.yy179, yymsp[0].minor.yy602); }
  yymsp[-5].minor.yy602 = yylhsminor.yy602;
        break;
      case 147: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 150: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==150);
      case 427: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==427);
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-1].minor.yy874, yymsp[0].minor.yy602); }
  yymsp[-1].minor.yy874 = yylhsminor.yy874;
        break;
      case 148: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy602 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy767, yymsp[-8].minor.yy602, yymsp[-6].minor.yy602, yymsp[-5].minor.yy874, yymsp[-2].minor.yy874, yymsp[0].minor.yy602); }
  yymsp[-9].minor.yy602 = yylhsminor.yy602;
        break;
      case 151: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy602 = createDropTableClause(pCxt, yymsp[-1].minor.yy767, yymsp[0].minor.yy602); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 152: /* specific_cols_opt ::= */
      case 183: /* tags_def_opt ::= */ yytestcase(yyruleno==183);
      case 255: /* tag_list_opt ::= */ yytestcase(yyruleno==255);
      case 306: /* col_list_opt ::= */ yytestcase(yyruleno==306);
      case 490: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==490);
      case 513: /* group_by_clause_opt ::= */ yytestcase(yyruleno==513);
      case 532: /* order_by_clause_opt ::= */ yytestcase(yyruleno==532);
{ yymsp[1].minor.yy874 = NULL; }
        break;
      case 153: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 307: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==307);
{ yymsp[-2].minor.yy874 = yymsp[-1].minor.yy874; }
        break;
      case 154: /* full_table_name ::= table_name */
{ yylhsminor.yy602 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy179, NULL); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 155: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy602 = createRealTableNode(pCxt, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy179, NULL); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 158: /* column_def ::= column_name type_name */
{ yylhsminor.yy602 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy179, yymsp[0].minor.yy394, NULL); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 159: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy602 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy179, yymsp[-2].minor.yy394, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 160: /* type_name ::= BOOL */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 161: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 162: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 163: /* type_name ::= INT */
      case 164: /* type_name ::= INTEGER */ yytestcase(yyruleno==164);
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 165: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 166: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 167: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 168: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy394 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 169: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 170: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy394 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 171: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy394 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 172: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy394 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 173: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy394 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 174: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy394 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 175: /* type_name ::= JSON */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 176: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy394 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 177: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 178: /* type_name ::= BLOB */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 179: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy394 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 180: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy394 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy394 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 182: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy394 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 184: /* tags_def_opt ::= tags_def */
      case 419: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==419);
{ yylhsminor.yy874 = yymsp[0].minor.yy874; }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 185: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy874 = yymsp[-1].minor.yy874; }
        break;
      case 186: /* table_options ::= */
{ yymsp[1].minor.yy602 = createDefaultTableOptions(pCxt); }
        break;
      case 187: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy602 = setTableOption(pCxt, yymsp[-2].minor.yy602, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 188: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy602 = setTableOption(pCxt, yymsp[-2].minor.yy602, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 189: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy602 = setTableOption(pCxt, yymsp[-2].minor.yy602, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 190: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy602 = setTableOption(pCxt, yymsp[-4].minor.yy602, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy874); }
  yymsp[-4].minor.yy602 = yylhsminor.yy602;
        break;
      case 191: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy602 = setTableOption(pCxt, yymsp[-2].minor.yy602, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 192: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy602 = setTableOption(pCxt, yymsp[-4].minor.yy602, TABLE_OPTION_SMA, yymsp[-1].minor.yy874); }
  yymsp[-4].minor.yy602 = yylhsminor.yy602;
        break;
      case 193: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy602 = setTableOption(pCxt, yymsp[-2].minor.yy602, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy874); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 194: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy602 = createAlterTableOptions(pCxt); yylhsminor.yy602 = setTableOption(pCxt, yylhsminor.yy602, yymsp[0].minor.yy845.type, &yymsp[0].minor.yy845.val); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 195: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy602 = setTableOption(pCxt, yymsp[-1].minor.yy602, yymsp[0].minor.yy845.type, &yymsp[0].minor.yy845.val); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 196: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy845.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy845.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy845.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy845.val = yymsp[0].minor.yy0; }
        break;
      case 198: /* duration_list ::= duration_literal */
      case 383: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==383);
{ yylhsminor.yy874 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy602)); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 199: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 384: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==384);
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, releaseRawExprNode(pCxt, yymsp[0].minor.yy602)); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 202: /* rollup_func_name ::= function_name */
{ yylhsminor.yy602 = createFunctionNode(pCxt, &yymsp[0].minor.yy179, NULL); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 203: /* rollup_func_name ::= FIRST */
      case 204: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==204);
      case 259: /* tag_item ::= QTAGS */ yytestcase(yyruleno==259);
{ yylhsminor.yy602 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 207: /* col_name ::= column_name */
      case 260: /* tag_item ::= column_name */ yytestcase(yyruleno==260);
{ yylhsminor.yy602 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy179); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 208: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 209: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 210: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 211: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy602, yymsp[0].minor.yy602, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy602, yymsp[0].minor.yy602, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy602, NULL, OP_TYPE_LIKE); }
        break;
      case 215: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 217: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 218: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy602, yymsp[-1].minor.yy602, OP_TYPE_EQUAL); }
        break;
      case 219: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 220: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 221: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 222: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 223: /* cmd ::= SHOW LICENCES */
      case 224: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==224);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 225: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy179); }
        break;
      case 226: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy602); }
        break;
      case 227: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy602); }
        break;
      case 228: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 229: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 230: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 231: /* cmd ::= SHOW VARIABLES */
      case 232: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==232);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 234: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy602); }
        break;
      case 235: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 237: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 238: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 239: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy602); }
        break;
      case 240: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 241: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 242: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy602, yymsp[-1].minor.yy602, OP_TYPE_EQUAL); }
        break;
      case 243: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy602, yymsp[0].minor.yy602, yymsp[-3].minor.yy874); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 245: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 246: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy602,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 247: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 248: /* db_name_cond_opt ::= */
      case 253: /* from_db_opt ::= */ yytestcase(yyruleno==253);
{ yymsp[1].minor.yy602 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 249: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy602 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy179); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 250: /* like_pattern_opt ::= */
      case 315: /* subtable_opt ::= */ yytestcase(yyruleno==315);
      case 429: /* case_when_else_opt ::= */ yytestcase(yyruleno==429);
      case 459: /* from_clause_opt ::= */ yytestcase(yyruleno==459);
      case 488: /* where_clause_opt ::= */ yytestcase(yyruleno==488);
      case 497: /* twindow_clause_opt ::= */ yytestcase(yyruleno==497);
      case 503: /* sliding_opt ::= */ yytestcase(yyruleno==503);
      case 505: /* fill_opt ::= */ yytestcase(yyruleno==505);
      case 517: /* having_clause_opt ::= */ yytestcase(yyruleno==517);
      case 519: /* range_opt ::= */ yytestcase(yyruleno==519);
      case 521: /* every_opt ::= */ yytestcase(yyruleno==521);
      case 534: /* slimit_clause_opt ::= */ yytestcase(yyruleno==534);
      case 538: /* limit_clause_opt ::= */ yytestcase(yyruleno==538);
{ yymsp[1].minor.yy602 = NULL; }
        break;
      case 251: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 252: /* table_name_cond ::= table_name */
{ yylhsminor.yy602 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy179); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 254: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy602 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy179); }
        break;
      case 258: /* tag_item ::= TBNAME */
{ yylhsminor.yy602 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 261: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy602 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy179), &yymsp[0].minor.yy179); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 262: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy602 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy179), &yymsp[0].minor.yy179); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 263: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy767, yymsp[-3].minor.yy602, yymsp[-1].minor.yy602, NULL, yymsp[0].minor.yy602); }
        break;
      case 264: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy767, yymsp[-5].minor.yy602, yymsp[-3].minor.yy602, yymsp[-1].minor.yy874, NULL); }
        break;
      case 265: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy767, yymsp[0].minor.yy602); }
        break;
      case 266: /* full_index_name ::= index_name */
{ yylhsminor.yy602 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy179); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 267: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy602 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy179); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 268: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy602 = createIndexOption(pCxt, yymsp[-7].minor.yy874, releaseRawExprNode(pCxt, yymsp[-3].minor.yy602), NULL, yymsp[-1].minor.yy602, yymsp[0].minor.yy602); }
        break;
      case 269: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy602 = createIndexOption(pCxt, yymsp[-9].minor.yy874, releaseRawExprNode(pCxt, yymsp[-5].minor.yy602), releaseRawExprNode(pCxt, yymsp[-3].minor.yy602), yymsp[-1].minor.yy602, yymsp[0].minor.yy602); }
        break;
      case 272: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy602 = createFunctionNode(pCxt, &yymsp[-3].minor.yy179, yymsp[-1].minor.yy874); }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 278: /* sma_stream_opt ::= */
      case 308: /* stream_options ::= */ yytestcase(yyruleno==308);
{ yymsp[1].minor.yy602 = createStreamOptions(pCxt); }
        break;
      case 279: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 312: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==312);
{ ((SStreamOptions*)yymsp[-2].minor.yy602)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy602); yylhsminor.yy602 = yymsp[-2].minor.yy602; }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 280: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy602)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy602); yylhsminor.yy602 = yymsp[-2].minor.yy602; }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 281: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy602)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy602); yylhsminor.yy602 = yymsp[-2].minor.yy602; }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 282: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy767, &yymsp[-2].minor.yy179, yymsp[0].minor.yy602); }
        break;
      case 283: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy767, &yymsp[-3].minor.yy179, &yymsp[0].minor.yy179, false); }
        break;
      case 284: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy767, &yymsp[-5].minor.yy179, &yymsp[0].minor.yy179, true); }
        break;
      case 285: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy767, &yymsp[-3].minor.yy179, yymsp[0].minor.yy602, false); }
        break;
      case 286: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy767, &yymsp[-5].minor.yy179, yymsp[0].minor.yy602, true); }
        break;
      case 287: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy767, &yymsp[0].minor.yy179); }
        break;
      case 288: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy767, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy179); }
        break;
      case 289: /* cmd ::= DESC full_table_name */
      case 290: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==290);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy602); }
        break;
      case 291: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 292: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy767, yymsp[-1].minor.yy602, yymsp[0].minor.yy602); }
        break;
      case 295: /* explain_options ::= */
{ yymsp[1].minor.yy602 = createDefaultExplainOptions(pCxt); }
        break;
      case 296: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy602 = setExplainVerbose(pCxt, yymsp[-2].minor.yy602, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 297: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy602 = setExplainRatio(pCxt, yymsp[-2].minor.yy602, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 298: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy767, yymsp[-8].minor.yy767, &yymsp[-5].minor.yy179, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy394, yymsp[0].minor.yy820); }
        break;
      case 299: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy767, &yymsp[0].minor.yy179); }
        break;
      case 304: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy767, &yymsp[-8].minor.yy179, yymsp[-5].minor.yy602, yymsp[-7].minor.yy602, yymsp[-3].minor.yy874, yymsp[-2].minor.yy602, yymsp[0].minor.yy602, yymsp[-4].minor.yy874); }
        break;
      case 305: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy767, &yymsp[0].minor.yy179); }
        break;
      case 309: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy602)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy602 = yymsp[-2].minor.yy602; }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 310: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy602)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy602 = yymsp[-2].minor.yy602; }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 311: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy602)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy602)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy602); yylhsminor.yy602 = yymsp[-3].minor.yy602; }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 313: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy602)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy602 = yymsp[-3].minor.yy602; }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 314: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy602)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy602 = yymsp[-2].minor.yy602; }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 316: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 504: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==504);
      case 522: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==522);
{ yymsp[-3].minor.yy602 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy602); }
        break;
      case 317: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 318: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 319: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 320: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 321: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 322: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy874); }
        break;
      case 323: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 324: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy874 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 326: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy602, yymsp[0].minor.yy602); }
        break;
      case 328: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy602, yymsp[-2].minor.yy874, yymsp[0].minor.yy602); }
        break;
      case 329: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy602, NULL, yymsp[0].minor.yy602); }
        break;
      case 330: /* literal ::= NK_INTEGER */
{ yylhsminor.yy602 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 331: /* literal ::= NK_FLOAT */
{ yylhsminor.yy602 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 332: /* literal ::= NK_STRING */
{ yylhsminor.yy602 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 333: /* literal ::= NK_BOOL */
{ yylhsminor.yy602 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 334: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 335: /* literal ::= duration_literal */
      case 345: /* signed_literal ::= signed */ yytestcase(yyruleno==345);
      case 366: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==366);
      case 367: /* expression ::= literal */ yytestcase(yyruleno==367);
      case 368: /* expression ::= pseudo_column */ yytestcase(yyruleno==368);
      case 369: /* expression ::= column_reference */ yytestcase(yyruleno==369);
      case 370: /* expression ::= function_expression */ yytestcase(yyruleno==370);
      case 371: /* expression ::= case_when_expression */ yytestcase(yyruleno==371);
      case 402: /* function_expression ::= literal_func */ yytestcase(yyruleno==402);
      case 451: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==451);
      case 455: /* boolean_primary ::= predicate */ yytestcase(yyruleno==455);
      case 457: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==457);
      case 458: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==458);
      case 461: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==461);
      case 463: /* table_reference ::= table_primary */ yytestcase(yyruleno==463);
      case 464: /* table_reference ::= joined_table */ yytestcase(yyruleno==464);
      case 468: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==468);
      case 524: /* query_simple ::= query_specification */ yytestcase(yyruleno==524);
      case 525: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==525);
      case 528: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==528);
      case 530: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==530);
{ yylhsminor.yy602 = yymsp[0].minor.yy602; }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 336: /* literal ::= NULL */
{ yylhsminor.yy602 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 337: /* literal ::= NK_QUESTION */
{ yylhsminor.yy602 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 338: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy602 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 339: /* signed ::= NK_INTEGER */
{ yylhsminor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 340: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 341: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 342: /* signed ::= NK_FLOAT */
{ yylhsminor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 343: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 344: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 346: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 347: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 348: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 349: /* signed_literal ::= duration_literal */
      case 351: /* signed_literal ::= literal_func */ yytestcase(yyruleno==351);
      case 422: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==422);
      case 484: /* select_item ::= common_expression */ yytestcase(yyruleno==484);
      case 494: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==494);
      case 529: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==529);
      case 531: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==531);
      case 544: /* search_condition ::= common_expression */ yytestcase(yyruleno==544);
{ yylhsminor.yy602 = releaseRawExprNode(pCxt, yymsp[0].minor.yy602); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 350: /* signed_literal ::= NULL */
{ yylhsminor.yy602 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 352: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy602 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 372: /* expression ::= NK_LP expression NK_RP */
      case 456: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==456);
      case 543: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==543);
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy602)); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 373: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy602));
                                                                                  }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 374: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy602), NULL));
                                                                                  }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 375: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602))); 
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 376: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602))); 
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 377: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602))); 
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 378: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602))); 
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 379: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602)));
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 380: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 381: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602)));
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 382: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602)));
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 385: /* column_reference ::= column_name */
{ yylhsminor.yy602 = createRawExprNode(pCxt, &yymsp[0].minor.yy179, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy179)); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 386: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy179, createColumnNode(pCxt, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy179)); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 387: /* pseudo_column ::= ROWTS */
      case 388: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==388);
      case 390: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==390);
      case 391: /* pseudo_column ::= QEND */ yytestcase(yyruleno==391);
      case 392: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==392);
      case 393: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==393);
      case 394: /* pseudo_column ::= WEND */ yytestcase(yyruleno==394);
      case 395: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==395);
      case 396: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==396);
      case 397: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==397);
      case 398: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==398);
      case 404: /* literal_func ::= NOW */ yytestcase(yyruleno==404);
{ yylhsminor.yy602 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 389: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy179)))); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 399: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 400: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==400);
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy179, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy179, yymsp[-1].minor.yy874)); }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 401: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy602), yymsp[-1].minor.yy394)); }
  yymsp[-5].minor.yy602 = yylhsminor.yy602;
        break;
      case 403: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy179, NULL)); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 418: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy874 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 423: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 487: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==487);
{ yylhsminor.yy602 = createColumnNode(pCxt, &yymsp[-2].minor.yy179, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 424: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy874, yymsp[-1].minor.yy602)); }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 425: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy602), yymsp[-2].minor.yy874, yymsp[-1].minor.yy602)); }
  yymsp[-4].minor.yy602 = yylhsminor.yy602;
        break;
      case 428: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy602 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602)); }
        break;
      case 430: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy602 = releaseRawExprNode(pCxt, yymsp[0].minor.yy602); }
        break;
      case 431: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 436: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==436);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy290, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602)));
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 432: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy602), releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602)));
                                                                                  }
  yymsp[-4].minor.yy602 = yylhsminor.yy602;
        break;
      case 433: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy602), releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602)));
                                                                                  }
  yymsp[-5].minor.yy602 = yylhsminor.yy602;
        break;
      case 434: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), NULL));
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 435: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy602), NULL));
                                                                                  }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 437: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy290 = OP_TYPE_LOWER_THAN; }
        break;
      case 438: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy290 = OP_TYPE_GREATER_THAN; }
        break;
      case 439: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy290 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 440: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy290 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 441: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy290 = OP_TYPE_NOT_EQUAL; }
        break;
      case 442: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy290 = OP_TYPE_EQUAL; }
        break;
      case 443: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy290 = OP_TYPE_LIKE; }
        break;
      case 444: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy290 = OP_TYPE_NOT_LIKE; }
        break;
      case 445: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy290 = OP_TYPE_MATCH; }
        break;
      case 446: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy290 = OP_TYPE_NMATCH; }
        break;
      case 447: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy290 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 448: /* in_op ::= IN */
{ yymsp[0].minor.yy290 = OP_TYPE_IN; }
        break;
      case 449: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy290 = OP_TYPE_NOT_IN; }
        break;
      case 450: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy874)); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 452: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy602), NULL));
                                                                                  }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 453: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602)));
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 454: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy602);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy602);
                                                                                    yylhsminor.yy602 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), releaseRawExprNode(pCxt, yymsp[0].minor.yy602)));
                                                                                  }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 460: /* from_clause_opt ::= FROM table_reference_list */
      case 489: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==489);
      case 518: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==518);
{ yymsp[-1].minor.yy602 = yymsp[0].minor.yy602; }
        break;
      case 462: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy602 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy602, yymsp[0].minor.yy602, NULL); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 465: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy602 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy179, &yymsp[0].minor.yy179); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 466: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy602 = createRealTableNode(pCxt, &yymsp[-3].minor.yy179, &yymsp[-1].minor.yy179, &yymsp[0].minor.yy179); }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 467: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy602 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy602), &yymsp[0].minor.yy179); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 469: /* alias_opt ::= */
{ yymsp[1].minor.yy179 = nil_token;  }
        break;
      case 471: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy179 = yymsp[0].minor.yy179; }
        break;
      case 472: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 473: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==473);
{ yymsp[-2].minor.yy602 = yymsp[-1].minor.yy602; }
        break;
      case 474: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy602 = createJoinTableNode(pCxt, yymsp[-4].minor.yy42, yymsp[-5].minor.yy602, yymsp[-2].minor.yy602, yymsp[0].minor.yy602); }
  yymsp[-5].minor.yy602 = yylhsminor.yy602;
        break;
      case 475: /* join_type ::= */
{ yymsp[1].minor.yy42 = JOIN_TYPE_INNER; }
        break;
      case 476: /* join_type ::= INNER */
{ yymsp[0].minor.yy42 = JOIN_TYPE_INNER; }
        break;
      case 477: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy602 = createSelectStmt(pCxt, yymsp[-10].minor.yy767, yymsp[-9].minor.yy874, yymsp[-8].minor.yy602);
                                                                                    yymsp[-11].minor.yy602 = addWhereClause(pCxt, yymsp[-11].minor.yy602, yymsp[-7].minor.yy602);
                                                                                    yymsp[-11].minor.yy602 = addPartitionByClause(pCxt, yymsp[-11].minor.yy602, yymsp[-6].minor.yy874);
                                                                                    yymsp[-11].minor.yy602 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy602, yymsp[-2].minor.yy602);
                                                                                    yymsp[-11].minor.yy602 = addGroupByClause(pCxt, yymsp[-11].minor.yy602, yymsp[-1].minor.yy874);
                                                                                    yymsp[-11].minor.yy602 = addHavingClause(pCxt, yymsp[-11].minor.yy602, yymsp[0].minor.yy602);
                                                                                    yymsp[-11].minor.yy602 = addRangeClause(pCxt, yymsp[-11].minor.yy602, yymsp[-5].minor.yy602);
                                                                                    yymsp[-11].minor.yy602 = addEveryClause(pCxt, yymsp[-11].minor.yy602, yymsp[-4].minor.yy602);
                                                                                    yymsp[-11].minor.yy602 = addFillClause(pCxt, yymsp[-11].minor.yy602, yymsp[-3].minor.yy602);
                                                                                  }
        break;
      case 480: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy767 = false; }
        break;
      case 483: /* select_item ::= NK_STAR */
{ yylhsminor.yy602 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy602 = yylhsminor.yy602;
        break;
      case 485: /* select_item ::= common_expression column_alias */
      case 495: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==495);
{ yylhsminor.yy602 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy602), &yymsp[0].minor.yy179); }
  yymsp[-1].minor.yy602 = yylhsminor.yy602;
        break;
      case 486: /* select_item ::= common_expression AS column_alias */
      case 496: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==496);
{ yylhsminor.yy602 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), &yymsp[0].minor.yy179); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 491: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 514: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==514);
      case 533: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==533);
{ yymsp[-2].minor.yy874 = yymsp[0].minor.yy874; }
        break;
      case 498: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy602 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy602), releaseRawExprNode(pCxt, yymsp[-1].minor.yy602)); }
        break;
      case 499: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy602 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy602)); }
        break;
      case 500: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy602 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy602), NULL, yymsp[-1].minor.yy602, yymsp[0].minor.yy602); }
        break;
      case 501: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy602 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy602), releaseRawExprNode(pCxt, yymsp[-3].minor.yy602), yymsp[-1].minor.yy602, yymsp[0].minor.yy602); }
        break;
      case 502: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy602 = createEventWindowNode(pCxt, yymsp[-3].minor.yy602, yymsp[0].minor.yy602); }
        break;
      case 506: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy602 = createFillNode(pCxt, yymsp[-1].minor.yy324, NULL); }
        break;
      case 507: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy602 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy874)); }
        break;
      case 508: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy324 = FILL_MODE_NONE; }
        break;
      case 509: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy324 = FILL_MODE_PREV; }
        break;
      case 510: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy324 = FILL_MODE_NULL; }
        break;
      case 511: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy324 = FILL_MODE_LINEAR; }
        break;
      case 512: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy324 = FILL_MODE_NEXT; }
        break;
      case 515: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy874 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy602))); }
  yymsp[0].minor.yy874 = yylhsminor.yy874;
        break;
      case 516: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy874 = addNodeToList(pCxt, yymsp[-2].minor.yy874, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy602))); }
  yymsp[-2].minor.yy874 = yylhsminor.yy874;
        break;
      case 520: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy602 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy602), releaseRawExprNode(pCxt, yymsp[-1].minor.yy602)); }
        break;
      case 523: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy602 = addOrderByClause(pCxt, yymsp[-3].minor.yy602, yymsp[-2].minor.yy874);
                                                                                    yylhsminor.yy602 = addSlimitClause(pCxt, yylhsminor.yy602, yymsp[-1].minor.yy602);
                                                                                    yylhsminor.yy602 = addLimitClause(pCxt, yylhsminor.yy602, yymsp[0].minor.yy602);
                                                                                  }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 526: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy602 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy602, yymsp[0].minor.yy602); }
  yymsp[-3].minor.yy602 = yylhsminor.yy602;
        break;
      case 527: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy602 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy602, yymsp[0].minor.yy602); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 535: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 539: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==539);
{ yymsp[-1].minor.yy602 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 536: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 540: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==540);
{ yymsp[-3].minor.yy602 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 537: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 541: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==541);
{ yymsp[-3].minor.yy602 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 542: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy602 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy602); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 547: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy602 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy602), yymsp[-1].minor.yy878, yymsp[0].minor.yy487); }
  yymsp[-2].minor.yy602 = yylhsminor.yy602;
        break;
      case 548: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy878 = ORDER_ASC; }
        break;
      case 549: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy878 = ORDER_ASC; }
        break;
      case 550: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy878 = ORDER_DESC; }
        break;
      case 551: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy487 = NULL_ORDER_DEFAULT; }
        break;
      case 552: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy487 = NULL_ORDER_FIRST; }
        break;
      case 553: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy487 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
