/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 361
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EFillMode yy18;
  SAlterOption yy25;
  SToken yy53;
  EOperatorType yy136;
  int32_t yy158;
  ENullOrder yy185;
  SNodeList* yy236;
  EJoinType yy342;
  EOrder yy430;
  int64_t yy435;
  SDataType yy450;
  bool yy603;
  SNode* yy636;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             611
#define YYNRULE              455
#define YYNTOKEN             240
#define YY_MAX_SHIFT         610
#define YY_MIN_SHIFTREDUCE   901
#define YY_MAX_SHIFTREDUCE   1355
#define YY_ERROR_ACTION      1356
#define YY_ACCEPT_ACTION     1357
#define YY_NO_ACTION         1358
#define YY_MIN_REDUCE        1359
#define YY_MAX_REDUCE        1813
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2153)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   386, 1647,  387, 1391,  295,  394,  524,  387, 1391,   28,
 /*    10 */   226,  931,   35,   33,  130, 1676, 1371, 1660,  104, 1791,
 /*    20 */   304, 1644, 1169,  477,  523,  424,   36,   34,   32,   31,
 /*    30 */    30,  385, 1790,   62,  389, 1490, 1788, 1640, 1646,   36,
 /*    40 */    34,   32,   31,   30, 1535, 1676,  108, 1167,  527,  935,
 /*    50 */   936,  294, 1000,  508,  524, 1485, 1533,  154,   14,  476,
 /*    60 */    35,   33, 1296,  507, 1175,   24,  350, 1630,  304, 1002,
 /*    70 */  1169, 1418,  277,  488,  523,   36,   34,   32,   31,   30,
 /*    80 */    56,    1,   60, 1490, 1689,   59,  524,   80, 1661,  510,
 /*    90 */  1663, 1664,  506, 1359,  527, 1167, 1207, 1729,  104,  603,
 /*   100 */   602,  276, 1725,  607, 1258,  429,   14,   36,   34,   32,
 /*   110 */    31,   30, 1175, 1791, 1168, 1490,  140,  103,  102,  101,
 /*   120 */   100,   99,   98,   97,   96,   95,  147,  376, 1529,    2,
 /*   130 */  1788,  583,  582,  581,  319,   39,  580,  579,  578,  114,
 /*   140 */   573,  572,  571,  570,  569,  568,  567,  566,  121,  562,
 /*   150 */   511,  607, 1568,  307, 1259,   55, 1580,   55, 1170,  156,
 /*   160 */    94, 1791, 1168,   93,   92,   91,   90,   89,   88,   87,
 /*   170 */    86,   85,  158,  157,  146,  352, 1264, 1352, 1788,  393,
 /*   180 */  1173, 1174,  389, 1220, 1221, 1223, 1224, 1225, 1226, 1227,
 /*   190 */   503,  525, 1235, 1236, 1237, 1238, 1239, 1240, 1468,   36,
 /*   200 */    34,   32,   31,   30,   64,  292, 1170,  131,  191,  274,
 /*   210 */   148, 1447,   27,  302, 1253, 1254, 1255, 1256, 1257, 1261,
 /*   220 */  1262, 1263, 1421,   36,   34,   32,   31,   30, 1173, 1174,
 /*   230 */   484, 1220, 1221, 1223, 1224, 1225, 1226, 1227,  503,  525,
 /*   240 */  1235, 1236, 1237, 1238, 1239, 1240,   35,   33, 1467,  948,
 /*   250 */    70,  947,  438,  437,  304,  403, 1169,  436, 1351,  112,
 /*   260 */   109,  433,  308, 1791,  432,  431,  430,   35,   33, 1310,
 /*   270 */   128, 1483, 1660,  403,  523,  304, 1789, 1169,  949, 1492,
 /*   280 */  1788, 1167,  438,  437,  148, 1193,  148,  436,   62,  972,
 /*   290 */   109,  433,   14, 1207,  432,  431,  430,  110, 1175, 1360,
 /*   300 */  1676, 1303, 1167, 1382, 1660,  524,  973, 1193,  508,  524,
 /*   310 */  1486,  486,  142, 1736, 1737,    2, 1741,  351,  507, 1175,
 /*   320 */    94,  361, 1630,   93,   92,   91,   90,   89,   88,   87,
 /*   330 */    86,   85, 1676, 1381, 1490,   38,    8,  607, 1490, 1689,
 /*   340 */   487,  559,   82, 1661,  510, 1663, 1664,  506, 1168,  527,
 /*   350 */   507, 1191, 1729, 1630, 1630, 1535, 1728, 1725,  607,  128,
 /*   360 */   558,  557,  309,  556,  555,  554, 1380, 1533, 1493, 1168,
 /*   370 */   565, 1689, 1462, 1535,   81, 1661,  510, 1663, 1664,  506,
 /*   380 */   315,  527,  524, 1630, 1729, 1533, 1743,   26,  297, 1725,
 /*   390 */   141,  478, 1170,   54,  362,  435,  434,   36,   34,   32,
 /*   400 */    31,   30,  218,   36,   34,   32,   31,   30,  466, 1756,
 /*   410 */  1740, 1490,   55, 1170, 1173, 1174, 1630, 1220, 1221, 1223,
 /*   420 */  1224, 1225, 1226, 1227,  503,  525, 1235, 1236, 1237, 1238,
 /*   430 */  1239, 1240,  460,  577,  575, 1173, 1174, 1379, 1220, 1221,
 /*   440 */  1223, 1224, 1225, 1226, 1227,  503,  525, 1235, 1236, 1237,
 /*   450 */  1238, 1239, 1240,   35,   33, 1241, 1378,  443, 1195,  610,
 /*   460 */   316,  304, 1377, 1169,  148,  148,  249, 1571, 1573, 1520,
 /*   470 */  1246, 1222,  451,  243,   35,   33, 1193, 1481, 1376, 1660,
 /*   480 */  1647,  461,  304,  312, 1169,  105,  190, 1630, 1167,  524,
 /*   490 */   473,  599,  595,  591,  587,  242,  391, 1644,  446, 1357,
 /*   500 */  1644,  402, 1191,  440,  561, 1175, 1630, 1676,  189, 1167,
 /*   510 */   337,  484, 1630, 1640, 1646,  508, 1640, 1646, 1490,  484,
 /*   520 */    78, 1791,    9,  237,  527,  507, 1175,  527, 1630, 1630,
 /*   530 */   339,  335,  564,   51,  145,  488,   50,  127, 1788,  511,
 /*   540 */   112,  148,  576,    9,  607, 1581, 1689, 1194,  112,   80,
 /*   550 */  1661,  510, 1663, 1664,  506, 1168,  527,  520,  320, 1729,
 /*   560 */  1375,  479,  474,  276, 1725,  607,   36,   34,   32,   31,
 /*   570 */    30, 1648, 1130,  314, 1479, 1791, 1168,  428,  110,  553,
 /*   580 */  1132,  128,  465,  340,  217,  198,  110, 1465,  145,   55,
 /*   590 */  1492, 1644, 1788,  143, 1736, 1737,   77, 1741, 1791, 1170,
 /*   600 */   427,  144, 1736, 1737, 1146, 1741,  193, 1640, 1646,  113,
 /*   610 */  1630,  145,  277, 1572, 1573, 1788,  490, 1482,  527, 1295,
 /*   620 */  1170, 1173, 1174, 1374, 1220, 1221, 1223, 1224, 1225, 1226,
 /*   630 */  1227,  503,  525, 1235, 1236, 1237, 1238, 1239, 1240,  286,
 /*   640 */  1222, 1131, 1173, 1174, 1258, 1220, 1221, 1223, 1224, 1225,
 /*   650 */  1226, 1227,  503,  525, 1235, 1236, 1237, 1238, 1239, 1240,
 /*   660 */    35,   33,  273,  559, 1191,  345, 1320,  344,  304,  524,
 /*   670 */  1169,  369,  524, 1630,  381,   32,   31,   30, 1748, 1291,
 /*   680 */   559, 1487,  558,  557, 1610,  556,  555,  554,  287,    7,
 /*   690 */   285,  284,  382,  426, 1259, 1167,  947,  428, 1490,  558,
 /*   700 */   557, 1490,  556,  555,  554,  470, 1318, 1319, 1321, 1322,
 /*   710 */  1535,  317, 1175,   11,   10, 1373, 1264, 1743,  148,  128,
 /*   720 */   427,  422, 1534,  935,  936, 1743, 1154, 1155, 1492,    2,
 /*   730 */  1038,  550,  549,  548, 1042,  547, 1044, 1045,  546, 1047,
 /*   740 */   543, 1739, 1053,  540, 1055, 1056,  537,  534,  346, 1738,
 /*   750 */  1370,  607,   27,  302, 1253, 1254, 1255, 1256, 1257, 1261,
 /*   760 */  1262, 1263, 1168,  380, 1466, 1630,  375,  374,  373,  372,
 /*   770 */   371,  368,  367,  366,  365,  364,  360,  359,  358,  357,
 /*   780 */   356,  355,  354,  353,  524,  524,  129,  524, 1791, 1196,
 /*   790 */   492,  255, 1192, 1193, 1272, 1260,  521,  522, 1475,  239,
 /*   800 */  1630,  145, 1369,  253,   53, 1788, 1170,   52, 1368, 1367,
 /*   810 */  1366,  452, 1365, 1490, 1490, 1364, 1490, 1265,  524, 1363,
 /*   820 */  1660,  561, 1362,   47,  159,  275, 1294, 1477, 1173, 1174,
 /*   830 */   318, 1220, 1221, 1223, 1224, 1225, 1226, 1227,  503,  525,
 /*   840 */  1235, 1236, 1237, 1238, 1239, 1240,  495, 1490, 1676,   55,
 /*   850 */  1473, 1791, 1630,   25, 1619,  194,  487, 1408, 1630, 1630,
 /*   860 */  1630, 1291, 1630, 1403,  145, 1630,  507, 1401, 1788, 1630,
 /*   870 */  1630,  182, 1630,  184,  180,  186,  183,  188,  185,  439,
 /*   880 */   187, 1660,  500,  450,  502,  441,   79, 1689,   76,  444,
 /*   890 */    81, 1661,  510, 1663, 1664,  506,  448,  527,   72,  327,
 /*   900 */  1729,   11,   10,  552,  297, 1725,  141, 1372,  459, 1676,
 /*   910 */  1354, 1355, 1650, 1448, 1660,  202, 1178,  508,   58,   57,
 /*   920 */   349,  118,   46,  153,  471, 1757, 1177,  507,  343,  205,
 /*   930 */   221, 1630,   37,   37,   37,  453,  212, 1677, 1392,  228,
 /*   940 */   272,  421, 1676,  333, 1530,  329,  325,  150, 1689, 1652,
 /*   950 */   508,   81, 1661,  510, 1663, 1664,  506, 1222,  527, 1759,
 /*   960 */   507, 1729,  462, 1317, 1630,  297, 1725, 1804, 1191,  116,
 /*   970 */   207,  117,  485, 1266, 1228, 1124, 1763,  493,  148, 1660,
 /*   980 */   230, 1689,  220, 1181,   81, 1661,  510, 1663, 1664,  506,
 /*   990 */   223,  527,  118, 1180, 1729, 1660,   46,  532,  297, 1725,
 /*  1000 */  1804,  322,  117,  225, 1250,    3,  118, 1676,  326, 1786,
 /*  1010 */   516,  282,  236, 1000,  283,  508,  119,  117,  244,  155,
 /*  1020 */  1138,  363,  370, 1676, 1570,  507,  378, 1660,  377, 1630,
 /*  1030 */   379,  508,  383, 1031, 1197,  496,  384,  248, 1059,  392,
 /*  1040 */  1200,  507,  395, 1063,  162, 1630, 1689, 1070,  396,   82,
 /*  1050 */  1661,  510, 1663, 1664,  506, 1676,  527, 1068,  120, 1729,
 /*  1060 */  1199,  164, 1689,  508, 1726,   81, 1661,  510, 1663, 1664,
 /*  1070 */   506, 1201,  527,  507,  397, 1729,  398, 1630, 1660,  297,
 /*  1080 */  1725, 1804,  167,  488,  399,  169, 1198,  400,  401,  172,
 /*  1090 */  1747,   61,  404, 1660, 1689,  175,  423,  262, 1661,  510,
 /*  1100 */  1663, 1664,  506,  425,  527,   84, 1676, 1175, 1480,  179,
 /*  1110 */  1476,  291,  181, 1614,  508,  122,  123, 1478, 1474,  124,
 /*  1120 */   125, 1676,  245, 1791,  507,  192,  455,  195, 1630,  508,
 /*  1130 */   246,  197,  454,  464,  488,  463,  147,  200, 1196,  507,
 /*  1140 */  1788,  458,  472, 1630, 1660, 1689, 1770,  203,  262, 1661,
 /*  1150 */   510, 1663, 1664,  506,  514,  527,    6, 1750,  469, 1769,
 /*  1160 */  1689,  211,  481,   82, 1661,  510, 1663, 1664,  506,  206,
 /*  1170 */   527, 1760, 1676, 1729, 1791,  296,  475,  499, 1725, 1195,
 /*  1180 */   505,  468,    5, 1291,  111,   40,  497,  145, 1744, 1807,
 /*  1190 */   507, 1788,  298,   18, 1630,  512, 1660,  513,  494,  306,
 /*  1200 */   311,  310, 1579,  135, 1578, 1660,  214,  517,  518,  519,
 /*  1210 */  1183, 1689,  213, 1787,  270, 1661,  510, 1663, 1664,  506,
 /*  1220 */   504,  527,  501, 1701, 1676,  219,  232,   71,  491, 1710,
 /*  1230 */   234,  247,  508, 1676,   69, 1176,  250, 1491,  241,  222,
 /*  1240 */   606,  508,  507, 1463,  498,   48, 1630,  530,  224,  256,
 /*  1250 */   134,  507, 1175, 1660,  263, 1630,  257,  293,  467,  252,
 /*  1260 */   254, 1624, 1623, 1689,  321, 1620,  132, 1661,  510, 1663,
 /*  1270 */  1664,  506, 1689,  527,  323,  271, 1661,  510, 1663, 1664,
 /*  1280 */   506, 1676,  527,  324, 1163, 1660, 1164,  151, 1618,  508,
 /*  1290 */   328,  528,  330,  331, 1617,  332,  334, 1616,  336,  507,
 /*  1300 */  1615,  338, 1179, 1630, 1600,  152,  341, 1141,  342, 1140,
 /*  1310 */   489, 1805, 1594, 1676, 1593,  347,  348, 1660, 1592, 1591,
 /*  1320 */  1689,  508, 1107,  266, 1661,  510, 1663, 1664,  506, 1563,
 /*  1330 */   527,  507, 1562, 1561, 1560, 1630, 1559, 1558, 1557, 1556,
 /*  1340 */  1555, 1554, 1553, 1552, 1551, 1676, 1184, 1550, 1549, 1548,
 /*  1350 */  1547, 1546, 1689,  508, 1545,  132, 1661,  510, 1663, 1664,
 /*  1360 */   506,  480,  527,  507,  115, 1660, 1544, 1630, 1187, 1543,
 /*  1370 */   301, 1542, 1541, 1540, 1109, 1539, 1538, 1537, 1660,  525,
 /*  1380 */  1235, 1236, 1536, 1420, 1689, 1388,  160,  271, 1661,  510,
 /*  1390 */  1663, 1664,  506, 1676,  527,  938,  106,  138,  937,  388,
 /*  1400 */  1806,  505, 1387,  161,  390,  107, 1676, 1608, 1602, 1586,
 /*  1410 */  1585,  507, 1576, 1469,  508, 1630,  166,  171, 1660, 1419,
 /*  1420 */   966, 1417, 1415,  407,  507,  405, 1413,  411, 1630,  415,
 /*  1430 */  1411,  303, 1689,  419,  406,  270, 1661,  510, 1663, 1664,
 /*  1440 */   506,  409,  527,  410, 1702, 1689, 1676,  413,  271, 1661,
 /*  1450 */   510, 1663, 1664,  506,  508,  527,  414, 1400,  177, 1399,
 /*  1460 */   418,  417, 1386, 1471,  507, 1074, 1660, 1470, 1630, 1073,
 /*  1470 */   139,  305,  574,  576,  999, 1169,  420,  416,  412,  408,
 /*  1480 */   176,   45,  998,  178,  997, 1689,  996,  993,  271, 1661,
 /*  1490 */   510, 1663, 1664,  506, 1676,  527,  992,  991, 1409,  288,
 /*  1500 */  1167, 1404,  508,  289,  442,   63, 1402,  290,  174, 1385,
 /*  1510 */   447,  445,  507, 1384,  449,   83, 1630, 1175, 1607, 1148,
 /*  1520 */    49, 1601,  456, 1660, 1584,  126, 1583, 1575,  199,   65,
 /*  1530 */   196,    4,  133, 1689,  201,   37,  258, 1661,  510, 1663,
 /*  1540 */  1664,  506,  204,  527,   15,  457,   43, 1316, 1309,  208,
 /*  1550 */    22, 1676,  209,   23,  210,   66,  607, 1288, 1650,  508,
 /*  1560 */  1287,  216, 1345,   42,  136,   41,  173, 1168,  165,  507,
 /*  1570 */   170, 1660,  168, 1630,   17, 1340, 1339,   16,   13, 1334,
 /*  1580 */    10,  299, 1344, 1343,  300, 1251,   19,  137,  149, 1230,
 /*  1590 */  1689,  163, 1215,  265, 1661,  510, 1663, 1664,  506, 1676,
 /*  1600 */   527, 1660,  509, 1574,   29,  515,   12,  508, 1649,  233,
 /*  1610 */    72, 1170, 1229,   20,  235, 1185,  531,  507,  238,   21,
 /*  1620 */   229, 1630,  227,  529, 1314,  964,  313,  231,   67, 1676,
 /*  1630 */    68, 1660, 1692, 1173, 1174, 1232,  526,  508, 1689,   44,
 /*  1640 */   533,  267, 1661,  510, 1663, 1664,  506,  507,  527, 1060,
 /*  1650 */  1057, 1630,  535,  538,  536,  541,  544, 1054,  539, 1676,
 /*  1660 */  1037, 1052, 1048,  542, 1069, 1046,  545,  508, 1689,  551,
 /*  1670 */  1051,  259, 1661,  510, 1663, 1664,  506,  507,  527, 1660,
 /*  1680 */    73, 1630,   74,   75, 1066, 1065, 1050,  560, 1660, 1049,
 /*  1690 */   988, 1006,  563,  240,  986,  985,  984,  983, 1689,  981,
 /*  1700 */  1067,  268, 1661,  510, 1663, 1664,  506, 1676,  527,  982,
 /*  1710 */  1003,  980,  979, 1001,  976,  508, 1676,  975,  974,  971,
 /*  1720 */   970,  969, 1416,  584,  508,  507,  585,  586, 1414, 1630,
 /*  1730 */   588,  589,  590, 1412,  507,  592, 1660,  593, 1630,  594,
 /*  1740 */  1410,  596,  597,  598, 1398,  600, 1689,  601, 1397,  260,
 /*  1750 */  1661,  510, 1663, 1664,  506, 1689,  527, 1383,  269, 1661,
 /*  1760 */   510, 1663, 1664,  506, 1676,  527,  609,  604,  605, 1358,
 /*  1770 */  1358, 1171,  508,  251,  608, 1358, 1358, 1358, 1358, 1358,
 /*  1780 */  1358, 1358,  507, 1358, 1660, 1358, 1630, 1358, 1358, 1358,
 /*  1790 */  1358, 1358, 1358, 1358, 1358, 1660, 1358, 1358, 1358, 1358,
 /*  1800 */  1358, 1358, 1358, 1689, 1358, 1358,  261, 1661,  510, 1663,
 /*  1810 */  1664,  506, 1676,  527, 1660, 1358, 1358, 1358, 1358, 1358,
 /*  1820 */   508, 1358, 1358, 1676, 1358, 1358, 1358, 1358, 1358, 1358,
 /*  1830 */   507,  508, 1358, 1358, 1630, 1358, 1358, 1358, 1358, 1358,
 /*  1840 */  1358,  507, 1676, 1358, 1358, 1630, 1358, 1358, 1358, 1358,
 /*  1850 */   508, 1689, 1358, 1358, 1672, 1661,  510, 1663, 1664,  506,
 /*  1860 */   507,  527, 1689, 1358, 1630, 1671, 1661,  510, 1663, 1664,
 /*  1870 */   506, 1358,  527, 1660, 1358, 1358, 1358, 1358, 1358, 1358,
 /*  1880 */  1358, 1689, 1660, 1358, 1670, 1661,  510, 1663, 1664,  506,
 /*  1890 */  1358,  527, 1358, 1358, 1358, 1358, 1358, 1358, 1358, 1358,
 /*  1900 */  1358, 1676, 1358, 1358, 1358, 1358, 1358, 1358, 1358,  508,
 /*  1910 */  1676, 1358, 1358, 1358, 1358, 1358, 1358, 1358,  508,  507,
 /*  1920 */  1358, 1358, 1358, 1630, 1358, 1358, 1358, 1358,  507, 1358,
 /*  1930 */  1358, 1358, 1630, 1358, 1358, 1358, 1358, 1358, 1358, 1358,
 /*  1940 */  1689, 1358, 1660,  280, 1661,  510, 1663, 1664,  506, 1689,
 /*  1950 */   527, 1660,  279, 1661,  510, 1663, 1664,  506, 1358,  527,
 /*  1960 */  1358, 1358, 1358, 1358, 1358, 1358, 1358, 1358, 1358, 1358,
 /*  1970 */  1676, 1358, 1358, 1358, 1358, 1358, 1358, 1358,  508, 1676,
 /*  1980 */  1358, 1358, 1358, 1358, 1358, 1358, 1358,  508,  507, 1358,
 /*  1990 */  1358, 1358, 1630, 1358, 1358, 1358, 1358,  507, 1358, 1660,
 /*  2000 */  1358, 1630, 1358, 1358, 1358, 1358, 1358, 1358, 1358, 1689,
 /*  2010 */   484, 1358,  281, 1661,  510, 1663, 1664,  506, 1689,  527,
 /*  2020 */  1358,  278, 1661,  510, 1663, 1664,  506, 1676,  527, 1358,
 /*  2030 */  1358, 1358, 1358, 1358, 1358,  508, 1358, 1358, 1358,  112,
 /*  2040 */  1358, 1358, 1358, 1358, 1358,  507,  484, 1358, 1358, 1630,
 /*  2050 */  1358, 1358, 1358, 1358, 1358, 1358, 1358, 1358, 1358,  488,
 /*  2060 */  1358, 1358, 1358, 1358, 1358, 1358, 1689, 1358, 1358,  264,
 /*  2070 */  1661,  510, 1663, 1664,  506,  112,  527,  110, 1358, 1358,
 /*  2080 */  1358, 1358, 1358, 1358, 1358, 1358, 1358, 1358, 1358, 1358,
 /*  2090 */  1358, 1358,  215, 1736,  483,  488,  482, 1358, 1358, 1791,
 /*  2100 */  1358, 1358, 1358, 1358, 1358, 1358, 1358, 1358, 1358, 1358,
 /*  2110 */  1358, 1358,  147,  110, 1358, 1358, 1788, 1358, 1358, 1358,
 /*  2120 */  1358, 1358, 1358, 1358, 1358, 1358, 1358, 1358,  215, 1736,
 /*  2130 */   483, 1358,  482, 1358, 1358, 1791, 1358, 1358, 1358, 1358,
 /*  2140 */  1358, 1358, 1358, 1358, 1358, 1358, 1358, 1358,  145, 1358,
 /*  2150 */  1358, 1358, 1788,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   246,  273,  248,  249,  276,  246,  250,  248,  249,  324,
 /*    10 */   325,    4,   12,   13,  242,  271,  244,  243,  262,  339,
 /*    20 */    20,  293,   22,  279,   20,  269,   12,   13,   14,   15,
 /*    30 */    16,  247,  352,  255,  250,  279,  356,  309,  310,   12,
 /*    40 */    13,   14,   15,   16,  271,  271,  268,   47,  320,   42,
 /*    50 */    43,  278,   47,  279,  250,  277,  283,   55,   58,  315,
 /*    60 */    12,   13,   14,  289,   64,    2,  262,  293,   20,   64,
 /*    70 */    22,    0,   58,  299,   20,   12,   13,   14,   15,   16,
 /*    80 */     4,   81,   80,  279,  310,   83,  250,  313,  314,  315,
 /*    90 */   316,  317,  318,    0,  320,   47,   82,  323,  262,  251,
 /*   100 */   252,  327,  328,  103,   90,  269,   58,   12,   13,   14,
 /*   110 */    15,   16,   64,  339,  114,  279,  270,   24,   25,   26,
 /*   120 */    27,   28,   29,   30,   31,   32,  352,   75,  282,   81,
 /*   130 */   356,   60,   61,   62,   63,   81,   65,   66,   67,   68,
 /*   140 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   150 */   289,  103,  279,  292,  140,   81,  295,   81,  158,  286,
 /*   160 */    21,  339,  114,   24,   25,   26,   27,   28,   29,   30,
 /*   170 */    31,   32,  120,  121,  352,  250,  162,  150,  356,  247,
 /*   180 */   180,  181,  250,  183,  184,  185,  186,  187,  188,  189,
 /*   190 */   190,  191,  192,  193,  194,  195,  196,  197,    0,   12,
 /*   200 */    13,   14,   15,   16,  167,  168,  158,  256,  171,  284,
 /*   210 */   210,  260,  198,  199,  200,  201,  202,  203,  204,  205,
 /*   220 */   206,  207,    0,   12,   13,   14,   15,   16,  180,  181,
 /*   230 */   250,  183,  184,  185,  186,  187,  188,  189,  190,  191,
 /*   240 */   192,  193,  194,  195,  196,  197,   12,   13,    0,   20,
 /*   250 */   253,   22,   60,   61,   20,   57,   22,   65,  231,  279,
 /*   260 */    68,   69,  263,  339,   72,   73,   74,   12,   13,   82,
 /*   270 */   271,  274,  243,   57,   20,   20,  352,   22,   49,  280,
 /*   280 */   356,   47,   60,   61,  210,   20,  210,   65,  255,   47,
 /*   290 */    68,   69,   58,   82,   72,   73,   74,  317,   64,    0,
 /*   300 */   271,   14,   47,  243,  243,  250,   64,   20,  279,  250,
 /*   310 */   277,  331,  332,  333,  334,   81,  336,  262,  289,   64,
 /*   320 */    21,  262,  293,   24,   25,   26,   27,   28,   29,   30,
 /*   330 */    31,   32,  271,  243,  279,   81,   81,  103,  279,  310,
 /*   340 */   279,   93,  313,  314,  315,  316,  317,  318,  114,  320,
 /*   350 */   289,   20,  323,  293,  293,  271,  327,  328,  103,  271,
 /*   360 */   112,  113,  278,  115,  116,  117,  243,  283,  280,  114,
 /*   370 */   259,  310,  261,  271,  313,  314,  315,  316,  317,  318,
 /*   380 */   278,  320,  250,  293,  323,  283,  311,    2,  327,  328,
 /*   390 */   329,   20,  158,    3,  262,  257,  258,   12,   13,   14,
 /*   400 */    15,   16,  341,   12,   13,   14,   15,   16,  347,  348,
 /*   410 */   335,  279,   81,  158,  180,  181,  293,  183,  184,  185,
 /*   420 */   186,  187,  188,  189,  190,  191,  192,  193,  194,  195,
 /*   430 */   196,  197,  250,  257,  258,  180,  181,  243,  183,  184,
 /*   440 */   185,  186,  187,  188,  189,  190,  191,  192,  193,  194,
 /*   450 */   195,  196,  197,   12,   13,   14,  243,    4,   20,   19,
 /*   460 */   281,   20,  243,   22,  210,  210,  264,  288,  289,  267,
 /*   470 */    14,  184,   19,   33,   12,   13,   20,  273,  243,  243,
 /*   480 */   273,  299,   20,  276,   22,   45,   33,  293,   47,  250,
 /*   490 */   144,   51,   52,   53,   54,   55,   14,  293,   45,  240,
 /*   500 */   293,  262,   20,   50,   57,   64,  293,  271,   55,   47,
 /*   510 */   153,  250,  293,  309,  310,  279,  309,  310,  279,  250,
 /*   520 */    80,  339,   81,   83,  320,  289,   64,  320,  293,  293,
 /*   530 */   173,  174,   64,   80,  352,  299,   83,  146,  356,  289,
 /*   540 */   279,  210,   41,   81,  103,  295,  310,   20,  279,  313,
 /*   550 */   314,  315,  316,  317,  318,  114,  320,  117,  299,  323,
 /*   560 */   243,  215,  216,  327,  328,  103,   12,   13,   14,   15,
 /*   570 */    16,  273,   80,  263,  272,  339,  114,   93,  317,   92,
 /*   580 */    88,  271,  142,   82,  146,  145,  317,    0,  352,   81,
 /*   590 */   280,  293,  356,  332,  333,  334,  253,  336,  339,  158,
 /*   600 */   116,  332,  333,  334,  164,  336,  166,  309,  310,  266,
 /*   610 */   293,  352,   58,  288,  289,  356,  226,  274,  320,    4,
 /*   620 */   158,  180,  181,  243,  183,  184,  185,  186,  187,  188,
 /*   630 */   189,  190,  191,  192,  193,  194,  195,  196,  197,   35,
 /*   640 */   184,  149,  180,  181,   90,  183,  184,  185,  186,  187,
 /*   650 */   188,  189,  190,  191,  192,  193,  194,  195,  196,  197,
 /*   660 */    12,   13,   18,   93,   20,  157,  180,  159,   20,  250,
 /*   670 */    22,   27,  250,  293,   30,   14,   15,   16,  208,  209,
 /*   680 */    93,  262,  112,  113,  262,  115,  116,  117,   84,   37,
 /*   690 */    86,   87,   48,   89,  140,   47,   22,   93,  279,  112,
 /*   700 */   113,  279,  115,  116,  117,  219,  220,  221,  222,  223,
 /*   710 */   271,  263,   64,    1,    2,  243,  162,  311,  210,  271,
 /*   720 */   116,   47,  283,   42,   43,  311,  169,  170,  280,   81,
 /*   730 */    94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   740 */   104,  335,  106,  107,  108,  109,  110,  111,  299,  335,
 /*   750 */   243,  103,  198,  199,  200,  201,  202,  203,  204,  205,
 /*   760 */   206,  207,  114,  119,    0,  293,  122,  123,  124,  125,
 /*   770 */   126,  127,  128,  129,  130,  131,  132,  133,  134,  135,
 /*   780 */   136,  137,  138,  139,  250,  250,   18,  250,  339,   20,
 /*   790 */    41,   23,   20,   20,   82,  140,  262,  262,  272,  262,
 /*   800 */   293,  352,  243,   35,   36,  356,  158,   39,  243,  243,
 /*   810 */   243,  299,  243,  279,  279,  243,  279,  162,  250,  243,
 /*   820 */   243,   57,  243,  146,   56,  148,  211,  272,  180,  181,
 /*   830 */   262,  183,  184,  185,  186,  187,  188,  189,  190,  191,
 /*   840 */   192,  193,  194,  195,  196,  197,   41,  279,  271,   81,
 /*   850 */   272,  339,  293,  198,    0,  272,  279,    0,  293,  293,
 /*   860 */   293,  209,  293,    0,  352,  293,  289,    0,  356,  293,
 /*   870 */   293,   85,  293,   85,   88,   85,   88,   85,   88,   22,
 /*   880 */    88,  243,   58,   21,  272,   22,  118,  310,   81,   22,
 /*   890 */   313,  314,  315,  316,  317,  318,   34,  320,   91,   45,
 /*   900 */   323,    1,    2,  272,  327,  328,  329,  244,  303,  271,
 /*   910 */   195,  196,   44,  260,  243,  146,   47,  279,  150,  151,
 /*   920 */   152,   41,   41,  155,  350,  348,   47,  289,  160,   41,
 /*   930 */   359,  293,   41,   41,   41,  307,  344,  271,  249,   41,
 /*   940 */   172,  251,  271,  175,  282,  177,  178,  179,  310,   81,
 /*   950 */   279,  313,  314,  315,  316,  317,  318,  184,  320,  312,
 /*   960 */   289,  323,   82,   82,  293,  327,  328,  329,   20,   41,
 /*   970 */    82,   41,  337,   82,   82,   82,  338,  228,  210,  243,
 /*   980 */    82,  310,  353,  114,  313,  314,  315,  316,  317,  318,
 /*   990 */   353,  320,   41,  114,  323,  243,   41,   41,  327,  328,
 /*  1000 */   329,  250,   41,  353,  180,  340,   41,  271,   45,  338,
 /*  1010 */    82,  308,   82,   47,  257,  279,   41,   41,  301,   40,
 /*  1020 */   156,  250,  287,  271,  250,  289,  140,  243,  285,  293,
 /*  1030 */   285,  279,  250,   82,   20,  230,  245,   82,   82,  245,
 /*  1040 */    20,  289,  305,   82,  255,  293,  310,   82,  289,  313,
 /*  1050 */   314,  315,  316,  317,  318,  271,  320,   82,   82,  323,
 /*  1060 */    20,  255,  310,  279,  328,  313,  314,  315,  316,  317,
 /*  1070 */   318,   20,  320,  289,  297,  323,  300,  293,  243,  327,
 /*  1080 */   328,  329,  255,  299,  297,  255,   20,  279,  290,  255,
 /*  1090 */   338,  255,  250,  243,  310,  255,  245,  313,  314,  315,
 /*  1100 */   316,  317,  318,  271,  320,  250,  271,   64,  271,  271,
 /*  1110 */   271,  245,  271,  293,  279,  271,  271,  271,  271,  271,
 /*  1120 */   271,  271,  305,  339,  289,  253,  304,  253,  293,  279,
 /*  1130 */   297,  253,  165,  290,  299,  279,  352,  253,   20,  289,
 /*  1140 */   356,  289,  218,  293,  243,  310,  349,  294,  313,  314,
 /*  1150 */   315,  316,  317,  318,  217,  320,  225,  346,  293,  349,
 /*  1160 */   310,  345,  224,  313,  314,  315,  316,  317,  318,  294,
 /*  1170 */   320,  312,  271,  323,  339,  293,  293,  327,  328,   20,
 /*  1180 */   279,  213,  212,  209,  279,   40,  229,  352,  311,  360,
 /*  1190 */   289,  356,  232,   81,  293,  293,  243,  293,  227,  293,
 /*  1200 */    12,   13,  294,  343,  294,  243,  330,  143,  291,  290,
 /*  1210 */    22,  310,  342,  355,  313,  314,  315,  316,  317,  318,
 /*  1220 */   319,  320,  321,  322,  271,  354,  279,   81,  355,  326,
 /*  1230 */   253,  267,  279,  271,  253,   47,  250,  279,  253,  354,
 /*  1240 */   245,  279,  289,  261,  355,  302,  293,  275,  354,  265,
 /*  1250 */   306,  289,   64,  243,  265,  293,  265,  298,  296,  254,
 /*  1260 */   241,    0,    0,  310,   72,    0,  313,  314,  315,  316,
 /*  1270 */   317,  318,  310,  320,   47,  313,  314,  315,  316,  317,
 /*  1280 */   318,  271,  320,  176,   47,  243,   47,   47,    0,  279,
 /*  1290 */   176,  103,   47,   47,    0,  176,   47,    0,   47,  289,
 /*  1300 */     0,   47,  114,  293,    0,   81,  162,  114,  161,  158,
 /*  1310 */   357,  358,    0,  271,    0,  154,  153,  243,    0,    0,
 /*  1320 */   310,  279,   44,  313,  314,  315,  316,  317,  318,    0,
 /*  1330 */   320,  289,    0,    0,    0,  293,    0,    0,    0,    0,
 /*  1340 */     0,    0,    0,    0,    0,  271,  158,    0,    0,    0,
 /*  1350 */     0,    0,  310,  279,    0,  313,  314,  315,  316,  317,
 /*  1360 */   318,  351,  320,  289,   40,  243,    0,  293,  180,    0,
 /*  1370 */   296,    0,    0,    0,   22,    0,    0,    0,  243,  191,
 /*  1380 */   192,  193,    0,    0,  310,    0,   40,  313,  314,  315,
 /*  1390 */   316,  317,  318,  271,  320,   14,   37,   41,   14,   44,
 /*  1400 */   358,  279,    0,   38,   44,   37,  271,    0,    0,    0,
 /*  1410 */     0,  289,    0,    0,  279,  293,   37,   37,  243,    0,
 /*  1420 */    59,    0,    0,   37,  289,   47,    0,   37,  293,   37,
 /*  1430 */     0,  296,  310,   37,   45,  313,  314,  315,  316,  317,
 /*  1440 */   318,   47,  320,   45,  322,  310,  271,   47,  313,  314,
 /*  1450 */   315,  316,  317,  318,  279,  320,   45,    0,   33,    0,
 /*  1460 */    45,   47,    0,    0,  289,   47,  243,    0,  293,   22,
 /*  1470 */    45,  296,   41,   41,   47,   22,   51,   52,   53,   54,
 /*  1480 */    55,   90,   47,   88,   47,  310,   47,   47,  313,  314,
 /*  1490 */   315,  316,  317,  318,  271,  320,   47,   47,    0,   22,
 /*  1500 */    47,    0,  279,   22,   48,   80,    0,   22,   83,    0,
 /*  1510 */    22,   47,  289,    0,   22,   20,  293,   64,    0,   47,
 /*  1520 */   146,    0,   22,  243,    0,  163,    0,    0,   37,   81,
 /*  1530 */   143,   41,   81,  310,  141,   41,  313,  314,  315,  316,
 /*  1540 */   317,  318,   82,  320,  214,  146,   41,   82,   82,   81,
 /*  1550 */    81,  271,   41,   41,   44,   81,  103,   82,   44,  279,
 /*  1560 */    82,   44,   82,   41,   44,  208,  141,  114,  143,  289,
 /*  1570 */   145,  243,  147,  293,   41,   47,   47,  214,  214,   82,
 /*  1580 */     2,   47,   47,   47,   47,  180,   41,   44,   44,   82,
 /*  1590 */   310,  166,   22,  313,  314,  315,  316,  317,  318,  271,
 /*  1600 */   320,  243,  182,    0,   81,  144,   81,  279,   44,   37,
 /*  1610 */    91,  158,   82,   81,  141,   22,   47,  289,   44,   81,
 /*  1620 */    81,  293,   82,   92,   82,   59,   47,   81,   81,  271,
 /*  1630 */    81,  243,   81,  180,  181,   82,   81,  279,  310,   81,
 /*  1640 */    81,  313,  314,  315,  316,  317,  318,  289,  320,   82,
 /*  1650 */    82,  293,   47,   47,   81,   47,   47,   82,   81,  271,
 /*  1660 */    22,  105,   82,   81,   47,   82,   81,  279,  310,   93,
 /*  1670 */   105,  313,  314,  315,  316,  317,  318,  289,  320,  243,
 /*  1680 */    81,  293,   81,   81,   47,   22,  105,   58,  243,  105,
 /*  1690 */    47,   64,   79,   41,   47,   47,   47,   47,  310,   22,
 /*  1700 */   114,  313,  314,  315,  316,  317,  318,  271,  320,   47,
 /*  1710 */    64,   47,   47,   47,   47,  279,  271,   47,   47,   47,
 /*  1720 */    47,   47,    0,   47,  279,  289,   45,   37,    0,  293,
 /*  1730 */    47,   45,   37,    0,  289,   47,  243,   45,  293,   37,
 /*  1740 */     0,   47,   45,   37,    0,   47,  310,   46,    0,  313,
 /*  1750 */   314,  315,  316,  317,  318,  310,  320,    0,  313,  314,
 /*  1760 */   315,  316,  317,  318,  271,  320,   20,   22,   21,  361,
 /*  1770 */   361,   22,  279,   22,   21,  361,  361,  361,  361,  361,
 /*  1780 */   361,  361,  289,  361,  243,  361,  293,  361,  361,  361,
 /*  1790 */   361,  361,  361,  361,  361,  243,  361,  361,  361,  361,
 /*  1800 */   361,  361,  361,  310,  361,  361,  313,  314,  315,  316,
 /*  1810 */   317,  318,  271,  320,  243,  361,  361,  361,  361,  361,
 /*  1820 */   279,  361,  361,  271,  361,  361,  361,  361,  361,  361,
 /*  1830 */   289,  279,  361,  361,  293,  361,  361,  361,  361,  361,
 /*  1840 */   361,  289,  271,  361,  361,  293,  361,  361,  361,  361,
 /*  1850 */   279,  310,  361,  361,  313,  314,  315,  316,  317,  318,
 /*  1860 */   289,  320,  310,  361,  293,  313,  314,  315,  316,  317,
 /*  1870 */   318,  361,  320,  243,  361,  361,  361,  361,  361,  361,
 /*  1880 */   361,  310,  243,  361,  313,  314,  315,  316,  317,  318,
 /*  1890 */   361,  320,  361,  361,  361,  361,  361,  361,  361,  361,
 /*  1900 */   361,  271,  361,  361,  361,  361,  361,  361,  361,  279,
 /*  1910 */   271,  361,  361,  361,  361,  361,  361,  361,  279,  289,
 /*  1920 */   361,  361,  361,  293,  361,  361,  361,  361,  289,  361,
 /*  1930 */   361,  361,  293,  361,  361,  361,  361,  361,  361,  361,
 /*  1940 */   310,  361,  243,  313,  314,  315,  316,  317,  318,  310,
 /*  1950 */   320,  243,  313,  314,  315,  316,  317,  318,  361,  320,
 /*  1960 */   361,  361,  361,  361,  361,  361,  361,  361,  361,  361,
 /*  1970 */   271,  361,  361,  361,  361,  361,  361,  361,  279,  271,
 /*  1980 */   361,  361,  361,  361,  361,  361,  361,  279,  289,  361,
 /*  1990 */   361,  361,  293,  361,  361,  361,  361,  289,  361,  243,
 /*  2000 */   361,  293,  361,  361,  361,  361,  361,  361,  361,  310,
 /*  2010 */   250,  361,  313,  314,  315,  316,  317,  318,  310,  320,
 /*  2020 */   361,  313,  314,  315,  316,  317,  318,  271,  320,  361,
 /*  2030 */   361,  361,  361,  361,  361,  279,  361,  361,  361,  279,
 /*  2040 */   361,  361,  361,  361,  361,  289,  250,  361,  361,  293,
 /*  2050 */   361,  361,  361,  361,  361,  361,  361,  361,  361,  299,
 /*  2060 */   361,  361,  361,  361,  361,  361,  310,  361,  361,  313,
 /*  2070 */   314,  315,  316,  317,  318,  279,  320,  317,  361,  361,
 /*  2080 */   361,  361,  361,  361,  361,  361,  361,  361,  361,  361,
 /*  2090 */   361,  361,  332,  333,  334,  299,  336,  361,  361,  339,
 /*  2100 */   361,  361,  361,  361,  361,  361,  361,  361,  361,  361,
 /*  2110 */   361,  361,  352,  317,  361,  361,  356,  361,  361,  361,
 /*  2120 */   361,  361,  361,  361,  361,  361,  361,  361,  332,  333,
 /*  2130 */   334,  361,  336,  361,  361,  339,  361,  361,  361,  361,
 /*  2140 */   361,  361,  361,  361,  361,  361,  361,  361,  352,  361,
 /*  2150 */   361,  361,  356,
};
#define YY_SHIFT_COUNT    (610)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1757)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   768,    0,    0,   48,  234,  234,  234,  234,  255,  255,
 /*    10 */   234,  234,  441,  462,  648,  462,  462,  462,  462,  462,
 /*    20 */   462,  462,  462,  462,  462,  462,  462,  462,  462,  462,
 /*    30 */   462,  462,  462,  462,  462,  462,  462,  462,  254,  254,
 /*    40 */    54,   54,   54, 1188, 1188, 1188, 1188,  331,  508,   74,
 /*    50 */     4,    4,    7,    7,   76,   74,   74,    4,    4,    4,
 /*    60 */     4,    4,    4,  216,    4,  265,  371,  527,  265,    4,
 /*    70 */     4,  265,    4,  265,  265,  527,  265,    4,  447,  644,
 /*    80 */    14,  554,  554,  139,  192, 1453, 1453, 1453, 1453, 1453,
 /*    90 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   100 */  1453, 1453, 1453, 1453,  604,  229,  482,  482,  198,    5,
 /*   110 */   438,  438,  438,  764,    5,  772,  527,  265,  265,  527,
 /*   120 */   487,  468,  636,  636,  636,  636,  636,  636,  636,  440,
 /*   130 */   299,  222,   27,  486,   37,  346,  287,  456,  681,  674,
 /*   140 */   484,  769,  470,  652,  470,  390,  390,  390,  615,  773,
 /*   150 */   948,  963,  966,  864,  948,  948,  979,  886,  886,  948,
 /*   160 */  1014, 1014, 1020,  216,  527,  216, 1040, 1051,  216, 1040,
 /*   170 */   216,  772, 1066,  216,  216,  948,  216, 1014,  265,  265,
 /*   180 */   265,  265,  265,  265,  265,  265,  265,  265,  265,  948,
 /*   190 */  1014, 1043, 1020,  447,  967,  527,  447, 1040,  447,  772,
 /*   200 */  1066,  447, 1118,  924,  937, 1043,  924,  937, 1043, 1043,
 /*   210 */   265,  931,  938,  968,  970,  974,  772, 1159, 1145,  957,
 /*   220 */   971,  960,  957,  971,  957,  971, 1112,  937, 1043, 1043,
 /*   230 */   937, 1043, 1064,  772, 1066,  447,  487,  447,  772, 1146,
 /*   240 */   468,  948,  447, 1014, 2153, 2153, 2153, 2153, 2153, 2153,
 /*   250 */  2153, 2153,   71, 1425,   93,  453,  248,  587,  187,   63,
 /*   260 */   385,  391,  211,  570,   95,   95,   95,   95,   95,   95,
 /*   270 */    95,   95,  357,    2,   52,  492,  712,  655,  661,  661,
 /*   280 */   661,  661,  854,  501,  786,  788,  790,  792,  857,  863,
 /*   290 */   867,  862,  557,  677,  880,  881,  888,  900,  715,  749,
 /*   300 */   805,  891,  824,  892,  868,  893,  898,  928,  930,  951,
 /*   310 */   869,  879,  955,  956,  961,  965,  975,  976,  807,  242,
 /*   320 */  1261, 1262, 1192, 1265, 1227, 1107, 1237, 1239, 1240, 1114,
 /*   330 */  1288, 1245, 1246, 1119, 1294, 1249, 1297, 1251, 1300, 1254,
 /*   340 */  1304, 1224, 1144, 1147, 1193, 1151, 1312, 1314, 1161, 1163,
 /*   350 */  1318, 1319, 1278, 1329, 1332, 1333, 1334, 1336, 1337, 1338,
 /*   360 */  1339, 1340, 1341, 1342, 1343, 1344, 1347, 1348, 1349, 1350,
 /*   370 */  1351, 1324, 1354, 1366, 1369, 1371, 1372, 1373, 1352, 1375,
 /*   380 */  1376, 1377, 1382, 1383, 1385, 1346, 1359, 1356, 1381, 1355,
 /*   390 */  1384, 1360, 1402, 1365, 1368, 1407, 1408, 1409, 1379, 1410,
 /*   400 */  1412, 1380, 1413, 1361, 1419, 1421, 1378, 1389, 1386, 1422,
 /*   410 */  1394, 1398, 1390, 1426, 1400, 1411, 1392, 1430, 1414, 1415,
 /*   420 */  1396, 1457, 1459, 1462, 1463, 1391, 1395, 1418, 1447, 1467,
 /*   430 */  1427, 1435, 1437, 1439, 1431, 1432, 1440, 1449, 1450, 1498,
 /*   440 */  1477, 1501, 1481, 1456, 1506, 1485, 1464, 1509, 1488, 1513,
 /*   450 */  1492, 1495, 1518, 1374, 1472, 1521, 1362, 1500, 1399, 1387,
 /*   460 */  1524, 1526, 1527, 1448, 1491, 1393, 1490, 1494, 1330, 1460,
 /*   470 */  1505, 1465, 1451, 1468, 1469, 1466, 1511, 1510, 1514, 1474,
 /*   480 */  1512, 1363, 1475, 1478, 1517, 1357, 1522, 1520, 1480, 1533,
 /*   490 */  1364, 1497, 1528, 1529, 1534, 1535, 1536, 1537, 1497, 1578,
 /*   500 */  1405, 1545, 1507, 1523, 1530, 1543, 1525, 1532, 1544, 1570,
 /*   510 */  1420, 1538, 1540, 1542, 1539, 1546, 1461, 1547, 1603, 1572,
 /*   520 */  1473, 1549, 1519, 1564, 1574, 1551, 1553, 1555, 1593, 1558,
 /*   530 */  1531, 1567, 1569, 1579, 1559, 1568, 1605, 1573, 1575, 1606,
 /*   540 */  1577, 1580, 1608, 1582, 1583, 1609, 1585, 1556, 1565, 1581,
 /*   550 */  1584, 1638, 1576, 1599, 1601, 1617, 1602, 1586, 1637, 1663,
 /*   560 */  1566, 1629, 1643, 1627, 1613, 1652, 1647, 1648, 1649, 1650,
 /*   570 */  1662, 1677, 1664, 1665, 1646, 1431, 1666, 1432, 1667, 1670,
 /*   580 */  1671, 1672, 1673, 1674, 1722, 1676, 1681, 1690, 1728, 1683,
 /*   590 */  1686, 1695, 1733, 1688, 1692, 1702, 1740, 1694, 1697, 1706,
 /*   600 */  1744, 1698, 1701, 1748, 1757, 1745, 1747, 1749, 1751, 1753,
 /*   610 */  1746,
};
#define YY_REDUCE_COUNT (251)
#define YY_REDUCE_MIN   (-320)
#define YY_REDUCE_MAX   (1796)
static const short yy_reduce_ofst[] = {
 /*     0 */   259, -226,  236,   61,  577,  638,  671,  752,  784,  835,
 /*    10 */    29,  850,  901,  953,  736,  962, 1010, 1042, 1074, 1122,
 /*    20 */  1135, 1175, 1223, 1280, 1328, 1358, 1388, 1436, 1445, 1493,
 /*    30 */  1541, 1552, 1571, 1630, 1639, 1699, 1708, 1756, 1760, 1796,
 /*    40 */   -20,  261,  269, -272,  207,  204,  298,  182,  449,  512,
 /*    50 */  -244, -164, -246, -241, -320, -178,  -76, -196,   55,   59,
 /*    60 */   132,  239,  419, -222,  422, -227, -256, -139,   -1,  534,
 /*    70 */   535,   84,  537,  310,  102,  179,  448,  568,  343,  -75,
 /*    80 */  -315, -315, -315, -228,  -49,   60,   90,  123,  194,  213,
 /*    90 */   219,  235,  317,  380,  472,  507,  559,  565,  566,  567,
 /*   100 */   569,  572,  576,  579, -154, -152, -216,  -68,   33,  138,
 /*   110 */    75,  406,  414,   -3,  176, -127,  250,   88,  439,  325,
 /*   120 */   202,  111,  302,  526,  555,  578,  583,  612,  631,  605,
 /*   130 */   663,  653,  571,  574,  628,  592,  666,  666,  689,  690,
 /*   140 */   662,  647,  635,  635,  635,  629,  637,  650,  665,  666,
 /*   150 */   751,  703,  757,  717,  771,  774,  735,  743,  745,  782,
 /*   160 */   791,  794,  737,  789,  759,  806,  777,  776,  827,  787,
 /*   170 */   830,  808,  798,  834,  836,  842,  840,  851,  832,  837,
 /*   180 */   838,  839,  841,  844,  845,  846,  847,  848,  849,  855,
 /*   190 */   866,  820,  817,  872,  822,  852,  874,  833,  878,  856,
 /*   200 */   843,  884,  859,  797,  853,  865,  810,  875,  882,  883,
 /*   210 */   666,  811,  816,  860,  870,  635,  905,  877,  876,  858,
 /*   220 */   871,  829,  873,  885,  889,  894,  903,  908,  902,  904,
 /*   230 */   910,  906,  917,  947,  919,  977,  964,  981,  958,  972,
 /*   240 */   982,  986,  985,  995,  943,  944,  959,  984,  989,  991,
 /*   250 */  1005, 1019,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*    10 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*    20 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*    30 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*    40 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*    50 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*    60 */  1356, 1356, 1356, 1425, 1356, 1356, 1356, 1356, 1356, 1356,
 /*    70 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1423, 1564,
 /*    80 */  1356, 1731, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*    90 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   100 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1425, 1356,
 /*   110 */  1742, 1742, 1742, 1423, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   120 */  1519, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1603,
 /*   130 */  1356, 1356, 1808, 1356, 1609, 1766, 1356, 1356, 1356, 1356,
 /*   140 */  1472, 1758, 1734, 1748, 1735, 1793, 1793, 1793, 1751, 1356,
 /*   150 */  1356, 1356, 1356, 1595, 1356, 1356, 1569, 1566, 1566, 1356,
 /*   160 */  1356, 1356, 1356, 1425, 1356, 1425, 1356, 1356, 1425, 1356,
 /*   170 */  1425, 1356, 1356, 1425, 1425, 1356, 1425, 1356, 1356, 1356,
 /*   180 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   190 */  1356, 1356, 1356, 1423, 1605, 1356, 1423, 1356, 1423, 1356,
 /*   200 */  1356, 1423, 1356, 1773, 1771, 1356, 1773, 1771, 1356, 1356,
 /*   210 */  1356, 1785, 1781, 1764, 1762, 1748, 1356, 1356, 1356, 1799,
 /*   220 */  1795, 1811, 1799, 1795, 1799, 1795, 1356, 1771, 1356, 1356,
 /*   230 */  1771, 1356, 1577, 1356, 1356, 1423, 1356, 1423, 1356, 1488,
 /*   240 */  1356, 1356, 1423, 1356, 1597, 1611, 1587, 1522, 1522, 1522,
 /*   250 */  1426, 1361, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   260 */  1356, 1356, 1356, 1484, 1675, 1784, 1783, 1707, 1706, 1705,
 /*   270 */  1703, 1674, 1356, 1356, 1356, 1356, 1356, 1356, 1668, 1669,
 /*   280 */  1667, 1666, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   290 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1732, 1356, 1796,
 /*   300 */  1800, 1356, 1356, 1356, 1651, 1356, 1356, 1356, 1356, 1356,
 /*   310 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   320 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   330 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   340 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   350 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   360 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   370 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   380 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1390, 1356, 1356,
 /*   390 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   400 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   410 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   420 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   430 */  1356, 1356, 1356, 1356, 1453, 1452, 1356, 1356, 1356, 1356,
 /*   440 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   450 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   460 */  1356, 1356, 1356, 1356, 1356, 1356, 1755, 1765, 1356, 1356,
 /*   470 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1651, 1356,
 /*   480 */  1782, 1356, 1741, 1737, 1356, 1356, 1733, 1356, 1356, 1794,
 /*   490 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1727,
 /*   500 */  1356, 1700, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   510 */  1662, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   520 */  1356, 1356, 1356, 1650, 1356, 1691, 1356, 1356, 1356, 1356,
 /*   530 */  1356, 1356, 1356, 1356, 1516, 1356, 1356, 1356, 1356, 1356,
 /*   540 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1501, 1499, 1498,
 /*   550 */  1497, 1356, 1494, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   560 */  1356, 1356, 1356, 1356, 1356, 1445, 1356, 1356, 1356, 1356,
 /*   570 */  1356, 1356, 1356, 1356, 1356, 1436, 1356, 1435, 1356, 1356,
 /*   580 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   590 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   600 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*   610 */  1356,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*  PRIVILEGE => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*       DAYS => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*      DELAY => nothing */
    0,  /* FILE_FACTOR => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FULLTEXT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*     CGROUP => nothing */
    0,  /*       WITH => nothing */
    0,  /*     SCHEMA => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*      MERGE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /*      COUNT => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  233,  /*  NK_BITNOT => ID */
  233,  /*     INSERT => ID */
  233,  /*     VALUES => ID */
  233,  /*     IMPORT => ID */
  233,  /*    NK_SEMI => ID */
  233,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "GRANT",
  /*   37 */ "ON",
  /*   38 */ "TO",
  /*   39 */ "REVOKE",
  /*   40 */ "FROM",
  /*   41 */ "NK_COMMA",
  /*   42 */ "READ",
  /*   43 */ "WRITE",
  /*   44 */ "NK_DOT",
  /*   45 */ "DNODE",
  /*   46 */ "PORT",
  /*   47 */ "NK_INTEGER",
  /*   48 */ "DNODES",
  /*   49 */ "NK_IPTOKEN",
  /*   50 */ "LOCAL",
  /*   51 */ "QNODE",
  /*   52 */ "BNODE",
  /*   53 */ "SNODE",
  /*   54 */ "MNODE",
  /*   55 */ "DATABASE",
  /*   56 */ "USE",
  /*   57 */ "IF",
  /*   58 */ "NOT",
  /*   59 */ "EXISTS",
  /*   60 */ "BUFFER",
  /*   61 */ "CACHELAST",
  /*   62 */ "COMP",
  /*   63 */ "DAYS",
  /*   64 */ "NK_VARIABLE",
  /*   65 */ "FSYNC",
  /*   66 */ "MAXROWS",
  /*   67 */ "MINROWS",
  /*   68 */ "KEEP",
  /*   69 */ "PAGES",
  /*   70 */ "PAGESIZE",
  /*   71 */ "PRECISION",
  /*   72 */ "REPLICA",
  /*   73 */ "STRICT",
  /*   74 */ "WAL",
  /*   75 */ "VGROUPS",
  /*   76 */ "SINGLE_STABLE",
  /*   77 */ "RETENTIONS",
  /*   78 */ "SCHEMALESS",
  /*   79 */ "NK_COLON",
  /*   80 */ "TABLE",
  /*   81 */ "NK_LP",
  /*   82 */ "NK_RP",
  /*   83 */ "STABLE",
  /*   84 */ "ADD",
  /*   85 */ "COLUMN",
  /*   86 */ "MODIFY",
  /*   87 */ "RENAME",
  /*   88 */ "TAG",
  /*   89 */ "SET",
  /*   90 */ "NK_EQ",
  /*   91 */ "USING",
  /*   92 */ "TAGS",
  /*   93 */ "COMMENT",
  /*   94 */ "BOOL",
  /*   95 */ "TINYINT",
  /*   96 */ "SMALLINT",
  /*   97 */ "INT",
  /*   98 */ "INTEGER",
  /*   99 */ "BIGINT",
  /*  100 */ "FLOAT",
  /*  101 */ "DOUBLE",
  /*  102 */ "BINARY",
  /*  103 */ "TIMESTAMP",
  /*  104 */ "NCHAR",
  /*  105 */ "UNSIGNED",
  /*  106 */ "JSON",
  /*  107 */ "VARCHAR",
  /*  108 */ "MEDIUMBLOB",
  /*  109 */ "BLOB",
  /*  110 */ "VARBINARY",
  /*  111 */ "DECIMAL",
  /*  112 */ "DELAY",
  /*  113 */ "FILE_FACTOR",
  /*  114 */ "NK_FLOAT",
  /*  115 */ "ROLLUP",
  /*  116 */ "TTL",
  /*  117 */ "SMA",
  /*  118 */ "SHOW",
  /*  119 */ "DATABASES",
  /*  120 */ "TABLES",
  /*  121 */ "STABLES",
  /*  122 */ "MNODES",
  /*  123 */ "MODULES",
  /*  124 */ "QNODES",
  /*  125 */ "FUNCTIONS",
  /*  126 */ "INDEXES",
  /*  127 */ "ACCOUNTS",
  /*  128 */ "APPS",
  /*  129 */ "CONNECTIONS",
  /*  130 */ "LICENCE",
  /*  131 */ "GRANTS",
  /*  132 */ "QUERIES",
  /*  133 */ "SCORES",
  /*  134 */ "TOPICS",
  /*  135 */ "VARIABLES",
  /*  136 */ "BNODES",
  /*  137 */ "SNODES",
  /*  138 */ "CLUSTER",
  /*  139 */ "TRANSACTIONS",
  /*  140 */ "LIKE",
  /*  141 */ "INDEX",
  /*  142 */ "FULLTEXT",
  /*  143 */ "FUNCTION",
  /*  144 */ "INTERVAL",
  /*  145 */ "TOPIC",
  /*  146 */ "AS",
  /*  147 */ "CGROUP",
  /*  148 */ "WITH",
  /*  149 */ "SCHEMA",
  /*  150 */ "DESC",
  /*  151 */ "DESCRIBE",
  /*  152 */ "RESET",
  /*  153 */ "QUERY",
  /*  154 */ "CACHE",
  /*  155 */ "EXPLAIN",
  /*  156 */ "ANALYZE",
  /*  157 */ "VERBOSE",
  /*  158 */ "NK_BOOL",
  /*  159 */ "RATIO",
  /*  160 */ "COMPACT",
  /*  161 */ "VNODES",
  /*  162 */ "IN",
  /*  163 */ "OUTPUTTYPE",
  /*  164 */ "AGGREGATE",
  /*  165 */ "BUFSIZE",
  /*  166 */ "STREAM",
  /*  167 */ "INTO",
  /*  168 */ "TRIGGER",
  /*  169 */ "AT_ONCE",
  /*  170 */ "WINDOW_CLOSE",
  /*  171 */ "WATERMARK",
  /*  172 */ "KILL",
  /*  173 */ "CONNECTION",
  /*  174 */ "TRANSACTION",
  /*  175 */ "MERGE",
  /*  176 */ "VGROUP",
  /*  177 */ "REDISTRIBUTE",
  /*  178 */ "SPLIT",
  /*  179 */ "SYNCDB",
  /*  180 */ "NULL",
  /*  181 */ "NK_QUESTION",
  /*  182 */ "NK_ARROW",
  /*  183 */ "ROWTS",
  /*  184 */ "TBNAME",
  /*  185 */ "QSTARTTS",
  /*  186 */ "QENDTS",
  /*  187 */ "WSTARTTS",
  /*  188 */ "WENDTS",
  /*  189 */ "WDURATION",
  /*  190 */ "CAST",
  /*  191 */ "NOW",
  /*  192 */ "TODAY",
  /*  193 */ "TIMEZONE",
  /*  194 */ "COUNT",
  /*  195 */ "FIRST",
  /*  196 */ "LAST",
  /*  197 */ "LAST_ROW",
  /*  198 */ "BETWEEN",
  /*  199 */ "IS",
  /*  200 */ "NK_LT",
  /*  201 */ "NK_GT",
  /*  202 */ "NK_LE",
  /*  203 */ "NK_GE",
  /*  204 */ "NK_NE",
  /*  205 */ "MATCH",
  /*  206 */ "NMATCH",
  /*  207 */ "CONTAINS",
  /*  208 */ "JOIN",
  /*  209 */ "INNER",
  /*  210 */ "SELECT",
  /*  211 */ "DISTINCT",
  /*  212 */ "WHERE",
  /*  213 */ "PARTITION",
  /*  214 */ "BY",
  /*  215 */ "SESSION",
  /*  216 */ "STATE_WINDOW",
  /*  217 */ "SLIDING",
  /*  218 */ "FILL",
  /*  219 */ "VALUE",
  /*  220 */ "NONE",
  /*  221 */ "PREV",
  /*  222 */ "LINEAR",
  /*  223 */ "NEXT",
  /*  224 */ "GROUP",
  /*  225 */ "HAVING",
  /*  226 */ "ORDER",
  /*  227 */ "SLIMIT",
  /*  228 */ "SOFFSET",
  /*  229 */ "LIMIT",
  /*  230 */ "OFFSET",
  /*  231 */ "ASC",
  /*  232 */ "NULLS",
  /*  233 */ "ID",
  /*  234 */ "NK_BITNOT",
  /*  235 */ "INSERT",
  /*  236 */ "VALUES",
  /*  237 */ "IMPORT",
  /*  238 */ "NK_SEMI",
  /*  239 */ "FILE",
  /*  240 */ "cmd",
  /*  241 */ "account_options",
  /*  242 */ "alter_account_options",
  /*  243 */ "literal",
  /*  244 */ "alter_account_option",
  /*  245 */ "user_name",
  /*  246 */ "privileges",
  /*  247 */ "priv_level",
  /*  248 */ "priv_type_list",
  /*  249 */ "priv_type",
  /*  250 */ "db_name",
  /*  251 */ "dnode_endpoint",
  /*  252 */ "dnode_host_name",
  /*  253 */ "not_exists_opt",
  /*  254 */ "db_options",
  /*  255 */ "exists_opt",
  /*  256 */ "alter_db_options",
  /*  257 */ "integer_list",
  /*  258 */ "variable_list",
  /*  259 */ "retention_list",
  /*  260 */ "alter_db_option",
  /*  261 */ "retention",
  /*  262 */ "full_table_name",
  /*  263 */ "column_def_list",
  /*  264 */ "tags_def_opt",
  /*  265 */ "table_options",
  /*  266 */ "multi_create_clause",
  /*  267 */ "tags_def",
  /*  268 */ "multi_drop_clause",
  /*  269 */ "alter_table_clause",
  /*  270 */ "alter_table_options",
  /*  271 */ "column_name",
  /*  272 */ "type_name",
  /*  273 */ "signed_literal",
  /*  274 */ "create_subtable_clause",
  /*  275 */ "specific_tags_opt",
  /*  276 */ "literal_list",
  /*  277 */ "drop_table_clause",
  /*  278 */ "col_name_list",
  /*  279 */ "table_name",
  /*  280 */ "column_def",
  /*  281 */ "func_name_list",
  /*  282 */ "alter_table_option",
  /*  283 */ "col_name",
  /*  284 */ "db_name_cond_opt",
  /*  285 */ "like_pattern_opt",
  /*  286 */ "table_name_cond",
  /*  287 */ "from_db_opt",
  /*  288 */ "func_name",
  /*  289 */ "function_name",
  /*  290 */ "index_name",
  /*  291 */ "index_options",
  /*  292 */ "func_list",
  /*  293 */ "duration_literal",
  /*  294 */ "sliding_opt",
  /*  295 */ "func",
  /*  296 */ "expression_list",
  /*  297 */ "topic_name",
  /*  298 */ "topic_options",
  /*  299 */ "query_expression",
  /*  300 */ "cgroup_name",
  /*  301 */ "analyze_opt",
  /*  302 */ "explain_options",
  /*  303 */ "agg_func_opt",
  /*  304 */ "bufsize_opt",
  /*  305 */ "stream_name",
  /*  306 */ "stream_options",
  /*  307 */ "into_opt",
  /*  308 */ "dnode_list",
  /*  309 */ "signed",
  /*  310 */ "literal_func",
  /*  311 */ "table_alias",
  /*  312 */ "column_alias",
  /*  313 */ "expression",
  /*  314 */ "pseudo_column",
  /*  315 */ "column_reference",
  /*  316 */ "function_expression",
  /*  317 */ "subquery",
  /*  318 */ "star_func",
  /*  319 */ "star_func_para_list",
  /*  320 */ "noarg_func",
  /*  321 */ "other_para_list",
  /*  322 */ "star_func_para",
  /*  323 */ "predicate",
  /*  324 */ "compare_op",
  /*  325 */ "in_op",
  /*  326 */ "in_predicate_value",
  /*  327 */ "boolean_value_expression",
  /*  328 */ "boolean_primary",
  /*  329 */ "common_expression",
  /*  330 */ "from_clause",
  /*  331 */ "table_reference_list",
  /*  332 */ "table_reference",
  /*  333 */ "table_primary",
  /*  334 */ "joined_table",
  /*  335 */ "alias_opt",
  /*  336 */ "parenthesized_joined_table",
  /*  337 */ "join_type",
  /*  338 */ "search_condition",
  /*  339 */ "query_specification",
  /*  340 */ "set_quantifier_opt",
  /*  341 */ "select_list",
  /*  342 */ "where_clause_opt",
  /*  343 */ "partition_by_clause_opt",
  /*  344 */ "twindow_clause_opt",
  /*  345 */ "group_by_clause_opt",
  /*  346 */ "having_clause_opt",
  /*  347 */ "select_sublist",
  /*  348 */ "select_item",
  /*  349 */ "fill_opt",
  /*  350 */ "fill_mode",
  /*  351 */ "group_by_list",
  /*  352 */ "query_expression_body",
  /*  353 */ "order_by_clause_opt",
  /*  354 */ "slimit_clause_opt",
  /*  355 */ "limit_clause_opt",
  /*  356 */ "query_primary",
  /*  357 */ "sort_specification_list",
  /*  358 */ "sort_specification",
  /*  359 */ "ordering_specification_opt",
  /*  360 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  29 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  30 */ "privileges ::= ALL",
 /*  31 */ "privileges ::= priv_type_list",
 /*  32 */ "priv_type_list ::= priv_type",
 /*  33 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  34 */ "priv_type ::= READ",
 /*  35 */ "priv_type ::= WRITE",
 /*  36 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  37 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  38 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  39 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  40 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  41 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  42 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  43 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  44 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  45 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  46 */ "dnode_endpoint ::= NK_STRING",
 /*  47 */ "dnode_host_name ::= NK_ID",
 /*  48 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  49 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  50 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  51 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  52 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  53 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  54 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  60 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  61 */ "cmd ::= USE db_name",
 /*  62 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  63 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  64 */ "not_exists_opt ::=",
 /*  65 */ "exists_opt ::= IF EXISTS",
 /*  66 */ "exists_opt ::=",
 /*  67 */ "db_options ::=",
 /*  68 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  69 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  70 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  71 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  72 */ "db_options ::= db_options DAYS NK_VARIABLE",
 /*  73 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  74 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  75 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  76 */ "db_options ::= db_options KEEP integer_list",
 /*  77 */ "db_options ::= db_options KEEP variable_list",
 /*  78 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  79 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  81 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  82 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  83 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  84 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  85 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  86 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  87 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  88 */ "alter_db_options ::= alter_db_option",
 /*  89 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  90 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  91 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  92 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  93 */ "alter_db_option ::= KEEP integer_list",
 /*  94 */ "alter_db_option ::= KEEP variable_list",
 /*  95 */ "alter_db_option ::= PAGES NK_INTEGER",
 /*  96 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  97 */ "alter_db_option ::= STRICT NK_INTEGER",
 /*  98 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  99 */ "integer_list ::= NK_INTEGER",
 /* 100 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 101 */ "variable_list ::= NK_VARIABLE",
 /* 102 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 103 */ "retention_list ::= retention",
 /* 104 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 105 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 106 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 107 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 108 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 109 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 110 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 111 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 112 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 113 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 114 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 115 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 116 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 117 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 118 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 119 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 120 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 121 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 122 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 123 */ "multi_create_clause ::= create_subtable_clause",
 /* 124 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 125 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options",
 /* 126 */ "multi_drop_clause ::= drop_table_clause",
 /* 127 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 128 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 129 */ "specific_tags_opt ::=",
 /* 130 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 131 */ "full_table_name ::= table_name",
 /* 132 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 133 */ "column_def_list ::= column_def",
 /* 134 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 135 */ "column_def ::= column_name type_name",
 /* 136 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 137 */ "type_name ::= BOOL",
 /* 138 */ "type_name ::= TINYINT",
 /* 139 */ "type_name ::= SMALLINT",
 /* 140 */ "type_name ::= INT",
 /* 141 */ "type_name ::= INTEGER",
 /* 142 */ "type_name ::= BIGINT",
 /* 143 */ "type_name ::= FLOAT",
 /* 144 */ "type_name ::= DOUBLE",
 /* 145 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 146 */ "type_name ::= TIMESTAMP",
 /* 147 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= TINYINT UNSIGNED",
 /* 149 */ "type_name ::= SMALLINT UNSIGNED",
 /* 150 */ "type_name ::= INT UNSIGNED",
 /* 151 */ "type_name ::= BIGINT UNSIGNED",
 /* 152 */ "type_name ::= JSON",
 /* 153 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 154 */ "type_name ::= MEDIUMBLOB",
 /* 155 */ "type_name ::= BLOB",
 /* 156 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= DECIMAL",
 /* 158 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 159 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 160 */ "tags_def_opt ::=",
 /* 161 */ "tags_def_opt ::= tags_def",
 /* 162 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 163 */ "table_options ::=",
 /* 164 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 165 */ "table_options ::= table_options DELAY NK_INTEGER",
 /* 166 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 167 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 168 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 169 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 170 */ "alter_table_options ::= alter_table_option",
 /* 171 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 172 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 173 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 174 */ "col_name_list ::= col_name",
 /* 175 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 176 */ "col_name ::= column_name",
 /* 177 */ "cmd ::= SHOW DNODES",
 /* 178 */ "cmd ::= SHOW USERS",
 /* 179 */ "cmd ::= SHOW DATABASES",
 /* 180 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 181 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 182 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 183 */ "cmd ::= SHOW MNODES",
 /* 184 */ "cmd ::= SHOW MODULES",
 /* 185 */ "cmd ::= SHOW QNODES",
 /* 186 */ "cmd ::= SHOW FUNCTIONS",
 /* 187 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 188 */ "cmd ::= SHOW STREAMS",
 /* 189 */ "cmd ::= SHOW ACCOUNTS",
 /* 190 */ "cmd ::= SHOW APPS",
 /* 191 */ "cmd ::= SHOW CONNECTIONS",
 /* 192 */ "cmd ::= SHOW LICENCE",
 /* 193 */ "cmd ::= SHOW GRANTS",
 /* 194 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 195 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 196 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 197 */ "cmd ::= SHOW QUERIES",
 /* 198 */ "cmd ::= SHOW SCORES",
 /* 199 */ "cmd ::= SHOW TOPICS",
 /* 200 */ "cmd ::= SHOW VARIABLES",
 /* 201 */ "cmd ::= SHOW BNODES",
 /* 202 */ "cmd ::= SHOW SNODES",
 /* 203 */ "cmd ::= SHOW CLUSTER",
 /* 204 */ "cmd ::= SHOW TRANSACTIONS",
 /* 205 */ "db_name_cond_opt ::=",
 /* 206 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 207 */ "like_pattern_opt ::=",
 /* 208 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 209 */ "table_name_cond ::= table_name",
 /* 210 */ "from_db_opt ::=",
 /* 211 */ "from_db_opt ::= FROM db_name",
 /* 212 */ "func_name_list ::= func_name",
 /* 213 */ "func_name_list ::= func_name_list NK_COMMA func_name",
 /* 214 */ "func_name ::= function_name",
 /* 215 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 216 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 217 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 218 */ "index_options ::=",
 /* 219 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 220 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 221 */ "func_list ::= func",
 /* 222 */ "func_list ::= func_list NK_COMMA func",
 /* 223 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 224 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS query_expression",
 /* 225 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS db_name",
 /* 226 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 227 */ "cmd ::= DROP CGROUP exists_opt cgroup_name ON topic_name",
 /* 228 */ "topic_options ::=",
 /* 229 */ "topic_options ::= topic_options WITH TABLE",
 /* 230 */ "topic_options ::= topic_options WITH SCHEMA",
 /* 231 */ "topic_options ::= topic_options WITH TAG",
 /* 232 */ "cmd ::= DESC full_table_name",
 /* 233 */ "cmd ::= DESCRIBE full_table_name",
 /* 234 */ "cmd ::= RESET QUERY CACHE",
 /* 235 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 236 */ "analyze_opt ::=",
 /* 237 */ "analyze_opt ::= ANALYZE",
 /* 238 */ "explain_options ::=",
 /* 239 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 240 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 241 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 242 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 243 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 244 */ "agg_func_opt ::=",
 /* 245 */ "agg_func_opt ::= AGGREGATE",
 /* 246 */ "bufsize_opt ::=",
 /* 247 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 248 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 249 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 250 */ "into_opt ::=",
 /* 251 */ "into_opt ::= INTO full_table_name",
 /* 252 */ "stream_options ::=",
 /* 253 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 254 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 255 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 256 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 257 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 258 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 259 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 260 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 261 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 262 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 263 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 264 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 265 */ "cmd ::= query_expression",
 /* 266 */ "literal ::= NK_INTEGER",
 /* 267 */ "literal ::= NK_FLOAT",
 /* 268 */ "literal ::= NK_STRING",
 /* 269 */ "literal ::= NK_BOOL",
 /* 270 */ "literal ::= TIMESTAMP NK_STRING",
 /* 271 */ "literal ::= duration_literal",
 /* 272 */ "literal ::= NULL",
 /* 273 */ "literal ::= NK_QUESTION",
 /* 274 */ "duration_literal ::= NK_VARIABLE",
 /* 275 */ "signed ::= NK_INTEGER",
 /* 276 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 277 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 278 */ "signed ::= NK_FLOAT",
 /* 279 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 280 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 281 */ "signed_literal ::= signed",
 /* 282 */ "signed_literal ::= NK_STRING",
 /* 283 */ "signed_literal ::= NK_BOOL",
 /* 284 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 285 */ "signed_literal ::= duration_literal",
 /* 286 */ "signed_literal ::= NULL",
 /* 287 */ "signed_literal ::= literal_func",
 /* 288 */ "literal_list ::= signed_literal",
 /* 289 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 290 */ "db_name ::= NK_ID",
 /* 291 */ "table_name ::= NK_ID",
 /* 292 */ "column_name ::= NK_ID",
 /* 293 */ "function_name ::= NK_ID",
 /* 294 */ "table_alias ::= NK_ID",
 /* 295 */ "column_alias ::= NK_ID",
 /* 296 */ "user_name ::= NK_ID",
 /* 297 */ "index_name ::= NK_ID",
 /* 298 */ "topic_name ::= NK_ID",
 /* 299 */ "stream_name ::= NK_ID",
 /* 300 */ "cgroup_name ::= NK_ID",
 /* 301 */ "expression ::= literal",
 /* 302 */ "expression ::= pseudo_column",
 /* 303 */ "expression ::= column_reference",
 /* 304 */ "expression ::= function_expression",
 /* 305 */ "expression ::= subquery",
 /* 306 */ "expression ::= NK_LP expression NK_RP",
 /* 307 */ "expression ::= NK_PLUS expression",
 /* 308 */ "expression ::= NK_MINUS expression",
 /* 309 */ "expression ::= expression NK_PLUS expression",
 /* 310 */ "expression ::= expression NK_MINUS expression",
 /* 311 */ "expression ::= expression NK_STAR expression",
 /* 312 */ "expression ::= expression NK_SLASH expression",
 /* 313 */ "expression ::= expression NK_REM expression",
 /* 314 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 315 */ "expression_list ::= expression",
 /* 316 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 317 */ "column_reference ::= column_name",
 /* 318 */ "column_reference ::= table_name NK_DOT column_name",
 /* 319 */ "pseudo_column ::= ROWTS",
 /* 320 */ "pseudo_column ::= TBNAME",
 /* 321 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 322 */ "pseudo_column ::= QSTARTTS",
 /* 323 */ "pseudo_column ::= QENDTS",
 /* 324 */ "pseudo_column ::= WSTARTTS",
 /* 325 */ "pseudo_column ::= WENDTS",
 /* 326 */ "pseudo_column ::= WDURATION",
 /* 327 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 328 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 329 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 330 */ "function_expression ::= literal_func",
 /* 331 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 332 */ "literal_func ::= NOW",
 /* 333 */ "noarg_func ::= NOW",
 /* 334 */ "noarg_func ::= TODAY",
 /* 335 */ "noarg_func ::= TIMEZONE",
 /* 336 */ "star_func ::= COUNT",
 /* 337 */ "star_func ::= FIRST",
 /* 338 */ "star_func ::= LAST",
 /* 339 */ "star_func ::= LAST_ROW",
 /* 340 */ "star_func_para_list ::= NK_STAR",
 /* 341 */ "star_func_para_list ::= other_para_list",
 /* 342 */ "other_para_list ::= star_func_para",
 /* 343 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 344 */ "star_func_para ::= expression",
 /* 345 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 346 */ "predicate ::= expression compare_op expression",
 /* 347 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 348 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 349 */ "predicate ::= expression IS NULL",
 /* 350 */ "predicate ::= expression IS NOT NULL",
 /* 351 */ "predicate ::= expression in_op in_predicate_value",
 /* 352 */ "compare_op ::= NK_LT",
 /* 353 */ "compare_op ::= NK_GT",
 /* 354 */ "compare_op ::= NK_LE",
 /* 355 */ "compare_op ::= NK_GE",
 /* 356 */ "compare_op ::= NK_NE",
 /* 357 */ "compare_op ::= NK_EQ",
 /* 358 */ "compare_op ::= LIKE",
 /* 359 */ "compare_op ::= NOT LIKE",
 /* 360 */ "compare_op ::= MATCH",
 /* 361 */ "compare_op ::= NMATCH",
 /* 362 */ "compare_op ::= CONTAINS",
 /* 363 */ "in_op ::= IN",
 /* 364 */ "in_op ::= NOT IN",
 /* 365 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 366 */ "boolean_value_expression ::= boolean_primary",
 /* 367 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 368 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 369 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 370 */ "boolean_primary ::= predicate",
 /* 371 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 372 */ "common_expression ::= expression",
 /* 373 */ "common_expression ::= boolean_value_expression",
 /* 374 */ "from_clause ::= FROM table_reference_list",
 /* 375 */ "table_reference_list ::= table_reference",
 /* 376 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 377 */ "table_reference ::= table_primary",
 /* 378 */ "table_reference ::= joined_table",
 /* 379 */ "table_primary ::= table_name alias_opt",
 /* 380 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 381 */ "table_primary ::= subquery alias_opt",
 /* 382 */ "table_primary ::= parenthesized_joined_table",
 /* 383 */ "alias_opt ::=",
 /* 384 */ "alias_opt ::= table_alias",
 /* 385 */ "alias_opt ::= AS table_alias",
 /* 386 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 387 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 388 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 389 */ "join_type ::=",
 /* 390 */ "join_type ::= INNER",
 /* 391 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 392 */ "set_quantifier_opt ::=",
 /* 393 */ "set_quantifier_opt ::= DISTINCT",
 /* 394 */ "set_quantifier_opt ::= ALL",
 /* 395 */ "select_list ::= NK_STAR",
 /* 396 */ "select_list ::= select_sublist",
 /* 397 */ "select_sublist ::= select_item",
 /* 398 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 399 */ "select_item ::= common_expression",
 /* 400 */ "select_item ::= common_expression column_alias",
 /* 401 */ "select_item ::= common_expression AS column_alias",
 /* 402 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 403 */ "where_clause_opt ::=",
 /* 404 */ "where_clause_opt ::= WHERE search_condition",
 /* 405 */ "partition_by_clause_opt ::=",
 /* 406 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 407 */ "twindow_clause_opt ::=",
 /* 408 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 409 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 410 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 411 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 412 */ "sliding_opt ::=",
 /* 413 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 414 */ "fill_opt ::=",
 /* 415 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 416 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 417 */ "fill_mode ::= NONE",
 /* 418 */ "fill_mode ::= PREV",
 /* 419 */ "fill_mode ::= NULL",
 /* 420 */ "fill_mode ::= LINEAR",
 /* 421 */ "fill_mode ::= NEXT",
 /* 422 */ "group_by_clause_opt ::=",
 /* 423 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 424 */ "group_by_list ::= expression",
 /* 425 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 426 */ "having_clause_opt ::=",
 /* 427 */ "having_clause_opt ::= HAVING search_condition",
 /* 428 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 429 */ "query_expression_body ::= query_primary",
 /* 430 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 431 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 432 */ "query_primary ::= query_specification",
 /* 433 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 434 */ "order_by_clause_opt ::=",
 /* 435 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 436 */ "slimit_clause_opt ::=",
 /* 437 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 438 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 439 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 440 */ "limit_clause_opt ::=",
 /* 441 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 442 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 443 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 444 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 445 */ "search_condition ::= common_expression",
 /* 446 */ "sort_specification_list ::= sort_specification",
 /* 447 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 448 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 449 */ "ordering_specification_opt ::=",
 /* 450 */ "ordering_specification_opt ::= ASC",
 /* 451 */ "ordering_specification_opt ::= DESC",
 /* 452 */ "null_ordering_opt ::=",
 /* 453 */ "null_ordering_opt ::= NULLS FIRST",
 /* 454 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 240: /* cmd */
    case 243: /* literal */
    case 254: /* db_options */
    case 256: /* alter_db_options */
    case 261: /* retention */
    case 262: /* full_table_name */
    case 265: /* table_options */
    case 269: /* alter_table_clause */
    case 270: /* alter_table_options */
    case 273: /* signed_literal */
    case 274: /* create_subtable_clause */
    case 277: /* drop_table_clause */
    case 280: /* column_def */
    case 283: /* col_name */
    case 284: /* db_name_cond_opt */
    case 285: /* like_pattern_opt */
    case 286: /* table_name_cond */
    case 287: /* from_db_opt */
    case 288: /* func_name */
    case 291: /* index_options */
    case 293: /* duration_literal */
    case 294: /* sliding_opt */
    case 295: /* func */
    case 298: /* topic_options */
    case 299: /* query_expression */
    case 302: /* explain_options */
    case 306: /* stream_options */
    case 307: /* into_opt */
    case 309: /* signed */
    case 310: /* literal_func */
    case 313: /* expression */
    case 314: /* pseudo_column */
    case 315: /* column_reference */
    case 316: /* function_expression */
    case 317: /* subquery */
    case 322: /* star_func_para */
    case 323: /* predicate */
    case 326: /* in_predicate_value */
    case 327: /* boolean_value_expression */
    case 328: /* boolean_primary */
    case 329: /* common_expression */
    case 330: /* from_clause */
    case 331: /* table_reference_list */
    case 332: /* table_reference */
    case 333: /* table_primary */
    case 334: /* joined_table */
    case 336: /* parenthesized_joined_table */
    case 338: /* search_condition */
    case 339: /* query_specification */
    case 342: /* where_clause_opt */
    case 344: /* twindow_clause_opt */
    case 346: /* having_clause_opt */
    case 348: /* select_item */
    case 349: /* fill_opt */
    case 352: /* query_expression_body */
    case 354: /* slimit_clause_opt */
    case 355: /* limit_clause_opt */
    case 356: /* query_primary */
    case 358: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy636)); 
}
      break;
    case 241: /* account_options */
    case 242: /* alter_account_options */
    case 244: /* alter_account_option */
    case 304: /* bufsize_opt */
{
 
}
      break;
    case 245: /* user_name */
    case 247: /* priv_level */
    case 250: /* db_name */
    case 251: /* dnode_endpoint */
    case 252: /* dnode_host_name */
    case 271: /* column_name */
    case 279: /* table_name */
    case 289: /* function_name */
    case 290: /* index_name */
    case 297: /* topic_name */
    case 300: /* cgroup_name */
    case 305: /* stream_name */
    case 311: /* table_alias */
    case 312: /* column_alias */
    case 318: /* star_func */
    case 320: /* noarg_func */
    case 335: /* alias_opt */
{
 
}
      break;
    case 246: /* privileges */
    case 248: /* priv_type_list */
    case 249: /* priv_type */
{
 
}
      break;
    case 253: /* not_exists_opt */
    case 255: /* exists_opt */
    case 301: /* analyze_opt */
    case 303: /* agg_func_opt */
    case 340: /* set_quantifier_opt */
{
 
}
      break;
    case 257: /* integer_list */
    case 258: /* variable_list */
    case 259: /* retention_list */
    case 263: /* column_def_list */
    case 264: /* tags_def_opt */
    case 266: /* multi_create_clause */
    case 267: /* tags_def */
    case 268: /* multi_drop_clause */
    case 275: /* specific_tags_opt */
    case 276: /* literal_list */
    case 278: /* col_name_list */
    case 281: /* func_name_list */
    case 292: /* func_list */
    case 296: /* expression_list */
    case 308: /* dnode_list */
    case 319: /* star_func_para_list */
    case 321: /* other_para_list */
    case 341: /* select_list */
    case 343: /* partition_by_clause_opt */
    case 345: /* group_by_clause_opt */
    case 347: /* select_sublist */
    case 351: /* group_by_list */
    case 353: /* order_by_clause_opt */
    case 357: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy236)); 
}
      break;
    case 260: /* alter_db_option */
    case 282: /* alter_table_option */
{
 
}
      break;
    case 272: /* type_name */
{
 
}
      break;
    case 324: /* compare_op */
    case 325: /* in_op */
{
 
}
      break;
    case 337: /* join_type */
{
 
}
      break;
    case 350: /* fill_mode */
{
 
}
      break;
    case 359: /* ordering_specification_opt */
{
 
}
      break;
    case 360: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  240,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  240,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  241,    0 }, /* (2) account_options ::= */
  {  241,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  241,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  241,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  241,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  241,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  241,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  241,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  241,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  241,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  242,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  242,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  244,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  244,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  244,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  244,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  244,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  244,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  244,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  244,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  244,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  244,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  240,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  240,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  240,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  240,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  240,   -6 }, /* (28) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  240,   -6 }, /* (29) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  246,   -1 }, /* (30) privileges ::= ALL */
  {  246,   -1 }, /* (31) privileges ::= priv_type_list */
  {  248,   -1 }, /* (32) priv_type_list ::= priv_type */
  {  248,   -3 }, /* (33) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  249,   -1 }, /* (34) priv_type ::= READ */
  {  249,   -1 }, /* (35) priv_type ::= WRITE */
  {  247,   -3 }, /* (36) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  247,   -3 }, /* (37) priv_level ::= db_name NK_DOT NK_STAR */
  {  240,   -3 }, /* (38) cmd ::= CREATE DNODE dnode_endpoint */
  {  240,   -5 }, /* (39) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  240,   -3 }, /* (40) cmd ::= DROP DNODE NK_INTEGER */
  {  240,   -3 }, /* (41) cmd ::= DROP DNODE dnode_endpoint */
  {  240,   -4 }, /* (42) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  240,   -5 }, /* (43) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  240,   -4 }, /* (44) cmd ::= ALTER ALL DNODES NK_STRING */
  {  240,   -5 }, /* (45) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  251,   -1 }, /* (46) dnode_endpoint ::= NK_STRING */
  {  252,   -1 }, /* (47) dnode_host_name ::= NK_ID */
  {  252,   -1 }, /* (48) dnode_host_name ::= NK_IPTOKEN */
  {  240,   -3 }, /* (49) cmd ::= ALTER LOCAL NK_STRING */
  {  240,   -4 }, /* (50) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  240,   -5 }, /* (51) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (52) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (53) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (54) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (55) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (56) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (57) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (58) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  240,   -5 }, /* (59) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  240,   -4 }, /* (60) cmd ::= DROP DATABASE exists_opt db_name */
  {  240,   -2 }, /* (61) cmd ::= USE db_name */
  {  240,   -4 }, /* (62) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  253,   -3 }, /* (63) not_exists_opt ::= IF NOT EXISTS */
  {  253,    0 }, /* (64) not_exists_opt ::= */
  {  255,   -2 }, /* (65) exists_opt ::= IF EXISTS */
  {  255,    0 }, /* (66) exists_opt ::= */
  {  254,    0 }, /* (67) db_options ::= */
  {  254,   -3 }, /* (68) db_options ::= db_options BUFFER NK_INTEGER */
  {  254,   -3 }, /* (69) db_options ::= db_options CACHELAST NK_INTEGER */
  {  254,   -3 }, /* (70) db_options ::= db_options COMP NK_INTEGER */
  {  254,   -3 }, /* (71) db_options ::= db_options DAYS NK_INTEGER */
  {  254,   -3 }, /* (72) db_options ::= db_options DAYS NK_VARIABLE */
  {  254,   -3 }, /* (73) db_options ::= db_options FSYNC NK_INTEGER */
  {  254,   -3 }, /* (74) db_options ::= db_options MAXROWS NK_INTEGER */
  {  254,   -3 }, /* (75) db_options ::= db_options MINROWS NK_INTEGER */
  {  254,   -3 }, /* (76) db_options ::= db_options KEEP integer_list */
  {  254,   -3 }, /* (77) db_options ::= db_options KEEP variable_list */
  {  254,   -3 }, /* (78) db_options ::= db_options PAGES NK_INTEGER */
  {  254,   -3 }, /* (79) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  254,   -3 }, /* (80) db_options ::= db_options PRECISION NK_STRING */
  {  254,   -3 }, /* (81) db_options ::= db_options REPLICA NK_INTEGER */
  {  254,   -3 }, /* (82) db_options ::= db_options STRICT NK_INTEGER */
  {  254,   -3 }, /* (83) db_options ::= db_options WAL NK_INTEGER */
  {  254,   -3 }, /* (84) db_options ::= db_options VGROUPS NK_INTEGER */
  {  254,   -3 }, /* (85) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  254,   -3 }, /* (86) db_options ::= db_options RETENTIONS retention_list */
  {  254,   -3 }, /* (87) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  256,   -1 }, /* (88) alter_db_options ::= alter_db_option */
  {  256,   -2 }, /* (89) alter_db_options ::= alter_db_options alter_db_option */
  {  260,   -2 }, /* (90) alter_db_option ::= BUFFER NK_INTEGER */
  {  260,   -2 }, /* (91) alter_db_option ::= CACHELAST NK_INTEGER */
  {  260,   -2 }, /* (92) alter_db_option ::= FSYNC NK_INTEGER */
  {  260,   -2 }, /* (93) alter_db_option ::= KEEP integer_list */
  {  260,   -2 }, /* (94) alter_db_option ::= KEEP variable_list */
  {  260,   -2 }, /* (95) alter_db_option ::= PAGES NK_INTEGER */
  {  260,   -2 }, /* (96) alter_db_option ::= REPLICA NK_INTEGER */
  {  260,   -2 }, /* (97) alter_db_option ::= STRICT NK_INTEGER */
  {  260,   -2 }, /* (98) alter_db_option ::= WAL NK_INTEGER */
  {  257,   -1 }, /* (99) integer_list ::= NK_INTEGER */
  {  257,   -3 }, /* (100) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  258,   -1 }, /* (101) variable_list ::= NK_VARIABLE */
  {  258,   -3 }, /* (102) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  259,   -1 }, /* (103) retention_list ::= retention */
  {  259,   -3 }, /* (104) retention_list ::= retention_list NK_COMMA retention */
  {  261,   -3 }, /* (105) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  240,   -9 }, /* (106) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  240,   -3 }, /* (107) cmd ::= CREATE TABLE multi_create_clause */
  {  240,   -9 }, /* (108) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  240,   -3 }, /* (109) cmd ::= DROP TABLE multi_drop_clause */
  {  240,   -4 }, /* (110) cmd ::= DROP STABLE exists_opt full_table_name */
  {  240,   -3 }, /* (111) cmd ::= ALTER TABLE alter_table_clause */
  {  240,   -3 }, /* (112) cmd ::= ALTER STABLE alter_table_clause */
  {  269,   -2 }, /* (113) alter_table_clause ::= full_table_name alter_table_options */
  {  269,   -5 }, /* (114) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  269,   -4 }, /* (115) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  269,   -5 }, /* (116) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  269,   -5 }, /* (117) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  269,   -5 }, /* (118) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  269,   -4 }, /* (119) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  269,   -5 }, /* (120) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  269,   -5 }, /* (121) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  269,   -6 }, /* (122) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  266,   -1 }, /* (123) multi_create_clause ::= create_subtable_clause */
  {  266,   -2 }, /* (124) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  274,  -10 }, /* (125) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
  {  268,   -1 }, /* (126) multi_drop_clause ::= drop_table_clause */
  {  268,   -2 }, /* (127) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  277,   -2 }, /* (128) drop_table_clause ::= exists_opt full_table_name */
  {  275,    0 }, /* (129) specific_tags_opt ::= */
  {  275,   -3 }, /* (130) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  262,   -1 }, /* (131) full_table_name ::= table_name */
  {  262,   -3 }, /* (132) full_table_name ::= db_name NK_DOT table_name */
  {  263,   -1 }, /* (133) column_def_list ::= column_def */
  {  263,   -3 }, /* (134) column_def_list ::= column_def_list NK_COMMA column_def */
  {  280,   -2 }, /* (135) column_def ::= column_name type_name */
  {  280,   -4 }, /* (136) column_def ::= column_name type_name COMMENT NK_STRING */
  {  272,   -1 }, /* (137) type_name ::= BOOL */
  {  272,   -1 }, /* (138) type_name ::= TINYINT */
  {  272,   -1 }, /* (139) type_name ::= SMALLINT */
  {  272,   -1 }, /* (140) type_name ::= INT */
  {  272,   -1 }, /* (141) type_name ::= INTEGER */
  {  272,   -1 }, /* (142) type_name ::= BIGINT */
  {  272,   -1 }, /* (143) type_name ::= FLOAT */
  {  272,   -1 }, /* (144) type_name ::= DOUBLE */
  {  272,   -4 }, /* (145) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  272,   -1 }, /* (146) type_name ::= TIMESTAMP */
  {  272,   -4 }, /* (147) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  272,   -2 }, /* (148) type_name ::= TINYINT UNSIGNED */
  {  272,   -2 }, /* (149) type_name ::= SMALLINT UNSIGNED */
  {  272,   -2 }, /* (150) type_name ::= INT UNSIGNED */
  {  272,   -2 }, /* (151) type_name ::= BIGINT UNSIGNED */
  {  272,   -1 }, /* (152) type_name ::= JSON */
  {  272,   -4 }, /* (153) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  272,   -1 }, /* (154) type_name ::= MEDIUMBLOB */
  {  272,   -1 }, /* (155) type_name ::= BLOB */
  {  272,   -4 }, /* (156) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  272,   -1 }, /* (157) type_name ::= DECIMAL */
  {  272,   -4 }, /* (158) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  272,   -6 }, /* (159) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  264,    0 }, /* (160) tags_def_opt ::= */
  {  264,   -1 }, /* (161) tags_def_opt ::= tags_def */
  {  267,   -4 }, /* (162) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  265,    0 }, /* (163) table_options ::= */
  {  265,   -3 }, /* (164) table_options ::= table_options COMMENT NK_STRING */
  {  265,   -3 }, /* (165) table_options ::= table_options DELAY NK_INTEGER */
  {  265,   -3 }, /* (166) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  265,   -5 }, /* (167) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  265,   -3 }, /* (168) table_options ::= table_options TTL NK_INTEGER */
  {  265,   -5 }, /* (169) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  270,   -1 }, /* (170) alter_table_options ::= alter_table_option */
  {  270,   -2 }, /* (171) alter_table_options ::= alter_table_options alter_table_option */
  {  282,   -2 }, /* (172) alter_table_option ::= COMMENT NK_STRING */
  {  282,   -2 }, /* (173) alter_table_option ::= TTL NK_INTEGER */
  {  278,   -1 }, /* (174) col_name_list ::= col_name */
  {  278,   -3 }, /* (175) col_name_list ::= col_name_list NK_COMMA col_name */
  {  283,   -1 }, /* (176) col_name ::= column_name */
  {  240,   -2 }, /* (177) cmd ::= SHOW DNODES */
  {  240,   -2 }, /* (178) cmd ::= SHOW USERS */
  {  240,   -2 }, /* (179) cmd ::= SHOW DATABASES */
  {  240,   -4 }, /* (180) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  240,   -4 }, /* (181) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  240,   -3 }, /* (182) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  240,   -2 }, /* (183) cmd ::= SHOW MNODES */
  {  240,   -2 }, /* (184) cmd ::= SHOW MODULES */
  {  240,   -2 }, /* (185) cmd ::= SHOW QNODES */
  {  240,   -2 }, /* (186) cmd ::= SHOW FUNCTIONS */
  {  240,   -5 }, /* (187) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  240,   -2 }, /* (188) cmd ::= SHOW STREAMS */
  {  240,   -2 }, /* (189) cmd ::= SHOW ACCOUNTS */
  {  240,   -2 }, /* (190) cmd ::= SHOW APPS */
  {  240,   -2 }, /* (191) cmd ::= SHOW CONNECTIONS */
  {  240,   -2 }, /* (192) cmd ::= SHOW LICENCE */
  {  240,   -2 }, /* (193) cmd ::= SHOW GRANTS */
  {  240,   -4 }, /* (194) cmd ::= SHOW CREATE DATABASE db_name */
  {  240,   -4 }, /* (195) cmd ::= SHOW CREATE TABLE full_table_name */
  {  240,   -4 }, /* (196) cmd ::= SHOW CREATE STABLE full_table_name */
  {  240,   -2 }, /* (197) cmd ::= SHOW QUERIES */
  {  240,   -2 }, /* (198) cmd ::= SHOW SCORES */
  {  240,   -2 }, /* (199) cmd ::= SHOW TOPICS */
  {  240,   -2 }, /* (200) cmd ::= SHOW VARIABLES */
  {  240,   -2 }, /* (201) cmd ::= SHOW BNODES */
  {  240,   -2 }, /* (202) cmd ::= SHOW SNODES */
  {  240,   -2 }, /* (203) cmd ::= SHOW CLUSTER */
  {  240,   -2 }, /* (204) cmd ::= SHOW TRANSACTIONS */
  {  284,    0 }, /* (205) db_name_cond_opt ::= */
  {  284,   -2 }, /* (206) db_name_cond_opt ::= db_name NK_DOT */
  {  285,    0 }, /* (207) like_pattern_opt ::= */
  {  285,   -2 }, /* (208) like_pattern_opt ::= LIKE NK_STRING */
  {  286,   -1 }, /* (209) table_name_cond ::= table_name */
  {  287,    0 }, /* (210) from_db_opt ::= */
  {  287,   -2 }, /* (211) from_db_opt ::= FROM db_name */
  {  281,   -1 }, /* (212) func_name_list ::= func_name */
  {  281,   -3 }, /* (213) func_name_list ::= func_name_list NK_COMMA func_name */
  {  288,   -1 }, /* (214) func_name ::= function_name */
  {  240,   -8 }, /* (215) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  240,  -10 }, /* (216) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  240,   -6 }, /* (217) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  291,    0 }, /* (218) index_options ::= */
  {  291,   -9 }, /* (219) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  291,  -11 }, /* (220) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  292,   -1 }, /* (221) func_list ::= func */
  {  292,   -3 }, /* (222) func_list ::= func_list NK_COMMA func */
  {  295,   -4 }, /* (223) func ::= function_name NK_LP expression_list NK_RP */
  {  240,   -7 }, /* (224) cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS query_expression */
  {  240,   -7 }, /* (225) cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS db_name */
  {  240,   -4 }, /* (226) cmd ::= DROP TOPIC exists_opt topic_name */
  {  240,   -6 }, /* (227) cmd ::= DROP CGROUP exists_opt cgroup_name ON topic_name */
  {  298,    0 }, /* (228) topic_options ::= */
  {  298,   -3 }, /* (229) topic_options ::= topic_options WITH TABLE */
  {  298,   -3 }, /* (230) topic_options ::= topic_options WITH SCHEMA */
  {  298,   -3 }, /* (231) topic_options ::= topic_options WITH TAG */
  {  240,   -2 }, /* (232) cmd ::= DESC full_table_name */
  {  240,   -2 }, /* (233) cmd ::= DESCRIBE full_table_name */
  {  240,   -3 }, /* (234) cmd ::= RESET QUERY CACHE */
  {  240,   -4 }, /* (235) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  301,    0 }, /* (236) analyze_opt ::= */
  {  301,   -1 }, /* (237) analyze_opt ::= ANALYZE */
  {  302,    0 }, /* (238) explain_options ::= */
  {  302,   -3 }, /* (239) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  302,   -3 }, /* (240) explain_options ::= explain_options RATIO NK_FLOAT */
  {  240,   -6 }, /* (241) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  240,  -10 }, /* (242) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  240,   -4 }, /* (243) cmd ::= DROP FUNCTION exists_opt function_name */
  {  303,    0 }, /* (244) agg_func_opt ::= */
  {  303,   -1 }, /* (245) agg_func_opt ::= AGGREGATE */
  {  304,    0 }, /* (246) bufsize_opt ::= */
  {  304,   -2 }, /* (247) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  240,   -8 }, /* (248) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  240,   -4 }, /* (249) cmd ::= DROP STREAM exists_opt stream_name */
  {  307,    0 }, /* (250) into_opt ::= */
  {  307,   -2 }, /* (251) into_opt ::= INTO full_table_name */
  {  306,    0 }, /* (252) stream_options ::= */
  {  306,   -3 }, /* (253) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  306,   -3 }, /* (254) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  306,   -3 }, /* (255) stream_options ::= stream_options WATERMARK duration_literal */
  {  240,   -3 }, /* (256) cmd ::= KILL CONNECTION NK_INTEGER */
  {  240,   -3 }, /* (257) cmd ::= KILL QUERY NK_INTEGER */
  {  240,   -3 }, /* (258) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  240,   -4 }, /* (259) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  240,   -4 }, /* (260) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  240,   -3 }, /* (261) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  308,   -2 }, /* (262) dnode_list ::= DNODE NK_INTEGER */
  {  308,   -3 }, /* (263) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  240,   -3 }, /* (264) cmd ::= SYNCDB db_name REPLICA */
  {  240,   -1 }, /* (265) cmd ::= query_expression */
  {  243,   -1 }, /* (266) literal ::= NK_INTEGER */
  {  243,   -1 }, /* (267) literal ::= NK_FLOAT */
  {  243,   -1 }, /* (268) literal ::= NK_STRING */
  {  243,   -1 }, /* (269) literal ::= NK_BOOL */
  {  243,   -2 }, /* (270) literal ::= TIMESTAMP NK_STRING */
  {  243,   -1 }, /* (271) literal ::= duration_literal */
  {  243,   -1 }, /* (272) literal ::= NULL */
  {  243,   -1 }, /* (273) literal ::= NK_QUESTION */
  {  293,   -1 }, /* (274) duration_literal ::= NK_VARIABLE */
  {  309,   -1 }, /* (275) signed ::= NK_INTEGER */
  {  309,   -2 }, /* (276) signed ::= NK_PLUS NK_INTEGER */
  {  309,   -2 }, /* (277) signed ::= NK_MINUS NK_INTEGER */
  {  309,   -1 }, /* (278) signed ::= NK_FLOAT */
  {  309,   -2 }, /* (279) signed ::= NK_PLUS NK_FLOAT */
  {  309,   -2 }, /* (280) signed ::= NK_MINUS NK_FLOAT */
  {  273,   -1 }, /* (281) signed_literal ::= signed */
  {  273,   -1 }, /* (282) signed_literal ::= NK_STRING */
  {  273,   -1 }, /* (283) signed_literal ::= NK_BOOL */
  {  273,   -2 }, /* (284) signed_literal ::= TIMESTAMP NK_STRING */
  {  273,   -1 }, /* (285) signed_literal ::= duration_literal */
  {  273,   -1 }, /* (286) signed_literal ::= NULL */
  {  273,   -1 }, /* (287) signed_literal ::= literal_func */
  {  276,   -1 }, /* (288) literal_list ::= signed_literal */
  {  276,   -3 }, /* (289) literal_list ::= literal_list NK_COMMA signed_literal */
  {  250,   -1 }, /* (290) db_name ::= NK_ID */
  {  279,   -1 }, /* (291) table_name ::= NK_ID */
  {  271,   -1 }, /* (292) column_name ::= NK_ID */
  {  289,   -1 }, /* (293) function_name ::= NK_ID */
  {  311,   -1 }, /* (294) table_alias ::= NK_ID */
  {  312,   -1 }, /* (295) column_alias ::= NK_ID */
  {  245,   -1 }, /* (296) user_name ::= NK_ID */
  {  290,   -1 }, /* (297) index_name ::= NK_ID */
  {  297,   -1 }, /* (298) topic_name ::= NK_ID */
  {  305,   -1 }, /* (299) stream_name ::= NK_ID */
  {  300,   -1 }, /* (300) cgroup_name ::= NK_ID */
  {  313,   -1 }, /* (301) expression ::= literal */
  {  313,   -1 }, /* (302) expression ::= pseudo_column */
  {  313,   -1 }, /* (303) expression ::= column_reference */
  {  313,   -1 }, /* (304) expression ::= function_expression */
  {  313,   -1 }, /* (305) expression ::= subquery */
  {  313,   -3 }, /* (306) expression ::= NK_LP expression NK_RP */
  {  313,   -2 }, /* (307) expression ::= NK_PLUS expression */
  {  313,   -2 }, /* (308) expression ::= NK_MINUS expression */
  {  313,   -3 }, /* (309) expression ::= expression NK_PLUS expression */
  {  313,   -3 }, /* (310) expression ::= expression NK_MINUS expression */
  {  313,   -3 }, /* (311) expression ::= expression NK_STAR expression */
  {  313,   -3 }, /* (312) expression ::= expression NK_SLASH expression */
  {  313,   -3 }, /* (313) expression ::= expression NK_REM expression */
  {  313,   -3 }, /* (314) expression ::= column_reference NK_ARROW NK_STRING */
  {  296,   -1 }, /* (315) expression_list ::= expression */
  {  296,   -3 }, /* (316) expression_list ::= expression_list NK_COMMA expression */
  {  315,   -1 }, /* (317) column_reference ::= column_name */
  {  315,   -3 }, /* (318) column_reference ::= table_name NK_DOT column_name */
  {  314,   -1 }, /* (319) pseudo_column ::= ROWTS */
  {  314,   -1 }, /* (320) pseudo_column ::= TBNAME */
  {  314,   -3 }, /* (321) pseudo_column ::= table_name NK_DOT TBNAME */
  {  314,   -1 }, /* (322) pseudo_column ::= QSTARTTS */
  {  314,   -1 }, /* (323) pseudo_column ::= QENDTS */
  {  314,   -1 }, /* (324) pseudo_column ::= WSTARTTS */
  {  314,   -1 }, /* (325) pseudo_column ::= WENDTS */
  {  314,   -1 }, /* (326) pseudo_column ::= WDURATION */
  {  316,   -4 }, /* (327) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  316,   -4 }, /* (328) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  316,   -6 }, /* (329) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  316,   -1 }, /* (330) function_expression ::= literal_func */
  {  310,   -3 }, /* (331) literal_func ::= noarg_func NK_LP NK_RP */
  {  310,   -1 }, /* (332) literal_func ::= NOW */
  {  320,   -1 }, /* (333) noarg_func ::= NOW */
  {  320,   -1 }, /* (334) noarg_func ::= TODAY */
  {  320,   -1 }, /* (335) noarg_func ::= TIMEZONE */
  {  318,   -1 }, /* (336) star_func ::= COUNT */
  {  318,   -1 }, /* (337) star_func ::= FIRST */
  {  318,   -1 }, /* (338) star_func ::= LAST */
  {  318,   -1 }, /* (339) star_func ::= LAST_ROW */
  {  319,   -1 }, /* (340) star_func_para_list ::= NK_STAR */
  {  319,   -1 }, /* (341) star_func_para_list ::= other_para_list */
  {  321,   -1 }, /* (342) other_para_list ::= star_func_para */
  {  321,   -3 }, /* (343) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  322,   -1 }, /* (344) star_func_para ::= expression */
  {  322,   -3 }, /* (345) star_func_para ::= table_name NK_DOT NK_STAR */
  {  323,   -3 }, /* (346) predicate ::= expression compare_op expression */
  {  323,   -5 }, /* (347) predicate ::= expression BETWEEN expression AND expression */
  {  323,   -6 }, /* (348) predicate ::= expression NOT BETWEEN expression AND expression */
  {  323,   -3 }, /* (349) predicate ::= expression IS NULL */
  {  323,   -4 }, /* (350) predicate ::= expression IS NOT NULL */
  {  323,   -3 }, /* (351) predicate ::= expression in_op in_predicate_value */
  {  324,   -1 }, /* (352) compare_op ::= NK_LT */
  {  324,   -1 }, /* (353) compare_op ::= NK_GT */
  {  324,   -1 }, /* (354) compare_op ::= NK_LE */
  {  324,   -1 }, /* (355) compare_op ::= NK_GE */
  {  324,   -1 }, /* (356) compare_op ::= NK_NE */
  {  324,   -1 }, /* (357) compare_op ::= NK_EQ */
  {  324,   -1 }, /* (358) compare_op ::= LIKE */
  {  324,   -2 }, /* (359) compare_op ::= NOT LIKE */
  {  324,   -1 }, /* (360) compare_op ::= MATCH */
  {  324,   -1 }, /* (361) compare_op ::= NMATCH */
  {  324,   -1 }, /* (362) compare_op ::= CONTAINS */
  {  325,   -1 }, /* (363) in_op ::= IN */
  {  325,   -2 }, /* (364) in_op ::= NOT IN */
  {  326,   -3 }, /* (365) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  327,   -1 }, /* (366) boolean_value_expression ::= boolean_primary */
  {  327,   -2 }, /* (367) boolean_value_expression ::= NOT boolean_primary */
  {  327,   -3 }, /* (368) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  327,   -3 }, /* (369) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  328,   -1 }, /* (370) boolean_primary ::= predicate */
  {  328,   -3 }, /* (371) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  329,   -1 }, /* (372) common_expression ::= expression */
  {  329,   -1 }, /* (373) common_expression ::= boolean_value_expression */
  {  330,   -2 }, /* (374) from_clause ::= FROM table_reference_list */
  {  331,   -1 }, /* (375) table_reference_list ::= table_reference */
  {  331,   -3 }, /* (376) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  332,   -1 }, /* (377) table_reference ::= table_primary */
  {  332,   -1 }, /* (378) table_reference ::= joined_table */
  {  333,   -2 }, /* (379) table_primary ::= table_name alias_opt */
  {  333,   -4 }, /* (380) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  333,   -2 }, /* (381) table_primary ::= subquery alias_opt */
  {  333,   -1 }, /* (382) table_primary ::= parenthesized_joined_table */
  {  335,    0 }, /* (383) alias_opt ::= */
  {  335,   -1 }, /* (384) alias_opt ::= table_alias */
  {  335,   -2 }, /* (385) alias_opt ::= AS table_alias */
  {  336,   -3 }, /* (386) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  336,   -3 }, /* (387) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  334,   -6 }, /* (388) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  337,    0 }, /* (389) join_type ::= */
  {  337,   -1 }, /* (390) join_type ::= INNER */
  {  339,   -9 }, /* (391) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  340,    0 }, /* (392) set_quantifier_opt ::= */
  {  340,   -1 }, /* (393) set_quantifier_opt ::= DISTINCT */
  {  340,   -1 }, /* (394) set_quantifier_opt ::= ALL */
  {  341,   -1 }, /* (395) select_list ::= NK_STAR */
  {  341,   -1 }, /* (396) select_list ::= select_sublist */
  {  347,   -1 }, /* (397) select_sublist ::= select_item */
  {  347,   -3 }, /* (398) select_sublist ::= select_sublist NK_COMMA select_item */
  {  348,   -1 }, /* (399) select_item ::= common_expression */
  {  348,   -2 }, /* (400) select_item ::= common_expression column_alias */
  {  348,   -3 }, /* (401) select_item ::= common_expression AS column_alias */
  {  348,   -3 }, /* (402) select_item ::= table_name NK_DOT NK_STAR */
  {  342,    0 }, /* (403) where_clause_opt ::= */
  {  342,   -2 }, /* (404) where_clause_opt ::= WHERE search_condition */
  {  343,    0 }, /* (405) partition_by_clause_opt ::= */
  {  343,   -3 }, /* (406) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  344,    0 }, /* (407) twindow_clause_opt ::= */
  {  344,   -6 }, /* (408) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  344,   -4 }, /* (409) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  344,   -6 }, /* (410) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  344,   -8 }, /* (411) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  294,    0 }, /* (412) sliding_opt ::= */
  {  294,   -4 }, /* (413) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  349,    0 }, /* (414) fill_opt ::= */
  {  349,   -4 }, /* (415) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  349,   -6 }, /* (416) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  350,   -1 }, /* (417) fill_mode ::= NONE */
  {  350,   -1 }, /* (418) fill_mode ::= PREV */
  {  350,   -1 }, /* (419) fill_mode ::= NULL */
  {  350,   -1 }, /* (420) fill_mode ::= LINEAR */
  {  350,   -1 }, /* (421) fill_mode ::= NEXT */
  {  345,    0 }, /* (422) group_by_clause_opt ::= */
  {  345,   -3 }, /* (423) group_by_clause_opt ::= GROUP BY group_by_list */
  {  351,   -1 }, /* (424) group_by_list ::= expression */
  {  351,   -3 }, /* (425) group_by_list ::= group_by_list NK_COMMA expression */
  {  346,    0 }, /* (426) having_clause_opt ::= */
  {  346,   -2 }, /* (427) having_clause_opt ::= HAVING search_condition */
  {  299,   -4 }, /* (428) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  352,   -1 }, /* (429) query_expression_body ::= query_primary */
  {  352,   -4 }, /* (430) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  352,   -3 }, /* (431) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  356,   -1 }, /* (432) query_primary ::= query_specification */
  {  356,   -6 }, /* (433) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  353,    0 }, /* (434) order_by_clause_opt ::= */
  {  353,   -3 }, /* (435) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  354,    0 }, /* (436) slimit_clause_opt ::= */
  {  354,   -2 }, /* (437) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  354,   -4 }, /* (438) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  354,   -4 }, /* (439) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  355,    0 }, /* (440) limit_clause_opt ::= */
  {  355,   -2 }, /* (441) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  355,   -4 }, /* (442) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  355,   -4 }, /* (443) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  317,   -3 }, /* (444) subquery ::= NK_LP query_expression NK_RP */
  {  338,   -1 }, /* (445) search_condition ::= common_expression */
  {  357,   -1 }, /* (446) sort_specification_list ::= sort_specification */
  {  357,   -3 }, /* (447) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  358,   -3 }, /* (448) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  359,    0 }, /* (449) ordering_specification_opt ::= */
  {  359,   -1 }, /* (450) ordering_specification_opt ::= ASC */
  {  359,   -1 }, /* (451) ordering_specification_opt ::= DESC */
  {  360,    0 }, /* (452) null_ordering_opt ::= */
  {  360,   -2 }, /* (453) null_ordering_opt ::= NULLS FIRST */
  {  360,   -2 }, /* (454) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,241,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,242,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,241,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,243,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,244,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,242,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,244,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,243,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy53, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy53, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy53, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy53); }
        break;
      case 28: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy435, &yymsp[-2].minor.yy53, &yymsp[0].minor.yy53); }
        break;
      case 29: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy435, &yymsp[-2].minor.yy53, &yymsp[0].minor.yy53); }
        break;
      case 30: /* privileges ::= ALL */
{ yymsp[0].minor.yy435 = PRIVILEGE_TYPE_ALL; }
        break;
      case 31: /* privileges ::= priv_type_list */
      case 32: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==32);
{ yylhsminor.yy435 = yymsp[0].minor.yy435; }
  yymsp[0].minor.yy435 = yylhsminor.yy435;
        break;
      case 33: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy435 = yymsp[-2].minor.yy435 | yymsp[0].minor.yy435; }
  yymsp[-2].minor.yy435 = yylhsminor.yy435;
        break;
      case 34: /* priv_type ::= READ */
{ yymsp[0].minor.yy435 = PRIVILEGE_TYPE_READ; }
        break;
      case 35: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy435 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 36: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy53 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy53 = yylhsminor.yy53;
        break;
      case 37: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy53 = yymsp[-2].minor.yy53; }
  yymsp[-2].minor.yy53 = yylhsminor.yy53;
        break;
      case 38: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy53, NULL); }
        break;
      case 39: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy53, &yymsp[0].minor.yy0); }
        break;
      case 40: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy53); }
        break;
      case 42: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 43: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 45: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 46: /* dnode_endpoint ::= NK_STRING */
      case 47: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==47);
      case 48: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==48);
      case 290: /* db_name ::= NK_ID */ yytestcase(yyruleno==290);
      case 291: /* table_name ::= NK_ID */ yytestcase(yyruleno==291);
      case 292: /* column_name ::= NK_ID */ yytestcase(yyruleno==292);
      case 293: /* function_name ::= NK_ID */ yytestcase(yyruleno==293);
      case 294: /* table_alias ::= NK_ID */ yytestcase(yyruleno==294);
      case 295: /* column_alias ::= NK_ID */ yytestcase(yyruleno==295);
      case 296: /* user_name ::= NK_ID */ yytestcase(yyruleno==296);
      case 297: /* index_name ::= NK_ID */ yytestcase(yyruleno==297);
      case 298: /* topic_name ::= NK_ID */ yytestcase(yyruleno==298);
      case 299: /* stream_name ::= NK_ID */ yytestcase(yyruleno==299);
      case 300: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==300);
      case 333: /* noarg_func ::= NOW */ yytestcase(yyruleno==333);
      case 334: /* noarg_func ::= TODAY */ yytestcase(yyruleno==334);
      case 335: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==335);
      case 336: /* star_func ::= COUNT */ yytestcase(yyruleno==336);
      case 337: /* star_func ::= FIRST */ yytestcase(yyruleno==337);
      case 338: /* star_func ::= LAST */ yytestcase(yyruleno==338);
      case 339: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==339);
{ yylhsminor.yy53 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy53 = yylhsminor.yy53;
        break;
      case 49: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 52: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 53: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy603, &yymsp[-1].minor.yy53, yymsp[0].minor.yy636); }
        break;
      case 60: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy603, &yymsp[0].minor.yy53); }
        break;
      case 61: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy53); }
        break;
      case 62: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy53, yymsp[0].minor.yy636); }
        break;
      case 63: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy603 = true; }
        break;
      case 64: /* not_exists_opt ::= */
      case 66: /* exists_opt ::= */ yytestcase(yyruleno==66);
      case 236: /* analyze_opt ::= */ yytestcase(yyruleno==236);
      case 244: /* agg_func_opt ::= */ yytestcase(yyruleno==244);
      case 392: /* set_quantifier_opt ::= */ yytestcase(yyruleno==392);
{ yymsp[1].minor.yy603 = false; }
        break;
      case 65: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy603 = true; }
        break;
      case 67: /* db_options ::= */
{ yymsp[1].minor.yy636 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 68: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy636 = setDatabaseOption(pCxt, yymsp[-2].minor.yy636, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 69: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy636 = setDatabaseOption(pCxt, yymsp[-2].minor.yy636, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 70: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy636 = setDatabaseOption(pCxt, yymsp[-2].minor.yy636, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 71: /* db_options ::= db_options DAYS NK_INTEGER */
      case 72: /* db_options ::= db_options DAYS NK_VARIABLE */ yytestcase(yyruleno==72);
{ yylhsminor.yy636 = setDatabaseOption(pCxt, yymsp[-2].minor.yy636, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 73: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy636 = setDatabaseOption(pCxt, yymsp[-2].minor.yy636, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 74: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy636 = setDatabaseOption(pCxt, yymsp[-2].minor.yy636, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 75: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy636 = setDatabaseOption(pCxt, yymsp[-2].minor.yy636, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 76: /* db_options ::= db_options KEEP integer_list */
      case 77: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==77);
{ yylhsminor.yy636 = setDatabaseOption(pCxt, yymsp[-2].minor.yy636, DB_OPTION_KEEP, yymsp[0].minor.yy236); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 78: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy636 = setDatabaseOption(pCxt, yymsp[-2].minor.yy636, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 79: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy636 = setDatabaseOption(pCxt, yymsp[-2].minor.yy636, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 80: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy636 = setDatabaseOption(pCxt, yymsp[-2].minor.yy636, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 81: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy636 = setDatabaseOption(pCxt, yymsp[-2].minor.yy636, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 82: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy636 = setDatabaseOption(pCxt, yymsp[-2].minor.yy636, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 83: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy636 = setDatabaseOption(pCxt, yymsp[-2].minor.yy636, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 84: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy636 = setDatabaseOption(pCxt, yymsp[-2].minor.yy636, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 85: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy636 = setDatabaseOption(pCxt, yymsp[-2].minor.yy636, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 86: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy636 = setDatabaseOption(pCxt, yymsp[-2].minor.yy636, DB_OPTION_RETENTIONS, yymsp[0].minor.yy236); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 87: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy636 = setDatabaseOption(pCxt, yymsp[-2].minor.yy636, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 88: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy636 = createAlterDatabaseOptions(pCxt); yylhsminor.yy636 = setAlterDatabaseOption(pCxt, yylhsminor.yy636, &yymsp[0].minor.yy25); }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 89: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy636 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy636, &yymsp[0].minor.yy25); }
  yymsp[-1].minor.yy636 = yylhsminor.yy636;
        break;
      case 90: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy25.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 91: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy25.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 92: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy25.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 93: /* alter_db_option ::= KEEP integer_list */
      case 94: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==94);
{ yymsp[-1].minor.yy25.type = DB_OPTION_KEEP; yymsp[-1].minor.yy25.pList = yymsp[0].minor.yy236; }
        break;
      case 95: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy25.type = DB_OPTION_PAGES; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 96: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy25.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 97: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy25.type = DB_OPTION_STRICT; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 98: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy25.type = DB_OPTION_WAL; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 99: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy236 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy236 = yylhsminor.yy236;
        break;
      case 100: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 263: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==263);
{ yylhsminor.yy236 = addNodeToList(pCxt, yymsp[-2].minor.yy236, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy236 = yylhsminor.yy236;
        break;
      case 101: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy236 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy236 = yylhsminor.yy236;
        break;
      case 102: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy236 = addNodeToList(pCxt, yymsp[-2].minor.yy236, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy236 = yylhsminor.yy236;
        break;
      case 103: /* retention_list ::= retention */
      case 123: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==123);
      case 126: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==126);
      case 133: /* column_def_list ::= column_def */ yytestcase(yyruleno==133);
      case 174: /* col_name_list ::= col_name */ yytestcase(yyruleno==174);
      case 212: /* func_name_list ::= func_name */ yytestcase(yyruleno==212);
      case 221: /* func_list ::= func */ yytestcase(yyruleno==221);
      case 288: /* literal_list ::= signed_literal */ yytestcase(yyruleno==288);
      case 342: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==342);
      case 397: /* select_sublist ::= select_item */ yytestcase(yyruleno==397);
      case 446: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==446);
{ yylhsminor.yy236 = createNodeList(pCxt, yymsp[0].minor.yy636); }
  yymsp[0].minor.yy236 = yylhsminor.yy236;
        break;
      case 104: /* retention_list ::= retention_list NK_COMMA retention */
      case 134: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==134);
      case 175: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==175);
      case 213: /* func_name_list ::= func_name_list NK_COMMA func_name */ yytestcase(yyruleno==213);
      case 222: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==222);
      case 289: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==289);
      case 343: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==343);
      case 398: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==398);
      case 447: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==447);
{ yylhsminor.yy236 = addNodeToList(pCxt, yymsp[-2].minor.yy236, yymsp[0].minor.yy636); }
  yymsp[-2].minor.yy236 = yylhsminor.yy236;
        break;
      case 105: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy636 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 106: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 108: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==108);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy603, yymsp[-5].minor.yy636, yymsp[-3].minor.yy236, yymsp[-1].minor.yy236, yymsp[0].minor.yy636); }
        break;
      case 107: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy236); }
        break;
      case 109: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy236); }
        break;
      case 110: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy603, yymsp[0].minor.yy636); }
        break;
      case 111: /* cmd ::= ALTER TABLE alter_table_clause */
      case 112: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==112);
      case 265: /* cmd ::= query_expression */ yytestcase(yyruleno==265);
{ pCxt->pRootNode = yymsp[0].minor.yy636; }
        break;
      case 113: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy636 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy636, yymsp[0].minor.yy636); }
  yymsp[-1].minor.yy636 = yylhsminor.yy636;
        break;
      case 114: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy636 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy636, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy53, yymsp[0].minor.yy450); }
  yymsp[-4].minor.yy636 = yylhsminor.yy636;
        break;
      case 115: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy636 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy636, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy53); }
  yymsp[-3].minor.yy636 = yylhsminor.yy636;
        break;
      case 116: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy636 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy636, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy53, yymsp[0].minor.yy450); }
  yymsp[-4].minor.yy636 = yylhsminor.yy636;
        break;
      case 117: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy636 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy636, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy53, &yymsp[0].minor.yy53); }
  yymsp[-4].minor.yy636 = yylhsminor.yy636;
        break;
      case 118: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy636 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy636, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy53, yymsp[0].minor.yy450); }
  yymsp[-4].minor.yy636 = yylhsminor.yy636;
        break;
      case 119: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy636 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy636, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy53); }
  yymsp[-3].minor.yy636 = yylhsminor.yy636;
        break;
      case 120: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy636 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy636, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy53, yymsp[0].minor.yy450); }
  yymsp[-4].minor.yy636 = yylhsminor.yy636;
        break;
      case 121: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy636 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy636, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy53, &yymsp[0].minor.yy53); }
  yymsp[-4].minor.yy636 = yylhsminor.yy636;
        break;
      case 122: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy636 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy636, &yymsp[-2].minor.yy53, yymsp[0].minor.yy636); }
  yymsp[-5].minor.yy636 = yylhsminor.yy636;
        break;
      case 124: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 127: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==127);
{ yylhsminor.yy236 = addNodeToList(pCxt, yymsp[-1].minor.yy236, yymsp[0].minor.yy636); }
  yymsp[-1].minor.yy236 = yylhsminor.yy236;
        break;
      case 125: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
{ yylhsminor.yy636 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy603, yymsp[-8].minor.yy636, yymsp[-6].minor.yy636, yymsp[-5].minor.yy236, yymsp[-2].minor.yy236, yymsp[0].minor.yy636); }
  yymsp[-9].minor.yy636 = yylhsminor.yy636;
        break;
      case 128: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy636 = createDropTableClause(pCxt, yymsp[-1].minor.yy603, yymsp[0].minor.yy636); }
  yymsp[-1].minor.yy636 = yylhsminor.yy636;
        break;
      case 129: /* specific_tags_opt ::= */
      case 160: /* tags_def_opt ::= */ yytestcase(yyruleno==160);
      case 405: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==405);
      case 422: /* group_by_clause_opt ::= */ yytestcase(yyruleno==422);
      case 434: /* order_by_clause_opt ::= */ yytestcase(yyruleno==434);
{ yymsp[1].minor.yy236 = NULL; }
        break;
      case 130: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy236 = yymsp[-1].minor.yy236; }
        break;
      case 131: /* full_table_name ::= table_name */
{ yylhsminor.yy636 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy53, NULL); }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 132: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy636 = createRealTableNode(pCxt, &yymsp[-2].minor.yy53, &yymsp[0].minor.yy53, NULL); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 135: /* column_def ::= column_name type_name */
{ yylhsminor.yy636 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy53, yymsp[0].minor.yy450, NULL); }
  yymsp[-1].minor.yy636 = yylhsminor.yy636;
        break;
      case 136: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy636 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy53, yymsp[-2].minor.yy450, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy636 = yylhsminor.yy636;
        break;
      case 137: /* type_name ::= BOOL */
{ yymsp[0].minor.yy450 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 138: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy450 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 139: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy450 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 140: /* type_name ::= INT */
      case 141: /* type_name ::= INTEGER */ yytestcase(yyruleno==141);
{ yymsp[0].minor.yy450 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 142: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy450 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 143: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy450 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 144: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy450 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 145: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy450 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 146: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy450 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 147: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy450 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 148: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy450 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 149: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy450 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 150: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy450 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 151: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy450 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 152: /* type_name ::= JSON */
{ yymsp[0].minor.yy450 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 153: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy450 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 154: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy450 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 155: /* type_name ::= BLOB */
{ yymsp[0].minor.yy450 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 156: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy450 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy450 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 158: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy450 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 159: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy450 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 161: /* tags_def_opt ::= tags_def */
      case 341: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==341);
      case 396: /* select_list ::= select_sublist */ yytestcase(yyruleno==396);
{ yylhsminor.yy236 = yymsp[0].minor.yy236; }
  yymsp[0].minor.yy236 = yylhsminor.yy236;
        break;
      case 162: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy236 = yymsp[-1].minor.yy236; }
        break;
      case 163: /* table_options ::= */
{ yymsp[1].minor.yy636 = createDefaultTableOptions(pCxt); }
        break;
      case 164: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy636 = setTableOption(pCxt, yymsp[-2].minor.yy636, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 165: /* table_options ::= table_options DELAY NK_INTEGER */
{ yylhsminor.yy636 = setTableOption(pCxt, yymsp[-2].minor.yy636, TABLE_OPTION_DELAY, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 166: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ yylhsminor.yy636 = setTableOption(pCxt, yymsp[-2].minor.yy636, TABLE_OPTION_FILE_FACTOR, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 167: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ yylhsminor.yy636 = setTableOption(pCxt, yymsp[-4].minor.yy636, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy236); }
  yymsp[-4].minor.yy636 = yylhsminor.yy636;
        break;
      case 168: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy636 = setTableOption(pCxt, yymsp[-2].minor.yy636, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 169: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy636 = setTableOption(pCxt, yymsp[-4].minor.yy636, TABLE_OPTION_SMA, yymsp[-1].minor.yy236); }
  yymsp[-4].minor.yy636 = yylhsminor.yy636;
        break;
      case 170: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy636 = createAlterTableOptions(pCxt); yylhsminor.yy636 = setTableOption(pCxt, yylhsminor.yy636, yymsp[0].minor.yy25.type, &yymsp[0].minor.yy25.val); }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 171: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy636 = setTableOption(pCxt, yymsp[-1].minor.yy636, yymsp[0].minor.yy25.type, &yymsp[0].minor.yy25.val); }
  yymsp[-1].minor.yy636 = yylhsminor.yy636;
        break;
      case 172: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy25.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 173: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy25.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy25.val = yymsp[0].minor.yy0; }
        break;
      case 176: /* col_name ::= column_name */
{ yylhsminor.yy636 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy53); }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 177: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 178: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 179: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 180: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy636, yymsp[0].minor.yy636); }
        break;
      case 181: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy636, yymsp[0].minor.yy636); }
        break;
      case 182: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy636, NULL); }
        break;
      case 183: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 184: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 185: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 186: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 187: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy636, yymsp[0].minor.yy636); }
        break;
      case 188: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 189: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 190: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 191: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 192: /* cmd ::= SHOW LICENCE */
      case 193: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==193);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 194: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy53); }
        break;
      case 195: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy636); }
        break;
      case 196: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy636); }
        break;
      case 197: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 198: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 199: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 200: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 201: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT, NULL, NULL); }
        break;
      case 202: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT, NULL, NULL); }
        break;
      case 203: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT, NULL, NULL); }
        break;
      case 204: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT, NULL, NULL); }
        break;
      case 205: /* db_name_cond_opt ::= */
      case 210: /* from_db_opt ::= */ yytestcase(yyruleno==210);
{ yymsp[1].minor.yy636 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 206: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy636 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy53); }
  yymsp[-1].minor.yy636 = yylhsminor.yy636;
        break;
      case 207: /* like_pattern_opt ::= */
      case 218: /* index_options ::= */ yytestcase(yyruleno==218);
      case 250: /* into_opt ::= */ yytestcase(yyruleno==250);
      case 403: /* where_clause_opt ::= */ yytestcase(yyruleno==403);
      case 407: /* twindow_clause_opt ::= */ yytestcase(yyruleno==407);
      case 412: /* sliding_opt ::= */ yytestcase(yyruleno==412);
      case 414: /* fill_opt ::= */ yytestcase(yyruleno==414);
      case 426: /* having_clause_opt ::= */ yytestcase(yyruleno==426);
      case 436: /* slimit_clause_opt ::= */ yytestcase(yyruleno==436);
      case 440: /* limit_clause_opt ::= */ yytestcase(yyruleno==440);
{ yymsp[1].minor.yy636 = NULL; }
        break;
      case 208: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy636 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 209: /* table_name_cond ::= table_name */
{ yylhsminor.yy636 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy53); }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 211: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy636 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy53); }
        break;
      case 214: /* func_name ::= function_name */
{ yylhsminor.yy636 = createFunctionNode(pCxt, &yymsp[0].minor.yy53, NULL); }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 215: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy603, &yymsp[-3].minor.yy53, &yymsp[-1].minor.yy53, NULL, yymsp[0].minor.yy636); }
        break;
      case 216: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy603, &yymsp[-5].minor.yy53, &yymsp[-3].minor.yy53, yymsp[-1].minor.yy236, NULL); }
        break;
      case 217: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy603, &yymsp[-2].minor.yy53, &yymsp[0].minor.yy53); }
        break;
      case 219: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy636 = createIndexOption(pCxt, yymsp[-6].minor.yy236, releaseRawExprNode(pCxt, yymsp[-2].minor.yy636), NULL, yymsp[0].minor.yy636); }
        break;
      case 220: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy636 = createIndexOption(pCxt, yymsp[-8].minor.yy236, releaseRawExprNode(pCxt, yymsp[-4].minor.yy636), releaseRawExprNode(pCxt, yymsp[-2].minor.yy636), yymsp[0].minor.yy636); }
        break;
      case 223: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy636 = createFunctionNode(pCxt, &yymsp[-3].minor.yy53, yymsp[-1].minor.yy236); }
  yymsp[-3].minor.yy636 = yylhsminor.yy636;
        break;
      case 224: /* cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy603, &yymsp[-3].minor.yy53, yymsp[0].minor.yy636, NULL, yymsp[-2].minor.yy636); }
        break;
      case 225: /* cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy603, &yymsp[-3].minor.yy53, NULL, &yymsp[0].minor.yy53, yymsp[-2].minor.yy636); }
        break;
      case 226: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy603, &yymsp[0].minor.yy53); }
        break;
      case 227: /* cmd ::= DROP CGROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy603, &yymsp[-2].minor.yy53, &yymsp[0].minor.yy53); }
        break;
      case 228: /* topic_options ::= */
{ yymsp[1].minor.yy636 = createTopicOptions(pCxt); }
        break;
      case 229: /* topic_options ::= topic_options WITH TABLE */
{ ((STopicOptions*)yymsp[-2].minor.yy636)->withTable = true; yylhsminor.yy636 = yymsp[-2].minor.yy636; }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 230: /* topic_options ::= topic_options WITH SCHEMA */
{ ((STopicOptions*)yymsp[-2].minor.yy636)->withSchema = true; yylhsminor.yy636 = yymsp[-2].minor.yy636; }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 231: /* topic_options ::= topic_options WITH TAG */
{ ((STopicOptions*)yymsp[-2].minor.yy636)->withTag = true; yylhsminor.yy636 = yymsp[-2].minor.yy636; }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 232: /* cmd ::= DESC full_table_name */
      case 233: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==233);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy636); }
        break;
      case 234: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 235: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy603, yymsp[-1].minor.yy636, yymsp[0].minor.yy636); }
        break;
      case 237: /* analyze_opt ::= ANALYZE */
      case 245: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==245);
      case 393: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==393);
{ yymsp[0].minor.yy603 = true; }
        break;
      case 238: /* explain_options ::= */
{ yymsp[1].minor.yy636 = createDefaultExplainOptions(pCxt); }
        break;
      case 239: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy636 = setExplainVerbose(pCxt, yymsp[-2].minor.yy636, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 240: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy636 = setExplainRatio(pCxt, yymsp[-2].minor.yy636, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 241: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy236); }
        break;
      case 242: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy603, yymsp[-8].minor.yy603, &yymsp[-5].minor.yy53, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy450, yymsp[0].minor.yy158); }
        break;
      case 243: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy603, &yymsp[0].minor.yy53); }
        break;
      case 246: /* bufsize_opt ::= */
{ yymsp[1].minor.yy158 = 0; }
        break;
      case 247: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy158 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 248: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy603, &yymsp[-4].minor.yy53, yymsp[-2].minor.yy636, yymsp[-3].minor.yy636, yymsp[0].minor.yy636); }
        break;
      case 249: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy603, &yymsp[0].minor.yy53); }
        break;
      case 251: /* into_opt ::= INTO full_table_name */
      case 374: /* from_clause ::= FROM table_reference_list */ yytestcase(yyruleno==374);
      case 404: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==404);
      case 427: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==427);
{ yymsp[-1].minor.yy636 = yymsp[0].minor.yy636; }
        break;
      case 252: /* stream_options ::= */
{ yymsp[1].minor.yy636 = createStreamOptions(pCxt); }
        break;
      case 253: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy636)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy636 = yymsp[-2].minor.yy636; }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 254: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy636)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy636 = yymsp[-2].minor.yy636; }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 255: /* stream_options ::= stream_options WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy636)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy636); yylhsminor.yy636 = yymsp[-2].minor.yy636; }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 256: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 257: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 258: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 259: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 260: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy236); }
        break;
      case 261: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 262: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy236 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 264: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy53); }
        break;
      case 266: /* literal ::= NK_INTEGER */
{ yylhsminor.yy636 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 267: /* literal ::= NK_FLOAT */
{ yylhsminor.yy636 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 268: /* literal ::= NK_STRING */
{ yylhsminor.yy636 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 269: /* literal ::= NK_BOOL */
{ yylhsminor.yy636 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 270: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy636 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy636 = yylhsminor.yy636;
        break;
      case 271: /* literal ::= duration_literal */
      case 281: /* signed_literal ::= signed */ yytestcase(yyruleno==281);
      case 301: /* expression ::= literal */ yytestcase(yyruleno==301);
      case 302: /* expression ::= pseudo_column */ yytestcase(yyruleno==302);
      case 303: /* expression ::= column_reference */ yytestcase(yyruleno==303);
      case 304: /* expression ::= function_expression */ yytestcase(yyruleno==304);
      case 305: /* expression ::= subquery */ yytestcase(yyruleno==305);
      case 330: /* function_expression ::= literal_func */ yytestcase(yyruleno==330);
      case 366: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==366);
      case 370: /* boolean_primary ::= predicate */ yytestcase(yyruleno==370);
      case 372: /* common_expression ::= expression */ yytestcase(yyruleno==372);
      case 373: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==373);
      case 375: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==375);
      case 377: /* table_reference ::= table_primary */ yytestcase(yyruleno==377);
      case 378: /* table_reference ::= joined_table */ yytestcase(yyruleno==378);
      case 382: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==382);
      case 429: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==429);
      case 432: /* query_primary ::= query_specification */ yytestcase(yyruleno==432);
{ yylhsminor.yy636 = yymsp[0].minor.yy636; }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 272: /* literal ::= NULL */
{ yylhsminor.yy636 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 273: /* literal ::= NK_QUESTION */
{ yylhsminor.yy636 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 274: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy636 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 275: /* signed ::= NK_INTEGER */
{ yylhsminor.yy636 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 276: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy636 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 277: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy636 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy636 = yylhsminor.yy636;
        break;
      case 278: /* signed ::= NK_FLOAT */
{ yylhsminor.yy636 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 279: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy636 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 280: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy636 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy636 = yylhsminor.yy636;
        break;
      case 282: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy636 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 283: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy636 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 284: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy636 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 285: /* signed_literal ::= duration_literal */
      case 287: /* signed_literal ::= literal_func */ yytestcase(yyruleno==287);
      case 344: /* star_func_para ::= expression */ yytestcase(yyruleno==344);
      case 399: /* select_item ::= common_expression */ yytestcase(yyruleno==399);
      case 445: /* search_condition ::= common_expression */ yytestcase(yyruleno==445);
{ yylhsminor.yy636 = releaseRawExprNode(pCxt, yymsp[0].minor.yy636); }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 286: /* signed_literal ::= NULL */
{ yylhsminor.yy636 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 306: /* expression ::= NK_LP expression NK_RP */
      case 371: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==371);
{ yylhsminor.yy636 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy636)); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 307: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy636);
                                                                                    yylhsminor.yy636 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy636));
                                                                                  }
  yymsp[-1].minor.yy636 = yylhsminor.yy636;
        break;
      case 308: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy636);
                                                                                    yylhsminor.yy636 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy636), NULL));
                                                                                  }
  yymsp[-1].minor.yy636 = yylhsminor.yy636;
        break;
      case 309: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy636);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy636);
                                                                                    yylhsminor.yy636 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy636), releaseRawExprNode(pCxt, yymsp[0].minor.yy636))); 
                                                                                  }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 310: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy636);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy636);
                                                                                    yylhsminor.yy636 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy636), releaseRawExprNode(pCxt, yymsp[0].minor.yy636))); 
                                                                                  }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 311: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy636);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy636);
                                                                                    yylhsminor.yy636 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy636), releaseRawExprNode(pCxt, yymsp[0].minor.yy636))); 
                                                                                  }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 312: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy636);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy636);
                                                                                    yylhsminor.yy636 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy636), releaseRawExprNode(pCxt, yymsp[0].minor.yy636))); 
                                                                                  }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 313: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy636);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy636);
                                                                                    yylhsminor.yy636 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy636), releaseRawExprNode(pCxt, yymsp[0].minor.yy636))); 
                                                                                  }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 314: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy636);
                                                                                    yylhsminor.yy636 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy636), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 315: /* expression_list ::= expression */
{ yylhsminor.yy236 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy636)); }
  yymsp[0].minor.yy236 = yylhsminor.yy236;
        break;
      case 316: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy236 = addNodeToList(pCxt, yymsp[-2].minor.yy236, releaseRawExprNode(pCxt, yymsp[0].minor.yy636)); }
  yymsp[-2].minor.yy236 = yylhsminor.yy236;
        break;
      case 317: /* column_reference ::= column_name */
{ yylhsminor.yy636 = createRawExprNode(pCxt, &yymsp[0].minor.yy53, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy53)); }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 318: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy636 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy53, &yymsp[0].minor.yy53, createColumnNode(pCxt, &yymsp[-2].minor.yy53, &yymsp[0].minor.yy53)); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 319: /* pseudo_column ::= ROWTS */
      case 320: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==320);
      case 322: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==322);
      case 323: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==323);
      case 324: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==324);
      case 325: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==325);
      case 326: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==326);
      case 332: /* literal_func ::= NOW */ yytestcase(yyruleno==332);
{ yylhsminor.yy636 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy636 = yylhsminor.yy636;
        break;
      case 321: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy636 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy53, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy53)))); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 327: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 328: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==328);
{ yylhsminor.yy636 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy53, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy53, yymsp[-1].minor.yy236)); }
  yymsp[-3].minor.yy636 = yylhsminor.yy636;
        break;
      case 329: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy636 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy636), yymsp[-1].minor.yy450)); }
  yymsp[-5].minor.yy636 = yylhsminor.yy636;
        break;
      case 331: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy636 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy53, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy53, NULL)); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 340: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy236 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy236 = yylhsminor.yy236;
        break;
      case 345: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 402: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==402);
{ yylhsminor.yy636 = createColumnNode(pCxt, &yymsp[-2].minor.yy53, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 346: /* predicate ::= expression compare_op expression */
      case 351: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==351);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy636);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy636);
                                                                                    yylhsminor.yy636 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy136, releaseRawExprNode(pCxt, yymsp[-2].minor.yy636), releaseRawExprNode(pCxt, yymsp[0].minor.yy636)));
                                                                                  }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 347: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy636);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy636);
                                                                                    yylhsminor.yy636 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy636), releaseRawExprNode(pCxt, yymsp[-2].minor.yy636), releaseRawExprNode(pCxt, yymsp[0].minor.yy636)));
                                                                                  }
  yymsp[-4].minor.yy636 = yylhsminor.yy636;
        break;
      case 348: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy636);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy636);
                                                                                    yylhsminor.yy636 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy636), releaseRawExprNode(pCxt, yymsp[-2].minor.yy636), releaseRawExprNode(pCxt, yymsp[0].minor.yy636)));
                                                                                  }
  yymsp[-5].minor.yy636 = yylhsminor.yy636;
        break;
      case 349: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy636);
                                                                                    yylhsminor.yy636 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy636), NULL));
                                                                                  }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 350: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy636);
                                                                                    yylhsminor.yy636 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy636), NULL));
                                                                                  }
  yymsp[-3].minor.yy636 = yylhsminor.yy636;
        break;
      case 352: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy136 = OP_TYPE_LOWER_THAN; }
        break;
      case 353: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy136 = OP_TYPE_GREATER_THAN; }
        break;
      case 354: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy136 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 355: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy136 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 356: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy136 = OP_TYPE_NOT_EQUAL; }
        break;
      case 357: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy136 = OP_TYPE_EQUAL; }
        break;
      case 358: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy136 = OP_TYPE_LIKE; }
        break;
      case 359: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy136 = OP_TYPE_NOT_LIKE; }
        break;
      case 360: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy136 = OP_TYPE_MATCH; }
        break;
      case 361: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy136 = OP_TYPE_NMATCH; }
        break;
      case 362: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy136 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 363: /* in_op ::= IN */
{ yymsp[0].minor.yy136 = OP_TYPE_IN; }
        break;
      case 364: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy136 = OP_TYPE_NOT_IN; }
        break;
      case 365: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy636 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy236)); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 367: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy636);
                                                                                    yylhsminor.yy636 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy636), NULL));
                                                                                  }
  yymsp[-1].minor.yy636 = yylhsminor.yy636;
        break;
      case 368: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy636);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy636);
                                                                                    yylhsminor.yy636 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy636), releaseRawExprNode(pCxt, yymsp[0].minor.yy636)));
                                                                                  }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 369: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy636);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy636);
                                                                                    yylhsminor.yy636 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy636), releaseRawExprNode(pCxt, yymsp[0].minor.yy636)));
                                                                                  }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 376: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy636 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy636, yymsp[0].minor.yy636, NULL); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 379: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy636 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy53, &yymsp[0].minor.yy53); }
  yymsp[-1].minor.yy636 = yylhsminor.yy636;
        break;
      case 380: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy636 = createRealTableNode(pCxt, &yymsp[-3].minor.yy53, &yymsp[-1].minor.yy53, &yymsp[0].minor.yy53); }
  yymsp[-3].minor.yy636 = yylhsminor.yy636;
        break;
      case 381: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy636 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy636), &yymsp[0].minor.yy53); }
  yymsp[-1].minor.yy636 = yylhsminor.yy636;
        break;
      case 383: /* alias_opt ::= */
{ yymsp[1].minor.yy53 = nil_token;  }
        break;
      case 384: /* alias_opt ::= table_alias */
{ yylhsminor.yy53 = yymsp[0].minor.yy53; }
  yymsp[0].minor.yy53 = yylhsminor.yy53;
        break;
      case 385: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy53 = yymsp[0].minor.yy53; }
        break;
      case 386: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 387: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==387);
{ yymsp[-2].minor.yy636 = yymsp[-1].minor.yy636; }
        break;
      case 388: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy636 = createJoinTableNode(pCxt, yymsp[-4].minor.yy342, yymsp[-5].minor.yy636, yymsp[-2].minor.yy636, yymsp[0].minor.yy636); }
  yymsp[-5].minor.yy636 = yylhsminor.yy636;
        break;
      case 389: /* join_type ::= */
{ yymsp[1].minor.yy342 = JOIN_TYPE_INNER; }
        break;
      case 390: /* join_type ::= INNER */
{ yymsp[0].minor.yy342 = JOIN_TYPE_INNER; }
        break;
      case 391: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy636 = createSelectStmt(pCxt, yymsp[-7].minor.yy603, yymsp[-6].minor.yy236, yymsp[-5].minor.yy636);
                                                                                    yymsp[-8].minor.yy636 = addWhereClause(pCxt, yymsp[-8].minor.yy636, yymsp[-4].minor.yy636);
                                                                                    yymsp[-8].minor.yy636 = addPartitionByClause(pCxt, yymsp[-8].minor.yy636, yymsp[-3].minor.yy236);
                                                                                    yymsp[-8].minor.yy636 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy636, yymsp[-2].minor.yy636);
                                                                                    yymsp[-8].minor.yy636 = addGroupByClause(pCxt, yymsp[-8].minor.yy636, yymsp[-1].minor.yy236);
                                                                                    yymsp[-8].minor.yy636 = addHavingClause(pCxt, yymsp[-8].minor.yy636, yymsp[0].minor.yy636);
                                                                                  }
        break;
      case 394: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy603 = false; }
        break;
      case 395: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy236 = NULL; }
        break;
      case 400: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy636 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy636), &yymsp[0].minor.yy53); }
  yymsp[-1].minor.yy636 = yylhsminor.yy636;
        break;
      case 401: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy636 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy636), &yymsp[0].minor.yy53); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 406: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 423: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==423);
      case 435: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==435);
{ yymsp[-2].minor.yy236 = yymsp[0].minor.yy236; }
        break;
      case 408: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy636 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy636), releaseRawExprNode(pCxt, yymsp[-1].minor.yy636)); }
        break;
      case 409: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy636 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy636)); }
        break;
      case 410: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy636 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy636), NULL, yymsp[-1].minor.yy636, yymsp[0].minor.yy636); }
        break;
      case 411: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy636 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy636), releaseRawExprNode(pCxt, yymsp[-3].minor.yy636), yymsp[-1].minor.yy636, yymsp[0].minor.yy636); }
        break;
      case 413: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy636 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy636); }
        break;
      case 415: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy636 = createFillNode(pCxt, yymsp[-1].minor.yy18, NULL); }
        break;
      case 416: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy636 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy236)); }
        break;
      case 417: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy18 = FILL_MODE_NONE; }
        break;
      case 418: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy18 = FILL_MODE_PREV; }
        break;
      case 419: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy18 = FILL_MODE_NULL; }
        break;
      case 420: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy18 = FILL_MODE_LINEAR; }
        break;
      case 421: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy18 = FILL_MODE_NEXT; }
        break;
      case 424: /* group_by_list ::= expression */
{ yylhsminor.yy236 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy636))); }
  yymsp[0].minor.yy236 = yylhsminor.yy236;
        break;
      case 425: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy236 = addNodeToList(pCxt, yymsp[-2].minor.yy236, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy636))); }
  yymsp[-2].minor.yy236 = yylhsminor.yy236;
        break;
      case 428: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy636 = addOrderByClause(pCxt, yymsp[-3].minor.yy636, yymsp[-2].minor.yy236);
                                                                                    yylhsminor.yy636 = addSlimitClause(pCxt, yylhsminor.yy636, yymsp[-1].minor.yy636);
                                                                                    yylhsminor.yy636 = addLimitClause(pCxt, yylhsminor.yy636, yymsp[0].minor.yy636);
                                                                                  }
  yymsp[-3].minor.yy636 = yylhsminor.yy636;
        break;
      case 430: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy636 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy636, yymsp[0].minor.yy636); }
  yymsp[-3].minor.yy636 = yylhsminor.yy636;
        break;
      case 431: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy636 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy636, yymsp[0].minor.yy636); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 433: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ yymsp[-5].minor.yy636 = yymsp[-4].minor.yy636; }
  yy_destructor(yypParser,353,&yymsp[-3].minor);
  yy_destructor(yypParser,354,&yymsp[-2].minor);
  yy_destructor(yypParser,355,&yymsp[-1].minor);
        break;
      case 437: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 441: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==441);
{ yymsp[-1].minor.yy636 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 438: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 442: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==442);
{ yymsp[-3].minor.yy636 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 439: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 443: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==443);
{ yymsp[-3].minor.yy636 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 444: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy636 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy636); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 448: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy636 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy636), yymsp[-1].minor.yy430, yymsp[0].minor.yy185); }
  yymsp[-2].minor.yy636 = yylhsminor.yy636;
        break;
      case 449: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy430 = ORDER_ASC; }
        break;
      case 450: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy430 = ORDER_ASC; }
        break;
      case 451: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy430 = ORDER_DESC; }
        break;
      case 452: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy185 = NULL_ORDER_DEFAULT; }
        break;
      case 453: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy185 = NULL_ORDER_FIRST; }
        break;
      case 454: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy185 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
