/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 450
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  int64_t yy9;
  SToken yy29;
  EOrder yy38;
  bool yy137;
  SAlterOption yy245;
  SNodeList* yy424;
  int32_t yy460;
  SDataType yy484;
  int8_t yy503;
  EFillMode yy594;
  EJoinType yy612;
  EOperatorType yy740;
  ENullOrder yy757;
  SNode* yy812;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             699
#define YYNRULE              526
#define YYNTOKEN             318
#define YY_MAX_SHIFT         698
#define YY_MIN_SHIFTREDUCE   1033
#define YY_MAX_SHIFTREDUCE   1558
#define YY_ERROR_ACTION      1559
#define YY_ACCEPT_ACTION     1560
#define YY_NO_ACTION         1561
#define YY_MIN_REDUCE        1562
#define YY_MAX_REDUCE        2087
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2801)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1889,   34,  268, 1889, 1702, 1066,  448, 1903,  449, 1597,
 /*    10 */  1704, 1885,   44,   42, 1885,  456,  396,  449, 1597, 1817,
 /*    20 */   351, 1885, 1339,   43,   41,   40,   39,   38, 1365,   40,
 /*    30 */    39,   38,  591, 1419,  154, 1337, 1921, 1881, 1887,  339,
 /*    40 */  1881, 1887,  345, 1716,  592, 1070, 1071, 1881, 1887, 1871,
 /*    50 */   598,  604,   30,  598,  311,  157, 1414, 1574,   37,   36,
 /*    60 */   598,   17,   43,   41,   40,   39,   38, 1903, 1345,   44,
 /*    70 */    42, 1489, 1901, 1364, 1759, 1760, 1937,  351,  576, 1339,
 /*    80 */    97, 1902, 1904,  608, 1906, 1907,  603, 1083,  598, 1082,
 /*    90 */  1419,   77, 1337,  168,    1, 1990, 1921, 1493,   58,  344,
 /*   100 */  1986,   77,  484, 1364,  605,  588,   46, 2058,  591, 1871,
 /*   110 */  2062,  604,  173, 1414, 1709,  125,  695, 1084,   17,  536,
 /*   120 */  2016,  550,  575,  171, 1708, 1345,  336, 2059,  577, 1814,
 /*   130 */  1421, 1422,  606,   52,  132,  591, 1937, 1563, 1232, 1233,
 /*   140 */    98,  350, 1904,  608, 1906, 1907,  603,   58,  598,  356,
 /*   150 */  1713,    1, 1758, 1760, 1083, 1990, 1082, 1585,  110,  315,
 /*   160 */  1986,  109,  108,  107,  106,  105,  104,  103,  102,  101,
 /*   170 */  2058,  130,  465,  695,   58, 1340, 1365, 1338,  389,  433,
 /*   180 */   388,  337,   46, 1584, 1084,  575,  171, 1421, 1422,  154,
 /*   190 */  2059,  577,  590,  169, 1998, 1999, 1364, 2003, 1715, 1871,
 /*   200 */  1343, 1344, 1583, 1394, 1395, 1397, 1398, 1399, 1400, 1401,
 /*   210 */  1402, 1403, 1404,  600,  596, 1412, 1413, 1415, 1416, 1417,
 /*   220 */  1418, 1420, 1423,    3,   47, 1871, 1691,  550, 1560,  502,
 /*   230 */   501,  500, 1340,   94, 1338,  186,  185,  126,  496,  120,
 /*   240 */   641,  174,  495,  494, 1871,  174,  486,  127,  493,  499,
 /*   250 */   220, 1921,  228,  174,  492, 1705, 1713, 1343, 1344,  570,
 /*   260 */  1394, 1395, 1397, 1398, 1399, 1400, 1401, 1402, 1403, 1404,
 /*   270 */   600,  596, 1412, 1413, 1415, 1416, 1417, 1418, 1420, 1423,
 /*   280 */     3,   44,   42,  698, 1807, 1890,  465, 1396,  366,  351,
 /*   290 */    58, 1339,   81,  233,  174,  179, 1885,  275,  569, 1903,
 /*   300 */   588,   11, 1419,  156, 1337,  532,   79,  313, 1666, 1582,
 /*   310 */   540,  165,  538, 1366, 1581,  588,  688,  684,  680,  676,
 /*   320 */   273,  174, 1881, 1887, 1765, 1414, 1765,  566, 1921,  132,
 /*   330 */    17,  338,  516,  355, 2058,  598,  605, 1345,   44,   42,
 /*   340 */  1763, 1871, 1763,  604,  132,  514,  351,  512, 1339, 2064,
 /*   350 */   171, 1871, 1316, 1317, 2059,  577, 1871,   95, 1150, 1419,
 /*   360 */   241, 1337,  385,    1,  606,  579,  121,  550, 1937, 2005,
 /*   370 */   583,  174,  295,  350, 1904,  608, 1906, 1907,  603,  120,
 /*   380 */   598,  130, 1414,  387,  383,  695,  491,   17,  265, 1998,
 /*   390 */   587, 1152,  586,  547, 1345, 2058, 1713, 2002, 1515, 1421,
 /*   400 */  1422,  571, 2058,  170, 1998, 1999, 1363, 2003,  167, 2063,
 /*   410 */   575,  171,   62,  572,  567, 2059,  577,  575,  171,  490,
 /*   420 */     1, 1752, 2059,  577,  110,  230,  633,  109,  108,  107,
 /*   430 */   106,  105,  104,  103,  102,  101, 1562,  174, 2058,  498,
 /*   440 */   497,  489,  695, 1310, 1340,  223, 1338, 1429,  563, 1513,
 /*   450 */  1514, 1516, 1517, 1364, 2062,  267, 1421, 1422, 2059, 2061,
 /*   460 */   119,  118,  117,  116,  115,  114,  113,  112,  111, 1343,
 /*   470 */  1344,  595, 1394, 1395, 1397, 1398, 1399, 1400, 1401, 1402,
 /*   480 */  1403, 1404,  600,  596, 1412, 1413, 1415, 1416, 1417, 1418,
 /*   490 */  1420, 1423,    3, 1450,   11,   11, 1698,    9,  234,  235,
 /*   500 */   453, 1340,   58, 1338, 1627, 1858, 1362, 1190,  630,  629,
 /*   510 */   628, 1194,  627, 1196, 1197,  626, 1199,  623, 1689, 1205,
 /*   520 */   620, 1207, 1208,  617,  614, 1486, 1343, 1344,  327, 1394,
 /*   530 */  1395, 1397, 1398, 1399, 1400, 1401, 1402, 1403, 1404,  600,
 /*   540 */   596, 1412, 1413, 1415, 1416, 1417, 1418, 1420, 1423,    3,
 /*   550 */    44,   42,  373,  550, 1580, 2063,  313, 1579,  351,  540,
 /*   560 */  1339,  538,  354,  447,   31,  176,  451,  502,  501,  500,
 /*   570 */   154, 1419, 1578, 1337, 1455,  126,  496, 1667,  641, 1715,
 /*   580 */   495,  494, 1713, 1903, 2058, 2005,  493,  499,  328,  584,
 /*   590 */   326,  325,  492,  488, 1414, 1345, 1871,  490,  182, 1871,
 /*   600 */  2062,  552, 1903, 1962, 2059, 2060, 1345,   44,   42, 1424,
 /*   610 */  1440,  550, 1921, 2001, 1871,  351,  653, 1339,  588,  489,
 /*   620 */   605,  550, 1700,  394, 1577, 1871,  357,  604, 1419, 1765,
 /*   630 */  1337, 1921,    8,  395,  154,   74,  320, 1396,   73,  605,
 /*   640 */  1713,  550, 1696, 1715, 1871, 1763,  604,  132, 1901,  174,
 /*   650 */  1713, 1414, 1937,  405,  695,  390,  158, 1902, 1904,  608,
 /*   660 */  1906, 1907,  603, 1345,  598, 1690, 1871, 1901, 1421, 1422,
 /*   670 */  1713, 1937,  532,  550,  576,   97, 1902, 1904,  608, 1906,
 /*   680 */  1907,  603, 2063,  598,  130,  419, 1367,   87, 2078,    8,
 /*   690 */  1990,  666,  664,  455,  344, 1986,  451,  555, 2027, 1366,
 /*   700 */   224, 2058, 1713, 2058, 2024,  599,  172, 1998, 1999, 1706,
 /*   710 */  2003,  695,  554, 1340, 1962, 1338, 2064,  171,  575,  171,
 /*   720 */  1576, 2059,  577, 2059,  577, 1421, 1422, 1573,   37,   36,
 /*   730 */    13,   12,   43,   41,   40,   39,   38, 2005, 1343, 1344,
 /*   740 */  1367, 1394, 1395, 1397, 1398, 1399, 1400, 1401, 1402, 1403,
 /*   750 */  1404,  600,  596, 1412, 1413, 1415, 1416, 1417, 1418, 1420,
 /*   760 */  1423,    3, 1871, 1485, 1813, 2000,  306, 1807,  550, 1871,
 /*   770 */  1340,  639, 1338,  221, 1548, 1812, 1743,  306,  180,  174,
 /*   780 */   420,   37,   36, 1364, 1572,   43,   41,   40,   39,   38,
 /*   790 */   145,  144,  636,  635,  634, 1343, 1344, 1713, 1394, 1395,
 /*   800 */  1397, 1398, 1399, 1400, 1401, 1402, 1403, 1404,  600,  596,
 /*   810 */  1412, 1413, 1415, 1416, 1417, 1418, 1420, 1423,    3,   44,
 /*   820 */    42,  536,  507, 1807, 1462,  639, 1871,  351,  243, 1339,
 /*   830 */  1571, 1815,  580,  128,  184,  637, 1961,  517, 1756,  227,
 /*   840 */  1419,  267, 1337,   32,  145,  144,  636,  635,  634,   37,
 /*   850 */    36,  219, 1903,   43,   41,   40,   39,   38,  550,  404,
 /*   860 */  1570,  550, 1569, 1414,  632,  510,  550, 1765, 1525,  504,
 /*   870 */   463, 1903, 1871,  464,  218, 1345,   44,   42, 1710,   80,
 /*   880 */   550, 1921,  244, 1764,  351,  638, 1339, 1713, 1756,  605,
 /*   890 */  1713,    7,  137,  527, 1871, 1713,  604, 1419, 1794, 1337,
 /*   900 */  1921,    8, 1871,  654, 1871, 1683,  550,   72,  605, 1713,
 /*   910 */   550,   64, 1892, 1871,   63,  604,  280, 1901,  528, 1743,
 /*   920 */  1414, 1937,  533,  695, 1903,  159, 1902, 1904,  608, 1906,
 /*   930 */  1907,  603, 1345,  598, 1688, 1713, 1901, 1421, 1422, 1713,
 /*   940 */  1937, 1568,  550, 1567,   97, 1902, 1904,  608, 1906, 1907,
 /*   950 */   603, 1575,  598, 1921,  238, 1070, 1071, 2078,    1, 1990,
 /*   960 */  1894,  605,  550,  344, 1986, 2063, 1871, 1396,  604, 2010,
 /*   970 */  1482, 1713, 2030, 2052,  546,  550,  262,  578, 2079,  143,
 /*   980 */   695,  564, 1340, 1871, 1338, 1871, 1348,  548,  483, 1901,
 /*   990 */  1566, 1713, 1565, 1937, 1421, 1422,  397,  159, 1902, 1904,
 /*  1000 */   608, 1906, 1907,  603, 1713,  598,   45, 1343, 1344,  398,
 /*  1010 */  1394, 1395, 1397, 1398, 1399, 1400, 1401, 1402, 1403, 1404,
 /*  1020 */   600,  596, 1412, 1413, 1415, 1416, 1417, 1418, 1420, 1423,
 /*  1030 */     3,   51, 1871,  206, 1871,   48,    4,   50,  531, 1340,
 /*  1040 */   639, 1338,  211,   13,   12,  209,  414,  161,  213,  581,
 /*  1050 */  2080,  212,  482,  478,  474,  470,  205, 1548, 1287,  145,
 /*  1060 */   144,  636,  635,  634, 1343, 1344, 1624, 1394, 1395, 1397,
 /*  1070 */  1398, 1399, 1400, 1401, 1402, 1403, 1404,  600,  596, 1412,
 /*  1080 */  1413, 1415, 1416, 1417, 1418, 1420, 1423,    3,  310,  550,
 /*  1090 */  1362, 1614, 1482,   78,  256,  215,  203,  427,  214, 1922,
 /*  1100 */   438,  549,   37,   36, 1609, 1607,   43,   41,   40,   39,
 /*  1110 */    38,  217,  232,  503,  216,   93,  138,  411, 1713,  439,
 /*  1120 */  1347,  413, 1557, 1558,  362,   90,  505,  508, 1351,  672,
 /*  1130 */   671,  670,  669,  361, 1598,  668,  667,  133,  662,  661,
 /*  1140 */   660,  659,  658,  657,  656,  655,  147,  651,  650,  649,
 /*  1150 */   360,  359,  646,  645,  644,  643,  642,  155,  202,  196,
 /*  1160 */   647,  201,  286,  323,  236,  461,   37,   36,  543, 2020,
 /*  1170 */    43,   41,   40,   39,   38,  400,  284,   66, 1753,  142,
 /*  1180 */    65,  194, 1130,  535,   37,   36,  143,   60,   43,   41,
 /*  1190 */    40,   39,   38,  589,  248,   60,  190,  444,  442, 1903,
 /*  1200 */   532,   26,   45,  437,    2,  648,  432,  431,  430,  429,
 /*  1210 */   426,  425,  424,  423,  422,  418,  417,  416,  415,  324,
 /*  1220 */   408,  407,  406,  264,  402,  401,  322, 1128, 1921, 2058,
 /*  1230 */    45,  240, 1110,   58,  261,  367,  605,  316, 1183, 1512,
 /*  1240 */   372, 1871,    5,  604, 2064,  171,  251, 1456, 1603, 2059,
 /*  1250 */   577, 1303,   37,   36, 1405,  550,   43,   41,   40,   39,
 /*  1260 */    38, 1555, 1350,  321, 1901, 1111,  612,  269, 1937,  142,
 /*  1270 */   276,   96,   97, 1902, 1904,  608, 1906, 1907,  603, 1448,
 /*  1280 */   598,  183,  279,  129, 1713,  141, 1961, 1990,  143,  399,
 /*  1290 */   122,  344, 1986,  142,   37,   36,  690,  435,   43,   41,
 /*  1300 */    40,   39,   38,  364, 1362,  363,   71,   70,  393,   37,
 /*  1310 */    36,  178,  550,   43,   41,   40,   39,   38, 1211,  403,
 /*  1320 */   532, 1215,  532,  409,  358,  421,  428, 1809,  434,  309,
 /*  1330 */   440,  187,  381, 1449,  379,  375,  371,  368,  365, 1505,
 /*  1340 */  1222, 1713, 1220,  436,  441,  146,  443,  445, 1368, 2058,
 /*  1350 */  1903, 2058, 1370,  446,  454,  457,  193, 1554,  195,  458,
 /*  1360 */  1369,  459, 1371,  462, 2064,  171, 2064,  171,  460, 2059,
 /*  1370 */   577, 2059,  577,  198,  200,  466,   75,   76,  204, 1921,
 /*  1380 */   174,  485,  487, 1703,  208, 1699,  210,  592,  148,  149,
 /*  1390 */    99,  312, 1871, 1903,  604,  519,  521, 1701, 1697,  150,
 /*  1400 */   151,  522,  222,  277,   33,  348, 1443, 1444, 1445, 1446,
 /*  1410 */  1447, 1451, 1452, 1453, 1454, 1901, 1848,  526,  225, 1937,
 /*  1420 */   523,  529, 1921,   97, 1902, 1904,  608, 1906, 1907,  603,
 /*  1430 */   605,  598,  534,  333,  562, 1871,  168,  604, 1990,  229,
 /*  1440 */   139,  544,  344, 1986,  537, 1847, 1819,  541,  153,  140,
 /*  1450 */   545,  335,   84,  278, 1903,   86, 1714, 1367, 1901,  558,
 /*  1460 */   565, 2012, 1937, 2017,  560,    6,   97, 1902, 1904,  608,
 /*  1470 */  1906, 1907,  603, 2021,  598,  246, 1903,  561,  574, 2078,
 /*  1480 */   340, 1990, 2031, 1921, 2036,  344, 1986, 2035,  250,  568,
 /*  1490 */   559,  605,  255,  162,  257, 2009, 1871,  557,  604,  556,
 /*  1500 */   260,  341,  258,  585,  259, 1921, 1482, 2057, 2081, 1366,
 /*  1510 */   582,  131, 2006,  605,   57,   88,  610,  263, 1871, 1901,
 /*  1520 */   604, 1971, 1684, 1937, 1757,  281,  520,   97, 1902, 1904,
 /*  1530 */   608, 1906, 1907,  603, 1903,  598,  272,  691,  692,  694,
 /*  1540 */  1965, 1901, 1990,  532,   49, 1937,  344, 1986,  305,   97,
 /*  1550 */  1902, 1904,  608, 1906, 1907,  603,  293,  598, 1865,  304,
 /*  1560 */   347,  346, 1963, 1921, 1990,  285,  303,  283,  344, 1986,
 /*  1570 */  1353,  605, 2058, 1864,   68, 1863, 1871, 1862,  604,   69,
 /*  1580 */  1859, 1419,  369, 1346,  370, 1331, 1332, 2064,  171,  177,
 /*  1590 */   374, 1857, 2059,  577, 1903,  376,  377,  378, 1856, 1901,
 /*  1600 */   380, 1339, 1855, 1937, 1414,  382, 1854,   97, 1902, 1904,
 /*  1610 */   608, 1906, 1907,  603, 1337,  598, 1345,  384, 1853, 1306,
 /*  1620 */   553,  386, 1990, 1921, 1305, 1830,  344, 1986, 1829,  391,
 /*  1630 */   392,  605, 1828, 1827, 1275, 1802, 1871, 1801,  604, 1799,
 /*  1640 */  1798,  134, 1797, 1800, 1796,  135, 1795, 1345, 1793, 1792,
 /*  1650 */  1791,  181,  410, 1790,  412, 1903, 1789, 1788, 1787, 1901,
 /*  1660 */  1786, 1785, 1784, 1937,  594, 1783, 1782,   98, 1902, 1904,
 /*  1670 */   608, 1906, 1907,  603, 1781,  598, 1780, 1779, 1778, 1777,
 /*  1680 */  1776, 1775, 1990,  136, 1921, 1774, 1989, 1986,  166,  334,
 /*  1690 */  1773, 1772,  605, 1771, 1770,  695, 1769, 1871, 1768,  604,
 /*  1700 */  1767, 1766, 1158, 1629, 1277, 1628, 1626,  188,  189, 1903,
 /*  1710 */  1594,  191,  123, 1073, 1593,  192,  450,  452, 1072, 1843,
 /*  1720 */  1901, 1837,  124, 1354, 1937, 1349, 1826, 1825,  302, 1902,
 /*  1730 */  1904,  608, 1906, 1907,  603,  199,  598, 1811, 1921, 1692,
 /*  1740 */  1625,  197, 1623,  467,  468, 1621,  605,  471, 1357, 1359,
 /*  1750 */   469, 1871, 1903,  604, 1340,  473, 1338, 1103, 1619,  475,
 /*  1760 */   472, 1617,  596, 1412, 1413, 1415, 1416, 1417, 1418,  476,
 /*  1770 */   479,  477,  480,  481, 1901, 1606, 1903, 1605, 1937, 1343,
 /*  1780 */  1344, 1921,   98, 1902, 1904,  608, 1906, 1907,  603,  602,
 /*  1790 */   598, 1590, 1694, 1225, 1871,   59,  604, 1990, 1226, 1693,
 /*  1800 */  1149,  593, 1986, 1148, 1147, 1921, 1140, 1146,  207, 1145,
 /*  1810 */   663, 1142,  665,  605, 1141, 1139, 1615, 1901, 1871,  329,
 /*  1820 */   604, 1937, 1610,  330, 1608,  301, 1902, 1904,  608, 1906,
 /*  1830 */  1907,  603,  601,  598,  551, 1955,  506,  331, 1589,  509,
 /*  1840 */   511, 1901, 1903, 1588,  513, 1937, 1587,  515,  100,   98,
 /*  1850 */  1902, 1904,  608, 1906, 1907,  603,   25,  598, 1842, 1323,
 /*  1860 */  1836, 1312, 1903,  524, 1990,  152, 1824, 1822,  226, 1987,
 /*  1870 */  1823, 1921, 2063, 1821, 1820,   18,  539,   53,  231,  602,
 /*  1880 */   525,  530,  332, 1321, 1871, 1320,  604, 1818,  237,  542,
 /*  1890 */    82, 1921, 1810,   83,  239,  242,   85,   90,   19,  605,
 /*  1900 */    20,   27,   56, 1527, 1871, 1903,  604, 1901, 1431,   15,
 /*  1910 */   254, 1937,   10,  245,  249,  301, 1902, 1904,  608, 1906,
 /*  1920 */  1907,  603,  247,  598, 1509, 1956, 1511, 1901,  160, 1903,
 /*  1930 */   252, 1937, 1504,   28, 1921,  158, 1902, 1904,  608, 1906,
 /*  1940 */  1907,  603,  605,  598,  253, 1892,   89, 1871, 1547,  604,
 /*  1950 */    29, 1548, 1430,   61,   22, 1542, 1541,  342, 1921, 1546,
 /*  1960 */  1545,  343,  266,  349, 1891,  163,  605, 1479,   21, 1355,
 /*  1970 */  1901, 1871, 1478,  604, 1937,   16,   55, 2028,  297, 1902,
 /*  1980 */  1904,  608, 1906, 1907,  603,   54,  598,   12, 1441, 1903,
 /*  1990 */  1940,  164, 1409, 1407, 1901, 1406,  597,   35, 1937,  175,
 /*  2000 */    14, 1387,  302, 1902, 1904,  608, 1906, 1907,  603, 1903,
 /*  2010 */   598,   23,  607,  609, 1189,  611,  353,   24, 1921,  615,
 /*  2020 */   631,  613,  573,  352, 1379, 1212,  605, 1209,  616,  618,
 /*  2030 */  1206, 1871,  619,  604, 1200,  621,  622,  624, 1921, 1198,
 /*  2040 */   625, 1221,  270,   91, 1217,   92,  605,  640,   67, 1204,
 /*  2050 */  1101, 1871, 1903,  604, 1901, 1203, 1136, 1156, 1937, 1202,
 /*  2060 */  1135, 1201,  302, 1902, 1904,  608, 1906, 1907,  603,  652,
 /*  2070 */   598, 1903, 1134, 1133,  518, 1132, 1131, 1129, 1937, 1127,
 /*  2080 */  1126, 1921,  295, 1902, 1904,  608, 1906, 1907,  603,  605,
 /*  2090 */   598, 1125,  271, 1123, 1871, 1122,  604, 1121, 1120, 1119,
 /*  2100 */  1921, 1118, 1117, 1116, 1153, 1151, 1113, 1112,  605, 1109,
 /*  2110 */  1107, 1108, 1622, 1871, 1106,  604,  673, 1901, 1620,  675,
 /*  2120 */   674, 1937,  677,  679, 1903,  287, 1902, 1904,  608, 1906,
 /*  2130 */  1907,  603,  678,  598, 1618,  681, 1901,  682,  683, 1616,
 /*  2140 */  1937,  685, 1903,  686,  288, 1902, 1904,  608, 1906, 1907,
 /*  2150 */   603, 1604,  598, 1921,  687,  689, 1063, 1586,  274,  693,
 /*  2160 */  1561,  605, 1341,  282,  696,  697, 1871, 1561,  604, 1561,
 /*  2170 */  1561, 1921, 1561, 1561, 1561, 1561, 1561, 1561, 1561,  605,
 /*  2180 */  1561, 1561, 1561, 1561, 1871, 1561,  604, 1561, 1561, 1901,
 /*  2190 */  1561, 1561, 1561, 1937, 1561, 1561, 1561,  289, 1902, 1904,
 /*  2200 */   608, 1906, 1907,  603, 1561,  598, 1903, 1901, 1561, 1561,
 /*  2210 */  1561, 1937, 1561, 1561, 1561,  296, 1902, 1904,  608, 1906,
 /*  2220 */  1907,  603, 1561,  598, 1561, 1561, 1903, 1561, 1561, 1561,
 /*  2230 */  1561, 1561, 1561, 1561, 1561, 1921, 1561, 1561, 1561, 1561,
 /*  2240 */  1561, 1561, 1561,  605, 1561, 1561, 1561, 1561, 1871, 1561,
 /*  2250 */   604, 1561, 1561, 1561, 1561, 1921, 1561, 1561, 1561, 1561,
 /*  2260 */  1561, 1561, 1561,  605, 1561, 1561, 1561, 1561, 1871, 1903,
 /*  2270 */   604, 1901, 1561, 1561, 1561, 1937, 1561, 1561, 1561,  298,
 /*  2280 */  1902, 1904,  608, 1906, 1907,  603, 1561,  598, 1903, 1561,
 /*  2290 */  1561, 1901, 1561, 1561, 1561, 1937, 1561, 1561, 1921,  290,
 /*  2300 */  1902, 1904,  608, 1906, 1907,  603,  605,  598, 1561, 1561,
 /*  2310 */  1561, 1871, 1561,  604, 1561, 1561, 1561, 1921, 1561, 1561,
 /*  2320 */  1561, 1561, 1561, 1561, 1561,  605, 1561, 1561, 1561, 1561,
 /*  2330 */  1871, 1903,  604, 1561, 1901, 1561, 1561, 1561, 1937, 1561,
 /*  2340 */  1561, 1561,  299, 1902, 1904,  608, 1906, 1907,  603, 1561,
 /*  2350 */   598, 1561, 1561, 1901, 1561, 1903, 1561, 1937, 1561, 1561,
 /*  2360 */  1921,  291, 1902, 1904,  608, 1906, 1907,  603,  605,  598,
 /*  2370 */  1561, 1561, 1561, 1871, 1903,  604, 1561, 1561, 1561, 1561,
 /*  2380 */  1561, 1561, 1561, 1561, 1921, 1561, 1561, 1561, 1561, 1561,
 /*  2390 */  1561, 1561,  605, 1561, 1561, 1561, 1901, 1871, 1561,  604,
 /*  2400 */  1937, 1561, 1561, 1921,  300, 1902, 1904,  608, 1906, 1907,
 /*  2410 */   603,  605,  598, 1561, 1561, 1561, 1871, 1561,  604, 1561,
 /*  2420 */  1901, 1561, 1561, 1561, 1937, 1561, 1561, 1561,  292, 1902,
 /*  2430 */  1904,  608, 1906, 1907,  603, 1903,  598, 1561, 1561, 1901,
 /*  2440 */  1561, 1561, 1561, 1937, 1561, 1561, 1561,  307, 1902, 1904,
 /*  2450 */   608, 1906, 1907,  603, 1561,  598, 1561, 1561, 1561, 1561,
 /*  2460 */  1561, 1561, 1561, 1561, 1921, 1561, 1561, 1561, 1561, 1561,
 /*  2470 */  1561, 1561,  605, 1561, 1561, 1561, 1561, 1871, 1561,  604,
 /*  2480 */  1561, 1561, 1561, 1561, 1561, 1561, 1561, 1561, 1903, 1561,
 /*  2490 */  1561, 1561, 1561, 1561, 1561, 1561, 1561, 1561, 1561, 1561,
 /*  2500 */  1901, 1561, 1561, 1561, 1937, 1561, 1903, 1561,  308, 1902,
 /*  2510 */  1904,  608, 1906, 1907,  603, 1561,  598, 1921, 1561, 1561,
 /*  2520 */  1561, 1561, 1561, 1561, 1561,  605, 1561, 1561, 1561, 1561,
 /*  2530 */  1871, 1561,  604, 1561, 1561, 1921, 1561, 1561, 1561, 1561,
 /*  2540 */  1561, 1561, 1561,  605, 1561, 1561, 1561, 1561, 1871, 1561,
 /*  2550 */   604, 1561, 1561, 1901, 1561, 1561, 1561, 1937, 1561, 1561,
 /*  2560 */  1561, 1915, 1902, 1904,  608, 1906, 1907,  603, 1561,  598,
 /*  2570 */  1903, 1901, 1561, 1561, 1561, 1937, 1561, 1561, 1561, 1914,
 /*  2580 */  1902, 1904,  608, 1906, 1907,  603, 1561,  598, 1561, 1561,
 /*  2590 */  1903, 1561, 1561, 1561, 1561, 1561, 1561, 1561, 1561, 1921,
 /*  2600 */  1561, 1561, 1561, 1561, 1561, 1561, 1561,  605, 1561, 1561,
 /*  2610 */  1561, 1561, 1871, 1561,  604, 1561, 1561, 1561, 1561, 1921,
 /*  2620 */  1561, 1561, 1561, 1561, 1561, 1561, 1561,  605, 1561, 1561,
 /*  2630 */  1561, 1561, 1871, 1903,  604, 1901, 1561, 1561, 1561, 1937,
 /*  2640 */  1561, 1561, 1561, 1913, 1902, 1904,  608, 1906, 1907,  603,
 /*  2650 */  1561,  598, 1903, 1561, 1561, 1901, 1561, 1561, 1561, 1937,
 /*  2660 */  1561, 1561, 1921,  317, 1902, 1904,  608, 1906, 1907,  603,
 /*  2670 */   605,  598, 1561, 1561, 1561, 1871, 1561,  604, 1561, 1561,
 /*  2680 */  1561, 1921, 1561, 1561, 1561, 1561, 1561, 1561, 1561,  605,
 /*  2690 */  1561, 1561, 1561, 1561, 1871, 1903,  604, 1561, 1901, 1561,
 /*  2700 */  1561, 1561, 1937, 1561, 1561, 1561,  318, 1902, 1904,  608,
 /*  2710 */  1906, 1907,  603, 1561,  598, 1561, 1561, 1901, 1561, 1903,
 /*  2720 */  1561, 1937, 1561, 1561, 1921,  314, 1902, 1904,  608, 1906,
 /*  2730 */  1907,  603,  605,  598, 1561, 1561, 1561, 1871, 1561,  604,
 /*  2740 */  1561, 1561, 1561, 1561, 1561, 1561, 1561, 1561, 1921, 1561,
 /*  2750 */  1561, 1561, 1561, 1561, 1561, 1561,  605, 1561, 1561, 1561,
 /*  2760 */  1901, 1871, 1561,  604, 1937, 1561, 1561, 1561,  319, 1902,
 /*  2770 */  1904,  608, 1906, 1907,  603, 1561,  598, 1561, 1561, 1561,
 /*  2780 */  1561, 1561, 1561, 1561, 1901, 1561, 1561, 1561, 1937, 1561,
 /*  2790 */  1561, 1561,  294, 1902, 1904,  608, 1906, 1907,  603, 1561,
 /*  2800 */   598,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   352,  410,  411,  352,  351,    4,  325,  321,  327,  328,
 /*    10 */   352,  363,   12,   13,  363,  325,  329,  327,  328,    0,
 /*    20 */    20,  363,   22,   12,   13,   14,   15,   16,   20,   14,
 /*    30 */    15,   16,   20,   33,  350,   35,  350,  389,  390,  391,
 /*    40 */   389,  390,  391,  359,  358,   44,   45,  389,  390,  363,
 /*    50 */   402,  365,    2,  402,  367,  320,   56,  322,    8,    9,
 /*    60 */   402,   61,   12,   13,   14,   15,   16,  321,   68,   12,
 /*    70 */    13,   14,  386,   20,  364,  365,  390,   20,  395,   22,
 /*    80 */   394,  395,  396,  397,  398,  399,  400,   20,  402,   22,
 /*    90 */    33,  333,   35,  407,   94,  409,  350,   14,   94,  413,
 /*   100 */   414,  333,   35,   20,  358,  329,   94,  424,   20,  363,
 /*   110 */     3,  365,  426,   56,  356,  347,  116,   50,   61,  365,
 /*   120 */   434,  329,  439,  440,  356,   68,  372,  444,  445,  375,
 /*   130 */   130,  131,  386,  341,  358,   20,  390,    0,  130,  131,
 /*   140 */   394,  395,  396,  397,  398,  399,  400,   94,  402,  361,
 /*   150 */   358,   94,  364,  365,   20,  409,   22,  321,   21,  413,
 /*   160 */   414,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   170 */   424,  395,   60,  116,   94,  175,   20,  177,  174,   78,
 /*   180 */   176,  342,   94,  321,   50,  439,  440,  130,  131,  350,
 /*   190 */   444,  445,  416,  417,  418,  419,   20,  421,  359,  363,
 /*   200 */   200,  201,  321,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,   94,  363,    0,  329,  318,   63,
 /*   230 */    64,   65,  175,  331,  177,  134,  135,   71,   72,  341,
 /*   240 */    60,  241,   76,   77,  363,  241,  348,  345,   82,   83,
 /*   250 */   126,  350,   56,  241,   88,  353,  358,  200,  201,  358,
 /*   260 */   203,  204,  205,  206,  207,  208,  209,  210,  211,  212,
 /*   270 */   213,  214,  215,  216,  217,  218,  219,  220,  221,  222,
 /*   280 */   223,   12,   13,   19,  358,  352,   60,  204,  378,   20,
 /*   290 */    94,   22,   96,  125,  241,  369,  363,   33,  397,  321,
 /*   300 */   329,  225,   33,  334,   35,  395,  182,  183,  339,  321,
 /*   310 */   186,   47,  188,   20,  321,  329,   52,   53,   54,   55,
 /*   320 */    56,  241,  389,  390,  350,   56,  350,  160,  350,  358,
 /*   330 */    61,  357,   21,  357,  424,  402,  358,   68,   12,   13,
 /*   340 */   366,  363,  366,  365,  358,   34,   20,   36,   22,  439,
 /*   350 */   440,  363,  184,  185,  444,  445,  363,   93,   35,   33,
 /*   360 */    96,   35,  170,   94,  386,  258,  395,  329,  390,  392,
 /*   370 */    43,  241,  394,  395,  396,  397,  398,  399,  400,  341,
 /*   380 */   402,  395,   56,  191,  192,  116,  348,   61,  417,  418,
 /*   390 */   419,   68,  421,  129,   68,  424,  358,  420,  200,  130,
 /*   400 */   131,   20,  424,  417,  418,  419,   20,  421,  349,  395,
 /*   410 */   439,  440,    4,  246,  247,  444,  445,  439,  440,  106,
 /*   420 */    94,  362,  444,  445,   21,  161,  105,   24,   25,   26,
 /*   430 */    27,   28,   29,   30,   31,   32,    0,  241,  424,  336,
 /*   440 */   337,  128,  116,  179,  175,  181,  177,   14,  250,  251,
 /*   450 */   252,  253,  254,   20,  440,  162,  130,  131,  444,  445,
 /*   460 */    24,   25,   26,   27,   28,   29,   30,   31,   32,  200,
 /*   470 */   201,   61,  203,  204,  205,  206,  207,  208,  209,  210,
 /*   480 */   211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
 /*   490 */   221,  222,  223,  157,  225,  225,  351,  227,  125,  126,
 /*   500 */    14,  175,   94,  177,    0,    0,   20,  107,  108,  109,
 /*   510 */   110,  111,  112,  113,  114,  115,  116,  117,    0,  119,
 /*   520 */   120,  121,  122,  123,  124,    4,  200,  201,   37,  203,
 /*   530 */   204,  205,  206,  207,  208,  209,  210,  211,  212,  213,
 /*   540 */   214,  215,  216,  217,  218,  219,  220,  221,  222,  223,
 /*   550 */    12,   13,   47,  329,  321,  395,  183,  321,   20,  186,
 /*   560 */    22,  188,  342,  326,  228,  341,  329,   63,   64,   65,
 /*   570 */   350,   33,  321,   35,  238,   71,   72,  339,   60,  359,
 /*   580 */    76,   77,  358,  321,  424,  392,   82,   83,   97,  262,
 /*   590 */    99,  100,   88,  102,   56,   68,  363,  106,   56,  363,
 /*   600 */   440,  406,  321,  408,  444,  445,   68,   12,   13,   14,
 /*   610 */   200,  329,  350,  420,  363,   20,   68,   22,  329,  128,
 /*   620 */   358,  329,  351,  341,  321,  363,  342,  365,   33,  350,
 /*   630 */    35,  350,   94,  341,  350,   93,  357,  204,   96,  358,
 /*   640 */   358,  329,  351,  359,  363,  366,  365,  358,  386,  241,
 /*   650 */   358,   56,  390,  341,  116,  378,  394,  395,  396,  397,
 /*   660 */   398,  399,  400,   68,  402,    0,  363,  386,  130,  131,
 /*   670 */   358,  390,  395,  329,  395,  394,  395,  396,  397,  398,
 /*   680 */   399,  400,    3,  402,  395,  341,   20,  331,  407,   94,
 /*   690 */   409,  336,  337,  326,  413,  414,  329,  435,  436,   20,
 /*   700 */   351,  424,  358,  424,  423,  351,  417,  418,  419,  353,
 /*   710 */   421,  116,  406,  175,  408,  177,  439,  440,  439,  440,
 /*   720 */   321,  444,  445,  444,  445,  130,  131,  321,    8,    9,
 /*   730 */     1,    2,   12,   13,   14,   15,   16,  392,  200,  201,
 /*   740 */    20,  203,  204,  205,  206,  207,  208,  209,  210,  211,
 /*   750 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   760 */   222,  223,  363,  242,  374,  420,  376,  358,  329,  363,
 /*   770 */   175,  106,  177,  343,   95,  374,  346,  376,  369,  241,
 /*   780 */   341,    8,    9,   20,  321,   12,   13,   14,   15,   16,
 /*   790 */   125,  126,  127,  128,  129,  200,  201,  358,  203,  204,
 /*   800 */   205,  206,  207,  208,  209,  210,  211,  212,  213,  214,
 /*   810 */   215,  216,  217,  218,  219,  220,  221,  222,  223,   12,
 /*   820 */    13,  365,    4,  358,   95,  106,  363,   20,  162,   22,
 /*   830 */   321,  375,   43,  405,  369,  360,  408,   19,  363,   56,
 /*   840 */    33,  162,   35,    2,  125,  126,  127,  128,  129,    8,
 /*   850 */     9,   33,  321,   12,   13,   14,   15,   16,  329,  105,
 /*   860 */   321,  329,  321,   56,  351,   47,  329,  350,   95,   51,
 /*   870 */   341,  321,  363,  341,   56,   68,   12,   13,  341,   96,
 /*   880 */   329,  350,  162,  366,   20,  360,   22,  358,  363,  358,
 /*   890 */   358,   39,  341,  382,  363,  358,  365,   33,    0,   35,
 /*   900 */   350,   94,  363,  338,  363,  340,  329,  153,  358,  358,
 /*   910 */   329,   93,   46,  363,   96,  365,  343,  386,  341,  346,
 /*   920 */    56,  390,  341,  116,  321,  394,  395,  396,  397,  398,
 /*   930 */   399,  400,   68,  402,    0,  358,  386,  130,  131,  358,
 /*   940 */   390,  321,  329,  321,  394,  395,  396,  397,  398,  399,
 /*   950 */   400,  322,  402,  350,  341,   44,   45,  407,   94,  409,
 /*   960 */    94,  358,  329,  413,  414,    3,  363,  204,  365,  239,
 /*   970 */   240,  358,  393,  423,  341,  329,  448,  446,  447,   43,
 /*   980 */   116,  437,  175,  363,  177,  363,   35,  341,  330,  386,
 /*   990 */   321,  358,  321,  390,  130,  131,   22,  394,  395,  396,
 /*  1000 */   397,  398,  399,  400,  358,  402,   43,  200,  201,   35,
 /*  1010 */   203,  204,  205,  206,  207,  208,  209,  210,  211,  212,
 /*  1020 */   213,  214,  215,  216,  217,  218,  219,  220,  221,  222,
 /*  1030 */   223,   95,  363,   33,  363,   42,   43,  162,  163,  175,
 /*  1040 */   106,  177,   98,    1,    2,  101,  148,   47,   98,  260,
 /*  1050 */   447,  101,   52,   53,   54,   55,   56,   95,   95,  125,
 /*  1060 */   126,  127,  128,  129,  200,  201,    0,  203,  204,  205,
 /*  1070 */   206,  207,  208,  209,  210,  211,  212,  213,  214,  215,
 /*  1080 */   216,  217,  218,  219,  220,  221,  222,  223,   18,  329,
 /*  1090 */    20,    0,  240,   93,  431,   98,   96,   27,  101,  350,
 /*  1100 */    30,  341,    8,    9,    0,    0,   12,   13,   14,   15,
 /*  1110 */    16,   98,   43,   22,  101,   94,   43,   47,  358,   49,
 /*  1120 */    35,   51,  130,  131,  330,  104,   22,   22,  177,   63,
 /*  1130 */    64,   65,   66,   67,  328,   69,   70,   71,   72,   73,
 /*  1140 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*  1150 */    84,   85,   86,   87,   88,   89,   90,   18,  158,  159,
 /*  1160 */    13,  161,   23,   93,   95,  165,    8,    9,   95,  393,
 /*  1170 */    12,   13,   14,   15,   16,  105,   37,   38,  362,   43,
 /*  1180 */    41,  181,   35,  378,    8,    9,   43,   43,   12,   13,
 /*  1190 */    14,   15,   16,  422,   43,   43,   57,   58,   59,  321,
 /*  1200 */   395,   43,   43,  133,  425,   13,  136,  137,  138,  139,
 /*  1210 */   140,  141,  142,  143,  144,  145,  146,  147,  148,  149,
 /*  1220 */   150,  151,  152,  441,  154,  155,  156,   35,  350,  424,
 /*  1230 */    43,   95,   35,   94,  415,  388,  358,   61,   95,   95,
 /*  1240 */    47,  363,  243,  365,  439,  440,   95,   95,    0,  444,
 /*  1250 */   445,  173,    8,    9,   95,  329,   12,   13,   14,   15,
 /*  1260 */    16,  167,  177,  387,  386,   68,   43,  341,  390,   43,
 /*  1270 */   380,  132,  394,  395,  396,  397,  398,  399,  400,  103,
 /*  1280 */   402,   42,   95,  405,  358,  407,  408,  409,   43,  370,
 /*  1290 */    43,  413,  414,   43,    8,    9,   48,  157,   12,   13,
 /*  1300 */    14,   15,   16,  378,   20,  378,  167,  168,  169,    8,
 /*  1310 */     9,  172,  329,   12,   13,   14,   15,   16,   95,  370,
 /*  1320 */   395,   95,  395,  368,  341,  329,  370,  329,  368,  190,
 /*  1330 */    92,  329,  193,  157,  195,  196,  197,  198,  199,   95,
 /*  1340 */    95,  358,   95,  368,  335,   95,  329,  329,   20,  424,
 /*  1350 */   321,  424,   20,  323,  323,  384,  333,  263,  333,  365,
 /*  1360 */    20,  377,   20,  377,  439,  440,  439,  440,  379,  444,
 /*  1370 */   445,  444,  445,  333,  333,  329,  333,  333,  333,  350,
 /*  1380 */   241,  323,  350,  350,  350,  350,  350,  358,  350,  350,
 /*  1390 */   329,  323,  363,  321,  365,  189,  385,  350,  350,  350,
 /*  1400 */   350,  180,  331,  384,  228,  229,  230,  231,  232,  233,
 /*  1410 */   234,  235,  236,  237,  238,  386,  363,  365,  331,  390,
 /*  1420 */   383,  329,  350,  394,  395,  396,  397,  398,  399,  400,
 /*  1430 */   358,  402,  329,  377,  248,  363,  407,  365,  409,  331,
 /*  1440 */   373,  159,  413,  414,  363,  363,  363,  363,  162,  373,
 /*  1450 */   371,  363,  331,  346,  321,  331,  358,   20,  386,  363,
 /*  1460 */   249,  433,  390,  434,  363,  255,  394,  395,  396,  397,
 /*  1470 */   398,  399,  400,  393,  402,  373,  321,  363,  166,  407,
 /*  1480 */   363,  409,  393,  350,  430,  413,  414,  430,  373,  363,
 /*  1490 */   257,  358,  432,  430,  429,  423,  363,  256,  365,  244,
 /*  1500 */   388,  264,  428,  261,  427,  350,  240,  443,  449,   20,
 /*  1510 */   259,  358,  392,  358,   94,   94,  354,  442,  363,  386,
 /*  1520 */   365,  412,  340,  390,  363,  329,  378,  394,  395,  396,
 /*  1530 */   397,  398,  399,  400,  321,  402,  331,   36,  324,  323,
 /*  1540 */   407,  386,  409,  395,  381,  390,  413,  414,  376,  394,
 /*  1550 */   395,  396,  397,  398,  399,  400,  344,  402,    0,  344,
 /*  1560 */    12,   13,  407,  350,  409,  319,  344,  332,  413,  414,
 /*  1570 */    22,  358,  424,    0,  182,    0,  363,    0,  365,   42,
 /*  1580 */     0,   33,   35,   35,  194,   35,   35,  439,  440,   35,
 /*  1590 */   194,    0,  444,  445,  321,   35,   35,  194,    0,  386,
 /*  1600 */   194,   22,    0,  390,   56,   35,    0,  394,  395,  396,
 /*  1610 */   397,  398,  399,  400,   35,  402,   68,   22,    0,  177,
 /*  1620 */   407,   35,  409,  350,  175,    0,  413,  414,    0,  171,
 /*  1630 */   170,  358,    0,    0,   46,    0,  363,    0,  365,    0,
 /*  1640 */     0,   42,    0,    0,    0,   42,    0,   68,    0,    0,
 /*  1650 */     0,  148,   35,    0,  148,  321,    0,    0,    0,  386,
 /*  1660 */     0,    0,    0,  390,  116,    0,    0,  394,  395,  396,
 /*  1670 */   397,  398,  399,  400,    0,  402,    0,    0,    0,    0,
 /*  1680 */     0,    0,  409,   42,  350,    0,  413,  414,   43,  355,
 /*  1690 */     0,    0,  358,    0,    0,  116,    0,  363,    0,  365,
 /*  1700 */     0,    0,   35,    0,   22,    0,    0,   56,   56,  321,
 /*  1710 */     0,   42,   39,   14,    0,   40,   46,   46,   14,    0,
 /*  1720 */   386,    0,   39,  175,  390,  177,    0,    0,  394,  395,
 /*  1730 */   396,  397,  398,  399,  400,  166,  402,    0,  350,    0,
 /*  1740 */     0,   39,    0,   35,   47,    0,  358,   35,  200,  201,
 /*  1750 */    39,  363,  321,  365,  175,   39,  177,   62,    0,   35,
 /*  1760 */    47,    0,  214,  215,  216,  217,  218,  219,  220,   47,
 /*  1770 */    35,   39,   47,   39,  386,    0,  321,    0,  390,  200,
 /*  1780 */   201,  350,  394,  395,  396,  397,  398,  399,  400,  358,
 /*  1790 */   402,    0,    0,   22,  363,  103,  365,  409,   35,    0,
 /*  1800 */    35,  413,  414,   35,   22,  350,   22,   35,  101,   35,
 /*  1810 */    43,   35,   43,  358,   35,   35,    0,  386,  363,   22,
 /*  1820 */   365,  390,    0,   22,    0,  394,  395,  396,  397,  398,
 /*  1830 */   399,  400,  401,  402,  403,  404,   49,   22,    0,   35,
 /*  1840 */    35,  386,  321,    0,   35,  390,    0,   22,   20,  394,
 /*  1850 */   395,  396,  397,  398,  399,  400,   94,  402,    0,   95,
 /*  1860 */     0,   35,  321,   22,  409,  178,    0,    0,  159,  414,
 /*  1870 */     0,  350,    3,    0,    0,   94,  187,  162,   95,  358,
 /*  1880 */   162,  164,  162,   35,  363,   35,  365,    0,   94,  160,
 /*  1890 */    94,  350,    0,   39,  158,   46,   94,  104,   43,  358,
 /*  1900 */    43,   94,   43,   95,  363,  321,  365,  386,  224,  245,
 /*  1910 */    46,  390,  226,   94,   94,  394,  395,  396,  397,  398,
 /*  1920 */   399,  400,   95,  402,   95,  404,   95,  386,   94,  321,
 /*  1930 */    94,  390,   95,   94,  350,  394,  395,  396,  397,  398,
 /*  1940 */   399,  400,  358,  402,   43,   46,   94,  363,   95,  365,
 /*  1950 */    43,   95,  224,    3,   43,   35,   35,   35,  350,   35,
 /*  1960 */    35,   35,   46,  355,   46,   46,  358,   95,  245,   22,
 /*  1970 */   386,  363,   95,  365,  390,  245,   43,  436,  394,  395,
 /*  1980 */   396,  397,  398,  399,  400,  239,  402,    2,  200,  321,
 /*  1990 */    94,   46,   95,   95,  386,   95,   94,   94,  390,   46,
 /*  2000 */    94,   22,  394,  395,  396,  397,  398,  399,  400,  321,
 /*  2010 */   402,   94,  202,  105,   22,   35,   35,   94,  350,   35,
 /*  2020 */   106,   94,  438,  355,   95,   95,  358,   95,   94,   35,
 /*  2030 */    95,  363,   94,  365,   95,   35,   94,   35,  350,   95,
 /*  2040 */    94,   35,   43,   94,   22,   94,  358,   61,   94,  118,
 /*  2050 */    62,  363,  321,  365,  386,  118,   35,   68,  390,  118,
 /*  2060 */    35,  118,  394,  395,  396,  397,  398,  399,  400,   91,
 /*  2070 */   402,  321,   35,   35,  386,   35,   35,   35,  390,   35,
 /*  2080 */    35,  350,  394,  395,  396,  397,  398,  399,  400,  358,
 /*  2090 */   402,   35,   43,   35,  363,   35,  365,   22,   35,   22,
 /*  2100 */   350,   35,   35,   35,   68,   35,   35,   35,  358,   35,
 /*  2110 */    22,   35,    0,  363,   35,  365,   35,  386,    0,   39,
 /*  2120 */    47,  390,   35,   39,  321,  394,  395,  396,  397,  398,
 /*  2130 */   399,  400,   47,  402,    0,   35,  386,   47,   39,    0,
 /*  2140 */   390,   35,  321,   47,  394,  395,  396,  397,  398,  399,
 /*  2150 */   400,    0,  402,  350,   39,   35,   35,    0,   22,   21,
 /*  2160 */   450,  358,   22,   22,   21,   20,  363,  450,  365,  450,
 /*  2170 */   450,  350,  450,  450,  450,  450,  450,  450,  450,  358,
 /*  2180 */   450,  450,  450,  450,  363,  450,  365,  450,  450,  386,
 /*  2190 */   450,  450,  450,  390,  450,  450,  450,  394,  395,  396,
 /*  2200 */   397,  398,  399,  400,  450,  402,  321,  386,  450,  450,
 /*  2210 */   450,  390,  450,  450,  450,  394,  395,  396,  397,  398,
 /*  2220 */   399,  400,  450,  402,  450,  450,  321,  450,  450,  450,
 /*  2230 */   450,  450,  450,  450,  450,  350,  450,  450,  450,  450,
 /*  2240 */   450,  450,  450,  358,  450,  450,  450,  450,  363,  450,
 /*  2250 */   365,  450,  450,  450,  450,  350,  450,  450,  450,  450,
 /*  2260 */   450,  450,  450,  358,  450,  450,  450,  450,  363,  321,
 /*  2270 */   365,  386,  450,  450,  450,  390,  450,  450,  450,  394,
 /*  2280 */   395,  396,  397,  398,  399,  400,  450,  402,  321,  450,
 /*  2290 */   450,  386,  450,  450,  450,  390,  450,  450,  350,  394,
 /*  2300 */   395,  396,  397,  398,  399,  400,  358,  402,  450,  450,
 /*  2310 */   450,  363,  450,  365,  450,  450,  450,  350,  450,  450,
 /*  2320 */   450,  450,  450,  450,  450,  358,  450,  450,  450,  450,
 /*  2330 */   363,  321,  365,  450,  386,  450,  450,  450,  390,  450,
 /*  2340 */   450,  450,  394,  395,  396,  397,  398,  399,  400,  450,
 /*  2350 */   402,  450,  450,  386,  450,  321,  450,  390,  450,  450,
 /*  2360 */   350,  394,  395,  396,  397,  398,  399,  400,  358,  402,
 /*  2370 */   450,  450,  450,  363,  321,  365,  450,  450,  450,  450,
 /*  2380 */   450,  450,  450,  450,  350,  450,  450,  450,  450,  450,
 /*  2390 */   450,  450,  358,  450,  450,  450,  386,  363,  450,  365,
 /*  2400 */   390,  450,  450,  350,  394,  395,  396,  397,  398,  399,
 /*  2410 */   400,  358,  402,  450,  450,  450,  363,  450,  365,  450,
 /*  2420 */   386,  450,  450,  450,  390,  450,  450,  450,  394,  395,
 /*  2430 */   396,  397,  398,  399,  400,  321,  402,  450,  450,  386,
 /*  2440 */   450,  450,  450,  390,  450,  450,  450,  394,  395,  396,
 /*  2450 */   397,  398,  399,  400,  450,  402,  450,  450,  450,  450,
 /*  2460 */   450,  450,  450,  450,  350,  450,  450,  450,  450,  450,
 /*  2470 */   450,  450,  358,  450,  450,  450,  450,  363,  450,  365,
 /*  2480 */   450,  450,  450,  450,  450,  450,  450,  450,  321,  450,
 /*  2490 */   450,  450,  450,  450,  450,  450,  450,  450,  450,  450,
 /*  2500 */   386,  450,  450,  450,  390,  450,  321,  450,  394,  395,
 /*  2510 */   396,  397,  398,  399,  400,  450,  402,  350,  450,  450,
 /*  2520 */   450,  450,  450,  450,  450,  358,  450,  450,  450,  450,
 /*  2530 */   363,  450,  365,  450,  450,  350,  450,  450,  450,  450,
 /*  2540 */   450,  450,  450,  358,  450,  450,  450,  450,  363,  450,
 /*  2550 */   365,  450,  450,  386,  450,  450,  450,  390,  450,  450,
 /*  2560 */   450,  394,  395,  396,  397,  398,  399,  400,  450,  402,
 /*  2570 */   321,  386,  450,  450,  450,  390,  450,  450,  450,  394,
 /*  2580 */   395,  396,  397,  398,  399,  400,  450,  402,  450,  450,
 /*  2590 */   321,  450,  450,  450,  450,  450,  450,  450,  450,  350,
 /*  2600 */   450,  450,  450,  450,  450,  450,  450,  358,  450,  450,
 /*  2610 */   450,  450,  363,  450,  365,  450,  450,  450,  450,  350,
 /*  2620 */   450,  450,  450,  450,  450,  450,  450,  358,  450,  450,
 /*  2630 */   450,  450,  363,  321,  365,  386,  450,  450,  450,  390,
 /*  2640 */   450,  450,  450,  394,  395,  396,  397,  398,  399,  400,
 /*  2650 */   450,  402,  321,  450,  450,  386,  450,  450,  450,  390,
 /*  2660 */   450,  450,  350,  394,  395,  396,  397,  398,  399,  400,
 /*  2670 */   358,  402,  450,  450,  450,  363,  450,  365,  450,  450,
 /*  2680 */   450,  350,  450,  450,  450,  450,  450,  450,  450,  358,
 /*  2690 */   450,  450,  450,  450,  363,  321,  365,  450,  386,  450,
 /*  2700 */   450,  450,  390,  450,  450,  450,  394,  395,  396,  397,
 /*  2710 */   398,  399,  400,  450,  402,  450,  450,  386,  450,  321,
 /*  2720 */   450,  390,  450,  450,  350,  394,  395,  396,  397,  398,
 /*  2730 */   399,  400,  358,  402,  450,  450,  450,  363,  450,  365,
 /*  2740 */   450,  450,  450,  450,  450,  450,  450,  450,  350,  450,
 /*  2750 */   450,  450,  450,  450,  450,  450,  358,  450,  450,  450,
 /*  2760 */   386,  363,  450,  365,  390,  450,  450,  450,  394,  395,
 /*  2770 */   396,  397,  398,  399,  400,  450,  402,  450,  450,  450,
 /*  2780 */   450,  450,  450,  450,  386,  450,  450,  450,  390,  450,
 /*  2790 */   450,  450,  394,  395,  396,  397,  398,  399,  400,  450,
 /*  2800 */   402,
};
#define YY_SHIFT_COUNT    (698)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2157)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1139,    0,   57,  269,   57,  326,  326,  326,  538,  326,
 /*    10 */   326,  326,  326,  326,  595,  807,  807,  864,  807,  807,
 /*    20 */   807,  807,  807,  807,  807,  807,  807,  807,  807,  807,
 /*    30 */   807,  807,  807,  807,  807,  807,  807,  807,  807,  807,
 /*    40 */   807,  807,  807,  807,  807,  807,   12,   53,   88,    4,
 /*    50 */   196,   80,  130,   80,   88,   88, 1548, 1548,   80, 1548,
 /*    60 */  1548,  408,   80,  115,  115,    1,    1,    8,  115,  115,
 /*    70 */   115,  115,  115,  115,  115,  115,  115,  115,  112,  115,
 /*    80 */   115,  115,  156,  115,  115,  176,  115,  115,  176,  381,
 /*    90 */   115,  176,  176,  176,  115,  180, 1070, 1176, 1176,  166,
 /*   100 */   403, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   110 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   120 */   491,  679,    8,  486,  486,  226,  323,  518,  270,  270,
 /*   130 */   293,  293,  293,  323,  386,  386,  386,  321,  156,   19,
 /*   140 */    19,   76,  176,  176,  527,  527,  321,  548,  400,  400,
 /*   150 */   400,  400,  400,  400,  400,  264,  504,  137,  720, 1094,
 /*   160 */   198,   67,  167,   83,  433,  134,  911,  313,  666,  730,
 /*   170 */   852,  107,  730,  993,  521,  763,  999, 1193, 1078, 1239,
 /*   180 */  1239, 1140, 1284, 1284, 1239, 1140, 1140, 1238, 1284, 1284,
 /*   190 */  1284, 1328, 1328, 1332,  112,  156,  112, 1340, 1342,  112,
 /*   200 */  1340,  112,  112,  112, 1284,  112, 1328,  176,  176,  176,
 /*   210 */   176,  176,  176,  176,  176,  176,  176,  176, 1284, 1328,
 /*   220 */   527, 1206, 1332,  180, 1221,  156,  180, 1284, 1284, 1340,
 /*   230 */   180, 1186,  527,  527,  527,  527, 1186,  527, 1282,  180,
 /*   240 */   321,  180,  386, 1437, 1437,  527, 1211, 1186,  527,  527,
 /*   250 */  1211, 1186,  527,  527,  176, 1210, 1312, 1211, 1233, 1241,
 /*   260 */  1255,  999, 1237, 1242, 1251, 1266,  386, 1489, 1420, 1421,
 /*   270 */   527,  548, 1284,  180, 1501, 1328, 2801, 2801, 2801, 2801,
 /*   280 */  2801, 2801, 2801, 1066, 1000,  436,  818,  773, 1158, 1244,
 /*   290 */    50,  841, 1286,  665, 1301, 1301, 1301, 1301, 1301, 1301,
 /*   300 */  1301, 1301, 1301,  934,  719,  124,  373,   11,   11,  192,
 /*   310 */   542,  101,  311,  168,   15,  729,  336,   15,   15,   15,
 /*   320 */   936,  505,  974,  754,  898,  944,  950,  997, 1013, 1091,
 /*   330 */  1104, 1105,  783,  875,  963, 1069, 1073, 1136, 1143, 1144,
 /*   340 */  1151,  992,  789,  327, 1042, 1152,  951, 1085,  410, 1159,
 /*   350 */   962,  866, 1187, 1223, 1226, 1245, 1247, 1250, 1021, 1147,
 /*   360 */  1192, 1197, 1248, 1558, 1573, 1392, 1575, 1577, 1537, 1580,
 /*   370 */  1547, 1390, 1550, 1551, 1554, 1396, 1591, 1560, 1561, 1403,
 /*   380 */  1598, 1406, 1602, 1570, 1606, 1595, 1618, 1586, 1442, 1449,
 /*   390 */  1625, 1628, 1458, 1460, 1632, 1633, 1588, 1635, 1637, 1639,
 /*   400 */  1599, 1640, 1642, 1643, 1603, 1644, 1646, 1648, 1649, 1650,
 /*   410 */  1503, 1617, 1653, 1506, 1656, 1657, 1658, 1660, 1661, 1662,
 /*   420 */  1665, 1666, 1674, 1676, 1677, 1678, 1679, 1680, 1681, 1641,
 /*   430 */  1685, 1690, 1691, 1693, 1694, 1682, 1696, 1698, 1700, 1701,
 /*   440 */  1667, 1703, 1651, 1705, 1652, 1706, 1710, 1669, 1673, 1645,
 /*   450 */  1699, 1670, 1704, 1671, 1714, 1675, 1683, 1719, 1721, 1726,
 /*   460 */  1702, 1569, 1727, 1737, 1739, 1695, 1740, 1742, 1708, 1697,
 /*   470 */  1711, 1745, 1712, 1713, 1716, 1758, 1724, 1722, 1732, 1761,
 /*   480 */  1735, 1725, 1734, 1775, 1777, 1791, 1792, 1692, 1707, 1763,
 /*   490 */  1771, 1799, 1765, 1768, 1782, 1772, 1774, 1767, 1769, 1776,
 /*   500 */  1779, 1784, 1780, 1816, 1797, 1822, 1801, 1787, 1824, 1815,
 /*   510 */  1804, 1838, 1805, 1843, 1809, 1846, 1825, 1828, 1764, 1762,
 /*   520 */  1858, 1715, 1826, 1860, 1687, 1841, 1718, 1709, 1866, 1867,
 /*   530 */  1720, 1717, 1869, 1870, 1873, 1874, 1781, 1783, 1848, 1850,
 /*   540 */  1689, 1887, 1794, 1729, 1796, 1892, 1854, 1736, 1802, 1793,
 /*   550 */  1849, 1855, 1684, 1686, 1728, 1857, 1664, 1807, 1808, 1819,
 /*   560 */  1827, 1829, 1820, 1859, 1831, 1834, 1836, 1839, 1837, 1901,
 /*   570 */  1864, 1899, 1852, 1907, 1723, 1853, 1856, 1950, 1911, 1730,
 /*   580 */  1920, 1921, 1922, 1924, 1925, 1926, 1872, 1877, 1916, 1746,
 /*   590 */  1933, 1918, 1919, 1985, 1947, 1788, 1896, 1897, 1902, 1898,
 /*   600 */  1903, 1900, 1945, 1906, 1917, 1953, 1929, 1979, 1810, 1923,
 /*   610 */  1908, 1930, 1980, 1981, 1927, 1932, 1984, 1934, 1935, 1994,
 /*   620 */  1938, 1939, 2000, 1942, 1944, 2002, 1946, 1931, 1937, 1941,
 /*   630 */  1943, 1992, 1914, 1949, 1951, 2006, 1954, 1999, 1999, 2022,
 /*   640 */  1988, 1986, 2021, 2025, 2037, 2038, 2040, 2041, 2042, 2044,
 /*   650 */  2045, 2056, 1989, 1978, 2049, 2058, 2060, 2075, 2063, 2077,
 /*   660 */  2066, 2067, 2068, 2036, 1767, 2070, 1769, 2071, 2072, 2074,
 /*   670 */  2076, 2088, 2079, 2112, 2081, 2073, 2080, 2118, 2087, 2085,
 /*   680 */  2084, 2134, 2100, 2090, 2099, 2139, 2106, 2096, 2115, 2151,
 /*   690 */  2120, 2121, 2157, 2136, 2138, 2140, 2141, 2143, 2145,
};
#define YY_REDUCE_COUNT (282)
#define YY_REDUCE_MIN   (-409)
#define YY_REDUCE_MAX   (2398)
static const short yy_reduce_ofst[] = {
 /*     0 */   -90, -254, -314,  878, 1029,  281,  550, 1072,  -22, 1133,
 /*    10 */  1155, 1213, 1273, 1388, 1431,  262,  531, 1455, 1334, 1521,
 /*    20 */  1541, 1584,  603, 1608, 1668, 1688, 1731, 1750, 1803, 1821,
 /*    30 */  1885, 1905, 1948, 1967, 2010, 2034, 2053, 2114, 2167, 2185,
 /*    40 */  2249, 2269, 2312, 2331, 2374, 2398,  -29,  279, -224,  277,
 /*    50 */   805,  925,  927, 1148,  -14,  289, -352, -349, -317, -342,
 /*    60 */   -67,   14,  160, -102,   38, -319, -310, -212, -208,  224,
 /*    70 */   282,  292,  312,  344,  439,  529,  532,  537, -232,  551,
 /*    80 */   577,  581, -246,  613,  633, -161,  646,  760,  -26,  -99,
 /*    90 */   926,  220,  -24,  284,  983,  -98, -313, -409, -409,  -31,
 /*   100 */  -265, -164, -138, -119,  -12,   -7,  233,  236,  251,  303,
 /*   110 */   399,  406,  463,  509,  539,  541,  620,  622,  669,  671,
 /*   120 */    59,  -23, -290,  237,  367, -242,  103,  356,  195,  306,
 /*   130 */   -23,  193,  345,  355,  -74,  409,  465,  430,  456,  390,
 /*   140 */   401,  428, -316,  517,  475,  525,  573,  565, -347,  145,
 /*   150 */   271,  291,  349,  354,  513,  511,  238,  629,  579,  528,
 /*   160 */   544,  658,  663,  749,  749,  794,  806,  816,  776,  771,
 /*   170 */   771,  782,  771,  819,  779,  749,  847,  876,  890,  919,
 /*   180 */   949,  955,  996,  998,  956,  960,  975, 1009, 1002, 1017,
 /*   190 */  1018, 1030, 1031,  971, 1023,  994, 1025,  984,  989, 1040,
 /*   200 */   986, 1041, 1043, 1044, 1046, 1045, 1058, 1032, 1033, 1034,
 /*   210 */  1035, 1036, 1038, 1039, 1047, 1048, 1049, 1050, 1061, 1068,
 /*   220 */  1053, 1011, 1019, 1071, 1037, 1052, 1087, 1092, 1103, 1056,
 /*   230 */  1108, 1067, 1081, 1082, 1083, 1084, 1076, 1088, 1079, 1121,
 /*   240 */  1107, 1124, 1098, 1080, 1089, 1096, 1054, 1102, 1101, 1114,
 /*   250 */  1057, 1115, 1117, 1126,  749, 1028, 1060, 1063, 1065, 1074,
 /*   260 */  1077, 1112, 1059, 1064, 1075,  771, 1153, 1120, 1109, 1162,
 /*   270 */  1161, 1182, 1196, 1205, 1214, 1216, 1163, 1172, 1212, 1215,
 /*   280 */  1222, 1235, 1246,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*    10 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*    20 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*    30 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*    40 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*    50 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*    60 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*    70 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1633, 1559,
 /*    80 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*    90 */  1559, 1559, 1559, 1559, 1559, 1631, 1803, 1992, 1559, 1559,
 /*   100 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   110 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   120 */  1559, 2004, 1559, 1559, 1559, 1633, 1559, 1631, 1964, 1964,
 /*   130 */  2004, 2004, 2004, 1559, 1559, 1559, 1559, 1742, 1559, 1844,
 /*   140 */  1844, 1559, 1559, 1559, 1559, 1559, 1742, 1559, 1559, 1559,
 /*   150 */  1559, 1559, 1559, 1559, 1559, 1838, 1559, 1559, 2029, 2082,
 /*   160 */  1559, 1559, 2032, 1559, 1559, 1559, 1559, 1695, 2019, 1996,
 /*   170 */  2010, 2066, 1997, 1994, 2013, 1559, 2023, 1559, 1831, 1808,
 /*   180 */  1808, 1805, 1559, 1559, 1808, 1805, 1805, 1686, 1559, 1559,
 /*   190 */  1559, 1559, 1559, 1559, 1633, 1559, 1633, 1559, 1559, 1633,
 /*   200 */  1559, 1633, 1633, 1633, 1559, 1633, 1559, 1559, 1559, 1559,
 /*   210 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   220 */  1559, 1851, 1559, 1631, 1840, 1559, 1631, 1559, 1559, 1559,
 /*   230 */  1631, 2037, 1559, 1559, 1559, 1559, 2037, 1559, 1559, 1631,
 /*   240 */  1559, 1631, 1559, 1559, 1559, 1559, 2039, 2037, 1559, 1559,
 /*   250 */  2039, 2037, 1559, 1559, 1559, 2051, 2047, 2039, 2055, 2053,
 /*   260 */  2025, 2023, 2085, 2072, 2068, 2010, 1559, 1559, 1559, 1711,
 /*   270 */  1559, 1559, 1559, 1631, 1591, 1559, 1833, 1844, 1745, 1745,
 /*   280 */  1745, 1634, 1564, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   290 */  1559, 1559, 1559, 1559, 1920, 1559, 2050, 2049, 1968, 1967,
 /*   300 */  1966, 1957, 1919, 1559, 1707, 1559, 1559, 1918, 1917, 1559,
 /*   310 */  1559, 1559, 1559, 1559, 1911, 1559, 1559, 1912, 1910, 1909,
 /*   320 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   330 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   340 */  1559, 1559, 2069, 2073, 1993, 1559, 1559, 1559, 1559, 1559,
 /*   350 */  1902, 1893, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   360 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   370 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   380 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   390 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   400 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   410 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   420 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   430 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   440 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1596,
 /*   450 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   460 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   470 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   480 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   490 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1673, 1672, 1559,
 /*   500 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   510 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1901, 1559,
 /*   520 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   530 */  1559, 1559, 2065, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   540 */  1559, 1848, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   550 */  1559, 1954, 1559, 1559, 1559, 2026, 1559, 1559, 1559, 1559,
 /*   560 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   570 */  1559, 1893, 1559, 2048, 1559, 1559, 2063, 1559, 2067, 1559,
 /*   580 */  1559, 1559, 1559, 1559, 1559, 1559, 2003, 1999, 1559, 1559,
 /*   590 */  1995, 1892, 1559, 1988, 1559, 1559, 1939, 1559, 1559, 1559,
 /*   600 */  1559, 1559, 1559, 1559, 1559, 1559, 1901, 1559, 1905, 1559,
 /*   610 */  1559, 1559, 1559, 1559, 1739, 1559, 1559, 1559, 1559, 1559,
 /*   620 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1724, 1722, 1721,
 /*   630 */  1720, 1559, 1717, 1559, 1559, 1559, 1559, 1748, 1747, 1559,
 /*   640 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   650 */  1559, 1559, 1559, 1559, 1653, 1559, 1559, 1559, 1559, 1559,
 /*   660 */  1559, 1559, 1559, 1559, 1644, 1559, 1643, 1559, 1559, 1559,
 /*   670 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   680 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
 /*   690 */  1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559, 1559,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       CASE => nothing */
  265,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  265,  /*      AFTER => ABORT */
  265,  /*     ATTACH => ABORT */
  265,  /*     BEFORE => ABORT */
  265,  /*      BEGIN => ABORT */
  265,  /*     BITAND => ABORT */
  265,  /*     BITNOT => ABORT */
  265,  /*      BITOR => ABORT */
  265,  /*     BLOCKS => ABORT */
  265,  /*     CHANGE => ABORT */
  265,  /*      COMMA => ABORT */
  265,  /*    COMPACT => ABORT */
  265,  /*     CONCAT => ABORT */
  265,  /*   CONFLICT => ABORT */
  265,  /*       COPY => ABORT */
  265,  /*   DEFERRED => ABORT */
  265,  /* DELIMITERS => ABORT */
  265,  /*     DETACH => ABORT */
  265,  /*     DIVIDE => ABORT */
  265,  /*        DOT => ABORT */
  265,  /*       EACH => ABORT */
  265,  /*       FAIL => ABORT */
  265,  /*       FILE => ABORT */
  265,  /*        FOR => ABORT */
  265,  /*       GLOB => ABORT */
  265,  /*         ID => ABORT */
  265,  /*  IMMEDIATE => ABORT */
  265,  /*     IMPORT => ABORT */
  265,  /*  INITIALLY => ABORT */
  265,  /*    INSTEAD => ABORT */
  265,  /*     ISNULL => ABORT */
  265,  /*        KEY => ABORT */
  265,  /*    MODULES => ABORT */
  265,  /*  NK_BITNOT => ABORT */
  265,  /*    NK_SEMI => ABORT */
  265,  /*    NOTNULL => ABORT */
  265,  /*         OF => ABORT */
  265,  /*       PLUS => ABORT */
  265,  /*  PRIVILEGE => ABORT */
  265,  /*      RAISE => ABORT */
  265,  /*    REPLACE => ABORT */
  265,  /*   RESTRICT => ABORT */
  265,  /*        ROW => ABORT */
  265,  /*       SEMI => ABORT */
  265,  /*       STAR => ABORT */
  265,  /*  STATEMENT => ABORT */
  265,  /*     STRING => ABORT */
  265,  /*      TIMES => ABORT */
  265,  /*     UPDATE => ABORT */
  265,  /*     VALUES => ABORT */
  265,  /*   VARIABLE => ABORT */
  265,  /*       VIEW => ABORT */
  265,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "TRIM",
  /*   60 */ "IF",
  /*   61 */ "NOT",
  /*   62 */ "EXISTS",
  /*   63 */ "BUFFER",
  /*   64 */ "CACHEMODEL",
  /*   65 */ "CACHESIZE",
  /*   66 */ "COMP",
  /*   67 */ "DURATION",
  /*   68 */ "NK_VARIABLE",
  /*   69 */ "MAXROWS",
  /*   70 */ "MINROWS",
  /*   71 */ "KEEP",
  /*   72 */ "PAGES",
  /*   73 */ "PAGESIZE",
  /*   74 */ "TSDB_PAGESIZE",
  /*   75 */ "PRECISION",
  /*   76 */ "REPLICA",
  /*   77 */ "STRICT",
  /*   78 */ "VGROUPS",
  /*   79 */ "SINGLE_STABLE",
  /*   80 */ "RETENTIONS",
  /*   81 */ "SCHEMALESS",
  /*   82 */ "WAL_LEVEL",
  /*   83 */ "WAL_FSYNC_PERIOD",
  /*   84 */ "WAL_RETENTION_PERIOD",
  /*   85 */ "WAL_RETENTION_SIZE",
  /*   86 */ "WAL_ROLL_PERIOD",
  /*   87 */ "WAL_SEGMENT_SIZE",
  /*   88 */ "STT_TRIGGER",
  /*   89 */ "TABLE_PREFIX",
  /*   90 */ "TABLE_SUFFIX",
  /*   91 */ "NK_COLON",
  /*   92 */ "MAX_SPEED",
  /*   93 */ "TABLE",
  /*   94 */ "NK_LP",
  /*   95 */ "NK_RP",
  /*   96 */ "STABLE",
  /*   97 */ "ADD",
  /*   98 */ "COLUMN",
  /*   99 */ "MODIFY",
  /*  100 */ "RENAME",
  /*  101 */ "TAG",
  /*  102 */ "SET",
  /*  103 */ "NK_EQ",
  /*  104 */ "USING",
  /*  105 */ "TAGS",
  /*  106 */ "COMMENT",
  /*  107 */ "BOOL",
  /*  108 */ "TINYINT",
  /*  109 */ "SMALLINT",
  /*  110 */ "INT",
  /*  111 */ "INTEGER",
  /*  112 */ "BIGINT",
  /*  113 */ "FLOAT",
  /*  114 */ "DOUBLE",
  /*  115 */ "BINARY",
  /*  116 */ "TIMESTAMP",
  /*  117 */ "NCHAR",
  /*  118 */ "UNSIGNED",
  /*  119 */ "JSON",
  /*  120 */ "VARCHAR",
  /*  121 */ "MEDIUMBLOB",
  /*  122 */ "BLOB",
  /*  123 */ "VARBINARY",
  /*  124 */ "DECIMAL",
  /*  125 */ "MAX_DELAY",
  /*  126 */ "WATERMARK",
  /*  127 */ "ROLLUP",
  /*  128 */ "TTL",
  /*  129 */ "SMA",
  /*  130 */ "FIRST",
  /*  131 */ "LAST",
  /*  132 */ "SHOW",
  /*  133 */ "DATABASES",
  /*  134 */ "TABLES",
  /*  135 */ "STABLES",
  /*  136 */ "MNODES",
  /*  137 */ "QNODES",
  /*  138 */ "FUNCTIONS",
  /*  139 */ "INDEXES",
  /*  140 */ "ACCOUNTS",
  /*  141 */ "APPS",
  /*  142 */ "CONNECTIONS",
  /*  143 */ "LICENCES",
  /*  144 */ "GRANTS",
  /*  145 */ "QUERIES",
  /*  146 */ "SCORES",
  /*  147 */ "TOPICS",
  /*  148 */ "VARIABLES",
  /*  149 */ "CLUSTER",
  /*  150 */ "BNODES",
  /*  151 */ "SNODES",
  /*  152 */ "TRANSACTIONS",
  /*  153 */ "DISTRIBUTED",
  /*  154 */ "CONSUMERS",
  /*  155 */ "SUBSCRIPTIONS",
  /*  156 */ "VNODES",
  /*  157 */ "LIKE",
  /*  158 */ "INDEX",
  /*  159 */ "FUNCTION",
  /*  160 */ "INTERVAL",
  /*  161 */ "TOPIC",
  /*  162 */ "AS",
  /*  163 */ "WITH",
  /*  164 */ "META",
  /*  165 */ "CONSUMER",
  /*  166 */ "GROUP",
  /*  167 */ "DESC",
  /*  168 */ "DESCRIBE",
  /*  169 */ "RESET",
  /*  170 */ "QUERY",
  /*  171 */ "CACHE",
  /*  172 */ "EXPLAIN",
  /*  173 */ "ANALYZE",
  /*  174 */ "VERBOSE",
  /*  175 */ "NK_BOOL",
  /*  176 */ "RATIO",
  /*  177 */ "NK_FLOAT",
  /*  178 */ "OUTPUTTYPE",
  /*  179 */ "AGGREGATE",
  /*  180 */ "BUFSIZE",
  /*  181 */ "STREAM",
  /*  182 */ "INTO",
  /*  183 */ "TRIGGER",
  /*  184 */ "AT_ONCE",
  /*  185 */ "WINDOW_CLOSE",
  /*  186 */ "IGNORE",
  /*  187 */ "EXPIRED",
  /*  188 */ "FILL_HISTORY",
  /*  189 */ "SUBTABLE",
  /*  190 */ "KILL",
  /*  191 */ "CONNECTION",
  /*  192 */ "TRANSACTION",
  /*  193 */ "BALANCE",
  /*  194 */ "VGROUP",
  /*  195 */ "MERGE",
  /*  196 */ "REDISTRIBUTE",
  /*  197 */ "SPLIT",
  /*  198 */ "DELETE",
  /*  199 */ "INSERT",
  /*  200 */ "NULL",
  /*  201 */ "NK_QUESTION",
  /*  202 */ "NK_ARROW",
  /*  203 */ "ROWTS",
  /*  204 */ "TBNAME",
  /*  205 */ "QSTART",
  /*  206 */ "QEND",
  /*  207 */ "QDURATION",
  /*  208 */ "WSTART",
  /*  209 */ "WEND",
  /*  210 */ "WDURATION",
  /*  211 */ "IROWTS",
  /*  212 */ "QTAGS",
  /*  213 */ "CAST",
  /*  214 */ "NOW",
  /*  215 */ "TODAY",
  /*  216 */ "TIMEZONE",
  /*  217 */ "CLIENT_VERSION",
  /*  218 */ "SERVER_VERSION",
  /*  219 */ "SERVER_STATUS",
  /*  220 */ "CURRENT_USER",
  /*  221 */ "COUNT",
  /*  222 */ "LAST_ROW",
  /*  223 */ "CASE",
  /*  224 */ "END",
  /*  225 */ "WHEN",
  /*  226 */ "THEN",
  /*  227 */ "ELSE",
  /*  228 */ "BETWEEN",
  /*  229 */ "IS",
  /*  230 */ "NK_LT",
  /*  231 */ "NK_GT",
  /*  232 */ "NK_LE",
  /*  233 */ "NK_GE",
  /*  234 */ "NK_NE",
  /*  235 */ "MATCH",
  /*  236 */ "NMATCH",
  /*  237 */ "CONTAINS",
  /*  238 */ "IN",
  /*  239 */ "JOIN",
  /*  240 */ "INNER",
  /*  241 */ "SELECT",
  /*  242 */ "DISTINCT",
  /*  243 */ "WHERE",
  /*  244 */ "PARTITION",
  /*  245 */ "BY",
  /*  246 */ "SESSION",
  /*  247 */ "STATE_WINDOW",
  /*  248 */ "SLIDING",
  /*  249 */ "FILL",
  /*  250 */ "VALUE",
  /*  251 */ "NONE",
  /*  252 */ "PREV",
  /*  253 */ "LINEAR",
  /*  254 */ "NEXT",
  /*  255 */ "HAVING",
  /*  256 */ "RANGE",
  /*  257 */ "EVERY",
  /*  258 */ "ORDER",
  /*  259 */ "SLIMIT",
  /*  260 */ "SOFFSET",
  /*  261 */ "LIMIT",
  /*  262 */ "OFFSET",
  /*  263 */ "ASC",
  /*  264 */ "NULLS",
  /*  265 */ "ABORT",
  /*  266 */ "AFTER",
  /*  267 */ "ATTACH",
  /*  268 */ "BEFORE",
  /*  269 */ "BEGIN",
  /*  270 */ "BITAND",
  /*  271 */ "BITNOT",
  /*  272 */ "BITOR",
  /*  273 */ "BLOCKS",
  /*  274 */ "CHANGE",
  /*  275 */ "COMMA",
  /*  276 */ "COMPACT",
  /*  277 */ "CONCAT",
  /*  278 */ "CONFLICT",
  /*  279 */ "COPY",
  /*  280 */ "DEFERRED",
  /*  281 */ "DELIMITERS",
  /*  282 */ "DETACH",
  /*  283 */ "DIVIDE",
  /*  284 */ "DOT",
  /*  285 */ "EACH",
  /*  286 */ "FAIL",
  /*  287 */ "FILE",
  /*  288 */ "FOR",
  /*  289 */ "GLOB",
  /*  290 */ "ID",
  /*  291 */ "IMMEDIATE",
  /*  292 */ "IMPORT",
  /*  293 */ "INITIALLY",
  /*  294 */ "INSTEAD",
  /*  295 */ "ISNULL",
  /*  296 */ "KEY",
  /*  297 */ "MODULES",
  /*  298 */ "NK_BITNOT",
  /*  299 */ "NK_SEMI",
  /*  300 */ "NOTNULL",
  /*  301 */ "OF",
  /*  302 */ "PLUS",
  /*  303 */ "PRIVILEGE",
  /*  304 */ "RAISE",
  /*  305 */ "REPLACE",
  /*  306 */ "RESTRICT",
  /*  307 */ "ROW",
  /*  308 */ "SEMI",
  /*  309 */ "STAR",
  /*  310 */ "STATEMENT",
  /*  311 */ "STRING",
  /*  312 */ "TIMES",
  /*  313 */ "UPDATE",
  /*  314 */ "VALUES",
  /*  315 */ "VARIABLE",
  /*  316 */ "VIEW",
  /*  317 */ "WAL",
  /*  318 */ "cmd",
  /*  319 */ "account_options",
  /*  320 */ "alter_account_options",
  /*  321 */ "literal",
  /*  322 */ "alter_account_option",
  /*  323 */ "user_name",
  /*  324 */ "sysinfo_opt",
  /*  325 */ "privileges",
  /*  326 */ "priv_level",
  /*  327 */ "priv_type_list",
  /*  328 */ "priv_type",
  /*  329 */ "db_name",
  /*  330 */ "dnode_endpoint",
  /*  331 */ "not_exists_opt",
  /*  332 */ "db_options",
  /*  333 */ "exists_opt",
  /*  334 */ "alter_db_options",
  /*  335 */ "speed_opt",
  /*  336 */ "integer_list",
  /*  337 */ "variable_list",
  /*  338 */ "retention_list",
  /*  339 */ "alter_db_option",
  /*  340 */ "retention",
  /*  341 */ "full_table_name",
  /*  342 */ "column_def_list",
  /*  343 */ "tags_def_opt",
  /*  344 */ "table_options",
  /*  345 */ "multi_create_clause",
  /*  346 */ "tags_def",
  /*  347 */ "multi_drop_clause",
  /*  348 */ "alter_table_clause",
  /*  349 */ "alter_table_options",
  /*  350 */ "column_name",
  /*  351 */ "type_name",
  /*  352 */ "signed_literal",
  /*  353 */ "create_subtable_clause",
  /*  354 */ "specific_cols_opt",
  /*  355 */ "expression_list",
  /*  356 */ "drop_table_clause",
  /*  357 */ "col_name_list",
  /*  358 */ "table_name",
  /*  359 */ "column_def",
  /*  360 */ "duration_list",
  /*  361 */ "rollup_func_list",
  /*  362 */ "alter_table_option",
  /*  363 */ "duration_literal",
  /*  364 */ "rollup_func_name",
  /*  365 */ "function_name",
  /*  366 */ "col_name",
  /*  367 */ "db_name_cond_opt",
  /*  368 */ "like_pattern_opt",
  /*  369 */ "table_name_cond",
  /*  370 */ "from_db_opt",
  /*  371 */ "index_options",
  /*  372 */ "func_list",
  /*  373 */ "sliding_opt",
  /*  374 */ "sma_stream_opt",
  /*  375 */ "func",
  /*  376 */ "stream_options",
  /*  377 */ "topic_name",
  /*  378 */ "query_or_subquery",
  /*  379 */ "cgroup_name",
  /*  380 */ "analyze_opt",
  /*  381 */ "explain_options",
  /*  382 */ "agg_func_opt",
  /*  383 */ "bufsize_opt",
  /*  384 */ "stream_name",
  /*  385 */ "subtable_opt",
  /*  386 */ "expression",
  /*  387 */ "dnode_list",
  /*  388 */ "where_clause_opt",
  /*  389 */ "signed",
  /*  390 */ "literal_func",
  /*  391 */ "literal_list",
  /*  392 */ "table_alias",
  /*  393 */ "column_alias",
  /*  394 */ "expr_or_subquery",
  /*  395 */ "subquery",
  /*  396 */ "pseudo_column",
  /*  397 */ "column_reference",
  /*  398 */ "function_expression",
  /*  399 */ "case_when_expression",
  /*  400 */ "star_func",
  /*  401 */ "star_func_para_list",
  /*  402 */ "noarg_func",
  /*  403 */ "other_para_list",
  /*  404 */ "star_func_para",
  /*  405 */ "when_then_list",
  /*  406 */ "case_when_else_opt",
  /*  407 */ "common_expression",
  /*  408 */ "when_then_expr",
  /*  409 */ "predicate",
  /*  410 */ "compare_op",
  /*  411 */ "in_op",
  /*  412 */ "in_predicate_value",
  /*  413 */ "boolean_value_expression",
  /*  414 */ "boolean_primary",
  /*  415 */ "from_clause_opt",
  /*  416 */ "table_reference_list",
  /*  417 */ "table_reference",
  /*  418 */ "table_primary",
  /*  419 */ "joined_table",
  /*  420 */ "alias_opt",
  /*  421 */ "parenthesized_joined_table",
  /*  422 */ "join_type",
  /*  423 */ "search_condition",
  /*  424 */ "query_specification",
  /*  425 */ "set_quantifier_opt",
  /*  426 */ "select_list",
  /*  427 */ "partition_by_clause_opt",
  /*  428 */ "range_opt",
  /*  429 */ "every_opt",
  /*  430 */ "fill_opt",
  /*  431 */ "twindow_clause_opt",
  /*  432 */ "group_by_clause_opt",
  /*  433 */ "having_clause_opt",
  /*  434 */ "select_item",
  /*  435 */ "partition_list",
  /*  436 */ "partition_item",
  /*  437 */ "fill_mode",
  /*  438 */ "group_by_list",
  /*  439 */ "query_expression",
  /*  440 */ "query_simple",
  /*  441 */ "order_by_clause_opt",
  /*  442 */ "slimit_clause_opt",
  /*  443 */ "limit_clause_opt",
  /*  444 */ "union_query_expression",
  /*  445 */ "query_simple_or_subquery",
  /*  446 */ "sort_specification_list",
  /*  447 */ "sort_specification",
  /*  448 */ "ordering_specification_opt",
  /*  449 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  68 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  69 */ "not_exists_opt ::=",
 /*  70 */ "exists_opt ::= IF EXISTS",
 /*  71 */ "exists_opt ::=",
 /*  72 */ "db_options ::=",
 /*  73 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  75 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  76 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  78 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  79 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  80 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options KEEP integer_list",
 /*  82 */ "db_options ::= db_options KEEP variable_list",
 /*  83 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  84 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  85 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  86 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  87 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  88 */ "db_options ::= db_options STRICT NK_STRING",
 /*  89 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  90 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  91 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  92 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  93 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  94 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  95 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 102 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 103 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 104 */ "alter_db_options ::= alter_db_option",
 /* 105 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 106 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 107 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 108 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 109 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 110 */ "alter_db_option ::= KEEP integer_list",
 /* 111 */ "alter_db_option ::= KEEP variable_list",
 /* 112 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 113 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 114 */ "alter_db_option ::= STRICT NK_STRING",
 /* 115 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 116 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 117 */ "integer_list ::= NK_INTEGER",
 /* 118 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 119 */ "variable_list ::= NK_VARIABLE",
 /* 120 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 121 */ "retention_list ::= retention",
 /* 122 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 123 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 124 */ "speed_opt ::=",
 /* 125 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 126 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 127 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 128 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 129 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 130 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 131 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 132 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 133 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 134 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 135 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 136 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 138 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 140 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 142 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 143 */ "multi_create_clause ::= create_subtable_clause",
 /* 144 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 145 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 146 */ "multi_drop_clause ::= drop_table_clause",
 /* 147 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 148 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 149 */ "specific_cols_opt ::=",
 /* 150 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 151 */ "full_table_name ::= table_name",
 /* 152 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 153 */ "column_def_list ::= column_def",
 /* 154 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 155 */ "column_def ::= column_name type_name",
 /* 156 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 157 */ "type_name ::= BOOL",
 /* 158 */ "type_name ::= TINYINT",
 /* 159 */ "type_name ::= SMALLINT",
 /* 160 */ "type_name ::= INT",
 /* 161 */ "type_name ::= INTEGER",
 /* 162 */ "type_name ::= BIGINT",
 /* 163 */ "type_name ::= FLOAT",
 /* 164 */ "type_name ::= DOUBLE",
 /* 165 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 166 */ "type_name ::= TIMESTAMP",
 /* 167 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= TINYINT UNSIGNED",
 /* 169 */ "type_name ::= SMALLINT UNSIGNED",
 /* 170 */ "type_name ::= INT UNSIGNED",
 /* 171 */ "type_name ::= BIGINT UNSIGNED",
 /* 172 */ "type_name ::= JSON",
 /* 173 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 174 */ "type_name ::= MEDIUMBLOB",
 /* 175 */ "type_name ::= BLOB",
 /* 176 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 177 */ "type_name ::= DECIMAL",
 /* 178 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 180 */ "tags_def_opt ::=",
 /* 181 */ "tags_def_opt ::= tags_def",
 /* 182 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 183 */ "table_options ::=",
 /* 184 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 185 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 186 */ "table_options ::= table_options WATERMARK duration_list",
 /* 187 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 188 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 189 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 190 */ "alter_table_options ::= alter_table_option",
 /* 191 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 192 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 193 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 194 */ "duration_list ::= duration_literal",
 /* 195 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 196 */ "rollup_func_list ::= rollup_func_name",
 /* 197 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 198 */ "rollup_func_name ::= function_name",
 /* 199 */ "rollup_func_name ::= FIRST",
 /* 200 */ "rollup_func_name ::= LAST",
 /* 201 */ "col_name_list ::= col_name",
 /* 202 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 203 */ "col_name ::= column_name",
 /* 204 */ "cmd ::= SHOW DNODES",
 /* 205 */ "cmd ::= SHOW USERS",
 /* 206 */ "cmd ::= SHOW DATABASES",
 /* 207 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 208 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 209 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 210 */ "cmd ::= SHOW MNODES",
 /* 211 */ "cmd ::= SHOW QNODES",
 /* 212 */ "cmd ::= SHOW FUNCTIONS",
 /* 213 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 214 */ "cmd ::= SHOW STREAMS",
 /* 215 */ "cmd ::= SHOW ACCOUNTS",
 /* 216 */ "cmd ::= SHOW APPS",
 /* 217 */ "cmd ::= SHOW CONNECTIONS",
 /* 218 */ "cmd ::= SHOW LICENCES",
 /* 219 */ "cmd ::= SHOW GRANTS",
 /* 220 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 221 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 222 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 223 */ "cmd ::= SHOW QUERIES",
 /* 224 */ "cmd ::= SHOW SCORES",
 /* 225 */ "cmd ::= SHOW TOPICS",
 /* 226 */ "cmd ::= SHOW VARIABLES",
 /* 227 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 228 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 229 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 230 */ "cmd ::= SHOW BNODES",
 /* 231 */ "cmd ::= SHOW SNODES",
 /* 232 */ "cmd ::= SHOW CLUSTER",
 /* 233 */ "cmd ::= SHOW TRANSACTIONS",
 /* 234 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 235 */ "cmd ::= SHOW CONSUMERS",
 /* 236 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 237 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 238 */ "cmd ::= SHOW TABLE TAGS FROM table_name_cond from_db_opt",
 /* 239 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 240 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 241 */ "db_name_cond_opt ::=",
 /* 242 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 243 */ "like_pattern_opt ::=",
 /* 244 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 245 */ "table_name_cond ::= table_name",
 /* 246 */ "from_db_opt ::=",
 /* 247 */ "from_db_opt ::= FROM db_name",
 /* 248 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 249 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 250 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 251 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 252 */ "func_list ::= func",
 /* 253 */ "func_list ::= func_list NK_COMMA func",
 /* 254 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 255 */ "sma_stream_opt ::=",
 /* 256 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 257 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 258 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 259 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 260 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 261 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 262 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 263 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 264 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 265 */ "cmd ::= DESC full_table_name",
 /* 266 */ "cmd ::= DESCRIBE full_table_name",
 /* 267 */ "cmd ::= RESET QUERY CACHE",
 /* 268 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 269 */ "analyze_opt ::=",
 /* 270 */ "analyze_opt ::= ANALYZE",
 /* 271 */ "explain_options ::=",
 /* 272 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 273 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 274 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 275 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 276 */ "agg_func_opt ::=",
 /* 277 */ "agg_func_opt ::= AGGREGATE",
 /* 278 */ "bufsize_opt ::=",
 /* 279 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 280 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 281 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 282 */ "stream_options ::=",
 /* 283 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 284 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 285 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 286 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 287 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 288 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 289 */ "subtable_opt ::=",
 /* 290 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 291 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 292 */ "cmd ::= KILL QUERY NK_STRING",
 /* 293 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 294 */ "cmd ::= BALANCE VGROUP",
 /* 295 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 296 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 297 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 298 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 299 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 300 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 301 */ "cmd ::= query_or_subquery",
 /* 302 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 303 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 304 */ "literal ::= NK_INTEGER",
 /* 305 */ "literal ::= NK_FLOAT",
 /* 306 */ "literal ::= NK_STRING",
 /* 307 */ "literal ::= NK_BOOL",
 /* 308 */ "literal ::= TIMESTAMP NK_STRING",
 /* 309 */ "literal ::= duration_literal",
 /* 310 */ "literal ::= NULL",
 /* 311 */ "literal ::= NK_QUESTION",
 /* 312 */ "duration_literal ::= NK_VARIABLE",
 /* 313 */ "signed ::= NK_INTEGER",
 /* 314 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 315 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 316 */ "signed ::= NK_FLOAT",
 /* 317 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 318 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 319 */ "signed_literal ::= signed",
 /* 320 */ "signed_literal ::= NK_STRING",
 /* 321 */ "signed_literal ::= NK_BOOL",
 /* 322 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 323 */ "signed_literal ::= duration_literal",
 /* 324 */ "signed_literal ::= NULL",
 /* 325 */ "signed_literal ::= literal_func",
 /* 326 */ "signed_literal ::= NK_QUESTION",
 /* 327 */ "literal_list ::= signed_literal",
 /* 328 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 329 */ "db_name ::= NK_ID",
 /* 330 */ "table_name ::= NK_ID",
 /* 331 */ "column_name ::= NK_ID",
 /* 332 */ "function_name ::= NK_ID",
 /* 333 */ "table_alias ::= NK_ID",
 /* 334 */ "column_alias ::= NK_ID",
 /* 335 */ "user_name ::= NK_ID",
 /* 336 */ "topic_name ::= NK_ID",
 /* 337 */ "stream_name ::= NK_ID",
 /* 338 */ "cgroup_name ::= NK_ID",
 /* 339 */ "expr_or_subquery ::= expression",
 /* 340 */ "expr_or_subquery ::= subquery",
 /* 341 */ "expression ::= literal",
 /* 342 */ "expression ::= pseudo_column",
 /* 343 */ "expression ::= column_reference",
 /* 344 */ "expression ::= function_expression",
 /* 345 */ "expression ::= case_when_expression",
 /* 346 */ "expression ::= NK_LP expression NK_RP",
 /* 347 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 348 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 349 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 350 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 351 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 352 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 353 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 354 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 355 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 356 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 357 */ "expression_list ::= expr_or_subquery",
 /* 358 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 359 */ "column_reference ::= column_name",
 /* 360 */ "column_reference ::= table_name NK_DOT column_name",
 /* 361 */ "pseudo_column ::= ROWTS",
 /* 362 */ "pseudo_column ::= TBNAME",
 /* 363 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 364 */ "pseudo_column ::= QSTART",
 /* 365 */ "pseudo_column ::= QEND",
 /* 366 */ "pseudo_column ::= QDURATION",
 /* 367 */ "pseudo_column ::= WSTART",
 /* 368 */ "pseudo_column ::= WEND",
 /* 369 */ "pseudo_column ::= WDURATION",
 /* 370 */ "pseudo_column ::= IROWTS",
 /* 371 */ "pseudo_column ::= QTAGS",
 /* 372 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 373 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 374 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 375 */ "function_expression ::= literal_func",
 /* 376 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 377 */ "literal_func ::= NOW",
 /* 378 */ "noarg_func ::= NOW",
 /* 379 */ "noarg_func ::= TODAY",
 /* 380 */ "noarg_func ::= TIMEZONE",
 /* 381 */ "noarg_func ::= DATABASE",
 /* 382 */ "noarg_func ::= CLIENT_VERSION",
 /* 383 */ "noarg_func ::= SERVER_VERSION",
 /* 384 */ "noarg_func ::= SERVER_STATUS",
 /* 385 */ "noarg_func ::= CURRENT_USER",
 /* 386 */ "noarg_func ::= USER",
 /* 387 */ "star_func ::= COUNT",
 /* 388 */ "star_func ::= FIRST",
 /* 389 */ "star_func ::= LAST",
 /* 390 */ "star_func ::= LAST_ROW",
 /* 391 */ "star_func_para_list ::= NK_STAR",
 /* 392 */ "star_func_para_list ::= other_para_list",
 /* 393 */ "other_para_list ::= star_func_para",
 /* 394 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 395 */ "star_func_para ::= expr_or_subquery",
 /* 396 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 397 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 398 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 399 */ "when_then_list ::= when_then_expr",
 /* 400 */ "when_then_list ::= when_then_list when_then_expr",
 /* 401 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 402 */ "case_when_else_opt ::=",
 /* 403 */ "case_when_else_opt ::= ELSE common_expression",
 /* 404 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 405 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 406 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 407 */ "predicate ::= expr_or_subquery IS NULL",
 /* 408 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 409 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 410 */ "compare_op ::= NK_LT",
 /* 411 */ "compare_op ::= NK_GT",
 /* 412 */ "compare_op ::= NK_LE",
 /* 413 */ "compare_op ::= NK_GE",
 /* 414 */ "compare_op ::= NK_NE",
 /* 415 */ "compare_op ::= NK_EQ",
 /* 416 */ "compare_op ::= LIKE",
 /* 417 */ "compare_op ::= NOT LIKE",
 /* 418 */ "compare_op ::= MATCH",
 /* 419 */ "compare_op ::= NMATCH",
 /* 420 */ "compare_op ::= CONTAINS",
 /* 421 */ "in_op ::= IN",
 /* 422 */ "in_op ::= NOT IN",
 /* 423 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 424 */ "boolean_value_expression ::= boolean_primary",
 /* 425 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 426 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 427 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 428 */ "boolean_primary ::= predicate",
 /* 429 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 430 */ "common_expression ::= expr_or_subquery",
 /* 431 */ "common_expression ::= boolean_value_expression",
 /* 432 */ "from_clause_opt ::=",
 /* 433 */ "from_clause_opt ::= FROM table_reference_list",
 /* 434 */ "table_reference_list ::= table_reference",
 /* 435 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 436 */ "table_reference ::= table_primary",
 /* 437 */ "table_reference ::= joined_table",
 /* 438 */ "table_primary ::= table_name alias_opt",
 /* 439 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 440 */ "table_primary ::= subquery alias_opt",
 /* 441 */ "table_primary ::= parenthesized_joined_table",
 /* 442 */ "alias_opt ::=",
 /* 443 */ "alias_opt ::= table_alias",
 /* 444 */ "alias_opt ::= AS table_alias",
 /* 445 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 446 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 447 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 448 */ "join_type ::=",
 /* 449 */ "join_type ::= INNER",
 /* 450 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 451 */ "set_quantifier_opt ::=",
 /* 452 */ "set_quantifier_opt ::= DISTINCT",
 /* 453 */ "set_quantifier_opt ::= ALL",
 /* 454 */ "select_list ::= select_item",
 /* 455 */ "select_list ::= select_list NK_COMMA select_item",
 /* 456 */ "select_item ::= NK_STAR",
 /* 457 */ "select_item ::= common_expression",
 /* 458 */ "select_item ::= common_expression column_alias",
 /* 459 */ "select_item ::= common_expression AS column_alias",
 /* 460 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 461 */ "where_clause_opt ::=",
 /* 462 */ "where_clause_opt ::= WHERE search_condition",
 /* 463 */ "partition_by_clause_opt ::=",
 /* 464 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 465 */ "partition_list ::= partition_item",
 /* 466 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 467 */ "partition_item ::= expr_or_subquery",
 /* 468 */ "partition_item ::= expr_or_subquery column_alias",
 /* 469 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 470 */ "twindow_clause_opt ::=",
 /* 471 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 472 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 473 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 474 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 475 */ "sliding_opt ::=",
 /* 476 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 477 */ "fill_opt ::=",
 /* 478 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 479 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 480 */ "fill_mode ::= NONE",
 /* 481 */ "fill_mode ::= PREV",
 /* 482 */ "fill_mode ::= NULL",
 /* 483 */ "fill_mode ::= LINEAR",
 /* 484 */ "fill_mode ::= NEXT",
 /* 485 */ "group_by_clause_opt ::=",
 /* 486 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 487 */ "group_by_list ::= expr_or_subquery",
 /* 488 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 489 */ "having_clause_opt ::=",
 /* 490 */ "having_clause_opt ::= HAVING search_condition",
 /* 491 */ "range_opt ::=",
 /* 492 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 493 */ "every_opt ::=",
 /* 494 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 495 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 496 */ "query_simple ::= query_specification",
 /* 497 */ "query_simple ::= union_query_expression",
 /* 498 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 499 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 500 */ "query_simple_or_subquery ::= query_simple",
 /* 501 */ "query_simple_or_subquery ::= subquery",
 /* 502 */ "query_or_subquery ::= query_expression",
 /* 503 */ "query_or_subquery ::= subquery",
 /* 504 */ "order_by_clause_opt ::=",
 /* 505 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 506 */ "slimit_clause_opt ::=",
 /* 507 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 508 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 509 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 510 */ "limit_clause_opt ::=",
 /* 511 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 512 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 513 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 514 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 515 */ "subquery ::= NK_LP subquery NK_RP",
 /* 516 */ "search_condition ::= common_expression",
 /* 517 */ "sort_specification_list ::= sort_specification",
 /* 518 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 519 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 520 */ "ordering_specification_opt ::=",
 /* 521 */ "ordering_specification_opt ::= ASC",
 /* 522 */ "ordering_specification_opt ::= DESC",
 /* 523 */ "null_ordering_opt ::=",
 /* 524 */ "null_ordering_opt ::= NULLS FIRST",
 /* 525 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 318: /* cmd */
    case 321: /* literal */
    case 332: /* db_options */
    case 334: /* alter_db_options */
    case 340: /* retention */
    case 341: /* full_table_name */
    case 344: /* table_options */
    case 348: /* alter_table_clause */
    case 349: /* alter_table_options */
    case 352: /* signed_literal */
    case 353: /* create_subtable_clause */
    case 356: /* drop_table_clause */
    case 359: /* column_def */
    case 363: /* duration_literal */
    case 364: /* rollup_func_name */
    case 366: /* col_name */
    case 367: /* db_name_cond_opt */
    case 368: /* like_pattern_opt */
    case 369: /* table_name_cond */
    case 370: /* from_db_opt */
    case 371: /* index_options */
    case 373: /* sliding_opt */
    case 374: /* sma_stream_opt */
    case 375: /* func */
    case 376: /* stream_options */
    case 378: /* query_or_subquery */
    case 381: /* explain_options */
    case 385: /* subtable_opt */
    case 386: /* expression */
    case 388: /* where_clause_opt */
    case 389: /* signed */
    case 390: /* literal_func */
    case 394: /* expr_or_subquery */
    case 395: /* subquery */
    case 396: /* pseudo_column */
    case 397: /* column_reference */
    case 398: /* function_expression */
    case 399: /* case_when_expression */
    case 404: /* star_func_para */
    case 406: /* case_when_else_opt */
    case 407: /* common_expression */
    case 408: /* when_then_expr */
    case 409: /* predicate */
    case 412: /* in_predicate_value */
    case 413: /* boolean_value_expression */
    case 414: /* boolean_primary */
    case 415: /* from_clause_opt */
    case 416: /* table_reference_list */
    case 417: /* table_reference */
    case 418: /* table_primary */
    case 419: /* joined_table */
    case 421: /* parenthesized_joined_table */
    case 423: /* search_condition */
    case 424: /* query_specification */
    case 428: /* range_opt */
    case 429: /* every_opt */
    case 430: /* fill_opt */
    case 431: /* twindow_clause_opt */
    case 433: /* having_clause_opt */
    case 434: /* select_item */
    case 436: /* partition_item */
    case 439: /* query_expression */
    case 440: /* query_simple */
    case 442: /* slimit_clause_opt */
    case 443: /* limit_clause_opt */
    case 444: /* union_query_expression */
    case 445: /* query_simple_or_subquery */
    case 447: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy812)); 
}
      break;
    case 319: /* account_options */
    case 320: /* alter_account_options */
    case 322: /* alter_account_option */
    case 335: /* speed_opt */
    case 383: /* bufsize_opt */
{
 
}
      break;
    case 323: /* user_name */
    case 326: /* priv_level */
    case 329: /* db_name */
    case 330: /* dnode_endpoint */
    case 350: /* column_name */
    case 358: /* table_name */
    case 365: /* function_name */
    case 377: /* topic_name */
    case 379: /* cgroup_name */
    case 384: /* stream_name */
    case 392: /* table_alias */
    case 393: /* column_alias */
    case 400: /* star_func */
    case 402: /* noarg_func */
    case 420: /* alias_opt */
{
 
}
      break;
    case 324: /* sysinfo_opt */
{
 
}
      break;
    case 325: /* privileges */
    case 327: /* priv_type_list */
    case 328: /* priv_type */
{
 
}
      break;
    case 331: /* not_exists_opt */
    case 333: /* exists_opt */
    case 380: /* analyze_opt */
    case 382: /* agg_func_opt */
    case 425: /* set_quantifier_opt */
{
 
}
      break;
    case 336: /* integer_list */
    case 337: /* variable_list */
    case 338: /* retention_list */
    case 342: /* column_def_list */
    case 343: /* tags_def_opt */
    case 345: /* multi_create_clause */
    case 346: /* tags_def */
    case 347: /* multi_drop_clause */
    case 354: /* specific_cols_opt */
    case 355: /* expression_list */
    case 357: /* col_name_list */
    case 360: /* duration_list */
    case 361: /* rollup_func_list */
    case 372: /* func_list */
    case 387: /* dnode_list */
    case 391: /* literal_list */
    case 401: /* star_func_para_list */
    case 403: /* other_para_list */
    case 405: /* when_then_list */
    case 426: /* select_list */
    case 427: /* partition_by_clause_opt */
    case 432: /* group_by_clause_opt */
    case 435: /* partition_list */
    case 438: /* group_by_list */
    case 441: /* order_by_clause_opt */
    case 446: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy424)); 
}
      break;
    case 339: /* alter_db_option */
    case 362: /* alter_table_option */
{
 
}
      break;
    case 351: /* type_name */
{
 
}
      break;
    case 410: /* compare_op */
    case 411: /* in_op */
{
 
}
      break;
    case 422: /* join_type */
{
 
}
      break;
    case 437: /* fill_mode */
{
 
}
      break;
    case 448: /* ordering_specification_opt */
{
 
}
      break;
    case 449: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  318,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  318,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  319,    0 }, /* (2) account_options ::= */
  {  319,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  319,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  319,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  319,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  319,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  319,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  319,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  319,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  319,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  320,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  320,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  322,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  322,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  322,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  322,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  322,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  322,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  322,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  322,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  322,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  322,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  318,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  318,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  318,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  318,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  318,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  324,    0 }, /* (29) sysinfo_opt ::= */
  {  324,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  318,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  318,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  325,   -1 }, /* (33) privileges ::= ALL */
  {  325,   -1 }, /* (34) privileges ::= priv_type_list */
  {  327,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  327,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  328,   -1 }, /* (37) priv_type ::= READ */
  {  328,   -1 }, /* (38) priv_type ::= WRITE */
  {  326,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  326,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  318,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  318,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  318,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  318,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  318,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  318,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  318,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  318,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  330,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  330,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  330,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  318,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  318,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  318,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  318,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  318,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  318,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  318,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  318,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  318,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  318,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  318,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  318,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  318,   -2 }, /* (64) cmd ::= USE db_name */
  {  318,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  318,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  318,   -4 }, /* (67) cmd ::= TRIM DATABASE db_name speed_opt */
  {  331,   -3 }, /* (68) not_exists_opt ::= IF NOT EXISTS */
  {  331,    0 }, /* (69) not_exists_opt ::= */
  {  333,   -2 }, /* (70) exists_opt ::= IF EXISTS */
  {  333,    0 }, /* (71) exists_opt ::= */
  {  332,    0 }, /* (72) db_options ::= */
  {  332,   -3 }, /* (73) db_options ::= db_options BUFFER NK_INTEGER */
  {  332,   -3 }, /* (74) db_options ::= db_options CACHEMODEL NK_STRING */
  {  332,   -3 }, /* (75) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  332,   -3 }, /* (76) db_options ::= db_options COMP NK_INTEGER */
  {  332,   -3 }, /* (77) db_options ::= db_options DURATION NK_INTEGER */
  {  332,   -3 }, /* (78) db_options ::= db_options DURATION NK_VARIABLE */
  {  332,   -3 }, /* (79) db_options ::= db_options MAXROWS NK_INTEGER */
  {  332,   -3 }, /* (80) db_options ::= db_options MINROWS NK_INTEGER */
  {  332,   -3 }, /* (81) db_options ::= db_options KEEP integer_list */
  {  332,   -3 }, /* (82) db_options ::= db_options KEEP variable_list */
  {  332,   -3 }, /* (83) db_options ::= db_options PAGES NK_INTEGER */
  {  332,   -3 }, /* (84) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  332,   -3 }, /* (85) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  332,   -3 }, /* (86) db_options ::= db_options PRECISION NK_STRING */
  {  332,   -3 }, /* (87) db_options ::= db_options REPLICA NK_INTEGER */
  {  332,   -3 }, /* (88) db_options ::= db_options STRICT NK_STRING */
  {  332,   -3 }, /* (89) db_options ::= db_options VGROUPS NK_INTEGER */
  {  332,   -3 }, /* (90) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  332,   -3 }, /* (91) db_options ::= db_options RETENTIONS retention_list */
  {  332,   -3 }, /* (92) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  332,   -3 }, /* (93) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  332,   -3 }, /* (94) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  332,   -3 }, /* (95) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  332,   -4 }, /* (96) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  332,   -3 }, /* (97) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  332,   -4 }, /* (98) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  332,   -3 }, /* (99) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  332,   -3 }, /* (100) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  332,   -3 }, /* (101) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  332,   -3 }, /* (102) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  332,   -3 }, /* (103) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  334,   -1 }, /* (104) alter_db_options ::= alter_db_option */
  {  334,   -2 }, /* (105) alter_db_options ::= alter_db_options alter_db_option */
  {  339,   -2 }, /* (106) alter_db_option ::= BUFFER NK_INTEGER */
  {  339,   -2 }, /* (107) alter_db_option ::= CACHEMODEL NK_STRING */
  {  339,   -2 }, /* (108) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  339,   -2 }, /* (109) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  339,   -2 }, /* (110) alter_db_option ::= KEEP integer_list */
  {  339,   -2 }, /* (111) alter_db_option ::= KEEP variable_list */
  {  339,   -2 }, /* (112) alter_db_option ::= PAGES NK_INTEGER */
  {  339,   -2 }, /* (113) alter_db_option ::= REPLICA NK_INTEGER */
  {  339,   -2 }, /* (114) alter_db_option ::= STRICT NK_STRING */
  {  339,   -2 }, /* (115) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  339,   -2 }, /* (116) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  336,   -1 }, /* (117) integer_list ::= NK_INTEGER */
  {  336,   -3 }, /* (118) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  337,   -1 }, /* (119) variable_list ::= NK_VARIABLE */
  {  337,   -3 }, /* (120) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  338,   -1 }, /* (121) retention_list ::= retention */
  {  338,   -3 }, /* (122) retention_list ::= retention_list NK_COMMA retention */
  {  340,   -3 }, /* (123) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  335,    0 }, /* (124) speed_opt ::= */
  {  335,   -2 }, /* (125) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  318,   -9 }, /* (126) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  318,   -3 }, /* (127) cmd ::= CREATE TABLE multi_create_clause */
  {  318,   -9 }, /* (128) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  318,   -3 }, /* (129) cmd ::= DROP TABLE multi_drop_clause */
  {  318,   -4 }, /* (130) cmd ::= DROP STABLE exists_opt full_table_name */
  {  318,   -3 }, /* (131) cmd ::= ALTER TABLE alter_table_clause */
  {  318,   -3 }, /* (132) cmd ::= ALTER STABLE alter_table_clause */
  {  348,   -2 }, /* (133) alter_table_clause ::= full_table_name alter_table_options */
  {  348,   -5 }, /* (134) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  348,   -4 }, /* (135) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  348,   -5 }, /* (136) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  348,   -5 }, /* (137) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  348,   -5 }, /* (138) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  348,   -4 }, /* (139) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  348,   -5 }, /* (140) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  348,   -5 }, /* (141) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  348,   -6 }, /* (142) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  345,   -1 }, /* (143) multi_create_clause ::= create_subtable_clause */
  {  345,   -2 }, /* (144) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  353,  -10 }, /* (145) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  347,   -1 }, /* (146) multi_drop_clause ::= drop_table_clause */
  {  347,   -2 }, /* (147) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  356,   -2 }, /* (148) drop_table_clause ::= exists_opt full_table_name */
  {  354,    0 }, /* (149) specific_cols_opt ::= */
  {  354,   -3 }, /* (150) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  341,   -1 }, /* (151) full_table_name ::= table_name */
  {  341,   -3 }, /* (152) full_table_name ::= db_name NK_DOT table_name */
  {  342,   -1 }, /* (153) column_def_list ::= column_def */
  {  342,   -3 }, /* (154) column_def_list ::= column_def_list NK_COMMA column_def */
  {  359,   -2 }, /* (155) column_def ::= column_name type_name */
  {  359,   -4 }, /* (156) column_def ::= column_name type_name COMMENT NK_STRING */
  {  351,   -1 }, /* (157) type_name ::= BOOL */
  {  351,   -1 }, /* (158) type_name ::= TINYINT */
  {  351,   -1 }, /* (159) type_name ::= SMALLINT */
  {  351,   -1 }, /* (160) type_name ::= INT */
  {  351,   -1 }, /* (161) type_name ::= INTEGER */
  {  351,   -1 }, /* (162) type_name ::= BIGINT */
  {  351,   -1 }, /* (163) type_name ::= FLOAT */
  {  351,   -1 }, /* (164) type_name ::= DOUBLE */
  {  351,   -4 }, /* (165) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  351,   -1 }, /* (166) type_name ::= TIMESTAMP */
  {  351,   -4 }, /* (167) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  351,   -2 }, /* (168) type_name ::= TINYINT UNSIGNED */
  {  351,   -2 }, /* (169) type_name ::= SMALLINT UNSIGNED */
  {  351,   -2 }, /* (170) type_name ::= INT UNSIGNED */
  {  351,   -2 }, /* (171) type_name ::= BIGINT UNSIGNED */
  {  351,   -1 }, /* (172) type_name ::= JSON */
  {  351,   -4 }, /* (173) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  351,   -1 }, /* (174) type_name ::= MEDIUMBLOB */
  {  351,   -1 }, /* (175) type_name ::= BLOB */
  {  351,   -4 }, /* (176) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  351,   -1 }, /* (177) type_name ::= DECIMAL */
  {  351,   -4 }, /* (178) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  351,   -6 }, /* (179) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  343,    0 }, /* (180) tags_def_opt ::= */
  {  343,   -1 }, /* (181) tags_def_opt ::= tags_def */
  {  346,   -4 }, /* (182) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  344,    0 }, /* (183) table_options ::= */
  {  344,   -3 }, /* (184) table_options ::= table_options COMMENT NK_STRING */
  {  344,   -3 }, /* (185) table_options ::= table_options MAX_DELAY duration_list */
  {  344,   -3 }, /* (186) table_options ::= table_options WATERMARK duration_list */
  {  344,   -5 }, /* (187) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  344,   -3 }, /* (188) table_options ::= table_options TTL NK_INTEGER */
  {  344,   -5 }, /* (189) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  349,   -1 }, /* (190) alter_table_options ::= alter_table_option */
  {  349,   -2 }, /* (191) alter_table_options ::= alter_table_options alter_table_option */
  {  362,   -2 }, /* (192) alter_table_option ::= COMMENT NK_STRING */
  {  362,   -2 }, /* (193) alter_table_option ::= TTL NK_INTEGER */
  {  360,   -1 }, /* (194) duration_list ::= duration_literal */
  {  360,   -3 }, /* (195) duration_list ::= duration_list NK_COMMA duration_literal */
  {  361,   -1 }, /* (196) rollup_func_list ::= rollup_func_name */
  {  361,   -3 }, /* (197) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  364,   -1 }, /* (198) rollup_func_name ::= function_name */
  {  364,   -1 }, /* (199) rollup_func_name ::= FIRST */
  {  364,   -1 }, /* (200) rollup_func_name ::= LAST */
  {  357,   -1 }, /* (201) col_name_list ::= col_name */
  {  357,   -3 }, /* (202) col_name_list ::= col_name_list NK_COMMA col_name */
  {  366,   -1 }, /* (203) col_name ::= column_name */
  {  318,   -2 }, /* (204) cmd ::= SHOW DNODES */
  {  318,   -2 }, /* (205) cmd ::= SHOW USERS */
  {  318,   -2 }, /* (206) cmd ::= SHOW DATABASES */
  {  318,   -4 }, /* (207) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  318,   -4 }, /* (208) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  318,   -3 }, /* (209) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  318,   -2 }, /* (210) cmd ::= SHOW MNODES */
  {  318,   -2 }, /* (211) cmd ::= SHOW QNODES */
  {  318,   -2 }, /* (212) cmd ::= SHOW FUNCTIONS */
  {  318,   -5 }, /* (213) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  318,   -2 }, /* (214) cmd ::= SHOW STREAMS */
  {  318,   -2 }, /* (215) cmd ::= SHOW ACCOUNTS */
  {  318,   -2 }, /* (216) cmd ::= SHOW APPS */
  {  318,   -2 }, /* (217) cmd ::= SHOW CONNECTIONS */
  {  318,   -2 }, /* (218) cmd ::= SHOW LICENCES */
  {  318,   -2 }, /* (219) cmd ::= SHOW GRANTS */
  {  318,   -4 }, /* (220) cmd ::= SHOW CREATE DATABASE db_name */
  {  318,   -4 }, /* (221) cmd ::= SHOW CREATE TABLE full_table_name */
  {  318,   -4 }, /* (222) cmd ::= SHOW CREATE STABLE full_table_name */
  {  318,   -2 }, /* (223) cmd ::= SHOW QUERIES */
  {  318,   -2 }, /* (224) cmd ::= SHOW SCORES */
  {  318,   -2 }, /* (225) cmd ::= SHOW TOPICS */
  {  318,   -2 }, /* (226) cmd ::= SHOW VARIABLES */
  {  318,   -3 }, /* (227) cmd ::= SHOW CLUSTER VARIABLES */
  {  318,   -3 }, /* (228) cmd ::= SHOW LOCAL VARIABLES */
  {  318,   -5 }, /* (229) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  318,   -2 }, /* (230) cmd ::= SHOW BNODES */
  {  318,   -2 }, /* (231) cmd ::= SHOW SNODES */
  {  318,   -2 }, /* (232) cmd ::= SHOW CLUSTER */
  {  318,   -2 }, /* (233) cmd ::= SHOW TRANSACTIONS */
  {  318,   -4 }, /* (234) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  318,   -2 }, /* (235) cmd ::= SHOW CONSUMERS */
  {  318,   -2 }, /* (236) cmd ::= SHOW SUBSCRIPTIONS */
  {  318,   -5 }, /* (237) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  318,   -6 }, /* (238) cmd ::= SHOW TABLE TAGS FROM table_name_cond from_db_opt */
  {  318,   -3 }, /* (239) cmd ::= SHOW VNODES NK_INTEGER */
  {  318,   -3 }, /* (240) cmd ::= SHOW VNODES NK_STRING */
  {  367,    0 }, /* (241) db_name_cond_opt ::= */
  {  367,   -2 }, /* (242) db_name_cond_opt ::= db_name NK_DOT */
  {  368,    0 }, /* (243) like_pattern_opt ::= */
  {  368,   -2 }, /* (244) like_pattern_opt ::= LIKE NK_STRING */
  {  369,   -1 }, /* (245) table_name_cond ::= table_name */
  {  370,    0 }, /* (246) from_db_opt ::= */
  {  370,   -2 }, /* (247) from_db_opt ::= FROM db_name */
  {  318,   -8 }, /* (248) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  318,   -4 }, /* (249) cmd ::= DROP INDEX exists_opt full_table_name */
  {  371,  -10 }, /* (250) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  371,  -12 }, /* (251) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  372,   -1 }, /* (252) func_list ::= func */
  {  372,   -3 }, /* (253) func_list ::= func_list NK_COMMA func */
  {  375,   -4 }, /* (254) func ::= function_name NK_LP expression_list NK_RP */
  {  374,    0 }, /* (255) sma_stream_opt ::= */
  {  374,   -3 }, /* (256) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  374,   -3 }, /* (257) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  318,   -6 }, /* (258) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  318,   -7 }, /* (259) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  318,   -9 }, /* (260) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  318,   -7 }, /* (261) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  318,   -9 }, /* (262) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  318,   -4 }, /* (263) cmd ::= DROP TOPIC exists_opt topic_name */
  {  318,   -7 }, /* (264) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  318,   -2 }, /* (265) cmd ::= DESC full_table_name */
  {  318,   -2 }, /* (266) cmd ::= DESCRIBE full_table_name */
  {  318,   -3 }, /* (267) cmd ::= RESET QUERY CACHE */
  {  318,   -4 }, /* (268) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  380,    0 }, /* (269) analyze_opt ::= */
  {  380,   -1 }, /* (270) analyze_opt ::= ANALYZE */
  {  381,    0 }, /* (271) explain_options ::= */
  {  381,   -3 }, /* (272) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  381,   -3 }, /* (273) explain_options ::= explain_options RATIO NK_FLOAT */
  {  318,  -10 }, /* (274) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  318,   -4 }, /* (275) cmd ::= DROP FUNCTION exists_opt function_name */
  {  382,    0 }, /* (276) agg_func_opt ::= */
  {  382,   -1 }, /* (277) agg_func_opt ::= AGGREGATE */
  {  383,    0 }, /* (278) bufsize_opt ::= */
  {  383,   -2 }, /* (279) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  318,  -11 }, /* (280) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  318,   -4 }, /* (281) cmd ::= DROP STREAM exists_opt stream_name */
  {  376,    0 }, /* (282) stream_options ::= */
  {  376,   -3 }, /* (283) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  376,   -3 }, /* (284) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  376,   -4 }, /* (285) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  376,   -3 }, /* (286) stream_options ::= stream_options WATERMARK duration_literal */
  {  376,   -4 }, /* (287) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  376,   -3 }, /* (288) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  385,    0 }, /* (289) subtable_opt ::= */
  {  385,   -4 }, /* (290) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  318,   -3 }, /* (291) cmd ::= KILL CONNECTION NK_INTEGER */
  {  318,   -3 }, /* (292) cmd ::= KILL QUERY NK_STRING */
  {  318,   -3 }, /* (293) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  318,   -2 }, /* (294) cmd ::= BALANCE VGROUP */
  {  318,   -4 }, /* (295) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  318,   -4 }, /* (296) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  318,   -3 }, /* (297) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  387,   -2 }, /* (298) dnode_list ::= DNODE NK_INTEGER */
  {  387,   -3 }, /* (299) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  318,   -4 }, /* (300) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  318,   -1 }, /* (301) cmd ::= query_or_subquery */
  {  318,   -7 }, /* (302) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  318,   -4 }, /* (303) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  321,   -1 }, /* (304) literal ::= NK_INTEGER */
  {  321,   -1 }, /* (305) literal ::= NK_FLOAT */
  {  321,   -1 }, /* (306) literal ::= NK_STRING */
  {  321,   -1 }, /* (307) literal ::= NK_BOOL */
  {  321,   -2 }, /* (308) literal ::= TIMESTAMP NK_STRING */
  {  321,   -1 }, /* (309) literal ::= duration_literal */
  {  321,   -1 }, /* (310) literal ::= NULL */
  {  321,   -1 }, /* (311) literal ::= NK_QUESTION */
  {  363,   -1 }, /* (312) duration_literal ::= NK_VARIABLE */
  {  389,   -1 }, /* (313) signed ::= NK_INTEGER */
  {  389,   -2 }, /* (314) signed ::= NK_PLUS NK_INTEGER */
  {  389,   -2 }, /* (315) signed ::= NK_MINUS NK_INTEGER */
  {  389,   -1 }, /* (316) signed ::= NK_FLOAT */
  {  389,   -2 }, /* (317) signed ::= NK_PLUS NK_FLOAT */
  {  389,   -2 }, /* (318) signed ::= NK_MINUS NK_FLOAT */
  {  352,   -1 }, /* (319) signed_literal ::= signed */
  {  352,   -1 }, /* (320) signed_literal ::= NK_STRING */
  {  352,   -1 }, /* (321) signed_literal ::= NK_BOOL */
  {  352,   -2 }, /* (322) signed_literal ::= TIMESTAMP NK_STRING */
  {  352,   -1 }, /* (323) signed_literal ::= duration_literal */
  {  352,   -1 }, /* (324) signed_literal ::= NULL */
  {  352,   -1 }, /* (325) signed_literal ::= literal_func */
  {  352,   -1 }, /* (326) signed_literal ::= NK_QUESTION */
  {  391,   -1 }, /* (327) literal_list ::= signed_literal */
  {  391,   -3 }, /* (328) literal_list ::= literal_list NK_COMMA signed_literal */
  {  329,   -1 }, /* (329) db_name ::= NK_ID */
  {  358,   -1 }, /* (330) table_name ::= NK_ID */
  {  350,   -1 }, /* (331) column_name ::= NK_ID */
  {  365,   -1 }, /* (332) function_name ::= NK_ID */
  {  392,   -1 }, /* (333) table_alias ::= NK_ID */
  {  393,   -1 }, /* (334) column_alias ::= NK_ID */
  {  323,   -1 }, /* (335) user_name ::= NK_ID */
  {  377,   -1 }, /* (336) topic_name ::= NK_ID */
  {  384,   -1 }, /* (337) stream_name ::= NK_ID */
  {  379,   -1 }, /* (338) cgroup_name ::= NK_ID */
  {  394,   -1 }, /* (339) expr_or_subquery ::= expression */
  {  394,   -1 }, /* (340) expr_or_subquery ::= subquery */
  {  386,   -1 }, /* (341) expression ::= literal */
  {  386,   -1 }, /* (342) expression ::= pseudo_column */
  {  386,   -1 }, /* (343) expression ::= column_reference */
  {  386,   -1 }, /* (344) expression ::= function_expression */
  {  386,   -1 }, /* (345) expression ::= case_when_expression */
  {  386,   -3 }, /* (346) expression ::= NK_LP expression NK_RP */
  {  386,   -2 }, /* (347) expression ::= NK_PLUS expr_or_subquery */
  {  386,   -2 }, /* (348) expression ::= NK_MINUS expr_or_subquery */
  {  386,   -3 }, /* (349) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  386,   -3 }, /* (350) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  386,   -3 }, /* (351) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  386,   -3 }, /* (352) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  386,   -3 }, /* (353) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  386,   -3 }, /* (354) expression ::= column_reference NK_ARROW NK_STRING */
  {  386,   -3 }, /* (355) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  386,   -3 }, /* (356) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  355,   -1 }, /* (357) expression_list ::= expr_or_subquery */
  {  355,   -3 }, /* (358) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  397,   -1 }, /* (359) column_reference ::= column_name */
  {  397,   -3 }, /* (360) column_reference ::= table_name NK_DOT column_name */
  {  396,   -1 }, /* (361) pseudo_column ::= ROWTS */
  {  396,   -1 }, /* (362) pseudo_column ::= TBNAME */
  {  396,   -3 }, /* (363) pseudo_column ::= table_name NK_DOT TBNAME */
  {  396,   -1 }, /* (364) pseudo_column ::= QSTART */
  {  396,   -1 }, /* (365) pseudo_column ::= QEND */
  {  396,   -1 }, /* (366) pseudo_column ::= QDURATION */
  {  396,   -1 }, /* (367) pseudo_column ::= WSTART */
  {  396,   -1 }, /* (368) pseudo_column ::= WEND */
  {  396,   -1 }, /* (369) pseudo_column ::= WDURATION */
  {  396,   -1 }, /* (370) pseudo_column ::= IROWTS */
  {  396,   -1 }, /* (371) pseudo_column ::= QTAGS */
  {  398,   -4 }, /* (372) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  398,   -4 }, /* (373) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  398,   -6 }, /* (374) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  398,   -1 }, /* (375) function_expression ::= literal_func */
  {  390,   -3 }, /* (376) literal_func ::= noarg_func NK_LP NK_RP */
  {  390,   -1 }, /* (377) literal_func ::= NOW */
  {  402,   -1 }, /* (378) noarg_func ::= NOW */
  {  402,   -1 }, /* (379) noarg_func ::= TODAY */
  {  402,   -1 }, /* (380) noarg_func ::= TIMEZONE */
  {  402,   -1 }, /* (381) noarg_func ::= DATABASE */
  {  402,   -1 }, /* (382) noarg_func ::= CLIENT_VERSION */
  {  402,   -1 }, /* (383) noarg_func ::= SERVER_VERSION */
  {  402,   -1 }, /* (384) noarg_func ::= SERVER_STATUS */
  {  402,   -1 }, /* (385) noarg_func ::= CURRENT_USER */
  {  402,   -1 }, /* (386) noarg_func ::= USER */
  {  400,   -1 }, /* (387) star_func ::= COUNT */
  {  400,   -1 }, /* (388) star_func ::= FIRST */
  {  400,   -1 }, /* (389) star_func ::= LAST */
  {  400,   -1 }, /* (390) star_func ::= LAST_ROW */
  {  401,   -1 }, /* (391) star_func_para_list ::= NK_STAR */
  {  401,   -1 }, /* (392) star_func_para_list ::= other_para_list */
  {  403,   -1 }, /* (393) other_para_list ::= star_func_para */
  {  403,   -3 }, /* (394) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  404,   -1 }, /* (395) star_func_para ::= expr_or_subquery */
  {  404,   -3 }, /* (396) star_func_para ::= table_name NK_DOT NK_STAR */
  {  399,   -4 }, /* (397) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  399,   -5 }, /* (398) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  405,   -1 }, /* (399) when_then_list ::= when_then_expr */
  {  405,   -2 }, /* (400) when_then_list ::= when_then_list when_then_expr */
  {  408,   -4 }, /* (401) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  406,    0 }, /* (402) case_when_else_opt ::= */
  {  406,   -2 }, /* (403) case_when_else_opt ::= ELSE common_expression */
  {  409,   -3 }, /* (404) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  409,   -5 }, /* (405) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  409,   -6 }, /* (406) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  409,   -3 }, /* (407) predicate ::= expr_or_subquery IS NULL */
  {  409,   -4 }, /* (408) predicate ::= expr_or_subquery IS NOT NULL */
  {  409,   -3 }, /* (409) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  410,   -1 }, /* (410) compare_op ::= NK_LT */
  {  410,   -1 }, /* (411) compare_op ::= NK_GT */
  {  410,   -1 }, /* (412) compare_op ::= NK_LE */
  {  410,   -1 }, /* (413) compare_op ::= NK_GE */
  {  410,   -1 }, /* (414) compare_op ::= NK_NE */
  {  410,   -1 }, /* (415) compare_op ::= NK_EQ */
  {  410,   -1 }, /* (416) compare_op ::= LIKE */
  {  410,   -2 }, /* (417) compare_op ::= NOT LIKE */
  {  410,   -1 }, /* (418) compare_op ::= MATCH */
  {  410,   -1 }, /* (419) compare_op ::= NMATCH */
  {  410,   -1 }, /* (420) compare_op ::= CONTAINS */
  {  411,   -1 }, /* (421) in_op ::= IN */
  {  411,   -2 }, /* (422) in_op ::= NOT IN */
  {  412,   -3 }, /* (423) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  413,   -1 }, /* (424) boolean_value_expression ::= boolean_primary */
  {  413,   -2 }, /* (425) boolean_value_expression ::= NOT boolean_primary */
  {  413,   -3 }, /* (426) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  413,   -3 }, /* (427) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  414,   -1 }, /* (428) boolean_primary ::= predicate */
  {  414,   -3 }, /* (429) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  407,   -1 }, /* (430) common_expression ::= expr_or_subquery */
  {  407,   -1 }, /* (431) common_expression ::= boolean_value_expression */
  {  415,    0 }, /* (432) from_clause_opt ::= */
  {  415,   -2 }, /* (433) from_clause_opt ::= FROM table_reference_list */
  {  416,   -1 }, /* (434) table_reference_list ::= table_reference */
  {  416,   -3 }, /* (435) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  417,   -1 }, /* (436) table_reference ::= table_primary */
  {  417,   -1 }, /* (437) table_reference ::= joined_table */
  {  418,   -2 }, /* (438) table_primary ::= table_name alias_opt */
  {  418,   -4 }, /* (439) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  418,   -2 }, /* (440) table_primary ::= subquery alias_opt */
  {  418,   -1 }, /* (441) table_primary ::= parenthesized_joined_table */
  {  420,    0 }, /* (442) alias_opt ::= */
  {  420,   -1 }, /* (443) alias_opt ::= table_alias */
  {  420,   -2 }, /* (444) alias_opt ::= AS table_alias */
  {  421,   -3 }, /* (445) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  421,   -3 }, /* (446) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  419,   -6 }, /* (447) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  422,    0 }, /* (448) join_type ::= */
  {  422,   -1 }, /* (449) join_type ::= INNER */
  {  424,  -12 }, /* (450) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  425,    0 }, /* (451) set_quantifier_opt ::= */
  {  425,   -1 }, /* (452) set_quantifier_opt ::= DISTINCT */
  {  425,   -1 }, /* (453) set_quantifier_opt ::= ALL */
  {  426,   -1 }, /* (454) select_list ::= select_item */
  {  426,   -3 }, /* (455) select_list ::= select_list NK_COMMA select_item */
  {  434,   -1 }, /* (456) select_item ::= NK_STAR */
  {  434,   -1 }, /* (457) select_item ::= common_expression */
  {  434,   -2 }, /* (458) select_item ::= common_expression column_alias */
  {  434,   -3 }, /* (459) select_item ::= common_expression AS column_alias */
  {  434,   -3 }, /* (460) select_item ::= table_name NK_DOT NK_STAR */
  {  388,    0 }, /* (461) where_clause_opt ::= */
  {  388,   -2 }, /* (462) where_clause_opt ::= WHERE search_condition */
  {  427,    0 }, /* (463) partition_by_clause_opt ::= */
  {  427,   -3 }, /* (464) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  435,   -1 }, /* (465) partition_list ::= partition_item */
  {  435,   -3 }, /* (466) partition_list ::= partition_list NK_COMMA partition_item */
  {  436,   -1 }, /* (467) partition_item ::= expr_or_subquery */
  {  436,   -2 }, /* (468) partition_item ::= expr_or_subquery column_alias */
  {  436,   -3 }, /* (469) partition_item ::= expr_or_subquery AS column_alias */
  {  431,    0 }, /* (470) twindow_clause_opt ::= */
  {  431,   -6 }, /* (471) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  431,   -4 }, /* (472) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  431,   -6 }, /* (473) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  431,   -8 }, /* (474) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  373,    0 }, /* (475) sliding_opt ::= */
  {  373,   -4 }, /* (476) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  430,    0 }, /* (477) fill_opt ::= */
  {  430,   -4 }, /* (478) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  430,   -6 }, /* (479) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  437,   -1 }, /* (480) fill_mode ::= NONE */
  {  437,   -1 }, /* (481) fill_mode ::= PREV */
  {  437,   -1 }, /* (482) fill_mode ::= NULL */
  {  437,   -1 }, /* (483) fill_mode ::= LINEAR */
  {  437,   -1 }, /* (484) fill_mode ::= NEXT */
  {  432,    0 }, /* (485) group_by_clause_opt ::= */
  {  432,   -3 }, /* (486) group_by_clause_opt ::= GROUP BY group_by_list */
  {  438,   -1 }, /* (487) group_by_list ::= expr_or_subquery */
  {  438,   -3 }, /* (488) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  433,    0 }, /* (489) having_clause_opt ::= */
  {  433,   -2 }, /* (490) having_clause_opt ::= HAVING search_condition */
  {  428,    0 }, /* (491) range_opt ::= */
  {  428,   -6 }, /* (492) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  429,    0 }, /* (493) every_opt ::= */
  {  429,   -4 }, /* (494) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  439,   -4 }, /* (495) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  440,   -1 }, /* (496) query_simple ::= query_specification */
  {  440,   -1 }, /* (497) query_simple ::= union_query_expression */
  {  444,   -4 }, /* (498) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  444,   -3 }, /* (499) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  445,   -1 }, /* (500) query_simple_or_subquery ::= query_simple */
  {  445,   -1 }, /* (501) query_simple_or_subquery ::= subquery */
  {  378,   -1 }, /* (502) query_or_subquery ::= query_expression */
  {  378,   -1 }, /* (503) query_or_subquery ::= subquery */
  {  441,    0 }, /* (504) order_by_clause_opt ::= */
  {  441,   -3 }, /* (505) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  442,    0 }, /* (506) slimit_clause_opt ::= */
  {  442,   -2 }, /* (507) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  442,   -4 }, /* (508) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  442,   -4 }, /* (509) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  443,    0 }, /* (510) limit_clause_opt ::= */
  {  443,   -2 }, /* (511) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  443,   -4 }, /* (512) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  443,   -4 }, /* (513) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  395,   -3 }, /* (514) subquery ::= NK_LP query_expression NK_RP */
  {  395,   -3 }, /* (515) subquery ::= NK_LP subquery NK_RP */
  {  423,   -1 }, /* (516) search_condition ::= common_expression */
  {  446,   -1 }, /* (517) sort_specification_list ::= sort_specification */
  {  446,   -3 }, /* (518) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  447,   -3 }, /* (519) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  448,    0 }, /* (520) ordering_specification_opt ::= */
  {  448,   -1 }, /* (521) ordering_specification_opt ::= ASC */
  {  448,   -1 }, /* (522) ordering_specification_opt ::= DESC */
  {  449,    0 }, /* (523) null_ordering_opt ::= */
  {  449,   -2 }, /* (524) null_ordering_opt ::= NULLS FIRST */
  {  449,   -2 }, /* (525) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,319,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,320,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,319,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,321,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,322,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,320,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,322,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,321,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy29, &yymsp[-1].minor.yy0, yymsp[0].minor.yy503); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy29, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy29, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy29, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy29); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy503 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy503 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy9, &yymsp[-2].minor.yy29, &yymsp[0].minor.yy29); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy9, &yymsp[-2].minor.yy29, &yymsp[0].minor.yy29); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy9 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy9 = yymsp[0].minor.yy9; }
  yymsp[0].minor.yy9 = yylhsminor.yy9;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy9 = yymsp[-2].minor.yy9 | yymsp[0].minor.yy9; }
  yymsp[-2].minor.yy9 = yylhsminor.yy9;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy9 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy9 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy29 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy29 = yylhsminor.yy29;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy29 = yymsp[-2].minor.yy29; }
  yymsp[-2].minor.yy29 = yylhsminor.yy29;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy29, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy29, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy29); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 329: /* db_name ::= NK_ID */ yytestcase(yyruleno==329);
      case 330: /* table_name ::= NK_ID */ yytestcase(yyruleno==330);
      case 331: /* column_name ::= NK_ID */ yytestcase(yyruleno==331);
      case 332: /* function_name ::= NK_ID */ yytestcase(yyruleno==332);
      case 333: /* table_alias ::= NK_ID */ yytestcase(yyruleno==333);
      case 334: /* column_alias ::= NK_ID */ yytestcase(yyruleno==334);
      case 335: /* user_name ::= NK_ID */ yytestcase(yyruleno==335);
      case 336: /* topic_name ::= NK_ID */ yytestcase(yyruleno==336);
      case 337: /* stream_name ::= NK_ID */ yytestcase(yyruleno==337);
      case 338: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==338);
      case 378: /* noarg_func ::= NOW */ yytestcase(yyruleno==378);
      case 379: /* noarg_func ::= TODAY */ yytestcase(yyruleno==379);
      case 380: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==380);
      case 381: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==381);
      case 382: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==382);
      case 383: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==383);
      case 384: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==384);
      case 385: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==385);
      case 386: /* noarg_func ::= USER */ yytestcase(yyruleno==386);
      case 387: /* star_func ::= COUNT */ yytestcase(yyruleno==387);
      case 388: /* star_func ::= FIRST */ yytestcase(yyruleno==388);
      case 389: /* star_func ::= LAST */ yytestcase(yyruleno==389);
      case 390: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==390);
{ yylhsminor.yy29 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy29 = yylhsminor.yy29;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy137, &yymsp[-1].minor.yy29, yymsp[0].minor.yy812); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy137, &yymsp[0].minor.yy29); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy29); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy29, yymsp[0].minor.yy812); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy29); }
        break;
      case 67: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy29, yymsp[0].minor.yy460); }
        break;
      case 68: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy137 = true; }
        break;
      case 69: /* not_exists_opt ::= */
      case 71: /* exists_opt ::= */ yytestcase(yyruleno==71);
      case 269: /* analyze_opt ::= */ yytestcase(yyruleno==269);
      case 276: /* agg_func_opt ::= */ yytestcase(yyruleno==276);
      case 451: /* set_quantifier_opt ::= */ yytestcase(yyruleno==451);
{ yymsp[1].minor.yy137 = false; }
        break;
      case 70: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy137 = true; }
        break;
      case 72: /* db_options ::= */
{ yymsp[1].minor.yy812 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 73: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 74: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 75: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 76: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 77: /* db_options ::= db_options DURATION NK_INTEGER */
      case 78: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==78);
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 79: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 80: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 81: /* db_options ::= db_options KEEP integer_list */
      case 82: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==82);
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_KEEP, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 83: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 84: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 85: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 86: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 87: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 88: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 89: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 90: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 91: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_RETENTIONS, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 92: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 93: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 94: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 95: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 96: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-3].minor.yy812, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy812 = yylhsminor.yy812;
        break;
      case 97: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-3].minor.yy812, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy812 = yylhsminor.yy812;
        break;
      case 99: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 100: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 101: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 102: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 103: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy812 = setDatabaseOption(pCxt, yymsp[-2].minor.yy812, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 104: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy812 = createAlterDatabaseOptions(pCxt); yylhsminor.yy812 = setAlterDatabaseOption(pCxt, yylhsminor.yy812, &yymsp[0].minor.yy245); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 105: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy812 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy812, &yymsp[0].minor.yy245); }
  yymsp[-1].minor.yy812 = yylhsminor.yy812;
        break;
      case 106: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy245.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy245.val = yymsp[0].minor.yy0; }
        break;
      case 107: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy245.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy245.val = yymsp[0].minor.yy0; }
        break;
      case 108: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy245.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy245.val = yymsp[0].minor.yy0; }
        break;
      case 109: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy245.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy245.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= KEEP integer_list */
      case 111: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==111);
{ yymsp[-1].minor.yy245.type = DB_OPTION_KEEP; yymsp[-1].minor.yy245.pList = yymsp[0].minor.yy424; }
        break;
      case 112: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy245.type = DB_OPTION_PAGES; yymsp[-1].minor.yy245.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy245.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy245.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= STRICT NK_STRING */
{ yymsp[-1].minor.yy245.type = DB_OPTION_STRICT; yymsp[-1].minor.yy245.val = yymsp[0].minor.yy0; }
        break;
      case 115: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy245.type = DB_OPTION_WAL; yymsp[-1].minor.yy245.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy245.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy245.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy424 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 118: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 299: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==299);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 119: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy424 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 120: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 121: /* retention_list ::= retention */
      case 143: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==143);
      case 146: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==146);
      case 153: /* column_def_list ::= column_def */ yytestcase(yyruleno==153);
      case 196: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==196);
      case 201: /* col_name_list ::= col_name */ yytestcase(yyruleno==201);
      case 252: /* func_list ::= func */ yytestcase(yyruleno==252);
      case 327: /* literal_list ::= signed_literal */ yytestcase(yyruleno==327);
      case 393: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==393);
      case 399: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==399);
      case 454: /* select_list ::= select_item */ yytestcase(yyruleno==454);
      case 465: /* partition_list ::= partition_item */ yytestcase(yyruleno==465);
      case 517: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==517);
{ yylhsminor.yy424 = createNodeList(pCxt, yymsp[0].minor.yy812); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 122: /* retention_list ::= retention_list NK_COMMA retention */
      case 154: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==154);
      case 197: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==197);
      case 202: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==202);
      case 253: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==253);
      case 328: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==328);
      case 394: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==394);
      case 455: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==455);
      case 466: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==466);
      case 518: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==518);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, yymsp[0].minor.yy812); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 123: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy812 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 124: /* speed_opt ::= */
      case 278: /* bufsize_opt ::= */ yytestcase(yyruleno==278);
{ yymsp[1].minor.yy460 = 0; }
        break;
      case 125: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 279: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==279);
{ yymsp[-1].minor.yy460 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 126: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 128: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==128);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy137, yymsp[-5].minor.yy812, yymsp[-3].minor.yy424, yymsp[-1].minor.yy424, yymsp[0].minor.yy812); }
        break;
      case 127: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy424); }
        break;
      case 129: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy424); }
        break;
      case 130: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy137, yymsp[0].minor.yy812); }
        break;
      case 131: /* cmd ::= ALTER TABLE alter_table_clause */
      case 301: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==301);
{ pCxt->pRootNode = yymsp[0].minor.yy812; }
        break;
      case 132: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy812); }
        break;
      case 133: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy812 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy812, yymsp[0].minor.yy812); }
  yymsp[-1].minor.yy812 = yylhsminor.yy812;
        break;
      case 134: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy812 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy812, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy29, yymsp[0].minor.yy484); }
  yymsp[-4].minor.yy812 = yylhsminor.yy812;
        break;
      case 135: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy812 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy812, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy29); }
  yymsp[-3].minor.yy812 = yylhsminor.yy812;
        break;
      case 136: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy812 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy812, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy29, yymsp[0].minor.yy484); }
  yymsp[-4].minor.yy812 = yylhsminor.yy812;
        break;
      case 137: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy812 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy812, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy29, &yymsp[0].minor.yy29); }
  yymsp[-4].minor.yy812 = yylhsminor.yy812;
        break;
      case 138: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy812 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy812, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy29, yymsp[0].minor.yy484); }
  yymsp[-4].minor.yy812 = yylhsminor.yy812;
        break;
      case 139: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy812 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy812, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy29); }
  yymsp[-3].minor.yy812 = yylhsminor.yy812;
        break;
      case 140: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy812 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy812, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy29, yymsp[0].minor.yy484); }
  yymsp[-4].minor.yy812 = yylhsminor.yy812;
        break;
      case 141: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy812 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy812, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy29, &yymsp[0].minor.yy29); }
  yymsp[-4].minor.yy812 = yylhsminor.yy812;
        break;
      case 142: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy812 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy812, &yymsp[-2].minor.yy29, yymsp[0].minor.yy812); }
  yymsp[-5].minor.yy812 = yylhsminor.yy812;
        break;
      case 144: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 147: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==147);
      case 400: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==400);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-1].minor.yy424, yymsp[0].minor.yy812); }
  yymsp[-1].minor.yy424 = yylhsminor.yy424;
        break;
      case 145: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy812 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy137, yymsp[-8].minor.yy812, yymsp[-6].minor.yy812, yymsp[-5].minor.yy424, yymsp[-2].minor.yy424, yymsp[0].minor.yy812); }
  yymsp[-9].minor.yy812 = yylhsminor.yy812;
        break;
      case 148: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy812 = createDropTableClause(pCxt, yymsp[-1].minor.yy137, yymsp[0].minor.yy812); }
  yymsp[-1].minor.yy812 = yylhsminor.yy812;
        break;
      case 149: /* specific_cols_opt ::= */
      case 180: /* tags_def_opt ::= */ yytestcase(yyruleno==180);
      case 463: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==463);
      case 485: /* group_by_clause_opt ::= */ yytestcase(yyruleno==485);
      case 504: /* order_by_clause_opt ::= */ yytestcase(yyruleno==504);
{ yymsp[1].minor.yy424 = NULL; }
        break;
      case 150: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy424 = yymsp[-1].minor.yy424; }
        break;
      case 151: /* full_table_name ::= table_name */
{ yylhsminor.yy812 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy29, NULL); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 152: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy812 = createRealTableNode(pCxt, &yymsp[-2].minor.yy29, &yymsp[0].minor.yy29, NULL); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 155: /* column_def ::= column_name type_name */
{ yylhsminor.yy812 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy29, yymsp[0].minor.yy484, NULL); }
  yymsp[-1].minor.yy812 = yylhsminor.yy812;
        break;
      case 156: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy812 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy29, yymsp[-2].minor.yy484, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy812 = yylhsminor.yy812;
        break;
      case 157: /* type_name ::= BOOL */
{ yymsp[0].minor.yy484 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 158: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy484 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 159: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy484 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 160: /* type_name ::= INT */
      case 161: /* type_name ::= INTEGER */ yytestcase(yyruleno==161);
{ yymsp[0].minor.yy484 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 162: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy484 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 163: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy484 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 164: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy484 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 165: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy484 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 166: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy484 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 167: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy484 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy484 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 169: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy484 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 170: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy484 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 171: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy484 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 172: /* type_name ::= JSON */
{ yymsp[0].minor.yy484 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 173: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy484 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 174: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy484 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 175: /* type_name ::= BLOB */
{ yymsp[0].minor.yy484 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 176: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy484 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 177: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy484 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 178: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy484 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 179: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy484 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* tags_def_opt ::= tags_def */
      case 392: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==392);
{ yylhsminor.yy424 = yymsp[0].minor.yy424; }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 182: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy424 = yymsp[-1].minor.yy424; }
        break;
      case 183: /* table_options ::= */
{ yymsp[1].minor.yy812 = createDefaultTableOptions(pCxt); }
        break;
      case 184: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy812 = setTableOption(pCxt, yymsp[-2].minor.yy812, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 185: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy812 = setTableOption(pCxt, yymsp[-2].minor.yy812, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 186: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy812 = setTableOption(pCxt, yymsp[-2].minor.yy812, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 187: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy812 = setTableOption(pCxt, yymsp[-4].minor.yy812, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy424); }
  yymsp[-4].minor.yy812 = yylhsminor.yy812;
        break;
      case 188: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy812 = setTableOption(pCxt, yymsp[-2].minor.yy812, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 189: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy812 = setTableOption(pCxt, yymsp[-4].minor.yy812, TABLE_OPTION_SMA, yymsp[-1].minor.yy424); }
  yymsp[-4].minor.yy812 = yylhsminor.yy812;
        break;
      case 190: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy812 = createAlterTableOptions(pCxt); yylhsminor.yy812 = setTableOption(pCxt, yylhsminor.yy812, yymsp[0].minor.yy245.type, &yymsp[0].minor.yy245.val); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 191: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy812 = setTableOption(pCxt, yymsp[-1].minor.yy812, yymsp[0].minor.yy245.type, &yymsp[0].minor.yy245.val); }
  yymsp[-1].minor.yy812 = yylhsminor.yy812;
        break;
      case 192: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy245.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy245.val = yymsp[0].minor.yy0; }
        break;
      case 193: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy245.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy245.val = yymsp[0].minor.yy0; }
        break;
      case 194: /* duration_list ::= duration_literal */
      case 357: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==357);
{ yylhsminor.yy424 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy812)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 195: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 358: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==358);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, releaseRawExprNode(pCxt, yymsp[0].minor.yy812)); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 198: /* rollup_func_name ::= function_name */
{ yylhsminor.yy812 = createFunctionNode(pCxt, &yymsp[0].minor.yy29, NULL); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 199: /* rollup_func_name ::= FIRST */
      case 200: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==200);
{ yylhsminor.yy812 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 203: /* col_name ::= column_name */
{ yylhsminor.yy812 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy29); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 204: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 205: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 206: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 207: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy812, yymsp[0].minor.yy812, OP_TYPE_LIKE); }
        break;
      case 208: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy812, yymsp[0].minor.yy812, OP_TYPE_LIKE); }
        break;
      case 209: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy812, NULL, OP_TYPE_LIKE); }
        break;
      case 210: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 211: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 212: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 213: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy812, yymsp[-1].minor.yy812, OP_TYPE_EQUAL); }
        break;
      case 214: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 215: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 216: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 217: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 218: /* cmd ::= SHOW LICENCES */
      case 219: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==219);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 220: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy29); }
        break;
      case 221: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy812); }
        break;
      case 222: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy812); }
        break;
      case 223: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 224: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 225: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 226: /* cmd ::= SHOW VARIABLES */
      case 227: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==227);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 228: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 229: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy812); }
        break;
      case 230: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 231: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 232: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 233: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 234: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy812); }
        break;
      case 235: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 236: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 237: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy812, yymsp[-1].minor.yy812, OP_TYPE_EQUAL); }
        break;
      case 238: /* cmd ::= SHOW TABLE TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLE_TAGS_STMT, yymsp[0].minor.yy812, yymsp[-1].minor.yy812, OP_TYPE_EQUAL); }
        break;
      case 239: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 240: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 241: /* db_name_cond_opt ::= */
      case 246: /* from_db_opt ::= */ yytestcase(yyruleno==246);
{ yymsp[1].minor.yy812 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 242: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy812 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy29); }
  yymsp[-1].minor.yy812 = yylhsminor.yy812;
        break;
      case 243: /* like_pattern_opt ::= */
      case 289: /* subtable_opt ::= */ yytestcase(yyruleno==289);
      case 402: /* case_when_else_opt ::= */ yytestcase(yyruleno==402);
      case 432: /* from_clause_opt ::= */ yytestcase(yyruleno==432);
      case 461: /* where_clause_opt ::= */ yytestcase(yyruleno==461);
      case 470: /* twindow_clause_opt ::= */ yytestcase(yyruleno==470);
      case 475: /* sliding_opt ::= */ yytestcase(yyruleno==475);
      case 477: /* fill_opt ::= */ yytestcase(yyruleno==477);
      case 489: /* having_clause_opt ::= */ yytestcase(yyruleno==489);
      case 491: /* range_opt ::= */ yytestcase(yyruleno==491);
      case 493: /* every_opt ::= */ yytestcase(yyruleno==493);
      case 506: /* slimit_clause_opt ::= */ yytestcase(yyruleno==506);
      case 510: /* limit_clause_opt ::= */ yytestcase(yyruleno==510);
{ yymsp[1].minor.yy812 = NULL; }
        break;
      case 244: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy812 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 245: /* table_name_cond ::= table_name */
{ yylhsminor.yy812 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy29); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 247: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy812 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy29); }
        break;
      case 248: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy137, yymsp[-3].minor.yy812, yymsp[-1].minor.yy812, NULL, yymsp[0].minor.yy812); }
        break;
      case 249: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy137, yymsp[0].minor.yy812); }
        break;
      case 250: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy812 = createIndexOption(pCxt, yymsp[-7].minor.yy424, releaseRawExprNode(pCxt, yymsp[-3].minor.yy812), NULL, yymsp[-1].minor.yy812, yymsp[0].minor.yy812); }
        break;
      case 251: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy812 = createIndexOption(pCxt, yymsp[-9].minor.yy424, releaseRawExprNode(pCxt, yymsp[-5].minor.yy812), releaseRawExprNode(pCxt, yymsp[-3].minor.yy812), yymsp[-1].minor.yy812, yymsp[0].minor.yy812); }
        break;
      case 254: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy812 = createFunctionNode(pCxt, &yymsp[-3].minor.yy29, yymsp[-1].minor.yy424); }
  yymsp[-3].minor.yy812 = yylhsminor.yy812;
        break;
      case 255: /* sma_stream_opt ::= */
      case 282: /* stream_options ::= */ yytestcase(yyruleno==282);
{ yymsp[1].minor.yy812 = createStreamOptions(pCxt); }
        break;
      case 256: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 286: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==286);
{ ((SStreamOptions*)yymsp[-2].minor.yy812)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy812); yylhsminor.yy812 = yymsp[-2].minor.yy812; }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 257: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy812)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy812); yylhsminor.yy812 = yymsp[-2].minor.yy812; }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 258: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy137, &yymsp[-2].minor.yy29, yymsp[0].minor.yy812); }
        break;
      case 259: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy137, &yymsp[-3].minor.yy29, &yymsp[0].minor.yy29, false); }
        break;
      case 260: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy137, &yymsp[-5].minor.yy29, &yymsp[0].minor.yy29, true); }
        break;
      case 261: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy137, &yymsp[-3].minor.yy29, yymsp[0].minor.yy812, false); }
        break;
      case 262: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy137, &yymsp[-5].minor.yy29, yymsp[0].minor.yy812, true); }
        break;
      case 263: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy137, &yymsp[0].minor.yy29); }
        break;
      case 264: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy137, &yymsp[-2].minor.yy29, &yymsp[0].minor.yy29); }
        break;
      case 265: /* cmd ::= DESC full_table_name */
      case 266: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==266);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy812); }
        break;
      case 267: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 268: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy137, yymsp[-1].minor.yy812, yymsp[0].minor.yy812); }
        break;
      case 270: /* analyze_opt ::= ANALYZE */
      case 277: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==277);
      case 452: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==452);
{ yymsp[0].minor.yy137 = true; }
        break;
      case 271: /* explain_options ::= */
{ yymsp[1].minor.yy812 = createDefaultExplainOptions(pCxt); }
        break;
      case 272: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy812 = setExplainVerbose(pCxt, yymsp[-2].minor.yy812, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 273: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy812 = setExplainRatio(pCxt, yymsp[-2].minor.yy812, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 274: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy137, yymsp[-8].minor.yy137, &yymsp[-5].minor.yy29, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy484, yymsp[0].minor.yy460); }
        break;
      case 275: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy137, &yymsp[0].minor.yy29); }
        break;
      case 280: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy137, &yymsp[-7].minor.yy29, yymsp[-4].minor.yy812, yymsp[-6].minor.yy812, yymsp[-3].minor.yy424, yymsp[-2].minor.yy812, yymsp[0].minor.yy812); }
        break;
      case 281: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy137, &yymsp[0].minor.yy29); }
        break;
      case 283: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy812)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy812 = yymsp[-2].minor.yy812; }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 284: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy812)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy812 = yymsp[-2].minor.yy812; }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 285: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy812)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy812)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy812); yylhsminor.yy812 = yymsp[-3].minor.yy812; }
  yymsp[-3].minor.yy812 = yylhsminor.yy812;
        break;
      case 287: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy812)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy812 = yymsp[-3].minor.yy812; }
  yymsp[-3].minor.yy812 = yylhsminor.yy812;
        break;
      case 288: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy812)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy812 = yymsp[-2].minor.yy812; }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 290: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 476: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==476);
      case 494: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==494);
{ yymsp[-3].minor.yy812 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy812); }
        break;
      case 291: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 292: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 293: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 294: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 295: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 296: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy424); }
        break;
      case 297: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 298: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy424 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 300: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy812, yymsp[0].minor.yy812); }
        break;
      case 302: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy812, yymsp[-2].minor.yy424, yymsp[0].minor.yy812); }
        break;
      case 303: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy812, NULL, yymsp[0].minor.yy812); }
        break;
      case 304: /* literal ::= NK_INTEGER */
{ yylhsminor.yy812 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 305: /* literal ::= NK_FLOAT */
{ yylhsminor.yy812 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 306: /* literal ::= NK_STRING */
{ yylhsminor.yy812 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 307: /* literal ::= NK_BOOL */
{ yylhsminor.yy812 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 308: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy812 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy812 = yylhsminor.yy812;
        break;
      case 309: /* literal ::= duration_literal */
      case 319: /* signed_literal ::= signed */ yytestcase(yyruleno==319);
      case 339: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==339);
      case 340: /* expr_or_subquery ::= subquery */ yytestcase(yyruleno==340);
      case 341: /* expression ::= literal */ yytestcase(yyruleno==341);
      case 342: /* expression ::= pseudo_column */ yytestcase(yyruleno==342);
      case 343: /* expression ::= column_reference */ yytestcase(yyruleno==343);
      case 344: /* expression ::= function_expression */ yytestcase(yyruleno==344);
      case 345: /* expression ::= case_when_expression */ yytestcase(yyruleno==345);
      case 375: /* function_expression ::= literal_func */ yytestcase(yyruleno==375);
      case 424: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==424);
      case 428: /* boolean_primary ::= predicate */ yytestcase(yyruleno==428);
      case 430: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==430);
      case 431: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==431);
      case 434: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==434);
      case 436: /* table_reference ::= table_primary */ yytestcase(yyruleno==436);
      case 437: /* table_reference ::= joined_table */ yytestcase(yyruleno==437);
      case 441: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==441);
      case 496: /* query_simple ::= query_specification */ yytestcase(yyruleno==496);
      case 497: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==497);
      case 500: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==500);
      case 502: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==502);
{ yylhsminor.yy812 = yymsp[0].minor.yy812; }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 310: /* literal ::= NULL */
{ yylhsminor.yy812 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 311: /* literal ::= NK_QUESTION */
{ yylhsminor.yy812 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 312: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy812 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 313: /* signed ::= NK_INTEGER */
{ yylhsminor.yy812 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 314: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy812 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 315: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy812 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy812 = yylhsminor.yy812;
        break;
      case 316: /* signed ::= NK_FLOAT */
{ yylhsminor.yy812 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 317: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy812 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 318: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy812 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy812 = yylhsminor.yy812;
        break;
      case 320: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy812 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 321: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy812 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 322: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy812 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 323: /* signed_literal ::= duration_literal */
      case 325: /* signed_literal ::= literal_func */ yytestcase(yyruleno==325);
      case 395: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==395);
      case 457: /* select_item ::= common_expression */ yytestcase(yyruleno==457);
      case 467: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==467);
      case 501: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==501);
      case 503: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==503);
      case 516: /* search_condition ::= common_expression */ yytestcase(yyruleno==516);
{ yylhsminor.yy812 = releaseRawExprNode(pCxt, yymsp[0].minor.yy812); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 324: /* signed_literal ::= NULL */
{ yylhsminor.yy812 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 326: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy812 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 346: /* expression ::= NK_LP expression NK_RP */
      case 429: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==429);
      case 515: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==515);
{ yylhsminor.yy812 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy812)); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 347: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy812);
                                                                                    yylhsminor.yy812 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy812));
                                                                                  }
  yymsp[-1].minor.yy812 = yylhsminor.yy812;
        break;
      case 348: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy812);
                                                                                    yylhsminor.yy812 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy812), NULL));
                                                                                  }
  yymsp[-1].minor.yy812 = yylhsminor.yy812;
        break;
      case 349: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy812);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy812);
                                                                                    yylhsminor.yy812 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy812), releaseRawExprNode(pCxt, yymsp[0].minor.yy812))); 
                                                                                  }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 350: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy812);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy812);
                                                                                    yylhsminor.yy812 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy812), releaseRawExprNode(pCxt, yymsp[0].minor.yy812))); 
                                                                                  }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 351: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy812);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy812);
                                                                                    yylhsminor.yy812 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy812), releaseRawExprNode(pCxt, yymsp[0].minor.yy812))); 
                                                                                  }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 352: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy812);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy812);
                                                                                    yylhsminor.yy812 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy812), releaseRawExprNode(pCxt, yymsp[0].minor.yy812))); 
                                                                                  }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 353: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy812);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy812);
                                                                                    yylhsminor.yy812 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy812), releaseRawExprNode(pCxt, yymsp[0].minor.yy812)));
                                                                                  }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 354: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy812);
                                                                                    yylhsminor.yy812 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy812), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 355: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy812);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy812);
                                                                                    yylhsminor.yy812 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy812), releaseRawExprNode(pCxt, yymsp[0].minor.yy812)));
                                                                                  }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 356: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy812);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy812);
                                                                                    yylhsminor.yy812 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy812), releaseRawExprNode(pCxt, yymsp[0].minor.yy812)));
                                                                                  }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 359: /* column_reference ::= column_name */
{ yylhsminor.yy812 = createRawExprNode(pCxt, &yymsp[0].minor.yy29, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy29)); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 360: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy812 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy29, &yymsp[0].minor.yy29, createColumnNode(pCxt, &yymsp[-2].minor.yy29, &yymsp[0].minor.yy29)); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 361: /* pseudo_column ::= ROWTS */
      case 362: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==362);
      case 364: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==364);
      case 365: /* pseudo_column ::= QEND */ yytestcase(yyruleno==365);
      case 366: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==366);
      case 367: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==367);
      case 368: /* pseudo_column ::= WEND */ yytestcase(yyruleno==368);
      case 369: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==369);
      case 370: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==370);
      case 371: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==371);
      case 377: /* literal_func ::= NOW */ yytestcase(yyruleno==377);
{ yylhsminor.yy812 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 363: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy812 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy29, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy29)))); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 372: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 373: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==373);
{ yylhsminor.yy812 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy29, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy29, yymsp[-1].minor.yy424)); }
  yymsp[-3].minor.yy812 = yylhsminor.yy812;
        break;
      case 374: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy812 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy812), yymsp[-1].minor.yy484)); }
  yymsp[-5].minor.yy812 = yylhsminor.yy812;
        break;
      case 376: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy812 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy29, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy29, NULL)); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 391: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy424 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 396: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 460: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==460);
{ yylhsminor.yy812 = createColumnNode(pCxt, &yymsp[-2].minor.yy29, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 397: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy812 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy424, yymsp[-1].minor.yy812)); }
  yymsp[-3].minor.yy812 = yylhsminor.yy812;
        break;
      case 398: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy812 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy812), yymsp[-2].minor.yy424, yymsp[-1].minor.yy812)); }
  yymsp[-4].minor.yy812 = yylhsminor.yy812;
        break;
      case 401: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy812 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy812), releaseRawExprNode(pCxt, yymsp[0].minor.yy812)); }
        break;
      case 403: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy812 = releaseRawExprNode(pCxt, yymsp[0].minor.yy812); }
        break;
      case 404: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 409: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==409);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy812);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy812);
                                                                                    yylhsminor.yy812 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy740, releaseRawExprNode(pCxt, yymsp[-2].minor.yy812), releaseRawExprNode(pCxt, yymsp[0].minor.yy812)));
                                                                                  }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 405: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy812);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy812);
                                                                                    yylhsminor.yy812 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy812), releaseRawExprNode(pCxt, yymsp[-2].minor.yy812), releaseRawExprNode(pCxt, yymsp[0].minor.yy812)));
                                                                                  }
  yymsp[-4].minor.yy812 = yylhsminor.yy812;
        break;
      case 406: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy812);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy812);
                                                                                    yylhsminor.yy812 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy812), releaseRawExprNode(pCxt, yymsp[-2].minor.yy812), releaseRawExprNode(pCxt, yymsp[0].minor.yy812)));
                                                                                  }
  yymsp[-5].minor.yy812 = yylhsminor.yy812;
        break;
      case 407: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy812);
                                                                                    yylhsminor.yy812 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy812), NULL));
                                                                                  }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 408: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy812);
                                                                                    yylhsminor.yy812 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy812), NULL));
                                                                                  }
  yymsp[-3].minor.yy812 = yylhsminor.yy812;
        break;
      case 410: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy740 = OP_TYPE_LOWER_THAN; }
        break;
      case 411: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy740 = OP_TYPE_GREATER_THAN; }
        break;
      case 412: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy740 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 413: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy740 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 414: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy740 = OP_TYPE_NOT_EQUAL; }
        break;
      case 415: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy740 = OP_TYPE_EQUAL; }
        break;
      case 416: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy740 = OP_TYPE_LIKE; }
        break;
      case 417: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy740 = OP_TYPE_NOT_LIKE; }
        break;
      case 418: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy740 = OP_TYPE_MATCH; }
        break;
      case 419: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy740 = OP_TYPE_NMATCH; }
        break;
      case 420: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy740 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 421: /* in_op ::= IN */
{ yymsp[0].minor.yy740 = OP_TYPE_IN; }
        break;
      case 422: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy740 = OP_TYPE_NOT_IN; }
        break;
      case 423: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy812 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy424)); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 425: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy812);
                                                                                    yylhsminor.yy812 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy812), NULL));
                                                                                  }
  yymsp[-1].minor.yy812 = yylhsminor.yy812;
        break;
      case 426: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy812);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy812);
                                                                                    yylhsminor.yy812 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy812), releaseRawExprNode(pCxt, yymsp[0].minor.yy812)));
                                                                                  }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 427: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy812);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy812);
                                                                                    yylhsminor.yy812 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy812), releaseRawExprNode(pCxt, yymsp[0].minor.yy812)));
                                                                                  }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 433: /* from_clause_opt ::= FROM table_reference_list */
      case 462: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==462);
      case 490: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==490);
{ yymsp[-1].minor.yy812 = yymsp[0].minor.yy812; }
        break;
      case 435: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy812 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy812, yymsp[0].minor.yy812, NULL); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 438: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy812 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy29, &yymsp[0].minor.yy29); }
  yymsp[-1].minor.yy812 = yylhsminor.yy812;
        break;
      case 439: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy812 = createRealTableNode(pCxt, &yymsp[-3].minor.yy29, &yymsp[-1].minor.yy29, &yymsp[0].minor.yy29); }
  yymsp[-3].minor.yy812 = yylhsminor.yy812;
        break;
      case 440: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy812 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy812), &yymsp[0].minor.yy29); }
  yymsp[-1].minor.yy812 = yylhsminor.yy812;
        break;
      case 442: /* alias_opt ::= */
{ yymsp[1].minor.yy29 = nil_token;  }
        break;
      case 443: /* alias_opt ::= table_alias */
{ yylhsminor.yy29 = yymsp[0].minor.yy29; }
  yymsp[0].minor.yy29 = yylhsminor.yy29;
        break;
      case 444: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy29 = yymsp[0].minor.yy29; }
        break;
      case 445: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 446: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==446);
{ yymsp[-2].minor.yy812 = yymsp[-1].minor.yy812; }
        break;
      case 447: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy812 = createJoinTableNode(pCxt, yymsp[-4].minor.yy612, yymsp[-5].minor.yy812, yymsp[-2].minor.yy812, yymsp[0].minor.yy812); }
  yymsp[-5].minor.yy812 = yylhsminor.yy812;
        break;
      case 448: /* join_type ::= */
{ yymsp[1].minor.yy612 = JOIN_TYPE_INNER; }
        break;
      case 449: /* join_type ::= INNER */
{ yymsp[0].minor.yy612 = JOIN_TYPE_INNER; }
        break;
      case 450: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy812 = createSelectStmt(pCxt, yymsp[-10].minor.yy137, yymsp[-9].minor.yy424, yymsp[-8].minor.yy812);
                                                                                    yymsp[-11].minor.yy812 = addWhereClause(pCxt, yymsp[-11].minor.yy812, yymsp[-7].minor.yy812);
                                                                                    yymsp[-11].minor.yy812 = addPartitionByClause(pCxt, yymsp[-11].minor.yy812, yymsp[-6].minor.yy424);
                                                                                    yymsp[-11].minor.yy812 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy812, yymsp[-2].minor.yy812);
                                                                                    yymsp[-11].minor.yy812 = addGroupByClause(pCxt, yymsp[-11].minor.yy812, yymsp[-1].minor.yy424);
                                                                                    yymsp[-11].minor.yy812 = addHavingClause(pCxt, yymsp[-11].minor.yy812, yymsp[0].minor.yy812);
                                                                                    yymsp[-11].minor.yy812 = addRangeClause(pCxt, yymsp[-11].minor.yy812, yymsp[-5].minor.yy812);
                                                                                    yymsp[-11].minor.yy812 = addEveryClause(pCxt, yymsp[-11].minor.yy812, yymsp[-4].minor.yy812);
                                                                                    yymsp[-11].minor.yy812 = addFillClause(pCxt, yymsp[-11].minor.yy812, yymsp[-3].minor.yy812);
                                                                                  }
        break;
      case 453: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy137 = false; }
        break;
      case 456: /* select_item ::= NK_STAR */
{ yylhsminor.yy812 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 458: /* select_item ::= common_expression column_alias */
      case 468: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==468);
{ yylhsminor.yy812 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy812), &yymsp[0].minor.yy29); }
  yymsp[-1].minor.yy812 = yylhsminor.yy812;
        break;
      case 459: /* select_item ::= common_expression AS column_alias */
      case 469: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==469);
{ yylhsminor.yy812 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy812), &yymsp[0].minor.yy29); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 464: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 486: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==486);
      case 505: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==505);
{ yymsp[-2].minor.yy424 = yymsp[0].minor.yy424; }
        break;
      case 471: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy812 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy812), releaseRawExprNode(pCxt, yymsp[-1].minor.yy812)); }
        break;
      case 472: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy812 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy812)); }
        break;
      case 473: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy812 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy812), NULL, yymsp[-1].minor.yy812, yymsp[0].minor.yy812); }
        break;
      case 474: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy812 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy812), releaseRawExprNode(pCxt, yymsp[-3].minor.yy812), yymsp[-1].minor.yy812, yymsp[0].minor.yy812); }
        break;
      case 478: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy812 = createFillNode(pCxt, yymsp[-1].minor.yy594, NULL); }
        break;
      case 479: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy812 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy424)); }
        break;
      case 480: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy594 = FILL_MODE_NONE; }
        break;
      case 481: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy594 = FILL_MODE_PREV; }
        break;
      case 482: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy594 = FILL_MODE_NULL; }
        break;
      case 483: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy594 = FILL_MODE_LINEAR; }
        break;
      case 484: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy594 = FILL_MODE_NEXT; }
        break;
      case 487: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy424 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy812))); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 488: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy812))); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 492: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy812 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy812), releaseRawExprNode(pCxt, yymsp[-1].minor.yy812)); }
        break;
      case 495: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy812 = addOrderByClause(pCxt, yymsp[-3].minor.yy812, yymsp[-2].minor.yy424);
                                                                                    yylhsminor.yy812 = addSlimitClause(pCxt, yylhsminor.yy812, yymsp[-1].minor.yy812);
                                                                                    yylhsminor.yy812 = addLimitClause(pCxt, yylhsminor.yy812, yymsp[0].minor.yy812);
                                                                                  }
  yymsp[-3].minor.yy812 = yylhsminor.yy812;
        break;
      case 498: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy812 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy812, yymsp[0].minor.yy812); }
  yymsp[-3].minor.yy812 = yylhsminor.yy812;
        break;
      case 499: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy812 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy812, yymsp[0].minor.yy812); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 507: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 511: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==511);
{ yymsp[-1].minor.yy812 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 508: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 512: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==512);
{ yymsp[-3].minor.yy812 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 509: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 513: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==513);
{ yymsp[-3].minor.yy812 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 514: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy812 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy812); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 519: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy812 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy812), yymsp[-1].minor.yy38, yymsp[0].minor.yy757); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 520: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy38 = ORDER_ASC; }
        break;
      case 521: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy38 = ORDER_ASC; }
        break;
      case 522: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy38 = ORDER_DESC; }
        break;
      case 523: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy757 = NULL_ORDER_DEFAULT; }
        break;
      case 524: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy757 = NULL_ORDER_FIRST; }
        break;
      case 525: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy757 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
