---
sidebar_label: 标签索引
title: 标签索引
description: 使用标签索引提升查询性能
---

## 简介

在 TDengine 3.0.3.0 版本之前（不含），默认在第一列 TAG 上建立索引，但不支持给其它列动态添加索引。从 3.0.3.0 版本开始，可以动态地为其它 TAG 列添加索引。对于第一个 TAG 列上自动建立的索引，其在查询中默认生效，且用户无法对其进行任何干预。适当地使用索引能够有效地提升查询性能。

## 语法

创建索引的语法如下 

```sql
CREATE INDEX index_name ON tbl_name (tagColName）
```

其中 `index_name` 为索引名称， `tbl_name` 为超级表名称，`tagColName` 为要在其上建立索引的 tag 列的名称。`tagColName` 的类型不受限制，即任何类型的 tag 列都可以建立索引。

删除索引的语法如下

```sql
DROP INDEX index_name
```

其中 `index_name` 为已经建立的某个索引的名称，如果该索引不存在则该命令执行失败，但不会对系统产生任何其它影响。

查看系统中已经存在的索引

```sql
SELECT * FROM information_schema.INS_INDEXES 
```

也可以为上面的查询语句加上过滤条件以缩小查询范围。

## 使用说明

1. 索引使用得当能够提升数据过滤的效率，目前支持的过滤算子有 `=`, `>`, `>=`, `<`, `<=`。如果查询过滤条件中使用了这些算子，则索引能够明显提升查询效率。但如果查询过滤条件中使用的是其它算子，则索引起不到作用，查询效率没有变化。未来会逐步添加更多的算子。

2. 针对一个 tag 列只能建立一个索引，如果重复创建索引则会报错。

3. 每次只能针对一个 tag 列建立一个索引，不能同时对多个 tag 建立索引。

4. 整个系统中不管是哪种类型的索引，其名称必须唯一。

5. 对索引个数没有限制，但每增加一个索引都会导致系统中的元数据增加，过多的索引会降低元数据存取的效率从而降低整个系统的性能。所以请尽量避免添加不必要的索引。

6. 不支持对普通和子表建立索引。

7. 如果某个 tag 列的唯一值较少时，不建议对其建立索引，这种情况下收效甚微。