/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 316
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SAlterOption yy21;
  EFillMode yy22;
  EOperatorType yy84;
  bool yy121;
  SDataType yy160;
  ENullOrder yy281;
  SToken yy409;
  int32_t yy452;
  SNodeList* yy488;
  SNode* yy504;
  EOrder yy522;
  EJoinType yy556;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYNSTATE             550
#define YYNRULE              412
#define YYNRULE_WITH_ACTION  412
#define YYNTOKEN             210
#define YY_MAX_SHIFT         549
#define YY_MIN_SHIFTREDUCE   811
#define YY_MAX_SHIFTREDUCE   1222
#define YY_ERROR_ACTION      1223
#define YY_ACCEPT_ACTION     1224
#define YY_NO_ACTION         1225
#define YY_MIN_REDUCE        1226
#define YY_MAX_REDUCE        1637
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1559)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   452, 1224,  258,  270,  452,  465, 1436,   25,  195,  118,
 /*    10 */  1437, 1238,   30,   28,   73,   21,  307, 1505, 1337, 1487,
 /*    20 */   267,  370, 1056,   23,  464,   32,   31,   29,   27,   26,
 /*    30 */  1346, 1483, 1489,   32,   31,   29,   27,   26, 1054,  275,
 /*    40 */  1078, 1523,   32,   31,   29,   27,   26, 1616,  434,  464,
 /*    50 */    11,   30,   28, 1165,  283, 1324, 1487, 1061,  451,  267,
 /*    60 */   132, 1056, 1474, 1474, 1614,   30,   28,  450, 1483, 1489,
 /*    70 */  1505,  464,  349,  267,    1, 1056,  278, 1054,   70, 1506,
 /*    80 */  1507, 1512, 1555, 1427, 1429, 1616,  260, 1551,  127,   11,
 /*    90 */  1076, 1054, 1226, 1278, 1523, 1616, 1061,  546,  132, 1164,
 /*   100 */   191,  434, 1614,   12,  349, 1098,  414, 1582, 1615, 1055,
 /*   110 */  1061,  451, 1614,    1,  500, 1474,   94,   93,   92,   91,
 /*   120 */    90,   89,   88,   87,   86,   12,  124,    7, 1095,  138,
 /*   130 */  1487,   70, 1506, 1507, 1512, 1555,  546, 1386, 1393,  260,
 /*   140 */  1551,  127, 1483, 1490,  257,  384, 1057,  378, 1055, 1391,
 /*   150 */   546,  383,  465,  313,   98,   51,  379,  377,   50,  380,
 /*   160 */  1583,  311, 1055, 1060, 1080, 1081, 1082, 1083,  449, 1110,
 /*   170 */  1111, 1112, 1113, 1114, 1115, 1116,  431, 1346,   32,   31,
 /*   180 */    29,   27,   26,  239, 1079, 1057,   85,  133,  133,   84,
 /*   190 */    83,   82,   81,   80,   79,   78,   77,   76,  503, 1057,
 /*   200 */  1318,  101, 1060, 1080, 1081, 1082, 1083,  449, 1110, 1111,
 /*   210 */  1112, 1113, 1114, 1115, 1116, 1249, 1060, 1080, 1081, 1082,
 /*   220 */  1083,  449, 1110, 1111, 1112, 1113, 1114, 1115, 1116,   30,
 /*   230 */    28,  306,  119,  305,   99,  425, 1304,  267,  133, 1056,
 /*   240 */  1523,  398,   30,   28,  129, 1562, 1563,  447, 1567,  238,
 /*   250 */   267, 1076, 1056,  542,  541, 1054,  251,  133,  328, 1569,
 /*   260 */  1474,  340,   32,   31,   29,   27,   26,   11, 1054, 1077,
 /*   270 */   341, 1505, 1616,  133, 1061,  899,  271, 1566,   53,  424,
 /*   280 */    30,   28,  165, 1163,  116,  132,  373, 1061,  267, 1614,
 /*   290 */  1056,    1, 1348,  165,  901, 1523,   66,  373,  252, 1342,
 /*   300 */   250,  249,  447,  372,    7, 1219, 1054,  491,  375,  384,
 /*   310 */   102,  378,  451,  465,  546,  383, 1474, 1338,   98,  375,
 /*   320 */   379,  377,  312,  380,   53, 1061, 1055,  546, 1080, 1081,
 /*   330 */  1082, 1083,   71, 1506, 1507, 1512, 1555,   97, 1346, 1055,
 /*   340 */  1554, 1551,    7,  339,    6, 1341,  334,  333,  332,  331,
 /*   350 */   330,  502,  327,  326,  325,  324,  323,  319,  318,  317,
 /*   360 */   316,  315,  314, 1057,  421,  546,   32,   31,   29,   27,
 /*   370 */    26,  382,  381, 1189, 1218,  514, 1057, 1055,  335,  301,
 /*   380 */  1060, 1080, 1081, 1082, 1083,  449, 1110, 1111, 1112, 1113,
 /*   390 */  1114, 1115, 1116, 1060, 1080, 1081, 1082, 1083,  449, 1110,
 /*   400 */  1111, 1112, 1113, 1114, 1115, 1116,  418, 1187, 1188, 1190,
 /*   410 */  1191,   29,   27,   26, 1057,  116, 1393,  133,   30,   28,
 /*   420 */   426,  422,  272, 1349,  142,  141,  267, 1391, 1056, 1179,
 /*   430 */    60, 1060, 1080, 1081, 1082, 1083,  449, 1110, 1111, 1112,
 /*   440 */  1113, 1114, 1115, 1116, 1054,   32,   31,   29,   27,   26,
 /*   450 */  1084, 1339,  937,  488,  487,  486,  941,  485,  943,  944,
 /*   460 */   484,  946,  481, 1061,  952,  478,  954,  955,  475,  472,
 /*   470 */    32,   31,   29,   27,   26,  515,  513, 1335, 1393, 1056,
 /*   480 */     1, 1275,  465,  242,  465,  465, 1248, 1160,  465, 1428,
 /*   490 */  1393,   73, 1424,  320,  321, 1054,  277,  348,  376,  140,
 /*   500 */   117, 1392,  465,  546,  116,  223, 1322, 1346, 1098, 1346,
 /*   510 */  1346, 1343, 1348, 1346, 1061, 1055, 1128,  221,  848, 1247,
 /*   520 */   847,   32,   31,   29,   27,   26,  217, 1346, 1331, 1376,
 /*   530 */   143, 1474,  431,  522,  521,  520,  519,  282,  849,  518,
 /*   540 */   517,  516,  103,  511,  510,  509,  508,  507,  506,  505,
 /*   550 */   504,  109, 1057, 1246,  546,  500, 1393,  101, 1333,  242,
 /*   560 */   438, 1245,  279, 1244, 1474, 1129, 1055, 1391,  190, 1060,
 /*   570 */  1080, 1081, 1082, 1083,  449, 1110, 1111, 1112, 1113, 1114,
 /*   580 */  1115, 1116,  465, 1133, 1329,  407,  442,    9,    8,  280,
 /*   590 */    99,  462, 1128,   68, 1243,  170,  115,  116, 1474,  433,
 /*   600 */   128, 1562, 1563, 1057, 1567, 1348, 1474, 1346, 1474,   24,
 /*   610 */   265, 1123, 1124, 1125, 1126, 1127, 1131, 1132, 1242,  406,
 /*   620 */  1060,   49,   48,  310, 1227,  137, 1241, 1240,  448,  408,
 /*   630 */   304, 1085, 1463, 1505, 1237, 1236, 1235,  465,  247, 1474,
 /*   640 */   296, 1129,  292,  288,  134,   85,  463, 1569,   84,   83,
 /*   650 */    82,   81,   80,   79,   78,   77,   76, 1523, 1569, 1133,
 /*   660 */  1616, 1141, 1346, 1474,  447, 1565, 1234, 1233,  290,  133,
 /*   670 */   490, 1474, 1474,  132,  451, 1505, 1564, 1614, 1474, 1474,
 /*   680 */  1474, 1474, 1130,  435,  431,   24,  265, 1123, 1124, 1125,
 /*   690 */  1126, 1127, 1131, 1132,   69, 1506, 1507, 1512, 1555, 1523,
 /*   700 */  1134, 1239,  241, 1551,  465, 1232,  447,  549, 1323,  101,
 /*   710 */   439, 1474, 1474,  209, 1616,  107,  451, 1505, 1231,  410,
 /*   720 */  1474,  214,  443, 1230,   96, 1229,   22,  132,  435, 1346,
 /*   730 */   538, 1614,  534,  530,  526,  213,   70, 1506, 1507, 1512,
 /*   740 */  1555, 1523,   99,   45,  260, 1551, 1628, 1186,  447,  176,
 /*   750 */  1474,  847,  188, 1562,  430, 1589,  429, 1305,  451, 1616,
 /*   760 */   437,   67, 1474, 1474,  207, 1505,  465,  368, 1474,  210,
 /*   770 */  1474, 1172,  132,  496,  446,  281, 1614, 1078,   70, 1506,
 /*   780 */  1507, 1512, 1555, 1574, 1160,  298,  260, 1551, 1628, 1523,
 /*   790 */   158, 1346,  431,  156,  461,  498,  447, 1612, 1265,  160,
 /*   800 */   300, 1260,  159,    9,    8,  162,  451, 1505,  161,  164,
 /*   810 */  1474, 1258,  163,  873,  495,  494,  493,  101,  492,  419,
 /*   820 */   385,  192,  413,  387,  396,  172,   70, 1506, 1507, 1512,
 /*   830 */  1555, 1523,  874,  390,  260, 1551, 1628,  394,  447,  179,
 /*   840 */  1040,  344,  169,  181,  440, 1573, 1221, 1222,  451,   34,
 /*   850 */    99,   34, 1474, 1135, 1505, 1093, 1064,  435,  405, 1387,
 /*   860 */   130, 1562, 1563,  153, 1567, 1063,  126, 1494,  229, 1506,
 /*   870 */  1507, 1512,  366,   65,  362,  358,  354,  152, 1523, 1492,
 /*   880 */    34,  185,  367,   62, 1023,  447,  198, 1120, 1616, 1505,
 /*   890 */   200, 1585,   95,  432,  105,  451,  457, 1505,  206, 1474,
 /*   900 */  1524,  132,    2,   54,  194, 1614,  150, 1076,  107,  285,
 /*   910 */    45,  389,  930, 1523,  925,   71, 1506, 1507, 1512, 1555,
 /*   920 */   447, 1523,  289,  445, 1551,  470,  397, 1067,  447,  958,
 /*   930 */   451, 1505,  899,  105, 1474,  106, 1066,  962,  451,  968,
 /*   940 */   167, 1032, 1474,  392,  246,  266,  248,  215,  386,  322,
 /*   950 */   120, 1506, 1507, 1512,  166, 1523, 1426,  329,  234, 1506,
 /*   960 */  1507, 1512,  447,  149,  107,  122, 1505,  146,  967,  105,
 /*   970 */   139,  342,  451,  108,  337, 1505, 1474, 1089,  336,  343,
 /*   980 */    43, 1088,  338,   42,  144,  145,  346,  345,  436, 1629,
 /*   990 */  1523, 1087,   71, 1506, 1507, 1512, 1555,  447,  347, 1523,
 /*  1000 */  1505, 1552,  148,   52,  350,  151,  447,  451, 1086,  369,
 /*  1010 */   371, 1474,  400, 1336,  415,  374,  451,  402,  399,   75,
 /*  1020 */  1474, 1321,  401,  155, 1523, 1332,  157,  234, 1506, 1507,
 /*  1030 */  1512,  447,  110,  111,  256,  171,  233, 1506, 1507, 1512,
 /*  1040 */   174,  451, 1505, 1334, 1330, 1474,  412,  112, 1505,  113,
 /*  1050 */  1085,  420,  409, 1596, 1505,  455, 1586,  411, 1595, 1061,
 /*  1060 */     5,  120, 1506, 1507, 1512,  184, 1523,  177,  427,  428,
 /*  1070 */  1576,  416, 1523,  447,  417,  125,  186,    4, 1523,  447,
 /*  1080 */   100, 1160,  210,  451,  180,  447,  496, 1474, 1084,  451,
 /*  1090 */   264,  259,  423, 1474,   35,  451,  268,  444, 1570, 1474,
 /*  1100 */  1630,  261, 1505,  234, 1506, 1507, 1512,  441,  498,  234,
 /*  1110 */  1506, 1507, 1512, 1505,  193,  226, 1506, 1507, 1512, 1631,
 /*  1120 */    17, 1537, 1435,  187, 1613,  453, 1523,  495,  494,  493,
 /*  1130 */   454,  492, 1434,  447,  269,  458,  459, 1523, 1505,  460,
 /*  1140 */   202,  204,  216,  451,  447,   59, 1347, 1474,   61,  497,
 /*  1150 */   468, 1319,  218,  212,  451,  545,  220,  222, 1474,  224,
 /*  1160 */   225, 1468, 1523,  232, 1506, 1507, 1512, 1505, 1467,  447,
 /*  1170 */    41,  284, 1505,  286,  235, 1506, 1507, 1512, 1464,  451,
 /*  1180 */  1505,  287,  291, 1474, 1050, 1051,  135, 1462,  293,  294,
 /*  1190 */   295, 1523, 1461,  297, 1460,  299, 1523, 1451,  447,  227,
 /*  1200 */  1506, 1507, 1512,  447, 1523,  136,  302,  303,  451, 1035,
 /*  1210 */  1034,  447, 1474,  451, 1505, 1445, 1444, 1474,  308,  309,
 /*  1220 */  1443,  451, 1442, 1006, 1419, 1474, 1418, 1417,  236, 1506,
 /*  1230 */  1507, 1512, 1416,  228, 1506, 1507, 1512, 1415, 1523, 1414,
 /*  1240 */  1413,  237, 1506, 1507, 1512,  447, 1412, 1411, 1410, 1409,
 /*  1250 */  1505, 1408, 1407, 1406, 1405,  451, 1505, 1404, 1403, 1474,
 /*  1260 */   104, 1402, 1505, 1401, 1400, 1399, 1398, 1008, 1397, 1396,
 /*  1270 */  1395, 1394, 1277, 1459, 1523, 1520, 1506, 1507, 1512, 1453,
 /*  1280 */  1523,  447, 1441, 1432,  147, 1325, 1523,  447, 1276,  866,
 /*  1290 */  1274,  451, 1272,  447,  351, 1474,  352,  451,  353, 1270,
 /*  1300 */   355, 1474,  357,  451, 1505,  359, 1268, 1474, 1257, 1505,
 /*  1310 */   356, 1519, 1506, 1507, 1512,  363,  360,  244, 1506, 1507,
 /*  1320 */  1512,  361,  364, 1518, 1506, 1507, 1512,  365, 1523, 1256,
 /*  1330 */  1253, 1327,  975, 1523,  973,  447, 1326, 1266,  274,  273,
 /*  1340 */   447,  898,  897,  896,  253,  451, 1261,  514, 1069, 1474,
 /*  1350 */   451, 1505,  895,  892, 1474,  891,  254, 1505,   74,  388,
 /*  1360 */   512, 1259,  154,  255, 1062,  245, 1506, 1507, 1512, 1252,
 /*  1370 */   243, 1506, 1507, 1512,  393, 1523,  391, 1251,  395,   72,
 /*  1380 */  1458, 1523,  447, 1061,  168, 1042, 1505, 1452,  447,  403,
 /*  1390 */  1440, 1439,  451,  114, 1431,   55, 1474,  173,  451,    3,
 /*  1400 */    14,  121, 1474,   34, 1492,   15,   39,   57,  178,  189,
 /*  1410 */  1523,  183,  240, 1506, 1507, 1512,  182,  447,  230, 1506,
 /*  1420 */  1507, 1512,   19,  466, 1185,   44, 1178,  451,  123,  404,
 /*  1430 */   175, 1474,   56,   38,   20, 1065,   37, 1157, 1207, 1156,
 /*  1440 */  1206,  131,   16, 1212,  262, 1211, 1210,  231, 1506, 1507,
 /*  1450 */  1512,  263,    8, 1096, 1094,   33,  196,   13,   18, 1430,
 /*  1460 */   197, 1121,  203, 1183, 1071,  469,  199,  201, 1491,   46,
 /*  1470 */    58,  467, 1070,   62,  959,  456,  205,  276,   40,  471,
 /*  1480 */   936,   36,  473,  208,  956,  474,  476,  953,  477, 1073,
 /*  1490 */   947,   10,  479,  945,  480,  482,  483,  951,   63,  970,
 /*  1500 */   950,  966,   47,   64,  489,  964,  864,  501,  905,  949,
 /*  1510 */   499,  211,  887,  886,  885,  948,  884,  883,  882,  881,
 /*  1520 */   880,  902,  900,  877,  876,  875,  872,  871,  870,  869,
 /*  1530 */   969, 1273,  523,  524, 1271,  525,  528,  527,  529, 1269,
 /*  1540 */   531,  532, 1267, 1255,  533,  535,  536,  537, 1254,  539,
 /*  1550 */   540, 1250,  543,  544, 1225, 1058,  548,  219,  547,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   254,  210,  241,  257,  254,  219,  260,  279,  280,  212,
 /*    10 */   260,  214,   12,   13,  228,    2,  263,  213,  213,  258,
 /*    20 */    20,  235,   22,    2,   20,   12,   13,   14,   15,   16,
 /*    30 */   244,  270,  271,   12,   13,   14,   15,   16,   38,  241,
 /*    40 */    20,  237,   12,   13,   14,   15,   16,  294,  244,   20,
 /*    50 */    50,   12,   13,   14,  263,    0,  258,   57,  254,   20,
 /*    60 */   307,   22,  258,  258,  311,   12,   13,   14,  270,  271,
 /*    70 */   213,   20,   49,   20,   74,   22,  246,   38,  274,  275,
 /*    80 */   276,  277,  278,  253,  254,  294,  282,  283,  284,   50,
 /*    90 */    20,   38,    0,    0,  237,  294,   57,   97,  307,    4,
 /*   100 */   296,  244,  311,   74,   49,   75,  302,  303,  307,  109,
 /*   110 */    57,  254,  311,   74,   49,  258,   24,   25,   26,   27,
 /*   120 */    28,   29,   30,   31,   32,   74,  236,   74,   75,   47,
 /*   130 */   258,  274,  275,  276,  277,  278,   97,  247,  237,  282,
 /*   140 */   283,  284,  270,  271,  243,   52,  146,   54,  109,  248,
 /*   150 */    97,   58,  219,  219,   61,   73,   63,   64,   76,   66,
 /*   160 */   303,  228,  109,  163,  164,  165,  166,  167,  168,  169,
 /*   170 */   170,  171,  172,  173,  174,  175,  219,  244,   12,   13,
 /*   180 */    14,   15,   16,  249,   20,  146,   21,  187,  187,   24,
 /*   190 */    25,   26,   27,   28,   29,   30,   31,   32,  225,  146,
 /*   200 */   227,  244,  163,  164,  165,  166,  167,  168,  169,  170,
 /*   210 */   171,  172,  173,  174,  175,  213,  163,  164,  165,  166,
 /*   220 */   167,  168,  169,  170,  171,  172,  173,  174,  175,   12,
 /*   230 */    13,  145,  222,  147,  277,   20,  226,   20,  187,   22,
 /*   240 */   237,  263,   12,   13,  287,  288,  289,  244,  291,   18,
 /*   250 */    20,   20,   22,  216,  217,   38,   35,  187,   27,  272,
 /*   260 */   258,   30,   12,   13,   14,   15,   16,   50,   38,   20,
 /*   270 */    39,  213,  294,  187,   57,   38,  229,  290,  221,  276,
 /*   280 */    12,   13,   61,  188,  237,  307,   65,   57,   20,  311,
 /*   290 */    22,   74,  245,   61,   57,  237,  218,   65,   77,  242,
 /*   300 */    79,   80,  244,   82,   74,  139,   38,   85,   87,   52,
 /*   310 */   232,   54,  254,  219,   97,   58,  258,  239,   61,   87,
 /*   320 */    63,   64,  228,   66,  221,   57,  109,   97,  164,  165,
 /*   330 */   166,  167,  274,  275,  276,  277,  278,  234,  244,  109,
 /*   340 */   282,  283,   74,  112,   43,  242,  115,  116,  117,  118,
 /*   350 */   119,   57,  121,  122,  123,  124,  125,  126,  127,  128,
 /*   360 */   129,  130,  131,  146,  136,   97,   12,   13,   14,   15,
 /*   370 */    16,  223,  224,  163,  208,   71,  146,  109,   67,   75,
 /*   380 */   163,  164,  165,  166,  167,  168,  169,  170,  171,  172,
 /*   390 */   173,  174,  175,  163,  164,  165,  166,  167,  168,  169,
 /*   400 */   170,  171,  172,  173,  174,  175,  196,  197,  198,  199,
 /*   410 */   200,   14,   15,   16,  146,  237,  237,  187,   12,   13,
 /*   420 */   192,  193,  243,  245,  113,  114,   20,  248,   22,   75,
 /*   430 */   218,  163,  164,  165,  166,  167,  168,  169,  170,  171,
 /*   440 */   172,  173,  174,  175,   38,   12,   13,   14,   15,   16,
 /*   450 */    20,  239,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   460 */    96,   97,   98,   57,  100,  101,  102,  103,  104,  105,
 /*   470 */    12,   13,   14,   15,   16,  223,  224,  238,  237,   22,
 /*   480 */    74,    0,  219,   50,  219,  219,  213,  186,  219,  248,
 /*   490 */   237,  228,  244,  228,  228,   38,  229,  228,  235,  251,
 /*   500 */    18,  248,  219,   97,  237,   23,    0,  244,   75,  244,
 /*   510 */   244,  228,  245,  244,   57,  109,   83,   35,   20,  213,
 /*   520 */    22,   12,   13,   14,   15,   16,  230,  244,  238,  233,
 /*   530 */    48,  258,  219,   52,   53,   54,   55,   56,   40,   58,
 /*   540 */    59,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   550 */    69,   70,  146,  213,   97,   49,  237,  244,  238,   50,
 /*   560 */     3,  213,  243,  213,  258,  132,  109,  248,  138,  163,
 /*   570 */   164,  165,  166,  167,  168,  169,  170,  171,  172,  173,
 /*   580 */   174,  175,  219,  150,  238,  219,   71,    1,    2,  229,
 /*   590 */   277,  228,   83,  111,  213,  238,  138,  237,  258,  286,
 /*   600 */   287,  288,  289,  146,  291,  245,  258,  244,  258,  176,
 /*   610 */   177,  178,  179,  180,  181,  182,  183,  184,  213,  266,
 /*   620 */   163,  139,  140,  141,    0,  143,  213,  213,  238,  263,
 /*   630 */   148,   20,    0,  213,  213,  213,  213,  219,  156,  258,
 /*   640 */   158,  132,  160,  161,  162,   21,  228,  272,   24,   25,
 /*   650 */    26,   27,   28,   29,   30,   31,   32,  237,  272,  150,
 /*   660 */   294,   75,  244,  258,  244,  290,  213,  213,   36,  187,
 /*   670 */   238,  258,  258,  307,  254,  213,  290,  311,  258,  258,
 /*   680 */   258,  258,  132,  263,  219,  176,  177,  178,  179,  180,
 /*   690 */   181,  182,  183,  184,  274,  275,  276,  277,  278,  237,
 /*   700 */   150,  214,  282,  283,  219,  213,  244,   19,    0,  244,
 /*   710 */    71,  258,  258,  228,  294,   71,  254,  213,  213,   75,
 /*   720 */   258,   33,  207,  213,   36,  213,  176,  307,  263,  244,
 /*   730 */    42,  311,   44,   45,   46,   47,  274,  275,  276,  277,
 /*   740 */   278,  237,  277,   71,  282,  283,  284,   75,  244,  138,
 /*   750 */   258,   22,  287,  288,  289,  293,  291,  226,  254,  294,
 /*   760 */   203,   73,  258,  258,   76,  213,  219,   38,  258,   61,
 /*   770 */   258,   14,  307,   65,   50,  228,  311,   20,  274,  275,
 /*   780 */   276,  277,  278,  185,  186,  142,  282,  283,  284,  237,
 /*   790 */    78,  244,  219,   81,  106,   87,  244,  293,    0,   78,
 /*   800 */   157,    0,   81,    1,    2,   78,  254,  213,   81,   78,
 /*   810 */   258,    0,   81,   38,  106,  107,  108,  244,  110,  305,
 /*   820 */    22,  314,  134,   22,   21,  137,  274,  275,  276,  277,
 /*   830 */   278,  237,   57,   22,  282,  283,  284,   34,  244,   71,
 /*   840 */   152,  254,  154,   75,  205,  293,  164,  165,  254,   71,
 /*   850 */   277,   71,  258,   75,  213,   75,   38,  263,  254,  247,
 /*   860 */   287,  288,  289,   33,  291,   38,   36,   74,  274,  275,
 /*   870 */   276,  277,   42,   74,   44,   45,   46,   47,  237,   86,
 /*   880 */    71,  299,  216,   84,   75,  244,   71,  163,  294,  213,
 /*   890 */    75,  273,   71,  292,   71,  254,   75,  213,   75,  258,
 /*   900 */   237,  307,  295,   73,  308,  311,   76,   20,   71,  219,
 /*   910 */    71,    4,   75,  237,   75,  274,  275,  276,  277,  278,
 /*   920 */   244,  237,   36,  282,  283,   71,   19,  109,  244,   75,
 /*   930 */   254,  213,   38,   71,  258,   71,  109,   75,  254,   75,
 /*   940 */    33,  144,  258,   36,  269,  261,  223,  264,   41,  219,
 /*   950 */   274,  275,  276,  277,   47,  237,  219,  252,  274,  275,
 /*   960 */   276,  277,  244,  133,   71,  135,  213,  137,   75,   71,
 /*   970 */   120,  219,  254,   75,  132,  213,  258,   20,  250,  268,
 /*   980 */    73,   20,  250,   76,  154,  221,  244,  262,  312,  313,
 /*   990 */   237,   20,  274,  275,  276,  277,  278,  244,  255,  237,
 /*  1000 */   213,  283,  221,  221,  219,  221,  244,  254,   20,  215,
 /*  1010 */   237,  258,  268,  237,  261,  223,  254,  267,  244,  219,
 /*  1020 */   258,    0,  153,  237,  237,  237,  237,  274,  275,  276,
 /*  1030 */   277,  244,  237,  237,  215,  218,  274,  275,  276,  277,
 /*  1040 */   218,  254,  213,  237,  237,  258,  255,  237,  213,  237,
 /*  1050 */    20,  195,  262,  304,  213,  194,  273,  244,  304,   57,
 /*  1060 */   202,  274,  275,  276,  277,  300,  237,  259,  306,  201,
 /*  1070 */   301,  190,  237,  244,  258,  298,  297,  189,  237,  244,
 /*  1080 */   244,  186,   61,  254,  259,  244,   65,  258,   20,  254,
 /*  1090 */   261,  258,  258,  258,  120,  254,  261,  206,  272,  258,
 /*  1100 */   313,  209,  213,  274,  275,  276,  277,  204,   87,  274,
 /*  1110 */   275,  276,  277,  213,  309,  274,  275,  276,  277,  315,
 /*  1120 */    74,  281,  259,  285,  310,  258,  237,  106,  107,  108,
 /*  1130 */   258,  110,  259,  244,  258,  135,  256,  237,  213,  255,
 /*  1140 */   244,  218,  233,  254,  244,  218,  244,  258,   74,  223,
 /*  1150 */   240,  227,  219,  218,  254,  215,  220,  211,  258,  231,
 /*  1160 */   231,    0,  237,  274,  275,  276,  277,  213,    0,  244,
 /*  1170 */   265,   64,  213,   38,  274,  275,  276,  277,    0,  254,
 /*  1180 */   213,  159,  159,  258,   38,   38,   38,    0,   38,   38,
 /*  1190 */   159,  237,    0,   38,    0,   38,  237,    0,  244,  274,
 /*  1200 */   275,  276,  277,  244,  237,   74,  150,  149,  254,  109,
 /*  1210 */   146,  244,  258,  254,  213,    0,    0,  258,   53,  142,
 /*  1220 */     0,  254,    0,   86,    0,  258,    0,    0,  274,  275,
 /*  1230 */   276,  277,    0,  274,  275,  276,  277,    0,  237,    0,
 /*  1240 */     0,  274,  275,  276,  277,  244,    0,    0,    0,    0,
 /*  1250 */   213,    0,    0,    0,    0,  254,  213,    0,    0,  258,
 /*  1260 */   120,    0,  213,    0,    0,    0,    0,   22,    0,    0,
 /*  1270 */     0,    0,    0,    0,  237,  274,  275,  276,  277,    0,
 /*  1280 */   237,  244,    0,    0,   43,    0,  237,  244,    0,   51,
 /*  1290 */     0,  254,    0,  244,   38,  258,   36,  254,   43,    0,
 /*  1300 */    38,  258,   43,  254,  213,   38,    0,  258,    0,  213,
 /*  1310 */    36,  274,  275,  276,  277,   38,   36,  274,  275,  276,
 /*  1320 */   277,   43,   36,  274,  275,  276,  277,   43,  237,    0,
 /*  1330 */     0,    0,   38,  237,   22,  244,    0,    0,   12,   13,
 /*  1340 */   244,   38,   38,   38,   22,  254,    0,   71,   22,  258,
 /*  1350 */   254,  213,   38,   38,  258,   38,   22,  213,   83,   39,
 /*  1360 */    71,    0,   81,   22,   38,  274,  275,  276,  277,    0,
 /*  1370 */   274,  275,  276,  277,   22,  237,   38,    0,   22,   20,
 /*  1380 */     0,  237,  244,   57,  155,   38,  213,    0,  244,   22,
 /*  1390 */     0,    0,  254,  151,    0,   74,  258,   43,  254,   71,
 /*  1400 */   191,   74,  258,   71,   86,  191,   71,    4,   75,   86,
 /*  1410 */   237,   71,  274,  275,  276,  277,   74,  244,  274,  275,
 /*  1420 */   276,  277,   74,   97,   75,  138,   75,  254,  135,  138,
 /*  1430 */   133,  258,   74,  138,   71,  109,   71,   75,   38,   75,
 /*  1440 */    38,   86,   71,   75,   38,   38,   38,  274,  275,  276,
 /*  1450 */   277,   38,    2,   75,   75,   74,   86,   74,   74,    0,
 /*  1460 */    75,  163,   43,   75,   22,   38,   74,   74,   86,   74,
 /*  1470 */    74,   85,  146,   84,   75,  136,  133,   38,   74,   74,
 /*  1480 */    22,  185,   38,   86,   75,   74,   38,   75,   74,  163,
 /*  1490 */    75,  191,   38,   75,   74,   38,   74,   99,   74,   38,
 /*  1500 */    99,   38,   74,   74,   87,   22,   51,   72,   57,   99,
 /*  1510 */    50,   71,   38,   38,   38,   99,   38,   38,   38,   38,
 /*  1520 */    22,   57,   38,   38,   38,   38,   38,   38,   38,   38,
 /*  1530 */   109,    0,   38,   36,    0,   43,   36,   38,   43,    0,
 /*  1540 */    38,   36,    0,    0,   43,   38,   36,   43,    0,   38,
 /*  1550 */    37,    0,   22,   21,  316,   22,   20,   22,   21,  316,
 /*  1560 */   316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
 /*  1570 */   316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
 /*  1580 */   316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
 /*  1590 */   316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
 /*  1600 */   316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
 /*  1610 */   316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
 /*  1620 */   316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
 /*  1630 */   316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
 /*  1640 */   316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
 /*  1650 */   316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
 /*  1660 */   316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
 /*  1670 */   316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
 /*  1680 */   316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
 /*  1690 */   316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
 /*  1700 */   316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
 /*  1710 */   316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
 /*  1720 */   316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
 /*  1730 */   316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
 /*  1740 */   316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
 /*  1750 */   316,  316,  316,  316,  316,  316,  316,  316,  316,  316,
 /*  1760 */   316,  316,  316,  316,  316,  316,  316,  316,  316,
};
#define YY_SHIFT_COUNT    (549)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1551)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   482,    0,   39,  217,  217,  217,  217,  230,  217,  217,
 /*    10 */   268,  406,   51,   53,  268,  268,  268,  268,  268,  268,
 /*    20 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*    30 */   268,  268,  268,  268,  268,   29,   29,   29,   70, 1326,
 /*    40 */  1326,   86,    4,    4,    1, 1326,  164,  164,    4,    4,
 /*    50 */     4,    4,    4,    4,   23,   20,  215,    1,   20,    4,
 /*    60 */     4,   20,    4,   20,   20,   20,    4,   65,  231,  433,
 /*    70 */   509,  509,  165,  221,  457,  257,  457,  457,  457,  457,
 /*    80 */   457,  457,  457,  457,  457,  457,  457,  457,  457,  457,
 /*    90 */   457,  457,  457,  457,  457,  164,  498,   55,  237,  430,
 /*   100 */   430,  430,  506,  237,  249,   20,   20,   20,  222,  294,
 /*   110 */   364,  364,  364,  364,  364,  364,  364,  688,  624,   93,
 /*   120 */   166,  210,  164,  164,  232,  228,  729,  611,  598,  301,
 /*   130 */   598,  757,  557,   95,  887,  886,  894,  797,  887,  887,
 /*   140 */   850,  842,  842,  887,  957,  961,   23,  249,  971,   23,
 /*   150 */    23,  887,   23,  988,   20,   20,   20,   20,   20,   20,
 /*   160 */    20,   20,   20,   20,   20,  894,  887,  988,  249,  957,
 /*   170 */   869,  961,   65,  249,  971,   65, 1030,  856,  861, 1002,
 /*   180 */   856,  861, 1002, 1002,  858,  868,  881,  888,  895,  249,
 /*   190 */  1068,  974,  892,  891,  903, 1046,   20,  861, 1002, 1002,
 /*   200 */   861, 1002, 1000,  249,  971,   65,  222,   65,  249, 1074,
 /*   210 */   894,  294,  887,   65,  988, 1559, 1559, 1559, 1559, 1559,
 /*   220 */   481,  830,   92,  907,  708, 1021,  354,   13,   21,   30,
 /*   230 */   458,  250,  250,  250,  250,  250,  250,  250,   82,  311,
 /*   240 */   397,  586,  550,  397,  397,  397,  632,  643,  304,  712,
 /*   250 */   721,  727,  731,  798,  801,  811,  803,  644,  672,  768,
 /*   260 */   802,  682,  639,  515,  778,  724,  780,  793,  809,  815,
 /*   270 */   821,  823,  837,  818,  827,  839,  854,  862,  864,  893,
 /*   280 */   898,  799,  775, 1161, 1168, 1107, 1178, 1135, 1022, 1146,
 /*   290 */  1147, 1148, 1023, 1187, 1150, 1151, 1031, 1192, 1155, 1194,
 /*   300 */  1157, 1197, 1131, 1056, 1058, 1100, 1064, 1215, 1216, 1165,
 /*   310 */  1077, 1220, 1222, 1137, 1224, 1226, 1227, 1232, 1237, 1239,
 /*   320 */  1240, 1246, 1247, 1248, 1249, 1251, 1252, 1253, 1254, 1257,
 /*   330 */  1140, 1258, 1261, 1263, 1264, 1265, 1266, 1245, 1268, 1269,
 /*   340 */  1270, 1271, 1272, 1273, 1279, 1282, 1283, 1241, 1285, 1238,
 /*   350 */  1288, 1290, 1256, 1260, 1255, 1292, 1262, 1274, 1259, 1299,
 /*   360 */  1267, 1280, 1278, 1306, 1277, 1286, 1284, 1308, 1329, 1330,
 /*   370 */  1331, 1275, 1281, 1294, 1276, 1312, 1336, 1303, 1304, 1305,
 /*   380 */  1314, 1289, 1276, 1315, 1317, 1337, 1322, 1346, 1334, 1320,
 /*   390 */  1361, 1341, 1338, 1369, 1352, 1377, 1356, 1359, 1380, 1287,
 /*   400 */  1229, 1347, 1387, 1242, 1367, 1291, 1293, 1390, 1391, 1295,
 /*   410 */  1394, 1321, 1354, 1297, 1328, 1332, 1209, 1333, 1335, 1349,
 /*   420 */  1327, 1342, 1348, 1351, 1340, 1318, 1358, 1363, 1214, 1362,
 /*   430 */  1364, 1323, 1296, 1365, 1355, 1368, 1371, 1300, 1403, 1400,
 /*   440 */  1402, 1406, 1407, 1408, 1413, 1450, 1298, 1370, 1378, 1381,
 /*   450 */  1379, 1383, 1384, 1385, 1388, 1392, 1393, 1339, 1395, 1459,
 /*   460 */  1419, 1343, 1396, 1389, 1382, 1397, 1442, 1404, 1386, 1399,
 /*   470 */  1427, 1439, 1405, 1409, 1444, 1411, 1412, 1448, 1414, 1415,
 /*   480 */  1454, 1420, 1418, 1457, 1422, 1398, 1401, 1410, 1416, 1458,
 /*   490 */  1417, 1424, 1461, 1421, 1428, 1429, 1463, 1276, 1483, 1455,
 /*   500 */  1460, 1451, 1435, 1440, 1474, 1475, 1476, 1478, 1479, 1480,
 /*   510 */  1481, 1498, 1464, 1289, 1484, 1276, 1485, 1486, 1487, 1488,
 /*   520 */  1489, 1490, 1491, 1531, 1494, 1497, 1492, 1534, 1499, 1500,
 /*   530 */  1495, 1539, 1502, 1505, 1501, 1542, 1507, 1510, 1504, 1543,
 /*   540 */  1511, 1513, 1548, 1551, 1530, 1532, 1533, 1535, 1537, 1536,
};
#define YY_REDUCE_COUNT (219)
#define YY_REDUCE_MIN   (-272)
#define YY_REDUCE_MAX   (1173)
static const short yy_reduce_ofst[] = {
 /*     0 */  -209,  420, -196, -143,  462,  504,  552,  594,   58,  641,
 /*    10 */   676,  718,  465,  684,  753,  762,  787,  829,  835,  841,
 /*    20 */   889,  900,  925,  954,  959,  967, 1001, 1037, 1043, 1049,
 /*    30 */  1091, 1096, 1138, 1144, 1173,  313,  -43,  573,  366, -239,
 /*    40 */  -202, -247, -214,  263,  -22, -128, -254, -170,  -67,   94,
 /*    50 */   265,  266,  269,  283,  103,  -99,    3, -199,   47,  363,
 /*    60 */   418,  179,  485,  267,  319,  360,  547,   78,  -66, -272,
 /*    70 */  -272, -272, -203, -110, -195,   10,    2,  273,  306,  340,
 /*    80 */   348,  350,  381,  405,  413,  414,  421,  422,  423,  453,
 /*    90 */   454,  492,  505,  510,  512, -250,   37,   57,  148,  -13,
 /*   100 */   375,  386,  212,  252,  248,  178,  241,  253,  296,  -27,
 /*   110 */   239,  290,  320,  346,  357,  390,  432,  353,  487,  531,
 /*   120 */   507,  514,  587,  604,  612,  582,  666,  618,  601,  601,
 /*   130 */   601,  663,  596,  607,  690,  675,  723,  683,  730,  737,
 /*   140 */   705,  728,  732,  752,  711,  725,  764,  742,  743,  781,
 /*   150 */   782,  785,  784,  794,  773,  776,  786,  788,  789,  795,
 /*   160 */   796,  806,  807,  810,  812,  792,  800,  819,  774,  744,
 /*   170 */   750,  790,  817,  813,  791,  822,  783,  749,  808,  816,
 /*   180 */   754,  825,  833,  834,  769,  765,  777,  779,  601,  836,
 /*   190 */   826,  838,  804,  814,  805,  840,  663,  863,  867,  872,
 /*   200 */   873,  876,  880,  896,  884,  923,  909,  927,  902,  910,
 /*   210 */   926,  924,  933,  935,  940,  905,  928,  929,  936,  946,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*    10 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*    20 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*    30 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*    40 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*    50 */  1223, 1223, 1223, 1223, 1282, 1223, 1223, 1223, 1223, 1223,
 /*    60 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1280, 1420, 1223,
 /*    70 */  1557, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*    80 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*    90 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1282, 1223, 1568,
 /*   100 */  1568, 1568, 1280, 1223, 1223, 1223, 1223, 1223, 1375, 1223,
 /*   110 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1454, 1223, 1223,
 /*   120 */  1632, 1223, 1223, 1223, 1328, 1592, 1223, 1584, 1560, 1574,
 /*   130 */  1561, 1223, 1617, 1577, 1223, 1223, 1223, 1446, 1223, 1223,
 /*   140 */  1425, 1422, 1422, 1223, 1223, 1223, 1282, 1223, 1223, 1282,
 /*   150 */  1282, 1223, 1282, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   160 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   170 */  1456, 1223, 1280, 1223, 1223, 1280, 1223, 1599, 1597, 1223,
 /*   180 */  1599, 1597, 1223, 1223, 1611, 1607, 1590, 1588, 1574, 1223,
 /*   190 */  1223, 1223, 1635, 1623, 1619, 1223, 1223, 1597, 1223, 1223,
 /*   200 */  1597, 1223, 1433, 1223, 1223, 1280, 1223, 1280, 1223, 1344,
 /*   210 */  1223, 1223, 1223, 1280, 1223, 1448, 1378, 1378, 1283, 1228,
 /*   220 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   230 */  1223, 1522, 1610, 1609, 1521, 1534, 1533, 1532, 1223, 1223,
 /*   240 */  1516, 1223, 1223, 1517, 1515, 1514, 1223, 1223, 1223, 1223,
 /*   250 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   260 */  1558, 1223, 1620, 1624, 1223, 1223, 1223, 1493, 1223, 1223,
 /*   270 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   280 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   290 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   300 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   310 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   320 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   330 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   340 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   350 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   360 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   370 */  1223, 1223, 1223, 1223, 1389, 1223, 1223, 1223, 1223, 1223,
 /*   380 */  1223, 1309, 1308, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   390 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   400 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   410 */  1223, 1223, 1223, 1223, 1581, 1591, 1223, 1223, 1223, 1223,
 /*   420 */  1223, 1223, 1223, 1223, 1223, 1493, 1223, 1608, 1223, 1567,
 /*   430 */  1563, 1223, 1223, 1559, 1223, 1223, 1618, 1223, 1223, 1223,
 /*   440 */  1223, 1223, 1223, 1223, 1223, 1553, 1223, 1223, 1223, 1223,
 /*   450 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   460 */  1223, 1223, 1223, 1223, 1492, 1223, 1223, 1223, 1223, 1223,
 /*   470 */  1223, 1223, 1372, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   480 */  1223, 1223, 1223, 1223, 1223, 1357, 1355, 1354, 1353, 1223,
 /*   490 */  1350, 1223, 1223, 1223, 1223, 1223, 1223, 1380, 1223, 1223,
 /*   500 */  1223, 1223, 1223, 1303, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   510 */  1223, 1223, 1223, 1294, 1223, 1293, 1223, 1223, 1223, 1223,
 /*   520 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   530 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
 /*   540 */  1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "DNODE",
  /*   37 */ "PORT",
  /*   38 */ "NK_INTEGER",
  /*   39 */ "DNODES",
  /*   40 */ "NK_IPTOKEN",
  /*   41 */ "LOCAL",
  /*   42 */ "QNODE",
  /*   43 */ "ON",
  /*   44 */ "BNODE",
  /*   45 */ "SNODE",
  /*   46 */ "MNODE",
  /*   47 */ "DATABASE",
  /*   48 */ "USE",
  /*   49 */ "IF",
  /*   50 */ "NOT",
  /*   51 */ "EXISTS",
  /*   52 */ "BLOCKS",
  /*   53 */ "CACHE",
  /*   54 */ "CACHELAST",
  /*   55 */ "COMP",
  /*   56 */ "DAYS",
  /*   57 */ "NK_VARIABLE",
  /*   58 */ "FSYNC",
  /*   59 */ "MAXROWS",
  /*   60 */ "MINROWS",
  /*   61 */ "KEEP",
  /*   62 */ "PRECISION",
  /*   63 */ "QUORUM",
  /*   64 */ "REPLICA",
  /*   65 */ "TTL",
  /*   66 */ "WAL",
  /*   67 */ "VGROUPS",
  /*   68 */ "SINGLE_STABLE",
  /*   69 */ "STREAM_MODE",
  /*   70 */ "RETENTIONS",
  /*   71 */ "NK_COMMA",
  /*   72 */ "NK_COLON",
  /*   73 */ "TABLE",
  /*   74 */ "NK_LP",
  /*   75 */ "NK_RP",
  /*   76 */ "STABLE",
  /*   77 */ "ADD",
  /*   78 */ "COLUMN",
  /*   79 */ "MODIFY",
  /*   80 */ "RENAME",
  /*   81 */ "TAG",
  /*   82 */ "SET",
  /*   83 */ "NK_EQ",
  /*   84 */ "USING",
  /*   85 */ "TAGS",
  /*   86 */ "NK_DOT",
  /*   87 */ "COMMENT",
  /*   88 */ "BOOL",
  /*   89 */ "TINYINT",
  /*   90 */ "SMALLINT",
  /*   91 */ "INT",
  /*   92 */ "INTEGER",
  /*   93 */ "BIGINT",
  /*   94 */ "FLOAT",
  /*   95 */ "DOUBLE",
  /*   96 */ "BINARY",
  /*   97 */ "TIMESTAMP",
  /*   98 */ "NCHAR",
  /*   99 */ "UNSIGNED",
  /*  100 */ "JSON",
  /*  101 */ "VARCHAR",
  /*  102 */ "MEDIUMBLOB",
  /*  103 */ "BLOB",
  /*  104 */ "VARBINARY",
  /*  105 */ "DECIMAL",
  /*  106 */ "SMA",
  /*  107 */ "ROLLUP",
  /*  108 */ "FILE_FACTOR",
  /*  109 */ "NK_FLOAT",
  /*  110 */ "DELAY",
  /*  111 */ "SHOW",
  /*  112 */ "DATABASES",
  /*  113 */ "TABLES",
  /*  114 */ "STABLES",
  /*  115 */ "MNODES",
  /*  116 */ "MODULES",
  /*  117 */ "QNODES",
  /*  118 */ "FUNCTIONS",
  /*  119 */ "INDEXES",
  /*  120 */ "FROM",
  /*  121 */ "ACCOUNTS",
  /*  122 */ "APPS",
  /*  123 */ "CONNECTIONS",
  /*  124 */ "LICENCE",
  /*  125 */ "GRANTS",
  /*  126 */ "QUERIES",
  /*  127 */ "SCORES",
  /*  128 */ "TOPICS",
  /*  129 */ "VARIABLES",
  /*  130 */ "BNODES",
  /*  131 */ "SNODES",
  /*  132 */ "LIKE",
  /*  133 */ "INDEX",
  /*  134 */ "FULLTEXT",
  /*  135 */ "FUNCTION",
  /*  136 */ "INTERVAL",
  /*  137 */ "TOPIC",
  /*  138 */ "AS",
  /*  139 */ "DESC",
  /*  140 */ "DESCRIBE",
  /*  141 */ "RESET",
  /*  142 */ "QUERY",
  /*  143 */ "EXPLAIN",
  /*  144 */ "ANALYZE",
  /*  145 */ "VERBOSE",
  /*  146 */ "NK_BOOL",
  /*  147 */ "RATIO",
  /*  148 */ "COMPACT",
  /*  149 */ "VNODES",
  /*  150 */ "IN",
  /*  151 */ "OUTPUTTYPE",
  /*  152 */ "AGGREGATE",
  /*  153 */ "BUFSIZE",
  /*  154 */ "STREAM",
  /*  155 */ "INTO",
  /*  156 */ "KILL",
  /*  157 */ "CONNECTION",
  /*  158 */ "MERGE",
  /*  159 */ "VGROUP",
  /*  160 */ "REDISTRIBUTE",
  /*  161 */ "SPLIT",
  /*  162 */ "SYNCDB",
  /*  163 */ "NULL",
  /*  164 */ "FIRST",
  /*  165 */ "LAST",
  /*  166 */ "NOW",
  /*  167 */ "TODAY",
  /*  168 */ "CAST",
  /*  169 */ "ROWTS",
  /*  170 */ "TBNAME",
  /*  171 */ "QSTARTTS",
  /*  172 */ "QENDTS",
  /*  173 */ "WSTARTTS",
  /*  174 */ "WENDTS",
  /*  175 */ "WDURATION",
  /*  176 */ "BETWEEN",
  /*  177 */ "IS",
  /*  178 */ "NK_LT",
  /*  179 */ "NK_GT",
  /*  180 */ "NK_LE",
  /*  181 */ "NK_GE",
  /*  182 */ "NK_NE",
  /*  183 */ "MATCH",
  /*  184 */ "NMATCH",
  /*  185 */ "JOIN",
  /*  186 */ "INNER",
  /*  187 */ "SELECT",
  /*  188 */ "DISTINCT",
  /*  189 */ "WHERE",
  /*  190 */ "PARTITION",
  /*  191 */ "BY",
  /*  192 */ "SESSION",
  /*  193 */ "STATE_WINDOW",
  /*  194 */ "SLIDING",
  /*  195 */ "FILL",
  /*  196 */ "VALUE",
  /*  197 */ "NONE",
  /*  198 */ "PREV",
  /*  199 */ "LINEAR",
  /*  200 */ "NEXT",
  /*  201 */ "GROUP",
  /*  202 */ "HAVING",
  /*  203 */ "ORDER",
  /*  204 */ "SLIMIT",
  /*  205 */ "SOFFSET",
  /*  206 */ "LIMIT",
  /*  207 */ "OFFSET",
  /*  208 */ "ASC",
  /*  209 */ "NULLS",
  /*  210 */ "cmd",
  /*  211 */ "account_options",
  /*  212 */ "alter_account_options",
  /*  213 */ "literal",
  /*  214 */ "alter_account_option",
  /*  215 */ "user_name",
  /*  216 */ "dnode_endpoint",
  /*  217 */ "dnode_host_name",
  /*  218 */ "not_exists_opt",
  /*  219 */ "db_name",
  /*  220 */ "db_options",
  /*  221 */ "exists_opt",
  /*  222 */ "alter_db_options",
  /*  223 */ "integer_list",
  /*  224 */ "variable_list",
  /*  225 */ "retention_list",
  /*  226 */ "alter_db_option",
  /*  227 */ "retention",
  /*  228 */ "full_table_name",
  /*  229 */ "column_def_list",
  /*  230 */ "tags_def_opt",
  /*  231 */ "table_options",
  /*  232 */ "multi_create_clause",
  /*  233 */ "tags_def",
  /*  234 */ "multi_drop_clause",
  /*  235 */ "alter_table_clause",
  /*  236 */ "alter_table_options",
  /*  237 */ "column_name",
  /*  238 */ "type_name",
  /*  239 */ "create_subtable_clause",
  /*  240 */ "specific_tags_opt",
  /*  241 */ "literal_list",
  /*  242 */ "drop_table_clause",
  /*  243 */ "col_name_list",
  /*  244 */ "table_name",
  /*  245 */ "column_def",
  /*  246 */ "func_name_list",
  /*  247 */ "alter_table_option",
  /*  248 */ "col_name",
  /*  249 */ "db_name_cond_opt",
  /*  250 */ "like_pattern_opt",
  /*  251 */ "table_name_cond",
  /*  252 */ "from_db_opt",
  /*  253 */ "func_name",
  /*  254 */ "function_name",
  /*  255 */ "index_name",
  /*  256 */ "index_options",
  /*  257 */ "func_list",
  /*  258 */ "duration_literal",
  /*  259 */ "sliding_opt",
  /*  260 */ "func",
  /*  261 */ "expression_list",
  /*  262 */ "topic_name",
  /*  263 */ "query_expression",
  /*  264 */ "analyze_opt",
  /*  265 */ "explain_options",
  /*  266 */ "agg_func_opt",
  /*  267 */ "bufsize_opt",
  /*  268 */ "stream_name",
  /*  269 */ "dnode_list",
  /*  270 */ "signed",
  /*  271 */ "signed_literal",
  /*  272 */ "table_alias",
  /*  273 */ "column_alias",
  /*  274 */ "expression",
  /*  275 */ "pseudo_column",
  /*  276 */ "column_reference",
  /*  277 */ "subquery",
  /*  278 */ "predicate",
  /*  279 */ "compare_op",
  /*  280 */ "in_op",
  /*  281 */ "in_predicate_value",
  /*  282 */ "boolean_value_expression",
  /*  283 */ "boolean_primary",
  /*  284 */ "common_expression",
  /*  285 */ "from_clause",
  /*  286 */ "table_reference_list",
  /*  287 */ "table_reference",
  /*  288 */ "table_primary",
  /*  289 */ "joined_table",
  /*  290 */ "alias_opt",
  /*  291 */ "parenthesized_joined_table",
  /*  292 */ "join_type",
  /*  293 */ "search_condition",
  /*  294 */ "query_specification",
  /*  295 */ "set_quantifier_opt",
  /*  296 */ "select_list",
  /*  297 */ "where_clause_opt",
  /*  298 */ "partition_by_clause_opt",
  /*  299 */ "twindow_clause_opt",
  /*  300 */ "group_by_clause_opt",
  /*  301 */ "having_clause_opt",
  /*  302 */ "select_sublist",
  /*  303 */ "select_item",
  /*  304 */ "fill_opt",
  /*  305 */ "fill_mode",
  /*  306 */ "group_by_list",
  /*  307 */ "query_expression_body",
  /*  308 */ "order_by_clause_opt",
  /*  309 */ "slimit_clause_opt",
  /*  310 */ "limit_clause_opt",
  /*  311 */ "query_primary",
  /*  312 */ "sort_specification_list",
  /*  313 */ "sort_specification",
  /*  314 */ "ordering_specification_opt",
  /*  315 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  29 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  30 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  31 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  32 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  33 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  34 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  35 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  36 */ "dnode_endpoint ::= NK_STRING",
 /*  37 */ "dnode_host_name ::= NK_ID",
 /*  38 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  39 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  40 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  41 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  42 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  43 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  45 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  46 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  47 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  48 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  49 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  50 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  51 */ "cmd ::= USE db_name",
 /*  52 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  53 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  54 */ "not_exists_opt ::=",
 /*  55 */ "exists_opt ::= IF EXISTS",
 /*  56 */ "exists_opt ::=",
 /*  57 */ "db_options ::=",
 /*  58 */ "db_options ::= db_options BLOCKS NK_INTEGER",
 /*  59 */ "db_options ::= db_options CACHE NK_INTEGER",
 /*  60 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  61 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  62 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  63 */ "db_options ::= db_options DAYS NK_VARIABLE",
 /*  64 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  65 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  66 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  67 */ "db_options ::= db_options KEEP integer_list",
 /*  68 */ "db_options ::= db_options KEEP variable_list",
 /*  69 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  70 */ "db_options ::= db_options QUORUM NK_INTEGER",
 /*  71 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  72 */ "db_options ::= db_options TTL NK_INTEGER",
 /*  73 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  74 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  75 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  76 */ "db_options ::= db_options STREAM_MODE NK_INTEGER",
 /*  77 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  78 */ "alter_db_options ::= alter_db_option",
 /*  79 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  80 */ "alter_db_option ::= BLOCKS NK_INTEGER",
 /*  81 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  82 */ "alter_db_option ::= KEEP integer_list",
 /*  83 */ "alter_db_option ::= KEEP variable_list",
 /*  84 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  85 */ "alter_db_option ::= QUORUM NK_INTEGER",
 /*  86 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  87 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  88 */ "integer_list ::= NK_INTEGER",
 /*  89 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /*  90 */ "variable_list ::= NK_VARIABLE",
 /*  91 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /*  92 */ "retention_list ::= retention",
 /*  93 */ "retention_list ::= retention_list NK_COMMA retention",
 /*  94 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /*  95 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /*  96 */ "cmd ::= CREATE TABLE multi_create_clause",
 /*  97 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /*  98 */ "cmd ::= DROP TABLE multi_drop_clause",
 /*  99 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 100 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 101 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 102 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 103 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 104 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 105 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 106 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 107 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 108 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 109 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 110 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 111 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal",
 /* 112 */ "multi_create_clause ::= create_subtable_clause",
 /* 113 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 114 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP",
 /* 115 */ "multi_drop_clause ::= drop_table_clause",
 /* 116 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 117 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 118 */ "specific_tags_opt ::=",
 /* 119 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 120 */ "full_table_name ::= table_name",
 /* 121 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 122 */ "column_def_list ::= column_def",
 /* 123 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 124 */ "column_def ::= column_name type_name",
 /* 125 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 126 */ "type_name ::= BOOL",
 /* 127 */ "type_name ::= TINYINT",
 /* 128 */ "type_name ::= SMALLINT",
 /* 129 */ "type_name ::= INT",
 /* 130 */ "type_name ::= INTEGER",
 /* 131 */ "type_name ::= BIGINT",
 /* 132 */ "type_name ::= FLOAT",
 /* 133 */ "type_name ::= DOUBLE",
 /* 134 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 135 */ "type_name ::= TIMESTAMP",
 /* 136 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 137 */ "type_name ::= TINYINT UNSIGNED",
 /* 138 */ "type_name ::= SMALLINT UNSIGNED",
 /* 139 */ "type_name ::= INT UNSIGNED",
 /* 140 */ "type_name ::= BIGINT UNSIGNED",
 /* 141 */ "type_name ::= JSON",
 /* 142 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 143 */ "type_name ::= MEDIUMBLOB",
 /* 144 */ "type_name ::= BLOB",
 /* 145 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 146 */ "type_name ::= DECIMAL",
 /* 147 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 149 */ "tags_def_opt ::=",
 /* 150 */ "tags_def_opt ::= tags_def",
 /* 151 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 152 */ "table_options ::=",
 /* 153 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 154 */ "table_options ::= table_options KEEP integer_list",
 /* 155 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 156 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 157 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 158 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 159 */ "table_options ::= table_options DELAY NK_INTEGER",
 /* 160 */ "alter_table_options ::= alter_table_option",
 /* 161 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 162 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 163 */ "alter_table_option ::= KEEP integer_list",
 /* 164 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 165 */ "col_name_list ::= col_name",
 /* 166 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 167 */ "col_name ::= column_name",
 /* 168 */ "cmd ::= SHOW DNODES",
 /* 169 */ "cmd ::= SHOW USERS",
 /* 170 */ "cmd ::= SHOW DATABASES",
 /* 171 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 172 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 173 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 174 */ "cmd ::= SHOW MNODES",
 /* 175 */ "cmd ::= SHOW MODULES",
 /* 176 */ "cmd ::= SHOW QNODES",
 /* 177 */ "cmd ::= SHOW FUNCTIONS",
 /* 178 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 179 */ "cmd ::= SHOW STREAMS",
 /* 180 */ "cmd ::= SHOW ACCOUNTS",
 /* 181 */ "cmd ::= SHOW APPS",
 /* 182 */ "cmd ::= SHOW CONNECTIONS",
 /* 183 */ "cmd ::= SHOW LICENCE",
 /* 184 */ "cmd ::= SHOW GRANTS",
 /* 185 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 186 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 187 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 188 */ "cmd ::= SHOW QUERIES",
 /* 189 */ "cmd ::= SHOW SCORES",
 /* 190 */ "cmd ::= SHOW TOPICS",
 /* 191 */ "cmd ::= SHOW VARIABLES",
 /* 192 */ "cmd ::= SHOW BNODES",
 /* 193 */ "cmd ::= SHOW SNODES",
 /* 194 */ "db_name_cond_opt ::=",
 /* 195 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 196 */ "like_pattern_opt ::=",
 /* 197 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 198 */ "table_name_cond ::= table_name",
 /* 199 */ "from_db_opt ::=",
 /* 200 */ "from_db_opt ::= FROM db_name",
 /* 201 */ "func_name_list ::= func_name",
 /* 202 */ "func_name_list ::= func_name_list NK_COMMA col_name",
 /* 203 */ "func_name ::= function_name",
 /* 204 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 205 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 206 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 207 */ "index_options ::=",
 /* 208 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 209 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 210 */ "func_list ::= func",
 /* 211 */ "func_list ::= func_list NK_COMMA func",
 /* 212 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 213 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 214 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name",
 /* 215 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 216 */ "cmd ::= DESC full_table_name",
 /* 217 */ "cmd ::= DESCRIBE full_table_name",
 /* 218 */ "cmd ::= RESET QUERY CACHE",
 /* 219 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 220 */ "analyze_opt ::=",
 /* 221 */ "analyze_opt ::= ANALYZE",
 /* 222 */ "explain_options ::=",
 /* 223 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 224 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 225 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 226 */ "cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 227 */ "cmd ::= DROP FUNCTION function_name",
 /* 228 */ "agg_func_opt ::=",
 /* 229 */ "agg_func_opt ::= AGGREGATE",
 /* 230 */ "bufsize_opt ::=",
 /* 231 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 232 */ "cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression",
 /* 233 */ "cmd ::= DROP STREAM stream_name",
 /* 234 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 235 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 236 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 237 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 238 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 239 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 240 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 241 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 242 */ "cmd ::= query_expression",
 /* 243 */ "literal ::= NK_INTEGER",
 /* 244 */ "literal ::= NK_FLOAT",
 /* 245 */ "literal ::= NK_STRING",
 /* 246 */ "literal ::= NK_BOOL",
 /* 247 */ "literal ::= TIMESTAMP NK_STRING",
 /* 248 */ "literal ::= duration_literal",
 /* 249 */ "literal ::= NULL",
 /* 250 */ "duration_literal ::= NK_VARIABLE",
 /* 251 */ "signed ::= NK_INTEGER",
 /* 252 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 253 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 254 */ "signed ::= NK_FLOAT",
 /* 255 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 256 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 257 */ "signed_literal ::= signed",
 /* 258 */ "signed_literal ::= NK_STRING",
 /* 259 */ "signed_literal ::= NK_BOOL",
 /* 260 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 261 */ "signed_literal ::= duration_literal",
 /* 262 */ "signed_literal ::= NULL",
 /* 263 */ "literal_list ::= signed_literal",
 /* 264 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 265 */ "db_name ::= NK_ID",
 /* 266 */ "table_name ::= NK_ID",
 /* 267 */ "column_name ::= NK_ID",
 /* 268 */ "function_name ::= NK_ID",
 /* 269 */ "function_name ::= FIRST",
 /* 270 */ "function_name ::= LAST",
 /* 271 */ "function_name ::= NOW",
 /* 272 */ "function_name ::= TODAY",
 /* 273 */ "table_alias ::= NK_ID",
 /* 274 */ "column_alias ::= NK_ID",
 /* 275 */ "user_name ::= NK_ID",
 /* 276 */ "index_name ::= NK_ID",
 /* 277 */ "topic_name ::= NK_ID",
 /* 278 */ "stream_name ::= NK_ID",
 /* 279 */ "expression ::= literal",
 /* 280 */ "expression ::= pseudo_column",
 /* 281 */ "expression ::= column_reference",
 /* 282 */ "expression ::= function_name NK_LP expression_list NK_RP",
 /* 283 */ "expression ::= function_name NK_LP NK_STAR NK_RP",
 /* 284 */ "expression ::= function_name NK_LP NK_RP",
 /* 285 */ "expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 286 */ "expression ::= subquery",
 /* 287 */ "expression ::= NK_LP expression NK_RP",
 /* 288 */ "expression ::= NK_PLUS expression",
 /* 289 */ "expression ::= NK_MINUS expression",
 /* 290 */ "expression ::= expression NK_PLUS expression",
 /* 291 */ "expression ::= expression NK_MINUS expression",
 /* 292 */ "expression ::= expression NK_STAR expression",
 /* 293 */ "expression ::= expression NK_SLASH expression",
 /* 294 */ "expression ::= expression NK_REM expression",
 /* 295 */ "expression_list ::= expression",
 /* 296 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 297 */ "column_reference ::= column_name",
 /* 298 */ "column_reference ::= table_name NK_DOT column_name",
 /* 299 */ "pseudo_column ::= ROWTS",
 /* 300 */ "pseudo_column ::= TBNAME",
 /* 301 */ "pseudo_column ::= QSTARTTS",
 /* 302 */ "pseudo_column ::= QENDTS",
 /* 303 */ "pseudo_column ::= WSTARTTS",
 /* 304 */ "pseudo_column ::= WENDTS",
 /* 305 */ "pseudo_column ::= WDURATION",
 /* 306 */ "predicate ::= expression compare_op expression",
 /* 307 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 308 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 309 */ "predicate ::= expression IS NULL",
 /* 310 */ "predicate ::= expression IS NOT NULL",
 /* 311 */ "predicate ::= expression in_op in_predicate_value",
 /* 312 */ "compare_op ::= NK_LT",
 /* 313 */ "compare_op ::= NK_GT",
 /* 314 */ "compare_op ::= NK_LE",
 /* 315 */ "compare_op ::= NK_GE",
 /* 316 */ "compare_op ::= NK_NE",
 /* 317 */ "compare_op ::= NK_EQ",
 /* 318 */ "compare_op ::= LIKE",
 /* 319 */ "compare_op ::= NOT LIKE",
 /* 320 */ "compare_op ::= MATCH",
 /* 321 */ "compare_op ::= NMATCH",
 /* 322 */ "in_op ::= IN",
 /* 323 */ "in_op ::= NOT IN",
 /* 324 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 325 */ "boolean_value_expression ::= boolean_primary",
 /* 326 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 327 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 328 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 329 */ "boolean_primary ::= predicate",
 /* 330 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 331 */ "common_expression ::= expression",
 /* 332 */ "common_expression ::= boolean_value_expression",
 /* 333 */ "from_clause ::= FROM table_reference_list",
 /* 334 */ "table_reference_list ::= table_reference",
 /* 335 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 336 */ "table_reference ::= table_primary",
 /* 337 */ "table_reference ::= joined_table",
 /* 338 */ "table_primary ::= table_name alias_opt",
 /* 339 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 340 */ "table_primary ::= subquery alias_opt",
 /* 341 */ "table_primary ::= parenthesized_joined_table",
 /* 342 */ "alias_opt ::=",
 /* 343 */ "alias_opt ::= table_alias",
 /* 344 */ "alias_opt ::= AS table_alias",
 /* 345 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 346 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 347 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 348 */ "join_type ::=",
 /* 349 */ "join_type ::= INNER",
 /* 350 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 351 */ "set_quantifier_opt ::=",
 /* 352 */ "set_quantifier_opt ::= DISTINCT",
 /* 353 */ "set_quantifier_opt ::= ALL",
 /* 354 */ "select_list ::= NK_STAR",
 /* 355 */ "select_list ::= select_sublist",
 /* 356 */ "select_sublist ::= select_item",
 /* 357 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 358 */ "select_item ::= common_expression",
 /* 359 */ "select_item ::= common_expression column_alias",
 /* 360 */ "select_item ::= common_expression AS column_alias",
 /* 361 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 362 */ "where_clause_opt ::=",
 /* 363 */ "where_clause_opt ::= WHERE search_condition",
 /* 364 */ "partition_by_clause_opt ::=",
 /* 365 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 366 */ "twindow_clause_opt ::=",
 /* 367 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 368 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 369 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 370 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 371 */ "sliding_opt ::=",
 /* 372 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 373 */ "fill_opt ::=",
 /* 374 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 375 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 376 */ "fill_mode ::= NONE",
 /* 377 */ "fill_mode ::= PREV",
 /* 378 */ "fill_mode ::= NULL",
 /* 379 */ "fill_mode ::= LINEAR",
 /* 380 */ "fill_mode ::= NEXT",
 /* 381 */ "group_by_clause_opt ::=",
 /* 382 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 383 */ "group_by_list ::= expression",
 /* 384 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 385 */ "having_clause_opt ::=",
 /* 386 */ "having_clause_opt ::= HAVING search_condition",
 /* 387 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 388 */ "query_expression_body ::= query_primary",
 /* 389 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 390 */ "query_primary ::= query_specification",
 /* 391 */ "order_by_clause_opt ::=",
 /* 392 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 393 */ "slimit_clause_opt ::=",
 /* 394 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 395 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 396 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 397 */ "limit_clause_opt ::=",
 /* 398 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 399 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 400 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 401 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 402 */ "search_condition ::= common_expression",
 /* 403 */ "sort_specification_list ::= sort_specification",
 /* 404 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 405 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 406 */ "ordering_specification_opt ::=",
 /* 407 */ "ordering_specification_opt ::= ASC",
 /* 408 */ "ordering_specification_opt ::= DESC",
 /* 409 */ "null_ordering_opt ::=",
 /* 410 */ "null_ordering_opt ::= NULLS FIRST",
 /* 411 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 210: /* cmd */
    case 213: /* literal */
    case 220: /* db_options */
    case 222: /* alter_db_options */
    case 227: /* retention */
    case 228: /* full_table_name */
    case 231: /* table_options */
    case 235: /* alter_table_clause */
    case 236: /* alter_table_options */
    case 239: /* create_subtable_clause */
    case 242: /* drop_table_clause */
    case 245: /* column_def */
    case 248: /* col_name */
    case 249: /* db_name_cond_opt */
    case 250: /* like_pattern_opt */
    case 251: /* table_name_cond */
    case 252: /* from_db_opt */
    case 253: /* func_name */
    case 256: /* index_options */
    case 258: /* duration_literal */
    case 259: /* sliding_opt */
    case 260: /* func */
    case 263: /* query_expression */
    case 265: /* explain_options */
    case 270: /* signed */
    case 271: /* signed_literal */
    case 274: /* expression */
    case 275: /* pseudo_column */
    case 276: /* column_reference */
    case 277: /* subquery */
    case 278: /* predicate */
    case 281: /* in_predicate_value */
    case 282: /* boolean_value_expression */
    case 283: /* boolean_primary */
    case 284: /* common_expression */
    case 285: /* from_clause */
    case 286: /* table_reference_list */
    case 287: /* table_reference */
    case 288: /* table_primary */
    case 289: /* joined_table */
    case 291: /* parenthesized_joined_table */
    case 293: /* search_condition */
    case 294: /* query_specification */
    case 297: /* where_clause_opt */
    case 299: /* twindow_clause_opt */
    case 301: /* having_clause_opt */
    case 303: /* select_item */
    case 304: /* fill_opt */
    case 307: /* query_expression_body */
    case 309: /* slimit_clause_opt */
    case 310: /* limit_clause_opt */
    case 311: /* query_primary */
    case 313: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy504)); 
}
      break;
    case 211: /* account_options */
    case 212: /* alter_account_options */
    case 214: /* alter_account_option */
    case 267: /* bufsize_opt */
{
 
}
      break;
    case 215: /* user_name */
    case 216: /* dnode_endpoint */
    case 217: /* dnode_host_name */
    case 219: /* db_name */
    case 237: /* column_name */
    case 244: /* table_name */
    case 254: /* function_name */
    case 255: /* index_name */
    case 262: /* topic_name */
    case 268: /* stream_name */
    case 272: /* table_alias */
    case 273: /* column_alias */
    case 290: /* alias_opt */
{
 
}
      break;
    case 218: /* not_exists_opt */
    case 221: /* exists_opt */
    case 264: /* analyze_opt */
    case 266: /* agg_func_opt */
    case 295: /* set_quantifier_opt */
{
 
}
      break;
    case 223: /* integer_list */
    case 224: /* variable_list */
    case 225: /* retention_list */
    case 229: /* column_def_list */
    case 230: /* tags_def_opt */
    case 232: /* multi_create_clause */
    case 233: /* tags_def */
    case 234: /* multi_drop_clause */
    case 240: /* specific_tags_opt */
    case 241: /* literal_list */
    case 243: /* col_name_list */
    case 246: /* func_name_list */
    case 257: /* func_list */
    case 261: /* expression_list */
    case 269: /* dnode_list */
    case 296: /* select_list */
    case 298: /* partition_by_clause_opt */
    case 300: /* group_by_clause_opt */
    case 302: /* select_sublist */
    case 306: /* group_by_list */
    case 308: /* order_by_clause_opt */
    case 312: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy488)); 
}
      break;
    case 226: /* alter_db_option */
    case 247: /* alter_table_option */
{
 
}
      break;
    case 238: /* type_name */
{
 
}
      break;
    case 279: /* compare_op */
    case 280: /* in_op */
{
 
}
      break;
    case 292: /* join_type */
{
 
}
      break;
    case 305: /* fill_mode */
{
 
}
      break;
    case 314: /* ordering_specification_opt */
{
 
}
      break;
    case 315: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<sizeof(yy_action)/sizeof(yy_action[0]) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
   210,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   210,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
   211,  /* (2) account_options ::= */
   211,  /* (3) account_options ::= account_options PPS literal */
   211,  /* (4) account_options ::= account_options TSERIES literal */
   211,  /* (5) account_options ::= account_options STORAGE literal */
   211,  /* (6) account_options ::= account_options STREAMS literal */
   211,  /* (7) account_options ::= account_options QTIME literal */
   211,  /* (8) account_options ::= account_options DBS literal */
   211,  /* (9) account_options ::= account_options USERS literal */
   211,  /* (10) account_options ::= account_options CONNS literal */
   211,  /* (11) account_options ::= account_options STATE literal */
   212,  /* (12) alter_account_options ::= alter_account_option */
   212,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   214,  /* (14) alter_account_option ::= PASS literal */
   214,  /* (15) alter_account_option ::= PPS literal */
   214,  /* (16) alter_account_option ::= TSERIES literal */
   214,  /* (17) alter_account_option ::= STORAGE literal */
   214,  /* (18) alter_account_option ::= STREAMS literal */
   214,  /* (19) alter_account_option ::= QTIME literal */
   214,  /* (20) alter_account_option ::= DBS literal */
   214,  /* (21) alter_account_option ::= USERS literal */
   214,  /* (22) alter_account_option ::= CONNS literal */
   214,  /* (23) alter_account_option ::= STATE literal */
   210,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
   210,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   210,  /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
   210,  /* (27) cmd ::= DROP USER user_name */
   210,  /* (28) cmd ::= CREATE DNODE dnode_endpoint */
   210,  /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
   210,  /* (30) cmd ::= DROP DNODE NK_INTEGER */
   210,  /* (31) cmd ::= DROP DNODE dnode_endpoint */
   210,  /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   210,  /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   210,  /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
   210,  /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   216,  /* (36) dnode_endpoint ::= NK_STRING */
   217,  /* (37) dnode_host_name ::= NK_ID */
   217,  /* (38) dnode_host_name ::= NK_IPTOKEN */
   210,  /* (39) cmd ::= ALTER LOCAL NK_STRING */
   210,  /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   210,  /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   210,  /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   210,  /* (43) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   210,  /* (44) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   210,  /* (45) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   210,  /* (46) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   210,  /* (47) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   210,  /* (48) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   210,  /* (49) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   210,  /* (50) cmd ::= DROP DATABASE exists_opt db_name */
   210,  /* (51) cmd ::= USE db_name */
   210,  /* (52) cmd ::= ALTER DATABASE db_name alter_db_options */
   218,  /* (53) not_exists_opt ::= IF NOT EXISTS */
   218,  /* (54) not_exists_opt ::= */
   221,  /* (55) exists_opt ::= IF EXISTS */
   221,  /* (56) exists_opt ::= */
   220,  /* (57) db_options ::= */
   220,  /* (58) db_options ::= db_options BLOCKS NK_INTEGER */
   220,  /* (59) db_options ::= db_options CACHE NK_INTEGER */
   220,  /* (60) db_options ::= db_options CACHELAST NK_INTEGER */
   220,  /* (61) db_options ::= db_options COMP NK_INTEGER */
   220,  /* (62) db_options ::= db_options DAYS NK_INTEGER */
   220,  /* (63) db_options ::= db_options DAYS NK_VARIABLE */
   220,  /* (64) db_options ::= db_options FSYNC NK_INTEGER */
   220,  /* (65) db_options ::= db_options MAXROWS NK_INTEGER */
   220,  /* (66) db_options ::= db_options MINROWS NK_INTEGER */
   220,  /* (67) db_options ::= db_options KEEP integer_list */
   220,  /* (68) db_options ::= db_options KEEP variable_list */
   220,  /* (69) db_options ::= db_options PRECISION NK_STRING */
   220,  /* (70) db_options ::= db_options QUORUM NK_INTEGER */
   220,  /* (71) db_options ::= db_options REPLICA NK_INTEGER */
   220,  /* (72) db_options ::= db_options TTL NK_INTEGER */
   220,  /* (73) db_options ::= db_options WAL NK_INTEGER */
   220,  /* (74) db_options ::= db_options VGROUPS NK_INTEGER */
   220,  /* (75) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   220,  /* (76) db_options ::= db_options STREAM_MODE NK_INTEGER */
   220,  /* (77) db_options ::= db_options RETENTIONS retention_list */
   222,  /* (78) alter_db_options ::= alter_db_option */
   222,  /* (79) alter_db_options ::= alter_db_options alter_db_option */
   226,  /* (80) alter_db_option ::= BLOCKS NK_INTEGER */
   226,  /* (81) alter_db_option ::= FSYNC NK_INTEGER */
   226,  /* (82) alter_db_option ::= KEEP integer_list */
   226,  /* (83) alter_db_option ::= KEEP variable_list */
   226,  /* (84) alter_db_option ::= WAL NK_INTEGER */
   226,  /* (85) alter_db_option ::= QUORUM NK_INTEGER */
   226,  /* (86) alter_db_option ::= CACHELAST NK_INTEGER */
   226,  /* (87) alter_db_option ::= REPLICA NK_INTEGER */
   223,  /* (88) integer_list ::= NK_INTEGER */
   223,  /* (89) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   224,  /* (90) variable_list ::= NK_VARIABLE */
   224,  /* (91) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   225,  /* (92) retention_list ::= retention */
   225,  /* (93) retention_list ::= retention_list NK_COMMA retention */
   227,  /* (94) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
   210,  /* (95) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   210,  /* (96) cmd ::= CREATE TABLE multi_create_clause */
   210,  /* (97) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   210,  /* (98) cmd ::= DROP TABLE multi_drop_clause */
   210,  /* (99) cmd ::= DROP STABLE exists_opt full_table_name */
   210,  /* (100) cmd ::= ALTER TABLE alter_table_clause */
   210,  /* (101) cmd ::= ALTER STABLE alter_table_clause */
   235,  /* (102) alter_table_clause ::= full_table_name alter_table_options */
   235,  /* (103) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   235,  /* (104) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   235,  /* (105) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   235,  /* (106) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   235,  /* (107) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   235,  /* (108) alter_table_clause ::= full_table_name DROP TAG column_name */
   235,  /* (109) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   235,  /* (110) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   235,  /* (111) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
   232,  /* (112) multi_create_clause ::= create_subtable_clause */
   232,  /* (113) multi_create_clause ::= multi_create_clause create_subtable_clause */
   239,  /* (114) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
   234,  /* (115) multi_drop_clause ::= drop_table_clause */
   234,  /* (116) multi_drop_clause ::= multi_drop_clause drop_table_clause */
   242,  /* (117) drop_table_clause ::= exists_opt full_table_name */
   240,  /* (118) specific_tags_opt ::= */
   240,  /* (119) specific_tags_opt ::= NK_LP col_name_list NK_RP */
   228,  /* (120) full_table_name ::= table_name */
   228,  /* (121) full_table_name ::= db_name NK_DOT table_name */
   229,  /* (122) column_def_list ::= column_def */
   229,  /* (123) column_def_list ::= column_def_list NK_COMMA column_def */
   245,  /* (124) column_def ::= column_name type_name */
   245,  /* (125) column_def ::= column_name type_name COMMENT NK_STRING */
   238,  /* (126) type_name ::= BOOL */
   238,  /* (127) type_name ::= TINYINT */
   238,  /* (128) type_name ::= SMALLINT */
   238,  /* (129) type_name ::= INT */
   238,  /* (130) type_name ::= INTEGER */
   238,  /* (131) type_name ::= BIGINT */
   238,  /* (132) type_name ::= FLOAT */
   238,  /* (133) type_name ::= DOUBLE */
   238,  /* (134) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   238,  /* (135) type_name ::= TIMESTAMP */
   238,  /* (136) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   238,  /* (137) type_name ::= TINYINT UNSIGNED */
   238,  /* (138) type_name ::= SMALLINT UNSIGNED */
   238,  /* (139) type_name ::= INT UNSIGNED */
   238,  /* (140) type_name ::= BIGINT UNSIGNED */
   238,  /* (141) type_name ::= JSON */
   238,  /* (142) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   238,  /* (143) type_name ::= MEDIUMBLOB */
   238,  /* (144) type_name ::= BLOB */
   238,  /* (145) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   238,  /* (146) type_name ::= DECIMAL */
   238,  /* (147) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   238,  /* (148) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
   230,  /* (149) tags_def_opt ::= */
   230,  /* (150) tags_def_opt ::= tags_def */
   233,  /* (151) tags_def ::= TAGS NK_LP column_def_list NK_RP */
   231,  /* (152) table_options ::= */
   231,  /* (153) table_options ::= table_options COMMENT NK_STRING */
   231,  /* (154) table_options ::= table_options KEEP integer_list */
   231,  /* (155) table_options ::= table_options TTL NK_INTEGER */
   231,  /* (156) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   231,  /* (157) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
   231,  /* (158) table_options ::= table_options FILE_FACTOR NK_FLOAT */
   231,  /* (159) table_options ::= table_options DELAY NK_INTEGER */
   236,  /* (160) alter_table_options ::= alter_table_option */
   236,  /* (161) alter_table_options ::= alter_table_options alter_table_option */
   247,  /* (162) alter_table_option ::= COMMENT NK_STRING */
   247,  /* (163) alter_table_option ::= KEEP integer_list */
   247,  /* (164) alter_table_option ::= TTL NK_INTEGER */
   243,  /* (165) col_name_list ::= col_name */
   243,  /* (166) col_name_list ::= col_name_list NK_COMMA col_name */
   248,  /* (167) col_name ::= column_name */
   210,  /* (168) cmd ::= SHOW DNODES */
   210,  /* (169) cmd ::= SHOW USERS */
   210,  /* (170) cmd ::= SHOW DATABASES */
   210,  /* (171) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   210,  /* (172) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   210,  /* (173) cmd ::= SHOW db_name_cond_opt VGROUPS */
   210,  /* (174) cmd ::= SHOW MNODES */
   210,  /* (175) cmd ::= SHOW MODULES */
   210,  /* (176) cmd ::= SHOW QNODES */
   210,  /* (177) cmd ::= SHOW FUNCTIONS */
   210,  /* (178) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   210,  /* (179) cmd ::= SHOW STREAMS */
   210,  /* (180) cmd ::= SHOW ACCOUNTS */
   210,  /* (181) cmd ::= SHOW APPS */
   210,  /* (182) cmd ::= SHOW CONNECTIONS */
   210,  /* (183) cmd ::= SHOW LICENCE */
   210,  /* (184) cmd ::= SHOW GRANTS */
   210,  /* (185) cmd ::= SHOW CREATE DATABASE db_name */
   210,  /* (186) cmd ::= SHOW CREATE TABLE full_table_name */
   210,  /* (187) cmd ::= SHOW CREATE STABLE full_table_name */
   210,  /* (188) cmd ::= SHOW QUERIES */
   210,  /* (189) cmd ::= SHOW SCORES */
   210,  /* (190) cmd ::= SHOW TOPICS */
   210,  /* (191) cmd ::= SHOW VARIABLES */
   210,  /* (192) cmd ::= SHOW BNODES */
   210,  /* (193) cmd ::= SHOW SNODES */
   249,  /* (194) db_name_cond_opt ::= */
   249,  /* (195) db_name_cond_opt ::= db_name NK_DOT */
   250,  /* (196) like_pattern_opt ::= */
   250,  /* (197) like_pattern_opt ::= LIKE NK_STRING */
   251,  /* (198) table_name_cond ::= table_name */
   252,  /* (199) from_db_opt ::= */
   252,  /* (200) from_db_opt ::= FROM db_name */
   246,  /* (201) func_name_list ::= func_name */
   246,  /* (202) func_name_list ::= func_name_list NK_COMMA col_name */
   253,  /* (203) func_name ::= function_name */
   210,  /* (204) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
   210,  /* (205) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
   210,  /* (206) cmd ::= DROP INDEX exists_opt index_name ON table_name */
   256,  /* (207) index_options ::= */
   256,  /* (208) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
   256,  /* (209) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
   257,  /* (210) func_list ::= func */
   257,  /* (211) func_list ::= func_list NK_COMMA func */
   260,  /* (212) func ::= function_name NK_LP expression_list NK_RP */
   210,  /* (213) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
   210,  /* (214) cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
   210,  /* (215) cmd ::= DROP TOPIC exists_opt topic_name */
   210,  /* (216) cmd ::= DESC full_table_name */
   210,  /* (217) cmd ::= DESCRIBE full_table_name */
   210,  /* (218) cmd ::= RESET QUERY CACHE */
   210,  /* (219) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
   264,  /* (220) analyze_opt ::= */
   264,  /* (221) analyze_opt ::= ANALYZE */
   265,  /* (222) explain_options ::= */
   265,  /* (223) explain_options ::= explain_options VERBOSE NK_BOOL */
   265,  /* (224) explain_options ::= explain_options RATIO NK_FLOAT */
   210,  /* (225) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
   210,  /* (226) cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
   210,  /* (227) cmd ::= DROP FUNCTION function_name */
   266,  /* (228) agg_func_opt ::= */
   266,  /* (229) agg_func_opt ::= AGGREGATE */
   267,  /* (230) bufsize_opt ::= */
   267,  /* (231) bufsize_opt ::= BUFSIZE NK_INTEGER */
   210,  /* (232) cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression */
   210,  /* (233) cmd ::= DROP STREAM stream_name */
   210,  /* (234) cmd ::= KILL CONNECTION NK_INTEGER */
   210,  /* (235) cmd ::= KILL QUERY NK_INTEGER */
   210,  /* (236) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   210,  /* (237) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   210,  /* (238) cmd ::= SPLIT VGROUP NK_INTEGER */
   269,  /* (239) dnode_list ::= DNODE NK_INTEGER */
   269,  /* (240) dnode_list ::= dnode_list DNODE NK_INTEGER */
   210,  /* (241) cmd ::= SYNCDB db_name REPLICA */
   210,  /* (242) cmd ::= query_expression */
   213,  /* (243) literal ::= NK_INTEGER */
   213,  /* (244) literal ::= NK_FLOAT */
   213,  /* (245) literal ::= NK_STRING */
   213,  /* (246) literal ::= NK_BOOL */
   213,  /* (247) literal ::= TIMESTAMP NK_STRING */
   213,  /* (248) literal ::= duration_literal */
   213,  /* (249) literal ::= NULL */
   258,  /* (250) duration_literal ::= NK_VARIABLE */
   270,  /* (251) signed ::= NK_INTEGER */
   270,  /* (252) signed ::= NK_PLUS NK_INTEGER */
   270,  /* (253) signed ::= NK_MINUS NK_INTEGER */
   270,  /* (254) signed ::= NK_FLOAT */
   270,  /* (255) signed ::= NK_PLUS NK_FLOAT */
   270,  /* (256) signed ::= NK_MINUS NK_FLOAT */
   271,  /* (257) signed_literal ::= signed */
   271,  /* (258) signed_literal ::= NK_STRING */
   271,  /* (259) signed_literal ::= NK_BOOL */
   271,  /* (260) signed_literal ::= TIMESTAMP NK_STRING */
   271,  /* (261) signed_literal ::= duration_literal */
   271,  /* (262) signed_literal ::= NULL */
   241,  /* (263) literal_list ::= signed_literal */
   241,  /* (264) literal_list ::= literal_list NK_COMMA signed_literal */
   219,  /* (265) db_name ::= NK_ID */
   244,  /* (266) table_name ::= NK_ID */
   237,  /* (267) column_name ::= NK_ID */
   254,  /* (268) function_name ::= NK_ID */
   254,  /* (269) function_name ::= FIRST */
   254,  /* (270) function_name ::= LAST */
   254,  /* (271) function_name ::= NOW */
   254,  /* (272) function_name ::= TODAY */
   272,  /* (273) table_alias ::= NK_ID */
   273,  /* (274) column_alias ::= NK_ID */
   215,  /* (275) user_name ::= NK_ID */
   255,  /* (276) index_name ::= NK_ID */
   262,  /* (277) topic_name ::= NK_ID */
   268,  /* (278) stream_name ::= NK_ID */
   274,  /* (279) expression ::= literal */
   274,  /* (280) expression ::= pseudo_column */
   274,  /* (281) expression ::= column_reference */
   274,  /* (282) expression ::= function_name NK_LP expression_list NK_RP */
   274,  /* (283) expression ::= function_name NK_LP NK_STAR NK_RP */
   274,  /* (284) expression ::= function_name NK_LP NK_RP */
   274,  /* (285) expression ::= CAST NK_LP expression AS type_name NK_RP */
   274,  /* (286) expression ::= subquery */
   274,  /* (287) expression ::= NK_LP expression NK_RP */
   274,  /* (288) expression ::= NK_PLUS expression */
   274,  /* (289) expression ::= NK_MINUS expression */
   274,  /* (290) expression ::= expression NK_PLUS expression */
   274,  /* (291) expression ::= expression NK_MINUS expression */
   274,  /* (292) expression ::= expression NK_STAR expression */
   274,  /* (293) expression ::= expression NK_SLASH expression */
   274,  /* (294) expression ::= expression NK_REM expression */
   261,  /* (295) expression_list ::= expression */
   261,  /* (296) expression_list ::= expression_list NK_COMMA expression */
   276,  /* (297) column_reference ::= column_name */
   276,  /* (298) column_reference ::= table_name NK_DOT column_name */
   275,  /* (299) pseudo_column ::= ROWTS */
   275,  /* (300) pseudo_column ::= TBNAME */
   275,  /* (301) pseudo_column ::= QSTARTTS */
   275,  /* (302) pseudo_column ::= QENDTS */
   275,  /* (303) pseudo_column ::= WSTARTTS */
   275,  /* (304) pseudo_column ::= WENDTS */
   275,  /* (305) pseudo_column ::= WDURATION */
   278,  /* (306) predicate ::= expression compare_op expression */
   278,  /* (307) predicate ::= expression BETWEEN expression AND expression */
   278,  /* (308) predicate ::= expression NOT BETWEEN expression AND expression */
   278,  /* (309) predicate ::= expression IS NULL */
   278,  /* (310) predicate ::= expression IS NOT NULL */
   278,  /* (311) predicate ::= expression in_op in_predicate_value */
   279,  /* (312) compare_op ::= NK_LT */
   279,  /* (313) compare_op ::= NK_GT */
   279,  /* (314) compare_op ::= NK_LE */
   279,  /* (315) compare_op ::= NK_GE */
   279,  /* (316) compare_op ::= NK_NE */
   279,  /* (317) compare_op ::= NK_EQ */
   279,  /* (318) compare_op ::= LIKE */
   279,  /* (319) compare_op ::= NOT LIKE */
   279,  /* (320) compare_op ::= MATCH */
   279,  /* (321) compare_op ::= NMATCH */
   280,  /* (322) in_op ::= IN */
   280,  /* (323) in_op ::= NOT IN */
   281,  /* (324) in_predicate_value ::= NK_LP expression_list NK_RP */
   282,  /* (325) boolean_value_expression ::= boolean_primary */
   282,  /* (326) boolean_value_expression ::= NOT boolean_primary */
   282,  /* (327) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   282,  /* (328) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   283,  /* (329) boolean_primary ::= predicate */
   283,  /* (330) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   284,  /* (331) common_expression ::= expression */
   284,  /* (332) common_expression ::= boolean_value_expression */
   285,  /* (333) from_clause ::= FROM table_reference_list */
   286,  /* (334) table_reference_list ::= table_reference */
   286,  /* (335) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   287,  /* (336) table_reference ::= table_primary */
   287,  /* (337) table_reference ::= joined_table */
   288,  /* (338) table_primary ::= table_name alias_opt */
   288,  /* (339) table_primary ::= db_name NK_DOT table_name alias_opt */
   288,  /* (340) table_primary ::= subquery alias_opt */
   288,  /* (341) table_primary ::= parenthesized_joined_table */
   290,  /* (342) alias_opt ::= */
   290,  /* (343) alias_opt ::= table_alias */
   290,  /* (344) alias_opt ::= AS table_alias */
   291,  /* (345) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   291,  /* (346) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   289,  /* (347) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
   292,  /* (348) join_type ::= */
   292,  /* (349) join_type ::= INNER */
   294,  /* (350) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
   295,  /* (351) set_quantifier_opt ::= */
   295,  /* (352) set_quantifier_opt ::= DISTINCT */
   295,  /* (353) set_quantifier_opt ::= ALL */
   296,  /* (354) select_list ::= NK_STAR */
   296,  /* (355) select_list ::= select_sublist */
   302,  /* (356) select_sublist ::= select_item */
   302,  /* (357) select_sublist ::= select_sublist NK_COMMA select_item */
   303,  /* (358) select_item ::= common_expression */
   303,  /* (359) select_item ::= common_expression column_alias */
   303,  /* (360) select_item ::= common_expression AS column_alias */
   303,  /* (361) select_item ::= table_name NK_DOT NK_STAR */
   297,  /* (362) where_clause_opt ::= */
   297,  /* (363) where_clause_opt ::= WHERE search_condition */
   298,  /* (364) partition_by_clause_opt ::= */
   298,  /* (365) partition_by_clause_opt ::= PARTITION BY expression_list */
   299,  /* (366) twindow_clause_opt ::= */
   299,  /* (367) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   299,  /* (368) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
   299,  /* (369) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   299,  /* (370) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   259,  /* (371) sliding_opt ::= */
   259,  /* (372) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
   304,  /* (373) fill_opt ::= */
   304,  /* (374) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   304,  /* (375) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
   305,  /* (376) fill_mode ::= NONE */
   305,  /* (377) fill_mode ::= PREV */
   305,  /* (378) fill_mode ::= NULL */
   305,  /* (379) fill_mode ::= LINEAR */
   305,  /* (380) fill_mode ::= NEXT */
   300,  /* (381) group_by_clause_opt ::= */
   300,  /* (382) group_by_clause_opt ::= GROUP BY group_by_list */
   306,  /* (383) group_by_list ::= expression */
   306,  /* (384) group_by_list ::= group_by_list NK_COMMA expression */
   301,  /* (385) having_clause_opt ::= */
   301,  /* (386) having_clause_opt ::= HAVING search_condition */
   263,  /* (387) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
   307,  /* (388) query_expression_body ::= query_primary */
   307,  /* (389) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
   311,  /* (390) query_primary ::= query_specification */
   308,  /* (391) order_by_clause_opt ::= */
   308,  /* (392) order_by_clause_opt ::= ORDER BY sort_specification_list */
   309,  /* (393) slimit_clause_opt ::= */
   309,  /* (394) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   309,  /* (395) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   309,  /* (396) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   310,  /* (397) limit_clause_opt ::= */
   310,  /* (398) limit_clause_opt ::= LIMIT NK_INTEGER */
   310,  /* (399) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   310,  /* (400) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   277,  /* (401) subquery ::= NK_LP query_expression NK_RP */
   293,  /* (402) search_condition ::= common_expression */
   312,  /* (403) sort_specification_list ::= sort_specification */
   312,  /* (404) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   313,  /* (405) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
   314,  /* (406) ordering_specification_opt ::= */
   314,  /* (407) ordering_specification_opt ::= ASC */
   314,  /* (408) ordering_specification_opt ::= DESC */
   315,  /* (409) null_ordering_opt ::= */
   315,  /* (410) null_ordering_opt ::= NULLS FIRST */
   315,  /* (411) null_ordering_opt ::= NULLS LAST */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -6,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   -4,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
    0,  /* (2) account_options ::= */
   -3,  /* (3) account_options ::= account_options PPS literal */
   -3,  /* (4) account_options ::= account_options TSERIES literal */
   -3,  /* (5) account_options ::= account_options STORAGE literal */
   -3,  /* (6) account_options ::= account_options STREAMS literal */
   -3,  /* (7) account_options ::= account_options QTIME literal */
   -3,  /* (8) account_options ::= account_options DBS literal */
   -3,  /* (9) account_options ::= account_options USERS literal */
   -3,  /* (10) account_options ::= account_options CONNS literal */
   -3,  /* (11) account_options ::= account_options STATE literal */
   -1,  /* (12) alter_account_options ::= alter_account_option */
   -2,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   -2,  /* (14) alter_account_option ::= PASS literal */
   -2,  /* (15) alter_account_option ::= PPS literal */
   -2,  /* (16) alter_account_option ::= TSERIES literal */
   -2,  /* (17) alter_account_option ::= STORAGE literal */
   -2,  /* (18) alter_account_option ::= STREAMS literal */
   -2,  /* (19) alter_account_option ::= QTIME literal */
   -2,  /* (20) alter_account_option ::= DBS literal */
   -2,  /* (21) alter_account_option ::= USERS literal */
   -2,  /* (22) alter_account_option ::= CONNS literal */
   -2,  /* (23) alter_account_option ::= STATE literal */
   -5,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
   -5,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   -5,  /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
   -3,  /* (27) cmd ::= DROP USER user_name */
   -3,  /* (28) cmd ::= CREATE DNODE dnode_endpoint */
   -5,  /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
   -3,  /* (30) cmd ::= DROP DNODE NK_INTEGER */
   -3,  /* (31) cmd ::= DROP DNODE dnode_endpoint */
   -4,  /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   -5,  /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   -4,  /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
   -5,  /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   -1,  /* (36) dnode_endpoint ::= NK_STRING */
   -1,  /* (37) dnode_host_name ::= NK_ID */
   -1,  /* (38) dnode_host_name ::= NK_IPTOKEN */
   -3,  /* (39) cmd ::= ALTER LOCAL NK_STRING */
   -4,  /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   -5,  /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   -5,  /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   -5,  /* (43) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   -5,  /* (44) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   -5,  /* (45) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   -5,  /* (46) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   -5,  /* (47) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   -5,  /* (48) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   -5,  /* (49) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   -4,  /* (50) cmd ::= DROP DATABASE exists_opt db_name */
   -2,  /* (51) cmd ::= USE db_name */
   -4,  /* (52) cmd ::= ALTER DATABASE db_name alter_db_options */
   -3,  /* (53) not_exists_opt ::= IF NOT EXISTS */
    0,  /* (54) not_exists_opt ::= */
   -2,  /* (55) exists_opt ::= IF EXISTS */
    0,  /* (56) exists_opt ::= */
    0,  /* (57) db_options ::= */
   -3,  /* (58) db_options ::= db_options BLOCKS NK_INTEGER */
   -3,  /* (59) db_options ::= db_options CACHE NK_INTEGER */
   -3,  /* (60) db_options ::= db_options CACHELAST NK_INTEGER */
   -3,  /* (61) db_options ::= db_options COMP NK_INTEGER */
   -3,  /* (62) db_options ::= db_options DAYS NK_INTEGER */
   -3,  /* (63) db_options ::= db_options DAYS NK_VARIABLE */
   -3,  /* (64) db_options ::= db_options FSYNC NK_INTEGER */
   -3,  /* (65) db_options ::= db_options MAXROWS NK_INTEGER */
   -3,  /* (66) db_options ::= db_options MINROWS NK_INTEGER */
   -3,  /* (67) db_options ::= db_options KEEP integer_list */
   -3,  /* (68) db_options ::= db_options KEEP variable_list */
   -3,  /* (69) db_options ::= db_options PRECISION NK_STRING */
   -3,  /* (70) db_options ::= db_options QUORUM NK_INTEGER */
   -3,  /* (71) db_options ::= db_options REPLICA NK_INTEGER */
   -3,  /* (72) db_options ::= db_options TTL NK_INTEGER */
   -3,  /* (73) db_options ::= db_options WAL NK_INTEGER */
   -3,  /* (74) db_options ::= db_options VGROUPS NK_INTEGER */
   -3,  /* (75) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   -3,  /* (76) db_options ::= db_options STREAM_MODE NK_INTEGER */
   -3,  /* (77) db_options ::= db_options RETENTIONS retention_list */
   -1,  /* (78) alter_db_options ::= alter_db_option */
   -2,  /* (79) alter_db_options ::= alter_db_options alter_db_option */
   -2,  /* (80) alter_db_option ::= BLOCKS NK_INTEGER */
   -2,  /* (81) alter_db_option ::= FSYNC NK_INTEGER */
   -2,  /* (82) alter_db_option ::= KEEP integer_list */
   -2,  /* (83) alter_db_option ::= KEEP variable_list */
   -2,  /* (84) alter_db_option ::= WAL NK_INTEGER */
   -2,  /* (85) alter_db_option ::= QUORUM NK_INTEGER */
   -2,  /* (86) alter_db_option ::= CACHELAST NK_INTEGER */
   -2,  /* (87) alter_db_option ::= REPLICA NK_INTEGER */
   -1,  /* (88) integer_list ::= NK_INTEGER */
   -3,  /* (89) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   -1,  /* (90) variable_list ::= NK_VARIABLE */
   -3,  /* (91) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   -1,  /* (92) retention_list ::= retention */
   -3,  /* (93) retention_list ::= retention_list NK_COMMA retention */
   -3,  /* (94) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
   -9,  /* (95) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   -3,  /* (96) cmd ::= CREATE TABLE multi_create_clause */
   -9,  /* (97) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   -3,  /* (98) cmd ::= DROP TABLE multi_drop_clause */
   -4,  /* (99) cmd ::= DROP STABLE exists_opt full_table_name */
   -3,  /* (100) cmd ::= ALTER TABLE alter_table_clause */
   -3,  /* (101) cmd ::= ALTER STABLE alter_table_clause */
   -2,  /* (102) alter_table_clause ::= full_table_name alter_table_options */
   -5,  /* (103) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   -4,  /* (104) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   -5,  /* (105) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   -5,  /* (106) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   -5,  /* (107) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   -4,  /* (108) alter_table_clause ::= full_table_name DROP TAG column_name */
   -5,  /* (109) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   -5,  /* (110) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   -6,  /* (111) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
   -1,  /* (112) multi_create_clause ::= create_subtable_clause */
   -2,  /* (113) multi_create_clause ::= multi_create_clause create_subtable_clause */
   -9,  /* (114) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
   -1,  /* (115) multi_drop_clause ::= drop_table_clause */
   -2,  /* (116) multi_drop_clause ::= multi_drop_clause drop_table_clause */
   -2,  /* (117) drop_table_clause ::= exists_opt full_table_name */
    0,  /* (118) specific_tags_opt ::= */
   -3,  /* (119) specific_tags_opt ::= NK_LP col_name_list NK_RP */
   -1,  /* (120) full_table_name ::= table_name */
   -3,  /* (121) full_table_name ::= db_name NK_DOT table_name */
   -1,  /* (122) column_def_list ::= column_def */
   -3,  /* (123) column_def_list ::= column_def_list NK_COMMA column_def */
   -2,  /* (124) column_def ::= column_name type_name */
   -4,  /* (125) column_def ::= column_name type_name COMMENT NK_STRING */
   -1,  /* (126) type_name ::= BOOL */
   -1,  /* (127) type_name ::= TINYINT */
   -1,  /* (128) type_name ::= SMALLINT */
   -1,  /* (129) type_name ::= INT */
   -1,  /* (130) type_name ::= INTEGER */
   -1,  /* (131) type_name ::= BIGINT */
   -1,  /* (132) type_name ::= FLOAT */
   -1,  /* (133) type_name ::= DOUBLE */
   -4,  /* (134) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (135) type_name ::= TIMESTAMP */
   -4,  /* (136) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   -2,  /* (137) type_name ::= TINYINT UNSIGNED */
   -2,  /* (138) type_name ::= SMALLINT UNSIGNED */
   -2,  /* (139) type_name ::= INT UNSIGNED */
   -2,  /* (140) type_name ::= BIGINT UNSIGNED */
   -1,  /* (141) type_name ::= JSON */
   -4,  /* (142) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   -1,  /* (143) type_name ::= MEDIUMBLOB */
   -1,  /* (144) type_name ::= BLOB */
   -4,  /* (145) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (146) type_name ::= DECIMAL */
   -4,  /* (147) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   -6,  /* (148) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
    0,  /* (149) tags_def_opt ::= */
   -1,  /* (150) tags_def_opt ::= tags_def */
   -4,  /* (151) tags_def ::= TAGS NK_LP column_def_list NK_RP */
    0,  /* (152) table_options ::= */
   -3,  /* (153) table_options ::= table_options COMMENT NK_STRING */
   -3,  /* (154) table_options ::= table_options KEEP integer_list */
   -3,  /* (155) table_options ::= table_options TTL NK_INTEGER */
   -5,  /* (156) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   -5,  /* (157) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
   -3,  /* (158) table_options ::= table_options FILE_FACTOR NK_FLOAT */
   -3,  /* (159) table_options ::= table_options DELAY NK_INTEGER */
   -1,  /* (160) alter_table_options ::= alter_table_option */
   -2,  /* (161) alter_table_options ::= alter_table_options alter_table_option */
   -2,  /* (162) alter_table_option ::= COMMENT NK_STRING */
   -2,  /* (163) alter_table_option ::= KEEP integer_list */
   -2,  /* (164) alter_table_option ::= TTL NK_INTEGER */
   -1,  /* (165) col_name_list ::= col_name */
   -3,  /* (166) col_name_list ::= col_name_list NK_COMMA col_name */
   -1,  /* (167) col_name ::= column_name */
   -2,  /* (168) cmd ::= SHOW DNODES */
   -2,  /* (169) cmd ::= SHOW USERS */
   -2,  /* (170) cmd ::= SHOW DATABASES */
   -4,  /* (171) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   -4,  /* (172) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   -3,  /* (173) cmd ::= SHOW db_name_cond_opt VGROUPS */
   -2,  /* (174) cmd ::= SHOW MNODES */
   -2,  /* (175) cmd ::= SHOW MODULES */
   -2,  /* (176) cmd ::= SHOW QNODES */
   -2,  /* (177) cmd ::= SHOW FUNCTIONS */
   -5,  /* (178) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   -2,  /* (179) cmd ::= SHOW STREAMS */
   -2,  /* (180) cmd ::= SHOW ACCOUNTS */
   -2,  /* (181) cmd ::= SHOW APPS */
   -2,  /* (182) cmd ::= SHOW CONNECTIONS */
   -2,  /* (183) cmd ::= SHOW LICENCE */
   -2,  /* (184) cmd ::= SHOW GRANTS */
   -4,  /* (185) cmd ::= SHOW CREATE DATABASE db_name */
   -4,  /* (186) cmd ::= SHOW CREATE TABLE full_table_name */
   -4,  /* (187) cmd ::= SHOW CREATE STABLE full_table_name */
   -2,  /* (188) cmd ::= SHOW QUERIES */
   -2,  /* (189) cmd ::= SHOW SCORES */
   -2,  /* (190) cmd ::= SHOW TOPICS */
   -2,  /* (191) cmd ::= SHOW VARIABLES */
   -2,  /* (192) cmd ::= SHOW BNODES */
   -2,  /* (193) cmd ::= SHOW SNODES */
    0,  /* (194) db_name_cond_opt ::= */
   -2,  /* (195) db_name_cond_opt ::= db_name NK_DOT */
    0,  /* (196) like_pattern_opt ::= */
   -2,  /* (197) like_pattern_opt ::= LIKE NK_STRING */
   -1,  /* (198) table_name_cond ::= table_name */
    0,  /* (199) from_db_opt ::= */
   -2,  /* (200) from_db_opt ::= FROM db_name */
   -1,  /* (201) func_name_list ::= func_name */
   -3,  /* (202) func_name_list ::= func_name_list NK_COMMA col_name */
   -1,  /* (203) func_name ::= function_name */
   -8,  /* (204) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  -10,  /* (205) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
   -6,  /* (206) cmd ::= DROP INDEX exists_opt index_name ON table_name */
    0,  /* (207) index_options ::= */
   -9,  /* (208) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  -11,  /* (209) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
   -1,  /* (210) func_list ::= func */
   -3,  /* (211) func_list ::= func_list NK_COMMA func */
   -4,  /* (212) func ::= function_name NK_LP expression_list NK_RP */
   -6,  /* (213) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
   -6,  /* (214) cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
   -4,  /* (215) cmd ::= DROP TOPIC exists_opt topic_name */
   -2,  /* (216) cmd ::= DESC full_table_name */
   -2,  /* (217) cmd ::= DESCRIBE full_table_name */
   -3,  /* (218) cmd ::= RESET QUERY CACHE */
   -4,  /* (219) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
    0,  /* (220) analyze_opt ::= */
   -1,  /* (221) analyze_opt ::= ANALYZE */
    0,  /* (222) explain_options ::= */
   -3,  /* (223) explain_options ::= explain_options VERBOSE NK_BOOL */
   -3,  /* (224) explain_options ::= explain_options RATIO NK_FLOAT */
   -6,  /* (225) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
   -9,  /* (226) cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
   -3,  /* (227) cmd ::= DROP FUNCTION function_name */
    0,  /* (228) agg_func_opt ::= */
   -1,  /* (229) agg_func_opt ::= AGGREGATE */
    0,  /* (230) bufsize_opt ::= */
   -2,  /* (231) bufsize_opt ::= BUFSIZE NK_INTEGER */
   -7,  /* (232) cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression */
   -3,  /* (233) cmd ::= DROP STREAM stream_name */
   -3,  /* (234) cmd ::= KILL CONNECTION NK_INTEGER */
   -3,  /* (235) cmd ::= KILL QUERY NK_INTEGER */
   -4,  /* (236) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   -4,  /* (237) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   -3,  /* (238) cmd ::= SPLIT VGROUP NK_INTEGER */
   -2,  /* (239) dnode_list ::= DNODE NK_INTEGER */
   -3,  /* (240) dnode_list ::= dnode_list DNODE NK_INTEGER */
   -3,  /* (241) cmd ::= SYNCDB db_name REPLICA */
   -1,  /* (242) cmd ::= query_expression */
   -1,  /* (243) literal ::= NK_INTEGER */
   -1,  /* (244) literal ::= NK_FLOAT */
   -1,  /* (245) literal ::= NK_STRING */
   -1,  /* (246) literal ::= NK_BOOL */
   -2,  /* (247) literal ::= TIMESTAMP NK_STRING */
   -1,  /* (248) literal ::= duration_literal */
   -1,  /* (249) literal ::= NULL */
   -1,  /* (250) duration_literal ::= NK_VARIABLE */
   -1,  /* (251) signed ::= NK_INTEGER */
   -2,  /* (252) signed ::= NK_PLUS NK_INTEGER */
   -2,  /* (253) signed ::= NK_MINUS NK_INTEGER */
   -1,  /* (254) signed ::= NK_FLOAT */
   -2,  /* (255) signed ::= NK_PLUS NK_FLOAT */
   -2,  /* (256) signed ::= NK_MINUS NK_FLOAT */
   -1,  /* (257) signed_literal ::= signed */
   -1,  /* (258) signed_literal ::= NK_STRING */
   -1,  /* (259) signed_literal ::= NK_BOOL */
   -2,  /* (260) signed_literal ::= TIMESTAMP NK_STRING */
   -1,  /* (261) signed_literal ::= duration_literal */
   -1,  /* (262) signed_literal ::= NULL */
   -1,  /* (263) literal_list ::= signed_literal */
   -3,  /* (264) literal_list ::= literal_list NK_COMMA signed_literal */
   -1,  /* (265) db_name ::= NK_ID */
   -1,  /* (266) table_name ::= NK_ID */
   -1,  /* (267) column_name ::= NK_ID */
   -1,  /* (268) function_name ::= NK_ID */
   -1,  /* (269) function_name ::= FIRST */
   -1,  /* (270) function_name ::= LAST */
   -1,  /* (271) function_name ::= NOW */
   -1,  /* (272) function_name ::= TODAY */
   -1,  /* (273) table_alias ::= NK_ID */
   -1,  /* (274) column_alias ::= NK_ID */
   -1,  /* (275) user_name ::= NK_ID */
   -1,  /* (276) index_name ::= NK_ID */
   -1,  /* (277) topic_name ::= NK_ID */
   -1,  /* (278) stream_name ::= NK_ID */
   -1,  /* (279) expression ::= literal */
   -1,  /* (280) expression ::= pseudo_column */
   -1,  /* (281) expression ::= column_reference */
   -4,  /* (282) expression ::= function_name NK_LP expression_list NK_RP */
   -4,  /* (283) expression ::= function_name NK_LP NK_STAR NK_RP */
   -3,  /* (284) expression ::= function_name NK_LP NK_RP */
   -6,  /* (285) expression ::= CAST NK_LP expression AS type_name NK_RP */
   -1,  /* (286) expression ::= subquery */
   -3,  /* (287) expression ::= NK_LP expression NK_RP */
   -2,  /* (288) expression ::= NK_PLUS expression */
   -2,  /* (289) expression ::= NK_MINUS expression */
   -3,  /* (290) expression ::= expression NK_PLUS expression */
   -3,  /* (291) expression ::= expression NK_MINUS expression */
   -3,  /* (292) expression ::= expression NK_STAR expression */
   -3,  /* (293) expression ::= expression NK_SLASH expression */
   -3,  /* (294) expression ::= expression NK_REM expression */
   -1,  /* (295) expression_list ::= expression */
   -3,  /* (296) expression_list ::= expression_list NK_COMMA expression */
   -1,  /* (297) column_reference ::= column_name */
   -3,  /* (298) column_reference ::= table_name NK_DOT column_name */
   -1,  /* (299) pseudo_column ::= ROWTS */
   -1,  /* (300) pseudo_column ::= TBNAME */
   -1,  /* (301) pseudo_column ::= QSTARTTS */
   -1,  /* (302) pseudo_column ::= QENDTS */
   -1,  /* (303) pseudo_column ::= WSTARTTS */
   -1,  /* (304) pseudo_column ::= WENDTS */
   -1,  /* (305) pseudo_column ::= WDURATION */
   -3,  /* (306) predicate ::= expression compare_op expression */
   -5,  /* (307) predicate ::= expression BETWEEN expression AND expression */
   -6,  /* (308) predicate ::= expression NOT BETWEEN expression AND expression */
   -3,  /* (309) predicate ::= expression IS NULL */
   -4,  /* (310) predicate ::= expression IS NOT NULL */
   -3,  /* (311) predicate ::= expression in_op in_predicate_value */
   -1,  /* (312) compare_op ::= NK_LT */
   -1,  /* (313) compare_op ::= NK_GT */
   -1,  /* (314) compare_op ::= NK_LE */
   -1,  /* (315) compare_op ::= NK_GE */
   -1,  /* (316) compare_op ::= NK_NE */
   -1,  /* (317) compare_op ::= NK_EQ */
   -1,  /* (318) compare_op ::= LIKE */
   -2,  /* (319) compare_op ::= NOT LIKE */
   -1,  /* (320) compare_op ::= MATCH */
   -1,  /* (321) compare_op ::= NMATCH */
   -1,  /* (322) in_op ::= IN */
   -2,  /* (323) in_op ::= NOT IN */
   -3,  /* (324) in_predicate_value ::= NK_LP expression_list NK_RP */
   -1,  /* (325) boolean_value_expression ::= boolean_primary */
   -2,  /* (326) boolean_value_expression ::= NOT boolean_primary */
   -3,  /* (327) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   -3,  /* (328) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   -1,  /* (329) boolean_primary ::= predicate */
   -3,  /* (330) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   -1,  /* (331) common_expression ::= expression */
   -1,  /* (332) common_expression ::= boolean_value_expression */
   -2,  /* (333) from_clause ::= FROM table_reference_list */
   -1,  /* (334) table_reference_list ::= table_reference */
   -3,  /* (335) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   -1,  /* (336) table_reference ::= table_primary */
   -1,  /* (337) table_reference ::= joined_table */
   -2,  /* (338) table_primary ::= table_name alias_opt */
   -4,  /* (339) table_primary ::= db_name NK_DOT table_name alias_opt */
   -2,  /* (340) table_primary ::= subquery alias_opt */
   -1,  /* (341) table_primary ::= parenthesized_joined_table */
    0,  /* (342) alias_opt ::= */
   -1,  /* (343) alias_opt ::= table_alias */
   -2,  /* (344) alias_opt ::= AS table_alias */
   -3,  /* (345) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   -3,  /* (346) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   -6,  /* (347) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
    0,  /* (348) join_type ::= */
   -1,  /* (349) join_type ::= INNER */
   -9,  /* (350) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
    0,  /* (351) set_quantifier_opt ::= */
   -1,  /* (352) set_quantifier_opt ::= DISTINCT */
   -1,  /* (353) set_quantifier_opt ::= ALL */
   -1,  /* (354) select_list ::= NK_STAR */
   -1,  /* (355) select_list ::= select_sublist */
   -1,  /* (356) select_sublist ::= select_item */
   -3,  /* (357) select_sublist ::= select_sublist NK_COMMA select_item */
   -1,  /* (358) select_item ::= common_expression */
   -2,  /* (359) select_item ::= common_expression column_alias */
   -3,  /* (360) select_item ::= common_expression AS column_alias */
   -3,  /* (361) select_item ::= table_name NK_DOT NK_STAR */
    0,  /* (362) where_clause_opt ::= */
   -2,  /* (363) where_clause_opt ::= WHERE search_condition */
    0,  /* (364) partition_by_clause_opt ::= */
   -3,  /* (365) partition_by_clause_opt ::= PARTITION BY expression_list */
    0,  /* (366) twindow_clause_opt ::= */
   -6,  /* (367) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   -4,  /* (368) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
   -6,  /* (369) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   -8,  /* (370) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
    0,  /* (371) sliding_opt ::= */
   -4,  /* (372) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
    0,  /* (373) fill_opt ::= */
   -4,  /* (374) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   -6,  /* (375) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
   -1,  /* (376) fill_mode ::= NONE */
   -1,  /* (377) fill_mode ::= PREV */
   -1,  /* (378) fill_mode ::= NULL */
   -1,  /* (379) fill_mode ::= LINEAR */
   -1,  /* (380) fill_mode ::= NEXT */
    0,  /* (381) group_by_clause_opt ::= */
   -3,  /* (382) group_by_clause_opt ::= GROUP BY group_by_list */
   -1,  /* (383) group_by_list ::= expression */
   -3,  /* (384) group_by_list ::= group_by_list NK_COMMA expression */
    0,  /* (385) having_clause_opt ::= */
   -2,  /* (386) having_clause_opt ::= HAVING search_condition */
   -4,  /* (387) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
   -1,  /* (388) query_expression_body ::= query_primary */
   -4,  /* (389) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
   -1,  /* (390) query_primary ::= query_specification */
    0,  /* (391) order_by_clause_opt ::= */
   -3,  /* (392) order_by_clause_opt ::= ORDER BY sort_specification_list */
    0,  /* (393) slimit_clause_opt ::= */
   -2,  /* (394) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   -4,  /* (395) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   -4,  /* (396) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
    0,  /* (397) limit_clause_opt ::= */
   -2,  /* (398) limit_clause_opt ::= LIMIT NK_INTEGER */
   -4,  /* (399) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   -4,  /* (400) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   -3,  /* (401) subquery ::= NK_LP query_expression NK_RP */
   -1,  /* (402) search_condition ::= common_expression */
   -1,  /* (403) sort_specification_list ::= sort_specification */
   -3,  /* (404) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   -3,  /* (405) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
    0,  /* (406) ordering_specification_opt ::= */
   -1,  /* (407) ordering_specification_opt ::= ASC */
   -1,  /* (408) ordering_specification_opt ::= DESC */
    0,  /* (409) null_ordering_opt ::= */
   -2,  /* (410) null_ordering_opt ::= NULLS FIRST */
   -2,  /* (411) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfoNRhs[yyruleno];
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
        yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,211,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,212,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,211,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,213,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,214,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,212,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,214,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,213,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy409, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy409, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy409, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy409); }
        break;
      case 28: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy409, NULL); }
        break;
      case 29: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy409, &yymsp[0].minor.yy0); }
        break;
      case 30: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 31: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy409); }
        break;
      case 32: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 33: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 34: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 35: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 36: /* dnode_endpoint ::= NK_STRING */
      case 37: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==37);
      case 38: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==38);
      case 265: /* db_name ::= NK_ID */ yytestcase(yyruleno==265);
      case 266: /* table_name ::= NK_ID */ yytestcase(yyruleno==266);
      case 267: /* column_name ::= NK_ID */ yytestcase(yyruleno==267);
      case 268: /* function_name ::= NK_ID */ yytestcase(yyruleno==268);
      case 269: /* function_name ::= FIRST */ yytestcase(yyruleno==269);
      case 270: /* function_name ::= LAST */ yytestcase(yyruleno==270);
      case 271: /* function_name ::= NOW */ yytestcase(yyruleno==271);
      case 272: /* function_name ::= TODAY */ yytestcase(yyruleno==272);
      case 273: /* table_alias ::= NK_ID */ yytestcase(yyruleno==273);
      case 274: /* column_alias ::= NK_ID */ yytestcase(yyruleno==274);
      case 275: /* user_name ::= NK_ID */ yytestcase(yyruleno==275);
      case 276: /* index_name ::= NK_ID */ yytestcase(yyruleno==276);
      case 277: /* topic_name ::= NK_ID */ yytestcase(yyruleno==277);
      case 278: /* stream_name ::= NK_ID */ yytestcase(yyruleno==278);
{ yylhsminor.yy409 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy409 = yylhsminor.yy409;
        break;
      case 39: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 40: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 42: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 46: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy121, &yymsp[-1].minor.yy409, yymsp[0].minor.yy504); }
        break;
      case 50: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy121, &yymsp[0].minor.yy409); }
        break;
      case 51: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy409); }
        break;
      case 52: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy409, yymsp[0].minor.yy504); }
        break;
      case 53: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy121 = true; }
        break;
      case 54: /* not_exists_opt ::= */
      case 56: /* exists_opt ::= */ yytestcase(yyruleno==56);
      case 220: /* analyze_opt ::= */ yytestcase(yyruleno==220);
      case 228: /* agg_func_opt ::= */ yytestcase(yyruleno==228);
      case 351: /* set_quantifier_opt ::= */ yytestcase(yyruleno==351);
{ yymsp[1].minor.yy121 = false; }
        break;
      case 55: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy121 = true; }
        break;
      case 57: /* db_options ::= */
{ yymsp[1].minor.yy504 = createDatabaseOptions(pCxt); }
        break;
      case 58: /* db_options ::= db_options BLOCKS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy504)->pNumOfBlocks = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 59: /* db_options ::= db_options CACHE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy504)->pCacheBlockSize = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 60: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy504)->pCachelast = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 61: /* db_options ::= db_options COMP NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy504)->pCompressionLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 62: /* db_options ::= db_options DAYS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy504)->pDaysPerFile = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 63: /* db_options ::= db_options DAYS NK_VARIABLE */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy504)->pDaysPerFile = (SValueNode*)createDurationValueNode(pCxt, &yymsp[0].minor.yy0); yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 64: /* db_options ::= db_options FSYNC NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy504)->pFsyncPeriod = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 65: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy504)->pMaxRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 66: /* db_options ::= db_options MINROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy504)->pMinRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 67: /* db_options ::= db_options KEEP integer_list */
      case 68: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==68);
{ ((SDatabaseOptions*)yymsp[-2].minor.yy504)->pKeep = yymsp[0].minor.yy488; yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 69: /* db_options ::= db_options PRECISION NK_STRING */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy504)->pPrecision = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 70: /* db_options ::= db_options QUORUM NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy504)->pQuorum = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 71: /* db_options ::= db_options REPLICA NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy504)->pReplica = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 72: /* db_options ::= db_options TTL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy504)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 73: /* db_options ::= db_options WAL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy504)->pWalLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 74: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy504)->pNumOfVgroups = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 75: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy504)->pSingleStable = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 76: /* db_options ::= db_options STREAM_MODE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy504)->pStreamMode = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 77: /* db_options ::= db_options RETENTIONS retention_list */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy504)->pRetentions = yymsp[0].minor.yy488; yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 78: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy504 = createDatabaseOptions(pCxt); yylhsminor.yy504 = setDatabaseAlterOption(pCxt, yylhsminor.yy504, &yymsp[0].minor.yy21); }
  yymsp[0].minor.yy504 = yylhsminor.yy504;
        break;
      case 79: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy504 = setDatabaseAlterOption(pCxt, yymsp[-1].minor.yy504, &yymsp[0].minor.yy21); }
  yymsp[-1].minor.yy504 = yylhsminor.yy504;
        break;
      case 80: /* alter_db_option ::= BLOCKS NK_INTEGER */
{ yymsp[-1].minor.yy21.type = DB_OPTION_BLOCKS; yymsp[-1].minor.yy21.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 81: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy21.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy21.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 82: /* alter_db_option ::= KEEP integer_list */
      case 83: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==83);
{ yymsp[-1].minor.yy21.type = DB_OPTION_KEEP; yymsp[-1].minor.yy21.pList = yymsp[0].minor.yy488; }
        break;
      case 84: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy21.type = DB_OPTION_WAL; yymsp[-1].minor.yy21.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 85: /* alter_db_option ::= QUORUM NK_INTEGER */
{ yymsp[-1].minor.yy21.type = DB_OPTION_QUORUM; yymsp[-1].minor.yy21.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 86: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy21.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy21.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 87: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy21.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy21.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 88: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy488 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy488 = yylhsminor.yy488;
        break;
      case 89: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 240: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==240);
{ yylhsminor.yy488 = addNodeToList(pCxt, yymsp[-2].minor.yy488, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy488 = yylhsminor.yy488;
        break;
      case 90: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy488 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy488 = yylhsminor.yy488;
        break;
      case 91: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy488 = addNodeToList(pCxt, yymsp[-2].minor.yy488, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy488 = yylhsminor.yy488;
        break;
      case 92: /* retention_list ::= retention */
      case 112: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==112);
      case 115: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==115);
      case 122: /* column_def_list ::= column_def */ yytestcase(yyruleno==122);
      case 165: /* col_name_list ::= col_name */ yytestcase(yyruleno==165);
      case 201: /* func_name_list ::= func_name */ yytestcase(yyruleno==201);
      case 210: /* func_list ::= func */ yytestcase(yyruleno==210);
      case 263: /* literal_list ::= signed_literal */ yytestcase(yyruleno==263);
      case 356: /* select_sublist ::= select_item */ yytestcase(yyruleno==356);
      case 403: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==403);
{ yylhsminor.yy488 = createNodeList(pCxt, yymsp[0].minor.yy504); }
  yymsp[0].minor.yy488 = yylhsminor.yy488;
        break;
      case 93: /* retention_list ::= retention_list NK_COMMA retention */
      case 123: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==123);
      case 166: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==166);
      case 202: /* func_name_list ::= func_name_list NK_COMMA col_name */ yytestcase(yyruleno==202);
      case 211: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==211);
      case 264: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==264);
      case 357: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==357);
      case 404: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==404);
{ yylhsminor.yy488 = addNodeToList(pCxt, yymsp[-2].minor.yy488, yymsp[0].minor.yy504); }
  yymsp[-2].minor.yy488 = yylhsminor.yy488;
        break;
      case 94: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy504 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 95: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 97: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==97);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy121, yymsp[-5].minor.yy504, yymsp[-3].minor.yy488, yymsp[-1].minor.yy488, yymsp[0].minor.yy504); }
        break;
      case 96: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy488); }
        break;
      case 98: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy488); }
        break;
      case 99: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy121, yymsp[0].minor.yy504); }
        break;
      case 100: /* cmd ::= ALTER TABLE alter_table_clause */
      case 101: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==101);
      case 242: /* cmd ::= query_expression */ yytestcase(yyruleno==242);
{ pCxt->pRootNode = yymsp[0].minor.yy504; }
        break;
      case 102: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy504 = createAlterTableOption(pCxt, yymsp[-1].minor.yy504, yymsp[0].minor.yy504); }
  yymsp[-1].minor.yy504 = yylhsminor.yy504;
        break;
      case 103: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy504 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy504, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy409, yymsp[0].minor.yy160); }
  yymsp[-4].minor.yy504 = yylhsminor.yy504;
        break;
      case 104: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy504 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy504, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy409); }
  yymsp[-3].minor.yy504 = yylhsminor.yy504;
        break;
      case 105: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy504 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy504, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy409, yymsp[0].minor.yy160); }
  yymsp[-4].minor.yy504 = yylhsminor.yy504;
        break;
      case 106: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy504 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy504, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy409, &yymsp[0].minor.yy409); }
  yymsp[-4].minor.yy504 = yylhsminor.yy504;
        break;
      case 107: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy504 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy504, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy409, yymsp[0].minor.yy160); }
  yymsp[-4].minor.yy504 = yylhsminor.yy504;
        break;
      case 108: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy504 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy504, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy409); }
  yymsp[-3].minor.yy504 = yylhsminor.yy504;
        break;
      case 109: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy504 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy504, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy409, yymsp[0].minor.yy160); }
  yymsp[-4].minor.yy504 = yylhsminor.yy504;
        break;
      case 110: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy504 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy504, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy409, &yymsp[0].minor.yy409); }
  yymsp[-4].minor.yy504 = yylhsminor.yy504;
        break;
      case 111: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
{ yylhsminor.yy504 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy504, &yymsp[-2].minor.yy409, yymsp[0].minor.yy504); }
  yymsp[-5].minor.yy504 = yylhsminor.yy504;
        break;
      case 113: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 116: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==116);
{ yylhsminor.yy488 = addNodeToList(pCxt, yymsp[-1].minor.yy488, yymsp[0].minor.yy504); }
  yymsp[-1].minor.yy488 = yylhsminor.yy488;
        break;
      case 114: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
{ yylhsminor.yy504 = createCreateSubTableClause(pCxt, yymsp[-8].minor.yy121, yymsp[-7].minor.yy504, yymsp[-5].minor.yy504, yymsp[-4].minor.yy488, yymsp[-1].minor.yy488); }
  yymsp[-8].minor.yy504 = yylhsminor.yy504;
        break;
      case 117: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy504 = createDropTableClause(pCxt, yymsp[-1].minor.yy121, yymsp[0].minor.yy504); }
  yymsp[-1].minor.yy504 = yylhsminor.yy504;
        break;
      case 118: /* specific_tags_opt ::= */
      case 149: /* tags_def_opt ::= */ yytestcase(yyruleno==149);
      case 364: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==364);
      case 381: /* group_by_clause_opt ::= */ yytestcase(yyruleno==381);
      case 391: /* order_by_clause_opt ::= */ yytestcase(yyruleno==391);
{ yymsp[1].minor.yy488 = NULL; }
        break;
      case 119: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy488 = yymsp[-1].minor.yy488; }
        break;
      case 120: /* full_table_name ::= table_name */
{ yylhsminor.yy504 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy409, NULL); }
  yymsp[0].minor.yy504 = yylhsminor.yy504;
        break;
      case 121: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy504 = createRealTableNode(pCxt, &yymsp[-2].minor.yy409, &yymsp[0].minor.yy409, NULL); }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 124: /* column_def ::= column_name type_name */
{ yylhsminor.yy504 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy409, yymsp[0].minor.yy160, NULL); }
  yymsp[-1].minor.yy504 = yylhsminor.yy504;
        break;
      case 125: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy504 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy409, yymsp[-2].minor.yy160, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy504 = yylhsminor.yy504;
        break;
      case 126: /* type_name ::= BOOL */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 127: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 128: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 129: /* type_name ::= INT */
      case 130: /* type_name ::= INTEGER */ yytestcase(yyruleno==130);
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 131: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 132: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 133: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 134: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy160 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 135: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 136: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy160 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 137: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy160 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 138: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy160 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 139: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy160 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 140: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy160 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 141: /* type_name ::= JSON */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 142: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy160 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 143: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 144: /* type_name ::= BLOB */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 145: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy160 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 146: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy160 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 147: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy160 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 148: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy160 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 150: /* tags_def_opt ::= tags_def */
      case 355: /* select_list ::= select_sublist */ yytestcase(yyruleno==355);
{ yylhsminor.yy488 = yymsp[0].minor.yy488; }
  yymsp[0].minor.yy488 = yylhsminor.yy488;
        break;
      case 151: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy488 = yymsp[-1].minor.yy488; }
        break;
      case 152: /* table_options ::= */
{ yymsp[1].minor.yy504 = createTableOptions(pCxt); }
        break;
      case 153: /* table_options ::= table_options COMMENT NK_STRING */
{ ((STableOptions*)yymsp[-2].minor.yy504)->pComments = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 154: /* table_options ::= table_options KEEP integer_list */
{ ((STableOptions*)yymsp[-2].minor.yy504)->pKeep = yymsp[0].minor.yy488; yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 155: /* table_options ::= table_options TTL NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy504)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 156: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy504)->pSma = yymsp[-1].minor.yy488; yylhsminor.yy504 = yymsp[-4].minor.yy504; }
  yymsp[-4].minor.yy504 = yylhsminor.yy504;
        break;
      case 157: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy504)->pFuncs = yymsp[-1].minor.yy488; yylhsminor.yy504 = yymsp[-4].minor.yy504; }
  yymsp[-4].minor.yy504 = yylhsminor.yy504;
        break;
      case 158: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ ((STableOptions*)yymsp[-2].minor.yy504)->pFilesFactor = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 159: /* table_options ::= table_options DELAY NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy504)->pDelay = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy504 = yymsp[-2].minor.yy504; }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 160: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy504 = createTableOptions(pCxt); yylhsminor.yy504 = setTableAlterOption(pCxt, yylhsminor.yy504, &yymsp[0].minor.yy21); }
  yymsp[0].minor.yy504 = yylhsminor.yy504;
        break;
      case 161: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy504 = setTableAlterOption(pCxt, yymsp[-1].minor.yy504, &yymsp[0].minor.yy21); }
  yymsp[-1].minor.yy504 = yylhsminor.yy504;
        break;
      case 162: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy21.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy21.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 163: /* alter_table_option ::= KEEP integer_list */
{ yymsp[-1].minor.yy21.type = TABLE_OPTION_KEEP; yymsp[-1].minor.yy21.pList = yymsp[0].minor.yy488; }
        break;
      case 164: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy21.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy21.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 167: /* col_name ::= column_name */
{ yylhsminor.yy504 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy409); }
  yymsp[0].minor.yy504 = yylhsminor.yy504;
        break;
      case 168: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 169: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 170: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 171: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy504, yymsp[0].minor.yy504); }
        break;
      case 172: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy504, yymsp[0].minor.yy504); }
        break;
      case 173: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy504, NULL); }
        break;
      case 174: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 175: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 176: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 177: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 178: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy504, yymsp[0].minor.yy504); }
        break;
      case 179: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 180: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 181: /* cmd ::= SHOW APPS */
//{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 182: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 183: /* cmd ::= SHOW LICENCE */
      case 184: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==184);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 185: /* cmd ::= SHOW CREATE DATABASE db_name */
//{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy409); }
        break;
      case 186: /* cmd ::= SHOW CREATE TABLE full_table_name */
//{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy504); }
        break;
      case 187: /* cmd ::= SHOW CREATE STABLE full_table_name */
//{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy504); }
        break;
      case 188: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 189: /* cmd ::= SHOW SCORES */
//{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 190: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 191: /* cmd ::= SHOW VARIABLES */
//{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 192: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT, NULL, NULL); }
        break;
      case 193: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT, NULL, NULL); }
        break;
      case 194: /* db_name_cond_opt ::= */
      case 199: /* from_db_opt ::= */ yytestcase(yyruleno==199);
{ yymsp[1].minor.yy504 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 195: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy504 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy409); }
  yymsp[-1].minor.yy504 = yylhsminor.yy504;
        break;
      case 196: /* like_pattern_opt ::= */
      case 207: /* index_options ::= */ yytestcase(yyruleno==207);
      case 362: /* where_clause_opt ::= */ yytestcase(yyruleno==362);
      case 366: /* twindow_clause_opt ::= */ yytestcase(yyruleno==366);
      case 371: /* sliding_opt ::= */ yytestcase(yyruleno==371);
      case 373: /* fill_opt ::= */ yytestcase(yyruleno==373);
      case 385: /* having_clause_opt ::= */ yytestcase(yyruleno==385);
      case 393: /* slimit_clause_opt ::= */ yytestcase(yyruleno==393);
      case 397: /* limit_clause_opt ::= */ yytestcase(yyruleno==397);
{ yymsp[1].minor.yy504 = NULL; }
        break;
      case 197: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy504 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 198: /* table_name_cond ::= table_name */
{ yylhsminor.yy504 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy409); }
  yymsp[0].minor.yy504 = yylhsminor.yy504;
        break;
      case 200: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy504 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy409); }
        break;
      case 203: /* func_name ::= function_name */
{ yylhsminor.yy504 = createFunctionNode(pCxt, &yymsp[0].minor.yy409, NULL); }
  yymsp[0].minor.yy504 = yylhsminor.yy504;
        break;
      case 204: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy121, &yymsp[-3].minor.yy409, &yymsp[-1].minor.yy409, NULL, yymsp[0].minor.yy504); }
        break;
      case 205: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy121, &yymsp[-5].minor.yy409, &yymsp[-3].minor.yy409, yymsp[-1].minor.yy488, NULL); }
        break;
      case 206: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy121, &yymsp[-2].minor.yy409, &yymsp[0].minor.yy409); }
        break;
      case 208: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy504 = createIndexOption(pCxt, yymsp[-6].minor.yy488, releaseRawExprNode(pCxt, yymsp[-2].minor.yy504), NULL, yymsp[0].minor.yy504); }
        break;
      case 209: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy504 = createIndexOption(pCxt, yymsp[-8].minor.yy488, releaseRawExprNode(pCxt, yymsp[-4].minor.yy504), releaseRawExprNode(pCxt, yymsp[-2].minor.yy504), yymsp[0].minor.yy504); }
        break;
      case 212: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy504 = createFunctionNode(pCxt, &yymsp[-3].minor.yy409, yymsp[-1].minor.yy488); }
  yymsp[-3].minor.yy504 = yylhsminor.yy504;
        break;
      case 213: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy121, &yymsp[-2].minor.yy409, yymsp[0].minor.yy504, NULL); }
        break;
      case 214: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy121, &yymsp[-2].minor.yy409, NULL, &yymsp[0].minor.yy409); }
        break;
      case 215: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy121, &yymsp[0].minor.yy409); }
        break;
      case 216: /* cmd ::= DESC full_table_name */
      case 217: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==217);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy504); }
        break;
      case 218: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 219: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy121, yymsp[-1].minor.yy504, yymsp[0].minor.yy504); }
        break;
      case 221: /* analyze_opt ::= ANALYZE */
      case 229: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==229);
      case 352: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==352);
{ yymsp[0].minor.yy121 = true; }
        break;
      case 222: /* explain_options ::= */
{ yymsp[1].minor.yy504 = createDefaultExplainOptions(pCxt); }
        break;
      case 223: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy504 = setExplainVerbose(pCxt, yymsp[-2].minor.yy504, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 224: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy504 = setExplainRatio(pCxt, yymsp[-2].minor.yy504, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 225: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy488); }
        break;
      case 226: /* cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy121, &yymsp[-5].minor.yy409, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy160, yymsp[0].minor.yy452); }
        break;
      case 227: /* cmd ::= DROP FUNCTION function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, &yymsp[0].minor.yy409); }
        break;
      case 230: /* bufsize_opt ::= */
{ yymsp[1].minor.yy452 = 0; }
        break;
      case 231: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy452 = strtol(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 232: /* cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, &yymsp[-4].minor.yy409, &yymsp[-2].minor.yy409, yymsp[0].minor.yy504); }
        break;
      case 233: /* cmd ::= DROP STREAM stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, &yymsp[0].minor.yy409); }
        break;
      case 234: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 235: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 236: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 237: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy488); }
        break;
      case 238: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 239: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy488 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 241: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy409); }
        break;
      case 243: /* literal ::= NK_INTEGER */
{ yylhsminor.yy504 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy504 = yylhsminor.yy504;
        break;
      case 244: /* literal ::= NK_FLOAT */
{ yylhsminor.yy504 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy504 = yylhsminor.yy504;
        break;
      case 245: /* literal ::= NK_STRING */
{ yylhsminor.yy504 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy504 = yylhsminor.yy504;
        break;
      case 246: /* literal ::= NK_BOOL */
{ yylhsminor.yy504 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy504 = yylhsminor.yy504;
        break;
      case 247: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy504 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy504 = yylhsminor.yy504;
        break;
      case 248: /* literal ::= duration_literal */
      case 257: /* signed_literal ::= signed */ yytestcase(yyruleno==257);
      case 279: /* expression ::= literal */ yytestcase(yyruleno==279);
      case 280: /* expression ::= pseudo_column */ yytestcase(yyruleno==280);
      case 281: /* expression ::= column_reference */ yytestcase(yyruleno==281);
      case 286: /* expression ::= subquery */ yytestcase(yyruleno==286);
      case 325: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==325);
      case 329: /* boolean_primary ::= predicate */ yytestcase(yyruleno==329);
      case 331: /* common_expression ::= expression */ yytestcase(yyruleno==331);
      case 332: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==332);
      case 334: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==334);
      case 336: /* table_reference ::= table_primary */ yytestcase(yyruleno==336);
      case 337: /* table_reference ::= joined_table */ yytestcase(yyruleno==337);
      case 341: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==341);
      case 388: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==388);
      case 390: /* query_primary ::= query_specification */ yytestcase(yyruleno==390);
{ yylhsminor.yy504 = yymsp[0].minor.yy504; }
  yymsp[0].minor.yy504 = yylhsminor.yy504;
        break;
      case 249: /* literal ::= NULL */
{ yylhsminor.yy504 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL)); }
  yymsp[0].minor.yy504 = yylhsminor.yy504;
        break;
      case 250: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy504 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy504 = yylhsminor.yy504;
        break;
      case 251: /* signed ::= NK_INTEGER */
{ yylhsminor.yy504 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy504 = yylhsminor.yy504;
        break;
      case 252: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy504 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 253: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy504 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy504 = yylhsminor.yy504;
        break;
      case 254: /* signed ::= NK_FLOAT */
{ yylhsminor.yy504 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy504 = yylhsminor.yy504;
        break;
      case 255: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy504 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 256: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy504 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy504 = yylhsminor.yy504;
        break;
      case 258: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy504 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy504 = yylhsminor.yy504;
        break;
      case 259: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy504 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy504 = yylhsminor.yy504;
        break;
      case 260: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy504 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 261: /* signed_literal ::= duration_literal */
      case 358: /* select_item ::= common_expression */ yytestcase(yyruleno==358);
      case 402: /* search_condition ::= common_expression */ yytestcase(yyruleno==402);
{ yylhsminor.yy504 = releaseRawExprNode(pCxt, yymsp[0].minor.yy504); }
  yymsp[0].minor.yy504 = yylhsminor.yy504;
        break;
      case 262: /* signed_literal ::= NULL */
{ yymsp[0].minor.yy504 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL); }
        break;
      case 282: /* expression ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy504 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy409, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy409, yymsp[-1].minor.yy488)); }
  yymsp[-3].minor.yy504 = yylhsminor.yy504;
        break;
      case 283: /* expression ::= function_name NK_LP NK_STAR NK_RP */
{ yylhsminor.yy504 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy409, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy409, createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy0)))); }
  yymsp[-3].minor.yy504 = yylhsminor.yy504;
        break;
      case 284: /* expression ::= function_name NK_LP NK_RP */
{ yylhsminor.yy504 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy409, &yymsp[0].minor.yy0, createFunctionNodeNoParam(pCxt, &yymsp[-2].minor.yy409)); }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 285: /* expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy504 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy504), yymsp[-1].minor.yy160)); }
  yymsp[-5].minor.yy504 = yylhsminor.yy504;
        break;
      case 287: /* expression ::= NK_LP expression NK_RP */
      case 330: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==330);
{ yylhsminor.yy504 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy504)); }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 288: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy504);
                                                                                    yylhsminor.yy504 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy504));
                                                                                  }
  yymsp[-1].minor.yy504 = yylhsminor.yy504;
        break;
      case 289: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy504);
                                                                                    yylhsminor.yy504 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy504), NULL));
                                                                                  }
  yymsp[-1].minor.yy504 = yylhsminor.yy504;
        break;
      case 290: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy504);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy504);
                                                                                    yylhsminor.yy504 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy504), releaseRawExprNode(pCxt, yymsp[0].minor.yy504))); 
                                                                                  }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 291: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy504);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy504);
                                                                                    yylhsminor.yy504 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy504), releaseRawExprNode(pCxt, yymsp[0].minor.yy504))); 
                                                                                  }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 292: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy504);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy504);
                                                                                    yylhsminor.yy504 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy504), releaseRawExprNode(pCxt, yymsp[0].minor.yy504))); 
                                                                                  }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 293: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy504);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy504);
                                                                                    yylhsminor.yy504 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy504), releaseRawExprNode(pCxt, yymsp[0].minor.yy504))); 
                                                                                  }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 294: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy504);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy504);
                                                                                    yylhsminor.yy504 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy504), releaseRawExprNode(pCxt, yymsp[0].minor.yy504))); 
                                                                                  }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 295: /* expression_list ::= expression */
{ yylhsminor.yy488 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy504)); }
  yymsp[0].minor.yy488 = yylhsminor.yy488;
        break;
      case 296: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy488 = addNodeToList(pCxt, yymsp[-2].minor.yy488, releaseRawExprNode(pCxt, yymsp[0].minor.yy504)); }
  yymsp[-2].minor.yy488 = yylhsminor.yy488;
        break;
      case 297: /* column_reference ::= column_name */
{ yylhsminor.yy504 = createRawExprNode(pCxt, &yymsp[0].minor.yy409, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy409)); }
  yymsp[0].minor.yy504 = yylhsminor.yy504;
        break;
      case 298: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy504 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy409, &yymsp[0].minor.yy409, createColumnNode(pCxt, &yymsp[-2].minor.yy409, &yymsp[0].minor.yy409)); }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 299: /* pseudo_column ::= ROWTS */
      case 300: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==300);
      case 301: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==301);
      case 302: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==302);
      case 303: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==303);
      case 304: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==304);
      case 305: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==305);
{ yylhsminor.yy504 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy504 = yylhsminor.yy504;
        break;
      case 306: /* predicate ::= expression compare_op expression */
      case 311: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==311);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy504);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy504);
                                                                                    yylhsminor.yy504 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy84, releaseRawExprNode(pCxt, yymsp[-2].minor.yy504), releaseRawExprNode(pCxt, yymsp[0].minor.yy504)));
                                                                                  }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 307: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy504);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy504);
                                                                                    yylhsminor.yy504 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy504), releaseRawExprNode(pCxt, yymsp[-2].minor.yy504), releaseRawExprNode(pCxt, yymsp[0].minor.yy504)));
                                                                                  }
  yymsp[-4].minor.yy504 = yylhsminor.yy504;
        break;
      case 308: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy504);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy504);
                                                                                    yylhsminor.yy504 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy504), releaseRawExprNode(pCxt, yymsp[-5].minor.yy504), releaseRawExprNode(pCxt, yymsp[0].minor.yy504)));
                                                                                  }
  yymsp[-5].minor.yy504 = yylhsminor.yy504;
        break;
      case 309: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy504);
                                                                                    yylhsminor.yy504 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy504), NULL));
                                                                                  }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 310: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy504);
                                                                                    yylhsminor.yy504 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy504), NULL));
                                                                                  }
  yymsp[-3].minor.yy504 = yylhsminor.yy504;
        break;
      case 312: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy84 = OP_TYPE_LOWER_THAN; }
        break;
      case 313: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy84 = OP_TYPE_GREATER_THAN; }
        break;
      case 314: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy84 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 315: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy84 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 316: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy84 = OP_TYPE_NOT_EQUAL; }
        break;
      case 317: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy84 = OP_TYPE_EQUAL; }
        break;
      case 318: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy84 = OP_TYPE_LIKE; }
        break;
      case 319: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy84 = OP_TYPE_NOT_LIKE; }
        break;
      case 320: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy84 = OP_TYPE_MATCH; }
        break;
      case 321: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy84 = OP_TYPE_NMATCH; }
        break;
      case 322: /* in_op ::= IN */
{ yymsp[0].minor.yy84 = OP_TYPE_IN; }
        break;
      case 323: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy84 = OP_TYPE_NOT_IN; }
        break;
      case 324: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy504 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy488)); }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 326: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy504);
                                                                                    yylhsminor.yy504 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy504), NULL));
                                                                                  }
  yymsp[-1].minor.yy504 = yylhsminor.yy504;
        break;
      case 327: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy504);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy504);
                                                                                    yylhsminor.yy504 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy504), releaseRawExprNode(pCxt, yymsp[0].minor.yy504)));
                                                                                  }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 328: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy504);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy504);
                                                                                    yylhsminor.yy504 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy504), releaseRawExprNode(pCxt, yymsp[0].minor.yy504)));
                                                                                  }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 333: /* from_clause ::= FROM table_reference_list */
      case 363: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==363);
      case 386: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==386);
{ yymsp[-1].minor.yy504 = yymsp[0].minor.yy504; }
        break;
      case 335: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy504 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy504, yymsp[0].minor.yy504, NULL); }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 338: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy504 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy409, &yymsp[0].minor.yy409); }
  yymsp[-1].minor.yy504 = yylhsminor.yy504;
        break;
      case 339: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy504 = createRealTableNode(pCxt, &yymsp[-3].minor.yy409, &yymsp[-1].minor.yy409, &yymsp[0].minor.yy409); }
  yymsp[-3].minor.yy504 = yylhsminor.yy504;
        break;
      case 340: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy504 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy504), &yymsp[0].minor.yy409); }
  yymsp[-1].minor.yy504 = yylhsminor.yy504;
        break;
      case 342: /* alias_opt ::= */
{ yymsp[1].minor.yy409 = nil_token;  }
        break;
      case 343: /* alias_opt ::= table_alias */
{ yylhsminor.yy409 = yymsp[0].minor.yy409; }
  yymsp[0].minor.yy409 = yylhsminor.yy409;
        break;
      case 344: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy409 = yymsp[0].minor.yy409; }
        break;
      case 345: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 346: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==346);
{ yymsp[-2].minor.yy504 = yymsp[-1].minor.yy504; }
        break;
      case 347: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy504 = createJoinTableNode(pCxt, yymsp[-4].minor.yy556, yymsp[-5].minor.yy504, yymsp[-2].minor.yy504, yymsp[0].minor.yy504); }
  yymsp[-5].minor.yy504 = yylhsminor.yy504;
        break;
      case 348: /* join_type ::= */
{ yymsp[1].minor.yy556 = JOIN_TYPE_INNER; }
        break;
      case 349: /* join_type ::= INNER */
{ yymsp[0].minor.yy556 = JOIN_TYPE_INNER; }
        break;
      case 350: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy504 = createSelectStmt(pCxt, yymsp[-7].minor.yy121, yymsp[-6].minor.yy488, yymsp[-5].minor.yy504);
                                                                                    yymsp[-8].minor.yy504 = addWhereClause(pCxt, yymsp[-8].minor.yy504, yymsp[-4].minor.yy504);
                                                                                    yymsp[-8].minor.yy504 = addPartitionByClause(pCxt, yymsp[-8].minor.yy504, yymsp[-3].minor.yy488);
                                                                                    yymsp[-8].minor.yy504 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy504, yymsp[-2].minor.yy504);
                                                                                    yymsp[-8].minor.yy504 = addGroupByClause(pCxt, yymsp[-8].minor.yy504, yymsp[-1].minor.yy488);
                                                                                    yymsp[-8].minor.yy504 = addHavingClause(pCxt, yymsp[-8].minor.yy504, yymsp[0].minor.yy504);
                                                                                  }
        break;
      case 353: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy121 = false; }
        break;
      case 354: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy488 = NULL; }
        break;
      case 359: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy504 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy504), &yymsp[0].minor.yy409); }
  yymsp[-1].minor.yy504 = yylhsminor.yy504;
        break;
      case 360: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy504 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy504), &yymsp[0].minor.yy409); }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 361: /* select_item ::= table_name NK_DOT NK_STAR */
{ yylhsminor.yy504 = createColumnNode(pCxt, &yymsp[-2].minor.yy409, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 365: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 382: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==382);
      case 392: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==392);
{ yymsp[-2].minor.yy488 = yymsp[0].minor.yy488; }
        break;
      case 367: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy504 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy504), releaseRawExprNode(pCxt, yymsp[-1].minor.yy504)); }
        break;
      case 368: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy504 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy504)); }
        break;
      case 369: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy504 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy504), NULL, yymsp[-1].minor.yy504, yymsp[0].minor.yy504); }
        break;
      case 370: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy504 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy504), releaseRawExprNode(pCxt, yymsp[-3].minor.yy504), yymsp[-1].minor.yy504, yymsp[0].minor.yy504); }
        break;
      case 372: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy504 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy504); }
        break;
      case 374: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy504 = createFillNode(pCxt, yymsp[-1].minor.yy22, NULL); }
        break;
      case 375: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy504 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy488)); }
        break;
      case 376: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy22 = FILL_MODE_NONE; }
        break;
      case 377: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy22 = FILL_MODE_PREV; }
        break;
      case 378: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy22 = FILL_MODE_NULL; }
        break;
      case 379: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy22 = FILL_MODE_LINEAR; }
        break;
      case 380: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy22 = FILL_MODE_NEXT; }
        break;
      case 383: /* group_by_list ::= expression */
{ yylhsminor.yy488 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy504))); }
  yymsp[0].minor.yy488 = yylhsminor.yy488;
        break;
      case 384: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy488 = addNodeToList(pCxt, yymsp[-2].minor.yy488, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy504))); }
  yymsp[-2].minor.yy488 = yylhsminor.yy488;
        break;
      case 387: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy504 = addOrderByClause(pCxt, yymsp[-3].minor.yy504, yymsp[-2].minor.yy488);
                                                                                    yylhsminor.yy504 = addSlimitClause(pCxt, yylhsminor.yy504, yymsp[-1].minor.yy504);
                                                                                    yylhsminor.yy504 = addLimitClause(pCxt, yylhsminor.yy504, yymsp[0].minor.yy504);
                                                                                  }
  yymsp[-3].minor.yy504 = yylhsminor.yy504;
        break;
      case 389: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy504 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy504, yymsp[0].minor.yy504); }
  yymsp[-3].minor.yy504 = yylhsminor.yy504;
        break;
      case 394: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 398: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==398);
{ yymsp[-1].minor.yy504 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 395: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 399: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==399);
{ yymsp[-3].minor.yy504 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 396: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 400: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==400);
{ yymsp[-3].minor.yy504 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 401: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy504 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy504); }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 405: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy504 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy504), yymsp[-1].minor.yy522, yymsp[0].minor.yy281); }
  yymsp[-2].minor.yy504 = yylhsminor.yy504;
        break;
      case 406: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy522 = ORDER_ASC; }
        break;
      case 407: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy522 = ORDER_ASC; }
        break;
      case 408: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy522 = ORDER_DESC; }
        break;
      case 409: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy281 = NULL_ORDER_DEFAULT; }
        break;
      case 410: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy281 = NULL_ORDER_FIRST; }
        break;
      case 411: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy281 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (pCxt->valid) {
    if(TOKEN.z) {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
    pCxt->valid = false;
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
