import sys
from util.log import *
from util.cases import *
from util.sql import *
from util.dnodes import tdDnodes
from math import inf, nan


class TDTestCase:
    def caseDescription(self):
        """
        case1<shenglian zhou>: [TD-11204]Difference improvement that can ignore negative
        """
        return

    def init(self, conn, logSql):
        tdLog.debug("start to execute %s" % __file__)
        tdSql.init(conn.cursor(), logSql)
        self._conn = conn

    def restartTaosd(self, index=1, dbname="db"):
        tdDnodes.stop(index)
        tdDnodes.startWithoutSleep(index)
        tdSql.execute(f"use math_funcs")

    def run(self):
        print("running {}".format(__file__))
        tdSql.execute("drop database if exists math_funcs")
        tdSql.execute("create database if not exists math_funcs")
        tdSql.execute("use math_funcs")
        tdSql.execute(
            "create table stb1 (ts timestamp, c1 bool, c2 tinyint, c3 smallint, c4 int, c5 bigint, c6 float, c7 double, c8 binary(10), c9 nchar(10), c10 tinyint unsigned, c11 smallint unsigned, c12 int unsigned, c13 bigint unsigned) TAGS(t1 int, t2 binary(10), t3 double);"
        )

        tdSql.execute("create table tb1 using stb1 tags(1,'1',1.0);")

        tdSql.execute("create table tb2 using stb1 tags(2,'2',2.0);")

        tdSql.execute("create table tb3 using stb1 tags(3,'3',3.0);")

        tdSql.execute(
            'insert into tb1 values (\'2021-11-11 09:00:00\',true,1,1,1,1,1,1,"123","1234",1,1,1,1);'
        )

        tdSql.execute(
            "insert into tb1 values ('2021-11-11 09:00:01',true,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);"
        )

        tdSql.execute(
            "insert into tb1 values ('2021-11-11 09:00:02',true,2,NULL,2,NULL,2,NULL,\"234\",NULL,2,NULL,2,NULL);"
        )

        tdSql.execute(
            "insert into tb1 values ('2021-11-11 09:00:03',false,NULL,3,NULL,3,NULL,3,NULL,\"3456\",NULL,3,NULL,3);"
        )

        tdSql.execute(
            'insert into tb1 values (\'2021-11-11 09:00:04\',true,4,4,4,4,4,4,"456","4567",4,4,4,4);'
        )

        tdSql.execute(
            'insert into tb1 values (\'2021-11-11 09:00:05\',true,127,32767,2147483647,9223372036854775807,3.402823466e+38,1.79769e+308,"567","5678",254,65534,4294967294,9223372036854775807);'
        )

        tdSql.execute(
            'insert into tb1 values (\'2021-11-11 09:00:06\',true,-127,-32767,-2147483647,-9223372036854775807,-3.402823466e+38,-1.79769e+308,"678","6789",0,0,0,0);'
        )

        tdSql.execute(
            'insert into tb2 values (\'2021-11-11 09:00:00\',true,1,1,1,1,1,1,"111","1111",1,1,1,1);'
        )

        tdSql.execute(
            'insert into tb2 values (\'2021-11-11 09:00:01\',true,2,2,2,2,2,2,"222","2222",2,2,2,2);'
        )

        tdSql.execute(
            'insert into tb2 values (\'2021-11-11 09:00:02\',true,3,3,2,3,3,3,"333","3333",3,3,3,3);'
        )

        tdSql.execute(
            'insert into tb2 values (\'2021-11-11 09:00:03\',false,4,4,4,4,4,4,"444","4444",4,4,4,4);'
        )

        tdSql.execute(
            'insert into tb2 values (\'2021-11-11 09:00:04\',true,5,5,5,5,5,5,"555","5555",5,5,5,5);'
        )

        tdSql.execute(
            'insert into tb2 values (\'2021-11-11 09:00:05\',true,6,6,6,6,6,6,"666","6666",6,6,6,6);'
        )

        tdSql.execute(
            'insert into tb2 values (\'2021-11-11 09:00:06\',true,7,7,7,7,7,7,"777","7777",7,7,7,7);'
        )

        tdSql.execute(
            "create table tbn (ts timestamp, c1 bool, c2 tinyint, c3 smallint, c4 int, c5 bigint, c6 float, c7 double, c8 binary(10), c9 nchar(10), c10 tinyint unsigned, c11 smallint unsigned, c12 int unsigned, c13 bigint unsigned);"
        )

        tdSql.execute(
            'insert into tbn values (\'2021-11-11 09:00:00\',true,1,1,1,1,1,1,"111","1111",1,1,1,1);'
        )

        tdSql.execute(
            'insert into tbn values (\'2021-11-11 09:00:01\',true,2,2,2,2,2,2,"222","2222",2,2,2,2);'
        )

        tdSql.execute(
            'insert into tbn values (\'2021-11-11 09:00:02\',true,3,3,2,3,3,3,"333","3333",3,3,3,3);'
        )

        tdSql.execute(
            'insert into tbn values (\'2021-11-11 09:00:03\',false,4,4,4,4,4,4,"444","4444",4,4,4,4);'
        )

        tdSql.execute(
            'insert into tbn values (\'2021-11-11 09:00:04\',true,5,5,5,5,5,5,"555","5555",5,5,5,5);'
        )

        tdSql.execute(
            'insert into tbn values (\'2021-11-11 09:00:05\',true,6,6,6,6,6,6,"666","6666",6,6,6,6);'
        )

        tdSql.execute(
            'insert into tbn values (\'2021-11-11 09:00:06\',true,7,7,7,7,7,7,"777","7777",7,7,7,7);'
        )

        # ===========  begin math_sqrt  ==========
        tdSql.query("select sqrt(13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 3.605551275463989)
        tdSql.checkData(1, 0, 3.605551275463989)
        tdSql.checkData(2, 0, 3.605551275463989)
        tdSql.checkData(3, 0, 3.605551275463989)
        tdSql.checkData(4, 0, 3.605551275463989)
        tdSql.checkData(5, 0, 3.605551275463989)
        tdSql.checkData(6, 0, 3.605551275463989)

        tdSql.query("select sqrt(c2) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.4142135623730951)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 11.269427669584644)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt(c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 1.7320508075688772)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 181.01657382681842)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt(c4) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.4142135623730951)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 46340.950001051984)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt(c5) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 1.7320508075688772)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 3037000499.97605)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt(c6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.4142135623730951)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 1.844674352395373e19)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt(c7) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 1.7320508075688772)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 1.3407796239501852e154)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt(c10) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.4142135623730951)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 15.937377450509228)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select sqrt(c11) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 1.7320508075688772)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 255.99609372019722)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select sqrt(c12) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.4142135623730951)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 65535.99998474121)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select sqrt(c13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 1.7320508075688772)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 3037000499.97605)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select sqrt(a) from (select sqrt(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.189207115002721)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.4142135623730951)
        tdSql.checkData(5, 0, 3.3569968229929326)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt(c2 + c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.4142135623730951)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.8284271247461903)
        tdSql.checkData(5, 0, 181.36703118262702)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt((c2 + c3)) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.4142135623730951)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.8284271247461903)
        tdSql.checkData(5, 0, 181.36703118262702)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt((c2 * c3)+c4-6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 3.7416573867739413)
        tdSql.checkData(5, 0, 46385.82811592351)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt(11)+c2 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 4.3166247903554)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 5.3166247903554)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 7.3166247903554)
        tdSql.checkData(5, 0, 130.3166247903554)
        tdSql.checkData(6, 0, -123.6833752096446)

        tdSql.query("select sqrt(c2)+11 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 12.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 12.414213562373096)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 13.0)
        tdSql.checkData(5, 0, 22.269427669584644)
        tdSql.checkData(6, 0, nan)

        tdSql.query(
            "select sqrt(c2+c3) from tb1 where c2 is not null and c3 is not null;"
        )
        tdSql.checkRows(4)
        tdSql.checkData(0, 0, 1.4142135623730951)
        tdSql.checkData(1, 0, 2.8284271247461903)
        tdSql.checkData(2, 0, 181.36703118262702)
        tdSql.checkData(3, 0, nan)

        tdSql.query("select sqrt(c2) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, 11.269427669584644)
        tdSql.checkData(2, 0, 2.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.4142135623730951)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select sqrt(c2+c3) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, 181.36703118262702)
        tdSql.checkData(2, 0, 2.8284271247461903)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, None)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 1.4142135623730951)

        tdSql.query("select sqrt(c2+c3) from tb1 order by ts desc limit 3 offset 2;")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 2.8284271247461903)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)

        tdSql.query("select sqrt(c2) from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.4142135623730951)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 11.269427669584644)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 1.0)
        tdSql.checkData(8, 0, 1.4142135623730951)
        tdSql.checkData(9, 0, 1.7320508075688772)
        tdSql.checkData(10, 0, 2.0)
        tdSql.checkData(11, 0, 2.23606797749979)
        tdSql.checkData(12, 0, 2.449489742783178)
        tdSql.checkData(13, 0, 2.6457513110645907)

        tdSql.query("select sqrt(c2) from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select sqrt(c4),t1,c4 from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select sqrt(c3),tbname from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(0, 1, "tb1")
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, "tb1")
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, "tb1")
        tdSql.checkData(3, 0, 1.7320508075688772)
        tdSql.checkData(3, 1, "tb1")
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(4, 1, "tb1")
        tdSql.checkData(5, 0, 181.01657382681842)
        tdSql.checkData(5, 1, "tb1")
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, "tb1")
        tdSql.checkData(7, 0, 1.0)
        tdSql.checkData(7, 1, "tb2")
        tdSql.checkData(8, 0, 1.4142135623730951)
        tdSql.checkData(8, 1, "tb2")
        tdSql.checkData(9, 0, 1.7320508075688772)
        tdSql.checkData(9, 1, "tb2")
        tdSql.checkData(10, 0, 2.0)
        tdSql.checkData(10, 1, "tb2")
        tdSql.checkData(11, 0, 2.23606797749979)
        tdSql.checkData(11, 1, "tb2")
        tdSql.checkData(12, 0, 2.449489742783178)
        tdSql.checkData(12, 1, "tb2")
        tdSql.checkData(13, 0, 2.6457513110645907)
        tdSql.checkData(13, 1, "tb2")

        tdSql.query("select sqrt(c3),tbname from stb1 where t1 > 1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(0, 1, "tb2")
        tdSql.checkData(1, 0, 1.4142135623730951)
        tdSql.checkData(1, 1, "tb2")
        tdSql.checkData(2, 0, 1.7320508075688772)
        tdSql.checkData(2, 1, "tb2")
        tdSql.checkData(3, 0, 2.0)
        tdSql.checkData(3, 1, "tb2")
        tdSql.checkData(4, 0, 2.23606797749979)
        tdSql.checkData(4, 1, "tb2")
        tdSql.checkData(5, 0, 2.449489742783178)
        tdSql.checkData(5, 1, "tb2")
        tdSql.checkData(6, 0, 2.6457513110645907)
        tdSql.checkData(6, 1, "tb2")

        tdSql.query("select sqrt(a) from (select avg(c2) as a from stb1 interval(1s));")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, 1.4142135623730951)
        tdSql.checkData(2, 0, 1.5811388300841898)
        tdSql.checkData(3, 0, 2.0)
        tdSql.checkData(4, 0, 2.1213203435596424)
        tdSql.checkData(5, 0, 8.154753215150045)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt(c2) from (select * from stb1);")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.4142135623730951)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 11.269427669584644)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 1.0)
        tdSql.checkData(8, 0, 1.4142135623730951)
        tdSql.checkData(9, 0, 1.7320508075688772)
        tdSql.checkData(10, 0, 2.0)
        tdSql.checkData(11, 0, 2.23606797749979)
        tdSql.checkData(12, 0, 2.449489742783178)
        tdSql.checkData(13, 0, 2.6457513110645907)

        tdSql.query(
            "select sqrt(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null));"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, 1.4142135623730951)
        tdSql.checkData(2, 0, 1.5811388300841898)
        tdSql.checkData(3, 0, 2.0)
        tdSql.checkData(4, 0, 2.1213203435596424)
        tdSql.checkData(5, 0, 8.154753215150045)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select sqrt(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, 1.4142135623730951)
        tdSql.checkData(2, 0, 1.5811388300841898)
        tdSql.checkData(3, 0, 2.0)
        tdSql.checkData(4, 0, 2.1213203435596424)
        tdSql.checkData(5, 0, 8.154753215150045)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select sqrt(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, 8.154753215150045)
        tdSql.checkData(5, 0, 2.1213203435596424)
        tdSql.checkData(6, 0, 2.0)
        tdSql.checkData(7, 0, 1.5811388300841898)
        tdSql.checkData(8, 0, 1.4142135623730951)
        tdSql.checkData(9, 0, 1.0)

        tdSql.query(
            "select sqrt(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 8.154753215150045)
        tdSql.checkData(4, 0, 2.1213203435596424)
        tdSql.checkData(5, 0, 2.0)
        tdSql.checkData(6, 0, 1.5811388300841898)
        tdSql.checkData(7, 0, 1.4142135623730951)
        tdSql.checkData(8, 0, 1.0)
        tdSql.checkData(9, 0, nan)

        tdSql.query(
            "select sqrt(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, 1.0)
        tdSql.checkData(2, 0, 1.4142135623730951)
        tdSql.checkData(3, 0, 1.5811388300841898)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 2.1213203435596424)
        tdSql.checkData(6, 0, 8.154753215150045)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query("select sqrt(a) from (select sqrt(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.189207115002721)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.4142135623730951)
        tdSql.checkData(5, 0, 3.3569968229929326)
        tdSql.checkData(6, 0, nan)

        tdSql.query(
            "select sqrt(tb1.c3),sqrt(tb2.c3) from tb1,tb2 where tb1.ts=tb2.ts;"
        )
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(0, 1, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, 1.4142135623730951)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, 1.7320508075688772)
        tdSql.checkData(3, 0, 1.7320508075688772)
        tdSql.checkData(3, 1, 2.0)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(4, 1, 2.23606797749979)
        tdSql.checkData(5, 0, 181.01657382681842)
        tdSql.checkData(5, 1, 2.449489742783178)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, 2.6457513110645907)

        tdSql.query("select sqrt(c3) from tb1 union all select sqrt(c3) from tb2;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 1.7320508075688772)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 181.01657382681842)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 1.0)
        tdSql.checkData(8, 0, 1.4142135623730951)
        tdSql.checkData(9, 0, 1.7320508075688772)
        tdSql.checkData(10, 0, 2.0)
        tdSql.checkData(11, 0, 2.23606797749979)
        tdSql.checkData(12, 0, 2.449489742783178)
        tdSql.checkData(13, 0, 2.6457513110645907)

        # ===========  end   math_sqrt  ==========

        # ===========  begin math_abs  ==========
        tdSql.query("select abs(13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 13)
        tdSql.checkData(1, 0, 13)
        tdSql.checkData(2, 0, 13)
        tdSql.checkData(3, 0, 13)
        tdSql.checkData(4, 0, 13)
        tdSql.checkData(5, 0, 13)
        tdSql.checkData(6, 0, 13)

        tdSql.query("select abs(c2) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 127)
        tdSql.checkData(6, 0, 127)

        tdSql.query("select abs(c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 3)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 32767)
        tdSql.checkData(6, 0, 32767)

        tdSql.query("select abs(c4) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 2147483647)
        tdSql.checkData(6, 0, 2147483647)

        tdSql.query("select abs(c5) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 3)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 9223372036854775807)
        tdSql.checkData(6, 0, 9223372036854775807)

        tdSql.query("select abs(c6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4.0)
        tdSql.checkData(5, 0, 3.4028234663852886e38)
        tdSql.checkData(6, 0, 3.4028234663852886e38)

        tdSql.query("select abs(c7) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 3.0)
        tdSql.checkData(4, 0, 4.0)
        tdSql.checkData(5, 0, 1.79769e308)
        tdSql.checkData(6, 0, 1.79769e308)

        tdSql.query("select abs(c10) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 254)
        tdSql.checkData(6, 0, 0)

        tdSql.query("select abs(c11) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 3)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 65534)
        tdSql.checkData(6, 0, 0)

        tdSql.query("select abs(c12) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 4294967294)
        tdSql.checkData(6, 0, 0)

        tdSql.query("select abs(c13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 3)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 9223372036854775807)
        tdSql.checkData(6, 0, 0)

        tdSql.query("select abs(a) from (select abs(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 127)
        tdSql.checkData(6, 0, 127)

        tdSql.query("select abs(c2 + c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 2.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 8.0)
        tdSql.checkData(5, 0, 32894.0)
        tdSql.checkData(6, 0, 32894.0)

        tdSql.query("select abs((c2 + c3)) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 2.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 8.0)
        tdSql.checkData(5, 0, 32894.0)
        tdSql.checkData(6, 0, 32894.0)

        tdSql.query("select abs((c2 * c3)+c4-6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 4.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 14.0)
        tdSql.checkData(5, 0, 2151645050.0)
        tdSql.checkData(6, 0, 2143322244.0)

        tdSql.query("select abs(11)+c2 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 12.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 13.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 15.0)
        tdSql.checkData(5, 0, 138.0)
        tdSql.checkData(6, 0, -116.0)

        tdSql.query("select abs(c2)+11 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 12.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 13.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 15.0)
        tdSql.checkData(5, 0, 138.0)
        tdSql.checkData(6, 0, 138.0)

        tdSql.query(
            "select abs(c2+c3) from tb1 where c2 is not null and c3 is not null;"
        )
        tdSql.checkRows(4)
        tdSql.checkData(0, 0, 2.0)
        tdSql.checkData(1, 0, 8.0)
        tdSql.checkData(2, 0, 32894.0)
        tdSql.checkData(3, 0, 32894.0)

        tdSql.query("select abs(c2) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 127)
        tdSql.checkData(1, 0, 127)
        tdSql.checkData(2, 0, 4)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 1)

        tdSql.query("select abs(c2+c3) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 32894.0)
        tdSql.checkData(1, 0, 32894.0)
        tdSql.checkData(2, 0, 8.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, None)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 2.0)

        tdSql.query("select abs(c2+c3) from tb1 order by ts desc limit 3 offset 2;")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 8.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)

        tdSql.query("select abs(c2) from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 127)
        tdSql.checkData(6, 0, 127)
        tdSql.checkData(7, 0, 1)
        tdSql.checkData(8, 0, 2)
        tdSql.checkData(9, 0, 3)
        tdSql.checkData(10, 0, 4)
        tdSql.checkData(11, 0, 5)
        tdSql.checkData(12, 0, 6)
        tdSql.checkData(13, 0, 7)

        tdSql.query("select abs(c2) from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select abs(c4),t1 from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select abs(c3),tbname from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, "tb1")
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, "tb1")
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, "tb1")
        tdSql.checkData(3, 0, 3)
        tdSql.checkData(3, 1, "tb1")
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(4, 1, "tb1")
        tdSql.checkData(5, 0, 32767)
        tdSql.checkData(5, 1, "tb1")
        tdSql.checkData(6, 0, 32767)
        tdSql.checkData(6, 1, "tb1")
        tdSql.checkData(7, 0, 1)
        tdSql.checkData(7, 1, "tb2")
        tdSql.checkData(8, 0, 2)
        tdSql.checkData(8, 1, "tb2")
        tdSql.checkData(9, 0, 3)
        tdSql.checkData(9, 1, "tb2")
        tdSql.checkData(10, 0, 4)
        tdSql.checkData(10, 1, "tb2")
        tdSql.checkData(11, 0, 5)
        tdSql.checkData(11, 1, "tb2")
        tdSql.checkData(12, 0, 6)
        tdSql.checkData(12, 1, "tb2")
        tdSql.checkData(13, 0, 7)
        tdSql.checkData(13, 1, "tb2")

        tdSql.query("select abs(c3),tbname from stb1 where t1 > 1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, "tb2")
        tdSql.checkData(1, 0, 2)
        tdSql.checkData(1, 1, "tb2")
        tdSql.checkData(2, 0, 3)
        tdSql.checkData(2, 1, "tb2")
        tdSql.checkData(3, 0, 4)
        tdSql.checkData(3, 1, "tb2")
        tdSql.checkData(4, 0, 5)
        tdSql.checkData(4, 1, "tb2")
        tdSql.checkData(5, 0, 6)
        tdSql.checkData(5, 1, "tb2")
        tdSql.checkData(6, 0, 7)
        tdSql.checkData(6, 1, "tb2")

        tdSql.query("select abs(a) from (select avg(c2) as a from stb1 interval(1s));")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, 2.0)
        tdSql.checkData(2, 0, 2.5)
        tdSql.checkData(3, 0, 4.0)
        tdSql.checkData(4, 0, 4.5)
        tdSql.checkData(5, 0, 66.5)
        tdSql.checkData(6, 0, 60.0)

        tdSql.query("select abs(c2) from (select * from stb1);")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 127)
        tdSql.checkData(6, 0, 127)
        tdSql.checkData(7, 0, 1)
        tdSql.checkData(8, 0, 2)
        tdSql.checkData(9, 0, 3)
        tdSql.checkData(10, 0, 4)
        tdSql.checkData(11, 0, 5)
        tdSql.checkData(12, 0, 6)
        tdSql.checkData(13, 0, 7)

        tdSql.query(
            "select abs(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null));"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, 2.0)
        tdSql.checkData(2, 0, 2.5)
        tdSql.checkData(3, 0, 4.0)
        tdSql.checkData(4, 0, 4.5)
        tdSql.checkData(5, 0, 66.5)
        tdSql.checkData(6, 0, 60.0)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select abs(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, 2.0)
        tdSql.checkData(2, 0, 2.5)
        tdSql.checkData(3, 0, 4.0)
        tdSql.checkData(4, 0, 4.5)
        tdSql.checkData(5, 0, 66.5)
        tdSql.checkData(6, 0, 60.0)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select abs(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 60.0)
        tdSql.checkData(4, 0, 66.5)
        tdSql.checkData(5, 0, 4.5)
        tdSql.checkData(6, 0, 4.0)
        tdSql.checkData(7, 0, 2.5)
        tdSql.checkData(8, 0, 2.0)
        tdSql.checkData(9, 0, 1.0)

        tdSql.query(
            "select abs(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 66.5)
        tdSql.checkData(4, 0, 4.5)
        tdSql.checkData(5, 0, 4.0)
        tdSql.checkData(6, 0, 2.5)
        tdSql.checkData(7, 0, 2.0)
        tdSql.checkData(8, 0, 1.0)
        tdSql.checkData(9, 0, 60.0)

        tdSql.query(
            "select abs(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 60.0)
        tdSql.checkData(1, 0, 1.0)
        tdSql.checkData(2, 0, 2.0)
        tdSql.checkData(3, 0, 2.5)
        tdSql.checkData(4, 0, 4.0)
        tdSql.checkData(5, 0, 4.5)
        tdSql.checkData(6, 0, 66.5)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query("select abs(a) from (select abs(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 127)
        tdSql.checkData(6, 0, 127)

        tdSql.query("select abs(tb1.c3),abs(tb2.c3) from tb1,tb2 where tb1.ts=tb2.ts;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, 2)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, 3)
        tdSql.checkData(3, 0, 3)
        tdSql.checkData(3, 1, 4)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(4, 1, 5)
        tdSql.checkData(5, 0, 32767)
        tdSql.checkData(5, 1, 6)
        tdSql.checkData(6, 0, 32767)
        tdSql.checkData(6, 1, 7)

        tdSql.query("select abs(c3) from tb1 union all select abs(c3) from tb2;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 3)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 32767)
        tdSql.checkData(6, 0, 32767)
        tdSql.checkData(7, 0, 1)
        tdSql.checkData(8, 0, 2)
        tdSql.checkData(9, 0, 3)
        tdSql.checkData(10, 0, 4)
        tdSql.checkData(11, 0, 5)
        tdSql.checkData(12, 0, 6)
        tdSql.checkData(13, 0, 7)

        # ===========  end   math_abs  ==========

        # ===========  begin math_asin  ==========
        tdSql.query("select asin(13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c2) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c4) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c5) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c7) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c10) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select asin(c11) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select asin(c12) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select asin(c13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select asin(a) from (select asin(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c2 + c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin((c2 + c3)) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin((c2 * c3)+c4-6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(11)+c2 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c2)+11 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 12.570796326794897)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query(
            "select asin(c2+c3) from tb1 where c2 is not null and c3 is not null;"
        )
        tdSql.checkRows(4)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)

        tdSql.query("select asin(c2) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 1.5707963267948966)

        tdSql.query("select asin(c2+c3) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, None)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c2+c3) from tb1 order by ts desc limit 3 offset 2;")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)

        tdSql.query("select asin(c2) from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 1.5707963267948966)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)

        tdSql.query("select asin(c2) from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select asin(c4),t1 from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select asin(c3),tbname from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(0, 1, "tb1")
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, "tb1")
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, "tb1")
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(3, 1, "tb1")
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(4, 1, "tb1")
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(5, 1, "tb1")
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, "tb1")
        tdSql.checkData(7, 0, 1.5707963267948966)
        tdSql.checkData(7, 1, "tb2")
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(8, 1, "tb2")
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(9, 1, "tb2")
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(10, 1, "tb2")
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(11, 1, "tb2")
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(12, 1, "tb2")
        tdSql.checkData(13, 0, nan)
        tdSql.checkData(13, 1, "tb2")

        tdSql.query("select asin(c3),tbname from stb1 where t1 > 1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(0, 1, "tb2")
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(1, 1, "tb2")
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(2, 1, "tb2")
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(3, 1, "tb2")
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(4, 1, "tb2")
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(5, 1, "tb2")
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, "tb2")

        tdSql.query("select asin(a) from (select avg(c2) as a from stb1 interval(1s));")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c2) from (select * from stb1);")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 1.5707963267948966)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)

        tdSql.query(
            "select asin(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null));"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select asin(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select asin(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, 1.5707963267948966)

        tdSql.query(
            "select asin(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, 1.5707963267948966)
        tdSql.checkData(9, 0, nan)

        tdSql.query(
            "select asin(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, 1.5707963267948966)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query("select asin(a) from (select asin(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query(
            "select asin(tb1.c3),asin(tb2.c3) from tb1,tb2 where tb1.ts=tb2.ts;"
        )
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(0, 1, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, nan)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(3, 1, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(4, 1, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(5, 1, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, nan)

        tdSql.query("select asin(c3) from tb1 union all select asin(c3) from tb2;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 1.5707963267948966)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)

        # ===========  end   math_asin  ==========

        # ===========  begin math_acos  ==========
        tdSql.query("select acos(13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c2) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c4) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c5) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c7) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c10) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 1.5707963267948966)

        tdSql.query("select acos(c11) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 1.5707963267948966)

        tdSql.query("select acos(c12) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 1.5707963267948966)

        tdSql.query("select acos(c13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 1.5707963267948966)

        tdSql.query("select acos(a) from (select acos(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c2 + c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos((c2 + c3)) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos((c2 * c3)+c4-6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(11)+c2 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c2)+11 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 11.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query(
            "select acos(c2+c3) from tb1 where c2 is not null and c3 is not null;"
        )
        tdSql.checkRows(4)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)

        tdSql.query("select acos(c2) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select acos(c2+c3) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, None)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c2+c3) from tb1 order by ts desc limit 3 offset 2;")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)

        tdSql.query("select acos(c2) from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 0.0)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)

        tdSql.query("select acos(c2) from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select acos(c4),t1 from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select acos(c3),tbname from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(0, 1, "tb1")
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, "tb1")
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, "tb1")
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(3, 1, "tb1")
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(4, 1, "tb1")
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(5, 1, "tb1")
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, "tb1")
        tdSql.checkData(7, 0, 0.0)
        tdSql.checkData(7, 1, "tb2")
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(8, 1, "tb2")
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(9, 1, "tb2")
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(10, 1, "tb2")
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(11, 1, "tb2")
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(12, 1, "tb2")
        tdSql.checkData(13, 0, nan)
        tdSql.checkData(13, 1, "tb2")

        tdSql.query("select acos(c3),tbname from stb1 where t1 > 1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(0, 1, "tb2")
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(1, 1, "tb2")
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(2, 1, "tb2")
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(3, 1, "tb2")
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(4, 1, "tb2")
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(5, 1, "tb2")
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, "tb2")

        tdSql.query("select acos(a) from (select avg(c2) as a from stb1 interval(1s));")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c2) from (select * from stb1);")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 0.0)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)

        tdSql.query(
            "select acos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null));"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select acos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select acos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, 0.0)

        tdSql.query(
            "select acos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, 0.0)
        tdSql.checkData(9, 0, nan)

        tdSql.query(
            "select acos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, 0.0)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query("select acos(a) from (select acos(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query(
            "select acos(tb1.c3),acos(tb2.c3) from tb1,tb2 where tb1.ts=tb2.ts;"
        )
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(0, 1, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, nan)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(3, 1, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(4, 1, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(5, 1, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, nan)

        tdSql.query("select acos(c3) from tb1 union all select acos(c3) from tb2;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 0.0)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)

        # ===========  end   math_acos  ==========

        # ===========  begin math_atan  ==========
        tdSql.query("select acos(13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c2) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c4) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c5) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c7) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c10) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 1.5707963267948966)

        tdSql.query("select acos(c11) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 1.5707963267948966)

        tdSql.query("select acos(c12) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 1.5707963267948966)

        tdSql.query("select acos(c13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 1.5707963267948966)

        tdSql.query("select acos(a) from (select acos(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c2 + c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos((c2 + c3)) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos((c2 * c3)+c4-6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(11)+c2 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c2)+11 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 11.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query(
            "select acos(c2+c3) from tb1 where c2 is not null and c3 is not null;"
        )
        tdSql.checkRows(4)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)

        tdSql.query("select acos(c2) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select acos(c2+c3) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, None)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c2+c3) from tb1 order by ts desc limit 3 offset 2;")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)

        tdSql.query("select acos(c2) from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 0.0)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)

        tdSql.query("select acos(c2) from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select acos(c4),t1 from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select acos(c3),tbname from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(0, 1, "tb1")
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, "tb1")
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, "tb1")
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(3, 1, "tb1")
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(4, 1, "tb1")
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(5, 1, "tb1")
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, "tb1")
        tdSql.checkData(7, 0, 0.0)
        tdSql.checkData(7, 1, "tb2")
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(8, 1, "tb2")
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(9, 1, "tb2")
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(10, 1, "tb2")
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(11, 1, "tb2")
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(12, 1, "tb2")
        tdSql.checkData(13, 0, nan)
        tdSql.checkData(13, 1, "tb2")

        tdSql.query("select acos(c3),tbname from stb1 where t1 > 1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(0, 1, "tb2")
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(1, 1, "tb2")
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(2, 1, "tb2")
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(3, 1, "tb2")
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(4, 1, "tb2")
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(5, 1, "tb2")
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, "tb2")

        tdSql.query("select acos(a) from (select avg(c2) as a from stb1 interval(1s));")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c2) from (select * from stb1);")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 0.0)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)

        tdSql.query(
            "select acos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null));"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select acos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select acos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, 0.0)

        tdSql.query(
            "select acos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, 0.0)
        tdSql.checkData(9, 0, nan)

        tdSql.query(
            "select acos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, 0.0)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query("select acos(a) from (select acos(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query(
            "select acos(tb1.c3),acos(tb2.c3) from tb1,tb2 where tb1.ts=tb2.ts;"
        )
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(0, 1, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, nan)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(3, 1, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(4, 1, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(5, 1, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, nan)

        tdSql.query("select acos(c3) from tb1 union all select acos(c3) from tb2;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 0.0)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)

        # ===========  end   math_atan  ==========

        # ===========  begin math_sin  ==========
        tdSql.query("select sin(13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.4201670368266409)
        tdSql.checkData(1, 0, 0.4201670368266409)
        tdSql.checkData(2, 0, 0.4201670368266409)
        tdSql.checkData(3, 0, 0.4201670368266409)
        tdSql.checkData(4, 0, 0.4201670368266409)
        tdSql.checkData(5, 0, 0.4201670368266409)
        tdSql.checkData(6, 0, 0.4201670368266409)

        tdSql.query("select sin(c2) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.9092974268256817)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.972630067242408)
        tdSql.checkData(6, 0, -0.972630067242408)

        tdSql.query("select sin(c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 0.1411200080598672)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.18750655394138943)
        tdSql.checkData(6, 0, -0.18750655394138943)

        tdSql.query("select sin(c4) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.9092974268256817)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, -0.7249165551445564)
        tdSql.checkData(6, 0, 0.7249165551445564)

        tdSql.query("select sin(c5) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 0.1411200080598672)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.9999303766734422)
        tdSql.checkData(6, 0, -0.9999303766734422)

        tdSql.query("select sin(c6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.9092974268256817)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, -0.5218765233336585)
        tdSql.checkData(6, 0, 0.5218765233336585)

        tdSql.query("select sin(c7) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 0.1411200080598672)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.8728292970885063)
        tdSql.checkData(6, 0, -0.8728292970885063)

        tdSql.query("select sin(c10) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.9092974268256817)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.45199889806298343)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select sin(c11) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 0.1411200080598672)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.3683616323063538)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select sin(c12) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.9092974268256817)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.9986982434666626)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select sin(c13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 0.1411200080598672)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.9999303766734422)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select sin(a) from (select sin(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.7456241416655579)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.7890723435728884)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.6866002607386249)
        tdSql.checkData(5, 0, 0.8263696344332049)
        tdSql.checkData(6, 0, -0.8263696344332049)

        tdSql.query("select sin(c2 + c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.9092974268256817)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.9893582466233818)
        tdSql.checkData(5, 0, 0.9989477243796069)
        tdSql.checkData(6, 0, -0.9989477243796069)

        tdSql.query("select sin((c2 + c3)) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.9092974268256817)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.9893582466233818)
        tdSql.checkData(5, 0, 0.9989477243796069)
        tdSql.checkData(6, 0, -0.9989477243796069)

        tdSql.query("select sin((c2 * c3)+c4-6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.7568024953079282)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.9906073556948704)
        tdSql.checkData(5, 0, 0.08341720348826624)
        tdSql.checkData(6, 0, 0.9909625452221539)

        tdSql.query("select sin(11)+c2 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 9.793449296524592e-06)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.0000097934492964)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 3.0000097934492964)
        tdSql.checkData(5, 0, 126.0000097934493)
        tdSql.checkData(6, 0, -127.9999902065507)

        tdSql.query("select sin(c2)+11 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 11.841470984807897)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 11.909297426825681)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 10.243197504692072)
        tdSql.checkData(5, 0, 11.972630067242408)
        tdSql.checkData(6, 0, 10.027369932757592)

        tdSql.query(
            "select sin(c2+c3) from tb1 where c2 is not null and c3 is not null;"
        )
        tdSql.checkRows(4)
        tdSql.checkData(0, 0, 0.9092974268256817)
        tdSql.checkData(1, 0, 0.9893582466233818)
        tdSql.checkData(2, 0, 0.9989477243796069)
        tdSql.checkData(3, 0, -0.9989477243796069)

        tdSql.query("select sin(c2) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -0.972630067242408)
        tdSql.checkData(1, 0, 0.972630067242408)
        tdSql.checkData(2, 0, -0.7568024953079282)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.9092974268256817)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 0.8414709848078965)

        tdSql.query("select sin(c2+c3) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -0.9989477243796069)
        tdSql.checkData(1, 0, 0.9989477243796069)
        tdSql.checkData(2, 0, 0.9893582466233818)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, None)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 0.9092974268256817)

        tdSql.query("select sin(c2+c3) from tb1 order by ts desc limit 3 offset 2;")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 0.9893582466233818)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)

        tdSql.query("select sin(c2) from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.9092974268256817)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.972630067242408)
        tdSql.checkData(6, 0, -0.972630067242408)
        tdSql.checkData(7, 0, 0.8414709848078965)
        tdSql.checkData(8, 0, 0.9092974268256817)
        tdSql.checkData(9, 0, 0.1411200080598672)
        tdSql.checkData(10, 0, -0.7568024953079282)
        tdSql.checkData(11, 0, -0.9589242746631385)
        tdSql.checkData(12, 0, -0.27941549819892586)
        tdSql.checkData(13, 0, 0.6569865987187891)

        tdSql.query("select sin(c2) from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select sin(c4),t1 from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select sin(c3),tbname from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(0, 1, "tb1")
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, "tb1")
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, "tb1")
        tdSql.checkData(3, 0, 0.1411200080598672)
        tdSql.checkData(3, 1, "tb1")
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(4, 1, "tb1")
        tdSql.checkData(5, 0, 0.18750655394138943)
        tdSql.checkData(5, 1, "tb1")
        tdSql.checkData(6, 0, -0.18750655394138943)
        tdSql.checkData(6, 1, "tb1")
        tdSql.checkData(7, 0, 0.8414709848078965)
        tdSql.checkData(7, 1, "tb2")
        tdSql.checkData(8, 0, 0.9092974268256817)
        tdSql.checkData(8, 1, "tb2")
        tdSql.checkData(9, 0, 0.1411200080598672)
        tdSql.checkData(9, 1, "tb2")
        tdSql.checkData(10, 0, -0.7568024953079282)
        tdSql.checkData(10, 1, "tb2")
        tdSql.checkData(11, 0, -0.9589242746631385)
        tdSql.checkData(11, 1, "tb2")
        tdSql.checkData(12, 0, -0.27941549819892586)
        tdSql.checkData(12, 1, "tb2")
        tdSql.checkData(13, 0, 0.6569865987187891)
        tdSql.checkData(13, 1, "tb2")

        tdSql.query("select sin(c3),tbname from stb1 where t1 > 1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(0, 1, "tb2")
        tdSql.checkData(1, 0, 0.9092974268256817)
        tdSql.checkData(1, 1, "tb2")
        tdSql.checkData(2, 0, 0.1411200080598672)
        tdSql.checkData(2, 1, "tb2")
        tdSql.checkData(3, 0, -0.7568024953079282)
        tdSql.checkData(3, 1, "tb2")
        tdSql.checkData(4, 0, -0.9589242746631385)
        tdSql.checkData(4, 1, "tb2")
        tdSql.checkData(5, 0, -0.27941549819892586)
        tdSql.checkData(5, 1, "tb2")
        tdSql.checkData(6, 0, 0.6569865987187891)
        tdSql.checkData(6, 1, "tb2")

        tdSql.query("select sin(a) from (select avg(c2) as a from stb1 interval(1s));")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, 0.9092974268256817)
        tdSql.checkData(2, 0, 0.5984721441039565)
        tdSql.checkData(3, 0, -0.7568024953079282)
        tdSql.checkData(4, 0, -0.977530117665097)
        tdSql.checkData(5, 0, -0.5025573497604873)
        tdSql.checkData(6, 0, 0.3048106211022167)

        tdSql.query("select sin(c2) from (select * from stb1);")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.9092974268256817)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.972630067242408)
        tdSql.checkData(6, 0, -0.972630067242408)
        tdSql.checkData(7, 0, 0.8414709848078965)
        tdSql.checkData(8, 0, 0.9092974268256817)
        tdSql.checkData(9, 0, 0.1411200080598672)
        tdSql.checkData(10, 0, -0.7568024953079282)
        tdSql.checkData(11, 0, -0.9589242746631385)
        tdSql.checkData(12, 0, -0.27941549819892586)
        tdSql.checkData(13, 0, 0.6569865987187891)

        tdSql.query(
            "select sin(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null));"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, 0.9092974268256817)
        tdSql.checkData(2, 0, 0.5984721441039565)
        tdSql.checkData(3, 0, -0.7568024953079282)
        tdSql.checkData(4, 0, -0.977530117665097)
        tdSql.checkData(5, 0, -0.5025573497604873)
        tdSql.checkData(6, 0, 0.3048106211022167)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select sin(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, 0.9092974268256817)
        tdSql.checkData(2, 0, 0.5984721441039565)
        tdSql.checkData(3, 0, -0.7568024953079282)
        tdSql.checkData(4, 0, -0.977530117665097)
        tdSql.checkData(5, 0, -0.5025573497604873)
        tdSql.checkData(6, 0, 0.3048106211022167)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select sin(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 0.3048106211022167)
        tdSql.checkData(4, 0, -0.5025573497604873)
        tdSql.checkData(5, 0, -0.977530117665097)
        tdSql.checkData(6, 0, -0.7568024953079282)
        tdSql.checkData(7, 0, 0.5984721441039565)
        tdSql.checkData(8, 0, 0.9092974268256817)
        tdSql.checkData(9, 0, 0.8414709848078965)

        tdSql.query(
            "select sin(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.5025573497604873)
        tdSql.checkData(4, 0, -0.977530117665097)
        tdSql.checkData(5, 0, -0.7568024953079282)
        tdSql.checkData(6, 0, 0.5984721441039565)
        tdSql.checkData(7, 0, 0.9092974268256817)
        tdSql.checkData(8, 0, 0.8414709848078965)
        tdSql.checkData(9, 0, 0.3048106211022167)

        tdSql.query(
            "select sin(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 0.3048106211022167)
        tdSql.checkData(1, 0, 0.8414709848078965)
        tdSql.checkData(2, 0, 0.9092974268256817)
        tdSql.checkData(3, 0, 0.5984721441039565)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, -0.977530117665097)
        tdSql.checkData(6, 0, -0.5025573497604873)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query("select sin(a) from (select sin(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.7456241416655579)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.7890723435728884)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.6866002607386249)
        tdSql.checkData(5, 0, 0.8263696344332049)
        tdSql.checkData(6, 0, -0.8263696344332049)

        tdSql.query("select sin(tb1.c3),sin(tb2.c3) from tb1,tb2 where tb1.ts=tb2.ts;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(0, 1, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, 0.9092974268256817)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, 0.1411200080598672)
        tdSql.checkData(3, 0, 0.1411200080598672)
        tdSql.checkData(3, 1, -0.7568024953079282)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(4, 1, -0.9589242746631385)
        tdSql.checkData(5, 0, 0.18750655394138943)
        tdSql.checkData(5, 1, -0.27941549819892586)
        tdSql.checkData(6, 0, -0.18750655394138943)
        tdSql.checkData(6, 1, 0.6569865987187891)

        tdSql.query("select sin(c3) from tb1 union all select sin(c3) from tb2;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 0.1411200080598672)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.18750655394138943)
        tdSql.checkData(6, 0, -0.18750655394138943)
        tdSql.checkData(7, 0, 0.8414709848078965)
        tdSql.checkData(8, 0, 0.9092974268256817)
        tdSql.checkData(9, 0, 0.1411200080598672)
        tdSql.checkData(10, 0, -0.7568024953079282)
        tdSql.checkData(11, 0, -0.9589242746631385)
        tdSql.checkData(12, 0, -0.27941549819892586)
        tdSql.checkData(13, 0, 0.6569865987187891)

        # ===========  end   math_sin  ==========

        # ===========  begin math_cos  ==========
        tdSql.query("select cos(13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.9074467814501962)
        tdSql.checkData(1, 0, 0.9074467814501962)
        tdSql.checkData(2, 0, 0.9074467814501962)
        tdSql.checkData(3, 0, 0.9074467814501962)
        tdSql.checkData(4, 0, 0.9074467814501962)
        tdSql.checkData(5, 0, 0.9074467814501962)
        tdSql.checkData(6, 0, 0.9074467814501962)

        tdSql.query("select cos(c2) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -0.4161468365471424)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, 0.23235910202965793)
        tdSql.checkData(6, 0, 0.23235910202965793)

        tdSql.query("select cos(c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.9899924966004454)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, 0.9822633517692823)
        tdSql.checkData(6, 0, 0.9822633517692823)

        tdSql.query("select cos(c4) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -0.4161468365471424)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, -0.6888366918779438)
        tdSql.checkData(6, 0, -0.6888366918779438)

        tdSql.query("select cos(c5) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.9899924966004454)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, 0.011800076512800236)
        tdSql.checkData(6, 0, 0.011800076512800236)

        tdSql.query("select cos(c6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -0.4161468365471424)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, 0.8530210398303042)
        tdSql.checkData(6, 0, 0.8530210398303042)

        tdSql.query("select cos(c7) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.9899924966004454)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, 0.4880256326710555)
        tdSql.checkData(6, 0, 0.4880256326710555)

        tdSql.query("select cos(c10) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -0.4161468365471424)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, -0.892018495407942)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select cos(c11) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.9899924966004454)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, 0.9296825844580496)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select cos(c12) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -0.4161468365471424)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, -0.051008023845301335)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select cos(c13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.9899924966004454)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, 0.011800076512800236)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select cos(a) from (select cos(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8575532158463934)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.9146533258523714)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.7938734492261525)
        tdSql.checkData(5, 0, 0.9731258638638398)
        tdSql.checkData(6, 0, 0.9731258638638398)

        tdSql.query("select cos(c2 + c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -0.4161468365471424)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.14550003380861354)
        tdSql.checkData(5, 0, 0.04586331820534665)
        tdSql.checkData(6, 0, 0.04586331820534665)

        tdSql.query("select cos((c2 + c3)) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -0.4161468365471424)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.14550003380861354)
        tdSql.checkData(5, 0, 0.04586331820534665)
        tdSql.checkData(6, 0, 0.04586331820534665)

        tdSql.query("select cos((c2 * c3)+c4-6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -0.6536436208636119)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.1367372182078336)
        tdSql.checkData(5, 0, -0.9965147114630055)
        tdSql.checkData(6, 0, 0.13413886076313122)

        tdSql.query("select cos(11)+c2 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0044256979880508)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2.004425697988051)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4.004425697988051)
        tdSql.checkData(5, 0, 127.00442569798805)
        tdSql.checkData(6, 0, -126.99557430201195)

        tdSql.query("select cos(c2)+11 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 11.54030230586814)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 10.583853163452858)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 10.346356379136388)
        tdSql.checkData(5, 0, 11.232359102029658)
        tdSql.checkData(6, 0, 11.232359102029658)

        tdSql.query(
            "select cos(c2+c3) from tb1 where c2 is not null and c3 is not null;"
        )
        tdSql.checkRows(4)
        tdSql.checkData(0, 0, -0.4161468365471424)
        tdSql.checkData(1, 0, -0.14550003380861354)
        tdSql.checkData(2, 0, 0.04586331820534665)
        tdSql.checkData(3, 0, 0.04586331820534665)

        tdSql.query("select cos(c2) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.23235910202965793)
        tdSql.checkData(1, 0, 0.23235910202965793)
        tdSql.checkData(2, 0, -0.6536436208636119)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.4161468365471424)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 0.5403023058681398)

        tdSql.query("select cos(c2+c3) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.04586331820534665)
        tdSql.checkData(1, 0, 0.04586331820534665)
        tdSql.checkData(2, 0, -0.14550003380861354)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, None)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, -0.4161468365471424)

        tdSql.query("select cos(c2+c3) from tb1 order by ts desc limit 3 offset 2;")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, -0.14550003380861354)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)

        tdSql.query("select cos(c2) from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -0.4161468365471424)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, 0.23235910202965793)
        tdSql.checkData(6, 0, 0.23235910202965793)
        tdSql.checkData(7, 0, 0.5403023058681398)
        tdSql.checkData(8, 0, -0.4161468365471424)
        tdSql.checkData(9, 0, -0.9899924966004454)
        tdSql.checkData(10, 0, -0.6536436208636119)
        tdSql.checkData(11, 0, 0.28366218546322625)
        tdSql.checkData(12, 0, 0.960170286650366)
        tdSql.checkData(13, 0, 0.7539022543433046)

        tdSql.query("select cos(c2) from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select cos(c4),t1 from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select cos(c3),tbname from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(0, 1, "tb1")
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, "tb1")
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, "tb1")
        tdSql.checkData(3, 0, -0.9899924966004454)
        tdSql.checkData(3, 1, "tb1")
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(4, 1, "tb1")
        tdSql.checkData(5, 0, 0.9822633517692823)
        tdSql.checkData(5, 1, "tb1")
        tdSql.checkData(6, 0, 0.9822633517692823)
        tdSql.checkData(6, 1, "tb1")
        tdSql.checkData(7, 0, 0.5403023058681398)
        tdSql.checkData(7, 1, "tb2")
        tdSql.checkData(8, 0, -0.4161468365471424)
        tdSql.checkData(8, 1, "tb2")
        tdSql.checkData(9, 0, -0.9899924966004454)
        tdSql.checkData(9, 1, "tb2")
        tdSql.checkData(10, 0, -0.6536436208636119)
        tdSql.checkData(10, 1, "tb2")
        tdSql.checkData(11, 0, 0.28366218546322625)
        tdSql.checkData(11, 1, "tb2")
        tdSql.checkData(12, 0, 0.960170286650366)
        tdSql.checkData(12, 1, "tb2")
        tdSql.checkData(13, 0, 0.7539022543433046)
        tdSql.checkData(13, 1, "tb2")

        tdSql.query("select cos(c3),tbname from stb1 where t1 > 1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(0, 1, "tb2")
        tdSql.checkData(1, 0, -0.4161468365471424)
        tdSql.checkData(1, 1, "tb2")
        tdSql.checkData(2, 0, -0.9899924966004454)
        tdSql.checkData(2, 1, "tb2")
        tdSql.checkData(3, 0, -0.6536436208636119)
        tdSql.checkData(3, 1, "tb2")
        tdSql.checkData(4, 0, 0.28366218546322625)
        tdSql.checkData(4, 1, "tb2")
        tdSql.checkData(5, 0, 0.960170286650366)
        tdSql.checkData(5, 1, "tb2")
        tdSql.checkData(6, 0, 0.7539022543433046)
        tdSql.checkData(6, 1, "tb2")

        tdSql.query("select cos(a) from (select avg(c2) as a from stb1 interval(1s));")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, -0.4161468365471424)
        tdSql.checkData(2, 0, -0.8011436155469337)
        tdSql.checkData(3, 0, -0.6536436208636119)
        tdSql.checkData(4, 0, -0.2107957994307797)
        tdSql.checkData(5, 0, -0.8645438740756395)
        tdSql.checkData(6, 0, -0.9524129804151563)

        tdSql.query("select cos(c2) from (select * from stb1);")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -0.4161468365471424)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, 0.23235910202965793)
        tdSql.checkData(6, 0, 0.23235910202965793)
        tdSql.checkData(7, 0, 0.5403023058681398)
        tdSql.checkData(8, 0, -0.4161468365471424)
        tdSql.checkData(9, 0, -0.9899924966004454)
        tdSql.checkData(10, 0, -0.6536436208636119)
        tdSql.checkData(11, 0, 0.28366218546322625)
        tdSql.checkData(12, 0, 0.960170286650366)
        tdSql.checkData(13, 0, 0.7539022543433046)

        tdSql.query(
            "select cos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null));"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, -0.4161468365471424)
        tdSql.checkData(2, 0, -0.8011436155469337)
        tdSql.checkData(3, 0, -0.6536436208636119)
        tdSql.checkData(4, 0, -0.2107957994307797)
        tdSql.checkData(5, 0, -0.8645438740756395)
        tdSql.checkData(6, 0, -0.9524129804151563)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select cos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, -0.4161468365471424)
        tdSql.checkData(2, 0, -0.8011436155469337)
        tdSql.checkData(3, 0, -0.6536436208636119)
        tdSql.checkData(4, 0, -0.2107957994307797)
        tdSql.checkData(5, 0, -0.8645438740756395)
        tdSql.checkData(6, 0, -0.9524129804151563)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select cos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.9524129804151563)
        tdSql.checkData(4, 0, -0.8645438740756395)
        tdSql.checkData(5, 0, -0.2107957994307797)
        tdSql.checkData(6, 0, -0.6536436208636119)
        tdSql.checkData(7, 0, -0.8011436155469337)
        tdSql.checkData(8, 0, -0.4161468365471424)
        tdSql.checkData(9, 0, 0.5403023058681398)

        tdSql.query(
            "select cos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.8645438740756395)
        tdSql.checkData(4, 0, -0.2107957994307797)
        tdSql.checkData(5, 0, -0.6536436208636119)
        tdSql.checkData(6, 0, -0.8011436155469337)
        tdSql.checkData(7, 0, -0.4161468365471424)
        tdSql.checkData(8, 0, 0.5403023058681398)
        tdSql.checkData(9, 0, -0.9524129804151563)

        tdSql.query(
            "select cos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, -0.9524129804151563)
        tdSql.checkData(1, 0, 0.5403023058681398)
        tdSql.checkData(2, 0, -0.4161468365471424)
        tdSql.checkData(3, 0, -0.8011436155469337)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, -0.2107957994307797)
        tdSql.checkData(6, 0, -0.8645438740756395)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query("select cos(a) from (select cos(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8575532158463934)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.9146533258523714)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.7938734492261525)
        tdSql.checkData(5, 0, 0.9731258638638398)
        tdSql.checkData(6, 0, 0.9731258638638398)

        tdSql.query("select cos(tb1.c3),cos(tb2.c3) from tb1,tb2 where tb1.ts=tb2.ts;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(0, 1, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, -0.4161468365471424)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, -0.9899924966004454)
        tdSql.checkData(3, 0, -0.9899924966004454)
        tdSql.checkData(3, 1, -0.6536436208636119)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(4, 1, 0.28366218546322625)
        tdSql.checkData(5, 0, 0.9822633517692823)
        tdSql.checkData(5, 1, 0.960170286650366)
        tdSql.checkData(6, 0, 0.9822633517692823)
        tdSql.checkData(6, 1, 0.7539022543433046)

        tdSql.query("select cos(c3) from tb1 union all select cos(c3) from tb2;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.9899924966004454)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, 0.9822633517692823)
        tdSql.checkData(6, 0, 0.9822633517692823)
        tdSql.checkData(7, 0, 0.5403023058681398)
        tdSql.checkData(8, 0, -0.4161468365471424)
        tdSql.checkData(9, 0, -0.9899924966004454)
        tdSql.checkData(10, 0, -0.6536436208636119)
        tdSql.checkData(11, 0, 0.28366218546322625)
        tdSql.checkData(12, 0, 0.960170286650366)
        tdSql.checkData(13, 0, 0.7539022543433046)

        # ===========  end   math_cos  ==========

        # ===========  begin math_tan  ==========
        tdSql.query("select tan(13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.4630211329364896)
        tdSql.checkData(1, 0, 0.4630211329364896)
        tdSql.checkData(2, 0, 0.4630211329364896)
        tdSql.checkData(3, 0, 0.4630211329364896)
        tdSql.checkData(4, 0, 0.4630211329364896)
        tdSql.checkData(5, 0, 0.4630211329364896)
        tdSql.checkData(6, 0, 0.4630211329364896)

        tdSql.query("select tan(c2) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -2.185039863261519)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 4.185891831851989)
        tdSql.checkData(6, 0, -4.185891831851989)

        tdSql.query("select tan(c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.1425465430742778)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 0.19089234430221486)
        tdSql.checkData(6, 0, -0.19089234430221486)

        tdSql.query("select tan(c4) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -2.185039863261519)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 1.0523779637351338)
        tdSql.checkData(6, 0, -1.0523779637351338)

        tdSql.query("select tan(c5) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.1425465430742778)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 84.73931296875567)
        tdSql.checkData(6, 0, -84.73931296875567)

        tdSql.query("select tan(c6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -2.185039863261519)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, -0.6117979498342481)
        tdSql.checkData(6, 0, 0.6117979498342481)

        tdSql.query("select tan(c7) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.1425465430742778)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 1.7884906829818519)
        tdSql.checkData(6, 0, -1.7884906829818519)

        tdSql.query("select tan(c10) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -2.185039863261519)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, -0.5067147154345417)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select tan(c11) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.1425465430742778)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 0.39622301037411284)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select tan(c12) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -2.185039863261519)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, -19.579238091943036)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select tan(c13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.1425465430742778)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 84.73931296875567)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select tan(a) from (select tan(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 74.68593339876537)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.4179285755053868)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.282204450191367)
        tdSql.checkData(5, 0, 1.7205151938006633)
        tdSql.checkData(6, 0, -1.7205151938006633)

        tdSql.query("select tan(c2 + c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -2.185039863261519)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -6.799711455220379)
        tdSql.checkData(5, 0, 21.780973629229287)
        tdSql.checkData(6, 0, -21.780973629229287)

        tdSql.query("select tan((c2 + c3)) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -2.185039863261519)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -6.799711455220379)
        tdSql.checkData(5, 0, 21.780973629229287)
        tdSql.checkData(6, 0, -21.780973629229287)

        tdSql.query("select tan((c2 * c3)+c4-6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -1.1578212823495775)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 7.2446066160948055)
        tdSql.checkData(5, 0, -0.08370895334379919)
        tdSql.checkData(6, 0, 7.387587307544252)

        tdSql.query("select tan(11)+c2 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -224.95084645419513)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -223.95084645419513)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -221.95084645419513)
        tdSql.checkData(5, 0, -98.95084645419513)
        tdSql.checkData(6, 0, -352.95084645419513)

        tdSql.query("select tan(c2)+11 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 12.557407724654903)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 8.814960136738481)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 12.157821282349577)
        tdSql.checkData(5, 0, 15.18589183185199)
        tdSql.checkData(6, 0, 6.814108168148011)

        tdSql.query(
            "select tan(c2+c3) from tb1 where c2 is not null and c3 is not null;"
        )
        tdSql.checkRows(4)
        tdSql.checkData(0, 0, -2.185039863261519)
        tdSql.checkData(1, 0, -6.799711455220379)
        tdSql.checkData(2, 0, 21.780973629229287)
        tdSql.checkData(3, 0, -21.780973629229287)

        tdSql.query("select tan(c2) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -4.185891831851989)
        tdSql.checkData(1, 0, 4.185891831851989)
        tdSql.checkData(2, 0, 1.1578212823495775)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -2.185039863261519)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 1.5574077246549023)

        tdSql.query("select tan(c2+c3) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -21.780973629229287)
        tdSql.checkData(1, 0, 21.780973629229287)
        tdSql.checkData(2, 0, -6.799711455220379)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, None)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, -2.185039863261519)

        tdSql.query("select tan(c2+c3) from tb1 order by ts desc limit 3 offset 2;")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, -6.799711455220379)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)

        tdSql.query("select tan(c2) from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -2.185039863261519)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 4.185891831851989)
        tdSql.checkData(6, 0, -4.185891831851989)
        tdSql.checkData(7, 0, 1.5574077246549023)
        tdSql.checkData(8, 0, -2.185039863261519)
        tdSql.checkData(9, 0, -0.1425465430742778)
        tdSql.checkData(10, 0, 1.1578212823495775)
        tdSql.checkData(11, 0, -3.380515006246586)
        tdSql.checkData(12, 0, -0.29100619138474915)
        tdSql.checkData(13, 0, 0.8714479827243188)

        tdSql.query("select tan(c2) from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select tan(c4),t1 from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select tan(c3),tbname from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(0, 1, "tb1")
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, "tb1")
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, "tb1")
        tdSql.checkData(3, 0, -0.1425465430742778)
        tdSql.checkData(3, 1, "tb1")
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(4, 1, "tb1")
        tdSql.checkData(5, 0, 0.19089234430221486)
        tdSql.checkData(5, 1, "tb1")
        tdSql.checkData(6, 0, -0.19089234430221486)
        tdSql.checkData(6, 1, "tb1")
        tdSql.checkData(7, 0, 1.5574077246549023)
        tdSql.checkData(7, 1, "tb2")
        tdSql.checkData(8, 0, -2.185039863261519)
        tdSql.checkData(8, 1, "tb2")
        tdSql.checkData(9, 0, -0.1425465430742778)
        tdSql.checkData(9, 1, "tb2")
        tdSql.checkData(10, 0, 1.1578212823495775)
        tdSql.checkData(10, 1, "tb2")
        tdSql.checkData(11, 0, -3.380515006246586)
        tdSql.checkData(11, 1, "tb2")
        tdSql.checkData(12, 0, -0.29100619138474915)
        tdSql.checkData(12, 1, "tb2")
        tdSql.checkData(13, 0, 0.8714479827243188)
        tdSql.checkData(13, 1, "tb2")

        tdSql.query("select tan(c3),tbname from stb1 where t1 > 1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(0, 1, "tb2")
        tdSql.checkData(1, 0, -2.185039863261519)
        tdSql.checkData(1, 1, "tb2")
        tdSql.checkData(2, 0, -0.1425465430742778)
        tdSql.checkData(2, 1, "tb2")
        tdSql.checkData(3, 0, 1.1578212823495775)
        tdSql.checkData(3, 1, "tb2")
        tdSql.checkData(4, 0, -3.380515006246586)
        tdSql.checkData(4, 1, "tb2")
        tdSql.checkData(5, 0, -0.29100619138474915)
        tdSql.checkData(5, 1, "tb2")
        tdSql.checkData(6, 0, 0.8714479827243188)
        tdSql.checkData(6, 1, "tb2")

        tdSql.query("select tan(a) from (select avg(c2) as a from stb1 interval(1s));")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, -2.185039863261519)
        tdSql.checkData(2, 0, -0.7470222972386603)
        tdSql.checkData(3, 0, 1.1578212823495775)
        tdSql.checkData(4, 0, 4.637332054551185)
        tdSql.checkData(5, 0, 0.5812976817374548)
        tdSql.checkData(6, 0, -0.320040389379563)

        tdSql.query("select tan(c2) from (select * from stb1);")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -2.185039863261519)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 4.185891831851989)
        tdSql.checkData(6, 0, -4.185891831851989)
        tdSql.checkData(7, 0, 1.5574077246549023)
        tdSql.checkData(8, 0, -2.185039863261519)
        tdSql.checkData(9, 0, -0.1425465430742778)
        tdSql.checkData(10, 0, 1.1578212823495775)
        tdSql.checkData(11, 0, -3.380515006246586)
        tdSql.checkData(12, 0, -0.29100619138474915)
        tdSql.checkData(13, 0, 0.8714479827243188)

        tdSql.query(
            "select tan(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null));"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, -2.185039863261519)
        tdSql.checkData(2, 0, -0.7470222972386603)
        tdSql.checkData(3, 0, 1.1578212823495775)
        tdSql.checkData(4, 0, 4.637332054551185)
        tdSql.checkData(5, 0, 0.5812976817374548)
        tdSql.checkData(6, 0, -0.320040389379563)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select tan(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, -2.185039863261519)
        tdSql.checkData(2, 0, -0.7470222972386603)
        tdSql.checkData(3, 0, 1.1578212823495775)
        tdSql.checkData(4, 0, 4.637332054551185)
        tdSql.checkData(5, 0, 0.5812976817374548)
        tdSql.checkData(6, 0, -0.320040389379563)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select tan(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.320040389379563)
        tdSql.checkData(4, 0, 0.5812976817374548)
        tdSql.checkData(5, 0, 4.637332054551185)
        tdSql.checkData(6, 0, 1.1578212823495775)
        tdSql.checkData(7, 0, -0.7470222972386603)
        tdSql.checkData(8, 0, -2.185039863261519)
        tdSql.checkData(9, 0, 1.5574077246549023)

        tdSql.query(
            "select tan(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 0.5812976817374548)
        tdSql.checkData(4, 0, 4.637332054551185)
        tdSql.checkData(5, 0, 1.1578212823495775)
        tdSql.checkData(6, 0, -0.7470222972386603)
        tdSql.checkData(7, 0, -2.185039863261519)
        tdSql.checkData(8, 0, 1.5574077246549023)
        tdSql.checkData(9, 0, -0.320040389379563)

        tdSql.query(
            "select tan(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, -0.320040389379563)
        tdSql.checkData(1, 0, 1.5574077246549023)
        tdSql.checkData(2, 0, -2.185039863261519)
        tdSql.checkData(3, 0, -0.7470222972386603)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 4.637332054551185)
        tdSql.checkData(6, 0, 0.5812976817374548)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query("select tan(a) from (select tan(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 74.68593339876537)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.4179285755053868)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.282204450191367)
        tdSql.checkData(5, 0, 1.7205151938006633)
        tdSql.checkData(6, 0, -1.7205151938006633)

        tdSql.query("select tan(tb1.c3),tan(tb2.c3) from tb1,tb2 where tb1.ts=tb2.ts;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(0, 1, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, -2.185039863261519)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, -0.1425465430742778)
        tdSql.checkData(3, 0, -0.1425465430742778)
        tdSql.checkData(3, 1, 1.1578212823495775)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(4, 1, -3.380515006246586)
        tdSql.checkData(5, 0, 0.19089234430221486)
        tdSql.checkData(5, 1, -0.29100619138474915)
        tdSql.checkData(6, 0, -0.19089234430221486)
        tdSql.checkData(6, 1, 0.8714479827243188)

        tdSql.query("select tan(c3) from tb1 union all select tan(c3) from tb2;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.1425465430742778)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 0.19089234430221486)
        tdSql.checkData(6, 0, -0.19089234430221486)
        tdSql.checkData(7, 0, 1.5574077246549023)
        tdSql.checkData(8, 0, -2.185039863261519)
        tdSql.checkData(9, 0, -0.1425465430742778)
        tdSql.checkData(10, 0, 1.1578212823495775)
        tdSql.checkData(11, 0, -3.380515006246586)
        tdSql.checkData(12, 0, -0.29100619138474915)
        tdSql.checkData(13, 0, 0.8714479827243188)

        # ===========  end   math_tan  ==========

        # ===========  begin math_pow  ==========
        tdSql.query("select pow(c2,13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 8192.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 67108864.0)
        tdSql.checkData(5, 0, 2.235879388560037e27)
        tdSql.checkData(6, 0, -2.235879388560037e27)

        tdSql.query("select pow(c2,c2) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 4.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, 1.5243074119957227e267)
        tdSql.checkData(6, 0, -6.560356474884124e-268)

        tdSql.query("select pow(c2,c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, -0.0)

        tdSql.query("select pow(c2,c4) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 4.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, -0.0)

        tdSql.query("select pow(c2,c5) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select pow(c2,c6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 4.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select pow(c2,c7) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select pow(c2,c10) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 4.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select pow(c2,c11) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select pow(c2,c12) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 4.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select pow(c2,c13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select pow(c2,c2 + c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 65536.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select pow(c2,(c2 + c3)) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 65536.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select pow(c2,(c2 * c3)+c4-6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 268435456.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select pow(c2,11)+c2 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 2.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2050.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4194308.0)
        tdSql.checkData(5, 0, 1.3862479934032099e23)
        tdSql.checkData(6, 0, -1.3862479934032099e23)

        tdSql.query("select pow(c2,c2)+11 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 12.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 15.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 267.0)
        tdSql.checkData(5, 0, 1.5243074119957227e267)
        tdSql.checkData(6, 0, 11.0)

        tdSql.query(
            "select pow(c2,c2+c3) from tb1 where c2 is not null and c3 is not null;"
        )
        tdSql.checkRows(4)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, 65536.0)
        tdSql.checkData(2, 0, inf)
        tdSql.checkData(3, 0, 0.0)

        tdSql.query("select pow(c2,c2) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -6.560356474884124e-268)
        tdSql.checkData(1, 0, 1.5243074119957227e267)
        tdSql.checkData(2, 0, 256.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4.0)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select pow(c2,c2+c3) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, inf)
        tdSql.checkData(2, 0, 65536.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, None)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select pow(c2,c2+c3) from tb1 order by ts desc limit 3 offset 2;")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 65536.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)

        tdSql.query("select pow(c2,c2) from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 4.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, 1.5243074119957227e267)
        tdSql.checkData(6, 0, -6.560356474884124e-268)
        tdSql.checkData(7, 0, 1.0)
        tdSql.checkData(8, 0, 4.0)
        tdSql.checkData(9, 0, 27.0)
        tdSql.checkData(10, 0, 256.0)
        tdSql.checkData(11, 0, 3125.0)
        tdSql.checkData(12, 0, 46656.0)
        tdSql.checkData(13, 0, 823543.0)

        tdSql.query("select pow(c2,c2) from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select pow(c2,c4),t1 from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select pow(c2,c3),tbname from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(0, 1, "tb1")
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, "tb1")
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, "tb1")
        tdSql.checkData(3, 0, None)
        tdSql.checkData(3, 1, "tb1")
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(4, 1, "tb1")
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(5, 1, "tb1")
        tdSql.checkData(6, 0, -0.0)
        tdSql.checkData(6, 1, "tb1")
        tdSql.checkData(7, 0, 1.0)
        tdSql.checkData(7, 1, "tb2")
        tdSql.checkData(8, 0, 4.0)
        tdSql.checkData(8, 1, "tb2")
        tdSql.checkData(9, 0, 27.0)
        tdSql.checkData(9, 1, "tb2")
        tdSql.checkData(10, 0, 256.0)
        tdSql.checkData(10, 1, "tb2")
        tdSql.checkData(11, 0, 3125.0)
        tdSql.checkData(11, 1, "tb2")
        tdSql.checkData(12, 0, 46656.0)
        tdSql.checkData(12, 1, "tb2")
        tdSql.checkData(13, 0, 823543.0)
        tdSql.checkData(13, 1, "tb2")

        tdSql.query("select pow(c2,c3),tbname from stb1 where t1 > 1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(0, 1, "tb2")
        tdSql.checkData(1, 0, 4.0)
        tdSql.checkData(1, 1, "tb2")
        tdSql.checkData(2, 0, 27.0)
        tdSql.checkData(2, 1, "tb2")
        tdSql.checkData(3, 0, 256.0)
        tdSql.checkData(3, 1, "tb2")
        tdSql.checkData(4, 0, 3125.0)
        tdSql.checkData(4, 1, "tb2")
        tdSql.checkData(5, 0, 46656.0)
        tdSql.checkData(5, 1, "tb2")
        tdSql.checkData(6, 0, 823543.0)
        tdSql.checkData(6, 1, "tb2")

        tdSql.query("select pow(c2,c2) from (select * from stb1);")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 4.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, 1.5243074119957227e267)
        tdSql.checkData(6, 0, -6.560356474884124e-268)
        tdSql.checkData(7, 0, 1.0)
        tdSql.checkData(8, 0, 4.0)
        tdSql.checkData(9, 0, 27.0)
        tdSql.checkData(10, 0, 256.0)
        tdSql.checkData(11, 0, 3125.0)
        tdSql.checkData(12, 0, 46656.0)
        tdSql.checkData(13, 0, 823543.0)

        tdSql.query("select pow(c2,c3) from tb1 union all select pow(c2,c3) from tb2;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, -0.0)
        tdSql.checkData(7, 0, 1.0)
        tdSql.checkData(8, 0, 4.0)
        tdSql.checkData(9, 0, 27.0)
        tdSql.checkData(10, 0, 256.0)
        tdSql.checkData(11, 0, 3125.0)
        tdSql.checkData(12, 0, 46656.0)
        tdSql.checkData(13, 0, 823543.0)

        # ===========  end   math_pow  ==========

        # ===========  begin math_log  ==========
        tdSql.query("select log(c2,13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.27023815442731974)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.5404763088546395)
        tdSql.checkData(5, 0, 1.8886092516277813)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c2) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 1.0)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.465913680008469)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c4) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.22544144151366513)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c5) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.11093150296463757)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.05459909915208762)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c7) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.006824887406193638)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c10) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.8748229478056855)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c11) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.4367939948774267)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c12) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.2183963964662152)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.11093150296463757)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c2 + c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.6666666666666667)
        tdSql.checkData(5, 0, 0.4657403972991969)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,(c2 + c3)) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.6666666666666667)
        tdSql.checkData(5, 0, 0.4657403972991969)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,(c2 * c3)+c4-6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.5252990700743871)
        tdSql.checkData(5, 0, 0.22542113212116985)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,11)+c2 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2.2890648263178877)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4.578129652635775)
        tdSql.checkData(5, 0, 129.02018292517226)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c2)+11 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 12.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 12.0)
        tdSql.checkData(5, 0, 12.0)
        tdSql.checkData(6, 0, nan)

        tdSql.query(
            "select log(c2,c2+c3) from tb1 where c2 is not null and c3 is not null;"
        )
        tdSql.checkRows(4)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, 0.6666666666666667)
        tdSql.checkData(2, 0, 0.4657403972991969)
        tdSql.checkData(3, 0, nan)

        tdSql.query("select log(c2,c2) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, 1.0)
        tdSql.checkData(2, 0, 1.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c2+c3) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, 0.4657403972991969)
        tdSql.checkData(2, 0, 0.6666666666666667)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, None)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select log(c2,c2+c3) from tb1 order by ts desc limit 3 offset 2;")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 0.6666666666666667)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)

        tdSql.query("select log(c2,c2) from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 1.0)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, 1.0)
        tdSql.checkData(9, 0, 1.0)
        tdSql.checkData(10, 0, 1.0)
        tdSql.checkData(11, 0, 1.0)
        tdSql.checkData(12, 0, 1.0)
        tdSql.checkData(13, 0, 1.0)

        tdSql.query("select log(c2,c2) from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select log(c2,c4),t1 from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select log(c2,c3),tbname from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(0, 1, "tb1")
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, "tb1")
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, "tb1")
        tdSql.checkData(3, 0, None)
        tdSql.checkData(3, 1, "tb1")
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(4, 1, "tb1")
        tdSql.checkData(5, 0, 0.465913680008469)
        tdSql.checkData(5, 1, "tb1")
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, "tb1")
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(7, 1, "tb2")
        tdSql.checkData(8, 0, 1.0)
        tdSql.checkData(8, 1, "tb2")
        tdSql.checkData(9, 0, 1.0)
        tdSql.checkData(9, 1, "tb2")
        tdSql.checkData(10, 0, 1.0)
        tdSql.checkData(10, 1, "tb2")
        tdSql.checkData(11, 0, 1.0)
        tdSql.checkData(11, 1, "tb2")
        tdSql.checkData(12, 0, 1.0)
        tdSql.checkData(12, 1, "tb2")
        tdSql.checkData(13, 0, 1.0)
        tdSql.checkData(13, 1, "tb2")

        tdSql.query("select log(c2,c3),tbname from stb1 where t1 > 1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(0, 1, "tb2")
        tdSql.checkData(1, 0, 1.0)
        tdSql.checkData(1, 1, "tb2")
        tdSql.checkData(2, 0, 1.0)
        tdSql.checkData(2, 1, "tb2")
        tdSql.checkData(3, 0, 1.0)
        tdSql.checkData(3, 1, "tb2")
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(4, 1, "tb2")
        tdSql.checkData(5, 0, 1.0)
        tdSql.checkData(5, 1, "tb2")
        tdSql.checkData(6, 0, 1.0)
        tdSql.checkData(6, 1, "tb2")

        tdSql.query("select log(c2,c2) from (select * from stb1);")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 1.0)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, 1.0)
        tdSql.checkData(9, 0, 1.0)
        tdSql.checkData(10, 0, 1.0)
        tdSql.checkData(11, 0, 1.0)
        tdSql.checkData(12, 0, 1.0)
        tdSql.checkData(13, 0, 1.0)

        tdSql.query("select log(c2,c3) from tb1 union all select log(c2,c3) from tb2;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.465913680008469)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, 1.0)
        tdSql.checkData(9, 0, 1.0)
        tdSql.checkData(10, 0, 1.0)
        tdSql.checkData(11, 0, 1.0)
        tdSql.checkData(12, 0, 1.0)
        tdSql.checkData(13, 0, 1.0)

        # ===========  end   math_log  ==========

        tdSql.execute(
            "create table stba (ts timestamp, c1 bool, c2 tinyint, c3 smallint, c4 int, c5 bigint, c6 float, c7 double, c8 binary(10), c9 nchar(10), c10 tinyint unsigned, c11 smallint unsigned, c12 int unsigned, c13 bigint unsigned) TAGS(t1 int, t2 binary(10), t3 double);"
        )

        tdSql.execute("create table tba1 using stba tags(1,'1',1.0);")

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:00\',true, 1,1,1,1,1,1,"111","1111",1,1,1,1);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:01\',true, 2,2,2,2,2,2,"222","2222",2,2,2,2);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:02\',true, 3,3,2,3,3,3,"333","3333",3,3,3,3);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:03\',false,4,4,4,4,4,4,"444","4444",4,4,4,4);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:04\',true, 5,5,5,5,5,5,"555","5555",5,5,5,5);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:05\',true, 6,6,6,6,6,6,"666","6666",6,6,6,6);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:06\',true, 7,7,7,7,7,7,"777","7777",7,7,7,7);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:07\',true, 8,8,8,8,8,8,"888","8888",8,8,8,8);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:08\',true, 9,9,9,9,9,9,"999","9999",9,9,9,9);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:09\',true, 0,0,0,0,0,0,"000","0000",0,0,0,0);'
        )

        self.restartTaosd(1, dbname="math_funcs")

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:10\',true, 1,1,1,1,1,1,"111","1111",1,1,1,1);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:11\',true, 2,2,2,2,2,2,"222","2222",2,2,2,2);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:12\',true, 3,3,2,3,3,3,"333","3333",3,3,3,3);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:13\',false,4,4,4,4,4,4,"444","4444",4,4,4,4);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:14\',true, 5,5,5,5,5,5,"555","5555",5,5,5,5);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:15\',true, 6,6,6,6,6,6,"666","6666",6,6,6,6);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:16\',true, 7,7,7,7,7,7,"777","7777",7,7,7,7);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:17\',true, 8,8,8,8,8,8,"888","8888",8,8,8,8);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:18\',true, 9,9,9,9,9,9,"999","9999",9,9,9,9);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:19\',true, 0,0,0,0,0,0,"000","0000",0,0,0,0);'
        )

        self.restartTaosd(1, dbname="math_funcs")

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:20\',true, 1,1,1,1,1,1,"111","1111",1,1,1,1);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:21\',true, 2,2,2,2,2,2,"222","2222",2,2,2,2);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:22\',true, 3,3,2,3,3,3,"333","3333",3,3,3,3);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:23\',false,4,4,4,4,4,4,"444","4444",4,4,4,4);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:24\',true, 5,5,5,5,5,5,"555","5555",5,5,5,5);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:25\',true, 6,6,6,6,6,6,"666","6666",6,6,6,6);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:26\',true, 7,7,7,7,7,7,"777","7777",7,7,7,7);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:27\',true, 8,8,8,8,8,8,"888","8888",8,8,8,8);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:28\',true, 9,9,9,9,9,9,"999","9999",9,9,9,9);'
        )

        tdSql.execute(
            'insert into tba1 values (\'2021-11-11 09:00:29\',true, 0,0,0,0,0,0,"000","0000",0,0,0,0);'
        )

        # ===========  begin math_sqrt  ==========
        tdSql.query("select sqrt(13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 3.605551275463989)
        tdSql.checkData(1, 0, 3.605551275463989)
        tdSql.checkData(2, 0, 3.605551275463989)
        tdSql.checkData(3, 0, 3.605551275463989)
        tdSql.checkData(4, 0, 3.605551275463989)
        tdSql.checkData(5, 0, 3.605551275463989)
        tdSql.checkData(6, 0, 3.605551275463989)

        tdSql.query("select sqrt(c2) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.4142135623730951)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 11.269427669584644)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt(c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 1.7320508075688772)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 181.01657382681842)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt(c4) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.4142135623730951)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 46340.950001051984)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt(c5) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 1.7320508075688772)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 3037000499.97605)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt(c6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.4142135623730951)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 1.844674352395373e19)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt(c7) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 1.7320508075688772)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 1.3407796239501852e154)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt(c10) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.4142135623730951)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 15.937377450509228)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select sqrt(c11) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 1.7320508075688772)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 255.99609372019722)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select sqrt(c12) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.4142135623730951)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 65535.99998474121)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select sqrt(c13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 1.7320508075688772)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 3037000499.97605)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select sqrt(a) from (select sqrt(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.189207115002721)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.4142135623730951)
        tdSql.checkData(5, 0, 3.3569968229929326)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt(c2 + c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.4142135623730951)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.8284271247461903)
        tdSql.checkData(5, 0, 181.36703118262702)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt((c2 + c3)) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.4142135623730951)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.8284271247461903)
        tdSql.checkData(5, 0, 181.36703118262702)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt((c2 * c3)+c4-6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 3.7416573867739413)
        tdSql.checkData(5, 0, 46385.82811592351)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt(11)+c2 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 4.3166247903554)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 5.3166247903554)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 7.3166247903554)
        tdSql.checkData(5, 0, 130.3166247903554)
        tdSql.checkData(6, 0, -123.6833752096446)

        tdSql.query("select sqrt(c2)+11 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 12.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 12.414213562373096)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 13.0)
        tdSql.checkData(5, 0, 22.269427669584644)
        tdSql.checkData(6, 0, nan)

        tdSql.query(
            "select sqrt(c2+c3) from tb1 where c2 is not null and c3 is not null;"
        )
        tdSql.checkRows(4)
        tdSql.checkData(0, 0, 1.4142135623730951)
        tdSql.checkData(1, 0, 2.8284271247461903)
        tdSql.checkData(2, 0, 181.36703118262702)
        tdSql.checkData(3, 0, nan)

        tdSql.query("select sqrt(c2) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, 11.269427669584644)
        tdSql.checkData(2, 0, 2.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.4142135623730951)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select sqrt(c2+c3) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, 181.36703118262702)
        tdSql.checkData(2, 0, 2.8284271247461903)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, None)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 1.4142135623730951)

        tdSql.query("select sqrt(c2+c3) from tb1 order by ts desc limit 3 offset 2;")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 2.8284271247461903)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)

        tdSql.query("select sqrt(c2) from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.4142135623730951)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 11.269427669584644)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 1.0)
        tdSql.checkData(8, 0, 1.4142135623730951)
        tdSql.checkData(9, 0, 1.7320508075688772)
        tdSql.checkData(10, 0, 2.0)
        tdSql.checkData(11, 0, 2.23606797749979)
        tdSql.checkData(12, 0, 2.449489742783178)
        tdSql.checkData(13, 0, 2.6457513110645907)

        tdSql.query("select sqrt(c2) from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select sqrt(c4),t1,c4 from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select sqrt(c3),tbname from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(0, 1, "tb1")
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, "tb1")
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, "tb1")
        tdSql.checkData(3, 0, 1.7320508075688772)
        tdSql.checkData(3, 1, "tb1")
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(4, 1, "tb1")
        tdSql.checkData(5, 0, 181.01657382681842)
        tdSql.checkData(5, 1, "tb1")
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, "tb1")
        tdSql.checkData(7, 0, 1.0)
        tdSql.checkData(7, 1, "tb2")
        tdSql.checkData(8, 0, 1.4142135623730951)
        tdSql.checkData(8, 1, "tb2")
        tdSql.checkData(9, 0, 1.7320508075688772)
        tdSql.checkData(9, 1, "tb2")
        tdSql.checkData(10, 0, 2.0)
        tdSql.checkData(10, 1, "tb2")
        tdSql.checkData(11, 0, 2.23606797749979)
        tdSql.checkData(11, 1, "tb2")
        tdSql.checkData(12, 0, 2.449489742783178)
        tdSql.checkData(12, 1, "tb2")
        tdSql.checkData(13, 0, 2.6457513110645907)
        tdSql.checkData(13, 1, "tb2")

        tdSql.query("select sqrt(c3),tbname from stb1 where t1 > 1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(0, 1, "tb2")
        tdSql.checkData(1, 0, 1.4142135623730951)
        tdSql.checkData(1, 1, "tb2")
        tdSql.checkData(2, 0, 1.7320508075688772)
        tdSql.checkData(2, 1, "tb2")
        tdSql.checkData(3, 0, 2.0)
        tdSql.checkData(3, 1, "tb2")
        tdSql.checkData(4, 0, 2.23606797749979)
        tdSql.checkData(4, 1, "tb2")
        tdSql.checkData(5, 0, 2.449489742783178)
        tdSql.checkData(5, 1, "tb2")
        tdSql.checkData(6, 0, 2.6457513110645907)
        tdSql.checkData(6, 1, "tb2")

        tdSql.query("select sqrt(a) from (select avg(c2) as a from stb1 interval(1s));")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, 1.4142135623730951)
        tdSql.checkData(2, 0, 1.5811388300841898)
        tdSql.checkData(3, 0, 2.0)
        tdSql.checkData(4, 0, 2.1213203435596424)
        tdSql.checkData(5, 0, 8.154753215150045)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select sqrt(c2) from (select * from stb1);")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.4142135623730951)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 11.269427669584644)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 1.0)
        tdSql.checkData(8, 0, 1.4142135623730951)
        tdSql.checkData(9, 0, 1.7320508075688772)
        tdSql.checkData(10, 0, 2.0)
        tdSql.checkData(11, 0, 2.23606797749979)
        tdSql.checkData(12, 0, 2.449489742783178)
        tdSql.checkData(13, 0, 2.6457513110645907)

        tdSql.query(
            "select sqrt(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null));"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, 1.4142135623730951)
        tdSql.checkData(2, 0, 1.5811388300841898)
        tdSql.checkData(3, 0, 2.0)
        tdSql.checkData(4, 0, 2.1213203435596424)
        tdSql.checkData(5, 0, 8.154753215150045)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select sqrt(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, 1.4142135623730951)
        tdSql.checkData(2, 0, 1.5811388300841898)
        tdSql.checkData(3, 0, 2.0)
        tdSql.checkData(4, 0, 2.1213203435596424)
        tdSql.checkData(5, 0, 8.154753215150045)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select sqrt(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, 8.154753215150045)
        tdSql.checkData(5, 0, 2.1213203435596424)
        tdSql.checkData(6, 0, 2.0)
        tdSql.checkData(7, 0, 1.5811388300841898)
        tdSql.checkData(8, 0, 1.4142135623730951)
        tdSql.checkData(9, 0, 1.0)

        tdSql.query(
            "select sqrt(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 8.154753215150045)
        tdSql.checkData(4, 0, 2.1213203435596424)
        tdSql.checkData(5, 0, 2.0)
        tdSql.checkData(6, 0, 1.5811388300841898)
        tdSql.checkData(7, 0, 1.4142135623730951)
        tdSql.checkData(8, 0, 1.0)
        tdSql.checkData(9, 0, nan)

        tdSql.query(
            "select sqrt(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, 1.0)
        tdSql.checkData(2, 0, 1.4142135623730951)
        tdSql.checkData(3, 0, 1.5811388300841898)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 2.1213203435596424)
        tdSql.checkData(6, 0, 8.154753215150045)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query("select sqrt(a) from (select sqrt(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.189207115002721)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.4142135623730951)
        tdSql.checkData(5, 0, 3.3569968229929326)
        tdSql.checkData(6, 0, nan)

        tdSql.query(
            "select sqrt(tb1.c3),sqrt(tb2.c3) from tb1,tb2 where tb1.ts=tb2.ts;"
        )
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(0, 1, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, 1.4142135623730951)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, 1.7320508075688772)
        tdSql.checkData(3, 0, 1.7320508075688772)
        tdSql.checkData(3, 1, 2.0)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(4, 1, 2.23606797749979)
        tdSql.checkData(5, 0, 181.01657382681842)
        tdSql.checkData(5, 1, 2.449489742783178)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, 2.6457513110645907)

        tdSql.query("select sqrt(c3) from tb1 union all select sqrt(c3) from tb2;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 1.7320508075688772)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 181.01657382681842)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 1.0)
        tdSql.checkData(8, 0, 1.4142135623730951)
        tdSql.checkData(9, 0, 1.7320508075688772)
        tdSql.checkData(10, 0, 2.0)
        tdSql.checkData(11, 0, 2.23606797749979)
        tdSql.checkData(12, 0, 2.449489742783178)
        tdSql.checkData(13, 0, 2.6457513110645907)

        # ===========  end   math_sqrt  ==========

        # ===========  begin math_sqrt2  ==========
        tdSql.query(
            "select sqrt(stb1.c4),sqrt(stba.c5) from stb1,stba where stb1.t1=stba.t1 and stb1.ts=stba.ts;"
        )
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(0, 1, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, 1.4142135623730951)
        tdSql.checkData(2, 0, 1.4142135623730951)
        tdSql.checkData(2, 1, 1.7320508075688772)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(3, 1, 2.0)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(4, 1, 2.23606797749979)
        tdSql.checkData(5, 0, 46340.950001051984)
        tdSql.checkData(5, 1, 2.449489742783178)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, 2.6457513110645907)

        tdSql.query(
            "select sqrt(c4) as a from stb1 union all select sqrt(c5) as a from stba;"
        )
        tdSql.checkRows(44)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.4142135623730951)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.0)
        tdSql.checkData(5, 0, 46340.950001051984)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 1.0)
        tdSql.checkData(8, 0, 1.4142135623730951)
        tdSql.checkData(9, 0, 1.4142135623730951)
        tdSql.checkData(10, 0, 2.0)
        tdSql.checkData(11, 0, 2.23606797749979)
        tdSql.checkData(12, 0, 2.449489742783178)
        tdSql.checkData(13, 0, 2.6457513110645907)
        tdSql.checkData(14, 0, 1.0)
        tdSql.checkData(15, 0, 1.4142135623730951)
        tdSql.checkData(16, 0, 1.7320508075688772)
        tdSql.checkData(17, 0, 2.0)
        tdSql.checkData(18, 0, 2.23606797749979)
        tdSql.checkData(19, 0, 2.449489742783178)
        tdSql.checkData(20, 0, 2.6457513110645907)
        tdSql.checkData(21, 0, 2.8284271247461903)
        tdSql.checkData(22, 0, 3.0)
        tdSql.checkData(23, 0, 0.0)
        tdSql.checkData(24, 0, 1.0)
        tdSql.checkData(25, 0, 1.4142135623730951)
        tdSql.checkData(26, 0, 1.7320508075688772)
        tdSql.checkData(27, 0, 2.0)
        tdSql.checkData(28, 0, 2.23606797749979)
        tdSql.checkData(29, 0, 2.449489742783178)
        tdSql.checkData(30, 0, 2.6457513110645907)
        tdSql.checkData(31, 0, 2.8284271247461903)
        tdSql.checkData(32, 0, 3.0)
        tdSql.checkData(33, 0, 0.0)
        tdSql.checkData(34, 0, 1.0)
        tdSql.checkData(35, 0, 1.4142135623730951)
        tdSql.checkData(36, 0, 1.7320508075688772)
        tdSql.checkData(37, 0, 2.0)
        tdSql.checkData(38, 0, 2.23606797749979)
        tdSql.checkData(39, 0, 2.449489742783178)
        tdSql.checkData(40, 0, 2.6457513110645907)
        tdSql.checkData(41, 0, 2.8284271247461903)
        tdSql.checkData(42, 0, 3.0)
        tdSql.checkData(43, 0, 0.0)

        tdSql.query("select sqrt(c2) from stba;")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, 1.4142135623730951)
        tdSql.checkData(2, 0, 1.7320508075688772)
        tdSql.checkData(3, 0, 2.0)
        tdSql.checkData(4, 0, 2.23606797749979)
        tdSql.checkData(5, 0, 2.449489742783178)
        tdSql.checkData(6, 0, 2.6457513110645907)
        tdSql.checkData(7, 0, 2.8284271247461903)
        tdSql.checkData(8, 0, 3.0)
        tdSql.checkData(9, 0, 0.0)
        tdSql.checkData(10, 0, 1.0)
        tdSql.checkData(11, 0, 1.4142135623730951)
        tdSql.checkData(12, 0, 1.7320508075688772)
        tdSql.checkData(13, 0, 2.0)
        tdSql.checkData(14, 0, 2.23606797749979)
        tdSql.checkData(15, 0, 2.449489742783178)
        tdSql.checkData(16, 0, 2.6457513110645907)
        tdSql.checkData(17, 0, 2.8284271247461903)
        tdSql.checkData(18, 0, 3.0)
        tdSql.checkData(19, 0, 0.0)
        tdSql.checkData(20, 0, 1.0)
        tdSql.checkData(21, 0, 1.4142135623730951)
        tdSql.checkData(22, 0, 1.7320508075688772)
        tdSql.checkData(23, 0, 2.0)
        tdSql.checkData(24, 0, 2.23606797749979)
        tdSql.checkData(25, 0, 2.449489742783178)
        tdSql.checkData(26, 0, 2.6457513110645907)
        tdSql.checkData(27, 0, 2.8284271247461903)
        tdSql.checkData(28, 0, 3.0)
        tdSql.checkData(29, 0, 0.0)

        tdSql.query("select sqrt(min(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        tdSql.query("select sqrt(max(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 3.0)

        tdSql.query("select sqrt(count(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 5.477225575051661)

        tdSql.query("select sqrt(sum(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 11.61895003862225)

        tdSql.query("select sqrt(avg(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2.1213203435596424)

        tdSql.query("select sqrt(percentile(c2, 10)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.9486832980505138)

        tdSql.query("select sqrt(apercentile(c2, 10)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        tdSql.query("select sqrt(stddev(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.694780612135097)

        tdSql.query("select sqrt(spread(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 3.0)

        tdSql.query("select sqrt(twa(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2.1535856227423973)

        tdSql.query("select sqrt(interp(c2)) from tba1 every(1s)")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, datetime.datetime(2021, 11, 11, 9, 0))
        tdSql.checkData(0, 1, 1.0)
        tdSql.checkData(1, 0, datetime.datetime(2021, 11, 11, 9, 0, 1))
        tdSql.checkData(1, 1, 1.4142135623730951)
        tdSql.checkData(2, 0, datetime.datetime(2021, 11, 11, 9, 0, 2))
        tdSql.checkData(2, 1, 1.7320508075688772)
        tdSql.checkData(3, 0, datetime.datetime(2021, 11, 11, 9, 0, 3))
        tdSql.checkData(3, 1, 2.0)
        tdSql.checkData(4, 0, datetime.datetime(2021, 11, 11, 9, 0, 4))
        tdSql.checkData(4, 1, 2.23606797749979)
        tdSql.checkData(5, 0, datetime.datetime(2021, 11, 11, 9, 0, 5))
        tdSql.checkData(5, 1, 2.449489742783178)
        tdSql.checkData(6, 0, datetime.datetime(2021, 11, 11, 9, 0, 6))
        tdSql.checkData(6, 1, 2.6457513110645907)
        tdSql.checkData(7, 0, datetime.datetime(2021, 11, 11, 9, 0, 7))
        tdSql.checkData(7, 1, 2.8284271247461903)
        tdSql.checkData(8, 0, datetime.datetime(2021, 11, 11, 9, 0, 8))
        tdSql.checkData(8, 1, 3.0)
        tdSql.checkData(9, 0, datetime.datetime(2021, 11, 11, 9, 0, 9))
        tdSql.checkData(9, 1, 0.0)
        tdSql.checkData(10, 0, datetime.datetime(2021, 11, 11, 9, 0, 10))
        tdSql.checkData(10, 1, 1.0)
        tdSql.checkData(11, 0, datetime.datetime(2021, 11, 11, 9, 0, 11))
        tdSql.checkData(11, 1, 1.4142135623730951)
        tdSql.checkData(12, 0, datetime.datetime(2021, 11, 11, 9, 0, 12))
        tdSql.checkData(12, 1, 1.7320508075688772)
        tdSql.checkData(13, 0, datetime.datetime(2021, 11, 11, 9, 0, 13))
        tdSql.checkData(13, 1, 2.0)
        tdSql.checkData(14, 0, datetime.datetime(2021, 11, 11, 9, 0, 14))
        tdSql.checkData(14, 1, 2.23606797749979)
        tdSql.checkData(15, 0, datetime.datetime(2021, 11, 11, 9, 0, 15))
        tdSql.checkData(15, 1, 2.449489742783178)
        tdSql.checkData(16, 0, datetime.datetime(2021, 11, 11, 9, 0, 16))
        tdSql.checkData(16, 1, 2.6457513110645907)
        tdSql.checkData(17, 0, datetime.datetime(2021, 11, 11, 9, 0, 17))
        tdSql.checkData(17, 1, 2.8284271247461903)
        tdSql.checkData(18, 0, datetime.datetime(2021, 11, 11, 9, 0, 18))
        tdSql.checkData(18, 1, 3.0)
        tdSql.checkData(19, 0, datetime.datetime(2021, 11, 11, 9, 0, 19))
        tdSql.checkData(19, 1, 0.0)
        tdSql.checkData(20, 0, datetime.datetime(2021, 11, 11, 9, 0, 20))
        tdSql.checkData(20, 1, 1.0)
        tdSql.checkData(21, 0, datetime.datetime(2021, 11, 11, 9, 0, 21))
        tdSql.checkData(21, 1, 1.4142135623730951)
        tdSql.checkData(22, 0, datetime.datetime(2021, 11, 11, 9, 0, 22))
        tdSql.checkData(22, 1, 1.7320508075688772)
        tdSql.checkData(23, 0, datetime.datetime(2021, 11, 11, 9, 0, 23))
        tdSql.checkData(23, 1, 2.0)
        tdSql.checkData(24, 0, datetime.datetime(2021, 11, 11, 9, 0, 24))
        tdSql.checkData(24, 1, 2.23606797749979)
        tdSql.checkData(25, 0, datetime.datetime(2021, 11, 11, 9, 0, 25))
        tdSql.checkData(25, 1, 2.449489742783178)
        tdSql.checkData(26, 0, datetime.datetime(2021, 11, 11, 9, 0, 26))
        tdSql.checkData(26, 1, 2.6457513110645907)
        tdSql.checkData(27, 0, datetime.datetime(2021, 11, 11, 9, 0, 27))
        tdSql.checkData(27, 1, 2.8284271247461903)
        tdSql.checkData(28, 0, datetime.datetime(2021, 11, 11, 9, 0, 28))
        tdSql.checkData(28, 1, 3.0)
        tdSql.checkData(29, 0, datetime.datetime(2021, 11, 11, 9, 0, 29))
        tdSql.checkData(29, 1, 0.0)

        tdSql.query("select sqrt(interp(c2)) from stba every(1s) group by tbname;")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, datetime.datetime(2021, 11, 11, 9, 0))
        tdSql.checkData(0, 1, 1.0)
        tdSql.checkData(0, 2, "tba1")
        tdSql.checkData(1, 0, datetime.datetime(2021, 11, 11, 9, 0, 1))
        tdSql.checkData(1, 1, 1.4142135623730951)
        tdSql.checkData(1, 2, "tba1")
        tdSql.checkData(2, 0, datetime.datetime(2021, 11, 11, 9, 0, 2))
        tdSql.checkData(2, 1, 1.7320508075688772)
        tdSql.checkData(2, 2, "tba1")
        tdSql.checkData(3, 0, datetime.datetime(2021, 11, 11, 9, 0, 3))
        tdSql.checkData(3, 1, 2.0)
        tdSql.checkData(3, 2, "tba1")
        tdSql.checkData(4, 0, datetime.datetime(2021, 11, 11, 9, 0, 4))
        tdSql.checkData(4, 1, 2.23606797749979)
        tdSql.checkData(4, 2, "tba1")
        tdSql.checkData(5, 0, datetime.datetime(2021, 11, 11, 9, 0, 5))
        tdSql.checkData(5, 1, 2.449489742783178)
        tdSql.checkData(5, 2, "tba1")
        tdSql.checkData(6, 0, datetime.datetime(2021, 11, 11, 9, 0, 6))
        tdSql.checkData(6, 1, 2.6457513110645907)
        tdSql.checkData(6, 2, "tba1")
        tdSql.checkData(7, 0, datetime.datetime(2021, 11, 11, 9, 0, 7))
        tdSql.checkData(7, 1, 2.8284271247461903)
        tdSql.checkData(7, 2, "tba1")
        tdSql.checkData(8, 0, datetime.datetime(2021, 11, 11, 9, 0, 8))
        tdSql.checkData(8, 1, 3.0)
        tdSql.checkData(8, 2, "tba1")
        tdSql.checkData(9, 0, datetime.datetime(2021, 11, 11, 9, 0, 9))
        tdSql.checkData(9, 1, 0.0)
        tdSql.checkData(9, 2, "tba1")
        tdSql.checkData(10, 0, datetime.datetime(2021, 11, 11, 9, 0, 10))
        tdSql.checkData(10, 1, 1.0)
        tdSql.checkData(10, 2, "tba1")
        tdSql.checkData(11, 0, datetime.datetime(2021, 11, 11, 9, 0, 11))
        tdSql.checkData(11, 1, 1.4142135623730951)
        tdSql.checkData(11, 2, "tba1")
        tdSql.checkData(12, 0, datetime.datetime(2021, 11, 11, 9, 0, 12))
        tdSql.checkData(12, 1, 1.7320508075688772)
        tdSql.checkData(12, 2, "tba1")
        tdSql.checkData(13, 0, datetime.datetime(2021, 11, 11, 9, 0, 13))
        tdSql.checkData(13, 1, 2.0)
        tdSql.checkData(13, 2, "tba1")
        tdSql.checkData(14, 0, datetime.datetime(2021, 11, 11, 9, 0, 14))
        tdSql.checkData(14, 1, 2.23606797749979)
        tdSql.checkData(14, 2, "tba1")
        tdSql.checkData(15, 0, datetime.datetime(2021, 11, 11, 9, 0, 15))
        tdSql.checkData(15, 1, 2.449489742783178)
        tdSql.checkData(15, 2, "tba1")
        tdSql.checkData(16, 0, datetime.datetime(2021, 11, 11, 9, 0, 16))
        tdSql.checkData(16, 1, 2.6457513110645907)
        tdSql.checkData(16, 2, "tba1")
        tdSql.checkData(17, 0, datetime.datetime(2021, 11, 11, 9, 0, 17))
        tdSql.checkData(17, 1, 2.8284271247461903)
        tdSql.checkData(17, 2, "tba1")
        tdSql.checkData(18, 0, datetime.datetime(2021, 11, 11, 9, 0, 18))
        tdSql.checkData(18, 1, 3.0)
        tdSql.checkData(18, 2, "tba1")
        tdSql.checkData(19, 0, datetime.datetime(2021, 11, 11, 9, 0, 19))
        tdSql.checkData(19, 1, 0.0)
        tdSql.checkData(19, 2, "tba1")
        tdSql.checkData(20, 0, datetime.datetime(2021, 11, 11, 9, 0, 20))
        tdSql.checkData(20, 1, 1.0)
        tdSql.checkData(20, 2, "tba1")
        tdSql.checkData(21, 0, datetime.datetime(2021, 11, 11, 9, 0, 21))
        tdSql.checkData(21, 1, 1.4142135623730951)
        tdSql.checkData(21, 2, "tba1")
        tdSql.checkData(22, 0, datetime.datetime(2021, 11, 11, 9, 0, 22))
        tdSql.checkData(22, 1, 1.7320508075688772)
        tdSql.checkData(22, 2, "tba1")
        tdSql.checkData(23, 0, datetime.datetime(2021, 11, 11, 9, 0, 23))
        tdSql.checkData(23, 1, 2.0)
        tdSql.checkData(23, 2, "tba1")
        tdSql.checkData(24, 0, datetime.datetime(2021, 11, 11, 9, 0, 24))
        tdSql.checkData(24, 1, 2.23606797749979)
        tdSql.checkData(24, 2, "tba1")
        tdSql.checkData(25, 0, datetime.datetime(2021, 11, 11, 9, 0, 25))
        tdSql.checkData(25, 1, 2.449489742783178)
        tdSql.checkData(25, 2, "tba1")
        tdSql.checkData(26, 0, datetime.datetime(2021, 11, 11, 9, 0, 26))
        tdSql.checkData(26, 1, 2.6457513110645907)
        tdSql.checkData(26, 2, "tba1")
        tdSql.checkData(27, 0, datetime.datetime(2021, 11, 11, 9, 0, 27))
        tdSql.checkData(27, 1, 2.8284271247461903)
        tdSql.checkData(27, 2, "tba1")
        tdSql.checkData(28, 0, datetime.datetime(2021, 11, 11, 9, 0, 28))
        tdSql.checkData(28, 1, 3.0)
        tdSql.checkData(28, 2, "tba1")
        tdSql.checkData(29, 0, datetime.datetime(2021, 11, 11, 9, 0, 29))
        tdSql.checkData(29, 1, 0.0)
        tdSql.checkData(29, 2, "tba1")

        tdSql.query("select sqrt(elapsed(ts)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 170.29386365926402)

        tdSql.query("select sqrt(rate(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.9468641529479986)

        tdSql.query("select sqrt(irate(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        tdSql.query("select sqrt(first(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.0)

        tdSql.query("select sqrt(last(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        tdSql.query("select sqrt(last_row(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        # ===========  end   math_sqrt2  ==========

        # ===========  begin math_abs  ==========
        tdSql.query("select abs(13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 13)
        tdSql.checkData(1, 0, 13)
        tdSql.checkData(2, 0, 13)
        tdSql.checkData(3, 0, 13)
        tdSql.checkData(4, 0, 13)
        tdSql.checkData(5, 0, 13)
        tdSql.checkData(6, 0, 13)

        tdSql.query("select abs(c2) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 127)
        tdSql.checkData(6, 0, 127)

        tdSql.query("select abs(c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 3)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 32767)
        tdSql.checkData(6, 0, 32767)

        tdSql.query("select abs(c4) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 2147483647)
        tdSql.checkData(6, 0, 2147483647)

        tdSql.query("select abs(c5) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 3)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 9223372036854775807)
        tdSql.checkData(6, 0, 9223372036854775807)

        tdSql.query("select abs(c6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4.0)
        tdSql.checkData(5, 0, 3.4028234663852886e38)
        tdSql.checkData(6, 0, 3.4028234663852886e38)

        tdSql.query("select abs(c7) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 3.0)
        tdSql.checkData(4, 0, 4.0)
        tdSql.checkData(5, 0, 1.79769e308)
        tdSql.checkData(6, 0, 1.79769e308)

        tdSql.query("select abs(c10) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 254)
        tdSql.checkData(6, 0, 0)

        tdSql.query("select abs(c11) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 3)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 65534)
        tdSql.checkData(6, 0, 0)

        tdSql.query("select abs(c12) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 4294967294)
        tdSql.checkData(6, 0, 0)

        tdSql.query("select abs(c13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 3)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 9223372036854775807)
        tdSql.checkData(6, 0, 0)

        tdSql.query("select abs(a) from (select abs(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 127)
        tdSql.checkData(6, 0, 127)

        tdSql.query("select abs(c2 + c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 2.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 8.0)
        tdSql.checkData(5, 0, 32894.0)
        tdSql.checkData(6, 0, 32894.0)

        tdSql.query("select abs((c2 + c3)) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 2.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 8.0)
        tdSql.checkData(5, 0, 32894.0)
        tdSql.checkData(6, 0, 32894.0)

        tdSql.query("select abs((c2 * c3)+c4-6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 4.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 14.0)
        tdSql.checkData(5, 0, 2151645050.0)
        tdSql.checkData(6, 0, 2143322244.0)

        tdSql.query("select abs(11)+c2 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 12.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 13.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 15.0)
        tdSql.checkData(5, 0, 138.0)
        tdSql.checkData(6, 0, -116.0)

        tdSql.query("select abs(c2)+11 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 12.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 13.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 15.0)
        tdSql.checkData(5, 0, 138.0)
        tdSql.checkData(6, 0, 138.0)

        tdSql.query(
            "select abs(c2+c3) from tb1 where c2 is not null and c3 is not null;"
        )
        tdSql.checkRows(4)
        tdSql.checkData(0, 0, 2.0)
        tdSql.checkData(1, 0, 8.0)
        tdSql.checkData(2, 0, 32894.0)
        tdSql.checkData(3, 0, 32894.0)

        tdSql.query("select abs(c2) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 127)
        tdSql.checkData(1, 0, 127)
        tdSql.checkData(2, 0, 4)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 1)

        tdSql.query("select abs(c2+c3) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 32894.0)
        tdSql.checkData(1, 0, 32894.0)
        tdSql.checkData(2, 0, 8.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, None)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 2.0)

        tdSql.query("select abs(c2+c3) from tb1 order by ts desc limit 3 offset 2;")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 8.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)

        tdSql.query("select abs(c2) from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 127)
        tdSql.checkData(6, 0, 127)
        tdSql.checkData(7, 0, 1)
        tdSql.checkData(8, 0, 2)
        tdSql.checkData(9, 0, 3)
        tdSql.checkData(10, 0, 4)
        tdSql.checkData(11, 0, 5)
        tdSql.checkData(12, 0, 6)
        tdSql.checkData(13, 0, 7)

        tdSql.query("select abs(c2) from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select abs(c4),t1 from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select abs(c3),tbname from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, "tb1")
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, "tb1")
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, "tb1")
        tdSql.checkData(3, 0, 3)
        tdSql.checkData(3, 1, "tb1")
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(4, 1, "tb1")
        tdSql.checkData(5, 0, 32767)
        tdSql.checkData(5, 1, "tb1")
        tdSql.checkData(6, 0, 32767)
        tdSql.checkData(6, 1, "tb1")
        tdSql.checkData(7, 0, 1)
        tdSql.checkData(7, 1, "tb2")
        tdSql.checkData(8, 0, 2)
        tdSql.checkData(8, 1, "tb2")
        tdSql.checkData(9, 0, 3)
        tdSql.checkData(9, 1, "tb2")
        tdSql.checkData(10, 0, 4)
        tdSql.checkData(10, 1, "tb2")
        tdSql.checkData(11, 0, 5)
        tdSql.checkData(11, 1, "tb2")
        tdSql.checkData(12, 0, 6)
        tdSql.checkData(12, 1, "tb2")
        tdSql.checkData(13, 0, 7)
        tdSql.checkData(13, 1, "tb2")

        tdSql.query("select abs(c3),tbname from stb1 where t1 > 1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, "tb2")
        tdSql.checkData(1, 0, 2)
        tdSql.checkData(1, 1, "tb2")
        tdSql.checkData(2, 0, 3)
        tdSql.checkData(2, 1, "tb2")
        tdSql.checkData(3, 0, 4)
        tdSql.checkData(3, 1, "tb2")
        tdSql.checkData(4, 0, 5)
        tdSql.checkData(4, 1, "tb2")
        tdSql.checkData(5, 0, 6)
        tdSql.checkData(5, 1, "tb2")
        tdSql.checkData(6, 0, 7)
        tdSql.checkData(6, 1, "tb2")

        tdSql.query("select abs(a) from (select avg(c2) as a from stb1 interval(1s));")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, 2.0)
        tdSql.checkData(2, 0, 2.5)
        tdSql.checkData(3, 0, 4.0)
        tdSql.checkData(4, 0, 4.5)
        tdSql.checkData(5, 0, 66.5)
        tdSql.checkData(6, 0, 60.0)

        tdSql.query("select abs(c2) from (select * from stb1);")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 127)
        tdSql.checkData(6, 0, 127)
        tdSql.checkData(7, 0, 1)
        tdSql.checkData(8, 0, 2)
        tdSql.checkData(9, 0, 3)
        tdSql.checkData(10, 0, 4)
        tdSql.checkData(11, 0, 5)
        tdSql.checkData(12, 0, 6)
        tdSql.checkData(13, 0, 7)

        tdSql.query(
            "select abs(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null));"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, 2.0)
        tdSql.checkData(2, 0, 2.5)
        tdSql.checkData(3, 0, 4.0)
        tdSql.checkData(4, 0, 4.5)
        tdSql.checkData(5, 0, 66.5)
        tdSql.checkData(6, 0, 60.0)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select abs(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, 2.0)
        tdSql.checkData(2, 0, 2.5)
        tdSql.checkData(3, 0, 4.0)
        tdSql.checkData(4, 0, 4.5)
        tdSql.checkData(5, 0, 66.5)
        tdSql.checkData(6, 0, 60.0)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select abs(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 60.0)
        tdSql.checkData(4, 0, 66.5)
        tdSql.checkData(5, 0, 4.5)
        tdSql.checkData(6, 0, 4.0)
        tdSql.checkData(7, 0, 2.5)
        tdSql.checkData(8, 0, 2.0)
        tdSql.checkData(9, 0, 1.0)

        tdSql.query(
            "select abs(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 66.5)
        tdSql.checkData(4, 0, 4.5)
        tdSql.checkData(5, 0, 4.0)
        tdSql.checkData(6, 0, 2.5)
        tdSql.checkData(7, 0, 2.0)
        tdSql.checkData(8, 0, 1.0)
        tdSql.checkData(9, 0, 60.0)

        tdSql.query(
            "select abs(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 60.0)
        tdSql.checkData(1, 0, 1.0)
        tdSql.checkData(2, 0, 2.0)
        tdSql.checkData(3, 0, 2.5)
        tdSql.checkData(4, 0, 4.0)
        tdSql.checkData(5, 0, 4.5)
        tdSql.checkData(6, 0, 66.5)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query("select abs(a) from (select abs(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 127)
        tdSql.checkData(6, 0, 127)

        tdSql.query("select abs(tb1.c3),abs(tb2.c3) from tb1,tb2 where tb1.ts=tb2.ts;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, 2)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, 3)
        tdSql.checkData(3, 0, 3)
        tdSql.checkData(3, 1, 4)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(4, 1, 5)
        tdSql.checkData(5, 0, 32767)
        tdSql.checkData(5, 1, 6)
        tdSql.checkData(6, 0, 32767)
        tdSql.checkData(6, 1, 7)

        tdSql.query("select abs(c3) from tb1 union all select abs(c3) from tb2;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 3)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 32767)
        tdSql.checkData(6, 0, 32767)
        tdSql.checkData(7, 0, 1)
        tdSql.checkData(8, 0, 2)
        tdSql.checkData(9, 0, 3)
        tdSql.checkData(10, 0, 4)
        tdSql.checkData(11, 0, 5)
        tdSql.checkData(12, 0, 6)
        tdSql.checkData(13, 0, 7)

        # ===========  end   math_abs  ==========

        # ===========  begin math_abs2  ==========
        tdSql.query(
            "select abs(stb1.c4),abs(stba.c5) from stb1,stba where stb1.t1=stba.t1 and stb1.ts=stba.ts;"
        )
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, 2)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(2, 1, 3)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(3, 1, 4)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(4, 1, 5)
        tdSql.checkData(5, 0, 2147483647)
        tdSql.checkData(5, 1, 6)
        tdSql.checkData(6, 0, 2147483647)
        tdSql.checkData(6, 1, 7)

        tdSql.query(
            "select abs(c4) as a from stb1 union all select abs(c5) as a from stba;"
        )
        tdSql.checkRows(44)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(5, 0, 2147483647)
        tdSql.checkData(6, 0, 2147483647)
        tdSql.checkData(7, 0, 1)
        tdSql.checkData(8, 0, 2)
        tdSql.checkData(9, 0, 2)
        tdSql.checkData(10, 0, 4)
        tdSql.checkData(11, 0, 5)
        tdSql.checkData(12, 0, 6)
        tdSql.checkData(13, 0, 7)
        tdSql.checkData(14, 0, 1)
        tdSql.checkData(15, 0, 2)
        tdSql.checkData(16, 0, 3)
        tdSql.checkData(17, 0, 4)
        tdSql.checkData(18, 0, 5)
        tdSql.checkData(19, 0, 6)
        tdSql.checkData(20, 0, 7)
        tdSql.checkData(21, 0, 8)
        tdSql.checkData(22, 0, 9)
        tdSql.checkData(23, 0, 0)
        tdSql.checkData(24, 0, 1)
        tdSql.checkData(25, 0, 2)
        tdSql.checkData(26, 0, 3)
        tdSql.checkData(27, 0, 4)
        tdSql.checkData(28, 0, 5)
        tdSql.checkData(29, 0, 6)
        tdSql.checkData(30, 0, 7)
        tdSql.checkData(31, 0, 8)
        tdSql.checkData(32, 0, 9)
        tdSql.checkData(33, 0, 0)
        tdSql.checkData(34, 0, 1)
        tdSql.checkData(35, 0, 2)
        tdSql.checkData(36, 0, 3)
        tdSql.checkData(37, 0, 4)
        tdSql.checkData(38, 0, 5)
        tdSql.checkData(39, 0, 6)
        tdSql.checkData(40, 0, 7)
        tdSql.checkData(41, 0, 8)
        tdSql.checkData(42, 0, 9)
        tdSql.checkData(43, 0, 0)

        tdSql.query("select abs(c2) from stba;")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 2)
        tdSql.checkData(2, 0, 3)
        tdSql.checkData(3, 0, 4)
        tdSql.checkData(4, 0, 5)
        tdSql.checkData(5, 0, 6)
        tdSql.checkData(6, 0, 7)
        tdSql.checkData(7, 0, 8)
        tdSql.checkData(8, 0, 9)
        tdSql.checkData(9, 0, 0)
        tdSql.checkData(10, 0, 1)
        tdSql.checkData(11, 0, 2)
        tdSql.checkData(12, 0, 3)
        tdSql.checkData(13, 0, 4)
        tdSql.checkData(14, 0, 5)
        tdSql.checkData(15, 0, 6)
        tdSql.checkData(16, 0, 7)
        tdSql.checkData(17, 0, 8)
        tdSql.checkData(18, 0, 9)
        tdSql.checkData(19, 0, 0)
        tdSql.checkData(20, 0, 1)
        tdSql.checkData(21, 0, 2)
        tdSql.checkData(22, 0, 3)
        tdSql.checkData(23, 0, 4)
        tdSql.checkData(24, 0, 5)
        tdSql.checkData(25, 0, 6)
        tdSql.checkData(26, 0, 7)
        tdSql.checkData(27, 0, 8)
        tdSql.checkData(28, 0, 9)
        tdSql.checkData(29, 0, 0)

        tdSql.query("select abs(min(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select abs(max(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 9)

        tdSql.query("select abs(count(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 30)

        tdSql.query("select abs(sum(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 135)

        tdSql.query("select abs(avg(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 4.5)

        tdSql.query("select abs(percentile(c2, 10)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.8999999999999999)

        tdSql.query("select abs(apercentile(c2, 10)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        tdSql.query("select abs(stddev(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 2.8722813232690143)

        tdSql.query("select abs(spread(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 9.0)

        tdSql.query("select abs(twa(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 4.637931034482759)

        tdSql.query("select abs(interp(c2)) from tba1 every(1s)")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, datetime.datetime(2021, 11, 11, 9, 0))
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(1, 0, datetime.datetime(2021, 11, 11, 9, 0, 1))
        tdSql.checkData(1, 1, 2)
        tdSql.checkData(2, 0, datetime.datetime(2021, 11, 11, 9, 0, 2))
        tdSql.checkData(2, 1, 3)
        tdSql.checkData(3, 0, datetime.datetime(2021, 11, 11, 9, 0, 3))
        tdSql.checkData(3, 1, 4)
        tdSql.checkData(4, 0, datetime.datetime(2021, 11, 11, 9, 0, 4))
        tdSql.checkData(4, 1, 5)
        tdSql.checkData(5, 0, datetime.datetime(2021, 11, 11, 9, 0, 5))
        tdSql.checkData(5, 1, 6)
        tdSql.checkData(6, 0, datetime.datetime(2021, 11, 11, 9, 0, 6))
        tdSql.checkData(6, 1, 7)
        tdSql.checkData(7, 0, datetime.datetime(2021, 11, 11, 9, 0, 7))
        tdSql.checkData(7, 1, 8)
        tdSql.checkData(8, 0, datetime.datetime(2021, 11, 11, 9, 0, 8))
        tdSql.checkData(8, 1, 9)
        tdSql.checkData(9, 0, datetime.datetime(2021, 11, 11, 9, 0, 9))
        tdSql.checkData(9, 1, 0)
        tdSql.checkData(10, 0, datetime.datetime(2021, 11, 11, 9, 0, 10))
        tdSql.checkData(10, 1, 1)
        tdSql.checkData(11, 0, datetime.datetime(2021, 11, 11, 9, 0, 11))
        tdSql.checkData(11, 1, 2)
        tdSql.checkData(12, 0, datetime.datetime(2021, 11, 11, 9, 0, 12))
        tdSql.checkData(12, 1, 3)
        tdSql.checkData(13, 0, datetime.datetime(2021, 11, 11, 9, 0, 13))
        tdSql.checkData(13, 1, 4)
        tdSql.checkData(14, 0, datetime.datetime(2021, 11, 11, 9, 0, 14))
        tdSql.checkData(14, 1, 5)
        tdSql.checkData(15, 0, datetime.datetime(2021, 11, 11, 9, 0, 15))
        tdSql.checkData(15, 1, 6)
        tdSql.checkData(16, 0, datetime.datetime(2021, 11, 11, 9, 0, 16))
        tdSql.checkData(16, 1, 7)
        tdSql.checkData(17, 0, datetime.datetime(2021, 11, 11, 9, 0, 17))
        tdSql.checkData(17, 1, 8)
        tdSql.checkData(18, 0, datetime.datetime(2021, 11, 11, 9, 0, 18))
        tdSql.checkData(18, 1, 9)
        tdSql.checkData(19, 0, datetime.datetime(2021, 11, 11, 9, 0, 19))
        tdSql.checkData(19, 1, 0)
        tdSql.checkData(20, 0, datetime.datetime(2021, 11, 11, 9, 0, 20))
        tdSql.checkData(20, 1, 1)
        tdSql.checkData(21, 0, datetime.datetime(2021, 11, 11, 9, 0, 21))
        tdSql.checkData(21, 1, 2)
        tdSql.checkData(22, 0, datetime.datetime(2021, 11, 11, 9, 0, 22))
        tdSql.checkData(22, 1, 3)
        tdSql.checkData(23, 0, datetime.datetime(2021, 11, 11, 9, 0, 23))
        tdSql.checkData(23, 1, 4)
        tdSql.checkData(24, 0, datetime.datetime(2021, 11, 11, 9, 0, 24))
        tdSql.checkData(24, 1, 5)
        tdSql.checkData(25, 0, datetime.datetime(2021, 11, 11, 9, 0, 25))
        tdSql.checkData(25, 1, 6)
        tdSql.checkData(26, 0, datetime.datetime(2021, 11, 11, 9, 0, 26))
        tdSql.checkData(26, 1, 7)
        tdSql.checkData(27, 0, datetime.datetime(2021, 11, 11, 9, 0, 27))
        tdSql.checkData(27, 1, 8)
        tdSql.checkData(28, 0, datetime.datetime(2021, 11, 11, 9, 0, 28))
        tdSql.checkData(28, 1, 9)
        tdSql.checkData(29, 0, datetime.datetime(2021, 11, 11, 9, 0, 29))
        tdSql.checkData(29, 1, 0)

        tdSql.query("select abs(interp(c2)) from stba every(1s) group by tbname;")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, datetime.datetime(2021, 11, 11, 9, 0))
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(0, 2, "tba1")
        tdSql.checkData(1, 0, datetime.datetime(2021, 11, 11, 9, 0, 1))
        tdSql.checkData(1, 1, 2)
        tdSql.checkData(1, 2, "tba1")
        tdSql.checkData(2, 0, datetime.datetime(2021, 11, 11, 9, 0, 2))
        tdSql.checkData(2, 1, 3)
        tdSql.checkData(2, 2, "tba1")
        tdSql.checkData(3, 0, datetime.datetime(2021, 11, 11, 9, 0, 3))
        tdSql.checkData(3, 1, 4)
        tdSql.checkData(3, 2, "tba1")
        tdSql.checkData(4, 0, datetime.datetime(2021, 11, 11, 9, 0, 4))
        tdSql.checkData(4, 1, 5)
        tdSql.checkData(4, 2, "tba1")
        tdSql.checkData(5, 0, datetime.datetime(2021, 11, 11, 9, 0, 5))
        tdSql.checkData(5, 1, 6)
        tdSql.checkData(5, 2, "tba1")
        tdSql.checkData(6, 0, datetime.datetime(2021, 11, 11, 9, 0, 6))
        tdSql.checkData(6, 1, 7)
        tdSql.checkData(6, 2, "tba1")
        tdSql.checkData(7, 0, datetime.datetime(2021, 11, 11, 9, 0, 7))
        tdSql.checkData(7, 1, 8)
        tdSql.checkData(7, 2, "tba1")
        tdSql.checkData(8, 0, datetime.datetime(2021, 11, 11, 9, 0, 8))
        tdSql.checkData(8, 1, 9)
        tdSql.checkData(8, 2, "tba1")
        tdSql.checkData(9, 0, datetime.datetime(2021, 11, 11, 9, 0, 9))
        tdSql.checkData(9, 1, 0)
        tdSql.checkData(9, 2, "tba1")
        tdSql.checkData(10, 0, datetime.datetime(2021, 11, 11, 9, 0, 10))
        tdSql.checkData(10, 1, 1)
        tdSql.checkData(10, 2, "tba1")
        tdSql.checkData(11, 0, datetime.datetime(2021, 11, 11, 9, 0, 11))
        tdSql.checkData(11, 1, 2)
        tdSql.checkData(11, 2, "tba1")
        tdSql.checkData(12, 0, datetime.datetime(2021, 11, 11, 9, 0, 12))
        tdSql.checkData(12, 1, 3)
        tdSql.checkData(12, 2, "tba1")
        tdSql.checkData(13, 0, datetime.datetime(2021, 11, 11, 9, 0, 13))
        tdSql.checkData(13, 1, 4)
        tdSql.checkData(13, 2, "tba1")
        tdSql.checkData(14, 0, datetime.datetime(2021, 11, 11, 9, 0, 14))
        tdSql.checkData(14, 1, 5)
        tdSql.checkData(14, 2, "tba1")
        tdSql.checkData(15, 0, datetime.datetime(2021, 11, 11, 9, 0, 15))
        tdSql.checkData(15, 1, 6)
        tdSql.checkData(15, 2, "tba1")
        tdSql.checkData(16, 0, datetime.datetime(2021, 11, 11, 9, 0, 16))
        tdSql.checkData(16, 1, 7)
        tdSql.checkData(16, 2, "tba1")
        tdSql.checkData(17, 0, datetime.datetime(2021, 11, 11, 9, 0, 17))
        tdSql.checkData(17, 1, 8)
        tdSql.checkData(17, 2, "tba1")
        tdSql.checkData(18, 0, datetime.datetime(2021, 11, 11, 9, 0, 18))
        tdSql.checkData(18, 1, 9)
        tdSql.checkData(18, 2, "tba1")
        tdSql.checkData(19, 0, datetime.datetime(2021, 11, 11, 9, 0, 19))
        tdSql.checkData(19, 1, 0)
        tdSql.checkData(19, 2, "tba1")
        tdSql.checkData(20, 0, datetime.datetime(2021, 11, 11, 9, 0, 20))
        tdSql.checkData(20, 1, 1)
        tdSql.checkData(20, 2, "tba1")
        tdSql.checkData(21, 0, datetime.datetime(2021, 11, 11, 9, 0, 21))
        tdSql.checkData(21, 1, 2)
        tdSql.checkData(21, 2, "tba1")
        tdSql.checkData(22, 0, datetime.datetime(2021, 11, 11, 9, 0, 22))
        tdSql.checkData(22, 1, 3)
        tdSql.checkData(22, 2, "tba1")
        tdSql.checkData(23, 0, datetime.datetime(2021, 11, 11, 9, 0, 23))
        tdSql.checkData(23, 1, 4)
        tdSql.checkData(23, 2, "tba1")
        tdSql.checkData(24, 0, datetime.datetime(2021, 11, 11, 9, 0, 24))
        tdSql.checkData(24, 1, 5)
        tdSql.checkData(24, 2, "tba1")
        tdSql.checkData(25, 0, datetime.datetime(2021, 11, 11, 9, 0, 25))
        tdSql.checkData(25, 1, 6)
        tdSql.checkData(25, 2, "tba1")
        tdSql.checkData(26, 0, datetime.datetime(2021, 11, 11, 9, 0, 26))
        tdSql.checkData(26, 1, 7)
        tdSql.checkData(26, 2, "tba1")
        tdSql.checkData(27, 0, datetime.datetime(2021, 11, 11, 9, 0, 27))
        tdSql.checkData(27, 1, 8)
        tdSql.checkData(27, 2, "tba1")
        tdSql.checkData(28, 0, datetime.datetime(2021, 11, 11, 9, 0, 28))
        tdSql.checkData(28, 1, 9)
        tdSql.checkData(28, 2, "tba1")
        tdSql.checkData(29, 0, datetime.datetime(2021, 11, 11, 9, 0, 29))
        tdSql.checkData(29, 1, 0)
        tdSql.checkData(29, 2, "tba1")

        tdSql.query("select abs(elapsed(ts)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 29000.0)

        tdSql.query("select abs(rate(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.896551724137931)

        tdSql.query("select abs(irate(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        tdSql.query("select abs(first(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1)

        tdSql.query("select abs(last(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        tdSql.query("select abs(last_row(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)

        # ===========  end   math_abs2  ==========

        # ===========  begin math_asin  ==========
        tdSql.query("select asin(13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c2) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c4) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c5) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c7) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c10) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select asin(c11) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select asin(c12) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select asin(c13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select asin(a) from (select asin(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c2 + c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin((c2 + c3)) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin((c2 * c3)+c4-6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(11)+c2 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c2)+11 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 12.570796326794897)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query(
            "select asin(c2+c3) from tb1 where c2 is not null and c3 is not null;"
        )
        tdSql.checkRows(4)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)

        tdSql.query("select asin(c2) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 1.5707963267948966)

        tdSql.query("select asin(c2+c3) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, None)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c2+c3) from tb1 order by ts desc limit 3 offset 2;")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)

        tdSql.query("select asin(c2) from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 1.5707963267948966)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)

        tdSql.query("select asin(c2) from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select asin(c4),t1 from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select asin(c3),tbname from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(0, 1, "tb1")
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, "tb1")
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, "tb1")
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(3, 1, "tb1")
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(4, 1, "tb1")
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(5, 1, "tb1")
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, "tb1")
        tdSql.checkData(7, 0, 1.5707963267948966)
        tdSql.checkData(7, 1, "tb2")
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(8, 1, "tb2")
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(9, 1, "tb2")
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(10, 1, "tb2")
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(11, 1, "tb2")
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(12, 1, "tb2")
        tdSql.checkData(13, 0, nan)
        tdSql.checkData(13, 1, "tb2")

        tdSql.query("select asin(c3),tbname from stb1 where t1 > 1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(0, 1, "tb2")
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(1, 1, "tb2")
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(2, 1, "tb2")
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(3, 1, "tb2")
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(4, 1, "tb2")
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(5, 1, "tb2")
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, "tb2")

        tdSql.query("select asin(a) from (select avg(c2) as a from stb1 interval(1s));")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select asin(c2) from (select * from stb1);")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 1.5707963267948966)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)

        tdSql.query(
            "select asin(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null));"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select asin(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select asin(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, 1.5707963267948966)

        tdSql.query(
            "select asin(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, 1.5707963267948966)
        tdSql.checkData(9, 0, nan)

        tdSql.query(
            "select asin(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, 1.5707963267948966)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query("select asin(a) from (select asin(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query(
            "select asin(tb1.c3),asin(tb2.c3) from tb1,tb2 where tb1.ts=tb2.ts;"
        )
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(0, 1, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, nan)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(3, 1, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(4, 1, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(5, 1, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, nan)

        tdSql.query("select asin(c3) from tb1 union all select asin(c3) from tb2;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 1.5707963267948966)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)

        # ===========  end   math_asin  ==========

        # ===========  begin math_asin2  ==========
        tdSql.query(
            "select asin(stb1.c4),asin(stba.c5) from stb1,stba where stb1.t1=stba.t1 and stb1.ts=stba.ts;"
        )
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(0, 1, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(2, 1, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(3, 1, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(4, 1, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(5, 1, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, nan)

        tdSql.query(
            "select asin(c4) as a from stb1 union all select asin(c5) as a from stba;"
        )
        tdSql.checkRows(44)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 1.5707963267948966)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)
        tdSql.checkData(14, 0, 1.5707963267948966)
        tdSql.checkData(15, 0, nan)
        tdSql.checkData(16, 0, nan)
        tdSql.checkData(17, 0, nan)
        tdSql.checkData(18, 0, nan)
        tdSql.checkData(19, 0, nan)
        tdSql.checkData(20, 0, nan)
        tdSql.checkData(21, 0, nan)
        tdSql.checkData(22, 0, nan)
        tdSql.checkData(23, 0, 0.0)
        tdSql.checkData(24, 0, 1.5707963267948966)
        tdSql.checkData(25, 0, nan)
        tdSql.checkData(26, 0, nan)
        tdSql.checkData(27, 0, nan)
        tdSql.checkData(28, 0, nan)
        tdSql.checkData(29, 0, nan)
        tdSql.checkData(30, 0, nan)
        tdSql.checkData(31, 0, nan)
        tdSql.checkData(32, 0, nan)
        tdSql.checkData(33, 0, 0.0)
        tdSql.checkData(34, 0, 1.5707963267948966)
        tdSql.checkData(35, 0, nan)
        tdSql.checkData(36, 0, nan)
        tdSql.checkData(37, 0, nan)
        tdSql.checkData(38, 0, nan)
        tdSql.checkData(39, 0, nan)
        tdSql.checkData(40, 0, nan)
        tdSql.checkData(41, 0, nan)
        tdSql.checkData(42, 0, nan)
        tdSql.checkData(43, 0, 0.0)

        tdSql.query("select asin(c2) from stba;")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, 0.0)
        tdSql.checkData(10, 0, 1.5707963267948966)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)
        tdSql.checkData(14, 0, nan)
        tdSql.checkData(15, 0, nan)
        tdSql.checkData(16, 0, nan)
        tdSql.checkData(17, 0, nan)
        tdSql.checkData(18, 0, nan)
        tdSql.checkData(19, 0, 0.0)
        tdSql.checkData(20, 0, 1.5707963267948966)
        tdSql.checkData(21, 0, nan)
        tdSql.checkData(22, 0, nan)
        tdSql.checkData(23, 0, nan)
        tdSql.checkData(24, 0, nan)
        tdSql.checkData(25, 0, nan)
        tdSql.checkData(26, 0, nan)
        tdSql.checkData(27, 0, nan)
        tdSql.checkData(28, 0, nan)
        tdSql.checkData(29, 0, 0.0)

        tdSql.query("select asin(min(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        tdSql.query("select asin(max(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select asin(count(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select asin(sum(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select asin(avg(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select asin(percentile(c2, 10)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.119769514998634)

        tdSql.query("select asin(apercentile(c2, 10)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        tdSql.query("select asin(stddev(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select asin(spread(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select asin(twa(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select asin(interp(c2)) from tba1 every(1s)")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, datetime.datetime(2021, 11, 11, 9, 0))
        tdSql.checkData(0, 1, 1.5707963267948966)
        tdSql.checkData(1, 0, datetime.datetime(2021, 11, 11, 9, 0, 1))
        tdSql.checkData(1, 1, nan)
        tdSql.checkData(2, 0, datetime.datetime(2021, 11, 11, 9, 0, 2))
        tdSql.checkData(2, 1, nan)
        tdSql.checkData(3, 0, datetime.datetime(2021, 11, 11, 9, 0, 3))
        tdSql.checkData(3, 1, nan)
        tdSql.checkData(4, 0, datetime.datetime(2021, 11, 11, 9, 0, 4))
        tdSql.checkData(4, 1, nan)
        tdSql.checkData(5, 0, datetime.datetime(2021, 11, 11, 9, 0, 5))
        tdSql.checkData(5, 1, nan)
        tdSql.checkData(6, 0, datetime.datetime(2021, 11, 11, 9, 0, 6))
        tdSql.checkData(6, 1, nan)
        tdSql.checkData(7, 0, datetime.datetime(2021, 11, 11, 9, 0, 7))
        tdSql.checkData(7, 1, nan)
        tdSql.checkData(8, 0, datetime.datetime(2021, 11, 11, 9, 0, 8))
        tdSql.checkData(8, 1, nan)
        tdSql.checkData(9, 0, datetime.datetime(2021, 11, 11, 9, 0, 9))
        tdSql.checkData(9, 1, 0.0)
        tdSql.checkData(10, 0, datetime.datetime(2021, 11, 11, 9, 0, 10))
        tdSql.checkData(10, 1, 1.5707963267948966)
        tdSql.checkData(11, 0, datetime.datetime(2021, 11, 11, 9, 0, 11))
        tdSql.checkData(11, 1, nan)
        tdSql.checkData(12, 0, datetime.datetime(2021, 11, 11, 9, 0, 12))
        tdSql.checkData(12, 1, nan)
        tdSql.checkData(13, 0, datetime.datetime(2021, 11, 11, 9, 0, 13))
        tdSql.checkData(13, 1, nan)
        tdSql.checkData(14, 0, datetime.datetime(2021, 11, 11, 9, 0, 14))
        tdSql.checkData(14, 1, nan)
        tdSql.checkData(15, 0, datetime.datetime(2021, 11, 11, 9, 0, 15))
        tdSql.checkData(15, 1, nan)
        tdSql.checkData(16, 0, datetime.datetime(2021, 11, 11, 9, 0, 16))
        tdSql.checkData(16, 1, nan)
        tdSql.checkData(17, 0, datetime.datetime(2021, 11, 11, 9, 0, 17))
        tdSql.checkData(17, 1, nan)
        tdSql.checkData(18, 0, datetime.datetime(2021, 11, 11, 9, 0, 18))
        tdSql.checkData(18, 1, nan)
        tdSql.checkData(19, 0, datetime.datetime(2021, 11, 11, 9, 0, 19))
        tdSql.checkData(19, 1, 0.0)
        tdSql.checkData(20, 0, datetime.datetime(2021, 11, 11, 9, 0, 20))
        tdSql.checkData(20, 1, 1.5707963267948966)
        tdSql.checkData(21, 0, datetime.datetime(2021, 11, 11, 9, 0, 21))
        tdSql.checkData(21, 1, nan)
        tdSql.checkData(22, 0, datetime.datetime(2021, 11, 11, 9, 0, 22))
        tdSql.checkData(22, 1, nan)
        tdSql.checkData(23, 0, datetime.datetime(2021, 11, 11, 9, 0, 23))
        tdSql.checkData(23, 1, nan)
        tdSql.checkData(24, 0, datetime.datetime(2021, 11, 11, 9, 0, 24))
        tdSql.checkData(24, 1, nan)
        tdSql.checkData(25, 0, datetime.datetime(2021, 11, 11, 9, 0, 25))
        tdSql.checkData(25, 1, nan)
        tdSql.checkData(26, 0, datetime.datetime(2021, 11, 11, 9, 0, 26))
        tdSql.checkData(26, 1, nan)
        tdSql.checkData(27, 0, datetime.datetime(2021, 11, 11, 9, 0, 27))
        tdSql.checkData(27, 1, nan)
        tdSql.checkData(28, 0, datetime.datetime(2021, 11, 11, 9, 0, 28))
        tdSql.checkData(28, 1, nan)
        tdSql.checkData(29, 0, datetime.datetime(2021, 11, 11, 9, 0, 29))
        tdSql.checkData(29, 1, 0.0)

        tdSql.query("select asin(interp(c2)) from stba every(1s) group by tbname;")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, datetime.datetime(2021, 11, 11, 9, 0))
        tdSql.checkData(0, 1, 1.5707963267948966)
        tdSql.checkData(0, 2, "tba1")
        tdSql.checkData(1, 0, datetime.datetime(2021, 11, 11, 9, 0, 1))
        tdSql.checkData(1, 1, nan)
        tdSql.checkData(1, 2, "tba1")
        tdSql.checkData(2, 0, datetime.datetime(2021, 11, 11, 9, 0, 2))
        tdSql.checkData(2, 1, nan)
        tdSql.checkData(2, 2, "tba1")
        tdSql.checkData(3, 0, datetime.datetime(2021, 11, 11, 9, 0, 3))
        tdSql.checkData(3, 1, nan)
        tdSql.checkData(3, 2, "tba1")
        tdSql.checkData(4, 0, datetime.datetime(2021, 11, 11, 9, 0, 4))
        tdSql.checkData(4, 1, nan)
        tdSql.checkData(4, 2, "tba1")
        tdSql.checkData(5, 0, datetime.datetime(2021, 11, 11, 9, 0, 5))
        tdSql.checkData(5, 1, nan)
        tdSql.checkData(5, 2, "tba1")
        tdSql.checkData(6, 0, datetime.datetime(2021, 11, 11, 9, 0, 6))
        tdSql.checkData(6, 1, nan)
        tdSql.checkData(6, 2, "tba1")
        tdSql.checkData(7, 0, datetime.datetime(2021, 11, 11, 9, 0, 7))
        tdSql.checkData(7, 1, nan)
        tdSql.checkData(7, 2, "tba1")
        tdSql.checkData(8, 0, datetime.datetime(2021, 11, 11, 9, 0, 8))
        tdSql.checkData(8, 1, nan)
        tdSql.checkData(8, 2, "tba1")
        tdSql.checkData(9, 0, datetime.datetime(2021, 11, 11, 9, 0, 9))
        tdSql.checkData(9, 1, 0.0)
        tdSql.checkData(9, 2, "tba1")
        tdSql.checkData(10, 0, datetime.datetime(2021, 11, 11, 9, 0, 10))
        tdSql.checkData(10, 1, 1.5707963267948966)
        tdSql.checkData(10, 2, "tba1")
        tdSql.checkData(11, 0, datetime.datetime(2021, 11, 11, 9, 0, 11))
        tdSql.checkData(11, 1, nan)
        tdSql.checkData(11, 2, "tba1")
        tdSql.checkData(12, 0, datetime.datetime(2021, 11, 11, 9, 0, 12))
        tdSql.checkData(12, 1, nan)
        tdSql.checkData(12, 2, "tba1")
        tdSql.checkData(13, 0, datetime.datetime(2021, 11, 11, 9, 0, 13))
        tdSql.checkData(13, 1, nan)
        tdSql.checkData(13, 2, "tba1")
        tdSql.checkData(14, 0, datetime.datetime(2021, 11, 11, 9, 0, 14))
        tdSql.checkData(14, 1, nan)
        tdSql.checkData(14, 2, "tba1")
        tdSql.checkData(15, 0, datetime.datetime(2021, 11, 11, 9, 0, 15))
        tdSql.checkData(15, 1, nan)
        tdSql.checkData(15, 2, "tba1")
        tdSql.checkData(16, 0, datetime.datetime(2021, 11, 11, 9, 0, 16))
        tdSql.checkData(16, 1, nan)
        tdSql.checkData(16, 2, "tba1")
        tdSql.checkData(17, 0, datetime.datetime(2021, 11, 11, 9, 0, 17))
        tdSql.checkData(17, 1, nan)
        tdSql.checkData(17, 2, "tba1")
        tdSql.checkData(18, 0, datetime.datetime(2021, 11, 11, 9, 0, 18))
        tdSql.checkData(18, 1, nan)
        tdSql.checkData(18, 2, "tba1")
        tdSql.checkData(19, 0, datetime.datetime(2021, 11, 11, 9, 0, 19))
        tdSql.checkData(19, 1, 0.0)
        tdSql.checkData(19, 2, "tba1")
        tdSql.checkData(20, 0, datetime.datetime(2021, 11, 11, 9, 0, 20))
        tdSql.checkData(20, 1, 1.5707963267948966)
        tdSql.checkData(20, 2, "tba1")
        tdSql.checkData(21, 0, datetime.datetime(2021, 11, 11, 9, 0, 21))
        tdSql.checkData(21, 1, nan)
        tdSql.checkData(21, 2, "tba1")
        tdSql.checkData(22, 0, datetime.datetime(2021, 11, 11, 9, 0, 22))
        tdSql.checkData(22, 1, nan)
        tdSql.checkData(22, 2, "tba1")
        tdSql.checkData(23, 0, datetime.datetime(2021, 11, 11, 9, 0, 23))
        tdSql.checkData(23, 1, nan)
        tdSql.checkData(23, 2, "tba1")
        tdSql.checkData(24, 0, datetime.datetime(2021, 11, 11, 9, 0, 24))
        tdSql.checkData(24, 1, nan)
        tdSql.checkData(24, 2, "tba1")
        tdSql.checkData(25, 0, datetime.datetime(2021, 11, 11, 9, 0, 25))
        tdSql.checkData(25, 1, nan)
        tdSql.checkData(25, 2, "tba1")
        tdSql.checkData(26, 0, datetime.datetime(2021, 11, 11, 9, 0, 26))
        tdSql.checkData(26, 1, nan)
        tdSql.checkData(26, 2, "tba1")
        tdSql.checkData(27, 0, datetime.datetime(2021, 11, 11, 9, 0, 27))
        tdSql.checkData(27, 1, nan)
        tdSql.checkData(27, 2, "tba1")
        tdSql.checkData(28, 0, datetime.datetime(2021, 11, 11, 9, 0, 28))
        tdSql.checkData(28, 1, nan)
        tdSql.checkData(28, 2, "tba1")
        tdSql.checkData(29, 0, datetime.datetime(2021, 11, 11, 9, 0, 29))
        tdSql.checkData(29, 1, 0.0)
        tdSql.checkData(29, 2, "tba1")

        tdSql.query("select asin(elapsed(ts)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select asin(rate(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.1119221217807869)

        tdSql.query("select asin(irate(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        tdSql.query("select asin(first(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.5707963267948966)

        tdSql.query("select asin(last(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        tdSql.query("select asin(last_row(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        # ===========  end   math_asin2  ==========

        # ===========  begin math_acos  ==========
        tdSql.query("select acos(13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c2) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c4) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c5) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c7) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c10) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 1.5707963267948966)

        tdSql.query("select acos(c11) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 1.5707963267948966)

        tdSql.query("select acos(c12) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 1.5707963267948966)

        tdSql.query("select acos(c13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 1.5707963267948966)

        tdSql.query("select acos(a) from (select acos(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c2 + c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos((c2 + c3)) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos((c2 * c3)+c4-6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(11)+c2 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c2)+11 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 11.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query(
            "select acos(c2+c3) from tb1 where c2 is not null and c3 is not null;"
        )
        tdSql.checkRows(4)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)

        tdSql.query("select acos(c2) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select acos(c2+c3) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, None)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c2+c3) from tb1 order by ts desc limit 3 offset 2;")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)

        tdSql.query("select acos(c2) from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 0.0)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)

        tdSql.query("select acos(c2) from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select acos(c4),t1 from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select acos(c3),tbname from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(0, 1, "tb1")
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, "tb1")
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, "tb1")
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(3, 1, "tb1")
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(4, 1, "tb1")
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(5, 1, "tb1")
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, "tb1")
        tdSql.checkData(7, 0, 0.0)
        tdSql.checkData(7, 1, "tb2")
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(8, 1, "tb2")
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(9, 1, "tb2")
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(10, 1, "tb2")
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(11, 1, "tb2")
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(12, 1, "tb2")
        tdSql.checkData(13, 0, nan)
        tdSql.checkData(13, 1, "tb2")

        tdSql.query("select acos(c3),tbname from stb1 where t1 > 1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(0, 1, "tb2")
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(1, 1, "tb2")
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(2, 1, "tb2")
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(3, 1, "tb2")
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(4, 1, "tb2")
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(5, 1, "tb2")
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, "tb2")

        tdSql.query("select acos(a) from (select avg(c2) as a from stb1 interval(1s));")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c2) from (select * from stb1);")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 0.0)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)

        tdSql.query(
            "select acos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null));"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select acos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select acos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, 0.0)

        tdSql.query(
            "select acos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, 0.0)
        tdSql.checkData(9, 0, nan)

        tdSql.query(
            "select acos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, 0.0)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query("select acos(a) from (select acos(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query(
            "select acos(tb1.c3),acos(tb2.c3) from tb1,tb2 where tb1.ts=tb2.ts;"
        )
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(0, 1, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, nan)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(3, 1, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(4, 1, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(5, 1, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, nan)

        tdSql.query("select acos(c3) from tb1 union all select acos(c3) from tb2;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 0.0)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)

        # ===========  end   math_acos  ==========

        # ===========  begin math_acos2  ==========
        tdSql.query(
            "select acos(stb1.c4),acos(stba.c5) from stb1,stba where stb1.t1=stba.t1 and stb1.ts=stba.ts;"
        )
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(0, 1, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(2, 1, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(3, 1, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(4, 1, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(5, 1, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, nan)

        tdSql.query(
            "select acos(c4) as a from stb1 union all select acos(c5) as a from stba;"
        )
        tdSql.checkRows(44)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 0.0)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)
        tdSql.checkData(14, 0, 0.0)
        tdSql.checkData(15, 0, nan)
        tdSql.checkData(16, 0, nan)
        tdSql.checkData(17, 0, nan)
        tdSql.checkData(18, 0, nan)
        tdSql.checkData(19, 0, nan)
        tdSql.checkData(20, 0, nan)
        tdSql.checkData(21, 0, nan)
        tdSql.checkData(22, 0, nan)
        tdSql.checkData(23, 0, 1.5707963267948966)
        tdSql.checkData(24, 0, 0.0)
        tdSql.checkData(25, 0, nan)
        tdSql.checkData(26, 0, nan)
        tdSql.checkData(27, 0, nan)
        tdSql.checkData(28, 0, nan)
        tdSql.checkData(29, 0, nan)
        tdSql.checkData(30, 0, nan)
        tdSql.checkData(31, 0, nan)
        tdSql.checkData(32, 0, nan)
        tdSql.checkData(33, 0, 1.5707963267948966)
        tdSql.checkData(34, 0, 0.0)
        tdSql.checkData(35, 0, nan)
        tdSql.checkData(36, 0, nan)
        tdSql.checkData(37, 0, nan)
        tdSql.checkData(38, 0, nan)
        tdSql.checkData(39, 0, nan)
        tdSql.checkData(40, 0, nan)
        tdSql.checkData(41, 0, nan)
        tdSql.checkData(42, 0, nan)
        tdSql.checkData(43, 0, 1.5707963267948966)

        tdSql.query("select acos(c2) from stba;")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, 1.5707963267948966)
        tdSql.checkData(10, 0, 0.0)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)
        tdSql.checkData(14, 0, nan)
        tdSql.checkData(15, 0, nan)
        tdSql.checkData(16, 0, nan)
        tdSql.checkData(17, 0, nan)
        tdSql.checkData(18, 0, nan)
        tdSql.checkData(19, 0, 1.5707963267948966)
        tdSql.checkData(20, 0, 0.0)
        tdSql.checkData(21, 0, nan)
        tdSql.checkData(22, 0, nan)
        tdSql.checkData(23, 0, nan)
        tdSql.checkData(24, 0, nan)
        tdSql.checkData(25, 0, nan)
        tdSql.checkData(26, 0, nan)
        tdSql.checkData(27, 0, nan)
        tdSql.checkData(28, 0, nan)
        tdSql.checkData(29, 0, 1.5707963267948966)

        tdSql.query("select acos(min(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.5707963267948966)

        tdSql.query("select acos(max(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select acos(count(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select acos(sum(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select acos(avg(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select acos(percentile(c2, 10)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.45102681179626264)

        tdSql.query("select acos(apercentile(c2, 10)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.5707963267948966)

        tdSql.query("select acos(stddev(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select acos(spread(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select acos(twa(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select acos(interp(c2)) from tba1 every(1s)")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, datetime.datetime(2021, 11, 11, 9, 0))
        tdSql.checkData(0, 1, 0.0)
        tdSql.checkData(1, 0, datetime.datetime(2021, 11, 11, 9, 0, 1))
        tdSql.checkData(1, 1, nan)
        tdSql.checkData(2, 0, datetime.datetime(2021, 11, 11, 9, 0, 2))
        tdSql.checkData(2, 1, nan)
        tdSql.checkData(3, 0, datetime.datetime(2021, 11, 11, 9, 0, 3))
        tdSql.checkData(3, 1, nan)
        tdSql.checkData(4, 0, datetime.datetime(2021, 11, 11, 9, 0, 4))
        tdSql.checkData(4, 1, nan)
        tdSql.checkData(5, 0, datetime.datetime(2021, 11, 11, 9, 0, 5))
        tdSql.checkData(5, 1, nan)
        tdSql.checkData(6, 0, datetime.datetime(2021, 11, 11, 9, 0, 6))
        tdSql.checkData(6, 1, nan)
        tdSql.checkData(7, 0, datetime.datetime(2021, 11, 11, 9, 0, 7))
        tdSql.checkData(7, 1, nan)
        tdSql.checkData(8, 0, datetime.datetime(2021, 11, 11, 9, 0, 8))
        tdSql.checkData(8, 1, nan)
        tdSql.checkData(9, 0, datetime.datetime(2021, 11, 11, 9, 0, 9))
        tdSql.checkData(9, 1, 1.5707963267948966)
        tdSql.checkData(10, 0, datetime.datetime(2021, 11, 11, 9, 0, 10))
        tdSql.checkData(10, 1, 0.0)
        tdSql.checkData(11, 0, datetime.datetime(2021, 11, 11, 9, 0, 11))
        tdSql.checkData(11, 1, nan)
        tdSql.checkData(12, 0, datetime.datetime(2021, 11, 11, 9, 0, 12))
        tdSql.checkData(12, 1, nan)
        tdSql.checkData(13, 0, datetime.datetime(2021, 11, 11, 9, 0, 13))
        tdSql.checkData(13, 1, nan)
        tdSql.checkData(14, 0, datetime.datetime(2021, 11, 11, 9, 0, 14))
        tdSql.checkData(14, 1, nan)
        tdSql.checkData(15, 0, datetime.datetime(2021, 11, 11, 9, 0, 15))
        tdSql.checkData(15, 1, nan)
        tdSql.checkData(16, 0, datetime.datetime(2021, 11, 11, 9, 0, 16))
        tdSql.checkData(16, 1, nan)
        tdSql.checkData(17, 0, datetime.datetime(2021, 11, 11, 9, 0, 17))
        tdSql.checkData(17, 1, nan)
        tdSql.checkData(18, 0, datetime.datetime(2021, 11, 11, 9, 0, 18))
        tdSql.checkData(18, 1, nan)
        tdSql.checkData(19, 0, datetime.datetime(2021, 11, 11, 9, 0, 19))
        tdSql.checkData(19, 1, 1.5707963267948966)
        tdSql.checkData(20, 0, datetime.datetime(2021, 11, 11, 9, 0, 20))
        tdSql.checkData(20, 1, 0.0)
        tdSql.checkData(21, 0, datetime.datetime(2021, 11, 11, 9, 0, 21))
        tdSql.checkData(21, 1, nan)
        tdSql.checkData(22, 0, datetime.datetime(2021, 11, 11, 9, 0, 22))
        tdSql.checkData(22, 1, nan)
        tdSql.checkData(23, 0, datetime.datetime(2021, 11, 11, 9, 0, 23))
        tdSql.checkData(23, 1, nan)
        tdSql.checkData(24, 0, datetime.datetime(2021, 11, 11, 9, 0, 24))
        tdSql.checkData(24, 1, nan)
        tdSql.checkData(25, 0, datetime.datetime(2021, 11, 11, 9, 0, 25))
        tdSql.checkData(25, 1, nan)
        tdSql.checkData(26, 0, datetime.datetime(2021, 11, 11, 9, 0, 26))
        tdSql.checkData(26, 1, nan)
        tdSql.checkData(27, 0, datetime.datetime(2021, 11, 11, 9, 0, 27))
        tdSql.checkData(27, 1, nan)
        tdSql.checkData(28, 0, datetime.datetime(2021, 11, 11, 9, 0, 28))
        tdSql.checkData(28, 1, nan)
        tdSql.checkData(29, 0, datetime.datetime(2021, 11, 11, 9, 0, 29))
        tdSql.checkData(29, 1, 1.5707963267948966)

        tdSql.query("select acos(interp(c2)) from stba every(1s) group by tbname;")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, datetime.datetime(2021, 11, 11, 9, 0))
        tdSql.checkData(0, 1, 0.0)
        tdSql.checkData(0, 2, "tba1")
        tdSql.checkData(1, 0, datetime.datetime(2021, 11, 11, 9, 0, 1))
        tdSql.checkData(1, 1, nan)
        tdSql.checkData(1, 2, "tba1")
        tdSql.checkData(2, 0, datetime.datetime(2021, 11, 11, 9, 0, 2))
        tdSql.checkData(2, 1, nan)
        tdSql.checkData(2, 2, "tba1")
        tdSql.checkData(3, 0, datetime.datetime(2021, 11, 11, 9, 0, 3))
        tdSql.checkData(3, 1, nan)
        tdSql.checkData(3, 2, "tba1")
        tdSql.checkData(4, 0, datetime.datetime(2021, 11, 11, 9, 0, 4))
        tdSql.checkData(4, 1, nan)
        tdSql.checkData(4, 2, "tba1")
        tdSql.checkData(5, 0, datetime.datetime(2021, 11, 11, 9, 0, 5))
        tdSql.checkData(5, 1, nan)
        tdSql.checkData(5, 2, "tba1")
        tdSql.checkData(6, 0, datetime.datetime(2021, 11, 11, 9, 0, 6))
        tdSql.checkData(6, 1, nan)
        tdSql.checkData(6, 2, "tba1")
        tdSql.checkData(7, 0, datetime.datetime(2021, 11, 11, 9, 0, 7))
        tdSql.checkData(7, 1, nan)
        tdSql.checkData(7, 2, "tba1")
        tdSql.checkData(8, 0, datetime.datetime(2021, 11, 11, 9, 0, 8))
        tdSql.checkData(8, 1, nan)
        tdSql.checkData(8, 2, "tba1")
        tdSql.checkData(9, 0, datetime.datetime(2021, 11, 11, 9, 0, 9))
        tdSql.checkData(9, 1, 1.5707963267948966)
        tdSql.checkData(9, 2, "tba1")
        tdSql.checkData(10, 0, datetime.datetime(2021, 11, 11, 9, 0, 10))
        tdSql.checkData(10, 1, 0.0)
        tdSql.checkData(10, 2, "tba1")
        tdSql.checkData(11, 0, datetime.datetime(2021, 11, 11, 9, 0, 11))
        tdSql.checkData(11, 1, nan)
        tdSql.checkData(11, 2, "tba1")
        tdSql.checkData(12, 0, datetime.datetime(2021, 11, 11, 9, 0, 12))
        tdSql.checkData(12, 1, nan)
        tdSql.checkData(12, 2, "tba1")
        tdSql.checkData(13, 0, datetime.datetime(2021, 11, 11, 9, 0, 13))
        tdSql.checkData(13, 1, nan)
        tdSql.checkData(13, 2, "tba1")
        tdSql.checkData(14, 0, datetime.datetime(2021, 11, 11, 9, 0, 14))
        tdSql.checkData(14, 1, nan)
        tdSql.checkData(14, 2, "tba1")
        tdSql.checkData(15, 0, datetime.datetime(2021, 11, 11, 9, 0, 15))
        tdSql.checkData(15, 1, nan)
        tdSql.checkData(15, 2, "tba1")
        tdSql.checkData(16, 0, datetime.datetime(2021, 11, 11, 9, 0, 16))
        tdSql.checkData(16, 1, nan)
        tdSql.checkData(16, 2, "tba1")
        tdSql.checkData(17, 0, datetime.datetime(2021, 11, 11, 9, 0, 17))
        tdSql.checkData(17, 1, nan)
        tdSql.checkData(17, 2, "tba1")
        tdSql.checkData(18, 0, datetime.datetime(2021, 11, 11, 9, 0, 18))
        tdSql.checkData(18, 1, nan)
        tdSql.checkData(18, 2, "tba1")
        tdSql.checkData(19, 0, datetime.datetime(2021, 11, 11, 9, 0, 19))
        tdSql.checkData(19, 1, 1.5707963267948966)
        tdSql.checkData(19, 2, "tba1")
        tdSql.checkData(20, 0, datetime.datetime(2021, 11, 11, 9, 0, 20))
        tdSql.checkData(20, 1, 0.0)
        tdSql.checkData(20, 2, "tba1")
        tdSql.checkData(21, 0, datetime.datetime(2021, 11, 11, 9, 0, 21))
        tdSql.checkData(21, 1, nan)
        tdSql.checkData(21, 2, "tba1")
        tdSql.checkData(22, 0, datetime.datetime(2021, 11, 11, 9, 0, 22))
        tdSql.checkData(22, 1, nan)
        tdSql.checkData(22, 2, "tba1")
        tdSql.checkData(23, 0, datetime.datetime(2021, 11, 11, 9, 0, 23))
        tdSql.checkData(23, 1, nan)
        tdSql.checkData(23, 2, "tba1")
        tdSql.checkData(24, 0, datetime.datetime(2021, 11, 11, 9, 0, 24))
        tdSql.checkData(24, 1, nan)
        tdSql.checkData(24, 2, "tba1")
        tdSql.checkData(25, 0, datetime.datetime(2021, 11, 11, 9, 0, 25))
        tdSql.checkData(25, 1, nan)
        tdSql.checkData(25, 2, "tba1")
        tdSql.checkData(26, 0, datetime.datetime(2021, 11, 11, 9, 0, 26))
        tdSql.checkData(26, 1, nan)
        tdSql.checkData(26, 2, "tba1")
        tdSql.checkData(27, 0, datetime.datetime(2021, 11, 11, 9, 0, 27))
        tdSql.checkData(27, 1, nan)
        tdSql.checkData(27, 2, "tba1")
        tdSql.checkData(28, 0, datetime.datetime(2021, 11, 11, 9, 0, 28))
        tdSql.checkData(28, 1, nan)
        tdSql.checkData(28, 2, "tba1")
        tdSql.checkData(29, 0, datetime.datetime(2021, 11, 11, 9, 0, 29))
        tdSql.checkData(29, 1, 1.5707963267948966)
        tdSql.checkData(29, 2, "tba1")

        tdSql.query("select acos(elapsed(ts)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select acos(rate(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.4588742050141097)

        tdSql.query("select acos(irate(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.5707963267948966)

        tdSql.query("select acos(first(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        tdSql.query("select acos(last(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.5707963267948966)

        tdSql.query("select acos(last_row(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.5707963267948966)

        # ===========  end   math_acos2  ==========

        # ===========  begin math_atan  ==========
        tdSql.query("select acos(13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c2) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c4) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c5) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c7) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c10) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 1.5707963267948966)

        tdSql.query("select acos(c11) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 1.5707963267948966)

        tdSql.query("select acos(c12) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 1.5707963267948966)

        tdSql.query("select acos(c13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, 1.5707963267948966)

        tdSql.query("select acos(a) from (select acos(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c2 + c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos((c2 + c3)) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos((c2 * c3)+c4-6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(11)+c2 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c2)+11 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 11.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query(
            "select acos(c2+c3) from tb1 where c2 is not null and c3 is not null;"
        )
        tdSql.checkRows(4)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)

        tdSql.query("select acos(c2) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select acos(c2+c3) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, None)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c2+c3) from tb1 order by ts desc limit 3 offset 2;")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)

        tdSql.query("select acos(c2) from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 0.0)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)

        tdSql.query("select acos(c2) from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select acos(c4),t1 from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select acos(c3),tbname from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(0, 1, "tb1")
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, "tb1")
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, "tb1")
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(3, 1, "tb1")
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(4, 1, "tb1")
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(5, 1, "tb1")
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, "tb1")
        tdSql.checkData(7, 0, 0.0)
        tdSql.checkData(7, 1, "tb2")
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(8, 1, "tb2")
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(9, 1, "tb2")
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(10, 1, "tb2")
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(11, 1, "tb2")
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(12, 1, "tb2")
        tdSql.checkData(13, 0, nan)
        tdSql.checkData(13, 1, "tb2")

        tdSql.query("select acos(c3),tbname from stb1 where t1 > 1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(0, 1, "tb2")
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(1, 1, "tb2")
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(2, 1, "tb2")
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(3, 1, "tb2")
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(4, 1, "tb2")
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(5, 1, "tb2")
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, "tb2")

        tdSql.query("select acos(a) from (select avg(c2) as a from stb1 interval(1s));")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select acos(c2) from (select * from stb1);")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 0.0)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)

        tdSql.query(
            "select acos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null));"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select acos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select acos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, 0.0)

        tdSql.query(
            "select acos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, 0.0)
        tdSql.checkData(9, 0, nan)

        tdSql.query(
            "select acos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, 0.0)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query("select acos(a) from (select acos(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5707963267948966)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)

        tdSql.query(
            "select acos(tb1.c3),acos(tb2.c3) from tb1,tb2 where tb1.ts=tb2.ts;"
        )
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(0, 1, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, nan)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(3, 1, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(4, 1, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(5, 1, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, nan)

        tdSql.query("select acos(c3) from tb1 union all select acos(c3) from tb2;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 0.0)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)

        # ===========  end   math_atan  ==========

        # ===========  begin math_atan2  ==========
        tdSql.query(
            "select acos(stb1.c4),acos(stba.c5) from stb1,stba where stb1.t1=stba.t1 and stb1.ts=stba.ts;"
        )
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(0, 1, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(2, 1, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(3, 1, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(4, 1, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(5, 1, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, nan)

        tdSql.query(
            "select acos(c4) as a from stb1 union all select acos(c5) as a from stba;"
        )
        tdSql.checkRows(44)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, 0.0)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)
        tdSql.checkData(14, 0, 0.0)
        tdSql.checkData(15, 0, nan)
        tdSql.checkData(16, 0, nan)
        tdSql.checkData(17, 0, nan)
        tdSql.checkData(18, 0, nan)
        tdSql.checkData(19, 0, nan)
        tdSql.checkData(20, 0, nan)
        tdSql.checkData(21, 0, nan)
        tdSql.checkData(22, 0, nan)
        tdSql.checkData(23, 0, 1.5707963267948966)
        tdSql.checkData(24, 0, 0.0)
        tdSql.checkData(25, 0, nan)
        tdSql.checkData(26, 0, nan)
        tdSql.checkData(27, 0, nan)
        tdSql.checkData(28, 0, nan)
        tdSql.checkData(29, 0, nan)
        tdSql.checkData(30, 0, nan)
        tdSql.checkData(31, 0, nan)
        tdSql.checkData(32, 0, nan)
        tdSql.checkData(33, 0, 1.5707963267948966)
        tdSql.checkData(34, 0, 0.0)
        tdSql.checkData(35, 0, nan)
        tdSql.checkData(36, 0, nan)
        tdSql.checkData(37, 0, nan)
        tdSql.checkData(38, 0, nan)
        tdSql.checkData(39, 0, nan)
        tdSql.checkData(40, 0, nan)
        tdSql.checkData(41, 0, nan)
        tdSql.checkData(42, 0, nan)
        tdSql.checkData(43, 0, 1.5707963267948966)

        tdSql.query("select acos(c2) from stba;")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, nan)
        tdSql.checkData(2, 0, nan)
        tdSql.checkData(3, 0, nan)
        tdSql.checkData(4, 0, nan)
        tdSql.checkData(5, 0, nan)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, nan)
        tdSql.checkData(9, 0, 1.5707963267948966)
        tdSql.checkData(10, 0, 0.0)
        tdSql.checkData(11, 0, nan)
        tdSql.checkData(12, 0, nan)
        tdSql.checkData(13, 0, nan)
        tdSql.checkData(14, 0, nan)
        tdSql.checkData(15, 0, nan)
        tdSql.checkData(16, 0, nan)
        tdSql.checkData(17, 0, nan)
        tdSql.checkData(18, 0, nan)
        tdSql.checkData(19, 0, 1.5707963267948966)
        tdSql.checkData(20, 0, 0.0)
        tdSql.checkData(21, 0, nan)
        tdSql.checkData(22, 0, nan)
        tdSql.checkData(23, 0, nan)
        tdSql.checkData(24, 0, nan)
        tdSql.checkData(25, 0, nan)
        tdSql.checkData(26, 0, nan)
        tdSql.checkData(27, 0, nan)
        tdSql.checkData(28, 0, nan)
        tdSql.checkData(29, 0, 1.5707963267948966)

        tdSql.query("select acos(min(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.5707963267948966)

        tdSql.query("select acos(max(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select acos(count(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select acos(sum(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select acos(avg(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select acos(percentile(c2, 10)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.45102681179626264)

        tdSql.query("select acos(apercentile(c2, 10)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.5707963267948966)

        tdSql.query("select acos(stddev(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select acos(spread(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select acos(twa(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select acos(interp(c2)) from tba1 every(1s)")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, datetime.datetime(2021, 11, 11, 9, 0))
        tdSql.checkData(0, 1, 0.0)
        tdSql.checkData(1, 0, datetime.datetime(2021, 11, 11, 9, 0, 1))
        tdSql.checkData(1, 1, nan)
        tdSql.checkData(2, 0, datetime.datetime(2021, 11, 11, 9, 0, 2))
        tdSql.checkData(2, 1, nan)
        tdSql.checkData(3, 0, datetime.datetime(2021, 11, 11, 9, 0, 3))
        tdSql.checkData(3, 1, nan)
        tdSql.checkData(4, 0, datetime.datetime(2021, 11, 11, 9, 0, 4))
        tdSql.checkData(4, 1, nan)
        tdSql.checkData(5, 0, datetime.datetime(2021, 11, 11, 9, 0, 5))
        tdSql.checkData(5, 1, nan)
        tdSql.checkData(6, 0, datetime.datetime(2021, 11, 11, 9, 0, 6))
        tdSql.checkData(6, 1, nan)
        tdSql.checkData(7, 0, datetime.datetime(2021, 11, 11, 9, 0, 7))
        tdSql.checkData(7, 1, nan)
        tdSql.checkData(8, 0, datetime.datetime(2021, 11, 11, 9, 0, 8))
        tdSql.checkData(8, 1, nan)
        tdSql.checkData(9, 0, datetime.datetime(2021, 11, 11, 9, 0, 9))
        tdSql.checkData(9, 1, 1.5707963267948966)
        tdSql.checkData(10, 0, datetime.datetime(2021, 11, 11, 9, 0, 10))
        tdSql.checkData(10, 1, 0.0)
        tdSql.checkData(11, 0, datetime.datetime(2021, 11, 11, 9, 0, 11))
        tdSql.checkData(11, 1, nan)
        tdSql.checkData(12, 0, datetime.datetime(2021, 11, 11, 9, 0, 12))
        tdSql.checkData(12, 1, nan)
        tdSql.checkData(13, 0, datetime.datetime(2021, 11, 11, 9, 0, 13))
        tdSql.checkData(13, 1, nan)
        tdSql.checkData(14, 0, datetime.datetime(2021, 11, 11, 9, 0, 14))
        tdSql.checkData(14, 1, nan)
        tdSql.checkData(15, 0, datetime.datetime(2021, 11, 11, 9, 0, 15))
        tdSql.checkData(15, 1, nan)
        tdSql.checkData(16, 0, datetime.datetime(2021, 11, 11, 9, 0, 16))
        tdSql.checkData(16, 1, nan)
        tdSql.checkData(17, 0, datetime.datetime(2021, 11, 11, 9, 0, 17))
        tdSql.checkData(17, 1, nan)
        tdSql.checkData(18, 0, datetime.datetime(2021, 11, 11, 9, 0, 18))
        tdSql.checkData(18, 1, nan)
        tdSql.checkData(19, 0, datetime.datetime(2021, 11, 11, 9, 0, 19))
        tdSql.checkData(19, 1, 1.5707963267948966)
        tdSql.checkData(20, 0, datetime.datetime(2021, 11, 11, 9, 0, 20))
        tdSql.checkData(20, 1, 0.0)
        tdSql.checkData(21, 0, datetime.datetime(2021, 11, 11, 9, 0, 21))
        tdSql.checkData(21, 1, nan)
        tdSql.checkData(22, 0, datetime.datetime(2021, 11, 11, 9, 0, 22))
        tdSql.checkData(22, 1, nan)
        tdSql.checkData(23, 0, datetime.datetime(2021, 11, 11, 9, 0, 23))
        tdSql.checkData(23, 1, nan)
        tdSql.checkData(24, 0, datetime.datetime(2021, 11, 11, 9, 0, 24))
        tdSql.checkData(24, 1, nan)
        tdSql.checkData(25, 0, datetime.datetime(2021, 11, 11, 9, 0, 25))
        tdSql.checkData(25, 1, nan)
        tdSql.checkData(26, 0, datetime.datetime(2021, 11, 11, 9, 0, 26))
        tdSql.checkData(26, 1, nan)
        tdSql.checkData(27, 0, datetime.datetime(2021, 11, 11, 9, 0, 27))
        tdSql.checkData(27, 1, nan)
        tdSql.checkData(28, 0, datetime.datetime(2021, 11, 11, 9, 0, 28))
        tdSql.checkData(28, 1, nan)
        tdSql.checkData(29, 0, datetime.datetime(2021, 11, 11, 9, 0, 29))
        tdSql.checkData(29, 1, 1.5707963267948966)

        tdSql.query("select acos(interp(c2)) from stba every(1s) group by tbname;")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, datetime.datetime(2021, 11, 11, 9, 0))
        tdSql.checkData(0, 1, 0.0)
        tdSql.checkData(0, 2, "tba1")
        tdSql.checkData(1, 0, datetime.datetime(2021, 11, 11, 9, 0, 1))
        tdSql.checkData(1, 1, nan)
        tdSql.checkData(1, 2, "tba1")
        tdSql.checkData(2, 0, datetime.datetime(2021, 11, 11, 9, 0, 2))
        tdSql.checkData(2, 1, nan)
        tdSql.checkData(2, 2, "tba1")
        tdSql.checkData(3, 0, datetime.datetime(2021, 11, 11, 9, 0, 3))
        tdSql.checkData(3, 1, nan)
        tdSql.checkData(3, 2, "tba1")
        tdSql.checkData(4, 0, datetime.datetime(2021, 11, 11, 9, 0, 4))
        tdSql.checkData(4, 1, nan)
        tdSql.checkData(4, 2, "tba1")
        tdSql.checkData(5, 0, datetime.datetime(2021, 11, 11, 9, 0, 5))
        tdSql.checkData(5, 1, nan)
        tdSql.checkData(5, 2, "tba1")
        tdSql.checkData(6, 0, datetime.datetime(2021, 11, 11, 9, 0, 6))
        tdSql.checkData(6, 1, nan)
        tdSql.checkData(6, 2, "tba1")
        tdSql.checkData(7, 0, datetime.datetime(2021, 11, 11, 9, 0, 7))
        tdSql.checkData(7, 1, nan)
        tdSql.checkData(7, 2, "tba1")
        tdSql.checkData(8, 0, datetime.datetime(2021, 11, 11, 9, 0, 8))
        tdSql.checkData(8, 1, nan)
        tdSql.checkData(8, 2, "tba1")
        tdSql.checkData(9, 0, datetime.datetime(2021, 11, 11, 9, 0, 9))
        tdSql.checkData(9, 1, 1.5707963267948966)
        tdSql.checkData(9, 2, "tba1")
        tdSql.checkData(10, 0, datetime.datetime(2021, 11, 11, 9, 0, 10))
        tdSql.checkData(10, 1, 0.0)
        tdSql.checkData(10, 2, "tba1")
        tdSql.checkData(11, 0, datetime.datetime(2021, 11, 11, 9, 0, 11))
        tdSql.checkData(11, 1, nan)
        tdSql.checkData(11, 2, "tba1")
        tdSql.checkData(12, 0, datetime.datetime(2021, 11, 11, 9, 0, 12))
        tdSql.checkData(12, 1, nan)
        tdSql.checkData(12, 2, "tba1")
        tdSql.checkData(13, 0, datetime.datetime(2021, 11, 11, 9, 0, 13))
        tdSql.checkData(13, 1, nan)
        tdSql.checkData(13, 2, "tba1")
        tdSql.checkData(14, 0, datetime.datetime(2021, 11, 11, 9, 0, 14))
        tdSql.checkData(14, 1, nan)
        tdSql.checkData(14, 2, "tba1")
        tdSql.checkData(15, 0, datetime.datetime(2021, 11, 11, 9, 0, 15))
        tdSql.checkData(15, 1, nan)
        tdSql.checkData(15, 2, "tba1")
        tdSql.checkData(16, 0, datetime.datetime(2021, 11, 11, 9, 0, 16))
        tdSql.checkData(16, 1, nan)
        tdSql.checkData(16, 2, "tba1")
        tdSql.checkData(17, 0, datetime.datetime(2021, 11, 11, 9, 0, 17))
        tdSql.checkData(17, 1, nan)
        tdSql.checkData(17, 2, "tba1")
        tdSql.checkData(18, 0, datetime.datetime(2021, 11, 11, 9, 0, 18))
        tdSql.checkData(18, 1, nan)
        tdSql.checkData(18, 2, "tba1")
        tdSql.checkData(19, 0, datetime.datetime(2021, 11, 11, 9, 0, 19))
        tdSql.checkData(19, 1, 1.5707963267948966)
        tdSql.checkData(19, 2, "tba1")
        tdSql.checkData(20, 0, datetime.datetime(2021, 11, 11, 9, 0, 20))
        tdSql.checkData(20, 1, 0.0)
        tdSql.checkData(20, 2, "tba1")
        tdSql.checkData(21, 0, datetime.datetime(2021, 11, 11, 9, 0, 21))
        tdSql.checkData(21, 1, nan)
        tdSql.checkData(21, 2, "tba1")
        tdSql.checkData(22, 0, datetime.datetime(2021, 11, 11, 9, 0, 22))
        tdSql.checkData(22, 1, nan)
        tdSql.checkData(22, 2, "tba1")
        tdSql.checkData(23, 0, datetime.datetime(2021, 11, 11, 9, 0, 23))
        tdSql.checkData(23, 1, nan)
        tdSql.checkData(23, 2, "tba1")
        tdSql.checkData(24, 0, datetime.datetime(2021, 11, 11, 9, 0, 24))
        tdSql.checkData(24, 1, nan)
        tdSql.checkData(24, 2, "tba1")
        tdSql.checkData(25, 0, datetime.datetime(2021, 11, 11, 9, 0, 25))
        tdSql.checkData(25, 1, nan)
        tdSql.checkData(25, 2, "tba1")
        tdSql.checkData(26, 0, datetime.datetime(2021, 11, 11, 9, 0, 26))
        tdSql.checkData(26, 1, nan)
        tdSql.checkData(26, 2, "tba1")
        tdSql.checkData(27, 0, datetime.datetime(2021, 11, 11, 9, 0, 27))
        tdSql.checkData(27, 1, nan)
        tdSql.checkData(27, 2, "tba1")
        tdSql.checkData(28, 0, datetime.datetime(2021, 11, 11, 9, 0, 28))
        tdSql.checkData(28, 1, nan)
        tdSql.checkData(28, 2, "tba1")
        tdSql.checkData(29, 0, datetime.datetime(2021, 11, 11, 9, 0, 29))
        tdSql.checkData(29, 1, 1.5707963267948966)
        tdSql.checkData(29, 2, "tba1")

        tdSql.query("select acos(elapsed(ts)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, nan)

        tdSql.query("select acos(rate(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.4588742050141097)

        tdSql.query("select acos(irate(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.5707963267948966)

        tdSql.query("select acos(first(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        tdSql.query("select acos(last(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.5707963267948966)

        tdSql.query("select acos(last_row(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.5707963267948966)

        # ===========  end   math_atan2  ==========

        # ===========  begin math_sin  ==========
        tdSql.query("select sin(13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.4201670368266409)
        tdSql.checkData(1, 0, 0.4201670368266409)
        tdSql.checkData(2, 0, 0.4201670368266409)
        tdSql.checkData(3, 0, 0.4201670368266409)
        tdSql.checkData(4, 0, 0.4201670368266409)
        tdSql.checkData(5, 0, 0.4201670368266409)
        tdSql.checkData(6, 0, 0.4201670368266409)

        tdSql.query("select sin(c2) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.9092974268256817)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.972630067242408)
        tdSql.checkData(6, 0, -0.972630067242408)

        tdSql.query("select sin(c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 0.1411200080598672)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.18750655394138943)
        tdSql.checkData(6, 0, -0.18750655394138943)

        tdSql.query("select sin(c4) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.9092974268256817)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, -0.7249165551445564)
        tdSql.checkData(6, 0, 0.7249165551445564)

        tdSql.query("select sin(c5) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 0.1411200080598672)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.9999303766734422)
        tdSql.checkData(6, 0, -0.9999303766734422)

        tdSql.query("select sin(c6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.9092974268256817)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, -0.5218765233336585)
        tdSql.checkData(6, 0, 0.5218765233336585)

        tdSql.query("select sin(c7) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 0.1411200080598672)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.8728292970885063)
        tdSql.checkData(6, 0, -0.8728292970885063)

        tdSql.query("select sin(c10) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.9092974268256817)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.45199889806298343)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select sin(c11) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 0.1411200080598672)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.3683616323063538)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select sin(c12) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.9092974268256817)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.9986982434666626)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select sin(c13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 0.1411200080598672)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.9999303766734422)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select sin(a) from (select sin(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.7456241416655579)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.7890723435728884)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.6866002607386249)
        tdSql.checkData(5, 0, 0.8263696344332049)
        tdSql.checkData(6, 0, -0.8263696344332049)

        tdSql.query("select sin(c2 + c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.9092974268256817)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.9893582466233818)
        tdSql.checkData(5, 0, 0.9989477243796069)
        tdSql.checkData(6, 0, -0.9989477243796069)

        tdSql.query("select sin((c2 + c3)) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.9092974268256817)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.9893582466233818)
        tdSql.checkData(5, 0, 0.9989477243796069)
        tdSql.checkData(6, 0, -0.9989477243796069)

        tdSql.query("select sin((c2 * c3)+c4-6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.7568024953079282)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.9906073556948704)
        tdSql.checkData(5, 0, 0.08341720348826624)
        tdSql.checkData(6, 0, 0.9909625452221539)

        tdSql.query("select sin(11)+c2 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 9.793449296524592e-06)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.0000097934492964)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 3.0000097934492964)
        tdSql.checkData(5, 0, 126.0000097934493)
        tdSql.checkData(6, 0, -127.9999902065507)

        tdSql.query("select sin(c2)+11 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 11.841470984807897)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 11.909297426825681)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 10.243197504692072)
        tdSql.checkData(5, 0, 11.972630067242408)
        tdSql.checkData(6, 0, 10.027369932757592)

        tdSql.query(
            "select sin(c2+c3) from tb1 where c2 is not null and c3 is not null;"
        )
        tdSql.checkRows(4)
        tdSql.checkData(0, 0, 0.9092974268256817)
        tdSql.checkData(1, 0, 0.9893582466233818)
        tdSql.checkData(2, 0, 0.9989477243796069)
        tdSql.checkData(3, 0, -0.9989477243796069)

        tdSql.query("select sin(c2) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -0.972630067242408)
        tdSql.checkData(1, 0, 0.972630067242408)
        tdSql.checkData(2, 0, -0.7568024953079282)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.9092974268256817)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 0.8414709848078965)

        tdSql.query("select sin(c2+c3) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -0.9989477243796069)
        tdSql.checkData(1, 0, 0.9989477243796069)
        tdSql.checkData(2, 0, 0.9893582466233818)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, None)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 0.9092974268256817)

        tdSql.query("select sin(c2+c3) from tb1 order by ts desc limit 3 offset 2;")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 0.9893582466233818)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)

        tdSql.query("select sin(c2) from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.9092974268256817)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.972630067242408)
        tdSql.checkData(6, 0, -0.972630067242408)
        tdSql.checkData(7, 0, 0.8414709848078965)
        tdSql.checkData(8, 0, 0.9092974268256817)
        tdSql.checkData(9, 0, 0.1411200080598672)
        tdSql.checkData(10, 0, -0.7568024953079282)
        tdSql.checkData(11, 0, -0.9589242746631385)
        tdSql.checkData(12, 0, -0.27941549819892586)
        tdSql.checkData(13, 0, 0.6569865987187891)

        tdSql.query("select sin(c2) from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select sin(c4),t1 from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select sin(c3),tbname from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(0, 1, "tb1")
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, "tb1")
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, "tb1")
        tdSql.checkData(3, 0, 0.1411200080598672)
        tdSql.checkData(3, 1, "tb1")
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(4, 1, "tb1")
        tdSql.checkData(5, 0, 0.18750655394138943)
        tdSql.checkData(5, 1, "tb1")
        tdSql.checkData(6, 0, -0.18750655394138943)
        tdSql.checkData(6, 1, "tb1")
        tdSql.checkData(7, 0, 0.8414709848078965)
        tdSql.checkData(7, 1, "tb2")
        tdSql.checkData(8, 0, 0.9092974268256817)
        tdSql.checkData(8, 1, "tb2")
        tdSql.checkData(9, 0, 0.1411200080598672)
        tdSql.checkData(9, 1, "tb2")
        tdSql.checkData(10, 0, -0.7568024953079282)
        tdSql.checkData(10, 1, "tb2")
        tdSql.checkData(11, 0, -0.9589242746631385)
        tdSql.checkData(11, 1, "tb2")
        tdSql.checkData(12, 0, -0.27941549819892586)
        tdSql.checkData(12, 1, "tb2")
        tdSql.checkData(13, 0, 0.6569865987187891)
        tdSql.checkData(13, 1, "tb2")

        tdSql.query("select sin(c3),tbname from stb1 where t1 > 1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(0, 1, "tb2")
        tdSql.checkData(1, 0, 0.9092974268256817)
        tdSql.checkData(1, 1, "tb2")
        tdSql.checkData(2, 0, 0.1411200080598672)
        tdSql.checkData(2, 1, "tb2")
        tdSql.checkData(3, 0, -0.7568024953079282)
        tdSql.checkData(3, 1, "tb2")
        tdSql.checkData(4, 0, -0.9589242746631385)
        tdSql.checkData(4, 1, "tb2")
        tdSql.checkData(5, 0, -0.27941549819892586)
        tdSql.checkData(5, 1, "tb2")
        tdSql.checkData(6, 0, 0.6569865987187891)
        tdSql.checkData(6, 1, "tb2")

        tdSql.query("select sin(a) from (select avg(c2) as a from stb1 interval(1s));")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, 0.9092974268256817)
        tdSql.checkData(2, 0, 0.5984721441039565)
        tdSql.checkData(3, 0, -0.7568024953079282)
        tdSql.checkData(4, 0, -0.977530117665097)
        tdSql.checkData(5, 0, -0.5025573497604873)
        tdSql.checkData(6, 0, 0.3048106211022167)

        tdSql.query("select sin(c2) from (select * from stb1);")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.9092974268256817)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.972630067242408)
        tdSql.checkData(6, 0, -0.972630067242408)
        tdSql.checkData(7, 0, 0.8414709848078965)
        tdSql.checkData(8, 0, 0.9092974268256817)
        tdSql.checkData(9, 0, 0.1411200080598672)
        tdSql.checkData(10, 0, -0.7568024953079282)
        tdSql.checkData(11, 0, -0.9589242746631385)
        tdSql.checkData(12, 0, -0.27941549819892586)
        tdSql.checkData(13, 0, 0.6569865987187891)

        tdSql.query(
            "select sin(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null));"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, 0.9092974268256817)
        tdSql.checkData(2, 0, 0.5984721441039565)
        tdSql.checkData(3, 0, -0.7568024953079282)
        tdSql.checkData(4, 0, -0.977530117665097)
        tdSql.checkData(5, 0, -0.5025573497604873)
        tdSql.checkData(6, 0, 0.3048106211022167)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select sin(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, 0.9092974268256817)
        tdSql.checkData(2, 0, 0.5984721441039565)
        tdSql.checkData(3, 0, -0.7568024953079282)
        tdSql.checkData(4, 0, -0.977530117665097)
        tdSql.checkData(5, 0, -0.5025573497604873)
        tdSql.checkData(6, 0, 0.3048106211022167)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select sin(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 0.3048106211022167)
        tdSql.checkData(4, 0, -0.5025573497604873)
        tdSql.checkData(5, 0, -0.977530117665097)
        tdSql.checkData(6, 0, -0.7568024953079282)
        tdSql.checkData(7, 0, 0.5984721441039565)
        tdSql.checkData(8, 0, 0.9092974268256817)
        tdSql.checkData(9, 0, 0.8414709848078965)

        tdSql.query(
            "select sin(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.5025573497604873)
        tdSql.checkData(4, 0, -0.977530117665097)
        tdSql.checkData(5, 0, -0.7568024953079282)
        tdSql.checkData(6, 0, 0.5984721441039565)
        tdSql.checkData(7, 0, 0.9092974268256817)
        tdSql.checkData(8, 0, 0.8414709848078965)
        tdSql.checkData(9, 0, 0.3048106211022167)

        tdSql.query(
            "select sin(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 0.3048106211022167)
        tdSql.checkData(1, 0, 0.8414709848078965)
        tdSql.checkData(2, 0, 0.9092974268256817)
        tdSql.checkData(3, 0, 0.5984721441039565)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, -0.977530117665097)
        tdSql.checkData(6, 0, -0.5025573497604873)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query("select sin(a) from (select sin(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.7456241416655579)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.7890723435728884)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.6866002607386249)
        tdSql.checkData(5, 0, 0.8263696344332049)
        tdSql.checkData(6, 0, -0.8263696344332049)

        tdSql.query("select sin(tb1.c3),sin(tb2.c3) from tb1,tb2 where tb1.ts=tb2.ts;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(0, 1, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, 0.9092974268256817)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, 0.1411200080598672)
        tdSql.checkData(3, 0, 0.1411200080598672)
        tdSql.checkData(3, 1, -0.7568024953079282)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(4, 1, -0.9589242746631385)
        tdSql.checkData(5, 0, 0.18750655394138943)
        tdSql.checkData(5, 1, -0.27941549819892586)
        tdSql.checkData(6, 0, -0.18750655394138943)
        tdSql.checkData(6, 1, 0.6569865987187891)

        tdSql.query("select sin(c3) from tb1 union all select sin(c3) from tb2;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 0.1411200080598672)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, 0.18750655394138943)
        tdSql.checkData(6, 0, -0.18750655394138943)
        tdSql.checkData(7, 0, 0.8414709848078965)
        tdSql.checkData(8, 0, 0.9092974268256817)
        tdSql.checkData(9, 0, 0.1411200080598672)
        tdSql.checkData(10, 0, -0.7568024953079282)
        tdSql.checkData(11, 0, -0.9589242746631385)
        tdSql.checkData(12, 0, -0.27941549819892586)
        tdSql.checkData(13, 0, 0.6569865987187891)

        # ===========  end   math_sin  ==========

        # ===========  begin math_sin2  ==========
        tdSql.query(
            "select sin(stb1.c4),sin(stba.c5) from stb1,stba where stb1.t1=stba.t1 and stb1.ts=stba.ts;"
        )
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(0, 1, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, 0.9092974268256817)
        tdSql.checkData(2, 0, 0.9092974268256817)
        tdSql.checkData(2, 1, 0.1411200080598672)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(3, 1, -0.7568024953079282)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(4, 1, -0.9589242746631385)
        tdSql.checkData(5, 0, -0.7249165551445564)
        tdSql.checkData(5, 1, -0.27941549819892586)
        tdSql.checkData(6, 0, 0.7249165551445564)
        tdSql.checkData(6, 1, 0.6569865987187891)

        tdSql.query(
            "select sin(c4) as a from stb1 union all select sin(c5) as a from stba;"
        )
        tdSql.checkRows(44)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.9092974268256817)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.7568024953079282)
        tdSql.checkData(5, 0, -0.7249165551445564)
        tdSql.checkData(6, 0, 0.7249165551445564)
        tdSql.checkData(7, 0, 0.8414709848078965)
        tdSql.checkData(8, 0, 0.9092974268256817)
        tdSql.checkData(9, 0, 0.9092974268256817)
        tdSql.checkData(10, 0, -0.7568024953079282)
        tdSql.checkData(11, 0, -0.9589242746631385)
        tdSql.checkData(12, 0, -0.27941549819892586)
        tdSql.checkData(13, 0, 0.6569865987187891)
        tdSql.checkData(14, 0, 0.8414709848078965)
        tdSql.checkData(15, 0, 0.9092974268256817)
        tdSql.checkData(16, 0, 0.1411200080598672)
        tdSql.checkData(17, 0, -0.7568024953079282)
        tdSql.checkData(18, 0, -0.9589242746631385)
        tdSql.checkData(19, 0, -0.27941549819892586)
        tdSql.checkData(20, 0, 0.6569865987187891)
        tdSql.checkData(21, 0, 0.9893582466233818)
        tdSql.checkData(22, 0, 0.4121184852417566)
        tdSql.checkData(23, 0, 0.0)
        tdSql.checkData(24, 0, 0.8414709848078965)
        tdSql.checkData(25, 0, 0.9092974268256817)
        tdSql.checkData(26, 0, 0.1411200080598672)
        tdSql.checkData(27, 0, -0.7568024953079282)
        tdSql.checkData(28, 0, -0.9589242746631385)
        tdSql.checkData(29, 0, -0.27941549819892586)
        tdSql.checkData(30, 0, 0.6569865987187891)
        tdSql.checkData(31, 0, 0.9893582466233818)
        tdSql.checkData(32, 0, 0.4121184852417566)
        tdSql.checkData(33, 0, 0.0)
        tdSql.checkData(34, 0, 0.8414709848078965)
        tdSql.checkData(35, 0, 0.9092974268256817)
        tdSql.checkData(36, 0, 0.1411200080598672)
        tdSql.checkData(37, 0, -0.7568024953079282)
        tdSql.checkData(38, 0, -0.9589242746631385)
        tdSql.checkData(39, 0, -0.27941549819892586)
        tdSql.checkData(40, 0, 0.6569865987187891)
        tdSql.checkData(41, 0, 0.9893582466233818)
        tdSql.checkData(42, 0, 0.4121184852417566)
        tdSql.checkData(43, 0, 0.0)

        tdSql.query("select sin(c2) from stba;")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, 0.8414709848078965)
        tdSql.checkData(1, 0, 0.9092974268256817)
        tdSql.checkData(2, 0, 0.1411200080598672)
        tdSql.checkData(3, 0, -0.7568024953079282)
        tdSql.checkData(4, 0, -0.9589242746631385)
        tdSql.checkData(5, 0, -0.27941549819892586)
        tdSql.checkData(6, 0, 0.6569865987187891)
        tdSql.checkData(7, 0, 0.9893582466233818)
        tdSql.checkData(8, 0, 0.4121184852417566)
        tdSql.checkData(9, 0, 0.0)
        tdSql.checkData(10, 0, 0.8414709848078965)
        tdSql.checkData(11, 0, 0.9092974268256817)
        tdSql.checkData(12, 0, 0.1411200080598672)
        tdSql.checkData(13, 0, -0.7568024953079282)
        tdSql.checkData(14, 0, -0.9589242746631385)
        tdSql.checkData(15, 0, -0.27941549819892586)
        tdSql.checkData(16, 0, 0.6569865987187891)
        tdSql.checkData(17, 0, 0.9893582466233818)
        tdSql.checkData(18, 0, 0.4121184852417566)
        tdSql.checkData(19, 0, 0.0)
        tdSql.checkData(20, 0, 0.8414709848078965)
        tdSql.checkData(21, 0, 0.9092974268256817)
        tdSql.checkData(22, 0, 0.1411200080598672)
        tdSql.checkData(23, 0, -0.7568024953079282)
        tdSql.checkData(24, 0, -0.9589242746631385)
        tdSql.checkData(25, 0, -0.27941549819892586)
        tdSql.checkData(26, 0, 0.6569865987187891)
        tdSql.checkData(27, 0, 0.9893582466233818)
        tdSql.checkData(28, 0, 0.4121184852417566)
        tdSql.checkData(29, 0, 0.0)

        tdSql.query("select sin(min(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        tdSql.query("select sin(max(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.4121184852417566)

        tdSql.query("select sin(count(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, -0.9880316240928618)

        tdSql.query("select sin(sum(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.08836868610400143)

        tdSql.query("select sin(avg(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, -0.977530117665097)

        tdSql.query("select sin(percentile(c2, 10)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.7833269096274833)

        tdSql.query("select sin(apercentile(c2, 10)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        tdSql.query("select sin(stddev(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.266067653696438)

        tdSql.query("select sin(spread(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.4121184852417566)

        tdSql.query("select sin(twa(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, -0.9972292875667882)

        tdSql.query("select sin(interp(c2)) from tba1 every(1s)")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, datetime.datetime(2021, 11, 11, 9, 0))
        tdSql.checkData(0, 1, 0.8414709848078965)
        tdSql.checkData(1, 0, datetime.datetime(2021, 11, 11, 9, 0, 1))
        tdSql.checkData(1, 1, 0.9092974268256817)
        tdSql.checkData(2, 0, datetime.datetime(2021, 11, 11, 9, 0, 2))
        tdSql.checkData(2, 1, 0.1411200080598672)
        tdSql.checkData(3, 0, datetime.datetime(2021, 11, 11, 9, 0, 3))
        tdSql.checkData(3, 1, -0.7568024953079282)
        tdSql.checkData(4, 0, datetime.datetime(2021, 11, 11, 9, 0, 4))
        tdSql.checkData(4, 1, -0.9589242746631385)
        tdSql.checkData(5, 0, datetime.datetime(2021, 11, 11, 9, 0, 5))
        tdSql.checkData(5, 1, -0.27941549819892586)
        tdSql.checkData(6, 0, datetime.datetime(2021, 11, 11, 9, 0, 6))
        tdSql.checkData(6, 1, 0.6569865987187891)
        tdSql.checkData(7, 0, datetime.datetime(2021, 11, 11, 9, 0, 7))
        tdSql.checkData(7, 1, 0.9893582466233818)
        tdSql.checkData(8, 0, datetime.datetime(2021, 11, 11, 9, 0, 8))
        tdSql.checkData(8, 1, 0.4121184852417566)
        tdSql.checkData(9, 0, datetime.datetime(2021, 11, 11, 9, 0, 9))
        tdSql.checkData(9, 1, 0.0)
        tdSql.checkData(10, 0, datetime.datetime(2021, 11, 11, 9, 0, 10))
        tdSql.checkData(10, 1, 0.8414709848078965)
        tdSql.checkData(11, 0, datetime.datetime(2021, 11, 11, 9, 0, 11))
        tdSql.checkData(11, 1, 0.9092974268256817)
        tdSql.checkData(12, 0, datetime.datetime(2021, 11, 11, 9, 0, 12))
        tdSql.checkData(12, 1, 0.1411200080598672)
        tdSql.checkData(13, 0, datetime.datetime(2021, 11, 11, 9, 0, 13))
        tdSql.checkData(13, 1, -0.7568024953079282)
        tdSql.checkData(14, 0, datetime.datetime(2021, 11, 11, 9, 0, 14))
        tdSql.checkData(14, 1, -0.9589242746631385)
        tdSql.checkData(15, 0, datetime.datetime(2021, 11, 11, 9, 0, 15))
        tdSql.checkData(15, 1, -0.27941549819892586)
        tdSql.checkData(16, 0, datetime.datetime(2021, 11, 11, 9, 0, 16))
        tdSql.checkData(16, 1, 0.6569865987187891)
        tdSql.checkData(17, 0, datetime.datetime(2021, 11, 11, 9, 0, 17))
        tdSql.checkData(17, 1, 0.9893582466233818)
        tdSql.checkData(18, 0, datetime.datetime(2021, 11, 11, 9, 0, 18))
        tdSql.checkData(18, 1, 0.4121184852417566)
        tdSql.checkData(19, 0, datetime.datetime(2021, 11, 11, 9, 0, 19))
        tdSql.checkData(19, 1, 0.0)
        tdSql.checkData(20, 0, datetime.datetime(2021, 11, 11, 9, 0, 20))
        tdSql.checkData(20, 1, 0.8414709848078965)
        tdSql.checkData(21, 0, datetime.datetime(2021, 11, 11, 9, 0, 21))
        tdSql.checkData(21, 1, 0.9092974268256817)
        tdSql.checkData(22, 0, datetime.datetime(2021, 11, 11, 9, 0, 22))
        tdSql.checkData(22, 1, 0.1411200080598672)
        tdSql.checkData(23, 0, datetime.datetime(2021, 11, 11, 9, 0, 23))
        tdSql.checkData(23, 1, -0.7568024953079282)
        tdSql.checkData(24, 0, datetime.datetime(2021, 11, 11, 9, 0, 24))
        tdSql.checkData(24, 1, -0.9589242746631385)
        tdSql.checkData(25, 0, datetime.datetime(2021, 11, 11, 9, 0, 25))
        tdSql.checkData(25, 1, -0.27941549819892586)
        tdSql.checkData(26, 0, datetime.datetime(2021, 11, 11, 9, 0, 26))
        tdSql.checkData(26, 1, 0.6569865987187891)
        tdSql.checkData(27, 0, datetime.datetime(2021, 11, 11, 9, 0, 27))
        tdSql.checkData(27, 1, 0.9893582466233818)
        tdSql.checkData(28, 0, datetime.datetime(2021, 11, 11, 9, 0, 28))
        tdSql.checkData(28, 1, 0.4121184852417566)
        tdSql.checkData(29, 0, datetime.datetime(2021, 11, 11, 9, 0, 29))
        tdSql.checkData(29, 1, 0.0)

        tdSql.query("select sin(interp(c2)) from stba every(1s) group by tbname;")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, datetime.datetime(2021, 11, 11, 9, 0))
        tdSql.checkData(0, 1, 0.8414709848078965)
        tdSql.checkData(0, 2, "tba1")
        tdSql.checkData(1, 0, datetime.datetime(2021, 11, 11, 9, 0, 1))
        tdSql.checkData(1, 1, 0.9092974268256817)
        tdSql.checkData(1, 2, "tba1")
        tdSql.checkData(2, 0, datetime.datetime(2021, 11, 11, 9, 0, 2))
        tdSql.checkData(2, 1, 0.1411200080598672)
        tdSql.checkData(2, 2, "tba1")
        tdSql.checkData(3, 0, datetime.datetime(2021, 11, 11, 9, 0, 3))
        tdSql.checkData(3, 1, -0.7568024953079282)
        tdSql.checkData(3, 2, "tba1")
        tdSql.checkData(4, 0, datetime.datetime(2021, 11, 11, 9, 0, 4))
        tdSql.checkData(4, 1, -0.9589242746631385)
        tdSql.checkData(4, 2, "tba1")
        tdSql.checkData(5, 0, datetime.datetime(2021, 11, 11, 9, 0, 5))
        tdSql.checkData(5, 1, -0.27941549819892586)
        tdSql.checkData(5, 2, "tba1")
        tdSql.checkData(6, 0, datetime.datetime(2021, 11, 11, 9, 0, 6))
        tdSql.checkData(6, 1, 0.6569865987187891)
        tdSql.checkData(6, 2, "tba1")
        tdSql.checkData(7, 0, datetime.datetime(2021, 11, 11, 9, 0, 7))
        tdSql.checkData(7, 1, 0.9893582466233818)
        tdSql.checkData(7, 2, "tba1")
        tdSql.checkData(8, 0, datetime.datetime(2021, 11, 11, 9, 0, 8))
        tdSql.checkData(8, 1, 0.4121184852417566)
        tdSql.checkData(8, 2, "tba1")
        tdSql.checkData(9, 0, datetime.datetime(2021, 11, 11, 9, 0, 9))
        tdSql.checkData(9, 1, 0.0)
        tdSql.checkData(9, 2, "tba1")
        tdSql.checkData(10, 0, datetime.datetime(2021, 11, 11, 9, 0, 10))
        tdSql.checkData(10, 1, 0.8414709848078965)
        tdSql.checkData(10, 2, "tba1")
        tdSql.checkData(11, 0, datetime.datetime(2021, 11, 11, 9, 0, 11))
        tdSql.checkData(11, 1, 0.9092974268256817)
        tdSql.checkData(11, 2, "tba1")
        tdSql.checkData(12, 0, datetime.datetime(2021, 11, 11, 9, 0, 12))
        tdSql.checkData(12, 1, 0.1411200080598672)
        tdSql.checkData(12, 2, "tba1")
        tdSql.checkData(13, 0, datetime.datetime(2021, 11, 11, 9, 0, 13))
        tdSql.checkData(13, 1, -0.7568024953079282)
        tdSql.checkData(13, 2, "tba1")
        tdSql.checkData(14, 0, datetime.datetime(2021, 11, 11, 9, 0, 14))
        tdSql.checkData(14, 1, -0.9589242746631385)
        tdSql.checkData(14, 2, "tba1")
        tdSql.checkData(15, 0, datetime.datetime(2021, 11, 11, 9, 0, 15))
        tdSql.checkData(15, 1, -0.27941549819892586)
        tdSql.checkData(15, 2, "tba1")
        tdSql.checkData(16, 0, datetime.datetime(2021, 11, 11, 9, 0, 16))
        tdSql.checkData(16, 1, 0.6569865987187891)
        tdSql.checkData(16, 2, "tba1")
        tdSql.checkData(17, 0, datetime.datetime(2021, 11, 11, 9, 0, 17))
        tdSql.checkData(17, 1, 0.9893582466233818)
        tdSql.checkData(17, 2, "tba1")
        tdSql.checkData(18, 0, datetime.datetime(2021, 11, 11, 9, 0, 18))
        tdSql.checkData(18, 1, 0.4121184852417566)
        tdSql.checkData(18, 2, "tba1")
        tdSql.checkData(19, 0, datetime.datetime(2021, 11, 11, 9, 0, 19))
        tdSql.checkData(19, 1, 0.0)
        tdSql.checkData(19, 2, "tba1")
        tdSql.checkData(20, 0, datetime.datetime(2021, 11, 11, 9, 0, 20))
        tdSql.checkData(20, 1, 0.8414709848078965)
        tdSql.checkData(20, 2, "tba1")
        tdSql.checkData(21, 0, datetime.datetime(2021, 11, 11, 9, 0, 21))
        tdSql.checkData(21, 1, 0.9092974268256817)
        tdSql.checkData(21, 2, "tba1")
        tdSql.checkData(22, 0, datetime.datetime(2021, 11, 11, 9, 0, 22))
        tdSql.checkData(22, 1, 0.1411200080598672)
        tdSql.checkData(22, 2, "tba1")
        tdSql.checkData(23, 0, datetime.datetime(2021, 11, 11, 9, 0, 23))
        tdSql.checkData(23, 1, -0.7568024953079282)
        tdSql.checkData(23, 2, "tba1")
        tdSql.checkData(24, 0, datetime.datetime(2021, 11, 11, 9, 0, 24))
        tdSql.checkData(24, 1, -0.9589242746631385)
        tdSql.checkData(24, 2, "tba1")
        tdSql.checkData(25, 0, datetime.datetime(2021, 11, 11, 9, 0, 25))
        tdSql.checkData(25, 1, -0.27941549819892586)
        tdSql.checkData(25, 2, "tba1")
        tdSql.checkData(26, 0, datetime.datetime(2021, 11, 11, 9, 0, 26))
        tdSql.checkData(26, 1, 0.6569865987187891)
        tdSql.checkData(26, 2, "tba1")
        tdSql.checkData(27, 0, datetime.datetime(2021, 11, 11, 9, 0, 27))
        tdSql.checkData(27, 1, 0.9893582466233818)
        tdSql.checkData(27, 2, "tba1")
        tdSql.checkData(28, 0, datetime.datetime(2021, 11, 11, 9, 0, 28))
        tdSql.checkData(28, 1, 0.4121184852417566)
        tdSql.checkData(28, 2, "tba1")
        tdSql.checkData(29, 0, datetime.datetime(2021, 11, 11, 9, 0, 29))
        tdSql.checkData(29, 1, 0.0)
        tdSql.checkData(29, 2, "tba1")

        tdSql.query("select sin(elapsed(ts)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.04177312885292625)

        tdSql.query("select sin(rate(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.7811787741147804)

        tdSql.query("select sin(irate(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        tdSql.query("select sin(first(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.8414709848078965)

        tdSql.query("select sin(last(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        tdSql.query("select sin(last_row(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        # ===========  end   math_sin2  ==========

        # ===========  begin math_cos  ==========
        tdSql.query("select cos(13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.9074467814501962)
        tdSql.checkData(1, 0, 0.9074467814501962)
        tdSql.checkData(2, 0, 0.9074467814501962)
        tdSql.checkData(3, 0, 0.9074467814501962)
        tdSql.checkData(4, 0, 0.9074467814501962)
        tdSql.checkData(5, 0, 0.9074467814501962)
        tdSql.checkData(6, 0, 0.9074467814501962)

        tdSql.query("select cos(c2) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -0.4161468365471424)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, 0.23235910202965793)
        tdSql.checkData(6, 0, 0.23235910202965793)

        tdSql.query("select cos(c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.9899924966004454)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, 0.9822633517692823)
        tdSql.checkData(6, 0, 0.9822633517692823)

        tdSql.query("select cos(c4) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -0.4161468365471424)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, -0.6888366918779438)
        tdSql.checkData(6, 0, -0.6888366918779438)

        tdSql.query("select cos(c5) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.9899924966004454)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, 0.011800076512800236)
        tdSql.checkData(6, 0, 0.011800076512800236)

        tdSql.query("select cos(c6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -0.4161468365471424)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, 0.8530210398303042)
        tdSql.checkData(6, 0, 0.8530210398303042)

        tdSql.query("select cos(c7) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.9899924966004454)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, 0.4880256326710555)
        tdSql.checkData(6, 0, 0.4880256326710555)

        tdSql.query("select cos(c10) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -0.4161468365471424)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, -0.892018495407942)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select cos(c11) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.9899924966004454)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, 0.9296825844580496)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select cos(c12) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -0.4161468365471424)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, -0.051008023845301335)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select cos(c13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.9899924966004454)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, 0.011800076512800236)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select cos(a) from (select cos(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8575532158463934)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.9146533258523714)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.7938734492261525)
        tdSql.checkData(5, 0, 0.9731258638638398)
        tdSql.checkData(6, 0, 0.9731258638638398)

        tdSql.query("select cos(c2 + c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -0.4161468365471424)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.14550003380861354)
        tdSql.checkData(5, 0, 0.04586331820534665)
        tdSql.checkData(6, 0, 0.04586331820534665)

        tdSql.query("select cos((c2 + c3)) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -0.4161468365471424)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.14550003380861354)
        tdSql.checkData(5, 0, 0.04586331820534665)
        tdSql.checkData(6, 0, 0.04586331820534665)

        tdSql.query("select cos((c2 * c3)+c4-6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -0.6536436208636119)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.1367372182078336)
        tdSql.checkData(5, 0, -0.9965147114630055)
        tdSql.checkData(6, 0, 0.13413886076313122)

        tdSql.query("select cos(11)+c2 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0044256979880508)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2.004425697988051)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4.004425697988051)
        tdSql.checkData(5, 0, 127.00442569798805)
        tdSql.checkData(6, 0, -126.99557430201195)

        tdSql.query("select cos(c2)+11 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 11.54030230586814)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 10.583853163452858)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 10.346356379136388)
        tdSql.checkData(5, 0, 11.232359102029658)
        tdSql.checkData(6, 0, 11.232359102029658)

        tdSql.query(
            "select cos(c2+c3) from tb1 where c2 is not null and c3 is not null;"
        )
        tdSql.checkRows(4)
        tdSql.checkData(0, 0, -0.4161468365471424)
        tdSql.checkData(1, 0, -0.14550003380861354)
        tdSql.checkData(2, 0, 0.04586331820534665)
        tdSql.checkData(3, 0, 0.04586331820534665)

        tdSql.query("select cos(c2) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.23235910202965793)
        tdSql.checkData(1, 0, 0.23235910202965793)
        tdSql.checkData(2, 0, -0.6536436208636119)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.4161468365471424)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 0.5403023058681398)

        tdSql.query("select cos(c2+c3) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.04586331820534665)
        tdSql.checkData(1, 0, 0.04586331820534665)
        tdSql.checkData(2, 0, -0.14550003380861354)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, None)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, -0.4161468365471424)

        tdSql.query("select cos(c2+c3) from tb1 order by ts desc limit 3 offset 2;")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, -0.14550003380861354)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)

        tdSql.query("select cos(c2) from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -0.4161468365471424)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, 0.23235910202965793)
        tdSql.checkData(6, 0, 0.23235910202965793)
        tdSql.checkData(7, 0, 0.5403023058681398)
        tdSql.checkData(8, 0, -0.4161468365471424)
        tdSql.checkData(9, 0, -0.9899924966004454)
        tdSql.checkData(10, 0, -0.6536436208636119)
        tdSql.checkData(11, 0, 0.28366218546322625)
        tdSql.checkData(12, 0, 0.960170286650366)
        tdSql.checkData(13, 0, 0.7539022543433046)

        tdSql.query("select cos(c2) from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select cos(c4),t1 from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select cos(c3),tbname from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(0, 1, "tb1")
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, "tb1")
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, "tb1")
        tdSql.checkData(3, 0, -0.9899924966004454)
        tdSql.checkData(3, 1, "tb1")
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(4, 1, "tb1")
        tdSql.checkData(5, 0, 0.9822633517692823)
        tdSql.checkData(5, 1, "tb1")
        tdSql.checkData(6, 0, 0.9822633517692823)
        tdSql.checkData(6, 1, "tb1")
        tdSql.checkData(7, 0, 0.5403023058681398)
        tdSql.checkData(7, 1, "tb2")
        tdSql.checkData(8, 0, -0.4161468365471424)
        tdSql.checkData(8, 1, "tb2")
        tdSql.checkData(9, 0, -0.9899924966004454)
        tdSql.checkData(9, 1, "tb2")
        tdSql.checkData(10, 0, -0.6536436208636119)
        tdSql.checkData(10, 1, "tb2")
        tdSql.checkData(11, 0, 0.28366218546322625)
        tdSql.checkData(11, 1, "tb2")
        tdSql.checkData(12, 0, 0.960170286650366)
        tdSql.checkData(12, 1, "tb2")
        tdSql.checkData(13, 0, 0.7539022543433046)
        tdSql.checkData(13, 1, "tb2")

        tdSql.query("select cos(c3),tbname from stb1 where t1 > 1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(0, 1, "tb2")
        tdSql.checkData(1, 0, -0.4161468365471424)
        tdSql.checkData(1, 1, "tb2")
        tdSql.checkData(2, 0, -0.9899924966004454)
        tdSql.checkData(2, 1, "tb2")
        tdSql.checkData(3, 0, -0.6536436208636119)
        tdSql.checkData(3, 1, "tb2")
        tdSql.checkData(4, 0, 0.28366218546322625)
        tdSql.checkData(4, 1, "tb2")
        tdSql.checkData(5, 0, 0.960170286650366)
        tdSql.checkData(5, 1, "tb2")
        tdSql.checkData(6, 0, 0.7539022543433046)
        tdSql.checkData(6, 1, "tb2")

        tdSql.query("select cos(a) from (select avg(c2) as a from stb1 interval(1s));")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, -0.4161468365471424)
        tdSql.checkData(2, 0, -0.8011436155469337)
        tdSql.checkData(3, 0, -0.6536436208636119)
        tdSql.checkData(4, 0, -0.2107957994307797)
        tdSql.checkData(5, 0, -0.8645438740756395)
        tdSql.checkData(6, 0, -0.9524129804151563)

        tdSql.query("select cos(c2) from (select * from stb1);")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -0.4161468365471424)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, 0.23235910202965793)
        tdSql.checkData(6, 0, 0.23235910202965793)
        tdSql.checkData(7, 0, 0.5403023058681398)
        tdSql.checkData(8, 0, -0.4161468365471424)
        tdSql.checkData(9, 0, -0.9899924966004454)
        tdSql.checkData(10, 0, -0.6536436208636119)
        tdSql.checkData(11, 0, 0.28366218546322625)
        tdSql.checkData(12, 0, 0.960170286650366)
        tdSql.checkData(13, 0, 0.7539022543433046)

        tdSql.query(
            "select cos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null));"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, -0.4161468365471424)
        tdSql.checkData(2, 0, -0.8011436155469337)
        tdSql.checkData(3, 0, -0.6536436208636119)
        tdSql.checkData(4, 0, -0.2107957994307797)
        tdSql.checkData(5, 0, -0.8645438740756395)
        tdSql.checkData(6, 0, -0.9524129804151563)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select cos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, -0.4161468365471424)
        tdSql.checkData(2, 0, -0.8011436155469337)
        tdSql.checkData(3, 0, -0.6536436208636119)
        tdSql.checkData(4, 0, -0.2107957994307797)
        tdSql.checkData(5, 0, -0.8645438740756395)
        tdSql.checkData(6, 0, -0.9524129804151563)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select cos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.9524129804151563)
        tdSql.checkData(4, 0, -0.8645438740756395)
        tdSql.checkData(5, 0, -0.2107957994307797)
        tdSql.checkData(6, 0, -0.6536436208636119)
        tdSql.checkData(7, 0, -0.8011436155469337)
        tdSql.checkData(8, 0, -0.4161468365471424)
        tdSql.checkData(9, 0, 0.5403023058681398)

        tdSql.query(
            "select cos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.8645438740756395)
        tdSql.checkData(4, 0, -0.2107957994307797)
        tdSql.checkData(5, 0, -0.6536436208636119)
        tdSql.checkData(6, 0, -0.8011436155469337)
        tdSql.checkData(7, 0, -0.4161468365471424)
        tdSql.checkData(8, 0, 0.5403023058681398)
        tdSql.checkData(9, 0, -0.9524129804151563)

        tdSql.query(
            "select cos(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, -0.9524129804151563)
        tdSql.checkData(1, 0, 0.5403023058681398)
        tdSql.checkData(2, 0, -0.4161468365471424)
        tdSql.checkData(3, 0, -0.8011436155469337)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, -0.2107957994307797)
        tdSql.checkData(6, 0, -0.8645438740756395)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query("select cos(a) from (select cos(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.8575532158463934)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.9146533258523714)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.7938734492261525)
        tdSql.checkData(5, 0, 0.9731258638638398)
        tdSql.checkData(6, 0, 0.9731258638638398)

        tdSql.query("select cos(tb1.c3),cos(tb2.c3) from tb1,tb2 where tb1.ts=tb2.ts;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(0, 1, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, -0.4161468365471424)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, -0.9899924966004454)
        tdSql.checkData(3, 0, -0.9899924966004454)
        tdSql.checkData(3, 1, -0.6536436208636119)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(4, 1, 0.28366218546322625)
        tdSql.checkData(5, 0, 0.9822633517692823)
        tdSql.checkData(5, 1, 0.960170286650366)
        tdSql.checkData(6, 0, 0.9822633517692823)
        tdSql.checkData(6, 1, 0.7539022543433046)

        tdSql.query("select cos(c3) from tb1 union all select cos(c3) from tb2;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.9899924966004454)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, 0.9822633517692823)
        tdSql.checkData(6, 0, 0.9822633517692823)
        tdSql.checkData(7, 0, 0.5403023058681398)
        tdSql.checkData(8, 0, -0.4161468365471424)
        tdSql.checkData(9, 0, -0.9899924966004454)
        tdSql.checkData(10, 0, -0.6536436208636119)
        tdSql.checkData(11, 0, 0.28366218546322625)
        tdSql.checkData(12, 0, 0.960170286650366)
        tdSql.checkData(13, 0, 0.7539022543433046)

        # ===========  end   math_cos  ==========

        # ===========  begin math_cos2  ==========
        tdSql.query(
            "select cos(stb1.c4),cos(stba.c5) from stb1,stba where stb1.t1=stba.t1 and stb1.ts=stba.ts;"
        )
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(0, 1, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, -0.4161468365471424)
        tdSql.checkData(2, 0, -0.4161468365471424)
        tdSql.checkData(2, 1, -0.9899924966004454)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(3, 1, -0.6536436208636119)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(4, 1, 0.28366218546322625)
        tdSql.checkData(5, 0, -0.6888366918779438)
        tdSql.checkData(5, 1, 0.960170286650366)
        tdSql.checkData(6, 0, -0.6888366918779438)
        tdSql.checkData(6, 1, 0.7539022543433046)

        tdSql.query(
            "select cos(c4) as a from stb1 union all select cos(c5) as a from stba;"
        )
        tdSql.checkRows(44)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -0.4161468365471424)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -0.6536436208636119)
        tdSql.checkData(5, 0, -0.6888366918779438)
        tdSql.checkData(6, 0, -0.6888366918779438)
        tdSql.checkData(7, 0, 0.5403023058681398)
        tdSql.checkData(8, 0, -0.4161468365471424)
        tdSql.checkData(9, 0, -0.4161468365471424)
        tdSql.checkData(10, 0, -0.6536436208636119)
        tdSql.checkData(11, 0, 0.28366218546322625)
        tdSql.checkData(12, 0, 0.960170286650366)
        tdSql.checkData(13, 0, 0.7539022543433046)
        tdSql.checkData(14, 0, 0.5403023058681398)
        tdSql.checkData(15, 0, -0.4161468365471424)
        tdSql.checkData(16, 0, -0.9899924966004454)
        tdSql.checkData(17, 0, -0.6536436208636119)
        tdSql.checkData(18, 0, 0.28366218546322625)
        tdSql.checkData(19, 0, 0.960170286650366)
        tdSql.checkData(20, 0, 0.7539022543433046)
        tdSql.checkData(21, 0, -0.14550003380861354)
        tdSql.checkData(22, 0, -0.9111302618846769)
        tdSql.checkData(23, 0, 1.0)
        tdSql.checkData(24, 0, 0.5403023058681398)
        tdSql.checkData(25, 0, -0.4161468365471424)
        tdSql.checkData(26, 0, -0.9899924966004454)
        tdSql.checkData(27, 0, -0.6536436208636119)
        tdSql.checkData(28, 0, 0.28366218546322625)
        tdSql.checkData(29, 0, 0.960170286650366)
        tdSql.checkData(30, 0, 0.7539022543433046)
        tdSql.checkData(31, 0, -0.14550003380861354)
        tdSql.checkData(32, 0, -0.9111302618846769)
        tdSql.checkData(33, 0, 1.0)
        tdSql.checkData(34, 0, 0.5403023058681398)
        tdSql.checkData(35, 0, -0.4161468365471424)
        tdSql.checkData(36, 0, -0.9899924966004454)
        tdSql.checkData(37, 0, -0.6536436208636119)
        tdSql.checkData(38, 0, 0.28366218546322625)
        tdSql.checkData(39, 0, 0.960170286650366)
        tdSql.checkData(40, 0, 0.7539022543433046)
        tdSql.checkData(41, 0, -0.14550003380861354)
        tdSql.checkData(42, 0, -0.9111302618846769)
        tdSql.checkData(43, 0, 1.0)

        tdSql.query("select cos(c2) from stba;")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, 0.5403023058681398)
        tdSql.checkData(1, 0, -0.4161468365471424)
        tdSql.checkData(2, 0, -0.9899924966004454)
        tdSql.checkData(3, 0, -0.6536436208636119)
        tdSql.checkData(4, 0, 0.28366218546322625)
        tdSql.checkData(5, 0, 0.960170286650366)
        tdSql.checkData(6, 0, 0.7539022543433046)
        tdSql.checkData(7, 0, -0.14550003380861354)
        tdSql.checkData(8, 0, -0.9111302618846769)
        tdSql.checkData(9, 0, 1.0)
        tdSql.checkData(10, 0, 0.5403023058681398)
        tdSql.checkData(11, 0, -0.4161468365471424)
        tdSql.checkData(12, 0, -0.9899924966004454)
        tdSql.checkData(13, 0, -0.6536436208636119)
        tdSql.checkData(14, 0, 0.28366218546322625)
        tdSql.checkData(15, 0, 0.960170286650366)
        tdSql.checkData(16, 0, 0.7539022543433046)
        tdSql.checkData(17, 0, -0.14550003380861354)
        tdSql.checkData(18, 0, -0.9111302618846769)
        tdSql.checkData(19, 0, 1.0)
        tdSql.checkData(20, 0, 0.5403023058681398)
        tdSql.checkData(21, 0, -0.4161468365471424)
        tdSql.checkData(22, 0, -0.9899924966004454)
        tdSql.checkData(23, 0, -0.6536436208636119)
        tdSql.checkData(24, 0, 0.28366218546322625)
        tdSql.checkData(25, 0, 0.960170286650366)
        tdSql.checkData(26, 0, 0.7539022543433046)
        tdSql.checkData(27, 0, -0.14550003380861354)
        tdSql.checkData(28, 0, -0.9111302618846769)
        tdSql.checkData(29, 0, 1.0)

        tdSql.query("select cos(min(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.0)

        tdSql.query("select cos(max(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, -0.9111302618846769)

        tdSql.query("select cos(count(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.15425144988758405)

        tdSql.query("select cos(sum(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, -0.9960878351411849)

        tdSql.query("select cos(avg(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, -0.2107957994307797)

        tdSql.query("select cos(percentile(c2, 10)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.6216099682706645)

        tdSql.query("select cos(apercentile(c2, 10)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.0)

        tdSql.query("select cos(stddev(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, -0.9639543576624737)

        tdSql.query("select cos(spread(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, -0.9111302618846769)

        tdSql.query("select cos(twa(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, -0.07438916600578388)

        tdSql.query("select cos(interp(c2)) from tba1 every(1s)")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, datetime.datetime(2021, 11, 11, 9, 0))
        tdSql.checkData(0, 1, 0.5403023058681398)
        tdSql.checkData(1, 0, datetime.datetime(2021, 11, 11, 9, 0, 1))
        tdSql.checkData(1, 1, -0.4161468365471424)
        tdSql.checkData(2, 0, datetime.datetime(2021, 11, 11, 9, 0, 2))
        tdSql.checkData(2, 1, -0.9899924966004454)
        tdSql.checkData(3, 0, datetime.datetime(2021, 11, 11, 9, 0, 3))
        tdSql.checkData(3, 1, -0.6536436208636119)
        tdSql.checkData(4, 0, datetime.datetime(2021, 11, 11, 9, 0, 4))
        tdSql.checkData(4, 1, 0.28366218546322625)
        tdSql.checkData(5, 0, datetime.datetime(2021, 11, 11, 9, 0, 5))
        tdSql.checkData(5, 1, 0.960170286650366)
        tdSql.checkData(6, 0, datetime.datetime(2021, 11, 11, 9, 0, 6))
        tdSql.checkData(6, 1, 0.7539022543433046)
        tdSql.checkData(7, 0, datetime.datetime(2021, 11, 11, 9, 0, 7))
        tdSql.checkData(7, 1, -0.14550003380861354)
        tdSql.checkData(8, 0, datetime.datetime(2021, 11, 11, 9, 0, 8))
        tdSql.checkData(8, 1, -0.9111302618846769)
        tdSql.checkData(9, 0, datetime.datetime(2021, 11, 11, 9, 0, 9))
        tdSql.checkData(9, 1, 1.0)
        tdSql.checkData(10, 0, datetime.datetime(2021, 11, 11, 9, 0, 10))
        tdSql.checkData(10, 1, 0.5403023058681398)
        tdSql.checkData(11, 0, datetime.datetime(2021, 11, 11, 9, 0, 11))
        tdSql.checkData(11, 1, -0.4161468365471424)
        tdSql.checkData(12, 0, datetime.datetime(2021, 11, 11, 9, 0, 12))
        tdSql.checkData(12, 1, -0.9899924966004454)
        tdSql.checkData(13, 0, datetime.datetime(2021, 11, 11, 9, 0, 13))
        tdSql.checkData(13, 1, -0.6536436208636119)
        tdSql.checkData(14, 0, datetime.datetime(2021, 11, 11, 9, 0, 14))
        tdSql.checkData(14, 1, 0.28366218546322625)
        tdSql.checkData(15, 0, datetime.datetime(2021, 11, 11, 9, 0, 15))
        tdSql.checkData(15, 1, 0.960170286650366)
        tdSql.checkData(16, 0, datetime.datetime(2021, 11, 11, 9, 0, 16))
        tdSql.checkData(16, 1, 0.7539022543433046)
        tdSql.checkData(17, 0, datetime.datetime(2021, 11, 11, 9, 0, 17))
        tdSql.checkData(17, 1, -0.14550003380861354)
        tdSql.checkData(18, 0, datetime.datetime(2021, 11, 11, 9, 0, 18))
        tdSql.checkData(18, 1, -0.9111302618846769)
        tdSql.checkData(19, 0, datetime.datetime(2021, 11, 11, 9, 0, 19))
        tdSql.checkData(19, 1, 1.0)
        tdSql.checkData(20, 0, datetime.datetime(2021, 11, 11, 9, 0, 20))
        tdSql.checkData(20, 1, 0.5403023058681398)
        tdSql.checkData(21, 0, datetime.datetime(2021, 11, 11, 9, 0, 21))
        tdSql.checkData(21, 1, -0.4161468365471424)
        tdSql.checkData(22, 0, datetime.datetime(2021, 11, 11, 9, 0, 22))
        tdSql.checkData(22, 1, -0.9899924966004454)
        tdSql.checkData(23, 0, datetime.datetime(2021, 11, 11, 9, 0, 23))
        tdSql.checkData(23, 1, -0.6536436208636119)
        tdSql.checkData(24, 0, datetime.datetime(2021, 11, 11, 9, 0, 24))
        tdSql.checkData(24, 1, 0.28366218546322625)
        tdSql.checkData(25, 0, datetime.datetime(2021, 11, 11, 9, 0, 25))
        tdSql.checkData(25, 1, 0.960170286650366)
        tdSql.checkData(26, 0, datetime.datetime(2021, 11, 11, 9, 0, 26))
        tdSql.checkData(26, 1, 0.7539022543433046)
        tdSql.checkData(27, 0, datetime.datetime(2021, 11, 11, 9, 0, 27))
        tdSql.checkData(27, 1, -0.14550003380861354)
        tdSql.checkData(28, 0, datetime.datetime(2021, 11, 11, 9, 0, 28))
        tdSql.checkData(28, 1, -0.9111302618846769)
        tdSql.checkData(29, 0, datetime.datetime(2021, 11, 11, 9, 0, 29))
        tdSql.checkData(29, 1, 1.0)

        tdSql.query("select cos(interp(c2)) from stba every(1s) group by tbname;")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, datetime.datetime(2021, 11, 11, 9, 0))
        tdSql.checkData(0, 1, 0.5403023058681398)
        tdSql.checkData(0, 2, "tba1")
        tdSql.checkData(1, 0, datetime.datetime(2021, 11, 11, 9, 0, 1))
        tdSql.checkData(1, 1, -0.4161468365471424)
        tdSql.checkData(1, 2, "tba1")
        tdSql.checkData(2, 0, datetime.datetime(2021, 11, 11, 9, 0, 2))
        tdSql.checkData(2, 1, -0.9899924966004454)
        tdSql.checkData(2, 2, "tba1")
        tdSql.checkData(3, 0, datetime.datetime(2021, 11, 11, 9, 0, 3))
        tdSql.checkData(3, 1, -0.6536436208636119)
        tdSql.checkData(3, 2, "tba1")
        tdSql.checkData(4, 0, datetime.datetime(2021, 11, 11, 9, 0, 4))
        tdSql.checkData(4, 1, 0.28366218546322625)
        tdSql.checkData(4, 2, "tba1")
        tdSql.checkData(5, 0, datetime.datetime(2021, 11, 11, 9, 0, 5))
        tdSql.checkData(5, 1, 0.960170286650366)
        tdSql.checkData(5, 2, "tba1")
        tdSql.checkData(6, 0, datetime.datetime(2021, 11, 11, 9, 0, 6))
        tdSql.checkData(6, 1, 0.7539022543433046)
        tdSql.checkData(6, 2, "tba1")
        tdSql.checkData(7, 0, datetime.datetime(2021, 11, 11, 9, 0, 7))
        tdSql.checkData(7, 1, -0.14550003380861354)
        tdSql.checkData(7, 2, "tba1")
        tdSql.checkData(8, 0, datetime.datetime(2021, 11, 11, 9, 0, 8))
        tdSql.checkData(8, 1, -0.9111302618846769)
        tdSql.checkData(8, 2, "tba1")
        tdSql.checkData(9, 0, datetime.datetime(2021, 11, 11, 9, 0, 9))
        tdSql.checkData(9, 1, 1.0)
        tdSql.checkData(9, 2, "tba1")
        tdSql.checkData(10, 0, datetime.datetime(2021, 11, 11, 9, 0, 10))
        tdSql.checkData(10, 1, 0.5403023058681398)
        tdSql.checkData(10, 2, "tba1")
        tdSql.checkData(11, 0, datetime.datetime(2021, 11, 11, 9, 0, 11))
        tdSql.checkData(11, 1, -0.4161468365471424)
        tdSql.checkData(11, 2, "tba1")
        tdSql.checkData(12, 0, datetime.datetime(2021, 11, 11, 9, 0, 12))
        tdSql.checkData(12, 1, -0.9899924966004454)
        tdSql.checkData(12, 2, "tba1")
        tdSql.checkData(13, 0, datetime.datetime(2021, 11, 11, 9, 0, 13))
        tdSql.checkData(13, 1, -0.6536436208636119)
        tdSql.checkData(13, 2, "tba1")
        tdSql.checkData(14, 0, datetime.datetime(2021, 11, 11, 9, 0, 14))
        tdSql.checkData(14, 1, 0.28366218546322625)
        tdSql.checkData(14, 2, "tba1")
        tdSql.checkData(15, 0, datetime.datetime(2021, 11, 11, 9, 0, 15))
        tdSql.checkData(15, 1, 0.960170286650366)
        tdSql.checkData(15, 2, "tba1")
        tdSql.checkData(16, 0, datetime.datetime(2021, 11, 11, 9, 0, 16))
        tdSql.checkData(16, 1, 0.7539022543433046)
        tdSql.checkData(16, 2, "tba1")
        tdSql.checkData(17, 0, datetime.datetime(2021, 11, 11, 9, 0, 17))
        tdSql.checkData(17, 1, -0.14550003380861354)
        tdSql.checkData(17, 2, "tba1")
        tdSql.checkData(18, 0, datetime.datetime(2021, 11, 11, 9, 0, 18))
        tdSql.checkData(18, 1, -0.9111302618846769)
        tdSql.checkData(18, 2, "tba1")
        tdSql.checkData(19, 0, datetime.datetime(2021, 11, 11, 9, 0, 19))
        tdSql.checkData(19, 1, 1.0)
        tdSql.checkData(19, 2, "tba1")
        tdSql.checkData(20, 0, datetime.datetime(2021, 11, 11, 9, 0, 20))
        tdSql.checkData(20, 1, 0.5403023058681398)
        tdSql.checkData(20, 2, "tba1")
        tdSql.checkData(21, 0, datetime.datetime(2021, 11, 11, 9, 0, 21))
        tdSql.checkData(21, 1, -0.4161468365471424)
        tdSql.checkData(21, 2, "tba1")
        tdSql.checkData(22, 0, datetime.datetime(2021, 11, 11, 9, 0, 22))
        tdSql.checkData(22, 1, -0.9899924966004454)
        tdSql.checkData(22, 2, "tba1")
        tdSql.checkData(23, 0, datetime.datetime(2021, 11, 11, 9, 0, 23))
        tdSql.checkData(23, 1, -0.6536436208636119)
        tdSql.checkData(23, 2, "tba1")
        tdSql.checkData(24, 0, datetime.datetime(2021, 11, 11, 9, 0, 24))
        tdSql.checkData(24, 1, 0.28366218546322625)
        tdSql.checkData(24, 2, "tba1")
        tdSql.checkData(25, 0, datetime.datetime(2021, 11, 11, 9, 0, 25))
        tdSql.checkData(25, 1, 0.960170286650366)
        tdSql.checkData(25, 2, "tba1")
        tdSql.checkData(26, 0, datetime.datetime(2021, 11, 11, 9, 0, 26))
        tdSql.checkData(26, 1, 0.7539022543433046)
        tdSql.checkData(26, 2, "tba1")
        tdSql.checkData(27, 0, datetime.datetime(2021, 11, 11, 9, 0, 27))
        tdSql.checkData(27, 1, -0.14550003380861354)
        tdSql.checkData(27, 2, "tba1")
        tdSql.checkData(28, 0, datetime.datetime(2021, 11, 11, 9, 0, 28))
        tdSql.checkData(28, 1, -0.9111302618846769)
        tdSql.checkData(28, 2, "tba1")
        tdSql.checkData(29, 0, datetime.datetime(2021, 11, 11, 9, 0, 29))
        tdSql.checkData(29, 1, 1.0)
        tdSql.checkData(29, 2, "tba1")

        tdSql.query("select cos(elapsed(ts)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, -0.9991271218948251)

        tdSql.query("select cos(rate(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.6243073945361602)

        tdSql.query("select cos(irate(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.0)

        tdSql.query("select cos(first(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.5403023058681398)

        tdSql.query("select cos(last(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.0)

        tdSql.query("select cos(last_row(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.0)

        # ===========  end   math_cos2  ==========

        # ===========  begin math_tan  ==========
        tdSql.query("select tan(13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.4630211329364896)
        tdSql.checkData(1, 0, 0.4630211329364896)
        tdSql.checkData(2, 0, 0.4630211329364896)
        tdSql.checkData(3, 0, 0.4630211329364896)
        tdSql.checkData(4, 0, 0.4630211329364896)
        tdSql.checkData(5, 0, 0.4630211329364896)
        tdSql.checkData(6, 0, 0.4630211329364896)

        tdSql.query("select tan(c2) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -2.185039863261519)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 4.185891831851989)
        tdSql.checkData(6, 0, -4.185891831851989)

        tdSql.query("select tan(c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.1425465430742778)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 0.19089234430221486)
        tdSql.checkData(6, 0, -0.19089234430221486)

        tdSql.query("select tan(c4) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -2.185039863261519)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 1.0523779637351338)
        tdSql.checkData(6, 0, -1.0523779637351338)

        tdSql.query("select tan(c5) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.1425465430742778)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 84.73931296875567)
        tdSql.checkData(6, 0, -84.73931296875567)

        tdSql.query("select tan(c6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -2.185039863261519)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, -0.6117979498342481)
        tdSql.checkData(6, 0, 0.6117979498342481)

        tdSql.query("select tan(c7) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.1425465430742778)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 1.7884906829818519)
        tdSql.checkData(6, 0, -1.7884906829818519)

        tdSql.query("select tan(c10) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -2.185039863261519)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, -0.5067147154345417)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select tan(c11) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.1425465430742778)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 0.39622301037411284)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select tan(c12) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -2.185039863261519)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, -19.579238091943036)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select tan(c13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.1425465430742778)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 84.73931296875567)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select tan(a) from (select tan(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 74.68593339876537)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.4179285755053868)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.282204450191367)
        tdSql.checkData(5, 0, 1.7205151938006633)
        tdSql.checkData(6, 0, -1.7205151938006633)

        tdSql.query("select tan(c2 + c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -2.185039863261519)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -6.799711455220379)
        tdSql.checkData(5, 0, 21.780973629229287)
        tdSql.checkData(6, 0, -21.780973629229287)

        tdSql.query("select tan((c2 + c3)) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -2.185039863261519)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -6.799711455220379)
        tdSql.checkData(5, 0, 21.780973629229287)
        tdSql.checkData(6, 0, -21.780973629229287)

        tdSql.query("select tan((c2 * c3)+c4-6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -1.1578212823495775)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 7.2446066160948055)
        tdSql.checkData(5, 0, -0.08370895334379919)
        tdSql.checkData(6, 0, 7.387587307544252)

        tdSql.query("select tan(11)+c2 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -224.95084645419513)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -223.95084645419513)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -221.95084645419513)
        tdSql.checkData(5, 0, -98.95084645419513)
        tdSql.checkData(6, 0, -352.95084645419513)

        tdSql.query("select tan(c2)+11 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 12.557407724654903)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 8.814960136738481)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 12.157821282349577)
        tdSql.checkData(5, 0, 15.18589183185199)
        tdSql.checkData(6, 0, 6.814108168148011)

        tdSql.query(
            "select tan(c2+c3) from tb1 where c2 is not null and c3 is not null;"
        )
        tdSql.checkRows(4)
        tdSql.checkData(0, 0, -2.185039863261519)
        tdSql.checkData(1, 0, -6.799711455220379)
        tdSql.checkData(2, 0, 21.780973629229287)
        tdSql.checkData(3, 0, -21.780973629229287)

        tdSql.query("select tan(c2) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -4.185891831851989)
        tdSql.checkData(1, 0, 4.185891831851989)
        tdSql.checkData(2, 0, 1.1578212823495775)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, -2.185039863261519)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 1.5574077246549023)

        tdSql.query("select tan(c2+c3) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -21.780973629229287)
        tdSql.checkData(1, 0, 21.780973629229287)
        tdSql.checkData(2, 0, -6.799711455220379)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, None)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, -2.185039863261519)

        tdSql.query("select tan(c2+c3) from tb1 order by ts desc limit 3 offset 2;")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, -6.799711455220379)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)

        tdSql.query("select tan(c2) from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -2.185039863261519)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 4.185891831851989)
        tdSql.checkData(6, 0, -4.185891831851989)
        tdSql.checkData(7, 0, 1.5574077246549023)
        tdSql.checkData(8, 0, -2.185039863261519)
        tdSql.checkData(9, 0, -0.1425465430742778)
        tdSql.checkData(10, 0, 1.1578212823495775)
        tdSql.checkData(11, 0, -3.380515006246586)
        tdSql.checkData(12, 0, -0.29100619138474915)
        tdSql.checkData(13, 0, 0.8714479827243188)

        tdSql.query("select tan(c2) from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select tan(c4),t1 from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select tan(c3),tbname from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(0, 1, "tb1")
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, "tb1")
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, "tb1")
        tdSql.checkData(3, 0, -0.1425465430742778)
        tdSql.checkData(3, 1, "tb1")
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(4, 1, "tb1")
        tdSql.checkData(5, 0, 0.19089234430221486)
        tdSql.checkData(5, 1, "tb1")
        tdSql.checkData(6, 0, -0.19089234430221486)
        tdSql.checkData(6, 1, "tb1")
        tdSql.checkData(7, 0, 1.5574077246549023)
        tdSql.checkData(7, 1, "tb2")
        tdSql.checkData(8, 0, -2.185039863261519)
        tdSql.checkData(8, 1, "tb2")
        tdSql.checkData(9, 0, -0.1425465430742778)
        tdSql.checkData(9, 1, "tb2")
        tdSql.checkData(10, 0, 1.1578212823495775)
        tdSql.checkData(10, 1, "tb2")
        tdSql.checkData(11, 0, -3.380515006246586)
        tdSql.checkData(11, 1, "tb2")
        tdSql.checkData(12, 0, -0.29100619138474915)
        tdSql.checkData(12, 1, "tb2")
        tdSql.checkData(13, 0, 0.8714479827243188)
        tdSql.checkData(13, 1, "tb2")

        tdSql.query("select tan(c3),tbname from stb1 where t1 > 1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(0, 1, "tb2")
        tdSql.checkData(1, 0, -2.185039863261519)
        tdSql.checkData(1, 1, "tb2")
        tdSql.checkData(2, 0, -0.1425465430742778)
        tdSql.checkData(2, 1, "tb2")
        tdSql.checkData(3, 0, 1.1578212823495775)
        tdSql.checkData(3, 1, "tb2")
        tdSql.checkData(4, 0, -3.380515006246586)
        tdSql.checkData(4, 1, "tb2")
        tdSql.checkData(5, 0, -0.29100619138474915)
        tdSql.checkData(5, 1, "tb2")
        tdSql.checkData(6, 0, 0.8714479827243188)
        tdSql.checkData(6, 1, "tb2")

        tdSql.query("select tan(a) from (select avg(c2) as a from stb1 interval(1s));")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, -2.185039863261519)
        tdSql.checkData(2, 0, -0.7470222972386603)
        tdSql.checkData(3, 0, 1.1578212823495775)
        tdSql.checkData(4, 0, 4.637332054551185)
        tdSql.checkData(5, 0, 0.5812976817374548)
        tdSql.checkData(6, 0, -0.320040389379563)

        tdSql.query("select tan(c2) from (select * from stb1);")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -2.185039863261519)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 4.185891831851989)
        tdSql.checkData(6, 0, -4.185891831851989)
        tdSql.checkData(7, 0, 1.5574077246549023)
        tdSql.checkData(8, 0, -2.185039863261519)
        tdSql.checkData(9, 0, -0.1425465430742778)
        tdSql.checkData(10, 0, 1.1578212823495775)
        tdSql.checkData(11, 0, -3.380515006246586)
        tdSql.checkData(12, 0, -0.29100619138474915)
        tdSql.checkData(13, 0, 0.8714479827243188)

        tdSql.query(
            "select tan(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null));"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, -2.185039863261519)
        tdSql.checkData(2, 0, -0.7470222972386603)
        tdSql.checkData(3, 0, 1.1578212823495775)
        tdSql.checkData(4, 0, 4.637332054551185)
        tdSql.checkData(5, 0, 0.5812976817374548)
        tdSql.checkData(6, 0, -0.320040389379563)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select tan(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, -2.185039863261519)
        tdSql.checkData(2, 0, -0.7470222972386603)
        tdSql.checkData(3, 0, 1.1578212823495775)
        tdSql.checkData(4, 0, 4.637332054551185)
        tdSql.checkData(5, 0, 0.5812976817374548)
        tdSql.checkData(6, 0, -0.320040389379563)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query(
            "select tan(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by ts desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.320040389379563)
        tdSql.checkData(4, 0, 0.5812976817374548)
        tdSql.checkData(5, 0, 4.637332054551185)
        tdSql.checkData(6, 0, 1.1578212823495775)
        tdSql.checkData(7, 0, -0.7470222972386603)
        tdSql.checkData(8, 0, -2.185039863261519)
        tdSql.checkData(9, 0, 1.5574077246549023)

        tdSql.query(
            "select tan(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a desc;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, None)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, 0.5812976817374548)
        tdSql.checkData(4, 0, 4.637332054551185)
        tdSql.checkData(5, 0, 1.1578212823495775)
        tdSql.checkData(6, 0, -0.7470222972386603)
        tdSql.checkData(7, 0, -2.185039863261519)
        tdSql.checkData(8, 0, 1.5574077246549023)
        tdSql.checkData(9, 0, -0.320040389379563)

        tdSql.query(
            "select tan(a) from (select avg(c2) as a from stb1 where ts >= '2021-11-11 09:00:00.000' and ts <= '2021-11-11 09:00:09.000' interval(1s) fill(null)) order by a;"
        )
        tdSql.checkRows(10)
        tdSql.checkData(0, 0, -0.320040389379563)
        tdSql.checkData(1, 0, 1.5574077246549023)
        tdSql.checkData(2, 0, -2.185039863261519)
        tdSql.checkData(3, 0, -0.7470222972386603)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 4.637332054551185)
        tdSql.checkData(6, 0, 0.5812976817374548)
        tdSql.checkData(7, 0, None)
        tdSql.checkData(8, 0, None)
        tdSql.checkData(9, 0, None)

        tdSql.query("select tan(a) from (select tan(c2) as a from tb1);")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 74.68593339876537)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.4179285755053868)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 2.282204450191367)
        tdSql.checkData(5, 0, 1.7205151938006633)
        tdSql.checkData(6, 0, -1.7205151938006633)

        tdSql.query("select tan(tb1.c3),tan(tb2.c3) from tb1,tb2 where tb1.ts=tb2.ts;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(0, 1, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, -2.185039863261519)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, -0.1425465430742778)
        tdSql.checkData(3, 0, -0.1425465430742778)
        tdSql.checkData(3, 1, 1.1578212823495775)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(4, 1, -3.380515006246586)
        tdSql.checkData(5, 0, 0.19089234430221486)
        tdSql.checkData(5, 1, -0.29100619138474915)
        tdSql.checkData(6, 0, -0.19089234430221486)
        tdSql.checkData(6, 1, 0.8714479827243188)

        tdSql.query("select tan(c3) from tb1 union all select tan(c3) from tb2;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, -0.1425465430742778)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 0.19089234430221486)
        tdSql.checkData(6, 0, -0.19089234430221486)
        tdSql.checkData(7, 0, 1.5574077246549023)
        tdSql.checkData(8, 0, -2.185039863261519)
        tdSql.checkData(9, 0, -0.1425465430742778)
        tdSql.checkData(10, 0, 1.1578212823495775)
        tdSql.checkData(11, 0, -3.380515006246586)
        tdSql.checkData(12, 0, -0.29100619138474915)
        tdSql.checkData(13, 0, 0.8714479827243188)

        # ===========  end   math_tan  ==========

        # ===========  begin math_tan2  ==========
        tdSql.query(
            "select tan(stb1.c4),tan(stba.c5) from stb1,stba where stb1.t1=stba.t1 and stb1.ts=stba.ts;"
        )
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(0, 1, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, -2.185039863261519)
        tdSql.checkData(2, 0, -2.185039863261519)
        tdSql.checkData(2, 1, -0.1425465430742778)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(3, 1, 1.1578212823495775)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(4, 1, -3.380515006246586)
        tdSql.checkData(5, 0, 1.0523779637351338)
        tdSql.checkData(5, 1, -0.29100619138474915)
        tdSql.checkData(6, 0, -1.0523779637351338)
        tdSql.checkData(6, 1, 0.8714479827243188)

        tdSql.query(
            "select tan(c4) as a from stb1 union all select tan(c5) as a from stba;"
        )
        tdSql.checkRows(44)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, -2.185039863261519)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.1578212823495775)
        tdSql.checkData(5, 0, 1.0523779637351338)
        tdSql.checkData(6, 0, -1.0523779637351338)
        tdSql.checkData(7, 0, 1.5574077246549023)
        tdSql.checkData(8, 0, -2.185039863261519)
        tdSql.checkData(9, 0, -2.185039863261519)
        tdSql.checkData(10, 0, 1.1578212823495775)
        tdSql.checkData(11, 0, -3.380515006246586)
        tdSql.checkData(12, 0, -0.29100619138474915)
        tdSql.checkData(13, 0, 0.8714479827243188)
        tdSql.checkData(14, 0, 1.5574077246549023)
        tdSql.checkData(15, 0, -2.185039863261519)
        tdSql.checkData(16, 0, -0.1425465430742778)
        tdSql.checkData(17, 0, 1.1578212823495775)
        tdSql.checkData(18, 0, -3.380515006246586)
        tdSql.checkData(19, 0, -0.29100619138474915)
        tdSql.checkData(20, 0, 0.8714479827243188)
        tdSql.checkData(21, 0, -6.799711455220379)
        tdSql.checkData(22, 0, -0.45231565944180985)
        tdSql.checkData(23, 0, 0.0)
        tdSql.checkData(24, 0, 1.5574077246549023)
        tdSql.checkData(25, 0, -2.185039863261519)
        tdSql.checkData(26, 0, -0.1425465430742778)
        tdSql.checkData(27, 0, 1.1578212823495775)
        tdSql.checkData(28, 0, -3.380515006246586)
        tdSql.checkData(29, 0, -0.29100619138474915)
        tdSql.checkData(30, 0, 0.8714479827243188)
        tdSql.checkData(31, 0, -6.799711455220379)
        tdSql.checkData(32, 0, -0.45231565944180985)
        tdSql.checkData(33, 0, 0.0)
        tdSql.checkData(34, 0, 1.5574077246549023)
        tdSql.checkData(35, 0, -2.185039863261519)
        tdSql.checkData(36, 0, -0.1425465430742778)
        tdSql.checkData(37, 0, 1.1578212823495775)
        tdSql.checkData(38, 0, -3.380515006246586)
        tdSql.checkData(39, 0, -0.29100619138474915)
        tdSql.checkData(40, 0, 0.8714479827243188)
        tdSql.checkData(41, 0, -6.799711455220379)
        tdSql.checkData(42, 0, -0.45231565944180985)
        tdSql.checkData(43, 0, 0.0)

        tdSql.query("select tan(c2) from stba;")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, 1.5574077246549023)
        tdSql.checkData(1, 0, -2.185039863261519)
        tdSql.checkData(2, 0, -0.1425465430742778)
        tdSql.checkData(3, 0, 1.1578212823495775)
        tdSql.checkData(4, 0, -3.380515006246586)
        tdSql.checkData(5, 0, -0.29100619138474915)
        tdSql.checkData(6, 0, 0.8714479827243188)
        tdSql.checkData(7, 0, -6.799711455220379)
        tdSql.checkData(8, 0, -0.45231565944180985)
        tdSql.checkData(9, 0, 0.0)
        tdSql.checkData(10, 0, 1.5574077246549023)
        tdSql.checkData(11, 0, -2.185039863261519)
        tdSql.checkData(12, 0, -0.1425465430742778)
        tdSql.checkData(13, 0, 1.1578212823495775)
        tdSql.checkData(14, 0, -3.380515006246586)
        tdSql.checkData(15, 0, -0.29100619138474915)
        tdSql.checkData(16, 0, 0.8714479827243188)
        tdSql.checkData(17, 0, -6.799711455220379)
        tdSql.checkData(18, 0, -0.45231565944180985)
        tdSql.checkData(19, 0, 0.0)
        tdSql.checkData(20, 0, 1.5574077246549023)
        tdSql.checkData(21, 0, -2.185039863261519)
        tdSql.checkData(22, 0, -0.1425465430742778)
        tdSql.checkData(23, 0, 1.1578212823495775)
        tdSql.checkData(24, 0, -3.380515006246586)
        tdSql.checkData(25, 0, -0.29100619138474915)
        tdSql.checkData(26, 0, 0.8714479827243188)
        tdSql.checkData(27, 0, -6.799711455220379)
        tdSql.checkData(28, 0, -0.45231565944180985)
        tdSql.checkData(29, 0, 0.0)

        tdSql.query("select tan(min(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        tdSql.query("select tan(max(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, -0.45231565944180985)

        tdSql.query("select tan(count(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, -6.405331196646276)

        tdSql.query("select tan(sum(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, -0.08871575677006045)

        tdSql.query("select tan(avg(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 4.637332054551185)

        tdSql.query("select tan(percentile(c2, 10)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.260158217550339)

        tdSql.query("select tan(apercentile(c2, 10)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        tdSql.query("select tan(stddev(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, -0.27601685866292947)

        tdSql.query("select tan(spread(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, -0.45231565944180985)

        tdSql.query("select tan(twa(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 13.40557155176672)

        tdSql.query("select tan(interp(c2)) from tba1 every(1s)")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, datetime.datetime(2021, 11, 11, 9, 0))
        tdSql.checkData(0, 1, 1.5574077246549023)
        tdSql.checkData(1, 0, datetime.datetime(2021, 11, 11, 9, 0, 1))
        tdSql.checkData(1, 1, -2.185039863261519)
        tdSql.checkData(2, 0, datetime.datetime(2021, 11, 11, 9, 0, 2))
        tdSql.checkData(2, 1, -0.1425465430742778)
        tdSql.checkData(3, 0, datetime.datetime(2021, 11, 11, 9, 0, 3))
        tdSql.checkData(3, 1, 1.1578212823495775)
        tdSql.checkData(4, 0, datetime.datetime(2021, 11, 11, 9, 0, 4))
        tdSql.checkData(4, 1, -3.380515006246586)
        tdSql.checkData(5, 0, datetime.datetime(2021, 11, 11, 9, 0, 5))
        tdSql.checkData(5, 1, -0.29100619138474915)
        tdSql.checkData(6, 0, datetime.datetime(2021, 11, 11, 9, 0, 6))
        tdSql.checkData(6, 1, 0.8714479827243188)
        tdSql.checkData(7, 0, datetime.datetime(2021, 11, 11, 9, 0, 7))
        tdSql.checkData(7, 1, -6.799711455220379)
        tdSql.checkData(8, 0, datetime.datetime(2021, 11, 11, 9, 0, 8))
        tdSql.checkData(8, 1, -0.45231565944180985)
        tdSql.checkData(9, 0, datetime.datetime(2021, 11, 11, 9, 0, 9))
        tdSql.checkData(9, 1, 0.0)
        tdSql.checkData(10, 0, datetime.datetime(2021, 11, 11, 9, 0, 10))
        tdSql.checkData(10, 1, 1.5574077246549023)
        tdSql.checkData(11, 0, datetime.datetime(2021, 11, 11, 9, 0, 11))
        tdSql.checkData(11, 1, -2.185039863261519)
        tdSql.checkData(12, 0, datetime.datetime(2021, 11, 11, 9, 0, 12))
        tdSql.checkData(12, 1, -0.1425465430742778)
        tdSql.checkData(13, 0, datetime.datetime(2021, 11, 11, 9, 0, 13))
        tdSql.checkData(13, 1, 1.1578212823495775)
        tdSql.checkData(14, 0, datetime.datetime(2021, 11, 11, 9, 0, 14))
        tdSql.checkData(14, 1, -3.380515006246586)
        tdSql.checkData(15, 0, datetime.datetime(2021, 11, 11, 9, 0, 15))
        tdSql.checkData(15, 1, -0.29100619138474915)
        tdSql.checkData(16, 0, datetime.datetime(2021, 11, 11, 9, 0, 16))
        tdSql.checkData(16, 1, 0.8714479827243188)
        tdSql.checkData(17, 0, datetime.datetime(2021, 11, 11, 9, 0, 17))
        tdSql.checkData(17, 1, -6.799711455220379)
        tdSql.checkData(18, 0, datetime.datetime(2021, 11, 11, 9, 0, 18))
        tdSql.checkData(18, 1, -0.45231565944180985)
        tdSql.checkData(19, 0, datetime.datetime(2021, 11, 11, 9, 0, 19))
        tdSql.checkData(19, 1, 0.0)
        tdSql.checkData(20, 0, datetime.datetime(2021, 11, 11, 9, 0, 20))
        tdSql.checkData(20, 1, 1.5574077246549023)
        tdSql.checkData(21, 0, datetime.datetime(2021, 11, 11, 9, 0, 21))
        tdSql.checkData(21, 1, -2.185039863261519)
        tdSql.checkData(22, 0, datetime.datetime(2021, 11, 11, 9, 0, 22))
        tdSql.checkData(22, 1, -0.1425465430742778)
        tdSql.checkData(23, 0, datetime.datetime(2021, 11, 11, 9, 0, 23))
        tdSql.checkData(23, 1, 1.1578212823495775)
        tdSql.checkData(24, 0, datetime.datetime(2021, 11, 11, 9, 0, 24))
        tdSql.checkData(24, 1, -3.380515006246586)
        tdSql.checkData(25, 0, datetime.datetime(2021, 11, 11, 9, 0, 25))
        tdSql.checkData(25, 1, -0.29100619138474915)
        tdSql.checkData(26, 0, datetime.datetime(2021, 11, 11, 9, 0, 26))
        tdSql.checkData(26, 1, 0.8714479827243188)
        tdSql.checkData(27, 0, datetime.datetime(2021, 11, 11, 9, 0, 27))
        tdSql.checkData(27, 1, -6.799711455220379)
        tdSql.checkData(28, 0, datetime.datetime(2021, 11, 11, 9, 0, 28))
        tdSql.checkData(28, 1, -0.45231565944180985)
        tdSql.checkData(29, 0, datetime.datetime(2021, 11, 11, 9, 0, 29))
        tdSql.checkData(29, 1, 0.0)

        tdSql.query("select tan(interp(c2)) from stba every(1s) group by tbname;")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, datetime.datetime(2021, 11, 11, 9, 0))
        tdSql.checkData(0, 1, 1.5574077246549023)
        tdSql.checkData(0, 2, "tba1")
        tdSql.checkData(1, 0, datetime.datetime(2021, 11, 11, 9, 0, 1))
        tdSql.checkData(1, 1, -2.185039863261519)
        tdSql.checkData(1, 2, "tba1")
        tdSql.checkData(2, 0, datetime.datetime(2021, 11, 11, 9, 0, 2))
        tdSql.checkData(2, 1, -0.1425465430742778)
        tdSql.checkData(2, 2, "tba1")
        tdSql.checkData(3, 0, datetime.datetime(2021, 11, 11, 9, 0, 3))
        tdSql.checkData(3, 1, 1.1578212823495775)
        tdSql.checkData(3, 2, "tba1")
        tdSql.checkData(4, 0, datetime.datetime(2021, 11, 11, 9, 0, 4))
        tdSql.checkData(4, 1, -3.380515006246586)
        tdSql.checkData(4, 2, "tba1")
        tdSql.checkData(5, 0, datetime.datetime(2021, 11, 11, 9, 0, 5))
        tdSql.checkData(5, 1, -0.29100619138474915)
        tdSql.checkData(5, 2, "tba1")
        tdSql.checkData(6, 0, datetime.datetime(2021, 11, 11, 9, 0, 6))
        tdSql.checkData(6, 1, 0.8714479827243188)
        tdSql.checkData(6, 2, "tba1")
        tdSql.checkData(7, 0, datetime.datetime(2021, 11, 11, 9, 0, 7))
        tdSql.checkData(7, 1, -6.799711455220379)
        tdSql.checkData(7, 2, "tba1")
        tdSql.checkData(8, 0, datetime.datetime(2021, 11, 11, 9, 0, 8))
        tdSql.checkData(8, 1, -0.45231565944180985)
        tdSql.checkData(8, 2, "tba1")
        tdSql.checkData(9, 0, datetime.datetime(2021, 11, 11, 9, 0, 9))
        tdSql.checkData(9, 1, 0.0)
        tdSql.checkData(9, 2, "tba1")
        tdSql.checkData(10, 0, datetime.datetime(2021, 11, 11, 9, 0, 10))
        tdSql.checkData(10, 1, 1.5574077246549023)
        tdSql.checkData(10, 2, "tba1")
        tdSql.checkData(11, 0, datetime.datetime(2021, 11, 11, 9, 0, 11))
        tdSql.checkData(11, 1, -2.185039863261519)
        tdSql.checkData(11, 2, "tba1")
        tdSql.checkData(12, 0, datetime.datetime(2021, 11, 11, 9, 0, 12))
        tdSql.checkData(12, 1, -0.1425465430742778)
        tdSql.checkData(12, 2, "tba1")
        tdSql.checkData(13, 0, datetime.datetime(2021, 11, 11, 9, 0, 13))
        tdSql.checkData(13, 1, 1.1578212823495775)
        tdSql.checkData(13, 2, "tba1")
        tdSql.checkData(14, 0, datetime.datetime(2021, 11, 11, 9, 0, 14))
        tdSql.checkData(14, 1, -3.380515006246586)
        tdSql.checkData(14, 2, "tba1")
        tdSql.checkData(15, 0, datetime.datetime(2021, 11, 11, 9, 0, 15))
        tdSql.checkData(15, 1, -0.29100619138474915)
        tdSql.checkData(15, 2, "tba1")
        tdSql.checkData(16, 0, datetime.datetime(2021, 11, 11, 9, 0, 16))
        tdSql.checkData(16, 1, 0.8714479827243188)
        tdSql.checkData(16, 2, "tba1")
        tdSql.checkData(17, 0, datetime.datetime(2021, 11, 11, 9, 0, 17))
        tdSql.checkData(17, 1, -6.799711455220379)
        tdSql.checkData(17, 2, "tba1")
        tdSql.checkData(18, 0, datetime.datetime(2021, 11, 11, 9, 0, 18))
        tdSql.checkData(18, 1, -0.45231565944180985)
        tdSql.checkData(18, 2, "tba1")
        tdSql.checkData(19, 0, datetime.datetime(2021, 11, 11, 9, 0, 19))
        tdSql.checkData(19, 1, 0.0)
        tdSql.checkData(19, 2, "tba1")
        tdSql.checkData(20, 0, datetime.datetime(2021, 11, 11, 9, 0, 20))
        tdSql.checkData(20, 1, 1.5574077246549023)
        tdSql.checkData(20, 2, "tba1")
        tdSql.checkData(21, 0, datetime.datetime(2021, 11, 11, 9, 0, 21))
        tdSql.checkData(21, 1, -2.185039863261519)
        tdSql.checkData(21, 2, "tba1")
        tdSql.checkData(22, 0, datetime.datetime(2021, 11, 11, 9, 0, 22))
        tdSql.checkData(22, 1, -0.1425465430742778)
        tdSql.checkData(22, 2, "tba1")
        tdSql.checkData(23, 0, datetime.datetime(2021, 11, 11, 9, 0, 23))
        tdSql.checkData(23, 1, 1.1578212823495775)
        tdSql.checkData(23, 2, "tba1")
        tdSql.checkData(24, 0, datetime.datetime(2021, 11, 11, 9, 0, 24))
        tdSql.checkData(24, 1, -3.380515006246586)
        tdSql.checkData(24, 2, "tba1")
        tdSql.checkData(25, 0, datetime.datetime(2021, 11, 11, 9, 0, 25))
        tdSql.checkData(25, 1, -0.29100619138474915)
        tdSql.checkData(25, 2, "tba1")
        tdSql.checkData(26, 0, datetime.datetime(2021, 11, 11, 9, 0, 26))
        tdSql.checkData(26, 1, 0.8714479827243188)
        tdSql.checkData(26, 2, "tba1")
        tdSql.checkData(27, 0, datetime.datetime(2021, 11, 11, 9, 0, 27))
        tdSql.checkData(27, 1, -6.799711455220379)
        tdSql.checkData(27, 2, "tba1")
        tdSql.checkData(28, 0, datetime.datetime(2021, 11, 11, 9, 0, 28))
        tdSql.checkData(28, 1, -0.45231565944180985)
        tdSql.checkData(28, 2, "tba1")
        tdSql.checkData(29, 0, datetime.datetime(2021, 11, 11, 9, 0, 29))
        tdSql.checkData(29, 1, 0.0)
        tdSql.checkData(29, 2, "tba1")

        tdSql.query("select tan(elapsed(ts)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, -0.04180962355791556)

        tdSql.query("select tan(rate(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.2512726598331747)

        tdSql.query("select tan(irate(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        tdSql.query("select tan(first(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 1.5574077246549023)

        tdSql.query("select tan(last(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        tdSql.query("select tan(last_row(c2)) from tba1;")
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0.0)

        # ===========  end   math_tan2  ==========

        # ===========  begin math_pow  ==========
        tdSql.query("select pow(c2,13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 8192.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 67108864.0)
        tdSql.checkData(5, 0, 2.235879388560037e27)
        tdSql.checkData(6, 0, -2.235879388560037e27)

        tdSql.query("select pow(c2,c2) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 4.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, 1.5243074119957227e267)
        tdSql.checkData(6, 0, -6.560356474884124e-268)

        tdSql.query("select pow(c2,c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, -0.0)

        tdSql.query("select pow(c2,c4) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 4.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, -0.0)

        tdSql.query("select pow(c2,c5) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select pow(c2,c6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 4.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select pow(c2,c7) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select pow(c2,c10) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 4.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select pow(c2,c11) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select pow(c2,c12) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 4.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select pow(c2,c13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select pow(c2,c2 + c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 65536.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select pow(c2,(c2 + c3)) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 65536.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select pow(c2,(c2 * c3)+c4-6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 268435456.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select pow(c2,11)+c2 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 2.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2050.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4194308.0)
        tdSql.checkData(5, 0, 1.3862479934032099e23)
        tdSql.checkData(6, 0, -1.3862479934032099e23)

        tdSql.query("select pow(c2,c2)+11 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 12.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 15.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 267.0)
        tdSql.checkData(5, 0, 1.5243074119957227e267)
        tdSql.checkData(6, 0, 11.0)

        tdSql.query(
            "select pow(c2,c2+c3) from tb1 where c2 is not null and c3 is not null;"
        )
        tdSql.checkRows(4)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, 65536.0)
        tdSql.checkData(2, 0, inf)
        tdSql.checkData(3, 0, 0.0)

        tdSql.query("select pow(c2,c2) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, -6.560356474884124e-268)
        tdSql.checkData(1, 0, 1.5243074119957227e267)
        tdSql.checkData(2, 0, 256.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4.0)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select pow(c2,c2+c3) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, inf)
        tdSql.checkData(2, 0, 65536.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, None)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 1.0)

        tdSql.query("select pow(c2,c2+c3) from tb1 order by ts desc limit 3 offset 2;")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 65536.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)

        tdSql.query("select pow(c2,c2) from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 4.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, 1.5243074119957227e267)
        tdSql.checkData(6, 0, -6.560356474884124e-268)
        tdSql.checkData(7, 0, 1.0)
        tdSql.checkData(8, 0, 4.0)
        tdSql.checkData(9, 0, 27.0)
        tdSql.checkData(10, 0, 256.0)
        tdSql.checkData(11, 0, 3125.0)
        tdSql.checkData(12, 0, 46656.0)
        tdSql.checkData(13, 0, 823543.0)

        tdSql.query("select pow(c2,c2) from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select pow(c2,c4),t1 from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select pow(c2,c3),tbname from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(0, 1, "tb1")
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, "tb1")
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, "tb1")
        tdSql.checkData(3, 0, None)
        tdSql.checkData(3, 1, "tb1")
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(4, 1, "tb1")
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(5, 1, "tb1")
        tdSql.checkData(6, 0, -0.0)
        tdSql.checkData(6, 1, "tb1")
        tdSql.checkData(7, 0, 1.0)
        tdSql.checkData(7, 1, "tb2")
        tdSql.checkData(8, 0, 4.0)
        tdSql.checkData(8, 1, "tb2")
        tdSql.checkData(9, 0, 27.0)
        tdSql.checkData(9, 1, "tb2")
        tdSql.checkData(10, 0, 256.0)
        tdSql.checkData(10, 1, "tb2")
        tdSql.checkData(11, 0, 3125.0)
        tdSql.checkData(11, 1, "tb2")
        tdSql.checkData(12, 0, 46656.0)
        tdSql.checkData(12, 1, "tb2")
        tdSql.checkData(13, 0, 823543.0)
        tdSql.checkData(13, 1, "tb2")

        tdSql.query("select pow(c2,c3),tbname from stb1 where t1 > 1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(0, 1, "tb2")
        tdSql.checkData(1, 0, 4.0)
        tdSql.checkData(1, 1, "tb2")
        tdSql.checkData(2, 0, 27.0)
        tdSql.checkData(2, 1, "tb2")
        tdSql.checkData(3, 0, 256.0)
        tdSql.checkData(3, 1, "tb2")
        tdSql.checkData(4, 0, 3125.0)
        tdSql.checkData(4, 1, "tb2")
        tdSql.checkData(5, 0, 46656.0)
        tdSql.checkData(5, 1, "tb2")
        tdSql.checkData(6, 0, 823543.0)
        tdSql.checkData(6, 1, "tb2")

        tdSql.query("select pow(c2,c2) from (select * from stb1);")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 4.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, 1.5243074119957227e267)
        tdSql.checkData(6, 0, -6.560356474884124e-268)
        tdSql.checkData(7, 0, 1.0)
        tdSql.checkData(8, 0, 4.0)
        tdSql.checkData(9, 0, 27.0)
        tdSql.checkData(10, 0, 256.0)
        tdSql.checkData(11, 0, 3125.0)
        tdSql.checkData(12, 0, 46656.0)
        tdSql.checkData(13, 0, 823543.0)

        tdSql.query("select pow(c2,c3) from tb1 union all select pow(c2,c3) from tb2;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, -0.0)
        tdSql.checkData(7, 0, 1.0)
        tdSql.checkData(8, 0, 4.0)
        tdSql.checkData(9, 0, 27.0)
        tdSql.checkData(10, 0, 256.0)
        tdSql.checkData(11, 0, 3125.0)
        tdSql.checkData(12, 0, 46656.0)
        tdSql.checkData(13, 0, 823543.0)

        # ===========  end   math_pow  ==========

        # ===========  begin math_pow2  ==========
        tdSql.query(
            "select pow(c2,c4) as a from stb1 union all select pow(c2,c5) as a from stba;"
        )
        tdSql.checkRows(44)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 4.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 256.0)
        tdSql.checkData(5, 0, inf)
        tdSql.checkData(6, 0, -0.0)
        tdSql.checkData(7, 0, 1.0)
        tdSql.checkData(8, 0, 4.0)
        tdSql.checkData(9, 0, 9.0)
        tdSql.checkData(10, 0, 256.0)
        tdSql.checkData(11, 0, 3125.0)
        tdSql.checkData(12, 0, 46656.0)
        tdSql.checkData(13, 0, 823543.0)
        tdSql.checkData(14, 0, 1.0)
        tdSql.checkData(15, 0, 4.0)
        tdSql.checkData(16, 0, 27.0)
        tdSql.checkData(17, 0, 256.0)
        tdSql.checkData(18, 0, 3125.0)
        tdSql.checkData(19, 0, 46656.0)
        tdSql.checkData(20, 0, 823543.0)
        tdSql.checkData(21, 0, 16777216.0)
        tdSql.checkData(22, 0, 387420489.0)
        tdSql.checkData(23, 0, 1.0)
        tdSql.checkData(24, 0, 1.0)
        tdSql.checkData(25, 0, 4.0)
        tdSql.checkData(26, 0, 27.0)
        tdSql.checkData(27, 0, 256.0)
        tdSql.checkData(28, 0, 3125.0)
        tdSql.checkData(29, 0, 46656.0)
        tdSql.checkData(30, 0, 823543.0)
        tdSql.checkData(31, 0, 16777216.0)
        tdSql.checkData(32, 0, 387420489.0)
        tdSql.checkData(33, 0, 1.0)
        tdSql.checkData(34, 0, 1.0)
        tdSql.checkData(35, 0, 4.0)
        tdSql.checkData(36, 0, 27.0)
        tdSql.checkData(37, 0, 256.0)
        tdSql.checkData(38, 0, 3125.0)
        tdSql.checkData(39, 0, 46656.0)
        tdSql.checkData(40, 0, 823543.0)
        tdSql.checkData(41, 0, 16777216.0)
        tdSql.checkData(42, 0, 387420489.0)
        tdSql.checkData(43, 0, 1.0)

        tdSql.query("select pow(c2,c2) from stba;")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, 4.0)
        tdSql.checkData(2, 0, 27.0)
        tdSql.checkData(3, 0, 256.0)
        tdSql.checkData(4, 0, 3125.0)
        tdSql.checkData(5, 0, 46656.0)
        tdSql.checkData(6, 0, 823543.0)
        tdSql.checkData(7, 0, 16777216.0)
        tdSql.checkData(8, 0, 387420489.0)
        tdSql.checkData(9, 0, 1.0)
        tdSql.checkData(10, 0, 1.0)
        tdSql.checkData(11, 0, 4.0)
        tdSql.checkData(12, 0, 27.0)
        tdSql.checkData(13, 0, 256.0)
        tdSql.checkData(14, 0, 3125.0)
        tdSql.checkData(15, 0, 46656.0)
        tdSql.checkData(16, 0, 823543.0)
        tdSql.checkData(17, 0, 16777216.0)
        tdSql.checkData(18, 0, 387420489.0)
        tdSql.checkData(19, 0, 1.0)
        tdSql.checkData(20, 0, 1.0)
        tdSql.checkData(21, 0, 4.0)
        tdSql.checkData(22, 0, 27.0)
        tdSql.checkData(23, 0, 256.0)
        tdSql.checkData(24, 0, 3125.0)
        tdSql.checkData(25, 0, 46656.0)
        tdSql.checkData(26, 0, 823543.0)
        tdSql.checkData(27, 0, 16777216.0)
        tdSql.checkData(28, 0, 387420489.0)
        tdSql.checkData(29, 0, 1.0)

        # ===========  end   math_pow2  ==========

        # ===========  begin math_log  ==========
        tdSql.query("select log(c2,13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 0.27023815442731974)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.5404763088546395)
        tdSql.checkData(5, 0, 1.8886092516277813)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c2) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 1.0)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.465913680008469)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c4) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.22544144151366513)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c5) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.11093150296463757)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.05459909915208762)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c7) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.006824887406193638)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c10) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.8748229478056855)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c11) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.4367939948774267)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c12) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.2183963964662152)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c13) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.11093150296463757)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c2 + c3) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.6666666666666667)
        tdSql.checkData(5, 0, 0.4657403972991969)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,(c2 + c3)) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.6666666666666667)
        tdSql.checkData(5, 0, 0.4657403972991969)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,(c2 * c3)+c4-6) from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 0.5252990700743871)
        tdSql.checkData(5, 0, 0.22542113212116985)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,11)+c2 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, 1.0)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 2.2890648263178877)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 4.578129652635775)
        tdSql.checkData(5, 0, 129.02018292517226)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c2)+11 from tb1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 12.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 12.0)
        tdSql.checkData(5, 0, 12.0)
        tdSql.checkData(6, 0, nan)

        tdSql.query(
            "select log(c2,c2+c3) from tb1 where c2 is not null and c3 is not null;"
        )
        tdSql.checkRows(4)
        tdSql.checkData(0, 0, 0.0)
        tdSql.checkData(1, 0, 0.6666666666666667)
        tdSql.checkData(2, 0, 0.4657403972991969)
        tdSql.checkData(3, 0, nan)

        tdSql.query("select log(c2,c2) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, 1.0)
        tdSql.checkData(2, 0, 1.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, nan)

        tdSql.query("select log(c2,c2+c3) from tb1 order by ts desc;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, 0.4657403972991969)
        tdSql.checkData(2, 0, 0.6666666666666667)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, None)
        tdSql.checkData(5, 0, None)
        tdSql.checkData(6, 0, 0.0)

        tdSql.query("select log(c2,c2+c3) from tb1 order by ts desc limit 3 offset 2;")
        tdSql.checkRows(3)
        tdSql.checkData(0, 0, 0.6666666666666667)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)

        tdSql.query("select log(c2,c2) from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 1.0)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, 1.0)
        tdSql.checkData(9, 0, 1.0)
        tdSql.checkData(10, 0, 1.0)
        tdSql.checkData(11, 0, 1.0)
        tdSql.checkData(12, 0, 1.0)
        tdSql.checkData(13, 0, 1.0)

        tdSql.query("select log(c2,c2) from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select log(c2,c4),t1 from stb1 order by ts desc;")
        tdSql.checkRows(14)
        tdSql.query("select log(c2,c3),tbname from stb1;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(0, 1, "tb1")
        tdSql.checkData(1, 0, None)
        tdSql.checkData(1, 1, "tb1")
        tdSql.checkData(2, 0, None)
        tdSql.checkData(2, 1, "tb1")
        tdSql.checkData(3, 0, None)
        tdSql.checkData(3, 1, "tb1")
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(4, 1, "tb1")
        tdSql.checkData(5, 0, 0.465913680008469)
        tdSql.checkData(5, 1, "tb1")
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(6, 1, "tb1")
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(7, 1, "tb2")
        tdSql.checkData(8, 0, 1.0)
        tdSql.checkData(8, 1, "tb2")
        tdSql.checkData(9, 0, 1.0)
        tdSql.checkData(9, 1, "tb2")
        tdSql.checkData(10, 0, 1.0)
        tdSql.checkData(10, 1, "tb2")
        tdSql.checkData(11, 0, 1.0)
        tdSql.checkData(11, 1, "tb2")
        tdSql.checkData(12, 0, 1.0)
        tdSql.checkData(12, 1, "tb2")
        tdSql.checkData(13, 0, 1.0)
        tdSql.checkData(13, 1, "tb2")

        tdSql.query("select log(c2,c3),tbname from stb1 where t1 > 1;")
        tdSql.checkRows(7)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(0, 1, "tb2")
        tdSql.checkData(1, 0, 1.0)
        tdSql.checkData(1, 1, "tb2")
        tdSql.checkData(2, 0, 1.0)
        tdSql.checkData(2, 1, "tb2")
        tdSql.checkData(3, 0, 1.0)
        tdSql.checkData(3, 1, "tb2")
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(4, 1, "tb2")
        tdSql.checkData(5, 0, 1.0)
        tdSql.checkData(5, 1, "tb2")
        tdSql.checkData(6, 0, 1.0)
        tdSql.checkData(6, 1, "tb2")

        tdSql.query("select log(c2,c2) from (select * from stb1);")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 1.0)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, 1.0)
        tdSql.checkData(9, 0, 1.0)
        tdSql.checkData(10, 0, 1.0)
        tdSql.checkData(11, 0, 1.0)
        tdSql.checkData(12, 0, 1.0)
        tdSql.checkData(13, 0, 1.0)

        tdSql.query("select log(c2,c3) from tb1 union all select log(c2,c3) from tb2;")
        tdSql.checkRows(14)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, None)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.465913680008469)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, 1.0)
        tdSql.checkData(9, 0, 1.0)
        tdSql.checkData(10, 0, 1.0)
        tdSql.checkData(11, 0, 1.0)
        tdSql.checkData(12, 0, 1.0)
        tdSql.checkData(13, 0, 1.0)

        # ===========  end   math_log  ==========

        # ===========  begin math_log2  ==========
        tdSql.query(
            "select log(c2,c4) as a from stb1 union all select log(c2,c5) as a from stba;"
        )
        tdSql.checkRows(44)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, None)
        tdSql.checkData(2, 0, 1.0)
        tdSql.checkData(3, 0, None)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 0.22544144151366513)
        tdSql.checkData(6, 0, nan)
        tdSql.checkData(7, 0, nan)
        tdSql.checkData(8, 0, 1.0)
        tdSql.checkData(9, 0, 1.5849625007211563)
        tdSql.checkData(10, 0, 1.0)
        tdSql.checkData(11, 0, 1.0)
        tdSql.checkData(12, 0, 1.0)
        tdSql.checkData(13, 0, 1.0)
        tdSql.checkData(14, 0, nan)
        tdSql.checkData(15, 0, 1.0)
        tdSql.checkData(16, 0, 1.0)
        tdSql.checkData(17, 0, 1.0)
        tdSql.checkData(18, 0, 1.0)
        tdSql.checkData(19, 0, 1.0)
        tdSql.checkData(20, 0, 1.0)
        tdSql.checkData(21, 0, 1.0)
        tdSql.checkData(22, 0, 1.0)
        tdSql.checkData(23, 0, nan)
        tdSql.checkData(24, 0, nan)
        tdSql.checkData(25, 0, 1.0)
        tdSql.checkData(26, 0, 1.0)
        tdSql.checkData(27, 0, 1.0)
        tdSql.checkData(28, 0, 1.0)
        tdSql.checkData(29, 0, 1.0)
        tdSql.checkData(30, 0, 1.0)
        tdSql.checkData(31, 0, 1.0)
        tdSql.checkData(32, 0, 1.0)
        tdSql.checkData(33, 0, nan)
        tdSql.checkData(34, 0, nan)
        tdSql.checkData(35, 0, 1.0)
        tdSql.checkData(36, 0, 1.0)
        tdSql.checkData(37, 0, 1.0)
        tdSql.checkData(38, 0, 1.0)
        tdSql.checkData(39, 0, 1.0)
        tdSql.checkData(40, 0, 1.0)
        tdSql.checkData(41, 0, 1.0)
        tdSql.checkData(42, 0, 1.0)
        tdSql.checkData(43, 0, nan)

        tdSql.query("select log(c2,c2) from stba;")
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, nan)
        tdSql.checkData(1, 0, 1.0)
        tdSql.checkData(2, 0, 1.0)
        tdSql.checkData(3, 0, 1.0)
        tdSql.checkData(4, 0, 1.0)
        tdSql.checkData(5, 0, 1.0)
        tdSql.checkData(6, 0, 1.0)
        tdSql.checkData(7, 0, 1.0)
        tdSql.checkData(8, 0, 1.0)
        tdSql.checkData(9, 0, nan)
        tdSql.checkData(10, 0, nan)
        tdSql.checkData(11, 0, 1.0)
        tdSql.checkData(12, 0, 1.0)
        tdSql.checkData(13, 0, 1.0)
        tdSql.checkData(14, 0, 1.0)
        tdSql.checkData(15, 0, 1.0)
        tdSql.checkData(16, 0, 1.0)
        tdSql.checkData(17, 0, 1.0)
        tdSql.checkData(18, 0, 1.0)
        tdSql.checkData(19, 0, nan)
        tdSql.checkData(20, 0, nan)
        tdSql.checkData(21, 0, 1.0)
        tdSql.checkData(22, 0, 1.0)
        tdSql.checkData(23, 0, 1.0)
        tdSql.checkData(24, 0, 1.0)
        tdSql.checkData(25, 0, 1.0)
        tdSql.checkData(26, 0, 1.0)
        tdSql.checkData(27, 0, 1.0)
        tdSql.checkData(28, 0, 1.0)
        tdSql.checkData(29, 0, nan)

        # ===========  end   math_log2  ==========

        tdSql.execute("drop database math_funcs")

    def stop(self):
        tdSql.close()
        tdLog.success("%s successfully executed" % __file__)


tdCases.addWindows(__file__, TDTestCase())
tdCases.addLinux(__file__, TDTestCase())
