/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/
#line 11 "sql.y"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
#line 46 "sql.c"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 482
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SNodeList* yy72;
  SNode* yy164;
  EJoinType yy196;
  bool yy441;
  EFillMode yy446;
  SToken yy497;
  ENullOrder yy517;
  EOrder yy550;
  int32_t yy560;
  int8_t yy563;
  int64_t yy693;
  SDataType yy700;
  SAlterOption yy761;
  EOperatorType yy796;
  STokenPair yy953;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             787
#define YYNRULE              591
#define YYNRULE_WITH_ACTION  591
#define YYNTOKEN             335
#define YY_MAX_SHIFT         786
#define YY_MIN_SHIFTREDUCE   1162
#define YY_MAX_SHIFTREDUCE   1752
#define YY_ERROR_ACTION      1753
#define YY_ACCEPT_ACTION     1754
#define YY_NO_ACTION         1755
#define YY_MIN_REDUCE        1756
#define YY_MAX_REDUCE        2346
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2980)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  2158,  402,  680, 1930,   38,  303,  182, 2091,  643,  162,
 /*    10 */   694, 2317,   48,   46, 1680, 1757,  380, 1932, 1969,  216,
 /*    20 */   399,  133, 1529,  529, 1980, 1799,  642,  186,  564,  655,
 /*    30 */   140, 2318,  644, 1610, 1829, 1527,  123, 2176,  107,  122,
 /*    40 */   121,  120,  119,  118,  117,  116,  115,  114, 1555, 2126,
 /*    50 */  1907,  696,   41,   40,  251,  141,   47,   45,   44,   43,
 /*    60 */    42, 1605,  531, 1922, 1557,   41,   40,   19,  528,   47,
 /*    70 */    45,   44,   43,   42, 1535, 1905, 1554,   47,   45,   44,
 /*    80 */    43,   42,  142, 2157,  526, 2217, 2193,  527, 1792,  339,
 /*    90 */  2159,  700, 2161, 2162,  695,  693,  690,  681, 2211,  783,
 /*   100 */   167,   30,   15,  760,  759,  758,  757,  411, 1871,  756,
 /*   110 */   755,  144,  750,  749,  748,  747,  746,  745,  744,  157,
 /*   120 */   740,  739,  738,  410,  409,  735,  734,  733,  175,  174,
 /*   130 */   657,  184, 2254, 2255, 1350,  138, 2259,  123, 1612, 1613,
 /*   140 */   122,  121,  120,  119,  118,  117,  116,  115,  114, 1341,
 /*   150 */   722,  721,  720, 1345,  719, 1347, 1348,  718,  715,  679,
 /*   160 */  1356,  712, 1358, 1359,  709,  706, 1384, 1385, 1585, 1595,
 /*   170 */   680, 1930,   41,   40, 1611, 1614,   47,   45,   44,   43,
 /*   180 */    42,  730,  155,  154,  727,  726,  725,  152, 1530,  133,
 /*   190 */  1528,   62,  666,  408,  407,  568,  569,   41,   40,  567,
 /*   200 */   661,   47,   45,   44,   43,   42,  730,  155,  154,  727,
 /*   210 */   726,  725,  152,  665,  262,  534, 1536, 1554,  527, 1792,
 /*   220 */  1533, 1534,  543, 1584, 1587, 1588, 1589, 1590, 1591, 1592,
 /*   230 */  1593, 1594,  692,  688, 1603, 1604, 1606, 1607, 1608, 1609,
 /*   240 */     2,   48,   46,  541, 2158, 2041,  349,  618, 1552,  399,
 /*   250 */  2317, 1529,   14,   13,  658,  482,  358, 2048,  496,  638,
 /*   260 */   679,  495, 1610,   52, 1527, 2323,  186,  582,  581,  580,
 /*   270 */  2318,  644, 2046,  667,  572,  137,  576,  465, 2136,  497,
 /*   280 */   575, 2176,  234,  467, 1195,  574,  579,  374,  373, 1756,
 /*   290 */  1605,  573, 1921, 2126, 1982,  696,   19, 1982,  172, 1677,
 /*   300 */  1639,  379, 2140, 1535,  389,  560,  556,  552,  548, 1980,
 /*   310 */   231,  179, 1980,  132,  131,  130,  129,  128,  127,  126,
 /*   320 */   125,  124,  168, 1197, 1768, 1200, 1201, 2157,  783,  367,
 /*   330 */  2193,   15, 2032,  110, 2159,  700, 2161, 2162,  695, 2142,
 /*   340 */   690,  455,   51, 2261, 1749,  183,  189, 2246, 1982,  690,
 /*   350 */    88,  395, 2242,  229, 1653,  394, 1640,  404,  445,  732,
 /*   360 */  1975, 1977,  444, 1980,  188, 1439, 1440, 1612, 1613, 2258,
 /*   370 */   493, 1539, 2272,  487,  486,  485,  484,  481,  480,  479,
 /*   380 */   478,  477,  473,  472,  471,  470,  348,  462,  461,  460,
 /*   390 */   218,  457,  456,  365,  529,  679, 1799, 1585, 1595, 2012,
 /*   400 */  1555,  655,  140, 1611, 1614,  618,   41,   40, 2317, 2322,
 /*   410 */    47,   45,   44,   43,   42, 1982,  371, 1530,  189, 1528,
 /*   420 */   228,  222,  364, 2323,  186,  227, 1556,  539, 2318,  644,
 /*   430 */  1980, 1754, 2048,   37,  397, 1634, 1635, 1636, 1637, 1638,
 /*   440 */  1642, 1643, 1644, 1645,  392,  220, 1748, 2045,  667, 1533,
 /*   450 */  1534,  637, 1584, 1587, 1588, 1589, 1590, 1591, 1592, 1593,
 /*   460 */  1594,  692,  688, 1603, 1604, 1606, 1607, 1608, 1609,    2,
 /*   470 */    12,   48,   46,   87,   87,  393,  666,   51, 2176,  399,
 /*   480 */   451, 1529, 1779,  165,  372,  666,  370,  369, 2158,  566,
 /*   490 */   368, 1932, 1610,  643, 1527, 1708, 2317,  189,  697, 1925,
 /*   500 */  1926, 1719,  414,  185, 2254, 2255,  413,  138, 2259, 1742,
 /*   510 */   568,  642,  186, 2158,  567, 1982, 2318,  644, 1456, 1457,
 /*   520 */  1605,  680, 1930,  697,  345, 2176,   19,  664,  489, 2041,
 /*   530 */  1981, 2126,  636, 1535,  655,  140,  675, 2126, 2041,  696,
 /*   540 */   191,  633,  630,  629, 1706, 1707, 1709, 1710, 1711,  618,
 /*   550 */  2176, 1778, 2317, 1676, 1455, 1458,  469,   66,  783,  523,
 /*   560 */   101,   15, 2126, 1553,  696,  468,  521, 2323,  186,  517,
 /*   570 */   513, 2157, 2318,  644, 2193, 1832,  284,  169, 2159,  700,
 /*   580 */  2161, 2162,  695,   12,  690, 1923,   41,   40,  207,  206,
 /*   590 */    47,   45,   44,   43,   42,  596, 2157, 1612, 1613, 2193,
 /*   600 */  2126,  605,  110, 2159,  700, 2161, 2162,  695,  594,  690,
 /*   610 */   592,  488,  143, 1684,  150, 2217, 2246,  619, 2283, 1554,
 /*   620 */   395, 2242,  179, 1554,  294,  295, 1529, 1585, 1595,  293,
 /*   630 */   639,  634,  627, 1611, 1614, 2261,  187, 2254, 2255, 1527,
 /*   640 */   138, 2259,  366, 2031,  582,  581,  580, 1530,  165, 1528,
 /*   650 */   249,  572,  137,  576,  248,   62, 1933,  575, 1777,  723,
 /*   660 */  1620, 2257,  574,  579,  374,  373, 1554, 2158,  573,  730,
 /*   670 */   155,  154,  727,  726,  725,  152,  260,  658, 1535, 1533,
 /*   680 */  1534, 1696, 1584, 1587, 1588, 1589, 1590, 1591, 1592, 1593,
 /*   690 */  1594,  692,  688, 1603, 1604, 1606, 1607, 1608, 1609,    2,
 /*   700 */    48,   46, 1615,  783, 2176,   62, 1535, 2126,  399, 1294,
 /*   710 */  1529, 1218,   62, 1217,   90, 2158, 2126,  353,  696,   91,
 /*   720 */   378, 1610,  598, 1527,   34,  697,  233, 1801,  680, 1930,
 /*   730 */    41,   40,  680, 1930,   47,   45,   44,   43,   42,    9,
 /*   740 */   655,  140, 1776, 2261, 1219,  285,  742,   57, 1296, 1605,
 /*   750 */  2157,  449, 2176, 2193,  680, 1930,  110, 2159,  700, 2161,
 /*   760 */  2162,  695, 1535,  690, 2126, 2119,  696, 1586,  183, 2256,
 /*   770 */  2246,   36, 1775,  450,  395, 2242, 1538,   41,   40,  408,
 /*   780 */   407,   47,   45,   44,   43,   42,   62,  783,   93, 1543,
 /*   790 */    49, 2126, 1530, 1906, 1528, 2273,  153,  443, 2157,  442,
 /*   800 */  1610, 2193, 1536, 2158,  110, 2159,  700, 2161, 2162,  695,
 /*   810 */   189,  690,  618,  697, 1586, 2317, 2337,  570, 2246,  680,
 /*   820 */  1930, 2126,  395, 2242, 1533, 1534, 1612, 1613, 1605,  441,
 /*   830 */  2323,  186,  680, 1930, 1919, 2318,  644,  402,  459, 1292,
 /*   840 */  2176, 1535,  282, 2254,  654,  165,  134,  653,   12, 2317,
 /*   850 */    10,  474, 2126, 1932,  696,   56, 1585, 1595, 1774,  732,
 /*   860 */   189, 1773, 1611, 1614,  642,  186,  686,  189, 1982, 2318,
 /*   870 */   644,  680, 1930,  578,  577,  403, 1530, 2136, 1528, 2322,
 /*   880 */  1915, 2322, 2317, 1980, 2317, 1772, 2157,  680, 1930, 2193,
 /*   890 */   475, 2145,  170, 2159,  700, 2161, 2162,  695, 2321,  690,
 /*   900 */  2321, 2140, 2318, 2320, 2318, 2319,  542, 2126, 1533, 1534,
 /*   910 */  2126, 1584, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594,
 /*   920 */   692,  688, 1603, 1604, 1606, 1607, 1608, 1609,    2,   48,
 /*   930 */    46, 1541,  680, 1930, 2126, 2158, 1771,  399, 2142, 1529,
 /*   940 */  1305,  189, 2321,  645, 2338,  697,  405, 2280,  690, 1917,
 /*   950 */  1610, 1927, 1527, 1304,  165, 1544, 1673, 1539, 1770,   41,
 /*   960 */    40, 1767, 1932,   47,   45,   44,   43,   42,  317,   41,
 /*   970 */    40, 1959, 2176,   47,   45,   44,   43,   42, 1605, 1554,
 /*   980 */   680, 1930, 1976, 1977, 2126, 2126,  696, 1547, 1549,  680,
 /*   990 */  1930, 1535,  680, 1930,  680, 1930, 1309, 2109, 2120,  252,
 /*  1000 */   688, 1603, 1604, 1606, 1607, 1608, 1609, 2126,  614, 1308,
 /*  1010 */  2126,  659, 2027,  663, 1556, 1913,  783,  498, 2157,   49,
 /*  1020 */  1218, 2193, 1217, 2158,  110, 2159,  700, 2161, 2162,  695,
 /*  1030 */   250,  690,  587,  697,  724, 2293, 2337, 1973, 2246,  680,
 /*  1040 */  1930,  728,  395, 2242, 1973,  618, 1641,  597, 2317, 1766,
 /*  1050 */   203,  680, 1930, 1219,  433, 1612, 1613,  199,  298, 1765,
 /*  1060 */  2176,  247, 1764, 2323,  186,  680, 1930, 1557, 2318,  644,
 /*  1070 */   677, 1763, 2126,  500,  696,  680, 1930,  590,  680, 1930,
 /*  1080 */  1557,  435,  431,  584,  678, 1585, 1595,  754,  752,  246,
 /*  1090 */    84, 1611, 1614,   83,  304, 1200, 1201,  406, 2126, 1500,
 /*  1100 */  1501,   44,   43,   42, 1203, 1530, 2157, 1528, 2126, 2193,
 /*  1110 */  1553, 2126,  110, 2159,  700, 2161, 2162,  695, 1762,  690,
 /*  1120 */  2126,  164,  603,   35, 2337, 1761, 2246, 1586, 1760,   70,
 /*  1130 */   395, 2242,   69, 1646, 1759, 2266, 1673, 1533, 1534, 2027,
 /*  1140 */  1584, 1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594,  692,
 /*  1150 */   688, 1603, 1604, 1606, 1607, 1608, 1609,    2,   48,   46,
 /*  1160 */  2027, 2158, 2136,  682,  284, 2218,  399, 2126, 1529,  618,
 /*  1170 */  2112,  697, 2317,  625, 2126,  743, 2144, 2126, 1892, 1610,
 /*  1180 */   684, 1527, 2218, 2126,  201,   74, 2140, 2323,  186,  452,
 /*  1190 */   617,  729, 2318,  644, 1973,   54, 1908,    3, 2176,  146,
 /*  1200 */   239,  135,  453,  237, 1816,  205,  241, 1605,  153,  240,
 /*  1210 */  2126,  428,  696,  571, 1808,  243,  646,  200,  242,  421,
 /*  1220 */  1535, 1806,  245, 2142,  396,  244,  583,  600,  153,  599,
 /*  1230 */   261,   50,   50,  690,   82, 1290,  585,  266,  153,  647,
 /*  1240 */   148, 1751, 1752,  588, 2157,  783,   50, 2193,   15,  687,
 /*  1250 */   110, 2159,  700, 2161, 2162,  695,  650,  690, 2147,  291,
 /*  1260 */    71, 1802, 2337, 1537, 2246,  106,  151, 1495,  395, 2242,
 /*  1270 */   153,   14,   13,   64,   50,  103,   50,  736,  737,  704,
 /*  1280 */   151,  153,  136,  151, 1612, 1613, 1934, 1498, 1251,  256,
 /*  1290 */  1705, 1704,  691,  259, 1872, 1769,  268,  662, 2286, 1270,
 /*  1300 */  1268,  279,  631,  166,  232, 1453,  273, 1870,  323, 1869,
 /*  1310 */  2177,  778,   55, 2149, 1585, 1595,  412, 2036,  296,  672,
 /*  1320 */  1611, 1614,  321,   73, 1793,  300,   72, 1252, 1798, 1335,
 /*  1330 */  2276, 1970, 1647, 1596, 1530,  316, 1528,  346, 1362, 1366,
 /*  1340 */  1373, 1371,  156,  656,  278,  281,    1,  214,  508,  506,
 /*  1350 */   503,    5,  415,  420,  362, 2158, 1560,  437,  436,  194,
 /*  1360 */   193,  196,  439, 1476,  204,  697, 1533, 1534,  311, 1584,
 /*  1370 */  1587, 1588, 1589, 1590, 1591, 1592, 1593, 1594,  692,  688,
 /*  1380 */  1603, 1604, 1606, 1607, 1608, 1609,    2,   62, 1557,  454,
 /*  1390 */  2037,  491, 2176,  458,  463, 1552,  476,  483, 2029,  490,
 /*  1400 */   492,  501, 1631,  502, 2126,  499,  696,  504,  209,  211,
 /*  1410 */   208,  505,  507,  509, 1558,  524,  535,    4, 1540,  532,
 /*  1420 */   525,  533,  219, 1555, 2158,  109,  536, 1559,  221,  537,
 /*  1430 */  1561,  538,  540,  224,  697,  544, 2311,  226, 2157,   85,
 /*  1440 */    86, 2193, 1221,  561,  110, 2159,  700, 2161, 2162,  695,
 /*  1450 */   230,  690,  563,  562,  352,  112, 2221, 2100, 2246,  602,
 /*  1460 */   604, 2176,  395, 2242,  565,   81,   80,  448, 1920,   89,
 /*  1470 */   198,  236, 1916, 2126,  648,  696,  149,  238,  312,  158,
 /*  1480 */   159, 1918, 1914,  440,  438,  160, 2158,  253,  161,  608,
 /*  1490 */   607,  257, 1483,  651,  347,  609,  697,  429, 2265,  615,
 /*  1500 */   427,  423,  419,  416,  441, 2097, 2096, 2157, 2277,  612,
 /*  1510 */  2193,  255, 2158,  110, 2159,  700, 2161, 2162,  695, 2287,
 /*  1520 */   690,  632,  697, 2176,  622, 2337, 2292, 2246,  670,  613,
 /*  1530 */   264,  395, 2242, 2291,  628, 2126,  384,  696,  267, 2268,
 /*  1540 */     8,  635,  189,  641,  623,  385,  621,  620,  277, 2176,
 /*  1550 */  2340,  649,  652,  139, 1673, 1556, 2262,  660,  388,  286,
 /*  1560 */   274, 2126, 1562,  696,  313, 2042,   96,  668,  669, 2157,
 /*  1570 */  2056,  314, 2193, 2055,  276,  110, 2159,  700, 2161, 2162,
 /*  1580 */   695,  673,  690,  275, 2054,  272, 2158, 2337,  173, 2246,
 /*  1590 */   391,  674,   61,  395, 2242, 2157,  697,   98, 2193, 2316,
 /*  1600 */   100,  110, 2159,  700, 2161, 2162,  695,  280,  690,  102,
 /*  1610 */  2227,  315,  702, 2219, 1974, 2246, 1893, 1931,  779,  395,
 /*  1620 */  2242,  318,  780, 2176,  782,  327,   53,  341,  307,  331,
 /*  1630 */   320, 2118,  322, 2117,  342, 2126, 2116,  696,   78, 2113,
 /*  1640 */   417,  418, 1520, 1521,  354,  355,  192, 2158, 2111,  422,
 /*  1650 */   424,  425,  426, 2110,  363, 2108,  430,  697,  434,  432,
 /*  1660 */  2106, 1511, 2087,  195, 2086,  197, 1479,   79, 1478, 2157,
 /*  1670 */  2107, 2068, 2193, 2158, 2067,  110, 2159,  700, 2161, 2162,
 /*  1680 */   695, 2066,  690,  697, 2176,  446,  447,  683, 2065, 2246,
 /*  1690 */  2064, 1430, 2020,  395, 2242, 2019, 2126, 2017,  696,  145,
 /*  1700 */  2016, 2015, 2018, 2014, 2013, 2011, 2010, 2009,  202, 2158,
 /*  1710 */  2176,  464, 2008,  466, 2022, 2007, 2006, 2005, 2004,  697,
 /*  1720 */   147, 1992, 2126, 2003,  696, 2002, 2001, 2000, 1999, 1998,
 /*  1730 */  2157, 1997, 1996, 2193, 1995, 1994,  111, 2159,  700, 2161,
 /*  1740 */  2162,  695, 1993,  690, 1991, 1990, 2176, 2021, 1989, 1988,
 /*  1750 */  2246, 1987, 1432, 1986, 2245, 2242, 2157, 1985, 2126, 2193,
 /*  1760 */   696,  494,  111, 2159,  700, 2161, 2162,  695, 1984,  690,
 /*  1770 */  1983, 1835, 1306, 2158, 1310, 1302, 2246, 1834, 1833, 1831,
 /*  1780 */   685, 2242,  225,  697,  350,  351, 1828,  511, 1827, 1820,
 /*  1790 */   510, 1810,  698,  514,  210, 2193,  518, 2158,  111, 2159,
 /*  1800 */   700, 2161, 2162,  695,  212,  690,  512,  697,  515,  519,
 /*  1810 */  2176,  516, 2246,  520, 1788,  213,  357, 2242,  215,  522,
 /*  1820 */    76, 1202, 2126, 1787,  696, 2085,   77, 2146, 2075,  180,
 /*  1830 */  2063, 2062, 2040,  217, 2176,  223, 1909,  181, 1830,  530,
 /*  1840 */  1826, 1244,  547,  545,  546, 1824, 2126,  549,  696,  550,
 /*  1850 */   551, 1822,  553,  554,  555, 1819, 2157,  557,  558, 2193,
 /*  1860 */   559, 2158,  111, 2159,  700, 2161, 2162,  695, 1805,  690,
 /*  1870 */  1804,  697, 1784, 1911,   63,  235, 2246, 1378, 1377, 1910,
 /*  1880 */  2157, 2243,  606, 2193, 1293, 1291,  169, 2159,  700, 2161,
 /*  1890 */  2162,  695,  751,  690, 1289, 1288, 1287, 1286, 2176, 1285,
 /*  1900 */   786, 1282,  753,  382, 1281, 1280, 1279, 1817,  375, 1809,
 /*  1910 */  2126,  376,  696, 1807,  310,  377,  586,  589, 1783, 2158,
 /*  1920 */   591, 1782,  593, 1781,  595,  113, 1505, 2284,   29,  697,
 /*  1930 */   178, 1507, 1504, 2084,   58, 2158, 1509,  776,  772,  768,
 /*  1940 */   764,   67,  308, 1485, 2157,  697, 1487, 2193, 2074,  610,
 /*  1950 */   340, 2159,  700, 2161, 2162,  695, 2176,  690, 2061, 2059,
 /*  1960 */  1489,  383,    6, 2322,  611,   31,  163,  624, 2126,  258,
 /*  1970 */   696,  381, 2176,   20,   17,  616,    7, 1721,  263,   21,
 /*  1980 */    22,  265,  108, 1703, 2126,  301,  696, 1695,  626,  271,
 /*  1990 */   171,  270,   65, 2147,  269,   33, 2158,   32,   24, 1736,
 /*  2000 */    92, 1735, 2157, 1741, 1742, 2193,  697,   23,  340, 2159,
 /*  2010 */   700, 2161, 2162,  695,  386,  690, 1740,  676, 2157, 1739,
 /*  2020 */   387, 2193, 2158,   18,  333, 2159,  700, 2161, 2162,  695,
 /*  2030 */   283,  690,  697, 2176, 1670, 1669,   60,  176,   59, 2060,
 /*  2040 */  2058, 2057, 2039,   94,   95, 2126,  289,  696,  671, 2038,
 /*  2050 */    97,   25,  288,  290,  302, 1701,  103,  287, 2158, 2176,
 /*  2060 */    26,   11,  177,  292,  390,  297,   13,  640,  694,   68,
 /*  2070 */   299, 2126,   99,  696, 1622, 1621, 1545,  254, 2196, 2157,
 /*  2080 */  1600, 1598, 2193, 1597,  689,  170, 2159,  700, 2161, 2162,
 /*  2090 */   695,  190,  690,   39, 2158, 2176,   16,   27, 1577, 1569,
 /*  2100 */    28,  701,  703, 1363,  697, 2157,  401, 2126, 2193,  696,
 /*  2110 */   705,  340, 2159,  700, 2161, 2162,  695, 1360,  690,  707,
 /*  2120 */  2158,  708,  710, 1632, 1357,  711,  699, 1351,  713,  714,
 /*  2130 */   697, 2176, 1349,  716,  717,  104,  398, 2339,  305,  105,
 /*  2140 */  1372, 2157, 1355, 2126, 2193,  696, 1354,  339, 2159,  700,
 /*  2150 */  2161, 2162,  695,   75,  690, 1353, 2212, 2176, 1352, 1368,
 /*  2160 */  1242, 1274,  400,  731, 1273, 1272, 1271, 1269, 1267, 2126,
 /*  2170 */  1266,  696,  306, 1300, 1265,  741, 1263, 2157, 1262, 1261,
 /*  2180 */  2193, 1260, 1259,  340, 2159,  700, 2161, 2162,  695, 1258,
 /*  2190 */   690, 1257, 1297, 1295, 1248, 2158, 1254, 1253, 1250, 1249,
 /*  2200 */  1247, 1825,  761, 2157,  762,  697, 2193,  763, 1823,  340,
 /*  2210 */  2159,  700, 2161, 2162,  695, 2158,  690,  765,  766,  767,
 /*  2220 */  1821, 1818,  769,  770,  771,  697,  773,  774,  775, 1803,
 /*  2230 */   777, 1192, 2176, 1780,  309,  781, 1755, 1531,  319,  784,
 /*  2240 */  1755, 1755,  785, 1755, 2126, 1755,  696, 1755, 1755, 1755,
 /*  2250 */  1755, 1755, 2176, 1755, 1755, 1755, 1755, 1755, 1755, 1755,
 /*  2260 */  1755, 1755, 1755, 1755, 2126, 1755,  696, 1755, 1755, 1755,
 /*  2270 */  1755, 1755, 1755, 1755, 1755, 1755, 1755, 1755,  601, 1755,
 /*  2280 */  1755, 2193, 1755, 2158,  335, 2159,  700, 2161, 2162,  695,
 /*  2290 */  1755,  690, 1755,  697, 1755, 1755, 1755, 1755, 2157, 1755,
 /*  2300 */  2158, 2193, 1755, 1755,  324, 2159,  700, 2161, 2162,  695,
 /*  2310 */   697,  690, 1755, 1755, 1755, 1755, 1755, 1755, 1755, 1755,
 /*  2320 */  2176, 1755, 1755, 1755, 1755, 1755, 1755, 1755, 1755, 1755,
 /*  2330 */  1755, 1755, 2126, 1755,  696, 1755, 1755, 2176, 1755, 1755,
 /*  2340 */  1755, 1755, 1755, 1755, 1755, 1755, 1755, 1755, 2158, 2126,
 /*  2350 */  1755,  696, 1755, 1755, 1755, 1755, 1755, 1755,  697, 1755,
 /*  2360 */  1755, 1755, 1755, 1755, 1755, 1755, 2157, 1755, 2158, 2193,
 /*  2370 */  1755, 1755,  325, 2159,  700, 2161, 2162,  695,  697,  690,
 /*  2380 */  1755, 1755, 1755, 2157, 1755, 2176, 2193, 1755, 1755,  326,
 /*  2390 */  2159,  700, 2161, 2162,  695, 1755,  690, 2126, 2158,  696,
 /*  2400 */  1755, 1755, 1755, 1755, 1755, 2176, 1755, 1755,  697, 1755,
 /*  2410 */  1755, 1755, 1755, 1755, 1755, 1755, 2158, 2126, 1755,  696,
 /*  2420 */  1755, 1755, 1755, 1755, 1755, 1755,  697, 1755, 1755, 1755,
 /*  2430 */  1755, 2157, 1755, 1755, 2193, 2176, 1755,  332, 2159,  700,
 /*  2440 */  2161, 2162,  695, 1755,  690, 1755, 2158, 2126, 1755,  696,
 /*  2450 */  1755, 2157, 1755, 2176, 2193, 1755,  697,  336, 2159,  700,
 /*  2460 */  2161, 2162,  695, 1755,  690, 2126, 1755,  696, 1755, 1755,
 /*  2470 */  1755, 1755, 1755, 1755, 1755, 1755, 2158, 1755, 1755, 1755,
 /*  2480 */  1755, 2157, 1755, 2176, 2193, 1755,  697,  328, 2159,  700,
 /*  2490 */  2161, 2162,  695, 1755,  690, 2126, 1755,  696, 1755, 2157,
 /*  2500 */  1755, 1755, 2193, 1755, 1755,  337, 2159,  700, 2161, 2162,
 /*  2510 */   695, 1755,  690, 2176, 1755, 1755, 1755, 1755, 1755, 1755,
 /*  2520 */  1755, 1755, 1755, 1755, 2158, 2126, 1755,  696, 1755, 2157,
 /*  2530 */  1755, 1755, 2193, 1755,  697,  329, 2159,  700, 2161, 2162,
 /*  2540 */   695, 1755,  690, 1755, 2158, 1755, 1755, 1755, 1755, 1755,
 /*  2550 */  1755, 1755, 1755, 1755,  697, 1755, 1755, 1755, 1755, 2157,
 /*  2560 */  1755, 2176, 2193, 1755, 1755,  338, 2159,  700, 2161, 2162,
 /*  2570 */   695, 1755,  690, 2126, 1755,  696, 1755, 1755, 1755, 1755,
 /*  2580 */  1755, 2176, 1755, 1755, 1755, 1755, 1755, 1755, 1755, 1755,
 /*  2590 */  1755, 1755, 1755, 2126, 1755,  696, 1755, 1755, 1755, 1755,
 /*  2600 */  1755, 1755, 1755, 1755, 1755, 1755, 1755, 2157, 1755, 1755,
 /*  2610 */  2193, 1755, 1755,  330, 2159,  700, 2161, 2162,  695, 1755,
 /*  2620 */   690, 1755, 2158, 1755, 1755, 1755, 1755, 2157, 1755, 1755,
 /*  2630 */  2193, 1755,  697,  343, 2159,  700, 2161, 2162,  695, 2158,
 /*  2640 */   690, 1755, 1755, 1755, 1755, 1755, 1755, 1755, 1755,  697,
 /*  2650 */  1755, 1755, 1755, 1755, 1755, 1755, 1755, 1755, 1755, 2176,
 /*  2660 */  1755, 1755, 1755, 1755, 1755, 1755, 1755, 1755, 1755, 1755,
 /*  2670 */  1755, 2126, 1755,  696, 1755, 1755, 2176, 1755, 1755, 1755,
 /*  2680 */  1755, 1755, 1755, 1755, 1755, 1755, 1755, 2158, 2126, 1755,
 /*  2690 */   696, 1755, 1755, 1755, 1755, 1755, 1755,  697, 1755, 1755,
 /*  2700 */  1755, 1755, 1755, 1755, 1755, 2157, 1755, 2158, 2193, 1755,
 /*  2710 */  1755,  344, 2159,  700, 2161, 2162,  695,  697,  690, 1755,
 /*  2720 */  1755, 1755, 2157, 1755, 2176, 2193, 1755, 1755, 2170, 2159,
 /*  2730 */   700, 2161, 2162,  695, 1755,  690, 2126, 2158,  696, 1755,
 /*  2740 */  1755, 1755, 1755, 1755, 2176, 1755, 1755,  697, 1755, 1755,
 /*  2750 */  1755, 1755, 1755, 1755, 1755, 2158, 2126, 1755,  696, 1755,
 /*  2760 */  1755, 1755, 1755, 1755, 1755,  697, 1755, 1755, 1755, 1755,
 /*  2770 */  2157, 1755, 1755, 2193, 2176, 1755, 2169, 2159,  700, 2161,
 /*  2780 */  2162,  695, 1755,  690, 1755, 2158, 2126, 1755,  696, 1755,
 /*  2790 */  2157, 1755, 2176, 2193, 1755,  697, 2168, 2159,  700, 2161,
 /*  2800 */  2162,  695, 1755,  690, 2126, 1755,  696, 1755, 1755, 1755,
 /*  2810 */  1755, 1755, 1755, 1755, 1755, 2158, 1755, 1755, 1755, 1755,
 /*  2820 */  2157, 1755, 2176, 2193, 1755,  697,  359, 2159,  700, 2161,
 /*  2830 */  2162,  695, 1755,  690, 2126, 1755,  696, 1755, 2157, 1755,
 /*  2840 */  1755, 2193, 1755, 1755,  360, 2159,  700, 2161, 2162,  695,
 /*  2850 */  1755,  690, 2176, 1755, 1755, 1755, 1755, 1755, 1755, 1755,
 /*  2860 */  1755, 1755, 1755, 2158, 2126, 1755,  696, 1755, 2157, 1755,
 /*  2870 */  1755, 2193, 1755,  697,  356, 2159,  700, 2161, 2162,  695,
 /*  2880 */  1755,  690, 1755, 2158, 1755, 1755, 1755, 1755, 1755, 1755,
 /*  2890 */  1755, 1755, 1755,  697, 1755, 1755, 1755, 1755, 2157, 1755,
 /*  2900 */  2176, 2193, 1755, 1755,  361, 2159,  700, 2161, 2162,  695,
 /*  2910 */  1755,  690, 2126, 1755,  696, 1755, 1755, 1755, 1755, 1755,
 /*  2920 */  2176, 1755, 1755, 1755, 1755, 1755, 1755, 1755, 1755, 1755,
 /*  2930 */  1755, 1755, 2126, 1755,  696, 1755, 1755, 1755, 1755, 1755,
 /*  2940 */  1755, 1755, 1755, 1755, 1755, 1755,  698, 1755, 1755, 2193,
 /*  2950 */  1755, 1755,  335, 2159,  700, 2161, 2162,  695, 1755,  690,
 /*  2960 */  1755, 1755, 1755, 1755, 1755, 1755, 2157, 1755, 1755, 2193,
 /*  2970 */  1755, 1755,  334, 2159,  700, 2161, 2162,  695, 1755,  690,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   338,  367,  347,  348,  442,  443,  374,  371,  453,  375,
 /*    10 */   348,  456,   12,   13,   14,    0,  382,  383,  386,  343,
 /*    20 */    20,  366,   22,  347,  390,  349,  471,  472,  373,  347,
 /*    30 */   348,  476,  477,   33,    0,   35,   21,  375,  353,   24,
 /*    40 */    25,   26,   27,   28,   29,   30,   31,   32,   20,  387,
 /*    50 */     0,  389,    8,    9,  418,  370,   12,   13,   14,   15,
 /*    60 */    16,   61,   14,  378,   20,    8,    9,   67,   20,   12,
 /*    70 */    13,   14,   15,   16,   74,    0,   20,   12,   13,   14,
 /*    80 */    15,   16,  437,  421,  342,  440,  424,  345,  346,  427,
 /*    90 */   428,  429,  430,  431,  432,  433,  434,  435,  436,   99,
 /*   100 */   356,   44,  102,   69,   70,   71,   72,   73,  364,   75,
 /*   110 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   120 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   130 */   448,  449,  450,  451,   99,  453,  454,   21,  138,  139,
 /*   140 */    24,   25,   26,   27,   28,   29,   30,   31,   32,  114,
 /*   150 */   115,  116,  117,  118,  119,  120,  121,  122,  123,   20,
 /*   160 */   125,  126,  127,  128,  129,  130,  138,  139,  168,  169,
 /*   170 */   347,  348,    8,    9,  174,  175,   12,   13,   14,   15,
 /*   180 */    16,  131,  132,  133,  134,  135,  136,  137,  188,  366,
 /*   190 */   190,  102,  347,   12,   13,  131,  373,    8,    9,  135,
 /*   200 */   406,   12,   13,   14,   15,   16,  131,  132,  133,  134,
 /*   210 */   135,  136,  137,   20,  170,  342,   35,   20,  345,  346,
 /*   220 */   220,  221,   66,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */   230,  231,  232,  233,  234,  235,  236,  237,  238,  239,
 /*   240 */   240,   12,   13,  398,  338,  400,   18,  453,   20,   20,
 /*   250 */   456,   22,    1,    2,  348,   27,   67,  389,   30,   20,
 /*   260 */    20,   33,   33,  102,   35,  471,  472,   69,   70,   71,
 /*   270 */   476,  477,  404,  405,   76,   77,   78,   49,  363,   51,
 /*   280 */    82,  375,   33,   55,    4,   87,   88,   89,   90,    0,
 /*   290 */    61,   93,  377,  387,  375,  389,   67,  375,   49,    4,
 /*   300 */   111,  382,  387,   74,  382,   56,   57,   58,   59,  390,
 /*   310 */    61,  375,  390,   24,   25,   26,   27,   28,   29,   30,
 /*   320 */    31,   32,  337,   43,  339,   45,   46,  421,   99,  101,
 /*   330 */   424,  102,  396,  427,  428,  429,  430,  431,  432,  424,
 /*   340 */   434,  113,  102,  426,  180,  439,  257,  441,  375,  434,
 /*   350 */   101,  445,  446,  104,  103,  382,  167,  385,  406,   66,
 /*   360 */   388,  389,  410,  390,  458,  168,  169,  138,  139,  452,
 /*   370 */   142,  190,  466,  145,  146,  147,  148,  149,  150,  151,
 /*   380 */   152,  153,  154,  155,  156,  157,  158,  159,  160,  161,
 /*   390 */   343,  163,  164,  165,  347,   20,  349,  168,  169,    0,
 /*   400 */    20,  347,  348,  174,  175,  453,    8,    9,  456,    3,
 /*   410 */    12,   13,   14,   15,   16,  375,   37,  188,  257,  190,
 /*   420 */   171,  172,  382,  471,  472,  176,   20,  178,  476,  477,
 /*   430 */   390,  335,  389,  244,  245,  246,  247,  248,  249,  250,
 /*   440 */   251,  252,  253,  254,  401,  196,  282,  404,  405,  220,
 /*   450 */   221,  348,  223,  224,  225,  226,  227,  228,  229,  230,
 /*   460 */   231,  232,  233,  234,  235,  236,  237,  238,  239,  240,
 /*   470 */   241,   12,   13,  355,  355,  367,  347,  102,  375,   20,
 /*   480 */   347,   22,  338,  375,  105,  347,  107,  108,  338,  110,
 /*   490 */   372,  383,   33,  453,   35,  220,  456,  257,  348,  381,
 /*   500 */   381,  103,  406,  449,  450,  451,  410,  453,  454,  103,
 /*   510 */   131,  471,  472,  338,  135,  375,  476,  477,  138,  139,
 /*   520 */    61,  347,  348,  348,  391,  375,   67,  398,   83,  400,
 /*   530 */   390,  387,  429,   74,  347,  348,  398,  387,  400,  389,
 /*   540 */   366,  173,  267,  268,  269,  270,  271,  272,  273,  453,
 /*   550 */   375,  338,  456,  258,  174,  175,  157,    4,   99,   49,
 /*   560 */   353,  102,  387,   20,  389,  166,   56,  471,  472,   59,
 /*   570 */    60,  421,  476,  477,  424,    0,  170,  427,  428,  429,
 /*   580 */   430,  431,  432,  241,  434,  378,    8,    9,  143,  144,
 /*   590 */    12,   13,   14,   15,   16,   21,  421,  138,  139,  424,
 /*   600 */   387,  113,  427,  428,  429,  430,  431,  432,   34,  434,
 /*   610 */    36,  166,  437,   14,  439,  440,  441,  467,  468,   20,
 /*   620 */   445,  446,  375,   20,  132,  133,   22,  168,  169,  137,
 /*   630 */   262,  263,  264,  174,  175,  426,  449,  450,  451,   35,
 /*   640 */   453,  454,  395,  396,   69,   70,   71,  188,  375,  190,
 /*   650 */   133,   76,   77,   78,  137,  102,  383,   82,  338,  113,
 /*   660 */    14,  452,   87,   88,   89,   90,   20,  338,   93,  131,
 /*   670 */   132,  133,  134,  135,  136,  137,   61,  348,   74,  220,
 /*   680 */   221,  103,  223,  224,  225,  226,  227,  228,  229,  230,
 /*   690 */   231,  232,  233,  234,  235,  236,  237,  238,  239,  240,
 /*   700 */    12,   13,   14,   99,  375,  102,   74,  387,   20,   35,
 /*   710 */    22,   20,  102,   22,  197,  338,  387,  200,  389,  104,
 /*   720 */   203,   33,  205,   35,    2,  348,   35,  350,  347,  348,
 /*   730 */     8,    9,  347,  348,   12,   13,   14,   15,   16,   39,
 /*   740 */   347,  348,  338,  426,   53,   61,   74,  366,   74,   61,
 /*   750 */   421,  366,  375,  424,  347,  348,  427,  428,  429,  430,
 /*   760 */   431,  432,   74,  434,  387,  406,  389,  168,  439,  452,
 /*   770 */   441,    2,  338,  366,  445,  446,   35,    8,    9,   12,
 /*   780 */    13,   12,   13,   14,   15,   16,  102,   99,  104,   22,
 /*   790 */   102,  387,  188,    0,  190,  466,   44,  187,  421,  189,
 /*   800 */    33,  424,   35,  338,  427,  428,  429,  430,  431,  432,
 /*   810 */   257,  434,  453,  348,  168,  456,  439,   13,  441,  347,
 /*   820 */   348,  387,  445,  446,  220,  221,  138,  139,   61,  219,
 /*   830 */   471,  472,  347,  348,  376,  476,  477,  367,  366,   35,
 /*   840 */   375,   74,  449,  450,  451,  375,  453,  454,  241,  456,
 /*   850 */   243,  366,  387,  383,  389,  103,  168,  169,  338,   66,
 /*   860 */   257,  338,  174,  175,  471,  472,   99,  257,  375,  476,
 /*   870 */   477,  347,  348,  360,  361,  382,  188,  363,  190,  453,
 /*   880 */   376,  453,  456,  390,  456,  338,  421,  347,  348,  424,
 /*   890 */   366,  377,  427,  428,  429,  430,  431,  432,  472,  434,
 /*   900 */   472,  387,  476,  477,  476,  477,  366,  387,  220,  221,
 /*   910 */   387,  223,  224,  225,  226,  227,  228,  229,  230,  231,
 /*   920 */   232,  233,  234,  235,  236,  237,  238,  239,  240,   12,
 /*   930 */    13,  190,  347,  348,  387,  338,  338,   20,  424,   22,
 /*   940 */    22,  257,    3,  478,  479,  348,  367,  350,  434,  376,
 /*   950 */    33,  366,   35,   35,  375,  188,  256,  190,  338,    8,
 /*   960 */     9,  338,  383,   12,   13,   14,   15,   16,  368,    8,
 /*   970 */     9,  371,  375,   12,   13,   14,   15,   16,   61,   20,
 /*   980 */   347,  348,  388,  389,  387,  387,  389,  220,  221,  347,
 /*   990 */   348,   74,  347,  348,  347,  348,   22,    0,  406,  366,
 /*  1000 */   233,  234,  235,  236,  237,  238,  239,  387,  366,   35,
 /*  1010 */   387,  366,  348,  366,   20,  376,   99,   99,  421,  102,
 /*  1020 */    20,  424,   22,  338,  427,  428,  429,  430,  431,  432,
 /*  1030 */   132,  434,    4,  348,  384,  350,  439,  387,  441,  347,
 /*  1040 */   348,  384,  445,  446,  387,  453,  167,   19,  456,  338,
 /*  1050 */    61,  347,  348,   53,  183,  138,  139,  393,  366,  338,
 /*  1060 */   375,   33,  338,  471,  472,  347,  348,   20,  476,  477,
 /*  1070 */   366,  338,  387,   99,  389,  347,  348,   49,  347,  348,
 /*  1080 */    20,  210,  211,   55,  366,  168,  169,  360,  361,   61,
 /*  1090 */   101,  174,  175,  104,  366,   45,   46,  366,  387,  201,
 /*  1100 */   202,   14,   15,   16,   14,  188,  421,  190,  387,  424,
 /*  1110 */    20,  387,  427,  428,  429,  430,  431,  432,  338,  434,
 /*  1120 */   387,  170,  406,  244,  439,  338,  441,  168,  338,  101,
 /*  1130 */   445,  446,  104,  254,  338,  255,  256,  220,  221,  348,
 /*  1140 */   223,  224,  225,  226,  227,  228,  229,  230,  231,  232,
 /*  1150 */   233,  234,  235,  236,  237,  238,  239,  240,   12,   13,
 /*  1160 */   348,  338,  363,  438,  170,  440,   20,  387,   22,  453,
 /*  1170 */     0,  348,  456,  350,  387,  362,  377,  387,  365,   33,
 /*  1180 */   438,   35,  440,  387,  393,  113,  387,  471,  472,   22,
 /*  1190 */    48,  384,  476,  477,  387,   42,    0,   44,  375,   42,
 /*  1200 */   106,   44,   35,  109,    0,  393,  106,   61,   44,  109,
 /*  1210 */   387,  214,  389,   13,    0,  106,  277,  170,  109,   49,
 /*  1220 */    74,    0,  106,  424,  425,  109,   22,  204,   44,  206,
 /*  1230 */   170,   44,   44,  434,  162,   35,   22,   44,   44,   44,
 /*  1240 */    44,  138,  139,   22,  421,   99,   44,  424,  102,   67,
 /*  1250 */   427,  428,  429,  430,  431,  432,   44,  434,   47,   44,
 /*  1260 */    44,    0,  439,   35,  441,  102,   44,  103,  445,  446,
 /*  1270 */    44,    1,    2,   44,   44,  112,   44,   13,   13,   44,
 /*  1280 */    44,   44,   44,   44,  138,  139,  376,  103,   35,  376,
 /*  1290 */   103,  103,  376,  411,  364,  339,  103,  103,  397,   35,
 /*  1300 */    35,  480,  469,   18,  351,  103,  463,  363,   23,  363,
 /*  1310 */   375,   50,  170,  102,  168,  169,  351,  397,  103,  103,
 /*  1320 */   174,  175,   37,   38,  346,  103,   41,   74,  348,  103,
 /*  1330 */   397,  386,  103,  103,  188,  103,  190,   52,  103,  103,
 /*  1340 */   103,  103,  103,  455,  447,  473,  457,   62,   63,   64,
 /*  1350 */    65,  259,  423,   49,  422,  338,   20,  415,  203,  355,
 /*  1360 */   420,  355,  415,  186,   42,  348,  220,  221,  408,  223,
 /*  1370 */   224,  225,  226,  227,  228,  229,  230,  231,  232,  233,
 /*  1380 */   234,  235,  236,  237,  238,  239,  240,  102,   20,  394,
 /*  1390 */   397,  167,  375,  394,  392,   20,  347,  394,  347,  392,
 /*  1400 */   392,  100,  220,  359,  387,   98,  389,   97,  347,  347,
 /*  1410 */   358,  357,  347,  347,   20,  340,  415,   48,  190,  340,
 /*  1420 */   344,  344,  355,   20,  338,  140,  389,   20,  355,  349,
 /*  1430 */    20,  407,  349,  355,  348,  347,  350,  355,  421,  355,
 /*  1440 */   355,  424,   54,  352,  427,  428,  429,  430,  431,  432,
 /*  1450 */   355,  434,  340,  352,  340,  347,  439,  387,  441,  207,
 /*  1460 */   419,  375,  445,  446,  375,  180,  181,  182,  375,  102,
 /*  1470 */   185,  375,  375,  387,  279,  389,  417,  375,  415,  375,
 /*  1480 */   375,  375,  375,  198,  199,  375,  338,  353,  375,  194,
 /*  1490 */   193,  353,  192,  281,  209,  414,  348,  212,  350,  347,
 /*  1500 */   215,  216,  217,  218,  219,  387,  387,  421,  397,  389,
 /*  1510 */   424,  413,  338,  427,  428,  429,  430,  431,  432,  397,
 /*  1520 */   434,  266,  348,  375,  387,  439,  462,  441,  265,  412,
 /*  1530 */   402,  445,  446,  462,  387,  387,  387,  389,  402,  465,
 /*  1540 */   274,  387,  257,  179,  276,  283,  275,  260,  423,  375,
 /*  1550 */   481,  278,  280,  348,  256,   20,  426,  347,  349,  353,
 /*  1560 */   461,  387,   20,  389,  402,  400,  353,  387,  387,  421,
 /*  1570 */   387,  402,  424,  387,  459,  427,  428,  429,  430,  431,
 /*  1580 */   432,  172,  434,  460,  387,  464,  338,  439,  462,  441,
 /*  1590 */   387,  399,  102,  445,  446,  421,  348,  353,  424,  475,
 /*  1600 */   353,  427,  428,  429,  430,  431,  432,  474,  434,  102,
 /*  1610 */   444,  371,  379,  439,  387,  441,  365,  348,   36,  445,
 /*  1620 */   446,  347,  341,  375,  340,  369,  409,  369,  353,  369,
 /*  1630 */   354,    0,  336,    0,  416,  387,    0,  389,   42,    0,
 /*  1640 */    35,  213,   35,   35,  403,  403,   35,  338,    0,  213,
 /*  1650 */    35,   35,  213,    0,  213,    0,   35,  348,   35,   22,
 /*  1660 */     0,  208,    0,  196,    0,  196,  190,  197,  188,  421,
 /*  1670 */     0,    0,  424,  338,    0,  427,  428,  429,  430,  431,
 /*  1680 */   432,    0,  434,  348,  375,  184,  183,  439,    0,  441,
 /*  1690 */     0,   47,    0,  445,  446,    0,  387,    0,  389,   42,
 /*  1700 */     0,    0,    0,    0,    0,    0,    0,    0,  157,  338,
 /*  1710 */   375,   35,    0,  157,    0,    0,    0,    0,    0,  348,
 /*  1720 */    42,    0,  387,    0,  389,    0,    0,    0,    0,    0,
 /*  1730 */   421,    0,    0,  424,    0,    0,  427,  428,  429,  430,
 /*  1740 */   431,  432,    0,  434,    0,    0,  375,    0,    0,    0,
 /*  1750 */   441,    0,   22,    0,  445,  446,  421,    0,  387,  424,
 /*  1760 */   389,  141,  427,  428,  429,  430,  431,  432,    0,  434,
 /*  1770 */     0,    0,   22,  338,   22,   35,  441,    0,    0,    0,
 /*  1780 */   445,  446,  179,  348,   48,   48,    0,   49,    0,    0,
 /*  1790 */    35,    0,  421,   35,   61,  424,   35,  338,  427,  428,
 /*  1800 */   429,  430,  431,  432,   61,  434,   39,  348,   49,   49,
 /*  1810 */   375,   39,  441,   39,    0,   61,  445,  446,   42,   35,
 /*  1820 */    39,   14,  387,    0,  389,    0,   39,   47,    0,   44,
 /*  1830 */     0,    0,    0,   40,  375,   39,    0,   47,    0,   47,
 /*  1840 */     0,   68,   39,   35,   49,    0,  387,   35,  389,   49,
 /*  1850 */    39,    0,   35,   49,   39,    0,  421,   35,   49,  424,
 /*  1860 */    39,  338,  427,  428,  429,  430,  431,  432,    0,  434,
 /*  1870 */     0,  348,    0,    0,  111,  109,  441,   35,   22,    0,
 /*  1880 */   421,  446,    1,  424,   35,   35,  427,  428,  429,  430,
 /*  1890 */   431,  432,   44,  434,   35,   35,   35,   35,  375,   35,
 /*  1900 */    19,   35,   44,  380,   35,   22,   35,    0,   22,    0,
 /*  1910 */   387,   22,  389,    0,   33,   22,   51,   35,    0,  338,
 /*  1920 */    35,    0,   35,    0,   22,   20,   35,  468,  102,  348,
 /*  1930 */    49,   35,   35,    0,  170,  338,  103,   56,   57,   58,
 /*  1940 */    59,  102,   61,   35,  421,  348,   22,  424,    0,   22,
 /*  1950 */   427,  428,  429,  430,  431,  432,  375,  434,    0,    0,
 /*  1960 */   195,  380,   48,    3,  170,  102,  191,  100,  387,  172,
 /*  1970 */   389,  170,  375,   44,  261,  177,   48,  103,  102,   44,
 /*  1980 */    44,  103,  101,  103,  387,  104,  389,  103,   98,   47,
 /*  1990 */   102,   44,    3,   47,  102,   44,  338,  102,   44,   35,
 /*  2000 */   102,   35,  421,  103,  103,  424,  348,  261,  427,  428,
 /*  2010 */   429,  430,  431,  432,   35,  434,   35,  136,  421,   35,
 /*  2020 */    35,  424,  338,  261,  427,  428,  429,  430,  431,  432,
 /*  2030 */    47,  434,  348,  375,  103,  103,   44,   47,  255,    0,
 /*  2040 */     0,    0,    0,  102,   39,  387,   47,  389,  173,    0,
 /*  2050 */    39,  102,  171,  103,   47,  103,  112,  176,  338,  375,
 /*  2060 */    44,  242,   47,  102,  380,  102,    2,  470,  348,  102,
 /*  2070 */   171,  387,  102,  389,  100,  100,   22,  196,  102,  421,
 /*  2080 */   103,  103,  424,  103,  102,  427,  428,  429,  430,  431,
 /*  2090 */   432,   47,  434,  102,  338,  375,  102,  102,   22,  103,
 /*  2100 */   102,  113,   35,  103,  348,  421,   35,  387,  424,  389,
 /*  2110 */   102,  427,  428,  429,  430,  431,  432,  103,  434,   35,
 /*  2120 */   338,  102,   35,  220,  103,  102,  222,  103,   35,  102,
 /*  2130 */   348,  375,  103,   35,  102,  102,  380,  479,   44,  102,
 /*  2140 */    35,  421,  124,  387,  424,  389,  124,  427,  428,  429,
 /*  2150 */   430,  431,  432,  102,  434,  124,  436,  375,  124,   22,
 /*  2160 */    68,   35,  380,   67,   35,   35,   35,   35,   35,  387,
 /*  2170 */    35,  389,   44,   74,   35,   96,   35,  421,   35,   35,
 /*  2180 */   424,   22,   35,  427,  428,  429,  430,  431,  432,   35,
 /*  2190 */   434,   35,   74,   35,   22,  338,   35,   35,   35,   35,
 /*  2200 */    35,    0,   35,  421,   49,  348,  424,   39,    0,  427,
 /*  2210 */   428,  429,  430,  431,  432,  338,  434,   35,   49,   39,
 /*  2220 */     0,    0,   35,   49,   39,  348,   35,   49,   39,    0,
 /*  2230 */    35,   35,  375,    0,   22,   21,  482,   22,   22,   21,
 /*  2240 */   482,  482,   20,  482,  387,  482,  389,  482,  482,  482,
 /*  2250 */   482,  482,  375,  482,  482,  482,  482,  482,  482,  482,
 /*  2260 */   482,  482,  482,  482,  387,  482,  389,  482,  482,  482,
 /*  2270 */   482,  482,  482,  482,  482,  482,  482,  482,  421,  482,
 /*  2280 */   482,  424,  482,  338,  427,  428,  429,  430,  431,  432,
 /*  2290 */   482,  434,  482,  348,  482,  482,  482,  482,  421,  482,
 /*  2300 */   338,  424,  482,  482,  427,  428,  429,  430,  431,  432,
 /*  2310 */   348,  434,  482,  482,  482,  482,  482,  482,  482,  482,
 /*  2320 */   375,  482,  482,  482,  482,  482,  482,  482,  482,  482,
 /*  2330 */   482,  482,  387,  482,  389,  482,  482,  375,  482,  482,
 /*  2340 */   482,  482,  482,  482,  482,  482,  482,  482,  338,  387,
 /*  2350 */   482,  389,  482,  482,  482,  482,  482,  482,  348,  482,
 /*  2360 */   482,  482,  482,  482,  482,  482,  421,  482,  338,  424,
 /*  2370 */   482,  482,  427,  428,  429,  430,  431,  432,  348,  434,
 /*  2380 */   482,  482,  482,  421,  482,  375,  424,  482,  482,  427,
 /*  2390 */   428,  429,  430,  431,  432,  482,  434,  387,  338,  389,
 /*  2400 */   482,  482,  482,  482,  482,  375,  482,  482,  348,  482,
 /*  2410 */   482,  482,  482,  482,  482,  482,  338,  387,  482,  389,
 /*  2420 */   482,  482,  482,  482,  482,  482,  348,  482,  482,  482,
 /*  2430 */   482,  421,  482,  482,  424,  375,  482,  427,  428,  429,
 /*  2440 */   430,  431,  432,  482,  434,  482,  338,  387,  482,  389,
 /*  2450 */   482,  421,  482,  375,  424,  482,  348,  427,  428,  429,
 /*  2460 */   430,  431,  432,  482,  434,  387,  482,  389,  482,  482,
 /*  2470 */   482,  482,  482,  482,  482,  482,  338,  482,  482,  482,
 /*  2480 */   482,  421,  482,  375,  424,  482,  348,  427,  428,  429,
 /*  2490 */   430,  431,  432,  482,  434,  387,  482,  389,  482,  421,
 /*  2500 */   482,  482,  424,  482,  482,  427,  428,  429,  430,  431,
 /*  2510 */   432,  482,  434,  375,  482,  482,  482,  482,  482,  482,
 /*  2520 */   482,  482,  482,  482,  338,  387,  482,  389,  482,  421,
 /*  2530 */   482,  482,  424,  482,  348,  427,  428,  429,  430,  431,
 /*  2540 */   432,  482,  434,  482,  338,  482,  482,  482,  482,  482,
 /*  2550 */   482,  482,  482,  482,  348,  482,  482,  482,  482,  421,
 /*  2560 */   482,  375,  424,  482,  482,  427,  428,  429,  430,  431,
 /*  2570 */   432,  482,  434,  387,  482,  389,  482,  482,  482,  482,
 /*  2580 */   482,  375,  482,  482,  482,  482,  482,  482,  482,  482,
 /*  2590 */   482,  482,  482,  387,  482,  389,  482,  482,  482,  482,
 /*  2600 */   482,  482,  482,  482,  482,  482,  482,  421,  482,  482,
 /*  2610 */   424,  482,  482,  427,  428,  429,  430,  431,  432,  482,
 /*  2620 */   434,  482,  338,  482,  482,  482,  482,  421,  482,  482,
 /*  2630 */   424,  482,  348,  427,  428,  429,  430,  431,  432,  338,
 /*  2640 */   434,  482,  482,  482,  482,  482,  482,  482,  482,  348,
 /*  2650 */   482,  482,  482,  482,  482,  482,  482,  482,  482,  375,
 /*  2660 */   482,  482,  482,  482,  482,  482,  482,  482,  482,  482,
 /*  2670 */   482,  387,  482,  389,  482,  482,  375,  482,  482,  482,
 /*  2680 */   482,  482,  482,  482,  482,  482,  482,  338,  387,  482,
 /*  2690 */   389,  482,  482,  482,  482,  482,  482,  348,  482,  482,
 /*  2700 */   482,  482,  482,  482,  482,  421,  482,  338,  424,  482,
 /*  2710 */   482,  427,  428,  429,  430,  431,  432,  348,  434,  482,
 /*  2720 */   482,  482,  421,  482,  375,  424,  482,  482,  427,  428,
 /*  2730 */   429,  430,  431,  432,  482,  434,  387,  338,  389,  482,
 /*  2740 */   482,  482,  482,  482,  375,  482,  482,  348,  482,  482,
 /*  2750 */   482,  482,  482,  482,  482,  338,  387,  482,  389,  482,
 /*  2760 */   482,  482,  482,  482,  482,  348,  482,  482,  482,  482,
 /*  2770 */   421,  482,  482,  424,  375,  482,  427,  428,  429,  430,
 /*  2780 */   431,  432,  482,  434,  482,  338,  387,  482,  389,  482,
 /*  2790 */   421,  482,  375,  424,  482,  348,  427,  428,  429,  430,
 /*  2800 */   431,  432,  482,  434,  387,  482,  389,  482,  482,  482,
 /*  2810 */   482,  482,  482,  482,  482,  338,  482,  482,  482,  482,
 /*  2820 */   421,  482,  375,  424,  482,  348,  427,  428,  429,  430,
 /*  2830 */   431,  432,  482,  434,  387,  482,  389,  482,  421,  482,
 /*  2840 */   482,  424,  482,  482,  427,  428,  429,  430,  431,  432,
 /*  2850 */   482,  434,  375,  482,  482,  482,  482,  482,  482,  482,
 /*  2860 */   482,  482,  482,  338,  387,  482,  389,  482,  421,  482,
 /*  2870 */   482,  424,  482,  348,  427,  428,  429,  430,  431,  432,
 /*  2880 */   482,  434,  482,  338,  482,  482,  482,  482,  482,  482,
 /*  2890 */   482,  482,  482,  348,  482,  482,  482,  482,  421,  482,
 /*  2900 */   375,  424,  482,  482,  427,  428,  429,  430,  431,  432,
 /*  2910 */   482,  434,  387,  482,  389,  482,  482,  482,  482,  482,
 /*  2920 */   375,  482,  482,  482,  482,  482,  482,  482,  482,  482,
 /*  2930 */   482,  482,  387,  482,  389,  482,  482,  482,  482,  482,
 /*  2940 */   482,  482,  482,  482,  482,  482,  421,  482,  482,  424,
 /*  2950 */   482,  482,  427,  428,  429,  430,  431,  432,  482,  434,
 /*  2960 */   482,  482,  482,  482,  482,  482,  421,  482,  482,  424,
 /*  2970 */   482,  482,  427,  428,  429,  430,  431,  432,  482,  434,
 /*  2980 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  2990 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3000 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3010 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3020 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3030 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3040 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3050 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3060 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3070 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3080 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3090 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3100 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3110 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3120 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3130 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3140 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3150 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3160 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3170 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3180 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3190 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3200 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3210 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3220 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3230 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3240 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3250 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3260 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3270 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3280 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3290 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3300 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  3310 */   335,  335,  335,  335,  335,
};
#define YY_SHIFT_COUNT    (786)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2233)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1285,    0,  229,    0,  459,  459,  459,  459,  459,  459,
 /*    10 */   459,  459,  459,  459,  459,  459,  688,  917,  917, 1146,
 /*    20 */   917,  917,  917,  917,  917,  917,  917,  917,  917,  917,
 /*    30 */   917,  917,  917,  917,  917,  917,  917,  917,  917,  917,
 /*    40 */   917,  917,  917,  917,  917,  917,  917,  917,  917,  917,
 /*    50 */   917,  240,  603,  610,  375,  684,   89,  161,   89,  375,
 /*    60 */   375,  767,   89,  767,  767,  553,   89,   56,  380,  139,
 /*    70 */   139,  380,  280,  280,  197,   28,   48,   48,  139,  139,
 /*    80 */   139,  139,  139,  139,  139,  193,  139,  139,  156,   56,
 /*    90 */   139,  139,  239,  139,   56,  139,  193,  139,  193,   56,
 /*   100 */   139,  139,   56,  139,   56,   56,   56,  139,  293,  228,
 /*   110 */   189,  189,  198,  116,  604,  604,  604,  604,  604,  604,
 /*   120 */   604,  604,  604,  604,  604,  604,  604,  604,  604,  604,
 /*   130 */   604,  604,  604,  379,  406,  197,   28,  674,  994,  994,
 /*   140 */   994,  793,  607,  607,  674,  543,  543,  543,  156,  488,
 /*   150 */   342,   56,  632,   56,  632,  632,  546,  672,   35,   35,
 /*   160 */    35,   35,   35,   35,   35,   35, 1881,  575,   15,   44,
 /*   170 */   164,  275,  691,  368,  181,  181,  599,  646, 1000, 1047,
 /*   180 */  1050, 1090,   64, 1060,  880,  700,  939,  880, 1153,  295,
 /*   190 */   959, 1092, 1304, 1336, 1155,  156, 1336,  156, 1177, 1322,
 /*   200 */  1368, 1322, 1224, 1375, 1375, 1322, 1224, 1224, 1301, 1307,
 /*   210 */  1375, 1310, 1375, 1375, 1375, 1394, 1369, 1394, 1369, 1336,
 /*   220 */   156, 1403,  156, 1407, 1410,  156, 1407,  156,  156,  156,
 /*   230 */  1375,  156, 1388, 1388, 1394,   56,   56,   56,   56,   56,
 /*   240 */    56,   56,   56,   56,   56,   56, 1375, 1394,  632,  632,
 /*   250 */   632, 1252, 1367, 1336,  293, 1295, 1297, 1403,  293, 1300,
 /*   260 */  1375, 1368, 1368,  632, 1255, 1263,  632, 1255, 1263,  632,
 /*   270 */   632,   56, 1266, 1364, 1255, 1268, 1271, 1287, 1092, 1262,
 /*   280 */  1272, 1273, 1298,  543, 1535, 1375, 1407,  293,  293, 1542,
 /*   290 */  1263,  632,  632,  632,  632,  632, 1263,  632, 1409,  293,
 /*   300 */   546,  293,  543, 1490, 1507,  632,  672, 1375,  293, 1582,
 /*   310 */  1394, 2980, 2980, 2980, 2980, 2980, 2980, 2980, 2980, 2980,
 /*   320 */    34,  249,  289, 1028,  398,   57,  578,   50,  722,  769,
 /*   330 */   951,   75,  961,  961,  961,  961,  961,  961,  961,  961,
 /*   340 */   961,  538,  517,   65,   65,  445,  510,  871,  399,  989,
 /*   350 */   918,  974,  574,  898,  492,  492, 1087,  251,  879, 1087,
 /*   360 */  1087, 1087, 1170,  997,  752, 1167, 1157, 1072, 1196, 1094,
 /*   370 */  1100, 1109, 1116,  804, 1200, 1204, 1214, 1221, 1023, 1164,
 /*   380 */  1184,  615, 1187, 1188, 1193, 1103, 1195, 1212, 1142, 1194,
 /*   390 */  1202, 1215, 1216, 1222, 1226, 1270, 1229, 1182, 1230, 1211,
 /*   400 */  1232, 1235, 1236, 1237, 1238, 1239, 1163,  741, 1228, 1264,
 /*   410 */  1265, 1253, 1261, 1631, 1633, 1636, 1596, 1639, 1605, 1428,
 /*   420 */  1607, 1608, 1611, 1436, 1648, 1615, 1616, 1439, 1653, 1441,
 /*   430 */  1655, 1621, 1670, 1637, 1660, 1623, 1453, 1662, 1467, 1664,
 /*   440 */  1469, 1470, 1476, 1480, 1671, 1674, 1681, 1501, 1503, 1688,
 /*   450 */  1690, 1644, 1692, 1695, 1697, 1657, 1700, 1701, 1702, 1703,
 /*   460 */  1704, 1705, 1706, 1707, 1551, 1676, 1712, 1556, 1714, 1715,
 /*   470 */  1716, 1717, 1718, 1723, 1725, 1726, 1727, 1728, 1729, 1731,
 /*   480 */  1732, 1734, 1735, 1742, 1678, 1721, 1744, 1745, 1747, 1748,
 /*   490 */  1749, 1730, 1751, 1753, 1757, 1620, 1768, 1770, 1750, 1736,
 /*   500 */  1752, 1737, 1771, 1733, 1740, 1777, 1743, 1778, 1754, 1779,
 /*   510 */  1786, 1755, 1738, 1767, 1788, 1758, 1759, 1772, 1789, 1761,
 /*   520 */  1760, 1774, 1791, 1784, 1814, 1776, 1781, 1785, 1780, 1790,
 /*   530 */  1807, 1792, 1823, 1793, 1787, 1825, 1828, 1830, 1796, 1603,
 /*   540 */  1831, 1832, 1836, 1773, 1838, 1840, 1808, 1795, 1803, 1845,
 /*   550 */  1812, 1800, 1811, 1851, 1817, 1804, 1815, 1855, 1822, 1809,
 /*   560 */  1821, 1868, 1870, 1872, 1873, 1763, 1766, 1842, 1856, 1879,
 /*   570 */  1849, 1850, 1859, 1860, 1861, 1862, 1864, 1848, 1858, 1866,
 /*   580 */  1869, 1883, 1871, 1907, 1886, 1909, 1889, 1865, 1913, 1893,
 /*   590 */  1882, 1918, 1885, 1921, 1887, 1923, 1902, 1905, 1891, 1896,
 /*   600 */  1897, 1833, 1826, 1933, 1764, 1839, 1765, 1908, 1924, 1948,
 /*   610 */  1775, 1927, 1794, 1797, 1958, 1959, 1801, 1798, 1960, 1929,
 /*   620 */  1713, 1863, 1874, 1876, 1914, 1867, 1928, 1890, 1878, 1935,
 /*   630 */  1936, 1880, 1888, 1892, 1895, 1884, 1947, 1942, 1946, 1898,
 /*   640 */  1951, 1746, 1900, 1901, 1989, 1954, 1762, 1964, 1966, 1979,
 /*   650 */  1981, 1984, 1985, 1931, 1932, 1983, 1783, 1992, 1990, 2039,
 /*   660 */  2040, 2041, 2042, 1941, 2005, 1780, 1999, 1949, 1950, 1952,
 /*   670 */  1961, 1963, 1875, 1967, 2049, 2011, 1899, 1970, 1944, 1780,
 /*   680 */  2007, 2016, 1974, 1819, 1975, 2064, 2054, 1903, 1976, 1977,
 /*   690 */  1982, 1978, 1991, 1980, 2015, 1994, 1995, 2044, 1996, 2076,
 /*   700 */  1904, 1998, 1988, 2000, 2067, 2071, 2008, 2014, 2084, 2019,
 /*   710 */  2021, 2087, 2023, 2024, 2093, 2027, 2029, 2098, 2032, 2018,
 /*   720 */  2022, 2031, 2034, 2033, 2094, 2037, 2105, 2051, 2094, 2094,
 /*   730 */  2137, 2092, 2096, 2126, 2129, 2130, 2131, 2132, 2133, 2135,
 /*   740 */  2139, 2099, 2079, 2128, 2141, 2143, 2144, 2159, 2147, 2154,
 /*   750 */  2156, 2118, 1848, 2158, 1858, 2161, 2162, 2163, 2164, 2172,
 /*   760 */  2165, 2201, 2167, 2155, 2168, 2208, 2182, 2169, 2180, 2220,
 /*   770 */  2187, 2174, 2185, 2221, 2191, 2178, 2189, 2229, 2195, 2196,
 /*   780 */  2233, 2212, 2214, 2215, 2216, 2218, 2222,
};
#define YY_REDUCE_COUNT (319)
#define YY_REDUCE_MIN   (-445)
#define YY_REDUCE_MAX   (2545)
static const short yy_reduce_ofst[] = {
 /*     0 */    96,  -94,  175,  329,  377,  597,  685,  823, 1086, 1148,
 /*    10 */  1017, 1174, 1248, 1309, 1335, 1371, -338,  150,  465, 1435,
 /*    20 */  1459, 1523, 1581, 1597, 1658, 1684, 1720, 1756, 1782, 1857,
 /*    30 */  1877, 1945, 1962, 2010, 2030, 2060, 2078, 2108, 2138, 2186,
 /*    40 */  2206, 2284, 2301, 2349, 2369, 2399, 2417, 2447, 2477, 2525,
 /*    50 */  2545,  393,   40,  -48, -318, -206,  359,  592,  716,   54,
 /*    60 */   187,  799, -445,  -85,  514,  426,  428, -366,   43, -345,
 /*    70 */  -177, -132, -258, -127,  247,  -28, -324,   47,  174,  381,
 /*    80 */   385,  407,  472,  485,  524, -155,  540,  585,  118,  -81,
 /*    90 */   633,  642,  103,  645,  -78,  647,  129,  692,  138,  108,
 /*   100 */   704,  718,  -27,  728,  470,  493,  579,  731, -315,  133,
 /*   110 */  -438, -438, -256,  -15,  144,  213,  320,  404,  434,  520,
 /*   120 */   523,  547,  598,  620,  623,  711,  721,  724,  733,  780,
 /*   130 */   787,  790,  796, -368,  -83,  -64,  594,  513,  -83,  209,
 /*   140 */   317,  207,  725,  742,  727,  664,  791,  812,  119, -364,
 /*   150 */  -355,  273,  650,  140,  657,  807,  600,  813,  458,  504,
 /*   160 */   573,  639,  910,  913,  916,  910,  882,  930,  956,  901,
 /*   170 */   821,  833,  953,  843,  944,  946,  935,  935,  965,  920,
 /*   180 */   978,  980,  945,  933,  888,  888,  872,  888,  897,  889,
 /*   190 */   935,  929,  932,  942,  940, 1004,  947, 1006,  960,  995,
 /*   200 */   993,  999, 1002, 1049, 1051, 1003, 1007, 1008, 1044, 1052,
 /*   210 */  1061, 1054, 1062, 1065, 1066, 1075, 1076, 1079, 1077, 1001,
 /*   220 */  1067, 1037, 1073, 1080, 1024, 1078, 1083, 1082, 1084, 1085,
 /*   230 */  1088, 1095, 1091, 1101, 1112, 1089, 1093, 1096, 1097, 1102,
 /*   240 */  1104, 1105, 1106, 1107, 1110, 1113, 1108, 1114, 1070, 1118,
 /*   250 */  1119, 1041, 1059, 1063, 1134, 1081, 1098, 1120, 1138, 1117,
 /*   260 */  1152, 1111, 1122, 1137, 1064, 1128, 1147, 1071, 1136, 1149,
 /*   270 */  1154,  935, 1074, 1121, 1126, 1099, 1123, 1115, 1125, 1069,
 /*   280 */  1124, 1133,  888, 1205, 1130, 1210, 1209, 1206, 1213, 1165,
 /*   290 */  1162, 1180, 1181, 1183, 1186, 1197, 1169, 1203, 1192, 1244,
 /*   300 */  1240, 1247, 1269, 1166, 1233, 1227, 1251, 1274, 1275, 1281,
 /*   310 */  1284, 1217, 1218, 1241, 1242, 1256, 1258, 1260, 1276, 1296,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*    10 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*    20 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*    30 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*    40 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*    50 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*    60 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*    70 */  1753, 1753, 1753, 1753, 2030, 1753, 1753, 1753, 1753, 1753,
 /*    80 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1839, 1753,
 /*    90 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   100 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1837, 2023,
 /*   110 */  2248, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   120 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   130 */  1753, 1753, 1753, 1753, 2260, 1753, 1753, 1753, 2260, 2260,
 /*   140 */  2260, 1837, 2220, 2220, 1753, 1753, 1753, 1753, 1839, 2090,
 /*   150 */  1753, 1753, 1753, 1753, 1753, 1753, 1958, 1753, 1753, 1753,
 /*   160 */  1753, 1753, 1982, 1753, 1753, 1753, 2082, 1753, 1753, 2285,
 /*   170 */  2341, 1753, 1753, 2288, 1753, 1753, 1753, 1753, 1753, 2035,
 /*   180 */  1753, 1753, 1912, 2275, 2252, 2266, 2325, 2253, 2250, 2269,
 /*   190 */  1753, 2279, 1753, 1753, 2104, 1839, 1753, 1839, 2069, 2028,
 /*   200 */  1753, 2028, 2025, 1753, 1753, 2028, 2025, 2025, 1901, 1897,
 /*   210 */  1753, 1895, 1753, 1753, 1753, 1753, 1800, 1753, 1800, 1753,
 /*   220 */  1839, 1753, 1839, 1753, 1753, 1839, 1753, 1839, 1839, 1839,
 /*   230 */  1753, 1839, 1814, 1814, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   240 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   250 */  1753, 2102, 2088, 1753, 1837, 2080, 2078, 1753, 1837, 2076,
 /*   260 */  1753, 1753, 1753, 1753, 2296, 2294, 1753, 2296, 2294, 1753,
 /*   270 */  1753, 1753, 2310, 2306, 2296, 2314, 2312, 2281, 2279, 2344,
 /*   280 */  2331, 2327, 2266, 1753, 1753, 1753, 1753, 1837, 1837, 1753,
 /*   290 */  2294, 1753, 1753, 1753, 1753, 1753, 2294, 1753, 1753, 1837,
 /*   300 */  1753, 1837, 1753, 1753, 1928, 1753, 1753, 1753, 1837, 1785,
 /*   310 */  1753, 2071, 2093, 2053, 2053, 1961, 1961, 1961, 1840, 1758,
 /*   320 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   330 */  1753, 1753, 2309, 2308, 2175, 1753, 2224, 2223, 2222, 2213,
 /*   340 */  2174, 1924, 1753, 2173, 2172, 1753, 1753, 1753, 1753, 1753,
 /*   350 */  1753, 1753, 1753, 1753, 2044, 2043, 2166, 1753, 1753, 2167,
 /*   360 */  2165, 2164, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   370 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   380 */  1753, 1753, 1753, 1753, 1753, 1753, 2328, 2332, 1753, 1753,
 /*   390 */  1753, 1753, 1753, 1753, 1753, 2249, 1753, 1753, 1753, 2148,
 /*   400 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   410 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   420 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   430 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   440 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   450 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   460 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   470 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   480 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   490 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   500 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   510 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   520 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1790, 2153, 1753,
 /*   530 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   540 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   550 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   560 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   570 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1878, 1877, 1753,
 /*   580 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   590 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   600 */  1753, 2157, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   610 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 2324, 2282,
 /*   620 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   630 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 2148, 1753,
 /*   640 */  2307, 1753, 1753, 2322, 1753, 2326, 1753, 1753, 1753, 1753,
 /*   650 */  1753, 1753, 1753, 2259, 2255, 1753, 1753, 2251, 1753, 1753,
 /*   660 */  1753, 1753, 1753, 1753, 1753, 2156, 1753, 1753, 1753, 1753,
 /*   670 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 2147,
 /*   680 */  1753, 2210, 1753, 1753, 1753, 2244, 1753, 1753, 2195, 1753,
 /*   690 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 2157, 1753,
 /*   700 */  2160, 1753, 1753, 1753, 1753, 1753, 1955, 1753, 1753, 1753,
 /*   710 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1940,
 /*   720 */  1938, 1937, 1936, 1753, 1968, 1753, 1753, 1753, 1964, 1963,
 /*   730 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   740 */  1753, 1753, 1753, 1858, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   750 */  1753, 1753, 1850, 1753, 1849, 1753, 1753, 1753, 1753, 1753,
 /*   760 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   770 */  1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753, 1753,
 /*   780 */  1753, 1753, 1753, 1753, 1753, 1753, 1753,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*       WITH => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /*    RESTORE => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*      VNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      START => nothing */
    0,  /*  TIMESTAMP => nothing */
  284,  /*        END => ABORT */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*   LANGUAGE => nothing */
    0,  /*    REPLACE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*      PAUSE => nothing */
    0,  /*     RESUME => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*  UNTREATED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*     LEADER => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  284,  /*      AFTER => ABORT */
  284,  /*     ATTACH => ABORT */
  284,  /*     BEFORE => ABORT */
  284,  /*      BEGIN => ABORT */
  284,  /*     BITAND => ABORT */
  284,  /*     BITNOT => ABORT */
  284,  /*      BITOR => ABORT */
  284,  /*     BLOCKS => ABORT */
  284,  /*     CHANGE => ABORT */
  284,  /*      COMMA => ABORT */
  284,  /*     CONCAT => ABORT */
  284,  /*   CONFLICT => ABORT */
  284,  /*       COPY => ABORT */
  284,  /*   DEFERRED => ABORT */
  284,  /* DELIMITERS => ABORT */
  284,  /*     DETACH => ABORT */
  284,  /*     DIVIDE => ABORT */
  284,  /*        DOT => ABORT */
  284,  /*       EACH => ABORT */
  284,  /*       FAIL => ABORT */
  284,  /*       FILE => ABORT */
  284,  /*        FOR => ABORT */
  284,  /*       GLOB => ABORT */
  284,  /*         ID => ABORT */
  284,  /*  IMMEDIATE => ABORT */
  284,  /*     IMPORT => ABORT */
  284,  /*  INITIALLY => ABORT */
  284,  /*    INSTEAD => ABORT */
  284,  /*     ISNULL => ABORT */
  284,  /*        KEY => ABORT */
  284,  /*    MODULES => ABORT */
  284,  /*  NK_BITNOT => ABORT */
  284,  /*    NK_SEMI => ABORT */
  284,  /*    NOTNULL => ABORT */
  284,  /*         OF => ABORT */
  284,  /*       PLUS => ABORT */
  284,  /*  PRIVILEGE => ABORT */
  284,  /*      RAISE => ABORT */
  284,  /*   RESTRICT => ABORT */
  284,  /*        ROW => ABORT */
  284,  /*       SEMI => ABORT */
  284,  /*       STAR => ABORT */
  284,  /*  STATEMENT => ABORT */
  284,  /*     STRICT => ABORT */
  284,  /*     STRING => ABORT */
  284,  /*      TIMES => ABORT */
  284,  /*     VALUES => ABORT */
  284,  /*   VARIABLE => ABORT */
  284,  /*       VIEW => ABORT */
  284,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "WITH",
  /*   49 */ "DNODE",
  /*   50 */ "PORT",
  /*   51 */ "DNODES",
  /*   52 */ "RESTORE",
  /*   53 */ "NK_IPTOKEN",
  /*   54 */ "FORCE",
  /*   55 */ "LOCAL",
  /*   56 */ "QNODE",
  /*   57 */ "BNODE",
  /*   58 */ "SNODE",
  /*   59 */ "MNODE",
  /*   60 */ "VNODE",
  /*   61 */ "DATABASE",
  /*   62 */ "USE",
  /*   63 */ "FLUSH",
  /*   64 */ "TRIM",
  /*   65 */ "COMPACT",
  /*   66 */ "IF",
  /*   67 */ "NOT",
  /*   68 */ "EXISTS",
  /*   69 */ "BUFFER",
  /*   70 */ "CACHEMODEL",
  /*   71 */ "CACHESIZE",
  /*   72 */ "COMP",
  /*   73 */ "DURATION",
  /*   74 */ "NK_VARIABLE",
  /*   75 */ "MAXROWS",
  /*   76 */ "MINROWS",
  /*   77 */ "KEEP",
  /*   78 */ "PAGES",
  /*   79 */ "PAGESIZE",
  /*   80 */ "TSDB_PAGESIZE",
  /*   81 */ "PRECISION",
  /*   82 */ "REPLICA",
  /*   83 */ "VGROUPS",
  /*   84 */ "SINGLE_STABLE",
  /*   85 */ "RETENTIONS",
  /*   86 */ "SCHEMALESS",
  /*   87 */ "WAL_LEVEL",
  /*   88 */ "WAL_FSYNC_PERIOD",
  /*   89 */ "WAL_RETENTION_PERIOD",
  /*   90 */ "WAL_RETENTION_SIZE",
  /*   91 */ "WAL_ROLL_PERIOD",
  /*   92 */ "WAL_SEGMENT_SIZE",
  /*   93 */ "STT_TRIGGER",
  /*   94 */ "TABLE_PREFIX",
  /*   95 */ "TABLE_SUFFIX",
  /*   96 */ "NK_COLON",
  /*   97 */ "MAX_SPEED",
  /*   98 */ "START",
  /*   99 */ "TIMESTAMP",
  /*  100 */ "END",
  /*  101 */ "TABLE",
  /*  102 */ "NK_LP",
  /*  103 */ "NK_RP",
  /*  104 */ "STABLE",
  /*  105 */ "ADD",
  /*  106 */ "COLUMN",
  /*  107 */ "MODIFY",
  /*  108 */ "RENAME",
  /*  109 */ "TAG",
  /*  110 */ "SET",
  /*  111 */ "NK_EQ",
  /*  112 */ "USING",
  /*  113 */ "TAGS",
  /*  114 */ "BOOL",
  /*  115 */ "TINYINT",
  /*  116 */ "SMALLINT",
  /*  117 */ "INT",
  /*  118 */ "INTEGER",
  /*  119 */ "BIGINT",
  /*  120 */ "FLOAT",
  /*  121 */ "DOUBLE",
  /*  122 */ "BINARY",
  /*  123 */ "NCHAR",
  /*  124 */ "UNSIGNED",
  /*  125 */ "JSON",
  /*  126 */ "VARCHAR",
  /*  127 */ "MEDIUMBLOB",
  /*  128 */ "BLOB",
  /*  129 */ "VARBINARY",
  /*  130 */ "DECIMAL",
  /*  131 */ "COMMENT",
  /*  132 */ "MAX_DELAY",
  /*  133 */ "WATERMARK",
  /*  134 */ "ROLLUP",
  /*  135 */ "TTL",
  /*  136 */ "SMA",
  /*  137 */ "DELETE_MARK",
  /*  138 */ "FIRST",
  /*  139 */ "LAST",
  /*  140 */ "SHOW",
  /*  141 */ "PRIVILEGES",
  /*  142 */ "DATABASES",
  /*  143 */ "TABLES",
  /*  144 */ "STABLES",
  /*  145 */ "MNODES",
  /*  146 */ "QNODES",
  /*  147 */ "FUNCTIONS",
  /*  148 */ "INDEXES",
  /*  149 */ "ACCOUNTS",
  /*  150 */ "APPS",
  /*  151 */ "CONNECTIONS",
  /*  152 */ "LICENCES",
  /*  153 */ "GRANTS",
  /*  154 */ "QUERIES",
  /*  155 */ "SCORES",
  /*  156 */ "TOPICS",
  /*  157 */ "VARIABLES",
  /*  158 */ "CLUSTER",
  /*  159 */ "BNODES",
  /*  160 */ "SNODES",
  /*  161 */ "TRANSACTIONS",
  /*  162 */ "DISTRIBUTED",
  /*  163 */ "CONSUMERS",
  /*  164 */ "SUBSCRIPTIONS",
  /*  165 */ "VNODES",
  /*  166 */ "ALIVE",
  /*  167 */ "LIKE",
  /*  168 */ "TBNAME",
  /*  169 */ "QTAGS",
  /*  170 */ "AS",
  /*  171 */ "INDEX",
  /*  172 */ "FUNCTION",
  /*  173 */ "INTERVAL",
  /*  174 */ "COUNT",
  /*  175 */ "LAST_ROW",
  /*  176 */ "TOPIC",
  /*  177 */ "META",
  /*  178 */ "CONSUMER",
  /*  179 */ "GROUP",
  /*  180 */ "DESC",
  /*  181 */ "DESCRIBE",
  /*  182 */ "RESET",
  /*  183 */ "QUERY",
  /*  184 */ "CACHE",
  /*  185 */ "EXPLAIN",
  /*  186 */ "ANALYZE",
  /*  187 */ "VERBOSE",
  /*  188 */ "NK_BOOL",
  /*  189 */ "RATIO",
  /*  190 */ "NK_FLOAT",
  /*  191 */ "OUTPUTTYPE",
  /*  192 */ "AGGREGATE",
  /*  193 */ "BUFSIZE",
  /*  194 */ "LANGUAGE",
  /*  195 */ "REPLACE",
  /*  196 */ "STREAM",
  /*  197 */ "INTO",
  /*  198 */ "PAUSE",
  /*  199 */ "RESUME",
  /*  200 */ "TRIGGER",
  /*  201 */ "AT_ONCE",
  /*  202 */ "WINDOW_CLOSE",
  /*  203 */ "IGNORE",
  /*  204 */ "EXPIRED",
  /*  205 */ "FILL_HISTORY",
  /*  206 */ "UPDATE",
  /*  207 */ "SUBTABLE",
  /*  208 */ "UNTREATED",
  /*  209 */ "KILL",
  /*  210 */ "CONNECTION",
  /*  211 */ "TRANSACTION",
  /*  212 */ "BALANCE",
  /*  213 */ "VGROUP",
  /*  214 */ "LEADER",
  /*  215 */ "MERGE",
  /*  216 */ "REDISTRIBUTE",
  /*  217 */ "SPLIT",
  /*  218 */ "DELETE",
  /*  219 */ "INSERT",
  /*  220 */ "NULL",
  /*  221 */ "NK_QUESTION",
  /*  222 */ "NK_ARROW",
  /*  223 */ "ROWTS",
  /*  224 */ "QSTART",
  /*  225 */ "QEND",
  /*  226 */ "QDURATION",
  /*  227 */ "WSTART",
  /*  228 */ "WEND",
  /*  229 */ "WDURATION",
  /*  230 */ "IROWTS",
  /*  231 */ "ISFILLED",
  /*  232 */ "CAST",
  /*  233 */ "NOW",
  /*  234 */ "TODAY",
  /*  235 */ "TIMEZONE",
  /*  236 */ "CLIENT_VERSION",
  /*  237 */ "SERVER_VERSION",
  /*  238 */ "SERVER_STATUS",
  /*  239 */ "CURRENT_USER",
  /*  240 */ "CASE",
  /*  241 */ "WHEN",
  /*  242 */ "THEN",
  /*  243 */ "ELSE",
  /*  244 */ "BETWEEN",
  /*  245 */ "IS",
  /*  246 */ "NK_LT",
  /*  247 */ "NK_GT",
  /*  248 */ "NK_LE",
  /*  249 */ "NK_GE",
  /*  250 */ "NK_NE",
  /*  251 */ "MATCH",
  /*  252 */ "NMATCH",
  /*  253 */ "CONTAINS",
  /*  254 */ "IN",
  /*  255 */ "JOIN",
  /*  256 */ "INNER",
  /*  257 */ "SELECT",
  /*  258 */ "DISTINCT",
  /*  259 */ "WHERE",
  /*  260 */ "PARTITION",
  /*  261 */ "BY",
  /*  262 */ "SESSION",
  /*  263 */ "STATE_WINDOW",
  /*  264 */ "EVENT_WINDOW",
  /*  265 */ "SLIDING",
  /*  266 */ "FILL",
  /*  267 */ "VALUE",
  /*  268 */ "VALUE_F",
  /*  269 */ "NONE",
  /*  270 */ "PREV",
  /*  271 */ "NULL_F",
  /*  272 */ "LINEAR",
  /*  273 */ "NEXT",
  /*  274 */ "HAVING",
  /*  275 */ "RANGE",
  /*  276 */ "EVERY",
  /*  277 */ "ORDER",
  /*  278 */ "SLIMIT",
  /*  279 */ "SOFFSET",
  /*  280 */ "LIMIT",
  /*  281 */ "OFFSET",
  /*  282 */ "ASC",
  /*  283 */ "NULLS",
  /*  284 */ "ABORT",
  /*  285 */ "AFTER",
  /*  286 */ "ATTACH",
  /*  287 */ "BEFORE",
  /*  288 */ "BEGIN",
  /*  289 */ "BITAND",
  /*  290 */ "BITNOT",
  /*  291 */ "BITOR",
  /*  292 */ "BLOCKS",
  /*  293 */ "CHANGE",
  /*  294 */ "COMMA",
  /*  295 */ "CONCAT",
  /*  296 */ "CONFLICT",
  /*  297 */ "COPY",
  /*  298 */ "DEFERRED",
  /*  299 */ "DELIMITERS",
  /*  300 */ "DETACH",
  /*  301 */ "DIVIDE",
  /*  302 */ "DOT",
  /*  303 */ "EACH",
  /*  304 */ "FAIL",
  /*  305 */ "FILE",
  /*  306 */ "FOR",
  /*  307 */ "GLOB",
  /*  308 */ "ID",
  /*  309 */ "IMMEDIATE",
  /*  310 */ "IMPORT",
  /*  311 */ "INITIALLY",
  /*  312 */ "INSTEAD",
  /*  313 */ "ISNULL",
  /*  314 */ "KEY",
  /*  315 */ "MODULES",
  /*  316 */ "NK_BITNOT",
  /*  317 */ "NK_SEMI",
  /*  318 */ "NOTNULL",
  /*  319 */ "OF",
  /*  320 */ "PLUS",
  /*  321 */ "PRIVILEGE",
  /*  322 */ "RAISE",
  /*  323 */ "RESTRICT",
  /*  324 */ "ROW",
  /*  325 */ "SEMI",
  /*  326 */ "STAR",
  /*  327 */ "STATEMENT",
  /*  328 */ "STRICT",
  /*  329 */ "STRING",
  /*  330 */ "TIMES",
  /*  331 */ "VALUES",
  /*  332 */ "VARIABLE",
  /*  333 */ "VIEW",
  /*  334 */ "WAL",
  /*  335 */ "cmd",
  /*  336 */ "account_options",
  /*  337 */ "alter_account_options",
  /*  338 */ "literal",
  /*  339 */ "alter_account_option",
  /*  340 */ "user_name",
  /*  341 */ "sysinfo_opt",
  /*  342 */ "privileges",
  /*  343 */ "priv_level",
  /*  344 */ "with_opt",
  /*  345 */ "priv_type_list",
  /*  346 */ "priv_type",
  /*  347 */ "db_name",
  /*  348 */ "table_name",
  /*  349 */ "topic_name",
  /*  350 */ "search_condition",
  /*  351 */ "dnode_endpoint",
  /*  352 */ "force_opt",
  /*  353 */ "not_exists_opt",
  /*  354 */ "db_options",
  /*  355 */ "exists_opt",
  /*  356 */ "alter_db_options",
  /*  357 */ "speed_opt",
  /*  358 */ "start_opt",
  /*  359 */ "end_opt",
  /*  360 */ "integer_list",
  /*  361 */ "variable_list",
  /*  362 */ "retention_list",
  /*  363 */ "signed",
  /*  364 */ "alter_db_option",
  /*  365 */ "retention",
  /*  366 */ "full_table_name",
  /*  367 */ "column_def_list",
  /*  368 */ "tags_def_opt",
  /*  369 */ "table_options",
  /*  370 */ "multi_create_clause",
  /*  371 */ "tags_def",
  /*  372 */ "multi_drop_clause",
  /*  373 */ "alter_table_clause",
  /*  374 */ "alter_table_options",
  /*  375 */ "column_name",
  /*  376 */ "type_name",
  /*  377 */ "signed_literal",
  /*  378 */ "create_subtable_clause",
  /*  379 */ "specific_cols_opt",
  /*  380 */ "expression_list",
  /*  381 */ "drop_table_clause",
  /*  382 */ "col_name_list",
  /*  383 */ "column_def",
  /*  384 */ "duration_list",
  /*  385 */ "rollup_func_list",
  /*  386 */ "alter_table_option",
  /*  387 */ "duration_literal",
  /*  388 */ "rollup_func_name",
  /*  389 */ "function_name",
  /*  390 */ "col_name",
  /*  391 */ "db_name_cond_opt",
  /*  392 */ "like_pattern_opt",
  /*  393 */ "table_name_cond",
  /*  394 */ "from_db_opt",
  /*  395 */ "tag_list_opt",
  /*  396 */ "tag_item",
  /*  397 */ "column_alias",
  /*  398 */ "full_index_name",
  /*  399 */ "index_options",
  /*  400 */ "index_name",
  /*  401 */ "func_list",
  /*  402 */ "sliding_opt",
  /*  403 */ "sma_stream_opt",
  /*  404 */ "func",
  /*  405 */ "sma_func_name",
  /*  406 */ "query_or_subquery",
  /*  407 */ "cgroup_name",
  /*  408 */ "analyze_opt",
  /*  409 */ "explain_options",
  /*  410 */ "insert_query",
  /*  411 */ "or_replace_opt",
  /*  412 */ "agg_func_opt",
  /*  413 */ "bufsize_opt",
  /*  414 */ "language_opt",
  /*  415 */ "stream_name",
  /*  416 */ "stream_options",
  /*  417 */ "col_list_opt",
  /*  418 */ "tag_def_or_ref_opt",
  /*  419 */ "subtable_opt",
  /*  420 */ "ignore_opt",
  /*  421 */ "expression",
  /*  422 */ "dnode_list",
  /*  423 */ "where_clause_opt",
  /*  424 */ "literal_func",
  /*  425 */ "literal_list",
  /*  426 */ "table_alias",
  /*  427 */ "expr_or_subquery",
  /*  428 */ "pseudo_column",
  /*  429 */ "column_reference",
  /*  430 */ "function_expression",
  /*  431 */ "case_when_expression",
  /*  432 */ "star_func",
  /*  433 */ "star_func_para_list",
  /*  434 */ "noarg_func",
  /*  435 */ "other_para_list",
  /*  436 */ "star_func_para",
  /*  437 */ "when_then_list",
  /*  438 */ "case_when_else_opt",
  /*  439 */ "common_expression",
  /*  440 */ "when_then_expr",
  /*  441 */ "predicate",
  /*  442 */ "compare_op",
  /*  443 */ "in_op",
  /*  444 */ "in_predicate_value",
  /*  445 */ "boolean_value_expression",
  /*  446 */ "boolean_primary",
  /*  447 */ "from_clause_opt",
  /*  448 */ "table_reference_list",
  /*  449 */ "table_reference",
  /*  450 */ "table_primary",
  /*  451 */ "joined_table",
  /*  452 */ "alias_opt",
  /*  453 */ "subquery",
  /*  454 */ "parenthesized_joined_table",
  /*  455 */ "join_type",
  /*  456 */ "query_specification",
  /*  457 */ "set_quantifier_opt",
  /*  458 */ "select_list",
  /*  459 */ "partition_by_clause_opt",
  /*  460 */ "range_opt",
  /*  461 */ "every_opt",
  /*  462 */ "fill_opt",
  /*  463 */ "twindow_clause_opt",
  /*  464 */ "group_by_clause_opt",
  /*  465 */ "having_clause_opt",
  /*  466 */ "select_item",
  /*  467 */ "partition_list",
  /*  468 */ "partition_item",
  /*  469 */ "fill_mode",
  /*  470 */ "group_by_list",
  /*  471 */ "query_expression",
  /*  472 */ "query_simple",
  /*  473 */ "order_by_clause_opt",
  /*  474 */ "slimit_clause_opt",
  /*  475 */ "limit_clause_opt",
  /*  476 */ "union_query_expression",
  /*  477 */ "query_simple_or_subquery",
  /*  478 */ "sort_specification_list",
  /*  479 */ "sort_specification",
  /*  480 */ "ordering_specification_opt",
  /*  481 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level with_opt TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= db_name NK_DOT table_name",
 /*  43 */ "priv_level ::= topic_name",
 /*  44 */ "with_opt ::=",
 /*  45 */ "with_opt ::= WITH search_condition",
 /*  46 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  47 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  48 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  49 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  50 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  51 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  52 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  53 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  54 */ "cmd ::= RESTORE DNODE NK_INTEGER",
 /*  55 */ "dnode_endpoint ::= NK_STRING",
 /*  56 */ "dnode_endpoint ::= NK_ID",
 /*  57 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  58 */ "force_opt ::=",
 /*  59 */ "force_opt ::= FORCE",
 /*  60 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  61 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  62 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= RESTORE QNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  67 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  68 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  69 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  70 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  71 */ "cmd ::= RESTORE MNODE ON DNODE NK_INTEGER",
 /*  72 */ "cmd ::= RESTORE VNODE ON DNODE NK_INTEGER",
 /*  73 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  74 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  75 */ "cmd ::= USE db_name",
 /*  76 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  77 */ "cmd ::= FLUSH DATABASE db_name",
 /*  78 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  79 */ "cmd ::= COMPACT DATABASE db_name start_opt end_opt",
 /*  80 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  81 */ "not_exists_opt ::=",
 /*  82 */ "exists_opt ::= IF EXISTS",
 /*  83 */ "exists_opt ::=",
 /*  84 */ "db_options ::=",
 /*  85 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  86 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  87 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  88 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  89 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  90 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  91 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  92 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  93 */ "db_options ::= db_options KEEP integer_list",
 /*  94 */ "db_options ::= db_options KEEP variable_list",
 /*  95 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  96 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  97 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  98 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  99 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /* 100 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /* 101 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /* 102 */ "db_options ::= db_options RETENTIONS retention_list",
 /* 103 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /* 105 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /* 106 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 107 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 108 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 109 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 110 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 111 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 112 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 113 */ "db_options ::= db_options TABLE_PREFIX signed",
 /* 114 */ "db_options ::= db_options TABLE_SUFFIX signed",
 /* 115 */ "alter_db_options ::= alter_db_option",
 /* 116 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 117 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 118 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 119 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 120 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 121 */ "alter_db_option ::= KEEP integer_list",
 /* 122 */ "alter_db_option ::= KEEP variable_list",
 /* 123 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 124 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 125 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 126 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 127 */ "alter_db_option ::= MINROWS NK_INTEGER",
 /* 128 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER",
 /* 129 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 130 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER",
 /* 131 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 132 */ "integer_list ::= NK_INTEGER",
 /* 133 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 134 */ "variable_list ::= NK_VARIABLE",
 /* 135 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 136 */ "retention_list ::= retention",
 /* 137 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 138 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 139 */ "speed_opt ::=",
 /* 140 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 141 */ "start_opt ::=",
 /* 142 */ "start_opt ::= START WITH NK_INTEGER",
 /* 143 */ "start_opt ::= START WITH NK_STRING",
 /* 144 */ "start_opt ::= START WITH TIMESTAMP NK_STRING",
 /* 145 */ "end_opt ::=",
 /* 146 */ "end_opt ::= END WITH NK_INTEGER",
 /* 147 */ "end_opt ::= END WITH NK_STRING",
 /* 148 */ "end_opt ::= END WITH TIMESTAMP NK_STRING",
 /* 149 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 150 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 151 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 152 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 153 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 154 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 155 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 156 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 157 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 158 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 159 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 160 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 161 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 162 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 163 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 164 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 165 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 166 */ "multi_create_clause ::= create_subtable_clause",
 /* 167 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 168 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 169 */ "multi_drop_clause ::= drop_table_clause",
 /* 170 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 171 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 172 */ "specific_cols_opt ::=",
 /* 173 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 174 */ "full_table_name ::= table_name",
 /* 175 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 176 */ "column_def_list ::= column_def",
 /* 177 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 178 */ "column_def ::= column_name type_name",
 /* 179 */ "type_name ::= BOOL",
 /* 180 */ "type_name ::= TINYINT",
 /* 181 */ "type_name ::= SMALLINT",
 /* 182 */ "type_name ::= INT",
 /* 183 */ "type_name ::= INTEGER",
 /* 184 */ "type_name ::= BIGINT",
 /* 185 */ "type_name ::= FLOAT",
 /* 186 */ "type_name ::= DOUBLE",
 /* 187 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 188 */ "type_name ::= TIMESTAMP",
 /* 189 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 190 */ "type_name ::= TINYINT UNSIGNED",
 /* 191 */ "type_name ::= SMALLINT UNSIGNED",
 /* 192 */ "type_name ::= INT UNSIGNED",
 /* 193 */ "type_name ::= BIGINT UNSIGNED",
 /* 194 */ "type_name ::= JSON",
 /* 195 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 196 */ "type_name ::= MEDIUMBLOB",
 /* 197 */ "type_name ::= BLOB",
 /* 198 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 199 */ "type_name ::= DECIMAL",
 /* 200 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 201 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 202 */ "tags_def_opt ::=",
 /* 203 */ "tags_def_opt ::= tags_def",
 /* 204 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 205 */ "table_options ::=",
 /* 206 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 207 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 208 */ "table_options ::= table_options WATERMARK duration_list",
 /* 209 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 210 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 211 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 212 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 213 */ "alter_table_options ::= alter_table_option",
 /* 214 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 215 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 216 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 217 */ "duration_list ::= duration_literal",
 /* 218 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 219 */ "rollup_func_list ::= rollup_func_name",
 /* 220 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 221 */ "rollup_func_name ::= function_name",
 /* 222 */ "rollup_func_name ::= FIRST",
 /* 223 */ "rollup_func_name ::= LAST",
 /* 224 */ "col_name_list ::= col_name",
 /* 225 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 226 */ "col_name ::= column_name",
 /* 227 */ "cmd ::= SHOW DNODES",
 /* 228 */ "cmd ::= SHOW USERS",
 /* 229 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 230 */ "cmd ::= SHOW DATABASES",
 /* 231 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 232 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 233 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 234 */ "cmd ::= SHOW MNODES",
 /* 235 */ "cmd ::= SHOW QNODES",
 /* 236 */ "cmd ::= SHOW FUNCTIONS",
 /* 237 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 238 */ "cmd ::= SHOW STREAMS",
 /* 239 */ "cmd ::= SHOW ACCOUNTS",
 /* 240 */ "cmd ::= SHOW APPS",
 /* 241 */ "cmd ::= SHOW CONNECTIONS",
 /* 242 */ "cmd ::= SHOW LICENCES",
 /* 243 */ "cmd ::= SHOW GRANTS",
 /* 244 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 245 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 246 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 247 */ "cmd ::= SHOW QUERIES",
 /* 248 */ "cmd ::= SHOW SCORES",
 /* 249 */ "cmd ::= SHOW TOPICS",
 /* 250 */ "cmd ::= SHOW VARIABLES",
 /* 251 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 252 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 253 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 254 */ "cmd ::= SHOW BNODES",
 /* 255 */ "cmd ::= SHOW SNODES",
 /* 256 */ "cmd ::= SHOW CLUSTER",
 /* 257 */ "cmd ::= SHOW TRANSACTIONS",
 /* 258 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 259 */ "cmd ::= SHOW CONSUMERS",
 /* 260 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 261 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 262 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 263 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 264 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 265 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 266 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 267 */ "db_name_cond_opt ::=",
 /* 268 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 269 */ "like_pattern_opt ::=",
 /* 270 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 271 */ "table_name_cond ::= table_name",
 /* 272 */ "from_db_opt ::=",
 /* 273 */ "from_db_opt ::= FROM db_name",
 /* 274 */ "tag_list_opt ::=",
 /* 275 */ "tag_list_opt ::= tag_item",
 /* 276 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 277 */ "tag_item ::= TBNAME",
 /* 278 */ "tag_item ::= QTAGS",
 /* 279 */ "tag_item ::= column_name",
 /* 280 */ "tag_item ::= column_name column_alias",
 /* 281 */ "tag_item ::= column_name AS column_alias",
 /* 282 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 283 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 284 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 285 */ "full_index_name ::= index_name",
 /* 286 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 287 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 288 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 289 */ "func_list ::= func",
 /* 290 */ "func_list ::= func_list NK_COMMA func",
 /* 291 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 292 */ "sma_func_name ::= function_name",
 /* 293 */ "sma_func_name ::= COUNT",
 /* 294 */ "sma_func_name ::= FIRST",
 /* 295 */ "sma_func_name ::= LAST",
 /* 296 */ "sma_func_name ::= LAST_ROW",
 /* 297 */ "sma_stream_opt ::=",
 /* 298 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 299 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 300 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 301 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 302 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 303 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 304 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 305 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 306 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 307 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 308 */ "cmd ::= DESC full_table_name",
 /* 309 */ "cmd ::= DESCRIBE full_table_name",
 /* 310 */ "cmd ::= RESET QUERY CACHE",
 /* 311 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 312 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 313 */ "analyze_opt ::=",
 /* 314 */ "analyze_opt ::= ANALYZE",
 /* 315 */ "explain_options ::=",
 /* 316 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 317 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 318 */ "cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt",
 /* 319 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 320 */ "agg_func_opt ::=",
 /* 321 */ "agg_func_opt ::= AGGREGATE",
 /* 322 */ "bufsize_opt ::=",
 /* 323 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 324 */ "language_opt ::=",
 /* 325 */ "language_opt ::= LANGUAGE NK_STRING",
 /* 326 */ "or_replace_opt ::=",
 /* 327 */ "or_replace_opt ::= OR REPLACE",
 /* 328 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 329 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 330 */ "cmd ::= PAUSE STREAM exists_opt stream_name",
 /* 331 */ "cmd ::= RESUME STREAM exists_opt ignore_opt stream_name",
 /* 332 */ "col_list_opt ::=",
 /* 333 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 334 */ "tag_def_or_ref_opt ::=",
 /* 335 */ "tag_def_or_ref_opt ::= tags_def",
 /* 336 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 337 */ "stream_options ::=",
 /* 338 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 339 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 340 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 341 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 342 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 343 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 344 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 345 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 346 */ "subtable_opt ::=",
 /* 347 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 348 */ "ignore_opt ::=",
 /* 349 */ "ignore_opt ::= IGNORE UNTREATED",
 /* 350 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 351 */ "cmd ::= KILL QUERY NK_STRING",
 /* 352 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 353 */ "cmd ::= BALANCE VGROUP",
 /* 354 */ "cmd ::= BALANCE VGROUP LEADER",
 /* 355 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 356 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 357 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 358 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 359 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 360 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 361 */ "cmd ::= query_or_subquery",
 /* 362 */ "cmd ::= insert_query",
 /* 363 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 364 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 365 */ "literal ::= NK_INTEGER",
 /* 366 */ "literal ::= NK_FLOAT",
 /* 367 */ "literal ::= NK_STRING",
 /* 368 */ "literal ::= NK_BOOL",
 /* 369 */ "literal ::= TIMESTAMP NK_STRING",
 /* 370 */ "literal ::= duration_literal",
 /* 371 */ "literal ::= NULL",
 /* 372 */ "literal ::= NK_QUESTION",
 /* 373 */ "duration_literal ::= NK_VARIABLE",
 /* 374 */ "signed ::= NK_INTEGER",
 /* 375 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 376 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 377 */ "signed ::= NK_FLOAT",
 /* 378 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 379 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 380 */ "signed_literal ::= signed",
 /* 381 */ "signed_literal ::= NK_STRING",
 /* 382 */ "signed_literal ::= NK_BOOL",
 /* 383 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 384 */ "signed_literal ::= duration_literal",
 /* 385 */ "signed_literal ::= NULL",
 /* 386 */ "signed_literal ::= literal_func",
 /* 387 */ "signed_literal ::= NK_QUESTION",
 /* 388 */ "literal_list ::= signed_literal",
 /* 389 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 390 */ "db_name ::= NK_ID",
 /* 391 */ "table_name ::= NK_ID",
 /* 392 */ "column_name ::= NK_ID",
 /* 393 */ "function_name ::= NK_ID",
 /* 394 */ "table_alias ::= NK_ID",
 /* 395 */ "column_alias ::= NK_ID",
 /* 396 */ "user_name ::= NK_ID",
 /* 397 */ "topic_name ::= NK_ID",
 /* 398 */ "stream_name ::= NK_ID",
 /* 399 */ "cgroup_name ::= NK_ID",
 /* 400 */ "index_name ::= NK_ID",
 /* 401 */ "expr_or_subquery ::= expression",
 /* 402 */ "expression ::= literal",
 /* 403 */ "expression ::= pseudo_column",
 /* 404 */ "expression ::= column_reference",
 /* 405 */ "expression ::= function_expression",
 /* 406 */ "expression ::= case_when_expression",
 /* 407 */ "expression ::= NK_LP expression NK_RP",
 /* 408 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 409 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 410 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 411 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 412 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 413 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 414 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 415 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 416 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 417 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 418 */ "expression_list ::= expr_or_subquery",
 /* 419 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 420 */ "column_reference ::= column_name",
 /* 421 */ "column_reference ::= table_name NK_DOT column_name",
 /* 422 */ "pseudo_column ::= ROWTS",
 /* 423 */ "pseudo_column ::= TBNAME",
 /* 424 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 425 */ "pseudo_column ::= QSTART",
 /* 426 */ "pseudo_column ::= QEND",
 /* 427 */ "pseudo_column ::= QDURATION",
 /* 428 */ "pseudo_column ::= WSTART",
 /* 429 */ "pseudo_column ::= WEND",
 /* 430 */ "pseudo_column ::= WDURATION",
 /* 431 */ "pseudo_column ::= IROWTS",
 /* 432 */ "pseudo_column ::= ISFILLED",
 /* 433 */ "pseudo_column ::= QTAGS",
 /* 434 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 435 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 436 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 437 */ "function_expression ::= literal_func",
 /* 438 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 439 */ "literal_func ::= NOW",
 /* 440 */ "noarg_func ::= NOW",
 /* 441 */ "noarg_func ::= TODAY",
 /* 442 */ "noarg_func ::= TIMEZONE",
 /* 443 */ "noarg_func ::= DATABASE",
 /* 444 */ "noarg_func ::= CLIENT_VERSION",
 /* 445 */ "noarg_func ::= SERVER_VERSION",
 /* 446 */ "noarg_func ::= SERVER_STATUS",
 /* 447 */ "noarg_func ::= CURRENT_USER",
 /* 448 */ "noarg_func ::= USER",
 /* 449 */ "star_func ::= COUNT",
 /* 450 */ "star_func ::= FIRST",
 /* 451 */ "star_func ::= LAST",
 /* 452 */ "star_func ::= LAST_ROW",
 /* 453 */ "star_func_para_list ::= NK_STAR",
 /* 454 */ "star_func_para_list ::= other_para_list",
 /* 455 */ "other_para_list ::= star_func_para",
 /* 456 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 457 */ "star_func_para ::= expr_or_subquery",
 /* 458 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 459 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 460 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 461 */ "when_then_list ::= when_then_expr",
 /* 462 */ "when_then_list ::= when_then_list when_then_expr",
 /* 463 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 464 */ "case_when_else_opt ::=",
 /* 465 */ "case_when_else_opt ::= ELSE common_expression",
 /* 466 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 467 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 468 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 469 */ "predicate ::= expr_or_subquery IS NULL",
 /* 470 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 471 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 472 */ "compare_op ::= NK_LT",
 /* 473 */ "compare_op ::= NK_GT",
 /* 474 */ "compare_op ::= NK_LE",
 /* 475 */ "compare_op ::= NK_GE",
 /* 476 */ "compare_op ::= NK_NE",
 /* 477 */ "compare_op ::= NK_EQ",
 /* 478 */ "compare_op ::= LIKE",
 /* 479 */ "compare_op ::= NOT LIKE",
 /* 480 */ "compare_op ::= MATCH",
 /* 481 */ "compare_op ::= NMATCH",
 /* 482 */ "compare_op ::= CONTAINS",
 /* 483 */ "in_op ::= IN",
 /* 484 */ "in_op ::= NOT IN",
 /* 485 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 486 */ "boolean_value_expression ::= boolean_primary",
 /* 487 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 488 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 489 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 490 */ "boolean_primary ::= predicate",
 /* 491 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 492 */ "common_expression ::= expr_or_subquery",
 /* 493 */ "common_expression ::= boolean_value_expression",
 /* 494 */ "from_clause_opt ::=",
 /* 495 */ "from_clause_opt ::= FROM table_reference_list",
 /* 496 */ "table_reference_list ::= table_reference",
 /* 497 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 498 */ "table_reference ::= table_primary",
 /* 499 */ "table_reference ::= joined_table",
 /* 500 */ "table_primary ::= table_name alias_opt",
 /* 501 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 502 */ "table_primary ::= subquery alias_opt",
 /* 503 */ "table_primary ::= parenthesized_joined_table",
 /* 504 */ "alias_opt ::=",
 /* 505 */ "alias_opt ::= table_alias",
 /* 506 */ "alias_opt ::= AS table_alias",
 /* 507 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 508 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 509 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 510 */ "join_type ::=",
 /* 511 */ "join_type ::= INNER",
 /* 512 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 513 */ "set_quantifier_opt ::=",
 /* 514 */ "set_quantifier_opt ::= DISTINCT",
 /* 515 */ "set_quantifier_opt ::= ALL",
 /* 516 */ "select_list ::= select_item",
 /* 517 */ "select_list ::= select_list NK_COMMA select_item",
 /* 518 */ "select_item ::= NK_STAR",
 /* 519 */ "select_item ::= common_expression",
 /* 520 */ "select_item ::= common_expression column_alias",
 /* 521 */ "select_item ::= common_expression AS column_alias",
 /* 522 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 523 */ "where_clause_opt ::=",
 /* 524 */ "where_clause_opt ::= WHERE search_condition",
 /* 525 */ "partition_by_clause_opt ::=",
 /* 526 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 527 */ "partition_list ::= partition_item",
 /* 528 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 529 */ "partition_item ::= expr_or_subquery",
 /* 530 */ "partition_item ::= expr_or_subquery column_alias",
 /* 531 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 532 */ "twindow_clause_opt ::=",
 /* 533 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 534 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 535 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 536 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 537 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 538 */ "sliding_opt ::=",
 /* 539 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 540 */ "fill_opt ::=",
 /* 541 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 542 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP",
 /* 543 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP",
 /* 544 */ "fill_mode ::= NONE",
 /* 545 */ "fill_mode ::= PREV",
 /* 546 */ "fill_mode ::= NULL",
 /* 547 */ "fill_mode ::= NULL_F",
 /* 548 */ "fill_mode ::= LINEAR",
 /* 549 */ "fill_mode ::= NEXT",
 /* 550 */ "group_by_clause_opt ::=",
 /* 551 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 552 */ "group_by_list ::= expr_or_subquery",
 /* 553 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 554 */ "having_clause_opt ::=",
 /* 555 */ "having_clause_opt ::= HAVING search_condition",
 /* 556 */ "range_opt ::=",
 /* 557 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 558 */ "every_opt ::=",
 /* 559 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 560 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 561 */ "query_simple ::= query_specification",
 /* 562 */ "query_simple ::= union_query_expression",
 /* 563 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 564 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 565 */ "query_simple_or_subquery ::= query_simple",
 /* 566 */ "query_simple_or_subquery ::= subquery",
 /* 567 */ "query_or_subquery ::= query_expression",
 /* 568 */ "query_or_subquery ::= subquery",
 /* 569 */ "order_by_clause_opt ::=",
 /* 570 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 571 */ "slimit_clause_opt ::=",
 /* 572 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 573 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 574 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 575 */ "limit_clause_opt ::=",
 /* 576 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 577 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 578 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 579 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 580 */ "subquery ::= NK_LP subquery NK_RP",
 /* 581 */ "search_condition ::= common_expression",
 /* 582 */ "sort_specification_list ::= sort_specification",
 /* 583 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 584 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 585 */ "ordering_specification_opt ::=",
 /* 586 */ "ordering_specification_opt ::= ASC",
 /* 587 */ "ordering_specification_opt ::= DESC",
 /* 588 */ "null_ordering_opt ::=",
 /* 589 */ "null_ordering_opt ::= NULLS FIRST",
 /* 590 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 335: /* cmd */
    case 338: /* literal */
    case 344: /* with_opt */
    case 350: /* search_condition */
    case 354: /* db_options */
    case 356: /* alter_db_options */
    case 358: /* start_opt */
    case 359: /* end_opt */
    case 363: /* signed */
    case 365: /* retention */
    case 366: /* full_table_name */
    case 369: /* table_options */
    case 373: /* alter_table_clause */
    case 374: /* alter_table_options */
    case 377: /* signed_literal */
    case 378: /* create_subtable_clause */
    case 381: /* drop_table_clause */
    case 383: /* column_def */
    case 387: /* duration_literal */
    case 388: /* rollup_func_name */
    case 390: /* col_name */
    case 391: /* db_name_cond_opt */
    case 392: /* like_pattern_opt */
    case 393: /* table_name_cond */
    case 394: /* from_db_opt */
    case 396: /* tag_item */
    case 398: /* full_index_name */
    case 399: /* index_options */
    case 402: /* sliding_opt */
    case 403: /* sma_stream_opt */
    case 404: /* func */
    case 406: /* query_or_subquery */
    case 409: /* explain_options */
    case 410: /* insert_query */
    case 416: /* stream_options */
    case 419: /* subtable_opt */
    case 421: /* expression */
    case 423: /* where_clause_opt */
    case 424: /* literal_func */
    case 427: /* expr_or_subquery */
    case 428: /* pseudo_column */
    case 429: /* column_reference */
    case 430: /* function_expression */
    case 431: /* case_when_expression */
    case 436: /* star_func_para */
    case 438: /* case_when_else_opt */
    case 439: /* common_expression */
    case 440: /* when_then_expr */
    case 441: /* predicate */
    case 444: /* in_predicate_value */
    case 445: /* boolean_value_expression */
    case 446: /* boolean_primary */
    case 447: /* from_clause_opt */
    case 448: /* table_reference_list */
    case 449: /* table_reference */
    case 450: /* table_primary */
    case 451: /* joined_table */
    case 453: /* subquery */
    case 454: /* parenthesized_joined_table */
    case 456: /* query_specification */
    case 460: /* range_opt */
    case 461: /* every_opt */
    case 462: /* fill_opt */
    case 463: /* twindow_clause_opt */
    case 465: /* having_clause_opt */
    case 466: /* select_item */
    case 468: /* partition_item */
    case 471: /* query_expression */
    case 472: /* query_simple */
    case 474: /* slimit_clause_opt */
    case 475: /* limit_clause_opt */
    case 476: /* union_query_expression */
    case 477: /* query_simple_or_subquery */
    case 479: /* sort_specification */
{
#line 7 "sql.y"
 nodesDestroyNode((yypminor->yy164)); 
#line 2784 "sql.c"
}
      break;
    case 336: /* account_options */
    case 337: /* alter_account_options */
    case 339: /* alter_account_option */
    case 357: /* speed_opt */
    case 413: /* bufsize_opt */
{
#line 54 "sql.y"
 
#line 2795 "sql.c"
}
      break;
    case 340: /* user_name */
    case 347: /* db_name */
    case 348: /* table_name */
    case 349: /* topic_name */
    case 351: /* dnode_endpoint */
    case 375: /* column_name */
    case 389: /* function_name */
    case 397: /* column_alias */
    case 400: /* index_name */
    case 405: /* sma_func_name */
    case 407: /* cgroup_name */
    case 414: /* language_opt */
    case 415: /* stream_name */
    case 426: /* table_alias */
    case 432: /* star_func */
    case 434: /* noarg_func */
    case 452: /* alias_opt */
{
#line 728 "sql.y"
 
#line 2818 "sql.c"
}
      break;
    case 341: /* sysinfo_opt */
{
#line 92 "sql.y"
 
#line 2825 "sql.c"
}
      break;
    case 342: /* privileges */
    case 345: /* priv_type_list */
    case 346: /* priv_type */
{
#line 101 "sql.y"
 
#line 2834 "sql.c"
}
      break;
    case 343: /* priv_level */
{
#line 117 "sql.y"
 
#line 2841 "sql.c"
}
      break;
    case 352: /* force_opt */
    case 353: /* not_exists_opt */
    case 355: /* exists_opt */
    case 408: /* analyze_opt */
    case 411: /* or_replace_opt */
    case 412: /* agg_func_opt */
    case 420: /* ignore_opt */
    case 457: /* set_quantifier_opt */
{
#line 144 "sql.y"
 
#line 2855 "sql.c"
}
      break;
    case 360: /* integer_list */
    case 361: /* variable_list */
    case 362: /* retention_list */
    case 367: /* column_def_list */
    case 368: /* tags_def_opt */
    case 370: /* multi_create_clause */
    case 371: /* tags_def */
    case 372: /* multi_drop_clause */
    case 379: /* specific_cols_opt */
    case 380: /* expression_list */
    case 382: /* col_name_list */
    case 384: /* duration_list */
    case 385: /* rollup_func_list */
    case 395: /* tag_list_opt */
    case 401: /* func_list */
    case 417: /* col_list_opt */
    case 418: /* tag_def_or_ref_opt */
    case 422: /* dnode_list */
    case 425: /* literal_list */
    case 433: /* star_func_para_list */
    case 435: /* other_para_list */
    case 437: /* when_then_list */
    case 458: /* select_list */
    case 459: /* partition_by_clause_opt */
    case 464: /* group_by_clause_opt */
    case 467: /* partition_list */
    case 470: /* group_by_list */
    case 473: /* order_by_clause_opt */
    case 478: /* sort_specification_list */
{
#line 264 "sql.y"
 nodesDestroyList((yypminor->yy72)); 
#line 2890 "sql.c"
}
      break;
    case 364: /* alter_db_option */
    case 386: /* alter_table_option */
{
#line 237 "sql.y"
 
#line 2898 "sql.c"
}
      break;
    case 376: /* type_name */
{
#line 358 "sql.y"
 
#line 2905 "sql.c"
}
      break;
    case 442: /* compare_op */
    case 443: /* in_op */
{
#line 916 "sql.y"
 
#line 2913 "sql.c"
}
      break;
    case 455: /* join_type */
{
#line 992 "sql.y"
 
#line 2920 "sql.c"
}
      break;
    case 469: /* fill_mode */
{
#line 1067 "sql.y"
 
#line 2927 "sql.c"
}
      break;
    case 480: /* ordering_specification_opt */
{
#line 1150 "sql.y"
 
#line 2934 "sql.c"
}
      break;
    case 481: /* null_ordering_opt */
{
#line 1156 "sql.y"
 
#line 2941 "sql.c"
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<sizeof(yy_action)/sizeof(yy_action[0]) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
   335,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   335,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
   336,  /* (2) account_options ::= */
   336,  /* (3) account_options ::= account_options PPS literal */
   336,  /* (4) account_options ::= account_options TSERIES literal */
   336,  /* (5) account_options ::= account_options STORAGE literal */
   336,  /* (6) account_options ::= account_options STREAMS literal */
   336,  /* (7) account_options ::= account_options QTIME literal */
   336,  /* (8) account_options ::= account_options DBS literal */
   336,  /* (9) account_options ::= account_options USERS literal */
   336,  /* (10) account_options ::= account_options CONNS literal */
   336,  /* (11) account_options ::= account_options STATE literal */
   337,  /* (12) alter_account_options ::= alter_account_option */
   337,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   339,  /* (14) alter_account_option ::= PASS literal */
   339,  /* (15) alter_account_option ::= PPS literal */
   339,  /* (16) alter_account_option ::= TSERIES literal */
   339,  /* (17) alter_account_option ::= STORAGE literal */
   339,  /* (18) alter_account_option ::= STREAMS literal */
   339,  /* (19) alter_account_option ::= QTIME literal */
   339,  /* (20) alter_account_option ::= DBS literal */
   339,  /* (21) alter_account_option ::= USERS literal */
   339,  /* (22) alter_account_option ::= CONNS literal */
   339,  /* (23) alter_account_option ::= STATE literal */
   335,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   335,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   335,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   335,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   335,  /* (28) cmd ::= DROP USER user_name */
   341,  /* (29) sysinfo_opt ::= */
   341,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   335,  /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
   335,  /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
   342,  /* (33) privileges ::= ALL */
   342,  /* (34) privileges ::= priv_type_list */
   342,  /* (35) privileges ::= SUBSCRIBE */
   345,  /* (36) priv_type_list ::= priv_type */
   345,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   346,  /* (38) priv_type ::= READ */
   346,  /* (39) priv_type ::= WRITE */
   343,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   343,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   343,  /* (42) priv_level ::= db_name NK_DOT table_name */
   343,  /* (43) priv_level ::= topic_name */
   344,  /* (44) with_opt ::= */
   344,  /* (45) with_opt ::= WITH search_condition */
   335,  /* (46) cmd ::= CREATE DNODE dnode_endpoint */
   335,  /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   335,  /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
   335,  /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
   335,  /* (50) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   335,  /* (51) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   335,  /* (52) cmd ::= ALTER ALL DNODES NK_STRING */
   335,  /* (53) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   335,  /* (54) cmd ::= RESTORE DNODE NK_INTEGER */
   351,  /* (55) dnode_endpoint ::= NK_STRING */
   351,  /* (56) dnode_endpoint ::= NK_ID */
   351,  /* (57) dnode_endpoint ::= NK_IPTOKEN */
   352,  /* (58) force_opt ::= */
   352,  /* (59) force_opt ::= FORCE */
   335,  /* (60) cmd ::= ALTER LOCAL NK_STRING */
   335,  /* (61) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   335,  /* (62) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   335,  /* (63) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   335,  /* (64) cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
   335,  /* (65) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   335,  /* (66) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   335,  /* (67) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   335,  /* (68) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   335,  /* (69) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   335,  /* (70) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   335,  /* (71) cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
   335,  /* (72) cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
   335,  /* (73) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   335,  /* (74) cmd ::= DROP DATABASE exists_opt db_name */
   335,  /* (75) cmd ::= USE db_name */
   335,  /* (76) cmd ::= ALTER DATABASE db_name alter_db_options */
   335,  /* (77) cmd ::= FLUSH DATABASE db_name */
   335,  /* (78) cmd ::= TRIM DATABASE db_name speed_opt */
   335,  /* (79) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
   353,  /* (80) not_exists_opt ::= IF NOT EXISTS */
   353,  /* (81) not_exists_opt ::= */
   355,  /* (82) exists_opt ::= IF EXISTS */
   355,  /* (83) exists_opt ::= */
   354,  /* (84) db_options ::= */
   354,  /* (85) db_options ::= db_options BUFFER NK_INTEGER */
   354,  /* (86) db_options ::= db_options CACHEMODEL NK_STRING */
   354,  /* (87) db_options ::= db_options CACHESIZE NK_INTEGER */
   354,  /* (88) db_options ::= db_options COMP NK_INTEGER */
   354,  /* (89) db_options ::= db_options DURATION NK_INTEGER */
   354,  /* (90) db_options ::= db_options DURATION NK_VARIABLE */
   354,  /* (91) db_options ::= db_options MAXROWS NK_INTEGER */
   354,  /* (92) db_options ::= db_options MINROWS NK_INTEGER */
   354,  /* (93) db_options ::= db_options KEEP integer_list */
   354,  /* (94) db_options ::= db_options KEEP variable_list */
   354,  /* (95) db_options ::= db_options PAGES NK_INTEGER */
   354,  /* (96) db_options ::= db_options PAGESIZE NK_INTEGER */
   354,  /* (97) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   354,  /* (98) db_options ::= db_options PRECISION NK_STRING */
   354,  /* (99) db_options ::= db_options REPLICA NK_INTEGER */
   354,  /* (100) db_options ::= db_options VGROUPS NK_INTEGER */
   354,  /* (101) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   354,  /* (102) db_options ::= db_options RETENTIONS retention_list */
   354,  /* (103) db_options ::= db_options SCHEMALESS NK_INTEGER */
   354,  /* (104) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   354,  /* (105) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   354,  /* (106) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   354,  /* (107) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   354,  /* (108) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   354,  /* (109) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   354,  /* (110) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   354,  /* (111) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   354,  /* (112) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   354,  /* (113) db_options ::= db_options TABLE_PREFIX signed */
   354,  /* (114) db_options ::= db_options TABLE_SUFFIX signed */
   356,  /* (115) alter_db_options ::= alter_db_option */
   356,  /* (116) alter_db_options ::= alter_db_options alter_db_option */
   364,  /* (117) alter_db_option ::= BUFFER NK_INTEGER */
   364,  /* (118) alter_db_option ::= CACHEMODEL NK_STRING */
   364,  /* (119) alter_db_option ::= CACHESIZE NK_INTEGER */
   364,  /* (120) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   364,  /* (121) alter_db_option ::= KEEP integer_list */
   364,  /* (122) alter_db_option ::= KEEP variable_list */
   364,  /* (123) alter_db_option ::= PAGES NK_INTEGER */
   364,  /* (124) alter_db_option ::= REPLICA NK_INTEGER */
   364,  /* (125) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   364,  /* (126) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   364,  /* (127) alter_db_option ::= MINROWS NK_INTEGER */
   364,  /* (128) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
   364,  /* (129) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   364,  /* (130) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
   364,  /* (131) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   360,  /* (132) integer_list ::= NK_INTEGER */
   360,  /* (133) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   361,  /* (134) variable_list ::= NK_VARIABLE */
   361,  /* (135) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   362,  /* (136) retention_list ::= retention */
   362,  /* (137) retention_list ::= retention_list NK_COMMA retention */
   365,  /* (138) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
   357,  /* (139) speed_opt ::= */
   357,  /* (140) speed_opt ::= MAX_SPEED NK_INTEGER */
   358,  /* (141) start_opt ::= */
   358,  /* (142) start_opt ::= START WITH NK_INTEGER */
   358,  /* (143) start_opt ::= START WITH NK_STRING */
   358,  /* (144) start_opt ::= START WITH TIMESTAMP NK_STRING */
   359,  /* (145) end_opt ::= */
   359,  /* (146) end_opt ::= END WITH NK_INTEGER */
   359,  /* (147) end_opt ::= END WITH NK_STRING */
   359,  /* (148) end_opt ::= END WITH TIMESTAMP NK_STRING */
   335,  /* (149) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   335,  /* (150) cmd ::= CREATE TABLE multi_create_clause */
   335,  /* (151) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   335,  /* (152) cmd ::= DROP TABLE multi_drop_clause */
   335,  /* (153) cmd ::= DROP STABLE exists_opt full_table_name */
   335,  /* (154) cmd ::= ALTER TABLE alter_table_clause */
   335,  /* (155) cmd ::= ALTER STABLE alter_table_clause */
   373,  /* (156) alter_table_clause ::= full_table_name alter_table_options */
   373,  /* (157) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   373,  /* (158) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   373,  /* (159) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   373,  /* (160) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   373,  /* (161) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   373,  /* (162) alter_table_clause ::= full_table_name DROP TAG column_name */
   373,  /* (163) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   373,  /* (164) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   373,  /* (165) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   370,  /* (166) multi_create_clause ::= create_subtable_clause */
   370,  /* (167) multi_create_clause ::= multi_create_clause create_subtable_clause */
   378,  /* (168) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   372,  /* (169) multi_drop_clause ::= drop_table_clause */
   372,  /* (170) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
   381,  /* (171) drop_table_clause ::= exists_opt full_table_name */
   379,  /* (172) specific_cols_opt ::= */
   379,  /* (173) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   366,  /* (174) full_table_name ::= table_name */
   366,  /* (175) full_table_name ::= db_name NK_DOT table_name */
   367,  /* (176) column_def_list ::= column_def */
   367,  /* (177) column_def_list ::= column_def_list NK_COMMA column_def */
   383,  /* (178) column_def ::= column_name type_name */
   376,  /* (179) type_name ::= BOOL */
   376,  /* (180) type_name ::= TINYINT */
   376,  /* (181) type_name ::= SMALLINT */
   376,  /* (182) type_name ::= INT */
   376,  /* (183) type_name ::= INTEGER */
   376,  /* (184) type_name ::= BIGINT */
   376,  /* (185) type_name ::= FLOAT */
   376,  /* (186) type_name ::= DOUBLE */
   376,  /* (187) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   376,  /* (188) type_name ::= TIMESTAMP */
   376,  /* (189) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   376,  /* (190) type_name ::= TINYINT UNSIGNED */
   376,  /* (191) type_name ::= SMALLINT UNSIGNED */
   376,  /* (192) type_name ::= INT UNSIGNED */
   376,  /* (193) type_name ::= BIGINT UNSIGNED */
   376,  /* (194) type_name ::= JSON */
   376,  /* (195) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   376,  /* (196) type_name ::= MEDIUMBLOB */
   376,  /* (197) type_name ::= BLOB */
   376,  /* (198) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   376,  /* (199) type_name ::= DECIMAL */
   376,  /* (200) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   376,  /* (201) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
   368,  /* (202) tags_def_opt ::= */
   368,  /* (203) tags_def_opt ::= tags_def */
   371,  /* (204) tags_def ::= TAGS NK_LP column_def_list NK_RP */
   369,  /* (205) table_options ::= */
   369,  /* (206) table_options ::= table_options COMMENT NK_STRING */
   369,  /* (207) table_options ::= table_options MAX_DELAY duration_list */
   369,  /* (208) table_options ::= table_options WATERMARK duration_list */
   369,  /* (209) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   369,  /* (210) table_options ::= table_options TTL NK_INTEGER */
   369,  /* (211) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   369,  /* (212) table_options ::= table_options DELETE_MARK duration_list */
   374,  /* (213) alter_table_options ::= alter_table_option */
   374,  /* (214) alter_table_options ::= alter_table_options alter_table_option */
   386,  /* (215) alter_table_option ::= COMMENT NK_STRING */
   386,  /* (216) alter_table_option ::= TTL NK_INTEGER */
   384,  /* (217) duration_list ::= duration_literal */
   384,  /* (218) duration_list ::= duration_list NK_COMMA duration_literal */
   385,  /* (219) rollup_func_list ::= rollup_func_name */
   385,  /* (220) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   388,  /* (221) rollup_func_name ::= function_name */
   388,  /* (222) rollup_func_name ::= FIRST */
   388,  /* (223) rollup_func_name ::= LAST */
   382,  /* (224) col_name_list ::= col_name */
   382,  /* (225) col_name_list ::= col_name_list NK_COMMA col_name */
   390,  /* (226) col_name ::= column_name */
   335,  /* (227) cmd ::= SHOW DNODES */
   335,  /* (228) cmd ::= SHOW USERS */
   335,  /* (229) cmd ::= SHOW USER PRIVILEGES */
   335,  /* (230) cmd ::= SHOW DATABASES */
   335,  /* (231) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   335,  /* (232) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   335,  /* (233) cmd ::= SHOW db_name_cond_opt VGROUPS */
   335,  /* (234) cmd ::= SHOW MNODES */
   335,  /* (235) cmd ::= SHOW QNODES */
   335,  /* (236) cmd ::= SHOW FUNCTIONS */
   335,  /* (237) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   335,  /* (238) cmd ::= SHOW STREAMS */
   335,  /* (239) cmd ::= SHOW ACCOUNTS */
   335,  /* (240) cmd ::= SHOW APPS */
   335,  /* (241) cmd ::= SHOW CONNECTIONS */
   335,  /* (242) cmd ::= SHOW LICENCES */
   335,  /* (243) cmd ::= SHOW GRANTS */
   335,  /* (244) cmd ::= SHOW CREATE DATABASE db_name */
   335,  /* (245) cmd ::= SHOW CREATE TABLE full_table_name */
   335,  /* (246) cmd ::= SHOW CREATE STABLE full_table_name */
   335,  /* (247) cmd ::= SHOW QUERIES */
   335,  /* (248) cmd ::= SHOW SCORES */
   335,  /* (249) cmd ::= SHOW TOPICS */
   335,  /* (250) cmd ::= SHOW VARIABLES */
   335,  /* (251) cmd ::= SHOW CLUSTER VARIABLES */
   335,  /* (252) cmd ::= SHOW LOCAL VARIABLES */
   335,  /* (253) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   335,  /* (254) cmd ::= SHOW BNODES */
   335,  /* (255) cmd ::= SHOW SNODES */
   335,  /* (256) cmd ::= SHOW CLUSTER */
   335,  /* (257) cmd ::= SHOW TRANSACTIONS */
   335,  /* (258) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   335,  /* (259) cmd ::= SHOW CONSUMERS */
   335,  /* (260) cmd ::= SHOW SUBSCRIPTIONS */
   335,  /* (261) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   335,  /* (262) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   335,  /* (263) cmd ::= SHOW VNODES NK_INTEGER */
   335,  /* (264) cmd ::= SHOW VNODES NK_STRING */
   335,  /* (265) cmd ::= SHOW db_name_cond_opt ALIVE */
   335,  /* (266) cmd ::= SHOW CLUSTER ALIVE */
   391,  /* (267) db_name_cond_opt ::= */
   391,  /* (268) db_name_cond_opt ::= db_name NK_DOT */
   392,  /* (269) like_pattern_opt ::= */
   392,  /* (270) like_pattern_opt ::= LIKE NK_STRING */
   393,  /* (271) table_name_cond ::= table_name */
   394,  /* (272) from_db_opt ::= */
   394,  /* (273) from_db_opt ::= FROM db_name */
   395,  /* (274) tag_list_opt ::= */
   395,  /* (275) tag_list_opt ::= tag_item */
   395,  /* (276) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   396,  /* (277) tag_item ::= TBNAME */
   396,  /* (278) tag_item ::= QTAGS */
   396,  /* (279) tag_item ::= column_name */
   396,  /* (280) tag_item ::= column_name column_alias */
   396,  /* (281) tag_item ::= column_name AS column_alias */
   335,  /* (282) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
   335,  /* (283) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
   335,  /* (284) cmd ::= DROP INDEX exists_opt full_index_name */
   398,  /* (285) full_index_name ::= index_name */
   398,  /* (286) full_index_name ::= db_name NK_DOT index_name */
   399,  /* (287) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
   399,  /* (288) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   401,  /* (289) func_list ::= func */
   401,  /* (290) func_list ::= func_list NK_COMMA func */
   404,  /* (291) func ::= sma_func_name NK_LP expression_list NK_RP */
   405,  /* (292) sma_func_name ::= function_name */
   405,  /* (293) sma_func_name ::= COUNT */
   405,  /* (294) sma_func_name ::= FIRST */
   405,  /* (295) sma_func_name ::= LAST */
   405,  /* (296) sma_func_name ::= LAST_ROW */
   403,  /* (297) sma_stream_opt ::= */
   403,  /* (298) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   403,  /* (299) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   403,  /* (300) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   335,  /* (301) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   335,  /* (302) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   335,  /* (303) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   335,  /* (304) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
   335,  /* (305) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
   335,  /* (306) cmd ::= DROP TOPIC exists_opt topic_name */
   335,  /* (307) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   335,  /* (308) cmd ::= DESC full_table_name */
   335,  /* (309) cmd ::= DESCRIBE full_table_name */
   335,  /* (310) cmd ::= RESET QUERY CACHE */
   335,  /* (311) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   335,  /* (312) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
   408,  /* (313) analyze_opt ::= */
   408,  /* (314) analyze_opt ::= ANALYZE */
   409,  /* (315) explain_options ::= */
   409,  /* (316) explain_options ::= explain_options VERBOSE NK_BOOL */
   409,  /* (317) explain_options ::= explain_options RATIO NK_FLOAT */
   335,  /* (318) cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
   335,  /* (319) cmd ::= DROP FUNCTION exists_opt function_name */
   412,  /* (320) agg_func_opt ::= */
   412,  /* (321) agg_func_opt ::= AGGREGATE */
   413,  /* (322) bufsize_opt ::= */
   413,  /* (323) bufsize_opt ::= BUFSIZE NK_INTEGER */
   414,  /* (324) language_opt ::= */
   414,  /* (325) language_opt ::= LANGUAGE NK_STRING */
   411,  /* (326) or_replace_opt ::= */
   411,  /* (327) or_replace_opt ::= OR REPLACE */
   335,  /* (328) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
   335,  /* (329) cmd ::= DROP STREAM exists_opt stream_name */
   335,  /* (330) cmd ::= PAUSE STREAM exists_opt stream_name */
   335,  /* (331) cmd ::= RESUME STREAM exists_opt ignore_opt stream_name */
   417,  /* (332) col_list_opt ::= */
   417,  /* (333) col_list_opt ::= NK_LP col_name_list NK_RP */
   418,  /* (334) tag_def_or_ref_opt ::= */
   418,  /* (335) tag_def_or_ref_opt ::= tags_def */
   418,  /* (336) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
   416,  /* (337) stream_options ::= */
   416,  /* (338) stream_options ::= stream_options TRIGGER AT_ONCE */
   416,  /* (339) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   416,  /* (340) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   416,  /* (341) stream_options ::= stream_options WATERMARK duration_literal */
   416,  /* (342) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   416,  /* (343) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   416,  /* (344) stream_options ::= stream_options DELETE_MARK duration_literal */
   416,  /* (345) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
   419,  /* (346) subtable_opt ::= */
   419,  /* (347) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
   420,  /* (348) ignore_opt ::= */
   420,  /* (349) ignore_opt ::= IGNORE UNTREATED */
   335,  /* (350) cmd ::= KILL CONNECTION NK_INTEGER */
   335,  /* (351) cmd ::= KILL QUERY NK_STRING */
   335,  /* (352) cmd ::= KILL TRANSACTION NK_INTEGER */
   335,  /* (353) cmd ::= BALANCE VGROUP */
   335,  /* (354) cmd ::= BALANCE VGROUP LEADER */
   335,  /* (355) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   335,  /* (356) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   335,  /* (357) cmd ::= SPLIT VGROUP NK_INTEGER */
   422,  /* (358) dnode_list ::= DNODE NK_INTEGER */
   422,  /* (359) dnode_list ::= dnode_list DNODE NK_INTEGER */
   335,  /* (360) cmd ::= DELETE FROM full_table_name where_clause_opt */
   335,  /* (361) cmd ::= query_or_subquery */
   335,  /* (362) cmd ::= insert_query */
   410,  /* (363) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   410,  /* (364) insert_query ::= INSERT INTO full_table_name query_or_subquery */
   338,  /* (365) literal ::= NK_INTEGER */
   338,  /* (366) literal ::= NK_FLOAT */
   338,  /* (367) literal ::= NK_STRING */
   338,  /* (368) literal ::= NK_BOOL */
   338,  /* (369) literal ::= TIMESTAMP NK_STRING */
   338,  /* (370) literal ::= duration_literal */
   338,  /* (371) literal ::= NULL */
   338,  /* (372) literal ::= NK_QUESTION */
   387,  /* (373) duration_literal ::= NK_VARIABLE */
   363,  /* (374) signed ::= NK_INTEGER */
   363,  /* (375) signed ::= NK_PLUS NK_INTEGER */
   363,  /* (376) signed ::= NK_MINUS NK_INTEGER */
   363,  /* (377) signed ::= NK_FLOAT */
   363,  /* (378) signed ::= NK_PLUS NK_FLOAT */
   363,  /* (379) signed ::= NK_MINUS NK_FLOAT */
   377,  /* (380) signed_literal ::= signed */
   377,  /* (381) signed_literal ::= NK_STRING */
   377,  /* (382) signed_literal ::= NK_BOOL */
   377,  /* (383) signed_literal ::= TIMESTAMP NK_STRING */
   377,  /* (384) signed_literal ::= duration_literal */
   377,  /* (385) signed_literal ::= NULL */
   377,  /* (386) signed_literal ::= literal_func */
   377,  /* (387) signed_literal ::= NK_QUESTION */
   425,  /* (388) literal_list ::= signed_literal */
   425,  /* (389) literal_list ::= literal_list NK_COMMA signed_literal */
   347,  /* (390) db_name ::= NK_ID */
   348,  /* (391) table_name ::= NK_ID */
   375,  /* (392) column_name ::= NK_ID */
   389,  /* (393) function_name ::= NK_ID */
   426,  /* (394) table_alias ::= NK_ID */
   397,  /* (395) column_alias ::= NK_ID */
   340,  /* (396) user_name ::= NK_ID */
   349,  /* (397) topic_name ::= NK_ID */
   415,  /* (398) stream_name ::= NK_ID */
   407,  /* (399) cgroup_name ::= NK_ID */
   400,  /* (400) index_name ::= NK_ID */
   427,  /* (401) expr_or_subquery ::= expression */
   421,  /* (402) expression ::= literal */
   421,  /* (403) expression ::= pseudo_column */
   421,  /* (404) expression ::= column_reference */
   421,  /* (405) expression ::= function_expression */
   421,  /* (406) expression ::= case_when_expression */
   421,  /* (407) expression ::= NK_LP expression NK_RP */
   421,  /* (408) expression ::= NK_PLUS expr_or_subquery */
   421,  /* (409) expression ::= NK_MINUS expr_or_subquery */
   421,  /* (410) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   421,  /* (411) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   421,  /* (412) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   421,  /* (413) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   421,  /* (414) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   421,  /* (415) expression ::= column_reference NK_ARROW NK_STRING */
   421,  /* (416) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   421,  /* (417) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   380,  /* (418) expression_list ::= expr_or_subquery */
   380,  /* (419) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   429,  /* (420) column_reference ::= column_name */
   429,  /* (421) column_reference ::= table_name NK_DOT column_name */
   428,  /* (422) pseudo_column ::= ROWTS */
   428,  /* (423) pseudo_column ::= TBNAME */
   428,  /* (424) pseudo_column ::= table_name NK_DOT TBNAME */
   428,  /* (425) pseudo_column ::= QSTART */
   428,  /* (426) pseudo_column ::= QEND */
   428,  /* (427) pseudo_column ::= QDURATION */
   428,  /* (428) pseudo_column ::= WSTART */
   428,  /* (429) pseudo_column ::= WEND */
   428,  /* (430) pseudo_column ::= WDURATION */
   428,  /* (431) pseudo_column ::= IROWTS */
   428,  /* (432) pseudo_column ::= ISFILLED */
   428,  /* (433) pseudo_column ::= QTAGS */
   430,  /* (434) function_expression ::= function_name NK_LP expression_list NK_RP */
   430,  /* (435) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   430,  /* (436) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   430,  /* (437) function_expression ::= literal_func */
   424,  /* (438) literal_func ::= noarg_func NK_LP NK_RP */
   424,  /* (439) literal_func ::= NOW */
   434,  /* (440) noarg_func ::= NOW */
   434,  /* (441) noarg_func ::= TODAY */
   434,  /* (442) noarg_func ::= TIMEZONE */
   434,  /* (443) noarg_func ::= DATABASE */
   434,  /* (444) noarg_func ::= CLIENT_VERSION */
   434,  /* (445) noarg_func ::= SERVER_VERSION */
   434,  /* (446) noarg_func ::= SERVER_STATUS */
   434,  /* (447) noarg_func ::= CURRENT_USER */
   434,  /* (448) noarg_func ::= USER */
   432,  /* (449) star_func ::= COUNT */
   432,  /* (450) star_func ::= FIRST */
   432,  /* (451) star_func ::= LAST */
   432,  /* (452) star_func ::= LAST_ROW */
   433,  /* (453) star_func_para_list ::= NK_STAR */
   433,  /* (454) star_func_para_list ::= other_para_list */
   435,  /* (455) other_para_list ::= star_func_para */
   435,  /* (456) other_para_list ::= other_para_list NK_COMMA star_func_para */
   436,  /* (457) star_func_para ::= expr_or_subquery */
   436,  /* (458) star_func_para ::= table_name NK_DOT NK_STAR */
   431,  /* (459) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   431,  /* (460) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   437,  /* (461) when_then_list ::= when_then_expr */
   437,  /* (462) when_then_list ::= when_then_list when_then_expr */
   440,  /* (463) when_then_expr ::= WHEN common_expression THEN common_expression */
   438,  /* (464) case_when_else_opt ::= */
   438,  /* (465) case_when_else_opt ::= ELSE common_expression */
   441,  /* (466) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   441,  /* (467) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   441,  /* (468) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   441,  /* (469) predicate ::= expr_or_subquery IS NULL */
   441,  /* (470) predicate ::= expr_or_subquery IS NOT NULL */
   441,  /* (471) predicate ::= expr_or_subquery in_op in_predicate_value */
   442,  /* (472) compare_op ::= NK_LT */
   442,  /* (473) compare_op ::= NK_GT */
   442,  /* (474) compare_op ::= NK_LE */
   442,  /* (475) compare_op ::= NK_GE */
   442,  /* (476) compare_op ::= NK_NE */
   442,  /* (477) compare_op ::= NK_EQ */
   442,  /* (478) compare_op ::= LIKE */
   442,  /* (479) compare_op ::= NOT LIKE */
   442,  /* (480) compare_op ::= MATCH */
   442,  /* (481) compare_op ::= NMATCH */
   442,  /* (482) compare_op ::= CONTAINS */
   443,  /* (483) in_op ::= IN */
   443,  /* (484) in_op ::= NOT IN */
   444,  /* (485) in_predicate_value ::= NK_LP literal_list NK_RP */
   445,  /* (486) boolean_value_expression ::= boolean_primary */
   445,  /* (487) boolean_value_expression ::= NOT boolean_primary */
   445,  /* (488) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   445,  /* (489) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   446,  /* (490) boolean_primary ::= predicate */
   446,  /* (491) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   439,  /* (492) common_expression ::= expr_or_subquery */
   439,  /* (493) common_expression ::= boolean_value_expression */
   447,  /* (494) from_clause_opt ::= */
   447,  /* (495) from_clause_opt ::= FROM table_reference_list */
   448,  /* (496) table_reference_list ::= table_reference */
   448,  /* (497) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   449,  /* (498) table_reference ::= table_primary */
   449,  /* (499) table_reference ::= joined_table */
   450,  /* (500) table_primary ::= table_name alias_opt */
   450,  /* (501) table_primary ::= db_name NK_DOT table_name alias_opt */
   450,  /* (502) table_primary ::= subquery alias_opt */
   450,  /* (503) table_primary ::= parenthesized_joined_table */
   452,  /* (504) alias_opt ::= */
   452,  /* (505) alias_opt ::= table_alias */
   452,  /* (506) alias_opt ::= AS table_alias */
   454,  /* (507) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   454,  /* (508) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   451,  /* (509) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
   455,  /* (510) join_type ::= */
   455,  /* (511) join_type ::= INNER */
   456,  /* (512) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
   457,  /* (513) set_quantifier_opt ::= */
   457,  /* (514) set_quantifier_opt ::= DISTINCT */
   457,  /* (515) set_quantifier_opt ::= ALL */
   458,  /* (516) select_list ::= select_item */
   458,  /* (517) select_list ::= select_list NK_COMMA select_item */
   466,  /* (518) select_item ::= NK_STAR */
   466,  /* (519) select_item ::= common_expression */
   466,  /* (520) select_item ::= common_expression column_alias */
   466,  /* (521) select_item ::= common_expression AS column_alias */
   466,  /* (522) select_item ::= table_name NK_DOT NK_STAR */
   423,  /* (523) where_clause_opt ::= */
   423,  /* (524) where_clause_opt ::= WHERE search_condition */
   459,  /* (525) partition_by_clause_opt ::= */
   459,  /* (526) partition_by_clause_opt ::= PARTITION BY partition_list */
   467,  /* (527) partition_list ::= partition_item */
   467,  /* (528) partition_list ::= partition_list NK_COMMA partition_item */
   468,  /* (529) partition_item ::= expr_or_subquery */
   468,  /* (530) partition_item ::= expr_or_subquery column_alias */
   468,  /* (531) partition_item ::= expr_or_subquery AS column_alias */
   463,  /* (532) twindow_clause_opt ::= */
   463,  /* (533) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   463,  /* (534) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   463,  /* (535) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   463,  /* (536) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   463,  /* (537) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
   402,  /* (538) sliding_opt ::= */
   402,  /* (539) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
   462,  /* (540) fill_opt ::= */
   462,  /* (541) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   462,  /* (542) fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
   462,  /* (543) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
   469,  /* (544) fill_mode ::= NONE */
   469,  /* (545) fill_mode ::= PREV */
   469,  /* (546) fill_mode ::= NULL */
   469,  /* (547) fill_mode ::= NULL_F */
   469,  /* (548) fill_mode ::= LINEAR */
   469,  /* (549) fill_mode ::= NEXT */
   464,  /* (550) group_by_clause_opt ::= */
   464,  /* (551) group_by_clause_opt ::= GROUP BY group_by_list */
   470,  /* (552) group_by_list ::= expr_or_subquery */
   470,  /* (553) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
   465,  /* (554) having_clause_opt ::= */
   465,  /* (555) having_clause_opt ::= HAVING search_condition */
   460,  /* (556) range_opt ::= */
   460,  /* (557) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
   461,  /* (558) every_opt ::= */
   461,  /* (559) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   471,  /* (560) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   472,  /* (561) query_simple ::= query_specification */
   472,  /* (562) query_simple ::= union_query_expression */
   476,  /* (563) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   476,  /* (564) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   477,  /* (565) query_simple_or_subquery ::= query_simple */
   477,  /* (566) query_simple_or_subquery ::= subquery */
   406,  /* (567) query_or_subquery ::= query_expression */
   406,  /* (568) query_or_subquery ::= subquery */
   473,  /* (569) order_by_clause_opt ::= */
   473,  /* (570) order_by_clause_opt ::= ORDER BY sort_specification_list */
   474,  /* (571) slimit_clause_opt ::= */
   474,  /* (572) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   474,  /* (573) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   474,  /* (574) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   475,  /* (575) limit_clause_opt ::= */
   475,  /* (576) limit_clause_opt ::= LIMIT NK_INTEGER */
   475,  /* (577) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   475,  /* (578) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   453,  /* (579) subquery ::= NK_LP query_expression NK_RP */
   453,  /* (580) subquery ::= NK_LP subquery NK_RP */
   350,  /* (581) search_condition ::= common_expression */
   478,  /* (582) sort_specification_list ::= sort_specification */
   478,  /* (583) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   479,  /* (584) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
   480,  /* (585) ordering_specification_opt ::= */
   480,  /* (586) ordering_specification_opt ::= ASC */
   480,  /* (587) ordering_specification_opt ::= DESC */
   481,  /* (588) null_ordering_opt ::= */
   481,  /* (589) null_ordering_opt ::= NULLS FIRST */
   481,  /* (590) null_ordering_opt ::= NULLS LAST */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -6,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   -4,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
    0,  /* (2) account_options ::= */
   -3,  /* (3) account_options ::= account_options PPS literal */
   -3,  /* (4) account_options ::= account_options TSERIES literal */
   -3,  /* (5) account_options ::= account_options STORAGE literal */
   -3,  /* (6) account_options ::= account_options STREAMS literal */
   -3,  /* (7) account_options ::= account_options QTIME literal */
   -3,  /* (8) account_options ::= account_options DBS literal */
   -3,  /* (9) account_options ::= account_options USERS literal */
   -3,  /* (10) account_options ::= account_options CONNS literal */
   -3,  /* (11) account_options ::= account_options STATE literal */
   -1,  /* (12) alter_account_options ::= alter_account_option */
   -2,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   -2,  /* (14) alter_account_option ::= PASS literal */
   -2,  /* (15) alter_account_option ::= PPS literal */
   -2,  /* (16) alter_account_option ::= TSERIES literal */
   -2,  /* (17) alter_account_option ::= STORAGE literal */
   -2,  /* (18) alter_account_option ::= STREAMS literal */
   -2,  /* (19) alter_account_option ::= QTIME literal */
   -2,  /* (20) alter_account_option ::= DBS literal */
   -2,  /* (21) alter_account_option ::= USERS literal */
   -2,  /* (22) alter_account_option ::= CONNS literal */
   -2,  /* (23) alter_account_option ::= STATE literal */
   -6,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   -5,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   -5,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   -5,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   -3,  /* (28) cmd ::= DROP USER user_name */
    0,  /* (29) sysinfo_opt ::= */
   -2,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   -7,  /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
   -7,  /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
   -1,  /* (33) privileges ::= ALL */
   -1,  /* (34) privileges ::= priv_type_list */
   -1,  /* (35) privileges ::= SUBSCRIBE */
   -1,  /* (36) priv_type_list ::= priv_type */
   -3,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   -1,  /* (38) priv_type ::= READ */
   -1,  /* (39) priv_type ::= WRITE */
   -3,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   -3,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   -3,  /* (42) priv_level ::= db_name NK_DOT table_name */
   -1,  /* (43) priv_level ::= topic_name */
    0,  /* (44) with_opt ::= */
   -2,  /* (45) with_opt ::= WITH search_condition */
   -3,  /* (46) cmd ::= CREATE DNODE dnode_endpoint */
   -5,  /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   -4,  /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
   -4,  /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
   -4,  /* (50) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   -5,  /* (51) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   -4,  /* (52) cmd ::= ALTER ALL DNODES NK_STRING */
   -5,  /* (53) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   -3,  /* (54) cmd ::= RESTORE DNODE NK_INTEGER */
   -1,  /* (55) dnode_endpoint ::= NK_STRING */
   -1,  /* (56) dnode_endpoint ::= NK_ID */
   -1,  /* (57) dnode_endpoint ::= NK_IPTOKEN */
    0,  /* (58) force_opt ::= */
   -1,  /* (59) force_opt ::= FORCE */
   -3,  /* (60) cmd ::= ALTER LOCAL NK_STRING */
   -4,  /* (61) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   -5,  /* (62) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   -5,  /* (63) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   -5,  /* (64) cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
   -5,  /* (65) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   -5,  /* (66) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   -5,  /* (67) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   -5,  /* (68) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   -5,  /* (69) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   -5,  /* (70) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   -5,  /* (71) cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
   -5,  /* (72) cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
   -5,  /* (73) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   -4,  /* (74) cmd ::= DROP DATABASE exists_opt db_name */
   -2,  /* (75) cmd ::= USE db_name */
   -4,  /* (76) cmd ::= ALTER DATABASE db_name alter_db_options */
   -3,  /* (77) cmd ::= FLUSH DATABASE db_name */
   -4,  /* (78) cmd ::= TRIM DATABASE db_name speed_opt */
   -5,  /* (79) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
   -3,  /* (80) not_exists_opt ::= IF NOT EXISTS */
    0,  /* (81) not_exists_opt ::= */
   -2,  /* (82) exists_opt ::= IF EXISTS */
    0,  /* (83) exists_opt ::= */
    0,  /* (84) db_options ::= */
   -3,  /* (85) db_options ::= db_options BUFFER NK_INTEGER */
   -3,  /* (86) db_options ::= db_options CACHEMODEL NK_STRING */
   -3,  /* (87) db_options ::= db_options CACHESIZE NK_INTEGER */
   -3,  /* (88) db_options ::= db_options COMP NK_INTEGER */
   -3,  /* (89) db_options ::= db_options DURATION NK_INTEGER */
   -3,  /* (90) db_options ::= db_options DURATION NK_VARIABLE */
   -3,  /* (91) db_options ::= db_options MAXROWS NK_INTEGER */
   -3,  /* (92) db_options ::= db_options MINROWS NK_INTEGER */
   -3,  /* (93) db_options ::= db_options KEEP integer_list */
   -3,  /* (94) db_options ::= db_options KEEP variable_list */
   -3,  /* (95) db_options ::= db_options PAGES NK_INTEGER */
   -3,  /* (96) db_options ::= db_options PAGESIZE NK_INTEGER */
   -3,  /* (97) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   -3,  /* (98) db_options ::= db_options PRECISION NK_STRING */
   -3,  /* (99) db_options ::= db_options REPLICA NK_INTEGER */
   -3,  /* (100) db_options ::= db_options VGROUPS NK_INTEGER */
   -3,  /* (101) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   -3,  /* (102) db_options ::= db_options RETENTIONS retention_list */
   -3,  /* (103) db_options ::= db_options SCHEMALESS NK_INTEGER */
   -3,  /* (104) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   -3,  /* (105) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   -3,  /* (106) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   -4,  /* (107) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -3,  /* (108) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   -4,  /* (109) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -3,  /* (110) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   -3,  /* (111) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   -3,  /* (112) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   -3,  /* (113) db_options ::= db_options TABLE_PREFIX signed */
   -3,  /* (114) db_options ::= db_options TABLE_SUFFIX signed */
   -1,  /* (115) alter_db_options ::= alter_db_option */
   -2,  /* (116) alter_db_options ::= alter_db_options alter_db_option */
   -2,  /* (117) alter_db_option ::= BUFFER NK_INTEGER */
   -2,  /* (118) alter_db_option ::= CACHEMODEL NK_STRING */
   -2,  /* (119) alter_db_option ::= CACHESIZE NK_INTEGER */
   -2,  /* (120) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   -2,  /* (121) alter_db_option ::= KEEP integer_list */
   -2,  /* (122) alter_db_option ::= KEEP variable_list */
   -2,  /* (123) alter_db_option ::= PAGES NK_INTEGER */
   -2,  /* (124) alter_db_option ::= REPLICA NK_INTEGER */
   -2,  /* (125) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   -2,  /* (126) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   -2,  /* (127) alter_db_option ::= MINROWS NK_INTEGER */
   -2,  /* (128) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
   -3,  /* (129) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -2,  /* (130) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
   -3,  /* (131) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -1,  /* (132) integer_list ::= NK_INTEGER */
   -3,  /* (133) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   -1,  /* (134) variable_list ::= NK_VARIABLE */
   -3,  /* (135) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   -1,  /* (136) retention_list ::= retention */
   -3,  /* (137) retention_list ::= retention_list NK_COMMA retention */
   -3,  /* (138) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
    0,  /* (139) speed_opt ::= */
   -2,  /* (140) speed_opt ::= MAX_SPEED NK_INTEGER */
    0,  /* (141) start_opt ::= */
   -3,  /* (142) start_opt ::= START WITH NK_INTEGER */
   -3,  /* (143) start_opt ::= START WITH NK_STRING */
   -4,  /* (144) start_opt ::= START WITH TIMESTAMP NK_STRING */
    0,  /* (145) end_opt ::= */
   -3,  /* (146) end_opt ::= END WITH NK_INTEGER */
   -3,  /* (147) end_opt ::= END WITH NK_STRING */
   -4,  /* (148) end_opt ::= END WITH TIMESTAMP NK_STRING */
   -9,  /* (149) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   -3,  /* (150) cmd ::= CREATE TABLE multi_create_clause */
   -9,  /* (151) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   -3,  /* (152) cmd ::= DROP TABLE multi_drop_clause */
   -4,  /* (153) cmd ::= DROP STABLE exists_opt full_table_name */
   -3,  /* (154) cmd ::= ALTER TABLE alter_table_clause */
   -3,  /* (155) cmd ::= ALTER STABLE alter_table_clause */
   -2,  /* (156) alter_table_clause ::= full_table_name alter_table_options */
   -5,  /* (157) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   -4,  /* (158) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   -5,  /* (159) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   -5,  /* (160) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   -5,  /* (161) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   -4,  /* (162) alter_table_clause ::= full_table_name DROP TAG column_name */
   -5,  /* (163) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   -5,  /* (164) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   -6,  /* (165) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   -1,  /* (166) multi_create_clause ::= create_subtable_clause */
   -2,  /* (167) multi_create_clause ::= multi_create_clause create_subtable_clause */
  -10,  /* (168) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   -1,  /* (169) multi_drop_clause ::= drop_table_clause */
   -3,  /* (170) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
   -2,  /* (171) drop_table_clause ::= exists_opt full_table_name */
    0,  /* (172) specific_cols_opt ::= */
   -3,  /* (173) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   -1,  /* (174) full_table_name ::= table_name */
   -3,  /* (175) full_table_name ::= db_name NK_DOT table_name */
   -1,  /* (176) column_def_list ::= column_def */
   -3,  /* (177) column_def_list ::= column_def_list NK_COMMA column_def */
   -2,  /* (178) column_def ::= column_name type_name */
   -1,  /* (179) type_name ::= BOOL */
   -1,  /* (180) type_name ::= TINYINT */
   -1,  /* (181) type_name ::= SMALLINT */
   -1,  /* (182) type_name ::= INT */
   -1,  /* (183) type_name ::= INTEGER */
   -1,  /* (184) type_name ::= BIGINT */
   -1,  /* (185) type_name ::= FLOAT */
   -1,  /* (186) type_name ::= DOUBLE */
   -4,  /* (187) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (188) type_name ::= TIMESTAMP */
   -4,  /* (189) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   -2,  /* (190) type_name ::= TINYINT UNSIGNED */
   -2,  /* (191) type_name ::= SMALLINT UNSIGNED */
   -2,  /* (192) type_name ::= INT UNSIGNED */
   -2,  /* (193) type_name ::= BIGINT UNSIGNED */
   -1,  /* (194) type_name ::= JSON */
   -4,  /* (195) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   -1,  /* (196) type_name ::= MEDIUMBLOB */
   -1,  /* (197) type_name ::= BLOB */
   -4,  /* (198) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (199) type_name ::= DECIMAL */
   -4,  /* (200) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   -6,  /* (201) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
    0,  /* (202) tags_def_opt ::= */
   -1,  /* (203) tags_def_opt ::= tags_def */
   -4,  /* (204) tags_def ::= TAGS NK_LP column_def_list NK_RP */
    0,  /* (205) table_options ::= */
   -3,  /* (206) table_options ::= table_options COMMENT NK_STRING */
   -3,  /* (207) table_options ::= table_options MAX_DELAY duration_list */
   -3,  /* (208) table_options ::= table_options WATERMARK duration_list */
   -5,  /* (209) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   -3,  /* (210) table_options ::= table_options TTL NK_INTEGER */
   -5,  /* (211) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   -3,  /* (212) table_options ::= table_options DELETE_MARK duration_list */
   -1,  /* (213) alter_table_options ::= alter_table_option */
   -2,  /* (214) alter_table_options ::= alter_table_options alter_table_option */
   -2,  /* (215) alter_table_option ::= COMMENT NK_STRING */
   -2,  /* (216) alter_table_option ::= TTL NK_INTEGER */
   -1,  /* (217) duration_list ::= duration_literal */
   -3,  /* (218) duration_list ::= duration_list NK_COMMA duration_literal */
   -1,  /* (219) rollup_func_list ::= rollup_func_name */
   -3,  /* (220) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   -1,  /* (221) rollup_func_name ::= function_name */
   -1,  /* (222) rollup_func_name ::= FIRST */
   -1,  /* (223) rollup_func_name ::= LAST */
   -1,  /* (224) col_name_list ::= col_name */
   -3,  /* (225) col_name_list ::= col_name_list NK_COMMA col_name */
   -1,  /* (226) col_name ::= column_name */
   -2,  /* (227) cmd ::= SHOW DNODES */
   -2,  /* (228) cmd ::= SHOW USERS */
   -3,  /* (229) cmd ::= SHOW USER PRIVILEGES */
   -2,  /* (230) cmd ::= SHOW DATABASES */
   -4,  /* (231) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   -4,  /* (232) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   -3,  /* (233) cmd ::= SHOW db_name_cond_opt VGROUPS */
   -2,  /* (234) cmd ::= SHOW MNODES */
   -2,  /* (235) cmd ::= SHOW QNODES */
   -2,  /* (236) cmd ::= SHOW FUNCTIONS */
   -5,  /* (237) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   -2,  /* (238) cmd ::= SHOW STREAMS */
   -2,  /* (239) cmd ::= SHOW ACCOUNTS */
   -2,  /* (240) cmd ::= SHOW APPS */
   -2,  /* (241) cmd ::= SHOW CONNECTIONS */
   -2,  /* (242) cmd ::= SHOW LICENCES */
   -2,  /* (243) cmd ::= SHOW GRANTS */
   -4,  /* (244) cmd ::= SHOW CREATE DATABASE db_name */
   -4,  /* (245) cmd ::= SHOW CREATE TABLE full_table_name */
   -4,  /* (246) cmd ::= SHOW CREATE STABLE full_table_name */
   -2,  /* (247) cmd ::= SHOW QUERIES */
   -2,  /* (248) cmd ::= SHOW SCORES */
   -2,  /* (249) cmd ::= SHOW TOPICS */
   -2,  /* (250) cmd ::= SHOW VARIABLES */
   -3,  /* (251) cmd ::= SHOW CLUSTER VARIABLES */
   -3,  /* (252) cmd ::= SHOW LOCAL VARIABLES */
   -5,  /* (253) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   -2,  /* (254) cmd ::= SHOW BNODES */
   -2,  /* (255) cmd ::= SHOW SNODES */
   -2,  /* (256) cmd ::= SHOW CLUSTER */
   -2,  /* (257) cmd ::= SHOW TRANSACTIONS */
   -4,  /* (258) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   -2,  /* (259) cmd ::= SHOW CONSUMERS */
   -2,  /* (260) cmd ::= SHOW SUBSCRIPTIONS */
   -5,  /* (261) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   -7,  /* (262) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   -3,  /* (263) cmd ::= SHOW VNODES NK_INTEGER */
   -3,  /* (264) cmd ::= SHOW VNODES NK_STRING */
   -3,  /* (265) cmd ::= SHOW db_name_cond_opt ALIVE */
   -3,  /* (266) cmd ::= SHOW CLUSTER ALIVE */
    0,  /* (267) db_name_cond_opt ::= */
   -2,  /* (268) db_name_cond_opt ::= db_name NK_DOT */
    0,  /* (269) like_pattern_opt ::= */
   -2,  /* (270) like_pattern_opt ::= LIKE NK_STRING */
   -1,  /* (271) table_name_cond ::= table_name */
    0,  /* (272) from_db_opt ::= */
   -2,  /* (273) from_db_opt ::= FROM db_name */
    0,  /* (274) tag_list_opt ::= */
   -1,  /* (275) tag_list_opt ::= tag_item */
   -3,  /* (276) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   -1,  /* (277) tag_item ::= TBNAME */
   -1,  /* (278) tag_item ::= QTAGS */
   -1,  /* (279) tag_item ::= column_name */
   -2,  /* (280) tag_item ::= column_name column_alias */
   -3,  /* (281) tag_item ::= column_name AS column_alias */
   -8,  /* (282) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
   -9,  /* (283) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
   -4,  /* (284) cmd ::= DROP INDEX exists_opt full_index_name */
   -1,  /* (285) full_index_name ::= index_name */
   -3,  /* (286) full_index_name ::= db_name NK_DOT index_name */
  -10,  /* (287) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  -12,  /* (288) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   -1,  /* (289) func_list ::= func */
   -3,  /* (290) func_list ::= func_list NK_COMMA func */
   -4,  /* (291) func ::= sma_func_name NK_LP expression_list NK_RP */
   -1,  /* (292) sma_func_name ::= function_name */
   -1,  /* (293) sma_func_name ::= COUNT */
   -1,  /* (294) sma_func_name ::= FIRST */
   -1,  /* (295) sma_func_name ::= LAST */
   -1,  /* (296) sma_func_name ::= LAST_ROW */
    0,  /* (297) sma_stream_opt ::= */
   -3,  /* (298) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   -3,  /* (299) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   -3,  /* (300) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   -6,  /* (301) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   -7,  /* (302) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   -9,  /* (303) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   -7,  /* (304) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
   -9,  /* (305) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
   -4,  /* (306) cmd ::= DROP TOPIC exists_opt topic_name */
   -7,  /* (307) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   -2,  /* (308) cmd ::= DESC full_table_name */
   -2,  /* (309) cmd ::= DESCRIBE full_table_name */
   -3,  /* (310) cmd ::= RESET QUERY CACHE */
   -4,  /* (311) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   -4,  /* (312) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
    0,  /* (313) analyze_opt ::= */
   -1,  /* (314) analyze_opt ::= ANALYZE */
    0,  /* (315) explain_options ::= */
   -3,  /* (316) explain_options ::= explain_options VERBOSE NK_BOOL */
   -3,  /* (317) explain_options ::= explain_options RATIO NK_FLOAT */
  -12,  /* (318) cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
   -4,  /* (319) cmd ::= DROP FUNCTION exists_opt function_name */
    0,  /* (320) agg_func_opt ::= */
   -1,  /* (321) agg_func_opt ::= AGGREGATE */
    0,  /* (322) bufsize_opt ::= */
   -2,  /* (323) bufsize_opt ::= BUFSIZE NK_INTEGER */
    0,  /* (324) language_opt ::= */
   -2,  /* (325) language_opt ::= LANGUAGE NK_STRING */
    0,  /* (326) or_replace_opt ::= */
   -2,  /* (327) or_replace_opt ::= OR REPLACE */
  -12,  /* (328) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
   -4,  /* (329) cmd ::= DROP STREAM exists_opt stream_name */
   -4,  /* (330) cmd ::= PAUSE STREAM exists_opt stream_name */
   -5,  /* (331) cmd ::= RESUME STREAM exists_opt ignore_opt stream_name */
    0,  /* (332) col_list_opt ::= */
   -3,  /* (333) col_list_opt ::= NK_LP col_name_list NK_RP */
    0,  /* (334) tag_def_or_ref_opt ::= */
   -1,  /* (335) tag_def_or_ref_opt ::= tags_def */
   -4,  /* (336) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
    0,  /* (337) stream_options ::= */
   -3,  /* (338) stream_options ::= stream_options TRIGGER AT_ONCE */
   -3,  /* (339) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   -4,  /* (340) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   -3,  /* (341) stream_options ::= stream_options WATERMARK duration_literal */
   -4,  /* (342) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   -3,  /* (343) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   -3,  /* (344) stream_options ::= stream_options DELETE_MARK duration_literal */
   -4,  /* (345) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
    0,  /* (346) subtable_opt ::= */
   -4,  /* (347) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
    0,  /* (348) ignore_opt ::= */
   -2,  /* (349) ignore_opt ::= IGNORE UNTREATED */
   -3,  /* (350) cmd ::= KILL CONNECTION NK_INTEGER */
   -3,  /* (351) cmd ::= KILL QUERY NK_STRING */
   -3,  /* (352) cmd ::= KILL TRANSACTION NK_INTEGER */
   -2,  /* (353) cmd ::= BALANCE VGROUP */
   -3,  /* (354) cmd ::= BALANCE VGROUP LEADER */
   -4,  /* (355) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   -4,  /* (356) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   -3,  /* (357) cmd ::= SPLIT VGROUP NK_INTEGER */
   -2,  /* (358) dnode_list ::= DNODE NK_INTEGER */
   -3,  /* (359) dnode_list ::= dnode_list DNODE NK_INTEGER */
   -4,  /* (360) cmd ::= DELETE FROM full_table_name where_clause_opt */
   -1,  /* (361) cmd ::= query_or_subquery */
   -1,  /* (362) cmd ::= insert_query */
   -7,  /* (363) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   -4,  /* (364) insert_query ::= INSERT INTO full_table_name query_or_subquery */
   -1,  /* (365) literal ::= NK_INTEGER */
   -1,  /* (366) literal ::= NK_FLOAT */
   -1,  /* (367) literal ::= NK_STRING */
   -1,  /* (368) literal ::= NK_BOOL */
   -2,  /* (369) literal ::= TIMESTAMP NK_STRING */
   -1,  /* (370) literal ::= duration_literal */
   -1,  /* (371) literal ::= NULL */
   -1,  /* (372) literal ::= NK_QUESTION */
   -1,  /* (373) duration_literal ::= NK_VARIABLE */
   -1,  /* (374) signed ::= NK_INTEGER */
   -2,  /* (375) signed ::= NK_PLUS NK_INTEGER */
   -2,  /* (376) signed ::= NK_MINUS NK_INTEGER */
   -1,  /* (377) signed ::= NK_FLOAT */
   -2,  /* (378) signed ::= NK_PLUS NK_FLOAT */
   -2,  /* (379) signed ::= NK_MINUS NK_FLOAT */
   -1,  /* (380) signed_literal ::= signed */
   -1,  /* (381) signed_literal ::= NK_STRING */
   -1,  /* (382) signed_literal ::= NK_BOOL */
   -2,  /* (383) signed_literal ::= TIMESTAMP NK_STRING */
   -1,  /* (384) signed_literal ::= duration_literal */
   -1,  /* (385) signed_literal ::= NULL */
   -1,  /* (386) signed_literal ::= literal_func */
   -1,  /* (387) signed_literal ::= NK_QUESTION */
   -1,  /* (388) literal_list ::= signed_literal */
   -3,  /* (389) literal_list ::= literal_list NK_COMMA signed_literal */
   -1,  /* (390) db_name ::= NK_ID */
   -1,  /* (391) table_name ::= NK_ID */
   -1,  /* (392) column_name ::= NK_ID */
   -1,  /* (393) function_name ::= NK_ID */
   -1,  /* (394) table_alias ::= NK_ID */
   -1,  /* (395) column_alias ::= NK_ID */
   -1,  /* (396) user_name ::= NK_ID */
   -1,  /* (397) topic_name ::= NK_ID */
   -1,  /* (398) stream_name ::= NK_ID */
   -1,  /* (399) cgroup_name ::= NK_ID */
   -1,  /* (400) index_name ::= NK_ID */
   -1,  /* (401) expr_or_subquery ::= expression */
   -1,  /* (402) expression ::= literal */
   -1,  /* (403) expression ::= pseudo_column */
   -1,  /* (404) expression ::= column_reference */
   -1,  /* (405) expression ::= function_expression */
   -1,  /* (406) expression ::= case_when_expression */
   -3,  /* (407) expression ::= NK_LP expression NK_RP */
   -2,  /* (408) expression ::= NK_PLUS expr_or_subquery */
   -2,  /* (409) expression ::= NK_MINUS expr_or_subquery */
   -3,  /* (410) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   -3,  /* (411) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   -3,  /* (412) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   -3,  /* (413) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   -3,  /* (414) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   -3,  /* (415) expression ::= column_reference NK_ARROW NK_STRING */
   -3,  /* (416) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   -3,  /* (417) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   -1,  /* (418) expression_list ::= expr_or_subquery */
   -3,  /* (419) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   -1,  /* (420) column_reference ::= column_name */
   -3,  /* (421) column_reference ::= table_name NK_DOT column_name */
   -1,  /* (422) pseudo_column ::= ROWTS */
   -1,  /* (423) pseudo_column ::= TBNAME */
   -3,  /* (424) pseudo_column ::= table_name NK_DOT TBNAME */
   -1,  /* (425) pseudo_column ::= QSTART */
   -1,  /* (426) pseudo_column ::= QEND */
   -1,  /* (427) pseudo_column ::= QDURATION */
   -1,  /* (428) pseudo_column ::= WSTART */
   -1,  /* (429) pseudo_column ::= WEND */
   -1,  /* (430) pseudo_column ::= WDURATION */
   -1,  /* (431) pseudo_column ::= IROWTS */
   -1,  /* (432) pseudo_column ::= ISFILLED */
   -1,  /* (433) pseudo_column ::= QTAGS */
   -4,  /* (434) function_expression ::= function_name NK_LP expression_list NK_RP */
   -4,  /* (435) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   -6,  /* (436) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   -1,  /* (437) function_expression ::= literal_func */
   -3,  /* (438) literal_func ::= noarg_func NK_LP NK_RP */
   -1,  /* (439) literal_func ::= NOW */
   -1,  /* (440) noarg_func ::= NOW */
   -1,  /* (441) noarg_func ::= TODAY */
   -1,  /* (442) noarg_func ::= TIMEZONE */
   -1,  /* (443) noarg_func ::= DATABASE */
   -1,  /* (444) noarg_func ::= CLIENT_VERSION */
   -1,  /* (445) noarg_func ::= SERVER_VERSION */
   -1,  /* (446) noarg_func ::= SERVER_STATUS */
   -1,  /* (447) noarg_func ::= CURRENT_USER */
   -1,  /* (448) noarg_func ::= USER */
   -1,  /* (449) star_func ::= COUNT */
   -1,  /* (450) star_func ::= FIRST */
   -1,  /* (451) star_func ::= LAST */
   -1,  /* (452) star_func ::= LAST_ROW */
   -1,  /* (453) star_func_para_list ::= NK_STAR */
   -1,  /* (454) star_func_para_list ::= other_para_list */
   -1,  /* (455) other_para_list ::= star_func_para */
   -3,  /* (456) other_para_list ::= other_para_list NK_COMMA star_func_para */
   -1,  /* (457) star_func_para ::= expr_or_subquery */
   -3,  /* (458) star_func_para ::= table_name NK_DOT NK_STAR */
   -4,  /* (459) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   -5,  /* (460) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   -1,  /* (461) when_then_list ::= when_then_expr */
   -2,  /* (462) when_then_list ::= when_then_list when_then_expr */
   -4,  /* (463) when_then_expr ::= WHEN common_expression THEN common_expression */
    0,  /* (464) case_when_else_opt ::= */
   -2,  /* (465) case_when_else_opt ::= ELSE common_expression */
   -3,  /* (466) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   -5,  /* (467) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   -6,  /* (468) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   -3,  /* (469) predicate ::= expr_or_subquery IS NULL */
   -4,  /* (470) predicate ::= expr_or_subquery IS NOT NULL */
   -3,  /* (471) predicate ::= expr_or_subquery in_op in_predicate_value */
   -1,  /* (472) compare_op ::= NK_LT */
   -1,  /* (473) compare_op ::= NK_GT */
   -1,  /* (474) compare_op ::= NK_LE */
   -1,  /* (475) compare_op ::= NK_GE */
   -1,  /* (476) compare_op ::= NK_NE */
   -1,  /* (477) compare_op ::= NK_EQ */
   -1,  /* (478) compare_op ::= LIKE */
   -2,  /* (479) compare_op ::= NOT LIKE */
   -1,  /* (480) compare_op ::= MATCH */
   -1,  /* (481) compare_op ::= NMATCH */
   -1,  /* (482) compare_op ::= CONTAINS */
   -1,  /* (483) in_op ::= IN */
   -2,  /* (484) in_op ::= NOT IN */
   -3,  /* (485) in_predicate_value ::= NK_LP literal_list NK_RP */
   -1,  /* (486) boolean_value_expression ::= boolean_primary */
   -2,  /* (487) boolean_value_expression ::= NOT boolean_primary */
   -3,  /* (488) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   -3,  /* (489) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   -1,  /* (490) boolean_primary ::= predicate */
   -3,  /* (491) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   -1,  /* (492) common_expression ::= expr_or_subquery */
   -1,  /* (493) common_expression ::= boolean_value_expression */
    0,  /* (494) from_clause_opt ::= */
   -2,  /* (495) from_clause_opt ::= FROM table_reference_list */
   -1,  /* (496) table_reference_list ::= table_reference */
   -3,  /* (497) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   -1,  /* (498) table_reference ::= table_primary */
   -1,  /* (499) table_reference ::= joined_table */
   -2,  /* (500) table_primary ::= table_name alias_opt */
   -4,  /* (501) table_primary ::= db_name NK_DOT table_name alias_opt */
   -2,  /* (502) table_primary ::= subquery alias_opt */
   -1,  /* (503) table_primary ::= parenthesized_joined_table */
    0,  /* (504) alias_opt ::= */
   -1,  /* (505) alias_opt ::= table_alias */
   -2,  /* (506) alias_opt ::= AS table_alias */
   -3,  /* (507) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   -3,  /* (508) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   -6,  /* (509) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
    0,  /* (510) join_type ::= */
   -1,  /* (511) join_type ::= INNER */
  -12,  /* (512) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
    0,  /* (513) set_quantifier_opt ::= */
   -1,  /* (514) set_quantifier_opt ::= DISTINCT */
   -1,  /* (515) set_quantifier_opt ::= ALL */
   -1,  /* (516) select_list ::= select_item */
   -3,  /* (517) select_list ::= select_list NK_COMMA select_item */
   -1,  /* (518) select_item ::= NK_STAR */
   -1,  /* (519) select_item ::= common_expression */
   -2,  /* (520) select_item ::= common_expression column_alias */
   -3,  /* (521) select_item ::= common_expression AS column_alias */
   -3,  /* (522) select_item ::= table_name NK_DOT NK_STAR */
    0,  /* (523) where_clause_opt ::= */
   -2,  /* (524) where_clause_opt ::= WHERE search_condition */
    0,  /* (525) partition_by_clause_opt ::= */
   -3,  /* (526) partition_by_clause_opt ::= PARTITION BY partition_list */
   -1,  /* (527) partition_list ::= partition_item */
   -3,  /* (528) partition_list ::= partition_list NK_COMMA partition_item */
   -1,  /* (529) partition_item ::= expr_or_subquery */
   -2,  /* (530) partition_item ::= expr_or_subquery column_alias */
   -3,  /* (531) partition_item ::= expr_or_subquery AS column_alias */
    0,  /* (532) twindow_clause_opt ::= */
   -6,  /* (533) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   -4,  /* (534) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   -6,  /* (535) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   -8,  /* (536) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   -7,  /* (537) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
    0,  /* (538) sliding_opt ::= */
   -4,  /* (539) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
    0,  /* (540) fill_opt ::= */
   -4,  /* (541) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   -6,  /* (542) fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
   -6,  /* (543) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
   -1,  /* (544) fill_mode ::= NONE */
   -1,  /* (545) fill_mode ::= PREV */
   -1,  /* (546) fill_mode ::= NULL */
   -1,  /* (547) fill_mode ::= NULL_F */
   -1,  /* (548) fill_mode ::= LINEAR */
   -1,  /* (549) fill_mode ::= NEXT */
    0,  /* (550) group_by_clause_opt ::= */
   -3,  /* (551) group_by_clause_opt ::= GROUP BY group_by_list */
   -1,  /* (552) group_by_list ::= expr_or_subquery */
   -3,  /* (553) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
    0,  /* (554) having_clause_opt ::= */
   -2,  /* (555) having_clause_opt ::= HAVING search_condition */
    0,  /* (556) range_opt ::= */
   -6,  /* (557) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
    0,  /* (558) every_opt ::= */
   -4,  /* (559) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   -4,  /* (560) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   -1,  /* (561) query_simple ::= query_specification */
   -1,  /* (562) query_simple ::= union_query_expression */
   -4,  /* (563) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   -3,  /* (564) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   -1,  /* (565) query_simple_or_subquery ::= query_simple */
   -1,  /* (566) query_simple_or_subquery ::= subquery */
   -1,  /* (567) query_or_subquery ::= query_expression */
   -1,  /* (568) query_or_subquery ::= subquery */
    0,  /* (569) order_by_clause_opt ::= */
   -3,  /* (570) order_by_clause_opt ::= ORDER BY sort_specification_list */
    0,  /* (571) slimit_clause_opt ::= */
   -2,  /* (572) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   -4,  /* (573) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   -4,  /* (574) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
    0,  /* (575) limit_clause_opt ::= */
   -2,  /* (576) limit_clause_opt ::= LIMIT NK_INTEGER */
   -4,  /* (577) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   -4,  /* (578) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   -3,  /* (579) subquery ::= NK_LP query_expression NK_RP */
   -3,  /* (580) subquery ::= NK_LP subquery NK_RP */
   -1,  /* (581) search_condition ::= common_expression */
   -1,  /* (582) sort_specification_list ::= sort_specification */
   -3,  /* (583) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   -3,  /* (584) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
    0,  /* (585) ordering_specification_opt ::= */
   -1,  /* (586) ordering_specification_opt ::= ASC */
   -1,  /* (587) ordering_specification_opt ::= DESC */
    0,  /* (588) null_ordering_opt ::= */
   -2,  /* (589) null_ordering_opt ::= NULLS FIRST */
   -2,  /* (590) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfoNRhs[yyruleno];
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
        yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
#line 50 "sql.y"
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
#line 4509 "sql.c"
  yy_destructor(yypParser,336,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
#line 51 "sql.y"
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
#line 4515 "sql.c"
  yy_destructor(yypParser,337,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
#line 55 "sql.y"
{ }
#line 4521 "sql.c"
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,336,&yymsp[-2].minor);
#line 56 "sql.y"
{ }
#line 4535 "sql.c"
  yy_destructor(yypParser,338,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,339,&yymsp[0].minor);
#line 68 "sql.y"
{ }
#line 4543 "sql.c"
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,337,&yymsp[-1].minor);
#line 69 "sql.y"
{ }
#line 4550 "sql.c"
  yy_destructor(yypParser,339,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
#line 73 "sql.y"
{ }
#line 4566 "sql.c"
  yy_destructor(yypParser,338,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
#line 85 "sql.y"
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy497, &yymsp[-1].minor.yy0, yymsp[0].minor.yy563); }
#line 4572 "sql.c"
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
#line 86 "sql.y"
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy497, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
#line 4577 "sql.c"
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
#line 87 "sql.y"
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy497, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
#line 4582 "sql.c"
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
#line 88 "sql.y"
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy497, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
#line 4587 "sql.c"
        break;
      case 28: /* cmd ::= DROP USER user_name */
#line 89 "sql.y"
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy497); }
#line 4592 "sql.c"
        break;
      case 29: /* sysinfo_opt ::= */
#line 93 "sql.y"
{ yymsp[1].minor.yy563 = 1; }
#line 4597 "sql.c"
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
#line 94 "sql.y"
{ yymsp[-1].minor.yy563 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
#line 4602 "sql.c"
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
#line 97 "sql.y"
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-5].minor.yy693, &yymsp[-3].minor.yy953, &yymsp[0].minor.yy497, yymsp[-2].minor.yy164); }
#line 4607 "sql.c"
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
#line 98 "sql.y"
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-5].minor.yy693, &yymsp[-3].minor.yy953, &yymsp[0].minor.yy497, yymsp[-2].minor.yy164); }
#line 4612 "sql.c"
        break;
      case 33: /* privileges ::= ALL */
#line 102 "sql.y"
{ yymsp[0].minor.yy693 = PRIVILEGE_TYPE_ALL; }
#line 4617 "sql.c"
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
#line 103 "sql.y"
{ yylhsminor.yy693 = yymsp[0].minor.yy693; }
#line 4623 "sql.c"
  yymsp[0].minor.yy693 = yylhsminor.yy693;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
#line 104 "sql.y"
{ yymsp[0].minor.yy693 = PRIVILEGE_TYPE_SUBSCRIBE; }
#line 4629 "sql.c"
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
#line 109 "sql.y"
{ yylhsminor.yy693 = yymsp[-2].minor.yy693 | yymsp[0].minor.yy693; }
#line 4634 "sql.c"
  yymsp[-2].minor.yy693 = yylhsminor.yy693;
        break;
      case 38: /* priv_type ::= READ */
#line 113 "sql.y"
{ yymsp[0].minor.yy693 = PRIVILEGE_TYPE_READ; }
#line 4640 "sql.c"
        break;
      case 39: /* priv_type ::= WRITE */
#line 114 "sql.y"
{ yymsp[0].minor.yy693 = PRIVILEGE_TYPE_WRITE; }
#line 4645 "sql.c"
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
#line 118 "sql.y"
{ yylhsminor.yy953.first = yymsp[-2].minor.yy0; yylhsminor.yy953.second = yymsp[0].minor.yy0; }
#line 4650 "sql.c"
  yymsp[-2].minor.yy953 = yylhsminor.yy953;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
#line 119 "sql.y"
{ yylhsminor.yy953.first = yymsp[-2].minor.yy497; yylhsminor.yy953.second = yymsp[0].minor.yy0; }
#line 4656 "sql.c"
  yymsp[-2].minor.yy953 = yylhsminor.yy953;
        break;
      case 42: /* priv_level ::= db_name NK_DOT table_name */
#line 120 "sql.y"
{ yylhsminor.yy953.first = yymsp[-2].minor.yy497; yylhsminor.yy953.second = yymsp[0].minor.yy497; }
#line 4662 "sql.c"
  yymsp[-2].minor.yy953 = yylhsminor.yy953;
        break;
      case 43: /* priv_level ::= topic_name */
#line 121 "sql.y"
{ yylhsminor.yy953.first = yymsp[0].minor.yy497; yylhsminor.yy953.second = nil_token; }
#line 4668 "sql.c"
  yymsp[0].minor.yy953 = yylhsminor.yy953;
        break;
      case 44: /* with_opt ::= */
      case 141: /* start_opt ::= */ yytestcase(yyruleno==141);
      case 145: /* end_opt ::= */ yytestcase(yyruleno==145);
      case 269: /* like_pattern_opt ::= */ yytestcase(yyruleno==269);
      case 346: /* subtable_opt ::= */ yytestcase(yyruleno==346);
      case 464: /* case_when_else_opt ::= */ yytestcase(yyruleno==464);
      case 494: /* from_clause_opt ::= */ yytestcase(yyruleno==494);
      case 523: /* where_clause_opt ::= */ yytestcase(yyruleno==523);
      case 532: /* twindow_clause_opt ::= */ yytestcase(yyruleno==532);
      case 538: /* sliding_opt ::= */ yytestcase(yyruleno==538);
      case 540: /* fill_opt ::= */ yytestcase(yyruleno==540);
      case 554: /* having_clause_opt ::= */ yytestcase(yyruleno==554);
      case 556: /* range_opt ::= */ yytestcase(yyruleno==556);
      case 558: /* every_opt ::= */ yytestcase(yyruleno==558);
      case 571: /* slimit_clause_opt ::= */ yytestcase(yyruleno==571);
      case 575: /* limit_clause_opt ::= */ yytestcase(yyruleno==575);
#line 123 "sql.y"
{ yymsp[1].minor.yy164 = NULL; }
#line 4689 "sql.c"
        break;
      case 45: /* with_opt ::= WITH search_condition */
      case 495: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==495);
      case 524: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==524);
      case 555: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==555);
#line 124 "sql.y"
{ yymsp[-1].minor.yy164 = yymsp[0].minor.yy164; }
#line 4697 "sql.c"
        break;
      case 46: /* cmd ::= CREATE DNODE dnode_endpoint */
#line 127 "sql.y"
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy497, NULL); }
#line 4702 "sql.c"
        break;
      case 47: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
#line 128 "sql.y"
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy497, &yymsp[0].minor.yy0); }
#line 4707 "sql.c"
        break;
      case 48: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
#line 129 "sql.y"
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy441); }
#line 4712 "sql.c"
        break;
      case 49: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
#line 130 "sql.y"
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy497, yymsp[0].minor.yy441); }
#line 4717 "sql.c"
        break;
      case 50: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
#line 131 "sql.y"
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
#line 4722 "sql.c"
        break;
      case 51: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
#line 132 "sql.y"
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
#line 4727 "sql.c"
        break;
      case 52: /* cmd ::= ALTER ALL DNODES NK_STRING */
#line 133 "sql.y"
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
#line 4732 "sql.c"
        break;
      case 53: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
#line 134 "sql.y"
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
#line 4737 "sql.c"
        break;
      case 54: /* cmd ::= RESTORE DNODE NK_INTEGER */
#line 135 "sql.y"
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_DNODE_STMT, &yymsp[0].minor.yy0); }
#line 4742 "sql.c"
        break;
      case 55: /* dnode_endpoint ::= NK_STRING */
      case 56: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==56);
      case 57: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==57);
      case 293: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==293);
      case 294: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==294);
      case 295: /* sma_func_name ::= LAST */ yytestcase(yyruleno==295);
      case 296: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==296);
      case 390: /* db_name ::= NK_ID */ yytestcase(yyruleno==390);
      case 391: /* table_name ::= NK_ID */ yytestcase(yyruleno==391);
      case 392: /* column_name ::= NK_ID */ yytestcase(yyruleno==392);
      case 393: /* function_name ::= NK_ID */ yytestcase(yyruleno==393);
      case 394: /* table_alias ::= NK_ID */ yytestcase(yyruleno==394);
      case 395: /* column_alias ::= NK_ID */ yytestcase(yyruleno==395);
      case 396: /* user_name ::= NK_ID */ yytestcase(yyruleno==396);
      case 397: /* topic_name ::= NK_ID */ yytestcase(yyruleno==397);
      case 398: /* stream_name ::= NK_ID */ yytestcase(yyruleno==398);
      case 399: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==399);
      case 400: /* index_name ::= NK_ID */ yytestcase(yyruleno==400);
      case 440: /* noarg_func ::= NOW */ yytestcase(yyruleno==440);
      case 441: /* noarg_func ::= TODAY */ yytestcase(yyruleno==441);
      case 442: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==442);
      case 443: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==443);
      case 444: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==444);
      case 445: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==445);
      case 446: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==446);
      case 447: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==447);
      case 448: /* noarg_func ::= USER */ yytestcase(yyruleno==448);
      case 449: /* star_func ::= COUNT */ yytestcase(yyruleno==449);
      case 450: /* star_func ::= FIRST */ yytestcase(yyruleno==450);
      case 451: /* star_func ::= LAST */ yytestcase(yyruleno==451);
      case 452: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==452);
#line 139 "sql.y"
{ yylhsminor.yy497 = yymsp[0].minor.yy0; }
#line 4777 "sql.c"
  yymsp[0].minor.yy497 = yylhsminor.yy497;
        break;
      case 58: /* force_opt ::= */
      case 81: /* not_exists_opt ::= */ yytestcase(yyruleno==81);
      case 83: /* exists_opt ::= */ yytestcase(yyruleno==83);
      case 313: /* analyze_opt ::= */ yytestcase(yyruleno==313);
      case 320: /* agg_func_opt ::= */ yytestcase(yyruleno==320);
      case 326: /* or_replace_opt ::= */ yytestcase(yyruleno==326);
      case 348: /* ignore_opt ::= */ yytestcase(yyruleno==348);
      case 513: /* set_quantifier_opt ::= */ yytestcase(yyruleno==513);
#line 145 "sql.y"
{ yymsp[1].minor.yy441 = false; }
#line 4790 "sql.c"
        break;
      case 59: /* force_opt ::= FORCE */
      case 314: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==314);
      case 321: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==321);
      case 514: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==514);
#line 146 "sql.y"
{ yymsp[0].minor.yy441 = true; }
#line 4798 "sql.c"
        break;
      case 60: /* cmd ::= ALTER LOCAL NK_STRING */
#line 149 "sql.y"
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
#line 4803 "sql.c"
        break;
      case 61: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
#line 150 "sql.y"
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
#line 4808 "sql.c"
        break;
      case 62: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
#line 153 "sql.y"
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
#line 4813 "sql.c"
        break;
      case 63: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
#line 154 "sql.y"
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
#line 4818 "sql.c"
        break;
      case 64: /* cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
#line 155 "sql.y"
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_QNODE_STMT, &yymsp[0].minor.yy0); }
#line 4823 "sql.c"
        break;
      case 65: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
#line 158 "sql.y"
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
#line 4828 "sql.c"
        break;
      case 66: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
#line 159 "sql.y"
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
#line 4833 "sql.c"
        break;
      case 67: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
#line 162 "sql.y"
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
#line 4838 "sql.c"
        break;
      case 68: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
#line 163 "sql.y"
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
#line 4843 "sql.c"
        break;
      case 69: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
#line 166 "sql.y"
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
#line 4848 "sql.c"
        break;
      case 70: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
#line 167 "sql.y"
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
#line 4853 "sql.c"
        break;
      case 71: /* cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
#line 168 "sql.y"
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_MNODE_STMT, &yymsp[0].minor.yy0); }
#line 4858 "sql.c"
        break;
      case 72: /* cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
#line 171 "sql.y"
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_VNODE_STMT, &yymsp[0].minor.yy0); }
#line 4863 "sql.c"
        break;
      case 73: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
#line 174 "sql.y"
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy441, &yymsp[-1].minor.yy497, yymsp[0].minor.yy164); }
#line 4868 "sql.c"
        break;
      case 74: /* cmd ::= DROP DATABASE exists_opt db_name */
#line 175 "sql.y"
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy441, &yymsp[0].minor.yy497); }
#line 4873 "sql.c"
        break;
      case 75: /* cmd ::= USE db_name */
#line 176 "sql.y"
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy497); }
#line 4878 "sql.c"
        break;
      case 76: /* cmd ::= ALTER DATABASE db_name alter_db_options */
#line 177 "sql.y"
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy497, yymsp[0].minor.yy164); }
#line 4883 "sql.c"
        break;
      case 77: /* cmd ::= FLUSH DATABASE db_name */
#line 178 "sql.y"
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy497); }
#line 4888 "sql.c"
        break;
      case 78: /* cmd ::= TRIM DATABASE db_name speed_opt */
#line 179 "sql.y"
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy497, yymsp[0].minor.yy560); }
#line 4893 "sql.c"
        break;
      case 79: /* cmd ::= COMPACT DATABASE db_name start_opt end_opt */
#line 180 "sql.y"
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[-2].minor.yy497, yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
#line 4898 "sql.c"
        break;
      case 80: /* not_exists_opt ::= IF NOT EXISTS */
#line 184 "sql.y"
{ yymsp[-2].minor.yy441 = true; }
#line 4903 "sql.c"
        break;
      case 82: /* exists_opt ::= IF EXISTS */
      case 327: /* or_replace_opt ::= OR REPLACE */ yytestcase(yyruleno==327);
      case 349: /* ignore_opt ::= IGNORE UNTREATED */ yytestcase(yyruleno==349);
#line 189 "sql.y"
{ yymsp[-1].minor.yy441 = true; }
#line 4910 "sql.c"
        break;
      case 84: /* db_options ::= */
#line 192 "sql.y"
{ yymsp[1].minor.yy164 = createDefaultDatabaseOptions(pCxt); }
#line 4915 "sql.c"
        break;
      case 85: /* db_options ::= db_options BUFFER NK_INTEGER */
#line 193 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
#line 4920 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 86: /* db_options ::= db_options CACHEMODEL NK_STRING */
#line 194 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
#line 4926 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 87: /* db_options ::= db_options CACHESIZE NK_INTEGER */
#line 195 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
#line 4932 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 88: /* db_options ::= db_options COMP NK_INTEGER */
#line 196 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
#line 4938 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 89: /* db_options ::= db_options DURATION NK_INTEGER */
      case 90: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==90);
#line 197 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
#line 4945 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 91: /* db_options ::= db_options MAXROWS NK_INTEGER */
#line 199 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
#line 4951 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 92: /* db_options ::= db_options MINROWS NK_INTEGER */
#line 200 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
#line 4957 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 93: /* db_options ::= db_options KEEP integer_list */
      case 94: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==94);
#line 201 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_KEEP, yymsp[0].minor.yy72); }
#line 4964 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 95: /* db_options ::= db_options PAGES NK_INTEGER */
#line 203 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
#line 4970 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 96: /* db_options ::= db_options PAGESIZE NK_INTEGER */
#line 204 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
#line 4976 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 97: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
#line 205 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
#line 4982 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 98: /* db_options ::= db_options PRECISION NK_STRING */
#line 206 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
#line 4988 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 99: /* db_options ::= db_options REPLICA NK_INTEGER */
#line 207 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
#line 4994 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 100: /* db_options ::= db_options VGROUPS NK_INTEGER */
#line 209 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
#line 5000 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 101: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
#line 210 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
#line 5006 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 102: /* db_options ::= db_options RETENTIONS retention_list */
#line 211 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_RETENTIONS, yymsp[0].minor.yy72); }
#line 5012 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 103: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
#line 212 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
#line 5018 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 104: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
#line 213 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
#line 5024 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 105: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
#line 214 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
#line 5030 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 106: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
#line 215 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
#line 5036 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 107: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
#line 216 "sql.y"
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-3].minor.yy164, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
#line 5046 "sql.c"
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 108: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
#line 221 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
#line 5052 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 109: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
#line 222 "sql.y"
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-3].minor.yy164, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
#line 5062 "sql.c"
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 110: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
#line 227 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
#line 5068 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 111: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
#line 228 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
#line 5074 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 112: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
#line 229 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
#line 5080 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 113: /* db_options ::= db_options TABLE_PREFIX signed */
#line 230 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_TABLE_PREFIX, yymsp[0].minor.yy164); }
#line 5086 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 114: /* db_options ::= db_options TABLE_SUFFIX signed */
#line 231 "sql.y"
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_TABLE_SUFFIX, yymsp[0].minor.yy164); }
#line 5092 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 115: /* alter_db_options ::= alter_db_option */
#line 233 "sql.y"
{ yylhsminor.yy164 = createAlterDatabaseOptions(pCxt); yylhsminor.yy164 = setAlterDatabaseOption(pCxt, yylhsminor.yy164, &yymsp[0].minor.yy761); }
#line 5098 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 116: /* alter_db_options ::= alter_db_options alter_db_option */
#line 234 "sql.y"
{ yylhsminor.yy164 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy164, &yymsp[0].minor.yy761); }
#line 5104 "sql.c"
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 117: /* alter_db_option ::= BUFFER NK_INTEGER */
#line 238 "sql.y"
{ yymsp[-1].minor.yy761.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy761.val = yymsp[0].minor.yy0; }
#line 5110 "sql.c"
        break;
      case 118: /* alter_db_option ::= CACHEMODEL NK_STRING */
#line 239 "sql.y"
{ yymsp[-1].minor.yy761.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy761.val = yymsp[0].minor.yy0; }
#line 5115 "sql.c"
        break;
      case 119: /* alter_db_option ::= CACHESIZE NK_INTEGER */
#line 240 "sql.y"
{ yymsp[-1].minor.yy761.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy761.val = yymsp[0].minor.yy0; }
#line 5120 "sql.c"
        break;
      case 120: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
#line 241 "sql.y"
{ yymsp[-1].minor.yy761.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy761.val = yymsp[0].minor.yy0; }
#line 5125 "sql.c"
        break;
      case 121: /* alter_db_option ::= KEEP integer_list */
      case 122: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==122);
#line 242 "sql.y"
{ yymsp[-1].minor.yy761.type = DB_OPTION_KEEP; yymsp[-1].minor.yy761.pList = yymsp[0].minor.yy72; }
#line 5131 "sql.c"
        break;
      case 123: /* alter_db_option ::= PAGES NK_INTEGER */
#line 244 "sql.y"
{ yymsp[-1].minor.yy761.type = DB_OPTION_PAGES; yymsp[-1].minor.yy761.val = yymsp[0].minor.yy0; }
#line 5136 "sql.c"
        break;
      case 124: /* alter_db_option ::= REPLICA NK_INTEGER */
#line 245 "sql.y"
{ yymsp[-1].minor.yy761.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy761.val = yymsp[0].minor.yy0; }
#line 5141 "sql.c"
        break;
      case 125: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
#line 247 "sql.y"
{ yymsp[-1].minor.yy761.type = DB_OPTION_WAL; yymsp[-1].minor.yy761.val = yymsp[0].minor.yy0; }
#line 5146 "sql.c"
        break;
      case 126: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
#line 248 "sql.y"
{ yymsp[-1].minor.yy761.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy761.val = yymsp[0].minor.yy0; }
#line 5151 "sql.c"
        break;
      case 127: /* alter_db_option ::= MINROWS NK_INTEGER */
#line 249 "sql.y"
{ yymsp[-1].minor.yy761.type = DB_OPTION_MINROWS; yymsp[-1].minor.yy761.val = yymsp[0].minor.yy0; }
#line 5156 "sql.c"
        break;
      case 128: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
#line 250 "sql.y"
{ yymsp[-1].minor.yy761.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-1].minor.yy761.val = yymsp[0].minor.yy0; }
#line 5161 "sql.c"
        break;
      case 129: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
#line 251 "sql.y"
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy761.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-2].minor.yy761.val = t;
                                                                                  }
#line 5170 "sql.c"
        break;
      case 130: /* alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
#line 256 "sql.y"
{ yymsp[-1].minor.yy761.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-1].minor.yy761.val = yymsp[0].minor.yy0; }
#line 5175 "sql.c"
        break;
      case 131: /* alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
#line 257 "sql.y"
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy761.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-2].minor.yy761.val = t;
                                                                                  }
#line 5184 "sql.c"
        break;
      case 132: /* integer_list ::= NK_INTEGER */
#line 265 "sql.y"
{ yylhsminor.yy72 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
#line 5189 "sql.c"
  yymsp[0].minor.yy72 = yylhsminor.yy72;
        break;
      case 133: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 359: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==359);
#line 266 "sql.y"
{ yylhsminor.yy72 = addNodeToList(pCxt, yymsp[-2].minor.yy72, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
#line 5196 "sql.c"
  yymsp[-2].minor.yy72 = yylhsminor.yy72;
        break;
      case 134: /* variable_list ::= NK_VARIABLE */
#line 270 "sql.y"
{ yylhsminor.yy72 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
#line 5202 "sql.c"
  yymsp[0].minor.yy72 = yylhsminor.yy72;
        break;
      case 135: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
#line 271 "sql.y"
{ yylhsminor.yy72 = addNodeToList(pCxt, yymsp[-2].minor.yy72, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
#line 5208 "sql.c"
  yymsp[-2].minor.yy72 = yylhsminor.yy72;
        break;
      case 136: /* retention_list ::= retention */
      case 166: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==166);
      case 169: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==169);
      case 176: /* column_def_list ::= column_def */ yytestcase(yyruleno==176);
      case 219: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==219);
      case 224: /* col_name_list ::= col_name */ yytestcase(yyruleno==224);
      case 275: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==275);
      case 289: /* func_list ::= func */ yytestcase(yyruleno==289);
      case 388: /* literal_list ::= signed_literal */ yytestcase(yyruleno==388);
      case 455: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==455);
      case 461: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==461);
      case 516: /* select_list ::= select_item */ yytestcase(yyruleno==516);
      case 527: /* partition_list ::= partition_item */ yytestcase(yyruleno==527);
      case 582: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==582);
#line 275 "sql.y"
{ yylhsminor.yy72 = createNodeList(pCxt, yymsp[0].minor.yy164); }
#line 5227 "sql.c"
  yymsp[0].minor.yy72 = yylhsminor.yy72;
        break;
      case 137: /* retention_list ::= retention_list NK_COMMA retention */
      case 170: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==170);
      case 177: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==177);
      case 220: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==220);
      case 225: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==225);
      case 276: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==276);
      case 290: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==290);
      case 389: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==389);
      case 456: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==456);
      case 517: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==517);
      case 528: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==528);
      case 583: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==583);
#line 276 "sql.y"
{ yylhsminor.yy72 = addNodeToList(pCxt, yymsp[-2].minor.yy72, yymsp[0].minor.yy164); }
#line 5244 "sql.c"
  yymsp[-2].minor.yy72 = yylhsminor.yy72;
        break;
      case 138: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
#line 278 "sql.y"
{ yylhsminor.yy164 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
#line 5250 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 139: /* speed_opt ::= */
      case 322: /* bufsize_opt ::= */ yytestcase(yyruleno==322);
#line 282 "sql.y"
{ yymsp[1].minor.yy560 = 0; }
#line 5257 "sql.c"
        break;
      case 140: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 323: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==323);
#line 283 "sql.y"
{ yymsp[-1].minor.yy560 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
#line 5263 "sql.c"
        break;
      case 142: /* start_opt ::= START WITH NK_INTEGER */
      case 146: /* end_opt ::= END WITH NK_INTEGER */ yytestcase(yyruleno==146);
#line 286 "sql.y"
{ yymsp[-2].minor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
#line 5269 "sql.c"
        break;
      case 143: /* start_opt ::= START WITH NK_STRING */
      case 147: /* end_opt ::= END WITH NK_STRING */ yytestcase(yyruleno==147);
#line 287 "sql.y"
{ yymsp[-2].minor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
#line 5275 "sql.c"
        break;
      case 144: /* start_opt ::= START WITH TIMESTAMP NK_STRING */
      case 148: /* end_opt ::= END WITH TIMESTAMP NK_STRING */ yytestcase(yyruleno==148);
#line 288 "sql.y"
{ yymsp[-3].minor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
#line 5281 "sql.c"
        break;
      case 149: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 151: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==151);
#line 297 "sql.y"
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy441, yymsp[-5].minor.yy164, yymsp[-3].minor.yy72, yymsp[-1].minor.yy72, yymsp[0].minor.yy164); }
#line 5287 "sql.c"
        break;
      case 150: /* cmd ::= CREATE TABLE multi_create_clause */
#line 298 "sql.y"
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy72); }
#line 5292 "sql.c"
        break;
      case 152: /* cmd ::= DROP TABLE multi_drop_clause */
#line 301 "sql.y"
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy72); }
#line 5297 "sql.c"
        break;
      case 153: /* cmd ::= DROP STABLE exists_opt full_table_name */
#line 302 "sql.y"
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy441, yymsp[0].minor.yy164); }
#line 5302 "sql.c"
        break;
      case 154: /* cmd ::= ALTER TABLE alter_table_clause */
      case 361: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==361);
      case 362: /* cmd ::= insert_query */ yytestcase(yyruleno==362);
#line 304 "sql.y"
{ pCxt->pRootNode = yymsp[0].minor.yy164; }
#line 5309 "sql.c"
        break;
      case 155: /* cmd ::= ALTER STABLE alter_table_clause */
#line 305 "sql.y"
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy164); }
#line 5314 "sql.c"
        break;
      case 156: /* alter_table_clause ::= full_table_name alter_table_options */
#line 307 "sql.y"
{ yylhsminor.yy164 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
#line 5319 "sql.c"
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 157: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
#line 309 "sql.y"
{ yylhsminor.yy164 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy164, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy497, yymsp[0].minor.yy700); }
#line 5325 "sql.c"
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 158: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
#line 310 "sql.y"
{ yylhsminor.yy164 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy164, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy497); }
#line 5331 "sql.c"
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 159: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
#line 312 "sql.y"
{ yylhsminor.yy164 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy164, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy497, yymsp[0].minor.yy700); }
#line 5337 "sql.c"
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 160: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
#line 314 "sql.y"
{ yylhsminor.yy164 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy164, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy497, &yymsp[0].minor.yy497); }
#line 5343 "sql.c"
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 161: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
#line 316 "sql.y"
{ yylhsminor.yy164 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy164, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy497, yymsp[0].minor.yy700); }
#line 5349 "sql.c"
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 162: /* alter_table_clause ::= full_table_name DROP TAG column_name */
#line 317 "sql.y"
{ yylhsminor.yy164 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy164, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy497); }
#line 5355 "sql.c"
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 163: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
#line 319 "sql.y"
{ yylhsminor.yy164 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy164, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy497, yymsp[0].minor.yy700); }
#line 5361 "sql.c"
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 164: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
#line 321 "sql.y"
{ yylhsminor.yy164 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy164, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy497, &yymsp[0].minor.yy497); }
#line 5367 "sql.c"
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 165: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
#line 323 "sql.y"
{ yylhsminor.yy164 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy164, &yymsp[-2].minor.yy497, yymsp[0].minor.yy164); }
#line 5373 "sql.c"
  yymsp[-5].minor.yy164 = yylhsminor.yy164;
        break;
      case 167: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 462: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==462);
#line 328 "sql.y"
{ yylhsminor.yy72 = addNodeToList(pCxt, yymsp[-1].minor.yy72, yymsp[0].minor.yy164); }
#line 5380 "sql.c"
  yymsp[-1].minor.yy72 = yylhsminor.yy72;
        break;
      case 168: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
#line 332 "sql.y"
{ yylhsminor.yy164 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy441, yymsp[-8].minor.yy164, yymsp[-6].minor.yy164, yymsp[-5].minor.yy72, yymsp[-2].minor.yy72, yymsp[0].minor.yy164); }
#line 5386 "sql.c"
  yymsp[-9].minor.yy164 = yylhsminor.yy164;
        break;
      case 171: /* drop_table_clause ::= exists_opt full_table_name */
#line 339 "sql.y"
{ yylhsminor.yy164 = createDropTableClause(pCxt, yymsp[-1].minor.yy441, yymsp[0].minor.yy164); }
#line 5392 "sql.c"
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 172: /* specific_cols_opt ::= */
      case 202: /* tags_def_opt ::= */ yytestcase(yyruleno==202);
      case 274: /* tag_list_opt ::= */ yytestcase(yyruleno==274);
      case 332: /* col_list_opt ::= */ yytestcase(yyruleno==332);
      case 334: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==334);
      case 525: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==525);
      case 550: /* group_by_clause_opt ::= */ yytestcase(yyruleno==550);
      case 569: /* order_by_clause_opt ::= */ yytestcase(yyruleno==569);
#line 343 "sql.y"
{ yymsp[1].minor.yy72 = NULL; }
#line 5405 "sql.c"
        break;
      case 173: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 333: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==333);
#line 344 "sql.y"
{ yymsp[-2].minor.yy72 = yymsp[-1].minor.yy72; }
#line 5411 "sql.c"
        break;
      case 174: /* full_table_name ::= table_name */
#line 346 "sql.y"
{ yylhsminor.yy164 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy497, NULL); }
#line 5416 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 175: /* full_table_name ::= db_name NK_DOT table_name */
#line 347 "sql.y"
{ yylhsminor.yy164 = createRealTableNode(pCxt, &yymsp[-2].minor.yy497, &yymsp[0].minor.yy497, NULL); }
#line 5422 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 178: /* column_def ::= column_name type_name */
#line 354 "sql.y"
{ yylhsminor.yy164 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy497, yymsp[0].minor.yy700, NULL); }
#line 5428 "sql.c"
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 179: /* type_name ::= BOOL */
#line 359 "sql.y"
{ yymsp[0].minor.yy700 = createDataType(TSDB_DATA_TYPE_BOOL); }
#line 5434 "sql.c"
        break;
      case 180: /* type_name ::= TINYINT */
#line 360 "sql.y"
{ yymsp[0].minor.yy700 = createDataType(TSDB_DATA_TYPE_TINYINT); }
#line 5439 "sql.c"
        break;
      case 181: /* type_name ::= SMALLINT */
#line 361 "sql.y"
{ yymsp[0].minor.yy700 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
#line 5444 "sql.c"
        break;
      case 182: /* type_name ::= INT */
      case 183: /* type_name ::= INTEGER */ yytestcase(yyruleno==183);
#line 362 "sql.y"
{ yymsp[0].minor.yy700 = createDataType(TSDB_DATA_TYPE_INT); }
#line 5450 "sql.c"
        break;
      case 184: /* type_name ::= BIGINT */
#line 364 "sql.y"
{ yymsp[0].minor.yy700 = createDataType(TSDB_DATA_TYPE_BIGINT); }
#line 5455 "sql.c"
        break;
      case 185: /* type_name ::= FLOAT */
#line 365 "sql.y"
{ yymsp[0].minor.yy700 = createDataType(TSDB_DATA_TYPE_FLOAT); }
#line 5460 "sql.c"
        break;
      case 186: /* type_name ::= DOUBLE */
#line 366 "sql.y"
{ yymsp[0].minor.yy700 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
#line 5465 "sql.c"
        break;
      case 187: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
#line 367 "sql.y"
{ yymsp[-3].minor.yy700 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
#line 5470 "sql.c"
        break;
      case 188: /* type_name ::= TIMESTAMP */
#line 368 "sql.y"
{ yymsp[0].minor.yy700 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
#line 5475 "sql.c"
        break;
      case 189: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
#line 369 "sql.y"
{ yymsp[-3].minor.yy700 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
#line 5480 "sql.c"
        break;
      case 190: /* type_name ::= TINYINT UNSIGNED */
#line 370 "sql.y"
{ yymsp[-1].minor.yy700 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
#line 5485 "sql.c"
        break;
      case 191: /* type_name ::= SMALLINT UNSIGNED */
#line 371 "sql.y"
{ yymsp[-1].minor.yy700 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
#line 5490 "sql.c"
        break;
      case 192: /* type_name ::= INT UNSIGNED */
#line 372 "sql.y"
{ yymsp[-1].minor.yy700 = createDataType(TSDB_DATA_TYPE_UINT); }
#line 5495 "sql.c"
        break;
      case 193: /* type_name ::= BIGINT UNSIGNED */
#line 373 "sql.y"
{ yymsp[-1].minor.yy700 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
#line 5500 "sql.c"
        break;
      case 194: /* type_name ::= JSON */
#line 374 "sql.y"
{ yymsp[0].minor.yy700 = createDataType(TSDB_DATA_TYPE_JSON); }
#line 5505 "sql.c"
        break;
      case 195: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
#line 375 "sql.y"
{ yymsp[-3].minor.yy700 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
#line 5510 "sql.c"
        break;
      case 196: /* type_name ::= MEDIUMBLOB */
#line 376 "sql.y"
{ yymsp[0].minor.yy700 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
#line 5515 "sql.c"
        break;
      case 197: /* type_name ::= BLOB */
#line 377 "sql.y"
{ yymsp[0].minor.yy700 = createDataType(TSDB_DATA_TYPE_BLOB); }
#line 5520 "sql.c"
        break;
      case 198: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
#line 378 "sql.y"
{ yymsp[-3].minor.yy700 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
#line 5525 "sql.c"
        break;
      case 199: /* type_name ::= DECIMAL */
#line 379 "sql.y"
{ yymsp[0].minor.yy700 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
#line 5530 "sql.c"
        break;
      case 200: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
#line 380 "sql.y"
{ yymsp[-3].minor.yy700 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
#line 5535 "sql.c"
        break;
      case 201: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
#line 381 "sql.y"
{ yymsp[-5].minor.yy700 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
#line 5540 "sql.c"
        break;
      case 203: /* tags_def_opt ::= tags_def */
      case 335: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==335);
      case 454: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==454);
#line 386 "sql.y"
{ yylhsminor.yy72 = yymsp[0].minor.yy72; }
#line 5547 "sql.c"
  yymsp[0].minor.yy72 = yylhsminor.yy72;
        break;
      case 204: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 336: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==336);
#line 390 "sql.y"
{ yymsp[-3].minor.yy72 = yymsp[-1].minor.yy72; }
#line 5554 "sql.c"
        break;
      case 205: /* table_options ::= */
#line 392 "sql.y"
{ yymsp[1].minor.yy164 = createDefaultTableOptions(pCxt); }
#line 5559 "sql.c"
        break;
      case 206: /* table_options ::= table_options COMMENT NK_STRING */
#line 393 "sql.y"
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-2].minor.yy164, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
#line 5564 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 207: /* table_options ::= table_options MAX_DELAY duration_list */
#line 394 "sql.y"
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-2].minor.yy164, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy72); }
#line 5570 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 208: /* table_options ::= table_options WATERMARK duration_list */
#line 395 "sql.y"
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-2].minor.yy164, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy72); }
#line 5576 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 209: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
#line 396 "sql.y"
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-4].minor.yy164, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy72); }
#line 5582 "sql.c"
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 210: /* table_options ::= table_options TTL NK_INTEGER */
#line 397 "sql.y"
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-2].minor.yy164, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
#line 5588 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 211: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
#line 398 "sql.y"
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-4].minor.yy164, TABLE_OPTION_SMA, yymsp[-1].minor.yy72); }
#line 5594 "sql.c"
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 212: /* table_options ::= table_options DELETE_MARK duration_list */
#line 399 "sql.y"
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-2].minor.yy164, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy72); }
#line 5600 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 213: /* alter_table_options ::= alter_table_option */
#line 401 "sql.y"
{ yylhsminor.yy164 = createAlterTableOptions(pCxt); yylhsminor.yy164 = setTableOption(pCxt, yylhsminor.yy164, yymsp[0].minor.yy761.type, &yymsp[0].minor.yy761.val); }
#line 5606 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 214: /* alter_table_options ::= alter_table_options alter_table_option */
#line 402 "sql.y"
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-1].minor.yy164, yymsp[0].minor.yy761.type, &yymsp[0].minor.yy761.val); }
#line 5612 "sql.c"
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 215: /* alter_table_option ::= COMMENT NK_STRING */
#line 406 "sql.y"
{ yymsp[-1].minor.yy761.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy761.val = yymsp[0].minor.yy0; }
#line 5618 "sql.c"
        break;
      case 216: /* alter_table_option ::= TTL NK_INTEGER */
#line 407 "sql.y"
{ yymsp[-1].minor.yy761.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy761.val = yymsp[0].minor.yy0; }
#line 5623 "sql.c"
        break;
      case 217: /* duration_list ::= duration_literal */
      case 418: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==418);
#line 411 "sql.y"
{ yylhsminor.yy72 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy164)); }
#line 5629 "sql.c"
  yymsp[0].minor.yy72 = yylhsminor.yy72;
        break;
      case 218: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 419: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==419);
#line 412 "sql.y"
{ yylhsminor.yy72 = addNodeToList(pCxt, yymsp[-2].minor.yy72, releaseRawExprNode(pCxt, yymsp[0].minor.yy164)); }
#line 5636 "sql.c"
  yymsp[-2].minor.yy72 = yylhsminor.yy72;
        break;
      case 221: /* rollup_func_name ::= function_name */
#line 419 "sql.y"
{ yylhsminor.yy164 = createFunctionNode(pCxt, &yymsp[0].minor.yy497, NULL); }
#line 5642 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 222: /* rollup_func_name ::= FIRST */
      case 223: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==223);
      case 278: /* tag_item ::= QTAGS */ yytestcase(yyruleno==278);
#line 420 "sql.y"
{ yylhsminor.yy164 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
#line 5650 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 226: /* col_name ::= column_name */
      case 279: /* tag_item ::= column_name */ yytestcase(yyruleno==279);
#line 428 "sql.y"
{ yylhsminor.yy164 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy497); }
#line 5657 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 227: /* cmd ::= SHOW DNODES */
#line 431 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
#line 5663 "sql.c"
        break;
      case 228: /* cmd ::= SHOW USERS */
#line 432 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
#line 5668 "sql.c"
        break;
      case 229: /* cmd ::= SHOW USER PRIVILEGES */
#line 433 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
#line 5673 "sql.c"
        break;
      case 230: /* cmd ::= SHOW DATABASES */
#line 434 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
#line 5678 "sql.c"
        break;
      case 231: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
#line 435 "sql.y"
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, OP_TYPE_LIKE); }
#line 5683 "sql.c"
        break;
      case 232: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
#line 436 "sql.y"
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, OP_TYPE_LIKE); }
#line 5688 "sql.c"
        break;
      case 233: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
#line 437 "sql.y"
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy164, NULL, OP_TYPE_LIKE); }
#line 5693 "sql.c"
        break;
      case 234: /* cmd ::= SHOW MNODES */
#line 438 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
#line 5698 "sql.c"
        break;
      case 235: /* cmd ::= SHOW QNODES */
#line 440 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
#line 5703 "sql.c"
        break;
      case 236: /* cmd ::= SHOW FUNCTIONS */
#line 441 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
#line 5708 "sql.c"
        break;
      case 237: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
#line 442 "sql.y"
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy164, yymsp[-1].minor.yy164, OP_TYPE_EQUAL); }
#line 5713 "sql.c"
        break;
      case 238: /* cmd ::= SHOW STREAMS */
#line 443 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
#line 5718 "sql.c"
        break;
      case 239: /* cmd ::= SHOW ACCOUNTS */
#line 444 "sql.y"
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
#line 5723 "sql.c"
        break;
      case 240: /* cmd ::= SHOW APPS */
#line 445 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
#line 5728 "sql.c"
        break;
      case 241: /* cmd ::= SHOW CONNECTIONS */
#line 446 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
#line 5733 "sql.c"
        break;
      case 242: /* cmd ::= SHOW LICENCES */
      case 243: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==243);
#line 447 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
#line 5739 "sql.c"
        break;
      case 244: /* cmd ::= SHOW CREATE DATABASE db_name */
#line 449 "sql.y"
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy497); }
#line 5744 "sql.c"
        break;
      case 245: /* cmd ::= SHOW CREATE TABLE full_table_name */
#line 450 "sql.y"
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy164); }
#line 5749 "sql.c"
        break;
      case 246: /* cmd ::= SHOW CREATE STABLE full_table_name */
#line 451 "sql.y"
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy164); }
#line 5754 "sql.c"
        break;
      case 247: /* cmd ::= SHOW QUERIES */
#line 452 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
#line 5759 "sql.c"
        break;
      case 248: /* cmd ::= SHOW SCORES */
#line 453 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
#line 5764 "sql.c"
        break;
      case 249: /* cmd ::= SHOW TOPICS */
#line 454 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
#line 5769 "sql.c"
        break;
      case 250: /* cmd ::= SHOW VARIABLES */
      case 251: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==251);
#line 455 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
#line 5775 "sql.c"
        break;
      case 252: /* cmd ::= SHOW LOCAL VARIABLES */
#line 457 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
#line 5780 "sql.c"
        break;
      case 253: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
#line 458 "sql.y"
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy164); }
#line 5785 "sql.c"
        break;
      case 254: /* cmd ::= SHOW BNODES */
#line 459 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
#line 5790 "sql.c"
        break;
      case 255: /* cmd ::= SHOW SNODES */
#line 460 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
#line 5795 "sql.c"
        break;
      case 256: /* cmd ::= SHOW CLUSTER */
#line 461 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
#line 5800 "sql.c"
        break;
      case 257: /* cmd ::= SHOW TRANSACTIONS */
#line 462 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
#line 5805 "sql.c"
        break;
      case 258: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
#line 463 "sql.y"
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy164); }
#line 5810 "sql.c"
        break;
      case 259: /* cmd ::= SHOW CONSUMERS */
#line 464 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
#line 5815 "sql.c"
        break;
      case 260: /* cmd ::= SHOW SUBSCRIPTIONS */
#line 465 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
#line 5820 "sql.c"
        break;
      case 261: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
#line 466 "sql.y"
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy164, yymsp[-1].minor.yy164, OP_TYPE_EQUAL); }
#line 5825 "sql.c"
        break;
      case 262: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
#line 467 "sql.y"
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy164, yymsp[0].minor.yy164, yymsp[-3].minor.yy72); }
#line 5830 "sql.c"
        break;
      case 263: /* cmd ::= SHOW VNODES NK_INTEGER */
#line 468 "sql.y"
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
#line 5835 "sql.c"
        break;
      case 264: /* cmd ::= SHOW VNODES NK_STRING */
#line 469 "sql.y"
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
#line 5840 "sql.c"
        break;
      case 265: /* cmd ::= SHOW db_name_cond_opt ALIVE */
#line 471 "sql.y"
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy164,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
#line 5845 "sql.c"
        break;
      case 266: /* cmd ::= SHOW CLUSTER ALIVE */
#line 472 "sql.y"
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
#line 5850 "sql.c"
        break;
      case 267: /* db_name_cond_opt ::= */
      case 272: /* from_db_opt ::= */ yytestcase(yyruleno==272);
#line 474 "sql.y"
{ yymsp[1].minor.yy164 = createDefaultDatabaseCondValue(pCxt); }
#line 5856 "sql.c"
        break;
      case 268: /* db_name_cond_opt ::= db_name NK_DOT */
#line 475 "sql.y"
{ yylhsminor.yy164 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy497); }
#line 5861 "sql.c"
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 270: /* like_pattern_opt ::= LIKE NK_STRING */
#line 478 "sql.y"
{ yymsp[-1].minor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
#line 5867 "sql.c"
        break;
      case 271: /* table_name_cond ::= table_name */
#line 480 "sql.y"
{ yylhsminor.yy164 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy497); }
#line 5872 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 273: /* from_db_opt ::= FROM db_name */
#line 483 "sql.y"
{ yymsp[-1].minor.yy164 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy497); }
#line 5878 "sql.c"
        break;
      case 277: /* tag_item ::= TBNAME */
#line 491 "sql.y"
{ yylhsminor.yy164 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
#line 5883 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 280: /* tag_item ::= column_name column_alias */
#line 494 "sql.y"
{ yylhsminor.yy164 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy497), &yymsp[0].minor.yy497); }
#line 5889 "sql.c"
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 281: /* tag_item ::= column_name AS column_alias */
#line 495 "sql.y"
{ yylhsminor.yy164 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy497), &yymsp[0].minor.yy497); }
#line 5895 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 282: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
#line 499 "sql.y"
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy441, yymsp[-3].minor.yy164, yymsp[-1].minor.yy164, NULL, yymsp[0].minor.yy164); }
#line 5901 "sql.c"
        break;
      case 283: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
#line 501 "sql.y"
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy441, yymsp[-5].minor.yy164, yymsp[-3].minor.yy164, yymsp[-1].minor.yy72, NULL); }
#line 5906 "sql.c"
        break;
      case 284: /* cmd ::= DROP INDEX exists_opt full_index_name */
#line 502 "sql.y"
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy441, yymsp[0].minor.yy164); }
#line 5911 "sql.c"
        break;
      case 285: /* full_index_name ::= index_name */
#line 504 "sql.y"
{ yylhsminor.yy164 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy497); }
#line 5916 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 286: /* full_index_name ::= db_name NK_DOT index_name */
#line 505 "sql.y"
{ yylhsminor.yy164 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy497, &yymsp[0].minor.yy497); }
#line 5922 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 287: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
#line 508 "sql.y"
{ yymsp[-9].minor.yy164 = createIndexOption(pCxt, yymsp[-7].minor.yy72, releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), NULL, yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
#line 5928 "sql.c"
        break;
      case 288: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
#line 511 "sql.y"
{ yymsp[-11].minor.yy164 = createIndexOption(pCxt, yymsp[-9].minor.yy72, releaseRawExprNode(pCxt, yymsp[-5].minor.yy164), releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
#line 5933 "sql.c"
        break;
      case 291: /* func ::= sma_func_name NK_LP expression_list NK_RP */
#line 518 "sql.y"
{ yylhsminor.yy164 = createFunctionNode(pCxt, &yymsp[-3].minor.yy497, yymsp[-1].minor.yy72); }
#line 5938 "sql.c"
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 292: /* sma_func_name ::= function_name */
      case 505: /* alias_opt ::= table_alias */ yytestcase(yyruleno==505);
#line 522 "sql.y"
{ yylhsminor.yy497 = yymsp[0].minor.yy497; }
#line 5945 "sql.c"
  yymsp[0].minor.yy497 = yylhsminor.yy497;
        break;
      case 297: /* sma_stream_opt ::= */
      case 337: /* stream_options ::= */ yytestcase(yyruleno==337);
#line 528 "sql.y"
{ yymsp[1].minor.yy164 = createStreamOptions(pCxt); }
#line 5952 "sql.c"
        break;
      case 298: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
#line 529 "sql.y"
{ ((SStreamOptions*)yymsp[-2].minor.yy164)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy164); yylhsminor.yy164 = yymsp[-2].minor.yy164; }
#line 5957 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 299: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
#line 530 "sql.y"
{ ((SStreamOptions*)yymsp[-2].minor.yy164)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy164); yylhsminor.yy164 = yymsp[-2].minor.yy164; }
#line 5963 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 300: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
#line 531 "sql.y"
{ ((SStreamOptions*)yymsp[-2].minor.yy164)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy164); yylhsminor.yy164 = yymsp[-2].minor.yy164; }
#line 5969 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 301: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
#line 534 "sql.y"
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy441, &yymsp[-2].minor.yy497, yymsp[0].minor.yy164); }
#line 5975 "sql.c"
        break;
      case 302: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
#line 535 "sql.y"
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy441, &yymsp[-3].minor.yy497, &yymsp[0].minor.yy497, false); }
#line 5980 "sql.c"
        break;
      case 303: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
#line 537 "sql.y"
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy441, &yymsp[-5].minor.yy497, &yymsp[0].minor.yy497, true); }
#line 5985 "sql.c"
        break;
      case 304: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
#line 539 "sql.y"
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy441, &yymsp[-3].minor.yy497, yymsp[0].minor.yy164, false); }
#line 5990 "sql.c"
        break;
      case 305: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
#line 541 "sql.y"
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy441, &yymsp[-5].minor.yy497, yymsp[0].minor.yy164, true); }
#line 5995 "sql.c"
        break;
      case 306: /* cmd ::= DROP TOPIC exists_opt topic_name */
#line 542 "sql.y"
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy441, &yymsp[0].minor.yy497); }
#line 6000 "sql.c"
        break;
      case 307: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
#line 543 "sql.y"
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy441, &yymsp[-2].minor.yy497, &yymsp[0].minor.yy497); }
#line 6005 "sql.c"
        break;
      case 308: /* cmd ::= DESC full_table_name */
      case 309: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==309);
#line 546 "sql.y"
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy164); }
#line 6011 "sql.c"
        break;
      case 310: /* cmd ::= RESET QUERY CACHE */
#line 550 "sql.y"
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
#line 6016 "sql.c"
        break;
      case 311: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 312: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==312);
#line 553 "sql.y"
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy441, yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
#line 6022 "sql.c"
        break;
      case 315: /* explain_options ::= */
#line 561 "sql.y"
{ yymsp[1].minor.yy164 = createDefaultExplainOptions(pCxt); }
#line 6027 "sql.c"
        break;
      case 316: /* explain_options ::= explain_options VERBOSE NK_BOOL */
#line 562 "sql.y"
{ yylhsminor.yy164 = setExplainVerbose(pCxt, yymsp[-2].minor.yy164, &yymsp[0].minor.yy0); }
#line 6032 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 317: /* explain_options ::= explain_options RATIO NK_FLOAT */
#line 563 "sql.y"
{ yylhsminor.yy164 = setExplainRatio(pCxt, yymsp[-2].minor.yy164, &yymsp[0].minor.yy0); }
#line 6038 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 318: /* cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
#line 568 "sql.y"
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy441, yymsp[-9].minor.yy441, &yymsp[-6].minor.yy497, &yymsp[-4].minor.yy0, yymsp[-2].minor.yy700, yymsp[-1].minor.yy560, &yymsp[0].minor.yy497, yymsp[-10].minor.yy441); }
#line 6044 "sql.c"
        break;
      case 319: /* cmd ::= DROP FUNCTION exists_opt function_name */
#line 569 "sql.y"
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy441, &yymsp[0].minor.yy497); }
#line 6049 "sql.c"
        break;
      case 324: /* language_opt ::= */
#line 583 "sql.y"
{ yymsp[1].minor.yy497 = nil_token; }
#line 6054 "sql.c"
        break;
      case 325: /* language_opt ::= LANGUAGE NK_STRING */
#line 584 "sql.y"
{ yymsp[-1].minor.yy497 = yymsp[0].minor.yy0; }
#line 6059 "sql.c"
        break;
      case 328: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
#line 594 "sql.y"
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy441, &yymsp[-8].minor.yy497, yymsp[-5].minor.yy164, yymsp[-7].minor.yy164, yymsp[-3].minor.yy72, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, yymsp[-4].minor.yy72); }
#line 6064 "sql.c"
        break;
      case 329: /* cmd ::= DROP STREAM exists_opt stream_name */
#line 595 "sql.y"
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy441, &yymsp[0].minor.yy497); }
#line 6069 "sql.c"
        break;
      case 330: /* cmd ::= PAUSE STREAM exists_opt stream_name */
#line 596 "sql.y"
{ pCxt->pRootNode = createPauseStreamStmt(pCxt, yymsp[-1].minor.yy441, &yymsp[0].minor.yy497); }
#line 6074 "sql.c"
        break;
      case 331: /* cmd ::= RESUME STREAM exists_opt ignore_opt stream_name */
#line 597 "sql.y"
{ pCxt->pRootNode = createResumeStreamStmt(pCxt, yymsp[-2].minor.yy441, yymsp[-1].minor.yy441, &yymsp[0].minor.yy497); }
#line 6079 "sql.c"
        break;
      case 338: /* stream_options ::= stream_options TRIGGER AT_ONCE */
      case 339: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */ yytestcase(yyruleno==339);
#line 611 "sql.y"
{ yylhsminor.yy164 = setStreamOptions(pCxt, yymsp[-2].minor.yy164, SOPT_TRIGGER_TYPE_SET, &yymsp[0].minor.yy0, NULL); }
#line 6085 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 340: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
#line 613 "sql.y"
{ yylhsminor.yy164 = setStreamOptions(pCxt, yymsp[-3].minor.yy164, SOPT_TRIGGER_TYPE_SET, &yymsp[-1].minor.yy0, releaseRawExprNode(pCxt, yymsp[0].minor.yy164)); }
#line 6091 "sql.c"
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 341: /* stream_options ::= stream_options WATERMARK duration_literal */
#line 614 "sql.y"
{ yylhsminor.yy164 = setStreamOptions(pCxt, yymsp[-2].minor.yy164, SOPT_WATERMARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy164)); }
#line 6097 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 342: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
#line 615 "sql.y"
{ yylhsminor.yy164 = setStreamOptions(pCxt, yymsp[-3].minor.yy164, SOPT_IGNORE_EXPIRED_SET, &yymsp[0].minor.yy0, NULL); }
#line 6103 "sql.c"
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 343: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
#line 616 "sql.y"
{ yylhsminor.yy164 = setStreamOptions(pCxt, yymsp[-2].minor.yy164, SOPT_FILL_HISTORY_SET, &yymsp[0].minor.yy0, NULL); }
#line 6109 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 344: /* stream_options ::= stream_options DELETE_MARK duration_literal */
#line 617 "sql.y"
{ yylhsminor.yy164 = setStreamOptions(pCxt, yymsp[-2].minor.yy164, SOPT_DELETE_MARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy164)); }
#line 6115 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 345: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
#line 618 "sql.y"
{ yylhsminor.yy164 = setStreamOptions(pCxt, yymsp[-3].minor.yy164, SOPT_IGNORE_UPDATE_SET, &yymsp[0].minor.yy0, NULL); }
#line 6121 "sql.c"
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 347: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 539: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==539);
      case 559: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==559);
#line 621 "sql.y"
{ yymsp[-3].minor.yy164 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy164); }
#line 6129 "sql.c"
        break;
      case 350: /* cmd ::= KILL CONNECTION NK_INTEGER */
#line 629 "sql.y"
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
#line 6134 "sql.c"
        break;
      case 351: /* cmd ::= KILL QUERY NK_STRING */
#line 630 "sql.y"
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
#line 6139 "sql.c"
        break;
      case 352: /* cmd ::= KILL TRANSACTION NK_INTEGER */
#line 631 "sql.y"
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
#line 6144 "sql.c"
        break;
      case 353: /* cmd ::= BALANCE VGROUP */
#line 634 "sql.y"
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
#line 6149 "sql.c"
        break;
      case 354: /* cmd ::= BALANCE VGROUP LEADER */
#line 635 "sql.y"
{ pCxt->pRootNode = createBalanceVgroupLeaderStmt(pCxt); }
#line 6154 "sql.c"
        break;
      case 355: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
#line 636 "sql.y"
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
#line 6159 "sql.c"
        break;
      case 356: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
#line 637 "sql.y"
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy72); }
#line 6164 "sql.c"
        break;
      case 357: /* cmd ::= SPLIT VGROUP NK_INTEGER */
#line 638 "sql.y"
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
#line 6169 "sql.c"
        break;
      case 358: /* dnode_list ::= DNODE NK_INTEGER */
#line 642 "sql.y"
{ yymsp[-1].minor.yy72 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
#line 6174 "sql.c"
        break;
      case 360: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
#line 649 "sql.y"
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
#line 6179 "sql.c"
        break;
      case 363: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
#line 658 "sql.y"
{ yymsp[-6].minor.yy164 = createInsertStmt(pCxt, yymsp[-4].minor.yy164, yymsp[-2].minor.yy72, yymsp[0].minor.yy164); }
#line 6184 "sql.c"
        break;
      case 364: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
#line 659 "sql.y"
{ yymsp[-3].minor.yy164 = createInsertStmt(pCxt, yymsp[-1].minor.yy164, NULL, yymsp[0].minor.yy164); }
#line 6189 "sql.c"
        break;
      case 365: /* literal ::= NK_INTEGER */
#line 662 "sql.y"
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
#line 6194 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 366: /* literal ::= NK_FLOAT */
#line 663 "sql.y"
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
#line 6200 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 367: /* literal ::= NK_STRING */
#line 664 "sql.y"
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
#line 6206 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 368: /* literal ::= NK_BOOL */
#line 665 "sql.y"
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
#line 6212 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 369: /* literal ::= TIMESTAMP NK_STRING */
#line 666 "sql.y"
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
#line 6218 "sql.c"
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 370: /* literal ::= duration_literal */
      case 380: /* signed_literal ::= signed */ yytestcase(yyruleno==380);
      case 401: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==401);
      case 402: /* expression ::= literal */ yytestcase(yyruleno==402);
      case 403: /* expression ::= pseudo_column */ yytestcase(yyruleno==403);
      case 404: /* expression ::= column_reference */ yytestcase(yyruleno==404);
      case 405: /* expression ::= function_expression */ yytestcase(yyruleno==405);
      case 406: /* expression ::= case_when_expression */ yytestcase(yyruleno==406);
      case 437: /* function_expression ::= literal_func */ yytestcase(yyruleno==437);
      case 486: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==486);
      case 490: /* boolean_primary ::= predicate */ yytestcase(yyruleno==490);
      case 492: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==492);
      case 493: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==493);
      case 496: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==496);
      case 498: /* table_reference ::= table_primary */ yytestcase(yyruleno==498);
      case 499: /* table_reference ::= joined_table */ yytestcase(yyruleno==499);
      case 503: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==503);
      case 561: /* query_simple ::= query_specification */ yytestcase(yyruleno==561);
      case 562: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==562);
      case 565: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==565);
      case 567: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==567);
#line 667 "sql.y"
{ yylhsminor.yy164 = yymsp[0].minor.yy164; }
#line 6244 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 371: /* literal ::= NULL */
#line 668 "sql.y"
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
#line 6250 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 372: /* literal ::= NK_QUESTION */
#line 669 "sql.y"
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
#line 6256 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 373: /* duration_literal ::= NK_VARIABLE */
#line 671 "sql.y"
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
#line 6262 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 374: /* signed ::= NK_INTEGER */
#line 673 "sql.y"
{ yylhsminor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
#line 6268 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 375: /* signed ::= NK_PLUS NK_INTEGER */
#line 674 "sql.y"
{ yymsp[-1].minor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
#line 6274 "sql.c"
        break;
      case 376: /* signed ::= NK_MINUS NK_INTEGER */
#line 675 "sql.y"
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
#line 6283 "sql.c"
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 377: /* signed ::= NK_FLOAT */
#line 680 "sql.y"
{ yylhsminor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
#line 6289 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 378: /* signed ::= NK_PLUS NK_FLOAT */
#line 681 "sql.y"
{ yymsp[-1].minor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
#line 6295 "sql.c"
        break;
      case 379: /* signed ::= NK_MINUS NK_FLOAT */
#line 682 "sql.y"
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
#line 6304 "sql.c"
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 381: /* signed_literal ::= NK_STRING */
#line 689 "sql.y"
{ yylhsminor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
#line 6310 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 382: /* signed_literal ::= NK_BOOL */
#line 690 "sql.y"
{ yylhsminor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
#line 6316 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 383: /* signed_literal ::= TIMESTAMP NK_STRING */
#line 691 "sql.y"
{ yymsp[-1].minor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
#line 6322 "sql.c"
        break;
      case 384: /* signed_literal ::= duration_literal */
      case 386: /* signed_literal ::= literal_func */ yytestcase(yyruleno==386);
      case 457: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==457);
      case 519: /* select_item ::= common_expression */ yytestcase(yyruleno==519);
      case 529: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==529);
      case 566: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==566);
      case 568: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==568);
      case 581: /* search_condition ::= common_expression */ yytestcase(yyruleno==581);
#line 692 "sql.y"
{ yylhsminor.yy164 = releaseRawExprNode(pCxt, yymsp[0].minor.yy164); }
#line 6334 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 385: /* signed_literal ::= NULL */
#line 693 "sql.y"
{ yylhsminor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
#line 6340 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 387: /* signed_literal ::= NK_QUESTION */
#line 695 "sql.y"
{ yylhsminor.yy164 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
#line 6346 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 407: /* expression ::= NK_LP expression NK_RP */
      case 491: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==491);
      case 580: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==580);
#line 756 "sql.y"
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy164)); }
#line 6354 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 408: /* expression ::= NK_PLUS expr_or_subquery */
#line 757 "sql.y"
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy164));
                                                                                  }
#line 6363 "sql.c"
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 409: /* expression ::= NK_MINUS expr_or_subquery */
#line 761 "sql.y"
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy164), NULL));
                                                                                  }
#line 6372 "sql.c"
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 410: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
#line 765 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164))); 
                                                                                  }
#line 6382 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 411: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
#line 770 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164))); 
                                                                                  }
#line 6392 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 412: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
#line 775 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164))); 
                                                                                  }
#line 6402 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 413: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
#line 780 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164))); 
                                                                                  }
#line 6412 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 414: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
#line 785 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
#line 6422 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 415: /* expression ::= column_reference NK_ARROW NK_STRING */
#line 790 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
#line 6431 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 416: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
#line 794 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
#line 6441 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 417: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
#line 799 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
#line 6451 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 420: /* column_reference ::= column_name */
#line 810 "sql.y"
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy497, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy497)); }
#line 6457 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 421: /* column_reference ::= table_name NK_DOT column_name */
#line 811 "sql.y"
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy497, &yymsp[0].minor.yy497, createColumnNode(pCxt, &yymsp[-2].minor.yy497, &yymsp[0].minor.yy497)); }
#line 6463 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 422: /* pseudo_column ::= ROWTS */
      case 423: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==423);
      case 425: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==425);
      case 426: /* pseudo_column ::= QEND */ yytestcase(yyruleno==426);
      case 427: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==427);
      case 428: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==428);
      case 429: /* pseudo_column ::= WEND */ yytestcase(yyruleno==429);
      case 430: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==430);
      case 431: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==431);
      case 432: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==432);
      case 433: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==433);
      case 439: /* literal_func ::= NOW */ yytestcase(yyruleno==439);
#line 813 "sql.y"
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
#line 6480 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 424: /* pseudo_column ::= table_name NK_DOT TBNAME */
#line 815 "sql.y"
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy497, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy497)))); }
#line 6486 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 434: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 435: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==435);
#line 826 "sql.y"
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy497, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy497, yymsp[-1].minor.yy72)); }
#line 6493 "sql.c"
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 436: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
#line 829 "sql.y"
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), yymsp[-1].minor.yy700)); }
#line 6499 "sql.c"
  yymsp[-5].minor.yy164 = yylhsminor.yy164;
        break;
      case 438: /* literal_func ::= noarg_func NK_LP NK_RP */
#line 832 "sql.y"
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy497, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy497, NULL)); }
#line 6505 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 453: /* star_func_para_list ::= NK_STAR */
#line 856 "sql.y"
{ yylhsminor.yy72 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
#line 6511 "sql.c"
  yymsp[0].minor.yy72 = yylhsminor.yy72;
        break;
      case 458: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 522: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==522);
#line 865 "sql.y"
{ yylhsminor.yy164 = createColumnNode(pCxt, &yymsp[-2].minor.yy497, &yymsp[0].minor.yy0); }
#line 6518 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 459: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
#line 868 "sql.y"
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy72, yymsp[-1].minor.yy164)); }
#line 6524 "sql.c"
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 460: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
#line 870 "sql.y"
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), yymsp[-2].minor.yy72, yymsp[-1].minor.yy164)); }
#line 6530 "sql.c"
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 463: /* when_then_expr ::= WHEN common_expression THEN common_expression */
#line 877 "sql.y"
{ yymsp[-3].minor.yy164 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)); }
#line 6536 "sql.c"
        break;
      case 465: /* case_when_else_opt ::= ELSE common_expression */
#line 880 "sql.y"
{ yymsp[-1].minor.yy164 = releaseRawExprNode(pCxt, yymsp[0].minor.yy164); }
#line 6541 "sql.c"
        break;
      case 466: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 471: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==471);
#line 883 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy796, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
#line 6551 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 467: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
#line 890 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy164), releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
#line 6561 "sql.c"
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 468: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
#line 896 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy164), releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
#line 6571 "sql.c"
  yymsp[-5].minor.yy164 = yylhsminor.yy164;
        break;
      case 469: /* predicate ::= expr_or_subquery IS NULL */
#line 901 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), NULL));
                                                                                  }
#line 6580 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 470: /* predicate ::= expr_or_subquery IS NOT NULL */
#line 905 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), NULL));
                                                                                  }
#line 6589 "sql.c"
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 472: /* compare_op ::= NK_LT */
#line 917 "sql.y"
{ yymsp[0].minor.yy796 = OP_TYPE_LOWER_THAN; }
#line 6595 "sql.c"
        break;
      case 473: /* compare_op ::= NK_GT */
#line 918 "sql.y"
{ yymsp[0].minor.yy796 = OP_TYPE_GREATER_THAN; }
#line 6600 "sql.c"
        break;
      case 474: /* compare_op ::= NK_LE */
#line 919 "sql.y"
{ yymsp[0].minor.yy796 = OP_TYPE_LOWER_EQUAL; }
#line 6605 "sql.c"
        break;
      case 475: /* compare_op ::= NK_GE */
#line 920 "sql.y"
{ yymsp[0].minor.yy796 = OP_TYPE_GREATER_EQUAL; }
#line 6610 "sql.c"
        break;
      case 476: /* compare_op ::= NK_NE */
#line 921 "sql.y"
{ yymsp[0].minor.yy796 = OP_TYPE_NOT_EQUAL; }
#line 6615 "sql.c"
        break;
      case 477: /* compare_op ::= NK_EQ */
#line 922 "sql.y"
{ yymsp[0].minor.yy796 = OP_TYPE_EQUAL; }
#line 6620 "sql.c"
        break;
      case 478: /* compare_op ::= LIKE */
#line 923 "sql.y"
{ yymsp[0].minor.yy796 = OP_TYPE_LIKE; }
#line 6625 "sql.c"
        break;
      case 479: /* compare_op ::= NOT LIKE */
#line 924 "sql.y"
{ yymsp[-1].minor.yy796 = OP_TYPE_NOT_LIKE; }
#line 6630 "sql.c"
        break;
      case 480: /* compare_op ::= MATCH */
#line 925 "sql.y"
{ yymsp[0].minor.yy796 = OP_TYPE_MATCH; }
#line 6635 "sql.c"
        break;
      case 481: /* compare_op ::= NMATCH */
#line 926 "sql.y"
{ yymsp[0].minor.yy796 = OP_TYPE_NMATCH; }
#line 6640 "sql.c"
        break;
      case 482: /* compare_op ::= CONTAINS */
#line 927 "sql.y"
{ yymsp[0].minor.yy796 = OP_TYPE_JSON_CONTAINS; }
#line 6645 "sql.c"
        break;
      case 483: /* in_op ::= IN */
#line 931 "sql.y"
{ yymsp[0].minor.yy796 = OP_TYPE_IN; }
#line 6650 "sql.c"
        break;
      case 484: /* in_op ::= NOT IN */
#line 932 "sql.y"
{ yymsp[-1].minor.yy796 = OP_TYPE_NOT_IN; }
#line 6655 "sql.c"
        break;
      case 485: /* in_predicate_value ::= NK_LP literal_list NK_RP */
#line 934 "sql.y"
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy72)); }
#line 6660 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 487: /* boolean_value_expression ::= NOT boolean_primary */
#line 938 "sql.y"
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy164), NULL));
                                                                                  }
#line 6669 "sql.c"
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 488: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
#line 943 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
#line 6679 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 489: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
#line 949 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
#line 6689 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 497: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
#line 967 "sql.y"
{ yylhsminor.yy164 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, NULL); }
#line 6695 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 500: /* table_primary ::= table_name alias_opt */
#line 973 "sql.y"
{ yylhsminor.yy164 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy497, &yymsp[0].minor.yy497); }
#line 6701 "sql.c"
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 501: /* table_primary ::= db_name NK_DOT table_name alias_opt */
#line 974 "sql.y"
{ yylhsminor.yy164 = createRealTableNode(pCxt, &yymsp[-3].minor.yy497, &yymsp[-1].minor.yy497, &yymsp[0].minor.yy497); }
#line 6707 "sql.c"
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 502: /* table_primary ::= subquery alias_opt */
#line 975 "sql.y"
{ yylhsminor.yy164 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy164), &yymsp[0].minor.yy497); }
#line 6713 "sql.c"
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 504: /* alias_opt ::= */
#line 980 "sql.y"
{ yymsp[1].minor.yy497 = nil_token;  }
#line 6719 "sql.c"
        break;
      case 506: /* alias_opt ::= AS table_alias */
#line 982 "sql.y"
{ yymsp[-1].minor.yy497 = yymsp[0].minor.yy497; }
#line 6724 "sql.c"
        break;
      case 507: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 508: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==508);
#line 984 "sql.y"
{ yymsp[-2].minor.yy164 = yymsp[-1].minor.yy164; }
#line 6730 "sql.c"
        break;
      case 509: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
#line 989 "sql.y"
{ yylhsminor.yy164 = createJoinTableNode(pCxt, yymsp[-4].minor.yy196, yymsp[-5].minor.yy164, yymsp[-2].minor.yy164, yymsp[0].minor.yy164); }
#line 6735 "sql.c"
  yymsp[-5].minor.yy164 = yylhsminor.yy164;
        break;
      case 510: /* join_type ::= */
#line 993 "sql.y"
{ yymsp[1].minor.yy196 = JOIN_TYPE_INNER; }
#line 6741 "sql.c"
        break;
      case 511: /* join_type ::= INNER */
#line 994 "sql.y"
{ yymsp[0].minor.yy196 = JOIN_TYPE_INNER; }
#line 6746 "sql.c"
        break;
      case 512: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
#line 1000 "sql.y"
{ 
                                                                                    yymsp[-11].minor.yy164 = createSelectStmt(pCxt, yymsp[-10].minor.yy441, yymsp[-9].minor.yy72, yymsp[-8].minor.yy164);
                                                                                    yymsp[-11].minor.yy164 = addWhereClause(pCxt, yymsp[-11].minor.yy164, yymsp[-7].minor.yy164);
                                                                                    yymsp[-11].minor.yy164 = addPartitionByClause(pCxt, yymsp[-11].minor.yy164, yymsp[-6].minor.yy72);
                                                                                    yymsp[-11].minor.yy164 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy164, yymsp[-2].minor.yy164);
                                                                                    yymsp[-11].minor.yy164 = addGroupByClause(pCxt, yymsp[-11].minor.yy164, yymsp[-1].minor.yy72);
                                                                                    yymsp[-11].minor.yy164 = addHavingClause(pCxt, yymsp[-11].minor.yy164, yymsp[0].minor.yy164);
                                                                                    yymsp[-11].minor.yy164 = addRangeClause(pCxt, yymsp[-11].minor.yy164, yymsp[-5].minor.yy164);
                                                                                    yymsp[-11].minor.yy164 = addEveryClause(pCxt, yymsp[-11].minor.yy164, yymsp[-4].minor.yy164);
                                                                                    yymsp[-11].minor.yy164 = addFillClause(pCxt, yymsp[-11].minor.yy164, yymsp[-3].minor.yy164);
                                                                                  }
#line 6761 "sql.c"
        break;
      case 515: /* set_quantifier_opt ::= ALL */
#line 1016 "sql.y"
{ yymsp[0].minor.yy441 = false; }
#line 6766 "sql.c"
        break;
      case 518: /* select_item ::= NK_STAR */
#line 1023 "sql.y"
{ yylhsminor.yy164 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
#line 6771 "sql.c"
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 520: /* select_item ::= common_expression column_alias */
      case 530: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==530);
#line 1025 "sql.y"
{ yylhsminor.yy164 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy164), &yymsp[0].minor.yy497); }
#line 6778 "sql.c"
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 521: /* select_item ::= common_expression AS column_alias */
      case 531: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==531);
#line 1026 "sql.y"
{ yylhsminor.yy164 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), &yymsp[0].minor.yy497); }
#line 6785 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 526: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 551: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==551);
      case 570: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==570);
#line 1035 "sql.y"
{ yymsp[-2].minor.yy72 = yymsp[0].minor.yy72; }
#line 6793 "sql.c"
        break;
      case 533: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
#line 1048 "sql.y"
{ yymsp[-5].minor.yy164 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), releaseRawExprNode(pCxt, yymsp[-1].minor.yy164)); }
#line 6798 "sql.c"
        break;
      case 534: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
#line 1049 "sql.y"
{ yymsp[-3].minor.yy164 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy164)); }
#line 6803 "sql.c"
        break;
      case 535: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
#line 1051 "sql.y"
{ yymsp[-5].minor.yy164 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), NULL, yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
#line 6808 "sql.c"
        break;
      case 536: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
#line 1054 "sql.y"
{ yymsp[-7].minor.yy164 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy164), releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
#line 6813 "sql.c"
        break;
      case 537: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
#line 1056 "sql.y"
{ yymsp[-6].minor.yy164 = createEventWindowNode(pCxt, yymsp[-3].minor.yy164, yymsp[0].minor.yy164); }
#line 6818 "sql.c"
        break;
      case 541: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
#line 1062 "sql.y"
{ yymsp[-3].minor.yy164 = createFillNode(pCxt, yymsp[-1].minor.yy446, NULL); }
#line 6823 "sql.c"
        break;
      case 542: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
#line 1063 "sql.y"
{ yymsp[-5].minor.yy164 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy72)); }
#line 6828 "sql.c"
        break;
      case 543: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
#line 1064 "sql.y"
{ yymsp[-5].minor.yy164 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy72)); }
#line 6833 "sql.c"
        break;
      case 544: /* fill_mode ::= NONE */
#line 1068 "sql.y"
{ yymsp[0].minor.yy446 = FILL_MODE_NONE; }
#line 6838 "sql.c"
        break;
      case 545: /* fill_mode ::= PREV */
#line 1069 "sql.y"
{ yymsp[0].minor.yy446 = FILL_MODE_PREV; }
#line 6843 "sql.c"
        break;
      case 546: /* fill_mode ::= NULL */
#line 1070 "sql.y"
{ yymsp[0].minor.yy446 = FILL_MODE_NULL; }
#line 6848 "sql.c"
        break;
      case 547: /* fill_mode ::= NULL_F */
#line 1071 "sql.y"
{ yymsp[0].minor.yy446 = FILL_MODE_NULL_F; }
#line 6853 "sql.c"
        break;
      case 548: /* fill_mode ::= LINEAR */
#line 1072 "sql.y"
{ yymsp[0].minor.yy446 = FILL_MODE_LINEAR; }
#line 6858 "sql.c"
        break;
      case 549: /* fill_mode ::= NEXT */
#line 1073 "sql.y"
{ yymsp[0].minor.yy446 = FILL_MODE_NEXT; }
#line 6863 "sql.c"
        break;
      case 552: /* group_by_list ::= expr_or_subquery */
#line 1082 "sql.y"
{ yylhsminor.yy72 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy164))); }
#line 6868 "sql.c"
  yymsp[0].minor.yy72 = yylhsminor.yy72;
        break;
      case 553: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
#line 1083 "sql.y"
{ yylhsminor.yy72 = addNodeToList(pCxt, yymsp[-2].minor.yy72, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy164))); }
#line 6874 "sql.c"
  yymsp[-2].minor.yy72 = yylhsminor.yy72;
        break;
      case 557: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
#line 1090 "sql.y"
{ yymsp[-5].minor.yy164 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), releaseRawExprNode(pCxt, yymsp[-1].minor.yy164)); }
#line 6880 "sql.c"
        break;
      case 560: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
#line 1097 "sql.y"
{
                                                                                    yylhsminor.yy164 = addOrderByClause(pCxt, yymsp[-3].minor.yy164, yymsp[-2].minor.yy72);
                                                                                    yylhsminor.yy164 = addSlimitClause(pCxt, yylhsminor.yy164, yymsp[-1].minor.yy164);
                                                                                    yylhsminor.yy164 = addLimitClause(pCxt, yylhsminor.yy164, yymsp[0].minor.yy164);
                                                                                  }
#line 6889 "sql.c"
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 563: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
#line 1107 "sql.y"
{ yylhsminor.yy164 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy164, yymsp[0].minor.yy164); }
#line 6895 "sql.c"
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 564: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
#line 1109 "sql.y"
{ yylhsminor.yy164 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy164, yymsp[0].minor.yy164); }
#line 6901 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 572: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 576: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==576);
#line 1123 "sql.y"
{ yymsp[-1].minor.yy164 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
#line 6908 "sql.c"
        break;
      case 573: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 577: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==577);
#line 1124 "sql.y"
{ yymsp[-3].minor.yy164 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
#line 6914 "sql.c"
        break;
      case 574: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 578: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==578);
#line 1125 "sql.y"
{ yymsp[-3].minor.yy164 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
#line 6920 "sql.c"
        break;
      case 579: /* subquery ::= NK_LP query_expression NK_RP */
#line 1133 "sql.y"
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy164); }
#line 6925 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 584: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
#line 1147 "sql.y"
{ yylhsminor.yy164 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), yymsp[-1].minor.yy550, yymsp[0].minor.yy517); }
#line 6931 "sql.c"
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 585: /* ordering_specification_opt ::= */
#line 1151 "sql.y"
{ yymsp[1].minor.yy550 = ORDER_ASC; }
#line 6937 "sql.c"
        break;
      case 586: /* ordering_specification_opt ::= ASC */
#line 1152 "sql.y"
{ yymsp[0].minor.yy550 = ORDER_ASC; }
#line 6942 "sql.c"
        break;
      case 587: /* ordering_specification_opt ::= DESC */
#line 1153 "sql.y"
{ yymsp[0].minor.yy550 = ORDER_DESC; }
#line 6947 "sql.c"
        break;
      case 588: /* null_ordering_opt ::= */
#line 1157 "sql.y"
{ yymsp[1].minor.yy517 = NULL_ORDER_DEFAULT; }
#line 6952 "sql.c"
        break;
      case 589: /* null_ordering_opt ::= NULLS FIRST */
#line 1158 "sql.y"
{ yymsp[-1].minor.yy517 = NULL_ORDER_FIRST; }
#line 6957 "sql.c"
        break;
      case 590: /* null_ordering_opt ::= NULLS LAST */
#line 1159 "sql.y"
{ yymsp[-1].minor.yy517 = NULL_ORDER_LAST; }
#line 6962 "sql.c"
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/
#line 29 "sql.y"

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
#line 7035 "sql.c"
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
