import sys
from util.log import *
from util.cases import *
from util.sql import *
from util.dnodes import tdDnodes
from math import inf


class TDTestCase:
    def caseDescription(self):
        """
        case1<shenglian zhou>: [TD-14565]power/log test case. log support default param e
        """
        return

    def init(self, conn, logSql):
        tdLog.debug("start to execute %s" % __file__)
        tdSql.init(conn.cursor(), logSql)
        self._conn = conn

    def restartTaosd(self, index=1, dbname="db"):
        tdDnodes.stop(index)
        tdDnodes.startWithoutSleep(index)
        tdSql.execute(f"use db0")

    def run(self):
        print("running {}".format(__file__))
        tdSql.execute("drop database if exists db0")
        tdSql.execute("create database if not exists db0")
        tdSql.execute("use db0")

        tdSql.execute(
            "create table st0 (ts timestamp, c1 int, c2 float, c3 bigint, c4 smallint, c5 tinyint, c6 double, c7 bool, c8 nchar(5), c9 binary(10)) TAGS (tgcol int);"
        )

        tdSql.execute("create table ct0 using st0 tags( 0 );")

        tdSql.execute(
            "insert into ct0 values (1601481600000 , 0 , 0.25 , 0 , 0 , 0 , 0.25 , 0 , 0 , 0 );"
        )

        tdSql.execute(
            "insert into ct0 values (1601481660000 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 );"
        )

        tdSql.execute(
            "insert into ct0 values (1601481720000 , 2 , 2 , 2 , 2 , 2 , 2 , 2 , 2 , 2 );"
        )

        tdSql.execute(
            "insert into ct0 values (1601481780000 , 3 , 3 , 3 , 3 , 3 , 3 , 3 , 3 , 3 );"
        )

        tdSql.execute(
            "insert into ct0 values (1601481840000 , 4 , 4 , 4 , 4 , 4 , 4 , 4 , 4 , 4 );"
        )

        tdSql.execute(
            "insert into ct0 values (1601481900000 , 5 , 5 , 5 , 5 , 5 , 5 , 5 , 5 , 5 );"
        )

        tdSql.execute(
            "insert into ct0 values (1601481960000 , 6 , 6 , 6 , 6 , 6 , 6 , 6 , 6 , 6 );"
        )

        tdSql.execute(
            "insert into ct0 values (1601482020000 , 7 , 7 , 7 , 7 , 7 , 7 , 7 , 7 , 7 );"
        )

        tdSql.execute(
            "insert into ct0 values (1601482080000 , 8 , 8 , 8 , 8 , 8 , 8 , 8 , 8 , 8 );"
        )

        tdSql.execute(
            "insert into ct0 values (1601482140000 , 9 , 9 , 9 , 9 , 9 , 9 , 9 , 9 , 9 );"
        )

        tdSql.execute("create table ct1 using st0 tags( 1 );")

        tdSql.execute(
            "insert into ct1 values (1601481600000 , 0 , 0.25 , 0 , 0 , 0 , 0.25 , 0 , 0 , 0 );"
        )

        tdSql.execute(
            "insert into ct1 values (1601481660000 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 , 1 );"
        )

        tdSql.execute(
            "insert into ct1 values (1601481720000 , 2 , 2 , 2 , 2 , 2 , 2 , 2 , 2 , 2 );"
        )

        tdSql.execute(
            "insert into ct1 values (1601481780000 , 3 , 3 , 3 , 3 , 3 , 3 , 3 , 3 , 3 );"
        )

        tdSql.execute(
            "insert into ct1 values (1601481840000 , 4 , 4 , 4 , 4 , 4 , 4 , 4 , 4 , 4 );"
        )

        tdSql.execute(
            "insert into ct1 values (1601481900000 , 5 , 5 , 5 , 5 , 5 , 5 , 5 , 5 , 5 );"
        )

        tdSql.execute(
            "insert into ct1 values (1601481960000 , 6 , 6 , 6 , 6 , 6 , 6 , 6 , 6 , 6 );"
        )

        tdSql.execute(
            "insert into ct1 values (1601482020000 , 7 , 7 , 7 , 7 , 7 , 7 , 7 , 7 , 7 );"
        )

        tdSql.execute(
            "insert into ct1 values (1601482080000 , 8 , 8 , 8 , 8 , 8 , 8 , 8 , 8 , 8 );"
        )

        tdSql.execute(
            "insert into ct1 values (1601482140000 , 9 , 9 , 9 , 9 , 9 , 9 , 9 , 9 , 9 );"
        )

        tdSql.execute(
            "insert into ct1 values (1601482200000 , 10 , 10 , 10 , 10 , 10 , 10 , 10 , 10 , 10 );"
        )

        tdSql.execute(
            "insert into ct1 values (1601482260000 , 11 , 11 , 11 , 11 , 11 , 11 , 11 , 11 , 11 );"
        )

        tdSql.execute(
            "insert into ct1 values (1601482320000 , 12 , 12 , 12 , 12 , 12 , 12 , 12 , 12 , 12 );"
        )

        tdSql.execute(
            "insert into ct1 values (1601482380000 , 13 , 13 , 13 , 13 , 13 , 13 , 13 , 13 , 13 );"
        )

        tdSql.execute(
            "insert into ct1 values (1601482440000 , 14 , 14 , 14 , 14 , 14 , 14 , 14 , 14 , 14 );"
        )

        tdSql.execute(
            "insert into ct1 values (1601482500000 , 15 , 15 , 15 , 15 , 15 , 15 , 15 , 15 , 15 );"
        )

        tdSql.execute(
            "insert into ct1 values (1601482560000 , 16 , 16 , 16 , 16 , 16 , 16 , 16 , 16 , 16 );"
        )

        tdSql.execute(
            "insert into ct1 values (1601482620000 , 17 , 17 , 17 , 17 , 17 , 17 , 17 , 17 , 17 );"
        )

        tdSql.execute(
            "insert into ct1 values (1601482680000 , 18 , 18 , 18 , 18 , 18 , 18 , 18 , 18 , 18 );"
        )

        tdSql.execute(
            "insert into ct1 values (1601482740000 , 19 , 19 , 19 , 19 , 19 , 19 , 19 , 19 , 19 );"
        )

        tdSql.query(
            "select c1, log(c2, 2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3, 2)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1,2)+log(c3,4)+pow(c6,2.8)+2 as v6 from ct1;"
        )
        tdSql.checkRows(20)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -2.0)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(1, 1, 0.0)
        tdSql.checkData(1, 2, 1.0)
        tdSql.checkData(1, 3, 3.0)
        tdSql.checkData(1, 4, 2.0)
        tdSql.checkData(1, 5, 2.0)
        tdSql.checkData(1, 6, 3.0)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(2, 1, 1.0)
        tdSql.checkData(2, 2, 4.0)
        tdSql.checkData(2, 3, 6.0)
        tdSql.checkData(2, 4, 13.0)
        tdSql.checkData(2, 5, 26.627416997969522)
        tdSql.checkData(2, 6, 10.464404506368993)
        tdSql.checkData(3, 0, 3)
        tdSql.checkData(3, 1, 1.5849625007211563)
        tdSql.checkData(3, 2, 9.0)
        tdSql.checkData(3, 3, 11.0)
        tdSql.checkData(3, 4, 37.58496250072116)
        tdSql.checkData(3, 5, 149.29611541307906)
        tdSql.checkData(3, 6, 26.05146591860796)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(4, 1, 2.0)
        tdSql.checkData(4, 2, 16.0)
        tdSql.checkData(4, 3, 18.0)
        tdSql.checkData(4, 4, 82.0)
        tdSql.checkData(4, 5, 528.0)
        tdSql.checkData(4, 6, 53.50293012833273)
        tdSql.checkData(5, 0, 5)
        tdSql.checkData(5, 1, 2.321928094887362)
        tdSql.checkData(5, 2, 25.0)
        tdSql.checkData(5, 3, 27.0)
        tdSql.checkData(5, 4, 152.32192809488737)
        tdSql.checkData(5, 5, 1422.5424859373686)
        tdSql.checkData(5, 6, 96.08035010204296)
        tdSql.checkData(6, 0, 6)
        tdSql.checkData(6, 1, 2.584962500721156)
        tdSql.checkData(6, 2, 36.0)
        tdSql.checkData(6, 3, 38.0)
        tdSql.checkData(6, 4, 254.58496250072116)
        tdSql.checkData(6, 5, 3210.538706646999)
        tdSql.checkData(6, 6, 156.8241014057428)
        tdSql.checkData(7, 0, 7)
        tdSql.checkData(7, 1, 2.807354922057604)
        tdSql.checkData(7, 2, 49.0)
        tdSql.checkData(7, 3, 51.0)
        tdSql.checkData(7, 4, 394.8073549220576)
        tdSql.checkData(7, 5, 6401.448897866082)
        tdSql.checkData(7, 6, 238.6315756794513)
        tdSql.checkData(8, 0, 8)
        tdSql.checkData(8, 1, 3.0)
        tdSql.checkData(8, 2, 64.0)
        tdSql.checkData(8, 3, 66.0)
        tdSql.checkData(8, 4, 579.0)
        tdSql.checkData(8, 5, 11649.237502960395)
        tdSql.checkData(8, 6, 344.2940251578608)
        tdSql.checkData(9, 0, 9)
        tdSql.checkData(9, 1, 3.1699250014423126)
        tdSql.checkData(9, 2, 81.0)
        tdSql.checkData(9, 3, 83.0)
        tdSql.checkData(9, 4, 813.1699250014423)
        tdSql.checkData(9, 5, 19764.0)
        tdSql.checkData(9, 6, 476.5181244205816)
        tdSql.checkData(10, 0, 10)
        tdSql.checkData(10, 1, 3.3219280948873626)
        tdSql.checkData(10, 2, 100.0)
        tdSql.checkData(10, 3, 102.0)
        tdSql.checkData(10, 4, 1103.3219280948874)
        tdSql.checkData(10, 5, 31722.776601683792)
        tdSql.checkData(10, 6, 637.940236622524)
        tdSql.checkData(11, 0, 11)
        tdSql.checkData(11, 1, 3.4594316186372978)
        tdSql.checkData(11, 2, 121.0)
        tdSql.checkData(11, 3, 123.0)
        tdSql.checkData(11, 4, 1455.4594316186374)
        tdSql.checkData(11, 5, 48679.70355559341)
        tdSql.checkData(11, 6, 831.1366058581541)
        tdSql.checkData(12, 0, 12)
        tdSql.checkData(12, 1, 3.5849625007211565)
        tdSql.checkData(12, 2, 144.0)
        tdSql.checkData(12, 3, 146.0)
        tdSql.checkData(12, 4, 1875.584962500721)
        tdSql.checkData(12, 5, 71975.61109149648)
        tdSql.checkData(12, 6, 1058.631026542541)
        tdSql.checkData(13, 0, 13)
        tdSql.checkData(13, 1, 3.700439718141092)
        tdSql.checkData(13, 2, 169.0)
        tdSql.checkData(13, 3, 171.0)
        tdSql.checkData(13, 4, 2369.7004397181413)
        tdSql.checkData(13, 5, 103147.149978527)
        tdSql.checkData(13, 6, 1322.9008332018816)
        tdSql.checkData(14, 0, 14)
        tdSql.checkData(14, 1, 3.8073549220576037)
        tdSql.checkData(14, 2, 196.0)
        tdSql.checkData(14, 3, 198.0)
        tdSql.checkData(14, 4, 2943.8073549220576)
        tdSql.checkData(14, 5, 143935.51017030774)
        tdSql.checkData(14, 6, 1626.3817114890194)
        tdSql.checkData(15, 0, 15)
        tdSql.checkData(15, 1, 3.9068905956085187)
        tdSql.checkData(15, 2, 225.0)
        tdSql.checkData(15, 3, 227.0)
        tdSql.checkData(15, 4, 3603.9068905956087)
        tdSql.checkData(15, 5, 196294.78190175048)
        tdSql.checkData(15, 6, 1971.471648033734)
        tdSql.checkData(16, 0, 16)
        tdSql.checkData(16, 1, 4.0)
        tdSql.checkData(16, 2, 256.0)
        tdSql.checkData(16, 3, 258.0)
        tdSql.checkData(16, 4, 4356.0)
        tdSql.checkData(16, 5, 262400.0)
        tdSql.checkData(16, 6, 2360.5342310339265)
        tdSql.checkData(17, 0, 17)
        tdSql.checkData(17, 1, 4.08746284125034)
        tdSql.checkData(17, 2, 289.0)
        tdSql.checkData(17, 3, 291.0)
        tdSql.checkData(17, 4, 5206.08746284125)
        tdSql.checkData(17, 5, 344654.9049572126)
        tdSql.checkData(17, 6, 2795.901448766347)
        tdSql.checkData(18, 0, 18)
        tdSql.checkData(18, 1, 4.169925001442312)
        tdSql.checkData(18, 2, 324.0)
        tdSql.checkData(18, 3, 326.0)
        tdSql.checkData(18, 4, 6160.169925001443)
        tdSql.checkData(18, 5, 445699.4487710341)
        tdSql.checkData(18, 6, 3279.8760916232795)
        tdSql.checkData(19, 0, 19)
        tdSql.checkData(19, 1, 4.247927513443585)
        tdSql.checkData(19, 2, 361.0)
        tdSql.checkData(19, 3, 363.0)
        tdSql.checkData(19, 4, 7224.247927513444)
        tdSql.checkData(19, 5, 568417.0692211641)
        tdSql.checkData(19, 6, 3814.7338355198453)

        tdSql.query(
            "select c1, log(c2, 2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3, 2)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1,2)+log(c3,4)+pow(c6,2.8)+2 as v6 from ct1 where ts == 1601481600000;"
        )
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -2.0)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)

        tdSql.query(
            "select c1, log(c2, 2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3, 2)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1,2)+log(c3,4)+pow(c6,2.8)+2 as v6 from st0 where ts == 1601481600000;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -2.0)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)
        tdSql.checkData(1, 0, 0)
        tdSql.checkData(1, 1, -2.0)
        tdSql.checkData(1, 2, 0.0)
        tdSql.checkData(1, 3, 2.0625)
        tdSql.checkData(1, 4, -inf)
        tdSql.checkData(1, 5, 0.0)
        tdSql.checkData(1, 6, -inf)

        tdSql.query(
            "select c1, log(c2, 2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3, 2)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1,2)+log(c3,4)+pow(c6,2.8)+2 as v6 from st0 where c1 == 0;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -2.0)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)
        tdSql.checkData(1, 0, 0)
        tdSql.checkData(1, 1, -2.0)
        tdSql.checkData(1, 2, 0.0)
        tdSql.checkData(1, 3, 2.0625)
        tdSql.checkData(1, 4, -inf)
        tdSql.checkData(1, 5, 0.0)
        tdSql.checkData(1, 6, -inf)

        tdSql.query(
            "select c1, log(c2, 2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3, 2)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1,2)+log(c3,4)+pow(c6,2.8)+2 as v6 from st0 where c1 == 0;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -2.0)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)
        tdSql.checkData(1, 0, 0)
        tdSql.checkData(1, 1, -2.0)
        tdSql.checkData(1, 2, 0.0)
        tdSql.checkData(1, 3, 2.0625)
        tdSql.checkData(1, 4, -inf)
        tdSql.checkData(1, 5, 0.0)
        tdSql.checkData(1, 6, -inf)

        tdSql.query(
            "select c1, log(c2, 2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3, 2)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1,2)+log(c3,4)+pow(c6,2.8)+2 as v6 from st0 order by ts desc;"
        )
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, 19)
        tdSql.checkData(0, 1, 4.247927513443585)
        tdSql.checkData(0, 2, 361.0)
        tdSql.checkData(0, 3, 363.0)
        tdSql.checkData(0, 4, 7224.247927513444)
        tdSql.checkData(0, 5, 568417.0692211641)
        tdSql.checkData(0, 6, 3814.7338355198453)
        tdSql.checkData(1, 0, 18)
        tdSql.checkData(1, 1, 4.169925001442312)
        tdSql.checkData(1, 2, 324.0)
        tdSql.checkData(1, 3, 326.0)
        tdSql.checkData(1, 4, 6160.169925001443)
        tdSql.checkData(1, 5, 445699.4487710341)
        tdSql.checkData(1, 6, 3279.8760916232795)
        tdSql.checkData(2, 0, 17)
        tdSql.checkData(2, 1, 4.08746284125034)
        tdSql.checkData(2, 2, 289.0)
        tdSql.checkData(2, 3, 291.0)
        tdSql.checkData(2, 4, 5206.08746284125)
        tdSql.checkData(2, 5, 344654.9049572126)
        tdSql.checkData(2, 6, 2795.901448766347)
        tdSql.checkData(3, 0, 16)
        tdSql.checkData(3, 1, 4.0)
        tdSql.checkData(3, 2, 256.0)
        tdSql.checkData(3, 3, 258.0)
        tdSql.checkData(3, 4, 4356.0)
        tdSql.checkData(3, 5, 262400.0)
        tdSql.checkData(3, 6, 2360.5342310339265)
        tdSql.checkData(4, 0, 15)
        tdSql.checkData(4, 1, 3.9068905956085187)
        tdSql.checkData(4, 2, 225.0)
        tdSql.checkData(4, 3, 227.0)
        tdSql.checkData(4, 4, 3603.9068905956087)
        tdSql.checkData(4, 5, 196294.78190175048)
        tdSql.checkData(4, 6, 1971.471648033734)
        tdSql.checkData(5, 0, 14)
        tdSql.checkData(5, 1, 3.8073549220576037)
        tdSql.checkData(5, 2, 196.0)
        tdSql.checkData(5, 3, 198.0)
        tdSql.checkData(5, 4, 2943.8073549220576)
        tdSql.checkData(5, 5, 143935.51017030774)
        tdSql.checkData(5, 6, 1626.3817114890194)
        tdSql.checkData(6, 0, 13)
        tdSql.checkData(6, 1, 3.700439718141092)
        tdSql.checkData(6, 2, 169.0)
        tdSql.checkData(6, 3, 171.0)
        tdSql.checkData(6, 4, 2369.7004397181413)
        tdSql.checkData(6, 5, 103147.149978527)
        tdSql.checkData(6, 6, 1322.9008332018816)
        tdSql.checkData(7, 0, 12)
        tdSql.checkData(7, 1, 3.5849625007211565)
        tdSql.checkData(7, 2, 144.0)
        tdSql.checkData(7, 3, 146.0)
        tdSql.checkData(7, 4, 1875.584962500721)
        tdSql.checkData(7, 5, 71975.61109149648)
        tdSql.checkData(7, 6, 1058.631026542541)
        tdSql.checkData(8, 0, 11)
        tdSql.checkData(8, 1, 3.4594316186372978)
        tdSql.checkData(8, 2, 121.0)
        tdSql.checkData(8, 3, 123.0)
        tdSql.checkData(8, 4, 1455.4594316186374)
        tdSql.checkData(8, 5, 48679.70355559341)
        tdSql.checkData(8, 6, 831.1366058581541)
        tdSql.checkData(9, 0, 10)
        tdSql.checkData(9, 1, 3.3219280948873626)
        tdSql.checkData(9, 2, 100.0)
        tdSql.checkData(9, 3, 102.0)
        tdSql.checkData(9, 4, 1103.3219280948874)
        tdSql.checkData(9, 5, 31722.776601683792)
        tdSql.checkData(9, 6, 637.940236622524)
        tdSql.checkData(10, 0, 9)
        tdSql.checkData(10, 1, 3.1699250014423126)
        tdSql.checkData(10, 2, 81.0)
        tdSql.checkData(10, 3, 83.0)
        tdSql.checkData(10, 4, 813.1699250014423)
        tdSql.checkData(10, 5, 19764.0)
        tdSql.checkData(10, 6, 476.5181244205816)
        tdSql.checkData(11, 0, 9)
        tdSql.checkData(11, 1, 3.1699250014423126)
        tdSql.checkData(11, 2, 81.0)
        tdSql.checkData(11, 3, 83.0)
        tdSql.checkData(11, 4, 813.1699250014423)
        tdSql.checkData(11, 5, 19764.0)
        tdSql.checkData(11, 6, 476.5181244205816)
        tdSql.checkData(12, 0, 8)
        tdSql.checkData(12, 1, 3.0)
        tdSql.checkData(12, 2, 64.0)
        tdSql.checkData(12, 3, 66.0)
        tdSql.checkData(12, 4, 579.0)
        tdSql.checkData(12, 5, 11649.237502960395)
        tdSql.checkData(12, 6, 344.2940251578608)
        tdSql.checkData(13, 0, 8)
        tdSql.checkData(13, 1, 3.0)
        tdSql.checkData(13, 2, 64.0)
        tdSql.checkData(13, 3, 66.0)
        tdSql.checkData(13, 4, 579.0)
        tdSql.checkData(13, 5, 11649.237502960395)
        tdSql.checkData(13, 6, 344.2940251578608)
        tdSql.checkData(14, 0, 7)
        tdSql.checkData(14, 1, 2.807354922057604)
        tdSql.checkData(14, 2, 49.0)
        tdSql.checkData(14, 3, 51.0)
        tdSql.checkData(14, 4, 394.8073549220576)
        tdSql.checkData(14, 5, 6401.448897866082)
        tdSql.checkData(14, 6, 238.6315756794513)
        tdSql.checkData(15, 0, 7)
        tdSql.checkData(15, 1, 2.807354922057604)
        tdSql.checkData(15, 2, 49.0)
        tdSql.checkData(15, 3, 51.0)
        tdSql.checkData(15, 4, 394.8073549220576)
        tdSql.checkData(15, 5, 6401.448897866082)
        tdSql.checkData(15, 6, 238.6315756794513)
        tdSql.checkData(16, 0, 6)
        tdSql.checkData(16, 1, 2.584962500721156)
        tdSql.checkData(16, 2, 36.0)
        tdSql.checkData(16, 3, 38.0)
        tdSql.checkData(16, 4, 254.58496250072116)
        tdSql.checkData(16, 5, 3210.538706646999)
        tdSql.checkData(16, 6, 156.8241014057428)
        tdSql.checkData(17, 0, 6)
        tdSql.checkData(17, 1, 2.584962500721156)
        tdSql.checkData(17, 2, 36.0)
        tdSql.checkData(17, 3, 38.0)
        tdSql.checkData(17, 4, 254.58496250072116)
        tdSql.checkData(17, 5, 3210.538706646999)
        tdSql.checkData(17, 6, 156.8241014057428)
        tdSql.checkData(18, 0, 5)
        tdSql.checkData(18, 1, 2.321928094887362)
        tdSql.checkData(18, 2, 25.0)
        tdSql.checkData(18, 3, 27.0)
        tdSql.checkData(18, 4, 152.32192809488737)
        tdSql.checkData(18, 5, 1422.5424859373686)
        tdSql.checkData(18, 6, 96.08035010204296)
        tdSql.checkData(19, 0, 5)
        tdSql.checkData(19, 1, 2.321928094887362)
        tdSql.checkData(19, 2, 25.0)
        tdSql.checkData(19, 3, 27.0)
        tdSql.checkData(19, 4, 152.32192809488737)
        tdSql.checkData(19, 5, 1422.5424859373686)
        tdSql.checkData(19, 6, 96.08035010204296)
        tdSql.checkData(20, 0, 4)
        tdSql.checkData(20, 1, 2.0)
        tdSql.checkData(20, 2, 16.0)
        tdSql.checkData(20, 3, 18.0)
        tdSql.checkData(20, 4, 82.0)
        tdSql.checkData(20, 5, 528.0)
        tdSql.checkData(20, 6, 53.50293012833273)
        tdSql.checkData(21, 0, 4)
        tdSql.checkData(21, 1, 2.0)
        tdSql.checkData(21, 2, 16.0)
        tdSql.checkData(21, 3, 18.0)
        tdSql.checkData(21, 4, 82.0)
        tdSql.checkData(21, 5, 528.0)
        tdSql.checkData(21, 6, 53.50293012833273)
        tdSql.checkData(22, 0, 3)
        tdSql.checkData(22, 1, 1.5849625007211563)
        tdSql.checkData(22, 2, 9.0)
        tdSql.checkData(22, 3, 11.0)
        tdSql.checkData(22, 4, 37.58496250072116)
        tdSql.checkData(22, 5, 149.29611541307906)
        tdSql.checkData(22, 6, 26.05146591860796)
        tdSql.checkData(23, 0, 3)
        tdSql.checkData(23, 1, 1.5849625007211563)
        tdSql.checkData(23, 2, 9.0)
        tdSql.checkData(23, 3, 11.0)
        tdSql.checkData(23, 4, 37.58496250072116)
        tdSql.checkData(23, 5, 149.29611541307906)
        tdSql.checkData(23, 6, 26.05146591860796)
        tdSql.checkData(24, 0, 2)
        tdSql.checkData(24, 1, 1.0)
        tdSql.checkData(24, 2, 4.0)
        tdSql.checkData(24, 3, 6.0)
        tdSql.checkData(24, 4, 13.0)
        tdSql.checkData(24, 5, 26.627416997969522)
        tdSql.checkData(24, 6, 10.464404506368993)
        tdSql.checkData(25, 0, 2)
        tdSql.checkData(25, 1, 1.0)
        tdSql.checkData(25, 2, 4.0)
        tdSql.checkData(25, 3, 6.0)
        tdSql.checkData(25, 4, 13.0)
        tdSql.checkData(25, 5, 26.627416997969522)
        tdSql.checkData(25, 6, 10.464404506368993)
        tdSql.checkData(26, 0, 1)
        tdSql.checkData(26, 1, 0.0)
        tdSql.checkData(26, 2, 1.0)
        tdSql.checkData(26, 3, 3.0)
        tdSql.checkData(26, 4, 2.0)
        tdSql.checkData(26, 5, 2.0)
        tdSql.checkData(26, 6, 3.0)
        tdSql.checkData(27, 0, 1)
        tdSql.checkData(27, 1, 0.0)
        tdSql.checkData(27, 2, 1.0)
        tdSql.checkData(27, 3, 3.0)
        tdSql.checkData(27, 4, 2.0)
        tdSql.checkData(27, 5, 2.0)
        tdSql.checkData(27, 6, 3.0)
        tdSql.checkData(28, 0, 0)
        tdSql.checkData(28, 1, -2.0)
        tdSql.checkData(28, 2, 0.0)
        tdSql.checkData(28, 3, 2.0625)
        tdSql.checkData(28, 4, -inf)
        tdSql.checkData(28, 5, 0.0)
        tdSql.checkData(28, 6, -inf)
        tdSql.checkData(29, 0, 0)
        tdSql.checkData(29, 1, -2.0)
        tdSql.checkData(29, 2, 0.0)
        tdSql.checkData(29, 3, 2.0625)
        tdSql.checkData(29, 4, -inf)
        tdSql.checkData(29, 5, 0.0)
        tdSql.checkData(29, 6, -inf)

        tdSql.query(
            "select c1, log(c2, 2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3, 2)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1,2)+log(c3,4)+pow(c6,2.8)+2 as v6 from ct1 order by ts limit 2;;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -2.0)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(1, 1, 0.0)
        tdSql.checkData(1, 2, 1.0)
        tdSql.checkData(1, 3, 3.0)
        tdSql.checkData(1, 4, 2.0)
        tdSql.checkData(1, 5, 2.0)
        tdSql.checkData(1, 6, 3.0)

        tdSql.query(
            "select sqrt(abs(log(c1,2)-pow(c1,2)))+2 from ct1 order by ts limit 2;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, inf)
        tdSql.checkData(1, 0, 3.0)

        tdSql.query(
            "select c1, log(c2, 2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3, 2)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1,2)+log(c3,4)+pow(c6,2.8)+2 as v6 from (select * from st0 order by ts desc);"
        )
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, 19)
        tdSql.checkData(0, 1, 4.247927513443585)
        tdSql.checkData(0, 2, 361.0)
        tdSql.checkData(0, 3, 363.0)
        tdSql.checkData(0, 4, 7224.247927513444)
        tdSql.checkData(0, 5, 568417.0692211641)
        tdSql.checkData(0, 6, 3814.7338355198453)
        tdSql.checkData(1, 0, 18)
        tdSql.checkData(1, 1, 4.169925001442312)
        tdSql.checkData(1, 2, 324.0)
        tdSql.checkData(1, 3, 326.0)
        tdSql.checkData(1, 4, 6160.169925001443)
        tdSql.checkData(1, 5, 445699.4487710341)
        tdSql.checkData(1, 6, 3279.8760916232795)
        tdSql.checkData(2, 0, 17)
        tdSql.checkData(2, 1, 4.08746284125034)
        tdSql.checkData(2, 2, 289.0)
        tdSql.checkData(2, 3, 291.0)
        tdSql.checkData(2, 4, 5206.08746284125)
        tdSql.checkData(2, 5, 344654.9049572126)
        tdSql.checkData(2, 6, 2795.901448766347)
        tdSql.checkData(3, 0, 16)
        tdSql.checkData(3, 1, 4.0)
        tdSql.checkData(3, 2, 256.0)
        tdSql.checkData(3, 3, 258.0)
        tdSql.checkData(3, 4, 4356.0)
        tdSql.checkData(3, 5, 262400.0)
        tdSql.checkData(3, 6, 2360.5342310339265)
        tdSql.checkData(4, 0, 15)
        tdSql.checkData(4, 1, 3.9068905956085187)
        tdSql.checkData(4, 2, 225.0)
        tdSql.checkData(4, 3, 227.0)
        tdSql.checkData(4, 4, 3603.9068905956087)
        tdSql.checkData(4, 5, 196294.78190175048)
        tdSql.checkData(4, 6, 1971.471648033734)
        tdSql.checkData(5, 0, 14)
        tdSql.checkData(5, 1, 3.8073549220576037)
        tdSql.checkData(5, 2, 196.0)
        tdSql.checkData(5, 3, 198.0)
        tdSql.checkData(5, 4, 2943.8073549220576)
        tdSql.checkData(5, 5, 143935.51017030774)
        tdSql.checkData(5, 6, 1626.3817114890194)
        tdSql.checkData(6, 0, 13)
        tdSql.checkData(6, 1, 3.700439718141092)
        tdSql.checkData(6, 2, 169.0)
        tdSql.checkData(6, 3, 171.0)
        tdSql.checkData(6, 4, 2369.7004397181413)
        tdSql.checkData(6, 5, 103147.149978527)
        tdSql.checkData(6, 6, 1322.9008332018816)
        tdSql.checkData(7, 0, 12)
        tdSql.checkData(7, 1, 3.5849625007211565)
        tdSql.checkData(7, 2, 144.0)
        tdSql.checkData(7, 3, 146.0)
        tdSql.checkData(7, 4, 1875.584962500721)
        tdSql.checkData(7, 5, 71975.61109149648)
        tdSql.checkData(7, 6, 1058.631026542541)
        tdSql.checkData(8, 0, 11)
        tdSql.checkData(8, 1, 3.4594316186372978)
        tdSql.checkData(8, 2, 121.0)
        tdSql.checkData(8, 3, 123.0)
        tdSql.checkData(8, 4, 1455.4594316186374)
        tdSql.checkData(8, 5, 48679.70355559341)
        tdSql.checkData(8, 6, 831.1366058581541)
        tdSql.checkData(9, 0, 10)
        tdSql.checkData(9, 1, 3.3219280948873626)
        tdSql.checkData(9, 2, 100.0)
        tdSql.checkData(9, 3, 102.0)
        tdSql.checkData(9, 4, 1103.3219280948874)
        tdSql.checkData(9, 5, 31722.776601683792)
        tdSql.checkData(9, 6, 637.940236622524)
        tdSql.checkData(10, 0, 9)
        tdSql.checkData(10, 1, 3.1699250014423126)
        tdSql.checkData(10, 2, 81.0)
        tdSql.checkData(10, 3, 83.0)
        tdSql.checkData(10, 4, 813.1699250014423)
        tdSql.checkData(10, 5, 19764.0)
        tdSql.checkData(10, 6, 476.5181244205816)
        tdSql.checkData(11, 0, 9)
        tdSql.checkData(11, 1, 3.1699250014423126)
        tdSql.checkData(11, 2, 81.0)
        tdSql.checkData(11, 3, 83.0)
        tdSql.checkData(11, 4, 813.1699250014423)
        tdSql.checkData(11, 5, 19764.0)
        tdSql.checkData(11, 6, 476.5181244205816)
        tdSql.checkData(12, 0, 8)
        tdSql.checkData(12, 1, 3.0)
        tdSql.checkData(12, 2, 64.0)
        tdSql.checkData(12, 3, 66.0)
        tdSql.checkData(12, 4, 579.0)
        tdSql.checkData(12, 5, 11649.237502960395)
        tdSql.checkData(12, 6, 344.2940251578608)
        tdSql.checkData(13, 0, 8)
        tdSql.checkData(13, 1, 3.0)
        tdSql.checkData(13, 2, 64.0)
        tdSql.checkData(13, 3, 66.0)
        tdSql.checkData(13, 4, 579.0)
        tdSql.checkData(13, 5, 11649.237502960395)
        tdSql.checkData(13, 6, 344.2940251578608)
        tdSql.checkData(14, 0, 7)
        tdSql.checkData(14, 1, 2.807354922057604)
        tdSql.checkData(14, 2, 49.0)
        tdSql.checkData(14, 3, 51.0)
        tdSql.checkData(14, 4, 394.8073549220576)
        tdSql.checkData(14, 5, 6401.448897866082)
        tdSql.checkData(14, 6, 238.6315756794513)
        tdSql.checkData(15, 0, 7)
        tdSql.checkData(15, 1, 2.807354922057604)
        tdSql.checkData(15, 2, 49.0)
        tdSql.checkData(15, 3, 51.0)
        tdSql.checkData(15, 4, 394.8073549220576)
        tdSql.checkData(15, 5, 6401.448897866082)
        tdSql.checkData(15, 6, 238.6315756794513)
        tdSql.checkData(16, 0, 6)
        tdSql.checkData(16, 1, 2.584962500721156)
        tdSql.checkData(16, 2, 36.0)
        tdSql.checkData(16, 3, 38.0)
        tdSql.checkData(16, 4, 254.58496250072116)
        tdSql.checkData(16, 5, 3210.538706646999)
        tdSql.checkData(16, 6, 156.8241014057428)
        tdSql.checkData(17, 0, 6)
        tdSql.checkData(17, 1, 2.584962500721156)
        tdSql.checkData(17, 2, 36.0)
        tdSql.checkData(17, 3, 38.0)
        tdSql.checkData(17, 4, 254.58496250072116)
        tdSql.checkData(17, 5, 3210.538706646999)
        tdSql.checkData(17, 6, 156.8241014057428)
        tdSql.checkData(18, 0, 5)
        tdSql.checkData(18, 1, 2.321928094887362)
        tdSql.checkData(18, 2, 25.0)
        tdSql.checkData(18, 3, 27.0)
        tdSql.checkData(18, 4, 152.32192809488737)
        tdSql.checkData(18, 5, 1422.5424859373686)
        tdSql.checkData(18, 6, 96.08035010204296)
        tdSql.checkData(19, 0, 5)
        tdSql.checkData(19, 1, 2.321928094887362)
        tdSql.checkData(19, 2, 25.0)
        tdSql.checkData(19, 3, 27.0)
        tdSql.checkData(19, 4, 152.32192809488737)
        tdSql.checkData(19, 5, 1422.5424859373686)
        tdSql.checkData(19, 6, 96.08035010204296)
        tdSql.checkData(20, 0, 4)
        tdSql.checkData(20, 1, 2.0)
        tdSql.checkData(20, 2, 16.0)
        tdSql.checkData(20, 3, 18.0)
        tdSql.checkData(20, 4, 82.0)
        tdSql.checkData(20, 5, 528.0)
        tdSql.checkData(20, 6, 53.50293012833273)
        tdSql.checkData(21, 0, 4)
        tdSql.checkData(21, 1, 2.0)
        tdSql.checkData(21, 2, 16.0)
        tdSql.checkData(21, 3, 18.0)
        tdSql.checkData(21, 4, 82.0)
        tdSql.checkData(21, 5, 528.0)
        tdSql.checkData(21, 6, 53.50293012833273)
        tdSql.checkData(22, 0, 3)
        tdSql.checkData(22, 1, 1.5849625007211563)
        tdSql.checkData(22, 2, 9.0)
        tdSql.checkData(22, 3, 11.0)
        tdSql.checkData(22, 4, 37.58496250072116)
        tdSql.checkData(22, 5, 149.29611541307906)
        tdSql.checkData(22, 6, 26.05146591860796)
        tdSql.checkData(23, 0, 3)
        tdSql.checkData(23, 1, 1.5849625007211563)
        tdSql.checkData(23, 2, 9.0)
        tdSql.checkData(23, 3, 11.0)
        tdSql.checkData(23, 4, 37.58496250072116)
        tdSql.checkData(23, 5, 149.29611541307906)
        tdSql.checkData(23, 6, 26.05146591860796)
        tdSql.checkData(24, 0, 2)
        tdSql.checkData(24, 1, 1.0)
        tdSql.checkData(24, 2, 4.0)
        tdSql.checkData(24, 3, 6.0)
        tdSql.checkData(24, 4, 13.0)
        tdSql.checkData(24, 5, 26.627416997969522)
        tdSql.checkData(24, 6, 10.464404506368993)
        tdSql.checkData(25, 0, 2)
        tdSql.checkData(25, 1, 1.0)
        tdSql.checkData(25, 2, 4.0)
        tdSql.checkData(25, 3, 6.0)
        tdSql.checkData(25, 4, 13.0)
        tdSql.checkData(25, 5, 26.627416997969522)
        tdSql.checkData(25, 6, 10.464404506368993)
        tdSql.checkData(26, 0, 1)
        tdSql.checkData(26, 1, 0.0)
        tdSql.checkData(26, 2, 1.0)
        tdSql.checkData(26, 3, 3.0)
        tdSql.checkData(26, 4, 2.0)
        tdSql.checkData(26, 5, 2.0)
        tdSql.checkData(26, 6, 3.0)
        tdSql.checkData(27, 0, 1)
        tdSql.checkData(27, 1, 0.0)
        tdSql.checkData(27, 2, 1.0)
        tdSql.checkData(27, 3, 3.0)
        tdSql.checkData(27, 4, 2.0)
        tdSql.checkData(27, 5, 2.0)
        tdSql.checkData(27, 6, 3.0)
        tdSql.checkData(28, 0, 0)
        tdSql.checkData(28, 1, -2.0)
        tdSql.checkData(28, 2, 0.0)
        tdSql.checkData(28, 3, 2.0625)
        tdSql.checkData(28, 4, -inf)
        tdSql.checkData(28, 5, 0.0)
        tdSql.checkData(28, 6, -inf)
        tdSql.checkData(29, 0, 0)
        tdSql.checkData(29, 1, -2.0)
        tdSql.checkData(29, 2, 0.0)
        tdSql.checkData(29, 3, 2.0625)
        tdSql.checkData(29, 4, -inf)
        tdSql.checkData(29, 5, 0.0)
        tdSql.checkData(29, 6, -inf)

        tdSql.query(
            "select c1, log(c2, 2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3, 2)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1,2)+log(c3,4)+pow(c6,2.8)+2 as v6 from (select * from ct1 order by ts limit 2);;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -2.0)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(1, 1, 0.0)
        tdSql.checkData(1, 2, 1.0)
        tdSql.checkData(1, 3, 3.0)
        tdSql.checkData(1, 4, 2.0)
        tdSql.checkData(1, 5, 2.0)
        tdSql.checkData(1, 6, 3.0)

        tdSql.query(
            "select c1, log(c2, 2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3, 2)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1,2)+log(c3,4)+pow(c6,2.8)+2 as v6 from (select * from st0 ) order by ts desc;"
        )
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, 19)
        tdSql.checkData(0, 1, 4.247927513443585)
        tdSql.checkData(0, 2, 361.0)
        tdSql.checkData(0, 3, 363.0)
        tdSql.checkData(0, 4, 7224.247927513444)
        tdSql.checkData(0, 5, 568417.0692211641)
        tdSql.checkData(0, 6, 3814.7338355198453)
        tdSql.checkData(1, 0, 18)
        tdSql.checkData(1, 1, 4.169925001442312)
        tdSql.checkData(1, 2, 324.0)
        tdSql.checkData(1, 3, 326.0)
        tdSql.checkData(1, 4, 6160.169925001443)
        tdSql.checkData(1, 5, 445699.4487710341)
        tdSql.checkData(1, 6, 3279.8760916232795)
        tdSql.checkData(2, 0, 17)
        tdSql.checkData(2, 1, 4.08746284125034)
        tdSql.checkData(2, 2, 289.0)
        tdSql.checkData(2, 3, 291.0)
        tdSql.checkData(2, 4, 5206.08746284125)
        tdSql.checkData(2, 5, 344654.9049572126)
        tdSql.checkData(2, 6, 2795.901448766347)
        tdSql.checkData(3, 0, 16)
        tdSql.checkData(3, 1, 4.0)
        tdSql.checkData(3, 2, 256.0)
        tdSql.checkData(3, 3, 258.0)
        tdSql.checkData(3, 4, 4356.0)
        tdSql.checkData(3, 5, 262400.0)
        tdSql.checkData(3, 6, 2360.5342310339265)
        tdSql.checkData(4, 0, 15)
        tdSql.checkData(4, 1, 3.9068905956085187)
        tdSql.checkData(4, 2, 225.0)
        tdSql.checkData(4, 3, 227.0)
        tdSql.checkData(4, 4, 3603.9068905956087)
        tdSql.checkData(4, 5, 196294.78190175048)
        tdSql.checkData(4, 6, 1971.471648033734)
        tdSql.checkData(5, 0, 14)
        tdSql.checkData(5, 1, 3.8073549220576037)
        tdSql.checkData(5, 2, 196.0)
        tdSql.checkData(5, 3, 198.0)
        tdSql.checkData(5, 4, 2943.8073549220576)
        tdSql.checkData(5, 5, 143935.51017030774)
        tdSql.checkData(5, 6, 1626.3817114890194)
        tdSql.checkData(6, 0, 13)
        tdSql.checkData(6, 1, 3.700439718141092)
        tdSql.checkData(6, 2, 169.0)
        tdSql.checkData(6, 3, 171.0)
        tdSql.checkData(6, 4, 2369.7004397181413)
        tdSql.checkData(6, 5, 103147.149978527)
        tdSql.checkData(6, 6, 1322.9008332018816)
        tdSql.checkData(7, 0, 12)
        tdSql.checkData(7, 1, 3.5849625007211565)
        tdSql.checkData(7, 2, 144.0)
        tdSql.checkData(7, 3, 146.0)
        tdSql.checkData(7, 4, 1875.584962500721)
        tdSql.checkData(7, 5, 71975.61109149648)
        tdSql.checkData(7, 6, 1058.631026542541)
        tdSql.checkData(8, 0, 11)
        tdSql.checkData(8, 1, 3.4594316186372978)
        tdSql.checkData(8, 2, 121.0)
        tdSql.checkData(8, 3, 123.0)
        tdSql.checkData(8, 4, 1455.4594316186374)
        tdSql.checkData(8, 5, 48679.70355559341)
        tdSql.checkData(8, 6, 831.1366058581541)
        tdSql.checkData(9, 0, 10)
        tdSql.checkData(9, 1, 3.3219280948873626)
        tdSql.checkData(9, 2, 100.0)
        tdSql.checkData(9, 3, 102.0)
        tdSql.checkData(9, 4, 1103.3219280948874)
        tdSql.checkData(9, 5, 31722.776601683792)
        tdSql.checkData(9, 6, 637.940236622524)
        tdSql.checkData(10, 0, 9)
        tdSql.checkData(10, 1, 3.1699250014423126)
        tdSql.checkData(10, 2, 81.0)
        tdSql.checkData(10, 3, 83.0)
        tdSql.checkData(10, 4, 813.1699250014423)
        tdSql.checkData(10, 5, 19764.0)
        tdSql.checkData(10, 6, 476.5181244205816)
        tdSql.checkData(11, 0, 9)
        tdSql.checkData(11, 1, 3.1699250014423126)
        tdSql.checkData(11, 2, 81.0)
        tdSql.checkData(11, 3, 83.0)
        tdSql.checkData(11, 4, 813.1699250014423)
        tdSql.checkData(11, 5, 19764.0)
        tdSql.checkData(11, 6, 476.5181244205816)
        tdSql.checkData(12, 0, 8)
        tdSql.checkData(12, 1, 3.0)
        tdSql.checkData(12, 2, 64.0)
        tdSql.checkData(12, 3, 66.0)
        tdSql.checkData(12, 4, 579.0)
        tdSql.checkData(12, 5, 11649.237502960395)
        tdSql.checkData(12, 6, 344.2940251578608)
        tdSql.checkData(13, 0, 8)
        tdSql.checkData(13, 1, 3.0)
        tdSql.checkData(13, 2, 64.0)
        tdSql.checkData(13, 3, 66.0)
        tdSql.checkData(13, 4, 579.0)
        tdSql.checkData(13, 5, 11649.237502960395)
        tdSql.checkData(13, 6, 344.2940251578608)
        tdSql.checkData(14, 0, 7)
        tdSql.checkData(14, 1, 2.807354922057604)
        tdSql.checkData(14, 2, 49.0)
        tdSql.checkData(14, 3, 51.0)
        tdSql.checkData(14, 4, 394.8073549220576)
        tdSql.checkData(14, 5, 6401.448897866082)
        tdSql.checkData(14, 6, 238.6315756794513)
        tdSql.checkData(15, 0, 7)
        tdSql.checkData(15, 1, 2.807354922057604)
        tdSql.checkData(15, 2, 49.0)
        tdSql.checkData(15, 3, 51.0)
        tdSql.checkData(15, 4, 394.8073549220576)
        tdSql.checkData(15, 5, 6401.448897866082)
        tdSql.checkData(15, 6, 238.6315756794513)
        tdSql.checkData(16, 0, 6)
        tdSql.checkData(16, 1, 2.584962500721156)
        tdSql.checkData(16, 2, 36.0)
        tdSql.checkData(16, 3, 38.0)
        tdSql.checkData(16, 4, 254.58496250072116)
        tdSql.checkData(16, 5, 3210.538706646999)
        tdSql.checkData(16, 6, 156.8241014057428)
        tdSql.checkData(17, 0, 6)
        tdSql.checkData(17, 1, 2.584962500721156)
        tdSql.checkData(17, 2, 36.0)
        tdSql.checkData(17, 3, 38.0)
        tdSql.checkData(17, 4, 254.58496250072116)
        tdSql.checkData(17, 5, 3210.538706646999)
        tdSql.checkData(17, 6, 156.8241014057428)
        tdSql.checkData(18, 0, 5)
        tdSql.checkData(18, 1, 2.321928094887362)
        tdSql.checkData(18, 2, 25.0)
        tdSql.checkData(18, 3, 27.0)
        tdSql.checkData(18, 4, 152.32192809488737)
        tdSql.checkData(18, 5, 1422.5424859373686)
        tdSql.checkData(18, 6, 96.08035010204296)
        tdSql.checkData(19, 0, 5)
        tdSql.checkData(19, 1, 2.321928094887362)
        tdSql.checkData(19, 2, 25.0)
        tdSql.checkData(19, 3, 27.0)
        tdSql.checkData(19, 4, 152.32192809488737)
        tdSql.checkData(19, 5, 1422.5424859373686)
        tdSql.checkData(19, 6, 96.08035010204296)
        tdSql.checkData(20, 0, 4)
        tdSql.checkData(20, 1, 2.0)
        tdSql.checkData(20, 2, 16.0)
        tdSql.checkData(20, 3, 18.0)
        tdSql.checkData(20, 4, 82.0)
        tdSql.checkData(20, 5, 528.0)
        tdSql.checkData(20, 6, 53.50293012833273)
        tdSql.checkData(21, 0, 4)
        tdSql.checkData(21, 1, 2.0)
        tdSql.checkData(21, 2, 16.0)
        tdSql.checkData(21, 3, 18.0)
        tdSql.checkData(21, 4, 82.0)
        tdSql.checkData(21, 5, 528.0)
        tdSql.checkData(21, 6, 53.50293012833273)
        tdSql.checkData(22, 0, 3)
        tdSql.checkData(22, 1, 1.5849625007211563)
        tdSql.checkData(22, 2, 9.0)
        tdSql.checkData(22, 3, 11.0)
        tdSql.checkData(22, 4, 37.58496250072116)
        tdSql.checkData(22, 5, 149.29611541307906)
        tdSql.checkData(22, 6, 26.05146591860796)
        tdSql.checkData(23, 0, 3)
        tdSql.checkData(23, 1, 1.5849625007211563)
        tdSql.checkData(23, 2, 9.0)
        tdSql.checkData(23, 3, 11.0)
        tdSql.checkData(23, 4, 37.58496250072116)
        tdSql.checkData(23, 5, 149.29611541307906)
        tdSql.checkData(23, 6, 26.05146591860796)
        tdSql.checkData(24, 0, 2)
        tdSql.checkData(24, 1, 1.0)
        tdSql.checkData(24, 2, 4.0)
        tdSql.checkData(24, 3, 6.0)
        tdSql.checkData(24, 4, 13.0)
        tdSql.checkData(24, 5, 26.627416997969522)
        tdSql.checkData(24, 6, 10.464404506368993)
        tdSql.checkData(25, 0, 2)
        tdSql.checkData(25, 1, 1.0)
        tdSql.checkData(25, 2, 4.0)
        tdSql.checkData(25, 3, 6.0)
        tdSql.checkData(25, 4, 13.0)
        tdSql.checkData(25, 5, 26.627416997969522)
        tdSql.checkData(25, 6, 10.464404506368993)
        tdSql.checkData(26, 0, 1)
        tdSql.checkData(26, 1, 0.0)
        tdSql.checkData(26, 2, 1.0)
        tdSql.checkData(26, 3, 3.0)
        tdSql.checkData(26, 4, 2.0)
        tdSql.checkData(26, 5, 2.0)
        tdSql.checkData(26, 6, 3.0)
        tdSql.checkData(27, 0, 1)
        tdSql.checkData(27, 1, 0.0)
        tdSql.checkData(27, 2, 1.0)
        tdSql.checkData(27, 3, 3.0)
        tdSql.checkData(27, 4, 2.0)
        tdSql.checkData(27, 5, 2.0)
        tdSql.checkData(27, 6, 3.0)
        tdSql.checkData(28, 0, 0)
        tdSql.checkData(28, 1, -2.0)
        tdSql.checkData(28, 2, 0.0)
        tdSql.checkData(28, 3, 2.0625)
        tdSql.checkData(28, 4, -inf)
        tdSql.checkData(28, 5, 0.0)
        tdSql.checkData(28, 6, -inf)
        tdSql.checkData(29, 0, 0)
        tdSql.checkData(29, 1, -2.0)
        tdSql.checkData(29, 2, 0.0)
        tdSql.checkData(29, 3, 2.0625)
        tdSql.checkData(29, 4, -inf)
        tdSql.checkData(29, 5, 0.0)
        tdSql.checkData(29, 6, -inf)

        tdSql.query(
            "select c1, log(c2, 2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3, 2)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1,2)+log(c3,4)+pow(c6,2.8)+2 as v6 from (select * from st0 );"
        )
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -2.0)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(1, 1, 0.0)
        tdSql.checkData(1, 2, 1.0)
        tdSql.checkData(1, 3, 3.0)
        tdSql.checkData(1, 4, 2.0)
        tdSql.checkData(1, 5, 2.0)
        tdSql.checkData(1, 6, 3.0)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(2, 1, 1.0)
        tdSql.checkData(2, 2, 4.0)
        tdSql.checkData(2, 3, 6.0)
        tdSql.checkData(2, 4, 13.0)
        tdSql.checkData(2, 5, 26.627416997969522)
        tdSql.checkData(2, 6, 10.464404506368993)
        tdSql.checkData(3, 0, 3)
        tdSql.checkData(3, 1, 1.5849625007211563)
        tdSql.checkData(3, 2, 9.0)
        tdSql.checkData(3, 3, 11.0)
        tdSql.checkData(3, 4, 37.58496250072116)
        tdSql.checkData(3, 5, 149.29611541307906)
        tdSql.checkData(3, 6, 26.05146591860796)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(4, 1, 2.0)
        tdSql.checkData(4, 2, 16.0)
        tdSql.checkData(4, 3, 18.0)
        tdSql.checkData(4, 4, 82.0)
        tdSql.checkData(4, 5, 528.0)
        tdSql.checkData(4, 6, 53.50293012833273)
        tdSql.checkData(5, 0, 5)
        tdSql.checkData(5, 1, 2.321928094887362)
        tdSql.checkData(5, 2, 25.0)
        tdSql.checkData(5, 3, 27.0)
        tdSql.checkData(5, 4, 152.32192809488737)
        tdSql.checkData(5, 5, 1422.5424859373686)
        tdSql.checkData(5, 6, 96.08035010204296)
        tdSql.checkData(6, 0, 6)
        tdSql.checkData(6, 1, 2.584962500721156)
        tdSql.checkData(6, 2, 36.0)
        tdSql.checkData(6, 3, 38.0)
        tdSql.checkData(6, 4, 254.58496250072116)
        tdSql.checkData(6, 5, 3210.538706646999)
        tdSql.checkData(6, 6, 156.8241014057428)
        tdSql.checkData(7, 0, 7)
        tdSql.checkData(7, 1, 2.807354922057604)
        tdSql.checkData(7, 2, 49.0)
        tdSql.checkData(7, 3, 51.0)
        tdSql.checkData(7, 4, 394.8073549220576)
        tdSql.checkData(7, 5, 6401.448897866082)
        tdSql.checkData(7, 6, 238.6315756794513)
        tdSql.checkData(8, 0, 8)
        tdSql.checkData(8, 1, 3.0)
        tdSql.checkData(8, 2, 64.0)
        tdSql.checkData(8, 3, 66.0)
        tdSql.checkData(8, 4, 579.0)
        tdSql.checkData(8, 5, 11649.237502960395)
        tdSql.checkData(8, 6, 344.2940251578608)
        tdSql.checkData(9, 0, 9)
        tdSql.checkData(9, 1, 3.1699250014423126)
        tdSql.checkData(9, 2, 81.0)
        tdSql.checkData(9, 3, 83.0)
        tdSql.checkData(9, 4, 813.1699250014423)
        tdSql.checkData(9, 5, 19764.0)
        tdSql.checkData(9, 6, 476.5181244205816)
        tdSql.checkData(10, 0, 0)
        tdSql.checkData(10, 1, -2.0)
        tdSql.checkData(10, 2, 0.0)
        tdSql.checkData(10, 3, 2.0625)
        tdSql.checkData(10, 4, -inf)
        tdSql.checkData(10, 5, 0.0)
        tdSql.checkData(10, 6, -inf)
        tdSql.checkData(11, 0, 1)
        tdSql.checkData(11, 1, 0.0)
        tdSql.checkData(11, 2, 1.0)
        tdSql.checkData(11, 3, 3.0)
        tdSql.checkData(11, 4, 2.0)
        tdSql.checkData(11, 5, 2.0)
        tdSql.checkData(11, 6, 3.0)
        tdSql.checkData(12, 0, 2)
        tdSql.checkData(12, 1, 1.0)
        tdSql.checkData(12, 2, 4.0)
        tdSql.checkData(12, 3, 6.0)
        tdSql.checkData(12, 4, 13.0)
        tdSql.checkData(12, 5, 26.627416997969522)
        tdSql.checkData(12, 6, 10.464404506368993)
        tdSql.checkData(13, 0, 3)
        tdSql.checkData(13, 1, 1.5849625007211563)
        tdSql.checkData(13, 2, 9.0)
        tdSql.checkData(13, 3, 11.0)
        tdSql.checkData(13, 4, 37.58496250072116)
        tdSql.checkData(13, 5, 149.29611541307906)
        tdSql.checkData(13, 6, 26.05146591860796)
        tdSql.checkData(14, 0, 4)
        tdSql.checkData(14, 1, 2.0)
        tdSql.checkData(14, 2, 16.0)
        tdSql.checkData(14, 3, 18.0)
        tdSql.checkData(14, 4, 82.0)
        tdSql.checkData(14, 5, 528.0)
        tdSql.checkData(14, 6, 53.50293012833273)
        tdSql.checkData(15, 0, 5)
        tdSql.checkData(15, 1, 2.321928094887362)
        tdSql.checkData(15, 2, 25.0)
        tdSql.checkData(15, 3, 27.0)
        tdSql.checkData(15, 4, 152.32192809488737)
        tdSql.checkData(15, 5, 1422.5424859373686)
        tdSql.checkData(15, 6, 96.08035010204296)
        tdSql.checkData(16, 0, 6)
        tdSql.checkData(16, 1, 2.584962500721156)
        tdSql.checkData(16, 2, 36.0)
        tdSql.checkData(16, 3, 38.0)
        tdSql.checkData(16, 4, 254.58496250072116)
        tdSql.checkData(16, 5, 3210.538706646999)
        tdSql.checkData(16, 6, 156.8241014057428)
        tdSql.checkData(17, 0, 7)
        tdSql.checkData(17, 1, 2.807354922057604)
        tdSql.checkData(17, 2, 49.0)
        tdSql.checkData(17, 3, 51.0)
        tdSql.checkData(17, 4, 394.8073549220576)
        tdSql.checkData(17, 5, 6401.448897866082)
        tdSql.checkData(17, 6, 238.6315756794513)
        tdSql.checkData(18, 0, 8)
        tdSql.checkData(18, 1, 3.0)
        tdSql.checkData(18, 2, 64.0)
        tdSql.checkData(18, 3, 66.0)
        tdSql.checkData(18, 4, 579.0)
        tdSql.checkData(18, 5, 11649.237502960395)
        tdSql.checkData(18, 6, 344.2940251578608)
        tdSql.checkData(19, 0, 9)
        tdSql.checkData(19, 1, 3.1699250014423126)
        tdSql.checkData(19, 2, 81.0)
        tdSql.checkData(19, 3, 83.0)
        tdSql.checkData(19, 4, 813.1699250014423)
        tdSql.checkData(19, 5, 19764.0)
        tdSql.checkData(19, 6, 476.5181244205816)
        tdSql.checkData(20, 0, 10)
        tdSql.checkData(20, 1, 3.3219280948873626)
        tdSql.checkData(20, 2, 100.0)
        tdSql.checkData(20, 3, 102.0)
        tdSql.checkData(20, 4, 1103.3219280948874)
        tdSql.checkData(20, 5, 31722.776601683792)
        tdSql.checkData(20, 6, 637.940236622524)
        tdSql.checkData(21, 0, 11)
        tdSql.checkData(21, 1, 3.4594316186372978)
        tdSql.checkData(21, 2, 121.0)
        tdSql.checkData(21, 3, 123.0)
        tdSql.checkData(21, 4, 1455.4594316186374)
        tdSql.checkData(21, 5, 48679.70355559341)
        tdSql.checkData(21, 6, 831.1366058581541)
        tdSql.checkData(22, 0, 12)
        tdSql.checkData(22, 1, 3.5849625007211565)
        tdSql.checkData(22, 2, 144.0)
        tdSql.checkData(22, 3, 146.0)
        tdSql.checkData(22, 4, 1875.584962500721)
        tdSql.checkData(22, 5, 71975.61109149648)
        tdSql.checkData(22, 6, 1058.631026542541)
        tdSql.checkData(23, 0, 13)
        tdSql.checkData(23, 1, 3.700439718141092)
        tdSql.checkData(23, 2, 169.0)
        tdSql.checkData(23, 3, 171.0)
        tdSql.checkData(23, 4, 2369.7004397181413)
        tdSql.checkData(23, 5, 103147.149978527)
        tdSql.checkData(23, 6, 1322.9008332018816)
        tdSql.checkData(24, 0, 14)
        tdSql.checkData(24, 1, 3.8073549220576037)
        tdSql.checkData(24, 2, 196.0)
        tdSql.checkData(24, 3, 198.0)
        tdSql.checkData(24, 4, 2943.8073549220576)
        tdSql.checkData(24, 5, 143935.51017030774)
        tdSql.checkData(24, 6, 1626.3817114890194)
        tdSql.checkData(25, 0, 15)
        tdSql.checkData(25, 1, 3.9068905956085187)
        tdSql.checkData(25, 2, 225.0)
        tdSql.checkData(25, 3, 227.0)
        tdSql.checkData(25, 4, 3603.9068905956087)
        tdSql.checkData(25, 5, 196294.78190175048)
        tdSql.checkData(25, 6, 1971.471648033734)
        tdSql.checkData(26, 0, 16)
        tdSql.checkData(26, 1, 4.0)
        tdSql.checkData(26, 2, 256.0)
        tdSql.checkData(26, 3, 258.0)
        tdSql.checkData(26, 4, 4356.0)
        tdSql.checkData(26, 5, 262400.0)
        tdSql.checkData(26, 6, 2360.5342310339265)
        tdSql.checkData(27, 0, 17)
        tdSql.checkData(27, 1, 4.08746284125034)
        tdSql.checkData(27, 2, 289.0)
        tdSql.checkData(27, 3, 291.0)
        tdSql.checkData(27, 4, 5206.08746284125)
        tdSql.checkData(27, 5, 344654.9049572126)
        tdSql.checkData(27, 6, 2795.901448766347)
        tdSql.checkData(28, 0, 18)
        tdSql.checkData(28, 1, 4.169925001442312)
        tdSql.checkData(28, 2, 324.0)
        tdSql.checkData(28, 3, 326.0)
        tdSql.checkData(28, 4, 6160.169925001443)
        tdSql.checkData(28, 5, 445699.4487710341)
        tdSql.checkData(28, 6, 3279.8760916232795)
        tdSql.checkData(29, 0, 19)
        tdSql.checkData(29, 1, 4.247927513443585)
        tdSql.checkData(29, 2, 361.0)
        tdSql.checkData(29, 3, 363.0)
        tdSql.checkData(29, 4, 7224.247927513444)
        tdSql.checkData(29, 5, 568417.0692211641)
        tdSql.checkData(29, 6, 3814.7338355198453)

        tdSql.query(
            "select c1, log(c2, 2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3, 2)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1,2)+log(c3,4)+pow(c6,2.8)+2 as v6 from (select * from ct1 ) order by ts limit 2;;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -2.0)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(1, 1, 0.0)
        tdSql.checkData(1, 2, 1.0)
        tdSql.checkData(1, 3, 3.0)
        tdSql.checkData(1, 4, 2.0)
        tdSql.checkData(1, 5, 2.0)
        tdSql.checkData(1, 6, 3.0)

        tdSql.query(
            "select c1, log(c2, 2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3, 2)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1,2)+log(c3,4)+pow(c6,2.8)+2 as v6 from (select * from ct1 ) limit 2;;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -2.0)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(1, 1, 0.0)
        tdSql.checkData(1, 2, 1.0)
        tdSql.checkData(1, 3, 3.0)
        tdSql.checkData(1, 4, 2.0)
        tdSql.checkData(1, 5, 2.0)
        tdSql.checkData(1, 6, 3.0)

        tdSql.query(
            "select * from (select c1, log(c2, 2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3, 2)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1,2)+log(c3,4)+pow(c6,2.8)+2 as v6, ts from st0 order by ts desc);"
        )
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, 19)
        tdSql.checkData(0, 1, 4.247927513443585)
        tdSql.checkData(0, 2, 361.0)
        tdSql.checkData(0, 3, 363.0)
        tdSql.checkData(0, 4, 7224.247927513444)
        tdSql.checkData(0, 5, 568417.0692211641)
        tdSql.checkData(0, 6, 3814.7338355198453)
        tdSql.checkData(0, 7, datetime.datetime(2020, 10, 1, 0, 19))
        tdSql.checkData(1, 0, 18)
        tdSql.checkData(1, 1, 4.169925001442312)
        tdSql.checkData(1, 2, 324.0)
        tdSql.checkData(1, 3, 326.0)
        tdSql.checkData(1, 4, 6160.169925001443)
        tdSql.checkData(1, 5, 445699.4487710341)
        tdSql.checkData(1, 6, 3279.8760916232795)
        tdSql.checkData(1, 7, datetime.datetime(2020, 10, 1, 0, 18))
        tdSql.checkData(2, 0, 17)
        tdSql.checkData(2, 1, 4.08746284125034)
        tdSql.checkData(2, 2, 289.0)
        tdSql.checkData(2, 3, 291.0)
        tdSql.checkData(2, 4, 5206.08746284125)
        tdSql.checkData(2, 5, 344654.9049572126)
        tdSql.checkData(2, 6, 2795.901448766347)
        tdSql.checkData(2, 7, datetime.datetime(2020, 10, 1, 0, 17))
        tdSql.checkData(3, 0, 16)
        tdSql.checkData(3, 1, 4.0)
        tdSql.checkData(3, 2, 256.0)
        tdSql.checkData(3, 3, 258.0)
        tdSql.checkData(3, 4, 4356.0)
        tdSql.checkData(3, 5, 262400.0)
        tdSql.checkData(3, 6, 2360.5342310339265)
        tdSql.checkData(3, 7, datetime.datetime(2020, 10, 1, 0, 16))
        tdSql.checkData(4, 0, 15)
        tdSql.checkData(4, 1, 3.9068905956085187)
        tdSql.checkData(4, 2, 225.0)
        tdSql.checkData(4, 3, 227.0)
        tdSql.checkData(4, 4, 3603.9068905956087)
        tdSql.checkData(4, 5, 196294.78190175048)
        tdSql.checkData(4, 6, 1971.471648033734)
        tdSql.checkData(4, 7, datetime.datetime(2020, 10, 1, 0, 15))
        tdSql.checkData(5, 0, 14)
        tdSql.checkData(5, 1, 3.8073549220576037)
        tdSql.checkData(5, 2, 196.0)
        tdSql.checkData(5, 3, 198.0)
        tdSql.checkData(5, 4, 2943.8073549220576)
        tdSql.checkData(5, 5, 143935.51017030774)
        tdSql.checkData(5, 6, 1626.3817114890194)
        tdSql.checkData(5, 7, datetime.datetime(2020, 10, 1, 0, 14))
        tdSql.checkData(6, 0, 13)
        tdSql.checkData(6, 1, 3.700439718141092)
        tdSql.checkData(6, 2, 169.0)
        tdSql.checkData(6, 3, 171.0)
        tdSql.checkData(6, 4, 2369.7004397181413)
        tdSql.checkData(6, 5, 103147.149978527)
        tdSql.checkData(6, 6, 1322.9008332018816)
        tdSql.checkData(6, 7, datetime.datetime(2020, 10, 1, 0, 13))
        tdSql.checkData(7, 0, 12)
        tdSql.checkData(7, 1, 3.5849625007211565)
        tdSql.checkData(7, 2, 144.0)
        tdSql.checkData(7, 3, 146.0)
        tdSql.checkData(7, 4, 1875.584962500721)
        tdSql.checkData(7, 5, 71975.61109149648)
        tdSql.checkData(7, 6, 1058.631026542541)
        tdSql.checkData(7, 7, datetime.datetime(2020, 10, 1, 0, 12))
        tdSql.checkData(8, 0, 11)
        tdSql.checkData(8, 1, 3.4594316186372978)
        tdSql.checkData(8, 2, 121.0)
        tdSql.checkData(8, 3, 123.0)
        tdSql.checkData(8, 4, 1455.4594316186374)
        tdSql.checkData(8, 5, 48679.70355559341)
        tdSql.checkData(8, 6, 831.1366058581541)
        tdSql.checkData(8, 7, datetime.datetime(2020, 10, 1, 0, 11))
        tdSql.checkData(9, 0, 10)
        tdSql.checkData(9, 1, 3.3219280948873626)
        tdSql.checkData(9, 2, 100.0)
        tdSql.checkData(9, 3, 102.0)
        tdSql.checkData(9, 4, 1103.3219280948874)
        tdSql.checkData(9, 5, 31722.776601683792)
        tdSql.checkData(9, 6, 637.940236622524)
        tdSql.checkData(9, 7, datetime.datetime(2020, 10, 1, 0, 10))
        tdSql.checkData(10, 0, 9)
        tdSql.checkData(10, 1, 3.1699250014423126)
        tdSql.checkData(10, 2, 81.0)
        tdSql.checkData(10, 3, 83.0)
        tdSql.checkData(10, 4, 813.1699250014423)
        tdSql.checkData(10, 5, 19764.0)
        tdSql.checkData(10, 6, 476.5181244205816)
        tdSql.checkData(10, 7, datetime.datetime(2020, 10, 1, 0, 9))
        tdSql.checkData(11, 0, 9)
        tdSql.checkData(11, 1, 3.1699250014423126)
        tdSql.checkData(11, 2, 81.0)
        tdSql.checkData(11, 3, 83.0)
        tdSql.checkData(11, 4, 813.1699250014423)
        tdSql.checkData(11, 5, 19764.0)
        tdSql.checkData(11, 6, 476.5181244205816)
        tdSql.checkData(11, 7, datetime.datetime(2020, 10, 1, 0, 9))
        tdSql.checkData(12, 0, 8)
        tdSql.checkData(12, 1, 3.0)
        tdSql.checkData(12, 2, 64.0)
        tdSql.checkData(12, 3, 66.0)
        tdSql.checkData(12, 4, 579.0)
        tdSql.checkData(12, 5, 11649.237502960395)
        tdSql.checkData(12, 6, 344.2940251578608)
        tdSql.checkData(12, 7, datetime.datetime(2020, 10, 1, 0, 8))
        tdSql.checkData(13, 0, 8)
        tdSql.checkData(13, 1, 3.0)
        tdSql.checkData(13, 2, 64.0)
        tdSql.checkData(13, 3, 66.0)
        tdSql.checkData(13, 4, 579.0)
        tdSql.checkData(13, 5, 11649.237502960395)
        tdSql.checkData(13, 6, 344.2940251578608)
        tdSql.checkData(13, 7, datetime.datetime(2020, 10, 1, 0, 8))
        tdSql.checkData(14, 0, 7)
        tdSql.checkData(14, 1, 2.807354922057604)
        tdSql.checkData(14, 2, 49.0)
        tdSql.checkData(14, 3, 51.0)
        tdSql.checkData(14, 4, 394.8073549220576)
        tdSql.checkData(14, 5, 6401.448897866082)
        tdSql.checkData(14, 6, 238.6315756794513)
        tdSql.checkData(14, 7, datetime.datetime(2020, 10, 1, 0, 7))
        tdSql.checkData(15, 0, 7)
        tdSql.checkData(15, 1, 2.807354922057604)
        tdSql.checkData(15, 2, 49.0)
        tdSql.checkData(15, 3, 51.0)
        tdSql.checkData(15, 4, 394.8073549220576)
        tdSql.checkData(15, 5, 6401.448897866082)
        tdSql.checkData(15, 6, 238.6315756794513)
        tdSql.checkData(15, 7, datetime.datetime(2020, 10, 1, 0, 7))
        tdSql.checkData(16, 0, 6)
        tdSql.checkData(16, 1, 2.584962500721156)
        tdSql.checkData(16, 2, 36.0)
        tdSql.checkData(16, 3, 38.0)
        tdSql.checkData(16, 4, 254.58496250072116)
        tdSql.checkData(16, 5, 3210.538706646999)
        tdSql.checkData(16, 6, 156.8241014057428)
        tdSql.checkData(16, 7, datetime.datetime(2020, 10, 1, 0, 6))
        tdSql.checkData(17, 0, 6)
        tdSql.checkData(17, 1, 2.584962500721156)
        tdSql.checkData(17, 2, 36.0)
        tdSql.checkData(17, 3, 38.0)
        tdSql.checkData(17, 4, 254.58496250072116)
        tdSql.checkData(17, 5, 3210.538706646999)
        tdSql.checkData(17, 6, 156.8241014057428)
        tdSql.checkData(17, 7, datetime.datetime(2020, 10, 1, 0, 6))
        tdSql.checkData(18, 0, 5)
        tdSql.checkData(18, 1, 2.321928094887362)
        tdSql.checkData(18, 2, 25.0)
        tdSql.checkData(18, 3, 27.0)
        tdSql.checkData(18, 4, 152.32192809488737)
        tdSql.checkData(18, 5, 1422.5424859373686)
        tdSql.checkData(18, 6, 96.08035010204296)
        tdSql.checkData(18, 7, datetime.datetime(2020, 10, 1, 0, 5))
        tdSql.checkData(19, 0, 5)
        tdSql.checkData(19, 1, 2.321928094887362)
        tdSql.checkData(19, 2, 25.0)
        tdSql.checkData(19, 3, 27.0)
        tdSql.checkData(19, 4, 152.32192809488737)
        tdSql.checkData(19, 5, 1422.5424859373686)
        tdSql.checkData(19, 6, 96.08035010204296)
        tdSql.checkData(19, 7, datetime.datetime(2020, 10, 1, 0, 5))
        tdSql.checkData(20, 0, 4)
        tdSql.checkData(20, 1, 2.0)
        tdSql.checkData(20, 2, 16.0)
        tdSql.checkData(20, 3, 18.0)
        tdSql.checkData(20, 4, 82.0)
        tdSql.checkData(20, 5, 528.0)
        tdSql.checkData(20, 6, 53.50293012833273)
        tdSql.checkData(20, 7, datetime.datetime(2020, 10, 1, 0, 4))
        tdSql.checkData(21, 0, 4)
        tdSql.checkData(21, 1, 2.0)
        tdSql.checkData(21, 2, 16.0)
        tdSql.checkData(21, 3, 18.0)
        tdSql.checkData(21, 4, 82.0)
        tdSql.checkData(21, 5, 528.0)
        tdSql.checkData(21, 6, 53.50293012833273)
        tdSql.checkData(21, 7, datetime.datetime(2020, 10, 1, 0, 4))
        tdSql.checkData(22, 0, 3)
        tdSql.checkData(22, 1, 1.5849625007211563)
        tdSql.checkData(22, 2, 9.0)
        tdSql.checkData(22, 3, 11.0)
        tdSql.checkData(22, 4, 37.58496250072116)
        tdSql.checkData(22, 5, 149.29611541307906)
        tdSql.checkData(22, 6, 26.05146591860796)
        tdSql.checkData(22, 7, datetime.datetime(2020, 10, 1, 0, 3))
        tdSql.checkData(23, 0, 3)
        tdSql.checkData(23, 1, 1.5849625007211563)
        tdSql.checkData(23, 2, 9.0)
        tdSql.checkData(23, 3, 11.0)
        tdSql.checkData(23, 4, 37.58496250072116)
        tdSql.checkData(23, 5, 149.29611541307906)
        tdSql.checkData(23, 6, 26.05146591860796)
        tdSql.checkData(23, 7, datetime.datetime(2020, 10, 1, 0, 3))
        tdSql.checkData(24, 0, 2)
        tdSql.checkData(24, 1, 1.0)
        tdSql.checkData(24, 2, 4.0)
        tdSql.checkData(24, 3, 6.0)
        tdSql.checkData(24, 4, 13.0)
        tdSql.checkData(24, 5, 26.627416997969522)
        tdSql.checkData(24, 6, 10.464404506368993)
        tdSql.checkData(24, 7, datetime.datetime(2020, 10, 1, 0, 2))
        tdSql.checkData(25, 0, 2)
        tdSql.checkData(25, 1, 1.0)
        tdSql.checkData(25, 2, 4.0)
        tdSql.checkData(25, 3, 6.0)
        tdSql.checkData(25, 4, 13.0)
        tdSql.checkData(25, 5, 26.627416997969522)
        tdSql.checkData(25, 6, 10.464404506368993)
        tdSql.checkData(25, 7, datetime.datetime(2020, 10, 1, 0, 2))
        tdSql.checkData(26, 0, 1)
        tdSql.checkData(26, 1, 0.0)
        tdSql.checkData(26, 2, 1.0)
        tdSql.checkData(26, 3, 3.0)
        tdSql.checkData(26, 4, 2.0)
        tdSql.checkData(26, 5, 2.0)
        tdSql.checkData(26, 6, 3.0)
        tdSql.checkData(26, 7, datetime.datetime(2020, 10, 1, 0, 1))
        tdSql.checkData(27, 0, 1)
        tdSql.checkData(27, 1, 0.0)
        tdSql.checkData(27, 2, 1.0)
        tdSql.checkData(27, 3, 3.0)
        tdSql.checkData(27, 4, 2.0)
        tdSql.checkData(27, 5, 2.0)
        tdSql.checkData(27, 6, 3.0)
        tdSql.checkData(27, 7, datetime.datetime(2020, 10, 1, 0, 1))
        tdSql.checkData(28, 0, 0)
        tdSql.checkData(28, 1, -2.0)
        tdSql.checkData(28, 2, 0.0)
        tdSql.checkData(28, 3, 2.0625)
        tdSql.checkData(28, 4, -inf)
        tdSql.checkData(28, 5, 0.0)
        tdSql.checkData(28, 6, -inf)
        tdSql.checkData(28, 7, datetime.datetime(2020, 10, 1, 0, 0))
        tdSql.checkData(29, 0, 0)
        tdSql.checkData(29, 1, -2.0)
        tdSql.checkData(29, 2, 0.0)
        tdSql.checkData(29, 3, 2.0625)
        tdSql.checkData(29, 4, -inf)
        tdSql.checkData(29, 5, 0.0)
        tdSql.checkData(29, 6, -inf)
        tdSql.checkData(29, 7, datetime.datetime(2020, 10, 1, 0, 0))

        tdSql.query(
            "select * from (select c1, log(c2, 2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3, 2)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1,2)+log(c3,4)+pow(c6,2.8)+2 as v6, ts from ct1 order by ts limit 2);;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -2.0)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)
        tdSql.checkData(0, 7, datetime.datetime(2020, 10, 1, 0, 0))
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(1, 1, 0.0)
        tdSql.checkData(1, 2, 1.0)
        tdSql.checkData(1, 3, 3.0)
        tdSql.checkData(1, 4, 2.0)
        tdSql.checkData(1, 5, 2.0)
        tdSql.checkData(1, 6, 3.0)
        tdSql.checkData(1, 7, datetime.datetime(2020, 10, 1, 0, 1))

        tdSql.query(
            "select c1, log(c2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1)+log(c3,4)+pow(c6,2.8)+2 as v6 from ct1;"
        )
        tdSql.checkRows(20)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -1.3862943611198906)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(1, 1, 0.0)
        tdSql.checkData(1, 2, 1.0)
        tdSql.checkData(1, 3, 3.0)
        tdSql.checkData(1, 4, 2.0)
        tdSql.checkData(1, 5, 2.0)
        tdSql.checkData(1, 6, 3.0)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(2, 1, 0.6931471805599453)
        tdSql.checkData(2, 2, 4.0)
        tdSql.checkData(2, 3, 6.0)
        tdSql.checkData(2, 4, 12.693147180559945)
        tdSql.checkData(2, 5, 26.627416997969522)
        tdSql.checkData(2, 6, 10.157551686928937)
        tdSql.checkData(3, 0, 3)
        tdSql.checkData(3, 1, 1.0986122886681098)
        tdSql.checkData(3, 2, 9.0)
        tdSql.checkData(3, 3, 11.0)
        tdSql.checkData(3, 4, 37.09861228866811)
        tdSql.checkData(3, 5, 149.29611541307906)
        tdSql.checkData(3, 6, 25.565115706554913)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(4, 1, 1.3862943611198906)
        tdSql.checkData(4, 2, 16.0)
        tdSql.checkData(4, 3, 18.0)
        tdSql.checkData(4, 4, 81.3862943611199)
        tdSql.checkData(4, 5, 528.0)
        tdSql.checkData(4, 6, 52.889224489452616)
        tdSql.checkData(5, 0, 5)
        tdSql.checkData(5, 1, 1.6094379124341003)
        tdSql.checkData(5, 2, 25.0)
        tdSql.checkData(5, 3, 27.0)
        tdSql.checkData(5, 4, 151.6094379124341)
        tdSql.checkData(5, 5, 1422.5424859373686)
        tdSql.checkData(5, 6, 95.3678599195897)
        tdSql.checkData(6, 0, 6)
        tdSql.checkData(6, 1, 1.791759469228055)
        tdSql.checkData(6, 2, 36.0)
        tdSql.checkData(6, 3, 38.0)
        tdSql.checkData(6, 4, 253.79175946922805)
        tdSql.checkData(6, 5, 3210.538706646999)
        tdSql.checkData(6, 6, 156.0308983742497)
        tdSql.checkData(7, 0, 7)
        tdSql.checkData(7, 1, 1.9459101490553132)
        tdSql.checkData(7, 2, 49.0)
        tdSql.checkData(7, 3, 51.0)
        tdSql.checkData(7, 4, 393.9459101490553)
        tdSql.checkData(7, 5, 6401.448897866082)
        tdSql.checkData(7, 6, 237.770130906449)
        tdSql.checkData(8, 0, 8)
        tdSql.checkData(8, 1, 2.0794415416798357)
        tdSql.checkData(8, 2, 64.0)
        tdSql.checkData(8, 3, 66.0)
        tdSql.checkData(8, 4, 578.0794415416798)
        tdSql.checkData(8, 5, 11649.237502960395)
        tdSql.checkData(8, 6, 343.37346669954064)
        tdSql.checkData(9, 0, 9)
        tdSql.checkData(9, 1, 2.1972245773362196)
        tdSql.checkData(9, 2, 81.0)
        tdSql.checkData(9, 3, 83.0)
        tdSql.checkData(9, 4, 812.1972245773362)
        tdSql.checkData(9, 5, 19764.0)
        tdSql.checkData(9, 6, 475.5454239964755)
        tdSql.checkData(10, 0, 10)
        tdSql.checkData(10, 1, 2.302585092994046)
        tdSql.checkData(10, 2, 100.0)
        tdSql.checkData(10, 3, 102.0)
        tdSql.checkData(10, 4, 1102.302585092994)
        tdSql.checkData(10, 5, 31722.776601683792)
        tdSql.checkData(10, 6, 636.9208936206307)
        tdSql.checkData(11, 0, 11)
        tdSql.checkData(11, 1, 2.3978952727983707)
        tdSql.checkData(11, 2, 121.0)
        tdSql.checkData(11, 3, 123.0)
        tdSql.checkData(11, 4, 1454.3978952727985)
        tdSql.checkData(11, 5, 48679.70355559341)
        tdSql.checkData(11, 6, 830.0750695123152)
        tdSql.checkData(12, 0, 12)
        tdSql.checkData(12, 1, 2.4849066497880004)
        tdSql.checkData(12, 2, 144.0)
        tdSql.checkData(12, 3, 146.0)
        tdSql.checkData(12, 4, 1874.484906649788)
        tdSql.checkData(12, 5, 71975.61109149648)
        tdSql.checkData(12, 6, 1057.5309706916078)
        tdSql.checkData(13, 0, 13)
        tdSql.checkData(13, 1, 2.5649493574615367)
        tdSql.checkData(13, 2, 169.0)
        tdSql.checkData(13, 3, 171.0)
        tdSql.checkData(13, 4, 2368.5649493574615)
        tdSql.checkData(13, 5, 103147.149978527)
        tdSql.checkData(13, 6, 1321.765342841202)
        tdSql.checkData(14, 0, 14)
        tdSql.checkData(14, 1, 2.6390573296152584)
        tdSql.checkData(14, 2, 196.0)
        tdSql.checkData(14, 3, 198.0)
        tdSql.checkData(14, 4, 2942.6390573296153)
        tdSql.checkData(14, 5, 143935.51017030774)
        tdSql.checkData(14, 6, 1625.213413896577)
        tdSql.checkData(15, 0, 15)
        tdSql.checkData(15, 1, 2.70805020110221)
        tdSql.checkData(15, 2, 225.0)
        tdSql.checkData(15, 3, 227.0)
        tdSql.checkData(15, 4, 3602.708050201102)
        tdSql.checkData(15, 5, 196294.78190175048)
        tdSql.checkData(15, 6, 1970.2728076392277)
        tdSql.checkData(16, 0, 16)
        tdSql.checkData(16, 1, 2.772588722239781)
        tdSql.checkData(16, 2, 256.0)
        tdSql.checkData(16, 3, 258.0)
        tdSql.checkData(16, 4, 4354.77258872224)
        tdSql.checkData(16, 5, 262400.0)
        tdSql.checkData(16, 6, 2359.306819756166)
        tdSql.checkData(17, 0, 17)
        tdSql.checkData(17, 1, 2.833213344056216)
        tdSql.checkData(17, 2, 289.0)
        tdSql.checkData(17, 3, 291.0)
        tdSql.checkData(17, 4, 5204.833213344056)
        tdSql.checkData(17, 5, 344654.9049572126)
        tdSql.checkData(17, 6, 2794.647199269153)
        tdSql.checkData(18, 0, 18)
        tdSql.checkData(18, 1, 2.8903717578961645)
        tdSql.checkData(18, 2, 324.0)
        tdSql.checkData(18, 3, 326.0)
        tdSql.checkData(18, 4, 6158.890371757896)
        tdSql.checkData(18, 5, 445699.4487710341)
        tdSql.checkData(18, 6, 3278.5965383797334)
        tdSql.checkData(19, 0, 19)
        tdSql.checkData(19, 1, 2.9444389791664403)
        tdSql.checkData(19, 2, 361.0)
        tdSql.checkData(19, 3, 363.0)
        tdSql.checkData(19, 4, 7222.944438979166)
        tdSql.checkData(19, 5, 568417.0692211641)
        tdSql.checkData(19, 6, 3813.4303469855686)

        tdSql.query(
            "select c1, log(c2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1)+log(c3,4)+pow(c6,2.8)+2 as v6 from ct1 where ts == 1601481600000;"
        )
        tdSql.checkRows(1)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -1.3862943611198906)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)

        tdSql.query(
            "select c1, log(c2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1)+log(c3,4)+pow(c6,2.8)+2 as v6 from st0 where ts == 1601481600000;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -1.3862943611198906)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)
        tdSql.checkData(1, 0, 0)
        tdSql.checkData(1, 1, -1.3862943611198906)
        tdSql.checkData(1, 2, 0.0)
        tdSql.checkData(1, 3, 2.0625)
        tdSql.checkData(1, 4, -inf)
        tdSql.checkData(1, 5, 0.0)
        tdSql.checkData(1, 6, -inf)

        tdSql.query(
            "select c1, log(c2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1)+log(c3,4)+pow(c6,2.8)+2 as v6 from st0 where c1 == 0;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -1.3862943611198906)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)
        tdSql.checkData(1, 0, 0)
        tdSql.checkData(1, 1, -1.3862943611198906)
        tdSql.checkData(1, 2, 0.0)
        tdSql.checkData(1, 3, 2.0625)
        tdSql.checkData(1, 4, -inf)
        tdSql.checkData(1, 5, 0.0)
        tdSql.checkData(1, 6, -inf)

        tdSql.query(
            "select c1, log(c2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1)+log(c3,4)+pow(c6,2.8)+2 as v6 from st0 where c1 == 0;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -1.3862943611198906)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)
        tdSql.checkData(1, 0, 0)
        tdSql.checkData(1, 1, -1.3862943611198906)
        tdSql.checkData(1, 2, 0.0)
        tdSql.checkData(1, 3, 2.0625)
        tdSql.checkData(1, 4, -inf)
        tdSql.checkData(1, 5, 0.0)
        tdSql.checkData(1, 6, -inf)

        tdSql.query(
            "select c1, log(c2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1)+log(c3,4)+pow(c6,2.8)+2 as v6 from st0 order by ts desc;"
        )
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, 19)
        tdSql.checkData(0, 1, 2.9444389791664403)
        tdSql.checkData(0, 2, 361.0)
        tdSql.checkData(0, 3, 363.0)
        tdSql.checkData(0, 4, 7222.944438979166)
        tdSql.checkData(0, 5, 568417.0692211641)
        tdSql.checkData(0, 6, 3813.4303469855686)
        tdSql.checkData(1, 0, 18)
        tdSql.checkData(1, 1, 2.8903717578961645)
        tdSql.checkData(1, 2, 324.0)
        tdSql.checkData(1, 3, 326.0)
        tdSql.checkData(1, 4, 6158.890371757896)
        tdSql.checkData(1, 5, 445699.4487710341)
        tdSql.checkData(1, 6, 3278.5965383797334)
        tdSql.checkData(2, 0, 17)
        tdSql.checkData(2, 1, 2.833213344056216)
        tdSql.checkData(2, 2, 289.0)
        tdSql.checkData(2, 3, 291.0)
        tdSql.checkData(2, 4, 5204.833213344056)
        tdSql.checkData(2, 5, 344654.9049572126)
        tdSql.checkData(2, 6, 2794.647199269153)
        tdSql.checkData(3, 0, 16)
        tdSql.checkData(3, 1, 2.772588722239781)
        tdSql.checkData(3, 2, 256.0)
        tdSql.checkData(3, 3, 258.0)
        tdSql.checkData(3, 4, 4354.77258872224)
        tdSql.checkData(3, 5, 262400.0)
        tdSql.checkData(3, 6, 2359.306819756166)
        tdSql.checkData(4, 0, 15)
        tdSql.checkData(4, 1, 2.70805020110221)
        tdSql.checkData(4, 2, 225.0)
        tdSql.checkData(4, 3, 227.0)
        tdSql.checkData(4, 4, 3602.708050201102)
        tdSql.checkData(4, 5, 196294.78190175048)
        tdSql.checkData(4, 6, 1970.2728076392277)
        tdSql.checkData(5, 0, 14)
        tdSql.checkData(5, 1, 2.6390573296152584)
        tdSql.checkData(5, 2, 196.0)
        tdSql.checkData(5, 3, 198.0)
        tdSql.checkData(5, 4, 2942.6390573296153)
        tdSql.checkData(5, 5, 143935.51017030774)
        tdSql.checkData(5, 6, 1625.213413896577)
        tdSql.checkData(6, 0, 13)
        tdSql.checkData(6, 1, 2.5649493574615367)
        tdSql.checkData(6, 2, 169.0)
        tdSql.checkData(6, 3, 171.0)
        tdSql.checkData(6, 4, 2368.5649493574615)
        tdSql.checkData(6, 5, 103147.149978527)
        tdSql.checkData(6, 6, 1321.765342841202)
        tdSql.checkData(7, 0, 12)
        tdSql.checkData(7, 1, 2.4849066497880004)
        tdSql.checkData(7, 2, 144.0)
        tdSql.checkData(7, 3, 146.0)
        tdSql.checkData(7, 4, 1874.484906649788)
        tdSql.checkData(7, 5, 71975.61109149648)
        tdSql.checkData(7, 6, 1057.5309706916078)
        tdSql.checkData(8, 0, 11)
        tdSql.checkData(8, 1, 2.3978952727983707)
        tdSql.checkData(8, 2, 121.0)
        tdSql.checkData(8, 3, 123.0)
        tdSql.checkData(8, 4, 1454.3978952727985)
        tdSql.checkData(8, 5, 48679.70355559341)
        tdSql.checkData(8, 6, 830.0750695123152)
        tdSql.checkData(9, 0, 10)
        tdSql.checkData(9, 1, 2.302585092994046)
        tdSql.checkData(9, 2, 100.0)
        tdSql.checkData(9, 3, 102.0)
        tdSql.checkData(9, 4, 1102.302585092994)
        tdSql.checkData(9, 5, 31722.776601683792)
        tdSql.checkData(9, 6, 636.9208936206307)
        tdSql.checkData(10, 0, 9)
        tdSql.checkData(10, 1, 2.1972245773362196)
        tdSql.checkData(10, 2, 81.0)
        tdSql.checkData(10, 3, 83.0)
        tdSql.checkData(10, 4, 812.1972245773362)
        tdSql.checkData(10, 5, 19764.0)
        tdSql.checkData(10, 6, 475.5454239964755)
        tdSql.checkData(11, 0, 9)
        tdSql.checkData(11, 1, 2.1972245773362196)
        tdSql.checkData(11, 2, 81.0)
        tdSql.checkData(11, 3, 83.0)
        tdSql.checkData(11, 4, 812.1972245773362)
        tdSql.checkData(11, 5, 19764.0)
        tdSql.checkData(11, 6, 475.5454239964755)
        tdSql.checkData(12, 0, 8)
        tdSql.checkData(12, 1, 2.0794415416798357)
        tdSql.checkData(12, 2, 64.0)
        tdSql.checkData(12, 3, 66.0)
        tdSql.checkData(12, 4, 578.0794415416798)
        tdSql.checkData(12, 5, 11649.237502960395)
        tdSql.checkData(12, 6, 343.37346669954064)
        tdSql.checkData(13, 0, 8)
        tdSql.checkData(13, 1, 2.0794415416798357)
        tdSql.checkData(13, 2, 64.0)
        tdSql.checkData(13, 3, 66.0)
        tdSql.checkData(13, 4, 578.0794415416798)
        tdSql.checkData(13, 5, 11649.237502960395)
        tdSql.checkData(13, 6, 343.37346669954064)
        tdSql.checkData(14, 0, 7)
        tdSql.checkData(14, 1, 1.9459101490553132)
        tdSql.checkData(14, 2, 49.0)
        tdSql.checkData(14, 3, 51.0)
        tdSql.checkData(14, 4, 393.9459101490553)
        tdSql.checkData(14, 5, 6401.448897866082)
        tdSql.checkData(14, 6, 237.770130906449)
        tdSql.checkData(15, 0, 7)
        tdSql.checkData(15, 1, 1.9459101490553132)
        tdSql.checkData(15, 2, 49.0)
        tdSql.checkData(15, 3, 51.0)
        tdSql.checkData(15, 4, 393.9459101490553)
        tdSql.checkData(15, 5, 6401.448897866082)
        tdSql.checkData(15, 6, 237.770130906449)
        tdSql.checkData(16, 0, 6)
        tdSql.checkData(16, 1, 1.791759469228055)
        tdSql.checkData(16, 2, 36.0)
        tdSql.checkData(16, 3, 38.0)
        tdSql.checkData(16, 4, 253.79175946922805)
        tdSql.checkData(16, 5, 3210.538706646999)
        tdSql.checkData(16, 6, 156.0308983742497)
        tdSql.checkData(17, 0, 6)
        tdSql.checkData(17, 1, 1.791759469228055)
        tdSql.checkData(17, 2, 36.0)
        tdSql.checkData(17, 3, 38.0)
        tdSql.checkData(17, 4, 253.79175946922805)
        tdSql.checkData(17, 5, 3210.538706646999)
        tdSql.checkData(17, 6, 156.0308983742497)
        tdSql.checkData(18, 0, 5)
        tdSql.checkData(18, 1, 1.6094379124341003)
        tdSql.checkData(18, 2, 25.0)
        tdSql.checkData(18, 3, 27.0)
        tdSql.checkData(18, 4, 151.6094379124341)
        tdSql.checkData(18, 5, 1422.5424859373686)
        tdSql.checkData(18, 6, 95.3678599195897)
        tdSql.checkData(19, 0, 5)
        tdSql.checkData(19, 1, 1.6094379124341003)
        tdSql.checkData(19, 2, 25.0)
        tdSql.checkData(19, 3, 27.0)
        tdSql.checkData(19, 4, 151.6094379124341)
        tdSql.checkData(19, 5, 1422.5424859373686)
        tdSql.checkData(19, 6, 95.3678599195897)
        tdSql.checkData(20, 0, 4)
        tdSql.checkData(20, 1, 1.3862943611198906)
        tdSql.checkData(20, 2, 16.0)
        tdSql.checkData(20, 3, 18.0)
        tdSql.checkData(20, 4, 81.3862943611199)
        tdSql.checkData(20, 5, 528.0)
        tdSql.checkData(20, 6, 52.889224489452616)
        tdSql.checkData(21, 0, 4)
        tdSql.checkData(21, 1, 1.3862943611198906)
        tdSql.checkData(21, 2, 16.0)
        tdSql.checkData(21, 3, 18.0)
        tdSql.checkData(21, 4, 81.3862943611199)
        tdSql.checkData(21, 5, 528.0)
        tdSql.checkData(21, 6, 52.889224489452616)
        tdSql.checkData(22, 0, 3)
        tdSql.checkData(22, 1, 1.0986122886681098)
        tdSql.checkData(22, 2, 9.0)
        tdSql.checkData(22, 3, 11.0)
        tdSql.checkData(22, 4, 37.09861228866811)
        tdSql.checkData(22, 5, 149.29611541307906)
        tdSql.checkData(22, 6, 25.565115706554913)
        tdSql.checkData(23, 0, 3)
        tdSql.checkData(23, 1, 1.0986122886681098)
        tdSql.checkData(23, 2, 9.0)
        tdSql.checkData(23, 3, 11.0)
        tdSql.checkData(23, 4, 37.09861228866811)
        tdSql.checkData(23, 5, 149.29611541307906)
        tdSql.checkData(23, 6, 25.565115706554913)
        tdSql.checkData(24, 0, 2)
        tdSql.checkData(24, 1, 0.6931471805599453)
        tdSql.checkData(24, 2, 4.0)
        tdSql.checkData(24, 3, 6.0)
        tdSql.checkData(24, 4, 12.693147180559945)
        tdSql.checkData(24, 5, 26.627416997969522)
        tdSql.checkData(24, 6, 10.157551686928937)
        tdSql.checkData(25, 0, 2)
        tdSql.checkData(25, 1, 0.6931471805599453)
        tdSql.checkData(25, 2, 4.0)
        tdSql.checkData(25, 3, 6.0)
        tdSql.checkData(25, 4, 12.693147180559945)
        tdSql.checkData(25, 5, 26.627416997969522)
        tdSql.checkData(25, 6, 10.157551686928937)
        tdSql.checkData(26, 0, 1)
        tdSql.checkData(26, 1, 0.0)
        tdSql.checkData(26, 2, 1.0)
        tdSql.checkData(26, 3, 3.0)
        tdSql.checkData(26, 4, 2.0)
        tdSql.checkData(26, 5, 2.0)
        tdSql.checkData(26, 6, 3.0)
        tdSql.checkData(27, 0, 1)
        tdSql.checkData(27, 1, 0.0)
        tdSql.checkData(27, 2, 1.0)
        tdSql.checkData(27, 3, 3.0)
        tdSql.checkData(27, 4, 2.0)
        tdSql.checkData(27, 5, 2.0)
        tdSql.checkData(27, 6, 3.0)
        tdSql.checkData(28, 0, 0)
        tdSql.checkData(28, 1, -1.3862943611198906)
        tdSql.checkData(28, 2, 0.0)
        tdSql.checkData(28, 3, 2.0625)
        tdSql.checkData(28, 4, -inf)
        tdSql.checkData(28, 5, 0.0)
        tdSql.checkData(28, 6, -inf)
        tdSql.checkData(29, 0, 0)
        tdSql.checkData(29, 1, -1.3862943611198906)
        tdSql.checkData(29, 2, 0.0)
        tdSql.checkData(29, 3, 2.0625)
        tdSql.checkData(29, 4, -inf)
        tdSql.checkData(29, 5, 0.0)
        tdSql.checkData(29, 6, -inf)

        tdSql.query(
            "select c1, log(c2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1)+log(c3,4)+pow(c6,2.8)+2 as v6 from ct1 order by ts limit 2;;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -1.3862943611198906)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(1, 1, 0.0)
        tdSql.checkData(1, 2, 1.0)
        tdSql.checkData(1, 3, 3.0)
        tdSql.checkData(1, 4, 2.0)
        tdSql.checkData(1, 5, 2.0)
        tdSql.checkData(1, 6, 3.0)

        tdSql.query(
            "select sqrt(abs(log(c1)-pow(c1,2)))+2 from ct1 order by ts limit 2;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, inf)
        tdSql.checkData(1, 0, 3.0)

        tdSql.query(
            "select c1, log(c2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1)+log(c3,4)+pow(c6,2.8)+2 as v6 from (select * from st0 order by ts desc);"
        )
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, 19)
        tdSql.checkData(0, 1, 2.9444389791664403)
        tdSql.checkData(0, 2, 361.0)
        tdSql.checkData(0, 3, 363.0)
        tdSql.checkData(0, 4, 7222.944438979166)
        tdSql.checkData(0, 5, 568417.0692211641)
        tdSql.checkData(0, 6, 3813.4303469855686)
        tdSql.checkData(1, 0, 18)
        tdSql.checkData(1, 1, 2.8903717578961645)
        tdSql.checkData(1, 2, 324.0)
        tdSql.checkData(1, 3, 326.0)
        tdSql.checkData(1, 4, 6158.890371757896)
        tdSql.checkData(1, 5, 445699.4487710341)
        tdSql.checkData(1, 6, 3278.5965383797334)
        tdSql.checkData(2, 0, 17)
        tdSql.checkData(2, 1, 2.833213344056216)
        tdSql.checkData(2, 2, 289.0)
        tdSql.checkData(2, 3, 291.0)
        tdSql.checkData(2, 4, 5204.833213344056)
        tdSql.checkData(2, 5, 344654.9049572126)
        tdSql.checkData(2, 6, 2794.647199269153)
        tdSql.checkData(3, 0, 16)
        tdSql.checkData(3, 1, 2.772588722239781)
        tdSql.checkData(3, 2, 256.0)
        tdSql.checkData(3, 3, 258.0)
        tdSql.checkData(3, 4, 4354.77258872224)
        tdSql.checkData(3, 5, 262400.0)
        tdSql.checkData(3, 6, 2359.306819756166)
        tdSql.checkData(4, 0, 15)
        tdSql.checkData(4, 1, 2.70805020110221)
        tdSql.checkData(4, 2, 225.0)
        tdSql.checkData(4, 3, 227.0)
        tdSql.checkData(4, 4, 3602.708050201102)
        tdSql.checkData(4, 5, 196294.78190175048)
        tdSql.checkData(4, 6, 1970.2728076392277)
        tdSql.checkData(5, 0, 14)
        tdSql.checkData(5, 1, 2.6390573296152584)
        tdSql.checkData(5, 2, 196.0)
        tdSql.checkData(5, 3, 198.0)
        tdSql.checkData(5, 4, 2942.6390573296153)
        tdSql.checkData(5, 5, 143935.51017030774)
        tdSql.checkData(5, 6, 1625.213413896577)
        tdSql.checkData(6, 0, 13)
        tdSql.checkData(6, 1, 2.5649493574615367)
        tdSql.checkData(6, 2, 169.0)
        tdSql.checkData(6, 3, 171.0)
        tdSql.checkData(6, 4, 2368.5649493574615)
        tdSql.checkData(6, 5, 103147.149978527)
        tdSql.checkData(6, 6, 1321.765342841202)
        tdSql.checkData(7, 0, 12)
        tdSql.checkData(7, 1, 2.4849066497880004)
        tdSql.checkData(7, 2, 144.0)
        tdSql.checkData(7, 3, 146.0)
        tdSql.checkData(7, 4, 1874.484906649788)
        tdSql.checkData(7, 5, 71975.61109149648)
        tdSql.checkData(7, 6, 1057.5309706916078)
        tdSql.checkData(8, 0, 11)
        tdSql.checkData(8, 1, 2.3978952727983707)
        tdSql.checkData(8, 2, 121.0)
        tdSql.checkData(8, 3, 123.0)
        tdSql.checkData(8, 4, 1454.3978952727985)
        tdSql.checkData(8, 5, 48679.70355559341)
        tdSql.checkData(8, 6, 830.0750695123152)
        tdSql.checkData(9, 0, 10)
        tdSql.checkData(9, 1, 2.302585092994046)
        tdSql.checkData(9, 2, 100.0)
        tdSql.checkData(9, 3, 102.0)
        tdSql.checkData(9, 4, 1102.302585092994)
        tdSql.checkData(9, 5, 31722.776601683792)
        tdSql.checkData(9, 6, 636.9208936206307)
        tdSql.checkData(10, 0, 9)
        tdSql.checkData(10, 1, 2.1972245773362196)
        tdSql.checkData(10, 2, 81.0)
        tdSql.checkData(10, 3, 83.0)
        tdSql.checkData(10, 4, 812.1972245773362)
        tdSql.checkData(10, 5, 19764.0)
        tdSql.checkData(10, 6, 475.5454239964755)
        tdSql.checkData(11, 0, 9)
        tdSql.checkData(11, 1, 2.1972245773362196)
        tdSql.checkData(11, 2, 81.0)
        tdSql.checkData(11, 3, 83.0)
        tdSql.checkData(11, 4, 812.1972245773362)
        tdSql.checkData(11, 5, 19764.0)
        tdSql.checkData(11, 6, 475.5454239964755)
        tdSql.checkData(12, 0, 8)
        tdSql.checkData(12, 1, 2.0794415416798357)
        tdSql.checkData(12, 2, 64.0)
        tdSql.checkData(12, 3, 66.0)
        tdSql.checkData(12, 4, 578.0794415416798)
        tdSql.checkData(12, 5, 11649.237502960395)
        tdSql.checkData(12, 6, 343.37346669954064)
        tdSql.checkData(13, 0, 8)
        tdSql.checkData(13, 1, 2.0794415416798357)
        tdSql.checkData(13, 2, 64.0)
        tdSql.checkData(13, 3, 66.0)
        tdSql.checkData(13, 4, 578.0794415416798)
        tdSql.checkData(13, 5, 11649.237502960395)
        tdSql.checkData(13, 6, 343.37346669954064)
        tdSql.checkData(14, 0, 7)
        tdSql.checkData(14, 1, 1.9459101490553132)
        tdSql.checkData(14, 2, 49.0)
        tdSql.checkData(14, 3, 51.0)
        tdSql.checkData(14, 4, 393.9459101490553)
        tdSql.checkData(14, 5, 6401.448897866082)
        tdSql.checkData(14, 6, 237.770130906449)
        tdSql.checkData(15, 0, 7)
        tdSql.checkData(15, 1, 1.9459101490553132)
        tdSql.checkData(15, 2, 49.0)
        tdSql.checkData(15, 3, 51.0)
        tdSql.checkData(15, 4, 393.9459101490553)
        tdSql.checkData(15, 5, 6401.448897866082)
        tdSql.checkData(15, 6, 237.770130906449)
        tdSql.checkData(16, 0, 6)
        tdSql.checkData(16, 1, 1.791759469228055)
        tdSql.checkData(16, 2, 36.0)
        tdSql.checkData(16, 3, 38.0)
        tdSql.checkData(16, 4, 253.79175946922805)
        tdSql.checkData(16, 5, 3210.538706646999)
        tdSql.checkData(16, 6, 156.0308983742497)
        tdSql.checkData(17, 0, 6)
        tdSql.checkData(17, 1, 1.791759469228055)
        tdSql.checkData(17, 2, 36.0)
        tdSql.checkData(17, 3, 38.0)
        tdSql.checkData(17, 4, 253.79175946922805)
        tdSql.checkData(17, 5, 3210.538706646999)
        tdSql.checkData(17, 6, 156.0308983742497)
        tdSql.checkData(18, 0, 5)
        tdSql.checkData(18, 1, 1.6094379124341003)
        tdSql.checkData(18, 2, 25.0)
        tdSql.checkData(18, 3, 27.0)
        tdSql.checkData(18, 4, 151.6094379124341)
        tdSql.checkData(18, 5, 1422.5424859373686)
        tdSql.checkData(18, 6, 95.3678599195897)
        tdSql.checkData(19, 0, 5)
        tdSql.checkData(19, 1, 1.6094379124341003)
        tdSql.checkData(19, 2, 25.0)
        tdSql.checkData(19, 3, 27.0)
        tdSql.checkData(19, 4, 151.6094379124341)
        tdSql.checkData(19, 5, 1422.5424859373686)
        tdSql.checkData(19, 6, 95.3678599195897)
        tdSql.checkData(20, 0, 4)
        tdSql.checkData(20, 1, 1.3862943611198906)
        tdSql.checkData(20, 2, 16.0)
        tdSql.checkData(20, 3, 18.0)
        tdSql.checkData(20, 4, 81.3862943611199)
        tdSql.checkData(20, 5, 528.0)
        tdSql.checkData(20, 6, 52.889224489452616)
        tdSql.checkData(21, 0, 4)
        tdSql.checkData(21, 1, 1.3862943611198906)
        tdSql.checkData(21, 2, 16.0)
        tdSql.checkData(21, 3, 18.0)
        tdSql.checkData(21, 4, 81.3862943611199)
        tdSql.checkData(21, 5, 528.0)
        tdSql.checkData(21, 6, 52.889224489452616)
        tdSql.checkData(22, 0, 3)
        tdSql.checkData(22, 1, 1.0986122886681098)
        tdSql.checkData(22, 2, 9.0)
        tdSql.checkData(22, 3, 11.0)
        tdSql.checkData(22, 4, 37.09861228866811)
        tdSql.checkData(22, 5, 149.29611541307906)
        tdSql.checkData(22, 6, 25.565115706554913)
        tdSql.checkData(23, 0, 3)
        tdSql.checkData(23, 1, 1.0986122886681098)
        tdSql.checkData(23, 2, 9.0)
        tdSql.checkData(23, 3, 11.0)
        tdSql.checkData(23, 4, 37.09861228866811)
        tdSql.checkData(23, 5, 149.29611541307906)
        tdSql.checkData(23, 6, 25.565115706554913)
        tdSql.checkData(24, 0, 2)
        tdSql.checkData(24, 1, 0.6931471805599453)
        tdSql.checkData(24, 2, 4.0)
        tdSql.checkData(24, 3, 6.0)
        tdSql.checkData(24, 4, 12.693147180559945)
        tdSql.checkData(24, 5, 26.627416997969522)
        tdSql.checkData(24, 6, 10.157551686928937)
        tdSql.checkData(25, 0, 2)
        tdSql.checkData(25, 1, 0.6931471805599453)
        tdSql.checkData(25, 2, 4.0)
        tdSql.checkData(25, 3, 6.0)
        tdSql.checkData(25, 4, 12.693147180559945)
        tdSql.checkData(25, 5, 26.627416997969522)
        tdSql.checkData(25, 6, 10.157551686928937)
        tdSql.checkData(26, 0, 1)
        tdSql.checkData(26, 1, 0.0)
        tdSql.checkData(26, 2, 1.0)
        tdSql.checkData(26, 3, 3.0)
        tdSql.checkData(26, 4, 2.0)
        tdSql.checkData(26, 5, 2.0)
        tdSql.checkData(26, 6, 3.0)
        tdSql.checkData(27, 0, 1)
        tdSql.checkData(27, 1, 0.0)
        tdSql.checkData(27, 2, 1.0)
        tdSql.checkData(27, 3, 3.0)
        tdSql.checkData(27, 4, 2.0)
        tdSql.checkData(27, 5, 2.0)
        tdSql.checkData(27, 6, 3.0)
        tdSql.checkData(28, 0, 0)
        tdSql.checkData(28, 1, -1.3862943611198906)
        tdSql.checkData(28, 2, 0.0)
        tdSql.checkData(28, 3, 2.0625)
        tdSql.checkData(28, 4, -inf)
        tdSql.checkData(28, 5, 0.0)
        tdSql.checkData(28, 6, -inf)
        tdSql.checkData(29, 0, 0)
        tdSql.checkData(29, 1, -1.3862943611198906)
        tdSql.checkData(29, 2, 0.0)
        tdSql.checkData(29, 3, 2.0625)
        tdSql.checkData(29, 4, -inf)
        tdSql.checkData(29, 5, 0.0)
        tdSql.checkData(29, 6, -inf)

        tdSql.query(
            "select c1, log(c2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1)+log(c3,4)+pow(c6,2.8)+2 as v6 from (select * from ct1 order by ts limit 2);;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -1.3862943611198906)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(1, 1, 0.0)
        tdSql.checkData(1, 2, 1.0)
        tdSql.checkData(1, 3, 3.0)
        tdSql.checkData(1, 4, 2.0)
        tdSql.checkData(1, 5, 2.0)
        tdSql.checkData(1, 6, 3.0)

        tdSql.query(
            "select c1, log(c2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1)+log(c3,4)+pow(c6,2.8)+2 as v6 from (select * from st0 ) order by ts desc;"
        )
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, 19)
        tdSql.checkData(0, 1, 2.9444389791664403)
        tdSql.checkData(0, 2, 361.0)
        tdSql.checkData(0, 3, 363.0)
        tdSql.checkData(0, 4, 7222.944438979166)
        tdSql.checkData(0, 5, 568417.0692211641)
        tdSql.checkData(0, 6, 3813.4303469855686)
        tdSql.checkData(1, 0, 18)
        tdSql.checkData(1, 1, 2.8903717578961645)
        tdSql.checkData(1, 2, 324.0)
        tdSql.checkData(1, 3, 326.0)
        tdSql.checkData(1, 4, 6158.890371757896)
        tdSql.checkData(1, 5, 445699.4487710341)
        tdSql.checkData(1, 6, 3278.5965383797334)
        tdSql.checkData(2, 0, 17)
        tdSql.checkData(2, 1, 2.833213344056216)
        tdSql.checkData(2, 2, 289.0)
        tdSql.checkData(2, 3, 291.0)
        tdSql.checkData(2, 4, 5204.833213344056)
        tdSql.checkData(2, 5, 344654.9049572126)
        tdSql.checkData(2, 6, 2794.647199269153)
        tdSql.checkData(3, 0, 16)
        tdSql.checkData(3, 1, 2.772588722239781)
        tdSql.checkData(3, 2, 256.0)
        tdSql.checkData(3, 3, 258.0)
        tdSql.checkData(3, 4, 4354.77258872224)
        tdSql.checkData(3, 5, 262400.0)
        tdSql.checkData(3, 6, 2359.306819756166)
        tdSql.checkData(4, 0, 15)
        tdSql.checkData(4, 1, 2.70805020110221)
        tdSql.checkData(4, 2, 225.0)
        tdSql.checkData(4, 3, 227.0)
        tdSql.checkData(4, 4, 3602.708050201102)
        tdSql.checkData(4, 5, 196294.78190175048)
        tdSql.checkData(4, 6, 1970.2728076392277)
        tdSql.checkData(5, 0, 14)
        tdSql.checkData(5, 1, 2.6390573296152584)
        tdSql.checkData(5, 2, 196.0)
        tdSql.checkData(5, 3, 198.0)
        tdSql.checkData(5, 4, 2942.6390573296153)
        tdSql.checkData(5, 5, 143935.51017030774)
        tdSql.checkData(5, 6, 1625.213413896577)
        tdSql.checkData(6, 0, 13)
        tdSql.checkData(6, 1, 2.5649493574615367)
        tdSql.checkData(6, 2, 169.0)
        tdSql.checkData(6, 3, 171.0)
        tdSql.checkData(6, 4, 2368.5649493574615)
        tdSql.checkData(6, 5, 103147.149978527)
        tdSql.checkData(6, 6, 1321.765342841202)
        tdSql.checkData(7, 0, 12)
        tdSql.checkData(7, 1, 2.4849066497880004)
        tdSql.checkData(7, 2, 144.0)
        tdSql.checkData(7, 3, 146.0)
        tdSql.checkData(7, 4, 1874.484906649788)
        tdSql.checkData(7, 5, 71975.61109149648)
        tdSql.checkData(7, 6, 1057.5309706916078)
        tdSql.checkData(8, 0, 11)
        tdSql.checkData(8, 1, 2.3978952727983707)
        tdSql.checkData(8, 2, 121.0)
        tdSql.checkData(8, 3, 123.0)
        tdSql.checkData(8, 4, 1454.3978952727985)
        tdSql.checkData(8, 5, 48679.70355559341)
        tdSql.checkData(8, 6, 830.0750695123152)
        tdSql.checkData(9, 0, 10)
        tdSql.checkData(9, 1, 2.302585092994046)
        tdSql.checkData(9, 2, 100.0)
        tdSql.checkData(9, 3, 102.0)
        tdSql.checkData(9, 4, 1102.302585092994)
        tdSql.checkData(9, 5, 31722.776601683792)
        tdSql.checkData(9, 6, 636.9208936206307)
        tdSql.checkData(10, 0, 9)
        tdSql.checkData(10, 1, 2.1972245773362196)
        tdSql.checkData(10, 2, 81.0)
        tdSql.checkData(10, 3, 83.0)
        tdSql.checkData(10, 4, 812.1972245773362)
        tdSql.checkData(10, 5, 19764.0)
        tdSql.checkData(10, 6, 475.5454239964755)
        tdSql.checkData(11, 0, 9)
        tdSql.checkData(11, 1, 2.1972245773362196)
        tdSql.checkData(11, 2, 81.0)
        tdSql.checkData(11, 3, 83.0)
        tdSql.checkData(11, 4, 812.1972245773362)
        tdSql.checkData(11, 5, 19764.0)
        tdSql.checkData(11, 6, 475.5454239964755)
        tdSql.checkData(12, 0, 8)
        tdSql.checkData(12, 1, 2.0794415416798357)
        tdSql.checkData(12, 2, 64.0)
        tdSql.checkData(12, 3, 66.0)
        tdSql.checkData(12, 4, 578.0794415416798)
        tdSql.checkData(12, 5, 11649.237502960395)
        tdSql.checkData(12, 6, 343.37346669954064)
        tdSql.checkData(13, 0, 8)
        tdSql.checkData(13, 1, 2.0794415416798357)
        tdSql.checkData(13, 2, 64.0)
        tdSql.checkData(13, 3, 66.0)
        tdSql.checkData(13, 4, 578.0794415416798)
        tdSql.checkData(13, 5, 11649.237502960395)
        tdSql.checkData(13, 6, 343.37346669954064)
        tdSql.checkData(14, 0, 7)
        tdSql.checkData(14, 1, 1.9459101490553132)
        tdSql.checkData(14, 2, 49.0)
        tdSql.checkData(14, 3, 51.0)
        tdSql.checkData(14, 4, 393.9459101490553)
        tdSql.checkData(14, 5, 6401.448897866082)
        tdSql.checkData(14, 6, 237.770130906449)
        tdSql.checkData(15, 0, 7)
        tdSql.checkData(15, 1, 1.9459101490553132)
        tdSql.checkData(15, 2, 49.0)
        tdSql.checkData(15, 3, 51.0)
        tdSql.checkData(15, 4, 393.9459101490553)
        tdSql.checkData(15, 5, 6401.448897866082)
        tdSql.checkData(15, 6, 237.770130906449)
        tdSql.checkData(16, 0, 6)
        tdSql.checkData(16, 1, 1.791759469228055)
        tdSql.checkData(16, 2, 36.0)
        tdSql.checkData(16, 3, 38.0)
        tdSql.checkData(16, 4, 253.79175946922805)
        tdSql.checkData(16, 5, 3210.538706646999)
        tdSql.checkData(16, 6, 156.0308983742497)
        tdSql.checkData(17, 0, 6)
        tdSql.checkData(17, 1, 1.791759469228055)
        tdSql.checkData(17, 2, 36.0)
        tdSql.checkData(17, 3, 38.0)
        tdSql.checkData(17, 4, 253.79175946922805)
        tdSql.checkData(17, 5, 3210.538706646999)
        tdSql.checkData(17, 6, 156.0308983742497)
        tdSql.checkData(18, 0, 5)
        tdSql.checkData(18, 1, 1.6094379124341003)
        tdSql.checkData(18, 2, 25.0)
        tdSql.checkData(18, 3, 27.0)
        tdSql.checkData(18, 4, 151.6094379124341)
        tdSql.checkData(18, 5, 1422.5424859373686)
        tdSql.checkData(18, 6, 95.3678599195897)
        tdSql.checkData(19, 0, 5)
        tdSql.checkData(19, 1, 1.6094379124341003)
        tdSql.checkData(19, 2, 25.0)
        tdSql.checkData(19, 3, 27.0)
        tdSql.checkData(19, 4, 151.6094379124341)
        tdSql.checkData(19, 5, 1422.5424859373686)
        tdSql.checkData(19, 6, 95.3678599195897)
        tdSql.checkData(20, 0, 4)
        tdSql.checkData(20, 1, 1.3862943611198906)
        tdSql.checkData(20, 2, 16.0)
        tdSql.checkData(20, 3, 18.0)
        tdSql.checkData(20, 4, 81.3862943611199)
        tdSql.checkData(20, 5, 528.0)
        tdSql.checkData(20, 6, 52.889224489452616)
        tdSql.checkData(21, 0, 4)
        tdSql.checkData(21, 1, 1.3862943611198906)
        tdSql.checkData(21, 2, 16.0)
        tdSql.checkData(21, 3, 18.0)
        tdSql.checkData(21, 4, 81.3862943611199)
        tdSql.checkData(21, 5, 528.0)
        tdSql.checkData(21, 6, 52.889224489452616)
        tdSql.checkData(22, 0, 3)
        tdSql.checkData(22, 1, 1.0986122886681098)
        tdSql.checkData(22, 2, 9.0)
        tdSql.checkData(22, 3, 11.0)
        tdSql.checkData(22, 4, 37.09861228866811)
        tdSql.checkData(22, 5, 149.29611541307906)
        tdSql.checkData(22, 6, 25.565115706554913)
        tdSql.checkData(23, 0, 3)
        tdSql.checkData(23, 1, 1.0986122886681098)
        tdSql.checkData(23, 2, 9.0)
        tdSql.checkData(23, 3, 11.0)
        tdSql.checkData(23, 4, 37.09861228866811)
        tdSql.checkData(23, 5, 149.29611541307906)
        tdSql.checkData(23, 6, 25.565115706554913)
        tdSql.checkData(24, 0, 2)
        tdSql.checkData(24, 1, 0.6931471805599453)
        tdSql.checkData(24, 2, 4.0)
        tdSql.checkData(24, 3, 6.0)
        tdSql.checkData(24, 4, 12.693147180559945)
        tdSql.checkData(24, 5, 26.627416997969522)
        tdSql.checkData(24, 6, 10.157551686928937)
        tdSql.checkData(25, 0, 2)
        tdSql.checkData(25, 1, 0.6931471805599453)
        tdSql.checkData(25, 2, 4.0)
        tdSql.checkData(25, 3, 6.0)
        tdSql.checkData(25, 4, 12.693147180559945)
        tdSql.checkData(25, 5, 26.627416997969522)
        tdSql.checkData(25, 6, 10.157551686928937)
        tdSql.checkData(26, 0, 1)
        tdSql.checkData(26, 1, 0.0)
        tdSql.checkData(26, 2, 1.0)
        tdSql.checkData(26, 3, 3.0)
        tdSql.checkData(26, 4, 2.0)
        tdSql.checkData(26, 5, 2.0)
        tdSql.checkData(26, 6, 3.0)
        tdSql.checkData(27, 0, 1)
        tdSql.checkData(27, 1, 0.0)
        tdSql.checkData(27, 2, 1.0)
        tdSql.checkData(27, 3, 3.0)
        tdSql.checkData(27, 4, 2.0)
        tdSql.checkData(27, 5, 2.0)
        tdSql.checkData(27, 6, 3.0)
        tdSql.checkData(28, 0, 0)
        tdSql.checkData(28, 1, -1.3862943611198906)
        tdSql.checkData(28, 2, 0.0)
        tdSql.checkData(28, 3, 2.0625)
        tdSql.checkData(28, 4, -inf)
        tdSql.checkData(28, 5, 0.0)
        tdSql.checkData(28, 6, -inf)
        tdSql.checkData(29, 0, 0)
        tdSql.checkData(29, 1, -1.3862943611198906)
        tdSql.checkData(29, 2, 0.0)
        tdSql.checkData(29, 3, 2.0625)
        tdSql.checkData(29, 4, -inf)
        tdSql.checkData(29, 5, 0.0)
        tdSql.checkData(29, 6, -inf)

        tdSql.query(
            "select c1, log(c2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1)+log(c3,4)+pow(c6,2.8)+2 as v6 from (select * from st0 );"
        )
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -1.3862943611198906)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(1, 1, 0.0)
        tdSql.checkData(1, 2, 1.0)
        tdSql.checkData(1, 3, 3.0)
        tdSql.checkData(1, 4, 2.0)
        tdSql.checkData(1, 5, 2.0)
        tdSql.checkData(1, 6, 3.0)
        tdSql.checkData(2, 0, 2)
        tdSql.checkData(2, 1, 0.6931471805599453)
        tdSql.checkData(2, 2, 4.0)
        tdSql.checkData(2, 3, 6.0)
        tdSql.checkData(2, 4, 12.693147180559945)
        tdSql.checkData(2, 5, 26.627416997969522)
        tdSql.checkData(2, 6, 10.157551686928937)
        tdSql.checkData(3, 0, 3)
        tdSql.checkData(3, 1, 1.0986122886681098)
        tdSql.checkData(3, 2, 9.0)
        tdSql.checkData(3, 3, 11.0)
        tdSql.checkData(3, 4, 37.09861228866811)
        tdSql.checkData(3, 5, 149.29611541307906)
        tdSql.checkData(3, 6, 25.565115706554913)
        tdSql.checkData(4, 0, 4)
        tdSql.checkData(4, 1, 1.3862943611198906)
        tdSql.checkData(4, 2, 16.0)
        tdSql.checkData(4, 3, 18.0)
        tdSql.checkData(4, 4, 81.3862943611199)
        tdSql.checkData(4, 5, 528.0)
        tdSql.checkData(4, 6, 52.889224489452616)
        tdSql.checkData(5, 0, 5)
        tdSql.checkData(5, 1, 1.6094379124341003)
        tdSql.checkData(5, 2, 25.0)
        tdSql.checkData(5, 3, 27.0)
        tdSql.checkData(5, 4, 151.6094379124341)
        tdSql.checkData(5, 5, 1422.5424859373686)
        tdSql.checkData(5, 6, 95.3678599195897)
        tdSql.checkData(6, 0, 6)
        tdSql.checkData(6, 1, 1.791759469228055)
        tdSql.checkData(6, 2, 36.0)
        tdSql.checkData(6, 3, 38.0)
        tdSql.checkData(6, 4, 253.79175946922805)
        tdSql.checkData(6, 5, 3210.538706646999)
        tdSql.checkData(6, 6, 156.0308983742497)
        tdSql.checkData(7, 0, 7)
        tdSql.checkData(7, 1, 1.9459101490553132)
        tdSql.checkData(7, 2, 49.0)
        tdSql.checkData(7, 3, 51.0)
        tdSql.checkData(7, 4, 393.9459101490553)
        tdSql.checkData(7, 5, 6401.448897866082)
        tdSql.checkData(7, 6, 237.770130906449)
        tdSql.checkData(8, 0, 8)
        tdSql.checkData(8, 1, 2.0794415416798357)
        tdSql.checkData(8, 2, 64.0)
        tdSql.checkData(8, 3, 66.0)
        tdSql.checkData(8, 4, 578.0794415416798)
        tdSql.checkData(8, 5, 11649.237502960395)
        tdSql.checkData(8, 6, 343.37346669954064)
        tdSql.checkData(9, 0, 9)
        tdSql.checkData(9, 1, 2.1972245773362196)
        tdSql.checkData(9, 2, 81.0)
        tdSql.checkData(9, 3, 83.0)
        tdSql.checkData(9, 4, 812.1972245773362)
        tdSql.checkData(9, 5, 19764.0)
        tdSql.checkData(9, 6, 475.5454239964755)
        tdSql.checkData(10, 0, 0)
        tdSql.checkData(10, 1, -1.3862943611198906)
        tdSql.checkData(10, 2, 0.0)
        tdSql.checkData(10, 3, 2.0625)
        tdSql.checkData(10, 4, -inf)
        tdSql.checkData(10, 5, 0.0)
        tdSql.checkData(10, 6, -inf)
        tdSql.checkData(11, 0, 1)
        tdSql.checkData(11, 1, 0.0)
        tdSql.checkData(11, 2, 1.0)
        tdSql.checkData(11, 3, 3.0)
        tdSql.checkData(11, 4, 2.0)
        tdSql.checkData(11, 5, 2.0)
        tdSql.checkData(11, 6, 3.0)
        tdSql.checkData(12, 0, 2)
        tdSql.checkData(12, 1, 0.6931471805599453)
        tdSql.checkData(12, 2, 4.0)
        tdSql.checkData(12, 3, 6.0)
        tdSql.checkData(12, 4, 12.693147180559945)
        tdSql.checkData(12, 5, 26.627416997969522)
        tdSql.checkData(12, 6, 10.157551686928937)
        tdSql.checkData(13, 0, 3)
        tdSql.checkData(13, 1, 1.0986122886681098)
        tdSql.checkData(13, 2, 9.0)
        tdSql.checkData(13, 3, 11.0)
        tdSql.checkData(13, 4, 37.09861228866811)
        tdSql.checkData(13, 5, 149.29611541307906)
        tdSql.checkData(13, 6, 25.565115706554913)
        tdSql.checkData(14, 0, 4)
        tdSql.checkData(14, 1, 1.3862943611198906)
        tdSql.checkData(14, 2, 16.0)
        tdSql.checkData(14, 3, 18.0)
        tdSql.checkData(14, 4, 81.3862943611199)
        tdSql.checkData(14, 5, 528.0)
        tdSql.checkData(14, 6, 52.889224489452616)
        tdSql.checkData(15, 0, 5)
        tdSql.checkData(15, 1, 1.6094379124341003)
        tdSql.checkData(15, 2, 25.0)
        tdSql.checkData(15, 3, 27.0)
        tdSql.checkData(15, 4, 151.6094379124341)
        tdSql.checkData(15, 5, 1422.5424859373686)
        tdSql.checkData(15, 6, 95.3678599195897)
        tdSql.checkData(16, 0, 6)
        tdSql.checkData(16, 1, 1.791759469228055)
        tdSql.checkData(16, 2, 36.0)
        tdSql.checkData(16, 3, 38.0)
        tdSql.checkData(16, 4, 253.79175946922805)
        tdSql.checkData(16, 5, 3210.538706646999)
        tdSql.checkData(16, 6, 156.0308983742497)
        tdSql.checkData(17, 0, 7)
        tdSql.checkData(17, 1, 1.9459101490553132)
        tdSql.checkData(17, 2, 49.0)
        tdSql.checkData(17, 3, 51.0)
        tdSql.checkData(17, 4, 393.9459101490553)
        tdSql.checkData(17, 5, 6401.448897866082)
        tdSql.checkData(17, 6, 237.770130906449)
        tdSql.checkData(18, 0, 8)
        tdSql.checkData(18, 1, 2.0794415416798357)
        tdSql.checkData(18, 2, 64.0)
        tdSql.checkData(18, 3, 66.0)
        tdSql.checkData(18, 4, 578.0794415416798)
        tdSql.checkData(18, 5, 11649.237502960395)
        tdSql.checkData(18, 6, 343.37346669954064)
        tdSql.checkData(19, 0, 9)
        tdSql.checkData(19, 1, 2.1972245773362196)
        tdSql.checkData(19, 2, 81.0)
        tdSql.checkData(19, 3, 83.0)
        tdSql.checkData(19, 4, 812.1972245773362)
        tdSql.checkData(19, 5, 19764.0)
        tdSql.checkData(19, 6, 475.5454239964755)
        tdSql.checkData(20, 0, 10)
        tdSql.checkData(20, 1, 2.302585092994046)
        tdSql.checkData(20, 2, 100.0)
        tdSql.checkData(20, 3, 102.0)
        tdSql.checkData(20, 4, 1102.302585092994)
        tdSql.checkData(20, 5, 31722.776601683792)
        tdSql.checkData(20, 6, 636.9208936206307)
        tdSql.checkData(21, 0, 11)
        tdSql.checkData(21, 1, 2.3978952727983707)
        tdSql.checkData(21, 2, 121.0)
        tdSql.checkData(21, 3, 123.0)
        tdSql.checkData(21, 4, 1454.3978952727985)
        tdSql.checkData(21, 5, 48679.70355559341)
        tdSql.checkData(21, 6, 830.0750695123152)
        tdSql.checkData(22, 0, 12)
        tdSql.checkData(22, 1, 2.4849066497880004)
        tdSql.checkData(22, 2, 144.0)
        tdSql.checkData(22, 3, 146.0)
        tdSql.checkData(22, 4, 1874.484906649788)
        tdSql.checkData(22, 5, 71975.61109149648)
        tdSql.checkData(22, 6, 1057.5309706916078)
        tdSql.checkData(23, 0, 13)
        tdSql.checkData(23, 1, 2.5649493574615367)
        tdSql.checkData(23, 2, 169.0)
        tdSql.checkData(23, 3, 171.0)
        tdSql.checkData(23, 4, 2368.5649493574615)
        tdSql.checkData(23, 5, 103147.149978527)
        tdSql.checkData(23, 6, 1321.765342841202)
        tdSql.checkData(24, 0, 14)
        tdSql.checkData(24, 1, 2.6390573296152584)
        tdSql.checkData(24, 2, 196.0)
        tdSql.checkData(24, 3, 198.0)
        tdSql.checkData(24, 4, 2942.6390573296153)
        tdSql.checkData(24, 5, 143935.51017030774)
        tdSql.checkData(24, 6, 1625.213413896577)
        tdSql.checkData(25, 0, 15)
        tdSql.checkData(25, 1, 2.70805020110221)
        tdSql.checkData(25, 2, 225.0)
        tdSql.checkData(25, 3, 227.0)
        tdSql.checkData(25, 4, 3602.708050201102)
        tdSql.checkData(25, 5, 196294.78190175048)
        tdSql.checkData(25, 6, 1970.2728076392277)
        tdSql.checkData(26, 0, 16)
        tdSql.checkData(26, 1, 2.772588722239781)
        tdSql.checkData(26, 2, 256.0)
        tdSql.checkData(26, 3, 258.0)
        tdSql.checkData(26, 4, 4354.77258872224)
        tdSql.checkData(26, 5, 262400.0)
        tdSql.checkData(26, 6, 2359.306819756166)
        tdSql.checkData(27, 0, 17)
        tdSql.checkData(27, 1, 2.833213344056216)
        tdSql.checkData(27, 2, 289.0)
        tdSql.checkData(27, 3, 291.0)
        tdSql.checkData(27, 4, 5204.833213344056)
        tdSql.checkData(27, 5, 344654.9049572126)
        tdSql.checkData(27, 6, 2794.647199269153)
        tdSql.checkData(28, 0, 18)
        tdSql.checkData(28, 1, 2.8903717578961645)
        tdSql.checkData(28, 2, 324.0)
        tdSql.checkData(28, 3, 326.0)
        tdSql.checkData(28, 4, 6158.890371757896)
        tdSql.checkData(28, 5, 445699.4487710341)
        tdSql.checkData(28, 6, 3278.5965383797334)
        tdSql.checkData(29, 0, 19)
        tdSql.checkData(29, 1, 2.9444389791664403)
        tdSql.checkData(29, 2, 361.0)
        tdSql.checkData(29, 3, 363.0)
        tdSql.checkData(29, 4, 7222.944438979166)
        tdSql.checkData(29, 5, 568417.0692211641)
        tdSql.checkData(29, 6, 3813.4303469855686)

        tdSql.query(
            "select c1, log(c2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1)+log(c3,4)+pow(c6,2.8)+2 as v6 from (select * from ct1 ) order by ts limit 2;;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -1.3862943611198906)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(1, 1, 0.0)
        tdSql.checkData(1, 2, 1.0)
        tdSql.checkData(1, 3, 3.0)
        tdSql.checkData(1, 4, 2.0)
        tdSql.checkData(1, 5, 2.0)
        tdSql.checkData(1, 6, 3.0)

        tdSql.query(
            "select c1, log(c2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1)+log(c3,4)+pow(c6,2.8)+2 as v6 from (select * from ct1 ) limit 2;;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -1.3862943611198906)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(1, 1, 0.0)
        tdSql.checkData(1, 2, 1.0)
        tdSql.checkData(1, 3, 3.0)
        tdSql.checkData(1, 4, 2.0)
        tdSql.checkData(1, 5, 2.0)
        tdSql.checkData(1, 6, 3.0)

        tdSql.query(
            "select * from (select c1, log(c2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1)+log(c3,4)+pow(c6,2.8)+2 as v6, ts from st0 order by ts desc);"
        )
        tdSql.checkRows(30)
        tdSql.checkData(0, 0, 19)
        tdSql.checkData(0, 1, 2.9444389791664403)
        tdSql.checkData(0, 2, 361.0)
        tdSql.checkData(0, 3, 363.0)
        tdSql.checkData(0, 4, 7222.944438979166)
        tdSql.checkData(0, 5, 568417.0692211641)
        tdSql.checkData(0, 6, 3813.4303469855686)
        tdSql.checkData(0, 7, datetime.datetime(2020, 10, 1, 0, 19))
        tdSql.checkData(1, 0, 18)
        tdSql.checkData(1, 1, 2.8903717578961645)
        tdSql.checkData(1, 2, 324.0)
        tdSql.checkData(1, 3, 326.0)
        tdSql.checkData(1, 4, 6158.890371757896)
        tdSql.checkData(1, 5, 445699.4487710341)
        tdSql.checkData(1, 6, 3278.5965383797334)
        tdSql.checkData(1, 7, datetime.datetime(2020, 10, 1, 0, 18))
        tdSql.checkData(2, 0, 17)
        tdSql.checkData(2, 1, 2.833213344056216)
        tdSql.checkData(2, 2, 289.0)
        tdSql.checkData(2, 3, 291.0)
        tdSql.checkData(2, 4, 5204.833213344056)
        tdSql.checkData(2, 5, 344654.9049572126)
        tdSql.checkData(2, 6, 2794.647199269153)
        tdSql.checkData(2, 7, datetime.datetime(2020, 10, 1, 0, 17))
        tdSql.checkData(3, 0, 16)
        tdSql.checkData(3, 1, 2.772588722239781)
        tdSql.checkData(3, 2, 256.0)
        tdSql.checkData(3, 3, 258.0)
        tdSql.checkData(3, 4, 4354.77258872224)
        tdSql.checkData(3, 5, 262400.0)
        tdSql.checkData(3, 6, 2359.306819756166)
        tdSql.checkData(3, 7, datetime.datetime(2020, 10, 1, 0, 16))
        tdSql.checkData(4, 0, 15)
        tdSql.checkData(4, 1, 2.70805020110221)
        tdSql.checkData(4, 2, 225.0)
        tdSql.checkData(4, 3, 227.0)
        tdSql.checkData(4, 4, 3602.708050201102)
        tdSql.checkData(4, 5, 196294.78190175048)
        tdSql.checkData(4, 6, 1970.2728076392277)
        tdSql.checkData(4, 7, datetime.datetime(2020, 10, 1, 0, 15))
        tdSql.checkData(5, 0, 14)
        tdSql.checkData(5, 1, 2.6390573296152584)
        tdSql.checkData(5, 2, 196.0)
        tdSql.checkData(5, 3, 198.0)
        tdSql.checkData(5, 4, 2942.6390573296153)
        tdSql.checkData(5, 5, 143935.51017030774)
        tdSql.checkData(5, 6, 1625.213413896577)
        tdSql.checkData(5, 7, datetime.datetime(2020, 10, 1, 0, 14))
        tdSql.checkData(6, 0, 13)
        tdSql.checkData(6, 1, 2.5649493574615367)
        tdSql.checkData(6, 2, 169.0)
        tdSql.checkData(6, 3, 171.0)
        tdSql.checkData(6, 4, 2368.5649493574615)
        tdSql.checkData(6, 5, 103147.149978527)
        tdSql.checkData(6, 6, 1321.765342841202)
        tdSql.checkData(6, 7, datetime.datetime(2020, 10, 1, 0, 13))
        tdSql.checkData(7, 0, 12)
        tdSql.checkData(7, 1, 2.4849066497880004)
        tdSql.checkData(7, 2, 144.0)
        tdSql.checkData(7, 3, 146.0)
        tdSql.checkData(7, 4, 1874.484906649788)
        tdSql.checkData(7, 5, 71975.61109149648)
        tdSql.checkData(7, 6, 1057.5309706916078)
        tdSql.checkData(7, 7, datetime.datetime(2020, 10, 1, 0, 12))
        tdSql.checkData(8, 0, 11)
        tdSql.checkData(8, 1, 2.3978952727983707)
        tdSql.checkData(8, 2, 121.0)
        tdSql.checkData(8, 3, 123.0)
        tdSql.checkData(8, 4, 1454.3978952727985)
        tdSql.checkData(8, 5, 48679.70355559341)
        tdSql.checkData(8, 6, 830.0750695123152)
        tdSql.checkData(8, 7, datetime.datetime(2020, 10, 1, 0, 11))
        tdSql.checkData(9, 0, 10)
        tdSql.checkData(9, 1, 2.302585092994046)
        tdSql.checkData(9, 2, 100.0)
        tdSql.checkData(9, 3, 102.0)
        tdSql.checkData(9, 4, 1102.302585092994)
        tdSql.checkData(9, 5, 31722.776601683792)
        tdSql.checkData(9, 6, 636.9208936206307)
        tdSql.checkData(9, 7, datetime.datetime(2020, 10, 1, 0, 10))
        tdSql.checkData(10, 0, 9)
        tdSql.checkData(10, 1, 2.1972245773362196)
        tdSql.checkData(10, 2, 81.0)
        tdSql.checkData(10, 3, 83.0)
        tdSql.checkData(10, 4, 812.1972245773362)
        tdSql.checkData(10, 5, 19764.0)
        tdSql.checkData(10, 6, 475.5454239964755)
        tdSql.checkData(10, 7, datetime.datetime(2020, 10, 1, 0, 9))
        tdSql.checkData(11, 0, 9)
        tdSql.checkData(11, 1, 2.1972245773362196)
        tdSql.checkData(11, 2, 81.0)
        tdSql.checkData(11, 3, 83.0)
        tdSql.checkData(11, 4, 812.1972245773362)
        tdSql.checkData(11, 5, 19764.0)
        tdSql.checkData(11, 6, 475.5454239964755)
        tdSql.checkData(11, 7, datetime.datetime(2020, 10, 1, 0, 9))
        tdSql.checkData(12, 0, 8)
        tdSql.checkData(12, 1, 2.0794415416798357)
        tdSql.checkData(12, 2, 64.0)
        tdSql.checkData(12, 3, 66.0)
        tdSql.checkData(12, 4, 578.0794415416798)
        tdSql.checkData(12, 5, 11649.237502960395)
        tdSql.checkData(12, 6, 343.37346669954064)
        tdSql.checkData(12, 7, datetime.datetime(2020, 10, 1, 0, 8))
        tdSql.checkData(13, 0, 8)
        tdSql.checkData(13, 1, 2.0794415416798357)
        tdSql.checkData(13, 2, 64.0)
        tdSql.checkData(13, 3, 66.0)
        tdSql.checkData(13, 4, 578.0794415416798)
        tdSql.checkData(13, 5, 11649.237502960395)
        tdSql.checkData(13, 6, 343.37346669954064)
        tdSql.checkData(13, 7, datetime.datetime(2020, 10, 1, 0, 8))
        tdSql.checkData(14, 0, 7)
        tdSql.checkData(14, 1, 1.9459101490553132)
        tdSql.checkData(14, 2, 49.0)
        tdSql.checkData(14, 3, 51.0)
        tdSql.checkData(14, 4, 393.9459101490553)
        tdSql.checkData(14, 5, 6401.448897866082)
        tdSql.checkData(14, 6, 237.770130906449)
        tdSql.checkData(14, 7, datetime.datetime(2020, 10, 1, 0, 7))
        tdSql.checkData(15, 0, 7)
        tdSql.checkData(15, 1, 1.9459101490553132)
        tdSql.checkData(15, 2, 49.0)
        tdSql.checkData(15, 3, 51.0)
        tdSql.checkData(15, 4, 393.9459101490553)
        tdSql.checkData(15, 5, 6401.448897866082)
        tdSql.checkData(15, 6, 237.770130906449)
        tdSql.checkData(15, 7, datetime.datetime(2020, 10, 1, 0, 7))
        tdSql.checkData(16, 0, 6)
        tdSql.checkData(16, 1, 1.791759469228055)
        tdSql.checkData(16, 2, 36.0)
        tdSql.checkData(16, 3, 38.0)
        tdSql.checkData(16, 4, 253.79175946922805)
        tdSql.checkData(16, 5, 3210.538706646999)
        tdSql.checkData(16, 6, 156.0308983742497)
        tdSql.checkData(16, 7, datetime.datetime(2020, 10, 1, 0, 6))
        tdSql.checkData(17, 0, 6)
        tdSql.checkData(17, 1, 1.791759469228055)
        tdSql.checkData(17, 2, 36.0)
        tdSql.checkData(17, 3, 38.0)
        tdSql.checkData(17, 4, 253.79175946922805)
        tdSql.checkData(17, 5, 3210.538706646999)
        tdSql.checkData(17, 6, 156.0308983742497)
        tdSql.checkData(17, 7, datetime.datetime(2020, 10, 1, 0, 6))
        tdSql.checkData(18, 0, 5)
        tdSql.checkData(18, 1, 1.6094379124341003)
        tdSql.checkData(18, 2, 25.0)
        tdSql.checkData(18, 3, 27.0)
        tdSql.checkData(18, 4, 151.6094379124341)
        tdSql.checkData(18, 5, 1422.5424859373686)
        tdSql.checkData(18, 6, 95.3678599195897)
        tdSql.checkData(18, 7, datetime.datetime(2020, 10, 1, 0, 5))
        tdSql.checkData(19, 0, 5)
        tdSql.checkData(19, 1, 1.6094379124341003)
        tdSql.checkData(19, 2, 25.0)
        tdSql.checkData(19, 3, 27.0)
        tdSql.checkData(19, 4, 151.6094379124341)
        tdSql.checkData(19, 5, 1422.5424859373686)
        tdSql.checkData(19, 6, 95.3678599195897)
        tdSql.checkData(19, 7, datetime.datetime(2020, 10, 1, 0, 5))
        tdSql.checkData(20, 0, 4)
        tdSql.checkData(20, 1, 1.3862943611198906)
        tdSql.checkData(20, 2, 16.0)
        tdSql.checkData(20, 3, 18.0)
        tdSql.checkData(20, 4, 81.3862943611199)
        tdSql.checkData(20, 5, 528.0)
        tdSql.checkData(20, 6, 52.889224489452616)
        tdSql.checkData(20, 7, datetime.datetime(2020, 10, 1, 0, 4))
        tdSql.checkData(21, 0, 4)
        tdSql.checkData(21, 1, 1.3862943611198906)
        tdSql.checkData(21, 2, 16.0)
        tdSql.checkData(21, 3, 18.0)
        tdSql.checkData(21, 4, 81.3862943611199)
        tdSql.checkData(21, 5, 528.0)
        tdSql.checkData(21, 6, 52.889224489452616)
        tdSql.checkData(21, 7, datetime.datetime(2020, 10, 1, 0, 4))
        tdSql.checkData(22, 0, 3)
        tdSql.checkData(22, 1, 1.0986122886681098)
        tdSql.checkData(22, 2, 9.0)
        tdSql.checkData(22, 3, 11.0)
        tdSql.checkData(22, 4, 37.09861228866811)
        tdSql.checkData(22, 5, 149.29611541307906)
        tdSql.checkData(22, 6, 25.565115706554913)
        tdSql.checkData(22, 7, datetime.datetime(2020, 10, 1, 0, 3))
        tdSql.checkData(23, 0, 3)
        tdSql.checkData(23, 1, 1.0986122886681098)
        tdSql.checkData(23, 2, 9.0)
        tdSql.checkData(23, 3, 11.0)
        tdSql.checkData(23, 4, 37.09861228866811)
        tdSql.checkData(23, 5, 149.29611541307906)
        tdSql.checkData(23, 6, 25.565115706554913)
        tdSql.checkData(23, 7, datetime.datetime(2020, 10, 1, 0, 3))
        tdSql.checkData(24, 0, 2)
        tdSql.checkData(24, 1, 0.6931471805599453)
        tdSql.checkData(24, 2, 4.0)
        tdSql.checkData(24, 3, 6.0)
        tdSql.checkData(24, 4, 12.693147180559945)
        tdSql.checkData(24, 5, 26.627416997969522)
        tdSql.checkData(24, 6, 10.157551686928937)
        tdSql.checkData(24, 7, datetime.datetime(2020, 10, 1, 0, 2))
        tdSql.checkData(25, 0, 2)
        tdSql.checkData(25, 1, 0.6931471805599453)
        tdSql.checkData(25, 2, 4.0)
        tdSql.checkData(25, 3, 6.0)
        tdSql.checkData(25, 4, 12.693147180559945)
        tdSql.checkData(25, 5, 26.627416997969522)
        tdSql.checkData(25, 6, 10.157551686928937)
        tdSql.checkData(25, 7, datetime.datetime(2020, 10, 1, 0, 2))
        tdSql.checkData(26, 0, 1)
        tdSql.checkData(26, 1, 0.0)
        tdSql.checkData(26, 2, 1.0)
        tdSql.checkData(26, 3, 3.0)
        tdSql.checkData(26, 4, 2.0)
        tdSql.checkData(26, 5, 2.0)
        tdSql.checkData(26, 6, 3.0)
        tdSql.checkData(26, 7, datetime.datetime(2020, 10, 1, 0, 1))
        tdSql.checkData(27, 0, 1)
        tdSql.checkData(27, 1, 0.0)
        tdSql.checkData(27, 2, 1.0)
        tdSql.checkData(27, 3, 3.0)
        tdSql.checkData(27, 4, 2.0)
        tdSql.checkData(27, 5, 2.0)
        tdSql.checkData(27, 6, 3.0)
        tdSql.checkData(27, 7, datetime.datetime(2020, 10, 1, 0, 1))
        tdSql.checkData(28, 0, 0)
        tdSql.checkData(28, 1, -1.3862943611198906)
        tdSql.checkData(28, 2, 0.0)
        tdSql.checkData(28, 3, 2.0625)
        tdSql.checkData(28, 4, -inf)
        tdSql.checkData(28, 5, 0.0)
        tdSql.checkData(28, 6, -inf)
        tdSql.checkData(28, 7, datetime.datetime(2020, 10, 1, 0, 0))
        tdSql.checkData(29, 0, 0)
        tdSql.checkData(29, 1, -1.3862943611198906)
        tdSql.checkData(29, 2, 0.0)
        tdSql.checkData(29, 3, 2.0625)
        tdSql.checkData(29, 4, -inf)
        tdSql.checkData(29, 5, 0.0)
        tdSql.checkData(29, 6, -inf)
        tdSql.checkData(29, 7, datetime.datetime(2020, 10, 1, 0, 0))

        tdSql.query(
            "select * from (select c1, log(c2), pow(c1,2), pow(c2,2)+2, pow(c2,3)+log(c3)+pow(c5,2) as v4, pow(c4, 4.5)+pow(c3, 2), log(c1)+log(c3,4)+pow(c6,2.8)+2 as v6, ts from ct1 order by ts limit 2);;"
        )
        tdSql.checkRows(2)
        tdSql.checkData(0, 0, 0)
        tdSql.checkData(0, 1, -1.3862943611198906)
        tdSql.checkData(0, 2, 0.0)
        tdSql.checkData(0, 3, 2.0625)
        tdSql.checkData(0, 4, -inf)
        tdSql.checkData(0, 5, 0.0)
        tdSql.checkData(0, 6, -inf)
        tdSql.checkData(0, 7, datetime.datetime(2020, 10, 1, 0, 0))
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(1, 1, 0.0)
        tdSql.checkData(1, 2, 1.0)
        tdSql.checkData(1, 3, 3.0)
        tdSql.checkData(1, 4, 2.0)
        tdSql.checkData(1, 5, 2.0)
        tdSql.checkData(1, 6, 3.0)
        tdSql.checkData(1, 7, datetime.datetime(2020, 10, 1, 0, 1))

        tdSql.execute("drop database db0")

    def stop(self):
        tdSql.close()
        tdLog.success("%s successfully executed" % __file__)


tdCases.addWindows(__file__, TDTestCase())
tdCases.addLinux(__file__, TDTestCase())
