/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 448
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  bool yy89;
  EFillMode yy102;
  SNodeList* yy152;
  int64_t yy221;
  EOperatorType yy380;
  EOrder yy386;
  int8_t yy439;
  int32_t yy452;
  ENullOrder yy585;
  EJoinType yy596;
  SNode* yy616;
  SAlterOption yy669;
  SToken yy673;
  SDataType yy784;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             689
#define YYNRULE              519
#define YYNTOKEN             316
#define YY_MAX_SHIFT         688
#define YY_MIN_SHIFTREDUCE   1017
#define YY_MAX_SHIFTREDUCE   1535
#define YY_ERROR_ACTION      1536
#define YY_ACCEPT_ACTION     1537
#define YY_NO_ACTION         1538
#define YY_MIN_REDUCE        1539
#define YY_MAX_REDUCE        2057
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (3046)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1860, 1789,  443, 1860,  444, 1574,  451, 1874,  444, 1574,
 /*    10 */  1677, 1856,   44,   42, 1856,  351,  540, 1675, 1731, 1733,
 /*    20 */   346, 1856, 1317,   43,   41,   40,   39,   38,   52, 2033,
 /*    30 */    40,   39,   38, 1396, 1050, 1315, 1892, 1852, 1858,  334,
 /*    40 */  1852, 1858,  340, 1343,  582, 1686, 1344, 1852, 1858, 1842,
 /*    50 */   588,  594,   30,  588,  442,  581, 1391,  446,   37,   36,
 /*    60 */   588,   17,   43,   41,   40,   39,   38, 1874, 1323,   44,
 /*    70 */    42, 1466, 1872, 1130, 1054, 1055, 1907,  346,  566, 1317,
 /*    80 */    97, 1873, 1875,  598, 1877, 1878,  593, 1067,  588, 1066,
 /*    90 */  1396, 1562, 1315,  167,    1, 1960, 1892, 1732, 1733,  339,
 /*   100 */  1956,   77,  479, 1738,  595,  578, 1132, 2028, 1470, 1842,
 /*   110 */   333,  594,  172, 1391, 1342,  125,  685, 1068,   17, 1736,
 /*   120 */  1986, 1525,  565,  170, 1681, 1323, 1663, 2029,  567,   46,
 /*   130 */  1398, 1399,  596, 1842,  132,   62, 1907, 1540, 1561,  225,
 /*   140 */    98,  345, 1875,  598, 1877, 1878,  593, 1975,  588, 1892,
 /*   150 */    87,    1,  581, 1212, 1213, 1960,   58,  560,  109,  312,
 /*   160 */  1956,  108,  107,  106,  105,  104,  103,  102,  101,  100,
 /*   170 */  2028,  130, 1679,  685,  527, 1972, 1318,   58, 1316,   81,
 /*   180 */  1842,  331,   34,  265, 1786,  565,  170, 1398, 1399,  264,
 /*   190 */  2029,  567,  580,  168, 1968, 1969,  559, 1973,  556,  450,
 /*   200 */  1321, 1322,  446, 1372, 1373, 1375, 1376, 1377, 1378, 1379,
 /*   210 */  1380, 1381,  590,  586, 1389, 1390, 1392, 1393, 1394, 1395,
 /*   220 */  1397, 1400,    3,  581,  203,   58,   46,   94, 1427,  155,
 /*   230 */   578, 1551,  629, 1318, 1342, 1316,   58,  384,  160,  383,
 /*   240 */   173,  127, 1492,  477,  473,  469,  465,  202,  428, 1678,
 /*   250 */   448,  144,  143,  626,  625,  624, 1340, 1321, 1322,  132,
 /*   260 */  1372, 1373, 1375, 1376, 1377, 1378, 1379, 1380, 1381,  590,
 /*   270 */   586, 1389, 1390, 1392, 1393, 1394, 1395, 1397, 1400,    3,
 /*   280 */    44,   42,  562,  557,   78,  490,  489,  200,  346, 1861,
 /*   290 */  1317,  553, 1490, 1491, 1493, 1494,  130,   31, 1374,  578,
 /*   300 */  1856, 1396,  173, 1315,  183,  182,  109, 1432,   58,  108,
 /*   310 */   107,  106,  105,  104,  103,  102,  101,  100,  169, 1968,
 /*   320 */  1969,  629, 1973,  173, 1391,  460, 1852, 1858,  132,   17,
 /*   330 */  2033,   11, 1874,    9,  540,  380, 1323,   44,   42,  588,
 /*   340 */   144,  143,  626,  625,  624,  346,  175, 1317,  578,  158,
 /*   350 */   199,  193,   47,  198, 1643,  382,  378,  456, 1396, 2028,
 /*   360 */  1315, 1892,    1, 1686, 1343,  130,  540, 2033,  542,  582,
 /*   370 */  1932,  173,  173,  191, 1842, 2032,  594,  132,  119, 2029,
 /*   380 */  2031, 1391,  173,  391,  685,  481,   17,  171, 1968, 1969,
 /*   390 */   217, 1973, 1067, 1323, 1066, 1686, 2028, 1872, 1398, 1399,
 /*   400 */  1342, 1907, 1539,  231,  232,   97, 1873, 1875,  598, 1877,
 /*   410 */  1878,  593, 2032,  588,  121,  561, 2029, 2030,  167,    1,
 /*   420 */  1960,  308, 1068,  540,  339, 1956,  118,  117,  116,  115,
 /*   430 */   114,  113,  112,  111,  110,  119,  262, 1968,  577, 1975,
 /*   440 */   576,  685,  486, 2028, 1318, 1987, 1316,   79,  310,  631,
 /*   450 */  1738,  530, 1686, 1341,  173, 1398, 1399,  350,  565,  170,
 /*   460 */    13,   12,  310, 2029,  567,  530, 1736, 1971, 1321, 1322,
 /*   470 */  1661, 1372, 1373, 1375, 1376, 1377, 1378, 1379, 1380, 1381,
 /*   480 */   590,  586, 1389, 1390, 1392, 1393, 1394, 1395, 1397, 1400,
 /*   490 */     3,  230,   11, 1406,  544, 1537, 1932,  322,  173, 1342,
 /*   500 */    77, 1318, 1785, 1316,  305, 1170,  620,  619,  618, 1174,
 /*   510 */   617, 1176, 1177,  616, 1179,  613,  142, 1185,  610, 1187,
 /*   520 */  1188,  607,  604, 1682,  623, 1321, 1322,  179, 1372, 1373,
 /*   530 */  1375, 1376, 1377, 1378, 1379, 1380, 1381,  590,  586, 1389,
 /*   540 */  1390, 1392, 1393, 1394, 1395, 1397, 1400,    3,   44,   42,
 /*   550 */   392, 1295, 1296,  332, 1439,  361,  346,  323, 1317,  321,
 /*   560 */   320,  153,  483,  393,   74,  540,  485,   73,   51, 1396,
 /*   570 */  1688, 1315,  523, 1664,  385, 1975,  629,  389,   37,   36,
 /*   580 */   166, 1874,   43,   41,   40,   39,   38, 1344,  484,   11,
 /*   590 */  1345,  523, 1391, 1725, 1686,  144,  143,  626,  625,  624,
 /*   600 */  1874, 2028,  540, 1970, 1323,   44,   42, 1401,  656,  654,
 /*   610 */  1892, 1560, 1323,  346,  390, 1317, 2034,  170,  595,  643,
 /*   620 */  2028, 2029,  567, 1842,  224,  594, 1396, 1738, 1315, 1892,
 /*   630 */     8, 1686,  507,  460,  317, 2034,  170,  595, 2032,  540,
 /*   640 */  2029,  567, 1842, 1736,  594,  505,  596,  503, 1662, 1391,
 /*   650 */  1907,  398,  685, 1842,  292,  345, 1875,  598, 1877, 1878,
 /*   660 */   593, 1323,  588,  349,   80, 1872, 1398, 1399, 1686, 1907,
 /*   670 */  1671,  153,  566,   97, 1873, 1875,  598, 1877, 1878,  593,
 /*   680 */  1688,  588,  218, 1374, 2028, 1716, 2048,    8, 1960, 1559,
 /*   690 */    37,   36,  339, 1956,   43,   41,   40,   39,   38,  565,
 /*   700 */   170, 2028, 1994,  540, 2029,  567,  540,   45,  631,  685,
 /*   710 */   527, 1784, 1318,  305, 1316,  413,  565,  170,  414, 1552,
 /*   720 */  1787, 2029,  567, 1398, 1399,  153,  627, 1779, 1558, 1729,
 /*   730 */   264, 1842, 1686,  241, 1689, 1686, 1321, 1322,  178, 1372,
 /*   740 */  1373, 1375, 1376, 1377, 1378, 1379, 1380, 1381,  590,  586,
 /*   750 */  1389, 1390, 1392, 1393, 1394, 1395, 1397, 1400,    3, 1266,
 /*   760 */    37,   36,  540,  540,   43,   41,   40,   39,   38, 1318,
 /*   770 */  1842, 1316,  352, 1673,  458,  459,  173, 1502,   37,   36,
 /*   780 */   153, 1557,   43,   41,   40,   39,   38,  128, 1556, 1688,
 /*   790 */  1931, 1686, 1686, 1321, 1322,   26, 1372, 1373, 1375, 1376,
 /*   800 */  1377, 1378, 1379, 1380, 1381,  590,  586, 1389, 1390, 1392,
 /*   810 */  1393, 1394, 1395, 1397, 1400,    3,   44,   42,  526, 1317,
 /*   820 */  1779, 1555, 1738, 1842,  346,  628, 1317, 1554, 1729, 2033,
 /*   830 */  1842,  181, 1315,  540, 1553,  523, 1669, 1396, 1737, 1315,
 /*   840 */    32,  359, 1054, 1055,  485, 1683,   37,   36, 1550, 1874,
 /*   850 */    43,   41,   40,   39,   38,  644,    7, 1656,  523,  540,
 /*   860 */  1391, 1463, 1686, 1842, 2028, 1323,  484, 1549, 1874, 1842,
 /*   870 */   540,  136, 1323,   44,   42,  570, 1842,  540, 1892, 2034,
 /*   880 */   170,  346,  519, 1317, 2029,  567,  595, 2028, 1686,  524,
 /*   890 */  1842, 1842,  569,  594, 1396, 1345, 1315, 1892,    8, 1686,
 /*   900 */   518,  277, 2034,  170, 1716,  595, 1686, 2029,  567, 1842,
 /*   910 */  1842, 1342,  594,  685, 1872, 1829, 1548, 1391, 1907,  540,
 /*   920 */   685, 1525,  156, 1873, 1875,  598, 1877, 1878,  593, 1323,
 /*   930 */   588,  235,  221, 1872, 1398, 1399, 1547, 1907, 1532,   48,
 /*   940 */     4,   97, 1873, 1875,  598, 1877, 1878,  593, 1686,  588,
 /*   950 */   493,  492, 1546,  585, 2048,    1, 1960,  126, 1842, 1591,
 /*   960 */   339, 1956,  368,  545, 1997, 1980, 1459,  540,  488,  491,
 /*   970 */  2022, 1604,  540, 1318,  487, 1316, 1326,  685, 1842,  536,
 /*   980 */  1318,  494, 1316,  358,  538, 1545,  208,  210, 1544,  206,
 /*   990 */   209, 1398, 1399,  589, 1842,  229, 1686, 1321, 1322, 1543,
 /*  1000 */   523, 1686,   50,  522, 1321, 1322, 1542, 1372, 1373, 1375,
 /*  1010 */  1376, 1377, 1378, 1379, 1380, 1381,  590,  586, 1389, 1390,
 /*  1020 */  1392, 1393, 1394, 1395, 1397, 1400,    3, 1842,  540, 2028,
 /*  1030 */  1842,  540, 1531, 1534, 1535,  493,  492, 1318,  240, 1316,
 /*  1040 */   539, 1842,  126,  266, 2034,  170,  573,  233, 1842, 2029,
 /*  1050 */   567,  622,  137,  488,  491,  212, 1459, 1686,  211,  487,
 /*  1060 */  1686, 1321, 1322, 1601, 1372, 1373, 1375, 1376, 1377, 1378,
 /*  1070 */  1379, 1380, 1381,  590,  586, 1389, 1390, 1392, 1393, 1394,
 /*  1080 */  1395, 1397, 1400,    3,  307,  540, 1340,  214,   13,   12,
 /*  1090 */   213,  571, 1417,  421, 1325, 1374,  433,  353, 1462, 1586,
 /*  1100 */  1584,   93,   37,   36,  533, 2000,   43,   41,   40,   39,
 /*  1110 */    38,   90, 1644,  406, 1686,  434,  141,  408,  142, 1329,
 /*  1120 */    60,  496,  499,  259,  245,   60,  662,  661,  660,  659,
 /*  1130 */   356,   45,  658,  657,  133,  652,  651,  650,  649,  648,
 /*  1140 */   647,  646,  645,  146,  641,  640,  639,  355,  354,  636,
 /*  1150 */   635,  634,  633,  632,  554,  154,  478,   37,   36,  399,
 /*  1160 */   283,   43,   41,   40,   39,   38,  253, 1094,  237,  637,
 /*  1170 */  1163,  395, 1489,   45,  281,   66,  248, 1433,   65, 1863,
 /*  1180 */    37,   36, 1893, 1382,   43,   41,   40,   39,   38, 1482,
 /*  1190 */   602, 1114,  357, 1575,  187,  439,  437,  141, 1990,  432,
 /*  1200 */  1095, 1874,  427,  426,  425,  424,  423,  420,  419,  418,
 /*  1210 */   417,  416,  412,  411,  410,  409,  403,  402,  401,  400,
 /*  1220 */   142,  397,  396,  319,  638,  276, 1726, 1865,   37,   36,
 /*  1230 */  1892,   58,   43,   41,   40,   39,   38, 1328,  595,  122,
 /*  1240 */   141,  579, 1191, 1842,  261,  594, 1112, 1580,  258, 1195,
 /*  1250 */     2,  362,    5,  367,  318,  273,  180, 1282,  394, 1340,
 /*  1260 */   415, 1781,  422,  430,  574,  429, 1872,  431,  435,   96,
 /*  1270 */  1907,  436, 1202,  184,   97, 1873, 1875,  598, 1877, 1878,
 /*  1280 */   593,  313,  588,  438, 1346,  129,  441,  140, 1931, 1960,
 /*  1290 */   440, 1200,  145,  339, 1956,  680,  449, 1348,  452,  190,
 /*  1300 */   511,  192,  453, 1347,  454,   71,   70,  388, 1349,  455,
 /*  1310 */   177, 1874,  152,  195,  197,  457,  498,  523,   75,   76,
 /*  1320 */   461,  201,  480, 1425,  482, 1676,  205,  306, 1672,  207,
 /*  1330 */   376,  508,  374,  370,  366,  363,  360,  309,  120,  147,
 /*  1340 */  1892,  510,  148, 1674, 1670,  216, 2028,  149,  595,  512,
 /*  1350 */   150,  274,  219, 1842,  513,  594,  222,  520, 1820,  501,
 /*  1360 */   514, 2034,  170,  495,  525,  226, 2029,  567,  215,  517,
 /*  1370 */   552,  138,  534,  328,  528, 1819, 1872,  173, 1426, 1791,
 /*  1380 */  1907,  531,  330,  139,   97, 1873, 1875,  598, 1877, 1878,
 /*  1390 */   593,  535,  588, 1874,   84,  275,   86, 2048, 1687, 1960,
 /*  1400 */  1345,  548, 2006,  339, 1956,   64, 1991,  555,   63,  243,
 /*  1410 */  2001,  550, 2005, 1979,  551,  247,  335,  558,    6,  564,
 /*  1420 */   336,  549, 1892,  547,  546,  257,  575, 2027,  572, 1459,
 /*  1430 */   595, 1344, 2051,  256,  252, 1842, 1982,  594, 1976,   57,
 /*  1440 */   131, 1941,   88,  600, 1657,  161, 1874,   33,  343, 1420,
 /*  1450 */  1421, 1422, 1423, 1424, 1428, 1429, 1430, 1431, 1872,  254,
 /*  1460 */   255,  278, 1907, 1730,  260,  269,   97, 1873, 1875,  598,
 /*  1470 */  1877, 1878,  593,  681,  588, 1892,   49,  682,  304, 1935,
 /*  1480 */   290, 1960,  684,  595,  301,  339, 1956,  300, 1842, 1836,
 /*  1490 */   594,  282,  280, 1835,   68, 1834, 1833,   69, 1830,  364,
 /*  1500 */   365, 1309, 1310,  176,  369, 1828,  371,  372,  373, 1827,
 /*  1510 */   375, 1872, 1826,  377, 1874, 1907, 1825, 1824,  381,   97,
 /*  1520 */  1873, 1875,  598, 1877, 1878,  593,  379,  588, 1285, 1284,
 /*  1530 */  1802, 1801, 1933,  386, 1960,  387, 1874, 1800,  339, 1956,
 /*  1540 */   342,  341, 1799, 1892,  134, 1254, 1774, 1773, 1772, 1771,
 /*  1550 */  1331,  595, 1770, 1769,   72, 1768, 1842, 1767,  594, 1766,
 /*  1560 */  1765, 1396, 1764, 1324,  404, 1892, 1763,  405,  407, 1762,
 /*  1570 */  1761, 1760, 1759,  595, 1758, 1757, 1756, 1755, 1842, 1872,
 /*  1580 */   594, 1754, 1753, 1907, 1391, 1752, 1751,   97, 1873, 1875,
 /*  1590 */   598, 1877, 1878,  593, 1874,  588, 1323, 1750, 1749, 1748,
 /*  1600 */   543, 1872, 1960,  135, 1747, 1907,  339, 1956, 1746,   98,
 /*  1610 */  1873, 1875,  598, 1877, 1878,  593, 1745,  588, 1744, 1743,
 /*  1620 */   688, 1742, 1256, 1892, 1960, 1741, 1740, 1739, 1959, 1956,
 /*  1630 */  1606,  595, 1605, 1603,  272,  185, 1842, 1138,  594,  186,
 /*  1640 */  1571, 1570, 1057, 1056,  584,  188,  123, 1815,  164,  165,
 /*  1650 */   189,  445,  124,  678,  674,  670,  666,  270, 1809, 1872,
 /*  1660 */   447, 1798,  194, 1907,  196, 1797, 1783,   98, 1873, 1875,
 /*  1670 */   598, 1877, 1878,  593, 1665,  588, 1602, 1087, 1600,  462,
 /*  1680 */  1598,  463, 1960,  466,  464,  467,  583, 1956,  468, 1596,
 /*  1690 */   470,  472, 1594,  471,   95,  474, 1874,  238,  475, 1583,
 /*  1700 */  1582,  476, 1567, 1667, 1332, 1206, 1327, 1205, 1666, 1123,
 /*  1710 */  1129,  653,   59, 1592, 1128,  655, 1125, 1124,  204, 1587,
 /*  1720 */   324, 1585,  497,  325, 1566, 1892,  326, 1565, 1335, 1337,
 /*  1730 */   537,  500, 1564,  592,  506, 1814,   99, 1301, 1842, 1808,
 /*  1740 */   594,  586, 1389, 1390, 1392, 1393, 1394, 1395,   25,  502,
 /*  1750 */   504,   53, 1291,  515,  516, 1874,  223,  151, 1796, 1794,
 /*  1760 */  2033, 1872, 1795,  227, 1793, 1907, 1792, 1790, 1299,  298,
 /*  1770 */  1873, 1875,  598, 1877, 1878,  593,  591,  588,  541, 1925,
 /*  1780 */    18, 1289,  529,  220, 1892,  327,  228,  234,   82,  521,
 /*  1790 */  1782,   83,  595,  239,   90,  236,  532, 1842,   19,  594,
 /*  1800 */    85,   27,   15, 1408,   20, 1504,  244,   21,   56,   10,
 /*  1810 */  1874,  250, 1407, 1486,  242,  251,  246, 1863, 1488,  159,
 /*  1820 */  1872, 1481,  249,   28, 1907,   29,   61,   22,  157, 1873,
 /*  1830 */  1875,  598, 1877, 1878,  593,   89,  588, 1524, 1525, 1892,
 /*  1840 */  1519, 1518,  337, 1523, 1522,  338, 1456,  595, 1455,  263,
 /*  1850 */  1862,   12, 1842, 1418,  594,   16,   55, 1333,   54, 1365,
 /*  1860 */   162,  163,  174, 1874, 1910,  597, 1169, 1386,  587,  601,
 /*  1870 */  1384,   35, 1184, 1383,   14, 1872, 1357,   23,  599, 1907,
 /*  1880 */   568, 2049,   24,   98, 1873, 1875,  598, 1877, 1878,  593,
 /*  1890 */  1192,  588, 1892,  348,  603,  605, 1189,  329, 1960,  608,
 /*  1900 */   595,  611,  621, 1957,  614, 1842,  606,  594, 1201, 1183,
 /*  1910 */  1182, 1181, 1186,  609, 1874, 1180,  612,  267, 1197, 1178,
 /*  1920 */   615,   91,   92,   67, 1085, 1120,  630, 1119, 1872, 1118,
 /*  1930 */  1117, 1874, 1907, 1116,  642, 1115,  299, 1873, 1875,  598,
 /*  1940 */  1877, 1878,  593, 1892,  588, 1113, 1111, 1110, 1109, 1136,
 /*  1950 */   268,  592, 1107, 1106, 1105, 1104, 1842, 1103,  594, 1102,
 /*  1960 */  1892, 1101, 1100, 1131, 1097, 1133, 1096, 1091,  595, 1093,
 /*  1970 */  1599, 1092, 1090, 1842,  663,  594, 1597,  664,  667, 1872,
 /*  1980 */   665, 1595, 1593, 1907,  671,  668,  669,  298, 1873, 1875,
 /*  1990 */   598, 1877, 1878,  593,  673,  588, 1872, 1926,  672,  675,
 /*  2000 */  1907,  676,  677, 1581,  156, 1873, 1875,  598, 1877, 1878,
 /*  2010 */   593, 1563,  588,  679, 1047,  683, 1874,  271, 1319,  279,
 /*  2020 */   686,  687, 1538, 1538, 1538, 1538, 1538, 1538, 1538, 1538,
 /*  2030 */  1538, 1538, 1538, 1538, 1538, 1538, 1538, 1538, 1538, 1538,
 /*  2040 */  1538, 1538, 1538, 1538, 1538, 1892, 1998, 1538, 1538, 1538,
 /*  2050 */  1538, 1538, 1538,  595, 1538, 1538, 1538, 1538, 1842, 1538,
 /*  2060 */   594, 1538, 1538, 1538, 1538, 1538, 1538, 1874, 1538, 1538,
 /*  2070 */  1538, 1538, 1538, 1538, 1538, 1538, 1538, 1538, 1538, 1538,
 /*  2080 */  1538, 1872, 1538, 1538, 1538, 1907, 1538, 1538, 1538,  294,
 /*  2090 */  1873, 1875,  598, 1877, 1878,  593, 1892,  588, 1538, 1538,
 /*  2100 */  1538, 1538, 1538, 1538,  595, 1538, 1538, 1538, 1538, 1842,
 /*  2110 */  1538,  594, 1538, 1538, 1538, 1538, 1538, 1538, 1538, 1538,
 /*  2120 */  1538, 1538, 1538, 1538, 1538, 1538, 1538, 1538, 1538, 1538,
 /*  2130 */  1874, 1538, 1872,  563, 1538, 1538, 1907, 1538, 1538, 1538,
 /*  2140 */   157, 1873, 1875,  598, 1877, 1878,  593, 1538,  588, 1538,
 /*  2150 */  1874, 1538, 1538, 1538, 1538, 1538, 1538, 1538, 1538, 1892,
 /*  2160 */  1538, 1538, 1538, 1538,  344, 1538, 1538,  595, 1538, 1538,
 /*  2170 */  1538, 1538, 1842, 1538,  594, 1538, 1538, 1538, 1538, 1892,
 /*  2180 */  1538, 1538, 1538, 1538,  347, 1538, 1538,  595, 1538, 1538,
 /*  2190 */  1538, 1538, 1842, 2050,  594, 1872, 1538, 1538, 1538, 1907,
 /*  2200 */  1538, 1874, 1538,  299, 1873, 1875,  598, 1877, 1878,  593,
 /*  2210 */  1538,  588, 1538, 1538, 1538, 1872, 1538, 1538, 1874, 1907,
 /*  2220 */  1538, 1538, 1538,  299, 1873, 1875,  598, 1877, 1878,  593,
 /*  2230 */  1892,  588, 1538, 1538, 1538, 1538, 1538, 1538,  595, 1538,
 /*  2240 */  1538, 1538, 1538, 1842, 1538,  594, 1538, 1892, 1538, 1538,
 /*  2250 */  1538, 1538, 1538, 1538, 1538,  595, 1538, 1538, 1538, 1538,
 /*  2260 */  1842, 1874,  594, 1538, 1538, 1538,  509, 1538, 1538, 1538,
 /*  2270 */  1907, 1538, 1538, 1538,  292, 1873, 1875,  598, 1877, 1878,
 /*  2280 */   593, 1538,  588, 1872, 1538, 1538, 1538, 1907, 1538, 1538,
 /*  2290 */  1892,  284, 1873, 1875,  598, 1877, 1878,  593,  595,  588,
 /*  2300 */  1538, 1538, 1538, 1842, 1538,  594, 1538, 1538, 1538, 1538,
 /*  2310 */  1538, 1538, 1874, 1538, 1538, 1538, 1538, 1538, 1538, 1538,
 /*  2320 */  1538, 1538, 1538, 1538, 1538, 1538, 1872, 1538, 1538, 1874,
 /*  2330 */  1907, 1538, 1538, 1538,  285, 1873, 1875,  598, 1877, 1878,
 /*  2340 */   593, 1892,  588, 1538, 1538, 1538, 1538, 1538, 1538,  595,
 /*  2350 */  1538, 1538, 1538, 1538, 1842, 1538,  594, 1538, 1892, 1538,
 /*  2360 */  1538, 1538, 1538, 1538, 1538, 1538,  595, 1538, 1538, 1538,
 /*  2370 */  1538, 1842, 1538,  594, 1538, 1538, 1538, 1872, 1538, 1538,
 /*  2380 */  1874, 1907, 1538, 1538, 1538,  286, 1873, 1875,  598, 1877,
 /*  2390 */  1878,  593, 1538,  588, 1872, 1538, 1538, 1538, 1907, 1538,
 /*  2400 */  1538, 1538,  293, 1873, 1875,  598, 1877, 1878,  593, 1892,
 /*  2410 */   588, 1538, 1538, 1538, 1538, 1538, 1538,  595, 1538, 1538,
 /*  2420 */  1538, 1538, 1842, 1538,  594, 1538, 1538, 1538, 1538, 1538,
 /*  2430 */  1538, 1874, 1538, 1538, 1538, 1538, 1538, 1538, 1538, 1538,
 /*  2440 */  1538, 1538, 1538, 1538, 1538, 1872, 1538, 1538, 1538, 1907,
 /*  2450 */  1874, 1538, 1538,  295, 1873, 1875,  598, 1877, 1878,  593,
 /*  2460 */  1892,  588, 1538, 1538, 1538, 1538, 1538, 1538,  595, 1538,
 /*  2470 */  1538, 1538, 1538, 1842, 1538,  594, 1538, 1538, 1538, 1892,
 /*  2480 */  1538, 1538, 1538, 1538, 1538, 1538, 1538,  595, 1538, 1538,
 /*  2490 */  1538, 1538, 1842, 1538,  594, 1538, 1872, 1538, 1538, 1538,
 /*  2500 */  1907, 1538, 1538, 1538,  287, 1873, 1875,  598, 1877, 1878,
 /*  2510 */   593, 1538,  588, 1874, 1538, 1872, 1538, 1538, 1538, 1907,
 /*  2520 */  1538, 1538, 1538,  296, 1873, 1875,  598, 1877, 1878,  593,
 /*  2530 */  1538,  588, 1538, 1538, 1538, 1874, 1538, 1538, 1538, 1538,
 /*  2540 */  1538, 1538, 1892, 1538, 1538, 1538, 1538, 1538, 1538, 1538,
 /*  2550 */   595, 1538, 1538, 1538, 1538, 1842, 1538,  594, 1538, 1538,
 /*  2560 */  1538, 1538, 1538, 1538, 1892, 1538, 1538, 1538, 1538, 1538,
 /*  2570 */  1538, 1538,  595, 1538, 1538, 1538, 1538, 1842, 1872,  594,
 /*  2580 */  1538, 1538, 1907, 1538, 1538, 1538,  288, 1873, 1875,  598,
 /*  2590 */  1877, 1878,  593, 1538,  588, 1874, 1538, 1538, 1538, 1538,
 /*  2600 */  1872, 1538, 1538, 1538, 1907, 1538, 1538, 1538,  297, 1873,
 /*  2610 */  1875,  598, 1877, 1878,  593, 1874,  588, 1538, 1538, 1538,
 /*  2620 */  1538, 1538, 1538, 1538, 1892, 1538, 1538, 1538, 1538, 1538,
 /*  2630 */  1538, 1538,  595, 1538, 1538, 1538, 1538, 1842, 1538,  594,
 /*  2640 */  1538, 1538, 1538, 1538, 1892, 1538, 1538, 1538, 1538, 1538,
 /*  2650 */  1538, 1538,  595, 1538, 1538, 1538, 1538, 1842, 1874,  594,
 /*  2660 */  1872, 1538, 1538, 1538, 1907, 1538, 1538, 1538,  289, 1873,
 /*  2670 */  1875,  598, 1877, 1878,  593, 1538,  588, 1538, 1874, 1538,
 /*  2680 */  1872, 1538, 1538, 1538, 1907, 1538, 1538, 1892,  302, 1873,
 /*  2690 */  1875,  598, 1877, 1878,  593,  595,  588, 1538, 1538, 1538,
 /*  2700 */  1842, 1538,  594, 1538, 1538, 1538, 1538, 1892, 1538, 1538,
 /*  2710 */  1538, 1538, 1538, 1538, 1538,  595, 1538, 1538, 1538, 1538,
 /*  2720 */  1842, 1538,  594, 1872, 1538, 1538, 1538, 1907, 1538, 1874,
 /*  2730 */  1538,  303, 1873, 1875,  598, 1877, 1878,  593, 1538,  588,
 /*  2740 */  1538, 1538, 1538, 1872, 1538, 1538, 1538, 1907, 1538, 1538,
 /*  2750 */  1538, 1886, 1873, 1875,  598, 1877, 1878,  593, 1892,  588,
 /*  2760 */  1538, 1538, 1538, 1538, 1538, 1538,  595, 1538, 1538, 1538,
 /*  2770 */  1538, 1842, 1538,  594, 1538, 1538, 1538, 1538, 1538, 1538,
 /*  2780 */  1874, 1538, 1538, 1538, 1538, 1538, 1538, 1538, 1538, 1538,
 /*  2790 */  1538, 1538, 1538, 1538, 1872, 1538, 1538, 1538, 1907, 1874,
 /*  2800 */  1538, 1538, 1885, 1873, 1875,  598, 1877, 1878,  593, 1892,
 /*  2810 */   588, 1538, 1538, 1538, 1538, 1538, 1538,  595, 1538, 1538,
 /*  2820 */  1538, 1538, 1842, 1538,  594, 1538, 1538, 1538, 1892, 1538,
 /*  2830 */  1538, 1538, 1538, 1538, 1538, 1538,  595, 1538, 1538, 1538,
 /*  2840 */  1538, 1842, 1538,  594, 1538, 1872, 1538, 1538, 1538, 1907,
 /*  2850 */  1538, 1538, 1538, 1884, 1873, 1875,  598, 1877, 1878,  593,
 /*  2860 */  1538,  588, 1874, 1538, 1872, 1538, 1538, 1538, 1907, 1538,
 /*  2870 */  1538, 1538,  314, 1873, 1875,  598, 1877, 1878,  593, 1538,
 /*  2880 */   588, 1538, 1538, 1538, 1874, 1538, 1538, 1538, 1538, 1538,
 /*  2890 */  1538, 1892, 1538, 1538, 1538, 1538, 1538, 1538, 1538,  595,
 /*  2900 */  1538, 1538, 1538, 1538, 1842, 1538,  594, 1538, 1538, 1538,
 /*  2910 */  1538, 1538, 1538, 1892, 1538, 1538, 1538, 1538, 1538, 1538,
 /*  2920 */  1538,  595, 1538, 1538, 1538, 1538, 1842, 1872,  594, 1538,
 /*  2930 */  1538, 1907, 1538, 1538, 1538,  315, 1873, 1875,  598, 1877,
 /*  2940 */  1878,  593, 1538,  588, 1874, 1538, 1538, 1538, 1538, 1872,
 /*  2950 */  1538, 1538, 1538, 1907, 1538, 1538, 1538,  311, 1873, 1875,
 /*  2960 */   598, 1877, 1878,  593, 1874,  588, 1538, 1538, 1538, 1538,
 /*  2970 */  1538, 1538, 1538, 1892, 1538, 1538, 1538, 1538, 1538, 1538,
 /*  2980 */  1538,  595, 1538, 1538, 1538, 1538, 1842, 1538,  594, 1538,
 /*  2990 */  1538, 1538, 1538, 1892, 1538, 1538, 1538, 1538, 1538, 1538,
 /*  3000 */  1538,  595, 1538, 1538, 1538, 1538, 1842, 1538,  594, 1872,
 /*  3010 */  1538, 1538, 1538, 1907, 1538, 1538, 1538,  316, 1873, 1875,
 /*  3020 */   598, 1877, 1878,  593, 1538,  588, 1538, 1538, 1538, 1872,
 /*  3030 */  1538, 1538, 1538, 1907, 1538, 1538, 1538,  291, 1873, 1875,
 /*  3040 */   598, 1877, 1878,  593, 1538,  588,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   350,    0,  323,  350,  325,  326,  323,  319,  325,  326,
 /*    10 */   350,  361,   12,   13,  361,  359,  327,  349,  362,  363,
 /*    20 */    20,  361,   22,   12,   13,   14,   15,   16,  339,    3,
 /*    30 */    14,   15,   16,   33,    4,   35,  348,  387,  388,  389,
 /*    40 */   387,  388,  389,   20,  356,  356,   20,  387,  388,  361,
 /*    50 */   400,  363,    2,  400,  324,   20,   56,  327,    8,    9,
 /*    60 */   400,   61,   12,   13,   14,   15,   16,  319,   68,   12,
 /*    70 */    13,   14,  384,   35,   44,   45,  388,   20,  393,   22,
 /*    80 */   392,  393,  394,  395,  396,  397,  398,   20,  400,   22,
 /*    90 */    33,  319,   35,  405,   94,  407,  348,  362,  363,  411,
 /*   100 */   412,  331,   35,  348,  356,  327,   68,  422,   14,  361,
 /*   110 */   355,  363,  424,   56,   20,  345,  116,   50,   61,  364,
 /*   120 */   432,   95,  437,  438,  354,   68,    0,  442,  443,   94,
 /*   130 */   130,  131,  384,  361,  356,    4,  388,    0,  319,   56,
 /*   140 */   392,  393,  394,  395,  396,  397,  398,  390,  400,  348,
 /*   150 */   329,   94,   20,  130,  131,  407,   94,  356,   21,  411,
 /*   160 */   412,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   170 */   422,  393,  351,  116,  363,  418,  176,   94,  178,   96,
 /*   180 */   361,  370,  408,  409,  373,  437,  438,  130,  131,  163,
 /*   190 */   442,  443,  414,  415,  416,  417,  395,  419,  161,  324,
 /*   200 */   200,  201,  327,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,   20,   33,   94,   94,  329,  158,  318,
 /*   230 */   327,  320,  106,  176,   20,  178,   94,  175,   47,  177,
 /*   240 */   240,  343,  200,   52,   53,   54,   55,   56,   78,  351,
 /*   250 */    14,  125,  126,  127,  128,  129,   20,  200,  201,  356,
 /*   260 */   203,  204,  205,  206,  207,  208,  209,  210,  211,  212,
 /*   270 */   213,  214,  215,  216,  217,  218,  219,  220,  221,  222,
 /*   280 */    12,   13,  245,  246,   93,  334,  335,   96,   20,  350,
 /*   290 */    22,  249,  250,  251,  252,  253,  393,  227,  204,  327,
 /*   300 */   361,   33,  240,   35,  134,  135,   21,  237,   94,   24,
 /*   310 */    25,   26,   27,   28,   29,   30,   31,   32,  415,  416,
 /*   320 */   417,  106,  419,  240,   56,   60,  387,  388,  356,   61,
 /*   330 */   393,  224,  319,  226,  327,  171,   68,   12,   13,  400,
 /*   340 */   125,  126,  127,  128,  129,   20,  339,   22,  327,  332,
 /*   350 */   159,  160,   94,  162,  337,  191,  192,  166,   33,  422,
 /*   360 */    35,  348,   94,  356,   20,  393,  327,  393,  404,  356,
 /*   370 */   406,  240,  240,  182,  361,  438,  363,  356,  339,  442,
 /*   380 */   443,   56,  240,  327,  116,  346,   61,  415,  416,  417,
 /*   390 */   126,  419,   20,   68,   22,  356,  422,  384,  130,  131,
 /*   400 */    20,  388,    0,  125,  126,  392,  393,  394,  395,  396,
 /*   410 */   397,  398,  438,  400,  393,   20,  442,  443,  405,   94,
 /*   420 */   407,  365,   50,  327,  411,  412,   24,   25,   26,   27,
 /*   430 */    28,   29,   30,   31,   32,  339,  415,  416,  417,  390,
 /*   440 */   419,  116,  346,  422,  176,  432,  178,  183,  184,   60,
 /*   450 */   348,  187,  356,   20,  240,  130,  131,  355,  437,  438,
 /*   460 */     1,    2,  184,  442,  443,  187,  364,  418,  200,  201,
 /*   470 */     0,  203,  204,  205,  206,  207,  208,  209,  210,  211,
 /*   480 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   490 */   222,  125,  224,   14,  404,  316,  406,   37,  240,   20,
 /*   500 */   331,  176,  372,  178,  374,  107,  108,  109,  110,  111,
 /*   510 */   112,  113,  114,  115,  116,  117,   43,  119,  120,  121,
 /*   520 */   122,  123,  124,  354,  105,  200,  201,   56,  203,  204,
 /*   530 */   205,  206,  207,  208,  209,  210,  211,  212,  213,  214,
 /*   540 */   215,  216,  217,  218,  219,  220,  221,  222,   12,   13,
 /*   550 */    22,  185,  186,  340,   95,  376,   20,   97,   22,   99,
 /*   560 */   100,  348,  102,   35,   93,  327,  106,   96,   95,   33,
 /*   570 */   357,   35,  393,    0,  376,  390,  106,  339,    8,    9,
 /*   580 */   347,  319,   12,   13,   14,   15,   16,   20,  128,  224,
 /*   590 */    20,  393,   56,  360,  356,  125,  126,  127,  128,  129,
 /*   600 */   319,  422,  327,  418,   68,   12,   13,   14,  334,  335,
 /*   610 */   348,  319,   68,   20,  339,   22,  437,  438,  356,   68,
 /*   620 */   422,  442,  443,  361,   56,  363,   33,  348,   35,  348,
 /*   630 */    94,  356,   21,   60,  355,  437,  438,  356,    3,  327,
 /*   640 */   442,  443,  361,  364,  363,   34,  384,   36,    0,   56,
 /*   650 */   388,  339,  116,  361,  392,  393,  394,  395,  396,  397,
 /*   660 */   398,   68,  400,  340,   96,  384,  130,  131,  356,  388,
 /*   670 */   349,  348,  393,  392,  393,  394,  395,  396,  397,  398,
 /*   680 */   357,  400,  341,  204,  422,  344,  405,   94,  407,  319,
 /*   690 */     8,    9,  411,  412,   12,   13,   14,   15,   16,  437,
 /*   700 */   438,  422,  421,  327,  442,  443,  327,   43,   60,  116,
 /*   710 */   363,  372,  176,  374,  178,  339,  437,  438,  339,  320,
 /*   720 */   373,  442,  443,  130,  131,  348,  358,  356,  319,  361,
 /*   730 */   163,  361,  356,  163,  357,  356,  200,  201,  367,  203,
 /*   740 */   204,  205,  206,  207,  208,  209,  210,  211,  212,  213,
 /*   750 */   214,  215,  216,  217,  218,  219,  220,  221,  222,   95,
 /*   760 */     8,    9,  327,  327,   12,   13,   14,   15,   16,  176,
 /*   770 */   361,  178,  340,  349,  339,  339,  240,   95,    8,    9,
 /*   780 */   348,  319,   12,   13,   14,   15,   16,  403,  319,  357,
 /*   790 */   406,  356,  356,  200,  201,   43,  203,  204,  205,  206,
 /*   800 */   207,  208,  209,  210,  211,  212,  213,  214,  215,  216,
 /*   810 */   217,  218,  219,  220,  221,  222,   12,   13,  376,   22,
 /*   820 */   356,  319,  348,  361,   20,  358,   22,  319,  361,    3,
 /*   830 */   361,  367,   35,  327,  319,  393,  349,   33,  364,   35,
 /*   840 */     2,  376,   44,   45,  106,  339,    8,    9,  319,  319,
 /*   850 */    12,   13,   14,   15,   16,  336,   39,  338,  393,  327,
 /*   860 */    56,    4,  356,  361,  422,   68,  128,  319,  319,  361,
 /*   870 */   327,  339,   68,   12,   13,   43,  361,  327,  348,  437,
 /*   880 */   438,   20,  339,   22,  442,  443,  356,  422,  356,  339,
 /*   890 */   361,  361,  257,  363,   33,   20,   35,  348,   94,  356,
 /*   900 */   380,  341,  437,  438,  344,  356,  356,  442,  443,  361,
 /*   910 */   361,   20,  363,  116,  384,    0,  319,   56,  388,  327,
 /*   920 */   116,   95,  392,  393,  394,  395,  396,  397,  398,   68,
 /*   930 */   400,  339,  349,  384,  130,  131,  319,  388,  168,   42,
 /*   940 */    43,  392,  393,  394,  395,  396,  397,  398,  356,  400,
 /*   950 */    64,   65,  319,   61,  405,   94,  407,   71,  361,    0,
 /*   960 */   411,  412,   47,  433,  434,  238,  239,  327,   82,   83,
 /*   970 */   421,    0,  327,  176,   88,  178,   35,  116,  361,  339,
 /*   980 */   176,   22,  178,  376,  339,  319,   98,   98,  319,  101,
 /*   990 */   101,  130,  131,  349,  361,   43,  356,  200,  201,  319,
 /*  1000 */   393,  356,  163,  164,  200,  201,  319,  203,  204,  205,
 /*  1010 */   206,  207,  208,  209,  210,  211,  212,  213,  214,  215,
 /*  1020 */   216,  217,  218,  219,  220,  221,  222,  361,  327,  422,
 /*  1030 */   361,  327,  262,  130,  131,   64,   65,  176,  163,  178,
 /*  1040 */   339,  361,   71,  339,  437,  438,   43,   95,  361,  442,
 /*  1050 */   443,  349,   43,   82,   83,   98,  239,  356,  101,   88,
 /*  1060 */   356,  200,  201,    0,  203,  204,  205,  206,  207,  208,
 /*  1070 */   209,  210,  211,  212,  213,  214,  215,  216,  217,  218,
 /*  1080 */   219,  220,  221,  222,   18,  327,   20,   98,    1,    2,
 /*  1090 */   101,  259,  200,   27,   35,  204,   30,  339,  241,    0,
 /*  1100 */     0,   94,    8,    9,   95,  391,   12,   13,   14,   15,
 /*  1110 */    16,  104,  337,   47,  356,   49,   43,   51,   43,  178,
 /*  1120 */    43,   22,   22,  446,   43,   43,   63,   64,   65,   66,
 /*  1130 */    67,   43,   69,   70,   71,   72,   73,   74,   75,   76,
 /*  1140 */    77,   78,   79,   80,   81,   82,   83,   84,   85,   86,
 /*  1150 */    87,   88,   89,   90,  435,   18,  328,    8,    9,   93,
 /*  1160 */    23,   12,   13,   14,   15,   16,  429,   35,   95,   13,
 /*  1170 */    95,  105,   95,   43,   37,   38,   95,   95,   41,   46,
 /*  1180 */     8,    9,  348,   95,   12,   13,   14,   15,   16,   95,
 /*  1190 */    43,   35,  328,  326,   57,   58,   59,   43,  391,  133,
 /*  1200 */    68,  319,  136,  137,  138,  139,  140,  141,  142,  143,
 /*  1210 */   144,  145,  146,  147,  148,  149,  150,  151,  152,  153,
 /*  1220 */    43,  155,  156,  157,   13,   95,  360,   94,    8,    9,
 /*  1230 */   348,   94,   12,   13,   14,   15,   16,  178,  356,   43,
 /*  1240 */    43,  420,   95,  361,  439,  363,   35,    0,  413,   95,
 /*  1250 */   423,  386,  242,   47,  385,  378,   42,  174,  368,   20,
 /*  1260 */   327,  327,  368,  158,  261,  366,  384,  366,   92,  132,
 /*  1270 */   388,  333,   95,  327,  392,  393,  394,  395,  396,  397,
 /*  1280 */   398,   61,  400,  327,   20,  403,  321,  405,  406,  407,
 /*  1290 */   327,   95,   95,  411,  412,   48,  321,   20,  382,  331,
 /*  1300 */   376,  331,  363,   20,  375,  168,  169,  170,   20,  377,
 /*  1310 */   173,  319,  163,  331,  331,  375,    4,  393,  331,  331,
 /*  1320 */   327,  331,  321,  103,  348,  348,  348,  190,  348,  348,
 /*  1330 */   193,   19,  195,  196,  197,  198,  199,  321,  327,  348,
 /*  1340 */   348,  189,  348,  348,  348,   33,  422,  348,  356,  383,
 /*  1350 */   348,  382,  329,  361,  181,  363,  329,  327,  361,   47,
 /*  1360 */   381,  437,  438,   51,  327,  329,  442,  443,   56,  363,
 /*  1370 */   247,  371,  160,  375,  361,  361,  384,  240,  158,  361,
 /*  1380 */   388,  361,  361,  371,  392,  393,  394,  395,  396,  397,
 /*  1390 */   398,  369,  400,  319,  329,  344,  329,  405,  356,  407,
 /*  1400 */    20,  361,  428,  411,  412,   93,  391,  248,   96,  371,
 /*  1410 */   391,  361,  428,  421,  361,  371,  361,  361,  254,  167,
 /*  1420 */   263,  256,  348,  255,  243,  386,  260,  441,  258,  239,
 /*  1430 */   356,   20,  447,  425,  430,  361,  431,  363,  390,   94,
 /*  1440 */   356,  410,   94,  352,  338,  428,  319,  227,  228,  229,
 /*  1450 */   230,  231,  232,  233,  234,  235,  236,  237,  384,  427,
 /*  1460 */   426,  327,  388,  361,  440,  329,  392,  393,  394,  395,
 /*  1470 */   396,  397,  398,   36,  400,  348,  379,  322,  374,  405,
 /*  1480 */   342,  407,  321,  356,  342,  411,  412,  342,  361,    0,
 /*  1490 */   363,  317,  330,    0,  183,    0,    0,   42,    0,   35,
 /*  1500 */   194,   35,   35,   35,  194,    0,   35,   35,  194,    0,
 /*  1510 */   194,  384,    0,   35,  319,  388,    0,    0,   35,  392,
 /*  1520 */   393,  394,  395,  396,  397,  398,   22,  400,  178,  176,
 /*  1530 */     0,    0,  405,  172,  407,  171,  319,    0,  411,  412,
 /*  1540 */    12,   13,    0,  348,   42,   46,    0,    0,    0,    0,
 /*  1550 */    22,  356,    0,    0,  154,    0,  361,    0,  363,    0,
 /*  1560 */     0,   33,    0,   35,  149,  348,    0,   35,  149,    0,
 /*  1570 */     0,    0,    0,  356,    0,    0,    0,    0,  361,  384,
 /*  1580 */   363,    0,    0,  388,   56,    0,    0,  392,  393,  394,
 /*  1590 */   395,  396,  397,  398,  319,  400,   68,    0,    0,    0,
 /*  1600 */   405,  384,  407,   42,    0,  388,  411,  412,    0,  392,
 /*  1610 */   393,  394,  395,  396,  397,  398,    0,  400,    0,    0,
 /*  1620 */    19,    0,   22,  348,  407,    0,    0,    0,  411,  412,
 /*  1630 */     0,  356,    0,    0,   33,   56,  361,   35,  363,   56,
 /*  1640 */     0,    0,   14,   14,  116,   42,   39,    0,   47,   43,
 /*  1650 */    40,   46,   39,   52,   53,   54,   55,   56,    0,  384,
 /*  1660 */    46,    0,   39,  388,  167,    0,    0,  392,  393,  394,
 /*  1670 */   395,  396,  397,  398,    0,  400,    0,   62,    0,   35,
 /*  1680 */     0,   47,  407,   35,   39,   47,  411,  412,   39,    0,
 /*  1690 */    35,   39,    0,   47,   93,   35,  319,   96,   47,    0,
 /*  1700 */     0,   39,    0,    0,  176,   35,  178,   22,    0,   22,
 /*  1710 */    35,   43,  103,    0,   35,   43,   35,   35,  101,    0,
 /*  1720 */    22,    0,   49,   22,    0,  348,   22,    0,  200,  201,
 /*  1730 */   129,   35,    0,  356,   22,    0,   20,   95,  361,    0,
 /*  1740 */   363,  213,  214,  215,  216,  217,  218,  219,   94,   35,
 /*  1750 */    35,  163,   35,   22,  163,  319,  160,  179,    0,    0,
 /*  1760 */     3,  384,    0,  162,    0,  388,    0,    0,   35,  392,
 /*  1770 */   393,  394,  395,  396,  397,  398,  399,  400,  401,  402,
 /*  1780 */    94,  180,  188,  182,  348,  163,   95,   94,   94,  165,
 /*  1790 */     0,   39,  356,   46,  104,  159,  161,  361,   43,  363,
 /*  1800 */    94,   94,  244,  223,   43,   95,   95,  244,   43,  225,
 /*  1810 */   319,   43,  223,   95,   94,   46,   94,   46,   95,   94,
 /*  1820 */   384,   95,   94,   94,  388,   43,    3,   43,  392,  393,
 /*  1830 */   394,  395,  396,  397,  398,   94,  400,   95,   95,  348,
 /*  1840 */    35,   35,   35,   35,   35,   35,   95,  356,   95,   46,
 /*  1850 */    46,    2,  361,  200,  363,  244,   43,   22,  238,   22,
 /*  1860 */    46,   46,   46,  319,   94,  202,   22,   95,   94,   35,
 /*  1870 */    95,   94,  118,   95,   94,  384,   95,   94,  105,  388,
 /*  1880 */   444,  445,   94,  392,  393,  394,  395,  396,  397,  398,
 /*  1890 */    95,  400,  348,   35,   94,   35,   95,  353,  407,   35,
 /*  1900 */   356,   35,  106,  412,   35,  361,   94,  363,   35,  118,
 /*  1910 */   118,  118,   95,   94,  319,   95,   94,   43,   22,   95,
 /*  1920 */    94,   94,   94,   94,   62,   35,   61,   35,  384,   35,
 /*  1930 */    35,  319,  388,   35,   91,   35,  392,  393,  394,  395,
 /*  1940 */   396,  397,  398,  348,  400,   35,   35,   35,   35,   68,
 /*  1950 */    43,  356,   35,   35,   22,   35,  361,   22,  363,   35,
 /*  1960 */   348,   35,   35,   35,   35,   68,   35,   22,  356,   35,
 /*  1970 */     0,   35,   35,  361,   35,  363,    0,   47,   35,  384,
 /*  1980 */    39,    0,    0,  388,   35,   47,   39,  392,  393,  394,
 /*  1990 */   395,  396,  397,  398,   39,  400,  384,  402,   47,   35,
 /*  2000 */   388,   47,   39,    0,  392,  393,  394,  395,  396,  397,
 /*  2010 */   398,    0,  400,   35,   35,   21,  319,   22,   22,   22,
 /*  2020 */    21,   20,  448,  448,  448,  448,  448,  448,  448,  448,
 /*  2030 */   448,  448,  448,  448,  448,  448,  448,  448,  448,  448,
 /*  2040 */   448,  448,  448,  448,  448,  348,  434,  448,  448,  448,
 /*  2050 */   448,  448,  448,  356,  448,  448,  448,  448,  361,  448,
 /*  2060 */   363,  448,  448,  448,  448,  448,  448,  319,  448,  448,
 /*  2070 */   448,  448,  448,  448,  448,  448,  448,  448,  448,  448,
 /*  2080 */   448,  384,  448,  448,  448,  388,  448,  448,  448,  392,
 /*  2090 */   393,  394,  395,  396,  397,  398,  348,  400,  448,  448,
 /*  2100 */   448,  448,  448,  448,  356,  448,  448,  448,  448,  361,
 /*  2110 */   448,  363,  448,  448,  448,  448,  448,  448,  448,  448,
 /*  2120 */   448,  448,  448,  448,  448,  448,  448,  448,  448,  448,
 /*  2130 */   319,  448,  384,  436,  448,  448,  388,  448,  448,  448,
 /*  2140 */   392,  393,  394,  395,  396,  397,  398,  448,  400,  448,
 /*  2150 */   319,  448,  448,  448,  448,  448,  448,  448,  448,  348,
 /*  2160 */   448,  448,  448,  448,  353,  448,  448,  356,  448,  448,
 /*  2170 */   448,  448,  361,  448,  363,  448,  448,  448,  448,  348,
 /*  2180 */   448,  448,  448,  448,  353,  448,  448,  356,  448,  448,
 /*  2190 */   448,  448,  361,  445,  363,  384,  448,  448,  448,  388,
 /*  2200 */   448,  319,  448,  392,  393,  394,  395,  396,  397,  398,
 /*  2210 */   448,  400,  448,  448,  448,  384,  448,  448,  319,  388,
 /*  2220 */   448,  448,  448,  392,  393,  394,  395,  396,  397,  398,
 /*  2230 */   348,  400,  448,  448,  448,  448,  448,  448,  356,  448,
 /*  2240 */   448,  448,  448,  361,  448,  363,  448,  348,  448,  448,
 /*  2250 */   448,  448,  448,  448,  448,  356,  448,  448,  448,  448,
 /*  2260 */   361,  319,  363,  448,  448,  448,  384,  448,  448,  448,
 /*  2270 */   388,  448,  448,  448,  392,  393,  394,  395,  396,  397,
 /*  2280 */   398,  448,  400,  384,  448,  448,  448,  388,  448,  448,
 /*  2290 */   348,  392,  393,  394,  395,  396,  397,  398,  356,  400,
 /*  2300 */   448,  448,  448,  361,  448,  363,  448,  448,  448,  448,
 /*  2310 */   448,  448,  319,  448,  448,  448,  448,  448,  448,  448,
 /*  2320 */   448,  448,  448,  448,  448,  448,  384,  448,  448,  319,
 /*  2330 */   388,  448,  448,  448,  392,  393,  394,  395,  396,  397,
 /*  2340 */   398,  348,  400,  448,  448,  448,  448,  448,  448,  356,
 /*  2350 */   448,  448,  448,  448,  361,  448,  363,  448,  348,  448,
 /*  2360 */   448,  448,  448,  448,  448,  448,  356,  448,  448,  448,
 /*  2370 */   448,  361,  448,  363,  448,  448,  448,  384,  448,  448,
 /*  2380 */   319,  388,  448,  448,  448,  392,  393,  394,  395,  396,
 /*  2390 */   397,  398,  448,  400,  384,  448,  448,  448,  388,  448,
 /*  2400 */   448,  448,  392,  393,  394,  395,  396,  397,  398,  348,
 /*  2410 */   400,  448,  448,  448,  448,  448,  448,  356,  448,  448,
 /*  2420 */   448,  448,  361,  448,  363,  448,  448,  448,  448,  448,
 /*  2430 */   448,  319,  448,  448,  448,  448,  448,  448,  448,  448,
 /*  2440 */   448,  448,  448,  448,  448,  384,  448,  448,  448,  388,
 /*  2450 */   319,  448,  448,  392,  393,  394,  395,  396,  397,  398,
 /*  2460 */   348,  400,  448,  448,  448,  448,  448,  448,  356,  448,
 /*  2470 */   448,  448,  448,  361,  448,  363,  448,  448,  448,  348,
 /*  2480 */   448,  448,  448,  448,  448,  448,  448,  356,  448,  448,
 /*  2490 */   448,  448,  361,  448,  363,  448,  384,  448,  448,  448,
 /*  2500 */   388,  448,  448,  448,  392,  393,  394,  395,  396,  397,
 /*  2510 */   398,  448,  400,  319,  448,  384,  448,  448,  448,  388,
 /*  2520 */   448,  448,  448,  392,  393,  394,  395,  396,  397,  398,
 /*  2530 */   448,  400,  448,  448,  448,  319,  448,  448,  448,  448,
 /*  2540 */   448,  448,  348,  448,  448,  448,  448,  448,  448,  448,
 /*  2550 */   356,  448,  448,  448,  448,  361,  448,  363,  448,  448,
 /*  2560 */   448,  448,  448,  448,  348,  448,  448,  448,  448,  448,
 /*  2570 */   448,  448,  356,  448,  448,  448,  448,  361,  384,  363,
 /*  2580 */   448,  448,  388,  448,  448,  448,  392,  393,  394,  395,
 /*  2590 */   396,  397,  398,  448,  400,  319,  448,  448,  448,  448,
 /*  2600 */   384,  448,  448,  448,  388,  448,  448,  448,  392,  393,
 /*  2610 */   394,  395,  396,  397,  398,  319,  400,  448,  448,  448,
 /*  2620 */   448,  448,  448,  448,  348,  448,  448,  448,  448,  448,
 /*  2630 */   448,  448,  356,  448,  448,  448,  448,  361,  448,  363,
 /*  2640 */   448,  448,  448,  448,  348,  448,  448,  448,  448,  448,
 /*  2650 */   448,  448,  356,  448,  448,  448,  448,  361,  319,  363,
 /*  2660 */   384,  448,  448,  448,  388,  448,  448,  448,  392,  393,
 /*  2670 */   394,  395,  396,  397,  398,  448,  400,  448,  319,  448,
 /*  2680 */   384,  448,  448,  448,  388,  448,  448,  348,  392,  393,
 /*  2690 */   394,  395,  396,  397,  398,  356,  400,  448,  448,  448,
 /*  2700 */   361,  448,  363,  448,  448,  448,  448,  348,  448,  448,
 /*  2710 */   448,  448,  448,  448,  448,  356,  448,  448,  448,  448,
 /*  2720 */   361,  448,  363,  384,  448,  448,  448,  388,  448,  319,
 /*  2730 */   448,  392,  393,  394,  395,  396,  397,  398,  448,  400,
 /*  2740 */   448,  448,  448,  384,  448,  448,  448,  388,  448,  448,
 /*  2750 */   448,  392,  393,  394,  395,  396,  397,  398,  348,  400,
 /*  2760 */   448,  448,  448,  448,  448,  448,  356,  448,  448,  448,
 /*  2770 */   448,  361,  448,  363,  448,  448,  448,  448,  448,  448,
 /*  2780 */   319,  448,  448,  448,  448,  448,  448,  448,  448,  448,
 /*  2790 */   448,  448,  448,  448,  384,  448,  448,  448,  388,  319,
 /*  2800 */   448,  448,  392,  393,  394,  395,  396,  397,  398,  348,
 /*  2810 */   400,  448,  448,  448,  448,  448,  448,  356,  448,  448,
 /*  2820 */   448,  448,  361,  448,  363,  448,  448,  448,  348,  448,
 /*  2830 */   448,  448,  448,  448,  448,  448,  356,  448,  448,  448,
 /*  2840 */   448,  361,  448,  363,  448,  384,  448,  448,  448,  388,
 /*  2850 */   448,  448,  448,  392,  393,  394,  395,  396,  397,  398,
 /*  2860 */   448,  400,  319,  448,  384,  448,  448,  448,  388,  448,
 /*  2870 */   448,  448,  392,  393,  394,  395,  396,  397,  398,  448,
 /*  2880 */   400,  448,  448,  448,  319,  448,  448,  448,  448,  448,
 /*  2890 */   448,  348,  448,  448,  448,  448,  448,  448,  448,  356,
 /*  2900 */   448,  448,  448,  448,  361,  448,  363,  448,  448,  448,
 /*  2910 */   448,  448,  448,  348,  448,  448,  448,  448,  448,  448,
 /*  2920 */   448,  356,  448,  448,  448,  448,  361,  384,  363,  448,
 /*  2930 */   448,  388,  448,  448,  448,  392,  393,  394,  395,  396,
 /*  2940 */   397,  398,  448,  400,  319,  448,  448,  448,  448,  384,
 /*  2950 */   448,  448,  448,  388,  448,  448,  448,  392,  393,  394,
 /*  2960 */   395,  396,  397,  398,  319,  400,  448,  448,  448,  448,
 /*  2970 */   448,  448,  448,  348,  448,  448,  448,  448,  448,  448,
 /*  2980 */   448,  356,  448,  448,  448,  448,  361,  448,  363,  448,
 /*  2990 */   448,  448,  448,  348,  448,  448,  448,  448,  448,  448,
 /*  3000 */   448,  356,  448,  448,  448,  448,  361,  448,  363,  384,
 /*  3010 */   448,  448,  448,  388,  448,  448,  448,  392,  393,  394,
 /*  3020 */   395,  396,  397,  398,  448,  400,  448,  448,  448,  384,
 /*  3030 */   448,  448,  448,  388,  448,  448,  448,  392,  393,  394,
 /*  3040 */   395,  396,  397,  398,  448,  400,
};
#define YY_SHIFT_COUNT    (688)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2011)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1137,    0,   57,  268,   57,  325,  325,  325,  536,  325,
 /*    10 */   325,  325,  325,  325,  593,  804,  804,  861,  804,  804,
 /*    20 */   804,  804,  804,  804,  804,  804,  804,  804,  804,  804,
 /*    30 */   804,  804,  804,  804,  804,  804,  804,  804,  804,  804,
 /*    40 */   804,  804,  804,  804,  804,  804,  132,  214,   35,   62,
 /*    50 */    83,  142,  258,  142,   35,   35, 1528, 1528,  142, 1528,
 /*    60 */  1528,  131,  142,  203,  203,   30,   30,   23,  203,  203,
 /*    70 */   203,  203,  203,  203,  203,  203,  203,  203,  265,  203,
 /*    80 */   203,  203,  344,  203,  203,  380,  203,  203,  380,  395,
 /*    90 */   203,  380,  380,  380,  203,  389, 1066, 1220, 1220,  285,
 /*   100 */   797,  797,  797,  797,  797,  797,  797,  797,  797,  797,
 /*   110 */   797,  797,  797,  797,  797,  797,  797,  797,  797,  460,
 /*   120 */   886,   26,   23,  236,  236,  573,   38,  648,  107,  107,
 /*   130 */   567,  567,  567,   38,  433,  433,  419,  344,    1,    1,
 /*   140 */   365,  380,  380,  544,  544,  419,  551,  398,  398,  398,
 /*   150 */   398,  398,  398,  398, 1601,  137,  570,  770,  971,   42,
 /*   160 */    67,   37,   94,  479,  372,  798,  738,  875,  727,  817,
 /*   170 */   635,  727,  897,  857,  891, 1010, 1206, 1083, 1214, 1239,
 /*   180 */  1239, 1214, 1105, 1105, 1176, 1239, 1239, 1239, 1264, 1264,
 /*   190 */  1277,  265,  344,  265, 1283, 1288,  265, 1283,  265,  265,
 /*   200 */   265, 1239,  265, 1264,  380,  380,  380,  380,  380,  380,
 /*   210 */   380,  380,  380,  380,  380, 1239, 1264,  544, 1152, 1277,
 /*   220 */   389, 1173,  344,  389, 1239, 1239, 1283,  389, 1123,  544,
 /*   230 */   544,  544,  544, 1123,  544, 1212,  389,  419,  389,  433,
 /*   240 */  1380, 1380,  544, 1159, 1123,  544,  544, 1159, 1123,  544,
 /*   250 */   544,  380, 1164, 1252, 1159, 1165, 1168, 1181, 1010, 1157,
 /*   260 */  1166, 1170, 1190,  433, 1411, 1345, 1348,  544,  551, 1239,
 /*   270 */   389, 1437, 1264, 3046, 3046, 3046, 3046, 3046, 3046, 3046,
 /*   280 */  1063,  191,  402, 1312,  682,  752, 1094,   50,  838, 1149,
 /*   290 */   126, 1172, 1172, 1172, 1172, 1172, 1172, 1172, 1172, 1172,
 /*   300 */   470,  215,   11,   11,  264,  278,  164,  471,  170,  611,
 /*   310 */   366,   16,  459,   70,   16,   16,   16,  473,  915,  528,
 /*   320 */   888,  889,  957,  989,  959, 1099, 1100,  568,  839,  664,
 /*   330 */   952, 1009, 1073, 1075, 1077, 1081,  903,  832, 1003, 1087,
 /*   340 */  1082,  941, 1059,  892, 1088,  826, 1133, 1130, 1147, 1154,
 /*   350 */  1177, 1196, 1197, 1007, 1156, 1211, 1132, 1247, 1489, 1493,
 /*   360 */  1311, 1495, 1496, 1455, 1498, 1464, 1306, 1466, 1467, 1468,
 /*   370 */  1310, 1505, 1471, 1472, 1314, 1509, 1316, 1512, 1478, 1516,
 /*   380 */  1504, 1517, 1483, 1350, 1353, 1530, 1531, 1361, 1364, 1537,
 /*   390 */  1542, 1499, 1546, 1547, 1548, 1502, 1549, 1552, 1553, 1400,
 /*   400 */  1555, 1557, 1559, 1560, 1562, 1415, 1532, 1566, 1419, 1569,
 /*   410 */  1570, 1571, 1572, 1574, 1575, 1576, 1577, 1581, 1582, 1585,
 /*   420 */  1586, 1597, 1598, 1561, 1599, 1604, 1608, 1616, 1618, 1619,
 /*   430 */  1600, 1621, 1625, 1626, 1627, 1602, 1630, 1579, 1632, 1583,
 /*   440 */  1633, 1640, 1603, 1607, 1606, 1628, 1605, 1629, 1614, 1641,
 /*   450 */  1610, 1613, 1647, 1658, 1661, 1623, 1497, 1665, 1666, 1674,
 /*   460 */  1615, 1676, 1678, 1644, 1634, 1645, 1680, 1648, 1638, 1649,
 /*   470 */  1689, 1655, 1646, 1652, 1692, 1660, 1651, 1662, 1699, 1700,
 /*   480 */  1702, 1703, 1609, 1617, 1670, 1685, 1708, 1675, 1679, 1668,
 /*   490 */  1672, 1681, 1682, 1687, 1713, 1698, 1719, 1701, 1673, 1721,
 /*   500 */  1704, 1696, 1724, 1714, 1727, 1715, 1732, 1712, 1716, 1642,
 /*   510 */  1654, 1735, 1588, 1717, 1739, 1578, 1731, 1591, 1596, 1758,
 /*   520 */  1759, 1622, 1624, 1757, 1762, 1764, 1766, 1686, 1691, 1733,
 /*   530 */  1594, 1767, 1693, 1635, 1694, 1790, 1752, 1636, 1706, 1690,
 /*   540 */  1747, 1755, 1580, 1584, 1589, 1761, 1558, 1707, 1710, 1720,
 /*   550 */  1711, 1718, 1722, 1765, 1723, 1725, 1728, 1729, 1726, 1768,
 /*   560 */  1769, 1771, 1741, 1782, 1563, 1742, 1743, 1823, 1784, 1611,
 /*   570 */  1805, 1806, 1807, 1808, 1809, 1810, 1751, 1753, 1803, 1620,
 /*   580 */  1813, 1804, 1814, 1849, 1835, 1653, 1770, 1772, 1774, 1775,
 /*   590 */  1777, 1778, 1815, 1780, 1783, 1816, 1781, 1837, 1663, 1788,
 /*   600 */  1773, 1795, 1834, 1858, 1800, 1801, 1860, 1812, 1817, 1864,
 /*   610 */  1819, 1820, 1866, 1822, 1824, 1869, 1826, 1754, 1791, 1792,
 /*   620 */  1793, 1844, 1796, 1827, 1828, 1873, 1829, 1874, 1874, 1896,
 /*   630 */  1862, 1865, 1890, 1892, 1894, 1895, 1898, 1900, 1910, 1911,
 /*   640 */  1912, 1913, 1881, 1843, 1907, 1917, 1918, 1932, 1920, 1935,
 /*   650 */  1924, 1926, 1927, 1897, 1668, 1928, 1672, 1929, 1931, 1934,
 /*   660 */  1936, 1945, 1937, 1970, 1939, 1930, 1941, 1976, 1943, 1938,
 /*   670 */  1947, 1981, 1949, 1951, 1955, 1982, 1964, 1954, 1963, 2003,
 /*   680 */  1978, 1979, 2011, 1995, 1994, 1996, 1997, 1999, 2001,
};
#define YY_REDUCE_COUNT (279)
#define YY_REDUCE_MIN   (-350)
#define YY_REDUCE_MAX   (2645)
static const short yy_reduce_ofst[] = {
 /*     0 */   179, -252, -312,  882,   13,  281,  549,  992,  262, 1074,
 /*    10 */  1127, 1195, 1217, 1275, 1377,  530, 1436, 1491, 1544, 1595,
 /*    20 */  1612, 1697, 1748, 1811, 1831, 1882, 1899, 1942, 1993, 2010,
 /*    30 */  2061, 2112, 2131, 2194, 2216, 2276, 2296, 2339, 2359, 2410,
 /*    40 */  2461, 2480, 2543, 2565, 2625, 2645,   21,  279, -222,  198,
 /*    50 */   442,  465,  607,  924,  -97,  -28, -350, -347, -315, -340,
 /*    60 */   -61,  -63,  -26,   39,   96, -321, -317, -344, -311,    7,
 /*    70 */   238,  275,  312,  376,  379,  435,  436,  506, -230,  532,
 /*    80 */   543,  550, -189,  592,  640,  213,  645,  701, -245, -199,
 /*    90 */   704,  323,  102,  432,  758, -102,   56, -226, -226,  -89,
 /*   100 */  -228, -181,  292,  370,  409,  462,  469,  502,  508,  515,
 /*   110 */   529,  548,  597,  617,  633,  666,  669,  680,  687,  233,
 /*   120 */    17, -243, -265, -270, -125,  169,  -49, -179,  -36,   90,
 /*   130 */  -243,   49,  185,  274,  371,  464,  341,  347,  130,  339,
 /*   140 */   384,  377,  474,  368,  467,  560,  519, -332,  321,  424,
 /*   150 */   487,  583,  644,  702,  520,  399,  714,  677,  775,  719,
 /*   160 */   828,  737,  834,  834,  864,  867,  866,  807,  821,  821,
 /*   170 */   805,  821,  835,  827,  834,  865,  869,  877,  890,  933,
 /*   180 */   934,  894,  899,  901,  938,  946,  956,  963,  965,  975,
 /*   190 */   916,  968,  939,  970,  929,  932,  982,  940,  983,  987,
 /*   200 */   988,  993,  990, 1001,  976,  977,  978,  980,  981,  991,
 /*   210 */   994,  995,  996,  999, 1002, 1011, 1016,  997,  966,  969,
 /*   220 */  1023,  979, 1006, 1027, 1030, 1037,  998, 1036, 1000, 1013,
 /*   230 */  1014, 1018, 1020, 1012, 1021, 1022, 1065, 1051, 1067, 1042,
 /*   240 */  1015, 1019, 1040,  974, 1038, 1050, 1053,  984, 1044, 1055,
 /*   250 */  1056,  834, 1005, 1004, 1017, 1032, 1034, 1008, 1039,  985,
 /*   260 */   986, 1024,  821, 1084, 1048, 1031, 1091, 1102, 1106, 1134,
 /*   270 */  1136, 1155, 1161, 1097, 1104, 1138, 1142, 1145, 1162, 1174,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*    10 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*    20 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*    30 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*    40 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*    50 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*    60 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*    70 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1610, 1536,
 /*    80 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*    90 */  1536, 1536, 1536, 1536, 1536, 1608, 1775, 1962, 1536, 1536,
 /*   100 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   110 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   120 */  1536, 1974, 1536, 1536, 1536, 1610, 1536, 1608, 1934, 1934,
 /*   130 */  1974, 1974, 1974, 1536, 1536, 1536, 1715, 1536, 1816, 1816,
 /*   140 */  1536, 1536, 1536, 1536, 1536, 1715, 1536, 1536, 1536, 1536,
 /*   150 */  1536, 1536, 1536, 1536, 1810, 1536, 1999, 2052, 1536, 1536,
 /*   160 */  1536, 2002, 1536, 1536, 1536, 1536, 1668, 1989, 1966, 1980,
 /*   170 */  2036, 1967, 1964, 1983, 1536, 1993, 1536, 1803, 1780, 1536,
 /*   180 */  1536, 1780, 1777, 1777, 1659, 1536, 1536, 1536, 1536, 1536,
 /*   190 */  1536, 1610, 1536, 1610, 1536, 1536, 1610, 1536, 1610, 1610,
 /*   200 */  1610, 1536, 1610, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   210 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1822, 1536,
 /*   220 */  1608, 1812, 1536, 1608, 1536, 1536, 1536, 1608, 2007, 1536,
 /*   230 */  1536, 1536, 1536, 2007, 1536, 1536, 1608, 1536, 1608, 1536,
 /*   240 */  1536, 1536, 1536, 2009, 2007, 1536, 1536, 2009, 2007, 1536,
 /*   250 */  1536, 1536, 2021, 2017, 2009, 2025, 2023, 1995, 1993, 2055,
 /*   260 */  2042, 2038, 1980, 1536, 1536, 1536, 1684, 1536, 1536, 1536,
 /*   270 */  1608, 1568, 1536, 1805, 1816, 1718, 1718, 1718, 1611, 1541,
 /*   280 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   290 */  1536, 1891, 1536, 2020, 2019, 1938, 1937, 1936, 1927, 1890,
 /*   300 */  1536, 1680, 1889, 1888, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   310 */  1536, 1882, 1536, 1536, 1883, 1881, 1880, 1536, 1536, 1536,
 /*   320 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   330 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 2039, 2043, 1963,
 /*   340 */  1536, 1536, 1536, 1536, 1536, 1873, 1864, 1536, 1536, 1536,
 /*   350 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   360 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   370 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   380 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   390 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   400 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   410 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   420 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   430 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   440 */  1536, 1536, 1536, 1536, 1573, 1536, 1536, 1536, 1536, 1536,
 /*   450 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   460 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   470 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   480 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1649,
 /*   490 */  1648, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   500 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1872,
 /*   510 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   520 */  1536, 1536, 1536, 2035, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   530 */  1536, 1820, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   540 */  1536, 1924, 1536, 1536, 1536, 1996, 1536, 1536, 1536, 1536,
 /*   550 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   560 */  1536, 1864, 1536, 2018, 1536, 1536, 2033, 1536, 2037, 1536,
 /*   570 */  1536, 1536, 1536, 1536, 1536, 1536, 1973, 1969, 1536, 1536,
 /*   580 */  1965, 1863, 1536, 1958, 1536, 1536, 1909, 1536, 1536, 1536,
 /*   590 */  1536, 1536, 1536, 1536, 1536, 1536, 1872, 1536, 1876, 1536,
 /*   600 */  1536, 1536, 1536, 1536, 1712, 1536, 1536, 1536, 1536, 1536,
 /*   610 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1697, 1695, 1694,
 /*   620 */  1693, 1536, 1690, 1536, 1536, 1536, 1536, 1721, 1720, 1536,
 /*   630 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   640 */  1536, 1536, 1536, 1536, 1630, 1536, 1536, 1536, 1536, 1536,
 /*   650 */  1536, 1536, 1536, 1536, 1621, 1536, 1620, 1536, 1536, 1536,
 /*   660 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   670 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
 /*   680 */  1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536, 1536,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       CASE => nothing */
  264,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  264,  /*      AFTER => ABORT */
  264,  /*     ATTACH => ABORT */
  264,  /*     BEFORE => ABORT */
  264,  /*      BEGIN => ABORT */
  264,  /*     BITAND => ABORT */
  264,  /*     BITNOT => ABORT */
  264,  /*      BITOR => ABORT */
  264,  /*     BLOCKS => ABORT */
  264,  /*     CHANGE => ABORT */
  264,  /*      COMMA => ABORT */
  264,  /*    COMPACT => ABORT */
  264,  /*     CONCAT => ABORT */
  264,  /*   CONFLICT => ABORT */
  264,  /*       COPY => ABORT */
  264,  /*   DEFERRED => ABORT */
  264,  /* DELIMITERS => ABORT */
  264,  /*     DETACH => ABORT */
  264,  /*     DIVIDE => ABORT */
  264,  /*        DOT => ABORT */
  264,  /*       EACH => ABORT */
  264,  /*       FAIL => ABORT */
  264,  /*       FILE => ABORT */
  264,  /*        FOR => ABORT */
  264,  /*       GLOB => ABORT */
  264,  /*         ID => ABORT */
  264,  /*  IMMEDIATE => ABORT */
  264,  /*     IMPORT => ABORT */
  264,  /*  INITIALLY => ABORT */
  264,  /*    INSTEAD => ABORT */
  264,  /*     ISNULL => ABORT */
  264,  /*        KEY => ABORT */
  264,  /*  NK_BITNOT => ABORT */
  264,  /*    NK_SEMI => ABORT */
  264,  /*    NOTNULL => ABORT */
  264,  /*         OF => ABORT */
  264,  /*       PLUS => ABORT */
  264,  /*  PRIVILEGE => ABORT */
  264,  /*      RAISE => ABORT */
  264,  /*    REPLACE => ABORT */
  264,  /*   RESTRICT => ABORT */
  264,  /*        ROW => ABORT */
  264,  /*       SEMI => ABORT */
  264,  /*       STAR => ABORT */
  264,  /*  STATEMENT => ABORT */
  264,  /*     STRING => ABORT */
  264,  /*      TIMES => ABORT */
  264,  /*     UPDATE => ABORT */
  264,  /*     VALUES => ABORT */
  264,  /*   VARIABLE => ABORT */
  264,  /*       VIEW => ABORT */
  264,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "TRIM",
  /*   60 */ "IF",
  /*   61 */ "NOT",
  /*   62 */ "EXISTS",
  /*   63 */ "BUFFER",
  /*   64 */ "CACHEMODEL",
  /*   65 */ "CACHESIZE",
  /*   66 */ "COMP",
  /*   67 */ "DURATION",
  /*   68 */ "NK_VARIABLE",
  /*   69 */ "MAXROWS",
  /*   70 */ "MINROWS",
  /*   71 */ "KEEP",
  /*   72 */ "PAGES",
  /*   73 */ "PAGESIZE",
  /*   74 */ "TSDB_PAGESIZE",
  /*   75 */ "PRECISION",
  /*   76 */ "REPLICA",
  /*   77 */ "STRICT",
  /*   78 */ "VGROUPS",
  /*   79 */ "SINGLE_STABLE",
  /*   80 */ "RETENTIONS",
  /*   81 */ "SCHEMALESS",
  /*   82 */ "WAL_LEVEL",
  /*   83 */ "WAL_FSYNC_PERIOD",
  /*   84 */ "WAL_RETENTION_PERIOD",
  /*   85 */ "WAL_RETENTION_SIZE",
  /*   86 */ "WAL_ROLL_PERIOD",
  /*   87 */ "WAL_SEGMENT_SIZE",
  /*   88 */ "STT_TRIGGER",
  /*   89 */ "TABLE_PREFIX",
  /*   90 */ "TABLE_SUFFIX",
  /*   91 */ "NK_COLON",
  /*   92 */ "MAX_SPEED",
  /*   93 */ "TABLE",
  /*   94 */ "NK_LP",
  /*   95 */ "NK_RP",
  /*   96 */ "STABLE",
  /*   97 */ "ADD",
  /*   98 */ "COLUMN",
  /*   99 */ "MODIFY",
  /*  100 */ "RENAME",
  /*  101 */ "TAG",
  /*  102 */ "SET",
  /*  103 */ "NK_EQ",
  /*  104 */ "USING",
  /*  105 */ "TAGS",
  /*  106 */ "COMMENT",
  /*  107 */ "BOOL",
  /*  108 */ "TINYINT",
  /*  109 */ "SMALLINT",
  /*  110 */ "INT",
  /*  111 */ "INTEGER",
  /*  112 */ "BIGINT",
  /*  113 */ "FLOAT",
  /*  114 */ "DOUBLE",
  /*  115 */ "BINARY",
  /*  116 */ "TIMESTAMP",
  /*  117 */ "NCHAR",
  /*  118 */ "UNSIGNED",
  /*  119 */ "JSON",
  /*  120 */ "VARCHAR",
  /*  121 */ "MEDIUMBLOB",
  /*  122 */ "BLOB",
  /*  123 */ "VARBINARY",
  /*  124 */ "DECIMAL",
  /*  125 */ "MAX_DELAY",
  /*  126 */ "WATERMARK",
  /*  127 */ "ROLLUP",
  /*  128 */ "TTL",
  /*  129 */ "SMA",
  /*  130 */ "FIRST",
  /*  131 */ "LAST",
  /*  132 */ "SHOW",
  /*  133 */ "DATABASES",
  /*  134 */ "TABLES",
  /*  135 */ "STABLES",
  /*  136 */ "MNODES",
  /*  137 */ "MODULES",
  /*  138 */ "QNODES",
  /*  139 */ "FUNCTIONS",
  /*  140 */ "INDEXES",
  /*  141 */ "ACCOUNTS",
  /*  142 */ "APPS",
  /*  143 */ "CONNECTIONS",
  /*  144 */ "LICENCES",
  /*  145 */ "GRANTS",
  /*  146 */ "QUERIES",
  /*  147 */ "SCORES",
  /*  148 */ "TOPICS",
  /*  149 */ "VARIABLES",
  /*  150 */ "BNODES",
  /*  151 */ "SNODES",
  /*  152 */ "CLUSTER",
  /*  153 */ "TRANSACTIONS",
  /*  154 */ "DISTRIBUTED",
  /*  155 */ "CONSUMERS",
  /*  156 */ "SUBSCRIPTIONS",
  /*  157 */ "VNODES",
  /*  158 */ "LIKE",
  /*  159 */ "INDEX",
  /*  160 */ "FUNCTION",
  /*  161 */ "INTERVAL",
  /*  162 */ "TOPIC",
  /*  163 */ "AS",
  /*  164 */ "WITH",
  /*  165 */ "META",
  /*  166 */ "CONSUMER",
  /*  167 */ "GROUP",
  /*  168 */ "DESC",
  /*  169 */ "DESCRIBE",
  /*  170 */ "RESET",
  /*  171 */ "QUERY",
  /*  172 */ "CACHE",
  /*  173 */ "EXPLAIN",
  /*  174 */ "ANALYZE",
  /*  175 */ "VERBOSE",
  /*  176 */ "NK_BOOL",
  /*  177 */ "RATIO",
  /*  178 */ "NK_FLOAT",
  /*  179 */ "OUTPUTTYPE",
  /*  180 */ "AGGREGATE",
  /*  181 */ "BUFSIZE",
  /*  182 */ "STREAM",
  /*  183 */ "INTO",
  /*  184 */ "TRIGGER",
  /*  185 */ "AT_ONCE",
  /*  186 */ "WINDOW_CLOSE",
  /*  187 */ "IGNORE",
  /*  188 */ "EXPIRED",
  /*  189 */ "SUBTABLE",
  /*  190 */ "KILL",
  /*  191 */ "CONNECTION",
  /*  192 */ "TRANSACTION",
  /*  193 */ "BALANCE",
  /*  194 */ "VGROUP",
  /*  195 */ "MERGE",
  /*  196 */ "REDISTRIBUTE",
  /*  197 */ "SPLIT",
  /*  198 */ "DELETE",
  /*  199 */ "INSERT",
  /*  200 */ "NULL",
  /*  201 */ "NK_QUESTION",
  /*  202 */ "NK_ARROW",
  /*  203 */ "ROWTS",
  /*  204 */ "TBNAME",
  /*  205 */ "QSTART",
  /*  206 */ "QEND",
  /*  207 */ "QDURATION",
  /*  208 */ "WSTART",
  /*  209 */ "WEND",
  /*  210 */ "WDURATION",
  /*  211 */ "IROWTS",
  /*  212 */ "CAST",
  /*  213 */ "NOW",
  /*  214 */ "TODAY",
  /*  215 */ "TIMEZONE",
  /*  216 */ "CLIENT_VERSION",
  /*  217 */ "SERVER_VERSION",
  /*  218 */ "SERVER_STATUS",
  /*  219 */ "CURRENT_USER",
  /*  220 */ "COUNT",
  /*  221 */ "LAST_ROW",
  /*  222 */ "CASE",
  /*  223 */ "END",
  /*  224 */ "WHEN",
  /*  225 */ "THEN",
  /*  226 */ "ELSE",
  /*  227 */ "BETWEEN",
  /*  228 */ "IS",
  /*  229 */ "NK_LT",
  /*  230 */ "NK_GT",
  /*  231 */ "NK_LE",
  /*  232 */ "NK_GE",
  /*  233 */ "NK_NE",
  /*  234 */ "MATCH",
  /*  235 */ "NMATCH",
  /*  236 */ "CONTAINS",
  /*  237 */ "IN",
  /*  238 */ "JOIN",
  /*  239 */ "INNER",
  /*  240 */ "SELECT",
  /*  241 */ "DISTINCT",
  /*  242 */ "WHERE",
  /*  243 */ "PARTITION",
  /*  244 */ "BY",
  /*  245 */ "SESSION",
  /*  246 */ "STATE_WINDOW",
  /*  247 */ "SLIDING",
  /*  248 */ "FILL",
  /*  249 */ "VALUE",
  /*  250 */ "NONE",
  /*  251 */ "PREV",
  /*  252 */ "LINEAR",
  /*  253 */ "NEXT",
  /*  254 */ "HAVING",
  /*  255 */ "RANGE",
  /*  256 */ "EVERY",
  /*  257 */ "ORDER",
  /*  258 */ "SLIMIT",
  /*  259 */ "SOFFSET",
  /*  260 */ "LIMIT",
  /*  261 */ "OFFSET",
  /*  262 */ "ASC",
  /*  263 */ "NULLS",
  /*  264 */ "ABORT",
  /*  265 */ "AFTER",
  /*  266 */ "ATTACH",
  /*  267 */ "BEFORE",
  /*  268 */ "BEGIN",
  /*  269 */ "BITAND",
  /*  270 */ "BITNOT",
  /*  271 */ "BITOR",
  /*  272 */ "BLOCKS",
  /*  273 */ "CHANGE",
  /*  274 */ "COMMA",
  /*  275 */ "COMPACT",
  /*  276 */ "CONCAT",
  /*  277 */ "CONFLICT",
  /*  278 */ "COPY",
  /*  279 */ "DEFERRED",
  /*  280 */ "DELIMITERS",
  /*  281 */ "DETACH",
  /*  282 */ "DIVIDE",
  /*  283 */ "DOT",
  /*  284 */ "EACH",
  /*  285 */ "FAIL",
  /*  286 */ "FILE",
  /*  287 */ "FOR",
  /*  288 */ "GLOB",
  /*  289 */ "ID",
  /*  290 */ "IMMEDIATE",
  /*  291 */ "IMPORT",
  /*  292 */ "INITIALLY",
  /*  293 */ "INSTEAD",
  /*  294 */ "ISNULL",
  /*  295 */ "KEY",
  /*  296 */ "NK_BITNOT",
  /*  297 */ "NK_SEMI",
  /*  298 */ "NOTNULL",
  /*  299 */ "OF",
  /*  300 */ "PLUS",
  /*  301 */ "PRIVILEGE",
  /*  302 */ "RAISE",
  /*  303 */ "REPLACE",
  /*  304 */ "RESTRICT",
  /*  305 */ "ROW",
  /*  306 */ "SEMI",
  /*  307 */ "STAR",
  /*  308 */ "STATEMENT",
  /*  309 */ "STRING",
  /*  310 */ "TIMES",
  /*  311 */ "UPDATE",
  /*  312 */ "VALUES",
  /*  313 */ "VARIABLE",
  /*  314 */ "VIEW",
  /*  315 */ "WAL",
  /*  316 */ "cmd",
  /*  317 */ "account_options",
  /*  318 */ "alter_account_options",
  /*  319 */ "literal",
  /*  320 */ "alter_account_option",
  /*  321 */ "user_name",
  /*  322 */ "sysinfo_opt",
  /*  323 */ "privileges",
  /*  324 */ "priv_level",
  /*  325 */ "priv_type_list",
  /*  326 */ "priv_type",
  /*  327 */ "db_name",
  /*  328 */ "dnode_endpoint",
  /*  329 */ "not_exists_opt",
  /*  330 */ "db_options",
  /*  331 */ "exists_opt",
  /*  332 */ "alter_db_options",
  /*  333 */ "speed_opt",
  /*  334 */ "integer_list",
  /*  335 */ "variable_list",
  /*  336 */ "retention_list",
  /*  337 */ "alter_db_option",
  /*  338 */ "retention",
  /*  339 */ "full_table_name",
  /*  340 */ "column_def_list",
  /*  341 */ "tags_def_opt",
  /*  342 */ "table_options",
  /*  343 */ "multi_create_clause",
  /*  344 */ "tags_def",
  /*  345 */ "multi_drop_clause",
  /*  346 */ "alter_table_clause",
  /*  347 */ "alter_table_options",
  /*  348 */ "column_name",
  /*  349 */ "type_name",
  /*  350 */ "signed_literal",
  /*  351 */ "create_subtable_clause",
  /*  352 */ "specific_cols_opt",
  /*  353 */ "expression_list",
  /*  354 */ "drop_table_clause",
  /*  355 */ "col_name_list",
  /*  356 */ "table_name",
  /*  357 */ "column_def",
  /*  358 */ "duration_list",
  /*  359 */ "rollup_func_list",
  /*  360 */ "alter_table_option",
  /*  361 */ "duration_literal",
  /*  362 */ "rollup_func_name",
  /*  363 */ "function_name",
  /*  364 */ "col_name",
  /*  365 */ "db_name_cond_opt",
  /*  366 */ "like_pattern_opt",
  /*  367 */ "table_name_cond",
  /*  368 */ "from_db_opt",
  /*  369 */ "index_options",
  /*  370 */ "func_list",
  /*  371 */ "sliding_opt",
  /*  372 */ "sma_stream_opt",
  /*  373 */ "func",
  /*  374 */ "stream_options",
  /*  375 */ "topic_name",
  /*  376 */ "query_or_subquery",
  /*  377 */ "cgroup_name",
  /*  378 */ "analyze_opt",
  /*  379 */ "explain_options",
  /*  380 */ "agg_func_opt",
  /*  381 */ "bufsize_opt",
  /*  382 */ "stream_name",
  /*  383 */ "subtable_opt",
  /*  384 */ "expression",
  /*  385 */ "dnode_list",
  /*  386 */ "where_clause_opt",
  /*  387 */ "signed",
  /*  388 */ "literal_func",
  /*  389 */ "literal_list",
  /*  390 */ "table_alias",
  /*  391 */ "column_alias",
  /*  392 */ "expr_or_subquery",
  /*  393 */ "subquery",
  /*  394 */ "pseudo_column",
  /*  395 */ "column_reference",
  /*  396 */ "function_expression",
  /*  397 */ "case_when_expression",
  /*  398 */ "star_func",
  /*  399 */ "star_func_para_list",
  /*  400 */ "noarg_func",
  /*  401 */ "other_para_list",
  /*  402 */ "star_func_para",
  /*  403 */ "when_then_list",
  /*  404 */ "case_when_else_opt",
  /*  405 */ "common_expression",
  /*  406 */ "when_then_expr",
  /*  407 */ "predicate",
  /*  408 */ "compare_op",
  /*  409 */ "in_op",
  /*  410 */ "in_predicate_value",
  /*  411 */ "boolean_value_expression",
  /*  412 */ "boolean_primary",
  /*  413 */ "from_clause_opt",
  /*  414 */ "table_reference_list",
  /*  415 */ "table_reference",
  /*  416 */ "table_primary",
  /*  417 */ "joined_table",
  /*  418 */ "alias_opt",
  /*  419 */ "parenthesized_joined_table",
  /*  420 */ "join_type",
  /*  421 */ "search_condition",
  /*  422 */ "query_specification",
  /*  423 */ "set_quantifier_opt",
  /*  424 */ "select_list",
  /*  425 */ "partition_by_clause_opt",
  /*  426 */ "range_opt",
  /*  427 */ "every_opt",
  /*  428 */ "fill_opt",
  /*  429 */ "twindow_clause_opt",
  /*  430 */ "group_by_clause_opt",
  /*  431 */ "having_clause_opt",
  /*  432 */ "select_item",
  /*  433 */ "partition_list",
  /*  434 */ "partition_item",
  /*  435 */ "fill_mode",
  /*  436 */ "group_by_list",
  /*  437 */ "query_expression",
  /*  438 */ "query_simple",
  /*  439 */ "order_by_clause_opt",
  /*  440 */ "slimit_clause_opt",
  /*  441 */ "limit_clause_opt",
  /*  442 */ "union_query_expression",
  /*  443 */ "query_simple_or_subquery",
  /*  444 */ "sort_specification_list",
  /*  445 */ "sort_specification",
  /*  446 */ "ordering_specification_opt",
  /*  447 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  68 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  69 */ "not_exists_opt ::=",
 /*  70 */ "exists_opt ::= IF EXISTS",
 /*  71 */ "exists_opt ::=",
 /*  72 */ "db_options ::=",
 /*  73 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  75 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  76 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  78 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  79 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  80 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options KEEP integer_list",
 /*  82 */ "db_options ::= db_options KEEP variable_list",
 /*  83 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  84 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  85 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  86 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  87 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  88 */ "db_options ::= db_options STRICT NK_STRING",
 /*  89 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  90 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  91 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  92 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  93 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  94 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  95 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 102 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 103 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 104 */ "alter_db_options ::= alter_db_option",
 /* 105 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 106 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 107 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 108 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 109 */ "alter_db_option ::= KEEP integer_list",
 /* 110 */ "alter_db_option ::= KEEP variable_list",
 /* 111 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 112 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 113 */ "integer_list ::= NK_INTEGER",
 /* 114 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 115 */ "variable_list ::= NK_VARIABLE",
 /* 116 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 117 */ "retention_list ::= retention",
 /* 118 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 119 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 120 */ "speed_opt ::=",
 /* 121 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 122 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 123 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 124 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 125 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 126 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 127 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 128 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 129 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 130 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 131 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 132 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 133 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 134 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 135 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 136 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 138 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 139 */ "multi_create_clause ::= create_subtable_clause",
 /* 140 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 141 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 142 */ "multi_drop_clause ::= drop_table_clause",
 /* 143 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 144 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 145 */ "specific_cols_opt ::=",
 /* 146 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 147 */ "full_table_name ::= table_name",
 /* 148 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 149 */ "column_def_list ::= column_def",
 /* 150 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 151 */ "column_def ::= column_name type_name",
 /* 152 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 153 */ "type_name ::= BOOL",
 /* 154 */ "type_name ::= TINYINT",
 /* 155 */ "type_name ::= SMALLINT",
 /* 156 */ "type_name ::= INT",
 /* 157 */ "type_name ::= INTEGER",
 /* 158 */ "type_name ::= BIGINT",
 /* 159 */ "type_name ::= FLOAT",
 /* 160 */ "type_name ::= DOUBLE",
 /* 161 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 162 */ "type_name ::= TIMESTAMP",
 /* 163 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 164 */ "type_name ::= TINYINT UNSIGNED",
 /* 165 */ "type_name ::= SMALLINT UNSIGNED",
 /* 166 */ "type_name ::= INT UNSIGNED",
 /* 167 */ "type_name ::= BIGINT UNSIGNED",
 /* 168 */ "type_name ::= JSON",
 /* 169 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= MEDIUMBLOB",
 /* 171 */ "type_name ::= BLOB",
 /* 172 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 173 */ "type_name ::= DECIMAL",
 /* 174 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 175 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 176 */ "tags_def_opt ::=",
 /* 177 */ "tags_def_opt ::= tags_def",
 /* 178 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 179 */ "table_options ::=",
 /* 180 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 181 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 182 */ "table_options ::= table_options WATERMARK duration_list",
 /* 183 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 184 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 185 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 186 */ "alter_table_options ::= alter_table_option",
 /* 187 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 188 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 189 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 190 */ "duration_list ::= duration_literal",
 /* 191 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 192 */ "rollup_func_list ::= rollup_func_name",
 /* 193 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 194 */ "rollup_func_name ::= function_name",
 /* 195 */ "rollup_func_name ::= FIRST",
 /* 196 */ "rollup_func_name ::= LAST",
 /* 197 */ "col_name_list ::= col_name",
 /* 198 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 199 */ "col_name ::= column_name",
 /* 200 */ "cmd ::= SHOW DNODES",
 /* 201 */ "cmd ::= SHOW USERS",
 /* 202 */ "cmd ::= SHOW DATABASES",
 /* 203 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 204 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 205 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 206 */ "cmd ::= SHOW MNODES",
 /* 207 */ "cmd ::= SHOW MODULES",
 /* 208 */ "cmd ::= SHOW QNODES",
 /* 209 */ "cmd ::= SHOW FUNCTIONS",
 /* 210 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 211 */ "cmd ::= SHOW STREAMS",
 /* 212 */ "cmd ::= SHOW ACCOUNTS",
 /* 213 */ "cmd ::= SHOW APPS",
 /* 214 */ "cmd ::= SHOW CONNECTIONS",
 /* 215 */ "cmd ::= SHOW LICENCES",
 /* 216 */ "cmd ::= SHOW GRANTS",
 /* 217 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 218 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 219 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 220 */ "cmd ::= SHOW QUERIES",
 /* 221 */ "cmd ::= SHOW SCORES",
 /* 222 */ "cmd ::= SHOW TOPICS",
 /* 223 */ "cmd ::= SHOW VARIABLES",
 /* 224 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 225 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 226 */ "cmd ::= SHOW BNODES",
 /* 227 */ "cmd ::= SHOW SNODES",
 /* 228 */ "cmd ::= SHOW CLUSTER",
 /* 229 */ "cmd ::= SHOW TRANSACTIONS",
 /* 230 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 231 */ "cmd ::= SHOW CONSUMERS",
 /* 232 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 233 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 234 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 235 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 236 */ "db_name_cond_opt ::=",
 /* 237 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 238 */ "like_pattern_opt ::=",
 /* 239 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 240 */ "table_name_cond ::= table_name",
 /* 241 */ "from_db_opt ::=",
 /* 242 */ "from_db_opt ::= FROM db_name",
 /* 243 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 244 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 245 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 246 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 247 */ "func_list ::= func",
 /* 248 */ "func_list ::= func_list NK_COMMA func",
 /* 249 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 250 */ "sma_stream_opt ::=",
 /* 251 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 252 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 253 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 254 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 255 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 256 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 257 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 258 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 259 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 260 */ "cmd ::= DESC full_table_name",
 /* 261 */ "cmd ::= DESCRIBE full_table_name",
 /* 262 */ "cmd ::= RESET QUERY CACHE",
 /* 263 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 264 */ "analyze_opt ::=",
 /* 265 */ "analyze_opt ::= ANALYZE",
 /* 266 */ "explain_options ::=",
 /* 267 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 268 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 269 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 270 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 271 */ "agg_func_opt ::=",
 /* 272 */ "agg_func_opt ::= AGGREGATE",
 /* 273 */ "bufsize_opt ::=",
 /* 274 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 275 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 276 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 277 */ "stream_options ::=",
 /* 278 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 279 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 280 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 281 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 282 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 283 */ "subtable_opt ::=",
 /* 284 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 285 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 286 */ "cmd ::= KILL QUERY NK_STRING",
 /* 287 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 288 */ "cmd ::= BALANCE VGROUP",
 /* 289 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 290 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 291 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 292 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 293 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 294 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 295 */ "cmd ::= query_or_subquery",
 /* 296 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 297 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 298 */ "literal ::= NK_INTEGER",
 /* 299 */ "literal ::= NK_FLOAT",
 /* 300 */ "literal ::= NK_STRING",
 /* 301 */ "literal ::= NK_BOOL",
 /* 302 */ "literal ::= TIMESTAMP NK_STRING",
 /* 303 */ "literal ::= duration_literal",
 /* 304 */ "literal ::= NULL",
 /* 305 */ "literal ::= NK_QUESTION",
 /* 306 */ "duration_literal ::= NK_VARIABLE",
 /* 307 */ "signed ::= NK_INTEGER",
 /* 308 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 309 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 310 */ "signed ::= NK_FLOAT",
 /* 311 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 312 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 313 */ "signed_literal ::= signed",
 /* 314 */ "signed_literal ::= NK_STRING",
 /* 315 */ "signed_literal ::= NK_BOOL",
 /* 316 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 317 */ "signed_literal ::= duration_literal",
 /* 318 */ "signed_literal ::= NULL",
 /* 319 */ "signed_literal ::= literal_func",
 /* 320 */ "signed_literal ::= NK_QUESTION",
 /* 321 */ "literal_list ::= signed_literal",
 /* 322 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 323 */ "db_name ::= NK_ID",
 /* 324 */ "table_name ::= NK_ID",
 /* 325 */ "column_name ::= NK_ID",
 /* 326 */ "function_name ::= NK_ID",
 /* 327 */ "table_alias ::= NK_ID",
 /* 328 */ "column_alias ::= NK_ID",
 /* 329 */ "user_name ::= NK_ID",
 /* 330 */ "topic_name ::= NK_ID",
 /* 331 */ "stream_name ::= NK_ID",
 /* 332 */ "cgroup_name ::= NK_ID",
 /* 333 */ "expr_or_subquery ::= expression",
 /* 334 */ "expr_or_subquery ::= subquery",
 /* 335 */ "expression ::= literal",
 /* 336 */ "expression ::= pseudo_column",
 /* 337 */ "expression ::= column_reference",
 /* 338 */ "expression ::= function_expression",
 /* 339 */ "expression ::= case_when_expression",
 /* 340 */ "expression ::= NK_LP expression NK_RP",
 /* 341 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 342 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 343 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 344 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 345 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 346 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 347 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 348 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 349 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 350 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 351 */ "expression_list ::= expr_or_subquery",
 /* 352 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 353 */ "column_reference ::= column_name",
 /* 354 */ "column_reference ::= table_name NK_DOT column_name",
 /* 355 */ "pseudo_column ::= ROWTS",
 /* 356 */ "pseudo_column ::= TBNAME",
 /* 357 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 358 */ "pseudo_column ::= QSTART",
 /* 359 */ "pseudo_column ::= QEND",
 /* 360 */ "pseudo_column ::= QDURATION",
 /* 361 */ "pseudo_column ::= WSTART",
 /* 362 */ "pseudo_column ::= WEND",
 /* 363 */ "pseudo_column ::= WDURATION",
 /* 364 */ "pseudo_column ::= IROWTS",
 /* 365 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 366 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 367 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 368 */ "function_expression ::= literal_func",
 /* 369 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 370 */ "literal_func ::= NOW",
 /* 371 */ "noarg_func ::= NOW",
 /* 372 */ "noarg_func ::= TODAY",
 /* 373 */ "noarg_func ::= TIMEZONE",
 /* 374 */ "noarg_func ::= DATABASE",
 /* 375 */ "noarg_func ::= CLIENT_VERSION",
 /* 376 */ "noarg_func ::= SERVER_VERSION",
 /* 377 */ "noarg_func ::= SERVER_STATUS",
 /* 378 */ "noarg_func ::= CURRENT_USER",
 /* 379 */ "noarg_func ::= USER",
 /* 380 */ "star_func ::= COUNT",
 /* 381 */ "star_func ::= FIRST",
 /* 382 */ "star_func ::= LAST",
 /* 383 */ "star_func ::= LAST_ROW",
 /* 384 */ "star_func_para_list ::= NK_STAR",
 /* 385 */ "star_func_para_list ::= other_para_list",
 /* 386 */ "other_para_list ::= star_func_para",
 /* 387 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 388 */ "star_func_para ::= expr_or_subquery",
 /* 389 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 390 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 391 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 392 */ "when_then_list ::= when_then_expr",
 /* 393 */ "when_then_list ::= when_then_list when_then_expr",
 /* 394 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 395 */ "case_when_else_opt ::=",
 /* 396 */ "case_when_else_opt ::= ELSE common_expression",
 /* 397 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 398 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 399 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 400 */ "predicate ::= expr_or_subquery IS NULL",
 /* 401 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 402 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 403 */ "compare_op ::= NK_LT",
 /* 404 */ "compare_op ::= NK_GT",
 /* 405 */ "compare_op ::= NK_LE",
 /* 406 */ "compare_op ::= NK_GE",
 /* 407 */ "compare_op ::= NK_NE",
 /* 408 */ "compare_op ::= NK_EQ",
 /* 409 */ "compare_op ::= LIKE",
 /* 410 */ "compare_op ::= NOT LIKE",
 /* 411 */ "compare_op ::= MATCH",
 /* 412 */ "compare_op ::= NMATCH",
 /* 413 */ "compare_op ::= CONTAINS",
 /* 414 */ "in_op ::= IN",
 /* 415 */ "in_op ::= NOT IN",
 /* 416 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 417 */ "boolean_value_expression ::= boolean_primary",
 /* 418 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 419 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 420 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 421 */ "boolean_primary ::= predicate",
 /* 422 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 423 */ "common_expression ::= expr_or_subquery",
 /* 424 */ "common_expression ::= boolean_value_expression",
 /* 425 */ "from_clause_opt ::=",
 /* 426 */ "from_clause_opt ::= FROM table_reference_list",
 /* 427 */ "table_reference_list ::= table_reference",
 /* 428 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 429 */ "table_reference ::= table_primary",
 /* 430 */ "table_reference ::= joined_table",
 /* 431 */ "table_primary ::= table_name alias_opt",
 /* 432 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 433 */ "table_primary ::= subquery alias_opt",
 /* 434 */ "table_primary ::= parenthesized_joined_table",
 /* 435 */ "alias_opt ::=",
 /* 436 */ "alias_opt ::= table_alias",
 /* 437 */ "alias_opt ::= AS table_alias",
 /* 438 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 439 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 440 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 441 */ "join_type ::=",
 /* 442 */ "join_type ::= INNER",
 /* 443 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 444 */ "set_quantifier_opt ::=",
 /* 445 */ "set_quantifier_opt ::= DISTINCT",
 /* 446 */ "set_quantifier_opt ::= ALL",
 /* 447 */ "select_list ::= select_item",
 /* 448 */ "select_list ::= select_list NK_COMMA select_item",
 /* 449 */ "select_item ::= NK_STAR",
 /* 450 */ "select_item ::= common_expression",
 /* 451 */ "select_item ::= common_expression column_alias",
 /* 452 */ "select_item ::= common_expression AS column_alias",
 /* 453 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 454 */ "where_clause_opt ::=",
 /* 455 */ "where_clause_opt ::= WHERE search_condition",
 /* 456 */ "partition_by_clause_opt ::=",
 /* 457 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 458 */ "partition_list ::= partition_item",
 /* 459 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 460 */ "partition_item ::= expr_or_subquery",
 /* 461 */ "partition_item ::= expr_or_subquery column_alias",
 /* 462 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 463 */ "twindow_clause_opt ::=",
 /* 464 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 465 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 466 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 467 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 468 */ "sliding_opt ::=",
 /* 469 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 470 */ "fill_opt ::=",
 /* 471 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 472 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 473 */ "fill_mode ::= NONE",
 /* 474 */ "fill_mode ::= PREV",
 /* 475 */ "fill_mode ::= NULL",
 /* 476 */ "fill_mode ::= LINEAR",
 /* 477 */ "fill_mode ::= NEXT",
 /* 478 */ "group_by_clause_opt ::=",
 /* 479 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 480 */ "group_by_list ::= expr_or_subquery",
 /* 481 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 482 */ "having_clause_opt ::=",
 /* 483 */ "having_clause_opt ::= HAVING search_condition",
 /* 484 */ "range_opt ::=",
 /* 485 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 486 */ "every_opt ::=",
 /* 487 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 488 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 489 */ "query_simple ::= query_specification",
 /* 490 */ "query_simple ::= union_query_expression",
 /* 491 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 492 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 493 */ "query_simple_or_subquery ::= query_simple",
 /* 494 */ "query_simple_or_subquery ::= subquery",
 /* 495 */ "query_or_subquery ::= query_expression",
 /* 496 */ "query_or_subquery ::= subquery",
 /* 497 */ "order_by_clause_opt ::=",
 /* 498 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 499 */ "slimit_clause_opt ::=",
 /* 500 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 501 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 502 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 503 */ "limit_clause_opt ::=",
 /* 504 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 505 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 506 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 507 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 508 */ "subquery ::= NK_LP subquery NK_RP",
 /* 509 */ "search_condition ::= common_expression",
 /* 510 */ "sort_specification_list ::= sort_specification",
 /* 511 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 512 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 513 */ "ordering_specification_opt ::=",
 /* 514 */ "ordering_specification_opt ::= ASC",
 /* 515 */ "ordering_specification_opt ::= DESC",
 /* 516 */ "null_ordering_opt ::=",
 /* 517 */ "null_ordering_opt ::= NULLS FIRST",
 /* 518 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 316: /* cmd */
    case 319: /* literal */
    case 330: /* db_options */
    case 332: /* alter_db_options */
    case 338: /* retention */
    case 339: /* full_table_name */
    case 342: /* table_options */
    case 346: /* alter_table_clause */
    case 347: /* alter_table_options */
    case 350: /* signed_literal */
    case 351: /* create_subtable_clause */
    case 354: /* drop_table_clause */
    case 357: /* column_def */
    case 361: /* duration_literal */
    case 362: /* rollup_func_name */
    case 364: /* col_name */
    case 365: /* db_name_cond_opt */
    case 366: /* like_pattern_opt */
    case 367: /* table_name_cond */
    case 368: /* from_db_opt */
    case 369: /* index_options */
    case 371: /* sliding_opt */
    case 372: /* sma_stream_opt */
    case 373: /* func */
    case 374: /* stream_options */
    case 376: /* query_or_subquery */
    case 379: /* explain_options */
    case 383: /* subtable_opt */
    case 384: /* expression */
    case 386: /* where_clause_opt */
    case 387: /* signed */
    case 388: /* literal_func */
    case 392: /* expr_or_subquery */
    case 393: /* subquery */
    case 394: /* pseudo_column */
    case 395: /* column_reference */
    case 396: /* function_expression */
    case 397: /* case_when_expression */
    case 402: /* star_func_para */
    case 404: /* case_when_else_opt */
    case 405: /* common_expression */
    case 406: /* when_then_expr */
    case 407: /* predicate */
    case 410: /* in_predicate_value */
    case 411: /* boolean_value_expression */
    case 412: /* boolean_primary */
    case 413: /* from_clause_opt */
    case 414: /* table_reference_list */
    case 415: /* table_reference */
    case 416: /* table_primary */
    case 417: /* joined_table */
    case 419: /* parenthesized_joined_table */
    case 421: /* search_condition */
    case 422: /* query_specification */
    case 426: /* range_opt */
    case 427: /* every_opt */
    case 428: /* fill_opt */
    case 429: /* twindow_clause_opt */
    case 431: /* having_clause_opt */
    case 432: /* select_item */
    case 434: /* partition_item */
    case 437: /* query_expression */
    case 438: /* query_simple */
    case 440: /* slimit_clause_opt */
    case 441: /* limit_clause_opt */
    case 442: /* union_query_expression */
    case 443: /* query_simple_or_subquery */
    case 445: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy616)); 
}
      break;
    case 317: /* account_options */
    case 318: /* alter_account_options */
    case 320: /* alter_account_option */
    case 333: /* speed_opt */
    case 381: /* bufsize_opt */
{
 
}
      break;
    case 321: /* user_name */
    case 324: /* priv_level */
    case 327: /* db_name */
    case 328: /* dnode_endpoint */
    case 348: /* column_name */
    case 356: /* table_name */
    case 363: /* function_name */
    case 375: /* topic_name */
    case 377: /* cgroup_name */
    case 382: /* stream_name */
    case 390: /* table_alias */
    case 391: /* column_alias */
    case 398: /* star_func */
    case 400: /* noarg_func */
    case 418: /* alias_opt */
{
 
}
      break;
    case 322: /* sysinfo_opt */
{
 
}
      break;
    case 323: /* privileges */
    case 325: /* priv_type_list */
    case 326: /* priv_type */
{
 
}
      break;
    case 329: /* not_exists_opt */
    case 331: /* exists_opt */
    case 378: /* analyze_opt */
    case 380: /* agg_func_opt */
    case 423: /* set_quantifier_opt */
{
 
}
      break;
    case 334: /* integer_list */
    case 335: /* variable_list */
    case 336: /* retention_list */
    case 340: /* column_def_list */
    case 341: /* tags_def_opt */
    case 343: /* multi_create_clause */
    case 344: /* tags_def */
    case 345: /* multi_drop_clause */
    case 352: /* specific_cols_opt */
    case 353: /* expression_list */
    case 355: /* col_name_list */
    case 358: /* duration_list */
    case 359: /* rollup_func_list */
    case 370: /* func_list */
    case 385: /* dnode_list */
    case 389: /* literal_list */
    case 399: /* star_func_para_list */
    case 401: /* other_para_list */
    case 403: /* when_then_list */
    case 424: /* select_list */
    case 425: /* partition_by_clause_opt */
    case 430: /* group_by_clause_opt */
    case 433: /* partition_list */
    case 436: /* group_by_list */
    case 439: /* order_by_clause_opt */
    case 444: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy152)); 
}
      break;
    case 337: /* alter_db_option */
    case 360: /* alter_table_option */
{
 
}
      break;
    case 349: /* type_name */
{
 
}
      break;
    case 408: /* compare_op */
    case 409: /* in_op */
{
 
}
      break;
    case 420: /* join_type */
{
 
}
      break;
    case 435: /* fill_mode */
{
 
}
      break;
    case 446: /* ordering_specification_opt */
{
 
}
      break;
    case 447: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  316,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  316,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  317,    0 }, /* (2) account_options ::= */
  {  317,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  317,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  317,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  317,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  317,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  317,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  317,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  317,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  317,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  318,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  318,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  320,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  320,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  320,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  320,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  320,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  320,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  320,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  320,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  320,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  320,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  316,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  316,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  316,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  316,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  316,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  322,    0 }, /* (29) sysinfo_opt ::= */
  {  322,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  316,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  316,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  323,   -1 }, /* (33) privileges ::= ALL */
  {  323,   -1 }, /* (34) privileges ::= priv_type_list */
  {  325,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  325,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  326,   -1 }, /* (37) priv_type ::= READ */
  {  326,   -1 }, /* (38) priv_type ::= WRITE */
  {  324,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  324,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  316,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  316,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  316,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  316,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  316,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  316,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  316,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  316,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  328,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  328,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  328,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  316,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  316,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  316,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  316,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  316,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  316,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  316,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  316,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  316,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  316,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  316,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  316,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  316,   -2 }, /* (64) cmd ::= USE db_name */
  {  316,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  316,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  316,   -4 }, /* (67) cmd ::= TRIM DATABASE db_name speed_opt */
  {  329,   -3 }, /* (68) not_exists_opt ::= IF NOT EXISTS */
  {  329,    0 }, /* (69) not_exists_opt ::= */
  {  331,   -2 }, /* (70) exists_opt ::= IF EXISTS */
  {  331,    0 }, /* (71) exists_opt ::= */
  {  330,    0 }, /* (72) db_options ::= */
  {  330,   -3 }, /* (73) db_options ::= db_options BUFFER NK_INTEGER */
  {  330,   -3 }, /* (74) db_options ::= db_options CACHEMODEL NK_STRING */
  {  330,   -3 }, /* (75) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  330,   -3 }, /* (76) db_options ::= db_options COMP NK_INTEGER */
  {  330,   -3 }, /* (77) db_options ::= db_options DURATION NK_INTEGER */
  {  330,   -3 }, /* (78) db_options ::= db_options DURATION NK_VARIABLE */
  {  330,   -3 }, /* (79) db_options ::= db_options MAXROWS NK_INTEGER */
  {  330,   -3 }, /* (80) db_options ::= db_options MINROWS NK_INTEGER */
  {  330,   -3 }, /* (81) db_options ::= db_options KEEP integer_list */
  {  330,   -3 }, /* (82) db_options ::= db_options KEEP variable_list */
  {  330,   -3 }, /* (83) db_options ::= db_options PAGES NK_INTEGER */
  {  330,   -3 }, /* (84) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  330,   -3 }, /* (85) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  330,   -3 }, /* (86) db_options ::= db_options PRECISION NK_STRING */
  {  330,   -3 }, /* (87) db_options ::= db_options REPLICA NK_INTEGER */
  {  330,   -3 }, /* (88) db_options ::= db_options STRICT NK_STRING */
  {  330,   -3 }, /* (89) db_options ::= db_options VGROUPS NK_INTEGER */
  {  330,   -3 }, /* (90) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  330,   -3 }, /* (91) db_options ::= db_options RETENTIONS retention_list */
  {  330,   -3 }, /* (92) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  330,   -3 }, /* (93) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  330,   -3 }, /* (94) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  330,   -3 }, /* (95) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  330,   -4 }, /* (96) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  330,   -3 }, /* (97) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  330,   -4 }, /* (98) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  330,   -3 }, /* (99) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  330,   -3 }, /* (100) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  330,   -3 }, /* (101) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  330,   -3 }, /* (102) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  330,   -3 }, /* (103) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  332,   -1 }, /* (104) alter_db_options ::= alter_db_option */
  {  332,   -2 }, /* (105) alter_db_options ::= alter_db_options alter_db_option */
  {  337,   -2 }, /* (106) alter_db_option ::= CACHEMODEL NK_STRING */
  {  337,   -2 }, /* (107) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  337,   -2 }, /* (108) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  337,   -2 }, /* (109) alter_db_option ::= KEEP integer_list */
  {  337,   -2 }, /* (110) alter_db_option ::= KEEP variable_list */
  {  337,   -2 }, /* (111) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  337,   -2 }, /* (112) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  334,   -1 }, /* (113) integer_list ::= NK_INTEGER */
  {  334,   -3 }, /* (114) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  335,   -1 }, /* (115) variable_list ::= NK_VARIABLE */
  {  335,   -3 }, /* (116) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  336,   -1 }, /* (117) retention_list ::= retention */
  {  336,   -3 }, /* (118) retention_list ::= retention_list NK_COMMA retention */
  {  338,   -3 }, /* (119) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  333,    0 }, /* (120) speed_opt ::= */
  {  333,   -2 }, /* (121) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  316,   -9 }, /* (122) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  316,   -3 }, /* (123) cmd ::= CREATE TABLE multi_create_clause */
  {  316,   -9 }, /* (124) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  316,   -3 }, /* (125) cmd ::= DROP TABLE multi_drop_clause */
  {  316,   -4 }, /* (126) cmd ::= DROP STABLE exists_opt full_table_name */
  {  316,   -3 }, /* (127) cmd ::= ALTER TABLE alter_table_clause */
  {  316,   -3 }, /* (128) cmd ::= ALTER STABLE alter_table_clause */
  {  346,   -2 }, /* (129) alter_table_clause ::= full_table_name alter_table_options */
  {  346,   -5 }, /* (130) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  346,   -4 }, /* (131) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  346,   -5 }, /* (132) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  346,   -5 }, /* (133) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  346,   -5 }, /* (134) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  346,   -4 }, /* (135) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  346,   -5 }, /* (136) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  346,   -5 }, /* (137) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  346,   -6 }, /* (138) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  343,   -1 }, /* (139) multi_create_clause ::= create_subtable_clause */
  {  343,   -2 }, /* (140) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  351,  -10 }, /* (141) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  345,   -1 }, /* (142) multi_drop_clause ::= drop_table_clause */
  {  345,   -2 }, /* (143) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  354,   -2 }, /* (144) drop_table_clause ::= exists_opt full_table_name */
  {  352,    0 }, /* (145) specific_cols_opt ::= */
  {  352,   -3 }, /* (146) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  339,   -1 }, /* (147) full_table_name ::= table_name */
  {  339,   -3 }, /* (148) full_table_name ::= db_name NK_DOT table_name */
  {  340,   -1 }, /* (149) column_def_list ::= column_def */
  {  340,   -3 }, /* (150) column_def_list ::= column_def_list NK_COMMA column_def */
  {  357,   -2 }, /* (151) column_def ::= column_name type_name */
  {  357,   -4 }, /* (152) column_def ::= column_name type_name COMMENT NK_STRING */
  {  349,   -1 }, /* (153) type_name ::= BOOL */
  {  349,   -1 }, /* (154) type_name ::= TINYINT */
  {  349,   -1 }, /* (155) type_name ::= SMALLINT */
  {  349,   -1 }, /* (156) type_name ::= INT */
  {  349,   -1 }, /* (157) type_name ::= INTEGER */
  {  349,   -1 }, /* (158) type_name ::= BIGINT */
  {  349,   -1 }, /* (159) type_name ::= FLOAT */
  {  349,   -1 }, /* (160) type_name ::= DOUBLE */
  {  349,   -4 }, /* (161) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  349,   -1 }, /* (162) type_name ::= TIMESTAMP */
  {  349,   -4 }, /* (163) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  349,   -2 }, /* (164) type_name ::= TINYINT UNSIGNED */
  {  349,   -2 }, /* (165) type_name ::= SMALLINT UNSIGNED */
  {  349,   -2 }, /* (166) type_name ::= INT UNSIGNED */
  {  349,   -2 }, /* (167) type_name ::= BIGINT UNSIGNED */
  {  349,   -1 }, /* (168) type_name ::= JSON */
  {  349,   -4 }, /* (169) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  349,   -1 }, /* (170) type_name ::= MEDIUMBLOB */
  {  349,   -1 }, /* (171) type_name ::= BLOB */
  {  349,   -4 }, /* (172) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  349,   -1 }, /* (173) type_name ::= DECIMAL */
  {  349,   -4 }, /* (174) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  349,   -6 }, /* (175) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  341,    0 }, /* (176) tags_def_opt ::= */
  {  341,   -1 }, /* (177) tags_def_opt ::= tags_def */
  {  344,   -4 }, /* (178) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  342,    0 }, /* (179) table_options ::= */
  {  342,   -3 }, /* (180) table_options ::= table_options COMMENT NK_STRING */
  {  342,   -3 }, /* (181) table_options ::= table_options MAX_DELAY duration_list */
  {  342,   -3 }, /* (182) table_options ::= table_options WATERMARK duration_list */
  {  342,   -5 }, /* (183) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  342,   -3 }, /* (184) table_options ::= table_options TTL NK_INTEGER */
  {  342,   -5 }, /* (185) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  347,   -1 }, /* (186) alter_table_options ::= alter_table_option */
  {  347,   -2 }, /* (187) alter_table_options ::= alter_table_options alter_table_option */
  {  360,   -2 }, /* (188) alter_table_option ::= COMMENT NK_STRING */
  {  360,   -2 }, /* (189) alter_table_option ::= TTL NK_INTEGER */
  {  358,   -1 }, /* (190) duration_list ::= duration_literal */
  {  358,   -3 }, /* (191) duration_list ::= duration_list NK_COMMA duration_literal */
  {  359,   -1 }, /* (192) rollup_func_list ::= rollup_func_name */
  {  359,   -3 }, /* (193) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  362,   -1 }, /* (194) rollup_func_name ::= function_name */
  {  362,   -1 }, /* (195) rollup_func_name ::= FIRST */
  {  362,   -1 }, /* (196) rollup_func_name ::= LAST */
  {  355,   -1 }, /* (197) col_name_list ::= col_name */
  {  355,   -3 }, /* (198) col_name_list ::= col_name_list NK_COMMA col_name */
  {  364,   -1 }, /* (199) col_name ::= column_name */
  {  316,   -2 }, /* (200) cmd ::= SHOW DNODES */
  {  316,   -2 }, /* (201) cmd ::= SHOW USERS */
  {  316,   -2 }, /* (202) cmd ::= SHOW DATABASES */
  {  316,   -4 }, /* (203) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  316,   -4 }, /* (204) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  316,   -3 }, /* (205) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  316,   -2 }, /* (206) cmd ::= SHOW MNODES */
  {  316,   -2 }, /* (207) cmd ::= SHOW MODULES */
  {  316,   -2 }, /* (208) cmd ::= SHOW QNODES */
  {  316,   -2 }, /* (209) cmd ::= SHOW FUNCTIONS */
  {  316,   -5 }, /* (210) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  316,   -2 }, /* (211) cmd ::= SHOW STREAMS */
  {  316,   -2 }, /* (212) cmd ::= SHOW ACCOUNTS */
  {  316,   -2 }, /* (213) cmd ::= SHOW APPS */
  {  316,   -2 }, /* (214) cmd ::= SHOW CONNECTIONS */
  {  316,   -2 }, /* (215) cmd ::= SHOW LICENCES */
  {  316,   -2 }, /* (216) cmd ::= SHOW GRANTS */
  {  316,   -4 }, /* (217) cmd ::= SHOW CREATE DATABASE db_name */
  {  316,   -4 }, /* (218) cmd ::= SHOW CREATE TABLE full_table_name */
  {  316,   -4 }, /* (219) cmd ::= SHOW CREATE STABLE full_table_name */
  {  316,   -2 }, /* (220) cmd ::= SHOW QUERIES */
  {  316,   -2 }, /* (221) cmd ::= SHOW SCORES */
  {  316,   -2 }, /* (222) cmd ::= SHOW TOPICS */
  {  316,   -2 }, /* (223) cmd ::= SHOW VARIABLES */
  {  316,   -3 }, /* (224) cmd ::= SHOW LOCAL VARIABLES */
  {  316,   -4 }, /* (225) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  316,   -2 }, /* (226) cmd ::= SHOW BNODES */
  {  316,   -2 }, /* (227) cmd ::= SHOW SNODES */
  {  316,   -2 }, /* (228) cmd ::= SHOW CLUSTER */
  {  316,   -2 }, /* (229) cmd ::= SHOW TRANSACTIONS */
  {  316,   -4 }, /* (230) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  316,   -2 }, /* (231) cmd ::= SHOW CONSUMERS */
  {  316,   -2 }, /* (232) cmd ::= SHOW SUBSCRIPTIONS */
  {  316,   -5 }, /* (233) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  316,   -3 }, /* (234) cmd ::= SHOW VNODES NK_INTEGER */
  {  316,   -3 }, /* (235) cmd ::= SHOW VNODES NK_STRING */
  {  365,    0 }, /* (236) db_name_cond_opt ::= */
  {  365,   -2 }, /* (237) db_name_cond_opt ::= db_name NK_DOT */
  {  366,    0 }, /* (238) like_pattern_opt ::= */
  {  366,   -2 }, /* (239) like_pattern_opt ::= LIKE NK_STRING */
  {  367,   -1 }, /* (240) table_name_cond ::= table_name */
  {  368,    0 }, /* (241) from_db_opt ::= */
  {  368,   -2 }, /* (242) from_db_opt ::= FROM db_name */
  {  316,   -8 }, /* (243) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  316,   -4 }, /* (244) cmd ::= DROP INDEX exists_opt full_table_name */
  {  369,  -10 }, /* (245) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  369,  -12 }, /* (246) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  370,   -1 }, /* (247) func_list ::= func */
  {  370,   -3 }, /* (248) func_list ::= func_list NK_COMMA func */
  {  373,   -4 }, /* (249) func ::= function_name NK_LP expression_list NK_RP */
  {  372,    0 }, /* (250) sma_stream_opt ::= */
  {  372,   -3 }, /* (251) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  372,   -3 }, /* (252) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  316,   -6 }, /* (253) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  316,   -7 }, /* (254) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  316,   -9 }, /* (255) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  316,   -7 }, /* (256) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  316,   -9 }, /* (257) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  316,   -4 }, /* (258) cmd ::= DROP TOPIC exists_opt topic_name */
  {  316,   -7 }, /* (259) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  316,   -2 }, /* (260) cmd ::= DESC full_table_name */
  {  316,   -2 }, /* (261) cmd ::= DESCRIBE full_table_name */
  {  316,   -3 }, /* (262) cmd ::= RESET QUERY CACHE */
  {  316,   -4 }, /* (263) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  378,    0 }, /* (264) analyze_opt ::= */
  {  378,   -1 }, /* (265) analyze_opt ::= ANALYZE */
  {  379,    0 }, /* (266) explain_options ::= */
  {  379,   -3 }, /* (267) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  379,   -3 }, /* (268) explain_options ::= explain_options RATIO NK_FLOAT */
  {  316,  -10 }, /* (269) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  316,   -4 }, /* (270) cmd ::= DROP FUNCTION exists_opt function_name */
  {  380,    0 }, /* (271) agg_func_opt ::= */
  {  380,   -1 }, /* (272) agg_func_opt ::= AGGREGATE */
  {  381,    0 }, /* (273) bufsize_opt ::= */
  {  381,   -2 }, /* (274) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  316,  -11 }, /* (275) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  316,   -4 }, /* (276) cmd ::= DROP STREAM exists_opt stream_name */
  {  374,    0 }, /* (277) stream_options ::= */
  {  374,   -3 }, /* (278) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  374,   -3 }, /* (279) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  374,   -4 }, /* (280) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  374,   -3 }, /* (281) stream_options ::= stream_options WATERMARK duration_literal */
  {  374,   -4 }, /* (282) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  383,    0 }, /* (283) subtable_opt ::= */
  {  383,   -4 }, /* (284) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  316,   -3 }, /* (285) cmd ::= KILL CONNECTION NK_INTEGER */
  {  316,   -3 }, /* (286) cmd ::= KILL QUERY NK_STRING */
  {  316,   -3 }, /* (287) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  316,   -2 }, /* (288) cmd ::= BALANCE VGROUP */
  {  316,   -4 }, /* (289) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  316,   -4 }, /* (290) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  316,   -3 }, /* (291) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  385,   -2 }, /* (292) dnode_list ::= DNODE NK_INTEGER */
  {  385,   -3 }, /* (293) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  316,   -4 }, /* (294) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  316,   -1 }, /* (295) cmd ::= query_or_subquery */
  {  316,   -7 }, /* (296) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  316,   -4 }, /* (297) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  319,   -1 }, /* (298) literal ::= NK_INTEGER */
  {  319,   -1 }, /* (299) literal ::= NK_FLOAT */
  {  319,   -1 }, /* (300) literal ::= NK_STRING */
  {  319,   -1 }, /* (301) literal ::= NK_BOOL */
  {  319,   -2 }, /* (302) literal ::= TIMESTAMP NK_STRING */
  {  319,   -1 }, /* (303) literal ::= duration_literal */
  {  319,   -1 }, /* (304) literal ::= NULL */
  {  319,   -1 }, /* (305) literal ::= NK_QUESTION */
  {  361,   -1 }, /* (306) duration_literal ::= NK_VARIABLE */
  {  387,   -1 }, /* (307) signed ::= NK_INTEGER */
  {  387,   -2 }, /* (308) signed ::= NK_PLUS NK_INTEGER */
  {  387,   -2 }, /* (309) signed ::= NK_MINUS NK_INTEGER */
  {  387,   -1 }, /* (310) signed ::= NK_FLOAT */
  {  387,   -2 }, /* (311) signed ::= NK_PLUS NK_FLOAT */
  {  387,   -2 }, /* (312) signed ::= NK_MINUS NK_FLOAT */
  {  350,   -1 }, /* (313) signed_literal ::= signed */
  {  350,   -1 }, /* (314) signed_literal ::= NK_STRING */
  {  350,   -1 }, /* (315) signed_literal ::= NK_BOOL */
  {  350,   -2 }, /* (316) signed_literal ::= TIMESTAMP NK_STRING */
  {  350,   -1 }, /* (317) signed_literal ::= duration_literal */
  {  350,   -1 }, /* (318) signed_literal ::= NULL */
  {  350,   -1 }, /* (319) signed_literal ::= literal_func */
  {  350,   -1 }, /* (320) signed_literal ::= NK_QUESTION */
  {  389,   -1 }, /* (321) literal_list ::= signed_literal */
  {  389,   -3 }, /* (322) literal_list ::= literal_list NK_COMMA signed_literal */
  {  327,   -1 }, /* (323) db_name ::= NK_ID */
  {  356,   -1 }, /* (324) table_name ::= NK_ID */
  {  348,   -1 }, /* (325) column_name ::= NK_ID */
  {  363,   -1 }, /* (326) function_name ::= NK_ID */
  {  390,   -1 }, /* (327) table_alias ::= NK_ID */
  {  391,   -1 }, /* (328) column_alias ::= NK_ID */
  {  321,   -1 }, /* (329) user_name ::= NK_ID */
  {  375,   -1 }, /* (330) topic_name ::= NK_ID */
  {  382,   -1 }, /* (331) stream_name ::= NK_ID */
  {  377,   -1 }, /* (332) cgroup_name ::= NK_ID */
  {  392,   -1 }, /* (333) expr_or_subquery ::= expression */
  {  392,   -1 }, /* (334) expr_or_subquery ::= subquery */
  {  384,   -1 }, /* (335) expression ::= literal */
  {  384,   -1 }, /* (336) expression ::= pseudo_column */
  {  384,   -1 }, /* (337) expression ::= column_reference */
  {  384,   -1 }, /* (338) expression ::= function_expression */
  {  384,   -1 }, /* (339) expression ::= case_when_expression */
  {  384,   -3 }, /* (340) expression ::= NK_LP expression NK_RP */
  {  384,   -2 }, /* (341) expression ::= NK_PLUS expr_or_subquery */
  {  384,   -2 }, /* (342) expression ::= NK_MINUS expr_or_subquery */
  {  384,   -3 }, /* (343) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  384,   -3 }, /* (344) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  384,   -3 }, /* (345) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  384,   -3 }, /* (346) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  384,   -3 }, /* (347) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  384,   -3 }, /* (348) expression ::= column_reference NK_ARROW NK_STRING */
  {  384,   -3 }, /* (349) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  384,   -3 }, /* (350) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  353,   -1 }, /* (351) expression_list ::= expr_or_subquery */
  {  353,   -3 }, /* (352) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  395,   -1 }, /* (353) column_reference ::= column_name */
  {  395,   -3 }, /* (354) column_reference ::= table_name NK_DOT column_name */
  {  394,   -1 }, /* (355) pseudo_column ::= ROWTS */
  {  394,   -1 }, /* (356) pseudo_column ::= TBNAME */
  {  394,   -3 }, /* (357) pseudo_column ::= table_name NK_DOT TBNAME */
  {  394,   -1 }, /* (358) pseudo_column ::= QSTART */
  {  394,   -1 }, /* (359) pseudo_column ::= QEND */
  {  394,   -1 }, /* (360) pseudo_column ::= QDURATION */
  {  394,   -1 }, /* (361) pseudo_column ::= WSTART */
  {  394,   -1 }, /* (362) pseudo_column ::= WEND */
  {  394,   -1 }, /* (363) pseudo_column ::= WDURATION */
  {  394,   -1 }, /* (364) pseudo_column ::= IROWTS */
  {  396,   -4 }, /* (365) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  396,   -4 }, /* (366) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  396,   -6 }, /* (367) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  396,   -1 }, /* (368) function_expression ::= literal_func */
  {  388,   -3 }, /* (369) literal_func ::= noarg_func NK_LP NK_RP */
  {  388,   -1 }, /* (370) literal_func ::= NOW */
  {  400,   -1 }, /* (371) noarg_func ::= NOW */
  {  400,   -1 }, /* (372) noarg_func ::= TODAY */
  {  400,   -1 }, /* (373) noarg_func ::= TIMEZONE */
  {  400,   -1 }, /* (374) noarg_func ::= DATABASE */
  {  400,   -1 }, /* (375) noarg_func ::= CLIENT_VERSION */
  {  400,   -1 }, /* (376) noarg_func ::= SERVER_VERSION */
  {  400,   -1 }, /* (377) noarg_func ::= SERVER_STATUS */
  {  400,   -1 }, /* (378) noarg_func ::= CURRENT_USER */
  {  400,   -1 }, /* (379) noarg_func ::= USER */
  {  398,   -1 }, /* (380) star_func ::= COUNT */
  {  398,   -1 }, /* (381) star_func ::= FIRST */
  {  398,   -1 }, /* (382) star_func ::= LAST */
  {  398,   -1 }, /* (383) star_func ::= LAST_ROW */
  {  399,   -1 }, /* (384) star_func_para_list ::= NK_STAR */
  {  399,   -1 }, /* (385) star_func_para_list ::= other_para_list */
  {  401,   -1 }, /* (386) other_para_list ::= star_func_para */
  {  401,   -3 }, /* (387) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  402,   -1 }, /* (388) star_func_para ::= expr_or_subquery */
  {  402,   -3 }, /* (389) star_func_para ::= table_name NK_DOT NK_STAR */
  {  397,   -4 }, /* (390) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  397,   -5 }, /* (391) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  403,   -1 }, /* (392) when_then_list ::= when_then_expr */
  {  403,   -2 }, /* (393) when_then_list ::= when_then_list when_then_expr */
  {  406,   -4 }, /* (394) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  404,    0 }, /* (395) case_when_else_opt ::= */
  {  404,   -2 }, /* (396) case_when_else_opt ::= ELSE common_expression */
  {  407,   -3 }, /* (397) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  407,   -5 }, /* (398) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  407,   -6 }, /* (399) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  407,   -3 }, /* (400) predicate ::= expr_or_subquery IS NULL */
  {  407,   -4 }, /* (401) predicate ::= expr_or_subquery IS NOT NULL */
  {  407,   -3 }, /* (402) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  408,   -1 }, /* (403) compare_op ::= NK_LT */
  {  408,   -1 }, /* (404) compare_op ::= NK_GT */
  {  408,   -1 }, /* (405) compare_op ::= NK_LE */
  {  408,   -1 }, /* (406) compare_op ::= NK_GE */
  {  408,   -1 }, /* (407) compare_op ::= NK_NE */
  {  408,   -1 }, /* (408) compare_op ::= NK_EQ */
  {  408,   -1 }, /* (409) compare_op ::= LIKE */
  {  408,   -2 }, /* (410) compare_op ::= NOT LIKE */
  {  408,   -1 }, /* (411) compare_op ::= MATCH */
  {  408,   -1 }, /* (412) compare_op ::= NMATCH */
  {  408,   -1 }, /* (413) compare_op ::= CONTAINS */
  {  409,   -1 }, /* (414) in_op ::= IN */
  {  409,   -2 }, /* (415) in_op ::= NOT IN */
  {  410,   -3 }, /* (416) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  411,   -1 }, /* (417) boolean_value_expression ::= boolean_primary */
  {  411,   -2 }, /* (418) boolean_value_expression ::= NOT boolean_primary */
  {  411,   -3 }, /* (419) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  411,   -3 }, /* (420) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  412,   -1 }, /* (421) boolean_primary ::= predicate */
  {  412,   -3 }, /* (422) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  405,   -1 }, /* (423) common_expression ::= expr_or_subquery */
  {  405,   -1 }, /* (424) common_expression ::= boolean_value_expression */
  {  413,    0 }, /* (425) from_clause_opt ::= */
  {  413,   -2 }, /* (426) from_clause_opt ::= FROM table_reference_list */
  {  414,   -1 }, /* (427) table_reference_list ::= table_reference */
  {  414,   -3 }, /* (428) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  415,   -1 }, /* (429) table_reference ::= table_primary */
  {  415,   -1 }, /* (430) table_reference ::= joined_table */
  {  416,   -2 }, /* (431) table_primary ::= table_name alias_opt */
  {  416,   -4 }, /* (432) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  416,   -2 }, /* (433) table_primary ::= subquery alias_opt */
  {  416,   -1 }, /* (434) table_primary ::= parenthesized_joined_table */
  {  418,    0 }, /* (435) alias_opt ::= */
  {  418,   -1 }, /* (436) alias_opt ::= table_alias */
  {  418,   -2 }, /* (437) alias_opt ::= AS table_alias */
  {  419,   -3 }, /* (438) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  419,   -3 }, /* (439) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  417,   -6 }, /* (440) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  420,    0 }, /* (441) join_type ::= */
  {  420,   -1 }, /* (442) join_type ::= INNER */
  {  422,  -12 }, /* (443) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  423,    0 }, /* (444) set_quantifier_opt ::= */
  {  423,   -1 }, /* (445) set_quantifier_opt ::= DISTINCT */
  {  423,   -1 }, /* (446) set_quantifier_opt ::= ALL */
  {  424,   -1 }, /* (447) select_list ::= select_item */
  {  424,   -3 }, /* (448) select_list ::= select_list NK_COMMA select_item */
  {  432,   -1 }, /* (449) select_item ::= NK_STAR */
  {  432,   -1 }, /* (450) select_item ::= common_expression */
  {  432,   -2 }, /* (451) select_item ::= common_expression column_alias */
  {  432,   -3 }, /* (452) select_item ::= common_expression AS column_alias */
  {  432,   -3 }, /* (453) select_item ::= table_name NK_DOT NK_STAR */
  {  386,    0 }, /* (454) where_clause_opt ::= */
  {  386,   -2 }, /* (455) where_clause_opt ::= WHERE search_condition */
  {  425,    0 }, /* (456) partition_by_clause_opt ::= */
  {  425,   -3 }, /* (457) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  433,   -1 }, /* (458) partition_list ::= partition_item */
  {  433,   -3 }, /* (459) partition_list ::= partition_list NK_COMMA partition_item */
  {  434,   -1 }, /* (460) partition_item ::= expr_or_subquery */
  {  434,   -2 }, /* (461) partition_item ::= expr_or_subquery column_alias */
  {  434,   -3 }, /* (462) partition_item ::= expr_or_subquery AS column_alias */
  {  429,    0 }, /* (463) twindow_clause_opt ::= */
  {  429,   -6 }, /* (464) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  429,   -4 }, /* (465) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  429,   -6 }, /* (466) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  429,   -8 }, /* (467) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  371,    0 }, /* (468) sliding_opt ::= */
  {  371,   -4 }, /* (469) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  428,    0 }, /* (470) fill_opt ::= */
  {  428,   -4 }, /* (471) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  428,   -6 }, /* (472) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  435,   -1 }, /* (473) fill_mode ::= NONE */
  {  435,   -1 }, /* (474) fill_mode ::= PREV */
  {  435,   -1 }, /* (475) fill_mode ::= NULL */
  {  435,   -1 }, /* (476) fill_mode ::= LINEAR */
  {  435,   -1 }, /* (477) fill_mode ::= NEXT */
  {  430,    0 }, /* (478) group_by_clause_opt ::= */
  {  430,   -3 }, /* (479) group_by_clause_opt ::= GROUP BY group_by_list */
  {  436,   -1 }, /* (480) group_by_list ::= expr_or_subquery */
  {  436,   -3 }, /* (481) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  431,    0 }, /* (482) having_clause_opt ::= */
  {  431,   -2 }, /* (483) having_clause_opt ::= HAVING search_condition */
  {  426,    0 }, /* (484) range_opt ::= */
  {  426,   -6 }, /* (485) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  427,    0 }, /* (486) every_opt ::= */
  {  427,   -4 }, /* (487) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  437,   -4 }, /* (488) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  438,   -1 }, /* (489) query_simple ::= query_specification */
  {  438,   -1 }, /* (490) query_simple ::= union_query_expression */
  {  442,   -4 }, /* (491) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  442,   -3 }, /* (492) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  443,   -1 }, /* (493) query_simple_or_subquery ::= query_simple */
  {  443,   -1 }, /* (494) query_simple_or_subquery ::= subquery */
  {  376,   -1 }, /* (495) query_or_subquery ::= query_expression */
  {  376,   -1 }, /* (496) query_or_subquery ::= subquery */
  {  439,    0 }, /* (497) order_by_clause_opt ::= */
  {  439,   -3 }, /* (498) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  440,    0 }, /* (499) slimit_clause_opt ::= */
  {  440,   -2 }, /* (500) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  440,   -4 }, /* (501) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  440,   -4 }, /* (502) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  441,    0 }, /* (503) limit_clause_opt ::= */
  {  441,   -2 }, /* (504) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  441,   -4 }, /* (505) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  441,   -4 }, /* (506) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  393,   -3 }, /* (507) subquery ::= NK_LP query_expression NK_RP */
  {  393,   -3 }, /* (508) subquery ::= NK_LP subquery NK_RP */
  {  421,   -1 }, /* (509) search_condition ::= common_expression */
  {  444,   -1 }, /* (510) sort_specification_list ::= sort_specification */
  {  444,   -3 }, /* (511) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  445,   -3 }, /* (512) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  446,    0 }, /* (513) ordering_specification_opt ::= */
  {  446,   -1 }, /* (514) ordering_specification_opt ::= ASC */
  {  446,   -1 }, /* (515) ordering_specification_opt ::= DESC */
  {  447,    0 }, /* (516) null_ordering_opt ::= */
  {  447,   -2 }, /* (517) null_ordering_opt ::= NULLS FIRST */
  {  447,   -2 }, /* (518) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,317,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,318,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,317,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,319,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,320,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,318,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,320,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,319,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy673, &yymsp[-1].minor.yy0, yymsp[0].minor.yy439); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy673, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy673, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy673, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy673); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy439 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy439 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy221, &yymsp[-2].minor.yy673, &yymsp[0].minor.yy673); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy221, &yymsp[-2].minor.yy673, &yymsp[0].minor.yy673); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy221 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy221 = yymsp[0].minor.yy221; }
  yymsp[0].minor.yy221 = yylhsminor.yy221;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy221 = yymsp[-2].minor.yy221 | yymsp[0].minor.yy221; }
  yymsp[-2].minor.yy221 = yylhsminor.yy221;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy221 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy221 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy673 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy673 = yylhsminor.yy673;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy673 = yymsp[-2].minor.yy673; }
  yymsp[-2].minor.yy673 = yylhsminor.yy673;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy673, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy673, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy673); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 323: /* db_name ::= NK_ID */ yytestcase(yyruleno==323);
      case 324: /* table_name ::= NK_ID */ yytestcase(yyruleno==324);
      case 325: /* column_name ::= NK_ID */ yytestcase(yyruleno==325);
      case 326: /* function_name ::= NK_ID */ yytestcase(yyruleno==326);
      case 327: /* table_alias ::= NK_ID */ yytestcase(yyruleno==327);
      case 328: /* column_alias ::= NK_ID */ yytestcase(yyruleno==328);
      case 329: /* user_name ::= NK_ID */ yytestcase(yyruleno==329);
      case 330: /* topic_name ::= NK_ID */ yytestcase(yyruleno==330);
      case 331: /* stream_name ::= NK_ID */ yytestcase(yyruleno==331);
      case 332: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==332);
      case 371: /* noarg_func ::= NOW */ yytestcase(yyruleno==371);
      case 372: /* noarg_func ::= TODAY */ yytestcase(yyruleno==372);
      case 373: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==373);
      case 374: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==374);
      case 375: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==375);
      case 376: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==376);
      case 377: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==377);
      case 378: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==378);
      case 379: /* noarg_func ::= USER */ yytestcase(yyruleno==379);
      case 380: /* star_func ::= COUNT */ yytestcase(yyruleno==380);
      case 381: /* star_func ::= FIRST */ yytestcase(yyruleno==381);
      case 382: /* star_func ::= LAST */ yytestcase(yyruleno==382);
      case 383: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==383);
{ yylhsminor.yy673 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy673 = yylhsminor.yy673;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy89, &yymsp[-1].minor.yy673, yymsp[0].minor.yy616); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy673); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy673); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy673, yymsp[0].minor.yy616); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy673); }
        break;
      case 67: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy673, yymsp[0].minor.yy452); }
        break;
      case 68: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy89 = true; }
        break;
      case 69: /* not_exists_opt ::= */
      case 71: /* exists_opt ::= */ yytestcase(yyruleno==71);
      case 264: /* analyze_opt ::= */ yytestcase(yyruleno==264);
      case 271: /* agg_func_opt ::= */ yytestcase(yyruleno==271);
      case 444: /* set_quantifier_opt ::= */ yytestcase(yyruleno==444);
{ yymsp[1].minor.yy89 = false; }
        break;
      case 70: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy89 = true; }
        break;
      case 72: /* db_options ::= */
{ yymsp[1].minor.yy616 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 73: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 74: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 75: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 76: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 77: /* db_options ::= db_options DURATION NK_INTEGER */
      case 78: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==78);
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 79: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 80: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 81: /* db_options ::= db_options KEEP integer_list */
      case 82: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==82);
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_KEEP, yymsp[0].minor.yy152); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 83: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 84: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 85: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 86: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 87: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 88: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 89: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 90: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 91: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_RETENTIONS, yymsp[0].minor.yy152); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 92: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 93: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 94: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 95: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 96: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-3].minor.yy616, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 97: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-3].minor.yy616, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 99: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 100: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 101: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 102: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 103: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy616 = setDatabaseOption(pCxt, yymsp[-2].minor.yy616, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 104: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy616 = createAlterDatabaseOptions(pCxt); yylhsminor.yy616 = setAlterDatabaseOption(pCxt, yylhsminor.yy616, &yymsp[0].minor.yy669); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 105: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy616 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy616, &yymsp[0].minor.yy669); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 106: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy669.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy669.val = yymsp[0].minor.yy0; }
        break;
      case 107: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy669.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy669.val = yymsp[0].minor.yy0; }
        break;
      case 108: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy669.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy669.val = yymsp[0].minor.yy0; }
        break;
      case 109: /* alter_db_option ::= KEEP integer_list */
      case 110: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==110);
{ yymsp[-1].minor.yy669.type = DB_OPTION_KEEP; yymsp[-1].minor.yy669.pList = yymsp[0].minor.yy152; }
        break;
      case 111: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy669.type = DB_OPTION_WAL; yymsp[-1].minor.yy669.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy669.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy669.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy152 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy152 = yylhsminor.yy152;
        break;
      case 114: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 293: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==293);
{ yylhsminor.yy152 = addNodeToList(pCxt, yymsp[-2].minor.yy152, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy152 = yylhsminor.yy152;
        break;
      case 115: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy152 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy152 = yylhsminor.yy152;
        break;
      case 116: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy152 = addNodeToList(pCxt, yymsp[-2].minor.yy152, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy152 = yylhsminor.yy152;
        break;
      case 117: /* retention_list ::= retention */
      case 139: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==139);
      case 142: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==142);
      case 149: /* column_def_list ::= column_def */ yytestcase(yyruleno==149);
      case 192: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==192);
      case 197: /* col_name_list ::= col_name */ yytestcase(yyruleno==197);
      case 247: /* func_list ::= func */ yytestcase(yyruleno==247);
      case 321: /* literal_list ::= signed_literal */ yytestcase(yyruleno==321);
      case 386: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==386);
      case 392: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==392);
      case 447: /* select_list ::= select_item */ yytestcase(yyruleno==447);
      case 458: /* partition_list ::= partition_item */ yytestcase(yyruleno==458);
      case 510: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==510);
{ yylhsminor.yy152 = createNodeList(pCxt, yymsp[0].minor.yy616); }
  yymsp[0].minor.yy152 = yylhsminor.yy152;
        break;
      case 118: /* retention_list ::= retention_list NK_COMMA retention */
      case 150: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==150);
      case 193: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==193);
      case 198: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==198);
      case 248: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==248);
      case 322: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==322);
      case 387: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==387);
      case 448: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==448);
      case 459: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==459);
      case 511: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==511);
{ yylhsminor.yy152 = addNodeToList(pCxt, yymsp[-2].minor.yy152, yymsp[0].minor.yy616); }
  yymsp[-2].minor.yy152 = yylhsminor.yy152;
        break;
      case 119: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy616 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 120: /* speed_opt ::= */
      case 273: /* bufsize_opt ::= */ yytestcase(yyruleno==273);
{ yymsp[1].minor.yy452 = 0; }
        break;
      case 121: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 274: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==274);
{ yymsp[-1].minor.yy452 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 122: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 124: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==124);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy89, yymsp[-5].minor.yy616, yymsp[-3].minor.yy152, yymsp[-1].minor.yy152, yymsp[0].minor.yy616); }
        break;
      case 123: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy152); }
        break;
      case 125: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy152); }
        break;
      case 126: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy89, yymsp[0].minor.yy616); }
        break;
      case 127: /* cmd ::= ALTER TABLE alter_table_clause */
      case 295: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==295);
{ pCxt->pRootNode = yymsp[0].minor.yy616; }
        break;
      case 128: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy616); }
        break;
      case 129: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy616 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 130: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy616 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy673, yymsp[0].minor.yy784); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 131: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy616 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy616, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy673); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 132: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy616 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy673, yymsp[0].minor.yy784); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 133: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy616 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy673, &yymsp[0].minor.yy673); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 134: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy616 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy673, yymsp[0].minor.yy784); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 135: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy616 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy616, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy673); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 136: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy616 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy673, yymsp[0].minor.yy784); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 137: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy616 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy616, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy673, &yymsp[0].minor.yy673); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 138: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy616 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy616, &yymsp[-2].minor.yy673, yymsp[0].minor.yy616); }
  yymsp[-5].minor.yy616 = yylhsminor.yy616;
        break;
      case 140: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 143: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==143);
      case 393: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==393);
{ yylhsminor.yy152 = addNodeToList(pCxt, yymsp[-1].minor.yy152, yymsp[0].minor.yy616); }
  yymsp[-1].minor.yy152 = yylhsminor.yy152;
        break;
      case 141: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy616 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy89, yymsp[-8].minor.yy616, yymsp[-6].minor.yy616, yymsp[-5].minor.yy152, yymsp[-2].minor.yy152, yymsp[0].minor.yy616); }
  yymsp[-9].minor.yy616 = yylhsminor.yy616;
        break;
      case 144: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy616 = createDropTableClause(pCxt, yymsp[-1].minor.yy89, yymsp[0].minor.yy616); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 145: /* specific_cols_opt ::= */
      case 176: /* tags_def_opt ::= */ yytestcase(yyruleno==176);
      case 456: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==456);
      case 478: /* group_by_clause_opt ::= */ yytestcase(yyruleno==478);
      case 497: /* order_by_clause_opt ::= */ yytestcase(yyruleno==497);
{ yymsp[1].minor.yy152 = NULL; }
        break;
      case 146: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy152 = yymsp[-1].minor.yy152; }
        break;
      case 147: /* full_table_name ::= table_name */
{ yylhsminor.yy616 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy673, NULL); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 148: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy616 = createRealTableNode(pCxt, &yymsp[-2].minor.yy673, &yymsp[0].minor.yy673, NULL); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 151: /* column_def ::= column_name type_name */
{ yylhsminor.yy616 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy673, yymsp[0].minor.yy784, NULL); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 152: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy616 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy673, yymsp[-2].minor.yy784, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 153: /* type_name ::= BOOL */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 154: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 155: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 156: /* type_name ::= INT */
      case 157: /* type_name ::= INTEGER */ yytestcase(yyruleno==157);
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 158: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 159: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 160: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 161: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy784 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 162: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 163: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy784 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 164: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy784 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 165: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy784 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 166: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy784 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 167: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy784 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 168: /* type_name ::= JSON */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 169: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy784 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 171: /* type_name ::= BLOB */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 172: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy784 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 173: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 174: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy784 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 175: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy784 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 177: /* tags_def_opt ::= tags_def */
      case 385: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==385);
{ yylhsminor.yy152 = yymsp[0].minor.yy152; }
  yymsp[0].minor.yy152 = yylhsminor.yy152;
        break;
      case 178: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy152 = yymsp[-1].minor.yy152; }
        break;
      case 179: /* table_options ::= */
{ yymsp[1].minor.yy616 = createDefaultTableOptions(pCxt); }
        break;
      case 180: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-2].minor.yy616, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 181: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-2].minor.yy616, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy152); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 182: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-2].minor.yy616, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy152); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 183: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-4].minor.yy616, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy152); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 184: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-2].minor.yy616, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 185: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-4].minor.yy616, TABLE_OPTION_SMA, yymsp[-1].minor.yy152); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 186: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy616 = createAlterTableOptions(pCxt); yylhsminor.yy616 = setTableOption(pCxt, yylhsminor.yy616, yymsp[0].minor.yy669.type, &yymsp[0].minor.yy669.val); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 187: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy616 = setTableOption(pCxt, yymsp[-1].minor.yy616, yymsp[0].minor.yy669.type, &yymsp[0].minor.yy669.val); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 188: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy669.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy669.val = yymsp[0].minor.yy0; }
        break;
      case 189: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy669.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy669.val = yymsp[0].minor.yy0; }
        break;
      case 190: /* duration_list ::= duration_literal */
      case 351: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==351);
{ yylhsminor.yy152 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy616)); }
  yymsp[0].minor.yy152 = yylhsminor.yy152;
        break;
      case 191: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 352: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==352);
{ yylhsminor.yy152 = addNodeToList(pCxt, yymsp[-2].minor.yy152, releaseRawExprNode(pCxt, yymsp[0].minor.yy616)); }
  yymsp[-2].minor.yy152 = yylhsminor.yy152;
        break;
      case 194: /* rollup_func_name ::= function_name */
{ yylhsminor.yy616 = createFunctionNode(pCxt, &yymsp[0].minor.yy673, NULL); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 195: /* rollup_func_name ::= FIRST */
      case 196: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==196);
{ yylhsminor.yy616 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 199: /* col_name ::= column_name */
{ yylhsminor.yy616 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy673); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 200: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 201: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 202: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 203: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy616, yymsp[0].minor.yy616, OP_TYPE_LIKE); }
        break;
      case 204: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy616, yymsp[0].minor.yy616, OP_TYPE_LIKE); }
        break;
      case 205: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy616, NULL, OP_TYPE_LIKE); }
        break;
      case 206: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 207: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 208: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 209: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 210: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy616, yymsp[-1].minor.yy616, OP_TYPE_EQUAL); }
        break;
      case 211: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 212: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 213: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 214: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 215: /* cmd ::= SHOW LICENCES */
      case 216: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==216);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 217: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy673); }
        break;
      case 218: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy616); }
        break;
      case 219: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy616); }
        break;
      case 220: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 221: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 222: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 223: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 224: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 225: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 226: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 227: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 228: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 229: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 230: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy616); }
        break;
      case 231: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 232: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 233: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy616, yymsp[-1].minor.yy616, OP_TYPE_EQUAL); }
        break;
      case 234: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 235: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 236: /* db_name_cond_opt ::= */
      case 241: /* from_db_opt ::= */ yytestcase(yyruleno==241);
{ yymsp[1].minor.yy616 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 237: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy673); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 238: /* like_pattern_opt ::= */
      case 283: /* subtable_opt ::= */ yytestcase(yyruleno==283);
      case 395: /* case_when_else_opt ::= */ yytestcase(yyruleno==395);
      case 425: /* from_clause_opt ::= */ yytestcase(yyruleno==425);
      case 454: /* where_clause_opt ::= */ yytestcase(yyruleno==454);
      case 463: /* twindow_clause_opt ::= */ yytestcase(yyruleno==463);
      case 468: /* sliding_opt ::= */ yytestcase(yyruleno==468);
      case 470: /* fill_opt ::= */ yytestcase(yyruleno==470);
      case 482: /* having_clause_opt ::= */ yytestcase(yyruleno==482);
      case 484: /* range_opt ::= */ yytestcase(yyruleno==484);
      case 486: /* every_opt ::= */ yytestcase(yyruleno==486);
      case 499: /* slimit_clause_opt ::= */ yytestcase(yyruleno==499);
      case 503: /* limit_clause_opt ::= */ yytestcase(yyruleno==503);
{ yymsp[1].minor.yy616 = NULL; }
        break;
      case 239: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 240: /* table_name_cond ::= table_name */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy673); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 242: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy673); }
        break;
      case 243: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy89, yymsp[-3].minor.yy616, yymsp[-1].minor.yy616, NULL, yymsp[0].minor.yy616); }
        break;
      case 244: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy89, yymsp[0].minor.yy616); }
        break;
      case 245: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy616 = createIndexOption(pCxt, yymsp[-7].minor.yy152, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), NULL, yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 246: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy616 = createIndexOption(pCxt, yymsp[-9].minor.yy152, releaseRawExprNode(pCxt, yymsp[-5].minor.yy616), releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 249: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy616 = createFunctionNode(pCxt, &yymsp[-3].minor.yy673, yymsp[-1].minor.yy152); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 250: /* sma_stream_opt ::= */
      case 277: /* stream_options ::= */ yytestcase(yyruleno==277);
{ yymsp[1].minor.yy616 = createStreamOptions(pCxt); }
        break;
      case 251: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 281: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==281);
{ ((SStreamOptions*)yymsp[-2].minor.yy616)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy616); yylhsminor.yy616 = yymsp[-2].minor.yy616; }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 252: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy616)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy616); yylhsminor.yy616 = yymsp[-2].minor.yy616; }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 253: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy89, &yymsp[-2].minor.yy673, yymsp[0].minor.yy616); }
        break;
      case 254: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy89, &yymsp[-3].minor.yy673, &yymsp[0].minor.yy673, false); }
        break;
      case 255: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy89, &yymsp[-5].minor.yy673, &yymsp[0].minor.yy673, true); }
        break;
      case 256: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy89, &yymsp[-3].minor.yy673, yymsp[0].minor.yy616, false); }
        break;
      case 257: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy89, &yymsp[-5].minor.yy673, yymsp[0].minor.yy616, true); }
        break;
      case 258: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy673); }
        break;
      case 259: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy89, &yymsp[-2].minor.yy673, &yymsp[0].minor.yy673); }
        break;
      case 260: /* cmd ::= DESC full_table_name */
      case 261: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==261);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy616); }
        break;
      case 262: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 263: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy89, yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 265: /* analyze_opt ::= ANALYZE */
      case 272: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==272);
      case 445: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==445);
{ yymsp[0].minor.yy89 = true; }
        break;
      case 266: /* explain_options ::= */
{ yymsp[1].minor.yy616 = createDefaultExplainOptions(pCxt); }
        break;
      case 267: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy616 = setExplainVerbose(pCxt, yymsp[-2].minor.yy616, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 268: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy616 = setExplainRatio(pCxt, yymsp[-2].minor.yy616, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 269: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy89, yymsp[-8].minor.yy89, &yymsp[-5].minor.yy673, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy784, yymsp[0].minor.yy452); }
        break;
      case 270: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy673); }
        break;
      case 275: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy89, &yymsp[-7].minor.yy673, yymsp[-4].minor.yy616, yymsp[-6].minor.yy616, yymsp[-3].minor.yy152, yymsp[-2].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 276: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy89, &yymsp[0].minor.yy673); }
        break;
      case 278: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy616)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy616 = yymsp[-2].minor.yy616; }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 279: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy616)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy616 = yymsp[-2].minor.yy616; }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 280: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy616)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy616)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy616); yylhsminor.yy616 = yymsp[-3].minor.yy616; }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 282: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy616)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy616 = yymsp[-3].minor.yy616; }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 284: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 469: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==469);
      case 487: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==487);
{ yymsp[-3].minor.yy616 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy616); }
        break;
      case 285: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 286: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 287: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 288: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 289: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 290: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy152); }
        break;
      case 291: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 292: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy152 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 294: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 296: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy616, yymsp[-2].minor.yy152, yymsp[0].minor.yy616); }
        break;
      case 297: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy616, NULL, yymsp[0].minor.yy616); }
        break;
      case 298: /* literal ::= NK_INTEGER */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 299: /* literal ::= NK_FLOAT */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 300: /* literal ::= NK_STRING */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 301: /* literal ::= NK_BOOL */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 302: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 303: /* literal ::= duration_literal */
      case 313: /* signed_literal ::= signed */ yytestcase(yyruleno==313);
      case 333: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==333);
      case 334: /* expr_or_subquery ::= subquery */ yytestcase(yyruleno==334);
      case 335: /* expression ::= literal */ yytestcase(yyruleno==335);
      case 336: /* expression ::= pseudo_column */ yytestcase(yyruleno==336);
      case 337: /* expression ::= column_reference */ yytestcase(yyruleno==337);
      case 338: /* expression ::= function_expression */ yytestcase(yyruleno==338);
      case 339: /* expression ::= case_when_expression */ yytestcase(yyruleno==339);
      case 368: /* function_expression ::= literal_func */ yytestcase(yyruleno==368);
      case 417: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==417);
      case 421: /* boolean_primary ::= predicate */ yytestcase(yyruleno==421);
      case 423: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==423);
      case 424: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==424);
      case 427: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==427);
      case 429: /* table_reference ::= table_primary */ yytestcase(yyruleno==429);
      case 430: /* table_reference ::= joined_table */ yytestcase(yyruleno==430);
      case 434: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==434);
      case 489: /* query_simple ::= query_specification */ yytestcase(yyruleno==489);
      case 490: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==490);
      case 493: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==493);
      case 495: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==495);
{ yylhsminor.yy616 = yymsp[0].minor.yy616; }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 304: /* literal ::= NULL */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 305: /* literal ::= NK_QUESTION */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 306: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 307: /* signed ::= NK_INTEGER */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 308: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 309: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 310: /* signed ::= NK_FLOAT */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 311: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 312: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 314: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 315: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 316: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 317: /* signed_literal ::= duration_literal */
      case 319: /* signed_literal ::= literal_func */ yytestcase(yyruleno==319);
      case 388: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==388);
      case 450: /* select_item ::= common_expression */ yytestcase(yyruleno==450);
      case 460: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==460);
      case 494: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==494);
      case 496: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==496);
      case 509: /* search_condition ::= common_expression */ yytestcase(yyruleno==509);
{ yylhsminor.yy616 = releaseRawExprNode(pCxt, yymsp[0].minor.yy616); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 318: /* signed_literal ::= NULL */
{ yylhsminor.yy616 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 320: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy616 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 340: /* expression ::= NK_LP expression NK_RP */
      case 422: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==422);
      case 508: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==508);
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy616)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 341: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy616));
                                                                                  }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 342: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy616), NULL));
                                                                                  }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 343: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); 
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 344: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); 
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 345: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); 
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 346: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); 
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 347: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 348: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 349: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 350: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 353: /* column_reference ::= column_name */
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy673, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy673)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 354: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy673, &yymsp[0].minor.yy673, createColumnNode(pCxt, &yymsp[-2].minor.yy673, &yymsp[0].minor.yy673)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 355: /* pseudo_column ::= ROWTS */
      case 356: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==356);
      case 358: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==358);
      case 359: /* pseudo_column ::= QEND */ yytestcase(yyruleno==359);
      case 360: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==360);
      case 361: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==361);
      case 362: /* pseudo_column ::= WEND */ yytestcase(yyruleno==362);
      case 363: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==363);
      case 364: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==364);
      case 370: /* literal_func ::= NOW */ yytestcase(yyruleno==370);
{ yylhsminor.yy616 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 357: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy673, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy673)))); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 365: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 366: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==366);
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy673, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy673, yymsp[-1].minor.yy152)); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 367: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), yymsp[-1].minor.yy784)); }
  yymsp[-5].minor.yy616 = yylhsminor.yy616;
        break;
      case 369: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy673, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy673, NULL)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 384: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy152 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy152 = yylhsminor.yy152;
        break;
      case 389: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 453: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==453);
{ yylhsminor.yy616 = createColumnNode(pCxt, &yymsp[-2].minor.yy673, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 390: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy152, yymsp[-1].minor.yy616)); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 391: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), yymsp[-2].minor.yy152, yymsp[-1].minor.yy616)); }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 394: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy616 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)); }
        break;
      case 396: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy616 = releaseRawExprNode(pCxt, yymsp[0].minor.yy616); }
        break;
      case 397: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 402: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==402);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy380, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 398: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy616), releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-4].minor.yy616 = yylhsminor.yy616;
        break;
      case 399: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy616), releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-5].minor.yy616 = yylhsminor.yy616;
        break;
      case 400: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), NULL));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 401: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), NULL));
                                                                                  }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 403: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy380 = OP_TYPE_LOWER_THAN; }
        break;
      case 404: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy380 = OP_TYPE_GREATER_THAN; }
        break;
      case 405: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy380 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 406: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy380 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 407: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy380 = OP_TYPE_NOT_EQUAL; }
        break;
      case 408: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy380 = OP_TYPE_EQUAL; }
        break;
      case 409: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy380 = OP_TYPE_LIKE; }
        break;
      case 410: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy380 = OP_TYPE_NOT_LIKE; }
        break;
      case 411: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy380 = OP_TYPE_MATCH; }
        break;
      case 412: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy380 = OP_TYPE_NMATCH; }
        break;
      case 413: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy380 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 414: /* in_op ::= IN */
{ yymsp[0].minor.yy380 = OP_TYPE_IN; }
        break;
      case 415: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy380 = OP_TYPE_NOT_IN; }
        break;
      case 416: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy152)); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 418: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy616), NULL));
                                                                                  }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 419: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 420: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy616);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy616);
                                                                                    yylhsminor.yy616 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), releaseRawExprNode(pCxt, yymsp[0].minor.yy616)));
                                                                                  }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 426: /* from_clause_opt ::= FROM table_reference_list */
      case 455: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==455);
      case 483: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==483);
{ yymsp[-1].minor.yy616 = yymsp[0].minor.yy616; }
        break;
      case 428: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy616 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy616, yymsp[0].minor.yy616, NULL); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 431: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy616 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy673, &yymsp[0].minor.yy673); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 432: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy616 = createRealTableNode(pCxt, &yymsp[-3].minor.yy673, &yymsp[-1].minor.yy673, &yymsp[0].minor.yy673); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 433: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy616 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy616), &yymsp[0].minor.yy673); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 435: /* alias_opt ::= */
{ yymsp[1].minor.yy673 = nil_token;  }
        break;
      case 436: /* alias_opt ::= table_alias */
{ yylhsminor.yy673 = yymsp[0].minor.yy673; }
  yymsp[0].minor.yy673 = yylhsminor.yy673;
        break;
      case 437: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy673 = yymsp[0].minor.yy673; }
        break;
      case 438: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 439: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==439);
{ yymsp[-2].minor.yy616 = yymsp[-1].minor.yy616; }
        break;
      case 440: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy616 = createJoinTableNode(pCxt, yymsp[-4].minor.yy596, yymsp[-5].minor.yy616, yymsp[-2].minor.yy616, yymsp[0].minor.yy616); }
  yymsp[-5].minor.yy616 = yylhsminor.yy616;
        break;
      case 441: /* join_type ::= */
{ yymsp[1].minor.yy596 = JOIN_TYPE_INNER; }
        break;
      case 442: /* join_type ::= INNER */
{ yymsp[0].minor.yy596 = JOIN_TYPE_INNER; }
        break;
      case 443: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy616 = createSelectStmt(pCxt, yymsp[-10].minor.yy89, yymsp[-9].minor.yy152, yymsp[-8].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addWhereClause(pCxt, yymsp[-11].minor.yy616, yymsp[-7].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addPartitionByClause(pCxt, yymsp[-11].minor.yy616, yymsp[-6].minor.yy152);
                                                                                    yymsp[-11].minor.yy616 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy616, yymsp[-2].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addGroupByClause(pCxt, yymsp[-11].minor.yy616, yymsp[-1].minor.yy152);
                                                                                    yymsp[-11].minor.yy616 = addHavingClause(pCxt, yymsp[-11].minor.yy616, yymsp[0].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addRangeClause(pCxt, yymsp[-11].minor.yy616, yymsp[-5].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addEveryClause(pCxt, yymsp[-11].minor.yy616, yymsp[-4].minor.yy616);
                                                                                    yymsp[-11].minor.yy616 = addFillClause(pCxt, yymsp[-11].minor.yy616, yymsp[-3].minor.yy616);
                                                                                  }
        break;
      case 446: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy89 = false; }
        break;
      case 449: /* select_item ::= NK_STAR */
{ yylhsminor.yy616 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy616 = yylhsminor.yy616;
        break;
      case 451: /* select_item ::= common_expression column_alias */
      case 461: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==461);
{ yylhsminor.yy616 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy616), &yymsp[0].minor.yy673); }
  yymsp[-1].minor.yy616 = yylhsminor.yy616;
        break;
      case 452: /* select_item ::= common_expression AS column_alias */
      case 462: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==462);
{ yylhsminor.yy616 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), &yymsp[0].minor.yy673); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 457: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 479: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==479);
      case 498: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==498);
{ yymsp[-2].minor.yy152 = yymsp[0].minor.yy152; }
        break;
      case 464: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy616 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), releaseRawExprNode(pCxt, yymsp[-1].minor.yy616)); }
        break;
      case 465: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy616 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy616)); }
        break;
      case 466: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy616 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), NULL, yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 467: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy616 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy616), releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), yymsp[-1].minor.yy616, yymsp[0].minor.yy616); }
        break;
      case 471: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy616 = createFillNode(pCxt, yymsp[-1].minor.yy102, NULL); }
        break;
      case 472: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy616 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy152)); }
        break;
      case 473: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy102 = FILL_MODE_NONE; }
        break;
      case 474: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy102 = FILL_MODE_PREV; }
        break;
      case 475: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy102 = FILL_MODE_NULL; }
        break;
      case 476: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy102 = FILL_MODE_LINEAR; }
        break;
      case 477: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy102 = FILL_MODE_NEXT; }
        break;
      case 480: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy152 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); }
  yymsp[0].minor.yy152 = yylhsminor.yy152;
        break;
      case 481: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy152 = addNodeToList(pCxt, yymsp[-2].minor.yy152, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy616))); }
  yymsp[-2].minor.yy152 = yylhsminor.yy152;
        break;
      case 485: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy616 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy616), releaseRawExprNode(pCxt, yymsp[-1].minor.yy616)); }
        break;
      case 488: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy616 = addOrderByClause(pCxt, yymsp[-3].minor.yy616, yymsp[-2].minor.yy152);
                                                                                    yylhsminor.yy616 = addSlimitClause(pCxt, yylhsminor.yy616, yymsp[-1].minor.yy616);
                                                                                    yylhsminor.yy616 = addLimitClause(pCxt, yylhsminor.yy616, yymsp[0].minor.yy616);
                                                                                  }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 491: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy616 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy616, yymsp[0].minor.yy616); }
  yymsp[-3].minor.yy616 = yylhsminor.yy616;
        break;
      case 492: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy616 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy616, yymsp[0].minor.yy616); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 500: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 504: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==504);
{ yymsp[-1].minor.yy616 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 501: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 505: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==505);
{ yymsp[-3].minor.yy616 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 502: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 506: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==506);
{ yymsp[-3].minor.yy616 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 507: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy616 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy616); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 512: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy616 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy616), yymsp[-1].minor.yy386, yymsp[0].minor.yy585); }
  yymsp[-2].minor.yy616 = yylhsminor.yy616;
        break;
      case 513: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy386 = ORDER_ASC; }
        break;
      case 514: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy386 = ORDER_ASC; }
        break;
      case 515: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy386 = ORDER_DESC; }
        break;
      case 516: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy585 = NULL_ORDER_DEFAULT; }
        break;
      case 517: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy585 = NULL_ORDER_FIRST; }
        break;
      case 518: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy585 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
