/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 466
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  int8_t yy27;
  ENullOrder yy89;
  int64_t yy129;
  SToken yy233;
  SAlterOption yy257;
  bool yy397;
  EJoinType yy428;
  EFillMode yy646;
  SNodeList* yy776;
  int32_t yy832;
  SDataType yy852;
  EOperatorType yy856;
  EOrder yy870;
  SNode* yy924;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             734
#define YYNRULE              556
#define YYNTOKEN             326
#define YY_MAX_SHIFT         733
#define YY_MIN_SHIFTREDUCE   1087
#define YY_MAX_SHIFTREDUCE   1642
#define YY_ERROR_ACTION      1643
#define YY_ACCEPT_ACTION     1644
#define YY_NO_ACTION         1645
#define YY_MIN_REDUCE        1646
#define YY_MAX_REDUCE        2201
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2952)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1918, 2177,  366,  623, 1788, 2172,  474, 2001,  475, 1682,
 /*    10 */   163,  557,   45,   43, 1572, 1916,  610,   54, 1997, 1801,
 /*    20 */   374, 2176, 1421,   38,   37, 2173, 2175,   44,   42,   41,
 /*    30 */    40,   39,  419, 1502, 1799, 1419, 1715,   44,   42,   41,
 /*    40 */    40,   39,   38,   37, 2001,  175,   44,   42,   41,   40,
 /*    50 */    39, 1993, 1999,  356,  219, 1997,  377,  377, 1497,  163,
 /*    60 */   348, 2015,  633,   18,  160,  163,  344, 1901, 1802,  170,
 /*    70 */  1427,  354,  327, 1801, 1801,  509,  505,  501,  497,  216,
 /*    80 */  1850,  598,  379,   45,   43, 1845, 1847, 1448, 1993, 1999,
 /*    90 */   369,  374, 2033, 1421, 1446,   14, 2177,  337,  104,  633,
 /*   100 */   601,  528,  527,  526, 1502, 1983, 1419,  639,  101,  136,
 /*   110 */   522, 1609,  139, 1448,  521,   86,  480,  730,  214,  520,
 /*   120 */   525,  349,  476,  347,  346,  519,  515,   60, 1446, 1497,
 /*   130 */   517, 1120, 1504, 1505,   18, 2014,  623,  105, 1531, 2050,
 /*   140 */   177, 1427,  108, 2016,  643, 2018, 2019,  638, 1852,  633,
 /*   150 */   131,  140,  516, 1839,  178,  353, 2103,  513, 1421, 1791,
 /*   160 */   368, 2099, 1477, 1487, 1850, 1430,   14, 1799, 1503, 1506,
 /*   170 */  1122, 1419, 1125, 1126,  183,  600,  179, 2111, 2112,   85,
 /*   180 */   137, 2116, 2129, 1422,  234, 1420,  213,  207,  730, 1632,
 /*   190 */    64,  212,   38,   37,  488, 1532,   44,   42,   41,   40,
 /*   200 */    39, 1447, 1795, 1504, 1505,  165, 1427, 1658, 1425, 1426,
 /*   210 */   205, 1476, 1479, 1480, 1481, 1482, 1483, 1484, 1485, 1486,
 /*   220 */   635,  631, 1495, 1496, 1498, 1499, 1500, 1501,    2,   60,
 /*   230 */  1139,  266, 1138, 1477, 1487,  492, 1344, 1345,  121, 1503,
 /*   240 */  1506,  120,  119,  118,  117,  116,  115,  114,  113,  112,
 /*   250 */  1398, 1399, 2033,  730, 1422,  622, 1420,  266,   38,   37,
 /*   260 */   580, 1140,   44,   42,   41,   40,   39,   34,  372, 1526,
 /*   270 */  1527, 1528, 1529, 1530, 1534, 1535, 1536, 1537,  184, 1425,
 /*   280 */  1426,   60, 1476, 1479, 1480, 1481, 1482, 1483, 1484, 1485,
 /*   290 */  1486,  635,  631, 1495, 1496, 1498, 1499, 1500, 1501,    2,
 /*   300 */   175,   11,   45,   43,  579,  483,  598,  475, 1682,  457,
 /*   310 */   374,  420, 1421, 1361, 1362, 1433,  412,  622,  411, 1422,
 /*   320 */    49, 1420, 1902, 1502,  421, 1419, 1246,  665,  664,  663,
 /*   330 */  1250,  662, 1252, 1253,  661, 1255,  658,  139, 1261,  655,
 /*   340 */  1263, 1264,  652,  649, 1425, 1426, 1588,  608, 1497, 1360,
 /*   350 */  1363,   31,  267,   18,   41,   40,   39,   38,   37, 1639,
 /*   360 */  1427,   44,   42,   41,   40,   39,  598,  197,  196,  528,
 /*   370 */   527,  526, 2118,   45,   43, 1507, 1882,  136,  522,  593,
 /*   380 */   184,  374,  521, 1421, 1599,   14, 1646,  520,  525,   60,
 /*   390 */   456,   91,   48,  519, 1502,  622, 1419,  139, 2115,  408,
 /*   400 */  1533,  264, 2111,  597, 1669,  132,  596,  730, 1447, 2172,
 /*   410 */   130,  129,  128,  127,  126,  125,  124,  123,  122, 1497,
 /*   420 */   410,  406, 1504, 1505,  585,  181, 1918,   35,  285, 2173,
 /*   430 */   587, 1427,  184,  573, 1597, 1598, 1600, 1601,  365,   38,
 /*   440 */    37, 1915,  610,   44,   42,   41,   40,   39, 1983,  581,
 /*   450 */   166, 1449, 1477, 1487, 1638, 1753,   46,   52, 1503, 1506,
 /*   460 */  1647,  180, 2111, 2112,  561,  137, 2116, 1852,  233, 1445,
 /*   470 */    48,  184,   32, 1422,  341, 1420,  473, 1777,  730,  478,
 /*   480 */  1688,  121, 1538, 1850,  120,  119,  118,  117,  116,  115,
 /*   490 */   114,  113,  112, 1504, 1505,  276,  277,  413, 1425, 1426,
 /*   500 */   275, 1476, 1479, 1480, 1481, 1482, 1483, 1484, 1485, 1486,
 /*   510 */   635,  631, 1495, 1496, 1498, 1499, 1500, 1501,    2,  733,
 /*   520 */  1289, 1290,  482, 1477, 1487,  478, 1688,  437,  623, 1503,
 /*   530 */  1506,   88,  332,  292, 1446,  546,  436,  544,  542,  492,
 /*   540 */   184,  562,  186,  586, 1422, 2172, 1420, 2172,  174, 1776,
 /*   550 */   677,  540,  609,  538,  723,  719,  715,  711,  290, 1799,
 /*   560 */  2178,  181,  585,  181,  551, 2173,  587, 2173,  587, 1425,
 /*   570 */  1426,  604, 1476, 1479, 1480, 1481, 1482, 1483, 1484, 1485,
 /*   580 */  1486,  635,  631, 1495, 1496, 1498, 1499, 1500, 1501,    2,
 /*   590 */    45,   43, 2118,  533,  106,  244, 1954,  283,  374,  490,
 /*   600 */  1421, 1911, 1644,  609,  594,  675,  576, 1852,  543,   60,
 /*   610 */  1775, 1502, 2118, 1419,  362,  562, 1846, 1847, 2114, 2172,
 /*   620 */  2015,  184,  232, 1850,  153,  152,  672,  671,  670,  150,
 /*   630 */   619,   11,  623,    9, 2178,  181, 1497,  536, 2113, 2173,
 /*   640 */   587,  235,  530, 1139, 1668, 1138,  131,  231, 1427, 1667,
 /*   650 */   607, 2033, 1911,  518,   13,   12,  675,   11,  218,  640,
 /*   660 */   193,   45,   43, 1799, 1983,  270,  639, 1446,  389,  374,
 /*   670 */   269, 1421,  677,   46, 1140,  153,  152,  672,  671,  670,
 /*   680 */   150, 1427, 1502,   68, 1419, 1206,   67, 1387, 1983,  238,
 /*   690 */   582,  577,  571, 1983, 2014,  730,   82,  141, 2050,   81,
 /*   700 */  2074,  167, 2016,  643, 2018, 2019,  638, 1497,  633,  586,
 /*   710 */  1504, 1505,  562, 2172,  524,  523, 2172,   38,   37, 1427,
 /*   720 */  1208,   44,   42,   41,   40,   39,  609,  299,  585,  181,
 /*   730 */  1829, 2178,  181, 2173,  587, 1689, 2173,  587,  701,  699,
 /*   740 */  1477, 1487,  563, 2140,   14,   33, 1503, 1506,  623, 1545,
 /*   750 */   668,   38,   37,   27,  598,   44,   42,   41,   40,   39,
 /*   760 */   184, 1422,  417, 1420,   38,   37,  730, 1852,   44,   42,
 /*   770 */    41,   40,   39,  618,  367, 1911, 1666,  689,  625, 1799,
 /*   780 */  2075, 1504, 1505, 1850,  725,  139, 1425, 1426, 1774, 1476,
 /*   790 */  1479, 1480, 1481, 1482, 1483, 1484, 1485, 1486,  635,  631,
 /*   800 */  1495, 1496, 1498, 1499, 1500, 1501,    2,   85,  627, 1478,
 /*   810 */  2075, 1477, 1487,  330, 1784, 1444, 1897, 1503, 1506, 1852,
 /*   820 */  1983,  135,  450,  380,  623,  464,  378,  189,  463, 2176,
 /*   830 */  1794,  163, 1422, 1786, 1420, 1850,  387,   99,  418,  669,
 /*   840 */  1801, 1790, 1843,  433,   50,  465,    3, 1665,  435,  182,
 /*   850 */  2111, 2112, 1997,  137, 2116, 1799, 1782, 1425, 1426, 1792,
 /*   860 */  1476, 1479, 1480, 1481, 1482, 1483, 1484, 1485, 1486,  635,
 /*   870 */   631, 1495, 1496, 1498, 1499, 1500, 1501,    2,  623,  623,
 /*   880 */   562, 1576, 1569,  164, 2172, 1993, 1999, 1446,  305,  345,
 /*   890 */  1712, 1983,  427,  442,  667,  675,  633,  623,  623, 2178,
 /*   900 */   181,  423,  303,   71, 2173,  587,   70, 1852,    8, 1799,
 /*   910 */  1799,  443,  491, 1449,  153,  152,  672,  671,  670,  150,
 /*   920 */   162, 1897, 1897, 1851,  201,  470,  468,  673, 1799, 1799,
 /*   930 */  1843,  461,  191,  195,  455,  454,  453,  452,  449,  448,
 /*   940 */   447,  446,  445,  441,  440,  439,  438,  329,  430,  429,
 /*   950 */   428, 1664,  425,  424,  343,  707,  706,  705,  704,  384,
 /*   960 */    60,  703,  702,  143,  697,  696,  695,  694,  693,  692,
 /*   970 */   691,  155,  687,  686,  685,  383,  382,  682,  681,  680,
 /*   980 */   679,  678,  674,  386,  690, 1843, 1769,  590, 1663,  623,
 /*   990 */  1512,  549,  371,  370, 2177, 1983, 1446,  623, 2172,  107,
 /*  1000 */    38,   37, 1435, 1796,   44,   42,   41,   40,   39, 1125,
 /*  1010 */  1126,  236,  623, 1502, 2176, 1428, 1641, 1642, 2173, 2174,
 /*  1020 */  1799, 1662,  623, 1449, 2123, 1565,  558,  562, 1799, 1478,
 /*  1030 */   623, 2172, 1983, 1661, 1660,  562,  602,  151, 1497, 2172,
 /*  1040 */    79,   78,  416, 1799,  606,  188, 2178,  181,  623, 2015,
 /*  1050 */  1427, 2173,  587, 1799, 2178,  181, 1970,  190, 1657, 2173,
 /*  1060 */   587, 1799,  280,  328, 2002, 1983,  404,  623,  402,  398,
 /*  1070 */   394,  391,  388,  239,   72, 1997, 2015, 1983, 1983, 1799,
 /*  1080 */  2033,  620,  623, 1702, 1656,  623,  623,  151,  640,   53,
 /*  1090 */  1659,  589, 1655, 1983,  630,  639,  621,  629, 1799,  286,
 /*  1100 */   381, 1654, 1983, 1653,  396,  529, 1429, 2033, 1993, 1999,
 /*  1110 */  1754,  184, 1652, 1799, 1565,  601, 1799, 1799,  224,  633,
 /*  1120 */  1983,  222,  639, 2014,   80, 1568, 1651, 2050, 1983, 1650,
 /*  1130 */   108, 2016,  643, 2018, 2019,  638, 1983,  633, 1478, 1393,
 /*  1140 */   142, 2015,  148, 2074, 2103, 1983,  517, 1983,  368, 2099,
 /*  1150 */  2014, 1649,  226,  634, 2050,  225, 1983,  108, 2016,  643,
 /*  1160 */  2018, 2019,  638, 1436,  633, 1431,  151,  243,  516,  178,
 /*  1170 */  1983, 2103, 2033, 1983, 1695,  368, 2099,  145,  228,  133,
 /*  1180 */   640,  227,  242,   62, 2143, 1983, 1693,  639, 1439, 1441,
 /*  1190 */   248,  230,  151, 1168,  229, 1983,  531, 2130, 2004, 2015,
 /*  1200 */    47,  631, 1495, 1496, 1498, 1499, 1500, 1501,  534,  273,
 /*  1210 */   591,  683,   69,  149,  151, 2014,   13,   12, 1396, 2050,
 /*  1220 */    62,   89,  108, 2016,  643, 2018, 2019,  638, 1169,  633,
 /*  1230 */  2033,  261, 2015, 1187, 2192, 1596, 2103,   47,  640, 1523,
 /*  1240 */   368, 2099,  250, 1983,  605,  639, 2006,  684,   47,  647,
 /*  1250 */   149, 2137, 1358,  151,  217,  134, 1432,  574,  255, 2034,
 /*  1260 */   149,  278,  385, 2033,  615,  282, 1239, 1683, 1906, 1185,
 /*  1270 */  1840,  640, 1539, 2014, 2133,  599, 1983, 2050,  639,  260,
 /*  1280 */   108, 2016,  643, 2018, 2019,  638,  263,  633,    1, 1488,
 /*  1290 */  2015,  390, 2192,    4, 2103,  395,  342, 1380,  368, 2099,
 /*  1300 */   298, 1267, 1271,  293,  194, 1278, 2014, 1276,  422, 2150,
 /*  1310 */  2050, 1449,  154,  108, 2016,  643, 2018, 2019,  638, 1907,
 /*  1320 */   633, 2033,  426,  459,  431, 2192, 1444, 2103,  444,  640,
 /*  1330 */   451,  368, 2099, 1899, 1983,  458,  639,  460,  466,  467,
 /*  1340 */  1450,  198,  569,  469,  471,  472,  481, 1452,  204,  484,
 /*  1350 */  1447,  206,  485, 1451,  486, 1453,  487, 1142,  489,  512,
 /*  1360 */   209,  211,  493, 1960, 2014,   83,   84,  215, 2050,  510,
 /*  1370 */  2015,  108, 2016,  643, 2018, 2019,  638,  511,  633,  331,
 /*  1380 */   548,  514, 1959, 2192,  111, 2103, 1789,  221,  550,  368,
 /*  1390 */  2099,   87, 1785, 2015,  223,  156,  157,  147, 1787,  294,
 /*  1400 */  2166, 2033, 1783,  237,  158,  552,  159,  553,  556,  640,
 /*  1410 */   240,  559, 2149, 2134, 1983,  575,  639, 2148,  613,    7,
 /*  1420 */   584, 2125,  566, 2144, 2033,  572,  254,  171,  357,  256,
 /*  1430 */   578,  567,  640,  257,  565,  358,  564, 1983,  246,  639,
 /*  1440 */  2195,  258,  249,  595, 2014,  592, 2171, 1565, 2050,  138,
 /*  1450 */  1448,  108, 2016,  643, 2018, 2019,  638,  262,  633,  361,
 /*  1460 */  2015,  268,  603, 2192,  259, 2103, 1454, 2014,   94,  368,
 /*  1470 */  2099, 2050, 2119, 1912,  108, 2016,  643, 2018, 2019,  638,
 /*  1480 */  2122,  633,  295,  611, 2015,  612, 2078, 1926, 2103,  296,
 /*  1490 */  1925, 2033,  368, 2099,  616,   96, 1924,  297,  617,  640,
 /*  1500 */  1800,  364,   98,   59, 1983, 2084,  639,  100,  645, 1844,
 /*  1510 */  1770,  729,  726,  289,  300, 2033,  727,  324,  333,  334,
 /*  1520 */   309,   51,  304,  640,  302, 1977, 1976,  323, 1983,   76,
 /*  1530 */   639, 1975, 2015,   77, 2014,  313, 1974, 1971, 2050,  392,
 /*  1540 */   393,  108, 2016,  643, 2018, 2019,  638, 1413,  633, 1414,
 /*  1550 */   187,  397, 1969, 2076,  399, 2103, 2015,  400, 2014,  368,
 /*  1560 */  2099,  401, 2050, 2033, 1968,  108, 2016,  643, 2018, 2019,
 /*  1570 */   638,  640,  633,  403, 1967,  405, 1983,  626,  639, 2103,
 /*  1580 */  1966,  407, 1965,  368, 2099,  409, 1383, 2033, 1382, 1937,
 /*  1590 */  1936, 1935,  414,  415, 1934,  640, 1335, 1890, 1889, 1887,
 /*  1600 */  1983, 1886,  639,  144, 1885, 1888, 2014, 1884, 1883, 1881,
 /*  1610 */  2050, 1880, 1879,  109, 2016,  643, 2018, 2019,  638,  192,
 /*  1620 */   633,  432, 2015, 1878,  434, 1892, 1877, 2103, 1876, 1875,
 /*  1630 */  2014, 2102, 2099, 1874, 2050, 1873, 1872,  109, 2016,  643,
 /*  1640 */  2018, 2019,  638, 1871,  633, 2015, 1870, 1869, 1868, 1867,
 /*  1650 */  1866, 2103, 1865, 2033, 1864,  628, 2099, 1863,  146, 1862,
 /*  1660 */  1861,  640, 1860, 1891, 1859, 1858, 1983, 1337,  639, 1857,
 /*  1670 */  1856, 1855, 1854,  462, 1853, 1214, 2033, 1717,  199, 1716,
 /*  1680 */   200, 1714, 1678,  202,  637, 2003,  176, 1128, 1677, 1983,
 /*  1690 */    74,  639, 1127,  203, 1950, 1944,  641,   75, 1933, 1932,
 /*  1700 */  2050,  210,  477,  109, 2016,  643, 2018, 2019,  638, 1910,
 /*  1710 */   633, 1778, 1713, 2015,  479,  208, 1711, 2103,  494, 2014,
 /*  1720 */  1709,  336, 2099, 2050,  496, 1161,  321, 2016,  643, 2018,
 /*  1730 */  2019,  638,  636,  633,  624, 2068,  498,  495,  499, 2015,
 /*  1740 */  1707,  500,  502,  504, 2033,  503, 1705,  508,  506, 1692,
 /*  1750 */  1691,  507,  640, 1674, 1780, 1282, 1283, 1983, 1779,  639,
 /*  1760 */  1205, 1204, 1203, 1202, 1199, 1198,  698,  700,  220, 1197,
 /*  1770 */  2033, 1196,   61, 1703,  350, 1696, 1694,  351,  640,  352,
 /*  1780 */   535,  532, 1673, 1983, 1672,  639,  537, 2014, 1671,  541,
 /*  1790 */   110, 2050, 1405, 1949,  168, 2016,  643, 2018, 2019,  638,
 /*  1800 */   539,  633, 1943, 1403, 2015,  545, 1402, 1389,   55,   26,
 /*  1810 */    65,  554, 1931, 2014, 2177,   16,  161, 2050, 1929,   28,
 /*  1820 */   109, 2016,  643, 2018, 2019,  638,  570,  633, 1611, 2015,
 /*  1830 */    19,  568,  245,  169, 2103, 2033,   58,  247, 1595, 2100,
 /*  1840 */  1587,  241,  252,  640,  555,   30,  588, 2193, 1983,   63,
 /*  1850 */   639,  355,  253, 2004,  251,   29,  560,    5,   90,   21,
 /*  1860 */  2033, 1626, 2015,    6,   20, 1631, 1625,   17,  640,  359,
 /*  1870 */  1632, 1630, 1629, 1983,  360,  639, 1562, 1561, 2014,  265,
 /*  1880 */   172,   56, 2050, 1930,   57,  167, 2016,  643, 2018, 2019,
 /*  1890 */   638, 1928,  633, 2033, 1927, 2015, 1909,   93,   92,  271,
 /*  1900 */   272,  640,   22, 2014, 1593,  274, 1983, 2050,  639, 1908,
 /*  1910 */   315, 2016,  643, 2018, 2019,  638,  279,  633,   66,   95,
 /*  1920 */    97,  101,  284,  614,   10,   23, 2033, 2141,   12,  281,
 /*  1930 */  1437,  363,  173, 2053,  640, 1514, 2014, 1492,  632, 1983,
 /*  1940 */  2050,  639,   36,  168, 2016,  643, 2018, 2019,  638, 1490,
 /*  1950 */   633, 1524, 1489,  185,  583,   15,   24, 1469, 1461,   25,
 /*  1960 */  2015,  644, 1268, 1513,  646,  376,  648,  650, 1265, 2014,
 /*  1970 */  1260,  642,  651, 2050, 1262,  653,  322, 2016,  643, 2018,
 /*  1980 */  2019,  638,  654,  633, 1256, 2015,  656,  657,  659, 1254,
 /*  1990 */   660, 2033, 1259, 1245,  102, 1258, 2194,  103, 1257,  637,
 /*  2000 */   287, 1277, 1273, 1159, 1983,  666,  639,   73,  676, 1193,
 /*  2010 */  1192, 1191, 1190, 1189, 1188,  688, 2033, 1186, 1184, 1183,
 /*  2020 */  1182,  373, 1212, 1180,  640,  288, 1179, 1178, 1177, 1983,
 /*  2030 */  1176,  639, 1175, 1174, 2014, 1209, 1207, 1171, 2050, 1170,
 /*  2040 */  1167,  321, 2016,  643, 2018, 2019,  638, 2015,  633, 1166,
 /*  2050 */  2069, 1165, 1164, 1710,  708,  709, 1708,  710,  712, 2014,
 /*  2060 */   713,  714, 1706, 2050, 2015,  716,  322, 2016,  643, 2018,
 /*  2070 */  2019,  638,  717,  633,  718, 1704,  720,  722, 2033,  721,
 /*  2080 */  1690,  724, 1117,  375, 1670,  291,  640,  728, 1645, 1423,
 /*  2090 */   301, 1983,  731,  639,  732, 2033, 1645, 1645, 1645, 1645,
 /*  2100 */  1645, 1645, 1645,  640, 1645, 1645, 1645, 1645, 1983, 1645,
 /*  2110 */   639, 1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
 /*  2120 */  1645, 2014, 1645, 1645, 2015, 2050, 1645, 1645,  322, 2016,
 /*  2130 */   643, 2018, 2019,  638, 1645,  633, 1645, 1645,  547, 1645,
 /*  2140 */  1645, 1645, 2050, 2015, 1645,  317, 2016,  643, 2018, 2019,
 /*  2150 */   638, 1645,  633, 1645, 1645, 2033, 1645, 1645, 1645, 1645,
 /*  2160 */  1645, 1645, 1645,  640, 1645, 1645, 1645, 1645, 1983, 1645,
 /*  2170 */   639, 1645, 1645, 1645, 2033, 1645, 1645, 1645, 1645, 1645,
 /*  2180 */  1645, 1645,  640, 1645, 1645, 1645, 1645, 1983, 1645,  639,
 /*  2190 */  1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645, 2014, 1645,
 /*  2200 */  1645, 1645, 2050, 2015, 1645,  306, 2016,  643, 2018, 2019,
 /*  2210 */   638, 1645,  633, 1645, 1645, 1645, 1645, 2014, 1645, 2015,
 /*  2220 */  1645, 2050, 1645, 1645,  307, 2016,  643, 2018, 2019,  638,
 /*  2230 */  1645,  633, 1645, 1645, 2033, 1645, 2015, 1645, 1645, 1645,
 /*  2240 */  1645, 1645,  640, 1645, 1645, 1645, 1645, 1983, 1645,  639,
 /*  2250 */  2033, 1645, 1645, 1645, 1645, 1645, 1645, 1645,  640, 1645,
 /*  2260 */  1645, 1645, 1645, 1983, 1645,  639, 1645, 2033, 1645, 1645,
 /*  2270 */  1645, 1645, 1645, 1645, 1645,  640, 1645, 2014, 1645, 1645,
 /*  2280 */  1983, 2050,  639, 1645,  308, 2016,  643, 2018, 2019,  638,
 /*  2290 */  1645,  633, 1645, 2014, 1645, 1645, 1645, 2050, 1645, 2015,
 /*  2300 */   314, 2016,  643, 2018, 2019,  638, 1645,  633, 1645, 1645,
 /*  2310 */  2014, 1645, 1645, 1645, 2050, 2015, 1645,  318, 2016,  643,
 /*  2320 */  2018, 2019,  638, 1645,  633, 1645, 1645, 1645, 1645, 1645,
 /*  2330 */  2033, 1645, 1645, 1645, 1645, 1645, 1645, 1645,  640, 1645,
 /*  2340 */  1645, 1645, 1645, 1983, 1645,  639, 2033, 1645, 1645, 1645,
 /*  2350 */  1645, 1645, 1645, 1645,  640, 1645, 1645, 1645, 1645, 1983,
 /*  2360 */  1645,  639, 1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
 /*  2370 */  1645, 2015, 1645, 2014, 1645, 1645, 1645, 2050, 1645, 1645,
 /*  2380 */   310, 2016,  643, 2018, 2019,  638, 1645,  633, 1645, 2014,
 /*  2390 */  1645, 1645, 1645, 2050, 2015, 1645,  319, 2016,  643, 2018,
 /*  2400 */  2019,  638, 2033,  633, 1645, 1645, 1645, 1645, 1645, 1645,
 /*  2410 */   640, 1645, 1645, 1645, 1645, 1983, 1645,  639, 1645, 1645,
 /*  2420 */  1645, 1645, 1645, 1645, 1645, 2033, 1645, 1645, 1645, 1645,
 /*  2430 */  1645, 1645, 1645,  640, 1645, 1645, 1645, 1645, 1983, 1645,
 /*  2440 */   639, 1645, 1645, 1645, 1645, 2014, 1645, 1645, 1645, 2050,
 /*  2450 */  1645, 1645,  311, 2016,  643, 2018, 2019,  638, 2015,  633,
 /*  2460 */  1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645, 2014, 1645,
 /*  2470 */  1645, 1645, 2050, 1645, 1645,  320, 2016,  643, 2018, 2019,
 /*  2480 */   638, 1645,  633, 1645, 1645, 2015, 1645, 1645, 1645, 2033,
 /*  2490 */  1645, 1645, 1645, 1645, 1645, 1645, 1645,  640, 1645, 1645,
 /*  2500 */  1645, 1645, 1983, 1645,  639, 1645, 1645, 1645, 1645, 1645,
 /*  2510 */  1645, 1645, 1645, 1645, 1645, 1645, 2033, 1645, 1645, 1645,
 /*  2520 */  1645, 1645, 1645, 1645,  640, 1645, 1645, 1645, 1645, 1983,
 /*  2530 */  1645,  639, 2014, 2015, 1645, 1645, 2050, 1645, 1645,  312,
 /*  2540 */  2016,  643, 2018, 2019,  638, 1645,  633, 1645, 1645, 2015,
 /*  2550 */  1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645, 2014,
 /*  2560 */  1645, 1645, 1645, 2050, 2033, 1645,  325, 2016,  643, 2018,
 /*  2570 */  2019,  638,  640,  633, 1645, 1645, 1645, 1983, 1645,  639,
 /*  2580 */  2033, 1645, 1645, 1645, 1645, 1645, 1645, 1645,  640, 1645,
 /*  2590 */  1645, 1645, 1645, 1983, 1645,  639, 1645, 2015, 1645, 1645,
 /*  2600 */  1645, 1645, 1645, 1645, 1645, 1645, 1645, 2014, 1645, 1645,
 /*  2610 */  1645, 2050, 1645, 1645,  326, 2016,  643, 2018, 2019,  638,
 /*  2620 */  1645,  633, 1645, 2014, 1645, 1645, 1645, 2050, 2033, 1645,
 /*  2630 */  2027, 2016,  643, 2018, 2019,  638,  640,  633, 1645, 1645,
 /*  2640 */  1645, 1983, 1645,  639, 1645, 2015, 1645, 1645, 1645, 1645,
 /*  2650 */  1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
 /*  2660 */  1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645, 2015, 1645,
 /*  2670 */  1645, 2014, 1645, 1645, 1645, 2050, 2033, 1645, 2026, 2016,
 /*  2680 */   643, 2018, 2019,  638,  640,  633, 1645, 1645, 1645, 1983,
 /*  2690 */  1645,  639, 1645, 1645, 1645, 1645, 1645, 1645, 1645, 2033,
 /*  2700 */  1645, 2015, 1645, 1645, 1645, 1645, 1645,  640, 1645, 1645,
 /*  2710 */  1645, 1645, 1983, 1645,  639, 1645, 1645, 1645, 1645, 2014,
 /*  2720 */  1645, 1645, 1645, 2050, 2015, 1645, 2025, 2016,  643, 2018,
 /*  2730 */  2019,  638, 2033,  633, 1645, 1645, 1645, 1645, 1645, 1645,
 /*  2740 */   640, 1645, 2014, 1645, 1645, 1983, 2050,  639, 1645,  338,
 /*  2750 */  2016,  643, 2018, 2019,  638, 2033,  633, 1645, 1645, 1645,
 /*  2760 */  1645, 1645, 1645,  640, 1645, 1645, 1645, 1645, 1983, 1645,
 /*  2770 */   639, 1645, 1645, 1645, 1645, 2014, 1645, 1645, 1645, 2050,
 /*  2780 */  1645, 1645,  339, 2016,  643, 2018, 2019,  638, 2015,  633,
 /*  2790 */  1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645, 2014, 1645,
 /*  2800 */  1645, 1645, 2050, 1645, 1645,  335, 2016,  643, 2018, 2019,
 /*  2810 */   638, 1645,  633, 1645, 1645, 2015, 1645, 1645, 1645, 2033,
 /*  2820 */  1645, 1645, 1645, 1645, 1645, 1645, 1645,  640, 1645, 1645,
 /*  2830 */  1645, 1645, 1983, 1645,  639, 1645, 1645, 1645, 1645, 1645,
 /*  2840 */  1645, 1645, 1645, 1645, 1645, 1645, 2033, 1645, 1645, 1645,
 /*  2850 */  1645, 1645, 1645, 1645,  640, 1645, 1645, 1645, 1645, 1983,
 /*  2860 */  1645,  639, 2014, 2015, 1645, 1645, 2050, 1645, 1645,  340,
 /*  2870 */  2016,  643, 2018, 2019,  638, 1645,  633, 1645, 1645, 1645,
 /*  2880 */  1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,  641,
 /*  2890 */  1645, 1645, 1645, 2050, 2033, 1645,  317, 2016,  643, 2018,
 /*  2900 */  2019,  638,  640,  633, 1645, 1645, 1645, 1983, 1645,  639,
 /*  2910 */  1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
 /*  2920 */  1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645, 1645,
 /*  2930 */  1645, 1645, 1645, 1645, 1645, 1645, 1645, 2014, 1645, 1645,
 /*  2940 */  1645, 2050, 1645, 1645,  316, 2016,  643, 2018, 2019,  638,
 /*  2950 */  1645,  633,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   375,  436,  352,  337,  361,  440,  333,  362,  335,  336,
 /*    10 */   360,  396,   12,   13,   14,  390,  391,  351,  373,  369,
 /*    20 */    20,  456,   22,    8,    9,  460,  461,   12,   13,   14,
 /*    30 */    15,   16,  337,   33,  368,   35,    0,   12,   13,   14,
 /*    40 */    15,   16,    8,    9,  362,  360,   12,   13,   14,   15,
 /*    50 */    16,  406,  407,  408,   33,  373,  352,  352,   58,  360,
 /*    60 */    37,  329,  417,   63,  360,  360,  381,  382,  369,   48,
 /*    70 */    70,  367,  377,  369,  369,   54,   55,   56,   57,   58,
 /*    80 */   376,  337,  371,   12,   13,  374,  375,   20,  406,  407,
 /*    90 */   408,   20,  360,   22,   20,   95,    3,   63,   95,  417,
 /*   100 */   368,   65,   66,   67,   33,  373,   35,  375,  105,   73,
 /*   110 */    74,   96,  368,   20,   78,   94,   14,  117,   97,   83,
 /*   120 */    84,   98,   20,  100,  101,   89,  103,   95,   20,   58,
 /*   130 */   107,    4,  132,  133,   63,  403,  337,  341,  104,  407,
 /*   140 */   359,   70,  410,  411,  412,  413,  414,  415,  360,  417,
 /*   150 */   351,  355,  129,  372,  422,  367,  424,  358,   22,  363,
 /*   160 */   428,  429,  162,  163,  376,   35,   95,  368,  168,  169,
 /*   170 */    43,   35,   45,   46,  442,  431,  432,  433,  434,  343,
 /*   180 */   436,  437,  450,  183,  126,  185,  165,  166,  117,   96,
 /*   190 */     4,  170,    8,    9,  173,  161,   12,   13,   14,   15,
 /*   200 */    16,   20,  366,  132,  133,  328,   70,  330,  208,  209,
 /*   210 */   189,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,   95,
 /*   230 */    20,  164,   22,  162,  163,   62,  162,  163,   21,  168,
 /*   240 */   169,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   250 */   192,  193,  360,  117,  183,   20,  185,  164,    8,    9,
 /*   260 */   368,   51,   12,   13,   14,   15,   16,  233,  234,  235,
 /*   270 */   236,  237,  238,  239,  240,  241,  242,  243,  246,  208,
 /*   280 */   209,   95,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   290 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*   300 */   360,  230,   12,   13,  412,  333,  337,  335,  336,   79,
 /*   310 */    20,   22,   22,  132,  133,  185,  182,   20,  184,  183,
 /*   320 */    95,  185,  382,   33,   35,   35,  108,  109,  110,  111,
 /*   330 */   112,  113,  114,  115,  116,  117,  118,  368,  120,  121,
 /*   340 */   122,  123,  124,  125,  208,  209,   96,   20,   58,  168,
 /*   350 */   169,    2,   58,   63,   14,   15,   16,    8,    9,  175,
 /*   360 */    70,   12,   13,   14,   15,   16,  337,  137,  138,   65,
 /*   370 */    66,   67,  409,   12,   13,   14,    0,   73,   74,   44,
 /*   380 */   246,   20,   78,   22,  208,   95,    0,   83,   84,   95,
 /*   390 */   160,   97,   95,   89,   33,   20,   35,  368,  435,  178,
 /*   400 */   161,  432,  433,  434,  329,  436,  437,  117,   20,  440,
 /*   410 */    24,   25,   26,   27,   28,   29,   30,   31,   32,   58,
 /*   420 */   199,  200,  132,  133,  455,  456,  375,  425,  426,  460,
 /*   430 */   461,   70,  246,  257,  258,  259,  260,  261,  387,    8,
 /*   440 */     9,  390,  391,   12,   13,   14,   15,   16,  373,   20,
 /*   450 */   344,   20,  162,  163,  270,  349,   95,  164,  168,  169,
 /*   460 */     0,  432,  433,  434,  171,  436,  437,  360,  127,   20,
 /*   470 */    95,  246,  233,  183,  367,  185,  334,    0,  117,  337,
 /*   480 */   338,   21,  243,  376,   24,   25,   26,   27,   28,   29,
 /*   490 */    30,   31,   32,  132,  133,  126,  127,  392,  208,  209,
 /*   500 */   131,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   510 */   220,  221,  222,  223,  224,  225,  226,  227,  228,   19,
 /*   520 */   132,  133,  334,  162,  163,  337,  338,  151,  337,  168,
 /*   530 */   169,  190,  191,   33,   20,  194,  160,  196,   21,   62,
 /*   540 */   246,  436,  351,  436,  183,  440,  185,  440,   48,    0,
 /*   550 */    62,   34,  337,   36,   54,   55,   56,   57,   58,  368,
 /*   560 */   455,  456,  455,  456,  106,  460,  461,  460,  461,  208,
 /*   570 */   209,  392,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   580 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*   590 */    12,   13,  409,    4,   94,  164,  356,   97,   20,  384,
 /*   600 */    22,  386,  326,  337,  269,  107,  167,  360,   19,   95,
 /*   610 */     0,   33,  409,   35,  367,  436,  374,  375,  435,  440,
 /*   620 */   329,  246,   33,  376,  126,  127,  128,  129,  130,  131,
 /*   630 */   130,  230,  337,  232,  455,  456,   58,   48,  435,  460,
 /*   640 */   461,  401,   53,   20,  329,   22,  351,   58,   70,  329,
 /*   650 */   384,  360,  386,  358,    1,    2,  107,  230,   35,  368,
 /*   660 */    58,   12,   13,  368,  373,  165,  375,   20,  392,   20,
 /*   670 */   170,   22,   62,   95,   51,  126,  127,  128,  129,  130,
 /*   680 */   131,   70,   33,   94,   35,   35,   97,  187,  373,  189,
 /*   690 */   251,  252,  253,  373,  403,  117,   94,  420,  407,   97,
 /*   700 */   423,  410,  411,  412,  413,  414,  415,   58,  417,  436,
 /*   710 */   132,  133,  436,  440,  346,  347,  440,    8,    9,   70,
 /*   720 */    70,   12,   13,   14,   15,   16,  337,  353,  455,  456,
 /*   730 */   356,  455,  456,  460,  461,    0,  460,  461,  346,  347,
 /*   740 */   162,  163,  451,  452,   95,    2,  168,  169,  337,   96,
 /*   750 */   106,    8,    9,   44,  337,   12,   13,   14,   15,   16,
 /*   760 */   246,  183,  351,  185,    8,    9,  117,  360,   12,   13,
 /*   770 */    14,   15,   16,  384,  367,  386,  329,   70,  421,  368,
 /*   780 */   423,  132,  133,  376,   49,  368,  208,  209,    0,  211,
 /*   790 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   800 */   222,  223,  224,  225,  226,  227,  228,  343,  421,  162,
 /*   810 */   423,  162,  163,   18,  361,   20,  368,  168,  169,  360,
 /*   820 */   373,  357,   27,  352,  337,   30,  367,  379,   33,    3,
 /*   830 */   366,  360,  183,  361,  185,  376,  392,  341,  351,  370,
 /*   840 */   369,  362,  373,   48,   42,   50,   44,  329,   53,  432,
 /*   850 */   433,  434,  373,  436,  437,  368,  361,  208,  209,  363,
 /*   860 */   211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
 /*   870 */   221,  222,  223,  224,  225,  226,  227,  228,  337,  337,
 /*   880 */   436,   14,    4,   18,  440,  406,  407,   20,   23,   94,
 /*   890 */     0,  373,  351,  351,  361,  107,  417,  337,  337,  455,
 /*   900 */   456,  106,   37,   38,  460,  461,   41,  360,   39,  368,
 /*   910 */   368,  351,  351,   20,  126,  127,  128,  129,  130,  131,
 /*   920 */   164,  368,  368,  376,   59,   60,   61,  370,  368,  368,
 /*   930 */   373,  136,  379,  379,  139,  140,  141,  142,  143,  144,
 /*   940 */   145,  146,  147,  148,  149,  150,  151,  152,  153,  154,
 /*   950 */   155,  329,  157,  158,  159,   65,   66,   67,   68,   69,
 /*   960 */    95,   71,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   970 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   980 */    90,   91,  370,  392,  348,  373,  350,   44,  329,  337,
 /*   990 */    14,  392,   12,   13,  436,  373,   20,  337,  440,  134,
 /*  1000 */     8,    9,   22,  351,   12,   13,   14,   15,   16,   45,
 /*  1010 */    46,  351,  337,   33,  456,   35,  132,  133,  460,  461,
 /*  1020 */   368,  329,  337,   20,  244,  245,  351,  436,  368,  162,
 /*  1030 */   337,  440,  373,  329,  329,  436,  351,   44,   58,  440,
 /*  1040 */   175,  176,  177,  368,  351,  180,  455,  456,  337,  329,
 /*  1050 */    70,  460,  461,  368,  455,  456,    0,  164,  329,  460,
 /*  1060 */   461,  368,  351,  198,  362,  373,  201,  337,  203,  204,
 /*  1070 */   205,  206,  207,  361,  106,  373,  329,  373,  373,  368,
 /*  1080 */   360,  351,  337,    0,  329,  337,  337,   44,  368,   96,
 /*  1090 */   330,  265,  329,  373,   63,  375,  351,  117,  368,  351,
 /*  1100 */   351,  329,  373,  329,   48,   22,   35,  360,  406,  407,
 /*  1110 */   349,  246,  329,  368,  245,  368,  368,  368,   99,  417,
 /*  1120 */   373,  102,  375,  403,  156,  247,  329,  407,  373,  329,
 /*  1130 */   410,  411,  412,  413,  414,  415,  373,  417,  162,   96,
 /*  1140 */   420,  329,  422,  423,  424,  373,  107,  373,  428,  429,
 /*  1150 */   403,  329,   99,  361,  407,  102,  373,  410,  411,  412,
 /*  1160 */   413,  414,  415,  183,  417,  185,   44,  164,  129,  422,
 /*  1170 */   373,  424,  360,  373,    0,  428,  429,   42,   99,   44,
 /*  1180 */   368,  102,   58,   44,  383,  373,    0,  375,  208,  209,
 /*  1190 */    44,   99,   44,   35,  102,  373,   22,  450,   47,  329,
 /*  1200 */    44,  221,  222,  223,  224,  225,  226,  227,   22,   44,
 /*  1210 */   267,   13,   44,   44,   44,  403,    1,    2,   96,  407,
 /*  1220 */    44,   97,  410,  411,  412,  413,  414,  415,   70,  417,
 /*  1230 */   360,  464,  329,   35,  422,   96,  424,   44,  368,  208,
 /*  1240 */   428,  429,   96,  373,   96,  375,   95,   13,   44,   44,
 /*  1250 */    44,  439,   96,   44,  339,   44,  185,  453,  447,  360,
 /*  1260 */    44,   96,  339,  360,   96,   96,   96,  336,  383,   35,
 /*  1270 */   372,  368,   96,  403,  383,  438,  373,  407,  375,  430,
 /*  1280 */   410,  411,  412,  413,  414,  415,  457,  417,  441,   96,
 /*  1290 */   329,  405,  422,  248,  424,   48,  404,  181,  428,  429,
 /*  1300 */    96,   96,   96,  394,   42,   96,  403,   96,  380,  439,
 /*  1310 */   407,   20,   96,  410,  411,  412,  413,  414,  415,  383,
 /*  1320 */   417,  360,  380,  161,  378,  422,   20,  424,  337,  368,
 /*  1330 */   380,  428,  429,  337,  373,  378,  375,  378,   93,  345,
 /*  1340 */    20,  337,  439,  337,  337,  331,  331,   20,  343,  398,
 /*  1350 */    20,  343,  375,   20,  338,   20,  393,   52,  338,  331,
 /*  1360 */   343,  343,  337,  373,  403,  343,  343,  343,  407,  340,
 /*  1370 */   329,  410,  411,  412,  413,  414,  415,  340,  417,  331,
 /*  1380 */   197,  360,  373,  422,  337,  424,  360,  360,  402,  428,
 /*  1390 */   429,   95,  360,  329,  360,  360,  360,  400,  360,  398,
 /*  1400 */   439,  360,  360,  341,  360,  188,  360,  397,  375,  368,
 /*  1410 */   341,  337,  446,  383,  373,  256,  375,  446,  255,  262,
 /*  1420 */   174,  449,  373,  383,  360,  373,  448,  446,  373,  445,
 /*  1430 */   373,  264,  368,  444,  263,  271,  249,  373,  388,  375,
 /*  1440 */   465,  443,  388,  268,  403,  266,  459,  245,  407,  368,
 /*  1450 */    20,  410,  411,  412,  413,  414,  415,  458,  417,  338,
 /*  1460 */   329,  341,  337,  422,  405,  424,   20,  403,  341,  428,
 /*  1470 */   429,  407,  409,  386,  410,  411,  412,  413,  414,  415,
 /*  1480 */   439,  417,  388,  373,  329,  373,  422,  373,  424,  388,
 /*  1490 */   373,  360,  428,  429,  166,  341,  373,  356,  385,  368,
 /*  1500 */   368,  373,  341,   95,  373,  427,  375,   95,  364,  373,
 /*  1510 */   350,  331,   36,  341,  337,  360,  332,  399,  389,  389,
 /*  1520 */   354,  395,  327,  368,  342,    0,    0,  354,  373,  190,
 /*  1530 */   375,    0,  329,   42,  403,  354,    0,    0,  407,   35,
 /*  1540 */   202,  410,  411,  412,  413,  414,  415,   35,  417,   35,
 /*  1550 */    35,  202,    0,  422,   35,  424,  329,   35,  403,  428,
 /*  1560 */   429,  202,  407,  360,    0,  410,  411,  412,  413,  414,
 /*  1570 */   415,  368,  417,  202,    0,   35,  373,  422,  375,  424,
 /*  1580 */     0,   22,    0,  428,  429,   35,  185,  360,  183,    0,
 /*  1590 */     0,    0,  179,  178,    0,  368,   47,    0,    0,    0,
 /*  1600 */   373,    0,  375,   42,    0,    0,  403,    0,    0,    0,
 /*  1610 */   407,    0,    0,  410,  411,  412,  413,  414,  415,  151,
 /*  1620 */   417,   35,  329,    0,  151,    0,    0,  424,    0,    0,
 /*  1630 */   403,  428,  429,    0,  407,    0,    0,  410,  411,  412,
 /*  1640 */   413,  414,  415,    0,  417,  329,    0,    0,    0,    0,
 /*  1650 */     0,  424,    0,  360,    0,  428,  429,    0,   42,    0,
 /*  1660 */     0,  368,    0,    0,    0,    0,  373,   22,  375,    0,
 /*  1670 */     0,    0,    0,  135,    0,   35,  360,    0,   58,    0,
 /*  1680 */    58,    0,    0,   42,  368,   47,   44,   14,    0,  373,
 /*  1690 */    39,  375,   14,   40,    0,    0,  403,   39,    0,    0,
 /*  1700 */   407,  174,   47,  410,  411,  412,  413,  414,  415,    0,
 /*  1710 */   417,    0,    0,  329,   47,   39,    0,  424,   35,  403,
 /*  1720 */     0,  428,  429,  407,   39,   64,  410,  411,  412,  413,
 /*  1730 */   414,  415,  416,  417,  418,  419,   35,   48,   48,  329,
 /*  1740 */     0,   39,   35,   39,  360,   48,    0,   39,   35,    0,
 /*  1750 */     0,   48,  368,    0,    0,   22,   35,  373,    0,  375,
 /*  1760 */    35,   35,   35,   35,   35,   35,   44,   44,  102,   22,
 /*  1770 */   360,   35,  104,    0,   22,    0,    0,   22,  368,   22,
 /*  1780 */    35,   50,    0,  373,    0,  375,   35,  403,    0,   22,
 /*  1790 */    20,  407,   96,    0,  410,  411,  412,  413,  414,  415,
 /*  1800 */    35,  417,    0,   35,  329,  195,   35,   35,  164,   95,
 /*  1810 */    95,   22,    0,  403,    3,  250,  186,  407,    0,   95,
 /*  1820 */   410,  411,  412,  413,  414,  415,  254,  417,   96,  329,
 /*  1830 */    44,  229,   95,   95,  424,  360,   44,   96,   96,  429,
 /*  1840 */    96,  166,   44,  368,  164,   44,  462,  463,  373,    3,
 /*  1850 */   375,  164,   47,   47,   95,   95,  172,  171,   95,   44,
 /*  1860 */   360,   35,  329,  171,  250,   96,   35,  250,  368,   35,
 /*  1870 */    96,   35,   35,  373,   35,  375,   96,   96,  403,   47,
 /*  1880 */    47,  244,  407,    0,   44,  410,  411,  412,  413,  414,
 /*  1890 */   415,    0,  417,  360,    0,  329,    0,   39,   95,   47,
 /*  1900 */    96,  368,   95,  403,   96,   95,  373,  407,  375,    0,
 /*  1910 */   410,  411,  412,  413,  414,  415,   95,  417,   95,   39,
 /*  1920 */    95,  105,   47,  167,  231,   44,  360,  452,    2,  165,
 /*  1930 */    22,  365,   47,   95,  368,  229,  403,   96,   95,  373,
 /*  1940 */   407,  375,   95,  410,  411,  412,  413,  414,  415,   96,
 /*  1950 */   417,  208,   96,   47,  454,   95,   95,   22,   96,   95,
 /*  1960 */   329,  106,   96,  229,   35,   35,   95,   35,   96,  403,
 /*  1970 */   119,  210,   95,  407,   96,   35,  410,  411,  412,  413,
 /*  1980 */   414,  415,   95,  417,   96,  329,   35,   95,   35,   96,
 /*  1990 */    95,  360,  119,   22,   95,  119,  463,   95,  119,  368,
 /*  2000 */    44,   35,   22,   64,  373,  107,  375,   95,   63,   35,
 /*  2010 */    35,   35,   35,   35,   35,   92,  360,   35,   35,   35,
 /*  2020 */    35,  365,   70,   35,  368,   44,   35,   35,   22,  373,
 /*  2030 */    35,  375,   35,   35,  403,   70,   35,   35,  407,   35,
 /*  2040 */    35,  410,  411,  412,  413,  414,  415,  329,  417,   35,
 /*  2050 */   419,   22,   35,    0,   35,   48,    0,   39,   35,  403,
 /*  2060 */    48,   39,    0,  407,  329,   35,  410,  411,  412,  413,
 /*  2070 */   414,  415,   48,  417,   39,    0,   35,   39,  360,   48,
 /*  2080 */     0,   35,   35,  365,    0,   22,  368,   21,  466,   22,
 /*  2090 */    22,  373,   21,  375,   20,  360,  466,  466,  466,  466,
 /*  2100 */   466,  466,  466,  368,  466,  466,  466,  466,  373,  466,
 /*  2110 */   375,  466,  466,  466,  466,  466,  466,  466,  466,  466,
 /*  2120 */   466,  403,  466,  466,  329,  407,  466,  466,  410,  411,
 /*  2130 */   412,  413,  414,  415,  466,  417,  466,  466,  403,  466,
 /*  2140 */   466,  466,  407,  329,  466,  410,  411,  412,  413,  414,
 /*  2150 */   415,  466,  417,  466,  466,  360,  466,  466,  466,  466,
 /*  2160 */   466,  466,  466,  368,  466,  466,  466,  466,  373,  466,
 /*  2170 */   375,  466,  466,  466,  360,  466,  466,  466,  466,  466,
 /*  2180 */   466,  466,  368,  466,  466,  466,  466,  373,  466,  375,
 /*  2190 */   466,  466,  466,  466,  466,  466,  466,  466,  403,  466,
 /*  2200 */   466,  466,  407,  329,  466,  410,  411,  412,  413,  414,
 /*  2210 */   415,  466,  417,  466,  466,  466,  466,  403,  466,  329,
 /*  2220 */   466,  407,  466,  466,  410,  411,  412,  413,  414,  415,
 /*  2230 */   466,  417,  466,  466,  360,  466,  329,  466,  466,  466,
 /*  2240 */   466,  466,  368,  466,  466,  466,  466,  373,  466,  375,
 /*  2250 */   360,  466,  466,  466,  466,  466,  466,  466,  368,  466,
 /*  2260 */   466,  466,  466,  373,  466,  375,  466,  360,  466,  466,
 /*  2270 */   466,  466,  466,  466,  466,  368,  466,  403,  466,  466,
 /*  2280 */   373,  407,  375,  466,  410,  411,  412,  413,  414,  415,
 /*  2290 */   466,  417,  466,  403,  466,  466,  466,  407,  466,  329,
 /*  2300 */   410,  411,  412,  413,  414,  415,  466,  417,  466,  466,
 /*  2310 */   403,  466,  466,  466,  407,  329,  466,  410,  411,  412,
 /*  2320 */   413,  414,  415,  466,  417,  466,  466,  466,  466,  466,
 /*  2330 */   360,  466,  466,  466,  466,  466,  466,  466,  368,  466,
 /*  2340 */   466,  466,  466,  373,  466,  375,  360,  466,  466,  466,
 /*  2350 */   466,  466,  466,  466,  368,  466,  466,  466,  466,  373,
 /*  2360 */   466,  375,  466,  466,  466,  466,  466,  466,  466,  466,
 /*  2370 */   466,  329,  466,  403,  466,  466,  466,  407,  466,  466,
 /*  2380 */   410,  411,  412,  413,  414,  415,  466,  417,  466,  403,
 /*  2390 */   466,  466,  466,  407,  329,  466,  410,  411,  412,  413,
 /*  2400 */   414,  415,  360,  417,  466,  466,  466,  466,  466,  466,
 /*  2410 */   368,  466,  466,  466,  466,  373,  466,  375,  466,  466,
 /*  2420 */   466,  466,  466,  466,  466,  360,  466,  466,  466,  466,
 /*  2430 */   466,  466,  466,  368,  466,  466,  466,  466,  373,  466,
 /*  2440 */   375,  466,  466,  466,  466,  403,  466,  466,  466,  407,
 /*  2450 */   466,  466,  410,  411,  412,  413,  414,  415,  329,  417,
 /*  2460 */   466,  466,  466,  466,  466,  466,  466,  466,  403,  466,
 /*  2470 */   466,  466,  407,  466,  466,  410,  411,  412,  413,  414,
 /*  2480 */   415,  466,  417,  466,  466,  329,  466,  466,  466,  360,
 /*  2490 */   466,  466,  466,  466,  466,  466,  466,  368,  466,  466,
 /*  2500 */   466,  466,  373,  466,  375,  466,  466,  466,  466,  466,
 /*  2510 */   466,  466,  466,  466,  466,  466,  360,  466,  466,  466,
 /*  2520 */   466,  466,  466,  466,  368,  466,  466,  466,  466,  373,
 /*  2530 */   466,  375,  403,  329,  466,  466,  407,  466,  466,  410,
 /*  2540 */   411,  412,  413,  414,  415,  466,  417,  466,  466,  329,
 /*  2550 */   466,  466,  466,  466,  466,  466,  466,  466,  466,  403,
 /*  2560 */   466,  466,  466,  407,  360,  466,  410,  411,  412,  413,
 /*  2570 */   414,  415,  368,  417,  466,  466,  466,  373,  466,  375,
 /*  2580 */   360,  466,  466,  466,  466,  466,  466,  466,  368,  466,
 /*  2590 */   466,  466,  466,  373,  466,  375,  466,  329,  466,  466,
 /*  2600 */   466,  466,  466,  466,  466,  466,  466,  403,  466,  466,
 /*  2610 */   466,  407,  466,  466,  410,  411,  412,  413,  414,  415,
 /*  2620 */   466,  417,  466,  403,  466,  466,  466,  407,  360,  466,
 /*  2630 */   410,  411,  412,  413,  414,  415,  368,  417,  466,  466,
 /*  2640 */   466,  373,  466,  375,  466,  329,  466,  466,  466,  466,
 /*  2650 */   466,  466,  466,  466,  466,  466,  466,  466,  466,  466,
 /*  2660 */   466,  466,  466,  466,  466,  466,  466,  466,  329,  466,
 /*  2670 */   466,  403,  466,  466,  466,  407,  360,  466,  410,  411,
 /*  2680 */   412,  413,  414,  415,  368,  417,  466,  466,  466,  373,
 /*  2690 */   466,  375,  466,  466,  466,  466,  466,  466,  466,  360,
 /*  2700 */   466,  329,  466,  466,  466,  466,  466,  368,  466,  466,
 /*  2710 */   466,  466,  373,  466,  375,  466,  466,  466,  466,  403,
 /*  2720 */   466,  466,  466,  407,  329,  466,  410,  411,  412,  413,
 /*  2730 */   414,  415,  360,  417,  466,  466,  466,  466,  466,  466,
 /*  2740 */   368,  466,  403,  466,  466,  373,  407,  375,  466,  410,
 /*  2750 */   411,  412,  413,  414,  415,  360,  417,  466,  466,  466,
 /*  2760 */   466,  466,  466,  368,  466,  466,  466,  466,  373,  466,
 /*  2770 */   375,  466,  466,  466,  466,  403,  466,  466,  466,  407,
 /*  2780 */   466,  466,  410,  411,  412,  413,  414,  415,  329,  417,
 /*  2790 */   466,  466,  466,  466,  466,  466,  466,  466,  403,  466,
 /*  2800 */   466,  466,  407,  466,  466,  410,  411,  412,  413,  414,
 /*  2810 */   415,  466,  417,  466,  466,  329,  466,  466,  466,  360,
 /*  2820 */   466,  466,  466,  466,  466,  466,  466,  368,  466,  466,
 /*  2830 */   466,  466,  373,  466,  375,  466,  466,  466,  466,  466,
 /*  2840 */   466,  466,  466,  466,  466,  466,  360,  466,  466,  466,
 /*  2850 */   466,  466,  466,  466,  368,  466,  466,  466,  466,  373,
 /*  2860 */   466,  375,  403,  329,  466,  466,  407,  466,  466,  410,
 /*  2870 */   411,  412,  413,  414,  415,  466,  417,  466,  466,  466,
 /*  2880 */   466,  466,  466,  466,  466,  466,  466,  466,  466,  403,
 /*  2890 */   466,  466,  466,  407,  360,  466,  410,  411,  412,  413,
 /*  2900 */   414,  415,  368,  417,  466,  466,  466,  373,  466,  375,
 /*  2910 */   466,  466,  466,  466,  466,  466,  466,  466,  466,  466,
 /*  2920 */   466,  466,  466,  466,  466,  466,  466,  466,  466,  466,
 /*  2930 */   466,  466,  466,  466,  466,  466,  466,  403,  466,  466,
 /*  2940 */   466,  407,  466,  466,  410,  411,  412,  413,  414,  415,
 /*  2950 */   466,  417,
};
#define YY_SHIFT_COUNT    (733)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2084)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   865,    0,   71,    0,  290,  290,  290,  290,  290,  290,
 /*    10 */   290,  290,  290,  290,  290,  361,  578,  578,  649,  578,
 /*    20 */   578,  578,  578,  578,  578,  578,  578,  578,  578,  578,
 /*    30 */   578,  578,  578,  578,  578,  578,  578,  578,  578,  578,
 /*    40 */   578,  578,  578,  578,  578,  578,  578,  578,  375,  514,
 /*    50 */   297,  134,  294,   32,  225,   32,  297,  297,  980,  980,
 /*    60 */    32,  980,  980,  186,   32,  108,  181,  235,  235,  181,
 /*    70 */   127,  127,   74,  388,  102,  102,  235,  235,  235,  235,
 /*    80 */   235,  235,  235,  327,  235,  235,  173,  108,  235,  235,
 /*    90 */   429,  235,  108,  235,  327,  235,  327,  108,  235,  235,
 /*   100 */   108,  235,  108,  108,  108,  235,  488,  795,   34,   34,
 /*   110 */   217,  304,  136,  136,  136,  136,  136,  136,  136,  136,
 /*   120 */   136,  136,  136,  136,  136,  136,  136,  136,  136,  136,
 /*   130 */   136,   23,   93,   74,  388,  477,  650,   67,   67,   67,
 /*   140 */   610,  401,  401,  650,  449,  449,  449,  458,  427,  108,
 /*   150 */   611,  108,  611,  611,  644,  707,  218,  218,  218,  218,
 /*   160 */   218,  218,  218,  218,  500,  460,   36,  431,  184,  176,
 /*   170 */   623,  439,  867,  976,  210,  893,  964, 1039, 1003,  780,
 /*   180 */   869,  826,  780,  802,  878,  647, 1045, 1247, 1116, 1262,
 /*   190 */  1291, 1262, 1162, 1306, 1306, 1262, 1162, 1162, 1245, 1306,
 /*   200 */  1306, 1306, 1320, 1320, 1327,  173, 1330,  173, 1333, 1335,
 /*   210 */   173, 1333,  173,  173,  173, 1306,  173, 1305, 1305, 1320,
 /*   220 */   108,  108,  108,  108,  108,  108,  108,  108,  108,  108,
 /*   230 */   108, 1306, 1320,  611,  611, 1183, 1296, 1327,  488, 1217,
 /*   240 */  1330,  488, 1306, 1291, 1291,  611, 1159, 1163,  611, 1159,
 /*   250 */  1163,  611,  611,  108, 1157, 1246, 1159, 1167, 1171, 1187,
 /*   260 */  1045, 1164, 1175, 1179, 1202,  449, 1430, 1306, 1333,  488,
 /*   270 */   488, 1446, 1163,  611,  611,  611,  611,  611, 1163,  611,
 /*   280 */  1328,  488,  644,  488,  449, 1408, 1412,  611,  707, 1306,
 /*   290 */   488, 1476, 1320, 2952, 2952, 2952, 2952, 2952, 2952, 2952,
 /*   300 */  2952, 2952,  890,   21,  386,  589,   15,  709,  250,  549,
 /*   310 */   349,  743,  756,  788,  992,  992,  992,  992,  992,  992,
 /*   320 */   992,  992,  992,  498,  341,   25,   25,  230,  221,  376,
 /*   330 */   602,  517,   58,  369,  369,  340,  653,  239,  340,  340,
 /*   340 */   340,  993, 1056,  289, 1135,  968, 1019, 1053, 1079, 1092,
 /*   350 */  1083, 1174, 1186, 1043, 1122, 1124, 1139, 1146,  884,  943,
 /*   360 */   335,  293, 1148, 1156, 1165, 1168, 1169, 1170, 1215, 1176,
 /*   370 */   130, 1071, 1031, 1193, 1151, 1204, 1205, 1206, 1209, 1211,
 /*   380 */  1216,    3, 1198, 1234, 1158,  735, 1525, 1526, 1339, 1531,
 /*   390 */  1536, 1491, 1537, 1504, 1338, 1512, 1514, 1515, 1349, 1552,
 /*   400 */  1519, 1522, 1359, 1564, 1371, 1574, 1540, 1580, 1559, 1582,
 /*   410 */  1550, 1401, 1405, 1589, 1590, 1413, 1415, 1591, 1594, 1549,
 /*   420 */  1597, 1598, 1599, 1561, 1601, 1604, 1605, 1607, 1608, 1609,
 /*   430 */  1611, 1612, 1468, 1586, 1623, 1473, 1625, 1626, 1628, 1629,
 /*   440 */  1633, 1635, 1636, 1643, 1646, 1647, 1648, 1649, 1650, 1652,
 /*   450 */  1654, 1657, 1616, 1659, 1660, 1662, 1663, 1664, 1665, 1645,
 /*   460 */  1669, 1670, 1671, 1538, 1672, 1674, 1640, 1677, 1620, 1679,
 /*   470 */  1622, 1681, 1682, 1641, 1651, 1642, 1638, 1673, 1655, 1678,
 /*   480 */  1667, 1688, 1653, 1658, 1694, 1695, 1698, 1676, 1527, 1699,
 /*   490 */  1709, 1711, 1661, 1712, 1716, 1683, 1689, 1685, 1720, 1701,
 /*   500 */  1690, 1702, 1740, 1707, 1697, 1704, 1746, 1713, 1703, 1708,
 /*   510 */  1749, 1750, 1753, 1754, 1668, 1666, 1721, 1733, 1758, 1725,
 /*   520 */  1726, 1727, 1728, 1722, 1723, 1729, 1730, 1747, 1736, 1773,
 /*   530 */  1752, 1775, 1755, 1731, 1776, 1757, 1745, 1782, 1751, 1784,
 /*   540 */  1765, 1788, 1767, 1770, 1768, 1771, 1610, 1696, 1714, 1793,
 /*   550 */  1644, 1715, 1772, 1802, 1630, 1789, 1680, 1675, 1812, 1818,
 /*   560 */  1687, 1684, 1811, 1786, 1565, 1724, 1732, 1737, 1686, 1602,
 /*   570 */  1692, 1572, 1741, 1792, 1742, 1738, 1759, 1760, 1744, 1798,
 /*   580 */  1805, 1806, 1763, 1801, 1614, 1769, 1774, 1846, 1815, 1617,
 /*   590 */  1826, 1831, 1834, 1836, 1837, 1839, 1780, 1781, 1832, 1637,
 /*   600 */  1840, 1833, 1883, 1891, 1894, 1896, 1803, 1858, 1638, 1852,
 /*   610 */  1807, 1804, 1808, 1810, 1821, 1756, 1823, 1909, 1880, 1764,
 /*   620 */  1825, 1816, 1638, 1875, 1881, 1706, 1693, 1734, 1926, 1908,
 /*   630 */  1743, 1838, 1841, 1843, 1853, 1847, 1856, 1885, 1860, 1861,
 /*   640 */  1906, 1862, 1935, 1761, 1864, 1855, 1866, 1929, 1930, 1871,
 /*   650 */  1872, 1932, 1877, 1878, 1940, 1887, 1888, 1951, 1892, 1893,
 /*   660 */  1953, 1895, 1851, 1873, 1876, 1879, 1971, 1898, 1899, 1956,
 /*   670 */  1902, 1966, 1912, 1956, 1956, 1980, 1939, 1945, 1974, 1975,
 /*   680 */  1976, 1977, 1978, 1979, 1982, 1983, 1984, 1985, 1952, 1923,
 /*   690 */  1981, 1988, 1991, 1992, 2006, 1995, 1997, 1998, 1965, 1722,
 /*   700 */  2001, 1723, 2002, 2004, 2005, 2014, 2029, 2017, 2053, 2019,
 /*   710 */  2007, 2018, 2056, 2023, 2012, 2022, 2062, 2030, 2024, 2035,
 /*   720 */  2075, 2041, 2031, 2038, 2080, 2046, 2047, 2084, 2063, 2066,
 /*   730 */  2067, 2068, 2071, 2074,
};
#define YY_REDUCE_COUNT (301)
#define YY_REDUCE_MIN   (-435)
#define YY_REDUCE_MAX   (2534)
static const short yy_reduce_ofst[] = {
 /*     0 */   276, -268,  720,  747,  812,  870,  903,  961, 1041, 1064,
 /*    10 */  1131, 1155, 1203, 1227, 1293, 1316,  291, 1384, 1410, 1475,
 /*    20 */  1500, 1533, 1566, 1631, 1656, 1718, 1735, 1795, 1814, 1874,
 /*    30 */  1890, 1907, 1970, 1986, 2042, 2065, 2129, 2156, 2204, 2220,
 /*    40 */  2268, 2316, 2339, 2372, 2395, 2459, 2486, 2534,  -31,  107,
 /*    50 */  -256,  105,  179,  444,  591,  599,   29,  417, -355, -318,
 /*    60 */   273,  479,  702, -435,  558, -296,   51, -201,  295, -375,
 /*    70 */  -327,  -28, -315, -289,  142,  188, -334,  191,  411,  487,
 /*    80 */   541,  542,  560,  215,  561,  652,  464, -212,  660,  675,
 /*    90 */  -108,  685,  247,  693,  266,  711,  389, -350,  730,  745,
 /*   100 */   407,  748, -295,  459,  471,  749, -204, -305,    2,    2,
 /*   110 */  -123,  106,   75,  315,  320,  447,  518,  622,  659,  692,
 /*   120 */   704,  705,  729,  755,  763,  772,  774,  783,  797,  800,
 /*   130 */   822, -219,  -37,  -60,  242, -164,  368,  -37,  183,  203,
 /*   140 */   496,  357,  387,  392,  448,  553,  554,  240,  277, -301,
 /*   150 */   469,  547,  557,  612,  374,  636, -357,  453,  472,  495,
 /*   160 */   533,  712,  792,  533, -385,  760,  761,  801,  767,  804,
 /*   170 */   915,  811,  899,  899,  923,  885,  931,  898,  891,  837,
 /*   180 */   837,  829,  837,  849,  847,  899,  886,  892,  909,  928,
 /*   190 */   936,  942,  946,  991,  996,  950,  957,  959,  994, 1004,
 /*   200 */  1006, 1007, 1014, 1015,  951, 1005,  977, 1008, 1016,  963,
 /*   210 */  1017, 1020, 1018, 1022, 1023, 1025, 1024, 1029, 1037, 1028,
 /*   220 */  1021, 1026, 1027, 1032, 1034, 1035, 1036, 1038, 1042, 1044,
 /*   230 */  1046, 1047, 1048,  990, 1009,  986,  997, 1001, 1062, 1010,
 /*   240 */  1033, 1069, 1074, 1030, 1040, 1049,  966, 1050, 1052,  971,
 /*   250 */  1054, 1055, 1057,  899,  972,  978,  981,  984,  989,  998,
 /*   260 */  1059,  975,  987,  999,  837, 1081, 1063, 1125, 1121, 1120,
 /*   270 */  1127, 1087, 1094, 1110, 1112, 1114, 1117, 1123, 1101, 1128,
 /*   280 */  1113, 1154, 1141, 1161, 1132, 1078, 1144, 1136, 1160, 1177,
 /*   290 */  1172, 1184, 1180, 1126, 1118, 1129, 1130, 1166, 1173, 1181,
 /*   300 */  1182, 1195,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*    10 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*    20 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*    30 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*    40 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*    50 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*    60 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*    70 */  1643, 1643, 1900, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*    80 */  1643, 1643, 1643, 1643, 1643, 1643, 1721, 1643, 1643, 1643,
 /*    90 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   100 */  1643, 1643, 1643, 1643, 1643, 1643, 1719, 1893, 2105, 1643,
 /*   110 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   120 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   130 */  1643, 1643, 2117, 1643, 1643, 1721, 1643, 2117, 2117, 2117,
 /*   140 */  1719, 2077, 2077, 1643, 1643, 1643, 1643, 1953, 1643, 1643,
 /*   150 */  1643, 1643, 1643, 1643, 1828, 1643, 1643, 1643, 1643, 1643,
 /*   160 */  1852, 1643, 1643, 1643, 1945, 1643, 1643, 2142, 2196, 1643,
 /*   170 */  1643, 2145, 1643, 1643, 1643, 1905, 1643, 1781, 2132, 2109,
 /*   180 */  2123, 2180, 2110, 2107, 2126, 1643, 2136, 1643, 1938, 1898,
 /*   190 */  1643, 1898, 1895, 1643, 1643, 1898, 1895, 1895, 1772, 1643,
 /*   200 */  1643, 1643, 1643, 1643, 1643, 1721, 1643, 1721, 1643, 1643,
 /*   210 */  1721, 1643, 1721, 1721, 1721, 1643, 1721, 1700, 1700, 1643,
 /*   220 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   230 */  1643, 1643, 1643, 1643, 1643, 1963, 1951, 1643, 1719, 1947,
 /*   240 */  1643, 1719, 1643, 1643, 1643, 1643, 2153, 2151, 1643, 2153,
 /*   250 */  2151, 1643, 1643, 1643, 2165, 2161, 2153, 2169, 2167, 2138,
 /*   260 */  2136, 2199, 2186, 2182, 2123, 1643, 1643, 1643, 1643, 1719,
 /*   270 */  1719, 1643, 2151, 1643, 1643, 1643, 1643, 1643, 2151, 1643,
 /*   280 */  1643, 1719, 1643, 1719, 1643, 1643, 1797, 1643, 1643, 1643,
 /*   290 */  1719, 1675, 1643, 1940, 1956, 1923, 1923, 1831, 1831, 1831,
 /*   300 */  1722, 1648, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   310 */  1643, 1643, 1643, 1643, 2164, 2163, 2032, 1643, 2081, 2080,
 /*   320 */  2079, 2070, 2031, 1793, 1643, 2030, 2029, 1643, 1643, 1643,
 /*   330 */  1643, 1643, 1643, 1914, 1913, 2023, 1643, 1643, 2024, 2022,
 /*   340 */  2021, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   350 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 2183,
 /*   360 */  2187, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 2106, 1643,
 /*   370 */  1643, 1643, 1643, 1643, 2005, 1643, 1643, 1643, 1643, 1643,
 /*   380 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   390 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   400 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   410 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   420 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   430 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   440 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   450 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   460 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   470 */  1643, 1643, 1643, 1643, 1643, 1680, 2010, 1643, 1643, 1643,
 /*   480 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   490 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   500 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   510 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   520 */  1643, 1643, 1643, 1760, 1759, 1643, 1643, 1643, 1643, 1643,
 /*   530 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   540 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 2014, 1643, 1643,
 /*   550 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   560 */  1643, 1643, 2179, 2139, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   570 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   580 */  1643, 2005, 1643, 2162, 1643, 1643, 2177, 1643, 2181, 1643,
 /*   590 */  1643, 1643, 1643, 1643, 1643, 1643, 2116, 2112, 1643, 1643,
 /*   600 */  2108, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 2013, 1643,
 /*   610 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   620 */  1643, 1643, 2004, 1643, 2067, 1643, 1643, 1643, 2101, 1643,
 /*   630 */  1643, 2052, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   640 */  1643, 2014, 1643, 2017, 1643, 1643, 1643, 1643, 1643, 1825,
 /*   650 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   660 */  1643, 1643, 1810, 1808, 1807, 1806, 1643, 1803, 1643, 1838,
 /*   670 */  1643, 1643, 1643, 1834, 1833, 1643, 1643, 1643, 1643, 1643,
 /*   680 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   690 */  1740, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1732,
 /*   700 */  1643, 1731, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   710 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   720 */  1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643, 1643,
 /*   730 */  1643, 1643, 1643, 1643,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
  272,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*      START => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  272,  /*      AFTER => ABORT */
  272,  /*     ATTACH => ABORT */
  272,  /*     BEFORE => ABORT */
  272,  /*      BEGIN => ABORT */
  272,  /*     BITAND => ABORT */
  272,  /*     BITNOT => ABORT */
  272,  /*      BITOR => ABORT */
  272,  /*     BLOCKS => ABORT */
  272,  /*     CHANGE => ABORT */
  272,  /*      COMMA => ABORT */
  272,  /*    COMPACT => ABORT */
  272,  /*     CONCAT => ABORT */
  272,  /*   CONFLICT => ABORT */
  272,  /*       COPY => ABORT */
  272,  /*   DEFERRED => ABORT */
  272,  /* DELIMITERS => ABORT */
  272,  /*     DETACH => ABORT */
  272,  /*     DIVIDE => ABORT */
  272,  /*        DOT => ABORT */
  272,  /*       EACH => ABORT */
  272,  /*       FAIL => ABORT */
  272,  /*       FILE => ABORT */
  272,  /*        FOR => ABORT */
  272,  /*       GLOB => ABORT */
  272,  /*         ID => ABORT */
  272,  /*  IMMEDIATE => ABORT */
  272,  /*     IMPORT => ABORT */
  272,  /*  INITIALLY => ABORT */
  272,  /*    INSTEAD => ABORT */
  272,  /*     ISNULL => ABORT */
  272,  /*        KEY => ABORT */
  272,  /*    MODULES => ABORT */
  272,  /*  NK_BITNOT => ABORT */
  272,  /*    NK_SEMI => ABORT */
  272,  /*    NOTNULL => ABORT */
  272,  /*         OF => ABORT */
  272,  /*       PLUS => ABORT */
  272,  /*  PRIVILEGE => ABORT */
  272,  /*      RAISE => ABORT */
  272,  /*    REPLACE => ABORT */
  272,  /*   RESTRICT => ABORT */
  272,  /*        ROW => ABORT */
  272,  /*       SEMI => ABORT */
  272,  /*       STAR => ABORT */
  272,  /*  STATEMENT => ABORT */
  272,  /*     STRICT => ABORT */
  272,  /*     STRING => ABORT */
  272,  /*      TIMES => ABORT */
  272,  /*     UPDATE => ABORT */
  272,  /*     VALUES => ABORT */
  272,  /*   VARIABLE => ABORT */
  272,  /*       VIEW => ABORT */
  272,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "IF",
  /*   63 */ "NOT",
  /*   64 */ "EXISTS",
  /*   65 */ "BUFFER",
  /*   66 */ "CACHEMODEL",
  /*   67 */ "CACHESIZE",
  /*   68 */ "COMP",
  /*   69 */ "DURATION",
  /*   70 */ "NK_VARIABLE",
  /*   71 */ "MAXROWS",
  /*   72 */ "MINROWS",
  /*   73 */ "KEEP",
  /*   74 */ "PAGES",
  /*   75 */ "PAGESIZE",
  /*   76 */ "TSDB_PAGESIZE",
  /*   77 */ "PRECISION",
  /*   78 */ "REPLICA",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "WAL_LEVEL",
  /*   84 */ "WAL_FSYNC_PERIOD",
  /*   85 */ "WAL_RETENTION_PERIOD",
  /*   86 */ "WAL_RETENTION_SIZE",
  /*   87 */ "WAL_ROLL_PERIOD",
  /*   88 */ "WAL_SEGMENT_SIZE",
  /*   89 */ "STT_TRIGGER",
  /*   90 */ "TABLE_PREFIX",
  /*   91 */ "TABLE_SUFFIX",
  /*   92 */ "NK_COLON",
  /*   93 */ "MAX_SPEED",
  /*   94 */ "TABLE",
  /*   95 */ "NK_LP",
  /*   96 */ "NK_RP",
  /*   97 */ "STABLE",
  /*   98 */ "ADD",
  /*   99 */ "COLUMN",
  /*  100 */ "MODIFY",
  /*  101 */ "RENAME",
  /*  102 */ "TAG",
  /*  103 */ "SET",
  /*  104 */ "NK_EQ",
  /*  105 */ "USING",
  /*  106 */ "TAGS",
  /*  107 */ "COMMENT",
  /*  108 */ "BOOL",
  /*  109 */ "TINYINT",
  /*  110 */ "SMALLINT",
  /*  111 */ "INT",
  /*  112 */ "INTEGER",
  /*  113 */ "BIGINT",
  /*  114 */ "FLOAT",
  /*  115 */ "DOUBLE",
  /*  116 */ "BINARY",
  /*  117 */ "TIMESTAMP",
  /*  118 */ "NCHAR",
  /*  119 */ "UNSIGNED",
  /*  120 */ "JSON",
  /*  121 */ "VARCHAR",
  /*  122 */ "MEDIUMBLOB",
  /*  123 */ "BLOB",
  /*  124 */ "VARBINARY",
  /*  125 */ "DECIMAL",
  /*  126 */ "MAX_DELAY",
  /*  127 */ "WATERMARK",
  /*  128 */ "ROLLUP",
  /*  129 */ "TTL",
  /*  130 */ "SMA",
  /*  131 */ "DELETE_MARK",
  /*  132 */ "FIRST",
  /*  133 */ "LAST",
  /*  134 */ "SHOW",
  /*  135 */ "PRIVILEGES",
  /*  136 */ "DATABASES",
  /*  137 */ "TABLES",
  /*  138 */ "STABLES",
  /*  139 */ "MNODES",
  /*  140 */ "QNODES",
  /*  141 */ "FUNCTIONS",
  /*  142 */ "INDEXES",
  /*  143 */ "ACCOUNTS",
  /*  144 */ "APPS",
  /*  145 */ "CONNECTIONS",
  /*  146 */ "LICENCES",
  /*  147 */ "GRANTS",
  /*  148 */ "QUERIES",
  /*  149 */ "SCORES",
  /*  150 */ "TOPICS",
  /*  151 */ "VARIABLES",
  /*  152 */ "CLUSTER",
  /*  153 */ "BNODES",
  /*  154 */ "SNODES",
  /*  155 */ "TRANSACTIONS",
  /*  156 */ "DISTRIBUTED",
  /*  157 */ "CONSUMERS",
  /*  158 */ "SUBSCRIPTIONS",
  /*  159 */ "VNODES",
  /*  160 */ "ALIVE",
  /*  161 */ "LIKE",
  /*  162 */ "TBNAME",
  /*  163 */ "QTAGS",
  /*  164 */ "AS",
  /*  165 */ "INDEX",
  /*  166 */ "FUNCTION",
  /*  167 */ "INTERVAL",
  /*  168 */ "COUNT",
  /*  169 */ "LAST_ROW",
  /*  170 */ "TOPIC",
  /*  171 */ "WITH",
  /*  172 */ "META",
  /*  173 */ "CONSUMER",
  /*  174 */ "GROUP",
  /*  175 */ "DESC",
  /*  176 */ "DESCRIBE",
  /*  177 */ "RESET",
  /*  178 */ "QUERY",
  /*  179 */ "CACHE",
  /*  180 */ "EXPLAIN",
  /*  181 */ "ANALYZE",
  /*  182 */ "VERBOSE",
  /*  183 */ "NK_BOOL",
  /*  184 */ "RATIO",
  /*  185 */ "NK_FLOAT",
  /*  186 */ "OUTPUTTYPE",
  /*  187 */ "AGGREGATE",
  /*  188 */ "BUFSIZE",
  /*  189 */ "STREAM",
  /*  190 */ "INTO",
  /*  191 */ "TRIGGER",
  /*  192 */ "AT_ONCE",
  /*  193 */ "WINDOW_CLOSE",
  /*  194 */ "IGNORE",
  /*  195 */ "EXPIRED",
  /*  196 */ "FILL_HISTORY",
  /*  197 */ "SUBTABLE",
  /*  198 */ "KILL",
  /*  199 */ "CONNECTION",
  /*  200 */ "TRANSACTION",
  /*  201 */ "BALANCE",
  /*  202 */ "VGROUP",
  /*  203 */ "MERGE",
  /*  204 */ "REDISTRIBUTE",
  /*  205 */ "SPLIT",
  /*  206 */ "DELETE",
  /*  207 */ "INSERT",
  /*  208 */ "NULL",
  /*  209 */ "NK_QUESTION",
  /*  210 */ "NK_ARROW",
  /*  211 */ "ROWTS",
  /*  212 */ "QSTART",
  /*  213 */ "QEND",
  /*  214 */ "QDURATION",
  /*  215 */ "WSTART",
  /*  216 */ "WEND",
  /*  217 */ "WDURATION",
  /*  218 */ "IROWTS",
  /*  219 */ "ISFILLED",
  /*  220 */ "CAST",
  /*  221 */ "NOW",
  /*  222 */ "TODAY",
  /*  223 */ "TIMEZONE",
  /*  224 */ "CLIENT_VERSION",
  /*  225 */ "SERVER_VERSION",
  /*  226 */ "SERVER_STATUS",
  /*  227 */ "CURRENT_USER",
  /*  228 */ "CASE",
  /*  229 */ "END",
  /*  230 */ "WHEN",
  /*  231 */ "THEN",
  /*  232 */ "ELSE",
  /*  233 */ "BETWEEN",
  /*  234 */ "IS",
  /*  235 */ "NK_LT",
  /*  236 */ "NK_GT",
  /*  237 */ "NK_LE",
  /*  238 */ "NK_GE",
  /*  239 */ "NK_NE",
  /*  240 */ "MATCH",
  /*  241 */ "NMATCH",
  /*  242 */ "CONTAINS",
  /*  243 */ "IN",
  /*  244 */ "JOIN",
  /*  245 */ "INNER",
  /*  246 */ "SELECT",
  /*  247 */ "DISTINCT",
  /*  248 */ "WHERE",
  /*  249 */ "PARTITION",
  /*  250 */ "BY",
  /*  251 */ "SESSION",
  /*  252 */ "STATE_WINDOW",
  /*  253 */ "EVENT_WINDOW",
  /*  254 */ "START",
  /*  255 */ "SLIDING",
  /*  256 */ "FILL",
  /*  257 */ "VALUE",
  /*  258 */ "NONE",
  /*  259 */ "PREV",
  /*  260 */ "LINEAR",
  /*  261 */ "NEXT",
  /*  262 */ "HAVING",
  /*  263 */ "RANGE",
  /*  264 */ "EVERY",
  /*  265 */ "ORDER",
  /*  266 */ "SLIMIT",
  /*  267 */ "SOFFSET",
  /*  268 */ "LIMIT",
  /*  269 */ "OFFSET",
  /*  270 */ "ASC",
  /*  271 */ "NULLS",
  /*  272 */ "ABORT",
  /*  273 */ "AFTER",
  /*  274 */ "ATTACH",
  /*  275 */ "BEFORE",
  /*  276 */ "BEGIN",
  /*  277 */ "BITAND",
  /*  278 */ "BITNOT",
  /*  279 */ "BITOR",
  /*  280 */ "BLOCKS",
  /*  281 */ "CHANGE",
  /*  282 */ "COMMA",
  /*  283 */ "COMPACT",
  /*  284 */ "CONCAT",
  /*  285 */ "CONFLICT",
  /*  286 */ "COPY",
  /*  287 */ "DEFERRED",
  /*  288 */ "DELIMITERS",
  /*  289 */ "DETACH",
  /*  290 */ "DIVIDE",
  /*  291 */ "DOT",
  /*  292 */ "EACH",
  /*  293 */ "FAIL",
  /*  294 */ "FILE",
  /*  295 */ "FOR",
  /*  296 */ "GLOB",
  /*  297 */ "ID",
  /*  298 */ "IMMEDIATE",
  /*  299 */ "IMPORT",
  /*  300 */ "INITIALLY",
  /*  301 */ "INSTEAD",
  /*  302 */ "ISNULL",
  /*  303 */ "KEY",
  /*  304 */ "MODULES",
  /*  305 */ "NK_BITNOT",
  /*  306 */ "NK_SEMI",
  /*  307 */ "NOTNULL",
  /*  308 */ "OF",
  /*  309 */ "PLUS",
  /*  310 */ "PRIVILEGE",
  /*  311 */ "RAISE",
  /*  312 */ "REPLACE",
  /*  313 */ "RESTRICT",
  /*  314 */ "ROW",
  /*  315 */ "SEMI",
  /*  316 */ "STAR",
  /*  317 */ "STATEMENT",
  /*  318 */ "STRICT",
  /*  319 */ "STRING",
  /*  320 */ "TIMES",
  /*  321 */ "UPDATE",
  /*  322 */ "VALUES",
  /*  323 */ "VARIABLE",
  /*  324 */ "VIEW",
  /*  325 */ "WAL",
  /*  326 */ "cmd",
  /*  327 */ "account_options",
  /*  328 */ "alter_account_options",
  /*  329 */ "literal",
  /*  330 */ "alter_account_option",
  /*  331 */ "user_name",
  /*  332 */ "sysinfo_opt",
  /*  333 */ "privileges",
  /*  334 */ "priv_level",
  /*  335 */ "priv_type_list",
  /*  336 */ "priv_type",
  /*  337 */ "db_name",
  /*  338 */ "topic_name",
  /*  339 */ "dnode_endpoint",
  /*  340 */ "force_opt",
  /*  341 */ "not_exists_opt",
  /*  342 */ "db_options",
  /*  343 */ "exists_opt",
  /*  344 */ "alter_db_options",
  /*  345 */ "speed_opt",
  /*  346 */ "integer_list",
  /*  347 */ "variable_list",
  /*  348 */ "retention_list",
  /*  349 */ "alter_db_option",
  /*  350 */ "retention",
  /*  351 */ "full_table_name",
  /*  352 */ "column_def_list",
  /*  353 */ "tags_def_opt",
  /*  354 */ "table_options",
  /*  355 */ "multi_create_clause",
  /*  356 */ "tags_def",
  /*  357 */ "multi_drop_clause",
  /*  358 */ "alter_table_clause",
  /*  359 */ "alter_table_options",
  /*  360 */ "column_name",
  /*  361 */ "type_name",
  /*  362 */ "signed_literal",
  /*  363 */ "create_subtable_clause",
  /*  364 */ "specific_cols_opt",
  /*  365 */ "expression_list",
  /*  366 */ "drop_table_clause",
  /*  367 */ "col_name_list",
  /*  368 */ "table_name",
  /*  369 */ "column_def",
  /*  370 */ "duration_list",
  /*  371 */ "rollup_func_list",
  /*  372 */ "alter_table_option",
  /*  373 */ "duration_literal",
  /*  374 */ "rollup_func_name",
  /*  375 */ "function_name",
  /*  376 */ "col_name",
  /*  377 */ "db_name_cond_opt",
  /*  378 */ "like_pattern_opt",
  /*  379 */ "table_name_cond",
  /*  380 */ "from_db_opt",
  /*  381 */ "tag_list_opt",
  /*  382 */ "tag_item",
  /*  383 */ "column_alias",
  /*  384 */ "full_index_name",
  /*  385 */ "index_options",
  /*  386 */ "index_name",
  /*  387 */ "func_list",
  /*  388 */ "sliding_opt",
  /*  389 */ "sma_stream_opt",
  /*  390 */ "func",
  /*  391 */ "sma_func_name",
  /*  392 */ "query_or_subquery",
  /*  393 */ "cgroup_name",
  /*  394 */ "analyze_opt",
  /*  395 */ "explain_options",
  /*  396 */ "agg_func_opt",
  /*  397 */ "bufsize_opt",
  /*  398 */ "stream_name",
  /*  399 */ "stream_options",
  /*  400 */ "col_list_opt",
  /*  401 */ "tag_def_or_ref_opt",
  /*  402 */ "subtable_opt",
  /*  403 */ "expression",
  /*  404 */ "dnode_list",
  /*  405 */ "where_clause_opt",
  /*  406 */ "signed",
  /*  407 */ "literal_func",
  /*  408 */ "literal_list",
  /*  409 */ "table_alias",
  /*  410 */ "expr_or_subquery",
  /*  411 */ "pseudo_column",
  /*  412 */ "column_reference",
  /*  413 */ "function_expression",
  /*  414 */ "case_when_expression",
  /*  415 */ "star_func",
  /*  416 */ "star_func_para_list",
  /*  417 */ "noarg_func",
  /*  418 */ "other_para_list",
  /*  419 */ "star_func_para",
  /*  420 */ "when_then_list",
  /*  421 */ "case_when_else_opt",
  /*  422 */ "common_expression",
  /*  423 */ "when_then_expr",
  /*  424 */ "predicate",
  /*  425 */ "compare_op",
  /*  426 */ "in_op",
  /*  427 */ "in_predicate_value",
  /*  428 */ "boolean_value_expression",
  /*  429 */ "boolean_primary",
  /*  430 */ "from_clause_opt",
  /*  431 */ "table_reference_list",
  /*  432 */ "table_reference",
  /*  433 */ "table_primary",
  /*  434 */ "joined_table",
  /*  435 */ "alias_opt",
  /*  436 */ "subquery",
  /*  437 */ "parenthesized_joined_table",
  /*  438 */ "join_type",
  /*  439 */ "search_condition",
  /*  440 */ "query_specification",
  /*  441 */ "set_quantifier_opt",
  /*  442 */ "select_list",
  /*  443 */ "partition_by_clause_opt",
  /*  444 */ "range_opt",
  /*  445 */ "every_opt",
  /*  446 */ "fill_opt",
  /*  447 */ "twindow_clause_opt",
  /*  448 */ "group_by_clause_opt",
  /*  449 */ "having_clause_opt",
  /*  450 */ "select_item",
  /*  451 */ "partition_list",
  /*  452 */ "partition_item",
  /*  453 */ "fill_mode",
  /*  454 */ "group_by_list",
  /*  455 */ "query_expression",
  /*  456 */ "query_simple",
  /*  457 */ "order_by_clause_opt",
  /*  458 */ "slimit_clause_opt",
  /*  459 */ "limit_clause_opt",
  /*  460 */ "union_query_expression",
  /*  461 */ "query_simple_or_subquery",
  /*  462 */ "sort_specification_list",
  /*  463 */ "sort_specification",
  /*  464 */ "ordering_specification_opt",
  /*  465 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  73 */ "not_exists_opt ::=",
 /*  74 */ "exists_opt ::= IF EXISTS",
 /*  75 */ "exists_opt ::=",
 /*  76 */ "db_options ::=",
 /*  77 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  78 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  79 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  81 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  83 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  84 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options KEEP integer_list",
 /*  86 */ "db_options ::= db_options KEEP variable_list",
 /*  87 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  88 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  89 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  91 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  92 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  93 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  94 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  95 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 104 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 105 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 107 */ "alter_db_options ::= alter_db_option",
 /* 108 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 109 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 110 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 111 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 112 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 113 */ "alter_db_option ::= KEEP integer_list",
 /* 114 */ "alter_db_option ::= KEEP variable_list",
 /* 115 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 116 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 117 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 118 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 119 */ "integer_list ::= NK_INTEGER",
 /* 120 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 121 */ "variable_list ::= NK_VARIABLE",
 /* 122 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 123 */ "retention_list ::= retention",
 /* 124 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 125 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 126 */ "speed_opt ::=",
 /* 127 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 128 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 129 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 130 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 131 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 132 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 133 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 134 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 135 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 136 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 138 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 140 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 142 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 143 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 144 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 145 */ "multi_create_clause ::= create_subtable_clause",
 /* 146 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 147 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 148 */ "multi_drop_clause ::= drop_table_clause",
 /* 149 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 150 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 151 */ "specific_cols_opt ::=",
 /* 152 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 153 */ "full_table_name ::= table_name",
 /* 154 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 155 */ "column_def_list ::= column_def",
 /* 156 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 157 */ "column_def ::= column_name type_name",
 /* 158 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 159 */ "type_name ::= BOOL",
 /* 160 */ "type_name ::= TINYINT",
 /* 161 */ "type_name ::= SMALLINT",
 /* 162 */ "type_name ::= INT",
 /* 163 */ "type_name ::= INTEGER",
 /* 164 */ "type_name ::= BIGINT",
 /* 165 */ "type_name ::= FLOAT",
 /* 166 */ "type_name ::= DOUBLE",
 /* 167 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= TIMESTAMP",
 /* 169 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= TINYINT UNSIGNED",
 /* 171 */ "type_name ::= SMALLINT UNSIGNED",
 /* 172 */ "type_name ::= INT UNSIGNED",
 /* 173 */ "type_name ::= BIGINT UNSIGNED",
 /* 174 */ "type_name ::= JSON",
 /* 175 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 176 */ "type_name ::= MEDIUMBLOB",
 /* 177 */ "type_name ::= BLOB",
 /* 178 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= DECIMAL",
 /* 180 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 182 */ "tags_def_opt ::=",
 /* 183 */ "tags_def_opt ::= tags_def",
 /* 184 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 185 */ "table_options ::=",
 /* 186 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 187 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 188 */ "table_options ::= table_options WATERMARK duration_list",
 /* 189 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 190 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 191 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 192 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 193 */ "alter_table_options ::= alter_table_option",
 /* 194 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 195 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 196 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 197 */ "duration_list ::= duration_literal",
 /* 198 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 199 */ "rollup_func_list ::= rollup_func_name",
 /* 200 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 201 */ "rollup_func_name ::= function_name",
 /* 202 */ "rollup_func_name ::= FIRST",
 /* 203 */ "rollup_func_name ::= LAST",
 /* 204 */ "col_name_list ::= col_name",
 /* 205 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 206 */ "col_name ::= column_name",
 /* 207 */ "cmd ::= SHOW DNODES",
 /* 208 */ "cmd ::= SHOW USERS",
 /* 209 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 210 */ "cmd ::= SHOW DATABASES",
 /* 211 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 214 */ "cmd ::= SHOW MNODES",
 /* 215 */ "cmd ::= SHOW QNODES",
 /* 216 */ "cmd ::= SHOW FUNCTIONS",
 /* 217 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 218 */ "cmd ::= SHOW STREAMS",
 /* 219 */ "cmd ::= SHOW ACCOUNTS",
 /* 220 */ "cmd ::= SHOW APPS",
 /* 221 */ "cmd ::= SHOW CONNECTIONS",
 /* 222 */ "cmd ::= SHOW LICENCES",
 /* 223 */ "cmd ::= SHOW GRANTS",
 /* 224 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 225 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 226 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 227 */ "cmd ::= SHOW QUERIES",
 /* 228 */ "cmd ::= SHOW SCORES",
 /* 229 */ "cmd ::= SHOW TOPICS",
 /* 230 */ "cmd ::= SHOW VARIABLES",
 /* 231 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 232 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 233 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 234 */ "cmd ::= SHOW BNODES",
 /* 235 */ "cmd ::= SHOW SNODES",
 /* 236 */ "cmd ::= SHOW CLUSTER",
 /* 237 */ "cmd ::= SHOW TRANSACTIONS",
 /* 238 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 239 */ "cmd ::= SHOW CONSUMERS",
 /* 240 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 241 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 242 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 244 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 245 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 246 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 247 */ "db_name_cond_opt ::=",
 /* 248 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 249 */ "like_pattern_opt ::=",
 /* 250 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 251 */ "table_name_cond ::= table_name",
 /* 252 */ "from_db_opt ::=",
 /* 253 */ "from_db_opt ::= FROM db_name",
 /* 254 */ "tag_list_opt ::=",
 /* 255 */ "tag_list_opt ::= tag_item",
 /* 256 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 257 */ "tag_item ::= TBNAME",
 /* 258 */ "tag_item ::= QTAGS",
 /* 259 */ "tag_item ::= column_name",
 /* 260 */ "tag_item ::= column_name column_alias",
 /* 261 */ "tag_item ::= column_name AS column_alias",
 /* 262 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 263 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 264 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 265 */ "full_index_name ::= index_name",
 /* 266 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 267 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 268 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 269 */ "func_list ::= func",
 /* 270 */ "func_list ::= func_list NK_COMMA func",
 /* 271 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 272 */ "sma_func_name ::= function_name",
 /* 273 */ "sma_func_name ::= COUNT",
 /* 274 */ "sma_func_name ::= FIRST",
 /* 275 */ "sma_func_name ::= LAST",
 /* 276 */ "sma_func_name ::= LAST_ROW",
 /* 277 */ "sma_stream_opt ::=",
 /* 278 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 279 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 280 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 281 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 282 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 283 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 284 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 285 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 286 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 287 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 288 */ "cmd ::= DESC full_table_name",
 /* 289 */ "cmd ::= DESCRIBE full_table_name",
 /* 290 */ "cmd ::= RESET QUERY CACHE",
 /* 291 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 292 */ "analyze_opt ::=",
 /* 293 */ "analyze_opt ::= ANALYZE",
 /* 294 */ "explain_options ::=",
 /* 295 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 296 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 297 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 298 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 299 */ "agg_func_opt ::=",
 /* 300 */ "agg_func_opt ::= AGGREGATE",
 /* 301 */ "bufsize_opt ::=",
 /* 302 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 303 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 304 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 305 */ "col_list_opt ::=",
 /* 306 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 307 */ "tag_def_or_ref_opt ::=",
 /* 308 */ "tag_def_or_ref_opt ::= tags_def",
 /* 309 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 310 */ "stream_options ::=",
 /* 311 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 312 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 313 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 314 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 315 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 316 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 317 */ "subtable_opt ::=",
 /* 318 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 319 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 320 */ "cmd ::= KILL QUERY NK_STRING",
 /* 321 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 322 */ "cmd ::= BALANCE VGROUP",
 /* 323 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 324 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 325 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 326 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 327 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 328 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 329 */ "cmd ::= query_or_subquery",
 /* 330 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 331 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 332 */ "literal ::= NK_INTEGER",
 /* 333 */ "literal ::= NK_FLOAT",
 /* 334 */ "literal ::= NK_STRING",
 /* 335 */ "literal ::= NK_BOOL",
 /* 336 */ "literal ::= TIMESTAMP NK_STRING",
 /* 337 */ "literal ::= duration_literal",
 /* 338 */ "literal ::= NULL",
 /* 339 */ "literal ::= NK_QUESTION",
 /* 340 */ "duration_literal ::= NK_VARIABLE",
 /* 341 */ "signed ::= NK_INTEGER",
 /* 342 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 343 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 344 */ "signed ::= NK_FLOAT",
 /* 345 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 346 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 347 */ "signed_literal ::= signed",
 /* 348 */ "signed_literal ::= NK_STRING",
 /* 349 */ "signed_literal ::= NK_BOOL",
 /* 350 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 351 */ "signed_literal ::= duration_literal",
 /* 352 */ "signed_literal ::= NULL",
 /* 353 */ "signed_literal ::= literal_func",
 /* 354 */ "signed_literal ::= NK_QUESTION",
 /* 355 */ "literal_list ::= signed_literal",
 /* 356 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 357 */ "db_name ::= NK_ID",
 /* 358 */ "table_name ::= NK_ID",
 /* 359 */ "column_name ::= NK_ID",
 /* 360 */ "function_name ::= NK_ID",
 /* 361 */ "table_alias ::= NK_ID",
 /* 362 */ "column_alias ::= NK_ID",
 /* 363 */ "user_name ::= NK_ID",
 /* 364 */ "topic_name ::= NK_ID",
 /* 365 */ "stream_name ::= NK_ID",
 /* 366 */ "cgroup_name ::= NK_ID",
 /* 367 */ "index_name ::= NK_ID",
 /* 368 */ "expr_or_subquery ::= expression",
 /* 369 */ "expression ::= literal",
 /* 370 */ "expression ::= pseudo_column",
 /* 371 */ "expression ::= column_reference",
 /* 372 */ "expression ::= function_expression",
 /* 373 */ "expression ::= case_when_expression",
 /* 374 */ "expression ::= NK_LP expression NK_RP",
 /* 375 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 376 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 377 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 378 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 379 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 380 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 381 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 382 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 383 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 384 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 385 */ "expression_list ::= expr_or_subquery",
 /* 386 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 387 */ "column_reference ::= column_name",
 /* 388 */ "column_reference ::= table_name NK_DOT column_name",
 /* 389 */ "pseudo_column ::= ROWTS",
 /* 390 */ "pseudo_column ::= TBNAME",
 /* 391 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 392 */ "pseudo_column ::= QSTART",
 /* 393 */ "pseudo_column ::= QEND",
 /* 394 */ "pseudo_column ::= QDURATION",
 /* 395 */ "pseudo_column ::= WSTART",
 /* 396 */ "pseudo_column ::= WEND",
 /* 397 */ "pseudo_column ::= WDURATION",
 /* 398 */ "pseudo_column ::= IROWTS",
 /* 399 */ "pseudo_column ::= ISFILLED",
 /* 400 */ "pseudo_column ::= QTAGS",
 /* 401 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 402 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 403 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 404 */ "function_expression ::= literal_func",
 /* 405 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 406 */ "literal_func ::= NOW",
 /* 407 */ "noarg_func ::= NOW",
 /* 408 */ "noarg_func ::= TODAY",
 /* 409 */ "noarg_func ::= TIMEZONE",
 /* 410 */ "noarg_func ::= DATABASE",
 /* 411 */ "noarg_func ::= CLIENT_VERSION",
 /* 412 */ "noarg_func ::= SERVER_VERSION",
 /* 413 */ "noarg_func ::= SERVER_STATUS",
 /* 414 */ "noarg_func ::= CURRENT_USER",
 /* 415 */ "noarg_func ::= USER",
 /* 416 */ "star_func ::= COUNT",
 /* 417 */ "star_func ::= FIRST",
 /* 418 */ "star_func ::= LAST",
 /* 419 */ "star_func ::= LAST_ROW",
 /* 420 */ "star_func_para_list ::= NK_STAR",
 /* 421 */ "star_func_para_list ::= other_para_list",
 /* 422 */ "other_para_list ::= star_func_para",
 /* 423 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 424 */ "star_func_para ::= expr_or_subquery",
 /* 425 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 426 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 427 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 428 */ "when_then_list ::= when_then_expr",
 /* 429 */ "when_then_list ::= when_then_list when_then_expr",
 /* 430 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 431 */ "case_when_else_opt ::=",
 /* 432 */ "case_when_else_opt ::= ELSE common_expression",
 /* 433 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 434 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 435 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 436 */ "predicate ::= expr_or_subquery IS NULL",
 /* 437 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 438 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 439 */ "compare_op ::= NK_LT",
 /* 440 */ "compare_op ::= NK_GT",
 /* 441 */ "compare_op ::= NK_LE",
 /* 442 */ "compare_op ::= NK_GE",
 /* 443 */ "compare_op ::= NK_NE",
 /* 444 */ "compare_op ::= NK_EQ",
 /* 445 */ "compare_op ::= LIKE",
 /* 446 */ "compare_op ::= NOT LIKE",
 /* 447 */ "compare_op ::= MATCH",
 /* 448 */ "compare_op ::= NMATCH",
 /* 449 */ "compare_op ::= CONTAINS",
 /* 450 */ "in_op ::= IN",
 /* 451 */ "in_op ::= NOT IN",
 /* 452 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 453 */ "boolean_value_expression ::= boolean_primary",
 /* 454 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 455 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 456 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 457 */ "boolean_primary ::= predicate",
 /* 458 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 459 */ "common_expression ::= expr_or_subquery",
 /* 460 */ "common_expression ::= boolean_value_expression",
 /* 461 */ "from_clause_opt ::=",
 /* 462 */ "from_clause_opt ::= FROM table_reference_list",
 /* 463 */ "table_reference_list ::= table_reference",
 /* 464 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 465 */ "table_reference ::= table_primary",
 /* 466 */ "table_reference ::= joined_table",
 /* 467 */ "table_primary ::= table_name alias_opt",
 /* 468 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 469 */ "table_primary ::= subquery alias_opt",
 /* 470 */ "table_primary ::= parenthesized_joined_table",
 /* 471 */ "alias_opt ::=",
 /* 472 */ "alias_opt ::= table_alias",
 /* 473 */ "alias_opt ::= AS table_alias",
 /* 474 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 475 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 476 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 477 */ "join_type ::=",
 /* 478 */ "join_type ::= INNER",
 /* 479 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 480 */ "set_quantifier_opt ::=",
 /* 481 */ "set_quantifier_opt ::= DISTINCT",
 /* 482 */ "set_quantifier_opt ::= ALL",
 /* 483 */ "select_list ::= select_item",
 /* 484 */ "select_list ::= select_list NK_COMMA select_item",
 /* 485 */ "select_item ::= NK_STAR",
 /* 486 */ "select_item ::= common_expression",
 /* 487 */ "select_item ::= common_expression column_alias",
 /* 488 */ "select_item ::= common_expression AS column_alias",
 /* 489 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 490 */ "where_clause_opt ::=",
 /* 491 */ "where_clause_opt ::= WHERE search_condition",
 /* 492 */ "partition_by_clause_opt ::=",
 /* 493 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 494 */ "partition_list ::= partition_item",
 /* 495 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 496 */ "partition_item ::= expr_or_subquery",
 /* 497 */ "partition_item ::= expr_or_subquery column_alias",
 /* 498 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 499 */ "twindow_clause_opt ::=",
 /* 500 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 501 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 502 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 503 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 504 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 505 */ "sliding_opt ::=",
 /* 506 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 507 */ "fill_opt ::=",
 /* 508 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 509 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 510 */ "fill_mode ::= NONE",
 /* 511 */ "fill_mode ::= PREV",
 /* 512 */ "fill_mode ::= NULL",
 /* 513 */ "fill_mode ::= LINEAR",
 /* 514 */ "fill_mode ::= NEXT",
 /* 515 */ "group_by_clause_opt ::=",
 /* 516 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 517 */ "group_by_list ::= expr_or_subquery",
 /* 518 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 519 */ "having_clause_opt ::=",
 /* 520 */ "having_clause_opt ::= HAVING search_condition",
 /* 521 */ "range_opt ::=",
 /* 522 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 523 */ "every_opt ::=",
 /* 524 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 525 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 526 */ "query_simple ::= query_specification",
 /* 527 */ "query_simple ::= union_query_expression",
 /* 528 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 529 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 530 */ "query_simple_or_subquery ::= query_simple",
 /* 531 */ "query_simple_or_subquery ::= subquery",
 /* 532 */ "query_or_subquery ::= query_expression",
 /* 533 */ "query_or_subquery ::= subquery",
 /* 534 */ "order_by_clause_opt ::=",
 /* 535 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 536 */ "slimit_clause_opt ::=",
 /* 537 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 538 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 539 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 540 */ "limit_clause_opt ::=",
 /* 541 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 542 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 543 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 544 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 545 */ "subquery ::= NK_LP subquery NK_RP",
 /* 546 */ "search_condition ::= common_expression",
 /* 547 */ "sort_specification_list ::= sort_specification",
 /* 548 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 549 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 550 */ "ordering_specification_opt ::=",
 /* 551 */ "ordering_specification_opt ::= ASC",
 /* 552 */ "ordering_specification_opt ::= DESC",
 /* 553 */ "null_ordering_opt ::=",
 /* 554 */ "null_ordering_opt ::= NULLS FIRST",
 /* 555 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 326: /* cmd */
    case 329: /* literal */
    case 342: /* db_options */
    case 344: /* alter_db_options */
    case 350: /* retention */
    case 351: /* full_table_name */
    case 354: /* table_options */
    case 358: /* alter_table_clause */
    case 359: /* alter_table_options */
    case 362: /* signed_literal */
    case 363: /* create_subtable_clause */
    case 366: /* drop_table_clause */
    case 369: /* column_def */
    case 373: /* duration_literal */
    case 374: /* rollup_func_name */
    case 376: /* col_name */
    case 377: /* db_name_cond_opt */
    case 378: /* like_pattern_opt */
    case 379: /* table_name_cond */
    case 380: /* from_db_opt */
    case 382: /* tag_item */
    case 384: /* full_index_name */
    case 385: /* index_options */
    case 388: /* sliding_opt */
    case 389: /* sma_stream_opt */
    case 390: /* func */
    case 392: /* query_or_subquery */
    case 395: /* explain_options */
    case 399: /* stream_options */
    case 402: /* subtable_opt */
    case 403: /* expression */
    case 405: /* where_clause_opt */
    case 406: /* signed */
    case 407: /* literal_func */
    case 410: /* expr_or_subquery */
    case 411: /* pseudo_column */
    case 412: /* column_reference */
    case 413: /* function_expression */
    case 414: /* case_when_expression */
    case 419: /* star_func_para */
    case 421: /* case_when_else_opt */
    case 422: /* common_expression */
    case 423: /* when_then_expr */
    case 424: /* predicate */
    case 427: /* in_predicate_value */
    case 428: /* boolean_value_expression */
    case 429: /* boolean_primary */
    case 430: /* from_clause_opt */
    case 431: /* table_reference_list */
    case 432: /* table_reference */
    case 433: /* table_primary */
    case 434: /* joined_table */
    case 436: /* subquery */
    case 437: /* parenthesized_joined_table */
    case 439: /* search_condition */
    case 440: /* query_specification */
    case 444: /* range_opt */
    case 445: /* every_opt */
    case 446: /* fill_opt */
    case 447: /* twindow_clause_opt */
    case 449: /* having_clause_opt */
    case 450: /* select_item */
    case 452: /* partition_item */
    case 455: /* query_expression */
    case 456: /* query_simple */
    case 458: /* slimit_clause_opt */
    case 459: /* limit_clause_opt */
    case 460: /* union_query_expression */
    case 461: /* query_simple_or_subquery */
    case 463: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy924)); 
}
      break;
    case 327: /* account_options */
    case 328: /* alter_account_options */
    case 330: /* alter_account_option */
    case 345: /* speed_opt */
    case 397: /* bufsize_opt */
{
 
}
      break;
    case 331: /* user_name */
    case 334: /* priv_level */
    case 337: /* db_name */
    case 338: /* topic_name */
    case 339: /* dnode_endpoint */
    case 360: /* column_name */
    case 368: /* table_name */
    case 375: /* function_name */
    case 383: /* column_alias */
    case 386: /* index_name */
    case 391: /* sma_func_name */
    case 393: /* cgroup_name */
    case 398: /* stream_name */
    case 409: /* table_alias */
    case 415: /* star_func */
    case 417: /* noarg_func */
    case 435: /* alias_opt */
{
 
}
      break;
    case 332: /* sysinfo_opt */
{
 
}
      break;
    case 333: /* privileges */
    case 335: /* priv_type_list */
    case 336: /* priv_type */
{
 
}
      break;
    case 340: /* force_opt */
    case 341: /* not_exists_opt */
    case 343: /* exists_opt */
    case 394: /* analyze_opt */
    case 396: /* agg_func_opt */
    case 441: /* set_quantifier_opt */
{
 
}
      break;
    case 346: /* integer_list */
    case 347: /* variable_list */
    case 348: /* retention_list */
    case 352: /* column_def_list */
    case 353: /* tags_def_opt */
    case 355: /* multi_create_clause */
    case 356: /* tags_def */
    case 357: /* multi_drop_clause */
    case 364: /* specific_cols_opt */
    case 365: /* expression_list */
    case 367: /* col_name_list */
    case 370: /* duration_list */
    case 371: /* rollup_func_list */
    case 381: /* tag_list_opt */
    case 387: /* func_list */
    case 400: /* col_list_opt */
    case 401: /* tag_def_or_ref_opt */
    case 404: /* dnode_list */
    case 408: /* literal_list */
    case 416: /* star_func_para_list */
    case 418: /* other_para_list */
    case 420: /* when_then_list */
    case 442: /* select_list */
    case 443: /* partition_by_clause_opt */
    case 448: /* group_by_clause_opt */
    case 451: /* partition_list */
    case 454: /* group_by_list */
    case 457: /* order_by_clause_opt */
    case 462: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy776)); 
}
      break;
    case 349: /* alter_db_option */
    case 372: /* alter_table_option */
{
 
}
      break;
    case 361: /* type_name */
{
 
}
      break;
    case 425: /* compare_op */
    case 426: /* in_op */
{
 
}
      break;
    case 438: /* join_type */
{
 
}
      break;
    case 453: /* fill_mode */
{
 
}
      break;
    case 464: /* ordering_specification_opt */
{
 
}
      break;
    case 465: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  326,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  326,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  327,    0 }, /* (2) account_options ::= */
  {  327,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  327,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  327,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  327,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  327,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  327,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  327,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  327,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  327,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  328,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  328,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  330,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  330,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  330,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  330,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  330,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  330,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  330,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  330,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  330,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  330,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  326,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  326,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  326,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  326,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  326,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  332,    0 }, /* (29) sysinfo_opt ::= */
  {  332,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  326,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  326,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  333,   -1 }, /* (33) privileges ::= ALL */
  {  333,   -1 }, /* (34) privileges ::= priv_type_list */
  {  333,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  335,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  335,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  336,   -1 }, /* (38) priv_type ::= READ */
  {  336,   -1 }, /* (39) priv_type ::= WRITE */
  {  334,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  334,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  334,   -1 }, /* (42) priv_level ::= topic_name */
  {  326,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  326,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  326,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  326,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  326,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  326,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  326,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  326,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  339,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  339,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  339,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  340,    0 }, /* (54) force_opt ::= */
  {  340,   -1 }, /* (55) force_opt ::= FORCE */
  {  326,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  326,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  326,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  326,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  326,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  326,   -2 }, /* (68) cmd ::= USE db_name */
  {  326,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  326,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  326,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  341,   -3 }, /* (72) not_exists_opt ::= IF NOT EXISTS */
  {  341,    0 }, /* (73) not_exists_opt ::= */
  {  343,   -2 }, /* (74) exists_opt ::= IF EXISTS */
  {  343,    0 }, /* (75) exists_opt ::= */
  {  342,    0 }, /* (76) db_options ::= */
  {  342,   -3 }, /* (77) db_options ::= db_options BUFFER NK_INTEGER */
  {  342,   -3 }, /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
  {  342,   -3 }, /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  342,   -3 }, /* (80) db_options ::= db_options COMP NK_INTEGER */
  {  342,   -3 }, /* (81) db_options ::= db_options DURATION NK_INTEGER */
  {  342,   -3 }, /* (82) db_options ::= db_options DURATION NK_VARIABLE */
  {  342,   -3 }, /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
  {  342,   -3 }, /* (84) db_options ::= db_options MINROWS NK_INTEGER */
  {  342,   -3 }, /* (85) db_options ::= db_options KEEP integer_list */
  {  342,   -3 }, /* (86) db_options ::= db_options KEEP variable_list */
  {  342,   -3 }, /* (87) db_options ::= db_options PAGES NK_INTEGER */
  {  342,   -3 }, /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  342,   -3 }, /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  342,   -3 }, /* (90) db_options ::= db_options PRECISION NK_STRING */
  {  342,   -3 }, /* (91) db_options ::= db_options REPLICA NK_INTEGER */
  {  342,   -3 }, /* (92) db_options ::= db_options VGROUPS NK_INTEGER */
  {  342,   -3 }, /* (93) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  342,   -3 }, /* (94) db_options ::= db_options RETENTIONS retention_list */
  {  342,   -3 }, /* (95) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  342,   -3 }, /* (96) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  342,   -3 }, /* (97) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  342,   -3 }, /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  342,   -4 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  342,   -3 }, /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  342,   -4 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  342,   -3 }, /* (102) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  342,   -3 }, /* (103) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  342,   -3 }, /* (104) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  342,   -3 }, /* (105) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  342,   -3 }, /* (106) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  344,   -1 }, /* (107) alter_db_options ::= alter_db_option */
  {  344,   -2 }, /* (108) alter_db_options ::= alter_db_options alter_db_option */
  {  349,   -2 }, /* (109) alter_db_option ::= BUFFER NK_INTEGER */
  {  349,   -2 }, /* (110) alter_db_option ::= CACHEMODEL NK_STRING */
  {  349,   -2 }, /* (111) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  349,   -2 }, /* (112) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  349,   -2 }, /* (113) alter_db_option ::= KEEP integer_list */
  {  349,   -2 }, /* (114) alter_db_option ::= KEEP variable_list */
  {  349,   -2 }, /* (115) alter_db_option ::= PAGES NK_INTEGER */
  {  349,   -2 }, /* (116) alter_db_option ::= REPLICA NK_INTEGER */
  {  349,   -2 }, /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  349,   -2 }, /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  346,   -1 }, /* (119) integer_list ::= NK_INTEGER */
  {  346,   -3 }, /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  347,   -1 }, /* (121) variable_list ::= NK_VARIABLE */
  {  347,   -3 }, /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  348,   -1 }, /* (123) retention_list ::= retention */
  {  348,   -3 }, /* (124) retention_list ::= retention_list NK_COMMA retention */
  {  350,   -3 }, /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  345,    0 }, /* (126) speed_opt ::= */
  {  345,   -2 }, /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  326,   -9 }, /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  326,   -3 }, /* (129) cmd ::= CREATE TABLE multi_create_clause */
  {  326,   -9 }, /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  326,   -3 }, /* (131) cmd ::= DROP TABLE multi_drop_clause */
  {  326,   -4 }, /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
  {  326,   -3 }, /* (133) cmd ::= ALTER TABLE alter_table_clause */
  {  326,   -3 }, /* (134) cmd ::= ALTER STABLE alter_table_clause */
  {  358,   -2 }, /* (135) alter_table_clause ::= full_table_name alter_table_options */
  {  358,   -5 }, /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  358,   -4 }, /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  358,   -5 }, /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  358,   -5 }, /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  358,   -5 }, /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  358,   -4 }, /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  358,   -5 }, /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  358,   -5 }, /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  358,   -6 }, /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  355,   -1 }, /* (145) multi_create_clause ::= create_subtable_clause */
  {  355,   -2 }, /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  363,  -10 }, /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  357,   -1 }, /* (148) multi_drop_clause ::= drop_table_clause */
  {  357,   -2 }, /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  366,   -2 }, /* (150) drop_table_clause ::= exists_opt full_table_name */
  {  364,    0 }, /* (151) specific_cols_opt ::= */
  {  364,   -3 }, /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  351,   -1 }, /* (153) full_table_name ::= table_name */
  {  351,   -3 }, /* (154) full_table_name ::= db_name NK_DOT table_name */
  {  352,   -1 }, /* (155) column_def_list ::= column_def */
  {  352,   -3 }, /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
  {  369,   -2 }, /* (157) column_def ::= column_name type_name */
  {  369,   -4 }, /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
  {  361,   -1 }, /* (159) type_name ::= BOOL */
  {  361,   -1 }, /* (160) type_name ::= TINYINT */
  {  361,   -1 }, /* (161) type_name ::= SMALLINT */
  {  361,   -1 }, /* (162) type_name ::= INT */
  {  361,   -1 }, /* (163) type_name ::= INTEGER */
  {  361,   -1 }, /* (164) type_name ::= BIGINT */
  {  361,   -1 }, /* (165) type_name ::= FLOAT */
  {  361,   -1 }, /* (166) type_name ::= DOUBLE */
  {  361,   -4 }, /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  361,   -1 }, /* (168) type_name ::= TIMESTAMP */
  {  361,   -4 }, /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  361,   -2 }, /* (170) type_name ::= TINYINT UNSIGNED */
  {  361,   -2 }, /* (171) type_name ::= SMALLINT UNSIGNED */
  {  361,   -2 }, /* (172) type_name ::= INT UNSIGNED */
  {  361,   -2 }, /* (173) type_name ::= BIGINT UNSIGNED */
  {  361,   -1 }, /* (174) type_name ::= JSON */
  {  361,   -4 }, /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  361,   -1 }, /* (176) type_name ::= MEDIUMBLOB */
  {  361,   -1 }, /* (177) type_name ::= BLOB */
  {  361,   -4 }, /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  361,   -1 }, /* (179) type_name ::= DECIMAL */
  {  361,   -4 }, /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  361,   -6 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  353,    0 }, /* (182) tags_def_opt ::= */
  {  353,   -1 }, /* (183) tags_def_opt ::= tags_def */
  {  356,   -4 }, /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  354,    0 }, /* (185) table_options ::= */
  {  354,   -3 }, /* (186) table_options ::= table_options COMMENT NK_STRING */
  {  354,   -3 }, /* (187) table_options ::= table_options MAX_DELAY duration_list */
  {  354,   -3 }, /* (188) table_options ::= table_options WATERMARK duration_list */
  {  354,   -5 }, /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  354,   -3 }, /* (190) table_options ::= table_options TTL NK_INTEGER */
  {  354,   -5 }, /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  354,   -3 }, /* (192) table_options ::= table_options DELETE_MARK duration_list */
  {  359,   -1 }, /* (193) alter_table_options ::= alter_table_option */
  {  359,   -2 }, /* (194) alter_table_options ::= alter_table_options alter_table_option */
  {  372,   -2 }, /* (195) alter_table_option ::= COMMENT NK_STRING */
  {  372,   -2 }, /* (196) alter_table_option ::= TTL NK_INTEGER */
  {  370,   -1 }, /* (197) duration_list ::= duration_literal */
  {  370,   -3 }, /* (198) duration_list ::= duration_list NK_COMMA duration_literal */
  {  371,   -1 }, /* (199) rollup_func_list ::= rollup_func_name */
  {  371,   -3 }, /* (200) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  374,   -1 }, /* (201) rollup_func_name ::= function_name */
  {  374,   -1 }, /* (202) rollup_func_name ::= FIRST */
  {  374,   -1 }, /* (203) rollup_func_name ::= LAST */
  {  367,   -1 }, /* (204) col_name_list ::= col_name */
  {  367,   -3 }, /* (205) col_name_list ::= col_name_list NK_COMMA col_name */
  {  376,   -1 }, /* (206) col_name ::= column_name */
  {  326,   -2 }, /* (207) cmd ::= SHOW DNODES */
  {  326,   -2 }, /* (208) cmd ::= SHOW USERS */
  {  326,   -3 }, /* (209) cmd ::= SHOW USER PRIVILEGES */
  {  326,   -2 }, /* (210) cmd ::= SHOW DATABASES */
  {  326,   -4 }, /* (211) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  326,   -4 }, /* (212) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  326,   -3 }, /* (213) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  326,   -2 }, /* (214) cmd ::= SHOW MNODES */
  {  326,   -2 }, /* (215) cmd ::= SHOW QNODES */
  {  326,   -2 }, /* (216) cmd ::= SHOW FUNCTIONS */
  {  326,   -5 }, /* (217) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  326,   -2 }, /* (218) cmd ::= SHOW STREAMS */
  {  326,   -2 }, /* (219) cmd ::= SHOW ACCOUNTS */
  {  326,   -2 }, /* (220) cmd ::= SHOW APPS */
  {  326,   -2 }, /* (221) cmd ::= SHOW CONNECTIONS */
  {  326,   -2 }, /* (222) cmd ::= SHOW LICENCES */
  {  326,   -2 }, /* (223) cmd ::= SHOW GRANTS */
  {  326,   -4 }, /* (224) cmd ::= SHOW CREATE DATABASE db_name */
  {  326,   -4 }, /* (225) cmd ::= SHOW CREATE TABLE full_table_name */
  {  326,   -4 }, /* (226) cmd ::= SHOW CREATE STABLE full_table_name */
  {  326,   -2 }, /* (227) cmd ::= SHOW QUERIES */
  {  326,   -2 }, /* (228) cmd ::= SHOW SCORES */
  {  326,   -2 }, /* (229) cmd ::= SHOW TOPICS */
  {  326,   -2 }, /* (230) cmd ::= SHOW VARIABLES */
  {  326,   -3 }, /* (231) cmd ::= SHOW CLUSTER VARIABLES */
  {  326,   -3 }, /* (232) cmd ::= SHOW LOCAL VARIABLES */
  {  326,   -5 }, /* (233) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  326,   -2 }, /* (234) cmd ::= SHOW BNODES */
  {  326,   -2 }, /* (235) cmd ::= SHOW SNODES */
  {  326,   -2 }, /* (236) cmd ::= SHOW CLUSTER */
  {  326,   -2 }, /* (237) cmd ::= SHOW TRANSACTIONS */
  {  326,   -4 }, /* (238) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  326,   -2 }, /* (239) cmd ::= SHOW CONSUMERS */
  {  326,   -2 }, /* (240) cmd ::= SHOW SUBSCRIPTIONS */
  {  326,   -5 }, /* (241) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  326,   -7 }, /* (242) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  326,   -3 }, /* (243) cmd ::= SHOW VNODES NK_INTEGER */
  {  326,   -3 }, /* (244) cmd ::= SHOW VNODES NK_STRING */
  {  326,   -3 }, /* (245) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  326,   -3 }, /* (246) cmd ::= SHOW CLUSTER ALIVE */
  {  377,    0 }, /* (247) db_name_cond_opt ::= */
  {  377,   -2 }, /* (248) db_name_cond_opt ::= db_name NK_DOT */
  {  378,    0 }, /* (249) like_pattern_opt ::= */
  {  378,   -2 }, /* (250) like_pattern_opt ::= LIKE NK_STRING */
  {  379,   -1 }, /* (251) table_name_cond ::= table_name */
  {  380,    0 }, /* (252) from_db_opt ::= */
  {  380,   -2 }, /* (253) from_db_opt ::= FROM db_name */
  {  381,    0 }, /* (254) tag_list_opt ::= */
  {  381,   -1 }, /* (255) tag_list_opt ::= tag_item */
  {  381,   -3 }, /* (256) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  382,   -1 }, /* (257) tag_item ::= TBNAME */
  {  382,   -1 }, /* (258) tag_item ::= QTAGS */
  {  382,   -1 }, /* (259) tag_item ::= column_name */
  {  382,   -2 }, /* (260) tag_item ::= column_name column_alias */
  {  382,   -3 }, /* (261) tag_item ::= column_name AS column_alias */
  {  326,   -8 }, /* (262) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  326,   -9 }, /* (263) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  326,   -4 }, /* (264) cmd ::= DROP INDEX exists_opt full_index_name */
  {  384,   -1 }, /* (265) full_index_name ::= index_name */
  {  384,   -3 }, /* (266) full_index_name ::= db_name NK_DOT index_name */
  {  385,  -10 }, /* (267) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  385,  -12 }, /* (268) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  387,   -1 }, /* (269) func_list ::= func */
  {  387,   -3 }, /* (270) func_list ::= func_list NK_COMMA func */
  {  390,   -4 }, /* (271) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  391,   -1 }, /* (272) sma_func_name ::= function_name */
  {  391,   -1 }, /* (273) sma_func_name ::= COUNT */
  {  391,   -1 }, /* (274) sma_func_name ::= FIRST */
  {  391,   -1 }, /* (275) sma_func_name ::= LAST */
  {  391,   -1 }, /* (276) sma_func_name ::= LAST_ROW */
  {  389,    0 }, /* (277) sma_stream_opt ::= */
  {  389,   -3 }, /* (278) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  389,   -3 }, /* (279) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  389,   -3 }, /* (280) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  326,   -6 }, /* (281) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  326,   -7 }, /* (282) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  326,   -9 }, /* (283) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  326,   -7 }, /* (284) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  326,   -9 }, /* (285) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  326,   -4 }, /* (286) cmd ::= DROP TOPIC exists_opt topic_name */
  {  326,   -7 }, /* (287) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  326,   -2 }, /* (288) cmd ::= DESC full_table_name */
  {  326,   -2 }, /* (289) cmd ::= DESCRIBE full_table_name */
  {  326,   -3 }, /* (290) cmd ::= RESET QUERY CACHE */
  {  326,   -4 }, /* (291) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  394,    0 }, /* (292) analyze_opt ::= */
  {  394,   -1 }, /* (293) analyze_opt ::= ANALYZE */
  {  395,    0 }, /* (294) explain_options ::= */
  {  395,   -3 }, /* (295) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  395,   -3 }, /* (296) explain_options ::= explain_options RATIO NK_FLOAT */
  {  326,  -10 }, /* (297) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  326,   -4 }, /* (298) cmd ::= DROP FUNCTION exists_opt function_name */
  {  396,    0 }, /* (299) agg_func_opt ::= */
  {  396,   -1 }, /* (300) agg_func_opt ::= AGGREGATE */
  {  397,    0 }, /* (301) bufsize_opt ::= */
  {  397,   -2 }, /* (302) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  326,  -12 }, /* (303) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
  {  326,   -4 }, /* (304) cmd ::= DROP STREAM exists_opt stream_name */
  {  400,    0 }, /* (305) col_list_opt ::= */
  {  400,   -3 }, /* (306) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  401,    0 }, /* (307) tag_def_or_ref_opt ::= */
  {  401,   -1 }, /* (308) tag_def_or_ref_opt ::= tags_def */
  {  401,   -4 }, /* (309) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
  {  399,    0 }, /* (310) stream_options ::= */
  {  399,   -3 }, /* (311) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  399,   -3 }, /* (312) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  399,   -4 }, /* (313) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  399,   -3 }, /* (314) stream_options ::= stream_options WATERMARK duration_literal */
  {  399,   -4 }, /* (315) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  399,   -3 }, /* (316) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  402,    0 }, /* (317) subtable_opt ::= */
  {  402,   -4 }, /* (318) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  326,   -3 }, /* (319) cmd ::= KILL CONNECTION NK_INTEGER */
  {  326,   -3 }, /* (320) cmd ::= KILL QUERY NK_STRING */
  {  326,   -3 }, /* (321) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  326,   -2 }, /* (322) cmd ::= BALANCE VGROUP */
  {  326,   -4 }, /* (323) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  326,   -4 }, /* (324) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  326,   -3 }, /* (325) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  404,   -2 }, /* (326) dnode_list ::= DNODE NK_INTEGER */
  {  404,   -3 }, /* (327) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  326,   -4 }, /* (328) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  326,   -1 }, /* (329) cmd ::= query_or_subquery */
  {  326,   -7 }, /* (330) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  326,   -4 }, /* (331) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  329,   -1 }, /* (332) literal ::= NK_INTEGER */
  {  329,   -1 }, /* (333) literal ::= NK_FLOAT */
  {  329,   -1 }, /* (334) literal ::= NK_STRING */
  {  329,   -1 }, /* (335) literal ::= NK_BOOL */
  {  329,   -2 }, /* (336) literal ::= TIMESTAMP NK_STRING */
  {  329,   -1 }, /* (337) literal ::= duration_literal */
  {  329,   -1 }, /* (338) literal ::= NULL */
  {  329,   -1 }, /* (339) literal ::= NK_QUESTION */
  {  373,   -1 }, /* (340) duration_literal ::= NK_VARIABLE */
  {  406,   -1 }, /* (341) signed ::= NK_INTEGER */
  {  406,   -2 }, /* (342) signed ::= NK_PLUS NK_INTEGER */
  {  406,   -2 }, /* (343) signed ::= NK_MINUS NK_INTEGER */
  {  406,   -1 }, /* (344) signed ::= NK_FLOAT */
  {  406,   -2 }, /* (345) signed ::= NK_PLUS NK_FLOAT */
  {  406,   -2 }, /* (346) signed ::= NK_MINUS NK_FLOAT */
  {  362,   -1 }, /* (347) signed_literal ::= signed */
  {  362,   -1 }, /* (348) signed_literal ::= NK_STRING */
  {  362,   -1 }, /* (349) signed_literal ::= NK_BOOL */
  {  362,   -2 }, /* (350) signed_literal ::= TIMESTAMP NK_STRING */
  {  362,   -1 }, /* (351) signed_literal ::= duration_literal */
  {  362,   -1 }, /* (352) signed_literal ::= NULL */
  {  362,   -1 }, /* (353) signed_literal ::= literal_func */
  {  362,   -1 }, /* (354) signed_literal ::= NK_QUESTION */
  {  408,   -1 }, /* (355) literal_list ::= signed_literal */
  {  408,   -3 }, /* (356) literal_list ::= literal_list NK_COMMA signed_literal */
  {  337,   -1 }, /* (357) db_name ::= NK_ID */
  {  368,   -1 }, /* (358) table_name ::= NK_ID */
  {  360,   -1 }, /* (359) column_name ::= NK_ID */
  {  375,   -1 }, /* (360) function_name ::= NK_ID */
  {  409,   -1 }, /* (361) table_alias ::= NK_ID */
  {  383,   -1 }, /* (362) column_alias ::= NK_ID */
  {  331,   -1 }, /* (363) user_name ::= NK_ID */
  {  338,   -1 }, /* (364) topic_name ::= NK_ID */
  {  398,   -1 }, /* (365) stream_name ::= NK_ID */
  {  393,   -1 }, /* (366) cgroup_name ::= NK_ID */
  {  386,   -1 }, /* (367) index_name ::= NK_ID */
  {  410,   -1 }, /* (368) expr_or_subquery ::= expression */
  {  403,   -1 }, /* (369) expression ::= literal */
  {  403,   -1 }, /* (370) expression ::= pseudo_column */
  {  403,   -1 }, /* (371) expression ::= column_reference */
  {  403,   -1 }, /* (372) expression ::= function_expression */
  {  403,   -1 }, /* (373) expression ::= case_when_expression */
  {  403,   -3 }, /* (374) expression ::= NK_LP expression NK_RP */
  {  403,   -2 }, /* (375) expression ::= NK_PLUS expr_or_subquery */
  {  403,   -2 }, /* (376) expression ::= NK_MINUS expr_or_subquery */
  {  403,   -3 }, /* (377) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  403,   -3 }, /* (378) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  403,   -3 }, /* (379) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  403,   -3 }, /* (380) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  403,   -3 }, /* (381) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  403,   -3 }, /* (382) expression ::= column_reference NK_ARROW NK_STRING */
  {  403,   -3 }, /* (383) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  403,   -3 }, /* (384) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  365,   -1 }, /* (385) expression_list ::= expr_or_subquery */
  {  365,   -3 }, /* (386) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  412,   -1 }, /* (387) column_reference ::= column_name */
  {  412,   -3 }, /* (388) column_reference ::= table_name NK_DOT column_name */
  {  411,   -1 }, /* (389) pseudo_column ::= ROWTS */
  {  411,   -1 }, /* (390) pseudo_column ::= TBNAME */
  {  411,   -3 }, /* (391) pseudo_column ::= table_name NK_DOT TBNAME */
  {  411,   -1 }, /* (392) pseudo_column ::= QSTART */
  {  411,   -1 }, /* (393) pseudo_column ::= QEND */
  {  411,   -1 }, /* (394) pseudo_column ::= QDURATION */
  {  411,   -1 }, /* (395) pseudo_column ::= WSTART */
  {  411,   -1 }, /* (396) pseudo_column ::= WEND */
  {  411,   -1 }, /* (397) pseudo_column ::= WDURATION */
  {  411,   -1 }, /* (398) pseudo_column ::= IROWTS */
  {  411,   -1 }, /* (399) pseudo_column ::= ISFILLED */
  {  411,   -1 }, /* (400) pseudo_column ::= QTAGS */
  {  413,   -4 }, /* (401) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  413,   -4 }, /* (402) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  413,   -6 }, /* (403) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  413,   -1 }, /* (404) function_expression ::= literal_func */
  {  407,   -3 }, /* (405) literal_func ::= noarg_func NK_LP NK_RP */
  {  407,   -1 }, /* (406) literal_func ::= NOW */
  {  417,   -1 }, /* (407) noarg_func ::= NOW */
  {  417,   -1 }, /* (408) noarg_func ::= TODAY */
  {  417,   -1 }, /* (409) noarg_func ::= TIMEZONE */
  {  417,   -1 }, /* (410) noarg_func ::= DATABASE */
  {  417,   -1 }, /* (411) noarg_func ::= CLIENT_VERSION */
  {  417,   -1 }, /* (412) noarg_func ::= SERVER_VERSION */
  {  417,   -1 }, /* (413) noarg_func ::= SERVER_STATUS */
  {  417,   -1 }, /* (414) noarg_func ::= CURRENT_USER */
  {  417,   -1 }, /* (415) noarg_func ::= USER */
  {  415,   -1 }, /* (416) star_func ::= COUNT */
  {  415,   -1 }, /* (417) star_func ::= FIRST */
  {  415,   -1 }, /* (418) star_func ::= LAST */
  {  415,   -1 }, /* (419) star_func ::= LAST_ROW */
  {  416,   -1 }, /* (420) star_func_para_list ::= NK_STAR */
  {  416,   -1 }, /* (421) star_func_para_list ::= other_para_list */
  {  418,   -1 }, /* (422) other_para_list ::= star_func_para */
  {  418,   -3 }, /* (423) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  419,   -1 }, /* (424) star_func_para ::= expr_or_subquery */
  {  419,   -3 }, /* (425) star_func_para ::= table_name NK_DOT NK_STAR */
  {  414,   -4 }, /* (426) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  414,   -5 }, /* (427) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  420,   -1 }, /* (428) when_then_list ::= when_then_expr */
  {  420,   -2 }, /* (429) when_then_list ::= when_then_list when_then_expr */
  {  423,   -4 }, /* (430) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  421,    0 }, /* (431) case_when_else_opt ::= */
  {  421,   -2 }, /* (432) case_when_else_opt ::= ELSE common_expression */
  {  424,   -3 }, /* (433) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  424,   -5 }, /* (434) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  424,   -6 }, /* (435) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  424,   -3 }, /* (436) predicate ::= expr_or_subquery IS NULL */
  {  424,   -4 }, /* (437) predicate ::= expr_or_subquery IS NOT NULL */
  {  424,   -3 }, /* (438) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  425,   -1 }, /* (439) compare_op ::= NK_LT */
  {  425,   -1 }, /* (440) compare_op ::= NK_GT */
  {  425,   -1 }, /* (441) compare_op ::= NK_LE */
  {  425,   -1 }, /* (442) compare_op ::= NK_GE */
  {  425,   -1 }, /* (443) compare_op ::= NK_NE */
  {  425,   -1 }, /* (444) compare_op ::= NK_EQ */
  {  425,   -1 }, /* (445) compare_op ::= LIKE */
  {  425,   -2 }, /* (446) compare_op ::= NOT LIKE */
  {  425,   -1 }, /* (447) compare_op ::= MATCH */
  {  425,   -1 }, /* (448) compare_op ::= NMATCH */
  {  425,   -1 }, /* (449) compare_op ::= CONTAINS */
  {  426,   -1 }, /* (450) in_op ::= IN */
  {  426,   -2 }, /* (451) in_op ::= NOT IN */
  {  427,   -3 }, /* (452) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  428,   -1 }, /* (453) boolean_value_expression ::= boolean_primary */
  {  428,   -2 }, /* (454) boolean_value_expression ::= NOT boolean_primary */
  {  428,   -3 }, /* (455) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  428,   -3 }, /* (456) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  429,   -1 }, /* (457) boolean_primary ::= predicate */
  {  429,   -3 }, /* (458) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  422,   -1 }, /* (459) common_expression ::= expr_or_subquery */
  {  422,   -1 }, /* (460) common_expression ::= boolean_value_expression */
  {  430,    0 }, /* (461) from_clause_opt ::= */
  {  430,   -2 }, /* (462) from_clause_opt ::= FROM table_reference_list */
  {  431,   -1 }, /* (463) table_reference_list ::= table_reference */
  {  431,   -3 }, /* (464) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  432,   -1 }, /* (465) table_reference ::= table_primary */
  {  432,   -1 }, /* (466) table_reference ::= joined_table */
  {  433,   -2 }, /* (467) table_primary ::= table_name alias_opt */
  {  433,   -4 }, /* (468) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  433,   -2 }, /* (469) table_primary ::= subquery alias_opt */
  {  433,   -1 }, /* (470) table_primary ::= parenthesized_joined_table */
  {  435,    0 }, /* (471) alias_opt ::= */
  {  435,   -1 }, /* (472) alias_opt ::= table_alias */
  {  435,   -2 }, /* (473) alias_opt ::= AS table_alias */
  {  437,   -3 }, /* (474) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  437,   -3 }, /* (475) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  434,   -6 }, /* (476) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  438,    0 }, /* (477) join_type ::= */
  {  438,   -1 }, /* (478) join_type ::= INNER */
  {  440,  -12 }, /* (479) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  441,    0 }, /* (480) set_quantifier_opt ::= */
  {  441,   -1 }, /* (481) set_quantifier_opt ::= DISTINCT */
  {  441,   -1 }, /* (482) set_quantifier_opt ::= ALL */
  {  442,   -1 }, /* (483) select_list ::= select_item */
  {  442,   -3 }, /* (484) select_list ::= select_list NK_COMMA select_item */
  {  450,   -1 }, /* (485) select_item ::= NK_STAR */
  {  450,   -1 }, /* (486) select_item ::= common_expression */
  {  450,   -2 }, /* (487) select_item ::= common_expression column_alias */
  {  450,   -3 }, /* (488) select_item ::= common_expression AS column_alias */
  {  450,   -3 }, /* (489) select_item ::= table_name NK_DOT NK_STAR */
  {  405,    0 }, /* (490) where_clause_opt ::= */
  {  405,   -2 }, /* (491) where_clause_opt ::= WHERE search_condition */
  {  443,    0 }, /* (492) partition_by_clause_opt ::= */
  {  443,   -3 }, /* (493) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  451,   -1 }, /* (494) partition_list ::= partition_item */
  {  451,   -3 }, /* (495) partition_list ::= partition_list NK_COMMA partition_item */
  {  452,   -1 }, /* (496) partition_item ::= expr_or_subquery */
  {  452,   -2 }, /* (497) partition_item ::= expr_or_subquery column_alias */
  {  452,   -3 }, /* (498) partition_item ::= expr_or_subquery AS column_alias */
  {  447,    0 }, /* (499) twindow_clause_opt ::= */
  {  447,   -6 }, /* (500) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  447,   -4 }, /* (501) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  447,   -6 }, /* (502) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  447,   -8 }, /* (503) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  447,   -7 }, /* (504) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  388,    0 }, /* (505) sliding_opt ::= */
  {  388,   -4 }, /* (506) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  446,    0 }, /* (507) fill_opt ::= */
  {  446,   -4 }, /* (508) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  446,   -6 }, /* (509) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  453,   -1 }, /* (510) fill_mode ::= NONE */
  {  453,   -1 }, /* (511) fill_mode ::= PREV */
  {  453,   -1 }, /* (512) fill_mode ::= NULL */
  {  453,   -1 }, /* (513) fill_mode ::= LINEAR */
  {  453,   -1 }, /* (514) fill_mode ::= NEXT */
  {  448,    0 }, /* (515) group_by_clause_opt ::= */
  {  448,   -3 }, /* (516) group_by_clause_opt ::= GROUP BY group_by_list */
  {  454,   -1 }, /* (517) group_by_list ::= expr_or_subquery */
  {  454,   -3 }, /* (518) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  449,    0 }, /* (519) having_clause_opt ::= */
  {  449,   -2 }, /* (520) having_clause_opt ::= HAVING search_condition */
  {  444,    0 }, /* (521) range_opt ::= */
  {  444,   -6 }, /* (522) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  445,    0 }, /* (523) every_opt ::= */
  {  445,   -4 }, /* (524) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  455,   -4 }, /* (525) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  456,   -1 }, /* (526) query_simple ::= query_specification */
  {  456,   -1 }, /* (527) query_simple ::= union_query_expression */
  {  460,   -4 }, /* (528) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  460,   -3 }, /* (529) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  461,   -1 }, /* (530) query_simple_or_subquery ::= query_simple */
  {  461,   -1 }, /* (531) query_simple_or_subquery ::= subquery */
  {  392,   -1 }, /* (532) query_or_subquery ::= query_expression */
  {  392,   -1 }, /* (533) query_or_subquery ::= subquery */
  {  457,    0 }, /* (534) order_by_clause_opt ::= */
  {  457,   -3 }, /* (535) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  458,    0 }, /* (536) slimit_clause_opt ::= */
  {  458,   -2 }, /* (537) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  458,   -4 }, /* (538) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  458,   -4 }, /* (539) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  459,    0 }, /* (540) limit_clause_opt ::= */
  {  459,   -2 }, /* (541) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  459,   -4 }, /* (542) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  459,   -4 }, /* (543) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  436,   -3 }, /* (544) subquery ::= NK_LP query_expression NK_RP */
  {  436,   -3 }, /* (545) subquery ::= NK_LP subquery NK_RP */
  {  439,   -1 }, /* (546) search_condition ::= common_expression */
  {  462,   -1 }, /* (547) sort_specification_list ::= sort_specification */
  {  462,   -3 }, /* (548) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  463,   -3 }, /* (549) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  464,    0 }, /* (550) ordering_specification_opt ::= */
  {  464,   -1 }, /* (551) ordering_specification_opt ::= ASC */
  {  464,   -1 }, /* (552) ordering_specification_opt ::= DESC */
  {  465,    0 }, /* (553) null_ordering_opt ::= */
  {  465,   -2 }, /* (554) null_ordering_opt ::= NULLS FIRST */
  {  465,   -2 }, /* (555) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,327,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,328,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,327,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,329,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,330,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,328,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,330,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,329,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy233, &yymsp[-1].minor.yy0, yymsp[0].minor.yy27); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy233, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy233, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy233, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy233); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy27 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy27 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy129, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy233); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy129, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy233); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy129 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy129 = yymsp[0].minor.yy129; }
  yymsp[0].minor.yy129 = yylhsminor.yy129;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy129 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy129 = yymsp[-2].minor.yy129 | yymsp[0].minor.yy129; }
  yymsp[-2].minor.yy129 = yylhsminor.yy129;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy129 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy129 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy233 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy233 = yylhsminor.yy233;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy233 = yymsp[-2].minor.yy233; }
  yymsp[-2].minor.yy233 = yylhsminor.yy233;
        break;
      case 42: /* priv_level ::= topic_name */
      case 272: /* sma_func_name ::= function_name */ yytestcase(yyruleno==272);
      case 472: /* alias_opt ::= table_alias */ yytestcase(yyruleno==472);
{ yylhsminor.yy233 = yymsp[0].minor.yy233; }
  yymsp[0].minor.yy233 = yylhsminor.yy233;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy233, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy397); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy233, yymsp[0].minor.yy397); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 273: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==273);
      case 274: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==274);
      case 275: /* sma_func_name ::= LAST */ yytestcase(yyruleno==275);
      case 276: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==276);
      case 357: /* db_name ::= NK_ID */ yytestcase(yyruleno==357);
      case 358: /* table_name ::= NK_ID */ yytestcase(yyruleno==358);
      case 359: /* column_name ::= NK_ID */ yytestcase(yyruleno==359);
      case 360: /* function_name ::= NK_ID */ yytestcase(yyruleno==360);
      case 361: /* table_alias ::= NK_ID */ yytestcase(yyruleno==361);
      case 362: /* column_alias ::= NK_ID */ yytestcase(yyruleno==362);
      case 363: /* user_name ::= NK_ID */ yytestcase(yyruleno==363);
      case 364: /* topic_name ::= NK_ID */ yytestcase(yyruleno==364);
      case 365: /* stream_name ::= NK_ID */ yytestcase(yyruleno==365);
      case 366: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==366);
      case 367: /* index_name ::= NK_ID */ yytestcase(yyruleno==367);
      case 407: /* noarg_func ::= NOW */ yytestcase(yyruleno==407);
      case 408: /* noarg_func ::= TODAY */ yytestcase(yyruleno==408);
      case 409: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==409);
      case 410: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==410);
      case 411: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==411);
      case 412: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==412);
      case 413: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==413);
      case 414: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==414);
      case 415: /* noarg_func ::= USER */ yytestcase(yyruleno==415);
      case 416: /* star_func ::= COUNT */ yytestcase(yyruleno==416);
      case 417: /* star_func ::= FIRST */ yytestcase(yyruleno==417);
      case 418: /* star_func ::= LAST */ yytestcase(yyruleno==418);
      case 419: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==419);
{ yylhsminor.yy233 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy233 = yylhsminor.yy233;
        break;
      case 54: /* force_opt ::= */
      case 73: /* not_exists_opt ::= */ yytestcase(yyruleno==73);
      case 75: /* exists_opt ::= */ yytestcase(yyruleno==75);
      case 292: /* analyze_opt ::= */ yytestcase(yyruleno==292);
      case 299: /* agg_func_opt ::= */ yytestcase(yyruleno==299);
      case 480: /* set_quantifier_opt ::= */ yytestcase(yyruleno==480);
{ yymsp[1].minor.yy397 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 293: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==293);
      case 300: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==300);
      case 481: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==481);
{ yymsp[0].minor.yy397 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy397, &yymsp[-1].minor.yy233, yymsp[0].minor.yy924); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy397, &yymsp[0].minor.yy233); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy233); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy233, yymsp[0].minor.yy924); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy233); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy233, yymsp[0].minor.yy832); }
        break;
      case 72: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy397 = true; }
        break;
      case 74: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy397 = true; }
        break;
      case 76: /* db_options ::= */
{ yymsp[1].minor.yy924 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 77: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 78: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 79: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 80: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 81: /* db_options ::= db_options DURATION NK_INTEGER */
      case 82: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==82);
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 83: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 84: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 85: /* db_options ::= db_options KEEP integer_list */
      case 86: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==86);
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_KEEP, yymsp[0].minor.yy776); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 87: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 88: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 89: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 90: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 91: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 92: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 93: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 94: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_RETENTIONS, yymsp[0].minor.yy776); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 95: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 96: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 97: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-3].minor.yy924, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-3].minor.yy924, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 102: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 103: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 104: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 105: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 106: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy924 = setDatabaseOption(pCxt, yymsp[-2].minor.yy924, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 107: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy924 = createAlterDatabaseOptions(pCxt); yylhsminor.yy924 = setAlterDatabaseOption(pCxt, yylhsminor.yy924, &yymsp[0].minor.yy257); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 108: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy924 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy924, &yymsp[0].minor.yy257); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 109: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy257.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy257.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy257.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy257.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy257.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy257.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy257.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy257.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= KEEP integer_list */
      case 114: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==114);
{ yymsp[-1].minor.yy257.type = DB_OPTION_KEEP; yymsp[-1].minor.yy257.pList = yymsp[0].minor.yy776; }
        break;
      case 115: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy257.type = DB_OPTION_PAGES; yymsp[-1].minor.yy257.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy257.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy257.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy257.type = DB_OPTION_WAL; yymsp[-1].minor.yy257.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy257.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy257.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy776 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 120: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 327: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==327);
{ yylhsminor.yy776 = addNodeToList(pCxt, yymsp[-2].minor.yy776, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 121: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy776 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 122: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy776 = addNodeToList(pCxt, yymsp[-2].minor.yy776, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 123: /* retention_list ::= retention */
      case 145: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==145);
      case 148: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==148);
      case 155: /* column_def_list ::= column_def */ yytestcase(yyruleno==155);
      case 199: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==199);
      case 204: /* col_name_list ::= col_name */ yytestcase(yyruleno==204);
      case 255: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==255);
      case 269: /* func_list ::= func */ yytestcase(yyruleno==269);
      case 355: /* literal_list ::= signed_literal */ yytestcase(yyruleno==355);
      case 422: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==422);
      case 428: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==428);
      case 483: /* select_list ::= select_item */ yytestcase(yyruleno==483);
      case 494: /* partition_list ::= partition_item */ yytestcase(yyruleno==494);
      case 547: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==547);
{ yylhsminor.yy776 = createNodeList(pCxt, yymsp[0].minor.yy924); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 124: /* retention_list ::= retention_list NK_COMMA retention */
      case 156: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==205);
      case 256: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==256);
      case 270: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==270);
      case 356: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==356);
      case 423: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==423);
      case 484: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==484);
      case 495: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==495);
      case 548: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==548);
{ yylhsminor.yy776 = addNodeToList(pCxt, yymsp[-2].minor.yy776, yymsp[0].minor.yy924); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 125: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy924 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 126: /* speed_opt ::= */
      case 301: /* bufsize_opt ::= */ yytestcase(yyruleno==301);
{ yymsp[1].minor.yy832 = 0; }
        break;
      case 127: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 302: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==302);
{ yymsp[-1].minor.yy832 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 128: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 130: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==130);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy397, yymsp[-5].minor.yy924, yymsp[-3].minor.yy776, yymsp[-1].minor.yy776, yymsp[0].minor.yy924); }
        break;
      case 129: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy776); }
        break;
      case 131: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy776); }
        break;
      case 132: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy397, yymsp[0].minor.yy924); }
        break;
      case 133: /* cmd ::= ALTER TABLE alter_table_clause */
      case 329: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==329);
{ pCxt->pRootNode = yymsp[0].minor.yy924; }
        break;
      case 134: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy924); }
        break;
      case 135: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy924 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy924, yymsp[0].minor.yy924); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 136: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy924 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy924, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy233, yymsp[0].minor.yy852); }
  yymsp[-4].minor.yy924 = yylhsminor.yy924;
        break;
      case 137: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy924 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy924, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy233); }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 138: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy924 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy924, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy233, yymsp[0].minor.yy852); }
  yymsp[-4].minor.yy924 = yylhsminor.yy924;
        break;
      case 139: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy924 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy924, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy233, &yymsp[0].minor.yy233); }
  yymsp[-4].minor.yy924 = yylhsminor.yy924;
        break;
      case 140: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy924 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy924, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy233, yymsp[0].minor.yy852); }
  yymsp[-4].minor.yy924 = yylhsminor.yy924;
        break;
      case 141: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy924 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy924, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy233); }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 142: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy924 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy924, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy233, yymsp[0].minor.yy852); }
  yymsp[-4].minor.yy924 = yylhsminor.yy924;
        break;
      case 143: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy924 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy924, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy233, &yymsp[0].minor.yy233); }
  yymsp[-4].minor.yy924 = yylhsminor.yy924;
        break;
      case 144: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy924 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy924, &yymsp[-2].minor.yy233, yymsp[0].minor.yy924); }
  yymsp[-5].minor.yy924 = yylhsminor.yy924;
        break;
      case 146: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 149: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==149);
      case 429: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==429);
{ yylhsminor.yy776 = addNodeToList(pCxt, yymsp[-1].minor.yy776, yymsp[0].minor.yy924); }
  yymsp[-1].minor.yy776 = yylhsminor.yy776;
        break;
      case 147: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy924 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy397, yymsp[-8].minor.yy924, yymsp[-6].minor.yy924, yymsp[-5].minor.yy776, yymsp[-2].minor.yy776, yymsp[0].minor.yy924); }
  yymsp[-9].minor.yy924 = yylhsminor.yy924;
        break;
      case 150: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy924 = createDropTableClause(pCxt, yymsp[-1].minor.yy397, yymsp[0].minor.yy924); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 151: /* specific_cols_opt ::= */
      case 182: /* tags_def_opt ::= */ yytestcase(yyruleno==182);
      case 254: /* tag_list_opt ::= */ yytestcase(yyruleno==254);
      case 305: /* col_list_opt ::= */ yytestcase(yyruleno==305);
      case 307: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==307);
      case 492: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==492);
      case 515: /* group_by_clause_opt ::= */ yytestcase(yyruleno==515);
      case 534: /* order_by_clause_opt ::= */ yytestcase(yyruleno==534);
{ yymsp[1].minor.yy776 = NULL; }
        break;
      case 152: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 306: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==306);
{ yymsp[-2].minor.yy776 = yymsp[-1].minor.yy776; }
        break;
      case 153: /* full_table_name ::= table_name */
{ yylhsminor.yy924 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy233, NULL); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 154: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy924 = createRealTableNode(pCxt, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy233, NULL); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 157: /* column_def ::= column_name type_name */
{ yylhsminor.yy924 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy233, yymsp[0].minor.yy852, NULL); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 158: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy924 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy233, yymsp[-2].minor.yy852, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 159: /* type_name ::= BOOL */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 160: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 161: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 162: /* type_name ::= INT */
      case 163: /* type_name ::= INTEGER */ yytestcase(yyruleno==163);
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 164: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 165: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 166: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 167: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy852 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 169: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy852 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy852 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 171: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy852 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 172: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy852 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 173: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy852 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 174: /* type_name ::= JSON */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 175: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy852 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 176: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 177: /* type_name ::= BLOB */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 178: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy852 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 179: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy852 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 180: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy852 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy852 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 183: /* tags_def_opt ::= tags_def */
      case 308: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==308);
      case 421: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==421);
{ yylhsminor.yy776 = yymsp[0].minor.yy776; }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 184: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 309: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==309);
{ yymsp[-3].minor.yy776 = yymsp[-1].minor.yy776; }
        break;
      case 185: /* table_options ::= */
{ yymsp[1].minor.yy924 = createDefaultTableOptions(pCxt); }
        break;
      case 186: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy924 = setTableOption(pCxt, yymsp[-2].minor.yy924, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 187: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy924 = setTableOption(pCxt, yymsp[-2].minor.yy924, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy776); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 188: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy924 = setTableOption(pCxt, yymsp[-2].minor.yy924, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy776); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 189: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy924 = setTableOption(pCxt, yymsp[-4].minor.yy924, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy776); }
  yymsp[-4].minor.yy924 = yylhsminor.yy924;
        break;
      case 190: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy924 = setTableOption(pCxt, yymsp[-2].minor.yy924, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 191: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy924 = setTableOption(pCxt, yymsp[-4].minor.yy924, TABLE_OPTION_SMA, yymsp[-1].minor.yy776); }
  yymsp[-4].minor.yy924 = yylhsminor.yy924;
        break;
      case 192: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy924 = setTableOption(pCxt, yymsp[-2].minor.yy924, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy776); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 193: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy924 = createAlterTableOptions(pCxt); yylhsminor.yy924 = setTableOption(pCxt, yylhsminor.yy924, yymsp[0].minor.yy257.type, &yymsp[0].minor.yy257.val); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 194: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy924 = setTableOption(pCxt, yymsp[-1].minor.yy924, yymsp[0].minor.yy257.type, &yymsp[0].minor.yy257.val); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 195: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy257.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy257.val = yymsp[0].minor.yy0; }
        break;
      case 196: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy257.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy257.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* duration_list ::= duration_literal */
      case 385: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==385);
{ yylhsminor.yy776 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy924)); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 198: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 386: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==386);
{ yylhsminor.yy776 = addNodeToList(pCxt, yymsp[-2].minor.yy776, releaseRawExprNode(pCxt, yymsp[0].minor.yy924)); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 201: /* rollup_func_name ::= function_name */
{ yylhsminor.yy924 = createFunctionNode(pCxt, &yymsp[0].minor.yy233, NULL); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 202: /* rollup_func_name ::= FIRST */
      case 203: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==203);
      case 258: /* tag_item ::= QTAGS */ yytestcase(yyruleno==258);
{ yylhsminor.yy924 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 206: /* col_name ::= column_name */
      case 259: /* tag_item ::= column_name */ yytestcase(yyruleno==259);
{ yylhsminor.yy924 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy233); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 207: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 208: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 209: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 210: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 211: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy924, yymsp[0].minor.yy924, OP_TYPE_LIKE); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy924, yymsp[0].minor.yy924, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy924, NULL, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 217: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy924, yymsp[-1].minor.yy924, OP_TYPE_EQUAL); }
        break;
      case 218: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 219: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 220: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 221: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 222: /* cmd ::= SHOW LICENCES */
      case 223: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==223);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 224: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy233); }
        break;
      case 225: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy924); }
        break;
      case 226: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy924); }
        break;
      case 227: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 228: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 229: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 230: /* cmd ::= SHOW VARIABLES */
      case 231: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==231);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 232: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy924); }
        break;
      case 234: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 235: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 237: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 238: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy924); }
        break;
      case 239: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 240: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 241: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy924, yymsp[-1].minor.yy924, OP_TYPE_EQUAL); }
        break;
      case 242: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy924, yymsp[0].minor.yy924, yymsp[-3].minor.yy776); }
        break;
      case 243: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 245: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy924,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 246: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 247: /* db_name_cond_opt ::= */
      case 252: /* from_db_opt ::= */ yytestcase(yyruleno==252);
{ yymsp[1].minor.yy924 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 248: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy924 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy233); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 249: /* like_pattern_opt ::= */
      case 317: /* subtable_opt ::= */ yytestcase(yyruleno==317);
      case 431: /* case_when_else_opt ::= */ yytestcase(yyruleno==431);
      case 461: /* from_clause_opt ::= */ yytestcase(yyruleno==461);
      case 490: /* where_clause_opt ::= */ yytestcase(yyruleno==490);
      case 499: /* twindow_clause_opt ::= */ yytestcase(yyruleno==499);
      case 505: /* sliding_opt ::= */ yytestcase(yyruleno==505);
      case 507: /* fill_opt ::= */ yytestcase(yyruleno==507);
      case 519: /* having_clause_opt ::= */ yytestcase(yyruleno==519);
      case 521: /* range_opt ::= */ yytestcase(yyruleno==521);
      case 523: /* every_opt ::= */ yytestcase(yyruleno==523);
      case 536: /* slimit_clause_opt ::= */ yytestcase(yyruleno==536);
      case 540: /* limit_clause_opt ::= */ yytestcase(yyruleno==540);
{ yymsp[1].minor.yy924 = NULL; }
        break;
      case 250: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 251: /* table_name_cond ::= table_name */
{ yylhsminor.yy924 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy233); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 253: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy924 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy233); }
        break;
      case 257: /* tag_item ::= TBNAME */
{ yylhsminor.yy924 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 260: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy924 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy233), &yymsp[0].minor.yy233); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 261: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy924 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy233), &yymsp[0].minor.yy233); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 262: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy397, yymsp[-3].minor.yy924, yymsp[-1].minor.yy924, NULL, yymsp[0].minor.yy924); }
        break;
      case 263: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy397, yymsp[-5].minor.yy924, yymsp[-3].minor.yy924, yymsp[-1].minor.yy776, NULL); }
        break;
      case 264: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy397, yymsp[0].minor.yy924); }
        break;
      case 265: /* full_index_name ::= index_name */
{ yylhsminor.yy924 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy233); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 266: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy924 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy233); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 267: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy924 = createIndexOption(pCxt, yymsp[-7].minor.yy776, releaseRawExprNode(pCxt, yymsp[-3].minor.yy924), NULL, yymsp[-1].minor.yy924, yymsp[0].minor.yy924); }
        break;
      case 268: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy924 = createIndexOption(pCxt, yymsp[-9].minor.yy776, releaseRawExprNode(pCxt, yymsp[-5].minor.yy924), releaseRawExprNode(pCxt, yymsp[-3].minor.yy924), yymsp[-1].minor.yy924, yymsp[0].minor.yy924); }
        break;
      case 271: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy924 = createFunctionNode(pCxt, &yymsp[-3].minor.yy233, yymsp[-1].minor.yy776); }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 277: /* sma_stream_opt ::= */
      case 310: /* stream_options ::= */ yytestcase(yyruleno==310);
{ yymsp[1].minor.yy924 = createStreamOptions(pCxt); }
        break;
      case 278: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 314: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==314);
{ ((SStreamOptions*)yymsp[-2].minor.yy924)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy924); yylhsminor.yy924 = yymsp[-2].minor.yy924; }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 279: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy924)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy924); yylhsminor.yy924 = yymsp[-2].minor.yy924; }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 280: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy924)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy924); yylhsminor.yy924 = yymsp[-2].minor.yy924; }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 281: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy397, &yymsp[-2].minor.yy233, yymsp[0].minor.yy924); }
        break;
      case 282: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy397, &yymsp[-3].minor.yy233, &yymsp[0].minor.yy233, false); }
        break;
      case 283: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy397, &yymsp[-5].minor.yy233, &yymsp[0].minor.yy233, true); }
        break;
      case 284: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy397, &yymsp[-3].minor.yy233, yymsp[0].minor.yy924, false); }
        break;
      case 285: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy397, &yymsp[-5].minor.yy233, yymsp[0].minor.yy924, true); }
        break;
      case 286: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy397, &yymsp[0].minor.yy233); }
        break;
      case 287: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy397, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy233); }
        break;
      case 288: /* cmd ::= DESC full_table_name */
      case 289: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==289);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy924); }
        break;
      case 290: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 291: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy397, yymsp[-1].minor.yy924, yymsp[0].minor.yy924); }
        break;
      case 294: /* explain_options ::= */
{ yymsp[1].minor.yy924 = createDefaultExplainOptions(pCxt); }
        break;
      case 295: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy924 = setExplainVerbose(pCxt, yymsp[-2].minor.yy924, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 296: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy924 = setExplainRatio(pCxt, yymsp[-2].minor.yy924, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 297: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy397, yymsp[-8].minor.yy397, &yymsp[-5].minor.yy233, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy852, yymsp[0].minor.yy832); }
        break;
      case 298: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy397, &yymsp[0].minor.yy233); }
        break;
      case 303: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy397, &yymsp[-8].minor.yy233, yymsp[-5].minor.yy924, yymsp[-7].minor.yy924, yymsp[-3].minor.yy776, yymsp[-2].minor.yy924, yymsp[0].minor.yy924, yymsp[-4].minor.yy776); }
        break;
      case 304: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy397, &yymsp[0].minor.yy233); }
        break;
      case 311: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy924)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy924 = yymsp[-2].minor.yy924; }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 312: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy924)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy924 = yymsp[-2].minor.yy924; }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 313: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy924)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy924)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy924); yylhsminor.yy924 = yymsp[-3].minor.yy924; }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 315: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy924)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy924 = yymsp[-3].minor.yy924; }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 316: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy924)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy924 = yymsp[-2].minor.yy924; }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 318: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 506: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==506);
      case 524: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==524);
{ yymsp[-3].minor.yy924 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy924); }
        break;
      case 319: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 320: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 321: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 322: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 323: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 324: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy776); }
        break;
      case 325: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 326: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy776 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 328: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy924, yymsp[0].minor.yy924); }
        break;
      case 330: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy924, yymsp[-2].minor.yy776, yymsp[0].minor.yy924); }
        break;
      case 331: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy924, NULL, yymsp[0].minor.yy924); }
        break;
      case 332: /* literal ::= NK_INTEGER */
{ yylhsminor.yy924 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 333: /* literal ::= NK_FLOAT */
{ yylhsminor.yy924 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 334: /* literal ::= NK_STRING */
{ yylhsminor.yy924 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 335: /* literal ::= NK_BOOL */
{ yylhsminor.yy924 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 336: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 337: /* literal ::= duration_literal */
      case 347: /* signed_literal ::= signed */ yytestcase(yyruleno==347);
      case 368: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==368);
      case 369: /* expression ::= literal */ yytestcase(yyruleno==369);
      case 370: /* expression ::= pseudo_column */ yytestcase(yyruleno==370);
      case 371: /* expression ::= column_reference */ yytestcase(yyruleno==371);
      case 372: /* expression ::= function_expression */ yytestcase(yyruleno==372);
      case 373: /* expression ::= case_when_expression */ yytestcase(yyruleno==373);
      case 404: /* function_expression ::= literal_func */ yytestcase(yyruleno==404);
      case 453: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==453);
      case 457: /* boolean_primary ::= predicate */ yytestcase(yyruleno==457);
      case 459: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==459);
      case 460: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==460);
      case 463: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==463);
      case 465: /* table_reference ::= table_primary */ yytestcase(yyruleno==465);
      case 466: /* table_reference ::= joined_table */ yytestcase(yyruleno==466);
      case 470: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==470);
      case 526: /* query_simple ::= query_specification */ yytestcase(yyruleno==526);
      case 527: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==527);
      case 530: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==530);
      case 532: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==532);
{ yylhsminor.yy924 = yymsp[0].minor.yy924; }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 338: /* literal ::= NULL */
{ yylhsminor.yy924 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 339: /* literal ::= NK_QUESTION */
{ yylhsminor.yy924 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 340: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy924 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 341: /* signed ::= NK_INTEGER */
{ yylhsminor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 342: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 343: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 344: /* signed ::= NK_FLOAT */
{ yylhsminor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 345: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 346: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 348: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 349: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 350: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 351: /* signed_literal ::= duration_literal */
      case 353: /* signed_literal ::= literal_func */ yytestcase(yyruleno==353);
      case 424: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==424);
      case 486: /* select_item ::= common_expression */ yytestcase(yyruleno==486);
      case 496: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==496);
      case 531: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==531);
      case 533: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==533);
      case 546: /* search_condition ::= common_expression */ yytestcase(yyruleno==546);
{ yylhsminor.yy924 = releaseRawExprNode(pCxt, yymsp[0].minor.yy924); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 352: /* signed_literal ::= NULL */
{ yylhsminor.yy924 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 354: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy924 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 374: /* expression ::= NK_LP expression NK_RP */
      case 458: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==458);
      case 545: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==545);
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy924)); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 375: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy924));
                                                                                  }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 376: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy924), NULL));
                                                                                  }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 377: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924))); 
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 378: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924))); 
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 379: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924))); 
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 380: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924))); 
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 381: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924)));
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 382: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 383: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924)));
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 384: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924)));
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 387: /* column_reference ::= column_name */
{ yylhsminor.yy924 = createRawExprNode(pCxt, &yymsp[0].minor.yy233, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy233)); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 388: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy233, createColumnNode(pCxt, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy233)); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 389: /* pseudo_column ::= ROWTS */
      case 390: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==390);
      case 392: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==392);
      case 393: /* pseudo_column ::= QEND */ yytestcase(yyruleno==393);
      case 394: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==394);
      case 395: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==395);
      case 396: /* pseudo_column ::= WEND */ yytestcase(yyruleno==396);
      case 397: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==397);
      case 398: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==398);
      case 399: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==399);
      case 400: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==400);
      case 406: /* literal_func ::= NOW */ yytestcase(yyruleno==406);
{ yylhsminor.yy924 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 391: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy233)))); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 401: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 402: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==402);
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy233, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy233, yymsp[-1].minor.yy776)); }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 403: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy924), yymsp[-1].minor.yy852)); }
  yymsp[-5].minor.yy924 = yylhsminor.yy924;
        break;
      case 405: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy233, NULL)); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 420: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy776 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 425: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 489: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==489);
{ yylhsminor.yy924 = createColumnNode(pCxt, &yymsp[-2].minor.yy233, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 426: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy776, yymsp[-1].minor.yy924)); }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 427: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy924), yymsp[-2].minor.yy776, yymsp[-1].minor.yy924)); }
  yymsp[-4].minor.yy924 = yylhsminor.yy924;
        break;
      case 430: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy924 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924)); }
        break;
      case 432: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy924 = releaseRawExprNode(pCxt, yymsp[0].minor.yy924); }
        break;
      case 433: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 438: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==438);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy856, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924)));
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 434: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy924), releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924)));
                                                                                  }
  yymsp[-4].minor.yy924 = yylhsminor.yy924;
        break;
      case 435: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy924), releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924)));
                                                                                  }
  yymsp[-5].minor.yy924 = yylhsminor.yy924;
        break;
      case 436: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), NULL));
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 437: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy924), NULL));
                                                                                  }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 439: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy856 = OP_TYPE_LOWER_THAN; }
        break;
      case 440: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy856 = OP_TYPE_GREATER_THAN; }
        break;
      case 441: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy856 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 442: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy856 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 443: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy856 = OP_TYPE_NOT_EQUAL; }
        break;
      case 444: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy856 = OP_TYPE_EQUAL; }
        break;
      case 445: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy856 = OP_TYPE_LIKE; }
        break;
      case 446: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy856 = OP_TYPE_NOT_LIKE; }
        break;
      case 447: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy856 = OP_TYPE_MATCH; }
        break;
      case 448: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy856 = OP_TYPE_NMATCH; }
        break;
      case 449: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy856 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 450: /* in_op ::= IN */
{ yymsp[0].minor.yy856 = OP_TYPE_IN; }
        break;
      case 451: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy856 = OP_TYPE_NOT_IN; }
        break;
      case 452: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy776)); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 454: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy924), NULL));
                                                                                  }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 455: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924)));
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 456: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy924);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy924);
                                                                                    yylhsminor.yy924 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), releaseRawExprNode(pCxt, yymsp[0].minor.yy924)));
                                                                                  }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 462: /* from_clause_opt ::= FROM table_reference_list */
      case 491: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==491);
      case 520: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==520);
{ yymsp[-1].minor.yy924 = yymsp[0].minor.yy924; }
        break;
      case 464: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy924 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy924, yymsp[0].minor.yy924, NULL); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 467: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy924 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy233, &yymsp[0].minor.yy233); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 468: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy924 = createRealTableNode(pCxt, &yymsp[-3].minor.yy233, &yymsp[-1].minor.yy233, &yymsp[0].minor.yy233); }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 469: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy924 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy924), &yymsp[0].minor.yy233); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 471: /* alias_opt ::= */
{ yymsp[1].minor.yy233 = nil_token;  }
        break;
      case 473: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy233 = yymsp[0].minor.yy233; }
        break;
      case 474: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 475: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==475);
{ yymsp[-2].minor.yy924 = yymsp[-1].minor.yy924; }
        break;
      case 476: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy924 = createJoinTableNode(pCxt, yymsp[-4].minor.yy428, yymsp[-5].minor.yy924, yymsp[-2].minor.yy924, yymsp[0].minor.yy924); }
  yymsp[-5].minor.yy924 = yylhsminor.yy924;
        break;
      case 477: /* join_type ::= */
{ yymsp[1].minor.yy428 = JOIN_TYPE_INNER; }
        break;
      case 478: /* join_type ::= INNER */
{ yymsp[0].minor.yy428 = JOIN_TYPE_INNER; }
        break;
      case 479: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy924 = createSelectStmt(pCxt, yymsp[-10].minor.yy397, yymsp[-9].minor.yy776, yymsp[-8].minor.yy924);
                                                                                    yymsp[-11].minor.yy924 = addWhereClause(pCxt, yymsp[-11].minor.yy924, yymsp[-7].minor.yy924);
                                                                                    yymsp[-11].minor.yy924 = addPartitionByClause(pCxt, yymsp[-11].minor.yy924, yymsp[-6].minor.yy776);
                                                                                    yymsp[-11].minor.yy924 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy924, yymsp[-2].minor.yy924);
                                                                                    yymsp[-11].minor.yy924 = addGroupByClause(pCxt, yymsp[-11].minor.yy924, yymsp[-1].minor.yy776);
                                                                                    yymsp[-11].minor.yy924 = addHavingClause(pCxt, yymsp[-11].minor.yy924, yymsp[0].minor.yy924);
                                                                                    yymsp[-11].minor.yy924 = addRangeClause(pCxt, yymsp[-11].minor.yy924, yymsp[-5].minor.yy924);
                                                                                    yymsp[-11].minor.yy924 = addEveryClause(pCxt, yymsp[-11].minor.yy924, yymsp[-4].minor.yy924);
                                                                                    yymsp[-11].minor.yy924 = addFillClause(pCxt, yymsp[-11].minor.yy924, yymsp[-3].minor.yy924);
                                                                                  }
        break;
      case 482: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy397 = false; }
        break;
      case 485: /* select_item ::= NK_STAR */
{ yylhsminor.yy924 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy924 = yylhsminor.yy924;
        break;
      case 487: /* select_item ::= common_expression column_alias */
      case 497: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==497);
{ yylhsminor.yy924 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy924), &yymsp[0].minor.yy233); }
  yymsp[-1].minor.yy924 = yylhsminor.yy924;
        break;
      case 488: /* select_item ::= common_expression AS column_alias */
      case 498: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==498);
{ yylhsminor.yy924 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), &yymsp[0].minor.yy233); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 493: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 516: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==516);
      case 535: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==535);
{ yymsp[-2].minor.yy776 = yymsp[0].minor.yy776; }
        break;
      case 500: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy924 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy924), releaseRawExprNode(pCxt, yymsp[-1].minor.yy924)); }
        break;
      case 501: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy924 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy924)); }
        break;
      case 502: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy924 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy924), NULL, yymsp[-1].minor.yy924, yymsp[0].minor.yy924); }
        break;
      case 503: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy924 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy924), releaseRawExprNode(pCxt, yymsp[-3].minor.yy924), yymsp[-1].minor.yy924, yymsp[0].minor.yy924); }
        break;
      case 504: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy924 = createEventWindowNode(pCxt, yymsp[-3].minor.yy924, yymsp[0].minor.yy924); }
        break;
      case 508: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy924 = createFillNode(pCxt, yymsp[-1].minor.yy646, NULL); }
        break;
      case 509: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy924 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy776)); }
        break;
      case 510: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy646 = FILL_MODE_NONE; }
        break;
      case 511: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy646 = FILL_MODE_PREV; }
        break;
      case 512: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy646 = FILL_MODE_NULL; }
        break;
      case 513: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy646 = FILL_MODE_LINEAR; }
        break;
      case 514: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy646 = FILL_MODE_NEXT; }
        break;
      case 517: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy776 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy924))); }
  yymsp[0].minor.yy776 = yylhsminor.yy776;
        break;
      case 518: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy776 = addNodeToList(pCxt, yymsp[-2].minor.yy776, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy924))); }
  yymsp[-2].minor.yy776 = yylhsminor.yy776;
        break;
      case 522: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy924 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy924), releaseRawExprNode(pCxt, yymsp[-1].minor.yy924)); }
        break;
      case 525: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy924 = addOrderByClause(pCxt, yymsp[-3].minor.yy924, yymsp[-2].minor.yy776);
                                                                                    yylhsminor.yy924 = addSlimitClause(pCxt, yylhsminor.yy924, yymsp[-1].minor.yy924);
                                                                                    yylhsminor.yy924 = addLimitClause(pCxt, yylhsminor.yy924, yymsp[0].minor.yy924);
                                                                                  }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 528: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy924 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy924, yymsp[0].minor.yy924); }
  yymsp[-3].minor.yy924 = yylhsminor.yy924;
        break;
      case 529: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy924 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy924, yymsp[0].minor.yy924); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 537: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 541: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==541);
{ yymsp[-1].minor.yy924 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 538: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 542: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==542);
{ yymsp[-3].minor.yy924 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 539: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 543: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==543);
{ yymsp[-3].minor.yy924 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 544: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy924 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy924); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 549: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy924 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy924), yymsp[-1].minor.yy870, yymsp[0].minor.yy89); }
  yymsp[-2].minor.yy924 = yylhsminor.yy924;
        break;
      case 550: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy870 = ORDER_ASC; }
        break;
      case 551: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy870 = ORDER_ASC; }
        break;
      case 552: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy870 = ORDER_DESC; }
        break;
      case 553: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy89 = NULL_ORDER_DEFAULT; }
        break;
      case 554: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy89 = NULL_ORDER_FIRST; }
        break;
      case 555: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy89 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
