/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 314
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  ENullOrder yy69;
  SNode* yy140;
  EFillMode yy174;
  SAlterOption yy181;
  SNodeList* yy220;
  EJoinType yy224;
  EOrder yy238;
  SToken yy253;
  bool yy273;
  SDataType yy368;
  EOperatorType yy480;
  int32_t yy528;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYNSTATE             548
#define YYNRULE              410
#define YYNTOKEN             208
#define YY_MAX_SHIFT         547
#define YY_MIN_SHIFTREDUCE   807
#define YY_MAX_SHIFTREDUCE   1216
#define YY_ERROR_ACTION      1217
#define YY_ACCEPT_ACTION     1218
#define YY_NO_ACTION         1219
#define YY_MIN_REDUCE        1220
#define YY_MAX_REDUCE        1629
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1533)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   463,   25,  194,   52,  257,  306, 1497,    9,    8,   72,
 /*    10 */   277,  388,   30,   28,  463,  274,  369, 1421, 1423,  270,
 /*    20 */   266, 1481, 1052,  310, 1336, 1340,  396,  115, 1072, 1481,
 /*    30 */  1514, 1497, 1481, 1477, 1483, 1342, 1608,  446, 1050, 1340,
 /*    40 */   166, 1477, 1484,  391, 1477, 1483,  462,  449,  385,  131,
 /*    50 */    11, 1468,  406, 1606,  165, 1514,  312, 1057,   29,   27,
 /*    60 */    26,  348,  446,   30,   28, 1159,  463,  119, 1498, 1499,
 /*    70 */  1503,  266,  449, 1052,    1,   72, 1468,   30,   28,  265,
 /*    80 */    42, 1135,  375,   41,  462,  266,  238, 1052, 1497, 1050,
 /*    90 */  1331, 1340,  229, 1498, 1499, 1503,  407,  544,  540,  539,
 /*   100 */  1075,   11,  462, 1050,  450,  435, 1621,  269, 1057, 1051,
 /*   110 */  1430,  463, 1514,  381,  380,   11,   30,   28,  430,  446,
 /*   120 */   311,  117, 1057, 1232,  266,    1, 1052, 1608, 1608,  449,
 /*   130 */   513,  511, 1243, 1468,  430, 1468, 1340, 1124,   12,    1,
 /*   140 */   131, 1607, 1050,  100, 1606, 1606, 1053, 1318,  544,   70,
 /*   150 */  1498, 1499, 1503, 1547,  420, 1128,   12, 1546, 1543,  100,
 /*   160 */  1051, 1057,  544, 1056, 1076, 1077, 1103, 1104, 1105, 1106,
 /*   170 */  1107, 1108, 1109, 1110, 1051,  463,   98, 1468,    7,   22,
 /*   180 */  1242,   30,   28,  448,  319,  132,  128, 1554, 1555,  266,
 /*   190 */  1559, 1052,   98,  132,  118,  132,  348, 1053, 1298, 1387,
 /*   200 */  1340,  544,  129, 1554, 1555,  256, 1559, 1050,  425,  421,
 /*   210 */  1385, 1053, 1074, 1051, 1056, 1076, 1077, 1103, 1104, 1105,
 /*   220 */  1106, 1107, 1108, 1109, 1110, 1468, 1057, 1221, 1056, 1076,
 /*   230 */  1077, 1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110,  305,
 /*   240 */   844,  304,  843,    7, 1076, 1077,    9,    8,   84,  132,
 /*   250 */  1053,   83,   82,   81,   80,   79,   78,   77,   76,   75,
 /*   260 */   845,   32,   31,   29,   27,   26,  544, 1056, 1076, 1077,
 /*   270 */  1103, 1104, 1105, 1106, 1107, 1108, 1109, 1110, 1051,  132,
 /*   280 */   424, 1418,   52,   30,   28,  237,   65, 1072,  139,  132,
 /*   290 */   383,  266,  377, 1052,  327,   96,  382,  339, 1241,   97,
 /*   300 */   101,  378,  376, 1335,  379,  216,  340, 1332, 1370, 1050,
 /*   310 */    32,   31,   29,   27,   26, 1053,   84, 1566, 1154,   83,
 /*   320 */    82,   81,   80,   79,   78,   77,   76,   75, 1057, 1220,
 /*   330 */   334, 1183, 1056, 1076, 1077, 1103, 1104, 1105, 1106, 1107,
 /*   340 */  1108, 1109, 1110, 1468, 1078,    7,  164,  445,  241,  137,
 /*   350 */   372,  895,  498,   93,   92,   91,   90,   89,   88,   87,
 /*   360 */    86,   85,  417, 1181, 1182, 1184, 1185,  501,  544, 1312,
 /*   370 */   897, 1079,  374, 1091,  250,   50,  141,  140,   49,  338,
 /*   380 */  1051, 1122,  333,  332,  331,  330,  329,  430,  326,  325,
 /*   390 */   324,  323,  322,  318,  317,  316,  315,  314,  313,  463,
 /*   400 */   164,   30,   28,  489,  372, 1561,  463,  450,  320,  266,
 /*   410 */  1561, 1052,  100, 1431, 1387,  347,  251, 1053,  249,  248,
 /*   420 */   271,  371, 1514, 1558, 1340, 1385,  374, 1050, 1557,  446,
 /*   430 */  1123, 1340, 1215, 1216, 1056, 1076, 1077, 1103, 1104, 1105,
 /*   440 */  1106, 1107, 1108, 1109, 1110,   98, 1057, 1269, 1127,   32,
 /*   450 */    31,   29,   27,   26,  432,  127, 1554, 1555, 1317, 1559,
 /*   460 */  1114,  423,  189,    1, 1073,   32,   31,   29,   27,   26,
 /*   470 */  1561,   59,   24,  264, 1117, 1118, 1119, 1120, 1121, 1125,
 /*   480 */  1126,   32,   31,   29,   27,   26,  544,  241, 1556,  175,
 /*   490 */  1166,  157, 1333,  122,  155, 1158, 1074, 1240, 1051,  520,
 /*   500 */   519,  518,  517,  281, 1380,  516,  515,  514,  102,  509,
 /*   510 */   508,  507,  506,  505,  504,  503,  502,  108,  159,  209,
 /*   520 */  1122,  158,  500,  494,  933,  486,  485,  484,  937,  483,
 /*   530 */   939,  940,  482,  942,  479, 1053,  948,  476,  950,  951,
 /*   540 */   473,  470, 1468, 1239, 1173,  496,  116, 1329, 1218, 1316,
 /*   550 */     6,  222, 1056, 1076, 1077, 1103, 1104, 1105, 1106, 1107,
 /*   560 */  1108, 1109, 1110,  220,  493,  492,  491,   21,  490, 1123,
 /*   570 */   161,  437,   23,  160,  843, 1238,  142,   32,   31,   29,
 /*   580 */    27,   26,   32,   31,   29,   27,   26, 1127, 1468,  115,
 /*   590 */   367, 1325, 1213,  152, 1272, 1327,  125, 1343,  498,  463,
 /*   600 */   463,  282,  365,  397,  361,  357,  353,  151, 1337,  460,
 /*   610 */  1387,   24,  264, 1117, 1118, 1119, 1120, 1121, 1125, 1126,
 /*   620 */  1468, 1422, 1323,  169, 1340, 1340,  297,  276,  447,  463,
 /*   630 */   273,  272, 1608,   53, 1608,  115,  149, 1237,  461,   67,
 /*   640 */  1065,  299, 1497, 1342, 1457,  131,  383,  131,  377, 1606,
 /*   650 */   163, 1606,  382,  162, 1340,   97, 1058,  378,  376, 1212,
 /*   660 */   379,   32,   31,   29,   27,   26, 1514,   48,   47,  309,
 /*   670 */  1387,  136,  405,  446,  512, 1057,  303, 1157,  300, 1259,
 /*   680 */   289, 1386, 1468,  449,  246, 1497,  295, 1468,  291,  287,
 /*   690 */   133, 1154,  434,  148,  279,  121,  106,  145, 1497, 1236,
 /*   700 */   409,  384,  115,   68, 1498, 1499, 1503, 1547,  488, 1514,
 /*   710 */  1342,  240, 1543,  132,  143,  464,  433,   32,   31,   29,
 /*   720 */    27,   26, 1514, 1608, 1091,  395,  449, 1061,  463,  446,
 /*   730 */  1468, 1235, 1234, 1299,  441,  438,  131,  208,  393,  449,
 /*   740 */  1606, 1497,  463, 1468, 1468, 1231,   69, 1498, 1499, 1503,
 /*   750 */  1547,  280, 1387, 1340,  259, 1543,  126, 1254,  278,  119,
 /*   760 */  1498, 1499, 1503, 1385, 1066, 1514,  547, 1340,  190,  436,
 /*   770 */   430, 1233,  433, 1230,  413, 1574, 1468, 1468, 1060,  386,
 /*   780 */   213, 1069,  449,   95, 1052, 1252, 1468, 1229, 1228,  536,
 /*   790 */  1468,  532,  528,  524,  212,  100, 1227,   44, 1622, 1226,
 /*   800 */  1050, 1180,   69, 1498, 1499, 1503, 1547,  389,  191,  178,
 /*   810 */   259, 1543,  126,  180,  434, 1225, 1224,  418, 1468, 1057,
 /*   820 */    66, 1223,   33,  206, 1497,   33, 1129, 1059,   98, 1087,
 /*   830 */   343, 1575, 1468, 1468, 1488, 1381,  404,   64,  187, 1554,
 /*   840 */   429, 1468,  428,  114, 1468, 1608, 1486,   61, 1514, 1063,
 /*   850 */    44, 1497,   33,  459,  921,  446, 1019,  366,  131,  544,
 /*   860 */  1468, 1468, 1606,  184, 1577,  449, 1468,  439,  442, 1468,
 /*   870 */   197, 1051,   94,  104,  199, 1514,  455,  205, 1497,  106,
 /*   880 */  1515,  412,  446,  926,  171,   69, 1498, 1499, 1503, 1547,
 /*   890 */   431,    2,  449,  259, 1543, 1620, 1468,  193, 1062, 1036,
 /*   900 */  1072,  168, 1514,  468, 1581,  869,  104,  954, 1053,  446,
 /*   910 */   958,  284,   69, 1498, 1499, 1503, 1547,  288,  245,  449,
 /*   920 */   259, 1543, 1620, 1468,  870, 1056,  105,  895, 1497,  247,
 /*   930 */   964, 1604,  106,  104, 1028,  214,  963,  107,  321,   69,
 /*   940 */  1498, 1499, 1503, 1547, 1420,  138,  328,  259, 1543, 1620,
 /*   950 */   336,  335, 1514, 1497,  337, 1083,  341,  342, 1565,  446,
 /*   960 */  1082,  344,  144, 1081,  345,  346, 1080,  147,   51,  449,
 /*   970 */   349,  150,  368, 1468,  398,  399,  370, 1514,  434, 1330,
 /*   980 */  1497,  154,  411,  400,  446, 1326,  255,   74,  401,  228,
 /*   990 */  1498, 1499, 1503,  156,  449,  373,  109,  408, 1468,  110,
 /*  1000 */  1328, 1324,  111,  112, 1514, 1079, 1497,  170,  173, 1608,
 /*  1010 */   419,  446, 1588,  410,   70, 1498, 1499, 1503, 1547,  453,
 /*  1020 */  1057,  449,  131, 1544,    5, 1468, 1606, 1578,  183,  176,
 /*  1030 */  1514,  416, 1497, 1587,  179, 1568,  258,  446,  422,  427,
 /*  1040 */  1497,   70, 1498, 1499, 1503, 1547,  415,  449, 1154,  444,
 /*  1050 */  1543, 1468,    4,   99,  414, 1078, 1514, 1562,   34,  260,
 /*  1060 */   443,  186,  440,  446, 1514,   17, 1429,  233, 1498, 1499,
 /*  1070 */  1503,  446,  124,  449, 1497, 1529,  451, 1468,  185,  452,
 /*  1080 */   456,  449,  203, 1428,  268, 1468,  201, 1497,  263,   58,
 /*  1090 */   457,  458, 1341,  232, 1498, 1499, 1503, 1623, 1514, 1497,
 /*  1100 */   192,  233, 1498, 1499, 1503,  446, 1605,  466,  215, 1313,
 /*  1110 */    60, 1514,  495,  217,  211,  449,  543,   40,  446, 1468,
 /*  1120 */   219,  223,  267, 1514,  224,  426,  221, 1462,  449, 1461,
 /*  1130 */   446,  283, 1468, 1497, 1458,  233, 1498, 1499, 1503,  285,
 /*  1140 */   449,  286, 1046, 1047, 1468,  134,  290, 1456,  225, 1498,
 /*  1150 */  1499, 1503,  292,  293,  294, 1455,  296, 1514, 1454, 1497,
 /*  1160 */   231, 1498, 1499, 1503,  446, 1445,  298,  135,  301,  302,
 /*  1170 */  1031, 1030, 1439, 1438,  449,  307,  308, 1437, 1468,  103,
 /*  1180 */  1002, 1413, 1412, 1514, 1436, 1497, 1411, 1410, 1409, 1408,
 /*  1190 */   446, 1407, 1406, 1405,  234, 1498, 1499, 1503, 1404, 1403,
 /*  1200 */   449, 1402, 1401, 1400, 1468, 1004, 1391, 1390, 1389, 1514,
 /*  1210 */  1497, 1399, 1398, 1397, 1396, 1395,  446, 1394, 1393, 1392,
 /*  1220 */   226, 1498, 1499, 1503, 1388, 1271,  449, 1453, 1447, 1435,
 /*  1230 */  1468, 1426, 1319,  146, 1514, 1497,  862, 1270, 1268,  352,
 /*  1240 */  1266,  446,  350,  356, 1497,  351,  235, 1498, 1499, 1503,
 /*  1250 */  1264,  449, 1262,  360,  354, 1468,  355,  359, 1251, 1514,
 /*  1260 */   358,  362,  363, 1250, 1247, 1321,  446,  969, 1514, 1320,
 /*  1270 */  1260,  227, 1498, 1499, 1503,  446,  449,  364,   73, 1497,
 /*  1280 */  1468,  971,  894,  252,  893,  449,  892,  891, 1255, 1468,
 /*  1290 */   253,  888,  887, 1253,  387,  254,  236, 1498, 1499, 1503,
 /*  1300 */   390, 1246,  392, 1514,  512, 1511, 1498, 1499, 1503, 1245,
 /*  1310 */   446,  153,  510, 1497,  394,   71, 1452,  167,   43, 1038,
 /*  1320 */   449, 1446,  113, 1434, 1468,  402, 1433, 1425,  172,   14,
 /*  1330 */    54,    3,  403, 1486,  177,   37,   35, 1514,   33,   15,
 /*  1340 */  1510, 1498, 1499, 1503,  446,   38, 1179, 1497,   10,  120,
 /*  1350 */   181,   19,  188, 1172,  449,  182, 1497,   55, 1468,   56,
 /*  1360 */    20, 1151, 1497, 1201,    8, 1150, 1206,   36,  130,  174,
 /*  1370 */   123, 1514, 1200,   16,  243, 1498, 1499, 1503,  446,  261,
 /*  1380 */  1514, 1315, 1205, 1204,  262,  195, 1514,  446,  449, 1089,
 /*  1390 */  1497,   13, 1468,  446, 1088,  196,   18,  449, 1424, 1177,
 /*  1400 */   202, 1468, 1115,  449,  198,  200,   45, 1468, 1509, 1498,
 /*  1410 */  1499, 1503,   57,   61, 1514,  454, 1497,  244, 1498, 1499,
 /*  1420 */  1503,  446, 1485,  242, 1498, 1499, 1503,  204,  207, 1067,
 /*  1430 */    39,  449,  465,  955,  467, 1468,  952,  275,  469,  471,
 /*  1440 */  1514,  472,  209,  949,  474,  475,  494,  446,  943,  477,
 /*  1450 */   478,  239, 1498, 1499, 1503,  941,  480,  449,  481,  947,
 /*  1460 */   932, 1468,  946,   62,  945,  944,  487,  966,  496,   46,
 /*  1470 */   962,   63,  960,  860,  497,  499,  901,  230, 1498, 1499,
 /*  1480 */  1503,  965,  883,  210,  882,  881,  880,  493,  492,  491,
 /*  1490 */   879,  490,  878,  877,  876,  896,  898,  873,  872,  871,
 /*  1500 */   868,  867,  866,  865, 1267,  521,  522, 1265, 1263,  523,
 /*  1510 */   526,  525,  527,  529,  530, 1261,  534,  533, 1249,  531,
 /*  1520 */   535,  537,  538, 1248, 1244,  541,  542, 1219, 1054, 1219,
 /*  1530 */   546,  218,  545,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   217,  277,  278,  219,  239,  261,  211,    1,    2,  226,
 /*    10 */   244,    4,   12,   13,  217,  239,  233,  251,  252,  227,
 /*    20 */    20,  256,   22,  226,  240,  242,   19,  235,   20,  256,
 /*    30 */   235,  211,  256,  268,  269,  243,  292,  242,   38,  242,
 /*    40 */    33,  268,  269,   36,  268,  269,   20,  252,   41,  305,
 /*    50 */    50,  256,  217,  309,   47,  235,  217,   57,   14,   15,
 /*    60 */    16,   49,  242,   12,   13,   14,  217,  272,  273,  274,
 /*    70 */   275,   20,  252,   22,   74,  226,  256,   12,   13,  259,
 /*    80 */    73,   75,  233,   76,   20,   20,  247,   22,  211,   38,
 /*    90 */   211,  242,  272,  273,  274,  275,  261,   97,  214,  215,
 /*   100 */    20,   50,   20,   38,  252,  310,  311,  255,   57,  109,
 /*   110 */   258,  217,  235,  221,  222,   50,   12,   13,  217,  242,
 /*   120 */   226,  210,   57,  212,   20,   74,   22,  292,  292,  252,
 /*   130 */   221,  222,  211,  256,  217,  256,  242,  132,   74,   74,
 /*   140 */   305,  305,   38,  242,  309,  309,  146,    0,   97,  272,
 /*   150 */   273,  274,  275,  276,  136,  150,   74,  280,  281,  242,
 /*   160 */   109,   57,   97,  163,  164,  165,  166,  167,  168,  169,
 /*   170 */   170,  171,  172,  173,  109,  217,  275,  256,   74,  174,
 /*   180 */   211,   12,   13,   14,  226,  185,  285,  286,  287,   20,
 /*   190 */   289,   22,  275,  185,  220,  185,   49,  146,  224,  235,
 /*   200 */   242,   97,  285,  286,  287,  241,  289,   38,  190,  191,
 /*   210 */   246,  146,   20,  109,  163,  164,  165,  166,  167,  168,
 /*   220 */   169,  170,  171,  172,  173,  256,   57,    0,  163,  164,
 /*   230 */   165,  166,  167,  168,  169,  170,  171,  172,  173,  145,
 /*   240 */    20,  147,   22,   74,  164,  165,    1,    2,   21,  185,
 /*   250 */   146,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   260 */    40,   12,   13,   14,   15,   16,   97,  163,  164,  165,
 /*   270 */   166,  167,  168,  169,  170,  171,  172,  173,  109,  185,
 /*   280 */    20,  242,  219,   12,   13,   18,  216,   20,  249,  185,
 /*   290 */    52,   20,   54,   22,   27,  232,   58,   30,  211,   61,
 /*   300 */   230,   63,   64,  240,   66,  228,   39,  237,  231,   38,
 /*   310 */    12,   13,   14,   15,   16,  146,   21,  183,  184,   24,
 /*   320 */    25,   26,   27,   28,   29,   30,   31,   32,   57,    0,
 /*   330 */    67,  163,  163,  164,  165,  166,  167,  168,  169,  170,
 /*   340 */   171,  172,  173,  256,   20,   74,   61,   50,   50,   47,
 /*   350 */    65,   38,   49,   24,   25,   26,   27,   28,   29,   30,
 /*   360 */    31,   32,  194,  195,  196,  197,  198,  223,   97,  225,
 /*   370 */    57,   20,   87,   75,   35,   73,  113,  114,   76,  112,
 /*   380 */   109,   83,  115,  116,  117,  118,  119,  217,  121,  122,
 /*   390 */   123,  124,  125,  126,  127,  128,  129,  130,  131,  217,
 /*   400 */    61,   12,   13,   85,   65,  270,  217,  252,  226,   20,
 /*   410 */   270,   22,  242,  258,  235,  226,   77,  146,   79,   80,
 /*   420 */   241,   82,  235,  288,  242,  246,   87,   38,  288,  242,
 /*   430 */   132,  242,  164,  165,  163,  164,  165,  166,  167,  168,
 /*   440 */   169,  170,  171,  172,  173,  275,   57,    0,  150,   12,
 /*   450 */    13,   14,   15,   16,  284,  285,  286,  287,    0,  289,
 /*   460 */   163,  274,  138,   74,   20,   12,   13,   14,   15,   16,
 /*   470 */   270,  216,  174,  175,  176,  177,  178,  179,  180,  181,
 /*   480 */   182,   12,   13,   14,   15,   16,   97,   50,  288,  138,
 /*   490 */    14,   78,  237,  234,   81,    4,   20,  211,  109,   52,
 /*   500 */    53,   54,   55,   56,  245,   58,   59,   60,   61,   62,
 /*   510 */    63,   64,   65,   66,   67,   68,   69,   70,   78,   61,
 /*   520 */    83,   81,   57,   65,   88,   89,   90,   91,   92,   93,
 /*   530 */    94,   95,   96,   97,   98,  146,  100,  101,  102,  103,
 /*   540 */   104,  105,  256,  211,   75,   87,   18,  236,  208,    0,
 /*   550 */    43,   23,  163,  164,  165,  166,  167,  168,  169,  170,
 /*   560 */   171,  172,  173,   35,  106,  107,  108,    2,  110,  132,
 /*   570 */    78,    3,    2,   81,   22,  211,   48,   12,   13,   14,
 /*   580 */    15,   16,   12,   13,   14,   15,   16,  150,  256,  235,
 /*   590 */    38,  236,  139,   33,    0,  236,   36,  243,   49,  217,
 /*   600 */   217,  261,   42,  261,   44,   45,   46,   47,  226,  226,
 /*   610 */   235,  174,  175,  176,  177,  178,  179,  180,  181,  182,
 /*   620 */   256,  246,  236,  236,  242,  242,  142,  227,  236,  217,
 /*   630 */    12,   13,  292,   73,  292,  235,   76,  211,  226,  111,
 /*   640 */    22,  157,  211,  243,    0,  305,   52,  305,   54,  309,
 /*   650 */    78,  309,   58,   81,  242,   61,   38,   63,   64,  206,
 /*   660 */    66,   12,   13,   14,   15,   16,  235,  139,  140,  141,
 /*   670 */   235,  143,  264,  242,   71,   57,  148,  186,   75,    0,
 /*   680 */    36,  246,  256,  252,  156,  211,  158,  256,  160,  161,
 /*   690 */   162,  184,  261,  133,  227,  135,   71,  137,  211,  211,
 /*   700 */    75,   22,  235,  272,  273,  274,  275,  276,  236,  235,
 /*   710 */   243,  280,  281,  185,  154,   97,  242,   12,   13,   14,
 /*   720 */    15,   16,  235,  292,   75,   21,  252,  109,  217,  242,
 /*   730 */   256,  211,  211,  224,   71,   71,  305,  226,   34,  252,
 /*   740 */   309,  211,  217,  256,  256,  211,  272,  273,  274,  275,
 /*   750 */   276,  226,  235,  242,  280,  281,  282,    0,  241,  272,
 /*   760 */   273,  274,  275,  246,  146,  235,   19,  242,  294,  201,
 /*   770 */   217,  212,  242,  211,  300,  301,  256,  256,   38,   22,
 /*   780 */    33,  163,  252,   36,   22,    0,  256,  211,  211,   42,
 /*   790 */   256,   44,   45,   46,   47,  242,  211,   71,  311,  211,
 /*   800 */    38,   75,  272,  273,  274,  275,  276,   22,  312,   71,
 /*   810 */   280,  281,  282,   75,  261,  211,  211,  303,  256,   57,
 /*   820 */    73,  211,   71,   76,  211,   71,   75,   38,  275,   75,
 /*   830 */   252,  301,  256,  256,   74,  245,  252,   74,  285,  286,
 /*   840 */   287,  256,  289,  138,  256,  292,   86,   84,  235,  109,
 /*   850 */    71,  211,   71,  106,   75,  242,   75,  214,  305,   97,
 /*   860 */   256,  256,  309,  297,  271,  252,  256,  203,  205,  256,
 /*   870 */    71,  109,   71,   71,   75,  235,   75,   75,  211,   71,
 /*   880 */   235,  134,  242,   75,  137,  272,  273,  274,  275,  276,
 /*   890 */   290,  293,  252,  280,  281,  282,  256,  306,  109,  152,
 /*   900 */    20,  154,  235,   71,  291,   38,   71,   75,  146,  242,
 /*   910 */    75,  217,  272,  273,  274,  275,  276,   36,  267,  252,
 /*   920 */   280,  281,  282,  256,   57,  163,   71,   38,  211,  221,
 /*   930 */    75,  291,   71,   71,  144,  262,   75,   75,  217,  272,
 /*   940 */   273,  274,  275,  276,  217,  120,  250,  280,  281,  282,
 /*   950 */   132,  248,  235,  211,  248,   20,  217,  266,  291,  242,
 /*   960 */    20,  260,  219,   20,  242,  253,   20,  219,  219,  252,
 /*   970 */   217,  219,  213,  256,  242,  266,  235,  235,  261,  235,
 /*   980 */   211,  235,  253,  153,  242,  235,  213,  217,  265,  272,
 /*   990 */   273,  274,  275,  235,  252,  221,  235,  260,  256,  235,
 /*  1000 */   235,  235,  235,  235,  235,   20,  211,  216,  216,  292,
 /*  1010 */   193,  242,  302,  242,  272,  273,  274,  275,  276,  192,
 /*  1020 */    57,  252,  305,  281,  200,  256,  309,  271,  298,  257,
 /*  1030 */   235,  256,  211,  302,  257,  299,  256,  242,  256,  199,
 /*  1040 */   211,  272,  273,  274,  275,  276,  188,  252,  184,  280,
 /*  1050 */   281,  256,  187,  242,  259,   20,  235,  270,  120,  207,
 /*  1060 */   204,  283,  202,  242,  235,   74,  257,  272,  273,  274,
 /*  1070 */   275,  242,  296,  252,  211,  279,  256,  256,  295,  256,
 /*  1080 */   135,  252,  216,  257,  256,  256,  242,  211,  259,  216,
 /*  1090 */   254,  253,  242,  272,  273,  274,  275,  313,  235,  211,
 /*  1100 */   307,  272,  273,  274,  275,  242,  308,  238,  231,  225,
 /*  1110 */    74,  235,  221,  217,  216,  252,  213,  263,  242,  256,
 /*  1120 */   218,  229,  259,  235,  229,  304,  209,    0,  252,    0,
 /*  1130 */   242,   64,  256,  211,    0,  272,  273,  274,  275,   38,
 /*  1140 */   252,  159,   38,   38,  256,   38,  159,    0,  272,  273,
 /*  1150 */   274,  275,   38,   38,  159,    0,   38,  235,    0,  211,
 /*  1160 */   272,  273,  274,  275,  242,    0,   38,   74,  150,  149,
 /*  1170 */   109,  146,    0,    0,  252,   53,  142,    0,  256,  120,
 /*  1180 */    86,    0,    0,  235,    0,  211,    0,    0,    0,    0,
 /*  1190 */   242,    0,    0,    0,  272,  273,  274,  275,    0,    0,
 /*  1200 */   252,    0,    0,    0,  256,   22,    0,    0,    0,  235,
 /*  1210 */   211,    0,    0,    0,    0,    0,  242,    0,    0,    0,
 /*  1220 */   272,  273,  274,  275,    0,    0,  252,    0,    0,    0,
 /*  1230 */   256,    0,    0,   43,  235,  211,   51,    0,    0,   43,
 /*  1240 */     0,  242,   38,   43,  211,   36,  272,  273,  274,  275,
 /*  1250 */     0,  252,    0,   43,   38,  256,   36,   36,    0,  235,
 /*  1260 */    38,   38,   36,    0,    0,    0,  242,   22,  235,    0,
 /*  1270 */     0,  272,  273,  274,  275,  242,  252,   43,   83,  211,
 /*  1280 */   256,   38,   38,   22,   38,  252,   38,   38,    0,  256,
 /*  1290 */    22,   38,   38,    0,   39,   22,  272,  273,  274,  275,
 /*  1300 */    38,    0,   22,  235,   71,  272,  273,  274,  275,    0,
 /*  1310 */   242,   81,   71,  211,   22,   20,    0,  155,  138,   38,
 /*  1320 */   252,    0,  151,    0,  256,   22,    0,    0,   43,  189,
 /*  1330 */    74,   71,  138,   86,   75,  138,  183,  235,   71,  189,
 /*  1340 */   272,  273,  274,  275,  242,   71,   75,  211,  189,   74,
 /*  1350 */    74,   74,   86,   75,  252,   71,  211,   74,  256,    4,
 /*  1360 */    71,   75,  211,   38,    2,   75,   75,   71,   86,  133,
 /*  1370 */   135,  235,   38,   71,  272,  273,  274,  275,  242,   38,
 /*  1380 */   235,    0,   38,   38,   38,   86,  235,  242,  252,   75,
 /*  1390 */   211,   74,  256,  242,   75,   75,   74,  252,    0,   75,
 /*  1400 */    43,  256,  163,  252,   74,   74,   74,  256,  272,  273,
 /*  1410 */   274,  275,   74,   84,  235,  136,  211,  272,  273,  274,
 /*  1420 */   275,  242,   86,  272,  273,  274,  275,  133,   86,   22,
 /*  1430 */    74,  252,   85,   75,   38,  256,   75,   38,   74,   38,
 /*  1440 */   235,   74,   61,   75,   38,   74,   65,  242,   75,   38,
 /*  1450 */    74,  272,  273,  274,  275,   75,   38,  252,   74,   99,
 /*  1460 */    22,  256,   99,   74,   99,   99,   87,   38,   87,   74,
 /*  1470 */    38,   74,   22,   51,   50,   72,   57,  272,  273,  274,
 /*  1480 */   275,  109,   38,   71,   38,   38,   38,  106,  107,  108,
 /*  1490 */    38,  110,   38,   38,   22,   38,   57,   38,   38,   38,
 /*  1500 */    38,   38,   38,   38,    0,   38,   36,    0,    0,   43,
 /*  1510 */    36,   38,   43,   38,   36,    0,   36,   38,    0,   43,
 /*  1520 */    43,   38,   37,    0,    0,   22,   21,  314,   22,  314,
 /*  1530 */    20,   22,   21,  314,  314,  314,  314,  314,  314,  314,
 /*  1540 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1550 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1560 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1570 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1580 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1590 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1600 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1610 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1620 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1630 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1640 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1650 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1660 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1670 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1680 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1690 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1700 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1710 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1720 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1730 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*  1740 */   314,
};
#define YY_SHIFT_COUNT    (547)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1524)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   528,    0,   51,   65,   65,   65,   65,  104,   65,   65,
 /*    10 */   271,  389,   64,  169,  271,  271,  271,  271,  271,  271,
 /*    20 */   271,  271,  271,  271,  271,  271,  271,  271,  271,  271,
 /*    30 */   271,  271,  271,  271,   82,   82,   82,    8,  618,  618,
 /*    40 */    94,   26,   26,   10,  618,   80,   80,   26,   26,   26,
 /*    50 */    26,   26,   26,   12,  192,  260,   10,  192,   26,   26,
 /*    60 */   192,   26,  192,  192,  192,   26,  303,  267,  298,  437,
 /*    70 */   437,  295,  339,  762,  238,  762,  762,  762,  762,  762,
 /*    80 */   762,  762,  762,  762,  762,  762,  762,  762,  762,  762,
 /*    90 */   762,  762,  762,  762,   80,  220,  147,  313,  324,  324,
 /*   100 */   324,  549,  313,  444,  192,  192,  192,  318,  465,  436,
 /*   110 */   436,  436,  436,  436,  436,  436,  747,  227,  594,  453,
 /*   120 */   168,   80,  285,   80,   18,  552,  351,  134,  507,  134,
 /*   130 */   476,  568,  491,  880,  881,  889,  790,  880,  880,  825,
 /*   140 */   818,  818,  880,  935,  940,   12,  444,  943,   12,   12,
 /*   150 */   880,   12,  946,  192,  192,  192,  192,  192,  192,  192,
 /*   160 */   192,  192,  192,  192,  889,  880,  946,  444,  935,  830,
 /*   170 */   940,  303,  444,  943,  303,  985,  817,  827,  963,  817,
 /*   180 */   827,  963,  963,  824,  840,  858,  865,  864,  444, 1035,
 /*   190 */   938,  852,  856,  860,  991,  192,  827,  963,  963,  827,
 /*   200 */   963,  945,  444,  943,  303,  318,  303,  444, 1036,  889,
 /*   210 */   465,  880,  303,  946, 1533, 1533, 1533, 1533, 1533,  447,
 /*   220 */   560,  329,    7,  458, 1381,  469,  565,  570,  649,  705,
 /*   230 */   249,  249,  249,  249,  249,  249,  249,  302,  263,   44,
 /*   240 */     6,    5,   44,   44,   44,  644,  484,  603,  413,  440,
 /*   250 */   492,  572,  679,  757,  785,  704,  625,  726,  738,  245,
 /*   260 */   268,  664,  663,  751,  297,  754,  760,  781,  799,  801,
 /*   270 */   802,  808,  740,  789,  779,  832,  835,  855,  861,  862,
 /*   280 */   763,  867, 1127, 1129, 1067, 1134, 1101,  982, 1104, 1105,
 /*   290 */  1107,  987, 1147, 1114, 1115,  995, 1155, 1118, 1158, 1128,
 /*   300 */  1165, 1093, 1018, 1020, 1061, 1025, 1172, 1173, 1122, 1034,
 /*   310 */  1177, 1184, 1094, 1181, 1182, 1186, 1187, 1188, 1189, 1191,
 /*   320 */  1192, 1193, 1198, 1199, 1201, 1202, 1203, 1211, 1212, 1059,
 /*   330 */  1213, 1214, 1215, 1217, 1218, 1219, 1183, 1206, 1207, 1208,
 /*   340 */  1224, 1225, 1227, 1228, 1229, 1231, 1190, 1232, 1185, 1237,
 /*   350 */  1238, 1204, 1209, 1196, 1240, 1216, 1220, 1200, 1250, 1222,
 /*   360 */  1221, 1210, 1252, 1223, 1226, 1234, 1258, 1263, 1264, 1265,
 /*   370 */  1195, 1230, 1243, 1233, 1245, 1269, 1244, 1246, 1248, 1249,
 /*   380 */  1241, 1233, 1253, 1254, 1270, 1261, 1288, 1268, 1255, 1293,
 /*   390 */  1273, 1262, 1301, 1280, 1309, 1292, 1295, 1316, 1180, 1162,
 /*   400 */  1281, 1321, 1171, 1303, 1194, 1235, 1323, 1326, 1197, 1327,
 /*   410 */  1256, 1285, 1236, 1260, 1267, 1140, 1259, 1274, 1271, 1275,
 /*   420 */  1276, 1277, 1278, 1284, 1247, 1283, 1289, 1150, 1286, 1290,
 /*   430 */  1266, 1153, 1296, 1282, 1291, 1302, 1159, 1355, 1325, 1334,
 /*   440 */  1341, 1344, 1345, 1346, 1362, 1239, 1299, 1314, 1319, 1317,
 /*   450 */  1322, 1320, 1324, 1330, 1331, 1279, 1332, 1398, 1357, 1294,
 /*   460 */  1338, 1329, 1336, 1342, 1407, 1356, 1347, 1358, 1396, 1399,
 /*   470 */  1364, 1361, 1401, 1367, 1368, 1406, 1371, 1373, 1411, 1376,
 /*   480 */  1380, 1418, 1384, 1360, 1363, 1365, 1366, 1438, 1379, 1389,
 /*   490 */  1429, 1372, 1395, 1397, 1432, 1233, 1450, 1422, 1424, 1419,
 /*   500 */  1403, 1412, 1444, 1446, 1447, 1448, 1452, 1454, 1455, 1472,
 /*   510 */  1439, 1241, 1457, 1233, 1459, 1460, 1461, 1462, 1463, 1464,
 /*   520 */  1465, 1504, 1467, 1470, 1466, 1507, 1473, 1474, 1469, 1508,
 /*   530 */  1475, 1478, 1476, 1515, 1479, 1480, 1477, 1518, 1483, 1485,
 /*   540 */  1523, 1524, 1503, 1505, 1506, 1509, 1511, 1510,
};
#define YY_REDUCE_COUNT (218)
#define YY_REDUCE_MIN   (-276)
#define YY_REDUCE_MAX   (1205)
static const short yy_reduce_ofst[] = {
 /*     0 */   340,  431,  474,  530,  613,  640,  667,  717, -123,  769,
 /*    10 */  -205,  742,  553, -180,  795,  821,  487,  829,  863,  876,
 /*    20 */   888,  922,  948,  974,  999, 1024, 1033, 1068, 1102, 1136,
 /*    30 */  1145, 1151, 1179, 1205,  170,  -99,  -83, -165, -235, -224,
 /*    40 */  -256, -217, -151,  342, -227, -148, -234, -203, -106,  -42,
 /*    50 */   182,  189,  382,   63,  -36,  187, -164, -208,  383,  412,
 /*    60 */   179,  511,  400,  517,  467,  525,   70, -161, -276, -276,
 /*    70 */  -276,  -89,  259, -121,  -26,  -79,  -31,   87,  286,  332,
 /*    80 */   364,  426,  488,  520,  521,  534,  562,  576,  577,  585,
 /*    90 */   588,  604,  605,  610,  155, -116, -216, -108,  135,  140,
 /*   100 */   200,  255,  -91,   39,  354,  375,  435,   77,  144,  311,
 /*   110 */   355,  359,  386,  387,  392,  472,  408,  559,  509,  496,
 /*   120 */   514,  578,  590,  584,  566,  643,  593,  600,  600,  600,
 /*   130 */   645,  591,  598,  694,  651,  708,  673,  721,  727,  696,
 /*   140 */   703,  706,  739,  691,  701,  743,  722,  712,  748,  749,
 /*   150 */   753,  752,  759,  741,  744,  746,  750,  758,  761,  764,
 /*   160 */   765,  766,  767,  768,  774,  770,  773,  732,  709,  723,
 /*   170 */   737,  791,  771,  729,  792,  756,  710,  772,  775,  731,
 /*   180 */   777,  780,  782,  736,  730,  776,  783,  600,  811,  787,
 /*   190 */   778,  784,  798,  793,  796,  645,  809,  820,  823,  826,
 /*   200 */   828,  836,  844,  838,  866,  877,  873,  850,  869,  891,
 /*   210 */   884,  896,  898,  903,  854,  892,  895,  902,  917,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*    10 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*    20 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*    30 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*    40 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*    50 */  1217, 1217, 1217, 1276, 1217, 1217, 1217, 1217, 1217, 1217,
 /*    60 */  1217, 1217, 1217, 1217, 1217, 1217, 1274, 1414, 1217, 1549,
 /*    70 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*    80 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*    90 */  1217, 1217, 1217, 1217, 1217, 1217, 1276, 1217, 1560, 1560,
 /*   100 */  1560, 1274, 1217, 1217, 1217, 1217, 1217, 1369, 1217, 1217,
 /*   110 */  1217, 1217, 1217, 1217, 1217, 1217, 1448, 1217, 1217, 1624,
 /*   120 */  1217, 1217, 1322, 1217, 1584, 1217, 1576, 1552, 1566, 1553,
 /*   130 */  1217, 1609, 1569, 1217, 1217, 1217, 1440, 1217, 1217, 1419,
 /*   140 */  1416, 1416, 1217, 1217, 1217, 1276, 1217, 1217, 1276, 1276,
 /*   150 */  1217, 1276, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   160 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1450,
 /*   170 */  1217, 1274, 1217, 1217, 1274, 1217, 1591, 1589, 1217, 1591,
 /*   180 */  1589, 1217, 1217, 1603, 1599, 1582, 1580, 1566, 1217, 1217,
 /*   190 */  1217, 1627, 1615, 1611, 1217, 1217, 1589, 1217, 1217, 1589,
 /*   200 */  1217, 1427, 1217, 1217, 1274, 1217, 1274, 1217, 1338, 1217,
 /*   210 */  1217, 1217, 1274, 1217, 1442, 1372, 1372, 1277, 1222, 1217,
 /*   220 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1512,
 /*   230 */  1513, 1602, 1601, 1512, 1526, 1525, 1524, 1217, 1217, 1507,
 /*   240 */  1217, 1217, 1508, 1506, 1505, 1217, 1217, 1217, 1217, 1217,
 /*   250 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1550,
 /*   260 */  1217, 1612, 1616, 1217, 1217, 1217, 1487, 1217, 1217, 1217,
 /*   270 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   280 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   290 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   300 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   310 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   320 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   330 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   340 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   350 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   360 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   370 */  1217, 1217, 1217, 1383, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   380 */  1303, 1302, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   390 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   400 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   410 */  1217, 1217, 1217, 1573, 1583, 1217, 1217, 1217, 1217, 1217,
 /*   420 */  1217, 1217, 1217, 1217, 1487, 1217, 1600, 1217, 1559, 1555,
 /*   430 */  1217, 1217, 1551, 1217, 1217, 1610, 1217, 1217, 1217, 1217,
 /*   440 */  1217, 1217, 1217, 1217, 1545, 1217, 1217, 1217, 1217, 1217,
 /*   450 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   460 */  1217, 1217, 1486, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   470 */  1366, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   480 */  1217, 1217, 1217, 1351, 1349, 1348, 1347, 1217, 1344, 1217,
 /*   490 */  1217, 1217, 1217, 1217, 1217, 1374, 1217, 1217, 1217, 1217,
 /*   500 */  1217, 1297, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   510 */  1217, 1288, 1217, 1287, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   520 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   530 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
 /*   540 */  1217, 1217, 1217, 1217, 1217, 1217, 1217, 1217,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "DNODE",
  /*   37 */ "PORT",
  /*   38 */ "NK_INTEGER",
  /*   39 */ "DNODES",
  /*   40 */ "NK_IPTOKEN",
  /*   41 */ "LOCAL",
  /*   42 */ "QNODE",
  /*   43 */ "ON",
  /*   44 */ "BNODE",
  /*   45 */ "SNODE",
  /*   46 */ "MNODE",
  /*   47 */ "DATABASE",
  /*   48 */ "USE",
  /*   49 */ "IF",
  /*   50 */ "NOT",
  /*   51 */ "EXISTS",
  /*   52 */ "BLOCKS",
  /*   53 */ "CACHE",
  /*   54 */ "CACHELAST",
  /*   55 */ "COMP",
  /*   56 */ "DAYS",
  /*   57 */ "NK_VARIABLE",
  /*   58 */ "FSYNC",
  /*   59 */ "MAXROWS",
  /*   60 */ "MINROWS",
  /*   61 */ "KEEP",
  /*   62 */ "PRECISION",
  /*   63 */ "QUORUM",
  /*   64 */ "REPLICA",
  /*   65 */ "TTL",
  /*   66 */ "WAL",
  /*   67 */ "VGROUPS",
  /*   68 */ "SINGLE_STABLE",
  /*   69 */ "STREAM_MODE",
  /*   70 */ "RETENTIONS",
  /*   71 */ "NK_COMMA",
  /*   72 */ "NK_COLON",
  /*   73 */ "TABLE",
  /*   74 */ "NK_LP",
  /*   75 */ "NK_RP",
  /*   76 */ "STABLE",
  /*   77 */ "ADD",
  /*   78 */ "COLUMN",
  /*   79 */ "MODIFY",
  /*   80 */ "RENAME",
  /*   81 */ "TAG",
  /*   82 */ "SET",
  /*   83 */ "NK_EQ",
  /*   84 */ "USING",
  /*   85 */ "TAGS",
  /*   86 */ "NK_DOT",
  /*   87 */ "COMMENT",
  /*   88 */ "BOOL",
  /*   89 */ "TINYINT",
  /*   90 */ "SMALLINT",
  /*   91 */ "INT",
  /*   92 */ "INTEGER",
  /*   93 */ "BIGINT",
  /*   94 */ "FLOAT",
  /*   95 */ "DOUBLE",
  /*   96 */ "BINARY",
  /*   97 */ "TIMESTAMP",
  /*   98 */ "NCHAR",
  /*   99 */ "UNSIGNED",
  /*  100 */ "JSON",
  /*  101 */ "VARCHAR",
  /*  102 */ "MEDIUMBLOB",
  /*  103 */ "BLOB",
  /*  104 */ "VARBINARY",
  /*  105 */ "DECIMAL",
  /*  106 */ "SMA",
  /*  107 */ "ROLLUP",
  /*  108 */ "FILE_FACTOR",
  /*  109 */ "NK_FLOAT",
  /*  110 */ "DELAY",
  /*  111 */ "SHOW",
  /*  112 */ "DATABASES",
  /*  113 */ "TABLES",
  /*  114 */ "STABLES",
  /*  115 */ "MNODES",
  /*  116 */ "MODULES",
  /*  117 */ "QNODES",
  /*  118 */ "FUNCTIONS",
  /*  119 */ "INDEXES",
  /*  120 */ "FROM",
  /*  121 */ "ACCOUNTS",
  /*  122 */ "APPS",
  /*  123 */ "CONNECTIONS",
  /*  124 */ "LICENCE",
  /*  125 */ "GRANTS",
  /*  126 */ "QUERIES",
  /*  127 */ "SCORES",
  /*  128 */ "TOPICS",
  /*  129 */ "VARIABLES",
  /*  130 */ "BNODES",
  /*  131 */ "SNODES",
  /*  132 */ "LIKE",
  /*  133 */ "INDEX",
  /*  134 */ "FULLTEXT",
  /*  135 */ "FUNCTION",
  /*  136 */ "INTERVAL",
  /*  137 */ "TOPIC",
  /*  138 */ "AS",
  /*  139 */ "DESC",
  /*  140 */ "DESCRIBE",
  /*  141 */ "RESET",
  /*  142 */ "QUERY",
  /*  143 */ "EXPLAIN",
  /*  144 */ "ANALYZE",
  /*  145 */ "VERBOSE",
  /*  146 */ "NK_BOOL",
  /*  147 */ "RATIO",
  /*  148 */ "COMPACT",
  /*  149 */ "VNODES",
  /*  150 */ "IN",
  /*  151 */ "OUTPUTTYPE",
  /*  152 */ "AGGREGATE",
  /*  153 */ "BUFSIZE",
  /*  154 */ "STREAM",
  /*  155 */ "INTO",
  /*  156 */ "KILL",
  /*  157 */ "CONNECTION",
  /*  158 */ "MERGE",
  /*  159 */ "VGROUP",
  /*  160 */ "REDISTRIBUTE",
  /*  161 */ "SPLIT",
  /*  162 */ "SYNCDB",
  /*  163 */ "NULL",
  /*  164 */ "FIRST",
  /*  165 */ "LAST",
  /*  166 */ "NOW",
  /*  167 */ "ROWTS",
  /*  168 */ "TBNAME",
  /*  169 */ "QSTARTTS",
  /*  170 */ "QENDTS",
  /*  171 */ "WSTARTTS",
  /*  172 */ "WENDTS",
  /*  173 */ "WDURATION",
  /*  174 */ "BETWEEN",
  /*  175 */ "IS",
  /*  176 */ "NK_LT",
  /*  177 */ "NK_GT",
  /*  178 */ "NK_LE",
  /*  179 */ "NK_GE",
  /*  180 */ "NK_NE",
  /*  181 */ "MATCH",
  /*  182 */ "NMATCH",
  /*  183 */ "JOIN",
  /*  184 */ "INNER",
  /*  185 */ "SELECT",
  /*  186 */ "DISTINCT",
  /*  187 */ "WHERE",
  /*  188 */ "PARTITION",
  /*  189 */ "BY",
  /*  190 */ "SESSION",
  /*  191 */ "STATE_WINDOW",
  /*  192 */ "SLIDING",
  /*  193 */ "FILL",
  /*  194 */ "VALUE",
  /*  195 */ "NONE",
  /*  196 */ "PREV",
  /*  197 */ "LINEAR",
  /*  198 */ "NEXT",
  /*  199 */ "GROUP",
  /*  200 */ "HAVING",
  /*  201 */ "ORDER",
  /*  202 */ "SLIMIT",
  /*  203 */ "SOFFSET",
  /*  204 */ "LIMIT",
  /*  205 */ "OFFSET",
  /*  206 */ "ASC",
  /*  207 */ "NULLS",
  /*  208 */ "cmd",
  /*  209 */ "account_options",
  /*  210 */ "alter_account_options",
  /*  211 */ "literal",
  /*  212 */ "alter_account_option",
  /*  213 */ "user_name",
  /*  214 */ "dnode_endpoint",
  /*  215 */ "dnode_host_name",
  /*  216 */ "not_exists_opt",
  /*  217 */ "db_name",
  /*  218 */ "db_options",
  /*  219 */ "exists_opt",
  /*  220 */ "alter_db_options",
  /*  221 */ "integer_list",
  /*  222 */ "variable_list",
  /*  223 */ "retention_list",
  /*  224 */ "alter_db_option",
  /*  225 */ "retention",
  /*  226 */ "full_table_name",
  /*  227 */ "column_def_list",
  /*  228 */ "tags_def_opt",
  /*  229 */ "table_options",
  /*  230 */ "multi_create_clause",
  /*  231 */ "tags_def",
  /*  232 */ "multi_drop_clause",
  /*  233 */ "alter_table_clause",
  /*  234 */ "alter_table_options",
  /*  235 */ "column_name",
  /*  236 */ "type_name",
  /*  237 */ "create_subtable_clause",
  /*  238 */ "specific_tags_opt",
  /*  239 */ "literal_list",
  /*  240 */ "drop_table_clause",
  /*  241 */ "col_name_list",
  /*  242 */ "table_name",
  /*  243 */ "column_def",
  /*  244 */ "func_name_list",
  /*  245 */ "alter_table_option",
  /*  246 */ "col_name",
  /*  247 */ "db_name_cond_opt",
  /*  248 */ "like_pattern_opt",
  /*  249 */ "table_name_cond",
  /*  250 */ "from_db_opt",
  /*  251 */ "func_name",
  /*  252 */ "function_name",
  /*  253 */ "index_name",
  /*  254 */ "index_options",
  /*  255 */ "func_list",
  /*  256 */ "duration_literal",
  /*  257 */ "sliding_opt",
  /*  258 */ "func",
  /*  259 */ "expression_list",
  /*  260 */ "topic_name",
  /*  261 */ "query_expression",
  /*  262 */ "analyze_opt",
  /*  263 */ "explain_options",
  /*  264 */ "agg_func_opt",
  /*  265 */ "bufsize_opt",
  /*  266 */ "stream_name",
  /*  267 */ "dnode_list",
  /*  268 */ "signed",
  /*  269 */ "signed_literal",
  /*  270 */ "table_alias",
  /*  271 */ "column_alias",
  /*  272 */ "expression",
  /*  273 */ "pseudo_column",
  /*  274 */ "column_reference",
  /*  275 */ "subquery",
  /*  276 */ "predicate",
  /*  277 */ "compare_op",
  /*  278 */ "in_op",
  /*  279 */ "in_predicate_value",
  /*  280 */ "boolean_value_expression",
  /*  281 */ "boolean_primary",
  /*  282 */ "common_expression",
  /*  283 */ "from_clause",
  /*  284 */ "table_reference_list",
  /*  285 */ "table_reference",
  /*  286 */ "table_primary",
  /*  287 */ "joined_table",
  /*  288 */ "alias_opt",
  /*  289 */ "parenthesized_joined_table",
  /*  290 */ "join_type",
  /*  291 */ "search_condition",
  /*  292 */ "query_specification",
  /*  293 */ "set_quantifier_opt",
  /*  294 */ "select_list",
  /*  295 */ "where_clause_opt",
  /*  296 */ "partition_by_clause_opt",
  /*  297 */ "twindow_clause_opt",
  /*  298 */ "group_by_clause_opt",
  /*  299 */ "having_clause_opt",
  /*  300 */ "select_sublist",
  /*  301 */ "select_item",
  /*  302 */ "fill_opt",
  /*  303 */ "fill_mode",
  /*  304 */ "group_by_list",
  /*  305 */ "query_expression_body",
  /*  306 */ "order_by_clause_opt",
  /*  307 */ "slimit_clause_opt",
  /*  308 */ "limit_clause_opt",
  /*  309 */ "query_primary",
  /*  310 */ "sort_specification_list",
  /*  311 */ "sort_specification",
  /*  312 */ "ordering_specification_opt",
  /*  313 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  29 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  30 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  31 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  32 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  33 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  34 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  35 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  36 */ "dnode_endpoint ::= NK_STRING",
 /*  37 */ "dnode_host_name ::= NK_ID",
 /*  38 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  39 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  40 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  41 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  42 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  43 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  45 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  46 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  47 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  48 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  49 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  50 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  51 */ "cmd ::= USE db_name",
 /*  52 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  53 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  54 */ "not_exists_opt ::=",
 /*  55 */ "exists_opt ::= IF EXISTS",
 /*  56 */ "exists_opt ::=",
 /*  57 */ "db_options ::=",
 /*  58 */ "db_options ::= db_options BLOCKS NK_INTEGER",
 /*  59 */ "db_options ::= db_options CACHE NK_INTEGER",
 /*  60 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  61 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  62 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  63 */ "db_options ::= db_options DAYS NK_VARIABLE",
 /*  64 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  65 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  66 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  67 */ "db_options ::= db_options KEEP integer_list",
 /*  68 */ "db_options ::= db_options KEEP variable_list",
 /*  69 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  70 */ "db_options ::= db_options QUORUM NK_INTEGER",
 /*  71 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  72 */ "db_options ::= db_options TTL NK_INTEGER",
 /*  73 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  74 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  75 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  76 */ "db_options ::= db_options STREAM_MODE NK_INTEGER",
 /*  77 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  78 */ "alter_db_options ::= alter_db_option",
 /*  79 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  80 */ "alter_db_option ::= BLOCKS NK_INTEGER",
 /*  81 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  82 */ "alter_db_option ::= KEEP integer_list",
 /*  83 */ "alter_db_option ::= KEEP variable_list",
 /*  84 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  85 */ "alter_db_option ::= QUORUM NK_INTEGER",
 /*  86 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  87 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  88 */ "integer_list ::= NK_INTEGER",
 /*  89 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /*  90 */ "variable_list ::= NK_VARIABLE",
 /*  91 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /*  92 */ "retention_list ::= retention",
 /*  93 */ "retention_list ::= retention_list NK_COMMA retention",
 /*  94 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /*  95 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /*  96 */ "cmd ::= CREATE TABLE multi_create_clause",
 /*  97 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /*  98 */ "cmd ::= DROP TABLE multi_drop_clause",
 /*  99 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 100 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 101 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 102 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 103 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 104 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 105 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 106 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 107 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 108 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 109 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 110 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 111 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal",
 /* 112 */ "multi_create_clause ::= create_subtable_clause",
 /* 113 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 114 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP",
 /* 115 */ "multi_drop_clause ::= drop_table_clause",
 /* 116 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 117 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 118 */ "specific_tags_opt ::=",
 /* 119 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 120 */ "full_table_name ::= table_name",
 /* 121 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 122 */ "column_def_list ::= column_def",
 /* 123 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 124 */ "column_def ::= column_name type_name",
 /* 125 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 126 */ "type_name ::= BOOL",
 /* 127 */ "type_name ::= TINYINT",
 /* 128 */ "type_name ::= SMALLINT",
 /* 129 */ "type_name ::= INT",
 /* 130 */ "type_name ::= INTEGER",
 /* 131 */ "type_name ::= BIGINT",
 /* 132 */ "type_name ::= FLOAT",
 /* 133 */ "type_name ::= DOUBLE",
 /* 134 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 135 */ "type_name ::= TIMESTAMP",
 /* 136 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 137 */ "type_name ::= TINYINT UNSIGNED",
 /* 138 */ "type_name ::= SMALLINT UNSIGNED",
 /* 139 */ "type_name ::= INT UNSIGNED",
 /* 140 */ "type_name ::= BIGINT UNSIGNED",
 /* 141 */ "type_name ::= JSON",
 /* 142 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 143 */ "type_name ::= MEDIUMBLOB",
 /* 144 */ "type_name ::= BLOB",
 /* 145 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 146 */ "type_name ::= DECIMAL",
 /* 147 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 149 */ "tags_def_opt ::=",
 /* 150 */ "tags_def_opt ::= tags_def",
 /* 151 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 152 */ "table_options ::=",
 /* 153 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 154 */ "table_options ::= table_options KEEP integer_list",
 /* 155 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 156 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 157 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 158 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 159 */ "table_options ::= table_options DELAY NK_INTEGER",
 /* 160 */ "alter_table_options ::= alter_table_option",
 /* 161 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 162 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 163 */ "alter_table_option ::= KEEP integer_list",
 /* 164 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 165 */ "col_name_list ::= col_name",
 /* 166 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 167 */ "col_name ::= column_name",
 /* 168 */ "cmd ::= SHOW DNODES",
 /* 169 */ "cmd ::= SHOW USERS",
 /* 170 */ "cmd ::= SHOW DATABASES",
 /* 171 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 172 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 173 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 174 */ "cmd ::= SHOW MNODES",
 /* 175 */ "cmd ::= SHOW MODULES",
 /* 176 */ "cmd ::= SHOW QNODES",
 /* 177 */ "cmd ::= SHOW FUNCTIONS",
 /* 178 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 179 */ "cmd ::= SHOW STREAMS",
 /* 180 */ "cmd ::= SHOW ACCOUNTS",
 /* 181 */ "cmd ::= SHOW APPS",
 /* 182 */ "cmd ::= SHOW CONNECTIONS",
 /* 183 */ "cmd ::= SHOW LICENCE",
 /* 184 */ "cmd ::= SHOW GRANTS",
 /* 185 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 186 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 187 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 188 */ "cmd ::= SHOW QUERIES",
 /* 189 */ "cmd ::= SHOW SCORES",
 /* 190 */ "cmd ::= SHOW TOPICS",
 /* 191 */ "cmd ::= SHOW VARIABLES",
 /* 192 */ "cmd ::= SHOW BNODES",
 /* 193 */ "cmd ::= SHOW SNODES",
 /* 194 */ "db_name_cond_opt ::=",
 /* 195 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 196 */ "like_pattern_opt ::=",
 /* 197 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 198 */ "table_name_cond ::= table_name",
 /* 199 */ "from_db_opt ::=",
 /* 200 */ "from_db_opt ::= FROM db_name",
 /* 201 */ "func_name_list ::= func_name",
 /* 202 */ "func_name_list ::= func_name_list NK_COMMA col_name",
 /* 203 */ "func_name ::= function_name",
 /* 204 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 205 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 206 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 207 */ "index_options ::=",
 /* 208 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 209 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 210 */ "func_list ::= func",
 /* 211 */ "func_list ::= func_list NK_COMMA func",
 /* 212 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 213 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 214 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name",
 /* 215 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 216 */ "cmd ::= DESC full_table_name",
 /* 217 */ "cmd ::= DESCRIBE full_table_name",
 /* 218 */ "cmd ::= RESET QUERY CACHE",
 /* 219 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 220 */ "analyze_opt ::=",
 /* 221 */ "analyze_opt ::= ANALYZE",
 /* 222 */ "explain_options ::=",
 /* 223 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 224 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 225 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 226 */ "cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 227 */ "cmd ::= DROP FUNCTION function_name",
 /* 228 */ "agg_func_opt ::=",
 /* 229 */ "agg_func_opt ::= AGGREGATE",
 /* 230 */ "bufsize_opt ::=",
 /* 231 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 232 */ "cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression",
 /* 233 */ "cmd ::= DROP STREAM stream_name",
 /* 234 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 235 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 236 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 237 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 238 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 239 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 240 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 241 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 242 */ "cmd ::= query_expression",
 /* 243 */ "literal ::= NK_INTEGER",
 /* 244 */ "literal ::= NK_FLOAT",
 /* 245 */ "literal ::= NK_STRING",
 /* 246 */ "literal ::= NK_BOOL",
 /* 247 */ "literal ::= TIMESTAMP NK_STRING",
 /* 248 */ "literal ::= duration_literal",
 /* 249 */ "literal ::= NULL",
 /* 250 */ "duration_literal ::= NK_VARIABLE",
 /* 251 */ "signed ::= NK_INTEGER",
 /* 252 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 253 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 254 */ "signed ::= NK_FLOAT",
 /* 255 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 256 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 257 */ "signed_literal ::= signed",
 /* 258 */ "signed_literal ::= NK_STRING",
 /* 259 */ "signed_literal ::= NK_BOOL",
 /* 260 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 261 */ "signed_literal ::= duration_literal",
 /* 262 */ "signed_literal ::= NULL",
 /* 263 */ "literal_list ::= signed_literal",
 /* 264 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 265 */ "db_name ::= NK_ID",
 /* 266 */ "table_name ::= NK_ID",
 /* 267 */ "column_name ::= NK_ID",
 /* 268 */ "function_name ::= NK_ID",
 /* 269 */ "function_name ::= FIRST",
 /* 270 */ "function_name ::= LAST",
 /* 271 */ "table_alias ::= NK_ID",
 /* 272 */ "column_alias ::= NK_ID",
 /* 273 */ "user_name ::= NK_ID",
 /* 274 */ "index_name ::= NK_ID",
 /* 275 */ "topic_name ::= NK_ID",
 /* 276 */ "stream_name ::= NK_ID",
 /* 277 */ "expression ::= literal",
 /* 278 */ "expression ::= pseudo_column",
 /* 279 */ "expression ::= column_reference",
 /* 280 */ "expression ::= function_name NK_LP expression_list NK_RP",
 /* 281 */ "expression ::= function_name NK_LP NK_STAR NK_RP",
 /* 282 */ "expression ::= function_name NK_LP expression AS type_name NK_RP",
 /* 283 */ "expression ::= subquery",
 /* 284 */ "expression ::= NK_LP expression NK_RP",
 /* 285 */ "expression ::= NK_PLUS expression",
 /* 286 */ "expression ::= NK_MINUS expression",
 /* 287 */ "expression ::= expression NK_PLUS expression",
 /* 288 */ "expression ::= expression NK_MINUS expression",
 /* 289 */ "expression ::= expression NK_STAR expression",
 /* 290 */ "expression ::= expression NK_SLASH expression",
 /* 291 */ "expression ::= expression NK_REM expression",
 /* 292 */ "expression_list ::= expression",
 /* 293 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 294 */ "column_reference ::= column_name",
 /* 295 */ "column_reference ::= table_name NK_DOT column_name",
 /* 296 */ "pseudo_column ::= NOW",
 /* 297 */ "pseudo_column ::= ROWTS",
 /* 298 */ "pseudo_column ::= TBNAME",
 /* 299 */ "pseudo_column ::= QSTARTTS",
 /* 300 */ "pseudo_column ::= QENDTS",
 /* 301 */ "pseudo_column ::= WSTARTTS",
 /* 302 */ "pseudo_column ::= WENDTS",
 /* 303 */ "pseudo_column ::= WDURATION",
 /* 304 */ "predicate ::= expression compare_op expression",
 /* 305 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 306 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 307 */ "predicate ::= expression IS NULL",
 /* 308 */ "predicate ::= expression IS NOT NULL",
 /* 309 */ "predicate ::= expression in_op in_predicate_value",
 /* 310 */ "compare_op ::= NK_LT",
 /* 311 */ "compare_op ::= NK_GT",
 /* 312 */ "compare_op ::= NK_LE",
 /* 313 */ "compare_op ::= NK_GE",
 /* 314 */ "compare_op ::= NK_NE",
 /* 315 */ "compare_op ::= NK_EQ",
 /* 316 */ "compare_op ::= LIKE",
 /* 317 */ "compare_op ::= NOT LIKE",
 /* 318 */ "compare_op ::= MATCH",
 /* 319 */ "compare_op ::= NMATCH",
 /* 320 */ "in_op ::= IN",
 /* 321 */ "in_op ::= NOT IN",
 /* 322 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 323 */ "boolean_value_expression ::= boolean_primary",
 /* 324 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 325 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 326 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 327 */ "boolean_primary ::= predicate",
 /* 328 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 329 */ "common_expression ::= expression",
 /* 330 */ "common_expression ::= boolean_value_expression",
 /* 331 */ "from_clause ::= FROM table_reference_list",
 /* 332 */ "table_reference_list ::= table_reference",
 /* 333 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 334 */ "table_reference ::= table_primary",
 /* 335 */ "table_reference ::= joined_table",
 /* 336 */ "table_primary ::= table_name alias_opt",
 /* 337 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 338 */ "table_primary ::= subquery alias_opt",
 /* 339 */ "table_primary ::= parenthesized_joined_table",
 /* 340 */ "alias_opt ::=",
 /* 341 */ "alias_opt ::= table_alias",
 /* 342 */ "alias_opt ::= AS table_alias",
 /* 343 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 344 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 345 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 346 */ "join_type ::=",
 /* 347 */ "join_type ::= INNER",
 /* 348 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 349 */ "set_quantifier_opt ::=",
 /* 350 */ "set_quantifier_opt ::= DISTINCT",
 /* 351 */ "set_quantifier_opt ::= ALL",
 /* 352 */ "select_list ::= NK_STAR",
 /* 353 */ "select_list ::= select_sublist",
 /* 354 */ "select_sublist ::= select_item",
 /* 355 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 356 */ "select_item ::= common_expression",
 /* 357 */ "select_item ::= common_expression column_alias",
 /* 358 */ "select_item ::= common_expression AS column_alias",
 /* 359 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 360 */ "where_clause_opt ::=",
 /* 361 */ "where_clause_opt ::= WHERE search_condition",
 /* 362 */ "partition_by_clause_opt ::=",
 /* 363 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 364 */ "twindow_clause_opt ::=",
 /* 365 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 366 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 367 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 368 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 369 */ "sliding_opt ::=",
 /* 370 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 371 */ "fill_opt ::=",
 /* 372 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 373 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 374 */ "fill_mode ::= NONE",
 /* 375 */ "fill_mode ::= PREV",
 /* 376 */ "fill_mode ::= NULL",
 /* 377 */ "fill_mode ::= LINEAR",
 /* 378 */ "fill_mode ::= NEXT",
 /* 379 */ "group_by_clause_opt ::=",
 /* 380 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 381 */ "group_by_list ::= expression",
 /* 382 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 383 */ "having_clause_opt ::=",
 /* 384 */ "having_clause_opt ::= HAVING search_condition",
 /* 385 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 386 */ "query_expression_body ::= query_primary",
 /* 387 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 388 */ "query_primary ::= query_specification",
 /* 389 */ "order_by_clause_opt ::=",
 /* 390 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 391 */ "slimit_clause_opt ::=",
 /* 392 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 393 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 394 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 395 */ "limit_clause_opt ::=",
 /* 396 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 397 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 398 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 399 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 400 */ "search_condition ::= common_expression",
 /* 401 */ "sort_specification_list ::= sort_specification",
 /* 402 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 403 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 404 */ "ordering_specification_opt ::=",
 /* 405 */ "ordering_specification_opt ::= ASC",
 /* 406 */ "ordering_specification_opt ::= DESC",
 /* 407 */ "null_ordering_opt ::=",
 /* 408 */ "null_ordering_opt ::= NULLS FIRST",
 /* 409 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 208: /* cmd */
    case 211: /* literal */
    case 218: /* db_options */
    case 220: /* alter_db_options */
    case 225: /* retention */
    case 226: /* full_table_name */
    case 229: /* table_options */
    case 233: /* alter_table_clause */
    case 234: /* alter_table_options */
    case 237: /* create_subtable_clause */
    case 240: /* drop_table_clause */
    case 243: /* column_def */
    case 246: /* col_name */
    case 247: /* db_name_cond_opt */
    case 248: /* like_pattern_opt */
    case 249: /* table_name_cond */
    case 250: /* from_db_opt */
    case 251: /* func_name */
    case 254: /* index_options */
    case 256: /* duration_literal */
    case 257: /* sliding_opt */
    case 258: /* func */
    case 261: /* query_expression */
    case 263: /* explain_options */
    case 268: /* signed */
    case 269: /* signed_literal */
    case 272: /* expression */
    case 273: /* pseudo_column */
    case 274: /* column_reference */
    case 275: /* subquery */
    case 276: /* predicate */
    case 279: /* in_predicate_value */
    case 280: /* boolean_value_expression */
    case 281: /* boolean_primary */
    case 282: /* common_expression */
    case 283: /* from_clause */
    case 284: /* table_reference_list */
    case 285: /* table_reference */
    case 286: /* table_primary */
    case 287: /* joined_table */
    case 289: /* parenthesized_joined_table */
    case 291: /* search_condition */
    case 292: /* query_specification */
    case 295: /* where_clause_opt */
    case 297: /* twindow_clause_opt */
    case 299: /* having_clause_opt */
    case 301: /* select_item */
    case 302: /* fill_opt */
    case 305: /* query_expression_body */
    case 307: /* slimit_clause_opt */
    case 308: /* limit_clause_opt */
    case 309: /* query_primary */
    case 311: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy140)); 
}
      break;
    case 209: /* account_options */
    case 210: /* alter_account_options */
    case 212: /* alter_account_option */
    case 265: /* bufsize_opt */
{
 
}
      break;
    case 213: /* user_name */
    case 214: /* dnode_endpoint */
    case 215: /* dnode_host_name */
    case 217: /* db_name */
    case 235: /* column_name */
    case 242: /* table_name */
    case 252: /* function_name */
    case 253: /* index_name */
    case 260: /* topic_name */
    case 266: /* stream_name */
    case 270: /* table_alias */
    case 271: /* column_alias */
    case 288: /* alias_opt */
{
 
}
      break;
    case 216: /* not_exists_opt */
    case 219: /* exists_opt */
    case 262: /* analyze_opt */
    case 264: /* agg_func_opt */
    case 293: /* set_quantifier_opt */
{
 
}
      break;
    case 221: /* integer_list */
    case 222: /* variable_list */
    case 223: /* retention_list */
    case 227: /* column_def_list */
    case 228: /* tags_def_opt */
    case 230: /* multi_create_clause */
    case 231: /* tags_def */
    case 232: /* multi_drop_clause */
    case 238: /* specific_tags_opt */
    case 239: /* literal_list */
    case 241: /* col_name_list */
    case 244: /* func_name_list */
    case 255: /* func_list */
    case 259: /* expression_list */
    case 267: /* dnode_list */
    case 294: /* select_list */
    case 296: /* partition_by_clause_opt */
    case 298: /* group_by_clause_opt */
    case 300: /* select_sublist */
    case 304: /* group_by_list */
    case 306: /* order_by_clause_opt */
    case 310: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy220)); 
}
      break;
    case 224: /* alter_db_option */
    case 245: /* alter_table_option */
{
 
}
      break;
    case 236: /* type_name */
{
 
}
      break;
    case 277: /* compare_op */
    case 278: /* in_op */
{
 
}
      break;
    case 290: /* join_type */
{
 
}
      break;
    case 303: /* fill_mode */
{
 
}
      break;
    case 312: /* ordering_specification_opt */
{
 
}
      break;
    case 313: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  208,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  208,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  209,    0 }, /* (2) account_options ::= */
  {  209,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  209,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  209,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  209,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  209,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  209,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  209,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  209,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  209,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  210,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  210,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  212,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  212,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  212,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  212,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  212,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  212,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  212,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  212,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  212,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  212,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  208,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  208,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  208,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  208,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  208,   -3 }, /* (28) cmd ::= CREATE DNODE dnode_endpoint */
  {  208,   -5 }, /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  208,   -3 }, /* (30) cmd ::= DROP DNODE NK_INTEGER */
  {  208,   -3 }, /* (31) cmd ::= DROP DNODE dnode_endpoint */
  {  208,   -4 }, /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  208,   -5 }, /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  208,   -4 }, /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
  {  208,   -5 }, /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  214,   -1 }, /* (36) dnode_endpoint ::= NK_STRING */
  {  215,   -1 }, /* (37) dnode_host_name ::= NK_ID */
  {  215,   -1 }, /* (38) dnode_host_name ::= NK_IPTOKEN */
  {  208,   -3 }, /* (39) cmd ::= ALTER LOCAL NK_STRING */
  {  208,   -4 }, /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  208,   -5 }, /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  208,   -5 }, /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  208,   -5 }, /* (43) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  208,   -5 }, /* (44) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  208,   -5 }, /* (45) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  208,   -5 }, /* (46) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  208,   -5 }, /* (47) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  208,   -5 }, /* (48) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  208,   -5 }, /* (49) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  208,   -4 }, /* (50) cmd ::= DROP DATABASE exists_opt db_name */
  {  208,   -2 }, /* (51) cmd ::= USE db_name */
  {  208,   -4 }, /* (52) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  216,   -3 }, /* (53) not_exists_opt ::= IF NOT EXISTS */
  {  216,    0 }, /* (54) not_exists_opt ::= */
  {  219,   -2 }, /* (55) exists_opt ::= IF EXISTS */
  {  219,    0 }, /* (56) exists_opt ::= */
  {  218,    0 }, /* (57) db_options ::= */
  {  218,   -3 }, /* (58) db_options ::= db_options BLOCKS NK_INTEGER */
  {  218,   -3 }, /* (59) db_options ::= db_options CACHE NK_INTEGER */
  {  218,   -3 }, /* (60) db_options ::= db_options CACHELAST NK_INTEGER */
  {  218,   -3 }, /* (61) db_options ::= db_options COMP NK_INTEGER */
  {  218,   -3 }, /* (62) db_options ::= db_options DAYS NK_INTEGER */
  {  218,   -3 }, /* (63) db_options ::= db_options DAYS NK_VARIABLE */
  {  218,   -3 }, /* (64) db_options ::= db_options FSYNC NK_INTEGER */
  {  218,   -3 }, /* (65) db_options ::= db_options MAXROWS NK_INTEGER */
  {  218,   -3 }, /* (66) db_options ::= db_options MINROWS NK_INTEGER */
  {  218,   -3 }, /* (67) db_options ::= db_options KEEP integer_list */
  {  218,   -3 }, /* (68) db_options ::= db_options KEEP variable_list */
  {  218,   -3 }, /* (69) db_options ::= db_options PRECISION NK_STRING */
  {  218,   -3 }, /* (70) db_options ::= db_options QUORUM NK_INTEGER */
  {  218,   -3 }, /* (71) db_options ::= db_options REPLICA NK_INTEGER */
  {  218,   -3 }, /* (72) db_options ::= db_options TTL NK_INTEGER */
  {  218,   -3 }, /* (73) db_options ::= db_options WAL NK_INTEGER */
  {  218,   -3 }, /* (74) db_options ::= db_options VGROUPS NK_INTEGER */
  {  218,   -3 }, /* (75) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  218,   -3 }, /* (76) db_options ::= db_options STREAM_MODE NK_INTEGER */
  {  218,   -3 }, /* (77) db_options ::= db_options RETENTIONS retention_list */
  {  220,   -1 }, /* (78) alter_db_options ::= alter_db_option */
  {  220,   -2 }, /* (79) alter_db_options ::= alter_db_options alter_db_option */
  {  224,   -2 }, /* (80) alter_db_option ::= BLOCKS NK_INTEGER */
  {  224,   -2 }, /* (81) alter_db_option ::= FSYNC NK_INTEGER */
  {  224,   -2 }, /* (82) alter_db_option ::= KEEP integer_list */
  {  224,   -2 }, /* (83) alter_db_option ::= KEEP variable_list */
  {  224,   -2 }, /* (84) alter_db_option ::= WAL NK_INTEGER */
  {  224,   -2 }, /* (85) alter_db_option ::= QUORUM NK_INTEGER */
  {  224,   -2 }, /* (86) alter_db_option ::= CACHELAST NK_INTEGER */
  {  224,   -2 }, /* (87) alter_db_option ::= REPLICA NK_INTEGER */
  {  221,   -1 }, /* (88) integer_list ::= NK_INTEGER */
  {  221,   -3 }, /* (89) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  222,   -1 }, /* (90) variable_list ::= NK_VARIABLE */
  {  222,   -3 }, /* (91) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  223,   -1 }, /* (92) retention_list ::= retention */
  {  223,   -3 }, /* (93) retention_list ::= retention_list NK_COMMA retention */
  {  225,   -3 }, /* (94) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  208,   -9 }, /* (95) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  208,   -3 }, /* (96) cmd ::= CREATE TABLE multi_create_clause */
  {  208,   -9 }, /* (97) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  208,   -3 }, /* (98) cmd ::= DROP TABLE multi_drop_clause */
  {  208,   -4 }, /* (99) cmd ::= DROP STABLE exists_opt full_table_name */
  {  208,   -3 }, /* (100) cmd ::= ALTER TABLE alter_table_clause */
  {  208,   -3 }, /* (101) cmd ::= ALTER STABLE alter_table_clause */
  {  233,   -2 }, /* (102) alter_table_clause ::= full_table_name alter_table_options */
  {  233,   -5 }, /* (103) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  233,   -4 }, /* (104) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  233,   -5 }, /* (105) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  233,   -5 }, /* (106) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  233,   -5 }, /* (107) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  233,   -4 }, /* (108) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  233,   -5 }, /* (109) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  233,   -5 }, /* (110) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  233,   -6 }, /* (111) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
  {  230,   -1 }, /* (112) multi_create_clause ::= create_subtable_clause */
  {  230,   -2 }, /* (113) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  237,   -9 }, /* (114) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
  {  232,   -1 }, /* (115) multi_drop_clause ::= drop_table_clause */
  {  232,   -2 }, /* (116) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  240,   -2 }, /* (117) drop_table_clause ::= exists_opt full_table_name */
  {  238,    0 }, /* (118) specific_tags_opt ::= */
  {  238,   -3 }, /* (119) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  226,   -1 }, /* (120) full_table_name ::= table_name */
  {  226,   -3 }, /* (121) full_table_name ::= db_name NK_DOT table_name */
  {  227,   -1 }, /* (122) column_def_list ::= column_def */
  {  227,   -3 }, /* (123) column_def_list ::= column_def_list NK_COMMA column_def */
  {  243,   -2 }, /* (124) column_def ::= column_name type_name */
  {  243,   -4 }, /* (125) column_def ::= column_name type_name COMMENT NK_STRING */
  {  236,   -1 }, /* (126) type_name ::= BOOL */
  {  236,   -1 }, /* (127) type_name ::= TINYINT */
  {  236,   -1 }, /* (128) type_name ::= SMALLINT */
  {  236,   -1 }, /* (129) type_name ::= INT */
  {  236,   -1 }, /* (130) type_name ::= INTEGER */
  {  236,   -1 }, /* (131) type_name ::= BIGINT */
  {  236,   -1 }, /* (132) type_name ::= FLOAT */
  {  236,   -1 }, /* (133) type_name ::= DOUBLE */
  {  236,   -4 }, /* (134) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  236,   -1 }, /* (135) type_name ::= TIMESTAMP */
  {  236,   -4 }, /* (136) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  236,   -2 }, /* (137) type_name ::= TINYINT UNSIGNED */
  {  236,   -2 }, /* (138) type_name ::= SMALLINT UNSIGNED */
  {  236,   -2 }, /* (139) type_name ::= INT UNSIGNED */
  {  236,   -2 }, /* (140) type_name ::= BIGINT UNSIGNED */
  {  236,   -1 }, /* (141) type_name ::= JSON */
  {  236,   -4 }, /* (142) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  236,   -1 }, /* (143) type_name ::= MEDIUMBLOB */
  {  236,   -1 }, /* (144) type_name ::= BLOB */
  {  236,   -4 }, /* (145) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  236,   -1 }, /* (146) type_name ::= DECIMAL */
  {  236,   -4 }, /* (147) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  236,   -6 }, /* (148) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  228,    0 }, /* (149) tags_def_opt ::= */
  {  228,   -1 }, /* (150) tags_def_opt ::= tags_def */
  {  231,   -4 }, /* (151) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  229,    0 }, /* (152) table_options ::= */
  {  229,   -3 }, /* (153) table_options ::= table_options COMMENT NK_STRING */
  {  229,   -3 }, /* (154) table_options ::= table_options KEEP integer_list */
  {  229,   -3 }, /* (155) table_options ::= table_options TTL NK_INTEGER */
  {  229,   -5 }, /* (156) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  229,   -5 }, /* (157) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  229,   -3 }, /* (158) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  229,   -3 }, /* (159) table_options ::= table_options DELAY NK_INTEGER */
  {  234,   -1 }, /* (160) alter_table_options ::= alter_table_option */
  {  234,   -2 }, /* (161) alter_table_options ::= alter_table_options alter_table_option */
  {  245,   -2 }, /* (162) alter_table_option ::= COMMENT NK_STRING */
  {  245,   -2 }, /* (163) alter_table_option ::= KEEP integer_list */
  {  245,   -2 }, /* (164) alter_table_option ::= TTL NK_INTEGER */
  {  241,   -1 }, /* (165) col_name_list ::= col_name */
  {  241,   -3 }, /* (166) col_name_list ::= col_name_list NK_COMMA col_name */
  {  246,   -1 }, /* (167) col_name ::= column_name */
  {  208,   -2 }, /* (168) cmd ::= SHOW DNODES */
  {  208,   -2 }, /* (169) cmd ::= SHOW USERS */
  {  208,   -2 }, /* (170) cmd ::= SHOW DATABASES */
  {  208,   -4 }, /* (171) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  208,   -4 }, /* (172) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  208,   -3 }, /* (173) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  208,   -2 }, /* (174) cmd ::= SHOW MNODES */
  {  208,   -2 }, /* (175) cmd ::= SHOW MODULES */
  {  208,   -2 }, /* (176) cmd ::= SHOW QNODES */
  {  208,   -2 }, /* (177) cmd ::= SHOW FUNCTIONS */
  {  208,   -5 }, /* (178) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  208,   -2 }, /* (179) cmd ::= SHOW STREAMS */
  {  208,   -2 }, /* (180) cmd ::= SHOW ACCOUNTS */
  {  208,   -2 }, /* (181) cmd ::= SHOW APPS */
  {  208,   -2 }, /* (182) cmd ::= SHOW CONNECTIONS */
  {  208,   -2 }, /* (183) cmd ::= SHOW LICENCE */
  {  208,   -2 }, /* (184) cmd ::= SHOW GRANTS */
  {  208,   -4 }, /* (185) cmd ::= SHOW CREATE DATABASE db_name */
  {  208,   -4 }, /* (186) cmd ::= SHOW CREATE TABLE full_table_name */
  {  208,   -4 }, /* (187) cmd ::= SHOW CREATE STABLE full_table_name */
  {  208,   -2 }, /* (188) cmd ::= SHOW QUERIES */
  {  208,   -2 }, /* (189) cmd ::= SHOW SCORES */
  {  208,   -2 }, /* (190) cmd ::= SHOW TOPICS */
  {  208,   -2 }, /* (191) cmd ::= SHOW VARIABLES */
  {  208,   -2 }, /* (192) cmd ::= SHOW BNODES */
  {  208,   -2 }, /* (193) cmd ::= SHOW SNODES */
  {  247,    0 }, /* (194) db_name_cond_opt ::= */
  {  247,   -2 }, /* (195) db_name_cond_opt ::= db_name NK_DOT */
  {  248,    0 }, /* (196) like_pattern_opt ::= */
  {  248,   -2 }, /* (197) like_pattern_opt ::= LIKE NK_STRING */
  {  249,   -1 }, /* (198) table_name_cond ::= table_name */
  {  250,    0 }, /* (199) from_db_opt ::= */
  {  250,   -2 }, /* (200) from_db_opt ::= FROM db_name */
  {  244,   -1 }, /* (201) func_name_list ::= func_name */
  {  244,   -3 }, /* (202) func_name_list ::= func_name_list NK_COMMA col_name */
  {  251,   -1 }, /* (203) func_name ::= function_name */
  {  208,   -8 }, /* (204) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  208,  -10 }, /* (205) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  208,   -6 }, /* (206) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  254,    0 }, /* (207) index_options ::= */
  {  254,   -9 }, /* (208) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  254,  -11 }, /* (209) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  255,   -1 }, /* (210) func_list ::= func */
  {  255,   -3 }, /* (211) func_list ::= func_list NK_COMMA func */
  {  258,   -4 }, /* (212) func ::= function_name NK_LP expression_list NK_RP */
  {  208,   -6 }, /* (213) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  208,   -6 }, /* (214) cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
  {  208,   -4 }, /* (215) cmd ::= DROP TOPIC exists_opt topic_name */
  {  208,   -2 }, /* (216) cmd ::= DESC full_table_name */
  {  208,   -2 }, /* (217) cmd ::= DESCRIBE full_table_name */
  {  208,   -3 }, /* (218) cmd ::= RESET QUERY CACHE */
  {  208,   -4 }, /* (219) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  262,    0 }, /* (220) analyze_opt ::= */
  {  262,   -1 }, /* (221) analyze_opt ::= ANALYZE */
  {  263,    0 }, /* (222) explain_options ::= */
  {  263,   -3 }, /* (223) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  263,   -3 }, /* (224) explain_options ::= explain_options RATIO NK_FLOAT */
  {  208,   -6 }, /* (225) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  208,   -9 }, /* (226) cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  208,   -3 }, /* (227) cmd ::= DROP FUNCTION function_name */
  {  264,    0 }, /* (228) agg_func_opt ::= */
  {  264,   -1 }, /* (229) agg_func_opt ::= AGGREGATE */
  {  265,    0 }, /* (230) bufsize_opt ::= */
  {  265,   -2 }, /* (231) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  208,   -7 }, /* (232) cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression */
  {  208,   -3 }, /* (233) cmd ::= DROP STREAM stream_name */
  {  208,   -3 }, /* (234) cmd ::= KILL CONNECTION NK_INTEGER */
  {  208,   -3 }, /* (235) cmd ::= KILL QUERY NK_INTEGER */
  {  208,   -4 }, /* (236) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  208,   -4 }, /* (237) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  208,   -3 }, /* (238) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  267,   -2 }, /* (239) dnode_list ::= DNODE NK_INTEGER */
  {  267,   -3 }, /* (240) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  208,   -3 }, /* (241) cmd ::= SYNCDB db_name REPLICA */
  {  208,   -1 }, /* (242) cmd ::= query_expression */
  {  211,   -1 }, /* (243) literal ::= NK_INTEGER */
  {  211,   -1 }, /* (244) literal ::= NK_FLOAT */
  {  211,   -1 }, /* (245) literal ::= NK_STRING */
  {  211,   -1 }, /* (246) literal ::= NK_BOOL */
  {  211,   -2 }, /* (247) literal ::= TIMESTAMP NK_STRING */
  {  211,   -1 }, /* (248) literal ::= duration_literal */
  {  211,   -1 }, /* (249) literal ::= NULL */
  {  256,   -1 }, /* (250) duration_literal ::= NK_VARIABLE */
  {  268,   -1 }, /* (251) signed ::= NK_INTEGER */
  {  268,   -2 }, /* (252) signed ::= NK_PLUS NK_INTEGER */
  {  268,   -2 }, /* (253) signed ::= NK_MINUS NK_INTEGER */
  {  268,   -1 }, /* (254) signed ::= NK_FLOAT */
  {  268,   -2 }, /* (255) signed ::= NK_PLUS NK_FLOAT */
  {  268,   -2 }, /* (256) signed ::= NK_MINUS NK_FLOAT */
  {  269,   -1 }, /* (257) signed_literal ::= signed */
  {  269,   -1 }, /* (258) signed_literal ::= NK_STRING */
  {  269,   -1 }, /* (259) signed_literal ::= NK_BOOL */
  {  269,   -2 }, /* (260) signed_literal ::= TIMESTAMP NK_STRING */
  {  269,   -1 }, /* (261) signed_literal ::= duration_literal */
  {  269,   -1 }, /* (262) signed_literal ::= NULL */
  {  239,   -1 }, /* (263) literal_list ::= signed_literal */
  {  239,   -3 }, /* (264) literal_list ::= literal_list NK_COMMA signed_literal */
  {  217,   -1 }, /* (265) db_name ::= NK_ID */
  {  242,   -1 }, /* (266) table_name ::= NK_ID */
  {  235,   -1 }, /* (267) column_name ::= NK_ID */
  {  252,   -1 }, /* (268) function_name ::= NK_ID */
  {  252,   -1 }, /* (269) function_name ::= FIRST */
  {  252,   -1 }, /* (270) function_name ::= LAST */
  {  270,   -1 }, /* (271) table_alias ::= NK_ID */
  {  271,   -1 }, /* (272) column_alias ::= NK_ID */
  {  213,   -1 }, /* (273) user_name ::= NK_ID */
  {  253,   -1 }, /* (274) index_name ::= NK_ID */
  {  260,   -1 }, /* (275) topic_name ::= NK_ID */
  {  266,   -1 }, /* (276) stream_name ::= NK_ID */
  {  272,   -1 }, /* (277) expression ::= literal */
  {  272,   -1 }, /* (278) expression ::= pseudo_column */
  {  272,   -1 }, /* (279) expression ::= column_reference */
  {  272,   -4 }, /* (280) expression ::= function_name NK_LP expression_list NK_RP */
  {  272,   -4 }, /* (281) expression ::= function_name NK_LP NK_STAR NK_RP */
  {  272,   -6 }, /* (282) expression ::= function_name NK_LP expression AS type_name NK_RP */
  {  272,   -1 }, /* (283) expression ::= subquery */
  {  272,   -3 }, /* (284) expression ::= NK_LP expression NK_RP */
  {  272,   -2 }, /* (285) expression ::= NK_PLUS expression */
  {  272,   -2 }, /* (286) expression ::= NK_MINUS expression */
  {  272,   -3 }, /* (287) expression ::= expression NK_PLUS expression */
  {  272,   -3 }, /* (288) expression ::= expression NK_MINUS expression */
  {  272,   -3 }, /* (289) expression ::= expression NK_STAR expression */
  {  272,   -3 }, /* (290) expression ::= expression NK_SLASH expression */
  {  272,   -3 }, /* (291) expression ::= expression NK_REM expression */
  {  259,   -1 }, /* (292) expression_list ::= expression */
  {  259,   -3 }, /* (293) expression_list ::= expression_list NK_COMMA expression */
  {  274,   -1 }, /* (294) column_reference ::= column_name */
  {  274,   -3 }, /* (295) column_reference ::= table_name NK_DOT column_name */
  {  273,   -1 }, /* (296) pseudo_column ::= NOW */
  {  273,   -1 }, /* (297) pseudo_column ::= ROWTS */
  {  273,   -1 }, /* (298) pseudo_column ::= TBNAME */
  {  273,   -1 }, /* (299) pseudo_column ::= QSTARTTS */
  {  273,   -1 }, /* (300) pseudo_column ::= QENDTS */
  {  273,   -1 }, /* (301) pseudo_column ::= WSTARTTS */
  {  273,   -1 }, /* (302) pseudo_column ::= WENDTS */
  {  273,   -1 }, /* (303) pseudo_column ::= WDURATION */
  {  276,   -3 }, /* (304) predicate ::= expression compare_op expression */
  {  276,   -5 }, /* (305) predicate ::= expression BETWEEN expression AND expression */
  {  276,   -6 }, /* (306) predicate ::= expression NOT BETWEEN expression AND expression */
  {  276,   -3 }, /* (307) predicate ::= expression IS NULL */
  {  276,   -4 }, /* (308) predicate ::= expression IS NOT NULL */
  {  276,   -3 }, /* (309) predicate ::= expression in_op in_predicate_value */
  {  277,   -1 }, /* (310) compare_op ::= NK_LT */
  {  277,   -1 }, /* (311) compare_op ::= NK_GT */
  {  277,   -1 }, /* (312) compare_op ::= NK_LE */
  {  277,   -1 }, /* (313) compare_op ::= NK_GE */
  {  277,   -1 }, /* (314) compare_op ::= NK_NE */
  {  277,   -1 }, /* (315) compare_op ::= NK_EQ */
  {  277,   -1 }, /* (316) compare_op ::= LIKE */
  {  277,   -2 }, /* (317) compare_op ::= NOT LIKE */
  {  277,   -1 }, /* (318) compare_op ::= MATCH */
  {  277,   -1 }, /* (319) compare_op ::= NMATCH */
  {  278,   -1 }, /* (320) in_op ::= IN */
  {  278,   -2 }, /* (321) in_op ::= NOT IN */
  {  279,   -3 }, /* (322) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  280,   -1 }, /* (323) boolean_value_expression ::= boolean_primary */
  {  280,   -2 }, /* (324) boolean_value_expression ::= NOT boolean_primary */
  {  280,   -3 }, /* (325) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  280,   -3 }, /* (326) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  281,   -1 }, /* (327) boolean_primary ::= predicate */
  {  281,   -3 }, /* (328) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  282,   -1 }, /* (329) common_expression ::= expression */
  {  282,   -1 }, /* (330) common_expression ::= boolean_value_expression */
  {  283,   -2 }, /* (331) from_clause ::= FROM table_reference_list */
  {  284,   -1 }, /* (332) table_reference_list ::= table_reference */
  {  284,   -3 }, /* (333) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  285,   -1 }, /* (334) table_reference ::= table_primary */
  {  285,   -1 }, /* (335) table_reference ::= joined_table */
  {  286,   -2 }, /* (336) table_primary ::= table_name alias_opt */
  {  286,   -4 }, /* (337) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  286,   -2 }, /* (338) table_primary ::= subquery alias_opt */
  {  286,   -1 }, /* (339) table_primary ::= parenthesized_joined_table */
  {  288,    0 }, /* (340) alias_opt ::= */
  {  288,   -1 }, /* (341) alias_opt ::= table_alias */
  {  288,   -2 }, /* (342) alias_opt ::= AS table_alias */
  {  289,   -3 }, /* (343) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  289,   -3 }, /* (344) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  287,   -6 }, /* (345) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  290,    0 }, /* (346) join_type ::= */
  {  290,   -1 }, /* (347) join_type ::= INNER */
  {  292,   -9 }, /* (348) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  293,    0 }, /* (349) set_quantifier_opt ::= */
  {  293,   -1 }, /* (350) set_quantifier_opt ::= DISTINCT */
  {  293,   -1 }, /* (351) set_quantifier_opt ::= ALL */
  {  294,   -1 }, /* (352) select_list ::= NK_STAR */
  {  294,   -1 }, /* (353) select_list ::= select_sublist */
  {  300,   -1 }, /* (354) select_sublist ::= select_item */
  {  300,   -3 }, /* (355) select_sublist ::= select_sublist NK_COMMA select_item */
  {  301,   -1 }, /* (356) select_item ::= common_expression */
  {  301,   -2 }, /* (357) select_item ::= common_expression column_alias */
  {  301,   -3 }, /* (358) select_item ::= common_expression AS column_alias */
  {  301,   -3 }, /* (359) select_item ::= table_name NK_DOT NK_STAR */
  {  295,    0 }, /* (360) where_clause_opt ::= */
  {  295,   -2 }, /* (361) where_clause_opt ::= WHERE search_condition */
  {  296,    0 }, /* (362) partition_by_clause_opt ::= */
  {  296,   -3 }, /* (363) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  297,    0 }, /* (364) twindow_clause_opt ::= */
  {  297,   -6 }, /* (365) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  297,   -4 }, /* (366) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  297,   -6 }, /* (367) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  297,   -8 }, /* (368) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  257,    0 }, /* (369) sliding_opt ::= */
  {  257,   -4 }, /* (370) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  302,    0 }, /* (371) fill_opt ::= */
  {  302,   -4 }, /* (372) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  302,   -6 }, /* (373) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  303,   -1 }, /* (374) fill_mode ::= NONE */
  {  303,   -1 }, /* (375) fill_mode ::= PREV */
  {  303,   -1 }, /* (376) fill_mode ::= NULL */
  {  303,   -1 }, /* (377) fill_mode ::= LINEAR */
  {  303,   -1 }, /* (378) fill_mode ::= NEXT */
  {  298,    0 }, /* (379) group_by_clause_opt ::= */
  {  298,   -3 }, /* (380) group_by_clause_opt ::= GROUP BY group_by_list */
  {  304,   -1 }, /* (381) group_by_list ::= expression */
  {  304,   -3 }, /* (382) group_by_list ::= group_by_list NK_COMMA expression */
  {  299,    0 }, /* (383) having_clause_opt ::= */
  {  299,   -2 }, /* (384) having_clause_opt ::= HAVING search_condition */
  {  261,   -4 }, /* (385) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  305,   -1 }, /* (386) query_expression_body ::= query_primary */
  {  305,   -4 }, /* (387) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  309,   -1 }, /* (388) query_primary ::= query_specification */
  {  306,    0 }, /* (389) order_by_clause_opt ::= */
  {  306,   -3 }, /* (390) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  307,    0 }, /* (391) slimit_clause_opt ::= */
  {  307,   -2 }, /* (392) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  307,   -4 }, /* (393) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  307,   -4 }, /* (394) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  308,    0 }, /* (395) limit_clause_opt ::= */
  {  308,   -2 }, /* (396) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  308,   -4 }, /* (397) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  308,   -4 }, /* (398) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  275,   -3 }, /* (399) subquery ::= NK_LP query_expression NK_RP */
  {  291,   -1 }, /* (400) search_condition ::= common_expression */
  {  310,   -1 }, /* (401) sort_specification_list ::= sort_specification */
  {  310,   -3 }, /* (402) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  311,   -3 }, /* (403) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  312,    0 }, /* (404) ordering_specification_opt ::= */
  {  312,   -1 }, /* (405) ordering_specification_opt ::= ASC */
  {  312,   -1 }, /* (406) ordering_specification_opt ::= DESC */
  {  313,    0 }, /* (407) null_ordering_opt ::= */
  {  313,   -2 }, /* (408) null_ordering_opt ::= NULLS FIRST */
  {  313,   -2 }, /* (409) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,209,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,210,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,209,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,211,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,212,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,210,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,212,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,211,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy253, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy253, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy253, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy253); }
        break;
      case 28: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy253, NULL); }
        break;
      case 29: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy253, &yymsp[0].minor.yy0); }
        break;
      case 30: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 31: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy253); }
        break;
      case 32: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 33: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 34: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 35: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 36: /* dnode_endpoint ::= NK_STRING */
      case 37: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==37);
      case 38: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==38);
      case 265: /* db_name ::= NK_ID */ yytestcase(yyruleno==265);
      case 266: /* table_name ::= NK_ID */ yytestcase(yyruleno==266);
      case 267: /* column_name ::= NK_ID */ yytestcase(yyruleno==267);
      case 268: /* function_name ::= NK_ID */ yytestcase(yyruleno==268);
      case 269: /* function_name ::= FIRST */ yytestcase(yyruleno==269);
      case 270: /* function_name ::= LAST */ yytestcase(yyruleno==270);
      case 271: /* table_alias ::= NK_ID */ yytestcase(yyruleno==271);
      case 272: /* column_alias ::= NK_ID */ yytestcase(yyruleno==272);
      case 273: /* user_name ::= NK_ID */ yytestcase(yyruleno==273);
      case 274: /* index_name ::= NK_ID */ yytestcase(yyruleno==274);
      case 275: /* topic_name ::= NK_ID */ yytestcase(yyruleno==275);
      case 276: /* stream_name ::= NK_ID */ yytestcase(yyruleno==276);
{ yylhsminor.yy253 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy253 = yylhsminor.yy253;
        break;
      case 39: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 40: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 42: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 46: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy273, &yymsp[-1].minor.yy253, yymsp[0].minor.yy140); }
        break;
      case 50: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy273, &yymsp[0].minor.yy253); }
        break;
      case 51: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy253); }
        break;
      case 52: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy253, yymsp[0].minor.yy140); }
        break;
      case 53: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy273 = true; }
        break;
      case 54: /* not_exists_opt ::= */
      case 56: /* exists_opt ::= */ yytestcase(yyruleno==56);
      case 220: /* analyze_opt ::= */ yytestcase(yyruleno==220);
      case 228: /* agg_func_opt ::= */ yytestcase(yyruleno==228);
      case 349: /* set_quantifier_opt ::= */ yytestcase(yyruleno==349);
{ yymsp[1].minor.yy273 = false; }
        break;
      case 55: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy273 = true; }
        break;
      case 57: /* db_options ::= */
{ yymsp[1].minor.yy140 = createDatabaseOptions(pCxt); }
        break;
      case 58: /* db_options ::= db_options BLOCKS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy140)->pNumOfBlocks = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 59: /* db_options ::= db_options CACHE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy140)->pCacheBlockSize = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 60: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy140)->pCachelast = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 61: /* db_options ::= db_options COMP NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy140)->pCompressionLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 62: /* db_options ::= db_options DAYS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy140)->pDaysPerFile = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 63: /* db_options ::= db_options DAYS NK_VARIABLE */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy140)->pDaysPerFile = (SValueNode*)createDurationValueNode(pCxt, &yymsp[0].minor.yy0); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 64: /* db_options ::= db_options FSYNC NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy140)->pFsyncPeriod = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 65: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy140)->pMaxRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 66: /* db_options ::= db_options MINROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy140)->pMinRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 67: /* db_options ::= db_options KEEP integer_list */
      case 68: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==68);
{ ((SDatabaseOptions*)yymsp[-2].minor.yy140)->pKeep = yymsp[0].minor.yy220; yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 69: /* db_options ::= db_options PRECISION NK_STRING */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy140)->pPrecision = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 70: /* db_options ::= db_options QUORUM NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy140)->pQuorum = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 71: /* db_options ::= db_options REPLICA NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy140)->pReplica = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 72: /* db_options ::= db_options TTL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy140)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 73: /* db_options ::= db_options WAL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy140)->pWalLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 74: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy140)->pNumOfVgroups = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 75: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy140)->pSingleStable = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 76: /* db_options ::= db_options STREAM_MODE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy140)->pStreamMode = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 77: /* db_options ::= db_options RETENTIONS retention_list */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy140)->pRetentions = yymsp[0].minor.yy220; yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 78: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy140 = createDatabaseOptions(pCxt); yylhsminor.yy140 = setDatabaseAlterOption(pCxt, yylhsminor.yy140, &yymsp[0].minor.yy181); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 79: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy140 = setDatabaseAlterOption(pCxt, yymsp[-1].minor.yy140, &yymsp[0].minor.yy181); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 80: /* alter_db_option ::= BLOCKS NK_INTEGER */
{ yymsp[-1].minor.yy181.type = DB_OPTION_BLOCKS; yymsp[-1].minor.yy181.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 81: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy181.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy181.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 82: /* alter_db_option ::= KEEP integer_list */
      case 83: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==83);
{ yymsp[-1].minor.yy181.type = DB_OPTION_KEEP; yymsp[-1].minor.yy181.pList = yymsp[0].minor.yy220; }
        break;
      case 84: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy181.type = DB_OPTION_WAL; yymsp[-1].minor.yy181.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 85: /* alter_db_option ::= QUORUM NK_INTEGER */
{ yymsp[-1].minor.yy181.type = DB_OPTION_QUORUM; yymsp[-1].minor.yy181.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 86: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy181.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy181.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 87: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy181.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy181.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 88: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy220 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 89: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 240: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==240);
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 90: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy220 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 91: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 92: /* retention_list ::= retention */
      case 112: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==112);
      case 115: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==115);
      case 122: /* column_def_list ::= column_def */ yytestcase(yyruleno==122);
      case 165: /* col_name_list ::= col_name */ yytestcase(yyruleno==165);
      case 201: /* func_name_list ::= func_name */ yytestcase(yyruleno==201);
      case 210: /* func_list ::= func */ yytestcase(yyruleno==210);
      case 263: /* literal_list ::= signed_literal */ yytestcase(yyruleno==263);
      case 354: /* select_sublist ::= select_item */ yytestcase(yyruleno==354);
      case 401: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==401);
{ yylhsminor.yy220 = createNodeList(pCxt, yymsp[0].minor.yy140); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 93: /* retention_list ::= retention_list NK_COMMA retention */
      case 123: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==123);
      case 166: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==166);
      case 202: /* func_name_list ::= func_name_list NK_COMMA col_name */ yytestcase(yyruleno==202);
      case 211: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==211);
      case 264: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==264);
      case 355: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==355);
      case 402: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==402);
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, yymsp[0].minor.yy140); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 94: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy140 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 95: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 97: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==97);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy273, yymsp[-5].minor.yy140, yymsp[-3].minor.yy220, yymsp[-1].minor.yy220, yymsp[0].minor.yy140); }
        break;
      case 96: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy220); }
        break;
      case 98: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy220); }
        break;
      case 99: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy273, yymsp[0].minor.yy140); }
        break;
      case 100: /* cmd ::= ALTER TABLE alter_table_clause */
      case 101: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==101);
      case 242: /* cmd ::= query_expression */ yytestcase(yyruleno==242);
{ pCxt->pRootNode = yymsp[0].minor.yy140; }
        break;
      case 102: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy140 = createAlterTableOption(pCxt, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 103: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy253, yymsp[0].minor.yy368); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 104: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy140 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy140, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy253); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 105: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy253, yymsp[0].minor.yy368); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 106: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy140 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy253, &yymsp[0].minor.yy253); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 107: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy253, yymsp[0].minor.yy368); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 108: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy140 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy140, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy253); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 109: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy140 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy253, yymsp[0].minor.yy368); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 110: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy140 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy140, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy253, &yymsp[0].minor.yy253); }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 111: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
{ yylhsminor.yy140 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy140, &yymsp[-2].minor.yy253, yymsp[0].minor.yy140); }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 113: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 116: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==116);
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-1].minor.yy220, yymsp[0].minor.yy140); }
  yymsp[-1].minor.yy220 = yylhsminor.yy220;
        break;
      case 114: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
{ yylhsminor.yy140 = createCreateSubTableClause(pCxt, yymsp[-8].minor.yy273, yymsp[-7].minor.yy140, yymsp[-5].minor.yy140, yymsp[-4].minor.yy220, yymsp[-1].minor.yy220); }
  yymsp[-8].minor.yy140 = yylhsminor.yy140;
        break;
      case 117: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy140 = createDropTableClause(pCxt, yymsp[-1].minor.yy273, yymsp[0].minor.yy140); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 118: /* specific_tags_opt ::= */
      case 149: /* tags_def_opt ::= */ yytestcase(yyruleno==149);
      case 362: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==362);
      case 379: /* group_by_clause_opt ::= */ yytestcase(yyruleno==379);
      case 389: /* order_by_clause_opt ::= */ yytestcase(yyruleno==389);
{ yymsp[1].minor.yy220 = NULL; }
        break;
      case 119: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy220 = yymsp[-1].minor.yy220; }
        break;
      case 120: /* full_table_name ::= table_name */
{ yylhsminor.yy140 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy253, NULL); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 121: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy140 = createRealTableNode(pCxt, &yymsp[-2].minor.yy253, &yymsp[0].minor.yy253, NULL); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 124: /* column_def ::= column_name type_name */
{ yylhsminor.yy140 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy253, yymsp[0].minor.yy368, NULL); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 125: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy140 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy253, yymsp[-2].minor.yy368, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 126: /* type_name ::= BOOL */
{ yymsp[0].minor.yy368 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 127: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy368 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 128: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy368 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 129: /* type_name ::= INT */
      case 130: /* type_name ::= INTEGER */ yytestcase(yyruleno==130);
{ yymsp[0].minor.yy368 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 131: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy368 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 132: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy368 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 133: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy368 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 134: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy368 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 135: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy368 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 136: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy368 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 137: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy368 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 138: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy368 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 139: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy368 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 140: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy368 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 141: /* type_name ::= JSON */
{ yymsp[0].minor.yy368 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 142: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy368 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 143: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy368 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 144: /* type_name ::= BLOB */
{ yymsp[0].minor.yy368 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 145: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy368 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 146: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy368 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 147: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy368 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 148: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy368 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 150: /* tags_def_opt ::= tags_def */
      case 353: /* select_list ::= select_sublist */ yytestcase(yyruleno==353);
{ yylhsminor.yy220 = yymsp[0].minor.yy220; }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 151: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy220 = yymsp[-1].minor.yy220; }
        break;
      case 152: /* table_options ::= */
{ yymsp[1].minor.yy140 = createTableOptions(pCxt); }
        break;
      case 153: /* table_options ::= table_options COMMENT NK_STRING */
{ ((STableOptions*)yymsp[-2].minor.yy140)->pComments = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 154: /* table_options ::= table_options KEEP integer_list */
{ ((STableOptions*)yymsp[-2].minor.yy140)->pKeep = yymsp[0].minor.yy220; yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 155: /* table_options ::= table_options TTL NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy140)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 156: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy140)->pSma = yymsp[-1].minor.yy220; yylhsminor.yy140 = yymsp[-4].minor.yy140; }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 157: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy140)->pFuncs = yymsp[-1].minor.yy220; yylhsminor.yy140 = yymsp[-4].minor.yy140; }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 158: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ ((STableOptions*)yymsp[-2].minor.yy140)->pFilesFactor = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 159: /* table_options ::= table_options DELAY NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy140)->pDelay = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy140 = yymsp[-2].minor.yy140; }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 160: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy140 = createTableOptions(pCxt); yylhsminor.yy140 = setTableAlterOption(pCxt, yylhsminor.yy140, &yymsp[0].minor.yy181); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 161: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy140 = setTableAlterOption(pCxt, yymsp[-1].minor.yy140, &yymsp[0].minor.yy181); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 162: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy181.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy181.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 163: /* alter_table_option ::= KEEP integer_list */
{ yymsp[-1].minor.yy181.type = TABLE_OPTION_KEEP; yymsp[-1].minor.yy181.pList = yymsp[0].minor.yy220; }
        break;
      case 164: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy181.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy181.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 167: /* col_name ::= column_name */
{ yylhsminor.yy140 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy253); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 168: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 169: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 170: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 171: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 172: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 173: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy140, NULL); }
        break;
      case 174: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 175: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 176: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 177: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 178: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 179: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 180: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 181: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 182: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 183: /* cmd ::= SHOW LICENCE */
      case 184: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==184);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 185: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy253); }
        break;
      case 186: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy140); }
        break;
      case 187: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy140); }
        break;
      case 188: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 189: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 190: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 191: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 192: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT, NULL, NULL); }
        break;
      case 193: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT, NULL, NULL); }
        break;
      case 194: /* db_name_cond_opt ::= */
      case 199: /* from_db_opt ::= */ yytestcase(yyruleno==199);
{ yymsp[1].minor.yy140 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 195: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy253); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 196: /* like_pattern_opt ::= */
      case 207: /* index_options ::= */ yytestcase(yyruleno==207);
      case 360: /* where_clause_opt ::= */ yytestcase(yyruleno==360);
      case 364: /* twindow_clause_opt ::= */ yytestcase(yyruleno==364);
      case 369: /* sliding_opt ::= */ yytestcase(yyruleno==369);
      case 371: /* fill_opt ::= */ yytestcase(yyruleno==371);
      case 383: /* having_clause_opt ::= */ yytestcase(yyruleno==383);
      case 391: /* slimit_clause_opt ::= */ yytestcase(yyruleno==391);
      case 395: /* limit_clause_opt ::= */ yytestcase(yyruleno==395);
{ yymsp[1].minor.yy140 = NULL; }
        break;
      case 197: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 198: /* table_name_cond ::= table_name */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy253); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 200: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy253); }
        break;
      case 203: /* func_name ::= function_name */
{ yylhsminor.yy140 = createFunctionNode(pCxt, &yymsp[0].minor.yy253, NULL); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 204: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy273, &yymsp[-3].minor.yy253, &yymsp[-1].minor.yy253, NULL, yymsp[0].minor.yy140); }
        break;
      case 205: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy273, &yymsp[-5].minor.yy253, &yymsp[-3].minor.yy253, yymsp[-1].minor.yy220, NULL); }
        break;
      case 206: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy273, &yymsp[-2].minor.yy253, &yymsp[0].minor.yy253); }
        break;
      case 208: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy140 = createIndexOption(pCxt, yymsp[-6].minor.yy220, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), NULL, yymsp[0].minor.yy140); }
        break;
      case 209: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy140 = createIndexOption(pCxt, yymsp[-8].minor.yy220, releaseRawExprNode(pCxt, yymsp[-4].minor.yy140), releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), yymsp[0].minor.yy140); }
        break;
      case 212: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy140 = createFunctionNode(pCxt, &yymsp[-3].minor.yy253, yymsp[-1].minor.yy220); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 213: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy273, &yymsp[-2].minor.yy253, yymsp[0].minor.yy140, NULL); }
        break;
      case 214: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy273, &yymsp[-2].minor.yy253, NULL, &yymsp[0].minor.yy253); }
        break;
      case 215: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy273, &yymsp[0].minor.yy253); }
        break;
      case 216: /* cmd ::= DESC full_table_name */
      case 217: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==217);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy140); }
        break;
      case 218: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 219: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy273, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 221: /* analyze_opt ::= ANALYZE */
      case 229: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==229);
      case 350: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==350);
{ yymsp[0].minor.yy273 = true; }
        break;
      case 222: /* explain_options ::= */
{ yymsp[1].minor.yy140 = createDefaultExplainOptions(pCxt); }
        break;
      case 223: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy140 = setExplainVerbose(pCxt, yymsp[-2].minor.yy140, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 224: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy140 = setExplainRatio(pCxt, yymsp[-2].minor.yy140, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 225: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy220); }
        break;
      case 226: /* cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy273, &yymsp[-5].minor.yy253, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy368, yymsp[0].minor.yy528); }
        break;
      case 227: /* cmd ::= DROP FUNCTION function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, &yymsp[0].minor.yy253); }
        break;
      case 230: /* bufsize_opt ::= */
{ yymsp[1].minor.yy528 = 0; }
        break;
      case 231: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy528 = strtol(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 232: /* cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, &yymsp[-4].minor.yy253, &yymsp[-2].minor.yy253, yymsp[0].minor.yy140); }
        break;
      case 233: /* cmd ::= DROP STREAM stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, &yymsp[0].minor.yy253); }
        break;
      case 234: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 235: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 236: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 237: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy220); }
        break;
      case 238: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 239: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy220 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 241: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy253); }
        break;
      case 243: /* literal ::= NK_INTEGER */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 244: /* literal ::= NK_FLOAT */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 245: /* literal ::= NK_STRING */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 246: /* literal ::= NK_BOOL */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 247: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 248: /* literal ::= duration_literal */
      case 257: /* signed_literal ::= signed */ yytestcase(yyruleno==257);
      case 277: /* expression ::= literal */ yytestcase(yyruleno==277);
      case 278: /* expression ::= pseudo_column */ yytestcase(yyruleno==278);
      case 279: /* expression ::= column_reference */ yytestcase(yyruleno==279);
      case 283: /* expression ::= subquery */ yytestcase(yyruleno==283);
      case 323: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==323);
      case 327: /* boolean_primary ::= predicate */ yytestcase(yyruleno==327);
      case 329: /* common_expression ::= expression */ yytestcase(yyruleno==329);
      case 330: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==330);
      case 332: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==332);
      case 334: /* table_reference ::= table_primary */ yytestcase(yyruleno==334);
      case 335: /* table_reference ::= joined_table */ yytestcase(yyruleno==335);
      case 339: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==339);
      case 386: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==386);
      case 388: /* query_primary ::= query_specification */ yytestcase(yyruleno==388);
{ yylhsminor.yy140 = yymsp[0].minor.yy140; }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 249: /* literal ::= NULL */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 250: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 251: /* signed ::= NK_INTEGER */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 252: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 253: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 254: /* signed ::= NK_FLOAT */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 255: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 256: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 258: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 259: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 260: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 261: /* signed_literal ::= duration_literal */
      case 356: /* select_item ::= common_expression */ yytestcase(yyruleno==356);
      case 400: /* search_condition ::= common_expression */ yytestcase(yyruleno==400);
{ yylhsminor.yy140 = releaseRawExprNode(pCxt, yymsp[0].minor.yy140); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 262: /* signed_literal ::= NULL */
{ yymsp[0].minor.yy140 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL); }
        break;
      case 280: /* expression ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy253, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy253, yymsp[-1].minor.yy220)); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 281: /* expression ::= function_name NK_LP NK_STAR NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy253, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy253, createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy0)))); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 282: /* expression ::= function_name NK_LP expression AS type_name NK_RP */
{
                                                                                    SNodeList *p = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140));
                                                                                    p = addValueNodeFromTypeToList(pCxt, yymsp[-1].minor.yy368, p);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy253, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-5].minor.yy253, p));
                                                                                  }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 284: /* expression ::= NK_LP expression NK_RP */
      case 328: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==328);
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 285: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy140));
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 286: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy140), NULL));
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 287: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 288: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 289: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 290: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 291: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); 
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 292: /* expression_list ::= expression */
{ yylhsminor.yy220 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 293: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, releaseRawExprNode(pCxt, yymsp[0].minor.yy140)); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 294: /* column_reference ::= column_name */
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy253, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy253)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 295: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy253, &yymsp[0].minor.yy253, createColumnNode(pCxt, &yymsp[-2].minor.yy253, &yymsp[0].minor.yy253)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 296: /* pseudo_column ::= NOW */
      case 297: /* pseudo_column ::= ROWTS */ yytestcase(yyruleno==297);
      case 298: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==298);
      case 299: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==299);
      case 300: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==300);
      case 301: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==301);
      case 302: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==302);
      case 303: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==303);
{ yylhsminor.yy140 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy140 = yylhsminor.yy140;
        break;
      case 304: /* predicate ::= expression compare_op expression */
      case 309: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==309);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy480, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 305: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy140), releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-4].minor.yy140 = yylhsminor.yy140;
        break;
      case 306: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[-5].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 307: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), NULL));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 308: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), NULL));
                                                                                  }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 310: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy480 = OP_TYPE_LOWER_THAN; }
        break;
      case 311: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy480 = OP_TYPE_GREATER_THAN; }
        break;
      case 312: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy480 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 313: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy480 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 314: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy480 = OP_TYPE_NOT_EQUAL; }
        break;
      case 315: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy480 = OP_TYPE_EQUAL; }
        break;
      case 316: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy480 = OP_TYPE_LIKE; }
        break;
      case 317: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy480 = OP_TYPE_NOT_LIKE; }
        break;
      case 318: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy480 = OP_TYPE_MATCH; }
        break;
      case 319: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy480 = OP_TYPE_NMATCH; }
        break;
      case 320: /* in_op ::= IN */
{ yymsp[0].minor.yy480 = OP_TYPE_IN; }
        break;
      case 321: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy480 = OP_TYPE_NOT_IN; }
        break;
      case 322: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy220)); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 324: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy140), NULL));
                                                                                  }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 325: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 326: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy140);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy140);
                                                                                    yylhsminor.yy140 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), releaseRawExprNode(pCxt, yymsp[0].minor.yy140)));
                                                                                  }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 331: /* from_clause ::= FROM table_reference_list */
      case 361: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==361);
      case 384: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==384);
{ yymsp[-1].minor.yy140 = yymsp[0].minor.yy140; }
        break;
      case 333: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy140 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy140, yymsp[0].minor.yy140, NULL); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 336: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy140 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy253, &yymsp[0].minor.yy253); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 337: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy140 = createRealTableNode(pCxt, &yymsp[-3].minor.yy253, &yymsp[-1].minor.yy253, &yymsp[0].minor.yy253); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 338: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy140 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140), &yymsp[0].minor.yy253); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 340: /* alias_opt ::= */
{ yymsp[1].minor.yy253 = nil_token;  }
        break;
      case 341: /* alias_opt ::= table_alias */
{ yylhsminor.yy253 = yymsp[0].minor.yy253; }
  yymsp[0].minor.yy253 = yylhsminor.yy253;
        break;
      case 342: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy253 = yymsp[0].minor.yy253; }
        break;
      case 343: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 344: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==344);
{ yymsp[-2].minor.yy140 = yymsp[-1].minor.yy140; }
        break;
      case 345: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy140 = createJoinTableNode(pCxt, yymsp[-4].minor.yy224, yymsp[-5].minor.yy140, yymsp[-2].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-5].minor.yy140 = yylhsminor.yy140;
        break;
      case 346: /* join_type ::= */
{ yymsp[1].minor.yy224 = JOIN_TYPE_INNER; }
        break;
      case 347: /* join_type ::= INNER */
{ yymsp[0].minor.yy224 = JOIN_TYPE_INNER; }
        break;
      case 348: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy140 = createSelectStmt(pCxt, yymsp[-7].minor.yy273, yymsp[-6].minor.yy220, yymsp[-5].minor.yy140);
                                                                                    yymsp[-8].minor.yy140 = addWhereClause(pCxt, yymsp[-8].minor.yy140, yymsp[-4].minor.yy140);
                                                                                    yymsp[-8].minor.yy140 = addPartitionByClause(pCxt, yymsp[-8].minor.yy140, yymsp[-3].minor.yy220);
                                                                                    yymsp[-8].minor.yy140 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy140, yymsp[-2].minor.yy140);
                                                                                    yymsp[-8].minor.yy140 = addGroupByClause(pCxt, yymsp[-8].minor.yy140, yymsp[-1].minor.yy220);
                                                                                    yymsp[-8].minor.yy140 = addHavingClause(pCxt, yymsp[-8].minor.yy140, yymsp[0].minor.yy140);
                                                                                  }
        break;
      case 351: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy273 = false; }
        break;
      case 352: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy220 = NULL; }
        break;
      case 357: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy140 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140), &yymsp[0].minor.yy253); }
  yymsp[-1].minor.yy140 = yylhsminor.yy140;
        break;
      case 358: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy140 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), &yymsp[0].minor.yy253); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 359: /* select_item ::= table_name NK_DOT NK_STAR */
{ yylhsminor.yy140 = createColumnNode(pCxt, &yymsp[-2].minor.yy253, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 363: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 380: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==380);
      case 390: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==390);
{ yymsp[-2].minor.yy220 = yymsp[0].minor.yy220; }
        break;
      case 365: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy140 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
        break;
      case 366: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy140 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy140)); }
        break;
      case 367: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy140 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), NULL, yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 368: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy140 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy140), releaseRawExprNode(pCxt, yymsp[-3].minor.yy140), yymsp[-1].minor.yy140, yymsp[0].minor.yy140); }
        break;
      case 370: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy140 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy140); }
        break;
      case 372: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy140 = createFillNode(pCxt, yymsp[-1].minor.yy174, NULL); }
        break;
      case 373: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy140 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy220)); }
        break;
      case 374: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy174 = FILL_MODE_NONE; }
        break;
      case 375: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy174 = FILL_MODE_PREV; }
        break;
      case 376: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy174 = FILL_MODE_NULL; }
        break;
      case 377: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy174 = FILL_MODE_LINEAR; }
        break;
      case 378: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy174 = FILL_MODE_NEXT; }
        break;
      case 381: /* group_by_list ::= expression */
{ yylhsminor.yy220 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); }
  yymsp[0].minor.yy220 = yylhsminor.yy220;
        break;
      case 382: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy220 = addNodeToList(pCxt, yymsp[-2].minor.yy220, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy140))); }
  yymsp[-2].minor.yy220 = yylhsminor.yy220;
        break;
      case 385: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy140 = addOrderByClause(pCxt, yymsp[-3].minor.yy140, yymsp[-2].minor.yy220);
                                                                                    yylhsminor.yy140 = addSlimitClause(pCxt, yylhsminor.yy140, yymsp[-1].minor.yy140);
                                                                                    yylhsminor.yy140 = addLimitClause(pCxt, yylhsminor.yy140, yymsp[0].minor.yy140);
                                                                                  }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 387: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy140 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy140, yymsp[0].minor.yy140); }
  yymsp[-3].minor.yy140 = yylhsminor.yy140;
        break;
      case 392: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 396: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==396);
{ yymsp[-1].minor.yy140 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 393: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 397: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==397);
{ yymsp[-3].minor.yy140 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 394: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 398: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==398);
{ yymsp[-3].minor.yy140 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 399: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy140 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy140); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 403: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy140 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy140), yymsp[-1].minor.yy238, yymsp[0].minor.yy69); }
  yymsp[-2].minor.yy140 = yylhsminor.yy140;
        break;
      case 404: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy238 = ORDER_ASC; }
        break;
      case 405: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy238 = ORDER_ASC; }
        break;
      case 406: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy238 = ORDER_DESC; }
        break;
      case 407: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy69 = NULL_ORDER_DEFAULT; }
        break;
      case 408: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy69 = NULL_ORDER_FIRST; }
        break;
      case 409: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy69 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (pCxt->valid) {
    if(TOKEN.z) {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
    pCxt->valid = false;
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
