/*
 * Decompiled with CFR 0.152.
 */
package com.taosdata.jdbc.rs;

import com.taosdata.jdbc.AbstractDatabaseMetaData;
import com.taosdata.jdbc.CatalogResultSet;
import com.taosdata.jdbc.ColumnMetaData;
import com.taosdata.jdbc.DatabaseMetaDataResultSet;
import com.taosdata.jdbc.EmptyResultSet;
import com.taosdata.jdbc.GetTablesResultSet;
import com.taosdata.jdbc.TSDBConstants;
import com.taosdata.jdbc.TSDBResultSetRowData;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class RestfulDatabaseMetaData
extends AbstractDatabaseMetaData {
    private final String url;
    private final String userName;
    private final Connection connection;

    public RestfulDatabaseMetaData(String url, String userName, Connection connection) {
        this.url = url;
        this.userName = userName;
        this.connection = connection;
    }

    @Override
    public String getURL() throws SQLException {
        return this.url;
    }

    @Override
    public String getUserName() throws SQLException {
        return this.userName;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return null;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return null;
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return null;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        Statement stmt = null;
        if (null != this.connection && !this.connection.isClosed()) {
            stmt = this.connection.createStatement();
            if (catalog == null || catalog.length() < 1) {
                catalog = this.connection.getCatalog();
            }
            stmt.executeUpdate("use " + catalog);
            ResultSet resultSet0 = stmt.executeQuery("show tables");
            GetTablesResultSet getTablesResultSet = new GetTablesResultSet(resultSet0, catalog, schemaPattern, tableNamePattern, types);
            return getTablesResultSet;
        }
        throw new SQLException(TSDBConstants.FixErrMsg(-2));
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        if (this.connection != null && !this.connection.isClosed()) {
            Statement stmt = this.connection.createStatement();
            ResultSet resultSet0 = stmt.executeQuery("show databases");
            CatalogResultSet resultSet = new CatalogResultSet(resultSet0);
            return resultSet;
        }
        return new EmptyResultSet();
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        Statement stmt = null;
        if (null != this.connection && !this.connection.isClosed()) {
            stmt = this.connection.createStatement();
            if (catalog == null || catalog.length() < 1) {
                catalog = this.connection.getCatalog();
            }
            stmt.execute("use " + catalog);
            DatabaseMetaDataResultSet resultSet = new DatabaseMetaDataResultSet();
            ArrayList<ColumnMetaData> columnMetaDataList = new ArrayList<ColumnMetaData>(24);
            columnMetaDataList.add(null);
            columnMetaDataList.add(null);
            ColumnMetaData colMetaData = new ColumnMetaData();
            colMetaData.setColIndex(3);
            colMetaData.setColName("TABLE_NAME");
            colMetaData.setColSize(193);
            colMetaData.setColType(8);
            columnMetaDataList.add(colMetaData);
            colMetaData = new ColumnMetaData();
            colMetaData.setColIndex(4);
            colMetaData.setColName("COLUMN_NAME");
            colMetaData.setColSize(65);
            colMetaData.setColType(8);
            columnMetaDataList.add(colMetaData);
            colMetaData = new ColumnMetaData();
            colMetaData.setColIndex(5);
            colMetaData.setColName("DATA_TYPE");
            colMetaData.setColType(4);
            columnMetaDataList.add(colMetaData);
            colMetaData = new ColumnMetaData();
            colMetaData.setColIndex(6);
            colMetaData.setColName("TYPE_NAME");
            colMetaData.setColType(8);
            columnMetaDataList.add(colMetaData);
            colMetaData = new ColumnMetaData();
            colMetaData.setColIndex(7);
            colMetaData.setColName("COLUMN_SIZE");
            colMetaData.setColType(4);
            columnMetaDataList.add(colMetaData);
            columnMetaDataList.add(null);
            colMetaData = new ColumnMetaData();
            colMetaData.setColIndex(9);
            colMetaData.setColName("DECIMAL_DIGITS");
            colMetaData.setColType(4);
            columnMetaDataList.add(colMetaData);
            colMetaData = new ColumnMetaData();
            colMetaData.setColIndex(10);
            colMetaData.setColName("NUM_PREC_RADIX");
            colMetaData.setColType(4);
            columnMetaDataList.add(colMetaData);
            colMetaData = new ColumnMetaData();
            colMetaData.setColIndex(11);
            colMetaData.setColName("NULLABLE");
            colMetaData.setColType(4);
            columnMetaDataList.add(colMetaData);
            resultSet.setColumnMetaDataList(columnMetaDataList);
            ResultSet resultSet0 = stmt.executeQuery("describe " + tableNamePattern);
            ArrayList<TSDBResultSetRowData> rowDataList = new ArrayList<TSDBResultSetRowData>();
            int index = 0;
            while (resultSet0.next()) {
                TSDBResultSetRowData rowData = new TSDBResultSetRowData(24);
                rowData.setString(2, tableNamePattern);
                rowData.setString(3, resultSet0.getString(1));
                String typeName = resultSet0.getString(2);
                rowData.setInt(4, this.getDataType(typeName));
                rowData.setString(5, typeName);
                int length = resultSet0.getInt(3);
                rowData.setInt(6, this.getColumnSize(typeName, length));
                rowData.setInt(8, this.getDecimalDigits(typeName));
                rowData.setInt(9, 10);
                rowData.setInt(10, this.getNullable(index, typeName));
                rowDataList.add(rowData);
                ++index;
            }
            resultSet.setRowDataList(rowDataList);
            return resultSet;
        }
        throw new SQLException(TSDBConstants.FixErrMsg(-2));
    }

    @Override
    public long getMaxLogicalLobSize() throws SQLException {
        return 0L;
    }

    @Override
    public boolean supportsRefCursors() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }
}

