/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 449
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy14;
  bool yy39;
  SToken yy181;
  EJoinType yy202;
  int32_t yy276;
  SNodeList* yy282;
  int8_t yy293;
  ENullOrder yy305;
  SDataType yy380;
  EFillMode yy381;
  SAlterOption yy645;
  EOperatorType yy682;
  SNode* yy778;
  int64_t yy831;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             693
#define YYNRULE              521
#define YYNTOKEN             317
#define YY_MAX_SHIFT         692
#define YY_MIN_SHIFTREDUCE   1022
#define YY_MAX_SHIFTREDUCE   1542
#define YY_ERROR_ACTION      1543
#define YY_ACCEPT_ACTION     1544
#define YY_NO_ACTION         1545
#define YY_MIN_REDUCE        1546
#define YY_MAX_REDUCE        2066
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2993)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1868, 1797,  447, 1868,  448, 1581,  455, 1882,  448, 1581,
 /*    10 */  1684, 1864,   44,   42, 1864,  354,  544,  394, 1738, 1740,
 /*    20 */   349, 1864, 1323,   43,   41,   40,   39,   38,   52, 2042,
 /*    30 */    34,  267,  585, 1403, 1348, 1321, 1900, 1860, 1866,  337,
 /*    40 */  1860, 1866,  343, 1349,  586, 1693, 1350, 1860, 1866, 1850,
 /*    50 */   592,  598,   30,  592, 1671,  310, 1398, 1055,   37,   36,
 /*    60 */   592,   17,   43,   41,   40,   39,   38, 1882, 1329,   44,
 /*    70 */    42, 1473, 1880,   40,   39,   38, 1916,  349,  570, 1323,
 /*    80 */    97, 1881, 1883,  602, 1885, 1886,  597, 1072,  592, 1071,
 /*    90 */  1403,   62, 1321,  168,    1, 1969, 1900, 1059, 1060,  342,
 /*   100 */  1965,   77,  483,  464,  599,  582,   46, 2037,   58, 1850,
 /*   110 */   585,  598,  173, 1398,  464,  125,  689, 1073,   17,  531,
 /*   120 */  1995, 1532,  569,  171, 1688, 1329,  334, 2038,  571, 1794,
 /*   130 */  1405, 1406,  600,  585,  132,  181, 1916, 1547,  154,  227,
 /*   140 */    98,  348, 1883,  602, 1885, 1886,  597, 1696,  592, 1900,
 /*   150 */  1072,    1, 1071, 1217, 1218, 1969,   58,  564,  109,  314,
 /*   160 */  1965,  108,  107,  106,  105,  104,  103,  102,  101,  100,
 /*   170 */  2037,  130,   74,  689,   58,   73, 1324,   58, 1322,   81,
 /*   180 */  1073,   58, 1669, 1569,   46,  569,  171, 1405, 1406,  266,
 /*   190 */  2038,  571,  584,  169, 1977, 1978,  563, 1982, 1739, 1740,
 /*   200 */  1327, 1328,  635, 1378, 1379, 1381, 1382, 1383, 1384, 1385,
 /*   210 */  1386, 1387, 1388,  594,  590, 1396, 1397, 1399, 1400, 1401,
 /*   220 */  1402, 1404, 1407,    3,  205, 1850,  233,  234, 1349,  633,
 /*   230 */   582,  159,  325, 1324, 1477, 1322, 1650,  387,  161,  386,
 /*   240 */  1348,  174,  635,  481,  477,  473,  469,  204,  145,  144,
 /*   250 */   630,  629,  628,  174,  156,  174, 1558, 1327, 1328,  132,
 /*   260 */  1378, 1379, 1381, 1382, 1383, 1384, 1385, 1386, 1387, 1388,
 /*   270 */   594,  590, 1396, 1397, 1399, 1400, 1401, 1402, 1404, 1407,
 /*   280 */     3,   44,   42,  219,   78,  312,  167,  202,  534,  349,
 /*   290 */   335, 1323,  326, 1568,  324,  323,  130,  487,  154, 1732,
 /*   300 */   582,  489, 1403,  174, 1321, 1567,  109, 1695, 1348,  108,
 /*   310 */   107,  106,  105,  104,  103,  102,  101,  100,  170, 1977,
 /*   320 */  1978,  174, 1982,  488,  174, 1398,  565, 1745,  174,  132,
 /*   330 */    17, 1869,  560, 1882,  336, 1850,  232, 1329,   44,   42,
 /*   340 */    79,  312, 1864, 1743,  534, 1787,  349, 1850, 1323,  582,
 /*   350 */   201,  195,   47,  200,  452,  544,  179,  460,   94, 1403,
 /*   360 */  1346, 1321, 1900,    1,  544, 1413,  130,  119, 1860, 1866,
 /*   370 */   586, 1348,  127,  193,  485, 1850,  119,  598,  132, 1745,
 /*   380 */  1685,  592, 1398,  490, 1693,  689,  353,   17,  172, 1977,
 /*   390 */  1978,  395, 1982, 1693, 1329, 1743, 1301, 1302, 1880, 1405,
 /*   400 */  1406, 1499, 1916, 1546,  396,  352,   97, 1881, 1883,  602,
 /*   410 */  1885, 1886,  597,  154,  592,  121, 1135,  566,  561,  168,
 /*   420 */     1, 1969, 1695, 1434, 1380,  342, 1965,  118,  117,  116,
 /*   430 */   115,  114,  113,  112,  111,  110, 2042,  264, 1977,  581,
 /*   440 */   432,  580,  689,   77, 2037, 1324, 1996, 1322,  511, 1137,
 /*   450 */   355,  557, 1497, 1498, 1500, 1501, 1405, 1406,  154,  569,
 /*   460 */   171,  509, 1350,  507, 2038,  571, 1689, 1695, 1347, 1327,
 /*   470 */  1328, 1670, 1378, 1379, 1381, 1382, 1383, 1384, 1385, 1386,
 /*   480 */  1387, 1388,  594,  590, 1396, 1397, 1399, 1400, 1401, 1402,
 /*   490 */  1404, 1407,    3,   31,   11,  446,  185,  184,  450,  174,
 /*   500 */   494,  493, 1324, 1439, 1322, 1329, 1175,  624,  623,  622,
 /*   510 */  1179,  621, 1181, 1182,  620, 1184,  617, 1566, 1190,  614,
 /*   520 */  1192, 1193,  611,  608, 1984, 2042, 1327, 1328, 1532, 1378,
 /*   530 */  1379, 1381, 1382, 1383, 1384, 1385, 1386, 1387, 1388,  594,
 /*   540 */   590, 1396, 1397, 1399, 1400, 1401, 1402, 1404, 1407,    3,
 /*   550 */    44,   42, 1981,  544, 2037, 1380,  660,  658,  349, 1850,
 /*   560 */  1323,   11, 1332,    9,  544,  176,  544,  627, 1565,  454,
 /*   570 */  2041, 1403,  450, 1321, 2038, 2040,  392,  633,  393, 1564,
 /*   580 */    37,   36, 1693, 1882,   43,   41,   40,   39,   38,  544,
 /*   590 */    13,   12, 1351, 1693, 1398, 1693,  145,  144,  630,  629,
 /*   600 */   628,  403, 1882, 1668,  544,  266, 1329,   44,   42, 1408,
 /*   610 */  1850,  544, 1900, 1563,  544,  349,  417, 1323, 1693, 1984,
 /*   620 */   599, 1850, 1745,  418, 1562, 1850,  462,  598, 1403, 1745,
 /*   630 */  1321, 1900,    8, 1693,   11,  546,  319, 1941, 1744,  599,
 /*   640 */  1693,  544,  226, 1693, 1850, 1743,  598, 1980,  600, 1561,
 /*   650 */    87, 1398, 1916,  463,  689, 1850,  294,  348, 1883,  602,
 /*   660 */  1885, 1886,  597, 1329,  592,  647, 1850, 1880, 1405, 1406,
 /*   670 */  1693, 1916, 1686, 1560,  570,   97, 1881, 1883,  602, 1885,
 /*   680 */  1886,  597,   80,  592, 1446, 1793, 2037,  307, 2057,    8,
 /*   690 */  1969, 1850,   37,   36,  342, 1965,   43,   41,   40,   39,
 /*   700 */    38,  569,  171, 2037, 2003, 1335, 2038,  571,  544,  633,
 /*   710 */   548,  689, 1941,  383, 1324, 1850, 1322, 1544,  569,  171,
 /*   720 */   356, 1059, 1060, 2038,  571, 1405, 1406,   26,  145,  144,
 /*   730 */   630,  629,  628,  385,  381,  243, 1557, 1693, 1327, 1328,
 /*   740 */  1682, 1378, 1379, 1381, 1382, 1383, 1384, 1385, 1386, 1387,
 /*   750 */  1388,  594,  590, 1396, 1397, 1399, 1400, 1401, 1402, 1404,
 /*   760 */  1407,    3,   37,   36,  544, 1678,   43,   41,   40,   39,
 /*   770 */    38, 1324,  220, 1322, 1787, 1723, 1690,  364, 1850,  174,
 /*   780 */  2041, 1351,   37,   36, 1556,  180,   43,   41,   40,   39,
 /*   790 */    38, 1611, 1555, 1693,  527, 1327, 1328,    7, 1378, 1379,
 /*   800 */  1381, 1382, 1383, 1384, 1385, 1386, 1387, 1388,  594,  590,
 /*   810 */  1396, 1397, 1399, 1400, 1401, 1402, 1404, 1407,    3,   44,
 /*   820 */    42,  544, 1323, 2037, 1554, 1553, 1850,  349,  574, 1323,
 /*   830 */  1552,  531, 1680,  137, 1850, 1321,  544, 1099, 2043,  171,
 /*   840 */  1403, 1795, 1321, 2038,  571, 1676, 1551,   32,  523, 1509,
 /*   850 */  1693, 1470, 1882,   37,   36,  497,  496,   43,   41,   40,
 /*   860 */    39,   38,  126, 1398, 1550, 1693, 1850, 1850, 1329, 2042,
 /*   870 */  1100, 1882, 1850,  492,  495, 1329,   44,   42,  544,  491,
 /*   880 */   544, 1900, 1984,  544,  349, 1792, 1323,  307, 1850,  599,
 /*   890 */   528, 1787,  237,  544, 1850,  540,  598, 1403, 2037, 1321,
 /*   900 */  1900,    8,  183, 1989, 1466,  542, 1850, 1693,  599, 1693,
 /*   910 */  1979, 1348, 1693, 1850, 2041,  598,  689, 1880, 2038, 2039,
 /*   920 */  1398, 1916, 1693,  689,  242,  157, 1881, 1883,  602, 1885,
 /*   930 */  1886,  597, 1329,  592,  489,  223, 1880, 1405, 1406, 1549,
 /*   940 */  1916,  544, 1539,  544,   97, 1881, 1883,  602, 1885, 1886,
 /*   950 */   597,  128,  592,  543, 1940,  268,  488, 2057,    1, 1969,
 /*   960 */   648,  593, 1663,  342, 1965,  631,  549, 2006, 1736,  522,
 /*   970 */  1693,  632, 1693, 2031, 1736, 1598, 1324,  626, 1322,  279,
 /*   980 */   689, 1850, 1723, 1324,  143, 1322,   48,    4,  210,  402,
 /*   990 */   212,  208,   45,  211, 1405, 1406,  214,  498, 1466,  213,
 /*  1000 */  1327, 1328, 1837,  216,   50,  526,  215, 1327, 1328, 1593,
 /*  1010 */  1378, 1379, 1381, 1382, 1383, 1384, 1385, 1386, 1387, 1388,
 /*  1020 */   594,  590, 1396, 1397, 1399, 1400, 1401, 1402, 1404, 1407,
 /*  1030 */     3,  500, 1541, 1542,  577,  573,   51, 1538,   72, 1331,
 /*  1040 */  1324,  231, 1322, 1559, 1272,  575,   37,   36,  589,  371,
 /*  1050 */    43,   41,   40,   39,   38,   37,   36,  138, 2009,   43,
 /*  1060 */    41,   40,   39,   38, 1327, 1328, 1608, 1378, 1379, 1381,
 /*  1070 */  1382, 1383, 1384, 1385, 1386, 1387, 1388,  594,  590, 1396,
 /*  1080 */  1397, 1399, 1400, 1401, 1402, 1404, 1407,    3,  309, 1469,
 /*  1090 */  1346,   13,   12,  235,   93, 1380, 1591,  425,  261,  558,
 /*  1100 */   437,  641,  642, 1651,   90,  482,   37,   36,  142,  537,
 /*  1110 */    43,   41,   40,   39,   38,  143,   60,  410,  503,  438,
 /*  1120 */   247,  412,   60, 1119, 1117, 1587,  255,   45, 1901,  666,
 /*  1130 */   665,  664,  663,  359,   45,  662,  661,  133,  656,  655,
 /*  1140 */   654,  653,  652,  651,  650,  649,  147,  645,  644,  643,
 /*  1150 */   358,  357,  640,  639,  638,  637,  636,  155,  360, 1582,
 /*  1160 */   239, 1999,  285,  322, 1733,  583,  263, 1168, 1496,  260,
 /*  1170 */     2,    5,  250,  684, 1440,  398,  283,   66,  388, 1389,
 /*  1180 */    65,  365, 1334, 1871,  606,  142,  278, 1424,  275,  143,
 /*  1190 */   370,  122,  320, 1489,  142,  527,  189,  443,  441, 1288,
 /*  1200 */   182,  153,  397,  436,  401, 1882,  431,  430,  429,  428,
 /*  1210 */   427,  424,  423,  422,  421,  420,  416,  415,  414,  413,
 /*  1220 */   407,  406,  405,  404, 2037,  400,  399,  321, 1346,  419,
 /*  1230 */   426, 1873, 1789,   58, 1900,  433, 1196, 1200,  434, 2043,
 /*  1240 */   171, 1207,  599, 1205, 2038,  571,  146, 1850,  435,  598,
 /*  1250 */   440,   37,   36,  578,  439,   43,   41,   40,   39,   38,
 /*  1260 */   186, 1352,  442,  444,  445,  453, 1354,  457,  192,  456,
 /*  1270 */  1880,   96,  194, 1353, 1916,  458, 1355,  197,   97, 1881,
 /*  1280 */  1883,  602, 1885, 1886,  597,  459,  592,  497,  496,  129,
 /*  1290 */   461,  141, 1940, 1969,  126,  199,   75,  342, 1965,   76,
 /*  1300 */   465,  530,  203,  362,  315,  492,  495,   71,   70,  391,
 /*  1310 */   361,  491,  178,  120,  484,  486, 1882, 1683,  527,  311,
 /*  1320 */   527, 1828,  207, 1679,  514,  209,  148,  527,  149,  308,
 /*  1330 */  1681, 1677,  379,  276,  377,  373,  369,  366,  363,  150,
 /*  1340 */   516,  221,  151,  518,  517, 1900, 1432, 2037,  224, 2037,
 /*  1350 */   521,  524,  529,  599,  331,  556, 2037,  228, 1850,  538,
 /*  1360 */   598,  515, 2043,  171, 2043,  171,  139, 2038,  571, 2038,
 /*  1370 */   571, 2043,  171,  140,  532, 1827, 2038,  571,  527, 1799,
 /*  1380 */   174, 1880,  535,  333,   84, 1916,  539,  277,   86,   97,
 /*  1390 */  1881, 1883,  602, 1885, 1886,  597, 1694,  592, 1351, 2000,
 /*  1400 */  2010, 1433, 2057,  552, 1969,  559,  245, 2037,  342, 1965,
 /*  1410 */   692,  554, 2015,  555,  338,  249,    6, 2014, 1988,  562,
 /*  1420 */   254, 1882, 2043,  171,  274,  568,  553, 2038,  571,  551,
 /*  1430 */   550, 1991,  162,  256,  339,  259,  579,  257,  165,  576,
 /*  1440 */  1466,  258,  131,  682,  678,  674,  670,  272, 1350,   57,
 /*  1450 */  1900, 1985,   88,  604, 2060, 1950, 1737, 1664,  599,  280,
 /*  1460 */   271, 2036,  685, 1850, 1882,  598,   49,  262,  686,  688,
 /*  1470 */   306,   33,  346, 1427, 1428, 1429, 1430, 1431, 1435, 1436,
 /*  1480 */  1437, 1438,  284,  292,   95,  282, 1880,  240, 1844, 1843,
 /*  1490 */  1916,   68,  303, 1900,   97, 1881, 1883,  602, 1885, 1886,
 /*  1500 */   597,  599,  592,  302, 1842, 1841, 1850, 1944,  598, 1969,
 /*  1510 */    69,  345,  344,  342, 1965, 1838,  367, 1882,  368, 1315,
 /*  1520 */   541, 1337, 1316,  372, 1836,  177,  374,  375,  376, 1880,
 /*  1530 */  1835,  378, 1403, 1916, 1330, 1834,  380,   97, 1881, 1883,
 /*  1540 */   602, 1885, 1886,  597,  384,  592, 1900, 1833,  382, 1832,
 /*  1550 */  1942, 1291, 1969,  229,  599, 1398,  342, 1965, 1290, 1850,
 /*  1560 */  1810,  598, 1809, 1808,  389,  390, 1807, 1329, 1782, 1260,
 /*  1570 */  1882, 1295, 1781,  222, 1779,  134, 1778, 1777, 1780,  135,
 /*  1580 */  1776, 1775, 1880, 1774, 1773, 1772, 1916, 1771,  408,  409,
 /*  1590 */    97, 1881, 1883,  602, 1885, 1886,  597, 1770,  592, 1900,
 /*  1600 */   411, 1769, 1768,  547, 1262, 1969, 1767,  599, 1766,  342,
 /*  1610 */  1965, 1765, 1850, 1882,  598,  588, 1764, 1763, 1762, 1761,
 /*  1620 */  1760, 1759, 1758, 1757, 1756, 1755, 1754, 1753,  136, 1752,
 /*  1630 */  1751, 1750, 1749, 1748, 1747, 1880, 1746, 1613, 1143, 1916,
 /*  1640 */  1612, 1610, 1900,   98, 1881, 1883,  602, 1885, 1886,  597,
 /*  1650 */   599,  592,  187, 1578,  188, 1850,  190,  598, 1969, 1062,
 /*  1660 */  1061,  449, 1968, 1965,  198, 1805, 1882,  123, 1577, 1823,
 /*  1670 */  1817, 1806, 1791, 1672,  124, 1338, 1609, 1333, 1880, 1607,
 /*  1680 */  1605,  166, 1916,  191,  466,  451,   98, 1881, 1883,  602,
 /*  1690 */  1885, 1886,  597,  196,  592, 1900,  468,  467,  470, 1341,
 /*  1700 */  1343, 1969,  471,  596, 1092,  587, 1965, 1603, 1850,  474,
 /*  1710 */   598, 1601, 1590,  590, 1396, 1397, 1399, 1400, 1401, 1402,
 /*  1720 */   472,  476, 1882,  478,  475,  479,  480, 1589, 1574, 1674,
 /*  1730 */  1211, 1880, 1210, 1673, 1134, 1916, 1133,  657, 1130,  300,
 /*  1740 */  1881, 1883,  602, 1885, 1886,  597,  595,  592,  545, 1934,
 /*  1750 */  1129, 1900,  659,  206,   59, 1599, 1128,  327, 1594,  599,
 /*  1760 */   328, 1592,  501,  329, 1850,  504,  598, 1573, 1572, 1571,
 /*  1770 */   510,   99,  506, 1822,  508,   53, 1816, 1297, 1307,   25,
 /*  1780 */  1804,  519, 1802, 1803, 1882,   18,  152, 1880, 1801,  502,
 /*  1790 */  2042, 1916, 1800,  230, 1798,  158, 1881, 1883,  602, 1885,
 /*  1800 */  1886,  597,  236,  592,  512, 1305, 1790,  520,  225,   90,
 /*  1810 */    82,   83,  241, 1900,   85, 1415,   10,   19,  218,  330,
 /*  1820 */   536,  599,   20,  525, 1414,  238, 1850, 1511,  598,   56,
 /*  1830 */   253,   61,  505,   15,   27, 1871,  499,  244,  252,  246,
 /*  1840 */  1493,  217, 1882,  248,   29, 1495,  160,  572, 2058, 1880,
 /*  1850 */   533,  251,   22, 1916,   28,   21,   89,   98, 1881, 1883,
 /*  1860 */   602, 1885, 1886,  597, 1882,  592, 1488, 1526, 1525,  340,
 /*  1870 */  1531, 1900, 1969, 1532, 1530, 1529,  332, 1966,   64,  599,
 /*  1880 */   341,   63,  265, 1870, 1850, 1463,  598,   55, 1462,  163,
 /*  1890 */    12, 1339, 1425, 1900, 1919,  164,  175, 1393,  591,   35,
 /*  1900 */    54,  596, 1391, 1390,   14,   16, 1850, 1880,  598,   23,
 /*  1910 */    24, 1916, 1363, 1371, 1197,  301, 1881, 1883,  602, 1885,
 /*  1920 */  1886,  597,  605,  592, 1882,  601,  603,  351,  609, 1880,
 /*  1930 */  1194,  612,  607, 1916,  615,  610,  613,  300, 1881, 1883,
 /*  1940 */   602, 1885, 1886,  597,  618,  592, 1191, 1935, 1185,  616,
 /*  1950 */  1174, 1183,  619, 1900,  625,   91,   92, 1206,   67,  269,
 /*  1960 */  1202,  599, 1090,  634, 1189, 1188, 1850, 1882,  598, 1125,
 /*  1970 */  1187, 1124, 1186, 1141, 1123, 1122, 1121, 1120, 1118, 1116,
 /*  1980 */  1115, 1114, 1110, 1108, 1882,  646, 1112, 1111, 1109, 1880,
 /*  1990 */   270, 1107, 1106, 1916, 1105, 1138, 1900,  157, 1881, 1883,
 /*  2000 */   602, 1885, 1886,  597,  599,  592, 1136, 1102, 1101, 1850,
 /*  2010 */  1098,  598, 1097, 1900, 1096, 1095, 1606,  667,  669, 1604,
 /*  2020 */   671,  599,  673,  668, 1602,  672, 1850,  677,  598,  675,
 /*  2030 */  1600,  676, 1880,  679,  680,  681, 1916, 1588, 1882, 2007,
 /*  2040 */   296, 1881, 1883,  602, 1885, 1886,  597,  683,  592, 1880,
 /*  2050 */  1052, 1570,  687, 1916,  273, 1325, 1882,  158, 1881, 1883,
 /*  2060 */   602, 1885, 1886,  597,  281,  592,  690, 1900,  691, 1545,
 /*  2070 */  1545, 1545,  347, 1545, 1545,  599, 1545, 1545, 1545, 1545,
 /*  2080 */  1850, 1545,  598, 1545,  567, 1900, 1545, 1545, 1545, 1545,
 /*  2090 */   350, 1545, 1545,  599, 1545, 1545, 1545, 1545, 1850, 1545,
 /*  2100 */   598, 1545, 1545, 1880, 1545, 1545, 1545, 1916, 1545, 1545,
 /*  2110 */  2059,  301, 1881, 1883,  602, 1885, 1886,  597, 1882,  592,
 /*  2120 */  1545, 1880, 1545, 1545, 1545, 1916, 1545, 1545, 1545,  301,
 /*  2130 */  1881, 1883,  602, 1885, 1886,  597, 1545,  592, 1545, 1545,
 /*  2140 */  1545, 1545, 1882, 1545, 1545, 1545, 1545, 1900, 1545, 1545,
 /*  2150 */  1545, 1545, 1545, 1545, 1545,  599, 1545, 1545, 1545, 1545,
 /*  2160 */  1850, 1545,  598, 1545, 1545, 1545, 1545, 1545, 1545, 1545,
 /*  2170 */  1545, 1900, 1545, 1545, 1545, 1545, 1545, 1545, 1545,  599,
 /*  2180 */  1545, 1545, 1545,  513, 1850, 1882,  598, 1916, 1545, 1545,
 /*  2190 */  1545,  294, 1881, 1883,  602, 1885, 1886,  597, 1545,  592,
 /*  2200 */  1545, 1545, 1545, 1545, 1545, 1882, 1545, 1880, 1545, 1545,
 /*  2210 */  1545, 1916, 1545, 1545, 1900,  286, 1881, 1883,  602, 1885,
 /*  2220 */  1886,  597,  599,  592, 1545, 1545, 1545, 1850, 1545,  598,
 /*  2230 */  1545, 1545, 1545, 1545, 1900, 1545, 1545, 1545, 1545, 1545,
 /*  2240 */  1545, 1545,  599, 1545, 1545, 1545, 1545, 1850, 1545,  598,
 /*  2250 */  1880, 1545, 1545, 1545, 1916, 1545, 1545, 1545,  287, 1881,
 /*  2260 */  1883,  602, 1885, 1886,  597, 1545,  592, 1545, 1882, 1545,
 /*  2270 */  1880, 1545, 1545, 1545, 1916, 1545, 1545, 1545,  288, 1881,
 /*  2280 */  1883,  602, 1885, 1886,  597, 1545,  592, 1882, 1545, 1545,
 /*  2290 */  1545, 1545, 1545, 1545, 1545, 1545, 1545, 1900, 1545, 1545,
 /*  2300 */  1545, 1545, 1545, 1545, 1545,  599, 1545, 1545, 1545, 1545,
 /*  2310 */  1850, 1545,  598, 1545, 1545, 1545, 1900, 1545, 1545, 1545,
 /*  2320 */  1545, 1545, 1545, 1545,  599, 1545, 1545, 1545, 1545, 1850,
 /*  2330 */  1882,  598, 1545, 1880, 1545, 1545, 1545, 1916, 1545, 1545,
 /*  2340 */  1545,  295, 1881, 1883,  602, 1885, 1886,  597, 1545,  592,
 /*  2350 */  1545, 1545, 1880, 1545, 1545, 1545, 1916, 1545, 1545, 1900,
 /*  2360 */   297, 1881, 1883,  602, 1885, 1886,  597,  599,  592, 1545,
 /*  2370 */  1545, 1545, 1850, 1545,  598, 1545, 1545, 1545, 1545, 1545,
 /*  2380 */  1545, 1882, 1545, 1545, 1545, 1545, 1545, 1545, 1545, 1545,
 /*  2390 */  1545, 1545, 1545, 1545, 1545, 1880, 1545, 1545, 1545, 1916,
 /*  2400 */  1545, 1882, 1545,  289, 1881, 1883,  602, 1885, 1886,  597,
 /*  2410 */  1900,  592, 1545, 1545, 1545, 1545, 1545, 1545,  599, 1545,
 /*  2420 */  1545, 1545, 1545, 1850, 1545,  598, 1545, 1545, 1545, 1545,
 /*  2430 */  1900, 1545, 1545, 1545, 1545, 1545, 1545, 1545,  599, 1545,
 /*  2440 */  1545, 1545, 1545, 1850, 1545,  598, 1880, 1545, 1545, 1545,
 /*  2450 */  1916, 1545, 1882, 1545,  298, 1881, 1883,  602, 1885, 1886,
 /*  2460 */   597, 1545,  592, 1545, 1545, 1545, 1880, 1545, 1545, 1545,
 /*  2470 */  1916, 1545, 1545, 1545,  290, 1881, 1883,  602, 1885, 1886,
 /*  2480 */   597, 1900,  592, 1545, 1545, 1545, 1545, 1545, 1545,  599,
 /*  2490 */  1545, 1545, 1545, 1545, 1850, 1545,  598, 1545, 1545, 1545,
 /*  2500 */  1545, 1545, 1545, 1545, 1545, 1882, 1545, 1545, 1545, 1545,
 /*  2510 */  1545, 1545, 1545, 1545, 1545, 1545, 1545, 1880, 1545, 1545,
 /*  2520 */  1545, 1916, 1545, 1545, 1545,  299, 1881, 1883,  602, 1885,
 /*  2530 */  1886,  597, 1545,  592, 1900, 1545, 1545, 1545, 1545, 1545,
 /*  2540 */  1545, 1545,  599, 1545, 1545, 1545, 1545, 1850, 1882,  598,
 /*  2550 */  1545, 1545, 1545, 1545, 1545, 1545, 1545, 1545, 1545, 1545,
 /*  2560 */  1545, 1545, 1545, 1545, 1545, 1545, 1545, 1545, 1882, 1545,
 /*  2570 */  1880, 1545, 1545, 1545, 1916, 1545, 1545, 1900,  291, 1881,
 /*  2580 */  1883,  602, 1885, 1886,  597,  599,  592, 1545, 1545, 1545,
 /*  2590 */  1850, 1545,  598, 1545, 1545, 1545, 1545, 1900, 1545, 1545,
 /*  2600 */  1545, 1545, 1545, 1545, 1545,  599, 1545, 1545, 1545, 1545,
 /*  2610 */  1850, 1545,  598, 1880, 1545, 1545, 1545, 1916, 1545, 1545,
 /*  2620 */  1545,  304, 1881, 1883,  602, 1885, 1886,  597, 1545,  592,
 /*  2630 */  1545, 1882, 1545, 1880, 1545, 1545, 1545, 1916, 1545, 1545,
 /*  2640 */  1545,  305, 1881, 1883,  602, 1885, 1886,  597, 1545,  592,
 /*  2650 */  1882, 1545, 1545, 1545, 1545, 1545, 1545, 1545, 1545, 1545,
 /*  2660 */  1900, 1545, 1545, 1545, 1545, 1545, 1545, 1545,  599, 1545,
 /*  2670 */  1545, 1545, 1545, 1850, 1545,  598, 1545, 1545, 1545, 1900,
 /*  2680 */  1545, 1545, 1545, 1545, 1545, 1545, 1545,  599, 1545, 1545,
 /*  2690 */  1545, 1545, 1850, 1882,  598, 1545, 1880, 1545, 1545, 1545,
 /*  2700 */  1916, 1545, 1545, 1545, 1894, 1881, 1883,  602, 1885, 1886,
 /*  2710 */   597, 1545,  592, 1545, 1545, 1880, 1545, 1545, 1545, 1916,
 /*  2720 */  1545, 1545, 1900, 1893, 1881, 1883,  602, 1885, 1886,  597,
 /*  2730 */   599,  592, 1545, 1545, 1545, 1850, 1545,  598, 1545, 1545,
 /*  2740 */  1545, 1545, 1545, 1545, 1882, 1545, 1545, 1545, 1545, 1545,
 /*  2750 */  1545, 1545, 1545, 1545, 1545, 1545, 1545, 1545, 1880, 1545,
 /*  2760 */  1545, 1545, 1916, 1545, 1882, 1545, 1892, 1881, 1883,  602,
 /*  2770 */  1885, 1886,  597, 1900,  592, 1545, 1545, 1545, 1545, 1545,
 /*  2780 */  1545,  599, 1545, 1545, 1545, 1545, 1850, 1545,  598, 1545,
 /*  2790 */  1545, 1545, 1545, 1900, 1545, 1545, 1545, 1545, 1545, 1545,
 /*  2800 */  1545,  599, 1545, 1545, 1545, 1545, 1850, 1545,  598, 1880,
 /*  2810 */  1545, 1545, 1545, 1916, 1545, 1882, 1545,  316, 1881, 1883,
 /*  2820 */   602, 1885, 1886,  597, 1545,  592, 1545, 1545, 1545, 1880,
 /*  2830 */  1545, 1545, 1545, 1916, 1545, 1545, 1545,  317, 1881, 1883,
 /*  2840 */   602, 1885, 1886,  597, 1900,  592, 1545, 1545, 1545, 1545,
 /*  2850 */  1545, 1545,  599, 1545, 1545, 1545, 1545, 1850, 1545,  598,
 /*  2860 */  1545, 1545, 1545, 1545, 1545, 1545, 1545, 1545, 1882, 1545,
 /*  2870 */  1545, 1545, 1545, 1545, 1545, 1545, 1545, 1545, 1545, 1545,
 /*  2880 */  1880, 1545, 1545, 1545, 1916, 1545, 1545, 1545,  313, 1881,
 /*  2890 */  1883,  602, 1885, 1886,  597, 1545,  592, 1900, 1545, 1545,
 /*  2900 */  1545, 1545, 1545, 1545, 1545,  599, 1545, 1545, 1545, 1545,
 /*  2910 */  1850, 1882,  598, 1545, 1545, 1545, 1545, 1545, 1545, 1545,
 /*  2920 */  1545, 1545, 1545, 1545, 1545, 1545, 1545, 1545, 1545, 1545,
 /*  2930 */  1545, 1545, 1545, 1880, 1545, 1545, 1545, 1916, 1545, 1545,
 /*  2940 */  1900,  318, 1881, 1883,  602, 1885, 1886,  597,  599,  592,
 /*  2950 */  1545, 1545, 1545, 1850, 1545,  598, 1545, 1545, 1545, 1545,
 /*  2960 */  1545, 1545, 1545, 1545, 1545, 1545, 1545, 1545, 1545, 1545,
 /*  2970 */  1545, 1545, 1545, 1545, 1545, 1545, 1880, 1545, 1545, 1545,
 /*  2980 */  1916, 1545, 1545, 1545,  293, 1881, 1883,  602, 1885, 1886,
 /*  2990 */   597, 1545,  592,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   351,    0,  324,  351,  326,  327,  324,  320,  326,  327,
 /*    10 */   351,  362,   12,   13,  362,  360,  328,  328,  363,  364,
 /*    20 */    20,  362,   22,   12,   13,   14,   15,   16,  340,    3,
 /*    30 */   409,  410,   20,   33,   20,   35,  349,  388,  389,  390,
 /*    40 */   388,  389,  390,   20,  357,  357,   20,  388,  389,  362,
 /*    50 */   401,  364,    2,  401,    0,  366,   56,    4,    8,    9,
 /*    60 */   401,   61,   12,   13,   14,   15,   16,  320,   68,   12,
 /*    70 */    13,   14,  385,   14,   15,   16,  389,   20,  394,   22,
 /*    80 */   393,  394,  395,  396,  397,  398,  399,   20,  401,   22,
 /*    90 */    33,    4,   35,  406,   94,  408,  349,   44,   45,  412,
 /*   100 */   413,  332,   35,   60,  357,  328,   94,  423,   94,  362,
 /*   110 */    20,  364,  425,   56,   60,  346,  116,   50,   61,  364,
 /*   120 */   433,   95,  438,  439,  355,   68,  371,  443,  444,  374,
 /*   130 */   130,  131,  385,   20,  357,   56,  389,    0,  349,   56,
 /*   140 */   393,  394,  395,  396,  397,  398,  399,  358,  401,  349,
 /*   150 */    20,   94,   22,  130,  131,  408,   94,  357,   21,  412,
 /*   160 */   413,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   170 */   423,  394,   93,  116,   94,   96,  176,   94,  178,   96,
 /*   180 */    50,   94,    0,  320,   94,  438,  439,  130,  131,  163,
 /*   190 */   443,  444,  415,  416,  417,  418,  396,  420,  363,  364,
 /*   200 */   200,  201,   60,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,   33,  362,  125,  126,   20,  106,
 /*   230 */   328,  333,   37,  176,   14,  178,  338,  175,   47,  177,
 /*   240 */    20,  241,   60,   52,   53,   54,   55,   56,  125,  126,
 /*   250 */   127,  128,  129,  241,  319,  241,  321,  200,  201,  357,
 /*   260 */   203,  204,  205,  206,  207,  208,  209,  210,  211,  212,
 /*   270 */   213,  214,  215,  216,  217,  218,  219,  220,  221,  222,
 /*   280 */   223,   12,   13,  126,   93,  184,  348,   96,  187,   20,
 /*   290 */   341,   22,   97,  320,   99,  100,  394,  102,  349,  361,
 /*   300 */   328,  106,   33,  241,   35,  320,   21,  358,   20,   24,
 /*   310 */    25,   26,   27,   28,   29,   30,   31,   32,  416,  417,
 /*   320 */   418,  241,  420,  128,  241,   56,   20,  349,  241,  357,
 /*   330 */    61,  351,  161,  320,  356,  362,  125,   68,   12,   13,
 /*   340 */   183,  184,  362,  365,  187,  357,   20,  362,   22,  328,
 /*   350 */   159,  160,   94,  162,   14,  328,  368,  166,  330,   33,
 /*   360 */    20,   35,  349,   94,  328,   14,  394,  340,  388,  389,
 /*   370 */   357,   20,  344,  182,  347,  362,  340,  364,  357,  349,
 /*   380 */   352,  401,   56,  347,  357,  116,  356,   61,  416,  417,
 /*   390 */   418,   22,  420,  357,   68,  365,  185,  186,  385,  130,
 /*   400 */   131,  200,  389,    0,   35,  341,  393,  394,  395,  396,
 /*   410 */   397,  398,  399,  349,  401,  394,   35,  246,  247,  406,
 /*   420 */    94,  408,  358,  158,  204,  412,  413,   24,   25,   26,
 /*   430 */    27,   28,   29,   30,   31,   32,    3,  416,  417,  418,
 /*   440 */    78,  420,  116,  332,  423,  176,  433,  178,   21,   68,
 /*   450 */   341,  250,  251,  252,  253,  254,  130,  131,  349,  438,
 /*   460 */   439,   34,   20,   36,  443,  444,  355,  358,   20,  200,
 /*   470 */   201,    0,  203,  204,  205,  206,  207,  208,  209,  210,
 /*   480 */   211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
 /*   490 */   221,  222,  223,  228,  225,  325,  134,  135,  328,  241,
 /*   500 */   335,  336,  176,  238,  178,   68,  107,  108,  109,  110,
 /*   510 */   111,  112,  113,  114,  115,  116,  117,  320,  119,  120,
 /*   520 */   121,  122,  123,  124,  391,  394,  200,  201,   95,  203,
 /*   530 */   204,  205,  206,  207,  208,  209,  210,  211,  212,  213,
 /*   540 */   214,  215,  216,  217,  218,  219,  220,  221,  222,  223,
 /*   550 */    12,   13,  419,  328,  423,  204,  335,  336,   20,  362,
 /*   560 */    22,  225,   35,  227,  328,  340,  328,  105,  320,  325,
 /*   570 */   439,   33,  328,   35,  443,  444,  340,  106,  340,  320,
 /*   580 */     8,    9,  357,  320,   12,   13,   14,   15,   16,  328,
 /*   590 */     1,    2,   20,  357,   56,  357,  125,  126,  127,  128,
 /*   600 */   129,  340,  320,    0,  328,  163,   68,   12,   13,   14,
 /*   610 */   362,  328,  349,  320,  328,   20,  340,   22,  357,  391,
 /*   620 */   357,  362,  349,  340,  320,  362,  340,  364,   33,  349,
 /*   630 */    35,  349,   94,  357,  225,  405,  356,  407,  365,  357,
 /*   640 */   357,  328,   56,  357,  362,  365,  364,  419,  385,  320,
 /*   650 */   330,   56,  389,  340,  116,  362,  393,  394,  395,  396,
 /*   660 */   397,  398,  399,   68,  401,   68,  362,  385,  130,  131,
 /*   670 */   357,  389,  352,  320,  394,  393,  394,  395,  396,  397,
 /*   680 */   398,  399,   96,  401,   95,  373,  423,  375,  406,   94,
 /*   690 */   408,  362,    8,    9,  412,  413,   12,   13,   14,   15,
 /*   700 */    16,  438,  439,  423,  422,  178,  443,  444,  328,  106,
 /*   710 */   405,  116,  407,  171,  176,  362,  178,  317,  438,  439,
 /*   720 */   340,   44,   45,  443,  444,  130,  131,   43,  125,  126,
 /*   730 */   127,  128,  129,  191,  192,  163,  320,  357,  200,  201,
 /*   740 */   350,  203,  204,  205,  206,  207,  208,  209,  210,  211,
 /*   750 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   760 */   222,  223,    8,    9,  328,  350,   12,   13,   14,   15,
 /*   770 */    16,  176,  342,  178,  357,  345,  340,  377,  362,  241,
 /*   780 */     3,   20,    8,    9,  320,  368,   12,   13,   14,   15,
 /*   790 */    16,    0,  320,  357,  394,  200,  201,   39,  203,  204,
 /*   800 */   205,  206,  207,  208,  209,  210,  211,  212,  213,  214,
 /*   810 */   215,  216,  217,  218,  219,  220,  221,  222,  223,   12,
 /*   820 */    13,  328,   22,  423,  320,  320,  362,   20,   43,   22,
 /*   830 */   320,  364,  350,  340,  362,   35,  328,   35,  438,  439,
 /*   840 */    33,  374,   35,  443,  444,  350,  320,    2,  340,   95,
 /*   850 */   357,    4,  320,    8,    9,   64,   65,   12,   13,   14,
 /*   860 */    15,   16,   71,   56,  320,  357,  362,  362,   68,  394,
 /*   870 */    68,  320,  362,   82,   83,   68,   12,   13,  328,   88,
 /*   880 */   328,  349,  391,  328,   20,  373,   22,  375,  362,  357,
 /*   890 */   340,  357,  340,  328,  362,  340,  364,   33,  423,   35,
 /*   900 */   349,   94,  368,  239,  240,  340,  362,  357,  357,  357,
 /*   910 */   419,   20,  357,  362,  439,  364,  116,  385,  443,  444,
 /*   920 */    56,  389,  357,  116,  163,  393,  394,  395,  396,  397,
 /*   930 */   398,  399,   68,  401,  106,  350,  385,  130,  131,  320,
 /*   940 */   389,  328,  168,  328,  393,  394,  395,  396,  397,  398,
 /*   950 */   399,  404,  401,  340,  407,  340,  128,  406,   94,  408,
 /*   960 */   337,  350,  339,  412,  413,  359,  434,  435,  362,  381,
 /*   970 */   357,  359,  357,  422,  362,    0,  176,  350,  178,  342,
 /*   980 */   116,  362,  345,  176,   43,  178,   42,   43,   98,  105,
 /*   990 */    98,  101,   43,  101,  130,  131,   98,   22,  240,  101,
 /*  1000 */   200,  201,    0,   98,  163,  164,  101,  200,  201,    0,
 /*  1010 */   203,  204,  205,  206,  207,  208,  209,  210,  211,  212,
 /*  1020 */   213,  214,  215,  216,  217,  218,  219,  220,  221,  222,
 /*  1030 */   223,   22,  130,  131,   43,  258,   95,  263,  154,   35,
 /*  1040 */   176,   43,  178,  321,   95,  260,    8,    9,   61,   47,
 /*  1050 */    12,   13,   14,   15,   16,    8,    9,   43,  392,   12,
 /*  1060 */    13,   14,   15,   16,  200,  201,    0,  203,  204,  205,
 /*  1070 */   206,  207,  208,  209,  210,  211,  212,  213,  214,  215,
 /*  1080 */   216,  217,  218,  219,  220,  221,  222,  223,   18,  242,
 /*  1090 */    20,    1,    2,   95,   94,  204,    0,   27,  447,  436,
 /*  1100 */    30,   13,   13,  338,  104,  329,    8,    9,   43,   95,
 /*  1110 */    12,   13,   14,   15,   16,   43,   43,   47,   22,   49,
 /*  1120 */    43,   51,   43,   35,   35,    0,  430,   43,  349,   63,
 /*  1130 */    64,   65,   66,   67,   43,   69,   70,   71,   72,   73,
 /*  1140 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*  1150 */    84,   85,   86,   87,   88,   89,   90,   18,  329,  327,
 /*  1160 */    95,  392,   23,   93,  361,  421,  440,   95,   95,  414,
 /*  1170 */   424,  243,   95,   48,   95,  105,   37,   38,  377,   95,
 /*  1180 */    41,  387,  178,   46,   43,   43,   95,  200,  379,   43,
 /*  1190 */    47,   43,  386,   95,   43,  394,   57,   58,   59,  174,
 /*  1200 */    42,  163,  369,  133,  369,  320,  136,  137,  138,  139,
 /*  1210 */   140,  141,  142,  143,  144,  145,  146,  147,  148,  149,
 /*  1220 */   150,  151,  152,  153,  423,  155,  156,  157,   20,  328,
 /*  1230 */   369,   94,  328,   94,  349,  367,   95,   95,  158,  438,
 /*  1240 */   439,   95,  357,   95,  443,  444,   95,  362,  367,  364,
 /*  1250 */   334,    8,    9,  262,   92,   12,   13,   14,   15,   16,
 /*  1260 */   328,   20,  328,  328,  322,  322,   20,  364,  332,  383,
 /*  1270 */   385,  132,  332,   20,  389,  376,   20,  332,  393,  394,
 /*  1280 */   395,  396,  397,  398,  399,  378,  401,   64,   65,  404,
 /*  1290 */   376,  406,  407,  408,   71,  332,  332,  412,  413,  332,
 /*  1300 */   328,  377,  332,  377,   61,   82,   83,  168,  169,  170,
 /*  1310 */   377,   88,  173,  328,  322,  349,  320,  349,  394,  322,
 /*  1320 */   394,  362,  349,  349,  189,  349,  349,  394,  349,  190,
 /*  1330 */   349,  349,  193,  383,  195,  196,  197,  198,  199,  349,
 /*  1340 */   384,  330,  349,  382,  181,  349,  103,  423,  330,  423,
 /*  1350 */   364,  328,  328,  357,  376,  248,  423,  330,  362,  160,
 /*  1360 */   364,  377,  438,  439,  438,  439,  372,  443,  444,  443,
 /*  1370 */   444,  438,  439,  372,  362,  362,  443,  444,  394,  362,
 /*  1380 */   241,  385,  362,  362,  330,  389,  370,  345,  330,  393,
 /*  1390 */   394,  395,  396,  397,  398,  399,  357,  401,   20,  392,
 /*  1400 */   392,  158,  406,  362,  408,  249,  372,  423,  412,  413,
 /*  1410 */    19,  362,  429,  362,  362,  372,  255,  429,  422,  362,
 /*  1420 */   431,  320,  438,  439,   33,  167,  257,  443,  444,  256,
 /*  1430 */   244,  432,  429,  428,  264,  387,  261,  427,   47,  259,
 /*  1440 */   240,  426,  357,   52,   53,   54,   55,   56,   20,   94,
 /*  1450 */   349,  391,   94,  353,  448,  411,  362,  339,  357,  328,
 /*  1460 */   330,  442,   36,  362,  320,  364,  380,  441,  323,  322,
 /*  1470 */   375,  228,  229,  230,  231,  232,  233,  234,  235,  236,
 /*  1480 */   237,  238,  318,  343,   93,  331,  385,   96,    0,    0,
 /*  1490 */   389,  183,  343,  349,  393,  394,  395,  396,  397,  398,
 /*  1500 */   399,  357,  401,  343,    0,    0,  362,  406,  364,  408,
 /*  1510 */    42,   12,   13,  412,  413,    0,   35,  320,  194,   35,
 /*  1520 */   129,   22,   35,  194,    0,   35,   35,   35,  194,  385,
 /*  1530 */     0,  194,   33,  389,   35,    0,   35,  393,  394,  395,
 /*  1540 */   396,  397,  398,  399,   35,  401,  349,    0,   22,    0,
 /*  1550 */   406,  178,  408,  162,  357,   56,  412,  413,  176,  362,
 /*  1560 */     0,  364,    0,    0,  172,  171,    0,   68,    0,   46,
 /*  1570 */   320,  180,    0,  182,    0,   42,    0,    0,    0,   42,
 /*  1580 */     0,    0,  385,    0,    0,    0,  389,    0,  149,   35,
 /*  1590 */   393,  394,  395,  396,  397,  398,  399,    0,  401,  349,
 /*  1600 */   149,    0,    0,  406,   22,  408,    0,  357,    0,  412,
 /*  1610 */   413,    0,  362,  320,  364,  116,    0,    0,    0,    0,
 /*  1620 */     0,    0,    0,    0,    0,    0,    0,    0,   42,    0,
 /*  1630 */     0,    0,    0,    0,    0,  385,    0,    0,   35,  389,
 /*  1640 */     0,    0,  349,  393,  394,  395,  396,  397,  398,  399,
 /*  1650 */   357,  401,   56,    0,   56,  362,   42,  364,  408,   14,
 /*  1660 */    14,   46,  412,  413,  167,    0,  320,   39,    0,    0,
 /*  1670 */     0,    0,    0,    0,   39,  176,    0,  178,  385,    0,
 /*  1680 */     0,   43,  389,   40,   35,   46,  393,  394,  395,  396,
 /*  1690 */   397,  398,  399,   39,  401,  349,   39,   47,   35,  200,
 /*  1700 */   201,  408,   47,  357,   62,  412,  413,    0,  362,   35,
 /*  1710 */   364,    0,    0,  214,  215,  216,  217,  218,  219,  220,
 /*  1720 */    39,   39,  320,   35,   47,   47,   39,    0,    0,    0,
 /*  1730 */    35,  385,   22,    0,   35,  389,   35,   43,   35,  393,
 /*  1740 */   394,  395,  396,  397,  398,  399,  400,  401,  402,  403,
 /*  1750 */    35,  349,   43,  101,  103,    0,   22,   22,    0,  357,
 /*  1760 */    22,    0,   49,   22,  362,   35,  364,    0,    0,    0,
 /*  1770 */    22,   20,   35,    0,   35,  163,    0,   35,   95,   94,
 /*  1780 */     0,   22,    0,    0,  320,   94,  179,  385,    0,    4,
 /*  1790 */     3,  389,    0,   95,    0,  393,  394,  395,  396,  397,
 /*  1800 */   398,  399,   94,  401,   19,   35,    0,  163,  160,  104,
 /*  1810 */    94,   39,   46,  349,   94,  224,  226,   43,   33,  163,
 /*  1820 */   161,  357,   43,  165,  224,  159,  362,   95,  364,   43,
 /*  1830 */    46,    3,   47,  245,   94,   46,   51,   94,   43,   95,
 /*  1840 */    95,   56,  320,   94,   43,   95,   94,  445,  446,  385,
 /*  1850 */   188,   94,   43,  389,   94,  245,   94,  393,  394,  395,
 /*  1860 */   396,  397,  398,  399,  320,  401,   95,   35,   35,   35,
 /*  1870 */    95,  349,  408,   95,   35,   35,  354,  413,   93,  357,
 /*  1880 */    35,   96,   46,   46,  362,   95,  364,   43,   95,   46,
 /*  1890 */     2,   22,  200,  349,   94,   46,   46,   95,   94,   94,
 /*  1900 */   239,  357,   95,   95,   94,  245,  362,  385,  364,   94,
 /*  1910 */    94,  389,   95,   22,   95,  393,  394,  395,  396,  397,
 /*  1920 */   398,  399,   35,  401,  320,  202,  105,   35,   35,  385,
 /*  1930 */    95,   35,   94,  389,   35,   94,   94,  393,  394,  395,
 /*  1940 */   396,  397,  398,  399,   35,  401,   95,  403,   95,   94,
 /*  1950 */    22,   95,   94,  349,  106,   94,   94,   35,   94,   43,
 /*  1960 */    22,  357,   62,   61,  118,  118,  362,  320,  364,   35,
 /*  1970 */   118,   35,  118,   68,   35,   35,   35,   35,   35,   35,
 /*  1980 */    35,   35,   22,   22,  320,   91,   35,   35,   35,  385,
 /*  1990 */    43,   35,   35,  389,   35,   68,  349,  393,  394,  395,
 /*  2000 */   396,  397,  398,  399,  357,  401,   35,   35,   35,  362,
 /*  2010 */    35,  364,   35,  349,   22,   35,    0,   35,   39,    0,
 /*  2020 */    35,  357,   39,   47,    0,   47,  362,   39,  364,   35,
 /*  2030 */     0,   47,  385,   35,   47,   39,  389,    0,  320,  435,
 /*  2040 */   393,  394,  395,  396,  397,  398,  399,   35,  401,  385,
 /*  2050 */    35,    0,   21,  389,   22,   22,  320,  393,  394,  395,
 /*  2060 */   396,  397,  398,  399,   22,  401,   21,  349,   20,  449,
 /*  2070 */   449,  449,  354,  449,  449,  357,  449,  449,  449,  449,
 /*  2080 */   362,  449,  364,  449,  437,  349,  449,  449,  449,  449,
 /*  2090 */   354,  449,  449,  357,  449,  449,  449,  449,  362,  449,
 /*  2100 */   364,  449,  449,  385,  449,  449,  449,  389,  449,  449,
 /*  2110 */   446,  393,  394,  395,  396,  397,  398,  399,  320,  401,
 /*  2120 */   449,  385,  449,  449,  449,  389,  449,  449,  449,  393,
 /*  2130 */   394,  395,  396,  397,  398,  399,  449,  401,  449,  449,
 /*  2140 */   449,  449,  320,  449,  449,  449,  449,  349,  449,  449,
 /*  2150 */   449,  449,  449,  449,  449,  357,  449,  449,  449,  449,
 /*  2160 */   362,  449,  364,  449,  449,  449,  449,  449,  449,  449,
 /*  2170 */   449,  349,  449,  449,  449,  449,  449,  449,  449,  357,
 /*  2180 */   449,  449,  449,  385,  362,  320,  364,  389,  449,  449,
 /*  2190 */   449,  393,  394,  395,  396,  397,  398,  399,  449,  401,
 /*  2200 */   449,  449,  449,  449,  449,  320,  449,  385,  449,  449,
 /*  2210 */   449,  389,  449,  449,  349,  393,  394,  395,  396,  397,
 /*  2220 */   398,  399,  357,  401,  449,  449,  449,  362,  449,  364,
 /*  2230 */   449,  449,  449,  449,  349,  449,  449,  449,  449,  449,
 /*  2240 */   449,  449,  357,  449,  449,  449,  449,  362,  449,  364,
 /*  2250 */   385,  449,  449,  449,  389,  449,  449,  449,  393,  394,
 /*  2260 */   395,  396,  397,  398,  399,  449,  401,  449,  320,  449,
 /*  2270 */   385,  449,  449,  449,  389,  449,  449,  449,  393,  394,
 /*  2280 */   395,  396,  397,  398,  399,  449,  401,  320,  449,  449,
 /*  2290 */   449,  449,  449,  449,  449,  449,  449,  349,  449,  449,
 /*  2300 */   449,  449,  449,  449,  449,  357,  449,  449,  449,  449,
 /*  2310 */   362,  449,  364,  449,  449,  449,  349,  449,  449,  449,
 /*  2320 */   449,  449,  449,  449,  357,  449,  449,  449,  449,  362,
 /*  2330 */   320,  364,  449,  385,  449,  449,  449,  389,  449,  449,
 /*  2340 */   449,  393,  394,  395,  396,  397,  398,  399,  449,  401,
 /*  2350 */   449,  449,  385,  449,  449,  449,  389,  449,  449,  349,
 /*  2360 */   393,  394,  395,  396,  397,  398,  399,  357,  401,  449,
 /*  2370 */   449,  449,  362,  449,  364,  449,  449,  449,  449,  449,
 /*  2380 */   449,  320,  449,  449,  449,  449,  449,  449,  449,  449,
 /*  2390 */   449,  449,  449,  449,  449,  385,  449,  449,  449,  389,
 /*  2400 */   449,  320,  449,  393,  394,  395,  396,  397,  398,  399,
 /*  2410 */   349,  401,  449,  449,  449,  449,  449,  449,  357,  449,
 /*  2420 */   449,  449,  449,  362,  449,  364,  449,  449,  449,  449,
 /*  2430 */   349,  449,  449,  449,  449,  449,  449,  449,  357,  449,
 /*  2440 */   449,  449,  449,  362,  449,  364,  385,  449,  449,  449,
 /*  2450 */   389,  449,  320,  449,  393,  394,  395,  396,  397,  398,
 /*  2460 */   399,  449,  401,  449,  449,  449,  385,  449,  449,  449,
 /*  2470 */   389,  449,  449,  449,  393,  394,  395,  396,  397,  398,
 /*  2480 */   399,  349,  401,  449,  449,  449,  449,  449,  449,  357,
 /*  2490 */   449,  449,  449,  449,  362,  449,  364,  449,  449,  449,
 /*  2500 */   449,  449,  449,  449,  449,  320,  449,  449,  449,  449,
 /*  2510 */   449,  449,  449,  449,  449,  449,  449,  385,  449,  449,
 /*  2520 */   449,  389,  449,  449,  449,  393,  394,  395,  396,  397,
 /*  2530 */   398,  399,  449,  401,  349,  449,  449,  449,  449,  449,
 /*  2540 */   449,  449,  357,  449,  449,  449,  449,  362,  320,  364,
 /*  2550 */   449,  449,  449,  449,  449,  449,  449,  449,  449,  449,
 /*  2560 */   449,  449,  449,  449,  449,  449,  449,  449,  320,  449,
 /*  2570 */   385,  449,  449,  449,  389,  449,  449,  349,  393,  394,
 /*  2580 */   395,  396,  397,  398,  399,  357,  401,  449,  449,  449,
 /*  2590 */   362,  449,  364,  449,  449,  449,  449,  349,  449,  449,
 /*  2600 */   449,  449,  449,  449,  449,  357,  449,  449,  449,  449,
 /*  2610 */   362,  449,  364,  385,  449,  449,  449,  389,  449,  449,
 /*  2620 */   449,  393,  394,  395,  396,  397,  398,  399,  449,  401,
 /*  2630 */   449,  320,  449,  385,  449,  449,  449,  389,  449,  449,
 /*  2640 */   449,  393,  394,  395,  396,  397,  398,  399,  449,  401,
 /*  2650 */   320,  449,  449,  449,  449,  449,  449,  449,  449,  449,
 /*  2660 */   349,  449,  449,  449,  449,  449,  449,  449,  357,  449,
 /*  2670 */   449,  449,  449,  362,  449,  364,  449,  449,  449,  349,
 /*  2680 */   449,  449,  449,  449,  449,  449,  449,  357,  449,  449,
 /*  2690 */   449,  449,  362,  320,  364,  449,  385,  449,  449,  449,
 /*  2700 */   389,  449,  449,  449,  393,  394,  395,  396,  397,  398,
 /*  2710 */   399,  449,  401,  449,  449,  385,  449,  449,  449,  389,
 /*  2720 */   449,  449,  349,  393,  394,  395,  396,  397,  398,  399,
 /*  2730 */   357,  401,  449,  449,  449,  362,  449,  364,  449,  449,
 /*  2740 */   449,  449,  449,  449,  320,  449,  449,  449,  449,  449,
 /*  2750 */   449,  449,  449,  449,  449,  449,  449,  449,  385,  449,
 /*  2760 */   449,  449,  389,  449,  320,  449,  393,  394,  395,  396,
 /*  2770 */   397,  398,  399,  349,  401,  449,  449,  449,  449,  449,
 /*  2780 */   449,  357,  449,  449,  449,  449,  362,  449,  364,  449,
 /*  2790 */   449,  449,  449,  349,  449,  449,  449,  449,  449,  449,
 /*  2800 */   449,  357,  449,  449,  449,  449,  362,  449,  364,  385,
 /*  2810 */   449,  449,  449,  389,  449,  320,  449,  393,  394,  395,
 /*  2820 */   396,  397,  398,  399,  449,  401,  449,  449,  449,  385,
 /*  2830 */   449,  449,  449,  389,  449,  449,  449,  393,  394,  395,
 /*  2840 */   396,  397,  398,  399,  349,  401,  449,  449,  449,  449,
 /*  2850 */   449,  449,  357,  449,  449,  449,  449,  362,  449,  364,
 /*  2860 */   449,  449,  449,  449,  449,  449,  449,  449,  320,  449,
 /*  2870 */   449,  449,  449,  449,  449,  449,  449,  449,  449,  449,
 /*  2880 */   385,  449,  449,  449,  389,  449,  449,  449,  393,  394,
 /*  2890 */   395,  396,  397,  398,  399,  449,  401,  349,  449,  449,
 /*  2900 */   449,  449,  449,  449,  449,  357,  449,  449,  449,  449,
 /*  2910 */   362,  320,  364,  449,  449,  449,  449,  449,  449,  449,
 /*  2920 */   449,  449,  449,  449,  449,  449,  449,  449,  449,  449,
 /*  2930 */   449,  449,  449,  385,  449,  449,  449,  389,  449,  449,
 /*  2940 */   349,  393,  394,  395,  396,  397,  398,  399,  357,  401,
 /*  2950 */   449,  449,  449,  362,  449,  364,  449,  449,  449,  449,
 /*  2960 */   449,  449,  449,  449,  449,  449,  449,  449,  449,  449,
 /*  2970 */   449,  449,  449,  449,  449,  449,  385,  449,  449,  449,
 /*  2980 */   389,  449,  449,  449,  393,  394,  395,  396,  397,  398,
 /*  2990 */   399,  449,  401,
};
#define YY_SHIFT_COUNT    (692)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2051)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1139,    0,   57,  269,   57,  326,  326,  326,  538,  326,
 /*    10 */   326,  326,  326,  326,  595,  807,  807,  864,  807,  807,
 /*    20 */   807,  807,  807,  807,  807,  807,  807,  807,  807,  807,
 /*    30 */   807,  807,  807,  807,  807,  807,  807,  807,  807,  807,
 /*    40 */   807,  807,  807,  807,  807,  807,   12,   14,   90,   62,
 /*    50 */    83,   80,  258,   80,   90,   90, 1499, 1499,   80, 1499,
 /*    60 */  1499,   87,   80,  113,  113,   53,   53,   23,  113,  113,
 /*    70 */   113,  113,  113,  113,  113,  113,  113,  113,   43,  113,
 /*    80 */   113,  113,  208,  113,  113,  288,  113,  113,  288,  306,
 /*    90 */   113,  288,  288,  288,  113,  142, 1070, 1243, 1243,  285,
 /*   100 */   800,  800,  800,  800,  800,  800,  800,  800,  800,  800,
 /*   110 */   800,  800,  800,  800,  800,  800,  800,  800,  800,  195,
 /*   120 */  1223,   26,   23,  340,  340,   54,  381,  182,  336,  336,
 /*   130 */   442,  442,  442,  381,  448,  448,  448,  462,  208,    1,
 /*   140 */     1,  409,  288,  288,  437,  437,  462,  597,  399,  399,
 /*   150 */   399,  399,  399,  399,  399, 1391,  137,  572,  774,  791,
 /*   160 */   201,   67,  171,  220,  351,  130,  677,  828,  761,  664,
 /*   170 */   758,  777,  664,  944,  847,  891,  928, 1143, 1025, 1158,
 /*   180 */  1158, 1208, 1208, 1158, 1080, 1080, 1162, 1208, 1208, 1208,
 /*   190 */  1241, 1241, 1246,   43,  208,   43, 1253, 1256,   43, 1253,
 /*   200 */    43,   43,   43, 1208,   43, 1241,  288,  288,  288,  288,
 /*   210 */   288,  288,  288,  288,  288,  288,  288, 1208, 1241,  437,
 /*   220 */  1135, 1246,  142, 1163,  208,  142, 1208, 1208, 1253,  142,
 /*   230 */  1107,  437,  437,  437,  437, 1107,  437, 1199,  142,  462,
 /*   240 */   142,  448, 1378, 1378,  437, 1156, 1107,  437,  437, 1156,
 /*   250 */  1107,  437,  437,  288, 1161, 1258, 1156, 1169, 1173, 1186,
 /*   260 */   928, 1170, 1175, 1180, 1200,  448, 1428, 1355, 1358,  437,
 /*   270 */   597, 1208,  142, 1426, 1241, 2993, 2993, 2993, 2993, 2993,
 /*   280 */  2993, 2993, 1066,  191,  403, 1785,  754,  684, 1098,   50,
 /*   290 */   845, 1038,  471, 1047, 1047, 1047, 1047, 1047, 1047, 1047,
 /*   300 */  1047, 1047,  603,  123,   11,   11,  157,  101,  542,   79,
 /*   310 */   362,  427,  211,   59,  589,  265,   59,   59,   59,  941,
 /*   320 */  1002,  369,  884,  890,  892,  898,  905,  975, 1009, 1096,
 /*   330 */   586,  841,  949,  998, 1014, 1065, 1072, 1073, 1077,  902,
 /*   340 */   785,  991, 1090, 1079,  527, 1004,  987, 1084,  433, 1137,
 /*   350 */  1091, 1141, 1142, 1146, 1148, 1151, 1000, 1088, 1089,  802,
 /*   360 */  1125, 1488, 1489, 1308, 1504, 1505, 1468, 1515, 1481, 1324,
 /*   370 */  1484, 1487, 1490, 1329, 1524, 1491, 1492, 1334, 1530, 1337,
 /*   380 */  1535, 1501, 1547, 1526, 1549, 1509, 1373, 1382, 1560, 1562,
 /*   390 */  1392, 1394, 1563, 1566, 1523, 1568, 1572, 1574, 1533, 1576,
 /*   400 */  1577, 1578, 1537, 1580, 1581, 1583, 1584, 1585, 1587, 1439,
 /*   410 */  1554, 1597, 1451, 1601, 1602, 1606, 1608, 1611, 1616, 1617,
 /*   420 */  1618, 1619, 1620, 1621, 1622, 1623, 1624, 1586, 1625, 1626,
 /*   430 */  1627, 1629, 1630, 1631, 1582, 1632, 1633, 1634, 1636, 1603,
 /*   440 */  1637, 1596, 1640, 1598, 1641, 1653, 1614, 1628, 1638, 1645,
 /*   450 */  1615, 1646, 1639, 1668, 1643, 1635, 1669, 1670, 1671, 1654,
 /*   460 */  1497, 1665, 1672, 1673, 1642, 1676, 1679, 1649, 1650, 1657,
 /*   470 */  1680, 1663, 1655, 1681, 1707, 1674, 1677, 1682, 1711, 1688,
 /*   480 */  1678, 1687, 1712, 1727, 1728, 1729, 1651, 1652, 1695, 1710,
 /*   490 */  1733, 1699, 1701, 1694, 1709, 1703, 1715, 1734, 1755, 1735,
 /*   500 */  1758, 1738, 1713, 1761, 1741, 1730, 1767, 1737, 1768, 1739,
 /*   510 */  1769, 1748, 1751, 1683, 1685, 1773, 1612, 1742, 1776, 1607,
 /*   520 */  1759, 1644, 1648, 1780, 1782, 1656, 1658, 1787, 1783, 1788,
 /*   530 */  1792, 1691, 1698, 1770, 1662, 1794, 1708, 1659, 1716, 1806,
 /*   540 */  1772, 1666, 1720, 1705, 1766, 1774, 1591, 1590, 1600, 1779,
 /*   550 */  1588, 1740, 1732, 1743, 1744, 1745, 1749, 1786, 1750, 1752,
 /*   560 */  1757, 1760, 1771, 1795, 1784, 1789, 1762, 1801, 1610, 1775,
 /*   570 */  1778, 1828, 1809, 1660, 1832, 1833, 1834, 1839, 1840, 1845,
 /*   580 */  1790, 1793, 1836, 1661, 1844, 1837, 1843, 1888, 1869, 1692,
 /*   590 */  1800, 1802, 1804, 1807, 1805, 1808, 1849, 1810, 1815, 1850,
 /*   600 */  1817, 1891, 1723, 1816, 1821, 1819, 1887, 1892, 1838, 1835,
 /*   610 */  1893, 1841, 1851, 1896, 1842, 1853, 1899, 1855, 1856, 1909,
 /*   620 */  1858, 1846, 1847, 1852, 1854, 1928, 1848, 1861, 1862, 1922,
 /*   630 */  1864, 1916, 1916, 1938, 1900, 1902, 1934, 1936, 1939, 1940,
 /*   640 */  1941, 1942, 1943, 1944, 1945, 1946, 1905, 1894, 1947, 1951,
 /*   650 */  1952, 1960, 1953, 1961, 1956, 1957, 1959, 1927, 1694, 1971,
 /*   660 */  1709, 1972, 1973, 1975, 1977, 1992, 1980, 2016, 1982, 1976,
 /*   670 */  1979, 2019, 1985, 1978, 1983, 2024, 1994, 1984, 1988, 2030,
 /*   680 */  1998, 1987, 1996, 2037, 2012, 2015, 2051, 2032, 2031, 2033,
 /*   690 */  2042, 2045, 2048,
};
#define YY_REDUCE_COUNT (281)
#define YY_REDUCE_MIN   (-379)
#define YY_REDUCE_MAX   (2591)
static const short yy_reduce_ofst[] = {
 /*     0 */   400, -253, -313,  885,   13,  282,  551,  996,  263, 1101,
 /*    10 */  1144, 1197, 1250, 1293, 1346,  532, 1402, 1464, 1522, 1544,
 /*    20 */  1604, 1647, 1664, 1718, 1736, 1798, 1822, 1865, 1885, 1948,
 /*    30 */  1967, 2010, 2061, 2081, 2132, 2185, 2228, 2248, 2311, 2330,
 /*    40 */  2373, 2424, 2444, 2495, 2548, 2591,   21,  280, -223,  801,
 /*    50 */   924,  926,  933,  984,  -98,  -28, -351, -348, -316, -341,
 /*    60 */   -20,  131,  475,   27,   36, -322, -318, -345, -312,  225,
 /*    70 */   236,  238,  261,  276,  283,  286,  313,  436, -231,  493,
 /*    80 */   508,  550, -245,  552,  555,  -51,  565,  613,  -22, -200,
 /*    90 */   615,   64,   30,  109,  380,   28, -311, -379, -379,  -65,
 /*   100 */  -137,  -27,  -15,  197,  248,  259,  293,  304,  329,  353,
 /*   110 */   416,  464,  472,  504,  505,  510,  526,  544,  619,  -62,
 /*   120 */  -102,  133, -165,  170,  244,  111,  165,  320,  230,  305,
 /*   130 */   133,  228,  491,  221,  -12,  417,  534,  430,  467,  312,
 /*   140 */   512,  547, -211,  273,  606,  612,  637,  623,  390,  415,
 /*   150 */   482,  495,  585,  611,  627,  588,  722,  666,  651,  765,
 /*   160 */   663,  776,  696,  779,  779,  829,  832,  803,  769,  744,
 /*   170 */   744,  726,  744,  755,  746,  779,  794,  806,  809,  833,
 /*   180 */   835,  901,  904,  861,  868,  881,  916,  932,  934,  935,
 /*   190 */   942,  943,  886,  936,  903,  940,  899,  907,  945,  914,
 /*   200 */   963,  964,  967,  972,  970,  992,  966,  968,  973,  974,
 /*   210 */   976,  977,  979,  981,  982,  990,  993,  985,  997,  959,
 /*   220 */   956,  950, 1011,  961,  986, 1018, 1023, 1024,  978, 1027,
 /*   230 */   994, 1012, 1013, 1017, 1020, 1001, 1021, 1016, 1054, 1042,
 /*   240 */  1058, 1039, 1007, 1008, 1041,  983, 1034, 1049, 1051,  988,
 /*   250 */  1043, 1052, 1057,  779,  999,  989, 1003, 1005, 1010, 1015,
 /*   260 */  1048, 1006, 1019, 1026,  744, 1085, 1060, 1044, 1100, 1094,
 /*   270 */  1118, 1131, 1130, 1145, 1147, 1086, 1095, 1140, 1149, 1160,
 /*   280 */  1154, 1164,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*    10 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*    20 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*    30 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*    40 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*    50 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*    60 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*    70 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1617, 1543,
 /*    80 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*    90 */  1543, 1543, 1543, 1543, 1543, 1615, 1783, 1971, 1543, 1543,
 /*   100 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   110 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   120 */  1543, 1983, 1543, 1543, 1543, 1617, 1543, 1615, 1943, 1943,
 /*   130 */  1983, 1983, 1983, 1543, 1543, 1543, 1543, 1722, 1543, 1824,
 /*   140 */  1824, 1543, 1543, 1543, 1543, 1543, 1722, 1543, 1543, 1543,
 /*   150 */  1543, 1543, 1543, 1543, 1543, 1818, 1543, 2008, 2061, 1543,
 /*   160 */  1543, 1543, 2011, 1543, 1543, 1543, 1543, 1675, 1998, 1975,
 /*   170 */  1989, 2045, 1976, 1973, 1992, 1543, 2002, 1543, 1811, 1788,
 /*   180 */  1788, 1543, 1543, 1788, 1785, 1785, 1666, 1543, 1543, 1543,
 /*   190 */  1543, 1543, 1543, 1617, 1543, 1617, 1543, 1543, 1617, 1543,
 /*   200 */  1617, 1617, 1617, 1543, 1617, 1543, 1543, 1543, 1543, 1543,
 /*   210 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   220 */  1830, 1543, 1615, 1820, 1543, 1615, 1543, 1543, 1543, 1615,
 /*   230 */  2016, 1543, 1543, 1543, 1543, 2016, 1543, 1543, 1615, 1543,
 /*   240 */  1615, 1543, 1543, 1543, 1543, 2018, 2016, 1543, 1543, 2018,
 /*   250 */  2016, 1543, 1543, 1543, 2030, 2026, 2018, 2034, 2032, 2004,
 /*   260 */  2002, 2064, 2051, 2047, 1989, 1543, 1543, 1543, 1691, 1543,
 /*   270 */  1543, 1543, 1615, 1575, 1543, 1813, 1824, 1725, 1725, 1725,
 /*   280 */  1618, 1548, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   290 */  1543, 1543, 1543, 1899, 1543, 2029, 2028, 1947, 1946, 1945,
 /*   300 */  1936, 1898, 1543, 1687, 1897, 1896, 1543, 1543, 1543, 1543,
 /*   310 */  1543, 1543, 1543, 1890, 1543, 1543, 1891, 1889, 1888, 1543,
 /*   320 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   330 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   340 */  2048, 2052, 1972, 1543, 1543, 1543, 1543, 1543, 1881, 1872,
 /*   350 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   360 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   370 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   380 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   390 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   400 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   410 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   420 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   430 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   440 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1580, 1543,
 /*   450 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   460 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   470 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   480 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   490 */  1543, 1543, 1543, 1656, 1655, 1543, 1543, 1543, 1543, 1543,
 /*   500 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   510 */  1543, 1543, 1543, 1880, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   520 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 2044, 1543, 1543,
 /*   530 */  1543, 1543, 1543, 1543, 1543, 1828, 1543, 1543, 1543, 1543,
 /*   540 */  1543, 1543, 1543, 1543, 1543, 1933, 1543, 1543, 1543, 2005,
 /*   550 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   560 */  1543, 1543, 1543, 1543, 1543, 1872, 1543, 2027, 1543, 1543,
 /*   570 */  2042, 1543, 2046, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   580 */  1982, 1978, 1543, 1543, 1974, 1871, 1543, 1967, 1543, 1543,
 /*   590 */  1918, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   600 */  1880, 1543, 1884, 1543, 1543, 1543, 1543, 1543, 1719, 1543,
 /*   610 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   620 */  1543, 1704, 1702, 1701, 1700, 1543, 1697, 1543, 1543, 1543,
 /*   630 */  1543, 1728, 1727, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   640 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1637, 1543,
 /*   650 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1628, 1543,
 /*   660 */  1627, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   670 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   680 */  1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543, 1543,
 /*   690 */  1543, 1543, 1543,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       CASE => nothing */
  265,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  265,  /*      AFTER => ABORT */
  265,  /*     ATTACH => ABORT */
  265,  /*     BEFORE => ABORT */
  265,  /*      BEGIN => ABORT */
  265,  /*     BITAND => ABORT */
  265,  /*     BITNOT => ABORT */
  265,  /*      BITOR => ABORT */
  265,  /*     BLOCKS => ABORT */
  265,  /*     CHANGE => ABORT */
  265,  /*      COMMA => ABORT */
  265,  /*    COMPACT => ABORT */
  265,  /*     CONCAT => ABORT */
  265,  /*   CONFLICT => ABORT */
  265,  /*       COPY => ABORT */
  265,  /*   DEFERRED => ABORT */
  265,  /* DELIMITERS => ABORT */
  265,  /*     DETACH => ABORT */
  265,  /*     DIVIDE => ABORT */
  265,  /*        DOT => ABORT */
  265,  /*       EACH => ABORT */
  265,  /*       FAIL => ABORT */
  265,  /*       FILE => ABORT */
  265,  /*        FOR => ABORT */
  265,  /*       GLOB => ABORT */
  265,  /*         ID => ABORT */
  265,  /*  IMMEDIATE => ABORT */
  265,  /*     IMPORT => ABORT */
  265,  /*  INITIALLY => ABORT */
  265,  /*    INSTEAD => ABORT */
  265,  /*     ISNULL => ABORT */
  265,  /*        KEY => ABORT */
  265,  /*  NK_BITNOT => ABORT */
  265,  /*    NK_SEMI => ABORT */
  265,  /*    NOTNULL => ABORT */
  265,  /*         OF => ABORT */
  265,  /*       PLUS => ABORT */
  265,  /*  PRIVILEGE => ABORT */
  265,  /*      RAISE => ABORT */
  265,  /*    REPLACE => ABORT */
  265,  /*   RESTRICT => ABORT */
  265,  /*        ROW => ABORT */
  265,  /*       SEMI => ABORT */
  265,  /*       STAR => ABORT */
  265,  /*  STATEMENT => ABORT */
  265,  /*     STRING => ABORT */
  265,  /*      TIMES => ABORT */
  265,  /*     UPDATE => ABORT */
  265,  /*     VALUES => ABORT */
  265,  /*   VARIABLE => ABORT */
  265,  /*       VIEW => ABORT */
  265,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "TRIM",
  /*   60 */ "IF",
  /*   61 */ "NOT",
  /*   62 */ "EXISTS",
  /*   63 */ "BUFFER",
  /*   64 */ "CACHEMODEL",
  /*   65 */ "CACHESIZE",
  /*   66 */ "COMP",
  /*   67 */ "DURATION",
  /*   68 */ "NK_VARIABLE",
  /*   69 */ "MAXROWS",
  /*   70 */ "MINROWS",
  /*   71 */ "KEEP",
  /*   72 */ "PAGES",
  /*   73 */ "PAGESIZE",
  /*   74 */ "TSDB_PAGESIZE",
  /*   75 */ "PRECISION",
  /*   76 */ "REPLICA",
  /*   77 */ "STRICT",
  /*   78 */ "VGROUPS",
  /*   79 */ "SINGLE_STABLE",
  /*   80 */ "RETENTIONS",
  /*   81 */ "SCHEMALESS",
  /*   82 */ "WAL_LEVEL",
  /*   83 */ "WAL_FSYNC_PERIOD",
  /*   84 */ "WAL_RETENTION_PERIOD",
  /*   85 */ "WAL_RETENTION_SIZE",
  /*   86 */ "WAL_ROLL_PERIOD",
  /*   87 */ "WAL_SEGMENT_SIZE",
  /*   88 */ "STT_TRIGGER",
  /*   89 */ "TABLE_PREFIX",
  /*   90 */ "TABLE_SUFFIX",
  /*   91 */ "NK_COLON",
  /*   92 */ "MAX_SPEED",
  /*   93 */ "TABLE",
  /*   94 */ "NK_LP",
  /*   95 */ "NK_RP",
  /*   96 */ "STABLE",
  /*   97 */ "ADD",
  /*   98 */ "COLUMN",
  /*   99 */ "MODIFY",
  /*  100 */ "RENAME",
  /*  101 */ "TAG",
  /*  102 */ "SET",
  /*  103 */ "NK_EQ",
  /*  104 */ "USING",
  /*  105 */ "TAGS",
  /*  106 */ "COMMENT",
  /*  107 */ "BOOL",
  /*  108 */ "TINYINT",
  /*  109 */ "SMALLINT",
  /*  110 */ "INT",
  /*  111 */ "INTEGER",
  /*  112 */ "BIGINT",
  /*  113 */ "FLOAT",
  /*  114 */ "DOUBLE",
  /*  115 */ "BINARY",
  /*  116 */ "TIMESTAMP",
  /*  117 */ "NCHAR",
  /*  118 */ "UNSIGNED",
  /*  119 */ "JSON",
  /*  120 */ "VARCHAR",
  /*  121 */ "MEDIUMBLOB",
  /*  122 */ "BLOB",
  /*  123 */ "VARBINARY",
  /*  124 */ "DECIMAL",
  /*  125 */ "MAX_DELAY",
  /*  126 */ "WATERMARK",
  /*  127 */ "ROLLUP",
  /*  128 */ "TTL",
  /*  129 */ "SMA",
  /*  130 */ "FIRST",
  /*  131 */ "LAST",
  /*  132 */ "SHOW",
  /*  133 */ "DATABASES",
  /*  134 */ "TABLES",
  /*  135 */ "STABLES",
  /*  136 */ "MNODES",
  /*  137 */ "MODULES",
  /*  138 */ "QNODES",
  /*  139 */ "FUNCTIONS",
  /*  140 */ "INDEXES",
  /*  141 */ "ACCOUNTS",
  /*  142 */ "APPS",
  /*  143 */ "CONNECTIONS",
  /*  144 */ "LICENCES",
  /*  145 */ "GRANTS",
  /*  146 */ "QUERIES",
  /*  147 */ "SCORES",
  /*  148 */ "TOPICS",
  /*  149 */ "VARIABLES",
  /*  150 */ "BNODES",
  /*  151 */ "SNODES",
  /*  152 */ "CLUSTER",
  /*  153 */ "TRANSACTIONS",
  /*  154 */ "DISTRIBUTED",
  /*  155 */ "CONSUMERS",
  /*  156 */ "SUBSCRIPTIONS",
  /*  157 */ "VNODES",
  /*  158 */ "LIKE",
  /*  159 */ "INDEX",
  /*  160 */ "FUNCTION",
  /*  161 */ "INTERVAL",
  /*  162 */ "TOPIC",
  /*  163 */ "AS",
  /*  164 */ "WITH",
  /*  165 */ "META",
  /*  166 */ "CONSUMER",
  /*  167 */ "GROUP",
  /*  168 */ "DESC",
  /*  169 */ "DESCRIBE",
  /*  170 */ "RESET",
  /*  171 */ "QUERY",
  /*  172 */ "CACHE",
  /*  173 */ "EXPLAIN",
  /*  174 */ "ANALYZE",
  /*  175 */ "VERBOSE",
  /*  176 */ "NK_BOOL",
  /*  177 */ "RATIO",
  /*  178 */ "NK_FLOAT",
  /*  179 */ "OUTPUTTYPE",
  /*  180 */ "AGGREGATE",
  /*  181 */ "BUFSIZE",
  /*  182 */ "STREAM",
  /*  183 */ "INTO",
  /*  184 */ "TRIGGER",
  /*  185 */ "AT_ONCE",
  /*  186 */ "WINDOW_CLOSE",
  /*  187 */ "IGNORE",
  /*  188 */ "EXPIRED",
  /*  189 */ "SUBTABLE",
  /*  190 */ "KILL",
  /*  191 */ "CONNECTION",
  /*  192 */ "TRANSACTION",
  /*  193 */ "BALANCE",
  /*  194 */ "VGROUP",
  /*  195 */ "MERGE",
  /*  196 */ "REDISTRIBUTE",
  /*  197 */ "SPLIT",
  /*  198 */ "DELETE",
  /*  199 */ "INSERT",
  /*  200 */ "NULL",
  /*  201 */ "NK_QUESTION",
  /*  202 */ "NK_ARROW",
  /*  203 */ "ROWTS",
  /*  204 */ "TBNAME",
  /*  205 */ "QSTART",
  /*  206 */ "QEND",
  /*  207 */ "QDURATION",
  /*  208 */ "WSTART",
  /*  209 */ "WEND",
  /*  210 */ "WDURATION",
  /*  211 */ "IROWTS",
  /*  212 */ "QTAGS",
  /*  213 */ "CAST",
  /*  214 */ "NOW",
  /*  215 */ "TODAY",
  /*  216 */ "TIMEZONE",
  /*  217 */ "CLIENT_VERSION",
  /*  218 */ "SERVER_VERSION",
  /*  219 */ "SERVER_STATUS",
  /*  220 */ "CURRENT_USER",
  /*  221 */ "COUNT",
  /*  222 */ "LAST_ROW",
  /*  223 */ "CASE",
  /*  224 */ "END",
  /*  225 */ "WHEN",
  /*  226 */ "THEN",
  /*  227 */ "ELSE",
  /*  228 */ "BETWEEN",
  /*  229 */ "IS",
  /*  230 */ "NK_LT",
  /*  231 */ "NK_GT",
  /*  232 */ "NK_LE",
  /*  233 */ "NK_GE",
  /*  234 */ "NK_NE",
  /*  235 */ "MATCH",
  /*  236 */ "NMATCH",
  /*  237 */ "CONTAINS",
  /*  238 */ "IN",
  /*  239 */ "JOIN",
  /*  240 */ "INNER",
  /*  241 */ "SELECT",
  /*  242 */ "DISTINCT",
  /*  243 */ "WHERE",
  /*  244 */ "PARTITION",
  /*  245 */ "BY",
  /*  246 */ "SESSION",
  /*  247 */ "STATE_WINDOW",
  /*  248 */ "SLIDING",
  /*  249 */ "FILL",
  /*  250 */ "VALUE",
  /*  251 */ "NONE",
  /*  252 */ "PREV",
  /*  253 */ "LINEAR",
  /*  254 */ "NEXT",
  /*  255 */ "HAVING",
  /*  256 */ "RANGE",
  /*  257 */ "EVERY",
  /*  258 */ "ORDER",
  /*  259 */ "SLIMIT",
  /*  260 */ "SOFFSET",
  /*  261 */ "LIMIT",
  /*  262 */ "OFFSET",
  /*  263 */ "ASC",
  /*  264 */ "NULLS",
  /*  265 */ "ABORT",
  /*  266 */ "AFTER",
  /*  267 */ "ATTACH",
  /*  268 */ "BEFORE",
  /*  269 */ "BEGIN",
  /*  270 */ "BITAND",
  /*  271 */ "BITNOT",
  /*  272 */ "BITOR",
  /*  273 */ "BLOCKS",
  /*  274 */ "CHANGE",
  /*  275 */ "COMMA",
  /*  276 */ "COMPACT",
  /*  277 */ "CONCAT",
  /*  278 */ "CONFLICT",
  /*  279 */ "COPY",
  /*  280 */ "DEFERRED",
  /*  281 */ "DELIMITERS",
  /*  282 */ "DETACH",
  /*  283 */ "DIVIDE",
  /*  284 */ "DOT",
  /*  285 */ "EACH",
  /*  286 */ "FAIL",
  /*  287 */ "FILE",
  /*  288 */ "FOR",
  /*  289 */ "GLOB",
  /*  290 */ "ID",
  /*  291 */ "IMMEDIATE",
  /*  292 */ "IMPORT",
  /*  293 */ "INITIALLY",
  /*  294 */ "INSTEAD",
  /*  295 */ "ISNULL",
  /*  296 */ "KEY",
  /*  297 */ "NK_BITNOT",
  /*  298 */ "NK_SEMI",
  /*  299 */ "NOTNULL",
  /*  300 */ "OF",
  /*  301 */ "PLUS",
  /*  302 */ "PRIVILEGE",
  /*  303 */ "RAISE",
  /*  304 */ "REPLACE",
  /*  305 */ "RESTRICT",
  /*  306 */ "ROW",
  /*  307 */ "SEMI",
  /*  308 */ "STAR",
  /*  309 */ "STATEMENT",
  /*  310 */ "STRING",
  /*  311 */ "TIMES",
  /*  312 */ "UPDATE",
  /*  313 */ "VALUES",
  /*  314 */ "VARIABLE",
  /*  315 */ "VIEW",
  /*  316 */ "WAL",
  /*  317 */ "cmd",
  /*  318 */ "account_options",
  /*  319 */ "alter_account_options",
  /*  320 */ "literal",
  /*  321 */ "alter_account_option",
  /*  322 */ "user_name",
  /*  323 */ "sysinfo_opt",
  /*  324 */ "privileges",
  /*  325 */ "priv_level",
  /*  326 */ "priv_type_list",
  /*  327 */ "priv_type",
  /*  328 */ "db_name",
  /*  329 */ "dnode_endpoint",
  /*  330 */ "not_exists_opt",
  /*  331 */ "db_options",
  /*  332 */ "exists_opt",
  /*  333 */ "alter_db_options",
  /*  334 */ "speed_opt",
  /*  335 */ "integer_list",
  /*  336 */ "variable_list",
  /*  337 */ "retention_list",
  /*  338 */ "alter_db_option",
  /*  339 */ "retention",
  /*  340 */ "full_table_name",
  /*  341 */ "column_def_list",
  /*  342 */ "tags_def_opt",
  /*  343 */ "table_options",
  /*  344 */ "multi_create_clause",
  /*  345 */ "tags_def",
  /*  346 */ "multi_drop_clause",
  /*  347 */ "alter_table_clause",
  /*  348 */ "alter_table_options",
  /*  349 */ "column_name",
  /*  350 */ "type_name",
  /*  351 */ "signed_literal",
  /*  352 */ "create_subtable_clause",
  /*  353 */ "specific_cols_opt",
  /*  354 */ "expression_list",
  /*  355 */ "drop_table_clause",
  /*  356 */ "col_name_list",
  /*  357 */ "table_name",
  /*  358 */ "column_def",
  /*  359 */ "duration_list",
  /*  360 */ "rollup_func_list",
  /*  361 */ "alter_table_option",
  /*  362 */ "duration_literal",
  /*  363 */ "rollup_func_name",
  /*  364 */ "function_name",
  /*  365 */ "col_name",
  /*  366 */ "db_name_cond_opt",
  /*  367 */ "like_pattern_opt",
  /*  368 */ "table_name_cond",
  /*  369 */ "from_db_opt",
  /*  370 */ "index_options",
  /*  371 */ "func_list",
  /*  372 */ "sliding_opt",
  /*  373 */ "sma_stream_opt",
  /*  374 */ "func",
  /*  375 */ "stream_options",
  /*  376 */ "topic_name",
  /*  377 */ "query_or_subquery",
  /*  378 */ "cgroup_name",
  /*  379 */ "analyze_opt",
  /*  380 */ "explain_options",
  /*  381 */ "agg_func_opt",
  /*  382 */ "bufsize_opt",
  /*  383 */ "stream_name",
  /*  384 */ "subtable_opt",
  /*  385 */ "expression",
  /*  386 */ "dnode_list",
  /*  387 */ "where_clause_opt",
  /*  388 */ "signed",
  /*  389 */ "literal_func",
  /*  390 */ "literal_list",
  /*  391 */ "table_alias",
  /*  392 */ "column_alias",
  /*  393 */ "expr_or_subquery",
  /*  394 */ "subquery",
  /*  395 */ "pseudo_column",
  /*  396 */ "column_reference",
  /*  397 */ "function_expression",
  /*  398 */ "case_when_expression",
  /*  399 */ "star_func",
  /*  400 */ "star_func_para_list",
  /*  401 */ "noarg_func",
  /*  402 */ "other_para_list",
  /*  403 */ "star_func_para",
  /*  404 */ "when_then_list",
  /*  405 */ "case_when_else_opt",
  /*  406 */ "common_expression",
  /*  407 */ "when_then_expr",
  /*  408 */ "predicate",
  /*  409 */ "compare_op",
  /*  410 */ "in_op",
  /*  411 */ "in_predicate_value",
  /*  412 */ "boolean_value_expression",
  /*  413 */ "boolean_primary",
  /*  414 */ "from_clause_opt",
  /*  415 */ "table_reference_list",
  /*  416 */ "table_reference",
  /*  417 */ "table_primary",
  /*  418 */ "joined_table",
  /*  419 */ "alias_opt",
  /*  420 */ "parenthesized_joined_table",
  /*  421 */ "join_type",
  /*  422 */ "search_condition",
  /*  423 */ "query_specification",
  /*  424 */ "set_quantifier_opt",
  /*  425 */ "select_list",
  /*  426 */ "partition_by_clause_opt",
  /*  427 */ "range_opt",
  /*  428 */ "every_opt",
  /*  429 */ "fill_opt",
  /*  430 */ "twindow_clause_opt",
  /*  431 */ "group_by_clause_opt",
  /*  432 */ "having_clause_opt",
  /*  433 */ "select_item",
  /*  434 */ "partition_list",
  /*  435 */ "partition_item",
  /*  436 */ "fill_mode",
  /*  437 */ "group_by_list",
  /*  438 */ "query_expression",
  /*  439 */ "query_simple",
  /*  440 */ "order_by_clause_opt",
  /*  441 */ "slimit_clause_opt",
  /*  442 */ "limit_clause_opt",
  /*  443 */ "union_query_expression",
  /*  444 */ "query_simple_or_subquery",
  /*  445 */ "sort_specification_list",
  /*  446 */ "sort_specification",
  /*  447 */ "ordering_specification_opt",
  /*  448 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  68 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  69 */ "not_exists_opt ::=",
 /*  70 */ "exists_opt ::= IF EXISTS",
 /*  71 */ "exists_opt ::=",
 /*  72 */ "db_options ::=",
 /*  73 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  75 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  76 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  78 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  79 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  80 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options KEEP integer_list",
 /*  82 */ "db_options ::= db_options KEEP variable_list",
 /*  83 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  84 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  85 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  86 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  87 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  88 */ "db_options ::= db_options STRICT NK_STRING",
 /*  89 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  90 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  91 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  92 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  93 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  94 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  95 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 102 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 103 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 104 */ "alter_db_options ::= alter_db_option",
 /* 105 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 106 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 107 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 108 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 109 */ "alter_db_option ::= KEEP integer_list",
 /* 110 */ "alter_db_option ::= KEEP variable_list",
 /* 111 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 112 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 113 */ "integer_list ::= NK_INTEGER",
 /* 114 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 115 */ "variable_list ::= NK_VARIABLE",
 /* 116 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 117 */ "retention_list ::= retention",
 /* 118 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 119 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 120 */ "speed_opt ::=",
 /* 121 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 122 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 123 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 124 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 125 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 126 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 127 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 128 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 129 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 130 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 131 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 132 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 133 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 134 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 135 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 136 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 138 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 139 */ "multi_create_clause ::= create_subtable_clause",
 /* 140 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 141 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 142 */ "multi_drop_clause ::= drop_table_clause",
 /* 143 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 144 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 145 */ "specific_cols_opt ::=",
 /* 146 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 147 */ "full_table_name ::= table_name",
 /* 148 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 149 */ "column_def_list ::= column_def",
 /* 150 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 151 */ "column_def ::= column_name type_name",
 /* 152 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 153 */ "type_name ::= BOOL",
 /* 154 */ "type_name ::= TINYINT",
 /* 155 */ "type_name ::= SMALLINT",
 /* 156 */ "type_name ::= INT",
 /* 157 */ "type_name ::= INTEGER",
 /* 158 */ "type_name ::= BIGINT",
 /* 159 */ "type_name ::= FLOAT",
 /* 160 */ "type_name ::= DOUBLE",
 /* 161 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 162 */ "type_name ::= TIMESTAMP",
 /* 163 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 164 */ "type_name ::= TINYINT UNSIGNED",
 /* 165 */ "type_name ::= SMALLINT UNSIGNED",
 /* 166 */ "type_name ::= INT UNSIGNED",
 /* 167 */ "type_name ::= BIGINT UNSIGNED",
 /* 168 */ "type_name ::= JSON",
 /* 169 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= MEDIUMBLOB",
 /* 171 */ "type_name ::= BLOB",
 /* 172 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 173 */ "type_name ::= DECIMAL",
 /* 174 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 175 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 176 */ "tags_def_opt ::=",
 /* 177 */ "tags_def_opt ::= tags_def",
 /* 178 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 179 */ "table_options ::=",
 /* 180 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 181 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 182 */ "table_options ::= table_options WATERMARK duration_list",
 /* 183 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 184 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 185 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 186 */ "alter_table_options ::= alter_table_option",
 /* 187 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 188 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 189 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 190 */ "duration_list ::= duration_literal",
 /* 191 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 192 */ "rollup_func_list ::= rollup_func_name",
 /* 193 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 194 */ "rollup_func_name ::= function_name",
 /* 195 */ "rollup_func_name ::= FIRST",
 /* 196 */ "rollup_func_name ::= LAST",
 /* 197 */ "col_name_list ::= col_name",
 /* 198 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 199 */ "col_name ::= column_name",
 /* 200 */ "cmd ::= SHOW DNODES",
 /* 201 */ "cmd ::= SHOW USERS",
 /* 202 */ "cmd ::= SHOW DATABASES",
 /* 203 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 204 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 205 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 206 */ "cmd ::= SHOW MNODES",
 /* 207 */ "cmd ::= SHOW MODULES",
 /* 208 */ "cmd ::= SHOW QNODES",
 /* 209 */ "cmd ::= SHOW FUNCTIONS",
 /* 210 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 211 */ "cmd ::= SHOW STREAMS",
 /* 212 */ "cmd ::= SHOW ACCOUNTS",
 /* 213 */ "cmd ::= SHOW APPS",
 /* 214 */ "cmd ::= SHOW CONNECTIONS",
 /* 215 */ "cmd ::= SHOW LICENCES",
 /* 216 */ "cmd ::= SHOW GRANTS",
 /* 217 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 218 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 219 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 220 */ "cmd ::= SHOW QUERIES",
 /* 221 */ "cmd ::= SHOW SCORES",
 /* 222 */ "cmd ::= SHOW TOPICS",
 /* 223 */ "cmd ::= SHOW VARIABLES",
 /* 224 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 225 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 226 */ "cmd ::= SHOW BNODES",
 /* 227 */ "cmd ::= SHOW SNODES",
 /* 228 */ "cmd ::= SHOW CLUSTER",
 /* 229 */ "cmd ::= SHOW TRANSACTIONS",
 /* 230 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 231 */ "cmd ::= SHOW CONSUMERS",
 /* 232 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 233 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 234 */ "cmd ::= SHOW TABLE TAGS FROM table_name_cond from_db_opt",
 /* 235 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 236 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 237 */ "db_name_cond_opt ::=",
 /* 238 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 239 */ "like_pattern_opt ::=",
 /* 240 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 241 */ "table_name_cond ::= table_name",
 /* 242 */ "from_db_opt ::=",
 /* 243 */ "from_db_opt ::= FROM db_name",
 /* 244 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 245 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 246 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 247 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 248 */ "func_list ::= func",
 /* 249 */ "func_list ::= func_list NK_COMMA func",
 /* 250 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 251 */ "sma_stream_opt ::=",
 /* 252 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 253 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 254 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 255 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 256 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 257 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 258 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 259 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 260 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 261 */ "cmd ::= DESC full_table_name",
 /* 262 */ "cmd ::= DESCRIBE full_table_name",
 /* 263 */ "cmd ::= RESET QUERY CACHE",
 /* 264 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 265 */ "analyze_opt ::=",
 /* 266 */ "analyze_opt ::= ANALYZE",
 /* 267 */ "explain_options ::=",
 /* 268 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 269 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 270 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 271 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 272 */ "agg_func_opt ::=",
 /* 273 */ "agg_func_opt ::= AGGREGATE",
 /* 274 */ "bufsize_opt ::=",
 /* 275 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 276 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 277 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 278 */ "stream_options ::=",
 /* 279 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 280 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 281 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 282 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 283 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 284 */ "subtable_opt ::=",
 /* 285 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 286 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 287 */ "cmd ::= KILL QUERY NK_STRING",
 /* 288 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 289 */ "cmd ::= BALANCE VGROUP",
 /* 290 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 291 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 292 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 293 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 294 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 295 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 296 */ "cmd ::= query_or_subquery",
 /* 297 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 298 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 299 */ "literal ::= NK_INTEGER",
 /* 300 */ "literal ::= NK_FLOAT",
 /* 301 */ "literal ::= NK_STRING",
 /* 302 */ "literal ::= NK_BOOL",
 /* 303 */ "literal ::= TIMESTAMP NK_STRING",
 /* 304 */ "literal ::= duration_literal",
 /* 305 */ "literal ::= NULL",
 /* 306 */ "literal ::= NK_QUESTION",
 /* 307 */ "duration_literal ::= NK_VARIABLE",
 /* 308 */ "signed ::= NK_INTEGER",
 /* 309 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 310 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 311 */ "signed ::= NK_FLOAT",
 /* 312 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 313 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 314 */ "signed_literal ::= signed",
 /* 315 */ "signed_literal ::= NK_STRING",
 /* 316 */ "signed_literal ::= NK_BOOL",
 /* 317 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 318 */ "signed_literal ::= duration_literal",
 /* 319 */ "signed_literal ::= NULL",
 /* 320 */ "signed_literal ::= literal_func",
 /* 321 */ "signed_literal ::= NK_QUESTION",
 /* 322 */ "literal_list ::= signed_literal",
 /* 323 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 324 */ "db_name ::= NK_ID",
 /* 325 */ "table_name ::= NK_ID",
 /* 326 */ "column_name ::= NK_ID",
 /* 327 */ "function_name ::= NK_ID",
 /* 328 */ "table_alias ::= NK_ID",
 /* 329 */ "column_alias ::= NK_ID",
 /* 330 */ "user_name ::= NK_ID",
 /* 331 */ "topic_name ::= NK_ID",
 /* 332 */ "stream_name ::= NK_ID",
 /* 333 */ "cgroup_name ::= NK_ID",
 /* 334 */ "expr_or_subquery ::= expression",
 /* 335 */ "expr_or_subquery ::= subquery",
 /* 336 */ "expression ::= literal",
 /* 337 */ "expression ::= pseudo_column",
 /* 338 */ "expression ::= column_reference",
 /* 339 */ "expression ::= function_expression",
 /* 340 */ "expression ::= case_when_expression",
 /* 341 */ "expression ::= NK_LP expression NK_RP",
 /* 342 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 343 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 344 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 345 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 346 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 347 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 348 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 349 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 350 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 351 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 352 */ "expression_list ::= expr_or_subquery",
 /* 353 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 354 */ "column_reference ::= column_name",
 /* 355 */ "column_reference ::= table_name NK_DOT column_name",
 /* 356 */ "pseudo_column ::= ROWTS",
 /* 357 */ "pseudo_column ::= TBNAME",
 /* 358 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 359 */ "pseudo_column ::= QSTART",
 /* 360 */ "pseudo_column ::= QEND",
 /* 361 */ "pseudo_column ::= QDURATION",
 /* 362 */ "pseudo_column ::= WSTART",
 /* 363 */ "pseudo_column ::= WEND",
 /* 364 */ "pseudo_column ::= WDURATION",
 /* 365 */ "pseudo_column ::= IROWTS",
 /* 366 */ "pseudo_column ::= QTAGS",
 /* 367 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 368 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 369 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 370 */ "function_expression ::= literal_func",
 /* 371 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 372 */ "literal_func ::= NOW",
 /* 373 */ "noarg_func ::= NOW",
 /* 374 */ "noarg_func ::= TODAY",
 /* 375 */ "noarg_func ::= TIMEZONE",
 /* 376 */ "noarg_func ::= DATABASE",
 /* 377 */ "noarg_func ::= CLIENT_VERSION",
 /* 378 */ "noarg_func ::= SERVER_VERSION",
 /* 379 */ "noarg_func ::= SERVER_STATUS",
 /* 380 */ "noarg_func ::= CURRENT_USER",
 /* 381 */ "noarg_func ::= USER",
 /* 382 */ "star_func ::= COUNT",
 /* 383 */ "star_func ::= FIRST",
 /* 384 */ "star_func ::= LAST",
 /* 385 */ "star_func ::= LAST_ROW",
 /* 386 */ "star_func_para_list ::= NK_STAR",
 /* 387 */ "star_func_para_list ::= other_para_list",
 /* 388 */ "other_para_list ::= star_func_para",
 /* 389 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 390 */ "star_func_para ::= expr_or_subquery",
 /* 391 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 392 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 393 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 394 */ "when_then_list ::= when_then_expr",
 /* 395 */ "when_then_list ::= when_then_list when_then_expr",
 /* 396 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 397 */ "case_when_else_opt ::=",
 /* 398 */ "case_when_else_opt ::= ELSE common_expression",
 /* 399 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 400 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 401 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 402 */ "predicate ::= expr_or_subquery IS NULL",
 /* 403 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 404 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 405 */ "compare_op ::= NK_LT",
 /* 406 */ "compare_op ::= NK_GT",
 /* 407 */ "compare_op ::= NK_LE",
 /* 408 */ "compare_op ::= NK_GE",
 /* 409 */ "compare_op ::= NK_NE",
 /* 410 */ "compare_op ::= NK_EQ",
 /* 411 */ "compare_op ::= LIKE",
 /* 412 */ "compare_op ::= NOT LIKE",
 /* 413 */ "compare_op ::= MATCH",
 /* 414 */ "compare_op ::= NMATCH",
 /* 415 */ "compare_op ::= CONTAINS",
 /* 416 */ "in_op ::= IN",
 /* 417 */ "in_op ::= NOT IN",
 /* 418 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 419 */ "boolean_value_expression ::= boolean_primary",
 /* 420 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 421 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 422 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 423 */ "boolean_primary ::= predicate",
 /* 424 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 425 */ "common_expression ::= expr_or_subquery",
 /* 426 */ "common_expression ::= boolean_value_expression",
 /* 427 */ "from_clause_opt ::=",
 /* 428 */ "from_clause_opt ::= FROM table_reference_list",
 /* 429 */ "table_reference_list ::= table_reference",
 /* 430 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 431 */ "table_reference ::= table_primary",
 /* 432 */ "table_reference ::= joined_table",
 /* 433 */ "table_primary ::= table_name alias_opt",
 /* 434 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 435 */ "table_primary ::= subquery alias_opt",
 /* 436 */ "table_primary ::= parenthesized_joined_table",
 /* 437 */ "alias_opt ::=",
 /* 438 */ "alias_opt ::= table_alias",
 /* 439 */ "alias_opt ::= AS table_alias",
 /* 440 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 441 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 442 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 443 */ "join_type ::=",
 /* 444 */ "join_type ::= INNER",
 /* 445 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 446 */ "set_quantifier_opt ::=",
 /* 447 */ "set_quantifier_opt ::= DISTINCT",
 /* 448 */ "set_quantifier_opt ::= ALL",
 /* 449 */ "select_list ::= select_item",
 /* 450 */ "select_list ::= select_list NK_COMMA select_item",
 /* 451 */ "select_item ::= NK_STAR",
 /* 452 */ "select_item ::= common_expression",
 /* 453 */ "select_item ::= common_expression column_alias",
 /* 454 */ "select_item ::= common_expression AS column_alias",
 /* 455 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 456 */ "where_clause_opt ::=",
 /* 457 */ "where_clause_opt ::= WHERE search_condition",
 /* 458 */ "partition_by_clause_opt ::=",
 /* 459 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 460 */ "partition_list ::= partition_item",
 /* 461 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 462 */ "partition_item ::= expr_or_subquery",
 /* 463 */ "partition_item ::= expr_or_subquery column_alias",
 /* 464 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 465 */ "twindow_clause_opt ::=",
 /* 466 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 467 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 468 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 469 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 470 */ "sliding_opt ::=",
 /* 471 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 472 */ "fill_opt ::=",
 /* 473 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 474 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 475 */ "fill_mode ::= NONE",
 /* 476 */ "fill_mode ::= PREV",
 /* 477 */ "fill_mode ::= NULL",
 /* 478 */ "fill_mode ::= LINEAR",
 /* 479 */ "fill_mode ::= NEXT",
 /* 480 */ "group_by_clause_opt ::=",
 /* 481 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 482 */ "group_by_list ::= expr_or_subquery",
 /* 483 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 484 */ "having_clause_opt ::=",
 /* 485 */ "having_clause_opt ::= HAVING search_condition",
 /* 486 */ "range_opt ::=",
 /* 487 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 488 */ "every_opt ::=",
 /* 489 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 490 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 491 */ "query_simple ::= query_specification",
 /* 492 */ "query_simple ::= union_query_expression",
 /* 493 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 494 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 495 */ "query_simple_or_subquery ::= query_simple",
 /* 496 */ "query_simple_or_subquery ::= subquery",
 /* 497 */ "query_or_subquery ::= query_expression",
 /* 498 */ "query_or_subquery ::= subquery",
 /* 499 */ "order_by_clause_opt ::=",
 /* 500 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 501 */ "slimit_clause_opt ::=",
 /* 502 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 503 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 504 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 505 */ "limit_clause_opt ::=",
 /* 506 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 507 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 508 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 509 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 510 */ "subquery ::= NK_LP subquery NK_RP",
 /* 511 */ "search_condition ::= common_expression",
 /* 512 */ "sort_specification_list ::= sort_specification",
 /* 513 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 514 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 515 */ "ordering_specification_opt ::=",
 /* 516 */ "ordering_specification_opt ::= ASC",
 /* 517 */ "ordering_specification_opt ::= DESC",
 /* 518 */ "null_ordering_opt ::=",
 /* 519 */ "null_ordering_opt ::= NULLS FIRST",
 /* 520 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 317: /* cmd */
    case 320: /* literal */
    case 331: /* db_options */
    case 333: /* alter_db_options */
    case 339: /* retention */
    case 340: /* full_table_name */
    case 343: /* table_options */
    case 347: /* alter_table_clause */
    case 348: /* alter_table_options */
    case 351: /* signed_literal */
    case 352: /* create_subtable_clause */
    case 355: /* drop_table_clause */
    case 358: /* column_def */
    case 362: /* duration_literal */
    case 363: /* rollup_func_name */
    case 365: /* col_name */
    case 366: /* db_name_cond_opt */
    case 367: /* like_pattern_opt */
    case 368: /* table_name_cond */
    case 369: /* from_db_opt */
    case 370: /* index_options */
    case 372: /* sliding_opt */
    case 373: /* sma_stream_opt */
    case 374: /* func */
    case 375: /* stream_options */
    case 377: /* query_or_subquery */
    case 380: /* explain_options */
    case 384: /* subtable_opt */
    case 385: /* expression */
    case 387: /* where_clause_opt */
    case 388: /* signed */
    case 389: /* literal_func */
    case 393: /* expr_or_subquery */
    case 394: /* subquery */
    case 395: /* pseudo_column */
    case 396: /* column_reference */
    case 397: /* function_expression */
    case 398: /* case_when_expression */
    case 403: /* star_func_para */
    case 405: /* case_when_else_opt */
    case 406: /* common_expression */
    case 407: /* when_then_expr */
    case 408: /* predicate */
    case 411: /* in_predicate_value */
    case 412: /* boolean_value_expression */
    case 413: /* boolean_primary */
    case 414: /* from_clause_opt */
    case 415: /* table_reference_list */
    case 416: /* table_reference */
    case 417: /* table_primary */
    case 418: /* joined_table */
    case 420: /* parenthesized_joined_table */
    case 422: /* search_condition */
    case 423: /* query_specification */
    case 427: /* range_opt */
    case 428: /* every_opt */
    case 429: /* fill_opt */
    case 430: /* twindow_clause_opt */
    case 432: /* having_clause_opt */
    case 433: /* select_item */
    case 435: /* partition_item */
    case 438: /* query_expression */
    case 439: /* query_simple */
    case 441: /* slimit_clause_opt */
    case 442: /* limit_clause_opt */
    case 443: /* union_query_expression */
    case 444: /* query_simple_or_subquery */
    case 446: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy778)); 
}
      break;
    case 318: /* account_options */
    case 319: /* alter_account_options */
    case 321: /* alter_account_option */
    case 334: /* speed_opt */
    case 382: /* bufsize_opt */
{
 
}
      break;
    case 322: /* user_name */
    case 325: /* priv_level */
    case 328: /* db_name */
    case 329: /* dnode_endpoint */
    case 349: /* column_name */
    case 357: /* table_name */
    case 364: /* function_name */
    case 376: /* topic_name */
    case 378: /* cgroup_name */
    case 383: /* stream_name */
    case 391: /* table_alias */
    case 392: /* column_alias */
    case 399: /* star_func */
    case 401: /* noarg_func */
    case 419: /* alias_opt */
{
 
}
      break;
    case 323: /* sysinfo_opt */
{
 
}
      break;
    case 324: /* privileges */
    case 326: /* priv_type_list */
    case 327: /* priv_type */
{
 
}
      break;
    case 330: /* not_exists_opt */
    case 332: /* exists_opt */
    case 379: /* analyze_opt */
    case 381: /* agg_func_opt */
    case 424: /* set_quantifier_opt */
{
 
}
      break;
    case 335: /* integer_list */
    case 336: /* variable_list */
    case 337: /* retention_list */
    case 341: /* column_def_list */
    case 342: /* tags_def_opt */
    case 344: /* multi_create_clause */
    case 345: /* tags_def */
    case 346: /* multi_drop_clause */
    case 353: /* specific_cols_opt */
    case 354: /* expression_list */
    case 356: /* col_name_list */
    case 359: /* duration_list */
    case 360: /* rollup_func_list */
    case 371: /* func_list */
    case 386: /* dnode_list */
    case 390: /* literal_list */
    case 400: /* star_func_para_list */
    case 402: /* other_para_list */
    case 404: /* when_then_list */
    case 425: /* select_list */
    case 426: /* partition_by_clause_opt */
    case 431: /* group_by_clause_opt */
    case 434: /* partition_list */
    case 437: /* group_by_list */
    case 440: /* order_by_clause_opt */
    case 445: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy282)); 
}
      break;
    case 338: /* alter_db_option */
    case 361: /* alter_table_option */
{
 
}
      break;
    case 350: /* type_name */
{
 
}
      break;
    case 409: /* compare_op */
    case 410: /* in_op */
{
 
}
      break;
    case 421: /* join_type */
{
 
}
      break;
    case 436: /* fill_mode */
{
 
}
      break;
    case 447: /* ordering_specification_opt */
{
 
}
      break;
    case 448: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  317,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  317,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  318,    0 }, /* (2) account_options ::= */
  {  318,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  318,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  318,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  318,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  318,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  318,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  318,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  318,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  318,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  319,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  319,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  321,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  321,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  321,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  321,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  321,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  321,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  321,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  321,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  321,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  321,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  317,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  317,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  317,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  317,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  317,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  323,    0 }, /* (29) sysinfo_opt ::= */
  {  323,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  317,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  317,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  324,   -1 }, /* (33) privileges ::= ALL */
  {  324,   -1 }, /* (34) privileges ::= priv_type_list */
  {  326,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  326,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  327,   -1 }, /* (37) priv_type ::= READ */
  {  327,   -1 }, /* (38) priv_type ::= WRITE */
  {  325,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  325,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  317,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  317,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  317,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  317,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  317,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  317,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  317,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  317,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  329,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  329,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  329,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  317,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  317,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  317,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  317,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  317,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  317,   -2 }, /* (64) cmd ::= USE db_name */
  {  317,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  317,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  317,   -4 }, /* (67) cmd ::= TRIM DATABASE db_name speed_opt */
  {  330,   -3 }, /* (68) not_exists_opt ::= IF NOT EXISTS */
  {  330,    0 }, /* (69) not_exists_opt ::= */
  {  332,   -2 }, /* (70) exists_opt ::= IF EXISTS */
  {  332,    0 }, /* (71) exists_opt ::= */
  {  331,    0 }, /* (72) db_options ::= */
  {  331,   -3 }, /* (73) db_options ::= db_options BUFFER NK_INTEGER */
  {  331,   -3 }, /* (74) db_options ::= db_options CACHEMODEL NK_STRING */
  {  331,   -3 }, /* (75) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  331,   -3 }, /* (76) db_options ::= db_options COMP NK_INTEGER */
  {  331,   -3 }, /* (77) db_options ::= db_options DURATION NK_INTEGER */
  {  331,   -3 }, /* (78) db_options ::= db_options DURATION NK_VARIABLE */
  {  331,   -3 }, /* (79) db_options ::= db_options MAXROWS NK_INTEGER */
  {  331,   -3 }, /* (80) db_options ::= db_options MINROWS NK_INTEGER */
  {  331,   -3 }, /* (81) db_options ::= db_options KEEP integer_list */
  {  331,   -3 }, /* (82) db_options ::= db_options KEEP variable_list */
  {  331,   -3 }, /* (83) db_options ::= db_options PAGES NK_INTEGER */
  {  331,   -3 }, /* (84) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  331,   -3 }, /* (85) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  331,   -3 }, /* (86) db_options ::= db_options PRECISION NK_STRING */
  {  331,   -3 }, /* (87) db_options ::= db_options REPLICA NK_INTEGER */
  {  331,   -3 }, /* (88) db_options ::= db_options STRICT NK_STRING */
  {  331,   -3 }, /* (89) db_options ::= db_options VGROUPS NK_INTEGER */
  {  331,   -3 }, /* (90) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  331,   -3 }, /* (91) db_options ::= db_options RETENTIONS retention_list */
  {  331,   -3 }, /* (92) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  331,   -3 }, /* (93) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  331,   -3 }, /* (94) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  331,   -3 }, /* (95) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  331,   -4 }, /* (96) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  331,   -3 }, /* (97) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  331,   -4 }, /* (98) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  331,   -3 }, /* (99) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  331,   -3 }, /* (100) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  331,   -3 }, /* (101) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  331,   -3 }, /* (102) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  331,   -3 }, /* (103) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  333,   -1 }, /* (104) alter_db_options ::= alter_db_option */
  {  333,   -2 }, /* (105) alter_db_options ::= alter_db_options alter_db_option */
  {  338,   -2 }, /* (106) alter_db_option ::= CACHEMODEL NK_STRING */
  {  338,   -2 }, /* (107) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  338,   -2 }, /* (108) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  338,   -2 }, /* (109) alter_db_option ::= KEEP integer_list */
  {  338,   -2 }, /* (110) alter_db_option ::= KEEP variable_list */
  {  338,   -2 }, /* (111) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  338,   -2 }, /* (112) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  335,   -1 }, /* (113) integer_list ::= NK_INTEGER */
  {  335,   -3 }, /* (114) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  336,   -1 }, /* (115) variable_list ::= NK_VARIABLE */
  {  336,   -3 }, /* (116) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  337,   -1 }, /* (117) retention_list ::= retention */
  {  337,   -3 }, /* (118) retention_list ::= retention_list NK_COMMA retention */
  {  339,   -3 }, /* (119) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  334,    0 }, /* (120) speed_opt ::= */
  {  334,   -2 }, /* (121) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  317,   -9 }, /* (122) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  317,   -3 }, /* (123) cmd ::= CREATE TABLE multi_create_clause */
  {  317,   -9 }, /* (124) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  317,   -3 }, /* (125) cmd ::= DROP TABLE multi_drop_clause */
  {  317,   -4 }, /* (126) cmd ::= DROP STABLE exists_opt full_table_name */
  {  317,   -3 }, /* (127) cmd ::= ALTER TABLE alter_table_clause */
  {  317,   -3 }, /* (128) cmd ::= ALTER STABLE alter_table_clause */
  {  347,   -2 }, /* (129) alter_table_clause ::= full_table_name alter_table_options */
  {  347,   -5 }, /* (130) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  347,   -4 }, /* (131) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  347,   -5 }, /* (132) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  347,   -5 }, /* (133) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  347,   -5 }, /* (134) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  347,   -4 }, /* (135) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  347,   -5 }, /* (136) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  347,   -5 }, /* (137) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  347,   -6 }, /* (138) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  344,   -1 }, /* (139) multi_create_clause ::= create_subtable_clause */
  {  344,   -2 }, /* (140) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  352,  -10 }, /* (141) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  346,   -1 }, /* (142) multi_drop_clause ::= drop_table_clause */
  {  346,   -2 }, /* (143) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  355,   -2 }, /* (144) drop_table_clause ::= exists_opt full_table_name */
  {  353,    0 }, /* (145) specific_cols_opt ::= */
  {  353,   -3 }, /* (146) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  340,   -1 }, /* (147) full_table_name ::= table_name */
  {  340,   -3 }, /* (148) full_table_name ::= db_name NK_DOT table_name */
  {  341,   -1 }, /* (149) column_def_list ::= column_def */
  {  341,   -3 }, /* (150) column_def_list ::= column_def_list NK_COMMA column_def */
  {  358,   -2 }, /* (151) column_def ::= column_name type_name */
  {  358,   -4 }, /* (152) column_def ::= column_name type_name COMMENT NK_STRING */
  {  350,   -1 }, /* (153) type_name ::= BOOL */
  {  350,   -1 }, /* (154) type_name ::= TINYINT */
  {  350,   -1 }, /* (155) type_name ::= SMALLINT */
  {  350,   -1 }, /* (156) type_name ::= INT */
  {  350,   -1 }, /* (157) type_name ::= INTEGER */
  {  350,   -1 }, /* (158) type_name ::= BIGINT */
  {  350,   -1 }, /* (159) type_name ::= FLOAT */
  {  350,   -1 }, /* (160) type_name ::= DOUBLE */
  {  350,   -4 }, /* (161) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  350,   -1 }, /* (162) type_name ::= TIMESTAMP */
  {  350,   -4 }, /* (163) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  350,   -2 }, /* (164) type_name ::= TINYINT UNSIGNED */
  {  350,   -2 }, /* (165) type_name ::= SMALLINT UNSIGNED */
  {  350,   -2 }, /* (166) type_name ::= INT UNSIGNED */
  {  350,   -2 }, /* (167) type_name ::= BIGINT UNSIGNED */
  {  350,   -1 }, /* (168) type_name ::= JSON */
  {  350,   -4 }, /* (169) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  350,   -1 }, /* (170) type_name ::= MEDIUMBLOB */
  {  350,   -1 }, /* (171) type_name ::= BLOB */
  {  350,   -4 }, /* (172) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  350,   -1 }, /* (173) type_name ::= DECIMAL */
  {  350,   -4 }, /* (174) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  350,   -6 }, /* (175) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  342,    0 }, /* (176) tags_def_opt ::= */
  {  342,   -1 }, /* (177) tags_def_opt ::= tags_def */
  {  345,   -4 }, /* (178) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  343,    0 }, /* (179) table_options ::= */
  {  343,   -3 }, /* (180) table_options ::= table_options COMMENT NK_STRING */
  {  343,   -3 }, /* (181) table_options ::= table_options MAX_DELAY duration_list */
  {  343,   -3 }, /* (182) table_options ::= table_options WATERMARK duration_list */
  {  343,   -5 }, /* (183) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  343,   -3 }, /* (184) table_options ::= table_options TTL NK_INTEGER */
  {  343,   -5 }, /* (185) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  348,   -1 }, /* (186) alter_table_options ::= alter_table_option */
  {  348,   -2 }, /* (187) alter_table_options ::= alter_table_options alter_table_option */
  {  361,   -2 }, /* (188) alter_table_option ::= COMMENT NK_STRING */
  {  361,   -2 }, /* (189) alter_table_option ::= TTL NK_INTEGER */
  {  359,   -1 }, /* (190) duration_list ::= duration_literal */
  {  359,   -3 }, /* (191) duration_list ::= duration_list NK_COMMA duration_literal */
  {  360,   -1 }, /* (192) rollup_func_list ::= rollup_func_name */
  {  360,   -3 }, /* (193) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  363,   -1 }, /* (194) rollup_func_name ::= function_name */
  {  363,   -1 }, /* (195) rollup_func_name ::= FIRST */
  {  363,   -1 }, /* (196) rollup_func_name ::= LAST */
  {  356,   -1 }, /* (197) col_name_list ::= col_name */
  {  356,   -3 }, /* (198) col_name_list ::= col_name_list NK_COMMA col_name */
  {  365,   -1 }, /* (199) col_name ::= column_name */
  {  317,   -2 }, /* (200) cmd ::= SHOW DNODES */
  {  317,   -2 }, /* (201) cmd ::= SHOW USERS */
  {  317,   -2 }, /* (202) cmd ::= SHOW DATABASES */
  {  317,   -4 }, /* (203) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  317,   -4 }, /* (204) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  317,   -3 }, /* (205) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  317,   -2 }, /* (206) cmd ::= SHOW MNODES */
  {  317,   -2 }, /* (207) cmd ::= SHOW MODULES */
  {  317,   -2 }, /* (208) cmd ::= SHOW QNODES */
  {  317,   -2 }, /* (209) cmd ::= SHOW FUNCTIONS */
  {  317,   -5 }, /* (210) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  317,   -2 }, /* (211) cmd ::= SHOW STREAMS */
  {  317,   -2 }, /* (212) cmd ::= SHOW ACCOUNTS */
  {  317,   -2 }, /* (213) cmd ::= SHOW APPS */
  {  317,   -2 }, /* (214) cmd ::= SHOW CONNECTIONS */
  {  317,   -2 }, /* (215) cmd ::= SHOW LICENCES */
  {  317,   -2 }, /* (216) cmd ::= SHOW GRANTS */
  {  317,   -4 }, /* (217) cmd ::= SHOW CREATE DATABASE db_name */
  {  317,   -4 }, /* (218) cmd ::= SHOW CREATE TABLE full_table_name */
  {  317,   -4 }, /* (219) cmd ::= SHOW CREATE STABLE full_table_name */
  {  317,   -2 }, /* (220) cmd ::= SHOW QUERIES */
  {  317,   -2 }, /* (221) cmd ::= SHOW SCORES */
  {  317,   -2 }, /* (222) cmd ::= SHOW TOPICS */
  {  317,   -2 }, /* (223) cmd ::= SHOW VARIABLES */
  {  317,   -3 }, /* (224) cmd ::= SHOW LOCAL VARIABLES */
  {  317,   -4 }, /* (225) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  317,   -2 }, /* (226) cmd ::= SHOW BNODES */
  {  317,   -2 }, /* (227) cmd ::= SHOW SNODES */
  {  317,   -2 }, /* (228) cmd ::= SHOW CLUSTER */
  {  317,   -2 }, /* (229) cmd ::= SHOW TRANSACTIONS */
  {  317,   -4 }, /* (230) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  317,   -2 }, /* (231) cmd ::= SHOW CONSUMERS */
  {  317,   -2 }, /* (232) cmd ::= SHOW SUBSCRIPTIONS */
  {  317,   -5 }, /* (233) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  317,   -6 }, /* (234) cmd ::= SHOW TABLE TAGS FROM table_name_cond from_db_opt */
  {  317,   -3 }, /* (235) cmd ::= SHOW VNODES NK_INTEGER */
  {  317,   -3 }, /* (236) cmd ::= SHOW VNODES NK_STRING */
  {  366,    0 }, /* (237) db_name_cond_opt ::= */
  {  366,   -2 }, /* (238) db_name_cond_opt ::= db_name NK_DOT */
  {  367,    0 }, /* (239) like_pattern_opt ::= */
  {  367,   -2 }, /* (240) like_pattern_opt ::= LIKE NK_STRING */
  {  368,   -1 }, /* (241) table_name_cond ::= table_name */
  {  369,    0 }, /* (242) from_db_opt ::= */
  {  369,   -2 }, /* (243) from_db_opt ::= FROM db_name */
  {  317,   -8 }, /* (244) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  317,   -4 }, /* (245) cmd ::= DROP INDEX exists_opt full_table_name */
  {  370,  -10 }, /* (246) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  370,  -12 }, /* (247) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  371,   -1 }, /* (248) func_list ::= func */
  {  371,   -3 }, /* (249) func_list ::= func_list NK_COMMA func */
  {  374,   -4 }, /* (250) func ::= function_name NK_LP expression_list NK_RP */
  {  373,    0 }, /* (251) sma_stream_opt ::= */
  {  373,   -3 }, /* (252) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  373,   -3 }, /* (253) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  317,   -6 }, /* (254) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  317,   -7 }, /* (255) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  317,   -9 }, /* (256) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  317,   -7 }, /* (257) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  317,   -9 }, /* (258) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  317,   -4 }, /* (259) cmd ::= DROP TOPIC exists_opt topic_name */
  {  317,   -7 }, /* (260) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  317,   -2 }, /* (261) cmd ::= DESC full_table_name */
  {  317,   -2 }, /* (262) cmd ::= DESCRIBE full_table_name */
  {  317,   -3 }, /* (263) cmd ::= RESET QUERY CACHE */
  {  317,   -4 }, /* (264) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  379,    0 }, /* (265) analyze_opt ::= */
  {  379,   -1 }, /* (266) analyze_opt ::= ANALYZE */
  {  380,    0 }, /* (267) explain_options ::= */
  {  380,   -3 }, /* (268) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  380,   -3 }, /* (269) explain_options ::= explain_options RATIO NK_FLOAT */
  {  317,  -10 }, /* (270) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  317,   -4 }, /* (271) cmd ::= DROP FUNCTION exists_opt function_name */
  {  381,    0 }, /* (272) agg_func_opt ::= */
  {  381,   -1 }, /* (273) agg_func_opt ::= AGGREGATE */
  {  382,    0 }, /* (274) bufsize_opt ::= */
  {  382,   -2 }, /* (275) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  317,  -11 }, /* (276) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  317,   -4 }, /* (277) cmd ::= DROP STREAM exists_opt stream_name */
  {  375,    0 }, /* (278) stream_options ::= */
  {  375,   -3 }, /* (279) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  375,   -3 }, /* (280) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  375,   -4 }, /* (281) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  375,   -3 }, /* (282) stream_options ::= stream_options WATERMARK duration_literal */
  {  375,   -4 }, /* (283) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  384,    0 }, /* (284) subtable_opt ::= */
  {  384,   -4 }, /* (285) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  317,   -3 }, /* (286) cmd ::= KILL CONNECTION NK_INTEGER */
  {  317,   -3 }, /* (287) cmd ::= KILL QUERY NK_STRING */
  {  317,   -3 }, /* (288) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  317,   -2 }, /* (289) cmd ::= BALANCE VGROUP */
  {  317,   -4 }, /* (290) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  317,   -4 }, /* (291) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  317,   -3 }, /* (292) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  386,   -2 }, /* (293) dnode_list ::= DNODE NK_INTEGER */
  {  386,   -3 }, /* (294) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  317,   -4 }, /* (295) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  317,   -1 }, /* (296) cmd ::= query_or_subquery */
  {  317,   -7 }, /* (297) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  317,   -4 }, /* (298) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  320,   -1 }, /* (299) literal ::= NK_INTEGER */
  {  320,   -1 }, /* (300) literal ::= NK_FLOAT */
  {  320,   -1 }, /* (301) literal ::= NK_STRING */
  {  320,   -1 }, /* (302) literal ::= NK_BOOL */
  {  320,   -2 }, /* (303) literal ::= TIMESTAMP NK_STRING */
  {  320,   -1 }, /* (304) literal ::= duration_literal */
  {  320,   -1 }, /* (305) literal ::= NULL */
  {  320,   -1 }, /* (306) literal ::= NK_QUESTION */
  {  362,   -1 }, /* (307) duration_literal ::= NK_VARIABLE */
  {  388,   -1 }, /* (308) signed ::= NK_INTEGER */
  {  388,   -2 }, /* (309) signed ::= NK_PLUS NK_INTEGER */
  {  388,   -2 }, /* (310) signed ::= NK_MINUS NK_INTEGER */
  {  388,   -1 }, /* (311) signed ::= NK_FLOAT */
  {  388,   -2 }, /* (312) signed ::= NK_PLUS NK_FLOAT */
  {  388,   -2 }, /* (313) signed ::= NK_MINUS NK_FLOAT */
  {  351,   -1 }, /* (314) signed_literal ::= signed */
  {  351,   -1 }, /* (315) signed_literal ::= NK_STRING */
  {  351,   -1 }, /* (316) signed_literal ::= NK_BOOL */
  {  351,   -2 }, /* (317) signed_literal ::= TIMESTAMP NK_STRING */
  {  351,   -1 }, /* (318) signed_literal ::= duration_literal */
  {  351,   -1 }, /* (319) signed_literal ::= NULL */
  {  351,   -1 }, /* (320) signed_literal ::= literal_func */
  {  351,   -1 }, /* (321) signed_literal ::= NK_QUESTION */
  {  390,   -1 }, /* (322) literal_list ::= signed_literal */
  {  390,   -3 }, /* (323) literal_list ::= literal_list NK_COMMA signed_literal */
  {  328,   -1 }, /* (324) db_name ::= NK_ID */
  {  357,   -1 }, /* (325) table_name ::= NK_ID */
  {  349,   -1 }, /* (326) column_name ::= NK_ID */
  {  364,   -1 }, /* (327) function_name ::= NK_ID */
  {  391,   -1 }, /* (328) table_alias ::= NK_ID */
  {  392,   -1 }, /* (329) column_alias ::= NK_ID */
  {  322,   -1 }, /* (330) user_name ::= NK_ID */
  {  376,   -1 }, /* (331) topic_name ::= NK_ID */
  {  383,   -1 }, /* (332) stream_name ::= NK_ID */
  {  378,   -1 }, /* (333) cgroup_name ::= NK_ID */
  {  393,   -1 }, /* (334) expr_or_subquery ::= expression */
  {  393,   -1 }, /* (335) expr_or_subquery ::= subquery */
  {  385,   -1 }, /* (336) expression ::= literal */
  {  385,   -1 }, /* (337) expression ::= pseudo_column */
  {  385,   -1 }, /* (338) expression ::= column_reference */
  {  385,   -1 }, /* (339) expression ::= function_expression */
  {  385,   -1 }, /* (340) expression ::= case_when_expression */
  {  385,   -3 }, /* (341) expression ::= NK_LP expression NK_RP */
  {  385,   -2 }, /* (342) expression ::= NK_PLUS expr_or_subquery */
  {  385,   -2 }, /* (343) expression ::= NK_MINUS expr_or_subquery */
  {  385,   -3 }, /* (344) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  385,   -3 }, /* (345) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  385,   -3 }, /* (346) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  385,   -3 }, /* (347) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  385,   -3 }, /* (348) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  385,   -3 }, /* (349) expression ::= column_reference NK_ARROW NK_STRING */
  {  385,   -3 }, /* (350) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  385,   -3 }, /* (351) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  354,   -1 }, /* (352) expression_list ::= expr_or_subquery */
  {  354,   -3 }, /* (353) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  396,   -1 }, /* (354) column_reference ::= column_name */
  {  396,   -3 }, /* (355) column_reference ::= table_name NK_DOT column_name */
  {  395,   -1 }, /* (356) pseudo_column ::= ROWTS */
  {  395,   -1 }, /* (357) pseudo_column ::= TBNAME */
  {  395,   -3 }, /* (358) pseudo_column ::= table_name NK_DOT TBNAME */
  {  395,   -1 }, /* (359) pseudo_column ::= QSTART */
  {  395,   -1 }, /* (360) pseudo_column ::= QEND */
  {  395,   -1 }, /* (361) pseudo_column ::= QDURATION */
  {  395,   -1 }, /* (362) pseudo_column ::= WSTART */
  {  395,   -1 }, /* (363) pseudo_column ::= WEND */
  {  395,   -1 }, /* (364) pseudo_column ::= WDURATION */
  {  395,   -1 }, /* (365) pseudo_column ::= IROWTS */
  {  395,   -1 }, /* (366) pseudo_column ::= QTAGS */
  {  397,   -4 }, /* (367) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  397,   -4 }, /* (368) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  397,   -6 }, /* (369) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  397,   -1 }, /* (370) function_expression ::= literal_func */
  {  389,   -3 }, /* (371) literal_func ::= noarg_func NK_LP NK_RP */
  {  389,   -1 }, /* (372) literal_func ::= NOW */
  {  401,   -1 }, /* (373) noarg_func ::= NOW */
  {  401,   -1 }, /* (374) noarg_func ::= TODAY */
  {  401,   -1 }, /* (375) noarg_func ::= TIMEZONE */
  {  401,   -1 }, /* (376) noarg_func ::= DATABASE */
  {  401,   -1 }, /* (377) noarg_func ::= CLIENT_VERSION */
  {  401,   -1 }, /* (378) noarg_func ::= SERVER_VERSION */
  {  401,   -1 }, /* (379) noarg_func ::= SERVER_STATUS */
  {  401,   -1 }, /* (380) noarg_func ::= CURRENT_USER */
  {  401,   -1 }, /* (381) noarg_func ::= USER */
  {  399,   -1 }, /* (382) star_func ::= COUNT */
  {  399,   -1 }, /* (383) star_func ::= FIRST */
  {  399,   -1 }, /* (384) star_func ::= LAST */
  {  399,   -1 }, /* (385) star_func ::= LAST_ROW */
  {  400,   -1 }, /* (386) star_func_para_list ::= NK_STAR */
  {  400,   -1 }, /* (387) star_func_para_list ::= other_para_list */
  {  402,   -1 }, /* (388) other_para_list ::= star_func_para */
  {  402,   -3 }, /* (389) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  403,   -1 }, /* (390) star_func_para ::= expr_or_subquery */
  {  403,   -3 }, /* (391) star_func_para ::= table_name NK_DOT NK_STAR */
  {  398,   -4 }, /* (392) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  398,   -5 }, /* (393) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  404,   -1 }, /* (394) when_then_list ::= when_then_expr */
  {  404,   -2 }, /* (395) when_then_list ::= when_then_list when_then_expr */
  {  407,   -4 }, /* (396) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  405,    0 }, /* (397) case_when_else_opt ::= */
  {  405,   -2 }, /* (398) case_when_else_opt ::= ELSE common_expression */
  {  408,   -3 }, /* (399) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  408,   -5 }, /* (400) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  408,   -6 }, /* (401) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  408,   -3 }, /* (402) predicate ::= expr_or_subquery IS NULL */
  {  408,   -4 }, /* (403) predicate ::= expr_or_subquery IS NOT NULL */
  {  408,   -3 }, /* (404) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  409,   -1 }, /* (405) compare_op ::= NK_LT */
  {  409,   -1 }, /* (406) compare_op ::= NK_GT */
  {  409,   -1 }, /* (407) compare_op ::= NK_LE */
  {  409,   -1 }, /* (408) compare_op ::= NK_GE */
  {  409,   -1 }, /* (409) compare_op ::= NK_NE */
  {  409,   -1 }, /* (410) compare_op ::= NK_EQ */
  {  409,   -1 }, /* (411) compare_op ::= LIKE */
  {  409,   -2 }, /* (412) compare_op ::= NOT LIKE */
  {  409,   -1 }, /* (413) compare_op ::= MATCH */
  {  409,   -1 }, /* (414) compare_op ::= NMATCH */
  {  409,   -1 }, /* (415) compare_op ::= CONTAINS */
  {  410,   -1 }, /* (416) in_op ::= IN */
  {  410,   -2 }, /* (417) in_op ::= NOT IN */
  {  411,   -3 }, /* (418) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  412,   -1 }, /* (419) boolean_value_expression ::= boolean_primary */
  {  412,   -2 }, /* (420) boolean_value_expression ::= NOT boolean_primary */
  {  412,   -3 }, /* (421) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  412,   -3 }, /* (422) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  413,   -1 }, /* (423) boolean_primary ::= predicate */
  {  413,   -3 }, /* (424) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  406,   -1 }, /* (425) common_expression ::= expr_or_subquery */
  {  406,   -1 }, /* (426) common_expression ::= boolean_value_expression */
  {  414,    0 }, /* (427) from_clause_opt ::= */
  {  414,   -2 }, /* (428) from_clause_opt ::= FROM table_reference_list */
  {  415,   -1 }, /* (429) table_reference_list ::= table_reference */
  {  415,   -3 }, /* (430) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  416,   -1 }, /* (431) table_reference ::= table_primary */
  {  416,   -1 }, /* (432) table_reference ::= joined_table */
  {  417,   -2 }, /* (433) table_primary ::= table_name alias_opt */
  {  417,   -4 }, /* (434) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  417,   -2 }, /* (435) table_primary ::= subquery alias_opt */
  {  417,   -1 }, /* (436) table_primary ::= parenthesized_joined_table */
  {  419,    0 }, /* (437) alias_opt ::= */
  {  419,   -1 }, /* (438) alias_opt ::= table_alias */
  {  419,   -2 }, /* (439) alias_opt ::= AS table_alias */
  {  420,   -3 }, /* (440) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  420,   -3 }, /* (441) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  418,   -6 }, /* (442) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  421,    0 }, /* (443) join_type ::= */
  {  421,   -1 }, /* (444) join_type ::= INNER */
  {  423,  -12 }, /* (445) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  424,    0 }, /* (446) set_quantifier_opt ::= */
  {  424,   -1 }, /* (447) set_quantifier_opt ::= DISTINCT */
  {  424,   -1 }, /* (448) set_quantifier_opt ::= ALL */
  {  425,   -1 }, /* (449) select_list ::= select_item */
  {  425,   -3 }, /* (450) select_list ::= select_list NK_COMMA select_item */
  {  433,   -1 }, /* (451) select_item ::= NK_STAR */
  {  433,   -1 }, /* (452) select_item ::= common_expression */
  {  433,   -2 }, /* (453) select_item ::= common_expression column_alias */
  {  433,   -3 }, /* (454) select_item ::= common_expression AS column_alias */
  {  433,   -3 }, /* (455) select_item ::= table_name NK_DOT NK_STAR */
  {  387,    0 }, /* (456) where_clause_opt ::= */
  {  387,   -2 }, /* (457) where_clause_opt ::= WHERE search_condition */
  {  426,    0 }, /* (458) partition_by_clause_opt ::= */
  {  426,   -3 }, /* (459) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  434,   -1 }, /* (460) partition_list ::= partition_item */
  {  434,   -3 }, /* (461) partition_list ::= partition_list NK_COMMA partition_item */
  {  435,   -1 }, /* (462) partition_item ::= expr_or_subquery */
  {  435,   -2 }, /* (463) partition_item ::= expr_or_subquery column_alias */
  {  435,   -3 }, /* (464) partition_item ::= expr_or_subquery AS column_alias */
  {  430,    0 }, /* (465) twindow_clause_opt ::= */
  {  430,   -6 }, /* (466) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  430,   -4 }, /* (467) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  430,   -6 }, /* (468) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  430,   -8 }, /* (469) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  372,    0 }, /* (470) sliding_opt ::= */
  {  372,   -4 }, /* (471) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  429,    0 }, /* (472) fill_opt ::= */
  {  429,   -4 }, /* (473) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  429,   -6 }, /* (474) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  436,   -1 }, /* (475) fill_mode ::= NONE */
  {  436,   -1 }, /* (476) fill_mode ::= PREV */
  {  436,   -1 }, /* (477) fill_mode ::= NULL */
  {  436,   -1 }, /* (478) fill_mode ::= LINEAR */
  {  436,   -1 }, /* (479) fill_mode ::= NEXT */
  {  431,    0 }, /* (480) group_by_clause_opt ::= */
  {  431,   -3 }, /* (481) group_by_clause_opt ::= GROUP BY group_by_list */
  {  437,   -1 }, /* (482) group_by_list ::= expr_or_subquery */
  {  437,   -3 }, /* (483) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  432,    0 }, /* (484) having_clause_opt ::= */
  {  432,   -2 }, /* (485) having_clause_opt ::= HAVING search_condition */
  {  427,    0 }, /* (486) range_opt ::= */
  {  427,   -6 }, /* (487) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  428,    0 }, /* (488) every_opt ::= */
  {  428,   -4 }, /* (489) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  438,   -4 }, /* (490) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  439,   -1 }, /* (491) query_simple ::= query_specification */
  {  439,   -1 }, /* (492) query_simple ::= union_query_expression */
  {  443,   -4 }, /* (493) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  443,   -3 }, /* (494) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  444,   -1 }, /* (495) query_simple_or_subquery ::= query_simple */
  {  444,   -1 }, /* (496) query_simple_or_subquery ::= subquery */
  {  377,   -1 }, /* (497) query_or_subquery ::= query_expression */
  {  377,   -1 }, /* (498) query_or_subquery ::= subquery */
  {  440,    0 }, /* (499) order_by_clause_opt ::= */
  {  440,   -3 }, /* (500) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  441,    0 }, /* (501) slimit_clause_opt ::= */
  {  441,   -2 }, /* (502) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  441,   -4 }, /* (503) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  441,   -4 }, /* (504) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  442,    0 }, /* (505) limit_clause_opt ::= */
  {  442,   -2 }, /* (506) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  442,   -4 }, /* (507) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  442,   -4 }, /* (508) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  394,   -3 }, /* (509) subquery ::= NK_LP query_expression NK_RP */
  {  394,   -3 }, /* (510) subquery ::= NK_LP subquery NK_RP */
  {  422,   -1 }, /* (511) search_condition ::= common_expression */
  {  445,   -1 }, /* (512) sort_specification_list ::= sort_specification */
  {  445,   -3 }, /* (513) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  446,   -3 }, /* (514) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  447,    0 }, /* (515) ordering_specification_opt ::= */
  {  447,   -1 }, /* (516) ordering_specification_opt ::= ASC */
  {  447,   -1 }, /* (517) ordering_specification_opt ::= DESC */
  {  448,    0 }, /* (518) null_ordering_opt ::= */
  {  448,   -2 }, /* (519) null_ordering_opt ::= NULLS FIRST */
  {  448,   -2 }, /* (520) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,318,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,319,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,318,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,320,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,321,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,319,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,321,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,320,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy181, &yymsp[-1].minor.yy0, yymsp[0].minor.yy293); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy181, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy181, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy181, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy293 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy293 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy831, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy831, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy831 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy831 = yymsp[0].minor.yy831; }
  yymsp[0].minor.yy831 = yylhsminor.yy831;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy831 = yymsp[-2].minor.yy831 | yymsp[0].minor.yy831; }
  yymsp[-2].minor.yy831 = yylhsminor.yy831;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy831 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy831 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy181 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy181 = yylhsminor.yy181;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy181 = yymsp[-2].minor.yy181; }
  yymsp[-2].minor.yy181 = yylhsminor.yy181;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy181, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 324: /* db_name ::= NK_ID */ yytestcase(yyruleno==324);
      case 325: /* table_name ::= NK_ID */ yytestcase(yyruleno==325);
      case 326: /* column_name ::= NK_ID */ yytestcase(yyruleno==326);
      case 327: /* function_name ::= NK_ID */ yytestcase(yyruleno==327);
      case 328: /* table_alias ::= NK_ID */ yytestcase(yyruleno==328);
      case 329: /* column_alias ::= NK_ID */ yytestcase(yyruleno==329);
      case 330: /* user_name ::= NK_ID */ yytestcase(yyruleno==330);
      case 331: /* topic_name ::= NK_ID */ yytestcase(yyruleno==331);
      case 332: /* stream_name ::= NK_ID */ yytestcase(yyruleno==332);
      case 333: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==333);
      case 373: /* noarg_func ::= NOW */ yytestcase(yyruleno==373);
      case 374: /* noarg_func ::= TODAY */ yytestcase(yyruleno==374);
      case 375: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==375);
      case 376: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==376);
      case 377: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==377);
      case 378: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==378);
      case 379: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==379);
      case 380: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==380);
      case 381: /* noarg_func ::= USER */ yytestcase(yyruleno==381);
      case 382: /* star_func ::= COUNT */ yytestcase(yyruleno==382);
      case 383: /* star_func ::= FIRST */ yytestcase(yyruleno==383);
      case 384: /* star_func ::= LAST */ yytestcase(yyruleno==384);
      case 385: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==385);
{ yylhsminor.yy181 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy181 = yylhsminor.yy181;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy39, &yymsp[-1].minor.yy181, yymsp[0].minor.yy778); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy39, &yymsp[0].minor.yy181); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy181, yymsp[0].minor.yy778); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 67: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy181, yymsp[0].minor.yy276); }
        break;
      case 68: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy39 = true; }
        break;
      case 69: /* not_exists_opt ::= */
      case 71: /* exists_opt ::= */ yytestcase(yyruleno==71);
      case 265: /* analyze_opt ::= */ yytestcase(yyruleno==265);
      case 272: /* agg_func_opt ::= */ yytestcase(yyruleno==272);
      case 446: /* set_quantifier_opt ::= */ yytestcase(yyruleno==446);
{ yymsp[1].minor.yy39 = false; }
        break;
      case 70: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy39 = true; }
        break;
      case 72: /* db_options ::= */
{ yymsp[1].minor.yy778 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 73: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 74: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 75: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 76: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 77: /* db_options ::= db_options DURATION NK_INTEGER */
      case 78: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==78);
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 79: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 80: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 81: /* db_options ::= db_options KEEP integer_list */
      case 82: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==82);
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_KEEP, yymsp[0].minor.yy282); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 83: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 84: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 85: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 86: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 87: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 88: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 89: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 90: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 91: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_RETENTIONS, yymsp[0].minor.yy282); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 92: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 93: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 94: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 95: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 96: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-3].minor.yy778, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 97: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-3].minor.yy778, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 99: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 100: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 101: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 102: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 103: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy778 = setDatabaseOption(pCxt, yymsp[-2].minor.yy778, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 104: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy778 = createAlterDatabaseOptions(pCxt); yylhsminor.yy778 = setAlterDatabaseOption(pCxt, yylhsminor.yy778, &yymsp[0].minor.yy645); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 105: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy778 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy778, &yymsp[0].minor.yy645); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 106: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy645.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 107: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 108: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 109: /* alter_db_option ::= KEEP integer_list */
      case 110: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==110);
{ yymsp[-1].minor.yy645.type = DB_OPTION_KEEP; yymsp[-1].minor.yy645.pList = yymsp[0].minor.yy282; }
        break;
      case 111: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_WAL; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy645.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy282 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 114: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 294: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==294);
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 115: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy282 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 116: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 117: /* retention_list ::= retention */
      case 139: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==139);
      case 142: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==142);
      case 149: /* column_def_list ::= column_def */ yytestcase(yyruleno==149);
      case 192: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==192);
      case 197: /* col_name_list ::= col_name */ yytestcase(yyruleno==197);
      case 248: /* func_list ::= func */ yytestcase(yyruleno==248);
      case 322: /* literal_list ::= signed_literal */ yytestcase(yyruleno==322);
      case 388: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==388);
      case 394: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==394);
      case 449: /* select_list ::= select_item */ yytestcase(yyruleno==449);
      case 460: /* partition_list ::= partition_item */ yytestcase(yyruleno==460);
      case 512: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==512);
{ yylhsminor.yy282 = createNodeList(pCxt, yymsp[0].minor.yy778); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 118: /* retention_list ::= retention_list NK_COMMA retention */
      case 150: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==150);
      case 193: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==193);
      case 198: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==198);
      case 249: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==249);
      case 323: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==323);
      case 389: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==389);
      case 450: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==450);
      case 461: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==461);
      case 513: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==513);
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, yymsp[0].minor.yy778); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 119: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy778 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 120: /* speed_opt ::= */
      case 274: /* bufsize_opt ::= */ yytestcase(yyruleno==274);
{ yymsp[1].minor.yy276 = 0; }
        break;
      case 121: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 275: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==275);
{ yymsp[-1].minor.yy276 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 122: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 124: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==124);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy39, yymsp[-5].minor.yy778, yymsp[-3].minor.yy282, yymsp[-1].minor.yy282, yymsp[0].minor.yy778); }
        break;
      case 123: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy282); }
        break;
      case 125: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy282); }
        break;
      case 126: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy39, yymsp[0].minor.yy778); }
        break;
      case 127: /* cmd ::= ALTER TABLE alter_table_clause */
      case 296: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==296);
{ pCxt->pRootNode = yymsp[0].minor.yy778; }
        break;
      case 128: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy778); }
        break;
      case 129: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy778 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 130: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy778 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 131: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy778 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy778, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy181); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 132: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy778 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 133: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy778 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy181, &yymsp[0].minor.yy181); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 134: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy778 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 135: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy778 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy778, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy181); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 136: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy778 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 137: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy778 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy778, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy181, &yymsp[0].minor.yy181); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 138: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy778 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy778, &yymsp[-2].minor.yy181, yymsp[0].minor.yy778); }
  yymsp[-5].minor.yy778 = yylhsminor.yy778;
        break;
      case 140: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 143: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==143);
      case 395: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==395);
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-1].minor.yy282, yymsp[0].minor.yy778); }
  yymsp[-1].minor.yy282 = yylhsminor.yy282;
        break;
      case 141: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy778 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy39, yymsp[-8].minor.yy778, yymsp[-6].minor.yy778, yymsp[-5].minor.yy282, yymsp[-2].minor.yy282, yymsp[0].minor.yy778); }
  yymsp[-9].minor.yy778 = yylhsminor.yy778;
        break;
      case 144: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy778 = createDropTableClause(pCxt, yymsp[-1].minor.yy39, yymsp[0].minor.yy778); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 145: /* specific_cols_opt ::= */
      case 176: /* tags_def_opt ::= */ yytestcase(yyruleno==176);
      case 458: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==458);
      case 480: /* group_by_clause_opt ::= */ yytestcase(yyruleno==480);
      case 499: /* order_by_clause_opt ::= */ yytestcase(yyruleno==499);
{ yymsp[1].minor.yy282 = NULL; }
        break;
      case 146: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy282 = yymsp[-1].minor.yy282; }
        break;
      case 147: /* full_table_name ::= table_name */
{ yylhsminor.yy778 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy181, NULL); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 148: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy778 = createRealTableNode(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181, NULL); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 151: /* column_def ::= column_name type_name */
{ yylhsminor.yy778 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy181, yymsp[0].minor.yy380, NULL); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 152: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy778 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy181, yymsp[-2].minor.yy380, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 153: /* type_name ::= BOOL */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 154: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 155: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 156: /* type_name ::= INT */
      case 157: /* type_name ::= INTEGER */ yytestcase(yyruleno==157);
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 158: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 159: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 160: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 161: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 162: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 163: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 164: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 165: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 166: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 167: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy380 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 168: /* type_name ::= JSON */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 169: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 171: /* type_name ::= BLOB */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 172: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 173: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy380 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 174: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy380 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 175: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy380 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 177: /* tags_def_opt ::= tags_def */
      case 387: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==387);
{ yylhsminor.yy282 = yymsp[0].minor.yy282; }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 178: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy282 = yymsp[-1].minor.yy282; }
        break;
      case 179: /* table_options ::= */
{ yymsp[1].minor.yy778 = createDefaultTableOptions(pCxt); }
        break;
      case 180: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-2].minor.yy778, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 181: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-2].minor.yy778, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy282); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 182: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-2].minor.yy778, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy282); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 183: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-4].minor.yy778, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy282); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 184: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-2].minor.yy778, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 185: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-4].minor.yy778, TABLE_OPTION_SMA, yymsp[-1].minor.yy282); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 186: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy778 = createAlterTableOptions(pCxt); yylhsminor.yy778 = setTableOption(pCxt, yylhsminor.yy778, yymsp[0].minor.yy645.type, &yymsp[0].minor.yy645.val); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 187: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy778 = setTableOption(pCxt, yymsp[-1].minor.yy778, yymsp[0].minor.yy645.type, &yymsp[0].minor.yy645.val); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 188: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy645.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 189: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy645.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy645.val = yymsp[0].minor.yy0; }
        break;
      case 190: /* duration_list ::= duration_literal */
      case 352: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==352);
{ yylhsminor.yy282 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy778)); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 191: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 353: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==353);
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, releaseRawExprNode(pCxt, yymsp[0].minor.yy778)); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 194: /* rollup_func_name ::= function_name */
{ yylhsminor.yy778 = createFunctionNode(pCxt, &yymsp[0].minor.yy181, NULL); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 195: /* rollup_func_name ::= FIRST */
      case 196: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==196);
{ yylhsminor.yy778 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 199: /* col_name ::= column_name */
{ yylhsminor.yy778 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy181); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 200: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 201: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 202: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 203: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy778, yymsp[0].minor.yy778, OP_TYPE_LIKE); }
        break;
      case 204: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy778, yymsp[0].minor.yy778, OP_TYPE_LIKE); }
        break;
      case 205: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy778, NULL, OP_TYPE_LIKE); }
        break;
      case 206: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 207: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 208: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 209: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 210: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy778, yymsp[-1].minor.yy778, OP_TYPE_EQUAL); }
        break;
      case 211: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 212: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 213: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 214: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 215: /* cmd ::= SHOW LICENCES */
      case 216: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==216);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 217: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy181); }
        break;
      case 218: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy778); }
        break;
      case 219: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy778); }
        break;
      case 220: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 221: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 222: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 223: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 224: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 225: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 226: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 227: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 228: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 229: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 230: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy778); }
        break;
      case 231: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 232: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 233: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy778, yymsp[-1].minor.yy778, OP_TYPE_EQUAL); }
        break;
      case 234: /* cmd ::= SHOW TABLE TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLE_TAGS_STMT, yymsp[0].minor.yy778, yymsp[-1].minor.yy778, OP_TYPE_EQUAL); }
        break;
      case 235: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 236: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 237: /* db_name_cond_opt ::= */
      case 242: /* from_db_opt ::= */ yytestcase(yyruleno==242);
{ yymsp[1].minor.yy778 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 238: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy181); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 239: /* like_pattern_opt ::= */
      case 284: /* subtable_opt ::= */ yytestcase(yyruleno==284);
      case 397: /* case_when_else_opt ::= */ yytestcase(yyruleno==397);
      case 427: /* from_clause_opt ::= */ yytestcase(yyruleno==427);
      case 456: /* where_clause_opt ::= */ yytestcase(yyruleno==456);
      case 465: /* twindow_clause_opt ::= */ yytestcase(yyruleno==465);
      case 470: /* sliding_opt ::= */ yytestcase(yyruleno==470);
      case 472: /* fill_opt ::= */ yytestcase(yyruleno==472);
      case 484: /* having_clause_opt ::= */ yytestcase(yyruleno==484);
      case 486: /* range_opt ::= */ yytestcase(yyruleno==486);
      case 488: /* every_opt ::= */ yytestcase(yyruleno==488);
      case 501: /* slimit_clause_opt ::= */ yytestcase(yyruleno==501);
      case 505: /* limit_clause_opt ::= */ yytestcase(yyruleno==505);
{ yymsp[1].minor.yy778 = NULL; }
        break;
      case 240: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 241: /* table_name_cond ::= table_name */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy181); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 243: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy181); }
        break;
      case 244: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy39, yymsp[-3].minor.yy778, yymsp[-1].minor.yy778, NULL, yymsp[0].minor.yy778); }
        break;
      case 245: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy39, yymsp[0].minor.yy778); }
        break;
      case 246: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy778 = createIndexOption(pCxt, yymsp[-7].minor.yy282, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), NULL, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 247: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy778 = createIndexOption(pCxt, yymsp[-9].minor.yy282, releaseRawExprNode(pCxt, yymsp[-5].minor.yy778), releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 250: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy778 = createFunctionNode(pCxt, &yymsp[-3].minor.yy181, yymsp[-1].minor.yy282); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 251: /* sma_stream_opt ::= */
      case 278: /* stream_options ::= */ yytestcase(yyruleno==278);
{ yymsp[1].minor.yy778 = createStreamOptions(pCxt); }
        break;
      case 252: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 282: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==282);
{ ((SStreamOptions*)yymsp[-2].minor.yy778)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); yylhsminor.yy778 = yymsp[-2].minor.yy778; }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 253: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy778)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); yylhsminor.yy778 = yymsp[-2].minor.yy778; }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 254: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy39, &yymsp[-2].minor.yy181, yymsp[0].minor.yy778); }
        break;
      case 255: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy39, &yymsp[-3].minor.yy181, &yymsp[0].minor.yy181, false); }
        break;
      case 256: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy39, &yymsp[-5].minor.yy181, &yymsp[0].minor.yy181, true); }
        break;
      case 257: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy39, &yymsp[-3].minor.yy181, yymsp[0].minor.yy778, false); }
        break;
      case 258: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy39, &yymsp[-5].minor.yy181, yymsp[0].minor.yy778, true); }
        break;
      case 259: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy39, &yymsp[0].minor.yy181); }
        break;
      case 260: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy39, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181); }
        break;
      case 261: /* cmd ::= DESC full_table_name */
      case 262: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==262);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy778); }
        break;
      case 263: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 264: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy39, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 266: /* analyze_opt ::= ANALYZE */
      case 273: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==273);
      case 447: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==447);
{ yymsp[0].minor.yy39 = true; }
        break;
      case 267: /* explain_options ::= */
{ yymsp[1].minor.yy778 = createDefaultExplainOptions(pCxt); }
        break;
      case 268: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy778 = setExplainVerbose(pCxt, yymsp[-2].minor.yy778, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 269: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy778 = setExplainRatio(pCxt, yymsp[-2].minor.yy778, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 270: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy39, yymsp[-8].minor.yy39, &yymsp[-5].minor.yy181, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy380, yymsp[0].minor.yy276); }
        break;
      case 271: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy39, &yymsp[0].minor.yy181); }
        break;
      case 276: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy39, &yymsp[-7].minor.yy181, yymsp[-4].minor.yy778, yymsp[-6].minor.yy778, yymsp[-3].minor.yy282, yymsp[-2].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 277: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy39, &yymsp[0].minor.yy181); }
        break;
      case 279: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy778)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy778 = yymsp[-2].minor.yy778; }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 280: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy778)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy778 = yymsp[-2].minor.yy778; }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 281: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy778)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy778)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); yylhsminor.yy778 = yymsp[-3].minor.yy778; }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 283: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy778)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy778 = yymsp[-3].minor.yy778; }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 285: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 471: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==471);
      case 489: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==489);
{ yymsp[-3].minor.yy778 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy778); }
        break;
      case 286: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 287: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 288: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 289: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 290: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 291: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy282); }
        break;
      case 292: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 293: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy282 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 295: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 297: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy778, yymsp[-2].minor.yy282, yymsp[0].minor.yy778); }
        break;
      case 298: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy778, NULL, yymsp[0].minor.yy778); }
        break;
      case 299: /* literal ::= NK_INTEGER */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 300: /* literal ::= NK_FLOAT */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 301: /* literal ::= NK_STRING */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 302: /* literal ::= NK_BOOL */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 303: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 304: /* literal ::= duration_literal */
      case 314: /* signed_literal ::= signed */ yytestcase(yyruleno==314);
      case 334: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==334);
      case 335: /* expr_or_subquery ::= subquery */ yytestcase(yyruleno==335);
      case 336: /* expression ::= literal */ yytestcase(yyruleno==336);
      case 337: /* expression ::= pseudo_column */ yytestcase(yyruleno==337);
      case 338: /* expression ::= column_reference */ yytestcase(yyruleno==338);
      case 339: /* expression ::= function_expression */ yytestcase(yyruleno==339);
      case 340: /* expression ::= case_when_expression */ yytestcase(yyruleno==340);
      case 370: /* function_expression ::= literal_func */ yytestcase(yyruleno==370);
      case 419: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==419);
      case 423: /* boolean_primary ::= predicate */ yytestcase(yyruleno==423);
      case 425: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==425);
      case 426: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==426);
      case 429: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==429);
      case 431: /* table_reference ::= table_primary */ yytestcase(yyruleno==431);
      case 432: /* table_reference ::= joined_table */ yytestcase(yyruleno==432);
      case 436: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==436);
      case 491: /* query_simple ::= query_specification */ yytestcase(yyruleno==491);
      case 492: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==492);
      case 495: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==495);
      case 497: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==497);
{ yylhsminor.yy778 = yymsp[0].minor.yy778; }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 305: /* literal ::= NULL */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 306: /* literal ::= NK_QUESTION */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 307: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 308: /* signed ::= NK_INTEGER */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 309: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 310: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 311: /* signed ::= NK_FLOAT */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 312: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 313: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 315: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 316: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 317: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 318: /* signed_literal ::= duration_literal */
      case 320: /* signed_literal ::= literal_func */ yytestcase(yyruleno==320);
      case 390: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==390);
      case 452: /* select_item ::= common_expression */ yytestcase(yyruleno==452);
      case 462: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==462);
      case 496: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==496);
      case 498: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==498);
      case 511: /* search_condition ::= common_expression */ yytestcase(yyruleno==511);
{ yylhsminor.yy778 = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 319: /* signed_literal ::= NULL */
{ yylhsminor.yy778 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 321: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy778 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 341: /* expression ::= NK_LP expression NK_RP */
      case 424: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==424);
      case 510: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==510);
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy778)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 342: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy778));
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 343: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy778), NULL));
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 344: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 345: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 346: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 347: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 348: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 349: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 350: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 351: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 354: /* column_reference ::= column_name */
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy181, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy181)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 355: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181, createColumnNode(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy181)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 356: /* pseudo_column ::= ROWTS */
      case 357: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==357);
      case 359: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==359);
      case 360: /* pseudo_column ::= QEND */ yytestcase(yyruleno==360);
      case 361: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==361);
      case 362: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==362);
      case 363: /* pseudo_column ::= WEND */ yytestcase(yyruleno==363);
      case 364: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==364);
      case 365: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==365);
      case 366: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==366);
      case 372: /* literal_func ::= NOW */ yytestcase(yyruleno==372);
{ yylhsminor.yy778 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 358: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy181)))); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 367: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 368: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==368);
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy181, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy181, yymsp[-1].minor.yy282)); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 369: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), yymsp[-1].minor.yy380)); }
  yymsp[-5].minor.yy778 = yylhsminor.yy778;
        break;
      case 371: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy181, NULL)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 386: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy282 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 391: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 455: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==455);
{ yylhsminor.yy778 = createColumnNode(pCxt, &yymsp[-2].minor.yy181, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 392: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy282, yymsp[-1].minor.yy778)); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 393: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), yymsp[-2].minor.yy282, yymsp[-1].minor.yy778)); }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 396: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy778 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)); }
        break;
      case 398: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy778 = releaseRawExprNode(pCxt, yymsp[0].minor.yy778); }
        break;
      case 399: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 404: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==404);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy682, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 400: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy778), releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-4].minor.yy778 = yylhsminor.yy778;
        break;
      case 401: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy778), releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-5].minor.yy778 = yylhsminor.yy778;
        break;
      case 402: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), NULL));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 403: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), NULL));
                                                                                  }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 405: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy682 = OP_TYPE_LOWER_THAN; }
        break;
      case 406: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy682 = OP_TYPE_GREATER_THAN; }
        break;
      case 407: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy682 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 408: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy682 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 409: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy682 = OP_TYPE_NOT_EQUAL; }
        break;
      case 410: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy682 = OP_TYPE_EQUAL; }
        break;
      case 411: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy682 = OP_TYPE_LIKE; }
        break;
      case 412: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy682 = OP_TYPE_NOT_LIKE; }
        break;
      case 413: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy682 = OP_TYPE_MATCH; }
        break;
      case 414: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy682 = OP_TYPE_NMATCH; }
        break;
      case 415: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy682 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 416: /* in_op ::= IN */
{ yymsp[0].minor.yy682 = OP_TYPE_IN; }
        break;
      case 417: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy682 = OP_TYPE_NOT_IN; }
        break;
      case 418: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy282)); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 420: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy778), NULL));
                                                                                  }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 421: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 422: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy778);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy778);
                                                                                    yylhsminor.yy778 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), releaseRawExprNode(pCxt, yymsp[0].minor.yy778)));
                                                                                  }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 428: /* from_clause_opt ::= FROM table_reference_list */
      case 457: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==457);
      case 485: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==485);
{ yymsp[-1].minor.yy778 = yymsp[0].minor.yy778; }
        break;
      case 430: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy778 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy778, yymsp[0].minor.yy778, NULL); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 433: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy778 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy181, &yymsp[0].minor.yy181); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 434: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy778 = createRealTableNode(pCxt, &yymsp[-3].minor.yy181, &yymsp[-1].minor.yy181, &yymsp[0].minor.yy181); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 435: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy778 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy778), &yymsp[0].minor.yy181); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 437: /* alias_opt ::= */
{ yymsp[1].minor.yy181 = nil_token;  }
        break;
      case 438: /* alias_opt ::= table_alias */
{ yylhsminor.yy181 = yymsp[0].minor.yy181; }
  yymsp[0].minor.yy181 = yylhsminor.yy181;
        break;
      case 439: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy181 = yymsp[0].minor.yy181; }
        break;
      case 440: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 441: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==441);
{ yymsp[-2].minor.yy778 = yymsp[-1].minor.yy778; }
        break;
      case 442: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy778 = createJoinTableNode(pCxt, yymsp[-4].minor.yy202, yymsp[-5].minor.yy778, yymsp[-2].minor.yy778, yymsp[0].minor.yy778); }
  yymsp[-5].minor.yy778 = yylhsminor.yy778;
        break;
      case 443: /* join_type ::= */
{ yymsp[1].minor.yy202 = JOIN_TYPE_INNER; }
        break;
      case 444: /* join_type ::= INNER */
{ yymsp[0].minor.yy202 = JOIN_TYPE_INNER; }
        break;
      case 445: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy778 = createSelectStmt(pCxt, yymsp[-10].minor.yy39, yymsp[-9].minor.yy282, yymsp[-8].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addWhereClause(pCxt, yymsp[-11].minor.yy778, yymsp[-7].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addPartitionByClause(pCxt, yymsp[-11].minor.yy778, yymsp[-6].minor.yy282);
                                                                                    yymsp[-11].minor.yy778 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy778, yymsp[-2].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addGroupByClause(pCxt, yymsp[-11].minor.yy778, yymsp[-1].minor.yy282);
                                                                                    yymsp[-11].minor.yy778 = addHavingClause(pCxt, yymsp[-11].minor.yy778, yymsp[0].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addRangeClause(pCxt, yymsp[-11].minor.yy778, yymsp[-5].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addEveryClause(pCxt, yymsp[-11].minor.yy778, yymsp[-4].minor.yy778);
                                                                                    yymsp[-11].minor.yy778 = addFillClause(pCxt, yymsp[-11].minor.yy778, yymsp[-3].minor.yy778);
                                                                                  }
        break;
      case 448: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy39 = false; }
        break;
      case 451: /* select_item ::= NK_STAR */
{ yylhsminor.yy778 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy778 = yylhsminor.yy778;
        break;
      case 453: /* select_item ::= common_expression column_alias */
      case 463: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==463);
{ yylhsminor.yy778 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy778), &yymsp[0].minor.yy181); }
  yymsp[-1].minor.yy778 = yylhsminor.yy778;
        break;
      case 454: /* select_item ::= common_expression AS column_alias */
      case 464: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==464);
{ yylhsminor.yy778 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), &yymsp[0].minor.yy181); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 459: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 481: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==481);
      case 500: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==500);
{ yymsp[-2].minor.yy282 = yymsp[0].minor.yy282; }
        break;
      case 466: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy778 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), releaseRawExprNode(pCxt, yymsp[-1].minor.yy778)); }
        break;
      case 467: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy778 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy778)); }
        break;
      case 468: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy778 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), NULL, yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 469: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy778 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy778), releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), yymsp[-1].minor.yy778, yymsp[0].minor.yy778); }
        break;
      case 473: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy778 = createFillNode(pCxt, yymsp[-1].minor.yy381, NULL); }
        break;
      case 474: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy778 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy282)); }
        break;
      case 475: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy381 = FILL_MODE_NONE; }
        break;
      case 476: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy381 = FILL_MODE_PREV; }
        break;
      case 477: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy381 = FILL_MODE_NULL; }
        break;
      case 478: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy381 = FILL_MODE_LINEAR; }
        break;
      case 479: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy381 = FILL_MODE_NEXT; }
        break;
      case 482: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy282 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); }
  yymsp[0].minor.yy282 = yylhsminor.yy282;
        break;
      case 483: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy282 = addNodeToList(pCxt, yymsp[-2].minor.yy282, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy778))); }
  yymsp[-2].minor.yy282 = yylhsminor.yy282;
        break;
      case 487: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy778 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy778), releaseRawExprNode(pCxt, yymsp[-1].minor.yy778)); }
        break;
      case 490: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy778 = addOrderByClause(pCxt, yymsp[-3].minor.yy778, yymsp[-2].minor.yy282);
                                                                                    yylhsminor.yy778 = addSlimitClause(pCxt, yylhsminor.yy778, yymsp[-1].minor.yy778);
                                                                                    yylhsminor.yy778 = addLimitClause(pCxt, yylhsminor.yy778, yymsp[0].minor.yy778);
                                                                                  }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 493: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy778 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy778, yymsp[0].minor.yy778); }
  yymsp[-3].minor.yy778 = yylhsminor.yy778;
        break;
      case 494: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy778 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy778, yymsp[0].minor.yy778); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 502: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 506: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==506);
{ yymsp[-1].minor.yy778 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 503: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 507: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==507);
{ yymsp[-3].minor.yy778 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 504: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 508: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==508);
{ yymsp[-3].minor.yy778 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 509: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy778 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy778); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 514: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy778 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy778), yymsp[-1].minor.yy14, yymsp[0].minor.yy305); }
  yymsp[-2].minor.yy778 = yylhsminor.yy778;
        break;
      case 515: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy14 = ORDER_ASC; }
        break;
      case 516: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy14 = ORDER_ASC; }
        break;
      case 517: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy14 = ORDER_DESC; }
        break;
      case 518: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy305 = NULL_ORDER_DEFAULT; }
        break;
      case 519: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy305 = NULL_ORDER_FIRST; }
        break;
      case 520: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy305 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
