/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 268
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy106;
  EFillMode yy142;
  SNode* yy176;
  SToken yy225;
  EJoinType yy236;
  SAlterOption yy325;
  EOperatorType yy404;
  SDataType yy448;
  ENullOrder yy465;
  bool yy505;
  int32_t yy508;
  SNodeList* yy512;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYNSTATE             432
#define YYNRULE              348
#define YYNTOKEN             172
#define YY_MAX_SHIFT         431
#define YY_MIN_SHIFTREDUCE   675
#define YY_MAX_SHIFTREDUCE   1022
#define YY_ERROR_ACTION      1023
#define YY_ACCEPT_ACTION     1024
#define YY_NO_ACTION         1025
#define YY_MIN_REDUCE        1026
#define YY_MAX_REDUCE        1373
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1282)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1230,   43,  306, 1243, 1118,  350, 1226, 1233,  238, 1114,
 /*    10 */    89, 1205,   31,   29,   27,   26,   25, 1259, 1124,   24,
 /*    20 */   170, 1352,  226, 1259,  347,   31,   29,   27,   26,   25,
 /*    30 */   347,  363,  363,  251, 1351,  362,   66,  270, 1350, 1230,
 /*    40 */   349, 1243,  307,  280, 1217, 1226, 1232,  212, 1069,  335,
 /*    50 */   321,  362, 1129, 1129,   61, 1244, 1245, 1248, 1291,  210,
 /*    60 */   212, 1259,  211, 1287,  246,  363, 1065, 1352,  347,  898,
 /*    70 */  1126, 1196, 1198,  239, 1352,  106, 1096,  928,  349,  350,
 /*    80 */   117,  104, 1217,   12, 1350, 1206, 1129,  117,  293, 1131,
 /*    90 */   928, 1350,  107, 1244, 1245, 1248, 1027,  416,  415,  414,
 /*   100 */   413,  412,  411,  410,  409,  408,  407,  406,  405,  404,
 /*   110 */   403,  402,  401,  400,  399,  189,  929,   77, 1159, 1120,
 /*   120 */    76,   75,   74,   73,   72,   71,   70,   69,   68,  929,
 /*   130 */   336, 1365,  424,  423,   23,  233,  923,  924,  925,  926,
 /*   140 */   927,  931,  932,  933,   27,   26,   25,   23,  233,  923,
 /*   150 */   924,  925,  926,  927,  931,  932,  933,    9,    8, 1243,
 /*   160 */  1217,  784,  386,  385,  384,  788,  383,  790,  791,  382,
 /*   170 */   793,  379,  883,  799,  376,  801,  802,  373,  370, 1259,
 /*   180 */    30,   28,  105, 1176, 1038,  243,  334, 1049,  235,  225,
 /*   190 */   863,   30,   28,  965, 1174,  271,  349,  362, 1259,  235,
 /*   200 */  1217,  863, 1230, 1243,  885,  347,  861, 1107, 1226, 1232,
 /*   210 */    62, 1244, 1245, 1248, 1291,   11,  363,  861,  228, 1287,
 /*   220 */   112,  360,  712, 1259,  711,  941,   11,  339, 1217, 1105,
 /*   230 */   347,  324,  166,   30,   28, 1024,    1, 1129,  313, 1318,
 /*   240 */   349,  235,  713,  863, 1217,   12,  320,    1,   31,   29,
 /*   250 */    27,   26,   25,  271,   62, 1244, 1245, 1248, 1291,  861,
 /*   260 */   428,  338,  228, 1287, 1364, 1310,  960, 1048,   11,  363,
 /*   270 */   930,  428,  862, 1325,   66,  398, 1176,  326,  322, 1243,
 /*   280 */  1047,  286,  240,  862,  250,  242,  241, 1174,   21,    1,
 /*   290 */  1129,  864,  867,  868,  201,  876,  911,  934,  118, 1259,
 /*   300 */   325,  109,  864,  867,  868,  201,  334,  911, 1217, 1352,
 /*   310 */   340,  869, 1169,  428,  118, 1243,  349, 1046, 1176, 1045,
 /*   320 */  1217, 1217,  117,  118,  247,  862, 1350,  259, 1060, 1174,
 /*   330 */    62, 1244, 1245, 1248, 1291, 1259,  363, 1305,  228, 1287,
 /*   340 */   112,  361,  347,  363,  864,  867,  868,  201,  184,  911,
 /*   350 */   295, 1243,  349,   30,   28, 1302, 1217, 1129, 1217, 1319,
 /*   360 */  1217,  235, 1305,  863, 1129,  364,   62, 1244, 1245, 1248,
 /*   370 */  1291, 1259,  122,  121,  228, 1287, 1364,  872,  347,  861,
 /*   380 */  1301,   30,   28,  348,  972, 1348, 1044,  389,  349,  235,
 /*   390 */   885,  863, 1217,  118,  363,  331,  877,  880,  868,  249,
 /*   400 */  1043, 1042,   62, 1244, 1245, 1248, 1291,  861, 1041,    7,
 /*   410 */   228, 1287, 1364,  964,  245, 1129,   92,  886,   30,   28,
 /*   420 */   337, 1309,  104,  398,   30,   28,  235, 1217,  863,   59,
 /*   430 */  1131, 1243,  235,  428,  863, 1040, 1176,    7, 1037,   93,
 /*   440 */   248, 1217, 1217,   90,  861,  862, 1121, 1197,  104, 1217,
 /*   450 */   861, 1259,  333,  113, 1298, 1299, 1131, 1303,  347, 1036,
 /*   460 */  1035,  428,  884, 1193,  864,  867,  868,  201,  349,  911,
 /*   470 */   120, 1034, 1217,  862,    7,  887, 1217,  335, 1176, 1217,
 /*   480 */     1, 1033,  202, 1244, 1245, 1248,  284,  118,  297, 1175,
 /*   490 */   283, 1116,  864,  867,  868,  201,   43,  911,  428, 1112,
 /*   500 */  1217, 1217, 1352,  305,  428, 1032, 1243, 1106, 1031, 1030,
 /*   510 */   862,  285, 1217, 1125, 1029,  117,  862,  145,  888, 1350,
 /*   520 */   300, 1305, 1217,    9,    8,  294, 1259,   52,  144,  864,
 /*   530 */   867,  868,  201,  347,  911,  864,  867,  868,  201, 1300,
 /*   540 */   911,  989, 1243,  349, 1122,  104, 1217, 1217,    6, 1217,
 /*   550 */  1217,   40,  342, 1132,   39, 1217,  963,   63, 1244, 1245,
 /*   560 */  1248, 1291, 1259,  331,  395, 1290, 1287,  304,  394,  347,
 /*   570 */   863,  388,  317,  987,  988,  990,  991,  165, 1243,  349,
 /*   580 */   302,  871,  137, 1217,   92,  135,  861,  194,  139,  396,
 /*   590 */  1039,  138,  196,   63, 1244, 1245, 1248, 1291, 1259,  318,
 /*   600 */   711,  345, 1287,  335,  195,  347,  309, 1243,  393,  392,
 /*   610 */   391,   90,  390, 1058,  123,  349,  278,  346,   98, 1217,
 /*   620 */   151,  163, 1298,  330, 1104,  329, 1243, 1259, 1352,   63,
 /*   630 */  1244, 1245, 1248, 1291,  347,  298,  141,  343, 1288,  140,
 /*   640 */   428,  117,  986,  156,  349, 1350, 1259,  874, 1217, 1243,
 /*   650 */   960,  234,  862,  347,   41,  154, 1021, 1022,  206, 1244,
 /*   660 */  1245, 1248,  143,  349,   58,  142, 1097, 1217, 1243, 1259,
 /*   670 */   314,  864,  867,  868,   54,   64,  347,  206, 1244, 1245,
 /*   680 */  1248,  395,  870, 1170,  935,  394,  349,  895, 1259,  167,
 /*   690 */  1217,  160,  277, 1321,  920,  347,   32,  883, 1237,   32,
 /*   700 */   205, 1244, 1245, 1248,  252,  349,  396,  264, 1243, 1217,
 /*   710 */  1235,  856,  175, 1243,  332,  118,  265,  169,  355,  107,
 /*   720 */  1244, 1245, 1248,   32,  173,  393,  392,  391, 1259,  390,
 /*   730 */    95, 1260,  327, 1259,    2,  347,  883, 1195,  119,  253,
 /*   740 */   347,  181,  261,  260,  266,  349,  891,  262,  873, 1217,
 /*   750 */   349,  777,  232,   96, 1217, 1072,  268,  236, 1366,  206,
 /*   760 */  1244, 1245, 1248,   98,  206, 1244, 1245, 1248, 1026,  267,
 /*   770 */   124,   77,  890,  772,   76,   75,   74,   73,   72,   71,
 /*   780 */    70,   69,   68,  127,  263,   41,   42,  258,  257,  256,
 /*   790 */   255,  254,   86,   85,   84,   83,   82,   81,   80,   79,
 /*   800 */    78,  431, 1243,  272,  292,  269,  287, 1243,  130,  291,
 /*   810 */   889,  805,  290,  279,  288,  187,  281,  289,   88,   87,
 /*   820 */   809,  308, 1259,  368,  420,  224,  186, 1259,  292,  347,
 /*   830 */   287,  310,   96,  291,  347,  815,  290, 1243,  288,  349,
 /*   840 */  1119,  289,  134, 1217,  349, 1243, 1115,   97, 1217,   60,
 /*   850 */   814,  136,  182,  204, 1244, 1245, 1248, 1259,  207, 1244,
 /*   860 */  1245, 1248,   98,   99,  347, 1259,   31,   29,   27,   26,
 /*   870 */    25,  100,  347,  101,  349,   96, 1117,  146, 1217, 1113,
 /*   880 */   102, 1243,  349,  359,  103,  149, 1217,  311,  199, 1244,
 /*   890 */  1245, 1248,  888, 1322,  319, 1332,  208, 1244, 1245, 1248,
 /*   900 */   312, 1259,  353,  147, 1243,  152,  316,  227,  347, 1243,
 /*   910 */    31,   29,   27,   26,   25, 1331,  868,  155,  349,  323,
 /*   920 */     5,  328, 1217,  898, 1259,  315, 1312,  159,    4, 1259,
 /*   930 */   110,  347,  200, 1244, 1245, 1248,  347,  960,   91,  887,
 /*   940 */    33,  349,  161, 1306, 1243, 1217,  349,  162,  344,  341,
 /*   950 */  1217,   17, 1243,  229, 1367,  209, 1244, 1245, 1248,  331,
 /*   960 */  1256, 1244, 1245, 1248, 1259, 1273,  356,  357,  179, 1349,
 /*   970 */   168,  347, 1259, 1204, 1243, 1203,  351,  177,  352,  347,
 /*   980 */    92,  349,   51,  237,  358, 1217,  188, 1130,   53,  349,
 /*   990 */   190,  366,  185, 1217, 1259, 1255, 1244, 1245, 1248,  427,
 /*  1000 */   197,  347, 1243, 1254, 1244, 1245, 1248,   90,  198,  193,
 /*  1010 */  1243,  349,  192, 1211,  839, 1217, 1188,  114, 1298, 1299,
 /*  1020 */    94, 1303, 1259, 1187, 1186,  215, 1244, 1245, 1248,  347,
 /*  1030 */  1259, 1185, 1243, 1184, 1183, 1182, 1181,  347,  126,  349,
 /*  1040 */  1243,  841, 1180, 1217, 1179, 1178, 1177,  349, 1071, 1210,
 /*  1050 */  1201, 1217, 1259,  214, 1244, 1245, 1248, 1108,  724,  347,
 /*  1060 */  1259,  216, 1244, 1245, 1248, 1018, 1019,  347, 1070,  349,
 /*  1070 */  1068,  132,  275, 1217,  111,  219, 1057,  349,  331,  273,
 /*  1080 */   276, 1217,  131,  213, 1244, 1245, 1248,  274, 1056, 1053,
 /*  1090 */  1110,  203, 1244, 1245, 1248,   67,  133,  284,  822,   92,
 /*  1100 */   821,  283,  820, 1109,  752,   44, 1066,  751,  129,  750,
 /*  1110 */   749,  220,  748,  218,  217,  747,  282,   20,  221, 1061,
 /*  1120 */   222,  296,  285, 1059,  223,  299,   90,   31,   29,   27,
 /*  1130 */    26,   25,   22, 1052,  301, 1051,  115, 1298, 1299,  303,
 /*  1140 */  1303,   65,   31,   29,   27,   26,   25,  910, 1209,  912,
 /*  1150 */   913,  914,  915,  916, 1208,  128, 1200,  148,   14,  125,
 /*  1160 */    45,   36,    3,  153,  150,   32,   37,  158,  985,  108,
 /*  1170 */    34, 1235,  157,  164,  979,   46,   19,  978,   47,   48,
 /*  1180 */    15,   35,  957, 1007, 1006,  956,    8, 1012,  230,  116,
 /*  1190 */  1011, 1010,   16,   10,  896,  231,   13,  921,  172,   18,
 /*  1200 */   171,  983,  174,  354,  176,   49, 1199,  178,   50,  878,
 /*  1210 */    38,  367,  244,  806,  180,  369,   54,  371,  803, 1234,
 /*  1220 */   800,  183,  365,  372,  374,  783,  375,  377,  794,  378,
 /*  1230 */   380,  792,  817,  381,  813,  812,  811,   55,  722,   56,
 /*  1240 */    57,  744,  397,  743,  736,  742,  741,  740,  739,  738,
 /*  1250 */   387,  737, 1067,  735,  798,  734,  733,  797,  732,  731,
 /*  1260 */   796,  795,  730,  729,  728,  727,  417,  418, 1055, 1054,
 /*  1270 */   421,  422,  419, 1050,  816,  425,  426, 1025,  865,  191,
 /*  1280 */   429,  430,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   216,  183,  181,  175,  196,  212,  222,  223,  215,  196,
 /*    10 */   192,  218,   12,   13,   14,   15,   16,  195,  200,  231,
 /*    20 */   232,  246,  199,  195,  202,   12,   13,   14,   15,   16,
 /*    30 */   202,  181,  181,  181,  259,   20,  186,  186,  263,  216,
 /*    40 */   212,  175,  221,  193,  216,  222,  223,   47,    0,  221,
 /*    50 */   228,   20,  202,  202,  226,  227,  228,  229,  230,  207,
 /*    60 */    47,  195,  234,  235,  204,  181,    0,  246,  202,   69,
 /*    70 */   186,  211,  212,  187,  246,  184,  185,   77,  212,  212,
 /*    80 */   259,  195,  216,   68,  263,  218,  202,  259,   22,  203,
 /*    90 */    77,  263,  226,  227,  228,  229,    0,   49,   50,   51,
 /*   100 */    52,   53,   54,   55,   56,   57,   58,   59,   60,   61,
 /*   110 */    62,   63,   64,   65,   66,  188,  116,   21,  191,  175,
 /*   120 */    24,   25,   26,   27,   28,   29,   30,   31,   32,  116,
 /*   130 */   264,  265,  178,  179,  134,  135,  136,  137,  138,  139,
 /*   140 */   140,  141,  142,  143,   14,   15,   16,  134,  135,  136,
 /*   150 */   137,  138,  139,  140,  141,  142,  143,    1,    2,  175,
 /*   160 */   216,   83,   84,   85,   86,   87,   88,   89,   90,   91,
 /*   170 */    92,   93,   20,   95,   96,   97,   98,   99,  100,  195,
 /*   180 */    12,   13,  174,  195,  176,  199,  202,  175,   20,  201,
 /*   190 */    22,   12,   13,   14,  206,   46,  212,   20,  195,   20,
 /*   200 */   216,   22,  216,  175,   20,  202,   38,    0,  222,  223,
 /*   210 */   226,  227,  228,  229,  230,   47,  181,   38,  234,  235,
 /*   220 */   236,  186,   20,  195,   22,   69,   47,   81,  216,    0,
 /*   230 */   202,  228,  248,   12,   13,  172,   68,  202,  254,  255,
 /*   240 */   212,   20,   40,   22,  216,   68,  120,   68,   12,   13,
 /*   250 */    14,   15,   16,   46,  226,  227,  228,  229,  230,   38,
 /*   260 */    92,    3,  234,  235,  236,  144,  145,  175,   47,  181,
 /*   270 */   116,   92,  104,  245,  186,   46,  195,  151,  152,  175,
 /*   280 */   175,  193,  201,  104,  221,   12,   13,  206,  134,   68,
 /*   290 */   202,  123,  124,  125,  126,   22,  128,  143,  146,  195,
 /*   300 */    20,  194,  123,  124,  125,  126,  202,  128,  216,  246,
 /*   310 */   164,   38,  205,   92,  146,  175,  212,  175,  195,  175,
 /*   320 */   216,  216,  259,  146,  201,  104,  263,   63,    0,  206,
 /*   330 */   226,  227,  228,  229,  230,  195,  181,  224,  234,  235,
 /*   340 */   236,  186,  202,  181,  123,  124,  125,  126,  186,  128,
 /*   350 */    22,  175,  212,   12,   13,  242,  216,  202,  216,  255,
 /*   360 */   216,   20,  224,   22,  202,   92,  226,  227,  228,  229,
 /*   370 */   230,  195,  108,  109,  234,  235,  236,  104,  202,   38,
 /*   380 */   242,   12,   13,   14,   14,  245,  175,   79,  212,   20,
 /*   390 */    20,   22,  216,  146,  181,  181,  123,  124,  125,  186,
 /*   400 */   175,  175,  226,  227,  228,  229,  230,   38,  175,   68,
 /*   410 */   234,  235,  236,    4,  187,  202,  202,   20,   12,   13,
 /*   420 */   162,  245,  195,   46,   12,   13,   20,  216,   22,  180,
 /*   430 */   203,  175,   20,   92,   22,  175,  195,   68,  175,  190,
 /*   440 */   187,  216,  216,  229,   38,  104,  197,  206,  195,  216,
 /*   450 */    38,  195,  238,  239,  240,  241,  203,  243,  202,  175,
 /*   460 */   175,   92,   20,  202,  123,  124,  125,  126,  212,  128,
 /*   470 */   209,  175,  216,  104,   68,   20,  216,  221,  195,  216,
 /*   480 */    68,  175,  226,  227,  228,  229,   57,  146,    4,  206,
 /*   490 */    61,  196,  123,  124,  125,  126,  183,  128,   92,  196,
 /*   500 */   216,  216,  246,   19,   92,  175,  175,    0,  175,  175,
 /*   510 */   104,   82,  216,  200,  175,  259,  104,   33,   20,  263,
 /*   520 */    36,  224,  216,    1,    2,   41,  195,  180,   44,  123,
 /*   530 */   124,  125,  126,  202,  128,  123,  124,  125,  126,  242,
 /*   540 */   128,  124,  175,  212,  197,  195,  216,  216,   43,  216,
 /*   550 */   216,   67,   81,  203,   70,  216,  147,  226,  227,  228,
 /*   560 */   229,  230,  195,  181,   57,  234,  235,   21,   61,  202,
 /*   570 */    22,  196,  155,  156,  157,  158,  159,  122,  175,  212,
 /*   580 */    34,   38,   72,  216,  202,   75,   38,   18,   72,   82,
 /*   590 */   176,   75,   23,  226,  227,  228,  229,  230,  195,  257,
 /*   600 */    22,  234,  235,  221,   35,  202,   69,  175,  101,  102,
 /*   610 */   103,  229,  105,    0,   45,  212,   38,   47,   81,  216,
 /*   620 */   122,  239,  240,  241,    0,  243,  175,  195,  246,  226,
 /*   630 */   227,  228,  229,  230,  202,   22,   72,  166,  235,   75,
 /*   640 */    92,  259,   69,   69,  212,  263,  195,  104,  216,  175,
 /*   650 */   145,  219,  104,  202,   81,   81,  170,  171,  226,  227,
 /*   660 */   228,  229,   72,  212,   68,   75,  185,  216,  175,  195,
 /*   670 */   219,  123,  124,  125,   78,  106,  202,  226,  227,  228,
 /*   680 */   229,   57,   38,  205,   69,   61,  212,   69,  195,  266,
 /*   690 */   216,  251,  178,  225,  124,  202,   81,   20,   68,   81,
 /*   700 */   226,  227,  228,  229,   27,  212,   82,   30,  175,  216,
 /*   710 */    80,   69,   69,  175,  244,  146,   39,  260,   69,  226,
 /*   720 */   227,  228,  229,   81,   81,  101,  102,  103,  195,  105,
 /*   730 */    81,  195,  258,  195,  247,  202,   20,  181,  115,  210,
 /*   740 */   202,   69,  116,  208,  181,  212,   20,  208,  104,  216,
 /*   750 */   212,   69,  219,   81,  216,    0,  202,  219,  265,  226,
 /*   760 */   227,  228,  229,   81,  226,  227,  228,  229,    0,  220,
 /*   770 */   183,   21,   20,   69,   24,   25,   26,   27,   28,   29,
 /*   780 */    30,   31,   32,  183,  107,   81,  183,  110,  111,  112,
 /*   790 */   113,  114,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   800 */    32,   19,  175,  181,   49,  213,   51,  175,  183,   54,
 /*   810 */    20,   69,   57,  177,   59,   33,  195,   62,   36,  181,
 /*   820 */    69,  220,  195,   81,   42,  177,   44,  195,   49,  202,
 /*   830 */    51,  202,   81,   54,  202,   69,   57,  175,   59,  212,
 /*   840 */   195,   62,  195,  216,  212,  175,  195,   81,  216,   67,
 /*   850 */    69,  195,   70,  226,  227,  228,  229,  195,  226,  227,
 /*   860 */   228,  229,   81,   69,  202,  195,   12,   13,   14,   15,
 /*   870 */    16,  195,  202,  195,  212,   81,  195,  180,  216,  195,
 /*   880 */   195,  175,  212,  101,  195,  180,  216,  213,  226,  227,
 /*   890 */   228,  229,   20,  225,  154,  256,  226,  227,  228,  229,
 /*   900 */   118,  195,  153,  121,  175,  217,  216,  216,  202,  175,
 /*   910 */    12,   13,   14,   15,   16,  256,  125,  217,  212,  216,
 /*   920 */   161,  160,  216,   69,  195,  149,  253,  252,  148,  195,
 /*   930 */   250,  202,  226,  227,  228,  229,  202,  145,  202,   20,
 /*   940 */   115,  212,  249,  224,  175,  216,  212,  237,  165,  163,
 /*   950 */   216,   68,  175,  169,  267,  226,  227,  228,  229,  181,
 /*   960 */   226,  227,  228,  229,  195,  233,  119,  214,  180,  262,
 /*   970 */   261,  202,  195,  217,  175,  217,  216,  202,  216,  202,
 /*   980 */   202,  212,  180,  216,  213,  216,  191,  202,   68,  212,
 /*   990 */   181,  198,  180,  216,  195,  226,  227,  228,  229,  177,
 /*  1000 */   189,  202,  175,  226,  227,  228,  229,  229,  189,  173,
 /*  1010 */   175,  212,  182,    0,   80,  216,    0,  239,  240,  241,
 /*  1020 */   115,  243,  195,    0,    0,  226,  227,  228,  229,  202,
 /*  1030 */   195,    0,  175,    0,    0,    0,    0,  202,   43,  212,
 /*  1040 */   175,   22,    0,  216,    0,    0,    0,  212,    0,    0,
 /*  1050 */     0,  216,  195,  226,  227,  228,  229,    0,   48,  202,
 /*  1060 */   195,  226,  227,  228,  229,  167,  168,  202,    0,  212,
 /*  1070 */     0,   33,   43,  216,   36,   35,    0,  212,  181,   38,
 /*  1080 */    42,  216,   44,  226,  227,  228,  229,   36,    0,    0,
 /*  1090 */     0,  226,  227,  228,  229,   77,   75,   57,   38,  202,
 /*  1100 */    38,   61,   22,    0,   38,   67,    0,   38,   70,   38,
 /*  1110 */    38,   71,   38,   73,   74,   38,   76,    2,   22,    0,
 /*  1120 */    22,   39,   82,    0,   22,   38,  229,   12,   13,   14,
 /*  1130 */    15,   16,    2,    0,   22,    0,  239,  240,  241,   22,
 /*  1140 */   243,   20,   12,   13,   14,   15,   16,  127,    0,  129,
 /*  1150 */   130,  131,  132,  133,    0,  117,    0,   43,  150,  121,
 /*  1160 */    68,  122,   81,   69,  117,   81,   81,   81,   69,   68,
 /*  1170 */   144,   80,   68,   80,   69,   68,   81,   69,   68,    4,
 /*  1180 */   150,   81,   69,   38,   38,   69,    2,   69,   38,   80,
 /*  1190 */    38,   38,   81,  150,   69,   38,   68,  124,   69,   68,
 /*  1200 */    80,   69,   68,  120,   68,   68,    0,   43,   68,   22,
 /*  1210 */    68,   38,   38,   69,  117,   68,   78,   38,   69,   80,
 /*  1220 */    69,   80,   79,   68,   38,   22,   68,   38,   69,   68,
 /*  1230 */    38,   69,   38,   68,   38,   38,   22,   68,   48,   68,
 /*  1240 */    68,   22,   47,   38,   22,   38,   38,   38,   38,   38,
 /*  1250 */    82,   38,    0,   38,   94,   38,   38,   94,   38,   38,
 /*  1260 */    94,   94,   38,   38,   38,   38,   38,   36,    0,    0,
 /*  1270 */    38,   37,   43,    0,  104,   22,   21,  268,   22,   22,
 /*  1280 */    21,   20,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1290 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1300 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1310 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1320 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1330 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1340 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1350 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1360 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1370 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1380 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1390 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1400 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1410 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1420 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1430 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1440 */   268,  268,  268,  268,  268,  268,  268,  268,  268,  268,
 /*  1450 */   268,  268,  268,  268,
};
#define YY_SHIFT_COUNT    (431)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1273)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   569,  168,  179,  221,  221,  221,  221,  341,  221,  221,
 /*    10 */   406,  412,  177,  369,  406,  406,  406,  406,  406,  406,
 /*    20 */   406,  406,  406,  406,  406,  406,  406,  406,  406,  406,
 /*    30 */   406,  406,  406,   15,   15,   15,  152,  273,  273,   31,
 /*    40 */    31,  273,   31,   31,  149,  184,  280,  280,  247,  397,
 /*    50 */   184,   31,   31,  184,   31,  184,  397,  184,  184,   31,
 /*    60 */   377,    0,   13,   13,  677,  750, 1040,  548,  548,  548,
 /*    70 */   548,  548,  548,  548,  548,  548,  548,  548,  548,  548,
 /*    80 */   548,  548,  548,  548,  548,  548,  548,  779,  202,  207,
 /*    90 */   455,  455,  455,  229,  442,  397,  184,  184,  184,  308,
 /*   100 */    78,   78,   78,   78,   78,   96,  755,  898,  417,  429,
 /*   110 */   126,  578,  498,  121,  505,  121,  370,  258,  409,  716,
 /*   120 */   623,  626,  626,  716,  726,  149,  442,  752,  149,  149,
 /*   130 */   716,  149,  790,  184,  184,  184,  184,  184,  184,  184,
 /*   140 */   184,  184,  184,  184,  716,  790,  726,  377,  442,  752,
 /*   150 */   377,  872,  740,  749,  791,  740,  749,  791,  791,  759,
 /*   160 */   761,  776,  780,  792,  442,  919,  825,  784,  783,  786,
 /*   170 */   883,  184,  749,  791,  791,  749,  791,  847,  442,  752,
 /*   180 */   377,  308,  377,  442,  920,  716,  377,  790, 1282, 1282,
 /*   190 */  1282, 1282,   48,  768,  782, 1038,  484,  507,  624, 1115,
 /*   200 */  1130, 1020,  854,  236,  236,  236,  236,  236,  236,  236,
 /*   210 */   264,  156,  154,  130,  130,  130,  130,  510,  516,  564,
 /*   220 */   590,   66,  328,  613,  546,  537,  573,  574,  522,  486,
 /*   230 */   146,  471,  615,  570,  618,  630,  642,  643,  649,  672,
 /*   240 */   682,  543,  644,  704,  742,  751,  766,  781,  794,  596,
 /*   250 */  1013,  934, 1016, 1023,  905, 1024, 1031, 1033, 1034, 1035,
 /*   260 */  1036, 1019, 1042, 1044, 1045, 1046, 1048, 1049, 1050,  995,
 /*   270 */  1057, 1010, 1068, 1070, 1041, 1051, 1029, 1076, 1088, 1089,
 /*   280 */  1090, 1018, 1021, 1060, 1062, 1080, 1103, 1066, 1069, 1071,
 /*   290 */  1072, 1074, 1077, 1106, 1096, 1119, 1098, 1082, 1123, 1102,
 /*   300 */  1087, 1133, 1112, 1135, 1117, 1121, 1148, 1154, 1039, 1156,
 /*   310 */  1092, 1114, 1047, 1081, 1084, 1008, 1094, 1085, 1099, 1101,
 /*   320 */  1104, 1105, 1107, 1108, 1086, 1091, 1110, 1095, 1030, 1113,
 /*   330 */  1116, 1093, 1026, 1100, 1109, 1118, 1111, 1043, 1175, 1145,
 /*   340 */  1146, 1150, 1152, 1153, 1157, 1184, 1073, 1120, 1125, 1128,
 /*   350 */  1131, 1129, 1132, 1134, 1136, 1083, 1137, 1206, 1164, 1097,
 /*   360 */  1140, 1138, 1139, 1141, 1187, 1142, 1143, 1144, 1173, 1174,
 /*   370 */  1147, 1149, 1179, 1155, 1151, 1186, 1158, 1159, 1189, 1161,
 /*   380 */  1162, 1192, 1165, 1160, 1163, 1166, 1167, 1203, 1168, 1169,
 /*   390 */  1194, 1170, 1171, 1172, 1196, 1197, 1214, 1190, 1195, 1219,
 /*   400 */  1205, 1207, 1208, 1209, 1210, 1211, 1213, 1222, 1215, 1217,
 /*   410 */  1218, 1220, 1221, 1224, 1225, 1226, 1227, 1252, 1228, 1231,
 /*   420 */  1229, 1268, 1232, 1234, 1269, 1273, 1253, 1255, 1256, 1257,
 /*   430 */  1259, 1261,
};
#define YY_REDUCE_COUNT (191)
#define YY_REDUCE_MIN   (-225)
#define YY_REDUCE_MAX   (897)
static const short yy_reduce_ofst[] = {
 /*     0 */    63, -172,  -16,  104,   28,  140,  176,  256,  331,  367,
 /*    10 */  -134,  403,  382,  432,  451,  474,  493,  533,  538,  627,
 /*    20 */   632,  662,  670,  706,  729,  734,  769,  777,  799,  827,
 /*    30 */   835,  857,  865,  214,  778,  897, -179, -177,  -14, -150,
 /*    40 */    88, -216, -149, -116, -182,  -12, -178,    3, -225, -207,
 /*    50 */  -114,   35,  155,   81,  162,  227, -140,  123,  253,  213,
 /*    60 */   249, -212, -212, -212, -148,    8,  107,  -56,   12,   92,
 /*    70 */   105,  142,  144,  211,  225,  226,  233,  260,  263,  284,
 /*    80 */   285,  296,  306,  330,  333,  334,  339, -109,  -46,  313,
 /*    90 */   113,  138,  297,  347,  261, -133,  350,  241,  283,  -73,
 /*   100 */  -192, -187,  295,  303,  375,  414,  481,  423,  342,  478,
 /*   110 */   440,  514,  468,  470,  470,  470,  536,  457,  487,  556,
 /*   120 */   529,  535,  539,  563,  549,  587,  554,  592,  600,  603,
 /*   130 */   622,  625,  636,  621,  645,  647,  651,  656,  676,  678,
 /*   140 */   681,  684,  685,  689,  638,  648,  601,  697,  629,  674,
 /*   150 */   705,  668,  639,  688,  690,  659,  700,  691,  703,  673,
 /*   160 */   675,  680,  693,  470,  736,  719,  710,  687,  707,  709,
 /*   170 */   732,  536,  756,  760,  762,  758,  767,  753,  775,  771,
 /*   180 */   788,  795,  802,  785,  793,  809,  812,  822,  811,  819,
 /*   190 */   830,  836,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*    10 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*    20 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*    30 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*    40 */  1023, 1023, 1023, 1023, 1076, 1023, 1023, 1023, 1023, 1023,
 /*    50 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*    60 */  1074, 1023, 1293, 1023, 1189, 1023, 1023, 1023, 1023, 1023,
 /*    70 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*    80 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1076,
 /*    90 */  1304, 1304, 1304, 1074, 1023, 1023, 1023, 1023, 1023, 1158,
 /*   100 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1368, 1023, 1111,
 /*   110 */  1328, 1023, 1320, 1296, 1310, 1297, 1023, 1353, 1313, 1023,
 /*   120 */  1194, 1191, 1191, 1023, 1023, 1076, 1023, 1023, 1076, 1076,
 /*   130 */  1023, 1076, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*   140 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1074, 1023, 1023,
 /*   150 */  1074, 1023, 1335, 1333, 1023, 1335, 1333, 1023, 1023, 1347,
 /*   160 */  1343, 1326, 1324, 1310, 1023, 1023, 1023, 1371, 1359, 1355,
 /*   170 */  1023, 1023, 1333, 1023, 1023, 1333, 1023, 1202, 1023, 1023,
 /*   180 */  1074, 1023, 1074, 1023, 1127, 1023, 1074, 1023, 1161, 1161,
 /*   190 */  1077, 1028, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*   200 */  1023, 1023, 1023, 1258, 1346, 1345, 1257, 1270, 1269, 1268,
 /*   210 */  1023, 1023, 1023, 1252, 1253, 1251, 1250, 1023, 1023, 1023,
 /*   220 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1294, 1023,
 /*   230 */  1356, 1360, 1023, 1023, 1023, 1236, 1023, 1023, 1023, 1023,
 /*   240 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*   250 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*   260 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*   270 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*   280 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*   290 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*   300 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*   310 */  1023, 1023, 1023, 1317, 1327, 1023, 1023, 1023, 1023, 1023,
 /*   320 */  1023, 1023, 1023, 1023, 1023, 1236, 1023, 1344, 1023, 1303,
 /*   330 */  1299, 1023, 1023, 1295, 1023, 1023, 1354, 1023, 1023, 1023,
 /*   340 */  1023, 1023, 1023, 1023, 1023, 1289, 1023, 1023, 1023, 1023,
 /*   350 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*   360 */  1023, 1023, 1235, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*   370 */  1155, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*   380 */  1023, 1023, 1023, 1140, 1138, 1137, 1136, 1023, 1133, 1023,
 /*   390 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*   400 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*   410 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*   420 */  1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023, 1023,
 /*   430 */  1023, 1023,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "DNODE",
  /*   37 */ "PORT",
  /*   38 */ "NK_INTEGER",
  /*   39 */ "DNODES",
  /*   40 */ "NK_IPTOKEN",
  /*   41 */ "LOCAL",
  /*   42 */ "QNODE",
  /*   43 */ "ON",
  /*   44 */ "DATABASE",
  /*   45 */ "USE",
  /*   46 */ "IF",
  /*   47 */ "NOT",
  /*   48 */ "EXISTS",
  /*   49 */ "BLOCKS",
  /*   50 */ "CACHE",
  /*   51 */ "CACHELAST",
  /*   52 */ "COMP",
  /*   53 */ "DAYS",
  /*   54 */ "FSYNC",
  /*   55 */ "MAXROWS",
  /*   56 */ "MINROWS",
  /*   57 */ "KEEP",
  /*   58 */ "PRECISION",
  /*   59 */ "QUORUM",
  /*   60 */ "REPLICA",
  /*   61 */ "TTL",
  /*   62 */ "WAL",
  /*   63 */ "VGROUPS",
  /*   64 */ "SINGLE_STABLE",
  /*   65 */ "STREAM_MODE",
  /*   66 */ "RETENTIONS",
  /*   67 */ "TABLE",
  /*   68 */ "NK_LP",
  /*   69 */ "NK_RP",
  /*   70 */ "STABLE",
  /*   71 */ "ADD",
  /*   72 */ "COLUMN",
  /*   73 */ "MODIFY",
  /*   74 */ "RENAME",
  /*   75 */ "TAG",
  /*   76 */ "SET",
  /*   77 */ "NK_EQ",
  /*   78 */ "USING",
  /*   79 */ "TAGS",
  /*   80 */ "NK_DOT",
  /*   81 */ "NK_COMMA",
  /*   82 */ "COMMENT",
  /*   83 */ "BOOL",
  /*   84 */ "TINYINT",
  /*   85 */ "SMALLINT",
  /*   86 */ "INT",
  /*   87 */ "INTEGER",
  /*   88 */ "BIGINT",
  /*   89 */ "FLOAT",
  /*   90 */ "DOUBLE",
  /*   91 */ "BINARY",
  /*   92 */ "TIMESTAMP",
  /*   93 */ "NCHAR",
  /*   94 */ "UNSIGNED",
  /*   95 */ "JSON",
  /*   96 */ "VARCHAR",
  /*   97 */ "MEDIUMBLOB",
  /*   98 */ "BLOB",
  /*   99 */ "VARBINARY",
  /*  100 */ "DECIMAL",
  /*  101 */ "SMA",
  /*  102 */ "ROLLUP",
  /*  103 */ "FILE_FACTOR",
  /*  104 */ "NK_FLOAT",
  /*  105 */ "DELAY",
  /*  106 */ "SHOW",
  /*  107 */ "DATABASES",
  /*  108 */ "TABLES",
  /*  109 */ "STABLES",
  /*  110 */ "MNODES",
  /*  111 */ "MODULES",
  /*  112 */ "QNODES",
  /*  113 */ "FUNCTIONS",
  /*  114 */ "INDEXES",
  /*  115 */ "FROM",
  /*  116 */ "LIKE",
  /*  117 */ "INDEX",
  /*  118 */ "FULLTEXT",
  /*  119 */ "FUNCTION",
  /*  120 */ "INTERVAL",
  /*  121 */ "TOPIC",
  /*  122 */ "AS",
  /*  123 */ "NK_BOOL",
  /*  124 */ "NULL",
  /*  125 */ "NK_VARIABLE",
  /*  126 */ "NK_UNDERLINE",
  /*  127 */ "ROWTS",
  /*  128 */ "TBNAME",
  /*  129 */ "QSTARTTS",
  /*  130 */ "QENDTS",
  /*  131 */ "WSTARTTS",
  /*  132 */ "WENDTS",
  /*  133 */ "WDURATION",
  /*  134 */ "BETWEEN",
  /*  135 */ "IS",
  /*  136 */ "NK_LT",
  /*  137 */ "NK_GT",
  /*  138 */ "NK_LE",
  /*  139 */ "NK_GE",
  /*  140 */ "NK_NE",
  /*  141 */ "MATCH",
  /*  142 */ "NMATCH",
  /*  143 */ "IN",
  /*  144 */ "JOIN",
  /*  145 */ "INNER",
  /*  146 */ "SELECT",
  /*  147 */ "DISTINCT",
  /*  148 */ "WHERE",
  /*  149 */ "PARTITION",
  /*  150 */ "BY",
  /*  151 */ "SESSION",
  /*  152 */ "STATE_WINDOW",
  /*  153 */ "SLIDING",
  /*  154 */ "FILL",
  /*  155 */ "VALUE",
  /*  156 */ "NONE",
  /*  157 */ "PREV",
  /*  158 */ "LINEAR",
  /*  159 */ "NEXT",
  /*  160 */ "GROUP",
  /*  161 */ "HAVING",
  /*  162 */ "ORDER",
  /*  163 */ "SLIMIT",
  /*  164 */ "SOFFSET",
  /*  165 */ "LIMIT",
  /*  166 */ "OFFSET",
  /*  167 */ "ASC",
  /*  168 */ "DESC",
  /*  169 */ "NULLS",
  /*  170 */ "FIRST",
  /*  171 */ "LAST",
  /*  172 */ "cmd",
  /*  173 */ "account_options",
  /*  174 */ "alter_account_options",
  /*  175 */ "literal",
  /*  176 */ "alter_account_option",
  /*  177 */ "user_name",
  /*  178 */ "dnode_endpoint",
  /*  179 */ "dnode_host_name",
  /*  180 */ "not_exists_opt",
  /*  181 */ "db_name",
  /*  182 */ "db_options",
  /*  183 */ "exists_opt",
  /*  184 */ "alter_db_options",
  /*  185 */ "alter_db_option",
  /*  186 */ "full_table_name",
  /*  187 */ "column_def_list",
  /*  188 */ "tags_def_opt",
  /*  189 */ "table_options",
  /*  190 */ "multi_create_clause",
  /*  191 */ "tags_def",
  /*  192 */ "multi_drop_clause",
  /*  193 */ "alter_table_clause",
  /*  194 */ "alter_table_options",
  /*  195 */ "column_name",
  /*  196 */ "type_name",
  /*  197 */ "create_subtable_clause",
  /*  198 */ "specific_tags_opt",
  /*  199 */ "literal_list",
  /*  200 */ "drop_table_clause",
  /*  201 */ "col_name_list",
  /*  202 */ "table_name",
  /*  203 */ "column_def",
  /*  204 */ "func_name_list",
  /*  205 */ "alter_table_option",
  /*  206 */ "col_name",
  /*  207 */ "db_name_cond_opt",
  /*  208 */ "like_pattern_opt",
  /*  209 */ "table_name_cond",
  /*  210 */ "from_db_opt",
  /*  211 */ "func_name",
  /*  212 */ "function_name",
  /*  213 */ "index_name",
  /*  214 */ "index_options",
  /*  215 */ "func_list",
  /*  216 */ "duration_literal",
  /*  217 */ "sliding_opt",
  /*  218 */ "func",
  /*  219 */ "expression_list",
  /*  220 */ "topic_name",
  /*  221 */ "query_expression",
  /*  222 */ "signed",
  /*  223 */ "signed_literal",
  /*  224 */ "table_alias",
  /*  225 */ "column_alias",
  /*  226 */ "expression",
  /*  227 */ "pseudo_column",
  /*  228 */ "column_reference",
  /*  229 */ "subquery",
  /*  230 */ "predicate",
  /*  231 */ "compare_op",
  /*  232 */ "in_op",
  /*  233 */ "in_predicate_value",
  /*  234 */ "boolean_value_expression",
  /*  235 */ "boolean_primary",
  /*  236 */ "common_expression",
  /*  237 */ "from_clause",
  /*  238 */ "table_reference_list",
  /*  239 */ "table_reference",
  /*  240 */ "table_primary",
  /*  241 */ "joined_table",
  /*  242 */ "alias_opt",
  /*  243 */ "parenthesized_joined_table",
  /*  244 */ "join_type",
  /*  245 */ "search_condition",
  /*  246 */ "query_specification",
  /*  247 */ "set_quantifier_opt",
  /*  248 */ "select_list",
  /*  249 */ "where_clause_opt",
  /*  250 */ "partition_by_clause_opt",
  /*  251 */ "twindow_clause_opt",
  /*  252 */ "group_by_clause_opt",
  /*  253 */ "having_clause_opt",
  /*  254 */ "select_sublist",
  /*  255 */ "select_item",
  /*  256 */ "fill_opt",
  /*  257 */ "fill_mode",
  /*  258 */ "group_by_list",
  /*  259 */ "query_expression_body",
  /*  260 */ "order_by_clause_opt",
  /*  261 */ "slimit_clause_opt",
  /*  262 */ "limit_clause_opt",
  /*  263 */ "query_primary",
  /*  264 */ "sort_specification_list",
  /*  265 */ "sort_specification",
  /*  266 */ "ordering_specification_opt",
  /*  267 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  29 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  30 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  31 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  32 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  33 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  34 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  35 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  36 */ "dnode_endpoint ::= NK_STRING",
 /*  37 */ "dnode_host_name ::= NK_ID",
 /*  38 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  39 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  40 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  41 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  42 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  43 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  44 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  45 */ "cmd ::= USE db_name",
 /*  46 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  47 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  48 */ "not_exists_opt ::=",
 /*  49 */ "exists_opt ::= IF EXISTS",
 /*  50 */ "exists_opt ::=",
 /*  51 */ "db_options ::=",
 /*  52 */ "db_options ::= db_options BLOCKS NK_INTEGER",
 /*  53 */ "db_options ::= db_options CACHE NK_INTEGER",
 /*  54 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  55 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  56 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  57 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  58 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  59 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  60 */ "db_options ::= db_options KEEP NK_INTEGER",
 /*  61 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  62 */ "db_options ::= db_options QUORUM NK_INTEGER",
 /*  63 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  64 */ "db_options ::= db_options TTL NK_INTEGER",
 /*  65 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  66 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  67 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  68 */ "db_options ::= db_options STREAM_MODE NK_INTEGER",
 /*  69 */ "db_options ::= db_options RETENTIONS NK_STRING",
 /*  70 */ "alter_db_options ::= alter_db_option",
 /*  71 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  72 */ "alter_db_option ::= BLOCKS NK_INTEGER",
 /*  73 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  74 */ "alter_db_option ::= KEEP NK_INTEGER",
 /*  75 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  76 */ "alter_db_option ::= QUORUM NK_INTEGER",
 /*  77 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  78 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /*  79 */ "cmd ::= CREATE TABLE multi_create_clause",
 /*  80 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /*  81 */ "cmd ::= DROP TABLE multi_drop_clause",
 /*  82 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /*  83 */ "cmd ::= ALTER TABLE alter_table_clause",
 /*  84 */ "cmd ::= ALTER STABLE alter_table_clause",
 /*  85 */ "alter_table_clause ::= full_table_name alter_table_options",
 /*  86 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /*  87 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /*  88 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /*  89 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /*  90 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /*  91 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /*  92 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /*  93 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /*  94 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal",
 /*  95 */ "multi_create_clause ::= create_subtable_clause",
 /*  96 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /*  97 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP",
 /*  98 */ "multi_drop_clause ::= drop_table_clause",
 /*  99 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 100 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 101 */ "specific_tags_opt ::=",
 /* 102 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 103 */ "full_table_name ::= table_name",
 /* 104 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 105 */ "column_def_list ::= column_def",
 /* 106 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 107 */ "column_def ::= column_name type_name",
 /* 108 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 109 */ "type_name ::= BOOL",
 /* 110 */ "type_name ::= TINYINT",
 /* 111 */ "type_name ::= SMALLINT",
 /* 112 */ "type_name ::= INT",
 /* 113 */ "type_name ::= INTEGER",
 /* 114 */ "type_name ::= BIGINT",
 /* 115 */ "type_name ::= FLOAT",
 /* 116 */ "type_name ::= DOUBLE",
 /* 117 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 118 */ "type_name ::= TIMESTAMP",
 /* 119 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 120 */ "type_name ::= TINYINT UNSIGNED",
 /* 121 */ "type_name ::= SMALLINT UNSIGNED",
 /* 122 */ "type_name ::= INT UNSIGNED",
 /* 123 */ "type_name ::= BIGINT UNSIGNED",
 /* 124 */ "type_name ::= JSON",
 /* 125 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 126 */ "type_name ::= MEDIUMBLOB",
 /* 127 */ "type_name ::= BLOB",
 /* 128 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 129 */ "type_name ::= DECIMAL",
 /* 130 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 131 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 132 */ "tags_def_opt ::=",
 /* 133 */ "tags_def_opt ::= tags_def",
 /* 134 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 135 */ "table_options ::=",
 /* 136 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 137 */ "table_options ::= table_options KEEP NK_INTEGER",
 /* 138 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 139 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 140 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 141 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 142 */ "table_options ::= table_options DELAY NK_INTEGER",
 /* 143 */ "alter_table_options ::= alter_table_option",
 /* 144 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 145 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 146 */ "alter_table_option ::= KEEP NK_INTEGER",
 /* 147 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 148 */ "col_name_list ::= col_name",
 /* 149 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 150 */ "col_name ::= column_name",
 /* 151 */ "cmd ::= SHOW DNODES",
 /* 152 */ "cmd ::= SHOW USERS",
 /* 153 */ "cmd ::= SHOW DATABASES",
 /* 154 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 155 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 156 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 157 */ "cmd ::= SHOW MNODES",
 /* 158 */ "cmd ::= SHOW MODULES",
 /* 159 */ "cmd ::= SHOW QNODES",
 /* 160 */ "cmd ::= SHOW FUNCTIONS",
 /* 161 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 162 */ "cmd ::= SHOW STREAMS",
 /* 163 */ "db_name_cond_opt ::=",
 /* 164 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 165 */ "like_pattern_opt ::=",
 /* 166 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 167 */ "table_name_cond ::= table_name",
 /* 168 */ "from_db_opt ::=",
 /* 169 */ "from_db_opt ::= FROM db_name",
 /* 170 */ "func_name_list ::= func_name",
 /* 171 */ "func_name_list ::= func_name_list NK_COMMA col_name",
 /* 172 */ "func_name ::= function_name",
 /* 173 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 174 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 175 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 176 */ "index_options ::=",
 /* 177 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 178 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 179 */ "func_list ::= func",
 /* 180 */ "func_list ::= func_list NK_COMMA func",
 /* 181 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 182 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 183 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name",
 /* 184 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 185 */ "cmd ::= query_expression",
 /* 186 */ "literal ::= NK_INTEGER",
 /* 187 */ "literal ::= NK_FLOAT",
 /* 188 */ "literal ::= NK_STRING",
 /* 189 */ "literal ::= NK_BOOL",
 /* 190 */ "literal ::= TIMESTAMP NK_STRING",
 /* 191 */ "literal ::= duration_literal",
 /* 192 */ "literal ::= NULL",
 /* 193 */ "duration_literal ::= NK_VARIABLE",
 /* 194 */ "signed ::= NK_INTEGER",
 /* 195 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 196 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 197 */ "signed ::= NK_FLOAT",
 /* 198 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 199 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 200 */ "signed_literal ::= signed",
 /* 201 */ "signed_literal ::= NK_STRING",
 /* 202 */ "signed_literal ::= NK_BOOL",
 /* 203 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 204 */ "signed_literal ::= duration_literal",
 /* 205 */ "signed_literal ::= NULL",
 /* 206 */ "literal_list ::= signed_literal",
 /* 207 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 208 */ "db_name ::= NK_ID",
 /* 209 */ "table_name ::= NK_ID",
 /* 210 */ "column_name ::= NK_ID",
 /* 211 */ "function_name ::= NK_ID",
 /* 212 */ "table_alias ::= NK_ID",
 /* 213 */ "column_alias ::= NK_ID",
 /* 214 */ "user_name ::= NK_ID",
 /* 215 */ "index_name ::= NK_ID",
 /* 216 */ "topic_name ::= NK_ID",
 /* 217 */ "expression ::= literal",
 /* 218 */ "expression ::= pseudo_column",
 /* 219 */ "expression ::= column_reference",
 /* 220 */ "expression ::= function_name NK_LP expression_list NK_RP",
 /* 221 */ "expression ::= function_name NK_LP NK_STAR NK_RP",
 /* 222 */ "expression ::= subquery",
 /* 223 */ "expression ::= NK_LP expression NK_RP",
 /* 224 */ "expression ::= NK_PLUS expression",
 /* 225 */ "expression ::= NK_MINUS expression",
 /* 226 */ "expression ::= expression NK_PLUS expression",
 /* 227 */ "expression ::= expression NK_MINUS expression",
 /* 228 */ "expression ::= expression NK_STAR expression",
 /* 229 */ "expression ::= expression NK_SLASH expression",
 /* 230 */ "expression ::= expression NK_REM expression",
 /* 231 */ "expression_list ::= expression",
 /* 232 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 233 */ "column_reference ::= column_name",
 /* 234 */ "column_reference ::= table_name NK_DOT column_name",
 /* 235 */ "pseudo_column ::= NK_UNDERLINE ROWTS",
 /* 236 */ "pseudo_column ::= TBNAME",
 /* 237 */ "pseudo_column ::= NK_UNDERLINE QSTARTTS",
 /* 238 */ "pseudo_column ::= NK_UNDERLINE QENDTS",
 /* 239 */ "pseudo_column ::= NK_UNDERLINE WSTARTTS",
 /* 240 */ "pseudo_column ::= NK_UNDERLINE WENDTS",
 /* 241 */ "pseudo_column ::= NK_UNDERLINE WDURATION",
 /* 242 */ "predicate ::= expression compare_op expression",
 /* 243 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 244 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 245 */ "predicate ::= expression IS NULL",
 /* 246 */ "predicate ::= expression IS NOT NULL",
 /* 247 */ "predicate ::= expression in_op in_predicate_value",
 /* 248 */ "compare_op ::= NK_LT",
 /* 249 */ "compare_op ::= NK_GT",
 /* 250 */ "compare_op ::= NK_LE",
 /* 251 */ "compare_op ::= NK_GE",
 /* 252 */ "compare_op ::= NK_NE",
 /* 253 */ "compare_op ::= NK_EQ",
 /* 254 */ "compare_op ::= LIKE",
 /* 255 */ "compare_op ::= NOT LIKE",
 /* 256 */ "compare_op ::= MATCH",
 /* 257 */ "compare_op ::= NMATCH",
 /* 258 */ "in_op ::= IN",
 /* 259 */ "in_op ::= NOT IN",
 /* 260 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 261 */ "boolean_value_expression ::= boolean_primary",
 /* 262 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 263 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 264 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 265 */ "boolean_primary ::= predicate",
 /* 266 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 267 */ "common_expression ::= expression",
 /* 268 */ "common_expression ::= boolean_value_expression",
 /* 269 */ "from_clause ::= FROM table_reference_list",
 /* 270 */ "table_reference_list ::= table_reference",
 /* 271 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 272 */ "table_reference ::= table_primary",
 /* 273 */ "table_reference ::= joined_table",
 /* 274 */ "table_primary ::= table_name alias_opt",
 /* 275 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 276 */ "table_primary ::= subquery alias_opt",
 /* 277 */ "table_primary ::= parenthesized_joined_table",
 /* 278 */ "alias_opt ::=",
 /* 279 */ "alias_opt ::= table_alias",
 /* 280 */ "alias_opt ::= AS table_alias",
 /* 281 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 282 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 283 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 284 */ "join_type ::=",
 /* 285 */ "join_type ::= INNER",
 /* 286 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 287 */ "set_quantifier_opt ::=",
 /* 288 */ "set_quantifier_opt ::= DISTINCT",
 /* 289 */ "set_quantifier_opt ::= ALL",
 /* 290 */ "select_list ::= NK_STAR",
 /* 291 */ "select_list ::= select_sublist",
 /* 292 */ "select_sublist ::= select_item",
 /* 293 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 294 */ "select_item ::= common_expression",
 /* 295 */ "select_item ::= common_expression column_alias",
 /* 296 */ "select_item ::= common_expression AS column_alias",
 /* 297 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 298 */ "where_clause_opt ::=",
 /* 299 */ "where_clause_opt ::= WHERE search_condition",
 /* 300 */ "partition_by_clause_opt ::=",
 /* 301 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 302 */ "twindow_clause_opt ::=",
 /* 303 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 304 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP column_reference NK_RP",
 /* 305 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 306 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 307 */ "sliding_opt ::=",
 /* 308 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 309 */ "fill_opt ::=",
 /* 310 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 311 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 312 */ "fill_mode ::= NONE",
 /* 313 */ "fill_mode ::= PREV",
 /* 314 */ "fill_mode ::= NULL",
 /* 315 */ "fill_mode ::= LINEAR",
 /* 316 */ "fill_mode ::= NEXT",
 /* 317 */ "group_by_clause_opt ::=",
 /* 318 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 319 */ "group_by_list ::= expression",
 /* 320 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 321 */ "having_clause_opt ::=",
 /* 322 */ "having_clause_opt ::= HAVING search_condition",
 /* 323 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 324 */ "query_expression_body ::= query_primary",
 /* 325 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 326 */ "query_primary ::= query_specification",
 /* 327 */ "order_by_clause_opt ::=",
 /* 328 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 329 */ "slimit_clause_opt ::=",
 /* 330 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 331 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 332 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 333 */ "limit_clause_opt ::=",
 /* 334 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 335 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 336 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 337 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 338 */ "search_condition ::= common_expression",
 /* 339 */ "sort_specification_list ::= sort_specification",
 /* 340 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 341 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 342 */ "ordering_specification_opt ::=",
 /* 343 */ "ordering_specification_opt ::= ASC",
 /* 344 */ "ordering_specification_opt ::= DESC",
 /* 345 */ "null_ordering_opt ::=",
 /* 346 */ "null_ordering_opt ::= NULLS FIRST",
 /* 347 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 172: /* cmd */
    case 175: /* literal */
    case 182: /* db_options */
    case 184: /* alter_db_options */
    case 186: /* full_table_name */
    case 189: /* table_options */
    case 193: /* alter_table_clause */
    case 194: /* alter_table_options */
    case 197: /* create_subtable_clause */
    case 200: /* drop_table_clause */
    case 203: /* column_def */
    case 206: /* col_name */
    case 207: /* db_name_cond_opt */
    case 208: /* like_pattern_opt */
    case 209: /* table_name_cond */
    case 210: /* from_db_opt */
    case 211: /* func_name */
    case 214: /* index_options */
    case 216: /* duration_literal */
    case 217: /* sliding_opt */
    case 218: /* func */
    case 221: /* query_expression */
    case 222: /* signed */
    case 223: /* signed_literal */
    case 226: /* expression */
    case 227: /* pseudo_column */
    case 228: /* column_reference */
    case 229: /* subquery */
    case 230: /* predicate */
    case 233: /* in_predicate_value */
    case 234: /* boolean_value_expression */
    case 235: /* boolean_primary */
    case 236: /* common_expression */
    case 237: /* from_clause */
    case 238: /* table_reference_list */
    case 239: /* table_reference */
    case 240: /* table_primary */
    case 241: /* joined_table */
    case 243: /* parenthesized_joined_table */
    case 245: /* search_condition */
    case 246: /* query_specification */
    case 249: /* where_clause_opt */
    case 251: /* twindow_clause_opt */
    case 253: /* having_clause_opt */
    case 255: /* select_item */
    case 256: /* fill_opt */
    case 259: /* query_expression_body */
    case 261: /* slimit_clause_opt */
    case 262: /* limit_clause_opt */
    case 263: /* query_primary */
    case 265: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy176)); 
}
      break;
    case 173: /* account_options */
    case 174: /* alter_account_options */
    case 176: /* alter_account_option */
{
 
}
      break;
    case 177: /* user_name */
    case 178: /* dnode_endpoint */
    case 179: /* dnode_host_name */
    case 181: /* db_name */
    case 195: /* column_name */
    case 202: /* table_name */
    case 212: /* function_name */
    case 213: /* index_name */
    case 220: /* topic_name */
    case 224: /* table_alias */
    case 225: /* column_alias */
    case 242: /* alias_opt */
{
 
}
      break;
    case 180: /* not_exists_opt */
    case 183: /* exists_opt */
    case 247: /* set_quantifier_opt */
{
 
}
      break;
    case 185: /* alter_db_option */
    case 205: /* alter_table_option */
{
 
}
      break;
    case 187: /* column_def_list */
    case 188: /* tags_def_opt */
    case 190: /* multi_create_clause */
    case 191: /* tags_def */
    case 192: /* multi_drop_clause */
    case 198: /* specific_tags_opt */
    case 199: /* literal_list */
    case 201: /* col_name_list */
    case 204: /* func_name_list */
    case 215: /* func_list */
    case 219: /* expression_list */
    case 248: /* select_list */
    case 250: /* partition_by_clause_opt */
    case 252: /* group_by_clause_opt */
    case 254: /* select_sublist */
    case 258: /* group_by_list */
    case 260: /* order_by_clause_opt */
    case 264: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy512)); 
}
      break;
    case 196: /* type_name */
{
 
}
      break;
    case 231: /* compare_op */
    case 232: /* in_op */
{
 
}
      break;
    case 244: /* join_type */
{
 
}
      break;
    case 257: /* fill_mode */
{
 
}
      break;
    case 266: /* ordering_specification_opt */
{
 
}
      break;
    case 267: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  172,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  172,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  173,    0 }, /* (2) account_options ::= */
  {  173,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  173,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  173,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  173,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  173,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  173,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  173,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  173,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  173,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  174,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  174,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  176,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  176,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  176,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  176,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  176,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  176,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  176,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  176,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  176,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  176,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  172,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  172,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  172,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  172,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  172,   -3 }, /* (28) cmd ::= CREATE DNODE dnode_endpoint */
  {  172,   -5 }, /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  172,   -3 }, /* (30) cmd ::= DROP DNODE NK_INTEGER */
  {  172,   -3 }, /* (31) cmd ::= DROP DNODE dnode_endpoint */
  {  172,   -4 }, /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  172,   -5 }, /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  172,   -4 }, /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
  {  172,   -5 }, /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  178,   -1 }, /* (36) dnode_endpoint ::= NK_STRING */
  {  179,   -1 }, /* (37) dnode_host_name ::= NK_ID */
  {  179,   -1 }, /* (38) dnode_host_name ::= NK_IPTOKEN */
  {  172,   -3 }, /* (39) cmd ::= ALTER LOCAL NK_STRING */
  {  172,   -4 }, /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  172,   -5 }, /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  172,   -5 }, /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  172,   -5 }, /* (43) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  172,   -4 }, /* (44) cmd ::= DROP DATABASE exists_opt db_name */
  {  172,   -2 }, /* (45) cmd ::= USE db_name */
  {  172,   -4 }, /* (46) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  180,   -3 }, /* (47) not_exists_opt ::= IF NOT EXISTS */
  {  180,    0 }, /* (48) not_exists_opt ::= */
  {  183,   -2 }, /* (49) exists_opt ::= IF EXISTS */
  {  183,    0 }, /* (50) exists_opt ::= */
  {  182,    0 }, /* (51) db_options ::= */
  {  182,   -3 }, /* (52) db_options ::= db_options BLOCKS NK_INTEGER */
  {  182,   -3 }, /* (53) db_options ::= db_options CACHE NK_INTEGER */
  {  182,   -3 }, /* (54) db_options ::= db_options CACHELAST NK_INTEGER */
  {  182,   -3 }, /* (55) db_options ::= db_options COMP NK_INTEGER */
  {  182,   -3 }, /* (56) db_options ::= db_options DAYS NK_INTEGER */
  {  182,   -3 }, /* (57) db_options ::= db_options FSYNC NK_INTEGER */
  {  182,   -3 }, /* (58) db_options ::= db_options MAXROWS NK_INTEGER */
  {  182,   -3 }, /* (59) db_options ::= db_options MINROWS NK_INTEGER */
  {  182,   -3 }, /* (60) db_options ::= db_options KEEP NK_INTEGER */
  {  182,   -3 }, /* (61) db_options ::= db_options PRECISION NK_STRING */
  {  182,   -3 }, /* (62) db_options ::= db_options QUORUM NK_INTEGER */
  {  182,   -3 }, /* (63) db_options ::= db_options REPLICA NK_INTEGER */
  {  182,   -3 }, /* (64) db_options ::= db_options TTL NK_INTEGER */
  {  182,   -3 }, /* (65) db_options ::= db_options WAL NK_INTEGER */
  {  182,   -3 }, /* (66) db_options ::= db_options VGROUPS NK_INTEGER */
  {  182,   -3 }, /* (67) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  182,   -3 }, /* (68) db_options ::= db_options STREAM_MODE NK_INTEGER */
  {  182,   -3 }, /* (69) db_options ::= db_options RETENTIONS NK_STRING */
  {  184,   -1 }, /* (70) alter_db_options ::= alter_db_option */
  {  184,   -2 }, /* (71) alter_db_options ::= alter_db_options alter_db_option */
  {  185,   -2 }, /* (72) alter_db_option ::= BLOCKS NK_INTEGER */
  {  185,   -2 }, /* (73) alter_db_option ::= FSYNC NK_INTEGER */
  {  185,   -2 }, /* (74) alter_db_option ::= KEEP NK_INTEGER */
  {  185,   -2 }, /* (75) alter_db_option ::= WAL NK_INTEGER */
  {  185,   -2 }, /* (76) alter_db_option ::= QUORUM NK_INTEGER */
  {  185,   -2 }, /* (77) alter_db_option ::= CACHELAST NK_INTEGER */
  {  172,   -9 }, /* (78) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  172,   -3 }, /* (79) cmd ::= CREATE TABLE multi_create_clause */
  {  172,   -9 }, /* (80) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  172,   -3 }, /* (81) cmd ::= DROP TABLE multi_drop_clause */
  {  172,   -4 }, /* (82) cmd ::= DROP STABLE exists_opt full_table_name */
  {  172,   -3 }, /* (83) cmd ::= ALTER TABLE alter_table_clause */
  {  172,   -3 }, /* (84) cmd ::= ALTER STABLE alter_table_clause */
  {  193,   -2 }, /* (85) alter_table_clause ::= full_table_name alter_table_options */
  {  193,   -5 }, /* (86) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  193,   -4 }, /* (87) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  193,   -5 }, /* (88) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  193,   -5 }, /* (89) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  193,   -5 }, /* (90) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  193,   -4 }, /* (91) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  193,   -5 }, /* (92) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  193,   -5 }, /* (93) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  193,   -6 }, /* (94) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
  {  190,   -1 }, /* (95) multi_create_clause ::= create_subtable_clause */
  {  190,   -2 }, /* (96) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  197,   -9 }, /* (97) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
  {  192,   -1 }, /* (98) multi_drop_clause ::= drop_table_clause */
  {  192,   -2 }, /* (99) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  200,   -2 }, /* (100) drop_table_clause ::= exists_opt full_table_name */
  {  198,    0 }, /* (101) specific_tags_opt ::= */
  {  198,   -3 }, /* (102) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  186,   -1 }, /* (103) full_table_name ::= table_name */
  {  186,   -3 }, /* (104) full_table_name ::= db_name NK_DOT table_name */
  {  187,   -1 }, /* (105) column_def_list ::= column_def */
  {  187,   -3 }, /* (106) column_def_list ::= column_def_list NK_COMMA column_def */
  {  203,   -2 }, /* (107) column_def ::= column_name type_name */
  {  203,   -4 }, /* (108) column_def ::= column_name type_name COMMENT NK_STRING */
  {  196,   -1 }, /* (109) type_name ::= BOOL */
  {  196,   -1 }, /* (110) type_name ::= TINYINT */
  {  196,   -1 }, /* (111) type_name ::= SMALLINT */
  {  196,   -1 }, /* (112) type_name ::= INT */
  {  196,   -1 }, /* (113) type_name ::= INTEGER */
  {  196,   -1 }, /* (114) type_name ::= BIGINT */
  {  196,   -1 }, /* (115) type_name ::= FLOAT */
  {  196,   -1 }, /* (116) type_name ::= DOUBLE */
  {  196,   -4 }, /* (117) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  196,   -1 }, /* (118) type_name ::= TIMESTAMP */
  {  196,   -4 }, /* (119) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  196,   -2 }, /* (120) type_name ::= TINYINT UNSIGNED */
  {  196,   -2 }, /* (121) type_name ::= SMALLINT UNSIGNED */
  {  196,   -2 }, /* (122) type_name ::= INT UNSIGNED */
  {  196,   -2 }, /* (123) type_name ::= BIGINT UNSIGNED */
  {  196,   -1 }, /* (124) type_name ::= JSON */
  {  196,   -4 }, /* (125) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  196,   -1 }, /* (126) type_name ::= MEDIUMBLOB */
  {  196,   -1 }, /* (127) type_name ::= BLOB */
  {  196,   -4 }, /* (128) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  196,   -1 }, /* (129) type_name ::= DECIMAL */
  {  196,   -4 }, /* (130) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  196,   -6 }, /* (131) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  188,    0 }, /* (132) tags_def_opt ::= */
  {  188,   -1 }, /* (133) tags_def_opt ::= tags_def */
  {  191,   -4 }, /* (134) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  189,    0 }, /* (135) table_options ::= */
  {  189,   -3 }, /* (136) table_options ::= table_options COMMENT NK_STRING */
  {  189,   -3 }, /* (137) table_options ::= table_options KEEP NK_INTEGER */
  {  189,   -3 }, /* (138) table_options ::= table_options TTL NK_INTEGER */
  {  189,   -5 }, /* (139) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  189,   -5 }, /* (140) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  189,   -3 }, /* (141) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  189,   -3 }, /* (142) table_options ::= table_options DELAY NK_INTEGER */
  {  194,   -1 }, /* (143) alter_table_options ::= alter_table_option */
  {  194,   -2 }, /* (144) alter_table_options ::= alter_table_options alter_table_option */
  {  205,   -2 }, /* (145) alter_table_option ::= COMMENT NK_STRING */
  {  205,   -2 }, /* (146) alter_table_option ::= KEEP NK_INTEGER */
  {  205,   -2 }, /* (147) alter_table_option ::= TTL NK_INTEGER */
  {  201,   -1 }, /* (148) col_name_list ::= col_name */
  {  201,   -3 }, /* (149) col_name_list ::= col_name_list NK_COMMA col_name */
  {  206,   -1 }, /* (150) col_name ::= column_name */
  {  172,   -2 }, /* (151) cmd ::= SHOW DNODES */
  {  172,   -2 }, /* (152) cmd ::= SHOW USERS */
  {  172,   -2 }, /* (153) cmd ::= SHOW DATABASES */
  {  172,   -4 }, /* (154) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  172,   -4 }, /* (155) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  172,   -3 }, /* (156) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  172,   -2 }, /* (157) cmd ::= SHOW MNODES */
  {  172,   -2 }, /* (158) cmd ::= SHOW MODULES */
  {  172,   -2 }, /* (159) cmd ::= SHOW QNODES */
  {  172,   -2 }, /* (160) cmd ::= SHOW FUNCTIONS */
  {  172,   -5 }, /* (161) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  172,   -2 }, /* (162) cmd ::= SHOW STREAMS */
  {  207,    0 }, /* (163) db_name_cond_opt ::= */
  {  207,   -2 }, /* (164) db_name_cond_opt ::= db_name NK_DOT */
  {  208,    0 }, /* (165) like_pattern_opt ::= */
  {  208,   -2 }, /* (166) like_pattern_opt ::= LIKE NK_STRING */
  {  209,   -1 }, /* (167) table_name_cond ::= table_name */
  {  210,    0 }, /* (168) from_db_opt ::= */
  {  210,   -2 }, /* (169) from_db_opt ::= FROM db_name */
  {  204,   -1 }, /* (170) func_name_list ::= func_name */
  {  204,   -3 }, /* (171) func_name_list ::= func_name_list NK_COMMA col_name */
  {  211,   -1 }, /* (172) func_name ::= function_name */
  {  172,   -8 }, /* (173) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  172,  -10 }, /* (174) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  172,   -6 }, /* (175) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  214,    0 }, /* (176) index_options ::= */
  {  214,   -9 }, /* (177) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  214,  -11 }, /* (178) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  215,   -1 }, /* (179) func_list ::= func */
  {  215,   -3 }, /* (180) func_list ::= func_list NK_COMMA func */
  {  218,   -4 }, /* (181) func ::= function_name NK_LP expression_list NK_RP */
  {  172,   -6 }, /* (182) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  172,   -6 }, /* (183) cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
  {  172,   -4 }, /* (184) cmd ::= DROP TOPIC exists_opt topic_name */
  {  172,   -1 }, /* (185) cmd ::= query_expression */
  {  175,   -1 }, /* (186) literal ::= NK_INTEGER */
  {  175,   -1 }, /* (187) literal ::= NK_FLOAT */
  {  175,   -1 }, /* (188) literal ::= NK_STRING */
  {  175,   -1 }, /* (189) literal ::= NK_BOOL */
  {  175,   -2 }, /* (190) literal ::= TIMESTAMP NK_STRING */
  {  175,   -1 }, /* (191) literal ::= duration_literal */
  {  175,   -1 }, /* (192) literal ::= NULL */
  {  216,   -1 }, /* (193) duration_literal ::= NK_VARIABLE */
  {  222,   -1 }, /* (194) signed ::= NK_INTEGER */
  {  222,   -2 }, /* (195) signed ::= NK_PLUS NK_INTEGER */
  {  222,   -2 }, /* (196) signed ::= NK_MINUS NK_INTEGER */
  {  222,   -1 }, /* (197) signed ::= NK_FLOAT */
  {  222,   -2 }, /* (198) signed ::= NK_PLUS NK_FLOAT */
  {  222,   -2 }, /* (199) signed ::= NK_MINUS NK_FLOAT */
  {  223,   -1 }, /* (200) signed_literal ::= signed */
  {  223,   -1 }, /* (201) signed_literal ::= NK_STRING */
  {  223,   -1 }, /* (202) signed_literal ::= NK_BOOL */
  {  223,   -2 }, /* (203) signed_literal ::= TIMESTAMP NK_STRING */
  {  223,   -1 }, /* (204) signed_literal ::= duration_literal */
  {  223,   -1 }, /* (205) signed_literal ::= NULL */
  {  199,   -1 }, /* (206) literal_list ::= signed_literal */
  {  199,   -3 }, /* (207) literal_list ::= literal_list NK_COMMA signed_literal */
  {  181,   -1 }, /* (208) db_name ::= NK_ID */
  {  202,   -1 }, /* (209) table_name ::= NK_ID */
  {  195,   -1 }, /* (210) column_name ::= NK_ID */
  {  212,   -1 }, /* (211) function_name ::= NK_ID */
  {  224,   -1 }, /* (212) table_alias ::= NK_ID */
  {  225,   -1 }, /* (213) column_alias ::= NK_ID */
  {  177,   -1 }, /* (214) user_name ::= NK_ID */
  {  213,   -1 }, /* (215) index_name ::= NK_ID */
  {  220,   -1 }, /* (216) topic_name ::= NK_ID */
  {  226,   -1 }, /* (217) expression ::= literal */
  {  226,   -1 }, /* (218) expression ::= pseudo_column */
  {  226,   -1 }, /* (219) expression ::= column_reference */
  {  226,   -4 }, /* (220) expression ::= function_name NK_LP expression_list NK_RP */
  {  226,   -4 }, /* (221) expression ::= function_name NK_LP NK_STAR NK_RP */
  {  226,   -1 }, /* (222) expression ::= subquery */
  {  226,   -3 }, /* (223) expression ::= NK_LP expression NK_RP */
  {  226,   -2 }, /* (224) expression ::= NK_PLUS expression */
  {  226,   -2 }, /* (225) expression ::= NK_MINUS expression */
  {  226,   -3 }, /* (226) expression ::= expression NK_PLUS expression */
  {  226,   -3 }, /* (227) expression ::= expression NK_MINUS expression */
  {  226,   -3 }, /* (228) expression ::= expression NK_STAR expression */
  {  226,   -3 }, /* (229) expression ::= expression NK_SLASH expression */
  {  226,   -3 }, /* (230) expression ::= expression NK_REM expression */
  {  219,   -1 }, /* (231) expression_list ::= expression */
  {  219,   -3 }, /* (232) expression_list ::= expression_list NK_COMMA expression */
  {  228,   -1 }, /* (233) column_reference ::= column_name */
  {  228,   -3 }, /* (234) column_reference ::= table_name NK_DOT column_name */
  {  227,   -2 }, /* (235) pseudo_column ::= NK_UNDERLINE ROWTS */
  {  227,   -1 }, /* (236) pseudo_column ::= TBNAME */
  {  227,   -2 }, /* (237) pseudo_column ::= NK_UNDERLINE QSTARTTS */
  {  227,   -2 }, /* (238) pseudo_column ::= NK_UNDERLINE QENDTS */
  {  227,   -2 }, /* (239) pseudo_column ::= NK_UNDERLINE WSTARTTS */
  {  227,   -2 }, /* (240) pseudo_column ::= NK_UNDERLINE WENDTS */
  {  227,   -2 }, /* (241) pseudo_column ::= NK_UNDERLINE WDURATION */
  {  230,   -3 }, /* (242) predicate ::= expression compare_op expression */
  {  230,   -5 }, /* (243) predicate ::= expression BETWEEN expression AND expression */
  {  230,   -6 }, /* (244) predicate ::= expression NOT BETWEEN expression AND expression */
  {  230,   -3 }, /* (245) predicate ::= expression IS NULL */
  {  230,   -4 }, /* (246) predicate ::= expression IS NOT NULL */
  {  230,   -3 }, /* (247) predicate ::= expression in_op in_predicate_value */
  {  231,   -1 }, /* (248) compare_op ::= NK_LT */
  {  231,   -1 }, /* (249) compare_op ::= NK_GT */
  {  231,   -1 }, /* (250) compare_op ::= NK_LE */
  {  231,   -1 }, /* (251) compare_op ::= NK_GE */
  {  231,   -1 }, /* (252) compare_op ::= NK_NE */
  {  231,   -1 }, /* (253) compare_op ::= NK_EQ */
  {  231,   -1 }, /* (254) compare_op ::= LIKE */
  {  231,   -2 }, /* (255) compare_op ::= NOT LIKE */
  {  231,   -1 }, /* (256) compare_op ::= MATCH */
  {  231,   -1 }, /* (257) compare_op ::= NMATCH */
  {  232,   -1 }, /* (258) in_op ::= IN */
  {  232,   -2 }, /* (259) in_op ::= NOT IN */
  {  233,   -3 }, /* (260) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  234,   -1 }, /* (261) boolean_value_expression ::= boolean_primary */
  {  234,   -2 }, /* (262) boolean_value_expression ::= NOT boolean_primary */
  {  234,   -3 }, /* (263) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  234,   -3 }, /* (264) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  235,   -1 }, /* (265) boolean_primary ::= predicate */
  {  235,   -3 }, /* (266) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  236,   -1 }, /* (267) common_expression ::= expression */
  {  236,   -1 }, /* (268) common_expression ::= boolean_value_expression */
  {  237,   -2 }, /* (269) from_clause ::= FROM table_reference_list */
  {  238,   -1 }, /* (270) table_reference_list ::= table_reference */
  {  238,   -3 }, /* (271) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  239,   -1 }, /* (272) table_reference ::= table_primary */
  {  239,   -1 }, /* (273) table_reference ::= joined_table */
  {  240,   -2 }, /* (274) table_primary ::= table_name alias_opt */
  {  240,   -4 }, /* (275) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  240,   -2 }, /* (276) table_primary ::= subquery alias_opt */
  {  240,   -1 }, /* (277) table_primary ::= parenthesized_joined_table */
  {  242,    0 }, /* (278) alias_opt ::= */
  {  242,   -1 }, /* (279) alias_opt ::= table_alias */
  {  242,   -2 }, /* (280) alias_opt ::= AS table_alias */
  {  243,   -3 }, /* (281) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  243,   -3 }, /* (282) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  241,   -6 }, /* (283) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  244,    0 }, /* (284) join_type ::= */
  {  244,   -1 }, /* (285) join_type ::= INNER */
  {  246,   -9 }, /* (286) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  247,    0 }, /* (287) set_quantifier_opt ::= */
  {  247,   -1 }, /* (288) set_quantifier_opt ::= DISTINCT */
  {  247,   -1 }, /* (289) set_quantifier_opt ::= ALL */
  {  248,   -1 }, /* (290) select_list ::= NK_STAR */
  {  248,   -1 }, /* (291) select_list ::= select_sublist */
  {  254,   -1 }, /* (292) select_sublist ::= select_item */
  {  254,   -3 }, /* (293) select_sublist ::= select_sublist NK_COMMA select_item */
  {  255,   -1 }, /* (294) select_item ::= common_expression */
  {  255,   -2 }, /* (295) select_item ::= common_expression column_alias */
  {  255,   -3 }, /* (296) select_item ::= common_expression AS column_alias */
  {  255,   -3 }, /* (297) select_item ::= table_name NK_DOT NK_STAR */
  {  249,    0 }, /* (298) where_clause_opt ::= */
  {  249,   -2 }, /* (299) where_clause_opt ::= WHERE search_condition */
  {  250,    0 }, /* (300) partition_by_clause_opt ::= */
  {  250,   -3 }, /* (301) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  251,    0 }, /* (302) twindow_clause_opt ::= */
  {  251,   -6 }, /* (303) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  251,   -4 }, /* (304) twindow_clause_opt ::= STATE_WINDOW NK_LP column_reference NK_RP */
  {  251,   -6 }, /* (305) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  251,   -8 }, /* (306) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  217,    0 }, /* (307) sliding_opt ::= */
  {  217,   -4 }, /* (308) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  256,    0 }, /* (309) fill_opt ::= */
  {  256,   -4 }, /* (310) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  256,   -6 }, /* (311) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  257,   -1 }, /* (312) fill_mode ::= NONE */
  {  257,   -1 }, /* (313) fill_mode ::= PREV */
  {  257,   -1 }, /* (314) fill_mode ::= NULL */
  {  257,   -1 }, /* (315) fill_mode ::= LINEAR */
  {  257,   -1 }, /* (316) fill_mode ::= NEXT */
  {  252,    0 }, /* (317) group_by_clause_opt ::= */
  {  252,   -3 }, /* (318) group_by_clause_opt ::= GROUP BY group_by_list */
  {  258,   -1 }, /* (319) group_by_list ::= expression */
  {  258,   -3 }, /* (320) group_by_list ::= group_by_list NK_COMMA expression */
  {  253,    0 }, /* (321) having_clause_opt ::= */
  {  253,   -2 }, /* (322) having_clause_opt ::= HAVING search_condition */
  {  221,   -4 }, /* (323) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  259,   -1 }, /* (324) query_expression_body ::= query_primary */
  {  259,   -4 }, /* (325) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  263,   -1 }, /* (326) query_primary ::= query_specification */
  {  260,    0 }, /* (327) order_by_clause_opt ::= */
  {  260,   -3 }, /* (328) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  261,    0 }, /* (329) slimit_clause_opt ::= */
  {  261,   -2 }, /* (330) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  261,   -4 }, /* (331) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  261,   -4 }, /* (332) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  262,    0 }, /* (333) limit_clause_opt ::= */
  {  262,   -2 }, /* (334) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  262,   -4 }, /* (335) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  262,   -4 }, /* (336) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  229,   -3 }, /* (337) subquery ::= NK_LP query_expression NK_RP */
  {  245,   -1 }, /* (338) search_condition ::= common_expression */
  {  264,   -1 }, /* (339) sort_specification_list ::= sort_specification */
  {  264,   -3 }, /* (340) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  265,   -3 }, /* (341) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  266,    0 }, /* (342) ordering_specification_opt ::= */
  {  266,   -1 }, /* (343) ordering_specification_opt ::= ASC */
  {  266,   -1 }, /* (344) ordering_specification_opt ::= DESC */
  {  267,    0 }, /* (345) null_ordering_opt ::= */
  {  267,   -2 }, /* (346) null_ordering_opt ::= NULLS FIRST */
  {  267,   -2 }, /* (347) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,173,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,174,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,173,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,175,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,176,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,174,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,176,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,175,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy225, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy225, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 28: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy225, NULL); }
        break;
      case 29: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy0); }
        break;
      case 30: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 31: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 32: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 33: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 34: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 35: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 36: /* dnode_endpoint ::= NK_STRING */
      case 37: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==37);
      case 38: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==38);
      case 208: /* db_name ::= NK_ID */ yytestcase(yyruleno==208);
      case 209: /* table_name ::= NK_ID */ yytestcase(yyruleno==209);
      case 210: /* column_name ::= NK_ID */ yytestcase(yyruleno==210);
      case 211: /* function_name ::= NK_ID */ yytestcase(yyruleno==211);
      case 212: /* table_alias ::= NK_ID */ yytestcase(yyruleno==212);
      case 213: /* column_alias ::= NK_ID */ yytestcase(yyruleno==213);
      case 214: /* user_name ::= NK_ID */ yytestcase(yyruleno==214);
      case 215: /* index_name ::= NK_ID */ yytestcase(yyruleno==215);
      case 216: /* topic_name ::= NK_ID */ yytestcase(yyruleno==216);
{ yylhsminor.yy225 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy225 = yylhsminor.yy225;
        break;
      case 39: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 40: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateQnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 42: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropQnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy505, &yymsp[-1].minor.yy225, yymsp[0].minor.yy176); }
        break;
      case 44: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy505, &yymsp[0].minor.yy225); }
        break;
      case 45: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy225); }
        break;
      case 46: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy225, yymsp[0].minor.yy176); }
        break;
      case 47: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy505 = true; }
        break;
      case 48: /* not_exists_opt ::= */
      case 50: /* exists_opt ::= */ yytestcase(yyruleno==50);
      case 287: /* set_quantifier_opt ::= */ yytestcase(yyruleno==287);
{ yymsp[1].minor.yy505 = false; }
        break;
      case 49: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy505 = true; }
        break;
      case 51: /* db_options ::= */
{ yymsp[1].minor.yy176 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 52: /* db_options ::= db_options BLOCKS NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_BLOCKS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 53: /* db_options ::= db_options CACHE NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_CACHE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 54: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 55: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 56: /* db_options ::= db_options DAYS NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 57: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 58: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 59: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 60: /* db_options ::= db_options KEEP NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_KEEP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 61: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 62: /* db_options ::= db_options QUORUM NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_QUORUM, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 63: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 64: /* db_options ::= db_options TTL NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 65: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 66: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 67: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 68: /* db_options ::= db_options STREAM_MODE NK_INTEGER */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_STREAM_MODE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 69: /* db_options ::= db_options RETENTIONS NK_STRING */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-2].minor.yy176, DB_OPTION_RETENTIONS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 70: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy176 = createDefaultAlterDatabaseOptions(pCxt); yylhsminor.yy176 = setDatabaseOption(pCxt, yylhsminor.yy176, yymsp[0].minor.yy325.type, &yymsp[0].minor.yy325.val); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 71: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy176 = setDatabaseOption(pCxt, yymsp[-1].minor.yy176, yymsp[0].minor.yy325.type, &yymsp[0].minor.yy325.val); }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 72: /* alter_db_option ::= BLOCKS NK_INTEGER */
{ yymsp[-1].minor.yy325.type = DB_OPTION_BLOCKS; yymsp[-1].minor.yy325.val = yymsp[0].minor.yy0; }
        break;
      case 73: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy325.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy325.val = yymsp[0].minor.yy0; }
        break;
      case 74: /* alter_db_option ::= KEEP NK_INTEGER */
{ yymsp[-1].minor.yy325.type = DB_OPTION_KEEP; yymsp[-1].minor.yy325.val = yymsp[0].minor.yy0; }
        break;
      case 75: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy325.type = DB_OPTION_WAL; yymsp[-1].minor.yy325.val = yymsp[0].minor.yy0; }
        break;
      case 76: /* alter_db_option ::= QUORUM NK_INTEGER */
{ yymsp[-1].minor.yy325.type = DB_OPTION_QUORUM; yymsp[-1].minor.yy325.val = yymsp[0].minor.yy0; }
        break;
      case 77: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy325.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy325.val = yymsp[0].minor.yy0; }
        break;
      case 78: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 80: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==80);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy505, yymsp[-5].minor.yy176, yymsp[-3].minor.yy512, yymsp[-1].minor.yy512, yymsp[0].minor.yy176); }
        break;
      case 79: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy512); }
        break;
      case 81: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy512); }
        break;
      case 82: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy505, yymsp[0].minor.yy176); }
        break;
      case 83: /* cmd ::= ALTER TABLE alter_table_clause */
      case 84: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==84);
      case 185: /* cmd ::= query_expression */ yytestcase(yyruleno==185);
{ pCxt->pRootNode = yymsp[0].minor.yy176; }
        break;
      case 85: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy176 = createAlterTableOption(pCxt, yymsp[-1].minor.yy176, yymsp[0].minor.yy176); }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 86: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy176 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy176, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy176 = yylhsminor.yy176;
        break;
      case 87: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy176 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy176, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy225); }
  yymsp[-3].minor.yy176 = yylhsminor.yy176;
        break;
      case 88: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy176 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy176, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy176 = yylhsminor.yy176;
        break;
      case 89: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy176 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy176, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-4].minor.yy176 = yylhsminor.yy176;
        break;
      case 90: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy176 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy176, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy176 = yylhsminor.yy176;
        break;
      case 91: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy176 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy176, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy225); }
  yymsp[-3].minor.yy176 = yylhsminor.yy176;
        break;
      case 92: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy176 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy176, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy176 = yylhsminor.yy176;
        break;
      case 93: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy176 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy176, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-4].minor.yy176 = yylhsminor.yy176;
        break;
      case 94: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
{ yylhsminor.yy176 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy176, &yymsp[-2].minor.yy225, yymsp[0].minor.yy176); }
  yymsp[-5].minor.yy176 = yylhsminor.yy176;
        break;
      case 95: /* multi_create_clause ::= create_subtable_clause */
      case 98: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==98);
      case 105: /* column_def_list ::= column_def */ yytestcase(yyruleno==105);
      case 148: /* col_name_list ::= col_name */ yytestcase(yyruleno==148);
      case 170: /* func_name_list ::= func_name */ yytestcase(yyruleno==170);
      case 179: /* func_list ::= func */ yytestcase(yyruleno==179);
      case 206: /* literal_list ::= signed_literal */ yytestcase(yyruleno==206);
      case 292: /* select_sublist ::= select_item */ yytestcase(yyruleno==292);
      case 339: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==339);
{ yylhsminor.yy512 = createNodeList(pCxt, yymsp[0].minor.yy176); }
  yymsp[0].minor.yy512 = yylhsminor.yy512;
        break;
      case 96: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 99: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==99);
{ yylhsminor.yy512 = addNodeToList(pCxt, yymsp[-1].minor.yy512, yymsp[0].minor.yy176); }
  yymsp[-1].minor.yy512 = yylhsminor.yy512;
        break;
      case 97: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
{ yylhsminor.yy176 = createCreateSubTableClause(pCxt, yymsp[-8].minor.yy505, yymsp[-7].minor.yy176, yymsp[-5].minor.yy176, yymsp[-4].minor.yy512, yymsp[-1].minor.yy512); }
  yymsp[-8].minor.yy176 = yylhsminor.yy176;
        break;
      case 100: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy176 = createDropTableClause(pCxt, yymsp[-1].minor.yy505, yymsp[0].minor.yy176); }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 101: /* specific_tags_opt ::= */
      case 132: /* tags_def_opt ::= */ yytestcase(yyruleno==132);
      case 300: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==300);
      case 317: /* group_by_clause_opt ::= */ yytestcase(yyruleno==317);
      case 327: /* order_by_clause_opt ::= */ yytestcase(yyruleno==327);
{ yymsp[1].minor.yy512 = NULL; }
        break;
      case 102: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy512 = yymsp[-1].minor.yy512; }
        break;
      case 103: /* full_table_name ::= table_name */
{ yylhsminor.yy176 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy225, NULL); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 104: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy176 = createRealTableNode(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225, NULL); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 106: /* column_def_list ::= column_def_list NK_COMMA column_def */
      case 149: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==149);
      case 171: /* func_name_list ::= func_name_list NK_COMMA col_name */ yytestcase(yyruleno==171);
      case 180: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==180);
      case 207: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==207);
      case 293: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==293);
      case 340: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==340);
{ yylhsminor.yy512 = addNodeToList(pCxt, yymsp[-2].minor.yy512, yymsp[0].minor.yy176); }
  yymsp[-2].minor.yy512 = yylhsminor.yy512;
        break;
      case 107: /* column_def ::= column_name type_name */
{ yylhsminor.yy176 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy225, yymsp[0].minor.yy448, NULL); }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 108: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy176 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy225, yymsp[-2].minor.yy448, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy176 = yylhsminor.yy176;
        break;
      case 109: /* type_name ::= BOOL */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 110: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 111: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 112: /* type_name ::= INT */
      case 113: /* type_name ::= INTEGER */ yytestcase(yyruleno==113);
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 114: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 115: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 116: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 117: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 118: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 119: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 120: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 121: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 122: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 123: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 124: /* type_name ::= JSON */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 125: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 126: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 127: /* type_name ::= BLOB */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 128: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 129: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 130: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 131: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy448 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 133: /* tags_def_opt ::= tags_def */
      case 291: /* select_list ::= select_sublist */ yytestcase(yyruleno==291);
{ yylhsminor.yy512 = yymsp[0].minor.yy512; }
  yymsp[0].minor.yy512 = yylhsminor.yy512;
        break;
      case 134: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy512 = yymsp[-1].minor.yy512; }
        break;
      case 135: /* table_options ::= */
{ yymsp[1].minor.yy176 = createDefaultTableOptions(pCxt); }
        break;
      case 136: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy176 = setTableOption(pCxt, yymsp[-2].minor.yy176, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 137: /* table_options ::= table_options KEEP NK_INTEGER */
{ yylhsminor.yy176 = setTableOption(pCxt, yymsp[-2].minor.yy176, TABLE_OPTION_KEEP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 138: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy176 = setTableOption(pCxt, yymsp[-2].minor.yy176, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 139: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy176 = setTableSmaOption(pCxt, yymsp[-4].minor.yy176, yymsp[-1].minor.yy512); }
  yymsp[-4].minor.yy176 = yylhsminor.yy176;
        break;
      case 140: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ yylhsminor.yy176 = setTableRollupOption(pCxt, yymsp[-4].minor.yy176, yymsp[-1].minor.yy512); }
  yymsp[-4].minor.yy176 = yylhsminor.yy176;
        break;
      case 141: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ yylhsminor.yy176 = setTableOption(pCxt, yymsp[-2].minor.yy176, TABLE_OPTION_FILE_FACTOR, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 142: /* table_options ::= table_options DELAY NK_INTEGER */
{ yylhsminor.yy176 = setTableOption(pCxt, yymsp[-2].minor.yy176, TABLE_OPTION_DELAY, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 143: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy176 = createDefaultAlterTableOptions(pCxt); yylhsminor.yy176 = setTableOption(pCxt, yylhsminor.yy176, yymsp[0].minor.yy325.type, &yymsp[0].minor.yy325.val); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 144: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy176 = setTableOption(pCxt, yymsp[-1].minor.yy176, yymsp[0].minor.yy325.type, &yymsp[0].minor.yy325.val); }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 145: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy325.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy325.val = yymsp[0].minor.yy0; }
        break;
      case 146: /* alter_table_option ::= KEEP NK_INTEGER */
{ yymsp[-1].minor.yy325.type = TABLE_OPTION_KEEP; yymsp[-1].minor.yy325.val = yymsp[0].minor.yy0; }
        break;
      case 147: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy325.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy325.val = yymsp[0].minor.yy0; }
        break;
      case 150: /* col_name ::= column_name */
{ yylhsminor.yy176 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy225); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 151: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 152: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 153: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 154: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy176, yymsp[0].minor.yy176); }
        break;
      case 155: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy176, yymsp[0].minor.yy176); }
        break;
      case 156: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy176, NULL); }
        break;
      case 157: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 158: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 159: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 160: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 161: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy176, yymsp[0].minor.yy176); }
        break;
      case 162: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 163: /* db_name_cond_opt ::= */
      case 168: /* from_db_opt ::= */ yytestcase(yyruleno==168);
{ yymsp[1].minor.yy176 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 164: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy225); }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 165: /* like_pattern_opt ::= */
      case 176: /* index_options ::= */ yytestcase(yyruleno==176);
      case 298: /* where_clause_opt ::= */ yytestcase(yyruleno==298);
      case 302: /* twindow_clause_opt ::= */ yytestcase(yyruleno==302);
      case 307: /* sliding_opt ::= */ yytestcase(yyruleno==307);
      case 309: /* fill_opt ::= */ yytestcase(yyruleno==309);
      case 321: /* having_clause_opt ::= */ yytestcase(yyruleno==321);
      case 329: /* slimit_clause_opt ::= */ yytestcase(yyruleno==329);
      case 333: /* limit_clause_opt ::= */ yytestcase(yyruleno==333);
{ yymsp[1].minor.yy176 = NULL; }
        break;
      case 166: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 167: /* table_name_cond ::= table_name */
{ yylhsminor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy225); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 169: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy225); }
        break;
      case 172: /* func_name ::= function_name */
{ yylhsminor.yy176 = createFunctionNode(pCxt, &yymsp[0].minor.yy225, NULL); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 173: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy505, &yymsp[-3].minor.yy225, &yymsp[-1].minor.yy225, NULL, yymsp[0].minor.yy176); }
        break;
      case 174: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy505, &yymsp[-5].minor.yy225, &yymsp[-3].minor.yy225, yymsp[-1].minor.yy512, NULL); }
        break;
      case 175: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy505, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225); }
        break;
      case 177: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy176 = createIndexOption(pCxt, yymsp[-6].minor.yy512, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), NULL, yymsp[0].minor.yy176); }
        break;
      case 178: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy176 = createIndexOption(pCxt, yymsp[-8].minor.yy512, releaseRawExprNode(pCxt, yymsp[-4].minor.yy176), releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), yymsp[0].minor.yy176); }
        break;
      case 181: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy176 = createFunctionNode(pCxt, &yymsp[-3].minor.yy225, yymsp[-1].minor.yy512); }
  yymsp[-3].minor.yy176 = yylhsminor.yy176;
        break;
      case 182: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy505, &yymsp[-2].minor.yy225, yymsp[0].minor.yy176, NULL); }
        break;
      case 183: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy505, &yymsp[-2].minor.yy225, NULL, &yymsp[0].minor.yy225); }
        break;
      case 184: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy505, &yymsp[0].minor.yy225); }
        break;
      case 186: /* literal ::= NK_INTEGER */
{ yylhsminor.yy176 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 187: /* literal ::= NK_FLOAT */
{ yylhsminor.yy176 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 188: /* literal ::= NK_STRING */
{ yylhsminor.yy176 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 189: /* literal ::= NK_BOOL */
{ yylhsminor.yy176 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 190: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy176 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 191: /* literal ::= duration_literal */
      case 200: /* signed_literal ::= signed */ yytestcase(yyruleno==200);
      case 217: /* expression ::= literal */ yytestcase(yyruleno==217);
      case 218: /* expression ::= pseudo_column */ yytestcase(yyruleno==218);
      case 219: /* expression ::= column_reference */ yytestcase(yyruleno==219);
      case 222: /* expression ::= subquery */ yytestcase(yyruleno==222);
      case 261: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==261);
      case 265: /* boolean_primary ::= predicate */ yytestcase(yyruleno==265);
      case 267: /* common_expression ::= expression */ yytestcase(yyruleno==267);
      case 268: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==268);
      case 270: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==270);
      case 272: /* table_reference ::= table_primary */ yytestcase(yyruleno==272);
      case 273: /* table_reference ::= joined_table */ yytestcase(yyruleno==273);
      case 277: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==277);
      case 324: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==324);
      case 326: /* query_primary ::= query_specification */ yytestcase(yyruleno==326);
{ yylhsminor.yy176 = yymsp[0].minor.yy176; }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 192: /* literal ::= NULL */
{ yylhsminor.yy176 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL)); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 193: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy176 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 194: /* signed ::= NK_INTEGER */
{ yylhsminor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 195: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 196: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 197: /* signed ::= NK_FLOAT */
{ yylhsminor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 198: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 199: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 201: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 202: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 203: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 204: /* signed_literal ::= duration_literal */
      case 338: /* search_condition ::= common_expression */ yytestcase(yyruleno==338);
{ yylhsminor.yy176 = releaseRawExprNode(pCxt, yymsp[0].minor.yy176); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 205: /* signed_literal ::= NULL */
{ yymsp[0].minor.yy176 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL); }
        break;
      case 220: /* expression ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy176 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy225, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy225, yymsp[-1].minor.yy512)); }
  yymsp[-3].minor.yy176 = yylhsminor.yy176;
        break;
      case 221: /* expression ::= function_name NK_LP NK_STAR NK_RP */
{ yylhsminor.yy176 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy225, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy225, createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy0)))); }
  yymsp[-3].minor.yy176 = yylhsminor.yy176;
        break;
      case 223: /* expression ::= NK_LP expression NK_RP */
      case 266: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==266);
{ yylhsminor.yy176 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy176)); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 224: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy176));
                                                                                  }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 225: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[0].minor.yy176), NULL));
                                                                                  }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 226: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy176);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), releaseRawExprNode(pCxt, yymsp[0].minor.yy176))); 
                                                                                  }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 227: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy176);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), releaseRawExprNode(pCxt, yymsp[0].minor.yy176))); 
                                                                                  }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 228: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy176);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), releaseRawExprNode(pCxt, yymsp[0].minor.yy176))); 
                                                                                  }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 229: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy176);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), releaseRawExprNode(pCxt, yymsp[0].minor.yy176))); 
                                                                                  }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 230: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy176);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), releaseRawExprNode(pCxt, yymsp[0].minor.yy176))); 
                                                                                  }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 231: /* expression_list ::= expression */
{ yylhsminor.yy512 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy176)); }
  yymsp[0].minor.yy512 = yylhsminor.yy512;
        break;
      case 232: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy512 = addNodeToList(pCxt, yymsp[-2].minor.yy512, releaseRawExprNode(pCxt, yymsp[0].minor.yy176)); }
  yymsp[-2].minor.yy512 = yylhsminor.yy512;
        break;
      case 233: /* column_reference ::= column_name */
{ yylhsminor.yy176 = createRawExprNode(pCxt, &yymsp[0].minor.yy225, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy225)); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 234: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy176 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225, createColumnNode(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy225)); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 235: /* pseudo_column ::= NK_UNDERLINE ROWTS */
      case 237: /* pseudo_column ::= NK_UNDERLINE QSTARTTS */ yytestcase(yyruleno==237);
      case 238: /* pseudo_column ::= NK_UNDERLINE QENDTS */ yytestcase(yyruleno==238);
      case 239: /* pseudo_column ::= NK_UNDERLINE WSTARTTS */ yytestcase(yyruleno==239);
      case 240: /* pseudo_column ::= NK_UNDERLINE WENDTS */ yytestcase(yyruleno==240);
      case 241: /* pseudo_column ::= NK_UNDERLINE WDURATION */ yytestcase(yyruleno==241);
{
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy176 = createRawExprNode(pCxt, &t, createFunctionNode(pCxt, &t, NULL));
                                                                                  }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 236: /* pseudo_column ::= TBNAME */
{ yylhsminor.yy176 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 242: /* predicate ::= expression compare_op expression */
      case 247: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==247);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy176);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy404, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), releaseRawExprNode(pCxt, yymsp[0].minor.yy176)));
                                                                                  }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 243: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy176);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy176), releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), releaseRawExprNode(pCxt, yymsp[0].minor.yy176)));
                                                                                  }
  yymsp[-4].minor.yy176 = yylhsminor.yy176;
        break;
      case 244: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy176);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), releaseRawExprNode(pCxt, yymsp[-5].minor.yy176), releaseRawExprNode(pCxt, yymsp[0].minor.yy176)));
                                                                                  }
  yymsp[-5].minor.yy176 = yylhsminor.yy176;
        break;
      case 245: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), NULL));
                                                                                  }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 246: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy176), NULL));
                                                                                  }
  yymsp[-3].minor.yy176 = yylhsminor.yy176;
        break;
      case 248: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy404 = OP_TYPE_LOWER_THAN; }
        break;
      case 249: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy404 = OP_TYPE_GREATER_THAN; }
        break;
      case 250: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy404 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 251: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy404 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 252: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy404 = OP_TYPE_NOT_EQUAL; }
        break;
      case 253: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy404 = OP_TYPE_EQUAL; }
        break;
      case 254: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy404 = OP_TYPE_LIKE; }
        break;
      case 255: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy404 = OP_TYPE_NOT_LIKE; }
        break;
      case 256: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy404 = OP_TYPE_MATCH; }
        break;
      case 257: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy404 = OP_TYPE_NMATCH; }
        break;
      case 258: /* in_op ::= IN */
{ yymsp[0].minor.yy404 = OP_TYPE_IN; }
        break;
      case 259: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy404 = OP_TYPE_NOT_IN; }
        break;
      case 260: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy176 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy512)); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 262: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy176), NULL));
                                                                                  }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 263: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy176);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), releaseRawExprNode(pCxt, yymsp[0].minor.yy176)));
                                                                                  }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 264: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy176);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), releaseRawExprNode(pCxt, yymsp[0].minor.yy176)));
                                                                                  }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 269: /* from_clause ::= FROM table_reference_list */
      case 299: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==299);
      case 322: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==322);
{ yymsp[-1].minor.yy176 = yymsp[0].minor.yy176; }
        break;
      case 271: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy176 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy176, yymsp[0].minor.yy176, NULL); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 274: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy176 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 275: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy176 = createRealTableNode(pCxt, &yymsp[-3].minor.yy225, &yymsp[-1].minor.yy225, &yymsp[0].minor.yy225); }
  yymsp[-3].minor.yy176 = yylhsminor.yy176;
        break;
      case 276: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy176 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy176), &yymsp[0].minor.yy225); }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 278: /* alias_opt ::= */
{ yymsp[1].minor.yy225 = nil_token;  }
        break;
      case 279: /* alias_opt ::= table_alias */
{ yylhsminor.yy225 = yymsp[0].minor.yy225; }
  yymsp[0].minor.yy225 = yylhsminor.yy225;
        break;
      case 280: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy225 = yymsp[0].minor.yy225; }
        break;
      case 281: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 282: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==282);
{ yymsp[-2].minor.yy176 = yymsp[-1].minor.yy176; }
        break;
      case 283: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy176 = createJoinTableNode(pCxt, yymsp[-4].minor.yy236, yymsp[-5].minor.yy176, yymsp[-2].minor.yy176, yymsp[0].minor.yy176); }
  yymsp[-5].minor.yy176 = yylhsminor.yy176;
        break;
      case 284: /* join_type ::= */
{ yymsp[1].minor.yy236 = JOIN_TYPE_INNER; }
        break;
      case 285: /* join_type ::= INNER */
{ yymsp[0].minor.yy236 = JOIN_TYPE_INNER; }
        break;
      case 286: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy176 = createSelectStmt(pCxt, yymsp[-7].minor.yy505, yymsp[-6].minor.yy512, yymsp[-5].minor.yy176);
                                                                                    yymsp[-8].minor.yy176 = addWhereClause(pCxt, yymsp[-8].minor.yy176, yymsp[-4].minor.yy176);
                                                                                    yymsp[-8].minor.yy176 = addPartitionByClause(pCxt, yymsp[-8].minor.yy176, yymsp[-3].minor.yy512);
                                                                                    yymsp[-8].minor.yy176 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy176, yymsp[-2].minor.yy176);
                                                                                    yymsp[-8].minor.yy176 = addGroupByClause(pCxt, yymsp[-8].minor.yy176, yymsp[-1].minor.yy512);
                                                                                    yymsp[-8].minor.yy176 = addHavingClause(pCxt, yymsp[-8].minor.yy176, yymsp[0].minor.yy176);
                                                                                  }
        break;
      case 288: /* set_quantifier_opt ::= DISTINCT */
{ yymsp[0].minor.yy505 = true; }
        break;
      case 289: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy505 = false; }
        break;
      case 290: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy512 = NULL; }
        break;
      case 294: /* select_item ::= common_expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy176);
                                                                                    yylhsminor.yy176 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy176), &t);
                                                                                  }
  yymsp[0].minor.yy176 = yylhsminor.yy176;
        break;
      case 295: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy176 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy176), &yymsp[0].minor.yy225); }
  yymsp[-1].minor.yy176 = yylhsminor.yy176;
        break;
      case 296: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy176 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), &yymsp[0].minor.yy225); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 297: /* select_item ::= table_name NK_DOT NK_STAR */
{ yylhsminor.yy176 = createColumnNode(pCxt, &yymsp[-2].minor.yy225, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 301: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 318: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==318);
      case 328: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==328);
{ yymsp[-2].minor.yy512 = yymsp[0].minor.yy512; }
        break;
      case 303: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy176 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy176), releaseRawExprNode(pCxt, yymsp[-1].minor.yy176)); }
        break;
      case 304: /* twindow_clause_opt ::= STATE_WINDOW NK_LP column_reference NK_RP */
{ yymsp[-3].minor.yy176 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy176)); }
        break;
      case 305: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy176 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy176), NULL, yymsp[-1].minor.yy176, yymsp[0].minor.yy176); }
        break;
      case 306: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy176 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy176), releaseRawExprNode(pCxt, yymsp[-3].minor.yy176), yymsp[-1].minor.yy176, yymsp[0].minor.yy176); }
        break;
      case 308: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy176 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy176); }
        break;
      case 310: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy176 = createFillNode(pCxt, yymsp[-1].minor.yy142, NULL); }
        break;
      case 311: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy176 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy512)); }
        break;
      case 312: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy142 = FILL_MODE_NONE; }
        break;
      case 313: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy142 = FILL_MODE_PREV; }
        break;
      case 314: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy142 = FILL_MODE_NULL; }
        break;
      case 315: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy142 = FILL_MODE_LINEAR; }
        break;
      case 316: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy142 = FILL_MODE_NEXT; }
        break;
      case 319: /* group_by_list ::= expression */
{ yylhsminor.yy512 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy176))); }
  yymsp[0].minor.yy512 = yylhsminor.yy512;
        break;
      case 320: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy512 = addNodeToList(pCxt, yymsp[-2].minor.yy512, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy176))); }
  yymsp[-2].minor.yy512 = yylhsminor.yy512;
        break;
      case 323: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy176 = addOrderByClause(pCxt, yymsp[-3].minor.yy176, yymsp[-2].minor.yy512);
                                                                                    yylhsminor.yy176 = addSlimitClause(pCxt, yylhsminor.yy176, yymsp[-1].minor.yy176);
                                                                                    yylhsminor.yy176 = addLimitClause(pCxt, yylhsminor.yy176, yymsp[0].minor.yy176);
                                                                                  }
  yymsp[-3].minor.yy176 = yylhsminor.yy176;
        break;
      case 325: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy176 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy176, yymsp[0].minor.yy176); }
  yymsp[-3].minor.yy176 = yylhsminor.yy176;
        break;
      case 330: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 334: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==334);
{ yymsp[-1].minor.yy176 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 331: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 335: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==335);
{ yymsp[-3].minor.yy176 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 332: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 336: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==336);
{ yymsp[-3].minor.yy176 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 337: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy176 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy176); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 341: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy176 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy176), yymsp[-1].minor.yy106, yymsp[0].minor.yy465); }
  yymsp[-2].minor.yy176 = yylhsminor.yy176;
        break;
      case 342: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy106 = ORDER_ASC; }
        break;
      case 343: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy106 = ORDER_ASC; }
        break;
      case 344: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy106 = ORDER_DESC; }
        break;
      case 345: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy465 = NULL_ORDER_DEFAULT; }
        break;
      case 346: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy465 = NULL_ORDER_FIRST; }
        break;
      case 347: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy465 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (pCxt->valid) {
    if(TOKEN.z) {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
    pCxt->valid = false;
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
