/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 473
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOperatorType yy62;
  SToken yy63;
  EOrder yy158;
  SNodeList* yy222;
  SAlterOption yy233;
  int32_t yy332;
  int64_t yy393;
  EJoinType yy574;
  bool yy669;
  ENullOrder yy675;
  SDataType yy686;
  int8_t yy707;
  EFillMode yy822;
  SNode* yy828;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             754
#define YYNRULE              574
#define YYNTOKEN             329
#define YY_MAX_SHIFT         753
#define YY_MIN_SHIFTREDUCE   1121
#define YY_MAX_SHIFTREDUCE   1694
#define YY_ERROR_ACTION      1695
#define YY_ACCEPT_ACTION     1696
#define YY_NO_ACTION         1697
#define YY_MIN_REDUCE        1698
#define YY_MAX_REDUCE        2271
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2833)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  2069, 2247, 1980,  166, 2083, 2242,  491, 2101,  492, 1734,
 /*    10 */  1806, 2065,   45,   43, 1622,  600, 1980, 1978,  630, 2069,
 /*    20 */   385, 2246, 1471,  618, 1496, 2243, 2245, 2083,  376, 2186,
 /*    30 */  2065, 1977,  630, 1552, 2019, 1469, 1837, 2101,   44,   42,
 /*    40 */    41,   40,   39,  430,  642,  621, 2061, 2067,  366, 1173,
 /*    50 */  2051, 1172,  659,  629,  643, 2183,  139,  653, 1547, 2247,
 /*    60 */  2101,  599, 1914, 2242,   18, 2061, 2067,  367,  660,  350,
 /*    70 */   132, 1477,  167, 2051, 1710,  659,  653,  530, 1912, 2246,
 /*    80 */  1174,  240, 2082, 2243, 2244,  333, 2118, 1861,  642,  109,
 /*    90 */  2084,  663, 2086, 2087,  658, 2069,  653,  750,   65,  697,
 /*   100 */    14,  179,  507, 2171, 1973, 2082, 2065,  379, 2167, 2118,
 /*   110 */    45,   43,  168, 2084,  663, 2086, 2087,  658,  385,  653,
 /*   120 */  1471,  184,  270, 2179,  617, 1721,  133,  616,   73, 2197,
 /*   130 */  2242, 1552, 1173, 1469, 1172,  390, 1554, 1555, 1907, 1909,
 /*   140 */   606, 2061, 2067,  380, 2242,  605,  182,  222,   35,  291,
 /*   150 */  2243,  607,  653,  582, 2208,  273, 1547, 1838,  628,  605,
 /*   160 */   182,  642,   18, 1174, 2243,  607, 1527, 1537,   48, 1477,
 /*   170 */  1764, 2051, 1553, 1556,   38,   37,  178,   81,   44,   42,
 /*   180 */    41,   40,   39,  546,  545,  544, 1472,  509, 1470, 1901,
 /*   190 */   536,  136,  540,  176,   61,  750,  539,   61,   14,   92,
 /*   200 */   497,  538,  543,   61,   38,   37,  493,  537,   44,   42,
 /*   210 */    41,   40,   39, 1475, 1476, 1964, 1526, 1529, 1530, 1531,
 /*   220 */  1532, 1533, 1534, 1535, 1536,  655,  651, 1545, 1546, 1548,
 /*   230 */  1549, 1550, 1551,    2, 1554, 1555,  727,  726,  725,  724,
 /*   240 */   395,   48,  723,  722,  143,  717,  716,  715,  714,  713,
 /*   250 */   712,  711,  156,  707,  706,  705,  394,  393,  702,  701,
 /*   260 */   700,  699,  698,  601, 1527, 1537,  596, 1661,  580,  695,
 /*   270 */  1553, 1556,  122, 1583, 1242,  121,  120,  119,  118,  117,
 /*   280 */   116,  115,  114,  113, 1472,  695, 1470,  154,  153,  692,
 /*   290 */   691,  690,  151,   38,   37,  697, 1154,   44,   42,   41,
 /*   300 */    40,   39, 1959,  154,  153,  692,  691,  690,  151, 1696,
 /*   310 */  1244, 1475, 1476,  190, 1526, 1529, 1530, 1531, 1532, 1533,
 /*   320 */  1534, 1535, 1536,  655,  651, 1545, 1546, 1548, 1549, 1550,
 /*   330 */  1551,    2,   11,   45,   43, 1156, 1839, 1159, 1160, 1496,
 /*   340 */    52,  385, 1299, 1471,  185,   32, 1959,  185, 1496,  345,
 /*   350 */   602,  597,  590,  185, 1552, 1588, 1469,  192, 1290,  685,
 /*   360 */   684,  683, 1294,  682, 1296, 1297,  681,  678,   86, 1305,
 /*   370 */   675, 1307, 1308,  672,  669, 1699,   31,  398, 2083, 1547,
 /*   380 */   147,  397,   38,   37,  354,   18,   44,   42,   41,   40,
 /*   390 */    39,  185, 1477, 1856, 1581,  500,  122,  492, 1734,  121,
 /*   400 */   120,  119,  118,  117,  116,  115,  114,  113,   38,   37,
 /*   410 */   629, 2101,   44,   42,   41,   40,   39,  377,  750,  657,
 /*   420 */  1499,   14,  468,  581, 2051,  164,  659, 2242,   61,  388,
 /*   430 */  1495,   45,   43, 1557, 1863,  282,  283,  161, 1959,  385,
 /*   440 */   281, 1471, 2248,  182,  364, 1497, 1863, 2243,  607,  196,
 /*   450 */  1582,  238, 1552, 1912, 1469,  237, 2082, 1554, 1555,  627,
 /*   460 */  2118, 1973,  569,  327, 2084,  663, 2086, 2087,  658,  656,
 /*   470 */   653,  644, 2136, 1698,   38,   37,   11, 1547,   44,   42,
 /*   480 */    41,   40,   39,  198,  197, 1388, 1389, 1527, 1537,  100,
 /*   490 */  1477, 1767,  490, 1553, 1556,  495, 1740,  131,  130,  129,
 /*   500 */   128,  127,  126,  125,  124,  123,  467, 1472,  499, 1470,
 /*   510 */    27,  495, 1740, 1854,   89,  340,  750,  424,  362,   46,
 /*   520 */   562,  423,   34,  383, 1576, 1577, 1578, 1579, 1580, 1584,
 /*   530 */  1585, 1586, 1587, 1720, 1475, 1476,  576, 1526, 1529, 1530,
 /*   540 */  1531, 1532, 1533, 1534, 1535, 1536,  655,  651, 1545, 1546,
 /*   550 */  1548, 1549, 1550, 1551,    2, 1554, 1555,  546,  545,  544,
 /*   560 */  1477, 1333, 1334,  581,  536,  136,  540, 2242,  250,   49,
 /*   570 */   539, 1908, 1909, 1852,  106,  538,  543,  709,  185, 2051,
 /*   580 */  2083,  537, 2248,  182, 2065, 1527, 1537, 2243,  607,   33,
 /*   590 */   140, 1553, 1556,   13,   12,   38,   37, 1836, 1853,   44,
 /*   600 */    42,   41,   40,   39,  688, 1472, 2247, 1470,  542,  541,
 /*   610 */    38,   37,  560, 2101,   44,   42,   41,   40,   39, 2061,
 /*   620 */  2067,  660,  618, 1498, 1944,  558, 2051,  556,  659,   11,
 /*   630 */   653,    9, 1475, 1476,   86, 1526, 1529, 1530, 1531, 1532,
 /*   640 */  1533, 1534, 1535, 1536,  655,  651, 1545, 1546, 1548, 1549,
 /*   650 */  1550, 1551,    2,   45,   43,  139,  248, 2083, 2082, 1857,
 /*   660 */  2070,  385, 2118, 1471,  643,  109, 2084,  663, 2086, 2087,
 /*   670 */   658, 2065,  653, 1497, 1552,  142, 1469,  149, 2142, 2171,
 /*   680 */   187,   38,   37,  379, 2167,   44,   42,   41,   40,   39,
 /*   690 */  2101, 1719,  176, 1595, 1498, 1914, 1754, 1861,  660, 1547,
 /*   700 */    90,  618,  363, 2051, 1684,  659, 2061, 2067, 1718,  695,
 /*   710 */   624, 1912, 1477,  352, 1963, 1650,  357,  653,  547,  185,
 /*   720 */   620,  180, 2179, 2180,  643,  137, 2184,  154,  153,  692,
 /*   730 */   691,  690,  151,  141,  139, 2082, 2142, 2051,  750, 2118,
 /*   740 */    54,   46,  169, 2084,  663, 2086, 2087,  658, 2246,  653,
 /*   750 */  1717,   45,   43,  643, 2051,  689,  581, 1861, 1905,  385,
 /*   760 */  2242, 1471,  593,  592, 1648, 1649, 1651, 1652, 1653,  428,
 /*   770 */   163,  272, 1552, 1850, 1469, 2248,  182, 1554, 1555,  448,
 /*   780 */  2243,  607,  358, 2186,  356,  355, 1861,  532,  447, 1405,
 /*   790 */  1406,  534,  629, 1846,  608, 2263, 2051, 1547, 1848, 2083,
 /*   800 */   181, 2179, 2180, 1716,  137, 2184, 1499, 1527, 1537, 2182,
 /*   810 */  1477, 1844,  533, 1553, 1556,  643,   38,   37, 2186,  643,
 /*   820 */    44,   42,   41,   40,   39, 1404, 1407, 1472,  687, 1470,
 /*   830 */  1914,  132, 2101, 1715, 2037,  429,  750,  373,  535,   14,
 /*   840 */   660,  638,  272, 1973, 2181, 2051, 1912,  659, 1861, 2051,
 /*   850 */  2044, 1691, 1861,  194, 1475, 1476, 1714, 1526, 1529, 1530,
 /*   860 */  1531, 1532, 1533, 1534, 1535, 1536,  655,  651, 1545, 1546,
 /*   870 */  1548, 1549, 1550, 1551,    2, 1554, 1555, 2082,  245, 2051,
 /*   880 */  2045, 2118,  405, 1914,  110, 2084,  663, 2086, 2087,  658,
 /*   890 */   378,  653,  693,  388,   83, 1905,  581,   82, 2171, 1912,
 /*   900 */  2242,  164, 2051, 2168,  606, 1527, 1537, 1496, 2242, 1638,
 /*   910 */  1863, 1553, 1556,  721,  719, 2248,  182,  417,   61,    8,
 /*   920 */  2243,  607, 1253,  605,  182, 1472,  581, 1470, 2243,  607,
 /*   930 */  2242, 1914,  645, 1626, 2143, 1252, 1562,  654,  389, 1496,
 /*   940 */   419,  415, 1496, 1159, 1160, 2248,  182, 1912, 1690,  610,
 /*   950 */  2243,  607, 1475, 1476,  191, 1526, 1529, 1530, 1531, 1532,
 /*   960 */  1533, 1534, 1535, 1536,  655,  651, 1545, 1546, 1548, 1549,
 /*   970 */  1550, 1551,    2, 1499,  336,  165, 1494,  643,  382,  381,
 /*   980 */   311,  567,  647,  461, 2143,  551,  475, 2083, 1485,  474,
 /*   990 */    41,   40,   39,  438,  309,   72, 1619,  477,   71, 1552,
 /*  1000 */   561, 1478, 1711,  422,  444,  421,  476, 2211,  694,  446,
 /*  1010 */  1861, 1905, 1471,  164,  236,  609,  205,  487,  485,  482,
 /*  1020 */  2101,  152, 1864,  618, 1547, 1469,  643,  581,  660,  554,
 /*  1030 */   420, 2242,  391, 2051,  548,  659, 1713, 1477,  643,  235,
 /*  1040 */   164,  534,  453, 1712, 2191, 1615, 2248,  182,  643, 1863,
 /*  1050 */  1914, 2243,  607, 1528,  454,  353,  139,   61,  710, 1861,
 /*  1060 */  1823, 1477,  533,  649,  508, 2082, 1913,  434,  185, 2118,
 /*  1070 */  1807, 1861,  109, 2084,  663, 2086, 2087,  658,   53,  653,
 /*  1080 */    69, 1861, 2051,   68, 2146, 1528, 2171,  750, 1528, 2051,
 /*  1090 */   379, 2167, 1709, 1708, 1480,  108,  472, 1707, 1747,  466,
 /*  1100 */   465,  464,  463,  460,  459,  458,  457,  456,  452,  451,
 /*  1110 */   450,  449,  335,  441,  440,  439,  643,  436,  435,  351,
 /*  1120 */   549,  249,  183, 2179, 2180,  613,  137, 2184,  643, 1615,
 /*  1130 */   305,  643, 1858, 1891,  152,   80,   79,  427, 2051, 2051,
 /*  1140 */   189, 2083,  643, 2051,  241,  239, 1257,  577,   51, 1861,
 /*  1150 */     3,  145, 1486,  134, 1481,  643, 1706,  643,  622, 1256,
 /*  1160 */   334, 1861, 1479,  413, 1861,  411,  407,  403,  400,  420,
 /*  1170 */  1705,  626, 2083,  286, 2101, 1861, 1472,  611, 1470, 1489,
 /*  1180 */  1491,  267,  621,  228,  643,  650,  226, 2051, 1861,  659,
 /*  1190 */  1861, 1440,  651, 1545, 1546, 1548, 1549, 1550, 1551,  643,
 /*  1200 */   640,  431, 2051, 1475, 1476, 2101, 1704,  185,  643,  643,
 /*  1210 */  1703, 1445, 1446,  660,  432,  641, 2051, 1861, 2051, 2082,
 /*  1220 */   659,  479, 2083, 2118,  292,  392,  109, 2084,  663, 2086,
 /*  1230 */  2087,  658, 1861,  653,  230, 1702, 1701,  229,  179, 2083,
 /*  1240 */  2171, 1861, 1861, 1618,  379, 2167,  232, 1483,  234,  231,
 /*  1250 */  2082,  233, 2051,  594, 2118, 2101, 2051,  109, 2084,  663,
 /*  1260 */  2086, 2087,  658,  660,  653,  152, 2198, 1745, 2051, 2262,
 /*  1270 */   659, 2171, 2101,   63,  221,  379, 2167,  564,   63,  563,
 /*  1280 */   660, 2051, 2051,  261,  254, 2051, 2205,  659,  105,  552,
 /*  1290 */  1693, 1694, 2102,  152,  396,   13,   12,   47,  102, 2083,
 /*  1300 */  2082,  279,   70, 2072, 2118,  150,  152,  168, 2084,  663,
 /*  1310 */  2086, 2087,  658,   63,  653, 1482, 1968, 2082, 1735, 2083,
 /*  1320 */  1902, 2118, 1443,   47,  109, 2084,  663, 2086, 2087,  658,
 /*  1330 */  1647,  653, 2101, 2201, 1573, 1646, 2262,  753, 2171,  703,
 /*  1340 */   660,  256,  379, 2167,  619, 2051, 1741,  659,  269, 2209,
 /*  1350 */   625,  298, 2101, 2218, 1402,  614, 2074,   47,  284,  635,
 /*  1360 */   660, 1222,  288, 1283,  667, 2051,  175,  659,  150,  152,
 /*  1370 */  1589,  704,  743,  739,  735,  731,  296, 2082,  266,  135,
 /*  1380 */  1538, 2118,  150, 1203,  109, 2084,  663, 2086, 2087,  658,
 /*  1390 */     1,  653,    4, 1220,  399,  745, 2262, 2082, 2171,  404,
 /*  1400 */   349, 2118,  379, 2167,  109, 2084,  663, 2086, 2087,  658,
 /*  1410 */  1425,  653,  299,  588,  304,  195, 2262,  107, 2171, 1204,
 /*  1420 */   289, 1311,  379, 2167,  433, 1315, 1322, 1499, 2083, 1969,
 /*  1430 */   437,  470,  442, 2236, 1494,  223, 1320,  455,  462,  155,
 /*  1440 */  1961,  469,  480,  471,  481,  478,  483,  200, 2083,  484,
 /*  1450 */   171,  199,  639,  202,  486,  488,  526,  522,  518,  514,
 /*  1460 */   220, 2101, 1500,  489, 1502,  498,  501, 1497,  208,  660,
 /*  1470 */  1501,  502,  210,  503, 2051, 1503,  659,  506,  504,  213,
 /*  1480 */   215, 2101, 1176,   84,   85,  510,  527,  276,  531,  660,
 /*  1490 */   529,  528,  275,  219, 2051,  111,  659, 2028, 2025,  339,
 /*  1500 */  1851,   87,  566, 2024,  218,   88, 2082,  571, 1432,  300,
 /*  1510 */  2118,  243,  568,  109, 2084,  663, 2086, 2087,  658,  148,
 /*  1520 */   653,  242, 2083,  225, 1847, 2262, 2082, 2171,  227,  157,
 /*  1530 */  2118,  379, 2167,  109, 2084,  663, 2086, 2087,  658,  158,
 /*  1540 */   653, 1849, 2190, 1845,  570, 2144, 2083, 2171,  159,  160,
 /*  1550 */   572,  379, 2167,  244,  246, 2101,  578, 2202, 2212,  585,
 /*  1560 */   575,  595,  633,  660, 2217,  252,  255,  591, 2051,  368,
 /*  1570 */   659,  217,  211,  598,    7,  604,  216,  586,  505, 2101,
 /*  1580 */   584, 2216,  583,  265,  615,  369, 1615,  660,  612, 2265,
 /*  1590 */   138,  262, 2051, 1498,  659,  209, 2083, 2193, 2187,  623,
 /*  1600 */  2082,  372,  172,  263, 2118, 1504,  260,  109, 2084,  663,
 /*  1610 */  2086, 2087,  658, 2083,  653,  274,  264,   95,  268,  646,
 /*  1620 */   301, 2171, 1974, 2241, 2082,  379, 2167,  636, 2118, 2101,
 /*  1630 */   631,  110, 2084,  663, 2086, 2087,  658,  660,  653,  302,
 /*  1640 */   637,  632, 2051, 1988,  659, 2171, 2101,   97, 1987, 2170,
 /*  1650 */  2167,  303, 1986,  375,  660, 1862,   60, 2152,   99, 2051,
 /*  1660 */   101,  659,  665, 1906,  746, 1824,  295,  306,  747,  310,
 /*  1670 */   749,  341,   50, 2083, 2082,  315, 2043,  308, 2118, 2042,
 /*  1680 */   342,  321, 2084,  663, 2086, 2087,  658,  329,  653,  330,
 /*  1690 */   319, 2082, 2041, 2083,   77, 2118, 2038,  401,  110, 2084,
 /*  1700 */   663, 2086, 2087,  658,  402,  653, 2101, 1462, 1463,  188,
 /*  1710 */   406, 2036, 2171,  408,  660,  409,  648, 2167,  410, 2051,
 /*  1720 */  2035,  659,  412, 2034,  414,  603, 2101, 2033,  416, 2032,
 /*  1730 */   418,   78, 1428, 1427,  660, 2000, 1999, 1998,  426, 2051,
 /*  1740 */   425,  659, 1997, 1996, 1379, 1952, 1951, 1949, 1948,  144,
 /*  1750 */  1947,  661, 1950, 1946, 1945, 2118, 2083, 1943,  110, 2084,
 /*  1760 */   663, 2086, 2087,  658, 1942,  653, 1941,  193,  443, 1940,
 /*  1770 */   445, 2082, 2171, 1954, 1939, 2118,  344, 2167,  169, 2084,
 /*  1780 */   663, 2086, 2087,  658, 1381,  653, 1938, 1937, 1936, 2101,
 /*  1790 */  1935, 1934, 1933, 1932,  374, 1931, 1930,  660, 1929, 1928,
 /*  1800 */  1927, 1926, 2051, 1925,  659,  146, 1924, 1923, 1922, 1953,
 /*  1810 */  1921, 1920, 1919, 1918, 2083, 1917,  473, 1916, 1915, 1254,
 /*  1820 */   337,  338, 1770,  201, 1258, 1769,  203, 1768,  204, 1250,
 /*  1830 */  1766, 2264, 1730,  177, 2082, 1162, 1729, 1161, 2118, 2083,
 /*  1840 */  2015,  328, 2084,  663, 2086, 2087,  658, 2101,  653, 2007,
 /*  1850 */  1995, 2071,  494, 1994, 1972,  657,  206, 1840,   75,   76,
 /*  1860 */  2051,  214,  659,  496,  207,  212, 1765, 1763,  511, 1761,
 /*  1870 */   515, 1759, 2101,  513,  519, 1757,  517,  384, 1744,  512,
 /*  1880 */   660,  523,  521,  525, 1743, 2051,  516,  659, 1726,  520,
 /*  1890 */  1842,   62, 2082, 1196, 1327,  524, 2118, 1841, 1326,  327,
 /*  1900 */  2084,  663, 2086, 2087,  658, 1241,  653, 1240, 2137, 1239,
 /*  1910 */  1755, 1232, 2083, 1748, 1238, 1237, 1234, 2082, 1233, 1746,
 /*  1920 */  1231, 2118,  359,  360,  328, 2084,  663, 2086, 2087,  658,
 /*  1930 */   718,  653,  550, 2083,  361,  720,  224,  553, 1725,  555,
 /*  1940 */  1724,  557, 1723,  559,  112, 2101, 1450, 2014,   26, 1452,
 /*  1950 */   386, 1449, 1454,  660, 1436,   66, 2006,  573, 2051, 1993,
 /*  1960 */   659, 1434, 2083, 1991,  162, 2247, 2101,   19,   16, 1663,
 /*  1970 */    20,   58,   59,   28,  660,  258,  259,  251,   30, 2051,
 /*  1980 */    64,  659,   17, 2083, 2072,  587, 1678,   21,    5,    6,
 /*  1990 */  2082,  589, 1677,  370, 2118, 2101,  253,  328, 2084,  663,
 /*  2000 */  2086, 2087,  658,  660,  653, 1682, 1645,  170, 2051,  257,
 /*  2010 */   659,  565,  271,   55, 1681, 2118, 2101,   29,  323, 2084,
 /*  2020 */   663, 2086, 2087,  658,  660,  653,  574,  579,  371, 2051,
 /*  2030 */   247,  659,  365, 2083, 1637,   57,   91,  173, 1992, 1990,
 /*  2040 */  2082, 1989, 1683, 1971, 2118, 1684, 1612,  312, 2084,  663,
 /*  2050 */  2086, 2087,  658, 1611,  653,   93,   94,  277, 2083,   96,
 /*  2060 */    22, 2082,  278, 1970,  280, 2118, 2101, 1643,  313, 2084,
 /*  2070 */   663, 2086, 2087,  658,  660,  653,  285,  287,   67, 2051,
 /*  2080 */   290,  659,   98,  102,   23, 1564,  634, 1563,   12, 1487,
 /*  2090 */  1519, 2101, 2121, 2083,  174, 1542, 1540,  652,   10,  660,
 /*  2100 */    36,  186, 1539,   15, 2051,   24,  659, 1574, 1511,   25,
 /*  2110 */    56, 2082, 1312,  662,  666, 2118, 2083,  664,  314, 2084,
 /*  2120 */   663, 2086, 2087,  658,  387,  653, 2101,  668,  670, 1309,
 /*  2130 */   671,  673, 1306, 1300,  660,  674, 2082,  676, 1298, 2051,
 /*  2140 */  2118,  659,  677,  320, 2084,  663, 2086, 2087,  658, 2101,
 /*  2150 */   653,  679,  680, 1289,  293,  103,  104,  660, 1321, 1304,
 /*  2160 */   686,   74, 2051, 1317,  659, 1194, 1248, 1303, 1302, 1301,
 /*  2170 */   696, 2082, 1228, 1227, 2083, 2118,  708, 1226,  324, 2084,
 /*  2180 */   663, 2086, 2087,  658, 1225,  653, 1224, 1223, 1221, 1219,
 /*  2190 */  1218, 1217,  294, 2083, 2082, 1215, 1214, 1213, 2118, 1212,
 /*  2200 */  1211,  316, 2084,  663, 2086, 2087,  658, 2101,  653, 1210,
 /*  2210 */  1245, 1209, 1200, 1243, 1206,  660, 1205, 1202, 1201, 1199,
 /*  2220 */  2051, 1762,  659,  728,  730, 1760, 2101,  732,  729, 1758,
 /*  2230 */   734,  736,  738, 1756,  660,  733,  740,  737,  742, 2051,
 /*  2240 */  1742,  659,  741,  744, 1151, 1722,  297,  748, 1697, 1473,
 /*  2250 */   307,  751, 2082, 1697, 2083, 1697, 2118,  752, 1697,  325,
 /*  2260 */  2084,  663, 2086, 2087,  658, 1697,  653, 1697, 1697, 1697,
 /*  2270 */  1697, 2082, 1697, 1697, 1697, 2118, 1697, 1697,  317, 2084,
 /*  2280 */   663, 2086, 2087,  658, 1697,  653, 1697, 2101, 1697, 1697,
 /*  2290 */  1697, 1697, 1697, 1697, 1697,  660, 1697, 1697, 1697, 1697,
 /*  2300 */  2051, 1697,  659, 1697, 1697, 1697, 1697, 1697, 1697, 1697,
 /*  2310 */  1697, 1697, 2083, 1697, 1697, 1697, 1697, 1697, 1697, 1697,
 /*  2320 */  1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 2083, 1697,
 /*  2330 */  1697, 1697, 2082, 1697, 1697, 1697, 2118, 1697, 1697,  326,
 /*  2340 */  2084,  663, 2086, 2087,  658, 2101,  653, 1697, 1697, 1697,
 /*  2350 */  1697, 1697, 1697,  660, 1697, 1697, 1697, 1697, 2051, 1697,
 /*  2360 */   659, 2101, 1697, 1697, 1697, 1697, 1697, 1697, 1697,  660,
 /*  2370 */  1697, 1697, 1697, 1697, 2051, 1697,  659, 1697, 1697, 1697,
 /*  2380 */  1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697,
 /*  2390 */  2082, 2083, 1697, 1697, 2118, 1697, 1697,  318, 2084,  663,
 /*  2400 */  2086, 2087,  658, 1697,  653, 1697, 2082, 2083, 1697, 1697,
 /*  2410 */  2118, 1697, 1697,  331, 2084,  663, 2086, 2087,  658, 1697,
 /*  2420 */   653, 1697, 1697, 1697, 2101, 1697, 2083, 1697, 1697, 1697,
 /*  2430 */  1697, 1697,  660, 1697, 1697, 1697, 1697, 2051, 1697,  659,
 /*  2440 */  2101, 1697, 1697, 1697, 1697, 1697, 1697, 1697,  660, 1697,
 /*  2450 */  1697, 1697, 1697, 2051, 1697,  659, 1697, 1697, 1697, 2101,
 /*  2460 */  1697, 1697, 1697, 1697, 1697, 1697, 1697,  660, 1697, 2082,
 /*  2470 */  1697, 1697, 2051, 2118,  659, 1697,  332, 2084,  663, 2086,
 /*  2480 */  2087,  658, 1697,  653, 1697, 2082, 1697, 1697, 1697, 2118,
 /*  2490 */  2083, 1697, 2095, 2084,  663, 2086, 2087,  658, 1697,  653,
 /*  2500 */  1697, 1697, 1697, 1697, 2082, 1697, 1697, 2083, 2118, 1697,
 /*  2510 */  1697, 2094, 2084,  663, 2086, 2087,  658, 1697,  653, 1697,
 /*  2520 */  1697, 1697, 1697, 2101, 1697, 1697, 1697, 1697, 1697, 1697,
 /*  2530 */  1697,  660, 1697, 1697, 1697, 1697, 2051, 1697,  659, 1697,
 /*  2540 */  2101, 1697, 1697, 1697, 1697, 1697, 1697, 1697,  660, 1697,
 /*  2550 */  1697, 1697, 1697, 2051, 1697,  659, 1697, 1697, 1697, 1697,
 /*  2560 */  1697, 1697, 1697, 1697, 1697, 1697, 1697, 2083, 2082, 1697,
 /*  2570 */  1697, 1697, 2118, 1697, 1697, 2093, 2084,  663, 2086, 2087,
 /*  2580 */   658, 1697,  653, 1697, 1697, 2082, 1697, 2083, 1697, 2118,
 /*  2590 */  1697, 1697,  346, 2084,  663, 2086, 2087,  658, 1697,  653,
 /*  2600 */  2101, 1697, 1697, 1697, 1697, 1697, 1697, 1697,  660, 1697,
 /*  2610 */  1697, 1697, 1697, 2051, 1697,  659, 1697, 1697, 1697, 1697,
 /*  2620 */  2101, 1697, 1697, 1697, 1697, 1697, 1697, 1697,  660, 1697,
 /*  2630 */  1697, 1697, 1697, 2051, 1697,  659, 1697, 1697, 1697, 1697,
 /*  2640 */  1697, 1697, 1697, 1697, 1697, 2082, 1697, 1697, 1697, 2118,
 /*  2650 */  1697, 1697,  347, 2084,  663, 2086, 2087,  658, 1697,  653,
 /*  2660 */  1697, 2083, 1697, 1697, 1697, 2082, 1697, 1697, 1697, 2118,
 /*  2670 */  1697, 1697,  343, 2084,  663, 2086, 2087,  658, 2083,  653,
 /*  2680 */  1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697,
 /*  2690 */  1697, 1697, 1697, 1697, 2101, 1697, 1697, 1697, 1697, 1697,
 /*  2700 */  1697, 1697,  660, 1697, 1697, 1697, 1697, 2051, 1697,  659,
 /*  2710 */  1697, 2101, 1697, 1697, 1697, 1697, 1697, 1697, 1697,  660,
 /*  2720 */  1697, 1697, 1697, 1697, 2051, 1697,  659, 1697, 1697, 1697,
 /*  2730 */  1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 2082,
 /*  2740 */  2083, 1697, 1697, 2118, 1697, 1697,  348, 2084,  663, 2086,
 /*  2750 */  2087,  658, 1697,  653, 1697, 1697,  661, 1697, 1697, 1697,
 /*  2760 */  2118, 1697, 1697,  323, 2084,  663, 2086, 2087,  658, 1697,
 /*  2770 */   653, 1697, 1697, 2101, 1697, 1697, 1697, 1697, 1697, 1697,
 /*  2780 */  1697,  660, 1697, 1697, 1697, 1697, 2051, 1697,  659, 1697,
 /*  2790 */  1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697,
 /*  2800 */  1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697,
 /*  2810 */  1697, 1697, 1697, 1697, 1697, 1697, 1697, 1697, 2082, 1697,
 /*  2820 */  1697, 1697, 2118, 1697, 1697,  322, 2084,  663, 2086, 2087,
 /*  2830 */   658, 1697,  653,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   367,  443,  380,  347,  332,  447,  336,  365,  338,  339,
 /*    10 */   354,  378,   12,   13,   14,  373,  380,  395,  396,  367,
 /*    20 */    20,  463,   22,  340,   20,  467,  468,  332,  392,  416,
 /*    30 */   378,  395,  396,   33,  361,   35,    0,  365,   12,   13,
 /*    40 */    14,   15,   16,  340,   20,  373,  413,  414,  415,   20,
 /*    50 */   378,   22,  380,  340,  340,  442,  373,  424,   58,  443,
 /*    60 */   365,  419,  365,  447,   64,  413,  414,  415,  373,  372,
 /*    70 */   356,   71,  331,  378,  333,  380,  424,  363,  381,  463,
 /*    80 */    51,  408,  410,  467,  468,  382,  414,  373,   20,  417,
 /*    90 */   418,  419,  420,  421,  422,  367,  424,   97,    4,   63,
 /*   100 */   100,  429,  389,  431,  391,  410,  378,  435,  436,  414,
 /*   110 */    12,   13,  417,  418,  419,  420,  421,  422,   20,  424,
 /*   120 */    22,  449,  439,  440,  441,  332,  443,  444,  111,  457,
 /*   130 */   447,   33,   20,   35,   22,  376,  136,  137,  379,  380,
 /*   140 */   443,  413,  414,  415,  447,  462,  463,   35,  432,  433,
 /*   150 */   467,  468,  424,  458,  459,   58,   58,    0,   20,  462,
 /*   160 */   463,   20,   64,   51,  467,  468,  166,  167,  100,   71,
 /*   170 */     0,  378,  172,  173,    8,    9,  364,  160,   12,   13,
 /*   180 */    14,   15,   16,   66,   67,   68,  186,   63,  188,  377,
 /*   190 */    73,   74,   75,  365,  100,   97,   79,  100,  100,  102,
 /*   200 */    14,   84,   85,  100,    8,    9,   20,   90,   12,   13,
 /*   210 */    14,   15,   16,  213,  214,  387,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */   230,  231,  232,  233,  136,  137,   66,   67,   68,   69,
 /*   240 */    70,  100,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   250 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   260 */    90,   91,   92,   20,  166,  167,  171,  101,   96,  112,
 /*   270 */   172,  173,   21,  165,   35,   24,   25,   26,   27,   28,
 /*   280 */    29,   30,   31,   32,  186,  112,  188,  130,  131,  132,
 /*   290 */   133,  134,  135,    8,    9,   63,    4,   12,   13,   14,
 /*   300 */    15,   16,  373,  130,  131,  132,  133,  134,  135,  329,
 /*   310 */    71,  213,  214,  384,  216,  217,  218,  219,  220,  221,
 /*   320 */   222,  223,  224,  225,  226,  227,  228,  229,  230,  231,
 /*   330 */   232,  233,  234,   12,   13,   43,    0,   45,   46,   20,
 /*   340 */   168,   20,   97,   22,  250,  237,  373,  250,   20,   64,
 /*   350 */   255,  256,  257,  250,   33,  247,   35,  384,  113,  114,
 /*   360 */   115,  116,  117,  118,  119,  120,  121,  122,  346,  124,
 /*   370 */   125,  126,  127,  128,  129,    0,    2,  397,  332,   58,
 /*   380 */    44,  401,    8,    9,  362,   64,   12,   13,   14,   15,
 /*   390 */    16,  250,   71,  371,  109,  336,   21,  338,  339,   24,
 /*   400 */    25,   26,   27,   28,   29,   30,   31,   32,    8,    9,
 /*   410 */   340,  365,   12,   13,   14,   15,   16,  357,   97,  373,
 /*   420 */    20,  100,   80,  443,  378,  365,  380,  447,  100,  357,
 /*   430 */    20,   12,   13,   14,  374,  130,  131,  365,  373,   20,
 /*   440 */   135,   22,  462,  463,  372,   20,  374,  467,  468,  384,
 /*   450 */   165,  131,   33,  381,   35,  135,  410,  136,  137,  389,
 /*   460 */   414,  391,  111,  417,  418,  419,  420,  421,  422,  423,
 /*   470 */   424,  425,  426,    0,    8,    9,  234,   58,   12,   13,
 /*   480 */    14,   15,   16,  141,  142,  166,  167,  166,  167,  344,
 /*   490 */    71,    0,  337,  172,  173,  340,  341,   24,   25,   26,
 /*   500 */    27,   28,   29,   30,   31,   32,  164,  186,  337,  188,
 /*   510 */    44,  340,  341,  368,  194,  195,   97,  397,  198,  100,
 /*   520 */   200,  401,  237,  238,  239,  240,  241,  242,  243,  244,
 /*   530 */   245,  246,  247,  332,  213,  214,  402,  216,  217,  218,
 /*   540 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*   550 */   229,  230,  231,  232,  233,  136,  137,   66,   67,   68,
 /*   560 */    71,  136,  137,  443,   73,   74,   75,  447,  168,  100,
 /*   570 */    79,  379,  380,  367,  344,   84,   85,   71,  250,  378,
 /*   580 */   332,   90,  462,  463,  378,  166,  167,  467,  468,    2,
 /*   590 */   360,  172,  173,    1,    2,    8,    9,    0,  368,   12,
 /*   600 */    13,   14,   15,   16,  111,  186,    3,  188,  351,  352,
 /*   610 */     8,    9,   21,  365,   12,   13,   14,   15,   16,  413,
 /*   620 */   414,  373,  340,   20,    0,   34,  378,   36,  380,  234,
 /*   630 */   424,  236,  213,  214,  346,  216,  217,  218,  219,  220,
 /*   640 */   221,  222,  223,  224,  225,  226,  227,  228,  229,  230,
 /*   650 */   231,  232,  233,   12,   13,  373,   58,  332,  410,  371,
 /*   660 */   367,   20,  414,   22,  340,  417,  418,  419,  420,  421,
 /*   670 */   422,  378,  424,   20,   33,  427,   35,  429,  430,  431,
 /*   680 */   356,    8,    9,  435,  436,   12,   13,   14,   15,   16,
 /*   690 */   365,  332,  365,  101,   20,  365,    0,  373,  373,   58,
 /*   700 */   102,  340,  372,  378,  101,  380,  413,  414,  332,  112,
 /*   710 */   397,  381,   71,  386,  387,  213,   37,  424,   22,  250,
 /*   720 */   438,  439,  440,  441,  340,  443,  444,  130,  131,  132,
 /*   730 */   133,  134,  135,  427,  373,  410,  430,  378,   97,  414,
 /*   740 */   356,  100,  417,  418,  419,  420,  421,  422,    3,  424,
 /*   750 */   332,   12,   13,  340,  378,  375,  443,  373,  378,   20,
 /*   760 */   447,   22,  260,  261,  262,  263,  264,  265,  266,  356,
 /*   770 */   168,  168,   33,  366,   35,  462,  463,  136,  137,  155,
 /*   780 */   467,  468,  103,  416,  105,  106,  373,  108,  164,  136,
 /*   790 */   137,  112,  340,  366,  469,  470,  378,   58,  366,  332,
 /*   800 */   439,  440,  441,  332,  443,  444,   20,  166,  167,  442,
 /*   810 */    71,  366,  133,  172,  173,  340,    8,    9,  416,  340,
 /*   820 */    12,   13,   14,   15,   16,  172,  173,  186,  366,  188,
 /*   830 */   365,  356,  365,  332,    0,  356,   97,  372,  363,  100,
 /*   840 */   373,  389,  168,  391,  442,  378,  381,  380,  373,  378,
 /*   850 */   397,  178,  373,   58,  213,  214,  332,  216,  217,  218,
 /*   860 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*   870 */   229,  230,  231,  232,  233,  136,  137,  410,  366,  378,
 /*   880 */   397,  414,   48,  365,  417,  418,  419,  420,  421,  422,
 /*   890 */   372,  424,  375,  357,   99,  378,  443,  102,  431,  381,
 /*   900 */   447,  365,  378,  436,  443,  166,  167,   20,  447,  101,
 /*   910 */   374,  172,  173,  351,  352,  462,  463,  181,  100,   39,
 /*   920 */   467,  468,   22,  462,  463,  186,  443,  188,  467,  468,
 /*   930 */   447,  365,  428,   14,  430,   35,   14,  366,  372,   20,
 /*   940 */   204,  205,   20,   45,   46,  462,  463,  381,  275,   44,
 /*   950 */   467,  468,  213,  214,  168,  216,  217,  218,  219,  220,
 /*   960 */   221,  222,  223,  224,  225,  226,  227,  228,  229,  230,
 /*   970 */   231,  232,  233,   20,   18,   18,   20,  340,   12,   13,
 /*   980 */    23,  397,  428,   27,  430,    4,   30,  332,   22,   33,
 /*   990 */    14,   15,   16,  356,   37,   38,    4,   97,   41,   33,
 /*  1000 */    19,   35,  333,  185,   48,  187,   50,  388,  375,   53,
 /*  1010 */   373,  378,   22,  365,   33,  270,   59,   60,   61,   62,
 /*  1020 */   365,   44,  374,  340,   58,   35,  340,  443,  373,   48,
 /*  1030 */   212,  447,  357,  378,   53,  380,  332,   71,  340,   58,
 /*  1040 */   365,  112,  356,  332,  248,  249,  462,  463,  340,  374,
 /*  1050 */   365,  467,  468,  166,  356,   99,  373,  100,  353,  373,
 /*  1060 */   355,   71,  133,   97,  356,  410,  381,  111,  250,  414,
 /*  1070 */   354,  373,  417,  418,  419,  420,  421,  422,  101,  424,
 /*  1080 */    99,  373,  378,  102,  429,  166,  431,   97,  166,  378,
 /*  1090 */   435,  436,  332,  332,   35,  138,  140,  332,    0,  143,
 /*  1100 */   144,  145,  146,  147,  148,  149,  150,  151,  152,  153,
 /*  1110 */   154,  155,  156,  157,  158,  159,  340,  161,  162,  163,
 /*  1120 */    22,  168,  439,  440,  441,   44,  443,  444,  340,  249,
 /*  1130 */   358,  340,  356,  361,   44,  178,  179,  180,  378,  378,
 /*  1140 */   183,  332,  340,  378,  356,  130,   22,  356,   42,  373,
 /*  1150 */    44,   42,  186,   44,  188,  340,  332,  340,  356,   35,
 /*  1160 */   203,  373,   35,  206,  373,  208,  209,  210,  211,  212,
 /*  1170 */   332,  356,  332,  356,  365,  373,  186,  272,  188,  213,
 /*  1180 */   214,  471,  373,  104,  340,   64,  107,  378,  373,  380,
 /*  1190 */   373,  101,  226,  227,  228,  229,  230,  231,  232,  340,
 /*  1200 */   356,   22,  378,  213,  214,  365,  332,  250,  340,  340,
 /*  1210 */   332,  196,  197,  373,   35,  356,  378,  373,  378,  410,
 /*  1220 */   380,   97,  332,  414,  356,  356,  417,  418,  419,  420,
 /*  1230 */   421,  422,  373,  424,  104,  332,  332,  107,  429,  332,
 /*  1240 */   431,  373,  373,  251,  435,  436,  104,  188,  104,  107,
 /*  1250 */   410,  107,  378,  460,  414,  365,  378,  417,  418,  419,
 /*  1260 */   420,  421,  422,  373,  424,   44,  457,    0,  378,  429,
 /*  1270 */   380,  431,  365,   44,  342,  435,  436,  199,   44,  201,
 /*  1280 */   373,  378,  378,  454,   44,  378,  446,  380,  100,   22,
 /*  1290 */   136,  137,  365,   44,  342,    1,    2,   44,  110,  332,
 /*  1300 */   410,   44,   44,   47,  414,   44,   44,  417,  418,  419,
 /*  1310 */   420,  421,  422,   44,  424,  188,  388,  410,  339,  332,
 /*  1320 */   377,  414,  101,   44,  417,  418,  419,  420,  421,  422,
 /*  1330 */   101,  424,  365,  388,  213,  101,  429,   19,  431,   13,
 /*  1340 */   373,  101,  435,  436,  445,  378,    0,  380,  464,  459,
 /*  1350 */   101,   33,  365,  446,  101,  274,  100,   44,  101,  101,
 /*  1360 */   373,   35,  101,  101,   44,  378,   48,  380,   44,   44,
 /*  1370 */   101,   13,   54,   55,   56,   57,   58,  410,  437,   44,
 /*  1380 */   101,  414,   44,   35,  417,  418,  419,  420,  421,  422,
 /*  1390 */   448,  424,  252,   35,  412,   49,  429,  410,  431,   48,
 /*  1400 */   411,  414,  435,  436,  417,  418,  419,  420,  421,  422,
 /*  1410 */   184,  424,  399,  446,  101,   42,  429,   99,  431,   71,
 /*  1420 */   102,  101,  435,  436,  385,  101,  101,   20,  332,  388,
 /*  1430 */   385,  165,  383,  446,   20,   33,  101,  340,  385,  101,
 /*  1440 */   340,  383,   98,  383,  350,   95,   94,  340,  332,  348,
 /*  1450 */    48,  349,  134,  340,  340,  340,   54,   55,   56,   57,
 /*  1460 */    58,  365,   20,  334,   20,  334,  405,   20,  346,  373,
 /*  1470 */    20,  380,  346,  341,  378,   20,  380,  341,  398,  346,
 /*  1480 */   346,  365,   52,  346,  346,  340,  343,  169,  365,  373,
 /*  1490 */   334,  343,  174,  346,  378,  340,  380,  378,  378,  334,
 /*  1500 */   365,   99,  202,  378,  102,  100,  410,  192,  190,  405,
 /*  1510 */   414,  193,  409,  417,  418,  419,  420,  421,  422,  407,
 /*  1520 */   424,  344,  332,  365,  365,  429,  410,  431,  365,  365,
 /*  1530 */   414,  435,  436,  417,  418,  419,  420,  421,  422,  365,
 /*  1540 */   424,  365,  446,  365,  191,  429,  332,  431,  365,  365,
 /*  1550 */   404,  435,  436,  403,  344,  365,  340,  388,  388,  378,
 /*  1560 */   380,  259,  258,  373,  453,  393,  393,  378,  378,  378,
 /*  1570 */   380,  169,  170,  378,  267,  177,  174,  269,  176,  365,
 /*  1580 */   268,  453,  253,  412,  273,  276,  249,  373,  271,  472,
 /*  1590 */   373,  452,  378,   20,  380,  193,  332,  456,  416,  340,
 /*  1600 */   410,  341,  453,  451,  414,   20,  455,  417,  418,  419,
 /*  1610 */   420,  421,  422,  332,  424,  344,  450,  344,  465,  429,
 /*  1620 */   393,  431,  391,  466,  410,  435,  436,  170,  414,  365,
 /*  1630 */   378,  417,  418,  419,  420,  421,  422,  373,  424,  393,
 /*  1640 */   390,  378,  378,  378,  380,  431,  365,  344,  378,  435,
 /*  1650 */   436,  361,  378,  378,  373,  373,  100,  434,  344,  378,
 /*  1660 */   100,  380,  369,  378,   36,  355,  344,  340,  335,  330,
 /*  1670 */   334,  394,  400,  332,  410,  359,    0,  345,  414,    0,
 /*  1680 */   394,  417,  418,  419,  420,  421,  422,  359,  424,  406,
 /*  1690 */   359,  410,    0,  332,   42,  414,    0,   35,  417,  418,
 /*  1700 */   419,  420,  421,  422,  207,  424,  365,   35,   35,   35,
 /*  1710 */   207,    0,  431,   35,  373,   35,  435,  436,  207,  378,
 /*  1720 */     0,  380,  207,    0,   35,  461,  365,    0,   22,    0,
 /*  1730 */    35,  194,  188,  186,  373,    0,    0,    0,  181,  378,
 /*  1740 */   182,  380,    0,    0,   47,    0,    0,    0,    0,   42,
 /*  1750 */     0,  410,    0,    0,    0,  414,  332,    0,  417,  418,
 /*  1760 */   419,  420,  421,  422,    0,  424,    0,  155,   35,    0,
 /*  1770 */   155,  410,  431,    0,    0,  414,  435,  436,  417,  418,
 /*  1780 */   419,  420,  421,  422,   22,  424,    0,    0,    0,  365,
 /*  1790 */     0,    0,    0,    0,  370,    0,    0,  373,    0,    0,
 /*  1800 */     0,    0,  378,    0,  380,   42,    0,    0,    0,    0,
 /*  1810 */     0,    0,    0,    0,  332,    0,  139,    0,    0,   22,
 /*  1820 */    96,   96,    0,   58,   22,    0,   58,    0,   58,   35,
 /*  1830 */     0,  470,    0,   44,  410,   14,    0,   14,  414,  332,
 /*  1840 */     0,  417,  418,  419,  420,  421,  422,  365,  424,    0,
 /*  1850 */     0,   47,   47,    0,    0,  373,   42,    0,   39,   39,
 /*  1860 */   378,  177,  380,   47,   40,   39,    0,    0,   35,    0,
 /*  1870 */    35,    0,  365,   39,   35,    0,   39,  370,    0,   48,
 /*  1880 */   373,   35,   39,   39,    0,  378,   48,  380,    0,   48,
 /*  1890 */     0,  109,  410,   65,   35,   48,  414,    0,   22,  417,
 /*  1900 */   418,  419,  420,  421,  422,   35,  424,   35,  426,   35,
 /*  1910 */     0,   22,  332,    0,   35,   35,   35,  410,   35,    0,
 /*  1920 */    35,  414,   22,   22,  417,  418,  419,  420,  421,  422,
 /*  1930 */    44,  424,   50,  332,   22,   44,  107,   35,    0,   35,
 /*  1940 */     0,   35,    0,   22,   20,  365,   35,    0,  100,   35,
 /*  1950 */   370,   35,  101,  373,   22,  100,    0,   22,  378,    0,
 /*  1960 */   380,   35,  332,    0,  189,    3,  365,   44,  254,  101,
 /*  1970 */   254,   44,   44,  100,  373,   44,   47,  100,   44,  378,
 /*  1980 */     3,  380,  254,  332,   47,   98,   35,   44,   96,   96,
 /*  1990 */   410,   95,   35,   35,  414,  365,  101,  417,  418,  419,
 /*  2000 */   420,  421,  422,  373,  424,   35,  101,  100,  378,  100,
 /*  2010 */   380,  410,   47,  168,   35,  414,  365,  100,  417,  418,
 /*  2020 */   419,  420,  421,  422,  373,  424,  168,  175,   35,  378,
 /*  2030 */   170,  380,  168,  332,  101,   44,  100,   47,    0,    0,
 /*  2040 */   410,    0,  101,    0,  414,  101,  101,  417,  418,  419,
 /*  2050 */   420,  421,  422,  101,  424,  100,   39,   47,  332,   39,
 /*  2060 */   100,  410,  101,    0,  100,  414,  365,  101,  417,  418,
 /*  2070 */   419,  420,  421,  422,  373,  424,  100,  169,  100,  378,
 /*  2080 */    47,  380,  100,  110,   44,   98,  171,   98,    2,   22,
 /*  2090 */    22,  365,  100,  332,   47,  101,  101,  100,  235,  373,
 /*  2100 */   100,   47,  101,  100,  378,  100,  380,  213,  101,  100,
 /*  2110 */   248,  410,  101,  215,   35,  414,  332,  111,  417,  418,
 /*  2120 */   419,  420,  421,  422,   35,  424,  365,  100,   35,  101,
 /*  2130 */   100,   35,  101,  101,  373,  100,  410,   35,  101,  378,
 /*  2140 */   414,  380,  100,  417,  418,  419,  420,  421,  422,  365,
 /*  2150 */   424,   35,  100,   22,   44,  100,  100,  373,   35,  123,
 /*  2160 */   112,  100,  378,   22,  380,   65,   71,  123,  123,  123,
 /*  2170 */    64,  410,   35,   35,  332,  414,   93,   35,  417,  418,
 /*  2180 */   419,  420,  421,  422,   35,  424,   35,   35,   35,   35,
 /*  2190 */    35,   35,   44,  332,  410,   35,   35,   35,  414,   22,
 /*  2200 */    35,  417,  418,  419,  420,  421,  422,  365,  424,   35,
 /*  2210 */    71,   35,   22,   35,   35,  373,   35,   35,   35,   35,
 /*  2220 */   378,    0,  380,   35,   39,    0,  365,   35,   48,    0,
 /*  2230 */    39,   35,   39,    0,  373,   48,   35,   48,   39,  378,
 /*  2240 */     0,  380,   48,   35,   35,    0,   22,   21,  473,   22,
 /*  2250 */    22,   21,  410,  473,  332,  473,  414,   20,  473,  417,
 /*  2260 */   418,  419,  420,  421,  422,  473,  424,  473,  473,  473,
 /*  2270 */   473,  410,  473,  473,  473,  414,  473,  473,  417,  418,
 /*  2280 */   419,  420,  421,  422,  473,  424,  473,  365,  473,  473,
 /*  2290 */   473,  473,  473,  473,  473,  373,  473,  473,  473,  473,
 /*  2300 */   378,  473,  380,  473,  473,  473,  473,  473,  473,  473,
 /*  2310 */   473,  473,  332,  473,  473,  473,  473,  473,  473,  473,
 /*  2320 */   473,  473,  473,  473,  473,  473,  473,  473,  332,  473,
 /*  2330 */   473,  473,  410,  473,  473,  473,  414,  473,  473,  417,
 /*  2340 */   418,  419,  420,  421,  422,  365,  424,  473,  473,  473,
 /*  2350 */   473,  473,  473,  373,  473,  473,  473,  473,  378,  473,
 /*  2360 */   380,  365,  473,  473,  473,  473,  473,  473,  473,  373,
 /*  2370 */   473,  473,  473,  473,  378,  473,  380,  473,  473,  473,
 /*  2380 */   473,  473,  473,  473,  473,  473,  473,  473,  473,  473,
 /*  2390 */   410,  332,  473,  473,  414,  473,  473,  417,  418,  419,
 /*  2400 */   420,  421,  422,  473,  424,  473,  410,  332,  473,  473,
 /*  2410 */   414,  473,  473,  417,  418,  419,  420,  421,  422,  473,
 /*  2420 */   424,  473,  473,  473,  365,  473,  332,  473,  473,  473,
 /*  2430 */   473,  473,  373,  473,  473,  473,  473,  378,  473,  380,
 /*  2440 */   365,  473,  473,  473,  473,  473,  473,  473,  373,  473,
 /*  2450 */   473,  473,  473,  378,  473,  380,  473,  473,  473,  365,
 /*  2460 */   473,  473,  473,  473,  473,  473,  473,  373,  473,  410,
 /*  2470 */   473,  473,  378,  414,  380,  473,  417,  418,  419,  420,
 /*  2480 */   421,  422,  473,  424,  473,  410,  473,  473,  473,  414,
 /*  2490 */   332,  473,  417,  418,  419,  420,  421,  422,  473,  424,
 /*  2500 */   473,  473,  473,  473,  410,  473,  473,  332,  414,  473,
 /*  2510 */   473,  417,  418,  419,  420,  421,  422,  473,  424,  473,
 /*  2520 */   473,  473,  473,  365,  473,  473,  473,  473,  473,  473,
 /*  2530 */   473,  373,  473,  473,  473,  473,  378,  473,  380,  473,
 /*  2540 */   365,  473,  473,  473,  473,  473,  473,  473,  373,  473,
 /*  2550 */   473,  473,  473,  378,  473,  380,  473,  473,  473,  473,
 /*  2560 */   473,  473,  473,  473,  473,  473,  473,  332,  410,  473,
 /*  2570 */   473,  473,  414,  473,  473,  417,  418,  419,  420,  421,
 /*  2580 */   422,  473,  424,  473,  473,  410,  473,  332,  473,  414,
 /*  2590 */   473,  473,  417,  418,  419,  420,  421,  422,  473,  424,
 /*  2600 */   365,  473,  473,  473,  473,  473,  473,  473,  373,  473,
 /*  2610 */   473,  473,  473,  378,  473,  380,  473,  473,  473,  473,
 /*  2620 */   365,  473,  473,  473,  473,  473,  473,  473,  373,  473,
 /*  2630 */   473,  473,  473,  378,  473,  380,  473,  473,  473,  473,
 /*  2640 */   473,  473,  473,  473,  473,  410,  473,  473,  473,  414,
 /*  2650 */   473,  473,  417,  418,  419,  420,  421,  422,  473,  424,
 /*  2660 */   473,  332,  473,  473,  473,  410,  473,  473,  473,  414,
 /*  2670 */   473,  473,  417,  418,  419,  420,  421,  422,  332,  424,
 /*  2680 */   473,  473,  473,  473,  473,  473,  473,  473,  473,  473,
 /*  2690 */   473,  473,  473,  473,  365,  473,  473,  473,  473,  473,
 /*  2700 */   473,  473,  373,  473,  473,  473,  473,  378,  473,  380,
 /*  2710 */   473,  365,  473,  473,  473,  473,  473,  473,  473,  373,
 /*  2720 */   473,  473,  473,  473,  378,  473,  380,  473,  473,  473,
 /*  2730 */   473,  473,  473,  473,  473,  473,  473,  473,  473,  410,
 /*  2740 */   332,  473,  473,  414,  473,  473,  417,  418,  419,  420,
 /*  2750 */   421,  422,  473,  424,  473,  473,  410,  473,  473,  473,
 /*  2760 */   414,  473,  473,  417,  418,  419,  420,  421,  422,  473,
 /*  2770 */   424,  473,  473,  365,  473,  473,  473,  473,  473,  473,
 /*  2780 */   473,  373,  473,  473,  473,  473,  378,  473,  380,  473,
 /*  2790 */   473,  473,  473,  473,  473,  473,  473,  473,  473,  473,
 /*  2800 */   473,  473,  473,  473,  473,  473,  473,  473,  473,  473,
 /*  2810 */   473,  473,  473,  473,  473,  473,  473,  473,  410,  473,
 /*  2820 */   473,  473,  414,  473,  473,  417,  418,  419,  420,  421,
 /*  2830 */   422,  473,  424,
};
#define YY_SHIFT_COUNT    (753)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2245)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   957,    0,   98,    0,  321,  321,  321,  321,  321,  321,
 /*    10 */   321,  321,  321,  321,  321,  419,  641,  641,  739,  641,
 /*    20 */   641,  641,  641,  641,  641,  641,  641,  641,  641,  641,
 /*    30 */   641,  641,  641,  641,  641,  641,  641,  641,  641,  641,
 /*    40 */   641,  641,  641,  641,  641,  641,  641,  641,  141,  328,
 /*    50 */   818,   68,   97,  103,  469,  103,   68,   68,  966,  966,
 /*    60 */   966,  103,  966,  966,   94,  103,    4,  653,   24,   24,
 /*    70 */   653,  292,  292,  319,  425,  186,  186,   24,   24,   24,
 /*    80 */    24,   24,   24,   24,  138,   24,   24,  124,    4,   24,
 /*    90 */    24,  243,   24,    4,   24,  138,   24,  138,    4,   24,
 /*   100 */    24,    4,   24,    4,    4,    4,   24,  232,  956,  285,
 /*   110 */   285,  117,  251,  990,  990,  990,  990,  990,  990,  990,
 /*   120 */   990,  990,  990,  990,  990,  990,  990,  990,  990,  990,
 /*   130 */   990,  990,  679,  603,  319,  425,  239,  674,  674,  674,
 /*   140 */    36,  395,  395,  239,  410,  410,  410,  124,  351,  242,
 /*   150 */     4,  489,    4,  489,  489,  493,  506,  245,  245,  245,
 /*   160 */   245,  245,  245,  245,  245, 1318,  491,  375,  400,  673,
 /*   170 */   502,  112,   95,  919,  922,   29,  786,  898,  929,  953,
 /*   180 */   796,  880,  745,  796, 1106,  992,  887, 1140, 1351, 1226,
 /*   190 */  1373, 1407, 1373, 1266, 1414, 1414, 1373, 1266, 1266, 1344,
 /*   200 */  1350, 1414, 1352, 1414, 1414, 1414, 1442, 1442, 1444,  124,
 /*   210 */  1447,  124, 1450, 1455,  124, 1450,  124,  124,  124, 1414,
 /*   220 */   124, 1430, 1430, 1442,    4,    4,    4,    4,    4,    4,
 /*   230 */     4,    4,    4,    4,    4, 1414, 1442,  489,  489,  489,
 /*   240 */  1300, 1405, 1444,  232, 1315, 1353, 1447,  232, 1414, 1407,
 /*   250 */  1407,  489, 1302, 1304,  489, 1302, 1304,  489,  489,    4,
 /*   260 */  1307, 1398, 1302, 1308, 1312, 1329, 1140, 1309, 1311, 1317,
 /*   270 */  1337,  410, 1573, 1414, 1450,  232,  232, 1585, 1304,  489,
 /*   280 */   489,  489,  489,  489, 1304,  489, 1457,  232,  493,  232,
 /*   290 */   410, 1556, 1560,  489,  506, 1414,  232, 1628, 1442, 2833,
 /*   300 */  2833, 2833, 2833, 2833, 2833, 2833, 2833, 2833,  170, 1402,
 /*   310 */   473,  981,  166,  466,  808,  157,  374,  587,  602,  597,
 /*   320 */   196,  196,  196,  196,  196,  196,  196,  196,  196,  173,
 /*   330 */   320,   26,   26,  342,  736,  624,  795,  900, 1124,  591,
 /*   340 */  1015,  305,  305,  976,  592,  108,  976,  976,  976,  834,
 /*   350 */   977, 1179, 1109,   17,  336, 1079, 1130, 1142, 1144,  696,
 /*   360 */  1098, 1267, 1078, 1090, 1221,  598, 1229, 1234, 1240, 1154,
 /*   370 */   905, 1081,  172, 1249, 1253, 1257, 1258, 1261, 1262, 1294,
 /*   380 */  1269, 1059, 1127, 1121, 1279, 1256, 1313, 1320, 1324, 1325,
 /*   390 */  1335, 1338, 1188, 1326, 1358, 1348, 1346, 1676, 1679, 1692,
 /*   400 */  1652, 1696, 1662, 1497, 1672, 1673, 1674, 1503, 1711, 1678,
 /*   410 */  1680, 1511, 1720, 1515, 1723, 1689, 1727, 1706, 1729, 1695,
 /*   420 */  1537, 1544, 1547, 1735, 1736, 1737, 1558, 1557, 1742, 1743,
 /*   430 */  1697, 1745, 1746, 1747, 1707, 1748, 1750, 1752, 1753, 1754,
 /*   440 */  1757, 1764, 1766, 1612, 1733, 1769, 1615, 1773, 1774, 1786,
 /*   450 */  1787, 1788, 1790, 1791, 1792, 1793, 1795, 1796, 1798, 1799,
 /*   460 */  1800, 1801, 1803, 1763, 1806, 1807, 1808, 1809, 1810, 1811,
 /*   470 */  1762, 1812, 1813, 1815, 1677, 1817, 1818, 1797, 1724, 1802,
 /*   480 */  1725, 1822, 1765, 1794, 1825, 1768, 1827, 1770, 1830, 1832,
 /*   490 */  1814, 1819, 1789, 1804, 1821, 1805, 1823, 1816, 1836, 1824,
 /*   500 */  1820, 1840, 1849, 1850, 1826, 1684, 1853, 1854, 1857, 1828,
 /*   510 */  1866, 1867, 1833, 1831, 1834, 1869, 1835, 1838, 1837, 1871,
 /*   520 */  1839, 1841, 1843, 1875, 1846, 1847, 1844, 1878, 1884, 1888,
 /*   530 */  1890, 1782, 1829, 1859, 1876, 1897, 1870, 1872, 1874, 1879,
 /*   540 */  1880, 1886, 1891, 1881, 1883, 1889, 1885, 1910, 1900, 1913,
 /*   550 */  1901, 1882, 1919, 1912, 1902, 1938, 1904, 1940, 1906, 1942,
 /*   560 */  1921, 1924, 1911, 1914, 1916, 1851, 1848, 1947, 1845, 1855,
 /*   570 */  1926, 1932, 1956, 1775, 1935, 1858, 1860, 1959, 1963, 1864,
 /*   580 */  1852, 1962, 1923, 1714, 1873, 1868, 1877, 1892, 1887, 1893,
 /*   590 */  1896, 1895, 1927, 1928, 1905, 1907, 1909, 1917, 1933, 1931,
 /*   600 */  1929, 1937, 1936, 1934, 1716, 1941, 1944, 1977, 1943, 1728,
 /*   610 */  1951, 1957, 1958, 1970, 1979, 1993, 1945, 1952, 1965, 1862,
 /*   620 */  1991, 1990, 2038, 2039, 2041, 2043, 1955, 2017, 1804, 2010,
 /*   630 */  1960, 1961, 1966, 1964, 1976, 1915, 1978, 2063, 2020, 1908,
 /*   640 */  1982, 1973, 1804, 2033, 2040, 1987, 1863, 1989, 2086, 2067,
 /*   650 */  1894, 1992, 1994, 1997, 1995, 2000, 2001, 2047, 2003, 2005,
 /*   660 */  2054, 2007, 2068, 1898, 2009, 2006, 2011, 2079, 2089, 2027,
 /*   670 */  2028, 2093, 2030, 2031, 2096, 2035, 2032, 2102, 2042, 2037,
 /*   680 */  2116, 2052, 2036, 2044, 2045, 2046, 2131, 2048, 2055, 2110,
 /*   690 */  2056, 2123, 2061, 2110, 2110, 2141, 2100, 2106, 2137, 2138,
 /*   700 */  2142, 2149, 2151, 2152, 2153, 2154, 2155, 2156, 2095, 2083,
 /*   710 */  2148, 2160, 2161, 2162, 2177, 2165, 2174, 2176, 2139, 1886,
 /*   720 */  2178, 1891, 2179, 2181, 2182, 2183, 2190, 2184, 2221, 2188,
 /*   730 */  2180, 2185, 2225, 2192, 2187, 2191, 2229, 2196, 2189, 2193,
 /*   740 */  2233, 2201, 2194, 2199, 2240, 2208, 2209, 2245, 2224, 2226,
 /*   750 */  2227, 2228, 2230, 2237,
};
#define YY_REDUCE_COUNT (307)
#define YY_REDUCE_MIN   (-442)
#define YY_REDUCE_MAX   (2408)
static const short yy_reduce_ofst[] = {
 /*     0 */   -20, -328,  248,  809,  840,  907,  967,  987, 1096,  655,
 /*    10 */  1116, 1190, 1214, 1281, 1341,   46, -305,  325,  467,  890,
 /*    20 */  1264, 1361, 1424, 1482, 1507, 1580, 1601, 1630, 1651, 1701,
 /*    30 */  1726, 1761, 1784, 1842, 1861, 1922, 1980, 1996, 2059, 2075,
 /*    40 */  2094, 2158, 2175, 2235, 2255, 2329, 2346, 2408, -317, -303,
 /*    50 */   120,  282,  313,  453,  483,  584,  361,  683, -367, -348,
 /*    60 */  -272,  461,  206,  293, -442, -384,   72, -364, -286,  475,
 /*    70 */  -378, -330,   59,  327, -241,  155,  171,  324,  384,  413,
 /*    80 */   479,  637,  686,  698, -287,  708,  776,   22,  330,  788,
 /*    90 */   791, -358,  802,  465,  815,   70,  817,  452,   60,  844,
 /*   100 */   859,  518,  868,  536,  566,  675,  869,  230, -297, -284,
 /*   110 */  -284, -344, -259, -207,  201,  359,  376,  418,  471,  501,
 /*   120 */   524,  704,  711,  760,  761,  765,  824,  838,  874,  878,
 /*   130 */   903,  904, -188, -387, -172,  192,  257, -387,  367,  402,
 /*   140 */   145,  504,  554,  562,  -71,  -27,   65,  288, -327,  306,
 /*   150 */   648,  380,  685,  517,  633,  772,  705,  407,  427,  432,
 /*   160 */   445,  462,  512,  571,  462,  134,  716,  669,  619,  710,
 /*   170 */   793,  932,  829,  927,  927,  952,  928,  979,  943,  945,
 /*   180 */   899,  899,  884,  899,  941,  942,  927,  982,  989, 1013,
 /*   190 */  1039, 1041, 1045, 1049, 1097, 1100, 1053, 1058, 1060, 1094,
 /*   200 */  1102, 1107, 1101, 1113, 1114, 1115, 1129, 1131, 1061, 1122,
 /*   210 */  1091, 1126, 1132, 1080, 1133, 1136, 1134, 1137, 1138, 1145,
 /*   220 */  1147, 1143, 1148, 1156, 1123, 1135, 1158, 1159, 1163, 1164,
 /*   230 */  1174, 1176, 1178, 1183, 1184, 1155, 1165, 1119, 1120, 1125,
 /*   240 */  1103, 1112, 1104, 1177, 1146, 1150, 1180, 1210, 1216, 1169,
 /*   250 */  1170, 1181, 1111, 1172, 1189, 1128, 1173, 1191, 1195,  927,
 /*   260 */  1141, 1151, 1149, 1139, 1152, 1166, 1171, 1117, 1157, 1153,
 /*   270 */   899, 1217, 1182, 1259, 1260, 1271, 1273, 1231, 1227, 1252,
 /*   280 */  1263, 1265, 1270, 1274, 1246, 1275, 1250, 1303, 1290, 1314,
 /*   290 */  1282, 1223, 1293, 1285, 1310, 1327, 1322, 1333, 1336, 1272,
 /*   300 */  1283, 1277, 1286, 1316, 1328, 1331, 1332, 1339,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*    10 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*    20 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*    30 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*    40 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*    50 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*    60 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*    70 */  1695, 1695, 1695, 1962, 1695, 1695, 1695, 1695, 1695, 1695,
 /*    80 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1774, 1695, 1695,
 /*    90 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   100 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1772, 1955, 2173,
 /*   110 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   120 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   130 */  1695, 1695, 1695, 2185, 1695, 1695, 1695, 2185, 2185, 2185,
 /*   140 */  1772, 2145, 2145, 1695, 1695, 1695, 1695, 1774, 2018, 1695,
 /*   150 */  1695, 1695, 1695, 1695, 1695, 1890, 1695, 1695, 1695, 1695,
 /*   160 */  1695, 1914, 1695, 1695, 1695, 2008, 1695, 1695, 2210, 2266,
 /*   170 */  1695, 1695, 2213, 1695, 1695, 1695, 1967, 1695, 1843, 2200,
 /*   180 */  2177, 2191, 2250, 2178, 2175, 2194, 1695, 2204, 1695, 2001,
 /*   190 */  1960, 1695, 1960, 1957, 1695, 1695, 1960, 1957, 1957, 1832,
 /*   200 */  1828, 1695, 1826, 1695, 1695, 1695, 1695, 1695, 1695, 1774,
 /*   210 */  1695, 1774, 1695, 1695, 1774, 1695, 1774, 1774, 1774, 1695,
 /*   220 */  1774, 1752, 1752, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   230 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   240 */  2030, 2016, 1695, 1772, 2012, 2010, 1695, 1772, 1695, 1695,
 /*   250 */  1695, 1695, 2221, 2219, 1695, 2221, 2219, 1695, 1695, 1695,
 /*   260 */  2235, 2231, 2221, 2239, 2237, 2206, 2204, 2269, 2256, 2252,
 /*   270 */  2191, 1695, 1695, 1695, 1695, 1772, 1772, 1695, 2219, 1695,
 /*   280 */  1695, 1695, 1695, 1695, 2219, 1695, 1695, 1772, 1695, 1772,
 /*   290 */  1695, 1695, 1859, 1695, 1695, 1695, 1772, 1727, 1695, 2003,
 /*   300 */  2021, 1985, 1985, 1893, 1893, 1893, 1775, 1700, 1695, 1695,
 /*   310 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   320 */  2234, 2233, 2100, 1695, 2149, 2148, 2147, 2138, 2099, 1855,
 /*   330 */  1695, 2098, 2097, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   340 */  1695, 1976, 1975, 2091, 1695, 1695, 2092, 2090, 2089, 1695,
 /*   350 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   360 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   370 */  2253, 2257, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 2174,
 /*   380 */  1695, 1695, 1695, 1695, 1695, 2073, 1695, 1695, 1695, 1695,
 /*   390 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   400 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   410 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   420 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   430 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   440 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   450 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   460 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   470 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   480 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   490 */  1695, 1695, 1732, 2078, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   500 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   510 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   520 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   530 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   540 */  1695, 1813, 1812, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   550 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   560 */  1695, 1695, 1695, 1695, 1695, 2082, 1695, 1695, 1695, 1695,
 /*   570 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   580 */  1695, 2249, 2207, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   590 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   600 */  1695, 2073, 1695, 2232, 1695, 1695, 2247, 1695, 2251, 1695,
 /*   610 */  1695, 1695, 1695, 1695, 1695, 1695, 2184, 2180, 1695, 1695,
 /*   620 */  2176, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 2081, 1695,
 /*   630 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   640 */  1695, 1695, 2072, 1695, 2135, 1695, 1695, 1695, 2169, 1695,
 /*   650 */  1695, 2120, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   660 */  1695, 2082, 1695, 2085, 1695, 1695, 1695, 1695, 1695, 1887,
 /*   670 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   680 */  1695, 1695, 1872, 1870, 1869, 1868, 1695, 1865, 1695, 1900,
 /*   690 */  1695, 1695, 1695, 1896, 1895, 1695, 1695, 1695, 1695, 1695,
 /*   700 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   710 */  1793, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1785,
 /*   720 */  1695, 1784, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   730 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   740 */  1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695, 1695,
 /*   750 */  1695, 1695, 1695, 1695,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      START => nothing */
    0,  /*       WITH => nothing */
    0,  /*  TIMESTAMP => nothing */
  277,  /*        END => ABORT */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*   LANGUAGE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  277,  /*      AFTER => ABORT */
  277,  /*     ATTACH => ABORT */
  277,  /*     BEFORE => ABORT */
  277,  /*      BEGIN => ABORT */
  277,  /*     BITAND => ABORT */
  277,  /*     BITNOT => ABORT */
  277,  /*      BITOR => ABORT */
  277,  /*     BLOCKS => ABORT */
  277,  /*     CHANGE => ABORT */
  277,  /*      COMMA => ABORT */
  277,  /*     CONCAT => ABORT */
  277,  /*   CONFLICT => ABORT */
  277,  /*       COPY => ABORT */
  277,  /*   DEFERRED => ABORT */
  277,  /* DELIMITERS => ABORT */
  277,  /*     DETACH => ABORT */
  277,  /*     DIVIDE => ABORT */
  277,  /*        DOT => ABORT */
  277,  /*       EACH => ABORT */
  277,  /*       FAIL => ABORT */
  277,  /*       FILE => ABORT */
  277,  /*        FOR => ABORT */
  277,  /*       GLOB => ABORT */
  277,  /*         ID => ABORT */
  277,  /*  IMMEDIATE => ABORT */
  277,  /*     IMPORT => ABORT */
  277,  /*  INITIALLY => ABORT */
  277,  /*    INSTEAD => ABORT */
  277,  /*     ISNULL => ABORT */
  277,  /*        KEY => ABORT */
  277,  /*    MODULES => ABORT */
  277,  /*  NK_BITNOT => ABORT */
  277,  /*    NK_SEMI => ABORT */
  277,  /*    NOTNULL => ABORT */
  277,  /*         OF => ABORT */
  277,  /*       PLUS => ABORT */
  277,  /*  PRIVILEGE => ABORT */
  277,  /*      RAISE => ABORT */
  277,  /*    REPLACE => ABORT */
  277,  /*   RESTRICT => ABORT */
  277,  /*        ROW => ABORT */
  277,  /*       SEMI => ABORT */
  277,  /*       STAR => ABORT */
  277,  /*  STATEMENT => ABORT */
  277,  /*     STRICT => ABORT */
  277,  /*     STRING => ABORT */
  277,  /*      TIMES => ABORT */
  277,  /*     VALUES => ABORT */
  277,  /*   VARIABLE => ABORT */
  277,  /*       VIEW => ABORT */
  277,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "COMPACT",
  /*   63 */ "IF",
  /*   64 */ "NOT",
  /*   65 */ "EXISTS",
  /*   66 */ "BUFFER",
  /*   67 */ "CACHEMODEL",
  /*   68 */ "CACHESIZE",
  /*   69 */ "COMP",
  /*   70 */ "DURATION",
  /*   71 */ "NK_VARIABLE",
  /*   72 */ "MAXROWS",
  /*   73 */ "MINROWS",
  /*   74 */ "KEEP",
  /*   75 */ "PAGES",
  /*   76 */ "PAGESIZE",
  /*   77 */ "TSDB_PAGESIZE",
  /*   78 */ "PRECISION",
  /*   79 */ "REPLICA",
  /*   80 */ "VGROUPS",
  /*   81 */ "SINGLE_STABLE",
  /*   82 */ "RETENTIONS",
  /*   83 */ "SCHEMALESS",
  /*   84 */ "WAL_LEVEL",
  /*   85 */ "WAL_FSYNC_PERIOD",
  /*   86 */ "WAL_RETENTION_PERIOD",
  /*   87 */ "WAL_RETENTION_SIZE",
  /*   88 */ "WAL_ROLL_PERIOD",
  /*   89 */ "WAL_SEGMENT_SIZE",
  /*   90 */ "STT_TRIGGER",
  /*   91 */ "TABLE_PREFIX",
  /*   92 */ "TABLE_SUFFIX",
  /*   93 */ "NK_COLON",
  /*   94 */ "MAX_SPEED",
  /*   95 */ "START",
  /*   96 */ "WITH",
  /*   97 */ "TIMESTAMP",
  /*   98 */ "END",
  /*   99 */ "TABLE",
  /*  100 */ "NK_LP",
  /*  101 */ "NK_RP",
  /*  102 */ "STABLE",
  /*  103 */ "ADD",
  /*  104 */ "COLUMN",
  /*  105 */ "MODIFY",
  /*  106 */ "RENAME",
  /*  107 */ "TAG",
  /*  108 */ "SET",
  /*  109 */ "NK_EQ",
  /*  110 */ "USING",
  /*  111 */ "TAGS",
  /*  112 */ "COMMENT",
  /*  113 */ "BOOL",
  /*  114 */ "TINYINT",
  /*  115 */ "SMALLINT",
  /*  116 */ "INT",
  /*  117 */ "INTEGER",
  /*  118 */ "BIGINT",
  /*  119 */ "FLOAT",
  /*  120 */ "DOUBLE",
  /*  121 */ "BINARY",
  /*  122 */ "NCHAR",
  /*  123 */ "UNSIGNED",
  /*  124 */ "JSON",
  /*  125 */ "VARCHAR",
  /*  126 */ "MEDIUMBLOB",
  /*  127 */ "BLOB",
  /*  128 */ "VARBINARY",
  /*  129 */ "DECIMAL",
  /*  130 */ "MAX_DELAY",
  /*  131 */ "WATERMARK",
  /*  132 */ "ROLLUP",
  /*  133 */ "TTL",
  /*  134 */ "SMA",
  /*  135 */ "DELETE_MARK",
  /*  136 */ "FIRST",
  /*  137 */ "LAST",
  /*  138 */ "SHOW",
  /*  139 */ "PRIVILEGES",
  /*  140 */ "DATABASES",
  /*  141 */ "TABLES",
  /*  142 */ "STABLES",
  /*  143 */ "MNODES",
  /*  144 */ "QNODES",
  /*  145 */ "FUNCTIONS",
  /*  146 */ "INDEXES",
  /*  147 */ "ACCOUNTS",
  /*  148 */ "APPS",
  /*  149 */ "CONNECTIONS",
  /*  150 */ "LICENCES",
  /*  151 */ "GRANTS",
  /*  152 */ "QUERIES",
  /*  153 */ "SCORES",
  /*  154 */ "TOPICS",
  /*  155 */ "VARIABLES",
  /*  156 */ "CLUSTER",
  /*  157 */ "BNODES",
  /*  158 */ "SNODES",
  /*  159 */ "TRANSACTIONS",
  /*  160 */ "DISTRIBUTED",
  /*  161 */ "CONSUMERS",
  /*  162 */ "SUBSCRIPTIONS",
  /*  163 */ "VNODES",
  /*  164 */ "ALIVE",
  /*  165 */ "LIKE",
  /*  166 */ "TBNAME",
  /*  167 */ "QTAGS",
  /*  168 */ "AS",
  /*  169 */ "INDEX",
  /*  170 */ "FUNCTION",
  /*  171 */ "INTERVAL",
  /*  172 */ "COUNT",
  /*  173 */ "LAST_ROW",
  /*  174 */ "TOPIC",
  /*  175 */ "META",
  /*  176 */ "CONSUMER",
  /*  177 */ "GROUP",
  /*  178 */ "DESC",
  /*  179 */ "DESCRIBE",
  /*  180 */ "RESET",
  /*  181 */ "QUERY",
  /*  182 */ "CACHE",
  /*  183 */ "EXPLAIN",
  /*  184 */ "ANALYZE",
  /*  185 */ "VERBOSE",
  /*  186 */ "NK_BOOL",
  /*  187 */ "RATIO",
  /*  188 */ "NK_FLOAT",
  /*  189 */ "OUTPUTTYPE",
  /*  190 */ "AGGREGATE",
  /*  191 */ "BUFSIZE",
  /*  192 */ "LANGUAGE",
  /*  193 */ "STREAM",
  /*  194 */ "INTO",
  /*  195 */ "TRIGGER",
  /*  196 */ "AT_ONCE",
  /*  197 */ "WINDOW_CLOSE",
  /*  198 */ "IGNORE",
  /*  199 */ "EXPIRED",
  /*  200 */ "FILL_HISTORY",
  /*  201 */ "UPDATE",
  /*  202 */ "SUBTABLE",
  /*  203 */ "KILL",
  /*  204 */ "CONNECTION",
  /*  205 */ "TRANSACTION",
  /*  206 */ "BALANCE",
  /*  207 */ "VGROUP",
  /*  208 */ "MERGE",
  /*  209 */ "REDISTRIBUTE",
  /*  210 */ "SPLIT",
  /*  211 */ "DELETE",
  /*  212 */ "INSERT",
  /*  213 */ "NULL",
  /*  214 */ "NK_QUESTION",
  /*  215 */ "NK_ARROW",
  /*  216 */ "ROWTS",
  /*  217 */ "QSTART",
  /*  218 */ "QEND",
  /*  219 */ "QDURATION",
  /*  220 */ "WSTART",
  /*  221 */ "WEND",
  /*  222 */ "WDURATION",
  /*  223 */ "IROWTS",
  /*  224 */ "ISFILLED",
  /*  225 */ "CAST",
  /*  226 */ "NOW",
  /*  227 */ "TODAY",
  /*  228 */ "TIMEZONE",
  /*  229 */ "CLIENT_VERSION",
  /*  230 */ "SERVER_VERSION",
  /*  231 */ "SERVER_STATUS",
  /*  232 */ "CURRENT_USER",
  /*  233 */ "CASE",
  /*  234 */ "WHEN",
  /*  235 */ "THEN",
  /*  236 */ "ELSE",
  /*  237 */ "BETWEEN",
  /*  238 */ "IS",
  /*  239 */ "NK_LT",
  /*  240 */ "NK_GT",
  /*  241 */ "NK_LE",
  /*  242 */ "NK_GE",
  /*  243 */ "NK_NE",
  /*  244 */ "MATCH",
  /*  245 */ "NMATCH",
  /*  246 */ "CONTAINS",
  /*  247 */ "IN",
  /*  248 */ "JOIN",
  /*  249 */ "INNER",
  /*  250 */ "SELECT",
  /*  251 */ "DISTINCT",
  /*  252 */ "WHERE",
  /*  253 */ "PARTITION",
  /*  254 */ "BY",
  /*  255 */ "SESSION",
  /*  256 */ "STATE_WINDOW",
  /*  257 */ "EVENT_WINDOW",
  /*  258 */ "SLIDING",
  /*  259 */ "FILL",
  /*  260 */ "VALUE",
  /*  261 */ "VALUE_F",
  /*  262 */ "NONE",
  /*  263 */ "PREV",
  /*  264 */ "NULL_F",
  /*  265 */ "LINEAR",
  /*  266 */ "NEXT",
  /*  267 */ "HAVING",
  /*  268 */ "RANGE",
  /*  269 */ "EVERY",
  /*  270 */ "ORDER",
  /*  271 */ "SLIMIT",
  /*  272 */ "SOFFSET",
  /*  273 */ "LIMIT",
  /*  274 */ "OFFSET",
  /*  275 */ "ASC",
  /*  276 */ "NULLS",
  /*  277 */ "ABORT",
  /*  278 */ "AFTER",
  /*  279 */ "ATTACH",
  /*  280 */ "BEFORE",
  /*  281 */ "BEGIN",
  /*  282 */ "BITAND",
  /*  283 */ "BITNOT",
  /*  284 */ "BITOR",
  /*  285 */ "BLOCKS",
  /*  286 */ "CHANGE",
  /*  287 */ "COMMA",
  /*  288 */ "CONCAT",
  /*  289 */ "CONFLICT",
  /*  290 */ "COPY",
  /*  291 */ "DEFERRED",
  /*  292 */ "DELIMITERS",
  /*  293 */ "DETACH",
  /*  294 */ "DIVIDE",
  /*  295 */ "DOT",
  /*  296 */ "EACH",
  /*  297 */ "FAIL",
  /*  298 */ "FILE",
  /*  299 */ "FOR",
  /*  300 */ "GLOB",
  /*  301 */ "ID",
  /*  302 */ "IMMEDIATE",
  /*  303 */ "IMPORT",
  /*  304 */ "INITIALLY",
  /*  305 */ "INSTEAD",
  /*  306 */ "ISNULL",
  /*  307 */ "KEY",
  /*  308 */ "MODULES",
  /*  309 */ "NK_BITNOT",
  /*  310 */ "NK_SEMI",
  /*  311 */ "NOTNULL",
  /*  312 */ "OF",
  /*  313 */ "PLUS",
  /*  314 */ "PRIVILEGE",
  /*  315 */ "RAISE",
  /*  316 */ "REPLACE",
  /*  317 */ "RESTRICT",
  /*  318 */ "ROW",
  /*  319 */ "SEMI",
  /*  320 */ "STAR",
  /*  321 */ "STATEMENT",
  /*  322 */ "STRICT",
  /*  323 */ "STRING",
  /*  324 */ "TIMES",
  /*  325 */ "VALUES",
  /*  326 */ "VARIABLE",
  /*  327 */ "VIEW",
  /*  328 */ "WAL",
  /*  329 */ "cmd",
  /*  330 */ "account_options",
  /*  331 */ "alter_account_options",
  /*  332 */ "literal",
  /*  333 */ "alter_account_option",
  /*  334 */ "user_name",
  /*  335 */ "sysinfo_opt",
  /*  336 */ "privileges",
  /*  337 */ "priv_level",
  /*  338 */ "priv_type_list",
  /*  339 */ "priv_type",
  /*  340 */ "db_name",
  /*  341 */ "topic_name",
  /*  342 */ "dnode_endpoint",
  /*  343 */ "force_opt",
  /*  344 */ "not_exists_opt",
  /*  345 */ "db_options",
  /*  346 */ "exists_opt",
  /*  347 */ "alter_db_options",
  /*  348 */ "speed_opt",
  /*  349 */ "start_opt",
  /*  350 */ "end_opt",
  /*  351 */ "integer_list",
  /*  352 */ "variable_list",
  /*  353 */ "retention_list",
  /*  354 */ "alter_db_option",
  /*  355 */ "retention",
  /*  356 */ "full_table_name",
  /*  357 */ "column_def_list",
  /*  358 */ "tags_def_opt",
  /*  359 */ "table_options",
  /*  360 */ "multi_create_clause",
  /*  361 */ "tags_def",
  /*  362 */ "multi_drop_clause",
  /*  363 */ "alter_table_clause",
  /*  364 */ "alter_table_options",
  /*  365 */ "column_name",
  /*  366 */ "type_name",
  /*  367 */ "signed_literal",
  /*  368 */ "create_subtable_clause",
  /*  369 */ "specific_cols_opt",
  /*  370 */ "expression_list",
  /*  371 */ "drop_table_clause",
  /*  372 */ "col_name_list",
  /*  373 */ "table_name",
  /*  374 */ "column_def",
  /*  375 */ "duration_list",
  /*  376 */ "rollup_func_list",
  /*  377 */ "alter_table_option",
  /*  378 */ "duration_literal",
  /*  379 */ "rollup_func_name",
  /*  380 */ "function_name",
  /*  381 */ "col_name",
  /*  382 */ "db_name_cond_opt",
  /*  383 */ "like_pattern_opt",
  /*  384 */ "table_name_cond",
  /*  385 */ "from_db_opt",
  /*  386 */ "tag_list_opt",
  /*  387 */ "tag_item",
  /*  388 */ "column_alias",
  /*  389 */ "full_index_name",
  /*  390 */ "index_options",
  /*  391 */ "index_name",
  /*  392 */ "func_list",
  /*  393 */ "sliding_opt",
  /*  394 */ "sma_stream_opt",
  /*  395 */ "func",
  /*  396 */ "sma_func_name",
  /*  397 */ "query_or_subquery",
  /*  398 */ "cgroup_name",
  /*  399 */ "analyze_opt",
  /*  400 */ "explain_options",
  /*  401 */ "insert_query",
  /*  402 */ "agg_func_opt",
  /*  403 */ "bufsize_opt",
  /*  404 */ "language_opt",
  /*  405 */ "stream_name",
  /*  406 */ "stream_options",
  /*  407 */ "col_list_opt",
  /*  408 */ "tag_def_or_ref_opt",
  /*  409 */ "subtable_opt",
  /*  410 */ "expression",
  /*  411 */ "dnode_list",
  /*  412 */ "where_clause_opt",
  /*  413 */ "signed",
  /*  414 */ "literal_func",
  /*  415 */ "literal_list",
  /*  416 */ "table_alias",
  /*  417 */ "expr_or_subquery",
  /*  418 */ "pseudo_column",
  /*  419 */ "column_reference",
  /*  420 */ "function_expression",
  /*  421 */ "case_when_expression",
  /*  422 */ "star_func",
  /*  423 */ "star_func_para_list",
  /*  424 */ "noarg_func",
  /*  425 */ "other_para_list",
  /*  426 */ "star_func_para",
  /*  427 */ "when_then_list",
  /*  428 */ "case_when_else_opt",
  /*  429 */ "common_expression",
  /*  430 */ "when_then_expr",
  /*  431 */ "predicate",
  /*  432 */ "compare_op",
  /*  433 */ "in_op",
  /*  434 */ "in_predicate_value",
  /*  435 */ "boolean_value_expression",
  /*  436 */ "boolean_primary",
  /*  437 */ "from_clause_opt",
  /*  438 */ "table_reference_list",
  /*  439 */ "table_reference",
  /*  440 */ "table_primary",
  /*  441 */ "joined_table",
  /*  442 */ "alias_opt",
  /*  443 */ "subquery",
  /*  444 */ "parenthesized_joined_table",
  /*  445 */ "join_type",
  /*  446 */ "search_condition",
  /*  447 */ "query_specification",
  /*  448 */ "set_quantifier_opt",
  /*  449 */ "select_list",
  /*  450 */ "partition_by_clause_opt",
  /*  451 */ "range_opt",
  /*  452 */ "every_opt",
  /*  453 */ "fill_opt",
  /*  454 */ "twindow_clause_opt",
  /*  455 */ "group_by_clause_opt",
  /*  456 */ "having_clause_opt",
  /*  457 */ "select_item",
  /*  458 */ "partition_list",
  /*  459 */ "partition_item",
  /*  460 */ "fill_mode",
  /*  461 */ "group_by_list",
  /*  462 */ "query_expression",
  /*  463 */ "query_simple",
  /*  464 */ "order_by_clause_opt",
  /*  465 */ "slimit_clause_opt",
  /*  466 */ "limit_clause_opt",
  /*  467 */ "union_query_expression",
  /*  468 */ "query_simple_or_subquery",
  /*  469 */ "sort_specification_list",
  /*  470 */ "sort_specification",
  /*  471 */ "ordering_specification_opt",
  /*  472 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "cmd ::= COMPACT DATABASE db_name start_opt end_opt",
 /*  73 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  74 */ "not_exists_opt ::=",
 /*  75 */ "exists_opt ::= IF EXISTS",
 /*  76 */ "exists_opt ::=",
 /*  77 */ "db_options ::=",
 /*  78 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  79 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  80 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  81 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  83 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  84 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  86 */ "db_options ::= db_options KEEP integer_list",
 /*  87 */ "db_options ::= db_options KEEP variable_list",
 /*  88 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  89 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  91 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  92 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  93 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  94 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  95 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  96 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 107 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 108 */ "alter_db_options ::= alter_db_option",
 /* 109 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 110 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 111 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 112 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 113 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 114 */ "alter_db_option ::= KEEP integer_list",
 /* 115 */ "alter_db_option ::= KEEP variable_list",
 /* 116 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 117 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 118 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 119 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 120 */ "alter_db_option ::= MINROWS NK_INTEGER",
 /* 121 */ "integer_list ::= NK_INTEGER",
 /* 122 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 123 */ "variable_list ::= NK_VARIABLE",
 /* 124 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 125 */ "retention_list ::= retention",
 /* 126 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 127 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 128 */ "speed_opt ::=",
 /* 129 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 130 */ "start_opt ::=",
 /* 131 */ "start_opt ::= START WITH NK_INTEGER",
 /* 132 */ "start_opt ::= START WITH NK_STRING",
 /* 133 */ "start_opt ::= START WITH TIMESTAMP NK_STRING",
 /* 134 */ "end_opt ::=",
 /* 135 */ "end_opt ::= END WITH NK_INTEGER",
 /* 136 */ "end_opt ::= END WITH NK_STRING",
 /* 137 */ "end_opt ::= END WITH TIMESTAMP NK_STRING",
 /* 138 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 139 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 140 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 141 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 142 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 143 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 144 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 145 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 146 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 147 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 148 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 149 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 150 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 151 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 152 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 153 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 154 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 155 */ "multi_create_clause ::= create_subtable_clause",
 /* 156 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 157 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 158 */ "multi_drop_clause ::= drop_table_clause",
 /* 159 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 160 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 161 */ "specific_cols_opt ::=",
 /* 162 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 163 */ "full_table_name ::= table_name",
 /* 164 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 165 */ "column_def_list ::= column_def",
 /* 166 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 167 */ "column_def ::= column_name type_name",
 /* 168 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 169 */ "type_name ::= BOOL",
 /* 170 */ "type_name ::= TINYINT",
 /* 171 */ "type_name ::= SMALLINT",
 /* 172 */ "type_name ::= INT",
 /* 173 */ "type_name ::= INTEGER",
 /* 174 */ "type_name ::= BIGINT",
 /* 175 */ "type_name ::= FLOAT",
 /* 176 */ "type_name ::= DOUBLE",
 /* 177 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 178 */ "type_name ::= TIMESTAMP",
 /* 179 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 180 */ "type_name ::= TINYINT UNSIGNED",
 /* 181 */ "type_name ::= SMALLINT UNSIGNED",
 /* 182 */ "type_name ::= INT UNSIGNED",
 /* 183 */ "type_name ::= BIGINT UNSIGNED",
 /* 184 */ "type_name ::= JSON",
 /* 185 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 186 */ "type_name ::= MEDIUMBLOB",
 /* 187 */ "type_name ::= BLOB",
 /* 188 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 189 */ "type_name ::= DECIMAL",
 /* 190 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 191 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 192 */ "tags_def_opt ::=",
 /* 193 */ "tags_def_opt ::= tags_def",
 /* 194 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 195 */ "table_options ::=",
 /* 196 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 197 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 198 */ "table_options ::= table_options WATERMARK duration_list",
 /* 199 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 200 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 201 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 202 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 203 */ "alter_table_options ::= alter_table_option",
 /* 204 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 205 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 206 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 207 */ "duration_list ::= duration_literal",
 /* 208 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 209 */ "rollup_func_list ::= rollup_func_name",
 /* 210 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 211 */ "rollup_func_name ::= function_name",
 /* 212 */ "rollup_func_name ::= FIRST",
 /* 213 */ "rollup_func_name ::= LAST",
 /* 214 */ "col_name_list ::= col_name",
 /* 215 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 216 */ "col_name ::= column_name",
 /* 217 */ "cmd ::= SHOW DNODES",
 /* 218 */ "cmd ::= SHOW USERS",
 /* 219 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 220 */ "cmd ::= SHOW DATABASES",
 /* 221 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 222 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 223 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 224 */ "cmd ::= SHOW MNODES",
 /* 225 */ "cmd ::= SHOW QNODES",
 /* 226 */ "cmd ::= SHOW FUNCTIONS",
 /* 227 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 228 */ "cmd ::= SHOW STREAMS",
 /* 229 */ "cmd ::= SHOW ACCOUNTS",
 /* 230 */ "cmd ::= SHOW APPS",
 /* 231 */ "cmd ::= SHOW CONNECTIONS",
 /* 232 */ "cmd ::= SHOW LICENCES",
 /* 233 */ "cmd ::= SHOW GRANTS",
 /* 234 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 235 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 236 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 237 */ "cmd ::= SHOW QUERIES",
 /* 238 */ "cmd ::= SHOW SCORES",
 /* 239 */ "cmd ::= SHOW TOPICS",
 /* 240 */ "cmd ::= SHOW VARIABLES",
 /* 241 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 242 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 243 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 244 */ "cmd ::= SHOW BNODES",
 /* 245 */ "cmd ::= SHOW SNODES",
 /* 246 */ "cmd ::= SHOW CLUSTER",
 /* 247 */ "cmd ::= SHOW TRANSACTIONS",
 /* 248 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 249 */ "cmd ::= SHOW CONSUMERS",
 /* 250 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 251 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 252 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 253 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 254 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 255 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 256 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 257 */ "db_name_cond_opt ::=",
 /* 258 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 259 */ "like_pattern_opt ::=",
 /* 260 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 261 */ "table_name_cond ::= table_name",
 /* 262 */ "from_db_opt ::=",
 /* 263 */ "from_db_opt ::= FROM db_name",
 /* 264 */ "tag_list_opt ::=",
 /* 265 */ "tag_list_opt ::= tag_item",
 /* 266 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 267 */ "tag_item ::= TBNAME",
 /* 268 */ "tag_item ::= QTAGS",
 /* 269 */ "tag_item ::= column_name",
 /* 270 */ "tag_item ::= column_name column_alias",
 /* 271 */ "tag_item ::= column_name AS column_alias",
 /* 272 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 273 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 274 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 275 */ "full_index_name ::= index_name",
 /* 276 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 277 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 278 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 279 */ "func_list ::= func",
 /* 280 */ "func_list ::= func_list NK_COMMA func",
 /* 281 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 282 */ "sma_func_name ::= function_name",
 /* 283 */ "sma_func_name ::= COUNT",
 /* 284 */ "sma_func_name ::= FIRST",
 /* 285 */ "sma_func_name ::= LAST",
 /* 286 */ "sma_func_name ::= LAST_ROW",
 /* 287 */ "sma_stream_opt ::=",
 /* 288 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 289 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 290 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 291 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 292 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 293 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 294 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 295 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 296 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 297 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 298 */ "cmd ::= DESC full_table_name",
 /* 299 */ "cmd ::= DESCRIBE full_table_name",
 /* 300 */ "cmd ::= RESET QUERY CACHE",
 /* 301 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 302 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 303 */ "analyze_opt ::=",
 /* 304 */ "analyze_opt ::= ANALYZE",
 /* 305 */ "explain_options ::=",
 /* 306 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 307 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 308 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt",
 /* 309 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 310 */ "agg_func_opt ::=",
 /* 311 */ "agg_func_opt ::= AGGREGATE",
 /* 312 */ "bufsize_opt ::=",
 /* 313 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 314 */ "language_opt ::=",
 /* 315 */ "language_opt ::= LANGUAGE NK_STRING",
 /* 316 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 317 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 318 */ "col_list_opt ::=",
 /* 319 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 320 */ "tag_def_or_ref_opt ::=",
 /* 321 */ "tag_def_or_ref_opt ::= tags_def",
 /* 322 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 323 */ "stream_options ::=",
 /* 324 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 325 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 326 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 327 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 328 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 329 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 330 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 331 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 332 */ "subtable_opt ::=",
 /* 333 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 334 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 335 */ "cmd ::= KILL QUERY NK_STRING",
 /* 336 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 337 */ "cmd ::= BALANCE VGROUP",
 /* 338 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 339 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 340 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 341 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 342 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 343 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 344 */ "cmd ::= query_or_subquery",
 /* 345 */ "cmd ::= insert_query",
 /* 346 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 347 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 348 */ "literal ::= NK_INTEGER",
 /* 349 */ "literal ::= NK_FLOAT",
 /* 350 */ "literal ::= NK_STRING",
 /* 351 */ "literal ::= NK_BOOL",
 /* 352 */ "literal ::= TIMESTAMP NK_STRING",
 /* 353 */ "literal ::= duration_literal",
 /* 354 */ "literal ::= NULL",
 /* 355 */ "literal ::= NK_QUESTION",
 /* 356 */ "duration_literal ::= NK_VARIABLE",
 /* 357 */ "signed ::= NK_INTEGER",
 /* 358 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 359 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 360 */ "signed ::= NK_FLOAT",
 /* 361 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 362 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 363 */ "signed_literal ::= signed",
 /* 364 */ "signed_literal ::= NK_STRING",
 /* 365 */ "signed_literal ::= NK_BOOL",
 /* 366 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 367 */ "signed_literal ::= duration_literal",
 /* 368 */ "signed_literal ::= NULL",
 /* 369 */ "signed_literal ::= literal_func",
 /* 370 */ "signed_literal ::= NK_QUESTION",
 /* 371 */ "literal_list ::= signed_literal",
 /* 372 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 373 */ "db_name ::= NK_ID",
 /* 374 */ "table_name ::= NK_ID",
 /* 375 */ "column_name ::= NK_ID",
 /* 376 */ "function_name ::= NK_ID",
 /* 377 */ "table_alias ::= NK_ID",
 /* 378 */ "column_alias ::= NK_ID",
 /* 379 */ "user_name ::= NK_ID",
 /* 380 */ "topic_name ::= NK_ID",
 /* 381 */ "stream_name ::= NK_ID",
 /* 382 */ "cgroup_name ::= NK_ID",
 /* 383 */ "index_name ::= NK_ID",
 /* 384 */ "expr_or_subquery ::= expression",
 /* 385 */ "expression ::= literal",
 /* 386 */ "expression ::= pseudo_column",
 /* 387 */ "expression ::= column_reference",
 /* 388 */ "expression ::= function_expression",
 /* 389 */ "expression ::= case_when_expression",
 /* 390 */ "expression ::= NK_LP expression NK_RP",
 /* 391 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 392 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 393 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 394 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 395 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 396 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 397 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 398 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 399 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 400 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 401 */ "expression_list ::= expr_or_subquery",
 /* 402 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 403 */ "column_reference ::= column_name",
 /* 404 */ "column_reference ::= table_name NK_DOT column_name",
 /* 405 */ "pseudo_column ::= ROWTS",
 /* 406 */ "pseudo_column ::= TBNAME",
 /* 407 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 408 */ "pseudo_column ::= QSTART",
 /* 409 */ "pseudo_column ::= QEND",
 /* 410 */ "pseudo_column ::= QDURATION",
 /* 411 */ "pseudo_column ::= WSTART",
 /* 412 */ "pseudo_column ::= WEND",
 /* 413 */ "pseudo_column ::= WDURATION",
 /* 414 */ "pseudo_column ::= IROWTS",
 /* 415 */ "pseudo_column ::= ISFILLED",
 /* 416 */ "pseudo_column ::= QTAGS",
 /* 417 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 418 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 419 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 420 */ "function_expression ::= literal_func",
 /* 421 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 422 */ "literal_func ::= NOW",
 /* 423 */ "noarg_func ::= NOW",
 /* 424 */ "noarg_func ::= TODAY",
 /* 425 */ "noarg_func ::= TIMEZONE",
 /* 426 */ "noarg_func ::= DATABASE",
 /* 427 */ "noarg_func ::= CLIENT_VERSION",
 /* 428 */ "noarg_func ::= SERVER_VERSION",
 /* 429 */ "noarg_func ::= SERVER_STATUS",
 /* 430 */ "noarg_func ::= CURRENT_USER",
 /* 431 */ "noarg_func ::= USER",
 /* 432 */ "star_func ::= COUNT",
 /* 433 */ "star_func ::= FIRST",
 /* 434 */ "star_func ::= LAST",
 /* 435 */ "star_func ::= LAST_ROW",
 /* 436 */ "star_func_para_list ::= NK_STAR",
 /* 437 */ "star_func_para_list ::= other_para_list",
 /* 438 */ "other_para_list ::= star_func_para",
 /* 439 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 440 */ "star_func_para ::= expr_or_subquery",
 /* 441 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 442 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 443 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 444 */ "when_then_list ::= when_then_expr",
 /* 445 */ "when_then_list ::= when_then_list when_then_expr",
 /* 446 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 447 */ "case_when_else_opt ::=",
 /* 448 */ "case_when_else_opt ::= ELSE common_expression",
 /* 449 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 450 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 451 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 452 */ "predicate ::= expr_or_subquery IS NULL",
 /* 453 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 454 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 455 */ "compare_op ::= NK_LT",
 /* 456 */ "compare_op ::= NK_GT",
 /* 457 */ "compare_op ::= NK_LE",
 /* 458 */ "compare_op ::= NK_GE",
 /* 459 */ "compare_op ::= NK_NE",
 /* 460 */ "compare_op ::= NK_EQ",
 /* 461 */ "compare_op ::= LIKE",
 /* 462 */ "compare_op ::= NOT LIKE",
 /* 463 */ "compare_op ::= MATCH",
 /* 464 */ "compare_op ::= NMATCH",
 /* 465 */ "compare_op ::= CONTAINS",
 /* 466 */ "in_op ::= IN",
 /* 467 */ "in_op ::= NOT IN",
 /* 468 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 469 */ "boolean_value_expression ::= boolean_primary",
 /* 470 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 471 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 472 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 473 */ "boolean_primary ::= predicate",
 /* 474 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 475 */ "common_expression ::= expr_or_subquery",
 /* 476 */ "common_expression ::= boolean_value_expression",
 /* 477 */ "from_clause_opt ::=",
 /* 478 */ "from_clause_opt ::= FROM table_reference_list",
 /* 479 */ "table_reference_list ::= table_reference",
 /* 480 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 481 */ "table_reference ::= table_primary",
 /* 482 */ "table_reference ::= joined_table",
 /* 483 */ "table_primary ::= table_name alias_opt",
 /* 484 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 485 */ "table_primary ::= subquery alias_opt",
 /* 486 */ "table_primary ::= parenthesized_joined_table",
 /* 487 */ "alias_opt ::=",
 /* 488 */ "alias_opt ::= table_alias",
 /* 489 */ "alias_opt ::= AS table_alias",
 /* 490 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 491 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 492 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 493 */ "join_type ::=",
 /* 494 */ "join_type ::= INNER",
 /* 495 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 496 */ "set_quantifier_opt ::=",
 /* 497 */ "set_quantifier_opt ::= DISTINCT",
 /* 498 */ "set_quantifier_opt ::= ALL",
 /* 499 */ "select_list ::= select_item",
 /* 500 */ "select_list ::= select_list NK_COMMA select_item",
 /* 501 */ "select_item ::= NK_STAR",
 /* 502 */ "select_item ::= common_expression",
 /* 503 */ "select_item ::= common_expression column_alias",
 /* 504 */ "select_item ::= common_expression AS column_alias",
 /* 505 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 506 */ "where_clause_opt ::=",
 /* 507 */ "where_clause_opt ::= WHERE search_condition",
 /* 508 */ "partition_by_clause_opt ::=",
 /* 509 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 510 */ "partition_list ::= partition_item",
 /* 511 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 512 */ "partition_item ::= expr_or_subquery",
 /* 513 */ "partition_item ::= expr_or_subquery column_alias",
 /* 514 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 515 */ "twindow_clause_opt ::=",
 /* 516 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 517 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 518 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 519 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 520 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 521 */ "sliding_opt ::=",
 /* 522 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 523 */ "fill_opt ::=",
 /* 524 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 525 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 526 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP",
 /* 527 */ "fill_mode ::= NONE",
 /* 528 */ "fill_mode ::= PREV",
 /* 529 */ "fill_mode ::= NULL",
 /* 530 */ "fill_mode ::= NULL_F",
 /* 531 */ "fill_mode ::= LINEAR",
 /* 532 */ "fill_mode ::= NEXT",
 /* 533 */ "group_by_clause_opt ::=",
 /* 534 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 535 */ "group_by_list ::= expr_or_subquery",
 /* 536 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 537 */ "having_clause_opt ::=",
 /* 538 */ "having_clause_opt ::= HAVING search_condition",
 /* 539 */ "range_opt ::=",
 /* 540 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 541 */ "every_opt ::=",
 /* 542 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 543 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 544 */ "query_simple ::= query_specification",
 /* 545 */ "query_simple ::= union_query_expression",
 /* 546 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 547 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 548 */ "query_simple_or_subquery ::= query_simple",
 /* 549 */ "query_simple_or_subquery ::= subquery",
 /* 550 */ "query_or_subquery ::= query_expression",
 /* 551 */ "query_or_subquery ::= subquery",
 /* 552 */ "order_by_clause_opt ::=",
 /* 553 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 554 */ "slimit_clause_opt ::=",
 /* 555 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 556 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 557 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 558 */ "limit_clause_opt ::=",
 /* 559 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 560 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 561 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 562 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 563 */ "subquery ::= NK_LP subquery NK_RP",
 /* 564 */ "search_condition ::= common_expression",
 /* 565 */ "sort_specification_list ::= sort_specification",
 /* 566 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 567 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 568 */ "ordering_specification_opt ::=",
 /* 569 */ "ordering_specification_opt ::= ASC",
 /* 570 */ "ordering_specification_opt ::= DESC",
 /* 571 */ "null_ordering_opt ::=",
 /* 572 */ "null_ordering_opt ::= NULLS FIRST",
 /* 573 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 329: /* cmd */
    case 332: /* literal */
    case 345: /* db_options */
    case 347: /* alter_db_options */
    case 349: /* start_opt */
    case 350: /* end_opt */
    case 355: /* retention */
    case 356: /* full_table_name */
    case 359: /* table_options */
    case 363: /* alter_table_clause */
    case 364: /* alter_table_options */
    case 367: /* signed_literal */
    case 368: /* create_subtable_clause */
    case 371: /* drop_table_clause */
    case 374: /* column_def */
    case 378: /* duration_literal */
    case 379: /* rollup_func_name */
    case 381: /* col_name */
    case 382: /* db_name_cond_opt */
    case 383: /* like_pattern_opt */
    case 384: /* table_name_cond */
    case 385: /* from_db_opt */
    case 387: /* tag_item */
    case 389: /* full_index_name */
    case 390: /* index_options */
    case 393: /* sliding_opt */
    case 394: /* sma_stream_opt */
    case 395: /* func */
    case 397: /* query_or_subquery */
    case 400: /* explain_options */
    case 401: /* insert_query */
    case 406: /* stream_options */
    case 409: /* subtable_opt */
    case 410: /* expression */
    case 412: /* where_clause_opt */
    case 413: /* signed */
    case 414: /* literal_func */
    case 417: /* expr_or_subquery */
    case 418: /* pseudo_column */
    case 419: /* column_reference */
    case 420: /* function_expression */
    case 421: /* case_when_expression */
    case 426: /* star_func_para */
    case 428: /* case_when_else_opt */
    case 429: /* common_expression */
    case 430: /* when_then_expr */
    case 431: /* predicate */
    case 434: /* in_predicate_value */
    case 435: /* boolean_value_expression */
    case 436: /* boolean_primary */
    case 437: /* from_clause_opt */
    case 438: /* table_reference_list */
    case 439: /* table_reference */
    case 440: /* table_primary */
    case 441: /* joined_table */
    case 443: /* subquery */
    case 444: /* parenthesized_joined_table */
    case 446: /* search_condition */
    case 447: /* query_specification */
    case 451: /* range_opt */
    case 452: /* every_opt */
    case 453: /* fill_opt */
    case 454: /* twindow_clause_opt */
    case 456: /* having_clause_opt */
    case 457: /* select_item */
    case 459: /* partition_item */
    case 462: /* query_expression */
    case 463: /* query_simple */
    case 465: /* slimit_clause_opt */
    case 466: /* limit_clause_opt */
    case 467: /* union_query_expression */
    case 468: /* query_simple_or_subquery */
    case 470: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy828)); 
}
      break;
    case 330: /* account_options */
    case 331: /* alter_account_options */
    case 333: /* alter_account_option */
    case 348: /* speed_opt */
    case 403: /* bufsize_opt */
{
 
}
      break;
    case 334: /* user_name */
    case 337: /* priv_level */
    case 340: /* db_name */
    case 341: /* topic_name */
    case 342: /* dnode_endpoint */
    case 365: /* column_name */
    case 373: /* table_name */
    case 380: /* function_name */
    case 388: /* column_alias */
    case 391: /* index_name */
    case 396: /* sma_func_name */
    case 398: /* cgroup_name */
    case 404: /* language_opt */
    case 405: /* stream_name */
    case 416: /* table_alias */
    case 422: /* star_func */
    case 424: /* noarg_func */
    case 442: /* alias_opt */
{
 
}
      break;
    case 335: /* sysinfo_opt */
{
 
}
      break;
    case 336: /* privileges */
    case 338: /* priv_type_list */
    case 339: /* priv_type */
{
 
}
      break;
    case 343: /* force_opt */
    case 344: /* not_exists_opt */
    case 346: /* exists_opt */
    case 399: /* analyze_opt */
    case 402: /* agg_func_opt */
    case 448: /* set_quantifier_opt */
{
 
}
      break;
    case 351: /* integer_list */
    case 352: /* variable_list */
    case 353: /* retention_list */
    case 357: /* column_def_list */
    case 358: /* tags_def_opt */
    case 360: /* multi_create_clause */
    case 361: /* tags_def */
    case 362: /* multi_drop_clause */
    case 369: /* specific_cols_opt */
    case 370: /* expression_list */
    case 372: /* col_name_list */
    case 375: /* duration_list */
    case 376: /* rollup_func_list */
    case 386: /* tag_list_opt */
    case 392: /* func_list */
    case 407: /* col_list_opt */
    case 408: /* tag_def_or_ref_opt */
    case 411: /* dnode_list */
    case 415: /* literal_list */
    case 423: /* star_func_para_list */
    case 425: /* other_para_list */
    case 427: /* when_then_list */
    case 449: /* select_list */
    case 450: /* partition_by_clause_opt */
    case 455: /* group_by_clause_opt */
    case 458: /* partition_list */
    case 461: /* group_by_list */
    case 464: /* order_by_clause_opt */
    case 469: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy222)); 
}
      break;
    case 354: /* alter_db_option */
    case 377: /* alter_table_option */
{
 
}
      break;
    case 366: /* type_name */
{
 
}
      break;
    case 432: /* compare_op */
    case 433: /* in_op */
{
 
}
      break;
    case 445: /* join_type */
{
 
}
      break;
    case 460: /* fill_mode */
{
 
}
      break;
    case 471: /* ordering_specification_opt */
{
 
}
      break;
    case 472: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  329,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  329,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  330,    0 }, /* (2) account_options ::= */
  {  330,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  330,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  330,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  330,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  330,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  330,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  330,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  330,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  330,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  331,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  331,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  333,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  333,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  333,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  333,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  333,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  333,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  333,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  333,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  333,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  333,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  329,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  329,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  329,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  329,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  329,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  335,    0 }, /* (29) sysinfo_opt ::= */
  {  335,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  329,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  329,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  336,   -1 }, /* (33) privileges ::= ALL */
  {  336,   -1 }, /* (34) privileges ::= priv_type_list */
  {  336,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  338,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  338,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  339,   -1 }, /* (38) priv_type ::= READ */
  {  339,   -1 }, /* (39) priv_type ::= WRITE */
  {  337,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  337,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  337,   -1 }, /* (42) priv_level ::= topic_name */
  {  329,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  329,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  329,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  329,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  329,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  329,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  329,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  329,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  342,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  342,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  342,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  343,    0 }, /* (54) force_opt ::= */
  {  343,   -1 }, /* (55) force_opt ::= FORCE */
  {  329,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  329,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  329,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  329,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  329,   -2 }, /* (68) cmd ::= USE db_name */
  {  329,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  329,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  329,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  329,   -5 }, /* (72) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
  {  344,   -3 }, /* (73) not_exists_opt ::= IF NOT EXISTS */
  {  344,    0 }, /* (74) not_exists_opt ::= */
  {  346,   -2 }, /* (75) exists_opt ::= IF EXISTS */
  {  346,    0 }, /* (76) exists_opt ::= */
  {  345,    0 }, /* (77) db_options ::= */
  {  345,   -3 }, /* (78) db_options ::= db_options BUFFER NK_INTEGER */
  {  345,   -3 }, /* (79) db_options ::= db_options CACHEMODEL NK_STRING */
  {  345,   -3 }, /* (80) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  345,   -3 }, /* (81) db_options ::= db_options COMP NK_INTEGER */
  {  345,   -3 }, /* (82) db_options ::= db_options DURATION NK_INTEGER */
  {  345,   -3 }, /* (83) db_options ::= db_options DURATION NK_VARIABLE */
  {  345,   -3 }, /* (84) db_options ::= db_options MAXROWS NK_INTEGER */
  {  345,   -3 }, /* (85) db_options ::= db_options MINROWS NK_INTEGER */
  {  345,   -3 }, /* (86) db_options ::= db_options KEEP integer_list */
  {  345,   -3 }, /* (87) db_options ::= db_options KEEP variable_list */
  {  345,   -3 }, /* (88) db_options ::= db_options PAGES NK_INTEGER */
  {  345,   -3 }, /* (89) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  345,   -3 }, /* (90) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  345,   -3 }, /* (91) db_options ::= db_options PRECISION NK_STRING */
  {  345,   -3 }, /* (92) db_options ::= db_options REPLICA NK_INTEGER */
  {  345,   -3 }, /* (93) db_options ::= db_options VGROUPS NK_INTEGER */
  {  345,   -3 }, /* (94) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  345,   -3 }, /* (95) db_options ::= db_options RETENTIONS retention_list */
  {  345,   -3 }, /* (96) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  345,   -3 }, /* (97) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  345,   -3 }, /* (98) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  345,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  345,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  345,   -3 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  345,   -4 }, /* (102) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  345,   -3 }, /* (103) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  345,   -3 }, /* (104) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  345,   -3 }, /* (105) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  345,   -3 }, /* (106) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  345,   -3 }, /* (107) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  347,   -1 }, /* (108) alter_db_options ::= alter_db_option */
  {  347,   -2 }, /* (109) alter_db_options ::= alter_db_options alter_db_option */
  {  354,   -2 }, /* (110) alter_db_option ::= BUFFER NK_INTEGER */
  {  354,   -2 }, /* (111) alter_db_option ::= CACHEMODEL NK_STRING */
  {  354,   -2 }, /* (112) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  354,   -2 }, /* (113) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  354,   -2 }, /* (114) alter_db_option ::= KEEP integer_list */
  {  354,   -2 }, /* (115) alter_db_option ::= KEEP variable_list */
  {  354,   -2 }, /* (116) alter_db_option ::= PAGES NK_INTEGER */
  {  354,   -2 }, /* (117) alter_db_option ::= REPLICA NK_INTEGER */
  {  354,   -2 }, /* (118) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  354,   -2 }, /* (119) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  354,   -2 }, /* (120) alter_db_option ::= MINROWS NK_INTEGER */
  {  351,   -1 }, /* (121) integer_list ::= NK_INTEGER */
  {  351,   -3 }, /* (122) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  352,   -1 }, /* (123) variable_list ::= NK_VARIABLE */
  {  352,   -3 }, /* (124) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  353,   -1 }, /* (125) retention_list ::= retention */
  {  353,   -3 }, /* (126) retention_list ::= retention_list NK_COMMA retention */
  {  355,   -3 }, /* (127) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  348,    0 }, /* (128) speed_opt ::= */
  {  348,   -2 }, /* (129) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  349,    0 }, /* (130) start_opt ::= */
  {  349,   -3 }, /* (131) start_opt ::= START WITH NK_INTEGER */
  {  349,   -3 }, /* (132) start_opt ::= START WITH NK_STRING */
  {  349,   -4 }, /* (133) start_opt ::= START WITH TIMESTAMP NK_STRING */
  {  350,    0 }, /* (134) end_opt ::= */
  {  350,   -3 }, /* (135) end_opt ::= END WITH NK_INTEGER */
  {  350,   -3 }, /* (136) end_opt ::= END WITH NK_STRING */
  {  350,   -4 }, /* (137) end_opt ::= END WITH TIMESTAMP NK_STRING */
  {  329,   -9 }, /* (138) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  329,   -3 }, /* (139) cmd ::= CREATE TABLE multi_create_clause */
  {  329,   -9 }, /* (140) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  329,   -3 }, /* (141) cmd ::= DROP TABLE multi_drop_clause */
  {  329,   -4 }, /* (142) cmd ::= DROP STABLE exists_opt full_table_name */
  {  329,   -3 }, /* (143) cmd ::= ALTER TABLE alter_table_clause */
  {  329,   -3 }, /* (144) cmd ::= ALTER STABLE alter_table_clause */
  {  363,   -2 }, /* (145) alter_table_clause ::= full_table_name alter_table_options */
  {  363,   -5 }, /* (146) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  363,   -4 }, /* (147) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  363,   -5 }, /* (148) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  363,   -5 }, /* (149) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  363,   -5 }, /* (150) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  363,   -4 }, /* (151) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  363,   -5 }, /* (152) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  363,   -5 }, /* (153) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  363,   -6 }, /* (154) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  360,   -1 }, /* (155) multi_create_clause ::= create_subtable_clause */
  {  360,   -2 }, /* (156) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  368,  -10 }, /* (157) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  362,   -1 }, /* (158) multi_drop_clause ::= drop_table_clause */
  {  362,   -3 }, /* (159) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
  {  371,   -2 }, /* (160) drop_table_clause ::= exists_opt full_table_name */
  {  369,    0 }, /* (161) specific_cols_opt ::= */
  {  369,   -3 }, /* (162) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  356,   -1 }, /* (163) full_table_name ::= table_name */
  {  356,   -3 }, /* (164) full_table_name ::= db_name NK_DOT table_name */
  {  357,   -1 }, /* (165) column_def_list ::= column_def */
  {  357,   -3 }, /* (166) column_def_list ::= column_def_list NK_COMMA column_def */
  {  374,   -2 }, /* (167) column_def ::= column_name type_name */
  {  374,   -4 }, /* (168) column_def ::= column_name type_name COMMENT NK_STRING */
  {  366,   -1 }, /* (169) type_name ::= BOOL */
  {  366,   -1 }, /* (170) type_name ::= TINYINT */
  {  366,   -1 }, /* (171) type_name ::= SMALLINT */
  {  366,   -1 }, /* (172) type_name ::= INT */
  {  366,   -1 }, /* (173) type_name ::= INTEGER */
  {  366,   -1 }, /* (174) type_name ::= BIGINT */
  {  366,   -1 }, /* (175) type_name ::= FLOAT */
  {  366,   -1 }, /* (176) type_name ::= DOUBLE */
  {  366,   -4 }, /* (177) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  366,   -1 }, /* (178) type_name ::= TIMESTAMP */
  {  366,   -4 }, /* (179) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  366,   -2 }, /* (180) type_name ::= TINYINT UNSIGNED */
  {  366,   -2 }, /* (181) type_name ::= SMALLINT UNSIGNED */
  {  366,   -2 }, /* (182) type_name ::= INT UNSIGNED */
  {  366,   -2 }, /* (183) type_name ::= BIGINT UNSIGNED */
  {  366,   -1 }, /* (184) type_name ::= JSON */
  {  366,   -4 }, /* (185) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  366,   -1 }, /* (186) type_name ::= MEDIUMBLOB */
  {  366,   -1 }, /* (187) type_name ::= BLOB */
  {  366,   -4 }, /* (188) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  366,   -1 }, /* (189) type_name ::= DECIMAL */
  {  366,   -4 }, /* (190) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  366,   -6 }, /* (191) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  358,    0 }, /* (192) tags_def_opt ::= */
  {  358,   -1 }, /* (193) tags_def_opt ::= tags_def */
  {  361,   -4 }, /* (194) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  359,    0 }, /* (195) table_options ::= */
  {  359,   -3 }, /* (196) table_options ::= table_options COMMENT NK_STRING */
  {  359,   -3 }, /* (197) table_options ::= table_options MAX_DELAY duration_list */
  {  359,   -3 }, /* (198) table_options ::= table_options WATERMARK duration_list */
  {  359,   -5 }, /* (199) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  359,   -3 }, /* (200) table_options ::= table_options TTL NK_INTEGER */
  {  359,   -5 }, /* (201) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  359,   -3 }, /* (202) table_options ::= table_options DELETE_MARK duration_list */
  {  364,   -1 }, /* (203) alter_table_options ::= alter_table_option */
  {  364,   -2 }, /* (204) alter_table_options ::= alter_table_options alter_table_option */
  {  377,   -2 }, /* (205) alter_table_option ::= COMMENT NK_STRING */
  {  377,   -2 }, /* (206) alter_table_option ::= TTL NK_INTEGER */
  {  375,   -1 }, /* (207) duration_list ::= duration_literal */
  {  375,   -3 }, /* (208) duration_list ::= duration_list NK_COMMA duration_literal */
  {  376,   -1 }, /* (209) rollup_func_list ::= rollup_func_name */
  {  376,   -3 }, /* (210) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  379,   -1 }, /* (211) rollup_func_name ::= function_name */
  {  379,   -1 }, /* (212) rollup_func_name ::= FIRST */
  {  379,   -1 }, /* (213) rollup_func_name ::= LAST */
  {  372,   -1 }, /* (214) col_name_list ::= col_name */
  {  372,   -3 }, /* (215) col_name_list ::= col_name_list NK_COMMA col_name */
  {  381,   -1 }, /* (216) col_name ::= column_name */
  {  329,   -2 }, /* (217) cmd ::= SHOW DNODES */
  {  329,   -2 }, /* (218) cmd ::= SHOW USERS */
  {  329,   -3 }, /* (219) cmd ::= SHOW USER PRIVILEGES */
  {  329,   -2 }, /* (220) cmd ::= SHOW DATABASES */
  {  329,   -4 }, /* (221) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  329,   -4 }, /* (222) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  329,   -3 }, /* (223) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  329,   -2 }, /* (224) cmd ::= SHOW MNODES */
  {  329,   -2 }, /* (225) cmd ::= SHOW QNODES */
  {  329,   -2 }, /* (226) cmd ::= SHOW FUNCTIONS */
  {  329,   -5 }, /* (227) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  329,   -2 }, /* (228) cmd ::= SHOW STREAMS */
  {  329,   -2 }, /* (229) cmd ::= SHOW ACCOUNTS */
  {  329,   -2 }, /* (230) cmd ::= SHOW APPS */
  {  329,   -2 }, /* (231) cmd ::= SHOW CONNECTIONS */
  {  329,   -2 }, /* (232) cmd ::= SHOW LICENCES */
  {  329,   -2 }, /* (233) cmd ::= SHOW GRANTS */
  {  329,   -4 }, /* (234) cmd ::= SHOW CREATE DATABASE db_name */
  {  329,   -4 }, /* (235) cmd ::= SHOW CREATE TABLE full_table_name */
  {  329,   -4 }, /* (236) cmd ::= SHOW CREATE STABLE full_table_name */
  {  329,   -2 }, /* (237) cmd ::= SHOW QUERIES */
  {  329,   -2 }, /* (238) cmd ::= SHOW SCORES */
  {  329,   -2 }, /* (239) cmd ::= SHOW TOPICS */
  {  329,   -2 }, /* (240) cmd ::= SHOW VARIABLES */
  {  329,   -3 }, /* (241) cmd ::= SHOW CLUSTER VARIABLES */
  {  329,   -3 }, /* (242) cmd ::= SHOW LOCAL VARIABLES */
  {  329,   -5 }, /* (243) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  329,   -2 }, /* (244) cmd ::= SHOW BNODES */
  {  329,   -2 }, /* (245) cmd ::= SHOW SNODES */
  {  329,   -2 }, /* (246) cmd ::= SHOW CLUSTER */
  {  329,   -2 }, /* (247) cmd ::= SHOW TRANSACTIONS */
  {  329,   -4 }, /* (248) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  329,   -2 }, /* (249) cmd ::= SHOW CONSUMERS */
  {  329,   -2 }, /* (250) cmd ::= SHOW SUBSCRIPTIONS */
  {  329,   -5 }, /* (251) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  329,   -7 }, /* (252) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  329,   -3 }, /* (253) cmd ::= SHOW VNODES NK_INTEGER */
  {  329,   -3 }, /* (254) cmd ::= SHOW VNODES NK_STRING */
  {  329,   -3 }, /* (255) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  329,   -3 }, /* (256) cmd ::= SHOW CLUSTER ALIVE */
  {  382,    0 }, /* (257) db_name_cond_opt ::= */
  {  382,   -2 }, /* (258) db_name_cond_opt ::= db_name NK_DOT */
  {  383,    0 }, /* (259) like_pattern_opt ::= */
  {  383,   -2 }, /* (260) like_pattern_opt ::= LIKE NK_STRING */
  {  384,   -1 }, /* (261) table_name_cond ::= table_name */
  {  385,    0 }, /* (262) from_db_opt ::= */
  {  385,   -2 }, /* (263) from_db_opt ::= FROM db_name */
  {  386,    0 }, /* (264) tag_list_opt ::= */
  {  386,   -1 }, /* (265) tag_list_opt ::= tag_item */
  {  386,   -3 }, /* (266) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  387,   -1 }, /* (267) tag_item ::= TBNAME */
  {  387,   -1 }, /* (268) tag_item ::= QTAGS */
  {  387,   -1 }, /* (269) tag_item ::= column_name */
  {  387,   -2 }, /* (270) tag_item ::= column_name column_alias */
  {  387,   -3 }, /* (271) tag_item ::= column_name AS column_alias */
  {  329,   -8 }, /* (272) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  329,   -9 }, /* (273) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  329,   -4 }, /* (274) cmd ::= DROP INDEX exists_opt full_index_name */
  {  389,   -1 }, /* (275) full_index_name ::= index_name */
  {  389,   -3 }, /* (276) full_index_name ::= db_name NK_DOT index_name */
  {  390,  -10 }, /* (277) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  390,  -12 }, /* (278) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  392,   -1 }, /* (279) func_list ::= func */
  {  392,   -3 }, /* (280) func_list ::= func_list NK_COMMA func */
  {  395,   -4 }, /* (281) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  396,   -1 }, /* (282) sma_func_name ::= function_name */
  {  396,   -1 }, /* (283) sma_func_name ::= COUNT */
  {  396,   -1 }, /* (284) sma_func_name ::= FIRST */
  {  396,   -1 }, /* (285) sma_func_name ::= LAST */
  {  396,   -1 }, /* (286) sma_func_name ::= LAST_ROW */
  {  394,    0 }, /* (287) sma_stream_opt ::= */
  {  394,   -3 }, /* (288) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  394,   -3 }, /* (289) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  394,   -3 }, /* (290) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  329,   -6 }, /* (291) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  329,   -7 }, /* (292) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  329,   -9 }, /* (293) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  329,   -7 }, /* (294) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  329,   -9 }, /* (295) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  329,   -4 }, /* (296) cmd ::= DROP TOPIC exists_opt topic_name */
  {  329,   -7 }, /* (297) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  329,   -2 }, /* (298) cmd ::= DESC full_table_name */
  {  329,   -2 }, /* (299) cmd ::= DESCRIBE full_table_name */
  {  329,   -3 }, /* (300) cmd ::= RESET QUERY CACHE */
  {  329,   -4 }, /* (301) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  329,   -4 }, /* (302) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
  {  399,    0 }, /* (303) analyze_opt ::= */
  {  399,   -1 }, /* (304) analyze_opt ::= ANALYZE */
  {  400,    0 }, /* (305) explain_options ::= */
  {  400,   -3 }, /* (306) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  400,   -3 }, /* (307) explain_options ::= explain_options RATIO NK_FLOAT */
  {  329,  -11 }, /* (308) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
  {  329,   -4 }, /* (309) cmd ::= DROP FUNCTION exists_opt function_name */
  {  402,    0 }, /* (310) agg_func_opt ::= */
  {  402,   -1 }, /* (311) agg_func_opt ::= AGGREGATE */
  {  403,    0 }, /* (312) bufsize_opt ::= */
  {  403,   -2 }, /* (313) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  404,    0 }, /* (314) language_opt ::= */
  {  404,   -2 }, /* (315) language_opt ::= LANGUAGE NK_STRING */
  {  329,  -12 }, /* (316) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
  {  329,   -4 }, /* (317) cmd ::= DROP STREAM exists_opt stream_name */
  {  407,    0 }, /* (318) col_list_opt ::= */
  {  407,   -3 }, /* (319) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  408,    0 }, /* (320) tag_def_or_ref_opt ::= */
  {  408,   -1 }, /* (321) tag_def_or_ref_opt ::= tags_def */
  {  408,   -4 }, /* (322) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
  {  406,    0 }, /* (323) stream_options ::= */
  {  406,   -3 }, /* (324) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  406,   -3 }, /* (325) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  406,   -4 }, /* (326) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  406,   -3 }, /* (327) stream_options ::= stream_options WATERMARK duration_literal */
  {  406,   -4 }, /* (328) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  406,   -3 }, /* (329) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  406,   -3 }, /* (330) stream_options ::= stream_options DELETE_MARK duration_literal */
  {  406,   -4 }, /* (331) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
  {  409,    0 }, /* (332) subtable_opt ::= */
  {  409,   -4 }, /* (333) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  329,   -3 }, /* (334) cmd ::= KILL CONNECTION NK_INTEGER */
  {  329,   -3 }, /* (335) cmd ::= KILL QUERY NK_STRING */
  {  329,   -3 }, /* (336) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  329,   -2 }, /* (337) cmd ::= BALANCE VGROUP */
  {  329,   -4 }, /* (338) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  329,   -4 }, /* (339) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  329,   -3 }, /* (340) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  411,   -2 }, /* (341) dnode_list ::= DNODE NK_INTEGER */
  {  411,   -3 }, /* (342) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  329,   -4 }, /* (343) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  329,   -1 }, /* (344) cmd ::= query_or_subquery */
  {  329,   -1 }, /* (345) cmd ::= insert_query */
  {  401,   -7 }, /* (346) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  401,   -4 }, /* (347) insert_query ::= INSERT INTO full_table_name query_or_subquery */
  {  332,   -1 }, /* (348) literal ::= NK_INTEGER */
  {  332,   -1 }, /* (349) literal ::= NK_FLOAT */
  {  332,   -1 }, /* (350) literal ::= NK_STRING */
  {  332,   -1 }, /* (351) literal ::= NK_BOOL */
  {  332,   -2 }, /* (352) literal ::= TIMESTAMP NK_STRING */
  {  332,   -1 }, /* (353) literal ::= duration_literal */
  {  332,   -1 }, /* (354) literal ::= NULL */
  {  332,   -1 }, /* (355) literal ::= NK_QUESTION */
  {  378,   -1 }, /* (356) duration_literal ::= NK_VARIABLE */
  {  413,   -1 }, /* (357) signed ::= NK_INTEGER */
  {  413,   -2 }, /* (358) signed ::= NK_PLUS NK_INTEGER */
  {  413,   -2 }, /* (359) signed ::= NK_MINUS NK_INTEGER */
  {  413,   -1 }, /* (360) signed ::= NK_FLOAT */
  {  413,   -2 }, /* (361) signed ::= NK_PLUS NK_FLOAT */
  {  413,   -2 }, /* (362) signed ::= NK_MINUS NK_FLOAT */
  {  367,   -1 }, /* (363) signed_literal ::= signed */
  {  367,   -1 }, /* (364) signed_literal ::= NK_STRING */
  {  367,   -1 }, /* (365) signed_literal ::= NK_BOOL */
  {  367,   -2 }, /* (366) signed_literal ::= TIMESTAMP NK_STRING */
  {  367,   -1 }, /* (367) signed_literal ::= duration_literal */
  {  367,   -1 }, /* (368) signed_literal ::= NULL */
  {  367,   -1 }, /* (369) signed_literal ::= literal_func */
  {  367,   -1 }, /* (370) signed_literal ::= NK_QUESTION */
  {  415,   -1 }, /* (371) literal_list ::= signed_literal */
  {  415,   -3 }, /* (372) literal_list ::= literal_list NK_COMMA signed_literal */
  {  340,   -1 }, /* (373) db_name ::= NK_ID */
  {  373,   -1 }, /* (374) table_name ::= NK_ID */
  {  365,   -1 }, /* (375) column_name ::= NK_ID */
  {  380,   -1 }, /* (376) function_name ::= NK_ID */
  {  416,   -1 }, /* (377) table_alias ::= NK_ID */
  {  388,   -1 }, /* (378) column_alias ::= NK_ID */
  {  334,   -1 }, /* (379) user_name ::= NK_ID */
  {  341,   -1 }, /* (380) topic_name ::= NK_ID */
  {  405,   -1 }, /* (381) stream_name ::= NK_ID */
  {  398,   -1 }, /* (382) cgroup_name ::= NK_ID */
  {  391,   -1 }, /* (383) index_name ::= NK_ID */
  {  417,   -1 }, /* (384) expr_or_subquery ::= expression */
  {  410,   -1 }, /* (385) expression ::= literal */
  {  410,   -1 }, /* (386) expression ::= pseudo_column */
  {  410,   -1 }, /* (387) expression ::= column_reference */
  {  410,   -1 }, /* (388) expression ::= function_expression */
  {  410,   -1 }, /* (389) expression ::= case_when_expression */
  {  410,   -3 }, /* (390) expression ::= NK_LP expression NK_RP */
  {  410,   -2 }, /* (391) expression ::= NK_PLUS expr_or_subquery */
  {  410,   -2 }, /* (392) expression ::= NK_MINUS expr_or_subquery */
  {  410,   -3 }, /* (393) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  410,   -3 }, /* (394) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  410,   -3 }, /* (395) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  410,   -3 }, /* (396) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  410,   -3 }, /* (397) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  410,   -3 }, /* (398) expression ::= column_reference NK_ARROW NK_STRING */
  {  410,   -3 }, /* (399) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  410,   -3 }, /* (400) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  370,   -1 }, /* (401) expression_list ::= expr_or_subquery */
  {  370,   -3 }, /* (402) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  419,   -1 }, /* (403) column_reference ::= column_name */
  {  419,   -3 }, /* (404) column_reference ::= table_name NK_DOT column_name */
  {  418,   -1 }, /* (405) pseudo_column ::= ROWTS */
  {  418,   -1 }, /* (406) pseudo_column ::= TBNAME */
  {  418,   -3 }, /* (407) pseudo_column ::= table_name NK_DOT TBNAME */
  {  418,   -1 }, /* (408) pseudo_column ::= QSTART */
  {  418,   -1 }, /* (409) pseudo_column ::= QEND */
  {  418,   -1 }, /* (410) pseudo_column ::= QDURATION */
  {  418,   -1 }, /* (411) pseudo_column ::= WSTART */
  {  418,   -1 }, /* (412) pseudo_column ::= WEND */
  {  418,   -1 }, /* (413) pseudo_column ::= WDURATION */
  {  418,   -1 }, /* (414) pseudo_column ::= IROWTS */
  {  418,   -1 }, /* (415) pseudo_column ::= ISFILLED */
  {  418,   -1 }, /* (416) pseudo_column ::= QTAGS */
  {  420,   -4 }, /* (417) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  420,   -4 }, /* (418) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  420,   -6 }, /* (419) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  420,   -1 }, /* (420) function_expression ::= literal_func */
  {  414,   -3 }, /* (421) literal_func ::= noarg_func NK_LP NK_RP */
  {  414,   -1 }, /* (422) literal_func ::= NOW */
  {  424,   -1 }, /* (423) noarg_func ::= NOW */
  {  424,   -1 }, /* (424) noarg_func ::= TODAY */
  {  424,   -1 }, /* (425) noarg_func ::= TIMEZONE */
  {  424,   -1 }, /* (426) noarg_func ::= DATABASE */
  {  424,   -1 }, /* (427) noarg_func ::= CLIENT_VERSION */
  {  424,   -1 }, /* (428) noarg_func ::= SERVER_VERSION */
  {  424,   -1 }, /* (429) noarg_func ::= SERVER_STATUS */
  {  424,   -1 }, /* (430) noarg_func ::= CURRENT_USER */
  {  424,   -1 }, /* (431) noarg_func ::= USER */
  {  422,   -1 }, /* (432) star_func ::= COUNT */
  {  422,   -1 }, /* (433) star_func ::= FIRST */
  {  422,   -1 }, /* (434) star_func ::= LAST */
  {  422,   -1 }, /* (435) star_func ::= LAST_ROW */
  {  423,   -1 }, /* (436) star_func_para_list ::= NK_STAR */
  {  423,   -1 }, /* (437) star_func_para_list ::= other_para_list */
  {  425,   -1 }, /* (438) other_para_list ::= star_func_para */
  {  425,   -3 }, /* (439) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  426,   -1 }, /* (440) star_func_para ::= expr_or_subquery */
  {  426,   -3 }, /* (441) star_func_para ::= table_name NK_DOT NK_STAR */
  {  421,   -4 }, /* (442) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  421,   -5 }, /* (443) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  427,   -1 }, /* (444) when_then_list ::= when_then_expr */
  {  427,   -2 }, /* (445) when_then_list ::= when_then_list when_then_expr */
  {  430,   -4 }, /* (446) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  428,    0 }, /* (447) case_when_else_opt ::= */
  {  428,   -2 }, /* (448) case_when_else_opt ::= ELSE common_expression */
  {  431,   -3 }, /* (449) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  431,   -5 }, /* (450) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  431,   -6 }, /* (451) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  431,   -3 }, /* (452) predicate ::= expr_or_subquery IS NULL */
  {  431,   -4 }, /* (453) predicate ::= expr_or_subquery IS NOT NULL */
  {  431,   -3 }, /* (454) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  432,   -1 }, /* (455) compare_op ::= NK_LT */
  {  432,   -1 }, /* (456) compare_op ::= NK_GT */
  {  432,   -1 }, /* (457) compare_op ::= NK_LE */
  {  432,   -1 }, /* (458) compare_op ::= NK_GE */
  {  432,   -1 }, /* (459) compare_op ::= NK_NE */
  {  432,   -1 }, /* (460) compare_op ::= NK_EQ */
  {  432,   -1 }, /* (461) compare_op ::= LIKE */
  {  432,   -2 }, /* (462) compare_op ::= NOT LIKE */
  {  432,   -1 }, /* (463) compare_op ::= MATCH */
  {  432,   -1 }, /* (464) compare_op ::= NMATCH */
  {  432,   -1 }, /* (465) compare_op ::= CONTAINS */
  {  433,   -1 }, /* (466) in_op ::= IN */
  {  433,   -2 }, /* (467) in_op ::= NOT IN */
  {  434,   -3 }, /* (468) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  435,   -1 }, /* (469) boolean_value_expression ::= boolean_primary */
  {  435,   -2 }, /* (470) boolean_value_expression ::= NOT boolean_primary */
  {  435,   -3 }, /* (471) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  435,   -3 }, /* (472) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  436,   -1 }, /* (473) boolean_primary ::= predicate */
  {  436,   -3 }, /* (474) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  429,   -1 }, /* (475) common_expression ::= expr_or_subquery */
  {  429,   -1 }, /* (476) common_expression ::= boolean_value_expression */
  {  437,    0 }, /* (477) from_clause_opt ::= */
  {  437,   -2 }, /* (478) from_clause_opt ::= FROM table_reference_list */
  {  438,   -1 }, /* (479) table_reference_list ::= table_reference */
  {  438,   -3 }, /* (480) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  439,   -1 }, /* (481) table_reference ::= table_primary */
  {  439,   -1 }, /* (482) table_reference ::= joined_table */
  {  440,   -2 }, /* (483) table_primary ::= table_name alias_opt */
  {  440,   -4 }, /* (484) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  440,   -2 }, /* (485) table_primary ::= subquery alias_opt */
  {  440,   -1 }, /* (486) table_primary ::= parenthesized_joined_table */
  {  442,    0 }, /* (487) alias_opt ::= */
  {  442,   -1 }, /* (488) alias_opt ::= table_alias */
  {  442,   -2 }, /* (489) alias_opt ::= AS table_alias */
  {  444,   -3 }, /* (490) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  444,   -3 }, /* (491) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  441,   -6 }, /* (492) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  445,    0 }, /* (493) join_type ::= */
  {  445,   -1 }, /* (494) join_type ::= INNER */
  {  447,  -12 }, /* (495) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  448,    0 }, /* (496) set_quantifier_opt ::= */
  {  448,   -1 }, /* (497) set_quantifier_opt ::= DISTINCT */
  {  448,   -1 }, /* (498) set_quantifier_opt ::= ALL */
  {  449,   -1 }, /* (499) select_list ::= select_item */
  {  449,   -3 }, /* (500) select_list ::= select_list NK_COMMA select_item */
  {  457,   -1 }, /* (501) select_item ::= NK_STAR */
  {  457,   -1 }, /* (502) select_item ::= common_expression */
  {  457,   -2 }, /* (503) select_item ::= common_expression column_alias */
  {  457,   -3 }, /* (504) select_item ::= common_expression AS column_alias */
  {  457,   -3 }, /* (505) select_item ::= table_name NK_DOT NK_STAR */
  {  412,    0 }, /* (506) where_clause_opt ::= */
  {  412,   -2 }, /* (507) where_clause_opt ::= WHERE search_condition */
  {  450,    0 }, /* (508) partition_by_clause_opt ::= */
  {  450,   -3 }, /* (509) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  458,   -1 }, /* (510) partition_list ::= partition_item */
  {  458,   -3 }, /* (511) partition_list ::= partition_list NK_COMMA partition_item */
  {  459,   -1 }, /* (512) partition_item ::= expr_or_subquery */
  {  459,   -2 }, /* (513) partition_item ::= expr_or_subquery column_alias */
  {  459,   -3 }, /* (514) partition_item ::= expr_or_subquery AS column_alias */
  {  454,    0 }, /* (515) twindow_clause_opt ::= */
  {  454,   -6 }, /* (516) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  454,   -4 }, /* (517) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  454,   -6 }, /* (518) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  454,   -8 }, /* (519) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  454,   -7 }, /* (520) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  393,    0 }, /* (521) sliding_opt ::= */
  {  393,   -4 }, /* (522) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  453,    0 }, /* (523) fill_opt ::= */
  {  453,   -4 }, /* (524) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  453,   -6 }, /* (525) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  453,   -6 }, /* (526) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
  {  460,   -1 }, /* (527) fill_mode ::= NONE */
  {  460,   -1 }, /* (528) fill_mode ::= PREV */
  {  460,   -1 }, /* (529) fill_mode ::= NULL */
  {  460,   -1 }, /* (530) fill_mode ::= NULL_F */
  {  460,   -1 }, /* (531) fill_mode ::= LINEAR */
  {  460,   -1 }, /* (532) fill_mode ::= NEXT */
  {  455,    0 }, /* (533) group_by_clause_opt ::= */
  {  455,   -3 }, /* (534) group_by_clause_opt ::= GROUP BY group_by_list */
  {  461,   -1 }, /* (535) group_by_list ::= expr_or_subquery */
  {  461,   -3 }, /* (536) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  456,    0 }, /* (537) having_clause_opt ::= */
  {  456,   -2 }, /* (538) having_clause_opt ::= HAVING search_condition */
  {  451,    0 }, /* (539) range_opt ::= */
  {  451,   -6 }, /* (540) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  452,    0 }, /* (541) every_opt ::= */
  {  452,   -4 }, /* (542) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  462,   -4 }, /* (543) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  463,   -1 }, /* (544) query_simple ::= query_specification */
  {  463,   -1 }, /* (545) query_simple ::= union_query_expression */
  {  467,   -4 }, /* (546) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  467,   -3 }, /* (547) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  468,   -1 }, /* (548) query_simple_or_subquery ::= query_simple */
  {  468,   -1 }, /* (549) query_simple_or_subquery ::= subquery */
  {  397,   -1 }, /* (550) query_or_subquery ::= query_expression */
  {  397,   -1 }, /* (551) query_or_subquery ::= subquery */
  {  464,    0 }, /* (552) order_by_clause_opt ::= */
  {  464,   -3 }, /* (553) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  465,    0 }, /* (554) slimit_clause_opt ::= */
  {  465,   -2 }, /* (555) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  465,   -4 }, /* (556) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  465,   -4 }, /* (557) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  466,    0 }, /* (558) limit_clause_opt ::= */
  {  466,   -2 }, /* (559) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  466,   -4 }, /* (560) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  466,   -4 }, /* (561) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  443,   -3 }, /* (562) subquery ::= NK_LP query_expression NK_RP */
  {  443,   -3 }, /* (563) subquery ::= NK_LP subquery NK_RP */
  {  446,   -1 }, /* (564) search_condition ::= common_expression */
  {  469,   -1 }, /* (565) sort_specification_list ::= sort_specification */
  {  469,   -3 }, /* (566) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  470,   -3 }, /* (567) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  471,    0 }, /* (568) ordering_specification_opt ::= */
  {  471,   -1 }, /* (569) ordering_specification_opt ::= ASC */
  {  471,   -1 }, /* (570) ordering_specification_opt ::= DESC */
  {  472,    0 }, /* (571) null_ordering_opt ::= */
  {  472,   -2 }, /* (572) null_ordering_opt ::= NULLS FIRST */
  {  472,   -2 }, /* (573) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,330,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,331,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,330,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,332,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,333,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,331,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,333,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,332,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy63, &yymsp[-1].minor.yy0, yymsp[0].minor.yy707); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy63, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy63, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy63, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy63); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy707 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy707 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy393, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy63); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy393, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy63); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy393 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy393 = yymsp[0].minor.yy393; }
  yymsp[0].minor.yy393 = yylhsminor.yy393;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy393 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy393 = yymsp[-2].minor.yy393 | yymsp[0].minor.yy393; }
  yymsp[-2].minor.yy393 = yylhsminor.yy393;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy393 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy393 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy63 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy63 = yylhsminor.yy63;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy63 = yymsp[-2].minor.yy63; }
  yymsp[-2].minor.yy63 = yylhsminor.yy63;
        break;
      case 42: /* priv_level ::= topic_name */
      case 282: /* sma_func_name ::= function_name */ yytestcase(yyruleno==282);
      case 488: /* alias_opt ::= table_alias */ yytestcase(yyruleno==488);
{ yylhsminor.yy63 = yymsp[0].minor.yy63; }
  yymsp[0].minor.yy63 = yylhsminor.yy63;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy63, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy669); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy63, yymsp[0].minor.yy669); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 283: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==283);
      case 284: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==284);
      case 285: /* sma_func_name ::= LAST */ yytestcase(yyruleno==285);
      case 286: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==286);
      case 373: /* db_name ::= NK_ID */ yytestcase(yyruleno==373);
      case 374: /* table_name ::= NK_ID */ yytestcase(yyruleno==374);
      case 375: /* column_name ::= NK_ID */ yytestcase(yyruleno==375);
      case 376: /* function_name ::= NK_ID */ yytestcase(yyruleno==376);
      case 377: /* table_alias ::= NK_ID */ yytestcase(yyruleno==377);
      case 378: /* column_alias ::= NK_ID */ yytestcase(yyruleno==378);
      case 379: /* user_name ::= NK_ID */ yytestcase(yyruleno==379);
      case 380: /* topic_name ::= NK_ID */ yytestcase(yyruleno==380);
      case 381: /* stream_name ::= NK_ID */ yytestcase(yyruleno==381);
      case 382: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==382);
      case 383: /* index_name ::= NK_ID */ yytestcase(yyruleno==383);
      case 423: /* noarg_func ::= NOW */ yytestcase(yyruleno==423);
      case 424: /* noarg_func ::= TODAY */ yytestcase(yyruleno==424);
      case 425: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==425);
      case 426: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==426);
      case 427: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==427);
      case 428: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==428);
      case 429: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==429);
      case 430: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==430);
      case 431: /* noarg_func ::= USER */ yytestcase(yyruleno==431);
      case 432: /* star_func ::= COUNT */ yytestcase(yyruleno==432);
      case 433: /* star_func ::= FIRST */ yytestcase(yyruleno==433);
      case 434: /* star_func ::= LAST */ yytestcase(yyruleno==434);
      case 435: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==435);
{ yylhsminor.yy63 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy63 = yylhsminor.yy63;
        break;
      case 54: /* force_opt ::= */
      case 74: /* not_exists_opt ::= */ yytestcase(yyruleno==74);
      case 76: /* exists_opt ::= */ yytestcase(yyruleno==76);
      case 303: /* analyze_opt ::= */ yytestcase(yyruleno==303);
      case 310: /* agg_func_opt ::= */ yytestcase(yyruleno==310);
      case 496: /* set_quantifier_opt ::= */ yytestcase(yyruleno==496);
{ yymsp[1].minor.yy669 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 304: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==304);
      case 311: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==311);
      case 497: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==497);
{ yymsp[0].minor.yy669 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy669, &yymsp[-1].minor.yy63, yymsp[0].minor.yy828); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy669, &yymsp[0].minor.yy63); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy63); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy63, yymsp[0].minor.yy828); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy63); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy63, yymsp[0].minor.yy332); }
        break;
      case 72: /* cmd ::= COMPACT DATABASE db_name start_opt end_opt */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[-2].minor.yy63, yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 73: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy669 = true; }
        break;
      case 75: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy669 = true; }
        break;
      case 77: /* db_options ::= */
{ yymsp[1].minor.yy828 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 78: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 79: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 80: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 81: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 82: /* db_options ::= db_options DURATION NK_INTEGER */
      case 83: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==83);
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 84: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 85: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 86: /* db_options ::= db_options KEEP integer_list */
      case 87: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==87);
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_KEEP, yymsp[0].minor.yy222); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 88: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 89: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 90: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 91: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 92: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 93: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 94: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 95: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_RETENTIONS, yymsp[0].minor.yy222); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 96: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 97: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 98: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-3].minor.yy828, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-3].minor.yy828, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 103: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 104: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 105: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 106: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 107: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 108: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy828 = createAlterDatabaseOptions(pCxt); yylhsminor.yy828 = setAlterDatabaseOption(pCxt, yylhsminor.yy828, &yymsp[0].minor.yy233); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 109: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy828 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy828, &yymsp[0].minor.yy233); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 110: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy233.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= KEEP integer_list */
      case 115: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==115);
{ yymsp[-1].minor.yy233.type = DB_OPTION_KEEP; yymsp[-1].minor.yy233.pList = yymsp[0].minor.yy222; }
        break;
      case 116: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_PAGES; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_WAL; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* alter_db_option ::= MINROWS NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_MINROWS; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 121: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy222 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy222 = yylhsminor.yy222;
        break;
      case 122: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 342: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==342);
{ yylhsminor.yy222 = addNodeToList(pCxt, yymsp[-2].minor.yy222, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy222 = yylhsminor.yy222;
        break;
      case 123: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy222 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy222 = yylhsminor.yy222;
        break;
      case 124: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy222 = addNodeToList(pCxt, yymsp[-2].minor.yy222, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy222 = yylhsminor.yy222;
        break;
      case 125: /* retention_list ::= retention */
      case 155: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==155);
      case 158: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==158);
      case 165: /* column_def_list ::= column_def */ yytestcase(yyruleno==165);
      case 209: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==209);
      case 214: /* col_name_list ::= col_name */ yytestcase(yyruleno==214);
      case 265: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==265);
      case 279: /* func_list ::= func */ yytestcase(yyruleno==279);
      case 371: /* literal_list ::= signed_literal */ yytestcase(yyruleno==371);
      case 438: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==438);
      case 444: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==444);
      case 499: /* select_list ::= select_item */ yytestcase(yyruleno==499);
      case 510: /* partition_list ::= partition_item */ yytestcase(yyruleno==510);
      case 565: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==565);
{ yylhsminor.yy222 = createNodeList(pCxt, yymsp[0].minor.yy828); }
  yymsp[0].minor.yy222 = yylhsminor.yy222;
        break;
      case 126: /* retention_list ::= retention_list NK_COMMA retention */
      case 159: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==159);
      case 166: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==166);
      case 210: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==210);
      case 215: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==215);
      case 266: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==266);
      case 280: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==280);
      case 372: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==372);
      case 439: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==439);
      case 500: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==500);
      case 511: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==511);
      case 566: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==566);
{ yylhsminor.yy222 = addNodeToList(pCxt, yymsp[-2].minor.yy222, yymsp[0].minor.yy828); }
  yymsp[-2].minor.yy222 = yylhsminor.yy222;
        break;
      case 127: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy828 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 128: /* speed_opt ::= */
      case 312: /* bufsize_opt ::= */ yytestcase(yyruleno==312);
{ yymsp[1].minor.yy332 = 0; }
        break;
      case 129: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 313: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==313);
{ yymsp[-1].minor.yy332 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 130: /* start_opt ::= */
      case 134: /* end_opt ::= */ yytestcase(yyruleno==134);
      case 259: /* like_pattern_opt ::= */ yytestcase(yyruleno==259);
      case 332: /* subtable_opt ::= */ yytestcase(yyruleno==332);
      case 447: /* case_when_else_opt ::= */ yytestcase(yyruleno==447);
      case 477: /* from_clause_opt ::= */ yytestcase(yyruleno==477);
      case 506: /* where_clause_opt ::= */ yytestcase(yyruleno==506);
      case 515: /* twindow_clause_opt ::= */ yytestcase(yyruleno==515);
      case 521: /* sliding_opt ::= */ yytestcase(yyruleno==521);
      case 523: /* fill_opt ::= */ yytestcase(yyruleno==523);
      case 537: /* having_clause_opt ::= */ yytestcase(yyruleno==537);
      case 539: /* range_opt ::= */ yytestcase(yyruleno==539);
      case 541: /* every_opt ::= */ yytestcase(yyruleno==541);
      case 554: /* slimit_clause_opt ::= */ yytestcase(yyruleno==554);
      case 558: /* limit_clause_opt ::= */ yytestcase(yyruleno==558);
{ yymsp[1].minor.yy828 = NULL; }
        break;
      case 131: /* start_opt ::= START WITH NK_INTEGER */
      case 135: /* end_opt ::= END WITH NK_INTEGER */ yytestcase(yyruleno==135);
{ yymsp[-2].minor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 132: /* start_opt ::= START WITH NK_STRING */
      case 136: /* end_opt ::= END WITH NK_STRING */ yytestcase(yyruleno==136);
{ yymsp[-2].minor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 133: /* start_opt ::= START WITH TIMESTAMP NK_STRING */
      case 137: /* end_opt ::= END WITH TIMESTAMP NK_STRING */ yytestcase(yyruleno==137);
{ yymsp[-3].minor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 138: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 140: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==140);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy669, yymsp[-5].minor.yy828, yymsp[-3].minor.yy222, yymsp[-1].minor.yy222, yymsp[0].minor.yy828); }
        break;
      case 139: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy222); }
        break;
      case 141: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy222); }
        break;
      case 142: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy669, yymsp[0].minor.yy828); }
        break;
      case 143: /* cmd ::= ALTER TABLE alter_table_clause */
      case 344: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==344);
      case 345: /* cmd ::= insert_query */ yytestcase(yyruleno==345);
{ pCxt->pRootNode = yymsp[0].minor.yy828; }
        break;
      case 144: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy828); }
        break;
      case 145: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy828 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 146: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy828 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy828, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy63, yymsp[0].minor.yy686); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 147: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy828 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy828, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy63); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 148: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy828 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy828, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy63, yymsp[0].minor.yy686); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 149: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy828 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy828, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy63, &yymsp[0].minor.yy63); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 150: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy828 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy828, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy63, yymsp[0].minor.yy686); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 151: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy828 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy828, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy63); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 152: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy828 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy828, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy63, yymsp[0].minor.yy686); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 153: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy828 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy828, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy63, &yymsp[0].minor.yy63); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 154: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy828 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy828, &yymsp[-2].minor.yy63, yymsp[0].minor.yy828); }
  yymsp[-5].minor.yy828 = yylhsminor.yy828;
        break;
      case 156: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 445: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==445);
{ yylhsminor.yy222 = addNodeToList(pCxt, yymsp[-1].minor.yy222, yymsp[0].minor.yy828); }
  yymsp[-1].minor.yy222 = yylhsminor.yy222;
        break;
      case 157: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy828 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy669, yymsp[-8].minor.yy828, yymsp[-6].minor.yy828, yymsp[-5].minor.yy222, yymsp[-2].minor.yy222, yymsp[0].minor.yy828); }
  yymsp[-9].minor.yy828 = yylhsminor.yy828;
        break;
      case 160: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy828 = createDropTableClause(pCxt, yymsp[-1].minor.yy669, yymsp[0].minor.yy828); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 161: /* specific_cols_opt ::= */
      case 192: /* tags_def_opt ::= */ yytestcase(yyruleno==192);
      case 264: /* tag_list_opt ::= */ yytestcase(yyruleno==264);
      case 318: /* col_list_opt ::= */ yytestcase(yyruleno==318);
      case 320: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==320);
      case 508: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==508);
      case 533: /* group_by_clause_opt ::= */ yytestcase(yyruleno==533);
      case 552: /* order_by_clause_opt ::= */ yytestcase(yyruleno==552);
{ yymsp[1].minor.yy222 = NULL; }
        break;
      case 162: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 319: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==319);
{ yymsp[-2].minor.yy222 = yymsp[-1].minor.yy222; }
        break;
      case 163: /* full_table_name ::= table_name */
{ yylhsminor.yy828 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy63, NULL); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 164: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy828 = createRealTableNode(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy63, NULL); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 167: /* column_def ::= column_name type_name */
{ yylhsminor.yy828 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy63, yymsp[0].minor.yy686, NULL); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 168: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy828 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy63, yymsp[-2].minor.yy686, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 169: /* type_name ::= BOOL */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 170: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 171: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 172: /* type_name ::= INT */
      case 173: /* type_name ::= INTEGER */ yytestcase(yyruleno==173);
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 174: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 175: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 176: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 177: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy686 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 178: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 179: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy686 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 180: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy686 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 181: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy686 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 182: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy686 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 183: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy686 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 184: /* type_name ::= JSON */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 185: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy686 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 186: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 187: /* type_name ::= BLOB */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 188: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy686 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 189: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 190: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy686 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 191: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy686 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 193: /* tags_def_opt ::= tags_def */
      case 321: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==321);
      case 437: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==437);
{ yylhsminor.yy222 = yymsp[0].minor.yy222; }
  yymsp[0].minor.yy222 = yylhsminor.yy222;
        break;
      case 194: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 322: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==322);
{ yymsp[-3].minor.yy222 = yymsp[-1].minor.yy222; }
        break;
      case 195: /* table_options ::= */
{ yymsp[1].minor.yy828 = createDefaultTableOptions(pCxt); }
        break;
      case 196: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-2].minor.yy828, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 197: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-2].minor.yy828, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy222); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 198: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-2].minor.yy828, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy222); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 199: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-4].minor.yy828, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy222); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 200: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-2].minor.yy828, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 201: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-4].minor.yy828, TABLE_OPTION_SMA, yymsp[-1].minor.yy222); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 202: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-2].minor.yy828, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy222); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 203: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy828 = createAlterTableOptions(pCxt); yylhsminor.yy828 = setTableOption(pCxt, yylhsminor.yy828, yymsp[0].minor.yy233.type, &yymsp[0].minor.yy233.val); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 204: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-1].minor.yy828, yymsp[0].minor.yy233.type, &yymsp[0].minor.yy233.val); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 205: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy233.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 206: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy233.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 207: /* duration_list ::= duration_literal */
      case 401: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==401);
{ yylhsminor.yy222 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy828)); }
  yymsp[0].minor.yy222 = yylhsminor.yy222;
        break;
      case 208: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 402: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==402);
{ yylhsminor.yy222 = addNodeToList(pCxt, yymsp[-2].minor.yy222, releaseRawExprNode(pCxt, yymsp[0].minor.yy828)); }
  yymsp[-2].minor.yy222 = yylhsminor.yy222;
        break;
      case 211: /* rollup_func_name ::= function_name */
{ yylhsminor.yy828 = createFunctionNode(pCxt, &yymsp[0].minor.yy63, NULL); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 212: /* rollup_func_name ::= FIRST */
      case 213: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==213);
      case 268: /* tag_item ::= QTAGS */ yytestcase(yyruleno==268);
{ yylhsminor.yy828 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 216: /* col_name ::= column_name */
      case 269: /* tag_item ::= column_name */ yytestcase(yyruleno==269);
{ yylhsminor.yy828 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy63); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 217: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 218: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 219: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 220: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 221: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy828, yymsp[0].minor.yy828, OP_TYPE_LIKE); }
        break;
      case 222: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy828, yymsp[0].minor.yy828, OP_TYPE_LIKE); }
        break;
      case 223: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy828, NULL, OP_TYPE_LIKE); }
        break;
      case 224: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 225: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 226: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 227: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy828, yymsp[-1].minor.yy828, OP_TYPE_EQUAL); }
        break;
      case 228: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 229: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 230: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 231: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 232: /* cmd ::= SHOW LICENCES */
      case 233: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==233);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 234: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy63); }
        break;
      case 235: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy828); }
        break;
      case 236: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy828); }
        break;
      case 237: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 238: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 239: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 240: /* cmd ::= SHOW VARIABLES */
      case 241: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==241);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 242: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 243: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy828); }
        break;
      case 244: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 245: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 246: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 247: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 248: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy828); }
        break;
      case 249: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 250: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 251: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy828, yymsp[-1].minor.yy828, OP_TYPE_EQUAL); }
        break;
      case 252: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy828, yymsp[0].minor.yy828, yymsp[-3].minor.yy222); }
        break;
      case 253: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 254: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 255: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy828,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 256: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 257: /* db_name_cond_opt ::= */
      case 262: /* from_db_opt ::= */ yytestcase(yyruleno==262);
{ yymsp[1].minor.yy828 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 258: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy828 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy63); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 260: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 261: /* table_name_cond ::= table_name */
{ yylhsminor.yy828 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy63); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 263: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy828 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy63); }
        break;
      case 267: /* tag_item ::= TBNAME */
{ yylhsminor.yy828 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 270: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy828 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy63), &yymsp[0].minor.yy63); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 271: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy828 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy63), &yymsp[0].minor.yy63); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 272: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy669, yymsp[-3].minor.yy828, yymsp[-1].minor.yy828, NULL, yymsp[0].minor.yy828); }
        break;
      case 273: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy669, yymsp[-5].minor.yy828, yymsp[-3].minor.yy828, yymsp[-1].minor.yy222, NULL); }
        break;
      case 274: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy669, yymsp[0].minor.yy828); }
        break;
      case 275: /* full_index_name ::= index_name */
{ yylhsminor.yy828 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy63); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 276: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy828 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy63); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 277: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy828 = createIndexOption(pCxt, yymsp[-7].minor.yy222, releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), NULL, yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 278: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy828 = createIndexOption(pCxt, yymsp[-9].minor.yy222, releaseRawExprNode(pCxt, yymsp[-5].minor.yy828), releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 281: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy828 = createFunctionNode(pCxt, &yymsp[-3].minor.yy63, yymsp[-1].minor.yy222); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 287: /* sma_stream_opt ::= */
      case 323: /* stream_options ::= */ yytestcase(yyruleno==323);
{ yymsp[1].minor.yy828 = createStreamOptions(pCxt); }
        break;
      case 288: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy828)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy828); yylhsminor.yy828 = yymsp[-2].minor.yy828; }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 289: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy828)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy828); yylhsminor.yy828 = yymsp[-2].minor.yy828; }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 290: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy828)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy828); yylhsminor.yy828 = yymsp[-2].minor.yy828; }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 291: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy669, &yymsp[-2].minor.yy63, yymsp[0].minor.yy828); }
        break;
      case 292: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy669, &yymsp[-3].minor.yy63, &yymsp[0].minor.yy63, false); }
        break;
      case 293: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy669, &yymsp[-5].minor.yy63, &yymsp[0].minor.yy63, true); }
        break;
      case 294: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy669, &yymsp[-3].minor.yy63, yymsp[0].minor.yy828, false); }
        break;
      case 295: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy669, &yymsp[-5].minor.yy63, yymsp[0].minor.yy828, true); }
        break;
      case 296: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy669, &yymsp[0].minor.yy63); }
        break;
      case 297: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy669, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy63); }
        break;
      case 298: /* cmd ::= DESC full_table_name */
      case 299: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==299);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy828); }
        break;
      case 300: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 301: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 302: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==302);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy669, yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 305: /* explain_options ::= */
{ yymsp[1].minor.yy828 = createDefaultExplainOptions(pCxt); }
        break;
      case 306: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy828 = setExplainVerbose(pCxt, yymsp[-2].minor.yy828, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 307: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy828 = setExplainRatio(pCxt, yymsp[-2].minor.yy828, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 308: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy669, yymsp[-9].minor.yy669, &yymsp[-6].minor.yy63, &yymsp[-4].minor.yy0, yymsp[-2].minor.yy686, yymsp[-1].minor.yy332, &yymsp[0].minor.yy63); }
        break;
      case 309: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy669, &yymsp[0].minor.yy63); }
        break;
      case 314: /* language_opt ::= */
{ yymsp[1].minor.yy63 = nil_token; }
        break;
      case 315: /* language_opt ::= LANGUAGE NK_STRING */
{ yymsp[-1].minor.yy63 = yymsp[0].minor.yy0; }
        break;
      case 316: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy669, &yymsp[-8].minor.yy63, yymsp[-5].minor.yy828, yymsp[-7].minor.yy828, yymsp[-3].minor.yy222, yymsp[-2].minor.yy828, yymsp[0].minor.yy828, yymsp[-4].minor.yy222); }
        break;
      case 317: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy669, &yymsp[0].minor.yy63); }
        break;
      case 324: /* stream_options ::= stream_options TRIGGER AT_ONCE */
      case 325: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */ yytestcase(yyruleno==325);
{ yylhsminor.yy828 = setStreamOptions(pCxt, yymsp[-2].minor.yy828, SOPT_TRIGGER_TYPE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 326: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ yylhsminor.yy828 = setStreamOptions(pCxt, yymsp[-3].minor.yy828, SOPT_TRIGGER_TYPE_SET, &yymsp[-1].minor.yy0, releaseRawExprNode(pCxt, yymsp[0].minor.yy828)); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 327: /* stream_options ::= stream_options WATERMARK duration_literal */
{ yylhsminor.yy828 = setStreamOptions(pCxt, yymsp[-2].minor.yy828, SOPT_WATERMARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy828)); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 328: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ yylhsminor.yy828 = setStreamOptions(pCxt, yymsp[-3].minor.yy828, SOPT_IGNORE_EXPIRED_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 329: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ yylhsminor.yy828 = setStreamOptions(pCxt, yymsp[-2].minor.yy828, SOPT_FILL_HISTORY_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 330: /* stream_options ::= stream_options DELETE_MARK duration_literal */
{ yylhsminor.yy828 = setStreamOptions(pCxt, yymsp[-2].minor.yy828, SOPT_DELETE_MARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy828)); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 331: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ yylhsminor.yy828 = setStreamOptions(pCxt, yymsp[-3].minor.yy828, SOPT_IGNORE_UPDATE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 333: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 522: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==522);
      case 542: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==542);
{ yymsp[-3].minor.yy828 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy828); }
        break;
      case 334: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 335: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 336: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 337: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 338: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 339: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy222); }
        break;
      case 340: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 341: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy222 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 343: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 346: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy828 = createInsertStmt(pCxt, yymsp[-4].minor.yy828, yymsp[-2].minor.yy222, yymsp[0].minor.yy828); }
        break;
      case 347: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy828 = createInsertStmt(pCxt, yymsp[-1].minor.yy828, NULL, yymsp[0].minor.yy828); }
        break;
      case 348: /* literal ::= NK_INTEGER */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 349: /* literal ::= NK_FLOAT */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 350: /* literal ::= NK_STRING */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 351: /* literal ::= NK_BOOL */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 352: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 353: /* literal ::= duration_literal */
      case 363: /* signed_literal ::= signed */ yytestcase(yyruleno==363);
      case 384: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==384);
      case 385: /* expression ::= literal */ yytestcase(yyruleno==385);
      case 386: /* expression ::= pseudo_column */ yytestcase(yyruleno==386);
      case 387: /* expression ::= column_reference */ yytestcase(yyruleno==387);
      case 388: /* expression ::= function_expression */ yytestcase(yyruleno==388);
      case 389: /* expression ::= case_when_expression */ yytestcase(yyruleno==389);
      case 420: /* function_expression ::= literal_func */ yytestcase(yyruleno==420);
      case 469: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==469);
      case 473: /* boolean_primary ::= predicate */ yytestcase(yyruleno==473);
      case 475: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==475);
      case 476: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==476);
      case 479: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==479);
      case 481: /* table_reference ::= table_primary */ yytestcase(yyruleno==481);
      case 482: /* table_reference ::= joined_table */ yytestcase(yyruleno==482);
      case 486: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==486);
      case 544: /* query_simple ::= query_specification */ yytestcase(yyruleno==544);
      case 545: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==545);
      case 548: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==548);
      case 550: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==550);
{ yylhsminor.yy828 = yymsp[0].minor.yy828; }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 354: /* literal ::= NULL */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 355: /* literal ::= NK_QUESTION */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 356: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 357: /* signed ::= NK_INTEGER */
{ yylhsminor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 358: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 359: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 360: /* signed ::= NK_FLOAT */
{ yylhsminor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 361: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 362: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 364: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 365: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 366: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 367: /* signed_literal ::= duration_literal */
      case 369: /* signed_literal ::= literal_func */ yytestcase(yyruleno==369);
      case 440: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==440);
      case 502: /* select_item ::= common_expression */ yytestcase(yyruleno==502);
      case 512: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==512);
      case 549: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==549);
      case 551: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==551);
      case 564: /* search_condition ::= common_expression */ yytestcase(yyruleno==564);
{ yylhsminor.yy828 = releaseRawExprNode(pCxt, yymsp[0].minor.yy828); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 368: /* signed_literal ::= NULL */
{ yylhsminor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 370: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy828 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 390: /* expression ::= NK_LP expression NK_RP */
      case 474: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==474);
      case 563: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==563);
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy828)); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 391: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy828));
                                                                                  }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 392: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy828), NULL));
                                                                                  }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 393: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828))); 
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 394: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828))); 
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 395: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828))); 
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 396: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828))); 
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 397: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 398: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 399: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 400: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 403: /* column_reference ::= column_name */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy63, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy63)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 404: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy63, createColumnNode(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy63)); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 405: /* pseudo_column ::= ROWTS */
      case 406: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==406);
      case 408: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==408);
      case 409: /* pseudo_column ::= QEND */ yytestcase(yyruleno==409);
      case 410: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==410);
      case 411: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==411);
      case 412: /* pseudo_column ::= WEND */ yytestcase(yyruleno==412);
      case 413: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==413);
      case 414: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==414);
      case 415: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==415);
      case 416: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==416);
      case 422: /* literal_func ::= NOW */ yytestcase(yyruleno==422);
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 407: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy63)))); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 417: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 418: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==418);
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy63, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy63, yymsp[-1].minor.yy222)); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 419: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), yymsp[-1].minor.yy686)); }
  yymsp[-5].minor.yy828 = yylhsminor.yy828;
        break;
      case 421: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy63, NULL)); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 436: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy222 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy222 = yylhsminor.yy222;
        break;
      case 441: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 505: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==505);
{ yylhsminor.yy828 = createColumnNode(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 442: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy222, yymsp[-1].minor.yy828)); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 443: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), yymsp[-2].minor.yy222, yymsp[-1].minor.yy828)); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 446: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy828 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)); }
        break;
      case 448: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy828 = releaseRawExprNode(pCxt, yymsp[0].minor.yy828); }
        break;
      case 449: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 454: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==454);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy62, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 450: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy828), releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 451: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy828), releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-5].minor.yy828 = yylhsminor.yy828;
        break;
      case 452: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), NULL));
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 453: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), NULL));
                                                                                  }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 455: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy62 = OP_TYPE_LOWER_THAN; }
        break;
      case 456: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy62 = OP_TYPE_GREATER_THAN; }
        break;
      case 457: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy62 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 458: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy62 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 459: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy62 = OP_TYPE_NOT_EQUAL; }
        break;
      case 460: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy62 = OP_TYPE_EQUAL; }
        break;
      case 461: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy62 = OP_TYPE_LIKE; }
        break;
      case 462: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy62 = OP_TYPE_NOT_LIKE; }
        break;
      case 463: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy62 = OP_TYPE_MATCH; }
        break;
      case 464: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy62 = OP_TYPE_NMATCH; }
        break;
      case 465: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy62 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 466: /* in_op ::= IN */
{ yymsp[0].minor.yy62 = OP_TYPE_IN; }
        break;
      case 467: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy62 = OP_TYPE_NOT_IN; }
        break;
      case 468: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy222)); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 470: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy828), NULL));
                                                                                  }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 471: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 472: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 478: /* from_clause_opt ::= FROM table_reference_list */
      case 507: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==507);
      case 538: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==538);
{ yymsp[-1].minor.yy828 = yymsp[0].minor.yy828; }
        break;
      case 480: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy828 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy828, yymsp[0].minor.yy828, NULL); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 483: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy828 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy63, &yymsp[0].minor.yy63); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 484: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy828 = createRealTableNode(pCxt, &yymsp[-3].minor.yy63, &yymsp[-1].minor.yy63, &yymsp[0].minor.yy63); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 485: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy828 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy828), &yymsp[0].minor.yy63); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 487: /* alias_opt ::= */
{ yymsp[1].minor.yy63 = nil_token;  }
        break;
      case 489: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy63 = yymsp[0].minor.yy63; }
        break;
      case 490: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 491: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==491);
{ yymsp[-2].minor.yy828 = yymsp[-1].minor.yy828; }
        break;
      case 492: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy828 = createJoinTableNode(pCxt, yymsp[-4].minor.yy574, yymsp[-5].minor.yy828, yymsp[-2].minor.yy828, yymsp[0].minor.yy828); }
  yymsp[-5].minor.yy828 = yylhsminor.yy828;
        break;
      case 493: /* join_type ::= */
{ yymsp[1].minor.yy574 = JOIN_TYPE_INNER; }
        break;
      case 494: /* join_type ::= INNER */
{ yymsp[0].minor.yy574 = JOIN_TYPE_INNER; }
        break;
      case 495: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy828 = createSelectStmt(pCxt, yymsp[-10].minor.yy669, yymsp[-9].minor.yy222, yymsp[-8].minor.yy828);
                                                                                    yymsp[-11].minor.yy828 = addWhereClause(pCxt, yymsp[-11].minor.yy828, yymsp[-7].minor.yy828);
                                                                                    yymsp[-11].minor.yy828 = addPartitionByClause(pCxt, yymsp[-11].minor.yy828, yymsp[-6].minor.yy222);
                                                                                    yymsp[-11].minor.yy828 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy828, yymsp[-2].minor.yy828);
                                                                                    yymsp[-11].minor.yy828 = addGroupByClause(pCxt, yymsp[-11].minor.yy828, yymsp[-1].minor.yy222);
                                                                                    yymsp[-11].minor.yy828 = addHavingClause(pCxt, yymsp[-11].minor.yy828, yymsp[0].minor.yy828);
                                                                                    yymsp[-11].minor.yy828 = addRangeClause(pCxt, yymsp[-11].minor.yy828, yymsp[-5].minor.yy828);
                                                                                    yymsp[-11].minor.yy828 = addEveryClause(pCxt, yymsp[-11].minor.yy828, yymsp[-4].minor.yy828);
                                                                                    yymsp[-11].minor.yy828 = addFillClause(pCxt, yymsp[-11].minor.yy828, yymsp[-3].minor.yy828);
                                                                                  }
        break;
      case 498: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy669 = false; }
        break;
      case 501: /* select_item ::= NK_STAR */
{ yylhsminor.yy828 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 503: /* select_item ::= common_expression column_alias */
      case 513: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==513);
{ yylhsminor.yy828 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy828), &yymsp[0].minor.yy63); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 504: /* select_item ::= common_expression AS column_alias */
      case 514: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==514);
{ yylhsminor.yy828 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), &yymsp[0].minor.yy63); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 509: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 534: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==534);
      case 553: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==553);
{ yymsp[-2].minor.yy222 = yymsp[0].minor.yy222; }
        break;
      case 516: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy828 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), releaseRawExprNode(pCxt, yymsp[-1].minor.yy828)); }
        break;
      case 517: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy828 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy828)); }
        break;
      case 518: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy828 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), NULL, yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 519: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy828 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy828), releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 520: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy828 = createEventWindowNode(pCxt, yymsp[-3].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 524: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy828 = createFillNode(pCxt, yymsp[-1].minor.yy822, NULL); }
        break;
      case 525: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy828 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy222)); }
        break;
      case 526: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy828 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy222)); }
        break;
      case 527: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy822 = FILL_MODE_NONE; }
        break;
      case 528: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy822 = FILL_MODE_PREV; }
        break;
      case 529: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy822 = FILL_MODE_NULL; }
        break;
      case 530: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy822 = FILL_MODE_NULL_F; }
        break;
      case 531: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy822 = FILL_MODE_LINEAR; }
        break;
      case 532: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy822 = FILL_MODE_NEXT; }
        break;
      case 535: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy222 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy828))); }
  yymsp[0].minor.yy222 = yylhsminor.yy222;
        break;
      case 536: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy222 = addNodeToList(pCxt, yymsp[-2].minor.yy222, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy828))); }
  yymsp[-2].minor.yy222 = yylhsminor.yy222;
        break;
      case 540: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy828 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), releaseRawExprNode(pCxt, yymsp[-1].minor.yy828)); }
        break;
      case 543: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy828 = addOrderByClause(pCxt, yymsp[-3].minor.yy828, yymsp[-2].minor.yy222);
                                                                                    yylhsminor.yy828 = addSlimitClause(pCxt, yylhsminor.yy828, yymsp[-1].minor.yy828);
                                                                                    yylhsminor.yy828 = addLimitClause(pCxt, yylhsminor.yy828, yymsp[0].minor.yy828);
                                                                                  }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 546: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy828 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy828, yymsp[0].minor.yy828); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 547: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy828 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy828, yymsp[0].minor.yy828); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 555: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 559: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==559);
{ yymsp[-1].minor.yy828 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 556: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 560: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==560);
{ yymsp[-3].minor.yy828 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 557: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 561: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==561);
{ yymsp[-3].minor.yy828 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 562: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy828); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 567: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy828 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), yymsp[-1].minor.yy158, yymsp[0].minor.yy675); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 568: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy158 = ORDER_ASC; }
        break;
      case 569: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy158 = ORDER_ASC; }
        break;
      case 570: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy158 = ORDER_DESC; }
        break;
      case 571: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy675 = NULL_ORDER_DEFAULT; }
        break;
      case 572: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy675 = NULL_ORDER_FIRST; }
        break;
      case 573: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy675 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
