CMAKE_MINIMUM_REQUIRED(VERSION 2.8)
PROJECT(TDengine)

IF (TD_ACCOUNT)
  ADD_DEFINITIONS(-D_ACCT)
ENDIF ()

IF (TD_ADMIN)
  ADD_DEFINITIONS(-D_ADMIN)
ENDIF ()

IF (TD_GRANT)
  ADD_DEFINITIONS(-D_GRANT)
ENDIF ()

IF (TD_MQTT)
  ADD_DEFINITIONS(-D_MQTT)
ENDIF ()

IF (TD_TSDB_PLUGINS)
  ADD_DEFINITIONS(-D_TSDB_PLUGINS)
ENDIF ()

IF (TD_STORAGE)
  ADD_DEFINITIONS(-D_STORAGE)
ENDIF ()

IF (TD_GODLL)
  ADD_DEFINITIONS(-D_TD_GO_DLL_)
ENDIF ()

IF (TD_POWER)
  ADD_DEFINITIONS(-D_TD_POWER_)
ENDIF ()

IF (TD_MEM_CHECK)
  ADD_DEFINITIONS(-DTAOS_MEM_CHECK)
ENDIF ()

IF (TD_RANDOM_FILE_FAIL)
  ADD_DEFINITIONS(-DTAOS_RANDOM_FILE_FAIL)
ENDIF ()

IF (TD_RANDOM_NETWORK_FAIL)
  ADD_DEFINITIONS(-DTAOS_RANDOM_NETWORK_FAIL)
ENDIF ()

IF (TD_LINUX_64)
  ADD_DEFINITIONS(-D_M_X64)
  ADD_DEFINITIONS(-D_TD_LINUX_64)
  MESSAGE(STATUS "linux64 is defined")
  SET(COMMON_FLAGS "-std=gnu99 -Wall -Werror -fPIC -g3 -gdwarf-2 -msse4.2 -D_FILE_OFFSET_BITS=64 -D_LARGE_FILE")
  ADD_DEFINITIONS(-DUSE_LIBICONV)
ENDIF ()

IF (TD_LINUX_32)
  ADD_DEFINITIONS(-D_TD_LINUX_32)
  ADD_DEFINITIONS(-DUSE_LIBICONV)
  MESSAGE(STATUS "linux32 is defined")
  SET(COMMON_FLAGS "-std=gnu99 -Wall -Werror -fPIC -g -fsigned-char -munaligned-access -fpack-struct=8 -D_FILE_OFFSET_BITS=64 -D_LARGE_FILE")
ENDIF ()

IF (TD_ARM_64)
  ADD_DEFINITIONS(-D_M_X64)
  ADD_DEFINITIONS(-D_TD_ARM_64)
  ADD_DEFINITIONS(-D_TD_ARM_)
  ADD_DEFINITIONS(-DUSE_LIBICONV)
  MESSAGE(STATUS "arm64 is defined")
  SET(COMMON_FLAGS "-std=gnu99 -Wall -Werror -fPIC -g -fsigned-char -fpack-struct=8 -D_FILE_OFFSET_BITS=64 -D_LARGE_FILE")
ENDIF ()

IF (TD_ARM_32)
  ADD_DEFINITIONS(-D_TD_ARM_32)
  ADD_DEFINITIONS(-D_TD_ARM_)
  ADD_DEFINITIONS(-DUSE_LIBICONV)
  MESSAGE(STATUS "arm32 is defined")
  SET(COMMON_FLAGS "-std=gnu99 -Wall -Werror -fPIC -g -fsigned-char -fpack-struct=8 -D_FILE_OFFSET_BITS=64 -D_LARGE_FILE -Wno-pointer-to-int-cast -Wno-int-to-pointer-cast -Wno-incompatible-pointer-types ")
ENDIF ()

IF (TD_MIPS_64)
  ADD_DEFINITIONS(-D_TD_MIPS_64_)
  ADD_DEFINITIONS(-DUSE_LIBICONV)
  MESSAGE(STATUS "mips64 is defined")
  SET(COMMON_FLAGS "-std=gnu99 -Wall -Werror -fPIC -g3 -gdwarf-2 -msse4.2 -D_FILE_OFFSET_BITS=64 -D_LARGE_FILE")
ENDIF ()

IF (TD_MIPS_32)
  ADD_DEFINITIONS(-D_TD_MIPS_32_)
  ADD_DEFINITIONS(-DUSE_LIBICONV)
  MESSAGE(STATUS "mips32 is defined")
  SET(COMMON_FLAGS "-std=gnu99 -Wall -Werror -fPIC -g3 -gdwarf-2 -msse4.2 -D_FILE_OFFSET_BITS=64 -D_LARGE_FILE")
ENDIF ()

IF (TD_APLHINE)
  SET(COMMON_FLAGS "${COMMON_FLAGS} -largp")
  link_libraries(/usr/lib/libargp.a)
  ADD_DEFINITIONS(-D_ALPINE)
  MESSAGE(STATUS "aplhine is defined")
ENDIF ()

IF (TD_LINUX)
  ADD_DEFINITIONS(-DLINUX)
  ADD_DEFINITIONS(-D_LINUX)
  ADD_DEFINITIONS(-D_TD_LINUX)
  ADD_DEFINITIONS(-D_REENTRANT -D__USE_POSIX -D_LIBC_REENTRANT)

  IF (TD_NINGSI_60)
    ADD_DEFINITIONS(-D_TD_NINGSI_60)
    MESSAGE(STATUS "set ningsi macro to true")
  ENDIF ()
  
  SET(DEBUG_FLAGS "-O0 -DDEBUG")
  SET(RELEASE_FLAGS "-O0 -Wno-unused-variable -Wunused-but-set-variable")
  
  IF (${COVER} MATCHES "true")
    MESSAGE(STATUS "Test coverage mode, add extra flags")
    SET(GCC_COVERAGE_COMPILE_FLAGS "-fprofile-arcs -ftest-coverage")
    SET(GCC_COVERAGE_LINK_FLAGS    "-lgcov --coverage")
    SET(COMMON_FLAGS "${COMMON_FLAGS} ${GCC_COVERAGE_COMPILE_FLAGS} ${GCC_COVERAGE_LINK_FLAGS}")
  ENDIF ()

  INCLUDE_DIRECTORIES(${TD_COMMUNITY_DIR}/deps/cJson/inc)
  INCLUDE_DIRECTORIES(${TD_COMMUNITY_DIR}/deps/lz4/inc)
ENDIF ()

IF (TD_DARWIN_64)
  ADD_DEFINITIONS(-D_TD_DARWIN_64)
  ADD_DEFINITIONS(-DDARWIN)
  ADD_DEFINITIONS(-D_REENTRANT -D__USE_POSIX -D_LIBC_REENTRANT)
  ADD_DEFINITIONS(-DUSE_LIBICONV)
  MESSAGE(STATUS "darwin64 is defined")
  SET(COMMON_FLAGS "-std=gnu99 -Wall -Werror -Wno-missing-braces -fPIC -g -msse4.2 -D_FILE_OFFSET_BITS=64 -D_LARGE_FILE")
  SET(DEBUG_FLAGS "-O0 -DDEBUG")
  SET(RELEASE_FLAGS "-O0")
ENDIF ()

IF (TD_WINDOWS)
  ADD_DEFINITIONS(-DWINDOWS)
  ADD_DEFINITIONS(-D__CLEANUP_C)
  ADD_DEFINITIONS(-DPTW32_STATIC_LIB)
  ADD_DEFINITIONS(-DPTW32_BUILD)
  ADD_DEFINITIONS(-D_MBCS -D_CRT_SECURE_NO_DEPRECATE -D_CRT_NONSTDC_NO_DEPRECATE)
  SET(CMAKE_GENERATOR "NMake Makefiles" CACHE INTERNAL "" FORCE)
  IF (NOT TD_GODLL)
    SET(COMMON_FLAGS "/nologo /WX /wd4018 /wd2220 /Oi /Oy- /Gm- /EHsc /MT /GS /Gy /fp:precise /Zc:wchar_t /Zc:forScope /Gd /errorReport:prompt /analyze-")
    SET(DEBUG_FLAGS "/Zi /W3 /GL")
    SET(RELEASE_FLAGS "/W0 /GL")
  ENDIF ()

  INCLUDE_DIRECTORIES(${TD_COMMUNITY_DIR}/deps/pthread)
  INCLUDE_DIRECTORIES(${TD_COMMUNITY_DIR}/deps/iconv)
  INCLUDE_DIRECTORIES(${TD_COMMUNITY_DIR}/deps/regex)
  INCLUDE_DIRECTORIES(${TD_COMMUNITY_DIR}/deps/wepoll/inc)
  INCLUDE_DIRECTORIES(${TD_COMMUNITY_DIR}/deps/MsvcLibX/include)
ENDIF () 

IF (TD_WINDOWS_64)
  ADD_DEFINITIONS(-D_M_X64)
  ADD_DEFINITIONS(-D_TD_WINDOWS_64)
  ADD_DEFINITIONS(-DUSE_LIBICONV)
  MESSAGE(STATUS "windows64 is defined")
ENDIF ()

IF (TD_WINDOWS_32)
  ADD_DEFINITIONS(-D_TD_WINDOWS_32)
  ADD_DEFINITIONS(-DUSE_LIBICONV)
  MESSAGE(STATUS "windows32 is defined")
ENDIF ()

INCLUDE_DIRECTORIES(${TD_COMMUNITY_DIR}/src/inc)
INCLUDE_DIRECTORIES(${TD_COMMUNITY_DIR}/src/os/inc)
INCLUDE_DIRECTORIES(${TD_COMMUNITY_DIR}/src/util/inc)
INCLUDE_DIRECTORIES(${TD_COMMUNITY_DIR}/src/common/inc)

MESSAGE(STATUS "CMAKE_CXX_COMPILER_ID: " ${CMAKE_CXX_COMPILER_ID})
