/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 375
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SDataType yy34;
  EJoinType yy162;
  EOrder yy188;
  SNode* yy212;
  SAlterOption yy245;
  EOperatorType yy290;
  EFillMode yy294;
  SToken yy329;
  SNodeList* yy424;
  ENullOrder yy607;
  int64_t yy609;
  int32_t yy610;
  int8_t yy653;
  bool yy737;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             653
#define YYNRULE              483
#define YYNTOKEN             252
#define YY_MAX_SHIFT         652
#define YY_MIN_SHIFTREDUCE   954
#define YY_MAX_SHIFTREDUCE   1436
#define YY_ERROR_ACTION      1437
#define YY_ACCEPT_ACTION     1438
#define YY_NO_ACTION         1439
#define YY_MIN_REDUCE        1440
#define YY_MAX_REDUCE        1922
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2471)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   422, 1670,  423, 1475,  294, 1744, 1438,  430,  317,  423,
 /*    10 */  1475, 1563,   39,   37, 1505,  338, 1741,   69, 1619, 1621,
 /*    20 */   326, 1441, 1238, 1744, 1900, 1565,  334,  525,  373,  379,
 /*    30 */   115, 1674, 1775, 1313, 1741, 1236, 1741, 1899, 1552, 1569,
 /*    40 */   518, 1897,  101, 1737, 1743,  100,   99,   98,   97,   96,
 /*    50 */    95,   94,   93,   92,  570,  119, 1308,  987, 1757,   14,
 /*    60 */    61, 1737, 1743, 1737, 1743, 1244,  297,  343, 1900,   39,
 /*    70 */    37, 1376,  570,  439,  570,  474,  473,  326,  517, 1238,
 /*    80 */   472,  157,    1,  116,  469, 1897, 1775,  468,  467,  466,
 /*    90 */  1313, 1004, 1236, 1003,  528,  117,  439,  991,  992, 1727,
 /*   100 */   479,  548, 1380,  310,  649,  566,  458, 1900, 1262,  527,
 /*   110 */   153, 1842, 1843, 1308, 1847,  489,   14,  552, 1315, 1316,
 /*   120 */   157, 1005, 1244, 1550, 1897,  329,  412, 1788, 1671,  202,
 /*   130 */    88, 1758,  551, 1760, 1761,  547,   60,  570,   60,    2,
 /*   140 */  1834,  525,  210,  482,  319, 1830,  152,  476,   30,  240,
 /*   150 */   652,  311,  201,  309,  308,  140,  462, 1452,  156,  421,
 /*   160 */   464,  649,  425, 1239,  262, 1237, 1860,   43,   60,  119,
 /*   170 */    73,  330,  171,  170,  566, 1315, 1316,   55,  149,  138,
 /*   180 */    54,  604,  463,  642,  638,  634,  630,  260, 1576, 1242,
 /*   190 */  1243,  519, 1291, 1292, 1294, 1295, 1296, 1297, 1298,  544,
 /*   200 */   568, 1306, 1307, 1309, 1310, 1311, 1312, 1314, 1317,  117,
 /*   210 */  1263, 1669,   85, 1323,  294,  254,  372,  167,  371, 1262,
 /*   220 */  1239,  160, 1237,  427,  154, 1842, 1843, 1900, 1847, 1260,
 /*   230 */  1745,   33,   32,  504, 1263,   40,   38,   36,   35,   34,
 /*   240 */   158, 1741,   67,  525, 1897,   66, 1242, 1243,  563, 1291,
 /*   250 */  1292, 1294, 1295, 1296, 1297, 1298,  544,  568, 1306, 1307,
 /*   260 */  1309, 1310, 1311, 1312, 1314, 1317,   39,   37, 1737, 1743,
 /*   270 */   488,  119,  490, 1900,  326,  160, 1238,  160,   69,  570,
 /*   280 */   212, 1293,  300,  486,   60,  484,  157, 1313,  101, 1236,
 /*   290 */  1897,  100,   99,   98,   97,   96,   95,   94,   93,   92,
 /*   300 */  1570, 1211,  151,  205, 1900,  552, 1276,  160, 1136, 1137,
 /*   310 */  1308,  117, 1900,   14, 1335, 1613, 1672, 1898, 1262, 1244,
 /*   320 */   602, 1897,  566,   39,   37,  157,  155, 1842, 1843, 1897,
 /*   330 */  1847,  326,  604, 1238, 1502, 1004,    2, 1003, 1261,  129,
 /*   340 */   128,  599,  598,  597, 1313,   78, 1236, 1094,  593,  592,
 /*   350 */   591, 1098,  590, 1100, 1101,  589, 1103,  586,  649, 1109,
 /*   360 */   583, 1111, 1112,  580,  577, 1005, 1567, 1308, 1336,   36,
 /*   370 */    35,   34, 1315, 1316, 1664, 1463, 1244,   40,   38,   36,
 /*   380 */    35,   34,   33,   32,   42,  169,   40,   38,   36,   35,
 /*   390 */    34, 1341, 1293,    8,  541,  626,  625,  624,  341,  596,
 /*   400 */   623,  622,  621,  121,  616,  615,  614,  613,  612,  611,
 /*   410 */   610,  609,  131,  605,  141,  649, 1727, 1239, 1531, 1237,
 /*   420 */    33,   32, 1397,  160,   40,   38,   36,   35,   34, 1315,
 /*   430 */  1316, 1551,   29,  324, 1330, 1331, 1332, 1333, 1334, 1338,
 /*   440 */  1339, 1340,  600, 1242, 1243, 1617, 1291, 1292, 1294, 1295,
 /*   450 */  1296, 1297, 1298,  544,  568, 1306, 1307, 1309, 1310, 1311,
 /*   460 */  1312, 1314, 1317,  511, 1395, 1396, 1398, 1399, 1056,  567,
 /*   470 */   474,  473,  138, 1337, 1239,  472, 1237, 1264,  116,  469,
 /*   480 */   111, 1577,  468,  467,  466,   33,   32,  460, 1244,   40,
 /*   490 */    38,   36,   35,   34,  607, 1407, 1342, 1574, 1058, 1462,
 /*   500 */  1242, 1243,  203, 1291, 1292, 1294, 1295, 1296, 1297, 1298,
 /*   510 */   544,  568, 1306, 1307, 1309, 1310, 1311, 1312, 1314, 1317,
 /*   520 */    39,   37, 1318,  160, 1327,  602, 1620, 1621,  326, 1433,
 /*   530 */  1238,  567,  160,  471,  470,  189,  300,   27,  245,  246,
 /*   540 */  1727, 1313,  162, 1236,  129,  128,  599,  598,  597,  144,
 /*   550 */  1559,  525,  567, 1626,  456,  452,  448,  444,  188, 1574,
 /*   560 */   331,   71,  305,  111, 1308,  556, 1265,  336, 1335, 1624,
 /*   570 */   465,   11,   10, 1244,  339,  138,  497,   39,   37,  119,
 /*   580 */  1574, 1561,  138,   70, 1576,  326,  186, 1238,   33,   32,
 /*   590 */     9, 1576,   40,   38,   36,   35,   34,   84, 1313,  305,
 /*   600 */  1236,  529,  556, 1757,  567,  567,  464,  232, 1626, 1461,
 /*   610 */   120, 1460,  649, 1626,  567,  377,  378, 1432, 1566,  117,
 /*   620 */   337, 1308, 1336,   22, 1625,  382, 1315, 1316,  463, 1624,
 /*   630 */  1244, 1775, 1574, 1574,  230, 1842,  524, 1262,  523,  549,
 /*   640 */  1459, 1900, 1574,  364, 1727, 1341,  548,    9,  185,  178,
 /*   650 */  1727,  183, 1727, 1349,  159,  435,   33,   32, 1897,  514,
 /*   660 */    40,   38,   36,   35,   34,  366,  362,  429,   58,  649,
 /*   670 */   425, 1239, 1788, 1237,  176,  142, 1758,  551, 1760, 1761,
 /*   680 */   547, 1727,  570, 1315, 1316, 1549,   29,  324, 1330, 1331,
 /*   690 */  1332, 1333, 1334, 1338, 1339, 1340,  213, 1242, 1243, 1458,
 /*   700 */  1291, 1292, 1294, 1295, 1296, 1297, 1298,  544,  568, 1306,
 /*   710 */  1307, 1309, 1310, 1311, 1312, 1314, 1317, 1440,  267,  530,
 /*   720 */  1914, 1604,  567,  567,  567,  620,  618, 1557, 1239,  601,
 /*   730 */  1237, 1387, 1617,  397,  398,  438,  206,  520,  515, 1715,
 /*   740 */  1727,  110,  109,  108,  107,  106,  105,  104,  103,  102,
 /*   750 */  1574, 1574, 1574,  525, 1242, 1243,  543, 1291, 1292, 1294,
 /*   760 */  1295, 1296, 1297, 1298,  544,  568, 1306, 1307, 1309, 1310,
 /*   770 */  1311, 1312, 1314, 1317,   39,   37,  296, 1238, 1260,  602,
 /*   780 */   567,  119,  326,  567, 1238,  405,  352, 1457,  417, 1849,
 /*   790 */  1236, 1571, 1849,  595, 1703, 1313, 1373, 1236,  129,  128,
 /*   800 */   599,  598,  597,  529, 1456,  390,  567,  418, 1574,  392,
 /*   810 */  1293, 1574,  244, 1846,  991,  992, 1845,  498, 1308, 1453,
 /*   820 */  1244,  117,  567,    7, 1455, 1849, 1532, 1244, 1727, 1854,
 /*   830 */  1369, 1454,  194,  502, 1574,  192,  230, 1842,  524,  383,
 /*   840 */   523,   26,  235, 1900,    2, 1727,  533,   33,   32, 1844,
 /*   850 */  1574,   40,   38,   36,   35,   34,  157,   28,  512,  649,
 /*   860 */  1897,   44,    4,   33,   32, 1727,  649,   40,   38,   36,
 /*   870 */    35,   34, 1727,  457, 1219, 1220, 1451,   52,  501,  416,
 /*   880 */  1315, 1316,  411,  410,  409,  408,  407,  404,  403,  402,
 /*   890 */   401,  400,  396,  395,  394,  393,  387,  386,  385,  384,
 /*   900 */  1492,  381,  380,  531,  196,  567, 1450,  195,  567,  139,
 /*   910 */   536,  608, 1449, 1546,  273,  491,  564, 1727, 1239,  565,
 /*   920 */  1237,  198,  475,  200,  197, 1239,  199, 1237,  271,   57,
 /*   930 */    11,   10,   56, 1574,   33,   32, 1574, 1448,   40,   38,
 /*   940 */    36,   35,   34, 1757, 1242, 1243, 1447, 1727,  172, 1446,
 /*   950 */  1445, 1242, 1243, 1727, 1291, 1292, 1294, 1295, 1296, 1297,
 /*   960 */  1298,  544,  568, 1306, 1307, 1309, 1310, 1311, 1312, 1314,
 /*   970 */  1317, 1775,  567,   60,  567, 1435, 1436,  209, 1727,  549,
 /*   980 */  1444, 1487,  224,  256, 1727,  340,  548, 1727,   33,   32,
 /*   990 */  1727, 1727,   40,   38,   36,   35,   34, 1443, 1776,  619,
 /*  1000 */  1574,  529, 1574,  477, 1369,   72, 1747, 1247, 1246, 1276,
 /*  1010 */    50,   86, 1788,  217, 1372,   87, 1758,  551, 1760, 1761,
 /*  1020 */   547, 1727,  570, 1485, 1757, 1834, 1476,   33,   32,  299,
 /*  1030 */  1830,   40,   38,   36,   35,   34, 1481,  342, 1727,  367,
 /*  1040 */  1614, 1900, 1749,  534, 1757,  480,   64,   63,  376,   41,
 /*  1050 */  1394,  166, 1775,  219,  159,   41,   83,  370, 1897, 1864,
 /*  1060 */   549, 1028,  229,  526,   41, 1727,   80,  548,  242,  234,
 /*  1070 */   295,  237, 1775,  360,  123,  358,  354,  350,  163,  345,
 /*  1080 */   528,  239,  529,    3,  644, 1727,    5,  548,  126, 1343,
 /*  1090 */   344, 1029, 1260, 1788,  127, 1299,   87, 1758,  551, 1760,
 /*  1100 */  1761,  547,   50,  570, 1187,  347, 1834,  351,  247,  537,
 /*  1110 */   299, 1830,  160, 1788,  559,  306,   88, 1758,  551, 1760,
 /*  1120 */  1761,  547, 1900,  570, 1056,  307, 1834, 1203,  253,  263,
 /*  1130 */   319, 1830,  152,  575, 1087,  157, 1757, 1250, 1249, 1897,
 /*  1140 */   126,  127,  266,  112,  126,  399, 1666,  168,  406,  414,
 /*  1150 */   413,  415, 1861,  419, 1266,  420,  428, 1269,  432,  431,
 /*  1160 */   175,  177, 1268,  433, 1775, 1270,  434, 1267,  180,  137,
 /*  1170 */   436,  182,  549, 1115,  437,  184,   68, 1727,  440,  548,
 /*  1180 */  1119, 1126,  459, 1124,  130,  187,  461,   91, 1564,  191,
 /*  1190 */  1560,  298, 1708,  193,  132,  133, 1562, 1558,  264, 1757,
 /*  1200 */   134,  204,  135,  492,  493, 1788,  207,  316,   88, 1758,
 /*  1210 */   551, 1760, 1761,  547,  496,  570,  499,  503, 1834, 1265,
 /*  1220 */   211,  513,  319, 1830, 1913, 1875, 1757, 1775, 1865,  508,
 /*  1230 */   555,  510, 1874, 1868,  215,  549,  333,  332,  218,  318,
 /*  1240 */  1727,  516,  548,    6,  509,  522, 1252, 1856,  223,  507,
 /*  1250 */   228,  146,  506, 1369, 1775,  225,  118, 1313, 1264, 1245,
 /*  1260 */   320,  538,  549, 1850,   18,  124,  535, 1727, 1788,  548,
 /*  1270 */   125,   88, 1758,  551, 1760, 1761,  547,  226,  570,  227,
 /*  1280 */  1308, 1834,  553,  554, 1707,  319, 1830, 1913, 1815, 1244,
 /*  1290 */  1676, 1896,  557,  328,  561, 1788, 1891, 1757,   88, 1758,
 /*  1300 */   551, 1760, 1761,  547, 1916,  570,  532,  233, 1834,  539,
 /*  1310 */   236,  560,  319, 1830, 1913,  238,  265,  251,  562,   77,
 /*  1320 */   249, 1575,   79, 1853,  268, 1775,  573,  259,  571, 1547,
 /*  1330 */  1618,  645,  646,  549,  648,  145,  270,  272, 1727, 1721,
 /*  1340 */   548,  289,  291,  290, 1720,   62, 1719,  346, 1716,  348,
 /*  1350 */   349,   51, 1231, 1232,  164,  529,  353, 1714,  355,  356,
 /*  1360 */   357, 1713, 1757,  359, 1712,  361, 1788, 1711, 1710,  280,
 /*  1370 */  1758,  551, 1760, 1761,  547,  363,  570,  365, 1693,  165,
 /*  1380 */   368,  369, 1206, 1205, 1687, 1686,  374, 1253,  375, 1248,
 /*  1390 */  1775, 1685, 1684, 1175, 1659, 1900, 1658, 1657,  549,   65,
 /*  1400 */  1656, 1655, 1654, 1727, 1653,  548, 1652,  388,  159,  389,
 /*  1410 */  1651, 1650, 1897, 1256,  391, 1649, 1648, 1647, 1646, 1645,
 /*  1420 */   529, 1644, 1643, 1642,  568, 1306, 1307, 1309, 1310, 1311,
 /*  1430 */  1312, 1788, 1641, 1757,  280, 1758,  551, 1760, 1761,  547,
 /*  1440 */  1640,  570, 1639, 1638, 1637,  122, 1636, 1635, 1634, 1633,
 /*  1450 */  1632, 1631, 1177, 1630, 1629, 1757,  173,   49,  424,  113,
 /*  1460 */  1900, 1775, 1628, 1627, 1504, 1472,  994,  150, 1471,  549,
 /*  1470 */   114,  993,  426,  157, 1727,  174,  548, 1897, 1701, 1695,
 /*  1480 */  1683,  181, 1682, 1775,  179, 1668, 1553, 1022, 1503, 1501,
 /*  1490 */   441,  549, 1499, 1497,  445, 1495, 1727, 1484,  548,  443,
 /*  1500 */   447, 1483, 1788, 1468,  449,   89, 1758,  551, 1760, 1761,
 /*  1510 */   547,  451,  570,  442,  446, 1834,  453,  450, 1757, 1833,
 /*  1520 */  1830,  454,  455, 1555, 1788,  190, 1130,   89, 1758,  551,
 /*  1530 */  1760, 1761,  547, 1129,  570, 1554, 1757, 1834, 1493, 1055,
 /*  1540 */  1054,  540, 1830, 1053, 1052,  617, 1775, 1049, 1048,  619,
 /*  1550 */  1047,  312, 1488,  313,  546, 1486,  478,  481,  314, 1727,
 /*  1560 */  1467,  548,  483, 1466, 1775,  485, 1465,  487,   90, 1700,
 /*  1570 */  1694,  494,  549, 1681, 1213,   53,  136, 1727,  495,  548,
 /*  1580 */   208, 1679, 1680, 1678,  315, 1677,   41, 1788,   15, 1757,
 /*  1590 */   287, 1758,  551, 1760, 1761,  547,  545,  570,  542, 1806,
 /*  1600 */    23,   47,  221, 1409,  216, 1788,  214,  143,   89, 1758,
 /*  1610 */   551, 1760, 1761,  547,  220,  570, 1393, 1775, 1834,   24,
 /*  1620 */   222, 1747,   74, 1831, 1386,  549,  231,  500,   45,   25,
 /*  1630 */  1727,   46,  548,   16, 1366,  147, 1365, 1426,   17, 1415,
 /*  1640 */  1421, 1420,  321, 1757,  505,   10, 1425, 1424,  322,  148,
 /*  1650 */  1301,   19, 1284,   31, 1757, 1300, 1675, 1667, 1788,   12,
 /*  1660 */  1328,  288, 1758,  551, 1760, 1761,  547,  161,  570,   20,
 /*  1670 */   250, 1775,   21, 1746,  241,  550, 1391, 1223,  243,  549,
 /*  1680 */   248,  255, 1775,   13, 1727, 1303,  548, 1254,  574,   80,
 /*  1690 */   549,   75,  558,  252,  572, 1727,   76,  548, 1791,  569,
 /*  1700 */    48, 1093, 1116,  335,  576,  578, 1113,  579,  581, 1110,
 /*  1710 */   582, 1757, 1788,  584,  585,  283, 1758,  551, 1760, 1761,
 /*  1720 */   547, 1104,  570, 1788, 1102,  587,  142, 1758,  551, 1760,
 /*  1730 */  1761,  547, 1757,  570,  588, 1108,  594,   81, 1125, 1775,
 /*  1740 */  1107,   82, 1106, 1105,   59,  257, 1121,  549, 1020, 1044,
 /*  1750 */  1062,  603, 1727,  521,  548,  606,  258, 1042, 1041, 1037,
 /*  1760 */  1775, 1040, 1039, 1038, 1036, 1035,  323, 1057,  546, 1059,
 /*  1770 */  1032, 1915, 1500, 1727, 1757,  548, 1031, 1030, 1027, 1026,
 /*  1780 */  1788, 1025,  627,  288, 1758,  551, 1760, 1761,  547,  629,
 /*  1790 */   570, 1498,  628,  631,  633,  632, 1496, 1757,  635,  636,
 /*  1800 */   637, 1788, 1775, 1494,  287, 1758,  551, 1760, 1761,  547,
 /*  1810 */   549,  570,  639, 1807,  640, 1727, 1482,  548,  641,  643,
 /*  1820 */   984, 1464,  261,  647, 1439, 1775, 1240,  269,  650,  325,
 /*  1830 */   651, 1439, 1439,  549, 1439, 1439, 1439, 1439, 1727, 1439,
 /*  1840 */   548, 1439, 1439, 1788, 1439, 1439,  288, 1758,  551, 1760,
 /*  1850 */  1761,  547,  327,  570, 1757, 1439, 1439, 1439, 1439, 1439,
 /*  1860 */  1439, 1439, 1439, 1439, 1439, 1757, 1788, 1439, 1439,  288,
 /*  1870 */  1758,  551, 1760, 1761,  547, 1439,  570, 1439, 1439, 1757,
 /*  1880 */  1439, 1439, 1775, 1439, 1439, 1439, 1439, 1439, 1439, 1439,
 /*  1890 */   549, 1439, 1439, 1775, 1439, 1727, 1439,  548, 1439, 1439,
 /*  1900 */  1439,  549, 1439, 1439, 1439, 1439, 1727, 1775,  548, 1439,
 /*  1910 */  1439, 1439, 1439, 1439, 1439,  549, 1439, 1439, 1439, 1439,
 /*  1920 */  1727, 1757,  548, 1788, 1439, 1439,  274, 1758,  551, 1760,
 /*  1930 */  1761,  547, 1439,  570, 1788, 1757, 1439,  275, 1758,  551,
 /*  1940 */  1760, 1761,  547, 1439,  570, 1439, 1757, 1439, 1788, 1775,
 /*  1950 */  1439,  276, 1758,  551, 1760, 1761,  547,  549,  570, 1439,
 /*  1960 */  1439, 1439, 1727, 1775,  548, 1439, 1439, 1439, 1439, 1439,
 /*  1970 */  1439,  549, 1439, 1439, 1775, 1439, 1727, 1439,  548, 1439,
 /*  1980 */  1439, 1439,  549, 1439, 1439, 1439, 1439, 1727, 1757,  548,
 /*  1990 */  1788, 1439, 1439,  282, 1758,  551, 1760, 1761,  547, 1439,
 /*  2000 */   570, 1439, 1439, 1439, 1788, 1439, 1439,  284, 1758,  551,
 /*  2010 */  1760, 1761,  547, 1439,  570, 1788, 1775, 1439,  277, 1758,
 /*  2020 */   551, 1760, 1761,  547,  549,  570, 1439, 1439, 1439, 1727,
 /*  2030 */  1757,  548, 1439, 1439, 1439, 1439, 1439, 1439, 1439, 1439,
 /*  2040 */  1439, 1757, 1439, 1439, 1439, 1439, 1439, 1439, 1439, 1439,
 /*  2050 */  1439, 1439, 1439, 1757, 1439, 1439, 1439, 1788, 1775, 1439,
 /*  2060 */   285, 1758,  551, 1760, 1761,  547,  549,  570, 1439, 1775,
 /*  2070 */  1439, 1727, 1439,  548, 1439, 1439, 1439,  549, 1439, 1439,
 /*  2080 */  1439, 1775, 1727, 1439,  548, 1439, 1439, 1439, 1439,  549,
 /*  2090 */  1439, 1439, 1439, 1439, 1727, 1439,  548, 1439, 1439, 1788,
 /*  2100 */  1439, 1439,  278, 1758,  551, 1760, 1761,  547, 1757,  570,
 /*  2110 */  1788, 1439, 1439,  286, 1758,  551, 1760, 1761,  547, 1439,
 /*  2120 */   570, 1439, 1788, 1439, 1439,  279, 1758,  551, 1760, 1761,
 /*  2130 */   547, 1439,  570, 1439, 1439, 1757, 1775, 1439, 1439, 1439,
 /*  2140 */  1439, 1439, 1439, 1439,  549, 1439, 1439, 1439, 1439, 1727,
 /*  2150 */  1439,  548, 1439, 1439, 1439, 1439, 1439, 1439, 1439, 1439,
 /*  2160 */  1439, 1439, 1757, 1775, 1439, 1439, 1439, 1439, 1439, 1439,
 /*  2170 */  1439,  549, 1439, 1439, 1439, 1439, 1727, 1788,  548, 1439,
 /*  2180 */   292, 1758,  551, 1760, 1761,  547, 1439,  570, 1439, 1757,
 /*  2190 */  1775, 1439, 1439, 1439, 1439, 1439, 1439, 1439,  549, 1439,
 /*  2200 */  1439, 1439, 1439, 1727, 1788,  548, 1439,  293, 1758,  551,
 /*  2210 */  1760, 1761,  547, 1439,  570, 1439, 1439, 1775, 1439, 1439,
 /*  2220 */  1439, 1439, 1439, 1439, 1439,  549, 1439, 1439, 1439, 1439,
 /*  2230 */  1727, 1788,  548, 1439, 1769, 1758,  551, 1760, 1761,  547,
 /*  2240 */  1439,  570, 1439, 1757, 1439, 1439, 1439, 1439, 1439, 1439,
 /*  2250 */  1439, 1439, 1757, 1439, 1439, 1439, 1439, 1439, 1788, 1439,
 /*  2260 */  1439, 1768, 1758,  551, 1760, 1761,  547, 1439,  570, 1439,
 /*  2270 */  1757, 1775, 1439, 1439, 1439, 1439, 1439, 1439, 1439,  549,
 /*  2280 */  1775, 1439, 1439, 1439, 1727, 1439,  548, 1439,  549, 1439,
 /*  2290 */  1439, 1439, 1439, 1727, 1439,  548, 1439, 1439, 1775, 1439,
 /*  2300 */  1439, 1439, 1439, 1439, 1439, 1439,  549, 1439, 1439, 1439,
 /*  2310 */  1439, 1727, 1788,  548, 1439, 1767, 1758,  551, 1760, 1761,
 /*  2320 */   547, 1788,  570, 1757,  303, 1758,  551, 1760, 1761,  547,
 /*  2330 */  1439,  570, 1439, 1439, 1439, 1439, 1439, 1757, 1439, 1788,
 /*  2340 */  1439, 1439,  302, 1758,  551, 1760, 1761,  547, 1439,  570,
 /*  2350 */  1439, 1775, 1439, 1439, 1439, 1439, 1439, 1439, 1439,  549,
 /*  2360 */  1439, 1439, 1439, 1439, 1727, 1775,  548, 1439, 1439, 1439,
 /*  2370 */  1439, 1439, 1439,  549, 1439, 1439, 1439, 1439, 1727, 1439,
 /*  2380 */   548, 1439, 1439, 1439, 1439, 1439, 1439, 1439, 1439, 1439,
 /*  2390 */  1439, 1757, 1788, 1439, 1439,  304, 1758,  551, 1760, 1761,
 /*  2400 */   547, 1439,  570, 1439, 1439, 1439, 1788, 1439, 1439,  301,
 /*  2410 */  1758,  551, 1760, 1761,  547, 1439,  570, 1439, 1439, 1775,
 /*  2420 */  1439, 1439, 1439, 1439, 1439, 1439, 1439,  549, 1439, 1439,
 /*  2430 */  1439, 1439, 1727, 1439,  548, 1439, 1439, 1439, 1439, 1439,
 /*  2440 */  1439, 1439, 1439, 1439, 1439, 1439, 1439, 1439, 1439, 1439,
 /*  2450 */  1439, 1439, 1439, 1439, 1439, 1439, 1439, 1439, 1439, 1439,
 /*  2460 */  1788, 1439, 1439,  281, 1758,  551, 1760, 1761,  547, 1439,
 /*  2470 */   570,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   259,  308,  261,  262,  311,  285,  252,  259,  288,  261,
 /*    10 */   262,  284,   12,   13,    0,  294,  296,  267,  297,  298,
 /*    20 */    20,    0,   22,  285,  353,  285,  288,  263,  313,  263,
 /*    30 */   280,    0,  283,   33,  296,   35,  296,  366,    0,  289,
 /*    40 */   291,  370,   21,  323,  324,   24,   25,   26,   27,   28,
 /*    50 */    29,   30,   31,   32,  334,  291,   56,    4,  255,   59,
 /*    60 */     4,  323,  324,  323,  324,   65,  300,  313,  353,   12,
 /*    70 */    13,   14,  334,   58,  334,   61,   62,   20,  329,   22,
 /*    80 */    66,  366,   82,   69,   70,  370,  283,   73,   74,   75,
 /*    90 */    33,   20,   35,   22,  291,  331,   58,   44,   45,  296,
 /*   100 */     4,  298,   14,   37,  104,   20,   35,  353,   20,  345,
 /*   110 */   346,  347,  348,   56,  350,   19,   59,  298,  118,  119,
 /*   120 */   366,   50,   65,    0,  370,  306,   76,  324,  309,   33,
 /*   130 */   327,  328,  329,  330,  331,  332,   82,  334,   82,   82,
 /*   140 */   337,  263,   56,   47,  341,  342,  343,   51,  338,  339,
 /*   150 */    19,   85,   56,   87,   88,  254,   90,  256,  355,  260,
 /*   160 */    94,  104,  263,  163,   33,  165,  363,   82,   82,  291,
 /*   170 */    84,  275,  122,  123,   20,  118,  119,   81,   47,  283,
 /*   180 */    84,   58,  116,   52,   53,   54,   55,   56,  292,  189,
 /*   190 */   190,   20,  192,  193,  194,  195,  196,  197,  198,  199,
 /*   200 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  331,
 /*   210 */    20,  308,   81,   14,  311,   84,  162,   56,  164,   20,
 /*   220 */   163,  221,  165,   14,  346,  347,  348,  353,  350,   20,
 /*   230 */   285,    8,    9,  313,   20,   12,   13,   14,   15,   16,
 /*   240 */   366,  296,   81,  263,  370,   84,  189,  190,  117,  192,
 /*   250 */   193,  194,  195,  196,  197,  198,  199,  200,  201,  202,
 /*   260 */   203,  204,  205,  206,  207,  208,   12,   13,  323,  324,
 /*   270 */    21,  291,  313,  353,   20,  221,   22,  221,  267,  334,
 /*   280 */   149,  193,   59,   34,   82,   36,  366,   33,   21,   35,
 /*   290 */   370,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   300 */   289,  170,  282,  172,  353,  298,   83,  221,  118,  119,
 /*   310 */    56,  331,  353,   59,   91,  295,  309,  366,   20,   65,
 /*   320 */    94,  370,   20,   12,   13,  366,  346,  347,  348,  370,
 /*   330 */   350,   20,   58,   22,    0,   20,   82,   22,   20,  113,
 /*   340 */   114,  115,  116,  117,   33,  265,   35,   95,   96,   97,
 /*   350 */    98,   99,  100,  101,  102,  103,  104,  105,  104,  107,
 /*   360 */   108,  109,  110,  111,  112,   50,  286,   56,  145,   14,
 /*   370 */    15,   16,  118,  119,  291,  255,   65,   12,   13,   14,
 /*   380 */    15,   16,    8,    9,   82,  302,   12,   13,   14,   15,
 /*   390 */    16,  168,  193,   82,   59,   61,   62,   63,   64,   93,
 /*   400 */    66,   67,   68,   69,   70,   71,   72,   73,   74,   75,
 /*   410 */    76,   77,   78,   79,  268,  104,  296,  163,  272,  165,
 /*   420 */     8,    9,  189,  221,   12,   13,   14,   15,   16,  118,
 /*   430 */   119,    0,  209,  210,  211,  212,  213,  214,  215,  216,
 /*   440 */   217,  218,  293,  189,  190,  296,  192,  193,  194,  195,
 /*   450 */   196,  197,  198,  199,  200,  201,  202,  203,  204,  205,
 /*   460 */   206,  207,  208,  230,  231,  232,  233,  234,   35,  263,
 /*   470 */    61,   62,  283,  145,  163,   66,  165,   20,   69,   70,
 /*   480 */   274,  292,   73,   74,   75,    8,    9,  281,   65,   12,
 /*   490 */    13,   14,   15,   16,   65,   83,  168,  291,   65,  255,
 /*   500 */   189,  190,  114,  192,  193,  194,  195,  196,  197,  198,
 /*   510 */   199,  200,  201,  202,  203,  204,  205,  206,  207,  208,
 /*   520 */    12,   13,   14,  221,  189,   94,  297,  298,   20,  155,
 /*   530 */    22,  263,  221,  269,  270,   33,   59,  209,  113,  114,
 /*   540 */   296,   33,  274,   35,  113,  114,  115,  116,  117,   47,
 /*   550 */   284,  263,  263,  283,   52,   53,   54,   55,   56,  291,
 /*   560 */   290,  173,  174,  274,   56,  177,   20,  275,   91,  299,
 /*   570 */   281,    1,    2,   65,  275,  283,  317,   12,   13,  291,
 /*   580 */   291,  284,  283,   81,  292,   20,   84,   22,    8,    9,
 /*   590 */    82,  292,   12,   13,   14,   15,   16,  265,   33,  174,
 /*   600 */    35,  313,  177,  255,  263,  263,   94,  150,  283,  255,
 /*   610 */   278,  255,  104,  283,  263,  274,  274,  243,  286,  331,
 /*   620 */   290,   56,  145,   43,  299,  274,  118,  119,  116,  299,
 /*   630 */    65,  283,  291,  291,  346,  347,  348,   20,  350,  291,
 /*   640 */   255,  353,  291,  158,  296,  168,  298,   82,  146,  147,
 /*   650 */   296,  149,  296,   83,  366,  153,    8,    9,  370,  148,
 /*   660 */    12,   13,   14,   15,   16,  180,  181,  260,    3,  104,
 /*   670 */   263,  163,  324,  165,  172,  327,  328,  329,  330,  331,
 /*   680 */   332,  296,  334,  118,  119,    0,  209,  210,  211,  212,
 /*   690 */   213,  214,  215,  216,  217,  218,  150,  189,  190,  255,
 /*   700 */   192,  193,  194,  195,  196,  197,  198,  199,  200,  201,
 /*   710 */   202,  203,  204,  205,  206,  207,  208,    0,  276,  371,
 /*   720 */   372,  279,  263,  263,  263,  269,  270,  284,  163,  293,
 /*   730 */   165,   83,  296,  274,  274,  274,  284,  226,  227,    0,
 /*   740 */   296,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   750 */   291,  291,  291,  263,  189,  190,  284,  192,  193,  194,
 /*   760 */   195,  196,  197,  198,  199,  200,  201,  202,  203,  204,
 /*   770 */   205,  206,  207,  208,   12,   13,   18,   22,   20,   94,
 /*   780 */   263,  291,   20,  263,   22,   27,   47,  255,   30,  325,
 /*   790 */    35,  274,  325,  284,  274,   33,    4,   35,  113,  114,
 /*   800 */   115,  116,  117,  313,  255,   47,  263,   49,  291,   51,
 /*   810 */   193,  291,  113,  349,   44,   45,  349,  274,   56,  256,
 /*   820 */    65,  331,  263,   39,  255,  325,  272,   65,  296,  219,
 /*   830 */   220,  255,   86,  274,  291,   89,  346,  347,  348,   81,
 /*   840 */   350,    2,  373,  353,   82,  296,   43,    8,    9,  349,
 /*   850 */   291,   12,   13,   14,   15,   16,  366,    2,  364,  104,
 /*   860 */   370,   42,   43,    8,    9,  296,  104,   12,   13,   14,
 /*   870 */    15,   16,  296,  264,  175,  176,  255,  150,  151,  121,
 /*   880 */   118,  119,  124,  125,  126,  127,  128,  129,  130,  131,
 /*   890 */   132,  133,  134,  135,  136,  137,  138,  139,  140,  141,
 /*   900 */     0,  143,  144,  238,   86,  263,  255,   89,  263,   18,
 /*   910 */    43,  271,  255,  273,   23,  320,  274,  296,  163,  274,
 /*   920 */   165,   86,   22,   86,   89,  163,   89,  165,   37,   38,
 /*   930 */     1,    2,   41,  291,    8,    9,  291,  255,   12,   13,
 /*   940 */    14,   15,   16,  255,  189,  190,  255,  296,   57,  255,
 /*   950 */   255,  189,  190,  296,  192,  193,  194,  195,  196,  197,
 /*   960 */   198,  199,  200,  201,  202,  203,  204,  205,  206,  207,
 /*   970 */   208,  283,  263,   82,  263,  118,  119,   56,  296,  291,
 /*   980 */   255,    0,  360,  274,  296,  274,  298,  296,    8,    9,
 /*   990 */   296,  296,   12,   13,   14,   15,   16,  255,  283,   43,
 /*  1000 */   291,  313,  291,   22,  220,   84,   46,   35,   35,   83,
 /*  1010 */    43,  120,  324,   43,  222,  327,  328,  329,  330,  331,
 /*  1020 */   332,  296,  334,    0,  255,  337,  262,    8,    9,  341,
 /*  1030 */   342,   12,   13,   14,   15,   16,    0,  264,  296,   83,
 /*  1040 */   295,  353,   82,  240,  255,   22,  155,  156,  157,   43,
 /*  1050 */    83,  160,  283,   83,  366,   43,   82,  166,  370,  326,
 /*  1060 */   291,   35,  344,  351,   43,  296,   92,  298,   43,  367,
 /*  1070 */   179,  367,  283,  182,   43,  184,  185,  186,  187,  188,
 /*  1080 */   291,  367,  313,  354,   48,  296,  223,  298,   43,   83,
 /*  1090 */   322,   65,   20,  324,   43,   83,  327,  328,  329,  330,
 /*  1100 */   331,  332,   43,  334,   83,  263,  337,   47,   83,  242,
 /*  1110 */   341,  342,  221,  324,   83,  321,  327,  328,  329,  330,
 /*  1120 */   331,  332,  353,  334,   35,  269,  337,  161,   83,  315,
 /*  1130 */   341,  342,  343,   43,   83,  366,  255,  165,  165,  370,
 /*  1140 */    43,   43,   83,   43,   43,  263,  263,   42,  303,  145,
 /*  1150 */   301,  301,  363,  263,   20,  257,  257,   20,  298,  319,
 /*  1160 */   267,  267,   20,  312,  283,   20,  314,   20,  267,  150,
 /*  1170 */   312,  267,  291,   83,  304,  267,  267,  296,  263,  298,
 /*  1180 */    83,   83,  257,   83,   83,  267,  283,  263,  283,  283,
 /*  1190 */   283,  257,  296,  283,  283,  283,  283,  283,  319,  255,
 /*  1200 */   283,  265,  283,  171,  318,  324,  265,  312,  327,  328,
 /*  1210 */   329,  330,  331,  332,  298,  334,  263,  263,  337,   20,
 /*  1220 */   265,  229,  341,  342,  343,  359,  255,  283,  326,  296,
 /*  1230 */   228,  296,  359,  352,  307,  291,   12,   13,  307,  296,
 /*  1240 */   296,  296,  298,  235,  237,  154,   22,  362,  361,  236,
 /*  1250 */   322,  359,  224,  220,  283,  358,  291,   33,   20,   35,
 /*  1260 */   244,  241,  291,  325,   82,  307,  239,  296,  324,  298,
 /*  1270 */   307,  327,  328,  329,  330,  331,  332,  357,  334,  356,
 /*  1280 */    56,  337,  296,  296,  296,  341,  342,  343,  340,   65,
 /*  1290 */   296,  369,  296,  296,  305,  324,  352,  255,  327,  328,
 /*  1300 */   329,  330,  331,  332,  374,  334,  369,  368,  337,  369,
 /*  1310 */   368,  147,  341,  342,  343,  368,  279,  265,  304,  265,
 /*  1320 */   291,  291,   82,  352,  263,  283,  287,  265,  104,  273,
 /*  1330 */   296,   36,  258,  291,  257,  311,  266,  253,  296,    0,
 /*  1340 */   298,  277,  277,  277,    0,   42,    0,   73,    0,   35,
 /*  1350 */   183,  316,   35,   35,   35,  313,  183,    0,   35,   35,
 /*  1360 */   183,    0,  255,  183,    0,   35,  324,    0,    0,  327,
 /*  1370 */   328,  329,  330,  331,  332,   22,  334,   35,    0,   82,
 /*  1380 */   168,  167,  165,  163,    0,    0,  159,  163,  158,  165,
 /*  1390 */   283,    0,    0,   46,    0,  353,    0,    0,  291,  142,
 /*  1400 */     0,    0,    0,  296,    0,  298,    0,  137,  366,   35,
 /*  1410 */     0,    0,  370,  189,  137,    0,    0,    0,    0,    0,
 /*  1420 */   313,    0,    0,    0,  200,  201,  202,  203,  204,  205,
 /*  1430 */   206,  324,    0,  255,  327,  328,  329,  330,  331,  332,
 /*  1440 */     0,  334,    0,    0,    0,   42,    0,    0,    0,    0,
 /*  1450 */     0,    0,   22,    0,    0,  255,   42,   91,   46,   39,
 /*  1460 */   353,  283,    0,    0,    0,    0,   14,   43,    0,  291,
 /*  1470 */    39,   14,   46,  366,  296,   40,  298,  370,    0,    0,
 /*  1480 */     0,  154,    0,  283,   39,    0,    0,   60,    0,    0,
 /*  1490 */    35,  291,    0,    0,   35,    0,  296,    0,  298,   39,
 /*  1500 */    39,    0,  324,    0,   35,  327,  328,  329,  330,  331,
 /*  1510 */   332,   39,  334,   47,   47,  337,   35,   47,  255,  341,
 /*  1520 */   342,   47,   39,    0,  324,   89,   35,  327,  328,  329,
 /*  1530 */   330,  331,  332,   22,  334,    0,  255,  337,    0,   35,
 /*  1540 */    35,  341,  342,   35,   35,   43,  283,   35,   35,   43,
 /*  1550 */    35,   22,    0,   22,  291,    0,   49,   35,   22,  296,
 /*  1560 */     0,  298,   35,    0,  283,   35,    0,   22,   20,    0,
 /*  1570 */     0,   22,  291,    0,   35,  150,  169,  296,  150,  298,
 /*  1580 */   147,    0,    0,    0,  150,    0,   43,  324,  225,  255,
 /*  1590 */   327,  328,  329,  330,  331,  332,  333,  334,  335,  336,
 /*  1600 */    82,   43,   43,   83,   83,  324,   82,   82,  327,  328,
 /*  1610 */   329,  330,  331,  332,   82,  334,   83,  283,  337,   82,
 /*  1620 */    46,   46,   82,  342,   83,  291,   46,  152,  219,   43,
 /*  1630 */   296,   43,  298,  225,   83,   46,   83,   83,   43,   83,
 /*  1640 */    35,   35,   35,  255,  310,    2,   35,   35,   35,   46,
 /*  1650 */    83,   43,   22,   82,  255,   83,    0,    0,  324,   82,
 /*  1660 */   189,  327,  328,  329,  330,  331,  332,   46,  334,   82,
 /*  1670 */    39,  283,   82,   46,   83,  191,   83,  178,   82,  291,
 /*  1680 */    82,   46,  283,  225,  296,   83,  298,   22,   35,   92,
 /*  1690 */   291,   82,  148,  146,   93,  296,   82,  298,   82,   82,
 /*  1700 */    82,   22,   83,   35,   82,   35,   83,   82,   35,   83,
 /*  1710 */    82,  255,  324,   35,   82,  327,  328,  329,  330,  331,
 /*  1720 */   332,   83,  334,  324,   83,   35,  327,  328,  329,  330,
 /*  1730 */   331,  332,  255,  334,   82,  106,   94,   82,   35,  283,
 /*  1740 */   106,   82,  106,  106,   82,   43,   22,  291,   60,   35,
 /*  1750 */    65,   59,  296,  365,  298,   80,   43,   35,   35,   22,
 /*  1760 */   283,   35,   35,   35,   35,   35,  310,   35,  291,   65,
 /*  1770 */    35,  372,    0,  296,  255,  298,   35,   35,   35,   35,
 /*  1780 */   324,   35,   35,  327,  328,  329,  330,  331,  332,   39,
 /*  1790 */   334,    0,   47,   35,   39,   47,    0,  255,   35,   47,
 /*  1800 */    39,  324,  283,    0,  327,  328,  329,  330,  331,  332,
 /*  1810 */   291,  334,   35,  336,   47,  296,    0,  298,   39,   35,
 /*  1820 */    35,    0,   22,   21,  375,  283,   22,   22,   21,  310,
 /*  1830 */    20,  375,  375,  291,  375,  375,  375,  375,  296,  375,
 /*  1840 */   298,  375,  375,  324,  375,  375,  327,  328,  329,  330,
 /*  1850 */   331,  332,  310,  334,  255,  375,  375,  375,  375,  375,
 /*  1860 */   375,  375,  375,  375,  375,  255,  324,  375,  375,  327,
 /*  1870 */   328,  329,  330,  331,  332,  375,  334,  375,  375,  255,
 /*  1880 */   375,  375,  283,  375,  375,  375,  375,  375,  375,  375,
 /*  1890 */   291,  375,  375,  283,  375,  296,  375,  298,  375,  375,
 /*  1900 */   375,  291,  375,  375,  375,  375,  296,  283,  298,  375,
 /*  1910 */   375,  375,  375,  375,  375,  291,  375,  375,  375,  375,
 /*  1920 */   296,  255,  298,  324,  375,  375,  327,  328,  329,  330,
 /*  1930 */   331,  332,  375,  334,  324,  255,  375,  327,  328,  329,
 /*  1940 */   330,  331,  332,  375,  334,  375,  255,  375,  324,  283,
 /*  1950 */   375,  327,  328,  329,  330,  331,  332,  291,  334,  375,
 /*  1960 */   375,  375,  296,  283,  298,  375,  375,  375,  375,  375,
 /*  1970 */   375,  291,  375,  375,  283,  375,  296,  375,  298,  375,
 /*  1980 */   375,  375,  291,  375,  375,  375,  375,  296,  255,  298,
 /*  1990 */   324,  375,  375,  327,  328,  329,  330,  331,  332,  375,
 /*  2000 */   334,  375,  375,  375,  324,  375,  375,  327,  328,  329,
 /*  2010 */   330,  331,  332,  375,  334,  324,  283,  375,  327,  328,
 /*  2020 */   329,  330,  331,  332,  291,  334,  375,  375,  375,  296,
 /*  2030 */   255,  298,  375,  375,  375,  375,  375,  375,  375,  375,
 /*  2040 */   375,  255,  375,  375,  375,  375,  375,  375,  375,  375,
 /*  2050 */   375,  375,  375,  255,  375,  375,  375,  324,  283,  375,
 /*  2060 */   327,  328,  329,  330,  331,  332,  291,  334,  375,  283,
 /*  2070 */   375,  296,  375,  298,  375,  375,  375,  291,  375,  375,
 /*  2080 */   375,  283,  296,  375,  298,  375,  375,  375,  375,  291,
 /*  2090 */   375,  375,  375,  375,  296,  375,  298,  375,  375,  324,
 /*  2100 */   375,  375,  327,  328,  329,  330,  331,  332,  255,  334,
 /*  2110 */   324,  375,  375,  327,  328,  329,  330,  331,  332,  375,
 /*  2120 */   334,  375,  324,  375,  375,  327,  328,  329,  330,  331,
 /*  2130 */   332,  375,  334,  375,  375,  255,  283,  375,  375,  375,
 /*  2140 */   375,  375,  375,  375,  291,  375,  375,  375,  375,  296,
 /*  2150 */   375,  298,  375,  375,  375,  375,  375,  375,  375,  375,
 /*  2160 */   375,  375,  255,  283,  375,  375,  375,  375,  375,  375,
 /*  2170 */   375,  291,  375,  375,  375,  375,  296,  324,  298,  375,
 /*  2180 */   327,  328,  329,  330,  331,  332,  375,  334,  375,  255,
 /*  2190 */   283,  375,  375,  375,  375,  375,  375,  375,  291,  375,
 /*  2200 */   375,  375,  375,  296,  324,  298,  375,  327,  328,  329,
 /*  2210 */   330,  331,  332,  375,  334,  375,  375,  283,  375,  375,
 /*  2220 */   375,  375,  375,  375,  375,  291,  375,  375,  375,  375,
 /*  2230 */   296,  324,  298,  375,  327,  328,  329,  330,  331,  332,
 /*  2240 */   375,  334,  375,  255,  375,  375,  375,  375,  375,  375,
 /*  2250 */   375,  375,  255,  375,  375,  375,  375,  375,  324,  375,
 /*  2260 */   375,  327,  328,  329,  330,  331,  332,  375,  334,  375,
 /*  2270 */   255,  283,  375,  375,  375,  375,  375,  375,  375,  291,
 /*  2280 */   283,  375,  375,  375,  296,  375,  298,  375,  291,  375,
 /*  2290 */   375,  375,  375,  296,  375,  298,  375,  375,  283,  375,
 /*  2300 */   375,  375,  375,  375,  375,  375,  291,  375,  375,  375,
 /*  2310 */   375,  296,  324,  298,  375,  327,  328,  329,  330,  331,
 /*  2320 */   332,  324,  334,  255,  327,  328,  329,  330,  331,  332,
 /*  2330 */   375,  334,  375,  375,  375,  375,  375,  255,  375,  324,
 /*  2340 */   375,  375,  327,  328,  329,  330,  331,  332,  375,  334,
 /*  2350 */   375,  283,  375,  375,  375,  375,  375,  375,  375,  291,
 /*  2360 */   375,  375,  375,  375,  296,  283,  298,  375,  375,  375,
 /*  2370 */   375,  375,  375,  291,  375,  375,  375,  375,  296,  375,
 /*  2380 */   298,  375,  375,  375,  375,  375,  375,  375,  375,  375,
 /*  2390 */   375,  255,  324,  375,  375,  327,  328,  329,  330,  331,
 /*  2400 */   332,  375,  334,  375,  375,  375,  324,  375,  375,  327,
 /*  2410 */   328,  329,  330,  331,  332,  375,  334,  375,  375,  283,
 /*  2420 */   375,  375,  375,  375,  375,  375,  375,  291,  375,  375,
 /*  2430 */   375,  375,  296,  375,  298,  375,  375,  375,  375,  375,
 /*  2440 */   375,  375,  375,  375,  375,  375,  375,  375,  375,  375,
 /*  2450 */   375,  375,  375,  375,  375,  375,  375,  375,  375,  375,
 /*  2460 */   324,  375,  375,  327,  328,  329,  330,  331,  332,  375,
 /*  2470 */   334,
};
#define YY_SHIFT_COUNT    (652)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1821)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   891,    0,    0,   57,   57,  254,  254,  254,  311,  311,
 /*    10 */   254,  254,  508,  565,  762,  565,  565,  565,  565,  565,
 /*    20 */   565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
 /*    30 */   565,  565,  565,  565,  565,  565,  565,  565,  565,  565,
 /*    40 */   565,  565,  302,  302,   85,   85,   85, 1224, 1224, 1224,
 /*    50 */  1224,   54,   86,  202,  154,  154,   53,   53,   56,  190,
 /*    60 */   202,  202,  154,  154,  154,  154,  154,  154,  154,  154,
 /*    70 */    15,  154,  154,  154,  171,  214,  298,  154,  154,  298,
 /*    80 */   154,  298,  298,  298,  154,  274,  758,  223,  477,  477,
 /*    90 */   267,  409,  755,  755,  755,  755,  755,  755,  755,  755,
 /*   100 */   755,  755,  755,  755,  755,  755,  755,  755,  755,  755,
 /*   110 */   755,   66,  190,  209,  209,   38,  433,  457,  457,  457,
 /*   120 */   123,  433,  318,  214,   31,   31,  298,  298,  423,  423,
 /*   130 */   306,  429,  252,  252,  252,  252,  252,  252,  252,  131,
 /*   140 */    21,   14,  374,  233,   71,  388,  511,   88,  199,  315,
 /*   150 */   770,  512,  546,  610,  784,  610,  819,  665,  665,  665,
 /*   160 */   792,  617,  863, 1072, 1060, 1089,  966, 1072, 1072, 1105,
 /*   170 */  1004, 1004, 1072, 1134, 1134, 1137,   15,  214,   15, 1142,
 /*   180 */  1145,   15, 1142,   15, 1147,   15,   15, 1072,   15, 1134,
 /*   190 */   298,  298,  298,  298,  298,  298,  298,  298,  298,  298,
 /*   200 */   298, 1072, 1134,  423, 1137,  274, 1032,  214,  274, 1072,
 /*   210 */  1072, 1142,  274, 1199,  423,  992, 1002,  423,  992, 1002,
 /*   220 */   423,  423,  298, 1008, 1091,  992, 1007, 1013, 1028,  863,
 /*   230 */  1033,  318, 1238, 1020, 1027, 1016, 1020, 1027, 1020, 1027,
 /*   240 */  1182, 1002,  423,  423,  423,  423,  423, 1002,  423, 1164,
 /*   250 */   318, 1147,  274,  306,  274,  318, 1240,  423,  429, 1072,
 /*   260 */   274, 1295, 1134, 2471, 2471, 2471, 2471, 2471, 2471, 2471,
 /*   270 */   334,  502,  717,   96,  412,  580,  648,  839,  855, 1019,
 /*   280 */   926,  980,  980,  980,  980,  980,  980,  980,  980,  431,
 /*   290 */   685,  226,  365,  365,  425,  485,  161,   50,  249,  570,
 /*   300 */   328,  355,  355,  355,  355,  699,  739,  956,  746,  818,
 /*   310 */   835,  837,  900,  981, 1023,  921,  727,  967,  970,  929,
 /*   320 */   857,  803,  867, 1006,  335, 1012,  960, 1021, 1025, 1031,
 /*   330 */  1045, 1051,  972,  973, 1059, 1090, 1097, 1098, 1100, 1101,
 /*   340 */   974, 1026, 1036, 1339, 1344, 1303, 1346, 1274, 1348, 1314,
 /*   350 */  1167, 1317, 1318, 1319, 1173, 1357, 1323, 1324, 1177, 1361,
 /*   360 */  1180, 1364, 1330, 1367, 1353, 1368, 1342, 1378, 1297, 1212,
 /*   370 */  1214, 1217, 1220, 1384, 1385, 1227, 1230, 1391, 1392, 1347,
 /*   380 */  1394, 1396, 1397, 1257, 1400, 1401, 1402, 1404, 1406, 1270,
 /*   390 */  1374, 1410, 1277, 1411, 1415, 1416, 1417, 1418, 1419, 1421,
 /*   400 */  1422, 1423, 1432, 1440, 1442, 1443, 1444, 1403, 1446, 1447,
 /*   410 */  1448, 1449, 1450, 1451, 1430, 1453, 1454, 1462, 1463, 1464,
 /*   420 */  1465, 1414, 1420, 1424, 1452, 1412, 1457, 1426, 1468, 1435,
 /*   430 */  1431, 1478, 1479, 1480, 1445, 1327, 1482, 1485, 1486, 1427,
 /*   440 */  1488, 1489, 1455, 1466, 1460, 1492, 1459, 1467, 1461, 1493,
 /*   450 */  1469, 1470, 1472, 1495, 1481, 1474, 1483, 1497, 1501, 1503,
 /*   460 */  1523, 1366, 1436, 1491, 1511, 1535, 1504, 1505, 1508, 1509,
 /*   470 */  1502, 1506, 1512, 1513, 1515, 1538, 1529, 1552, 1531, 1507,
 /*   480 */  1555, 1536, 1522, 1560, 1527, 1563, 1530, 1566, 1545, 1548,
 /*   490 */  1569, 1425, 1539, 1570, 1407, 1549, 1428, 1433, 1573, 1581,
 /*   500 */  1434, 1475, 1582, 1583, 1585, 1543, 1363, 1518, 1520, 1524,
 /*   510 */  1521, 1558, 1533, 1525, 1532, 1537, 1541, 1559, 1574, 1575,
 /*   520 */  1540, 1586, 1408, 1551, 1553, 1580, 1409, 1588, 1589, 1554,
 /*   530 */  1595, 1458, 1556, 1605, 1606, 1607, 1611, 1612, 1613, 1556,
 /*   540 */  1643, 1471, 1608, 1567, 1571, 1572, 1603, 1577, 1587, 1621,
 /*   550 */  1630, 1484, 1590, 1591, 1593, 1596, 1499, 1656, 1598, 1544,
 /*   560 */  1609, 1657, 1631, 1547, 1614, 1597, 1627, 1635, 1616, 1602,
 /*   570 */  1617, 1665, 1618, 1601, 1619, 1653, 1668, 1622, 1623, 1670,
 /*   580 */  1625, 1626, 1673, 1628, 1638, 1678, 1632, 1641, 1690, 1652,
 /*   590 */  1629, 1634, 1636, 1637, 1679, 1642, 1655, 1659, 1703, 1662,
 /*   600 */  1702, 1702, 1724, 1688, 1692, 1714, 1685, 1675, 1713, 1722,
 /*   610 */  1723, 1726, 1727, 1728, 1737, 1729, 1730, 1704, 1502, 1732,
 /*   620 */  1506, 1735, 1741, 1742, 1743, 1744, 1746, 1772, 1747, 1745,
 /*   630 */  1750, 1791, 1758, 1748, 1755, 1796, 1763, 1752, 1761, 1803,
 /*   640 */  1777, 1767, 1779, 1816, 1784, 1785, 1821, 1800, 1802, 1804,
 /*   650 */  1805, 1807, 1810,
};
#define YY_REDUCE_COUNT (269)
#define YY_REDUCE_MIN   (-329)
#define YY_REDUCE_MAX   (2136)
static const short yy_reduce_ofst[] = {
 /*     0 */  -246,  688,  769, -197,  789,  881,  944,  971, 1042, 1107,
 /*    10 */  1178, 1200, 1263,  348, 1281, 1334, 1388, 1399, 1456, 1477,
 /*    20 */  1519, 1542, 1599, 1610, 1624, 1666, 1680, 1691, 1733, 1775,
 /*    30 */  1786, 1798, 1853, 1880, 1907, 1934, 1988, 1997, 2015, 2068,
 /*    40 */  2082, 2136,  288,  490, -236, -122,  -20, -280, -262, -260,
 /*    50 */   -55, -285,  -80,  -41,  206,  289, -259, -252, -329, -279,
 /*    60 */  -126,  -49,  268,  341,  342,  351,  459,  460,  461,  517,
 /*    70 */  -250,  520,  543,  559, -251, -181, -104,  642,  645,  270,
 /*    80 */   709,  292,  330,  299,  711,  332, -234, -190, -190, -190,
 /*    90 */   -99,  146,  120,  244,  354,  356,  385,  444,  532,  549,
 /*   100 */   569,  576,  621,  651,  657,  682,  691,  694,  695,  725,
 /*   110 */   742,   20,  229, -101,  407,   11,  264,  464,  467,  500,
 /*   120 */    80,  456,   83,    7, -307,  -97,  189,  325,  149,  436,
 /*   130 */   442,  640, -273,  266,  297,  443,  452,  472,  509,  259,
 /*   140 */   563,  554,  469,  494,  609,  595,  622,  715,  715,  773,
 /*   150 */   764,  745,  733,  712,  712,  712,  718,  702,  704,  714,
 /*   160 */   729,  715,  768,  842,  794,  856,  814,  882,  883,  845,
 /*   170 */   849,  850,  890,  898,  899,  840,  893,  860,  894,  851,
 /*   180 */   852,  901,  858,  904,  870,  908,  909,  915,  918,  925,
 /*   190 */   903,  905,  906,  907,  910,  911,  912,  913,  914,  917,
 /*   200 */   919,  924,  934,  896,  879,  936,  886,  916,  941,  953,
 /*   210 */   954,  895,  955,  902,  933,  866,  927,  935,  873,  931,
 /*   220 */   943,  945,  715,  885,  887,  892,  897,  920,  923,  928,
 /*   230 */   712,  965,  938,  922,  939,  930,  937,  942,  940,  947,
 /*   240 */   948,  958,  986,  987,  988,  994,  996,  963,  997,  989,
 /*   250 */  1029, 1014, 1052, 1037, 1054, 1030, 1039, 1034, 1056, 1061,
 /*   260 */  1062, 1074, 1077, 1035, 1024, 1064, 1065, 1066, 1070, 1084,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*    10 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*    20 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*    30 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*    40 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*    50 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*    60 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*    70 */  1509, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*    80 */  1437, 1437, 1437, 1437, 1437, 1507, 1660, 1437, 1836, 1437,
 /*    90 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   100 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   110 */  1437, 1437, 1437, 1437, 1437, 1509, 1437, 1848, 1848, 1848,
 /*   120 */  1507, 1437, 1437, 1437, 1704, 1704, 1437, 1437, 1437, 1437,
 /*   130 */  1603, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1696,
 /*   140 */  1437, 1437, 1917, 1437, 1437, 1702, 1871, 1437, 1437, 1437,
 /*   150 */  1437, 1556, 1863, 1840, 1854, 1841, 1838, 1902, 1902, 1902,
 /*   160 */  1857, 1437, 1867, 1437, 1437, 1437, 1688, 1437, 1437, 1665,
 /*   170 */  1662, 1662, 1437, 1437, 1437, 1437, 1509, 1437, 1509, 1437,
 /*   180 */  1437, 1509, 1437, 1509, 1437, 1509, 1509, 1437, 1509, 1437,
 /*   190 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   200 */  1437, 1437, 1437, 1437, 1437, 1507, 1698, 1437, 1507, 1437,
 /*   210 */  1437, 1437, 1507, 1437, 1437, 1878, 1876, 1437, 1878, 1876,
 /*   220 */  1437, 1437, 1437, 1890, 1886, 1878, 1894, 1892, 1869, 1867,
 /*   230 */  1854, 1437, 1437, 1908, 1904, 1920, 1908, 1904, 1908, 1904,
 /*   240 */  1437, 1876, 1437, 1437, 1437, 1437, 1437, 1876, 1437, 1437,
 /*   250 */  1437, 1437, 1507, 1437, 1507, 1437, 1572, 1437, 1437, 1437,
 /*   260 */  1507, 1469, 1437, 1690, 1704, 1606, 1606, 1606, 1510, 1442,
 /*   270 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   280 */  1437, 1774, 1889, 1888, 1812, 1811, 1810, 1808, 1773, 1437,
 /*   290 */  1437, 1568, 1772, 1771, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   300 */  1437, 1765, 1766, 1764, 1763, 1437, 1437, 1437, 1437, 1437,
 /*   310 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1837,
 /*   320 */  1437, 1905, 1909, 1437, 1437, 1437, 1748, 1437, 1437, 1437,
 /*   330 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   340 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   350 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   360 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   370 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   380 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   390 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   400 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   410 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   420 */  1437, 1437, 1437, 1474, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   430 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   440 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   450 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   460 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   470 */  1537, 1536, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   480 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   490 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   500 */  1437, 1437, 1437, 1437, 1437, 1870, 1437, 1437, 1437, 1437,
 /*   510 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1748,
 /*   520 */  1437, 1887, 1437, 1847, 1843, 1437, 1437, 1839, 1437, 1437,
 /*   530 */  1903, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   540 */  1832, 1437, 1805, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   550 */  1437, 1759, 1437, 1437, 1437, 1437, 1437, 1708, 1437, 1437,
 /*   560 */  1437, 1437, 1437, 1437, 1437, 1437, 1747, 1437, 1790, 1437,
 /*   570 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1600, 1437, 1437,
 /*   580 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   590 */  1585, 1583, 1582, 1581, 1437, 1578, 1437, 1437, 1437, 1437,
 /*   600 */  1609, 1608, 1437, 1437, 1437, 1437, 1437, 1437, 1529, 1437,
 /*   610 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1520, 1437,
 /*   620 */  1519, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   630 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   640 */  1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437, 1437,
 /*   650 */  1437, 1437, 1437,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*     DELETE => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  245,  /*  NK_BITNOT => ID */
  245,  /*     INSERT => ID */
  245,  /*     VALUES => ID */
  245,  /*     IMPORT => ID */
  245,  /*    NK_SEMI => ID */
  245,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "IF",
  /*   59 */ "NOT",
  /*   60 */ "EXISTS",
  /*   61 */ "BUFFER",
  /*   62 */ "CACHELAST",
  /*   63 */ "COMP",
  /*   64 */ "DURATION",
  /*   65 */ "NK_VARIABLE",
  /*   66 */ "FSYNC",
  /*   67 */ "MAXROWS",
  /*   68 */ "MINROWS",
  /*   69 */ "KEEP",
  /*   70 */ "PAGES",
  /*   71 */ "PAGESIZE",
  /*   72 */ "PRECISION",
  /*   73 */ "REPLICA",
  /*   74 */ "STRICT",
  /*   75 */ "WAL",
  /*   76 */ "VGROUPS",
  /*   77 */ "SINGLE_STABLE",
  /*   78 */ "RETENTIONS",
  /*   79 */ "SCHEMALESS",
  /*   80 */ "NK_COLON",
  /*   81 */ "TABLE",
  /*   82 */ "NK_LP",
  /*   83 */ "NK_RP",
  /*   84 */ "STABLE",
  /*   85 */ "ADD",
  /*   86 */ "COLUMN",
  /*   87 */ "MODIFY",
  /*   88 */ "RENAME",
  /*   89 */ "TAG",
  /*   90 */ "SET",
  /*   91 */ "NK_EQ",
  /*   92 */ "USING",
  /*   93 */ "TAGS",
  /*   94 */ "COMMENT",
  /*   95 */ "BOOL",
  /*   96 */ "TINYINT",
  /*   97 */ "SMALLINT",
  /*   98 */ "INT",
  /*   99 */ "INTEGER",
  /*  100 */ "BIGINT",
  /*  101 */ "FLOAT",
  /*  102 */ "DOUBLE",
  /*  103 */ "BINARY",
  /*  104 */ "TIMESTAMP",
  /*  105 */ "NCHAR",
  /*  106 */ "UNSIGNED",
  /*  107 */ "JSON",
  /*  108 */ "VARCHAR",
  /*  109 */ "MEDIUMBLOB",
  /*  110 */ "BLOB",
  /*  111 */ "VARBINARY",
  /*  112 */ "DECIMAL",
  /*  113 */ "MAX_DELAY",
  /*  114 */ "WATERMARK",
  /*  115 */ "ROLLUP",
  /*  116 */ "TTL",
  /*  117 */ "SMA",
  /*  118 */ "FIRST",
  /*  119 */ "LAST",
  /*  120 */ "SHOW",
  /*  121 */ "DATABASES",
  /*  122 */ "TABLES",
  /*  123 */ "STABLES",
  /*  124 */ "MNODES",
  /*  125 */ "MODULES",
  /*  126 */ "QNODES",
  /*  127 */ "FUNCTIONS",
  /*  128 */ "INDEXES",
  /*  129 */ "ACCOUNTS",
  /*  130 */ "APPS",
  /*  131 */ "CONNECTIONS",
  /*  132 */ "LICENCE",
  /*  133 */ "GRANTS",
  /*  134 */ "QUERIES",
  /*  135 */ "SCORES",
  /*  136 */ "TOPICS",
  /*  137 */ "VARIABLES",
  /*  138 */ "BNODES",
  /*  139 */ "SNODES",
  /*  140 */ "CLUSTER",
  /*  141 */ "TRANSACTIONS",
  /*  142 */ "DISTRIBUTED",
  /*  143 */ "CONSUMERS",
  /*  144 */ "SUBSCRIPTIONS",
  /*  145 */ "LIKE",
  /*  146 */ "INDEX",
  /*  147 */ "FUNCTION",
  /*  148 */ "INTERVAL",
  /*  149 */ "TOPIC",
  /*  150 */ "AS",
  /*  151 */ "WITH",
  /*  152 */ "META",
  /*  153 */ "CONSUMER",
  /*  154 */ "GROUP",
  /*  155 */ "DESC",
  /*  156 */ "DESCRIBE",
  /*  157 */ "RESET",
  /*  158 */ "QUERY",
  /*  159 */ "CACHE",
  /*  160 */ "EXPLAIN",
  /*  161 */ "ANALYZE",
  /*  162 */ "VERBOSE",
  /*  163 */ "NK_BOOL",
  /*  164 */ "RATIO",
  /*  165 */ "NK_FLOAT",
  /*  166 */ "COMPACT",
  /*  167 */ "VNODES",
  /*  168 */ "IN",
  /*  169 */ "OUTPUTTYPE",
  /*  170 */ "AGGREGATE",
  /*  171 */ "BUFSIZE",
  /*  172 */ "STREAM",
  /*  173 */ "INTO",
  /*  174 */ "TRIGGER",
  /*  175 */ "AT_ONCE",
  /*  176 */ "WINDOW_CLOSE",
  /*  177 */ "IGNORE",
  /*  178 */ "EXPIRED",
  /*  179 */ "KILL",
  /*  180 */ "CONNECTION",
  /*  181 */ "TRANSACTION",
  /*  182 */ "BALANCE",
  /*  183 */ "VGROUP",
  /*  184 */ "MERGE",
  /*  185 */ "REDISTRIBUTE",
  /*  186 */ "SPLIT",
  /*  187 */ "SYNCDB",
  /*  188 */ "DELETE",
  /*  189 */ "NULL",
  /*  190 */ "NK_QUESTION",
  /*  191 */ "NK_ARROW",
  /*  192 */ "ROWTS",
  /*  193 */ "TBNAME",
  /*  194 */ "QSTARTTS",
  /*  195 */ "QENDTS",
  /*  196 */ "WSTARTTS",
  /*  197 */ "WENDTS",
  /*  198 */ "WDURATION",
  /*  199 */ "CAST",
  /*  200 */ "NOW",
  /*  201 */ "TODAY",
  /*  202 */ "TIMEZONE",
  /*  203 */ "CLIENT_VERSION",
  /*  204 */ "SERVER_VERSION",
  /*  205 */ "SERVER_STATUS",
  /*  206 */ "CURRENT_USER",
  /*  207 */ "COUNT",
  /*  208 */ "LAST_ROW",
  /*  209 */ "BETWEEN",
  /*  210 */ "IS",
  /*  211 */ "NK_LT",
  /*  212 */ "NK_GT",
  /*  213 */ "NK_LE",
  /*  214 */ "NK_GE",
  /*  215 */ "NK_NE",
  /*  216 */ "MATCH",
  /*  217 */ "NMATCH",
  /*  218 */ "CONTAINS",
  /*  219 */ "JOIN",
  /*  220 */ "INNER",
  /*  221 */ "SELECT",
  /*  222 */ "DISTINCT",
  /*  223 */ "WHERE",
  /*  224 */ "PARTITION",
  /*  225 */ "BY",
  /*  226 */ "SESSION",
  /*  227 */ "STATE_WINDOW",
  /*  228 */ "SLIDING",
  /*  229 */ "FILL",
  /*  230 */ "VALUE",
  /*  231 */ "NONE",
  /*  232 */ "PREV",
  /*  233 */ "LINEAR",
  /*  234 */ "NEXT",
  /*  235 */ "HAVING",
  /*  236 */ "RANGE",
  /*  237 */ "EVERY",
  /*  238 */ "ORDER",
  /*  239 */ "SLIMIT",
  /*  240 */ "SOFFSET",
  /*  241 */ "LIMIT",
  /*  242 */ "OFFSET",
  /*  243 */ "ASC",
  /*  244 */ "NULLS",
  /*  245 */ "ID",
  /*  246 */ "NK_BITNOT",
  /*  247 */ "INSERT",
  /*  248 */ "VALUES",
  /*  249 */ "IMPORT",
  /*  250 */ "NK_SEMI",
  /*  251 */ "FILE",
  /*  252 */ "cmd",
  /*  253 */ "account_options",
  /*  254 */ "alter_account_options",
  /*  255 */ "literal",
  /*  256 */ "alter_account_option",
  /*  257 */ "user_name",
  /*  258 */ "sysinfo_opt",
  /*  259 */ "privileges",
  /*  260 */ "priv_level",
  /*  261 */ "priv_type_list",
  /*  262 */ "priv_type",
  /*  263 */ "db_name",
  /*  264 */ "dnode_endpoint",
  /*  265 */ "not_exists_opt",
  /*  266 */ "db_options",
  /*  267 */ "exists_opt",
  /*  268 */ "alter_db_options",
  /*  269 */ "integer_list",
  /*  270 */ "variable_list",
  /*  271 */ "retention_list",
  /*  272 */ "alter_db_option",
  /*  273 */ "retention",
  /*  274 */ "full_table_name",
  /*  275 */ "column_def_list",
  /*  276 */ "tags_def_opt",
  /*  277 */ "table_options",
  /*  278 */ "multi_create_clause",
  /*  279 */ "tags_def",
  /*  280 */ "multi_drop_clause",
  /*  281 */ "alter_table_clause",
  /*  282 */ "alter_table_options",
  /*  283 */ "column_name",
  /*  284 */ "type_name",
  /*  285 */ "signed_literal",
  /*  286 */ "create_subtable_clause",
  /*  287 */ "specific_tags_opt",
  /*  288 */ "literal_list",
  /*  289 */ "drop_table_clause",
  /*  290 */ "col_name_list",
  /*  291 */ "table_name",
  /*  292 */ "column_def",
  /*  293 */ "duration_list",
  /*  294 */ "rollup_func_list",
  /*  295 */ "alter_table_option",
  /*  296 */ "duration_literal",
  /*  297 */ "rollup_func_name",
  /*  298 */ "function_name",
  /*  299 */ "col_name",
  /*  300 */ "db_name_cond_opt",
  /*  301 */ "like_pattern_opt",
  /*  302 */ "table_name_cond",
  /*  303 */ "from_db_opt",
  /*  304 */ "index_name",
  /*  305 */ "index_options",
  /*  306 */ "func_list",
  /*  307 */ "sliding_opt",
  /*  308 */ "sma_stream_opt",
  /*  309 */ "func",
  /*  310 */ "expression_list",
  /*  311 */ "stream_options",
  /*  312 */ "topic_name",
  /*  313 */ "query_expression",
  /*  314 */ "cgroup_name",
  /*  315 */ "analyze_opt",
  /*  316 */ "explain_options",
  /*  317 */ "agg_func_opt",
  /*  318 */ "bufsize_opt",
  /*  319 */ "stream_name",
  /*  320 */ "into_opt",
  /*  321 */ "dnode_list",
  /*  322 */ "where_clause_opt",
  /*  323 */ "signed",
  /*  324 */ "literal_func",
  /*  325 */ "table_alias",
  /*  326 */ "column_alias",
  /*  327 */ "expression",
  /*  328 */ "pseudo_column",
  /*  329 */ "column_reference",
  /*  330 */ "function_expression",
  /*  331 */ "subquery",
  /*  332 */ "star_func",
  /*  333 */ "star_func_para_list",
  /*  334 */ "noarg_func",
  /*  335 */ "other_para_list",
  /*  336 */ "star_func_para",
  /*  337 */ "predicate",
  /*  338 */ "compare_op",
  /*  339 */ "in_op",
  /*  340 */ "in_predicate_value",
  /*  341 */ "boolean_value_expression",
  /*  342 */ "boolean_primary",
  /*  343 */ "common_expression",
  /*  344 */ "from_clause_opt",
  /*  345 */ "table_reference_list",
  /*  346 */ "table_reference",
  /*  347 */ "table_primary",
  /*  348 */ "joined_table",
  /*  349 */ "alias_opt",
  /*  350 */ "parenthesized_joined_table",
  /*  351 */ "join_type",
  /*  352 */ "search_condition",
  /*  353 */ "query_specification",
  /*  354 */ "set_quantifier_opt",
  /*  355 */ "select_list",
  /*  356 */ "partition_by_clause_opt",
  /*  357 */ "range_opt",
  /*  358 */ "every_opt",
  /*  359 */ "fill_opt",
  /*  360 */ "twindow_clause_opt",
  /*  361 */ "group_by_clause_opt",
  /*  362 */ "having_clause_opt",
  /*  363 */ "select_item",
  /*  364 */ "fill_mode",
  /*  365 */ "group_by_list",
  /*  366 */ "query_expression_body",
  /*  367 */ "order_by_clause_opt",
  /*  368 */ "slimit_clause_opt",
  /*  369 */ "limit_clause_opt",
  /*  370 */ "query_primary",
  /*  371 */ "sort_specification_list",
  /*  372 */ "sort_specification",
  /*  373 */ "ordering_specification_opt",
  /*  374 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  67 */ "not_exists_opt ::=",
 /*  68 */ "exists_opt ::= IF EXISTS",
 /*  69 */ "exists_opt ::=",
 /*  70 */ "db_options ::=",
 /*  71 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  72 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  73 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  74 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  75 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  76 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  77 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  78 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  79 */ "db_options ::= db_options KEEP integer_list",
 /*  80 */ "db_options ::= db_options KEEP variable_list",
 /*  81 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  82 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  83 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  84 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  85 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  86 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  87 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  88 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  89 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  90 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  91 */ "alter_db_options ::= alter_db_option",
 /*  92 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  93 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  94 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  95 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  96 */ "alter_db_option ::= KEEP integer_list",
 /*  97 */ "alter_db_option ::= KEEP variable_list",
 /*  98 */ "alter_db_option ::= PAGES NK_INTEGER",
 /*  99 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 100 */ "alter_db_option ::= STRICT NK_INTEGER",
 /* 101 */ "alter_db_option ::= WAL NK_INTEGER",
 /* 102 */ "integer_list ::= NK_INTEGER",
 /* 103 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 104 */ "variable_list ::= NK_VARIABLE",
 /* 105 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 106 */ "retention_list ::= retention",
 /* 107 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 108 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 109 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 110 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 111 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 112 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 113 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 114 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 115 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 116 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 117 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 118 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 119 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 120 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 121 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 122 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 123 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 124 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 125 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 126 */ "multi_create_clause ::= create_subtable_clause",
 /* 127 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 128 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options",
 /* 129 */ "multi_drop_clause ::= drop_table_clause",
 /* 130 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 131 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 132 */ "specific_tags_opt ::=",
 /* 133 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 134 */ "full_table_name ::= table_name",
 /* 135 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 136 */ "column_def_list ::= column_def",
 /* 137 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 138 */ "column_def ::= column_name type_name",
 /* 139 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 140 */ "type_name ::= BOOL",
 /* 141 */ "type_name ::= TINYINT",
 /* 142 */ "type_name ::= SMALLINT",
 /* 143 */ "type_name ::= INT",
 /* 144 */ "type_name ::= INTEGER",
 /* 145 */ "type_name ::= BIGINT",
 /* 146 */ "type_name ::= FLOAT",
 /* 147 */ "type_name ::= DOUBLE",
 /* 148 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 149 */ "type_name ::= TIMESTAMP",
 /* 150 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 151 */ "type_name ::= TINYINT UNSIGNED",
 /* 152 */ "type_name ::= SMALLINT UNSIGNED",
 /* 153 */ "type_name ::= INT UNSIGNED",
 /* 154 */ "type_name ::= BIGINT UNSIGNED",
 /* 155 */ "type_name ::= JSON",
 /* 156 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= MEDIUMBLOB",
 /* 158 */ "type_name ::= BLOB",
 /* 159 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 160 */ "type_name ::= DECIMAL",
 /* 161 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 162 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 163 */ "tags_def_opt ::=",
 /* 164 */ "tags_def_opt ::= tags_def",
 /* 165 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 166 */ "table_options ::=",
 /* 167 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 168 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 169 */ "table_options ::= table_options WATERMARK duration_list",
 /* 170 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 171 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 172 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 173 */ "alter_table_options ::= alter_table_option",
 /* 174 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 175 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 176 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 177 */ "duration_list ::= duration_literal",
 /* 178 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 179 */ "rollup_func_list ::= rollup_func_name",
 /* 180 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 181 */ "rollup_func_name ::= function_name",
 /* 182 */ "rollup_func_name ::= FIRST",
 /* 183 */ "rollup_func_name ::= LAST",
 /* 184 */ "col_name_list ::= col_name",
 /* 185 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 186 */ "col_name ::= column_name",
 /* 187 */ "cmd ::= SHOW DNODES",
 /* 188 */ "cmd ::= SHOW USERS",
 /* 189 */ "cmd ::= SHOW DATABASES",
 /* 190 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 191 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 192 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 193 */ "cmd ::= SHOW MNODES",
 /* 194 */ "cmd ::= SHOW MODULES",
 /* 195 */ "cmd ::= SHOW QNODES",
 /* 196 */ "cmd ::= SHOW FUNCTIONS",
 /* 197 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 198 */ "cmd ::= SHOW STREAMS",
 /* 199 */ "cmd ::= SHOW ACCOUNTS",
 /* 200 */ "cmd ::= SHOW APPS",
 /* 201 */ "cmd ::= SHOW CONNECTIONS",
 /* 202 */ "cmd ::= SHOW LICENCE",
 /* 203 */ "cmd ::= SHOW GRANTS",
 /* 204 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 205 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 206 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 207 */ "cmd ::= SHOW QUERIES",
 /* 208 */ "cmd ::= SHOW SCORES",
 /* 209 */ "cmd ::= SHOW TOPICS",
 /* 210 */ "cmd ::= SHOW VARIABLES",
 /* 211 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 212 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 213 */ "cmd ::= SHOW BNODES",
 /* 214 */ "cmd ::= SHOW SNODES",
 /* 215 */ "cmd ::= SHOW CLUSTER",
 /* 216 */ "cmd ::= SHOW TRANSACTIONS",
 /* 217 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 218 */ "cmd ::= SHOW CONSUMERS",
 /* 219 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 220 */ "db_name_cond_opt ::=",
 /* 221 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 222 */ "like_pattern_opt ::=",
 /* 223 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 224 */ "table_name_cond ::= table_name",
 /* 225 */ "from_db_opt ::=",
 /* 226 */ "from_db_opt ::= FROM db_name",
 /* 227 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 228 */ "cmd ::= DROP INDEX exists_opt index_name",
 /* 229 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 230 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 231 */ "func_list ::= func",
 /* 232 */ "func_list ::= func_list NK_COMMA func",
 /* 233 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 234 */ "sma_stream_opt ::=",
 /* 235 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 236 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 237 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 238 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 239 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 240 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 241 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 242 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 243 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 244 */ "cmd ::= DESC full_table_name",
 /* 245 */ "cmd ::= DESCRIBE full_table_name",
 /* 246 */ "cmd ::= RESET QUERY CACHE",
 /* 247 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 248 */ "analyze_opt ::=",
 /* 249 */ "analyze_opt ::= ANALYZE",
 /* 250 */ "explain_options ::=",
 /* 251 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 252 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 253 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 254 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 255 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 256 */ "agg_func_opt ::=",
 /* 257 */ "agg_func_opt ::= AGGREGATE",
 /* 258 */ "bufsize_opt ::=",
 /* 259 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 260 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 261 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 262 */ "into_opt ::=",
 /* 263 */ "into_opt ::= INTO full_table_name",
 /* 264 */ "stream_options ::=",
 /* 265 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 266 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 267 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 268 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 269 */ "stream_options ::= stream_options IGNORE EXPIRED",
 /* 270 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 271 */ "cmd ::= KILL QUERY NK_STRING",
 /* 272 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 273 */ "cmd ::= BALANCE VGROUP",
 /* 274 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 275 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 276 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 277 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 278 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 279 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 280 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 281 */ "cmd ::= query_expression",
 /* 282 */ "literal ::= NK_INTEGER",
 /* 283 */ "literal ::= NK_FLOAT",
 /* 284 */ "literal ::= NK_STRING",
 /* 285 */ "literal ::= NK_BOOL",
 /* 286 */ "literal ::= TIMESTAMP NK_STRING",
 /* 287 */ "literal ::= duration_literal",
 /* 288 */ "literal ::= NULL",
 /* 289 */ "literal ::= NK_QUESTION",
 /* 290 */ "duration_literal ::= NK_VARIABLE",
 /* 291 */ "signed ::= NK_INTEGER",
 /* 292 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 293 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 294 */ "signed ::= NK_FLOAT",
 /* 295 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 296 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 297 */ "signed_literal ::= signed",
 /* 298 */ "signed_literal ::= NK_STRING",
 /* 299 */ "signed_literal ::= NK_BOOL",
 /* 300 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 301 */ "signed_literal ::= duration_literal",
 /* 302 */ "signed_literal ::= NULL",
 /* 303 */ "signed_literal ::= literal_func",
 /* 304 */ "literal_list ::= signed_literal",
 /* 305 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 306 */ "db_name ::= NK_ID",
 /* 307 */ "table_name ::= NK_ID",
 /* 308 */ "column_name ::= NK_ID",
 /* 309 */ "function_name ::= NK_ID",
 /* 310 */ "table_alias ::= NK_ID",
 /* 311 */ "column_alias ::= NK_ID",
 /* 312 */ "user_name ::= NK_ID",
 /* 313 */ "index_name ::= NK_ID",
 /* 314 */ "topic_name ::= NK_ID",
 /* 315 */ "stream_name ::= NK_ID",
 /* 316 */ "cgroup_name ::= NK_ID",
 /* 317 */ "expression ::= literal",
 /* 318 */ "expression ::= pseudo_column",
 /* 319 */ "expression ::= column_reference",
 /* 320 */ "expression ::= function_expression",
 /* 321 */ "expression ::= subquery",
 /* 322 */ "expression ::= NK_LP expression NK_RP",
 /* 323 */ "expression ::= NK_PLUS expression",
 /* 324 */ "expression ::= NK_MINUS expression",
 /* 325 */ "expression ::= expression NK_PLUS expression",
 /* 326 */ "expression ::= expression NK_MINUS expression",
 /* 327 */ "expression ::= expression NK_STAR expression",
 /* 328 */ "expression ::= expression NK_SLASH expression",
 /* 329 */ "expression ::= expression NK_REM expression",
 /* 330 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 331 */ "expression ::= expression NK_BITAND expression",
 /* 332 */ "expression ::= expression NK_BITOR expression",
 /* 333 */ "expression_list ::= expression",
 /* 334 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 335 */ "column_reference ::= column_name",
 /* 336 */ "column_reference ::= table_name NK_DOT column_name",
 /* 337 */ "pseudo_column ::= ROWTS",
 /* 338 */ "pseudo_column ::= TBNAME",
 /* 339 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 340 */ "pseudo_column ::= QSTARTTS",
 /* 341 */ "pseudo_column ::= QENDTS",
 /* 342 */ "pseudo_column ::= WSTARTTS",
 /* 343 */ "pseudo_column ::= WENDTS",
 /* 344 */ "pseudo_column ::= WDURATION",
 /* 345 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 346 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 347 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 348 */ "function_expression ::= literal_func",
 /* 349 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 350 */ "literal_func ::= NOW",
 /* 351 */ "noarg_func ::= NOW",
 /* 352 */ "noarg_func ::= TODAY",
 /* 353 */ "noarg_func ::= TIMEZONE",
 /* 354 */ "noarg_func ::= DATABASE",
 /* 355 */ "noarg_func ::= CLIENT_VERSION",
 /* 356 */ "noarg_func ::= SERVER_VERSION",
 /* 357 */ "noarg_func ::= SERVER_STATUS",
 /* 358 */ "noarg_func ::= CURRENT_USER",
 /* 359 */ "noarg_func ::= USER",
 /* 360 */ "star_func ::= COUNT",
 /* 361 */ "star_func ::= FIRST",
 /* 362 */ "star_func ::= LAST",
 /* 363 */ "star_func ::= LAST_ROW",
 /* 364 */ "star_func_para_list ::= NK_STAR",
 /* 365 */ "star_func_para_list ::= other_para_list",
 /* 366 */ "other_para_list ::= star_func_para",
 /* 367 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 368 */ "star_func_para ::= expression",
 /* 369 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 370 */ "predicate ::= expression compare_op expression",
 /* 371 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 372 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 373 */ "predicate ::= expression IS NULL",
 /* 374 */ "predicate ::= expression IS NOT NULL",
 /* 375 */ "predicate ::= expression in_op in_predicate_value",
 /* 376 */ "compare_op ::= NK_LT",
 /* 377 */ "compare_op ::= NK_GT",
 /* 378 */ "compare_op ::= NK_LE",
 /* 379 */ "compare_op ::= NK_GE",
 /* 380 */ "compare_op ::= NK_NE",
 /* 381 */ "compare_op ::= NK_EQ",
 /* 382 */ "compare_op ::= LIKE",
 /* 383 */ "compare_op ::= NOT LIKE",
 /* 384 */ "compare_op ::= MATCH",
 /* 385 */ "compare_op ::= NMATCH",
 /* 386 */ "compare_op ::= CONTAINS",
 /* 387 */ "in_op ::= IN",
 /* 388 */ "in_op ::= NOT IN",
 /* 389 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 390 */ "boolean_value_expression ::= boolean_primary",
 /* 391 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 392 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 393 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 394 */ "boolean_primary ::= predicate",
 /* 395 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 396 */ "common_expression ::= expression",
 /* 397 */ "common_expression ::= boolean_value_expression",
 /* 398 */ "from_clause_opt ::=",
 /* 399 */ "from_clause_opt ::= FROM table_reference_list",
 /* 400 */ "table_reference_list ::= table_reference",
 /* 401 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 402 */ "table_reference ::= table_primary",
 /* 403 */ "table_reference ::= joined_table",
 /* 404 */ "table_primary ::= table_name alias_opt",
 /* 405 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 406 */ "table_primary ::= subquery alias_opt",
 /* 407 */ "table_primary ::= parenthesized_joined_table",
 /* 408 */ "alias_opt ::=",
 /* 409 */ "alias_opt ::= table_alias",
 /* 410 */ "alias_opt ::= AS table_alias",
 /* 411 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 412 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 413 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 414 */ "join_type ::=",
 /* 415 */ "join_type ::= INNER",
 /* 416 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 417 */ "set_quantifier_opt ::=",
 /* 418 */ "set_quantifier_opt ::= DISTINCT",
 /* 419 */ "set_quantifier_opt ::= ALL",
 /* 420 */ "select_list ::= select_item",
 /* 421 */ "select_list ::= select_list NK_COMMA select_item",
 /* 422 */ "select_item ::= NK_STAR",
 /* 423 */ "select_item ::= common_expression",
 /* 424 */ "select_item ::= common_expression column_alias",
 /* 425 */ "select_item ::= common_expression AS column_alias",
 /* 426 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 427 */ "where_clause_opt ::=",
 /* 428 */ "where_clause_opt ::= WHERE search_condition",
 /* 429 */ "partition_by_clause_opt ::=",
 /* 430 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 431 */ "twindow_clause_opt ::=",
 /* 432 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 433 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 434 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 435 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 436 */ "sliding_opt ::=",
 /* 437 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 438 */ "fill_opt ::=",
 /* 439 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 440 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 441 */ "fill_mode ::= NONE",
 /* 442 */ "fill_mode ::= PREV",
 /* 443 */ "fill_mode ::= NULL",
 /* 444 */ "fill_mode ::= LINEAR",
 /* 445 */ "fill_mode ::= NEXT",
 /* 446 */ "group_by_clause_opt ::=",
 /* 447 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 448 */ "group_by_list ::= expression",
 /* 449 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 450 */ "having_clause_opt ::=",
 /* 451 */ "having_clause_opt ::= HAVING search_condition",
 /* 452 */ "range_opt ::=",
 /* 453 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 454 */ "every_opt ::=",
 /* 455 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 456 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 457 */ "query_expression_body ::= query_primary",
 /* 458 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 459 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 460 */ "query_primary ::= query_specification",
 /* 461 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 462 */ "order_by_clause_opt ::=",
 /* 463 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 464 */ "slimit_clause_opt ::=",
 /* 465 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 466 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 467 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 468 */ "limit_clause_opt ::=",
 /* 469 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 470 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 471 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 472 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 473 */ "search_condition ::= common_expression",
 /* 474 */ "sort_specification_list ::= sort_specification",
 /* 475 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 476 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 477 */ "ordering_specification_opt ::=",
 /* 478 */ "ordering_specification_opt ::= ASC",
 /* 479 */ "ordering_specification_opt ::= DESC",
 /* 480 */ "null_ordering_opt ::=",
 /* 481 */ "null_ordering_opt ::= NULLS FIRST",
 /* 482 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 252: /* cmd */
    case 255: /* literal */
    case 266: /* db_options */
    case 268: /* alter_db_options */
    case 273: /* retention */
    case 274: /* full_table_name */
    case 277: /* table_options */
    case 281: /* alter_table_clause */
    case 282: /* alter_table_options */
    case 285: /* signed_literal */
    case 286: /* create_subtable_clause */
    case 289: /* drop_table_clause */
    case 292: /* column_def */
    case 296: /* duration_literal */
    case 297: /* rollup_func_name */
    case 299: /* col_name */
    case 300: /* db_name_cond_opt */
    case 301: /* like_pattern_opt */
    case 302: /* table_name_cond */
    case 303: /* from_db_opt */
    case 305: /* index_options */
    case 307: /* sliding_opt */
    case 308: /* sma_stream_opt */
    case 309: /* func */
    case 311: /* stream_options */
    case 313: /* query_expression */
    case 316: /* explain_options */
    case 320: /* into_opt */
    case 322: /* where_clause_opt */
    case 323: /* signed */
    case 324: /* literal_func */
    case 327: /* expression */
    case 328: /* pseudo_column */
    case 329: /* column_reference */
    case 330: /* function_expression */
    case 331: /* subquery */
    case 336: /* star_func_para */
    case 337: /* predicate */
    case 340: /* in_predicate_value */
    case 341: /* boolean_value_expression */
    case 342: /* boolean_primary */
    case 343: /* common_expression */
    case 344: /* from_clause_opt */
    case 345: /* table_reference_list */
    case 346: /* table_reference */
    case 347: /* table_primary */
    case 348: /* joined_table */
    case 350: /* parenthesized_joined_table */
    case 352: /* search_condition */
    case 353: /* query_specification */
    case 357: /* range_opt */
    case 358: /* every_opt */
    case 359: /* fill_opt */
    case 360: /* twindow_clause_opt */
    case 362: /* having_clause_opt */
    case 363: /* select_item */
    case 366: /* query_expression_body */
    case 368: /* slimit_clause_opt */
    case 369: /* limit_clause_opt */
    case 370: /* query_primary */
    case 372: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy212)); 
}
      break;
    case 253: /* account_options */
    case 254: /* alter_account_options */
    case 256: /* alter_account_option */
    case 318: /* bufsize_opt */
{
 
}
      break;
    case 257: /* user_name */
    case 260: /* priv_level */
    case 263: /* db_name */
    case 264: /* dnode_endpoint */
    case 283: /* column_name */
    case 291: /* table_name */
    case 298: /* function_name */
    case 304: /* index_name */
    case 312: /* topic_name */
    case 314: /* cgroup_name */
    case 319: /* stream_name */
    case 325: /* table_alias */
    case 326: /* column_alias */
    case 332: /* star_func */
    case 334: /* noarg_func */
    case 349: /* alias_opt */
{
 
}
      break;
    case 258: /* sysinfo_opt */
{
 
}
      break;
    case 259: /* privileges */
    case 261: /* priv_type_list */
    case 262: /* priv_type */
{
 
}
      break;
    case 265: /* not_exists_opt */
    case 267: /* exists_opt */
    case 315: /* analyze_opt */
    case 317: /* agg_func_opt */
    case 354: /* set_quantifier_opt */
{
 
}
      break;
    case 269: /* integer_list */
    case 270: /* variable_list */
    case 271: /* retention_list */
    case 275: /* column_def_list */
    case 276: /* tags_def_opt */
    case 278: /* multi_create_clause */
    case 279: /* tags_def */
    case 280: /* multi_drop_clause */
    case 287: /* specific_tags_opt */
    case 288: /* literal_list */
    case 290: /* col_name_list */
    case 293: /* duration_list */
    case 294: /* rollup_func_list */
    case 306: /* func_list */
    case 310: /* expression_list */
    case 321: /* dnode_list */
    case 333: /* star_func_para_list */
    case 335: /* other_para_list */
    case 355: /* select_list */
    case 356: /* partition_by_clause_opt */
    case 361: /* group_by_clause_opt */
    case 365: /* group_by_list */
    case 367: /* order_by_clause_opt */
    case 371: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy424)); 
}
      break;
    case 272: /* alter_db_option */
    case 295: /* alter_table_option */
{
 
}
      break;
    case 284: /* type_name */
{
 
}
      break;
    case 338: /* compare_op */
    case 339: /* in_op */
{
 
}
      break;
    case 351: /* join_type */
{
 
}
      break;
    case 364: /* fill_mode */
{
 
}
      break;
    case 373: /* ordering_specification_opt */
{
 
}
      break;
    case 374: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  252,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  252,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  253,    0 }, /* (2) account_options ::= */
  {  253,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  253,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  253,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  253,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  253,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  253,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  253,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  253,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  253,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  254,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  254,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  256,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  256,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  256,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  256,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  256,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  256,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  256,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  256,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  256,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  256,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  252,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  252,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  252,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  252,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  252,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  258,    0 }, /* (29) sysinfo_opt ::= */
  {  258,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  252,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  252,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  259,   -1 }, /* (33) privileges ::= ALL */
  {  259,   -1 }, /* (34) privileges ::= priv_type_list */
  {  261,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  261,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  262,   -1 }, /* (37) priv_type ::= READ */
  {  262,   -1 }, /* (38) priv_type ::= WRITE */
  {  260,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  260,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  252,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  252,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  252,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  252,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  252,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  252,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  252,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  252,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  264,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  264,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  264,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  252,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  252,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  252,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  252,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  252,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  252,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  252,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  252,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  252,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  252,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  252,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  252,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  252,   -2 }, /* (64) cmd ::= USE db_name */
  {  252,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  265,   -3 }, /* (66) not_exists_opt ::= IF NOT EXISTS */
  {  265,    0 }, /* (67) not_exists_opt ::= */
  {  267,   -2 }, /* (68) exists_opt ::= IF EXISTS */
  {  267,    0 }, /* (69) exists_opt ::= */
  {  266,    0 }, /* (70) db_options ::= */
  {  266,   -3 }, /* (71) db_options ::= db_options BUFFER NK_INTEGER */
  {  266,   -3 }, /* (72) db_options ::= db_options CACHELAST NK_INTEGER */
  {  266,   -3 }, /* (73) db_options ::= db_options COMP NK_INTEGER */
  {  266,   -3 }, /* (74) db_options ::= db_options DURATION NK_INTEGER */
  {  266,   -3 }, /* (75) db_options ::= db_options DURATION NK_VARIABLE */
  {  266,   -3 }, /* (76) db_options ::= db_options FSYNC NK_INTEGER */
  {  266,   -3 }, /* (77) db_options ::= db_options MAXROWS NK_INTEGER */
  {  266,   -3 }, /* (78) db_options ::= db_options MINROWS NK_INTEGER */
  {  266,   -3 }, /* (79) db_options ::= db_options KEEP integer_list */
  {  266,   -3 }, /* (80) db_options ::= db_options KEEP variable_list */
  {  266,   -3 }, /* (81) db_options ::= db_options PAGES NK_INTEGER */
  {  266,   -3 }, /* (82) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  266,   -3 }, /* (83) db_options ::= db_options PRECISION NK_STRING */
  {  266,   -3 }, /* (84) db_options ::= db_options REPLICA NK_INTEGER */
  {  266,   -3 }, /* (85) db_options ::= db_options STRICT NK_INTEGER */
  {  266,   -3 }, /* (86) db_options ::= db_options WAL NK_INTEGER */
  {  266,   -3 }, /* (87) db_options ::= db_options VGROUPS NK_INTEGER */
  {  266,   -3 }, /* (88) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  266,   -3 }, /* (89) db_options ::= db_options RETENTIONS retention_list */
  {  266,   -3 }, /* (90) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  268,   -1 }, /* (91) alter_db_options ::= alter_db_option */
  {  268,   -2 }, /* (92) alter_db_options ::= alter_db_options alter_db_option */
  {  272,   -2 }, /* (93) alter_db_option ::= BUFFER NK_INTEGER */
  {  272,   -2 }, /* (94) alter_db_option ::= CACHELAST NK_INTEGER */
  {  272,   -2 }, /* (95) alter_db_option ::= FSYNC NK_INTEGER */
  {  272,   -2 }, /* (96) alter_db_option ::= KEEP integer_list */
  {  272,   -2 }, /* (97) alter_db_option ::= KEEP variable_list */
  {  272,   -2 }, /* (98) alter_db_option ::= PAGES NK_INTEGER */
  {  272,   -2 }, /* (99) alter_db_option ::= REPLICA NK_INTEGER */
  {  272,   -2 }, /* (100) alter_db_option ::= STRICT NK_INTEGER */
  {  272,   -2 }, /* (101) alter_db_option ::= WAL NK_INTEGER */
  {  269,   -1 }, /* (102) integer_list ::= NK_INTEGER */
  {  269,   -3 }, /* (103) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  270,   -1 }, /* (104) variable_list ::= NK_VARIABLE */
  {  270,   -3 }, /* (105) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  271,   -1 }, /* (106) retention_list ::= retention */
  {  271,   -3 }, /* (107) retention_list ::= retention_list NK_COMMA retention */
  {  273,   -3 }, /* (108) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  252,   -9 }, /* (109) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  252,   -3 }, /* (110) cmd ::= CREATE TABLE multi_create_clause */
  {  252,   -9 }, /* (111) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  252,   -3 }, /* (112) cmd ::= DROP TABLE multi_drop_clause */
  {  252,   -4 }, /* (113) cmd ::= DROP STABLE exists_opt full_table_name */
  {  252,   -3 }, /* (114) cmd ::= ALTER TABLE alter_table_clause */
  {  252,   -3 }, /* (115) cmd ::= ALTER STABLE alter_table_clause */
  {  281,   -2 }, /* (116) alter_table_clause ::= full_table_name alter_table_options */
  {  281,   -5 }, /* (117) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  281,   -4 }, /* (118) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  281,   -5 }, /* (119) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  281,   -5 }, /* (120) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  281,   -5 }, /* (121) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  281,   -4 }, /* (122) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  281,   -5 }, /* (123) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  281,   -5 }, /* (124) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  281,   -6 }, /* (125) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  278,   -1 }, /* (126) multi_create_clause ::= create_subtable_clause */
  {  278,   -2 }, /* (127) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  286,  -10 }, /* (128) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
  {  280,   -1 }, /* (129) multi_drop_clause ::= drop_table_clause */
  {  280,   -2 }, /* (130) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  289,   -2 }, /* (131) drop_table_clause ::= exists_opt full_table_name */
  {  287,    0 }, /* (132) specific_tags_opt ::= */
  {  287,   -3 }, /* (133) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  274,   -1 }, /* (134) full_table_name ::= table_name */
  {  274,   -3 }, /* (135) full_table_name ::= db_name NK_DOT table_name */
  {  275,   -1 }, /* (136) column_def_list ::= column_def */
  {  275,   -3 }, /* (137) column_def_list ::= column_def_list NK_COMMA column_def */
  {  292,   -2 }, /* (138) column_def ::= column_name type_name */
  {  292,   -4 }, /* (139) column_def ::= column_name type_name COMMENT NK_STRING */
  {  284,   -1 }, /* (140) type_name ::= BOOL */
  {  284,   -1 }, /* (141) type_name ::= TINYINT */
  {  284,   -1 }, /* (142) type_name ::= SMALLINT */
  {  284,   -1 }, /* (143) type_name ::= INT */
  {  284,   -1 }, /* (144) type_name ::= INTEGER */
  {  284,   -1 }, /* (145) type_name ::= BIGINT */
  {  284,   -1 }, /* (146) type_name ::= FLOAT */
  {  284,   -1 }, /* (147) type_name ::= DOUBLE */
  {  284,   -4 }, /* (148) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  284,   -1 }, /* (149) type_name ::= TIMESTAMP */
  {  284,   -4 }, /* (150) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  284,   -2 }, /* (151) type_name ::= TINYINT UNSIGNED */
  {  284,   -2 }, /* (152) type_name ::= SMALLINT UNSIGNED */
  {  284,   -2 }, /* (153) type_name ::= INT UNSIGNED */
  {  284,   -2 }, /* (154) type_name ::= BIGINT UNSIGNED */
  {  284,   -1 }, /* (155) type_name ::= JSON */
  {  284,   -4 }, /* (156) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  284,   -1 }, /* (157) type_name ::= MEDIUMBLOB */
  {  284,   -1 }, /* (158) type_name ::= BLOB */
  {  284,   -4 }, /* (159) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  284,   -1 }, /* (160) type_name ::= DECIMAL */
  {  284,   -4 }, /* (161) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  284,   -6 }, /* (162) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  276,    0 }, /* (163) tags_def_opt ::= */
  {  276,   -1 }, /* (164) tags_def_opt ::= tags_def */
  {  279,   -4 }, /* (165) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  277,    0 }, /* (166) table_options ::= */
  {  277,   -3 }, /* (167) table_options ::= table_options COMMENT NK_STRING */
  {  277,   -3 }, /* (168) table_options ::= table_options MAX_DELAY duration_list */
  {  277,   -3 }, /* (169) table_options ::= table_options WATERMARK duration_list */
  {  277,   -5 }, /* (170) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  277,   -3 }, /* (171) table_options ::= table_options TTL NK_INTEGER */
  {  277,   -5 }, /* (172) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  282,   -1 }, /* (173) alter_table_options ::= alter_table_option */
  {  282,   -2 }, /* (174) alter_table_options ::= alter_table_options alter_table_option */
  {  295,   -2 }, /* (175) alter_table_option ::= COMMENT NK_STRING */
  {  295,   -2 }, /* (176) alter_table_option ::= TTL NK_INTEGER */
  {  293,   -1 }, /* (177) duration_list ::= duration_literal */
  {  293,   -3 }, /* (178) duration_list ::= duration_list NK_COMMA duration_literal */
  {  294,   -1 }, /* (179) rollup_func_list ::= rollup_func_name */
  {  294,   -3 }, /* (180) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  297,   -1 }, /* (181) rollup_func_name ::= function_name */
  {  297,   -1 }, /* (182) rollup_func_name ::= FIRST */
  {  297,   -1 }, /* (183) rollup_func_name ::= LAST */
  {  290,   -1 }, /* (184) col_name_list ::= col_name */
  {  290,   -3 }, /* (185) col_name_list ::= col_name_list NK_COMMA col_name */
  {  299,   -1 }, /* (186) col_name ::= column_name */
  {  252,   -2 }, /* (187) cmd ::= SHOW DNODES */
  {  252,   -2 }, /* (188) cmd ::= SHOW USERS */
  {  252,   -2 }, /* (189) cmd ::= SHOW DATABASES */
  {  252,   -4 }, /* (190) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  252,   -4 }, /* (191) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  252,   -3 }, /* (192) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  252,   -2 }, /* (193) cmd ::= SHOW MNODES */
  {  252,   -2 }, /* (194) cmd ::= SHOW MODULES */
  {  252,   -2 }, /* (195) cmd ::= SHOW QNODES */
  {  252,   -2 }, /* (196) cmd ::= SHOW FUNCTIONS */
  {  252,   -5 }, /* (197) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  252,   -2 }, /* (198) cmd ::= SHOW STREAMS */
  {  252,   -2 }, /* (199) cmd ::= SHOW ACCOUNTS */
  {  252,   -2 }, /* (200) cmd ::= SHOW APPS */
  {  252,   -2 }, /* (201) cmd ::= SHOW CONNECTIONS */
  {  252,   -2 }, /* (202) cmd ::= SHOW LICENCE */
  {  252,   -2 }, /* (203) cmd ::= SHOW GRANTS */
  {  252,   -4 }, /* (204) cmd ::= SHOW CREATE DATABASE db_name */
  {  252,   -4 }, /* (205) cmd ::= SHOW CREATE TABLE full_table_name */
  {  252,   -4 }, /* (206) cmd ::= SHOW CREATE STABLE full_table_name */
  {  252,   -2 }, /* (207) cmd ::= SHOW QUERIES */
  {  252,   -2 }, /* (208) cmd ::= SHOW SCORES */
  {  252,   -2 }, /* (209) cmd ::= SHOW TOPICS */
  {  252,   -2 }, /* (210) cmd ::= SHOW VARIABLES */
  {  252,   -3 }, /* (211) cmd ::= SHOW LOCAL VARIABLES */
  {  252,   -4 }, /* (212) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  252,   -2 }, /* (213) cmd ::= SHOW BNODES */
  {  252,   -2 }, /* (214) cmd ::= SHOW SNODES */
  {  252,   -2 }, /* (215) cmd ::= SHOW CLUSTER */
  {  252,   -2 }, /* (216) cmd ::= SHOW TRANSACTIONS */
  {  252,   -4 }, /* (217) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  252,   -2 }, /* (218) cmd ::= SHOW CONSUMERS */
  {  252,   -2 }, /* (219) cmd ::= SHOW SUBSCRIPTIONS */
  {  300,    0 }, /* (220) db_name_cond_opt ::= */
  {  300,   -2 }, /* (221) db_name_cond_opt ::= db_name NK_DOT */
  {  301,    0 }, /* (222) like_pattern_opt ::= */
  {  301,   -2 }, /* (223) like_pattern_opt ::= LIKE NK_STRING */
  {  302,   -1 }, /* (224) table_name_cond ::= table_name */
  {  303,    0 }, /* (225) from_db_opt ::= */
  {  303,   -2 }, /* (226) from_db_opt ::= FROM db_name */
  {  252,   -8 }, /* (227) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  252,   -4 }, /* (228) cmd ::= DROP INDEX exists_opt index_name */
  {  305,  -10 }, /* (229) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  305,  -12 }, /* (230) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  306,   -1 }, /* (231) func_list ::= func */
  {  306,   -3 }, /* (232) func_list ::= func_list NK_COMMA func */
  {  309,   -4 }, /* (233) func ::= function_name NK_LP expression_list NK_RP */
  {  308,    0 }, /* (234) sma_stream_opt ::= */
  {  308,   -3 }, /* (235) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  308,   -3 }, /* (236) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  252,   -6 }, /* (237) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  252,   -7 }, /* (238) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  252,   -9 }, /* (239) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  252,   -7 }, /* (240) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  252,   -9 }, /* (241) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  252,   -4 }, /* (242) cmd ::= DROP TOPIC exists_opt topic_name */
  {  252,   -7 }, /* (243) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  252,   -2 }, /* (244) cmd ::= DESC full_table_name */
  {  252,   -2 }, /* (245) cmd ::= DESCRIBE full_table_name */
  {  252,   -3 }, /* (246) cmd ::= RESET QUERY CACHE */
  {  252,   -4 }, /* (247) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  315,    0 }, /* (248) analyze_opt ::= */
  {  315,   -1 }, /* (249) analyze_opt ::= ANALYZE */
  {  316,    0 }, /* (250) explain_options ::= */
  {  316,   -3 }, /* (251) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  316,   -3 }, /* (252) explain_options ::= explain_options RATIO NK_FLOAT */
  {  252,   -6 }, /* (253) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  252,  -10 }, /* (254) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  252,   -4 }, /* (255) cmd ::= DROP FUNCTION exists_opt function_name */
  {  317,    0 }, /* (256) agg_func_opt ::= */
  {  317,   -1 }, /* (257) agg_func_opt ::= AGGREGATE */
  {  318,    0 }, /* (258) bufsize_opt ::= */
  {  318,   -2 }, /* (259) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  252,   -8 }, /* (260) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  252,   -4 }, /* (261) cmd ::= DROP STREAM exists_opt stream_name */
  {  320,    0 }, /* (262) into_opt ::= */
  {  320,   -2 }, /* (263) into_opt ::= INTO full_table_name */
  {  311,    0 }, /* (264) stream_options ::= */
  {  311,   -3 }, /* (265) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  311,   -3 }, /* (266) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  311,   -4 }, /* (267) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  311,   -3 }, /* (268) stream_options ::= stream_options WATERMARK duration_literal */
  {  311,   -3 }, /* (269) stream_options ::= stream_options IGNORE EXPIRED */
  {  252,   -3 }, /* (270) cmd ::= KILL CONNECTION NK_INTEGER */
  {  252,   -3 }, /* (271) cmd ::= KILL QUERY NK_STRING */
  {  252,   -3 }, /* (272) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  252,   -2 }, /* (273) cmd ::= BALANCE VGROUP */
  {  252,   -4 }, /* (274) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  252,   -4 }, /* (275) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  252,   -3 }, /* (276) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  321,   -2 }, /* (277) dnode_list ::= DNODE NK_INTEGER */
  {  321,   -3 }, /* (278) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  252,   -3 }, /* (279) cmd ::= SYNCDB db_name REPLICA */
  {  252,   -4 }, /* (280) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  252,   -1 }, /* (281) cmd ::= query_expression */
  {  255,   -1 }, /* (282) literal ::= NK_INTEGER */
  {  255,   -1 }, /* (283) literal ::= NK_FLOAT */
  {  255,   -1 }, /* (284) literal ::= NK_STRING */
  {  255,   -1 }, /* (285) literal ::= NK_BOOL */
  {  255,   -2 }, /* (286) literal ::= TIMESTAMP NK_STRING */
  {  255,   -1 }, /* (287) literal ::= duration_literal */
  {  255,   -1 }, /* (288) literal ::= NULL */
  {  255,   -1 }, /* (289) literal ::= NK_QUESTION */
  {  296,   -1 }, /* (290) duration_literal ::= NK_VARIABLE */
  {  323,   -1 }, /* (291) signed ::= NK_INTEGER */
  {  323,   -2 }, /* (292) signed ::= NK_PLUS NK_INTEGER */
  {  323,   -2 }, /* (293) signed ::= NK_MINUS NK_INTEGER */
  {  323,   -1 }, /* (294) signed ::= NK_FLOAT */
  {  323,   -2 }, /* (295) signed ::= NK_PLUS NK_FLOAT */
  {  323,   -2 }, /* (296) signed ::= NK_MINUS NK_FLOAT */
  {  285,   -1 }, /* (297) signed_literal ::= signed */
  {  285,   -1 }, /* (298) signed_literal ::= NK_STRING */
  {  285,   -1 }, /* (299) signed_literal ::= NK_BOOL */
  {  285,   -2 }, /* (300) signed_literal ::= TIMESTAMP NK_STRING */
  {  285,   -1 }, /* (301) signed_literal ::= duration_literal */
  {  285,   -1 }, /* (302) signed_literal ::= NULL */
  {  285,   -1 }, /* (303) signed_literal ::= literal_func */
  {  288,   -1 }, /* (304) literal_list ::= signed_literal */
  {  288,   -3 }, /* (305) literal_list ::= literal_list NK_COMMA signed_literal */
  {  263,   -1 }, /* (306) db_name ::= NK_ID */
  {  291,   -1 }, /* (307) table_name ::= NK_ID */
  {  283,   -1 }, /* (308) column_name ::= NK_ID */
  {  298,   -1 }, /* (309) function_name ::= NK_ID */
  {  325,   -1 }, /* (310) table_alias ::= NK_ID */
  {  326,   -1 }, /* (311) column_alias ::= NK_ID */
  {  257,   -1 }, /* (312) user_name ::= NK_ID */
  {  304,   -1 }, /* (313) index_name ::= NK_ID */
  {  312,   -1 }, /* (314) topic_name ::= NK_ID */
  {  319,   -1 }, /* (315) stream_name ::= NK_ID */
  {  314,   -1 }, /* (316) cgroup_name ::= NK_ID */
  {  327,   -1 }, /* (317) expression ::= literal */
  {  327,   -1 }, /* (318) expression ::= pseudo_column */
  {  327,   -1 }, /* (319) expression ::= column_reference */
  {  327,   -1 }, /* (320) expression ::= function_expression */
  {  327,   -1 }, /* (321) expression ::= subquery */
  {  327,   -3 }, /* (322) expression ::= NK_LP expression NK_RP */
  {  327,   -2 }, /* (323) expression ::= NK_PLUS expression */
  {  327,   -2 }, /* (324) expression ::= NK_MINUS expression */
  {  327,   -3 }, /* (325) expression ::= expression NK_PLUS expression */
  {  327,   -3 }, /* (326) expression ::= expression NK_MINUS expression */
  {  327,   -3 }, /* (327) expression ::= expression NK_STAR expression */
  {  327,   -3 }, /* (328) expression ::= expression NK_SLASH expression */
  {  327,   -3 }, /* (329) expression ::= expression NK_REM expression */
  {  327,   -3 }, /* (330) expression ::= column_reference NK_ARROW NK_STRING */
  {  327,   -3 }, /* (331) expression ::= expression NK_BITAND expression */
  {  327,   -3 }, /* (332) expression ::= expression NK_BITOR expression */
  {  310,   -1 }, /* (333) expression_list ::= expression */
  {  310,   -3 }, /* (334) expression_list ::= expression_list NK_COMMA expression */
  {  329,   -1 }, /* (335) column_reference ::= column_name */
  {  329,   -3 }, /* (336) column_reference ::= table_name NK_DOT column_name */
  {  328,   -1 }, /* (337) pseudo_column ::= ROWTS */
  {  328,   -1 }, /* (338) pseudo_column ::= TBNAME */
  {  328,   -3 }, /* (339) pseudo_column ::= table_name NK_DOT TBNAME */
  {  328,   -1 }, /* (340) pseudo_column ::= QSTARTTS */
  {  328,   -1 }, /* (341) pseudo_column ::= QENDTS */
  {  328,   -1 }, /* (342) pseudo_column ::= WSTARTTS */
  {  328,   -1 }, /* (343) pseudo_column ::= WENDTS */
  {  328,   -1 }, /* (344) pseudo_column ::= WDURATION */
  {  330,   -4 }, /* (345) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  330,   -4 }, /* (346) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  330,   -6 }, /* (347) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  330,   -1 }, /* (348) function_expression ::= literal_func */
  {  324,   -3 }, /* (349) literal_func ::= noarg_func NK_LP NK_RP */
  {  324,   -1 }, /* (350) literal_func ::= NOW */
  {  334,   -1 }, /* (351) noarg_func ::= NOW */
  {  334,   -1 }, /* (352) noarg_func ::= TODAY */
  {  334,   -1 }, /* (353) noarg_func ::= TIMEZONE */
  {  334,   -1 }, /* (354) noarg_func ::= DATABASE */
  {  334,   -1 }, /* (355) noarg_func ::= CLIENT_VERSION */
  {  334,   -1 }, /* (356) noarg_func ::= SERVER_VERSION */
  {  334,   -1 }, /* (357) noarg_func ::= SERVER_STATUS */
  {  334,   -1 }, /* (358) noarg_func ::= CURRENT_USER */
  {  334,   -1 }, /* (359) noarg_func ::= USER */
  {  332,   -1 }, /* (360) star_func ::= COUNT */
  {  332,   -1 }, /* (361) star_func ::= FIRST */
  {  332,   -1 }, /* (362) star_func ::= LAST */
  {  332,   -1 }, /* (363) star_func ::= LAST_ROW */
  {  333,   -1 }, /* (364) star_func_para_list ::= NK_STAR */
  {  333,   -1 }, /* (365) star_func_para_list ::= other_para_list */
  {  335,   -1 }, /* (366) other_para_list ::= star_func_para */
  {  335,   -3 }, /* (367) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  336,   -1 }, /* (368) star_func_para ::= expression */
  {  336,   -3 }, /* (369) star_func_para ::= table_name NK_DOT NK_STAR */
  {  337,   -3 }, /* (370) predicate ::= expression compare_op expression */
  {  337,   -5 }, /* (371) predicate ::= expression BETWEEN expression AND expression */
  {  337,   -6 }, /* (372) predicate ::= expression NOT BETWEEN expression AND expression */
  {  337,   -3 }, /* (373) predicate ::= expression IS NULL */
  {  337,   -4 }, /* (374) predicate ::= expression IS NOT NULL */
  {  337,   -3 }, /* (375) predicate ::= expression in_op in_predicate_value */
  {  338,   -1 }, /* (376) compare_op ::= NK_LT */
  {  338,   -1 }, /* (377) compare_op ::= NK_GT */
  {  338,   -1 }, /* (378) compare_op ::= NK_LE */
  {  338,   -1 }, /* (379) compare_op ::= NK_GE */
  {  338,   -1 }, /* (380) compare_op ::= NK_NE */
  {  338,   -1 }, /* (381) compare_op ::= NK_EQ */
  {  338,   -1 }, /* (382) compare_op ::= LIKE */
  {  338,   -2 }, /* (383) compare_op ::= NOT LIKE */
  {  338,   -1 }, /* (384) compare_op ::= MATCH */
  {  338,   -1 }, /* (385) compare_op ::= NMATCH */
  {  338,   -1 }, /* (386) compare_op ::= CONTAINS */
  {  339,   -1 }, /* (387) in_op ::= IN */
  {  339,   -2 }, /* (388) in_op ::= NOT IN */
  {  340,   -3 }, /* (389) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  341,   -1 }, /* (390) boolean_value_expression ::= boolean_primary */
  {  341,   -2 }, /* (391) boolean_value_expression ::= NOT boolean_primary */
  {  341,   -3 }, /* (392) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  341,   -3 }, /* (393) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  342,   -1 }, /* (394) boolean_primary ::= predicate */
  {  342,   -3 }, /* (395) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  343,   -1 }, /* (396) common_expression ::= expression */
  {  343,   -1 }, /* (397) common_expression ::= boolean_value_expression */
  {  344,    0 }, /* (398) from_clause_opt ::= */
  {  344,   -2 }, /* (399) from_clause_opt ::= FROM table_reference_list */
  {  345,   -1 }, /* (400) table_reference_list ::= table_reference */
  {  345,   -3 }, /* (401) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  346,   -1 }, /* (402) table_reference ::= table_primary */
  {  346,   -1 }, /* (403) table_reference ::= joined_table */
  {  347,   -2 }, /* (404) table_primary ::= table_name alias_opt */
  {  347,   -4 }, /* (405) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  347,   -2 }, /* (406) table_primary ::= subquery alias_opt */
  {  347,   -1 }, /* (407) table_primary ::= parenthesized_joined_table */
  {  349,    0 }, /* (408) alias_opt ::= */
  {  349,   -1 }, /* (409) alias_opt ::= table_alias */
  {  349,   -2 }, /* (410) alias_opt ::= AS table_alias */
  {  350,   -3 }, /* (411) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  350,   -3 }, /* (412) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  348,   -6 }, /* (413) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  351,    0 }, /* (414) join_type ::= */
  {  351,   -1 }, /* (415) join_type ::= INNER */
  {  353,  -12 }, /* (416) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  354,    0 }, /* (417) set_quantifier_opt ::= */
  {  354,   -1 }, /* (418) set_quantifier_opt ::= DISTINCT */
  {  354,   -1 }, /* (419) set_quantifier_opt ::= ALL */
  {  355,   -1 }, /* (420) select_list ::= select_item */
  {  355,   -3 }, /* (421) select_list ::= select_list NK_COMMA select_item */
  {  363,   -1 }, /* (422) select_item ::= NK_STAR */
  {  363,   -1 }, /* (423) select_item ::= common_expression */
  {  363,   -2 }, /* (424) select_item ::= common_expression column_alias */
  {  363,   -3 }, /* (425) select_item ::= common_expression AS column_alias */
  {  363,   -3 }, /* (426) select_item ::= table_name NK_DOT NK_STAR */
  {  322,    0 }, /* (427) where_clause_opt ::= */
  {  322,   -2 }, /* (428) where_clause_opt ::= WHERE search_condition */
  {  356,    0 }, /* (429) partition_by_clause_opt ::= */
  {  356,   -3 }, /* (430) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  360,    0 }, /* (431) twindow_clause_opt ::= */
  {  360,   -6 }, /* (432) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  360,   -4 }, /* (433) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  360,   -6 }, /* (434) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  360,   -8 }, /* (435) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  307,    0 }, /* (436) sliding_opt ::= */
  {  307,   -4 }, /* (437) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  359,    0 }, /* (438) fill_opt ::= */
  {  359,   -4 }, /* (439) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  359,   -6 }, /* (440) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  364,   -1 }, /* (441) fill_mode ::= NONE */
  {  364,   -1 }, /* (442) fill_mode ::= PREV */
  {  364,   -1 }, /* (443) fill_mode ::= NULL */
  {  364,   -1 }, /* (444) fill_mode ::= LINEAR */
  {  364,   -1 }, /* (445) fill_mode ::= NEXT */
  {  361,    0 }, /* (446) group_by_clause_opt ::= */
  {  361,   -3 }, /* (447) group_by_clause_opt ::= GROUP BY group_by_list */
  {  365,   -1 }, /* (448) group_by_list ::= expression */
  {  365,   -3 }, /* (449) group_by_list ::= group_by_list NK_COMMA expression */
  {  362,    0 }, /* (450) having_clause_opt ::= */
  {  362,   -2 }, /* (451) having_clause_opt ::= HAVING search_condition */
  {  357,    0 }, /* (452) range_opt ::= */
  {  357,   -6 }, /* (453) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  358,    0 }, /* (454) every_opt ::= */
  {  358,   -4 }, /* (455) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  313,   -4 }, /* (456) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  366,   -1 }, /* (457) query_expression_body ::= query_primary */
  {  366,   -4 }, /* (458) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  366,   -3 }, /* (459) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  370,   -1 }, /* (460) query_primary ::= query_specification */
  {  370,   -6 }, /* (461) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  367,    0 }, /* (462) order_by_clause_opt ::= */
  {  367,   -3 }, /* (463) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  368,    0 }, /* (464) slimit_clause_opt ::= */
  {  368,   -2 }, /* (465) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  368,   -4 }, /* (466) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  368,   -4 }, /* (467) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  369,    0 }, /* (468) limit_clause_opt ::= */
  {  369,   -2 }, /* (469) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  369,   -4 }, /* (470) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  369,   -4 }, /* (471) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  331,   -3 }, /* (472) subquery ::= NK_LP query_expression NK_RP */
  {  352,   -1 }, /* (473) search_condition ::= common_expression */
  {  371,   -1 }, /* (474) sort_specification_list ::= sort_specification */
  {  371,   -3 }, /* (475) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  372,   -3 }, /* (476) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  373,    0 }, /* (477) ordering_specification_opt ::= */
  {  373,   -1 }, /* (478) ordering_specification_opt ::= ASC */
  {  373,   -1 }, /* (479) ordering_specification_opt ::= DESC */
  {  374,    0 }, /* (480) null_ordering_opt ::= */
  {  374,   -2 }, /* (481) null_ordering_opt ::= NULLS FIRST */
  {  374,   -2 }, /* (482) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,253,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,254,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,253,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,255,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,256,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,254,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,256,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,255,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy329, &yymsp[-1].minor.yy0, yymsp[0].minor.yy653); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy329, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy329, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy329, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy329); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy653 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy653 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy609, &yymsp[-2].minor.yy329, &yymsp[0].minor.yy329); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy609, &yymsp[-2].minor.yy329, &yymsp[0].minor.yy329); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy609 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy609 = yymsp[0].minor.yy609; }
  yymsp[0].minor.yy609 = yylhsminor.yy609;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy609 = yymsp[-2].minor.yy609 | yymsp[0].minor.yy609; }
  yymsp[-2].minor.yy609 = yylhsminor.yy609;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy609 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy609 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy329 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy329 = yylhsminor.yy329;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy329 = yymsp[-2].minor.yy329; }
  yymsp[-2].minor.yy329 = yylhsminor.yy329;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy329, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy329, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy329); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 306: /* db_name ::= NK_ID */ yytestcase(yyruleno==306);
      case 307: /* table_name ::= NK_ID */ yytestcase(yyruleno==307);
      case 308: /* column_name ::= NK_ID */ yytestcase(yyruleno==308);
      case 309: /* function_name ::= NK_ID */ yytestcase(yyruleno==309);
      case 310: /* table_alias ::= NK_ID */ yytestcase(yyruleno==310);
      case 311: /* column_alias ::= NK_ID */ yytestcase(yyruleno==311);
      case 312: /* user_name ::= NK_ID */ yytestcase(yyruleno==312);
      case 313: /* index_name ::= NK_ID */ yytestcase(yyruleno==313);
      case 314: /* topic_name ::= NK_ID */ yytestcase(yyruleno==314);
      case 315: /* stream_name ::= NK_ID */ yytestcase(yyruleno==315);
      case 316: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==316);
      case 351: /* noarg_func ::= NOW */ yytestcase(yyruleno==351);
      case 352: /* noarg_func ::= TODAY */ yytestcase(yyruleno==352);
      case 353: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==353);
      case 354: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==354);
      case 355: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==355);
      case 356: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==356);
      case 357: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==357);
      case 358: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==358);
      case 359: /* noarg_func ::= USER */ yytestcase(yyruleno==359);
      case 360: /* star_func ::= COUNT */ yytestcase(yyruleno==360);
      case 361: /* star_func ::= FIRST */ yytestcase(yyruleno==361);
      case 362: /* star_func ::= LAST */ yytestcase(yyruleno==362);
      case 363: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==363);
{ yylhsminor.yy329 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy329 = yylhsminor.yy329;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy737, &yymsp[-1].minor.yy329, yymsp[0].minor.yy212); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy737, &yymsp[0].minor.yy329); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy329); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy329, yymsp[0].minor.yy212); }
        break;
      case 66: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy737 = true; }
        break;
      case 67: /* not_exists_opt ::= */
      case 69: /* exists_opt ::= */ yytestcase(yyruleno==69);
      case 248: /* analyze_opt ::= */ yytestcase(yyruleno==248);
      case 256: /* agg_func_opt ::= */ yytestcase(yyruleno==256);
      case 417: /* set_quantifier_opt ::= */ yytestcase(yyruleno==417);
{ yymsp[1].minor.yy737 = false; }
        break;
      case 68: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy737 = true; }
        break;
      case 70: /* db_options ::= */
{ yymsp[1].minor.yy212 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 71: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy212 = setDatabaseOption(pCxt, yymsp[-2].minor.yy212, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 72: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy212 = setDatabaseOption(pCxt, yymsp[-2].minor.yy212, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 73: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy212 = setDatabaseOption(pCxt, yymsp[-2].minor.yy212, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 74: /* db_options ::= db_options DURATION NK_INTEGER */
      case 75: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==75);
{ yylhsminor.yy212 = setDatabaseOption(pCxt, yymsp[-2].minor.yy212, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 76: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy212 = setDatabaseOption(pCxt, yymsp[-2].minor.yy212, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 77: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy212 = setDatabaseOption(pCxt, yymsp[-2].minor.yy212, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 78: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy212 = setDatabaseOption(pCxt, yymsp[-2].minor.yy212, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 79: /* db_options ::= db_options KEEP integer_list */
      case 80: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==80);
{ yylhsminor.yy212 = setDatabaseOption(pCxt, yymsp[-2].minor.yy212, DB_OPTION_KEEP, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 81: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy212 = setDatabaseOption(pCxt, yymsp[-2].minor.yy212, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 82: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy212 = setDatabaseOption(pCxt, yymsp[-2].minor.yy212, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 83: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy212 = setDatabaseOption(pCxt, yymsp[-2].minor.yy212, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 84: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy212 = setDatabaseOption(pCxt, yymsp[-2].minor.yy212, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 85: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy212 = setDatabaseOption(pCxt, yymsp[-2].minor.yy212, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 86: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy212 = setDatabaseOption(pCxt, yymsp[-2].minor.yy212, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 87: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy212 = setDatabaseOption(pCxt, yymsp[-2].minor.yy212, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 88: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy212 = setDatabaseOption(pCxt, yymsp[-2].minor.yy212, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 89: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy212 = setDatabaseOption(pCxt, yymsp[-2].minor.yy212, DB_OPTION_RETENTIONS, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 90: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy212 = setDatabaseOption(pCxt, yymsp[-2].minor.yy212, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 91: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy212 = createAlterDatabaseOptions(pCxt); yylhsminor.yy212 = setAlterDatabaseOption(pCxt, yylhsminor.yy212, &yymsp[0].minor.yy245); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 92: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy212 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy212, &yymsp[0].minor.yy245); }
  yymsp[-1].minor.yy212 = yylhsminor.yy212;
        break;
      case 93: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy245.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy245.val = yymsp[0].minor.yy0; }
        break;
      case 94: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy245.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy245.val = yymsp[0].minor.yy0; }
        break;
      case 95: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy245.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy245.val = yymsp[0].minor.yy0; }
        break;
      case 96: /* alter_db_option ::= KEEP integer_list */
      case 97: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==97);
{ yymsp[-1].minor.yy245.type = DB_OPTION_KEEP; yymsp[-1].minor.yy245.pList = yymsp[0].minor.yy424; }
        break;
      case 98: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy245.type = DB_OPTION_PAGES; yymsp[-1].minor.yy245.val = yymsp[0].minor.yy0; }
        break;
      case 99: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy245.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy245.val = yymsp[0].minor.yy0; }
        break;
      case 100: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy245.type = DB_OPTION_STRICT; yymsp[-1].minor.yy245.val = yymsp[0].minor.yy0; }
        break;
      case 101: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy245.type = DB_OPTION_WAL; yymsp[-1].minor.yy245.val = yymsp[0].minor.yy0; }
        break;
      case 102: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy424 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 103: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 278: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==278);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 104: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy424 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 105: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 106: /* retention_list ::= retention */
      case 126: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==126);
      case 129: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==129);
      case 136: /* column_def_list ::= column_def */ yytestcase(yyruleno==136);
      case 179: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==179);
      case 184: /* col_name_list ::= col_name */ yytestcase(yyruleno==184);
      case 231: /* func_list ::= func */ yytestcase(yyruleno==231);
      case 304: /* literal_list ::= signed_literal */ yytestcase(yyruleno==304);
      case 366: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==366);
      case 420: /* select_list ::= select_item */ yytestcase(yyruleno==420);
      case 474: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==474);
{ yylhsminor.yy424 = createNodeList(pCxt, yymsp[0].minor.yy212); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 107: /* retention_list ::= retention_list NK_COMMA retention */
      case 137: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==137);
      case 180: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==180);
      case 185: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==185);
      case 232: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==232);
      case 305: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==305);
      case 367: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==367);
      case 421: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==421);
      case 475: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==475);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, yymsp[0].minor.yy212); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 108: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy212 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 109: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 111: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==111);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy737, yymsp[-5].minor.yy212, yymsp[-3].minor.yy424, yymsp[-1].minor.yy424, yymsp[0].minor.yy212); }
        break;
      case 110: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy424); }
        break;
      case 112: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy424); }
        break;
      case 113: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy737, yymsp[0].minor.yy212); }
        break;
      case 114: /* cmd ::= ALTER TABLE alter_table_clause */
      case 115: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==115);
      case 281: /* cmd ::= query_expression */ yytestcase(yyruleno==281);
{ pCxt->pRootNode = yymsp[0].minor.yy212; }
        break;
      case 116: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy212 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy212, yymsp[0].minor.yy212); }
  yymsp[-1].minor.yy212 = yylhsminor.yy212;
        break;
      case 117: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy212 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy212, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy329, yymsp[0].minor.yy34); }
  yymsp[-4].minor.yy212 = yylhsminor.yy212;
        break;
      case 118: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy212 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy212, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy329); }
  yymsp[-3].minor.yy212 = yylhsminor.yy212;
        break;
      case 119: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy212 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy212, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy329, yymsp[0].minor.yy34); }
  yymsp[-4].minor.yy212 = yylhsminor.yy212;
        break;
      case 120: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy212 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy212, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy329, &yymsp[0].minor.yy329); }
  yymsp[-4].minor.yy212 = yylhsminor.yy212;
        break;
      case 121: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy212 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy212, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy329, yymsp[0].minor.yy34); }
  yymsp[-4].minor.yy212 = yylhsminor.yy212;
        break;
      case 122: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy212 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy212, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy329); }
  yymsp[-3].minor.yy212 = yylhsminor.yy212;
        break;
      case 123: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy212 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy212, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy329, yymsp[0].minor.yy34); }
  yymsp[-4].minor.yy212 = yylhsminor.yy212;
        break;
      case 124: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy212 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy212, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy329, &yymsp[0].minor.yy329); }
  yymsp[-4].minor.yy212 = yylhsminor.yy212;
        break;
      case 125: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy212 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy212, &yymsp[-2].minor.yy329, yymsp[0].minor.yy212); }
  yymsp[-5].minor.yy212 = yylhsminor.yy212;
        break;
      case 127: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 130: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==130);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-1].minor.yy424, yymsp[0].minor.yy212); }
  yymsp[-1].minor.yy424 = yylhsminor.yy424;
        break;
      case 128: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
{ yylhsminor.yy212 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy737, yymsp[-8].minor.yy212, yymsp[-6].minor.yy212, yymsp[-5].minor.yy424, yymsp[-2].minor.yy424, yymsp[0].minor.yy212); }
  yymsp[-9].minor.yy212 = yylhsminor.yy212;
        break;
      case 131: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy212 = createDropTableClause(pCxt, yymsp[-1].minor.yy737, yymsp[0].minor.yy212); }
  yymsp[-1].minor.yy212 = yylhsminor.yy212;
        break;
      case 132: /* specific_tags_opt ::= */
      case 163: /* tags_def_opt ::= */ yytestcase(yyruleno==163);
      case 429: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==429);
      case 446: /* group_by_clause_opt ::= */ yytestcase(yyruleno==446);
      case 462: /* order_by_clause_opt ::= */ yytestcase(yyruleno==462);
{ yymsp[1].minor.yy424 = NULL; }
        break;
      case 133: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy424 = yymsp[-1].minor.yy424; }
        break;
      case 134: /* full_table_name ::= table_name */
{ yylhsminor.yy212 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy329, NULL); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 135: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy212 = createRealTableNode(pCxt, &yymsp[-2].minor.yy329, &yymsp[0].minor.yy329, NULL); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 138: /* column_def ::= column_name type_name */
{ yylhsminor.yy212 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy329, yymsp[0].minor.yy34, NULL); }
  yymsp[-1].minor.yy212 = yylhsminor.yy212;
        break;
      case 139: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy212 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy329, yymsp[-2].minor.yy34, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy212 = yylhsminor.yy212;
        break;
      case 140: /* type_name ::= BOOL */
{ yymsp[0].minor.yy34 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 141: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy34 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 142: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy34 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 143: /* type_name ::= INT */
      case 144: /* type_name ::= INTEGER */ yytestcase(yyruleno==144);
{ yymsp[0].minor.yy34 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 145: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy34 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 146: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy34 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 147: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy34 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 148: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy34 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 149: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy34 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 150: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy34 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 151: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy34 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 152: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy34 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 153: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy34 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 154: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy34 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 155: /* type_name ::= JSON */
{ yymsp[0].minor.yy34 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 156: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy34 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy34 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 158: /* type_name ::= BLOB */
{ yymsp[0].minor.yy34 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 159: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy34 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 160: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy34 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 161: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy34 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 162: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy34 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 164: /* tags_def_opt ::= tags_def */
      case 365: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==365);
{ yylhsminor.yy424 = yymsp[0].minor.yy424; }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 165: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy424 = yymsp[-1].minor.yy424; }
        break;
      case 166: /* table_options ::= */
{ yymsp[1].minor.yy212 = createDefaultTableOptions(pCxt); }
        break;
      case 167: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy212 = setTableOption(pCxt, yymsp[-2].minor.yy212, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 168: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy212 = setTableOption(pCxt, yymsp[-2].minor.yy212, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 169: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy212 = setTableOption(pCxt, yymsp[-2].minor.yy212, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 170: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy212 = setTableOption(pCxt, yymsp[-4].minor.yy212, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy424); }
  yymsp[-4].minor.yy212 = yylhsminor.yy212;
        break;
      case 171: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy212 = setTableOption(pCxt, yymsp[-2].minor.yy212, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 172: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy212 = setTableOption(pCxt, yymsp[-4].minor.yy212, TABLE_OPTION_SMA, yymsp[-1].minor.yy424); }
  yymsp[-4].minor.yy212 = yylhsminor.yy212;
        break;
      case 173: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy212 = createAlterTableOptions(pCxt); yylhsminor.yy212 = setTableOption(pCxt, yylhsminor.yy212, yymsp[0].minor.yy245.type, &yymsp[0].minor.yy245.val); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 174: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy212 = setTableOption(pCxt, yymsp[-1].minor.yy212, yymsp[0].minor.yy245.type, &yymsp[0].minor.yy245.val); }
  yymsp[-1].minor.yy212 = yylhsminor.yy212;
        break;
      case 175: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy245.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy245.val = yymsp[0].minor.yy0; }
        break;
      case 176: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy245.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy245.val = yymsp[0].minor.yy0; }
        break;
      case 177: /* duration_list ::= duration_literal */
      case 333: /* expression_list ::= expression */ yytestcase(yyruleno==333);
{ yylhsminor.yy424 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy212)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 178: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 334: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==334);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, releaseRawExprNode(pCxt, yymsp[0].minor.yy212)); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 181: /* rollup_func_name ::= function_name */
{ yylhsminor.yy212 = createFunctionNode(pCxt, &yymsp[0].minor.yy329, NULL); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 182: /* rollup_func_name ::= FIRST */
      case 183: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==183);
{ yylhsminor.yy212 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 186: /* col_name ::= column_name */
{ yylhsminor.yy212 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy329); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 187: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 188: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 189: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 190: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy212, yymsp[0].minor.yy212, OP_TYPE_LIKE); }
        break;
      case 191: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy212, yymsp[0].minor.yy212, OP_TYPE_LIKE); }
        break;
      case 192: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy212, NULL, OP_TYPE_LIKE); }
        break;
      case 193: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 194: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 195: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 196: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 197: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy212, yymsp[-1].minor.yy212, OP_TYPE_EQUAL); }
        break;
      case 198: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 199: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 200: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 201: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 202: /* cmd ::= SHOW LICENCE */
      case 203: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==203);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT); }
        break;
      case 204: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy329); }
        break;
      case 205: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy212); }
        break;
      case 206: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy212); }
        break;
      case 207: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 208: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 209: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 210: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 211: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 212: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 213: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 214: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 216: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 217: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy212); }
        break;
      case 218: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 219: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 220: /* db_name_cond_opt ::= */
      case 225: /* from_db_opt ::= */ yytestcase(yyruleno==225);
{ yymsp[1].minor.yy212 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 221: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy212 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy329); }
  yymsp[-1].minor.yy212 = yylhsminor.yy212;
        break;
      case 222: /* like_pattern_opt ::= */
      case 262: /* into_opt ::= */ yytestcase(yyruleno==262);
      case 398: /* from_clause_opt ::= */ yytestcase(yyruleno==398);
      case 427: /* where_clause_opt ::= */ yytestcase(yyruleno==427);
      case 431: /* twindow_clause_opt ::= */ yytestcase(yyruleno==431);
      case 436: /* sliding_opt ::= */ yytestcase(yyruleno==436);
      case 438: /* fill_opt ::= */ yytestcase(yyruleno==438);
      case 450: /* having_clause_opt ::= */ yytestcase(yyruleno==450);
      case 452: /* range_opt ::= */ yytestcase(yyruleno==452);
      case 454: /* every_opt ::= */ yytestcase(yyruleno==454);
      case 464: /* slimit_clause_opt ::= */ yytestcase(yyruleno==464);
      case 468: /* limit_clause_opt ::= */ yytestcase(yyruleno==468);
{ yymsp[1].minor.yy212 = NULL; }
        break;
      case 223: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy212 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 224: /* table_name_cond ::= table_name */
{ yylhsminor.yy212 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy329); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 226: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy212 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy329); }
        break;
      case 227: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy737, &yymsp[-3].minor.yy329, &yymsp[-1].minor.yy329, NULL, yymsp[0].minor.yy212); }
        break;
      case 228: /* cmd ::= DROP INDEX exists_opt index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy737, &yymsp[0].minor.yy329); }
        break;
      case 229: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy212 = createIndexOption(pCxt, yymsp[-7].minor.yy424, releaseRawExprNode(pCxt, yymsp[-3].minor.yy212), NULL, yymsp[-1].minor.yy212, yymsp[0].minor.yy212); }
        break;
      case 230: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy212 = createIndexOption(pCxt, yymsp[-9].minor.yy424, releaseRawExprNode(pCxt, yymsp[-5].minor.yy212), releaseRawExprNode(pCxt, yymsp[-3].minor.yy212), yymsp[-1].minor.yy212, yymsp[0].minor.yy212); }
        break;
      case 233: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy212 = createFunctionNode(pCxt, &yymsp[-3].minor.yy329, yymsp[-1].minor.yy424); }
  yymsp[-3].minor.yy212 = yylhsminor.yy212;
        break;
      case 234: /* sma_stream_opt ::= */
      case 264: /* stream_options ::= */ yytestcase(yyruleno==264);
{ yymsp[1].minor.yy212 = createStreamOptions(pCxt); }
        break;
      case 235: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 268: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==268);
{ ((SStreamOptions*)yymsp[-2].minor.yy212)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy212); yylhsminor.yy212 = yymsp[-2].minor.yy212; }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 236: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy212)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy212); yylhsminor.yy212 = yymsp[-2].minor.yy212; }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 237: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy737, &yymsp[-2].minor.yy329, yymsp[0].minor.yy212); }
        break;
      case 238: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy737, &yymsp[-3].minor.yy329, &yymsp[0].minor.yy329, false); }
        break;
      case 239: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy737, &yymsp[-5].minor.yy329, &yymsp[0].minor.yy329, true); }
        break;
      case 240: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy737, &yymsp[-3].minor.yy329, yymsp[0].minor.yy212, false); }
        break;
      case 241: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy737, &yymsp[-5].minor.yy329, yymsp[0].minor.yy212, true); }
        break;
      case 242: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy737, &yymsp[0].minor.yy329); }
        break;
      case 243: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy737, &yymsp[-2].minor.yy329, &yymsp[0].minor.yy329); }
        break;
      case 244: /* cmd ::= DESC full_table_name */
      case 245: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==245);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy212); }
        break;
      case 246: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 247: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy737, yymsp[-1].minor.yy212, yymsp[0].minor.yy212); }
        break;
      case 249: /* analyze_opt ::= ANALYZE */
      case 257: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==257);
      case 418: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==418);
{ yymsp[0].minor.yy737 = true; }
        break;
      case 250: /* explain_options ::= */
{ yymsp[1].minor.yy212 = createDefaultExplainOptions(pCxt); }
        break;
      case 251: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy212 = setExplainVerbose(pCxt, yymsp[-2].minor.yy212, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 252: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy212 = setExplainRatio(pCxt, yymsp[-2].minor.yy212, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 253: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy424); }
        break;
      case 254: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy737, yymsp[-8].minor.yy737, &yymsp[-5].minor.yy329, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy34, yymsp[0].minor.yy610); }
        break;
      case 255: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy737, &yymsp[0].minor.yy329); }
        break;
      case 258: /* bufsize_opt ::= */
{ yymsp[1].minor.yy610 = 0; }
        break;
      case 259: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy610 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 260: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy737, &yymsp[-4].minor.yy329, yymsp[-2].minor.yy212, yymsp[-3].minor.yy212, yymsp[0].minor.yy212); }
        break;
      case 261: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy737, &yymsp[0].minor.yy329); }
        break;
      case 263: /* into_opt ::= INTO full_table_name */
      case 399: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==399);
      case 428: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==428);
      case 451: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==451);
{ yymsp[-1].minor.yy212 = yymsp[0].minor.yy212; }
        break;
      case 265: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy212)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy212 = yymsp[-2].minor.yy212; }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 266: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy212)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy212 = yymsp[-2].minor.yy212; }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 267: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy212)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy212)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy212); yylhsminor.yy212 = yymsp[-3].minor.yy212; }
  yymsp[-3].minor.yy212 = yylhsminor.yy212;
        break;
      case 269: /* stream_options ::= stream_options IGNORE EXPIRED */
{ ((SStreamOptions*)yymsp[-2].minor.yy212)->ignoreExpired = true; yylhsminor.yy212 = yymsp[-2].minor.yy212; }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 270: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 271: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 272: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 273: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 274: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 275: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy424); }
        break;
      case 276: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 277: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy424 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 279: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy329); }
        break;
      case 280: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy212, yymsp[0].minor.yy212); }
        break;
      case 282: /* literal ::= NK_INTEGER */
{ yylhsminor.yy212 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 283: /* literal ::= NK_FLOAT */
{ yylhsminor.yy212 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 284: /* literal ::= NK_STRING */
{ yylhsminor.yy212 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 285: /* literal ::= NK_BOOL */
{ yylhsminor.yy212 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 286: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy212 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy212 = yylhsminor.yy212;
        break;
      case 287: /* literal ::= duration_literal */
      case 297: /* signed_literal ::= signed */ yytestcase(yyruleno==297);
      case 317: /* expression ::= literal */ yytestcase(yyruleno==317);
      case 318: /* expression ::= pseudo_column */ yytestcase(yyruleno==318);
      case 319: /* expression ::= column_reference */ yytestcase(yyruleno==319);
      case 320: /* expression ::= function_expression */ yytestcase(yyruleno==320);
      case 321: /* expression ::= subquery */ yytestcase(yyruleno==321);
      case 348: /* function_expression ::= literal_func */ yytestcase(yyruleno==348);
      case 390: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==390);
      case 394: /* boolean_primary ::= predicate */ yytestcase(yyruleno==394);
      case 396: /* common_expression ::= expression */ yytestcase(yyruleno==396);
      case 397: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==397);
      case 400: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==400);
      case 402: /* table_reference ::= table_primary */ yytestcase(yyruleno==402);
      case 403: /* table_reference ::= joined_table */ yytestcase(yyruleno==403);
      case 407: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==407);
      case 457: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==457);
      case 460: /* query_primary ::= query_specification */ yytestcase(yyruleno==460);
{ yylhsminor.yy212 = yymsp[0].minor.yy212; }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 288: /* literal ::= NULL */
{ yylhsminor.yy212 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 289: /* literal ::= NK_QUESTION */
{ yylhsminor.yy212 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 290: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy212 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 291: /* signed ::= NK_INTEGER */
{ yylhsminor.yy212 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 292: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy212 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 293: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy212 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy212 = yylhsminor.yy212;
        break;
      case 294: /* signed ::= NK_FLOAT */
{ yylhsminor.yy212 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 295: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy212 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 296: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy212 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy212 = yylhsminor.yy212;
        break;
      case 298: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy212 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 299: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy212 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 300: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy212 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 301: /* signed_literal ::= duration_literal */
      case 303: /* signed_literal ::= literal_func */ yytestcase(yyruleno==303);
      case 368: /* star_func_para ::= expression */ yytestcase(yyruleno==368);
      case 423: /* select_item ::= common_expression */ yytestcase(yyruleno==423);
      case 473: /* search_condition ::= common_expression */ yytestcase(yyruleno==473);
{ yylhsminor.yy212 = releaseRawExprNode(pCxt, yymsp[0].minor.yy212); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 302: /* signed_literal ::= NULL */
{ yylhsminor.yy212 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 322: /* expression ::= NK_LP expression NK_RP */
      case 395: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==395);
{ yylhsminor.yy212 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy212)); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 323: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy212);
                                                                                    yylhsminor.yy212 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy212));
                                                                                  }
  yymsp[-1].minor.yy212 = yylhsminor.yy212;
        break;
      case 324: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy212);
                                                                                    yylhsminor.yy212 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy212), NULL));
                                                                                  }
  yymsp[-1].minor.yy212 = yylhsminor.yy212;
        break;
      case 325: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy212);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy212);
                                                                                    yylhsminor.yy212 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy212), releaseRawExprNode(pCxt, yymsp[0].minor.yy212))); 
                                                                                  }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 326: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy212);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy212);
                                                                                    yylhsminor.yy212 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy212), releaseRawExprNode(pCxt, yymsp[0].minor.yy212))); 
                                                                                  }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 327: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy212);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy212);
                                                                                    yylhsminor.yy212 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy212), releaseRawExprNode(pCxt, yymsp[0].minor.yy212))); 
                                                                                  }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 328: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy212);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy212);
                                                                                    yylhsminor.yy212 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy212), releaseRawExprNode(pCxt, yymsp[0].minor.yy212))); 
                                                                                  }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 329: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy212);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy212);
                                                                                    yylhsminor.yy212 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy212), releaseRawExprNode(pCxt, yymsp[0].minor.yy212)));
                                                                                  }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 330: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy212);
                                                                                    yylhsminor.yy212 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy212), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 331: /* expression ::= expression NK_BITAND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy212);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy212);
                                                                                    yylhsminor.yy212 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy212), releaseRawExprNode(pCxt, yymsp[0].minor.yy212)));
                                                                                  }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 332: /* expression ::= expression NK_BITOR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy212);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy212);
                                                                                    yylhsminor.yy212 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy212), releaseRawExprNode(pCxt, yymsp[0].minor.yy212)));
                                                                                  }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 335: /* column_reference ::= column_name */
{ yylhsminor.yy212 = createRawExprNode(pCxt, &yymsp[0].minor.yy329, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy329)); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 336: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy212 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy329, &yymsp[0].minor.yy329, createColumnNode(pCxt, &yymsp[-2].minor.yy329, &yymsp[0].minor.yy329)); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 337: /* pseudo_column ::= ROWTS */
      case 338: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==338);
      case 340: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==340);
      case 341: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==341);
      case 342: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==342);
      case 343: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==343);
      case 344: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==344);
      case 350: /* literal_func ::= NOW */ yytestcase(yyruleno==350);
{ yylhsminor.yy212 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 339: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy212 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy329, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy329)))); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 345: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 346: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==346);
{ yylhsminor.yy212 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy329, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy329, yymsp[-1].minor.yy424)); }
  yymsp[-3].minor.yy212 = yylhsminor.yy212;
        break;
      case 347: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy212 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy212), yymsp[-1].minor.yy34)); }
  yymsp[-5].minor.yy212 = yylhsminor.yy212;
        break;
      case 349: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy212 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy329, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy329, NULL)); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 364: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy424 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 369: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 426: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==426);
{ yylhsminor.yy212 = createColumnNode(pCxt, &yymsp[-2].minor.yy329, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 370: /* predicate ::= expression compare_op expression */
      case 375: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==375);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy212);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy212);
                                                                                    yylhsminor.yy212 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy290, releaseRawExprNode(pCxt, yymsp[-2].minor.yy212), releaseRawExprNode(pCxt, yymsp[0].minor.yy212)));
                                                                                  }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 371: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy212);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy212);
                                                                                    yylhsminor.yy212 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy212), releaseRawExprNode(pCxt, yymsp[-2].minor.yy212), releaseRawExprNode(pCxt, yymsp[0].minor.yy212)));
                                                                                  }
  yymsp[-4].minor.yy212 = yylhsminor.yy212;
        break;
      case 372: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy212);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy212);
                                                                                    yylhsminor.yy212 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy212), releaseRawExprNode(pCxt, yymsp[-2].minor.yy212), releaseRawExprNode(pCxt, yymsp[0].minor.yy212)));
                                                                                  }
  yymsp[-5].minor.yy212 = yylhsminor.yy212;
        break;
      case 373: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy212);
                                                                                    yylhsminor.yy212 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy212), NULL));
                                                                                  }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 374: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy212);
                                                                                    yylhsminor.yy212 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy212), NULL));
                                                                                  }
  yymsp[-3].minor.yy212 = yylhsminor.yy212;
        break;
      case 376: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy290 = OP_TYPE_LOWER_THAN; }
        break;
      case 377: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy290 = OP_TYPE_GREATER_THAN; }
        break;
      case 378: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy290 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 379: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy290 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 380: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy290 = OP_TYPE_NOT_EQUAL; }
        break;
      case 381: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy290 = OP_TYPE_EQUAL; }
        break;
      case 382: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy290 = OP_TYPE_LIKE; }
        break;
      case 383: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy290 = OP_TYPE_NOT_LIKE; }
        break;
      case 384: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy290 = OP_TYPE_MATCH; }
        break;
      case 385: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy290 = OP_TYPE_NMATCH; }
        break;
      case 386: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy290 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 387: /* in_op ::= IN */
{ yymsp[0].minor.yy290 = OP_TYPE_IN; }
        break;
      case 388: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy290 = OP_TYPE_NOT_IN; }
        break;
      case 389: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy212 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy424)); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 391: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy212);
                                                                                    yylhsminor.yy212 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy212), NULL));
                                                                                  }
  yymsp[-1].minor.yy212 = yylhsminor.yy212;
        break;
      case 392: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy212);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy212);
                                                                                    yylhsminor.yy212 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy212), releaseRawExprNode(pCxt, yymsp[0].minor.yy212)));
                                                                                  }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 393: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy212);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy212);
                                                                                    yylhsminor.yy212 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy212), releaseRawExprNode(pCxt, yymsp[0].minor.yy212)));
                                                                                  }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 401: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy212 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy212, yymsp[0].minor.yy212, NULL); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 404: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy212 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy329, &yymsp[0].minor.yy329); }
  yymsp[-1].minor.yy212 = yylhsminor.yy212;
        break;
      case 405: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy212 = createRealTableNode(pCxt, &yymsp[-3].minor.yy329, &yymsp[-1].minor.yy329, &yymsp[0].minor.yy329); }
  yymsp[-3].minor.yy212 = yylhsminor.yy212;
        break;
      case 406: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy212 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy212), &yymsp[0].minor.yy329); }
  yymsp[-1].minor.yy212 = yylhsminor.yy212;
        break;
      case 408: /* alias_opt ::= */
{ yymsp[1].minor.yy329 = nil_token;  }
        break;
      case 409: /* alias_opt ::= table_alias */
{ yylhsminor.yy329 = yymsp[0].minor.yy329; }
  yymsp[0].minor.yy329 = yylhsminor.yy329;
        break;
      case 410: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy329 = yymsp[0].minor.yy329; }
        break;
      case 411: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 412: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==412);
{ yymsp[-2].minor.yy212 = yymsp[-1].minor.yy212; }
        break;
      case 413: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy212 = createJoinTableNode(pCxt, yymsp[-4].minor.yy162, yymsp[-5].minor.yy212, yymsp[-2].minor.yy212, yymsp[0].minor.yy212); }
  yymsp[-5].minor.yy212 = yylhsminor.yy212;
        break;
      case 414: /* join_type ::= */
{ yymsp[1].minor.yy162 = JOIN_TYPE_INNER; }
        break;
      case 415: /* join_type ::= INNER */
{ yymsp[0].minor.yy162 = JOIN_TYPE_INNER; }
        break;
      case 416: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy212 = createSelectStmt(pCxt, yymsp[-10].minor.yy737, yymsp[-9].minor.yy424, yymsp[-8].minor.yy212);
                                                                                    yymsp[-11].minor.yy212 = addWhereClause(pCxt, yymsp[-11].minor.yy212, yymsp[-7].minor.yy212);
                                                                                    yymsp[-11].minor.yy212 = addPartitionByClause(pCxt, yymsp[-11].minor.yy212, yymsp[-6].minor.yy424);
                                                                                    yymsp[-11].minor.yy212 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy212, yymsp[-2].minor.yy212);
                                                                                    yymsp[-11].minor.yy212 = addGroupByClause(pCxt, yymsp[-11].minor.yy212, yymsp[-1].minor.yy424);
                                                                                    yymsp[-11].minor.yy212 = addHavingClause(pCxt, yymsp[-11].minor.yy212, yymsp[0].minor.yy212);
                                                                                    yymsp[-11].minor.yy212 = addRangeClause(pCxt, yymsp[-11].minor.yy212, yymsp[-5].minor.yy212);
                                                                                    yymsp[-11].minor.yy212 = addEveryClause(pCxt, yymsp[-11].minor.yy212, yymsp[-4].minor.yy212);
                                                                                    yymsp[-11].minor.yy212 = addFillClause(pCxt, yymsp[-11].minor.yy212, yymsp[-3].minor.yy212);
                                                                                  }
        break;
      case 419: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy737 = false; }
        break;
      case 422: /* select_item ::= NK_STAR */
{ yylhsminor.yy212 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy212 = yylhsminor.yy212;
        break;
      case 424: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy212 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy212), &yymsp[0].minor.yy329); }
  yymsp[-1].minor.yy212 = yylhsminor.yy212;
        break;
      case 425: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy212 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy212), &yymsp[0].minor.yy329); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 430: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 447: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==447);
      case 463: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==463);
{ yymsp[-2].minor.yy424 = yymsp[0].minor.yy424; }
        break;
      case 432: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy212 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy212), releaseRawExprNode(pCxt, yymsp[-1].minor.yy212)); }
        break;
      case 433: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy212 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy212)); }
        break;
      case 434: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy212 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy212), NULL, yymsp[-1].minor.yy212, yymsp[0].minor.yy212); }
        break;
      case 435: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy212 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy212), releaseRawExprNode(pCxt, yymsp[-3].minor.yy212), yymsp[-1].minor.yy212, yymsp[0].minor.yy212); }
        break;
      case 437: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 455: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==455);
{ yymsp[-3].minor.yy212 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy212); }
        break;
      case 439: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy212 = createFillNode(pCxt, yymsp[-1].minor.yy294, NULL); }
        break;
      case 440: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy212 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy424)); }
        break;
      case 441: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy294 = FILL_MODE_NONE; }
        break;
      case 442: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy294 = FILL_MODE_PREV; }
        break;
      case 443: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy294 = FILL_MODE_NULL; }
        break;
      case 444: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy294 = FILL_MODE_LINEAR; }
        break;
      case 445: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy294 = FILL_MODE_NEXT; }
        break;
      case 448: /* group_by_list ::= expression */
{ yylhsminor.yy424 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy212))); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 449: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy212))); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 453: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy212 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy212), releaseRawExprNode(pCxt, yymsp[-1].minor.yy212)); }
        break;
      case 456: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy212 = addOrderByClause(pCxt, yymsp[-3].minor.yy212, yymsp[-2].minor.yy424);
                                                                                    yylhsminor.yy212 = addSlimitClause(pCxt, yylhsminor.yy212, yymsp[-1].minor.yy212);
                                                                                    yylhsminor.yy212 = addLimitClause(pCxt, yylhsminor.yy212, yymsp[0].minor.yy212);
                                                                                  }
  yymsp[-3].minor.yy212 = yylhsminor.yy212;
        break;
      case 458: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy212 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy212, yymsp[0].minor.yy212); }
  yymsp[-3].minor.yy212 = yylhsminor.yy212;
        break;
      case 459: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy212 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy212, yymsp[0].minor.yy212); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 461: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ yymsp[-5].minor.yy212 = yymsp[-4].minor.yy212; }
  yy_destructor(yypParser,367,&yymsp[-3].minor);
  yy_destructor(yypParser,368,&yymsp[-2].minor);
  yy_destructor(yypParser,369,&yymsp[-1].minor);
        break;
      case 465: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 469: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==469);
{ yymsp[-1].minor.yy212 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 466: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 470: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==470);
{ yymsp[-3].minor.yy212 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 467: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 471: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==471);
{ yymsp[-3].minor.yy212 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 472: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy212 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy212); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 476: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy212 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy212), yymsp[-1].minor.yy188, yymsp[0].minor.yy607); }
  yymsp[-2].minor.yy212 = yylhsminor.yy212;
        break;
      case 477: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy188 = ORDER_ASC; }
        break;
      case 478: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy188 = ORDER_ASC; }
        break;
      case 479: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy188 = ORDER_DESC; }
        break;
      case 480: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy607 = NULL_ORDER_DEFAULT; }
        break;
      case 481: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy607 = NULL_ORDER_FIRST; }
        break;
      case 482: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy607 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
