/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 335
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SNode* yy42;
  EJoinType yy102;
  ENullOrder yy197;
  bool yy237;
  int32_t yy240;
  SNodeList* yy244;
  EOperatorType yy270;
  SDataType yy314;
  SAlterOption yy325;
  SToken yy359;
  EOrder yy508;
  EFillMode yy544;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYNSTATE             570
#define YYNRULE              435
#define YYNTOKEN             221
#define YY_MAX_SHIFT         569
#define YY_MIN_SHIFTREDUCE   847
#define YY_MAX_SHIFTREDUCE   1281
#define YY_ERROR_ACTION      1282
#define YY_ACCEPT_ACTION     1283
#define YY_NO_ACTION         1284
#define YY_MIN_REDUCE        1285
#define YY_MAX_REDUCE        1719
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1813)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   268, 1587,  285,   53, 1571,  483,   26,  203,  467, 1385,
 /*    10 */  1283, 1557,   33,   31,   77, 1571,   99, 1557,  483, 1557,
 /*    20 */   277,  380, 1102,  442, 1402, 1553, 1560,  321, 1587,  288,
 /*    30 */  1407, 1553, 1559, 1553, 1559,  467, 1490, 1492, 1100, 1587,
 /*    40 */   124,   69,  435, 1407, 1364,  466,  467, 1384,  104, 1543,
 /*    50 */    12,   33,   31, 1224,  482,  105,  466, 1108,  359,  277,
 /*    60 */  1543, 1102, 1399,  293, 1123,  446, 1571,  241, 1572,  469,
 /*    70 */  1574, 1575,  465,  482,  460,    1,  323, 1100,   72, 1572,
 /*    80 */   469, 1574, 1575,  465,  102,  460,  562,  561, 1637,   12,
 /*    90 */  1587,  100,  249, 1633,  482,  383, 1108,  445,  566,  133,
 /*   100 */  1644, 1645, 1698, 1649, 1698,  438,  248,  466,  106,   36,
 /*   110 */  1101, 1543,  514,  483,    1,  136, 1651,  136,  386, 1696,
 /*   120 */   359, 1696,  322,   34,   32,   30,   29,   28,   36,   73,
 /*   130 */  1572,  469, 1574, 1575,  465,  517,  460,  566, 1407, 1637,
 /*   140 */  1648,  483,  483,  270, 1633,  131,  123, 1103, 1297, 1101,
 /*   150 */   330,  331, 1398, 1487,  513,  512,  511,  199,  510,  470,
 /*   160 */   145,  250,  280,  425, 1664, 1499, 1407, 1407, 1106, 1107,
 /*   170 */  1651, 1151, 1152, 1153, 1154, 1155, 1156, 1157,  462, 1162,
 /*   180 */  1163, 1164, 1165, 1166, 1167, 1168, 1103, 1138, 1127,   34,
 /*   190 */    32,   30,   29,   28, 1647, 1186,  418, 1543,  137,   34,
 /*   200 */    32,   30,   29,   28,  523,  442, 1379, 1106, 1107,  432,
 /*   210 */  1151, 1152, 1153, 1154, 1155, 1156, 1157,  462, 1162, 1163,
 /*   220 */  1164, 1165, 1166, 1167, 1168,   33,   31,  250,  483,  483,
 /*   230 */   104,  937,  137,  277,  247, 1102, 1123,  358,   77,  317,
 /*   240 */   419,  260,  137,  338, 1187,  387,  350, 1111,   55,  266,
 /*   250 */   939, 1100,  174, 1407, 1407,  351,   34,   32,   30,   29,
 /*   260 */    28, 1186, 1192,   12,   33,   31,  102,  100,  483,  410,
 /*   270 */  1108,  383,  277, 1383, 1102,  437,  433,  291, 1698, 1698,
 /*   280 */   444,  132, 1644, 1645,  261, 1649,  259,  258,    1,  382,
 /*   290 */  1100,  136,  136, 1407,  386, 1696, 1696,   25,  275, 1181,
 /*   300 */  1182, 1183, 1184, 1185, 1189, 1190, 1191,  198, 1698, 1108,
 /*   310 */  1187,  566, 1248,  127,   34,   32,   30,   29,   28, 1114,
 /*   320 */  1238,  136,  519, 1101, 1448, 1696,  120,    7, 1192,  349,
 /*   330 */   385,  384,  344,  343,  342,  341,  340,  449,  337,  336,
 /*   340 */   335,  334,  333,  329,  328,  327,  326,  325,  324,  137,
 /*   350 */   566,  429, 1246, 1247, 1249, 1250,   30,   29,   28,  884,
 /*   360 */  1103,  883, 1101,   25,  275, 1181, 1182, 1183, 1184, 1185,
 /*   370 */  1189, 1190, 1191,   34,   32,   30,   29,   28, 1125,  885,
 /*   380 */   225, 1106, 1107, 1437, 1151, 1152, 1153, 1154, 1155, 1156,
 /*   390 */  1157,  462, 1162, 1163, 1164, 1165, 1166, 1167, 1168, 1103,
 /*   400 */   975,  506,  505,  504,  979,  503,  981,  982,  502,  984,
 /*   410 */   499,  121,  990,  496,  992,  993,  493,  490,  442, 1410,
 /*   420 */  1106, 1107, 1324, 1151, 1152, 1153, 1154, 1155, 1156, 1157,
 /*   430 */   462, 1162, 1163, 1164, 1165, 1166, 1167, 1168,   33,   31,
 /*   440 */  1169, 1571, 1278,  104,  397,  316,  277,  315, 1102,  442,
 /*   450 */   137,   88,  394,  393,   87,   86,   85,   84,   83,   82,
 /*   460 */    81,   80,   79, 1698, 1100, 1587,  483,   34,   32,   30,
 /*   470 */    29,   28,  445,  281,  104, 1404, 1697,   33,   31,  102,
 /*   480 */  1696,  121,  466, 1108,  883,  277, 1543, 1102, 1651, 1409,
 /*   490 */   483, 1407,  436,  446,  134, 1644, 1645,  137, 1649, 1524,
 /*   500 */   378,    7,  519, 1100,   73, 1572,  469, 1574, 1575,  465,
 /*   510 */   102,  460, 1646, 1571, 1637, 1407,  522,  345,  270, 1633,
 /*   520 */   131, 1277, 1108,  401,  566,  196, 1644,  441, 1126,  440,
 /*   530 */     6, 1138, 1698, 1188,  483, 1456, 1101, 1587,  409, 1665,
 /*   540 */     7,  267, 1308,  480,  464,  136, 1454,  483,  448, 1696,
 /*   550 */  1564, 1193,  173,   53,  466,  404,  481,   22, 1543, 1407,
 /*   560 */   398,  143, 1562,  566,  147,  146,  172,   34,   32,   30,
 /*   570 */    29,   28, 1407, 1103, 1403, 1101,  245, 1572,  469, 1574,
 /*   580 */  1575,  465,  463,  460,  458, 1609,   23, 1543,   51,  165,
 /*   590 */  1571,   50,  163,   45, 1106, 1107,   44, 1151, 1152, 1153,
 /*   600 */  1154, 1155, 1156, 1157,  462, 1162, 1163, 1164, 1165, 1166,
 /*   610 */  1167, 1168, 1103,   24, 1587,  450,    9,    8,  534,  516,
 /*   620 */   515,  467,  311,   34,   32,   30,   29,   28, 1307,  535,
 /*   630 */   533,  466, 1223, 1106, 1107, 1543, 1151, 1152, 1153, 1154,
 /*   640 */  1155, 1156, 1157,  462, 1162, 1163, 1164, 1165, 1166, 1167,
 /*   650 */  1168,   33,   31,   73, 1572,  469, 1574, 1575,  465,  277,
 /*   660 */   460, 1102, 1571, 1637, 1456,  483,  308,  270, 1633, 1710,
 /*   670 */   282,  287,  290, 1543,  217, 1454, 1306, 1100, 1671,  121,
 /*   680 */   121, 1491, 1492,   62, 1219,  310, 1587, 1409, 1409, 1456,
 /*   690 */  1407, 1200,  470,  467, 1124,  289, 1108, 1305, 1500,  396,
 /*   700 */  1454,  390, 1304,  466, 1400,  395, 1303, 1543,  101, 1319,
 /*   710 */   391,  389, 1571,  392,    1,  453, 1302,  509,  388, 1301,
 /*   720 */  1300, 1543, 1299, 1296,  417,   73, 1572,  469, 1574, 1575,
 /*   730 */   465,  399,  460, 1396, 1456, 1637, 1587,  566, 1231,  270,
 /*   740 */  1633, 1710, 1543,  467, 1125, 1455,  569, 1543, 1295, 1101,
 /*   750 */  1694, 1543, 1294,  466, 1293, 1128, 1174, 1543, 1292,  451,
 /*   760 */   221, 1543, 1125,   98, 1543, 1543, 1532, 1543, 1543,  558,
 /*   770 */  1317,  554,  550,  546,  220,   73, 1572,  469, 1574, 1575,
 /*   780 */   465, 1291,  460, 1290, 1289, 1637, 1103, 1334, 1288,  270,
 /*   790 */  1633, 1710,  402, 1543, 1656, 1219,  408, 1543, 1110, 1543,
 /*   800 */  1655,   70,  300, 1543,  215,    9,    8, 1106, 1107,  406,
 /*   810 */  1151, 1152, 1153, 1154, 1155, 1156, 1157,  462, 1162, 1163,
 /*   820 */  1164, 1165, 1166, 1167, 1168, 1392, 1543, 1222, 1543, 1543,
 /*   830 */  1088, 1089,  167, 1543,  479,  166, 1571, 1280, 1281,  542,
 /*   840 */   541,  540,  539,  292, 1394,  538,  537,  536,  107,  531,
 /*   850 */   530,  529,  528,  527,  526,  525,  524,  114,  520,  122,
 /*   860 */  1587,  454,  424, 1382,  231,  180, 1571,  467,  169,  171,
 /*   870 */  1113,  168,  170,  457,  184,  112,  229,  466, 1390,  421,
 /*   880 */  1080, 1543,  176,   47,  187,   68,  446, 1245,  189,  148,
 /*   890 */  1587, 1286,   35,  177,   35,   64, 1194,  467, 1158,  238,
 /*   900 */  1572,  469, 1574, 1575,  465,   35,  460,  466,  909, 1063,
 /*   910 */   206, 1543,   88,  461,  208,   87,   86,   85,   84,   83,
 /*   920 */    82,   81,   80,   79,  106, 1698,  508,  910,  514,   74,
 /*   930 */  1572,  469, 1574, 1575,  465, 1285,  460,  109,  136, 1637,
 /*   940 */  1298,  475, 1696, 1636, 1633,  110,  112, 1365,   47,  214,
 /*   950 */   968,  517,  963,   71,  488, 1571,  200,  430,  996,   97,
 /*   960 */    96,   95,   94,   93,   92,   91,   90,   89,  411,  110,
 /*   970 */   513,  512,  511, 1000,  510, 1449,  111,  193,  377, 1587,
 /*   980 */  1007,   49,   48,  320,  112,  142,  467, 1667, 1006,  110,
 /*   990 */   314, 1178,  443,  113, 1588,  202,  466,    2, 1123,  295,
 /*  1000 */  1543,  299,  256, 1571,  306,  255,  302,  298,  139,  937,
 /*  1010 */   257, 1072, 1571,  222,  332, 1489,  144,  339,   74, 1572,
 /*  1020 */   469, 1574, 1575,  465,  346,  460,  347, 1587, 1637,  348,
 /*  1030 */  1102,  352,  456, 1633,  467, 1132, 1587,  353,  149,  137,
 /*  1040 */  1131,  152,  354,  467,  466,  355, 1100,  356, 1543,  357,
 /*  1050 */  1130,  155, 1129,  466,  379,  360,   52, 1543,  158,   78,
 /*  1060 */   265,  381, 1397,  162, 1571, 1108,  125, 1572,  469, 1574,
 /*  1070 */  1575,  465, 1571,  460, 1108,   74, 1572,  469, 1574, 1575,
 /*  1080 */   465,  223,  460, 1393,  164, 1637, 1528,  115, 1587,  175,
 /*  1090 */  1634,  116, 1395, 1391,  117,  467, 1587,  118,  412,  413,
 /*  1100 */   420,  179, 1571,  467,  182,  466,  566,  416,  422, 1543,
 /*  1110 */   447, 1711,  426,  466, 1128,  431,  423, 1543, 1101, 1678,
 /*  1120 */   473,  185, 1677, 1668,  428,  269, 1587,  246, 1572,  469,
 /*  1130 */  1574, 1575,  465,  467,  460,  125, 1572,  469, 1574, 1575,
 /*  1140 */   465,  188,  460,  466,    5,  439,  434, 1543,  427,  192,
 /*  1150 */   274, 1658,    4, 1219, 1571, 1103,  103, 1127,   37,  271,
 /*  1160 */   455, 1695,  195,  452,  129,  246, 1572,  469, 1574, 1575,
 /*  1170 */   465, 1652,  460,  194,   16, 1498, 1106, 1107, 1587, 1618,
 /*  1180 */  1712, 1497,  201,  471,  476,  464, 1713,  472,  279,  477,
 /*  1190 */   478,  210,  212,  224,   63,  466,   61, 1408, 1380, 1543,
 /*  1200 */   160,  486,  226,  130, 1571,  219,  128,  565,   43,  376,
 /*  1210 */   232,  372,  368,  364,  159, 1571,  233,  245, 1572,  469,
 /*  1220 */  1574, 1575,  465,  228,  460,  230, 1610,  294, 1587, 1537,
 /*  1230 */  1536, 1533,  296,  297, 1096,  467, 1097,  140,  301, 1587,
 /*  1240 */   303,   54, 1531,  304,  157,  466,  467,  305, 1530, 1543,
 /*  1250 */   307, 1529,  276, 1571,  309, 1514,  466,  141,  312,  313,
 /*  1260 */  1543, 1074, 1075,  278, 1508, 1507,  318,  246, 1572,  469,
 /*  1270 */  1574, 1575,  465,  319,  460, 1506, 1505, 1587,  246, 1572,
 /*  1280 */   469, 1574, 1575,  465,  467,  460, 1482, 1046, 1481, 1480,
 /*  1290 */  1479, 1478, 1477, 1476,  466, 1475, 1474, 1473, 1543, 1472,
 /*  1300 */  1571,  156, 1471,  151, 1470,  153, 1469, 1468, 1467,  108,
 /*  1310 */  1466, 1465, 1464, 1571, 1463, 1462,  234, 1572,  469, 1574,
 /*  1320 */  1575,  465,  150,  460, 1587, 1048, 1460, 1459, 1571, 1461,
 /*  1330 */  1458,  467, 1457, 1336, 1522, 1516, 1504, 1587,  902, 1335,
 /*  1340 */  1333,  466, 1495,  154,  467, 1543, 1386,  361,  363,  362,
 /*  1350 */  1331, 1329, 1587,   76,  466,  365,  366,  369, 1543,  467,
 /*  1360 */   370,  367, 1327,  240, 1572,  469, 1574, 1575,  465,  466,
 /*  1370 */   460,  371, 1316, 1543,  375, 1571,  242, 1572,  469, 1574,
 /*  1380 */  1575,  465,  373,  460,  374, 1315, 1312, 1388,  532, 1012,
 /*  1390 */  1571,  235, 1572,  469, 1574, 1575,  465, 1015,  460, 1587,
 /*  1400 */   262,  936,  935, 1571,  161, 1387,  467,  934,  933,  534,
 /*  1410 */  1325,  932,  929,  928, 1587,  263,  466, 1320,  400, 1318,
 /*  1420 */  1543,  467,  403,  264, 1311,  405, 1310, 1587,  407,   75,
 /*  1430 */  1521,  466, 1082,   46,  467, 1543, 1515,  119,  243, 1572,
 /*  1440 */   469, 1574, 1575,  465,  466,  460, 1503,  414, 1543, 1502,
 /*  1450 */  1494, 1571,   56,  236, 1572,  469, 1574, 1575,  465,  181,
 /*  1460 */   460,    3,  415,   35, 1571,   13,  244, 1572,  469, 1574,
 /*  1470 */  1575,  465,  186,  460,   41, 1587,   14,  178,   38,  191,
 /*  1480 */  1244,  183,  467,  126,   40, 1562,  190,   20, 1587, 1237,
 /*  1490 */  1216,   58,  466,   57,   21,  467, 1543, 1215, 1266,   39,
 /*  1500 */    11,   15, 1571, 1265,  272,  466, 1270,  197, 1271, 1543,
 /*  1510 */   135, 1269,  273,    8,  237, 1572,  469, 1574, 1575,  465,
 /*  1520 */  1179,  460,  459,   17, 1161,  138, 1587, 1583, 1572,  469,
 /*  1530 */  1574, 1575,  465,  467,  460, 1160,   27, 1146, 1159,   10,
 /*  1540 */   204,  468,   18,  466,   19, 1493,  205, 1543, 1242, 1571,
 /*  1550 */   207,  209,   59,  211,   60, 1118,   64,   42,  487,  997,
 /*  1560 */   286,  489, 1571,  491,  485, 1582, 1572,  469, 1574, 1575,
 /*  1570 */   465,  474,  460, 1587,  213, 1561,  216, 1571,  994,  492,
 /*  1580 */   467,  991,  494,  495,  497,  985, 1587,  498,  500,  983,
 /*  1590 */   466,  501,  989,  467, 1543,  988,  987,  986,  974,   65,
 /*  1600 */  1009, 1587,  507,  466, 1008,   66,   67, 1543,  467, 1005,
 /*  1610 */  1002,  900, 1581, 1572,  469, 1574, 1575,  465,  466,  460,
 /*  1620 */   518,  925, 1543,  943, 1571,  253, 1572,  469, 1574, 1575,
 /*  1630 */   465,  521,  460,  218,  923,  922,  921,  920,  919, 1571,
 /*  1640 */   252, 1572,  469, 1574, 1575,  465,  918,  460, 1587,  917,
 /*  1650 */   916,  940, 1571,  938,  913,  467,  284,  283,  912,  911,
 /*  1660 */   908,  907,  906, 1587,  905,  466, 1116, 1332,  543, 1543,
 /*  1670 */   467,  544,  545, 1330,  547,  548, 1587, 1337, 1328,  551,
 /*  1680 */   466,  549, 1109,  467, 1543,  552,  553,  254, 1572,  469,
 /*  1690 */  1574, 1575,  465,  466,  460, 1326,  555, 1543,  556,  557,
 /*  1700 */  1314, 1108,  251, 1572,  469, 1574, 1575,  465,  559,  460,
 /*  1710 */  1313,  560, 1309,  563,  564,  239, 1572,  469, 1574, 1575,
 /*  1720 */   465, 1104,  460,  227,  567,  568, 1284, 1284, 1284,  396,
 /*  1730 */  1284,  390, 1284, 1284, 1284,  395, 1284, 1284,  101, 1284,
 /*  1740 */   391,  389,  484,  392, 1284, 1284, 1284, 1284,  388, 1284,
 /*  1750 */  1284, 1284, 1284, 1284, 1112, 1284, 1284, 1284, 1284, 1284,
 /*  1760 */  1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284,
 /*  1770 */  1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284,
 /*  1780 */  1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284,
 /*  1790 */  1284, 1117, 1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284,
 /*  1800 */  1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284, 1284,
 /*  1810 */  1284, 1284, 1120,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   252,  248,  252,  232,  224,  230,  298,  299,  255,    0,
 /*    10 */   221,  269,   12,   13,  239,  224,  245,  269,  230,  269,
 /*    20 */    20,  246,   22,  230,  253,  283,  284,  239,  248,  257,
 /*    30 */   255,  283,  284,  283,  284,  255,  264,  265,   38,  248,
 /*    40 */   233,  229,  289,  255,  237,  265,  255,    0,  255,  269,
 /*    50 */    50,   12,   13,   14,   20,  243,  265,   57,   49,   20,
 /*    60 */   269,   22,  250,  274,   20,  274,  224,  287,  288,  289,
 /*    70 */   290,  291,  292,   20,  294,   75,  230,   38,  287,  288,
 /*    80 */   289,  290,  291,  292,  291,  294,  227,  228,  297,   50,
 /*    90 */   248,   61,  301,  302,   20,   65,   57,  255,   98,  306,
 /*   100 */   307,  308,  313,  310,  313,  325,  260,  265,   61,   75,
 /*   110 */   110,  269,   65,  230,   75,  326,  285,  326,   88,  330,
 /*   120 */    49,  330,  239,   12,   13,   14,   15,   16,   75,  287,
 /*   130 */   288,  289,  290,  291,  292,   88,  294,   98,  255,  297,
 /*   140 */   309,  230,  230,  301,  302,  303,  223,  147,  225,  110,
 /*   150 */   239,  239,  224,  255,  107,  108,  109,  315,  111,  265,
 /*   160 */   262,   50,  268,  321,  322,  271,  255,  255,  168,  169,
 /*   170 */   285,  171,  172,  173,  174,  175,  176,  177,  178,  179,
 /*   180 */   180,  181,  182,  183,  184,  185,  147,   76,   20,   12,
 /*   190 */    13,   14,   15,   16,  309,   84,  230,  269,  198,   12,
 /*   200 */    13,   14,   15,   16,  236,  230,  238,  168,  169,  137,
 /*   210 */   171,  172,  173,  174,  175,  176,  177,  178,  179,  180,
 /*   220 */   181,  182,  183,  184,  185,   12,   13,   50,  230,  230,
 /*   230 */   255,   38,  198,   20,   18,   22,   20,  239,  239,  274,
 /*   240 */   274,   35,  198,   27,  133,  246,   30,   38,  156,  157,
 /*   250 */    57,   38,  160,  255,  255,   39,   12,   13,   14,   15,
 /*   260 */    16,   84,  151,   50,   12,   13,  291,   61,  230,  274,
 /*   270 */    57,   65,   20,    0,   22,  203,  204,  239,  313,  313,
 /*   280 */   305,  306,  307,  308,   78,  310,   80,   81,   75,   83,
 /*   290 */    38,  326,  326,  255,   88,  330,  330,  186,  187,  188,
 /*   300 */   189,  190,  191,  192,  193,  194,  195,  139,  313,   57,
 /*   310 */   133,   98,  168,  247,   12,   13,   14,   15,   16,  110,
 /*   320 */    76,  326,   49,  110,  258,  330,  139,   75,  151,  113,
 /*   330 */   234,  235,  116,  117,  118,  119,  120,    3,  122,  123,
 /*   340 */   124,  125,  126,  127,  128,  129,  130,  131,  132,  198,
 /*   350 */    98,  207,  208,  209,  210,  211,   14,   15,   16,   20,
 /*   360 */   147,   22,  110,  186,  187,  188,  189,  190,  191,  192,
 /*   370 */   193,  194,  195,   12,   13,   14,   15,   16,   20,   40,
 /*   380 */   241,  168,  169,  244,  171,  172,  173,  174,  175,  176,
 /*   390 */   177,  178,  179,  180,  181,  182,  183,  184,  185,  147,
 /*   400 */    89,   90,   91,   92,   93,   94,   95,   96,   97,   98,
 /*   410 */    99,  248,  101,  102,  103,  104,  105,  106,  230,  256,
 /*   420 */   168,  169,    0,  171,  172,  173,  174,  175,  176,  177,
 /*   430 */   178,  179,  180,  181,  182,  183,  184,  185,   12,   13,
 /*   440 */    14,  224,  140,  255,   22,  146,   20,  148,   22,  230,
 /*   450 */   198,   21,  234,  235,   24,   25,   26,   27,   28,   29,
 /*   460 */    30,   31,   32,  313,   38,  248,  230,   12,   13,   14,
 /*   470 */    15,   16,  255,  240,  255,  239,  326,   12,   13,  291,
 /*   480 */   330,  248,  265,   57,   22,   20,  269,   22,  285,  256,
 /*   490 */   230,  255,   20,  274,  306,  307,  308,  198,  310,  239,
 /*   500 */    38,   75,   49,   38,  287,  288,  289,  290,  291,  292,
 /*   510 */   291,  294,  309,  224,  297,  255,   57,   67,  301,  302,
 /*   520 */   303,  219,   57,    4,   98,  306,  307,  308,   20,  310,
 /*   530 */    43,   76,  313,  133,  230,  248,  110,  248,   19,  322,
 /*   540 */    75,  254,  224,  239,  255,  326,  259,  230,  214,  330,
 /*   550 */    75,  151,   33,  232,  265,   36,  239,    2,  269,  255,
 /*   560 */    41,   47,   87,   98,  114,  115,   47,   12,   13,   14,
 /*   570 */    15,   16,  255,  147,  253,  110,  287,  288,  289,  290,
 /*   580 */   291,  292,  293,  294,  295,  296,  186,  269,   74,   79,
 /*   590 */   224,   77,   82,   74,  168,  169,   77,  171,  172,  173,
 /*   600 */   174,  175,  176,  177,  178,  179,  180,  181,  182,  183,
 /*   610 */   184,  185,  147,    2,  248,   72,    1,    2,   72,  234,
 /*   620 */   235,  255,   76,   12,   13,   14,   15,   16,  224,  234,
 /*   630 */   235,  265,    4,  168,  169,  269,  171,  172,  173,  174,
 /*   640 */   175,  176,  177,  178,  179,  180,  181,  182,  183,  184,
 /*   650 */   185,   12,   13,  287,  288,  289,  290,  291,  292,   20,
 /*   660 */   294,   22,  224,  297,  248,  230,  143,  301,  302,  303,
 /*   670 */   254,  240,  240,  269,  239,  259,  224,   38,  312,  248,
 /*   680 */   248,  264,  265,  229,  197,  162,  248,  256,  256,  248,
 /*   690 */   255,   76,  265,  255,   20,  254,   57,  224,  271,   52,
 /*   700 */   259,   54,  224,  265,  250,   58,  224,  269,   61,    0,
 /*   710 */    63,   64,  224,   66,   75,   72,  224,   86,   71,  224,
 /*   720 */   224,  269,  224,  224,  277,  287,  288,  289,  290,  291,
 /*   730 */   292,   22,  294,  249,  248,  297,  248,   98,   14,  301,
 /*   740 */   302,  303,  269,  255,   20,  259,   19,  269,  224,  110,
 /*   750 */   312,  269,  224,  265,  224,   20,   14,  269,  224,  216,
 /*   760 */    33,  269,   20,   36,  269,  269,    0,  269,  269,   42,
 /*   770 */     0,   44,   45,   46,   47,  287,  288,  289,  290,  291,
 /*   780 */   292,  224,  294,  224,  224,  297,  147,    0,  224,  301,
 /*   790 */   302,  303,   22,  269,  196,  197,   21,  269,   38,  269,
 /*   800 */   312,   74,   36,  269,   77,    1,    2,  168,  169,   34,
 /*   810 */   171,  172,  173,  174,  175,  176,  177,  178,  179,  180,
 /*   820 */   181,  182,  183,  184,  185,  249,  269,  199,  269,  269,
 /*   830 */   158,  159,   79,  269,  107,   82,  224,  183,  184,   52,
 /*   840 */    53,   54,   55,   56,  249,   58,   59,   60,   61,   62,
 /*   850 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   18,
 /*   860 */   248,  218,  135,    0,   23,  138,  224,  255,   79,   79,
 /*   870 */   110,   82,   82,   50,  139,   72,   35,  265,  249,   76,
 /*   880 */   153,  269,  155,   72,   72,   75,  274,   76,   76,   48,
 /*   890 */   248,    0,   72,  249,   72,   85,   76,  255,   76,  287,
 /*   900 */   288,  289,  290,  291,  292,   72,  294,  265,   38,   76,
 /*   910 */    72,  269,   21,  249,   76,   24,   25,   26,   27,   28,
 /*   920 */    29,   30,   31,   32,   61,  313,  249,   57,   65,  287,
 /*   930 */   288,  289,  290,  291,  292,    0,  294,   72,  326,  297,
 /*   940 */   225,   76,  330,  301,  302,   72,   72,  237,   72,   76,
 /*   950 */    76,   88,   76,  112,   72,  224,  333,  324,   76,   24,
 /*   960 */    25,   26,   27,   28,   29,   30,   31,   32,  281,   72,
 /*   970 */   107,  108,  109,   76,  111,  258,   72,  318,  227,  248,
 /*   980 */    76,  140,  141,  142,   72,  144,  255,  286,   76,   72,
 /*   990 */   149,  168,  311,   76,  248,  327,  265,  314,   20,  230,
 /*  1000 */   269,   36,  161,  224,  163,  282,  165,  166,  167,   38,
 /*  1010 */   234,  145,  224,  275,  230,  230,  121,  263,  287,  288,
 /*  1020 */   289,  290,  291,  292,  261,  294,  133,  248,  297,  261,
 /*  1030 */    22,  230,  301,  302,  255,   20,  248,  279,  232,  198,
 /*  1040 */    20,  232,  265,  255,  265,  273,   38,  255,  269,  266,
 /*  1050 */    20,  232,   20,  265,  226,  230,  232,  269,  232,  230,
 /*  1060 */   226,  248,  248,  248,  224,   57,  287,  288,  289,  290,
 /*  1070 */   291,  292,  224,  294,   57,  287,  288,  289,  290,  291,
 /*  1080 */   292,  279,  294,  248,  248,  297,  269,  248,  248,  229,
 /*  1090 */   302,  248,  248,  248,  248,  255,  248,  248,  154,  278,
 /*  1100 */   273,  229,  224,  255,  229,  265,   98,  265,  255,  269,
 /*  1110 */   331,  332,  272,  265,   20,  206,  266,  269,  110,  323,
 /*  1120 */   205,  270,  323,  286,  269,  269,  248,  287,  288,  289,
 /*  1130 */   290,  291,  292,  255,  294,  287,  288,  289,  290,  291,
 /*  1140 */   292,  270,  294,  265,  213,  212,  269,  269,  201,  319,
 /*  1150 */   272,  320,  200,  197,  224,  147,  255,   20,  121,  220,
 /*  1160 */   217,  329,  304,  215,  317,  287,  288,  289,  290,  291,
 /*  1170 */   292,  285,  294,  316,   75,  270,  168,  169,  248,  300,
 /*  1180 */   332,  270,  328,  269,  136,  255,  334,  269,  269,  267,
 /*  1190 */   266,  255,  229,  244,   75,  265,  229,  255,  238,  269,
 /*  1200 */    33,  251,  230,   36,  224,  229,  280,  226,  276,   42,
 /*  1210 */   242,   44,   45,   46,   47,  224,  242,  287,  288,  289,
 /*  1220 */   290,  291,  292,  231,  294,  222,  296,   64,  248,    0,
 /*  1230 */     0,    0,   38,  164,   38,  255,   38,   38,  164,  248,
 /*  1240 */    38,   74,    0,   38,   77,  265,  255,  164,    0,  269,
 /*  1250 */    38,    0,  272,  224,   38,    0,  265,   75,  151,  150,
 /*  1260 */   269,  147,  110,  272,    0,    0,   53,  287,  288,  289,
 /*  1270 */   290,  291,  292,  143,  294,    0,    0,  248,  287,  288,
 /*  1280 */   289,  290,  291,  292,  255,  294,    0,   87,    0,    0,
 /*  1290 */     0,    0,    0,    0,  265,    0,    0,    0,  269,    0,
 /*  1300 */   224,  134,    0,  136,    0,  138,    0,    0,    0,  121,
 /*  1310 */     0,    0,    0,  224,    0,    0,  287,  288,  289,  290,
 /*  1320 */   291,  292,  155,  294,  248,   22,    0,    0,  224,    0,
 /*  1330 */     0,  255,    0,    0,    0,    0,    0,  248,   51,    0,
 /*  1340 */     0,  265,    0,   43,  255,  269,    0,   38,   43,   36,
 /*  1350 */     0,    0,  248,   84,  265,   38,   36,   38,  269,  255,
 /*  1360 */    36,   43,    0,  287,  288,  289,  290,  291,  292,  265,
 /*  1370 */   294,   43,    0,  269,   43,  224,  287,  288,  289,  290,
 /*  1380 */   291,  292,   38,  294,   36,    0,    0,    0,   72,   22,
 /*  1390 */   224,  287,  288,  289,  290,  291,  292,   38,  294,  248,
 /*  1400 */    22,   38,   38,  224,   82,    0,  255,   38,   38,   72,
 /*  1410 */     0,   38,   38,   38,  248,   22,  265,    0,   39,    0,
 /*  1420 */   269,  255,   38,   22,    0,   22,    0,  248,   22,   20,
 /*  1430 */     0,  265,   38,  139,  255,  269,    0,  152,  287,  288,
 /*  1440 */   289,  290,  291,  292,  265,  294,    0,   22,  269,    0,
 /*  1450 */     0,  224,   75,  287,  288,  289,  290,  291,  292,   43,
 /*  1460 */   294,   72,  139,   72,  224,  202,  287,  288,  289,  290,
 /*  1470 */   291,  292,   76,  294,   72,  248,  202,  136,  196,   72,
 /*  1480 */    76,  134,  255,   75,  139,   87,   75,   75,  248,   76,
 /*  1490 */    76,    4,  265,   75,   72,  255,  269,   76,   38,   72,
 /*  1500 */   202,   72,  224,   38,   38,  265,   38,   87,   76,  269,
 /*  1510 */    87,   38,   38,    2,  287,  288,  289,  290,  291,  292,
 /*  1520 */   168,  294,   75,   72,   76,   87,  248,  287,  288,  289,
 /*  1530 */   290,  291,  292,  255,  294,   76,   75,   22,   76,   75,
 /*  1540 */    87,  170,   75,  265,   75,    0,   76,  269,   76,  224,
 /*  1550 */    75,   75,   75,   43,   75,   22,   85,   75,   38,   76,
 /*  1560 */    38,   75,  224,   38,   86,  287,  288,  289,  290,  291,
 /*  1570 */   292,  137,  294,  248,  134,   87,   87,  224,   76,   75,
 /*  1580 */   255,   76,   38,   75,   38,   76,  248,   75,   38,   76,
 /*  1590 */   265,   75,  100,  255,  269,  100,  100,  100,   22,   75,
 /*  1600 */    38,  248,   88,  265,  110,   75,   75,  269,  255,   38,
 /*  1610 */    22,   51,  287,  288,  289,  290,  291,  292,  265,  294,
 /*  1620 */    50,   38,  269,   57,  224,  287,  288,  289,  290,  291,
 /*  1630 */   292,   73,  294,   72,   38,   38,   38,   38,   38,  224,
 /*  1640 */   287,  288,  289,  290,  291,  292,   38,  294,  248,   38,
 /*  1650 */    22,   57,  224,   38,   38,  255,   12,   13,   38,   38,
 /*  1660 */    38,   38,   38,  248,   38,  265,   22,    0,   38,  269,
 /*  1670 */   255,   36,   43,    0,   38,   36,  248,    0,    0,   38,
 /*  1680 */   265,   43,   38,  255,  269,   36,   43,  287,  288,  289,
 /*  1690 */   290,  291,  292,  265,  294,    0,   38,  269,   36,   43,
 /*  1700 */     0,   57,  287,  288,  289,  290,  291,  292,   38,  294,
 /*  1710 */     0,   37,    0,   22,   21,  287,  288,  289,  290,  291,
 /*  1720 */   292,   22,  294,   22,   21,   20,  335,  335,  335,   52,
 /*  1730 */   335,   54,  335,  335,  335,   58,  335,  335,   61,  335,
 /*  1740 */    63,   64,   98,   66,  335,  335,  335,  335,   71,  335,
 /*  1750 */   335,  335,  335,  335,  110,  335,  335,  335,  335,  335,
 /*  1760 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  1770 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  1780 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  1790 */   335,  147,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  1800 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  1810 */   335,  335,  168,  335,  335,  335,  335,  335,  335,  335,
 /*  1820 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  1830 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  1840 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  1850 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  1860 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  1870 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  1880 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  1890 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  1900 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  1910 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  1920 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  1930 */   335,  335,  335,  335,  335,  335,  335,  335,  335,  335,
 /*  1940 */   335,  335,  335,  335,  335,  335,  335,
};
#define YY_SHIFT_COUNT    (569)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1712)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   841,    0,   39,  213,  213,  213,  213,  252,  213,  213,
 /*    10 */   426,  465,  639,  465,  465,  465,  465,  465,  465,  465,
 /*    20 */   465,  465,  465,  465,  465,  465,  465,  465,  465,  465,
 /*    30 */   465,  465,  465,  465,  465,  465,   34,   53,   53,   53,
 /*    40 */    44, 1644, 1644,  299,   74,   74,  151, 1644,   74,   74,
 /*    50 */    74,   74,   74,   74,   71,   74,  358,  472,  151,  508,
 /*    60 */   358,   74,   74,  358,   74,  358,  508,  358,  358,   74,
 /*    70 */   453,  216,  111,  177,  177,  430, 1008,  206,  647, 1008,
 /*    80 */  1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008,
 /*    90 */  1008, 1008, 1008, 1008, 1008, 1008, 1008, 1008,  339,    9,
 /*   100 */   193,  193,  168,  168,  168,  273,  193,  193,  674,  508,
 /*   110 */   358,  508,  358,  631,  459,  311,  311,  311,  311,  311,
 /*   120 */   311,  311,  727,  891, 1677,  302,  144,   30,   92,   72,
 /*   130 */   462,  735,  598,  487,  598,  724,  334,  628,  742,  978,
 /*   140 */   965,  971,  866,  978,  978,  895,  893,  893,  978, 1015,
 /*   150 */    71,  508, 1020,   71,  674, 1030,   71,   71,  978,   71,
 /*   160 */  1032,  358,  358,  358,  358,  358,  358,  358,  358,  358,
 /*   170 */   358,  358,  978, 1032, 1017, 1015,  453,  944,  508, 1020,
 /*   180 */   453,  674, 1030,  453, 1094,  909,  915, 1017,  909,  915,
 /*   190 */  1017, 1017,  931,  933,  947,  952,  956,  674, 1137, 1037,
 /*   200 */   939,  943,  948, 1099,  358,  915, 1017, 1017,  915, 1017,
 /*   210 */  1048,  674, 1030,  453,  631,  453,  674, 1119,  459,  978,
 /*   220 */   453, 1032, 1813, 1813, 1813, 1813, 1813, 1813,  787, 1167,
 /*   230 */   935,  519,   47,  863,  244,  555,  611,  187,  455,  361,
 /*   240 */   361,  361,  361,  361,  361,  361,  361,  514,  450,  615,
 /*   250 */   400,  342,  342,  342,  342,  766,  523,  546,  510,  753,
 /*   260 */   789,  790,  422,  709,  770,  775,  672,  803,  811,  812,
 /*   270 */   804,  654,  543,  643,  820,  823,  822,  475,  833,  838,
 /*   280 */   865,  873,  874,  209,  760,  876,  882,  897,  904,  912,
 /*   290 */   917,  810,  870, 1229, 1230, 1163, 1231, 1194, 1069, 1196,
 /*   300 */  1198, 1199, 1074, 1242, 1202, 1205, 1083, 1248, 1212, 1251,
 /*   310 */  1216, 1255, 1182, 1107, 1109, 1152, 1114, 1264, 1265, 1213,
 /*   320 */  1130, 1275, 1276, 1200, 1286, 1288, 1289, 1290, 1291, 1292,
 /*   330 */  1293, 1295, 1296, 1297, 1299, 1302, 1304, 1306, 1307, 1308,
 /*   340 */  1188, 1310, 1311, 1312, 1314, 1315, 1329, 1303, 1326, 1327,
 /*   350 */  1330, 1332, 1333, 1334, 1335, 1336, 1342, 1300, 1346, 1287,
 /*   360 */  1339, 1340, 1309, 1313, 1305, 1350, 1317, 1320, 1318, 1351,
 /*   370 */  1319, 1324, 1328, 1362, 1344, 1348, 1331, 1372, 1385, 1386,
 /*   380 */  1387, 1269, 1322, 1359, 1316, 1337, 1367, 1405, 1363, 1364,
 /*   390 */  1369, 1370, 1373, 1316, 1337, 1374, 1375, 1410, 1378, 1417,
 /*   400 */  1393, 1379, 1419, 1401, 1384, 1424, 1403, 1426, 1406, 1409,
 /*   410 */  1430, 1294, 1394, 1436, 1285, 1425, 1323, 1341, 1446, 1449,
 /*   420 */  1345, 1450, 1377, 1416, 1347, 1389, 1391, 1263, 1396, 1402,
 /*   430 */  1404, 1408, 1411, 1412, 1413, 1407, 1398, 1418, 1422, 1274,
 /*   440 */  1414, 1421, 1420, 1282, 1427, 1423, 1432, 1429, 1298, 1487,
 /*   450 */  1460, 1465, 1466, 1468, 1473, 1474, 1511, 1352, 1451, 1448,
 /*   460 */  1447, 1459, 1461, 1462, 1438, 1464, 1467, 1453, 1515, 1371,
 /*   470 */  1469, 1470, 1472, 1475, 1476, 1434, 1477, 1545, 1510, 1440,
 /*   480 */  1479, 1471, 1488, 1489, 1533, 1482, 1478, 1483, 1520, 1522,
 /*   490 */  1486, 1502, 1525, 1504, 1505, 1544, 1508, 1509, 1546, 1512,
 /*   500 */  1513, 1550, 1516, 1492, 1495, 1496, 1497, 1576, 1514, 1524,
 /*   510 */  1562, 1494, 1530, 1531, 1571, 1316, 1337, 1588, 1560, 1570,
 /*   520 */  1583, 1566, 1558, 1561, 1596, 1597, 1598, 1599, 1600, 1608,
 /*   530 */  1611, 1628, 1594, 1316, 1615, 1337, 1616, 1620, 1621, 1622,
 /*   540 */  1623, 1624, 1626, 1667, 1630, 1635, 1629, 1673, 1636, 1639,
 /*   550 */  1638, 1678, 1641, 1649, 1643, 1695, 1658, 1662, 1656, 1700,
 /*   560 */  1670, 1674, 1710, 1712, 1691, 1693, 1699, 1701, 1703, 1705,
};
#define YY_REDUCE_COUNT (227)
#define YY_REDUCE_MIN   (-292)
#define YY_REDUCE_MAX   (1428)
static const short yy_reduce_ofst[] = {
 /*     0 */  -211, -209, -158,  217,  366,  438,  488,  612,  642,  731,
 /*    10 */   289,  779,  788,  840, -220,  848,  878,  930,  980,  991,
 /*    20 */  1029, 1076, 1089, 1104, 1151, 1166, 1179, 1227, 1240, 1278,
 /*    30 */  1325, 1338, 1353, 1400, 1415, 1428,  219,  -25, -207,  188,
 /*    40 */   -34, -252, -250,  -35, -225,   -1,   -5, -258, -212, -117,
 /*    50 */   -89,  -88,   -2,  236, -229,  260,  287, -247,  150, -106,
 /*    60 */   233,  304,  317,  416,  435,  431, -228,  441,  432,   38,
 /*    70 */  -188, -154, -292, -292, -292,  -77,  -72,   66, -193,  318,
 /*    80 */   404,  452,  473,  478,  482,  492,  495,  496,  498,  499,
 /*    90 */   524,  528,  530,  534,  557,  559,  560,  564, -141,  321,
 /*   100 */    96,  218, -169, -115,  203,  454,  385,  395, -102,  427,
 /*   110 */   163,  417,  486,  139,  -32,  484,  576,  595,  629,  644,
 /*   120 */   664,  677,  447,  715,  710,  623,  633,  717,  687,  659,
 /*   130 */   751,  701,  681,  681,  681,  746,  668,  683,  746,  769,
 /*   140 */   723,  776,  738,  784,  785,  754,  763,  768,  801,  758,
 /*   150 */   806,  777,  772,  809,  792,  783,  819,  824,  825,  826,
 /*   160 */   828,  813,  814,  815,  835,  836,  839,  843,  844,  845,
 /*   170 */   846,  849,  829,  834,  817,  802,  860,  821,  842,  827,
 /*   180 */   872,  853,  850,  875,  837,  796,  851,  855,  799,  871,
 /*   190 */   856,  877,  831,  830,  847,  857,  681,  901,  886,  858,
 /*   200 */   852,  832,  854,  879,  746,  905,  914,  918,  911,  919,
 /*   210 */   922,  936,  924,  963,  949,  967,  942,  950,  960,  972,
 /*   220 */   976,  981,  932,  926,  968,  974,  992, 1003,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*    10 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*    20 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*    30 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*    40 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*    50 */  1282, 1282, 1282, 1282, 1341, 1282, 1282, 1282, 1282, 1282,
 /*    60 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*    70 */  1339, 1483, 1282, 1639, 1282, 1282, 1282, 1282, 1282, 1282,
 /*    80 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*    90 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1341,
 /*   100 */  1282, 1282, 1650, 1650, 1650, 1339, 1282, 1282, 1282, 1282,
 /*   110 */  1282, 1282, 1282, 1436, 1282, 1282, 1282, 1282, 1282, 1282,
 /*   120 */  1282, 1282, 1517, 1282, 1282, 1714, 1282, 1389, 1523, 1674,
 /*   130 */  1282, 1666, 1642, 1656, 1643, 1282, 1699, 1659, 1282, 1282,
 /*   140 */  1282, 1282, 1509, 1282, 1282, 1488, 1485, 1485, 1282, 1282,
 /*   150 */  1341, 1282, 1282, 1341, 1282, 1282, 1341, 1341, 1282, 1341,
 /*   160 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*   170 */  1282, 1282, 1282, 1282, 1282, 1282, 1339, 1519, 1282, 1282,
 /*   180 */  1339, 1282, 1282, 1339, 1282, 1681, 1679, 1282, 1681, 1679,
 /*   190 */  1282, 1282, 1693, 1689, 1672, 1670, 1656, 1282, 1282, 1282,
 /*   200 */  1717, 1705, 1701, 1282, 1282, 1679, 1282, 1282, 1679, 1282,
 /*   210 */  1496, 1282, 1282, 1339, 1282, 1339, 1282, 1405, 1282, 1282,
 /*   220 */  1339, 1282, 1511, 1525, 1439, 1439, 1342, 1287, 1282, 1282,
 /*   230 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1586,
 /*   240 */  1692, 1691, 1615, 1614, 1613, 1611, 1585, 1282, 1282, 1282,
 /*   250 */  1282, 1579, 1580, 1578, 1577, 1282, 1282, 1282, 1282, 1282,
 /*   260 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*   270 */  1640, 1282, 1702, 1706, 1282, 1282, 1282, 1563, 1282, 1282,
 /*   280 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*   290 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*   300 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*   310 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*   320 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*   330 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*   340 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*   350 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*   360 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*   370 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*   380 */  1282, 1282, 1282, 1282, 1452, 1451, 1282, 1282, 1282, 1282,
 /*   390 */  1282, 1282, 1282, 1369, 1368, 1282, 1282, 1282, 1282, 1282,
 /*   400 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*   410 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*   420 */  1282, 1282, 1282, 1282, 1282, 1663, 1673, 1282, 1282, 1282,
 /*   430 */  1282, 1282, 1282, 1282, 1282, 1282, 1563, 1282, 1690, 1282,
 /*   440 */  1649, 1645, 1282, 1282, 1641, 1282, 1282, 1700, 1282, 1282,
 /*   450 */  1282, 1282, 1282, 1282, 1282, 1282, 1635, 1282, 1608, 1282,
 /*   460 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1573,
 /*   470 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*   480 */  1282, 1282, 1562, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*   490 */  1433, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*   500 */  1282, 1282, 1282, 1418, 1416, 1415, 1414, 1282, 1411, 1282,
 /*   510 */  1282, 1282, 1282, 1282, 1282, 1442, 1441, 1282, 1282, 1282,
 /*   520 */  1282, 1282, 1282, 1362, 1282, 1282, 1282, 1282, 1282, 1282,
 /*   530 */  1282, 1282, 1282, 1353, 1282, 1352, 1282, 1282, 1282, 1282,
 /*   540 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*   550 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
 /*   560 */  1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "DNODE",
  /*   37 */ "PORT",
  /*   38 */ "NK_INTEGER",
  /*   39 */ "DNODES",
  /*   40 */ "NK_IPTOKEN",
  /*   41 */ "LOCAL",
  /*   42 */ "QNODE",
  /*   43 */ "ON",
  /*   44 */ "BNODE",
  /*   45 */ "SNODE",
  /*   46 */ "MNODE",
  /*   47 */ "DATABASE",
  /*   48 */ "USE",
  /*   49 */ "IF",
  /*   50 */ "NOT",
  /*   51 */ "EXISTS",
  /*   52 */ "BLOCKS",
  /*   53 */ "CACHE",
  /*   54 */ "CACHELAST",
  /*   55 */ "COMP",
  /*   56 */ "DAYS",
  /*   57 */ "NK_VARIABLE",
  /*   58 */ "FSYNC",
  /*   59 */ "MAXROWS",
  /*   60 */ "MINROWS",
  /*   61 */ "KEEP",
  /*   62 */ "PRECISION",
  /*   63 */ "QUORUM",
  /*   64 */ "REPLICA",
  /*   65 */ "TTL",
  /*   66 */ "WAL",
  /*   67 */ "VGROUPS",
  /*   68 */ "SINGLE_STABLE",
  /*   69 */ "STREAM_MODE",
  /*   70 */ "RETENTIONS",
  /*   71 */ "STRICT",
  /*   72 */ "NK_COMMA",
  /*   73 */ "NK_COLON",
  /*   74 */ "TABLE",
  /*   75 */ "NK_LP",
  /*   76 */ "NK_RP",
  /*   77 */ "STABLE",
  /*   78 */ "ADD",
  /*   79 */ "COLUMN",
  /*   80 */ "MODIFY",
  /*   81 */ "RENAME",
  /*   82 */ "TAG",
  /*   83 */ "SET",
  /*   84 */ "NK_EQ",
  /*   85 */ "USING",
  /*   86 */ "TAGS",
  /*   87 */ "NK_DOT",
  /*   88 */ "COMMENT",
  /*   89 */ "BOOL",
  /*   90 */ "TINYINT",
  /*   91 */ "SMALLINT",
  /*   92 */ "INT",
  /*   93 */ "INTEGER",
  /*   94 */ "BIGINT",
  /*   95 */ "FLOAT",
  /*   96 */ "DOUBLE",
  /*   97 */ "BINARY",
  /*   98 */ "TIMESTAMP",
  /*   99 */ "NCHAR",
  /*  100 */ "UNSIGNED",
  /*  101 */ "JSON",
  /*  102 */ "VARCHAR",
  /*  103 */ "MEDIUMBLOB",
  /*  104 */ "BLOB",
  /*  105 */ "VARBINARY",
  /*  106 */ "DECIMAL",
  /*  107 */ "SMA",
  /*  108 */ "ROLLUP",
  /*  109 */ "FILE_FACTOR",
  /*  110 */ "NK_FLOAT",
  /*  111 */ "DELAY",
  /*  112 */ "SHOW",
  /*  113 */ "DATABASES",
  /*  114 */ "TABLES",
  /*  115 */ "STABLES",
  /*  116 */ "MNODES",
  /*  117 */ "MODULES",
  /*  118 */ "QNODES",
  /*  119 */ "FUNCTIONS",
  /*  120 */ "INDEXES",
  /*  121 */ "FROM",
  /*  122 */ "ACCOUNTS",
  /*  123 */ "APPS",
  /*  124 */ "CONNECTIONS",
  /*  125 */ "LICENCE",
  /*  126 */ "GRANTS",
  /*  127 */ "QUERIES",
  /*  128 */ "SCORES",
  /*  129 */ "TOPICS",
  /*  130 */ "VARIABLES",
  /*  131 */ "BNODES",
  /*  132 */ "SNODES",
  /*  133 */ "LIKE",
  /*  134 */ "INDEX",
  /*  135 */ "FULLTEXT",
  /*  136 */ "FUNCTION",
  /*  137 */ "INTERVAL",
  /*  138 */ "TOPIC",
  /*  139 */ "AS",
  /*  140 */ "DESC",
  /*  141 */ "DESCRIBE",
  /*  142 */ "RESET",
  /*  143 */ "QUERY",
  /*  144 */ "EXPLAIN",
  /*  145 */ "ANALYZE",
  /*  146 */ "VERBOSE",
  /*  147 */ "NK_BOOL",
  /*  148 */ "RATIO",
  /*  149 */ "COMPACT",
  /*  150 */ "VNODES",
  /*  151 */ "IN",
  /*  152 */ "OUTPUTTYPE",
  /*  153 */ "AGGREGATE",
  /*  154 */ "BUFSIZE",
  /*  155 */ "STREAM",
  /*  156 */ "INTO",
  /*  157 */ "TRIGGER",
  /*  158 */ "AT_ONCE",
  /*  159 */ "WINDOW_CLOSE",
  /*  160 */ "WATERMARK",
  /*  161 */ "KILL",
  /*  162 */ "CONNECTION",
  /*  163 */ "MERGE",
  /*  164 */ "VGROUP",
  /*  165 */ "REDISTRIBUTE",
  /*  166 */ "SPLIT",
  /*  167 */ "SYNCDB",
  /*  168 */ "NULL",
  /*  169 */ "NK_QUESTION",
  /*  170 */ "NK_ARROW",
  /*  171 */ "ROWTS",
  /*  172 */ "TBNAME",
  /*  173 */ "QSTARTTS",
  /*  174 */ "QENDTS",
  /*  175 */ "WSTARTTS",
  /*  176 */ "WENDTS",
  /*  177 */ "WDURATION",
  /*  178 */ "CAST",
  /*  179 */ "NOW",
  /*  180 */ "TODAY",
  /*  181 */ "TIMEZONE",
  /*  182 */ "COUNT",
  /*  183 */ "FIRST",
  /*  184 */ "LAST",
  /*  185 */ "LAST_ROW",
  /*  186 */ "BETWEEN",
  /*  187 */ "IS",
  /*  188 */ "NK_LT",
  /*  189 */ "NK_GT",
  /*  190 */ "NK_LE",
  /*  191 */ "NK_GE",
  /*  192 */ "NK_NE",
  /*  193 */ "MATCH",
  /*  194 */ "NMATCH",
  /*  195 */ "CONTAINS",
  /*  196 */ "JOIN",
  /*  197 */ "INNER",
  /*  198 */ "SELECT",
  /*  199 */ "DISTINCT",
  /*  200 */ "WHERE",
  /*  201 */ "PARTITION",
  /*  202 */ "BY",
  /*  203 */ "SESSION",
  /*  204 */ "STATE_WINDOW",
  /*  205 */ "SLIDING",
  /*  206 */ "FILL",
  /*  207 */ "VALUE",
  /*  208 */ "NONE",
  /*  209 */ "PREV",
  /*  210 */ "LINEAR",
  /*  211 */ "NEXT",
  /*  212 */ "GROUP",
  /*  213 */ "HAVING",
  /*  214 */ "ORDER",
  /*  215 */ "SLIMIT",
  /*  216 */ "SOFFSET",
  /*  217 */ "LIMIT",
  /*  218 */ "OFFSET",
  /*  219 */ "ASC",
  /*  220 */ "NULLS",
  /*  221 */ "cmd",
  /*  222 */ "account_options",
  /*  223 */ "alter_account_options",
  /*  224 */ "literal",
  /*  225 */ "alter_account_option",
  /*  226 */ "user_name",
  /*  227 */ "dnode_endpoint",
  /*  228 */ "dnode_host_name",
  /*  229 */ "not_exists_opt",
  /*  230 */ "db_name",
  /*  231 */ "db_options",
  /*  232 */ "exists_opt",
  /*  233 */ "alter_db_options",
  /*  234 */ "integer_list",
  /*  235 */ "variable_list",
  /*  236 */ "retention_list",
  /*  237 */ "alter_db_option",
  /*  238 */ "retention",
  /*  239 */ "full_table_name",
  /*  240 */ "column_def_list",
  /*  241 */ "tags_def_opt",
  /*  242 */ "table_options",
  /*  243 */ "multi_create_clause",
  /*  244 */ "tags_def",
  /*  245 */ "multi_drop_clause",
  /*  246 */ "alter_table_clause",
  /*  247 */ "alter_table_options",
  /*  248 */ "column_name",
  /*  249 */ "type_name",
  /*  250 */ "create_subtable_clause",
  /*  251 */ "specific_tags_opt",
  /*  252 */ "literal_list",
  /*  253 */ "drop_table_clause",
  /*  254 */ "col_name_list",
  /*  255 */ "table_name",
  /*  256 */ "column_def",
  /*  257 */ "func_name_list",
  /*  258 */ "alter_table_option",
  /*  259 */ "col_name",
  /*  260 */ "db_name_cond_opt",
  /*  261 */ "like_pattern_opt",
  /*  262 */ "table_name_cond",
  /*  263 */ "from_db_opt",
  /*  264 */ "func_name",
  /*  265 */ "function_name",
  /*  266 */ "index_name",
  /*  267 */ "index_options",
  /*  268 */ "func_list",
  /*  269 */ "duration_literal",
  /*  270 */ "sliding_opt",
  /*  271 */ "func",
  /*  272 */ "expression_list",
  /*  273 */ "topic_name",
  /*  274 */ "query_expression",
  /*  275 */ "analyze_opt",
  /*  276 */ "explain_options",
  /*  277 */ "agg_func_opt",
  /*  278 */ "bufsize_opt",
  /*  279 */ "stream_name",
  /*  280 */ "stream_options",
  /*  281 */ "into_opt",
  /*  282 */ "dnode_list",
  /*  283 */ "signed",
  /*  284 */ "signed_literal",
  /*  285 */ "table_alias",
  /*  286 */ "column_alias",
  /*  287 */ "expression",
  /*  288 */ "pseudo_column",
  /*  289 */ "column_reference",
  /*  290 */ "function_expression",
  /*  291 */ "subquery",
  /*  292 */ "star_func",
  /*  293 */ "star_func_para_list",
  /*  294 */ "noarg_func",
  /*  295 */ "other_para_list",
  /*  296 */ "star_func_para",
  /*  297 */ "predicate",
  /*  298 */ "compare_op",
  /*  299 */ "in_op",
  /*  300 */ "in_predicate_value",
  /*  301 */ "boolean_value_expression",
  /*  302 */ "boolean_primary",
  /*  303 */ "common_expression",
  /*  304 */ "from_clause",
  /*  305 */ "table_reference_list",
  /*  306 */ "table_reference",
  /*  307 */ "table_primary",
  /*  308 */ "joined_table",
  /*  309 */ "alias_opt",
  /*  310 */ "parenthesized_joined_table",
  /*  311 */ "join_type",
  /*  312 */ "search_condition",
  /*  313 */ "query_specification",
  /*  314 */ "set_quantifier_opt",
  /*  315 */ "select_list",
  /*  316 */ "where_clause_opt",
  /*  317 */ "partition_by_clause_opt",
  /*  318 */ "twindow_clause_opt",
  /*  319 */ "group_by_clause_opt",
  /*  320 */ "having_clause_opt",
  /*  321 */ "select_sublist",
  /*  322 */ "select_item",
  /*  323 */ "fill_opt",
  /*  324 */ "fill_mode",
  /*  325 */ "group_by_list",
  /*  326 */ "query_expression_body",
  /*  327 */ "order_by_clause_opt",
  /*  328 */ "slimit_clause_opt",
  /*  329 */ "limit_clause_opt",
  /*  330 */ "query_primary",
  /*  331 */ "sort_specification_list",
  /*  332 */ "sort_specification",
  /*  333 */ "ordering_specification_opt",
  /*  334 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  29 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  30 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  31 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  32 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  33 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  34 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  35 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  36 */ "dnode_endpoint ::= NK_STRING",
 /*  37 */ "dnode_host_name ::= NK_ID",
 /*  38 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  39 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  40 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  41 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  42 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  43 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  45 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  46 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  47 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  48 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  49 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  50 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  51 */ "cmd ::= USE db_name",
 /*  52 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  53 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  54 */ "not_exists_opt ::=",
 /*  55 */ "exists_opt ::= IF EXISTS",
 /*  56 */ "exists_opt ::=",
 /*  57 */ "db_options ::=",
 /*  58 */ "db_options ::= db_options BLOCKS NK_INTEGER",
 /*  59 */ "db_options ::= db_options CACHE NK_INTEGER",
 /*  60 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  61 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  62 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  63 */ "db_options ::= db_options DAYS NK_VARIABLE",
 /*  64 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  65 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  66 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  67 */ "db_options ::= db_options KEEP integer_list",
 /*  68 */ "db_options ::= db_options KEEP variable_list",
 /*  69 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  70 */ "db_options ::= db_options QUORUM NK_INTEGER",
 /*  71 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  72 */ "db_options ::= db_options TTL NK_INTEGER",
 /*  73 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  74 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  75 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  76 */ "db_options ::= db_options STREAM_MODE NK_INTEGER",
 /*  77 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  78 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  79 */ "alter_db_options ::= alter_db_option",
 /*  80 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  81 */ "alter_db_option ::= BLOCKS NK_INTEGER",
 /*  82 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  83 */ "alter_db_option ::= KEEP integer_list",
 /*  84 */ "alter_db_option ::= KEEP variable_list",
 /*  85 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  86 */ "alter_db_option ::= QUORUM NK_INTEGER",
 /*  87 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  88 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  89 */ "alter_db_option ::= STRICT NK_INTEGER",
 /*  90 */ "integer_list ::= NK_INTEGER",
 /*  91 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /*  92 */ "variable_list ::= NK_VARIABLE",
 /*  93 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /*  94 */ "retention_list ::= retention",
 /*  95 */ "retention_list ::= retention_list NK_COMMA retention",
 /*  96 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /*  97 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /*  98 */ "cmd ::= CREATE TABLE multi_create_clause",
 /*  99 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 100 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 101 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 102 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 103 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 104 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 105 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 106 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 107 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 108 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 109 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 110 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 111 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 112 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 113 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal",
 /* 114 */ "multi_create_clause ::= create_subtable_clause",
 /* 115 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 116 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP",
 /* 117 */ "multi_drop_clause ::= drop_table_clause",
 /* 118 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 119 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 120 */ "specific_tags_opt ::=",
 /* 121 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 122 */ "full_table_name ::= table_name",
 /* 123 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 124 */ "column_def_list ::= column_def",
 /* 125 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 126 */ "column_def ::= column_name type_name",
 /* 127 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 128 */ "type_name ::= BOOL",
 /* 129 */ "type_name ::= TINYINT",
 /* 130 */ "type_name ::= SMALLINT",
 /* 131 */ "type_name ::= INT",
 /* 132 */ "type_name ::= INTEGER",
 /* 133 */ "type_name ::= BIGINT",
 /* 134 */ "type_name ::= FLOAT",
 /* 135 */ "type_name ::= DOUBLE",
 /* 136 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 137 */ "type_name ::= TIMESTAMP",
 /* 138 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 139 */ "type_name ::= TINYINT UNSIGNED",
 /* 140 */ "type_name ::= SMALLINT UNSIGNED",
 /* 141 */ "type_name ::= INT UNSIGNED",
 /* 142 */ "type_name ::= BIGINT UNSIGNED",
 /* 143 */ "type_name ::= JSON",
 /* 144 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 145 */ "type_name ::= MEDIUMBLOB",
 /* 146 */ "type_name ::= BLOB",
 /* 147 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= DECIMAL",
 /* 149 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 150 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 151 */ "tags_def_opt ::=",
 /* 152 */ "tags_def_opt ::= tags_def",
 /* 153 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 154 */ "table_options ::=",
 /* 155 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 156 */ "table_options ::= table_options KEEP integer_list",
 /* 157 */ "table_options ::= table_options KEEP variable_list",
 /* 158 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 159 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 160 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 161 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 162 */ "table_options ::= table_options DELAY NK_INTEGER",
 /* 163 */ "alter_table_options ::= alter_table_option",
 /* 164 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 165 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 166 */ "alter_table_option ::= KEEP integer_list",
 /* 167 */ "alter_table_option ::= KEEP variable_list",
 /* 168 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 169 */ "col_name_list ::= col_name",
 /* 170 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 171 */ "col_name ::= column_name",
 /* 172 */ "cmd ::= SHOW DNODES",
 /* 173 */ "cmd ::= SHOW USERS",
 /* 174 */ "cmd ::= SHOW DATABASES",
 /* 175 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 176 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 177 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 178 */ "cmd ::= SHOW MNODES",
 /* 179 */ "cmd ::= SHOW MODULES",
 /* 180 */ "cmd ::= SHOW QNODES",
 /* 181 */ "cmd ::= SHOW FUNCTIONS",
 /* 182 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 183 */ "cmd ::= SHOW STREAMS",
 /* 184 */ "cmd ::= SHOW ACCOUNTS",
 /* 185 */ "cmd ::= SHOW APPS",
 /* 186 */ "cmd ::= SHOW CONNECTIONS",
 /* 187 */ "cmd ::= SHOW LICENCE",
 /* 188 */ "cmd ::= SHOW GRANTS",
 /* 189 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 190 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 191 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 192 */ "cmd ::= SHOW QUERIES",
 /* 193 */ "cmd ::= SHOW SCORES",
 /* 194 */ "cmd ::= SHOW TOPICS",
 /* 195 */ "cmd ::= SHOW VARIABLES",
 /* 196 */ "cmd ::= SHOW BNODES",
 /* 197 */ "cmd ::= SHOW SNODES",
 /* 198 */ "db_name_cond_opt ::=",
 /* 199 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 200 */ "like_pattern_opt ::=",
 /* 201 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 202 */ "table_name_cond ::= table_name",
 /* 203 */ "from_db_opt ::=",
 /* 204 */ "from_db_opt ::= FROM db_name",
 /* 205 */ "func_name_list ::= func_name",
 /* 206 */ "func_name_list ::= func_name_list NK_COMMA func_name",
 /* 207 */ "func_name ::= function_name",
 /* 208 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 209 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 210 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 211 */ "index_options ::=",
 /* 212 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 213 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 214 */ "func_list ::= func",
 /* 215 */ "func_list ::= func_list NK_COMMA func",
 /* 216 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 217 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 218 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name",
 /* 219 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 220 */ "cmd ::= DESC full_table_name",
 /* 221 */ "cmd ::= DESCRIBE full_table_name",
 /* 222 */ "cmd ::= RESET QUERY CACHE",
 /* 223 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 224 */ "analyze_opt ::=",
 /* 225 */ "analyze_opt ::= ANALYZE",
 /* 226 */ "explain_options ::=",
 /* 227 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 228 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 229 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 230 */ "cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 231 */ "cmd ::= DROP FUNCTION function_name",
 /* 232 */ "agg_func_opt ::=",
 /* 233 */ "agg_func_opt ::= AGGREGATE",
 /* 234 */ "bufsize_opt ::=",
 /* 235 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 236 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 237 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 238 */ "into_opt ::=",
 /* 239 */ "into_opt ::= INTO full_table_name",
 /* 240 */ "stream_options ::=",
 /* 241 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 242 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 243 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 244 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 245 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 246 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 247 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 248 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 249 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 250 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 251 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 252 */ "cmd ::= query_expression",
 /* 253 */ "literal ::= NK_INTEGER",
 /* 254 */ "literal ::= NK_FLOAT",
 /* 255 */ "literal ::= NK_STRING",
 /* 256 */ "literal ::= NK_BOOL",
 /* 257 */ "literal ::= TIMESTAMP NK_STRING",
 /* 258 */ "literal ::= duration_literal",
 /* 259 */ "literal ::= NULL",
 /* 260 */ "literal ::= NK_QUESTION",
 /* 261 */ "duration_literal ::= NK_VARIABLE",
 /* 262 */ "signed ::= NK_INTEGER",
 /* 263 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 264 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 265 */ "signed ::= NK_FLOAT",
 /* 266 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 267 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 268 */ "signed_literal ::= signed",
 /* 269 */ "signed_literal ::= NK_STRING",
 /* 270 */ "signed_literal ::= NK_BOOL",
 /* 271 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 272 */ "signed_literal ::= duration_literal",
 /* 273 */ "signed_literal ::= NULL",
 /* 274 */ "literal_list ::= signed_literal",
 /* 275 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 276 */ "db_name ::= NK_ID",
 /* 277 */ "table_name ::= NK_ID",
 /* 278 */ "column_name ::= NK_ID",
 /* 279 */ "function_name ::= NK_ID",
 /* 280 */ "table_alias ::= NK_ID",
 /* 281 */ "column_alias ::= NK_ID",
 /* 282 */ "user_name ::= NK_ID",
 /* 283 */ "index_name ::= NK_ID",
 /* 284 */ "topic_name ::= NK_ID",
 /* 285 */ "stream_name ::= NK_ID",
 /* 286 */ "expression ::= literal",
 /* 287 */ "expression ::= pseudo_column",
 /* 288 */ "expression ::= column_reference",
 /* 289 */ "expression ::= function_expression",
 /* 290 */ "expression ::= subquery",
 /* 291 */ "expression ::= NK_LP expression NK_RP",
 /* 292 */ "expression ::= NK_PLUS expression",
 /* 293 */ "expression ::= NK_MINUS expression",
 /* 294 */ "expression ::= expression NK_PLUS expression",
 /* 295 */ "expression ::= expression NK_MINUS expression",
 /* 296 */ "expression ::= expression NK_STAR expression",
 /* 297 */ "expression ::= expression NK_SLASH expression",
 /* 298 */ "expression ::= expression NK_REM expression",
 /* 299 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 300 */ "expression_list ::= expression",
 /* 301 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 302 */ "column_reference ::= column_name",
 /* 303 */ "column_reference ::= table_name NK_DOT column_name",
 /* 304 */ "pseudo_column ::= ROWTS",
 /* 305 */ "pseudo_column ::= TBNAME",
 /* 306 */ "pseudo_column ::= QSTARTTS",
 /* 307 */ "pseudo_column ::= QENDTS",
 /* 308 */ "pseudo_column ::= WSTARTTS",
 /* 309 */ "pseudo_column ::= WENDTS",
 /* 310 */ "pseudo_column ::= WDURATION",
 /* 311 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 312 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 313 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 314 */ "function_expression ::= noarg_func NK_LP NK_RP",
 /* 315 */ "noarg_func ::= NOW",
 /* 316 */ "noarg_func ::= TODAY",
 /* 317 */ "noarg_func ::= TIMEZONE",
 /* 318 */ "star_func ::= COUNT",
 /* 319 */ "star_func ::= FIRST",
 /* 320 */ "star_func ::= LAST",
 /* 321 */ "star_func ::= LAST_ROW",
 /* 322 */ "star_func_para_list ::= NK_STAR",
 /* 323 */ "star_func_para_list ::= other_para_list",
 /* 324 */ "other_para_list ::= star_func_para",
 /* 325 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 326 */ "star_func_para ::= expression",
 /* 327 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 328 */ "predicate ::= expression compare_op expression",
 /* 329 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 330 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 331 */ "predicate ::= expression IS NULL",
 /* 332 */ "predicate ::= expression IS NOT NULL",
 /* 333 */ "predicate ::= expression in_op in_predicate_value",
 /* 334 */ "compare_op ::= NK_LT",
 /* 335 */ "compare_op ::= NK_GT",
 /* 336 */ "compare_op ::= NK_LE",
 /* 337 */ "compare_op ::= NK_GE",
 /* 338 */ "compare_op ::= NK_NE",
 /* 339 */ "compare_op ::= NK_EQ",
 /* 340 */ "compare_op ::= LIKE",
 /* 341 */ "compare_op ::= NOT LIKE",
 /* 342 */ "compare_op ::= MATCH",
 /* 343 */ "compare_op ::= NMATCH",
 /* 344 */ "compare_op ::= CONTAINS",
 /* 345 */ "in_op ::= IN",
 /* 346 */ "in_op ::= NOT IN",
 /* 347 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 348 */ "boolean_value_expression ::= boolean_primary",
 /* 349 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 350 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 351 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 352 */ "boolean_primary ::= predicate",
 /* 353 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 354 */ "common_expression ::= expression",
 /* 355 */ "common_expression ::= boolean_value_expression",
 /* 356 */ "from_clause ::= FROM table_reference_list",
 /* 357 */ "table_reference_list ::= table_reference",
 /* 358 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 359 */ "table_reference ::= table_primary",
 /* 360 */ "table_reference ::= joined_table",
 /* 361 */ "table_primary ::= table_name alias_opt",
 /* 362 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 363 */ "table_primary ::= subquery alias_opt",
 /* 364 */ "table_primary ::= parenthesized_joined_table",
 /* 365 */ "alias_opt ::=",
 /* 366 */ "alias_opt ::= table_alias",
 /* 367 */ "alias_opt ::= AS table_alias",
 /* 368 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 369 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 370 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 371 */ "join_type ::=",
 /* 372 */ "join_type ::= INNER",
 /* 373 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 374 */ "set_quantifier_opt ::=",
 /* 375 */ "set_quantifier_opt ::= DISTINCT",
 /* 376 */ "set_quantifier_opt ::= ALL",
 /* 377 */ "select_list ::= NK_STAR",
 /* 378 */ "select_list ::= select_sublist",
 /* 379 */ "select_sublist ::= select_item",
 /* 380 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 381 */ "select_item ::= common_expression",
 /* 382 */ "select_item ::= common_expression column_alias",
 /* 383 */ "select_item ::= common_expression AS column_alias",
 /* 384 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 385 */ "where_clause_opt ::=",
 /* 386 */ "where_clause_opt ::= WHERE search_condition",
 /* 387 */ "partition_by_clause_opt ::=",
 /* 388 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 389 */ "twindow_clause_opt ::=",
 /* 390 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 391 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 392 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 393 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 394 */ "sliding_opt ::=",
 /* 395 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 396 */ "fill_opt ::=",
 /* 397 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 398 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 399 */ "fill_mode ::= NONE",
 /* 400 */ "fill_mode ::= PREV",
 /* 401 */ "fill_mode ::= NULL",
 /* 402 */ "fill_mode ::= LINEAR",
 /* 403 */ "fill_mode ::= NEXT",
 /* 404 */ "group_by_clause_opt ::=",
 /* 405 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 406 */ "group_by_list ::= expression",
 /* 407 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 408 */ "having_clause_opt ::=",
 /* 409 */ "having_clause_opt ::= HAVING search_condition",
 /* 410 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 411 */ "query_expression_body ::= query_primary",
 /* 412 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 413 */ "query_primary ::= query_specification",
 /* 414 */ "order_by_clause_opt ::=",
 /* 415 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 416 */ "slimit_clause_opt ::=",
 /* 417 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 418 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 419 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 420 */ "limit_clause_opt ::=",
 /* 421 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 422 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 423 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 424 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 425 */ "search_condition ::= common_expression",
 /* 426 */ "sort_specification_list ::= sort_specification",
 /* 427 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 428 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 429 */ "ordering_specification_opt ::=",
 /* 430 */ "ordering_specification_opt ::= ASC",
 /* 431 */ "ordering_specification_opt ::= DESC",
 /* 432 */ "null_ordering_opt ::=",
 /* 433 */ "null_ordering_opt ::= NULLS FIRST",
 /* 434 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 221: /* cmd */
    case 224: /* literal */
    case 231: /* db_options */
    case 233: /* alter_db_options */
    case 238: /* retention */
    case 239: /* full_table_name */
    case 242: /* table_options */
    case 246: /* alter_table_clause */
    case 247: /* alter_table_options */
    case 250: /* create_subtable_clause */
    case 253: /* drop_table_clause */
    case 256: /* column_def */
    case 259: /* col_name */
    case 260: /* db_name_cond_opt */
    case 261: /* like_pattern_opt */
    case 262: /* table_name_cond */
    case 263: /* from_db_opt */
    case 264: /* func_name */
    case 267: /* index_options */
    case 269: /* duration_literal */
    case 270: /* sliding_opt */
    case 271: /* func */
    case 274: /* query_expression */
    case 276: /* explain_options */
    case 280: /* stream_options */
    case 281: /* into_opt */
    case 283: /* signed */
    case 284: /* signed_literal */
    case 287: /* expression */
    case 288: /* pseudo_column */
    case 289: /* column_reference */
    case 290: /* function_expression */
    case 291: /* subquery */
    case 296: /* star_func_para */
    case 297: /* predicate */
    case 300: /* in_predicate_value */
    case 301: /* boolean_value_expression */
    case 302: /* boolean_primary */
    case 303: /* common_expression */
    case 304: /* from_clause */
    case 305: /* table_reference_list */
    case 306: /* table_reference */
    case 307: /* table_primary */
    case 308: /* joined_table */
    case 310: /* parenthesized_joined_table */
    case 312: /* search_condition */
    case 313: /* query_specification */
    case 316: /* where_clause_opt */
    case 318: /* twindow_clause_opt */
    case 320: /* having_clause_opt */
    case 322: /* select_item */
    case 323: /* fill_opt */
    case 326: /* query_expression_body */
    case 328: /* slimit_clause_opt */
    case 329: /* limit_clause_opt */
    case 330: /* query_primary */
    case 332: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy42)); 
}
      break;
    case 222: /* account_options */
    case 223: /* alter_account_options */
    case 225: /* alter_account_option */
    case 278: /* bufsize_opt */
{
 
}
      break;
    case 226: /* user_name */
    case 227: /* dnode_endpoint */
    case 228: /* dnode_host_name */
    case 230: /* db_name */
    case 248: /* column_name */
    case 255: /* table_name */
    case 265: /* function_name */
    case 266: /* index_name */
    case 273: /* topic_name */
    case 279: /* stream_name */
    case 285: /* table_alias */
    case 286: /* column_alias */
    case 292: /* star_func */
    case 294: /* noarg_func */
    case 309: /* alias_opt */
{
 
}
      break;
    case 229: /* not_exists_opt */
    case 232: /* exists_opt */
    case 275: /* analyze_opt */
    case 277: /* agg_func_opt */
    case 314: /* set_quantifier_opt */
{
 
}
      break;
    case 234: /* integer_list */
    case 235: /* variable_list */
    case 236: /* retention_list */
    case 240: /* column_def_list */
    case 241: /* tags_def_opt */
    case 243: /* multi_create_clause */
    case 244: /* tags_def */
    case 245: /* multi_drop_clause */
    case 251: /* specific_tags_opt */
    case 252: /* literal_list */
    case 254: /* col_name_list */
    case 257: /* func_name_list */
    case 268: /* func_list */
    case 272: /* expression_list */
    case 282: /* dnode_list */
    case 293: /* star_func_para_list */
    case 295: /* other_para_list */
    case 315: /* select_list */
    case 317: /* partition_by_clause_opt */
    case 319: /* group_by_clause_opt */
    case 321: /* select_sublist */
    case 325: /* group_by_list */
    case 327: /* order_by_clause_opt */
    case 331: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy244)); 
}
      break;
    case 237: /* alter_db_option */
    case 258: /* alter_table_option */
{
 
}
      break;
    case 249: /* type_name */
{
 
}
      break;
    case 298: /* compare_op */
    case 299: /* in_op */
{
 
}
      break;
    case 311: /* join_type */
{
 
}
      break;
    case 324: /* fill_mode */
{
 
}
      break;
    case 333: /* ordering_specification_opt */
{
 
}
      break;
    case 334: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  221,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  221,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  222,    0 }, /* (2) account_options ::= */
  {  222,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  222,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  222,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  222,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  222,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  222,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  222,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  222,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  222,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  223,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  223,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  225,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  225,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  225,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  225,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  225,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  225,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  225,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  225,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  225,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  225,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  221,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  221,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  221,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  221,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  221,   -3 }, /* (28) cmd ::= CREATE DNODE dnode_endpoint */
  {  221,   -5 }, /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  221,   -3 }, /* (30) cmd ::= DROP DNODE NK_INTEGER */
  {  221,   -3 }, /* (31) cmd ::= DROP DNODE dnode_endpoint */
  {  221,   -4 }, /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  221,   -5 }, /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  221,   -4 }, /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
  {  221,   -5 }, /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  227,   -1 }, /* (36) dnode_endpoint ::= NK_STRING */
  {  228,   -1 }, /* (37) dnode_host_name ::= NK_ID */
  {  228,   -1 }, /* (38) dnode_host_name ::= NK_IPTOKEN */
  {  221,   -3 }, /* (39) cmd ::= ALTER LOCAL NK_STRING */
  {  221,   -4 }, /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  221,   -5 }, /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  221,   -5 }, /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  221,   -5 }, /* (43) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  221,   -5 }, /* (44) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  221,   -5 }, /* (45) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  221,   -5 }, /* (46) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  221,   -5 }, /* (47) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  221,   -5 }, /* (48) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  221,   -5 }, /* (49) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  221,   -4 }, /* (50) cmd ::= DROP DATABASE exists_opt db_name */
  {  221,   -2 }, /* (51) cmd ::= USE db_name */
  {  221,   -4 }, /* (52) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  229,   -3 }, /* (53) not_exists_opt ::= IF NOT EXISTS */
  {  229,    0 }, /* (54) not_exists_opt ::= */
  {  232,   -2 }, /* (55) exists_opt ::= IF EXISTS */
  {  232,    0 }, /* (56) exists_opt ::= */
  {  231,    0 }, /* (57) db_options ::= */
  {  231,   -3 }, /* (58) db_options ::= db_options BLOCKS NK_INTEGER */
  {  231,   -3 }, /* (59) db_options ::= db_options CACHE NK_INTEGER */
  {  231,   -3 }, /* (60) db_options ::= db_options CACHELAST NK_INTEGER */
  {  231,   -3 }, /* (61) db_options ::= db_options COMP NK_INTEGER */
  {  231,   -3 }, /* (62) db_options ::= db_options DAYS NK_INTEGER */
  {  231,   -3 }, /* (63) db_options ::= db_options DAYS NK_VARIABLE */
  {  231,   -3 }, /* (64) db_options ::= db_options FSYNC NK_INTEGER */
  {  231,   -3 }, /* (65) db_options ::= db_options MAXROWS NK_INTEGER */
  {  231,   -3 }, /* (66) db_options ::= db_options MINROWS NK_INTEGER */
  {  231,   -3 }, /* (67) db_options ::= db_options KEEP integer_list */
  {  231,   -3 }, /* (68) db_options ::= db_options KEEP variable_list */
  {  231,   -3 }, /* (69) db_options ::= db_options PRECISION NK_STRING */
  {  231,   -3 }, /* (70) db_options ::= db_options QUORUM NK_INTEGER */
  {  231,   -3 }, /* (71) db_options ::= db_options REPLICA NK_INTEGER */
  {  231,   -3 }, /* (72) db_options ::= db_options TTL NK_INTEGER */
  {  231,   -3 }, /* (73) db_options ::= db_options WAL NK_INTEGER */
  {  231,   -3 }, /* (74) db_options ::= db_options VGROUPS NK_INTEGER */
  {  231,   -3 }, /* (75) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  231,   -3 }, /* (76) db_options ::= db_options STREAM_MODE NK_INTEGER */
  {  231,   -3 }, /* (77) db_options ::= db_options RETENTIONS retention_list */
  {  231,   -3 }, /* (78) db_options ::= db_options STRICT NK_INTEGER */
  {  233,   -1 }, /* (79) alter_db_options ::= alter_db_option */
  {  233,   -2 }, /* (80) alter_db_options ::= alter_db_options alter_db_option */
  {  237,   -2 }, /* (81) alter_db_option ::= BLOCKS NK_INTEGER */
  {  237,   -2 }, /* (82) alter_db_option ::= FSYNC NK_INTEGER */
  {  237,   -2 }, /* (83) alter_db_option ::= KEEP integer_list */
  {  237,   -2 }, /* (84) alter_db_option ::= KEEP variable_list */
  {  237,   -2 }, /* (85) alter_db_option ::= WAL NK_INTEGER */
  {  237,   -2 }, /* (86) alter_db_option ::= QUORUM NK_INTEGER */
  {  237,   -2 }, /* (87) alter_db_option ::= CACHELAST NK_INTEGER */
  {  237,   -2 }, /* (88) alter_db_option ::= REPLICA NK_INTEGER */
  {  237,   -2 }, /* (89) alter_db_option ::= STRICT NK_INTEGER */
  {  234,   -1 }, /* (90) integer_list ::= NK_INTEGER */
  {  234,   -3 }, /* (91) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  235,   -1 }, /* (92) variable_list ::= NK_VARIABLE */
  {  235,   -3 }, /* (93) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  236,   -1 }, /* (94) retention_list ::= retention */
  {  236,   -3 }, /* (95) retention_list ::= retention_list NK_COMMA retention */
  {  238,   -3 }, /* (96) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  221,   -9 }, /* (97) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  221,   -3 }, /* (98) cmd ::= CREATE TABLE multi_create_clause */
  {  221,   -9 }, /* (99) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  221,   -3 }, /* (100) cmd ::= DROP TABLE multi_drop_clause */
  {  221,   -4 }, /* (101) cmd ::= DROP STABLE exists_opt full_table_name */
  {  221,   -3 }, /* (102) cmd ::= ALTER TABLE alter_table_clause */
  {  221,   -3 }, /* (103) cmd ::= ALTER STABLE alter_table_clause */
  {  246,   -2 }, /* (104) alter_table_clause ::= full_table_name alter_table_options */
  {  246,   -5 }, /* (105) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  246,   -4 }, /* (106) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  246,   -5 }, /* (107) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  246,   -5 }, /* (108) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  246,   -5 }, /* (109) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  246,   -4 }, /* (110) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  246,   -5 }, /* (111) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  246,   -5 }, /* (112) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  246,   -6 }, /* (113) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
  {  243,   -1 }, /* (114) multi_create_clause ::= create_subtable_clause */
  {  243,   -2 }, /* (115) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  250,   -9 }, /* (116) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
  {  245,   -1 }, /* (117) multi_drop_clause ::= drop_table_clause */
  {  245,   -2 }, /* (118) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  253,   -2 }, /* (119) drop_table_clause ::= exists_opt full_table_name */
  {  251,    0 }, /* (120) specific_tags_opt ::= */
  {  251,   -3 }, /* (121) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  239,   -1 }, /* (122) full_table_name ::= table_name */
  {  239,   -3 }, /* (123) full_table_name ::= db_name NK_DOT table_name */
  {  240,   -1 }, /* (124) column_def_list ::= column_def */
  {  240,   -3 }, /* (125) column_def_list ::= column_def_list NK_COMMA column_def */
  {  256,   -2 }, /* (126) column_def ::= column_name type_name */
  {  256,   -4 }, /* (127) column_def ::= column_name type_name COMMENT NK_STRING */
  {  249,   -1 }, /* (128) type_name ::= BOOL */
  {  249,   -1 }, /* (129) type_name ::= TINYINT */
  {  249,   -1 }, /* (130) type_name ::= SMALLINT */
  {  249,   -1 }, /* (131) type_name ::= INT */
  {  249,   -1 }, /* (132) type_name ::= INTEGER */
  {  249,   -1 }, /* (133) type_name ::= BIGINT */
  {  249,   -1 }, /* (134) type_name ::= FLOAT */
  {  249,   -1 }, /* (135) type_name ::= DOUBLE */
  {  249,   -4 }, /* (136) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  249,   -1 }, /* (137) type_name ::= TIMESTAMP */
  {  249,   -4 }, /* (138) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  249,   -2 }, /* (139) type_name ::= TINYINT UNSIGNED */
  {  249,   -2 }, /* (140) type_name ::= SMALLINT UNSIGNED */
  {  249,   -2 }, /* (141) type_name ::= INT UNSIGNED */
  {  249,   -2 }, /* (142) type_name ::= BIGINT UNSIGNED */
  {  249,   -1 }, /* (143) type_name ::= JSON */
  {  249,   -4 }, /* (144) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  249,   -1 }, /* (145) type_name ::= MEDIUMBLOB */
  {  249,   -1 }, /* (146) type_name ::= BLOB */
  {  249,   -4 }, /* (147) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  249,   -1 }, /* (148) type_name ::= DECIMAL */
  {  249,   -4 }, /* (149) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  249,   -6 }, /* (150) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  241,    0 }, /* (151) tags_def_opt ::= */
  {  241,   -1 }, /* (152) tags_def_opt ::= tags_def */
  {  244,   -4 }, /* (153) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  242,    0 }, /* (154) table_options ::= */
  {  242,   -3 }, /* (155) table_options ::= table_options COMMENT NK_STRING */
  {  242,   -3 }, /* (156) table_options ::= table_options KEEP integer_list */
  {  242,   -3 }, /* (157) table_options ::= table_options KEEP variable_list */
  {  242,   -3 }, /* (158) table_options ::= table_options TTL NK_INTEGER */
  {  242,   -5 }, /* (159) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  242,   -5 }, /* (160) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  242,   -3 }, /* (161) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  242,   -3 }, /* (162) table_options ::= table_options DELAY NK_INTEGER */
  {  247,   -1 }, /* (163) alter_table_options ::= alter_table_option */
  {  247,   -2 }, /* (164) alter_table_options ::= alter_table_options alter_table_option */
  {  258,   -2 }, /* (165) alter_table_option ::= COMMENT NK_STRING */
  {  258,   -2 }, /* (166) alter_table_option ::= KEEP integer_list */
  {  258,   -2 }, /* (167) alter_table_option ::= KEEP variable_list */
  {  258,   -2 }, /* (168) alter_table_option ::= TTL NK_INTEGER */
  {  254,   -1 }, /* (169) col_name_list ::= col_name */
  {  254,   -3 }, /* (170) col_name_list ::= col_name_list NK_COMMA col_name */
  {  259,   -1 }, /* (171) col_name ::= column_name */
  {  221,   -2 }, /* (172) cmd ::= SHOW DNODES */
  {  221,   -2 }, /* (173) cmd ::= SHOW USERS */
  {  221,   -2 }, /* (174) cmd ::= SHOW DATABASES */
  {  221,   -4 }, /* (175) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  221,   -4 }, /* (176) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  221,   -3 }, /* (177) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  221,   -2 }, /* (178) cmd ::= SHOW MNODES */
  {  221,   -2 }, /* (179) cmd ::= SHOW MODULES */
  {  221,   -2 }, /* (180) cmd ::= SHOW QNODES */
  {  221,   -2 }, /* (181) cmd ::= SHOW FUNCTIONS */
  {  221,   -5 }, /* (182) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  221,   -2 }, /* (183) cmd ::= SHOW STREAMS */
  {  221,   -2 }, /* (184) cmd ::= SHOW ACCOUNTS */
  {  221,   -2 }, /* (185) cmd ::= SHOW APPS */
  {  221,   -2 }, /* (186) cmd ::= SHOW CONNECTIONS */
  {  221,   -2 }, /* (187) cmd ::= SHOW LICENCE */
  {  221,   -2 }, /* (188) cmd ::= SHOW GRANTS */
  {  221,   -4 }, /* (189) cmd ::= SHOW CREATE DATABASE db_name */
  {  221,   -4 }, /* (190) cmd ::= SHOW CREATE TABLE full_table_name */
  {  221,   -4 }, /* (191) cmd ::= SHOW CREATE STABLE full_table_name */
  {  221,   -2 }, /* (192) cmd ::= SHOW QUERIES */
  {  221,   -2 }, /* (193) cmd ::= SHOW SCORES */
  {  221,   -2 }, /* (194) cmd ::= SHOW TOPICS */
  {  221,   -2 }, /* (195) cmd ::= SHOW VARIABLES */
  {  221,   -2 }, /* (196) cmd ::= SHOW BNODES */
  {  221,   -2 }, /* (197) cmd ::= SHOW SNODES */
  {  260,    0 }, /* (198) db_name_cond_opt ::= */
  {  260,   -2 }, /* (199) db_name_cond_opt ::= db_name NK_DOT */
  {  261,    0 }, /* (200) like_pattern_opt ::= */
  {  261,   -2 }, /* (201) like_pattern_opt ::= LIKE NK_STRING */
  {  262,   -1 }, /* (202) table_name_cond ::= table_name */
  {  263,    0 }, /* (203) from_db_opt ::= */
  {  263,   -2 }, /* (204) from_db_opt ::= FROM db_name */
  {  257,   -1 }, /* (205) func_name_list ::= func_name */
  {  257,   -3 }, /* (206) func_name_list ::= func_name_list NK_COMMA func_name */
  {  264,   -1 }, /* (207) func_name ::= function_name */
  {  221,   -8 }, /* (208) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  221,  -10 }, /* (209) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  221,   -6 }, /* (210) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  267,    0 }, /* (211) index_options ::= */
  {  267,   -9 }, /* (212) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  267,  -11 }, /* (213) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  268,   -1 }, /* (214) func_list ::= func */
  {  268,   -3 }, /* (215) func_list ::= func_list NK_COMMA func */
  {  271,   -4 }, /* (216) func ::= function_name NK_LP expression_list NK_RP */
  {  221,   -6 }, /* (217) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  221,   -6 }, /* (218) cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
  {  221,   -4 }, /* (219) cmd ::= DROP TOPIC exists_opt topic_name */
  {  221,   -2 }, /* (220) cmd ::= DESC full_table_name */
  {  221,   -2 }, /* (221) cmd ::= DESCRIBE full_table_name */
  {  221,   -3 }, /* (222) cmd ::= RESET QUERY CACHE */
  {  221,   -4 }, /* (223) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  275,    0 }, /* (224) analyze_opt ::= */
  {  275,   -1 }, /* (225) analyze_opt ::= ANALYZE */
  {  276,    0 }, /* (226) explain_options ::= */
  {  276,   -3 }, /* (227) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  276,   -3 }, /* (228) explain_options ::= explain_options RATIO NK_FLOAT */
  {  221,   -6 }, /* (229) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  221,   -9 }, /* (230) cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  221,   -3 }, /* (231) cmd ::= DROP FUNCTION function_name */
  {  277,    0 }, /* (232) agg_func_opt ::= */
  {  277,   -1 }, /* (233) agg_func_opt ::= AGGREGATE */
  {  278,    0 }, /* (234) bufsize_opt ::= */
  {  278,   -2 }, /* (235) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  221,   -8 }, /* (236) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  221,   -4 }, /* (237) cmd ::= DROP STREAM exists_opt stream_name */
  {  281,    0 }, /* (238) into_opt ::= */
  {  281,   -2 }, /* (239) into_opt ::= INTO full_table_name */
  {  280,    0 }, /* (240) stream_options ::= */
  {  280,   -3 }, /* (241) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  280,   -3 }, /* (242) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  280,   -3 }, /* (243) stream_options ::= stream_options WATERMARK duration_literal */
  {  221,   -3 }, /* (244) cmd ::= KILL CONNECTION NK_INTEGER */
  {  221,   -3 }, /* (245) cmd ::= KILL QUERY NK_INTEGER */
  {  221,   -4 }, /* (246) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  221,   -4 }, /* (247) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  221,   -3 }, /* (248) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  282,   -2 }, /* (249) dnode_list ::= DNODE NK_INTEGER */
  {  282,   -3 }, /* (250) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  221,   -3 }, /* (251) cmd ::= SYNCDB db_name REPLICA */
  {  221,   -1 }, /* (252) cmd ::= query_expression */
  {  224,   -1 }, /* (253) literal ::= NK_INTEGER */
  {  224,   -1 }, /* (254) literal ::= NK_FLOAT */
  {  224,   -1 }, /* (255) literal ::= NK_STRING */
  {  224,   -1 }, /* (256) literal ::= NK_BOOL */
  {  224,   -2 }, /* (257) literal ::= TIMESTAMP NK_STRING */
  {  224,   -1 }, /* (258) literal ::= duration_literal */
  {  224,   -1 }, /* (259) literal ::= NULL */
  {  224,   -1 }, /* (260) literal ::= NK_QUESTION */
  {  269,   -1 }, /* (261) duration_literal ::= NK_VARIABLE */
  {  283,   -1 }, /* (262) signed ::= NK_INTEGER */
  {  283,   -2 }, /* (263) signed ::= NK_PLUS NK_INTEGER */
  {  283,   -2 }, /* (264) signed ::= NK_MINUS NK_INTEGER */
  {  283,   -1 }, /* (265) signed ::= NK_FLOAT */
  {  283,   -2 }, /* (266) signed ::= NK_PLUS NK_FLOAT */
  {  283,   -2 }, /* (267) signed ::= NK_MINUS NK_FLOAT */
  {  284,   -1 }, /* (268) signed_literal ::= signed */
  {  284,   -1 }, /* (269) signed_literal ::= NK_STRING */
  {  284,   -1 }, /* (270) signed_literal ::= NK_BOOL */
  {  284,   -2 }, /* (271) signed_literal ::= TIMESTAMP NK_STRING */
  {  284,   -1 }, /* (272) signed_literal ::= duration_literal */
  {  284,   -1 }, /* (273) signed_literal ::= NULL */
  {  252,   -1 }, /* (274) literal_list ::= signed_literal */
  {  252,   -3 }, /* (275) literal_list ::= literal_list NK_COMMA signed_literal */
  {  230,   -1 }, /* (276) db_name ::= NK_ID */
  {  255,   -1 }, /* (277) table_name ::= NK_ID */
  {  248,   -1 }, /* (278) column_name ::= NK_ID */
  {  265,   -1 }, /* (279) function_name ::= NK_ID */
  {  285,   -1 }, /* (280) table_alias ::= NK_ID */
  {  286,   -1 }, /* (281) column_alias ::= NK_ID */
  {  226,   -1 }, /* (282) user_name ::= NK_ID */
  {  266,   -1 }, /* (283) index_name ::= NK_ID */
  {  273,   -1 }, /* (284) topic_name ::= NK_ID */
  {  279,   -1 }, /* (285) stream_name ::= NK_ID */
  {  287,   -1 }, /* (286) expression ::= literal */
  {  287,   -1 }, /* (287) expression ::= pseudo_column */
  {  287,   -1 }, /* (288) expression ::= column_reference */
  {  287,   -1 }, /* (289) expression ::= function_expression */
  {  287,   -1 }, /* (290) expression ::= subquery */
  {  287,   -3 }, /* (291) expression ::= NK_LP expression NK_RP */
  {  287,   -2 }, /* (292) expression ::= NK_PLUS expression */
  {  287,   -2 }, /* (293) expression ::= NK_MINUS expression */
  {  287,   -3 }, /* (294) expression ::= expression NK_PLUS expression */
  {  287,   -3 }, /* (295) expression ::= expression NK_MINUS expression */
  {  287,   -3 }, /* (296) expression ::= expression NK_STAR expression */
  {  287,   -3 }, /* (297) expression ::= expression NK_SLASH expression */
  {  287,   -3 }, /* (298) expression ::= expression NK_REM expression */
  {  287,   -3 }, /* (299) expression ::= column_reference NK_ARROW NK_STRING */
  {  272,   -1 }, /* (300) expression_list ::= expression */
  {  272,   -3 }, /* (301) expression_list ::= expression_list NK_COMMA expression */
  {  289,   -1 }, /* (302) column_reference ::= column_name */
  {  289,   -3 }, /* (303) column_reference ::= table_name NK_DOT column_name */
  {  288,   -1 }, /* (304) pseudo_column ::= ROWTS */
  {  288,   -1 }, /* (305) pseudo_column ::= TBNAME */
  {  288,   -1 }, /* (306) pseudo_column ::= QSTARTTS */
  {  288,   -1 }, /* (307) pseudo_column ::= QENDTS */
  {  288,   -1 }, /* (308) pseudo_column ::= WSTARTTS */
  {  288,   -1 }, /* (309) pseudo_column ::= WENDTS */
  {  288,   -1 }, /* (310) pseudo_column ::= WDURATION */
  {  290,   -4 }, /* (311) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  290,   -4 }, /* (312) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  290,   -6 }, /* (313) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  290,   -3 }, /* (314) function_expression ::= noarg_func NK_LP NK_RP */
  {  294,   -1 }, /* (315) noarg_func ::= NOW */
  {  294,   -1 }, /* (316) noarg_func ::= TODAY */
  {  294,   -1 }, /* (317) noarg_func ::= TIMEZONE */
  {  292,   -1 }, /* (318) star_func ::= COUNT */
  {  292,   -1 }, /* (319) star_func ::= FIRST */
  {  292,   -1 }, /* (320) star_func ::= LAST */
  {  292,   -1 }, /* (321) star_func ::= LAST_ROW */
  {  293,   -1 }, /* (322) star_func_para_list ::= NK_STAR */
  {  293,   -1 }, /* (323) star_func_para_list ::= other_para_list */
  {  295,   -1 }, /* (324) other_para_list ::= star_func_para */
  {  295,   -3 }, /* (325) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  296,   -1 }, /* (326) star_func_para ::= expression */
  {  296,   -3 }, /* (327) star_func_para ::= table_name NK_DOT NK_STAR */
  {  297,   -3 }, /* (328) predicate ::= expression compare_op expression */
  {  297,   -5 }, /* (329) predicate ::= expression BETWEEN expression AND expression */
  {  297,   -6 }, /* (330) predicate ::= expression NOT BETWEEN expression AND expression */
  {  297,   -3 }, /* (331) predicate ::= expression IS NULL */
  {  297,   -4 }, /* (332) predicate ::= expression IS NOT NULL */
  {  297,   -3 }, /* (333) predicate ::= expression in_op in_predicate_value */
  {  298,   -1 }, /* (334) compare_op ::= NK_LT */
  {  298,   -1 }, /* (335) compare_op ::= NK_GT */
  {  298,   -1 }, /* (336) compare_op ::= NK_LE */
  {  298,   -1 }, /* (337) compare_op ::= NK_GE */
  {  298,   -1 }, /* (338) compare_op ::= NK_NE */
  {  298,   -1 }, /* (339) compare_op ::= NK_EQ */
  {  298,   -1 }, /* (340) compare_op ::= LIKE */
  {  298,   -2 }, /* (341) compare_op ::= NOT LIKE */
  {  298,   -1 }, /* (342) compare_op ::= MATCH */
  {  298,   -1 }, /* (343) compare_op ::= NMATCH */
  {  298,   -1 }, /* (344) compare_op ::= CONTAINS */
  {  299,   -1 }, /* (345) in_op ::= IN */
  {  299,   -2 }, /* (346) in_op ::= NOT IN */
  {  300,   -3 }, /* (347) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  301,   -1 }, /* (348) boolean_value_expression ::= boolean_primary */
  {  301,   -2 }, /* (349) boolean_value_expression ::= NOT boolean_primary */
  {  301,   -3 }, /* (350) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  301,   -3 }, /* (351) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  302,   -1 }, /* (352) boolean_primary ::= predicate */
  {  302,   -3 }, /* (353) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  303,   -1 }, /* (354) common_expression ::= expression */
  {  303,   -1 }, /* (355) common_expression ::= boolean_value_expression */
  {  304,   -2 }, /* (356) from_clause ::= FROM table_reference_list */
  {  305,   -1 }, /* (357) table_reference_list ::= table_reference */
  {  305,   -3 }, /* (358) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  306,   -1 }, /* (359) table_reference ::= table_primary */
  {  306,   -1 }, /* (360) table_reference ::= joined_table */
  {  307,   -2 }, /* (361) table_primary ::= table_name alias_opt */
  {  307,   -4 }, /* (362) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  307,   -2 }, /* (363) table_primary ::= subquery alias_opt */
  {  307,   -1 }, /* (364) table_primary ::= parenthesized_joined_table */
  {  309,    0 }, /* (365) alias_opt ::= */
  {  309,   -1 }, /* (366) alias_opt ::= table_alias */
  {  309,   -2 }, /* (367) alias_opt ::= AS table_alias */
  {  310,   -3 }, /* (368) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  310,   -3 }, /* (369) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  308,   -6 }, /* (370) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  311,    0 }, /* (371) join_type ::= */
  {  311,   -1 }, /* (372) join_type ::= INNER */
  {  313,   -9 }, /* (373) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  314,    0 }, /* (374) set_quantifier_opt ::= */
  {  314,   -1 }, /* (375) set_quantifier_opt ::= DISTINCT */
  {  314,   -1 }, /* (376) set_quantifier_opt ::= ALL */
  {  315,   -1 }, /* (377) select_list ::= NK_STAR */
  {  315,   -1 }, /* (378) select_list ::= select_sublist */
  {  321,   -1 }, /* (379) select_sublist ::= select_item */
  {  321,   -3 }, /* (380) select_sublist ::= select_sublist NK_COMMA select_item */
  {  322,   -1 }, /* (381) select_item ::= common_expression */
  {  322,   -2 }, /* (382) select_item ::= common_expression column_alias */
  {  322,   -3 }, /* (383) select_item ::= common_expression AS column_alias */
  {  322,   -3 }, /* (384) select_item ::= table_name NK_DOT NK_STAR */
  {  316,    0 }, /* (385) where_clause_opt ::= */
  {  316,   -2 }, /* (386) where_clause_opt ::= WHERE search_condition */
  {  317,    0 }, /* (387) partition_by_clause_opt ::= */
  {  317,   -3 }, /* (388) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  318,    0 }, /* (389) twindow_clause_opt ::= */
  {  318,   -6 }, /* (390) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  318,   -4 }, /* (391) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  318,   -6 }, /* (392) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  318,   -8 }, /* (393) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  270,    0 }, /* (394) sliding_opt ::= */
  {  270,   -4 }, /* (395) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  323,    0 }, /* (396) fill_opt ::= */
  {  323,   -4 }, /* (397) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  323,   -6 }, /* (398) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  324,   -1 }, /* (399) fill_mode ::= NONE */
  {  324,   -1 }, /* (400) fill_mode ::= PREV */
  {  324,   -1 }, /* (401) fill_mode ::= NULL */
  {  324,   -1 }, /* (402) fill_mode ::= LINEAR */
  {  324,   -1 }, /* (403) fill_mode ::= NEXT */
  {  319,    0 }, /* (404) group_by_clause_opt ::= */
  {  319,   -3 }, /* (405) group_by_clause_opt ::= GROUP BY group_by_list */
  {  325,   -1 }, /* (406) group_by_list ::= expression */
  {  325,   -3 }, /* (407) group_by_list ::= group_by_list NK_COMMA expression */
  {  320,    0 }, /* (408) having_clause_opt ::= */
  {  320,   -2 }, /* (409) having_clause_opt ::= HAVING search_condition */
  {  274,   -4 }, /* (410) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  326,   -1 }, /* (411) query_expression_body ::= query_primary */
  {  326,   -4 }, /* (412) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  330,   -1 }, /* (413) query_primary ::= query_specification */
  {  327,    0 }, /* (414) order_by_clause_opt ::= */
  {  327,   -3 }, /* (415) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  328,    0 }, /* (416) slimit_clause_opt ::= */
  {  328,   -2 }, /* (417) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  328,   -4 }, /* (418) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  328,   -4 }, /* (419) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  329,    0 }, /* (420) limit_clause_opt ::= */
  {  329,   -2 }, /* (421) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  329,   -4 }, /* (422) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  329,   -4 }, /* (423) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  291,   -3 }, /* (424) subquery ::= NK_LP query_expression NK_RP */
  {  312,   -1 }, /* (425) search_condition ::= common_expression */
  {  331,   -1 }, /* (426) sort_specification_list ::= sort_specification */
  {  331,   -3 }, /* (427) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  332,   -3 }, /* (428) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  333,    0 }, /* (429) ordering_specification_opt ::= */
  {  333,   -1 }, /* (430) ordering_specification_opt ::= ASC */
  {  333,   -1 }, /* (431) ordering_specification_opt ::= DESC */
  {  334,    0 }, /* (432) null_ordering_opt ::= */
  {  334,   -2 }, /* (433) null_ordering_opt ::= NULLS FIRST */
  {  334,   -2 }, /* (434) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,222,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,223,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,222,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,224,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,225,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,223,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,225,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,224,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy359, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy359, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy359, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy359); }
        break;
      case 28: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy359, NULL); }
        break;
      case 29: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy359, &yymsp[0].minor.yy0); }
        break;
      case 30: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 31: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy359); }
        break;
      case 32: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 33: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 34: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 35: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 36: /* dnode_endpoint ::= NK_STRING */
      case 37: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==37);
      case 38: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==38);
      case 276: /* db_name ::= NK_ID */ yytestcase(yyruleno==276);
      case 277: /* table_name ::= NK_ID */ yytestcase(yyruleno==277);
      case 278: /* column_name ::= NK_ID */ yytestcase(yyruleno==278);
      case 279: /* function_name ::= NK_ID */ yytestcase(yyruleno==279);
      case 280: /* table_alias ::= NK_ID */ yytestcase(yyruleno==280);
      case 281: /* column_alias ::= NK_ID */ yytestcase(yyruleno==281);
      case 282: /* user_name ::= NK_ID */ yytestcase(yyruleno==282);
      case 283: /* index_name ::= NK_ID */ yytestcase(yyruleno==283);
      case 284: /* topic_name ::= NK_ID */ yytestcase(yyruleno==284);
      case 285: /* stream_name ::= NK_ID */ yytestcase(yyruleno==285);
      case 315: /* noarg_func ::= NOW */ yytestcase(yyruleno==315);
      case 316: /* noarg_func ::= TODAY */ yytestcase(yyruleno==316);
      case 317: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==317);
      case 318: /* star_func ::= COUNT */ yytestcase(yyruleno==318);
      case 319: /* star_func ::= FIRST */ yytestcase(yyruleno==319);
      case 320: /* star_func ::= LAST */ yytestcase(yyruleno==320);
      case 321: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==321);
{ yylhsminor.yy359 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy359 = yylhsminor.yy359;
        break;
      case 39: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 40: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 42: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 46: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy237, &yymsp[-1].minor.yy359, yymsp[0].minor.yy42); }
        break;
      case 50: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy237, &yymsp[0].minor.yy359); }
        break;
      case 51: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy359); }
        break;
      case 52: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy359, yymsp[0].minor.yy42); }
        break;
      case 53: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy237 = true; }
        break;
      case 54: /* not_exists_opt ::= */
      case 56: /* exists_opt ::= */ yytestcase(yyruleno==56);
      case 224: /* analyze_opt ::= */ yytestcase(yyruleno==224);
      case 232: /* agg_func_opt ::= */ yytestcase(yyruleno==232);
      case 374: /* set_quantifier_opt ::= */ yytestcase(yyruleno==374);
{ yymsp[1].minor.yy237 = false; }
        break;
      case 55: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy237 = true; }
        break;
      case 57: /* db_options ::= */
{ yymsp[1].minor.yy42 = createDatabaseOptions(pCxt); }
        break;
      case 58: /* db_options ::= db_options BLOCKS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy42)->pNumOfBlocks = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 59: /* db_options ::= db_options CACHE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy42)->pCacheBlockSize = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 60: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy42)->pCachelast = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 61: /* db_options ::= db_options COMP NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy42)->pCompressionLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 62: /* db_options ::= db_options DAYS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy42)->pDaysPerFile = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 63: /* db_options ::= db_options DAYS NK_VARIABLE */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy42)->pDaysPerFile = (SValueNode*)createDurationValueNode(pCxt, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 64: /* db_options ::= db_options FSYNC NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy42)->pFsyncPeriod = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 65: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy42)->pMaxRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 66: /* db_options ::= db_options MINROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy42)->pMinRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 67: /* db_options ::= db_options KEEP integer_list */
      case 68: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==68);
{ ((SDatabaseOptions*)yymsp[-2].minor.yy42)->pKeep = yymsp[0].minor.yy244; yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 69: /* db_options ::= db_options PRECISION NK_STRING */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy42)->pPrecision = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 70: /* db_options ::= db_options QUORUM NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy42)->pQuorum = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 71: /* db_options ::= db_options REPLICA NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy42)->pReplica = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 72: /* db_options ::= db_options TTL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy42)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 73: /* db_options ::= db_options WAL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy42)->pWalLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 74: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy42)->pNumOfVgroups = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 75: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy42)->pSingleStable = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 76: /* db_options ::= db_options STREAM_MODE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy42)->pStreamMode = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 77: /* db_options ::= db_options RETENTIONS retention_list */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy42)->pRetentions = yymsp[0].minor.yy244; yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 78: /* db_options ::= db_options STRICT NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy42)->pStrict = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 79: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy42 = createDatabaseOptions(pCxt); yylhsminor.yy42 = setDatabaseAlterOption(pCxt, yylhsminor.yy42, &yymsp[0].minor.yy325); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 80: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy42 = setDatabaseAlterOption(pCxt, yymsp[-1].minor.yy42, &yymsp[0].minor.yy325); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 81: /* alter_db_option ::= BLOCKS NK_INTEGER */
{ yymsp[-1].minor.yy325.type = DB_OPTION_BLOCKS; yymsp[-1].minor.yy325.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 82: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy325.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy325.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 83: /* alter_db_option ::= KEEP integer_list */
      case 84: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==84);
{ yymsp[-1].minor.yy325.type = DB_OPTION_KEEP; yymsp[-1].minor.yy325.pList = yymsp[0].minor.yy244; }
        break;
      case 85: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy325.type = DB_OPTION_WAL; yymsp[-1].minor.yy325.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 86: /* alter_db_option ::= QUORUM NK_INTEGER */
{ yymsp[-1].minor.yy325.type = DB_OPTION_QUORUM; yymsp[-1].minor.yy325.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 87: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy325.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy325.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 88: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy325.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy325.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 89: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy325.type = DB_OPTION_STRICT; yymsp[-1].minor.yy325.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 90: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy244 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy244 = yylhsminor.yy244;
        break;
      case 91: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 250: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==250);
{ yylhsminor.yy244 = addNodeToList(pCxt, yymsp[-2].minor.yy244, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy244 = yylhsminor.yy244;
        break;
      case 92: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy244 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy244 = yylhsminor.yy244;
        break;
      case 93: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy244 = addNodeToList(pCxt, yymsp[-2].minor.yy244, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy244 = yylhsminor.yy244;
        break;
      case 94: /* retention_list ::= retention */
      case 114: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==114);
      case 117: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==117);
      case 124: /* column_def_list ::= column_def */ yytestcase(yyruleno==124);
      case 169: /* col_name_list ::= col_name */ yytestcase(yyruleno==169);
      case 205: /* func_name_list ::= func_name */ yytestcase(yyruleno==205);
      case 214: /* func_list ::= func */ yytestcase(yyruleno==214);
      case 274: /* literal_list ::= signed_literal */ yytestcase(yyruleno==274);
      case 324: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==324);
      case 379: /* select_sublist ::= select_item */ yytestcase(yyruleno==379);
      case 426: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==426);
{ yylhsminor.yy244 = createNodeList(pCxt, yymsp[0].minor.yy42); }
  yymsp[0].minor.yy244 = yylhsminor.yy244;
        break;
      case 95: /* retention_list ::= retention_list NK_COMMA retention */
      case 125: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==125);
      case 170: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==170);
      case 206: /* func_name_list ::= func_name_list NK_COMMA func_name */ yytestcase(yyruleno==206);
      case 215: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==215);
      case 275: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==275);
      case 325: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==325);
      case 380: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==380);
      case 427: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==427);
{ yylhsminor.yy244 = addNodeToList(pCxt, yymsp[-2].minor.yy244, yymsp[0].minor.yy42); }
  yymsp[-2].minor.yy244 = yylhsminor.yy244;
        break;
      case 96: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy42 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 97: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 99: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==99);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy237, yymsp[-5].minor.yy42, yymsp[-3].minor.yy244, yymsp[-1].minor.yy244, yymsp[0].minor.yy42); }
        break;
      case 98: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy244); }
        break;
      case 100: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy244); }
        break;
      case 101: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy237, yymsp[0].minor.yy42); }
        break;
      case 102: /* cmd ::= ALTER TABLE alter_table_clause */
      case 103: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==103);
      case 252: /* cmd ::= query_expression */ yytestcase(yyruleno==252);
{ pCxt->pRootNode = yymsp[0].minor.yy42; }
        break;
      case 104: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy42 = createAlterTableOption(pCxt, yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 105: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy42 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy359, yymsp[0].minor.yy314); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 106: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy42 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy42, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy359); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 107: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy42 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy359, yymsp[0].minor.yy314); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 108: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy42 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy359, &yymsp[0].minor.yy359); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 109: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy42 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy359, yymsp[0].minor.yy314); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 110: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy42 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy42, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy359); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 111: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy42 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy359, yymsp[0].minor.yy314); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 112: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy42 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy42, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy359, &yymsp[0].minor.yy359); }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 113: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
{ yylhsminor.yy42 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy42, &yymsp[-2].minor.yy359, yymsp[0].minor.yy42); }
  yymsp[-5].minor.yy42 = yylhsminor.yy42;
        break;
      case 115: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 118: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==118);
{ yylhsminor.yy244 = addNodeToList(pCxt, yymsp[-1].minor.yy244, yymsp[0].minor.yy42); }
  yymsp[-1].minor.yy244 = yylhsminor.yy244;
        break;
      case 116: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
{ yylhsminor.yy42 = createCreateSubTableClause(pCxt, yymsp[-8].minor.yy237, yymsp[-7].minor.yy42, yymsp[-5].minor.yy42, yymsp[-4].minor.yy244, yymsp[-1].minor.yy244); }
  yymsp[-8].minor.yy42 = yylhsminor.yy42;
        break;
      case 119: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy42 = createDropTableClause(pCxt, yymsp[-1].minor.yy237, yymsp[0].minor.yy42); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 120: /* specific_tags_opt ::= */
      case 151: /* tags_def_opt ::= */ yytestcase(yyruleno==151);
      case 387: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==387);
      case 404: /* group_by_clause_opt ::= */ yytestcase(yyruleno==404);
      case 414: /* order_by_clause_opt ::= */ yytestcase(yyruleno==414);
{ yymsp[1].minor.yy244 = NULL; }
        break;
      case 121: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy244 = yymsp[-1].minor.yy244; }
        break;
      case 122: /* full_table_name ::= table_name */
{ yylhsminor.yy42 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy359, NULL); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 123: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy42 = createRealTableNode(pCxt, &yymsp[-2].minor.yy359, &yymsp[0].minor.yy359, NULL); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 126: /* column_def ::= column_name type_name */
{ yylhsminor.yy42 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy359, yymsp[0].minor.yy314, NULL); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 127: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy42 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy359, yymsp[-2].minor.yy314, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 128: /* type_name ::= BOOL */
{ yymsp[0].minor.yy314 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 129: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy314 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 130: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy314 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 131: /* type_name ::= INT */
      case 132: /* type_name ::= INTEGER */ yytestcase(yyruleno==132);
{ yymsp[0].minor.yy314 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 133: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy314 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 134: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy314 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 135: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy314 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 136: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy314 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 137: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy314 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 138: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy314 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 139: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy314 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 140: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy314 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 141: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy314 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 142: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy314 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 143: /* type_name ::= JSON */
{ yymsp[0].minor.yy314 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 144: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy314 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 145: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy314 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 146: /* type_name ::= BLOB */
{ yymsp[0].minor.yy314 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 147: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy314 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 148: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy314 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 149: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy314 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 150: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy314 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 152: /* tags_def_opt ::= tags_def */
      case 323: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==323);
      case 378: /* select_list ::= select_sublist */ yytestcase(yyruleno==378);
{ yylhsminor.yy244 = yymsp[0].minor.yy244; }
  yymsp[0].minor.yy244 = yylhsminor.yy244;
        break;
      case 153: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy244 = yymsp[-1].minor.yy244; }
        break;
      case 154: /* table_options ::= */
{ yymsp[1].minor.yy42 = createTableOptions(pCxt); }
        break;
      case 155: /* table_options ::= table_options COMMENT NK_STRING */
{ ((STableOptions*)yymsp[-2].minor.yy42)->pComments = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 156: /* table_options ::= table_options KEEP integer_list */
      case 157: /* table_options ::= table_options KEEP variable_list */ yytestcase(yyruleno==157);
{ ((STableOptions*)yymsp[-2].minor.yy42)->pKeep = yymsp[0].minor.yy244; yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 158: /* table_options ::= table_options TTL NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy42)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 159: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy42)->pSma = yymsp[-1].minor.yy244; yylhsminor.yy42 = yymsp[-4].minor.yy42; }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 160: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy42)->pFuncs = yymsp[-1].minor.yy244; yylhsminor.yy42 = yymsp[-4].minor.yy42; }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 161: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ ((STableOptions*)yymsp[-2].minor.yy42)->pFilesFactor = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 162: /* table_options ::= table_options DELAY NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy42)->pDelay = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 163: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy42 = createTableOptions(pCxt); yylhsminor.yy42 = setTableAlterOption(pCxt, yylhsminor.yy42, &yymsp[0].minor.yy325); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 164: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy42 = setTableAlterOption(pCxt, yymsp[-1].minor.yy42, &yymsp[0].minor.yy325); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 165: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy325.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy325.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 166: /* alter_table_option ::= KEEP integer_list */
      case 167: /* alter_table_option ::= KEEP variable_list */ yytestcase(yyruleno==167);
{ yymsp[-1].minor.yy325.type = TABLE_OPTION_KEEP; yymsp[-1].minor.yy325.pList = yymsp[0].minor.yy244; }
        break;
      case 168: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy325.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy325.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 171: /* col_name ::= column_name */
{ yylhsminor.yy42 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy359); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 172: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 173: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 174: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 175: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 176: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 177: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy42, NULL); }
        break;
      case 178: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 179: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 180: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 181: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 182: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 183: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 184: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 185: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 186: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 187: /* cmd ::= SHOW LICENCE */
      case 188: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==188);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 189: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy359); }
        break;
      case 190: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy42); }
        break;
      case 191: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy42); }
        break;
      case 192: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 193: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 194: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 195: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 196: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT, NULL, NULL); }
        break;
      case 197: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT, NULL, NULL); }
        break;
      case 198: /* db_name_cond_opt ::= */
      case 203: /* from_db_opt ::= */ yytestcase(yyruleno==203);
{ yymsp[1].minor.yy42 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 199: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy359); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 200: /* like_pattern_opt ::= */
      case 211: /* index_options ::= */ yytestcase(yyruleno==211);
      case 238: /* into_opt ::= */ yytestcase(yyruleno==238);
      case 385: /* where_clause_opt ::= */ yytestcase(yyruleno==385);
      case 389: /* twindow_clause_opt ::= */ yytestcase(yyruleno==389);
      case 394: /* sliding_opt ::= */ yytestcase(yyruleno==394);
      case 396: /* fill_opt ::= */ yytestcase(yyruleno==396);
      case 408: /* having_clause_opt ::= */ yytestcase(yyruleno==408);
      case 416: /* slimit_clause_opt ::= */ yytestcase(yyruleno==416);
      case 420: /* limit_clause_opt ::= */ yytestcase(yyruleno==420);
{ yymsp[1].minor.yy42 = NULL; }
        break;
      case 201: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 202: /* table_name_cond ::= table_name */
{ yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy359); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 204: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy359); }
        break;
      case 207: /* func_name ::= function_name */
{ yylhsminor.yy42 = createFunctionNode(pCxt, &yymsp[0].minor.yy359, NULL); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 208: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy237, &yymsp[-3].minor.yy359, &yymsp[-1].minor.yy359, NULL, yymsp[0].minor.yy42); }
        break;
      case 209: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy237, &yymsp[-5].minor.yy359, &yymsp[-3].minor.yy359, yymsp[-1].minor.yy244, NULL); }
        break;
      case 210: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy237, &yymsp[-2].minor.yy359, &yymsp[0].minor.yy359); }
        break;
      case 212: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy42 = createIndexOption(pCxt, yymsp[-6].minor.yy244, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), NULL, yymsp[0].minor.yy42); }
        break;
      case 213: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy42 = createIndexOption(pCxt, yymsp[-8].minor.yy244, releaseRawExprNode(pCxt, yymsp[-4].minor.yy42), releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), yymsp[0].minor.yy42); }
        break;
      case 216: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy42 = createFunctionNode(pCxt, &yymsp[-3].minor.yy359, yymsp[-1].minor.yy244); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 217: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy237, &yymsp[-2].minor.yy359, yymsp[0].minor.yy42, NULL); }
        break;
      case 218: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy237, &yymsp[-2].minor.yy359, NULL, &yymsp[0].minor.yy359); }
        break;
      case 219: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy237, &yymsp[0].minor.yy359); }
        break;
      case 220: /* cmd ::= DESC full_table_name */
      case 221: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==221);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy42); }
        break;
      case 222: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 223: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy237, yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 225: /* analyze_opt ::= ANALYZE */
      case 233: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==233);
      case 375: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==375);
{ yymsp[0].minor.yy237 = true; }
        break;
      case 226: /* explain_options ::= */
{ yymsp[1].minor.yy42 = createDefaultExplainOptions(pCxt); }
        break;
      case 227: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy42 = setExplainVerbose(pCxt, yymsp[-2].minor.yy42, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 228: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy42 = setExplainRatio(pCxt, yymsp[-2].minor.yy42, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 229: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy244); }
        break;
      case 230: /* cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy237, &yymsp[-5].minor.yy359, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy314, yymsp[0].minor.yy240); }
        break;
      case 231: /* cmd ::= DROP FUNCTION function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, &yymsp[0].minor.yy359); }
        break;
      case 234: /* bufsize_opt ::= */
{ yymsp[1].minor.yy240 = 0; }
        break;
      case 235: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy240 = strtol(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 236: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy237, &yymsp[-4].minor.yy359, yymsp[-2].minor.yy42, yymsp[-3].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 237: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy237, &yymsp[0].minor.yy359); }
        break;
      case 239: /* into_opt ::= INTO full_table_name */
      case 356: /* from_clause ::= FROM table_reference_list */ yytestcase(yyruleno==356);
      case 386: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==386);
      case 409: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==409);
{ yymsp[-1].minor.yy42 = yymsp[0].minor.yy42; }
        break;
      case 240: /* stream_options ::= */
{ yymsp[1].minor.yy42 = createStreamOptions(pCxt); }
        break;
      case 241: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy42)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 242: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy42)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 243: /* stream_options ::= stream_options WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy42)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy42); yylhsminor.yy42 = yymsp[-2].minor.yy42; }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 244: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 245: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 246: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 247: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy244); }
        break;
      case 248: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 249: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy244 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 251: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy359); }
        break;
      case 253: /* literal ::= NK_INTEGER */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 254: /* literal ::= NK_FLOAT */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 255: /* literal ::= NK_STRING */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 256: /* literal ::= NK_BOOL */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 257: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 258: /* literal ::= duration_literal */
      case 268: /* signed_literal ::= signed */ yytestcase(yyruleno==268);
      case 286: /* expression ::= literal */ yytestcase(yyruleno==286);
      case 287: /* expression ::= pseudo_column */ yytestcase(yyruleno==287);
      case 288: /* expression ::= column_reference */ yytestcase(yyruleno==288);
      case 289: /* expression ::= function_expression */ yytestcase(yyruleno==289);
      case 290: /* expression ::= subquery */ yytestcase(yyruleno==290);
      case 348: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==348);
      case 352: /* boolean_primary ::= predicate */ yytestcase(yyruleno==352);
      case 354: /* common_expression ::= expression */ yytestcase(yyruleno==354);
      case 355: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==355);
      case 357: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==357);
      case 359: /* table_reference ::= table_primary */ yytestcase(yyruleno==359);
      case 360: /* table_reference ::= joined_table */ yytestcase(yyruleno==360);
      case 364: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==364);
      case 411: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==411);
      case 413: /* query_primary ::= query_specification */ yytestcase(yyruleno==413);
{ yylhsminor.yy42 = yymsp[0].minor.yy42; }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 259: /* literal ::= NULL */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 260: /* literal ::= NK_QUESTION */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 261: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 262: /* signed ::= NK_INTEGER */
{ yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 263: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 264: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 265: /* signed ::= NK_FLOAT */
{ yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 266: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 267: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 269: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 270: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 271: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 272: /* signed_literal ::= duration_literal */
      case 326: /* star_func_para ::= expression */ yytestcase(yyruleno==326);
      case 381: /* select_item ::= common_expression */ yytestcase(yyruleno==381);
      case 425: /* search_condition ::= common_expression */ yytestcase(yyruleno==425);
{ yylhsminor.yy42 = releaseRawExprNode(pCxt, yymsp[0].minor.yy42); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 273: /* signed_literal ::= NULL */
{ yymsp[0].minor.yy42 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL); }
        break;
      case 291: /* expression ::= NK_LP expression NK_RP */
      case 353: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==353);
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy42)); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 292: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy42));
                                                                                  }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 293: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy42), NULL));
                                                                                  }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 294: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); 
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 295: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); 
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 296: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); 
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 297: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); 
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 298: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); 
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 299: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 300: /* expression_list ::= expression */
{ yylhsminor.yy244 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy42)); }
  yymsp[0].minor.yy244 = yylhsminor.yy244;
        break;
      case 301: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy244 = addNodeToList(pCxt, yymsp[-2].minor.yy244, releaseRawExprNode(pCxt, yymsp[0].minor.yy42)); }
  yymsp[-2].minor.yy244 = yylhsminor.yy244;
        break;
      case 302: /* column_reference ::= column_name */
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy359, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy359)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 303: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy359, &yymsp[0].minor.yy359, createColumnNode(pCxt, &yymsp[-2].minor.yy359, &yymsp[0].minor.yy359)); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 304: /* pseudo_column ::= ROWTS */
      case 305: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==305);
      case 306: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==306);
      case 307: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==307);
      case 308: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==308);
      case 309: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==309);
      case 310: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==310);
{ yylhsminor.yy42 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy42 = yylhsminor.yy42;
        break;
      case 311: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 312: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==312);
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy359, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy359, yymsp[-1].minor.yy244)); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 313: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), yymsp[-1].minor.yy314)); }
  yymsp[-5].minor.yy42 = yylhsminor.yy42;
        break;
      case 314: /* function_expression ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy359, &yymsp[0].minor.yy0, createFunctionNodeNoArg(pCxt, &yymsp[-2].minor.yy359)); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 322: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy244 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy244 = yylhsminor.yy244;
        break;
      case 327: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 384: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==384);
{ yylhsminor.yy42 = createColumnNode(pCxt, &yymsp[-2].minor.yy359, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 328: /* predicate ::= expression compare_op expression */
      case 333: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==333);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy270, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 329: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy42), releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-4].minor.yy42 = yylhsminor.yy42;
        break;
      case 330: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy42), releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-5].minor.yy42 = yylhsminor.yy42;
        break;
      case 331: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), NULL));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 332: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), NULL));
                                                                                  }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 334: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy270 = OP_TYPE_LOWER_THAN; }
        break;
      case 335: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy270 = OP_TYPE_GREATER_THAN; }
        break;
      case 336: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy270 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 337: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy270 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 338: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy270 = OP_TYPE_NOT_EQUAL; }
        break;
      case 339: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy270 = OP_TYPE_EQUAL; }
        break;
      case 340: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy270 = OP_TYPE_LIKE; }
        break;
      case 341: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy270 = OP_TYPE_NOT_LIKE; }
        break;
      case 342: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy270 = OP_TYPE_MATCH; }
        break;
      case 343: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy270 = OP_TYPE_NMATCH; }
        break;
      case 344: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy270 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 345: /* in_op ::= IN */
{ yymsp[0].minor.yy270 = OP_TYPE_IN; }
        break;
      case 346: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy270 = OP_TYPE_NOT_IN; }
        break;
      case 347: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy244)); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 349: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy42), NULL));
                                                                                  }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 350: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 351: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy42);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy42);
                                                                                    yylhsminor.yy42 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), releaseRawExprNode(pCxt, yymsp[0].minor.yy42)));
                                                                                  }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 358: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy42 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy42, yymsp[0].minor.yy42, NULL); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 361: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy42 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy359, &yymsp[0].minor.yy359); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 362: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy42 = createRealTableNode(pCxt, &yymsp[-3].minor.yy359, &yymsp[-1].minor.yy359, &yymsp[0].minor.yy359); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 363: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy42 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy42), &yymsp[0].minor.yy359); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 365: /* alias_opt ::= */
{ yymsp[1].minor.yy359 = nil_token;  }
        break;
      case 366: /* alias_opt ::= table_alias */
{ yylhsminor.yy359 = yymsp[0].minor.yy359; }
  yymsp[0].minor.yy359 = yylhsminor.yy359;
        break;
      case 367: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy359 = yymsp[0].minor.yy359; }
        break;
      case 368: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 369: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==369);
{ yymsp[-2].minor.yy42 = yymsp[-1].minor.yy42; }
        break;
      case 370: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy42 = createJoinTableNode(pCxt, yymsp[-4].minor.yy102, yymsp[-5].minor.yy42, yymsp[-2].minor.yy42, yymsp[0].minor.yy42); }
  yymsp[-5].minor.yy42 = yylhsminor.yy42;
        break;
      case 371: /* join_type ::= */
{ yymsp[1].minor.yy102 = JOIN_TYPE_INNER; }
        break;
      case 372: /* join_type ::= INNER */
{ yymsp[0].minor.yy102 = JOIN_TYPE_INNER; }
        break;
      case 373: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy42 = createSelectStmt(pCxt, yymsp[-7].minor.yy237, yymsp[-6].minor.yy244, yymsp[-5].minor.yy42);
                                                                                    yymsp[-8].minor.yy42 = addWhereClause(pCxt, yymsp[-8].minor.yy42, yymsp[-4].minor.yy42);
                                                                                    yymsp[-8].minor.yy42 = addPartitionByClause(pCxt, yymsp[-8].minor.yy42, yymsp[-3].minor.yy244);
                                                                                    yymsp[-8].minor.yy42 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy42, yymsp[-2].minor.yy42);
                                                                                    yymsp[-8].minor.yy42 = addGroupByClause(pCxt, yymsp[-8].minor.yy42, yymsp[-1].minor.yy244);
                                                                                    yymsp[-8].minor.yy42 = addHavingClause(pCxt, yymsp[-8].minor.yy42, yymsp[0].minor.yy42);
                                                                                  }
        break;
      case 376: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy237 = false; }
        break;
      case 377: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy244 = NULL; }
        break;
      case 382: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy42 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy42), &yymsp[0].minor.yy359); }
  yymsp[-1].minor.yy42 = yylhsminor.yy42;
        break;
      case 383: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy42 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), &yymsp[0].minor.yy359); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 388: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 405: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==405);
      case 415: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==415);
{ yymsp[-2].minor.yy244 = yymsp[0].minor.yy244; }
        break;
      case 390: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy42 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), releaseRawExprNode(pCxt, yymsp[-1].minor.yy42)); }
        break;
      case 391: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy42 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy42)); }
        break;
      case 392: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy42 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), NULL, yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 393: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy42 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy42), releaseRawExprNode(pCxt, yymsp[-3].minor.yy42), yymsp[-1].minor.yy42, yymsp[0].minor.yy42); }
        break;
      case 395: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy42 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy42); }
        break;
      case 397: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy42 = createFillNode(pCxt, yymsp[-1].minor.yy544, NULL); }
        break;
      case 398: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy42 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy244)); }
        break;
      case 399: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy544 = FILL_MODE_NONE; }
        break;
      case 400: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy544 = FILL_MODE_PREV; }
        break;
      case 401: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy544 = FILL_MODE_NULL; }
        break;
      case 402: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy544 = FILL_MODE_LINEAR; }
        break;
      case 403: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy544 = FILL_MODE_NEXT; }
        break;
      case 406: /* group_by_list ::= expression */
{ yylhsminor.yy244 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); }
  yymsp[0].minor.yy244 = yylhsminor.yy244;
        break;
      case 407: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy244 = addNodeToList(pCxt, yymsp[-2].minor.yy244, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy42))); }
  yymsp[-2].minor.yy244 = yylhsminor.yy244;
        break;
      case 410: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy42 = addOrderByClause(pCxt, yymsp[-3].minor.yy42, yymsp[-2].minor.yy244);
                                                                                    yylhsminor.yy42 = addSlimitClause(pCxt, yylhsminor.yy42, yymsp[-1].minor.yy42);
                                                                                    yylhsminor.yy42 = addLimitClause(pCxt, yylhsminor.yy42, yymsp[0].minor.yy42);
                                                                                  }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 412: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy42 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy42, yymsp[0].minor.yy42); }
  yymsp[-3].minor.yy42 = yylhsminor.yy42;
        break;
      case 417: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 421: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==421);
{ yymsp[-1].minor.yy42 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 418: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 422: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==422);
{ yymsp[-3].minor.yy42 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 419: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 423: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==423);
{ yymsp[-3].minor.yy42 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 424: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy42 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy42); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 428: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy42 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy42), yymsp[-1].minor.yy508, yymsp[0].minor.yy197); }
  yymsp[-2].minor.yy42 = yylhsminor.yy42;
        break;
      case 429: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy508 = ORDER_ASC; }
        break;
      case 430: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy508 = ORDER_ASC; }
        break;
      case 431: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy508 = ORDER_DESC; }
        break;
      case 432: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy197 = NULL_ORDER_DEFAULT; }
        break;
      case 433: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy197 = NULL_ORDER_FIRST; }
        break;
      case 434: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy197 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (pCxt->valid) {
    if(TOKEN.z) {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
    pCxt->valid = false;
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
