---
title: 高效写入
---

## 高效写入原理

本节介绍如何高效地向 TDengine 写入数据。高效写入数据要考虑几个因素：数据在不同表（或子表）之间的分布，即要写入数据的相邻性；单次写入的数据量；并发连接数。一般来说，每批次只向同一张表（或子表）写入数据比向多张表（或子表）写入数据要更高效；每批次写入的数据量越大越高效（但超过一定阈值其优势会消失）；同时写入数据的并发连接数越多写入越高效（但超过一定阈值反而会下降，取决于服务端处理能力）。

为了更高效地向 TDengine 写入数据，客户端程序要充分且恰当地利用以上几个因素。在单次写入中尽量只向同一张表（或子表）写入数据，每批次写入的数据量经过测试和调优设定为一个最适合当前系统处理能力的数值，并发写入的连接数同样经过测试和调优后设定为一个最适合当前系统处理能力的数值，以实现在当前系统中的最佳写入速度。同时，TDegnine 还提供了独特的参数绑定写入，这也是一个有助于实现高效写入的方法。

## 场景分析

下面的示例程序展示了这样一个用户场景下如何高效写入数据：
- TDengine 客户端程序从消息队列或者其它数据源不断读入数据，在示例程序中采用读取数据文件的方式对此进行了模拟
- 单个连接向 TDengine 写入的速度无法与读数据的速度相匹配，因此客户端程序启动多个线程，每个线程都建立了与 TDengine 的连接
- 客户端程序将接收到的数据根据根据所属表（或子表）HASH 到不同的线程，并确保属于某个表（或子表）的数据一定会被一个固定的线程处理
- 各个子线程在接收到设定数量的数据后将该批数据写入 TDengine，并继续处理后面接收到的数据


## Java 示例程序

在 Java 示例程序中采用拼接 SQL 的写入方式。

```java text=Java 示例程序
##include{}
```

## Python 示例程序

在 Python 示例程序中采用参数绑定的写入方式。

```python test=Python 示例程序
##include{}
```
