/*
 * Copyright (c) 2019 TAOS Data, Inc. <jhtao@taosdata.com>
 *
 * This program is free software: you can use, redistribute, and/or modify
 * it under the terms of the GNU Affero General Public License, version 3
 * or later ("AGPL"), as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _TD_COMMON_TOKEN_H_
#define _TD_COMMON_TOKEN_H_

#define TK_OR                   1
#define TK_AND                  2
#define TK_UNION                3
#define TK_ALL                  4
#define TK_MINUS                5
#define TK_EXCEPT               6
#define TK_INTERSECT            7
#define TK_NK_BITAND            8
#define TK_NK_BITOR             9
#define TK_NK_LSHIFT            10
#define TK_NK_RSHIFT            11
#define TK_NK_PLUS              12
#define TK_NK_MINUS             13
#define TK_NK_STAR              14
#define TK_NK_SLASH             15
#define TK_NK_REM               16
#define TK_NK_CONCAT            17
#define TK_CREATE               18
#define TK_ACCOUNT              19
#define TK_NK_ID                20
#define TK_PASS                 21
#define TK_NK_STRING            22
#define TK_ALTER                23
#define TK_PPS                  24
#define TK_TSERIES              25
#define TK_STORAGE              26
#define TK_STREAMS              27
#define TK_QTIME                28
#define TK_DBS                  29
#define TK_USERS                30
#define TK_CONNS                31
#define TK_STATE                32
#define TK_USER                 33
#define TK_ENABLE               34
#define TK_NK_INTEGER           35
#define TK_SYSINFO              36
#define TK_DROP                 37
#define TK_GRANT                38
#define TK_ON                   39
#define TK_TO                   40
#define TK_REVOKE               41
#define TK_FROM                 42
#define TK_NK_COMMA             43
#define TK_READ                 44
#define TK_WRITE                45
#define TK_NK_DOT               46
#define TK_DNODE                47
#define TK_PORT                 48
#define TK_DNODES               49
#define TK_NK_IPTOKEN           50
#define TK_LOCAL                51
#define TK_QNODE                52
#define TK_BNODE                53
#define TK_SNODE                54
#define TK_MNODE                55
#define TK_DATABASE             56
#define TK_USE                  57
#define TK_FLUSH                58
#define TK_TRIM                 59
#define TK_IF                   60
#define TK_NOT                  61
#define TK_EXISTS               62
#define TK_BUFFER               63
#define TK_CACHEMODEL           64
#define TK_CACHESIZE            65
#define TK_COMP                 66
#define TK_DURATION             67
#define TK_NK_VARIABLE          68
#define TK_MAXROWS              69
#define TK_MINROWS              70
#define TK_KEEP                 71
#define TK_PAGES                72
#define TK_PAGESIZE             73
#define TK_PRECISION            74
#define TK_REPLICA              75
#define TK_STRICT               76
#define TK_VGROUPS              77
#define TK_SINGLE_STABLE        78
#define TK_RETENTIONS           79
#define TK_SCHEMALESS           80
#define TK_WAL_LEVEL            81
#define TK_WAL_FSYNC_PERIOD     82
#define TK_WAL_RETENTION_PERIOD 83
#define TK_WAL_RETENTION_SIZE   84
#define TK_WAL_ROLL_PERIOD      85
#define TK_WAL_SEGMENT_SIZE     86
#define TK_SST_TRIGGER          87
#define TK_NK_COLON             88
#define TK_TABLE                89
#define TK_NK_LP                90
#define TK_NK_RP                91
#define TK_STABLE               92
#define TK_ADD                  93
#define TK_COLUMN               94
#define TK_MODIFY               95
#define TK_RENAME               96
#define TK_TAG                  97
#define TK_SET                  98
#define TK_NK_EQ                99
#define TK_USING                100
#define TK_TAGS                 101
#define TK_COMMENT              102
#define TK_BOOL                 103
#define TK_TINYINT              104
#define TK_SMALLINT             105
#define TK_INT                  106
#define TK_INTEGER              107
#define TK_BIGINT               108
#define TK_FLOAT                109
#define TK_DOUBLE               110
#define TK_BINARY               111
#define TK_TIMESTAMP            112
#define TK_NCHAR                113
#define TK_UNSIGNED             114
#define TK_JSON                 115
#define TK_VARCHAR              116
#define TK_MEDIUMBLOB           117
#define TK_BLOB                 118
#define TK_VARBINARY            119
#define TK_DECIMAL              120
#define TK_MAX_DELAY            121
#define TK_WATERMARK            122
#define TK_ROLLUP               123
#define TK_TTL                  124
#define TK_SMA                  125
#define TK_FIRST                126
#define TK_LAST                 127
#define TK_SHOW                 128
#define TK_DATABASES            129
#define TK_TABLES               130
#define TK_STABLES              131
#define TK_MNODES               132
#define TK_MODULES              133
#define TK_QNODES               134
#define TK_FUNCTIONS            135
#define TK_INDEXES              136
#define TK_ACCOUNTS             137
#define TK_APPS                 138
#define TK_CONNECTIONS          139
#define TK_LICENCES             140
#define TK_GRANTS               141
#define TK_QUERIES              142
#define TK_SCORES               143
#define TK_TOPICS               144
#define TK_VARIABLES            145
#define TK_BNODES               146
#define TK_SNODES               147
#define TK_CLUSTER              148
#define TK_TRANSACTIONS         149
#define TK_DISTRIBUTED          150
#define TK_CONSUMERS            151
#define TK_SUBSCRIPTIONS        152
#define TK_VNODES               153
#define TK_LIKE                 154
#define TK_INDEX                155
#define TK_FUNCTION             156
#define TK_INTERVAL             157
#define TK_TOPIC                158
#define TK_AS                   159
#define TK_WITH                 160
#define TK_META                 161
#define TK_CONSUMER             162
#define TK_GROUP                163
#define TK_DESC                 164
#define TK_DESCRIBE             165
#define TK_RESET                166
#define TK_QUERY                167
#define TK_CACHE                168
#define TK_EXPLAIN              169
#define TK_ANALYZE              170
#define TK_VERBOSE              171
#define TK_NK_BOOL              172
#define TK_RATIO                173
#define TK_NK_FLOAT             174
#define TK_OUTPUTTYPE           175
#define TK_AGGREGATE            176
#define TK_BUFSIZE              177
#define TK_STREAM               178
#define TK_INTO                 179
#define TK_TRIGGER              180
#define TK_AT_ONCE              181
#define TK_WINDOW_CLOSE         182
#define TK_IGNORE               183
#define TK_EXPIRED              184
#define TK_KILL                 185
#define TK_CONNECTION           186
#define TK_TRANSACTION          187
#define TK_BALANCE              188
#define TK_VGROUP               189
#define TK_MERGE                190
#define TK_REDISTRIBUTE         191
#define TK_SPLIT                192
#define TK_DELETE               193
#define TK_INSERT               194
#define TK_NULL                 195
#define TK_NK_QUESTION          196
#define TK_NK_ARROW             197
#define TK_ROWTS                198
#define TK_TBNAME               199
#define TK_QSTART               200
#define TK_QEND                 201
#define TK_QDURATION            202
#define TK_WSTART               203
#define TK_WEND                 204
#define TK_WDURATION            205
#define TK_CAST                 206
#define TK_NOW                  207
#define TK_TODAY                208
#define TK_TIMEZONE             209
#define TK_CLIENT_VERSION       210
#define TK_SERVER_VERSION       211
#define TK_SERVER_STATUS        212
#define TK_CURRENT_USER         213
#define TK_COUNT                214
#define TK_LAST_ROW             215
#define TK_BETWEEN              216
#define TK_IS                   217
#define TK_NK_LT                218
#define TK_NK_GT                219
#define TK_NK_LE                220
#define TK_NK_GE                221
#define TK_NK_NE                222
#define TK_MATCH                223
#define TK_NMATCH               224
#define TK_CONTAINS             225
#define TK_IN                   226
#define TK_JOIN                 227
#define TK_INNER                228
#define TK_SELECT               229
#define TK_DISTINCT             230
#define TK_WHERE                231
#define TK_PARTITION            232
#define TK_BY                   233
#define TK_SESSION              234
#define TK_STATE_WINDOW         235
#define TK_SLIDING              236
#define TK_FILL                 237
#define TK_VALUE                238
#define TK_NONE                 239
#define TK_PREV                 240
#define TK_LINEAR               241
#define TK_NEXT                 242
#define TK_HAVING               243
#define TK_RANGE                244
#define TK_EVERY                245
#define TK_ORDER                246
#define TK_SLIMIT               247
#define TK_SOFFSET              248
#define TK_LIMIT                249
#define TK_OFFSET               250
#define TK_ASC                  251
#define TK_NULLS                252
#define TK_ABORT                253
#define TK_AFTER                254
#define TK_ATTACH               255
#define TK_BEFORE               256
#define TK_BEGIN                257
#define TK_BITAND               258
#define TK_BITNOT               259
#define TK_BITOR                260
#define TK_BLOCKS               261
#define TK_CHANGE               262
#define TK_COMMA                263
#define TK_COMPACT              264
#define TK_CONCAT               265
#define TK_CONFLICT             266
#define TK_COPY                 267
#define TK_DEFERRED             268
#define TK_DELIMITERS           269
#define TK_DETACH               270
#define TK_DIVIDE               271
#define TK_DOT                  272
#define TK_EACH                 273
#define TK_END                  274
#define TK_FAIL                 275
#define TK_FILE                 276
#define TK_FOR                  277
#define TK_GLOB                 278
#define TK_ID                   279
#define TK_IMMEDIATE            280
#define TK_IMPORT               281
#define TK_INITIALLY            282
#define TK_INSTEAD              283
#define TK_ISNULL               284
#define TK_KEY                  285
#define TK_NK_BITNOT            286
#define TK_NK_SEMI              287
#define TK_NOTNULL              288
#define TK_OF                   289
#define TK_PLUS                 290
#define TK_PRIVILEGE            291
#define TK_RAISE                292
#define TK_REPLACE              293
#define TK_RESTRICT             294
#define TK_ROW                  295
#define TK_SEMI                 296
#define TK_STAR                 297
#define TK_STATEMENT            298
#define TK_STRING               299
#define TK_TIMES                300
#define TK_UPDATE               301
#define TK_VALUES               302
#define TK_VARIABLE             303
#define TK_VIEW                 304
#define TK_WAL                  305

#define TK_NK_SPACE   300
#define TK_NK_COMMENT 301
#define TK_NK_ILLEGAL 302
#define TK_NK_HEX     303  // hex number  0x123
#define TK_NK_OCT     304  // oct number
#define TK_NK_BIN     305  // bin format data 0b111

#define TK_NK_NIL 65535

#endif /*_TD_COMMON_TOKEN_H_*/
