/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 454
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  ENullOrder yy153;
  SNode* yy164;
  bool yy193;
  SAlterOption yy213;
  EOrder yy238;
  int32_t yy512;
  int64_t yy577;
  SToken yy593;
  EFillMode yy638;
  SNodeList* yy648;
  EOperatorType yy656;
  int8_t yy687;
  SDataType yy720;
  EJoinType yy868;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             704
#define YYNRULE              535
#define YYNTOKEN             319
#define YY_MAX_SHIFT         703
#define YY_MIN_SHIFTREDUCE   1044
#define YY_MAX_SHIFTREDUCE   1578
#define YY_ERROR_ACTION      1579
#define YY_ACCEPT_ACTION     1580
#define YY_NO_ACTION         1581
#define YY_MIN_REDUCE        1582
#define YY_MAX_REDUCE        2116
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2619)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  2034,  453, 1932,  454, 1617,  576,  158,  461, 1919,  454,
 /*    10 */  1617, 1688,   43,   41, 1509,  348, 1847,  557, 1844, 1915,
 /*    20 */   357, 2087, 1360,   36,   35, 1932, 2031,   42,   40,   39,
 /*    30 */    38,   37, 1950, 1439, 2092, 1358,  556,  174, 1386,   95,
 /*    40 */   572, 2088,  558, 1385,  168, 1901, 1077,  609, 1911, 1917,
 /*    50 */   340, 1387, 2092,  132,  593, 1950, 2087, 1434, 1094,  603,
 /*    60 */  1093, 1727,   16,  610, 1649,  329, 1833,  121, 1901, 1366,
 /*    70 */   609, 1931, 2091,  211,  491, 1966, 2088, 2090,   98, 1933,
 /*    80 */   613, 1935, 1936,  608, 1735,  603, 1081, 1082, 1095,  592,
 /*    90 */   171,  592, 2019,   62, 1931,   12,  351, 2015, 1966,  349,
 /*   100 */  1605,   98, 1933,  613, 1935, 1936,  608,  156,  603,   58,
 /*   110 */   176,  134, 1604,  143, 1990, 2019, 1737,  700, 2045,  351,
 /*   120 */  2015,   42,   40,   39,   38,   37,  593, 1568,  507,  506,
 /*   130 */   505, 1441, 1442,   39,   38,   37,  128,  501,  593,  121,
 /*   140 */   438,  500,  499, 1901,   43,   41,  496,  498,  504, 1245,
 /*   150 */  1246,   52,  357,  497, 1360, 1901, 1735, 1932,  362, 1415,
 /*   160 */  1424, 1780, 1782, 2091,   46, 1439,  111, 1358, 1735,  110,
 /*   170 */   109,  108,  107,  106,  105,  104,  103,  102, 1361,  159,
 /*   180 */  1359, 1594, 1297, 1298,   58, 1575,  402, 1950, 1726, 1434,
 /*   190 */   470,  395,  257,  394,   16,  572,  190,  189,  646, 1915,
 /*   200 */  1901, 1366,  609, 1364, 1365, 1603, 1414, 1417, 1418, 1419,
 /*   210 */  1420, 1421, 1422, 1423,  605,  601, 1432, 1433, 1435, 1436,
 /*   220 */  1437, 1438, 1440, 1443,    2,  317, 1931,   12, 1911, 1917,
 /*   230 */  1966,   33,  274,   98, 1933,  613, 1935, 1936,  608,  603,
 /*   240 */   603,  316,  552, 1383, 1385,  171,  168, 2019, 1901,  700,
 /*   250 */   432,  351, 2015,  443,   36,   35,  177,   78,   42,   40,
 /*   260 */    39,   38,   37, 1441, 1442,  258, 1388, 1919, 1834, 1386,
 /*   270 */   416,  127,  444, 2046, 1920,  418,   43,   41, 1915, 1574,
 /*   280 */  1730,  507,  506,  505,  357, 1915, 1360, 1888,   58,  128,
 /*   290 */   501, 1415, 1424,  569,  500,  499,  360, 1439, 1163, 1358,
 /*   300 */   498,  504,  592,   58,  156,   83,  497, 1911, 1917,  352,
 /*   310 */  1361,  177, 1359, 1737, 1911, 1917,  458,  330,  603,   58,
 /*   320 */   363, 1434, 1383,  131, 1513,  603,   16, 1385,  156,  406,
 /*   330 */  1385,  177, 1165, 1366,  379, 1364, 1365, 1737, 1414, 1417,
 /*   340 */  1418, 1419, 1420, 1421, 1422, 1423,  605,  601, 1432, 1433,
 /*   350 */  1435, 1436, 1437, 1438, 1440, 1443,    2,  442,    9,   12,
 /*   360 */   437,  436,  435,  434,  431,  430,  429,  428,  427,  423,
 /*   370 */   422,  421,  420,  331,  413,  412,  411,   46,  408,  407,
 /*   380 */   328,  700,  571,  172, 2027, 2028, 1449,  129, 2032, 1384,
 /*   390 */   593,  212, 1385,   36,   35, 1441, 1442,   42,   40,   39,
 /*   400 */    38,   37, 2092,  179,  593,  163, 2087,  235,   43,   41,
 /*   410 */  1444,  487,  483,  479,  475,  209,  357,  400, 1360,  560,
 /*   420 */  1735, 2034, 2091, 1415, 1424,  547, 2088, 2089,   25, 1439,
 /*   430 */  1787, 1358, 1582, 1787, 1735,  177,  638,  350, 1787, 1712,
 /*   440 */   361,    9, 1361,    7, 1359,  326, 1785, 2030,   47, 1785,
 /*   450 */   177,    9,   79, 1434, 1785,  207,  120,  119,  118,  117,
 /*   460 */   116,  115,  114,  113,  112, 1366,  177, 1364, 1365, 1416,
 /*   470 */  1414, 1417, 1418, 1419, 1420, 1421, 1422, 1423,  605,  601,
 /*   480 */  1432, 1433, 1435, 1436, 1437, 1438, 1440, 1443,    2,   11,
 /*   490 */    10,   44, 1781, 1782,  265,  266,  512,   36,   35, 1950,
 /*   500 */  1602,   42,   40,   39,   38,   37,  593,  551,  553,  548,
 /*   510 */   557,  522,  452,  700, 2087,  456,  391,  264, 1366,  401,
 /*   520 */   206,  200, 1094,  205, 1093,  225,  466, 1441, 1442,  556,
 /*   530 */   174, 1416,  593,  658, 2088,  558, 1735,  393,  389,  515,
 /*   540 */    43,   41,  198, 1901,  509,  410,  644,  550,  357,  224,
 /*   550 */  1360,  322, 1095, 1932,  319, 1415, 1424,  582,  569,  580,
 /*   560 */   593, 1439, 1735, 1358,  593,  147,  146,  641,  640,  639,
 /*   570 */   595,  569, 1991,  424, 1361, 1470, 1359,  425, 1337, 1338,
 /*   580 */   503,  502, 1601, 1950, 1482, 1434,   64,  186,  131,   63,
 /*   590 */  1735,  607, 1535, 1468, 1735,  177, 1901, 1366,  609, 1364,
 /*   600 */  1365,  131, 1414, 1417, 1418, 1419, 1420, 1421, 1422, 1423,
 /*   610 */   605,  601, 1432, 1433, 1435, 1436, 1437, 1438, 1440, 1443,
 /*   620 */     2,  569, 1931,   44,   75, 1901, 1966,   74, 1724,  307,
 /*   630 */  1933,  613, 1935, 1936,  608,  606,  603,  594, 1984, 1387,
 /*   640 */   544, 1533, 1534, 1536, 1537,  700,   30, 1469,  173, 2027,
 /*   650 */  2028,  131,  129, 2032,  460,  133, 1475,  456, 1990, 1441,
 /*   660 */  1442,  255, 2027,  568, 1600,  122,  567, 1599,  593, 2087,
 /*   670 */    36,   35,   43,   41,   42,   40,   39,   38,   37,  593,
 /*   680 */   357,  364, 1360,   89,  556,  174,  576, 1415, 1424, 2088,
 /*   690 */   558,  227,  468, 1439, 1765, 1358,   36,   35, 1735, 1845,
 /*   700 */    42,   40,   39,   38,   37, 1728, 1361, 1901, 1359, 1735,
 /*   710 */  1901,  175, 2027, 2028, 1598,  129, 2032, 1434,   32,  355,
 /*   720 */  1463, 1464, 1465, 1466, 1467, 1471, 1472, 1473, 1474, 1366,
 /*   730 */  1720, 1364, 1365, 1932, 1414, 1417, 1418, 1419, 1420, 1421,
 /*   740 */  1422, 1423,  605,  601, 1432, 1433, 1435, 1436, 1437, 1438,
 /*   750 */  1440, 1443,    2, 1597,   29,   12,  170, 1901, 1545,  593,
 /*   760 */    36,   35,   78, 1950,   42,   40,   39,   38,   37, 1774,
 /*   770 */  1360,  610,  469,  593, 1506,  593, 1901,  700,  609, 1829,
 /*   780 */   257, 1596,  403, 1358, 1525, 1731, 1732,   31,  139, 1735,
 /*   790 */   182, 1441, 1442,   36,   35,  404, 1901,   42,   40,   39,
 /*   800 */    38,   37, 1931, 1735, 1829, 1735, 1966,  671,  669,   99,
 /*   810 */  1933,  613, 1935, 1936,  608,  184,  603, 1366, 1593, 1415,
 /*   820 */  1424, 1646,  521, 2019, 1901,   36,   35, 2018, 2015,   42,
 /*   830 */    40,   39,   38,   37,  597,  519, 1991,  517, 1361, 1722,
 /*   840 */  1359, 1203,  635,  634,  633, 1207,  632, 1209, 1210,  631,
 /*   850 */  1212,  628, 1718, 1218,  625, 1220, 1221,  622,  619,  230,
 /*   860 */  1843, 1901,  312, 1364, 1365,  700, 1414, 1417, 1418, 1419,
 /*   870 */  1420, 1421, 1422, 1423,  605,  601, 1432, 1433, 1435, 1436,
 /*   880 */  1437, 1438, 1440, 1443,    2,  677,  676,  675,  674,  367,
 /*   890 */  1385,  673,  672,  135,  667,  666,  665,  664,  663,  662,
 /*   900 */   661,  660,  149,  656,  655,  654,  366,  365,  651,  650,
 /*   910 */   649,  648,  647,  157,  593, 1713, 1592,  604,  292,  396,
 /*   920 */  1932, 1388, 1787, 1591, 1590, 1589, 1361,  533, 1359, 1588,
 /*   930 */  2034, 1587,  290,   67, 1586, 1842,   66,  312, 1786, 1585,
 /*   940 */   637,   36,   35, 1932, 1735,   42,   40,   39,   38,   37,
 /*   950 */  1950, 1364, 1365,  194,  449,  447, 2029,  593,  610, 1901,
 /*   960 */   537,    6,  593, 1901, 2087,  609, 1901, 1901, 1901, 1711,
 /*   970 */   573, 1388, 1901, 1950, 1901,  269,  470, 1901,  155, 2093,
 /*   980 */   174,  610, 1901, 1829, 2088,  558, 1901, 1735,  609, 1931,
 /*   990 */    58,  334, 1735, 1966,  188,  561,   98, 1933,  613, 1935,
 /*  1000 */  1936,  608,  156,  603,  593,  659,  642, 1705, 2107, 1778,
 /*  1010 */  2019, 1738, 1931, 1505,  351, 2015, 1966,  588, 1816,   98,
 /*  1020 */  1933,  613, 1935, 1936,  608, 2053,  603,  564,   97, 1416,
 /*  1030 */   646, 2107, 1710, 2019, 1735,  354,  353,  351, 2015,  643,
 /*  1040 */   226, 1932, 1778,  286,  532, 1374, 1765,  593, 2081, 1081,
 /*  1050 */  1082,  593,  335,  644,  333,  332, 1439,  493, 1367,   65,
 /*  1060 */   590,  495,  183,  495,  591,   72,   71,  399, 2039, 1502,
 /*  1070 */   181, 1950,  147,  146,  641,  640,  639, 1735, 1369,  610,
 /*  1080 */  1434, 1735, 1689,  494, 1901,  494,  609, 1636,  315,   48,
 /*  1090 */     3,  387, 1366,  385,  381,  377,  374,  371,   80,  319,
 /*  1100 */  1932,  233,  582,  593,  580,  137,  123,   73,  600,  508,
 /*  1110 */  1931,  145,  234,   60, 1966, 1595,  275,   98, 1933,  613,
 /*  1120 */  1935, 1936,  608, 1583,  603, 1577, 1578,   11,   10, 2107,
 /*  1130 */  1950, 2019,  239, 1735, 1629,  351, 2015,  177,  610,  644,
 /*  1140 */   599,   81, 1368, 1901,  111,  609, 2038,  110,  109,  108,
 /*  1150 */   107,  106,  105,  104,  103,  102,  510,   45,  147,  146,
 /*  1160 */   641,  640,  639, 1502,   51,  217, 1532,  419,  215, 1931,
 /*  1170 */  1627,  219,  221, 1966,  218,  220,   98, 1933,  613, 1935,
 /*  1180 */  1936,  608,  262,  603,  223,  241, 1932,  222, 1994,  652,
 /*  1190 */  2019,   50,  513,  140,  351, 2015,  536,  144,  145,   60,
 /*  1200 */  1123, 1375, 2059, 1370,   45, 1922,  653,  252, 1580,  545,
 /*  1210 */  1308, 1143,  210,  562,  246, 1932, 1950,   45,  617, 1951,
 /*  1220 */   144,  368,  145, 1372,  610,  124, 1378, 1380, 1141, 1901,
 /*  1230 */   144,  609, 1838, 1618, 1124,  267, 1775, 2049,  601, 1432,
 /*  1240 */  1433, 1435, 1436, 1437, 1438, 1950,  585,  565,  570, 1460,
 /*  1250 */   271, 1196, 1476,  610, 1924, 1931,  254, 1425, 1901, 1966,
 /*  1260 */   609,  251,   98, 1933,  613, 1935, 1936,  608, 1623,  603,
 /*  1270 */   285, 1224,  372, 1228, 1992, 1235, 2019, 1932, 1233,   94,
 /*  1280 */   351, 2015,    1,  148, 1931,    4,  378, 1371, 1966,   91,
 /*  1290 */   373,   98, 1933,  613, 1935, 1936,  608,  327,  603,  282,
 /*  1300 */  1324,  187,  405,  596, 1932, 2019, 1388, 1950,  414,  351,
 /*  1310 */  2015, 1839,  409,  537, 1383,  610,  695, 2087,  440,  426,
 /*  1320 */  1901, 1831,  609,  445,  446,  191,  448,  450,  439,  433,
 /*  1330 */   441, 1932, 2093,  174, 1950, 1389,  451, 2088,  558,  459,
 /*  1340 */  1391,  197,  610,  463, 1390,  199, 1931, 1901, 1932,  609,
 /*  1350 */  1966,  462,  464,   99, 1933,  613, 1935, 1936,  608, 1392,
 /*  1360 */   603, 1950,  465,  202,  204,  467,   76, 2019,   77,  610,
 /*  1370 */   471,  598, 2015,  611, 1901,  490,  609, 1966, 1950, 1097,
 /*  1380 */    99, 1933,  613, 1935, 1936,  608,  610,  603,  208,  488,
 /*  1390 */   489, 1901,  100,  609, 2019,  524,  575,  492,  321, 2015,
 /*  1400 */  1931, 1725, 1932,  318, 1966,  283,  214,  160, 1933,  613,
 /*  1410 */  1935, 1936,  608, 1721,  603, 1878,  216, 1931,  527,  546,
 /*  1420 */   534, 1966,  528,  150,  161, 1933,  613, 1935, 1936,  608,
 /*  1430 */   151,  603, 1950,  228, 1723, 1719,  152,  537,  153,  231,
 /*  1440 */   610, 2087,  526,  531, 2050, 1901,  579,  609,  538, 2056,
 /*  1450 */   370, 2065, 2060,  541, 2064,    5, 2093,  174, 1932,  543,
 /*  1460 */   341, 2088,  558,  549,  369,  555,  542,  540,  248,  237,
 /*  1470 */   240, 1931, 2041,  245,  539, 1966,  559, 2108,   99, 1933,
 /*  1480 */   613, 1935, 1936,  608,  342,  603,  250,  249, 1950,  164,
 /*  1490 */   566,  537, 2019,  247,  563, 2087,  610, 2016, 1502, 1387,
 /*  1500 */   130, 1901, 1932,  609,  345,  537, 2035,  141,  525, 2087,
 /*  1510 */  2093,  174, 2110,  574,  259, 2088,  558,  577, 1932,  142,
 /*  1520 */   586, 2086,  578, 1877, 2093,  174, 1736, 1931, 1849, 2088,
 /*  1530 */   558, 1966, 1950,  583,  160, 1933,  613, 1935, 1936,  608,
 /*  1540 */   610,  603,  253,  347,   86, 1901,  284,  609, 1950,  537,
 /*  1550 */    88,   57, 2000, 2087,   90, 1779,  610,  615, 1706,  278,
 /*  1560 */   696, 1901,  587,  609,  301,  697,  287,  699, 2093,  174,
 /*  1570 */   311, 1931,  291, 2088,  558, 1966, 2057,   49,  300, 1933,
 /*  1580 */   613, 1935, 1936,  608,  310,  603, 1932, 1931,  309,  289,
 /*  1590 */  1895, 1966, 1894,   69,  161, 1933,  613, 1935, 1936,  608,
 /*  1600 */  1893,  603, 1892, 1932,   70, 1889,  375,  376, 1352, 1353,
 /*  1610 */   180,  380, 1887,  382,  383,  384, 1950, 1886,  386, 1885,
 /*  1620 */   388,  346,  554, 1884,  610,  390, 1883, 1327,  392, 1901,
 /*  1630 */  1326,  609, 1860, 1950, 1859,  397,  398, 1858, 1857, 1824,
 /*  1640 */  1288,  607,  415,  136, 1820, 1819, 1901, 2109,  609, 1823,
 /*  1650 */  1821, 1822, 1818, 1817, 1815, 1931, 1814, 1932, 1813, 1966,
 /*  1660 */   185, 1812,  308, 1933,  613, 1935, 1936,  608,  417,  603,
 /*  1670 */  1811, 1810, 1931, 1932, 1809, 1808, 1966, 1807, 1806,  307,
 /*  1680 */  1933,  613, 1935, 1936,  608, 1805,  603, 1950, 1985, 1804,
 /*  1690 */  1803, 1802,  356, 1801, 1800,  610,  125,  138, 1796, 1795,
 /*  1700 */  1901, 1799,  609, 1950, 1798, 1797, 1794, 1793,  358, 1792,
 /*  1710 */  1290,  610,  169,  455, 1171, 1651, 1901, 1932,  609, 1791,
 /*  1720 */  1790, 1789, 1788,  192, 1650,  193, 1931, 1648, 1614,  195,
 /*  1730 */  1966, 1084, 1083,  308, 1933,  613, 1935, 1936,  608, 1613,
 /*  1740 */   603,  457, 1931,  196, 1932, 1873, 1966, 1950, 1867,  308,
 /*  1750 */  1933,  613, 1935, 1936,  608,  610,  603, 1856,  203, 1855,
 /*  1760 */  1901, 1841,  609, 1714,  126,  201, 1647, 1645,  472,  474,
 /*  1770 */   473, 1932, 1643, 1116, 1950,  476,  477,  478, 1641,  480,
 /*  1780 */   482,  481,  610,  485,  484,  486,  523, 1901, 1639,  609,
 /*  1790 */  1966, 1626, 1625,  303, 1933,  613, 1935, 1936,  608, 1610,
 /*  1800 */   603, 1950, 1716, 1239,   59, 1715, 1238, 1160, 1162,  610,
 /*  1810 */   213, 1161, 1159, 1931, 1901, 1932,  609, 1966,  668, 1153,
 /*  1820 */   293, 1933,  613, 1935, 1936,  608, 1637,  603, 1158,  670,
 /*  1830 */  1155, 1154, 1630, 1152,  336,  337,  511, 1628,  338,  514,
 /*  1840 */  1931, 1609,  516, 1608, 1966, 1950,  518,  294, 1933,  613,
 /*  1850 */  1935, 1936,  608,  610,  603, 1607,  520,   24, 1901, 1932,
 /*  1860 */   609, 1344,  101, 1872, 1333, 1866,  529,  154, 1854, 1852,
 /*  1870 */  2092,   17,   53,   14,  530,   26,  236,  232, 1547, 1932,
 /*  1880 */    61,   56,  243,  535, 1931,  238, 1531,   18, 1966, 1950,
 /*  1890 */  1524,  295, 1933,  613, 1935, 1936,  608,  610,  603,  244,
 /*  1900 */    28,  162, 1901,  339,  609, 1922,   15,   19, 1562, 1950,
 /*  1910 */   242, 1561,   27,   82,  343, 1567, 1568,  610, 1566, 1565,
 /*  1920 */   344, 1499, 1901, 1498,  609,   55,  256,  165, 1931, 1853,
 /*  1930 */  1851, 1850, 1966,  581, 1342,  299, 1933,  613, 1935, 1936,
 /*  1940 */   608,   20,  603,  261, 1932, 1529,  263, 1341, 1931, 1848,
 /*  1950 */  1840,  268, 1966,   84,   85,  304, 1933,  613, 1935, 1936,
 /*  1960 */   608,   87,  603, 1921, 1932,  584,   91,  273,   21,   10,
 /*  1970 */   270,   54, 1451, 1376, 1950, 1407, 1450,    8,  166,  178,
 /*  1980 */   614, 1969,  610, 1429,  602,  636, 1427, 1901,   34,  609,
 /*  1990 */  1426,   13,   22,  616, 1950,  359, 1399,   23,  620, 1225,
 /*  2000 */   618,  621,  610, 1461, 1222, 1219,  623, 1901,  612,  609,
 /*  2010 */  1213,  624,  626, 1931,  627,  629, 1211, 1966, 1932,  630,
 /*  2020 */   296, 1933,  613, 1935, 1936,  608, 1217,  603, 1202, 1216,
 /*  2030 */  1215,   92, 1214, 1931, 1932,   93, 1234, 1966,   68,  276,
 /*  2040 */   305, 1933,  613, 1935, 1936,  608, 1230,  603, 1950, 1114,
 /*  2050 */   645, 1149, 1148, 1147, 1146, 1145,  610, 1144, 1142, 1169,
 /*  2060 */  1140, 1901, 1139,  609, 1950, 1138,  657, 1136, 1135,  277,
 /*  2070 */  1134, 1133,  610, 1132, 1131, 1130, 1129, 1901, 1932,  609,
 /*  2080 */  1166, 1164, 1126, 1120, 1125, 1122, 1644, 1931, 1121, 1119,
 /*  2090 */   678, 1966,  679, 1642,  297, 1933,  613, 1935, 1936,  608,
 /*  2100 */   682,  603,  680, 1931, 1640, 1932,  683, 1966, 1950,  684,
 /*  2110 */   306, 1933,  613, 1935, 1936,  608,  610,  603,  686,  687,
 /*  2120 */   688, 1901, 1638,  609,  690,  691,  692, 1624, 1606,  694,
 /*  2130 */  1074,  280, 1932,  698,  701, 1950, 1362,  288,  702, 1581,
 /*  2140 */  1581, 1581, 1581,  610, 1581, 1581, 1581, 1931, 1901, 1581,
 /*  2150 */   609, 1966, 1581, 1581,  298, 1933,  613, 1935, 1936,  608,
 /*  2160 */  1581,  603, 1950, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
 /*  2170 */   610, 1581, 1581, 1581, 1931, 1901, 1932,  609, 1966, 1581,
 /*  2180 */  1581,  313, 1933,  613, 1935, 1936,  608, 1581,  603, 1581,
 /*  2190 */  1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
 /*  2200 */  1581, 1931, 1581, 1581, 1581, 1966, 1950, 1581,  314, 1933,
 /*  2210 */   613, 1935, 1936,  608,  610,  603, 1581, 1581, 1581, 1901,
 /*  2220 */  1932,  609, 1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
 /*  2230 */  1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
 /*  2240 */  1932, 1581, 1581, 1581, 1581, 1931, 1581, 1581, 1581, 1966,
 /*  2250 */  1950, 1581, 1944, 1933,  613, 1935, 1936,  608,  610,  603,
 /*  2260 */  1581, 1581, 1581, 1901, 1581,  609, 1581, 1581, 1581, 1581,
 /*  2270 */  1950, 1581, 1581, 1581, 1581, 1581, 1581, 1581,  610, 1581,
 /*  2280 */  1581, 1581, 1581, 1901, 1581,  609, 1581, 1581, 1581, 1931,
 /*  2290 */  1581, 1581, 1581, 1966, 1581, 1581, 1943, 1933,  613, 1935,
 /*  2300 */  1936,  608, 1581,  603, 1581, 1932, 1581, 1581, 1581, 1931,
 /*  2310 */  1581, 1581, 1581, 1966, 1581, 1581, 1942, 1933,  613, 1935,
 /*  2320 */  1936,  608, 1581,  603, 1581, 1932, 1581, 1581, 1581, 1581,
 /*  2330 */  1581, 1581, 1581, 1581, 1581, 1950, 1581, 1581, 1581, 1581,
 /*  2340 */  1581, 1581, 1581,  610, 1581, 1581, 1581, 1581, 1901, 1581,
 /*  2350 */   609, 1581, 1581, 1581, 1581, 1950, 1581, 1581, 1581, 1581,
 /*  2360 */  1581, 1581, 1581,  610, 1581, 1581, 1581, 1581, 1901, 1581,
 /*  2370 */   609, 1581, 1581, 1581, 1931, 1581, 1581, 1581, 1966, 1932,
 /*  2380 */  1581,  323, 1933,  613, 1935, 1936,  608, 1581,  603, 1581,
 /*  2390 */  1581, 1581, 1581, 1581, 1931, 1932, 1581, 1581, 1966, 1581,
 /*  2400 */  1581,  324, 1933,  613, 1935, 1936,  608, 1581,  603, 1950,
 /*  2410 */  1581, 1581, 1581, 1581, 1581, 1581, 1581,  610, 1581, 1581,
 /*  2420 */  1581, 1581, 1901, 1581,  609, 1950, 1581, 1581, 1581, 1581,
 /*  2430 */  1581, 1581, 1581,  610, 1581, 1581, 1581, 1581, 1901, 1932,
 /*  2440 */   609, 1581, 1581, 1581, 1581, 1581, 1581, 1581, 1931, 1581,
 /*  2450 */  1581, 1581, 1966,  703, 1581,  320, 1933,  613, 1935, 1936,
 /*  2460 */   608, 1581,  603, 1581, 1931, 1581, 1932,  281, 1966, 1950,
 /*  2470 */  1581,  325, 1933,  613, 1935, 1936,  608,  610,  603, 1581,
 /*  2480 */  1581,  167, 1901, 1581,  609, 1581, 1581,  693,  689,  685,
 /*  2490 */   681,  279, 1581, 1581, 1581, 1581, 1950, 1581, 1581, 1581,
 /*  2500 */  1581, 1581, 1581, 1581,  610, 1581, 1581, 1581,  611, 1901,
 /*  2510 */  1581,  609, 1966, 1581, 1581,  303, 1933,  613, 1935, 1936,
 /*  2520 */   608, 1581,  603, 1581, 1581, 1581, 1581, 1581,   96, 1581,
 /*  2530 */  1581,  272, 1581, 1581, 1581, 1931, 1581, 1581, 1581, 1966,
 /*  2540 */  1581, 1581,  302, 1933,  613, 1935, 1936,  608, 1581,  603,
 /*  2550 */  1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
 /*  2560 */  1581, 1581, 1581, 1581,  589, 1581, 1581, 1581, 1581, 1581,
 /*  2570 */  1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
 /*  2580 */  1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
 /*  2590 */  1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,  260,
 /*  2600 */  1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581, 1581,
 /*  2610 */  1581, 1581, 1581, 1581, 1581, 1581, 1331, 1581,  229,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   397,  326,  322,  328,  329,  367,  336,  326,  354,  328,
 /*    10 */   329,  341,   12,   13,   14,  377,    0,  424,  380,  365,
 /*    20 */    20,  428,   22,    8,    9,  322,  423,   12,   13,   14,
 /*    30 */    15,   16,  352,   33,    3,   35,  443,  444,   20,  333,
 /*    40 */   360,  448,  449,   20,  352,  365,    4,  367,  394,  395,
 /*    50 */   396,   20,  424,  347,  330,  352,  428,   57,   20,  405,
 /*    60 */    22,  355,   62,  360,    0,  373,  374,  343,  365,   69,
 /*    70 */   367,  391,  444,   35,  350,  395,  448,  449,  398,  399,
 /*    80 */   400,  401,  402,  403,  360,  405,   44,   45,   50,   20,
 /*    90 */   410,   20,  412,    4,  391,   95,  416,  417,  395,  344,
 /*   100 */   322,  398,  399,  400,  401,  402,  403,  352,  405,   95,
 /*   110 */   430,  408,  322,  410,  411,  412,  361,  117,  438,  416,
 /*   120 */   417,   12,   13,   14,   15,   16,  330,   96,   64,   65,
 /*   130 */    66,  131,  132,   14,   15,   16,   72,   73,  330,  343,
 /*   140 */    79,   77,   78,  365,   12,   13,  350,   83,   84,  131,
 /*   150 */   132,  343,   20,   89,   22,  365,  360,  322,  363,  159,
 /*   160 */   160,  366,  367,    3,   95,   33,   21,   35,  360,   24,
 /*   170 */    25,   26,   27,   28,   29,   30,   31,   32,  178,  321,
 /*   180 */   180,  323,  159,  160,   95,  170,  330,  352,  354,   57,
 /*   190 */    61,  177,  161,  179,   62,  360,  135,  136,   61,  365,
 /*   200 */   365,   69,  367,  203,  204,  322,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  369,  391,   95,  394,  395,
 /*   230 */   395,  413,  414,  398,  399,  400,  401,  402,  403,  405,
 /*   240 */   405,   18,   20,   20,   20,  410,  352,  412,  365,  117,
 /*   250 */    27,  416,  417,   30,    8,    9,  242,  335,   12,   13,
 /*   260 */    14,   15,   16,  131,  132,   57,   20,  354,  374,   20,
 /*   270 */    47,  349,   49,  438,  354,   52,   12,   13,  365,  264,
 /*   280 */   358,   64,   65,   66,   20,  365,   22,    0,   95,   72,
 /*   290 */    73,  159,  160,  330,   77,   78,  344,   33,   35,   35,
 /*   300 */    83,   84,   20,   95,  352,   97,   89,  394,  395,  396,
 /*   310 */   178,  242,  180,  361,  394,  395,   14,   94,  405,   95,
 /*   320 */   344,   57,   20,  360,   14,  405,   62,   20,  352,  106,
 /*   330 */    20,  242,   69,   69,   47,  203,  204,  361,  206,  207,
 /*   340 */   208,  209,  210,  211,  212,  213,  214,  215,  216,  217,
 /*   350 */   218,  219,  220,  221,  222,  223,  224,  134,  226,   95,
 /*   360 */   137,  138,  139,  140,  141,  142,  143,  144,  145,  146,
 /*   370 */   147,  148,  149,  150,  151,  152,  153,   95,  155,  156,
 /*   380 */   157,  117,  419,  420,  421,  422,   14,  424,  425,   20,
 /*   390 */   330,   33,   20,    8,    9,  131,  132,   12,   13,   14,
 /*   400 */    15,   16,  424,  343,  330,   47,  428,  161,   12,   13,
 /*   410 */    14,   53,   54,   55,   56,   57,   20,  343,   22,  259,
 /*   420 */   360,  397,  444,  159,  160,  164,  448,  449,   43,   33,
 /*   430 */   352,   35,    0,  352,  360,  242,  106,  359,  352,    0,
 /*   440 */   359,  226,  178,  228,  180,  359,  368,  423,   95,  368,
 /*   450 */   242,  226,   94,   57,  368,   97,   24,   25,   26,   27,
 /*   460 */    28,   29,   30,   31,   32,   69,  242,  203,  204,  159,
 /*   470 */   206,  207,  208,  209,  210,  211,  212,  213,  214,  215,
 /*   480 */   216,  217,  218,  219,  220,  221,  222,  223,  224,    1,
 /*   490 */     2,   95,  366,  367,  126,  127,    4,    8,    9,  352,
 /*   500 */   322,   12,   13,   14,   15,   16,  330,  360,  247,  248,
 /*   510 */   424,   19,  327,  117,  428,  330,  173,  126,   69,  343,
 /*   520 */   162,  163,   20,  165,   22,   33,  168,  131,  132,  443,
 /*   530 */   444,  159,  330,   69,  448,  449,  360,  194,  195,   47,
 /*   540 */    12,   13,  184,  365,   52,  343,  107,  400,   20,   57,
 /*   550 */    22,   62,   50,  322,  186,  159,  160,  189,  330,  191,
 /*   560 */   330,   33,  360,   35,  330,  126,  127,  128,  129,  130,
 /*   570 */   409,  330,  411,  343,  178,  158,  180,  343,  187,  188,
 /*   580 */   338,  339,  322,  352,   96,   57,   94,   57,  360,   97,
 /*   590 */   360,  360,  203,  104,  360,  242,  365,   69,  367,  203,
 /*   600 */   204,  360,  206,  207,  208,  209,  210,  211,  212,  213,
 /*   610 */   214,  215,  216,  217,  218,  219,  220,  221,  222,  223,
 /*   620 */   224,  330,  391,   95,   94,  365,  395,   97,  353,  398,
 /*   630 */   399,  400,  401,  402,  403,  404,  405,  406,  407,   20,
 /*   640 */   251,  252,  253,  254,  255,  117,  229,  158,  420,  421,
 /*   650 */   422,  360,  424,  425,  327,  408,  239,  330,  411,  131,
 /*   660 */   132,  420,  421,  422,  322,  424,  425,  322,  330,  428,
 /*   670 */     8,    9,   12,   13,   12,   13,   14,   15,   16,  330,
 /*   680 */    20,  343,   22,  333,  443,  444,  367,  159,  160,  448,
 /*   690 */   449,  345,  343,   33,  348,   35,    8,    9,  360,  380,
 /*   700 */    12,   13,   14,   15,   16,  355,  178,  365,  180,  360,
 /*   710 */   365,  420,  421,  422,  322,  424,  425,   57,  229,  230,
 /*   720 */   231,  232,  233,  234,  235,  236,  237,  238,  239,   69,
 /*   730 */   353,  203,  204,  322,  206,  207,  208,  209,  210,  211,
 /*   740 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   750 */   222,  223,  224,  322,    2,   95,  351,  365,   96,  330,
 /*   760 */     8,    9,  335,  352,   12,   13,   14,   15,   16,  364,
 /*   770 */    22,  360,  343,  330,    4,  330,  365,  117,  367,  360,
 /*   780 */   161,  322,   22,   35,   96,  358,  343,    2,  343,  360,
 /*   790 */   371,  131,  132,    8,    9,   35,  365,   12,   13,   14,
 /*   800 */    15,   16,  391,  360,  360,  360,  395,  338,  339,  398,
 /*   810 */   399,  400,  401,  402,  403,  371,  405,   69,  322,  159,
 /*   820 */   160,    0,   21,  412,  365,    8,    9,  416,  417,   12,
 /*   830 */    13,   14,   15,   16,  409,   34,  411,   36,  178,  353,
 /*   840 */   180,  108,  109,  110,  111,  112,  113,  114,  115,  116,
 /*   850 */   117,  118,  353,  120,  121,  122,  123,  124,  125,  353,
 /*   860 */   379,  365,  381,  203,  204,  117,  206,  207,  208,  209,
 /*   870 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   880 */   220,  221,  222,  223,  224,   64,   65,   66,   67,   68,
 /*   890 */    20,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   900 */    79,   80,   81,   82,   83,   84,   85,   86,   87,   88,
 /*   910 */    89,   90,   91,   18,  330,    0,  322,  353,   23,  383,
 /*   920 */   322,   20,  352,  322,  322,  322,  178,  343,  180,  322,
 /*   930 */   397,  322,   37,   38,  322,  379,   41,  381,  368,  322,
 /*   940 */   353,    8,    9,  322,  360,   12,   13,   14,   15,   16,
 /*   950 */   352,  203,  204,   58,   59,   60,  423,  330,  360,  365,
 /*   960 */   424,   39,  330,  365,  428,  367,  365,  365,  365,    0,
 /*   970 */   343,   20,  365,  352,  365,  343,   61,  365,  161,  443,
 /*   980 */   444,  360,  365,  360,  448,  449,  365,  360,  367,  391,
 /*   990 */    95,   37,  360,  395,  371,   43,  398,  399,  400,  401,
 /*  1000 */   402,  403,  352,  405,  330,  340,  362,  342,  410,  365,
 /*  1010 */   412,  361,  391,  243,  416,  417,  395,  343,    0,  398,
 /*  1020 */   399,  400,  401,  402,  403,  427,  405,   43,  133,  159,
 /*  1030 */    61,  410,    0,  412,  360,   12,   13,  416,  417,  362,
 /*  1040 */   127,  322,  365,  345,  387,   22,  348,  330,  427,   44,
 /*  1050 */    45,  330,   98,  107,  100,  101,   33,  103,   35,  106,
 /*  1060 */   343,  107,  161,  107,  343,  170,  171,  172,  240,  241,
 /*  1070 */   175,  352,  126,  127,  128,  129,  130,  360,   35,  360,
 /*  1080 */    57,  360,  341,  129,  365,  129,  367,    0,  193,   42,
 /*  1090 */    43,  196,   69,  198,  199,  200,  201,  202,  185,  186,
 /*  1100 */   322,   57,  189,  330,  191,   42,   43,  154,   62,   22,
 /*  1110 */   391,   43,  161,   43,  395,  323,  343,  398,  399,  400,
 /*  1120 */   401,  402,  403,    0,  405,  131,  132,    1,    2,  410,
 /*  1130 */   352,  412,   43,  360,    0,  416,  417,  242,  360,  107,
 /*  1140 */   117,   97,   35,  365,   21,  367,  427,   24,   25,   26,
 /*  1150 */    27,   28,   29,   30,   31,   32,   22,   43,  126,  127,
 /*  1160 */   128,  129,  130,  241,   96,   99,   96,  149,  102,  391,
 /*  1170 */     0,   99,   99,  395,  102,  102,  398,  399,  400,  401,
 /*  1180 */   402,  403,   43,  405,   99,   96,  322,  102,  410,   13,
 /*  1190 */   412,  161,   22,   43,  416,  417,  166,   43,   43,   43,
 /*  1200 */    35,  178,  375,  180,   43,   46,   13,  452,  319,  441,
 /*  1210 */    96,   35,  331,  261,  435,  322,  352,   43,   43,  352,
 /*  1220 */    43,  331,   43,  180,  360,   43,  203,  204,   35,  365,
 /*  1230 */    43,  367,  375,  329,   69,   96,  364,  375,  215,  216,
 /*  1240 */   217,  218,  219,  220,  221,  352,   96,  263,  426,  203,
 /*  1250 */    96,   96,   96,  360,   95,  391,  445,   96,  365,  395,
 /*  1260 */   367,  418,  398,  399,  400,  401,  402,  403,    0,  405,
 /*  1270 */    96,   96,  383,   96,  410,   96,  412,  322,   96,   95,
 /*  1280 */   416,  417,  429,   96,  391,  244,   47,  180,  395,  105,
 /*  1290 */   393,  398,  399,  400,  401,  402,  403,  392,  405,  385,
 /*  1300 */   176,   42,  372,  410,  322,  412,   20,  352,  370,  416,
 /*  1310 */   417,  375,  372,  424,   20,  360,   48,  428,  158,  330,
 /*  1320 */   365,  330,  367,   93,  337,  330,  330,  330,  370,  372,
 /*  1330 */   370,  322,  443,  444,  352,   20,  324,  448,  449,  324,
 /*  1340 */    20,  335,  360,  367,   20,  335,  391,  365,  322,  367,
 /*  1350 */   395,  389,  382,  398,  399,  400,  401,  402,  403,   20,
 /*  1360 */   405,  352,  384,  335,  335,  382,  335,  412,  335,  360,
 /*  1370 */   330,  416,  417,  391,  365,  324,  367,  395,  352,   51,
 /*  1380 */   398,  399,  400,  401,  402,  403,  360,  405,  335,  332,
 /*  1390 */   332,  365,  330,  367,  412,  192,  383,  352,  416,  417,
 /*  1400 */   391,  352,  322,  324,  395,  389,  352,  398,  399,  400,
 /*  1410 */   401,  402,  403,  352,  405,  365,  352,  391,  183,  250,
 /*  1420 */   330,  395,  388,  352,  398,  399,  400,  401,  402,  403,
 /*  1430 */   352,  405,  352,  333,  352,  352,  352,  424,  352,  333,
 /*  1440 */   360,  428,  390,  367,  375,  365,  249,  367,  439,  440,
 /*  1450 */   383,  434,  375,  365,  434,  256,  443,  444,  322,  365,
 /*  1460 */   365,  448,  449,  365,  383,  169,  258,  257,  432,  378,
 /*  1470 */   378,  391,  437,  436,  245,  395,  450,  451,  398,  399,
 /*  1480 */   400,  401,  402,  403,  265,  405,  393,  431,  352,  434,
 /*  1490 */   262,  424,  412,  433,  260,  428,  360,  417,  241,   20,
 /*  1500 */   360,  365,  322,  367,  382,  424,  397,  378,  383,  428,
 /*  1510 */   443,  444,  453,  330,  333,  448,  449,  365,  322,  378,
 /*  1520 */   163,  447,  365,  365,  443,  444,  360,  391,  365,  448,
 /*  1530 */   449,  395,  352,  365,  398,  399,  400,  401,  402,  403,
 /*  1540 */   360,  405,  446,  365,  333,  365,  348,  367,  352,  424,
 /*  1550 */   333,   95,  415,  428,   95,  365,  360,  356,  342,  333,
 /*  1560 */    36,  365,  376,  367,  346,  325,  330,  324,  443,  444,
 /*  1570 */   381,  391,  320,  448,  449,  395,  440,  386,  398,  399,
 /*  1580 */   400,  401,  402,  403,  346,  405,  322,  391,  346,  334,
 /*  1590 */     0,  395,    0,  185,  398,  399,  400,  401,  402,  403,
 /*  1600 */     0,  405,    0,  322,   42,    0,   35,  197,   35,   35,
 /*  1610 */    35,  197,    0,   35,   35,  197,  352,    0,  197,    0,
 /*  1620 */    35,  357,  442,    0,  360,   22,    0,  180,   35,  365,
 /*  1630 */   178,  367,    0,  352,    0,  174,  173,    0,    0,    0,
 /*  1640 */    46,  360,   35,   42,    0,    0,  365,  451,  367,    0,
 /*  1650 */     0,    0,    0,    0,    0,  391,    0,  322,    0,  395,
 /*  1660 */   149,    0,  398,  399,  400,  401,  402,  403,  149,  405,
 /*  1670 */     0,    0,  391,  322,    0,    0,  395,    0,    0,  398,
 /*  1680 */   399,  400,  401,  402,  403,    0,  405,  352,  407,    0,
 /*  1690 */     0,    0,  357,    0,    0,  360,   39,   42,    0,    0,
 /*  1700 */   365,    0,  367,  352,    0,    0,    0,    0,  357,    0,
 /*  1710 */    22,  360,   43,   46,   35,    0,  365,  322,  367,    0,
 /*  1720 */     0,    0,    0,   57,    0,   57,  391,    0,    0,   42,
 /*  1730 */   395,   14,   14,  398,  399,  400,  401,  402,  403,    0,
 /*  1740 */   405,   46,  391,   40,  322,    0,  395,  352,    0,  398,
 /*  1750 */   399,  400,  401,  402,  403,  360,  405,    0,  169,    0,
 /*  1760 */   365,    0,  367,    0,   39,   39,    0,    0,   35,   39,
 /*  1770 */    47,  322,    0,   63,  352,   35,   47,   39,    0,   35,
 /*  1780 */    39,   47,  360,   47,   35,   39,  391,  365,    0,  367,
 /*  1790 */   395,    0,    0,  398,  399,  400,  401,  402,  403,    0,
 /*  1800 */   405,  352,    0,   35,  104,    0,   22,   22,   35,  360,
 /*  1810 */   102,   35,   35,  391,  365,  322,  367,  395,   43,   22,
 /*  1820 */   398,  399,  400,  401,  402,  403,    0,  405,   35,   43,
 /*  1830 */    35,   35,    0,   35,   22,   22,   49,    0,   22,   35,
 /*  1840 */   391,    0,   35,    0,  395,  352,   35,  398,  399,  400,
 /*  1850 */   401,  402,  403,  360,  405,    0,   22,   95,  365,  322,
 /*  1860 */   367,   96,   20,    0,   35,    0,   22,  181,    0,    0,
 /*  1870 */     3,   43,  161,  246,  161,   95,   95,  163,   96,  322,
 /*  1880 */     3,   43,   43,  167,  391,   96,   96,  246,  395,  352,
 /*  1890 */    96,  398,  399,  400,  401,  402,  403,  360,  405,   46,
 /*  1900 */    43,   95,  365,  161,  367,   46,  246,   43,   35,  352,
 /*  1910 */    95,   35,   95,   95,   35,   96,   96,  360,   35,   35,
 /*  1920 */    35,   96,  365,   96,  367,   43,   46,   46,  391,    0,
 /*  1930 */     0,    0,  395,  190,   35,  398,  399,  400,  401,  402,
 /*  1940 */   403,   95,  405,   96,  322,   96,   95,   35,  391,    0,
 /*  1950 */     0,   95,  395,   95,   39,  398,  399,  400,  401,  402,
 /*  1960 */   403,   95,  405,   46,  322,  164,  105,   46,   43,    2,
 /*  1970 */   162,  240,  225,   22,  352,   22,  225,  227,   46,   46,
 /*  1980 */   106,   95,  360,   96,   95,  107,   96,  365,   95,  367,
 /*  1990 */    96,   95,   95,   35,  352,   35,   96,   95,   35,   96,
 /*  2000 */    95,   95,  360,  203,   96,   96,   35,  365,  205,  367,
 /*  2010 */    96,   95,   35,  391,   95,   35,   96,  395,  322,   95,
 /*  2020 */   398,  399,  400,  401,  402,  403,  119,  405,   22,  119,
 /*  2030 */   119,   95,  119,  391,  322,   95,   35,  395,   95,   43,
 /*  2040 */   398,  399,  400,  401,  402,  403,   22,  405,  352,   63,
 /*  2050 */    62,   35,   35,   35,   35,   35,  360,   35,   35,   69,
 /*  2060 */    35,  365,   35,  367,  352,   35,   92,   35,   35,   43,
 /*  2070 */    22,   35,  360,   22,   35,   35,   35,  365,  322,  367,
 /*  2080 */    69,   35,   35,   22,   35,   35,    0,  391,   35,   35,
 /*  2090 */    35,  395,   47,    0,  398,  399,  400,  401,  402,  403,
 /*  2100 */    35,  405,   39,  391,    0,  322,   47,  395,  352,   39,
 /*  2110 */   398,  399,  400,  401,  402,  403,  360,  405,   35,   47,
 /*  2120 */    39,  365,    0,  367,   35,   47,   39,    0,    0,   35,
 /*  2130 */    35,   22,  322,   21,   21,  352,   22,   22,   20,  454,
 /*  2140 */   454,  454,  454,  360,  454,  454,  454,  391,  365,  454,
 /*  2150 */   367,  395,  454,  454,  398,  399,  400,  401,  402,  403,
 /*  2160 */   454,  405,  352,  454,  454,  454,  454,  454,  454,  454,
 /*  2170 */   360,  454,  454,  454,  391,  365,  322,  367,  395,  454,
 /*  2180 */   454,  398,  399,  400,  401,  402,  403,  454,  405,  454,
 /*  2190 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2200 */   454,  391,  454,  454,  454,  395,  352,  454,  398,  399,
 /*  2210 */   400,  401,  402,  403,  360,  405,  454,  454,  454,  365,
 /*  2220 */   322,  367,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2230 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2240 */   322,  454,  454,  454,  454,  391,  454,  454,  454,  395,
 /*  2250 */   352,  454,  398,  399,  400,  401,  402,  403,  360,  405,
 /*  2260 */   454,  454,  454,  365,  454,  367,  454,  454,  454,  454,
 /*  2270 */   352,  454,  454,  454,  454,  454,  454,  454,  360,  454,
 /*  2280 */   454,  454,  454,  365,  454,  367,  454,  454,  454,  391,
 /*  2290 */   454,  454,  454,  395,  454,  454,  398,  399,  400,  401,
 /*  2300 */   402,  403,  454,  405,  454,  322,  454,  454,  454,  391,
 /*  2310 */   454,  454,  454,  395,  454,  454,  398,  399,  400,  401,
 /*  2320 */   402,  403,  454,  405,  454,  322,  454,  454,  454,  454,
 /*  2330 */   454,  454,  454,  454,  454,  352,  454,  454,  454,  454,
 /*  2340 */   454,  454,  454,  360,  454,  454,  454,  454,  365,  454,
 /*  2350 */   367,  454,  454,  454,  454,  352,  454,  454,  454,  454,
 /*  2360 */   454,  454,  454,  360,  454,  454,  454,  454,  365,  454,
 /*  2370 */   367,  454,  454,  454,  391,  454,  454,  454,  395,  322,
 /*  2380 */   454,  398,  399,  400,  401,  402,  403,  454,  405,  454,
 /*  2390 */   454,  454,  454,  454,  391,  322,  454,  454,  395,  454,
 /*  2400 */   454,  398,  399,  400,  401,  402,  403,  454,  405,  352,
 /*  2410 */   454,  454,  454,  454,  454,  454,  454,  360,  454,  454,
 /*  2420 */   454,  454,  365,  454,  367,  352,  454,  454,  454,  454,
 /*  2430 */   454,  454,  454,  360,  454,  454,  454,  454,  365,  322,
 /*  2440 */   367,  454,  454,  454,  454,  454,  454,  454,  391,  454,
 /*  2450 */   454,  454,  395,   19,  454,  398,  399,  400,  401,  402,
 /*  2460 */   403,  454,  405,  454,  391,  454,  322,   33,  395,  352,
 /*  2470 */   454,  398,  399,  400,  401,  402,  403,  360,  405,  454,
 /*  2480 */   454,   47,  365,  454,  367,  454,  454,   53,   54,   55,
 /*  2490 */    56,   57,  454,  454,  454,  454,  352,  454,  454,  454,
 /*  2500 */   454,  454,  454,  454,  360,  454,  454,  454,  391,  365,
 /*  2510 */   454,  367,  395,  454,  454,  398,  399,  400,  401,  402,
 /*  2520 */   403,  454,  405,  454,  454,  454,  454,  454,   94,  454,
 /*  2530 */   454,   97,  454,  454,  454,  391,  454,  454,  454,  395,
 /*  2540 */   454,  454,  398,  399,  400,  401,  402,  403,  454,  405,
 /*  2550 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2560 */   454,  454,  454,  454,  130,  454,  454,  454,  454,  454,
 /*  2570 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2580 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2590 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  165,
 /*  2600 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2610 */   454,  454,  454,  454,  454,  454,  182,  454,  184,  454,
 /*  2620 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2630 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2640 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2650 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2660 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2670 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2680 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2690 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2700 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2710 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2720 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2730 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2740 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2750 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2760 */   454,  454,  454,  454,  454,  454,  454,  454,  454,  454,
 /*  2770 */   454,  454,  454,
};
#define YY_SHIFT_COUNT    (703)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2434)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   895,    0,  132,    0,  264,  264,  264,  264,  264,  264,
 /*    10 */   264,  264,  264,  396,  528,  528,  660,  528,  528,  528,
 /*    20 */   528,  528,  528,  528,  528,  528,  528,  528,  528,  528,
 /*    30 */   528,  528,  528,  528,  528,  528,  528,  528,  528,  528,
 /*    40 */   528,  528,  528,  528,  528,  528,   69,  224,  282,   14,
 /*    50 */   208,  193,  353,  193,  282,  282, 1023, 1023,  193, 1023,
 /*    60 */  1023,   89,  193,   71,   71,   23,   42,   42,   18,   71,
 /*    70 */    71,   71,   71,   71,   71,   71,   71,   71,   71,  129,
 /*    80 */    71,   71,  222,   71,  249,   71,   71,  307,   71,   71,
 /*    90 */   307,   71,  307,  307,  307,   71,  137,  223,  489,  489,
 /*   100 */   217,  145,  748,  748,  748,  748,  748,  748,  748,  748,
 /*   110 */   748,  748,  748,  748,  748,  748,  748,  748,  748,  748,
 /*   120 */   748,  954,   31,   23,   18,  302,  302,  915,  263,  619,
 /*   130 */   619,  619,  969,  215,  215,  263,  369,  369,  369,  330,
 /*   140 */   249,   16,   16,  225,  307,  307,  449,  449,  330,  464,
 /*   150 */   733,  733,  733,  733,  733,  733,  733, 2434,   64, 1123,
 /*   160 */   246,   15,  389,   38,  261,  310,  372,  502,  901, 1005,
 /*   170 */   956,  951,  828,  922,  160,  828, 1047,  770,  870, 1041,
 /*   180 */  1239, 1124, 1259, 1286, 1259, 1160, 1294, 1294, 1259, 1160,
 /*   190 */  1160, 1230, 1294, 1294, 1294, 1315, 1315, 1320,  129,  249,
 /*   200 */   129, 1324, 1339,  129, 1324,  129,  129,  129, 1294,  129,
 /*   210 */  1328, 1328, 1315,  307,  307,  307,  307,  307,  307,  307,
 /*   220 */   307,  307,  307,  307, 1294, 1315,  449, 1203, 1320,  137,
 /*   230 */  1235,  249,  137, 1294, 1286, 1286,  449, 1169, 1197,  449,
 /*   240 */  1169, 1197,  449,  449,  307, 1199, 1296, 1169, 1208, 1210,
 /*   250 */  1229, 1041, 1219, 1228, 1234, 1257,  369, 1479, 1294, 1324,
 /*   260 */   137, 1197,  449,  449,  449,  449,  449, 1197,  449, 1357,
 /*   270 */   137,  330,  137,  369, 1456, 1459,  449,  464, 1294,  137,
 /*   280 */  1524, 1315, 2619, 2619, 2619, 2619, 2619, 2619, 2619,  821,
 /*   290 */   358,  432,  492,  662,  385,  688,  752,  785,  817,  933,
 /*   300 */   933,  439,  933,  933,  933,  933,  933,  933,  933, 1032,
 /*   310 */   946,  913,  368,  109,  109,  343,  530,   61,  801,  391,
 /*   320 */   119,  488,  417,  119,  119,  119, 1068,  287,  760, 1063,
 /*   330 */   953, 1018, 1066, 1072, 1073, 1085, 1087, 1134, 1170, 1044,
 /*   340 */  1070, 1089,  994,  952,  984, 1030, 1114, 1139, 1150, 1154,
 /*   350 */  1155, 1126, 1156, 1043, 1107, 1046, 1161, 1159, 1174, 1175,
 /*   360 */  1177, 1179, 1182, 1187, 1184, 1176, 1193, 1165, 1268, 1590,
 /*   370 */  1592, 1408, 1600, 1602, 1562, 1605, 1571, 1410, 1573, 1574,
 /*   380 */  1575, 1414, 1612, 1578, 1579, 1418, 1617, 1421, 1619, 1585,
 /*   390 */  1623, 1603, 1626, 1593, 1447, 1452, 1632, 1634, 1461, 1463,
 /*   400 */  1637, 1638, 1594, 1639, 1649, 1650, 1601, 1644, 1645, 1651,
 /*   410 */  1652, 1653, 1654, 1656, 1658, 1511, 1607, 1661, 1519, 1670,
 /*   420 */  1671, 1674, 1675, 1677, 1678, 1685, 1689, 1690, 1691, 1693,
 /*   430 */  1694, 1701, 1704, 1705, 1655, 1698, 1699, 1706, 1707, 1709,
 /*   440 */  1688, 1719, 1720, 1721, 1722, 1679, 1715, 1666, 1724, 1668,
 /*   450 */  1727, 1728, 1687, 1657, 1669, 1717, 1667, 1718, 1695, 1739,
 /*   460 */  1703, 1725, 1745, 1748, 1757, 1726, 1589, 1759, 1761, 1763,
 /*   470 */  1710, 1766, 1767, 1733, 1723, 1730, 1772, 1740, 1729, 1738,
 /*   480 */  1778, 1744, 1734, 1741, 1788, 1749, 1736, 1746, 1791, 1792,
 /*   490 */  1799, 1802, 1700, 1708, 1768, 1784, 1805, 1773, 1776, 1785,
 /*   500 */  1777, 1793, 1775, 1786, 1795, 1796, 1797, 1798, 1826, 1812,
 /*   510 */  1832, 1813, 1787, 1837, 1816, 1804, 1841, 1807, 1843, 1811,
 /*   520 */  1855, 1834, 1842, 1765, 1762, 1863, 1711, 1829, 1865, 1686,
 /*   530 */  1844, 1713, 1714, 1868, 1869, 1742, 1716, 1867, 1828, 1627,
 /*   540 */  1780, 1782, 1781, 1789, 1838, 1790, 1806, 1815, 1817, 1794,
 /*   550 */  1839, 1853, 1859, 1818, 1857, 1641, 1819, 1820, 1877, 1864,
 /*   560 */  1660, 1873, 1876, 1879, 1883, 1884, 1885, 1825, 1827, 1880,
 /*   570 */  1731, 1882, 1881, 1929, 1930, 1931, 1846, 1847, 1849, 1851,
 /*   580 */  1899, 1912, 1743, 1949, 1856, 1801, 1858, 1950, 1915, 1808,
 /*   590 */  1866, 1861, 1917, 1921, 1925, 1747, 1750, 1751, 1967, 1951,
 /*   600 */  1800, 1886, 1887, 1889, 1890, 1893, 1894, 1932, 1896, 1897,
 /*   610 */  1933, 1900, 1953, 1803, 1902, 1874, 1903, 1958, 1960, 1905,
 /*   620 */  1908, 1963, 1906, 1909, 1971, 1916, 1914, 1977, 1919, 1920,
 /*   630 */  1980, 1924, 1907, 1910, 1911, 1913, 2006, 1878, 1936, 1940,
 /*   640 */  2001, 1943, 1996, 1996, 2024, 1986, 1988, 2016, 2017, 2018,
 /*   650 */  2019, 2020, 2022, 2023, 2025, 2027, 2030, 1990, 1974, 2026,
 /*   660 */  2032, 2033, 2048, 2036, 2051, 2039, 2040, 2041, 2011, 1775,
 /*   670 */  2046, 1786, 2047, 2049, 2050, 2053, 2061, 2054, 2086, 2055,
 /*   680 */  2045, 2063, 2093, 2065, 2059, 2070, 2104, 2083, 2072, 2081,
 /*   690 */  2122, 2089, 2078, 2087, 2127, 2094, 2095, 2128, 2109, 2112,
 /*   700 */  2114, 2115, 2113, 2118,
};
#define YY_REDUCE_COUNT (288)
#define YY_REDUCE_MIN   (-407)
#define YY_REDUCE_MAX   (2144)
static const short yy_reduce_ofst[] = {
 /*     0 */   889, -320, -297, -165,  598,  621,  719,  778,  864,  893,
 /*    10 */   411,  955,  982,  231, 1009, 1026, 1080, 1136, 1180, 1196,
 /*    20 */  1264, 1281, 1335, 1351, 1395, 1422, 1449, 1493, 1537, 1557,
 /*    30 */  1622, 1642, 1696, 1712, 1756, 1783, 1810, 1854, 1898, 1918,
 /*    40 */  1983, 2003, 2057, 2073, 2117, 2144,  241,   86,  -37,  536,
 /*    50 */  1013, 1067, 1081, 1125,  228,  291, -346,  -87, -407, -166,
 /*    60 */   -80, -372,  -22, -276, -204, -308, -325, -319, -205, -192,
 /*    70 */    60,   74,  176,  202,  230,  234,  349,  429,  443,  -78,
 /*    80 */   445,  584,  147,  627, -362,  632,  674, -245,  717,  721,
 /*    90 */    78,  773,  -48,   81,  -24,  338, -294, -144, -182, -182,
 /*   100 */  -330, -142, -222, -210, -117,  178,  260,  342,  345,  392,
 /*   110 */   431,  459,  496,  594,  601,  602,  603,  607,  609,  612,
 /*   120 */   617,  405, -397, -106,  126,  185,  327,  427,  242, -397,
 /*   130 */    24,  533,  350,  161,  425,  469,  419,  444,  623,  346,
 /*   140 */   319,  481,  556,  247,  650,  570,  644,  677,  698,  665,
 /*   150 */   275,  377,  486,  499,  506,  564,  587,  657,  741,  792,
 /*   160 */   827,  755,  768,  881,  779,  867,  867,  890,  857,  904,
 /*   170 */   872,  862,  822,  822,  811,  822,  843,  853,  867,  897,
 /*   180 */   905,  914,  930,  936,  940,  938,  989,  991,  957,  958,
 /*   190 */   960,  987,  995,  996,  997, 1012, 1015,  962, 1006,  976,
 /*   200 */  1010,  970,  978, 1028,  983, 1029, 1031, 1033, 1040, 1053,
 /*   210 */  1057, 1058, 1051, 1045, 1049, 1054, 1061, 1064, 1071, 1078,
 /*   220 */  1082, 1083, 1084, 1086, 1062, 1079, 1050, 1052, 1016, 1100,
 /*   230 */  1034, 1076, 1106, 1090, 1069, 1077, 1088, 1017, 1091, 1094,
 /*   240 */  1020, 1092, 1095, 1098,  867, 1035, 1037, 1055, 1060, 1036,
 /*   250 */  1056, 1093, 1059, 1074, 1096,  822, 1140, 1109, 1183, 1122,
 /*   260 */  1181, 1129, 1152, 1157, 1158, 1163, 1168, 1141, 1178, 1186,
 /*   270 */  1211, 1198, 1217, 1166, 1137, 1201, 1190, 1216, 1236, 1226,
 /*   280 */  1240, 1243, 1191, 1189, 1218, 1238, 1242, 1255, 1252,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*    10 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*    20 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*    30 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*    40 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*    50 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*    60 */  1579, 1579, 1579, 1579, 1579, 1832, 1579, 1579, 1579, 1579,
 /*    70 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1655,
 /*    80 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*    90 */  1579, 1579, 1579, 1579, 1579, 1579, 1653, 1825, 2021, 1579,
 /*   100 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   110 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   120 */  1579, 1579, 2033, 1579, 1579, 1579, 1579, 1655, 1579, 2033,
 /*   130 */  2033, 2033, 1653, 1993, 1993, 1579, 1579, 1579, 1579, 1764,
 /*   140 */  1579, 1874, 1874, 1579, 1579, 1579, 1579, 1579, 1764, 1579,
 /*   150 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1868, 1579, 1579,
 /*   160 */  2058, 2111, 1579, 1579, 2061, 1579, 1579, 1579, 1837, 1579,
 /*   170 */  1717, 2048, 2025, 2039, 2095, 2026, 2023, 2042, 1579, 2052,
 /*   180 */  1579, 1861, 1830, 1579, 1830, 1827, 1579, 1579, 1830, 1827,
 /*   190 */  1827, 1708, 1579, 1579, 1579, 1579, 1579, 1579, 1655, 1579,
 /*   200 */  1655, 1579, 1579, 1655, 1579, 1655, 1655, 1655, 1579, 1655,
 /*   210 */  1634, 1634, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   220 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1881, 1579, 1653,
 /*   230 */  1870, 1579, 1653, 1579, 1579, 1579, 1579, 2068, 2066, 1579,
 /*   240 */  2068, 2066, 1579, 1579, 1579, 2080, 2076, 2068, 2084, 2082,
 /*   250 */  2054, 2052, 2114, 2101, 2097, 2039, 1579, 1579, 1579, 1579,
 /*   260 */  1653, 2066, 1579, 1579, 1579, 1579, 1579, 2066, 1579, 1579,
 /*   270 */  1653, 1579, 1653, 1579, 1579, 1733, 1579, 1579, 1579, 1653,
 /*   280 */  1611, 1579, 1863, 1874, 1767, 1767, 1767, 1656, 1584, 1579,
 /*   290 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 2079,
 /*   300 */  2078, 1579, 1949, 1579, 1997, 1996, 1995, 1986, 1948, 1579,
 /*   310 */  1729, 1579, 1579, 1947, 1946, 1579, 1579, 1579, 1579, 1579,
 /*   320 */  1940, 1579, 1579, 1941, 1939, 1938, 1579, 1579, 1579, 1579,
 /*   330 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   340 */  1579, 1579, 1579, 2098, 2102, 1579, 1579, 1579, 1579, 1579,
 /*   350 */  1579, 2022, 1579, 1579, 1579, 1579, 1579, 1923, 1579, 1579,
 /*   360 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   370 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   380 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   390 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   400 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   410 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   420 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   430 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   440 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   450 */  1579, 1579, 1579, 1579, 1616, 1579, 1579, 1579, 1579, 1579,
 /*   460 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   470 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   480 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   490 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   500 */  1579, 1579, 1695, 1694, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   510 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   520 */  1579, 1579, 1579, 1931, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   530 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 2094, 2055, 1579,
 /*   540 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   550 */  1579, 1579, 1923, 1579, 2077, 1579, 1579, 2092, 1579, 2096,
 /*   560 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 2032, 2028, 1579,
 /*   570 */  1579, 2024, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   580 */  1579, 1579, 1579, 1878, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   590 */  1579, 1579, 1922, 1579, 1983, 1579, 1579, 1579, 2017, 1579,
 /*   600 */  1579, 1968, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   610 */  1579, 1931, 1579, 1934, 1579, 1579, 1579, 1579, 1579, 1761,
 /*   620 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   630 */  1579, 1579, 1746, 1744, 1743, 1742, 1579, 1739, 1579, 1579,
 /*   640 */  1579, 1579, 1770, 1769, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   650 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1675,
 /*   660 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1666,
 /*   670 */  1579, 1665, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   680 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   690 */  1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579, 1579,
 /*   700 */  1579, 1579, 1579, 1579,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       CASE => nothing */
  266,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  266,  /*      AFTER => ABORT */
  266,  /*     ATTACH => ABORT */
  266,  /*     BEFORE => ABORT */
  266,  /*      BEGIN => ABORT */
  266,  /*     BITAND => ABORT */
  266,  /*     BITNOT => ABORT */
  266,  /*      BITOR => ABORT */
  266,  /*     BLOCKS => ABORT */
  266,  /*     CHANGE => ABORT */
  266,  /*      COMMA => ABORT */
  266,  /*    COMPACT => ABORT */
  266,  /*     CONCAT => ABORT */
  266,  /*   CONFLICT => ABORT */
  266,  /*       COPY => ABORT */
  266,  /*   DEFERRED => ABORT */
  266,  /* DELIMITERS => ABORT */
  266,  /*     DETACH => ABORT */
  266,  /*     DIVIDE => ABORT */
  266,  /*        DOT => ABORT */
  266,  /*       EACH => ABORT */
  266,  /*       FAIL => ABORT */
  266,  /*       FILE => ABORT */
  266,  /*        FOR => ABORT */
  266,  /*       GLOB => ABORT */
  266,  /*         ID => ABORT */
  266,  /*  IMMEDIATE => ABORT */
  266,  /*     IMPORT => ABORT */
  266,  /*  INITIALLY => ABORT */
  266,  /*    INSTEAD => ABORT */
  266,  /*     ISNULL => ABORT */
  266,  /*        KEY => ABORT */
  266,  /*    MODULES => ABORT */
  266,  /*  NK_BITNOT => ABORT */
  266,  /*    NK_SEMI => ABORT */
  266,  /*    NOTNULL => ABORT */
  266,  /*         OF => ABORT */
  266,  /*       PLUS => ABORT */
  266,  /*  PRIVILEGE => ABORT */
  266,  /*      RAISE => ABORT */
  266,  /*    REPLACE => ABORT */
  266,  /*   RESTRICT => ABORT */
  266,  /*        ROW => ABORT */
  266,  /*       SEMI => ABORT */
  266,  /*       STAR => ABORT */
  266,  /*  STATEMENT => ABORT */
  266,  /*     STRING => ABORT */
  266,  /*      TIMES => ABORT */
  266,  /*     UPDATE => ABORT */
  266,  /*     VALUES => ABORT */
  266,  /*   VARIABLE => ABORT */
  266,  /*       VIEW => ABORT */
  266,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "FORCE",
  /*   52 */ "LOCAL",
  /*   53 */ "QNODE",
  /*   54 */ "BNODE",
  /*   55 */ "SNODE",
  /*   56 */ "MNODE",
  /*   57 */ "DATABASE",
  /*   58 */ "USE",
  /*   59 */ "FLUSH",
  /*   60 */ "TRIM",
  /*   61 */ "IF",
  /*   62 */ "NOT",
  /*   63 */ "EXISTS",
  /*   64 */ "BUFFER",
  /*   65 */ "CACHEMODEL",
  /*   66 */ "CACHESIZE",
  /*   67 */ "COMP",
  /*   68 */ "DURATION",
  /*   69 */ "NK_VARIABLE",
  /*   70 */ "MAXROWS",
  /*   71 */ "MINROWS",
  /*   72 */ "KEEP",
  /*   73 */ "PAGES",
  /*   74 */ "PAGESIZE",
  /*   75 */ "TSDB_PAGESIZE",
  /*   76 */ "PRECISION",
  /*   77 */ "REPLICA",
  /*   78 */ "STRICT",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "WAL_LEVEL",
  /*   84 */ "WAL_FSYNC_PERIOD",
  /*   85 */ "WAL_RETENTION_PERIOD",
  /*   86 */ "WAL_RETENTION_SIZE",
  /*   87 */ "WAL_ROLL_PERIOD",
  /*   88 */ "WAL_SEGMENT_SIZE",
  /*   89 */ "STT_TRIGGER",
  /*   90 */ "TABLE_PREFIX",
  /*   91 */ "TABLE_SUFFIX",
  /*   92 */ "NK_COLON",
  /*   93 */ "MAX_SPEED",
  /*   94 */ "TABLE",
  /*   95 */ "NK_LP",
  /*   96 */ "NK_RP",
  /*   97 */ "STABLE",
  /*   98 */ "ADD",
  /*   99 */ "COLUMN",
  /*  100 */ "MODIFY",
  /*  101 */ "RENAME",
  /*  102 */ "TAG",
  /*  103 */ "SET",
  /*  104 */ "NK_EQ",
  /*  105 */ "USING",
  /*  106 */ "TAGS",
  /*  107 */ "COMMENT",
  /*  108 */ "BOOL",
  /*  109 */ "TINYINT",
  /*  110 */ "SMALLINT",
  /*  111 */ "INT",
  /*  112 */ "INTEGER",
  /*  113 */ "BIGINT",
  /*  114 */ "FLOAT",
  /*  115 */ "DOUBLE",
  /*  116 */ "BINARY",
  /*  117 */ "TIMESTAMP",
  /*  118 */ "NCHAR",
  /*  119 */ "UNSIGNED",
  /*  120 */ "JSON",
  /*  121 */ "VARCHAR",
  /*  122 */ "MEDIUMBLOB",
  /*  123 */ "BLOB",
  /*  124 */ "VARBINARY",
  /*  125 */ "DECIMAL",
  /*  126 */ "MAX_DELAY",
  /*  127 */ "WATERMARK",
  /*  128 */ "ROLLUP",
  /*  129 */ "TTL",
  /*  130 */ "SMA",
  /*  131 */ "FIRST",
  /*  132 */ "LAST",
  /*  133 */ "SHOW",
  /*  134 */ "DATABASES",
  /*  135 */ "TABLES",
  /*  136 */ "STABLES",
  /*  137 */ "MNODES",
  /*  138 */ "QNODES",
  /*  139 */ "FUNCTIONS",
  /*  140 */ "INDEXES",
  /*  141 */ "ACCOUNTS",
  /*  142 */ "APPS",
  /*  143 */ "CONNECTIONS",
  /*  144 */ "LICENCES",
  /*  145 */ "GRANTS",
  /*  146 */ "QUERIES",
  /*  147 */ "SCORES",
  /*  148 */ "TOPICS",
  /*  149 */ "VARIABLES",
  /*  150 */ "CLUSTER",
  /*  151 */ "BNODES",
  /*  152 */ "SNODES",
  /*  153 */ "TRANSACTIONS",
  /*  154 */ "DISTRIBUTED",
  /*  155 */ "CONSUMERS",
  /*  156 */ "SUBSCRIPTIONS",
  /*  157 */ "VNODES",
  /*  158 */ "LIKE",
  /*  159 */ "TBNAME",
  /*  160 */ "QTAGS",
  /*  161 */ "AS",
  /*  162 */ "INDEX",
  /*  163 */ "FUNCTION",
  /*  164 */ "INTERVAL",
  /*  165 */ "TOPIC",
  /*  166 */ "WITH",
  /*  167 */ "META",
  /*  168 */ "CONSUMER",
  /*  169 */ "GROUP",
  /*  170 */ "DESC",
  /*  171 */ "DESCRIBE",
  /*  172 */ "RESET",
  /*  173 */ "QUERY",
  /*  174 */ "CACHE",
  /*  175 */ "EXPLAIN",
  /*  176 */ "ANALYZE",
  /*  177 */ "VERBOSE",
  /*  178 */ "NK_BOOL",
  /*  179 */ "RATIO",
  /*  180 */ "NK_FLOAT",
  /*  181 */ "OUTPUTTYPE",
  /*  182 */ "AGGREGATE",
  /*  183 */ "BUFSIZE",
  /*  184 */ "STREAM",
  /*  185 */ "INTO",
  /*  186 */ "TRIGGER",
  /*  187 */ "AT_ONCE",
  /*  188 */ "WINDOW_CLOSE",
  /*  189 */ "IGNORE",
  /*  190 */ "EXPIRED",
  /*  191 */ "FILL_HISTORY",
  /*  192 */ "SUBTABLE",
  /*  193 */ "KILL",
  /*  194 */ "CONNECTION",
  /*  195 */ "TRANSACTION",
  /*  196 */ "BALANCE",
  /*  197 */ "VGROUP",
  /*  198 */ "MERGE",
  /*  199 */ "REDISTRIBUTE",
  /*  200 */ "SPLIT",
  /*  201 */ "DELETE",
  /*  202 */ "INSERT",
  /*  203 */ "NULL",
  /*  204 */ "NK_QUESTION",
  /*  205 */ "NK_ARROW",
  /*  206 */ "ROWTS",
  /*  207 */ "QSTART",
  /*  208 */ "QEND",
  /*  209 */ "QDURATION",
  /*  210 */ "WSTART",
  /*  211 */ "WEND",
  /*  212 */ "WDURATION",
  /*  213 */ "IROWTS",
  /*  214 */ "CAST",
  /*  215 */ "NOW",
  /*  216 */ "TODAY",
  /*  217 */ "TIMEZONE",
  /*  218 */ "CLIENT_VERSION",
  /*  219 */ "SERVER_VERSION",
  /*  220 */ "SERVER_STATUS",
  /*  221 */ "CURRENT_USER",
  /*  222 */ "COUNT",
  /*  223 */ "LAST_ROW",
  /*  224 */ "CASE",
  /*  225 */ "END",
  /*  226 */ "WHEN",
  /*  227 */ "THEN",
  /*  228 */ "ELSE",
  /*  229 */ "BETWEEN",
  /*  230 */ "IS",
  /*  231 */ "NK_LT",
  /*  232 */ "NK_GT",
  /*  233 */ "NK_LE",
  /*  234 */ "NK_GE",
  /*  235 */ "NK_NE",
  /*  236 */ "MATCH",
  /*  237 */ "NMATCH",
  /*  238 */ "CONTAINS",
  /*  239 */ "IN",
  /*  240 */ "JOIN",
  /*  241 */ "INNER",
  /*  242 */ "SELECT",
  /*  243 */ "DISTINCT",
  /*  244 */ "WHERE",
  /*  245 */ "PARTITION",
  /*  246 */ "BY",
  /*  247 */ "SESSION",
  /*  248 */ "STATE_WINDOW",
  /*  249 */ "SLIDING",
  /*  250 */ "FILL",
  /*  251 */ "VALUE",
  /*  252 */ "NONE",
  /*  253 */ "PREV",
  /*  254 */ "LINEAR",
  /*  255 */ "NEXT",
  /*  256 */ "HAVING",
  /*  257 */ "RANGE",
  /*  258 */ "EVERY",
  /*  259 */ "ORDER",
  /*  260 */ "SLIMIT",
  /*  261 */ "SOFFSET",
  /*  262 */ "LIMIT",
  /*  263 */ "OFFSET",
  /*  264 */ "ASC",
  /*  265 */ "NULLS",
  /*  266 */ "ABORT",
  /*  267 */ "AFTER",
  /*  268 */ "ATTACH",
  /*  269 */ "BEFORE",
  /*  270 */ "BEGIN",
  /*  271 */ "BITAND",
  /*  272 */ "BITNOT",
  /*  273 */ "BITOR",
  /*  274 */ "BLOCKS",
  /*  275 */ "CHANGE",
  /*  276 */ "COMMA",
  /*  277 */ "COMPACT",
  /*  278 */ "CONCAT",
  /*  279 */ "CONFLICT",
  /*  280 */ "COPY",
  /*  281 */ "DEFERRED",
  /*  282 */ "DELIMITERS",
  /*  283 */ "DETACH",
  /*  284 */ "DIVIDE",
  /*  285 */ "DOT",
  /*  286 */ "EACH",
  /*  287 */ "FAIL",
  /*  288 */ "FILE",
  /*  289 */ "FOR",
  /*  290 */ "GLOB",
  /*  291 */ "ID",
  /*  292 */ "IMMEDIATE",
  /*  293 */ "IMPORT",
  /*  294 */ "INITIALLY",
  /*  295 */ "INSTEAD",
  /*  296 */ "ISNULL",
  /*  297 */ "KEY",
  /*  298 */ "MODULES",
  /*  299 */ "NK_BITNOT",
  /*  300 */ "NK_SEMI",
  /*  301 */ "NOTNULL",
  /*  302 */ "OF",
  /*  303 */ "PLUS",
  /*  304 */ "PRIVILEGE",
  /*  305 */ "RAISE",
  /*  306 */ "REPLACE",
  /*  307 */ "RESTRICT",
  /*  308 */ "ROW",
  /*  309 */ "SEMI",
  /*  310 */ "STAR",
  /*  311 */ "STATEMENT",
  /*  312 */ "STRING",
  /*  313 */ "TIMES",
  /*  314 */ "UPDATE",
  /*  315 */ "VALUES",
  /*  316 */ "VARIABLE",
  /*  317 */ "VIEW",
  /*  318 */ "WAL",
  /*  319 */ "cmd",
  /*  320 */ "account_options",
  /*  321 */ "alter_account_options",
  /*  322 */ "literal",
  /*  323 */ "alter_account_option",
  /*  324 */ "user_name",
  /*  325 */ "sysinfo_opt",
  /*  326 */ "privileges",
  /*  327 */ "priv_level",
  /*  328 */ "priv_type_list",
  /*  329 */ "priv_type",
  /*  330 */ "db_name",
  /*  331 */ "dnode_endpoint",
  /*  332 */ "force_opt",
  /*  333 */ "not_exists_opt",
  /*  334 */ "db_options",
  /*  335 */ "exists_opt",
  /*  336 */ "alter_db_options",
  /*  337 */ "speed_opt",
  /*  338 */ "integer_list",
  /*  339 */ "variable_list",
  /*  340 */ "retention_list",
  /*  341 */ "alter_db_option",
  /*  342 */ "retention",
  /*  343 */ "full_table_name",
  /*  344 */ "column_def_list",
  /*  345 */ "tags_def_opt",
  /*  346 */ "table_options",
  /*  347 */ "multi_create_clause",
  /*  348 */ "tags_def",
  /*  349 */ "multi_drop_clause",
  /*  350 */ "alter_table_clause",
  /*  351 */ "alter_table_options",
  /*  352 */ "column_name",
  /*  353 */ "type_name",
  /*  354 */ "signed_literal",
  /*  355 */ "create_subtable_clause",
  /*  356 */ "specific_cols_opt",
  /*  357 */ "expression_list",
  /*  358 */ "drop_table_clause",
  /*  359 */ "col_name_list",
  /*  360 */ "table_name",
  /*  361 */ "column_def",
  /*  362 */ "duration_list",
  /*  363 */ "rollup_func_list",
  /*  364 */ "alter_table_option",
  /*  365 */ "duration_literal",
  /*  366 */ "rollup_func_name",
  /*  367 */ "function_name",
  /*  368 */ "col_name",
  /*  369 */ "db_name_cond_opt",
  /*  370 */ "like_pattern_opt",
  /*  371 */ "table_name_cond",
  /*  372 */ "from_db_opt",
  /*  373 */ "tag_list_opt",
  /*  374 */ "tag_item",
  /*  375 */ "column_alias",
  /*  376 */ "index_options",
  /*  377 */ "func_list",
  /*  378 */ "sliding_opt",
  /*  379 */ "sma_stream_opt",
  /*  380 */ "func",
  /*  381 */ "stream_options",
  /*  382 */ "topic_name",
  /*  383 */ "query_or_subquery",
  /*  384 */ "cgroup_name",
  /*  385 */ "analyze_opt",
  /*  386 */ "explain_options",
  /*  387 */ "agg_func_opt",
  /*  388 */ "bufsize_opt",
  /*  389 */ "stream_name",
  /*  390 */ "subtable_opt",
  /*  391 */ "expression",
  /*  392 */ "dnode_list",
  /*  393 */ "where_clause_opt",
  /*  394 */ "signed",
  /*  395 */ "literal_func",
  /*  396 */ "literal_list",
  /*  397 */ "table_alias",
  /*  398 */ "expr_or_subquery",
  /*  399 */ "pseudo_column",
  /*  400 */ "column_reference",
  /*  401 */ "function_expression",
  /*  402 */ "case_when_expression",
  /*  403 */ "star_func",
  /*  404 */ "star_func_para_list",
  /*  405 */ "noarg_func",
  /*  406 */ "other_para_list",
  /*  407 */ "star_func_para",
  /*  408 */ "when_then_list",
  /*  409 */ "case_when_else_opt",
  /*  410 */ "common_expression",
  /*  411 */ "when_then_expr",
  /*  412 */ "predicate",
  /*  413 */ "compare_op",
  /*  414 */ "in_op",
  /*  415 */ "in_predicate_value",
  /*  416 */ "boolean_value_expression",
  /*  417 */ "boolean_primary",
  /*  418 */ "from_clause_opt",
  /*  419 */ "table_reference_list",
  /*  420 */ "table_reference",
  /*  421 */ "table_primary",
  /*  422 */ "joined_table",
  /*  423 */ "alias_opt",
  /*  424 */ "subquery",
  /*  425 */ "parenthesized_joined_table",
  /*  426 */ "join_type",
  /*  427 */ "search_condition",
  /*  428 */ "query_specification",
  /*  429 */ "set_quantifier_opt",
  /*  430 */ "select_list",
  /*  431 */ "partition_by_clause_opt",
  /*  432 */ "range_opt",
  /*  433 */ "every_opt",
  /*  434 */ "fill_opt",
  /*  435 */ "twindow_clause_opt",
  /*  436 */ "group_by_clause_opt",
  /*  437 */ "having_clause_opt",
  /*  438 */ "select_item",
  /*  439 */ "partition_list",
  /*  440 */ "partition_item",
  /*  441 */ "fill_mode",
  /*  442 */ "group_by_list",
  /*  443 */ "query_expression",
  /*  444 */ "query_simple",
  /*  445 */ "order_by_clause_opt",
  /*  446 */ "slimit_clause_opt",
  /*  447 */ "limit_clause_opt",
  /*  448 */ "union_query_expression",
  /*  449 */ "query_simple_or_subquery",
  /*  450 */ "sort_specification_list",
  /*  451 */ "sort_specification",
  /*  452 */ "ordering_specification_opt",
  /*  453 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "force_opt ::=",
 /*  53 */ "force_opt ::= FORCE",
 /*  54 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  55 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  56 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  65 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  66 */ "cmd ::= USE db_name",
 /*  67 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  68 */ "cmd ::= FLUSH DATABASE db_name",
 /*  69 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  70 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  71 */ "not_exists_opt ::=",
 /*  72 */ "exists_opt ::= IF EXISTS",
 /*  73 */ "exists_opt ::=",
 /*  74 */ "db_options ::=",
 /*  75 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  76 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  77 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  78 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  79 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  80 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  81 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  82 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  83 */ "db_options ::= db_options KEEP integer_list",
 /*  84 */ "db_options ::= db_options KEEP variable_list",
 /*  85 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  86 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  87 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  88 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  89 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  90 */ "db_options ::= db_options STRICT NK_STRING",
 /*  91 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  92 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  93 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  94 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  95 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 103 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 104 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 105 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 106 */ "alter_db_options ::= alter_db_option",
 /* 107 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 108 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 109 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 110 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 111 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 112 */ "alter_db_option ::= KEEP integer_list",
 /* 113 */ "alter_db_option ::= KEEP variable_list",
 /* 114 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 115 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 116 */ "alter_db_option ::= STRICT NK_STRING",
 /* 117 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 118 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 119 */ "integer_list ::= NK_INTEGER",
 /* 120 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 121 */ "variable_list ::= NK_VARIABLE",
 /* 122 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 123 */ "retention_list ::= retention",
 /* 124 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 125 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 126 */ "speed_opt ::=",
 /* 127 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 128 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 129 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 130 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 131 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 132 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 133 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 134 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 135 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 136 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 138 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 140 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 142 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 143 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 144 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 145 */ "multi_create_clause ::= create_subtable_clause",
 /* 146 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 147 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 148 */ "multi_drop_clause ::= drop_table_clause",
 /* 149 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 150 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 151 */ "specific_cols_opt ::=",
 /* 152 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 153 */ "full_table_name ::= table_name",
 /* 154 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 155 */ "column_def_list ::= column_def",
 /* 156 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 157 */ "column_def ::= column_name type_name",
 /* 158 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 159 */ "type_name ::= BOOL",
 /* 160 */ "type_name ::= TINYINT",
 /* 161 */ "type_name ::= SMALLINT",
 /* 162 */ "type_name ::= INT",
 /* 163 */ "type_name ::= INTEGER",
 /* 164 */ "type_name ::= BIGINT",
 /* 165 */ "type_name ::= FLOAT",
 /* 166 */ "type_name ::= DOUBLE",
 /* 167 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= TIMESTAMP",
 /* 169 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= TINYINT UNSIGNED",
 /* 171 */ "type_name ::= SMALLINT UNSIGNED",
 /* 172 */ "type_name ::= INT UNSIGNED",
 /* 173 */ "type_name ::= BIGINT UNSIGNED",
 /* 174 */ "type_name ::= JSON",
 /* 175 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 176 */ "type_name ::= MEDIUMBLOB",
 /* 177 */ "type_name ::= BLOB",
 /* 178 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= DECIMAL",
 /* 180 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 182 */ "tags_def_opt ::=",
 /* 183 */ "tags_def_opt ::= tags_def",
 /* 184 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 185 */ "table_options ::=",
 /* 186 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 187 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 188 */ "table_options ::= table_options WATERMARK duration_list",
 /* 189 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 190 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 191 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 192 */ "alter_table_options ::= alter_table_option",
 /* 193 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 194 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 195 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 196 */ "duration_list ::= duration_literal",
 /* 197 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 198 */ "rollup_func_list ::= rollup_func_name",
 /* 199 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 200 */ "rollup_func_name ::= function_name",
 /* 201 */ "rollup_func_name ::= FIRST",
 /* 202 */ "rollup_func_name ::= LAST",
 /* 203 */ "col_name_list ::= col_name",
 /* 204 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 205 */ "col_name ::= column_name",
 /* 206 */ "cmd ::= SHOW DNODES",
 /* 207 */ "cmd ::= SHOW USERS",
 /* 208 */ "cmd ::= SHOW DATABASES",
 /* 209 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 210 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 211 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 212 */ "cmd ::= SHOW MNODES",
 /* 213 */ "cmd ::= SHOW QNODES",
 /* 214 */ "cmd ::= SHOW FUNCTIONS",
 /* 215 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 216 */ "cmd ::= SHOW STREAMS",
 /* 217 */ "cmd ::= SHOW ACCOUNTS",
 /* 218 */ "cmd ::= SHOW APPS",
 /* 219 */ "cmd ::= SHOW CONNECTIONS",
 /* 220 */ "cmd ::= SHOW LICENCES",
 /* 221 */ "cmd ::= SHOW GRANTS",
 /* 222 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 223 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 224 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 225 */ "cmd ::= SHOW QUERIES",
 /* 226 */ "cmd ::= SHOW SCORES",
 /* 227 */ "cmd ::= SHOW TOPICS",
 /* 228 */ "cmd ::= SHOW VARIABLES",
 /* 229 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 230 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 231 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 232 */ "cmd ::= SHOW BNODES",
 /* 233 */ "cmd ::= SHOW SNODES",
 /* 234 */ "cmd ::= SHOW CLUSTER",
 /* 235 */ "cmd ::= SHOW TRANSACTIONS",
 /* 236 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 237 */ "cmd ::= SHOW CONSUMERS",
 /* 238 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 239 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 240 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 241 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 242 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 243 */ "db_name_cond_opt ::=",
 /* 244 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 245 */ "like_pattern_opt ::=",
 /* 246 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 247 */ "table_name_cond ::= table_name",
 /* 248 */ "from_db_opt ::=",
 /* 249 */ "from_db_opt ::= FROM db_name",
 /* 250 */ "tag_list_opt ::=",
 /* 251 */ "tag_list_opt ::= tag_item",
 /* 252 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 253 */ "tag_item ::= TBNAME",
 /* 254 */ "tag_item ::= QTAGS",
 /* 255 */ "tag_item ::= column_name",
 /* 256 */ "tag_item ::= column_name column_alias",
 /* 257 */ "tag_item ::= column_name AS column_alias",
 /* 258 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 259 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 260 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 261 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 262 */ "func_list ::= func",
 /* 263 */ "func_list ::= func_list NK_COMMA func",
 /* 264 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 265 */ "sma_stream_opt ::=",
 /* 266 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 267 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 268 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 269 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 270 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 271 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 272 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 273 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 274 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 275 */ "cmd ::= DESC full_table_name",
 /* 276 */ "cmd ::= DESCRIBE full_table_name",
 /* 277 */ "cmd ::= RESET QUERY CACHE",
 /* 278 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 279 */ "analyze_opt ::=",
 /* 280 */ "analyze_opt ::= ANALYZE",
 /* 281 */ "explain_options ::=",
 /* 282 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 283 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 284 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 285 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 286 */ "agg_func_opt ::=",
 /* 287 */ "agg_func_opt ::= AGGREGATE",
 /* 288 */ "bufsize_opt ::=",
 /* 289 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 290 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 291 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 292 */ "stream_options ::=",
 /* 293 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 294 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 295 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 296 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 297 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 298 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 299 */ "subtable_opt ::=",
 /* 300 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 301 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 302 */ "cmd ::= KILL QUERY NK_STRING",
 /* 303 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 304 */ "cmd ::= BALANCE VGROUP",
 /* 305 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 306 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 307 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 308 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 309 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 310 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 311 */ "cmd ::= query_or_subquery",
 /* 312 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 313 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 314 */ "literal ::= NK_INTEGER",
 /* 315 */ "literal ::= NK_FLOAT",
 /* 316 */ "literal ::= NK_STRING",
 /* 317 */ "literal ::= NK_BOOL",
 /* 318 */ "literal ::= TIMESTAMP NK_STRING",
 /* 319 */ "literal ::= duration_literal",
 /* 320 */ "literal ::= NULL",
 /* 321 */ "literal ::= NK_QUESTION",
 /* 322 */ "duration_literal ::= NK_VARIABLE",
 /* 323 */ "signed ::= NK_INTEGER",
 /* 324 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 325 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 326 */ "signed ::= NK_FLOAT",
 /* 327 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 328 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 329 */ "signed_literal ::= signed",
 /* 330 */ "signed_literal ::= NK_STRING",
 /* 331 */ "signed_literal ::= NK_BOOL",
 /* 332 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 333 */ "signed_literal ::= duration_literal",
 /* 334 */ "signed_literal ::= NULL",
 /* 335 */ "signed_literal ::= literal_func",
 /* 336 */ "signed_literal ::= NK_QUESTION",
 /* 337 */ "literal_list ::= signed_literal",
 /* 338 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 339 */ "db_name ::= NK_ID",
 /* 340 */ "table_name ::= NK_ID",
 /* 341 */ "column_name ::= NK_ID",
 /* 342 */ "function_name ::= NK_ID",
 /* 343 */ "table_alias ::= NK_ID",
 /* 344 */ "column_alias ::= NK_ID",
 /* 345 */ "user_name ::= NK_ID",
 /* 346 */ "topic_name ::= NK_ID",
 /* 347 */ "stream_name ::= NK_ID",
 /* 348 */ "cgroup_name ::= NK_ID",
 /* 349 */ "expr_or_subquery ::= expression",
 /* 350 */ "expression ::= literal",
 /* 351 */ "expression ::= pseudo_column",
 /* 352 */ "expression ::= column_reference",
 /* 353 */ "expression ::= function_expression",
 /* 354 */ "expression ::= case_when_expression",
 /* 355 */ "expression ::= NK_LP expression NK_RP",
 /* 356 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 357 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 358 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 359 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 360 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 361 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 362 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 363 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 364 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 365 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 366 */ "expression_list ::= expr_or_subquery",
 /* 367 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 368 */ "column_reference ::= column_name",
 /* 369 */ "column_reference ::= table_name NK_DOT column_name",
 /* 370 */ "pseudo_column ::= ROWTS",
 /* 371 */ "pseudo_column ::= TBNAME",
 /* 372 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 373 */ "pseudo_column ::= QSTART",
 /* 374 */ "pseudo_column ::= QEND",
 /* 375 */ "pseudo_column ::= QDURATION",
 /* 376 */ "pseudo_column ::= WSTART",
 /* 377 */ "pseudo_column ::= WEND",
 /* 378 */ "pseudo_column ::= WDURATION",
 /* 379 */ "pseudo_column ::= IROWTS",
 /* 380 */ "pseudo_column ::= QTAGS",
 /* 381 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 382 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 383 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 384 */ "function_expression ::= literal_func",
 /* 385 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 386 */ "literal_func ::= NOW",
 /* 387 */ "noarg_func ::= NOW",
 /* 388 */ "noarg_func ::= TODAY",
 /* 389 */ "noarg_func ::= TIMEZONE",
 /* 390 */ "noarg_func ::= DATABASE",
 /* 391 */ "noarg_func ::= CLIENT_VERSION",
 /* 392 */ "noarg_func ::= SERVER_VERSION",
 /* 393 */ "noarg_func ::= SERVER_STATUS",
 /* 394 */ "noarg_func ::= CURRENT_USER",
 /* 395 */ "noarg_func ::= USER",
 /* 396 */ "star_func ::= COUNT",
 /* 397 */ "star_func ::= FIRST",
 /* 398 */ "star_func ::= LAST",
 /* 399 */ "star_func ::= LAST_ROW",
 /* 400 */ "star_func_para_list ::= NK_STAR",
 /* 401 */ "star_func_para_list ::= other_para_list",
 /* 402 */ "other_para_list ::= star_func_para",
 /* 403 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 404 */ "star_func_para ::= expr_or_subquery",
 /* 405 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 406 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 407 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 408 */ "when_then_list ::= when_then_expr",
 /* 409 */ "when_then_list ::= when_then_list when_then_expr",
 /* 410 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 411 */ "case_when_else_opt ::=",
 /* 412 */ "case_when_else_opt ::= ELSE common_expression",
 /* 413 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 414 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 415 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 416 */ "predicate ::= expr_or_subquery IS NULL",
 /* 417 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 418 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 419 */ "compare_op ::= NK_LT",
 /* 420 */ "compare_op ::= NK_GT",
 /* 421 */ "compare_op ::= NK_LE",
 /* 422 */ "compare_op ::= NK_GE",
 /* 423 */ "compare_op ::= NK_NE",
 /* 424 */ "compare_op ::= NK_EQ",
 /* 425 */ "compare_op ::= LIKE",
 /* 426 */ "compare_op ::= NOT LIKE",
 /* 427 */ "compare_op ::= MATCH",
 /* 428 */ "compare_op ::= NMATCH",
 /* 429 */ "compare_op ::= CONTAINS",
 /* 430 */ "in_op ::= IN",
 /* 431 */ "in_op ::= NOT IN",
 /* 432 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 433 */ "boolean_value_expression ::= boolean_primary",
 /* 434 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 435 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 436 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 437 */ "boolean_primary ::= predicate",
 /* 438 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 439 */ "common_expression ::= expr_or_subquery",
 /* 440 */ "common_expression ::= boolean_value_expression",
 /* 441 */ "from_clause_opt ::=",
 /* 442 */ "from_clause_opt ::= FROM table_reference_list",
 /* 443 */ "table_reference_list ::= table_reference",
 /* 444 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 445 */ "table_reference ::= table_primary",
 /* 446 */ "table_reference ::= joined_table",
 /* 447 */ "table_primary ::= table_name alias_opt",
 /* 448 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 449 */ "table_primary ::= subquery alias_opt",
 /* 450 */ "table_primary ::= parenthesized_joined_table",
 /* 451 */ "alias_opt ::=",
 /* 452 */ "alias_opt ::= table_alias",
 /* 453 */ "alias_opt ::= AS table_alias",
 /* 454 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 455 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 456 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 457 */ "join_type ::=",
 /* 458 */ "join_type ::= INNER",
 /* 459 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 460 */ "set_quantifier_opt ::=",
 /* 461 */ "set_quantifier_opt ::= DISTINCT",
 /* 462 */ "set_quantifier_opt ::= ALL",
 /* 463 */ "select_list ::= select_item",
 /* 464 */ "select_list ::= select_list NK_COMMA select_item",
 /* 465 */ "select_item ::= NK_STAR",
 /* 466 */ "select_item ::= common_expression",
 /* 467 */ "select_item ::= common_expression column_alias",
 /* 468 */ "select_item ::= common_expression AS column_alias",
 /* 469 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 470 */ "where_clause_opt ::=",
 /* 471 */ "where_clause_opt ::= WHERE search_condition",
 /* 472 */ "partition_by_clause_opt ::=",
 /* 473 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 474 */ "partition_list ::= partition_item",
 /* 475 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 476 */ "partition_item ::= expr_or_subquery",
 /* 477 */ "partition_item ::= expr_or_subquery column_alias",
 /* 478 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 479 */ "twindow_clause_opt ::=",
 /* 480 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 481 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 482 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 483 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 484 */ "sliding_opt ::=",
 /* 485 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 486 */ "fill_opt ::=",
 /* 487 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 488 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 489 */ "fill_mode ::= NONE",
 /* 490 */ "fill_mode ::= PREV",
 /* 491 */ "fill_mode ::= NULL",
 /* 492 */ "fill_mode ::= LINEAR",
 /* 493 */ "fill_mode ::= NEXT",
 /* 494 */ "group_by_clause_opt ::=",
 /* 495 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 496 */ "group_by_list ::= expr_or_subquery",
 /* 497 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 498 */ "having_clause_opt ::=",
 /* 499 */ "having_clause_opt ::= HAVING search_condition",
 /* 500 */ "range_opt ::=",
 /* 501 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 502 */ "every_opt ::=",
 /* 503 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 504 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 505 */ "query_simple ::= query_specification",
 /* 506 */ "query_simple ::= union_query_expression",
 /* 507 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 508 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 509 */ "query_simple_or_subquery ::= query_simple",
 /* 510 */ "query_simple_or_subquery ::= subquery",
 /* 511 */ "query_or_subquery ::= query_expression",
 /* 512 */ "query_or_subquery ::= subquery",
 /* 513 */ "order_by_clause_opt ::=",
 /* 514 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 515 */ "slimit_clause_opt ::=",
 /* 516 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 517 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 518 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 519 */ "limit_clause_opt ::=",
 /* 520 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 521 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 522 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 523 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 524 */ "subquery ::= NK_LP subquery NK_RP",
 /* 525 */ "search_condition ::= common_expression",
 /* 526 */ "sort_specification_list ::= sort_specification",
 /* 527 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 528 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 529 */ "ordering_specification_opt ::=",
 /* 530 */ "ordering_specification_opt ::= ASC",
 /* 531 */ "ordering_specification_opt ::= DESC",
 /* 532 */ "null_ordering_opt ::=",
 /* 533 */ "null_ordering_opt ::= NULLS FIRST",
 /* 534 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 319: /* cmd */
    case 322: /* literal */
    case 334: /* db_options */
    case 336: /* alter_db_options */
    case 342: /* retention */
    case 343: /* full_table_name */
    case 346: /* table_options */
    case 350: /* alter_table_clause */
    case 351: /* alter_table_options */
    case 354: /* signed_literal */
    case 355: /* create_subtable_clause */
    case 358: /* drop_table_clause */
    case 361: /* column_def */
    case 365: /* duration_literal */
    case 366: /* rollup_func_name */
    case 368: /* col_name */
    case 369: /* db_name_cond_opt */
    case 370: /* like_pattern_opt */
    case 371: /* table_name_cond */
    case 372: /* from_db_opt */
    case 374: /* tag_item */
    case 376: /* index_options */
    case 378: /* sliding_opt */
    case 379: /* sma_stream_opt */
    case 380: /* func */
    case 381: /* stream_options */
    case 383: /* query_or_subquery */
    case 386: /* explain_options */
    case 390: /* subtable_opt */
    case 391: /* expression */
    case 393: /* where_clause_opt */
    case 394: /* signed */
    case 395: /* literal_func */
    case 398: /* expr_or_subquery */
    case 399: /* pseudo_column */
    case 400: /* column_reference */
    case 401: /* function_expression */
    case 402: /* case_when_expression */
    case 407: /* star_func_para */
    case 409: /* case_when_else_opt */
    case 410: /* common_expression */
    case 411: /* when_then_expr */
    case 412: /* predicate */
    case 415: /* in_predicate_value */
    case 416: /* boolean_value_expression */
    case 417: /* boolean_primary */
    case 418: /* from_clause_opt */
    case 419: /* table_reference_list */
    case 420: /* table_reference */
    case 421: /* table_primary */
    case 422: /* joined_table */
    case 424: /* subquery */
    case 425: /* parenthesized_joined_table */
    case 427: /* search_condition */
    case 428: /* query_specification */
    case 432: /* range_opt */
    case 433: /* every_opt */
    case 434: /* fill_opt */
    case 435: /* twindow_clause_opt */
    case 437: /* having_clause_opt */
    case 438: /* select_item */
    case 440: /* partition_item */
    case 443: /* query_expression */
    case 444: /* query_simple */
    case 446: /* slimit_clause_opt */
    case 447: /* limit_clause_opt */
    case 448: /* union_query_expression */
    case 449: /* query_simple_or_subquery */
    case 451: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy164)); 
}
      break;
    case 320: /* account_options */
    case 321: /* alter_account_options */
    case 323: /* alter_account_option */
    case 337: /* speed_opt */
    case 388: /* bufsize_opt */
{
 
}
      break;
    case 324: /* user_name */
    case 327: /* priv_level */
    case 330: /* db_name */
    case 331: /* dnode_endpoint */
    case 352: /* column_name */
    case 360: /* table_name */
    case 367: /* function_name */
    case 375: /* column_alias */
    case 382: /* topic_name */
    case 384: /* cgroup_name */
    case 389: /* stream_name */
    case 397: /* table_alias */
    case 403: /* star_func */
    case 405: /* noarg_func */
    case 423: /* alias_opt */
{
 
}
      break;
    case 325: /* sysinfo_opt */
{
 
}
      break;
    case 326: /* privileges */
    case 328: /* priv_type_list */
    case 329: /* priv_type */
{
 
}
      break;
    case 332: /* force_opt */
    case 333: /* not_exists_opt */
    case 335: /* exists_opt */
    case 385: /* analyze_opt */
    case 387: /* agg_func_opt */
    case 429: /* set_quantifier_opt */
{
 
}
      break;
    case 338: /* integer_list */
    case 339: /* variable_list */
    case 340: /* retention_list */
    case 344: /* column_def_list */
    case 345: /* tags_def_opt */
    case 347: /* multi_create_clause */
    case 348: /* tags_def */
    case 349: /* multi_drop_clause */
    case 356: /* specific_cols_opt */
    case 357: /* expression_list */
    case 359: /* col_name_list */
    case 362: /* duration_list */
    case 363: /* rollup_func_list */
    case 373: /* tag_list_opt */
    case 377: /* func_list */
    case 392: /* dnode_list */
    case 396: /* literal_list */
    case 404: /* star_func_para_list */
    case 406: /* other_para_list */
    case 408: /* when_then_list */
    case 430: /* select_list */
    case 431: /* partition_by_clause_opt */
    case 436: /* group_by_clause_opt */
    case 439: /* partition_list */
    case 442: /* group_by_list */
    case 445: /* order_by_clause_opt */
    case 450: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy648)); 
}
      break;
    case 341: /* alter_db_option */
    case 364: /* alter_table_option */
{
 
}
      break;
    case 353: /* type_name */
{
 
}
      break;
    case 413: /* compare_op */
    case 414: /* in_op */
{
 
}
      break;
    case 426: /* join_type */
{
 
}
      break;
    case 441: /* fill_mode */
{
 
}
      break;
    case 452: /* ordering_specification_opt */
{
 
}
      break;
    case 453: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  319,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  319,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  320,    0 }, /* (2) account_options ::= */
  {  320,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  320,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  320,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  320,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  320,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  320,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  320,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  320,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  320,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  321,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  321,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  323,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  323,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  323,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  323,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  323,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  323,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  323,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  323,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  323,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  323,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  319,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  319,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  319,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  319,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  319,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  325,    0 }, /* (29) sysinfo_opt ::= */
  {  325,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  319,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  319,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  326,   -1 }, /* (33) privileges ::= ALL */
  {  326,   -1 }, /* (34) privileges ::= priv_type_list */
  {  328,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  328,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  329,   -1 }, /* (37) priv_type ::= READ */
  {  329,   -1 }, /* (38) priv_type ::= WRITE */
  {  327,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  327,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  319,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  319,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  319,   -4 }, /* (43) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  319,   -4 }, /* (44) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  319,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  319,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  319,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  319,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  331,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  331,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  331,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  332,    0 }, /* (52) force_opt ::= */
  {  332,   -1 }, /* (53) force_opt ::= FORCE */
  {  319,   -3 }, /* (54) cmd ::= ALTER LOCAL NK_STRING */
  {  319,   -4 }, /* (55) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  319,   -5 }, /* (56) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (57) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (58) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (59) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (60) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (61) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (62) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (63) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  319,   -5 }, /* (64) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  319,   -4 }, /* (65) cmd ::= DROP DATABASE exists_opt db_name */
  {  319,   -2 }, /* (66) cmd ::= USE db_name */
  {  319,   -4 }, /* (67) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  319,   -3 }, /* (68) cmd ::= FLUSH DATABASE db_name */
  {  319,   -4 }, /* (69) cmd ::= TRIM DATABASE db_name speed_opt */
  {  333,   -3 }, /* (70) not_exists_opt ::= IF NOT EXISTS */
  {  333,    0 }, /* (71) not_exists_opt ::= */
  {  335,   -2 }, /* (72) exists_opt ::= IF EXISTS */
  {  335,    0 }, /* (73) exists_opt ::= */
  {  334,    0 }, /* (74) db_options ::= */
  {  334,   -3 }, /* (75) db_options ::= db_options BUFFER NK_INTEGER */
  {  334,   -3 }, /* (76) db_options ::= db_options CACHEMODEL NK_STRING */
  {  334,   -3 }, /* (77) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  334,   -3 }, /* (78) db_options ::= db_options COMP NK_INTEGER */
  {  334,   -3 }, /* (79) db_options ::= db_options DURATION NK_INTEGER */
  {  334,   -3 }, /* (80) db_options ::= db_options DURATION NK_VARIABLE */
  {  334,   -3 }, /* (81) db_options ::= db_options MAXROWS NK_INTEGER */
  {  334,   -3 }, /* (82) db_options ::= db_options MINROWS NK_INTEGER */
  {  334,   -3 }, /* (83) db_options ::= db_options KEEP integer_list */
  {  334,   -3 }, /* (84) db_options ::= db_options KEEP variable_list */
  {  334,   -3 }, /* (85) db_options ::= db_options PAGES NK_INTEGER */
  {  334,   -3 }, /* (86) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  334,   -3 }, /* (87) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  334,   -3 }, /* (88) db_options ::= db_options PRECISION NK_STRING */
  {  334,   -3 }, /* (89) db_options ::= db_options REPLICA NK_INTEGER */
  {  334,   -3 }, /* (90) db_options ::= db_options STRICT NK_STRING */
  {  334,   -3 }, /* (91) db_options ::= db_options VGROUPS NK_INTEGER */
  {  334,   -3 }, /* (92) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  334,   -3 }, /* (93) db_options ::= db_options RETENTIONS retention_list */
  {  334,   -3 }, /* (94) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  334,   -3 }, /* (95) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  334,   -3 }, /* (96) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  334,   -3 }, /* (97) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  334,   -4 }, /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  334,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  334,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  334,   -3 }, /* (101) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  334,   -3 }, /* (102) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  334,   -3 }, /* (103) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  334,   -3 }, /* (104) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  334,   -3 }, /* (105) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  336,   -1 }, /* (106) alter_db_options ::= alter_db_option */
  {  336,   -2 }, /* (107) alter_db_options ::= alter_db_options alter_db_option */
  {  341,   -2 }, /* (108) alter_db_option ::= BUFFER NK_INTEGER */
  {  341,   -2 }, /* (109) alter_db_option ::= CACHEMODEL NK_STRING */
  {  341,   -2 }, /* (110) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  341,   -2 }, /* (111) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  341,   -2 }, /* (112) alter_db_option ::= KEEP integer_list */
  {  341,   -2 }, /* (113) alter_db_option ::= KEEP variable_list */
  {  341,   -2 }, /* (114) alter_db_option ::= PAGES NK_INTEGER */
  {  341,   -2 }, /* (115) alter_db_option ::= REPLICA NK_INTEGER */
  {  341,   -2 }, /* (116) alter_db_option ::= STRICT NK_STRING */
  {  341,   -2 }, /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  341,   -2 }, /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  338,   -1 }, /* (119) integer_list ::= NK_INTEGER */
  {  338,   -3 }, /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  339,   -1 }, /* (121) variable_list ::= NK_VARIABLE */
  {  339,   -3 }, /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  340,   -1 }, /* (123) retention_list ::= retention */
  {  340,   -3 }, /* (124) retention_list ::= retention_list NK_COMMA retention */
  {  342,   -3 }, /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  337,    0 }, /* (126) speed_opt ::= */
  {  337,   -2 }, /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  319,   -9 }, /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  319,   -3 }, /* (129) cmd ::= CREATE TABLE multi_create_clause */
  {  319,   -9 }, /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  319,   -3 }, /* (131) cmd ::= DROP TABLE multi_drop_clause */
  {  319,   -4 }, /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
  {  319,   -3 }, /* (133) cmd ::= ALTER TABLE alter_table_clause */
  {  319,   -3 }, /* (134) cmd ::= ALTER STABLE alter_table_clause */
  {  350,   -2 }, /* (135) alter_table_clause ::= full_table_name alter_table_options */
  {  350,   -5 }, /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  350,   -4 }, /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  350,   -5 }, /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  350,   -5 }, /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  350,   -5 }, /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  350,   -4 }, /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  350,   -5 }, /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  350,   -5 }, /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  350,   -6 }, /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  347,   -1 }, /* (145) multi_create_clause ::= create_subtable_clause */
  {  347,   -2 }, /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  355,  -10 }, /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  349,   -1 }, /* (148) multi_drop_clause ::= drop_table_clause */
  {  349,   -2 }, /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  358,   -2 }, /* (150) drop_table_clause ::= exists_opt full_table_name */
  {  356,    0 }, /* (151) specific_cols_opt ::= */
  {  356,   -3 }, /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  343,   -1 }, /* (153) full_table_name ::= table_name */
  {  343,   -3 }, /* (154) full_table_name ::= db_name NK_DOT table_name */
  {  344,   -1 }, /* (155) column_def_list ::= column_def */
  {  344,   -3 }, /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
  {  361,   -2 }, /* (157) column_def ::= column_name type_name */
  {  361,   -4 }, /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
  {  353,   -1 }, /* (159) type_name ::= BOOL */
  {  353,   -1 }, /* (160) type_name ::= TINYINT */
  {  353,   -1 }, /* (161) type_name ::= SMALLINT */
  {  353,   -1 }, /* (162) type_name ::= INT */
  {  353,   -1 }, /* (163) type_name ::= INTEGER */
  {  353,   -1 }, /* (164) type_name ::= BIGINT */
  {  353,   -1 }, /* (165) type_name ::= FLOAT */
  {  353,   -1 }, /* (166) type_name ::= DOUBLE */
  {  353,   -4 }, /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  353,   -1 }, /* (168) type_name ::= TIMESTAMP */
  {  353,   -4 }, /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  353,   -2 }, /* (170) type_name ::= TINYINT UNSIGNED */
  {  353,   -2 }, /* (171) type_name ::= SMALLINT UNSIGNED */
  {  353,   -2 }, /* (172) type_name ::= INT UNSIGNED */
  {  353,   -2 }, /* (173) type_name ::= BIGINT UNSIGNED */
  {  353,   -1 }, /* (174) type_name ::= JSON */
  {  353,   -4 }, /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  353,   -1 }, /* (176) type_name ::= MEDIUMBLOB */
  {  353,   -1 }, /* (177) type_name ::= BLOB */
  {  353,   -4 }, /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  353,   -1 }, /* (179) type_name ::= DECIMAL */
  {  353,   -4 }, /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  353,   -6 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  345,    0 }, /* (182) tags_def_opt ::= */
  {  345,   -1 }, /* (183) tags_def_opt ::= tags_def */
  {  348,   -4 }, /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  346,    0 }, /* (185) table_options ::= */
  {  346,   -3 }, /* (186) table_options ::= table_options COMMENT NK_STRING */
  {  346,   -3 }, /* (187) table_options ::= table_options MAX_DELAY duration_list */
  {  346,   -3 }, /* (188) table_options ::= table_options WATERMARK duration_list */
  {  346,   -5 }, /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  346,   -3 }, /* (190) table_options ::= table_options TTL NK_INTEGER */
  {  346,   -5 }, /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  351,   -1 }, /* (192) alter_table_options ::= alter_table_option */
  {  351,   -2 }, /* (193) alter_table_options ::= alter_table_options alter_table_option */
  {  364,   -2 }, /* (194) alter_table_option ::= COMMENT NK_STRING */
  {  364,   -2 }, /* (195) alter_table_option ::= TTL NK_INTEGER */
  {  362,   -1 }, /* (196) duration_list ::= duration_literal */
  {  362,   -3 }, /* (197) duration_list ::= duration_list NK_COMMA duration_literal */
  {  363,   -1 }, /* (198) rollup_func_list ::= rollup_func_name */
  {  363,   -3 }, /* (199) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  366,   -1 }, /* (200) rollup_func_name ::= function_name */
  {  366,   -1 }, /* (201) rollup_func_name ::= FIRST */
  {  366,   -1 }, /* (202) rollup_func_name ::= LAST */
  {  359,   -1 }, /* (203) col_name_list ::= col_name */
  {  359,   -3 }, /* (204) col_name_list ::= col_name_list NK_COMMA col_name */
  {  368,   -1 }, /* (205) col_name ::= column_name */
  {  319,   -2 }, /* (206) cmd ::= SHOW DNODES */
  {  319,   -2 }, /* (207) cmd ::= SHOW USERS */
  {  319,   -2 }, /* (208) cmd ::= SHOW DATABASES */
  {  319,   -4 }, /* (209) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  319,   -4 }, /* (210) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  319,   -3 }, /* (211) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  319,   -2 }, /* (212) cmd ::= SHOW MNODES */
  {  319,   -2 }, /* (213) cmd ::= SHOW QNODES */
  {  319,   -2 }, /* (214) cmd ::= SHOW FUNCTIONS */
  {  319,   -5 }, /* (215) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  319,   -2 }, /* (216) cmd ::= SHOW STREAMS */
  {  319,   -2 }, /* (217) cmd ::= SHOW ACCOUNTS */
  {  319,   -2 }, /* (218) cmd ::= SHOW APPS */
  {  319,   -2 }, /* (219) cmd ::= SHOW CONNECTIONS */
  {  319,   -2 }, /* (220) cmd ::= SHOW LICENCES */
  {  319,   -2 }, /* (221) cmd ::= SHOW GRANTS */
  {  319,   -4 }, /* (222) cmd ::= SHOW CREATE DATABASE db_name */
  {  319,   -4 }, /* (223) cmd ::= SHOW CREATE TABLE full_table_name */
  {  319,   -4 }, /* (224) cmd ::= SHOW CREATE STABLE full_table_name */
  {  319,   -2 }, /* (225) cmd ::= SHOW QUERIES */
  {  319,   -2 }, /* (226) cmd ::= SHOW SCORES */
  {  319,   -2 }, /* (227) cmd ::= SHOW TOPICS */
  {  319,   -2 }, /* (228) cmd ::= SHOW VARIABLES */
  {  319,   -3 }, /* (229) cmd ::= SHOW CLUSTER VARIABLES */
  {  319,   -3 }, /* (230) cmd ::= SHOW LOCAL VARIABLES */
  {  319,   -5 }, /* (231) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  319,   -2 }, /* (232) cmd ::= SHOW BNODES */
  {  319,   -2 }, /* (233) cmd ::= SHOW SNODES */
  {  319,   -2 }, /* (234) cmd ::= SHOW CLUSTER */
  {  319,   -2 }, /* (235) cmd ::= SHOW TRANSACTIONS */
  {  319,   -4 }, /* (236) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  319,   -2 }, /* (237) cmd ::= SHOW CONSUMERS */
  {  319,   -2 }, /* (238) cmd ::= SHOW SUBSCRIPTIONS */
  {  319,   -5 }, /* (239) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  319,   -7 }, /* (240) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  319,   -3 }, /* (241) cmd ::= SHOW VNODES NK_INTEGER */
  {  319,   -3 }, /* (242) cmd ::= SHOW VNODES NK_STRING */
  {  369,    0 }, /* (243) db_name_cond_opt ::= */
  {  369,   -2 }, /* (244) db_name_cond_opt ::= db_name NK_DOT */
  {  370,    0 }, /* (245) like_pattern_opt ::= */
  {  370,   -2 }, /* (246) like_pattern_opt ::= LIKE NK_STRING */
  {  371,   -1 }, /* (247) table_name_cond ::= table_name */
  {  372,    0 }, /* (248) from_db_opt ::= */
  {  372,   -2 }, /* (249) from_db_opt ::= FROM db_name */
  {  373,    0 }, /* (250) tag_list_opt ::= */
  {  373,   -1 }, /* (251) tag_list_opt ::= tag_item */
  {  373,   -3 }, /* (252) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  374,   -1 }, /* (253) tag_item ::= TBNAME */
  {  374,   -1 }, /* (254) tag_item ::= QTAGS */
  {  374,   -1 }, /* (255) tag_item ::= column_name */
  {  374,   -2 }, /* (256) tag_item ::= column_name column_alias */
  {  374,   -3 }, /* (257) tag_item ::= column_name AS column_alias */
  {  319,   -8 }, /* (258) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  319,   -4 }, /* (259) cmd ::= DROP INDEX exists_opt full_table_name */
  {  376,  -10 }, /* (260) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  376,  -12 }, /* (261) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  377,   -1 }, /* (262) func_list ::= func */
  {  377,   -3 }, /* (263) func_list ::= func_list NK_COMMA func */
  {  380,   -4 }, /* (264) func ::= function_name NK_LP expression_list NK_RP */
  {  379,    0 }, /* (265) sma_stream_opt ::= */
  {  379,   -3 }, /* (266) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  379,   -3 }, /* (267) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  319,   -6 }, /* (268) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  319,   -7 }, /* (269) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  319,   -9 }, /* (270) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  319,   -7 }, /* (271) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  319,   -9 }, /* (272) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  319,   -4 }, /* (273) cmd ::= DROP TOPIC exists_opt topic_name */
  {  319,   -7 }, /* (274) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  319,   -2 }, /* (275) cmd ::= DESC full_table_name */
  {  319,   -2 }, /* (276) cmd ::= DESCRIBE full_table_name */
  {  319,   -3 }, /* (277) cmd ::= RESET QUERY CACHE */
  {  319,   -4 }, /* (278) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  385,    0 }, /* (279) analyze_opt ::= */
  {  385,   -1 }, /* (280) analyze_opt ::= ANALYZE */
  {  386,    0 }, /* (281) explain_options ::= */
  {  386,   -3 }, /* (282) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  386,   -3 }, /* (283) explain_options ::= explain_options RATIO NK_FLOAT */
  {  319,  -10 }, /* (284) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  319,   -4 }, /* (285) cmd ::= DROP FUNCTION exists_opt function_name */
  {  387,    0 }, /* (286) agg_func_opt ::= */
  {  387,   -1 }, /* (287) agg_func_opt ::= AGGREGATE */
  {  388,    0 }, /* (288) bufsize_opt ::= */
  {  388,   -2 }, /* (289) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  319,  -11 }, /* (290) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
  {  319,   -4 }, /* (291) cmd ::= DROP STREAM exists_opt stream_name */
  {  381,    0 }, /* (292) stream_options ::= */
  {  381,   -3 }, /* (293) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  381,   -3 }, /* (294) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  381,   -4 }, /* (295) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  381,   -3 }, /* (296) stream_options ::= stream_options WATERMARK duration_literal */
  {  381,   -4 }, /* (297) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  381,   -3 }, /* (298) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  390,    0 }, /* (299) subtable_opt ::= */
  {  390,   -4 }, /* (300) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  319,   -3 }, /* (301) cmd ::= KILL CONNECTION NK_INTEGER */
  {  319,   -3 }, /* (302) cmd ::= KILL QUERY NK_STRING */
  {  319,   -3 }, /* (303) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  319,   -2 }, /* (304) cmd ::= BALANCE VGROUP */
  {  319,   -4 }, /* (305) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  319,   -4 }, /* (306) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  319,   -3 }, /* (307) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  392,   -2 }, /* (308) dnode_list ::= DNODE NK_INTEGER */
  {  392,   -3 }, /* (309) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  319,   -4 }, /* (310) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  319,   -1 }, /* (311) cmd ::= query_or_subquery */
  {  319,   -7 }, /* (312) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  319,   -4 }, /* (313) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  322,   -1 }, /* (314) literal ::= NK_INTEGER */
  {  322,   -1 }, /* (315) literal ::= NK_FLOAT */
  {  322,   -1 }, /* (316) literal ::= NK_STRING */
  {  322,   -1 }, /* (317) literal ::= NK_BOOL */
  {  322,   -2 }, /* (318) literal ::= TIMESTAMP NK_STRING */
  {  322,   -1 }, /* (319) literal ::= duration_literal */
  {  322,   -1 }, /* (320) literal ::= NULL */
  {  322,   -1 }, /* (321) literal ::= NK_QUESTION */
  {  365,   -1 }, /* (322) duration_literal ::= NK_VARIABLE */
  {  394,   -1 }, /* (323) signed ::= NK_INTEGER */
  {  394,   -2 }, /* (324) signed ::= NK_PLUS NK_INTEGER */
  {  394,   -2 }, /* (325) signed ::= NK_MINUS NK_INTEGER */
  {  394,   -1 }, /* (326) signed ::= NK_FLOAT */
  {  394,   -2 }, /* (327) signed ::= NK_PLUS NK_FLOAT */
  {  394,   -2 }, /* (328) signed ::= NK_MINUS NK_FLOAT */
  {  354,   -1 }, /* (329) signed_literal ::= signed */
  {  354,   -1 }, /* (330) signed_literal ::= NK_STRING */
  {  354,   -1 }, /* (331) signed_literal ::= NK_BOOL */
  {  354,   -2 }, /* (332) signed_literal ::= TIMESTAMP NK_STRING */
  {  354,   -1 }, /* (333) signed_literal ::= duration_literal */
  {  354,   -1 }, /* (334) signed_literal ::= NULL */
  {  354,   -1 }, /* (335) signed_literal ::= literal_func */
  {  354,   -1 }, /* (336) signed_literal ::= NK_QUESTION */
  {  396,   -1 }, /* (337) literal_list ::= signed_literal */
  {  396,   -3 }, /* (338) literal_list ::= literal_list NK_COMMA signed_literal */
  {  330,   -1 }, /* (339) db_name ::= NK_ID */
  {  360,   -1 }, /* (340) table_name ::= NK_ID */
  {  352,   -1 }, /* (341) column_name ::= NK_ID */
  {  367,   -1 }, /* (342) function_name ::= NK_ID */
  {  397,   -1 }, /* (343) table_alias ::= NK_ID */
  {  375,   -1 }, /* (344) column_alias ::= NK_ID */
  {  324,   -1 }, /* (345) user_name ::= NK_ID */
  {  382,   -1 }, /* (346) topic_name ::= NK_ID */
  {  389,   -1 }, /* (347) stream_name ::= NK_ID */
  {  384,   -1 }, /* (348) cgroup_name ::= NK_ID */
  {  398,   -1 }, /* (349) expr_or_subquery ::= expression */
  {  391,   -1 }, /* (350) expression ::= literal */
  {  391,   -1 }, /* (351) expression ::= pseudo_column */
  {  391,   -1 }, /* (352) expression ::= column_reference */
  {  391,   -1 }, /* (353) expression ::= function_expression */
  {  391,   -1 }, /* (354) expression ::= case_when_expression */
  {  391,   -3 }, /* (355) expression ::= NK_LP expression NK_RP */
  {  391,   -2 }, /* (356) expression ::= NK_PLUS expr_or_subquery */
  {  391,   -2 }, /* (357) expression ::= NK_MINUS expr_or_subquery */
  {  391,   -3 }, /* (358) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  391,   -3 }, /* (359) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  391,   -3 }, /* (360) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  391,   -3 }, /* (361) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  391,   -3 }, /* (362) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  391,   -3 }, /* (363) expression ::= column_reference NK_ARROW NK_STRING */
  {  391,   -3 }, /* (364) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  391,   -3 }, /* (365) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  357,   -1 }, /* (366) expression_list ::= expr_or_subquery */
  {  357,   -3 }, /* (367) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  400,   -1 }, /* (368) column_reference ::= column_name */
  {  400,   -3 }, /* (369) column_reference ::= table_name NK_DOT column_name */
  {  399,   -1 }, /* (370) pseudo_column ::= ROWTS */
  {  399,   -1 }, /* (371) pseudo_column ::= TBNAME */
  {  399,   -3 }, /* (372) pseudo_column ::= table_name NK_DOT TBNAME */
  {  399,   -1 }, /* (373) pseudo_column ::= QSTART */
  {  399,   -1 }, /* (374) pseudo_column ::= QEND */
  {  399,   -1 }, /* (375) pseudo_column ::= QDURATION */
  {  399,   -1 }, /* (376) pseudo_column ::= WSTART */
  {  399,   -1 }, /* (377) pseudo_column ::= WEND */
  {  399,   -1 }, /* (378) pseudo_column ::= WDURATION */
  {  399,   -1 }, /* (379) pseudo_column ::= IROWTS */
  {  399,   -1 }, /* (380) pseudo_column ::= QTAGS */
  {  401,   -4 }, /* (381) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  401,   -4 }, /* (382) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  401,   -6 }, /* (383) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  401,   -1 }, /* (384) function_expression ::= literal_func */
  {  395,   -3 }, /* (385) literal_func ::= noarg_func NK_LP NK_RP */
  {  395,   -1 }, /* (386) literal_func ::= NOW */
  {  405,   -1 }, /* (387) noarg_func ::= NOW */
  {  405,   -1 }, /* (388) noarg_func ::= TODAY */
  {  405,   -1 }, /* (389) noarg_func ::= TIMEZONE */
  {  405,   -1 }, /* (390) noarg_func ::= DATABASE */
  {  405,   -1 }, /* (391) noarg_func ::= CLIENT_VERSION */
  {  405,   -1 }, /* (392) noarg_func ::= SERVER_VERSION */
  {  405,   -1 }, /* (393) noarg_func ::= SERVER_STATUS */
  {  405,   -1 }, /* (394) noarg_func ::= CURRENT_USER */
  {  405,   -1 }, /* (395) noarg_func ::= USER */
  {  403,   -1 }, /* (396) star_func ::= COUNT */
  {  403,   -1 }, /* (397) star_func ::= FIRST */
  {  403,   -1 }, /* (398) star_func ::= LAST */
  {  403,   -1 }, /* (399) star_func ::= LAST_ROW */
  {  404,   -1 }, /* (400) star_func_para_list ::= NK_STAR */
  {  404,   -1 }, /* (401) star_func_para_list ::= other_para_list */
  {  406,   -1 }, /* (402) other_para_list ::= star_func_para */
  {  406,   -3 }, /* (403) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  407,   -1 }, /* (404) star_func_para ::= expr_or_subquery */
  {  407,   -3 }, /* (405) star_func_para ::= table_name NK_DOT NK_STAR */
  {  402,   -4 }, /* (406) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  402,   -5 }, /* (407) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  408,   -1 }, /* (408) when_then_list ::= when_then_expr */
  {  408,   -2 }, /* (409) when_then_list ::= when_then_list when_then_expr */
  {  411,   -4 }, /* (410) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  409,    0 }, /* (411) case_when_else_opt ::= */
  {  409,   -2 }, /* (412) case_when_else_opt ::= ELSE common_expression */
  {  412,   -3 }, /* (413) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  412,   -5 }, /* (414) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  412,   -6 }, /* (415) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  412,   -3 }, /* (416) predicate ::= expr_or_subquery IS NULL */
  {  412,   -4 }, /* (417) predicate ::= expr_or_subquery IS NOT NULL */
  {  412,   -3 }, /* (418) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  413,   -1 }, /* (419) compare_op ::= NK_LT */
  {  413,   -1 }, /* (420) compare_op ::= NK_GT */
  {  413,   -1 }, /* (421) compare_op ::= NK_LE */
  {  413,   -1 }, /* (422) compare_op ::= NK_GE */
  {  413,   -1 }, /* (423) compare_op ::= NK_NE */
  {  413,   -1 }, /* (424) compare_op ::= NK_EQ */
  {  413,   -1 }, /* (425) compare_op ::= LIKE */
  {  413,   -2 }, /* (426) compare_op ::= NOT LIKE */
  {  413,   -1 }, /* (427) compare_op ::= MATCH */
  {  413,   -1 }, /* (428) compare_op ::= NMATCH */
  {  413,   -1 }, /* (429) compare_op ::= CONTAINS */
  {  414,   -1 }, /* (430) in_op ::= IN */
  {  414,   -2 }, /* (431) in_op ::= NOT IN */
  {  415,   -3 }, /* (432) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  416,   -1 }, /* (433) boolean_value_expression ::= boolean_primary */
  {  416,   -2 }, /* (434) boolean_value_expression ::= NOT boolean_primary */
  {  416,   -3 }, /* (435) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  416,   -3 }, /* (436) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  417,   -1 }, /* (437) boolean_primary ::= predicate */
  {  417,   -3 }, /* (438) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  410,   -1 }, /* (439) common_expression ::= expr_or_subquery */
  {  410,   -1 }, /* (440) common_expression ::= boolean_value_expression */
  {  418,    0 }, /* (441) from_clause_opt ::= */
  {  418,   -2 }, /* (442) from_clause_opt ::= FROM table_reference_list */
  {  419,   -1 }, /* (443) table_reference_list ::= table_reference */
  {  419,   -3 }, /* (444) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  420,   -1 }, /* (445) table_reference ::= table_primary */
  {  420,   -1 }, /* (446) table_reference ::= joined_table */
  {  421,   -2 }, /* (447) table_primary ::= table_name alias_opt */
  {  421,   -4 }, /* (448) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  421,   -2 }, /* (449) table_primary ::= subquery alias_opt */
  {  421,   -1 }, /* (450) table_primary ::= parenthesized_joined_table */
  {  423,    0 }, /* (451) alias_opt ::= */
  {  423,   -1 }, /* (452) alias_opt ::= table_alias */
  {  423,   -2 }, /* (453) alias_opt ::= AS table_alias */
  {  425,   -3 }, /* (454) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  425,   -3 }, /* (455) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  422,   -6 }, /* (456) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  426,    0 }, /* (457) join_type ::= */
  {  426,   -1 }, /* (458) join_type ::= INNER */
  {  428,  -12 }, /* (459) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  429,    0 }, /* (460) set_quantifier_opt ::= */
  {  429,   -1 }, /* (461) set_quantifier_opt ::= DISTINCT */
  {  429,   -1 }, /* (462) set_quantifier_opt ::= ALL */
  {  430,   -1 }, /* (463) select_list ::= select_item */
  {  430,   -3 }, /* (464) select_list ::= select_list NK_COMMA select_item */
  {  438,   -1 }, /* (465) select_item ::= NK_STAR */
  {  438,   -1 }, /* (466) select_item ::= common_expression */
  {  438,   -2 }, /* (467) select_item ::= common_expression column_alias */
  {  438,   -3 }, /* (468) select_item ::= common_expression AS column_alias */
  {  438,   -3 }, /* (469) select_item ::= table_name NK_DOT NK_STAR */
  {  393,    0 }, /* (470) where_clause_opt ::= */
  {  393,   -2 }, /* (471) where_clause_opt ::= WHERE search_condition */
  {  431,    0 }, /* (472) partition_by_clause_opt ::= */
  {  431,   -3 }, /* (473) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  439,   -1 }, /* (474) partition_list ::= partition_item */
  {  439,   -3 }, /* (475) partition_list ::= partition_list NK_COMMA partition_item */
  {  440,   -1 }, /* (476) partition_item ::= expr_or_subquery */
  {  440,   -2 }, /* (477) partition_item ::= expr_or_subquery column_alias */
  {  440,   -3 }, /* (478) partition_item ::= expr_or_subquery AS column_alias */
  {  435,    0 }, /* (479) twindow_clause_opt ::= */
  {  435,   -6 }, /* (480) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  435,   -4 }, /* (481) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  435,   -6 }, /* (482) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  435,   -8 }, /* (483) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  378,    0 }, /* (484) sliding_opt ::= */
  {  378,   -4 }, /* (485) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  434,    0 }, /* (486) fill_opt ::= */
  {  434,   -4 }, /* (487) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  434,   -6 }, /* (488) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  441,   -1 }, /* (489) fill_mode ::= NONE */
  {  441,   -1 }, /* (490) fill_mode ::= PREV */
  {  441,   -1 }, /* (491) fill_mode ::= NULL */
  {  441,   -1 }, /* (492) fill_mode ::= LINEAR */
  {  441,   -1 }, /* (493) fill_mode ::= NEXT */
  {  436,    0 }, /* (494) group_by_clause_opt ::= */
  {  436,   -3 }, /* (495) group_by_clause_opt ::= GROUP BY group_by_list */
  {  442,   -1 }, /* (496) group_by_list ::= expr_or_subquery */
  {  442,   -3 }, /* (497) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  437,    0 }, /* (498) having_clause_opt ::= */
  {  437,   -2 }, /* (499) having_clause_opt ::= HAVING search_condition */
  {  432,    0 }, /* (500) range_opt ::= */
  {  432,   -6 }, /* (501) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  433,    0 }, /* (502) every_opt ::= */
  {  433,   -4 }, /* (503) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  443,   -4 }, /* (504) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  444,   -1 }, /* (505) query_simple ::= query_specification */
  {  444,   -1 }, /* (506) query_simple ::= union_query_expression */
  {  448,   -4 }, /* (507) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  448,   -3 }, /* (508) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  449,   -1 }, /* (509) query_simple_or_subquery ::= query_simple */
  {  449,   -1 }, /* (510) query_simple_or_subquery ::= subquery */
  {  383,   -1 }, /* (511) query_or_subquery ::= query_expression */
  {  383,   -1 }, /* (512) query_or_subquery ::= subquery */
  {  445,    0 }, /* (513) order_by_clause_opt ::= */
  {  445,   -3 }, /* (514) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  446,    0 }, /* (515) slimit_clause_opt ::= */
  {  446,   -2 }, /* (516) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  446,   -4 }, /* (517) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  446,   -4 }, /* (518) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  447,    0 }, /* (519) limit_clause_opt ::= */
  {  447,   -2 }, /* (520) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  447,   -4 }, /* (521) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  447,   -4 }, /* (522) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  424,   -3 }, /* (523) subquery ::= NK_LP query_expression NK_RP */
  {  424,   -3 }, /* (524) subquery ::= NK_LP subquery NK_RP */
  {  427,   -1 }, /* (525) search_condition ::= common_expression */
  {  450,   -1 }, /* (526) sort_specification_list ::= sort_specification */
  {  450,   -3 }, /* (527) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  451,   -3 }, /* (528) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  452,    0 }, /* (529) ordering_specification_opt ::= */
  {  452,   -1 }, /* (530) ordering_specification_opt ::= ASC */
  {  452,   -1 }, /* (531) ordering_specification_opt ::= DESC */
  {  453,    0 }, /* (532) null_ordering_opt ::= */
  {  453,   -2 }, /* (533) null_ordering_opt ::= NULLS FIRST */
  {  453,   -2 }, /* (534) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,320,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,321,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,320,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,322,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,323,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,321,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,323,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,322,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy593, &yymsp[-1].minor.yy0, yymsp[0].minor.yy687); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy593, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy593, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy593, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy593); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy687 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy687 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy577, &yymsp[-2].minor.yy593, &yymsp[0].minor.yy593); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy577, &yymsp[-2].minor.yy593, &yymsp[0].minor.yy593); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy577 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy577 = yymsp[0].minor.yy577; }
  yymsp[0].minor.yy577 = yylhsminor.yy577;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy577 = yymsp[-2].minor.yy577 | yymsp[0].minor.yy577; }
  yymsp[-2].minor.yy577 = yylhsminor.yy577;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy577 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy577 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy593 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy593 = yylhsminor.yy593;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy593 = yymsp[-2].minor.yy593; }
  yymsp[-2].minor.yy593 = yylhsminor.yy593;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy593, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy593, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy193); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy593, yymsp[0].minor.yy193); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 339: /* db_name ::= NK_ID */ yytestcase(yyruleno==339);
      case 340: /* table_name ::= NK_ID */ yytestcase(yyruleno==340);
      case 341: /* column_name ::= NK_ID */ yytestcase(yyruleno==341);
      case 342: /* function_name ::= NK_ID */ yytestcase(yyruleno==342);
      case 343: /* table_alias ::= NK_ID */ yytestcase(yyruleno==343);
      case 344: /* column_alias ::= NK_ID */ yytestcase(yyruleno==344);
      case 345: /* user_name ::= NK_ID */ yytestcase(yyruleno==345);
      case 346: /* topic_name ::= NK_ID */ yytestcase(yyruleno==346);
      case 347: /* stream_name ::= NK_ID */ yytestcase(yyruleno==347);
      case 348: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==348);
      case 387: /* noarg_func ::= NOW */ yytestcase(yyruleno==387);
      case 388: /* noarg_func ::= TODAY */ yytestcase(yyruleno==388);
      case 389: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==389);
      case 390: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==390);
      case 391: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==391);
      case 392: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==392);
      case 393: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==393);
      case 394: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==394);
      case 395: /* noarg_func ::= USER */ yytestcase(yyruleno==395);
      case 396: /* star_func ::= COUNT */ yytestcase(yyruleno==396);
      case 397: /* star_func ::= FIRST */ yytestcase(yyruleno==397);
      case 398: /* star_func ::= LAST */ yytestcase(yyruleno==398);
      case 399: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==399);
{ yylhsminor.yy593 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy593 = yylhsminor.yy593;
        break;
      case 52: /* force_opt ::= */
      case 71: /* not_exists_opt ::= */ yytestcase(yyruleno==71);
      case 73: /* exists_opt ::= */ yytestcase(yyruleno==73);
      case 279: /* analyze_opt ::= */ yytestcase(yyruleno==279);
      case 286: /* agg_func_opt ::= */ yytestcase(yyruleno==286);
      case 460: /* set_quantifier_opt ::= */ yytestcase(yyruleno==460);
{ yymsp[1].minor.yy193 = false; }
        break;
      case 53: /* force_opt ::= FORCE */
      case 280: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==280);
      case 287: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==287);
      case 461: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==461);
{ yymsp[0].minor.yy193 = true; }
        break;
      case 54: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 55: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy193, &yymsp[-1].minor.yy593, yymsp[0].minor.yy164); }
        break;
      case 65: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy193, &yymsp[0].minor.yy593); }
        break;
      case 66: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy593); }
        break;
      case 67: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy593, yymsp[0].minor.yy164); }
        break;
      case 68: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy593); }
        break;
      case 69: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy593, yymsp[0].minor.yy512); }
        break;
      case 70: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy193 = true; }
        break;
      case 72: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy193 = true; }
        break;
      case 74: /* db_options ::= */
{ yymsp[1].minor.yy164 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 75: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 76: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 77: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 78: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 79: /* db_options ::= db_options DURATION NK_INTEGER */
      case 80: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==80);
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 81: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 82: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 83: /* db_options ::= db_options KEEP integer_list */
      case 84: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==84);
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_KEEP, yymsp[0].minor.yy648); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 85: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 86: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 87: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 88: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 89: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 90: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 91: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 92: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 93: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_RETENTIONS, yymsp[0].minor.yy648); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 94: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 95: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 96: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 97: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-3].minor.yy164, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-3].minor.yy164, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 101: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 102: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 103: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 104: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 105: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy164 = setDatabaseOption(pCxt, yymsp[-2].minor.yy164, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 106: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy164 = createAlterDatabaseOptions(pCxt); yylhsminor.yy164 = setAlterDatabaseOption(pCxt, yylhsminor.yy164, &yymsp[0].minor.yy213); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 107: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy164 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy164, &yymsp[0].minor.yy213); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 108: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy213.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 109: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy213.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy213.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy213.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= KEEP integer_list */
      case 113: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==113);
{ yymsp[-1].minor.yy213.type = DB_OPTION_KEEP; yymsp[-1].minor.yy213.pList = yymsp[0].minor.yy648; }
        break;
      case 114: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy213.type = DB_OPTION_PAGES; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 115: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy213.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= STRICT NK_STRING */
{ yymsp[-1].minor.yy213.type = DB_OPTION_STRICT; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy213.type = DB_OPTION_WAL; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy213.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy648 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy648 = yylhsminor.yy648;
        break;
      case 120: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 309: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==309);
{ yylhsminor.yy648 = addNodeToList(pCxt, yymsp[-2].minor.yy648, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy648 = yylhsminor.yy648;
        break;
      case 121: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy648 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy648 = yylhsminor.yy648;
        break;
      case 122: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy648 = addNodeToList(pCxt, yymsp[-2].minor.yy648, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy648 = yylhsminor.yy648;
        break;
      case 123: /* retention_list ::= retention */
      case 145: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==145);
      case 148: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==148);
      case 155: /* column_def_list ::= column_def */ yytestcase(yyruleno==155);
      case 198: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==198);
      case 203: /* col_name_list ::= col_name */ yytestcase(yyruleno==203);
      case 251: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==251);
      case 262: /* func_list ::= func */ yytestcase(yyruleno==262);
      case 337: /* literal_list ::= signed_literal */ yytestcase(yyruleno==337);
      case 402: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==402);
      case 408: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==408);
      case 463: /* select_list ::= select_item */ yytestcase(yyruleno==463);
      case 474: /* partition_list ::= partition_item */ yytestcase(yyruleno==474);
      case 526: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==526);
{ yylhsminor.yy648 = createNodeList(pCxt, yymsp[0].minor.yy164); }
  yymsp[0].minor.yy648 = yylhsminor.yy648;
        break;
      case 124: /* retention_list ::= retention_list NK_COMMA retention */
      case 156: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==156);
      case 199: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==199);
      case 204: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==204);
      case 252: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==252);
      case 263: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==263);
      case 338: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==338);
      case 403: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==403);
      case 464: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==464);
      case 475: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==475);
      case 527: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==527);
{ yylhsminor.yy648 = addNodeToList(pCxt, yymsp[-2].minor.yy648, yymsp[0].minor.yy164); }
  yymsp[-2].minor.yy648 = yylhsminor.yy648;
        break;
      case 125: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy164 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 126: /* speed_opt ::= */
      case 288: /* bufsize_opt ::= */ yytestcase(yyruleno==288);
{ yymsp[1].minor.yy512 = 0; }
        break;
      case 127: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 289: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==289);
{ yymsp[-1].minor.yy512 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 128: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 130: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==130);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy193, yymsp[-5].minor.yy164, yymsp[-3].minor.yy648, yymsp[-1].minor.yy648, yymsp[0].minor.yy164); }
        break;
      case 129: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy648); }
        break;
      case 131: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy648); }
        break;
      case 132: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy193, yymsp[0].minor.yy164); }
        break;
      case 133: /* cmd ::= ALTER TABLE alter_table_clause */
      case 311: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==311);
{ pCxt->pRootNode = yymsp[0].minor.yy164; }
        break;
      case 134: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy164); }
        break;
      case 135: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy164 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 136: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy164 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy164, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy593, yymsp[0].minor.yy720); }
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 137: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy164 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy164, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy593); }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 138: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy164 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy164, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy593, yymsp[0].minor.yy720); }
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 139: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy164 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy164, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy593, &yymsp[0].minor.yy593); }
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 140: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy164 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy164, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy593, yymsp[0].minor.yy720); }
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 141: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy164 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy164, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy593); }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 142: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy164 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy164, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy593, yymsp[0].minor.yy720); }
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 143: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy164 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy164, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy593, &yymsp[0].minor.yy593); }
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 144: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy164 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy164, &yymsp[-2].minor.yy593, yymsp[0].minor.yy164); }
  yymsp[-5].minor.yy164 = yylhsminor.yy164;
        break;
      case 146: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 149: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==149);
      case 409: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==409);
{ yylhsminor.yy648 = addNodeToList(pCxt, yymsp[-1].minor.yy648, yymsp[0].minor.yy164); }
  yymsp[-1].minor.yy648 = yylhsminor.yy648;
        break;
      case 147: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy164 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy193, yymsp[-8].minor.yy164, yymsp[-6].minor.yy164, yymsp[-5].minor.yy648, yymsp[-2].minor.yy648, yymsp[0].minor.yy164); }
  yymsp[-9].minor.yy164 = yylhsminor.yy164;
        break;
      case 150: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy164 = createDropTableClause(pCxt, yymsp[-1].minor.yy193, yymsp[0].minor.yy164); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 151: /* specific_cols_opt ::= */
      case 182: /* tags_def_opt ::= */ yytestcase(yyruleno==182);
      case 250: /* tag_list_opt ::= */ yytestcase(yyruleno==250);
      case 472: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==472);
      case 494: /* group_by_clause_opt ::= */ yytestcase(yyruleno==494);
      case 513: /* order_by_clause_opt ::= */ yytestcase(yyruleno==513);
{ yymsp[1].minor.yy648 = NULL; }
        break;
      case 152: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy648 = yymsp[-1].minor.yy648; }
        break;
      case 153: /* full_table_name ::= table_name */
{ yylhsminor.yy164 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy593, NULL); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 154: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy164 = createRealTableNode(pCxt, &yymsp[-2].minor.yy593, &yymsp[0].minor.yy593, NULL); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 157: /* column_def ::= column_name type_name */
{ yylhsminor.yy164 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy593, yymsp[0].minor.yy720, NULL); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 158: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy164 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy593, yymsp[-2].minor.yy720, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 159: /* type_name ::= BOOL */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 160: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 161: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 162: /* type_name ::= INT */
      case 163: /* type_name ::= INTEGER */ yytestcase(yyruleno==163);
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 164: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 165: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 166: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 167: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy720 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 169: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy720 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy720 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 171: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy720 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 172: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy720 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 173: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy720 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 174: /* type_name ::= JSON */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 175: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy720 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 176: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 177: /* type_name ::= BLOB */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 178: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy720 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 179: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy720 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 180: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy720 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy720 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 183: /* tags_def_opt ::= tags_def */
      case 401: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==401);
{ yylhsminor.yy648 = yymsp[0].minor.yy648; }
  yymsp[0].minor.yy648 = yylhsminor.yy648;
        break;
      case 184: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy648 = yymsp[-1].minor.yy648; }
        break;
      case 185: /* table_options ::= */
{ yymsp[1].minor.yy164 = createDefaultTableOptions(pCxt); }
        break;
      case 186: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-2].minor.yy164, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 187: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-2].minor.yy164, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy648); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 188: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-2].minor.yy164, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy648); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 189: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-4].minor.yy164, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy648); }
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 190: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-2].minor.yy164, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 191: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-4].minor.yy164, TABLE_OPTION_SMA, yymsp[-1].minor.yy648); }
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 192: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy164 = createAlterTableOptions(pCxt); yylhsminor.yy164 = setTableOption(pCxt, yylhsminor.yy164, yymsp[0].minor.yy213.type, &yymsp[0].minor.yy213.val); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 193: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy164 = setTableOption(pCxt, yymsp[-1].minor.yy164, yymsp[0].minor.yy213.type, &yymsp[0].minor.yy213.val); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 194: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy213.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 195: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy213.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy213.val = yymsp[0].minor.yy0; }
        break;
      case 196: /* duration_list ::= duration_literal */
      case 366: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==366);
{ yylhsminor.yy648 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy164)); }
  yymsp[0].minor.yy648 = yylhsminor.yy648;
        break;
      case 197: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 367: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==367);
{ yylhsminor.yy648 = addNodeToList(pCxt, yymsp[-2].minor.yy648, releaseRawExprNode(pCxt, yymsp[0].minor.yy164)); }
  yymsp[-2].minor.yy648 = yylhsminor.yy648;
        break;
      case 200: /* rollup_func_name ::= function_name */
{ yylhsminor.yy164 = createFunctionNode(pCxt, &yymsp[0].minor.yy593, NULL); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 201: /* rollup_func_name ::= FIRST */
      case 202: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==202);
      case 254: /* tag_item ::= QTAGS */ yytestcase(yyruleno==254);
{ yylhsminor.yy164 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 205: /* col_name ::= column_name */
      case 255: /* tag_item ::= column_name */ yytestcase(yyruleno==255);
{ yylhsminor.yy164 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy593); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 206: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 207: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 208: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 209: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, OP_TYPE_LIKE); }
        break;
      case 210: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, OP_TYPE_LIKE); }
        break;
      case 211: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy164, NULL, OP_TYPE_LIKE); }
        break;
      case 212: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 213: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 214: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 215: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy164, yymsp[-1].minor.yy164, OP_TYPE_EQUAL); }
        break;
      case 216: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 217: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 218: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 219: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 220: /* cmd ::= SHOW LICENCES */
      case 221: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==221);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 222: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy593); }
        break;
      case 223: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy164); }
        break;
      case 224: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy164); }
        break;
      case 225: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 226: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 227: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 228: /* cmd ::= SHOW VARIABLES */
      case 229: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==229);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 230: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 231: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy164); }
        break;
      case 232: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 233: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 234: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 235: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 236: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy164); }
        break;
      case 237: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 238: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 239: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy164, yymsp[-1].minor.yy164, OP_TYPE_EQUAL); }
        break;
      case 240: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy164, yymsp[0].minor.yy164, yymsp[-3].minor.yy648); }
        break;
      case 241: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 242: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 243: /* db_name_cond_opt ::= */
      case 248: /* from_db_opt ::= */ yytestcase(yyruleno==248);
{ yymsp[1].minor.yy164 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 244: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy164 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy593); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 245: /* like_pattern_opt ::= */
      case 299: /* subtable_opt ::= */ yytestcase(yyruleno==299);
      case 411: /* case_when_else_opt ::= */ yytestcase(yyruleno==411);
      case 441: /* from_clause_opt ::= */ yytestcase(yyruleno==441);
      case 470: /* where_clause_opt ::= */ yytestcase(yyruleno==470);
      case 479: /* twindow_clause_opt ::= */ yytestcase(yyruleno==479);
      case 484: /* sliding_opt ::= */ yytestcase(yyruleno==484);
      case 486: /* fill_opt ::= */ yytestcase(yyruleno==486);
      case 498: /* having_clause_opt ::= */ yytestcase(yyruleno==498);
      case 500: /* range_opt ::= */ yytestcase(yyruleno==500);
      case 502: /* every_opt ::= */ yytestcase(yyruleno==502);
      case 515: /* slimit_clause_opt ::= */ yytestcase(yyruleno==515);
      case 519: /* limit_clause_opt ::= */ yytestcase(yyruleno==519);
{ yymsp[1].minor.yy164 = NULL; }
        break;
      case 246: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 247: /* table_name_cond ::= table_name */
{ yylhsminor.yy164 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy593); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 249: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy164 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy593); }
        break;
      case 253: /* tag_item ::= TBNAME */
{ yylhsminor.yy164 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 256: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy164 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy593), &yymsp[0].minor.yy593); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 257: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy164 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy593), &yymsp[0].minor.yy593); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 258: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy193, yymsp[-3].minor.yy164, yymsp[-1].minor.yy164, NULL, yymsp[0].minor.yy164); }
        break;
      case 259: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy193, yymsp[0].minor.yy164); }
        break;
      case 260: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy164 = createIndexOption(pCxt, yymsp[-7].minor.yy648, releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), NULL, yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
        break;
      case 261: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy164 = createIndexOption(pCxt, yymsp[-9].minor.yy648, releaseRawExprNode(pCxt, yymsp[-5].minor.yy164), releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
        break;
      case 264: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy164 = createFunctionNode(pCxt, &yymsp[-3].minor.yy593, yymsp[-1].minor.yy648); }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 265: /* sma_stream_opt ::= */
      case 292: /* stream_options ::= */ yytestcase(yyruleno==292);
{ yymsp[1].minor.yy164 = createStreamOptions(pCxt); }
        break;
      case 266: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 296: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==296);
{ ((SStreamOptions*)yymsp[-2].minor.yy164)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy164); yylhsminor.yy164 = yymsp[-2].minor.yy164; }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 267: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy164)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy164); yylhsminor.yy164 = yymsp[-2].minor.yy164; }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 268: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy193, &yymsp[-2].minor.yy593, yymsp[0].minor.yy164); }
        break;
      case 269: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy193, &yymsp[-3].minor.yy593, &yymsp[0].minor.yy593, false); }
        break;
      case 270: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy193, &yymsp[-5].minor.yy593, &yymsp[0].minor.yy593, true); }
        break;
      case 271: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy193, &yymsp[-3].minor.yy593, yymsp[0].minor.yy164, false); }
        break;
      case 272: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy193, &yymsp[-5].minor.yy593, yymsp[0].minor.yy164, true); }
        break;
      case 273: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy193, &yymsp[0].minor.yy593); }
        break;
      case 274: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy193, &yymsp[-2].minor.yy593, &yymsp[0].minor.yy593); }
        break;
      case 275: /* cmd ::= DESC full_table_name */
      case 276: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==276);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy164); }
        break;
      case 277: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 278: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy193, yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
        break;
      case 281: /* explain_options ::= */
{ yymsp[1].minor.yy164 = createDefaultExplainOptions(pCxt); }
        break;
      case 282: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy164 = setExplainVerbose(pCxt, yymsp[-2].minor.yy164, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 283: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy164 = setExplainRatio(pCxt, yymsp[-2].minor.yy164, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 284: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy193, yymsp[-8].minor.yy193, &yymsp[-5].minor.yy593, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy720, yymsp[0].minor.yy512); }
        break;
      case 285: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy193, &yymsp[0].minor.yy593); }
        break;
      case 290: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy193, &yymsp[-7].minor.yy593, yymsp[-4].minor.yy164, yymsp[-6].minor.yy164, yymsp[-3].minor.yy648, yymsp[-2].minor.yy164, yymsp[0].minor.yy164); }
        break;
      case 291: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy193, &yymsp[0].minor.yy593); }
        break;
      case 293: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy164)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy164 = yymsp[-2].minor.yy164; }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 294: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy164)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy164 = yymsp[-2].minor.yy164; }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 295: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy164)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy164)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy164); yylhsminor.yy164 = yymsp[-3].minor.yy164; }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 297: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy164)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy164 = yymsp[-3].minor.yy164; }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 298: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy164)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy164 = yymsp[-2].minor.yy164; }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 300: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 485: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==485);
      case 503: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==503);
{ yymsp[-3].minor.yy164 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy164); }
        break;
      case 301: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 302: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 303: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 304: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 305: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 306: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy648); }
        break;
      case 307: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 308: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy648 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 310: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
        break;
      case 312: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy164, yymsp[-2].minor.yy648, yymsp[0].minor.yy164); }
        break;
      case 313: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy164, NULL, yymsp[0].minor.yy164); }
        break;
      case 314: /* literal ::= NK_INTEGER */
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 315: /* literal ::= NK_FLOAT */
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 316: /* literal ::= NK_STRING */
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 317: /* literal ::= NK_BOOL */
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 318: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 319: /* literal ::= duration_literal */
      case 329: /* signed_literal ::= signed */ yytestcase(yyruleno==329);
      case 349: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==349);
      case 350: /* expression ::= literal */ yytestcase(yyruleno==350);
      case 351: /* expression ::= pseudo_column */ yytestcase(yyruleno==351);
      case 352: /* expression ::= column_reference */ yytestcase(yyruleno==352);
      case 353: /* expression ::= function_expression */ yytestcase(yyruleno==353);
      case 354: /* expression ::= case_when_expression */ yytestcase(yyruleno==354);
      case 384: /* function_expression ::= literal_func */ yytestcase(yyruleno==384);
      case 433: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==433);
      case 437: /* boolean_primary ::= predicate */ yytestcase(yyruleno==437);
      case 439: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==439);
      case 440: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==440);
      case 443: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==443);
      case 445: /* table_reference ::= table_primary */ yytestcase(yyruleno==445);
      case 446: /* table_reference ::= joined_table */ yytestcase(yyruleno==446);
      case 450: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==450);
      case 505: /* query_simple ::= query_specification */ yytestcase(yyruleno==505);
      case 506: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==506);
      case 509: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==509);
      case 511: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==511);
{ yylhsminor.yy164 = yymsp[0].minor.yy164; }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 320: /* literal ::= NULL */
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 321: /* literal ::= NK_QUESTION */
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 322: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 323: /* signed ::= NK_INTEGER */
{ yylhsminor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 324: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 325: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 326: /* signed ::= NK_FLOAT */
{ yylhsminor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 327: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 328: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 330: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 331: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 332: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 333: /* signed_literal ::= duration_literal */
      case 335: /* signed_literal ::= literal_func */ yytestcase(yyruleno==335);
      case 404: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==404);
      case 466: /* select_item ::= common_expression */ yytestcase(yyruleno==466);
      case 476: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==476);
      case 510: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==510);
      case 512: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==512);
      case 525: /* search_condition ::= common_expression */ yytestcase(yyruleno==525);
{ yylhsminor.yy164 = releaseRawExprNode(pCxt, yymsp[0].minor.yy164); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 334: /* signed_literal ::= NULL */
{ yylhsminor.yy164 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 336: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy164 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 355: /* expression ::= NK_LP expression NK_RP */
      case 438: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==438);
      case 524: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==524);
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy164)); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 356: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy164));
                                                                                  }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 357: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy164), NULL));
                                                                                  }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 358: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164))); 
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 359: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164))); 
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 360: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164))); 
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 361: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164))); 
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 362: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 363: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 364: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 365: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 368: /* column_reference ::= column_name */
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy593, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy593)); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 369: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy593, &yymsp[0].minor.yy593, createColumnNode(pCxt, &yymsp[-2].minor.yy593, &yymsp[0].minor.yy593)); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 370: /* pseudo_column ::= ROWTS */
      case 371: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==371);
      case 373: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==373);
      case 374: /* pseudo_column ::= QEND */ yytestcase(yyruleno==374);
      case 375: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==375);
      case 376: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==376);
      case 377: /* pseudo_column ::= WEND */ yytestcase(yyruleno==377);
      case 378: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==378);
      case 379: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==379);
      case 380: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==380);
      case 386: /* literal_func ::= NOW */ yytestcase(yyruleno==386);
{ yylhsminor.yy164 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 372: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy593, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy593)))); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 381: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 382: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==382);
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy593, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy593, yymsp[-1].minor.yy648)); }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 383: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), yymsp[-1].minor.yy720)); }
  yymsp[-5].minor.yy164 = yylhsminor.yy164;
        break;
      case 385: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy593, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy593, NULL)); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 400: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy648 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy648 = yylhsminor.yy648;
        break;
      case 405: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 469: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==469);
{ yylhsminor.yy164 = createColumnNode(pCxt, &yymsp[-2].minor.yy593, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 406: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy648, yymsp[-1].minor.yy164)); }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 407: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), yymsp[-2].minor.yy648, yymsp[-1].minor.yy164)); }
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 410: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy164 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)); }
        break;
      case 412: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy164 = releaseRawExprNode(pCxt, yymsp[0].minor.yy164); }
        break;
      case 413: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 418: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==418);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy656, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 414: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy164), releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
  yymsp[-4].minor.yy164 = yylhsminor.yy164;
        break;
      case 415: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy164), releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
  yymsp[-5].minor.yy164 = yylhsminor.yy164;
        break;
      case 416: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), NULL));
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 417: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), NULL));
                                                                                  }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 419: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy656 = OP_TYPE_LOWER_THAN; }
        break;
      case 420: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy656 = OP_TYPE_GREATER_THAN; }
        break;
      case 421: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy656 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 422: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy656 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 423: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy656 = OP_TYPE_NOT_EQUAL; }
        break;
      case 424: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy656 = OP_TYPE_EQUAL; }
        break;
      case 425: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy656 = OP_TYPE_LIKE; }
        break;
      case 426: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy656 = OP_TYPE_NOT_LIKE; }
        break;
      case 427: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy656 = OP_TYPE_MATCH; }
        break;
      case 428: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy656 = OP_TYPE_NMATCH; }
        break;
      case 429: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy656 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 430: /* in_op ::= IN */
{ yymsp[0].minor.yy656 = OP_TYPE_IN; }
        break;
      case 431: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy656 = OP_TYPE_NOT_IN; }
        break;
      case 432: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy648)); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 434: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy164), NULL));
                                                                                  }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 435: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 436: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy164);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy164);
                                                                                    yylhsminor.yy164 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), releaseRawExprNode(pCxt, yymsp[0].minor.yy164)));
                                                                                  }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 442: /* from_clause_opt ::= FROM table_reference_list */
      case 471: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==471);
      case 499: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==499);
{ yymsp[-1].minor.yy164 = yymsp[0].minor.yy164; }
        break;
      case 444: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy164 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy164, yymsp[0].minor.yy164, NULL); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 447: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy164 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy593, &yymsp[0].minor.yy593); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 448: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy164 = createRealTableNode(pCxt, &yymsp[-3].minor.yy593, &yymsp[-1].minor.yy593, &yymsp[0].minor.yy593); }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 449: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy164 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy164), &yymsp[0].minor.yy593); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 451: /* alias_opt ::= */
{ yymsp[1].minor.yy593 = nil_token;  }
        break;
      case 452: /* alias_opt ::= table_alias */
{ yylhsminor.yy593 = yymsp[0].minor.yy593; }
  yymsp[0].minor.yy593 = yylhsminor.yy593;
        break;
      case 453: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy593 = yymsp[0].minor.yy593; }
        break;
      case 454: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 455: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==455);
{ yymsp[-2].minor.yy164 = yymsp[-1].minor.yy164; }
        break;
      case 456: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy164 = createJoinTableNode(pCxt, yymsp[-4].minor.yy868, yymsp[-5].minor.yy164, yymsp[-2].minor.yy164, yymsp[0].minor.yy164); }
  yymsp[-5].minor.yy164 = yylhsminor.yy164;
        break;
      case 457: /* join_type ::= */
{ yymsp[1].minor.yy868 = JOIN_TYPE_INNER; }
        break;
      case 458: /* join_type ::= INNER */
{ yymsp[0].minor.yy868 = JOIN_TYPE_INNER; }
        break;
      case 459: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy164 = createSelectStmt(pCxt, yymsp[-10].minor.yy193, yymsp[-9].minor.yy648, yymsp[-8].minor.yy164);
                                                                                    yymsp[-11].minor.yy164 = addWhereClause(pCxt, yymsp[-11].minor.yy164, yymsp[-7].minor.yy164);
                                                                                    yymsp[-11].minor.yy164 = addPartitionByClause(pCxt, yymsp[-11].minor.yy164, yymsp[-6].minor.yy648);
                                                                                    yymsp[-11].minor.yy164 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy164, yymsp[-2].minor.yy164);
                                                                                    yymsp[-11].minor.yy164 = addGroupByClause(pCxt, yymsp[-11].minor.yy164, yymsp[-1].minor.yy648);
                                                                                    yymsp[-11].minor.yy164 = addHavingClause(pCxt, yymsp[-11].minor.yy164, yymsp[0].minor.yy164);
                                                                                    yymsp[-11].minor.yy164 = addRangeClause(pCxt, yymsp[-11].minor.yy164, yymsp[-5].minor.yy164);
                                                                                    yymsp[-11].minor.yy164 = addEveryClause(pCxt, yymsp[-11].minor.yy164, yymsp[-4].minor.yy164);
                                                                                    yymsp[-11].minor.yy164 = addFillClause(pCxt, yymsp[-11].minor.yy164, yymsp[-3].minor.yy164);
                                                                                  }
        break;
      case 462: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy193 = false; }
        break;
      case 465: /* select_item ::= NK_STAR */
{ yylhsminor.yy164 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy164 = yylhsminor.yy164;
        break;
      case 467: /* select_item ::= common_expression column_alias */
      case 477: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==477);
{ yylhsminor.yy164 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy164), &yymsp[0].minor.yy593); }
  yymsp[-1].minor.yy164 = yylhsminor.yy164;
        break;
      case 468: /* select_item ::= common_expression AS column_alias */
      case 478: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==478);
{ yylhsminor.yy164 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), &yymsp[0].minor.yy593); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 473: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 495: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==495);
      case 514: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==514);
{ yymsp[-2].minor.yy648 = yymsp[0].minor.yy648; }
        break;
      case 480: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy164 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), releaseRawExprNode(pCxt, yymsp[-1].minor.yy164)); }
        break;
      case 481: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy164 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy164)); }
        break;
      case 482: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy164 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), NULL, yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
        break;
      case 483: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy164 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy164), releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), yymsp[-1].minor.yy164, yymsp[0].minor.yy164); }
        break;
      case 487: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy164 = createFillNode(pCxt, yymsp[-1].minor.yy638, NULL); }
        break;
      case 488: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy164 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy648)); }
        break;
      case 489: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy638 = FILL_MODE_NONE; }
        break;
      case 490: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy638 = FILL_MODE_PREV; }
        break;
      case 491: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy638 = FILL_MODE_NULL; }
        break;
      case 492: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy638 = FILL_MODE_LINEAR; }
        break;
      case 493: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy638 = FILL_MODE_NEXT; }
        break;
      case 496: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy648 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy164))); }
  yymsp[0].minor.yy648 = yylhsminor.yy648;
        break;
      case 497: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy648 = addNodeToList(pCxt, yymsp[-2].minor.yy648, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy164))); }
  yymsp[-2].minor.yy648 = yylhsminor.yy648;
        break;
      case 501: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy164 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy164), releaseRawExprNode(pCxt, yymsp[-1].minor.yy164)); }
        break;
      case 504: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy164 = addOrderByClause(pCxt, yymsp[-3].minor.yy164, yymsp[-2].minor.yy648);
                                                                                    yylhsminor.yy164 = addSlimitClause(pCxt, yylhsminor.yy164, yymsp[-1].minor.yy164);
                                                                                    yylhsminor.yy164 = addLimitClause(pCxt, yylhsminor.yy164, yymsp[0].minor.yy164);
                                                                                  }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 507: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy164 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy164, yymsp[0].minor.yy164); }
  yymsp[-3].minor.yy164 = yylhsminor.yy164;
        break;
      case 508: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy164 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy164, yymsp[0].minor.yy164); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 516: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 520: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==520);
{ yymsp[-1].minor.yy164 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 517: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 521: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==521);
{ yymsp[-3].minor.yy164 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 518: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 522: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==522);
{ yymsp[-3].minor.yy164 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 523: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy164 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy164); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 528: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy164 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy164), yymsp[-1].minor.yy238, yymsp[0].minor.yy153); }
  yymsp[-2].minor.yy164 = yylhsminor.yy164;
        break;
      case 529: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy238 = ORDER_ASC; }
        break;
      case 530: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy238 = ORDER_ASC; }
        break;
      case 531: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy238 = ORDER_DESC; }
        break;
      case 532: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy153 = NULL_ORDER_DEFAULT; }
        break;
      case 533: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy153 = NULL_ORDER_FIRST; }
        break;
      case 534: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy153 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
