/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/
#line 11 "sql.y"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
#line 46 "sql.c"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 478
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SNode* yy184;
  int8_t yy231;
  SAlterOption yy361;
  EFillMode yy362;
  SDataType yy388;
  STokenPair yy409;
  EJoinType yy416;
  EOperatorType yy424;
  int32_t yy480;
  SNodeList* yy532;
  int64_t yy541;
  ENullOrder yy617;
  SToken yy649;
  EOrder yy706;
  bool yy829;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             777
#define YYNRULE              587
#define YYNRULE_WITH_ACTION  587
#define YYNTOKEN             332
#define YY_MAX_SHIFT         776
#define YY_MIN_SHIFTREDUCE   1151
#define YY_MAX_SHIFTREDUCE   1737
#define YY_ERROR_ACTION      1738
#define YY_ACCEPT_ACTION     1739
#define YY_NO_ACTION         1740
#define YY_MIN_REDUCE        1741
#define YY_MAX_REDUCE        2327
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (3190)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  2139,  435, 1967,  397, 2090,  434,  670, 1915, 2074,  374,
 /*    10 */   684,  162,   48,   46, 1665,   38,  298, 1965,  375, 1917,
 /*    20 */   394,  627, 1514,   41,   40,  133, 1965,   47,   45,   44,
 /*    30 */    43,   42,  554, 1595, 1814, 1512,  168, 2157, 1753, 1207,
 /*    40 */   211, 1206,  645,  140,  519, 1904, 1784,  608, 2157, 2107,
 /*    50 */  2298,  686,   41,   40,  228,  246,   47,   45,   44,   43,
 /*    60 */    42, 1590,  366,   66, 1542, 2304,  186,   19, 2033, 1539,
 /*    70 */  2299,  634, 1208,  669, 1520,   47,   45,   44,   43,   42,
 /*    80 */   387,  669, 2138, 2030,  657, 2174, 1961, 1962,  334, 2140,
 /*    90 */   690, 2142, 2143,  685,  683,  680,  671, 2192,  441,  773,
 /*   100 */   167,  626,   15,  750,  749,  748,  747,  406, 1856,  746,
 /*   110 */   745,  144,  740,  739,  738,  737,  736,  735,  734,  157,
 /*   120 */   730,  729,  728,  405,  404,  725,  724,  723,  175,  174,
 /*   130 */   367,  179,  365,  364, 1539,  556,  403,  402, 1597, 1598,
 /*   140 */   521,   87,  340,  277, 2235,  644,  518,  134,  643, 1764,
 /*   150 */  2298,  361, 2016,  670, 1915, 1184,  558,  166,  363, 1521,
 /*   160 */   557,   62,  318,   51,   62,  632,  186, 1910, 1570, 1580,
 /*   170 */  2299,  634,  133, 1540, 1596, 1599,  316,   73, 1967,  559,
 /*   180 */    72, 1741, 1739, 2303,  672,  384, 2199,  182, 1515,  656,
 /*   190 */  1513,  341, 1540, 1965, 1186, 1734, 1189, 1190, 2107, 1954,
 /*   200 */  1541,  209,  498,  496,  493,  132,  131,  130,  129,  128,
 /*   210 */   127,  126,  125,  124,  257,  423,   62, 1518, 1519, 1817,
 /*   220 */  1569, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579,  682,
 /*   230 */   678, 1588, 1589, 1591, 1592, 1593, 1594,    2,   48,   46,
 /*   240 */   531,   62, 2026,  344,  533, 1537,  394, 2242, 1514,  433,
 /*   250 */   213,  432,  472,  409,  519,  486, 1784,  408,  485, 1595,
 /*   260 */   123, 1512,  586,  122,  121,  120,  119,  118,  117,  116,
 /*   270 */   115,  114,   87, 2239,  455,  584,  487,  582,  431,  109,
 /*   280 */   457,  516, 1693, 1727,  517, 1777,  655, 1590,  572,  571,
 /*   290 */   570, 1373, 1374,   19, 1733,  562,  137,  566, 1911,  608,
 /*   300 */  1520,  565, 2298,  645,  140,  669,  564,  569,  369,  368,
 /*   310 */  1445, 1446,  563,  189, 1524,  189,  189, 2304,  186,   81,
 /*   320 */    80,  438, 2299,  634,  193,  773,  362, 1283,   15,  620,
 /*   330 */   619, 1691, 1692, 1694, 1695, 1696, 1294, 2303,  445,  633,
 /*   340 */  2298,  640, 2298,  568,  567,  342, 1444, 1447,  424, 1293,
 /*   350 */   279,  422,  418,  414,  411,  431, 2302,  632,  186,  628,
 /*   360 */  2299, 2301, 2299,  634, 1597, 1598, 1285,  483,  189,  255,
 /*   370 */   477,  476,  475,  474,  471,  470,  469,  468,  467,  463,
 /*   380 */   462,  461,  460,  343,  452,  451,  450,   51,  447,  446,
 /*   390 */   360,  670, 1915,  189, 1570, 1580, 2303,  623,  722, 2298,
 /*   400 */  1596, 1599, 1539,  647,  184, 2235, 2236,  479,  138, 2240,
 /*   410 */   191, 2117,   91,  488, 1515, 2302, 1513,  101,  524, 2299,
 /*   420 */  2300,  517, 1777,   41,   40, 2125, 1192,   47,   45,   44,
 /*   430 */    43,   42, 1538,   41,   40, 2121,  280,   47,   45,   44,
 /*   440 */    43,   42, 1908, 1518, 1519,  428, 1569, 1572, 1573, 1574,
 /*   450 */  1575, 1576, 1577, 1578, 1579,  682,  678, 1588, 1589, 1591,
 /*   460 */  1592, 1593, 1594,    2,   12,   48,   46,  202,  201,  430,
 /*   470 */   426, 2123,  391,  394, 1967, 1514, 2033,   62,  656,   93,
 /*   480 */  1339,  680,  353,  629,  624,  617, 1595, 1541, 1512, 1966,
 /*   490 */   478, 2031,  657,  670, 1915, 1330,  712,  711,  710, 1334,
 /*   500 */   709, 1336, 1337,  708,  705, 2139, 1345,  702, 1347, 1348,
 /*   510 */   699,  696,   57, 2012, 1590,  648,  179,   41,   40,  577,
 /*   520 */    19,   47,   45,   44,   43,   42, 1624, 1520, 1704,  654,
 /*   530 */  1207, 2026, 1206, 2242,  587,  595,  513, 2017, 1967,  403,
 /*   540 */   402, 1538, 2157,  511,  107,  359,  507,  503,  242, 1528,
 /*   550 */  1428, 1429,  773, 1965, 2107,   15,  686,  656,  194, 2238,
 /*   560 */  1595,  141, 1521, 1208,  580,  572,  571,  570, 2012, 1907,
 /*   570 */   574, 1892,  562,  137,  566,  641,  241,  399,  565,   62,
 /*   580 */  1960, 1962, 1625,  564,  569,  369,  368, 2138, 1590,  563,
 /*   590 */  2174, 1597, 1598,  110, 2140,  690, 2142, 2143,  685, 1967,
 /*   600 */   680, 1520, 1967,  744,  742,  183,  389, 2227,  665,  398,
 /*   610 */  2026,  390, 2223,  196, 1965,  633,   70, 1965, 2298,   69,
 /*   620 */  1997, 1570, 1580, 1742,  188, 1669,  676, 1596, 1599,  189,
 /*   630 */  1605, 1539, 2253,  632,  186,   12, 1539,  279, 2299,  634,
 /*   640 */   674, 1515, 2199, 1513,  123, 1189, 1190,  122,  121,  120,
 /*   650 */   119,  118,  117,  116,  115,  114,   37,  392, 1619, 1620,
 /*   660 */  1621, 1622, 1623, 1627, 1628, 1629, 1630,  289,  290, 1763,
 /*   670 */  1518, 1519,  288, 1569, 1572, 1573, 1574, 1575, 1576, 1577,
 /*   680 */  1578, 1579,  682,  678, 1588, 1589, 1591, 1592, 1593, 1594,
 /*   690 */     2,   48,   46, 1600,   44,   43,   42, 2012, 1514,  394,
 /*   700 */  2139, 1514,  720,  155,  154,  717,  716,  715,  152,   52,
 /*   710 */   687, 1512, 1595, 2242, 1512, 1529, 1520, 1524, 2107,   41,
 /*   720 */    40,  713,  388,   47,   45,   44,   43,   42,   41,   40,
 /*   730 */   165,  189,   47,   45,   44,   43,   42, 2157, 1917, 2237,
 /*   740 */  1590,   12,  200,   10, 1532, 1534,  670, 1915,  397, 2107,
 /*   750 */  1520,  686,   54, 1520,    3,   30,  165,  678, 1588, 1589,
 /*   760 */  1591, 1592, 1593, 1594, 1917,  439,   41,   40,  670, 1915,
 /*   770 */    47,   45,   44,   43,   42,  773, 1891,  459,  773, 1571,
 /*   780 */   142,   49, 2138, 2198, 1571, 2174,  458,  440,  110, 2140,
 /*   790 */   690, 2142, 2143,  685, 2139,  680,  670, 1915,  143,  637,
 /*   800 */   150, 2198, 2227,  245,  687, 2117,  390, 2223,  720,  155,
 /*   810 */   154,  717,  716,  715,  152,  449,  732, 1597, 1598, 1906,
 /*   820 */   670, 1915,  165, 1681,  400,  670, 1915,  670, 1915, 2121,
 /*   830 */  1918, 2157,  165,  670, 1915, 1542,  377,  670, 1915,  464,
 /*   840 */  1917, 2139,  722, 2107,  465,  686,  532, 1570, 1580,  670,
 /*   850 */  1915,  648, 1912, 1596, 1599, 1890,  247,  312, 2247, 1658,
 /*   860 */  1944,  189,  670, 1915, 1515, 2123, 1513, 1515,  604, 1513,
 /*   870 */  1487, 1488,  670, 1915,    9,  680, 2138, 2302, 2157, 2174,
 /*   880 */  1900,  649,  335, 2140,  690, 2142, 2143,  685, 1626,  680,
 /*   890 */  2107,  653,  686, 1518, 1519,  714, 1518, 1519, 1958, 1569,
 /*   900 */  1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579,  682,  678,
 /*   910 */  1588, 1589, 1591, 1592, 1593, 1594,    2,   48,   46, 1662,
 /*   920 */    14,   13, 1298, 2138, 1539,  394, 2174, 1514,  164,  110,
 /*   930 */  2140,  690, 2142, 2143,  685, 1297,  680, 1902, 1595,   34,
 /*   940 */  1512,  183, 1542, 2227,  254,   41,   40,  390, 2223,   47,
 /*   950 */    45,   44,   43,   42,  670, 1915,  651, 2139,  198,  670,
 /*   960 */  1915,  106,   35,  146, 2100,  135, 1590,  687, 2254, 1786,
 /*   970 */    36,  103, 1631,  401,  670, 1915,   41,   40,  299, 1520,
 /*   980 */    47,   45,   44,   43,   42,  195,  720,  155,  154,  717,
 /*   990 */   716,  715,  152,  293, 2157,  607,  670, 1915,   84,  490,
 /*  1000 */  2117,   83,  608,  153,  773, 2298, 2107,   49,  686, 1762,
 /*  1010 */   608,  670, 1915, 2298, 2126,  667, 1761, 2139, 1760,  244,
 /*  1020 */  2304,  186, 1638,  243, 2121, 2299,  634,  687, 2304,  186,
 /*  1030 */   668,  638, 1759, 2299,  634,  718, 1898,  719, 1958, 2138,
 /*  1040 */  1958, 1758, 2174, 1597, 1598,  110, 2140,  690, 2142, 2143,
 /*  1050 */   685, 2101,  680,  733, 2157, 2093, 1877, 2318, 2107, 2227,
 /*  1060 */  2123,  677,   56,  390, 2223, 2107, 2107, 2107,  686, 1757,
 /*  1070 */   680,  558, 1571, 1570, 1580,  557, 1523, 1919,  442, 1596,
 /*  1080 */  1599, 2107,  251,   90,  348,  645,  140,  373, 1658,  588,
 /*  1090 */  2107,  443,  256, 1515,  590, 1513,  589,  608, 1756, 2138,
 /*  1100 */  2298, 1755, 2174, 1752,  416,  169, 2140,  690, 2142, 2143,
 /*  1110 */   685,  593,  680, 1751, 1750, 2304,  186,   55, 2107,   74,
 /*  1120 */  2299,  634, 1518, 1519,  681, 1569, 1572, 1573, 1574, 1575,
 /*  1130 */  1576, 1577, 1578, 1579,  682,  678, 1588, 1589, 1591, 1592,
 /*  1140 */  1593, 1594,    2,   48,   46,  609, 2264, 2107,  636, 1857,
 /*  1150 */  2107,  394, 2107, 1514, 1749, 1748, 1893,  608, 1754, 1747,
 /*  1160 */  2298, 1746, 2107, 2107, 1595, 1745, 1512, 1744,   82,  234,
 /*  1170 */  1661,  236,  232,  229,  235, 2304,  186,  153, 2267,  238,
 /*  1180 */  2299,  634,  237, 2139, 1240,  560,  185, 2235, 2236,  172,
 /*  1190 */   138, 2240, 1590,  687,  274, 2261,  550,  546,  542,  538,
 /*  1200 */   148,  226,  561, 2107, 2107, 1520,  240, 1281, 2107,  239,
 /*  1210 */  2107, 1616, 1736, 1737, 2107, 1522, 2107, 1801, 1793,  621,
 /*  1220 */  2157, 1791,  153, 1241, 1279,   50,  227,   50,  261,  268,
 /*  1230 */   773, 1526, 2107,   15,  686,  153, 1482,  645,  140,  573,
 /*  1240 */   575,   88, 2139,  578,  224,   50,   14,   13,  286,   71,
 /*  1250 */  1855,  151,  687, 1787,  153,   64,   50, 2158, 1854,  407,
 /*  1260 */  2021, 1778, 2128,   50, 1955, 2138,  694,  151, 2174, 1597,
 /*  1270 */  1598,  110, 2140,  690, 2142, 2143,  685, 1783,  680, 2157,
 /*  1280 */   726, 1485,  153, 2318, 1690, 2227, 1689,  263,  136,  390,
 /*  1290 */  2223, 2107,  646,  686,  652, 2257,  276,  273,    1, 1570,
 /*  1300 */  1580,  727, 1259,  768, 1442, 1596, 1599,  291,  662,    5,
 /*  1310 */   295,  223,  217, 1324, 1632, 1581,  222, 2130,  529, 1515,
 /*  1320 */   151, 1513,  311, 1257, 2138, 1351, 1355, 2174,  410,  415,
 /*  1330 */   170, 2140,  690, 2142, 2143,  685,  215,  680,  187, 2235,
 /*  1340 */  2236, 1362,  138, 2240,  357, 1465,  306, 1360, 1518, 1519,
 /*  1350 */   199, 1569, 1572, 1573, 1574, 1575, 1576, 1577, 1578, 1579,
 /*  1360 */   682,  678, 1588, 1589, 1591, 1592, 1593, 1594,    2,  444,
 /*  1370 */  1525, 1542,  448, 2022,  453, 2139,  481, 1537,  466,  156,
 /*  1380 */  2014,  635, 2319,  473,  480,  687,  482, 2274,  492,  491,
 /*  1390 */   489,  204,  203,  494,  206,  497,  495, 1543,  499,  514,
 /*  1400 */     4,  515,  523,  522, 1545,  525, 1540,  526, 1544,  214,
 /*  1410 */  2139,  216, 2157,  527, 1546,  528,  219,  530, 1210,  551,
 /*  1420 */   687,  221,  615,  534, 2107,  553,  686, 2083,   85,   86,
 /*  1430 */   225,  552,  347,  112,  592,  594, 2080,   89,  149,  307,
 /*  1440 */   555,  248, 2139,  598, 1905,  597,  599, 2157,  250, 1472,
 /*  1450 */   605,  622,  687,  231,  603, 1901,  233, 2138,  158, 2107,
 /*  1460 */  2174,  686,  159,  110, 2140,  690, 2142, 2143,  685, 1903,
 /*  1470 */   680, 1899,  252,  160, 2139, 2318,  161, 2227, 2079, 2157,
 /*  1480 */  2273,  390, 2223, 2272,  687,    8, 2292, 2258,  602,  612,
 /*  1490 */  2268, 2107, 2138,  686,  660, 2174,  618,  259,  110, 2140,
 /*  1500 */   690, 2142, 2143,  685,  379,  680,  631,  262,  625, 2249,
 /*  1510 */  2318, 2157, 2227,  613,  611,  610,  390, 2223,  267,  380,
 /*  1520 */   642, 2321,  272, 2107, 2138,  686,  639, 2174, 1658, 1541,
 /*  1530 */   111, 2140,  690, 2142, 2143,  685, 2243,  680,  173,  139,
 /*  1540 */   650, 2139,  269,  270, 2227,  383, 1547,  271,  281, 2224,
 /*  1550 */    96,  687, 2027, 2246,  658,  659, 2138,  308, 2041, 2174,
 /*  1560 */  2040, 2039,  110, 2140,  690, 2142, 2143,  685,  309,  680,
 /*  1570 */   386,  663,   61, 1916, 2318,  664, 2227,   98, 2157,  275,
 /*  1580 */   390, 2223, 2297,  100,  310, 2208,  102, 1959, 1878,  692,
 /*  1590 */  2107,  313,  686,  769,  770,  337,  302,  772,   53,  315,
 /*  1600 */   322, 2139,  349,  336,  317, 2099, 2098,  326,  350, 2097,
 /*  1610 */    78,  687, 2094,  412,  413, 1505, 1506,  192,  417, 2092,
 /*  1620 */   419,  420,  421, 2138, 2091,  358, 2174, 2089,  425,  110,
 /*  1630 */  2140,  690, 2142, 2143,  685, 2088,  680,  427, 2157, 2087,
 /*  1640 */    79, 2318,  429, 2227, 1468, 1467, 2053,  390, 2223, 2052,
 /*  1650 */  2107, 2051,  686,  436,  437, 2050, 2049, 1419, 2005, 2004,
 /*  1660 */  2002, 2001,  145, 2000, 2003, 1999, 1998, 1996, 1995, 1994,
 /*  1670 */   197,  454, 1993,  456, 2007, 1992, 1991, 1990, 1989, 1988,
 /*  1680 */  1987, 1986, 1985, 2138, 1984, 2139, 2174, 1983, 1982,  110,
 /*  1690 */  2140,  690, 2142, 2143,  685,  687,  680, 1981, 1980, 1979,
 /*  1700 */  1978, 2202, 1977, 2227,  147, 1976, 1975,  390, 2223, 2006,
 /*  1710 */  1974, 2139, 1973, 1421, 1972, 1971, 1970,  484, 1969, 1968,
 /*  1720 */  1820,  687, 2157, 1295, 1291, 1299, 1819, 1818, 1816, 1813,
 /*  1730 */   500,  345,  205,  346, 2107,  502,  686, 1812, 1805,  504,
 /*  1740 */  1795, 1773,  501,  505, 1191, 1772, 2139,  207, 2157,  210,
 /*  1750 */   506,  208,  508, 2070, 2060, 2048,  687,  180,  512, 2047,
 /*  1760 */  2107, 2025,  686,  510,   76, 1894,  220, 2138, 2127, 1815,
 /*  1770 */  2174,  509,   77,  110, 2140,  690, 2142, 2143,  685,  181,
 /*  1780 */   680,  520,  212, 2157, 1811, 2200,  218, 2227,  537, 1809,
 /*  1790 */   541,  390, 2223, 2138, 1807, 2107, 2174,  686,  535,  110,
 /*  1800 */  2140,  690, 2142, 2143,  685,  536,  680, 1233,  539,  540,
 /*  1810 */  2139,  673,  543, 2227,  545,  544, 1804,  390, 2223,  548,
 /*  1820 */   687,  547,  549, 1790, 1789, 1769, 1896, 1366, 2138, 1895,
 /*  1830 */  1367, 2174, 1282, 1280,  111, 2140,  690, 2142, 2143,  685,
 /*  1840 */   741,  680,   63, 1278,  230, 1277, 1276, 2157, 2227, 1275,
 /*  1850 */  1274,  743, 2226, 2223, 1271, 1270, 1269, 1268, 1802, 2107,
 /*  1860 */  2139,  686,  370, 1794,  371, 1792,  372,  579,  576, 1768,
 /*  1870 */   687,  581, 1767,  583, 1766,  585,  113, 2139, 1492, 1496,
 /*  1880 */  1494, 1491,   29, 2069,   67, 1474, 1476,  687, 2059,  600,
 /*  1890 */  2046, 2044, 2138,   20, 1706, 2174, 2303, 2157,  111, 2140,
 /*  1900 */   690, 2142, 2143,  685,   31,  680,   58,    6,   17, 2107,
 /*  1910 */     7,  686, 2227,  266, 2157,  258,  675, 2223,  601,   21,
 /*  1920 */    22,  614,  253,  606,  265,  616, 2107,  376,  686, 2128,
 /*  1930 */    33,  260,   65, 1688, 1680,  163, 1726,  171, 1478,  264,
 /*  1940 */    24,   32, 2138,   92, 1721, 2174, 1720,  381,  169, 2140,
 /*  1950 */   690, 2142, 2143,  685, 1727,  680, 1725, 1724,  382,  688,
 /*  1960 */  1655,  278, 2174, 1654,   60,  111, 2140,  690, 2142, 2143,
 /*  1970 */   685,  176,  680, 2045, 2043, 2042, 2024, 2139,   95, 2227,
 /*  1980 */   284,   94,  661,  352, 2223, 2023,   25,  687,  285, 2265,
 /*  1990 */  1686,  287,   97,  103,  292,  297,   68,   99,   26, 1607,
 /*  2000 */  1606,   11,   13, 1530, 1617, 2177,  177, 1585,  679,   39,
 /*  2010 */    23, 1583,  190, 1582, 2157,   16,   18,   27,  294,  378,
 /*  2020 */  1554, 1562,  689,   59,  693,  396, 2107, 2139,  686,   28,
 /*  2030 */   695,  691,  697, 1352, 1349, 1346,  698,  687,  700,  701,
 /*  2040 */   703, 1340,  704, 2139, 1338,  706,  707,  104,  300, 1344,
 /*  2050 */  1343,  105, 1361,  687,   75, 1357, 1231, 1263,  721, 2138,
 /*  2060 */  1342, 1262, 2174, 1261, 2157,  335, 2140,  690, 2142, 2143,
 /*  2070 */   685, 1341,  680, 1260, 1258, 1256, 2107, 1255,  686, 1254,
 /*  2080 */  2157, 1289,  731, 1252, 1251,  301, 1250, 1249, 1248, 1247,
 /*  2090 */  1246, 1284, 2107, 1286,  686, 1243, 1242, 1239, 1238, 1236,
 /*  2100 */  1237, 1810,  751, 2139, 1808,  753,  752,  755,  756, 2138,
 /*  2110 */   757, 1806, 2174,  687,  759,  328, 2140,  690, 2142, 2143,
 /*  2120 */   685,  761,  680,  760, 1803, 2138,  763, 2139, 2174,  764,
 /*  2130 */  1788,  170, 2140,  690, 2142, 2143,  685,  684,  680,  765,
 /*  2140 */  2157,  767, 1181, 1765,  304,  385,  771, 1740, 1516,  314,
 /*  2150 */   774,  775, 2107, 1740,  686, 1740, 1740, 1740,  630, 1740,
 /*  2160 */  1740, 1740, 1740, 1740, 2157, 1740, 1740, 1740, 1740, 1740,
 /*  2170 */  1740, 1740, 1740, 1740, 1740, 1740, 2107, 1740,  686, 1740,
 /*  2180 */  1740, 1740, 1740, 2320, 1740, 2138, 1740, 1740, 2174, 2139,
 /*  2190 */  1740,  335, 2140,  690, 2142, 2143,  685, 1740,  680,  687,
 /*  2200 */  1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 2138,
 /*  2210 */  1740, 1740, 2174, 2139, 1740,  334, 2140,  690, 2142, 2143,
 /*  2220 */   685, 1740,  680,  687, 2193, 1740, 2157, 1740, 1740, 1740,
 /*  2230 */  1740,  393, 1740, 1740, 1740, 1740, 1740, 1740, 2107, 1740,
 /*  2240 */   686, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2250 */  2157, 1740, 1740, 1740, 1740,  395, 1740, 1740, 1740, 1740,
 /*  2260 */  1740, 1740, 2107, 1740,  686, 1740, 1740, 1740, 1740, 1740,
 /*  2270 */  1740, 2138, 1740, 1740, 2174, 1740, 1740,  335, 2140,  690,
 /*  2280 */  2142, 2143,  685, 1740,  680, 1740, 2139, 1740, 1740, 1740,
 /*  2290 */  1740, 1740, 1740, 1740, 1740, 2138,  687,  596, 2174, 1740,
 /*  2300 */  1740,  335, 2140,  690, 2142, 2143,  685, 1740,  680, 1740,
 /*  2310 */  1740, 1740, 1740, 1740, 1740,  776, 1740, 1740, 1740, 1740,
 /*  2320 */  1740, 1740, 1740, 2157, 1740, 1740, 1740, 1740, 1740,  305,
 /*  2330 */  1740, 1740, 1740, 1740, 1740, 2107, 1740,  686, 1740, 1740,
 /*  2340 */  1740, 1740, 1740, 1740, 1740,  178, 1740, 1740, 1740, 1740,
 /*  2350 */  1740, 1740,  766,  762,  758,  754, 1740,  303, 1740, 1740,
 /*  2360 */  1740, 1740, 2139, 1740, 1740, 1740, 1740, 1740,  591, 1740,
 /*  2370 */  1740, 2174,  687, 1740,  330, 2140,  690, 2142, 2143,  685,
 /*  2380 */  1740,  680, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2390 */  1740, 1740, 1740, 1740, 1740, 1740, 1740,  108, 1740, 2157,
 /*  2400 */   296, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2410 */  1740, 2107, 2139,  686, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2420 */  1740, 1740,  687, 1740, 1740, 1740, 1740, 1740, 2139, 1740,
 /*  2430 */  1740, 1740,  666, 1740, 1740, 1740, 1740, 1740,  687, 1740,
 /*  2440 */  1740, 1740, 1740, 1740, 2138, 1740, 1740, 2174, 1740, 2157,
 /*  2450 */   319, 2140,  690, 2142, 2143,  685, 1740,  680, 1740, 1740,
 /*  2460 */  1740, 2107, 1740,  686, 1740, 2157, 1740,  283, 1740, 1740,
 /*  2470 */  1740, 1740,  282, 1740, 1740, 1740, 1740, 2107, 1740,  686,
 /*  2480 */  1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 2139, 1740,
 /*  2490 */  1740, 1740,  249, 1740, 2138, 1740, 1740, 2174,  687, 1740,
 /*  2500 */   320, 2140,  690, 2142, 2143,  685, 1740,  680, 1740, 1740,
 /*  2510 */  2138, 1740, 2139, 2174, 1740, 1740,  321, 2140,  690, 2142,
 /*  2520 */  2143,  685,  687,  680, 1740, 2157, 1740, 1740, 1740, 1740,
 /*  2530 */  1740, 1740, 1740, 1740, 1740, 2139, 1740, 2107, 1740,  686,
 /*  2540 */  1740, 1740, 1740, 1740, 1740,  687, 1740, 1740, 1740, 2157,
 /*  2550 */  1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 2139,
 /*  2560 */  1740, 2107, 1740,  686, 1740, 1740, 1740, 1740, 1740,  687,
 /*  2570 */  2138, 1740, 2157, 2174, 1740, 1740,  327, 2140,  690, 2142,
 /*  2580 */  2143,  685, 1740,  680, 2107, 1740,  686, 1740, 1740, 1740,
 /*  2590 */  1740, 1740, 1740, 1740, 2138, 1740, 2157, 2174, 1740, 1740,
 /*  2600 */   331, 2140,  690, 2142, 2143,  685, 1740,  680, 2107, 1740,
 /*  2610 */   686, 1740, 1740, 1740, 1740, 1740, 1740, 2138, 1740, 1740,
 /*  2620 */  2174, 1740, 2139,  323, 2140,  690, 2142, 2143,  685, 1740,
 /*  2630 */   680, 1740,  687, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2640 */  1740, 2138, 1740, 1740, 2174, 1740, 1740,  332, 2140,  690,
 /*  2650 */  2142, 2143,  685, 1740,  680, 1740, 1740, 1740, 1740, 2157,
 /*  2660 */  1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2670 */  1740, 2107, 1740,  686, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2680 */  1740, 2139, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2690 */  1740,  687, 1740, 1740, 1740, 1740, 1740, 1740, 2139, 1740,
 /*  2700 */  1740, 1740, 1740, 1740, 2138, 1740, 1740, 2174,  687, 1740,
 /*  2710 */   324, 2140,  690, 2142, 2143,  685, 1740,  680, 2157, 1740,
 /*  2720 */  1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2730 */  2107, 1740,  686, 1740, 1740, 2157, 1740, 1740, 1740, 1740,
 /*  2740 */  1740, 1740, 1740, 1740, 1740, 1740, 1740, 2107, 2139,  686,
 /*  2750 */  1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,  687, 1740,
 /*  2760 */  1740, 1740, 1740, 2138, 1740, 1740, 2174, 1740, 2139,  333,
 /*  2770 */  2140,  690, 2142, 2143,  685, 1740,  680, 1740,  687, 1740,
 /*  2780 */  2138, 1740, 1740, 2174, 1740, 2157,  325, 2140,  690, 2142,
 /*  2790 */  2143,  685, 1740,  680, 1740, 1740, 1740, 2107, 1740,  686,
 /*  2800 */  1740, 1740, 1740, 1740, 1740, 2157, 1740, 1740, 1740, 1740,
 /*  2810 */  1740, 1740, 1740, 1740, 1740, 2139, 1740, 2107, 1740,  686,
 /*  2820 */  1740, 1740, 1740, 1740, 1740,  687, 1740, 1740, 1740, 1740,
 /*  2830 */  2138, 1740, 1740, 2174, 2139, 1740,  338, 2140,  690, 2142,
 /*  2840 */  2143,  685, 1740,  680,  687, 1740, 1740, 1740, 1740, 1740,
 /*  2850 */  2138, 1740, 2157, 2174, 1740, 1740,  339, 2140,  690, 2142,
 /*  2860 */  2143,  685, 1740,  680, 2107, 1740,  686, 1740, 1740, 1740,
 /*  2870 */  1740, 2157, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  2880 */  1740, 2139, 1740, 2107, 1740,  686, 1740, 1740, 1740, 1740,
 /*  2890 */  1740,  687, 1740, 1740, 1740, 1740, 1740, 2138, 1740, 2139,
 /*  2900 */  2174, 1740, 1740, 2151, 2140,  690, 2142, 2143,  685,  687,
 /*  2910 */   680, 1740, 1740, 1740, 1740, 1740, 2138, 1740, 2157, 2174,
 /*  2920 */  1740, 1740, 2150, 2140,  690, 2142, 2143,  685, 1740,  680,
 /*  2930 */  2107, 1740,  686, 1740, 1740, 1740, 2157, 1740, 1740, 1740,
 /*  2940 */  1740, 1740, 1740, 1740, 1740, 1740, 2139, 1740, 2107, 1740,
 /*  2950 */   686, 1740, 1740, 1740, 1740, 1740,  687, 1740, 1740, 1740,
 /*  2960 */  1740, 1740, 1740, 2138, 1740, 1740, 2174, 1740, 2139, 2149,
 /*  2970 */  2140,  690, 2142, 2143,  685, 1740,  680, 1740,  687, 1740,
 /*  2980 */  1740, 2138, 1740, 2157, 2174, 1740, 1740,  354, 2140,  690,
 /*  2990 */  2142, 2143,  685, 1740,  680, 2107, 1740,  686, 1740, 1740,
 /*  3000 */  1740, 1740, 1740, 1740, 1740, 2157, 1740, 1740, 1740, 1740,
 /*  3010 */  1740, 1740, 1740, 1740, 1740, 1740, 1740, 2107, 1740,  686,
 /*  3020 */  1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 2138, 1740,
 /*  3030 */  1740, 2174, 1740, 1740,  355, 2140,  690, 2142, 2143,  685,
 /*  3040 */  1740,  680, 1740, 1740, 2139, 1740, 1740, 1740, 1740, 1740,
 /*  3050 */  2138, 1740, 1740, 2174,  687, 1740,  351, 2140,  690, 2142,
 /*  3060 */  2143,  685, 1740,  680, 1740, 1740, 2139, 1740, 1740, 1740,
 /*  3070 */  1740, 1740, 1740, 1740, 1740, 1740,  687, 1740, 1740, 1740,
 /*  3080 */  1740, 2157, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  3090 */  1740, 1740, 1740, 2107, 2139,  686, 1740, 1740, 1740, 1740,
 /*  3100 */  1740, 1740, 1740, 2157,  687, 1740, 1740, 1740, 1740, 1740,
 /*  3110 */  1740, 1740, 1740, 1740, 1740, 2107, 1740,  686, 1740, 1740,
 /*  3120 */  1740, 1740, 1740, 1740, 1740, 1740, 2138, 1740, 1740, 2174,
 /*  3130 */  1740, 2157,  356, 2140,  690, 2142, 2143,  685, 1740,  680,
 /*  3140 */  1740, 1740, 1740, 2107, 1740,  686, 1740, 1740,  688, 1740,
 /*  3150 */  1740, 2174, 1740, 1740,  330, 2140,  690, 2142, 2143,  685,
 /*  3160 */  1740,  680, 1740, 1740, 1740, 1740, 1740, 1740, 1740, 1740,
 /*  3170 */  1740, 1740, 1740, 1740, 1740, 1740, 2138, 1740, 1740, 2174,
 /*  3180 */  1740, 1740,  329, 2140,  690, 2142, 2143,  685, 1740,  680,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   335,  403,  372,  364,    0,  407,  344,  345,  368,  379,
 /*    10 */   345,  372,   12,   13,   14,  438,  439,  387,  379,  380,
 /*    20 */    20,  345,   22,    8,    9,  363,  387,   12,   13,   14,
 /*    30 */    15,   16,  370,   33,    0,   35,  334,  372,  336,   20,
 /*    40 */   340,   22,  344,  345,  344,  373,  346,  449,  372,  384,
 /*    50 */   452,  386,    8,    9,   35,  415,   12,   13,   14,   15,
 /*    60 */    16,   61,   37,    4,   20,  467,  468,   67,  386,   20,
 /*    70 */   472,  473,   53,   20,   74,   12,   13,   14,   15,   16,
 /*    80 */   398,   20,  417,  401,  402,  420,  385,  386,  423,  424,
 /*    90 */   425,  426,  427,  428,  429,  430,  431,  432,  344,   99,
 /*   100 */   353,  425,  102,   69,   70,   71,   72,   73,  361,   75,
 /*   110 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   120 */    86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
 /*   130 */   105,  372,  107,  108,   20,  110,   12,   13,  138,  139,
 /*   140 */    14,  352,  388,  445,  446,  447,   20,  449,  450,  335,
 /*   150 */   452,  392,  393,  344,  345,    4,  131,   18,  369,   35,
 /*   160 */   135,  102,   23,  102,  102,  467,  468,  378,  168,  169,
 /*   170 */   472,  473,  363,   20,  174,  175,   37,   38,  372,  370,
 /*   180 */    41,    0,  332,    3,  434,  379,  436,  371,  188,  344,
 /*   190 */   190,   52,   20,  387,   43,  180,   45,   46,  384,  383,
 /*   200 */    20,   62,   63,   64,   65,   24,   25,   26,   27,   28,
 /*   210 */    29,   30,   31,   32,  170,  211,  102,  217,  218,    0,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */   230,  231,  232,  233,  234,  235,  236,  237,   12,   13,
 /*   240 */   395,  102,  397,   18,   66,   20,   20,  422,   22,  187,
 /*   250 */   340,  189,   27,  403,  344,   30,  346,  407,   33,   33,
 /*   260 */    21,   35,   21,   24,   25,   26,   27,   28,   29,   30,
 /*   270 */    31,   32,  352,  448,   49,   34,   51,   36,  216,  140,
 /*   280 */    55,  339,  217,  103,  342,  343,   20,   61,   69,   70,
 /*   290 */    71,  138,  139,   67,  279,   76,   77,   78,  378,  449,
 /*   300 */    74,   82,  452,  344,  345,   20,   87,   88,   89,   90,
 /*   310 */   138,  139,   93,  254,  190,  254,  254,  467,  468,  180,
 /*   320 */   181,  182,  472,  473,  185,   99,  101,   35,  102,  264,
 /*   330 */   265,  266,  267,  268,  269,  270,   22,  449,  113,  449,
 /*   340 */   452,   44,  452,  357,  358,  206,  174,  175,  209,   35,
 /*   350 */   170,  212,  213,  214,  215,  216,  468,  467,  468,   20,
 /*   360 */   472,  473,  472,  473,  138,  139,   74,  142,  254,   61,
 /*   370 */   145,  146,  147,  148,  149,  150,  151,  152,  153,  154,
 /*   380 */   155,  156,  157,  158,  159,  160,  161,  102,  163,  164,
 /*   390 */   165,  344,  345,  254,  168,  169,  449,  173,   66,  452,
 /*   400 */   174,  175,   20,  444,  445,  446,  447,   83,  449,  450,
 /*   410 */   363,  360,  104,   99,  188,  468,  190,  350,  339,  472,
 /*   420 */   473,  342,  343,    8,    9,  374,   14,   12,   13,   14,
 /*   430 */    15,   16,   20,    8,    9,  384,   61,   12,   13,   14,
 /*   440 */    15,   16,  375,  217,  218,  183,  220,  221,  222,  223,
 /*   450 */   224,  225,  226,  227,  228,  229,  230,  231,  232,  233,
 /*   460 */   234,  235,  236,  237,  238,   12,   13,  143,  144,  207,
 /*   470 */   208,  420,  421,   20,  372,   22,  386,  102,  344,  104,
 /*   480 */    99,  430,   67,  259,  260,  261,   33,   20,   35,  387,
 /*   490 */   166,  401,  402,  344,  345,  114,  115,  116,  117,  118,
 /*   500 */   119,  120,  121,  122,  123,  335,  125,  126,  127,  128,
 /*   510 */   129,  130,  363,  345,   61,  345,  372,    8,    9,    4,
 /*   520 */    67,   12,   13,   14,   15,   16,  111,   74,  103,  395,
 /*   530 */    20,  397,   22,  422,   19,  113,   49,  393,  372,   12,
 /*   540 */    13,   20,  372,   56,  350,  379,   59,   60,   33,   22,
 /*   550 */   168,  169,   99,  387,  384,  102,  386,  344,  390,  448,
 /*   560 */    33,  367,   35,   53,   49,   69,   70,   71,  345,  375,
 /*   570 */    55,    0,   76,   77,   78,  278,   61,  382,   82,  102,
 /*   580 */   385,  386,  167,   87,   88,   89,   90,  417,   61,   93,
 /*   590 */   420,  138,  139,  423,  424,  425,  426,  427,  428,  372,
 /*   600 */   430,   74,  372,  357,  358,  435,  379,  437,  395,  379,
 /*   610 */   397,  441,  442,  390,  387,  449,  101,  387,  452,  104,
 /*   620 */     0,  168,  169,    0,  454,   14,   99,  174,  175,  254,
 /*   630 */    14,   20,  462,  467,  468,  238,   20,  170,  472,  473,
 /*   640 */   434,  188,  436,  190,   21,   45,   46,   24,   25,   26,
 /*   650 */    27,   28,   29,   30,   31,   32,  241,  242,  243,  244,
 /*   660 */   245,  246,  247,  248,  249,  250,  251,  132,  133,  335,
 /*   670 */   217,  218,  137,  220,  221,  222,  223,  224,  225,  226,
 /*   680 */   227,  228,  229,  230,  231,  232,  233,  234,  235,  236,
 /*   690 */   237,   12,   13,   14,   14,   15,   16,  345,   22,   20,
 /*   700 */   335,   22,  131,  132,  133,  134,  135,  136,  137,  102,
 /*   710 */   345,   35,   33,  422,   35,  188,   74,  190,  384,    8,
 /*   720 */     9,  113,  364,   12,   13,   14,   15,   16,    8,    9,
 /*   730 */   372,  254,   12,   13,   14,   15,   16,  372,  380,  448,
 /*   740 */    61,  238,  390,  240,  217,  218,  344,  345,  364,  384,
 /*   750 */    74,  386,   42,   74,   44,   44,  372,  230,  231,  232,
 /*   760 */   233,  234,  235,  236,  380,  363,    8,    9,  344,  345,
 /*   770 */    12,   13,   14,   15,   16,   99,    0,  157,   99,  168,
 /*   780 */   433,  102,  417,  436,  168,  420,  166,  363,  423,  424,
 /*   790 */   425,  426,  427,  428,  335,  430,  344,  345,  433,   44,
 /*   800 */   435,  436,  437,  132,  345,  360,  441,  442,  131,  132,
 /*   810 */   133,  134,  135,  136,  137,  363,   74,  138,  139,  374,
 /*   820 */   344,  345,  372,  103,  364,  344,  345,  344,  345,  384,
 /*   830 */   380,  372,  372,  344,  345,   20,  377,  344,  345,  363,
 /*   840 */   380,  335,   66,  384,  363,  386,  363,  168,  169,  344,
 /*   850 */   345,  345,  363,  174,  175,    0,  363,  365,  252,  253,
 /*   860 */   368,  254,  344,  345,  188,  420,  190,  188,  363,  190,
 /*   870 */   199,  200,  344,  345,   39,  430,  417,    3,  372,  420,
 /*   880 */   373,  363,  423,  424,  425,  426,  427,  428,  167,  430,
 /*   890 */   384,  363,  386,  217,  218,  381,  217,  218,  384,  220,
 /*   900 */   221,  222,  223,  224,  225,  226,  227,  228,  229,  230,
 /*   910 */   231,  232,  233,  234,  235,  236,  237,   12,   13,    4,
 /*   920 */     1,    2,   22,  417,   20,   20,  420,   22,  170,  423,
 /*   930 */   424,  425,  426,  427,  428,   35,  430,  373,   33,    2,
 /*   940 */    35,  435,   20,  437,  408,    8,    9,  441,  442,   12,
 /*   950 */    13,   14,   15,   16,  344,  345,  403,  335,   61,  344,
 /*   960 */   345,  102,  241,   42,  403,   44,   61,  345,  462,  347,
 /*   970 */     2,  112,  251,  363,  344,  345,    8,    9,  363,   74,
 /*   980 */    12,   13,   14,   15,   16,  170,  131,  132,  133,  134,
 /*   990 */   135,  136,  137,  363,  372,   48,  344,  345,  101,   99,
 /*  1000 */   360,  104,  449,   44,   99,  452,  384,  102,  386,  335,
 /*  1010 */   449,  344,  345,  452,  374,  363,  335,  335,  335,  133,
 /*  1020 */   467,  468,  103,  137,  384,  472,  473,  345,  467,  468,
 /*  1030 */   363,  276,  335,  472,  473,  381,  373,  381,  384,  417,
 /*  1040 */   384,  335,  420,  138,  139,  423,  424,  425,  426,  427,
 /*  1050 */   428,  403,  430,  359,  372,    0,  362,  435,  384,  437,
 /*  1060 */   420,   67,  103,  441,  442,  384,  384,  384,  386,  335,
 /*  1070 */   430,  131,  168,  168,  169,  135,   35,  373,   22,  174,
 /*  1080 */   175,  384,  373,  197,  198,  344,  345,  201,  253,  203,
 /*  1090 */   384,   35,  170,  188,  202,  190,  204,  449,  335,  417,
 /*  1100 */   452,  335,  420,  335,   49,  423,  424,  425,  426,  427,
 /*  1110 */   428,  403,  430,  335,  335,  467,  468,  170,  384,  113,
 /*  1120 */   472,  473,  217,  218,  373,  220,  221,  222,  223,  224,
 /*  1130 */   225,  226,  227,  228,  229,  230,  231,  232,  233,  234,
 /*  1140 */   235,  236,  237,   12,   13,  463,  464,  384,  274,  361,
 /*  1150 */   384,   20,  384,   22,  335,  335,    0,  449,  336,  335,
 /*  1160 */   452,  335,  384,  384,   33,  335,   35,  335,  162,  106,
 /*  1170 */   255,  106,  109,   33,  109,  467,  468,   44,  394,  106,
 /*  1180 */   472,  473,  109,  335,   35,   13,  445,  446,  447,   49,
 /*  1190 */   449,  450,   61,  345,  476,  347,   56,   57,   58,   59,
 /*  1200 */    44,   61,   13,  384,  384,   74,  106,   35,  384,  109,
 /*  1210 */   384,  217,  138,  139,  384,   35,  384,    0,    0,  465,
 /*  1220 */   372,    0,   44,   74,   35,   44,  348,   44,   44,  459,
 /*  1230 */    99,  190,  384,  102,  386,   44,  103,  344,  345,   22,
 /*  1240 */    22,  101,  335,   22,  104,   44,    1,    2,   44,   44,
 /*  1250 */   360,   44,  345,    0,   44,   44,   44,  372,  360,  348,
 /*  1260 */   394,  343,   47,   44,  383,  417,   44,   44,  420,  138,
 /*  1270 */   139,  423,  424,  425,  426,  427,  428,  345,  430,  372,
 /*  1280 */    13,  103,   44,  435,  103,  437,  103,  103,   44,  441,
 /*  1290 */   442,  384,  451,  386,  103,  394,  469,  443,  453,  168,
 /*  1300 */   169,   13,   35,   50,  103,  174,  175,  103,  103,  256,
 /*  1310 */   103,  171,  172,  103,  103,  103,  176,  102,  178,  188,
 /*  1320 */    44,  190,  103,   35,  417,  103,  103,  420,  419,   49,
 /*  1330 */   423,  424,  425,  426,  427,  428,  196,  430,  445,  446,
 /*  1340 */   447,  103,  449,  450,  418,  186,  405,  103,  217,  218,
 /*  1350 */    42,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*  1360 */   229,  230,  231,  232,  233,  234,  235,  236,  237,  391,
 /*  1370 */   190,   20,  391,  394,  389,  335,  167,   20,  344,  103,
 /*  1380 */   344,  474,  475,  391,  389,  345,  389,  347,  356,  100,
 /*  1390 */    98,  344,  355,   97,  344,  344,  354,   20,  344,  337,
 /*  1400 */    48,  341,  341,  337,   20,  412,   20,  386,   20,  352,
 /*  1410 */   335,  352,  372,  346,   20,  404,  352,  346,   54,  349,
 /*  1420 */   345,  352,  347,  344,  384,  337,  386,  384,  352,  352,
 /*  1430 */   352,  349,  337,  344,  205,  416,  384,  102,  414,  412,
 /*  1440 */   372,  350,  335,  194,  372,  193,  411,  372,  410,  192,
 /*  1450 */   344,  263,  345,  372,  409,  372,  372,  417,  372,  384,
 /*  1460 */   420,  386,  372,  423,  424,  425,  426,  427,  428,  372,
 /*  1470 */   430,  372,  350,  372,  335,  435,  372,  437,  384,  372,
 /*  1480 */   458,  441,  442,  458,  345,  271,  347,  394,  386,  384,
 /*  1490 */   394,  384,  417,  386,  262,  420,  384,  399,  423,  424,
 /*  1500 */   425,  426,  427,  428,  384,  430,  179,  399,  384,  461,
 /*  1510 */   435,  372,  437,  273,  272,  257,  441,  442,  460,  280,
 /*  1520 */   277,  477,  419,  384,  417,  386,  275,  420,  253,   20,
 /*  1530 */   423,  424,  425,  426,  427,  428,  422,  430,  458,  345,
 /*  1540 */   344,  335,  457,  456,  437,  346,   20,  455,  350,  442,
 /*  1550 */   350,  345,  397,  347,  384,  384,  417,  399,  384,  420,
 /*  1560 */   384,  384,  423,  424,  425,  426,  427,  428,  399,  430,
 /*  1570 */   384,  172,  102,  345,  435,  396,  437,  350,  372,  470,
 /*  1580 */   441,  442,  471,  350,  368,  440,  102,  384,  362,  376,
 /*  1590 */   384,  344,  386,   36,  338,  413,  350,  337,  406,  351,
 /*  1600 */   366,  335,  400,  366,  333,    0,    0,  366,  400,    0,
 /*  1610 */    42,  345,    0,   35,  210,   35,   35,   35,  210,    0,
 /*  1620 */    35,   35,  210,  417,    0,  210,  420,    0,   35,  423,
 /*  1630 */   424,  425,  426,  427,  428,    0,  430,   22,  372,    0,
 /*  1640 */   197,  435,   35,  437,  190,  188,    0,  441,  442,    0,
 /*  1650 */   384,    0,  386,  184,  183,    0,    0,   47,    0,    0,
 /*  1660 */     0,    0,   42,    0,    0,    0,    0,    0,    0,    0,
 /*  1670 */   157,   35,    0,  157,    0,    0,    0,    0,    0,    0,
 /*  1680 */     0,    0,    0,  417,    0,  335,  420,    0,    0,  423,
 /*  1690 */   424,  425,  426,  427,  428,  345,  430,    0,    0,    0,
 /*  1700 */     0,  435,    0,  437,   42,    0,    0,  441,  442,    0,
 /*  1710 */     0,  335,    0,   22,    0,    0,    0,  141,    0,    0,
 /*  1720 */     0,  345,  372,   22,   35,   22,    0,    0,    0,    0,
 /*  1730 */    35,   48,   61,   48,  384,   39,  386,    0,    0,   35,
 /*  1740 */     0,    0,   49,   49,   14,    0,  335,   61,  372,   42,
 /*  1750 */    39,   61,   35,    0,    0,    0,  345,   44,   35,    0,
 /*  1760 */   384,    0,  386,   39,   39,    0,  179,  417,   47,    0,
 /*  1770 */   420,   49,   39,  423,  424,  425,  426,  427,  428,   47,
 /*  1780 */   430,   47,   40,  372,    0,  435,   39,  437,   39,    0,
 /*  1790 */    39,  441,  442,  417,    0,  384,  420,  386,   35,  423,
 /*  1800 */   424,  425,  426,  427,  428,   49,  430,   68,   35,   49,
 /*  1810 */   335,  435,   35,  437,   39,   49,    0,  441,  442,   49,
 /*  1820 */   345,   35,   39,    0,    0,    0,    0,   22,  417,    0,
 /*  1830 */    35,  420,   35,   35,  423,  424,  425,  426,  427,  428,
 /*  1840 */    44,  430,  111,   35,  109,   35,   35,  372,  437,   35,
 /*  1850 */    35,   44,  441,  442,   35,   35,   22,   35,    0,  384,
 /*  1860 */   335,  386,   22,    0,   22,    0,   22,   35,   51,    0,
 /*  1870 */   345,   35,    0,   35,    0,   22,   20,  335,   35,  103,
 /*  1880 */    35,   35,  102,    0,  102,   35,   22,  345,    0,   22,
 /*  1890 */     0,    0,  417,   44,  103,  420,    3,  372,  423,  424,
 /*  1900 */   425,  426,  427,  428,  102,  430,  170,   48,  258,  384,
 /*  1910 */    48,  386,  437,   47,  372,  102,  441,  442,  170,   44,
 /*  1920 */    44,  100,  172,  177,   44,   98,  384,  170,  386,   47,
 /*  1930 */    44,  103,    3,  103,  103,  191,  103,  102,  195,  102,
 /*  1940 */    44,  102,  417,  102,   35,  420,   35,   35,  423,  424,
 /*  1950 */   425,  426,  427,  428,  103,  430,   35,   35,   35,  417,
 /*  1960 */   103,   47,  420,  103,   44,  423,  424,  425,  426,  427,
 /*  1970 */   428,   47,  430,    0,    0,    0,    0,  335,   39,  437,
 /*  1980 */    47,  102,  173,  441,  442,    0,  102,  345,  103,  464,
 /*  1990 */   103,  102,   39,  112,  102,   47,  102,  102,   44,  100,
 /*  2000 */   100,  239,    2,   22,  217,  102,   47,  103,  102,  102,
 /*  2010 */   258,  103,   47,  103,  372,  102,  258,  102,  171,  377,
 /*  2020 */   103,   22,  219,  252,   35,   35,  384,  335,  386,  102,
 /*  2030 */   102,  113,   35,  103,  103,  103,  102,  345,   35,  102,
 /*  2040 */    35,  103,  102,  335,  103,   35,  102,  102,   44,  124,
 /*  2050 */   124,  102,   35,  345,  102,   22,   68,   35,   67,  417,
 /*  2060 */   124,   35,  420,   35,  372,  423,  424,  425,  426,  427,
 /*  2070 */   428,  124,  430,   35,   35,   35,  384,   35,  386,   35,
 /*  2080 */   372,   74,   96,   35,   35,   44,   35,   22,   35,   35,
 /*  2090 */    35,   35,  384,   74,  386,   35,   35,   35,   35,   35,
 /*  2100 */    22,    0,   35,  335,    0,   39,   49,   35,   49,  417,
 /*  2110 */    39,    0,  420,  345,   35,  423,  424,  425,  426,  427,
 /*  2120 */   428,   39,  430,   49,    0,  417,   35,  335,  420,   49,
 /*  2130 */     0,  423,  424,  425,  426,  427,  428,  345,  430,   39,
 /*  2140 */   372,   35,   35,    0,   22,  377,   21,  478,   22,   22,
 /*  2150 */    21,   20,  384,  478,  386,  478,  478,  478,  466,  478,
 /*  2160 */   478,  478,  478,  478,  372,  478,  478,  478,  478,  478,
 /*  2170 */   478,  478,  478,  478,  478,  478,  384,  478,  386,  478,
 /*  2180 */   478,  478,  478,  475,  478,  417,  478,  478,  420,  335,
 /*  2190 */   478,  423,  424,  425,  426,  427,  428,  478,  430,  345,
 /*  2200 */   478,  478,  478,  478,  478,  478,  478,  478,  478,  417,
 /*  2210 */   478,  478,  420,  335,  478,  423,  424,  425,  426,  427,
 /*  2220 */   428,  478,  430,  345,  432,  478,  372,  478,  478,  478,
 /*  2230 */   478,  377,  478,  478,  478,  478,  478,  478,  384,  478,
 /*  2240 */   386,  478,  478,  478,  478,  478,  478,  478,  478,  478,
 /*  2250 */   372,  478,  478,  478,  478,  377,  478,  478,  478,  478,
 /*  2260 */   478,  478,  384,  478,  386,  478,  478,  478,  478,  478,
 /*  2270 */   478,  417,  478,  478,  420,  478,  478,  423,  424,  425,
 /*  2280 */   426,  427,  428,  478,  430,  478,  335,  478,  478,  478,
 /*  2290 */   478,  478,  478,  478,  478,  417,  345,    1,  420,  478,
 /*  2300 */   478,  423,  424,  425,  426,  427,  428,  478,  430,  478,
 /*  2310 */   478,  478,  478,  478,  478,   19,  478,  478,  478,  478,
 /*  2320 */   478,  478,  478,  372,  478,  478,  478,  478,  478,   33,
 /*  2330 */   478,  478,  478,  478,  478,  384,  478,  386,  478,  478,
 /*  2340 */   478,  478,  478,  478,  478,   49,  478,  478,  478,  478,
 /*  2350 */   478,  478,   56,   57,   58,   59,  478,   61,  478,  478,
 /*  2360 */   478,  478,  335,  478,  478,  478,  478,  478,  417,  478,
 /*  2370 */   478,  420,  345,  478,  423,  424,  425,  426,  427,  428,
 /*  2380 */   478,  430,  478,  478,  478,  478,  478,  478,  478,  478,
 /*  2390 */   478,  478,  478,  478,  478,  478,  478,  101,  478,  372,
 /*  2400 */   104,  478,  478,  478,  478,  478,  478,  478,  478,  478,
 /*  2410 */   478,  384,  335,  386,  478,  478,  478,  478,  478,  478,
 /*  2420 */   478,  478,  345,  478,  478,  478,  478,  478,  335,  478,
 /*  2430 */   478,  478,  136,  478,  478,  478,  478,  478,  345,  478,
 /*  2440 */   478,  478,  478,  478,  417,  478,  478,  420,  478,  372,
 /*  2450 */   423,  424,  425,  426,  427,  428,  478,  430,  478,  478,
 /*  2460 */   478,  384,  478,  386,  478,  372,  478,  171,  478,  478,
 /*  2470 */   478,  478,  176,  478,  478,  478,  478,  384,  478,  386,
 /*  2480 */   478,  478,  478,  478,  478,  478,  478,  478,  335,  478,
 /*  2490 */   478,  478,  196,  478,  417,  478,  478,  420,  345,  478,
 /*  2500 */   423,  424,  425,  426,  427,  428,  478,  430,  478,  478,
 /*  2510 */   417,  478,  335,  420,  478,  478,  423,  424,  425,  426,
 /*  2520 */   427,  428,  345,  430,  478,  372,  478,  478,  478,  478,
 /*  2530 */   478,  478,  478,  478,  478,  335,  478,  384,  478,  386,
 /*  2540 */   478,  478,  478,  478,  478,  345,  478,  478,  478,  372,
 /*  2550 */   478,  478,  478,  478,  478,  478,  478,  478,  478,  335,
 /*  2560 */   478,  384,  478,  386,  478,  478,  478,  478,  478,  345,
 /*  2570 */   417,  478,  372,  420,  478,  478,  423,  424,  425,  426,
 /*  2580 */   427,  428,  478,  430,  384,  478,  386,  478,  478,  478,
 /*  2590 */   478,  478,  478,  478,  417,  478,  372,  420,  478,  478,
 /*  2600 */   423,  424,  425,  426,  427,  428,  478,  430,  384,  478,
 /*  2610 */   386,  478,  478,  478,  478,  478,  478,  417,  478,  478,
 /*  2620 */   420,  478,  335,  423,  424,  425,  426,  427,  428,  478,
 /*  2630 */   430,  478,  345,  478,  478,  478,  478,  478,  478,  478,
 /*  2640 */   478,  417,  478,  478,  420,  478,  478,  423,  424,  425,
 /*  2650 */   426,  427,  428,  478,  430,  478,  478,  478,  478,  372,
 /*  2660 */   478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
 /*  2670 */   478,  384,  478,  386,  478,  478,  478,  478,  478,  478,
 /*  2680 */   478,  335,  478,  478,  478,  478,  478,  478,  478,  478,
 /*  2690 */   478,  345,  478,  478,  478,  478,  478,  478,  335,  478,
 /*  2700 */   478,  478,  478,  478,  417,  478,  478,  420,  345,  478,
 /*  2710 */   423,  424,  425,  426,  427,  428,  478,  430,  372,  478,
 /*  2720 */   478,  478,  478,  478,  478,  478,  478,  478,  478,  478,
 /*  2730 */   384,  478,  386,  478,  478,  372,  478,  478,  478,  478,
 /*  2740 */   478,  478,  478,  478,  478,  478,  478,  384,  335,  386,
 /*  2750 */   478,  478,  478,  478,  478,  478,  478,  478,  345,  478,
 /*  2760 */   478,  478,  478,  417,  478,  478,  420,  478,  335,  423,
 /*  2770 */   424,  425,  426,  427,  428,  478,  430,  478,  345,  478,
 /*  2780 */   417,  478,  478,  420,  478,  372,  423,  424,  425,  426,
 /*  2790 */   427,  428,  478,  430,  478,  478,  478,  384,  478,  386,
 /*  2800 */   478,  478,  478,  478,  478,  372,  478,  478,  478,  478,
 /*  2810 */   478,  478,  478,  478,  478,  335,  478,  384,  478,  386,
 /*  2820 */   478,  478,  478,  478,  478,  345,  478,  478,  478,  478,
 /*  2830 */   417,  478,  478,  420,  335,  478,  423,  424,  425,  426,
 /*  2840 */   427,  428,  478,  430,  345,  478,  478,  478,  478,  478,
 /*  2850 */   417,  478,  372,  420,  478,  478,  423,  424,  425,  426,
 /*  2860 */   427,  428,  478,  430,  384,  478,  386,  478,  478,  478,
 /*  2870 */   478,  372,  478,  478,  478,  478,  478,  478,  478,  478,
 /*  2880 */   478,  335,  478,  384,  478,  386,  478,  478,  478,  478,
 /*  2890 */   478,  345,  478,  478,  478,  478,  478,  417,  478,  335,
 /*  2900 */   420,  478,  478,  423,  424,  425,  426,  427,  428,  345,
 /*  2910 */   430,  478,  478,  478,  478,  478,  417,  478,  372,  420,
 /*  2920 */   478,  478,  423,  424,  425,  426,  427,  428,  478,  430,
 /*  2930 */   384,  478,  386,  478,  478,  478,  372,  478,  478,  478,
 /*  2940 */   478,  478,  478,  478,  478,  478,  335,  478,  384,  478,
 /*  2950 */   386,  478,  478,  478,  478,  478,  345,  478,  478,  478,
 /*  2960 */   478,  478,  478,  417,  478,  478,  420,  478,  335,  423,
 /*  2970 */   424,  425,  426,  427,  428,  478,  430,  478,  345,  478,
 /*  2980 */   478,  417,  478,  372,  420,  478,  478,  423,  424,  425,
 /*  2990 */   426,  427,  428,  478,  430,  384,  478,  386,  478,  478,
 /*  3000 */   478,  478,  478,  478,  478,  372,  478,  478,  478,  478,
 /*  3010 */   478,  478,  478,  478,  478,  478,  478,  384,  478,  386,
 /*  3020 */   478,  478,  478,  478,  478,  478,  478,  478,  417,  478,
 /*  3030 */   478,  420,  478,  478,  423,  424,  425,  426,  427,  428,
 /*  3040 */   478,  430,  478,  478,  335,  478,  478,  478,  478,  478,
 /*  3050 */   417,  478,  478,  420,  345,  478,  423,  424,  425,  426,
 /*  3060 */   427,  428,  478,  430,  478,  478,  335,  478,  478,  478,
 /*  3070 */   478,  478,  478,  478,  478,  478,  345,  478,  478,  478,
 /*  3080 */   478,  372,  478,  478,  478,  478,  478,  478,  478,  478,
 /*  3090 */   478,  478,  478,  384,  335,  386,  478,  478,  478,  478,
 /*  3100 */   478,  478,  478,  372,  345,  478,  478,  478,  478,  478,
 /*  3110 */   478,  478,  478,  478,  478,  384,  478,  386,  478,  478,
 /*  3120 */   478,  478,  478,  478,  478,  478,  417,  478,  478,  420,
 /*  3130 */   478,  372,  423,  424,  425,  426,  427,  428,  478,  430,
 /*  3140 */   478,  478,  478,  384,  478,  386,  478,  478,  417,  478,
 /*  3150 */   478,  420,  478,  478,  423,  424,  425,  426,  427,  428,
 /*  3160 */   478,  430,  478,  478,  478,  478,  478,  478,  478,  478,
 /*  3170 */   478,  478,  478,  478,  478,  478,  417,  478,  478,  420,
 /*  3180 */   478,  478,  423,  424,  425,  426,  427,  428,  478,  430,
 /*  3190 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3200 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3210 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3220 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3230 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3240 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3250 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3260 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3270 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3280 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3290 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3300 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3310 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3320 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3330 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3340 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3350 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3360 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3370 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3380 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3390 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3400 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3410 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3420 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3430 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3440 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3450 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3460 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3470 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3480 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3490 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3500 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3510 */   332,  332,  332,  332,  332,  332,  332,  332,  332,  332,
 /*  3520 */   332,  332,
};
#define YY_SHIFT_COUNT    (776)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2296)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   139,    0,  226,    0,  453,  453,  453,  453,  453,  453,
 /*    10 */   453,  453,  453,  453,  453,  453,  679,  905,  905, 1131,
 /*    20 */   905,  905,  905,  905,  905,  905,  905,  905,  905,  905,
 /*    30 */   905,  905,  905,  905,  905,  905,  905,  905,  905,  905,
 /*    40 */   905,  905,  905,  905,  905,  905,  905,  905,  905,  905,
 /*    50 */   905,   61,  114,   62,  285,  375,  477,  607,  477,  285,
 /*    60 */   285,  527,  477,  527,  527,   59,  477,   49,  172,   53,
 /*    70 */    53,  172,  151,  151,  382,  153,  126,  126,   53,   53,
 /*    80 */    53,   53,   53,   53,   53,  266,   53,   53,  178,   49,
 /*    90 */    53,   53,  339,   53,   49,   53,  266,   53,  266,   49,
 /*   100 */    53,   53,   49,   53,   49,   49,   49,   53,  332,  225,
 /*   110 */   415,  415,  496,  239,  676,  676,  676,  676,  676,  676,
 /*   120 */   676,  676,  676,  676,  676,  676,  676,  676,  676,  676,
 /*   130 */   676,  676,  676,   25,  180,  382,  153,  292,  467,  467,
 /*   140 */   467,  776,  503,  503,  292,  521,  521,  521,  178,  422,
 /*   150 */   397,   49,  642,   49,  642,  642,  608,  742,  381,  381,
 /*   160 */   381,  381,  381,  381,  381,  381, 2296,  219,  623,   44,
 /*   170 */    15,   65,   19,  224,  124,  124,  611,  616,  510,  815,
 /*   180 */   600,  412,  940,  922,  606,  835,  874,  606,  710,  915,
 /*   190 */   904, 1053, 1280, 1159, 1308, 1351, 1308, 1209, 1357, 1357,
 /*   200 */  1308, 1209, 1209, 1289, 1292, 1357, 1296, 1357, 1357, 1357,
 /*   210 */  1377, 1352, 1377, 1352, 1384,  178, 1386,  178, 1388, 1394,
 /*   220 */   178, 1388,  178,  178,  178, 1357,  178, 1364, 1364, 1377,
 /*   230 */    49,   49,   49,   49,   49,   49,   49,   49,   49,   49,
 /*   240 */    49, 1357, 1377,  642,  642,  642, 1229, 1335, 1384,  332,
 /*   250 */  1249, 1252, 1386,  332, 1257, 1357, 1351, 1351,  642, 1188,
 /*   260 */  1232,  642, 1188, 1232,  642,  642,   49, 1214, 1327, 1188,
 /*   270 */  1240, 1242, 1258, 1053, 1239, 1243, 1251, 1275,  521, 1509,
 /*   280 */  1357, 1388,  332,  332, 1526, 1232,  642,  642,  642,  642,
 /*   290 */   642, 1232,  642, 1399,  332,  608,  332,  521, 1470, 1484,
 /*   300 */   642,  742, 1357,  332, 1557, 1377, 3190, 3190, 3190, 3190,
 /*   310 */  3190, 3190, 3190, 3190, 3190,   34, 1140,  181,  515,  425,
 /*   320 */   711,  720,  571,  937,  968,  758,  855,  509,  509,  509,
 /*   330 */   509,  509,  509,  509,  509,  509,  677,  886,   63,   63,
 /*   340 */   324,  487,  262,  620,  897,  314,  900,  241,  671,  535,
 /*   350 */   535,  680,  919,  721,  680,  680,  680, 1055,    4,  959,
 /*   360 */  1056,  921, 1006, 1156, 1063, 1065, 1073, 1100, 1172, 1189,
 /*   370 */  1217, 1218, 1221,  892, 1133, 1178,  308, 1181, 1183, 1184,
 /*   380 */  1074,  755,  297,  947, 1191, 1201, 1204, 1205, 1207, 1210,
 /*   390 */  1245, 1211,  994, 1212, 1215, 1219, 1222, 1223, 1238, 1244,
 /*   400 */  1276,  859, 1041, 1180, 1267, 1288, 1149, 1253, 1605, 1606,
 /*   410 */  1609, 1568, 1612, 1578, 1404, 1580, 1581, 1582, 1408, 1619,
 /*   420 */  1585, 1586, 1412, 1624, 1415, 1627, 1593, 1635, 1615, 1639,
 /*   430 */  1607, 1443, 1454, 1457, 1646, 1649, 1651, 1469, 1471, 1655,
 /*   440 */  1656, 1610, 1658, 1659, 1660, 1620, 1661, 1663, 1664, 1665,
 /*   450 */  1666, 1667, 1668, 1669, 1513, 1636, 1672, 1516, 1674, 1675,
 /*   460 */  1676, 1677, 1678, 1679, 1680, 1681, 1682, 1684, 1687, 1688,
 /*   470 */  1697, 1698, 1699, 1700, 1662, 1702, 1705, 1706, 1709, 1710,
 /*   480 */  1712, 1691, 1714, 1715, 1716, 1576, 1718, 1719, 1701, 1683,
 /*   490 */  1703, 1685, 1720, 1671, 1689, 1726, 1686, 1727, 1690, 1728,
 /*   500 */  1729, 1695, 1693, 1696, 1737, 1704, 1694, 1711, 1738, 1717,
 /*   510 */  1722, 1724, 1740, 1723, 1741, 1707, 1725, 1713, 1721, 1732,
 /*   520 */  1730, 1734, 1745, 1742, 1733, 1753, 1754, 1755, 1747, 1587,
 /*   530 */  1759, 1761, 1765, 1739, 1769, 1784, 1763, 1756, 1749, 1789,
 /*   540 */  1773, 1760, 1751, 1794, 1777, 1766, 1775, 1816, 1786, 1770,
 /*   550 */  1783, 1823, 1824, 1825, 1826, 1731, 1735, 1795, 1805, 1829,
 /*   560 */  1797, 1798, 1808, 1810, 1811, 1814, 1815, 1796, 1807, 1819,
 /*   570 */  1820, 1834, 1822, 1858, 1840, 1863, 1842, 1817, 1865, 1844,
 /*   580 */  1832, 1869, 1836, 1872, 1838, 1874, 1853, 1856, 1843, 1845,
 /*   590 */  1846, 1776, 1780, 1883, 1736, 1782, 1743, 1850, 1864, 1888,
 /*   600 */  1744, 1867, 1748, 1750, 1890, 1891, 1757, 1746, 1893, 1849,
 /*   610 */  1650, 1802, 1791, 1813, 1859, 1821, 1862, 1827, 1828, 1875,
 /*   620 */  1876, 1830, 1835, 1837, 1839, 1831, 1880, 1866, 1882, 1841,
 /*   630 */  1886, 1752, 1833, 1851, 1929, 1896, 1758, 1909, 1911, 1912,
 /*   640 */  1921, 1922, 1923, 1857, 1860, 1914, 1771, 1920, 1924, 1973,
 /*   650 */  1974, 1975, 1976, 1879, 1939, 1721, 1933, 1884, 1885, 1887,
 /*   660 */  1889, 1892, 1809, 1894, 1985, 1953, 1847, 1895, 1881, 1721,
 /*   670 */  1948, 1954, 1899, 1762, 1900, 2000, 1981, 1787, 1903, 1904,
 /*   680 */  1906, 1908, 1907, 1910, 1959, 1913, 1915, 1965, 1917, 1999,
 /*   690 */  1803, 1927, 1918, 1930, 1989, 1990, 1928, 1931, 1997, 1934,
 /*   700 */  1932, 2003, 1937, 1938, 2005, 1940, 1941, 2010, 1944, 1925,
 /*   710 */  1926, 1936, 1947, 1945, 2004, 1949, 2017, 1952, 2004, 2004,
 /*   720 */  2033, 1988, 1991, 2022, 2026, 2028, 2038, 2039, 2040, 2042,
 /*   730 */  2044, 2007, 1986, 2041, 2048, 2049, 2051, 2065, 2053, 2054,
 /*   740 */  2055, 2019, 1796, 2056, 1807, 2060, 2061, 2062, 2063, 2078,
 /*   750 */  2064, 2101, 2067, 2057, 2066, 2104, 2072, 2059, 2071, 2111,
 /*   760 */  2079, 2074, 2082, 2124, 2091, 2080, 2100, 2130, 2106, 2107,
 /*   770 */  2143, 2122, 2125, 2126, 2127, 2129, 2131,
};
#define YY_REDUCE_COUNT (314)
#define YY_REDUCE_MIN   (-423)
#define YY_REDUCE_MAX   (2759)
static const short yy_reduce_ofst[] = {
 /*     0 */  -150,  170,  365,  506,  622,  848, 1040, 1075, 1139, 1206,
 /*    10 */  1266, 1350, 1376, 1411, 1475, 1542, -335,  682,  907, 1107,
 /*    20 */  1525,  459, 1642, 1692, 1708, 1768, 1792, 1854, 1878, 1951,
 /*    30 */  2027, 2077, 2093, 2153, 2177, 2200, 2224, 2287, 2346, 2363,
 /*    40 */  2413, 2433, 2480, 2499, 2546, 2564, 2611, 2633, 2709, 2731,
 /*    50 */  2759, -302,  166, -402,  -41,  553,  561,  648,  708,  741,
 /*    60 */   893,   51, -110,  445,  640, -112,  -53, -361, -318, -338,
 /*    70 */  -191,   90,  -58,   79, -241,  195, -300,  -90,   47,  149,
 /*    80 */   402,  424,  452,  476,  481, -155,  483,  489, -211, -370,
 /*    90 */   493,  505, -324,  518, -194,  528,  134,  630,  213,  358,
 /*   100 */   652,  667,  227,  615,  384,  230,  460,  610,  194, -246,
 /*   110 */  -423, -423, -253, -298, -186,  334,  674,  681,  683,  697,
 /*   120 */   706,  734,  763,  766,  768,  778,  779,  819,  820,  824,
 /*   130 */   826,  830,  832, -184, -175,  144, -299,  -14, -175,  111,
 /*   140 */   291,   67, -250,  206,  246,  168,  223,  352,  -80, -360,
 /*   150 */   347,  450,  514,  102,  654,  656,  492,  694, -328,  507,
 /*   160 */   564,  663,  704,  709,  751,  704,  536,  788,  822,  784,
 /*   170 */   718,  754,  878,  770,  890,  898,  885,  885,  911,  866,
 /*   180 */   918,  932,  881,  901,  841,  841,  827,  841,  854,  845,
 /*   190 */   885,  909,  926,  941,  978,  979,  981,  985, 1034, 1036,
 /*   200 */   992,  995,  997, 1032, 1037, 1047, 1042, 1050, 1051, 1054,
 /*   210 */  1062, 1060, 1066, 1061,  993, 1057, 1021, 1059, 1067, 1011,
 /*   220 */  1064, 1071, 1069, 1076, 1077, 1079, 1078, 1070, 1082, 1088,
 /*   230 */  1068, 1072, 1081, 1083, 1084, 1086, 1090, 1097, 1099, 1101,
 /*   240 */  1104, 1089, 1095, 1043, 1052, 1094, 1019, 1024, 1027, 1091,
 /*   250 */  1035, 1038, 1102, 1122, 1045, 1106, 1093, 1096, 1105, 1022,
 /*   260 */  1098, 1112, 1025, 1108, 1120, 1124,  885, 1048, 1058, 1080,
 /*   270 */  1085, 1087, 1092, 1103, 1044, 1111, 1109,  841, 1194, 1114,
 /*   280 */  1196, 1199, 1198, 1200, 1155, 1158, 1170, 1171, 1174, 1176,
 /*   290 */  1177, 1169, 1186, 1179, 1227, 1216, 1233, 1228, 1145, 1213,
 /*   300 */  1203, 1226, 1247, 1246, 1256, 1260, 1192, 1182, 1202, 1208,
 /*   310 */  1234, 1237, 1241, 1248, 1271,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*    10 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*    20 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*    30 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*    40 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*    50 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*    60 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*    70 */  1738, 1738, 1738, 1738, 2015, 1738, 1738, 1738, 1738, 1738,
 /*    80 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1824, 1738,
 /*    90 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   100 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1822, 2008,
 /*   110 */  2229, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   120 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   130 */  1738, 1738, 1738, 1738, 2241, 1738, 1738, 1738, 2241, 2241,
 /*   140 */  2241, 1822, 2201, 2201, 1738, 1738, 1738, 1738, 1824, 2073,
 /*   150 */  1738, 1738, 1738, 1738, 1738, 1738, 1943, 1738, 1738, 1738,
 /*   160 */  1738, 1738, 1967, 1738, 1738, 1738, 2067, 1738, 1738, 2266,
 /*   170 */  2322, 1738, 1738, 2269, 1738, 1738, 1738, 1738, 1738, 2020,
 /*   180 */  1738, 1738, 1897, 2256, 2233, 2247, 2306, 2234, 2231, 2250,
 /*   190 */  1738, 2260, 1738, 2054, 2013, 1738, 2013, 2010, 1738, 1738,
 /*   200 */  2013, 2010, 2010, 1886, 1882, 1738, 1880, 1738, 1738, 1738,
 /*   210 */  1738, 1785, 1738, 1785, 1738, 1824, 1738, 1824, 1738, 1738,
 /*   220 */  1824, 1738, 1824, 1824, 1824, 1738, 1824, 1799, 1799, 1738,
 /*   230 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   240 */  1738, 1738, 1738, 1738, 1738, 1738, 2085, 2071, 1738, 1822,
 /*   250 */  2065, 2063, 1738, 1822, 2061, 1738, 1738, 1738, 1738, 2277,
 /*   260 */  2275, 1738, 2277, 2275, 1738, 1738, 1738, 2291, 2287, 2277,
 /*   270 */  2295, 2293, 2262, 2260, 2325, 2312, 2308, 2247, 1738, 1738,
 /*   280 */  1738, 1738, 1822, 1822, 1738, 2275, 1738, 1738, 1738, 1738,
 /*   290 */  1738, 2275, 1738, 1738, 1822, 1738, 1822, 1738, 1738, 1913,
 /*   300 */  1738, 1738, 1738, 1822, 1770, 1738, 2056, 2076, 2038, 2038,
 /*   310 */  1946, 1946, 1946, 1825, 1743, 1738, 1738, 1738, 1738, 1738,
 /*   320 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 2290, 2289, 2156,
 /*   330 */  1738, 2205, 2204, 2203, 2194, 2155, 1909, 1738, 2154, 2153,
 /*   340 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 2029,
 /*   350 */  2028, 2147, 1738, 1738, 2148, 2146, 2145, 1738, 1738, 1738,
 /*   360 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   370 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   380 */  1738, 2309, 2313, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   390 */  2230, 1738, 1738, 1738, 2129, 1738, 1738, 1738, 1738, 1738,
 /*   400 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   410 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   420 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   430 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   440 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   450 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   460 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   470 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   480 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   490 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   500 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   510 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1775, 2134, 1738,
 /*   520 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   530 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   540 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   550 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   560 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1863, 1862, 1738,
 /*   570 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   580 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   590 */  1738, 2138, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   600 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 2305, 2263,
 /*   610 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   620 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 2129, 1738,
 /*   630 */  2288, 1738, 1738, 2303, 1738, 2307, 1738, 1738, 1738, 1738,
 /*   640 */  1738, 1738, 1738, 2240, 2236, 1738, 1738, 2232, 1738, 1738,
 /*   650 */  1738, 1738, 1738, 1738, 1738, 2137, 1738, 1738, 1738, 1738,
 /*   660 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 2128,
 /*   670 */  1738, 2191, 1738, 1738, 1738, 2225, 1738, 1738, 2176, 1738,
 /*   680 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 2138, 1738,
 /*   690 */  2141, 1738, 1738, 1738, 1738, 1738, 1940, 1738, 1738, 1738,
 /*   700 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1925,
 /*   710 */  1923, 1922, 1921, 1738, 1953, 1738, 1738, 1738, 1949, 1948,
 /*   720 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   730 */  1738, 1738, 1738, 1843, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   740 */  1738, 1738, 1835, 1738, 1834, 1738, 1738, 1738, 1738, 1738,
 /*   750 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   760 */  1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738, 1738,
 /*   770 */  1738, 1738, 1738, 1738, 1738, 1738, 1738,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*       WITH => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /*    RESTORE => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*      VNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      START => nothing */
    0,  /*  TIMESTAMP => nothing */
  281,  /*        END => ABORT */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*   LANGUAGE => nothing */
    0,  /*    REPLACE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*     LEADER => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  281,  /*      AFTER => ABORT */
  281,  /*     ATTACH => ABORT */
  281,  /*     BEFORE => ABORT */
  281,  /*      BEGIN => ABORT */
  281,  /*     BITAND => ABORT */
  281,  /*     BITNOT => ABORT */
  281,  /*      BITOR => ABORT */
  281,  /*     BLOCKS => ABORT */
  281,  /*     CHANGE => ABORT */
  281,  /*      COMMA => ABORT */
  281,  /*     CONCAT => ABORT */
  281,  /*   CONFLICT => ABORT */
  281,  /*       COPY => ABORT */
  281,  /*   DEFERRED => ABORT */
  281,  /* DELIMITERS => ABORT */
  281,  /*     DETACH => ABORT */
  281,  /*     DIVIDE => ABORT */
  281,  /*        DOT => ABORT */
  281,  /*       EACH => ABORT */
  281,  /*       FAIL => ABORT */
  281,  /*       FILE => ABORT */
  281,  /*        FOR => ABORT */
  281,  /*       GLOB => ABORT */
  281,  /*         ID => ABORT */
  281,  /*  IMMEDIATE => ABORT */
  281,  /*     IMPORT => ABORT */
  281,  /*  INITIALLY => ABORT */
  281,  /*    INSTEAD => ABORT */
  281,  /*     ISNULL => ABORT */
  281,  /*        KEY => ABORT */
  281,  /*    MODULES => ABORT */
  281,  /*  NK_BITNOT => ABORT */
  281,  /*    NK_SEMI => ABORT */
  281,  /*    NOTNULL => ABORT */
  281,  /*         OF => ABORT */
  281,  /*       PLUS => ABORT */
  281,  /*  PRIVILEGE => ABORT */
  281,  /*      RAISE => ABORT */
  281,  /*   RESTRICT => ABORT */
  281,  /*        ROW => ABORT */
  281,  /*       SEMI => ABORT */
  281,  /*       STAR => ABORT */
  281,  /*  STATEMENT => ABORT */
  281,  /*     STRICT => ABORT */
  281,  /*     STRING => ABORT */
  281,  /*      TIMES => ABORT */
  281,  /*     VALUES => ABORT */
  281,  /*   VARIABLE => ABORT */
  281,  /*       VIEW => ABORT */
  281,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "WITH",
  /*   49 */ "DNODE",
  /*   50 */ "PORT",
  /*   51 */ "DNODES",
  /*   52 */ "RESTORE",
  /*   53 */ "NK_IPTOKEN",
  /*   54 */ "FORCE",
  /*   55 */ "LOCAL",
  /*   56 */ "QNODE",
  /*   57 */ "BNODE",
  /*   58 */ "SNODE",
  /*   59 */ "MNODE",
  /*   60 */ "VNODE",
  /*   61 */ "DATABASE",
  /*   62 */ "USE",
  /*   63 */ "FLUSH",
  /*   64 */ "TRIM",
  /*   65 */ "COMPACT",
  /*   66 */ "IF",
  /*   67 */ "NOT",
  /*   68 */ "EXISTS",
  /*   69 */ "BUFFER",
  /*   70 */ "CACHEMODEL",
  /*   71 */ "CACHESIZE",
  /*   72 */ "COMP",
  /*   73 */ "DURATION",
  /*   74 */ "NK_VARIABLE",
  /*   75 */ "MAXROWS",
  /*   76 */ "MINROWS",
  /*   77 */ "KEEP",
  /*   78 */ "PAGES",
  /*   79 */ "PAGESIZE",
  /*   80 */ "TSDB_PAGESIZE",
  /*   81 */ "PRECISION",
  /*   82 */ "REPLICA",
  /*   83 */ "VGROUPS",
  /*   84 */ "SINGLE_STABLE",
  /*   85 */ "RETENTIONS",
  /*   86 */ "SCHEMALESS",
  /*   87 */ "WAL_LEVEL",
  /*   88 */ "WAL_FSYNC_PERIOD",
  /*   89 */ "WAL_RETENTION_PERIOD",
  /*   90 */ "WAL_RETENTION_SIZE",
  /*   91 */ "WAL_ROLL_PERIOD",
  /*   92 */ "WAL_SEGMENT_SIZE",
  /*   93 */ "STT_TRIGGER",
  /*   94 */ "TABLE_PREFIX",
  /*   95 */ "TABLE_SUFFIX",
  /*   96 */ "NK_COLON",
  /*   97 */ "MAX_SPEED",
  /*   98 */ "START",
  /*   99 */ "TIMESTAMP",
  /*  100 */ "END",
  /*  101 */ "TABLE",
  /*  102 */ "NK_LP",
  /*  103 */ "NK_RP",
  /*  104 */ "STABLE",
  /*  105 */ "ADD",
  /*  106 */ "COLUMN",
  /*  107 */ "MODIFY",
  /*  108 */ "RENAME",
  /*  109 */ "TAG",
  /*  110 */ "SET",
  /*  111 */ "NK_EQ",
  /*  112 */ "USING",
  /*  113 */ "TAGS",
  /*  114 */ "BOOL",
  /*  115 */ "TINYINT",
  /*  116 */ "SMALLINT",
  /*  117 */ "INT",
  /*  118 */ "INTEGER",
  /*  119 */ "BIGINT",
  /*  120 */ "FLOAT",
  /*  121 */ "DOUBLE",
  /*  122 */ "BINARY",
  /*  123 */ "NCHAR",
  /*  124 */ "UNSIGNED",
  /*  125 */ "JSON",
  /*  126 */ "VARCHAR",
  /*  127 */ "MEDIUMBLOB",
  /*  128 */ "BLOB",
  /*  129 */ "VARBINARY",
  /*  130 */ "DECIMAL",
  /*  131 */ "COMMENT",
  /*  132 */ "MAX_DELAY",
  /*  133 */ "WATERMARK",
  /*  134 */ "ROLLUP",
  /*  135 */ "TTL",
  /*  136 */ "SMA",
  /*  137 */ "DELETE_MARK",
  /*  138 */ "FIRST",
  /*  139 */ "LAST",
  /*  140 */ "SHOW",
  /*  141 */ "PRIVILEGES",
  /*  142 */ "DATABASES",
  /*  143 */ "TABLES",
  /*  144 */ "STABLES",
  /*  145 */ "MNODES",
  /*  146 */ "QNODES",
  /*  147 */ "FUNCTIONS",
  /*  148 */ "INDEXES",
  /*  149 */ "ACCOUNTS",
  /*  150 */ "APPS",
  /*  151 */ "CONNECTIONS",
  /*  152 */ "LICENCES",
  /*  153 */ "GRANTS",
  /*  154 */ "QUERIES",
  /*  155 */ "SCORES",
  /*  156 */ "TOPICS",
  /*  157 */ "VARIABLES",
  /*  158 */ "CLUSTER",
  /*  159 */ "BNODES",
  /*  160 */ "SNODES",
  /*  161 */ "TRANSACTIONS",
  /*  162 */ "DISTRIBUTED",
  /*  163 */ "CONSUMERS",
  /*  164 */ "SUBSCRIPTIONS",
  /*  165 */ "VNODES",
  /*  166 */ "ALIVE",
  /*  167 */ "LIKE",
  /*  168 */ "TBNAME",
  /*  169 */ "QTAGS",
  /*  170 */ "AS",
  /*  171 */ "INDEX",
  /*  172 */ "FUNCTION",
  /*  173 */ "INTERVAL",
  /*  174 */ "COUNT",
  /*  175 */ "LAST_ROW",
  /*  176 */ "TOPIC",
  /*  177 */ "META",
  /*  178 */ "CONSUMER",
  /*  179 */ "GROUP",
  /*  180 */ "DESC",
  /*  181 */ "DESCRIBE",
  /*  182 */ "RESET",
  /*  183 */ "QUERY",
  /*  184 */ "CACHE",
  /*  185 */ "EXPLAIN",
  /*  186 */ "ANALYZE",
  /*  187 */ "VERBOSE",
  /*  188 */ "NK_BOOL",
  /*  189 */ "RATIO",
  /*  190 */ "NK_FLOAT",
  /*  191 */ "OUTPUTTYPE",
  /*  192 */ "AGGREGATE",
  /*  193 */ "BUFSIZE",
  /*  194 */ "LANGUAGE",
  /*  195 */ "REPLACE",
  /*  196 */ "STREAM",
  /*  197 */ "INTO",
  /*  198 */ "TRIGGER",
  /*  199 */ "AT_ONCE",
  /*  200 */ "WINDOW_CLOSE",
  /*  201 */ "IGNORE",
  /*  202 */ "EXPIRED",
  /*  203 */ "FILL_HISTORY",
  /*  204 */ "UPDATE",
  /*  205 */ "SUBTABLE",
  /*  206 */ "KILL",
  /*  207 */ "CONNECTION",
  /*  208 */ "TRANSACTION",
  /*  209 */ "BALANCE",
  /*  210 */ "VGROUP",
  /*  211 */ "LEADER",
  /*  212 */ "MERGE",
  /*  213 */ "REDISTRIBUTE",
  /*  214 */ "SPLIT",
  /*  215 */ "DELETE",
  /*  216 */ "INSERT",
  /*  217 */ "NULL",
  /*  218 */ "NK_QUESTION",
  /*  219 */ "NK_ARROW",
  /*  220 */ "ROWTS",
  /*  221 */ "QSTART",
  /*  222 */ "QEND",
  /*  223 */ "QDURATION",
  /*  224 */ "WSTART",
  /*  225 */ "WEND",
  /*  226 */ "WDURATION",
  /*  227 */ "IROWTS",
  /*  228 */ "ISFILLED",
  /*  229 */ "CAST",
  /*  230 */ "NOW",
  /*  231 */ "TODAY",
  /*  232 */ "TIMEZONE",
  /*  233 */ "CLIENT_VERSION",
  /*  234 */ "SERVER_VERSION",
  /*  235 */ "SERVER_STATUS",
  /*  236 */ "CURRENT_USER",
  /*  237 */ "CASE",
  /*  238 */ "WHEN",
  /*  239 */ "THEN",
  /*  240 */ "ELSE",
  /*  241 */ "BETWEEN",
  /*  242 */ "IS",
  /*  243 */ "NK_LT",
  /*  244 */ "NK_GT",
  /*  245 */ "NK_LE",
  /*  246 */ "NK_GE",
  /*  247 */ "NK_NE",
  /*  248 */ "MATCH",
  /*  249 */ "NMATCH",
  /*  250 */ "CONTAINS",
  /*  251 */ "IN",
  /*  252 */ "JOIN",
  /*  253 */ "INNER",
  /*  254 */ "SELECT",
  /*  255 */ "DISTINCT",
  /*  256 */ "WHERE",
  /*  257 */ "PARTITION",
  /*  258 */ "BY",
  /*  259 */ "SESSION",
  /*  260 */ "STATE_WINDOW",
  /*  261 */ "EVENT_WINDOW",
  /*  262 */ "SLIDING",
  /*  263 */ "FILL",
  /*  264 */ "VALUE",
  /*  265 */ "VALUE_F",
  /*  266 */ "NONE",
  /*  267 */ "PREV",
  /*  268 */ "NULL_F",
  /*  269 */ "LINEAR",
  /*  270 */ "NEXT",
  /*  271 */ "HAVING",
  /*  272 */ "RANGE",
  /*  273 */ "EVERY",
  /*  274 */ "ORDER",
  /*  275 */ "SLIMIT",
  /*  276 */ "SOFFSET",
  /*  277 */ "LIMIT",
  /*  278 */ "OFFSET",
  /*  279 */ "ASC",
  /*  280 */ "NULLS",
  /*  281 */ "ABORT",
  /*  282 */ "AFTER",
  /*  283 */ "ATTACH",
  /*  284 */ "BEFORE",
  /*  285 */ "BEGIN",
  /*  286 */ "BITAND",
  /*  287 */ "BITNOT",
  /*  288 */ "BITOR",
  /*  289 */ "BLOCKS",
  /*  290 */ "CHANGE",
  /*  291 */ "COMMA",
  /*  292 */ "CONCAT",
  /*  293 */ "CONFLICT",
  /*  294 */ "COPY",
  /*  295 */ "DEFERRED",
  /*  296 */ "DELIMITERS",
  /*  297 */ "DETACH",
  /*  298 */ "DIVIDE",
  /*  299 */ "DOT",
  /*  300 */ "EACH",
  /*  301 */ "FAIL",
  /*  302 */ "FILE",
  /*  303 */ "FOR",
  /*  304 */ "GLOB",
  /*  305 */ "ID",
  /*  306 */ "IMMEDIATE",
  /*  307 */ "IMPORT",
  /*  308 */ "INITIALLY",
  /*  309 */ "INSTEAD",
  /*  310 */ "ISNULL",
  /*  311 */ "KEY",
  /*  312 */ "MODULES",
  /*  313 */ "NK_BITNOT",
  /*  314 */ "NK_SEMI",
  /*  315 */ "NOTNULL",
  /*  316 */ "OF",
  /*  317 */ "PLUS",
  /*  318 */ "PRIVILEGE",
  /*  319 */ "RAISE",
  /*  320 */ "RESTRICT",
  /*  321 */ "ROW",
  /*  322 */ "SEMI",
  /*  323 */ "STAR",
  /*  324 */ "STATEMENT",
  /*  325 */ "STRICT",
  /*  326 */ "STRING",
  /*  327 */ "TIMES",
  /*  328 */ "VALUES",
  /*  329 */ "VARIABLE",
  /*  330 */ "VIEW",
  /*  331 */ "WAL",
  /*  332 */ "cmd",
  /*  333 */ "account_options",
  /*  334 */ "alter_account_options",
  /*  335 */ "literal",
  /*  336 */ "alter_account_option",
  /*  337 */ "user_name",
  /*  338 */ "sysinfo_opt",
  /*  339 */ "privileges",
  /*  340 */ "priv_level",
  /*  341 */ "with_opt",
  /*  342 */ "priv_type_list",
  /*  343 */ "priv_type",
  /*  344 */ "db_name",
  /*  345 */ "table_name",
  /*  346 */ "topic_name",
  /*  347 */ "search_condition",
  /*  348 */ "dnode_endpoint",
  /*  349 */ "force_opt",
  /*  350 */ "not_exists_opt",
  /*  351 */ "db_options",
  /*  352 */ "exists_opt",
  /*  353 */ "alter_db_options",
  /*  354 */ "speed_opt",
  /*  355 */ "start_opt",
  /*  356 */ "end_opt",
  /*  357 */ "integer_list",
  /*  358 */ "variable_list",
  /*  359 */ "retention_list",
  /*  360 */ "signed",
  /*  361 */ "alter_db_option",
  /*  362 */ "retention",
  /*  363 */ "full_table_name",
  /*  364 */ "column_def_list",
  /*  365 */ "tags_def_opt",
  /*  366 */ "table_options",
  /*  367 */ "multi_create_clause",
  /*  368 */ "tags_def",
  /*  369 */ "multi_drop_clause",
  /*  370 */ "alter_table_clause",
  /*  371 */ "alter_table_options",
  /*  372 */ "column_name",
  /*  373 */ "type_name",
  /*  374 */ "signed_literal",
  /*  375 */ "create_subtable_clause",
  /*  376 */ "specific_cols_opt",
  /*  377 */ "expression_list",
  /*  378 */ "drop_table_clause",
  /*  379 */ "col_name_list",
  /*  380 */ "column_def",
  /*  381 */ "duration_list",
  /*  382 */ "rollup_func_list",
  /*  383 */ "alter_table_option",
  /*  384 */ "duration_literal",
  /*  385 */ "rollup_func_name",
  /*  386 */ "function_name",
  /*  387 */ "col_name",
  /*  388 */ "db_name_cond_opt",
  /*  389 */ "like_pattern_opt",
  /*  390 */ "table_name_cond",
  /*  391 */ "from_db_opt",
  /*  392 */ "tag_list_opt",
  /*  393 */ "tag_item",
  /*  394 */ "column_alias",
  /*  395 */ "full_index_name",
  /*  396 */ "index_options",
  /*  397 */ "index_name",
  /*  398 */ "func_list",
  /*  399 */ "sliding_opt",
  /*  400 */ "sma_stream_opt",
  /*  401 */ "func",
  /*  402 */ "sma_func_name",
  /*  403 */ "query_or_subquery",
  /*  404 */ "cgroup_name",
  /*  405 */ "analyze_opt",
  /*  406 */ "explain_options",
  /*  407 */ "insert_query",
  /*  408 */ "or_replace_opt",
  /*  409 */ "agg_func_opt",
  /*  410 */ "bufsize_opt",
  /*  411 */ "language_opt",
  /*  412 */ "stream_name",
  /*  413 */ "stream_options",
  /*  414 */ "col_list_opt",
  /*  415 */ "tag_def_or_ref_opt",
  /*  416 */ "subtable_opt",
  /*  417 */ "expression",
  /*  418 */ "dnode_list",
  /*  419 */ "where_clause_opt",
  /*  420 */ "literal_func",
  /*  421 */ "literal_list",
  /*  422 */ "table_alias",
  /*  423 */ "expr_or_subquery",
  /*  424 */ "pseudo_column",
  /*  425 */ "column_reference",
  /*  426 */ "function_expression",
  /*  427 */ "case_when_expression",
  /*  428 */ "star_func",
  /*  429 */ "star_func_para_list",
  /*  430 */ "noarg_func",
  /*  431 */ "other_para_list",
  /*  432 */ "star_func_para",
  /*  433 */ "when_then_list",
  /*  434 */ "case_when_else_opt",
  /*  435 */ "common_expression",
  /*  436 */ "when_then_expr",
  /*  437 */ "predicate",
  /*  438 */ "compare_op",
  /*  439 */ "in_op",
  /*  440 */ "in_predicate_value",
  /*  441 */ "boolean_value_expression",
  /*  442 */ "boolean_primary",
  /*  443 */ "from_clause_opt",
  /*  444 */ "table_reference_list",
  /*  445 */ "table_reference",
  /*  446 */ "table_primary",
  /*  447 */ "joined_table",
  /*  448 */ "alias_opt",
  /*  449 */ "subquery",
  /*  450 */ "parenthesized_joined_table",
  /*  451 */ "join_type",
  /*  452 */ "query_specification",
  /*  453 */ "set_quantifier_opt",
  /*  454 */ "select_list",
  /*  455 */ "partition_by_clause_opt",
  /*  456 */ "range_opt",
  /*  457 */ "every_opt",
  /*  458 */ "fill_opt",
  /*  459 */ "twindow_clause_opt",
  /*  460 */ "group_by_clause_opt",
  /*  461 */ "having_clause_opt",
  /*  462 */ "select_item",
  /*  463 */ "partition_list",
  /*  464 */ "partition_item",
  /*  465 */ "fill_mode",
  /*  466 */ "group_by_list",
  /*  467 */ "query_expression",
  /*  468 */ "query_simple",
  /*  469 */ "order_by_clause_opt",
  /*  470 */ "slimit_clause_opt",
  /*  471 */ "limit_clause_opt",
  /*  472 */ "union_query_expression",
  /*  473 */ "query_simple_or_subquery",
  /*  474 */ "sort_specification_list",
  /*  475 */ "sort_specification",
  /*  476 */ "ordering_specification_opt",
  /*  477 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level with_opt TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= db_name NK_DOT table_name",
 /*  43 */ "priv_level ::= topic_name",
 /*  44 */ "with_opt ::=",
 /*  45 */ "with_opt ::= WITH search_condition",
 /*  46 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  47 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  48 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  49 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  50 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  51 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  52 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  53 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  54 */ "cmd ::= RESTORE DNODE NK_INTEGER",
 /*  55 */ "dnode_endpoint ::= NK_STRING",
 /*  56 */ "dnode_endpoint ::= NK_ID",
 /*  57 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  58 */ "force_opt ::=",
 /*  59 */ "force_opt ::= FORCE",
 /*  60 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  61 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  62 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= RESTORE QNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  67 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  68 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  69 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  70 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  71 */ "cmd ::= RESTORE MNODE ON DNODE NK_INTEGER",
 /*  72 */ "cmd ::= RESTORE VNODE ON DNODE NK_INTEGER",
 /*  73 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  74 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  75 */ "cmd ::= USE db_name",
 /*  76 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  77 */ "cmd ::= FLUSH DATABASE db_name",
 /*  78 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  79 */ "cmd ::= COMPACT DATABASE db_name start_opt end_opt",
 /*  80 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  81 */ "not_exists_opt ::=",
 /*  82 */ "exists_opt ::= IF EXISTS",
 /*  83 */ "exists_opt ::=",
 /*  84 */ "db_options ::=",
 /*  85 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  86 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  87 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  88 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  89 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  90 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  91 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  92 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  93 */ "db_options ::= db_options KEEP integer_list",
 /*  94 */ "db_options ::= db_options KEEP variable_list",
 /*  95 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  96 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  97 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  98 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  99 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /* 100 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /* 101 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /* 102 */ "db_options ::= db_options RETENTIONS retention_list",
 /* 103 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /* 105 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /* 106 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 107 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 108 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 109 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 110 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 111 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 112 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 113 */ "db_options ::= db_options TABLE_PREFIX signed",
 /* 114 */ "db_options ::= db_options TABLE_SUFFIX signed",
 /* 115 */ "alter_db_options ::= alter_db_option",
 /* 116 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 117 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 118 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 119 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 120 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 121 */ "alter_db_option ::= KEEP integer_list",
 /* 122 */ "alter_db_option ::= KEEP variable_list",
 /* 123 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 124 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 125 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 126 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 127 */ "alter_db_option ::= MINROWS NK_INTEGER",
 /* 128 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER",
 /* 129 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 130 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER",
 /* 131 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 132 */ "integer_list ::= NK_INTEGER",
 /* 133 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 134 */ "variable_list ::= NK_VARIABLE",
 /* 135 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 136 */ "retention_list ::= retention",
 /* 137 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 138 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 139 */ "speed_opt ::=",
 /* 140 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 141 */ "start_opt ::=",
 /* 142 */ "start_opt ::= START WITH NK_INTEGER",
 /* 143 */ "start_opt ::= START WITH NK_STRING",
 /* 144 */ "start_opt ::= START WITH TIMESTAMP NK_STRING",
 /* 145 */ "end_opt ::=",
 /* 146 */ "end_opt ::= END WITH NK_INTEGER",
 /* 147 */ "end_opt ::= END WITH NK_STRING",
 /* 148 */ "end_opt ::= END WITH TIMESTAMP NK_STRING",
 /* 149 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 150 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 151 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 152 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 153 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 154 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 155 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 156 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 157 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 158 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 159 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 160 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 161 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 162 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 163 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 164 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 165 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 166 */ "multi_create_clause ::= create_subtable_clause",
 /* 167 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 168 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 169 */ "multi_drop_clause ::= drop_table_clause",
 /* 170 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 171 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 172 */ "specific_cols_opt ::=",
 /* 173 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 174 */ "full_table_name ::= table_name",
 /* 175 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 176 */ "column_def_list ::= column_def",
 /* 177 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 178 */ "column_def ::= column_name type_name",
 /* 179 */ "type_name ::= BOOL",
 /* 180 */ "type_name ::= TINYINT",
 /* 181 */ "type_name ::= SMALLINT",
 /* 182 */ "type_name ::= INT",
 /* 183 */ "type_name ::= INTEGER",
 /* 184 */ "type_name ::= BIGINT",
 /* 185 */ "type_name ::= FLOAT",
 /* 186 */ "type_name ::= DOUBLE",
 /* 187 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 188 */ "type_name ::= TIMESTAMP",
 /* 189 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 190 */ "type_name ::= TINYINT UNSIGNED",
 /* 191 */ "type_name ::= SMALLINT UNSIGNED",
 /* 192 */ "type_name ::= INT UNSIGNED",
 /* 193 */ "type_name ::= BIGINT UNSIGNED",
 /* 194 */ "type_name ::= JSON",
 /* 195 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 196 */ "type_name ::= MEDIUMBLOB",
 /* 197 */ "type_name ::= BLOB",
 /* 198 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 199 */ "type_name ::= DECIMAL",
 /* 200 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 201 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 202 */ "tags_def_opt ::=",
 /* 203 */ "tags_def_opt ::= tags_def",
 /* 204 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 205 */ "table_options ::=",
 /* 206 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 207 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 208 */ "table_options ::= table_options WATERMARK duration_list",
 /* 209 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 210 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 211 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 212 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 213 */ "alter_table_options ::= alter_table_option",
 /* 214 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 215 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 216 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 217 */ "duration_list ::= duration_literal",
 /* 218 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 219 */ "rollup_func_list ::= rollup_func_name",
 /* 220 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 221 */ "rollup_func_name ::= function_name",
 /* 222 */ "rollup_func_name ::= FIRST",
 /* 223 */ "rollup_func_name ::= LAST",
 /* 224 */ "col_name_list ::= col_name",
 /* 225 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 226 */ "col_name ::= column_name",
 /* 227 */ "cmd ::= SHOW DNODES",
 /* 228 */ "cmd ::= SHOW USERS",
 /* 229 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 230 */ "cmd ::= SHOW DATABASES",
 /* 231 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 232 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 233 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 234 */ "cmd ::= SHOW MNODES",
 /* 235 */ "cmd ::= SHOW QNODES",
 /* 236 */ "cmd ::= SHOW FUNCTIONS",
 /* 237 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 238 */ "cmd ::= SHOW STREAMS",
 /* 239 */ "cmd ::= SHOW ACCOUNTS",
 /* 240 */ "cmd ::= SHOW APPS",
 /* 241 */ "cmd ::= SHOW CONNECTIONS",
 /* 242 */ "cmd ::= SHOW LICENCES",
 /* 243 */ "cmd ::= SHOW GRANTS",
 /* 244 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 245 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 246 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 247 */ "cmd ::= SHOW QUERIES",
 /* 248 */ "cmd ::= SHOW SCORES",
 /* 249 */ "cmd ::= SHOW TOPICS",
 /* 250 */ "cmd ::= SHOW VARIABLES",
 /* 251 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 252 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 253 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 254 */ "cmd ::= SHOW BNODES",
 /* 255 */ "cmd ::= SHOW SNODES",
 /* 256 */ "cmd ::= SHOW CLUSTER",
 /* 257 */ "cmd ::= SHOW TRANSACTIONS",
 /* 258 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 259 */ "cmd ::= SHOW CONSUMERS",
 /* 260 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 261 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 262 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 263 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 264 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 265 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 266 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 267 */ "db_name_cond_opt ::=",
 /* 268 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 269 */ "like_pattern_opt ::=",
 /* 270 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 271 */ "table_name_cond ::= table_name",
 /* 272 */ "from_db_opt ::=",
 /* 273 */ "from_db_opt ::= FROM db_name",
 /* 274 */ "tag_list_opt ::=",
 /* 275 */ "tag_list_opt ::= tag_item",
 /* 276 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 277 */ "tag_item ::= TBNAME",
 /* 278 */ "tag_item ::= QTAGS",
 /* 279 */ "tag_item ::= column_name",
 /* 280 */ "tag_item ::= column_name column_alias",
 /* 281 */ "tag_item ::= column_name AS column_alias",
 /* 282 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 283 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 284 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 285 */ "full_index_name ::= index_name",
 /* 286 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 287 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 288 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 289 */ "func_list ::= func",
 /* 290 */ "func_list ::= func_list NK_COMMA func",
 /* 291 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 292 */ "sma_func_name ::= function_name",
 /* 293 */ "sma_func_name ::= COUNT",
 /* 294 */ "sma_func_name ::= FIRST",
 /* 295 */ "sma_func_name ::= LAST",
 /* 296 */ "sma_func_name ::= LAST_ROW",
 /* 297 */ "sma_stream_opt ::=",
 /* 298 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 299 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 300 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 301 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 302 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 303 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 304 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 305 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 306 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 307 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 308 */ "cmd ::= DESC full_table_name",
 /* 309 */ "cmd ::= DESCRIBE full_table_name",
 /* 310 */ "cmd ::= RESET QUERY CACHE",
 /* 311 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 312 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 313 */ "analyze_opt ::=",
 /* 314 */ "analyze_opt ::= ANALYZE",
 /* 315 */ "explain_options ::=",
 /* 316 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 317 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 318 */ "cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt",
 /* 319 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 320 */ "agg_func_opt ::=",
 /* 321 */ "agg_func_opt ::= AGGREGATE",
 /* 322 */ "bufsize_opt ::=",
 /* 323 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 324 */ "language_opt ::=",
 /* 325 */ "language_opt ::= LANGUAGE NK_STRING",
 /* 326 */ "or_replace_opt ::=",
 /* 327 */ "or_replace_opt ::= OR REPLACE",
 /* 328 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 329 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 330 */ "col_list_opt ::=",
 /* 331 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 332 */ "tag_def_or_ref_opt ::=",
 /* 333 */ "tag_def_or_ref_opt ::= tags_def",
 /* 334 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 335 */ "stream_options ::=",
 /* 336 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 337 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 338 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 339 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 340 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 341 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 342 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 343 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 344 */ "subtable_opt ::=",
 /* 345 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 346 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 347 */ "cmd ::= KILL QUERY NK_STRING",
 /* 348 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 349 */ "cmd ::= BALANCE VGROUP",
 /* 350 */ "cmd ::= BALANCE VGROUP LEADER",
 /* 351 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 352 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 353 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 354 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 355 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 356 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 357 */ "cmd ::= query_or_subquery",
 /* 358 */ "cmd ::= insert_query",
 /* 359 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 360 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 361 */ "literal ::= NK_INTEGER",
 /* 362 */ "literal ::= NK_FLOAT",
 /* 363 */ "literal ::= NK_STRING",
 /* 364 */ "literal ::= NK_BOOL",
 /* 365 */ "literal ::= TIMESTAMP NK_STRING",
 /* 366 */ "literal ::= duration_literal",
 /* 367 */ "literal ::= NULL",
 /* 368 */ "literal ::= NK_QUESTION",
 /* 369 */ "duration_literal ::= NK_VARIABLE",
 /* 370 */ "signed ::= NK_INTEGER",
 /* 371 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 372 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 373 */ "signed ::= NK_FLOAT",
 /* 374 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 375 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 376 */ "signed_literal ::= signed",
 /* 377 */ "signed_literal ::= NK_STRING",
 /* 378 */ "signed_literal ::= NK_BOOL",
 /* 379 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 380 */ "signed_literal ::= duration_literal",
 /* 381 */ "signed_literal ::= NULL",
 /* 382 */ "signed_literal ::= literal_func",
 /* 383 */ "signed_literal ::= NK_QUESTION",
 /* 384 */ "literal_list ::= signed_literal",
 /* 385 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 386 */ "db_name ::= NK_ID",
 /* 387 */ "table_name ::= NK_ID",
 /* 388 */ "column_name ::= NK_ID",
 /* 389 */ "function_name ::= NK_ID",
 /* 390 */ "table_alias ::= NK_ID",
 /* 391 */ "column_alias ::= NK_ID",
 /* 392 */ "user_name ::= NK_ID",
 /* 393 */ "topic_name ::= NK_ID",
 /* 394 */ "stream_name ::= NK_ID",
 /* 395 */ "cgroup_name ::= NK_ID",
 /* 396 */ "index_name ::= NK_ID",
 /* 397 */ "expr_or_subquery ::= expression",
 /* 398 */ "expression ::= literal",
 /* 399 */ "expression ::= pseudo_column",
 /* 400 */ "expression ::= column_reference",
 /* 401 */ "expression ::= function_expression",
 /* 402 */ "expression ::= case_when_expression",
 /* 403 */ "expression ::= NK_LP expression NK_RP",
 /* 404 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 405 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 406 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 407 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 408 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 409 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 410 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 411 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 412 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 413 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 414 */ "expression_list ::= expr_or_subquery",
 /* 415 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 416 */ "column_reference ::= column_name",
 /* 417 */ "column_reference ::= table_name NK_DOT column_name",
 /* 418 */ "pseudo_column ::= ROWTS",
 /* 419 */ "pseudo_column ::= TBNAME",
 /* 420 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 421 */ "pseudo_column ::= QSTART",
 /* 422 */ "pseudo_column ::= QEND",
 /* 423 */ "pseudo_column ::= QDURATION",
 /* 424 */ "pseudo_column ::= WSTART",
 /* 425 */ "pseudo_column ::= WEND",
 /* 426 */ "pseudo_column ::= WDURATION",
 /* 427 */ "pseudo_column ::= IROWTS",
 /* 428 */ "pseudo_column ::= ISFILLED",
 /* 429 */ "pseudo_column ::= QTAGS",
 /* 430 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 431 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 432 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 433 */ "function_expression ::= literal_func",
 /* 434 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 435 */ "literal_func ::= NOW",
 /* 436 */ "noarg_func ::= NOW",
 /* 437 */ "noarg_func ::= TODAY",
 /* 438 */ "noarg_func ::= TIMEZONE",
 /* 439 */ "noarg_func ::= DATABASE",
 /* 440 */ "noarg_func ::= CLIENT_VERSION",
 /* 441 */ "noarg_func ::= SERVER_VERSION",
 /* 442 */ "noarg_func ::= SERVER_STATUS",
 /* 443 */ "noarg_func ::= CURRENT_USER",
 /* 444 */ "noarg_func ::= USER",
 /* 445 */ "star_func ::= COUNT",
 /* 446 */ "star_func ::= FIRST",
 /* 447 */ "star_func ::= LAST",
 /* 448 */ "star_func ::= LAST_ROW",
 /* 449 */ "star_func_para_list ::= NK_STAR",
 /* 450 */ "star_func_para_list ::= other_para_list",
 /* 451 */ "other_para_list ::= star_func_para",
 /* 452 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 453 */ "star_func_para ::= expr_or_subquery",
 /* 454 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 455 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 456 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 457 */ "when_then_list ::= when_then_expr",
 /* 458 */ "when_then_list ::= when_then_list when_then_expr",
 /* 459 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 460 */ "case_when_else_opt ::=",
 /* 461 */ "case_when_else_opt ::= ELSE common_expression",
 /* 462 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 463 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 464 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 465 */ "predicate ::= expr_or_subquery IS NULL",
 /* 466 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 467 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 468 */ "compare_op ::= NK_LT",
 /* 469 */ "compare_op ::= NK_GT",
 /* 470 */ "compare_op ::= NK_LE",
 /* 471 */ "compare_op ::= NK_GE",
 /* 472 */ "compare_op ::= NK_NE",
 /* 473 */ "compare_op ::= NK_EQ",
 /* 474 */ "compare_op ::= LIKE",
 /* 475 */ "compare_op ::= NOT LIKE",
 /* 476 */ "compare_op ::= MATCH",
 /* 477 */ "compare_op ::= NMATCH",
 /* 478 */ "compare_op ::= CONTAINS",
 /* 479 */ "in_op ::= IN",
 /* 480 */ "in_op ::= NOT IN",
 /* 481 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 482 */ "boolean_value_expression ::= boolean_primary",
 /* 483 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 484 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 485 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 486 */ "boolean_primary ::= predicate",
 /* 487 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 488 */ "common_expression ::= expr_or_subquery",
 /* 489 */ "common_expression ::= boolean_value_expression",
 /* 490 */ "from_clause_opt ::=",
 /* 491 */ "from_clause_opt ::= FROM table_reference_list",
 /* 492 */ "table_reference_list ::= table_reference",
 /* 493 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 494 */ "table_reference ::= table_primary",
 /* 495 */ "table_reference ::= joined_table",
 /* 496 */ "table_primary ::= table_name alias_opt",
 /* 497 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 498 */ "table_primary ::= subquery alias_opt",
 /* 499 */ "table_primary ::= parenthesized_joined_table",
 /* 500 */ "alias_opt ::=",
 /* 501 */ "alias_opt ::= table_alias",
 /* 502 */ "alias_opt ::= AS table_alias",
 /* 503 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 504 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 505 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 506 */ "join_type ::=",
 /* 507 */ "join_type ::= INNER",
 /* 508 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 509 */ "set_quantifier_opt ::=",
 /* 510 */ "set_quantifier_opt ::= DISTINCT",
 /* 511 */ "set_quantifier_opt ::= ALL",
 /* 512 */ "select_list ::= select_item",
 /* 513 */ "select_list ::= select_list NK_COMMA select_item",
 /* 514 */ "select_item ::= NK_STAR",
 /* 515 */ "select_item ::= common_expression",
 /* 516 */ "select_item ::= common_expression column_alias",
 /* 517 */ "select_item ::= common_expression AS column_alias",
 /* 518 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 519 */ "where_clause_opt ::=",
 /* 520 */ "where_clause_opt ::= WHERE search_condition",
 /* 521 */ "partition_by_clause_opt ::=",
 /* 522 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 523 */ "partition_list ::= partition_item",
 /* 524 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 525 */ "partition_item ::= expr_or_subquery",
 /* 526 */ "partition_item ::= expr_or_subquery column_alias",
 /* 527 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 528 */ "twindow_clause_opt ::=",
 /* 529 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 530 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 531 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 532 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 533 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 534 */ "sliding_opt ::=",
 /* 535 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 536 */ "fill_opt ::=",
 /* 537 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 538 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP",
 /* 539 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP",
 /* 540 */ "fill_mode ::= NONE",
 /* 541 */ "fill_mode ::= PREV",
 /* 542 */ "fill_mode ::= NULL",
 /* 543 */ "fill_mode ::= NULL_F",
 /* 544 */ "fill_mode ::= LINEAR",
 /* 545 */ "fill_mode ::= NEXT",
 /* 546 */ "group_by_clause_opt ::=",
 /* 547 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 548 */ "group_by_list ::= expr_or_subquery",
 /* 549 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 550 */ "having_clause_opt ::=",
 /* 551 */ "having_clause_opt ::= HAVING search_condition",
 /* 552 */ "range_opt ::=",
 /* 553 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 554 */ "every_opt ::=",
 /* 555 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 556 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 557 */ "query_simple ::= query_specification",
 /* 558 */ "query_simple ::= union_query_expression",
 /* 559 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 560 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 561 */ "query_simple_or_subquery ::= query_simple",
 /* 562 */ "query_simple_or_subquery ::= subquery",
 /* 563 */ "query_or_subquery ::= query_expression",
 /* 564 */ "query_or_subquery ::= subquery",
 /* 565 */ "order_by_clause_opt ::=",
 /* 566 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 567 */ "slimit_clause_opt ::=",
 /* 568 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 569 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 570 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 571 */ "limit_clause_opt ::=",
 /* 572 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 573 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 574 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 575 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 576 */ "subquery ::= NK_LP subquery NK_RP",
 /* 577 */ "search_condition ::= common_expression",
 /* 578 */ "sort_specification_list ::= sort_specification",
 /* 579 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 580 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 581 */ "ordering_specification_opt ::=",
 /* 582 */ "ordering_specification_opt ::= ASC",
 /* 583 */ "ordering_specification_opt ::= DESC",
 /* 584 */ "null_ordering_opt ::=",
 /* 585 */ "null_ordering_opt ::= NULLS FIRST",
 /* 586 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 332: /* cmd */
    case 335: /* literal */
    case 341: /* with_opt */
    case 347: /* search_condition */
    case 351: /* db_options */
    case 353: /* alter_db_options */
    case 355: /* start_opt */
    case 356: /* end_opt */
    case 360: /* signed */
    case 362: /* retention */
    case 363: /* full_table_name */
    case 366: /* table_options */
    case 370: /* alter_table_clause */
    case 371: /* alter_table_options */
    case 374: /* signed_literal */
    case 375: /* create_subtable_clause */
    case 378: /* drop_table_clause */
    case 380: /* column_def */
    case 384: /* duration_literal */
    case 385: /* rollup_func_name */
    case 387: /* col_name */
    case 388: /* db_name_cond_opt */
    case 389: /* like_pattern_opt */
    case 390: /* table_name_cond */
    case 391: /* from_db_opt */
    case 393: /* tag_item */
    case 395: /* full_index_name */
    case 396: /* index_options */
    case 399: /* sliding_opt */
    case 400: /* sma_stream_opt */
    case 401: /* func */
    case 403: /* query_or_subquery */
    case 406: /* explain_options */
    case 407: /* insert_query */
    case 413: /* stream_options */
    case 416: /* subtable_opt */
    case 417: /* expression */
    case 419: /* where_clause_opt */
    case 420: /* literal_func */
    case 423: /* expr_or_subquery */
    case 424: /* pseudo_column */
    case 425: /* column_reference */
    case 426: /* function_expression */
    case 427: /* case_when_expression */
    case 432: /* star_func_para */
    case 434: /* case_when_else_opt */
    case 435: /* common_expression */
    case 436: /* when_then_expr */
    case 437: /* predicate */
    case 440: /* in_predicate_value */
    case 441: /* boolean_value_expression */
    case 442: /* boolean_primary */
    case 443: /* from_clause_opt */
    case 444: /* table_reference_list */
    case 445: /* table_reference */
    case 446: /* table_primary */
    case 447: /* joined_table */
    case 449: /* subquery */
    case 450: /* parenthesized_joined_table */
    case 452: /* query_specification */
    case 456: /* range_opt */
    case 457: /* every_opt */
    case 458: /* fill_opt */
    case 459: /* twindow_clause_opt */
    case 461: /* having_clause_opt */
    case 462: /* select_item */
    case 464: /* partition_item */
    case 467: /* query_expression */
    case 468: /* query_simple */
    case 470: /* slimit_clause_opt */
    case 471: /* limit_clause_opt */
    case 472: /* union_query_expression */
    case 473: /* query_simple_or_subquery */
    case 475: /* sort_specification */
{
#line 7 "sql.y"
 nodesDestroyNode((yypminor->yy184)); 
#line 2813 "sql.c"
}
      break;
    case 333: /* account_options */
    case 334: /* alter_account_options */
    case 336: /* alter_account_option */
    case 354: /* speed_opt */
    case 410: /* bufsize_opt */
{
#line 54 "sql.y"
 
#line 2824 "sql.c"
}
      break;
    case 337: /* user_name */
    case 344: /* db_name */
    case 345: /* table_name */
    case 346: /* topic_name */
    case 348: /* dnode_endpoint */
    case 372: /* column_name */
    case 386: /* function_name */
    case 394: /* column_alias */
    case 397: /* index_name */
    case 402: /* sma_func_name */
    case 404: /* cgroup_name */
    case 411: /* language_opt */
    case 412: /* stream_name */
    case 422: /* table_alias */
    case 428: /* star_func */
    case 430: /* noarg_func */
    case 448: /* alias_opt */
{
#line 721 "sql.y"
 
#line 2847 "sql.c"
}
      break;
    case 338: /* sysinfo_opt */
{
#line 92 "sql.y"
 
#line 2854 "sql.c"
}
      break;
    case 339: /* privileges */
    case 342: /* priv_type_list */
    case 343: /* priv_type */
{
#line 101 "sql.y"
 
#line 2863 "sql.c"
}
      break;
    case 340: /* priv_level */
{
#line 117 "sql.y"
 
#line 2870 "sql.c"
}
      break;
    case 349: /* force_opt */
    case 350: /* not_exists_opt */
    case 352: /* exists_opt */
    case 405: /* analyze_opt */
    case 408: /* or_replace_opt */
    case 409: /* agg_func_opt */
    case 453: /* set_quantifier_opt */
{
#line 144 "sql.y"
 
#line 2883 "sql.c"
}
      break;
    case 357: /* integer_list */
    case 358: /* variable_list */
    case 359: /* retention_list */
    case 364: /* column_def_list */
    case 365: /* tags_def_opt */
    case 367: /* multi_create_clause */
    case 368: /* tags_def */
    case 369: /* multi_drop_clause */
    case 376: /* specific_cols_opt */
    case 377: /* expression_list */
    case 379: /* col_name_list */
    case 381: /* duration_list */
    case 382: /* rollup_func_list */
    case 392: /* tag_list_opt */
    case 398: /* func_list */
    case 414: /* col_list_opt */
    case 415: /* tag_def_or_ref_opt */
    case 418: /* dnode_list */
    case 421: /* literal_list */
    case 429: /* star_func_para_list */
    case 431: /* other_para_list */
    case 433: /* when_then_list */
    case 454: /* select_list */
    case 455: /* partition_by_clause_opt */
    case 460: /* group_by_clause_opt */
    case 463: /* partition_list */
    case 466: /* group_by_list */
    case 469: /* order_by_clause_opt */
    case 474: /* sort_specification_list */
{
#line 264 "sql.y"
 nodesDestroyList((yypminor->yy532)); 
#line 2918 "sql.c"
}
      break;
    case 361: /* alter_db_option */
    case 383: /* alter_table_option */
{
#line 237 "sql.y"
 
#line 2926 "sql.c"
}
      break;
    case 373: /* type_name */
{
#line 358 "sql.y"
 
#line 2933 "sql.c"
}
      break;
    case 438: /* compare_op */
    case 439: /* in_op */
{
#line 909 "sql.y"
 
#line 2941 "sql.c"
}
      break;
    case 451: /* join_type */
{
#line 985 "sql.y"
 
#line 2948 "sql.c"
}
      break;
    case 465: /* fill_mode */
{
#line 1060 "sql.y"
 
#line 2955 "sql.c"
}
      break;
    case 476: /* ordering_specification_opt */
{
#line 1143 "sql.y"
 
#line 2962 "sql.c"
}
      break;
    case 477: /* null_ordering_opt */
{
#line 1149 "sql.y"
 
#line 2969 "sql.c"
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<sizeof(yy_action)/sizeof(yy_action[0]) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
   332,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   332,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
   333,  /* (2) account_options ::= */
   333,  /* (3) account_options ::= account_options PPS literal */
   333,  /* (4) account_options ::= account_options TSERIES literal */
   333,  /* (5) account_options ::= account_options STORAGE literal */
   333,  /* (6) account_options ::= account_options STREAMS literal */
   333,  /* (7) account_options ::= account_options QTIME literal */
   333,  /* (8) account_options ::= account_options DBS literal */
   333,  /* (9) account_options ::= account_options USERS literal */
   333,  /* (10) account_options ::= account_options CONNS literal */
   333,  /* (11) account_options ::= account_options STATE literal */
   334,  /* (12) alter_account_options ::= alter_account_option */
   334,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   336,  /* (14) alter_account_option ::= PASS literal */
   336,  /* (15) alter_account_option ::= PPS literal */
   336,  /* (16) alter_account_option ::= TSERIES literal */
   336,  /* (17) alter_account_option ::= STORAGE literal */
   336,  /* (18) alter_account_option ::= STREAMS literal */
   336,  /* (19) alter_account_option ::= QTIME literal */
   336,  /* (20) alter_account_option ::= DBS literal */
   336,  /* (21) alter_account_option ::= USERS literal */
   336,  /* (22) alter_account_option ::= CONNS literal */
   336,  /* (23) alter_account_option ::= STATE literal */
   332,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   332,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   332,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   332,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   332,  /* (28) cmd ::= DROP USER user_name */
   338,  /* (29) sysinfo_opt ::= */
   338,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   332,  /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
   332,  /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
   339,  /* (33) privileges ::= ALL */
   339,  /* (34) privileges ::= priv_type_list */
   339,  /* (35) privileges ::= SUBSCRIBE */
   342,  /* (36) priv_type_list ::= priv_type */
   342,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   343,  /* (38) priv_type ::= READ */
   343,  /* (39) priv_type ::= WRITE */
   340,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   340,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   340,  /* (42) priv_level ::= db_name NK_DOT table_name */
   340,  /* (43) priv_level ::= topic_name */
   341,  /* (44) with_opt ::= */
   341,  /* (45) with_opt ::= WITH search_condition */
   332,  /* (46) cmd ::= CREATE DNODE dnode_endpoint */
   332,  /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   332,  /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
   332,  /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
   332,  /* (50) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   332,  /* (51) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   332,  /* (52) cmd ::= ALTER ALL DNODES NK_STRING */
   332,  /* (53) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   332,  /* (54) cmd ::= RESTORE DNODE NK_INTEGER */
   348,  /* (55) dnode_endpoint ::= NK_STRING */
   348,  /* (56) dnode_endpoint ::= NK_ID */
   348,  /* (57) dnode_endpoint ::= NK_IPTOKEN */
   349,  /* (58) force_opt ::= */
   349,  /* (59) force_opt ::= FORCE */
   332,  /* (60) cmd ::= ALTER LOCAL NK_STRING */
   332,  /* (61) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   332,  /* (62) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   332,  /* (63) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   332,  /* (64) cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
   332,  /* (65) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   332,  /* (66) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   332,  /* (67) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   332,  /* (68) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   332,  /* (69) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   332,  /* (70) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   332,  /* (71) cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
   332,  /* (72) cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
   332,  /* (73) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   332,  /* (74) cmd ::= DROP DATABASE exists_opt db_name */
   332,  /* (75) cmd ::= USE db_name */
   332,  /* (76) cmd ::= ALTER DATABASE db_name alter_db_options */
   332,  /* (77) cmd ::= FLUSH DATABASE db_name */
   332,  /* (78) cmd ::= TRIM DATABASE db_name speed_opt */
   332,  /* (79) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
   350,  /* (80) not_exists_opt ::= IF NOT EXISTS */
   350,  /* (81) not_exists_opt ::= */
   352,  /* (82) exists_opt ::= IF EXISTS */
   352,  /* (83) exists_opt ::= */
   351,  /* (84) db_options ::= */
   351,  /* (85) db_options ::= db_options BUFFER NK_INTEGER */
   351,  /* (86) db_options ::= db_options CACHEMODEL NK_STRING */
   351,  /* (87) db_options ::= db_options CACHESIZE NK_INTEGER */
   351,  /* (88) db_options ::= db_options COMP NK_INTEGER */
   351,  /* (89) db_options ::= db_options DURATION NK_INTEGER */
   351,  /* (90) db_options ::= db_options DURATION NK_VARIABLE */
   351,  /* (91) db_options ::= db_options MAXROWS NK_INTEGER */
   351,  /* (92) db_options ::= db_options MINROWS NK_INTEGER */
   351,  /* (93) db_options ::= db_options KEEP integer_list */
   351,  /* (94) db_options ::= db_options KEEP variable_list */
   351,  /* (95) db_options ::= db_options PAGES NK_INTEGER */
   351,  /* (96) db_options ::= db_options PAGESIZE NK_INTEGER */
   351,  /* (97) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   351,  /* (98) db_options ::= db_options PRECISION NK_STRING */
   351,  /* (99) db_options ::= db_options REPLICA NK_INTEGER */
   351,  /* (100) db_options ::= db_options VGROUPS NK_INTEGER */
   351,  /* (101) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   351,  /* (102) db_options ::= db_options RETENTIONS retention_list */
   351,  /* (103) db_options ::= db_options SCHEMALESS NK_INTEGER */
   351,  /* (104) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   351,  /* (105) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   351,  /* (106) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   351,  /* (107) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   351,  /* (108) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   351,  /* (109) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   351,  /* (110) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   351,  /* (111) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   351,  /* (112) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   351,  /* (113) db_options ::= db_options TABLE_PREFIX signed */
   351,  /* (114) db_options ::= db_options TABLE_SUFFIX signed */
   353,  /* (115) alter_db_options ::= alter_db_option */
   353,  /* (116) alter_db_options ::= alter_db_options alter_db_option */
   361,  /* (117) alter_db_option ::= BUFFER NK_INTEGER */
   361,  /* (118) alter_db_option ::= CACHEMODEL NK_STRING */
   361,  /* (119) alter_db_option ::= CACHESIZE NK_INTEGER */
   361,  /* (120) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   361,  /* (121) alter_db_option ::= KEEP integer_list */
   361,  /* (122) alter_db_option ::= KEEP variable_list */
   361,  /* (123) alter_db_option ::= PAGES NK_INTEGER */
   361,  /* (124) alter_db_option ::= REPLICA NK_INTEGER */
   361,  /* (125) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   361,  /* (126) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   361,  /* (127) alter_db_option ::= MINROWS NK_INTEGER */
   361,  /* (128) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
   361,  /* (129) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   361,  /* (130) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
   361,  /* (131) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   357,  /* (132) integer_list ::= NK_INTEGER */
   357,  /* (133) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   358,  /* (134) variable_list ::= NK_VARIABLE */
   358,  /* (135) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   359,  /* (136) retention_list ::= retention */
   359,  /* (137) retention_list ::= retention_list NK_COMMA retention */
   362,  /* (138) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
   354,  /* (139) speed_opt ::= */
   354,  /* (140) speed_opt ::= MAX_SPEED NK_INTEGER */
   355,  /* (141) start_opt ::= */
   355,  /* (142) start_opt ::= START WITH NK_INTEGER */
   355,  /* (143) start_opt ::= START WITH NK_STRING */
   355,  /* (144) start_opt ::= START WITH TIMESTAMP NK_STRING */
   356,  /* (145) end_opt ::= */
   356,  /* (146) end_opt ::= END WITH NK_INTEGER */
   356,  /* (147) end_opt ::= END WITH NK_STRING */
   356,  /* (148) end_opt ::= END WITH TIMESTAMP NK_STRING */
   332,  /* (149) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   332,  /* (150) cmd ::= CREATE TABLE multi_create_clause */
   332,  /* (151) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   332,  /* (152) cmd ::= DROP TABLE multi_drop_clause */
   332,  /* (153) cmd ::= DROP STABLE exists_opt full_table_name */
   332,  /* (154) cmd ::= ALTER TABLE alter_table_clause */
   332,  /* (155) cmd ::= ALTER STABLE alter_table_clause */
   370,  /* (156) alter_table_clause ::= full_table_name alter_table_options */
   370,  /* (157) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   370,  /* (158) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   370,  /* (159) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   370,  /* (160) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   370,  /* (161) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   370,  /* (162) alter_table_clause ::= full_table_name DROP TAG column_name */
   370,  /* (163) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   370,  /* (164) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   370,  /* (165) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   367,  /* (166) multi_create_clause ::= create_subtable_clause */
   367,  /* (167) multi_create_clause ::= multi_create_clause create_subtable_clause */
   375,  /* (168) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   369,  /* (169) multi_drop_clause ::= drop_table_clause */
   369,  /* (170) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
   378,  /* (171) drop_table_clause ::= exists_opt full_table_name */
   376,  /* (172) specific_cols_opt ::= */
   376,  /* (173) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   363,  /* (174) full_table_name ::= table_name */
   363,  /* (175) full_table_name ::= db_name NK_DOT table_name */
   364,  /* (176) column_def_list ::= column_def */
   364,  /* (177) column_def_list ::= column_def_list NK_COMMA column_def */
   380,  /* (178) column_def ::= column_name type_name */
   373,  /* (179) type_name ::= BOOL */
   373,  /* (180) type_name ::= TINYINT */
   373,  /* (181) type_name ::= SMALLINT */
   373,  /* (182) type_name ::= INT */
   373,  /* (183) type_name ::= INTEGER */
   373,  /* (184) type_name ::= BIGINT */
   373,  /* (185) type_name ::= FLOAT */
   373,  /* (186) type_name ::= DOUBLE */
   373,  /* (187) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   373,  /* (188) type_name ::= TIMESTAMP */
   373,  /* (189) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   373,  /* (190) type_name ::= TINYINT UNSIGNED */
   373,  /* (191) type_name ::= SMALLINT UNSIGNED */
   373,  /* (192) type_name ::= INT UNSIGNED */
   373,  /* (193) type_name ::= BIGINT UNSIGNED */
   373,  /* (194) type_name ::= JSON */
   373,  /* (195) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   373,  /* (196) type_name ::= MEDIUMBLOB */
   373,  /* (197) type_name ::= BLOB */
   373,  /* (198) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   373,  /* (199) type_name ::= DECIMAL */
   373,  /* (200) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   373,  /* (201) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
   365,  /* (202) tags_def_opt ::= */
   365,  /* (203) tags_def_opt ::= tags_def */
   368,  /* (204) tags_def ::= TAGS NK_LP column_def_list NK_RP */
   366,  /* (205) table_options ::= */
   366,  /* (206) table_options ::= table_options COMMENT NK_STRING */
   366,  /* (207) table_options ::= table_options MAX_DELAY duration_list */
   366,  /* (208) table_options ::= table_options WATERMARK duration_list */
   366,  /* (209) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   366,  /* (210) table_options ::= table_options TTL NK_INTEGER */
   366,  /* (211) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   366,  /* (212) table_options ::= table_options DELETE_MARK duration_list */
   371,  /* (213) alter_table_options ::= alter_table_option */
   371,  /* (214) alter_table_options ::= alter_table_options alter_table_option */
   383,  /* (215) alter_table_option ::= COMMENT NK_STRING */
   383,  /* (216) alter_table_option ::= TTL NK_INTEGER */
   381,  /* (217) duration_list ::= duration_literal */
   381,  /* (218) duration_list ::= duration_list NK_COMMA duration_literal */
   382,  /* (219) rollup_func_list ::= rollup_func_name */
   382,  /* (220) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   385,  /* (221) rollup_func_name ::= function_name */
   385,  /* (222) rollup_func_name ::= FIRST */
   385,  /* (223) rollup_func_name ::= LAST */
   379,  /* (224) col_name_list ::= col_name */
   379,  /* (225) col_name_list ::= col_name_list NK_COMMA col_name */
   387,  /* (226) col_name ::= column_name */
   332,  /* (227) cmd ::= SHOW DNODES */
   332,  /* (228) cmd ::= SHOW USERS */
   332,  /* (229) cmd ::= SHOW USER PRIVILEGES */
   332,  /* (230) cmd ::= SHOW DATABASES */
   332,  /* (231) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   332,  /* (232) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   332,  /* (233) cmd ::= SHOW db_name_cond_opt VGROUPS */
   332,  /* (234) cmd ::= SHOW MNODES */
   332,  /* (235) cmd ::= SHOW QNODES */
   332,  /* (236) cmd ::= SHOW FUNCTIONS */
   332,  /* (237) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   332,  /* (238) cmd ::= SHOW STREAMS */
   332,  /* (239) cmd ::= SHOW ACCOUNTS */
   332,  /* (240) cmd ::= SHOW APPS */
   332,  /* (241) cmd ::= SHOW CONNECTIONS */
   332,  /* (242) cmd ::= SHOW LICENCES */
   332,  /* (243) cmd ::= SHOW GRANTS */
   332,  /* (244) cmd ::= SHOW CREATE DATABASE db_name */
   332,  /* (245) cmd ::= SHOW CREATE TABLE full_table_name */
   332,  /* (246) cmd ::= SHOW CREATE STABLE full_table_name */
   332,  /* (247) cmd ::= SHOW QUERIES */
   332,  /* (248) cmd ::= SHOW SCORES */
   332,  /* (249) cmd ::= SHOW TOPICS */
   332,  /* (250) cmd ::= SHOW VARIABLES */
   332,  /* (251) cmd ::= SHOW CLUSTER VARIABLES */
   332,  /* (252) cmd ::= SHOW LOCAL VARIABLES */
   332,  /* (253) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   332,  /* (254) cmd ::= SHOW BNODES */
   332,  /* (255) cmd ::= SHOW SNODES */
   332,  /* (256) cmd ::= SHOW CLUSTER */
   332,  /* (257) cmd ::= SHOW TRANSACTIONS */
   332,  /* (258) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   332,  /* (259) cmd ::= SHOW CONSUMERS */
   332,  /* (260) cmd ::= SHOW SUBSCRIPTIONS */
   332,  /* (261) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   332,  /* (262) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   332,  /* (263) cmd ::= SHOW VNODES NK_INTEGER */
   332,  /* (264) cmd ::= SHOW VNODES NK_STRING */
   332,  /* (265) cmd ::= SHOW db_name_cond_opt ALIVE */
   332,  /* (266) cmd ::= SHOW CLUSTER ALIVE */
   388,  /* (267) db_name_cond_opt ::= */
   388,  /* (268) db_name_cond_opt ::= db_name NK_DOT */
   389,  /* (269) like_pattern_opt ::= */
   389,  /* (270) like_pattern_opt ::= LIKE NK_STRING */
   390,  /* (271) table_name_cond ::= table_name */
   391,  /* (272) from_db_opt ::= */
   391,  /* (273) from_db_opt ::= FROM db_name */
   392,  /* (274) tag_list_opt ::= */
   392,  /* (275) tag_list_opt ::= tag_item */
   392,  /* (276) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   393,  /* (277) tag_item ::= TBNAME */
   393,  /* (278) tag_item ::= QTAGS */
   393,  /* (279) tag_item ::= column_name */
   393,  /* (280) tag_item ::= column_name column_alias */
   393,  /* (281) tag_item ::= column_name AS column_alias */
   332,  /* (282) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
   332,  /* (283) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
   332,  /* (284) cmd ::= DROP INDEX exists_opt full_index_name */
   395,  /* (285) full_index_name ::= index_name */
   395,  /* (286) full_index_name ::= db_name NK_DOT index_name */
   396,  /* (287) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
   396,  /* (288) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   398,  /* (289) func_list ::= func */
   398,  /* (290) func_list ::= func_list NK_COMMA func */
   401,  /* (291) func ::= sma_func_name NK_LP expression_list NK_RP */
   402,  /* (292) sma_func_name ::= function_name */
   402,  /* (293) sma_func_name ::= COUNT */
   402,  /* (294) sma_func_name ::= FIRST */
   402,  /* (295) sma_func_name ::= LAST */
   402,  /* (296) sma_func_name ::= LAST_ROW */
   400,  /* (297) sma_stream_opt ::= */
   400,  /* (298) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   400,  /* (299) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   400,  /* (300) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   332,  /* (301) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   332,  /* (302) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   332,  /* (303) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   332,  /* (304) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
   332,  /* (305) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
   332,  /* (306) cmd ::= DROP TOPIC exists_opt topic_name */
   332,  /* (307) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   332,  /* (308) cmd ::= DESC full_table_name */
   332,  /* (309) cmd ::= DESCRIBE full_table_name */
   332,  /* (310) cmd ::= RESET QUERY CACHE */
   332,  /* (311) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   332,  /* (312) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
   405,  /* (313) analyze_opt ::= */
   405,  /* (314) analyze_opt ::= ANALYZE */
   406,  /* (315) explain_options ::= */
   406,  /* (316) explain_options ::= explain_options VERBOSE NK_BOOL */
   406,  /* (317) explain_options ::= explain_options RATIO NK_FLOAT */
   332,  /* (318) cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
   332,  /* (319) cmd ::= DROP FUNCTION exists_opt function_name */
   409,  /* (320) agg_func_opt ::= */
   409,  /* (321) agg_func_opt ::= AGGREGATE */
   410,  /* (322) bufsize_opt ::= */
   410,  /* (323) bufsize_opt ::= BUFSIZE NK_INTEGER */
   411,  /* (324) language_opt ::= */
   411,  /* (325) language_opt ::= LANGUAGE NK_STRING */
   408,  /* (326) or_replace_opt ::= */
   408,  /* (327) or_replace_opt ::= OR REPLACE */
   332,  /* (328) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
   332,  /* (329) cmd ::= DROP STREAM exists_opt stream_name */
   414,  /* (330) col_list_opt ::= */
   414,  /* (331) col_list_opt ::= NK_LP col_name_list NK_RP */
   415,  /* (332) tag_def_or_ref_opt ::= */
   415,  /* (333) tag_def_or_ref_opt ::= tags_def */
   415,  /* (334) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
   413,  /* (335) stream_options ::= */
   413,  /* (336) stream_options ::= stream_options TRIGGER AT_ONCE */
   413,  /* (337) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   413,  /* (338) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   413,  /* (339) stream_options ::= stream_options WATERMARK duration_literal */
   413,  /* (340) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   413,  /* (341) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   413,  /* (342) stream_options ::= stream_options DELETE_MARK duration_literal */
   413,  /* (343) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
   416,  /* (344) subtable_opt ::= */
   416,  /* (345) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
   332,  /* (346) cmd ::= KILL CONNECTION NK_INTEGER */
   332,  /* (347) cmd ::= KILL QUERY NK_STRING */
   332,  /* (348) cmd ::= KILL TRANSACTION NK_INTEGER */
   332,  /* (349) cmd ::= BALANCE VGROUP */
   332,  /* (350) cmd ::= BALANCE VGROUP LEADER */
   332,  /* (351) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   332,  /* (352) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   332,  /* (353) cmd ::= SPLIT VGROUP NK_INTEGER */
   418,  /* (354) dnode_list ::= DNODE NK_INTEGER */
   418,  /* (355) dnode_list ::= dnode_list DNODE NK_INTEGER */
   332,  /* (356) cmd ::= DELETE FROM full_table_name where_clause_opt */
   332,  /* (357) cmd ::= query_or_subquery */
   332,  /* (358) cmd ::= insert_query */
   407,  /* (359) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   407,  /* (360) insert_query ::= INSERT INTO full_table_name query_or_subquery */
   335,  /* (361) literal ::= NK_INTEGER */
   335,  /* (362) literal ::= NK_FLOAT */
   335,  /* (363) literal ::= NK_STRING */
   335,  /* (364) literal ::= NK_BOOL */
   335,  /* (365) literal ::= TIMESTAMP NK_STRING */
   335,  /* (366) literal ::= duration_literal */
   335,  /* (367) literal ::= NULL */
   335,  /* (368) literal ::= NK_QUESTION */
   384,  /* (369) duration_literal ::= NK_VARIABLE */
   360,  /* (370) signed ::= NK_INTEGER */
   360,  /* (371) signed ::= NK_PLUS NK_INTEGER */
   360,  /* (372) signed ::= NK_MINUS NK_INTEGER */
   360,  /* (373) signed ::= NK_FLOAT */
   360,  /* (374) signed ::= NK_PLUS NK_FLOAT */
   360,  /* (375) signed ::= NK_MINUS NK_FLOAT */
   374,  /* (376) signed_literal ::= signed */
   374,  /* (377) signed_literal ::= NK_STRING */
   374,  /* (378) signed_literal ::= NK_BOOL */
   374,  /* (379) signed_literal ::= TIMESTAMP NK_STRING */
   374,  /* (380) signed_literal ::= duration_literal */
   374,  /* (381) signed_literal ::= NULL */
   374,  /* (382) signed_literal ::= literal_func */
   374,  /* (383) signed_literal ::= NK_QUESTION */
   421,  /* (384) literal_list ::= signed_literal */
   421,  /* (385) literal_list ::= literal_list NK_COMMA signed_literal */
   344,  /* (386) db_name ::= NK_ID */
   345,  /* (387) table_name ::= NK_ID */
   372,  /* (388) column_name ::= NK_ID */
   386,  /* (389) function_name ::= NK_ID */
   422,  /* (390) table_alias ::= NK_ID */
   394,  /* (391) column_alias ::= NK_ID */
   337,  /* (392) user_name ::= NK_ID */
   346,  /* (393) topic_name ::= NK_ID */
   412,  /* (394) stream_name ::= NK_ID */
   404,  /* (395) cgroup_name ::= NK_ID */
   397,  /* (396) index_name ::= NK_ID */
   423,  /* (397) expr_or_subquery ::= expression */
   417,  /* (398) expression ::= literal */
   417,  /* (399) expression ::= pseudo_column */
   417,  /* (400) expression ::= column_reference */
   417,  /* (401) expression ::= function_expression */
   417,  /* (402) expression ::= case_when_expression */
   417,  /* (403) expression ::= NK_LP expression NK_RP */
   417,  /* (404) expression ::= NK_PLUS expr_or_subquery */
   417,  /* (405) expression ::= NK_MINUS expr_or_subquery */
   417,  /* (406) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   417,  /* (407) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   417,  /* (408) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   417,  /* (409) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   417,  /* (410) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   417,  /* (411) expression ::= column_reference NK_ARROW NK_STRING */
   417,  /* (412) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   417,  /* (413) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   377,  /* (414) expression_list ::= expr_or_subquery */
   377,  /* (415) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   425,  /* (416) column_reference ::= column_name */
   425,  /* (417) column_reference ::= table_name NK_DOT column_name */
   424,  /* (418) pseudo_column ::= ROWTS */
   424,  /* (419) pseudo_column ::= TBNAME */
   424,  /* (420) pseudo_column ::= table_name NK_DOT TBNAME */
   424,  /* (421) pseudo_column ::= QSTART */
   424,  /* (422) pseudo_column ::= QEND */
   424,  /* (423) pseudo_column ::= QDURATION */
   424,  /* (424) pseudo_column ::= WSTART */
   424,  /* (425) pseudo_column ::= WEND */
   424,  /* (426) pseudo_column ::= WDURATION */
   424,  /* (427) pseudo_column ::= IROWTS */
   424,  /* (428) pseudo_column ::= ISFILLED */
   424,  /* (429) pseudo_column ::= QTAGS */
   426,  /* (430) function_expression ::= function_name NK_LP expression_list NK_RP */
   426,  /* (431) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   426,  /* (432) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   426,  /* (433) function_expression ::= literal_func */
   420,  /* (434) literal_func ::= noarg_func NK_LP NK_RP */
   420,  /* (435) literal_func ::= NOW */
   430,  /* (436) noarg_func ::= NOW */
   430,  /* (437) noarg_func ::= TODAY */
   430,  /* (438) noarg_func ::= TIMEZONE */
   430,  /* (439) noarg_func ::= DATABASE */
   430,  /* (440) noarg_func ::= CLIENT_VERSION */
   430,  /* (441) noarg_func ::= SERVER_VERSION */
   430,  /* (442) noarg_func ::= SERVER_STATUS */
   430,  /* (443) noarg_func ::= CURRENT_USER */
   430,  /* (444) noarg_func ::= USER */
   428,  /* (445) star_func ::= COUNT */
   428,  /* (446) star_func ::= FIRST */
   428,  /* (447) star_func ::= LAST */
   428,  /* (448) star_func ::= LAST_ROW */
   429,  /* (449) star_func_para_list ::= NK_STAR */
   429,  /* (450) star_func_para_list ::= other_para_list */
   431,  /* (451) other_para_list ::= star_func_para */
   431,  /* (452) other_para_list ::= other_para_list NK_COMMA star_func_para */
   432,  /* (453) star_func_para ::= expr_or_subquery */
   432,  /* (454) star_func_para ::= table_name NK_DOT NK_STAR */
   427,  /* (455) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   427,  /* (456) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   433,  /* (457) when_then_list ::= when_then_expr */
   433,  /* (458) when_then_list ::= when_then_list when_then_expr */
   436,  /* (459) when_then_expr ::= WHEN common_expression THEN common_expression */
   434,  /* (460) case_when_else_opt ::= */
   434,  /* (461) case_when_else_opt ::= ELSE common_expression */
   437,  /* (462) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   437,  /* (463) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   437,  /* (464) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   437,  /* (465) predicate ::= expr_or_subquery IS NULL */
   437,  /* (466) predicate ::= expr_or_subquery IS NOT NULL */
   437,  /* (467) predicate ::= expr_or_subquery in_op in_predicate_value */
   438,  /* (468) compare_op ::= NK_LT */
   438,  /* (469) compare_op ::= NK_GT */
   438,  /* (470) compare_op ::= NK_LE */
   438,  /* (471) compare_op ::= NK_GE */
   438,  /* (472) compare_op ::= NK_NE */
   438,  /* (473) compare_op ::= NK_EQ */
   438,  /* (474) compare_op ::= LIKE */
   438,  /* (475) compare_op ::= NOT LIKE */
   438,  /* (476) compare_op ::= MATCH */
   438,  /* (477) compare_op ::= NMATCH */
   438,  /* (478) compare_op ::= CONTAINS */
   439,  /* (479) in_op ::= IN */
   439,  /* (480) in_op ::= NOT IN */
   440,  /* (481) in_predicate_value ::= NK_LP literal_list NK_RP */
   441,  /* (482) boolean_value_expression ::= boolean_primary */
   441,  /* (483) boolean_value_expression ::= NOT boolean_primary */
   441,  /* (484) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   441,  /* (485) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   442,  /* (486) boolean_primary ::= predicate */
   442,  /* (487) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   435,  /* (488) common_expression ::= expr_or_subquery */
   435,  /* (489) common_expression ::= boolean_value_expression */
   443,  /* (490) from_clause_opt ::= */
   443,  /* (491) from_clause_opt ::= FROM table_reference_list */
   444,  /* (492) table_reference_list ::= table_reference */
   444,  /* (493) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   445,  /* (494) table_reference ::= table_primary */
   445,  /* (495) table_reference ::= joined_table */
   446,  /* (496) table_primary ::= table_name alias_opt */
   446,  /* (497) table_primary ::= db_name NK_DOT table_name alias_opt */
   446,  /* (498) table_primary ::= subquery alias_opt */
   446,  /* (499) table_primary ::= parenthesized_joined_table */
   448,  /* (500) alias_opt ::= */
   448,  /* (501) alias_opt ::= table_alias */
   448,  /* (502) alias_opt ::= AS table_alias */
   450,  /* (503) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   450,  /* (504) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   447,  /* (505) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
   451,  /* (506) join_type ::= */
   451,  /* (507) join_type ::= INNER */
   452,  /* (508) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
   453,  /* (509) set_quantifier_opt ::= */
   453,  /* (510) set_quantifier_opt ::= DISTINCT */
   453,  /* (511) set_quantifier_opt ::= ALL */
   454,  /* (512) select_list ::= select_item */
   454,  /* (513) select_list ::= select_list NK_COMMA select_item */
   462,  /* (514) select_item ::= NK_STAR */
   462,  /* (515) select_item ::= common_expression */
   462,  /* (516) select_item ::= common_expression column_alias */
   462,  /* (517) select_item ::= common_expression AS column_alias */
   462,  /* (518) select_item ::= table_name NK_DOT NK_STAR */
   419,  /* (519) where_clause_opt ::= */
   419,  /* (520) where_clause_opt ::= WHERE search_condition */
   455,  /* (521) partition_by_clause_opt ::= */
   455,  /* (522) partition_by_clause_opt ::= PARTITION BY partition_list */
   463,  /* (523) partition_list ::= partition_item */
   463,  /* (524) partition_list ::= partition_list NK_COMMA partition_item */
   464,  /* (525) partition_item ::= expr_or_subquery */
   464,  /* (526) partition_item ::= expr_or_subquery column_alias */
   464,  /* (527) partition_item ::= expr_or_subquery AS column_alias */
   459,  /* (528) twindow_clause_opt ::= */
   459,  /* (529) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   459,  /* (530) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   459,  /* (531) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   459,  /* (532) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   459,  /* (533) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
   399,  /* (534) sliding_opt ::= */
   399,  /* (535) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
   458,  /* (536) fill_opt ::= */
   458,  /* (537) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   458,  /* (538) fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
   458,  /* (539) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
   465,  /* (540) fill_mode ::= NONE */
   465,  /* (541) fill_mode ::= PREV */
   465,  /* (542) fill_mode ::= NULL */
   465,  /* (543) fill_mode ::= NULL_F */
   465,  /* (544) fill_mode ::= LINEAR */
   465,  /* (545) fill_mode ::= NEXT */
   460,  /* (546) group_by_clause_opt ::= */
   460,  /* (547) group_by_clause_opt ::= GROUP BY group_by_list */
   466,  /* (548) group_by_list ::= expr_or_subquery */
   466,  /* (549) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
   461,  /* (550) having_clause_opt ::= */
   461,  /* (551) having_clause_opt ::= HAVING search_condition */
   456,  /* (552) range_opt ::= */
   456,  /* (553) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
   457,  /* (554) every_opt ::= */
   457,  /* (555) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   467,  /* (556) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   468,  /* (557) query_simple ::= query_specification */
   468,  /* (558) query_simple ::= union_query_expression */
   472,  /* (559) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   472,  /* (560) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   473,  /* (561) query_simple_or_subquery ::= query_simple */
   473,  /* (562) query_simple_or_subquery ::= subquery */
   403,  /* (563) query_or_subquery ::= query_expression */
   403,  /* (564) query_or_subquery ::= subquery */
   469,  /* (565) order_by_clause_opt ::= */
   469,  /* (566) order_by_clause_opt ::= ORDER BY sort_specification_list */
   470,  /* (567) slimit_clause_opt ::= */
   470,  /* (568) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   470,  /* (569) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   470,  /* (570) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   471,  /* (571) limit_clause_opt ::= */
   471,  /* (572) limit_clause_opt ::= LIMIT NK_INTEGER */
   471,  /* (573) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   471,  /* (574) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   449,  /* (575) subquery ::= NK_LP query_expression NK_RP */
   449,  /* (576) subquery ::= NK_LP subquery NK_RP */
   347,  /* (577) search_condition ::= common_expression */
   474,  /* (578) sort_specification_list ::= sort_specification */
   474,  /* (579) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   475,  /* (580) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
   476,  /* (581) ordering_specification_opt ::= */
   476,  /* (582) ordering_specification_opt ::= ASC */
   476,  /* (583) ordering_specification_opt ::= DESC */
   477,  /* (584) null_ordering_opt ::= */
   477,  /* (585) null_ordering_opt ::= NULLS FIRST */
   477,  /* (586) null_ordering_opt ::= NULLS LAST */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -6,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   -4,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
    0,  /* (2) account_options ::= */
   -3,  /* (3) account_options ::= account_options PPS literal */
   -3,  /* (4) account_options ::= account_options TSERIES literal */
   -3,  /* (5) account_options ::= account_options STORAGE literal */
   -3,  /* (6) account_options ::= account_options STREAMS literal */
   -3,  /* (7) account_options ::= account_options QTIME literal */
   -3,  /* (8) account_options ::= account_options DBS literal */
   -3,  /* (9) account_options ::= account_options USERS literal */
   -3,  /* (10) account_options ::= account_options CONNS literal */
   -3,  /* (11) account_options ::= account_options STATE literal */
   -1,  /* (12) alter_account_options ::= alter_account_option */
   -2,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   -2,  /* (14) alter_account_option ::= PASS literal */
   -2,  /* (15) alter_account_option ::= PPS literal */
   -2,  /* (16) alter_account_option ::= TSERIES literal */
   -2,  /* (17) alter_account_option ::= STORAGE literal */
   -2,  /* (18) alter_account_option ::= STREAMS literal */
   -2,  /* (19) alter_account_option ::= QTIME literal */
   -2,  /* (20) alter_account_option ::= DBS literal */
   -2,  /* (21) alter_account_option ::= USERS literal */
   -2,  /* (22) alter_account_option ::= CONNS literal */
   -2,  /* (23) alter_account_option ::= STATE literal */
   -6,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   -5,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   -5,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   -5,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   -3,  /* (28) cmd ::= DROP USER user_name */
    0,  /* (29) sysinfo_opt ::= */
   -2,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   -7,  /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
   -7,  /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
   -1,  /* (33) privileges ::= ALL */
   -1,  /* (34) privileges ::= priv_type_list */
   -1,  /* (35) privileges ::= SUBSCRIBE */
   -1,  /* (36) priv_type_list ::= priv_type */
   -3,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   -1,  /* (38) priv_type ::= READ */
   -1,  /* (39) priv_type ::= WRITE */
   -3,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   -3,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   -3,  /* (42) priv_level ::= db_name NK_DOT table_name */
   -1,  /* (43) priv_level ::= topic_name */
    0,  /* (44) with_opt ::= */
   -2,  /* (45) with_opt ::= WITH search_condition */
   -3,  /* (46) cmd ::= CREATE DNODE dnode_endpoint */
   -5,  /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   -4,  /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
   -4,  /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
   -4,  /* (50) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   -5,  /* (51) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   -4,  /* (52) cmd ::= ALTER ALL DNODES NK_STRING */
   -5,  /* (53) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   -3,  /* (54) cmd ::= RESTORE DNODE NK_INTEGER */
   -1,  /* (55) dnode_endpoint ::= NK_STRING */
   -1,  /* (56) dnode_endpoint ::= NK_ID */
   -1,  /* (57) dnode_endpoint ::= NK_IPTOKEN */
    0,  /* (58) force_opt ::= */
   -1,  /* (59) force_opt ::= FORCE */
   -3,  /* (60) cmd ::= ALTER LOCAL NK_STRING */
   -4,  /* (61) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   -5,  /* (62) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   -5,  /* (63) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   -5,  /* (64) cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
   -5,  /* (65) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   -5,  /* (66) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   -5,  /* (67) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   -5,  /* (68) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   -5,  /* (69) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   -5,  /* (70) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   -5,  /* (71) cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
   -5,  /* (72) cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
   -5,  /* (73) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   -4,  /* (74) cmd ::= DROP DATABASE exists_opt db_name */
   -2,  /* (75) cmd ::= USE db_name */
   -4,  /* (76) cmd ::= ALTER DATABASE db_name alter_db_options */
   -3,  /* (77) cmd ::= FLUSH DATABASE db_name */
   -4,  /* (78) cmd ::= TRIM DATABASE db_name speed_opt */
   -5,  /* (79) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
   -3,  /* (80) not_exists_opt ::= IF NOT EXISTS */
    0,  /* (81) not_exists_opt ::= */
   -2,  /* (82) exists_opt ::= IF EXISTS */
    0,  /* (83) exists_opt ::= */
    0,  /* (84) db_options ::= */
   -3,  /* (85) db_options ::= db_options BUFFER NK_INTEGER */
   -3,  /* (86) db_options ::= db_options CACHEMODEL NK_STRING */
   -3,  /* (87) db_options ::= db_options CACHESIZE NK_INTEGER */
   -3,  /* (88) db_options ::= db_options COMP NK_INTEGER */
   -3,  /* (89) db_options ::= db_options DURATION NK_INTEGER */
   -3,  /* (90) db_options ::= db_options DURATION NK_VARIABLE */
   -3,  /* (91) db_options ::= db_options MAXROWS NK_INTEGER */
   -3,  /* (92) db_options ::= db_options MINROWS NK_INTEGER */
   -3,  /* (93) db_options ::= db_options KEEP integer_list */
   -3,  /* (94) db_options ::= db_options KEEP variable_list */
   -3,  /* (95) db_options ::= db_options PAGES NK_INTEGER */
   -3,  /* (96) db_options ::= db_options PAGESIZE NK_INTEGER */
   -3,  /* (97) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   -3,  /* (98) db_options ::= db_options PRECISION NK_STRING */
   -3,  /* (99) db_options ::= db_options REPLICA NK_INTEGER */
   -3,  /* (100) db_options ::= db_options VGROUPS NK_INTEGER */
   -3,  /* (101) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   -3,  /* (102) db_options ::= db_options RETENTIONS retention_list */
   -3,  /* (103) db_options ::= db_options SCHEMALESS NK_INTEGER */
   -3,  /* (104) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   -3,  /* (105) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   -3,  /* (106) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   -4,  /* (107) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -3,  /* (108) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   -4,  /* (109) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -3,  /* (110) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   -3,  /* (111) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   -3,  /* (112) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   -3,  /* (113) db_options ::= db_options TABLE_PREFIX signed */
   -3,  /* (114) db_options ::= db_options TABLE_SUFFIX signed */
   -1,  /* (115) alter_db_options ::= alter_db_option */
   -2,  /* (116) alter_db_options ::= alter_db_options alter_db_option */
   -2,  /* (117) alter_db_option ::= BUFFER NK_INTEGER */
   -2,  /* (118) alter_db_option ::= CACHEMODEL NK_STRING */
   -2,  /* (119) alter_db_option ::= CACHESIZE NK_INTEGER */
   -2,  /* (120) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   -2,  /* (121) alter_db_option ::= KEEP integer_list */
   -2,  /* (122) alter_db_option ::= KEEP variable_list */
   -2,  /* (123) alter_db_option ::= PAGES NK_INTEGER */
   -2,  /* (124) alter_db_option ::= REPLICA NK_INTEGER */
   -2,  /* (125) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   -2,  /* (126) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   -2,  /* (127) alter_db_option ::= MINROWS NK_INTEGER */
   -2,  /* (128) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
   -3,  /* (129) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -2,  /* (130) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
   -3,  /* (131) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -1,  /* (132) integer_list ::= NK_INTEGER */
   -3,  /* (133) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   -1,  /* (134) variable_list ::= NK_VARIABLE */
   -3,  /* (135) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   -1,  /* (136) retention_list ::= retention */
   -3,  /* (137) retention_list ::= retention_list NK_COMMA retention */
   -3,  /* (138) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
    0,  /* (139) speed_opt ::= */
   -2,  /* (140) speed_opt ::= MAX_SPEED NK_INTEGER */
    0,  /* (141) start_opt ::= */
   -3,  /* (142) start_opt ::= START WITH NK_INTEGER */
   -3,  /* (143) start_opt ::= START WITH NK_STRING */
   -4,  /* (144) start_opt ::= START WITH TIMESTAMP NK_STRING */
    0,  /* (145) end_opt ::= */
   -3,  /* (146) end_opt ::= END WITH NK_INTEGER */
   -3,  /* (147) end_opt ::= END WITH NK_STRING */
   -4,  /* (148) end_opt ::= END WITH TIMESTAMP NK_STRING */
   -9,  /* (149) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   -3,  /* (150) cmd ::= CREATE TABLE multi_create_clause */
   -9,  /* (151) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   -3,  /* (152) cmd ::= DROP TABLE multi_drop_clause */
   -4,  /* (153) cmd ::= DROP STABLE exists_opt full_table_name */
   -3,  /* (154) cmd ::= ALTER TABLE alter_table_clause */
   -3,  /* (155) cmd ::= ALTER STABLE alter_table_clause */
   -2,  /* (156) alter_table_clause ::= full_table_name alter_table_options */
   -5,  /* (157) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   -4,  /* (158) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   -5,  /* (159) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   -5,  /* (160) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   -5,  /* (161) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   -4,  /* (162) alter_table_clause ::= full_table_name DROP TAG column_name */
   -5,  /* (163) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   -5,  /* (164) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   -6,  /* (165) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   -1,  /* (166) multi_create_clause ::= create_subtable_clause */
   -2,  /* (167) multi_create_clause ::= multi_create_clause create_subtable_clause */
  -10,  /* (168) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   -1,  /* (169) multi_drop_clause ::= drop_table_clause */
   -3,  /* (170) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
   -2,  /* (171) drop_table_clause ::= exists_opt full_table_name */
    0,  /* (172) specific_cols_opt ::= */
   -3,  /* (173) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   -1,  /* (174) full_table_name ::= table_name */
   -3,  /* (175) full_table_name ::= db_name NK_DOT table_name */
   -1,  /* (176) column_def_list ::= column_def */
   -3,  /* (177) column_def_list ::= column_def_list NK_COMMA column_def */
   -2,  /* (178) column_def ::= column_name type_name */
   -1,  /* (179) type_name ::= BOOL */
   -1,  /* (180) type_name ::= TINYINT */
   -1,  /* (181) type_name ::= SMALLINT */
   -1,  /* (182) type_name ::= INT */
   -1,  /* (183) type_name ::= INTEGER */
   -1,  /* (184) type_name ::= BIGINT */
   -1,  /* (185) type_name ::= FLOAT */
   -1,  /* (186) type_name ::= DOUBLE */
   -4,  /* (187) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (188) type_name ::= TIMESTAMP */
   -4,  /* (189) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   -2,  /* (190) type_name ::= TINYINT UNSIGNED */
   -2,  /* (191) type_name ::= SMALLINT UNSIGNED */
   -2,  /* (192) type_name ::= INT UNSIGNED */
   -2,  /* (193) type_name ::= BIGINT UNSIGNED */
   -1,  /* (194) type_name ::= JSON */
   -4,  /* (195) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   -1,  /* (196) type_name ::= MEDIUMBLOB */
   -1,  /* (197) type_name ::= BLOB */
   -4,  /* (198) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (199) type_name ::= DECIMAL */
   -4,  /* (200) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   -6,  /* (201) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
    0,  /* (202) tags_def_opt ::= */
   -1,  /* (203) tags_def_opt ::= tags_def */
   -4,  /* (204) tags_def ::= TAGS NK_LP column_def_list NK_RP */
    0,  /* (205) table_options ::= */
   -3,  /* (206) table_options ::= table_options COMMENT NK_STRING */
   -3,  /* (207) table_options ::= table_options MAX_DELAY duration_list */
   -3,  /* (208) table_options ::= table_options WATERMARK duration_list */
   -5,  /* (209) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   -3,  /* (210) table_options ::= table_options TTL NK_INTEGER */
   -5,  /* (211) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   -3,  /* (212) table_options ::= table_options DELETE_MARK duration_list */
   -1,  /* (213) alter_table_options ::= alter_table_option */
   -2,  /* (214) alter_table_options ::= alter_table_options alter_table_option */
   -2,  /* (215) alter_table_option ::= COMMENT NK_STRING */
   -2,  /* (216) alter_table_option ::= TTL NK_INTEGER */
   -1,  /* (217) duration_list ::= duration_literal */
   -3,  /* (218) duration_list ::= duration_list NK_COMMA duration_literal */
   -1,  /* (219) rollup_func_list ::= rollup_func_name */
   -3,  /* (220) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   -1,  /* (221) rollup_func_name ::= function_name */
   -1,  /* (222) rollup_func_name ::= FIRST */
   -1,  /* (223) rollup_func_name ::= LAST */
   -1,  /* (224) col_name_list ::= col_name */
   -3,  /* (225) col_name_list ::= col_name_list NK_COMMA col_name */
   -1,  /* (226) col_name ::= column_name */
   -2,  /* (227) cmd ::= SHOW DNODES */
   -2,  /* (228) cmd ::= SHOW USERS */
   -3,  /* (229) cmd ::= SHOW USER PRIVILEGES */
   -2,  /* (230) cmd ::= SHOW DATABASES */
   -4,  /* (231) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   -4,  /* (232) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   -3,  /* (233) cmd ::= SHOW db_name_cond_opt VGROUPS */
   -2,  /* (234) cmd ::= SHOW MNODES */
   -2,  /* (235) cmd ::= SHOW QNODES */
   -2,  /* (236) cmd ::= SHOW FUNCTIONS */
   -5,  /* (237) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   -2,  /* (238) cmd ::= SHOW STREAMS */
   -2,  /* (239) cmd ::= SHOW ACCOUNTS */
   -2,  /* (240) cmd ::= SHOW APPS */
   -2,  /* (241) cmd ::= SHOW CONNECTIONS */
   -2,  /* (242) cmd ::= SHOW LICENCES */
   -2,  /* (243) cmd ::= SHOW GRANTS */
   -4,  /* (244) cmd ::= SHOW CREATE DATABASE db_name */
   -4,  /* (245) cmd ::= SHOW CREATE TABLE full_table_name */
   -4,  /* (246) cmd ::= SHOW CREATE STABLE full_table_name */
   -2,  /* (247) cmd ::= SHOW QUERIES */
   -2,  /* (248) cmd ::= SHOW SCORES */
   -2,  /* (249) cmd ::= SHOW TOPICS */
   -2,  /* (250) cmd ::= SHOW VARIABLES */
   -3,  /* (251) cmd ::= SHOW CLUSTER VARIABLES */
   -3,  /* (252) cmd ::= SHOW LOCAL VARIABLES */
   -5,  /* (253) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   -2,  /* (254) cmd ::= SHOW BNODES */
   -2,  /* (255) cmd ::= SHOW SNODES */
   -2,  /* (256) cmd ::= SHOW CLUSTER */
   -2,  /* (257) cmd ::= SHOW TRANSACTIONS */
   -4,  /* (258) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   -2,  /* (259) cmd ::= SHOW CONSUMERS */
   -2,  /* (260) cmd ::= SHOW SUBSCRIPTIONS */
   -5,  /* (261) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   -7,  /* (262) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   -3,  /* (263) cmd ::= SHOW VNODES NK_INTEGER */
   -3,  /* (264) cmd ::= SHOW VNODES NK_STRING */
   -3,  /* (265) cmd ::= SHOW db_name_cond_opt ALIVE */
   -3,  /* (266) cmd ::= SHOW CLUSTER ALIVE */
    0,  /* (267) db_name_cond_opt ::= */
   -2,  /* (268) db_name_cond_opt ::= db_name NK_DOT */
    0,  /* (269) like_pattern_opt ::= */
   -2,  /* (270) like_pattern_opt ::= LIKE NK_STRING */
   -1,  /* (271) table_name_cond ::= table_name */
    0,  /* (272) from_db_opt ::= */
   -2,  /* (273) from_db_opt ::= FROM db_name */
    0,  /* (274) tag_list_opt ::= */
   -1,  /* (275) tag_list_opt ::= tag_item */
   -3,  /* (276) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   -1,  /* (277) tag_item ::= TBNAME */
   -1,  /* (278) tag_item ::= QTAGS */
   -1,  /* (279) tag_item ::= column_name */
   -2,  /* (280) tag_item ::= column_name column_alias */
   -3,  /* (281) tag_item ::= column_name AS column_alias */
   -8,  /* (282) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
   -9,  /* (283) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
   -4,  /* (284) cmd ::= DROP INDEX exists_opt full_index_name */
   -1,  /* (285) full_index_name ::= index_name */
   -3,  /* (286) full_index_name ::= db_name NK_DOT index_name */
  -10,  /* (287) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  -12,  /* (288) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   -1,  /* (289) func_list ::= func */
   -3,  /* (290) func_list ::= func_list NK_COMMA func */
   -4,  /* (291) func ::= sma_func_name NK_LP expression_list NK_RP */
   -1,  /* (292) sma_func_name ::= function_name */
   -1,  /* (293) sma_func_name ::= COUNT */
   -1,  /* (294) sma_func_name ::= FIRST */
   -1,  /* (295) sma_func_name ::= LAST */
   -1,  /* (296) sma_func_name ::= LAST_ROW */
    0,  /* (297) sma_stream_opt ::= */
   -3,  /* (298) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   -3,  /* (299) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   -3,  /* (300) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   -6,  /* (301) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   -7,  /* (302) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   -9,  /* (303) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   -7,  /* (304) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
   -9,  /* (305) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
   -4,  /* (306) cmd ::= DROP TOPIC exists_opt topic_name */
   -7,  /* (307) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   -2,  /* (308) cmd ::= DESC full_table_name */
   -2,  /* (309) cmd ::= DESCRIBE full_table_name */
   -3,  /* (310) cmd ::= RESET QUERY CACHE */
   -4,  /* (311) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   -4,  /* (312) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
    0,  /* (313) analyze_opt ::= */
   -1,  /* (314) analyze_opt ::= ANALYZE */
    0,  /* (315) explain_options ::= */
   -3,  /* (316) explain_options ::= explain_options VERBOSE NK_BOOL */
   -3,  /* (317) explain_options ::= explain_options RATIO NK_FLOAT */
  -12,  /* (318) cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
   -4,  /* (319) cmd ::= DROP FUNCTION exists_opt function_name */
    0,  /* (320) agg_func_opt ::= */
   -1,  /* (321) agg_func_opt ::= AGGREGATE */
    0,  /* (322) bufsize_opt ::= */
   -2,  /* (323) bufsize_opt ::= BUFSIZE NK_INTEGER */
    0,  /* (324) language_opt ::= */
   -2,  /* (325) language_opt ::= LANGUAGE NK_STRING */
    0,  /* (326) or_replace_opt ::= */
   -2,  /* (327) or_replace_opt ::= OR REPLACE */
  -12,  /* (328) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
   -4,  /* (329) cmd ::= DROP STREAM exists_opt stream_name */
    0,  /* (330) col_list_opt ::= */
   -3,  /* (331) col_list_opt ::= NK_LP col_name_list NK_RP */
    0,  /* (332) tag_def_or_ref_opt ::= */
   -1,  /* (333) tag_def_or_ref_opt ::= tags_def */
   -4,  /* (334) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
    0,  /* (335) stream_options ::= */
   -3,  /* (336) stream_options ::= stream_options TRIGGER AT_ONCE */
   -3,  /* (337) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   -4,  /* (338) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   -3,  /* (339) stream_options ::= stream_options WATERMARK duration_literal */
   -4,  /* (340) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   -3,  /* (341) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   -3,  /* (342) stream_options ::= stream_options DELETE_MARK duration_literal */
   -4,  /* (343) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
    0,  /* (344) subtable_opt ::= */
   -4,  /* (345) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
   -3,  /* (346) cmd ::= KILL CONNECTION NK_INTEGER */
   -3,  /* (347) cmd ::= KILL QUERY NK_STRING */
   -3,  /* (348) cmd ::= KILL TRANSACTION NK_INTEGER */
   -2,  /* (349) cmd ::= BALANCE VGROUP */
   -3,  /* (350) cmd ::= BALANCE VGROUP LEADER */
   -4,  /* (351) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   -4,  /* (352) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   -3,  /* (353) cmd ::= SPLIT VGROUP NK_INTEGER */
   -2,  /* (354) dnode_list ::= DNODE NK_INTEGER */
   -3,  /* (355) dnode_list ::= dnode_list DNODE NK_INTEGER */
   -4,  /* (356) cmd ::= DELETE FROM full_table_name where_clause_opt */
   -1,  /* (357) cmd ::= query_or_subquery */
   -1,  /* (358) cmd ::= insert_query */
   -7,  /* (359) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   -4,  /* (360) insert_query ::= INSERT INTO full_table_name query_or_subquery */
   -1,  /* (361) literal ::= NK_INTEGER */
   -1,  /* (362) literal ::= NK_FLOAT */
   -1,  /* (363) literal ::= NK_STRING */
   -1,  /* (364) literal ::= NK_BOOL */
   -2,  /* (365) literal ::= TIMESTAMP NK_STRING */
   -1,  /* (366) literal ::= duration_literal */
   -1,  /* (367) literal ::= NULL */
   -1,  /* (368) literal ::= NK_QUESTION */
   -1,  /* (369) duration_literal ::= NK_VARIABLE */
   -1,  /* (370) signed ::= NK_INTEGER */
   -2,  /* (371) signed ::= NK_PLUS NK_INTEGER */
   -2,  /* (372) signed ::= NK_MINUS NK_INTEGER */
   -1,  /* (373) signed ::= NK_FLOAT */
   -2,  /* (374) signed ::= NK_PLUS NK_FLOAT */
   -2,  /* (375) signed ::= NK_MINUS NK_FLOAT */
   -1,  /* (376) signed_literal ::= signed */
   -1,  /* (377) signed_literal ::= NK_STRING */
   -1,  /* (378) signed_literal ::= NK_BOOL */
   -2,  /* (379) signed_literal ::= TIMESTAMP NK_STRING */
   -1,  /* (380) signed_literal ::= duration_literal */
   -1,  /* (381) signed_literal ::= NULL */
   -1,  /* (382) signed_literal ::= literal_func */
   -1,  /* (383) signed_literal ::= NK_QUESTION */
   -1,  /* (384) literal_list ::= signed_literal */
   -3,  /* (385) literal_list ::= literal_list NK_COMMA signed_literal */
   -1,  /* (386) db_name ::= NK_ID */
   -1,  /* (387) table_name ::= NK_ID */
   -1,  /* (388) column_name ::= NK_ID */
   -1,  /* (389) function_name ::= NK_ID */
   -1,  /* (390) table_alias ::= NK_ID */
   -1,  /* (391) column_alias ::= NK_ID */
   -1,  /* (392) user_name ::= NK_ID */
   -1,  /* (393) topic_name ::= NK_ID */
   -1,  /* (394) stream_name ::= NK_ID */
   -1,  /* (395) cgroup_name ::= NK_ID */
   -1,  /* (396) index_name ::= NK_ID */
   -1,  /* (397) expr_or_subquery ::= expression */
   -1,  /* (398) expression ::= literal */
   -1,  /* (399) expression ::= pseudo_column */
   -1,  /* (400) expression ::= column_reference */
   -1,  /* (401) expression ::= function_expression */
   -1,  /* (402) expression ::= case_when_expression */
   -3,  /* (403) expression ::= NK_LP expression NK_RP */
   -2,  /* (404) expression ::= NK_PLUS expr_or_subquery */
   -2,  /* (405) expression ::= NK_MINUS expr_or_subquery */
   -3,  /* (406) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   -3,  /* (407) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   -3,  /* (408) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   -3,  /* (409) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   -3,  /* (410) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   -3,  /* (411) expression ::= column_reference NK_ARROW NK_STRING */
   -3,  /* (412) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   -3,  /* (413) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   -1,  /* (414) expression_list ::= expr_or_subquery */
   -3,  /* (415) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   -1,  /* (416) column_reference ::= column_name */
   -3,  /* (417) column_reference ::= table_name NK_DOT column_name */
   -1,  /* (418) pseudo_column ::= ROWTS */
   -1,  /* (419) pseudo_column ::= TBNAME */
   -3,  /* (420) pseudo_column ::= table_name NK_DOT TBNAME */
   -1,  /* (421) pseudo_column ::= QSTART */
   -1,  /* (422) pseudo_column ::= QEND */
   -1,  /* (423) pseudo_column ::= QDURATION */
   -1,  /* (424) pseudo_column ::= WSTART */
   -1,  /* (425) pseudo_column ::= WEND */
   -1,  /* (426) pseudo_column ::= WDURATION */
   -1,  /* (427) pseudo_column ::= IROWTS */
   -1,  /* (428) pseudo_column ::= ISFILLED */
   -1,  /* (429) pseudo_column ::= QTAGS */
   -4,  /* (430) function_expression ::= function_name NK_LP expression_list NK_RP */
   -4,  /* (431) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   -6,  /* (432) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   -1,  /* (433) function_expression ::= literal_func */
   -3,  /* (434) literal_func ::= noarg_func NK_LP NK_RP */
   -1,  /* (435) literal_func ::= NOW */
   -1,  /* (436) noarg_func ::= NOW */
   -1,  /* (437) noarg_func ::= TODAY */
   -1,  /* (438) noarg_func ::= TIMEZONE */
   -1,  /* (439) noarg_func ::= DATABASE */
   -1,  /* (440) noarg_func ::= CLIENT_VERSION */
   -1,  /* (441) noarg_func ::= SERVER_VERSION */
   -1,  /* (442) noarg_func ::= SERVER_STATUS */
   -1,  /* (443) noarg_func ::= CURRENT_USER */
   -1,  /* (444) noarg_func ::= USER */
   -1,  /* (445) star_func ::= COUNT */
   -1,  /* (446) star_func ::= FIRST */
   -1,  /* (447) star_func ::= LAST */
   -1,  /* (448) star_func ::= LAST_ROW */
   -1,  /* (449) star_func_para_list ::= NK_STAR */
   -1,  /* (450) star_func_para_list ::= other_para_list */
   -1,  /* (451) other_para_list ::= star_func_para */
   -3,  /* (452) other_para_list ::= other_para_list NK_COMMA star_func_para */
   -1,  /* (453) star_func_para ::= expr_or_subquery */
   -3,  /* (454) star_func_para ::= table_name NK_DOT NK_STAR */
   -4,  /* (455) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   -5,  /* (456) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   -1,  /* (457) when_then_list ::= when_then_expr */
   -2,  /* (458) when_then_list ::= when_then_list when_then_expr */
   -4,  /* (459) when_then_expr ::= WHEN common_expression THEN common_expression */
    0,  /* (460) case_when_else_opt ::= */
   -2,  /* (461) case_when_else_opt ::= ELSE common_expression */
   -3,  /* (462) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   -5,  /* (463) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   -6,  /* (464) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   -3,  /* (465) predicate ::= expr_or_subquery IS NULL */
   -4,  /* (466) predicate ::= expr_or_subquery IS NOT NULL */
   -3,  /* (467) predicate ::= expr_or_subquery in_op in_predicate_value */
   -1,  /* (468) compare_op ::= NK_LT */
   -1,  /* (469) compare_op ::= NK_GT */
   -1,  /* (470) compare_op ::= NK_LE */
   -1,  /* (471) compare_op ::= NK_GE */
   -1,  /* (472) compare_op ::= NK_NE */
   -1,  /* (473) compare_op ::= NK_EQ */
   -1,  /* (474) compare_op ::= LIKE */
   -2,  /* (475) compare_op ::= NOT LIKE */
   -1,  /* (476) compare_op ::= MATCH */
   -1,  /* (477) compare_op ::= NMATCH */
   -1,  /* (478) compare_op ::= CONTAINS */
   -1,  /* (479) in_op ::= IN */
   -2,  /* (480) in_op ::= NOT IN */
   -3,  /* (481) in_predicate_value ::= NK_LP literal_list NK_RP */
   -1,  /* (482) boolean_value_expression ::= boolean_primary */
   -2,  /* (483) boolean_value_expression ::= NOT boolean_primary */
   -3,  /* (484) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   -3,  /* (485) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   -1,  /* (486) boolean_primary ::= predicate */
   -3,  /* (487) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   -1,  /* (488) common_expression ::= expr_or_subquery */
   -1,  /* (489) common_expression ::= boolean_value_expression */
    0,  /* (490) from_clause_opt ::= */
   -2,  /* (491) from_clause_opt ::= FROM table_reference_list */
   -1,  /* (492) table_reference_list ::= table_reference */
   -3,  /* (493) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   -1,  /* (494) table_reference ::= table_primary */
   -1,  /* (495) table_reference ::= joined_table */
   -2,  /* (496) table_primary ::= table_name alias_opt */
   -4,  /* (497) table_primary ::= db_name NK_DOT table_name alias_opt */
   -2,  /* (498) table_primary ::= subquery alias_opt */
   -1,  /* (499) table_primary ::= parenthesized_joined_table */
    0,  /* (500) alias_opt ::= */
   -1,  /* (501) alias_opt ::= table_alias */
   -2,  /* (502) alias_opt ::= AS table_alias */
   -3,  /* (503) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   -3,  /* (504) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   -6,  /* (505) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
    0,  /* (506) join_type ::= */
   -1,  /* (507) join_type ::= INNER */
  -12,  /* (508) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
    0,  /* (509) set_quantifier_opt ::= */
   -1,  /* (510) set_quantifier_opt ::= DISTINCT */
   -1,  /* (511) set_quantifier_opt ::= ALL */
   -1,  /* (512) select_list ::= select_item */
   -3,  /* (513) select_list ::= select_list NK_COMMA select_item */
   -1,  /* (514) select_item ::= NK_STAR */
   -1,  /* (515) select_item ::= common_expression */
   -2,  /* (516) select_item ::= common_expression column_alias */
   -3,  /* (517) select_item ::= common_expression AS column_alias */
   -3,  /* (518) select_item ::= table_name NK_DOT NK_STAR */
    0,  /* (519) where_clause_opt ::= */
   -2,  /* (520) where_clause_opt ::= WHERE search_condition */
    0,  /* (521) partition_by_clause_opt ::= */
   -3,  /* (522) partition_by_clause_opt ::= PARTITION BY partition_list */
   -1,  /* (523) partition_list ::= partition_item */
   -3,  /* (524) partition_list ::= partition_list NK_COMMA partition_item */
   -1,  /* (525) partition_item ::= expr_or_subquery */
   -2,  /* (526) partition_item ::= expr_or_subquery column_alias */
   -3,  /* (527) partition_item ::= expr_or_subquery AS column_alias */
    0,  /* (528) twindow_clause_opt ::= */
   -6,  /* (529) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   -4,  /* (530) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   -6,  /* (531) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   -8,  /* (532) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   -7,  /* (533) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
    0,  /* (534) sliding_opt ::= */
   -4,  /* (535) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
    0,  /* (536) fill_opt ::= */
   -4,  /* (537) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   -6,  /* (538) fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
   -6,  /* (539) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
   -1,  /* (540) fill_mode ::= NONE */
   -1,  /* (541) fill_mode ::= PREV */
   -1,  /* (542) fill_mode ::= NULL */
   -1,  /* (543) fill_mode ::= NULL_F */
   -1,  /* (544) fill_mode ::= LINEAR */
   -1,  /* (545) fill_mode ::= NEXT */
    0,  /* (546) group_by_clause_opt ::= */
   -3,  /* (547) group_by_clause_opt ::= GROUP BY group_by_list */
   -1,  /* (548) group_by_list ::= expr_or_subquery */
   -3,  /* (549) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
    0,  /* (550) having_clause_opt ::= */
   -2,  /* (551) having_clause_opt ::= HAVING search_condition */
    0,  /* (552) range_opt ::= */
   -6,  /* (553) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
    0,  /* (554) every_opt ::= */
   -4,  /* (555) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   -4,  /* (556) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   -1,  /* (557) query_simple ::= query_specification */
   -1,  /* (558) query_simple ::= union_query_expression */
   -4,  /* (559) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   -3,  /* (560) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   -1,  /* (561) query_simple_or_subquery ::= query_simple */
   -1,  /* (562) query_simple_or_subquery ::= subquery */
   -1,  /* (563) query_or_subquery ::= query_expression */
   -1,  /* (564) query_or_subquery ::= subquery */
    0,  /* (565) order_by_clause_opt ::= */
   -3,  /* (566) order_by_clause_opt ::= ORDER BY sort_specification_list */
    0,  /* (567) slimit_clause_opt ::= */
   -2,  /* (568) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   -4,  /* (569) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   -4,  /* (570) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
    0,  /* (571) limit_clause_opt ::= */
   -2,  /* (572) limit_clause_opt ::= LIMIT NK_INTEGER */
   -4,  /* (573) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   -4,  /* (574) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   -3,  /* (575) subquery ::= NK_LP query_expression NK_RP */
   -3,  /* (576) subquery ::= NK_LP subquery NK_RP */
   -1,  /* (577) search_condition ::= common_expression */
   -1,  /* (578) sort_specification_list ::= sort_specification */
   -3,  /* (579) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   -3,  /* (580) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
    0,  /* (581) ordering_specification_opt ::= */
   -1,  /* (582) ordering_specification_opt ::= ASC */
   -1,  /* (583) ordering_specification_opt ::= DESC */
    0,  /* (584) null_ordering_opt ::= */
   -2,  /* (585) null_ordering_opt ::= NULLS FIRST */
   -2,  /* (586) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfoNRhs[yyruleno];
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
        yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
#line 50 "sql.y"
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
#line 4529 "sql.c"
  yy_destructor(yypParser,333,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
#line 51 "sql.y"
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
#line 4535 "sql.c"
  yy_destructor(yypParser,334,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
#line 55 "sql.y"
{ }
#line 4541 "sql.c"
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,333,&yymsp[-2].minor);
#line 56 "sql.y"
{ }
#line 4555 "sql.c"
  yy_destructor(yypParser,335,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,336,&yymsp[0].minor);
#line 68 "sql.y"
{ }
#line 4563 "sql.c"
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,334,&yymsp[-1].minor);
#line 69 "sql.y"
{ }
#line 4570 "sql.c"
  yy_destructor(yypParser,336,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
#line 73 "sql.y"
{ }
#line 4586 "sql.c"
  yy_destructor(yypParser,335,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
#line 85 "sql.y"
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy649, &yymsp[-1].minor.yy0, yymsp[0].minor.yy231); }
#line 4592 "sql.c"
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
#line 86 "sql.y"
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy649, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
#line 4597 "sql.c"
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
#line 87 "sql.y"
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy649, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
#line 4602 "sql.c"
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
#line 88 "sql.y"
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy649, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
#line 4607 "sql.c"
        break;
      case 28: /* cmd ::= DROP USER user_name */
#line 89 "sql.y"
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy649); }
#line 4612 "sql.c"
        break;
      case 29: /* sysinfo_opt ::= */
#line 93 "sql.y"
{ yymsp[1].minor.yy231 = 1; }
#line 4617 "sql.c"
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
#line 94 "sql.y"
{ yymsp[-1].minor.yy231 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
#line 4622 "sql.c"
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
#line 97 "sql.y"
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-5].minor.yy541, &yymsp[-3].minor.yy409, &yymsp[0].minor.yy649, yymsp[-2].minor.yy184); }
#line 4627 "sql.c"
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
#line 98 "sql.y"
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-5].minor.yy541, &yymsp[-3].minor.yy409, &yymsp[0].minor.yy649, yymsp[-2].minor.yy184); }
#line 4632 "sql.c"
        break;
      case 33: /* privileges ::= ALL */
#line 102 "sql.y"
{ yymsp[0].minor.yy541 = PRIVILEGE_TYPE_ALL; }
#line 4637 "sql.c"
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
#line 103 "sql.y"
{ yylhsminor.yy541 = yymsp[0].minor.yy541; }
#line 4643 "sql.c"
  yymsp[0].minor.yy541 = yylhsminor.yy541;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
#line 104 "sql.y"
{ yymsp[0].minor.yy541 = PRIVILEGE_TYPE_SUBSCRIBE; }
#line 4649 "sql.c"
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
#line 109 "sql.y"
{ yylhsminor.yy541 = yymsp[-2].minor.yy541 | yymsp[0].minor.yy541; }
#line 4654 "sql.c"
  yymsp[-2].minor.yy541 = yylhsminor.yy541;
        break;
      case 38: /* priv_type ::= READ */
#line 113 "sql.y"
{ yymsp[0].minor.yy541 = PRIVILEGE_TYPE_READ; }
#line 4660 "sql.c"
        break;
      case 39: /* priv_type ::= WRITE */
#line 114 "sql.y"
{ yymsp[0].minor.yy541 = PRIVILEGE_TYPE_WRITE; }
#line 4665 "sql.c"
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
#line 118 "sql.y"
{ yylhsminor.yy409.first = yymsp[-2].minor.yy0; yylhsminor.yy409.second = yymsp[0].minor.yy0; }
#line 4670 "sql.c"
  yymsp[-2].minor.yy409 = yylhsminor.yy409;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
#line 119 "sql.y"
{ yylhsminor.yy409.first = yymsp[-2].minor.yy649; yylhsminor.yy409.second = yymsp[0].minor.yy0; }
#line 4676 "sql.c"
  yymsp[-2].minor.yy409 = yylhsminor.yy409;
        break;
      case 42: /* priv_level ::= db_name NK_DOT table_name */
#line 120 "sql.y"
{ yylhsminor.yy409.first = yymsp[-2].minor.yy649; yylhsminor.yy409.second = yymsp[0].minor.yy649; }
#line 4682 "sql.c"
  yymsp[-2].minor.yy409 = yylhsminor.yy409;
        break;
      case 43: /* priv_level ::= topic_name */
#line 121 "sql.y"
{ yylhsminor.yy409.first = yymsp[0].minor.yy649; yylhsminor.yy409.second = nil_token; }
#line 4688 "sql.c"
  yymsp[0].minor.yy409 = yylhsminor.yy409;
        break;
      case 44: /* with_opt ::= */
      case 141: /* start_opt ::= */ yytestcase(yyruleno==141);
      case 145: /* end_opt ::= */ yytestcase(yyruleno==145);
      case 269: /* like_pattern_opt ::= */ yytestcase(yyruleno==269);
      case 344: /* subtable_opt ::= */ yytestcase(yyruleno==344);
      case 460: /* case_when_else_opt ::= */ yytestcase(yyruleno==460);
      case 490: /* from_clause_opt ::= */ yytestcase(yyruleno==490);
      case 519: /* where_clause_opt ::= */ yytestcase(yyruleno==519);
      case 528: /* twindow_clause_opt ::= */ yytestcase(yyruleno==528);
      case 534: /* sliding_opt ::= */ yytestcase(yyruleno==534);
      case 536: /* fill_opt ::= */ yytestcase(yyruleno==536);
      case 550: /* having_clause_opt ::= */ yytestcase(yyruleno==550);
      case 552: /* range_opt ::= */ yytestcase(yyruleno==552);
      case 554: /* every_opt ::= */ yytestcase(yyruleno==554);
      case 567: /* slimit_clause_opt ::= */ yytestcase(yyruleno==567);
      case 571: /* limit_clause_opt ::= */ yytestcase(yyruleno==571);
#line 123 "sql.y"
{ yymsp[1].minor.yy184 = NULL; }
#line 4709 "sql.c"
        break;
      case 45: /* with_opt ::= WITH search_condition */
      case 491: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==491);
      case 520: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==520);
      case 551: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==551);
#line 124 "sql.y"
{ yymsp[-1].minor.yy184 = yymsp[0].minor.yy184; }
#line 4717 "sql.c"
        break;
      case 46: /* cmd ::= CREATE DNODE dnode_endpoint */
#line 127 "sql.y"
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy649, NULL); }
#line 4722 "sql.c"
        break;
      case 47: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
#line 128 "sql.y"
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy649, &yymsp[0].minor.yy0); }
#line 4727 "sql.c"
        break;
      case 48: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
#line 129 "sql.y"
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy829); }
#line 4732 "sql.c"
        break;
      case 49: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
#line 130 "sql.y"
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy649, yymsp[0].minor.yy829); }
#line 4737 "sql.c"
        break;
      case 50: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
#line 131 "sql.y"
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
#line 4742 "sql.c"
        break;
      case 51: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
#line 132 "sql.y"
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
#line 4747 "sql.c"
        break;
      case 52: /* cmd ::= ALTER ALL DNODES NK_STRING */
#line 133 "sql.y"
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
#line 4752 "sql.c"
        break;
      case 53: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
#line 134 "sql.y"
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
#line 4757 "sql.c"
        break;
      case 54: /* cmd ::= RESTORE DNODE NK_INTEGER */
#line 135 "sql.y"
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_DNODE_STMT, &yymsp[0].minor.yy0); }
#line 4762 "sql.c"
        break;
      case 55: /* dnode_endpoint ::= NK_STRING */
      case 56: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==56);
      case 57: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==57);
      case 293: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==293);
      case 294: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==294);
      case 295: /* sma_func_name ::= LAST */ yytestcase(yyruleno==295);
      case 296: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==296);
      case 386: /* db_name ::= NK_ID */ yytestcase(yyruleno==386);
      case 387: /* table_name ::= NK_ID */ yytestcase(yyruleno==387);
      case 388: /* column_name ::= NK_ID */ yytestcase(yyruleno==388);
      case 389: /* function_name ::= NK_ID */ yytestcase(yyruleno==389);
      case 390: /* table_alias ::= NK_ID */ yytestcase(yyruleno==390);
      case 391: /* column_alias ::= NK_ID */ yytestcase(yyruleno==391);
      case 392: /* user_name ::= NK_ID */ yytestcase(yyruleno==392);
      case 393: /* topic_name ::= NK_ID */ yytestcase(yyruleno==393);
      case 394: /* stream_name ::= NK_ID */ yytestcase(yyruleno==394);
      case 395: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==395);
      case 396: /* index_name ::= NK_ID */ yytestcase(yyruleno==396);
      case 436: /* noarg_func ::= NOW */ yytestcase(yyruleno==436);
      case 437: /* noarg_func ::= TODAY */ yytestcase(yyruleno==437);
      case 438: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==438);
      case 439: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==439);
      case 440: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==440);
      case 441: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==441);
      case 442: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==442);
      case 443: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==443);
      case 444: /* noarg_func ::= USER */ yytestcase(yyruleno==444);
      case 445: /* star_func ::= COUNT */ yytestcase(yyruleno==445);
      case 446: /* star_func ::= FIRST */ yytestcase(yyruleno==446);
      case 447: /* star_func ::= LAST */ yytestcase(yyruleno==447);
      case 448: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==448);
#line 139 "sql.y"
{ yylhsminor.yy649 = yymsp[0].minor.yy0; }
#line 4797 "sql.c"
  yymsp[0].minor.yy649 = yylhsminor.yy649;
        break;
      case 58: /* force_opt ::= */
      case 81: /* not_exists_opt ::= */ yytestcase(yyruleno==81);
      case 83: /* exists_opt ::= */ yytestcase(yyruleno==83);
      case 313: /* analyze_opt ::= */ yytestcase(yyruleno==313);
      case 320: /* agg_func_opt ::= */ yytestcase(yyruleno==320);
      case 326: /* or_replace_opt ::= */ yytestcase(yyruleno==326);
      case 509: /* set_quantifier_opt ::= */ yytestcase(yyruleno==509);
#line 145 "sql.y"
{ yymsp[1].minor.yy829 = false; }
#line 4809 "sql.c"
        break;
      case 59: /* force_opt ::= FORCE */
      case 314: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==314);
      case 321: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==321);
      case 510: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==510);
#line 146 "sql.y"
{ yymsp[0].minor.yy829 = true; }
#line 4817 "sql.c"
        break;
      case 60: /* cmd ::= ALTER LOCAL NK_STRING */
#line 149 "sql.y"
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
#line 4822 "sql.c"
        break;
      case 61: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
#line 150 "sql.y"
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
#line 4827 "sql.c"
        break;
      case 62: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
#line 153 "sql.y"
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
#line 4832 "sql.c"
        break;
      case 63: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
#line 154 "sql.y"
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
#line 4837 "sql.c"
        break;
      case 64: /* cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
#line 155 "sql.y"
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_QNODE_STMT, &yymsp[0].minor.yy0); }
#line 4842 "sql.c"
        break;
      case 65: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
#line 158 "sql.y"
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
#line 4847 "sql.c"
        break;
      case 66: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
#line 159 "sql.y"
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
#line 4852 "sql.c"
        break;
      case 67: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
#line 162 "sql.y"
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
#line 4857 "sql.c"
        break;
      case 68: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
#line 163 "sql.y"
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
#line 4862 "sql.c"
        break;
      case 69: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
#line 166 "sql.y"
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
#line 4867 "sql.c"
        break;
      case 70: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
#line 167 "sql.y"
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
#line 4872 "sql.c"
        break;
      case 71: /* cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
#line 168 "sql.y"
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_MNODE_STMT, &yymsp[0].minor.yy0); }
#line 4877 "sql.c"
        break;
      case 72: /* cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
#line 171 "sql.y"
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_VNODE_STMT, &yymsp[0].minor.yy0); }
#line 4882 "sql.c"
        break;
      case 73: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
#line 174 "sql.y"
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy829, &yymsp[-1].minor.yy649, yymsp[0].minor.yy184); }
#line 4887 "sql.c"
        break;
      case 74: /* cmd ::= DROP DATABASE exists_opt db_name */
#line 175 "sql.y"
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy829, &yymsp[0].minor.yy649); }
#line 4892 "sql.c"
        break;
      case 75: /* cmd ::= USE db_name */
#line 176 "sql.y"
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy649); }
#line 4897 "sql.c"
        break;
      case 76: /* cmd ::= ALTER DATABASE db_name alter_db_options */
#line 177 "sql.y"
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy649, yymsp[0].minor.yy184); }
#line 4902 "sql.c"
        break;
      case 77: /* cmd ::= FLUSH DATABASE db_name */
#line 178 "sql.y"
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy649); }
#line 4907 "sql.c"
        break;
      case 78: /* cmd ::= TRIM DATABASE db_name speed_opt */
#line 179 "sql.y"
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy649, yymsp[0].minor.yy480); }
#line 4912 "sql.c"
        break;
      case 79: /* cmd ::= COMPACT DATABASE db_name start_opt end_opt */
#line 180 "sql.y"
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[-2].minor.yy649, yymsp[-1].minor.yy184, yymsp[0].minor.yy184); }
#line 4917 "sql.c"
        break;
      case 80: /* not_exists_opt ::= IF NOT EXISTS */
#line 184 "sql.y"
{ yymsp[-2].minor.yy829 = true; }
#line 4922 "sql.c"
        break;
      case 82: /* exists_opt ::= IF EXISTS */
      case 327: /* or_replace_opt ::= OR REPLACE */ yytestcase(yyruleno==327);
#line 189 "sql.y"
{ yymsp[-1].minor.yy829 = true; }
#line 4928 "sql.c"
        break;
      case 84: /* db_options ::= */
#line 192 "sql.y"
{ yymsp[1].minor.yy184 = createDefaultDatabaseOptions(pCxt); }
#line 4933 "sql.c"
        break;
      case 85: /* db_options ::= db_options BUFFER NK_INTEGER */
#line 193 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
#line 4938 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 86: /* db_options ::= db_options CACHEMODEL NK_STRING */
#line 194 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
#line 4944 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 87: /* db_options ::= db_options CACHESIZE NK_INTEGER */
#line 195 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
#line 4950 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 88: /* db_options ::= db_options COMP NK_INTEGER */
#line 196 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
#line 4956 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 89: /* db_options ::= db_options DURATION NK_INTEGER */
      case 90: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==90);
#line 197 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
#line 4963 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 91: /* db_options ::= db_options MAXROWS NK_INTEGER */
#line 199 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
#line 4969 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 92: /* db_options ::= db_options MINROWS NK_INTEGER */
#line 200 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
#line 4975 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 93: /* db_options ::= db_options KEEP integer_list */
      case 94: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==94);
#line 201 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_KEEP, yymsp[0].minor.yy532); }
#line 4982 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 95: /* db_options ::= db_options PAGES NK_INTEGER */
#line 203 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
#line 4988 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 96: /* db_options ::= db_options PAGESIZE NK_INTEGER */
#line 204 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
#line 4994 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 97: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
#line 205 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
#line 5000 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 98: /* db_options ::= db_options PRECISION NK_STRING */
#line 206 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
#line 5006 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 99: /* db_options ::= db_options REPLICA NK_INTEGER */
#line 207 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
#line 5012 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 100: /* db_options ::= db_options VGROUPS NK_INTEGER */
#line 209 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
#line 5018 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 101: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
#line 210 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
#line 5024 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 102: /* db_options ::= db_options RETENTIONS retention_list */
#line 211 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_RETENTIONS, yymsp[0].minor.yy532); }
#line 5030 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 103: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
#line 212 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
#line 5036 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 104: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
#line 213 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
#line 5042 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 105: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
#line 214 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
#line 5048 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 106: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
#line 215 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
#line 5054 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 107: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
#line 216 "sql.y"
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-3].minor.yy184, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
#line 5064 "sql.c"
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 108: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
#line 221 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
#line 5070 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 109: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
#line 222 "sql.y"
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-3].minor.yy184, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
#line 5080 "sql.c"
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 110: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
#line 227 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
#line 5086 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 111: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
#line 228 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
#line 5092 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 112: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
#line 229 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
#line 5098 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 113: /* db_options ::= db_options TABLE_PREFIX signed */
#line 230 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_TABLE_PREFIX, yymsp[0].minor.yy184); }
#line 5104 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 114: /* db_options ::= db_options TABLE_SUFFIX signed */
#line 231 "sql.y"
{ yylhsminor.yy184 = setDatabaseOption(pCxt, yymsp[-2].minor.yy184, DB_OPTION_TABLE_SUFFIX, yymsp[0].minor.yy184); }
#line 5110 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 115: /* alter_db_options ::= alter_db_option */
#line 233 "sql.y"
{ yylhsminor.yy184 = createAlterDatabaseOptions(pCxt); yylhsminor.yy184 = setAlterDatabaseOption(pCxt, yylhsminor.yy184, &yymsp[0].minor.yy361); }
#line 5116 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 116: /* alter_db_options ::= alter_db_options alter_db_option */
#line 234 "sql.y"
{ yylhsminor.yy184 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy184, &yymsp[0].minor.yy361); }
#line 5122 "sql.c"
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 117: /* alter_db_option ::= BUFFER NK_INTEGER */
#line 238 "sql.y"
{ yymsp[-1].minor.yy361.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
#line 5128 "sql.c"
        break;
      case 118: /* alter_db_option ::= CACHEMODEL NK_STRING */
#line 239 "sql.y"
{ yymsp[-1].minor.yy361.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
#line 5133 "sql.c"
        break;
      case 119: /* alter_db_option ::= CACHESIZE NK_INTEGER */
#line 240 "sql.y"
{ yymsp[-1].minor.yy361.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
#line 5138 "sql.c"
        break;
      case 120: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
#line 241 "sql.y"
{ yymsp[-1].minor.yy361.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
#line 5143 "sql.c"
        break;
      case 121: /* alter_db_option ::= KEEP integer_list */
      case 122: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==122);
#line 242 "sql.y"
{ yymsp[-1].minor.yy361.type = DB_OPTION_KEEP; yymsp[-1].minor.yy361.pList = yymsp[0].minor.yy532; }
#line 5149 "sql.c"
        break;
      case 123: /* alter_db_option ::= PAGES NK_INTEGER */
#line 244 "sql.y"
{ yymsp[-1].minor.yy361.type = DB_OPTION_PAGES; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
#line 5154 "sql.c"
        break;
      case 124: /* alter_db_option ::= REPLICA NK_INTEGER */
#line 245 "sql.y"
{ yymsp[-1].minor.yy361.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
#line 5159 "sql.c"
        break;
      case 125: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
#line 247 "sql.y"
{ yymsp[-1].minor.yy361.type = DB_OPTION_WAL; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
#line 5164 "sql.c"
        break;
      case 126: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
#line 248 "sql.y"
{ yymsp[-1].minor.yy361.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
#line 5169 "sql.c"
        break;
      case 127: /* alter_db_option ::= MINROWS NK_INTEGER */
#line 249 "sql.y"
{ yymsp[-1].minor.yy361.type = DB_OPTION_MINROWS; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
#line 5174 "sql.c"
        break;
      case 128: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
#line 250 "sql.y"
{ yymsp[-1].minor.yy361.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
#line 5179 "sql.c"
        break;
      case 129: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
#line 251 "sql.y"
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy361.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-2].minor.yy361.val = t;
                                                                                  }
#line 5188 "sql.c"
        break;
      case 130: /* alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
#line 256 "sql.y"
{ yymsp[-1].minor.yy361.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
#line 5193 "sql.c"
        break;
      case 131: /* alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
#line 257 "sql.y"
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy361.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-2].minor.yy361.val = t;
                                                                                  }
#line 5202 "sql.c"
        break;
      case 132: /* integer_list ::= NK_INTEGER */
#line 265 "sql.y"
{ yylhsminor.yy532 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
#line 5207 "sql.c"
  yymsp[0].minor.yy532 = yylhsminor.yy532;
        break;
      case 133: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 355: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==355);
#line 266 "sql.y"
{ yylhsminor.yy532 = addNodeToList(pCxt, yymsp[-2].minor.yy532, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
#line 5214 "sql.c"
  yymsp[-2].minor.yy532 = yylhsminor.yy532;
        break;
      case 134: /* variable_list ::= NK_VARIABLE */
#line 270 "sql.y"
{ yylhsminor.yy532 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
#line 5220 "sql.c"
  yymsp[0].minor.yy532 = yylhsminor.yy532;
        break;
      case 135: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
#line 271 "sql.y"
{ yylhsminor.yy532 = addNodeToList(pCxt, yymsp[-2].minor.yy532, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
#line 5226 "sql.c"
  yymsp[-2].minor.yy532 = yylhsminor.yy532;
        break;
      case 136: /* retention_list ::= retention */
      case 166: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==166);
      case 169: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==169);
      case 176: /* column_def_list ::= column_def */ yytestcase(yyruleno==176);
      case 219: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==219);
      case 224: /* col_name_list ::= col_name */ yytestcase(yyruleno==224);
      case 275: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==275);
      case 289: /* func_list ::= func */ yytestcase(yyruleno==289);
      case 384: /* literal_list ::= signed_literal */ yytestcase(yyruleno==384);
      case 451: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==451);
      case 457: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==457);
      case 512: /* select_list ::= select_item */ yytestcase(yyruleno==512);
      case 523: /* partition_list ::= partition_item */ yytestcase(yyruleno==523);
      case 578: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==578);
#line 275 "sql.y"
{ yylhsminor.yy532 = createNodeList(pCxt, yymsp[0].minor.yy184); }
#line 5245 "sql.c"
  yymsp[0].minor.yy532 = yylhsminor.yy532;
        break;
      case 137: /* retention_list ::= retention_list NK_COMMA retention */
      case 170: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==170);
      case 177: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==177);
      case 220: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==220);
      case 225: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==225);
      case 276: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==276);
      case 290: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==290);
      case 385: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==385);
      case 452: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==452);
      case 513: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==513);
      case 524: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==524);
      case 579: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==579);
#line 276 "sql.y"
{ yylhsminor.yy532 = addNodeToList(pCxt, yymsp[-2].minor.yy532, yymsp[0].minor.yy184); }
#line 5262 "sql.c"
  yymsp[-2].minor.yy532 = yylhsminor.yy532;
        break;
      case 138: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
#line 278 "sql.y"
{ yylhsminor.yy184 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
#line 5268 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 139: /* speed_opt ::= */
      case 322: /* bufsize_opt ::= */ yytestcase(yyruleno==322);
#line 282 "sql.y"
{ yymsp[1].minor.yy480 = 0; }
#line 5275 "sql.c"
        break;
      case 140: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 323: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==323);
#line 283 "sql.y"
{ yymsp[-1].minor.yy480 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
#line 5281 "sql.c"
        break;
      case 142: /* start_opt ::= START WITH NK_INTEGER */
      case 146: /* end_opt ::= END WITH NK_INTEGER */ yytestcase(yyruleno==146);
#line 286 "sql.y"
{ yymsp[-2].minor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
#line 5287 "sql.c"
        break;
      case 143: /* start_opt ::= START WITH NK_STRING */
      case 147: /* end_opt ::= END WITH NK_STRING */ yytestcase(yyruleno==147);
#line 287 "sql.y"
{ yymsp[-2].minor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
#line 5293 "sql.c"
        break;
      case 144: /* start_opt ::= START WITH TIMESTAMP NK_STRING */
      case 148: /* end_opt ::= END WITH TIMESTAMP NK_STRING */ yytestcase(yyruleno==148);
#line 288 "sql.y"
{ yymsp[-3].minor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
#line 5299 "sql.c"
        break;
      case 149: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 151: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==151);
#line 297 "sql.y"
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy829, yymsp[-5].minor.yy184, yymsp[-3].minor.yy532, yymsp[-1].minor.yy532, yymsp[0].minor.yy184); }
#line 5305 "sql.c"
        break;
      case 150: /* cmd ::= CREATE TABLE multi_create_clause */
#line 298 "sql.y"
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy532); }
#line 5310 "sql.c"
        break;
      case 152: /* cmd ::= DROP TABLE multi_drop_clause */
#line 301 "sql.y"
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy532); }
#line 5315 "sql.c"
        break;
      case 153: /* cmd ::= DROP STABLE exists_opt full_table_name */
#line 302 "sql.y"
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy829, yymsp[0].minor.yy184); }
#line 5320 "sql.c"
        break;
      case 154: /* cmd ::= ALTER TABLE alter_table_clause */
      case 357: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==357);
      case 358: /* cmd ::= insert_query */ yytestcase(yyruleno==358);
#line 304 "sql.y"
{ pCxt->pRootNode = yymsp[0].minor.yy184; }
#line 5327 "sql.c"
        break;
      case 155: /* cmd ::= ALTER STABLE alter_table_clause */
#line 305 "sql.y"
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy184); }
#line 5332 "sql.c"
        break;
      case 156: /* alter_table_clause ::= full_table_name alter_table_options */
#line 307 "sql.y"
{ yylhsminor.yy184 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy184, yymsp[0].minor.yy184); }
#line 5337 "sql.c"
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 157: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
#line 309 "sql.y"
{ yylhsminor.yy184 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy184, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy649, yymsp[0].minor.yy388); }
#line 5343 "sql.c"
  yymsp[-4].minor.yy184 = yylhsminor.yy184;
        break;
      case 158: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
#line 310 "sql.y"
{ yylhsminor.yy184 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy184, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy649); }
#line 5349 "sql.c"
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 159: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
#line 312 "sql.y"
{ yylhsminor.yy184 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy184, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy649, yymsp[0].minor.yy388); }
#line 5355 "sql.c"
  yymsp[-4].minor.yy184 = yylhsminor.yy184;
        break;
      case 160: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
#line 314 "sql.y"
{ yylhsminor.yy184 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy184, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy649, &yymsp[0].minor.yy649); }
#line 5361 "sql.c"
  yymsp[-4].minor.yy184 = yylhsminor.yy184;
        break;
      case 161: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
#line 316 "sql.y"
{ yylhsminor.yy184 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy184, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy649, yymsp[0].minor.yy388); }
#line 5367 "sql.c"
  yymsp[-4].minor.yy184 = yylhsminor.yy184;
        break;
      case 162: /* alter_table_clause ::= full_table_name DROP TAG column_name */
#line 317 "sql.y"
{ yylhsminor.yy184 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy184, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy649); }
#line 5373 "sql.c"
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 163: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
#line 319 "sql.y"
{ yylhsminor.yy184 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy184, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy649, yymsp[0].minor.yy388); }
#line 5379 "sql.c"
  yymsp[-4].minor.yy184 = yylhsminor.yy184;
        break;
      case 164: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
#line 321 "sql.y"
{ yylhsminor.yy184 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy184, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy649, &yymsp[0].minor.yy649); }
#line 5385 "sql.c"
  yymsp[-4].minor.yy184 = yylhsminor.yy184;
        break;
      case 165: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
#line 323 "sql.y"
{ yylhsminor.yy184 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy184, &yymsp[-2].minor.yy649, yymsp[0].minor.yy184); }
#line 5391 "sql.c"
  yymsp[-5].minor.yy184 = yylhsminor.yy184;
        break;
      case 167: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 458: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==458);
#line 328 "sql.y"
{ yylhsminor.yy532 = addNodeToList(pCxt, yymsp[-1].minor.yy532, yymsp[0].minor.yy184); }
#line 5398 "sql.c"
  yymsp[-1].minor.yy532 = yylhsminor.yy532;
        break;
      case 168: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
#line 332 "sql.y"
{ yylhsminor.yy184 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy829, yymsp[-8].minor.yy184, yymsp[-6].minor.yy184, yymsp[-5].minor.yy532, yymsp[-2].minor.yy532, yymsp[0].minor.yy184); }
#line 5404 "sql.c"
  yymsp[-9].minor.yy184 = yylhsminor.yy184;
        break;
      case 171: /* drop_table_clause ::= exists_opt full_table_name */
#line 339 "sql.y"
{ yylhsminor.yy184 = createDropTableClause(pCxt, yymsp[-1].minor.yy829, yymsp[0].minor.yy184); }
#line 5410 "sql.c"
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 172: /* specific_cols_opt ::= */
      case 202: /* tags_def_opt ::= */ yytestcase(yyruleno==202);
      case 274: /* tag_list_opt ::= */ yytestcase(yyruleno==274);
      case 330: /* col_list_opt ::= */ yytestcase(yyruleno==330);
      case 332: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==332);
      case 521: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==521);
      case 546: /* group_by_clause_opt ::= */ yytestcase(yyruleno==546);
      case 565: /* order_by_clause_opt ::= */ yytestcase(yyruleno==565);
#line 343 "sql.y"
{ yymsp[1].minor.yy532 = NULL; }
#line 5423 "sql.c"
        break;
      case 173: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 331: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==331);
#line 344 "sql.y"
{ yymsp[-2].minor.yy532 = yymsp[-1].minor.yy532; }
#line 5429 "sql.c"
        break;
      case 174: /* full_table_name ::= table_name */
#line 346 "sql.y"
{ yylhsminor.yy184 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy649, NULL); }
#line 5434 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 175: /* full_table_name ::= db_name NK_DOT table_name */
#line 347 "sql.y"
{ yylhsminor.yy184 = createRealTableNode(pCxt, &yymsp[-2].minor.yy649, &yymsp[0].minor.yy649, NULL); }
#line 5440 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 178: /* column_def ::= column_name type_name */
#line 354 "sql.y"
{ yylhsminor.yy184 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy649, yymsp[0].minor.yy388, NULL); }
#line 5446 "sql.c"
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 179: /* type_name ::= BOOL */
#line 359 "sql.y"
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_BOOL); }
#line 5452 "sql.c"
        break;
      case 180: /* type_name ::= TINYINT */
#line 360 "sql.y"
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_TINYINT); }
#line 5457 "sql.c"
        break;
      case 181: /* type_name ::= SMALLINT */
#line 361 "sql.y"
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
#line 5462 "sql.c"
        break;
      case 182: /* type_name ::= INT */
      case 183: /* type_name ::= INTEGER */ yytestcase(yyruleno==183);
#line 362 "sql.y"
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_INT); }
#line 5468 "sql.c"
        break;
      case 184: /* type_name ::= BIGINT */
#line 364 "sql.y"
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_BIGINT); }
#line 5473 "sql.c"
        break;
      case 185: /* type_name ::= FLOAT */
#line 365 "sql.y"
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_FLOAT); }
#line 5478 "sql.c"
        break;
      case 186: /* type_name ::= DOUBLE */
#line 366 "sql.y"
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
#line 5483 "sql.c"
        break;
      case 187: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
#line 367 "sql.y"
{ yymsp[-3].minor.yy388 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
#line 5488 "sql.c"
        break;
      case 188: /* type_name ::= TIMESTAMP */
#line 368 "sql.y"
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
#line 5493 "sql.c"
        break;
      case 189: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
#line 369 "sql.y"
{ yymsp[-3].minor.yy388 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
#line 5498 "sql.c"
        break;
      case 190: /* type_name ::= TINYINT UNSIGNED */
#line 370 "sql.y"
{ yymsp[-1].minor.yy388 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
#line 5503 "sql.c"
        break;
      case 191: /* type_name ::= SMALLINT UNSIGNED */
#line 371 "sql.y"
{ yymsp[-1].minor.yy388 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
#line 5508 "sql.c"
        break;
      case 192: /* type_name ::= INT UNSIGNED */
#line 372 "sql.y"
{ yymsp[-1].minor.yy388 = createDataType(TSDB_DATA_TYPE_UINT); }
#line 5513 "sql.c"
        break;
      case 193: /* type_name ::= BIGINT UNSIGNED */
#line 373 "sql.y"
{ yymsp[-1].minor.yy388 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
#line 5518 "sql.c"
        break;
      case 194: /* type_name ::= JSON */
#line 374 "sql.y"
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_JSON); }
#line 5523 "sql.c"
        break;
      case 195: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
#line 375 "sql.y"
{ yymsp[-3].minor.yy388 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
#line 5528 "sql.c"
        break;
      case 196: /* type_name ::= MEDIUMBLOB */
#line 376 "sql.y"
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
#line 5533 "sql.c"
        break;
      case 197: /* type_name ::= BLOB */
#line 377 "sql.y"
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_BLOB); }
#line 5538 "sql.c"
        break;
      case 198: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
#line 378 "sql.y"
{ yymsp[-3].minor.yy388 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
#line 5543 "sql.c"
        break;
      case 199: /* type_name ::= DECIMAL */
#line 379 "sql.y"
{ yymsp[0].minor.yy388 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
#line 5548 "sql.c"
        break;
      case 200: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
#line 380 "sql.y"
{ yymsp[-3].minor.yy388 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
#line 5553 "sql.c"
        break;
      case 201: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
#line 381 "sql.y"
{ yymsp[-5].minor.yy388 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
#line 5558 "sql.c"
        break;
      case 203: /* tags_def_opt ::= tags_def */
      case 333: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==333);
      case 450: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==450);
#line 386 "sql.y"
{ yylhsminor.yy532 = yymsp[0].minor.yy532; }
#line 5565 "sql.c"
  yymsp[0].minor.yy532 = yylhsminor.yy532;
        break;
      case 204: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 334: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==334);
#line 390 "sql.y"
{ yymsp[-3].minor.yy532 = yymsp[-1].minor.yy532; }
#line 5572 "sql.c"
        break;
      case 205: /* table_options ::= */
#line 392 "sql.y"
{ yymsp[1].minor.yy184 = createDefaultTableOptions(pCxt); }
#line 5577 "sql.c"
        break;
      case 206: /* table_options ::= table_options COMMENT NK_STRING */
#line 393 "sql.y"
{ yylhsminor.yy184 = setTableOption(pCxt, yymsp[-2].minor.yy184, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
#line 5582 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 207: /* table_options ::= table_options MAX_DELAY duration_list */
#line 394 "sql.y"
{ yylhsminor.yy184 = setTableOption(pCxt, yymsp[-2].minor.yy184, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy532); }
#line 5588 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 208: /* table_options ::= table_options WATERMARK duration_list */
#line 395 "sql.y"
{ yylhsminor.yy184 = setTableOption(pCxt, yymsp[-2].minor.yy184, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy532); }
#line 5594 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 209: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
#line 396 "sql.y"
{ yylhsminor.yy184 = setTableOption(pCxt, yymsp[-4].minor.yy184, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy532); }
#line 5600 "sql.c"
  yymsp[-4].minor.yy184 = yylhsminor.yy184;
        break;
      case 210: /* table_options ::= table_options TTL NK_INTEGER */
#line 397 "sql.y"
{ yylhsminor.yy184 = setTableOption(pCxt, yymsp[-2].minor.yy184, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
#line 5606 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 211: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
#line 398 "sql.y"
{ yylhsminor.yy184 = setTableOption(pCxt, yymsp[-4].minor.yy184, TABLE_OPTION_SMA, yymsp[-1].minor.yy532); }
#line 5612 "sql.c"
  yymsp[-4].minor.yy184 = yylhsminor.yy184;
        break;
      case 212: /* table_options ::= table_options DELETE_MARK duration_list */
#line 399 "sql.y"
{ yylhsminor.yy184 = setTableOption(pCxt, yymsp[-2].minor.yy184, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy532); }
#line 5618 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 213: /* alter_table_options ::= alter_table_option */
#line 401 "sql.y"
{ yylhsminor.yy184 = createAlterTableOptions(pCxt); yylhsminor.yy184 = setTableOption(pCxt, yylhsminor.yy184, yymsp[0].minor.yy361.type, &yymsp[0].minor.yy361.val); }
#line 5624 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 214: /* alter_table_options ::= alter_table_options alter_table_option */
#line 402 "sql.y"
{ yylhsminor.yy184 = setTableOption(pCxt, yymsp[-1].minor.yy184, yymsp[0].minor.yy361.type, &yymsp[0].minor.yy361.val); }
#line 5630 "sql.c"
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 215: /* alter_table_option ::= COMMENT NK_STRING */
#line 406 "sql.y"
{ yymsp[-1].minor.yy361.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
#line 5636 "sql.c"
        break;
      case 216: /* alter_table_option ::= TTL NK_INTEGER */
#line 407 "sql.y"
{ yymsp[-1].minor.yy361.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy361.val = yymsp[0].minor.yy0; }
#line 5641 "sql.c"
        break;
      case 217: /* duration_list ::= duration_literal */
      case 414: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==414);
#line 411 "sql.y"
{ yylhsminor.yy532 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy184)); }
#line 5647 "sql.c"
  yymsp[0].minor.yy532 = yylhsminor.yy532;
        break;
      case 218: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 415: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==415);
#line 412 "sql.y"
{ yylhsminor.yy532 = addNodeToList(pCxt, yymsp[-2].minor.yy532, releaseRawExprNode(pCxt, yymsp[0].minor.yy184)); }
#line 5654 "sql.c"
  yymsp[-2].minor.yy532 = yylhsminor.yy532;
        break;
      case 221: /* rollup_func_name ::= function_name */
#line 419 "sql.y"
{ yylhsminor.yy184 = createFunctionNode(pCxt, &yymsp[0].minor.yy649, NULL); }
#line 5660 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 222: /* rollup_func_name ::= FIRST */
      case 223: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==223);
      case 278: /* tag_item ::= QTAGS */ yytestcase(yyruleno==278);
#line 420 "sql.y"
{ yylhsminor.yy184 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
#line 5668 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 226: /* col_name ::= column_name */
      case 279: /* tag_item ::= column_name */ yytestcase(yyruleno==279);
#line 428 "sql.y"
{ yylhsminor.yy184 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy649); }
#line 5675 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 227: /* cmd ::= SHOW DNODES */
#line 431 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
#line 5681 "sql.c"
        break;
      case 228: /* cmd ::= SHOW USERS */
#line 432 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
#line 5686 "sql.c"
        break;
      case 229: /* cmd ::= SHOW USER PRIVILEGES */
#line 433 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
#line 5691 "sql.c"
        break;
      case 230: /* cmd ::= SHOW DATABASES */
#line 434 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
#line 5696 "sql.c"
        break;
      case 231: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
#line 435 "sql.y"
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy184, yymsp[0].minor.yy184, OP_TYPE_LIKE); }
#line 5701 "sql.c"
        break;
      case 232: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
#line 436 "sql.y"
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy184, yymsp[0].minor.yy184, OP_TYPE_LIKE); }
#line 5706 "sql.c"
        break;
      case 233: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
#line 437 "sql.y"
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy184, NULL, OP_TYPE_LIKE); }
#line 5711 "sql.c"
        break;
      case 234: /* cmd ::= SHOW MNODES */
#line 438 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
#line 5716 "sql.c"
        break;
      case 235: /* cmd ::= SHOW QNODES */
#line 440 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
#line 5721 "sql.c"
        break;
      case 236: /* cmd ::= SHOW FUNCTIONS */
#line 441 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
#line 5726 "sql.c"
        break;
      case 237: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
#line 442 "sql.y"
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy184, yymsp[-1].minor.yy184, OP_TYPE_EQUAL); }
#line 5731 "sql.c"
        break;
      case 238: /* cmd ::= SHOW STREAMS */
#line 443 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
#line 5736 "sql.c"
        break;
      case 239: /* cmd ::= SHOW ACCOUNTS */
#line 444 "sql.y"
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
#line 5741 "sql.c"
        break;
      case 240: /* cmd ::= SHOW APPS */
#line 445 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
#line 5746 "sql.c"
        break;
      case 241: /* cmd ::= SHOW CONNECTIONS */
#line 446 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
#line 5751 "sql.c"
        break;
      case 242: /* cmd ::= SHOW LICENCES */
      case 243: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==243);
#line 447 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
#line 5757 "sql.c"
        break;
      case 244: /* cmd ::= SHOW CREATE DATABASE db_name */
#line 449 "sql.y"
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy649); }
#line 5762 "sql.c"
        break;
      case 245: /* cmd ::= SHOW CREATE TABLE full_table_name */
#line 450 "sql.y"
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy184); }
#line 5767 "sql.c"
        break;
      case 246: /* cmd ::= SHOW CREATE STABLE full_table_name */
#line 451 "sql.y"
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy184); }
#line 5772 "sql.c"
        break;
      case 247: /* cmd ::= SHOW QUERIES */
#line 452 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
#line 5777 "sql.c"
        break;
      case 248: /* cmd ::= SHOW SCORES */
#line 453 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
#line 5782 "sql.c"
        break;
      case 249: /* cmd ::= SHOW TOPICS */
#line 454 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
#line 5787 "sql.c"
        break;
      case 250: /* cmd ::= SHOW VARIABLES */
      case 251: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==251);
#line 455 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
#line 5793 "sql.c"
        break;
      case 252: /* cmd ::= SHOW LOCAL VARIABLES */
#line 457 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
#line 5798 "sql.c"
        break;
      case 253: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
#line 458 "sql.y"
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy184); }
#line 5803 "sql.c"
        break;
      case 254: /* cmd ::= SHOW BNODES */
#line 459 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
#line 5808 "sql.c"
        break;
      case 255: /* cmd ::= SHOW SNODES */
#line 460 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
#line 5813 "sql.c"
        break;
      case 256: /* cmd ::= SHOW CLUSTER */
#line 461 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
#line 5818 "sql.c"
        break;
      case 257: /* cmd ::= SHOW TRANSACTIONS */
#line 462 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
#line 5823 "sql.c"
        break;
      case 258: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
#line 463 "sql.y"
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy184); }
#line 5828 "sql.c"
        break;
      case 259: /* cmd ::= SHOW CONSUMERS */
#line 464 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
#line 5833 "sql.c"
        break;
      case 260: /* cmd ::= SHOW SUBSCRIPTIONS */
#line 465 "sql.y"
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
#line 5838 "sql.c"
        break;
      case 261: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
#line 466 "sql.y"
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy184, yymsp[-1].minor.yy184, OP_TYPE_EQUAL); }
#line 5843 "sql.c"
        break;
      case 262: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
#line 467 "sql.y"
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy184, yymsp[0].minor.yy184, yymsp[-3].minor.yy532); }
#line 5848 "sql.c"
        break;
      case 263: /* cmd ::= SHOW VNODES NK_INTEGER */
#line 468 "sql.y"
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
#line 5853 "sql.c"
        break;
      case 264: /* cmd ::= SHOW VNODES NK_STRING */
#line 469 "sql.y"
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
#line 5858 "sql.c"
        break;
      case 265: /* cmd ::= SHOW db_name_cond_opt ALIVE */
#line 471 "sql.y"
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy184,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
#line 5863 "sql.c"
        break;
      case 266: /* cmd ::= SHOW CLUSTER ALIVE */
#line 472 "sql.y"
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
#line 5868 "sql.c"
        break;
      case 267: /* db_name_cond_opt ::= */
      case 272: /* from_db_opt ::= */ yytestcase(yyruleno==272);
#line 474 "sql.y"
{ yymsp[1].minor.yy184 = createDefaultDatabaseCondValue(pCxt); }
#line 5874 "sql.c"
        break;
      case 268: /* db_name_cond_opt ::= db_name NK_DOT */
#line 475 "sql.y"
{ yylhsminor.yy184 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy649); }
#line 5879 "sql.c"
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 270: /* like_pattern_opt ::= LIKE NK_STRING */
#line 478 "sql.y"
{ yymsp[-1].minor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
#line 5885 "sql.c"
        break;
      case 271: /* table_name_cond ::= table_name */
#line 480 "sql.y"
{ yylhsminor.yy184 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy649); }
#line 5890 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 273: /* from_db_opt ::= FROM db_name */
#line 483 "sql.y"
{ yymsp[-1].minor.yy184 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy649); }
#line 5896 "sql.c"
        break;
      case 277: /* tag_item ::= TBNAME */
#line 491 "sql.y"
{ yylhsminor.yy184 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
#line 5901 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 280: /* tag_item ::= column_name column_alias */
#line 494 "sql.y"
{ yylhsminor.yy184 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy649), &yymsp[0].minor.yy649); }
#line 5907 "sql.c"
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 281: /* tag_item ::= column_name AS column_alias */
#line 495 "sql.y"
{ yylhsminor.yy184 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy649), &yymsp[0].minor.yy649); }
#line 5913 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 282: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
#line 499 "sql.y"
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy829, yymsp[-3].minor.yy184, yymsp[-1].minor.yy184, NULL, yymsp[0].minor.yy184); }
#line 5919 "sql.c"
        break;
      case 283: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
#line 501 "sql.y"
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy829, yymsp[-5].minor.yy184, yymsp[-3].minor.yy184, yymsp[-1].minor.yy532, NULL); }
#line 5924 "sql.c"
        break;
      case 284: /* cmd ::= DROP INDEX exists_opt full_index_name */
#line 502 "sql.y"
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy829, yymsp[0].minor.yy184); }
#line 5929 "sql.c"
        break;
      case 285: /* full_index_name ::= index_name */
#line 504 "sql.y"
{ yylhsminor.yy184 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy649); }
#line 5934 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 286: /* full_index_name ::= db_name NK_DOT index_name */
#line 505 "sql.y"
{ yylhsminor.yy184 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy649, &yymsp[0].minor.yy649); }
#line 5940 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 287: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
#line 508 "sql.y"
{ yymsp[-9].minor.yy184 = createIndexOption(pCxt, yymsp[-7].minor.yy532, releaseRawExprNode(pCxt, yymsp[-3].minor.yy184), NULL, yymsp[-1].minor.yy184, yymsp[0].minor.yy184); }
#line 5946 "sql.c"
        break;
      case 288: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
#line 511 "sql.y"
{ yymsp[-11].minor.yy184 = createIndexOption(pCxt, yymsp[-9].minor.yy532, releaseRawExprNode(pCxt, yymsp[-5].minor.yy184), releaseRawExprNode(pCxt, yymsp[-3].minor.yy184), yymsp[-1].minor.yy184, yymsp[0].minor.yy184); }
#line 5951 "sql.c"
        break;
      case 291: /* func ::= sma_func_name NK_LP expression_list NK_RP */
#line 518 "sql.y"
{ yylhsminor.yy184 = createFunctionNode(pCxt, &yymsp[-3].minor.yy649, yymsp[-1].minor.yy532); }
#line 5956 "sql.c"
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 292: /* sma_func_name ::= function_name */
      case 501: /* alias_opt ::= table_alias */ yytestcase(yyruleno==501);
#line 522 "sql.y"
{ yylhsminor.yy649 = yymsp[0].minor.yy649; }
#line 5963 "sql.c"
  yymsp[0].minor.yy649 = yylhsminor.yy649;
        break;
      case 297: /* sma_stream_opt ::= */
      case 335: /* stream_options ::= */ yytestcase(yyruleno==335);
#line 528 "sql.y"
{ yymsp[1].minor.yy184 = createStreamOptions(pCxt); }
#line 5970 "sql.c"
        break;
      case 298: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
#line 529 "sql.y"
{ ((SStreamOptions*)yymsp[-2].minor.yy184)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy184); yylhsminor.yy184 = yymsp[-2].minor.yy184; }
#line 5975 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 299: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
#line 530 "sql.y"
{ ((SStreamOptions*)yymsp[-2].minor.yy184)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy184); yylhsminor.yy184 = yymsp[-2].minor.yy184; }
#line 5981 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 300: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
#line 531 "sql.y"
{ ((SStreamOptions*)yymsp[-2].minor.yy184)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy184); yylhsminor.yy184 = yymsp[-2].minor.yy184; }
#line 5987 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 301: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
#line 534 "sql.y"
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy829, &yymsp[-2].minor.yy649, yymsp[0].minor.yy184); }
#line 5993 "sql.c"
        break;
      case 302: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
#line 535 "sql.y"
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy829, &yymsp[-3].minor.yy649, &yymsp[0].minor.yy649, false); }
#line 5998 "sql.c"
        break;
      case 303: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
#line 537 "sql.y"
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy829, &yymsp[-5].minor.yy649, &yymsp[0].minor.yy649, true); }
#line 6003 "sql.c"
        break;
      case 304: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
#line 539 "sql.y"
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy829, &yymsp[-3].minor.yy649, yymsp[0].minor.yy184, false); }
#line 6008 "sql.c"
        break;
      case 305: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
#line 541 "sql.y"
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy829, &yymsp[-5].minor.yy649, yymsp[0].minor.yy184, true); }
#line 6013 "sql.c"
        break;
      case 306: /* cmd ::= DROP TOPIC exists_opt topic_name */
#line 542 "sql.y"
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy829, &yymsp[0].minor.yy649); }
#line 6018 "sql.c"
        break;
      case 307: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
#line 543 "sql.y"
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy829, &yymsp[-2].minor.yy649, &yymsp[0].minor.yy649); }
#line 6023 "sql.c"
        break;
      case 308: /* cmd ::= DESC full_table_name */
      case 309: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==309);
#line 546 "sql.y"
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy184); }
#line 6029 "sql.c"
        break;
      case 310: /* cmd ::= RESET QUERY CACHE */
#line 550 "sql.y"
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
#line 6034 "sql.c"
        break;
      case 311: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 312: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==312);
#line 553 "sql.y"
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy829, yymsp[-1].minor.yy184, yymsp[0].minor.yy184); }
#line 6040 "sql.c"
        break;
      case 315: /* explain_options ::= */
#line 561 "sql.y"
{ yymsp[1].minor.yy184 = createDefaultExplainOptions(pCxt); }
#line 6045 "sql.c"
        break;
      case 316: /* explain_options ::= explain_options VERBOSE NK_BOOL */
#line 562 "sql.y"
{ yylhsminor.yy184 = setExplainVerbose(pCxt, yymsp[-2].minor.yy184, &yymsp[0].minor.yy0); }
#line 6050 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 317: /* explain_options ::= explain_options RATIO NK_FLOAT */
#line 563 "sql.y"
{ yylhsminor.yy184 = setExplainRatio(pCxt, yymsp[-2].minor.yy184, &yymsp[0].minor.yy0); }
#line 6056 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 318: /* cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
#line 568 "sql.y"
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy829, yymsp[-9].minor.yy829, &yymsp[-6].minor.yy649, &yymsp[-4].minor.yy0, yymsp[-2].minor.yy388, yymsp[-1].minor.yy480, &yymsp[0].minor.yy649, yymsp[-10].minor.yy829); }
#line 6062 "sql.c"
        break;
      case 319: /* cmd ::= DROP FUNCTION exists_opt function_name */
#line 569 "sql.y"
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy829, &yymsp[0].minor.yy649); }
#line 6067 "sql.c"
        break;
      case 324: /* language_opt ::= */
#line 583 "sql.y"
{ yymsp[1].minor.yy649 = nil_token; }
#line 6072 "sql.c"
        break;
      case 325: /* language_opt ::= LANGUAGE NK_STRING */
#line 584 "sql.y"
{ yymsp[-1].minor.yy649 = yymsp[0].minor.yy0; }
#line 6077 "sql.c"
        break;
      case 328: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
#line 594 "sql.y"
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy829, &yymsp[-8].minor.yy649, yymsp[-5].minor.yy184, yymsp[-7].minor.yy184, yymsp[-3].minor.yy532, yymsp[-2].minor.yy184, yymsp[0].minor.yy184, yymsp[-4].minor.yy532); }
#line 6082 "sql.c"
        break;
      case 329: /* cmd ::= DROP STREAM exists_opt stream_name */
#line 595 "sql.y"
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy829, &yymsp[0].minor.yy649); }
#line 6087 "sql.c"
        break;
      case 336: /* stream_options ::= stream_options TRIGGER AT_ONCE */
      case 337: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */ yytestcase(yyruleno==337);
#line 609 "sql.y"
{ yylhsminor.yy184 = setStreamOptions(pCxt, yymsp[-2].minor.yy184, SOPT_TRIGGER_TYPE_SET, &yymsp[0].minor.yy0, NULL); }
#line 6093 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 338: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
#line 611 "sql.y"
{ yylhsminor.yy184 = setStreamOptions(pCxt, yymsp[-3].minor.yy184, SOPT_TRIGGER_TYPE_SET, &yymsp[-1].minor.yy0, releaseRawExprNode(pCxt, yymsp[0].minor.yy184)); }
#line 6099 "sql.c"
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 339: /* stream_options ::= stream_options WATERMARK duration_literal */
#line 612 "sql.y"
{ yylhsminor.yy184 = setStreamOptions(pCxt, yymsp[-2].minor.yy184, SOPT_WATERMARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy184)); }
#line 6105 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 340: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
#line 613 "sql.y"
{ yylhsminor.yy184 = setStreamOptions(pCxt, yymsp[-3].minor.yy184, SOPT_IGNORE_EXPIRED_SET, &yymsp[0].minor.yy0, NULL); }
#line 6111 "sql.c"
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 341: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
#line 614 "sql.y"
{ yylhsminor.yy184 = setStreamOptions(pCxt, yymsp[-2].minor.yy184, SOPT_FILL_HISTORY_SET, &yymsp[0].minor.yy0, NULL); }
#line 6117 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 342: /* stream_options ::= stream_options DELETE_MARK duration_literal */
#line 615 "sql.y"
{ yylhsminor.yy184 = setStreamOptions(pCxt, yymsp[-2].minor.yy184, SOPT_DELETE_MARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy184)); }
#line 6123 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 343: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
#line 616 "sql.y"
{ yylhsminor.yy184 = setStreamOptions(pCxt, yymsp[-3].minor.yy184, SOPT_IGNORE_UPDATE_SET, &yymsp[0].minor.yy0, NULL); }
#line 6129 "sql.c"
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 345: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 535: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==535);
      case 555: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==555);
#line 619 "sql.y"
{ yymsp[-3].minor.yy184 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy184); }
#line 6137 "sql.c"
        break;
      case 346: /* cmd ::= KILL CONNECTION NK_INTEGER */
#line 622 "sql.y"
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
#line 6142 "sql.c"
        break;
      case 347: /* cmd ::= KILL QUERY NK_STRING */
#line 623 "sql.y"
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
#line 6147 "sql.c"
        break;
      case 348: /* cmd ::= KILL TRANSACTION NK_INTEGER */
#line 624 "sql.y"
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
#line 6152 "sql.c"
        break;
      case 349: /* cmd ::= BALANCE VGROUP */
#line 627 "sql.y"
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
#line 6157 "sql.c"
        break;
      case 350: /* cmd ::= BALANCE VGROUP LEADER */
#line 628 "sql.y"
{ pCxt->pRootNode = createBalanceVgroupLeaderStmt(pCxt); }
#line 6162 "sql.c"
        break;
      case 351: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
#line 629 "sql.y"
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
#line 6167 "sql.c"
        break;
      case 352: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
#line 630 "sql.y"
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy532); }
#line 6172 "sql.c"
        break;
      case 353: /* cmd ::= SPLIT VGROUP NK_INTEGER */
#line 631 "sql.y"
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
#line 6177 "sql.c"
        break;
      case 354: /* dnode_list ::= DNODE NK_INTEGER */
#line 635 "sql.y"
{ yymsp[-1].minor.yy532 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
#line 6182 "sql.c"
        break;
      case 356: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
#line 642 "sql.y"
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy184, yymsp[0].minor.yy184); }
#line 6187 "sql.c"
        break;
      case 359: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
#line 651 "sql.y"
{ yymsp[-6].minor.yy184 = createInsertStmt(pCxt, yymsp[-4].minor.yy184, yymsp[-2].minor.yy532, yymsp[0].minor.yy184); }
#line 6192 "sql.c"
        break;
      case 360: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
#line 652 "sql.y"
{ yymsp[-3].minor.yy184 = createInsertStmt(pCxt, yymsp[-1].minor.yy184, NULL, yymsp[0].minor.yy184); }
#line 6197 "sql.c"
        break;
      case 361: /* literal ::= NK_INTEGER */
#line 655 "sql.y"
{ yylhsminor.yy184 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
#line 6202 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 362: /* literal ::= NK_FLOAT */
#line 656 "sql.y"
{ yylhsminor.yy184 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
#line 6208 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 363: /* literal ::= NK_STRING */
#line 657 "sql.y"
{ yylhsminor.yy184 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
#line 6214 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 364: /* literal ::= NK_BOOL */
#line 658 "sql.y"
{ yylhsminor.yy184 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
#line 6220 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 365: /* literal ::= TIMESTAMP NK_STRING */
#line 659 "sql.y"
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
#line 6226 "sql.c"
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 366: /* literal ::= duration_literal */
      case 376: /* signed_literal ::= signed */ yytestcase(yyruleno==376);
      case 397: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==397);
      case 398: /* expression ::= literal */ yytestcase(yyruleno==398);
      case 399: /* expression ::= pseudo_column */ yytestcase(yyruleno==399);
      case 400: /* expression ::= column_reference */ yytestcase(yyruleno==400);
      case 401: /* expression ::= function_expression */ yytestcase(yyruleno==401);
      case 402: /* expression ::= case_when_expression */ yytestcase(yyruleno==402);
      case 433: /* function_expression ::= literal_func */ yytestcase(yyruleno==433);
      case 482: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==482);
      case 486: /* boolean_primary ::= predicate */ yytestcase(yyruleno==486);
      case 488: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==488);
      case 489: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==489);
      case 492: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==492);
      case 494: /* table_reference ::= table_primary */ yytestcase(yyruleno==494);
      case 495: /* table_reference ::= joined_table */ yytestcase(yyruleno==495);
      case 499: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==499);
      case 557: /* query_simple ::= query_specification */ yytestcase(yyruleno==557);
      case 558: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==558);
      case 561: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==561);
      case 563: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==563);
#line 660 "sql.y"
{ yylhsminor.yy184 = yymsp[0].minor.yy184; }
#line 6252 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 367: /* literal ::= NULL */
#line 661 "sql.y"
{ yylhsminor.yy184 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
#line 6258 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 368: /* literal ::= NK_QUESTION */
#line 662 "sql.y"
{ yylhsminor.yy184 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
#line 6264 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 369: /* duration_literal ::= NK_VARIABLE */
#line 664 "sql.y"
{ yylhsminor.yy184 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
#line 6270 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 370: /* signed ::= NK_INTEGER */
#line 666 "sql.y"
{ yylhsminor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
#line 6276 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 371: /* signed ::= NK_PLUS NK_INTEGER */
#line 667 "sql.y"
{ yymsp[-1].minor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
#line 6282 "sql.c"
        break;
      case 372: /* signed ::= NK_MINUS NK_INTEGER */
#line 668 "sql.y"
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
#line 6291 "sql.c"
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 373: /* signed ::= NK_FLOAT */
#line 673 "sql.y"
{ yylhsminor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
#line 6297 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 374: /* signed ::= NK_PLUS NK_FLOAT */
#line 674 "sql.y"
{ yymsp[-1].minor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
#line 6303 "sql.c"
        break;
      case 375: /* signed ::= NK_MINUS NK_FLOAT */
#line 675 "sql.y"
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
#line 6312 "sql.c"
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 377: /* signed_literal ::= NK_STRING */
#line 682 "sql.y"
{ yylhsminor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
#line 6318 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 378: /* signed_literal ::= NK_BOOL */
#line 683 "sql.y"
{ yylhsminor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
#line 6324 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 379: /* signed_literal ::= TIMESTAMP NK_STRING */
#line 684 "sql.y"
{ yymsp[-1].minor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
#line 6330 "sql.c"
        break;
      case 380: /* signed_literal ::= duration_literal */
      case 382: /* signed_literal ::= literal_func */ yytestcase(yyruleno==382);
      case 453: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==453);
      case 515: /* select_item ::= common_expression */ yytestcase(yyruleno==515);
      case 525: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==525);
      case 562: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==562);
      case 564: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==564);
      case 577: /* search_condition ::= common_expression */ yytestcase(yyruleno==577);
#line 685 "sql.y"
{ yylhsminor.yy184 = releaseRawExprNode(pCxt, yymsp[0].minor.yy184); }
#line 6342 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 381: /* signed_literal ::= NULL */
#line 686 "sql.y"
{ yylhsminor.yy184 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
#line 6348 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 383: /* signed_literal ::= NK_QUESTION */
#line 688 "sql.y"
{ yylhsminor.yy184 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
#line 6354 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 403: /* expression ::= NK_LP expression NK_RP */
      case 487: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==487);
      case 576: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==576);
#line 749 "sql.y"
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy184)); }
#line 6362 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 404: /* expression ::= NK_PLUS expr_or_subquery */
#line 750 "sql.y"
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy184));
                                                                                  }
#line 6371 "sql.c"
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 405: /* expression ::= NK_MINUS expr_or_subquery */
#line 754 "sql.y"
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy184), NULL));
                                                                                  }
#line 6380 "sql.c"
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 406: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
#line 758 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184))); 
                                                                                  }
#line 6390 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 407: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
#line 763 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184))); 
                                                                                  }
#line 6400 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 408: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
#line 768 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184))); 
                                                                                  }
#line 6410 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 409: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
#line 773 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184))); 
                                                                                  }
#line 6420 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 410: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
#line 778 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184)));
                                                                                  }
#line 6430 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 411: /* expression ::= column_reference NK_ARROW NK_STRING */
#line 783 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
#line 6439 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 412: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
#line 787 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184)));
                                                                                  }
#line 6449 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 413: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
#line 792 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184)));
                                                                                  }
#line 6459 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 416: /* column_reference ::= column_name */
#line 803 "sql.y"
{ yylhsminor.yy184 = createRawExprNode(pCxt, &yymsp[0].minor.yy649, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy649)); }
#line 6465 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 417: /* column_reference ::= table_name NK_DOT column_name */
#line 804 "sql.y"
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy649, &yymsp[0].minor.yy649, createColumnNode(pCxt, &yymsp[-2].minor.yy649, &yymsp[0].minor.yy649)); }
#line 6471 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 418: /* pseudo_column ::= ROWTS */
      case 419: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==419);
      case 421: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==421);
      case 422: /* pseudo_column ::= QEND */ yytestcase(yyruleno==422);
      case 423: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==423);
      case 424: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==424);
      case 425: /* pseudo_column ::= WEND */ yytestcase(yyruleno==425);
      case 426: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==426);
      case 427: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==427);
      case 428: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==428);
      case 429: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==429);
      case 435: /* literal_func ::= NOW */ yytestcase(yyruleno==435);
#line 806 "sql.y"
{ yylhsminor.yy184 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
#line 6488 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 420: /* pseudo_column ::= table_name NK_DOT TBNAME */
#line 808 "sql.y"
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy649, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy649)))); }
#line 6494 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 430: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 431: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==431);
#line 819 "sql.y"
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy649, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy649, yymsp[-1].minor.yy532)); }
#line 6501 "sql.c"
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 432: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
#line 822 "sql.y"
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy184), yymsp[-1].minor.yy388)); }
#line 6507 "sql.c"
  yymsp[-5].minor.yy184 = yylhsminor.yy184;
        break;
      case 434: /* literal_func ::= noarg_func NK_LP NK_RP */
#line 825 "sql.y"
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy649, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy649, NULL)); }
#line 6513 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 449: /* star_func_para_list ::= NK_STAR */
#line 849 "sql.y"
{ yylhsminor.yy532 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
#line 6519 "sql.c"
  yymsp[0].minor.yy532 = yylhsminor.yy532;
        break;
      case 454: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 518: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==518);
#line 858 "sql.y"
{ yylhsminor.yy184 = createColumnNode(pCxt, &yymsp[-2].minor.yy649, &yymsp[0].minor.yy0); }
#line 6526 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 455: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
#line 861 "sql.y"
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy532, yymsp[-1].minor.yy184)); }
#line 6532 "sql.c"
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 456: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
#line 863 "sql.y"
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy184), yymsp[-2].minor.yy532, yymsp[-1].minor.yy184)); }
#line 6538 "sql.c"
  yymsp[-4].minor.yy184 = yylhsminor.yy184;
        break;
      case 459: /* when_then_expr ::= WHEN common_expression THEN common_expression */
#line 870 "sql.y"
{ yymsp[-3].minor.yy184 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184)); }
#line 6544 "sql.c"
        break;
      case 461: /* case_when_else_opt ::= ELSE common_expression */
#line 873 "sql.y"
{ yymsp[-1].minor.yy184 = releaseRawExprNode(pCxt, yymsp[0].minor.yy184); }
#line 6549 "sql.c"
        break;
      case 462: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 467: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==467);
#line 876 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy424, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184)));
                                                                                  }
#line 6559 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 463: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
#line 883 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy184), releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184)));
                                                                                  }
#line 6569 "sql.c"
  yymsp[-4].minor.yy184 = yylhsminor.yy184;
        break;
      case 464: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
#line 889 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy184), releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184)));
                                                                                  }
#line 6579 "sql.c"
  yymsp[-5].minor.yy184 = yylhsminor.yy184;
        break;
      case 465: /* predicate ::= expr_or_subquery IS NULL */
#line 894 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), NULL));
                                                                                  }
#line 6588 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 466: /* predicate ::= expr_or_subquery IS NOT NULL */
#line 898 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy184), NULL));
                                                                                  }
#line 6597 "sql.c"
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 468: /* compare_op ::= NK_LT */
#line 910 "sql.y"
{ yymsp[0].minor.yy424 = OP_TYPE_LOWER_THAN; }
#line 6603 "sql.c"
        break;
      case 469: /* compare_op ::= NK_GT */
#line 911 "sql.y"
{ yymsp[0].minor.yy424 = OP_TYPE_GREATER_THAN; }
#line 6608 "sql.c"
        break;
      case 470: /* compare_op ::= NK_LE */
#line 912 "sql.y"
{ yymsp[0].minor.yy424 = OP_TYPE_LOWER_EQUAL; }
#line 6613 "sql.c"
        break;
      case 471: /* compare_op ::= NK_GE */
#line 913 "sql.y"
{ yymsp[0].minor.yy424 = OP_TYPE_GREATER_EQUAL; }
#line 6618 "sql.c"
        break;
      case 472: /* compare_op ::= NK_NE */
#line 914 "sql.y"
{ yymsp[0].minor.yy424 = OP_TYPE_NOT_EQUAL; }
#line 6623 "sql.c"
        break;
      case 473: /* compare_op ::= NK_EQ */
#line 915 "sql.y"
{ yymsp[0].minor.yy424 = OP_TYPE_EQUAL; }
#line 6628 "sql.c"
        break;
      case 474: /* compare_op ::= LIKE */
#line 916 "sql.y"
{ yymsp[0].minor.yy424 = OP_TYPE_LIKE; }
#line 6633 "sql.c"
        break;
      case 475: /* compare_op ::= NOT LIKE */
#line 917 "sql.y"
{ yymsp[-1].minor.yy424 = OP_TYPE_NOT_LIKE; }
#line 6638 "sql.c"
        break;
      case 476: /* compare_op ::= MATCH */
#line 918 "sql.y"
{ yymsp[0].minor.yy424 = OP_TYPE_MATCH; }
#line 6643 "sql.c"
        break;
      case 477: /* compare_op ::= NMATCH */
#line 919 "sql.y"
{ yymsp[0].minor.yy424 = OP_TYPE_NMATCH; }
#line 6648 "sql.c"
        break;
      case 478: /* compare_op ::= CONTAINS */
#line 920 "sql.y"
{ yymsp[0].minor.yy424 = OP_TYPE_JSON_CONTAINS; }
#line 6653 "sql.c"
        break;
      case 479: /* in_op ::= IN */
#line 924 "sql.y"
{ yymsp[0].minor.yy424 = OP_TYPE_IN; }
#line 6658 "sql.c"
        break;
      case 480: /* in_op ::= NOT IN */
#line 925 "sql.y"
{ yymsp[-1].minor.yy424 = OP_TYPE_NOT_IN; }
#line 6663 "sql.c"
        break;
      case 481: /* in_predicate_value ::= NK_LP literal_list NK_RP */
#line 927 "sql.y"
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy532)); }
#line 6668 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 483: /* boolean_value_expression ::= NOT boolean_primary */
#line 931 "sql.y"
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy184), NULL));
                                                                                  }
#line 6677 "sql.c"
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 484: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
#line 936 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184)));
                                                                                  }
#line 6687 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 485: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
#line 942 "sql.y"
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy184);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy184);
                                                                                    yylhsminor.yy184 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), releaseRawExprNode(pCxt, yymsp[0].minor.yy184)));
                                                                                  }
#line 6697 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 493: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
#line 960 "sql.y"
{ yylhsminor.yy184 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy184, yymsp[0].minor.yy184, NULL); }
#line 6703 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 496: /* table_primary ::= table_name alias_opt */
#line 966 "sql.y"
{ yylhsminor.yy184 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy649, &yymsp[0].minor.yy649); }
#line 6709 "sql.c"
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 497: /* table_primary ::= db_name NK_DOT table_name alias_opt */
#line 967 "sql.y"
{ yylhsminor.yy184 = createRealTableNode(pCxt, &yymsp[-3].minor.yy649, &yymsp[-1].minor.yy649, &yymsp[0].minor.yy649); }
#line 6715 "sql.c"
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 498: /* table_primary ::= subquery alias_opt */
#line 968 "sql.y"
{ yylhsminor.yy184 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy184), &yymsp[0].minor.yy649); }
#line 6721 "sql.c"
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 500: /* alias_opt ::= */
#line 973 "sql.y"
{ yymsp[1].minor.yy649 = nil_token;  }
#line 6727 "sql.c"
        break;
      case 502: /* alias_opt ::= AS table_alias */
#line 975 "sql.y"
{ yymsp[-1].minor.yy649 = yymsp[0].minor.yy649; }
#line 6732 "sql.c"
        break;
      case 503: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 504: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==504);
#line 977 "sql.y"
{ yymsp[-2].minor.yy184 = yymsp[-1].minor.yy184; }
#line 6738 "sql.c"
        break;
      case 505: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
#line 982 "sql.y"
{ yylhsminor.yy184 = createJoinTableNode(pCxt, yymsp[-4].minor.yy416, yymsp[-5].minor.yy184, yymsp[-2].minor.yy184, yymsp[0].minor.yy184); }
#line 6743 "sql.c"
  yymsp[-5].minor.yy184 = yylhsminor.yy184;
        break;
      case 506: /* join_type ::= */
#line 986 "sql.y"
{ yymsp[1].minor.yy416 = JOIN_TYPE_INNER; }
#line 6749 "sql.c"
        break;
      case 507: /* join_type ::= INNER */
#line 987 "sql.y"
{ yymsp[0].minor.yy416 = JOIN_TYPE_INNER; }
#line 6754 "sql.c"
        break;
      case 508: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
#line 993 "sql.y"
{ 
                                                                                    yymsp[-11].minor.yy184 = createSelectStmt(pCxt, yymsp[-10].minor.yy829, yymsp[-9].minor.yy532, yymsp[-8].minor.yy184);
                                                                                    yymsp[-11].minor.yy184 = addWhereClause(pCxt, yymsp[-11].minor.yy184, yymsp[-7].minor.yy184);
                                                                                    yymsp[-11].minor.yy184 = addPartitionByClause(pCxt, yymsp[-11].minor.yy184, yymsp[-6].minor.yy532);
                                                                                    yymsp[-11].minor.yy184 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy184, yymsp[-2].minor.yy184);
                                                                                    yymsp[-11].minor.yy184 = addGroupByClause(pCxt, yymsp[-11].minor.yy184, yymsp[-1].minor.yy532);
                                                                                    yymsp[-11].minor.yy184 = addHavingClause(pCxt, yymsp[-11].minor.yy184, yymsp[0].minor.yy184);
                                                                                    yymsp[-11].minor.yy184 = addRangeClause(pCxt, yymsp[-11].minor.yy184, yymsp[-5].minor.yy184);
                                                                                    yymsp[-11].minor.yy184 = addEveryClause(pCxt, yymsp[-11].minor.yy184, yymsp[-4].minor.yy184);
                                                                                    yymsp[-11].minor.yy184 = addFillClause(pCxt, yymsp[-11].minor.yy184, yymsp[-3].minor.yy184);
                                                                                  }
#line 6769 "sql.c"
        break;
      case 511: /* set_quantifier_opt ::= ALL */
#line 1009 "sql.y"
{ yymsp[0].minor.yy829 = false; }
#line 6774 "sql.c"
        break;
      case 514: /* select_item ::= NK_STAR */
#line 1016 "sql.y"
{ yylhsminor.yy184 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
#line 6779 "sql.c"
  yymsp[0].minor.yy184 = yylhsminor.yy184;
        break;
      case 516: /* select_item ::= common_expression column_alias */
      case 526: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==526);
#line 1018 "sql.y"
{ yylhsminor.yy184 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy184), &yymsp[0].minor.yy649); }
#line 6786 "sql.c"
  yymsp[-1].minor.yy184 = yylhsminor.yy184;
        break;
      case 517: /* select_item ::= common_expression AS column_alias */
      case 527: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==527);
#line 1019 "sql.y"
{ yylhsminor.yy184 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), &yymsp[0].minor.yy649); }
#line 6793 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 522: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 547: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==547);
      case 566: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==566);
#line 1028 "sql.y"
{ yymsp[-2].minor.yy532 = yymsp[0].minor.yy532; }
#line 6801 "sql.c"
        break;
      case 529: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
#line 1041 "sql.y"
{ yymsp[-5].minor.yy184 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy184), releaseRawExprNode(pCxt, yymsp[-1].minor.yy184)); }
#line 6806 "sql.c"
        break;
      case 530: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
#line 1042 "sql.y"
{ yymsp[-3].minor.yy184 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy184)); }
#line 6811 "sql.c"
        break;
      case 531: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
#line 1044 "sql.y"
{ yymsp[-5].minor.yy184 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy184), NULL, yymsp[-1].minor.yy184, yymsp[0].minor.yy184); }
#line 6816 "sql.c"
        break;
      case 532: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
#line 1047 "sql.y"
{ yymsp[-7].minor.yy184 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy184), releaseRawExprNode(pCxt, yymsp[-3].minor.yy184), yymsp[-1].minor.yy184, yymsp[0].minor.yy184); }
#line 6821 "sql.c"
        break;
      case 533: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
#line 1049 "sql.y"
{ yymsp[-6].minor.yy184 = createEventWindowNode(pCxt, yymsp[-3].minor.yy184, yymsp[0].minor.yy184); }
#line 6826 "sql.c"
        break;
      case 537: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
#line 1055 "sql.y"
{ yymsp[-3].minor.yy184 = createFillNode(pCxt, yymsp[-1].minor.yy362, NULL); }
#line 6831 "sql.c"
        break;
      case 538: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
#line 1056 "sql.y"
{ yymsp[-5].minor.yy184 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy532)); }
#line 6836 "sql.c"
        break;
      case 539: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
#line 1057 "sql.y"
{ yymsp[-5].minor.yy184 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy532)); }
#line 6841 "sql.c"
        break;
      case 540: /* fill_mode ::= NONE */
#line 1061 "sql.y"
{ yymsp[0].minor.yy362 = FILL_MODE_NONE; }
#line 6846 "sql.c"
        break;
      case 541: /* fill_mode ::= PREV */
#line 1062 "sql.y"
{ yymsp[0].minor.yy362 = FILL_MODE_PREV; }
#line 6851 "sql.c"
        break;
      case 542: /* fill_mode ::= NULL */
#line 1063 "sql.y"
{ yymsp[0].minor.yy362 = FILL_MODE_NULL; }
#line 6856 "sql.c"
        break;
      case 543: /* fill_mode ::= NULL_F */
#line 1064 "sql.y"
{ yymsp[0].minor.yy362 = FILL_MODE_NULL_F; }
#line 6861 "sql.c"
        break;
      case 544: /* fill_mode ::= LINEAR */
#line 1065 "sql.y"
{ yymsp[0].minor.yy362 = FILL_MODE_LINEAR; }
#line 6866 "sql.c"
        break;
      case 545: /* fill_mode ::= NEXT */
#line 1066 "sql.y"
{ yymsp[0].minor.yy362 = FILL_MODE_NEXT; }
#line 6871 "sql.c"
        break;
      case 548: /* group_by_list ::= expr_or_subquery */
#line 1075 "sql.y"
{ yylhsminor.yy532 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy184))); }
#line 6876 "sql.c"
  yymsp[0].minor.yy532 = yylhsminor.yy532;
        break;
      case 549: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
#line 1076 "sql.y"
{ yylhsminor.yy532 = addNodeToList(pCxt, yymsp[-2].minor.yy532, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy184))); }
#line 6882 "sql.c"
  yymsp[-2].minor.yy532 = yylhsminor.yy532;
        break;
      case 553: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
#line 1083 "sql.y"
{ yymsp[-5].minor.yy184 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy184), releaseRawExprNode(pCxt, yymsp[-1].minor.yy184)); }
#line 6888 "sql.c"
        break;
      case 556: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
#line 1090 "sql.y"
{
                                                                                    yylhsminor.yy184 = addOrderByClause(pCxt, yymsp[-3].minor.yy184, yymsp[-2].minor.yy532);
                                                                                    yylhsminor.yy184 = addSlimitClause(pCxt, yylhsminor.yy184, yymsp[-1].minor.yy184);
                                                                                    yylhsminor.yy184 = addLimitClause(pCxt, yylhsminor.yy184, yymsp[0].minor.yy184);
                                                                                  }
#line 6897 "sql.c"
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 559: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
#line 1100 "sql.y"
{ yylhsminor.yy184 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy184, yymsp[0].minor.yy184); }
#line 6903 "sql.c"
  yymsp[-3].minor.yy184 = yylhsminor.yy184;
        break;
      case 560: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
#line 1102 "sql.y"
{ yylhsminor.yy184 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy184, yymsp[0].minor.yy184); }
#line 6909 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 568: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 572: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==572);
#line 1116 "sql.y"
{ yymsp[-1].minor.yy184 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
#line 6916 "sql.c"
        break;
      case 569: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 573: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==573);
#line 1117 "sql.y"
{ yymsp[-3].minor.yy184 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
#line 6922 "sql.c"
        break;
      case 570: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 574: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==574);
#line 1118 "sql.y"
{ yymsp[-3].minor.yy184 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
#line 6928 "sql.c"
        break;
      case 575: /* subquery ::= NK_LP query_expression NK_RP */
#line 1126 "sql.y"
{ yylhsminor.yy184 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy184); }
#line 6933 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 580: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
#line 1140 "sql.y"
{ yylhsminor.yy184 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy184), yymsp[-1].minor.yy706, yymsp[0].minor.yy617); }
#line 6939 "sql.c"
  yymsp[-2].minor.yy184 = yylhsminor.yy184;
        break;
      case 581: /* ordering_specification_opt ::= */
#line 1144 "sql.y"
{ yymsp[1].minor.yy706 = ORDER_ASC; }
#line 6945 "sql.c"
        break;
      case 582: /* ordering_specification_opt ::= ASC */
#line 1145 "sql.y"
{ yymsp[0].minor.yy706 = ORDER_ASC; }
#line 6950 "sql.c"
        break;
      case 583: /* ordering_specification_opt ::= DESC */
#line 1146 "sql.y"
{ yymsp[0].minor.yy706 = ORDER_DESC; }
#line 6955 "sql.c"
        break;
      case 584: /* null_ordering_opt ::= */
#line 1150 "sql.y"
{ yymsp[1].minor.yy617 = NULL_ORDER_DEFAULT; }
#line 6960 "sql.c"
        break;
      case 585: /* null_ordering_opt ::= NULLS FIRST */
#line 1151 "sql.y"
{ yymsp[-1].minor.yy617 = NULL_ORDER_FIRST; }
#line 6965 "sql.c"
        break;
      case 586: /* null_ordering_opt ::= NULLS LAST */
#line 1152 "sql.y"
{ yymsp[-1].minor.yy617 = NULL_ORDER_LAST; }
#line 6970 "sql.c"
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/
#line 29 "sql.y"

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
#line 7043 "sql.c"
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
