/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 461
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy32;
  SToken yy77;
  int32_t yy248;
  int8_t yy287;
  ENullOrder yy385;
  EJoinType yy560;
  SNode* yy600;
  SNodeList* yy601;
  SAlterOption yy661;
  EOperatorType yy666;
  int64_t yy717;
  EFillMode yy798;
  bool yy841;
  SDataType yy888;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             714
#define YYNRULE              543
#define YYNRULE_WITH_ACTION  543
#define YYNTOKEN             324
#define YY_MAX_SHIFT         713
#define YY_MIN_SHIFTREDUCE   1059
#define YY_MAX_SHIFTREDUCE   1601
#define YY_ERROR_ACTION      1602
#define YY_ACCEPT_ACTION     1603
#define YY_NO_ACTION         1604
#define YY_MIN_REDUCE        1605
#define YY_MAX_REDUCE        2147
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2622)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   461,  355,  462, 1641,  569,  603,  581, 2123, 2118,  156,
 /*    10 */  1947, 2118,   43,   41, 1530,   33,  276, 1747, 1760,  124,
 /*    20 */   363, 1943, 1380,  568,  174,  602,  500, 2122, 2119,  570,
 /*    30 */  1961, 2119, 2121, 1460, 1405, 1378, 1758,  132,  470,  408,
 /*    40 */   462, 1641,   36,   35, 1947,  589,   42,   40,   39,   38,
 /*    50 */    37, 1939, 1945,  345,  543, 1943,  168,  581, 1455,  467,
 /*    60 */   588, 1979,  613,   16,  368,  463, 1811, 1804, 1806,  584,
 /*    70 */  1386,  602, 1406,  331, 1929,  159,  619,  334, 1858,  320,
 /*    80 */  1712, 1979, 1809,   43,   41, 1939, 1945,  346,  132,  563,
 /*    90 */   479,  363,  477, 1380, 1867,   12,  613,  327,  173, 2056,
 /*   100 */  2057, 1960,  130, 2061, 1460, 1995, 1378, 1407,  101, 1962,
 /*   110 */   623, 1964, 1965,  618,  603,  613, 1111,  710, 1110,  564,
 /*   120 */   171,  460, 2048,  602,  465, 1647,  357, 2044,  124, 1455,
 /*   130 */   562,  211, 1462, 1463,   16,  505, 1805, 1806, 1489,  569,
 /*   140 */   176, 1386,  158, 2118, 1617, 1758,   46, 1112, 2074,  256,
 /*   150 */  2056,  580,  581,  125,  579, 1628, 1961, 2118,  568,  174,
 /*   160 */   603, 1436, 1445, 2119,  570,  581,   12,   42,   40,   39,
 /*   170 */    38,   37,  568,  174,   52, 1314, 1315, 2119,  570,   98,
 /*   180 */  1381,  589, 1379,  132, 1261, 1262,  469, 1979,  710,  465,
 /*   190 */  1647, 1758, 1736,  133, 1490,  617,  132, 1406,   46, 1929,
 /*   200 */  1929, 1750,  619, 1462, 1463, 1384, 1385,   63, 1435, 1438,
 /*   210 */  1439, 1440, 1441, 1442, 1443, 1444,  615,  611, 1453, 1454,
 /*   220 */  1456, 1457, 1458, 1459, 1461, 1464,    2, 1960,  598, 1405,
 /*   230 */  1867, 1995, 1436, 1445,  312, 1962,  623, 1964, 1965,  618,
 /*   240 */   616,  613,  604, 2013,  175, 2056, 2057, 1408,  130, 2061,
 /*   250 */   258, 1381, 2063, 1379,  479,  657,  583,  172, 2056, 2057,
 /*   260 */   559,  130, 2061, 1557,   59,   32,  361, 1484, 1485, 1486,
 /*   270 */  1487, 1488, 1492, 1493, 1494, 1495, 1384, 1385, 2060, 1435,
 /*   280 */  1438, 1439, 1440, 1441, 1442, 1443, 1444,  615,  611, 1453,
 /*   290 */  1454, 1456, 1457, 1458, 1459, 1461, 1464,    2,   59,    9,
 /*   300 */    43,   41, 1674,  228,   59, 1603, 1788,  590,  363, 1627,
 /*   310 */  1380,  556,  555, 1555, 1556, 1558, 1559, 1560, 1961,  354,
 /*   320 */    59, 1460, 1871, 1378, 1218,  645,  644,  643, 1222,  642,
 /*   330 */  1224, 1225,  641, 1227,  638, 2123, 1233,  635, 1235, 1236,
 /*   340 */   632,  629,   81,  565,  560,  259, 1455,  177,  401, 1979,
 /*   350 */   400,   16, 1407, 1929,  267,  268,  128,  620, 1386,  266,
 /*   360 */  1178,  170, 1929, 1626,  619, 1753,  397,  515,  514,  513,
 /*   370 */   378,   43,   41, 1465, 1798,  129,  509,  402, 1734,  363,
 /*   380 */   508, 1380,   59,   12,   86,  507,  512,  399,  395, 1960,
 /*   390 */   183,  506, 1460, 1995, 1378, 1180,  101, 1962,  623, 1964,
 /*   400 */  1965,  618, 1961,  613,  603,  710,  135, 1929,  142, 2019,
 /*   410 */  2048,  529,  548,  177,  357, 2044, 2118, 1455,  179,  548,
 /*   420 */  1462, 1463,   68, 2118,  527, 1111,  525, 1110, 1591, 1386,
 /*   430 */  1405, 2124,  174, 1979, 1606, 1758, 2119,  570, 2124,  174,
 /*   440 */   657,  620, 1625, 2119,  570, 1624, 1929,  177,  619, 1436,
 /*   450 */  1445,   11,   10,  177,   44,  114, 1112,  603,  113,  112,
 /*   460 */   111,  110,  109,  108,  107,  106,  105,   81, 1381,  177,
 /*   470 */  1379,  406,   76, 1960,  511,  510,  710, 1995,  681,  679,
 /*   480 */   161, 1962,  623, 1964, 1965,  618, 1929,  613, 1758, 1929,
 /*   490 */  1754, 1462, 1463, 1384, 1385,  258, 1435, 1438, 1439, 1440,
 /*   500 */  1441, 1442, 1443, 1444,  615,  611, 1453, 1454, 1456, 1457,
 /*   510 */  1458, 1459, 1461, 1464,    2, 1092,  515,  514,  513,   47,
 /*   520 */  1436, 1445,  603,  713,  129,  509, 1811,  186,  227,  508,
 /*   530 */   590,  177,  571, 2139,  507,  512,  407,  283, 1408, 1381,
 /*   540 */   506, 1379, 1810,   36,   35, 1872, 1503,   42,   40,   39,
 /*   550 */    38,   37,  167, 1758, 1094, 1408, 1097, 1098,  703,  699,
 /*   560 */   695,  691,  281,   78, 1384, 1385,   77, 1435, 1438, 1439,
 /*   570 */  1440, 1441, 1442, 1443, 1444,  615,  611, 1453, 1454, 1456,
 /*   580 */  1457, 1458, 1459, 1461, 1464,    2,   43,   41,  168,  603,
 /*   590 */   156, 1357, 1358,  444,  363, 1947, 1380, 1605,   99, 1761,
 /*   600 */     9,  274,    7,  416, 1961, 1623, 1943, 1460,  114, 1378,
 /*   610 */  1859,  113,  112,  111,  110,  109,  108,  107,  106,  105,
 /*   620 */  1758,  123,  122,  121,  120,  119,  118,  117,  116,  115,
 /*   630 */  1622,   92, 1455, 1621,  599, 1979, 1939, 1945,  358, 1811,
 /*   640 */   655, 1404, 1491,  584, 1386,  648,  356,  613, 1929, 1929,
 /*   650 */   619,  190,  189, 1751,  605, 1809, 2020,   43,   41,  147,
 /*   660 */   146,  652,  651,  650,  144,  363, 1961, 1380,  177,   44,
 /*   670 */  1534,  261,  587, 1620, 1929, 1960, 1405, 1929, 1460, 1995,
 /*   680 */  1378,  235,  101, 1962,  623, 1964, 1965,  618, 1351,  613,
 /*   690 */   230,  710, 1811, 2063,  171, 2063, 2048, 1979,  236,  367,
 /*   700 */   357, 2044,  607, 1455, 2020,  620, 1462, 1463, 1809,  226,
 /*   710 */  1929, 1619,  619,   30,  548, 1386,  576, 1929, 2118, 2059,
 /*   720 */     9, 2058, 2075, 1496,   36,   35, 1743, 1616,   42,   40,
 /*   730 */    39,   38,   37, 2124,  174, 1436, 1445, 1960, 2119,  570,
 /*   740 */    12, 1995,  366, 1386,  102, 1962,  623, 1964, 1965,  618,
 /*   750 */   156,  613, 1097, 1098, 1381, 1929, 1379,  145, 2048, 1760,
 /*   760 */    36,   35,  710, 2045,   42,   40,   39,   38,   37,   83,
 /*   770 */   322, 1929,  670,  533, 1728,  531, 1615, 1462, 1463, 1384,
 /*   780 */  1385,  669, 1435, 1438, 1439, 1440, 1441, 1442, 1443, 1444,
 /*   790 */   615,  611, 1453, 1454, 1456, 1457, 1458, 1459, 1461, 1464,
 /*   800 */     2,  319,  134, 1403, 2123, 2019, 1436, 1445, 2118,   51,
 /*   810 */   438,  649, 1568,  451, 1802, 1745,  450, 1437,  603,  212,
 /*   820 */  1929,  603,  369,    6, 2122, 1381, 1671, 1379, 2119, 2120,
 /*   830 */   156,  422,  430,  452,  163,  431,  424, 1614, 1527, 1760,
 /*   840 */   496,  492,  488,  484,  209,   39,   38,   37, 1546, 1758,
 /*   850 */  1384, 1385, 1758, 1435, 1438, 1439, 1440, 1441, 1442, 1443,
 /*   860 */  1444,  615,  611, 1453, 1454, 1456, 1457, 1458, 1459, 1461,
 /*   870 */  1464,    2, 2122, 1916, 1613, 1854, 1612,  335, 1470, 1854,
 /*   880 */    82, 1929, 1389,  207, 1405, 1854,  182, 1405, 1741,  412,
 /*   890 */   184,  687,  686,  685,  684,  373,  188,  683,  682,  136,
 /*   900 */   677,  676,  675,  674,  673,  672,  671,  149,  667,  666,
 /*   910 */   665,  372,  371,  662,  661,  660,  659,  658, 1929,  448,
 /*   920 */  1929,  385,  443,  442,  441,  440,  437,  436,  435,  434,
 /*   930 */   433,  429,  428,  427,  426,  336,  419,  418,  417,  577,
 /*   940 */   414,  413,  333,  157, 1611, 1610, 1609,  603,  296,  504,
 /*   950 */   206,  200,  376,  205, 1380, 1735,  475, 2068, 1523, 1661,
 /*   960 */  1961,  478,  294,   67, 1608,  603,   66, 1378,  520,   36,
 /*   970 */    35,  503,  198,   42,   40,   39,   38,   37, 1758, 1755,
 /*   980 */  1841,  516, 1749,  530,  194,  457,  455,  573, 1929, 1929,
 /*   990 */  1929, 1979,  409, 1943,  548,  603, 1758,  225, 2118,  620,
 /*  1000 */   653,  603, 1386, 1802, 1929,  410,  619,  654, 1929,  140,
 /*  1010 */  1802,   61,  523, 2124,  174,  544,   50,  517, 2119,  570,
 /*  1020 */    59,  547,  224, 1939, 1945, 1437, 1758, 1523, 1437, 1392,
 /*  1030 */   290, 1960, 1758, 1788,  613, 1995, 1948,  603,  101, 1962,
 /*  1040 */   623, 1964, 1965,  618,   48,  613,    3, 1943,   61,  710,
 /*  1050 */  2138,  585, 2048,  138,  231,  126,  357, 2044,   65,  100,
 /*  1060 */   603,   64,  655, 1554, 1961,   36,   35, 2082, 1758,   42,
 /*  1070 */    40,   39,   38,   37,  271,  603,  603, 1939, 1945, 1526,
 /*  1080 */   603,  147,  146,  652,  651,  650,  144, 1654,  613,  600,
 /*  1090 */   601, 1758,  614,  217,  277, 1979,  215,   75,   74,  405,
 /*  1100 */  1553,   25,  181,  620, 1388,  240, 1758, 1758, 1929,  518,
 /*  1110 */   619, 1758, 1381,  219, 1379,  221,  218,  647,  220, 1961,
 /*  1120 */   318,  610,  603,  393,   45,  391,  387,  383,  380,  377,
 /*  1130 */  1618,  425,  572, 1598,  234, 1960,  370, 1384, 1385, 1995,
 /*  1140 */  1652,  264,  101, 1962,  623, 1964, 1965,  618, 1713,  613,
 /*  1150 */  1979, 2088,  223, 1758, 2138,  222, 2048,  242,  620, 1950,
 /*  1160 */   357, 2044,  521, 1929, 1648,  619, 1600, 1601,  141,  177,
 /*  1170 */   143, 2112,  557,   84,   29,  210, 1327, 1140,  145, 1961,
 /*  1180 */    36,   35,  360,  359,   42,   40,   39,   38,   37,  253,
 /*  1190 */  1960,  247, 1394,  269, 1995,   11,   10,  101, 1962,  623,
 /*  1200 */  1964, 1965,  618, 1460,  613, 1387, 1980, 1952,  574, 2138,
 /*  1210 */  1979, 2048, 1141,  705,   97,  357, 2044,  374,  620, 1642,
 /*  1220 */   595, 1863,  273, 1929,   94,  619, 2067, 1799, 1455, 1597,
 /*  1230 */  1211,   31,   61,   45, 1961, 2078,  582,   36,   35,   45,
 /*  1240 */  1386,   42,   40,   39,   38,   37,  627,  143,  145,  127,
 /*  1250 */  1960, 1391,  143,  252, 1995, 1733,  255,  101, 1962,  623,
 /*  1260 */  1964, 1965,  618, 1481,  613, 1979,  663,    4,    1, 2023,
 /*  1270 */   379, 2048,  384,  620,  332,  357, 2044, 1344, 1929,  375,
 /*  1280 */   619,  187,  284,  411, 1497, 1446, 1408,  609, 1159,   36,
 /*  1290 */    35,  289, 1864,   42,   40,   39,   38,   37, 1239, 1243,
 /*  1300 */  1250, 1248,  536,  446,  148, 1960,  415,  420, 1403, 1995,
 /*  1310 */   432, 1856,  101, 1962,  623, 1964, 1965,  618,  439,  613,
 /*  1320 */   445,  548,  447,  453, 2021, 2118, 2048, 1961,   36,   35,
 /*  1330 */   357, 2044,   42,   40,   39,   38,   37, 1409,  664,  454,
 /*  1340 */  2124,  174,  191,  456,  548, 2119,  570,  458, 2118,  459,
 /*  1350 */  1395,  468, 1390, 1411,  197,  471,  472, 1410, 1979,  199,
 /*  1360 */  1157,  473,  655, 2124,  174, 1412,  620,  474, 2119,  570,
 /*  1370 */   202, 1929,  476,  619,  204, 1398, 1400,  480,   79,   80,
 /*  1380 */   208,  147,  146,  652,  651,  650,  144,  611, 1453, 1454,
 /*  1390 */  1456, 1457, 1458, 1459, 1114, 1961,  499,  497, 1960,  501,
 /*  1400 */   498, 1748, 1995,  214, 1744,  101, 1962,  623, 1964, 1965,
 /*  1410 */   618,  321,  613,  216,  150, 1906,  104,  606,  151, 2048,
 /*  1420 */  1905, 1746, 1742,  357, 2044, 1961, 1979,  535,  152,  153,
 /*  1430 */   229,  538,  537,  232,  620,  285,  545,  558,  542, 1929,
 /*  1440 */  2094,  619,  539,  593,  155,  552,  554, 2079,  246,  347,
 /*  1450 */  2093,    5,  553, 2089,  561, 1961, 1979,  567,  551,  238,
 /*  1460 */   164, 2070,  249,  241,  620,  550, 1960,  248,  250, 1929,
 /*  1470 */  1995,  619,  578,  102, 1962,  623, 1964, 1965,  618,  251,
 /*  1480 */   613,  348, 2117,  575, 2141,  254, 1979, 2048, 1523,  131,
 /*  1490 */  1407, 2047, 2044, 2064,  620,  586, 1960,  351,  260, 1929,
 /*  1500 */  1995,  619, 1413,  102, 1962,  623, 1964, 1965,  618, 1868,
 /*  1510 */   613, 1961,  591,  286,  596,  592, 1877, 2048, 1876, 1875,
 /*  1520 */   353,  608, 2044,  287, 1759,   89,  621, 1961,  288,  597,
 /*  1530 */  1995,   58,   91,  102, 1962,  623, 1964, 1965,  618, 2029,
 /*  1540 */   613,   93, 1979,  625, 1803,  291, 1729, 2048,  280,  706,
 /*  1550 */   620,  326, 2044,  707,  709, 1929,  323,  619, 1979,  339,
 /*  1560 */    49,  315,  324,  300, 1923,  314,  620,  304,  293,  295,
 /*  1570 */  1922, 1929,   72,  619, 1921, 1920,   73, 1917,  381,  382,
 /*  1580 */  1372, 1373, 1960,  180, 1915,  386, 1995,  388, 1961,  160,
 /*  1590 */  1962,  623, 1964, 1965,  618,  389,  613,  390, 1960, 1914,
 /*  1600 */   392, 1913, 1995,  394, 1961,  160, 1962,  623, 1964, 1965,
 /*  1610 */   618, 1912,  613,  396, 1911,  398, 1347, 1346, 1888, 1979,
 /*  1620 */   340, 1887,  338,  337,  403,  502,  404,  620, 1305,  504,
 /*  1630 */   549, 2085, 1929, 1886,  619, 1979, 1885, 1849, 1848, 1846,
 /*  1640 */   137, 1845, 1844,  620,  421,  185, 1837, 2086, 1929, 1847,
 /*  1650 */   619,  503, 1843, 1842, 1840, 1839, 1838,  423, 1836, 1960,
 /*  1660 */  1835, 1834, 1833, 1995, 1832, 1831,  306, 1962,  623, 1964,
 /*  1670 */  1965,  618, 1830,  613, 1829, 1960, 1828, 1827, 1961, 1995,
 /*  1680 */  1826, 1825,  161, 1962,  623, 1964, 1965,  618, 1824,  613,
 /*  1690 */  1823, 1822,  139, 1821, 1961, 1820, 1819, 1818, 1817, 1816,
 /*  1700 */  1307, 1815, 1814, 1813,  449, 1812, 1186, 1676, 1675, 1979,
 /*  1710 */   566, 1673, 1637,  169,  352,  192, 1636,  620,   70, 1901,
 /*  1720 */  1949,  193, 1929, 1100,  619, 1979,  195, 1099,   71,  464,
 /*  1730 */   466, 1895,  196,  617,  203, 2140, 1884, 1883, 1929,  201,
 /*  1740 */   619, 1866, 1737, 1672, 1670,  481, 1668, 1961, 1666, 1960,
 /*  1750 */  1133, 1664,  482, 1995,  483,  485,  313, 1962,  623, 1964,
 /*  1760 */  1965,  618,  486,  613,  487, 1960,  491, 1961,  489, 1995,
 /*  1770 */   490,  494,  312, 1962,  623, 1964, 1965,  618, 1979,  613,
 /*  1780 */   493, 2014, 1651,  362, 1650, 1633,  620, 1739,  495,   60,
 /*  1790 */  1255, 1929, 1254,  619, 1738, 1177,  213, 1176, 1979, 1175,
 /*  1800 */  1174,  678,  680,  364, 1171, 1169,  620, 1170, 1168, 1662,
 /*  1810 */   341, 1929, 1655,  619,  342, 1653,  519,  343, 1960, 1632,
 /*  1820 */  1961,  522, 1995, 1631,  524,  313, 1962,  623, 1964, 1965,
 /*  1830 */   618,  526,  613, 1630,  103,  528, 1961, 1362, 1960, 1361,
 /*  1840 */   532, 1900, 1995, 1364, 1894,  313, 1962,  623, 1964, 1965,
 /*  1850 */   618, 1979,  613, 1353,   24, 1882,  540, 1880,  154,  620,
 /*  1860 */    17, 2123,   26,   14, 1929,   56,  619, 1979,   57,   53,
 /*  1870 */  1570,  237,  244,  239, 1552,  620,  162,  245, 1950,   28,
 /*  1880 */  1929,   62,  619,   18,  541,  243,  546, 1545,   27,  233,
 /*  1890 */    19,  534,  344,   85, 1961, 1995, 1590, 1591,  308, 1962,
 /*  1900 */   623, 1964, 1965,  618, 1585,  613, 1584, 1960,  349, 1589,
 /*  1910 */  1961, 1995, 1588, 1520,  297, 1962,  623, 1964, 1965,  618,
 /*  1920 */   350,  613, 1519,  257,   55, 1979,  165, 1881, 1879, 1878,
 /*  1930 */   262,   20, 1865,  620,  263,   15, 1550,  265, 1929,   88,
 /*  1940 */   619, 1979,  270,   87,   90,  275,  594,   21,   94,  620,
 /*  1950 */    10, 1998, 1396,  166, 1929, 1961,  619, 1472, 1482, 1471,
 /*  1960 */  1450,  272,  612,   34,    8, 1960, 1448,   13,   54, 1995,
 /*  1970 */    22, 1961,  298, 1962,  623, 1964, 1965,  618, 1447,  613,
 /*  1980 */   178, 1960, 1420, 1428,   23, 1995, 1979,  624,  299, 1962,
 /*  1990 */   623, 1964, 1965,  618,  620,  613, 1217, 1240,  626, 1929,
 /*  2000 */   365,  619, 1979,  628,  630, 1237,  622,  631,  633, 1234,
 /*  2010 */   620,  634,  636, 1228,  637, 1929, 1226,  619,  639,  640,
 /*  2020 */    95, 1232,  646, 1231, 1230,  278, 1960, 1249, 1245, 1229,
 /*  2030 */  1995,   96,   69,  305, 1962,  623, 1964, 1965,  618, 1131,
 /*  2040 */   613,  656, 1960, 1165, 1164, 1961, 1995, 1163, 1162,  309,
 /*  2050 */  1962,  623, 1964, 1965,  618, 1161,  613, 1160, 1158, 1156,
 /*  2060 */  1155, 1961, 1154, 1184, 1152,  279, 1151, 1150,  668, 1149,
 /*  2070 */  1148, 1147, 1146, 1181, 1179, 1143, 1979, 1142, 1139, 1138,
 /*  2080 */  1137, 1136, 1669,  688,  620, 1667,  689,  692,  690, 1929,
 /*  2090 */   694,  619, 1979,  693, 1665,  696,  698, 1663,  697,  700,
 /*  2100 */   620,  701,  702, 1649,  704, 1929, 1961,  619, 1089, 1629,
 /*  2110 */   282, 1382,  708,  712,  292, 1604, 1960,  711, 1604, 1604,
 /*  2120 */  1995, 1604, 1604,  301, 1962,  623, 1964, 1965,  618, 1604,
 /*  2130 */   613, 1604, 1960, 1604, 1961, 1604, 1995, 1979, 1604,  310,
 /*  2140 */  1962,  623, 1964, 1965,  618,  620,  613, 1604, 1604, 1604,
 /*  2150 */  1929, 1604,  619, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*  2160 */  1604, 1604, 1604, 1604, 1961, 1979, 1604, 1604, 1604, 1604,
 /*  2170 */  1604, 1604, 1604,  620, 1604, 1604, 1604, 1960, 1929, 1604,
 /*  2180 */   619, 1995, 1604, 1604,  302, 1962,  623, 1964, 1965,  618,
 /*  2190 */  1604,  613, 1961, 1604, 1604, 1979, 1604, 1604, 1604, 1604,
 /*  2200 */  1604, 1604, 1604,  620, 1604, 1960, 1604, 1604, 1929, 1995,
 /*  2210 */   619, 1604,  311, 1962,  623, 1964, 1965,  618, 1604,  613,
 /*  2220 */  1604, 1604, 1961, 1979, 1604, 1604, 1604, 1604, 1604, 1604,
 /*  2230 */  1604,  620, 1604, 1604, 1604, 1960, 1929, 1604,  619, 1995,
 /*  2240 */  1604, 1604,  303, 1962,  623, 1964, 1965,  618, 1604,  613,
 /*  2250 */  1604, 1604, 1604, 1979, 1604, 1604, 1604, 1604, 1604, 1604,
 /*  2260 */  1604,  620, 1604, 1960, 1604, 1604, 1929, 1995,  619, 1604,
 /*  2270 */   316, 1962,  623, 1964, 1965,  618, 1604,  613, 1604, 1604,
 /*  2280 */  1604, 1604, 1961, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*  2290 */  1604, 1604, 1604, 1960, 1604, 1604, 1604, 1995, 1604, 1961,
 /*  2300 */   317, 1962,  623, 1964, 1965,  618, 1604,  613, 1604, 1604,
 /*  2310 */  1604, 1604, 1604, 1979, 1604, 1604, 1604, 1604, 1604, 1604,
 /*  2320 */  1604,  620, 1604, 1604, 1604, 1604, 1929, 1961,  619, 1604,
 /*  2330 */  1979, 1604, 1604, 1604, 1604, 1604, 1604, 1604,  620, 1604,
 /*  2340 */  1604, 1604, 1604, 1929, 1604,  619, 1604, 1604, 1604, 1604,
 /*  2350 */  1604, 1604, 1604, 1960, 1604, 1604, 1604, 1995, 1979, 1604,
 /*  2360 */  1973, 1962,  623, 1964, 1965,  618,  620,  613, 1604, 1604,
 /*  2370 */  1960, 1929, 1604,  619, 1995, 1604, 1604, 1972, 1962,  623,
 /*  2380 */  1964, 1965,  618, 1604,  613, 1604, 1604, 1604, 1604, 1961,
 /*  2390 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1960, 1604,
 /*  2400 */  1604, 1604, 1995, 1604, 1604, 1971, 1962,  623, 1964, 1965,
 /*  2410 */   618, 1604,  613, 1604, 1604, 1604, 1604, 1961, 1604, 1604,
 /*  2420 */  1979, 1604, 1604, 1604, 1604, 1604, 1604, 1604,  620, 1604,
 /*  2430 */  1604, 1604, 1604, 1929, 1961,  619, 1604, 1604, 1604, 1604,
 /*  2440 */  1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1979, 1604,
 /*  2450 */  1604, 1604, 1604, 1604, 1604, 1604,  620, 1604, 1604, 1604,
 /*  2460 */  1960, 1929, 1961,  619, 1995, 1979, 1604,  328, 1962,  623,
 /*  2470 */  1964, 1965,  618,  620,  613, 1604, 1604, 1604, 1929, 1604,
 /*  2480 */   619, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1960, 1604,
 /*  2490 */  1604, 1604, 1995, 1979, 1604,  329, 1962,  623, 1964, 1965,
 /*  2500 */   618,  620,  613, 1604, 1604, 1960, 1929, 1604,  619, 1995,
 /*  2510 */  1604, 1604,  325, 1962,  623, 1964, 1965,  618, 1604,  613,
 /*  2520 */  1961, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*  2530 */  1604, 1604, 1604, 1960, 1604, 1604, 1961, 1995, 1604, 1604,
 /*  2540 */   330, 1962,  623, 1964, 1965,  618, 1604,  613, 1604, 1604,
 /*  2550 */  1604, 1979, 1604, 1604, 1604, 1604, 1604, 1604, 1604,  620,
 /*  2560 */  1604, 1604, 1604, 1604, 1929, 1604,  619, 1979, 1604, 1604,
 /*  2570 */  1604, 1604, 1604, 1604, 1604,  620, 1604, 1604, 1604, 1604,
 /*  2580 */  1929, 1604,  619, 1604, 1604, 1604, 1604, 1604, 1604, 1604,
 /*  2590 */  1604,  621, 1604, 1604, 1604, 1995, 1604, 1604,  308, 1962,
 /*  2600 */   623, 1964, 1965,  618, 1604,  613, 1604, 1960, 1604, 1604,
 /*  2610 */  1604, 1995, 1604, 1604,  307, 1962,  623, 1964, 1965,  618,
 /*  2620 */  1604,  613,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   331,  350,  333,  334,  431,  335,  335,  431,  435,  358,
 /*    10 */   360,  435,   12,   13,   14,  420,  421,  359,  367,  349,
 /*    20 */    20,  371,   22,  450,  451,   20,  356,  451,  455,  456,
 /*    30 */   327,  455,  456,   33,   20,   35,  366,  366,  331,  335,
 /*    40 */   333,  334,    8,    9,  360,  335,   12,   13,   14,   15,
 /*    50 */    16,  401,  402,  403,  393,  371,  358,  335,   58,   14,
 /*    60 */    20,  358,  412,   63,  369,   20,  358,  372,  373,  366,
 /*    70 */    70,   20,   20,  365,  371,  342,  373,  379,  380,  375,
 /*    80 */   347,  358,  374,   12,   13,  401,  402,  403,  366,  366,
 /*    90 */    62,   20,  382,   22,  384,   95,  412,   63,  427,  428,
 /*   100 */   429,  398,  431,  432,   33,  402,   35,   20,  405,  406,
 /*   110 */   407,  408,  409,  410,  335,  412,   20,  117,   22,   20,
 /*   120 */   417,  332,  419,   20,  335,  336,  423,  424,  349,   58,
 /*   130 */   407,   35,  132,  133,   63,  356,  372,  373,  104,  431,
 /*   140 */   437,   70,  326,  435,  328,  366,   95,   51,  445,  427,
 /*   150 */   428,  429,  335,  431,  432,  327,  327,  435,  450,  451,
 /*   160 */   335,  161,  162,  455,  456,  335,   95,   12,   13,   14,
 /*   170 */    15,   16,  450,  451,  349,  161,  162,  455,  456,  339,
 /*   180 */   180,  335,  182,  366,  132,  133,  332,  358,  117,  335,
 /*   190 */   336,  366,    0,  353,  160,  366,  366,   20,   95,  371,
 /*   200 */   371,  361,  373,  132,  133,  205,  206,    4,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  398,  382,   20,
 /*   230 */   384,  402,  161,  162,  405,  406,  407,  408,  409,  410,
 /*   240 */   411,  412,  413,  414,  427,  428,  429,   20,  431,  432,
 /*   250 */   163,  180,  404,  182,   62,   62,  426,  427,  428,  429,
 /*   260 */   166,  431,  432,  205,   95,  231,  232,  233,  234,  235,
 /*   270 */   236,  237,  238,  239,  240,  241,  205,  206,  430,  208,
 /*   280 */   209,  210,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   290 */   219,  220,  221,  222,  223,  224,  225,  226,   95,  228,
 /*   300 */    12,   13,    0,  351,   95,  324,  354,  373,   20,  327,
 /*   310 */    22,  253,  254,  255,  256,  257,  258,  259,  327,  385,
 /*   320 */    95,   33,  388,   35,  108,  109,  110,  111,  112,  113,
 /*   330 */   114,  115,  116,  117,  118,    3,  120,  121,  122,  123,
 /*   340 */   124,  125,  341,  249,  250,   58,   58,  244,  179,  358,
 /*   350 */   181,   63,   20,  371,  126,  127,  355,  366,   70,  131,
 /*   360 */    35,  357,  371,  327,  373,  364,  175,   65,   66,   67,
 /*   370 */   389,   12,   13,   14,  370,   73,   74,  389,    0,   20,
 /*   380 */    78,   22,   95,   95,   97,   83,   84,  196,  197,  398,
 /*   390 */   163,   89,   33,  402,   35,   70,  405,  406,  407,  408,
 /*   400 */   409,  410,  327,  412,  335,  117,  415,  371,  417,  418,
 /*   410 */   419,   21,  431,  244,  423,  424,  435,   58,  349,  431,
 /*   420 */   132,  133,  106,  435,   34,   20,   36,   22,   96,   70,
 /*   430 */    20,  450,  451,  358,    0,  366,  455,  456,  450,  451,
 /*   440 */    62,  366,  327,  455,  456,  327,  371,  244,  373,  161,
 /*   450 */   162,    1,    2,  244,   95,   21,   51,  335,   24,   25,
 /*   460 */    26,   27,   28,   29,   30,   31,   32,  341,  180,  244,
 /*   470 */   182,  349,  156,  398,  344,  345,  117,  402,  344,  345,
 /*   480 */   405,  406,  407,  408,  409,  410,  371,  412,  366,  371,
 /*   490 */   364,  132,  133,  205,  206,  163,  208,  209,  210,  211,
 /*   500 */   212,  213,  214,  215,  216,  217,  218,  219,  220,  221,
 /*   510 */   222,  223,  224,  225,  226,    4,   65,   66,   67,   95,
 /*   520 */   161,  162,  335,   19,   73,   74,  358,   58,  126,   78,
 /*   530 */   373,  244,  457,  458,   83,   84,  349,   33,   20,  180,
 /*   540 */    89,  182,  374,    8,    9,  388,   96,   12,   13,   14,
 /*   550 */    15,   16,   48,  366,   43,   20,   45,   46,   54,   55,
 /*   560 */    56,   57,   58,   94,  205,  206,   97,  208,  209,  210,
 /*   570 */   211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
 /*   580 */   221,  222,  223,  224,  225,  226,   12,   13,  358,  335,
 /*   590 */   358,  189,  190,   79,   20,  360,   22,    0,   94,  367,
 /*   600 */   228,   97,  230,  349,  327,  327,  371,   33,   21,   35,
 /*   610 */   380,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   620 */   366,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   630 */   327,  339,   58,  327,  130,  358,  401,  402,  403,  358,
 /*   640 */   107,   20,  160,  366,   70,  106,  365,  412,  371,  371,
 /*   650 */   373,  137,  138,  361,  416,  374,  418,   12,   13,  126,
 /*   660 */   127,  128,  129,  130,  131,   20,  327,   22,  244,   95,
 /*   670 */    14,  167,  389,  327,  371,  398,   20,  371,   33,  402,
 /*   680 */    35,  163,  405,  406,  407,  408,  409,  410,  184,  412,
 /*   690 */   186,  117,  358,  404,  417,  404,  419,  358,  163,  365,
 /*   700 */   423,  424,  416,   58,  418,  366,  132,  133,  374,  127,
 /*   710 */   371,  327,  373,  231,  431,   70,   44,  371,  435,  430,
 /*   720 */   228,  430,  445,  241,    8,    9,  359,  327,   12,   13,
 /*   730 */    14,   15,   16,  450,  451,  161,  162,  398,  455,  456,
 /*   740 */    95,  402,  350,   70,  405,  406,  407,  408,  409,  410,
 /*   750 */   358,  412,   45,   46,  180,  371,  182,   44,  419,  367,
 /*   760 */     8,    9,  117,  424,   12,   13,   14,   15,   16,  187,
 /*   770 */   188,  371,  346,  191,  348,  193,  327,  132,  133,  205,
 /*   780 */   206,   70,  208,  209,  210,  211,  212,  213,  214,  215,
 /*   790 */   216,  217,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   800 */   226,   18,  415,   20,  431,  418,  161,  162,  435,   96,
 /*   810 */    27,  368,   96,   30,  371,  359,   33,  161,  335,   33,
 /*   820 */   371,  335,  350,   39,  451,  180,    0,  182,  455,  456,
 /*   830 */   358,   48,  349,   50,   48,  349,   53,  327,    4,  367,
 /*   840 */    54,   55,   56,   57,   58,   14,   15,   16,   96,  366,
 /*   850 */   205,  206,  366,  208,  209,  210,  211,  212,  213,  214,
 /*   860 */   215,  216,  217,  218,  219,  220,  221,  222,  223,  224,
 /*   870 */   225,  226,    3,    0,  327,  366,  327,   94,   14,  366,
 /*   880 */    94,  371,   35,   97,   20,  366,  377,   20,  359,  106,
 /*   890 */   377,   65,   66,   67,   68,   69,  377,   71,   72,   73,
 /*   900 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   910 */    84,   85,   86,   87,   88,   89,   90,   91,  371,  136,
 /*   920 */   371,   48,  139,  140,  141,  142,  143,  144,  145,  146,
 /*   930 */   147,  148,  149,  150,  151,  152,  153,  154,  155,  267,
 /*   940 */   157,  158,  159,   18,  327,  327,  327,  335,   23,  107,
 /*   950 */   164,  165,  389,  167,   22,    0,  170,  242,  243,    0,
 /*   960 */   327,  349,   37,   38,  327,  335,   41,   35,    4,    8,
 /*   970 */     9,  129,  186,   12,   13,   14,   15,   16,  366,  349,
 /*   980 */     0,   22,  360,   19,   59,   60,   61,   44,  371,  371,
 /*   990 */   371,  358,   22,  371,  431,  335,  366,   33,  435,  366,
 /*  1000 */   368,  335,   70,  371,  371,   35,  373,  368,  371,  349,
 /*  1010 */   371,   44,   48,  450,  451,  349,  163,   53,  455,  456,
 /*  1020 */    95,  168,   58,  401,  402,  161,  366,  243,  161,  182,
 /*  1030 */   351,  398,  366,  354,  412,  402,  360,  335,  405,  406,
 /*  1040 */   407,  408,  409,  410,   42,  412,   44,  371,   44,  117,
 /*  1050 */   417,  349,  419,   42,  359,   44,  423,  424,   94,  134,
 /*  1060 */   335,   97,  107,   96,  327,    8,    9,  434,  366,   12,
 /*  1070 */    13,   14,   15,   16,  349,  335,  335,  401,  402,  245,
 /*  1080 */   335,  126,  127,  128,  129,  130,  131,    0,  412,  349,
 /*  1090 */   349,  366,  359,   99,  349,  358,  102,  172,  173,  174,
 /*  1100 */    96,   44,  177,  366,   35,   44,  366,  366,  371,   22,
 /*  1110 */   373,  366,  180,   99,  182,   99,  102,  359,  102,  327,
 /*  1120 */   195,   63,  335,  198,   44,  200,  201,  202,  203,  204,
 /*  1130 */   328,  151,  263,  172,   58,  398,  349,  205,  206,  402,
 /*  1140 */     0,   44,  405,  406,  407,  408,  409,  410,  347,  412,
 /*  1150 */   358,  381,   99,  366,  417,  102,  419,   96,  366,   47,
 /*  1160 */   423,  424,   22,  371,    0,  373,  132,  133,   44,  244,
 /*  1170 */    44,  434,  448,   97,    2,  337,   96,   35,   44,  327,
 /*  1180 */     8,    9,   12,   13,   12,   13,   14,   15,   16,  459,
 /*  1190 */   398,  442,   22,   96,  402,    1,    2,  405,  406,  407,
 /*  1200 */   408,  409,  410,   33,  412,   35,  358,   95,  265,  417,
 /*  1210 */   358,  419,   70,   49,   95,  423,  424,  337,  366,  334,
 /*  1220 */    96,  381,   96,  371,  105,  373,  434,  370,   58,  268,
 /*  1230 */    96,    2,   44,   44,  327,  381,  433,    8,    9,   44,
 /*  1240 */    70,   12,   13,   14,   15,   16,   44,   44,   44,   44,
 /*  1250 */   398,  182,   44,  425,  402,    0,  452,  405,  406,  407,
 /*  1260 */   408,  409,  410,  205,  412,  358,   13,  246,  436,  417,
 /*  1270 */   400,  419,   48,  366,  399,  423,  424,  178,  371,  389,
 /*  1280 */   373,   42,  391,  378,   96,   96,   20,  117,   35,    8,
 /*  1290 */     9,   96,  381,   12,   13,   14,   15,   16,   96,   96,
 /*  1300 */    96,   96,  389,  160,   96,  398,  378,  376,   20,  402,
 /*  1310 */   335,  335,  405,  406,  407,  408,  409,  410,  378,  412,
 /*  1320 */   376,  431,  376,   93,  417,  435,  419,  327,    8,    9,
 /*  1330 */   423,  424,   12,   13,   14,   15,   16,   20,   13,  343,
 /*  1340 */   450,  451,  335,  335,  431,  455,  456,  335,  435,  329,
 /*  1350 */   180,  329,  182,   20,  341,  395,  373,   20,  358,  341,
 /*  1360 */    35,  336,  107,  450,  451,   20,  366,  390,  455,  456,
 /*  1370 */   341,  371,  336,  373,  341,  205,  206,  335,  341,  341,
 /*  1380 */   341,  126,  127,  128,  129,  130,  131,  217,  218,  219,
 /*  1390 */   220,  221,  222,  223,   52,  327,  329,  338,  398,  358,
 /*  1400 */   338,  358,  402,  358,  358,  405,  406,  407,  408,  409,
 /*  1410 */   410,  329,  412,  358,  358,  371,  335,  417,  358,  419,
 /*  1420 */   371,  358,  358,  423,  424,  327,  358,  194,  358,  358,
 /*  1430 */   339,  185,  397,  339,  366,  395,  335,  252,  373,  371,
 /*  1440 */   441,  373,  394,  251,  163,  371,  371,  381,  443,  371,
 /*  1450 */   441,  260,  262,  381,  371,  327,  358,  171,  261,  386,
 /*  1460 */   441,  444,  439,  386,  366,  247,  398,  440,  438,  371,
 /*  1470 */   402,  373,  266,  405,  406,  407,  408,  409,  410,  400,
 /*  1480 */   412,  269,  454,  264,  460,  453,  358,  419,  243,  366,
 /*  1490 */    20,  423,  424,  404,  366,  335,  398,  336,  339,  371,
 /*  1500 */   402,  373,   20,  405,  406,  407,  408,  409,  410,  384,
 /*  1510 */   412,  327,  371,  386,  165,  371,  371,  419,  371,  371,
 /*  1520 */   371,  423,  424,  386,  366,  339,  398,  327,  354,  383,
 /*  1530 */   402,   95,  339,  405,  406,  407,  408,  409,  410,  422,
 /*  1540 */   412,   95,  358,  362,  371,  335,  348,  419,  339,   36,
 /*  1550 */   366,  423,  424,  330,  329,  371,  387,  373,  358,   37,
 /*  1560 */   392,  396,  387,  352,    0,  352,  366,  352,  340,  325,
 /*  1570 */     0,  371,  187,  373,    0,    0,   42,    0,   35,  199,
 /*  1580 */    35,   35,  398,   35,    0,  199,  402,   35,  327,  405,
 /*  1590 */   406,  407,  408,  409,  410,   35,  412,  199,  398,    0,
 /*  1600 */   199,    0,  402,   35,  327,  405,  406,  407,  408,  409,
 /*  1610 */   410,    0,  412,   22,    0,   35,  182,  180,    0,  358,
 /*  1620 */    98,    0,  100,  101,  176,  103,  175,  366,   47,  107,
 /*  1630 */   446,  447,  371,    0,  373,  358,    0,    0,    0,    0,
 /*  1640 */    42,    0,    0,  366,   35,  151,    0,  447,  371,    0,
 /*  1650 */   373,  129,    0,    0,    0,    0,    0,  151,    0,  398,
 /*  1660 */     0,    0,    0,  402,    0,    0,  405,  406,  407,  408,
 /*  1670 */   409,  410,    0,  412,    0,  398,    0,    0,  327,  402,
 /*  1680 */     0,    0,  405,  406,  407,  408,  409,  410,    0,  412,
 /*  1690 */     0,    0,   42,    0,  327,    0,    0,    0,    0,    0,
 /*  1700 */    22,    0,    0,    0,  135,    0,   35,    0,    0,  358,
 /*  1710 */   449,    0,    0,   44,  363,   58,    0,  366,   39,    0,
 /*  1720 */    47,   58,  371,   14,  373,  358,   42,   14,   39,   47,
 /*  1730 */    47,    0,   40,  366,  171,  458,    0,    0,  371,   39,
 /*  1740 */   373,    0,    0,    0,    0,   35,    0,  327,    0,  398,
 /*  1750 */    64,    0,   48,  402,   39,   35,  405,  406,  407,  408,
 /*  1760 */   409,  410,   48,  412,   39,  398,   39,  327,   35,  402,
 /*  1770 */    48,   48,  405,  406,  407,  408,  409,  410,  358,  412,
 /*  1780 */    35,  414,    0,  363,    0,    0,  366,    0,   39,  104,
 /*  1790 */    35,  371,   22,  373,    0,   35,  102,   35,  358,   35,
 /*  1800 */    35,   44,   44,  363,   35,   22,  366,   35,   35,    0,
 /*  1810 */    22,  371,    0,  373,   22,    0,   50,   22,  398,    0,
 /*  1820 */   327,   35,  402,    0,   35,  405,  406,  407,  408,  409,
 /*  1830 */   410,   35,  412,    0,   20,   22,  327,   35,  398,   35,
 /*  1840 */   192,    0,  402,   96,    0,  405,  406,  407,  408,  409,
 /*  1850 */   410,  358,  412,   35,   95,    0,   22,    0,  183,  366,
 /*  1860 */    44,    3,   95,  248,  371,   44,  373,  358,   44,  163,
 /*  1870 */    96,   95,   44,   96,   96,  366,   95,   47,   47,   44,
 /*  1880 */   371,    3,  373,  248,  163,   95,  169,   96,   95,  165,
 /*  1890 */    44,  398,  163,   95,  327,  402,   96,   96,  405,  406,
 /*  1900 */   407,  408,  409,  410,   35,  412,   35,  398,   35,   35,
 /*  1910 */   327,  402,   35,   96,  405,  406,  407,  408,  409,  410,
 /*  1920 */    35,  412,   96,   47,   44,  358,   47,    0,    0,    0,
 /*  1930 */    47,   95,    0,  366,   96,  248,   96,   95,  371,   39,
 /*  1940 */   373,  358,   95,   95,   95,   47,  166,   44,  105,  366,
 /*  1950 */     2,   95,   22,   47,  371,  327,  373,  227,  205,  227,
 /*  1960 */    96,  164,   95,   95,  229,  398,   96,   95,  242,  402,
 /*  1970 */    95,  327,  405,  406,  407,  408,  409,  410,   96,  412,
 /*  1980 */    47,  398,   96,   22,   95,  402,  358,  106,  405,  406,
 /*  1990 */   407,  408,  409,  410,  366,  412,   22,   96,   35,  371,
 /*  2000 */    35,  373,  358,   95,   35,   96,  207,   95,   35,   96,
 /*  2010 */   366,   95,   35,   96,   95,  371,   96,  373,   35,   95,
 /*  2020 */    95,  119,  107,  119,  119,   44,  398,   35,   22,  119,
 /*  2030 */   402,   95,   95,  405,  406,  407,  408,  409,  410,   64,
 /*  2040 */   412,   63,  398,   35,   35,  327,  402,   35,   35,  405,
 /*  2050 */   406,  407,  408,  409,  410,   35,  412,   35,   35,   35,
 /*  2060 */    35,  327,   35,   70,   35,   44,   35,   35,   92,   22,
 /*  2070 */    35,   35,   35,   70,   35,   35,  358,   35,   35,   35,
 /*  2080 */    22,   35,    0,   35,  366,    0,   48,   35,   39,  371,
 /*  2090 */    39,  373,  358,   48,    0,   35,   39,    0,   48,   35,
 /*  2100 */   366,   48,   39,    0,   35,  371,  327,  373,   35,    0,
 /*  2110 */    22,   22,   21,   20,   22,  461,  398,   21,  461,  461,
 /*  2120 */   402,  461,  461,  405,  406,  407,  408,  409,  410,  461,
 /*  2130 */   412,  461,  398,  461,  327,  461,  402,  358,  461,  405,
 /*  2140 */   406,  407,  408,  409,  410,  366,  412,  461,  461,  461,
 /*  2150 */   371,  461,  373,  461,  461,  461,  461,  461,  461,  461,
 /*  2160 */   461,  461,  461,  461,  327,  358,  461,  461,  461,  461,
 /*  2170 */   461,  461,  461,  366,  461,  461,  461,  398,  371,  461,
 /*  2180 */   373,  402,  461,  461,  405,  406,  407,  408,  409,  410,
 /*  2190 */   461,  412,  327,  461,  461,  358,  461,  461,  461,  461,
 /*  2200 */   461,  461,  461,  366,  461,  398,  461,  461,  371,  402,
 /*  2210 */   373,  461,  405,  406,  407,  408,  409,  410,  461,  412,
 /*  2220 */   461,  461,  327,  358,  461,  461,  461,  461,  461,  461,
 /*  2230 */   461,  366,  461,  461,  461,  398,  371,  461,  373,  402,
 /*  2240 */   461,  461,  405,  406,  407,  408,  409,  410,  461,  412,
 /*  2250 */   461,  461,  461,  358,  461,  461,  461,  461,  461,  461,
 /*  2260 */   461,  366,  461,  398,  461,  461,  371,  402,  373,  461,
 /*  2270 */   405,  406,  407,  408,  409,  410,  461,  412,  461,  461,
 /*  2280 */   461,  461,  327,  461,  461,  461,  461,  461,  461,  461,
 /*  2290 */   461,  461,  461,  398,  461,  461,  461,  402,  461,  327,
 /*  2300 */   405,  406,  407,  408,  409,  410,  461,  412,  461,  461,
 /*  2310 */   461,  461,  461,  358,  461,  461,  461,  461,  461,  461,
 /*  2320 */   461,  366,  461,  461,  461,  461,  371,  327,  373,  461,
 /*  2330 */   358,  461,  461,  461,  461,  461,  461,  461,  366,  461,
 /*  2340 */   461,  461,  461,  371,  461,  373,  461,  461,  461,  461,
 /*  2350 */   461,  461,  461,  398,  461,  461,  461,  402,  358,  461,
 /*  2360 */   405,  406,  407,  408,  409,  410,  366,  412,  461,  461,
 /*  2370 */   398,  371,  461,  373,  402,  461,  461,  405,  406,  407,
 /*  2380 */   408,  409,  410,  461,  412,  461,  461,  461,  461,  327,
 /*  2390 */   461,  461,  461,  461,  461,  461,  461,  461,  398,  461,
 /*  2400 */   461,  461,  402,  461,  461,  405,  406,  407,  408,  409,
 /*  2410 */   410,  461,  412,  461,  461,  461,  461,  327,  461,  461,
 /*  2420 */   358,  461,  461,  461,  461,  461,  461,  461,  366,  461,
 /*  2430 */   461,  461,  461,  371,  327,  373,  461,  461,  461,  461,
 /*  2440 */   461,  461,  461,  461,  461,  461,  461,  461,  358,  461,
 /*  2450 */   461,  461,  461,  461,  461,  461,  366,  461,  461,  461,
 /*  2460 */   398,  371,  327,  373,  402,  358,  461,  405,  406,  407,
 /*  2470 */   408,  409,  410,  366,  412,  461,  461,  461,  371,  461,
 /*  2480 */   373,  461,  461,  461,  461,  461,  461,  461,  398,  461,
 /*  2490 */   461,  461,  402,  358,  461,  405,  406,  407,  408,  409,
 /*  2500 */   410,  366,  412,  461,  461,  398,  371,  461,  373,  402,
 /*  2510 */   461,  461,  405,  406,  407,  408,  409,  410,  461,  412,
 /*  2520 */   327,  461,  461,  461,  461,  461,  461,  461,  461,  461,
 /*  2530 */   461,  461,  461,  398,  461,  461,  327,  402,  461,  461,
 /*  2540 */   405,  406,  407,  408,  409,  410,  461,  412,  461,  461,
 /*  2550 */   461,  358,  461,  461,  461,  461,  461,  461,  461,  366,
 /*  2560 */   461,  461,  461,  461,  371,  461,  373,  358,  461,  461,
 /*  2570 */   461,  461,  461,  461,  461,  366,  461,  461,  461,  461,
 /*  2580 */   371,  461,  373,  461,  461,  461,  461,  461,  461,  461,
 /*  2590 */   461,  398,  461,  461,  461,  402,  461,  461,  405,  406,
 /*  2600 */   407,  408,  409,  410,  461,  412,  461,  398,  461,  461,
 /*  2610 */   461,  402,  461,  461,  405,  406,  407,  408,  409,  410,
 /*  2620 */   461,  412,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2630 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2640 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2650 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2660 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2670 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2680 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2690 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2700 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2710 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2720 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2730 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2740 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2750 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2760 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2770 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2780 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2790 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2800 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2810 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2820 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2830 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2840 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2850 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2860 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2870 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2880 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2890 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2900 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2910 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2920 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2930 */   324,  324,  324,  324,  324,  324,  324,  324,  324,  324,
 /*  2940 */   324,  324,  324,  324,  324,  324,
};
#define YY_SHIFT_COUNT    (713)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2109)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   925,    0,   71,    0,  288,  288,  288,  288,  288,  288,
 /*    10 */   288,  288,  288,  359,  574,  574,  645,  574,  574,  574,
 /*    20 */   574,  574,  574,  574,  574,  574,  574,  574,  574,  574,
 /*    30 */   574,  574,  574,  574,  574,  574,  574,  574,  574,  574,
 /*    40 */   574,  574,  574,  574,  574,  574,  103,  209,   51,  169,
 /*    50 */   287,  225,  424,  225,   51,   51, 1170, 1170, 1170,  225,
 /*    60 */  1170, 1170,  203,  225,    5,    5,  511,  511,   14,   52,
 /*    70 */    45,   45,    5,    5,    5,    5,    5,    5,    5,   40,
 /*    80 */     5,    5,   28,    5,    5,   99,    5,  177,    5,   40,
 /*    90 */   410,    5,    5,  410,    5,  410,  410,  410,    5,  193,
 /*   100 */   783,   34,   34,  587,  451,  932,  932,  932,  932,  932,
 /*   110 */   932,  932,  932,  932,  932,  932,  932,  932,  932,  932,
 /*   120 */   932,  932,  932,  932, 1522,  332,   14,   52,  192,  325,
 /*   130 */    87,   87,   87,  378,  372,  372,  325,  621,  621,  621,
 /*   140 */   539,  177,  492,  410,  673,  410,  673,  673,  539,  711,
 /*   150 */   216,  216,  216,  216,  216,  216,  216,  504,  434,  302,
 /*   160 */   535,  961,   58,   96,   94,  656,  864,  405,  227,  707,
 /*   170 */   842,  518,  715,  784,  869,  715, 1002,  834,  867, 1021,
 /*   180 */  1224, 1099, 1239, 1266, 1239, 1143, 1288, 1288, 1239, 1143,
 /*   190 */  1143, 1230, 1288, 1288, 1288, 1317, 1317, 1333,   28,  177,
 /*   200 */    28, 1337, 1345,   28, 1337,   28,   28,   28, 1288,   28,
 /*   210 */  1342, 1342, 1317,  410,  410,  410,  410,  410,  410,  410,
 /*   220 */   410,  410,  410,  410, 1288, 1317,  673,  673, 1233, 1333,
 /*   230 */   193, 1246,  177,  193, 1288, 1266, 1266,  673, 1185, 1192,
 /*   240 */   673, 1185, 1192,  673,  673,  410, 1191, 1286, 1185, 1190,
 /*   250 */  1197, 1218, 1021, 1212, 1206, 1219, 1245,  621, 1470, 1288,
 /*   260 */  1337,  193, 1482, 1192,  673,  673,  673,  673,  673, 1192,
 /*   270 */   673, 1349,  193,  539,  193,  621, 1436, 1446,  673,  711,
 /*   280 */  1288,  193, 1513, 1317, 2622, 2622, 2622, 2622, 2622, 2622,
 /*   290 */  2622, 2622, 2622,  826,  786,  597,  964,  716, 1057,  752,
 /*   300 */   955, 1172, 1229, 1281, 1255, 1320, 1320, 1320, 1320, 1320,
 /*   310 */  1320, 1320, 1320, 1320,  533,  582,  155,  155,  191,  469,
 /*   320 */   514,  390,  402,  228,  228,  831,  450,  482,  831,  831,
 /*   330 */   831,  713,  873,  970, 1011,  316,  980,  994, 1014, 1016,
 /*   340 */  1053,  959, 1087, 1140, 1076,  967, 1004, 1061, 1034,  943,
 /*   350 */   672,  853, 1080, 1097, 1124, 1126, 1134, 1194, 1188,  847,
 /*   360 */  1069, 1058, 1189, 1112, 1195, 1202, 1203, 1204, 1205, 1208,
 /*   370 */  1119, 1253, 1325, 1142, 1164, 1564, 1570, 1385, 1574, 1575,
 /*   380 */  1534, 1577, 1543, 1380, 1545, 1546, 1548, 1386, 1584, 1552,
 /*   390 */  1560, 1398, 1599, 1401, 1601, 1568, 1611, 1591, 1614, 1580,
 /*   400 */  1434, 1437, 1618, 1621, 1448, 1451, 1633, 1636, 1581, 1637,
 /*   410 */  1638, 1639, 1598, 1641, 1642, 1649, 1652, 1653, 1654, 1655,
 /*   420 */  1656, 1494, 1609, 1646, 1506, 1658, 1660, 1661, 1662, 1664,
 /*   430 */  1665, 1672, 1674, 1676, 1677, 1680, 1681, 1688, 1690, 1691,
 /*   440 */  1650, 1693, 1695, 1696, 1697, 1698, 1678, 1699, 1701, 1702,
 /*   450 */  1569, 1703, 1705, 1671, 1707, 1657, 1708, 1663, 1711, 1712,
 /*   460 */  1684, 1679, 1669, 1673, 1709, 1682, 1713, 1683, 1716, 1692,
 /*   470 */  1689, 1719, 1731, 1736, 1700, 1563, 1737, 1741, 1742, 1686,
 /*   480 */  1743, 1744, 1710, 1704, 1715, 1746, 1720, 1714, 1725, 1748,
 /*   490 */  1733, 1722, 1727, 1751, 1745, 1723, 1749, 1782, 1784, 1785,
 /*   500 */  1787, 1685, 1694, 1755, 1770, 1794, 1760, 1762, 1764, 1765,
 /*   510 */  1757, 1758, 1769, 1772, 1783, 1773, 1809, 1788, 1812, 1792,
 /*   520 */  1766, 1815, 1795, 1786, 1819, 1789, 1823, 1796, 1833, 1813,
 /*   530 */  1814, 1802, 1804, 1648, 1747, 1759, 1841, 1706, 1818, 1844,
 /*   540 */  1675, 1834, 1721, 1724, 1855, 1857, 1729, 1717, 1858, 1816,
 /*   550 */  1615, 1767, 1774, 1776, 1777, 1821, 1824, 1778, 1781, 1790,
 /*   560 */  1793, 1791, 1828, 1830, 1831, 1798, 1835, 1635, 1800, 1801,
 /*   570 */  1878, 1846, 1687, 1869, 1871, 1873, 1874, 1877, 1885, 1817,
 /*   580 */  1826, 1876, 1726, 1880, 1879, 1927, 1928, 1929, 1673, 1883,
 /*   590 */  1836, 1838, 1840, 1842, 1847, 1780, 1848, 1932, 1900, 1797,
 /*   600 */  1849, 1843, 1673, 1898, 1903, 1730, 1735, 1732, 1948, 1930,
 /*   610 */  1753, 1856, 1864, 1867, 1870, 1868, 1882, 1906, 1872, 1875,
 /*   620 */  1933, 1886, 1961, 1799, 1889, 1881, 1901, 1963, 1965, 1908,
 /*   630 */  1909, 1969, 1912, 1913, 1973, 1916, 1917, 1977, 1919, 1920,
 /*   640 */  1983, 1924, 1902, 1904, 1905, 1910, 1974, 1915, 1925, 1981,
 /*   650 */  1936, 1992, 1937, 1981, 1981, 2006, 1975, 1978, 2008, 2009,
 /*   660 */  2012, 2013, 2020, 2022, 2023, 2024, 2025, 2027, 1993, 1976,
 /*   670 */  2021, 2029, 2031, 2032, 2047, 2035, 2036, 2037, 2003, 1757,
 /*   680 */  2039, 1758, 2040, 2042, 2043, 2044, 2058, 2046, 2082, 2048,
 /*   690 */  2038, 2049, 2085, 2052, 2045, 2051, 2094, 2060, 2050, 2057,
 /*   700 */  2097, 2064, 2053, 2063, 2103, 2069, 2073, 2109, 2088, 2091,
 /*   710 */  2089, 2092, 2096, 2093,
};
#define YY_REDUCE_COUNT (292)
#define YY_REDUCE_MIN   (-427)
#define YY_REDUCE_MAX   (2209)
static const short yy_reduce_ofst[] = {
 /*     0 */   -19, -297,   -9,  277,  633,  737,  792,  852,  907, 1000,
 /*    10 */  1068, 1098, 1128, -171, 1184,   75,  339, 1200, 1261, 1277,
 /*    20 */  1351, 1367, 1420, 1440, 1493, 1509, 1567, 1583, 1628, 1644,
 /*    30 */  1718, 1734, 1779, 1807, 1837, 1865, 1895, 1955, 1972, 2000,
 /*    40 */  2062, 2090, 2107, 2135, 2193, 2209, -278, -292, -170,  -12,
 /*    50 */   283,  563,  890,  913, -329, -183, -350, -316,  235, -427,
 /*    60 */   622,  676, -424,  373, -330, -221, -331, -293, -302, -305,
 /*    70 */  -211, -146, -175,   69,  122,  187,  254,  483,  486, -290,
 /*    80 */   612,  630,    1,  660,  666, -277,  702,  -66,  725, -154,
 /*    90 */  -349,  740,  741,  281,  745,  392,  334,  472,  787, -160,
 /*   100 */  -296, -405, -405, -184, -267, -172,  -18,   36,  115,  118,
 /*   110 */   278,  303,  306,  346,  384,  400,  449,  510,  547,  549,
 /*   120 */   617,  618,  619,  637,    4, -152,  230, -236,  126,  130,
 /*   130 */  -152,  289,  291,  292,  238,  286,  134,  509,  513,  519,
 /*   140 */   -48,  157,  387,  232,  443,  168,  632,  639,  679,  426,
 /*   150 */  -342,  367,  456,  529,  695,  733,  758, -339,  802,  801,
 /*   160 */   770,  730,  724,  838,  749,  848,  848,  880,  840,  885,
 /*   170 */   857,  854,  803,  803,  804,  803,  828,  832,  848,  870,
 /*   180 */   875,  891,  905,  911,  928,  931,  975,  976,  940,  944,
 /*   190 */   946,  996, 1007, 1008, 1012, 1020, 1022,  960, 1013,  983,
 /*   200 */  1018, 1025,  977, 1029, 1036, 1033, 1037, 1038, 1042, 1039,
 /*   210 */  1059, 1062, 1067, 1041, 1043, 1045, 1046, 1055, 1056, 1060,
 /*   220 */  1063, 1064, 1070, 1071, 1081, 1082, 1044, 1049, 1035, 1040,
 /*   230 */  1091, 1048, 1065, 1094, 1101, 1066, 1072, 1074,  999, 1073,
 /*   240 */  1075, 1009, 1077, 1078, 1083,  848, 1017, 1005, 1019, 1027,
 /*   250 */  1023, 1030, 1079, 1024, 1028, 1032,  803, 1123, 1089, 1160,
 /*   260 */  1161, 1159, 1125, 1127, 1141, 1144, 1145, 1147, 1148, 1137,
 /*   270 */  1149, 1146, 1186, 1174, 1193, 1158, 1117, 1181, 1173, 1198,
 /*   280 */  1210, 1209, 1223, 1225, 1168, 1165, 1169, 1175, 1211, 1213,
 /*   290 */  1215, 1228, 1244,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*    10 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*    20 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*    30 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*    40 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*    50 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*    60 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1857, 1602,
 /*    70 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*    80 */  1602, 1602, 1680, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*    90 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1678,
 /*   100 */  1850, 2050, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   110 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   120 */  1602, 1602, 1602, 1602, 1602, 2062, 1602, 1602, 1680, 1602,
 /*   130 */  2062, 2062, 2062, 1678, 2022, 2022, 1602, 1602, 1602, 1602,
 /*   140 */  1787, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1787, 1602,
 /*   150 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1896, 1602, 1602,
 /*   160 */  2087, 2142, 1602, 1602, 2090, 1602, 1602, 1602, 1862, 1602,
 /*   170 */  1740, 2077, 2054, 2068, 2126, 2055, 2052, 2071, 1602, 2081,
 /*   180 */  1602, 1889, 1855, 1602, 1855, 1852, 1602, 1602, 1855, 1852,
 /*   190 */  1852, 1731, 1602, 1602, 1602, 1602, 1602, 1602, 1680, 1602,
 /*   200 */  1680, 1602, 1602, 1680, 1602, 1680, 1680, 1680, 1602, 1680,
 /*   210 */  1659, 1659, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   220 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1909, 1602,
 /*   230 */  1678, 1898, 1602, 1678, 1602, 1602, 1602, 1602, 2097, 2095,
 /*   240 */  1602, 2097, 2095, 1602, 1602, 1602, 2111, 2107, 2097, 2115,
 /*   250 */  2113, 2083, 2081, 2145, 2132, 2128, 2068, 1602, 1602, 1602,
 /*   260 */  1602, 1678, 1602, 2095, 1602, 1602, 1602, 1602, 1602, 2095,
 /*   270 */  1602, 1602, 1678, 1602, 1678, 1602, 1602, 1756, 1602, 1602,
 /*   280 */  1602, 1678, 1634, 1602, 1891, 1902, 1874, 1874, 1790, 1790,
 /*   290 */  1790, 1681, 1607, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   300 */  1602, 1602, 1602, 1602, 1602, 2110, 2109, 1978, 1602, 2026,
 /*   310 */  2025, 2024, 2015, 1977, 1752, 1602, 1976, 1975, 1602, 1602,
 /*   320 */  1602, 1602, 1602, 1870, 1869, 1969, 1602, 1602, 1970, 1968,
 /*   330 */  1967, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   340 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 2129,
 /*   350 */  2133, 1602, 1602, 1602, 1602, 1602, 1602, 2051, 1602, 1602,
 /*   360 */  1602, 1602, 1602, 1951, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   370 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   380 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   390 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   400 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   410 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   420 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   430 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   440 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   450 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   460 */  1602, 1602, 1639, 1956, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   470 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   480 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   490 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   500 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   510 */  1719, 1718, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   520 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   530 */  1602, 1602, 1602, 1602, 1960, 1602, 1602, 1602, 1602, 1602,
 /*   540 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 2125, 2084,
 /*   550 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   560 */  1602, 1602, 1602, 1602, 1951, 1602, 2108, 1602, 1602, 2123,
 /*   570 */  1602, 2127, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 2061,
 /*   580 */  2057, 1602, 1602, 2053, 1602, 1602, 1602, 1602, 1959, 1602,
 /*   590 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   600 */  1602, 1602, 1950, 1602, 2012, 1602, 1602, 1602, 2046, 1602,
 /*   610 */  1602, 1997, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   620 */  1602, 1960, 1602, 1963, 1602, 1602, 1602, 1602, 1602, 1784,
 /*   630 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   640 */  1602, 1602, 1769, 1767, 1766, 1765, 1602, 1762, 1602, 1797,
 /*   650 */  1602, 1602, 1602, 1793, 1792, 1602, 1602, 1602, 1602, 1602,
 /*   660 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   670 */  1699, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1691,
 /*   680 */  1602, 1690, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   690 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   700 */  1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602, 1602,
 /*   710 */  1602, 1602, 1602, 1602,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       CASE => nothing */
  270,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  270,  /*      AFTER => ABORT */
  270,  /*     ATTACH => ABORT */
  270,  /*     BEFORE => ABORT */
  270,  /*      BEGIN => ABORT */
  270,  /*     BITAND => ABORT */
  270,  /*     BITNOT => ABORT */
  270,  /*      BITOR => ABORT */
  270,  /*     BLOCKS => ABORT */
  270,  /*     CHANGE => ABORT */
  270,  /*      COMMA => ABORT */
  270,  /*    COMPACT => ABORT */
  270,  /*     CONCAT => ABORT */
  270,  /*   CONFLICT => ABORT */
  270,  /*       COPY => ABORT */
  270,  /*   DEFERRED => ABORT */
  270,  /* DELIMITERS => ABORT */
  270,  /*     DETACH => ABORT */
  270,  /*     DIVIDE => ABORT */
  270,  /*        DOT => ABORT */
  270,  /*       EACH => ABORT */
  270,  /*       FAIL => ABORT */
  270,  /*       FILE => ABORT */
  270,  /*        FOR => ABORT */
  270,  /*       GLOB => ABORT */
  270,  /*         ID => ABORT */
  270,  /*  IMMEDIATE => ABORT */
  270,  /*     IMPORT => ABORT */
  270,  /*  INITIALLY => ABORT */
  270,  /*    INSTEAD => ABORT */
  270,  /*     ISNULL => ABORT */
  270,  /*        KEY => ABORT */
  270,  /*    MODULES => ABORT */
  270,  /*  NK_BITNOT => ABORT */
  270,  /*    NK_SEMI => ABORT */
  270,  /*    NOTNULL => ABORT */
  270,  /*         OF => ABORT */
  270,  /*       PLUS => ABORT */
  270,  /*  PRIVILEGE => ABORT */
  270,  /*      RAISE => ABORT */
  270,  /*    REPLACE => ABORT */
  270,  /*   RESTRICT => ABORT */
  270,  /*        ROW => ABORT */
  270,  /*       SEMI => ABORT */
  270,  /*       STAR => ABORT */
  270,  /*  STATEMENT => ABORT */
  270,  /*     STRICT => ABORT */
  270,  /*     STRING => ABORT */
  270,  /*      TIMES => ABORT */
  270,  /*     UPDATE => ABORT */
  270,  /*     VALUES => ABORT */
  270,  /*   VARIABLE => ABORT */
  270,  /*       VIEW => ABORT */
  270,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "IF",
  /*   63 */ "NOT",
  /*   64 */ "EXISTS",
  /*   65 */ "BUFFER",
  /*   66 */ "CACHEMODEL",
  /*   67 */ "CACHESIZE",
  /*   68 */ "COMP",
  /*   69 */ "DURATION",
  /*   70 */ "NK_VARIABLE",
  /*   71 */ "MAXROWS",
  /*   72 */ "MINROWS",
  /*   73 */ "KEEP",
  /*   74 */ "PAGES",
  /*   75 */ "PAGESIZE",
  /*   76 */ "TSDB_PAGESIZE",
  /*   77 */ "PRECISION",
  /*   78 */ "REPLICA",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "WAL_LEVEL",
  /*   84 */ "WAL_FSYNC_PERIOD",
  /*   85 */ "WAL_RETENTION_PERIOD",
  /*   86 */ "WAL_RETENTION_SIZE",
  /*   87 */ "WAL_ROLL_PERIOD",
  /*   88 */ "WAL_SEGMENT_SIZE",
  /*   89 */ "STT_TRIGGER",
  /*   90 */ "TABLE_PREFIX",
  /*   91 */ "TABLE_SUFFIX",
  /*   92 */ "NK_COLON",
  /*   93 */ "MAX_SPEED",
  /*   94 */ "TABLE",
  /*   95 */ "NK_LP",
  /*   96 */ "NK_RP",
  /*   97 */ "STABLE",
  /*   98 */ "ADD",
  /*   99 */ "COLUMN",
  /*  100 */ "MODIFY",
  /*  101 */ "RENAME",
  /*  102 */ "TAG",
  /*  103 */ "SET",
  /*  104 */ "NK_EQ",
  /*  105 */ "USING",
  /*  106 */ "TAGS",
  /*  107 */ "COMMENT",
  /*  108 */ "BOOL",
  /*  109 */ "TINYINT",
  /*  110 */ "SMALLINT",
  /*  111 */ "INT",
  /*  112 */ "INTEGER",
  /*  113 */ "BIGINT",
  /*  114 */ "FLOAT",
  /*  115 */ "DOUBLE",
  /*  116 */ "BINARY",
  /*  117 */ "TIMESTAMP",
  /*  118 */ "NCHAR",
  /*  119 */ "UNSIGNED",
  /*  120 */ "JSON",
  /*  121 */ "VARCHAR",
  /*  122 */ "MEDIUMBLOB",
  /*  123 */ "BLOB",
  /*  124 */ "VARBINARY",
  /*  125 */ "DECIMAL",
  /*  126 */ "MAX_DELAY",
  /*  127 */ "WATERMARK",
  /*  128 */ "ROLLUP",
  /*  129 */ "TTL",
  /*  130 */ "SMA",
  /*  131 */ "DELETE_MARK",
  /*  132 */ "FIRST",
  /*  133 */ "LAST",
  /*  134 */ "SHOW",
  /*  135 */ "PRIVILEGES",
  /*  136 */ "DATABASES",
  /*  137 */ "TABLES",
  /*  138 */ "STABLES",
  /*  139 */ "MNODES",
  /*  140 */ "QNODES",
  /*  141 */ "FUNCTIONS",
  /*  142 */ "INDEXES",
  /*  143 */ "ACCOUNTS",
  /*  144 */ "APPS",
  /*  145 */ "CONNECTIONS",
  /*  146 */ "LICENCES",
  /*  147 */ "GRANTS",
  /*  148 */ "QUERIES",
  /*  149 */ "SCORES",
  /*  150 */ "TOPICS",
  /*  151 */ "VARIABLES",
  /*  152 */ "CLUSTER",
  /*  153 */ "BNODES",
  /*  154 */ "SNODES",
  /*  155 */ "TRANSACTIONS",
  /*  156 */ "DISTRIBUTED",
  /*  157 */ "CONSUMERS",
  /*  158 */ "SUBSCRIPTIONS",
  /*  159 */ "VNODES",
  /*  160 */ "LIKE",
  /*  161 */ "TBNAME",
  /*  162 */ "QTAGS",
  /*  163 */ "AS",
  /*  164 */ "INDEX",
  /*  165 */ "FUNCTION",
  /*  166 */ "INTERVAL",
  /*  167 */ "TOPIC",
  /*  168 */ "WITH",
  /*  169 */ "META",
  /*  170 */ "CONSUMER",
  /*  171 */ "GROUP",
  /*  172 */ "DESC",
  /*  173 */ "DESCRIBE",
  /*  174 */ "RESET",
  /*  175 */ "QUERY",
  /*  176 */ "CACHE",
  /*  177 */ "EXPLAIN",
  /*  178 */ "ANALYZE",
  /*  179 */ "VERBOSE",
  /*  180 */ "NK_BOOL",
  /*  181 */ "RATIO",
  /*  182 */ "NK_FLOAT",
  /*  183 */ "OUTPUTTYPE",
  /*  184 */ "AGGREGATE",
  /*  185 */ "BUFSIZE",
  /*  186 */ "STREAM",
  /*  187 */ "INTO",
  /*  188 */ "TRIGGER",
  /*  189 */ "AT_ONCE",
  /*  190 */ "WINDOW_CLOSE",
  /*  191 */ "IGNORE",
  /*  192 */ "EXPIRED",
  /*  193 */ "FILL_HISTORY",
  /*  194 */ "SUBTABLE",
  /*  195 */ "KILL",
  /*  196 */ "CONNECTION",
  /*  197 */ "TRANSACTION",
  /*  198 */ "BALANCE",
  /*  199 */ "VGROUP",
  /*  200 */ "MERGE",
  /*  201 */ "REDISTRIBUTE",
  /*  202 */ "SPLIT",
  /*  203 */ "DELETE",
  /*  204 */ "INSERT",
  /*  205 */ "NULL",
  /*  206 */ "NK_QUESTION",
  /*  207 */ "NK_ARROW",
  /*  208 */ "ROWTS",
  /*  209 */ "QSTART",
  /*  210 */ "QEND",
  /*  211 */ "QDURATION",
  /*  212 */ "WSTART",
  /*  213 */ "WEND",
  /*  214 */ "WDURATION",
  /*  215 */ "IROWTS",
  /*  216 */ "CAST",
  /*  217 */ "NOW",
  /*  218 */ "TODAY",
  /*  219 */ "TIMEZONE",
  /*  220 */ "CLIENT_VERSION",
  /*  221 */ "SERVER_VERSION",
  /*  222 */ "SERVER_STATUS",
  /*  223 */ "CURRENT_USER",
  /*  224 */ "COUNT",
  /*  225 */ "LAST_ROW",
  /*  226 */ "CASE",
  /*  227 */ "END",
  /*  228 */ "WHEN",
  /*  229 */ "THEN",
  /*  230 */ "ELSE",
  /*  231 */ "BETWEEN",
  /*  232 */ "IS",
  /*  233 */ "NK_LT",
  /*  234 */ "NK_GT",
  /*  235 */ "NK_LE",
  /*  236 */ "NK_GE",
  /*  237 */ "NK_NE",
  /*  238 */ "MATCH",
  /*  239 */ "NMATCH",
  /*  240 */ "CONTAINS",
  /*  241 */ "IN",
  /*  242 */ "JOIN",
  /*  243 */ "INNER",
  /*  244 */ "SELECT",
  /*  245 */ "DISTINCT",
  /*  246 */ "WHERE",
  /*  247 */ "PARTITION",
  /*  248 */ "BY",
  /*  249 */ "SESSION",
  /*  250 */ "STATE_WINDOW",
  /*  251 */ "SLIDING",
  /*  252 */ "FILL",
  /*  253 */ "VALUE",
  /*  254 */ "VALUE_F",
  /*  255 */ "NONE",
  /*  256 */ "PREV",
  /*  257 */ "NULL_F",
  /*  258 */ "LINEAR",
  /*  259 */ "NEXT",
  /*  260 */ "HAVING",
  /*  261 */ "RANGE",
  /*  262 */ "EVERY",
  /*  263 */ "ORDER",
  /*  264 */ "SLIMIT",
  /*  265 */ "SOFFSET",
  /*  266 */ "LIMIT",
  /*  267 */ "OFFSET",
  /*  268 */ "ASC",
  /*  269 */ "NULLS",
  /*  270 */ "ABORT",
  /*  271 */ "AFTER",
  /*  272 */ "ATTACH",
  /*  273 */ "BEFORE",
  /*  274 */ "BEGIN",
  /*  275 */ "BITAND",
  /*  276 */ "BITNOT",
  /*  277 */ "BITOR",
  /*  278 */ "BLOCKS",
  /*  279 */ "CHANGE",
  /*  280 */ "COMMA",
  /*  281 */ "COMPACT",
  /*  282 */ "CONCAT",
  /*  283 */ "CONFLICT",
  /*  284 */ "COPY",
  /*  285 */ "DEFERRED",
  /*  286 */ "DELIMITERS",
  /*  287 */ "DETACH",
  /*  288 */ "DIVIDE",
  /*  289 */ "DOT",
  /*  290 */ "EACH",
  /*  291 */ "FAIL",
  /*  292 */ "FILE",
  /*  293 */ "FOR",
  /*  294 */ "GLOB",
  /*  295 */ "ID",
  /*  296 */ "IMMEDIATE",
  /*  297 */ "IMPORT",
  /*  298 */ "INITIALLY",
  /*  299 */ "INSTEAD",
  /*  300 */ "ISNULL",
  /*  301 */ "KEY",
  /*  302 */ "MODULES",
  /*  303 */ "NK_BITNOT",
  /*  304 */ "NK_SEMI",
  /*  305 */ "NOTNULL",
  /*  306 */ "OF",
  /*  307 */ "PLUS",
  /*  308 */ "PRIVILEGE",
  /*  309 */ "RAISE",
  /*  310 */ "REPLACE",
  /*  311 */ "RESTRICT",
  /*  312 */ "ROW",
  /*  313 */ "SEMI",
  /*  314 */ "STAR",
  /*  315 */ "STATEMENT",
  /*  316 */ "STRICT",
  /*  317 */ "STRING",
  /*  318 */ "TIMES",
  /*  319 */ "UPDATE",
  /*  320 */ "VALUES",
  /*  321 */ "VARIABLE",
  /*  322 */ "VIEW",
  /*  323 */ "WAL",
  /*  324 */ "cmd",
  /*  325 */ "account_options",
  /*  326 */ "alter_account_options",
  /*  327 */ "literal",
  /*  328 */ "alter_account_option",
  /*  329 */ "user_name",
  /*  330 */ "sysinfo_opt",
  /*  331 */ "privileges",
  /*  332 */ "priv_level",
  /*  333 */ "priv_type_list",
  /*  334 */ "priv_type",
  /*  335 */ "db_name",
  /*  336 */ "topic_name",
  /*  337 */ "dnode_endpoint",
  /*  338 */ "force_opt",
  /*  339 */ "not_exists_opt",
  /*  340 */ "db_options",
  /*  341 */ "exists_opt",
  /*  342 */ "alter_db_options",
  /*  343 */ "speed_opt",
  /*  344 */ "integer_list",
  /*  345 */ "variable_list",
  /*  346 */ "retention_list",
  /*  347 */ "alter_db_option",
  /*  348 */ "retention",
  /*  349 */ "full_table_name",
  /*  350 */ "column_def_list",
  /*  351 */ "tags_def_opt",
  /*  352 */ "table_options",
  /*  353 */ "multi_create_clause",
  /*  354 */ "tags_def",
  /*  355 */ "multi_drop_clause",
  /*  356 */ "alter_table_clause",
  /*  357 */ "alter_table_options",
  /*  358 */ "column_name",
  /*  359 */ "type_name",
  /*  360 */ "signed_literal",
  /*  361 */ "create_subtable_clause",
  /*  362 */ "specific_cols_opt",
  /*  363 */ "expression_list",
  /*  364 */ "drop_table_clause",
  /*  365 */ "col_name_list",
  /*  366 */ "table_name",
  /*  367 */ "column_def",
  /*  368 */ "duration_list",
  /*  369 */ "rollup_func_list",
  /*  370 */ "alter_table_option",
  /*  371 */ "duration_literal",
  /*  372 */ "rollup_func_name",
  /*  373 */ "function_name",
  /*  374 */ "col_name",
  /*  375 */ "db_name_cond_opt",
  /*  376 */ "like_pattern_opt",
  /*  377 */ "table_name_cond",
  /*  378 */ "from_db_opt",
  /*  379 */ "tag_list_opt",
  /*  380 */ "tag_item",
  /*  381 */ "column_alias",
  /*  382 */ "full_index_name",
  /*  383 */ "index_options",
  /*  384 */ "index_name",
  /*  385 */ "func_list",
  /*  386 */ "sliding_opt",
  /*  387 */ "sma_stream_opt",
  /*  388 */ "func",
  /*  389 */ "query_or_subquery",
  /*  390 */ "cgroup_name",
  /*  391 */ "analyze_opt",
  /*  392 */ "explain_options",
  /*  393 */ "agg_func_opt",
  /*  394 */ "bufsize_opt",
  /*  395 */ "stream_name",
  /*  396 */ "stream_options",
  /*  397 */ "subtable_opt",
  /*  398 */ "expression",
  /*  399 */ "dnode_list",
  /*  400 */ "where_clause_opt",
  /*  401 */ "signed",
  /*  402 */ "literal_func",
  /*  403 */ "literal_list",
  /*  404 */ "table_alias",
  /*  405 */ "expr_or_subquery",
  /*  406 */ "pseudo_column",
  /*  407 */ "column_reference",
  /*  408 */ "function_expression",
  /*  409 */ "case_when_expression",
  /*  410 */ "star_func",
  /*  411 */ "star_func_para_list",
  /*  412 */ "noarg_func",
  /*  413 */ "other_para_list",
  /*  414 */ "star_func_para",
  /*  415 */ "when_then_list",
  /*  416 */ "case_when_else_opt",
  /*  417 */ "common_expression",
  /*  418 */ "when_then_expr",
  /*  419 */ "predicate",
  /*  420 */ "compare_op",
  /*  421 */ "in_op",
  /*  422 */ "in_predicate_value",
  /*  423 */ "boolean_value_expression",
  /*  424 */ "boolean_primary",
  /*  425 */ "from_clause_opt",
  /*  426 */ "table_reference_list",
  /*  427 */ "table_reference",
  /*  428 */ "table_primary",
  /*  429 */ "joined_table",
  /*  430 */ "alias_opt",
  /*  431 */ "subquery",
  /*  432 */ "parenthesized_joined_table",
  /*  433 */ "join_type",
  /*  434 */ "search_condition",
  /*  435 */ "query_specification",
  /*  436 */ "set_quantifier_opt",
  /*  437 */ "select_list",
  /*  438 */ "partition_by_clause_opt",
  /*  439 */ "range_opt",
  /*  440 */ "every_opt",
  /*  441 */ "fill_opt",
  /*  442 */ "twindow_clause_opt",
  /*  443 */ "group_by_clause_opt",
  /*  444 */ "having_clause_opt",
  /*  445 */ "select_item",
  /*  446 */ "partition_list",
  /*  447 */ "partition_item",
  /*  448 */ "fill_mode",
  /*  449 */ "group_by_list",
  /*  450 */ "query_expression",
  /*  451 */ "query_simple",
  /*  452 */ "order_by_clause_opt",
  /*  453 */ "slimit_clause_opt",
  /*  454 */ "limit_clause_opt",
  /*  455 */ "union_query_expression",
  /*  456 */ "query_simple_or_subquery",
  /*  457 */ "sort_specification_list",
  /*  458 */ "sort_specification",
  /*  459 */ "ordering_specification_opt",
  /*  460 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  73 */ "not_exists_opt ::=",
 /*  74 */ "exists_opt ::= IF EXISTS",
 /*  75 */ "exists_opt ::=",
 /*  76 */ "db_options ::=",
 /*  77 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  78 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  79 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  81 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  83 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  84 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options KEEP integer_list",
 /*  86 */ "db_options ::= db_options KEEP variable_list",
 /*  87 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  88 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  89 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  91 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  92 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  93 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  94 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  95 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 104 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 105 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 107 */ "alter_db_options ::= alter_db_option",
 /* 108 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 109 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 110 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 111 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 112 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 113 */ "alter_db_option ::= KEEP integer_list",
 /* 114 */ "alter_db_option ::= KEEP variable_list",
 /* 115 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 116 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 117 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 118 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 119 */ "integer_list ::= NK_INTEGER",
 /* 120 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 121 */ "variable_list ::= NK_VARIABLE",
 /* 122 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 123 */ "retention_list ::= retention",
 /* 124 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 125 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 126 */ "speed_opt ::=",
 /* 127 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 128 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 129 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 130 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 131 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 132 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 133 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 134 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 135 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 136 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 138 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 140 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 142 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 143 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 144 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 145 */ "multi_create_clause ::= create_subtable_clause",
 /* 146 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 147 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 148 */ "multi_drop_clause ::= drop_table_clause",
 /* 149 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 150 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 151 */ "specific_cols_opt ::=",
 /* 152 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 153 */ "full_table_name ::= table_name",
 /* 154 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 155 */ "column_def_list ::= column_def",
 /* 156 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 157 */ "column_def ::= column_name type_name",
 /* 158 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 159 */ "type_name ::= BOOL",
 /* 160 */ "type_name ::= TINYINT",
 /* 161 */ "type_name ::= SMALLINT",
 /* 162 */ "type_name ::= INT",
 /* 163 */ "type_name ::= INTEGER",
 /* 164 */ "type_name ::= BIGINT",
 /* 165 */ "type_name ::= FLOAT",
 /* 166 */ "type_name ::= DOUBLE",
 /* 167 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= TIMESTAMP",
 /* 169 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= TINYINT UNSIGNED",
 /* 171 */ "type_name ::= SMALLINT UNSIGNED",
 /* 172 */ "type_name ::= INT UNSIGNED",
 /* 173 */ "type_name ::= BIGINT UNSIGNED",
 /* 174 */ "type_name ::= JSON",
 /* 175 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 176 */ "type_name ::= MEDIUMBLOB",
 /* 177 */ "type_name ::= BLOB",
 /* 178 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= DECIMAL",
 /* 180 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 182 */ "tags_def_opt ::=",
 /* 183 */ "tags_def_opt ::= tags_def",
 /* 184 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 185 */ "table_options ::=",
 /* 186 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 187 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 188 */ "table_options ::= table_options WATERMARK duration_list",
 /* 189 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 190 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 191 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 192 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 193 */ "alter_table_options ::= alter_table_option",
 /* 194 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 195 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 196 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 197 */ "duration_list ::= duration_literal",
 /* 198 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 199 */ "rollup_func_list ::= rollup_func_name",
 /* 200 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 201 */ "rollup_func_name ::= function_name",
 /* 202 */ "rollup_func_name ::= FIRST",
 /* 203 */ "rollup_func_name ::= LAST",
 /* 204 */ "col_name_list ::= col_name",
 /* 205 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 206 */ "col_name ::= column_name",
 /* 207 */ "cmd ::= SHOW DNODES",
 /* 208 */ "cmd ::= SHOW USERS",
 /* 209 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 210 */ "cmd ::= SHOW DATABASES",
 /* 211 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 214 */ "cmd ::= SHOW MNODES",
 /* 215 */ "cmd ::= SHOW QNODES",
 /* 216 */ "cmd ::= SHOW FUNCTIONS",
 /* 217 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 218 */ "cmd ::= SHOW STREAMS",
 /* 219 */ "cmd ::= SHOW ACCOUNTS",
 /* 220 */ "cmd ::= SHOW APPS",
 /* 221 */ "cmd ::= SHOW CONNECTIONS",
 /* 222 */ "cmd ::= SHOW LICENCES",
 /* 223 */ "cmd ::= SHOW GRANTS",
 /* 224 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 225 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 226 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 227 */ "cmd ::= SHOW QUERIES",
 /* 228 */ "cmd ::= SHOW SCORES",
 /* 229 */ "cmd ::= SHOW TOPICS",
 /* 230 */ "cmd ::= SHOW VARIABLES",
 /* 231 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 232 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 233 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 234 */ "cmd ::= SHOW BNODES",
 /* 235 */ "cmd ::= SHOW SNODES",
 /* 236 */ "cmd ::= SHOW CLUSTER",
 /* 237 */ "cmd ::= SHOW TRANSACTIONS",
 /* 238 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 239 */ "cmd ::= SHOW CONSUMERS",
 /* 240 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 241 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 242 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 244 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 245 */ "db_name_cond_opt ::=",
 /* 246 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 247 */ "like_pattern_opt ::=",
 /* 248 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 249 */ "table_name_cond ::= table_name",
 /* 250 */ "from_db_opt ::=",
 /* 251 */ "from_db_opt ::= FROM db_name",
 /* 252 */ "tag_list_opt ::=",
 /* 253 */ "tag_list_opt ::= tag_item",
 /* 254 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 255 */ "tag_item ::= TBNAME",
 /* 256 */ "tag_item ::= QTAGS",
 /* 257 */ "tag_item ::= column_name",
 /* 258 */ "tag_item ::= column_name column_alias",
 /* 259 */ "tag_item ::= column_name AS column_alias",
 /* 260 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 261 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 262 */ "full_index_name ::= index_name",
 /* 263 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 264 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 265 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 266 */ "func_list ::= func",
 /* 267 */ "func_list ::= func_list NK_COMMA func",
 /* 268 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 269 */ "sma_stream_opt ::=",
 /* 270 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 271 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 272 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 273 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 274 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 275 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 276 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 277 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 278 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 279 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 280 */ "cmd ::= DESC full_table_name",
 /* 281 */ "cmd ::= DESCRIBE full_table_name",
 /* 282 */ "cmd ::= RESET QUERY CACHE",
 /* 283 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 284 */ "analyze_opt ::=",
 /* 285 */ "analyze_opt ::= ANALYZE",
 /* 286 */ "explain_options ::=",
 /* 287 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 288 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 289 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 290 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 291 */ "agg_func_opt ::=",
 /* 292 */ "agg_func_opt ::= AGGREGATE",
 /* 293 */ "bufsize_opt ::=",
 /* 294 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 295 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery",
 /* 296 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 297 */ "stream_options ::=",
 /* 298 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 299 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 300 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 301 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 302 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 303 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 304 */ "subtable_opt ::=",
 /* 305 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 306 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 307 */ "cmd ::= KILL QUERY NK_STRING",
 /* 308 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 309 */ "cmd ::= BALANCE VGROUP",
 /* 310 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 311 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 312 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 313 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 314 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 315 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 316 */ "cmd ::= query_or_subquery",
 /* 317 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 318 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 319 */ "literal ::= NK_INTEGER",
 /* 320 */ "literal ::= NK_FLOAT",
 /* 321 */ "literal ::= NK_STRING",
 /* 322 */ "literal ::= NK_BOOL",
 /* 323 */ "literal ::= TIMESTAMP NK_STRING",
 /* 324 */ "literal ::= duration_literal",
 /* 325 */ "literal ::= NULL",
 /* 326 */ "literal ::= NK_QUESTION",
 /* 327 */ "duration_literal ::= NK_VARIABLE",
 /* 328 */ "signed ::= NK_INTEGER",
 /* 329 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 330 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 331 */ "signed ::= NK_FLOAT",
 /* 332 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 333 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 334 */ "signed_literal ::= signed",
 /* 335 */ "signed_literal ::= NK_STRING",
 /* 336 */ "signed_literal ::= NK_BOOL",
 /* 337 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 338 */ "signed_literal ::= duration_literal",
 /* 339 */ "signed_literal ::= NULL",
 /* 340 */ "signed_literal ::= literal_func",
 /* 341 */ "signed_literal ::= NK_QUESTION",
 /* 342 */ "literal_list ::= signed_literal",
 /* 343 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 344 */ "db_name ::= NK_ID",
 /* 345 */ "table_name ::= NK_ID",
 /* 346 */ "column_name ::= NK_ID",
 /* 347 */ "function_name ::= NK_ID",
 /* 348 */ "table_alias ::= NK_ID",
 /* 349 */ "column_alias ::= NK_ID",
 /* 350 */ "user_name ::= NK_ID",
 /* 351 */ "topic_name ::= NK_ID",
 /* 352 */ "stream_name ::= NK_ID",
 /* 353 */ "cgroup_name ::= NK_ID",
 /* 354 */ "index_name ::= NK_ID",
 /* 355 */ "expr_or_subquery ::= expression",
 /* 356 */ "expression ::= literal",
 /* 357 */ "expression ::= pseudo_column",
 /* 358 */ "expression ::= column_reference",
 /* 359 */ "expression ::= function_expression",
 /* 360 */ "expression ::= case_when_expression",
 /* 361 */ "expression ::= NK_LP expression NK_RP",
 /* 362 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 363 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 364 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 365 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 366 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 367 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 368 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 369 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 370 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 371 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 372 */ "expression_list ::= expr_or_subquery",
 /* 373 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 374 */ "column_reference ::= column_name",
 /* 375 */ "column_reference ::= table_name NK_DOT column_name",
 /* 376 */ "pseudo_column ::= ROWTS",
 /* 377 */ "pseudo_column ::= TBNAME",
 /* 378 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 379 */ "pseudo_column ::= QSTART",
 /* 380 */ "pseudo_column ::= QEND",
 /* 381 */ "pseudo_column ::= QDURATION",
 /* 382 */ "pseudo_column ::= WSTART",
 /* 383 */ "pseudo_column ::= WEND",
 /* 384 */ "pseudo_column ::= WDURATION",
 /* 385 */ "pseudo_column ::= IROWTS",
 /* 386 */ "pseudo_column ::= QTAGS",
 /* 387 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 388 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 389 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 390 */ "function_expression ::= literal_func",
 /* 391 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 392 */ "literal_func ::= NOW",
 /* 393 */ "noarg_func ::= NOW",
 /* 394 */ "noarg_func ::= TODAY",
 /* 395 */ "noarg_func ::= TIMEZONE",
 /* 396 */ "noarg_func ::= DATABASE",
 /* 397 */ "noarg_func ::= CLIENT_VERSION",
 /* 398 */ "noarg_func ::= SERVER_VERSION",
 /* 399 */ "noarg_func ::= SERVER_STATUS",
 /* 400 */ "noarg_func ::= CURRENT_USER",
 /* 401 */ "noarg_func ::= USER",
 /* 402 */ "star_func ::= COUNT",
 /* 403 */ "star_func ::= FIRST",
 /* 404 */ "star_func ::= LAST",
 /* 405 */ "star_func ::= LAST_ROW",
 /* 406 */ "star_func_para_list ::= NK_STAR",
 /* 407 */ "star_func_para_list ::= other_para_list",
 /* 408 */ "other_para_list ::= star_func_para",
 /* 409 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 410 */ "star_func_para ::= expr_or_subquery",
 /* 411 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 412 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 413 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 414 */ "when_then_list ::= when_then_expr",
 /* 415 */ "when_then_list ::= when_then_list when_then_expr",
 /* 416 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 417 */ "case_when_else_opt ::=",
 /* 418 */ "case_when_else_opt ::= ELSE common_expression",
 /* 419 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 420 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 421 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 422 */ "predicate ::= expr_or_subquery IS NULL",
 /* 423 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 424 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 425 */ "compare_op ::= NK_LT",
 /* 426 */ "compare_op ::= NK_GT",
 /* 427 */ "compare_op ::= NK_LE",
 /* 428 */ "compare_op ::= NK_GE",
 /* 429 */ "compare_op ::= NK_NE",
 /* 430 */ "compare_op ::= NK_EQ",
 /* 431 */ "compare_op ::= LIKE",
 /* 432 */ "compare_op ::= NOT LIKE",
 /* 433 */ "compare_op ::= MATCH",
 /* 434 */ "compare_op ::= NMATCH",
 /* 435 */ "compare_op ::= CONTAINS",
 /* 436 */ "in_op ::= IN",
 /* 437 */ "in_op ::= NOT IN",
 /* 438 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 439 */ "boolean_value_expression ::= boolean_primary",
 /* 440 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 441 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 442 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 443 */ "boolean_primary ::= predicate",
 /* 444 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 445 */ "common_expression ::= expr_or_subquery",
 /* 446 */ "common_expression ::= boolean_value_expression",
 /* 447 */ "from_clause_opt ::=",
 /* 448 */ "from_clause_opt ::= FROM table_reference_list",
 /* 449 */ "table_reference_list ::= table_reference",
 /* 450 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 451 */ "table_reference ::= table_primary",
 /* 452 */ "table_reference ::= joined_table",
 /* 453 */ "table_primary ::= table_name alias_opt",
 /* 454 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 455 */ "table_primary ::= subquery alias_opt",
 /* 456 */ "table_primary ::= parenthesized_joined_table",
 /* 457 */ "alias_opt ::=",
 /* 458 */ "alias_opt ::= table_alias",
 /* 459 */ "alias_opt ::= AS table_alias",
 /* 460 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 461 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 462 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 463 */ "join_type ::=",
 /* 464 */ "join_type ::= INNER",
 /* 465 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 466 */ "set_quantifier_opt ::=",
 /* 467 */ "set_quantifier_opt ::= DISTINCT",
 /* 468 */ "set_quantifier_opt ::= ALL",
 /* 469 */ "select_list ::= select_item",
 /* 470 */ "select_list ::= select_list NK_COMMA select_item",
 /* 471 */ "select_item ::= NK_STAR",
 /* 472 */ "select_item ::= common_expression",
 /* 473 */ "select_item ::= common_expression column_alias",
 /* 474 */ "select_item ::= common_expression AS column_alias",
 /* 475 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 476 */ "where_clause_opt ::=",
 /* 477 */ "where_clause_opt ::= WHERE search_condition",
 /* 478 */ "partition_by_clause_opt ::=",
 /* 479 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 480 */ "partition_list ::= partition_item",
 /* 481 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 482 */ "partition_item ::= expr_or_subquery",
 /* 483 */ "partition_item ::= expr_or_subquery column_alias",
 /* 484 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 485 */ "twindow_clause_opt ::=",
 /* 486 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 487 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 488 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 489 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 490 */ "sliding_opt ::=",
 /* 491 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 492 */ "fill_opt ::=",
 /* 493 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 494 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 495 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP",
 /* 496 */ "fill_mode ::= NONE",
 /* 497 */ "fill_mode ::= PREV",
 /* 498 */ "fill_mode ::= NULL",
 /* 499 */ "fill_mode ::= NULL_F",
 /* 500 */ "fill_mode ::= LINEAR",
 /* 501 */ "fill_mode ::= NEXT",
 /* 502 */ "group_by_clause_opt ::=",
 /* 503 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 504 */ "group_by_list ::= expr_or_subquery",
 /* 505 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 506 */ "having_clause_opt ::=",
 /* 507 */ "having_clause_opt ::= HAVING search_condition",
 /* 508 */ "range_opt ::=",
 /* 509 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 510 */ "every_opt ::=",
 /* 511 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 512 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 513 */ "query_simple ::= query_specification",
 /* 514 */ "query_simple ::= union_query_expression",
 /* 515 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 516 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 517 */ "query_simple_or_subquery ::= query_simple",
 /* 518 */ "query_simple_or_subquery ::= subquery",
 /* 519 */ "query_or_subquery ::= query_expression",
 /* 520 */ "query_or_subquery ::= subquery",
 /* 521 */ "order_by_clause_opt ::=",
 /* 522 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 523 */ "slimit_clause_opt ::=",
 /* 524 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 525 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 526 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 527 */ "limit_clause_opt ::=",
 /* 528 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 529 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 530 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 531 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 532 */ "subquery ::= NK_LP subquery NK_RP",
 /* 533 */ "search_condition ::= common_expression",
 /* 534 */ "sort_specification_list ::= sort_specification",
 /* 535 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 536 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 537 */ "ordering_specification_opt ::=",
 /* 538 */ "ordering_specification_opt ::= ASC",
 /* 539 */ "ordering_specification_opt ::= DESC",
 /* 540 */ "null_ordering_opt ::=",
 /* 541 */ "null_ordering_opt ::= NULLS FIRST",
 /* 542 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 324: /* cmd */
    case 327: /* literal */
    case 340: /* db_options */
    case 342: /* alter_db_options */
    case 348: /* retention */
    case 349: /* full_table_name */
    case 352: /* table_options */
    case 356: /* alter_table_clause */
    case 357: /* alter_table_options */
    case 360: /* signed_literal */
    case 361: /* create_subtable_clause */
    case 364: /* drop_table_clause */
    case 367: /* column_def */
    case 371: /* duration_literal */
    case 372: /* rollup_func_name */
    case 374: /* col_name */
    case 375: /* db_name_cond_opt */
    case 376: /* like_pattern_opt */
    case 377: /* table_name_cond */
    case 378: /* from_db_opt */
    case 380: /* tag_item */
    case 382: /* full_index_name */
    case 383: /* index_options */
    case 386: /* sliding_opt */
    case 387: /* sma_stream_opt */
    case 388: /* func */
    case 389: /* query_or_subquery */
    case 392: /* explain_options */
    case 396: /* stream_options */
    case 397: /* subtable_opt */
    case 398: /* expression */
    case 400: /* where_clause_opt */
    case 401: /* signed */
    case 402: /* literal_func */
    case 405: /* expr_or_subquery */
    case 406: /* pseudo_column */
    case 407: /* column_reference */
    case 408: /* function_expression */
    case 409: /* case_when_expression */
    case 414: /* star_func_para */
    case 416: /* case_when_else_opt */
    case 417: /* common_expression */
    case 418: /* when_then_expr */
    case 419: /* predicate */
    case 422: /* in_predicate_value */
    case 423: /* boolean_value_expression */
    case 424: /* boolean_primary */
    case 425: /* from_clause_opt */
    case 426: /* table_reference_list */
    case 427: /* table_reference */
    case 428: /* table_primary */
    case 429: /* joined_table */
    case 431: /* subquery */
    case 432: /* parenthesized_joined_table */
    case 434: /* search_condition */
    case 435: /* query_specification */
    case 439: /* range_opt */
    case 440: /* every_opt */
    case 441: /* fill_opt */
    case 442: /* twindow_clause_opt */
    case 444: /* having_clause_opt */
    case 445: /* select_item */
    case 447: /* partition_item */
    case 450: /* query_expression */
    case 451: /* query_simple */
    case 453: /* slimit_clause_opt */
    case 454: /* limit_clause_opt */
    case 455: /* union_query_expression */
    case 456: /* query_simple_or_subquery */
    case 458: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy600)); 
}
      break;
    case 325: /* account_options */
    case 326: /* alter_account_options */
    case 328: /* alter_account_option */
    case 343: /* speed_opt */
    case 394: /* bufsize_opt */
{
 
}
      break;
    case 329: /* user_name */
    case 332: /* priv_level */
    case 335: /* db_name */
    case 336: /* topic_name */
    case 337: /* dnode_endpoint */
    case 358: /* column_name */
    case 366: /* table_name */
    case 373: /* function_name */
    case 381: /* column_alias */
    case 384: /* index_name */
    case 390: /* cgroup_name */
    case 395: /* stream_name */
    case 404: /* table_alias */
    case 410: /* star_func */
    case 412: /* noarg_func */
    case 430: /* alias_opt */
{
 
}
      break;
    case 330: /* sysinfo_opt */
{
 
}
      break;
    case 331: /* privileges */
    case 333: /* priv_type_list */
    case 334: /* priv_type */
{
 
}
      break;
    case 338: /* force_opt */
    case 339: /* not_exists_opt */
    case 341: /* exists_opt */
    case 391: /* analyze_opt */
    case 393: /* agg_func_opt */
    case 436: /* set_quantifier_opt */
{
 
}
      break;
    case 344: /* integer_list */
    case 345: /* variable_list */
    case 346: /* retention_list */
    case 350: /* column_def_list */
    case 351: /* tags_def_opt */
    case 353: /* multi_create_clause */
    case 354: /* tags_def */
    case 355: /* multi_drop_clause */
    case 362: /* specific_cols_opt */
    case 363: /* expression_list */
    case 365: /* col_name_list */
    case 368: /* duration_list */
    case 369: /* rollup_func_list */
    case 379: /* tag_list_opt */
    case 385: /* func_list */
    case 399: /* dnode_list */
    case 403: /* literal_list */
    case 411: /* star_func_para_list */
    case 413: /* other_para_list */
    case 415: /* when_then_list */
    case 437: /* select_list */
    case 438: /* partition_by_clause_opt */
    case 443: /* group_by_clause_opt */
    case 446: /* partition_list */
    case 449: /* group_by_list */
    case 452: /* order_by_clause_opt */
    case 457: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy601)); 
}
      break;
    case 347: /* alter_db_option */
    case 370: /* alter_table_option */
{
 
}
      break;
    case 359: /* type_name */
{
 
}
      break;
    case 420: /* compare_op */
    case 421: /* in_op */
{
 
}
      break;
    case 433: /* join_type */
{
 
}
      break;
    case 448: /* fill_mode */
{
 
}
      break;
    case 459: /* ordering_specification_opt */
{
 
}
      break;
    case 460: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<sizeof(yy_action)/sizeof(yy_action[0]) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
   324,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   324,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
   325,  /* (2) account_options ::= */
   325,  /* (3) account_options ::= account_options PPS literal */
   325,  /* (4) account_options ::= account_options TSERIES literal */
   325,  /* (5) account_options ::= account_options STORAGE literal */
   325,  /* (6) account_options ::= account_options STREAMS literal */
   325,  /* (7) account_options ::= account_options QTIME literal */
   325,  /* (8) account_options ::= account_options DBS literal */
   325,  /* (9) account_options ::= account_options USERS literal */
   325,  /* (10) account_options ::= account_options CONNS literal */
   325,  /* (11) account_options ::= account_options STATE literal */
   326,  /* (12) alter_account_options ::= alter_account_option */
   326,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   328,  /* (14) alter_account_option ::= PASS literal */
   328,  /* (15) alter_account_option ::= PPS literal */
   328,  /* (16) alter_account_option ::= TSERIES literal */
   328,  /* (17) alter_account_option ::= STORAGE literal */
   328,  /* (18) alter_account_option ::= STREAMS literal */
   328,  /* (19) alter_account_option ::= QTIME literal */
   328,  /* (20) alter_account_option ::= DBS literal */
   328,  /* (21) alter_account_option ::= USERS literal */
   328,  /* (22) alter_account_option ::= CONNS literal */
   328,  /* (23) alter_account_option ::= STATE literal */
   324,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   324,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   324,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   324,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   324,  /* (28) cmd ::= DROP USER user_name */
   330,  /* (29) sysinfo_opt ::= */
   330,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   324,  /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
   324,  /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
   331,  /* (33) privileges ::= ALL */
   331,  /* (34) privileges ::= priv_type_list */
   331,  /* (35) privileges ::= SUBSCRIBE */
   333,  /* (36) priv_type_list ::= priv_type */
   333,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   334,  /* (38) priv_type ::= READ */
   334,  /* (39) priv_type ::= WRITE */
   332,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   332,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   332,  /* (42) priv_level ::= topic_name */
   324,  /* (43) cmd ::= CREATE DNODE dnode_endpoint */
   324,  /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   324,  /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
   324,  /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
   324,  /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   324,  /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   324,  /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
   324,  /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   337,  /* (51) dnode_endpoint ::= NK_STRING */
   337,  /* (52) dnode_endpoint ::= NK_ID */
   337,  /* (53) dnode_endpoint ::= NK_IPTOKEN */
   338,  /* (54) force_opt ::= */
   338,  /* (55) force_opt ::= FORCE */
   324,  /* (56) cmd ::= ALTER LOCAL NK_STRING */
   324,  /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   324,  /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   324,  /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   324,  /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   324,  /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   324,  /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   324,  /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   324,  /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   324,  /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   324,  /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   324,  /* (67) cmd ::= DROP DATABASE exists_opt db_name */
   324,  /* (68) cmd ::= USE db_name */
   324,  /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
   324,  /* (70) cmd ::= FLUSH DATABASE db_name */
   324,  /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
   339,  /* (72) not_exists_opt ::= IF NOT EXISTS */
   339,  /* (73) not_exists_opt ::= */
   341,  /* (74) exists_opt ::= IF EXISTS */
   341,  /* (75) exists_opt ::= */
   340,  /* (76) db_options ::= */
   340,  /* (77) db_options ::= db_options BUFFER NK_INTEGER */
   340,  /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
   340,  /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
   340,  /* (80) db_options ::= db_options COMP NK_INTEGER */
   340,  /* (81) db_options ::= db_options DURATION NK_INTEGER */
   340,  /* (82) db_options ::= db_options DURATION NK_VARIABLE */
   340,  /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
   340,  /* (84) db_options ::= db_options MINROWS NK_INTEGER */
   340,  /* (85) db_options ::= db_options KEEP integer_list */
   340,  /* (86) db_options ::= db_options KEEP variable_list */
   340,  /* (87) db_options ::= db_options PAGES NK_INTEGER */
   340,  /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
   340,  /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   340,  /* (90) db_options ::= db_options PRECISION NK_STRING */
   340,  /* (91) db_options ::= db_options REPLICA NK_INTEGER */
   340,  /* (92) db_options ::= db_options VGROUPS NK_INTEGER */
   340,  /* (93) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   340,  /* (94) db_options ::= db_options RETENTIONS retention_list */
   340,  /* (95) db_options ::= db_options SCHEMALESS NK_INTEGER */
   340,  /* (96) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   340,  /* (97) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   340,  /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   340,  /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   340,  /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   340,  /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   340,  /* (102) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   340,  /* (103) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   340,  /* (104) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   340,  /* (105) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
   340,  /* (106) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
   342,  /* (107) alter_db_options ::= alter_db_option */
   342,  /* (108) alter_db_options ::= alter_db_options alter_db_option */
   347,  /* (109) alter_db_option ::= BUFFER NK_INTEGER */
   347,  /* (110) alter_db_option ::= CACHEMODEL NK_STRING */
   347,  /* (111) alter_db_option ::= CACHESIZE NK_INTEGER */
   347,  /* (112) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   347,  /* (113) alter_db_option ::= KEEP integer_list */
   347,  /* (114) alter_db_option ::= KEEP variable_list */
   347,  /* (115) alter_db_option ::= PAGES NK_INTEGER */
   347,  /* (116) alter_db_option ::= REPLICA NK_INTEGER */
   347,  /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   347,  /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   344,  /* (119) integer_list ::= NK_INTEGER */
   344,  /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   345,  /* (121) variable_list ::= NK_VARIABLE */
   345,  /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   346,  /* (123) retention_list ::= retention */
   346,  /* (124) retention_list ::= retention_list NK_COMMA retention */
   348,  /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
   343,  /* (126) speed_opt ::= */
   343,  /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
   324,  /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   324,  /* (129) cmd ::= CREATE TABLE multi_create_clause */
   324,  /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   324,  /* (131) cmd ::= DROP TABLE multi_drop_clause */
   324,  /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
   324,  /* (133) cmd ::= ALTER TABLE alter_table_clause */
   324,  /* (134) cmd ::= ALTER STABLE alter_table_clause */
   356,  /* (135) alter_table_clause ::= full_table_name alter_table_options */
   356,  /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   356,  /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   356,  /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   356,  /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   356,  /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   356,  /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
   356,  /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   356,  /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   356,  /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   353,  /* (145) multi_create_clause ::= create_subtable_clause */
   353,  /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
   361,  /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   355,  /* (148) multi_drop_clause ::= drop_table_clause */
   355,  /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
   364,  /* (150) drop_table_clause ::= exists_opt full_table_name */
   362,  /* (151) specific_cols_opt ::= */
   362,  /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   349,  /* (153) full_table_name ::= table_name */
   349,  /* (154) full_table_name ::= db_name NK_DOT table_name */
   350,  /* (155) column_def_list ::= column_def */
   350,  /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
   367,  /* (157) column_def ::= column_name type_name */
   367,  /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
   359,  /* (159) type_name ::= BOOL */
   359,  /* (160) type_name ::= TINYINT */
   359,  /* (161) type_name ::= SMALLINT */
   359,  /* (162) type_name ::= INT */
   359,  /* (163) type_name ::= INTEGER */
   359,  /* (164) type_name ::= BIGINT */
   359,  /* (165) type_name ::= FLOAT */
   359,  /* (166) type_name ::= DOUBLE */
   359,  /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   359,  /* (168) type_name ::= TIMESTAMP */
   359,  /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   359,  /* (170) type_name ::= TINYINT UNSIGNED */
   359,  /* (171) type_name ::= SMALLINT UNSIGNED */
   359,  /* (172) type_name ::= INT UNSIGNED */
   359,  /* (173) type_name ::= BIGINT UNSIGNED */
   359,  /* (174) type_name ::= JSON */
   359,  /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   359,  /* (176) type_name ::= MEDIUMBLOB */
   359,  /* (177) type_name ::= BLOB */
   359,  /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   359,  /* (179) type_name ::= DECIMAL */
   359,  /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   359,  /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
   351,  /* (182) tags_def_opt ::= */
   351,  /* (183) tags_def_opt ::= tags_def */
   354,  /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
   352,  /* (185) table_options ::= */
   352,  /* (186) table_options ::= table_options COMMENT NK_STRING */
   352,  /* (187) table_options ::= table_options MAX_DELAY duration_list */
   352,  /* (188) table_options ::= table_options WATERMARK duration_list */
   352,  /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   352,  /* (190) table_options ::= table_options TTL NK_INTEGER */
   352,  /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   352,  /* (192) table_options ::= table_options DELETE_MARK duration_list */
   357,  /* (193) alter_table_options ::= alter_table_option */
   357,  /* (194) alter_table_options ::= alter_table_options alter_table_option */
   370,  /* (195) alter_table_option ::= COMMENT NK_STRING */
   370,  /* (196) alter_table_option ::= TTL NK_INTEGER */
   368,  /* (197) duration_list ::= duration_literal */
   368,  /* (198) duration_list ::= duration_list NK_COMMA duration_literal */
   369,  /* (199) rollup_func_list ::= rollup_func_name */
   369,  /* (200) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   372,  /* (201) rollup_func_name ::= function_name */
   372,  /* (202) rollup_func_name ::= FIRST */
   372,  /* (203) rollup_func_name ::= LAST */
   365,  /* (204) col_name_list ::= col_name */
   365,  /* (205) col_name_list ::= col_name_list NK_COMMA col_name */
   374,  /* (206) col_name ::= column_name */
   324,  /* (207) cmd ::= SHOW DNODES */
   324,  /* (208) cmd ::= SHOW USERS */
   324,  /* (209) cmd ::= SHOW USER PRIVILEGES */
   324,  /* (210) cmd ::= SHOW DATABASES */
   324,  /* (211) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   324,  /* (212) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   324,  /* (213) cmd ::= SHOW db_name_cond_opt VGROUPS */
   324,  /* (214) cmd ::= SHOW MNODES */
   324,  /* (215) cmd ::= SHOW QNODES */
   324,  /* (216) cmd ::= SHOW FUNCTIONS */
   324,  /* (217) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   324,  /* (218) cmd ::= SHOW STREAMS */
   324,  /* (219) cmd ::= SHOW ACCOUNTS */
   324,  /* (220) cmd ::= SHOW APPS */
   324,  /* (221) cmd ::= SHOW CONNECTIONS */
   324,  /* (222) cmd ::= SHOW LICENCES */
   324,  /* (223) cmd ::= SHOW GRANTS */
   324,  /* (224) cmd ::= SHOW CREATE DATABASE db_name */
   324,  /* (225) cmd ::= SHOW CREATE TABLE full_table_name */
   324,  /* (226) cmd ::= SHOW CREATE STABLE full_table_name */
   324,  /* (227) cmd ::= SHOW QUERIES */
   324,  /* (228) cmd ::= SHOW SCORES */
   324,  /* (229) cmd ::= SHOW TOPICS */
   324,  /* (230) cmd ::= SHOW VARIABLES */
   324,  /* (231) cmd ::= SHOW CLUSTER VARIABLES */
   324,  /* (232) cmd ::= SHOW LOCAL VARIABLES */
   324,  /* (233) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   324,  /* (234) cmd ::= SHOW BNODES */
   324,  /* (235) cmd ::= SHOW SNODES */
   324,  /* (236) cmd ::= SHOW CLUSTER */
   324,  /* (237) cmd ::= SHOW TRANSACTIONS */
   324,  /* (238) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   324,  /* (239) cmd ::= SHOW CONSUMERS */
   324,  /* (240) cmd ::= SHOW SUBSCRIPTIONS */
   324,  /* (241) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   324,  /* (242) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   324,  /* (243) cmd ::= SHOW VNODES NK_INTEGER */
   324,  /* (244) cmd ::= SHOW VNODES NK_STRING */
   375,  /* (245) db_name_cond_opt ::= */
   375,  /* (246) db_name_cond_opt ::= db_name NK_DOT */
   376,  /* (247) like_pattern_opt ::= */
   376,  /* (248) like_pattern_opt ::= LIKE NK_STRING */
   377,  /* (249) table_name_cond ::= table_name */
   378,  /* (250) from_db_opt ::= */
   378,  /* (251) from_db_opt ::= FROM db_name */
   379,  /* (252) tag_list_opt ::= */
   379,  /* (253) tag_list_opt ::= tag_item */
   379,  /* (254) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   380,  /* (255) tag_item ::= TBNAME */
   380,  /* (256) tag_item ::= QTAGS */
   380,  /* (257) tag_item ::= column_name */
   380,  /* (258) tag_item ::= column_name column_alias */
   380,  /* (259) tag_item ::= column_name AS column_alias */
   324,  /* (260) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
   324,  /* (261) cmd ::= DROP INDEX exists_opt full_index_name */
   382,  /* (262) full_index_name ::= index_name */
   382,  /* (263) full_index_name ::= db_name NK_DOT index_name */
   383,  /* (264) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
   383,  /* (265) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   385,  /* (266) func_list ::= func */
   385,  /* (267) func_list ::= func_list NK_COMMA func */
   388,  /* (268) func ::= function_name NK_LP expression_list NK_RP */
   387,  /* (269) sma_stream_opt ::= */
   387,  /* (270) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   387,  /* (271) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   387,  /* (272) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   324,  /* (273) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   324,  /* (274) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   324,  /* (275) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   324,  /* (276) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
   324,  /* (277) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
   324,  /* (278) cmd ::= DROP TOPIC exists_opt topic_name */
   324,  /* (279) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   324,  /* (280) cmd ::= DESC full_table_name */
   324,  /* (281) cmd ::= DESCRIBE full_table_name */
   324,  /* (282) cmd ::= RESET QUERY CACHE */
   324,  /* (283) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   391,  /* (284) analyze_opt ::= */
   391,  /* (285) analyze_opt ::= ANALYZE */
   392,  /* (286) explain_options ::= */
   392,  /* (287) explain_options ::= explain_options VERBOSE NK_BOOL */
   392,  /* (288) explain_options ::= explain_options RATIO NK_FLOAT */
   324,  /* (289) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
   324,  /* (290) cmd ::= DROP FUNCTION exists_opt function_name */
   393,  /* (291) agg_func_opt ::= */
   393,  /* (292) agg_func_opt ::= AGGREGATE */
   394,  /* (293) bufsize_opt ::= */
   394,  /* (294) bufsize_opt ::= BUFSIZE NK_INTEGER */
   324,  /* (295) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
   324,  /* (296) cmd ::= DROP STREAM exists_opt stream_name */
   396,  /* (297) stream_options ::= */
   396,  /* (298) stream_options ::= stream_options TRIGGER AT_ONCE */
   396,  /* (299) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   396,  /* (300) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   396,  /* (301) stream_options ::= stream_options WATERMARK duration_literal */
   396,  /* (302) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   396,  /* (303) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   397,  /* (304) subtable_opt ::= */
   397,  /* (305) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
   324,  /* (306) cmd ::= KILL CONNECTION NK_INTEGER */
   324,  /* (307) cmd ::= KILL QUERY NK_STRING */
   324,  /* (308) cmd ::= KILL TRANSACTION NK_INTEGER */
   324,  /* (309) cmd ::= BALANCE VGROUP */
   324,  /* (310) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   324,  /* (311) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   324,  /* (312) cmd ::= SPLIT VGROUP NK_INTEGER */
   399,  /* (313) dnode_list ::= DNODE NK_INTEGER */
   399,  /* (314) dnode_list ::= dnode_list DNODE NK_INTEGER */
   324,  /* (315) cmd ::= DELETE FROM full_table_name where_clause_opt */
   324,  /* (316) cmd ::= query_or_subquery */
   324,  /* (317) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   324,  /* (318) cmd ::= INSERT INTO full_table_name query_or_subquery */
   327,  /* (319) literal ::= NK_INTEGER */
   327,  /* (320) literal ::= NK_FLOAT */
   327,  /* (321) literal ::= NK_STRING */
   327,  /* (322) literal ::= NK_BOOL */
   327,  /* (323) literal ::= TIMESTAMP NK_STRING */
   327,  /* (324) literal ::= duration_literal */
   327,  /* (325) literal ::= NULL */
   327,  /* (326) literal ::= NK_QUESTION */
   371,  /* (327) duration_literal ::= NK_VARIABLE */
   401,  /* (328) signed ::= NK_INTEGER */
   401,  /* (329) signed ::= NK_PLUS NK_INTEGER */
   401,  /* (330) signed ::= NK_MINUS NK_INTEGER */
   401,  /* (331) signed ::= NK_FLOAT */
   401,  /* (332) signed ::= NK_PLUS NK_FLOAT */
   401,  /* (333) signed ::= NK_MINUS NK_FLOAT */
   360,  /* (334) signed_literal ::= signed */
   360,  /* (335) signed_literal ::= NK_STRING */
   360,  /* (336) signed_literal ::= NK_BOOL */
   360,  /* (337) signed_literal ::= TIMESTAMP NK_STRING */
   360,  /* (338) signed_literal ::= duration_literal */
   360,  /* (339) signed_literal ::= NULL */
   360,  /* (340) signed_literal ::= literal_func */
   360,  /* (341) signed_literal ::= NK_QUESTION */
   403,  /* (342) literal_list ::= signed_literal */
   403,  /* (343) literal_list ::= literal_list NK_COMMA signed_literal */
   335,  /* (344) db_name ::= NK_ID */
   366,  /* (345) table_name ::= NK_ID */
   358,  /* (346) column_name ::= NK_ID */
   373,  /* (347) function_name ::= NK_ID */
   404,  /* (348) table_alias ::= NK_ID */
   381,  /* (349) column_alias ::= NK_ID */
   329,  /* (350) user_name ::= NK_ID */
   336,  /* (351) topic_name ::= NK_ID */
   395,  /* (352) stream_name ::= NK_ID */
   390,  /* (353) cgroup_name ::= NK_ID */
   384,  /* (354) index_name ::= NK_ID */
   405,  /* (355) expr_or_subquery ::= expression */
   398,  /* (356) expression ::= literal */
   398,  /* (357) expression ::= pseudo_column */
   398,  /* (358) expression ::= column_reference */
   398,  /* (359) expression ::= function_expression */
   398,  /* (360) expression ::= case_when_expression */
   398,  /* (361) expression ::= NK_LP expression NK_RP */
   398,  /* (362) expression ::= NK_PLUS expr_or_subquery */
   398,  /* (363) expression ::= NK_MINUS expr_or_subquery */
   398,  /* (364) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   398,  /* (365) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   398,  /* (366) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   398,  /* (367) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   398,  /* (368) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   398,  /* (369) expression ::= column_reference NK_ARROW NK_STRING */
   398,  /* (370) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   398,  /* (371) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   363,  /* (372) expression_list ::= expr_or_subquery */
   363,  /* (373) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   407,  /* (374) column_reference ::= column_name */
   407,  /* (375) column_reference ::= table_name NK_DOT column_name */
   406,  /* (376) pseudo_column ::= ROWTS */
   406,  /* (377) pseudo_column ::= TBNAME */
   406,  /* (378) pseudo_column ::= table_name NK_DOT TBNAME */
   406,  /* (379) pseudo_column ::= QSTART */
   406,  /* (380) pseudo_column ::= QEND */
   406,  /* (381) pseudo_column ::= QDURATION */
   406,  /* (382) pseudo_column ::= WSTART */
   406,  /* (383) pseudo_column ::= WEND */
   406,  /* (384) pseudo_column ::= WDURATION */
   406,  /* (385) pseudo_column ::= IROWTS */
   406,  /* (386) pseudo_column ::= QTAGS */
   408,  /* (387) function_expression ::= function_name NK_LP expression_list NK_RP */
   408,  /* (388) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   408,  /* (389) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   408,  /* (390) function_expression ::= literal_func */
   402,  /* (391) literal_func ::= noarg_func NK_LP NK_RP */
   402,  /* (392) literal_func ::= NOW */
   412,  /* (393) noarg_func ::= NOW */
   412,  /* (394) noarg_func ::= TODAY */
   412,  /* (395) noarg_func ::= TIMEZONE */
   412,  /* (396) noarg_func ::= DATABASE */
   412,  /* (397) noarg_func ::= CLIENT_VERSION */
   412,  /* (398) noarg_func ::= SERVER_VERSION */
   412,  /* (399) noarg_func ::= SERVER_STATUS */
   412,  /* (400) noarg_func ::= CURRENT_USER */
   412,  /* (401) noarg_func ::= USER */
   410,  /* (402) star_func ::= COUNT */
   410,  /* (403) star_func ::= FIRST */
   410,  /* (404) star_func ::= LAST */
   410,  /* (405) star_func ::= LAST_ROW */
   411,  /* (406) star_func_para_list ::= NK_STAR */
   411,  /* (407) star_func_para_list ::= other_para_list */
   413,  /* (408) other_para_list ::= star_func_para */
   413,  /* (409) other_para_list ::= other_para_list NK_COMMA star_func_para */
   414,  /* (410) star_func_para ::= expr_or_subquery */
   414,  /* (411) star_func_para ::= table_name NK_DOT NK_STAR */
   409,  /* (412) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   409,  /* (413) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   415,  /* (414) when_then_list ::= when_then_expr */
   415,  /* (415) when_then_list ::= when_then_list when_then_expr */
   418,  /* (416) when_then_expr ::= WHEN common_expression THEN common_expression */
   416,  /* (417) case_when_else_opt ::= */
   416,  /* (418) case_when_else_opt ::= ELSE common_expression */
   419,  /* (419) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   419,  /* (420) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   419,  /* (421) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   419,  /* (422) predicate ::= expr_or_subquery IS NULL */
   419,  /* (423) predicate ::= expr_or_subquery IS NOT NULL */
   419,  /* (424) predicate ::= expr_or_subquery in_op in_predicate_value */
   420,  /* (425) compare_op ::= NK_LT */
   420,  /* (426) compare_op ::= NK_GT */
   420,  /* (427) compare_op ::= NK_LE */
   420,  /* (428) compare_op ::= NK_GE */
   420,  /* (429) compare_op ::= NK_NE */
   420,  /* (430) compare_op ::= NK_EQ */
   420,  /* (431) compare_op ::= LIKE */
   420,  /* (432) compare_op ::= NOT LIKE */
   420,  /* (433) compare_op ::= MATCH */
   420,  /* (434) compare_op ::= NMATCH */
   420,  /* (435) compare_op ::= CONTAINS */
   421,  /* (436) in_op ::= IN */
   421,  /* (437) in_op ::= NOT IN */
   422,  /* (438) in_predicate_value ::= NK_LP literal_list NK_RP */
   423,  /* (439) boolean_value_expression ::= boolean_primary */
   423,  /* (440) boolean_value_expression ::= NOT boolean_primary */
   423,  /* (441) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   423,  /* (442) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   424,  /* (443) boolean_primary ::= predicate */
   424,  /* (444) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   417,  /* (445) common_expression ::= expr_or_subquery */
   417,  /* (446) common_expression ::= boolean_value_expression */
   425,  /* (447) from_clause_opt ::= */
   425,  /* (448) from_clause_opt ::= FROM table_reference_list */
   426,  /* (449) table_reference_list ::= table_reference */
   426,  /* (450) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   427,  /* (451) table_reference ::= table_primary */
   427,  /* (452) table_reference ::= joined_table */
   428,  /* (453) table_primary ::= table_name alias_opt */
   428,  /* (454) table_primary ::= db_name NK_DOT table_name alias_opt */
   428,  /* (455) table_primary ::= subquery alias_opt */
   428,  /* (456) table_primary ::= parenthesized_joined_table */
   430,  /* (457) alias_opt ::= */
   430,  /* (458) alias_opt ::= table_alias */
   430,  /* (459) alias_opt ::= AS table_alias */
   432,  /* (460) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   432,  /* (461) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   429,  /* (462) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
   433,  /* (463) join_type ::= */
   433,  /* (464) join_type ::= INNER */
   435,  /* (465) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
   436,  /* (466) set_quantifier_opt ::= */
   436,  /* (467) set_quantifier_opt ::= DISTINCT */
   436,  /* (468) set_quantifier_opt ::= ALL */
   437,  /* (469) select_list ::= select_item */
   437,  /* (470) select_list ::= select_list NK_COMMA select_item */
   445,  /* (471) select_item ::= NK_STAR */
   445,  /* (472) select_item ::= common_expression */
   445,  /* (473) select_item ::= common_expression column_alias */
   445,  /* (474) select_item ::= common_expression AS column_alias */
   445,  /* (475) select_item ::= table_name NK_DOT NK_STAR */
   400,  /* (476) where_clause_opt ::= */
   400,  /* (477) where_clause_opt ::= WHERE search_condition */
   438,  /* (478) partition_by_clause_opt ::= */
   438,  /* (479) partition_by_clause_opt ::= PARTITION BY partition_list */
   446,  /* (480) partition_list ::= partition_item */
   446,  /* (481) partition_list ::= partition_list NK_COMMA partition_item */
   447,  /* (482) partition_item ::= expr_or_subquery */
   447,  /* (483) partition_item ::= expr_or_subquery column_alias */
   447,  /* (484) partition_item ::= expr_or_subquery AS column_alias */
   442,  /* (485) twindow_clause_opt ::= */
   442,  /* (486) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   442,  /* (487) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   442,  /* (488) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   442,  /* (489) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   386,  /* (490) sliding_opt ::= */
   386,  /* (491) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
   441,  /* (492) fill_opt ::= */
   441,  /* (493) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   441,  /* (494) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
   441,  /* (495) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
   448,  /* (496) fill_mode ::= NONE */
   448,  /* (497) fill_mode ::= PREV */
   448,  /* (498) fill_mode ::= NULL */
   448,  /* (499) fill_mode ::= NULL_F */
   448,  /* (500) fill_mode ::= LINEAR */
   448,  /* (501) fill_mode ::= NEXT */
   443,  /* (502) group_by_clause_opt ::= */
   443,  /* (503) group_by_clause_opt ::= GROUP BY group_by_list */
   449,  /* (504) group_by_list ::= expr_or_subquery */
   449,  /* (505) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
   444,  /* (506) having_clause_opt ::= */
   444,  /* (507) having_clause_opt ::= HAVING search_condition */
   439,  /* (508) range_opt ::= */
   439,  /* (509) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
   440,  /* (510) every_opt ::= */
   440,  /* (511) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   450,  /* (512) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   451,  /* (513) query_simple ::= query_specification */
   451,  /* (514) query_simple ::= union_query_expression */
   455,  /* (515) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   455,  /* (516) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   456,  /* (517) query_simple_or_subquery ::= query_simple */
   456,  /* (518) query_simple_or_subquery ::= subquery */
   389,  /* (519) query_or_subquery ::= query_expression */
   389,  /* (520) query_or_subquery ::= subquery */
   452,  /* (521) order_by_clause_opt ::= */
   452,  /* (522) order_by_clause_opt ::= ORDER BY sort_specification_list */
   453,  /* (523) slimit_clause_opt ::= */
   453,  /* (524) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   453,  /* (525) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   453,  /* (526) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   454,  /* (527) limit_clause_opt ::= */
   454,  /* (528) limit_clause_opt ::= LIMIT NK_INTEGER */
   454,  /* (529) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   454,  /* (530) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   431,  /* (531) subquery ::= NK_LP query_expression NK_RP */
   431,  /* (532) subquery ::= NK_LP subquery NK_RP */
   434,  /* (533) search_condition ::= common_expression */
   457,  /* (534) sort_specification_list ::= sort_specification */
   457,  /* (535) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   458,  /* (536) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
   459,  /* (537) ordering_specification_opt ::= */
   459,  /* (538) ordering_specification_opt ::= ASC */
   459,  /* (539) ordering_specification_opt ::= DESC */
   460,  /* (540) null_ordering_opt ::= */
   460,  /* (541) null_ordering_opt ::= NULLS FIRST */
   460,  /* (542) null_ordering_opt ::= NULLS LAST */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -6,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   -4,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
    0,  /* (2) account_options ::= */
   -3,  /* (3) account_options ::= account_options PPS literal */
   -3,  /* (4) account_options ::= account_options TSERIES literal */
   -3,  /* (5) account_options ::= account_options STORAGE literal */
   -3,  /* (6) account_options ::= account_options STREAMS literal */
   -3,  /* (7) account_options ::= account_options QTIME literal */
   -3,  /* (8) account_options ::= account_options DBS literal */
   -3,  /* (9) account_options ::= account_options USERS literal */
   -3,  /* (10) account_options ::= account_options CONNS literal */
   -3,  /* (11) account_options ::= account_options STATE literal */
   -1,  /* (12) alter_account_options ::= alter_account_option */
   -2,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   -2,  /* (14) alter_account_option ::= PASS literal */
   -2,  /* (15) alter_account_option ::= PPS literal */
   -2,  /* (16) alter_account_option ::= TSERIES literal */
   -2,  /* (17) alter_account_option ::= STORAGE literal */
   -2,  /* (18) alter_account_option ::= STREAMS literal */
   -2,  /* (19) alter_account_option ::= QTIME literal */
   -2,  /* (20) alter_account_option ::= DBS literal */
   -2,  /* (21) alter_account_option ::= USERS literal */
   -2,  /* (22) alter_account_option ::= CONNS literal */
   -2,  /* (23) alter_account_option ::= STATE literal */
   -6,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   -5,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   -5,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   -5,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   -3,  /* (28) cmd ::= DROP USER user_name */
    0,  /* (29) sysinfo_opt ::= */
   -2,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   -6,  /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
   -6,  /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
   -1,  /* (33) privileges ::= ALL */
   -1,  /* (34) privileges ::= priv_type_list */
   -1,  /* (35) privileges ::= SUBSCRIBE */
   -1,  /* (36) priv_type_list ::= priv_type */
   -3,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   -1,  /* (38) priv_type ::= READ */
   -1,  /* (39) priv_type ::= WRITE */
   -3,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   -3,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   -1,  /* (42) priv_level ::= topic_name */
   -3,  /* (43) cmd ::= CREATE DNODE dnode_endpoint */
   -5,  /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   -4,  /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
   -4,  /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
   -4,  /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   -5,  /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   -4,  /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
   -5,  /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   -1,  /* (51) dnode_endpoint ::= NK_STRING */
   -1,  /* (52) dnode_endpoint ::= NK_ID */
   -1,  /* (53) dnode_endpoint ::= NK_IPTOKEN */
    0,  /* (54) force_opt ::= */
   -1,  /* (55) force_opt ::= FORCE */
   -3,  /* (56) cmd ::= ALTER LOCAL NK_STRING */
   -4,  /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   -5,  /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   -5,  /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   -5,  /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   -5,  /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   -5,  /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   -5,  /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   -5,  /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   -5,  /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   -5,  /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   -4,  /* (67) cmd ::= DROP DATABASE exists_opt db_name */
   -2,  /* (68) cmd ::= USE db_name */
   -4,  /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
   -3,  /* (70) cmd ::= FLUSH DATABASE db_name */
   -4,  /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
   -3,  /* (72) not_exists_opt ::= IF NOT EXISTS */
    0,  /* (73) not_exists_opt ::= */
   -2,  /* (74) exists_opt ::= IF EXISTS */
    0,  /* (75) exists_opt ::= */
    0,  /* (76) db_options ::= */
   -3,  /* (77) db_options ::= db_options BUFFER NK_INTEGER */
   -3,  /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
   -3,  /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
   -3,  /* (80) db_options ::= db_options COMP NK_INTEGER */
   -3,  /* (81) db_options ::= db_options DURATION NK_INTEGER */
   -3,  /* (82) db_options ::= db_options DURATION NK_VARIABLE */
   -3,  /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
   -3,  /* (84) db_options ::= db_options MINROWS NK_INTEGER */
   -3,  /* (85) db_options ::= db_options KEEP integer_list */
   -3,  /* (86) db_options ::= db_options KEEP variable_list */
   -3,  /* (87) db_options ::= db_options PAGES NK_INTEGER */
   -3,  /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
   -3,  /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   -3,  /* (90) db_options ::= db_options PRECISION NK_STRING */
   -3,  /* (91) db_options ::= db_options REPLICA NK_INTEGER */
   -3,  /* (92) db_options ::= db_options VGROUPS NK_INTEGER */
   -3,  /* (93) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   -3,  /* (94) db_options ::= db_options RETENTIONS retention_list */
   -3,  /* (95) db_options ::= db_options SCHEMALESS NK_INTEGER */
   -3,  /* (96) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   -3,  /* (97) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   -3,  /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   -4,  /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -3,  /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   -4,  /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -3,  /* (102) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   -3,  /* (103) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   -3,  /* (104) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   -3,  /* (105) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
   -3,  /* (106) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
   -1,  /* (107) alter_db_options ::= alter_db_option */
   -2,  /* (108) alter_db_options ::= alter_db_options alter_db_option */
   -2,  /* (109) alter_db_option ::= BUFFER NK_INTEGER */
   -2,  /* (110) alter_db_option ::= CACHEMODEL NK_STRING */
   -2,  /* (111) alter_db_option ::= CACHESIZE NK_INTEGER */
   -2,  /* (112) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   -2,  /* (113) alter_db_option ::= KEEP integer_list */
   -2,  /* (114) alter_db_option ::= KEEP variable_list */
   -2,  /* (115) alter_db_option ::= PAGES NK_INTEGER */
   -2,  /* (116) alter_db_option ::= REPLICA NK_INTEGER */
   -2,  /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   -2,  /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   -1,  /* (119) integer_list ::= NK_INTEGER */
   -3,  /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   -1,  /* (121) variable_list ::= NK_VARIABLE */
   -3,  /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   -1,  /* (123) retention_list ::= retention */
   -3,  /* (124) retention_list ::= retention_list NK_COMMA retention */
   -3,  /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
    0,  /* (126) speed_opt ::= */
   -2,  /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
   -9,  /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   -3,  /* (129) cmd ::= CREATE TABLE multi_create_clause */
   -9,  /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   -3,  /* (131) cmd ::= DROP TABLE multi_drop_clause */
   -4,  /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
   -3,  /* (133) cmd ::= ALTER TABLE alter_table_clause */
   -3,  /* (134) cmd ::= ALTER STABLE alter_table_clause */
   -2,  /* (135) alter_table_clause ::= full_table_name alter_table_options */
   -5,  /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   -4,  /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   -5,  /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   -5,  /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   -5,  /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   -4,  /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
   -5,  /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   -5,  /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   -6,  /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   -1,  /* (145) multi_create_clause ::= create_subtable_clause */
   -2,  /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
  -10,  /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   -1,  /* (148) multi_drop_clause ::= drop_table_clause */
   -2,  /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
   -2,  /* (150) drop_table_clause ::= exists_opt full_table_name */
    0,  /* (151) specific_cols_opt ::= */
   -3,  /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   -1,  /* (153) full_table_name ::= table_name */
   -3,  /* (154) full_table_name ::= db_name NK_DOT table_name */
   -1,  /* (155) column_def_list ::= column_def */
   -3,  /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
   -2,  /* (157) column_def ::= column_name type_name */
   -4,  /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
   -1,  /* (159) type_name ::= BOOL */
   -1,  /* (160) type_name ::= TINYINT */
   -1,  /* (161) type_name ::= SMALLINT */
   -1,  /* (162) type_name ::= INT */
   -1,  /* (163) type_name ::= INTEGER */
   -1,  /* (164) type_name ::= BIGINT */
   -1,  /* (165) type_name ::= FLOAT */
   -1,  /* (166) type_name ::= DOUBLE */
   -4,  /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (168) type_name ::= TIMESTAMP */
   -4,  /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   -2,  /* (170) type_name ::= TINYINT UNSIGNED */
   -2,  /* (171) type_name ::= SMALLINT UNSIGNED */
   -2,  /* (172) type_name ::= INT UNSIGNED */
   -2,  /* (173) type_name ::= BIGINT UNSIGNED */
   -1,  /* (174) type_name ::= JSON */
   -4,  /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   -1,  /* (176) type_name ::= MEDIUMBLOB */
   -1,  /* (177) type_name ::= BLOB */
   -4,  /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (179) type_name ::= DECIMAL */
   -4,  /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   -6,  /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
    0,  /* (182) tags_def_opt ::= */
   -1,  /* (183) tags_def_opt ::= tags_def */
   -4,  /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
    0,  /* (185) table_options ::= */
   -3,  /* (186) table_options ::= table_options COMMENT NK_STRING */
   -3,  /* (187) table_options ::= table_options MAX_DELAY duration_list */
   -3,  /* (188) table_options ::= table_options WATERMARK duration_list */
   -5,  /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   -3,  /* (190) table_options ::= table_options TTL NK_INTEGER */
   -5,  /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   -3,  /* (192) table_options ::= table_options DELETE_MARK duration_list */
   -1,  /* (193) alter_table_options ::= alter_table_option */
   -2,  /* (194) alter_table_options ::= alter_table_options alter_table_option */
   -2,  /* (195) alter_table_option ::= COMMENT NK_STRING */
   -2,  /* (196) alter_table_option ::= TTL NK_INTEGER */
   -1,  /* (197) duration_list ::= duration_literal */
   -3,  /* (198) duration_list ::= duration_list NK_COMMA duration_literal */
   -1,  /* (199) rollup_func_list ::= rollup_func_name */
   -3,  /* (200) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   -1,  /* (201) rollup_func_name ::= function_name */
   -1,  /* (202) rollup_func_name ::= FIRST */
   -1,  /* (203) rollup_func_name ::= LAST */
   -1,  /* (204) col_name_list ::= col_name */
   -3,  /* (205) col_name_list ::= col_name_list NK_COMMA col_name */
   -1,  /* (206) col_name ::= column_name */
   -2,  /* (207) cmd ::= SHOW DNODES */
   -2,  /* (208) cmd ::= SHOW USERS */
   -3,  /* (209) cmd ::= SHOW USER PRIVILEGES */
   -2,  /* (210) cmd ::= SHOW DATABASES */
   -4,  /* (211) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   -4,  /* (212) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   -3,  /* (213) cmd ::= SHOW db_name_cond_opt VGROUPS */
   -2,  /* (214) cmd ::= SHOW MNODES */
   -2,  /* (215) cmd ::= SHOW QNODES */
   -2,  /* (216) cmd ::= SHOW FUNCTIONS */
   -5,  /* (217) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   -2,  /* (218) cmd ::= SHOW STREAMS */
   -2,  /* (219) cmd ::= SHOW ACCOUNTS */
   -2,  /* (220) cmd ::= SHOW APPS */
   -2,  /* (221) cmd ::= SHOW CONNECTIONS */
   -2,  /* (222) cmd ::= SHOW LICENCES */
   -2,  /* (223) cmd ::= SHOW GRANTS */
   -4,  /* (224) cmd ::= SHOW CREATE DATABASE db_name */
   -4,  /* (225) cmd ::= SHOW CREATE TABLE full_table_name */
   -4,  /* (226) cmd ::= SHOW CREATE STABLE full_table_name */
   -2,  /* (227) cmd ::= SHOW QUERIES */
   -2,  /* (228) cmd ::= SHOW SCORES */
   -2,  /* (229) cmd ::= SHOW TOPICS */
   -2,  /* (230) cmd ::= SHOW VARIABLES */
   -3,  /* (231) cmd ::= SHOW CLUSTER VARIABLES */
   -3,  /* (232) cmd ::= SHOW LOCAL VARIABLES */
   -5,  /* (233) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   -2,  /* (234) cmd ::= SHOW BNODES */
   -2,  /* (235) cmd ::= SHOW SNODES */
   -2,  /* (236) cmd ::= SHOW CLUSTER */
   -2,  /* (237) cmd ::= SHOW TRANSACTIONS */
   -4,  /* (238) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   -2,  /* (239) cmd ::= SHOW CONSUMERS */
   -2,  /* (240) cmd ::= SHOW SUBSCRIPTIONS */
   -5,  /* (241) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   -7,  /* (242) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   -3,  /* (243) cmd ::= SHOW VNODES NK_INTEGER */
   -3,  /* (244) cmd ::= SHOW VNODES NK_STRING */
    0,  /* (245) db_name_cond_opt ::= */
   -2,  /* (246) db_name_cond_opt ::= db_name NK_DOT */
    0,  /* (247) like_pattern_opt ::= */
   -2,  /* (248) like_pattern_opt ::= LIKE NK_STRING */
   -1,  /* (249) table_name_cond ::= table_name */
    0,  /* (250) from_db_opt ::= */
   -2,  /* (251) from_db_opt ::= FROM db_name */
    0,  /* (252) tag_list_opt ::= */
   -1,  /* (253) tag_list_opt ::= tag_item */
   -3,  /* (254) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   -1,  /* (255) tag_item ::= TBNAME */
   -1,  /* (256) tag_item ::= QTAGS */
   -1,  /* (257) tag_item ::= column_name */
   -2,  /* (258) tag_item ::= column_name column_alias */
   -3,  /* (259) tag_item ::= column_name AS column_alias */
   -8,  /* (260) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
   -4,  /* (261) cmd ::= DROP INDEX exists_opt full_index_name */
   -1,  /* (262) full_index_name ::= index_name */
   -3,  /* (263) full_index_name ::= db_name NK_DOT index_name */
  -10,  /* (264) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  -12,  /* (265) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   -1,  /* (266) func_list ::= func */
   -3,  /* (267) func_list ::= func_list NK_COMMA func */
   -4,  /* (268) func ::= function_name NK_LP expression_list NK_RP */
    0,  /* (269) sma_stream_opt ::= */
   -3,  /* (270) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   -3,  /* (271) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   -3,  /* (272) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   -6,  /* (273) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   -7,  /* (274) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   -9,  /* (275) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   -7,  /* (276) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
   -9,  /* (277) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
   -4,  /* (278) cmd ::= DROP TOPIC exists_opt topic_name */
   -7,  /* (279) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   -2,  /* (280) cmd ::= DESC full_table_name */
   -2,  /* (281) cmd ::= DESCRIBE full_table_name */
   -3,  /* (282) cmd ::= RESET QUERY CACHE */
   -4,  /* (283) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
    0,  /* (284) analyze_opt ::= */
   -1,  /* (285) analyze_opt ::= ANALYZE */
    0,  /* (286) explain_options ::= */
   -3,  /* (287) explain_options ::= explain_options VERBOSE NK_BOOL */
   -3,  /* (288) explain_options ::= explain_options RATIO NK_FLOAT */
  -10,  /* (289) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
   -4,  /* (290) cmd ::= DROP FUNCTION exists_opt function_name */
    0,  /* (291) agg_func_opt ::= */
   -1,  /* (292) agg_func_opt ::= AGGREGATE */
    0,  /* (293) bufsize_opt ::= */
   -2,  /* (294) bufsize_opt ::= BUFSIZE NK_INTEGER */
  -11,  /* (295) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
   -4,  /* (296) cmd ::= DROP STREAM exists_opt stream_name */
    0,  /* (297) stream_options ::= */
   -3,  /* (298) stream_options ::= stream_options TRIGGER AT_ONCE */
   -3,  /* (299) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   -4,  /* (300) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   -3,  /* (301) stream_options ::= stream_options WATERMARK duration_literal */
   -4,  /* (302) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   -3,  /* (303) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
    0,  /* (304) subtable_opt ::= */
   -4,  /* (305) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
   -3,  /* (306) cmd ::= KILL CONNECTION NK_INTEGER */
   -3,  /* (307) cmd ::= KILL QUERY NK_STRING */
   -3,  /* (308) cmd ::= KILL TRANSACTION NK_INTEGER */
   -2,  /* (309) cmd ::= BALANCE VGROUP */
   -4,  /* (310) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   -4,  /* (311) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   -3,  /* (312) cmd ::= SPLIT VGROUP NK_INTEGER */
   -2,  /* (313) dnode_list ::= DNODE NK_INTEGER */
   -3,  /* (314) dnode_list ::= dnode_list DNODE NK_INTEGER */
   -4,  /* (315) cmd ::= DELETE FROM full_table_name where_clause_opt */
   -1,  /* (316) cmd ::= query_or_subquery */
   -7,  /* (317) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   -4,  /* (318) cmd ::= INSERT INTO full_table_name query_or_subquery */
   -1,  /* (319) literal ::= NK_INTEGER */
   -1,  /* (320) literal ::= NK_FLOAT */
   -1,  /* (321) literal ::= NK_STRING */
   -1,  /* (322) literal ::= NK_BOOL */
   -2,  /* (323) literal ::= TIMESTAMP NK_STRING */
   -1,  /* (324) literal ::= duration_literal */
   -1,  /* (325) literal ::= NULL */
   -1,  /* (326) literal ::= NK_QUESTION */
   -1,  /* (327) duration_literal ::= NK_VARIABLE */
   -1,  /* (328) signed ::= NK_INTEGER */
   -2,  /* (329) signed ::= NK_PLUS NK_INTEGER */
   -2,  /* (330) signed ::= NK_MINUS NK_INTEGER */
   -1,  /* (331) signed ::= NK_FLOAT */
   -2,  /* (332) signed ::= NK_PLUS NK_FLOAT */
   -2,  /* (333) signed ::= NK_MINUS NK_FLOAT */
   -1,  /* (334) signed_literal ::= signed */
   -1,  /* (335) signed_literal ::= NK_STRING */
   -1,  /* (336) signed_literal ::= NK_BOOL */
   -2,  /* (337) signed_literal ::= TIMESTAMP NK_STRING */
   -1,  /* (338) signed_literal ::= duration_literal */
   -1,  /* (339) signed_literal ::= NULL */
   -1,  /* (340) signed_literal ::= literal_func */
   -1,  /* (341) signed_literal ::= NK_QUESTION */
   -1,  /* (342) literal_list ::= signed_literal */
   -3,  /* (343) literal_list ::= literal_list NK_COMMA signed_literal */
   -1,  /* (344) db_name ::= NK_ID */
   -1,  /* (345) table_name ::= NK_ID */
   -1,  /* (346) column_name ::= NK_ID */
   -1,  /* (347) function_name ::= NK_ID */
   -1,  /* (348) table_alias ::= NK_ID */
   -1,  /* (349) column_alias ::= NK_ID */
   -1,  /* (350) user_name ::= NK_ID */
   -1,  /* (351) topic_name ::= NK_ID */
   -1,  /* (352) stream_name ::= NK_ID */
   -1,  /* (353) cgroup_name ::= NK_ID */
   -1,  /* (354) index_name ::= NK_ID */
   -1,  /* (355) expr_or_subquery ::= expression */
   -1,  /* (356) expression ::= literal */
   -1,  /* (357) expression ::= pseudo_column */
   -1,  /* (358) expression ::= column_reference */
   -1,  /* (359) expression ::= function_expression */
   -1,  /* (360) expression ::= case_when_expression */
   -3,  /* (361) expression ::= NK_LP expression NK_RP */
   -2,  /* (362) expression ::= NK_PLUS expr_or_subquery */
   -2,  /* (363) expression ::= NK_MINUS expr_or_subquery */
   -3,  /* (364) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   -3,  /* (365) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   -3,  /* (366) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   -3,  /* (367) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   -3,  /* (368) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   -3,  /* (369) expression ::= column_reference NK_ARROW NK_STRING */
   -3,  /* (370) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   -3,  /* (371) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   -1,  /* (372) expression_list ::= expr_or_subquery */
   -3,  /* (373) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   -1,  /* (374) column_reference ::= column_name */
   -3,  /* (375) column_reference ::= table_name NK_DOT column_name */
   -1,  /* (376) pseudo_column ::= ROWTS */
   -1,  /* (377) pseudo_column ::= TBNAME */
   -3,  /* (378) pseudo_column ::= table_name NK_DOT TBNAME */
   -1,  /* (379) pseudo_column ::= QSTART */
   -1,  /* (380) pseudo_column ::= QEND */
   -1,  /* (381) pseudo_column ::= QDURATION */
   -1,  /* (382) pseudo_column ::= WSTART */
   -1,  /* (383) pseudo_column ::= WEND */
   -1,  /* (384) pseudo_column ::= WDURATION */
   -1,  /* (385) pseudo_column ::= IROWTS */
   -1,  /* (386) pseudo_column ::= QTAGS */
   -4,  /* (387) function_expression ::= function_name NK_LP expression_list NK_RP */
   -4,  /* (388) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   -6,  /* (389) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   -1,  /* (390) function_expression ::= literal_func */
   -3,  /* (391) literal_func ::= noarg_func NK_LP NK_RP */
   -1,  /* (392) literal_func ::= NOW */
   -1,  /* (393) noarg_func ::= NOW */
   -1,  /* (394) noarg_func ::= TODAY */
   -1,  /* (395) noarg_func ::= TIMEZONE */
   -1,  /* (396) noarg_func ::= DATABASE */
   -1,  /* (397) noarg_func ::= CLIENT_VERSION */
   -1,  /* (398) noarg_func ::= SERVER_VERSION */
   -1,  /* (399) noarg_func ::= SERVER_STATUS */
   -1,  /* (400) noarg_func ::= CURRENT_USER */
   -1,  /* (401) noarg_func ::= USER */
   -1,  /* (402) star_func ::= COUNT */
   -1,  /* (403) star_func ::= FIRST */
   -1,  /* (404) star_func ::= LAST */
   -1,  /* (405) star_func ::= LAST_ROW */
   -1,  /* (406) star_func_para_list ::= NK_STAR */
   -1,  /* (407) star_func_para_list ::= other_para_list */
   -1,  /* (408) other_para_list ::= star_func_para */
   -3,  /* (409) other_para_list ::= other_para_list NK_COMMA star_func_para */
   -1,  /* (410) star_func_para ::= expr_or_subquery */
   -3,  /* (411) star_func_para ::= table_name NK_DOT NK_STAR */
   -4,  /* (412) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   -5,  /* (413) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   -1,  /* (414) when_then_list ::= when_then_expr */
   -2,  /* (415) when_then_list ::= when_then_list when_then_expr */
   -4,  /* (416) when_then_expr ::= WHEN common_expression THEN common_expression */
    0,  /* (417) case_when_else_opt ::= */
   -2,  /* (418) case_when_else_opt ::= ELSE common_expression */
   -3,  /* (419) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   -5,  /* (420) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   -6,  /* (421) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   -3,  /* (422) predicate ::= expr_or_subquery IS NULL */
   -4,  /* (423) predicate ::= expr_or_subquery IS NOT NULL */
   -3,  /* (424) predicate ::= expr_or_subquery in_op in_predicate_value */
   -1,  /* (425) compare_op ::= NK_LT */
   -1,  /* (426) compare_op ::= NK_GT */
   -1,  /* (427) compare_op ::= NK_LE */
   -1,  /* (428) compare_op ::= NK_GE */
   -1,  /* (429) compare_op ::= NK_NE */
   -1,  /* (430) compare_op ::= NK_EQ */
   -1,  /* (431) compare_op ::= LIKE */
   -2,  /* (432) compare_op ::= NOT LIKE */
   -1,  /* (433) compare_op ::= MATCH */
   -1,  /* (434) compare_op ::= NMATCH */
   -1,  /* (435) compare_op ::= CONTAINS */
   -1,  /* (436) in_op ::= IN */
   -2,  /* (437) in_op ::= NOT IN */
   -3,  /* (438) in_predicate_value ::= NK_LP literal_list NK_RP */
   -1,  /* (439) boolean_value_expression ::= boolean_primary */
   -2,  /* (440) boolean_value_expression ::= NOT boolean_primary */
   -3,  /* (441) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   -3,  /* (442) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   -1,  /* (443) boolean_primary ::= predicate */
   -3,  /* (444) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   -1,  /* (445) common_expression ::= expr_or_subquery */
   -1,  /* (446) common_expression ::= boolean_value_expression */
    0,  /* (447) from_clause_opt ::= */
   -2,  /* (448) from_clause_opt ::= FROM table_reference_list */
   -1,  /* (449) table_reference_list ::= table_reference */
   -3,  /* (450) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   -1,  /* (451) table_reference ::= table_primary */
   -1,  /* (452) table_reference ::= joined_table */
   -2,  /* (453) table_primary ::= table_name alias_opt */
   -4,  /* (454) table_primary ::= db_name NK_DOT table_name alias_opt */
   -2,  /* (455) table_primary ::= subquery alias_opt */
   -1,  /* (456) table_primary ::= parenthesized_joined_table */
    0,  /* (457) alias_opt ::= */
   -1,  /* (458) alias_opt ::= table_alias */
   -2,  /* (459) alias_opt ::= AS table_alias */
   -3,  /* (460) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   -3,  /* (461) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   -6,  /* (462) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
    0,  /* (463) join_type ::= */
   -1,  /* (464) join_type ::= INNER */
  -12,  /* (465) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
    0,  /* (466) set_quantifier_opt ::= */
   -1,  /* (467) set_quantifier_opt ::= DISTINCT */
   -1,  /* (468) set_quantifier_opt ::= ALL */
   -1,  /* (469) select_list ::= select_item */
   -3,  /* (470) select_list ::= select_list NK_COMMA select_item */
   -1,  /* (471) select_item ::= NK_STAR */
   -1,  /* (472) select_item ::= common_expression */
   -2,  /* (473) select_item ::= common_expression column_alias */
   -3,  /* (474) select_item ::= common_expression AS column_alias */
   -3,  /* (475) select_item ::= table_name NK_DOT NK_STAR */
    0,  /* (476) where_clause_opt ::= */
   -2,  /* (477) where_clause_opt ::= WHERE search_condition */
    0,  /* (478) partition_by_clause_opt ::= */
   -3,  /* (479) partition_by_clause_opt ::= PARTITION BY partition_list */
   -1,  /* (480) partition_list ::= partition_item */
   -3,  /* (481) partition_list ::= partition_list NK_COMMA partition_item */
   -1,  /* (482) partition_item ::= expr_or_subquery */
   -2,  /* (483) partition_item ::= expr_or_subquery column_alias */
   -3,  /* (484) partition_item ::= expr_or_subquery AS column_alias */
    0,  /* (485) twindow_clause_opt ::= */
   -6,  /* (486) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   -4,  /* (487) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   -6,  /* (488) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   -8,  /* (489) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
    0,  /* (490) sliding_opt ::= */
   -4,  /* (491) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
    0,  /* (492) fill_opt ::= */
   -4,  /* (493) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   -6,  /* (494) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
   -6,  /* (495) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
   -1,  /* (496) fill_mode ::= NONE */
   -1,  /* (497) fill_mode ::= PREV */
   -1,  /* (498) fill_mode ::= NULL */
   -1,  /* (499) fill_mode ::= NULL_F */
   -1,  /* (500) fill_mode ::= LINEAR */
   -1,  /* (501) fill_mode ::= NEXT */
    0,  /* (502) group_by_clause_opt ::= */
   -3,  /* (503) group_by_clause_opt ::= GROUP BY group_by_list */
   -1,  /* (504) group_by_list ::= expr_or_subquery */
   -3,  /* (505) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
    0,  /* (506) having_clause_opt ::= */
   -2,  /* (507) having_clause_opt ::= HAVING search_condition */
    0,  /* (508) range_opt ::= */
   -6,  /* (509) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
    0,  /* (510) every_opt ::= */
   -4,  /* (511) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   -4,  /* (512) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   -1,  /* (513) query_simple ::= query_specification */
   -1,  /* (514) query_simple ::= union_query_expression */
   -4,  /* (515) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   -3,  /* (516) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   -1,  /* (517) query_simple_or_subquery ::= query_simple */
   -1,  /* (518) query_simple_or_subquery ::= subquery */
   -1,  /* (519) query_or_subquery ::= query_expression */
   -1,  /* (520) query_or_subquery ::= subquery */
    0,  /* (521) order_by_clause_opt ::= */
   -3,  /* (522) order_by_clause_opt ::= ORDER BY sort_specification_list */
    0,  /* (523) slimit_clause_opt ::= */
   -2,  /* (524) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   -4,  /* (525) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   -4,  /* (526) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
    0,  /* (527) limit_clause_opt ::= */
   -2,  /* (528) limit_clause_opt ::= LIMIT NK_INTEGER */
   -4,  /* (529) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   -4,  /* (530) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   -3,  /* (531) subquery ::= NK_LP query_expression NK_RP */
   -3,  /* (532) subquery ::= NK_LP subquery NK_RP */
   -1,  /* (533) search_condition ::= common_expression */
   -1,  /* (534) sort_specification_list ::= sort_specification */
   -3,  /* (535) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   -3,  /* (536) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
    0,  /* (537) ordering_specification_opt ::= */
   -1,  /* (538) ordering_specification_opt ::= ASC */
   -1,  /* (539) ordering_specification_opt ::= DESC */
    0,  /* (540) null_ordering_opt ::= */
   -2,  /* (541) null_ordering_opt ::= NULLS FIRST */
   -2,  /* (542) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfoNRhs[yyruleno];
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
        yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,325,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,326,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,325,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,327,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,328,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,326,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,328,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,327,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy77, &yymsp[-1].minor.yy0, yymsp[0].minor.yy287); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy77, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy77, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy77, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy287 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy287 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy717, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy717, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy717 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy717 = yymsp[0].minor.yy717; }
  yymsp[0].minor.yy717 = yylhsminor.yy717;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy717 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy717 = yymsp[-2].minor.yy717 | yymsp[0].minor.yy717; }
  yymsp[-2].minor.yy717 = yylhsminor.yy717;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy717 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy717 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy77 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy77 = yylhsminor.yy77;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy77 = yymsp[-2].minor.yy77; }
  yymsp[-2].minor.yy77 = yylhsminor.yy77;
        break;
      case 42: /* priv_level ::= topic_name */
      case 458: /* alias_opt ::= table_alias */ yytestcase(yyruleno==458);
{ yylhsminor.yy77 = yymsp[0].minor.yy77; }
  yymsp[0].minor.yy77 = yylhsminor.yy77;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy77, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy841); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy77, yymsp[0].minor.yy841); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 344: /* db_name ::= NK_ID */ yytestcase(yyruleno==344);
      case 345: /* table_name ::= NK_ID */ yytestcase(yyruleno==345);
      case 346: /* column_name ::= NK_ID */ yytestcase(yyruleno==346);
      case 347: /* function_name ::= NK_ID */ yytestcase(yyruleno==347);
      case 348: /* table_alias ::= NK_ID */ yytestcase(yyruleno==348);
      case 349: /* column_alias ::= NK_ID */ yytestcase(yyruleno==349);
      case 350: /* user_name ::= NK_ID */ yytestcase(yyruleno==350);
      case 351: /* topic_name ::= NK_ID */ yytestcase(yyruleno==351);
      case 352: /* stream_name ::= NK_ID */ yytestcase(yyruleno==352);
      case 353: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==353);
      case 354: /* index_name ::= NK_ID */ yytestcase(yyruleno==354);
      case 393: /* noarg_func ::= NOW */ yytestcase(yyruleno==393);
      case 394: /* noarg_func ::= TODAY */ yytestcase(yyruleno==394);
      case 395: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==395);
      case 396: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==396);
      case 397: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==397);
      case 398: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==398);
      case 399: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==399);
      case 400: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==400);
      case 401: /* noarg_func ::= USER */ yytestcase(yyruleno==401);
      case 402: /* star_func ::= COUNT */ yytestcase(yyruleno==402);
      case 403: /* star_func ::= FIRST */ yytestcase(yyruleno==403);
      case 404: /* star_func ::= LAST */ yytestcase(yyruleno==404);
      case 405: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==405);
{ yylhsminor.yy77 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy77 = yylhsminor.yy77;
        break;
      case 54: /* force_opt ::= */
      case 73: /* not_exists_opt ::= */ yytestcase(yyruleno==73);
      case 75: /* exists_opt ::= */ yytestcase(yyruleno==75);
      case 284: /* analyze_opt ::= */ yytestcase(yyruleno==284);
      case 291: /* agg_func_opt ::= */ yytestcase(yyruleno==291);
      case 466: /* set_quantifier_opt ::= */ yytestcase(yyruleno==466);
{ yymsp[1].minor.yy841 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 285: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==285);
      case 292: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==292);
      case 467: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==467);
{ yymsp[0].minor.yy841 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy841, &yymsp[-1].minor.yy77, yymsp[0].minor.yy600); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy841, &yymsp[0].minor.yy77); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy77, yymsp[0].minor.yy600); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy77, yymsp[0].minor.yy248); }
        break;
      case 72: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy841 = true; }
        break;
      case 74: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy841 = true; }
        break;
      case 76: /* db_options ::= */
{ yymsp[1].minor.yy600 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 77: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 78: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 79: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 80: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 81: /* db_options ::= db_options DURATION NK_INTEGER */
      case 82: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==82);
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 83: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 84: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 85: /* db_options ::= db_options KEEP integer_list */
      case 86: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==86);
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_KEEP, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 87: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 88: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 89: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 90: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 91: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 92: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 93: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 94: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_RETENTIONS, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 95: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 96: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 97: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-3].minor.yy600, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-3].minor.yy600, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 102: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 103: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 104: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 105: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 106: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy600 = setDatabaseOption(pCxt, yymsp[-2].minor.yy600, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 107: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy600 = createAlterDatabaseOptions(pCxt); yylhsminor.yy600 = setAlterDatabaseOption(pCxt, yylhsminor.yy600, &yymsp[0].minor.yy661); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 108: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy600 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy600, &yymsp[0].minor.yy661); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 109: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy661.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= KEEP integer_list */
      case 114: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==114);
{ yymsp[-1].minor.yy661.type = DB_OPTION_KEEP; yymsp[-1].minor.yy661.pList = yymsp[0].minor.yy601; }
        break;
      case 115: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_PAGES; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_WAL; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy661.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy601 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 120: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 314: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==314);
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 121: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy601 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 122: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 123: /* retention_list ::= retention */
      case 145: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==145);
      case 148: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==148);
      case 155: /* column_def_list ::= column_def */ yytestcase(yyruleno==155);
      case 199: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==199);
      case 204: /* col_name_list ::= col_name */ yytestcase(yyruleno==204);
      case 253: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==253);
      case 266: /* func_list ::= func */ yytestcase(yyruleno==266);
      case 342: /* literal_list ::= signed_literal */ yytestcase(yyruleno==342);
      case 408: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==408);
      case 414: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==414);
      case 469: /* select_list ::= select_item */ yytestcase(yyruleno==469);
      case 480: /* partition_list ::= partition_item */ yytestcase(yyruleno==480);
      case 534: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==534);
{ yylhsminor.yy601 = createNodeList(pCxt, yymsp[0].minor.yy600); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 124: /* retention_list ::= retention_list NK_COMMA retention */
      case 156: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==205);
      case 254: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==254);
      case 267: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==267);
      case 343: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==343);
      case 409: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==409);
      case 470: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==470);
      case 481: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==481);
      case 535: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==535);
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, yymsp[0].minor.yy600); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 125: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy600 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 126: /* speed_opt ::= */
      case 293: /* bufsize_opt ::= */ yytestcase(yyruleno==293);
{ yymsp[1].minor.yy248 = 0; }
        break;
      case 127: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 294: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==294);
{ yymsp[-1].minor.yy248 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 128: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 130: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==130);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy841, yymsp[-5].minor.yy600, yymsp[-3].minor.yy601, yymsp[-1].minor.yy601, yymsp[0].minor.yy600); }
        break;
      case 129: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy601); }
        break;
      case 131: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy601); }
        break;
      case 132: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy841, yymsp[0].minor.yy600); }
        break;
      case 133: /* cmd ::= ALTER TABLE alter_table_clause */
      case 316: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==316);
{ pCxt->pRootNode = yymsp[0].minor.yy600; }
        break;
      case 134: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy600); }
        break;
      case 135: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy600 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 136: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy600 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 137: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy600 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy600, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy77); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 138: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy600 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 139: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy600 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 140: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy600 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 141: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy600 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy600, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy77); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 142: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy600 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 143: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy600 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy600, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 144: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy600 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy600, &yymsp[-2].minor.yy77, yymsp[0].minor.yy600); }
  yymsp[-5].minor.yy600 = yylhsminor.yy600;
        break;
      case 146: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 149: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==149);
      case 415: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==415);
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-1].minor.yy601, yymsp[0].minor.yy600); }
  yymsp[-1].minor.yy601 = yylhsminor.yy601;
        break;
      case 147: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy600 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy841, yymsp[-8].minor.yy600, yymsp[-6].minor.yy600, yymsp[-5].minor.yy601, yymsp[-2].minor.yy601, yymsp[0].minor.yy600); }
  yymsp[-9].minor.yy600 = yylhsminor.yy600;
        break;
      case 150: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy600 = createDropTableClause(pCxt, yymsp[-1].minor.yy841, yymsp[0].minor.yy600); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 151: /* specific_cols_opt ::= */
      case 182: /* tags_def_opt ::= */ yytestcase(yyruleno==182);
      case 252: /* tag_list_opt ::= */ yytestcase(yyruleno==252);
      case 478: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==478);
      case 502: /* group_by_clause_opt ::= */ yytestcase(yyruleno==502);
      case 521: /* order_by_clause_opt ::= */ yytestcase(yyruleno==521);
{ yymsp[1].minor.yy601 = NULL; }
        break;
      case 152: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy601 = yymsp[-1].minor.yy601; }
        break;
      case 153: /* full_table_name ::= table_name */
{ yylhsminor.yy600 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy77, NULL); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 154: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy600 = createRealTableNode(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77, NULL); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 157: /* column_def ::= column_name type_name */
{ yylhsminor.yy600 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy77, yymsp[0].minor.yy888, NULL); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 158: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy600 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy77, yymsp[-2].minor.yy888, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 159: /* type_name ::= BOOL */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 160: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 161: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 162: /* type_name ::= INT */
      case 163: /* type_name ::= INTEGER */ yytestcase(yyruleno==163);
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 164: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 165: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 166: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 167: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 169: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy888 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 171: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy888 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 172: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy888 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 173: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy888 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 174: /* type_name ::= JSON */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 175: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 176: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 177: /* type_name ::= BLOB */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 178: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 179: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy888 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 180: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy888 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy888 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 183: /* tags_def_opt ::= tags_def */
      case 407: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==407);
{ yylhsminor.yy601 = yymsp[0].minor.yy601; }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 184: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy601 = yymsp[-1].minor.yy601; }
        break;
      case 185: /* table_options ::= */
{ yymsp[1].minor.yy600 = createDefaultTableOptions(pCxt); }
        break;
      case 186: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 187: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 188: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 189: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-4].minor.yy600, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy601); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 190: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 191: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-4].minor.yy600, TABLE_OPTION_SMA, yymsp[-1].minor.yy601); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 192: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-2].minor.yy600, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy601); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 193: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy600 = createAlterTableOptions(pCxt); yylhsminor.yy600 = setTableOption(pCxt, yylhsminor.yy600, yymsp[0].minor.yy661.type, &yymsp[0].minor.yy661.val); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 194: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy600 = setTableOption(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy661.type, &yymsp[0].minor.yy661.val); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 195: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy661.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 196: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy661.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy661.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* duration_list ::= duration_literal */
      case 372: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==372);
{ yylhsminor.yy601 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy600)); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 198: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 373: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==373);
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, releaseRawExprNode(pCxt, yymsp[0].minor.yy600)); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 201: /* rollup_func_name ::= function_name */
{ yylhsminor.yy600 = createFunctionNode(pCxt, &yymsp[0].minor.yy77, NULL); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 202: /* rollup_func_name ::= FIRST */
      case 203: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==203);
      case 256: /* tag_item ::= QTAGS */ yytestcase(yyruleno==256);
{ yylhsminor.yy600 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 206: /* col_name ::= column_name */
      case 257: /* tag_item ::= column_name */ yytestcase(yyruleno==257);
{ yylhsminor.yy600 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy77); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 207: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 208: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 209: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 210: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 211: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy600, yymsp[0].minor.yy600, OP_TYPE_LIKE); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy600, yymsp[0].minor.yy600, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy600, NULL, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 217: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy600, yymsp[-1].minor.yy600, OP_TYPE_EQUAL); }
        break;
      case 218: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 219: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 220: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 221: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 222: /* cmd ::= SHOW LICENCES */
      case 223: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==223);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 224: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 225: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy600); }
        break;
      case 226: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy600); }
        break;
      case 227: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 228: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 229: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 230: /* cmd ::= SHOW VARIABLES */
      case 231: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==231);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 232: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy600); }
        break;
      case 234: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 235: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 237: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 238: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy600); }
        break;
      case 239: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 240: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 241: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy600, yymsp[-1].minor.yy600, OP_TYPE_EQUAL); }
        break;
      case 242: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy600, yymsp[-3].minor.yy601); }
        break;
      case 243: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 245: /* db_name_cond_opt ::= */
      case 250: /* from_db_opt ::= */ yytestcase(yyruleno==250);
{ yymsp[1].minor.yy600 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 246: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy600 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 247: /* like_pattern_opt ::= */
      case 304: /* subtable_opt ::= */ yytestcase(yyruleno==304);
      case 417: /* case_when_else_opt ::= */ yytestcase(yyruleno==417);
      case 447: /* from_clause_opt ::= */ yytestcase(yyruleno==447);
      case 476: /* where_clause_opt ::= */ yytestcase(yyruleno==476);
      case 485: /* twindow_clause_opt ::= */ yytestcase(yyruleno==485);
      case 490: /* sliding_opt ::= */ yytestcase(yyruleno==490);
      case 492: /* fill_opt ::= */ yytestcase(yyruleno==492);
      case 506: /* having_clause_opt ::= */ yytestcase(yyruleno==506);
      case 508: /* range_opt ::= */ yytestcase(yyruleno==508);
      case 510: /* every_opt ::= */ yytestcase(yyruleno==510);
      case 523: /* slimit_clause_opt ::= */ yytestcase(yyruleno==523);
      case 527: /* limit_clause_opt ::= */ yytestcase(yyruleno==527);
{ yymsp[1].minor.yy600 = NULL; }
        break;
      case 248: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 249: /* table_name_cond ::= table_name */
{ yylhsminor.yy600 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy77); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 251: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy600 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy77); }
        break;
      case 255: /* tag_item ::= TBNAME */
{ yylhsminor.yy600 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 258: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy600 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy77), &yymsp[0].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 259: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy600 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy77), &yymsp[0].minor.yy77); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 260: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy841, yymsp[-3].minor.yy600, yymsp[-1].minor.yy600, NULL, yymsp[0].minor.yy600); }
        break;
      case 261: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy841, yymsp[0].minor.yy600); }
        break;
      case 262: /* full_index_name ::= index_name */
{ yylhsminor.yy600 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy77); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 263: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy600 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 264: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy600 = createIndexOption(pCxt, yymsp[-7].minor.yy601, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), NULL, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 265: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy600 = createIndexOption(pCxt, yymsp[-9].minor.yy601, releaseRawExprNode(pCxt, yymsp[-5].minor.yy600), releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 268: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy600 = createFunctionNode(pCxt, &yymsp[-3].minor.yy77, yymsp[-1].minor.yy601); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 269: /* sma_stream_opt ::= */
      case 297: /* stream_options ::= */ yytestcase(yyruleno==297);
{ yymsp[1].minor.yy600 = createStreamOptions(pCxt); }
        break;
      case 270: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 301: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==301);
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 271: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 272: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 273: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy841, &yymsp[-2].minor.yy77, yymsp[0].minor.yy600); }
        break;
      case 274: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy841, &yymsp[-3].minor.yy77, &yymsp[0].minor.yy77, false); }
        break;
      case 275: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy841, &yymsp[-5].minor.yy77, &yymsp[0].minor.yy77, true); }
        break;
      case 276: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy841, &yymsp[-3].minor.yy77, yymsp[0].minor.yy600, false); }
        break;
      case 277: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy841, &yymsp[-5].minor.yy77, yymsp[0].minor.yy600, true); }
        break;
      case 278: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy841, &yymsp[0].minor.yy77); }
        break;
      case 279: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy841, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77); }
        break;
      case 280: /* cmd ::= DESC full_table_name */
      case 281: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==281);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy600); }
        break;
      case 282: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 283: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy841, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 286: /* explain_options ::= */
{ yymsp[1].minor.yy600 = createDefaultExplainOptions(pCxt); }
        break;
      case 287: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy600 = setExplainVerbose(pCxt, yymsp[-2].minor.yy600, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 288: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy600 = setExplainRatio(pCxt, yymsp[-2].minor.yy600, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 289: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy841, yymsp[-8].minor.yy841, &yymsp[-5].minor.yy77, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy888, yymsp[0].minor.yy248); }
        break;
      case 290: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy841, &yymsp[0].minor.yy77); }
        break;
      case 295: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-8].minor.yy841, &yymsp[-7].minor.yy77, yymsp[-4].minor.yy600, yymsp[-6].minor.yy600, yymsp[-3].minor.yy601, yymsp[-2].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 296: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy841, &yymsp[0].minor.yy77); }
        break;
      case 298: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 299: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 300: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy600)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy600)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); yylhsminor.yy600 = yymsp[-3].minor.yy600; }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 302: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy600)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy600 = yymsp[-3].minor.yy600; }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 303: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy600)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy600 = yymsp[-2].minor.yy600; }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 305: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 491: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==491);
      case 511: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==511);
{ yymsp[-3].minor.yy600 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy600); }
        break;
      case 306: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 307: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 308: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 309: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 310: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 311: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy601); }
        break;
      case 312: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 313: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy601 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 315: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 317: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy600, yymsp[-2].minor.yy601, yymsp[0].minor.yy600); }
        break;
      case 318: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy600, NULL, yymsp[0].minor.yy600); }
        break;
      case 319: /* literal ::= NK_INTEGER */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 320: /* literal ::= NK_FLOAT */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 321: /* literal ::= NK_STRING */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 322: /* literal ::= NK_BOOL */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 323: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 324: /* literal ::= duration_literal */
      case 334: /* signed_literal ::= signed */ yytestcase(yyruleno==334);
      case 355: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==355);
      case 356: /* expression ::= literal */ yytestcase(yyruleno==356);
      case 357: /* expression ::= pseudo_column */ yytestcase(yyruleno==357);
      case 358: /* expression ::= column_reference */ yytestcase(yyruleno==358);
      case 359: /* expression ::= function_expression */ yytestcase(yyruleno==359);
      case 360: /* expression ::= case_when_expression */ yytestcase(yyruleno==360);
      case 390: /* function_expression ::= literal_func */ yytestcase(yyruleno==390);
      case 439: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==439);
      case 443: /* boolean_primary ::= predicate */ yytestcase(yyruleno==443);
      case 445: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==445);
      case 446: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==446);
      case 449: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==449);
      case 451: /* table_reference ::= table_primary */ yytestcase(yyruleno==451);
      case 452: /* table_reference ::= joined_table */ yytestcase(yyruleno==452);
      case 456: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==456);
      case 513: /* query_simple ::= query_specification */ yytestcase(yyruleno==513);
      case 514: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==514);
      case 517: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==517);
      case 519: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==519);
{ yylhsminor.yy600 = yymsp[0].minor.yy600; }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 325: /* literal ::= NULL */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 326: /* literal ::= NK_QUESTION */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 327: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 328: /* signed ::= NK_INTEGER */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 329: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 330: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 331: /* signed ::= NK_FLOAT */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 332: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 333: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 335: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 336: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 337: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 338: /* signed_literal ::= duration_literal */
      case 340: /* signed_literal ::= literal_func */ yytestcase(yyruleno==340);
      case 410: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==410);
      case 472: /* select_item ::= common_expression */ yytestcase(yyruleno==472);
      case 482: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==482);
      case 518: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==518);
      case 520: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==520);
      case 533: /* search_condition ::= common_expression */ yytestcase(yyruleno==533);
{ yylhsminor.yy600 = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 339: /* signed_literal ::= NULL */
{ yylhsminor.yy600 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 341: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy600 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 361: /* expression ::= NK_LP expression NK_RP */
      case 444: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==444);
      case 532: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==532);
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy600)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 362: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy600));
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 363: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy600), NULL));
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 364: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 365: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 366: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 367: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 368: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 369: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 370: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 371: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 374: /* column_reference ::= column_name */
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy77, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy77)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 375: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77, createColumnNode(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy77)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 376: /* pseudo_column ::= ROWTS */
      case 377: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==377);
      case 379: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==379);
      case 380: /* pseudo_column ::= QEND */ yytestcase(yyruleno==380);
      case 381: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==381);
      case 382: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==382);
      case 383: /* pseudo_column ::= WEND */ yytestcase(yyruleno==383);
      case 384: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==384);
      case 385: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==385);
      case 386: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==386);
      case 392: /* literal_func ::= NOW */ yytestcase(yyruleno==392);
{ yylhsminor.yy600 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 378: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy77)))); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 387: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 388: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==388);
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy77, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy77, yymsp[-1].minor.yy601)); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 389: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), yymsp[-1].minor.yy888)); }
  yymsp[-5].minor.yy600 = yylhsminor.yy600;
        break;
      case 391: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy77, NULL)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 406: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy601 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 411: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 475: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==475);
{ yylhsminor.yy600 = createColumnNode(pCxt, &yymsp[-2].minor.yy77, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 412: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy601, yymsp[-1].minor.yy600)); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 413: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), yymsp[-2].minor.yy601, yymsp[-1].minor.yy600)); }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 416: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy600 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)); }
        break;
      case 418: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy600 = releaseRawExprNode(pCxt, yymsp[0].minor.yy600); }
        break;
      case 419: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 424: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==424);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy666, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 420: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy600), releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-4].minor.yy600 = yylhsminor.yy600;
        break;
      case 421: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy600), releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-5].minor.yy600 = yylhsminor.yy600;
        break;
      case 422: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), NULL));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 423: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), NULL));
                                                                                  }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 425: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy666 = OP_TYPE_LOWER_THAN; }
        break;
      case 426: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy666 = OP_TYPE_GREATER_THAN; }
        break;
      case 427: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy666 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 428: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy666 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 429: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy666 = OP_TYPE_NOT_EQUAL; }
        break;
      case 430: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy666 = OP_TYPE_EQUAL; }
        break;
      case 431: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy666 = OP_TYPE_LIKE; }
        break;
      case 432: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy666 = OP_TYPE_NOT_LIKE; }
        break;
      case 433: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy666 = OP_TYPE_MATCH; }
        break;
      case 434: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy666 = OP_TYPE_NMATCH; }
        break;
      case 435: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy666 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 436: /* in_op ::= IN */
{ yymsp[0].minor.yy666 = OP_TYPE_IN; }
        break;
      case 437: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy666 = OP_TYPE_NOT_IN; }
        break;
      case 438: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy601)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 440: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy600), NULL));
                                                                                  }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 441: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 442: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy600);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy600);
                                                                                    yylhsminor.yy600 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), releaseRawExprNode(pCxt, yymsp[0].minor.yy600)));
                                                                                  }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 448: /* from_clause_opt ::= FROM table_reference_list */
      case 477: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==477);
      case 507: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==507);
{ yymsp[-1].minor.yy600 = yymsp[0].minor.yy600; }
        break;
      case 450: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy600 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy600, yymsp[0].minor.yy600, NULL); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 453: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy600 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 454: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy600 = createRealTableNode(pCxt, &yymsp[-3].minor.yy77, &yymsp[-1].minor.yy77, &yymsp[0].minor.yy77); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 455: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy600 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy600), &yymsp[0].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 457: /* alias_opt ::= */
{ yymsp[1].minor.yy77 = nil_token;  }
        break;
      case 459: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy77 = yymsp[0].minor.yy77; }
        break;
      case 460: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 461: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==461);
{ yymsp[-2].minor.yy600 = yymsp[-1].minor.yy600; }
        break;
      case 462: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy600 = createJoinTableNode(pCxt, yymsp[-4].minor.yy560, yymsp[-5].minor.yy600, yymsp[-2].minor.yy600, yymsp[0].minor.yy600); }
  yymsp[-5].minor.yy600 = yylhsminor.yy600;
        break;
      case 463: /* join_type ::= */
{ yymsp[1].minor.yy560 = JOIN_TYPE_INNER; }
        break;
      case 464: /* join_type ::= INNER */
{ yymsp[0].minor.yy560 = JOIN_TYPE_INNER; }
        break;
      case 465: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy600 = createSelectStmt(pCxt, yymsp[-10].minor.yy841, yymsp[-9].minor.yy601, yymsp[-8].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addWhereClause(pCxt, yymsp[-11].minor.yy600, yymsp[-7].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addPartitionByClause(pCxt, yymsp[-11].minor.yy600, yymsp[-6].minor.yy601);
                                                                                    yymsp[-11].minor.yy600 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy600, yymsp[-2].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addGroupByClause(pCxt, yymsp[-11].minor.yy600, yymsp[-1].minor.yy601);
                                                                                    yymsp[-11].minor.yy600 = addHavingClause(pCxt, yymsp[-11].minor.yy600, yymsp[0].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addRangeClause(pCxt, yymsp[-11].minor.yy600, yymsp[-5].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addEveryClause(pCxt, yymsp[-11].minor.yy600, yymsp[-4].minor.yy600);
                                                                                    yymsp[-11].minor.yy600 = addFillClause(pCxt, yymsp[-11].minor.yy600, yymsp[-3].minor.yy600);
                                                                                  }
        break;
      case 468: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy841 = false; }
        break;
      case 471: /* select_item ::= NK_STAR */
{ yylhsminor.yy600 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 473: /* select_item ::= common_expression column_alias */
      case 483: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==483);
{ yylhsminor.yy600 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy600), &yymsp[0].minor.yy77); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 474: /* select_item ::= common_expression AS column_alias */
      case 484: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==484);
{ yylhsminor.yy600 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), &yymsp[0].minor.yy77); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 479: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 503: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==503);
      case 522: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==522);
{ yymsp[-2].minor.yy601 = yymsp[0].minor.yy601; }
        break;
      case 486: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy600 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), releaseRawExprNode(pCxt, yymsp[-1].minor.yy600)); }
        break;
      case 487: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy600 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy600)); }
        break;
      case 488: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy600 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), NULL, yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 489: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy600 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy600), releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), yymsp[-1].minor.yy600, yymsp[0].minor.yy600); }
        break;
      case 493: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy600 = createFillNode(pCxt, yymsp[-1].minor.yy798, NULL); }
        break;
      case 494: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy600 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy601)); }
        break;
      case 495: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy600 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy601)); }
        break;
      case 496: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy798 = FILL_MODE_NONE; }
        break;
      case 497: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy798 = FILL_MODE_PREV; }
        break;
      case 498: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy798 = FILL_MODE_NULL; }
        break;
      case 499: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy798 = FILL_MODE_NULL_F; }
        break;
      case 500: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy798 = FILL_MODE_LINEAR; }
        break;
      case 501: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy798 = FILL_MODE_NEXT; }
        break;
      case 504: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy601 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); }
  yymsp[0].minor.yy601 = yylhsminor.yy601;
        break;
      case 505: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy601 = addNodeToList(pCxt, yymsp[-2].minor.yy601, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy600))); }
  yymsp[-2].minor.yy601 = yylhsminor.yy601;
        break;
      case 509: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy600 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy600), releaseRawExprNode(pCxt, yymsp[-1].minor.yy600)); }
        break;
      case 512: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy600 = addOrderByClause(pCxt, yymsp[-3].minor.yy600, yymsp[-2].minor.yy601);
                                                                                    yylhsminor.yy600 = addSlimitClause(pCxt, yylhsminor.yy600, yymsp[-1].minor.yy600);
                                                                                    yylhsminor.yy600 = addLimitClause(pCxt, yylhsminor.yy600, yymsp[0].minor.yy600);
                                                                                  }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 515: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy600 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy600, yymsp[0].minor.yy600); }
  yymsp[-3].minor.yy600 = yylhsminor.yy600;
        break;
      case 516: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy600 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy600, yymsp[0].minor.yy600); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 524: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 528: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==528);
{ yymsp[-1].minor.yy600 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 525: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 529: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==529);
{ yymsp[-3].minor.yy600 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 526: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 530: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==530);
{ yymsp[-3].minor.yy600 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 531: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy600 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy600); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 536: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy600 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy600), yymsp[-1].minor.yy32, yymsp[0].minor.yy385); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 537: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy32 = ORDER_ASC; }
        break;
      case 538: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy32 = ORDER_ASC; }
        break;
      case 539: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy32 = ORDER_DESC; }
        break;
      case 540: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy385 = NULL_ORDER_DEFAULT; }
        break;
      case 541: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy385 = NULL_ORDER_FIRST; }
        break;
      case 542: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy385 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
