/*
 * Copyright (c) 2019 TAOS Data, Inc. <jhtao@taosdata.com>
 *
 * This program is free software: you can use, redistribute, and/or modify
 * it under the terms of the GNU Affero General Public License, version 3
 * or later ("AGPL"), as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _TD_COMMON_TOKEN_H_
#define _TD_COMMON_TOKEN_H_

#define TK_OR                   1
#define TK_AND                  2
#define TK_UNION                3
#define TK_ALL                  4
#define TK_MINUS                5
#define TK_EXCEPT               6
#define TK_INTERSECT            7
#define TK_NK_BITAND            8
#define TK_NK_BITOR             9
#define TK_NK_LSHIFT            10
#define TK_NK_RSHIFT            11
#define TK_NK_PLUS              12
#define TK_NK_MINUS             13
#define TK_NK_STAR              14
#define TK_NK_SLASH             15
#define TK_NK_REM               16
#define TK_NK_CONCAT            17
#define TK_CREATE               18
#define TK_ACCOUNT              19
#define TK_NK_ID                20
#define TK_PASS                 21
#define TK_NK_STRING            22
#define TK_ALTER                23
#define TK_PPS                  24
#define TK_TSERIES              25
#define TK_STORAGE              26
#define TK_STREAMS              27
#define TK_QTIME                28
#define TK_DBS                  29
#define TK_USERS                30
#define TK_CONNS                31
#define TK_STATE                32
#define TK_USER                 33
#define TK_ENABLE               34
#define TK_NK_INTEGER           35
#define TK_SYSINFO              36
#define TK_DROP                 37
#define TK_GRANT                38
#define TK_ON                   39
#define TK_TO                   40
#define TK_REVOKE               41
#define TK_FROM                 42
#define TK_NK_COMMA             43
#define TK_READ                 44
#define TK_WRITE                45
#define TK_NK_DOT               46
#define TK_DNODE                47
#define TK_PORT                 48
#define TK_DNODES               49
#define TK_NK_IPTOKEN           50
#define TK_FORCE                51
#define TK_LOCAL                52
#define TK_QNODE                53
#define TK_BNODE                54
#define TK_SNODE                55
#define TK_MNODE                56
#define TK_DATABASE             57
#define TK_USE                  58
#define TK_FLUSH                59
#define TK_TRIM                 60
#define TK_IF                   61
#define TK_NOT                  62
#define TK_EXISTS               63
#define TK_BUFFER               64
#define TK_CACHEMODEL           65
#define TK_CACHESIZE            66
#define TK_COMP                 67
#define TK_DURATION             68
#define TK_NK_VARIABLE          69
#define TK_MAXROWS              70
#define TK_MINROWS              71
#define TK_KEEP                 72
#define TK_PAGES                73
#define TK_PAGESIZE             74
#define TK_TSDB_PAGESIZE        75
#define TK_PRECISION            76
#define TK_REPLICA              77
#define TK_STRICT               78
#define TK_VGROUPS              79
#define TK_SINGLE_STABLE        80
#define TK_RETENTIONS           81
#define TK_SCHEMALESS           82
#define TK_WAL_LEVEL            83
#define TK_WAL_FSYNC_PERIOD     84
#define TK_WAL_RETENTION_PERIOD 85
#define TK_WAL_RETENTION_SIZE   86
#define TK_WAL_ROLL_PERIOD      87
#define TK_WAL_SEGMENT_SIZE     88
#define TK_STT_TRIGGER          89
#define TK_TABLE_PREFIX         90
#define TK_TABLE_SUFFIX         91
#define TK_NK_COLON             92
#define TK_MAX_SPEED            93
#define TK_TABLE                94
#define TK_NK_LP                95
#define TK_NK_RP                96
#define TK_STABLE               97
#define TK_ADD                  98
#define TK_COLUMN               99
#define TK_MODIFY               100
#define TK_RENAME               101
#define TK_TAG                  102
#define TK_SET                  103
#define TK_NK_EQ                104
#define TK_USING                105
#define TK_TAGS                 106
#define TK_COMMENT              107
#define TK_BOOL                 108
#define TK_TINYINT              109
#define TK_SMALLINT             110
#define TK_INT                  111
#define TK_INTEGER              112
#define TK_BIGINT               113
#define TK_FLOAT                114
#define TK_DOUBLE               115
#define TK_BINARY               116
#define TK_TIMESTAMP            117
#define TK_NCHAR                118
#define TK_UNSIGNED             119
#define TK_JSON                 120
#define TK_VARCHAR              121
#define TK_MEDIUMBLOB           122
#define TK_BLOB                 123
#define TK_VARBINARY            124
#define TK_DECIMAL              125
#define TK_MAX_DELAY            126
#define TK_WATERMARK            127
#define TK_ROLLUP               128
#define TK_TTL                  129
#define TK_SMA                  130
#define TK_FIRST                131
#define TK_LAST                 132
#define TK_SHOW                 133
#define TK_DATABASES            134
#define TK_TABLES               135
#define TK_STABLES              136
#define TK_MNODES               137
#define TK_QNODES               138
#define TK_FUNCTIONS            139
#define TK_INDEXES              140
#define TK_ACCOUNTS             141
#define TK_APPS                 142
#define TK_CONNECTIONS          143
#define TK_LICENCES             144
#define TK_GRANTS               145
#define TK_QUERIES              146
#define TK_SCORES               147
#define TK_TOPICS               148
#define TK_VARIABLES            149
#define TK_CLUSTER              150
#define TK_BNODES               151
#define TK_SNODES               152
#define TK_TRANSACTIONS         153
#define TK_DISTRIBUTED          154
#define TK_CONSUMERS            155
#define TK_SUBSCRIPTIONS        156
#define TK_VNODES               157
#define TK_LIKE                 158
#define TK_TBNAME               159
#define TK_QTAGS                160
#define TK_AS                   161
#define TK_INDEX                162
#define TK_FUNCTION             163
#define TK_INTERVAL             164
#define TK_TOPIC                165
#define TK_WITH                 166
#define TK_META                 167
#define TK_CONSUMER             168
#define TK_GROUP                169
#define TK_DESC                 170
#define TK_DESCRIBE             171
#define TK_RESET                172
#define TK_QUERY                173
#define TK_CACHE                174
#define TK_EXPLAIN              175
#define TK_ANALYZE              176
#define TK_VERBOSE              177
#define TK_NK_BOOL              178
#define TK_RATIO                179
#define TK_NK_FLOAT             180
#define TK_OUTPUTTYPE           181
#define TK_AGGREGATE            182
#define TK_BUFSIZE              183
#define TK_STREAM               184
#define TK_INTO                 185
#define TK_TRIGGER              186
#define TK_AT_ONCE              187
#define TK_WINDOW_CLOSE         188
#define TK_IGNORE               189
#define TK_EXPIRED              190
#define TK_FILL_HISTORY         191
#define TK_SUBTABLE             192
#define TK_KILL                 193
#define TK_CONNECTION           194
#define TK_TRANSACTION          195
#define TK_BALANCE              196
#define TK_VGROUP               197
#define TK_MERGE                198
#define TK_REDISTRIBUTE         199
#define TK_SPLIT                200
#define TK_DELETE               201
#define TK_INSERT               202
#define TK_NULL                 203
#define TK_NK_QUESTION          204
#define TK_NK_ARROW             205
#define TK_ROWTS                206
#define TK_QSTART               207
#define TK_QEND                 208
#define TK_QDURATION            209
#define TK_WSTART               210
#define TK_WEND                 211
#define TK_WDURATION            212
#define TK_IROWTS               213
#define TK_CAST                 214
#define TK_NOW                  215
#define TK_TODAY                216
#define TK_TIMEZONE             217
#define TK_CLIENT_VERSION       218
#define TK_SERVER_VERSION       219
#define TK_SERVER_STATUS        220
#define TK_CURRENT_USER         221
#define TK_COUNT                222
#define TK_LAST_ROW             223
#define TK_CASE                 224
#define TK_END                  225
#define TK_WHEN                 226
#define TK_THEN                 227
#define TK_ELSE                 228
#define TK_BETWEEN              229
#define TK_IS                   230
#define TK_NK_LT                231
#define TK_NK_GT                232
#define TK_NK_LE                233
#define TK_NK_GE                234
#define TK_NK_NE                235
#define TK_MATCH                236
#define TK_NMATCH               237
#define TK_CONTAINS             238
#define TK_IN                   239
#define TK_JOIN                 240
#define TK_INNER                241
#define TK_SELECT               242
#define TK_DISTINCT             243
#define TK_WHERE                244
#define TK_PARTITION            245
#define TK_BY                   246
#define TK_SESSION              247
#define TK_STATE_WINDOW         248
#define TK_SLIDING              249
#define TK_FILL                 250
#define TK_VALUE                251
#define TK_NONE                 252
#define TK_PREV                 253
#define TK_LINEAR               254
#define TK_NEXT                 255
#define TK_HAVING               256
#define TK_RANGE                257
#define TK_EVERY                258
#define TK_ORDER                259
#define TK_SLIMIT               260
#define TK_SOFFSET              261
#define TK_LIMIT                262
#define TK_OFFSET               263
#define TK_ASC                  264
#define TK_NULLS                265
#define TK_ABORT                266
#define TK_AFTER                267
#define TK_ATTACH               268
#define TK_BEFORE               269
#define TK_BEGIN                270
#define TK_BITAND               271
#define TK_BITNOT               272
#define TK_BITOR                273
#define TK_BLOCKS               274
#define TK_CHANGE               275
#define TK_COMMA                276
#define TK_COMPACT              277
#define TK_CONCAT               278
#define TK_CONFLICT             279
#define TK_COPY                 280
#define TK_DEFERRED             281
#define TK_DELIMITERS           282
#define TK_DETACH               283
#define TK_DIVIDE               284
#define TK_DOT                  285
#define TK_EACH                 286
#define TK_FAIL                 287
#define TK_FILE                 288
#define TK_FOR                  289
#define TK_GLOB                 290
#define TK_ID                   291
#define TK_IMMEDIATE            292
#define TK_IMPORT               293
#define TK_INITIALLY            294
#define TK_INSTEAD              295
#define TK_ISNULL               296
#define TK_KEY                  297
#define TK_MODULES              298
#define TK_NK_BITNOT            299
#define TK_NK_SEMI              300
#define TK_NOTNULL              301
#define TK_OF                   302
#define TK_PLUS                 303
#define TK_PRIVILEGE            304
#define TK_RAISE                305
#define TK_REPLACE              306
#define TK_RESTRICT             307
#define TK_ROW                  308
#define TK_SEMI                 309
#define TK_STAR                 310
#define TK_STATEMENT            311
#define TK_STRING               312
#define TK_TIMES                313
#define TK_UPDATE               314
#define TK_VALUES               315
#define TK_VARIABLE             316
#define TK_VIEW                 317
#define TK_WAL                  318

#define TK_NK_SPACE   600
#define TK_NK_COMMENT 601
#define TK_NK_ILLEGAL 602
#define TK_NK_HEX     603  // hex number  0x123
#define TK_NK_OCT     604  // oct number
#define TK_NK_BIN     605  // bin format data 0b111

#define TK_NK_NIL 65535

#endif /*_TD_COMMON_TOKEN_H_*/
