/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 360
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EFillMode yy54;
  int32_t yy100;
  bool yy137;
  int64_t yy189;
  SToken yy209;
  ENullOrder yy217;
  SDataType yy304;
  EOperatorType yy380;
  SNodeList* yy424;
  EOrder yy578;
  SAlterOption yy605;
  EJoinType yy612;
  SNode* yy632;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             611
#define YYNRULE              454
#define YYNTOKEN             239
#define YY_MAX_SHIFT         610
#define YY_MIN_SHIFTREDUCE   900
#define YY_MAX_SHIFTREDUCE   1353
#define YY_ERROR_ACTION      1354
#define YY_ACCEPT_ACTION     1355
#define YY_NO_ACTION         1356
#define YY_MIN_REDUCE        1357
#define YY_MAX_REDUCE        1810
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2213)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   386, 1644,  387, 1389,  295,  394,  525,  387, 1389, 1740,
 /*    10 */    62,  930,   35,   33,   28,  226, 1477, 1657,  104, 1479,
 /*    20 */   304, 1641, 1167,  108, 1532,  425,   36,   34,   32,   31,
 /*    30 */    30,  294, 1483, 1737, 1355, 1488, 1530, 1637, 1643, 1641,
 /*    40 */    36,   34,   32,   31,   30, 1673,  524, 1165,  528,  934,
 /*    50 */   935,  524,   77,  509,  485, 1637, 1643,  947,   14,  946,
 /*    60 */    35,   33, 1294,  508, 1173,  113,  528, 1627,  304,  524,
 /*    70 */  1167,  352,  277, 1480,   36,   34,   32,   31,   30,  512,
 /*    80 */   404,    1,  307,  112, 1686, 1577,  948,   82, 1658,  511,
 /*    90 */  1660, 1661,  507,  320,  528, 1165, 1205, 1726, 1657, 1380,
 /*   100 */  1191, 1725, 1722,  607, 1256,  274,   14,   39,   35,   33,
 /*   110 */   603,  602, 1173, 1166,  385, 1788,  304,  389, 1167, 1644,
 /*   120 */   277,  110,  312, 1673,   55,  999, 1673, 1645, 1787,    2,
 /*   130 */    38,  478, 1785, 1788,  509,  487,  142, 1733, 1734, 1641,
 /*   140 */  1738,   55, 1001, 1165,  508,   56,  145, 1641, 1627, 1627,
 /*   150 */  1785,  607, 1256, 1257,   14, 1637, 1643,   62, 1168, 1465,
 /*   160 */  1173, 1166,  479, 1637, 1643, 1686,  528,  477,  256, 1658,
 /*   170 */   511, 1660, 1661,  507,  528,  528, 1262,    2, 1350, 1484,
 /*   180 */  1171, 1172,  376, 1218, 1219, 1221, 1222, 1223, 1224, 1225,
 /*   190 */   504,  526, 1233, 1234, 1235, 1236, 1237, 1238, 1192,  607,
 /*   200 */   345, 1257,  344,   64,  292, 1379, 1168,  191,  429, 1166,
 /*   210 */   148, 1189,   27,  302, 1251, 1252, 1253, 1254, 1255, 1259,
 /*   220 */  1260, 1261,   55,  130, 1262, 1369,  158,  157, 1171, 1172,
 /*   230 */   428, 1218, 1219, 1221, 1222, 1223, 1224, 1225,  504,  526,
 /*   240 */  1233, 1234, 1235, 1236, 1237, 1238, 1416,   36,   34,   32,
 /*   250 */    31,   30,  559,  148, 1168, 1627, 1406, 1318, 1349,  148,
 /*   260 */    27,  302, 1251, 1252, 1253, 1254, 1255, 1259, 1260, 1261,
 /*   270 */   148,  558,   55,  557,  556,  555, 1171, 1172,  440, 1218,
 /*   280 */  1219, 1221, 1222, 1223, 1224, 1225,  504,  526, 1233, 1234,
 /*   290 */  1235, 1236, 1237, 1238,   35,   33,  471, 1316, 1317, 1319,
 /*   300 */  1320,  131,  304,  154, 1167, 1445,  583,  582,  581,  319,
 /*   310 */   561,  580,  579,  578,  114,  573,  572,  571,  570,  569,
 /*   320 */   568,  567,  566,  121,  562, 1193,  559, 1466,   60, 1165,
 /*   330 */    94,   59, 1657,   93,   92,   91,   90,   89,   88,   87,
 /*   340 */    86,   85,   35,   33, 1239,  558, 1173,  557,  556,  555,
 /*   350 */   304,  148, 1167,  439,  438,   32,   31,   30,  437,  554,
 /*   360 */  1673,  109,  434,    8, 1301,  433,  432,  431,  509,  140,
 /*   370 */  1191,   36,   34,   32,   31,   30, 1788, 1165,  508, 1788,
 /*   380 */   127, 1526, 1627,  393,  404,  607,  389, 1190,  474,  146,
 /*   390 */    35,   33, 1786, 1785, 1173, 1166, 1785,  451,  304, 1686,
 /*   400 */  1167,  148,  132, 1658,  511, 1660, 1661,  507, 1740,  528,
 /*   410 */   449,    9,  436,  435, 1037,  551,  550,  549, 1041,  548,
 /*   420 */  1043, 1044,  547, 1046,  544, 1165, 1052,  541, 1054, 1055,
 /*   430 */   538,  535, 1736,  607, 1419,   36,   34,   32,   31,   30,
 /*   440 */  1168, 1308, 1173, 1166,   24,  316,  490, 1802,  249,  461,
 /*   450 */   217, 1518, 1568, 1570,   36,   34,   32,   31,   30,    9,
 /*   460 */   480,  475, 1171, 1172,  485, 1218, 1219, 1221, 1222, 1223,
 /*   470 */  1224, 1225,  504,  526, 1233, 1234, 1235, 1236, 1237, 1238,
 /*   480 */  1378,  607,   36,   34,   32,   31,   30, 1473, 1168, 1532,
 /*   490 */  1565, 1166,  148,  112,  439,  438,  309,  156,  462,  437,
 /*   500 */   346, 1530,  109,  434, 1463, 1205,  433,  432,  431, 1194,
 /*   510 */  1171, 1172,  485, 1218, 1219, 1221, 1222, 1223, 1224, 1225,
 /*   520 */   504,  526, 1233, 1234, 1235, 1236, 1237, 1238,   11,   10,
 /*   530 */  1627,  110, 1532, 1258, 1220,  946, 1168,  308, 1788,  315,
 /*   540 */  1788,  112,  577,  575, 1530,  128,  143, 1733, 1734, 1377,
 /*   550 */  1738,  145,  286,  145, 1490, 1785, 1263, 1785, 1171, 1172,
 /*   560 */   423, 1218, 1219, 1221, 1222, 1223, 1224, 1225,  504,  526,
 /*   570 */  1233, 1234, 1235, 1236, 1237, 1238,   35,   33,  273,  110,
 /*   580 */  1189, 1128, 1569, 1570,  304, 1657, 1167,  369,  525, 1130,
 /*   590 */   381, 1740,   25,  525,  144, 1733, 1734,  559, 1738, 1627,
 /*   600 */   104,  287,    7,  285,  284,  350,  427,  430,  382, 1270,
 /*   610 */   429, 1165, 1358, 1673, 1376, 1735,  558, 1488,  557,  556,
 /*   620 */   555,  509, 1488, 1244,  512, 1375,  337, 1475, 1173, 1191,
 /*   630 */  1578,  508,  428,   94,  202, 1627,   93,   92,   91,   90,
 /*   640 */    89,   88,   87,   86,   85,    2,  339,  335,  391, 1464,
 /*   650 */  1129,   70, 1686, 1191, 1189,   81, 1658,  511, 1660, 1661,
 /*   660 */   507,  453,  528,  564, 1627, 1726,  565,  607, 1460,  297,
 /*   670 */  1722, 1801, 1481, 1374, 1471, 1627,   54, 1166,  380,  493,
 /*   680 */  1760,  375,  374,  373,  372,  371,  368,  367,  366,  365,
 /*   690 */   364,  360,  359,  358,  357,  356,  355,  354,  353,   26,
 /*   700 */  1167, 1788,  576,  610,  525,  501,  561,  314, 1532,   36,
 /*   710 */    34,   32,   31,   30,  145,  128,  351,  243, 1785, 1373,
 /*   720 */  1531,  128, 1168, 1627, 1490, 1165, 1372, 1293, 1371,  105,
 /*   730 */  1491,  194, 1368, 1488, 1657,  599,  595,  591,  587,  242,
 /*   740 */   934,  935, 1173,  340, 1171, 1172,  503, 1218, 1219, 1221,
 /*   750 */  1222, 1223, 1224, 1225,  504,  526, 1233, 1234, 1235, 1236,
 /*   760 */  1237, 1238, 1673,  525,   78,  525,  496,  237, 1616, 1627,
 /*   770 */   509,  317, 1370,  525, 1289,  361, 1627,  362, 1627,  128,
 /*   780 */   508,  607, 1627, 1367, 1627,  403,  485,  525, 1490, 1366,
 /*   790 */   489, 1166, 1488, 1220, 1488, 1365, 1745, 1289,  460,  522,
 /*   800 */   521, 1686, 1488,  118,   80, 1658,  511, 1660, 1661,  507,
 /*   810 */  1657,  528,  525,  327, 1726,  112, 1488, 1220,  276, 1722,
 /*   820 */   525,   76,  525, 1364, 1485,  466,  182, 1248,  198,  180,
 /*   830 */  1788,   72, 1607, 1627,  523,  489, 1168,  184, 1673, 1627,
 /*   840 */   183, 1488, 1401,  147,  463, 1627,  509, 1785, 1144, 1488,
 /*   850 */   193, 1488, 1363,  110,  186,  553,  508,  185, 1171, 1172,
 /*   860 */  1627, 1362, 1361, 1360,  442,  494,  489,  525,  215, 1733,
 /*   870 */   484, 1657,  483, 1627,  444, 1788, 1446, 1686,  221,  239,
 /*   880 */    80, 1658,  511, 1660, 1661,  507, 1399,  528,  147,  452,
 /*   890 */  1726,  472, 1785,  525,  276, 1722, 1488,  188,  491, 1673,
 /*   900 */   187,   47, 1627,  190,  275,  318, 1788,  488,  445,  129,
 /*   910 */   454, 1627, 1627, 1627,  255,  447,  971,  508,  212,  145,
 /*   920 */   441, 1627, 1488, 1785,   46,  189,  253,   53, 1152, 1153,
 /*   930 */    52, 1390, 1657,  972, 1292, 1176,  205, 1674, 1686, 1352,
 /*   940 */  1353,   81, 1658,  511, 1660, 1661,  507,  159,  528,  422,
 /*   950 */    51, 1726, 1527,   50,  497,  297, 1722,  141,   11,   10,
 /*   960 */  1673, 1357, 1175, 1756,  486, 1315,  220,  223,  488,  218,
 /*   970 */    37,    3,   55, 1189,   37,  467, 1753,  207,  508,  225,
 /*   980 */   322,   37, 1627, 1647,  228,  103,  102,  101,  100,   99,
 /*   990 */    98,   97,   96,   95,  326,  116,  282,  117,  999, 1686,
 /*  1000 */   485, 1179,   81, 1658,  511, 1660, 1661,  507,   79,  528,
 /*  1010 */   283, 1264, 1726,  244, 1136, 1226,  297, 1722,  141,  118,
 /*  1020 */  1649,  363, 1122,   46,  533,  230, 1567,  155, 1178,  112,
 /*  1030 */   117,  370,  118,  119,  117,  378,  517, 1754,  236,  377,
 /*  1040 */   383,   58,   57,  349, 1657,  379,  153, 1195,  384,  489,
 /*  1050 */   392,  343, 1198,  395,  162,  396, 1197,  164, 1199,  397,
 /*  1060 */  1030,  167,  400,  272,  248, 1058,  333,  110,  329,  325,
 /*  1070 */   150, 1062, 1673, 1068, 1066,  120,  169,  398, 1196,  401,
 /*  1080 */   509,  402,  215, 1733,  484,  172,  483,   61,  405, 1788,
 /*  1090 */   508,  175,  424,  426, 1627, 1478,  179, 1474,  181, 1657,
 /*  1100 */   122,  148,  145,   84,  123, 1476, 1785,  291, 1472, 1173,
 /*  1110 */   124, 1686, 1611,  125,   81, 1658,  511, 1660, 1661,  507,
 /*  1120 */   245,  528,  456,  192, 1726,  455,  195, 1673,  297, 1722,
 /*  1130 */  1801,  197,  459,  464,  465,  509,  200,  246, 1194, 1783,
 /*  1140 */  1757,  473, 1767,  515,  203,  508, 1766,  482,  470, 1627,
 /*  1150 */  1657,    6,  206,  296,  476, 1747,  135,  211,  469,    5,
 /*  1160 */   111, 1289, 1657, 1193,   40,  213, 1686,  495,  219,   81,
 /*  1170 */  1658,  511, 1660, 1661,  507, 1741,  528,  298, 1673, 1726,
 /*  1180 */  1804,  214,   18,  297, 1722, 1801,  509,  498,  518,  222,
 /*  1190 */  1673, 1707, 1576,  513, 1744,  514,  508, 1575,  509,  224,
 /*  1200 */  1627, 1784,  306,  492,  499,  520,  489,  519,  508,  232,
 /*  1210 */   234,   71, 1627, 1489,  247, 1657,   69, 1686,  489,  250,
 /*  1220 */   260, 1658,  511, 1660, 1661,  507,  241,  528, 1461, 1686,
 /*  1230 */   606,   48,  260, 1658,  511, 1660, 1661,  507,  254,  528,
 /*  1240 */   531,  134, 1621, 1673,  261,  271, 1788,  293, 1657,  262,
 /*  1250 */   252,  509, 1620,  321, 1617,  323,  324, 1161, 1788,  147,
 /*  1260 */  1162,  508,  151, 1785,  328, 1627, 1615,  330,  331,  332,
 /*  1270 */  1614,  145,  334, 1613,  336, 1785, 1673, 1612,  338, 1597,
 /*  1280 */   152,  341, 1686,  342,  506,   82, 1658,  511, 1660, 1661,
 /*  1290 */   507, 1139,  528, 1138,  508, 1726, 1591, 1590, 1627,  500,
 /*  1300 */  1722,  347,  348, 1589, 1588, 1105, 1657, 1560, 1559, 1558,
 /*  1310 */  1557, 1556, 1555, 1554, 1553, 1686,  115, 1542,  269, 1658,
 /*  1320 */   511, 1660, 1661,  507,  505,  528,  502, 1698, 1552, 1551,
 /*  1330 */  1550, 1549, 1548, 1547, 1673, 1546, 1545, 1544, 1543, 1541,
 /*  1340 */  1540, 1539,  509, 1538, 1537, 1107, 1536, 1535, 1534, 1533,
 /*  1350 */  1418, 1386,  508, 1385, 1657,  160, 1627,  106, 1605,  138,
 /*  1360 */   161,  107, 1599,  388, 1583,  390,  937, 1657, 1582,  936,
 /*  1370 */   168,  166, 1573, 1686, 1467, 1417,   82, 1658,  511, 1660,
 /*  1380 */  1661,  507, 1673,  528,  965, 1415, 1726, 1413, 1411,  406,
 /*  1390 */   509, 1723,  410,  171,  408, 1673,  412, 1409, 1398,  407,
 /*  1400 */   508, 1397, 1384,  509, 1627,  411,  416,  468,  414, 1469,
 /*  1410 */   415,  419, 1071,  508,  418, 1657,   45, 1627,  420, 1468,
 /*  1420 */  1072, 1686, 1407,  998,  270, 1658,  511, 1660, 1661,  507,
 /*  1430 */   997,  528,  574,  996, 1686,  576,  995,  265, 1658,  511,
 /*  1440 */  1660, 1661,  507, 1673,  528,  288,  992,  991, 1402,  289,
 /*  1450 */   990,  509,  443, 1400,  446,  290, 1383,  448,  178, 1382,
 /*  1460 */   450,  508,   83, 1604, 1146, 1627, 1657, 1598,  126,  457,
 /*  1470 */  1581, 1580,   49, 1572,   65,  481,  199, 1657,    4,   15,
 /*  1480 */   210,   37, 1686,   16,   43,  132, 1658,  511, 1660, 1661,
 /*  1490 */   507,  133,  528,  204, 1673, 1314,  208,   22,  209, 1647,
 /*  1500 */  1307,   66,  509,   23,  216, 1673, 1286, 1285,  458,   41,
 /*  1510 */    42,  201,  508,  506,   13, 1338, 1627,   17,  136,  301,
 /*  1520 */   196,   10, 1337,  508,  299, 1657, 1343, 1627, 1332, 1342,
 /*  1530 */  1803, 1341,  300, 1686,   19,   29,  270, 1658,  511, 1660,
 /*  1540 */  1661,  507,  137,  528, 1686,  149, 1228,  269, 1658,  511,
 /*  1550 */  1660, 1661,  507, 1673,  528, 1213, 1699, 1249, 1657, 1571,
 /*  1560 */  1227,  509,   12,  233,  510, 1646,  238,   20,   21,  516,
 /*  1570 */   227,  508, 1312,  229,  235, 1627,  231,   67,  303, 1230,
 /*  1580 */    68, 1689,   72,  527, 1183,   44, 1673, 1059,  532,  313,
 /*  1590 */  1056,  534, 1686,  536,  509,  270, 1658,  511, 1660, 1661,
 /*  1600 */   507,  530,  528,  539,  508,  537, 1036, 1053, 1627,  540,
 /*  1610 */   542,  305, 1047,  543,  545, 1067, 1045,  546,   73, 1051,
 /*  1620 */  1050, 1657, 1049, 1048,  552, 1686,  177,  560,  270, 1658,
 /*  1630 */   511, 1660, 1661,  507, 1657,  528,   74, 1064,  139,   75,
 /*  1640 */  1065,  963,  987, 1005,  421,  417,  413,  409,  176, 1673,
 /*  1650 */   563,  240,  980,  985,  984,  983,  982,  509,  981,  979,
 /*  1660 */   978, 1002, 1673, 1000,  975,  974,  973,  508,  970,  969,
 /*  1670 */   509, 1627,  968,   63, 1657, 1414,  174,  585,  584,  586,
 /*  1680 */   508, 1412,  588,  589, 1627,  590, 1410,  592, 1686,  593,
 /*  1690 */   594,  264, 1658,  511, 1660, 1661,  507, 1408,  528,  596,
 /*  1700 */   597, 1686, 1673,  598,  266, 1658,  511, 1660, 1661,  507,
 /*  1710 */   509,  528, 1396, 1395,  600,  601, 1381,  604, 1169,  605,
 /*  1720 */   508,  251,  608,  609, 1627, 1657, 1356, 1356, 1356, 1356,
 /*  1730 */  1356, 1356, 1356,  173, 1356,  165, 1356,  170, 1356,  399,
 /*  1740 */  1356, 1686, 1356, 1356,  257, 1658,  511, 1660, 1661,  507,
 /*  1750 */  1356,  528, 1356, 1673, 1356, 1657, 1356, 1356, 1356,  163,
 /*  1760 */  1356,  509, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*  1770 */  1356,  508, 1356, 1356, 1356, 1627, 1356, 1356, 1356, 1356,
 /*  1780 */  1356, 1356, 1356, 1673, 1356, 1356, 1356, 1657, 1356, 1356,
 /*  1790 */  1356,  509, 1686, 1356, 1356,  267, 1658,  511, 1660, 1661,
 /*  1800 */   507,  508,  528, 1356, 1356, 1627, 1356, 1356, 1356, 1356,
 /*  1810 */  1356, 1356, 1356, 1356, 1356, 1673, 1356, 1356, 1356, 1356,
 /*  1820 */  1356, 1356, 1686,  509, 1356,  258, 1658,  511, 1660, 1661,
 /*  1830 */   507, 1356,  528,  508, 1356, 1356, 1356, 1627, 1657, 1356,
 /*  1840 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1657, 1356, 1356,
 /*  1850 */  1356, 1356, 1356, 1356, 1686, 1356, 1356,  268, 1658,  511,
 /*  1860 */  1660, 1661,  507, 1356,  528, 1356, 1673, 1356, 1356, 1356,
 /*  1870 */  1356, 1356, 1356, 1356,  509, 1673, 1356, 1356, 1356, 1356,
 /*  1880 */  1356, 1356, 1356,  509,  508, 1356, 1356, 1356, 1627, 1356,
 /*  1890 */  1356, 1356, 1356,  508, 1356, 1356, 1356, 1627, 1356, 1356,
 /*  1900 */  1657, 1356, 1356, 1356, 1356, 1686, 1356, 1356,  259, 1658,
 /*  1910 */   511, 1660, 1661,  507, 1686,  528, 1657, 1669, 1658,  511,
 /*  1920 */  1660, 1661,  507, 1356,  528, 1356, 1356, 1356, 1673, 1356,
 /*  1930 */  1356, 1356, 1356, 1356, 1356, 1356,  509, 1356, 1356, 1356,
 /*  1940 */  1356, 1356, 1356, 1356, 1673, 1356,  508, 1356, 1657, 1356,
 /*  1950 */  1627, 1356,  509, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*  1960 */  1356, 1356,  508, 1356, 1356, 1356, 1627, 1686, 1356, 1356,
 /*  1970 */  1668, 1658,  511, 1660, 1661,  507, 1673,  528, 1657, 1356,
 /*  1980 */  1356, 1356, 1356, 1686,  509, 1356, 1667, 1658,  511, 1660,
 /*  1990 */  1661,  507, 1356,  528,  508, 1356, 1356, 1356, 1627, 1356,
 /*  2000 */  1356, 1356, 1356, 1356, 1356, 1356, 1673, 1356, 1356, 1356,
 /*  2010 */  1356, 1356, 1356, 1356,  509, 1686, 1356, 1356,  280, 1658,
 /*  2020 */   511, 1660, 1661,  507,  508,  528, 1657, 1356, 1627, 1356,
 /*  2030 */  1356,  311,  310, 1356, 1356, 1657, 1356, 1356, 1356, 1356,
 /*  2040 */  1356, 1181, 1356, 1356, 1356, 1686, 1356, 1356,  279, 1658,
 /*  2050 */   511, 1660, 1661,  507, 1673,  528, 1356, 1356, 1356, 1356,
 /*  2060 */  1356, 1356,  509, 1673, 1356, 1356, 1174, 1356, 1356, 1356,
 /*  2070 */  1356,  509,  508, 1356, 1356, 1356, 1627, 1356, 1356, 1356,
 /*  2080 */  1356,  508, 1356, 1173, 1356, 1627, 1356, 1356, 1356, 1356,
 /*  2090 */  1657, 1356, 1356, 1686, 1356, 1356,  281, 1658,  511, 1660,
 /*  2100 */  1661,  507, 1686,  528, 1356,  278, 1658,  511, 1660, 1661,
 /*  2110 */   507, 1356,  528, 1356, 1356, 1356, 1356, 1356, 1673, 1356,
 /*  2120 */  1356, 1356,  529, 1356, 1356, 1356,  509, 1356, 1356, 1356,
 /*  2130 */  1356, 1356, 1177, 1356, 1356, 1356,  508, 1356, 1356, 1356,
 /*  2140 */  1627, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*  2150 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1686, 1356, 1356,
 /*  2160 */   263, 1658,  511, 1660, 1661,  507, 1356,  528, 1356, 1356,
 /*  2170 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1182, 1356, 1356,
 /*  2180 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*  2190 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1185,
 /*  2200 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*  2210 */   526, 1233, 1234,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   245,  272,  247,  248,  275,  245,  249,  247,  248,  310,
 /*    10 */   254,    4,   12,   13,  323,  324,  271,  242,  261,  272,
 /*    20 */    20,  292,   22,  267,  270,  268,   12,   13,   14,   15,
 /*    30 */    16,  277,  276,  334,  239,  278,  282,  308,  309,  292,
 /*    40 */    12,   13,   14,   15,   16,  270,   20,   47,  319,   42,
 /*    50 */    43,   20,  252,  278,  249,  308,  309,   20,   58,   22,
 /*    60 */    12,   13,   14,  288,   64,  265,  319,  292,   20,   20,
 /*    70 */    22,  249,   58,  273,   12,   13,   14,   15,   16,  288,
 /*    80 */    57,   81,  291,  278,  309,  294,   49,  312,  313,  314,
 /*    90 */   315,  316,  317,  298,  319,   47,   82,  322,  242,  242,
 /*   100 */    20,  326,  327,  103,   90,  283,   58,   81,   12,   13,
 /*   110 */   250,  251,   64,  113,  246,  338,   20,  249,   22,  272,
 /*   120 */    58,  316,  275,  270,   81,   47,  270,  272,  351,   81,
 /*   130 */    81,  278,  355,  338,  278,  330,  331,  332,  333,  292,
 /*   140 */   335,   81,   64,   47,  288,    4,  351,  292,  292,  292,
 /*   150 */   355,  103,   90,  139,   58,  308,  309,  254,  158,    0,
 /*   160 */    64,  113,   20,  308,  309,  309,  319,  314,  312,  313,
 /*   170 */   314,  315,  316,  317,  319,  319,  162,   81,  150,  276,
 /*   180 */   180,  181,   75,  183,  184,  185,  186,  187,  188,  189,
 /*   190 */   190,  191,  192,  193,  194,  195,  196,  197,   20,  103,
 /*   200 */   157,  139,  159,  167,  168,  242,  158,  171,   93,  113,
 /*   210 */   210,   20,  198,  199,  200,  201,  202,  203,  204,  205,
 /*   220 */   206,  207,   81,  241,  162,  243,  119,  120,  180,  181,
 /*   230 */   115,  183,  184,  185,  186,  187,  188,  189,  190,  191,
 /*   240 */   192,  193,  194,  195,  196,  197,    0,   12,   13,   14,
 /*   250 */    15,   16,   93,  210,  158,  292,    0,  180,  230,  210,
 /*   260 */   198,  199,  200,  201,  202,  203,  204,  205,  206,  207,
 /*   270 */   210,  112,   81,  114,  115,  116,  180,  181,   22,  183,
 /*   280 */   184,  185,  186,  187,  188,  189,  190,  191,  192,  193,
 /*   290 */   194,  195,  196,  197,   12,   13,  219,  220,  221,  222,
 /*   300 */   223,  255,   20,   55,   22,  259,   60,   61,   62,   63,
 /*   310 */    57,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   320 */    74,   75,   76,   77,   78,   20,   93,    0,   80,   47,
 /*   330 */    21,   83,  242,   24,   25,   26,   27,   28,   29,   30,
 /*   340 */    31,   32,   12,   13,   14,  112,   64,  114,  115,  116,
 /*   350 */    20,  210,   22,   60,   61,   14,   15,   16,   65,   92,
 /*   360 */   270,   68,   69,   81,   14,   72,   73,   74,  278,  269,
 /*   370 */    20,   12,   13,   14,   15,   16,  338,   47,  288,  338,
 /*   380 */   145,  281,  292,  246,   57,  103,  249,   20,  143,  351,
 /*   390 */    12,   13,  351,  355,   64,  113,  355,   21,   20,  309,
 /*   400 */    22,  210,  312,  313,  314,  315,  316,  317,  310,  319,
 /*   410 */    34,   81,  256,  257,   94,   95,   96,   97,   98,   99,
 /*   420 */   100,  101,  102,  103,  104,   47,  106,  107,  108,  109,
 /*   430 */   110,  111,  334,  103,    0,   12,   13,   14,   15,   16,
 /*   440 */   158,   82,   64,  113,    2,  280,  356,  357,  263,  249,
 /*   450 */   145,  266,  287,  288,   12,   13,   14,   15,   16,   81,
 /*   460 */   215,  216,  180,  181,  249,  183,  184,  185,  186,  187,
 /*   470 */   188,  189,  190,  191,  192,  193,  194,  195,  196,  197,
 /*   480 */   242,  103,   12,   13,   14,   15,   16,  271,  158,  270,
 /*   490 */   278,  113,  210,  278,   60,   61,  277,  285,  298,   65,
 /*   500 */   298,  282,   68,   69,    0,   82,   72,   73,   74,   20,
 /*   510 */   180,  181,  249,  183,  184,  185,  186,  187,  188,  189,
 /*   520 */   190,  191,  192,  193,  194,  195,  196,  197,    1,    2,
 /*   530 */   292,  316,  270,  139,  184,   22,  158,  262,  338,  277,
 /*   540 */   338,  278,  256,  257,  282,  270,  331,  332,  333,  242,
 /*   550 */   335,  351,   35,  351,  279,  355,  162,  355,  180,  181,
 /*   560 */    47,  183,  184,  185,  186,  187,  188,  189,  190,  191,
 /*   570 */   192,  193,  194,  195,  196,  197,   12,   13,   18,  316,
 /*   580 */    20,   80,  287,  288,   20,  242,   22,   27,  249,   88,
 /*   590 */    30,  310,  198,  249,  331,  332,  333,   93,  335,  292,
 /*   600 */   261,   84,   37,   86,   87,  261,   89,  268,   48,   82,
 /*   610 */    93,   47,    0,  270,  242,  334,  112,  278,  114,  115,
 /*   620 */   116,  278,  278,   14,  288,  242,  153,  271,   64,   20,
 /*   630 */   294,  288,  115,   21,  145,  292,   24,   25,   26,   27,
 /*   640 */    28,   29,   30,   31,   32,   81,  173,  174,   14,    0,
 /*   650 */   149,  252,  309,   20,   20,  312,  313,  314,  315,  316,
 /*   660 */   317,  298,  319,   64,  292,  322,  258,  103,  260,  326,
 /*   670 */   327,  328,  273,  242,  271,  292,    3,  113,  118,   41,
 /*   680 */   337,  121,  122,  123,  124,  125,  126,  127,  128,  129,
 /*   690 */   130,  131,  132,  133,  134,  135,  136,  137,  138,    2,
 /*   700 */    22,  338,   41,   19,  249,   58,   57,  262,  270,   12,
 /*   710 */    13,   14,   15,   16,  351,  270,  261,   33,  355,  242,
 /*   720 */   282,  270,  158,  292,  279,   47,  242,    4,  242,   45,
 /*   730 */   279,  271,  242,  278,  242,   51,   52,   53,   54,   55,
 /*   740 */    42,   43,   64,   82,  180,  181,  271,  183,  184,  185,
 /*   750 */   186,  187,  188,  189,  190,  191,  192,  193,  194,  195,
 /*   760 */   196,  197,  270,  249,   80,  249,   41,   83,    0,  292,
 /*   770 */   278,  262,  243,  249,  209,  261,  292,  261,  292,  270,
 /*   780 */   288,  103,  292,  242,  292,  261,  249,  249,  279,  242,
 /*   790 */   298,  113,  278,  184,  278,  242,  208,  209,  302,  261,
 /*   800 */   116,  309,  278,   41,  312,  313,  314,  315,  316,  317,
 /*   810 */   242,  319,  249,   45,  322,  278,  278,  184,  326,  327,
 /*   820 */   249,   81,  249,  242,  261,  141,   85,  180,  144,   88,
 /*   830 */   338,   91,  261,  292,  261,  298,  158,   85,  270,  292,
 /*   840 */    88,  278,    0,  351,   82,  292,  278,  355,  164,  278,
 /*   850 */   166,  278,  242,  316,   85,  271,  288,   88,  180,  181,
 /*   860 */   292,  242,  242,  242,   22,  227,  298,  249,  331,  332,
 /*   870 */   333,  242,  335,  292,    4,  338,  259,  309,  358,  261,
 /*   880 */   312,  313,  314,  315,  316,  317,    0,  319,  351,   19,
 /*   890 */   322,  349,  355,  249,  326,  327,  278,   85,  225,  270,
 /*   900 */    88,  145,  292,   33,  148,  261,  338,  278,   22,   18,
 /*   910 */   306,  292,  292,  292,   23,   45,   47,  288,  343,  351,
 /*   920 */    50,  292,  278,  355,   41,   55,   35,   36,  169,  170,
 /*   930 */    39,  248,  242,   64,  211,   47,   41,  270,  309,  195,
 /*   940 */   196,  312,  313,  314,  315,  316,  317,   56,  319,  250,
 /*   950 */    80,  322,  281,   83,  229,  326,  327,  328,    1,    2,
 /*   960 */   270,    0,   47,  311,  336,   82,  352,  352,  278,  340,
 /*   970 */    41,  339,   81,   20,   41,  346,  347,   82,  288,  352,
 /*   980 */   249,   41,  292,   44,   41,   24,   25,   26,   27,   28,
 /*   990 */    29,   30,   31,   32,   45,   41,  307,   41,   47,  309,
 /*  1000 */   249,  113,  312,  313,  314,  315,  316,  317,  117,  319,
 /*  1010 */   256,   82,  322,  300,  156,   82,  326,  327,  328,   41,
 /*  1020 */    81,  249,   82,   41,   41,   82,  249,   40,  113,  278,
 /*  1030 */    41,  286,   41,   41,   41,  139,   82,  347,   82,  284,
 /*  1040 */   249,  150,  151,  152,  242,  284,  155,   20,  244,  298,
 /*  1050 */   244,  160,   20,  304,  254,  288,   20,  254,   20,  296,
 /*  1060 */    82,  254,  296,  172,   82,   82,  175,  316,  177,  178,
 /*  1070 */   179,   82,  270,   82,   82,   82,  254,  299,   20,  278,
 /*  1080 */   278,  289,  331,  332,  333,  254,  335,  254,  249,  338,
 /*  1090 */   288,  254,  244,  270,  292,  270,  270,  270,  270,  242,
 /*  1100 */   270,  210,  351,  249,  270,  270,  355,  244,  270,   64,
 /*  1110 */   270,  309,  292,  270,  312,  313,  314,  315,  316,  317,
 /*  1120 */   304,  319,  303,  252,  322,  165,  252,  270,  326,  327,
 /*  1130 */   328,  252,  288,  278,  289,  278,  252,  296,   20,  337,
 /*  1140 */   311,  218,  348,  217,  293,  288,  348,  147,  292,  292,
 /*  1150 */   242,  224,  293,  292,  292,  345,  342,  344,  213,  212,
 /*  1160 */   278,  209,  242,   20,   40,  341,  309,  226,  353,  312,
 /*  1170 */   313,  314,  315,  316,  317,  310,  319,  231,  270,  322,
 /*  1180 */   359,  329,   81,  326,  327,  328,  278,  228,  142,  353,
 /*  1190 */   270,  325,  293,  292,  337,  292,  288,  293,  278,  353,
 /*  1200 */   292,  354,  292,  354,  354,  289,  298,  290,  288,  278,
 /*  1210 */   252,   81,  292,  278,  266,  242,  252,  309,  298,  249,
 /*  1220 */   312,  313,  314,  315,  316,  317,  252,  319,  260,  309,
 /*  1230 */   244,  301,  312,  313,  314,  315,  316,  317,  240,  319,
 /*  1240 */   274,  305,    0,  270,  264,  264,  338,  297,  242,  264,
 /*  1250 */   253,  278,    0,   72,    0,   47,  176,   47,  338,  351,
 /*  1260 */    47,  288,   47,  355,  176,  292,    0,   47,   47,  176,
 /*  1270 */     0,  351,   47,    0,   47,  355,  270,    0,   47,    0,
 /*  1280 */    81,  162,  309,  161,  278,  312,  313,  314,  315,  316,
 /*  1290 */   317,  113,  319,  158,  288,  322,    0,    0,  292,  326,
 /*  1300 */   327,  154,  153,    0,    0,   44,  242,    0,    0,    0,
 /*  1310 */     0,    0,    0,    0,    0,  309,   40,    0,  312,  313,
 /*  1320 */   314,  315,  316,  317,  318,  319,  320,  321,    0,    0,
 /*  1330 */     0,    0,    0,    0,  270,    0,    0,    0,    0,    0,
 /*  1340 */     0,    0,  278,    0,    0,   22,    0,    0,    0,    0,
 /*  1350 */     0,    0,  288,    0,  242,   40,  292,   37,    0,   41,
 /*  1360 */    38,   37,    0,   44,    0,   44,   14,  242,    0,   14,
 /*  1370 */   147,   37,    0,  309,    0,    0,  312,  313,  314,  315,
 /*  1380 */   316,  317,  270,  319,   59,    0,  322,    0,    0,   47,
 /*  1390 */   278,  327,   47,   37,   37,  270,   37,    0,    0,   45,
 /*  1400 */   288,    0,    0,  278,  292,   45,   37,  295,   47,    0,
 /*  1410 */    45,   45,   22,  288,   47,  242,   90,  292,   37,    0,
 /*  1420 */    47,  309,    0,   47,  312,  313,  314,  315,  316,  317,
 /*  1430 */    47,  319,   41,   47,  309,   41,   47,  312,  313,  314,
 /*  1440 */   315,  316,  317,  270,  319,   22,   47,   47,    0,   22,
 /*  1450 */    47,  278,   48,    0,   47,   22,    0,   22,   88,    0,
 /*  1460 */    22,  288,   20,    0,   47,  292,  242,    0,  163,   22,
 /*  1470 */     0,    0,  145,    0,   81,  350,   37,  242,   41,  214,
 /*  1480 */    44,   41,  309,  214,   41,  312,  313,  314,  315,  316,
 /*  1490 */   317,   81,  319,   82,  270,   82,   81,   81,   41,   44,
 /*  1500 */    82,   81,  278,   41,   44,  270,   82,   82,  145,  208,
 /*  1510 */    41,  140,  288,  278,  214,   47,  292,   41,   44,  295,
 /*  1520 */   142,    2,   47,  288,   47,  242,   82,  292,   82,   47,
 /*  1530 */   357,   47,   47,  309,   41,   81,  312,  313,  314,  315,
 /*  1540 */   316,  317,   44,  319,  309,   44,   82,  312,  313,  314,
 /*  1550 */   315,  316,  317,  270,  319,   22,  321,  180,  242,    0,
 /*  1560 */    82,  278,   81,   37,  182,   44,   44,   81,   81,  143,
 /*  1570 */    82,  288,   82,   81,  140,  292,   81,   81,  295,   82,
 /*  1580 */    81,   81,   91,   81,   22,   81,  270,   82,   47,   47,
 /*  1590 */    82,   81,  309,   47,  278,  312,  313,  314,  315,  316,
 /*  1600 */   317,   92,  319,   47,  288,   81,   22,   82,  292,   81,
 /*  1610 */    47,  295,   82,   81,   47,   47,   82,   81,   81,  105,
 /*  1620 */   105,  242,  105,  105,   93,  309,   33,   58,  312,  313,
 /*  1630 */   314,  315,  316,  317,  242,  319,   81,   22,   45,   81,
 /*  1640 */   113,   59,   47,   64,   51,   52,   53,   54,   55,  270,
 /*  1650 */    79,   41,   22,   47,   47,   47,   47,  278,   47,   47,
 /*  1660 */    47,   64,  270,   47,   47,   47,   47,  288,   47,   47,
 /*  1670 */   278,  292,   47,   80,  242,    0,   83,   45,   47,   37,
 /*  1680 */   288,    0,   47,   45,  292,   37,    0,   47,  309,   45,
 /*  1690 */    37,  312,  313,  314,  315,  316,  317,    0,  319,   47,
 /*  1700 */    45,  309,  270,   37,  312,  313,  314,  315,  316,  317,
 /*  1710 */   278,  319,    0,    0,   47,   46,    0,   22,   22,   21,
 /*  1720 */   288,   22,   21,   20,  292,  242,  360,  360,  360,  360,
 /*  1730 */   360,  360,  360,  140,  360,  142,  360,  144,  360,  146,
 /*  1740 */   360,  309,  360,  360,  312,  313,  314,  315,  316,  317,
 /*  1750 */   360,  319,  360,  270,  360,  242,  360,  360,  360,  166,
 /*  1760 */   360,  278,  360,  360,  360,  360,  360,  360,  360,  360,
 /*  1770 */   360,  288,  360,  360,  360,  292,  360,  360,  360,  360,
 /*  1780 */   360,  360,  360,  270,  360,  360,  360,  242,  360,  360,
 /*  1790 */   360,  278,  309,  360,  360,  312,  313,  314,  315,  316,
 /*  1800 */   317,  288,  319,  360,  360,  292,  360,  360,  360,  360,
 /*  1810 */   360,  360,  360,  360,  360,  270,  360,  360,  360,  360,
 /*  1820 */   360,  360,  309,  278,  360,  312,  313,  314,  315,  316,
 /*  1830 */   317,  360,  319,  288,  360,  360,  360,  292,  242,  360,
 /*  1840 */   360,  360,  360,  360,  360,  360,  360,  242,  360,  360,
 /*  1850 */   360,  360,  360,  360,  309,  360,  360,  312,  313,  314,
 /*  1860 */   315,  316,  317,  360,  319,  360,  270,  360,  360,  360,
 /*  1870 */   360,  360,  360,  360,  278,  270,  360,  360,  360,  360,
 /*  1880 */   360,  360,  360,  278,  288,  360,  360,  360,  292,  360,
 /*  1890 */   360,  360,  360,  288,  360,  360,  360,  292,  360,  360,
 /*  1900 */   242,  360,  360,  360,  360,  309,  360,  360,  312,  313,
 /*  1910 */   314,  315,  316,  317,  309,  319,  242,  312,  313,  314,
 /*  1920 */   315,  316,  317,  360,  319,  360,  360,  360,  270,  360,
 /*  1930 */   360,  360,  360,  360,  360,  360,  278,  360,  360,  360,
 /*  1940 */   360,  360,  360,  360,  270,  360,  288,  360,  242,  360,
 /*  1950 */   292,  360,  278,  360,  360,  360,  360,  360,  360,  360,
 /*  1960 */   360,  360,  288,  360,  360,  360,  292,  309,  360,  360,
 /*  1970 */   312,  313,  314,  315,  316,  317,  270,  319,  242,  360,
 /*  1980 */   360,  360,  360,  309,  278,  360,  312,  313,  314,  315,
 /*  1990 */   316,  317,  360,  319,  288,  360,  360,  360,  292,  360,
 /*  2000 */   360,  360,  360,  360,  360,  360,  270,  360,  360,  360,
 /*  2010 */   360,  360,  360,  360,  278,  309,  360,  360,  312,  313,
 /*  2020 */   314,  315,  316,  317,  288,  319,  242,  360,  292,  360,
 /*  2030 */   360,   12,   13,  360,  360,  242,  360,  360,  360,  360,
 /*  2040 */   360,   22,  360,  360,  360,  309,  360,  360,  312,  313,
 /*  2050 */   314,  315,  316,  317,  270,  319,  360,  360,  360,  360,
 /*  2060 */   360,  360,  278,  270,  360,  360,   47,  360,  360,  360,
 /*  2070 */   360,  278,  288,  360,  360,  360,  292,  360,  360,  360,
 /*  2080 */   360,  288,  360,   64,  360,  292,  360,  360,  360,  360,
 /*  2090 */   242,  360,  360,  309,  360,  360,  312,  313,  314,  315,
 /*  2100 */   316,  317,  309,  319,  360,  312,  313,  314,  315,  316,
 /*  2110 */   317,  360,  319,  360,  360,  360,  360,  360,  270,  360,
 /*  2120 */   360,  360,  103,  360,  360,  360,  278,  360,  360,  360,
 /*  2130 */   360,  360,  113,  360,  360,  360,  288,  360,  360,  360,
 /*  2140 */   292,  360,  360,  360,  360,  360,  360,  360,  360,  360,
 /*  2150 */   360,  360,  360,  360,  360,  360,  360,  309,  360,  360,
 /*  2160 */   312,  313,  314,  315,  316,  317,  360,  319,  360,  360,
 /*  2170 */   360,  360,  360,  360,  360,  360,  360,  158,  360,  360,
 /*  2180 */   360,  360,  360,  360,  360,  360,  360,  360,  360,  360,
 /*  2190 */   360,  360,  360,  360,  360,  360,  360,  360,  360,  180,
 /*  2200 */   360,  360,  360,  360,  360,  360,  360,  360,  360,  360,
 /*  2210 */   191,  192,  193,  360,  360,  360,  360,  360,  360,  360,
 /*  2220 */   360,  360,  360,  360,  360,  360,  360,  360,  360,  360,
 /*  2230 */   360,  360,  360,  360,  360,  360,  360,  360,  360,  360,
 /*  2240 */   360,  360,  360,  360,  360,  360,  360,  360,  360,  360,
 /*  2250 */   360,  360,  360,  360,  360,  360,  360,  360,  360,  360,
 /*  2260 */   360,  360,  360,  360,  360,  360,  360,  360,  360,  360,
 /*  2270 */   360,
};
#define YY_SHIFT_COUNT    (610)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2019)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   891,    0,    0,   48,   96,   96,   96,   96,  282,  282,
 /*    10 */    96,   96,  330,  378,  564,  378,  378,  378,  378,  378,
 /*    20 */   378,  378,  378,  378,  378,  378,  378,  378,  378,  378,
 /*    30 */   378,  378,  378,  378,  378,  378,  378,  378,   49,   49,
 /*    40 */    26,   26,   26, 2019, 2019, 2019, 2019,  191,   43,   60,
 /*    50 */    31,   31,    7,    7,  141,   60,   60,   31,   31,   31,
 /*    60 */    31,   31,   31,   23,   31,   80,  142,  178,   80,   31,
 /*    70 */    31,   80,   31,   80,   80,  178,   80,   31,  253,  560,
 /*    80 */    14,   62,   62,  309,  293,  678,  678,  678,  678,  678,
 /*    90 */   678,  678,  678,  678,  678,  678,  678,  678,  678,  678,
 /*   100 */   678,  678,  678,  678,  517,   37,  634,  634,  327,   78,
 /*   110 */   305,  305,  305,  649,   78,  367,  178,   80,   80,  178,
 /*   120 */   267,  599,  320,  320,  320,  320,  320,  320,  320,  684,
 /*   130 */   612,  434,   28,   77,   36,  245,  350,  609,  698,  513,
 /*   140 */   115,  489,  588,  565,  588,  673,  673,  673,  723,  633,
 /*   150 */   953,  949,  951,  858,  953,  953,  987,  896,  896,  953,
 /*   160 */  1027, 1027, 1032,   23,  178,   23, 1036, 1038,   23, 1036,
 /*   170 */    23,  367, 1058,   23,   23,  953,   23, 1027,   80,   80,
 /*   180 */    80,   80,   80,   80,   80,   80,   80,   80,   80,  953,
 /*   190 */  1027, 1045, 1032,  253,  960,  178,  253, 1036,  253,  367,
 /*   200 */  1058,  253, 1118,  923,  926, 1045,  923,  926, 1045, 1045,
 /*   210 */    80,  927, 1000,  945,  947,  952,  367, 1143, 1124,  959,
 /*   220 */   941,  946,  959,  941,  959,  941, 1101,  926, 1045, 1045,
 /*   230 */   926, 1045, 1046,  367, 1058,  253,  267,  253,  367, 1130,
 /*   240 */   599,  953,  253, 1027, 2213, 2213, 2213, 2213, 2213, 2213,
 /*   250 */  2213, 2213,  246, 1593,  961,  870,  359,  442,  697,  235,
 /*   260 */   423,  159,  504,  470,  470,  470,  470,  470,  470,  470,
 /*   270 */   470,  233,  473,  248,  107,  501,  527,  394,  341,  341,
 /*   280 */   341,  341,  768,  661,  741,  752,  769,  812,  256,  842,
 /*   290 */   886,  376,  759,  756,  762,  883,  895,  957,  744,  638,
 /*   300 */   725,  929,  647,  933,  939,  940,  943,  954,  956,  978,
 /*   310 */   888,  915,  982,  983,  989,  991,  992,  993,  740,  869,
 /*   320 */  1242, 1252, 1181, 1254, 1208, 1080, 1210, 1213, 1215, 1088,
 /*   330 */  1266, 1220, 1221, 1093, 1270, 1225, 1273, 1227, 1277, 1231,
 /*   340 */  1279, 1199, 1119, 1122, 1178, 1135, 1296, 1297, 1147, 1149,
 /*   350 */  1303, 1304, 1261, 1307, 1308, 1309, 1310, 1311, 1312, 1313,
 /*   360 */  1314, 1328, 1329, 1330, 1331, 1332, 1333, 1335, 1336, 1337,
 /*   370 */  1338, 1276, 1317, 1339, 1340, 1341, 1343, 1344, 1323, 1346,
 /*   380 */  1347, 1348, 1349, 1350, 1351, 1315, 1320, 1318, 1352, 1319,
 /*   390 */  1355, 1321, 1353, 1322, 1324, 1358, 1362, 1364, 1334, 1223,
 /*   400 */  1368, 1372, 1356, 1374, 1325, 1375, 1385, 1342, 1354, 1357,
 /*   410 */  1387, 1345, 1360, 1359, 1388, 1361, 1365, 1369, 1397, 1367,
 /*   420 */  1366, 1381, 1398, 1401, 1402, 1409, 1326, 1370, 1373, 1390,
 /*   430 */  1419, 1376, 1383, 1386, 1389, 1391, 1394, 1399, 1400, 1403,
 /*   440 */  1422, 1423, 1448, 1427, 1404, 1453, 1433, 1407, 1456, 1435,
 /*   450 */  1459, 1438, 1442, 1463, 1327, 1417, 1467, 1305, 1447, 1363,
 /*   460 */  1378, 1470, 1471, 1473, 1393, 1439, 1371, 1437, 1440, 1265,
 /*   470 */  1411, 1443, 1413, 1410, 1415, 1416, 1418, 1457, 1436, 1455,
 /*   480 */  1420, 1462, 1269, 1424, 1425, 1460, 1301, 1469, 1474, 1444,
 /*   490 */  1476, 1300, 1446, 1468, 1475, 1477, 1482, 1484, 1485, 1446,
 /*   500 */  1519, 1377, 1493, 1464, 1454, 1478, 1498, 1481, 1486, 1501,
 /*   510 */  1533, 1382, 1487, 1488, 1490, 1492, 1495, 1426, 1496, 1559,
 /*   520 */  1526, 1434, 1499, 1491, 1521, 1522, 1500, 1497, 1502, 1562,
 /*   530 */  1504, 1509, 1505, 1541, 1542, 1510, 1508, 1546, 1524, 1525,
 /*   540 */  1556, 1528, 1530, 1563, 1532, 1534, 1567, 1536, 1514, 1515,
 /*   550 */  1517, 1518, 1584, 1531, 1537, 1555, 1568, 1558, 1527, 1615,
 /*   560 */  1582, 1569, 1595, 1579, 1571, 1610, 1606, 1607, 1608, 1609,
 /*   570 */  1611, 1630, 1612, 1613, 1597, 1391, 1616, 1394, 1617, 1618,
 /*   580 */  1619, 1621, 1622, 1625, 1675, 1631, 1632, 1642, 1681, 1635,
 /*   590 */  1638, 1648, 1686, 1640, 1644, 1653, 1697, 1652, 1655, 1666,
 /*   600 */  1712, 1667, 1669, 1713, 1716, 1695, 1698, 1696, 1699, 1701,
 /*   610 */  1703,
};
#define YY_REDUCE_COUNT (251)
#define YY_REDUCE_MIN   (-309)
#define YY_REDUCE_MAX   (1848)
static const short yy_reduce_ofst[] = {
 /*     0 */  -205,  492,  568,  629,  690,  343,  802,  857,  908,  920,
 /*    10 */  -225,  973, 1006,   90, 1064, 1112, 1125, 1173, 1224, 1235,
 /*    20 */  1283, 1316, -144, 1379, 1392, 1432, 1483, 1513, 1545, 1596,
 /*    30 */  1605, 1658, 1674, 1706, 1736, 1784, 1793, 1848,  537,  751,
 /*    40 */  -195,  215,  263, -271, -153, -253, -145,  200,  202,  363,
 /*    50 */  -243,  339, -245, -240, -223,   38,   41,  344,  455,  514,
 /*    60 */   516,  524,  563, -244,  571, -246, -147, -209,  275,  538,
 /*    70 */   573,  219,  618,  445,  262,  165,  509,  644, -200, -178,
 /*    80 */  -309, -309, -309,  -18,   46, -143,  -37,  238,  307,  372,
 /*    90 */   383,  431,  477,  484,  486,  490,  541,  547,  553,  581,
 /*   100 */   610,  619,  620,  621,  100, -140, -132,  137,  -97,  156,
 /*   110 */  -301,   98,  281,  399,  286,  212,  336,  451,  438,  295,
 /*   120 */   185,  408, -255,  216,  356,  403,  460,  475,  584,  496,
 /*   130 */   529,  617,  520,  542,  604,  575,  667,  667,  683,  699,
 /*   140 */   671,  652,  628,  628,  628,  614,  615,  627,  632,  667,
 /*   150 */   731,  689,  754,  713,  772,  777,  745,  755,  761,  791,
 /*   160 */   804,  806,  749,  800,  767,  803,  763,  778,  807,  766,
 /*   170 */   822,  801,  792,  831,  833,  839,  837,  848,  823,  825,
 /*   180 */   826,  827,  828,  830,  834,  835,  838,  840,  843,  854,
 /*   190 */   863,  820,  816,  871,  819,  844,  874,  841,  879,  855,
 /*   200 */   845,  884,  829,  794,  851,  856,  798,  859,  861,  862,
 /*   210 */   667,  810,  813,  814,  824,  628,  882,  865,  852,  847,
 /*   220 */   815,  821,  849,  836,  850,  846,  866,  899,  901,  903,
 /*   230 */   904,  910,  917,  931,  916,  958,  948,  964,  935,  966,
 /*   240 */   968,  970,  974,  986,  930,  936,  950,  980,  981,  985,
 /*   250 */   997,  998,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*    10 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*    20 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*    30 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*    40 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*    50 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*    60 */  1354, 1354, 1354, 1423, 1354, 1354, 1354, 1354, 1354, 1354,
 /*    70 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1421, 1561,
 /*    80 */  1354, 1728, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*    90 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   100 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1423, 1354,
 /*   110 */  1739, 1739, 1739, 1421, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   120 */  1517, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1600,
 /*   130 */  1354, 1354, 1805, 1354, 1606, 1763, 1354, 1354, 1354, 1354,
 /*   140 */  1470, 1755, 1731, 1745, 1732, 1790, 1790, 1790, 1748, 1354,
 /*   150 */  1354, 1354, 1354, 1592, 1354, 1354, 1566, 1563, 1563, 1354,
 /*   160 */  1354, 1354, 1354, 1423, 1354, 1423, 1354, 1354, 1423, 1354,
 /*   170 */  1423, 1354, 1354, 1423, 1423, 1354, 1423, 1354, 1354, 1354,
 /*   180 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   190 */  1354, 1354, 1354, 1421, 1602, 1354, 1421, 1354, 1421, 1354,
 /*   200 */  1354, 1421, 1354, 1770, 1768, 1354, 1770, 1768, 1354, 1354,
 /*   210 */  1354, 1782, 1778, 1761, 1759, 1745, 1354, 1354, 1354, 1796,
 /*   220 */  1792, 1808, 1796, 1792, 1796, 1792, 1354, 1768, 1354, 1354,
 /*   230 */  1768, 1354, 1574, 1354, 1354, 1421, 1354, 1421, 1354, 1486,
 /*   240 */  1354, 1354, 1421, 1354, 1594, 1608, 1584, 1520, 1520, 1520,
 /*   250 */  1424, 1359, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   260 */  1354, 1354, 1354, 1672, 1781, 1780, 1704, 1703, 1702, 1700,
 /*   270 */  1671, 1482, 1354, 1354, 1354, 1354, 1354, 1354, 1665, 1666,
 /*   280 */  1664, 1663, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   290 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1729, 1354, 1793,
 /*   300 */  1797, 1354, 1354, 1354, 1648, 1354, 1354, 1354, 1354, 1354,
 /*   310 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   320 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   330 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   340 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   350 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   360 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   370 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   380 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1388, 1354, 1354,
 /*   390 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   400 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   410 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   420 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   430 */  1354, 1354, 1354, 1354, 1354, 1451, 1450, 1354, 1354, 1354,
 /*   440 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   450 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   460 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1752, 1762, 1354,
 /*   470 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1648,
 /*   480 */  1354, 1779, 1354, 1738, 1734, 1354, 1354, 1730, 1354, 1354,
 /*   490 */  1791, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   500 */  1724, 1354, 1697, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   510 */  1354, 1659, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   520 */  1354, 1354, 1354, 1354, 1647, 1354, 1688, 1354, 1354, 1354,
 /*   530 */  1354, 1354, 1354, 1354, 1354, 1514, 1354, 1354, 1354, 1354,
 /*   540 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1499, 1497,
 /*   550 */  1496, 1495, 1354, 1492, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   560 */  1354, 1354, 1354, 1354, 1354, 1443, 1354, 1354, 1354, 1354,
 /*   570 */  1354, 1354, 1354, 1354, 1354, 1434, 1354, 1433, 1354, 1354,
 /*   580 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   590 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   600 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   610 */  1354,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*  PRIVILEGE => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*       DAYS => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /* FILE_FACTOR => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FULLTEXT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       WITH => nothing */
    0,  /*     SCHEMA => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*      MERGE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /*      COUNT => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  232,  /*  NK_BITNOT => ID */
  232,  /*     INSERT => ID */
  232,  /*     VALUES => ID */
  232,  /*     IMPORT => ID */
  232,  /*    NK_SEMI => ID */
  232,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "GRANT",
  /*   37 */ "ON",
  /*   38 */ "TO",
  /*   39 */ "REVOKE",
  /*   40 */ "FROM",
  /*   41 */ "NK_COMMA",
  /*   42 */ "READ",
  /*   43 */ "WRITE",
  /*   44 */ "NK_DOT",
  /*   45 */ "DNODE",
  /*   46 */ "PORT",
  /*   47 */ "NK_INTEGER",
  /*   48 */ "DNODES",
  /*   49 */ "NK_IPTOKEN",
  /*   50 */ "LOCAL",
  /*   51 */ "QNODE",
  /*   52 */ "BNODE",
  /*   53 */ "SNODE",
  /*   54 */ "MNODE",
  /*   55 */ "DATABASE",
  /*   56 */ "USE",
  /*   57 */ "IF",
  /*   58 */ "NOT",
  /*   59 */ "EXISTS",
  /*   60 */ "BUFFER",
  /*   61 */ "CACHELAST",
  /*   62 */ "COMP",
  /*   63 */ "DAYS",
  /*   64 */ "NK_VARIABLE",
  /*   65 */ "FSYNC",
  /*   66 */ "MAXROWS",
  /*   67 */ "MINROWS",
  /*   68 */ "KEEP",
  /*   69 */ "PAGES",
  /*   70 */ "PAGESIZE",
  /*   71 */ "PRECISION",
  /*   72 */ "REPLICA",
  /*   73 */ "STRICT",
  /*   74 */ "WAL",
  /*   75 */ "VGROUPS",
  /*   76 */ "SINGLE_STABLE",
  /*   77 */ "RETENTIONS",
  /*   78 */ "SCHEMALESS",
  /*   79 */ "NK_COLON",
  /*   80 */ "TABLE",
  /*   81 */ "NK_LP",
  /*   82 */ "NK_RP",
  /*   83 */ "STABLE",
  /*   84 */ "ADD",
  /*   85 */ "COLUMN",
  /*   86 */ "MODIFY",
  /*   87 */ "RENAME",
  /*   88 */ "TAG",
  /*   89 */ "SET",
  /*   90 */ "NK_EQ",
  /*   91 */ "USING",
  /*   92 */ "TAGS",
  /*   93 */ "COMMENT",
  /*   94 */ "BOOL",
  /*   95 */ "TINYINT",
  /*   96 */ "SMALLINT",
  /*   97 */ "INT",
  /*   98 */ "INTEGER",
  /*   99 */ "BIGINT",
  /*  100 */ "FLOAT",
  /*  101 */ "DOUBLE",
  /*  102 */ "BINARY",
  /*  103 */ "TIMESTAMP",
  /*  104 */ "NCHAR",
  /*  105 */ "UNSIGNED",
  /*  106 */ "JSON",
  /*  107 */ "VARCHAR",
  /*  108 */ "MEDIUMBLOB",
  /*  109 */ "BLOB",
  /*  110 */ "VARBINARY",
  /*  111 */ "DECIMAL",
  /*  112 */ "FILE_FACTOR",
  /*  113 */ "NK_FLOAT",
  /*  114 */ "ROLLUP",
  /*  115 */ "TTL",
  /*  116 */ "SMA",
  /*  117 */ "SHOW",
  /*  118 */ "DATABASES",
  /*  119 */ "TABLES",
  /*  120 */ "STABLES",
  /*  121 */ "MNODES",
  /*  122 */ "MODULES",
  /*  123 */ "QNODES",
  /*  124 */ "FUNCTIONS",
  /*  125 */ "INDEXES",
  /*  126 */ "ACCOUNTS",
  /*  127 */ "APPS",
  /*  128 */ "CONNECTIONS",
  /*  129 */ "LICENCE",
  /*  130 */ "GRANTS",
  /*  131 */ "QUERIES",
  /*  132 */ "SCORES",
  /*  133 */ "TOPICS",
  /*  134 */ "VARIABLES",
  /*  135 */ "BNODES",
  /*  136 */ "SNODES",
  /*  137 */ "CLUSTER",
  /*  138 */ "TRANSACTIONS",
  /*  139 */ "LIKE",
  /*  140 */ "INDEX",
  /*  141 */ "FULLTEXT",
  /*  142 */ "FUNCTION",
  /*  143 */ "INTERVAL",
  /*  144 */ "TOPIC",
  /*  145 */ "AS",
  /*  146 */ "CONSUMER",
  /*  147 */ "GROUP",
  /*  148 */ "WITH",
  /*  149 */ "SCHEMA",
  /*  150 */ "DESC",
  /*  151 */ "DESCRIBE",
  /*  152 */ "RESET",
  /*  153 */ "QUERY",
  /*  154 */ "CACHE",
  /*  155 */ "EXPLAIN",
  /*  156 */ "ANALYZE",
  /*  157 */ "VERBOSE",
  /*  158 */ "NK_BOOL",
  /*  159 */ "RATIO",
  /*  160 */ "COMPACT",
  /*  161 */ "VNODES",
  /*  162 */ "IN",
  /*  163 */ "OUTPUTTYPE",
  /*  164 */ "AGGREGATE",
  /*  165 */ "BUFSIZE",
  /*  166 */ "STREAM",
  /*  167 */ "INTO",
  /*  168 */ "TRIGGER",
  /*  169 */ "AT_ONCE",
  /*  170 */ "WINDOW_CLOSE",
  /*  171 */ "WATERMARK",
  /*  172 */ "KILL",
  /*  173 */ "CONNECTION",
  /*  174 */ "TRANSACTION",
  /*  175 */ "MERGE",
  /*  176 */ "VGROUP",
  /*  177 */ "REDISTRIBUTE",
  /*  178 */ "SPLIT",
  /*  179 */ "SYNCDB",
  /*  180 */ "NULL",
  /*  181 */ "NK_QUESTION",
  /*  182 */ "NK_ARROW",
  /*  183 */ "ROWTS",
  /*  184 */ "TBNAME",
  /*  185 */ "QSTARTTS",
  /*  186 */ "QENDTS",
  /*  187 */ "WSTARTTS",
  /*  188 */ "WENDTS",
  /*  189 */ "WDURATION",
  /*  190 */ "CAST",
  /*  191 */ "NOW",
  /*  192 */ "TODAY",
  /*  193 */ "TIMEZONE",
  /*  194 */ "COUNT",
  /*  195 */ "FIRST",
  /*  196 */ "LAST",
  /*  197 */ "LAST_ROW",
  /*  198 */ "BETWEEN",
  /*  199 */ "IS",
  /*  200 */ "NK_LT",
  /*  201 */ "NK_GT",
  /*  202 */ "NK_LE",
  /*  203 */ "NK_GE",
  /*  204 */ "NK_NE",
  /*  205 */ "MATCH",
  /*  206 */ "NMATCH",
  /*  207 */ "CONTAINS",
  /*  208 */ "JOIN",
  /*  209 */ "INNER",
  /*  210 */ "SELECT",
  /*  211 */ "DISTINCT",
  /*  212 */ "WHERE",
  /*  213 */ "PARTITION",
  /*  214 */ "BY",
  /*  215 */ "SESSION",
  /*  216 */ "STATE_WINDOW",
  /*  217 */ "SLIDING",
  /*  218 */ "FILL",
  /*  219 */ "VALUE",
  /*  220 */ "NONE",
  /*  221 */ "PREV",
  /*  222 */ "LINEAR",
  /*  223 */ "NEXT",
  /*  224 */ "HAVING",
  /*  225 */ "ORDER",
  /*  226 */ "SLIMIT",
  /*  227 */ "SOFFSET",
  /*  228 */ "LIMIT",
  /*  229 */ "OFFSET",
  /*  230 */ "ASC",
  /*  231 */ "NULLS",
  /*  232 */ "ID",
  /*  233 */ "NK_BITNOT",
  /*  234 */ "INSERT",
  /*  235 */ "VALUES",
  /*  236 */ "IMPORT",
  /*  237 */ "NK_SEMI",
  /*  238 */ "FILE",
  /*  239 */ "cmd",
  /*  240 */ "account_options",
  /*  241 */ "alter_account_options",
  /*  242 */ "literal",
  /*  243 */ "alter_account_option",
  /*  244 */ "user_name",
  /*  245 */ "privileges",
  /*  246 */ "priv_level",
  /*  247 */ "priv_type_list",
  /*  248 */ "priv_type",
  /*  249 */ "db_name",
  /*  250 */ "dnode_endpoint",
  /*  251 */ "dnode_host_name",
  /*  252 */ "not_exists_opt",
  /*  253 */ "db_options",
  /*  254 */ "exists_opt",
  /*  255 */ "alter_db_options",
  /*  256 */ "integer_list",
  /*  257 */ "variable_list",
  /*  258 */ "retention_list",
  /*  259 */ "alter_db_option",
  /*  260 */ "retention",
  /*  261 */ "full_table_name",
  /*  262 */ "column_def_list",
  /*  263 */ "tags_def_opt",
  /*  264 */ "table_options",
  /*  265 */ "multi_create_clause",
  /*  266 */ "tags_def",
  /*  267 */ "multi_drop_clause",
  /*  268 */ "alter_table_clause",
  /*  269 */ "alter_table_options",
  /*  270 */ "column_name",
  /*  271 */ "type_name",
  /*  272 */ "signed_literal",
  /*  273 */ "create_subtable_clause",
  /*  274 */ "specific_tags_opt",
  /*  275 */ "literal_list",
  /*  276 */ "drop_table_clause",
  /*  277 */ "col_name_list",
  /*  278 */ "table_name",
  /*  279 */ "column_def",
  /*  280 */ "func_name_list",
  /*  281 */ "alter_table_option",
  /*  282 */ "col_name",
  /*  283 */ "db_name_cond_opt",
  /*  284 */ "like_pattern_opt",
  /*  285 */ "table_name_cond",
  /*  286 */ "from_db_opt",
  /*  287 */ "func_name",
  /*  288 */ "function_name",
  /*  289 */ "index_name",
  /*  290 */ "index_options",
  /*  291 */ "func_list",
  /*  292 */ "duration_literal",
  /*  293 */ "sliding_opt",
  /*  294 */ "func",
  /*  295 */ "expression_list",
  /*  296 */ "topic_name",
  /*  297 */ "topic_options",
  /*  298 */ "query_expression",
  /*  299 */ "cgroup_name",
  /*  300 */ "analyze_opt",
  /*  301 */ "explain_options",
  /*  302 */ "agg_func_opt",
  /*  303 */ "bufsize_opt",
  /*  304 */ "stream_name",
  /*  305 */ "stream_options",
  /*  306 */ "into_opt",
  /*  307 */ "dnode_list",
  /*  308 */ "signed",
  /*  309 */ "literal_func",
  /*  310 */ "table_alias",
  /*  311 */ "column_alias",
  /*  312 */ "expression",
  /*  313 */ "pseudo_column",
  /*  314 */ "column_reference",
  /*  315 */ "function_expression",
  /*  316 */ "subquery",
  /*  317 */ "star_func",
  /*  318 */ "star_func_para_list",
  /*  319 */ "noarg_func",
  /*  320 */ "other_para_list",
  /*  321 */ "star_func_para",
  /*  322 */ "predicate",
  /*  323 */ "compare_op",
  /*  324 */ "in_op",
  /*  325 */ "in_predicate_value",
  /*  326 */ "boolean_value_expression",
  /*  327 */ "boolean_primary",
  /*  328 */ "common_expression",
  /*  329 */ "from_clause",
  /*  330 */ "table_reference_list",
  /*  331 */ "table_reference",
  /*  332 */ "table_primary",
  /*  333 */ "joined_table",
  /*  334 */ "alias_opt",
  /*  335 */ "parenthesized_joined_table",
  /*  336 */ "join_type",
  /*  337 */ "search_condition",
  /*  338 */ "query_specification",
  /*  339 */ "set_quantifier_opt",
  /*  340 */ "select_list",
  /*  341 */ "where_clause_opt",
  /*  342 */ "partition_by_clause_opt",
  /*  343 */ "twindow_clause_opt",
  /*  344 */ "group_by_clause_opt",
  /*  345 */ "having_clause_opt",
  /*  346 */ "select_sublist",
  /*  347 */ "select_item",
  /*  348 */ "fill_opt",
  /*  349 */ "fill_mode",
  /*  350 */ "group_by_list",
  /*  351 */ "query_expression_body",
  /*  352 */ "order_by_clause_opt",
  /*  353 */ "slimit_clause_opt",
  /*  354 */ "limit_clause_opt",
  /*  355 */ "query_primary",
  /*  356 */ "sort_specification_list",
  /*  357 */ "sort_specification",
  /*  358 */ "ordering_specification_opt",
  /*  359 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  29 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  30 */ "privileges ::= ALL",
 /*  31 */ "privileges ::= priv_type_list",
 /*  32 */ "priv_type_list ::= priv_type",
 /*  33 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  34 */ "priv_type ::= READ",
 /*  35 */ "priv_type ::= WRITE",
 /*  36 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  37 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  38 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  39 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  40 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  41 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  42 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  43 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  44 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  45 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  46 */ "dnode_endpoint ::= NK_STRING",
 /*  47 */ "dnode_host_name ::= NK_ID",
 /*  48 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  49 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  50 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  51 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  52 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  53 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  54 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  60 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  61 */ "cmd ::= USE db_name",
 /*  62 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  63 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  64 */ "not_exists_opt ::=",
 /*  65 */ "exists_opt ::= IF EXISTS",
 /*  66 */ "exists_opt ::=",
 /*  67 */ "db_options ::=",
 /*  68 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  69 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  70 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  71 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  72 */ "db_options ::= db_options DAYS NK_VARIABLE",
 /*  73 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  74 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  75 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  76 */ "db_options ::= db_options KEEP integer_list",
 /*  77 */ "db_options ::= db_options KEEP variable_list",
 /*  78 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  79 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  81 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  82 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  83 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  84 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  85 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  86 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  87 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  88 */ "alter_db_options ::= alter_db_option",
 /*  89 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  90 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  91 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  92 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  93 */ "alter_db_option ::= KEEP integer_list",
 /*  94 */ "alter_db_option ::= KEEP variable_list",
 /*  95 */ "alter_db_option ::= PAGES NK_INTEGER",
 /*  96 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  97 */ "alter_db_option ::= STRICT NK_INTEGER",
 /*  98 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  99 */ "integer_list ::= NK_INTEGER",
 /* 100 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 101 */ "variable_list ::= NK_VARIABLE",
 /* 102 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 103 */ "retention_list ::= retention",
 /* 104 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 105 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 106 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 107 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 108 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 109 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 110 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 111 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 112 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 113 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 114 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 115 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 116 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 117 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 118 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 119 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 120 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 121 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 122 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 123 */ "multi_create_clause ::= create_subtable_clause",
 /* 124 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 125 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options",
 /* 126 */ "multi_drop_clause ::= drop_table_clause",
 /* 127 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 128 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 129 */ "specific_tags_opt ::=",
 /* 130 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 131 */ "full_table_name ::= table_name",
 /* 132 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 133 */ "column_def_list ::= column_def",
 /* 134 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 135 */ "column_def ::= column_name type_name",
 /* 136 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 137 */ "type_name ::= BOOL",
 /* 138 */ "type_name ::= TINYINT",
 /* 139 */ "type_name ::= SMALLINT",
 /* 140 */ "type_name ::= INT",
 /* 141 */ "type_name ::= INTEGER",
 /* 142 */ "type_name ::= BIGINT",
 /* 143 */ "type_name ::= FLOAT",
 /* 144 */ "type_name ::= DOUBLE",
 /* 145 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 146 */ "type_name ::= TIMESTAMP",
 /* 147 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= TINYINT UNSIGNED",
 /* 149 */ "type_name ::= SMALLINT UNSIGNED",
 /* 150 */ "type_name ::= INT UNSIGNED",
 /* 151 */ "type_name ::= BIGINT UNSIGNED",
 /* 152 */ "type_name ::= JSON",
 /* 153 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 154 */ "type_name ::= MEDIUMBLOB",
 /* 155 */ "type_name ::= BLOB",
 /* 156 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= DECIMAL",
 /* 158 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 159 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 160 */ "tags_def_opt ::=",
 /* 161 */ "tags_def_opt ::= tags_def",
 /* 162 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 163 */ "table_options ::=",
 /* 164 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 165 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 166 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 167 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 168 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 169 */ "alter_table_options ::= alter_table_option",
 /* 170 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 171 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 172 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 173 */ "col_name_list ::= col_name",
 /* 174 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 175 */ "col_name ::= column_name",
 /* 176 */ "cmd ::= SHOW DNODES",
 /* 177 */ "cmd ::= SHOW USERS",
 /* 178 */ "cmd ::= SHOW DATABASES",
 /* 179 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 180 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 181 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 182 */ "cmd ::= SHOW MNODES",
 /* 183 */ "cmd ::= SHOW MODULES",
 /* 184 */ "cmd ::= SHOW QNODES",
 /* 185 */ "cmd ::= SHOW FUNCTIONS",
 /* 186 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 187 */ "cmd ::= SHOW STREAMS",
 /* 188 */ "cmd ::= SHOW ACCOUNTS",
 /* 189 */ "cmd ::= SHOW APPS",
 /* 190 */ "cmd ::= SHOW CONNECTIONS",
 /* 191 */ "cmd ::= SHOW LICENCE",
 /* 192 */ "cmd ::= SHOW GRANTS",
 /* 193 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 194 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 195 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 196 */ "cmd ::= SHOW QUERIES",
 /* 197 */ "cmd ::= SHOW SCORES",
 /* 198 */ "cmd ::= SHOW TOPICS",
 /* 199 */ "cmd ::= SHOW VARIABLES",
 /* 200 */ "cmd ::= SHOW BNODES",
 /* 201 */ "cmd ::= SHOW SNODES",
 /* 202 */ "cmd ::= SHOW CLUSTER",
 /* 203 */ "cmd ::= SHOW TRANSACTIONS",
 /* 204 */ "db_name_cond_opt ::=",
 /* 205 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 206 */ "like_pattern_opt ::=",
 /* 207 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 208 */ "table_name_cond ::= table_name",
 /* 209 */ "from_db_opt ::=",
 /* 210 */ "from_db_opt ::= FROM db_name",
 /* 211 */ "func_name_list ::= func_name",
 /* 212 */ "func_name_list ::= func_name_list NK_COMMA func_name",
 /* 213 */ "func_name ::= function_name",
 /* 214 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 215 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 216 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 217 */ "index_options ::=",
 /* 218 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 219 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 220 */ "func_list ::= func",
 /* 221 */ "func_list ::= func_list NK_COMMA func",
 /* 222 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 223 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS query_expression",
 /* 224 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS db_name",
 /* 225 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 226 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 227 */ "topic_options ::=",
 /* 228 */ "topic_options ::= topic_options WITH TABLE",
 /* 229 */ "topic_options ::= topic_options WITH SCHEMA",
 /* 230 */ "topic_options ::= topic_options WITH TAG",
 /* 231 */ "cmd ::= DESC full_table_name",
 /* 232 */ "cmd ::= DESCRIBE full_table_name",
 /* 233 */ "cmd ::= RESET QUERY CACHE",
 /* 234 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 235 */ "analyze_opt ::=",
 /* 236 */ "analyze_opt ::= ANALYZE",
 /* 237 */ "explain_options ::=",
 /* 238 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 239 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 240 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 241 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 242 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 243 */ "agg_func_opt ::=",
 /* 244 */ "agg_func_opt ::= AGGREGATE",
 /* 245 */ "bufsize_opt ::=",
 /* 246 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 247 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 248 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 249 */ "into_opt ::=",
 /* 250 */ "into_opt ::= INTO full_table_name",
 /* 251 */ "stream_options ::=",
 /* 252 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 253 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 254 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 255 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 256 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 257 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 258 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 259 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 260 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 261 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 262 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 263 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 264 */ "cmd ::= query_expression",
 /* 265 */ "literal ::= NK_INTEGER",
 /* 266 */ "literal ::= NK_FLOAT",
 /* 267 */ "literal ::= NK_STRING",
 /* 268 */ "literal ::= NK_BOOL",
 /* 269 */ "literal ::= TIMESTAMP NK_STRING",
 /* 270 */ "literal ::= duration_literal",
 /* 271 */ "literal ::= NULL",
 /* 272 */ "literal ::= NK_QUESTION",
 /* 273 */ "duration_literal ::= NK_VARIABLE",
 /* 274 */ "signed ::= NK_INTEGER",
 /* 275 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 276 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 277 */ "signed ::= NK_FLOAT",
 /* 278 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 279 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 280 */ "signed_literal ::= signed",
 /* 281 */ "signed_literal ::= NK_STRING",
 /* 282 */ "signed_literal ::= NK_BOOL",
 /* 283 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 284 */ "signed_literal ::= duration_literal",
 /* 285 */ "signed_literal ::= NULL",
 /* 286 */ "signed_literal ::= literal_func",
 /* 287 */ "literal_list ::= signed_literal",
 /* 288 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 289 */ "db_name ::= NK_ID",
 /* 290 */ "table_name ::= NK_ID",
 /* 291 */ "column_name ::= NK_ID",
 /* 292 */ "function_name ::= NK_ID",
 /* 293 */ "table_alias ::= NK_ID",
 /* 294 */ "column_alias ::= NK_ID",
 /* 295 */ "user_name ::= NK_ID",
 /* 296 */ "index_name ::= NK_ID",
 /* 297 */ "topic_name ::= NK_ID",
 /* 298 */ "stream_name ::= NK_ID",
 /* 299 */ "cgroup_name ::= NK_ID",
 /* 300 */ "expression ::= literal",
 /* 301 */ "expression ::= pseudo_column",
 /* 302 */ "expression ::= column_reference",
 /* 303 */ "expression ::= function_expression",
 /* 304 */ "expression ::= subquery",
 /* 305 */ "expression ::= NK_LP expression NK_RP",
 /* 306 */ "expression ::= NK_PLUS expression",
 /* 307 */ "expression ::= NK_MINUS expression",
 /* 308 */ "expression ::= expression NK_PLUS expression",
 /* 309 */ "expression ::= expression NK_MINUS expression",
 /* 310 */ "expression ::= expression NK_STAR expression",
 /* 311 */ "expression ::= expression NK_SLASH expression",
 /* 312 */ "expression ::= expression NK_REM expression",
 /* 313 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 314 */ "expression_list ::= expression",
 /* 315 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 316 */ "column_reference ::= column_name",
 /* 317 */ "column_reference ::= table_name NK_DOT column_name",
 /* 318 */ "pseudo_column ::= ROWTS",
 /* 319 */ "pseudo_column ::= TBNAME",
 /* 320 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 321 */ "pseudo_column ::= QSTARTTS",
 /* 322 */ "pseudo_column ::= QENDTS",
 /* 323 */ "pseudo_column ::= WSTARTTS",
 /* 324 */ "pseudo_column ::= WENDTS",
 /* 325 */ "pseudo_column ::= WDURATION",
 /* 326 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 327 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 328 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 329 */ "function_expression ::= literal_func",
 /* 330 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 331 */ "literal_func ::= NOW",
 /* 332 */ "noarg_func ::= NOW",
 /* 333 */ "noarg_func ::= TODAY",
 /* 334 */ "noarg_func ::= TIMEZONE",
 /* 335 */ "star_func ::= COUNT",
 /* 336 */ "star_func ::= FIRST",
 /* 337 */ "star_func ::= LAST",
 /* 338 */ "star_func ::= LAST_ROW",
 /* 339 */ "star_func_para_list ::= NK_STAR",
 /* 340 */ "star_func_para_list ::= other_para_list",
 /* 341 */ "other_para_list ::= star_func_para",
 /* 342 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 343 */ "star_func_para ::= expression",
 /* 344 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 345 */ "predicate ::= expression compare_op expression",
 /* 346 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 347 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 348 */ "predicate ::= expression IS NULL",
 /* 349 */ "predicate ::= expression IS NOT NULL",
 /* 350 */ "predicate ::= expression in_op in_predicate_value",
 /* 351 */ "compare_op ::= NK_LT",
 /* 352 */ "compare_op ::= NK_GT",
 /* 353 */ "compare_op ::= NK_LE",
 /* 354 */ "compare_op ::= NK_GE",
 /* 355 */ "compare_op ::= NK_NE",
 /* 356 */ "compare_op ::= NK_EQ",
 /* 357 */ "compare_op ::= LIKE",
 /* 358 */ "compare_op ::= NOT LIKE",
 /* 359 */ "compare_op ::= MATCH",
 /* 360 */ "compare_op ::= NMATCH",
 /* 361 */ "compare_op ::= CONTAINS",
 /* 362 */ "in_op ::= IN",
 /* 363 */ "in_op ::= NOT IN",
 /* 364 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 365 */ "boolean_value_expression ::= boolean_primary",
 /* 366 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 367 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 368 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 369 */ "boolean_primary ::= predicate",
 /* 370 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 371 */ "common_expression ::= expression",
 /* 372 */ "common_expression ::= boolean_value_expression",
 /* 373 */ "from_clause ::= FROM table_reference_list",
 /* 374 */ "table_reference_list ::= table_reference",
 /* 375 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 376 */ "table_reference ::= table_primary",
 /* 377 */ "table_reference ::= joined_table",
 /* 378 */ "table_primary ::= table_name alias_opt",
 /* 379 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 380 */ "table_primary ::= subquery alias_opt",
 /* 381 */ "table_primary ::= parenthesized_joined_table",
 /* 382 */ "alias_opt ::=",
 /* 383 */ "alias_opt ::= table_alias",
 /* 384 */ "alias_opt ::= AS table_alias",
 /* 385 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 386 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 387 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 388 */ "join_type ::=",
 /* 389 */ "join_type ::= INNER",
 /* 390 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 391 */ "set_quantifier_opt ::=",
 /* 392 */ "set_quantifier_opt ::= DISTINCT",
 /* 393 */ "set_quantifier_opt ::= ALL",
 /* 394 */ "select_list ::= NK_STAR",
 /* 395 */ "select_list ::= select_sublist",
 /* 396 */ "select_sublist ::= select_item",
 /* 397 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 398 */ "select_item ::= common_expression",
 /* 399 */ "select_item ::= common_expression column_alias",
 /* 400 */ "select_item ::= common_expression AS column_alias",
 /* 401 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 402 */ "where_clause_opt ::=",
 /* 403 */ "where_clause_opt ::= WHERE search_condition",
 /* 404 */ "partition_by_clause_opt ::=",
 /* 405 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 406 */ "twindow_clause_opt ::=",
 /* 407 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 408 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 409 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 410 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 411 */ "sliding_opt ::=",
 /* 412 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 413 */ "fill_opt ::=",
 /* 414 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 415 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 416 */ "fill_mode ::= NONE",
 /* 417 */ "fill_mode ::= PREV",
 /* 418 */ "fill_mode ::= NULL",
 /* 419 */ "fill_mode ::= LINEAR",
 /* 420 */ "fill_mode ::= NEXT",
 /* 421 */ "group_by_clause_opt ::=",
 /* 422 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 423 */ "group_by_list ::= expression",
 /* 424 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 425 */ "having_clause_opt ::=",
 /* 426 */ "having_clause_opt ::= HAVING search_condition",
 /* 427 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 428 */ "query_expression_body ::= query_primary",
 /* 429 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 430 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 431 */ "query_primary ::= query_specification",
 /* 432 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 433 */ "order_by_clause_opt ::=",
 /* 434 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 435 */ "slimit_clause_opt ::=",
 /* 436 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 437 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 438 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 439 */ "limit_clause_opt ::=",
 /* 440 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 441 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 442 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 443 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 444 */ "search_condition ::= common_expression",
 /* 445 */ "sort_specification_list ::= sort_specification",
 /* 446 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 447 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 448 */ "ordering_specification_opt ::=",
 /* 449 */ "ordering_specification_opt ::= ASC",
 /* 450 */ "ordering_specification_opt ::= DESC",
 /* 451 */ "null_ordering_opt ::=",
 /* 452 */ "null_ordering_opt ::= NULLS FIRST",
 /* 453 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 239: /* cmd */
    case 242: /* literal */
    case 253: /* db_options */
    case 255: /* alter_db_options */
    case 260: /* retention */
    case 261: /* full_table_name */
    case 264: /* table_options */
    case 268: /* alter_table_clause */
    case 269: /* alter_table_options */
    case 272: /* signed_literal */
    case 273: /* create_subtable_clause */
    case 276: /* drop_table_clause */
    case 279: /* column_def */
    case 282: /* col_name */
    case 283: /* db_name_cond_opt */
    case 284: /* like_pattern_opt */
    case 285: /* table_name_cond */
    case 286: /* from_db_opt */
    case 287: /* func_name */
    case 290: /* index_options */
    case 292: /* duration_literal */
    case 293: /* sliding_opt */
    case 294: /* func */
    case 297: /* topic_options */
    case 298: /* query_expression */
    case 301: /* explain_options */
    case 305: /* stream_options */
    case 306: /* into_opt */
    case 308: /* signed */
    case 309: /* literal_func */
    case 312: /* expression */
    case 313: /* pseudo_column */
    case 314: /* column_reference */
    case 315: /* function_expression */
    case 316: /* subquery */
    case 321: /* star_func_para */
    case 322: /* predicate */
    case 325: /* in_predicate_value */
    case 326: /* boolean_value_expression */
    case 327: /* boolean_primary */
    case 328: /* common_expression */
    case 329: /* from_clause */
    case 330: /* table_reference_list */
    case 331: /* table_reference */
    case 332: /* table_primary */
    case 333: /* joined_table */
    case 335: /* parenthesized_joined_table */
    case 337: /* search_condition */
    case 338: /* query_specification */
    case 341: /* where_clause_opt */
    case 343: /* twindow_clause_opt */
    case 345: /* having_clause_opt */
    case 347: /* select_item */
    case 348: /* fill_opt */
    case 351: /* query_expression_body */
    case 353: /* slimit_clause_opt */
    case 354: /* limit_clause_opt */
    case 355: /* query_primary */
    case 357: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy632)); 
}
      break;
    case 240: /* account_options */
    case 241: /* alter_account_options */
    case 243: /* alter_account_option */
    case 303: /* bufsize_opt */
{
 
}
      break;
    case 244: /* user_name */
    case 246: /* priv_level */
    case 249: /* db_name */
    case 250: /* dnode_endpoint */
    case 251: /* dnode_host_name */
    case 270: /* column_name */
    case 278: /* table_name */
    case 288: /* function_name */
    case 289: /* index_name */
    case 296: /* topic_name */
    case 299: /* cgroup_name */
    case 304: /* stream_name */
    case 310: /* table_alias */
    case 311: /* column_alias */
    case 317: /* star_func */
    case 319: /* noarg_func */
    case 334: /* alias_opt */
{
 
}
      break;
    case 245: /* privileges */
    case 247: /* priv_type_list */
    case 248: /* priv_type */
{
 
}
      break;
    case 252: /* not_exists_opt */
    case 254: /* exists_opt */
    case 300: /* analyze_opt */
    case 302: /* agg_func_opt */
    case 339: /* set_quantifier_opt */
{
 
}
      break;
    case 256: /* integer_list */
    case 257: /* variable_list */
    case 258: /* retention_list */
    case 262: /* column_def_list */
    case 263: /* tags_def_opt */
    case 265: /* multi_create_clause */
    case 266: /* tags_def */
    case 267: /* multi_drop_clause */
    case 274: /* specific_tags_opt */
    case 275: /* literal_list */
    case 277: /* col_name_list */
    case 280: /* func_name_list */
    case 291: /* func_list */
    case 295: /* expression_list */
    case 307: /* dnode_list */
    case 318: /* star_func_para_list */
    case 320: /* other_para_list */
    case 340: /* select_list */
    case 342: /* partition_by_clause_opt */
    case 344: /* group_by_clause_opt */
    case 346: /* select_sublist */
    case 350: /* group_by_list */
    case 352: /* order_by_clause_opt */
    case 356: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy424)); 
}
      break;
    case 259: /* alter_db_option */
    case 281: /* alter_table_option */
{
 
}
      break;
    case 271: /* type_name */
{
 
}
      break;
    case 323: /* compare_op */
    case 324: /* in_op */
{
 
}
      break;
    case 336: /* join_type */
{
 
}
      break;
    case 349: /* fill_mode */
{
 
}
      break;
    case 358: /* ordering_specification_opt */
{
 
}
      break;
    case 359: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  239,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  239,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  240,    0 }, /* (2) account_options ::= */
  {  240,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  240,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  240,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  240,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  240,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  240,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  240,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  240,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  240,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  241,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  241,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  243,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  243,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  243,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  243,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  243,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  243,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  243,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  243,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  243,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  243,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  239,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  239,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  239,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  239,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  239,   -6 }, /* (28) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  239,   -6 }, /* (29) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  245,   -1 }, /* (30) privileges ::= ALL */
  {  245,   -1 }, /* (31) privileges ::= priv_type_list */
  {  247,   -1 }, /* (32) priv_type_list ::= priv_type */
  {  247,   -3 }, /* (33) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  248,   -1 }, /* (34) priv_type ::= READ */
  {  248,   -1 }, /* (35) priv_type ::= WRITE */
  {  246,   -3 }, /* (36) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  246,   -3 }, /* (37) priv_level ::= db_name NK_DOT NK_STAR */
  {  239,   -3 }, /* (38) cmd ::= CREATE DNODE dnode_endpoint */
  {  239,   -5 }, /* (39) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  239,   -3 }, /* (40) cmd ::= DROP DNODE NK_INTEGER */
  {  239,   -3 }, /* (41) cmd ::= DROP DNODE dnode_endpoint */
  {  239,   -4 }, /* (42) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  239,   -5 }, /* (43) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  239,   -4 }, /* (44) cmd ::= ALTER ALL DNODES NK_STRING */
  {  239,   -5 }, /* (45) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  250,   -1 }, /* (46) dnode_endpoint ::= NK_STRING */
  {  251,   -1 }, /* (47) dnode_host_name ::= NK_ID */
  {  251,   -1 }, /* (48) dnode_host_name ::= NK_IPTOKEN */
  {  239,   -3 }, /* (49) cmd ::= ALTER LOCAL NK_STRING */
  {  239,   -4 }, /* (50) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  239,   -5 }, /* (51) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (52) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (53) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (54) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (55) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (56) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (57) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (58) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (59) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  239,   -4 }, /* (60) cmd ::= DROP DATABASE exists_opt db_name */
  {  239,   -2 }, /* (61) cmd ::= USE db_name */
  {  239,   -4 }, /* (62) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  252,   -3 }, /* (63) not_exists_opt ::= IF NOT EXISTS */
  {  252,    0 }, /* (64) not_exists_opt ::= */
  {  254,   -2 }, /* (65) exists_opt ::= IF EXISTS */
  {  254,    0 }, /* (66) exists_opt ::= */
  {  253,    0 }, /* (67) db_options ::= */
  {  253,   -3 }, /* (68) db_options ::= db_options BUFFER NK_INTEGER */
  {  253,   -3 }, /* (69) db_options ::= db_options CACHELAST NK_INTEGER */
  {  253,   -3 }, /* (70) db_options ::= db_options COMP NK_INTEGER */
  {  253,   -3 }, /* (71) db_options ::= db_options DAYS NK_INTEGER */
  {  253,   -3 }, /* (72) db_options ::= db_options DAYS NK_VARIABLE */
  {  253,   -3 }, /* (73) db_options ::= db_options FSYNC NK_INTEGER */
  {  253,   -3 }, /* (74) db_options ::= db_options MAXROWS NK_INTEGER */
  {  253,   -3 }, /* (75) db_options ::= db_options MINROWS NK_INTEGER */
  {  253,   -3 }, /* (76) db_options ::= db_options KEEP integer_list */
  {  253,   -3 }, /* (77) db_options ::= db_options KEEP variable_list */
  {  253,   -3 }, /* (78) db_options ::= db_options PAGES NK_INTEGER */
  {  253,   -3 }, /* (79) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  253,   -3 }, /* (80) db_options ::= db_options PRECISION NK_STRING */
  {  253,   -3 }, /* (81) db_options ::= db_options REPLICA NK_INTEGER */
  {  253,   -3 }, /* (82) db_options ::= db_options STRICT NK_INTEGER */
  {  253,   -3 }, /* (83) db_options ::= db_options WAL NK_INTEGER */
  {  253,   -3 }, /* (84) db_options ::= db_options VGROUPS NK_INTEGER */
  {  253,   -3 }, /* (85) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  253,   -3 }, /* (86) db_options ::= db_options RETENTIONS retention_list */
  {  253,   -3 }, /* (87) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  255,   -1 }, /* (88) alter_db_options ::= alter_db_option */
  {  255,   -2 }, /* (89) alter_db_options ::= alter_db_options alter_db_option */
  {  259,   -2 }, /* (90) alter_db_option ::= BUFFER NK_INTEGER */
  {  259,   -2 }, /* (91) alter_db_option ::= CACHELAST NK_INTEGER */
  {  259,   -2 }, /* (92) alter_db_option ::= FSYNC NK_INTEGER */
  {  259,   -2 }, /* (93) alter_db_option ::= KEEP integer_list */
  {  259,   -2 }, /* (94) alter_db_option ::= KEEP variable_list */
  {  259,   -2 }, /* (95) alter_db_option ::= PAGES NK_INTEGER */
  {  259,   -2 }, /* (96) alter_db_option ::= REPLICA NK_INTEGER */
  {  259,   -2 }, /* (97) alter_db_option ::= STRICT NK_INTEGER */
  {  259,   -2 }, /* (98) alter_db_option ::= WAL NK_INTEGER */
  {  256,   -1 }, /* (99) integer_list ::= NK_INTEGER */
  {  256,   -3 }, /* (100) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  257,   -1 }, /* (101) variable_list ::= NK_VARIABLE */
  {  257,   -3 }, /* (102) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  258,   -1 }, /* (103) retention_list ::= retention */
  {  258,   -3 }, /* (104) retention_list ::= retention_list NK_COMMA retention */
  {  260,   -3 }, /* (105) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  239,   -9 }, /* (106) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  239,   -3 }, /* (107) cmd ::= CREATE TABLE multi_create_clause */
  {  239,   -9 }, /* (108) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  239,   -3 }, /* (109) cmd ::= DROP TABLE multi_drop_clause */
  {  239,   -4 }, /* (110) cmd ::= DROP STABLE exists_opt full_table_name */
  {  239,   -3 }, /* (111) cmd ::= ALTER TABLE alter_table_clause */
  {  239,   -3 }, /* (112) cmd ::= ALTER STABLE alter_table_clause */
  {  268,   -2 }, /* (113) alter_table_clause ::= full_table_name alter_table_options */
  {  268,   -5 }, /* (114) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  268,   -4 }, /* (115) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  268,   -5 }, /* (116) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  268,   -5 }, /* (117) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  268,   -5 }, /* (118) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  268,   -4 }, /* (119) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  268,   -5 }, /* (120) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  268,   -5 }, /* (121) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  268,   -6 }, /* (122) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  265,   -1 }, /* (123) multi_create_clause ::= create_subtable_clause */
  {  265,   -2 }, /* (124) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  273,  -10 }, /* (125) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
  {  267,   -1 }, /* (126) multi_drop_clause ::= drop_table_clause */
  {  267,   -2 }, /* (127) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  276,   -2 }, /* (128) drop_table_clause ::= exists_opt full_table_name */
  {  274,    0 }, /* (129) specific_tags_opt ::= */
  {  274,   -3 }, /* (130) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  261,   -1 }, /* (131) full_table_name ::= table_name */
  {  261,   -3 }, /* (132) full_table_name ::= db_name NK_DOT table_name */
  {  262,   -1 }, /* (133) column_def_list ::= column_def */
  {  262,   -3 }, /* (134) column_def_list ::= column_def_list NK_COMMA column_def */
  {  279,   -2 }, /* (135) column_def ::= column_name type_name */
  {  279,   -4 }, /* (136) column_def ::= column_name type_name COMMENT NK_STRING */
  {  271,   -1 }, /* (137) type_name ::= BOOL */
  {  271,   -1 }, /* (138) type_name ::= TINYINT */
  {  271,   -1 }, /* (139) type_name ::= SMALLINT */
  {  271,   -1 }, /* (140) type_name ::= INT */
  {  271,   -1 }, /* (141) type_name ::= INTEGER */
  {  271,   -1 }, /* (142) type_name ::= BIGINT */
  {  271,   -1 }, /* (143) type_name ::= FLOAT */
  {  271,   -1 }, /* (144) type_name ::= DOUBLE */
  {  271,   -4 }, /* (145) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  271,   -1 }, /* (146) type_name ::= TIMESTAMP */
  {  271,   -4 }, /* (147) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  271,   -2 }, /* (148) type_name ::= TINYINT UNSIGNED */
  {  271,   -2 }, /* (149) type_name ::= SMALLINT UNSIGNED */
  {  271,   -2 }, /* (150) type_name ::= INT UNSIGNED */
  {  271,   -2 }, /* (151) type_name ::= BIGINT UNSIGNED */
  {  271,   -1 }, /* (152) type_name ::= JSON */
  {  271,   -4 }, /* (153) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  271,   -1 }, /* (154) type_name ::= MEDIUMBLOB */
  {  271,   -1 }, /* (155) type_name ::= BLOB */
  {  271,   -4 }, /* (156) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  271,   -1 }, /* (157) type_name ::= DECIMAL */
  {  271,   -4 }, /* (158) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  271,   -6 }, /* (159) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  263,    0 }, /* (160) tags_def_opt ::= */
  {  263,   -1 }, /* (161) tags_def_opt ::= tags_def */
  {  266,   -4 }, /* (162) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  264,    0 }, /* (163) table_options ::= */
  {  264,   -3 }, /* (164) table_options ::= table_options COMMENT NK_STRING */
  {  264,   -3 }, /* (165) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  264,   -5 }, /* (166) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  264,   -3 }, /* (167) table_options ::= table_options TTL NK_INTEGER */
  {  264,   -5 }, /* (168) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  269,   -1 }, /* (169) alter_table_options ::= alter_table_option */
  {  269,   -2 }, /* (170) alter_table_options ::= alter_table_options alter_table_option */
  {  281,   -2 }, /* (171) alter_table_option ::= COMMENT NK_STRING */
  {  281,   -2 }, /* (172) alter_table_option ::= TTL NK_INTEGER */
  {  277,   -1 }, /* (173) col_name_list ::= col_name */
  {  277,   -3 }, /* (174) col_name_list ::= col_name_list NK_COMMA col_name */
  {  282,   -1 }, /* (175) col_name ::= column_name */
  {  239,   -2 }, /* (176) cmd ::= SHOW DNODES */
  {  239,   -2 }, /* (177) cmd ::= SHOW USERS */
  {  239,   -2 }, /* (178) cmd ::= SHOW DATABASES */
  {  239,   -4 }, /* (179) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  239,   -4 }, /* (180) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  239,   -3 }, /* (181) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  239,   -2 }, /* (182) cmd ::= SHOW MNODES */
  {  239,   -2 }, /* (183) cmd ::= SHOW MODULES */
  {  239,   -2 }, /* (184) cmd ::= SHOW QNODES */
  {  239,   -2 }, /* (185) cmd ::= SHOW FUNCTIONS */
  {  239,   -5 }, /* (186) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  239,   -2 }, /* (187) cmd ::= SHOW STREAMS */
  {  239,   -2 }, /* (188) cmd ::= SHOW ACCOUNTS */
  {  239,   -2 }, /* (189) cmd ::= SHOW APPS */
  {  239,   -2 }, /* (190) cmd ::= SHOW CONNECTIONS */
  {  239,   -2 }, /* (191) cmd ::= SHOW LICENCE */
  {  239,   -2 }, /* (192) cmd ::= SHOW GRANTS */
  {  239,   -4 }, /* (193) cmd ::= SHOW CREATE DATABASE db_name */
  {  239,   -4 }, /* (194) cmd ::= SHOW CREATE TABLE full_table_name */
  {  239,   -4 }, /* (195) cmd ::= SHOW CREATE STABLE full_table_name */
  {  239,   -2 }, /* (196) cmd ::= SHOW QUERIES */
  {  239,   -2 }, /* (197) cmd ::= SHOW SCORES */
  {  239,   -2 }, /* (198) cmd ::= SHOW TOPICS */
  {  239,   -2 }, /* (199) cmd ::= SHOW VARIABLES */
  {  239,   -2 }, /* (200) cmd ::= SHOW BNODES */
  {  239,   -2 }, /* (201) cmd ::= SHOW SNODES */
  {  239,   -2 }, /* (202) cmd ::= SHOW CLUSTER */
  {  239,   -2 }, /* (203) cmd ::= SHOW TRANSACTIONS */
  {  283,    0 }, /* (204) db_name_cond_opt ::= */
  {  283,   -2 }, /* (205) db_name_cond_opt ::= db_name NK_DOT */
  {  284,    0 }, /* (206) like_pattern_opt ::= */
  {  284,   -2 }, /* (207) like_pattern_opt ::= LIKE NK_STRING */
  {  285,   -1 }, /* (208) table_name_cond ::= table_name */
  {  286,    0 }, /* (209) from_db_opt ::= */
  {  286,   -2 }, /* (210) from_db_opt ::= FROM db_name */
  {  280,   -1 }, /* (211) func_name_list ::= func_name */
  {  280,   -3 }, /* (212) func_name_list ::= func_name_list NK_COMMA func_name */
  {  287,   -1 }, /* (213) func_name ::= function_name */
  {  239,   -8 }, /* (214) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  239,  -10 }, /* (215) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  239,   -6 }, /* (216) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  290,    0 }, /* (217) index_options ::= */
  {  290,   -9 }, /* (218) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  290,  -11 }, /* (219) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  291,   -1 }, /* (220) func_list ::= func */
  {  291,   -3 }, /* (221) func_list ::= func_list NK_COMMA func */
  {  294,   -4 }, /* (222) func ::= function_name NK_LP expression_list NK_RP */
  {  239,   -7 }, /* (223) cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS query_expression */
  {  239,   -7 }, /* (224) cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS db_name */
  {  239,   -4 }, /* (225) cmd ::= DROP TOPIC exists_opt topic_name */
  {  239,   -7 }, /* (226) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  297,    0 }, /* (227) topic_options ::= */
  {  297,   -3 }, /* (228) topic_options ::= topic_options WITH TABLE */
  {  297,   -3 }, /* (229) topic_options ::= topic_options WITH SCHEMA */
  {  297,   -3 }, /* (230) topic_options ::= topic_options WITH TAG */
  {  239,   -2 }, /* (231) cmd ::= DESC full_table_name */
  {  239,   -2 }, /* (232) cmd ::= DESCRIBE full_table_name */
  {  239,   -3 }, /* (233) cmd ::= RESET QUERY CACHE */
  {  239,   -4 }, /* (234) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  300,    0 }, /* (235) analyze_opt ::= */
  {  300,   -1 }, /* (236) analyze_opt ::= ANALYZE */
  {  301,    0 }, /* (237) explain_options ::= */
  {  301,   -3 }, /* (238) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  301,   -3 }, /* (239) explain_options ::= explain_options RATIO NK_FLOAT */
  {  239,   -6 }, /* (240) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  239,  -10 }, /* (241) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  239,   -4 }, /* (242) cmd ::= DROP FUNCTION exists_opt function_name */
  {  302,    0 }, /* (243) agg_func_opt ::= */
  {  302,   -1 }, /* (244) agg_func_opt ::= AGGREGATE */
  {  303,    0 }, /* (245) bufsize_opt ::= */
  {  303,   -2 }, /* (246) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  239,   -8 }, /* (247) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  239,   -4 }, /* (248) cmd ::= DROP STREAM exists_opt stream_name */
  {  306,    0 }, /* (249) into_opt ::= */
  {  306,   -2 }, /* (250) into_opt ::= INTO full_table_name */
  {  305,    0 }, /* (251) stream_options ::= */
  {  305,   -3 }, /* (252) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  305,   -3 }, /* (253) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  305,   -3 }, /* (254) stream_options ::= stream_options WATERMARK duration_literal */
  {  239,   -3 }, /* (255) cmd ::= KILL CONNECTION NK_INTEGER */
  {  239,   -3 }, /* (256) cmd ::= KILL QUERY NK_INTEGER */
  {  239,   -3 }, /* (257) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  239,   -4 }, /* (258) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  239,   -4 }, /* (259) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  239,   -3 }, /* (260) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  307,   -2 }, /* (261) dnode_list ::= DNODE NK_INTEGER */
  {  307,   -3 }, /* (262) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  239,   -3 }, /* (263) cmd ::= SYNCDB db_name REPLICA */
  {  239,   -1 }, /* (264) cmd ::= query_expression */
  {  242,   -1 }, /* (265) literal ::= NK_INTEGER */
  {  242,   -1 }, /* (266) literal ::= NK_FLOAT */
  {  242,   -1 }, /* (267) literal ::= NK_STRING */
  {  242,   -1 }, /* (268) literal ::= NK_BOOL */
  {  242,   -2 }, /* (269) literal ::= TIMESTAMP NK_STRING */
  {  242,   -1 }, /* (270) literal ::= duration_literal */
  {  242,   -1 }, /* (271) literal ::= NULL */
  {  242,   -1 }, /* (272) literal ::= NK_QUESTION */
  {  292,   -1 }, /* (273) duration_literal ::= NK_VARIABLE */
  {  308,   -1 }, /* (274) signed ::= NK_INTEGER */
  {  308,   -2 }, /* (275) signed ::= NK_PLUS NK_INTEGER */
  {  308,   -2 }, /* (276) signed ::= NK_MINUS NK_INTEGER */
  {  308,   -1 }, /* (277) signed ::= NK_FLOAT */
  {  308,   -2 }, /* (278) signed ::= NK_PLUS NK_FLOAT */
  {  308,   -2 }, /* (279) signed ::= NK_MINUS NK_FLOAT */
  {  272,   -1 }, /* (280) signed_literal ::= signed */
  {  272,   -1 }, /* (281) signed_literal ::= NK_STRING */
  {  272,   -1 }, /* (282) signed_literal ::= NK_BOOL */
  {  272,   -2 }, /* (283) signed_literal ::= TIMESTAMP NK_STRING */
  {  272,   -1 }, /* (284) signed_literal ::= duration_literal */
  {  272,   -1 }, /* (285) signed_literal ::= NULL */
  {  272,   -1 }, /* (286) signed_literal ::= literal_func */
  {  275,   -1 }, /* (287) literal_list ::= signed_literal */
  {  275,   -3 }, /* (288) literal_list ::= literal_list NK_COMMA signed_literal */
  {  249,   -1 }, /* (289) db_name ::= NK_ID */
  {  278,   -1 }, /* (290) table_name ::= NK_ID */
  {  270,   -1 }, /* (291) column_name ::= NK_ID */
  {  288,   -1 }, /* (292) function_name ::= NK_ID */
  {  310,   -1 }, /* (293) table_alias ::= NK_ID */
  {  311,   -1 }, /* (294) column_alias ::= NK_ID */
  {  244,   -1 }, /* (295) user_name ::= NK_ID */
  {  289,   -1 }, /* (296) index_name ::= NK_ID */
  {  296,   -1 }, /* (297) topic_name ::= NK_ID */
  {  304,   -1 }, /* (298) stream_name ::= NK_ID */
  {  299,   -1 }, /* (299) cgroup_name ::= NK_ID */
  {  312,   -1 }, /* (300) expression ::= literal */
  {  312,   -1 }, /* (301) expression ::= pseudo_column */
  {  312,   -1 }, /* (302) expression ::= column_reference */
  {  312,   -1 }, /* (303) expression ::= function_expression */
  {  312,   -1 }, /* (304) expression ::= subquery */
  {  312,   -3 }, /* (305) expression ::= NK_LP expression NK_RP */
  {  312,   -2 }, /* (306) expression ::= NK_PLUS expression */
  {  312,   -2 }, /* (307) expression ::= NK_MINUS expression */
  {  312,   -3 }, /* (308) expression ::= expression NK_PLUS expression */
  {  312,   -3 }, /* (309) expression ::= expression NK_MINUS expression */
  {  312,   -3 }, /* (310) expression ::= expression NK_STAR expression */
  {  312,   -3 }, /* (311) expression ::= expression NK_SLASH expression */
  {  312,   -3 }, /* (312) expression ::= expression NK_REM expression */
  {  312,   -3 }, /* (313) expression ::= column_reference NK_ARROW NK_STRING */
  {  295,   -1 }, /* (314) expression_list ::= expression */
  {  295,   -3 }, /* (315) expression_list ::= expression_list NK_COMMA expression */
  {  314,   -1 }, /* (316) column_reference ::= column_name */
  {  314,   -3 }, /* (317) column_reference ::= table_name NK_DOT column_name */
  {  313,   -1 }, /* (318) pseudo_column ::= ROWTS */
  {  313,   -1 }, /* (319) pseudo_column ::= TBNAME */
  {  313,   -3 }, /* (320) pseudo_column ::= table_name NK_DOT TBNAME */
  {  313,   -1 }, /* (321) pseudo_column ::= QSTARTTS */
  {  313,   -1 }, /* (322) pseudo_column ::= QENDTS */
  {  313,   -1 }, /* (323) pseudo_column ::= WSTARTTS */
  {  313,   -1 }, /* (324) pseudo_column ::= WENDTS */
  {  313,   -1 }, /* (325) pseudo_column ::= WDURATION */
  {  315,   -4 }, /* (326) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  315,   -4 }, /* (327) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  315,   -6 }, /* (328) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  315,   -1 }, /* (329) function_expression ::= literal_func */
  {  309,   -3 }, /* (330) literal_func ::= noarg_func NK_LP NK_RP */
  {  309,   -1 }, /* (331) literal_func ::= NOW */
  {  319,   -1 }, /* (332) noarg_func ::= NOW */
  {  319,   -1 }, /* (333) noarg_func ::= TODAY */
  {  319,   -1 }, /* (334) noarg_func ::= TIMEZONE */
  {  317,   -1 }, /* (335) star_func ::= COUNT */
  {  317,   -1 }, /* (336) star_func ::= FIRST */
  {  317,   -1 }, /* (337) star_func ::= LAST */
  {  317,   -1 }, /* (338) star_func ::= LAST_ROW */
  {  318,   -1 }, /* (339) star_func_para_list ::= NK_STAR */
  {  318,   -1 }, /* (340) star_func_para_list ::= other_para_list */
  {  320,   -1 }, /* (341) other_para_list ::= star_func_para */
  {  320,   -3 }, /* (342) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  321,   -1 }, /* (343) star_func_para ::= expression */
  {  321,   -3 }, /* (344) star_func_para ::= table_name NK_DOT NK_STAR */
  {  322,   -3 }, /* (345) predicate ::= expression compare_op expression */
  {  322,   -5 }, /* (346) predicate ::= expression BETWEEN expression AND expression */
  {  322,   -6 }, /* (347) predicate ::= expression NOT BETWEEN expression AND expression */
  {  322,   -3 }, /* (348) predicate ::= expression IS NULL */
  {  322,   -4 }, /* (349) predicate ::= expression IS NOT NULL */
  {  322,   -3 }, /* (350) predicate ::= expression in_op in_predicate_value */
  {  323,   -1 }, /* (351) compare_op ::= NK_LT */
  {  323,   -1 }, /* (352) compare_op ::= NK_GT */
  {  323,   -1 }, /* (353) compare_op ::= NK_LE */
  {  323,   -1 }, /* (354) compare_op ::= NK_GE */
  {  323,   -1 }, /* (355) compare_op ::= NK_NE */
  {  323,   -1 }, /* (356) compare_op ::= NK_EQ */
  {  323,   -1 }, /* (357) compare_op ::= LIKE */
  {  323,   -2 }, /* (358) compare_op ::= NOT LIKE */
  {  323,   -1 }, /* (359) compare_op ::= MATCH */
  {  323,   -1 }, /* (360) compare_op ::= NMATCH */
  {  323,   -1 }, /* (361) compare_op ::= CONTAINS */
  {  324,   -1 }, /* (362) in_op ::= IN */
  {  324,   -2 }, /* (363) in_op ::= NOT IN */
  {  325,   -3 }, /* (364) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  326,   -1 }, /* (365) boolean_value_expression ::= boolean_primary */
  {  326,   -2 }, /* (366) boolean_value_expression ::= NOT boolean_primary */
  {  326,   -3 }, /* (367) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  326,   -3 }, /* (368) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  327,   -1 }, /* (369) boolean_primary ::= predicate */
  {  327,   -3 }, /* (370) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  328,   -1 }, /* (371) common_expression ::= expression */
  {  328,   -1 }, /* (372) common_expression ::= boolean_value_expression */
  {  329,   -2 }, /* (373) from_clause ::= FROM table_reference_list */
  {  330,   -1 }, /* (374) table_reference_list ::= table_reference */
  {  330,   -3 }, /* (375) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  331,   -1 }, /* (376) table_reference ::= table_primary */
  {  331,   -1 }, /* (377) table_reference ::= joined_table */
  {  332,   -2 }, /* (378) table_primary ::= table_name alias_opt */
  {  332,   -4 }, /* (379) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  332,   -2 }, /* (380) table_primary ::= subquery alias_opt */
  {  332,   -1 }, /* (381) table_primary ::= parenthesized_joined_table */
  {  334,    0 }, /* (382) alias_opt ::= */
  {  334,   -1 }, /* (383) alias_opt ::= table_alias */
  {  334,   -2 }, /* (384) alias_opt ::= AS table_alias */
  {  335,   -3 }, /* (385) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  335,   -3 }, /* (386) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  333,   -6 }, /* (387) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  336,    0 }, /* (388) join_type ::= */
  {  336,   -1 }, /* (389) join_type ::= INNER */
  {  338,   -9 }, /* (390) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  339,    0 }, /* (391) set_quantifier_opt ::= */
  {  339,   -1 }, /* (392) set_quantifier_opt ::= DISTINCT */
  {  339,   -1 }, /* (393) set_quantifier_opt ::= ALL */
  {  340,   -1 }, /* (394) select_list ::= NK_STAR */
  {  340,   -1 }, /* (395) select_list ::= select_sublist */
  {  346,   -1 }, /* (396) select_sublist ::= select_item */
  {  346,   -3 }, /* (397) select_sublist ::= select_sublist NK_COMMA select_item */
  {  347,   -1 }, /* (398) select_item ::= common_expression */
  {  347,   -2 }, /* (399) select_item ::= common_expression column_alias */
  {  347,   -3 }, /* (400) select_item ::= common_expression AS column_alias */
  {  347,   -3 }, /* (401) select_item ::= table_name NK_DOT NK_STAR */
  {  341,    0 }, /* (402) where_clause_opt ::= */
  {  341,   -2 }, /* (403) where_clause_opt ::= WHERE search_condition */
  {  342,    0 }, /* (404) partition_by_clause_opt ::= */
  {  342,   -3 }, /* (405) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  343,    0 }, /* (406) twindow_clause_opt ::= */
  {  343,   -6 }, /* (407) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  343,   -4 }, /* (408) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  343,   -6 }, /* (409) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  343,   -8 }, /* (410) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  293,    0 }, /* (411) sliding_opt ::= */
  {  293,   -4 }, /* (412) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  348,    0 }, /* (413) fill_opt ::= */
  {  348,   -4 }, /* (414) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  348,   -6 }, /* (415) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  349,   -1 }, /* (416) fill_mode ::= NONE */
  {  349,   -1 }, /* (417) fill_mode ::= PREV */
  {  349,   -1 }, /* (418) fill_mode ::= NULL */
  {  349,   -1 }, /* (419) fill_mode ::= LINEAR */
  {  349,   -1 }, /* (420) fill_mode ::= NEXT */
  {  344,    0 }, /* (421) group_by_clause_opt ::= */
  {  344,   -3 }, /* (422) group_by_clause_opt ::= GROUP BY group_by_list */
  {  350,   -1 }, /* (423) group_by_list ::= expression */
  {  350,   -3 }, /* (424) group_by_list ::= group_by_list NK_COMMA expression */
  {  345,    0 }, /* (425) having_clause_opt ::= */
  {  345,   -2 }, /* (426) having_clause_opt ::= HAVING search_condition */
  {  298,   -4 }, /* (427) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  351,   -1 }, /* (428) query_expression_body ::= query_primary */
  {  351,   -4 }, /* (429) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  351,   -3 }, /* (430) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  355,   -1 }, /* (431) query_primary ::= query_specification */
  {  355,   -6 }, /* (432) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  352,    0 }, /* (433) order_by_clause_opt ::= */
  {  352,   -3 }, /* (434) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  353,    0 }, /* (435) slimit_clause_opt ::= */
  {  353,   -2 }, /* (436) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  353,   -4 }, /* (437) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  353,   -4 }, /* (438) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  354,    0 }, /* (439) limit_clause_opt ::= */
  {  354,   -2 }, /* (440) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  354,   -4 }, /* (441) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  354,   -4 }, /* (442) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  316,   -3 }, /* (443) subquery ::= NK_LP query_expression NK_RP */
  {  337,   -1 }, /* (444) search_condition ::= common_expression */
  {  356,   -1 }, /* (445) sort_specification_list ::= sort_specification */
  {  356,   -3 }, /* (446) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  357,   -3 }, /* (447) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  358,    0 }, /* (448) ordering_specification_opt ::= */
  {  358,   -1 }, /* (449) ordering_specification_opt ::= ASC */
  {  358,   -1 }, /* (450) ordering_specification_opt ::= DESC */
  {  359,    0 }, /* (451) null_ordering_opt ::= */
  {  359,   -2 }, /* (452) null_ordering_opt ::= NULLS FIRST */
  {  359,   -2 }, /* (453) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,240,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,241,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,240,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,242,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,243,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,241,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,243,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,242,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy209, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy209, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 28: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy189, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209); }
        break;
      case 29: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy189, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209); }
        break;
      case 30: /* privileges ::= ALL */
{ yymsp[0].minor.yy189 = PRIVILEGE_TYPE_ALL; }
        break;
      case 31: /* privileges ::= priv_type_list */
      case 32: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==32);
{ yylhsminor.yy189 = yymsp[0].minor.yy189; }
  yymsp[0].minor.yy189 = yylhsminor.yy189;
        break;
      case 33: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy189 = yymsp[-2].minor.yy189 | yymsp[0].minor.yy189; }
  yymsp[-2].minor.yy189 = yylhsminor.yy189;
        break;
      case 34: /* priv_type ::= READ */
{ yymsp[0].minor.yy189 = PRIVILEGE_TYPE_READ; }
        break;
      case 35: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy189 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 36: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy209 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy209 = yylhsminor.yy209;
        break;
      case 37: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy209 = yymsp[-2].minor.yy209; }
  yymsp[-2].minor.yy209 = yylhsminor.yy209;
        break;
      case 38: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy209, NULL); }
        break;
      case 39: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0); }
        break;
      case 40: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 42: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 43: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 45: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 46: /* dnode_endpoint ::= NK_STRING */
      case 47: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==47);
      case 48: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==48);
      case 289: /* db_name ::= NK_ID */ yytestcase(yyruleno==289);
      case 290: /* table_name ::= NK_ID */ yytestcase(yyruleno==290);
      case 291: /* column_name ::= NK_ID */ yytestcase(yyruleno==291);
      case 292: /* function_name ::= NK_ID */ yytestcase(yyruleno==292);
      case 293: /* table_alias ::= NK_ID */ yytestcase(yyruleno==293);
      case 294: /* column_alias ::= NK_ID */ yytestcase(yyruleno==294);
      case 295: /* user_name ::= NK_ID */ yytestcase(yyruleno==295);
      case 296: /* index_name ::= NK_ID */ yytestcase(yyruleno==296);
      case 297: /* topic_name ::= NK_ID */ yytestcase(yyruleno==297);
      case 298: /* stream_name ::= NK_ID */ yytestcase(yyruleno==298);
      case 299: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==299);
      case 332: /* noarg_func ::= NOW */ yytestcase(yyruleno==332);
      case 333: /* noarg_func ::= TODAY */ yytestcase(yyruleno==333);
      case 334: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==334);
      case 335: /* star_func ::= COUNT */ yytestcase(yyruleno==335);
      case 336: /* star_func ::= FIRST */ yytestcase(yyruleno==336);
      case 337: /* star_func ::= LAST */ yytestcase(yyruleno==337);
      case 338: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==338);
{ yylhsminor.yy209 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy209 = yylhsminor.yy209;
        break;
      case 49: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 52: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 53: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy137, &yymsp[-1].minor.yy209, yymsp[0].minor.yy632); }
        break;
      case 60: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy137, &yymsp[0].minor.yy209); }
        break;
      case 61: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 62: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy209, yymsp[0].minor.yy632); }
        break;
      case 63: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy137 = true; }
        break;
      case 64: /* not_exists_opt ::= */
      case 66: /* exists_opt ::= */ yytestcase(yyruleno==66);
      case 235: /* analyze_opt ::= */ yytestcase(yyruleno==235);
      case 243: /* agg_func_opt ::= */ yytestcase(yyruleno==243);
      case 391: /* set_quantifier_opt ::= */ yytestcase(yyruleno==391);
{ yymsp[1].minor.yy137 = false; }
        break;
      case 65: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy137 = true; }
        break;
      case 67: /* db_options ::= */
{ yymsp[1].minor.yy632 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 68: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 69: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 70: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 71: /* db_options ::= db_options DAYS NK_INTEGER */
      case 72: /* db_options ::= db_options DAYS NK_VARIABLE */ yytestcase(yyruleno==72);
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 73: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 74: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 75: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 76: /* db_options ::= db_options KEEP integer_list */
      case 77: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==77);
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_KEEP, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 78: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 79: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 80: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 81: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 82: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 83: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 84: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 85: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 86: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_RETENTIONS, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 87: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 88: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy632 = createAlterDatabaseOptions(pCxt); yylhsminor.yy632 = setAlterDatabaseOption(pCxt, yylhsminor.yy632, &yymsp[0].minor.yy605); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 89: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy632 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy632, &yymsp[0].minor.yy605); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 90: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 91: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 92: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 93: /* alter_db_option ::= KEEP integer_list */
      case 94: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==94);
{ yymsp[-1].minor.yy605.type = DB_OPTION_KEEP; yymsp[-1].minor.yy605.pList = yymsp[0].minor.yy424; }
        break;
      case 95: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_PAGES; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 96: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 97: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_STRICT; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 98: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_WAL; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 99: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy424 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 100: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 262: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==262);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 101: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy424 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 102: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 103: /* retention_list ::= retention */
      case 123: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==123);
      case 126: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==126);
      case 133: /* column_def_list ::= column_def */ yytestcase(yyruleno==133);
      case 173: /* col_name_list ::= col_name */ yytestcase(yyruleno==173);
      case 211: /* func_name_list ::= func_name */ yytestcase(yyruleno==211);
      case 220: /* func_list ::= func */ yytestcase(yyruleno==220);
      case 287: /* literal_list ::= signed_literal */ yytestcase(yyruleno==287);
      case 341: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==341);
      case 396: /* select_sublist ::= select_item */ yytestcase(yyruleno==396);
      case 445: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==445);
{ yylhsminor.yy424 = createNodeList(pCxt, yymsp[0].minor.yy632); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 104: /* retention_list ::= retention_list NK_COMMA retention */
      case 134: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==134);
      case 174: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==174);
      case 212: /* func_name_list ::= func_name_list NK_COMMA func_name */ yytestcase(yyruleno==212);
      case 221: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==221);
      case 288: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==288);
      case 342: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==342);
      case 397: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==397);
      case 446: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==446);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, yymsp[0].minor.yy632); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 105: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy632 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 106: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 108: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==108);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy137, yymsp[-5].minor.yy632, yymsp[-3].minor.yy424, yymsp[-1].minor.yy424, yymsp[0].minor.yy632); }
        break;
      case 107: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy424); }
        break;
      case 109: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy424); }
        break;
      case 110: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy137, yymsp[0].minor.yy632); }
        break;
      case 111: /* cmd ::= ALTER TABLE alter_table_clause */
      case 112: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==112);
      case 264: /* cmd ::= query_expression */ yytestcase(yyruleno==264);
{ pCxt->pRootNode = yymsp[0].minor.yy632; }
        break;
      case 113: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy632 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 114: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy632 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy209, yymsp[0].minor.yy304); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 115: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy632 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy632, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy209); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 116: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy632 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy209, yymsp[0].minor.yy304); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 117: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy632 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy209, &yymsp[0].minor.yy209); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 118: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy632 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy209, yymsp[0].minor.yy304); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 119: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy632 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy632, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy209); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 120: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy632 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy209, yymsp[0].minor.yy304); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 121: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy632 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy209, &yymsp[0].minor.yy209); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 122: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy632 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy632, &yymsp[-2].minor.yy209, yymsp[0].minor.yy632); }
  yymsp[-5].minor.yy632 = yylhsminor.yy632;
        break;
      case 124: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 127: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==127);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-1].minor.yy424, yymsp[0].minor.yy632); }
  yymsp[-1].minor.yy424 = yylhsminor.yy424;
        break;
      case 125: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
{ yylhsminor.yy632 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy137, yymsp[-8].minor.yy632, yymsp[-6].minor.yy632, yymsp[-5].minor.yy424, yymsp[-2].minor.yy424, yymsp[0].minor.yy632); }
  yymsp[-9].minor.yy632 = yylhsminor.yy632;
        break;
      case 128: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy632 = createDropTableClause(pCxt, yymsp[-1].minor.yy137, yymsp[0].minor.yy632); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 129: /* specific_tags_opt ::= */
      case 160: /* tags_def_opt ::= */ yytestcase(yyruleno==160);
      case 404: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==404);
      case 421: /* group_by_clause_opt ::= */ yytestcase(yyruleno==421);
      case 433: /* order_by_clause_opt ::= */ yytestcase(yyruleno==433);
{ yymsp[1].minor.yy424 = NULL; }
        break;
      case 130: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy424 = yymsp[-1].minor.yy424; }
        break;
      case 131: /* full_table_name ::= table_name */
{ yylhsminor.yy632 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy209, NULL); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 132: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy632 = createRealTableNode(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209, NULL); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 135: /* column_def ::= column_name type_name */
{ yylhsminor.yy632 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy209, yymsp[0].minor.yy304, NULL); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 136: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy632 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy209, yymsp[-2].minor.yy304, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 137: /* type_name ::= BOOL */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 138: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 139: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 140: /* type_name ::= INT */
      case 141: /* type_name ::= INTEGER */ yytestcase(yyruleno==141);
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 142: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 143: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 144: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 145: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 146: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 147: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 148: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy304 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 149: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy304 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 150: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy304 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 151: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy304 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 152: /* type_name ::= JSON */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 153: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 154: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 155: /* type_name ::= BLOB */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 156: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 158: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 159: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy304 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 161: /* tags_def_opt ::= tags_def */
      case 340: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==340);
      case 395: /* select_list ::= select_sublist */ yytestcase(yyruleno==395);
{ yylhsminor.yy424 = yymsp[0].minor.yy424; }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 162: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy424 = yymsp[-1].minor.yy424; }
        break;
      case 163: /* table_options ::= */
{ yymsp[1].minor.yy632 = createDefaultTableOptions(pCxt); }
        break;
      case 164: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-2].minor.yy632, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 165: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-2].minor.yy632, TABLE_OPTION_FILE_FACTOR, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 166: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-4].minor.yy632, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy424); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 167: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-2].minor.yy632, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 168: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-4].minor.yy632, TABLE_OPTION_SMA, yymsp[-1].minor.yy424); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 169: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy632 = createAlterTableOptions(pCxt); yylhsminor.yy632 = setTableOption(pCxt, yylhsminor.yy632, yymsp[0].minor.yy605.type, &yymsp[0].minor.yy605.val); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 170: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-1].minor.yy632, yymsp[0].minor.yy605.type, &yymsp[0].minor.yy605.val); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 171: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy605.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 172: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy605.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 175: /* col_name ::= column_name */
{ yylhsminor.yy632 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy209); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 176: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 177: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 178: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 179: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 180: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 181: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy632, NULL); }
        break;
      case 182: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 183: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 184: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 185: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 186: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 187: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 188: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 189: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 190: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 191: /* cmd ::= SHOW LICENCE */
      case 192: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==192);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 193: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 194: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy632); }
        break;
      case 195: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy632); }
        break;
      case 196: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 197: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 198: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 199: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 200: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT, NULL, NULL); }
        break;
      case 201: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT, NULL, NULL); }
        break;
      case 202: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT, NULL, NULL); }
        break;
      case 203: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT, NULL, NULL); }
        break;
      case 204: /* db_name_cond_opt ::= */
      case 209: /* from_db_opt ::= */ yytestcase(yyruleno==209);
{ yymsp[1].minor.yy632 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 205: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy209); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 206: /* like_pattern_opt ::= */
      case 217: /* index_options ::= */ yytestcase(yyruleno==217);
      case 249: /* into_opt ::= */ yytestcase(yyruleno==249);
      case 402: /* where_clause_opt ::= */ yytestcase(yyruleno==402);
      case 406: /* twindow_clause_opt ::= */ yytestcase(yyruleno==406);
      case 411: /* sliding_opt ::= */ yytestcase(yyruleno==411);
      case 413: /* fill_opt ::= */ yytestcase(yyruleno==413);
      case 425: /* having_clause_opt ::= */ yytestcase(yyruleno==425);
      case 435: /* slimit_clause_opt ::= */ yytestcase(yyruleno==435);
      case 439: /* limit_clause_opt ::= */ yytestcase(yyruleno==439);
{ yymsp[1].minor.yy632 = NULL; }
        break;
      case 207: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 208: /* table_name_cond ::= table_name */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy209); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 210: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy209); }
        break;
      case 213: /* func_name ::= function_name */
{ yylhsminor.yy632 = createFunctionNode(pCxt, &yymsp[0].minor.yy209, NULL); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 214: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy137, &yymsp[-3].minor.yy209, &yymsp[-1].minor.yy209, NULL, yymsp[0].minor.yy632); }
        break;
      case 215: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy137, &yymsp[-5].minor.yy209, &yymsp[-3].minor.yy209, yymsp[-1].minor.yy424, NULL); }
        break;
      case 216: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy137, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209); }
        break;
      case 218: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy632 = createIndexOption(pCxt, yymsp[-6].minor.yy424, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), NULL, yymsp[0].minor.yy632); }
        break;
      case 219: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy632 = createIndexOption(pCxt, yymsp[-8].minor.yy424, releaseRawExprNode(pCxt, yymsp[-4].minor.yy632), releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), yymsp[0].minor.yy632); }
        break;
      case 222: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy632 = createFunctionNode(pCxt, &yymsp[-3].minor.yy209, yymsp[-1].minor.yy424); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 223: /* cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy137, &yymsp[-3].minor.yy209, yymsp[0].minor.yy632, NULL, yymsp[-2].minor.yy632); }
        break;
      case 224: /* cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy137, &yymsp[-3].minor.yy209, NULL, &yymsp[0].minor.yy209, yymsp[-2].minor.yy632); }
        break;
      case 225: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy137, &yymsp[0].minor.yy209); }
        break;
      case 226: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy137, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209); }
        break;
      case 227: /* topic_options ::= */
{ yymsp[1].minor.yy632 = createTopicOptions(pCxt); }
        break;
      case 228: /* topic_options ::= topic_options WITH TABLE */
{ ((STopicOptions*)yymsp[-2].minor.yy632)->withTable = true; yylhsminor.yy632 = yymsp[-2].minor.yy632; }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 229: /* topic_options ::= topic_options WITH SCHEMA */
{ ((STopicOptions*)yymsp[-2].minor.yy632)->withSchema = true; yylhsminor.yy632 = yymsp[-2].minor.yy632; }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 230: /* topic_options ::= topic_options WITH TAG */
{ ((STopicOptions*)yymsp[-2].minor.yy632)->withTag = true; yylhsminor.yy632 = yymsp[-2].minor.yy632; }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 231: /* cmd ::= DESC full_table_name */
      case 232: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==232);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy632); }
        break;
      case 233: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 234: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy137, yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 236: /* analyze_opt ::= ANALYZE */
      case 244: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==244);
      case 392: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==392);
{ yymsp[0].minor.yy137 = true; }
        break;
      case 237: /* explain_options ::= */
{ yymsp[1].minor.yy632 = createDefaultExplainOptions(pCxt); }
        break;
      case 238: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy632 = setExplainVerbose(pCxt, yymsp[-2].minor.yy632, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 239: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy632 = setExplainRatio(pCxt, yymsp[-2].minor.yy632, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 240: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy424); }
        break;
      case 241: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy137, yymsp[-8].minor.yy137, &yymsp[-5].minor.yy209, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy304, yymsp[0].minor.yy100); }
        break;
      case 242: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy137, &yymsp[0].minor.yy209); }
        break;
      case 245: /* bufsize_opt ::= */
{ yymsp[1].minor.yy100 = 0; }
        break;
      case 246: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy100 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 247: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy137, &yymsp[-4].minor.yy209, yymsp[-2].minor.yy632, yymsp[-3].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 248: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy137, &yymsp[0].minor.yy209); }
        break;
      case 250: /* into_opt ::= INTO full_table_name */
      case 373: /* from_clause ::= FROM table_reference_list */ yytestcase(yyruleno==373);
      case 403: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==403);
      case 426: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==426);
{ yymsp[-1].minor.yy632 = yymsp[0].minor.yy632; }
        break;
      case 251: /* stream_options ::= */
{ yymsp[1].minor.yy632 = createStreamOptions(pCxt); }
        break;
      case 252: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy632)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy632 = yymsp[-2].minor.yy632; }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 253: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy632)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy632 = yymsp[-2].minor.yy632; }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 254: /* stream_options ::= stream_options WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy632)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy632); yylhsminor.yy632 = yymsp[-2].minor.yy632; }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 255: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 256: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 257: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 258: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 259: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy424); }
        break;
      case 260: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 261: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy424 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 263: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy209); }
        break;
      case 265: /* literal ::= NK_INTEGER */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 266: /* literal ::= NK_FLOAT */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 267: /* literal ::= NK_STRING */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 268: /* literal ::= NK_BOOL */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 269: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 270: /* literal ::= duration_literal */
      case 280: /* signed_literal ::= signed */ yytestcase(yyruleno==280);
      case 300: /* expression ::= literal */ yytestcase(yyruleno==300);
      case 301: /* expression ::= pseudo_column */ yytestcase(yyruleno==301);
      case 302: /* expression ::= column_reference */ yytestcase(yyruleno==302);
      case 303: /* expression ::= function_expression */ yytestcase(yyruleno==303);
      case 304: /* expression ::= subquery */ yytestcase(yyruleno==304);
      case 329: /* function_expression ::= literal_func */ yytestcase(yyruleno==329);
      case 365: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==365);
      case 369: /* boolean_primary ::= predicate */ yytestcase(yyruleno==369);
      case 371: /* common_expression ::= expression */ yytestcase(yyruleno==371);
      case 372: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==372);
      case 374: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==374);
      case 376: /* table_reference ::= table_primary */ yytestcase(yyruleno==376);
      case 377: /* table_reference ::= joined_table */ yytestcase(yyruleno==377);
      case 381: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==381);
      case 428: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==428);
      case 431: /* query_primary ::= query_specification */ yytestcase(yyruleno==431);
{ yylhsminor.yy632 = yymsp[0].minor.yy632; }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 271: /* literal ::= NULL */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 272: /* literal ::= NK_QUESTION */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 273: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 274: /* signed ::= NK_INTEGER */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 275: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 276: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 277: /* signed ::= NK_FLOAT */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 278: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 279: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 281: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 282: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 283: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 284: /* signed_literal ::= duration_literal */
      case 286: /* signed_literal ::= literal_func */ yytestcase(yyruleno==286);
      case 343: /* star_func_para ::= expression */ yytestcase(yyruleno==343);
      case 398: /* select_item ::= common_expression */ yytestcase(yyruleno==398);
      case 444: /* search_condition ::= common_expression */ yytestcase(yyruleno==444);
{ yylhsminor.yy632 = releaseRawExprNode(pCxt, yymsp[0].minor.yy632); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 285: /* signed_literal ::= NULL */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 305: /* expression ::= NK_LP expression NK_RP */
      case 370: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==370);
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy632)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 306: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy632));
                                                                                  }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 307: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy632), NULL));
                                                                                  }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 308: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); 
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 309: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); 
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 310: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); 
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 311: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); 
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 312: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); 
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 313: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 314: /* expression_list ::= expression */
{ yylhsminor.yy424 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy632)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 315: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, releaseRawExprNode(pCxt, yymsp[0].minor.yy632)); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 316: /* column_reference ::= column_name */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy209, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy209)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 317: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209, createColumnNode(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 318: /* pseudo_column ::= ROWTS */
      case 319: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==319);
      case 321: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==321);
      case 322: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==322);
      case 323: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==323);
      case 324: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==324);
      case 325: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==325);
      case 331: /* literal_func ::= NOW */ yytestcase(yyruleno==331);
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 320: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy209)))); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 326: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 327: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==327);
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy209, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy209, yymsp[-1].minor.yy424)); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 328: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy632), yymsp[-1].minor.yy304)); }
  yymsp[-5].minor.yy632 = yylhsminor.yy632;
        break;
      case 330: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy209, NULL)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 339: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy424 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 344: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 401: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==401);
{ yylhsminor.yy632 = createColumnNode(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 345: /* predicate ::= expression compare_op expression */
      case 350: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==350);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy380, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 346: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy632), releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 347: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy632), releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-5].minor.yy632 = yylhsminor.yy632;
        break;
      case 348: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), NULL));
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 349: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy632), NULL));
                                                                                  }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 351: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy380 = OP_TYPE_LOWER_THAN; }
        break;
      case 352: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy380 = OP_TYPE_GREATER_THAN; }
        break;
      case 353: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy380 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 354: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy380 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 355: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy380 = OP_TYPE_NOT_EQUAL; }
        break;
      case 356: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy380 = OP_TYPE_EQUAL; }
        break;
      case 357: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy380 = OP_TYPE_LIKE; }
        break;
      case 358: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy380 = OP_TYPE_NOT_LIKE; }
        break;
      case 359: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy380 = OP_TYPE_MATCH; }
        break;
      case 360: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy380 = OP_TYPE_NMATCH; }
        break;
      case 361: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy380 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 362: /* in_op ::= IN */
{ yymsp[0].minor.yy380 = OP_TYPE_IN; }
        break;
      case 363: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy380 = OP_TYPE_NOT_IN; }
        break;
      case 364: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy424)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 366: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy632), NULL));
                                                                                  }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 367: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 368: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 375: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy632 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy632, yymsp[0].minor.yy632, NULL); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 378: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy632 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy209, &yymsp[0].minor.yy209); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 379: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy632 = createRealTableNode(pCxt, &yymsp[-3].minor.yy209, &yymsp[-1].minor.yy209, &yymsp[0].minor.yy209); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 380: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy632 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy632), &yymsp[0].minor.yy209); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 382: /* alias_opt ::= */
{ yymsp[1].minor.yy209 = nil_token;  }
        break;
      case 383: /* alias_opt ::= table_alias */
{ yylhsminor.yy209 = yymsp[0].minor.yy209; }
  yymsp[0].minor.yy209 = yylhsminor.yy209;
        break;
      case 384: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy209 = yymsp[0].minor.yy209; }
        break;
      case 385: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 386: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==386);
{ yymsp[-2].minor.yy632 = yymsp[-1].minor.yy632; }
        break;
      case 387: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy632 = createJoinTableNode(pCxt, yymsp[-4].minor.yy612, yymsp[-5].minor.yy632, yymsp[-2].minor.yy632, yymsp[0].minor.yy632); }
  yymsp[-5].minor.yy632 = yylhsminor.yy632;
        break;
      case 388: /* join_type ::= */
{ yymsp[1].minor.yy612 = JOIN_TYPE_INNER; }
        break;
      case 389: /* join_type ::= INNER */
{ yymsp[0].minor.yy612 = JOIN_TYPE_INNER; }
        break;
      case 390: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy632 = createSelectStmt(pCxt, yymsp[-7].minor.yy137, yymsp[-6].minor.yy424, yymsp[-5].minor.yy632);
                                                                                    yymsp[-8].minor.yy632 = addWhereClause(pCxt, yymsp[-8].minor.yy632, yymsp[-4].minor.yy632);
                                                                                    yymsp[-8].minor.yy632 = addPartitionByClause(pCxt, yymsp[-8].minor.yy632, yymsp[-3].minor.yy424);
                                                                                    yymsp[-8].minor.yy632 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy632, yymsp[-2].minor.yy632);
                                                                                    yymsp[-8].minor.yy632 = addGroupByClause(pCxt, yymsp[-8].minor.yy632, yymsp[-1].minor.yy424);
                                                                                    yymsp[-8].minor.yy632 = addHavingClause(pCxt, yymsp[-8].minor.yy632, yymsp[0].minor.yy632);
                                                                                  }
        break;
      case 393: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy137 = false; }
        break;
      case 394: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy424 = NULL; }
        break;
      case 399: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy632 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy632), &yymsp[0].minor.yy209); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 400: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy632 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), &yymsp[0].minor.yy209); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 405: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 422: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==422);
      case 434: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==434);
{ yymsp[-2].minor.yy424 = yymsp[0].minor.yy424; }
        break;
      case 407: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy632 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy632), releaseRawExprNode(pCxt, yymsp[-1].minor.yy632)); }
        break;
      case 408: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy632 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy632)); }
        break;
      case 409: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy632 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy632), NULL, yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 410: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy632 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy632), releaseRawExprNode(pCxt, yymsp[-3].minor.yy632), yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 412: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy632 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy632); }
        break;
      case 414: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy632 = createFillNode(pCxt, yymsp[-1].minor.yy54, NULL); }
        break;
      case 415: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy632 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy424)); }
        break;
      case 416: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy54 = FILL_MODE_NONE; }
        break;
      case 417: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy54 = FILL_MODE_PREV; }
        break;
      case 418: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy54 = FILL_MODE_NULL; }
        break;
      case 419: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy54 = FILL_MODE_LINEAR; }
        break;
      case 420: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy54 = FILL_MODE_NEXT; }
        break;
      case 423: /* group_by_list ::= expression */
{ yylhsminor.yy424 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 424: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 427: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy632 = addOrderByClause(pCxt, yymsp[-3].minor.yy632, yymsp[-2].minor.yy424);
                                                                                    yylhsminor.yy632 = addSlimitClause(pCxt, yylhsminor.yy632, yymsp[-1].minor.yy632);
                                                                                    yylhsminor.yy632 = addLimitClause(pCxt, yylhsminor.yy632, yymsp[0].minor.yy632);
                                                                                  }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 429: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy632 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy632, yymsp[0].minor.yy632); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 430: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy632 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy632, yymsp[0].minor.yy632); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 432: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ yymsp[-5].minor.yy632 = yymsp[-4].minor.yy632; }
  yy_destructor(yypParser,352,&yymsp[-3].minor);
  yy_destructor(yypParser,353,&yymsp[-2].minor);
  yy_destructor(yypParser,354,&yymsp[-1].minor);
        break;
      case 436: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 440: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==440);
{ yymsp[-1].minor.yy632 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 437: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 441: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==441);
{ yymsp[-3].minor.yy632 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 438: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 442: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==442);
{ yymsp[-3].minor.yy632 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 443: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy632); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 447: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy632 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), yymsp[-1].minor.yy578, yymsp[0].minor.yy217); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 448: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy578 = ORDER_ASC; }
        break;
      case 449: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy578 = ORDER_ASC; }
        break;
      case 450: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy578 = ORDER_DESC; }
        break;
      case 451: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy217 = NULL_ORDER_DEFAULT; }
        break;
      case 452: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy217 = NULL_ORDER_FIRST; }
        break;
      case 453: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy217 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
