/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 358
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy14;
  ENullOrder yy17;
  SNodeList* yy60;
  SToken yy105;
  int32_t yy140;
  SNode* yy172;
  EFillMode yy202;
  SDataType yy248;
  EOperatorType yy572;
  int64_t yy593;
  SAlterOption yy609;
  bool yy617;
  EJoinType yy636;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             616
#define YYNRULE              452
#define YYNTOKEN             238
#define YY_MAX_SHIFT         615
#define YY_MIN_SHIFTREDUCE   902
#define YY_MAX_SHIFTREDUCE   1353
#define YY_ERROR_ACTION      1354
#define YY_ACCEPT_ACTION     1355
#define YY_NO_ACTION         1356
#define YY_MIN_REDUCE        1357
#define YY_MAX_REDUCE        1808
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2165)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */    72,  355, 1655, 1642,   28,  230,  296, 1465, 1642,  608,
 /*    10 */   607,  313,   35,   33,  530,   36,   34,   32,   31,   30,
 /*    20 */   305, 1481, 1167, 1639,  530,  490,  106, 1477, 1639,  389,
 /*    30 */  1671,  390, 1389,  428,  490,  277,  152,  349,  514, 1635,
 /*    40 */  1641,  529,  133, 1488, 1635, 1641, 1445, 1165,  513,  132,
 /*    50 */   533, 1369, 1625, 1488,  114,  533,  529,  494,   14,  530,
 /*    60 */    35,   33, 1294,  114, 1173, 1416,  932,   63,  305, 1684,
 /*    70 */  1167,  353,   82, 1656,  516, 1658, 1659,  512, 1786,  533,
 /*    80 */   110,    1, 1724,   56, 1532, 1308,  278, 1720, 1488, 1483,
 /*    90 */   147,  295,  112,  517, 1783, 1165, 1530,  529, 1786, 1578,
 /*   100 */   564,  112,   39,  612,  936,  937,   14,  145, 1731, 1732,
 /*   110 */   149, 1736, 1173, 1166, 1783,  492,  144, 1731, 1732,  563,
 /*   120 */  1736,  562,  561,  560,  407,  588,  587,  586,  320,    2,
 /*   130 */   585,  584,  583,  116,  578,  577,  576,  575,  574,  573,
 /*   140 */   572,  571,  123,  567, 1358,   36,   34,   32,   31,   30,
 /*   150 */   397,  612,  390, 1389,  142,  317, 1168, 1191,   38, 1671,
 /*   160 */    55, 1166, 1568, 1570, 1466,   96, 1526,  483,   95,   94,
 /*   170 */    93,   92,   91,   90,   89,   88,   87,  479,  388, 1171,
 /*   180 */  1172,  392, 1218, 1219, 1221, 1222, 1223, 1224, 1225,  509,
 /*   190 */   531, 1233, 1234, 1235, 1236, 1237, 1238,   36,   34,   32,
 /*   200 */    31,   30,  517,  482, 1168,  308,  581,   96, 1577,  150,
 /*   210 */    95,   94,   93,   92,   91,   90,   89,   88,   87,  288,
 /*   220 */   130,  407,   36,   34,   32,   31,   30, 1171, 1172, 1491,
 /*   230 */  1218, 1219, 1221, 1222, 1223, 1224, 1225,  509,  531, 1233,
 /*   240 */  1234, 1235, 1236, 1237, 1238,   35,   33,  343,  485,  480,
 /*   250 */  1355,  442,  441,  305, 1655, 1167,  440,  200,  252,  111,
 /*   260 */   437, 1518,  379,  436,  435,  434,   35,   33,  289,  447,
 /*   270 */   287,  286, 1001,  430,  305, 1479, 1167,  432,  129,  309,
 /*   280 */  1165,   79, 1671,   55,  455,   66,  150,  130,  150, 1003,
 /*   290 */   514,   14, 1205,  484,  115, 1639, 1490, 1173,  193,  431,
 /*   300 */   513, 1165, 1480,  949, 1625,  948,  161,  160,  321,  494,
 /*   310 */   450, 1635, 1641,  394,    2,  444, 1192, 1643, 1173, 1189,
 /*   320 */   192, 1684,  533,  490,   82, 1656,  516, 1658, 1659,  512,
 /*   330 */    24,  533,  950, 1350, 1724,    8,  612, 1639,  278, 1720,
 /*   340 */    36,   34,   32,   31,   30,   51, 1166, 1464,   50, 1786,
 /*   350 */  1786,  566,  114, 1635, 1641,   65,  294,  612, 1380,  194,
 /*   360 */   559,  147,  147, 1463,  533, 1783, 1783, 1166, 1357, 1039,
 /*   370 */   556,  555,  554, 1043,  553, 1045, 1046,  552, 1048,  549,
 /*   380 */  1379, 1054,  546, 1056, 1057,  543,  540,    7,   55, 1168,
 /*   390 */   112, 1190,  105,  104,  103,  102,  101,  100,   99,   98,
 /*   400 */    97,   32,   31,   30,  566,  146, 1731, 1732, 1625, 1736,
 /*   410 */  1168,  150, 1171, 1172, 1349, 1218, 1219, 1221, 1222, 1223,
 /*   420 */  1224, 1225,  509,  531, 1233, 1234, 1235, 1236, 1237, 1238,
 /*   430 */  1625,  569,  157, 1171, 1172,  463, 1218, 1219, 1221, 1222,
 /*   440 */  1223, 1224, 1225,  509,  531, 1233, 1234, 1235, 1236, 1237,
 /*   450 */  1238,   35,   33, 1239,   26, 1378,  564,   61,  466,  305,
 /*   460 */    60, 1167,  564,  150,   36,   34,   32,   31,   30,   63,
 /*   470 */  1406,  396,   35,   33,  392,  563, 1655,  562,  561,  560,
 /*   480 */   305,  563, 1167,  562,  561,  560, 1165, 1193,  530, 1318,
 /*   490 */   530, 1484,  443,   36,   34,   32,   31,   30, 1786, 1786,
 /*   500 */   354, 1645,  106, 1173, 1671, 1625, 1473, 1165,   55,  433,
 /*   510 */  1785,  147,  493,  456, 1783, 1783,  150, 1488, 1377, 1488,
 /*   520 */     9,  570,  513, 1460, 1173, 1419, 1625,  454,  476, 1316,
 /*   530 */  1317, 1319, 1320,   36,   34,   32,   31,   30, 1647,  279,
 /*   540 */   452,    9,  612, 1684,  439,  438,   83, 1656,  516, 1658,
 /*   550 */  1659,  512, 1166,  533, 1786, 1475, 1724, 1532, 1289,  315,
 /*   560 */   298, 1720,  143,  612,  310, 1786,  147,  130, 1625, 1530,
 /*   570 */  1783, 1256, 1301, 1166,  222, 1786, 1490,  148, 1191,  472,
 /*   580 */  1751, 1783,  348, 1738,  347,  442,  441, 1784,  530,  340,
 /*   590 */   440, 1783, 1532,  111,  437, 1168, 1532,  436,  435,  434,
 /*   600 */   364,  582,  580,  316, 1531, 1569, 1570, 1735, 1530,  342,
 /*   610 */   338, 1293,  221, 1376,  936,  937, 1168, 1488, 1171, 1172,
 /*   620 */  1257, 1218, 1219, 1221, 1222, 1223, 1224, 1225,  509,  531,
 /*   630 */  1233, 1234, 1235, 1236, 1237, 1238,  150,   11,   10, 1171,
 /*   640 */  1172, 1262, 1218, 1219, 1221, 1222, 1223, 1224, 1225,  509,
 /*   650 */   531, 1233, 1234, 1235, 1236, 1237, 1238,   35,   33,  276,
 /*   660 */  1655, 1189,  530, 1625,  530,  305, 1375, 1167,  372,   54,
 /*   670 */  1374,  384, 1373, 1471,  365,  197,  406,  508,   27,  303,
 /*   680 */  1251, 1252, 1253, 1254, 1255, 1259, 1260, 1261, 1671,  385,
 /*   690 */   530, 1488, 1165, 1488, 1244,  530,  514, 1372, 1565,  530,
 /*   700 */  1191,  432, 1485, 1371,  318,  159,  513, 1604, 1191, 1173,
 /*   710 */  1625,  464,  130,  530, 1151, 1152, 1625, 1194, 1270, 1488,
 /*   720 */  1625, 1490, 1625,  431, 1488,  527,    2, 1684, 1488, 1258,
 /*   730 */    83, 1656,  516, 1658, 1659,  512,  948,  533, 1368, 1367,
 /*   740 */  1724, 1220, 1488,  498,  298, 1720, 1799, 1625,  612,  120,
 /*   750 */  1263, 1743, 1289, 1625, 1366, 1758, 1365, 1364, 1166,  383,
 /*   760 */  1363,  426,  378,  377,  376,  375,  374,  371,  370,  369,
 /*   770 */   368,  367,  363,  362,  361,  360,  359,  358,  357,  356,
 /*   780 */   530,  131,  530,  530, 1738, 1370,  258,   25, 1625, 1625,
 /*   790 */   468, 1738,  528, 1362,  243,  319, 1361,  501,  256,   53,
 /*   800 */  1613, 1168,   52, 1360, 1625,  506, 1625, 1625, 1734, 1488,
 /*   810 */  1625, 1488, 1488,  185, 1446, 1733,  183, 1292,  187,  162,
 /*   820 */   189,  186, 1176,  188, 1171, 1172,   46, 1218, 1219, 1221,
 /*   830 */  1222, 1223, 1224, 1225,  509,  531, 1233, 1234, 1235, 1236,
 /*   840 */  1237, 1238,  206, 1625,   55,  330, 1625,   36,   34,   32,
 /*   850 */    31,   30,  191, 1625, 1401,  190, 1167, 1399,  209,   11,
 /*   860 */    10, 1352, 1353, 1220,   46,   37,   37, 1315,   37,  232,
 /*   870 */   558, 1220,  457,  118,  119,   78,  445,  120, 1175,  448,
 /*   880 */    81, 1165,  538,  225,  973,   74,  119,  477, 1179,  120,
 /*   890 */   496,  216, 1672,  279,  121, 1390, 1655, 1527, 1173,  211,
 /*   900 */   425,  974,  119, 1754,  491,  251, 1264, 1226,  322, 1124,
 /*   910 */   234,   59,   58,  352,  522,  240,  156, 1205, 1032, 1189,
 /*   920 */   224,  346,    3, 1060, 1671, 1256, 1248, 1064,  499,  227,
 /*   930 */  1070,  229,  493,  275,    5, 1068,  336,  612,  332,  328,
 /*   940 */   153,  323,  513,  122, 1178,  329, 1625, 1166,  325,  284,
 /*   950 */  1001,  285,  312,  311,  248, 1135,  158,  366, 1567,  373,
 /*   960 */   381,  380, 1181, 1684,  382,  386,   83, 1656,  516, 1658,
 /*   970 */  1659,  512,  150,  533, 1257, 1655, 1724, 1195, 1198,  387,
 /*   980 */   298, 1720,  143,  395,  502,  398,  399, 1174, 1197,  400,
 /*   990 */  1168,  165,  167, 1199,  170, 1262,  172,  404,  401,  403,
 /*  1000 */  1752, 1196,  175, 1671, 1173,   62,  405,  408,  178,  427,
 /*  1010 */  1173,  514,   86, 1171, 1172,  429,  293, 1478, 1608,  182,
 /*  1020 */  1474,  513,  184,  124,  249, 1625,  125, 1476, 1655, 1472,
 /*  1030 */   126,  127,   27,  303, 1251, 1252, 1253, 1254, 1255, 1259,
 /*  1040 */  1260, 1261, 1684,  534,  195,   83, 1656,  516, 1658, 1659,
 /*  1050 */   512,  458,  533, 1177,  198, 1724, 1671,  462,  465,  298,
 /*  1060 */  1720, 1799,  201,  467,  514,  469,  459,  470,  478,  204,
 /*  1070 */  1781, 1194, 1765,  207,  513,  520, 1764,  475, 1625, 1655,
 /*  1080 */   297, 1755,  210,  481,  215,    6,  487, 1745,  474,  217,
 /*  1090 */  1655, 1289,  113, 1193,   40, 1684, 1182,  503,   83, 1656,
 /*  1100 */   516, 1658, 1659,  512, 1739,  533,  218, 1671, 1724,  137,
 /*  1110 */   500,  299,  298, 1720, 1799,  514,   18,  518, 1671, 1185,
 /*  1120 */   519, 1705, 1576, 1742, 1782,  513,  514,  223,  226, 1625,
 /*  1130 */   531, 1233, 1234,  228,  494, 1575,  513, 1802, 1655,  523,
 /*  1140 */  1625,  307,  236,  497,  524,  494, 1684,  238,  504,  263,
 /*  1150 */  1656,  516, 1658, 1659,  512,  525,  533, 1684,  250,   71,
 /*  1160 */   263, 1656,  516, 1658, 1659,  512, 1671,  533, 1489,   73,
 /*  1170 */  1461,  536,  253,  245,  514, 1786,  611,   47, 1655,  255,
 /*  1180 */   136,  264,  274,  265,  513, 1619, 1786,  149, 1625,  257,
 /*  1190 */  1618, 1783,   57, 1617,  324, 1614,  326,  327,  147,  331,
 /*  1200 */  1160, 1161, 1783,  154, 1612, 1684, 1671,  333,   84, 1656,
 /*  1210 */   516, 1658, 1659,  512,  514,  533,  334,  335, 1724, 1611,
 /*  1220 */   180,  337, 1723, 1720,  513, 1610,  339, 1609, 1625,  341,
 /*  1230 */  1594,  155,  141, 1138,  344,  345, 1137, 1655,  424,  420,
 /*  1240 */   416,  412,  179, 1588, 1587, 1684,  350,  351,   84, 1656,
 /*  1250 */   516, 1658, 1659,  512, 1586,  533, 1585, 1107, 1724, 1109,
 /*  1260 */   117, 1542,  505, 1720, 1560, 1671, 1559,   64, 1558, 1557,
 /*  1270 */   177, 1556, 1555,  511, 1554, 1553, 1552, 1551, 1550, 1549,
 /*  1280 */  1548, 1547, 1546,  513, 1545, 1544, 1543, 1625, 1541, 1655,
 /*  1290 */  1540, 1539, 1538, 1537, 1536, 1535, 1534, 1533, 1655, 1418,
 /*  1300 */  1386,  140,  163,  939, 1684, 1385, 1602,  272, 1656,  516,
 /*  1310 */  1658, 1659,  512,  510,  533,  507, 1696, 1671,  938, 1596,
 /*  1320 */   108, 1584,  171, 1583,  109,  514, 1671,  176, 1573,  168,
 /*  1330 */  1467,  173,  967,  402,  514,  513, 1417, 1415, 1413, 1625,
 /*  1340 */   164, 1411,  391, 1409,  513,  393,  169,  174, 1625,  411,
 /*  1350 */   409,  166,  410,  415, 1655,  413, 1684, 1398,  414,  134,
 /*  1360 */  1656,  516, 1658, 1659,  512, 1684,  533,  417,   84, 1656,
 /*  1370 */   516, 1658, 1659,  512,  418,  533,  419,  422, 1724,  615,
 /*  1380 */   421,  423, 1671, 1721, 1397, 1384, 1469, 1074, 1073, 1468,
 /*  1390 */   514,  579, 1000,  247,  999,  998,  997,  581,  994,  993,
 /*  1400 */   513,  992,  495, 1800, 1625,  107,  181,  473, 1655, 1407,
 /*  1410 */   290,  604,  600,  596,  592,  246,   45, 1655, 1402,  291,
 /*  1420 */   446, 1684, 1400,  292,  273, 1656,  516, 1658, 1659,  512,
 /*  1430 */   449,  533, 1383,  451, 1382,  453, 1671,   85, 1601, 1145,
 /*  1440 */    80, 1595,  460,  241,  514, 1671, 1582, 1581, 1580, 1572,
 /*  1450 */    67,  203,   15,  514,  513,  208,    4,   37, 1625,   49,
 /*  1460 */   461,  135,   48,  513,  199,   43,  213, 1625,   16, 1314,
 /*  1470 */  1655,  205,  212,  214,   22, 1684,  526, 1307,  268, 1656,
 /*  1480 */   516, 1658, 1659,  512, 1684,  533,  128,  134, 1656,  516,
 /*  1490 */  1658, 1659,  512,   68,  533, 1645,   23,  220, 1671,   42,
 /*  1500 */  1655,  471,   17, 1286,  202, 1285,  514,  138, 1343, 1338,
 /*  1510 */  1332, 1337,  300, 1342, 1341,  486,  513,  301,   10,   19,
 /*  1520 */  1625, 1228, 1143,  302,  196, 1249,   29,  139, 1671,  151,
 /*  1530 */  1213, 1801, 1227,   12,  515,   20,  511, 1684,   21,  521,
 /*  1540 */   273, 1656,  516, 1658, 1659,  512,  513,  533,   13,   41,
 /*  1550 */  1625,  231, 1655, 1312,  233,  235,   69, 1571,   70,  237,
 /*  1560 */  1687, 1644,  242,   74, 1230,  532, 1183, 1684, 1655,   44,
 /*  1570 */   272, 1656,  516, 1658, 1659,  512,  239,  533,  535, 1697,
 /*  1580 */  1671, 1061,  537,  314,  539,  541, 1058,  542,  514, 1055,
 /*  1590 */   544,  545,  547, 1049,  548,  550, 1671, 1047,  513, 1053,
 /*  1600 */   551, 1052, 1625, 1051,  514,  304, 1050, 1038, 1655,   75,
 /*  1610 */    76, 1069,   77,  557,  513, 1067, 1066,  965, 1625, 1684,
 /*  1620 */  1655,  306,  273, 1656,  516, 1658, 1659,  512,  565,  533,
 /*  1630 */   989, 1007,  244,  568,  987, 1684, 1671,  986,  273, 1656,
 /*  1640 */   516, 1658, 1659,  512,  514,  533,  985,  984, 1671,  983,
 /*  1650 */   982,  981,  980, 1004,  513, 1002,  514,  977, 1625,  976,
 /*  1660 */   975,  972,  971,  970, 1414,  589,  513,  590, 1655,  591,
 /*  1670 */  1625, 1412,  593,  595,  594, 1684, 1410,  597,  259, 1656,
 /*  1680 */   516, 1658, 1659,  512,  598,  533,  599, 1684, 1408,  601,
 /*  1690 */   267, 1656,  516, 1658, 1659,  512, 1671,  533,  602,  603,
 /*  1700 */  1655,  605,  606, 1395,  514, 1396, 1381,  609,  610, 1356,
 /*  1710 */  1356, 1169,  254,  613,  513,  614, 1356, 1356, 1625, 1356,
 /*  1720 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1671, 1356,
 /*  1730 */  1655, 1356, 1356, 1356, 1356, 1684,  514, 1356,  269, 1656,
 /*  1740 */   516, 1658, 1659,  512, 1356,  533,  513, 1356, 1356, 1356,
 /*  1750 */  1625, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1671, 1356,
 /*  1760 */  1356, 1356, 1655, 1356, 1356, 1356,  514, 1684, 1356, 1356,
 /*  1770 */   260, 1656,  516, 1658, 1659,  512,  513,  533, 1655, 1356,
 /*  1780 */  1625, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*  1790 */  1671, 1356, 1356, 1356, 1655, 1356, 1356, 1684,  514, 1356,
 /*  1800 */   270, 1656,  516, 1658, 1659,  512, 1671,  533,  513, 1356,
 /*  1810 */  1655, 1356, 1625, 1356,  514, 1356, 1356, 1356, 1356, 1356,
 /*  1820 */  1356, 1356, 1671, 1356,  513, 1356, 1356, 1356, 1625, 1684,
 /*  1830 */   514, 1356,  261, 1656,  516, 1658, 1659,  512, 1671,  533,
 /*  1840 */   513, 1356, 1356, 1356, 1625, 1684,  514, 1356,  271, 1656,
 /*  1850 */   516, 1658, 1659,  512, 1356,  533,  513, 1356, 1356, 1356,
 /*  1860 */  1625, 1684, 1655, 1356,  262, 1656,  516, 1658, 1659,  512,
 /*  1870 */  1356,  533, 1356, 1356, 1356, 1356, 1356, 1684, 1655, 1356,
 /*  1880 */  1667, 1656,  516, 1658, 1659,  512, 1356,  533, 1356, 1356,
 /*  1890 */  1671, 1356, 1356, 1356, 1356, 1356, 1356, 1356,  514, 1356,
 /*  1900 */  1356, 1356, 1356, 1356, 1356, 1356, 1671, 1356,  513, 1356,
 /*  1910 */  1655, 1356, 1625, 1356,  514, 1356, 1356, 1356, 1356, 1356,
 /*  1920 */  1356, 1356, 1356, 1356,  513, 1356, 1356, 1356, 1625, 1684,
 /*  1930 */  1356, 1356, 1666, 1656,  516, 1658, 1659,  512, 1671,  533,
 /*  1940 */  1356, 1356, 1655, 1356, 1356, 1684,  514, 1356, 1665, 1656,
 /*  1950 */   516, 1658, 1659,  512, 1356,  533,  513, 1356, 1356, 1356,
 /*  1960 */  1625, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*  1970 */  1671, 1356, 1655, 1356, 1356, 1356, 1356, 1684,  514, 1356,
 /*  1980 */   282, 1656,  516, 1658, 1659,  512, 1356,  533,  513, 1356,
 /*  1990 */  1356, 1356, 1625, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*  2000 */  1671, 1356, 1356, 1356, 1655, 1356, 1356, 1356,  514, 1684,
 /*  2010 */  1356, 1356,  281, 1656,  516, 1658, 1659,  512,  513,  533,
 /*  2020 */  1655, 1356, 1625, 1356, 1356, 1356, 1356, 1356, 1356, 1356,
 /*  2030 */  1356, 1356, 1671, 1356, 1356, 1356, 1356, 1356, 1356, 1684,
 /*  2040 */   514, 1356,  283, 1656,  516, 1658, 1659,  512, 1671,  533,
 /*  2050 */   513,  490, 1356, 1356, 1625, 1356,  514, 1356, 1356,  490,
 /*  2060 */  1356, 1356, 1356, 1356, 1356, 1356,  513, 1356, 1356, 1356,
 /*  2070 */  1625, 1684, 1356, 1356,  280, 1656,  516, 1658, 1659,  512,
 /*  2080 */   114,  533, 1356, 1356, 1356, 1356, 1356, 1684,  114, 1356,
 /*  2090 */   266, 1656,  516, 1658, 1659,  512, 1356,  533, 1356,  494,
 /*  2100 */  1356, 1356, 1356, 1356, 1356, 1356, 1356,  494, 1356, 1356,
 /*  2110 */  1356, 1356, 1356, 1356, 1356, 1356, 1356, 1356,  112, 1356,
 /*  2120 */  1356, 1356, 1356, 1356, 1356, 1356,  112, 1356, 1356, 1356,
 /*  2130 */  1356, 1356, 1356,  219, 1731,  489, 1356,  488, 1356, 1356,
 /*  2140 */  1786,  219, 1731,  489, 1356,  488, 1356, 1356, 1786, 1356,
 /*  2150 */  1356, 1356,  149, 1356, 1356, 1356, 1783, 1356, 1356, 1356,
 /*  2160 */   147, 1356, 1356, 1356, 1783,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   251,  248,  241,  271,  322,  323,  274,    0,  271,  249,
 /*    10 */   250,  274,   12,   13,  248,   12,   13,   14,   15,   16,
 /*    20 */    20,  272,   22,  291,  248,  248,  260,  270,  291,  244,
 /*    30 */   269,  246,  247,  267,  248,  282,  260,  296,  277,  307,
 /*    40 */   308,   20,  254,  277,  307,  308,  258,   47,  287,  240,
 /*    50 */   318,  242,  291,  277,  277,  318,   20,  296,   58,  248,
 /*    60 */    12,   13,   14,  277,   64,    0,    4,  253,   20,  308,
 /*    70 */    22,  260,  311,  312,  313,  314,  315,  316,  337,  318,
 /*    80 */   266,   81,  321,    4,  269,   82,  325,  326,  277,  275,
 /*    90 */   349,  276,  315,  287,  353,   47,  281,   20,  337,  293,
 /*   100 */    93,  315,   81,  103,   42,   43,   58,  330,  331,  332,
 /*   110 */   349,  334,   64,  113,  353,  329,  330,  331,  332,  112,
 /*   120 */   334,  114,  115,  116,   57,   60,   61,   62,   63,   81,
 /*   130 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   140 */    75,   76,   77,   78,    0,   12,   13,   14,   15,   16,
 /*   150 */   244,  103,  246,  247,  268,  279,  156,   20,   81,  269,
 /*   160 */    81,  113,  286,  287,    0,   21,  280,  277,   24,   25,
 /*   170 */    26,   27,   28,   29,   30,   31,   32,  143,  245,  179,
 /*   180 */   180,  248,  182,  183,  184,  185,  186,  187,  188,  189,
 /*   190 */   190,  191,  192,  193,  194,  195,  196,   12,   13,   14,
 /*   200 */    15,   16,  287,  313,  156,  290,   41,   21,  293,  209,
 /*   210 */    24,   25,   26,   27,   28,   29,   30,   31,   32,   35,
 /*   220 */   269,   57,   12,   13,   14,   15,   16,  179,  180,  278,
 /*   230 */   182,  183,  184,  185,  186,  187,  188,  189,  190,  191,
 /*   240 */   192,  193,  194,  195,  196,   12,   13,   82,  214,  215,
 /*   250 */   238,   60,   61,   20,  241,   22,   65,   55,  262,   68,
 /*   260 */    69,  265,   75,   72,   73,   74,   12,   13,   84,    4,
 /*   270 */    86,   87,   47,   89,   20,  271,   22,   93,  145,  261,
 /*   280 */    47,  251,  269,   81,   19,   83,  209,  269,  209,   64,
 /*   290 */   277,   58,   82,   20,  264,  291,  278,   64,   33,  115,
 /*   300 */   287,   47,  272,   20,  291,   22,  119,  120,  296,  296,
 /*   310 */    45,  307,  308,   14,   81,   50,   20,  271,   64,   20,
 /*   320 */    55,  308,  318,  248,  311,  312,  313,  314,  315,  316,
 /*   330 */     2,  318,   49,  148,  321,   81,  103,  291,  325,  326,
 /*   340 */    12,   13,   14,   15,   16,   80,  113,    0,   83,  337,
 /*   350 */   337,   57,  277,  307,  308,  165,  166,  103,  241,  169,
 /*   360 */    92,  349,  349,    0,  318,  353,  353,  113,    0,   94,
 /*   370 */    95,   96,   97,   98,   99,  100,  101,  102,  103,  104,
 /*   380 */   241,  106,  107,  108,  109,  110,  111,   37,   81,  156,
 /*   390 */   315,   20,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   400 */    32,   14,   15,   16,   57,  330,  331,  332,  291,  334,
 /*   410 */   156,  209,  179,  180,  229,  182,  183,  184,  185,  186,
 /*   420 */   187,  188,  189,  190,  191,  192,  193,  194,  195,  196,
 /*   430 */   291,   64,   55,  179,  180,  300,  182,  183,  184,  185,
 /*   440 */   186,  187,  188,  189,  190,  191,  192,  193,  194,  195,
 /*   450 */   196,   12,   13,   14,    2,  241,   93,   80,  296,   20,
 /*   460 */    83,   22,   93,  209,   12,   13,   14,   15,   16,  253,
 /*   470 */     0,  245,   12,   13,  248,  112,  241,  114,  115,  116,
 /*   480 */    20,  112,   22,  114,  115,  116,   47,   20,  248,  179,
 /*   490 */   248,  275,   22,   12,   13,   14,   15,   16,  337,  337,
 /*   500 */   260,   44,  260,   64,  269,  291,  270,   47,   81,  267,
 /*   510 */   349,  349,  277,  296,  353,  353,  209,  277,  241,  277,
 /*   520 */    81,  257,  287,  259,   64,    0,  291,   21,  218,  219,
 /*   530 */   220,  221,  222,   12,   13,   14,   15,   16,   81,   58,
 /*   540 */    34,   81,  103,  308,  255,  256,  311,  312,  313,  314,
 /*   550 */   315,  316,  113,  318,  337,  270,  321,  269,  208,  261,
 /*   560 */   325,  326,  327,  103,  276,  337,  349,  269,  291,  281,
 /*   570 */   353,   90,   14,  113,  339,  337,  278,  349,   20,  344,
 /*   580 */   345,  353,  155,  309,  157,   60,   61,  349,  248,  151,
 /*   590 */    65,  353,  269,   68,   69,  156,  269,   72,   73,   74,
 /*   600 */   260,  255,  256,  276,  281,  286,  287,  333,  281,  171,
 /*   610 */   172,    4,  145,  241,   42,   43,  156,  277,  179,  180,
 /*   620 */   139,  182,  183,  184,  185,  186,  187,  188,  189,  190,
 /*   630 */   191,  192,  193,  194,  195,  196,  209,    1,    2,  179,
 /*   640 */   180,  160,  182,  183,  184,  185,  186,  187,  188,  189,
 /*   650 */   190,  191,  192,  193,  194,  195,  196,   12,   13,   18,
 /*   660 */   241,   20,  248,  291,  248,   20,  241,   22,   27,    3,
 /*   670 */   241,   30,  241,  270,  260,  270,  260,  270,  197,  198,
 /*   680 */   199,  200,  201,  202,  203,  204,  205,  206,  269,   48,
 /*   690 */   248,  277,   47,  277,   14,  248,  277,  241,  277,  248,
 /*   700 */    20,   93,  260,  241,  261,  284,  287,  260,   20,   64,
 /*   710 */   291,  260,  269,  248,  167,  168,  291,   20,   82,  277,
 /*   720 */   291,  278,  291,  115,  277,  260,   81,  308,  277,  139,
 /*   730 */   311,  312,  313,  314,  315,  316,   22,  318,  241,  241,
 /*   740 */   321,  183,  277,   41,  325,  326,  327,  291,  103,   41,
 /*   750 */   160,  207,  208,  291,  241,  336,  241,  241,  113,  118,
 /*   760 */   241,   47,  121,  122,  123,  124,  125,  126,  127,  128,
 /*   770 */   129,  130,  131,  132,  133,  134,  135,  136,  137,  138,
 /*   780 */   248,   18,  248,  248,  309,  242,   23,  197,  291,  291,
 /*   790 */    82,  309,  260,  241,  260,  260,  241,   41,   35,   36,
 /*   800 */     0,  156,   39,  241,  291,   58,  291,  291,  333,  277,
 /*   810 */   291,  277,  277,   85,  258,  333,   88,  210,   85,   56,
 /*   820 */    85,   88,   47,   88,  179,  180,   41,  182,  183,  184,
 /*   830 */   185,  186,  187,  188,  189,  190,  191,  192,  193,  194,
 /*   840 */   195,  196,  145,  291,   81,   45,  291,   12,   13,   14,
 /*   850 */    15,   16,   85,  291,    0,   88,   22,    0,   41,    1,
 /*   860 */     2,  194,  195,  183,   41,   41,   41,   82,   41,   41,
 /*   870 */   270,  183,  304,   41,   41,   81,   22,   41,   47,   22,
 /*   880 */   117,   47,   41,  356,   47,   91,   41,  347,  113,   41,
 /*   890 */   224,  341,  269,   58,   41,  247,  241,  280,   64,   82,
 /*   900 */   249,   64,   41,  310,  335,   82,   82,   82,  306,   82,
 /*   910 */    82,  148,  149,  150,   82,   82,  153,   82,   82,   20,
 /*   920 */   350,  158,  338,   82,  269,   90,  179,   82,  226,  350,
 /*   930 */    82,  350,  277,  170,  211,   82,  173,  103,  175,  176,
 /*   940 */   177,  178,  287,   82,  113,   45,  291,  113,  248,  305,
 /*   950 */    47,  255,   12,   13,  298,  154,   40,  248,  248,  285,
 /*   960 */   139,  283,   22,  308,  283,  248,  311,  312,  313,  314,
 /*   970 */   315,  316,  209,  318,  139,  241,  321,   20,   20,  243,
 /*   980 */   325,  326,  327,  243,  228,  302,  287,   47,   20,  295,
 /*   990 */   156,  253,  253,   20,  253,  160,  253,  277,  297,  295,
 /*  1000 */   345,   20,  253,  269,   64,  253,  288,  248,  253,  243,
 /*  1010 */    64,  277,  248,  179,  180,  269,  243,  269,  291,  269,
 /*  1020 */   269,  287,  269,  269,  302,  291,  269,  269,  241,  269,
 /*  1030 */   269,  269,  197,  198,  199,  200,  201,  202,  203,  204,
 /*  1040 */   205,  206,  308,  103,  251,  311,  312,  313,  314,  315,
 /*  1050 */   316,  163,  318,  113,  251,  321,  269,  287,  248,  325,
 /*  1060 */   326,  327,  251,  295,  277,  277,  301,  288,  217,  251,
 /*  1070 */   336,   20,  346,  292,  287,  216,  346,  291,  291,  241,
 /*  1080 */   291,  310,  292,  291,  342,  223,  147,  343,  212,  306,
 /*  1090 */   241,  208,  277,   20,   40,  308,  156,  227,  311,  312,
 /*  1100 */   313,  314,  315,  316,  309,  318,  328,  269,  321,  340,
 /*  1110 */   225,  230,  325,  326,  327,  277,   81,  291,  269,  179,
 /*  1120 */   291,  324,  292,  336,  352,  287,  277,  351,  351,  291,
 /*  1130 */   190,  191,  192,  351,  296,  292,  287,  357,  241,  142,
 /*  1140 */   291,  291,  277,  352,  289,  296,  308,  251,  352,  311,
 /*  1150 */   312,  313,  314,  315,  316,  288,  318,  308,  265,  251,
 /*  1160 */   311,  312,  313,  314,  315,  316,  269,  318,  277,   81,
 /*  1170 */   259,  273,  248,  251,  277,  337,  243,  299,  241,  252,
 /*  1180 */   303,  263,  263,  263,  287,    0,  337,  349,  291,  239,
 /*  1190 */     0,  353,   40,    0,   72,    0,   47,  174,  349,  174,
 /*  1200 */    47,   47,  353,   47,    0,  308,  269,   47,  311,  312,
 /*  1210 */   313,  314,  315,  316,  277,  318,   47,  174,  321,    0,
 /*  1220 */    33,   47,  325,  326,  287,    0,   47,    0,  291,   47,
 /*  1230 */     0,   81,   45,  113,  160,  159,  156,  241,   51,   52,
 /*  1240 */    53,   54,   55,    0,    0,  308,  152,  151,  311,  312,
 /*  1250 */   313,  314,  315,  316,    0,  318,    0,   44,  321,   22,
 /*  1260 */    40,    0,  325,  326,    0,  269,    0,   80,    0,    0,
 /*  1270 */    83,    0,    0,  277,    0,    0,    0,    0,    0,    0,
 /*  1280 */     0,    0,    0,  287,    0,    0,    0,  291,    0,  241,
 /*  1290 */     0,    0,    0,    0,    0,    0,    0,    0,  241,    0,
 /*  1300 */     0,   41,   40,   14,  308,    0,    0,  311,  312,  313,
 /*  1310 */   314,  315,  316,  317,  318,  319,  320,  269,   14,    0,
 /*  1320 */    37,    0,  147,    0,   37,  277,  269,  140,    0,  142,
 /*  1330 */     0,  144,   59,  146,  277,  287,    0,    0,    0,  291,
 /*  1340 */    38,    0,   44,    0,  287,   44,   37,   37,  291,   37,
 /*  1350 */    47,  164,   45,   37,  241,   47,  308,    0,   45,  311,
 /*  1360 */   312,  313,  314,  315,  316,  308,  318,   47,  311,  312,
 /*  1370 */   313,  314,  315,  316,   45,  318,   37,   45,  321,   19,
 /*  1380 */    47,   37,  269,  326,    0,    0,    0,   47,   22,    0,
 /*  1390 */   277,   41,   47,   33,   47,   47,   47,   41,   47,   47,
 /*  1400 */   287,   47,  354,  355,  291,   45,   88,  294,  241,    0,
 /*  1410 */    22,   51,   52,   53,   54,   55,   90,  241,    0,   22,
 /*  1420 */    48,  308,    0,   22,  311,  312,  313,  314,  315,  316,
 /*  1430 */    47,  318,    0,   22,    0,   22,  269,   20,    0,   47,
 /*  1440 */    80,    0,   22,   83,  277,  269,    0,    0,    0,    0,
 /*  1450 */    81,   37,  213,  277,  287,   82,   41,   41,  291,  145,
 /*  1460 */   145,   81,  145,  287,  142,   41,   41,  291,  213,   82,
 /*  1470 */   241,  140,   81,   44,   81,  308,  116,   82,  311,  312,
 /*  1480 */   313,  314,  315,  316,  308,  318,  161,  311,  312,  313,
 /*  1490 */   314,  315,  316,   81,  318,   44,   41,   44,  269,   41,
 /*  1500 */   241,  141,   41,   82,  144,   82,  277,   44,   82,   47,
 /*  1510 */    82,   47,   47,   47,   47,  348,  287,   47,    2,   41,
 /*  1520 */   291,   82,  162,  294,  164,  179,   81,   44,  269,   44,
 /*  1530 */    22,  355,   82,   81,  181,   81,  277,  308,   81,  143,
 /*  1540 */   311,  312,  313,  314,  315,  316,  287,  318,  213,  207,
 /*  1550 */   291,   82,  241,   82,   81,   81,   81,    0,   81,   37,
 /*  1560 */    81,   44,   44,   91,   82,   81,   22,  308,  241,   81,
 /*  1570 */   311,  312,  313,  314,  315,  316,  140,  318,   92,  320,
 /*  1580 */   269,   82,   47,   47,   81,   47,   82,   81,  277,   82,
 /*  1590 */    47,   81,   47,   82,   81,   47,  269,   82,  287,  105,
 /*  1600 */    81,  105,  291,  105,  277,  294,  105,   22,  241,   81,
 /*  1610 */    81,   47,   81,   93,  287,  113,   22,   59,  291,  308,
 /*  1620 */   241,  294,  311,  312,  313,  314,  315,  316,   58,  318,
 /*  1630 */    47,   64,   41,   79,   47,  308,  269,   47,  311,  312,
 /*  1640 */   313,  314,  315,  316,  277,  318,   47,   47,  269,   47,
 /*  1650 */    22,   47,   47,   64,  287,   47,  277,   47,  291,   47,
 /*  1660 */    47,   47,   47,   47,    0,   47,  287,   45,  241,   37,
 /*  1670 */   291,    0,   47,   37,   45,  308,    0,   47,  311,  312,
 /*  1680 */   313,  314,  315,  316,   45,  318,   37,  308,    0,   47,
 /*  1690 */   311,  312,  313,  314,  315,  316,  269,  318,   45,   37,
 /*  1700 */   241,   47,   46,    0,  277,    0,    0,   22,   21,  358,
 /*  1710 */   358,   22,   22,   21,  287,   20,  358,  358,  291,  358,
 /*  1720 */   358,  358,  358,  358,  358,  358,  358,  358,  269,  358,
 /*  1730 */   241,  358,  358,  358,  358,  308,  277,  358,  311,  312,
 /*  1740 */   313,  314,  315,  316,  358,  318,  287,  358,  358,  358,
 /*  1750 */   291,  358,  358,  358,  358,  358,  358,  358,  269,  358,
 /*  1760 */   358,  358,  241,  358,  358,  358,  277,  308,  358,  358,
 /*  1770 */   311,  312,  313,  314,  315,  316,  287,  318,  241,  358,
 /*  1780 */   291,  358,  358,  358,  358,  358,  358,  358,  358,  358,
 /*  1790 */   269,  358,  358,  358,  241,  358,  358,  308,  277,  358,
 /*  1800 */   311,  312,  313,  314,  315,  316,  269,  318,  287,  358,
 /*  1810 */   241,  358,  291,  358,  277,  358,  358,  358,  358,  358,
 /*  1820 */   358,  358,  269,  358,  287,  358,  358,  358,  291,  308,
 /*  1830 */   277,  358,  311,  312,  313,  314,  315,  316,  269,  318,
 /*  1840 */   287,  358,  358,  358,  291,  308,  277,  358,  311,  312,
 /*  1850 */   313,  314,  315,  316,  358,  318,  287,  358,  358,  358,
 /*  1860 */   291,  308,  241,  358,  311,  312,  313,  314,  315,  316,
 /*  1870 */   358,  318,  358,  358,  358,  358,  358,  308,  241,  358,
 /*  1880 */   311,  312,  313,  314,  315,  316,  358,  318,  358,  358,
 /*  1890 */   269,  358,  358,  358,  358,  358,  358,  358,  277,  358,
 /*  1900 */   358,  358,  358,  358,  358,  358,  269,  358,  287,  358,
 /*  1910 */   241,  358,  291,  358,  277,  358,  358,  358,  358,  358,
 /*  1920 */   358,  358,  358,  358,  287,  358,  358,  358,  291,  308,
 /*  1930 */   358,  358,  311,  312,  313,  314,  315,  316,  269,  318,
 /*  1940 */   358,  358,  241,  358,  358,  308,  277,  358,  311,  312,
 /*  1950 */   313,  314,  315,  316,  358,  318,  287,  358,  358,  358,
 /*  1960 */   291,  358,  358,  358,  358,  358,  358,  358,  358,  358,
 /*  1970 */   269,  358,  241,  358,  358,  358,  358,  308,  277,  358,
 /*  1980 */   311,  312,  313,  314,  315,  316,  358,  318,  287,  358,
 /*  1990 */   358,  358,  291,  358,  358,  358,  358,  358,  358,  358,
 /*  2000 */   269,  358,  358,  358,  241,  358,  358,  358,  277,  308,
 /*  2010 */   358,  358,  311,  312,  313,  314,  315,  316,  287,  318,
 /*  2020 */   241,  358,  291,  358,  358,  358,  358,  358,  358,  358,
 /*  2030 */   358,  358,  269,  358,  358,  358,  358,  358,  358,  308,
 /*  2040 */   277,  358,  311,  312,  313,  314,  315,  316,  269,  318,
 /*  2050 */   287,  248,  358,  358,  291,  358,  277,  358,  358,  248,
 /*  2060 */   358,  358,  358,  358,  358,  358,  287,  358,  358,  358,
 /*  2070 */   291,  308,  358,  358,  311,  312,  313,  314,  315,  316,
 /*  2080 */   277,  318,  358,  358,  358,  358,  358,  308,  277,  358,
 /*  2090 */   311,  312,  313,  314,  315,  316,  358,  318,  358,  296,
 /*  2100 */   358,  358,  358,  358,  358,  358,  358,  296,  358,  358,
 /*  2110 */   358,  358,  358,  358,  358,  358,  358,  358,  315,  358,
 /*  2120 */   358,  358,  358,  358,  358,  358,  315,  358,  358,  358,
 /*  2130 */   358,  358,  358,  330,  331,  332,  358,  334,  358,  358,
 /*  2140 */   337,  330,  331,  332,  358,  334,  358,  358,  337,  358,
 /*  2150 */   358,  358,  349,  358,  358,  358,  353,  358,  358,  358,
 /*  2160 */   349,  358,  358,  358,  353,
};
#define YY_SHIFT_COUNT    (615)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1706)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   763,    0,    0,   48,  233,  233,  233,  233,  254,  254,
 /*    10 */   233,  233,  439,  460,  645,  460,  460,  460,  460,  460,
 /*    20 */   460,  460,  460,  460,  460,  460,  460,  460,  460,  460,
 /*    30 */   460,  460,  460,  460,  460,  460,  460,  460,   77,   77,
 /*    40 */    21,   21,   21,  940,  940,  940,  940,  427,  202,  307,
 /*    50 */    36,   36,   62,   62,   79,  307,  307,   36,   36,   36,
 /*    60 */    36,   36,   36,   36,   67,   36,   36,  137,  273,  296,
 /*    70 */   137,   36,   36,  137,   36,  137,  137,  296,  137,   36,
 /*    80 */   294,  641,  835,  481,  481,  186,  191,  834,  834,  834,
 /*    90 */   834,  834,  834,  834,  834,  834,  834,  834,  834,  834,
 /*   100 */   834,  834,  834,  834,  834,  834,  184,  283,  299,  299,
 /*   110 */   164,  225,  467,  467,  467,  347,  225,  371,  296,  137,
 /*   120 */   137,  296,  268,  367,  275,  275,  275,  275,  275,  275,
 /*   130 */   275, 1360,  144,  525,  185,  310,  190,   34,  558,  680,
 /*   140 */   572,  714,  608,  697,  544,  350,  544,  666,  666,  666,
 /*   150 */   607,  688,  723,  899,  900,  903,  801,  899,  899,  916,
 /*   160 */   821,  821,  899,  957,  957,  958,   67,  296,   67,  968,
 /*   170 */   973,   67,  968,   67,  371,  981,   67,   67,  899,   67,
 /*   180 */   957,  137,  137,  137,  137,  137,  137,  137,  137,  137,
 /*   190 */   137,  137,  899,  957,  946,  958,  294,  888,  296,  294,
 /*   200 */   899,  968,  294,  371,  981,  294, 1051,  851,  859,  946,
 /*   210 */   851,  859,  946,  946,  137,  862,  939,  876,  723,  883,
 /*   220 */   371, 1073, 1054,  870,  885,  881,  870,  885,  870,  885,
 /*   230 */  1035,  859,  946,  946,  859,  946,  997,  371,  981,  294,
 /*   240 */   268,  294,  371, 1088,  367,  899,  294,  957, 2165, 2165,
 /*   250 */  2165, 2165, 2165, 2165, 2165,   65, 1187,  368,  265,    3,
 /*   260 */   328,  452,  133,  210,    7,  363,  521,  521,  521,  521,
 /*   270 */   521,  521,  521,  521,  369,  438,  377,  187,  636,  590,
 /*   280 */   387,  387,  387,  387,  800,  165,  728,  733,  735,  767,
 /*   290 */   470,  854,  857,  506,  547,  708,  785,  817,  858,  667,
 /*   300 */   702,  756,  824,  747,  825,  457,  827,  828,  832,  833,
 /*   310 */   836,  775,  831,  823,  841,  845,  848,  853,  861,  794,
 /*   320 */   837, 1185, 1190, 1152, 1193, 1122, 1195, 1149, 1023, 1153,
 /*   330 */  1154, 1156, 1025, 1204, 1160, 1169, 1043, 1219, 1174, 1225,
 /*   340 */  1179, 1227, 1182, 1230, 1150, 1074, 1076, 1120, 1080, 1243,
 /*   350 */  1244, 1094, 1096, 1254, 1256, 1213, 1264, 1266, 1268, 1269,
 /*   360 */  1271, 1272, 1274, 1275, 1276, 1277, 1278, 1279, 1280, 1281,
 /*   370 */  1282, 1284, 1285, 1286, 1220, 1261, 1288, 1290, 1291, 1292,
 /*   380 */  1293, 1237, 1294, 1295, 1296, 1297, 1299, 1300, 1262, 1283,
 /*   390 */  1260, 1289, 1298, 1304, 1301, 1305, 1302, 1287, 1306, 1319,
 /*   400 */  1321, 1309, 1175, 1323, 1328, 1310, 1330, 1273, 1336, 1337,
 /*   410 */  1303, 1307, 1312, 1338, 1308, 1313, 1316, 1341, 1320, 1329,
 /*   420 */  1339, 1343, 1333, 1332, 1344, 1357, 1384, 1385, 1386, 1326,
 /*   430 */  1318, 1340, 1366, 1389, 1345, 1347, 1348, 1349, 1350, 1356,
 /*   440 */  1351, 1352, 1354, 1409, 1388, 1418, 1397, 1372, 1422, 1401,
 /*   450 */  1383, 1432, 1411, 1434, 1413, 1417, 1438, 1314, 1392, 1441,
 /*   460 */  1325, 1420, 1315, 1322, 1446, 1447, 1448, 1317, 1449, 1369,
 /*   470 */  1414, 1331, 1415, 1416, 1239, 1373, 1424, 1387, 1380, 1391,
 /*   480 */  1393, 1395, 1425, 1429, 1451, 1412, 1455, 1255, 1421, 1423,
 /*   490 */  1453, 1342, 1458, 1463, 1426, 1461, 1335, 1428, 1462, 1464,
 /*   500 */  1465, 1466, 1467, 1470, 1428, 1516, 1346, 1478, 1439, 1445,
 /*   510 */  1450, 1483, 1452, 1454, 1485, 1508, 1353, 1457, 1469, 1471,
 /*   520 */  1473, 1474, 1396, 1475, 1557, 1522, 1436, 1477, 1472, 1517,
 /*   530 */  1518, 1479, 1482, 1484, 1544, 1488, 1486, 1499, 1535, 1536,
 /*   540 */  1503, 1504, 1538, 1506, 1507, 1543, 1510, 1511, 1545, 1513,
 /*   550 */  1515, 1548, 1519, 1494, 1496, 1498, 1501, 1585, 1520, 1528,
 /*   560 */  1529, 1564, 1531, 1502, 1594, 1558, 1570, 1583, 1567, 1554,
 /*   570 */  1591, 1587, 1590, 1599, 1600, 1602, 1628, 1604, 1605, 1589,
 /*   580 */  1350, 1608, 1356, 1610, 1612, 1613, 1614, 1615, 1616, 1664,
 /*   590 */  1618, 1622, 1632, 1671, 1625, 1629, 1636, 1676, 1630, 1639,
 /*   600 */  1649, 1688, 1642, 1653, 1662, 1705, 1654, 1656, 1703, 1706,
 /*   610 */  1685, 1687, 1689, 1690, 1692, 1695,
};
#define YY_REDUCE_COUNT (254)
#define YY_REDUCE_MIN   (-318)
#define YY_REDUCE_MAX   (1811)
static const short yy_reduce_ofst[] = {
 /*     0 */    12, -239,   13,  235,  655,  419,  734,  787,  838,  849,
 /*    10 */   897,  937,  996, 1048, 1057, 1113, 1167, 1176, 1229, 1259,
 /*    20 */  1311, 1327, 1367, 1379, 1427, 1459, 1489, 1521, 1537, 1553,
 /*    30 */  1569, 1621, 1637, 1669, 1701, 1731, 1763, 1779, 1803, 1811,
 /*    40 */  -214, -223,   75, -268, -263,    4,   46, -259,  162,  217,
 /*    50 */  -234,  242, -215,  -94,  161,  228,  238, -224, -189,  240,
 /*    60 */   340,  414,  416,  442, -186,  447,  451, -185, -110,  -85,
 /*    70 */    18,  465,  532,  288,  534,  298,  327, -124,  443,  535,
 /*    80 */    30, -247, -318, -318, -318, -191, -212,  117,  139,  214,
 /*    90 */   277,  372,  425,  429,  431,  456,  462,  497,  498,  513,
 /*   100 */   515,  516,  519,  552,  555,  562, -114, -240,  -67,  226,
 /*   110 */   216,  289,  274,  475,  482, -251,  346,  421, -194,  -49,
 /*   120 */   323,  319,   -4,  264, -243,  236,  285,  403,  405,  407,
 /*   130 */   600,  135,  543,  556,  527,  540,  568,  550,  623,  623,
 /*   140 */   648,  651,  617,  593,  569,  569,  569,  570,  579,  581,
 /*   150 */   584,  623,  602,  700,  644,  696,  656,  709,  710,  674,
 /*   160 */   678,  681,  717,  736,  740,  683,  738,  699,  739,  694,
 /*   170 */   701,  741,  704,  743,  720,  718,  749,  752,  759,  755,
 /*   180 */   766,  746,  748,  750,  751,  753,  754,  757,  758,  760,
 /*   190 */   761,  762,  764,  773,  727,  722,  793,  765,  770,  803,
 /*   200 */   810,  768,  811,  788,  779,  818,  771,  726,  781,  786,
 /*   210 */   730,  790,  789,  792,  623,  744,  742,  769,  783,  569,
 /*   220 */   815,  795,  778,  772,  776,  780,  791,  777,  796,  782,
 /*   230 */   797,  830,  826,  829,  843,  850,  855,  865,  867,  896,
 /*   240 */   893,  908,  891,  898,  911,  924,  922,  933,  878,  877,
 /*   250 */   918,  919,  920,  927,  950,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*    10 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*    20 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*    30 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*    40 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*    50 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*    60 */  1354, 1354, 1354, 1354, 1423, 1354, 1354, 1354, 1354, 1354,
 /*    70 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*    80 */  1421, 1561, 1354, 1726, 1354, 1354, 1354, 1354, 1354, 1354,
 /*    90 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   100 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   110 */  1423, 1354, 1737, 1737, 1737, 1421, 1354, 1354, 1354, 1354,
 /*   120 */  1354, 1354, 1517, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   130 */  1354, 1597, 1354, 1354, 1803, 1354, 1603, 1761, 1354, 1354,
 /*   140 */  1354, 1354, 1470, 1753, 1729, 1743, 1730, 1788, 1788, 1788,
 /*   150 */  1746, 1354, 1757, 1354, 1354, 1354, 1589, 1354, 1354, 1566,
 /*   160 */  1563, 1563, 1354, 1354, 1354, 1354, 1423, 1354, 1423, 1354,
 /*   170 */  1354, 1423, 1354, 1423, 1354, 1354, 1423, 1423, 1354, 1423,
 /*   180 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   190 */  1354, 1354, 1354, 1354, 1354, 1354, 1421, 1599, 1354, 1421,
 /*   200 */  1354, 1354, 1421, 1354, 1354, 1421, 1354, 1768, 1766, 1354,
 /*   210 */  1768, 1766, 1354, 1354, 1354, 1780, 1776, 1759, 1757, 1743,
 /*   220 */  1354, 1354, 1354, 1794, 1790, 1806, 1794, 1790, 1794, 1790,
 /*   230 */  1354, 1766, 1354, 1354, 1766, 1354, 1574, 1354, 1354, 1421,
 /*   240 */  1354, 1421, 1354, 1486, 1354, 1354, 1421, 1354, 1591, 1605,
 /*   250 */  1520, 1520, 1520, 1424, 1359, 1354, 1354, 1354, 1354, 1354,
 /*   260 */  1354, 1354, 1354, 1354, 1354, 1354, 1670, 1779, 1778, 1702,
 /*   270 */  1701, 1700, 1698, 1669, 1482, 1354, 1354, 1354, 1354, 1354,
 /*   280 */  1663, 1664, 1662, 1661, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   290 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1727, 1354,
 /*   300 */  1791, 1795, 1354, 1354, 1354, 1646, 1354, 1354, 1354, 1354,
 /*   310 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   320 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   330 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   340 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   350 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   360 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   370 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   380 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   390 */  1388, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   400 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   410 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   420 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   430 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1451, 1450,
 /*   440 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   450 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   460 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   470 */  1354, 1354, 1750, 1760, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   480 */  1354, 1354, 1354, 1354, 1646, 1354, 1777, 1354, 1736, 1732,
 /*   490 */  1354, 1354, 1728, 1354, 1354, 1789, 1354, 1354, 1354, 1354,
 /*   500 */  1354, 1354, 1354, 1354, 1354, 1722, 1354, 1695, 1354, 1354,
 /*   510 */  1354, 1354, 1354, 1354, 1354, 1354, 1657, 1354, 1354, 1354,
 /*   520 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1645,
 /*   530 */  1354, 1686, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   540 */  1514, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   550 */  1354, 1354, 1354, 1499, 1497, 1496, 1495, 1354, 1492, 1354,
 /*   560 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   570 */  1443, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   580 */  1434, 1354, 1433, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   590 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   600 */  1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354, 1354,
 /*   610 */  1354, 1354, 1354, 1354, 1354, 1354,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*  PRIVILEGE => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*       DAYS => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /* FILE_FACTOR => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FULLTEXT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*      MERGE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*     DELETE => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /*      COUNT => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  231,  /*  NK_BITNOT => ID */
  231,  /*     INSERT => ID */
  231,  /*     VALUES => ID */
  231,  /*     IMPORT => ID */
  231,  /*    NK_SEMI => ID */
  231,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "GRANT",
  /*   37 */ "ON",
  /*   38 */ "TO",
  /*   39 */ "REVOKE",
  /*   40 */ "FROM",
  /*   41 */ "NK_COMMA",
  /*   42 */ "READ",
  /*   43 */ "WRITE",
  /*   44 */ "NK_DOT",
  /*   45 */ "DNODE",
  /*   46 */ "PORT",
  /*   47 */ "NK_INTEGER",
  /*   48 */ "DNODES",
  /*   49 */ "NK_IPTOKEN",
  /*   50 */ "LOCAL",
  /*   51 */ "QNODE",
  /*   52 */ "BNODE",
  /*   53 */ "SNODE",
  /*   54 */ "MNODE",
  /*   55 */ "DATABASE",
  /*   56 */ "USE",
  /*   57 */ "IF",
  /*   58 */ "NOT",
  /*   59 */ "EXISTS",
  /*   60 */ "BUFFER",
  /*   61 */ "CACHELAST",
  /*   62 */ "COMP",
  /*   63 */ "DAYS",
  /*   64 */ "NK_VARIABLE",
  /*   65 */ "FSYNC",
  /*   66 */ "MAXROWS",
  /*   67 */ "MINROWS",
  /*   68 */ "KEEP",
  /*   69 */ "PAGES",
  /*   70 */ "PAGESIZE",
  /*   71 */ "PRECISION",
  /*   72 */ "REPLICA",
  /*   73 */ "STRICT",
  /*   74 */ "WAL",
  /*   75 */ "VGROUPS",
  /*   76 */ "SINGLE_STABLE",
  /*   77 */ "RETENTIONS",
  /*   78 */ "SCHEMALESS",
  /*   79 */ "NK_COLON",
  /*   80 */ "TABLE",
  /*   81 */ "NK_LP",
  /*   82 */ "NK_RP",
  /*   83 */ "STABLE",
  /*   84 */ "ADD",
  /*   85 */ "COLUMN",
  /*   86 */ "MODIFY",
  /*   87 */ "RENAME",
  /*   88 */ "TAG",
  /*   89 */ "SET",
  /*   90 */ "NK_EQ",
  /*   91 */ "USING",
  /*   92 */ "TAGS",
  /*   93 */ "COMMENT",
  /*   94 */ "BOOL",
  /*   95 */ "TINYINT",
  /*   96 */ "SMALLINT",
  /*   97 */ "INT",
  /*   98 */ "INTEGER",
  /*   99 */ "BIGINT",
  /*  100 */ "FLOAT",
  /*  101 */ "DOUBLE",
  /*  102 */ "BINARY",
  /*  103 */ "TIMESTAMP",
  /*  104 */ "NCHAR",
  /*  105 */ "UNSIGNED",
  /*  106 */ "JSON",
  /*  107 */ "VARCHAR",
  /*  108 */ "MEDIUMBLOB",
  /*  109 */ "BLOB",
  /*  110 */ "VARBINARY",
  /*  111 */ "DECIMAL",
  /*  112 */ "FILE_FACTOR",
  /*  113 */ "NK_FLOAT",
  /*  114 */ "ROLLUP",
  /*  115 */ "TTL",
  /*  116 */ "SMA",
  /*  117 */ "SHOW",
  /*  118 */ "DATABASES",
  /*  119 */ "TABLES",
  /*  120 */ "STABLES",
  /*  121 */ "MNODES",
  /*  122 */ "MODULES",
  /*  123 */ "QNODES",
  /*  124 */ "FUNCTIONS",
  /*  125 */ "INDEXES",
  /*  126 */ "ACCOUNTS",
  /*  127 */ "APPS",
  /*  128 */ "CONNECTIONS",
  /*  129 */ "LICENCE",
  /*  130 */ "GRANTS",
  /*  131 */ "QUERIES",
  /*  132 */ "SCORES",
  /*  133 */ "TOPICS",
  /*  134 */ "VARIABLES",
  /*  135 */ "BNODES",
  /*  136 */ "SNODES",
  /*  137 */ "CLUSTER",
  /*  138 */ "TRANSACTIONS",
  /*  139 */ "LIKE",
  /*  140 */ "INDEX",
  /*  141 */ "FULLTEXT",
  /*  142 */ "FUNCTION",
  /*  143 */ "INTERVAL",
  /*  144 */ "TOPIC",
  /*  145 */ "AS",
  /*  146 */ "CONSUMER",
  /*  147 */ "GROUP",
  /*  148 */ "DESC",
  /*  149 */ "DESCRIBE",
  /*  150 */ "RESET",
  /*  151 */ "QUERY",
  /*  152 */ "CACHE",
  /*  153 */ "EXPLAIN",
  /*  154 */ "ANALYZE",
  /*  155 */ "VERBOSE",
  /*  156 */ "NK_BOOL",
  /*  157 */ "RATIO",
  /*  158 */ "COMPACT",
  /*  159 */ "VNODES",
  /*  160 */ "IN",
  /*  161 */ "OUTPUTTYPE",
  /*  162 */ "AGGREGATE",
  /*  163 */ "BUFSIZE",
  /*  164 */ "STREAM",
  /*  165 */ "INTO",
  /*  166 */ "TRIGGER",
  /*  167 */ "AT_ONCE",
  /*  168 */ "WINDOW_CLOSE",
  /*  169 */ "WATERMARK",
  /*  170 */ "KILL",
  /*  171 */ "CONNECTION",
  /*  172 */ "TRANSACTION",
  /*  173 */ "MERGE",
  /*  174 */ "VGROUP",
  /*  175 */ "REDISTRIBUTE",
  /*  176 */ "SPLIT",
  /*  177 */ "SYNCDB",
  /*  178 */ "DELETE",
  /*  179 */ "NULL",
  /*  180 */ "NK_QUESTION",
  /*  181 */ "NK_ARROW",
  /*  182 */ "ROWTS",
  /*  183 */ "TBNAME",
  /*  184 */ "QSTARTTS",
  /*  185 */ "QENDTS",
  /*  186 */ "WSTARTTS",
  /*  187 */ "WENDTS",
  /*  188 */ "WDURATION",
  /*  189 */ "CAST",
  /*  190 */ "NOW",
  /*  191 */ "TODAY",
  /*  192 */ "TIMEZONE",
  /*  193 */ "COUNT",
  /*  194 */ "FIRST",
  /*  195 */ "LAST",
  /*  196 */ "LAST_ROW",
  /*  197 */ "BETWEEN",
  /*  198 */ "IS",
  /*  199 */ "NK_LT",
  /*  200 */ "NK_GT",
  /*  201 */ "NK_LE",
  /*  202 */ "NK_GE",
  /*  203 */ "NK_NE",
  /*  204 */ "MATCH",
  /*  205 */ "NMATCH",
  /*  206 */ "CONTAINS",
  /*  207 */ "JOIN",
  /*  208 */ "INNER",
  /*  209 */ "SELECT",
  /*  210 */ "DISTINCT",
  /*  211 */ "WHERE",
  /*  212 */ "PARTITION",
  /*  213 */ "BY",
  /*  214 */ "SESSION",
  /*  215 */ "STATE_WINDOW",
  /*  216 */ "SLIDING",
  /*  217 */ "FILL",
  /*  218 */ "VALUE",
  /*  219 */ "NONE",
  /*  220 */ "PREV",
  /*  221 */ "LINEAR",
  /*  222 */ "NEXT",
  /*  223 */ "HAVING",
  /*  224 */ "ORDER",
  /*  225 */ "SLIMIT",
  /*  226 */ "SOFFSET",
  /*  227 */ "LIMIT",
  /*  228 */ "OFFSET",
  /*  229 */ "ASC",
  /*  230 */ "NULLS",
  /*  231 */ "ID",
  /*  232 */ "NK_BITNOT",
  /*  233 */ "INSERT",
  /*  234 */ "VALUES",
  /*  235 */ "IMPORT",
  /*  236 */ "NK_SEMI",
  /*  237 */ "FILE",
  /*  238 */ "cmd",
  /*  239 */ "account_options",
  /*  240 */ "alter_account_options",
  /*  241 */ "literal",
  /*  242 */ "alter_account_option",
  /*  243 */ "user_name",
  /*  244 */ "privileges",
  /*  245 */ "priv_level",
  /*  246 */ "priv_type_list",
  /*  247 */ "priv_type",
  /*  248 */ "db_name",
  /*  249 */ "dnode_endpoint",
  /*  250 */ "dnode_host_name",
  /*  251 */ "not_exists_opt",
  /*  252 */ "db_options",
  /*  253 */ "exists_opt",
  /*  254 */ "alter_db_options",
  /*  255 */ "integer_list",
  /*  256 */ "variable_list",
  /*  257 */ "retention_list",
  /*  258 */ "alter_db_option",
  /*  259 */ "retention",
  /*  260 */ "full_table_name",
  /*  261 */ "column_def_list",
  /*  262 */ "tags_def_opt",
  /*  263 */ "table_options",
  /*  264 */ "multi_create_clause",
  /*  265 */ "tags_def",
  /*  266 */ "multi_drop_clause",
  /*  267 */ "alter_table_clause",
  /*  268 */ "alter_table_options",
  /*  269 */ "column_name",
  /*  270 */ "type_name",
  /*  271 */ "signed_literal",
  /*  272 */ "create_subtable_clause",
  /*  273 */ "specific_tags_opt",
  /*  274 */ "literal_list",
  /*  275 */ "drop_table_clause",
  /*  276 */ "col_name_list",
  /*  277 */ "table_name",
  /*  278 */ "column_def",
  /*  279 */ "func_name_list",
  /*  280 */ "alter_table_option",
  /*  281 */ "col_name",
  /*  282 */ "db_name_cond_opt",
  /*  283 */ "like_pattern_opt",
  /*  284 */ "table_name_cond",
  /*  285 */ "from_db_opt",
  /*  286 */ "func_name",
  /*  287 */ "function_name",
  /*  288 */ "index_name",
  /*  289 */ "index_options",
  /*  290 */ "func_list",
  /*  291 */ "duration_literal",
  /*  292 */ "sliding_opt",
  /*  293 */ "func",
  /*  294 */ "expression_list",
  /*  295 */ "topic_name",
  /*  296 */ "query_expression",
  /*  297 */ "cgroup_name",
  /*  298 */ "analyze_opt",
  /*  299 */ "explain_options",
  /*  300 */ "agg_func_opt",
  /*  301 */ "bufsize_opt",
  /*  302 */ "stream_name",
  /*  303 */ "stream_options",
  /*  304 */ "into_opt",
  /*  305 */ "dnode_list",
  /*  306 */ "where_clause_opt",
  /*  307 */ "signed",
  /*  308 */ "literal_func",
  /*  309 */ "table_alias",
  /*  310 */ "column_alias",
  /*  311 */ "expression",
  /*  312 */ "pseudo_column",
  /*  313 */ "column_reference",
  /*  314 */ "function_expression",
  /*  315 */ "subquery",
  /*  316 */ "star_func",
  /*  317 */ "star_func_para_list",
  /*  318 */ "noarg_func",
  /*  319 */ "other_para_list",
  /*  320 */ "star_func_para",
  /*  321 */ "predicate",
  /*  322 */ "compare_op",
  /*  323 */ "in_op",
  /*  324 */ "in_predicate_value",
  /*  325 */ "boolean_value_expression",
  /*  326 */ "boolean_primary",
  /*  327 */ "common_expression",
  /*  328 */ "from_clause",
  /*  329 */ "table_reference_list",
  /*  330 */ "table_reference",
  /*  331 */ "table_primary",
  /*  332 */ "joined_table",
  /*  333 */ "alias_opt",
  /*  334 */ "parenthesized_joined_table",
  /*  335 */ "join_type",
  /*  336 */ "search_condition",
  /*  337 */ "query_specification",
  /*  338 */ "set_quantifier_opt",
  /*  339 */ "select_list",
  /*  340 */ "partition_by_clause_opt",
  /*  341 */ "twindow_clause_opt",
  /*  342 */ "group_by_clause_opt",
  /*  343 */ "having_clause_opt",
  /*  344 */ "select_sublist",
  /*  345 */ "select_item",
  /*  346 */ "fill_opt",
  /*  347 */ "fill_mode",
  /*  348 */ "group_by_list",
  /*  349 */ "query_expression_body",
  /*  350 */ "order_by_clause_opt",
  /*  351 */ "slimit_clause_opt",
  /*  352 */ "limit_clause_opt",
  /*  353 */ "query_primary",
  /*  354 */ "sort_specification_list",
  /*  355 */ "sort_specification",
  /*  356 */ "ordering_specification_opt",
  /*  357 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  29 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  30 */ "privileges ::= ALL",
 /*  31 */ "privileges ::= priv_type_list",
 /*  32 */ "priv_type_list ::= priv_type",
 /*  33 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  34 */ "priv_type ::= READ",
 /*  35 */ "priv_type ::= WRITE",
 /*  36 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  37 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  38 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  39 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  40 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  41 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  42 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  43 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  44 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  45 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  46 */ "dnode_endpoint ::= NK_STRING",
 /*  47 */ "dnode_host_name ::= NK_ID",
 /*  48 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  49 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  50 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  51 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  52 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  53 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  54 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  60 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  61 */ "cmd ::= USE db_name",
 /*  62 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  63 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  64 */ "not_exists_opt ::=",
 /*  65 */ "exists_opt ::= IF EXISTS",
 /*  66 */ "exists_opt ::=",
 /*  67 */ "db_options ::=",
 /*  68 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  69 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  70 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  71 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  72 */ "db_options ::= db_options DAYS NK_VARIABLE",
 /*  73 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  74 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  75 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  76 */ "db_options ::= db_options KEEP integer_list",
 /*  77 */ "db_options ::= db_options KEEP variable_list",
 /*  78 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  79 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  81 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  82 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  83 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  84 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  85 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  86 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  87 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  88 */ "alter_db_options ::= alter_db_option",
 /*  89 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  90 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  91 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  92 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  93 */ "alter_db_option ::= KEEP integer_list",
 /*  94 */ "alter_db_option ::= KEEP variable_list",
 /*  95 */ "alter_db_option ::= PAGES NK_INTEGER",
 /*  96 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  97 */ "alter_db_option ::= STRICT NK_INTEGER",
 /*  98 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  99 */ "integer_list ::= NK_INTEGER",
 /* 100 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 101 */ "variable_list ::= NK_VARIABLE",
 /* 102 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 103 */ "retention_list ::= retention",
 /* 104 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 105 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 106 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 107 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 108 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 109 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 110 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 111 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 112 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 113 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 114 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 115 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 116 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 117 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 118 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 119 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 120 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 121 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 122 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 123 */ "multi_create_clause ::= create_subtable_clause",
 /* 124 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 125 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options",
 /* 126 */ "multi_drop_clause ::= drop_table_clause",
 /* 127 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 128 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 129 */ "specific_tags_opt ::=",
 /* 130 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 131 */ "full_table_name ::= table_name",
 /* 132 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 133 */ "column_def_list ::= column_def",
 /* 134 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 135 */ "column_def ::= column_name type_name",
 /* 136 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 137 */ "type_name ::= BOOL",
 /* 138 */ "type_name ::= TINYINT",
 /* 139 */ "type_name ::= SMALLINT",
 /* 140 */ "type_name ::= INT",
 /* 141 */ "type_name ::= INTEGER",
 /* 142 */ "type_name ::= BIGINT",
 /* 143 */ "type_name ::= FLOAT",
 /* 144 */ "type_name ::= DOUBLE",
 /* 145 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 146 */ "type_name ::= TIMESTAMP",
 /* 147 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= TINYINT UNSIGNED",
 /* 149 */ "type_name ::= SMALLINT UNSIGNED",
 /* 150 */ "type_name ::= INT UNSIGNED",
 /* 151 */ "type_name ::= BIGINT UNSIGNED",
 /* 152 */ "type_name ::= JSON",
 /* 153 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 154 */ "type_name ::= MEDIUMBLOB",
 /* 155 */ "type_name ::= BLOB",
 /* 156 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= DECIMAL",
 /* 158 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 159 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 160 */ "tags_def_opt ::=",
 /* 161 */ "tags_def_opt ::= tags_def",
 /* 162 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 163 */ "table_options ::=",
 /* 164 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 165 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 166 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 167 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 168 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 169 */ "alter_table_options ::= alter_table_option",
 /* 170 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 171 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 172 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 173 */ "col_name_list ::= col_name",
 /* 174 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 175 */ "col_name ::= column_name",
 /* 176 */ "cmd ::= SHOW DNODES",
 /* 177 */ "cmd ::= SHOW USERS",
 /* 178 */ "cmd ::= SHOW DATABASES",
 /* 179 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 180 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 181 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 182 */ "cmd ::= SHOW MNODES",
 /* 183 */ "cmd ::= SHOW MODULES",
 /* 184 */ "cmd ::= SHOW QNODES",
 /* 185 */ "cmd ::= SHOW FUNCTIONS",
 /* 186 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 187 */ "cmd ::= SHOW STREAMS",
 /* 188 */ "cmd ::= SHOW ACCOUNTS",
 /* 189 */ "cmd ::= SHOW APPS",
 /* 190 */ "cmd ::= SHOW CONNECTIONS",
 /* 191 */ "cmd ::= SHOW LICENCE",
 /* 192 */ "cmd ::= SHOW GRANTS",
 /* 193 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 194 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 195 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 196 */ "cmd ::= SHOW QUERIES",
 /* 197 */ "cmd ::= SHOW SCORES",
 /* 198 */ "cmd ::= SHOW TOPICS",
 /* 199 */ "cmd ::= SHOW VARIABLES",
 /* 200 */ "cmd ::= SHOW BNODES",
 /* 201 */ "cmd ::= SHOW SNODES",
 /* 202 */ "cmd ::= SHOW CLUSTER",
 /* 203 */ "cmd ::= SHOW TRANSACTIONS",
 /* 204 */ "db_name_cond_opt ::=",
 /* 205 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 206 */ "like_pattern_opt ::=",
 /* 207 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 208 */ "table_name_cond ::= table_name",
 /* 209 */ "from_db_opt ::=",
 /* 210 */ "from_db_opt ::= FROM db_name",
 /* 211 */ "func_name_list ::= func_name",
 /* 212 */ "func_name_list ::= func_name_list NK_COMMA func_name",
 /* 213 */ "func_name ::= function_name",
 /* 214 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 215 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 216 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 217 */ "index_options ::=",
 /* 218 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 219 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 220 */ "func_list ::= func",
 /* 221 */ "func_list ::= func_list NK_COMMA func",
 /* 222 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 223 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 224 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 225 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 226 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 227 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 228 */ "cmd ::= DESC full_table_name",
 /* 229 */ "cmd ::= DESCRIBE full_table_name",
 /* 230 */ "cmd ::= RESET QUERY CACHE",
 /* 231 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 232 */ "analyze_opt ::=",
 /* 233 */ "analyze_opt ::= ANALYZE",
 /* 234 */ "explain_options ::=",
 /* 235 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 236 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 237 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 238 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 239 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 240 */ "agg_func_opt ::=",
 /* 241 */ "agg_func_opt ::= AGGREGATE",
 /* 242 */ "bufsize_opt ::=",
 /* 243 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 244 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 245 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 246 */ "into_opt ::=",
 /* 247 */ "into_opt ::= INTO full_table_name",
 /* 248 */ "stream_options ::=",
 /* 249 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 250 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 251 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 252 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 253 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 254 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 255 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 256 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 257 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 258 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 259 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 260 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 261 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 262 */ "cmd ::= query_expression",
 /* 263 */ "literal ::= NK_INTEGER",
 /* 264 */ "literal ::= NK_FLOAT",
 /* 265 */ "literal ::= NK_STRING",
 /* 266 */ "literal ::= NK_BOOL",
 /* 267 */ "literal ::= TIMESTAMP NK_STRING",
 /* 268 */ "literal ::= duration_literal",
 /* 269 */ "literal ::= NULL",
 /* 270 */ "literal ::= NK_QUESTION",
 /* 271 */ "duration_literal ::= NK_VARIABLE",
 /* 272 */ "signed ::= NK_INTEGER",
 /* 273 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 274 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 275 */ "signed ::= NK_FLOAT",
 /* 276 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 277 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 278 */ "signed_literal ::= signed",
 /* 279 */ "signed_literal ::= NK_STRING",
 /* 280 */ "signed_literal ::= NK_BOOL",
 /* 281 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 282 */ "signed_literal ::= duration_literal",
 /* 283 */ "signed_literal ::= NULL",
 /* 284 */ "signed_literal ::= literal_func",
 /* 285 */ "literal_list ::= signed_literal",
 /* 286 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 287 */ "db_name ::= NK_ID",
 /* 288 */ "table_name ::= NK_ID",
 /* 289 */ "column_name ::= NK_ID",
 /* 290 */ "function_name ::= NK_ID",
 /* 291 */ "table_alias ::= NK_ID",
 /* 292 */ "column_alias ::= NK_ID",
 /* 293 */ "user_name ::= NK_ID",
 /* 294 */ "index_name ::= NK_ID",
 /* 295 */ "topic_name ::= NK_ID",
 /* 296 */ "stream_name ::= NK_ID",
 /* 297 */ "cgroup_name ::= NK_ID",
 /* 298 */ "expression ::= literal",
 /* 299 */ "expression ::= pseudo_column",
 /* 300 */ "expression ::= column_reference",
 /* 301 */ "expression ::= function_expression",
 /* 302 */ "expression ::= subquery",
 /* 303 */ "expression ::= NK_LP expression NK_RP",
 /* 304 */ "expression ::= NK_PLUS expression",
 /* 305 */ "expression ::= NK_MINUS expression",
 /* 306 */ "expression ::= expression NK_PLUS expression",
 /* 307 */ "expression ::= expression NK_MINUS expression",
 /* 308 */ "expression ::= expression NK_STAR expression",
 /* 309 */ "expression ::= expression NK_SLASH expression",
 /* 310 */ "expression ::= expression NK_REM expression",
 /* 311 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 312 */ "expression_list ::= expression",
 /* 313 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 314 */ "column_reference ::= column_name",
 /* 315 */ "column_reference ::= table_name NK_DOT column_name",
 /* 316 */ "pseudo_column ::= ROWTS",
 /* 317 */ "pseudo_column ::= TBNAME",
 /* 318 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 319 */ "pseudo_column ::= QSTARTTS",
 /* 320 */ "pseudo_column ::= QENDTS",
 /* 321 */ "pseudo_column ::= WSTARTTS",
 /* 322 */ "pseudo_column ::= WENDTS",
 /* 323 */ "pseudo_column ::= WDURATION",
 /* 324 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 325 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 326 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 327 */ "function_expression ::= literal_func",
 /* 328 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 329 */ "literal_func ::= NOW",
 /* 330 */ "noarg_func ::= NOW",
 /* 331 */ "noarg_func ::= TODAY",
 /* 332 */ "noarg_func ::= TIMEZONE",
 /* 333 */ "star_func ::= COUNT",
 /* 334 */ "star_func ::= FIRST",
 /* 335 */ "star_func ::= LAST",
 /* 336 */ "star_func ::= LAST_ROW",
 /* 337 */ "star_func_para_list ::= NK_STAR",
 /* 338 */ "star_func_para_list ::= other_para_list",
 /* 339 */ "other_para_list ::= star_func_para",
 /* 340 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 341 */ "star_func_para ::= expression",
 /* 342 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 343 */ "predicate ::= expression compare_op expression",
 /* 344 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 345 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 346 */ "predicate ::= expression IS NULL",
 /* 347 */ "predicate ::= expression IS NOT NULL",
 /* 348 */ "predicate ::= expression in_op in_predicate_value",
 /* 349 */ "compare_op ::= NK_LT",
 /* 350 */ "compare_op ::= NK_GT",
 /* 351 */ "compare_op ::= NK_LE",
 /* 352 */ "compare_op ::= NK_GE",
 /* 353 */ "compare_op ::= NK_NE",
 /* 354 */ "compare_op ::= NK_EQ",
 /* 355 */ "compare_op ::= LIKE",
 /* 356 */ "compare_op ::= NOT LIKE",
 /* 357 */ "compare_op ::= MATCH",
 /* 358 */ "compare_op ::= NMATCH",
 /* 359 */ "compare_op ::= CONTAINS",
 /* 360 */ "in_op ::= IN",
 /* 361 */ "in_op ::= NOT IN",
 /* 362 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 363 */ "boolean_value_expression ::= boolean_primary",
 /* 364 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 365 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 366 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 367 */ "boolean_primary ::= predicate",
 /* 368 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 369 */ "common_expression ::= expression",
 /* 370 */ "common_expression ::= boolean_value_expression",
 /* 371 */ "from_clause ::= FROM table_reference_list",
 /* 372 */ "table_reference_list ::= table_reference",
 /* 373 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 374 */ "table_reference ::= table_primary",
 /* 375 */ "table_reference ::= joined_table",
 /* 376 */ "table_primary ::= table_name alias_opt",
 /* 377 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 378 */ "table_primary ::= subquery alias_opt",
 /* 379 */ "table_primary ::= parenthesized_joined_table",
 /* 380 */ "alias_opt ::=",
 /* 381 */ "alias_opt ::= table_alias",
 /* 382 */ "alias_opt ::= AS table_alias",
 /* 383 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 384 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 385 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 386 */ "join_type ::=",
 /* 387 */ "join_type ::= INNER",
 /* 388 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 389 */ "set_quantifier_opt ::=",
 /* 390 */ "set_quantifier_opt ::= DISTINCT",
 /* 391 */ "set_quantifier_opt ::= ALL",
 /* 392 */ "select_list ::= NK_STAR",
 /* 393 */ "select_list ::= select_sublist",
 /* 394 */ "select_sublist ::= select_item",
 /* 395 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 396 */ "select_item ::= common_expression",
 /* 397 */ "select_item ::= common_expression column_alias",
 /* 398 */ "select_item ::= common_expression AS column_alias",
 /* 399 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 400 */ "where_clause_opt ::=",
 /* 401 */ "where_clause_opt ::= WHERE search_condition",
 /* 402 */ "partition_by_clause_opt ::=",
 /* 403 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 404 */ "twindow_clause_opt ::=",
 /* 405 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 406 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 407 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 408 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 409 */ "sliding_opt ::=",
 /* 410 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 411 */ "fill_opt ::=",
 /* 412 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 413 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 414 */ "fill_mode ::= NONE",
 /* 415 */ "fill_mode ::= PREV",
 /* 416 */ "fill_mode ::= NULL",
 /* 417 */ "fill_mode ::= LINEAR",
 /* 418 */ "fill_mode ::= NEXT",
 /* 419 */ "group_by_clause_opt ::=",
 /* 420 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 421 */ "group_by_list ::= expression",
 /* 422 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 423 */ "having_clause_opt ::=",
 /* 424 */ "having_clause_opt ::= HAVING search_condition",
 /* 425 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 426 */ "query_expression_body ::= query_primary",
 /* 427 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 428 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 429 */ "query_primary ::= query_specification",
 /* 430 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 431 */ "order_by_clause_opt ::=",
 /* 432 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 433 */ "slimit_clause_opt ::=",
 /* 434 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 435 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 436 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 437 */ "limit_clause_opt ::=",
 /* 438 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 439 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 440 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 441 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 442 */ "search_condition ::= common_expression",
 /* 443 */ "sort_specification_list ::= sort_specification",
 /* 444 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 445 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 446 */ "ordering_specification_opt ::=",
 /* 447 */ "ordering_specification_opt ::= ASC",
 /* 448 */ "ordering_specification_opt ::= DESC",
 /* 449 */ "null_ordering_opt ::=",
 /* 450 */ "null_ordering_opt ::= NULLS FIRST",
 /* 451 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 238: /* cmd */
    case 241: /* literal */
    case 252: /* db_options */
    case 254: /* alter_db_options */
    case 259: /* retention */
    case 260: /* full_table_name */
    case 263: /* table_options */
    case 267: /* alter_table_clause */
    case 268: /* alter_table_options */
    case 271: /* signed_literal */
    case 272: /* create_subtable_clause */
    case 275: /* drop_table_clause */
    case 278: /* column_def */
    case 281: /* col_name */
    case 282: /* db_name_cond_opt */
    case 283: /* like_pattern_opt */
    case 284: /* table_name_cond */
    case 285: /* from_db_opt */
    case 286: /* func_name */
    case 289: /* index_options */
    case 291: /* duration_literal */
    case 292: /* sliding_opt */
    case 293: /* func */
    case 296: /* query_expression */
    case 299: /* explain_options */
    case 303: /* stream_options */
    case 304: /* into_opt */
    case 306: /* where_clause_opt */
    case 307: /* signed */
    case 308: /* literal_func */
    case 311: /* expression */
    case 312: /* pseudo_column */
    case 313: /* column_reference */
    case 314: /* function_expression */
    case 315: /* subquery */
    case 320: /* star_func_para */
    case 321: /* predicate */
    case 324: /* in_predicate_value */
    case 325: /* boolean_value_expression */
    case 326: /* boolean_primary */
    case 327: /* common_expression */
    case 328: /* from_clause */
    case 329: /* table_reference_list */
    case 330: /* table_reference */
    case 331: /* table_primary */
    case 332: /* joined_table */
    case 334: /* parenthesized_joined_table */
    case 336: /* search_condition */
    case 337: /* query_specification */
    case 341: /* twindow_clause_opt */
    case 343: /* having_clause_opt */
    case 345: /* select_item */
    case 346: /* fill_opt */
    case 349: /* query_expression_body */
    case 351: /* slimit_clause_opt */
    case 352: /* limit_clause_opt */
    case 353: /* query_primary */
    case 355: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy172)); 
}
      break;
    case 239: /* account_options */
    case 240: /* alter_account_options */
    case 242: /* alter_account_option */
    case 301: /* bufsize_opt */
{
 
}
      break;
    case 243: /* user_name */
    case 245: /* priv_level */
    case 248: /* db_name */
    case 249: /* dnode_endpoint */
    case 250: /* dnode_host_name */
    case 269: /* column_name */
    case 277: /* table_name */
    case 287: /* function_name */
    case 288: /* index_name */
    case 295: /* topic_name */
    case 297: /* cgroup_name */
    case 302: /* stream_name */
    case 309: /* table_alias */
    case 310: /* column_alias */
    case 316: /* star_func */
    case 318: /* noarg_func */
    case 333: /* alias_opt */
{
 
}
      break;
    case 244: /* privileges */
    case 246: /* priv_type_list */
    case 247: /* priv_type */
{
 
}
      break;
    case 251: /* not_exists_opt */
    case 253: /* exists_opt */
    case 298: /* analyze_opt */
    case 300: /* agg_func_opt */
    case 338: /* set_quantifier_opt */
{
 
}
      break;
    case 255: /* integer_list */
    case 256: /* variable_list */
    case 257: /* retention_list */
    case 261: /* column_def_list */
    case 262: /* tags_def_opt */
    case 264: /* multi_create_clause */
    case 265: /* tags_def */
    case 266: /* multi_drop_clause */
    case 273: /* specific_tags_opt */
    case 274: /* literal_list */
    case 276: /* col_name_list */
    case 279: /* func_name_list */
    case 290: /* func_list */
    case 294: /* expression_list */
    case 305: /* dnode_list */
    case 317: /* star_func_para_list */
    case 319: /* other_para_list */
    case 339: /* select_list */
    case 340: /* partition_by_clause_opt */
    case 342: /* group_by_clause_opt */
    case 344: /* select_sublist */
    case 348: /* group_by_list */
    case 350: /* order_by_clause_opt */
    case 354: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy60)); 
}
      break;
    case 258: /* alter_db_option */
    case 280: /* alter_table_option */
{
 
}
      break;
    case 270: /* type_name */
{
 
}
      break;
    case 322: /* compare_op */
    case 323: /* in_op */
{
 
}
      break;
    case 335: /* join_type */
{
 
}
      break;
    case 347: /* fill_mode */
{
 
}
      break;
    case 356: /* ordering_specification_opt */
{
 
}
      break;
    case 357: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  238,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  238,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  239,    0 }, /* (2) account_options ::= */
  {  239,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  239,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  239,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  239,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  239,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  239,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  239,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  239,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  239,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  240,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  240,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  242,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  242,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  242,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  242,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  242,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  242,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  242,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  242,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  242,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  242,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  238,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  238,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  238,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  238,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  238,   -6 }, /* (28) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  238,   -6 }, /* (29) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  244,   -1 }, /* (30) privileges ::= ALL */
  {  244,   -1 }, /* (31) privileges ::= priv_type_list */
  {  246,   -1 }, /* (32) priv_type_list ::= priv_type */
  {  246,   -3 }, /* (33) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  247,   -1 }, /* (34) priv_type ::= READ */
  {  247,   -1 }, /* (35) priv_type ::= WRITE */
  {  245,   -3 }, /* (36) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  245,   -3 }, /* (37) priv_level ::= db_name NK_DOT NK_STAR */
  {  238,   -3 }, /* (38) cmd ::= CREATE DNODE dnode_endpoint */
  {  238,   -5 }, /* (39) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  238,   -3 }, /* (40) cmd ::= DROP DNODE NK_INTEGER */
  {  238,   -3 }, /* (41) cmd ::= DROP DNODE dnode_endpoint */
  {  238,   -4 }, /* (42) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  238,   -5 }, /* (43) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  238,   -4 }, /* (44) cmd ::= ALTER ALL DNODES NK_STRING */
  {  238,   -5 }, /* (45) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  249,   -1 }, /* (46) dnode_endpoint ::= NK_STRING */
  {  250,   -1 }, /* (47) dnode_host_name ::= NK_ID */
  {  250,   -1 }, /* (48) dnode_host_name ::= NK_IPTOKEN */
  {  238,   -3 }, /* (49) cmd ::= ALTER LOCAL NK_STRING */
  {  238,   -4 }, /* (50) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  238,   -5 }, /* (51) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (52) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (53) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (54) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (55) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (56) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (57) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (58) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  238,   -5 }, /* (59) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  238,   -4 }, /* (60) cmd ::= DROP DATABASE exists_opt db_name */
  {  238,   -2 }, /* (61) cmd ::= USE db_name */
  {  238,   -4 }, /* (62) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  251,   -3 }, /* (63) not_exists_opt ::= IF NOT EXISTS */
  {  251,    0 }, /* (64) not_exists_opt ::= */
  {  253,   -2 }, /* (65) exists_opt ::= IF EXISTS */
  {  253,    0 }, /* (66) exists_opt ::= */
  {  252,    0 }, /* (67) db_options ::= */
  {  252,   -3 }, /* (68) db_options ::= db_options BUFFER NK_INTEGER */
  {  252,   -3 }, /* (69) db_options ::= db_options CACHELAST NK_INTEGER */
  {  252,   -3 }, /* (70) db_options ::= db_options COMP NK_INTEGER */
  {  252,   -3 }, /* (71) db_options ::= db_options DAYS NK_INTEGER */
  {  252,   -3 }, /* (72) db_options ::= db_options DAYS NK_VARIABLE */
  {  252,   -3 }, /* (73) db_options ::= db_options FSYNC NK_INTEGER */
  {  252,   -3 }, /* (74) db_options ::= db_options MAXROWS NK_INTEGER */
  {  252,   -3 }, /* (75) db_options ::= db_options MINROWS NK_INTEGER */
  {  252,   -3 }, /* (76) db_options ::= db_options KEEP integer_list */
  {  252,   -3 }, /* (77) db_options ::= db_options KEEP variable_list */
  {  252,   -3 }, /* (78) db_options ::= db_options PAGES NK_INTEGER */
  {  252,   -3 }, /* (79) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  252,   -3 }, /* (80) db_options ::= db_options PRECISION NK_STRING */
  {  252,   -3 }, /* (81) db_options ::= db_options REPLICA NK_INTEGER */
  {  252,   -3 }, /* (82) db_options ::= db_options STRICT NK_INTEGER */
  {  252,   -3 }, /* (83) db_options ::= db_options WAL NK_INTEGER */
  {  252,   -3 }, /* (84) db_options ::= db_options VGROUPS NK_INTEGER */
  {  252,   -3 }, /* (85) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  252,   -3 }, /* (86) db_options ::= db_options RETENTIONS retention_list */
  {  252,   -3 }, /* (87) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  254,   -1 }, /* (88) alter_db_options ::= alter_db_option */
  {  254,   -2 }, /* (89) alter_db_options ::= alter_db_options alter_db_option */
  {  258,   -2 }, /* (90) alter_db_option ::= BUFFER NK_INTEGER */
  {  258,   -2 }, /* (91) alter_db_option ::= CACHELAST NK_INTEGER */
  {  258,   -2 }, /* (92) alter_db_option ::= FSYNC NK_INTEGER */
  {  258,   -2 }, /* (93) alter_db_option ::= KEEP integer_list */
  {  258,   -2 }, /* (94) alter_db_option ::= KEEP variable_list */
  {  258,   -2 }, /* (95) alter_db_option ::= PAGES NK_INTEGER */
  {  258,   -2 }, /* (96) alter_db_option ::= REPLICA NK_INTEGER */
  {  258,   -2 }, /* (97) alter_db_option ::= STRICT NK_INTEGER */
  {  258,   -2 }, /* (98) alter_db_option ::= WAL NK_INTEGER */
  {  255,   -1 }, /* (99) integer_list ::= NK_INTEGER */
  {  255,   -3 }, /* (100) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  256,   -1 }, /* (101) variable_list ::= NK_VARIABLE */
  {  256,   -3 }, /* (102) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  257,   -1 }, /* (103) retention_list ::= retention */
  {  257,   -3 }, /* (104) retention_list ::= retention_list NK_COMMA retention */
  {  259,   -3 }, /* (105) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  238,   -9 }, /* (106) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  238,   -3 }, /* (107) cmd ::= CREATE TABLE multi_create_clause */
  {  238,   -9 }, /* (108) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  238,   -3 }, /* (109) cmd ::= DROP TABLE multi_drop_clause */
  {  238,   -4 }, /* (110) cmd ::= DROP STABLE exists_opt full_table_name */
  {  238,   -3 }, /* (111) cmd ::= ALTER TABLE alter_table_clause */
  {  238,   -3 }, /* (112) cmd ::= ALTER STABLE alter_table_clause */
  {  267,   -2 }, /* (113) alter_table_clause ::= full_table_name alter_table_options */
  {  267,   -5 }, /* (114) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  267,   -4 }, /* (115) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  267,   -5 }, /* (116) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  267,   -5 }, /* (117) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  267,   -5 }, /* (118) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  267,   -4 }, /* (119) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  267,   -5 }, /* (120) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  267,   -5 }, /* (121) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  267,   -6 }, /* (122) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  264,   -1 }, /* (123) multi_create_clause ::= create_subtable_clause */
  {  264,   -2 }, /* (124) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  272,  -10 }, /* (125) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
  {  266,   -1 }, /* (126) multi_drop_clause ::= drop_table_clause */
  {  266,   -2 }, /* (127) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  275,   -2 }, /* (128) drop_table_clause ::= exists_opt full_table_name */
  {  273,    0 }, /* (129) specific_tags_opt ::= */
  {  273,   -3 }, /* (130) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  260,   -1 }, /* (131) full_table_name ::= table_name */
  {  260,   -3 }, /* (132) full_table_name ::= db_name NK_DOT table_name */
  {  261,   -1 }, /* (133) column_def_list ::= column_def */
  {  261,   -3 }, /* (134) column_def_list ::= column_def_list NK_COMMA column_def */
  {  278,   -2 }, /* (135) column_def ::= column_name type_name */
  {  278,   -4 }, /* (136) column_def ::= column_name type_name COMMENT NK_STRING */
  {  270,   -1 }, /* (137) type_name ::= BOOL */
  {  270,   -1 }, /* (138) type_name ::= TINYINT */
  {  270,   -1 }, /* (139) type_name ::= SMALLINT */
  {  270,   -1 }, /* (140) type_name ::= INT */
  {  270,   -1 }, /* (141) type_name ::= INTEGER */
  {  270,   -1 }, /* (142) type_name ::= BIGINT */
  {  270,   -1 }, /* (143) type_name ::= FLOAT */
  {  270,   -1 }, /* (144) type_name ::= DOUBLE */
  {  270,   -4 }, /* (145) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  270,   -1 }, /* (146) type_name ::= TIMESTAMP */
  {  270,   -4 }, /* (147) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  270,   -2 }, /* (148) type_name ::= TINYINT UNSIGNED */
  {  270,   -2 }, /* (149) type_name ::= SMALLINT UNSIGNED */
  {  270,   -2 }, /* (150) type_name ::= INT UNSIGNED */
  {  270,   -2 }, /* (151) type_name ::= BIGINT UNSIGNED */
  {  270,   -1 }, /* (152) type_name ::= JSON */
  {  270,   -4 }, /* (153) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  270,   -1 }, /* (154) type_name ::= MEDIUMBLOB */
  {  270,   -1 }, /* (155) type_name ::= BLOB */
  {  270,   -4 }, /* (156) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  270,   -1 }, /* (157) type_name ::= DECIMAL */
  {  270,   -4 }, /* (158) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  270,   -6 }, /* (159) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  262,    0 }, /* (160) tags_def_opt ::= */
  {  262,   -1 }, /* (161) tags_def_opt ::= tags_def */
  {  265,   -4 }, /* (162) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  263,    0 }, /* (163) table_options ::= */
  {  263,   -3 }, /* (164) table_options ::= table_options COMMENT NK_STRING */
  {  263,   -3 }, /* (165) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  263,   -5 }, /* (166) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  263,   -3 }, /* (167) table_options ::= table_options TTL NK_INTEGER */
  {  263,   -5 }, /* (168) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  268,   -1 }, /* (169) alter_table_options ::= alter_table_option */
  {  268,   -2 }, /* (170) alter_table_options ::= alter_table_options alter_table_option */
  {  280,   -2 }, /* (171) alter_table_option ::= COMMENT NK_STRING */
  {  280,   -2 }, /* (172) alter_table_option ::= TTL NK_INTEGER */
  {  276,   -1 }, /* (173) col_name_list ::= col_name */
  {  276,   -3 }, /* (174) col_name_list ::= col_name_list NK_COMMA col_name */
  {  281,   -1 }, /* (175) col_name ::= column_name */
  {  238,   -2 }, /* (176) cmd ::= SHOW DNODES */
  {  238,   -2 }, /* (177) cmd ::= SHOW USERS */
  {  238,   -2 }, /* (178) cmd ::= SHOW DATABASES */
  {  238,   -4 }, /* (179) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  238,   -4 }, /* (180) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  238,   -3 }, /* (181) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  238,   -2 }, /* (182) cmd ::= SHOW MNODES */
  {  238,   -2 }, /* (183) cmd ::= SHOW MODULES */
  {  238,   -2 }, /* (184) cmd ::= SHOW QNODES */
  {  238,   -2 }, /* (185) cmd ::= SHOW FUNCTIONS */
  {  238,   -5 }, /* (186) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  238,   -2 }, /* (187) cmd ::= SHOW STREAMS */
  {  238,   -2 }, /* (188) cmd ::= SHOW ACCOUNTS */
  {  238,   -2 }, /* (189) cmd ::= SHOW APPS */
  {  238,   -2 }, /* (190) cmd ::= SHOW CONNECTIONS */
  {  238,   -2 }, /* (191) cmd ::= SHOW LICENCE */
  {  238,   -2 }, /* (192) cmd ::= SHOW GRANTS */
  {  238,   -4 }, /* (193) cmd ::= SHOW CREATE DATABASE db_name */
  {  238,   -4 }, /* (194) cmd ::= SHOW CREATE TABLE full_table_name */
  {  238,   -4 }, /* (195) cmd ::= SHOW CREATE STABLE full_table_name */
  {  238,   -2 }, /* (196) cmd ::= SHOW QUERIES */
  {  238,   -2 }, /* (197) cmd ::= SHOW SCORES */
  {  238,   -2 }, /* (198) cmd ::= SHOW TOPICS */
  {  238,   -2 }, /* (199) cmd ::= SHOW VARIABLES */
  {  238,   -2 }, /* (200) cmd ::= SHOW BNODES */
  {  238,   -2 }, /* (201) cmd ::= SHOW SNODES */
  {  238,   -2 }, /* (202) cmd ::= SHOW CLUSTER */
  {  238,   -2 }, /* (203) cmd ::= SHOW TRANSACTIONS */
  {  282,    0 }, /* (204) db_name_cond_opt ::= */
  {  282,   -2 }, /* (205) db_name_cond_opt ::= db_name NK_DOT */
  {  283,    0 }, /* (206) like_pattern_opt ::= */
  {  283,   -2 }, /* (207) like_pattern_opt ::= LIKE NK_STRING */
  {  284,   -1 }, /* (208) table_name_cond ::= table_name */
  {  285,    0 }, /* (209) from_db_opt ::= */
  {  285,   -2 }, /* (210) from_db_opt ::= FROM db_name */
  {  279,   -1 }, /* (211) func_name_list ::= func_name */
  {  279,   -3 }, /* (212) func_name_list ::= func_name_list NK_COMMA func_name */
  {  286,   -1 }, /* (213) func_name ::= function_name */
  {  238,   -8 }, /* (214) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  238,  -10 }, /* (215) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  238,   -6 }, /* (216) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  289,    0 }, /* (217) index_options ::= */
  {  289,   -9 }, /* (218) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  289,  -11 }, /* (219) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  290,   -1 }, /* (220) func_list ::= func */
  {  290,   -3 }, /* (221) func_list ::= func_list NK_COMMA func */
  {  293,   -4 }, /* (222) func ::= function_name NK_LP expression_list NK_RP */
  {  238,   -6 }, /* (223) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  238,   -7 }, /* (224) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  238,   -7 }, /* (225) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  238,   -4 }, /* (226) cmd ::= DROP TOPIC exists_opt topic_name */
  {  238,   -7 }, /* (227) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  238,   -2 }, /* (228) cmd ::= DESC full_table_name */
  {  238,   -2 }, /* (229) cmd ::= DESCRIBE full_table_name */
  {  238,   -3 }, /* (230) cmd ::= RESET QUERY CACHE */
  {  238,   -4 }, /* (231) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  298,    0 }, /* (232) analyze_opt ::= */
  {  298,   -1 }, /* (233) analyze_opt ::= ANALYZE */
  {  299,    0 }, /* (234) explain_options ::= */
  {  299,   -3 }, /* (235) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  299,   -3 }, /* (236) explain_options ::= explain_options RATIO NK_FLOAT */
  {  238,   -6 }, /* (237) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  238,  -10 }, /* (238) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  238,   -4 }, /* (239) cmd ::= DROP FUNCTION exists_opt function_name */
  {  300,    0 }, /* (240) agg_func_opt ::= */
  {  300,   -1 }, /* (241) agg_func_opt ::= AGGREGATE */
  {  301,    0 }, /* (242) bufsize_opt ::= */
  {  301,   -2 }, /* (243) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  238,   -8 }, /* (244) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  238,   -4 }, /* (245) cmd ::= DROP STREAM exists_opt stream_name */
  {  304,    0 }, /* (246) into_opt ::= */
  {  304,   -2 }, /* (247) into_opt ::= INTO full_table_name */
  {  303,    0 }, /* (248) stream_options ::= */
  {  303,   -3 }, /* (249) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  303,   -3 }, /* (250) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  303,   -3 }, /* (251) stream_options ::= stream_options WATERMARK duration_literal */
  {  238,   -3 }, /* (252) cmd ::= KILL CONNECTION NK_INTEGER */
  {  238,   -3 }, /* (253) cmd ::= KILL QUERY NK_INTEGER */
  {  238,   -3 }, /* (254) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  238,   -4 }, /* (255) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  238,   -4 }, /* (256) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  238,   -3 }, /* (257) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  305,   -2 }, /* (258) dnode_list ::= DNODE NK_INTEGER */
  {  305,   -3 }, /* (259) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  238,   -3 }, /* (260) cmd ::= SYNCDB db_name REPLICA */
  {  238,   -4 }, /* (261) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  238,   -1 }, /* (262) cmd ::= query_expression */
  {  241,   -1 }, /* (263) literal ::= NK_INTEGER */
  {  241,   -1 }, /* (264) literal ::= NK_FLOAT */
  {  241,   -1 }, /* (265) literal ::= NK_STRING */
  {  241,   -1 }, /* (266) literal ::= NK_BOOL */
  {  241,   -2 }, /* (267) literal ::= TIMESTAMP NK_STRING */
  {  241,   -1 }, /* (268) literal ::= duration_literal */
  {  241,   -1 }, /* (269) literal ::= NULL */
  {  241,   -1 }, /* (270) literal ::= NK_QUESTION */
  {  291,   -1 }, /* (271) duration_literal ::= NK_VARIABLE */
  {  307,   -1 }, /* (272) signed ::= NK_INTEGER */
  {  307,   -2 }, /* (273) signed ::= NK_PLUS NK_INTEGER */
  {  307,   -2 }, /* (274) signed ::= NK_MINUS NK_INTEGER */
  {  307,   -1 }, /* (275) signed ::= NK_FLOAT */
  {  307,   -2 }, /* (276) signed ::= NK_PLUS NK_FLOAT */
  {  307,   -2 }, /* (277) signed ::= NK_MINUS NK_FLOAT */
  {  271,   -1 }, /* (278) signed_literal ::= signed */
  {  271,   -1 }, /* (279) signed_literal ::= NK_STRING */
  {  271,   -1 }, /* (280) signed_literal ::= NK_BOOL */
  {  271,   -2 }, /* (281) signed_literal ::= TIMESTAMP NK_STRING */
  {  271,   -1 }, /* (282) signed_literal ::= duration_literal */
  {  271,   -1 }, /* (283) signed_literal ::= NULL */
  {  271,   -1 }, /* (284) signed_literal ::= literal_func */
  {  274,   -1 }, /* (285) literal_list ::= signed_literal */
  {  274,   -3 }, /* (286) literal_list ::= literal_list NK_COMMA signed_literal */
  {  248,   -1 }, /* (287) db_name ::= NK_ID */
  {  277,   -1 }, /* (288) table_name ::= NK_ID */
  {  269,   -1 }, /* (289) column_name ::= NK_ID */
  {  287,   -1 }, /* (290) function_name ::= NK_ID */
  {  309,   -1 }, /* (291) table_alias ::= NK_ID */
  {  310,   -1 }, /* (292) column_alias ::= NK_ID */
  {  243,   -1 }, /* (293) user_name ::= NK_ID */
  {  288,   -1 }, /* (294) index_name ::= NK_ID */
  {  295,   -1 }, /* (295) topic_name ::= NK_ID */
  {  302,   -1 }, /* (296) stream_name ::= NK_ID */
  {  297,   -1 }, /* (297) cgroup_name ::= NK_ID */
  {  311,   -1 }, /* (298) expression ::= literal */
  {  311,   -1 }, /* (299) expression ::= pseudo_column */
  {  311,   -1 }, /* (300) expression ::= column_reference */
  {  311,   -1 }, /* (301) expression ::= function_expression */
  {  311,   -1 }, /* (302) expression ::= subquery */
  {  311,   -3 }, /* (303) expression ::= NK_LP expression NK_RP */
  {  311,   -2 }, /* (304) expression ::= NK_PLUS expression */
  {  311,   -2 }, /* (305) expression ::= NK_MINUS expression */
  {  311,   -3 }, /* (306) expression ::= expression NK_PLUS expression */
  {  311,   -3 }, /* (307) expression ::= expression NK_MINUS expression */
  {  311,   -3 }, /* (308) expression ::= expression NK_STAR expression */
  {  311,   -3 }, /* (309) expression ::= expression NK_SLASH expression */
  {  311,   -3 }, /* (310) expression ::= expression NK_REM expression */
  {  311,   -3 }, /* (311) expression ::= column_reference NK_ARROW NK_STRING */
  {  294,   -1 }, /* (312) expression_list ::= expression */
  {  294,   -3 }, /* (313) expression_list ::= expression_list NK_COMMA expression */
  {  313,   -1 }, /* (314) column_reference ::= column_name */
  {  313,   -3 }, /* (315) column_reference ::= table_name NK_DOT column_name */
  {  312,   -1 }, /* (316) pseudo_column ::= ROWTS */
  {  312,   -1 }, /* (317) pseudo_column ::= TBNAME */
  {  312,   -3 }, /* (318) pseudo_column ::= table_name NK_DOT TBNAME */
  {  312,   -1 }, /* (319) pseudo_column ::= QSTARTTS */
  {  312,   -1 }, /* (320) pseudo_column ::= QENDTS */
  {  312,   -1 }, /* (321) pseudo_column ::= WSTARTTS */
  {  312,   -1 }, /* (322) pseudo_column ::= WENDTS */
  {  312,   -1 }, /* (323) pseudo_column ::= WDURATION */
  {  314,   -4 }, /* (324) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  314,   -4 }, /* (325) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  314,   -6 }, /* (326) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  314,   -1 }, /* (327) function_expression ::= literal_func */
  {  308,   -3 }, /* (328) literal_func ::= noarg_func NK_LP NK_RP */
  {  308,   -1 }, /* (329) literal_func ::= NOW */
  {  318,   -1 }, /* (330) noarg_func ::= NOW */
  {  318,   -1 }, /* (331) noarg_func ::= TODAY */
  {  318,   -1 }, /* (332) noarg_func ::= TIMEZONE */
  {  316,   -1 }, /* (333) star_func ::= COUNT */
  {  316,   -1 }, /* (334) star_func ::= FIRST */
  {  316,   -1 }, /* (335) star_func ::= LAST */
  {  316,   -1 }, /* (336) star_func ::= LAST_ROW */
  {  317,   -1 }, /* (337) star_func_para_list ::= NK_STAR */
  {  317,   -1 }, /* (338) star_func_para_list ::= other_para_list */
  {  319,   -1 }, /* (339) other_para_list ::= star_func_para */
  {  319,   -3 }, /* (340) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  320,   -1 }, /* (341) star_func_para ::= expression */
  {  320,   -3 }, /* (342) star_func_para ::= table_name NK_DOT NK_STAR */
  {  321,   -3 }, /* (343) predicate ::= expression compare_op expression */
  {  321,   -5 }, /* (344) predicate ::= expression BETWEEN expression AND expression */
  {  321,   -6 }, /* (345) predicate ::= expression NOT BETWEEN expression AND expression */
  {  321,   -3 }, /* (346) predicate ::= expression IS NULL */
  {  321,   -4 }, /* (347) predicate ::= expression IS NOT NULL */
  {  321,   -3 }, /* (348) predicate ::= expression in_op in_predicate_value */
  {  322,   -1 }, /* (349) compare_op ::= NK_LT */
  {  322,   -1 }, /* (350) compare_op ::= NK_GT */
  {  322,   -1 }, /* (351) compare_op ::= NK_LE */
  {  322,   -1 }, /* (352) compare_op ::= NK_GE */
  {  322,   -1 }, /* (353) compare_op ::= NK_NE */
  {  322,   -1 }, /* (354) compare_op ::= NK_EQ */
  {  322,   -1 }, /* (355) compare_op ::= LIKE */
  {  322,   -2 }, /* (356) compare_op ::= NOT LIKE */
  {  322,   -1 }, /* (357) compare_op ::= MATCH */
  {  322,   -1 }, /* (358) compare_op ::= NMATCH */
  {  322,   -1 }, /* (359) compare_op ::= CONTAINS */
  {  323,   -1 }, /* (360) in_op ::= IN */
  {  323,   -2 }, /* (361) in_op ::= NOT IN */
  {  324,   -3 }, /* (362) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  325,   -1 }, /* (363) boolean_value_expression ::= boolean_primary */
  {  325,   -2 }, /* (364) boolean_value_expression ::= NOT boolean_primary */
  {  325,   -3 }, /* (365) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  325,   -3 }, /* (366) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  326,   -1 }, /* (367) boolean_primary ::= predicate */
  {  326,   -3 }, /* (368) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  327,   -1 }, /* (369) common_expression ::= expression */
  {  327,   -1 }, /* (370) common_expression ::= boolean_value_expression */
  {  328,   -2 }, /* (371) from_clause ::= FROM table_reference_list */
  {  329,   -1 }, /* (372) table_reference_list ::= table_reference */
  {  329,   -3 }, /* (373) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  330,   -1 }, /* (374) table_reference ::= table_primary */
  {  330,   -1 }, /* (375) table_reference ::= joined_table */
  {  331,   -2 }, /* (376) table_primary ::= table_name alias_opt */
  {  331,   -4 }, /* (377) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  331,   -2 }, /* (378) table_primary ::= subquery alias_opt */
  {  331,   -1 }, /* (379) table_primary ::= parenthesized_joined_table */
  {  333,    0 }, /* (380) alias_opt ::= */
  {  333,   -1 }, /* (381) alias_opt ::= table_alias */
  {  333,   -2 }, /* (382) alias_opt ::= AS table_alias */
  {  334,   -3 }, /* (383) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  334,   -3 }, /* (384) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  332,   -6 }, /* (385) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  335,    0 }, /* (386) join_type ::= */
  {  335,   -1 }, /* (387) join_type ::= INNER */
  {  337,   -9 }, /* (388) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  338,    0 }, /* (389) set_quantifier_opt ::= */
  {  338,   -1 }, /* (390) set_quantifier_opt ::= DISTINCT */
  {  338,   -1 }, /* (391) set_quantifier_opt ::= ALL */
  {  339,   -1 }, /* (392) select_list ::= NK_STAR */
  {  339,   -1 }, /* (393) select_list ::= select_sublist */
  {  344,   -1 }, /* (394) select_sublist ::= select_item */
  {  344,   -3 }, /* (395) select_sublist ::= select_sublist NK_COMMA select_item */
  {  345,   -1 }, /* (396) select_item ::= common_expression */
  {  345,   -2 }, /* (397) select_item ::= common_expression column_alias */
  {  345,   -3 }, /* (398) select_item ::= common_expression AS column_alias */
  {  345,   -3 }, /* (399) select_item ::= table_name NK_DOT NK_STAR */
  {  306,    0 }, /* (400) where_clause_opt ::= */
  {  306,   -2 }, /* (401) where_clause_opt ::= WHERE search_condition */
  {  340,    0 }, /* (402) partition_by_clause_opt ::= */
  {  340,   -3 }, /* (403) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  341,    0 }, /* (404) twindow_clause_opt ::= */
  {  341,   -6 }, /* (405) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  341,   -4 }, /* (406) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  341,   -6 }, /* (407) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  341,   -8 }, /* (408) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  292,    0 }, /* (409) sliding_opt ::= */
  {  292,   -4 }, /* (410) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  346,    0 }, /* (411) fill_opt ::= */
  {  346,   -4 }, /* (412) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  346,   -6 }, /* (413) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  347,   -1 }, /* (414) fill_mode ::= NONE */
  {  347,   -1 }, /* (415) fill_mode ::= PREV */
  {  347,   -1 }, /* (416) fill_mode ::= NULL */
  {  347,   -1 }, /* (417) fill_mode ::= LINEAR */
  {  347,   -1 }, /* (418) fill_mode ::= NEXT */
  {  342,    0 }, /* (419) group_by_clause_opt ::= */
  {  342,   -3 }, /* (420) group_by_clause_opt ::= GROUP BY group_by_list */
  {  348,   -1 }, /* (421) group_by_list ::= expression */
  {  348,   -3 }, /* (422) group_by_list ::= group_by_list NK_COMMA expression */
  {  343,    0 }, /* (423) having_clause_opt ::= */
  {  343,   -2 }, /* (424) having_clause_opt ::= HAVING search_condition */
  {  296,   -4 }, /* (425) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  349,   -1 }, /* (426) query_expression_body ::= query_primary */
  {  349,   -4 }, /* (427) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  349,   -3 }, /* (428) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  353,   -1 }, /* (429) query_primary ::= query_specification */
  {  353,   -6 }, /* (430) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  350,    0 }, /* (431) order_by_clause_opt ::= */
  {  350,   -3 }, /* (432) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  351,    0 }, /* (433) slimit_clause_opt ::= */
  {  351,   -2 }, /* (434) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  351,   -4 }, /* (435) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  351,   -4 }, /* (436) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  352,    0 }, /* (437) limit_clause_opt ::= */
  {  352,   -2 }, /* (438) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  352,   -4 }, /* (439) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  352,   -4 }, /* (440) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  315,   -3 }, /* (441) subquery ::= NK_LP query_expression NK_RP */
  {  336,   -1 }, /* (442) search_condition ::= common_expression */
  {  354,   -1 }, /* (443) sort_specification_list ::= sort_specification */
  {  354,   -3 }, /* (444) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  355,   -3 }, /* (445) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  356,    0 }, /* (446) ordering_specification_opt ::= */
  {  356,   -1 }, /* (447) ordering_specification_opt ::= ASC */
  {  356,   -1 }, /* (448) ordering_specification_opt ::= DESC */
  {  357,    0 }, /* (449) null_ordering_opt ::= */
  {  357,   -2 }, /* (450) null_ordering_opt ::= NULLS FIRST */
  {  357,   -2 }, /* (451) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,239,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,240,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,239,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,241,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,242,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,240,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,242,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,241,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy105, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy105, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy105); }
        break;
      case 28: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy593, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy105); }
        break;
      case 29: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy593, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy105); }
        break;
      case 30: /* privileges ::= ALL */
{ yymsp[0].minor.yy593 = PRIVILEGE_TYPE_ALL; }
        break;
      case 31: /* privileges ::= priv_type_list */
      case 32: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==32);
{ yylhsminor.yy593 = yymsp[0].minor.yy593; }
  yymsp[0].minor.yy593 = yylhsminor.yy593;
        break;
      case 33: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy593 = yymsp[-2].minor.yy593 | yymsp[0].minor.yy593; }
  yymsp[-2].minor.yy593 = yylhsminor.yy593;
        break;
      case 34: /* priv_type ::= READ */
{ yymsp[0].minor.yy593 = PRIVILEGE_TYPE_READ; }
        break;
      case 35: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy593 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 36: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy105 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy105 = yylhsminor.yy105;
        break;
      case 37: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy105 = yymsp[-2].minor.yy105; }
  yymsp[-2].minor.yy105 = yylhsminor.yy105;
        break;
      case 38: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy105, NULL); }
        break;
      case 39: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy0); }
        break;
      case 40: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy105); }
        break;
      case 42: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 43: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 45: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 46: /* dnode_endpoint ::= NK_STRING */
      case 47: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==47);
      case 48: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==48);
      case 287: /* db_name ::= NK_ID */ yytestcase(yyruleno==287);
      case 288: /* table_name ::= NK_ID */ yytestcase(yyruleno==288);
      case 289: /* column_name ::= NK_ID */ yytestcase(yyruleno==289);
      case 290: /* function_name ::= NK_ID */ yytestcase(yyruleno==290);
      case 291: /* table_alias ::= NK_ID */ yytestcase(yyruleno==291);
      case 292: /* column_alias ::= NK_ID */ yytestcase(yyruleno==292);
      case 293: /* user_name ::= NK_ID */ yytestcase(yyruleno==293);
      case 294: /* index_name ::= NK_ID */ yytestcase(yyruleno==294);
      case 295: /* topic_name ::= NK_ID */ yytestcase(yyruleno==295);
      case 296: /* stream_name ::= NK_ID */ yytestcase(yyruleno==296);
      case 297: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==297);
      case 330: /* noarg_func ::= NOW */ yytestcase(yyruleno==330);
      case 331: /* noarg_func ::= TODAY */ yytestcase(yyruleno==331);
      case 332: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==332);
      case 333: /* star_func ::= COUNT */ yytestcase(yyruleno==333);
      case 334: /* star_func ::= FIRST */ yytestcase(yyruleno==334);
      case 335: /* star_func ::= LAST */ yytestcase(yyruleno==335);
      case 336: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==336);
{ yylhsminor.yy105 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy105 = yylhsminor.yy105;
        break;
      case 49: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 52: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 53: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy617, &yymsp[-1].minor.yy105, yymsp[0].minor.yy172); }
        break;
      case 60: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy617, &yymsp[0].minor.yy105); }
        break;
      case 61: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy105); }
        break;
      case 62: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy105, yymsp[0].minor.yy172); }
        break;
      case 63: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy617 = true; }
        break;
      case 64: /* not_exists_opt ::= */
      case 66: /* exists_opt ::= */ yytestcase(yyruleno==66);
      case 232: /* analyze_opt ::= */ yytestcase(yyruleno==232);
      case 240: /* agg_func_opt ::= */ yytestcase(yyruleno==240);
      case 389: /* set_quantifier_opt ::= */ yytestcase(yyruleno==389);
{ yymsp[1].minor.yy617 = false; }
        break;
      case 65: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy617 = true; }
        break;
      case 67: /* db_options ::= */
{ yymsp[1].minor.yy172 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 68: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 69: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 70: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 71: /* db_options ::= db_options DAYS NK_INTEGER */
      case 72: /* db_options ::= db_options DAYS NK_VARIABLE */ yytestcase(yyruleno==72);
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 73: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 74: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 75: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 76: /* db_options ::= db_options KEEP integer_list */
      case 77: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==77);
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_KEEP, yymsp[0].minor.yy60); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 78: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 79: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 80: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 81: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 82: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 83: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 84: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 85: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 86: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_RETENTIONS, yymsp[0].minor.yy60); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 87: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy172 = setDatabaseOption(pCxt, yymsp[-2].minor.yy172, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 88: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy172 = createAlterDatabaseOptions(pCxt); yylhsminor.yy172 = setAlterDatabaseOption(pCxt, yylhsminor.yy172, &yymsp[0].minor.yy609); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 89: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy172 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy172, &yymsp[0].minor.yy609); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 90: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy609.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 91: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy609.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 92: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy609.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 93: /* alter_db_option ::= KEEP integer_list */
      case 94: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==94);
{ yymsp[-1].minor.yy609.type = DB_OPTION_KEEP; yymsp[-1].minor.yy609.pList = yymsp[0].minor.yy60; }
        break;
      case 95: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy609.type = DB_OPTION_PAGES; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 96: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy609.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 97: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy609.type = DB_OPTION_STRICT; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 98: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy609.type = DB_OPTION_WAL; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 99: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy60 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy60 = yylhsminor.yy60;
        break;
      case 100: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 259: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==259);
{ yylhsminor.yy60 = addNodeToList(pCxt, yymsp[-2].minor.yy60, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy60 = yylhsminor.yy60;
        break;
      case 101: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy60 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy60 = yylhsminor.yy60;
        break;
      case 102: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy60 = addNodeToList(pCxt, yymsp[-2].minor.yy60, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy60 = yylhsminor.yy60;
        break;
      case 103: /* retention_list ::= retention */
      case 123: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==123);
      case 126: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==126);
      case 133: /* column_def_list ::= column_def */ yytestcase(yyruleno==133);
      case 173: /* col_name_list ::= col_name */ yytestcase(yyruleno==173);
      case 211: /* func_name_list ::= func_name */ yytestcase(yyruleno==211);
      case 220: /* func_list ::= func */ yytestcase(yyruleno==220);
      case 285: /* literal_list ::= signed_literal */ yytestcase(yyruleno==285);
      case 339: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==339);
      case 394: /* select_sublist ::= select_item */ yytestcase(yyruleno==394);
      case 443: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==443);
{ yylhsminor.yy60 = createNodeList(pCxt, yymsp[0].minor.yy172); }
  yymsp[0].minor.yy60 = yylhsminor.yy60;
        break;
      case 104: /* retention_list ::= retention_list NK_COMMA retention */
      case 134: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==134);
      case 174: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==174);
      case 212: /* func_name_list ::= func_name_list NK_COMMA func_name */ yytestcase(yyruleno==212);
      case 221: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==221);
      case 286: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==286);
      case 340: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==340);
      case 395: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==395);
      case 444: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==444);
{ yylhsminor.yy60 = addNodeToList(pCxt, yymsp[-2].minor.yy60, yymsp[0].minor.yy172); }
  yymsp[-2].minor.yy60 = yylhsminor.yy60;
        break;
      case 105: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy172 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 106: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 108: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==108);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy617, yymsp[-5].minor.yy172, yymsp[-3].minor.yy60, yymsp[-1].minor.yy60, yymsp[0].minor.yy172); }
        break;
      case 107: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy60); }
        break;
      case 109: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy60); }
        break;
      case 110: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy617, yymsp[0].minor.yy172); }
        break;
      case 111: /* cmd ::= ALTER TABLE alter_table_clause */
      case 112: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==112);
      case 262: /* cmd ::= query_expression */ yytestcase(yyruleno==262);
{ pCxt->pRootNode = yymsp[0].minor.yy172; }
        break;
      case 113: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy172 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy172, yymsp[0].minor.yy172); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 114: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy172 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy172, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy105, yymsp[0].minor.yy248); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 115: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy172 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy172, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy105); }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 116: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy172 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy172, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy105, yymsp[0].minor.yy248); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 117: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy172 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy172, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy105, &yymsp[0].minor.yy105); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 118: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy172 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy172, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy105, yymsp[0].minor.yy248); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 119: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy172 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy172, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy105); }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 120: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy172 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy172, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy105, yymsp[0].minor.yy248); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 121: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy172 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy172, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy105, &yymsp[0].minor.yy105); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 122: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy172 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy172, &yymsp[-2].minor.yy105, yymsp[0].minor.yy172); }
  yymsp[-5].minor.yy172 = yylhsminor.yy172;
        break;
      case 124: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 127: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==127);
{ yylhsminor.yy60 = addNodeToList(pCxt, yymsp[-1].minor.yy60, yymsp[0].minor.yy172); }
  yymsp[-1].minor.yy60 = yylhsminor.yy60;
        break;
      case 125: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
{ yylhsminor.yy172 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy617, yymsp[-8].minor.yy172, yymsp[-6].minor.yy172, yymsp[-5].minor.yy60, yymsp[-2].minor.yy60, yymsp[0].minor.yy172); }
  yymsp[-9].minor.yy172 = yylhsminor.yy172;
        break;
      case 128: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy172 = createDropTableClause(pCxt, yymsp[-1].minor.yy617, yymsp[0].minor.yy172); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 129: /* specific_tags_opt ::= */
      case 160: /* tags_def_opt ::= */ yytestcase(yyruleno==160);
      case 402: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==402);
      case 419: /* group_by_clause_opt ::= */ yytestcase(yyruleno==419);
      case 431: /* order_by_clause_opt ::= */ yytestcase(yyruleno==431);
{ yymsp[1].minor.yy60 = NULL; }
        break;
      case 130: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy60 = yymsp[-1].minor.yy60; }
        break;
      case 131: /* full_table_name ::= table_name */
{ yylhsminor.yy172 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy105, NULL); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 132: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy172 = createRealTableNode(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy105, NULL); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 135: /* column_def ::= column_name type_name */
{ yylhsminor.yy172 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy105, yymsp[0].minor.yy248, NULL); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 136: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy172 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy105, yymsp[-2].minor.yy248, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 137: /* type_name ::= BOOL */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 138: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 139: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 140: /* type_name ::= INT */
      case 141: /* type_name ::= INTEGER */ yytestcase(yyruleno==141);
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 142: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 143: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 144: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 145: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy248 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 146: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 147: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy248 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 148: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy248 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 149: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy248 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 150: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy248 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 151: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy248 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 152: /* type_name ::= JSON */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 153: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy248 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 154: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 155: /* type_name ::= BLOB */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 156: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy248 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy248 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 158: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy248 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 159: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy248 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 161: /* tags_def_opt ::= tags_def */
      case 338: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==338);
      case 393: /* select_list ::= select_sublist */ yytestcase(yyruleno==393);
{ yylhsminor.yy60 = yymsp[0].minor.yy60; }
  yymsp[0].minor.yy60 = yylhsminor.yy60;
        break;
      case 162: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy60 = yymsp[-1].minor.yy60; }
        break;
      case 163: /* table_options ::= */
{ yymsp[1].minor.yy172 = createDefaultTableOptions(pCxt); }
        break;
      case 164: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy172 = setTableOption(pCxt, yymsp[-2].minor.yy172, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 165: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ yylhsminor.yy172 = setTableOption(pCxt, yymsp[-2].minor.yy172, TABLE_OPTION_FILE_FACTOR, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 166: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ yylhsminor.yy172 = setTableOption(pCxt, yymsp[-4].minor.yy172, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy60); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 167: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy172 = setTableOption(pCxt, yymsp[-2].minor.yy172, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 168: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy172 = setTableOption(pCxt, yymsp[-4].minor.yy172, TABLE_OPTION_SMA, yymsp[-1].minor.yy60); }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 169: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy172 = createAlterTableOptions(pCxt); yylhsminor.yy172 = setTableOption(pCxt, yylhsminor.yy172, yymsp[0].minor.yy609.type, &yymsp[0].minor.yy609.val); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 170: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy172 = setTableOption(pCxt, yymsp[-1].minor.yy172, yymsp[0].minor.yy609.type, &yymsp[0].minor.yy609.val); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 171: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy609.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 172: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy609.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy609.val = yymsp[0].minor.yy0; }
        break;
      case 175: /* col_name ::= column_name */
{ yylhsminor.yy172 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy105); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 176: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 177: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 178: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 179: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 180: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 181: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy172, NULL); }
        break;
      case 182: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 183: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 184: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 185: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 186: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 187: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 188: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 189: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 190: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 191: /* cmd ::= SHOW LICENCE */
      case 192: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==192);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 193: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy105); }
        break;
      case 194: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy172); }
        break;
      case 195: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy172); }
        break;
      case 196: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 197: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 198: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 199: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 200: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT, NULL, NULL); }
        break;
      case 201: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT, NULL, NULL); }
        break;
      case 202: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT, NULL, NULL); }
        break;
      case 203: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT, NULL, NULL); }
        break;
      case 204: /* db_name_cond_opt ::= */
      case 209: /* from_db_opt ::= */ yytestcase(yyruleno==209);
{ yymsp[1].minor.yy172 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 205: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy105); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 206: /* like_pattern_opt ::= */
      case 217: /* index_options ::= */ yytestcase(yyruleno==217);
      case 246: /* into_opt ::= */ yytestcase(yyruleno==246);
      case 400: /* where_clause_opt ::= */ yytestcase(yyruleno==400);
      case 404: /* twindow_clause_opt ::= */ yytestcase(yyruleno==404);
      case 409: /* sliding_opt ::= */ yytestcase(yyruleno==409);
      case 411: /* fill_opt ::= */ yytestcase(yyruleno==411);
      case 423: /* having_clause_opt ::= */ yytestcase(yyruleno==423);
      case 433: /* slimit_clause_opt ::= */ yytestcase(yyruleno==433);
      case 437: /* limit_clause_opt ::= */ yytestcase(yyruleno==437);
{ yymsp[1].minor.yy172 = NULL; }
        break;
      case 207: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 208: /* table_name_cond ::= table_name */
{ yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy105); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 210: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy105); }
        break;
      case 213: /* func_name ::= function_name */
{ yylhsminor.yy172 = createFunctionNode(pCxt, &yymsp[0].minor.yy105, NULL); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 214: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy617, &yymsp[-3].minor.yy105, &yymsp[-1].minor.yy105, NULL, yymsp[0].minor.yy172); }
        break;
      case 215: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy617, &yymsp[-5].minor.yy105, &yymsp[-3].minor.yy105, yymsp[-1].minor.yy60, NULL); }
        break;
      case 216: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy617, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy105); }
        break;
      case 218: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy172 = createIndexOption(pCxt, yymsp[-6].minor.yy60, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), NULL, yymsp[0].minor.yy172); }
        break;
      case 219: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy172 = createIndexOption(pCxt, yymsp[-8].minor.yy60, releaseRawExprNode(pCxt, yymsp[-4].minor.yy172), releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), yymsp[0].minor.yy172); }
        break;
      case 222: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy172 = createFunctionNode(pCxt, &yymsp[-3].minor.yy105, yymsp[-1].minor.yy60); }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 223: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy617, &yymsp[-2].minor.yy105, yymsp[0].minor.yy172, NULL, NULL); }
        break;
      case 224: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy617, &yymsp[-3].minor.yy105, NULL, &yymsp[0].minor.yy105, NULL); }
        break;
      case 225: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy617, &yymsp[-3].minor.yy105, NULL, NULL, yymsp[0].minor.yy172); }
        break;
      case 226: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy617, &yymsp[0].minor.yy105); }
        break;
      case 227: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy617, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy105); }
        break;
      case 228: /* cmd ::= DESC full_table_name */
      case 229: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==229);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy172); }
        break;
      case 230: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 231: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy617, yymsp[-1].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 233: /* analyze_opt ::= ANALYZE */
      case 241: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==241);
      case 390: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==390);
{ yymsp[0].minor.yy617 = true; }
        break;
      case 234: /* explain_options ::= */
{ yymsp[1].minor.yy172 = createDefaultExplainOptions(pCxt); }
        break;
      case 235: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy172 = setExplainVerbose(pCxt, yymsp[-2].minor.yy172, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 236: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy172 = setExplainRatio(pCxt, yymsp[-2].minor.yy172, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 237: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy60); }
        break;
      case 238: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy617, yymsp[-8].minor.yy617, &yymsp[-5].minor.yy105, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy248, yymsp[0].minor.yy140); }
        break;
      case 239: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy617, &yymsp[0].minor.yy105); }
        break;
      case 242: /* bufsize_opt ::= */
{ yymsp[1].minor.yy140 = 0; }
        break;
      case 243: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy140 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 244: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy617, &yymsp[-4].minor.yy105, yymsp[-2].minor.yy172, yymsp[-3].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 245: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy617, &yymsp[0].minor.yy105); }
        break;
      case 247: /* into_opt ::= INTO full_table_name */
      case 371: /* from_clause ::= FROM table_reference_list */ yytestcase(yyruleno==371);
      case 401: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==401);
      case 424: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==424);
{ yymsp[-1].minor.yy172 = yymsp[0].minor.yy172; }
        break;
      case 248: /* stream_options ::= */
{ yymsp[1].minor.yy172 = createStreamOptions(pCxt); }
        break;
      case 249: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy172)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy172 = yymsp[-2].minor.yy172; }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 250: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy172)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy172 = yymsp[-2].minor.yy172; }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 251: /* stream_options ::= stream_options WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy172)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy172); yylhsminor.yy172 = yymsp[-2].minor.yy172; }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 252: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 253: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 254: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 255: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 256: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy60); }
        break;
      case 257: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 258: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy60 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 260: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy105); }
        break;
      case 261: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 263: /* literal ::= NK_INTEGER */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 264: /* literal ::= NK_FLOAT */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 265: /* literal ::= NK_STRING */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 266: /* literal ::= NK_BOOL */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 267: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 268: /* literal ::= duration_literal */
      case 278: /* signed_literal ::= signed */ yytestcase(yyruleno==278);
      case 298: /* expression ::= literal */ yytestcase(yyruleno==298);
      case 299: /* expression ::= pseudo_column */ yytestcase(yyruleno==299);
      case 300: /* expression ::= column_reference */ yytestcase(yyruleno==300);
      case 301: /* expression ::= function_expression */ yytestcase(yyruleno==301);
      case 302: /* expression ::= subquery */ yytestcase(yyruleno==302);
      case 327: /* function_expression ::= literal_func */ yytestcase(yyruleno==327);
      case 363: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==363);
      case 367: /* boolean_primary ::= predicate */ yytestcase(yyruleno==367);
      case 369: /* common_expression ::= expression */ yytestcase(yyruleno==369);
      case 370: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==370);
      case 372: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==372);
      case 374: /* table_reference ::= table_primary */ yytestcase(yyruleno==374);
      case 375: /* table_reference ::= joined_table */ yytestcase(yyruleno==375);
      case 379: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==379);
      case 426: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==426);
      case 429: /* query_primary ::= query_specification */ yytestcase(yyruleno==429);
{ yylhsminor.yy172 = yymsp[0].minor.yy172; }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 269: /* literal ::= NULL */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 270: /* literal ::= NK_QUESTION */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 271: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 272: /* signed ::= NK_INTEGER */
{ yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 273: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 274: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 275: /* signed ::= NK_FLOAT */
{ yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 276: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 277: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 279: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 280: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 281: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 282: /* signed_literal ::= duration_literal */
      case 284: /* signed_literal ::= literal_func */ yytestcase(yyruleno==284);
      case 341: /* star_func_para ::= expression */ yytestcase(yyruleno==341);
      case 396: /* select_item ::= common_expression */ yytestcase(yyruleno==396);
      case 442: /* search_condition ::= common_expression */ yytestcase(yyruleno==442);
{ yylhsminor.yy172 = releaseRawExprNode(pCxt, yymsp[0].minor.yy172); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 283: /* signed_literal ::= NULL */
{ yylhsminor.yy172 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 303: /* expression ::= NK_LP expression NK_RP */
      case 368: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==368);
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy172)); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 304: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy172));
                                                                                  }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 305: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy172), NULL));
                                                                                  }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 306: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172))); 
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 307: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172))); 
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 308: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172))); 
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 309: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172))); 
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 310: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172)));
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 311: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 312: /* expression_list ::= expression */
{ yylhsminor.yy60 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy172)); }
  yymsp[0].minor.yy60 = yylhsminor.yy60;
        break;
      case 313: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy60 = addNodeToList(pCxt, yymsp[-2].minor.yy60, releaseRawExprNode(pCxt, yymsp[0].minor.yy172)); }
  yymsp[-2].minor.yy60 = yylhsminor.yy60;
        break;
      case 314: /* column_reference ::= column_name */
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy105, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy105)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 315: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy105, createColumnNode(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy105)); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 316: /* pseudo_column ::= ROWTS */
      case 317: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==317);
      case 319: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==319);
      case 320: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==320);
      case 321: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==321);
      case 322: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==322);
      case 323: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==323);
      case 329: /* literal_func ::= NOW */ yytestcase(yyruleno==329);
{ yylhsminor.yy172 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy172 = yylhsminor.yy172;
        break;
      case 318: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy105)))); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 324: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 325: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==325);
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy105, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy105, yymsp[-1].minor.yy60)); }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 326: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy172), yymsp[-1].minor.yy248)); }
  yymsp[-5].minor.yy172 = yylhsminor.yy172;
        break;
      case 328: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy105, NULL)); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 337: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy60 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy60 = yylhsminor.yy60;
        break;
      case 342: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 399: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==399);
{ yylhsminor.yy172 = createColumnNode(pCxt, &yymsp[-2].minor.yy105, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 343: /* predicate ::= expression compare_op expression */
      case 348: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==348);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy572, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172)));
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 344: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy172), releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172)));
                                                                                  }
  yymsp[-4].minor.yy172 = yylhsminor.yy172;
        break;
      case 345: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy172), releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172)));
                                                                                  }
  yymsp[-5].minor.yy172 = yylhsminor.yy172;
        break;
      case 346: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), NULL));
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 347: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy172), NULL));
                                                                                  }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 349: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy572 = OP_TYPE_LOWER_THAN; }
        break;
      case 350: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy572 = OP_TYPE_GREATER_THAN; }
        break;
      case 351: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy572 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 352: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy572 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 353: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy572 = OP_TYPE_NOT_EQUAL; }
        break;
      case 354: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy572 = OP_TYPE_EQUAL; }
        break;
      case 355: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy572 = OP_TYPE_LIKE; }
        break;
      case 356: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy572 = OP_TYPE_NOT_LIKE; }
        break;
      case 357: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy572 = OP_TYPE_MATCH; }
        break;
      case 358: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy572 = OP_TYPE_NMATCH; }
        break;
      case 359: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy572 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 360: /* in_op ::= IN */
{ yymsp[0].minor.yy572 = OP_TYPE_IN; }
        break;
      case 361: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy572 = OP_TYPE_NOT_IN; }
        break;
      case 362: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy60)); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 364: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy172), NULL));
                                                                                  }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 365: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172)));
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 366: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy172);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy172);
                                                                                    yylhsminor.yy172 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), releaseRawExprNode(pCxt, yymsp[0].minor.yy172)));
                                                                                  }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 373: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy172 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy172, yymsp[0].minor.yy172, NULL); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 376: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy172 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy105, &yymsp[0].minor.yy105); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 377: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy172 = createRealTableNode(pCxt, &yymsp[-3].minor.yy105, &yymsp[-1].minor.yy105, &yymsp[0].minor.yy105); }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 378: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy172 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy172), &yymsp[0].minor.yy105); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 380: /* alias_opt ::= */
{ yymsp[1].minor.yy105 = nil_token;  }
        break;
      case 381: /* alias_opt ::= table_alias */
{ yylhsminor.yy105 = yymsp[0].minor.yy105; }
  yymsp[0].minor.yy105 = yylhsminor.yy105;
        break;
      case 382: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy105 = yymsp[0].minor.yy105; }
        break;
      case 383: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 384: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==384);
{ yymsp[-2].minor.yy172 = yymsp[-1].minor.yy172; }
        break;
      case 385: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy172 = createJoinTableNode(pCxt, yymsp[-4].minor.yy636, yymsp[-5].minor.yy172, yymsp[-2].minor.yy172, yymsp[0].minor.yy172); }
  yymsp[-5].minor.yy172 = yylhsminor.yy172;
        break;
      case 386: /* join_type ::= */
{ yymsp[1].minor.yy636 = JOIN_TYPE_INNER; }
        break;
      case 387: /* join_type ::= INNER */
{ yymsp[0].minor.yy636 = JOIN_TYPE_INNER; }
        break;
      case 388: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy172 = createSelectStmt(pCxt, yymsp[-7].minor.yy617, yymsp[-6].minor.yy60, yymsp[-5].minor.yy172);
                                                                                    yymsp[-8].minor.yy172 = addWhereClause(pCxt, yymsp[-8].minor.yy172, yymsp[-4].minor.yy172);
                                                                                    yymsp[-8].minor.yy172 = addPartitionByClause(pCxt, yymsp[-8].minor.yy172, yymsp[-3].minor.yy60);
                                                                                    yymsp[-8].minor.yy172 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy172, yymsp[-2].minor.yy172);
                                                                                    yymsp[-8].minor.yy172 = addGroupByClause(pCxt, yymsp[-8].minor.yy172, yymsp[-1].minor.yy60);
                                                                                    yymsp[-8].minor.yy172 = addHavingClause(pCxt, yymsp[-8].minor.yy172, yymsp[0].minor.yy172);
                                                                                  }
        break;
      case 391: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy617 = false; }
        break;
      case 392: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy60 = NULL; }
        break;
      case 397: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy172 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy172), &yymsp[0].minor.yy105); }
  yymsp[-1].minor.yy172 = yylhsminor.yy172;
        break;
      case 398: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy172 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), &yymsp[0].minor.yy105); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 403: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 420: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==420);
      case 432: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==432);
{ yymsp[-2].minor.yy60 = yymsp[0].minor.yy60; }
        break;
      case 405: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy172 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy172), releaseRawExprNode(pCxt, yymsp[-1].minor.yy172)); }
        break;
      case 406: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy172 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy172)); }
        break;
      case 407: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy172 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy172), NULL, yymsp[-1].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 408: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy172 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy172), releaseRawExprNode(pCxt, yymsp[-3].minor.yy172), yymsp[-1].minor.yy172, yymsp[0].minor.yy172); }
        break;
      case 410: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy172 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy172); }
        break;
      case 412: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy172 = createFillNode(pCxt, yymsp[-1].minor.yy202, NULL); }
        break;
      case 413: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy172 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy60)); }
        break;
      case 414: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy202 = FILL_MODE_NONE; }
        break;
      case 415: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy202 = FILL_MODE_PREV; }
        break;
      case 416: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy202 = FILL_MODE_NULL; }
        break;
      case 417: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy202 = FILL_MODE_LINEAR; }
        break;
      case 418: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy202 = FILL_MODE_NEXT; }
        break;
      case 421: /* group_by_list ::= expression */
{ yylhsminor.yy60 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy172))); }
  yymsp[0].minor.yy60 = yylhsminor.yy60;
        break;
      case 422: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy60 = addNodeToList(pCxt, yymsp[-2].minor.yy60, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy172))); }
  yymsp[-2].minor.yy60 = yylhsminor.yy60;
        break;
      case 425: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy172 = addOrderByClause(pCxt, yymsp[-3].minor.yy172, yymsp[-2].minor.yy60);
                                                                                    yylhsminor.yy172 = addSlimitClause(pCxt, yylhsminor.yy172, yymsp[-1].minor.yy172);
                                                                                    yylhsminor.yy172 = addLimitClause(pCxt, yylhsminor.yy172, yymsp[0].minor.yy172);
                                                                                  }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 427: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy172 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy172, yymsp[0].minor.yy172); }
  yymsp[-3].minor.yy172 = yylhsminor.yy172;
        break;
      case 428: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy172 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy172, yymsp[0].minor.yy172); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 430: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ yymsp[-5].minor.yy172 = yymsp[-4].minor.yy172; }
  yy_destructor(yypParser,350,&yymsp[-3].minor);
  yy_destructor(yypParser,351,&yymsp[-2].minor);
  yy_destructor(yypParser,352,&yymsp[-1].minor);
        break;
      case 434: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 438: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==438);
{ yymsp[-1].minor.yy172 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 435: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 439: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==439);
{ yymsp[-3].minor.yy172 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 436: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 440: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==440);
{ yymsp[-3].minor.yy172 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 441: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy172 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy172); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 445: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy172 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy172), yymsp[-1].minor.yy14, yymsp[0].minor.yy17); }
  yymsp[-2].minor.yy172 = yylhsminor.yy172;
        break;
      case 446: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy14 = ORDER_ASC; }
        break;
      case 447: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy14 = ORDER_ASC; }
        break;
      case 448: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy14 = ORDER_DESC; }
        break;
      case 449: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy17 = NULL_ORDER_DEFAULT; }
        break;
      case 450: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy17 = NULL_ORDER_FIRST; }
        break;
      case 451: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy17 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
