/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 476
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EFillMode yy46;
  SAlterOption yy53;
  SToken yy113;
  EOperatorType yy156;
  bool yy369;
  SNodeList* yy432;
  SNode* yy448;
  int8_t yy551;
  ENullOrder yy585;
  EJoinType yy596;
  EOrder yy666;
  SDataType yy728;
  STokenPair yy777;
  int32_t yy788;
  int64_t yy837;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             762
#define YYNRULE              583
#define YYNRULE_WITH_ACTION  583
#define YYNTOKEN             330
#define YY_MAX_SHIFT         761
#define YY_MIN_SHIFTREDUCE   1136
#define YY_MAX_SHIFTREDUCE   1718
#define YY_ERROR_ACTION      1719
#define YY_ACCEPT_ACTION     1720
#define YY_NO_ACTION         1721
#define YY_MIN_REDUCE        1722
#define YY_MAX_REDUCE        2304
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2904)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  2116, 2010, 1881,  396,  434,  168,  636, 1734,  433, 1989,
 /*    10 */   672,  162,   46,   44, 1646, 1723, 2008,  642,  374, 1894,
 /*    20 */   393,  506, 1495,  440,   39,   38, 1942,  503,   45,   43,
 /*    30 */    42,   41,   40, 1576, 1791, 1493,  123, 2134, 1520,  122,
 /*    40 */   121,  120,  119,  118,  117,  116,  115,  114, 2279, 2084,
 /*    50 */   593,  671,  593, 2275,  194, 2275,   39,   38,  167, 1571,
 /*    60 */    45,   43,   42,   41,   40,   19, 1833,  340, 2281,  186,
 /*    70 */  2281,  186, 1501, 2276,  619, 2276,  619,   45,   43,   42,
 /*    80 */    41,   40, 2115,  501,  654, 2151,  502, 1758,  169, 2117,
 /*    90 */   675, 2119, 2120,  670,  182,  665, 1520,  758,   36,  298,
 /*   100 */    15,  735,  734,  733,  732,  405, 1931,  731,  730,  144,
 /*   110 */   725,  724,  723,  722,  721,  720,  719,  157,  715,  714,
 /*   120 */   713,  404,  403,  710,  709,  708,  175,  174,  594, 2241,
 /*   130 */   509,  654, 1320,  502, 1758,  123, 1578, 1579,  122,  121,
 /*   140 */   120,  119,  118,  117,  116,  115,  114, 1311,  697,  696,
 /*   150 */   695, 1315,  694, 1317, 1318,  693,  690,  179, 1326,  687,
 /*   160 */  1328, 1329,  684,  681,   49,  640, 1551, 1561,  654, 2219,
 /*   170 */   655, 1892, 1577, 1580, 1720,   39,   38,  360, 1993,   45,
 /*   180 */    43,   42,   41,   40, 1409, 1410, 1496, 1523, 1494,  133,
 /*   190 */   655, 1892,  387,   62, 1715, 2216,  539,   39,   38,  280,
 /*   200 */   165,   45,   43,   42,   41,   40,   39,   38, 1894,  191,
 /*   210 */    45,   43,   42,   41,   40, 1499, 1500, 1868, 1550, 1553,
 /*   220 */  1554, 1555, 1556, 1557, 1558, 1559, 1560,  667,  663, 1569,
 /*   230 */  1570, 1572, 1573, 1574, 1575,    2,   46,   44, 1722,  179,
 /*   240 */    62,  343,   93, 1518,  393,  408, 1495,   62,   49,  407,
 /*   250 */   471, 2116, 2280,  485,  352, 2275,  484, 1576, 1989, 1493,
 /*   260 */  1994,  672,  132,  131,  130,  129,  128,  127,  126,  125,
 /*   270 */   124, 2279,  454, 1522,  486, 2276, 2278,  456,  432,  396,
 /*   280 */   431,  707, 2280, 1571, 1275, 2275,  211,  165, 2134,   19,
 /*   290 */   504,  593, 1765, 1714, 2275, 1894, 1501, 1274, 1605, 1685,
 /*   300 */  2084, 2279,  671,  196, 2010, 2276, 2277,  430,  618, 2281,
 /*   310 */   186, 2275,  518, 2116, 2276,  619,  386,  621,   66, 2007,
 /*   320 */   642,  758,  361,  672,   15, 1767,  617,  186, 1264,  655,
 /*   330 */  1892, 2276,  619, 2115,  444,  257, 2151,  655, 1892,  110,
 /*   340 */  2117,  675, 2119, 2120,  670,  189,  665, 1521,  133,  143,
 /*   350 */  2134,  150, 2175, 2204, 1606,  544,   55,  389, 2200,  487,
 /*   360 */  1578, 1579, 2084,  482,  671, 1266,  476,  475,  474,  473,
 /*   370 */   470,  469,  468,  467,  466,  462,  461,  460,  459,  342,
 /*   380 */   451,  450,  449,  613,  446,  445,  359, 1650, 1520, 1521,
 /*   390 */  1551, 1561,  189, 1520,  545, 2115, 1577, 1580, 2151,  189,
 /*   400 */   189,  110, 2117,  675, 2119, 2120,  670,  707,  665, 1191,
 /*   410 */  1496, 1190, 1494, 2295,   62, 2204, 1262,  630,  140,  389,
 /*   420 */  2200,  279,   50,  608,  641,  630,  140, 1745,   35,  391,
 /*   430 */  1600, 1601, 1602, 1603, 1604, 1608, 1609, 1610, 1611, 1499,
 /*   440 */  1500, 1192, 1550, 1553, 1554, 1555, 1556, 1557, 1558, 1559,
 /*   450 */  1560,  667,  663, 1569, 1570, 1572, 1573, 1574, 1575,    2,
 /*   460 */    12,   46,   44, 1354, 1355, 1495,  402,  401,   62,  393,
 /*   470 */  1279, 1495,  557,  556,  555,  516, 2084, 2003, 1493,  547,
 /*   480 */   137,  551, 1576, 1278, 1493,  550, 2280, 2116,   32, 1502,
 /*   490 */   549,  554,  368,  367,   39,   38,  548,  672,   45,   43,
 /*   500 */    42,   41,   40, 1522, 1523, 1426, 1427, 2116, 1571,  614,
 /*   510 */   609,  602, 1674,  699,   19, 1501, 1935,  669,  185, 2212,
 /*   520 */  2213, 1501,  138, 2217, 2134,  632,  184, 2212, 2213,  398,
 /*   530 */   138, 2217, 1937, 1939, 2051, 1191, 2084, 1190,  671, 1552,
 /*   540 */   758, 1425, 1428, 1519, 2134,  489,  758,   39,   38,   15,
 /*   550 */   228,   45,   43,   42,   41,   40, 2084,  153,  671,  605,
 /*   560 */   604, 1672, 1673, 1675, 1676, 1677,  189, 1192,  166, 2115,
 /*   570 */  1744,  580, 2151,  318,  189,  170, 2117,  675, 2119, 2120,
 /*   580 */   670,  246,  665,   28, 1708, 1578, 1579,  316,   73, 2115,
 /*   590 */    12,   72, 2151, 2094,  562,  334, 2117,  675, 2119, 2120,
 /*   600 */   670,  668,  665,  656, 2169,  655, 1892, 2102,  107,  572,
 /*   610 */   209,  497,  495,  492,   54, 1551, 1561, 2098,  612, 2084,
 /*   620 */   189, 1577, 1580,  242,  438,  141,  620, 2296,  213, 1496,
 /*   630 */   478, 1494,  504, 1884, 1765, 1496, 1794, 1494,  165,  565,
 /*   640 */  1944, 1944, 1505,  641,  559, 2134, 1895,  358,  373,  241,
 /*   650 */    62,  279,  195, 2100,  376, 1942, 1942, 1501, 1499, 1500,
 /*   660 */  1169,  289,  290,  665, 1499, 1500,  288, 1550, 1553, 1554,
 /*   670 */  1555, 1556, 1557, 1558, 1559, 1560,  667,  663, 1569, 1570,
 /*   680 */  1572, 1573, 1574, 1575,    2,   46,   44, 1581,  109,   70,
 /*   690 */   202,  201,   69,  393,  639, 1495, 2003, 2116,  611, 1171,
 /*   700 */  1974, 1174, 1175,  557,  556,  555, 1576,  633, 1493,  365,
 /*   710 */   547,  137,  551,  477,  641,  698,  550,  618,  655, 1892,
 /*   720 */  2275,  549,  554,  368,  367,  630,  140,  548,   81,   80,
 /*   730 */   437, 1643, 1571,  193, 2134,  617,  186,  439, 1938, 1939,
 /*   740 */  2276,  619,  717,  244, 1944, 1501, 2084,  243,  671,  655,
 /*   750 */  1892,  383,   14,   13,  341,  655, 1892,  423, 1877, 1942,
 /*   760 */   421,  417,  413,  410,  430,  650, 1743, 2003,  448, 1944,
 /*   770 */   758,  106, 2077,   47,  463,  366,  388,  364,  363, 2115,
 /*   780 */   541,  103, 2151, 2116, 1942,  110, 2117,  675, 2119, 2120,
 /*   790 */   670, 1944,  665,  672, 1869,  655, 1892,  183,  397, 2204,
 /*   800 */   101,  543,  189,  389, 2200,  542, 1942,   90,  347, 1578,
 /*   810 */  1579,  372,   87,  573,  464, 2084,  188, 2078,  593, 1735,
 /*   820 */  2134, 2275,  553,  552, 2230, 1885,  277, 2212,  629,  362,
 /*   830 */   134,  628, 2084, 2275,  671, 1742, 2281,  186, 1887, 1551,
 /*   840 */  1561, 2276,  619,  630,  140, 1577, 1580,  245,  617,  186,
 /*   850 */   655, 1892, 1619, 2276,  619,  458, 1586, 2219,   12, 1496,
 /*   860 */    10, 1494, 1520,  593,  457, 2115, 2275, 1741, 2151,  517,
 /*   870 */  1879,  111, 2117,  675, 2119, 2120,  670,  657,  665, 2176,
 /*   880 */   622, 2281,  186, 2215, 2084, 2204, 2276,  619, 1499, 1500,
 /*   890 */  2201, 1550, 1553, 1554, 1555, 1556, 1557, 1558, 1559, 1560,
 /*   900 */   667,  663, 1569, 1570, 1572, 1573, 1574, 1575,    2,   46,
 /*   910 */    44,  659, 1523, 2176, 1468, 1469, 2084,  393,  427, 1495,
 /*   920 */    52, 2116,    3,  705,  155,  154,  702,  701,  700,  152,
 /*   930 */  1576,  633, 1493,   39,   38,  655, 1892,   45,   43,   42,
 /*   940 */    41,   40,  429,  425,  187, 2212, 2213, 2116,  138, 2217,
 /*   950 */   198, 1875,  655, 1892, 1889,  578, 1571,  672, 2134, 2238,
 /*   960 */   705,  155,  154,  702,  701,  700,  152,  399, 1520, 1501,
 /*   970 */  2084,  247,  671,  655, 1892,  165,   42,   41,   40, 2219,
 /*   980 */  1642,   39,   38, 1894, 2134,   45,   43,   42,   41,   40,
 /*   990 */    84,  543,  589,   83,  758,  542, 2084,   47,  671,  655,
 /*  1000 */  1892,  593, 1740, 2115, 2275, 2214, 2151, 2116, 1552,  110,
 /*  1010 */  2117,  675, 2119, 2120,  670, 2067,  665,  672,  634, 2281,
 /*  1020 */   186,  183,    9, 2204, 2276,  619, 1739,  389, 2200, 2115,
 /*  1030 */  1867,   87, 2151, 1578, 1579,  110, 2117,  675, 2119, 2120,
 /*  1040 */   670, 2094,  665,  254, 2134, 1738,  571, 2295, 2231, 2204,
 /*  1050 */   146, 2084,  135,  389, 2200, 1883, 2084, 1888,  671,  569,
 /*  1060 */   256,  567, 1989, 1551, 1561, 2098,   34,  655, 1892, 1577,
 /*  1070 */  1580, 1607,   39,   38, 1662, 2084,   45,   43,   42,   41,
 /*  1080 */    40,  729,  727, 1496, 1896, 1494,  638,  655, 1892, 2115,
 /*  1090 */   655, 1892, 2151,  164, 2084,  169, 2117,  675, 2119, 2120,
 /*  1100 */   670, 2100,  665, 1174, 1175,  312,  293,  200, 1921,  652,
 /*  1110 */   623,  665, 1499, 1500, 1552, 1550, 1553, 1554, 1555, 1556,
 /*  1120 */  1557, 1558, 1559, 1560,  667,  663, 1569, 1570, 1572, 1573,
 /*  1130 */  1574, 1575,    2,   46,   44, 1737, 2242, 2116,  655, 1892,
 /*  1140 */  1736,  393, 1733, 1495, 2094,   33, 1732,  672, 1731, 2251,
 /*  1150 */   655, 1892,  655, 1892, 1576, 1612, 1493,  653, 2102,  705,
 /*  1160 */   155,  154,  702,  701,  700,  152, 1730,  142, 2098,  299,
 /*  1170 */  2175,  400, 2224, 1639, 2134, 1944,  703, 1177,  704, 1935,
 /*  1180 */  1571, 1935, 1729, 1519, 2084, 2094, 2084, 1728,  671, 2084,
 /*  1190 */  1943, 2084, 2094, 1501, 1870, 2084,  625, 2084, 1727, 2102,
 /*  1200 */  1726, 1725, 2070,  251, 2100,  377, 2103,  718,  234, 2098,
 /*  1210 */  1854,  232,   74,  592,  665, 2084, 2098,  236,  758, 2115,
 /*  1220 */   235,   15, 2151, 2116,  422,  110, 2117,  675, 2119, 2120,
 /*  1230 */   670, 2084,  665,  672, 1639,  600, 2084, 2295,  148, 2204,
 /*  1240 */   153,  441,  546,  389, 2200, 2100,  390, 2084, 1781, 2084,
 /*  1250 */  2084,  415, 2100,  238,  442,  665,  237, 1578, 1579, 1774,
 /*  1260 */  2134,   82,  665,  240, 1260,  153,  239, 1772,  711,  575,
 /*  1270 */   558,  574, 2084,  662,  671,   64,  255,   64,  261, 1717,
 /*  1280 */  1718,  560,   14,   13,  666, 2105, 1834, 1551, 1561,  563,
 /*  1290 */  1240, 2244,  274, 1577, 1580,  227,  268, 1463,  606, 1832,
 /*  1300 */  1504, 1503,  712, 1831,  153, 2115,   48, 1496, 2151, 1494,
 /*  1310 */  2135,  110, 2117,  675, 2119, 2120,  670,  286,  665,   91,
 /*  1320 */    71,  151, 1466, 2295, 1238, 2204,  406,   64,   48,  389,
 /*  1330 */  2200, 1998, 1671,   53, 1670,  263, 1499, 1500, 2107, 1550,
 /*  1340 */  1553, 1554, 1555, 1556, 1557, 1558, 1559, 1560,  667,  663,
 /*  1350 */  1569, 1570, 1572, 1573, 1574, 1575,    2, 2116,  402,  401,
 /*  1360 */  1221,  637,  153, 1423,   48,  679, 1768,  672, 1509, 2269,
 /*  1370 */   151, 1764,  153, 1759,  291, 1932, 2234,  647,  295, 1576,
 /*  1380 */   136, 1502,  631, 2116, 1613, 1562,  276,  151,  273,    1,
 /*  1390 */     5,  409,  356,  672, 2134, 2223,  414, 1222, 1446,  306,
 /*  1400 */   199,  443, 1523, 1999,  480, 1571, 2084,  447,  671,  452,
 /*  1410 */  1518,  490,  465, 1991,  479,  472,  753,  491, 1501, 1305,
 /*  1420 */  2134,  311, 1332, 1597,  481,  488,  203, 1336,  626, 1343,
 /*  1430 */  2116,  204, 2084,  493,  671,  494,  206, 1341,  496, 2115,
 /*  1440 */   672,  498, 2151,  661,  156,  110, 2117,  675, 2119, 2120,
 /*  1450 */   670, 2116,  665, 1507, 1506, 1524,    4, 2295,  499, 2204,
 /*  1460 */   507,  672, 1526,  389, 2200, 2115,  500, 2134, 2151,  508,
 /*  1470 */   510,  110, 2117,  675, 2119, 2120,  670, 1521,  665, 2084,
 /*  1480 */  1525,  671,  214, 2295,  511, 2204,  512,  216, 2134,  389,
 /*  1490 */  2200, 1527,  513, 1194,  219,  515,  221,   85,   86,  519,
 /*  1500 */  2084,  536,  671,  225,  538,  537,  112,  346,  540, 1882,
 /*  1510 */   231, 1878, 2115, 2060,  577, 2151, 2057, 2056,  170, 2117,
 /*  1520 */   675, 2119, 2120,  670,  579,  665,  233,   89,  149,  307,
 /*  1530 */   158,  159, 1510, 2115, 1505,  248, 2151, 1880, 1876,  110,
 /*  1540 */  2117,  675, 2119, 2120,  670,  160,  665,  161,  583,  252,
 /*  1550 */   582, 2179, 1453, 2204,  584, 2116,  597,  389, 2200,  607,
 /*  1560 */   587, 1513, 1515,  250, 2250,  672,  590,  645,  259,  588,
 /*  1570 */  2297, 2235, 2245,  603,  663, 1569, 1570, 1572, 1573, 1574,
 /*  1580 */  1575,  262, 2249,    8,  616,  378,  610, 2226,  598,  596,
 /*  1590 */   595,  267, 2134,  379,  139,  272, 1639, 2298,  627, 1522,
 /*  1600 */   624, 2220,  382,  635, 2084,  269,  671, 1528, 2004,  308,
 /*  1610 */   643,  281,   96,  309,  644,  648,   98, 2018, 2017, 2016,
 /*  1620 */   649, 2116,  173,  385,  270, 1893,  271,  100,   61,  102,
 /*  1630 */  2185,  672, 1936,  313, 1855,  310,  754, 2115,  302,  755,
 /*  1640 */  2151,  757,  348,  110, 2117,  675, 2119, 2120,  670, 2116,
 /*  1650 */   665, 2274,  677,  275,  337, 2177,   51, 2204, 2134,  672,
 /*  1660 */   322,  389, 2200,  336,  326,  317, 2076, 2075,  349, 2074,
 /*  1670 */  2084,  315,  671,   78, 2071,  411,  412, 1486, 1487,  192,
 /*  1680 */   416, 2116, 2069,  418,  419,  420, 2134, 2068,  357, 2066,
 /*  1690 */   424,  672,  426, 2064,  428,   79, 1449, 1448, 2084, 2065,
 /*  1700 */   671, 2030, 2029, 2115, 2028,  435, 2151,  436, 2027,  110,
 /*  1710 */  2117,  675, 2119, 2120,  670, 2026,  665, 1982, 2134, 1400,
 /*  1720 */  1981,  658, 1979, 2204, 1978,  145, 1977,  389, 2200, 1980,
 /*  1730 */  2084, 2115,  671, 1976, 2151, 1975, 1973,  111, 2117,  675,
 /*  1740 */  2119, 2120,  670, 1972,  665, 1971,  197,  453, 1970,  455,
 /*  1750 */  1984, 2204, 2116, 1969, 1968, 2203, 2200,  483,  147, 1954,
 /*  1760 */  1953, 1952,  672, 2115, 1967, 1966, 2151, 1965, 1964,  111,
 /*  1770 */  2117,  675, 2119, 2120,  670, 1963,  665, 1962, 1961, 1960,
 /*  1780 */  2116, 1959, 1958, 2204, 1957, 1956, 1955,  660, 2200, 2134,
 /*  1790 */   672, 1983, 1951, 1950, 1402, 1949, 1948, 1947, 1946, 2116,
 /*  1800 */  1945, 2084, 1276,  671,  344, 1280,  345, 1797,  205,  669,
 /*  1810 */  1796, 1272, 1795, 1793,  207, 2116, 1754, 2134,  180, 1176,
 /*  1820 */  2104,  208, 1753, 2047, 2037,  672,   76, 2025,   77, 2084,
 /*  1830 */   210,  671, 2024,  218,  673,  220, 2134, 2151, 2002, 1871,
 /*  1840 */   111, 2117,  675, 2119, 2120,  670,  181,  665, 2084,  505,
 /*  1850 */   671,  212, 2134, 1792, 2204, 1790, 1214,  384,  351, 2200,
 /*  1860 */   520, 1788, 2115,  521, 2084, 2151,  671,  522,  328, 2117,
 /*  1870 */   675, 2119, 2120,  670,  526,  665, 2116,  524,  525, 1786,
 /*  1880 */   528, 2115,  529,  530, 2151, 1784,  672,  334, 2117,  675,
 /*  1890 */  2119, 2120,  670,  532,  665,  533, 2170, 2115,  581, 2116,
 /*  1900 */  2151,  534, 1771,  335, 2117,  675, 2119, 2120,  670,  672,
 /*  1910 */   665,  615, 1770, 2134, 1750, 1873,  761,   63,  392, 1348,
 /*  1920 */  1347, 1872,  230, 1263, 1261, 2084, 1259,  671, 1258, 1257,
 /*  1930 */   305, 1256, 1250, 1782, 1255,  369, 2134,  561, 1252,  726,
 /*  1940 */  1251,  394, 1249, 1775,  728,  370,  178, 1773, 2084,  371,
 /*  1950 */   671,  564,  751,  747,  743,  739,  303,  566, 2115, 1749,
 /*  1960 */  1748, 2151, 1747,  568,  335, 2117,  675, 2119, 2120,  670,
 /*  1970 */   570,  665,  113, 1473, 1475, 1472, 1477,   27, 2046, 1455,
 /*  1980 */    67, 2115, 2036, 1457, 2151,   56,  585,  335, 2117,  675,
 /*  1990 */  2119, 2120,  670, 2116,  665,  163,  108, 2023,  586,  296,
 /*  2000 */  2021,  253, 1459,  672,  375, 2280,   29,   20,   17,  591,
 /*  2010 */  1687,  258,   59,    6,    7,  599,  601,   60,  265,  260,
 /*  2020 */  1669,   31,  266, 2105,  171, 2116,  264,   21,   65,   30,
 /*  2030 */  2134,  651, 1661, 1707,   92,  672, 1708,   22, 1702,  278,
 /*  2040 */  1701,  380, 2084, 2116,  671, 1706, 1705,  381,  176, 2022,
 /*  2050 */  1636, 1635,   58,  672, 2020, 2019, 2001,   18,   94,   95,
 /*  2060 */   284,  646, 2134, 2000,  103,   97,  283,   23,   57,  297,
 /*  2070 */   285,  282, 1667,  294, 2084,  576,  671,   24, 2151,  287,
 /*  2080 */  2134,  330, 2117,  675, 2119, 2120,  670,  292,  665,   68,
 /*  2090 */  2116,  249, 2084,   11,  671,   99, 1588, 1587,   13, 1511,
 /*  2100 */   672, 1543, 1598,  678,  177,  190,  395, 2115, 1566, 2154,
 /*  2110 */  2151,  682, 1325,  319, 2117,  675, 2119, 2120,  670,  664,
 /*  2120 */   665,  685, 1564,   37,   16, 2115,  676, 2134, 2151, 1563,
 /*  2130 */    25,  320, 2117,  675, 2119, 2120,  670, 2116,  665, 2084,
 /*  2140 */  1535,  671,  674,   26,  688, 1333,  680,  672, 1330, 1327,
 /*  2150 */   683,  686,  691, 1321, 1319,  300, 1324, 1323, 1322, 2116,
 /*  2160 */   689,  692,  104, 1342,  105,   75, 1338, 1212,  706,  672,
 /*  2170 */  1244, 1243, 2115,  301, 2134, 2151, 1242, 1241,  321, 2117,
 /*  2180 */   675, 2119, 2120,  670, 2116,  665, 2084, 1239,  671, 1237,
 /*  2190 */  1236, 1235, 1270,  716,  672, 1233, 2134, 1232, 1231, 1230,
 /*  2200 */  1229, 1228, 1227, 1267, 1265, 1224, 2116, 1223, 2084, 1220,
 /*  2210 */   671, 1219, 1218, 1217, 1789,  736,  672,  737,  738, 2115,
 /*  2220 */  1787, 2134, 2151,  740,  741,  327, 2117,  675, 2119, 2120,
 /*  2230 */   670,  742,  665, 2084, 1785,  671,  744,  746,  745, 1783,
 /*  2240 */   748, 2115,  749, 2134, 2151,  750, 1769,  331, 2117,  675,
 /*  2250 */  2119, 2120,  670,  752,  665, 2084, 1166,  671,  304,  756,
 /*  2260 */  1721, 1721, 1497,  314,  759,  760, 2115, 1746, 1721, 2151,
 /*  2270 */  2116, 1721,  323, 2117,  675, 2119, 2120,  670, 1721,  665,
 /*  2280 */   672, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 2115, 1721,
 /*  2290 */  2116, 2151, 1721, 1721,  332, 2117,  675, 2119, 2120,  670,
 /*  2300 */   672,  665, 1721, 1721, 1721, 2116, 1721, 2134, 1721, 1721,
 /*  2310 */  1721, 1721, 1721, 1721, 1721,  672, 1721, 1721, 1721, 2084,
 /*  2320 */  1721,  671, 1721, 1721, 1721, 1721, 1721, 2134, 1721, 1721,
 /*  2330 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 2116, 1721, 2084,
 /*  2340 */  1721,  671, 2134, 1721, 1721, 1721, 1721,  672, 1721, 1721,
 /*  2350 */  1721, 1721, 2115, 1721, 2084, 2151,  671, 1721,  324, 2117,
 /*  2360 */   675, 2119, 2120,  670, 1721,  665, 1721, 1721, 1721, 1721,
 /*  2370 */  1721, 1721, 2115, 1721, 2134, 2151, 1721, 1721,  333, 2117,
 /*  2380 */   675, 2119, 2120,  670, 1721,  665, 2084, 2115,  671, 1721,
 /*  2390 */  2151, 1721, 1721,  325, 2117,  675, 2119, 2120,  670, 1721,
 /*  2400 */   665, 1721, 1721, 1721, 1721, 2116, 1721, 1721, 1721, 1721,
 /*  2410 */  1721, 1721, 1721, 1721, 1721,  672, 1721, 1721, 1721, 2115,
 /*  2420 */  1721, 1721, 2151, 1721, 2116,  338, 2117,  675, 2119, 2120,
 /*  2430 */   670, 1721,  665, 1721,  672, 1721, 1721, 1721, 1721, 1721,
 /*  2440 */  1721, 1721, 2134, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2450 */  1721, 1721, 2116, 1721, 2084, 1721,  671, 1721, 1721, 1721,
 /*  2460 */  1721, 2134,  672, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2470 */  1721, 2116, 1721, 2084, 1721,  671, 1721, 1721, 1721, 1721,
 /*  2480 */  1721,  672, 1721, 1721, 1721, 1721, 1721, 2115, 1721, 2134,
 /*  2490 */  2151, 1721, 1721,  339, 2117,  675, 2119, 2120,  670, 1721,
 /*  2500 */   665, 2084, 1721,  671, 1721, 1721, 2115, 1721, 2134, 2151,
 /*  2510 */  1721, 1721, 2128, 2117,  675, 2119, 2120,  670, 2116,  665,
 /*  2520 */  2084, 1721,  671, 1721, 1721, 1721, 1721, 1721,  672, 1721,
 /*  2530 */  1721, 1721, 1721, 1721, 2115, 1721, 1721, 2151, 1721, 1721,
 /*  2540 */  2127, 2117,  675, 2119, 2120,  670, 1721,  665, 1721, 1721,
 /*  2550 */  1721, 1721, 1721, 2115, 1721, 2134, 2151, 1721, 1721, 2126,
 /*  2560 */  2117,  675, 2119, 2120,  670, 1721,  665, 2084, 1721,  671,
 /*  2570 */  1721, 1721, 1721, 1721, 1721, 2116, 1721, 1721, 1721, 1721,
 /*  2580 */  1721, 1721, 1721, 1721, 1721,  672, 1721, 1721, 1721, 1721,
 /*  2590 */  1721, 2116, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2600 */  2115,  672, 1721, 2151, 1721, 1721,  353, 2117,  675, 2119,
 /*  2610 */  2120,  670, 2134,  665, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2620 */  1721, 1721, 1721, 1721, 2084, 1721,  671, 1721, 2134, 1721,
 /*  2630 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2640 */  2084, 2116,  671, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2650 */  1721,  672, 1721, 1721, 1721, 1721, 1721, 2115, 1721, 1721,
 /*  2660 */  2151, 2116, 1721,  354, 2117,  675, 2119, 2120,  670, 1721,
 /*  2670 */   665,  672, 1721, 2115, 1721, 1721, 2151, 1721, 2134,  350,
 /*  2680 */  2117,  675, 2119, 2120,  670, 1721,  665, 1721, 1721, 1721,
 /*  2690 */  2084, 1721,  671, 1721, 1721, 1721, 1721, 1721, 2134, 1721,
 /*  2700 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 2116, 1721,
 /*  2710 */  2084, 1721,  671, 1721, 1721, 1721, 1721, 1721,  672, 1721,
 /*  2720 */  1721, 1721, 1721, 2115, 1721, 1721, 2151, 1721, 1721,  355,
 /*  2730 */  2117,  675, 2119, 2120,  670, 1721,  665, 1721, 1721, 1721,
 /*  2740 */  1721, 1721,  229,  673, 1721, 2134, 2151, 1721, 1721,  330,
 /*  2750 */  2117,  675, 2119, 2120,  670, 1721,  665, 2084,  172,  671,
 /*  2760 */  1721, 1721, 1721, 1721,  535,  531,  527,  523,  226, 1721,
 /*  2770 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2780 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2790 */  2115, 1721, 1721, 2151, 1721, 1721,  329, 2117,  675, 2119,
 /*  2800 */  2120,  670, 1721,  665, 1721, 1721, 1721, 1721,   88, 1721,
 /*  2810 */  1721,  224, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2820 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2830 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2840 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2850 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2860 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2870 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,  223,  217,
 /*  2880 */  1721, 1721, 1721,  222, 1721,  514, 1721, 1721, 1721, 1721,
 /*  2890 */  1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721, 1721,
 /*  2900 */  1721, 1721, 1721,  215,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   333,  384,  371,  362,  401,  332,  401,  334,  405,  343,
 /*    10 */   343,  370,   12,   13,   14,    0,  399,  400,  377,  378,
 /*    20 */    20,   14,   22,  342,    8,    9,  385,   20,   12,   13,
 /*    30 */    14,   15,   16,   33,    0,   35,   21,  370,   20,   24,
 /*    40 */    25,   26,   27,   28,   29,   30,   31,   32,    3,  382,
 /*    50 */   447,  384,  447,  450,  388,  450,    8,    9,  351,   59,
 /*    60 */    12,   13,   14,   15,   16,   65,  359,  386,  465,  466,
 /*    70 */   465,  466,   72,  470,  471,  470,  471,   12,   13,   14,
 /*    80 */    15,   16,  415,  337,   20,  418,  340,  341,  421,  422,
 /*    90 */   423,  424,  425,  426,  369,  428,   20,   97,  436,  437,
 /*   100 */   100,   67,   68,   69,   70,   71,  381,   73,   74,   75,
 /*   110 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   120 */    86,   87,   88,   89,   90,   91,   92,   93,  461,  462,
 /*   130 */   337,   20,   97,  340,  341,   21,  136,  137,   24,   25,
 /*   140 */    26,   27,   28,   29,   30,   31,   32,  112,  113,  114,
 /*   150 */   115,  116,  117,  118,  119,  120,  121,  370,  123,  124,
 /*   160 */   125,  126,  127,  128,  100,   20,  166,  167,   20,  420,
 /*   170 */   342,  343,  172,  173,  330,    8,    9,  390,  391,   12,
 /*   180 */    13,   14,   15,   16,  166,  167,  186,   20,  188,  361,
 /*   190 */   342,  343,  362,  100,  178,  446,  368,    8,    9,   59,
 /*   200 */   370,   12,   13,   14,   15,   16,    8,    9,  378,  361,
 /*   210 */    12,   13,   14,   15,   16,  215,  216,    0,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */   230,  231,  232,  233,  234,  235,   12,   13,    0,  370,
 /*   240 */   100,   18,  102,   20,   20,  401,   22,  100,  100,  405,
 /*   250 */    27,  333,  447,   30,   65,  450,   33,   33,  343,   35,
 /*   260 */   391,  343,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   270 */    32,  466,   49,   20,   51,  470,  471,   54,  185,  362,
 /*   280 */   187,   64,  447,   59,   22,  450,  338,  370,  370,   65,
 /*   290 */   342,  447,  344,  277,  450,  378,   72,   35,  109,  101,
 /*   300 */   382,  466,  384,  388,  384,  470,  471,  214,  447,  465,
 /*   310 */   466,  450,   64,  333,  470,  471,  396,  272,    4,  399,
 /*   320 */   400,   97,   99,  343,  100,  345,  465,  466,   35,  342,
 /*   330 */   343,  470,  471,  415,  111,  168,  418,  342,  343,  421,
 /*   340 */   422,  423,  424,  425,  426,  252,  428,   20,  361,  431,
 /*   350 */   370,  433,  434,  435,  165,  368,  361,  439,  440,   97,
 /*   360 */   136,  137,  382,  140,  384,   72,  143,  144,  145,  146,
 /*   370 */   147,  148,  149,  150,  151,  152,  153,  154,  155,  156,
 /*   380 */   157,  158,  159,   20,  161,  162,  163,   14,   20,   20,
 /*   390 */   166,  167,  252,   20,   13,  415,  172,  173,  418,  252,
 /*   400 */   252,  421,  422,  423,  424,  425,  426,   64,  428,   20,
 /*   410 */   186,   22,  188,  433,  100,  435,   35,  342,  343,  439,
 /*   420 */   440,  168,  100,  171,  342,  342,  343,  333,  239,  240,
 /*   430 */   241,  242,  243,  244,  245,  246,  247,  248,  249,  215,
 /*   440 */   216,   52,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   450 */   226,  227,  228,  229,  230,  231,  232,  233,  234,  235,
 /*   460 */   236,   12,   13,  136,  137,   22,   12,   13,  100,   20,
 /*   470 */    22,   22,   67,   68,   69,  393,  382,  395,   35,   74,
 /*   480 */    75,   76,   33,   35,   35,   80,    3,  333,    2,   35,
 /*   490 */    85,   86,   87,   88,    8,    9,   91,  343,   12,   13,
 /*   500 */    14,   15,   16,   20,   20,  136,  137,  333,   59,  257,
 /*   510 */   258,  259,  215,  379,   65,   72,  382,  343,  443,  444,
 /*   520 */   445,   72,  447,  448,  370,  442,  443,  444,  445,  380,
 /*   530 */   447,  448,  383,  384,  366,   20,  382,   22,  384,  166,
 /*   540 */    97,  172,  173,   20,  370,   97,   97,    8,    9,  100,
 /*   550 */    35,   12,   13,   14,   15,   16,  382,   44,  384,  262,
 /*   560 */   263,  264,  265,  266,  267,  268,  252,   52,   18,  415,
 /*   570 */   333,  111,  418,   23,  252,  421,  422,  423,  424,  425,
 /*   580 */   426,  413,  428,   44,  101,  136,  137,   37,   38,  415,
 /*   590 */   236,   41,  418,  358,    4,  421,  422,  423,  424,  425,
 /*   600 */   426,  427,  428,  429,  430,  342,  343,  372,  348,   19,
 /*   610 */    60,   61,   62,   63,  101,  166,  167,  382,  343,  382,
 /*   620 */   252,  172,  173,   33,  361,  365,  472,  473,  338,  186,
 /*   630 */    81,  188,  342,  373,  344,  186,    0,  188,  370,   49,
 /*   640 */   370,  370,  188,  342,   54,  370,  378,  377,  377,   59,
 /*   650 */   100,  168,  168,  418,  419,  385,  385,   72,  215,  216,
 /*   660 */     4,  130,  131,  428,  215,  216,  135,  218,  219,  220,
 /*   670 */   221,  222,  223,  224,  225,  226,  227,  228,  229,  230,
 /*   680 */   231,  232,  233,  234,  235,   12,   13,   14,  138,   99,
 /*   690 */   141,  142,  102,   20,  393,   22,  395,  333,  423,   43,
 /*   700 */     0,   45,   46,   67,   68,   69,   33,  343,   35,   37,
 /*   710 */    74,   75,   76,  164,  342,  111,   80,  447,  342,  343,
 /*   720 */   450,   85,   86,   87,   88,  342,  343,   91,  178,  179,
 /*   730 */   180,    4,   59,  183,  370,  465,  466,  361,  383,  384,
 /*   740 */   470,  471,   72,  131,  370,   72,  382,  135,  384,  342,
 /*   750 */   343,  377,    1,    2,  204,  342,  343,  207,  371,  385,
 /*   760 */   210,  211,  212,  213,  214,  393,  333,  395,  361,  370,
 /*   770 */    97,  100,  401,  100,  361,  103,  377,  105,  106,  415,
 /*   780 */   108,  110,  418,  333,  385,  421,  422,  423,  424,  425,
 /*   790 */   426,  370,  428,  343,    0,  342,  343,  433,  377,  435,
 /*   800 */   348,  129,  252,  439,  440,  133,  385,  195,  196,  136,
 /*   810 */   137,  199,  350,  201,  361,  382,  452,  401,  447,  334,
 /*   820 */   370,  450,  355,  356,  460,  373,  443,  444,  445,  367,
 /*   830 */   447,  448,  382,  450,  384,  333,  465,  466,  376,  166,
 /*   840 */   167,  470,  471,  342,  343,  172,  173,  130,  465,  466,
 /*   850 */   342,  343,  101,  470,  471,  155,   14,  420,  236,  186,
 /*   860 */   238,  188,   20,  447,  164,  415,  450,  333,  418,  361,
 /*   870 */   371,  421,  422,  423,  424,  425,  426,  432,  428,  434,
 /*   880 */    44,  465,  466,  446,  382,  435,  470,  471,  215,  216,
 /*   890 */   440,  218,  219,  220,  221,  222,  223,  224,  225,  226,
 /*   900 */   227,  228,  229,  230,  231,  232,  233,  234,  235,   12,
 /*   910 */    13,  432,   20,  434,  197,  198,  382,   20,  181,   22,
 /*   920 */    42,  333,   44,  129,  130,  131,  132,  133,  134,  135,
 /*   930 */    33,  343,   35,    8,    9,  342,  343,   12,   13,   14,
 /*   940 */    15,   16,  205,  206,  443,  444,  445,  333,  447,  448,
 /*   950 */    59,  371,  342,  343,  361,  401,   59,  343,  370,  345,
 /*   960 */   129,  130,  131,  132,  133,  134,  135,  362,   20,   72,
 /*   970 */   382,  361,  384,  342,  343,  370,   14,   15,   16,  420,
 /*   980 */   253,    8,    9,  378,  370,   12,   13,   14,   15,   16,
 /*   990 */    99,  129,  361,  102,   97,  133,  382,  100,  384,  342,
 /*  1000 */   343,  447,  333,  415,  450,  446,  418,  333,  166,  421,
 /*  1010 */   422,  423,  424,  425,  426,    0,  428,  343,  361,  465,
 /*  1020 */   466,  433,   39,  435,  470,  471,  333,  439,  440,  415,
 /*  1030 */     0,  350,  418,  136,  137,  421,  422,  423,  424,  425,
 /*  1040 */   426,  358,  428,  406,  370,  333,   21,  433,  460,  435,
 /*  1050 */    42,  382,   44,  439,  440,  372,  382,  376,  384,   34,
 /*  1060 */   168,   36,  343,  166,  167,  382,    2,  342,  343,  172,
 /*  1070 */   173,  165,    8,    9,  101,  382,   12,   13,   14,   15,
 /*  1080 */    16,  355,  356,  186,  371,  188,  361,  342,  343,  415,
 /*  1090 */   342,  343,  418,  168,  382,  421,  422,  423,  424,  425,
 /*  1100 */   426,  418,  428,   45,   46,  363,  361,  388,  366,  361,
 /*  1110 */   274,  428,  215,  216,  166,  218,  219,  220,  221,  222,
 /*  1120 */   223,  224,  225,  226,  227,  228,  229,  230,  231,  232,
 /*  1130 */   233,  234,  235,   12,   13,  333,  462,  333,  342,  343,
 /*  1140 */   333,   20,  333,   22,  358,  239,  333,  343,  333,  345,
 /*  1150 */   342,  343,  342,  343,   33,  249,   35,  361,  372,  129,
 /*  1160 */   130,  131,  132,  133,  134,  135,  333,  431,  382,  361,
 /*  1170 */   434,  361,  250,  251,  370,  370,  379,   14,  379,  382,
 /*  1180 */    59,  382,  333,   20,  382,  358,  382,  333,  384,  382,
 /*  1190 */   385,  382,  358,   72,    0,  382,   44,  382,  333,  372,
 /*  1200 */   333,  333,    0,  371,  418,  419,  372,  357,  104,  382,
 /*  1210 */   360,  107,  111,   48,  428,  382,  382,  104,   97,  415,
 /*  1220 */   107,  100,  418,  333,  209,  421,  422,  423,  424,  425,
 /*  1230 */   426,  382,  428,  343,  251,  345,  382,  433,   44,  435,
 /*  1240 */    44,   22,   13,  439,  440,  418,  419,  382,    0,  382,
 /*  1250 */   382,   49,  418,  104,   35,  428,  107,  136,  137,    0,
 /*  1260 */   370,  160,  428,  104,   35,   44,  107,    0,   13,  200,
 /*  1270 */    22,  202,  382,   65,  384,   44,   59,   44,   44,  136,
 /*  1280 */   137,   22,    1,    2,  371,   47,  359,  166,  167,   22,
 /*  1290 */    35,  392,  474,  172,  173,  346,  457,  101,  463,  358,
 /*  1300 */    35,   35,   13,  358,   44,  415,   44,  186,  418,  188,
 /*  1310 */   370,  421,  422,  423,  424,  425,  426,   44,  428,  102,
 /*  1320 */    44,   44,  101,  433,   35,  435,  346,   44,   44,  439,
 /*  1330 */   440,  392,  101,  168,  101,  101,  215,  216,  100,  218,
 /*  1340 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*  1350 */   229,  230,  231,  232,  233,  234,  235,  333,   12,   13,
 /*  1360 */    35,  101,   44,  101,   44,   44,    0,  343,   22,  345,
 /*  1370 */    44,  343,   44,  341,  101,  381,  392,  101,  101,   33,
 /*  1380 */    44,   35,  449,  333,  101,  101,  467,   44,  441,  451,
 /*  1390 */   254,  417,  416,  343,  370,  345,   49,   72,  184,  403,
 /*  1400 */    42,  389,   20,  392,  165,   59,  382,  389,  384,  387,
 /*  1410 */    20,   98,  342,  342,  387,  389,   50,  354,   72,  101,
 /*  1420 */   370,  101,  101,  215,  387,   96,  353,  101,  276,  101,
 /*  1430 */   333,  342,  382,   95,  384,  352,  342,  101,  342,  415,
 /*  1440 */   343,  342,  418,   97,  101,  421,  422,  423,  424,  425,
 /*  1450 */   426,  333,  428,  188,  188,   20,   48,  433,  335,  435,
 /*  1460 */   335,  343,   20,  439,  440,  415,  339,  370,  418,  339,
 /*  1470 */   410,  421,  422,  423,  424,  425,  426,   20,  428,  382,
 /*  1480 */    20,  384,  350,  433,  384,  435,  344,  350,  370,  439,
 /*  1490 */   440,   20,  402,   53,  350,  344,  350,  350,  350,  342,
 /*  1500 */   382,  347,  384,  350,  335,  347,  342,  335,  370,  370,
 /*  1510 */   370,  370,  415,  382,  203,  418,  382,  382,  421,  422,
 /*  1520 */   423,  424,  425,  426,  414,  428,  370,  100,  412,  410,
 /*  1530 */   370,  370,  186,  415,  188,  348,  418,  370,  370,  421,
 /*  1540 */   422,  423,  424,  425,  426,  370,  428,  370,  192,  348,
 /*  1550 */   191,  433,  190,  435,  409,  333,  382,  439,  440,  261,
 /*  1560 */   384,  215,  216,  408,  456,  343,  342,  260,  397,  407,
 /*  1570 */   473,  392,  392,  382,  228,  229,  230,  231,  232,  233,
 /*  1580 */   234,  397,  456,  269,  177,  382,  382,  459,  271,  270,
 /*  1590 */   255,  458,  370,  278,  343,  417,  251,  475,  275,   20,
 /*  1600 */   273,  420,  344,  342,  382,  455,  384,   20,  395,  397,
 /*  1610 */   382,  348,  348,  397,  382,  170,  348,  382,  382,  382,
 /*  1620 */   394,  333,  456,  382,  454,  343,  453,  348,  100,  100,
 /*  1630 */   438,  343,  382,  342,  360,  366,   36,  415,  348,  336,
 /*  1640 */   418,  335,  398,  421,  422,  423,  424,  425,  426,  333,
 /*  1650 */   428,  469,  374,  468,  411,  433,  404,  435,  370,  343,
 /*  1660 */   364,  439,  440,  364,  364,  331,    0,    0,  398,    0,
 /*  1670 */   382,  349,  384,   42,    0,   35,  208,   35,   35,   35,
 /*  1680 */   208,  333,    0,   35,   35,  208,  370,    0,  208,    0,
 /*  1690 */    35,  343,   22,    0,   35,  195,  188,  186,  382,    0,
 /*  1700 */   384,    0,    0,  415,    0,  182,  418,  181,    0,  421,
 /*  1710 */   422,  423,  424,  425,  426,    0,  428,    0,  370,   47,
 /*  1720 */     0,  433,    0,  435,    0,   42,    0,  439,  440,    0,
 /*  1730 */   382,  415,  384,    0,  418,    0,    0,  421,  422,  423,
 /*  1740 */   424,  425,  426,    0,  428,    0,  155,   35,    0,  155,
 /*  1750 */     0,  435,  333,    0,    0,  439,  440,  139,   42,    0,
 /*  1760 */     0,    0,  343,  415,    0,    0,  418,    0,    0,  421,
 /*  1770 */   422,  423,  424,  425,  426,    0,  428,    0,    0,    0,
 /*  1780 */   333,    0,    0,  435,    0,    0,    0,  439,  440,  370,
 /*  1790 */   343,    0,    0,    0,   22,    0,    0,    0,    0,  333,
 /*  1800 */     0,  382,   22,  384,   48,   22,   48,    0,   59,  343,
 /*  1810 */     0,   35,    0,    0,   59,  333,    0,  370,   44,   14,
 /*  1820 */    47,   59,    0,    0,    0,  343,   39,    0,   39,  382,
 /*  1830 */    42,  384,    0,   39,  415,  177,  370,  418,    0,    0,
 /*  1840 */   421,  422,  423,  424,  425,  426,   47,  428,  382,   47,
 /*  1850 */   384,   40,  370,    0,  435,    0,   66,  375,  439,  440,
 /*  1860 */    35,    0,  415,   49,  382,  418,  384,   39,  421,  422,
 /*  1870 */   423,  424,  425,  426,   39,  428,  333,   35,   49,    0,
 /*  1880 */    35,  415,   49,   39,  418,    0,  343,  421,  422,  423,
 /*  1890 */   424,  425,  426,   35,  428,   49,  430,  415,    1,  333,
 /*  1900 */   418,   39,    0,  421,  422,  423,  424,  425,  426,  343,
 /*  1910 */   428,  464,    0,  370,    0,    0,   19,  109,  375,   35,
 /*  1920 */    22,    0,  107,   35,   35,  382,   35,  384,   35,   35,
 /*  1930 */    33,   35,   22,    0,   35,   22,  370,   51,   35,   44,
 /*  1940 */    35,  375,   35,    0,   44,   22,   49,    0,  382,   22,
 /*  1950 */   384,   35,   55,   56,   57,   58,   59,   35,  415,    0,
 /*  1960 */     0,  418,    0,   35,  421,  422,  423,  424,  425,  426,
 /*  1970 */    22,  428,   20,   35,   35,   35,  101,  100,    0,   35,
 /*  1980 */   100,  415,    0,   22,  418,  168,   22,  421,  422,  423,
 /*  1990 */   424,  425,  426,  333,  428,  189,   99,    0,  168,  102,
 /*  2000 */     0,  170,  193,  343,  168,    3,  100,   44,  256,  175,
 /*  2010 */   101,  100,   44,   48,   48,   98,   96,   44,   44,  101,
 /*  2020 */   101,   44,   47,   47,  100,  333,  100,  256,    3,  100,
 /*  2030 */   370,  134,  101,  101,  100,  343,  101,   44,   35,   47,
 /*  2040 */    35,   35,  382,  333,  384,   35,   35,   35,   47,    0,
 /*  2050 */   101,  101,   44,  343,    0,    0,    0,  256,  100,   39,
 /*  2060 */    47,  171,  370,    0,  110,   39,  169,  100,  250,   47,
 /*  2070 */   101,  174,  101,  169,  382,  415,  384,   44,  418,  100,
 /*  2080 */   370,  421,  422,  423,  424,  425,  426,  100,  428,  100,
 /*  2090 */   333,  194,  382,  237,  384,  100,   98,   98,    2,   22,
 /*  2100 */   343,   22,  215,   35,   47,   47,   35,  415,  101,  100,
 /*  2110 */   418,   35,  122,  421,  422,  423,  424,  425,  426,  100,
 /*  2120 */   428,   35,  101,  100,  100,  415,  111,  370,  418,  101,
 /*  2130 */   100,  421,  422,  423,  424,  425,  426,  333,  428,  382,
 /*  2140 */   101,  384,  217,  100,   35,  101,  100,  343,  101,  101,
 /*  2150 */   100,  100,   35,  101,  101,   44,  122,  122,  122,  333,
 /*  2160 */   100,  100,  100,   35,  100,  100,   22,   66,   65,  343,
 /*  2170 */    35,   35,  415,   44,  370,  418,   35,   35,  421,  422,
 /*  2180 */   423,  424,  425,  426,  333,  428,  382,   35,  384,   35,
 /*  2190 */    35,   35,   72,   94,  343,   35,  370,   35,   35,   22,
 /*  2200 */    35,   35,   35,   72,   35,   35,  333,   35,  382,   35,
 /*  2210 */   384,   35,   22,   35,    0,   35,  343,   49,   39,  415,
 /*  2220 */     0,  370,  418,   35,   49,  421,  422,  423,  424,  425,
 /*  2230 */   426,   39,  428,  382,    0,  384,   35,   39,   49,    0,
 /*  2240 */    35,  415,   49,  370,  418,   39,    0,  421,  422,  423,
 /*  2250 */   424,  425,  426,   35,  428,  382,   35,  384,   22,   21,
 /*  2260 */   476,  476,   22,   22,   21,   20,  415,    0,  476,  418,
 /*  2270 */   333,  476,  421,  422,  423,  424,  425,  426,  476,  428,
 /*  2280 */   343,  476,  476,  476,  476,  476,  476,  476,  415,  476,
 /*  2290 */   333,  418,  476,  476,  421,  422,  423,  424,  425,  426,
 /*  2300 */   343,  428,  476,  476,  476,  333,  476,  370,  476,  476,
 /*  2310 */   476,  476,  476,  476,  476,  343,  476,  476,  476,  382,
 /*  2320 */   476,  384,  476,  476,  476,  476,  476,  370,  476,  476,
 /*  2330 */   476,  476,  476,  476,  476,  476,  476,  333,  476,  382,
 /*  2340 */   476,  384,  370,  476,  476,  476,  476,  343,  476,  476,
 /*  2350 */   476,  476,  415,  476,  382,  418,  384,  476,  421,  422,
 /*  2360 */   423,  424,  425,  426,  476,  428,  476,  476,  476,  476,
 /*  2370 */   476,  476,  415,  476,  370,  418,  476,  476,  421,  422,
 /*  2380 */   423,  424,  425,  426,  476,  428,  382,  415,  384,  476,
 /*  2390 */   418,  476,  476,  421,  422,  423,  424,  425,  426,  476,
 /*  2400 */   428,  476,  476,  476,  476,  333,  476,  476,  476,  476,
 /*  2410 */   476,  476,  476,  476,  476,  343,  476,  476,  476,  415,
 /*  2420 */   476,  476,  418,  476,  333,  421,  422,  423,  424,  425,
 /*  2430 */   426,  476,  428,  476,  343,  476,  476,  476,  476,  476,
 /*  2440 */   476,  476,  370,  476,  476,  476,  476,  476,  476,  476,
 /*  2450 */   476,  476,  333,  476,  382,  476,  384,  476,  476,  476,
 /*  2460 */   476,  370,  343,  476,  476,  476,  476,  476,  476,  476,
 /*  2470 */   476,  333,  476,  382,  476,  384,  476,  476,  476,  476,
 /*  2480 */   476,  343,  476,  476,  476,  476,  476,  415,  476,  370,
 /*  2490 */   418,  476,  476,  421,  422,  423,  424,  425,  426,  476,
 /*  2500 */   428,  382,  476,  384,  476,  476,  415,  476,  370,  418,
 /*  2510 */   476,  476,  421,  422,  423,  424,  425,  426,  333,  428,
 /*  2520 */   382,  476,  384,  476,  476,  476,  476,  476,  343,  476,
 /*  2530 */   476,  476,  476,  476,  415,  476,  476,  418,  476,  476,
 /*  2540 */   421,  422,  423,  424,  425,  426,  476,  428,  476,  476,
 /*  2550 */   476,  476,  476,  415,  476,  370,  418,  476,  476,  421,
 /*  2560 */   422,  423,  424,  425,  426,  476,  428,  382,  476,  384,
 /*  2570 */   476,  476,  476,  476,  476,  333,  476,  476,  476,  476,
 /*  2580 */   476,  476,  476,  476,  476,  343,  476,  476,  476,  476,
 /*  2590 */   476,  333,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2600 */   415,  343,  476,  418,  476,  476,  421,  422,  423,  424,
 /*  2610 */   425,  426,  370,  428,  476,  476,  476,  476,  476,  476,
 /*  2620 */   476,  476,  476,  476,  382,  476,  384,  476,  370,  476,
 /*  2630 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2640 */   382,  333,  384,  476,  476,  476,  476,  476,  476,  476,
 /*  2650 */   476,  343,  476,  476,  476,  476,  476,  415,  476,  476,
 /*  2660 */   418,  333,  476,  421,  422,  423,  424,  425,  426,  476,
 /*  2670 */   428,  343,  476,  415,  476,  476,  418,  476,  370,  421,
 /*  2680 */   422,  423,  424,  425,  426,  476,  428,  476,  476,  476,
 /*  2690 */   382,  476,  384,  476,  476,  476,  476,  476,  370,  476,
 /*  2700 */   476,  476,  476,  476,  476,  476,  476,  476,  333,  476,
 /*  2710 */   382,  476,  384,  476,  476,  476,  476,  476,  343,  476,
 /*  2720 */   476,  476,  476,  415,  476,  476,  418,  476,  476,  421,
 /*  2730 */   422,  423,  424,  425,  426,  476,  428,  476,  476,  476,
 /*  2740 */   476,  476,   33,  415,  476,  370,  418,  476,  476,  421,
 /*  2750 */   422,  423,  424,  425,  426,  476,  428,  382,   49,  384,
 /*  2760 */   476,  476,  476,  476,   55,   56,   57,   58,   59,  476,
 /*  2770 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2780 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2790 */   415,  476,  476,  418,  476,  476,  421,  422,  423,  424,
 /*  2800 */   425,  426,  476,  428,  476,  476,  476,  476,   99,  476,
 /*  2810 */   476,  102,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2820 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2830 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2840 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2850 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2860 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2870 */   476,  476,  476,  476,  476,  476,  476,  476,  169,  170,
 /*  2880 */   476,  476,  476,  174,  476,  176,  476,  476,  476,  476,
 /*  2890 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2900 */   476,  476,  476,  194,  476,  476,  476,  476,  476,  476,
 /*  2910 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2920 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2930 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2940 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2950 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2960 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2970 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2980 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  2990 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  3000 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  3010 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  3020 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  3030 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  3040 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  3050 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  3060 */   476,  476,  476,  476,  476,  476,  476,  476,  476,  476,
 /*  3070 */   476,  476,  476,  330,  330,  330,  330,  330,  330,  330,
 /*  3080 */   330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
 /*  3090 */   330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
 /*  3100 */   330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
 /*  3110 */   330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
 /*  3120 */   330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
 /*  3130 */   330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
 /*  3140 */   330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
 /*  3150 */   330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
 /*  3160 */   330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
 /*  3170 */   330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
 /*  3180 */   330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
 /*  3190 */   330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
 /*  3200 */   330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
 /*  3210 */   330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
 /*  3220 */   330,  330,  330,  330,  330,  330,  330,  330,  330,  330,
 /*  3230 */   330,  330,  330,  330,
};
#define YY_SHIFT_COUNT    (761)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2709)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   550,    0,  224,    0,  449,  449,  449,  449,  449,  449,
 /*    10 */   449,  449,  449,  449,  449,  449,  673,  897,  897, 1121,
 /*    20 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*    30 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*    40 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  148,
 /*    50 */   368,   93,   64,  140,  147,  322,  147,   64,   64, 1346,
 /*    60 */  1346, 1346,  147, 1346, 1346,  314,  147,   76,  369,  111,
 /*    70 */   111,  369,  656,  656,   18,  327,    7,    7,  111,  111,
 /*    80 */   111,  111,  111,  111,  111,  145,  111,  111,  248,   76,
 /*    90 */   111,  111,  363,  111,   76,  111,  145,  111,  145,   76,
 /*   100 */   111,  111,   76,  111,   76,   76,   76,  111,  343,  223,
 /*   110 */   189,  189,  405,  114,  443,  443,  443,  443,  443,  443,
 /*   120 */   443,  443,  443,  443,  443,  443,  443,  443,  443,  443,
 /*   130 */   443,  443,  443,  672,  483,   18,  327,  293,  253,  253,
 /*   140 */   253,  217,  622,  622,  293,  523,  523,  523,  248,  460,
 /*   150 */   354,   76,  585,   76,  585,  585,  604,  670,   35,   35,
 /*   160 */    35,   35,   35,   35,   35,   35, 1897,  636,   15,  167,
 /*   170 */    16,  297,  515,  252,  454,  454,  373,  842,  389,  484,
 /*   180 */  1058, 1163,  862,  892,  922,  983,   45,  922,  878,  727,
 /*   190 */   948, 1136, 1347, 1214, 1358, 1382, 1358, 1239, 1390, 1390,
 /*   200 */  1358, 1239, 1239, 1313, 1329, 1390, 1338, 1390, 1390, 1390,
 /*   210 */  1435, 1408, 1435, 1408, 1442,  248, 1457,  248, 1460, 1471,
 /*   220 */   248, 1460,  248,  248,  248, 1390,  248, 1440, 1440, 1435,
 /*   230 */    76,   76,   76,   76,   76,   76,   76,   76,   76,   76,
 /*   240 */    76, 1390, 1435,  585,  585,  585, 1311, 1427, 1442,  343,
 /*   250 */  1356, 1359, 1457,  343, 1362, 1390, 1382, 1382,  585, 1298,
 /*   260 */  1307,  585, 1298, 1307,  585,  585,   76, 1314, 1407, 1298,
 /*   270 */  1317, 1319, 1335, 1136, 1315, 1323, 1327, 1345,  523, 1579,
 /*   280 */  1390, 1460,  343,  343, 1587, 1307,  585,  585,  585,  585,
 /*   290 */   585, 1307,  585, 1445,  343,  604,  343,  523, 1528, 1529,
 /*   300 */   585,  670, 1390,  343, 1600, 1435, 2904, 2904, 2904, 2904,
 /*   310 */  2904, 2904, 2904, 2904, 2904,   34, 2709,  238,  590,  198,
 /*   320 */   539,  973,  794,  486, 1064,  925, 1030,   48,   48,   48,
 /*   330 */    48,   48,   48,   48,   48,   48,  831,  612,   65,   65,
 /*   340 */   549,  737,  700,  891,  262,  448, 1025,  717,  531,  531,
 /*   350 */   962,  751,  906,  962,  962,  962, 1202, 1015,  513, 1219,
 /*   360 */  1008, 1101, 1194, 1104, 1113, 1149, 1159,  381, 1229, 1248,
 /*   370 */  1259, 1267, 1069, 1196, 1221, 1217, 1231, 1233, 1234, 1143,
 /*   380 */   836, 1152, 1165, 1260, 1262, 1273, 1276, 1277, 1318, 1281,
 /*   390 */  1283, 1208, 1284, 1238, 1320, 1321, 1326, 1328, 1336, 1343,
 /*   400 */   671, 1265, 1266, 1255, 1289, 1325, 1366, 1666, 1667, 1669,
 /*   410 */  1631, 1674, 1640, 1468, 1642, 1643, 1644, 1472, 1682, 1648,
 /*   420 */  1649, 1477, 1687, 1480, 1689, 1655, 1699, 1670, 1693, 1659,
 /*   430 */  1500, 1508, 1511, 1701, 1702, 1704, 1523, 1526, 1708, 1715,
 /*   440 */  1672, 1717, 1720, 1722, 1683, 1724, 1726, 1729, 1733, 1735,
 /*   450 */  1736, 1743, 1745, 1591, 1712, 1748, 1594, 1750, 1753, 1754,
 /*   460 */  1764, 1765, 1767, 1768, 1775, 1777, 1778, 1779, 1781, 1782,
 /*   470 */  1784, 1785, 1786, 1716, 1759, 1760, 1761, 1791, 1792, 1793,
 /*   480 */  1772, 1795, 1796, 1797, 1618, 1798, 1800, 1780, 1756, 1783,
 /*   490 */  1758, 1807, 1749, 1776, 1810, 1755, 1812, 1762, 1813, 1816,
 /*   500 */  1788, 1787, 1774, 1773, 1799, 1805, 1802, 1822, 1811, 1789,
 /*   510 */  1823, 1824, 1827, 1794, 1658, 1832, 1838, 1839, 1790, 1853,
 /*   520 */  1855, 1825, 1814, 1828, 1861, 1842, 1829, 1835, 1879, 1845,
 /*   530 */  1833, 1844, 1885, 1858, 1846, 1862, 1902, 1912, 1914, 1915,
 /*   540 */  1808, 1815, 1884, 1898, 1921, 1888, 1889, 1891, 1893, 1894,
 /*   550 */  1896, 1899, 1895, 1900, 1903, 1905, 1910, 1907, 1933, 1913,
 /*   560 */  1943, 1923, 1886, 1947, 1927, 1916, 1959, 1922, 1960, 1928,
 /*   570 */  1962, 1948, 1952, 1938, 1939, 1940, 1875, 1877, 1978, 1817,
 /*   580 */  1880, 1809, 1944, 1961, 1982, 1806, 1964, 1830, 1831, 1997,
 /*   590 */  2000, 1836, 1834, 2002, 1963, 1752, 1906, 1909, 1911, 1965,
 /*   600 */  1917, 1966, 1920, 1918, 1968, 1973, 1919, 1924, 1926, 1929,
 /*   610 */  1931, 1974, 1975, 1976, 1934, 1977, 1771, 1932, 1935, 2025,
 /*   620 */  1993, 1801, 2003, 2005, 2006, 2010, 2011, 2012, 1949, 1950,
 /*   630 */  1992, 1818, 2008, 2001, 2049, 2054, 2055, 2056, 1958, 2020,
 /*   640 */  1773, 2013, 1967, 1969, 1971, 1979, 1987, 1890, 1989, 2063,
 /*   650 */  2026, 1904, 1995, 1954, 1773, 2022, 2033, 1998, 1856, 1999,
 /*   660 */  2096, 2077, 1887, 2009, 2007, 2019, 2021, 2023, 2028, 2057,
 /*   670 */  2024, 2030, 2058, 2039, 2079, 1925, 2043, 2015, 2044, 2068,
 /*   680 */  2071, 2046, 2047, 2076, 2050, 2048, 2086, 2051, 2052, 2109,
 /*   690 */  2060, 2053, 2117, 2061, 1990, 2034, 2035, 2036, 2062, 2111,
 /*   700 */  2064, 2128, 2065, 2111, 2111, 2144, 2101, 2103, 2135, 2136,
 /*   710 */  2141, 2142, 2152, 2154, 2155, 2156, 2120, 2099, 2129, 2160,
 /*   720 */  2162, 2163, 2177, 2165, 2166, 2167, 2131, 1895, 2169, 1900,
 /*   730 */  2170, 2172, 2174, 2176, 2190, 2178, 2214, 2180, 2168, 2179,
 /*   740 */  2220, 2188, 2175, 2192, 2234, 2201, 2189, 2198, 2239, 2205,
 /*   750 */  2193, 2206, 2246, 2218, 2221, 2267, 2236, 2238, 2240, 2241,
 /*   760 */  2243, 2245,
};
#define YY_REDUCE_COUNT (314)
#define YY_REDUCE_MIN   (-397)
#define YY_REDUCE_MAX   (2375)
static const short yy_reduce_ofst[] = {
 /*     0 */  -156,  364,  -82,  588,  -20,  614,  804,  890, 1024, 1050,
 /*    10 */  1118, 1222, 1288, 1316, 1348, 1419,  174, -333,  154,  450,
 /*    20 */   674, 1447, 1097, 1482, 1466, 1543, 1566, 1660, 1692, 1710,
 /*    30 */  1757, 1804, 1826, 1851, 1873, 1937, 1957, 1972, 2004, 2072,
 /*    40 */  2091, 2119, 2138, 2185, 2242, 2258, 2308, 2328, 2375,  383,
 /*    50 */   270, -397,   83, -395,  371,  416,  554,   75,  501,  235,
 /*    60 */   786,  827, -139,  683,  834, -195, -165, -359,  -80, -172,
 /*    70 */   -13, -383, -254, -207, -213,  149,  -52,  290, -152,   -5,
 /*    80 */   263,  376,  407,  413,  453,   82,  508,  593,  462,  271,
 /*    90 */   610,  631,  275,  657,  374,  725,  301,  745,  372, -170,
 /*   100 */   748,  796,  399,  808,  -83,  421,  605,  810,  260, -319,
 /*   110 */  -338, -338, -293, -327,   94,  237,  433,  502,  534,  669,
 /*   120 */   693,  712,  802,  807,  809,  813,  815,  833,  849,  854,
 /*   130 */   865,  867,  868, -275, -251, -131,  355,  467, -251,  437,
 /*   140 */   559,  452,  445,  479,  726, -334,  -85,  719,  681,  168,
 /*   150 */   736,  268,  134,  805,  797,  799,  742,  850, -369,  387,
 /*   160 */   499,  580,  713,  832,  913,  713,  637,  927,  485,  899,
 /*   170 */   818,  835,  949,  839,  941,  945,  940,  940,  980,  939,
 /*   180 */  1032, 1028,  994,  984,  933,  933,  919,  933,  947,  938,
 /*   190 */   940,  974,  976,  996, 1012, 1011, 1018, 1022, 1070, 1071,
 /*   200 */  1026, 1027, 1037, 1063, 1073, 1089, 1083, 1094, 1096, 1099,
 /*   210 */  1123, 1127, 1125, 1130, 1060, 1132, 1100, 1137, 1142, 1090,
 /*   220 */  1144, 1151, 1146, 1147, 1148, 1157, 1153, 1154, 1158, 1169,
 /*   230 */  1138, 1139, 1140, 1141, 1156, 1160, 1161, 1167, 1168, 1175,
 /*   240 */  1177, 1164, 1172, 1131, 1134, 1135, 1110, 1116, 1119, 1187,
 /*   250 */  1145, 1155, 1176, 1201, 1162, 1224, 1179, 1180, 1174, 1108,
 /*   260 */  1171, 1191, 1126, 1184, 1203, 1204,  940, 1128, 1133, 1166,
 /*   270 */  1150, 1170, 1173, 1178, 1122, 1182, 1185,  933, 1251, 1181,
 /*   280 */  1261, 1258, 1263, 1264, 1213, 1212, 1228, 1232, 1235, 1236,
 /*   290 */  1237, 1216, 1241, 1226, 1268, 1269, 1279, 1282, 1192, 1278,
 /*   300 */  1250, 1274, 1291, 1290, 1303, 1306, 1252, 1243, 1244, 1270,
 /*   310 */  1296, 1299, 1300, 1322, 1334,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*    10 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*    20 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*    30 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*    40 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*    50 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*    60 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*    70 */  1719, 1719, 1719, 1719, 1992, 1719, 1719, 1719, 1719, 1719,
 /*    80 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1801, 1719,
 /*    90 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   100 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1799, 1985,
 /*   110 */  2206, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   120 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   130 */  1719, 1719, 1719, 1719, 2218, 1719, 1719, 1719, 2218, 2218,
 /*   140 */  2218, 1799, 2178, 2178, 1719, 1719, 1719, 1719, 1801, 2050,
 /*   150 */  1719, 1719, 1719, 1719, 1719, 1719, 1920, 1719, 1719, 1719,
 /*   160 */  1719, 1719, 1944, 1719, 1719, 1719, 2044, 1719, 1719, 2243,
 /*   170 */  2299, 1719, 1719, 2246, 1719, 1719, 1719, 1719, 1719, 1997,
 /*   180 */  1719, 1719, 1874, 2233, 2210, 2224, 2283, 2211, 2208, 2227,
 /*   190 */  1719, 2237, 1719, 2031, 1990, 1719, 1990, 1987, 1719, 1719,
 /*   200 */  1990, 1987, 1987, 1863, 1859, 1719, 1857, 1719, 1719, 1719,
 /*   210 */  1719, 1766, 1719, 1766, 1719, 1801, 1719, 1801, 1719, 1719,
 /*   220 */  1801, 1719, 1801, 1801, 1801, 1719, 1801, 1779, 1779, 1719,
 /*   230 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   240 */  1719, 1719, 1719, 1719, 1719, 1719, 2062, 2048, 1719, 1799,
 /*   250 */  2042, 2040, 1719, 1799, 2038, 1719, 1719, 1719, 1719, 2254,
 /*   260 */  2252, 1719, 2254, 2252, 1719, 1719, 1719, 2268, 2264, 2254,
 /*   270 */  2272, 2270, 2239, 2237, 2302, 2289, 2285, 2224, 1719, 1719,
 /*   280 */  1719, 1719, 1799, 1799, 1719, 2252, 1719, 1719, 1719, 1719,
 /*   290 */  1719, 2252, 1719, 1719, 1799, 1719, 1799, 1719, 1719, 1890,
 /*   300 */  1719, 1719, 1719, 1799, 1751, 1719, 2033, 2053, 2015, 2015,
 /*   310 */  1923, 1923, 1923, 1802, 1724, 1719, 1719, 1719, 1719, 1719,
 /*   320 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 2267, 2266, 2133,
 /*   330 */  1719, 2182, 2181, 2180, 2171, 2132, 1886, 1719, 2131, 2130,
 /*   340 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 2006, 2005,
 /*   350 */  2124, 1719, 1719, 2125, 2123, 2122, 1719, 1719, 1719, 1719,
 /*   360 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   370 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   380 */  2286, 2290, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 2207,
 /*   390 */  1719, 1719, 1719, 2106, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   400 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   410 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   420 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   430 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   440 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   450 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   460 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   470 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   480 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   490 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   500 */  1719, 1719, 1756, 2111, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   510 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   520 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   530 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   540 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   550 */  1719, 1719, 1840, 1839, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   560 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   570 */  1719, 1719, 1719, 1719, 1719, 1719, 2115, 1719, 1719, 1719,
 /*   580 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   590 */  1719, 1719, 1719, 2282, 2240, 1719, 1719, 1719, 1719, 1719,
 /*   600 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   610 */  1719, 1719, 1719, 2106, 1719, 2265, 1719, 1719, 2280, 1719,
 /*   620 */  2284, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 2217, 2213,
 /*   630 */  1719, 1719, 2209, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   640 */  2114, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   650 */  1719, 1719, 1719, 1719, 2105, 1719, 2168, 1719, 1719, 1719,
 /*   660 */  2202, 1719, 1719, 2153, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   670 */  1719, 1719, 1719, 2115, 1719, 2118, 1719, 1719, 1719, 1719,
 /*   680 */  1719, 1917, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   690 */  1719, 1719, 1719, 1719, 1902, 1900, 1899, 1898, 1719, 1930,
 /*   700 */  1719, 1719, 1719, 1926, 1925, 1719, 1719, 1719, 1719, 1719,
 /*   710 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1820, 1719,
 /*   720 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1812, 1719, 1811,
 /*   730 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   740 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   750 */  1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719,
 /*   760 */  1719, 1719,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*       WITH => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      START => nothing */
    0,  /*  TIMESTAMP => nothing */
  279,  /*        END => ABORT */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*   LANGUAGE => nothing */
    0,  /*    REPLACE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*     LEADER => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  279,  /*      AFTER => ABORT */
  279,  /*     ATTACH => ABORT */
  279,  /*     BEFORE => ABORT */
  279,  /*      BEGIN => ABORT */
  279,  /*     BITAND => ABORT */
  279,  /*     BITNOT => ABORT */
  279,  /*      BITOR => ABORT */
  279,  /*     BLOCKS => ABORT */
  279,  /*     CHANGE => ABORT */
  279,  /*      COMMA => ABORT */
  279,  /*     CONCAT => ABORT */
  279,  /*   CONFLICT => ABORT */
  279,  /*       COPY => ABORT */
  279,  /*   DEFERRED => ABORT */
  279,  /* DELIMITERS => ABORT */
  279,  /*     DETACH => ABORT */
  279,  /*     DIVIDE => ABORT */
  279,  /*        DOT => ABORT */
  279,  /*       EACH => ABORT */
  279,  /*       FAIL => ABORT */
  279,  /*       FILE => ABORT */
  279,  /*        FOR => ABORT */
  279,  /*       GLOB => ABORT */
  279,  /*         ID => ABORT */
  279,  /*  IMMEDIATE => ABORT */
  279,  /*     IMPORT => ABORT */
  279,  /*  INITIALLY => ABORT */
  279,  /*    INSTEAD => ABORT */
  279,  /*     ISNULL => ABORT */
  279,  /*        KEY => ABORT */
  279,  /*    MODULES => ABORT */
  279,  /*  NK_BITNOT => ABORT */
  279,  /*    NK_SEMI => ABORT */
  279,  /*    NOTNULL => ABORT */
  279,  /*         OF => ABORT */
  279,  /*       PLUS => ABORT */
  279,  /*  PRIVILEGE => ABORT */
  279,  /*      RAISE => ABORT */
  279,  /*   RESTRICT => ABORT */
  279,  /*        ROW => ABORT */
  279,  /*       SEMI => ABORT */
  279,  /*       STAR => ABORT */
  279,  /*  STATEMENT => ABORT */
  279,  /*     STRICT => ABORT */
  279,  /*     STRING => ABORT */
  279,  /*      TIMES => ABORT */
  279,  /*     VALUES => ABORT */
  279,  /*   VARIABLE => ABORT */
  279,  /*       VIEW => ABORT */
  279,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "WITH",
  /*   49 */ "DNODE",
  /*   50 */ "PORT",
  /*   51 */ "DNODES",
  /*   52 */ "NK_IPTOKEN",
  /*   53 */ "FORCE",
  /*   54 */ "LOCAL",
  /*   55 */ "QNODE",
  /*   56 */ "BNODE",
  /*   57 */ "SNODE",
  /*   58 */ "MNODE",
  /*   59 */ "DATABASE",
  /*   60 */ "USE",
  /*   61 */ "FLUSH",
  /*   62 */ "TRIM",
  /*   63 */ "COMPACT",
  /*   64 */ "IF",
  /*   65 */ "NOT",
  /*   66 */ "EXISTS",
  /*   67 */ "BUFFER",
  /*   68 */ "CACHEMODEL",
  /*   69 */ "CACHESIZE",
  /*   70 */ "COMP",
  /*   71 */ "DURATION",
  /*   72 */ "NK_VARIABLE",
  /*   73 */ "MAXROWS",
  /*   74 */ "MINROWS",
  /*   75 */ "KEEP",
  /*   76 */ "PAGES",
  /*   77 */ "PAGESIZE",
  /*   78 */ "TSDB_PAGESIZE",
  /*   79 */ "PRECISION",
  /*   80 */ "REPLICA",
  /*   81 */ "VGROUPS",
  /*   82 */ "SINGLE_STABLE",
  /*   83 */ "RETENTIONS",
  /*   84 */ "SCHEMALESS",
  /*   85 */ "WAL_LEVEL",
  /*   86 */ "WAL_FSYNC_PERIOD",
  /*   87 */ "WAL_RETENTION_PERIOD",
  /*   88 */ "WAL_RETENTION_SIZE",
  /*   89 */ "WAL_ROLL_PERIOD",
  /*   90 */ "WAL_SEGMENT_SIZE",
  /*   91 */ "STT_TRIGGER",
  /*   92 */ "TABLE_PREFIX",
  /*   93 */ "TABLE_SUFFIX",
  /*   94 */ "NK_COLON",
  /*   95 */ "MAX_SPEED",
  /*   96 */ "START",
  /*   97 */ "TIMESTAMP",
  /*   98 */ "END",
  /*   99 */ "TABLE",
  /*  100 */ "NK_LP",
  /*  101 */ "NK_RP",
  /*  102 */ "STABLE",
  /*  103 */ "ADD",
  /*  104 */ "COLUMN",
  /*  105 */ "MODIFY",
  /*  106 */ "RENAME",
  /*  107 */ "TAG",
  /*  108 */ "SET",
  /*  109 */ "NK_EQ",
  /*  110 */ "USING",
  /*  111 */ "TAGS",
  /*  112 */ "BOOL",
  /*  113 */ "TINYINT",
  /*  114 */ "SMALLINT",
  /*  115 */ "INT",
  /*  116 */ "INTEGER",
  /*  117 */ "BIGINT",
  /*  118 */ "FLOAT",
  /*  119 */ "DOUBLE",
  /*  120 */ "BINARY",
  /*  121 */ "NCHAR",
  /*  122 */ "UNSIGNED",
  /*  123 */ "JSON",
  /*  124 */ "VARCHAR",
  /*  125 */ "MEDIUMBLOB",
  /*  126 */ "BLOB",
  /*  127 */ "VARBINARY",
  /*  128 */ "DECIMAL",
  /*  129 */ "COMMENT",
  /*  130 */ "MAX_DELAY",
  /*  131 */ "WATERMARK",
  /*  132 */ "ROLLUP",
  /*  133 */ "TTL",
  /*  134 */ "SMA",
  /*  135 */ "DELETE_MARK",
  /*  136 */ "FIRST",
  /*  137 */ "LAST",
  /*  138 */ "SHOW",
  /*  139 */ "PRIVILEGES",
  /*  140 */ "DATABASES",
  /*  141 */ "TABLES",
  /*  142 */ "STABLES",
  /*  143 */ "MNODES",
  /*  144 */ "QNODES",
  /*  145 */ "FUNCTIONS",
  /*  146 */ "INDEXES",
  /*  147 */ "ACCOUNTS",
  /*  148 */ "APPS",
  /*  149 */ "CONNECTIONS",
  /*  150 */ "LICENCES",
  /*  151 */ "GRANTS",
  /*  152 */ "QUERIES",
  /*  153 */ "SCORES",
  /*  154 */ "TOPICS",
  /*  155 */ "VARIABLES",
  /*  156 */ "CLUSTER",
  /*  157 */ "BNODES",
  /*  158 */ "SNODES",
  /*  159 */ "TRANSACTIONS",
  /*  160 */ "DISTRIBUTED",
  /*  161 */ "CONSUMERS",
  /*  162 */ "SUBSCRIPTIONS",
  /*  163 */ "VNODES",
  /*  164 */ "ALIVE",
  /*  165 */ "LIKE",
  /*  166 */ "TBNAME",
  /*  167 */ "QTAGS",
  /*  168 */ "AS",
  /*  169 */ "INDEX",
  /*  170 */ "FUNCTION",
  /*  171 */ "INTERVAL",
  /*  172 */ "COUNT",
  /*  173 */ "LAST_ROW",
  /*  174 */ "TOPIC",
  /*  175 */ "META",
  /*  176 */ "CONSUMER",
  /*  177 */ "GROUP",
  /*  178 */ "DESC",
  /*  179 */ "DESCRIBE",
  /*  180 */ "RESET",
  /*  181 */ "QUERY",
  /*  182 */ "CACHE",
  /*  183 */ "EXPLAIN",
  /*  184 */ "ANALYZE",
  /*  185 */ "VERBOSE",
  /*  186 */ "NK_BOOL",
  /*  187 */ "RATIO",
  /*  188 */ "NK_FLOAT",
  /*  189 */ "OUTPUTTYPE",
  /*  190 */ "AGGREGATE",
  /*  191 */ "BUFSIZE",
  /*  192 */ "LANGUAGE",
  /*  193 */ "REPLACE",
  /*  194 */ "STREAM",
  /*  195 */ "INTO",
  /*  196 */ "TRIGGER",
  /*  197 */ "AT_ONCE",
  /*  198 */ "WINDOW_CLOSE",
  /*  199 */ "IGNORE",
  /*  200 */ "EXPIRED",
  /*  201 */ "FILL_HISTORY",
  /*  202 */ "UPDATE",
  /*  203 */ "SUBTABLE",
  /*  204 */ "KILL",
  /*  205 */ "CONNECTION",
  /*  206 */ "TRANSACTION",
  /*  207 */ "BALANCE",
  /*  208 */ "VGROUP",
  /*  209 */ "LEADER",
  /*  210 */ "MERGE",
  /*  211 */ "REDISTRIBUTE",
  /*  212 */ "SPLIT",
  /*  213 */ "DELETE",
  /*  214 */ "INSERT",
  /*  215 */ "NULL",
  /*  216 */ "NK_QUESTION",
  /*  217 */ "NK_ARROW",
  /*  218 */ "ROWTS",
  /*  219 */ "QSTART",
  /*  220 */ "QEND",
  /*  221 */ "QDURATION",
  /*  222 */ "WSTART",
  /*  223 */ "WEND",
  /*  224 */ "WDURATION",
  /*  225 */ "IROWTS",
  /*  226 */ "ISFILLED",
  /*  227 */ "CAST",
  /*  228 */ "NOW",
  /*  229 */ "TODAY",
  /*  230 */ "TIMEZONE",
  /*  231 */ "CLIENT_VERSION",
  /*  232 */ "SERVER_VERSION",
  /*  233 */ "SERVER_STATUS",
  /*  234 */ "CURRENT_USER",
  /*  235 */ "CASE",
  /*  236 */ "WHEN",
  /*  237 */ "THEN",
  /*  238 */ "ELSE",
  /*  239 */ "BETWEEN",
  /*  240 */ "IS",
  /*  241 */ "NK_LT",
  /*  242 */ "NK_GT",
  /*  243 */ "NK_LE",
  /*  244 */ "NK_GE",
  /*  245 */ "NK_NE",
  /*  246 */ "MATCH",
  /*  247 */ "NMATCH",
  /*  248 */ "CONTAINS",
  /*  249 */ "IN",
  /*  250 */ "JOIN",
  /*  251 */ "INNER",
  /*  252 */ "SELECT",
  /*  253 */ "DISTINCT",
  /*  254 */ "WHERE",
  /*  255 */ "PARTITION",
  /*  256 */ "BY",
  /*  257 */ "SESSION",
  /*  258 */ "STATE_WINDOW",
  /*  259 */ "EVENT_WINDOW",
  /*  260 */ "SLIDING",
  /*  261 */ "FILL",
  /*  262 */ "VALUE",
  /*  263 */ "VALUE_F",
  /*  264 */ "NONE",
  /*  265 */ "PREV",
  /*  266 */ "NULL_F",
  /*  267 */ "LINEAR",
  /*  268 */ "NEXT",
  /*  269 */ "HAVING",
  /*  270 */ "RANGE",
  /*  271 */ "EVERY",
  /*  272 */ "ORDER",
  /*  273 */ "SLIMIT",
  /*  274 */ "SOFFSET",
  /*  275 */ "LIMIT",
  /*  276 */ "OFFSET",
  /*  277 */ "ASC",
  /*  278 */ "NULLS",
  /*  279 */ "ABORT",
  /*  280 */ "AFTER",
  /*  281 */ "ATTACH",
  /*  282 */ "BEFORE",
  /*  283 */ "BEGIN",
  /*  284 */ "BITAND",
  /*  285 */ "BITNOT",
  /*  286 */ "BITOR",
  /*  287 */ "BLOCKS",
  /*  288 */ "CHANGE",
  /*  289 */ "COMMA",
  /*  290 */ "CONCAT",
  /*  291 */ "CONFLICT",
  /*  292 */ "COPY",
  /*  293 */ "DEFERRED",
  /*  294 */ "DELIMITERS",
  /*  295 */ "DETACH",
  /*  296 */ "DIVIDE",
  /*  297 */ "DOT",
  /*  298 */ "EACH",
  /*  299 */ "FAIL",
  /*  300 */ "FILE",
  /*  301 */ "FOR",
  /*  302 */ "GLOB",
  /*  303 */ "ID",
  /*  304 */ "IMMEDIATE",
  /*  305 */ "IMPORT",
  /*  306 */ "INITIALLY",
  /*  307 */ "INSTEAD",
  /*  308 */ "ISNULL",
  /*  309 */ "KEY",
  /*  310 */ "MODULES",
  /*  311 */ "NK_BITNOT",
  /*  312 */ "NK_SEMI",
  /*  313 */ "NOTNULL",
  /*  314 */ "OF",
  /*  315 */ "PLUS",
  /*  316 */ "PRIVILEGE",
  /*  317 */ "RAISE",
  /*  318 */ "RESTRICT",
  /*  319 */ "ROW",
  /*  320 */ "SEMI",
  /*  321 */ "STAR",
  /*  322 */ "STATEMENT",
  /*  323 */ "STRICT",
  /*  324 */ "STRING",
  /*  325 */ "TIMES",
  /*  326 */ "VALUES",
  /*  327 */ "VARIABLE",
  /*  328 */ "VIEW",
  /*  329 */ "WAL",
  /*  330 */ "cmd",
  /*  331 */ "account_options",
  /*  332 */ "alter_account_options",
  /*  333 */ "literal",
  /*  334 */ "alter_account_option",
  /*  335 */ "user_name",
  /*  336 */ "sysinfo_opt",
  /*  337 */ "privileges",
  /*  338 */ "priv_level",
  /*  339 */ "with_opt",
  /*  340 */ "priv_type_list",
  /*  341 */ "priv_type",
  /*  342 */ "db_name",
  /*  343 */ "table_name",
  /*  344 */ "topic_name",
  /*  345 */ "search_condition",
  /*  346 */ "dnode_endpoint",
  /*  347 */ "force_opt",
  /*  348 */ "not_exists_opt",
  /*  349 */ "db_options",
  /*  350 */ "exists_opt",
  /*  351 */ "alter_db_options",
  /*  352 */ "speed_opt",
  /*  353 */ "start_opt",
  /*  354 */ "end_opt",
  /*  355 */ "integer_list",
  /*  356 */ "variable_list",
  /*  357 */ "retention_list",
  /*  358 */ "signed",
  /*  359 */ "alter_db_option",
  /*  360 */ "retention",
  /*  361 */ "full_table_name",
  /*  362 */ "column_def_list",
  /*  363 */ "tags_def_opt",
  /*  364 */ "table_options",
  /*  365 */ "multi_create_clause",
  /*  366 */ "tags_def",
  /*  367 */ "multi_drop_clause",
  /*  368 */ "alter_table_clause",
  /*  369 */ "alter_table_options",
  /*  370 */ "column_name",
  /*  371 */ "type_name",
  /*  372 */ "signed_literal",
  /*  373 */ "create_subtable_clause",
  /*  374 */ "specific_cols_opt",
  /*  375 */ "expression_list",
  /*  376 */ "drop_table_clause",
  /*  377 */ "col_name_list",
  /*  378 */ "column_def",
  /*  379 */ "duration_list",
  /*  380 */ "rollup_func_list",
  /*  381 */ "alter_table_option",
  /*  382 */ "duration_literal",
  /*  383 */ "rollup_func_name",
  /*  384 */ "function_name",
  /*  385 */ "col_name",
  /*  386 */ "db_name_cond_opt",
  /*  387 */ "like_pattern_opt",
  /*  388 */ "table_name_cond",
  /*  389 */ "from_db_opt",
  /*  390 */ "tag_list_opt",
  /*  391 */ "tag_item",
  /*  392 */ "column_alias",
  /*  393 */ "full_index_name",
  /*  394 */ "index_options",
  /*  395 */ "index_name",
  /*  396 */ "func_list",
  /*  397 */ "sliding_opt",
  /*  398 */ "sma_stream_opt",
  /*  399 */ "func",
  /*  400 */ "sma_func_name",
  /*  401 */ "query_or_subquery",
  /*  402 */ "cgroup_name",
  /*  403 */ "analyze_opt",
  /*  404 */ "explain_options",
  /*  405 */ "insert_query",
  /*  406 */ "or_replace_opt",
  /*  407 */ "agg_func_opt",
  /*  408 */ "bufsize_opt",
  /*  409 */ "language_opt",
  /*  410 */ "stream_name",
  /*  411 */ "stream_options",
  /*  412 */ "col_list_opt",
  /*  413 */ "tag_def_or_ref_opt",
  /*  414 */ "subtable_opt",
  /*  415 */ "expression",
  /*  416 */ "dnode_list",
  /*  417 */ "where_clause_opt",
  /*  418 */ "literal_func",
  /*  419 */ "literal_list",
  /*  420 */ "table_alias",
  /*  421 */ "expr_or_subquery",
  /*  422 */ "pseudo_column",
  /*  423 */ "column_reference",
  /*  424 */ "function_expression",
  /*  425 */ "case_when_expression",
  /*  426 */ "star_func",
  /*  427 */ "star_func_para_list",
  /*  428 */ "noarg_func",
  /*  429 */ "other_para_list",
  /*  430 */ "star_func_para",
  /*  431 */ "when_then_list",
  /*  432 */ "case_when_else_opt",
  /*  433 */ "common_expression",
  /*  434 */ "when_then_expr",
  /*  435 */ "predicate",
  /*  436 */ "compare_op",
  /*  437 */ "in_op",
  /*  438 */ "in_predicate_value",
  /*  439 */ "boolean_value_expression",
  /*  440 */ "boolean_primary",
  /*  441 */ "from_clause_opt",
  /*  442 */ "table_reference_list",
  /*  443 */ "table_reference",
  /*  444 */ "table_primary",
  /*  445 */ "joined_table",
  /*  446 */ "alias_opt",
  /*  447 */ "subquery",
  /*  448 */ "parenthesized_joined_table",
  /*  449 */ "join_type",
  /*  450 */ "query_specification",
  /*  451 */ "set_quantifier_opt",
  /*  452 */ "select_list",
  /*  453 */ "partition_by_clause_opt",
  /*  454 */ "range_opt",
  /*  455 */ "every_opt",
  /*  456 */ "fill_opt",
  /*  457 */ "twindow_clause_opt",
  /*  458 */ "group_by_clause_opt",
  /*  459 */ "having_clause_opt",
  /*  460 */ "select_item",
  /*  461 */ "partition_list",
  /*  462 */ "partition_item",
  /*  463 */ "fill_mode",
  /*  464 */ "group_by_list",
  /*  465 */ "query_expression",
  /*  466 */ "query_simple",
  /*  467 */ "order_by_clause_opt",
  /*  468 */ "slimit_clause_opt",
  /*  469 */ "limit_clause_opt",
  /*  470 */ "union_query_expression",
  /*  471 */ "query_simple_or_subquery",
  /*  472 */ "sort_specification_list",
  /*  473 */ "sort_specification",
  /*  474 */ "ordering_specification_opt",
  /*  475 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level with_opt TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= db_name NK_DOT table_name",
 /*  43 */ "priv_level ::= topic_name",
 /*  44 */ "with_opt ::=",
 /*  45 */ "with_opt ::= WITH search_condition",
 /*  46 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  47 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  48 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  49 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  50 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  51 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  52 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  53 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  54 */ "dnode_endpoint ::= NK_STRING",
 /*  55 */ "dnode_endpoint ::= NK_ID",
 /*  56 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  57 */ "force_opt ::=",
 /*  58 */ "force_opt ::= FORCE",
 /*  59 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  60 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  61 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  67 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  68 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  69 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  70 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  71 */ "cmd ::= USE db_name",
 /*  72 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  73 */ "cmd ::= FLUSH DATABASE db_name",
 /*  74 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  75 */ "cmd ::= COMPACT DATABASE db_name start_opt end_opt",
 /*  76 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  77 */ "not_exists_opt ::=",
 /*  78 */ "exists_opt ::= IF EXISTS",
 /*  79 */ "exists_opt ::=",
 /*  80 */ "db_options ::=",
 /*  81 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  82 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  83 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  84 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  85 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  86 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  87 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  88 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  89 */ "db_options ::= db_options KEEP integer_list",
 /*  90 */ "db_options ::= db_options KEEP variable_list",
 /*  91 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  92 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  93 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  94 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  95 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  96 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  97 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  98 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  99 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 106 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 107 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 108 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 109 */ "db_options ::= db_options TABLE_PREFIX signed",
 /* 110 */ "db_options ::= db_options TABLE_SUFFIX signed",
 /* 111 */ "alter_db_options ::= alter_db_option",
 /* 112 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 113 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 114 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 115 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 116 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 117 */ "alter_db_option ::= KEEP integer_list",
 /* 118 */ "alter_db_option ::= KEEP variable_list",
 /* 119 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 120 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 121 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 122 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 123 */ "alter_db_option ::= MINROWS NK_INTEGER",
 /* 124 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER",
 /* 125 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 126 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER",
 /* 127 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 128 */ "integer_list ::= NK_INTEGER",
 /* 129 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 130 */ "variable_list ::= NK_VARIABLE",
 /* 131 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 132 */ "retention_list ::= retention",
 /* 133 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 134 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 135 */ "speed_opt ::=",
 /* 136 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 137 */ "start_opt ::=",
 /* 138 */ "start_opt ::= START WITH NK_INTEGER",
 /* 139 */ "start_opt ::= START WITH NK_STRING",
 /* 140 */ "start_opt ::= START WITH TIMESTAMP NK_STRING",
 /* 141 */ "end_opt ::=",
 /* 142 */ "end_opt ::= END WITH NK_INTEGER",
 /* 143 */ "end_opt ::= END WITH NK_STRING",
 /* 144 */ "end_opt ::= END WITH TIMESTAMP NK_STRING",
 /* 145 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 146 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 147 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 148 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 149 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 150 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 151 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 152 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 153 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 154 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 155 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 156 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 157 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 158 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 159 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 160 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 161 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 162 */ "multi_create_clause ::= create_subtable_clause",
 /* 163 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 164 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 165 */ "multi_drop_clause ::= drop_table_clause",
 /* 166 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 167 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 168 */ "specific_cols_opt ::=",
 /* 169 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 170 */ "full_table_name ::= table_name",
 /* 171 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 172 */ "column_def_list ::= column_def",
 /* 173 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 174 */ "column_def ::= column_name type_name",
 /* 175 */ "type_name ::= BOOL",
 /* 176 */ "type_name ::= TINYINT",
 /* 177 */ "type_name ::= SMALLINT",
 /* 178 */ "type_name ::= INT",
 /* 179 */ "type_name ::= INTEGER",
 /* 180 */ "type_name ::= BIGINT",
 /* 181 */ "type_name ::= FLOAT",
 /* 182 */ "type_name ::= DOUBLE",
 /* 183 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 184 */ "type_name ::= TIMESTAMP",
 /* 185 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 186 */ "type_name ::= TINYINT UNSIGNED",
 /* 187 */ "type_name ::= SMALLINT UNSIGNED",
 /* 188 */ "type_name ::= INT UNSIGNED",
 /* 189 */ "type_name ::= BIGINT UNSIGNED",
 /* 190 */ "type_name ::= JSON",
 /* 191 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 192 */ "type_name ::= MEDIUMBLOB",
 /* 193 */ "type_name ::= BLOB",
 /* 194 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 195 */ "type_name ::= DECIMAL",
 /* 196 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 197 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 198 */ "tags_def_opt ::=",
 /* 199 */ "tags_def_opt ::= tags_def",
 /* 200 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 201 */ "table_options ::=",
 /* 202 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 203 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 204 */ "table_options ::= table_options WATERMARK duration_list",
 /* 205 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 206 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 207 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 208 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 209 */ "alter_table_options ::= alter_table_option",
 /* 210 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 211 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 212 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 213 */ "duration_list ::= duration_literal",
 /* 214 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 215 */ "rollup_func_list ::= rollup_func_name",
 /* 216 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 217 */ "rollup_func_name ::= function_name",
 /* 218 */ "rollup_func_name ::= FIRST",
 /* 219 */ "rollup_func_name ::= LAST",
 /* 220 */ "col_name_list ::= col_name",
 /* 221 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 222 */ "col_name ::= column_name",
 /* 223 */ "cmd ::= SHOW DNODES",
 /* 224 */ "cmd ::= SHOW USERS",
 /* 225 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 226 */ "cmd ::= SHOW DATABASES",
 /* 227 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 228 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 229 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 230 */ "cmd ::= SHOW MNODES",
 /* 231 */ "cmd ::= SHOW QNODES",
 /* 232 */ "cmd ::= SHOW FUNCTIONS",
 /* 233 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 234 */ "cmd ::= SHOW STREAMS",
 /* 235 */ "cmd ::= SHOW ACCOUNTS",
 /* 236 */ "cmd ::= SHOW APPS",
 /* 237 */ "cmd ::= SHOW CONNECTIONS",
 /* 238 */ "cmd ::= SHOW LICENCES",
 /* 239 */ "cmd ::= SHOW GRANTS",
 /* 240 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 241 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 242 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 243 */ "cmd ::= SHOW QUERIES",
 /* 244 */ "cmd ::= SHOW SCORES",
 /* 245 */ "cmd ::= SHOW TOPICS",
 /* 246 */ "cmd ::= SHOW VARIABLES",
 /* 247 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 248 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 249 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 250 */ "cmd ::= SHOW BNODES",
 /* 251 */ "cmd ::= SHOW SNODES",
 /* 252 */ "cmd ::= SHOW CLUSTER",
 /* 253 */ "cmd ::= SHOW TRANSACTIONS",
 /* 254 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 255 */ "cmd ::= SHOW CONSUMERS",
 /* 256 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 257 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 258 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 259 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 260 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 261 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 262 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 263 */ "db_name_cond_opt ::=",
 /* 264 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 265 */ "like_pattern_opt ::=",
 /* 266 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 267 */ "table_name_cond ::= table_name",
 /* 268 */ "from_db_opt ::=",
 /* 269 */ "from_db_opt ::= FROM db_name",
 /* 270 */ "tag_list_opt ::=",
 /* 271 */ "tag_list_opt ::= tag_item",
 /* 272 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 273 */ "tag_item ::= TBNAME",
 /* 274 */ "tag_item ::= QTAGS",
 /* 275 */ "tag_item ::= column_name",
 /* 276 */ "tag_item ::= column_name column_alias",
 /* 277 */ "tag_item ::= column_name AS column_alias",
 /* 278 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 279 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 280 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 281 */ "full_index_name ::= index_name",
 /* 282 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 283 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 284 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 285 */ "func_list ::= func",
 /* 286 */ "func_list ::= func_list NK_COMMA func",
 /* 287 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 288 */ "sma_func_name ::= function_name",
 /* 289 */ "sma_func_name ::= COUNT",
 /* 290 */ "sma_func_name ::= FIRST",
 /* 291 */ "sma_func_name ::= LAST",
 /* 292 */ "sma_func_name ::= LAST_ROW",
 /* 293 */ "sma_stream_opt ::=",
 /* 294 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 295 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 296 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 297 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 298 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 299 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 300 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 301 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 302 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 303 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 304 */ "cmd ::= DESC full_table_name",
 /* 305 */ "cmd ::= DESCRIBE full_table_name",
 /* 306 */ "cmd ::= RESET QUERY CACHE",
 /* 307 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 308 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 309 */ "analyze_opt ::=",
 /* 310 */ "analyze_opt ::= ANALYZE",
 /* 311 */ "explain_options ::=",
 /* 312 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 313 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 314 */ "cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt",
 /* 315 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 316 */ "agg_func_opt ::=",
 /* 317 */ "agg_func_opt ::= AGGREGATE",
 /* 318 */ "bufsize_opt ::=",
 /* 319 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 320 */ "language_opt ::=",
 /* 321 */ "language_opt ::= LANGUAGE NK_STRING",
 /* 322 */ "or_replace_opt ::=",
 /* 323 */ "or_replace_opt ::= OR REPLACE",
 /* 324 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 325 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 326 */ "col_list_opt ::=",
 /* 327 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 328 */ "tag_def_or_ref_opt ::=",
 /* 329 */ "tag_def_or_ref_opt ::= tags_def",
 /* 330 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 331 */ "stream_options ::=",
 /* 332 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 333 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 334 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 335 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 336 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 337 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 338 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 339 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 340 */ "subtable_opt ::=",
 /* 341 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 342 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 343 */ "cmd ::= KILL QUERY NK_STRING",
 /* 344 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 345 */ "cmd ::= BALANCE VGROUP",
 /* 346 */ "cmd ::= BALANCE VGROUP LEADER",
 /* 347 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 348 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 349 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 350 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 351 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 352 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 353 */ "cmd ::= query_or_subquery",
 /* 354 */ "cmd ::= insert_query",
 /* 355 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 356 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 357 */ "literal ::= NK_INTEGER",
 /* 358 */ "literal ::= NK_FLOAT",
 /* 359 */ "literal ::= NK_STRING",
 /* 360 */ "literal ::= NK_BOOL",
 /* 361 */ "literal ::= TIMESTAMP NK_STRING",
 /* 362 */ "literal ::= duration_literal",
 /* 363 */ "literal ::= NULL",
 /* 364 */ "literal ::= NK_QUESTION",
 /* 365 */ "duration_literal ::= NK_VARIABLE",
 /* 366 */ "signed ::= NK_INTEGER",
 /* 367 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 368 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 369 */ "signed ::= NK_FLOAT",
 /* 370 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 371 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 372 */ "signed_literal ::= signed",
 /* 373 */ "signed_literal ::= NK_STRING",
 /* 374 */ "signed_literal ::= NK_BOOL",
 /* 375 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 376 */ "signed_literal ::= duration_literal",
 /* 377 */ "signed_literal ::= NULL",
 /* 378 */ "signed_literal ::= literal_func",
 /* 379 */ "signed_literal ::= NK_QUESTION",
 /* 380 */ "literal_list ::= signed_literal",
 /* 381 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 382 */ "db_name ::= NK_ID",
 /* 383 */ "table_name ::= NK_ID",
 /* 384 */ "column_name ::= NK_ID",
 /* 385 */ "function_name ::= NK_ID",
 /* 386 */ "table_alias ::= NK_ID",
 /* 387 */ "column_alias ::= NK_ID",
 /* 388 */ "user_name ::= NK_ID",
 /* 389 */ "topic_name ::= NK_ID",
 /* 390 */ "stream_name ::= NK_ID",
 /* 391 */ "cgroup_name ::= NK_ID",
 /* 392 */ "index_name ::= NK_ID",
 /* 393 */ "expr_or_subquery ::= expression",
 /* 394 */ "expression ::= literal",
 /* 395 */ "expression ::= pseudo_column",
 /* 396 */ "expression ::= column_reference",
 /* 397 */ "expression ::= function_expression",
 /* 398 */ "expression ::= case_when_expression",
 /* 399 */ "expression ::= NK_LP expression NK_RP",
 /* 400 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 401 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 402 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 403 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 404 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 405 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 406 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 407 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 408 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 409 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 410 */ "expression_list ::= expr_or_subquery",
 /* 411 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 412 */ "column_reference ::= column_name",
 /* 413 */ "column_reference ::= table_name NK_DOT column_name",
 /* 414 */ "pseudo_column ::= ROWTS",
 /* 415 */ "pseudo_column ::= TBNAME",
 /* 416 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 417 */ "pseudo_column ::= QSTART",
 /* 418 */ "pseudo_column ::= QEND",
 /* 419 */ "pseudo_column ::= QDURATION",
 /* 420 */ "pseudo_column ::= WSTART",
 /* 421 */ "pseudo_column ::= WEND",
 /* 422 */ "pseudo_column ::= WDURATION",
 /* 423 */ "pseudo_column ::= IROWTS",
 /* 424 */ "pseudo_column ::= ISFILLED",
 /* 425 */ "pseudo_column ::= QTAGS",
 /* 426 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 427 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 428 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 429 */ "function_expression ::= literal_func",
 /* 430 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 431 */ "literal_func ::= NOW",
 /* 432 */ "noarg_func ::= NOW",
 /* 433 */ "noarg_func ::= TODAY",
 /* 434 */ "noarg_func ::= TIMEZONE",
 /* 435 */ "noarg_func ::= DATABASE",
 /* 436 */ "noarg_func ::= CLIENT_VERSION",
 /* 437 */ "noarg_func ::= SERVER_VERSION",
 /* 438 */ "noarg_func ::= SERVER_STATUS",
 /* 439 */ "noarg_func ::= CURRENT_USER",
 /* 440 */ "noarg_func ::= USER",
 /* 441 */ "star_func ::= COUNT",
 /* 442 */ "star_func ::= FIRST",
 /* 443 */ "star_func ::= LAST",
 /* 444 */ "star_func ::= LAST_ROW",
 /* 445 */ "star_func_para_list ::= NK_STAR",
 /* 446 */ "star_func_para_list ::= other_para_list",
 /* 447 */ "other_para_list ::= star_func_para",
 /* 448 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 449 */ "star_func_para ::= expr_or_subquery",
 /* 450 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 451 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 452 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 453 */ "when_then_list ::= when_then_expr",
 /* 454 */ "when_then_list ::= when_then_list when_then_expr",
 /* 455 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 456 */ "case_when_else_opt ::=",
 /* 457 */ "case_when_else_opt ::= ELSE common_expression",
 /* 458 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 459 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 460 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 461 */ "predicate ::= expr_or_subquery IS NULL",
 /* 462 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 463 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 464 */ "compare_op ::= NK_LT",
 /* 465 */ "compare_op ::= NK_GT",
 /* 466 */ "compare_op ::= NK_LE",
 /* 467 */ "compare_op ::= NK_GE",
 /* 468 */ "compare_op ::= NK_NE",
 /* 469 */ "compare_op ::= NK_EQ",
 /* 470 */ "compare_op ::= LIKE",
 /* 471 */ "compare_op ::= NOT LIKE",
 /* 472 */ "compare_op ::= MATCH",
 /* 473 */ "compare_op ::= NMATCH",
 /* 474 */ "compare_op ::= CONTAINS",
 /* 475 */ "in_op ::= IN",
 /* 476 */ "in_op ::= NOT IN",
 /* 477 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 478 */ "boolean_value_expression ::= boolean_primary",
 /* 479 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 480 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 481 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 482 */ "boolean_primary ::= predicate",
 /* 483 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 484 */ "common_expression ::= expr_or_subquery",
 /* 485 */ "common_expression ::= boolean_value_expression",
 /* 486 */ "from_clause_opt ::=",
 /* 487 */ "from_clause_opt ::= FROM table_reference_list",
 /* 488 */ "table_reference_list ::= table_reference",
 /* 489 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 490 */ "table_reference ::= table_primary",
 /* 491 */ "table_reference ::= joined_table",
 /* 492 */ "table_primary ::= table_name alias_opt",
 /* 493 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 494 */ "table_primary ::= subquery alias_opt",
 /* 495 */ "table_primary ::= parenthesized_joined_table",
 /* 496 */ "alias_opt ::=",
 /* 497 */ "alias_opt ::= table_alias",
 /* 498 */ "alias_opt ::= AS table_alias",
 /* 499 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 500 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 501 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 502 */ "join_type ::=",
 /* 503 */ "join_type ::= INNER",
 /* 504 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 505 */ "set_quantifier_opt ::=",
 /* 506 */ "set_quantifier_opt ::= DISTINCT",
 /* 507 */ "set_quantifier_opt ::= ALL",
 /* 508 */ "select_list ::= select_item",
 /* 509 */ "select_list ::= select_list NK_COMMA select_item",
 /* 510 */ "select_item ::= NK_STAR",
 /* 511 */ "select_item ::= common_expression",
 /* 512 */ "select_item ::= common_expression column_alias",
 /* 513 */ "select_item ::= common_expression AS column_alias",
 /* 514 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 515 */ "where_clause_opt ::=",
 /* 516 */ "where_clause_opt ::= WHERE search_condition",
 /* 517 */ "partition_by_clause_opt ::=",
 /* 518 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 519 */ "partition_list ::= partition_item",
 /* 520 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 521 */ "partition_item ::= expr_or_subquery",
 /* 522 */ "partition_item ::= expr_or_subquery column_alias",
 /* 523 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 524 */ "twindow_clause_opt ::=",
 /* 525 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 526 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 527 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 528 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 529 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 530 */ "sliding_opt ::=",
 /* 531 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 532 */ "fill_opt ::=",
 /* 533 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 534 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 535 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP",
 /* 536 */ "fill_mode ::= NONE",
 /* 537 */ "fill_mode ::= PREV",
 /* 538 */ "fill_mode ::= NULL",
 /* 539 */ "fill_mode ::= NULL_F",
 /* 540 */ "fill_mode ::= LINEAR",
 /* 541 */ "fill_mode ::= NEXT",
 /* 542 */ "group_by_clause_opt ::=",
 /* 543 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 544 */ "group_by_list ::= expr_or_subquery",
 /* 545 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 546 */ "having_clause_opt ::=",
 /* 547 */ "having_clause_opt ::= HAVING search_condition",
 /* 548 */ "range_opt ::=",
 /* 549 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 550 */ "every_opt ::=",
 /* 551 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 552 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 553 */ "query_simple ::= query_specification",
 /* 554 */ "query_simple ::= union_query_expression",
 /* 555 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 556 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 557 */ "query_simple_or_subquery ::= query_simple",
 /* 558 */ "query_simple_or_subquery ::= subquery",
 /* 559 */ "query_or_subquery ::= query_expression",
 /* 560 */ "query_or_subquery ::= subquery",
 /* 561 */ "order_by_clause_opt ::=",
 /* 562 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 563 */ "slimit_clause_opt ::=",
 /* 564 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 565 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 566 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 567 */ "limit_clause_opt ::=",
 /* 568 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 569 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 570 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 571 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 572 */ "subquery ::= NK_LP subquery NK_RP",
 /* 573 */ "search_condition ::= common_expression",
 /* 574 */ "sort_specification_list ::= sort_specification",
 /* 575 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 576 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 577 */ "ordering_specification_opt ::=",
 /* 578 */ "ordering_specification_opt ::= ASC",
 /* 579 */ "ordering_specification_opt ::= DESC",
 /* 580 */ "null_ordering_opt ::=",
 /* 581 */ "null_ordering_opt ::= NULLS FIRST",
 /* 582 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 330: /* cmd */
    case 333: /* literal */
    case 339: /* with_opt */
    case 345: /* search_condition */
    case 349: /* db_options */
    case 351: /* alter_db_options */
    case 353: /* start_opt */
    case 354: /* end_opt */
    case 358: /* signed */
    case 360: /* retention */
    case 361: /* full_table_name */
    case 364: /* table_options */
    case 368: /* alter_table_clause */
    case 369: /* alter_table_options */
    case 372: /* signed_literal */
    case 373: /* create_subtable_clause */
    case 376: /* drop_table_clause */
    case 378: /* column_def */
    case 382: /* duration_literal */
    case 383: /* rollup_func_name */
    case 385: /* col_name */
    case 386: /* db_name_cond_opt */
    case 387: /* like_pattern_opt */
    case 388: /* table_name_cond */
    case 389: /* from_db_opt */
    case 391: /* tag_item */
    case 393: /* full_index_name */
    case 394: /* index_options */
    case 397: /* sliding_opt */
    case 398: /* sma_stream_opt */
    case 399: /* func */
    case 401: /* query_or_subquery */
    case 404: /* explain_options */
    case 405: /* insert_query */
    case 411: /* stream_options */
    case 414: /* subtable_opt */
    case 415: /* expression */
    case 417: /* where_clause_opt */
    case 418: /* literal_func */
    case 421: /* expr_or_subquery */
    case 422: /* pseudo_column */
    case 423: /* column_reference */
    case 424: /* function_expression */
    case 425: /* case_when_expression */
    case 430: /* star_func_para */
    case 432: /* case_when_else_opt */
    case 433: /* common_expression */
    case 434: /* when_then_expr */
    case 435: /* predicate */
    case 438: /* in_predicate_value */
    case 439: /* boolean_value_expression */
    case 440: /* boolean_primary */
    case 441: /* from_clause_opt */
    case 442: /* table_reference_list */
    case 443: /* table_reference */
    case 444: /* table_primary */
    case 445: /* joined_table */
    case 447: /* subquery */
    case 448: /* parenthesized_joined_table */
    case 450: /* query_specification */
    case 454: /* range_opt */
    case 455: /* every_opt */
    case 456: /* fill_opt */
    case 457: /* twindow_clause_opt */
    case 459: /* having_clause_opt */
    case 460: /* select_item */
    case 462: /* partition_item */
    case 465: /* query_expression */
    case 466: /* query_simple */
    case 468: /* slimit_clause_opt */
    case 469: /* limit_clause_opt */
    case 470: /* union_query_expression */
    case 471: /* query_simple_or_subquery */
    case 473: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy448)); 
}
      break;
    case 331: /* account_options */
    case 332: /* alter_account_options */
    case 334: /* alter_account_option */
    case 352: /* speed_opt */
    case 408: /* bufsize_opt */
{
 
}
      break;
    case 335: /* user_name */
    case 342: /* db_name */
    case 343: /* table_name */
    case 344: /* topic_name */
    case 346: /* dnode_endpoint */
    case 370: /* column_name */
    case 384: /* function_name */
    case 392: /* column_alias */
    case 395: /* index_name */
    case 400: /* sma_func_name */
    case 402: /* cgroup_name */
    case 409: /* language_opt */
    case 410: /* stream_name */
    case 420: /* table_alias */
    case 426: /* star_func */
    case 428: /* noarg_func */
    case 446: /* alias_opt */
{
 
}
      break;
    case 336: /* sysinfo_opt */
{
 
}
      break;
    case 337: /* privileges */
    case 340: /* priv_type_list */
    case 341: /* priv_type */
{
 
}
      break;
    case 338: /* priv_level */
{
 
}
      break;
    case 347: /* force_opt */
    case 348: /* not_exists_opt */
    case 350: /* exists_opt */
    case 403: /* analyze_opt */
    case 406: /* or_replace_opt */
    case 407: /* agg_func_opt */
    case 451: /* set_quantifier_opt */
{
 
}
      break;
    case 355: /* integer_list */
    case 356: /* variable_list */
    case 357: /* retention_list */
    case 362: /* column_def_list */
    case 363: /* tags_def_opt */
    case 365: /* multi_create_clause */
    case 366: /* tags_def */
    case 367: /* multi_drop_clause */
    case 374: /* specific_cols_opt */
    case 375: /* expression_list */
    case 377: /* col_name_list */
    case 379: /* duration_list */
    case 380: /* rollup_func_list */
    case 390: /* tag_list_opt */
    case 396: /* func_list */
    case 412: /* col_list_opt */
    case 413: /* tag_def_or_ref_opt */
    case 416: /* dnode_list */
    case 419: /* literal_list */
    case 427: /* star_func_para_list */
    case 429: /* other_para_list */
    case 431: /* when_then_list */
    case 452: /* select_list */
    case 453: /* partition_by_clause_opt */
    case 458: /* group_by_clause_opt */
    case 461: /* partition_list */
    case 464: /* group_by_list */
    case 467: /* order_by_clause_opt */
    case 472: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy432)); 
}
      break;
    case 359: /* alter_db_option */
    case 381: /* alter_table_option */
{
 
}
      break;
    case 371: /* type_name */
{
 
}
      break;
    case 436: /* compare_op */
    case 437: /* in_op */
{
 
}
      break;
    case 449: /* join_type */
{
 
}
      break;
    case 463: /* fill_mode */
{
 
}
      break;
    case 474: /* ordering_specification_opt */
{
 
}
      break;
    case 475: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<sizeof(yy_action)/sizeof(yy_action[0]) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
   330,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   330,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
   331,  /* (2) account_options ::= */
   331,  /* (3) account_options ::= account_options PPS literal */
   331,  /* (4) account_options ::= account_options TSERIES literal */
   331,  /* (5) account_options ::= account_options STORAGE literal */
   331,  /* (6) account_options ::= account_options STREAMS literal */
   331,  /* (7) account_options ::= account_options QTIME literal */
   331,  /* (8) account_options ::= account_options DBS literal */
   331,  /* (9) account_options ::= account_options USERS literal */
   331,  /* (10) account_options ::= account_options CONNS literal */
   331,  /* (11) account_options ::= account_options STATE literal */
   332,  /* (12) alter_account_options ::= alter_account_option */
   332,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   334,  /* (14) alter_account_option ::= PASS literal */
   334,  /* (15) alter_account_option ::= PPS literal */
   334,  /* (16) alter_account_option ::= TSERIES literal */
   334,  /* (17) alter_account_option ::= STORAGE literal */
   334,  /* (18) alter_account_option ::= STREAMS literal */
   334,  /* (19) alter_account_option ::= QTIME literal */
   334,  /* (20) alter_account_option ::= DBS literal */
   334,  /* (21) alter_account_option ::= USERS literal */
   334,  /* (22) alter_account_option ::= CONNS literal */
   334,  /* (23) alter_account_option ::= STATE literal */
   330,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   330,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   330,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   330,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   330,  /* (28) cmd ::= DROP USER user_name */
   336,  /* (29) sysinfo_opt ::= */
   336,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   330,  /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
   330,  /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
   337,  /* (33) privileges ::= ALL */
   337,  /* (34) privileges ::= priv_type_list */
   337,  /* (35) privileges ::= SUBSCRIBE */
   340,  /* (36) priv_type_list ::= priv_type */
   340,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   341,  /* (38) priv_type ::= READ */
   341,  /* (39) priv_type ::= WRITE */
   338,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   338,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   338,  /* (42) priv_level ::= db_name NK_DOT table_name */
   338,  /* (43) priv_level ::= topic_name */
   339,  /* (44) with_opt ::= */
   339,  /* (45) with_opt ::= WITH search_condition */
   330,  /* (46) cmd ::= CREATE DNODE dnode_endpoint */
   330,  /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   330,  /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
   330,  /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
   330,  /* (50) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   330,  /* (51) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   330,  /* (52) cmd ::= ALTER ALL DNODES NK_STRING */
   330,  /* (53) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   346,  /* (54) dnode_endpoint ::= NK_STRING */
   346,  /* (55) dnode_endpoint ::= NK_ID */
   346,  /* (56) dnode_endpoint ::= NK_IPTOKEN */
   347,  /* (57) force_opt ::= */
   347,  /* (58) force_opt ::= FORCE */
   330,  /* (59) cmd ::= ALTER LOCAL NK_STRING */
   330,  /* (60) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   330,  /* (61) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   330,  /* (62) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   330,  /* (63) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   330,  /* (64) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   330,  /* (65) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   330,  /* (66) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   330,  /* (67) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   330,  /* (68) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   330,  /* (69) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   330,  /* (70) cmd ::= DROP DATABASE exists_opt db_name */
   330,  /* (71) cmd ::= USE db_name */
   330,  /* (72) cmd ::= ALTER DATABASE db_name alter_db_options */
   330,  /* (73) cmd ::= FLUSH DATABASE db_name */
   330,  /* (74) cmd ::= TRIM DATABASE db_name speed_opt */
   330,  /* (75) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
   348,  /* (76) not_exists_opt ::= IF NOT EXISTS */
   348,  /* (77) not_exists_opt ::= */
   350,  /* (78) exists_opt ::= IF EXISTS */
   350,  /* (79) exists_opt ::= */
   349,  /* (80) db_options ::= */
   349,  /* (81) db_options ::= db_options BUFFER NK_INTEGER */
   349,  /* (82) db_options ::= db_options CACHEMODEL NK_STRING */
   349,  /* (83) db_options ::= db_options CACHESIZE NK_INTEGER */
   349,  /* (84) db_options ::= db_options COMP NK_INTEGER */
   349,  /* (85) db_options ::= db_options DURATION NK_INTEGER */
   349,  /* (86) db_options ::= db_options DURATION NK_VARIABLE */
   349,  /* (87) db_options ::= db_options MAXROWS NK_INTEGER */
   349,  /* (88) db_options ::= db_options MINROWS NK_INTEGER */
   349,  /* (89) db_options ::= db_options KEEP integer_list */
   349,  /* (90) db_options ::= db_options KEEP variable_list */
   349,  /* (91) db_options ::= db_options PAGES NK_INTEGER */
   349,  /* (92) db_options ::= db_options PAGESIZE NK_INTEGER */
   349,  /* (93) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   349,  /* (94) db_options ::= db_options PRECISION NK_STRING */
   349,  /* (95) db_options ::= db_options REPLICA NK_INTEGER */
   349,  /* (96) db_options ::= db_options VGROUPS NK_INTEGER */
   349,  /* (97) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   349,  /* (98) db_options ::= db_options RETENTIONS retention_list */
   349,  /* (99) db_options ::= db_options SCHEMALESS NK_INTEGER */
   349,  /* (100) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   349,  /* (101) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   349,  /* (102) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   349,  /* (103) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   349,  /* (104) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   349,  /* (105) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   349,  /* (106) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   349,  /* (107) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   349,  /* (108) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   349,  /* (109) db_options ::= db_options TABLE_PREFIX signed */
   349,  /* (110) db_options ::= db_options TABLE_SUFFIX signed */
   351,  /* (111) alter_db_options ::= alter_db_option */
   351,  /* (112) alter_db_options ::= alter_db_options alter_db_option */
   359,  /* (113) alter_db_option ::= BUFFER NK_INTEGER */
   359,  /* (114) alter_db_option ::= CACHEMODEL NK_STRING */
   359,  /* (115) alter_db_option ::= CACHESIZE NK_INTEGER */
   359,  /* (116) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   359,  /* (117) alter_db_option ::= KEEP integer_list */
   359,  /* (118) alter_db_option ::= KEEP variable_list */
   359,  /* (119) alter_db_option ::= PAGES NK_INTEGER */
   359,  /* (120) alter_db_option ::= REPLICA NK_INTEGER */
   359,  /* (121) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   359,  /* (122) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   359,  /* (123) alter_db_option ::= MINROWS NK_INTEGER */
   359,  /* (124) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
   359,  /* (125) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   359,  /* (126) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
   359,  /* (127) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   355,  /* (128) integer_list ::= NK_INTEGER */
   355,  /* (129) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   356,  /* (130) variable_list ::= NK_VARIABLE */
   356,  /* (131) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   357,  /* (132) retention_list ::= retention */
   357,  /* (133) retention_list ::= retention_list NK_COMMA retention */
   360,  /* (134) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
   352,  /* (135) speed_opt ::= */
   352,  /* (136) speed_opt ::= MAX_SPEED NK_INTEGER */
   353,  /* (137) start_opt ::= */
   353,  /* (138) start_opt ::= START WITH NK_INTEGER */
   353,  /* (139) start_opt ::= START WITH NK_STRING */
   353,  /* (140) start_opt ::= START WITH TIMESTAMP NK_STRING */
   354,  /* (141) end_opt ::= */
   354,  /* (142) end_opt ::= END WITH NK_INTEGER */
   354,  /* (143) end_opt ::= END WITH NK_STRING */
   354,  /* (144) end_opt ::= END WITH TIMESTAMP NK_STRING */
   330,  /* (145) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   330,  /* (146) cmd ::= CREATE TABLE multi_create_clause */
   330,  /* (147) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   330,  /* (148) cmd ::= DROP TABLE multi_drop_clause */
   330,  /* (149) cmd ::= DROP STABLE exists_opt full_table_name */
   330,  /* (150) cmd ::= ALTER TABLE alter_table_clause */
   330,  /* (151) cmd ::= ALTER STABLE alter_table_clause */
   368,  /* (152) alter_table_clause ::= full_table_name alter_table_options */
   368,  /* (153) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   368,  /* (154) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   368,  /* (155) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   368,  /* (156) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   368,  /* (157) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   368,  /* (158) alter_table_clause ::= full_table_name DROP TAG column_name */
   368,  /* (159) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   368,  /* (160) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   368,  /* (161) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   365,  /* (162) multi_create_clause ::= create_subtable_clause */
   365,  /* (163) multi_create_clause ::= multi_create_clause create_subtable_clause */
   373,  /* (164) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   367,  /* (165) multi_drop_clause ::= drop_table_clause */
   367,  /* (166) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
   376,  /* (167) drop_table_clause ::= exists_opt full_table_name */
   374,  /* (168) specific_cols_opt ::= */
   374,  /* (169) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   361,  /* (170) full_table_name ::= table_name */
   361,  /* (171) full_table_name ::= db_name NK_DOT table_name */
   362,  /* (172) column_def_list ::= column_def */
   362,  /* (173) column_def_list ::= column_def_list NK_COMMA column_def */
   378,  /* (174) column_def ::= column_name type_name */
   371,  /* (175) type_name ::= BOOL */
   371,  /* (176) type_name ::= TINYINT */
   371,  /* (177) type_name ::= SMALLINT */
   371,  /* (178) type_name ::= INT */
   371,  /* (179) type_name ::= INTEGER */
   371,  /* (180) type_name ::= BIGINT */
   371,  /* (181) type_name ::= FLOAT */
   371,  /* (182) type_name ::= DOUBLE */
   371,  /* (183) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   371,  /* (184) type_name ::= TIMESTAMP */
   371,  /* (185) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   371,  /* (186) type_name ::= TINYINT UNSIGNED */
   371,  /* (187) type_name ::= SMALLINT UNSIGNED */
   371,  /* (188) type_name ::= INT UNSIGNED */
   371,  /* (189) type_name ::= BIGINT UNSIGNED */
   371,  /* (190) type_name ::= JSON */
   371,  /* (191) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   371,  /* (192) type_name ::= MEDIUMBLOB */
   371,  /* (193) type_name ::= BLOB */
   371,  /* (194) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   371,  /* (195) type_name ::= DECIMAL */
   371,  /* (196) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   371,  /* (197) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
   363,  /* (198) tags_def_opt ::= */
   363,  /* (199) tags_def_opt ::= tags_def */
   366,  /* (200) tags_def ::= TAGS NK_LP column_def_list NK_RP */
   364,  /* (201) table_options ::= */
   364,  /* (202) table_options ::= table_options COMMENT NK_STRING */
   364,  /* (203) table_options ::= table_options MAX_DELAY duration_list */
   364,  /* (204) table_options ::= table_options WATERMARK duration_list */
   364,  /* (205) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   364,  /* (206) table_options ::= table_options TTL NK_INTEGER */
   364,  /* (207) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   364,  /* (208) table_options ::= table_options DELETE_MARK duration_list */
   369,  /* (209) alter_table_options ::= alter_table_option */
   369,  /* (210) alter_table_options ::= alter_table_options alter_table_option */
   381,  /* (211) alter_table_option ::= COMMENT NK_STRING */
   381,  /* (212) alter_table_option ::= TTL NK_INTEGER */
   379,  /* (213) duration_list ::= duration_literal */
   379,  /* (214) duration_list ::= duration_list NK_COMMA duration_literal */
   380,  /* (215) rollup_func_list ::= rollup_func_name */
   380,  /* (216) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   383,  /* (217) rollup_func_name ::= function_name */
   383,  /* (218) rollup_func_name ::= FIRST */
   383,  /* (219) rollup_func_name ::= LAST */
   377,  /* (220) col_name_list ::= col_name */
   377,  /* (221) col_name_list ::= col_name_list NK_COMMA col_name */
   385,  /* (222) col_name ::= column_name */
   330,  /* (223) cmd ::= SHOW DNODES */
   330,  /* (224) cmd ::= SHOW USERS */
   330,  /* (225) cmd ::= SHOW USER PRIVILEGES */
   330,  /* (226) cmd ::= SHOW DATABASES */
   330,  /* (227) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   330,  /* (228) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   330,  /* (229) cmd ::= SHOW db_name_cond_opt VGROUPS */
   330,  /* (230) cmd ::= SHOW MNODES */
   330,  /* (231) cmd ::= SHOW QNODES */
   330,  /* (232) cmd ::= SHOW FUNCTIONS */
   330,  /* (233) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   330,  /* (234) cmd ::= SHOW STREAMS */
   330,  /* (235) cmd ::= SHOW ACCOUNTS */
   330,  /* (236) cmd ::= SHOW APPS */
   330,  /* (237) cmd ::= SHOW CONNECTIONS */
   330,  /* (238) cmd ::= SHOW LICENCES */
   330,  /* (239) cmd ::= SHOW GRANTS */
   330,  /* (240) cmd ::= SHOW CREATE DATABASE db_name */
   330,  /* (241) cmd ::= SHOW CREATE TABLE full_table_name */
   330,  /* (242) cmd ::= SHOW CREATE STABLE full_table_name */
   330,  /* (243) cmd ::= SHOW QUERIES */
   330,  /* (244) cmd ::= SHOW SCORES */
   330,  /* (245) cmd ::= SHOW TOPICS */
   330,  /* (246) cmd ::= SHOW VARIABLES */
   330,  /* (247) cmd ::= SHOW CLUSTER VARIABLES */
   330,  /* (248) cmd ::= SHOW LOCAL VARIABLES */
   330,  /* (249) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   330,  /* (250) cmd ::= SHOW BNODES */
   330,  /* (251) cmd ::= SHOW SNODES */
   330,  /* (252) cmd ::= SHOW CLUSTER */
   330,  /* (253) cmd ::= SHOW TRANSACTIONS */
   330,  /* (254) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   330,  /* (255) cmd ::= SHOW CONSUMERS */
   330,  /* (256) cmd ::= SHOW SUBSCRIPTIONS */
   330,  /* (257) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   330,  /* (258) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   330,  /* (259) cmd ::= SHOW VNODES NK_INTEGER */
   330,  /* (260) cmd ::= SHOW VNODES NK_STRING */
   330,  /* (261) cmd ::= SHOW db_name_cond_opt ALIVE */
   330,  /* (262) cmd ::= SHOW CLUSTER ALIVE */
   386,  /* (263) db_name_cond_opt ::= */
   386,  /* (264) db_name_cond_opt ::= db_name NK_DOT */
   387,  /* (265) like_pattern_opt ::= */
   387,  /* (266) like_pattern_opt ::= LIKE NK_STRING */
   388,  /* (267) table_name_cond ::= table_name */
   389,  /* (268) from_db_opt ::= */
   389,  /* (269) from_db_opt ::= FROM db_name */
   390,  /* (270) tag_list_opt ::= */
   390,  /* (271) tag_list_opt ::= tag_item */
   390,  /* (272) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   391,  /* (273) tag_item ::= TBNAME */
   391,  /* (274) tag_item ::= QTAGS */
   391,  /* (275) tag_item ::= column_name */
   391,  /* (276) tag_item ::= column_name column_alias */
   391,  /* (277) tag_item ::= column_name AS column_alias */
   330,  /* (278) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
   330,  /* (279) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
   330,  /* (280) cmd ::= DROP INDEX exists_opt full_index_name */
   393,  /* (281) full_index_name ::= index_name */
   393,  /* (282) full_index_name ::= db_name NK_DOT index_name */
   394,  /* (283) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
   394,  /* (284) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   396,  /* (285) func_list ::= func */
   396,  /* (286) func_list ::= func_list NK_COMMA func */
   399,  /* (287) func ::= sma_func_name NK_LP expression_list NK_RP */
   400,  /* (288) sma_func_name ::= function_name */
   400,  /* (289) sma_func_name ::= COUNT */
   400,  /* (290) sma_func_name ::= FIRST */
   400,  /* (291) sma_func_name ::= LAST */
   400,  /* (292) sma_func_name ::= LAST_ROW */
   398,  /* (293) sma_stream_opt ::= */
   398,  /* (294) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   398,  /* (295) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   398,  /* (296) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   330,  /* (297) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   330,  /* (298) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   330,  /* (299) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   330,  /* (300) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
   330,  /* (301) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
   330,  /* (302) cmd ::= DROP TOPIC exists_opt topic_name */
   330,  /* (303) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   330,  /* (304) cmd ::= DESC full_table_name */
   330,  /* (305) cmd ::= DESCRIBE full_table_name */
   330,  /* (306) cmd ::= RESET QUERY CACHE */
   330,  /* (307) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   330,  /* (308) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
   403,  /* (309) analyze_opt ::= */
   403,  /* (310) analyze_opt ::= ANALYZE */
   404,  /* (311) explain_options ::= */
   404,  /* (312) explain_options ::= explain_options VERBOSE NK_BOOL */
   404,  /* (313) explain_options ::= explain_options RATIO NK_FLOAT */
   330,  /* (314) cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
   330,  /* (315) cmd ::= DROP FUNCTION exists_opt function_name */
   407,  /* (316) agg_func_opt ::= */
   407,  /* (317) agg_func_opt ::= AGGREGATE */
   408,  /* (318) bufsize_opt ::= */
   408,  /* (319) bufsize_opt ::= BUFSIZE NK_INTEGER */
   409,  /* (320) language_opt ::= */
   409,  /* (321) language_opt ::= LANGUAGE NK_STRING */
   406,  /* (322) or_replace_opt ::= */
   406,  /* (323) or_replace_opt ::= OR REPLACE */
   330,  /* (324) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
   330,  /* (325) cmd ::= DROP STREAM exists_opt stream_name */
   412,  /* (326) col_list_opt ::= */
   412,  /* (327) col_list_opt ::= NK_LP col_name_list NK_RP */
   413,  /* (328) tag_def_or_ref_opt ::= */
   413,  /* (329) tag_def_or_ref_opt ::= tags_def */
   413,  /* (330) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
   411,  /* (331) stream_options ::= */
   411,  /* (332) stream_options ::= stream_options TRIGGER AT_ONCE */
   411,  /* (333) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   411,  /* (334) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   411,  /* (335) stream_options ::= stream_options WATERMARK duration_literal */
   411,  /* (336) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   411,  /* (337) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   411,  /* (338) stream_options ::= stream_options DELETE_MARK duration_literal */
   411,  /* (339) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
   414,  /* (340) subtable_opt ::= */
   414,  /* (341) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
   330,  /* (342) cmd ::= KILL CONNECTION NK_INTEGER */
   330,  /* (343) cmd ::= KILL QUERY NK_STRING */
   330,  /* (344) cmd ::= KILL TRANSACTION NK_INTEGER */
   330,  /* (345) cmd ::= BALANCE VGROUP */
   330,  /* (346) cmd ::= BALANCE VGROUP LEADER */
   330,  /* (347) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   330,  /* (348) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   330,  /* (349) cmd ::= SPLIT VGROUP NK_INTEGER */
   416,  /* (350) dnode_list ::= DNODE NK_INTEGER */
   416,  /* (351) dnode_list ::= dnode_list DNODE NK_INTEGER */
   330,  /* (352) cmd ::= DELETE FROM full_table_name where_clause_opt */
   330,  /* (353) cmd ::= query_or_subquery */
   330,  /* (354) cmd ::= insert_query */
   405,  /* (355) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   405,  /* (356) insert_query ::= INSERT INTO full_table_name query_or_subquery */
   333,  /* (357) literal ::= NK_INTEGER */
   333,  /* (358) literal ::= NK_FLOAT */
   333,  /* (359) literal ::= NK_STRING */
   333,  /* (360) literal ::= NK_BOOL */
   333,  /* (361) literal ::= TIMESTAMP NK_STRING */
   333,  /* (362) literal ::= duration_literal */
   333,  /* (363) literal ::= NULL */
   333,  /* (364) literal ::= NK_QUESTION */
   382,  /* (365) duration_literal ::= NK_VARIABLE */
   358,  /* (366) signed ::= NK_INTEGER */
   358,  /* (367) signed ::= NK_PLUS NK_INTEGER */
   358,  /* (368) signed ::= NK_MINUS NK_INTEGER */
   358,  /* (369) signed ::= NK_FLOAT */
   358,  /* (370) signed ::= NK_PLUS NK_FLOAT */
   358,  /* (371) signed ::= NK_MINUS NK_FLOAT */
   372,  /* (372) signed_literal ::= signed */
   372,  /* (373) signed_literal ::= NK_STRING */
   372,  /* (374) signed_literal ::= NK_BOOL */
   372,  /* (375) signed_literal ::= TIMESTAMP NK_STRING */
   372,  /* (376) signed_literal ::= duration_literal */
   372,  /* (377) signed_literal ::= NULL */
   372,  /* (378) signed_literal ::= literal_func */
   372,  /* (379) signed_literal ::= NK_QUESTION */
   419,  /* (380) literal_list ::= signed_literal */
   419,  /* (381) literal_list ::= literal_list NK_COMMA signed_literal */
   342,  /* (382) db_name ::= NK_ID */
   343,  /* (383) table_name ::= NK_ID */
   370,  /* (384) column_name ::= NK_ID */
   384,  /* (385) function_name ::= NK_ID */
   420,  /* (386) table_alias ::= NK_ID */
   392,  /* (387) column_alias ::= NK_ID */
   335,  /* (388) user_name ::= NK_ID */
   344,  /* (389) topic_name ::= NK_ID */
   410,  /* (390) stream_name ::= NK_ID */
   402,  /* (391) cgroup_name ::= NK_ID */
   395,  /* (392) index_name ::= NK_ID */
   421,  /* (393) expr_or_subquery ::= expression */
   415,  /* (394) expression ::= literal */
   415,  /* (395) expression ::= pseudo_column */
   415,  /* (396) expression ::= column_reference */
   415,  /* (397) expression ::= function_expression */
   415,  /* (398) expression ::= case_when_expression */
   415,  /* (399) expression ::= NK_LP expression NK_RP */
   415,  /* (400) expression ::= NK_PLUS expr_or_subquery */
   415,  /* (401) expression ::= NK_MINUS expr_or_subquery */
   415,  /* (402) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   415,  /* (403) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   415,  /* (404) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   415,  /* (405) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   415,  /* (406) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   415,  /* (407) expression ::= column_reference NK_ARROW NK_STRING */
   415,  /* (408) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   415,  /* (409) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   375,  /* (410) expression_list ::= expr_or_subquery */
   375,  /* (411) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   423,  /* (412) column_reference ::= column_name */
   423,  /* (413) column_reference ::= table_name NK_DOT column_name */
   422,  /* (414) pseudo_column ::= ROWTS */
   422,  /* (415) pseudo_column ::= TBNAME */
   422,  /* (416) pseudo_column ::= table_name NK_DOT TBNAME */
   422,  /* (417) pseudo_column ::= QSTART */
   422,  /* (418) pseudo_column ::= QEND */
   422,  /* (419) pseudo_column ::= QDURATION */
   422,  /* (420) pseudo_column ::= WSTART */
   422,  /* (421) pseudo_column ::= WEND */
   422,  /* (422) pseudo_column ::= WDURATION */
   422,  /* (423) pseudo_column ::= IROWTS */
   422,  /* (424) pseudo_column ::= ISFILLED */
   422,  /* (425) pseudo_column ::= QTAGS */
   424,  /* (426) function_expression ::= function_name NK_LP expression_list NK_RP */
   424,  /* (427) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   424,  /* (428) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   424,  /* (429) function_expression ::= literal_func */
   418,  /* (430) literal_func ::= noarg_func NK_LP NK_RP */
   418,  /* (431) literal_func ::= NOW */
   428,  /* (432) noarg_func ::= NOW */
   428,  /* (433) noarg_func ::= TODAY */
   428,  /* (434) noarg_func ::= TIMEZONE */
   428,  /* (435) noarg_func ::= DATABASE */
   428,  /* (436) noarg_func ::= CLIENT_VERSION */
   428,  /* (437) noarg_func ::= SERVER_VERSION */
   428,  /* (438) noarg_func ::= SERVER_STATUS */
   428,  /* (439) noarg_func ::= CURRENT_USER */
   428,  /* (440) noarg_func ::= USER */
   426,  /* (441) star_func ::= COUNT */
   426,  /* (442) star_func ::= FIRST */
   426,  /* (443) star_func ::= LAST */
   426,  /* (444) star_func ::= LAST_ROW */
   427,  /* (445) star_func_para_list ::= NK_STAR */
   427,  /* (446) star_func_para_list ::= other_para_list */
   429,  /* (447) other_para_list ::= star_func_para */
   429,  /* (448) other_para_list ::= other_para_list NK_COMMA star_func_para */
   430,  /* (449) star_func_para ::= expr_or_subquery */
   430,  /* (450) star_func_para ::= table_name NK_DOT NK_STAR */
   425,  /* (451) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   425,  /* (452) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   431,  /* (453) when_then_list ::= when_then_expr */
   431,  /* (454) when_then_list ::= when_then_list when_then_expr */
   434,  /* (455) when_then_expr ::= WHEN common_expression THEN common_expression */
   432,  /* (456) case_when_else_opt ::= */
   432,  /* (457) case_when_else_opt ::= ELSE common_expression */
   435,  /* (458) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   435,  /* (459) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   435,  /* (460) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   435,  /* (461) predicate ::= expr_or_subquery IS NULL */
   435,  /* (462) predicate ::= expr_or_subquery IS NOT NULL */
   435,  /* (463) predicate ::= expr_or_subquery in_op in_predicate_value */
   436,  /* (464) compare_op ::= NK_LT */
   436,  /* (465) compare_op ::= NK_GT */
   436,  /* (466) compare_op ::= NK_LE */
   436,  /* (467) compare_op ::= NK_GE */
   436,  /* (468) compare_op ::= NK_NE */
   436,  /* (469) compare_op ::= NK_EQ */
   436,  /* (470) compare_op ::= LIKE */
   436,  /* (471) compare_op ::= NOT LIKE */
   436,  /* (472) compare_op ::= MATCH */
   436,  /* (473) compare_op ::= NMATCH */
   436,  /* (474) compare_op ::= CONTAINS */
   437,  /* (475) in_op ::= IN */
   437,  /* (476) in_op ::= NOT IN */
   438,  /* (477) in_predicate_value ::= NK_LP literal_list NK_RP */
   439,  /* (478) boolean_value_expression ::= boolean_primary */
   439,  /* (479) boolean_value_expression ::= NOT boolean_primary */
   439,  /* (480) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   439,  /* (481) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   440,  /* (482) boolean_primary ::= predicate */
   440,  /* (483) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   433,  /* (484) common_expression ::= expr_or_subquery */
   433,  /* (485) common_expression ::= boolean_value_expression */
   441,  /* (486) from_clause_opt ::= */
   441,  /* (487) from_clause_opt ::= FROM table_reference_list */
   442,  /* (488) table_reference_list ::= table_reference */
   442,  /* (489) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   443,  /* (490) table_reference ::= table_primary */
   443,  /* (491) table_reference ::= joined_table */
   444,  /* (492) table_primary ::= table_name alias_opt */
   444,  /* (493) table_primary ::= db_name NK_DOT table_name alias_opt */
   444,  /* (494) table_primary ::= subquery alias_opt */
   444,  /* (495) table_primary ::= parenthesized_joined_table */
   446,  /* (496) alias_opt ::= */
   446,  /* (497) alias_opt ::= table_alias */
   446,  /* (498) alias_opt ::= AS table_alias */
   448,  /* (499) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   448,  /* (500) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   445,  /* (501) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
   449,  /* (502) join_type ::= */
   449,  /* (503) join_type ::= INNER */
   450,  /* (504) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
   451,  /* (505) set_quantifier_opt ::= */
   451,  /* (506) set_quantifier_opt ::= DISTINCT */
   451,  /* (507) set_quantifier_opt ::= ALL */
   452,  /* (508) select_list ::= select_item */
   452,  /* (509) select_list ::= select_list NK_COMMA select_item */
   460,  /* (510) select_item ::= NK_STAR */
   460,  /* (511) select_item ::= common_expression */
   460,  /* (512) select_item ::= common_expression column_alias */
   460,  /* (513) select_item ::= common_expression AS column_alias */
   460,  /* (514) select_item ::= table_name NK_DOT NK_STAR */
   417,  /* (515) where_clause_opt ::= */
   417,  /* (516) where_clause_opt ::= WHERE search_condition */
   453,  /* (517) partition_by_clause_opt ::= */
   453,  /* (518) partition_by_clause_opt ::= PARTITION BY partition_list */
   461,  /* (519) partition_list ::= partition_item */
   461,  /* (520) partition_list ::= partition_list NK_COMMA partition_item */
   462,  /* (521) partition_item ::= expr_or_subquery */
   462,  /* (522) partition_item ::= expr_or_subquery column_alias */
   462,  /* (523) partition_item ::= expr_or_subquery AS column_alias */
   457,  /* (524) twindow_clause_opt ::= */
   457,  /* (525) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   457,  /* (526) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   457,  /* (527) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   457,  /* (528) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   457,  /* (529) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
   397,  /* (530) sliding_opt ::= */
   397,  /* (531) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
   456,  /* (532) fill_opt ::= */
   456,  /* (533) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   456,  /* (534) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
   456,  /* (535) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
   463,  /* (536) fill_mode ::= NONE */
   463,  /* (537) fill_mode ::= PREV */
   463,  /* (538) fill_mode ::= NULL */
   463,  /* (539) fill_mode ::= NULL_F */
   463,  /* (540) fill_mode ::= LINEAR */
   463,  /* (541) fill_mode ::= NEXT */
   458,  /* (542) group_by_clause_opt ::= */
   458,  /* (543) group_by_clause_opt ::= GROUP BY group_by_list */
   464,  /* (544) group_by_list ::= expr_or_subquery */
   464,  /* (545) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
   459,  /* (546) having_clause_opt ::= */
   459,  /* (547) having_clause_opt ::= HAVING search_condition */
   454,  /* (548) range_opt ::= */
   454,  /* (549) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
   455,  /* (550) every_opt ::= */
   455,  /* (551) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   465,  /* (552) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   466,  /* (553) query_simple ::= query_specification */
   466,  /* (554) query_simple ::= union_query_expression */
   470,  /* (555) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   470,  /* (556) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   471,  /* (557) query_simple_or_subquery ::= query_simple */
   471,  /* (558) query_simple_or_subquery ::= subquery */
   401,  /* (559) query_or_subquery ::= query_expression */
   401,  /* (560) query_or_subquery ::= subquery */
   467,  /* (561) order_by_clause_opt ::= */
   467,  /* (562) order_by_clause_opt ::= ORDER BY sort_specification_list */
   468,  /* (563) slimit_clause_opt ::= */
   468,  /* (564) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   468,  /* (565) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   468,  /* (566) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   469,  /* (567) limit_clause_opt ::= */
   469,  /* (568) limit_clause_opt ::= LIMIT NK_INTEGER */
   469,  /* (569) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   469,  /* (570) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   447,  /* (571) subquery ::= NK_LP query_expression NK_RP */
   447,  /* (572) subquery ::= NK_LP subquery NK_RP */
   345,  /* (573) search_condition ::= common_expression */
   472,  /* (574) sort_specification_list ::= sort_specification */
   472,  /* (575) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   473,  /* (576) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
   474,  /* (577) ordering_specification_opt ::= */
   474,  /* (578) ordering_specification_opt ::= ASC */
   474,  /* (579) ordering_specification_opt ::= DESC */
   475,  /* (580) null_ordering_opt ::= */
   475,  /* (581) null_ordering_opt ::= NULLS FIRST */
   475,  /* (582) null_ordering_opt ::= NULLS LAST */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -6,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   -4,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
    0,  /* (2) account_options ::= */
   -3,  /* (3) account_options ::= account_options PPS literal */
   -3,  /* (4) account_options ::= account_options TSERIES literal */
   -3,  /* (5) account_options ::= account_options STORAGE literal */
   -3,  /* (6) account_options ::= account_options STREAMS literal */
   -3,  /* (7) account_options ::= account_options QTIME literal */
   -3,  /* (8) account_options ::= account_options DBS literal */
   -3,  /* (9) account_options ::= account_options USERS literal */
   -3,  /* (10) account_options ::= account_options CONNS literal */
   -3,  /* (11) account_options ::= account_options STATE literal */
   -1,  /* (12) alter_account_options ::= alter_account_option */
   -2,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   -2,  /* (14) alter_account_option ::= PASS literal */
   -2,  /* (15) alter_account_option ::= PPS literal */
   -2,  /* (16) alter_account_option ::= TSERIES literal */
   -2,  /* (17) alter_account_option ::= STORAGE literal */
   -2,  /* (18) alter_account_option ::= STREAMS literal */
   -2,  /* (19) alter_account_option ::= QTIME literal */
   -2,  /* (20) alter_account_option ::= DBS literal */
   -2,  /* (21) alter_account_option ::= USERS literal */
   -2,  /* (22) alter_account_option ::= CONNS literal */
   -2,  /* (23) alter_account_option ::= STATE literal */
   -6,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   -5,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   -5,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   -5,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   -3,  /* (28) cmd ::= DROP USER user_name */
    0,  /* (29) sysinfo_opt ::= */
   -2,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   -7,  /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
   -7,  /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
   -1,  /* (33) privileges ::= ALL */
   -1,  /* (34) privileges ::= priv_type_list */
   -1,  /* (35) privileges ::= SUBSCRIBE */
   -1,  /* (36) priv_type_list ::= priv_type */
   -3,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   -1,  /* (38) priv_type ::= READ */
   -1,  /* (39) priv_type ::= WRITE */
   -3,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   -3,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   -3,  /* (42) priv_level ::= db_name NK_DOT table_name */
   -1,  /* (43) priv_level ::= topic_name */
    0,  /* (44) with_opt ::= */
   -2,  /* (45) with_opt ::= WITH search_condition */
   -3,  /* (46) cmd ::= CREATE DNODE dnode_endpoint */
   -5,  /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   -4,  /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
   -4,  /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
   -4,  /* (50) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   -5,  /* (51) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   -4,  /* (52) cmd ::= ALTER ALL DNODES NK_STRING */
   -5,  /* (53) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   -1,  /* (54) dnode_endpoint ::= NK_STRING */
   -1,  /* (55) dnode_endpoint ::= NK_ID */
   -1,  /* (56) dnode_endpoint ::= NK_IPTOKEN */
    0,  /* (57) force_opt ::= */
   -1,  /* (58) force_opt ::= FORCE */
   -3,  /* (59) cmd ::= ALTER LOCAL NK_STRING */
   -4,  /* (60) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   -5,  /* (61) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   -5,  /* (62) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   -5,  /* (63) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   -5,  /* (64) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   -5,  /* (65) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   -5,  /* (66) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   -5,  /* (67) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   -5,  /* (68) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   -5,  /* (69) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   -4,  /* (70) cmd ::= DROP DATABASE exists_opt db_name */
   -2,  /* (71) cmd ::= USE db_name */
   -4,  /* (72) cmd ::= ALTER DATABASE db_name alter_db_options */
   -3,  /* (73) cmd ::= FLUSH DATABASE db_name */
   -4,  /* (74) cmd ::= TRIM DATABASE db_name speed_opt */
   -5,  /* (75) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
   -3,  /* (76) not_exists_opt ::= IF NOT EXISTS */
    0,  /* (77) not_exists_opt ::= */
   -2,  /* (78) exists_opt ::= IF EXISTS */
    0,  /* (79) exists_opt ::= */
    0,  /* (80) db_options ::= */
   -3,  /* (81) db_options ::= db_options BUFFER NK_INTEGER */
   -3,  /* (82) db_options ::= db_options CACHEMODEL NK_STRING */
   -3,  /* (83) db_options ::= db_options CACHESIZE NK_INTEGER */
   -3,  /* (84) db_options ::= db_options COMP NK_INTEGER */
   -3,  /* (85) db_options ::= db_options DURATION NK_INTEGER */
   -3,  /* (86) db_options ::= db_options DURATION NK_VARIABLE */
   -3,  /* (87) db_options ::= db_options MAXROWS NK_INTEGER */
   -3,  /* (88) db_options ::= db_options MINROWS NK_INTEGER */
   -3,  /* (89) db_options ::= db_options KEEP integer_list */
   -3,  /* (90) db_options ::= db_options KEEP variable_list */
   -3,  /* (91) db_options ::= db_options PAGES NK_INTEGER */
   -3,  /* (92) db_options ::= db_options PAGESIZE NK_INTEGER */
   -3,  /* (93) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   -3,  /* (94) db_options ::= db_options PRECISION NK_STRING */
   -3,  /* (95) db_options ::= db_options REPLICA NK_INTEGER */
   -3,  /* (96) db_options ::= db_options VGROUPS NK_INTEGER */
   -3,  /* (97) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   -3,  /* (98) db_options ::= db_options RETENTIONS retention_list */
   -3,  /* (99) db_options ::= db_options SCHEMALESS NK_INTEGER */
   -3,  /* (100) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   -3,  /* (101) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   -3,  /* (102) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   -4,  /* (103) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -3,  /* (104) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   -4,  /* (105) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -3,  /* (106) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   -3,  /* (107) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   -3,  /* (108) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   -3,  /* (109) db_options ::= db_options TABLE_PREFIX signed */
   -3,  /* (110) db_options ::= db_options TABLE_SUFFIX signed */
   -1,  /* (111) alter_db_options ::= alter_db_option */
   -2,  /* (112) alter_db_options ::= alter_db_options alter_db_option */
   -2,  /* (113) alter_db_option ::= BUFFER NK_INTEGER */
   -2,  /* (114) alter_db_option ::= CACHEMODEL NK_STRING */
   -2,  /* (115) alter_db_option ::= CACHESIZE NK_INTEGER */
   -2,  /* (116) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   -2,  /* (117) alter_db_option ::= KEEP integer_list */
   -2,  /* (118) alter_db_option ::= KEEP variable_list */
   -2,  /* (119) alter_db_option ::= PAGES NK_INTEGER */
   -2,  /* (120) alter_db_option ::= REPLICA NK_INTEGER */
   -2,  /* (121) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   -2,  /* (122) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   -2,  /* (123) alter_db_option ::= MINROWS NK_INTEGER */
   -2,  /* (124) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
   -3,  /* (125) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -2,  /* (126) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
   -3,  /* (127) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -1,  /* (128) integer_list ::= NK_INTEGER */
   -3,  /* (129) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   -1,  /* (130) variable_list ::= NK_VARIABLE */
   -3,  /* (131) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   -1,  /* (132) retention_list ::= retention */
   -3,  /* (133) retention_list ::= retention_list NK_COMMA retention */
   -3,  /* (134) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
    0,  /* (135) speed_opt ::= */
   -2,  /* (136) speed_opt ::= MAX_SPEED NK_INTEGER */
    0,  /* (137) start_opt ::= */
   -3,  /* (138) start_opt ::= START WITH NK_INTEGER */
   -3,  /* (139) start_opt ::= START WITH NK_STRING */
   -4,  /* (140) start_opt ::= START WITH TIMESTAMP NK_STRING */
    0,  /* (141) end_opt ::= */
   -3,  /* (142) end_opt ::= END WITH NK_INTEGER */
   -3,  /* (143) end_opt ::= END WITH NK_STRING */
   -4,  /* (144) end_opt ::= END WITH TIMESTAMP NK_STRING */
   -9,  /* (145) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   -3,  /* (146) cmd ::= CREATE TABLE multi_create_clause */
   -9,  /* (147) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   -3,  /* (148) cmd ::= DROP TABLE multi_drop_clause */
   -4,  /* (149) cmd ::= DROP STABLE exists_opt full_table_name */
   -3,  /* (150) cmd ::= ALTER TABLE alter_table_clause */
   -3,  /* (151) cmd ::= ALTER STABLE alter_table_clause */
   -2,  /* (152) alter_table_clause ::= full_table_name alter_table_options */
   -5,  /* (153) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   -4,  /* (154) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   -5,  /* (155) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   -5,  /* (156) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   -5,  /* (157) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   -4,  /* (158) alter_table_clause ::= full_table_name DROP TAG column_name */
   -5,  /* (159) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   -5,  /* (160) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   -6,  /* (161) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   -1,  /* (162) multi_create_clause ::= create_subtable_clause */
   -2,  /* (163) multi_create_clause ::= multi_create_clause create_subtable_clause */
  -10,  /* (164) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   -1,  /* (165) multi_drop_clause ::= drop_table_clause */
   -3,  /* (166) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
   -2,  /* (167) drop_table_clause ::= exists_opt full_table_name */
    0,  /* (168) specific_cols_opt ::= */
   -3,  /* (169) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   -1,  /* (170) full_table_name ::= table_name */
   -3,  /* (171) full_table_name ::= db_name NK_DOT table_name */
   -1,  /* (172) column_def_list ::= column_def */
   -3,  /* (173) column_def_list ::= column_def_list NK_COMMA column_def */
   -2,  /* (174) column_def ::= column_name type_name */
   -1,  /* (175) type_name ::= BOOL */
   -1,  /* (176) type_name ::= TINYINT */
   -1,  /* (177) type_name ::= SMALLINT */
   -1,  /* (178) type_name ::= INT */
   -1,  /* (179) type_name ::= INTEGER */
   -1,  /* (180) type_name ::= BIGINT */
   -1,  /* (181) type_name ::= FLOAT */
   -1,  /* (182) type_name ::= DOUBLE */
   -4,  /* (183) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (184) type_name ::= TIMESTAMP */
   -4,  /* (185) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   -2,  /* (186) type_name ::= TINYINT UNSIGNED */
   -2,  /* (187) type_name ::= SMALLINT UNSIGNED */
   -2,  /* (188) type_name ::= INT UNSIGNED */
   -2,  /* (189) type_name ::= BIGINT UNSIGNED */
   -1,  /* (190) type_name ::= JSON */
   -4,  /* (191) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   -1,  /* (192) type_name ::= MEDIUMBLOB */
   -1,  /* (193) type_name ::= BLOB */
   -4,  /* (194) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (195) type_name ::= DECIMAL */
   -4,  /* (196) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   -6,  /* (197) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
    0,  /* (198) tags_def_opt ::= */
   -1,  /* (199) tags_def_opt ::= tags_def */
   -4,  /* (200) tags_def ::= TAGS NK_LP column_def_list NK_RP */
    0,  /* (201) table_options ::= */
   -3,  /* (202) table_options ::= table_options COMMENT NK_STRING */
   -3,  /* (203) table_options ::= table_options MAX_DELAY duration_list */
   -3,  /* (204) table_options ::= table_options WATERMARK duration_list */
   -5,  /* (205) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   -3,  /* (206) table_options ::= table_options TTL NK_INTEGER */
   -5,  /* (207) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   -3,  /* (208) table_options ::= table_options DELETE_MARK duration_list */
   -1,  /* (209) alter_table_options ::= alter_table_option */
   -2,  /* (210) alter_table_options ::= alter_table_options alter_table_option */
   -2,  /* (211) alter_table_option ::= COMMENT NK_STRING */
   -2,  /* (212) alter_table_option ::= TTL NK_INTEGER */
   -1,  /* (213) duration_list ::= duration_literal */
   -3,  /* (214) duration_list ::= duration_list NK_COMMA duration_literal */
   -1,  /* (215) rollup_func_list ::= rollup_func_name */
   -3,  /* (216) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   -1,  /* (217) rollup_func_name ::= function_name */
   -1,  /* (218) rollup_func_name ::= FIRST */
   -1,  /* (219) rollup_func_name ::= LAST */
   -1,  /* (220) col_name_list ::= col_name */
   -3,  /* (221) col_name_list ::= col_name_list NK_COMMA col_name */
   -1,  /* (222) col_name ::= column_name */
   -2,  /* (223) cmd ::= SHOW DNODES */
   -2,  /* (224) cmd ::= SHOW USERS */
   -3,  /* (225) cmd ::= SHOW USER PRIVILEGES */
   -2,  /* (226) cmd ::= SHOW DATABASES */
   -4,  /* (227) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   -4,  /* (228) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   -3,  /* (229) cmd ::= SHOW db_name_cond_opt VGROUPS */
   -2,  /* (230) cmd ::= SHOW MNODES */
   -2,  /* (231) cmd ::= SHOW QNODES */
   -2,  /* (232) cmd ::= SHOW FUNCTIONS */
   -5,  /* (233) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   -2,  /* (234) cmd ::= SHOW STREAMS */
   -2,  /* (235) cmd ::= SHOW ACCOUNTS */
   -2,  /* (236) cmd ::= SHOW APPS */
   -2,  /* (237) cmd ::= SHOW CONNECTIONS */
   -2,  /* (238) cmd ::= SHOW LICENCES */
   -2,  /* (239) cmd ::= SHOW GRANTS */
   -4,  /* (240) cmd ::= SHOW CREATE DATABASE db_name */
   -4,  /* (241) cmd ::= SHOW CREATE TABLE full_table_name */
   -4,  /* (242) cmd ::= SHOW CREATE STABLE full_table_name */
   -2,  /* (243) cmd ::= SHOW QUERIES */
   -2,  /* (244) cmd ::= SHOW SCORES */
   -2,  /* (245) cmd ::= SHOW TOPICS */
   -2,  /* (246) cmd ::= SHOW VARIABLES */
   -3,  /* (247) cmd ::= SHOW CLUSTER VARIABLES */
   -3,  /* (248) cmd ::= SHOW LOCAL VARIABLES */
   -5,  /* (249) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   -2,  /* (250) cmd ::= SHOW BNODES */
   -2,  /* (251) cmd ::= SHOW SNODES */
   -2,  /* (252) cmd ::= SHOW CLUSTER */
   -2,  /* (253) cmd ::= SHOW TRANSACTIONS */
   -4,  /* (254) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   -2,  /* (255) cmd ::= SHOW CONSUMERS */
   -2,  /* (256) cmd ::= SHOW SUBSCRIPTIONS */
   -5,  /* (257) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   -7,  /* (258) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   -3,  /* (259) cmd ::= SHOW VNODES NK_INTEGER */
   -3,  /* (260) cmd ::= SHOW VNODES NK_STRING */
   -3,  /* (261) cmd ::= SHOW db_name_cond_opt ALIVE */
   -3,  /* (262) cmd ::= SHOW CLUSTER ALIVE */
    0,  /* (263) db_name_cond_opt ::= */
   -2,  /* (264) db_name_cond_opt ::= db_name NK_DOT */
    0,  /* (265) like_pattern_opt ::= */
   -2,  /* (266) like_pattern_opt ::= LIKE NK_STRING */
   -1,  /* (267) table_name_cond ::= table_name */
    0,  /* (268) from_db_opt ::= */
   -2,  /* (269) from_db_opt ::= FROM db_name */
    0,  /* (270) tag_list_opt ::= */
   -1,  /* (271) tag_list_opt ::= tag_item */
   -3,  /* (272) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   -1,  /* (273) tag_item ::= TBNAME */
   -1,  /* (274) tag_item ::= QTAGS */
   -1,  /* (275) tag_item ::= column_name */
   -2,  /* (276) tag_item ::= column_name column_alias */
   -3,  /* (277) tag_item ::= column_name AS column_alias */
   -8,  /* (278) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
   -9,  /* (279) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
   -4,  /* (280) cmd ::= DROP INDEX exists_opt full_index_name */
   -1,  /* (281) full_index_name ::= index_name */
   -3,  /* (282) full_index_name ::= db_name NK_DOT index_name */
  -10,  /* (283) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  -12,  /* (284) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   -1,  /* (285) func_list ::= func */
   -3,  /* (286) func_list ::= func_list NK_COMMA func */
   -4,  /* (287) func ::= sma_func_name NK_LP expression_list NK_RP */
   -1,  /* (288) sma_func_name ::= function_name */
   -1,  /* (289) sma_func_name ::= COUNT */
   -1,  /* (290) sma_func_name ::= FIRST */
   -1,  /* (291) sma_func_name ::= LAST */
   -1,  /* (292) sma_func_name ::= LAST_ROW */
    0,  /* (293) sma_stream_opt ::= */
   -3,  /* (294) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   -3,  /* (295) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   -3,  /* (296) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   -6,  /* (297) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   -7,  /* (298) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
   -9,  /* (299) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
   -7,  /* (300) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
   -9,  /* (301) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
   -4,  /* (302) cmd ::= DROP TOPIC exists_opt topic_name */
   -7,  /* (303) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   -2,  /* (304) cmd ::= DESC full_table_name */
   -2,  /* (305) cmd ::= DESCRIBE full_table_name */
   -3,  /* (306) cmd ::= RESET QUERY CACHE */
   -4,  /* (307) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   -4,  /* (308) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
    0,  /* (309) analyze_opt ::= */
   -1,  /* (310) analyze_opt ::= ANALYZE */
    0,  /* (311) explain_options ::= */
   -3,  /* (312) explain_options ::= explain_options VERBOSE NK_BOOL */
   -3,  /* (313) explain_options ::= explain_options RATIO NK_FLOAT */
  -12,  /* (314) cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
   -4,  /* (315) cmd ::= DROP FUNCTION exists_opt function_name */
    0,  /* (316) agg_func_opt ::= */
   -1,  /* (317) agg_func_opt ::= AGGREGATE */
    0,  /* (318) bufsize_opt ::= */
   -2,  /* (319) bufsize_opt ::= BUFSIZE NK_INTEGER */
    0,  /* (320) language_opt ::= */
   -2,  /* (321) language_opt ::= LANGUAGE NK_STRING */
    0,  /* (322) or_replace_opt ::= */
   -2,  /* (323) or_replace_opt ::= OR REPLACE */
  -12,  /* (324) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
   -4,  /* (325) cmd ::= DROP STREAM exists_opt stream_name */
    0,  /* (326) col_list_opt ::= */
   -3,  /* (327) col_list_opt ::= NK_LP col_name_list NK_RP */
    0,  /* (328) tag_def_or_ref_opt ::= */
   -1,  /* (329) tag_def_or_ref_opt ::= tags_def */
   -4,  /* (330) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
    0,  /* (331) stream_options ::= */
   -3,  /* (332) stream_options ::= stream_options TRIGGER AT_ONCE */
   -3,  /* (333) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   -4,  /* (334) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   -3,  /* (335) stream_options ::= stream_options WATERMARK duration_literal */
   -4,  /* (336) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   -3,  /* (337) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   -3,  /* (338) stream_options ::= stream_options DELETE_MARK duration_literal */
   -4,  /* (339) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
    0,  /* (340) subtable_opt ::= */
   -4,  /* (341) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
   -3,  /* (342) cmd ::= KILL CONNECTION NK_INTEGER */
   -3,  /* (343) cmd ::= KILL QUERY NK_STRING */
   -3,  /* (344) cmd ::= KILL TRANSACTION NK_INTEGER */
   -2,  /* (345) cmd ::= BALANCE VGROUP */
   -3,  /* (346) cmd ::= BALANCE VGROUP LEADER */
   -4,  /* (347) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   -4,  /* (348) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   -3,  /* (349) cmd ::= SPLIT VGROUP NK_INTEGER */
   -2,  /* (350) dnode_list ::= DNODE NK_INTEGER */
   -3,  /* (351) dnode_list ::= dnode_list DNODE NK_INTEGER */
   -4,  /* (352) cmd ::= DELETE FROM full_table_name where_clause_opt */
   -1,  /* (353) cmd ::= query_or_subquery */
   -1,  /* (354) cmd ::= insert_query */
   -7,  /* (355) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   -4,  /* (356) insert_query ::= INSERT INTO full_table_name query_or_subquery */
   -1,  /* (357) literal ::= NK_INTEGER */
   -1,  /* (358) literal ::= NK_FLOAT */
   -1,  /* (359) literal ::= NK_STRING */
   -1,  /* (360) literal ::= NK_BOOL */
   -2,  /* (361) literal ::= TIMESTAMP NK_STRING */
   -1,  /* (362) literal ::= duration_literal */
   -1,  /* (363) literal ::= NULL */
   -1,  /* (364) literal ::= NK_QUESTION */
   -1,  /* (365) duration_literal ::= NK_VARIABLE */
   -1,  /* (366) signed ::= NK_INTEGER */
   -2,  /* (367) signed ::= NK_PLUS NK_INTEGER */
   -2,  /* (368) signed ::= NK_MINUS NK_INTEGER */
   -1,  /* (369) signed ::= NK_FLOAT */
   -2,  /* (370) signed ::= NK_PLUS NK_FLOAT */
   -2,  /* (371) signed ::= NK_MINUS NK_FLOAT */
   -1,  /* (372) signed_literal ::= signed */
   -1,  /* (373) signed_literal ::= NK_STRING */
   -1,  /* (374) signed_literal ::= NK_BOOL */
   -2,  /* (375) signed_literal ::= TIMESTAMP NK_STRING */
   -1,  /* (376) signed_literal ::= duration_literal */
   -1,  /* (377) signed_literal ::= NULL */
   -1,  /* (378) signed_literal ::= literal_func */
   -1,  /* (379) signed_literal ::= NK_QUESTION */
   -1,  /* (380) literal_list ::= signed_literal */
   -3,  /* (381) literal_list ::= literal_list NK_COMMA signed_literal */
   -1,  /* (382) db_name ::= NK_ID */
   -1,  /* (383) table_name ::= NK_ID */
   -1,  /* (384) column_name ::= NK_ID */
   -1,  /* (385) function_name ::= NK_ID */
   -1,  /* (386) table_alias ::= NK_ID */
   -1,  /* (387) column_alias ::= NK_ID */
   -1,  /* (388) user_name ::= NK_ID */
   -1,  /* (389) topic_name ::= NK_ID */
   -1,  /* (390) stream_name ::= NK_ID */
   -1,  /* (391) cgroup_name ::= NK_ID */
   -1,  /* (392) index_name ::= NK_ID */
   -1,  /* (393) expr_or_subquery ::= expression */
   -1,  /* (394) expression ::= literal */
   -1,  /* (395) expression ::= pseudo_column */
   -1,  /* (396) expression ::= column_reference */
   -1,  /* (397) expression ::= function_expression */
   -1,  /* (398) expression ::= case_when_expression */
   -3,  /* (399) expression ::= NK_LP expression NK_RP */
   -2,  /* (400) expression ::= NK_PLUS expr_or_subquery */
   -2,  /* (401) expression ::= NK_MINUS expr_or_subquery */
   -3,  /* (402) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   -3,  /* (403) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   -3,  /* (404) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   -3,  /* (405) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   -3,  /* (406) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   -3,  /* (407) expression ::= column_reference NK_ARROW NK_STRING */
   -3,  /* (408) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   -3,  /* (409) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   -1,  /* (410) expression_list ::= expr_or_subquery */
   -3,  /* (411) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   -1,  /* (412) column_reference ::= column_name */
   -3,  /* (413) column_reference ::= table_name NK_DOT column_name */
   -1,  /* (414) pseudo_column ::= ROWTS */
   -1,  /* (415) pseudo_column ::= TBNAME */
   -3,  /* (416) pseudo_column ::= table_name NK_DOT TBNAME */
   -1,  /* (417) pseudo_column ::= QSTART */
   -1,  /* (418) pseudo_column ::= QEND */
   -1,  /* (419) pseudo_column ::= QDURATION */
   -1,  /* (420) pseudo_column ::= WSTART */
   -1,  /* (421) pseudo_column ::= WEND */
   -1,  /* (422) pseudo_column ::= WDURATION */
   -1,  /* (423) pseudo_column ::= IROWTS */
   -1,  /* (424) pseudo_column ::= ISFILLED */
   -1,  /* (425) pseudo_column ::= QTAGS */
   -4,  /* (426) function_expression ::= function_name NK_LP expression_list NK_RP */
   -4,  /* (427) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   -6,  /* (428) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   -1,  /* (429) function_expression ::= literal_func */
   -3,  /* (430) literal_func ::= noarg_func NK_LP NK_RP */
   -1,  /* (431) literal_func ::= NOW */
   -1,  /* (432) noarg_func ::= NOW */
   -1,  /* (433) noarg_func ::= TODAY */
   -1,  /* (434) noarg_func ::= TIMEZONE */
   -1,  /* (435) noarg_func ::= DATABASE */
   -1,  /* (436) noarg_func ::= CLIENT_VERSION */
   -1,  /* (437) noarg_func ::= SERVER_VERSION */
   -1,  /* (438) noarg_func ::= SERVER_STATUS */
   -1,  /* (439) noarg_func ::= CURRENT_USER */
   -1,  /* (440) noarg_func ::= USER */
   -1,  /* (441) star_func ::= COUNT */
   -1,  /* (442) star_func ::= FIRST */
   -1,  /* (443) star_func ::= LAST */
   -1,  /* (444) star_func ::= LAST_ROW */
   -1,  /* (445) star_func_para_list ::= NK_STAR */
   -1,  /* (446) star_func_para_list ::= other_para_list */
   -1,  /* (447) other_para_list ::= star_func_para */
   -3,  /* (448) other_para_list ::= other_para_list NK_COMMA star_func_para */
   -1,  /* (449) star_func_para ::= expr_or_subquery */
   -3,  /* (450) star_func_para ::= table_name NK_DOT NK_STAR */
   -4,  /* (451) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   -5,  /* (452) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   -1,  /* (453) when_then_list ::= when_then_expr */
   -2,  /* (454) when_then_list ::= when_then_list when_then_expr */
   -4,  /* (455) when_then_expr ::= WHEN common_expression THEN common_expression */
    0,  /* (456) case_when_else_opt ::= */
   -2,  /* (457) case_when_else_opt ::= ELSE common_expression */
   -3,  /* (458) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   -5,  /* (459) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   -6,  /* (460) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   -3,  /* (461) predicate ::= expr_or_subquery IS NULL */
   -4,  /* (462) predicate ::= expr_or_subquery IS NOT NULL */
   -3,  /* (463) predicate ::= expr_or_subquery in_op in_predicate_value */
   -1,  /* (464) compare_op ::= NK_LT */
   -1,  /* (465) compare_op ::= NK_GT */
   -1,  /* (466) compare_op ::= NK_LE */
   -1,  /* (467) compare_op ::= NK_GE */
   -1,  /* (468) compare_op ::= NK_NE */
   -1,  /* (469) compare_op ::= NK_EQ */
   -1,  /* (470) compare_op ::= LIKE */
   -2,  /* (471) compare_op ::= NOT LIKE */
   -1,  /* (472) compare_op ::= MATCH */
   -1,  /* (473) compare_op ::= NMATCH */
   -1,  /* (474) compare_op ::= CONTAINS */
   -1,  /* (475) in_op ::= IN */
   -2,  /* (476) in_op ::= NOT IN */
   -3,  /* (477) in_predicate_value ::= NK_LP literal_list NK_RP */
   -1,  /* (478) boolean_value_expression ::= boolean_primary */
   -2,  /* (479) boolean_value_expression ::= NOT boolean_primary */
   -3,  /* (480) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   -3,  /* (481) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   -1,  /* (482) boolean_primary ::= predicate */
   -3,  /* (483) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   -1,  /* (484) common_expression ::= expr_or_subquery */
   -1,  /* (485) common_expression ::= boolean_value_expression */
    0,  /* (486) from_clause_opt ::= */
   -2,  /* (487) from_clause_opt ::= FROM table_reference_list */
   -1,  /* (488) table_reference_list ::= table_reference */
   -3,  /* (489) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   -1,  /* (490) table_reference ::= table_primary */
   -1,  /* (491) table_reference ::= joined_table */
   -2,  /* (492) table_primary ::= table_name alias_opt */
   -4,  /* (493) table_primary ::= db_name NK_DOT table_name alias_opt */
   -2,  /* (494) table_primary ::= subquery alias_opt */
   -1,  /* (495) table_primary ::= parenthesized_joined_table */
    0,  /* (496) alias_opt ::= */
   -1,  /* (497) alias_opt ::= table_alias */
   -2,  /* (498) alias_opt ::= AS table_alias */
   -3,  /* (499) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   -3,  /* (500) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   -6,  /* (501) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
    0,  /* (502) join_type ::= */
   -1,  /* (503) join_type ::= INNER */
  -12,  /* (504) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
    0,  /* (505) set_quantifier_opt ::= */
   -1,  /* (506) set_quantifier_opt ::= DISTINCT */
   -1,  /* (507) set_quantifier_opt ::= ALL */
   -1,  /* (508) select_list ::= select_item */
   -3,  /* (509) select_list ::= select_list NK_COMMA select_item */
   -1,  /* (510) select_item ::= NK_STAR */
   -1,  /* (511) select_item ::= common_expression */
   -2,  /* (512) select_item ::= common_expression column_alias */
   -3,  /* (513) select_item ::= common_expression AS column_alias */
   -3,  /* (514) select_item ::= table_name NK_DOT NK_STAR */
    0,  /* (515) where_clause_opt ::= */
   -2,  /* (516) where_clause_opt ::= WHERE search_condition */
    0,  /* (517) partition_by_clause_opt ::= */
   -3,  /* (518) partition_by_clause_opt ::= PARTITION BY partition_list */
   -1,  /* (519) partition_list ::= partition_item */
   -3,  /* (520) partition_list ::= partition_list NK_COMMA partition_item */
   -1,  /* (521) partition_item ::= expr_or_subquery */
   -2,  /* (522) partition_item ::= expr_or_subquery column_alias */
   -3,  /* (523) partition_item ::= expr_or_subquery AS column_alias */
    0,  /* (524) twindow_clause_opt ::= */
   -6,  /* (525) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   -4,  /* (526) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   -6,  /* (527) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   -8,  /* (528) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   -7,  /* (529) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
    0,  /* (530) sliding_opt ::= */
   -4,  /* (531) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
    0,  /* (532) fill_opt ::= */
   -4,  /* (533) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   -6,  /* (534) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
   -6,  /* (535) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
   -1,  /* (536) fill_mode ::= NONE */
   -1,  /* (537) fill_mode ::= PREV */
   -1,  /* (538) fill_mode ::= NULL */
   -1,  /* (539) fill_mode ::= NULL_F */
   -1,  /* (540) fill_mode ::= LINEAR */
   -1,  /* (541) fill_mode ::= NEXT */
    0,  /* (542) group_by_clause_opt ::= */
   -3,  /* (543) group_by_clause_opt ::= GROUP BY group_by_list */
   -1,  /* (544) group_by_list ::= expr_or_subquery */
   -3,  /* (545) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
    0,  /* (546) having_clause_opt ::= */
   -2,  /* (547) having_clause_opt ::= HAVING search_condition */
    0,  /* (548) range_opt ::= */
   -6,  /* (549) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
    0,  /* (550) every_opt ::= */
   -4,  /* (551) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   -4,  /* (552) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   -1,  /* (553) query_simple ::= query_specification */
   -1,  /* (554) query_simple ::= union_query_expression */
   -4,  /* (555) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   -3,  /* (556) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   -1,  /* (557) query_simple_or_subquery ::= query_simple */
   -1,  /* (558) query_simple_or_subquery ::= subquery */
   -1,  /* (559) query_or_subquery ::= query_expression */
   -1,  /* (560) query_or_subquery ::= subquery */
    0,  /* (561) order_by_clause_opt ::= */
   -3,  /* (562) order_by_clause_opt ::= ORDER BY sort_specification_list */
    0,  /* (563) slimit_clause_opt ::= */
   -2,  /* (564) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   -4,  /* (565) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   -4,  /* (566) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
    0,  /* (567) limit_clause_opt ::= */
   -2,  /* (568) limit_clause_opt ::= LIMIT NK_INTEGER */
   -4,  /* (569) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   -4,  /* (570) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   -3,  /* (571) subquery ::= NK_LP query_expression NK_RP */
   -3,  /* (572) subquery ::= NK_LP subquery NK_RP */
   -1,  /* (573) search_condition ::= common_expression */
   -1,  /* (574) sort_specification_list ::= sort_specification */
   -3,  /* (575) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   -3,  /* (576) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
    0,  /* (577) ordering_specification_opt ::= */
   -1,  /* (578) ordering_specification_opt ::= ASC */
   -1,  /* (579) ordering_specification_opt ::= DESC */
    0,  /* (580) null_ordering_opt ::= */
   -2,  /* (581) null_ordering_opt ::= NULLS FIRST */
   -2,  /* (582) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfoNRhs[yyruleno];
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
        yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,331,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,332,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,331,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,333,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,334,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,332,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,334,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,333,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy113, &yymsp[-1].minor.yy0, yymsp[0].minor.yy551); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy113, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy113, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy113, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy113); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy551 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy551 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-5].minor.yy837, &yymsp[-3].minor.yy777, &yymsp[0].minor.yy113, yymsp[-2].minor.yy448); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-5].minor.yy837, &yymsp[-3].minor.yy777, &yymsp[0].minor.yy113, yymsp[-2].minor.yy448); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy837 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy837 = yymsp[0].minor.yy837; }
  yymsp[0].minor.yy837 = yylhsminor.yy837;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy837 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy837 = yymsp[-2].minor.yy837 | yymsp[0].minor.yy837; }
  yymsp[-2].minor.yy837 = yylhsminor.yy837;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy837 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy837 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy777.first = yymsp[-2].minor.yy0; yylhsminor.yy777.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy777 = yylhsminor.yy777;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy777.first = yymsp[-2].minor.yy113; yylhsminor.yy777.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy777 = yylhsminor.yy777;
        break;
      case 42: /* priv_level ::= db_name NK_DOT table_name */
{ yylhsminor.yy777.first = yymsp[-2].minor.yy113; yylhsminor.yy777.second = yymsp[0].minor.yy113; }
  yymsp[-2].minor.yy777 = yylhsminor.yy777;
        break;
      case 43: /* priv_level ::= topic_name */
{ yylhsminor.yy777.first = yymsp[0].minor.yy113; yylhsminor.yy777.second = nil_token; }
  yymsp[0].minor.yy777 = yylhsminor.yy777;
        break;
      case 44: /* with_opt ::= */
      case 137: /* start_opt ::= */ yytestcase(yyruleno==137);
      case 141: /* end_opt ::= */ yytestcase(yyruleno==141);
      case 265: /* like_pattern_opt ::= */ yytestcase(yyruleno==265);
      case 340: /* subtable_opt ::= */ yytestcase(yyruleno==340);
      case 456: /* case_when_else_opt ::= */ yytestcase(yyruleno==456);
      case 486: /* from_clause_opt ::= */ yytestcase(yyruleno==486);
      case 515: /* where_clause_opt ::= */ yytestcase(yyruleno==515);
      case 524: /* twindow_clause_opt ::= */ yytestcase(yyruleno==524);
      case 530: /* sliding_opt ::= */ yytestcase(yyruleno==530);
      case 532: /* fill_opt ::= */ yytestcase(yyruleno==532);
      case 546: /* having_clause_opt ::= */ yytestcase(yyruleno==546);
      case 548: /* range_opt ::= */ yytestcase(yyruleno==548);
      case 550: /* every_opt ::= */ yytestcase(yyruleno==550);
      case 563: /* slimit_clause_opt ::= */ yytestcase(yyruleno==563);
      case 567: /* limit_clause_opt ::= */ yytestcase(yyruleno==567);
{ yymsp[1].minor.yy448 = NULL; }
        break;
      case 45: /* with_opt ::= WITH search_condition */
      case 487: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==487);
      case 516: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==516);
      case 547: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==547);
{ yymsp[-1].minor.yy448 = yymsp[0].minor.yy448; }
        break;
      case 46: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy113, NULL); }
        break;
      case 47: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy369); }
        break;
      case 49: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy113, yymsp[0].minor.yy369); }
        break;
      case 50: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 51: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 52: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* dnode_endpoint ::= NK_STRING */
      case 55: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==55);
      case 56: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==56);
      case 289: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==289);
      case 290: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==290);
      case 291: /* sma_func_name ::= LAST */ yytestcase(yyruleno==291);
      case 292: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==292);
      case 382: /* db_name ::= NK_ID */ yytestcase(yyruleno==382);
      case 383: /* table_name ::= NK_ID */ yytestcase(yyruleno==383);
      case 384: /* column_name ::= NK_ID */ yytestcase(yyruleno==384);
      case 385: /* function_name ::= NK_ID */ yytestcase(yyruleno==385);
      case 386: /* table_alias ::= NK_ID */ yytestcase(yyruleno==386);
      case 387: /* column_alias ::= NK_ID */ yytestcase(yyruleno==387);
      case 388: /* user_name ::= NK_ID */ yytestcase(yyruleno==388);
      case 389: /* topic_name ::= NK_ID */ yytestcase(yyruleno==389);
      case 390: /* stream_name ::= NK_ID */ yytestcase(yyruleno==390);
      case 391: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==391);
      case 392: /* index_name ::= NK_ID */ yytestcase(yyruleno==392);
      case 432: /* noarg_func ::= NOW */ yytestcase(yyruleno==432);
      case 433: /* noarg_func ::= TODAY */ yytestcase(yyruleno==433);
      case 434: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==434);
      case 435: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==435);
      case 436: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==436);
      case 437: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==437);
      case 438: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==438);
      case 439: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==439);
      case 440: /* noarg_func ::= USER */ yytestcase(yyruleno==440);
      case 441: /* star_func ::= COUNT */ yytestcase(yyruleno==441);
      case 442: /* star_func ::= FIRST */ yytestcase(yyruleno==442);
      case 443: /* star_func ::= LAST */ yytestcase(yyruleno==443);
      case 444: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==444);
{ yylhsminor.yy113 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy113 = yylhsminor.yy113;
        break;
      case 57: /* force_opt ::= */
      case 77: /* not_exists_opt ::= */ yytestcase(yyruleno==77);
      case 79: /* exists_opt ::= */ yytestcase(yyruleno==79);
      case 309: /* analyze_opt ::= */ yytestcase(yyruleno==309);
      case 316: /* agg_func_opt ::= */ yytestcase(yyruleno==316);
      case 322: /* or_replace_opt ::= */ yytestcase(yyruleno==322);
      case 505: /* set_quantifier_opt ::= */ yytestcase(yyruleno==505);
{ yymsp[1].minor.yy369 = false; }
        break;
      case 58: /* force_opt ::= FORCE */
      case 310: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==310);
      case 317: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==317);
      case 506: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==506);
{ yymsp[0].minor.yy369 = true; }
        break;
      case 59: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 60: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 67: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 68: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 69: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy369, &yymsp[-1].minor.yy113, yymsp[0].minor.yy448); }
        break;
      case 70: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy369, &yymsp[0].minor.yy113); }
        break;
      case 71: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy113); }
        break;
      case 72: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy113, yymsp[0].minor.yy448); }
        break;
      case 73: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy113); }
        break;
      case 74: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy113, yymsp[0].minor.yy788); }
        break;
      case 75: /* cmd ::= COMPACT DATABASE db_name start_opt end_opt */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[-2].minor.yy113, yymsp[-1].minor.yy448, yymsp[0].minor.yy448); }
        break;
      case 76: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy369 = true; }
        break;
      case 78: /* exists_opt ::= IF EXISTS */
      case 323: /* or_replace_opt ::= OR REPLACE */ yytestcase(yyruleno==323);
{ yymsp[-1].minor.yy369 = true; }
        break;
      case 80: /* db_options ::= */
{ yymsp[1].minor.yy448 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 81: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 82: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 83: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 84: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 85: /* db_options ::= db_options DURATION NK_INTEGER */
      case 86: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==86);
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 87: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 88: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 89: /* db_options ::= db_options KEEP integer_list */
      case 90: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==90);
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_KEEP, yymsp[0].minor.yy432); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 91: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 92: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 93: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 94: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 95: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 96: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 97: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 98: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_RETENTIONS, yymsp[0].minor.yy432); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 99: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 100: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 101: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 103: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-3].minor.yy448, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 104: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 105: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-3].minor.yy448, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 106: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 107: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 108: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 109: /* db_options ::= db_options TABLE_PREFIX signed */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_TABLE_PREFIX, yymsp[0].minor.yy448); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 110: /* db_options ::= db_options TABLE_SUFFIX signed */
{ yylhsminor.yy448 = setDatabaseOption(pCxt, yymsp[-2].minor.yy448, DB_OPTION_TABLE_SUFFIX, yymsp[0].minor.yy448); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 111: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy448 = createAlterDatabaseOptions(pCxt); yylhsminor.yy448 = setAlterDatabaseOption(pCxt, yylhsminor.yy448, &yymsp[0].minor.yy53); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 112: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy448 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy448, &yymsp[0].minor.yy53); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 113: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy53.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 115: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= KEEP integer_list */
      case 118: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==118);
{ yymsp[-1].minor.yy53.type = DB_OPTION_KEEP; yymsp[-1].minor.yy53.pList = yymsp[0].minor.yy432; }
        break;
      case 119: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_PAGES; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 121: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_WAL; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 122: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 123: /* alter_db_option ::= MINROWS NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_MINROWS; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 124: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 125: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy53.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-2].minor.yy53.val = t;
                                                                                  }
        break;
      case 126: /* alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
{ yymsp[-1].minor.yy53.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 127: /* alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy53.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-2].minor.yy53.val = t;
                                                                                  }
        break;
      case 128: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy432 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy432 = yylhsminor.yy432;
        break;
      case 129: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 351: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==351);
{ yylhsminor.yy432 = addNodeToList(pCxt, yymsp[-2].minor.yy432, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy432 = yylhsminor.yy432;
        break;
      case 130: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy432 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy432 = yylhsminor.yy432;
        break;
      case 131: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy432 = addNodeToList(pCxt, yymsp[-2].minor.yy432, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy432 = yylhsminor.yy432;
        break;
      case 132: /* retention_list ::= retention */
      case 162: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==162);
      case 165: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==165);
      case 172: /* column_def_list ::= column_def */ yytestcase(yyruleno==172);
      case 215: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==215);
      case 220: /* col_name_list ::= col_name */ yytestcase(yyruleno==220);
      case 271: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==271);
      case 285: /* func_list ::= func */ yytestcase(yyruleno==285);
      case 380: /* literal_list ::= signed_literal */ yytestcase(yyruleno==380);
      case 447: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==447);
      case 453: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==453);
      case 508: /* select_list ::= select_item */ yytestcase(yyruleno==508);
      case 519: /* partition_list ::= partition_item */ yytestcase(yyruleno==519);
      case 574: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==574);
{ yylhsminor.yy432 = createNodeList(pCxt, yymsp[0].minor.yy448); }
  yymsp[0].minor.yy432 = yylhsminor.yy432;
        break;
      case 133: /* retention_list ::= retention_list NK_COMMA retention */
      case 166: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==166);
      case 173: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==173);
      case 216: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==216);
      case 221: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==221);
      case 272: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==272);
      case 286: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==286);
      case 381: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==381);
      case 448: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==448);
      case 509: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==509);
      case 520: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==520);
      case 575: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==575);
{ yylhsminor.yy432 = addNodeToList(pCxt, yymsp[-2].minor.yy432, yymsp[0].minor.yy448); }
  yymsp[-2].minor.yy432 = yylhsminor.yy432;
        break;
      case 134: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy448 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 135: /* speed_opt ::= */
      case 318: /* bufsize_opt ::= */ yytestcase(yyruleno==318);
{ yymsp[1].minor.yy788 = 0; }
        break;
      case 136: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 319: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==319);
{ yymsp[-1].minor.yy788 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 138: /* start_opt ::= START WITH NK_INTEGER */
      case 142: /* end_opt ::= END WITH NK_INTEGER */ yytestcase(yyruleno==142);
{ yymsp[-2].minor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 139: /* start_opt ::= START WITH NK_STRING */
      case 143: /* end_opt ::= END WITH NK_STRING */ yytestcase(yyruleno==143);
{ yymsp[-2].minor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 140: /* start_opt ::= START WITH TIMESTAMP NK_STRING */
      case 144: /* end_opt ::= END WITH TIMESTAMP NK_STRING */ yytestcase(yyruleno==144);
{ yymsp[-3].minor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 145: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 147: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==147);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy369, yymsp[-5].minor.yy448, yymsp[-3].minor.yy432, yymsp[-1].minor.yy432, yymsp[0].minor.yy448); }
        break;
      case 146: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy432); }
        break;
      case 148: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy432); }
        break;
      case 149: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy369, yymsp[0].minor.yy448); }
        break;
      case 150: /* cmd ::= ALTER TABLE alter_table_clause */
      case 353: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==353);
      case 354: /* cmd ::= insert_query */ yytestcase(yyruleno==354);
{ pCxt->pRootNode = yymsp[0].minor.yy448; }
        break;
      case 151: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy448); }
        break;
      case 152: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy448 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy448, yymsp[0].minor.yy448); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 153: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy448 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy448, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy113, yymsp[0].minor.yy728); }
  yymsp[-4].minor.yy448 = yylhsminor.yy448;
        break;
      case 154: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy448 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy448, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy113); }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 155: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy448 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy448, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy113, yymsp[0].minor.yy728); }
  yymsp[-4].minor.yy448 = yylhsminor.yy448;
        break;
      case 156: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy448 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy448, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy113, &yymsp[0].minor.yy113); }
  yymsp[-4].minor.yy448 = yylhsminor.yy448;
        break;
      case 157: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy448 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy448, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy113, yymsp[0].minor.yy728); }
  yymsp[-4].minor.yy448 = yylhsminor.yy448;
        break;
      case 158: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy448 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy448, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy113); }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 159: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy448 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy448, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy113, yymsp[0].minor.yy728); }
  yymsp[-4].minor.yy448 = yylhsminor.yy448;
        break;
      case 160: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy448 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy448, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy113, &yymsp[0].minor.yy113); }
  yymsp[-4].minor.yy448 = yylhsminor.yy448;
        break;
      case 161: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy448 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy448, &yymsp[-2].minor.yy113, yymsp[0].minor.yy448); }
  yymsp[-5].minor.yy448 = yylhsminor.yy448;
        break;
      case 163: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 454: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==454);
{ yylhsminor.yy432 = addNodeToList(pCxt, yymsp[-1].minor.yy432, yymsp[0].minor.yy448); }
  yymsp[-1].minor.yy432 = yylhsminor.yy432;
        break;
      case 164: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy448 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy369, yymsp[-8].minor.yy448, yymsp[-6].minor.yy448, yymsp[-5].minor.yy432, yymsp[-2].minor.yy432, yymsp[0].minor.yy448); }
  yymsp[-9].minor.yy448 = yylhsminor.yy448;
        break;
      case 167: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy448 = createDropTableClause(pCxt, yymsp[-1].minor.yy369, yymsp[0].minor.yy448); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 168: /* specific_cols_opt ::= */
      case 198: /* tags_def_opt ::= */ yytestcase(yyruleno==198);
      case 270: /* tag_list_opt ::= */ yytestcase(yyruleno==270);
      case 326: /* col_list_opt ::= */ yytestcase(yyruleno==326);
      case 328: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==328);
      case 517: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==517);
      case 542: /* group_by_clause_opt ::= */ yytestcase(yyruleno==542);
      case 561: /* order_by_clause_opt ::= */ yytestcase(yyruleno==561);
{ yymsp[1].minor.yy432 = NULL; }
        break;
      case 169: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 327: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==327);
{ yymsp[-2].minor.yy432 = yymsp[-1].minor.yy432; }
        break;
      case 170: /* full_table_name ::= table_name */
{ yylhsminor.yy448 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy113, NULL); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 171: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy448 = createRealTableNode(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy113, NULL); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 174: /* column_def ::= column_name type_name */
{ yylhsminor.yy448 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy113, yymsp[0].minor.yy728, NULL); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 175: /* type_name ::= BOOL */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 176: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 177: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 178: /* type_name ::= INT */
      case 179: /* type_name ::= INTEGER */ yytestcase(yyruleno==179);
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 180: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 181: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 182: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 183: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy728 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 184: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 185: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy728 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 186: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy728 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 187: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy728 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 188: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy728 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 189: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy728 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 190: /* type_name ::= JSON */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 191: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy728 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 192: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 193: /* type_name ::= BLOB */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 194: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy728 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 195: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy728 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 196: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy728 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 197: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy728 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 199: /* tags_def_opt ::= tags_def */
      case 329: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==329);
      case 446: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==446);
{ yylhsminor.yy432 = yymsp[0].minor.yy432; }
  yymsp[0].minor.yy432 = yylhsminor.yy432;
        break;
      case 200: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 330: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==330);
{ yymsp[-3].minor.yy432 = yymsp[-1].minor.yy432; }
        break;
      case 201: /* table_options ::= */
{ yymsp[1].minor.yy448 = createDefaultTableOptions(pCxt); }
        break;
      case 202: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy448 = setTableOption(pCxt, yymsp[-2].minor.yy448, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 203: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy448 = setTableOption(pCxt, yymsp[-2].minor.yy448, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy432); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 204: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy448 = setTableOption(pCxt, yymsp[-2].minor.yy448, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy432); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 205: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy448 = setTableOption(pCxt, yymsp[-4].minor.yy448, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy432); }
  yymsp[-4].minor.yy448 = yylhsminor.yy448;
        break;
      case 206: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy448 = setTableOption(pCxt, yymsp[-2].minor.yy448, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 207: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy448 = setTableOption(pCxt, yymsp[-4].minor.yy448, TABLE_OPTION_SMA, yymsp[-1].minor.yy432); }
  yymsp[-4].minor.yy448 = yylhsminor.yy448;
        break;
      case 208: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy448 = setTableOption(pCxt, yymsp[-2].minor.yy448, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy432); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 209: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy448 = createAlterTableOptions(pCxt); yylhsminor.yy448 = setTableOption(pCxt, yylhsminor.yy448, yymsp[0].minor.yy53.type, &yymsp[0].minor.yy53.val); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 210: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy448 = setTableOption(pCxt, yymsp[-1].minor.yy448, yymsp[0].minor.yy53.type, &yymsp[0].minor.yy53.val); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 211: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy53.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 212: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy53.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy53.val = yymsp[0].minor.yy0; }
        break;
      case 213: /* duration_list ::= duration_literal */
      case 410: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==410);
{ yylhsminor.yy432 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy448)); }
  yymsp[0].minor.yy432 = yylhsminor.yy432;
        break;
      case 214: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 411: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==411);
{ yylhsminor.yy432 = addNodeToList(pCxt, yymsp[-2].minor.yy432, releaseRawExprNode(pCxt, yymsp[0].minor.yy448)); }
  yymsp[-2].minor.yy432 = yylhsminor.yy432;
        break;
      case 217: /* rollup_func_name ::= function_name */
{ yylhsminor.yy448 = createFunctionNode(pCxt, &yymsp[0].minor.yy113, NULL); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 218: /* rollup_func_name ::= FIRST */
      case 219: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==219);
      case 274: /* tag_item ::= QTAGS */ yytestcase(yyruleno==274);
{ yylhsminor.yy448 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 222: /* col_name ::= column_name */
      case 275: /* tag_item ::= column_name */ yytestcase(yyruleno==275);
{ yylhsminor.yy448 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy113); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 223: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 224: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 225: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 226: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 227: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy448, yymsp[0].minor.yy448, OP_TYPE_LIKE); }
        break;
      case 228: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy448, yymsp[0].minor.yy448, OP_TYPE_LIKE); }
        break;
      case 229: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy448, NULL, OP_TYPE_LIKE); }
        break;
      case 230: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 231: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 232: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 233: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy448, yymsp[-1].minor.yy448, OP_TYPE_EQUAL); }
        break;
      case 234: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 235: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 236: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 237: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 238: /* cmd ::= SHOW LICENCES */
      case 239: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==239);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 240: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy113); }
        break;
      case 241: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy448); }
        break;
      case 242: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy448); }
        break;
      case 243: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 244: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 245: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 246: /* cmd ::= SHOW VARIABLES */
      case 247: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==247);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 248: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 249: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy448); }
        break;
      case 250: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 251: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 252: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 253: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 254: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy448); }
        break;
      case 255: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 256: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 257: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy448, yymsp[-1].minor.yy448, OP_TYPE_EQUAL); }
        break;
      case 258: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy448, yymsp[0].minor.yy448, yymsp[-3].minor.yy432); }
        break;
      case 259: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 260: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 261: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy448,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 262: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 263: /* db_name_cond_opt ::= */
      case 268: /* from_db_opt ::= */ yytestcase(yyruleno==268);
{ yymsp[1].minor.yy448 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 264: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy448 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy113); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 266: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 267: /* table_name_cond ::= table_name */
{ yylhsminor.yy448 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy113); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 269: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy448 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy113); }
        break;
      case 273: /* tag_item ::= TBNAME */
{ yylhsminor.yy448 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 276: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy448 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy113), &yymsp[0].minor.yy113); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 277: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy448 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy113), &yymsp[0].minor.yy113); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 278: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy369, yymsp[-3].minor.yy448, yymsp[-1].minor.yy448, NULL, yymsp[0].minor.yy448); }
        break;
      case 279: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy369, yymsp[-5].minor.yy448, yymsp[-3].minor.yy448, yymsp[-1].minor.yy432, NULL); }
        break;
      case 280: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy369, yymsp[0].minor.yy448); }
        break;
      case 281: /* full_index_name ::= index_name */
{ yylhsminor.yy448 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy113); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 282: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy448 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy113); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 283: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy448 = createIndexOption(pCxt, yymsp[-7].minor.yy432, releaseRawExprNode(pCxt, yymsp[-3].minor.yy448), NULL, yymsp[-1].minor.yy448, yymsp[0].minor.yy448); }
        break;
      case 284: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy448 = createIndexOption(pCxt, yymsp[-9].minor.yy432, releaseRawExprNode(pCxt, yymsp[-5].minor.yy448), releaseRawExprNode(pCxt, yymsp[-3].minor.yy448), yymsp[-1].minor.yy448, yymsp[0].minor.yy448); }
        break;
      case 287: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy448 = createFunctionNode(pCxt, &yymsp[-3].minor.yy113, yymsp[-1].minor.yy432); }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 288: /* sma_func_name ::= function_name */
      case 497: /* alias_opt ::= table_alias */ yytestcase(yyruleno==497);
{ yylhsminor.yy113 = yymsp[0].minor.yy113; }
  yymsp[0].minor.yy113 = yylhsminor.yy113;
        break;
      case 293: /* sma_stream_opt ::= */
      case 331: /* stream_options ::= */ yytestcase(yyruleno==331);
{ yymsp[1].minor.yy448 = createStreamOptions(pCxt); }
        break;
      case 294: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy448)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy448); yylhsminor.yy448 = yymsp[-2].minor.yy448; }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 295: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy448)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy448); yylhsminor.yy448 = yymsp[-2].minor.yy448; }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 296: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy448)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy448); yylhsminor.yy448 = yymsp[-2].minor.yy448; }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 297: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy369, &yymsp[-2].minor.yy113, yymsp[0].minor.yy448); }
        break;
      case 298: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy369, &yymsp[-3].minor.yy113, &yymsp[0].minor.yy113, false); }
        break;
      case 299: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy369, &yymsp[-5].minor.yy113, &yymsp[0].minor.yy113, true); }
        break;
      case 300: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy369, &yymsp[-3].minor.yy113, yymsp[0].minor.yy448, false); }
        break;
      case 301: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy369, &yymsp[-5].minor.yy113, yymsp[0].minor.yy448, true); }
        break;
      case 302: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy369, &yymsp[0].minor.yy113); }
        break;
      case 303: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy369, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy113); }
        break;
      case 304: /* cmd ::= DESC full_table_name */
      case 305: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==305);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy448); }
        break;
      case 306: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 307: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 308: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==308);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy369, yymsp[-1].minor.yy448, yymsp[0].minor.yy448); }
        break;
      case 311: /* explain_options ::= */
{ yymsp[1].minor.yy448 = createDefaultExplainOptions(pCxt); }
        break;
      case 312: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy448 = setExplainVerbose(pCxt, yymsp[-2].minor.yy448, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 313: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy448 = setExplainRatio(pCxt, yymsp[-2].minor.yy448, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 314: /* cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy369, yymsp[-9].minor.yy369, &yymsp[-6].minor.yy113, &yymsp[-4].minor.yy0, yymsp[-2].minor.yy728, yymsp[-1].minor.yy788, &yymsp[0].minor.yy113, yymsp[-10].minor.yy369); }
        break;
      case 315: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy369, &yymsp[0].minor.yy113); }
        break;
      case 320: /* language_opt ::= */
{ yymsp[1].minor.yy113 = nil_token; }
        break;
      case 321: /* language_opt ::= LANGUAGE NK_STRING */
{ yymsp[-1].minor.yy113 = yymsp[0].minor.yy0; }
        break;
      case 324: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy369, &yymsp[-8].minor.yy113, yymsp[-5].minor.yy448, yymsp[-7].minor.yy448, yymsp[-3].minor.yy432, yymsp[-2].minor.yy448, yymsp[0].minor.yy448, yymsp[-4].minor.yy432); }
        break;
      case 325: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy369, &yymsp[0].minor.yy113); }
        break;
      case 332: /* stream_options ::= stream_options TRIGGER AT_ONCE */
      case 333: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */ yytestcase(yyruleno==333);
{ yylhsminor.yy448 = setStreamOptions(pCxt, yymsp[-2].minor.yy448, SOPT_TRIGGER_TYPE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 334: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ yylhsminor.yy448 = setStreamOptions(pCxt, yymsp[-3].minor.yy448, SOPT_TRIGGER_TYPE_SET, &yymsp[-1].minor.yy0, releaseRawExprNode(pCxt, yymsp[0].minor.yy448)); }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 335: /* stream_options ::= stream_options WATERMARK duration_literal */
{ yylhsminor.yy448 = setStreamOptions(pCxt, yymsp[-2].minor.yy448, SOPT_WATERMARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy448)); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 336: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ yylhsminor.yy448 = setStreamOptions(pCxt, yymsp[-3].minor.yy448, SOPT_IGNORE_EXPIRED_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 337: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ yylhsminor.yy448 = setStreamOptions(pCxt, yymsp[-2].minor.yy448, SOPT_FILL_HISTORY_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 338: /* stream_options ::= stream_options DELETE_MARK duration_literal */
{ yylhsminor.yy448 = setStreamOptions(pCxt, yymsp[-2].minor.yy448, SOPT_DELETE_MARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy448)); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 339: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ yylhsminor.yy448 = setStreamOptions(pCxt, yymsp[-3].minor.yy448, SOPT_IGNORE_UPDATE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 341: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 531: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==531);
      case 551: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==551);
{ yymsp[-3].minor.yy448 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy448); }
        break;
      case 342: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 343: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 344: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 345: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 346: /* cmd ::= BALANCE VGROUP LEADER */
{ pCxt->pRootNode = createBalanceVgroupLeaderStmt(pCxt); }
        break;
      case 347: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 348: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy432); }
        break;
      case 349: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 350: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy432 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 352: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy448, yymsp[0].minor.yy448); }
        break;
      case 355: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy448 = createInsertStmt(pCxt, yymsp[-4].minor.yy448, yymsp[-2].minor.yy432, yymsp[0].minor.yy448); }
        break;
      case 356: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy448 = createInsertStmt(pCxt, yymsp[-1].minor.yy448, NULL, yymsp[0].minor.yy448); }
        break;
      case 357: /* literal ::= NK_INTEGER */
{ yylhsminor.yy448 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 358: /* literal ::= NK_FLOAT */
{ yylhsminor.yy448 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 359: /* literal ::= NK_STRING */
{ yylhsminor.yy448 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 360: /* literal ::= NK_BOOL */
{ yylhsminor.yy448 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 361: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 362: /* literal ::= duration_literal */
      case 372: /* signed_literal ::= signed */ yytestcase(yyruleno==372);
      case 393: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==393);
      case 394: /* expression ::= literal */ yytestcase(yyruleno==394);
      case 395: /* expression ::= pseudo_column */ yytestcase(yyruleno==395);
      case 396: /* expression ::= column_reference */ yytestcase(yyruleno==396);
      case 397: /* expression ::= function_expression */ yytestcase(yyruleno==397);
      case 398: /* expression ::= case_when_expression */ yytestcase(yyruleno==398);
      case 429: /* function_expression ::= literal_func */ yytestcase(yyruleno==429);
      case 478: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==478);
      case 482: /* boolean_primary ::= predicate */ yytestcase(yyruleno==482);
      case 484: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==484);
      case 485: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==485);
      case 488: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==488);
      case 490: /* table_reference ::= table_primary */ yytestcase(yyruleno==490);
      case 491: /* table_reference ::= joined_table */ yytestcase(yyruleno==491);
      case 495: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==495);
      case 553: /* query_simple ::= query_specification */ yytestcase(yyruleno==553);
      case 554: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==554);
      case 557: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==557);
      case 559: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==559);
{ yylhsminor.yy448 = yymsp[0].minor.yy448; }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 363: /* literal ::= NULL */
{ yylhsminor.yy448 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 364: /* literal ::= NK_QUESTION */
{ yylhsminor.yy448 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 365: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy448 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 366: /* signed ::= NK_INTEGER */
{ yylhsminor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 367: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 368: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 369: /* signed ::= NK_FLOAT */
{ yylhsminor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 370: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 371: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 373: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 374: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 375: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 376: /* signed_literal ::= duration_literal */
      case 378: /* signed_literal ::= literal_func */ yytestcase(yyruleno==378);
      case 449: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==449);
      case 511: /* select_item ::= common_expression */ yytestcase(yyruleno==511);
      case 521: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==521);
      case 558: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==558);
      case 560: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==560);
      case 573: /* search_condition ::= common_expression */ yytestcase(yyruleno==573);
{ yylhsminor.yy448 = releaseRawExprNode(pCxt, yymsp[0].minor.yy448); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 377: /* signed_literal ::= NULL */
{ yylhsminor.yy448 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 379: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy448 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 399: /* expression ::= NK_LP expression NK_RP */
      case 483: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==483);
      case 572: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==572);
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy448)); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 400: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy448));
                                                                                  }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 401: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy448), NULL));
                                                                                  }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 402: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448))); 
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 403: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448))); 
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 404: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448))); 
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 405: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448))); 
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 406: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448)));
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 407: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 408: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448)));
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 409: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448)));
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 412: /* column_reference ::= column_name */
{ yylhsminor.yy448 = createRawExprNode(pCxt, &yymsp[0].minor.yy113, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy113)); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 413: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy113, createColumnNode(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy113)); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 414: /* pseudo_column ::= ROWTS */
      case 415: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==415);
      case 417: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==417);
      case 418: /* pseudo_column ::= QEND */ yytestcase(yyruleno==418);
      case 419: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==419);
      case 420: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==420);
      case 421: /* pseudo_column ::= WEND */ yytestcase(yyruleno==421);
      case 422: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==422);
      case 423: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==423);
      case 424: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==424);
      case 425: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==425);
      case 431: /* literal_func ::= NOW */ yytestcase(yyruleno==431);
{ yylhsminor.yy448 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 416: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy113)))); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 426: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 427: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==427);
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy113, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy113, yymsp[-1].minor.yy432)); }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 428: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy448), yymsp[-1].minor.yy728)); }
  yymsp[-5].minor.yy448 = yylhsminor.yy448;
        break;
      case 430: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy113, NULL)); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 445: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy432 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy432 = yylhsminor.yy432;
        break;
      case 450: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 514: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==514);
{ yylhsminor.yy448 = createColumnNode(pCxt, &yymsp[-2].minor.yy113, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 451: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy432, yymsp[-1].minor.yy448)); }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 452: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy448), yymsp[-2].minor.yy432, yymsp[-1].minor.yy448)); }
  yymsp[-4].minor.yy448 = yylhsminor.yy448;
        break;
      case 455: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy448 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448)); }
        break;
      case 457: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy448 = releaseRawExprNode(pCxt, yymsp[0].minor.yy448); }
        break;
      case 458: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 463: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==463);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy156, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448)));
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 459: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy448), releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448)));
                                                                                  }
  yymsp[-4].minor.yy448 = yylhsminor.yy448;
        break;
      case 460: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy448), releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448)));
                                                                                  }
  yymsp[-5].minor.yy448 = yylhsminor.yy448;
        break;
      case 461: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), NULL));
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 462: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy448), NULL));
                                                                                  }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 464: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy156 = OP_TYPE_LOWER_THAN; }
        break;
      case 465: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy156 = OP_TYPE_GREATER_THAN; }
        break;
      case 466: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy156 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 467: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy156 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 468: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy156 = OP_TYPE_NOT_EQUAL; }
        break;
      case 469: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy156 = OP_TYPE_EQUAL; }
        break;
      case 470: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy156 = OP_TYPE_LIKE; }
        break;
      case 471: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy156 = OP_TYPE_NOT_LIKE; }
        break;
      case 472: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy156 = OP_TYPE_MATCH; }
        break;
      case 473: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy156 = OP_TYPE_NMATCH; }
        break;
      case 474: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy156 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 475: /* in_op ::= IN */
{ yymsp[0].minor.yy156 = OP_TYPE_IN; }
        break;
      case 476: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy156 = OP_TYPE_NOT_IN; }
        break;
      case 477: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy432)); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 479: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy448), NULL));
                                                                                  }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 480: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448)));
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 481: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy448);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy448);
                                                                                    yylhsminor.yy448 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), releaseRawExprNode(pCxt, yymsp[0].minor.yy448)));
                                                                                  }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 489: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy448 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy448, yymsp[0].minor.yy448, NULL); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 492: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy448 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy113, &yymsp[0].minor.yy113); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 493: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy448 = createRealTableNode(pCxt, &yymsp[-3].minor.yy113, &yymsp[-1].minor.yy113, &yymsp[0].minor.yy113); }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 494: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy448 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy448), &yymsp[0].minor.yy113); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 496: /* alias_opt ::= */
{ yymsp[1].minor.yy113 = nil_token;  }
        break;
      case 498: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy113 = yymsp[0].minor.yy113; }
        break;
      case 499: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 500: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==500);
{ yymsp[-2].minor.yy448 = yymsp[-1].minor.yy448; }
        break;
      case 501: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy448 = createJoinTableNode(pCxt, yymsp[-4].minor.yy596, yymsp[-5].minor.yy448, yymsp[-2].minor.yy448, yymsp[0].minor.yy448); }
  yymsp[-5].minor.yy448 = yylhsminor.yy448;
        break;
      case 502: /* join_type ::= */
{ yymsp[1].minor.yy596 = JOIN_TYPE_INNER; }
        break;
      case 503: /* join_type ::= INNER */
{ yymsp[0].minor.yy596 = JOIN_TYPE_INNER; }
        break;
      case 504: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy448 = createSelectStmt(pCxt, yymsp[-10].minor.yy369, yymsp[-9].minor.yy432, yymsp[-8].minor.yy448);
                                                                                    yymsp[-11].minor.yy448 = addWhereClause(pCxt, yymsp[-11].minor.yy448, yymsp[-7].minor.yy448);
                                                                                    yymsp[-11].minor.yy448 = addPartitionByClause(pCxt, yymsp[-11].minor.yy448, yymsp[-6].minor.yy432);
                                                                                    yymsp[-11].minor.yy448 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy448, yymsp[-2].minor.yy448);
                                                                                    yymsp[-11].minor.yy448 = addGroupByClause(pCxt, yymsp[-11].minor.yy448, yymsp[-1].minor.yy432);
                                                                                    yymsp[-11].minor.yy448 = addHavingClause(pCxt, yymsp[-11].minor.yy448, yymsp[0].minor.yy448);
                                                                                    yymsp[-11].minor.yy448 = addRangeClause(pCxt, yymsp[-11].minor.yy448, yymsp[-5].minor.yy448);
                                                                                    yymsp[-11].minor.yy448 = addEveryClause(pCxt, yymsp[-11].minor.yy448, yymsp[-4].minor.yy448);
                                                                                    yymsp[-11].minor.yy448 = addFillClause(pCxt, yymsp[-11].minor.yy448, yymsp[-3].minor.yy448);
                                                                                  }
        break;
      case 507: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy369 = false; }
        break;
      case 510: /* select_item ::= NK_STAR */
{ yylhsminor.yy448 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy448 = yylhsminor.yy448;
        break;
      case 512: /* select_item ::= common_expression column_alias */
      case 522: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==522);
{ yylhsminor.yy448 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy448), &yymsp[0].minor.yy113); }
  yymsp[-1].minor.yy448 = yylhsminor.yy448;
        break;
      case 513: /* select_item ::= common_expression AS column_alias */
      case 523: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==523);
{ yylhsminor.yy448 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), &yymsp[0].minor.yy113); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 518: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 543: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==543);
      case 562: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==562);
{ yymsp[-2].minor.yy432 = yymsp[0].minor.yy432; }
        break;
      case 525: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy448 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy448), releaseRawExprNode(pCxt, yymsp[-1].minor.yy448)); }
        break;
      case 526: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy448 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy448)); }
        break;
      case 527: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy448 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy448), NULL, yymsp[-1].minor.yy448, yymsp[0].minor.yy448); }
        break;
      case 528: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy448 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy448), releaseRawExprNode(pCxt, yymsp[-3].minor.yy448), yymsp[-1].minor.yy448, yymsp[0].minor.yy448); }
        break;
      case 529: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy448 = createEventWindowNode(pCxt, yymsp[-3].minor.yy448, yymsp[0].minor.yy448); }
        break;
      case 533: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy448 = createFillNode(pCxt, yymsp[-1].minor.yy46, NULL); }
        break;
      case 534: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy448 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy432)); }
        break;
      case 535: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy448 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy432)); }
        break;
      case 536: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy46 = FILL_MODE_NONE; }
        break;
      case 537: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy46 = FILL_MODE_PREV; }
        break;
      case 538: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy46 = FILL_MODE_NULL; }
        break;
      case 539: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy46 = FILL_MODE_NULL_F; }
        break;
      case 540: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy46 = FILL_MODE_LINEAR; }
        break;
      case 541: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy46 = FILL_MODE_NEXT; }
        break;
      case 544: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy432 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy448))); }
  yymsp[0].minor.yy432 = yylhsminor.yy432;
        break;
      case 545: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy432 = addNodeToList(pCxt, yymsp[-2].minor.yy432, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy448))); }
  yymsp[-2].minor.yy432 = yylhsminor.yy432;
        break;
      case 549: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy448 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy448), releaseRawExprNode(pCxt, yymsp[-1].minor.yy448)); }
        break;
      case 552: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy448 = addOrderByClause(pCxt, yymsp[-3].minor.yy448, yymsp[-2].minor.yy432);
                                                                                    yylhsminor.yy448 = addSlimitClause(pCxt, yylhsminor.yy448, yymsp[-1].minor.yy448);
                                                                                    yylhsminor.yy448 = addLimitClause(pCxt, yylhsminor.yy448, yymsp[0].minor.yy448);
                                                                                  }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 555: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy448 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy448, yymsp[0].minor.yy448); }
  yymsp[-3].minor.yy448 = yylhsminor.yy448;
        break;
      case 556: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy448 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy448, yymsp[0].minor.yy448); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 564: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 568: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==568);
{ yymsp[-1].minor.yy448 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 565: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 569: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==569);
{ yymsp[-3].minor.yy448 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 566: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 570: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==570);
{ yymsp[-3].minor.yy448 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 571: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy448 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy448); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 576: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy448 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy448), yymsp[-1].minor.yy666, yymsp[0].minor.yy585); }
  yymsp[-2].minor.yy448 = yylhsminor.yy448;
        break;
      case 577: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy666 = ORDER_ASC; }
        break;
      case 578: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy666 = ORDER_ASC; }
        break;
      case 579: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy666 = ORDER_DESC; }
        break;
      case 580: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy585 = NULL_ORDER_DEFAULT; }
        break;
      case 581: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy585 = NULL_ORDER_FIRST; }
        break;
      case 582: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy585 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
