/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 347
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EJoinType yy84;
  SDataType yy156;
  ENullOrder yy181;
  EOrder yy272;
  EFillMode yy284;
  EOperatorType yy304;
  SAlterOption yy475;
  SToken yy555;
  SNodeList* yy568;
  int32_t yy610;
  bool yy617;
  SNode* yy662;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             569
#define YYNRULE              438
#define YYNTOKEN             231
#define YY_MAX_SHIFT         568
#define YY_MIN_SHIFTREDUCE   848
#define YY_MAX_SHIFTREDUCE   1285
#define YY_ERROR_ACTION      1286
#define YY_ACCEPT_ACTION     1287
#define YY_NO_ACTION         1288
#define YY_MIN_REDUCE        1289
#define YY_MAX_REDUCE        1726
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2054)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1575, 1560, 1705,  470, 1591,  483,  285,   26,  203, 1498,
 /*    10 */   273,  467,   33,   31,  326, 1704, 1556, 1564, 1562, 1702,
 /*    20 */   282,  445, 1102,   22, 1591,  123, 1400, 1560,  486, 1366,
 /*    30 */  1409,  467,  482,   34,   32,   30,   29,   28, 1100,  483,
 /*    40 */  1287,  466, 1556, 1563, 1562, 1546,  104,  438,   98, 1124,
 /*    50 */    12,   33,   31, 1227,  486,  386, 1108, 1575, 1386,  282,
 /*    60 */   482, 1102, 1603,  365, 1409,   75, 1576,  469, 1578, 1579,
 /*    70 */   465, 1546,  486,    1,  351, 1643, 1454, 1100,  294, 1642,
 /*    80 */  1639, 1591,  272, 1126,  102, 1489, 1491, 1452,  467,   12,
 /*    90 */  1128,  885, 1705,  884,  298, 1108,  565,   59,  466,  132,
 /*   100 */  1650, 1651, 1546, 1655,   24, 1703,  439, 1101,  449, 1702,
 /*   110 */  1127,  886,    1,   36,   34,   32,   30,   29,   28, 1603,
 /*   120 */   146,  145,   73, 1576,  469, 1578, 1579,  465, 1290,  486,
 /*   130 */   520,  122, 1643, 1301, 1705,  565,  253, 1639, 1657,   34,
 /*   140 */    32,   30,   29,   28,  518, 1125, 1101,  135, 1705,   88,
 /*   150 */  1103, 1702,   87,   86,   85,   84,   83,   82,   81,   80,
 /*   160 */    79,  135, 1654,  517,  516, 1702,  515,  514,  513,   56,
 /*   170 */   270, 1106, 1107,  173, 1152, 1153, 1154, 1155, 1156, 1157,
 /*   180 */  1158,  462,  484, 1166, 1167, 1168, 1169, 1170, 1171, 1103,
 /*   190 */   974,  509,  508,  507,  978,  506,  980,  981,  505,  983,
 /*   200 */   502,  136,  989,  499,  991,  992,  496,  493,  482,  198,
 /*   210 */  1106, 1107,  264, 1152, 1153, 1154, 1155, 1156, 1157, 1158,
 /*   220 */   462,  484, 1166, 1167, 1168, 1169, 1170, 1171,   33,   31,
 /*   230 */   136,  322,  328, 1575, 1384,  523,  282, 1381, 1102,   88,
 /*   240 */  1251,  136,   87,   86,   85,   84,   83,   82,   81,   80,
 /*   250 */    79, 1312, 1191,  265, 1100,  263,  262, 1591,  388, 1454,
 /*   260 */   435,   36,  251,  390,  464,  287,   12,   33,   31, 1282,
 /*   270 */  1452, 1705, 1108, 1196,  466,  282,  422, 1102, 1546,  432,
 /*   280 */  1249, 1250, 1252, 1253,  135,  321,  389,  320, 1702,    1,
 /*   290 */    30,   29,   28, 1100,  136, 1603, 1546,  136,  248, 1576,
 /*   300 */   469, 1578, 1579,  465,  463,  486,  460, 1615,   23, 1311,
 /*   310 */   390, 1108,  565, 1310, 1575,   34,   32,   30,   29,   28,
 /*   320 */   518,  423,  483, 1101,   33,   31, 1172,  483,    7,  440,
 /*   330 */   436,  327,  282,  389, 1102, 1454,  296,  136, 1591,  517,
 /*   340 */   516,  293,  515,  514,  513,  467, 1452, 1409, 1657, 1281,
 /*   350 */  1100,  565, 1409, 1568, 1546,  466,  129,  512, 1546, 1546,
 /*   360 */  1387, 1705, 1101,   33,   31, 1566, 1103, 1448, 1108,  561,
 /*   370 */   560,  282, 1653, 1102,  135, 1309, 1603, 1241, 1702,  244,
 /*   380 */  1576,  469, 1578, 1579,  465,    7,  486, 1106, 1107, 1100,
 /*   390 */  1152, 1153, 1154, 1155, 1156, 1157, 1158,  462,  484, 1166,
 /*   400 */  1167, 1168, 1169, 1170, 1171, 1103, 1308, 1108,  565,  365,
 /*   410 */    34,   32,   30,   29,   28,  397,  396,  441, 1307, 1101,
 /*   420 */  1546,  522,  535,  533,    7, 1306, 1106, 1107,   54, 1152,
 /*   430 */  1153, 1154, 1155, 1156, 1157, 1158,  462,  484, 1166, 1167,
 /*   440 */  1168, 1169, 1170, 1171,    9,    8,   54,  565,  142, 1405,
 /*   450 */   421, 1546,  400,  399,  568, 1398,  136,  398, 1101,  100,
 /*   460 */   101,  395, 1103, 1546,  394,  393,  392, 1404,  221, 1394,
 /*   470 */  1546,   99, 1139,   52, 1305, 1304,   51,  557, 1486,  553,
 /*   480 */   549,  545,  220, 1106, 1107,  144, 1152, 1153, 1154, 1155,
 /*   490 */  1156, 1157, 1158,  462,  484, 1166, 1167, 1168, 1169, 1170,
 /*   500 */  1171, 1103,   34,   32,   30,   29,   28,   71,  286,   48,
 /*   510 */   215,   34,   32,   30,   29,   28,  120, 1203,  445, 1546,
 /*   520 */  1546, 1226, 1106, 1107, 1411, 1152, 1153, 1154, 1155, 1156,
 /*   530 */  1157, 1158,  462,  484, 1166, 1167, 1168, 1169, 1170, 1171,
 /*   540 */    33,   31,  250,  104, 1124,  479,   63, 1575,  282, 1064,
 /*   550 */  1102,  344, 1088, 1089,  356,  483,  470, 1066,   70,  936,
 /*   560 */   483, 1385, 1499,  357,  336,  483, 1100, 1402,  414,   98,
 /*   570 */   427, 1591,  105,  180,  337, 1303,  391,  938,  467, 1401,
 /*   580 */  1409,  102, 1396,  518, 1108, 1409, 1300, 1299,  466, 1298,
 /*   590 */  1409, 1080, 1546,  175,    6,  447,  131, 1650, 1651, 1657,
 /*   600 */  1655,    1,  517,  516,  445,  515,  514,  513, 1705, 1603,
 /*   610 */   520, 1302,   74, 1576,  469, 1578, 1579,  465, 1065,  486,
 /*   620 */  1546,  135, 1643, 1652,  565, 1702,  275, 1639, 1717,  104,
 /*   630 */   227, 1546, 1546, 1439, 1546, 1101,  355, 1677,  119,  350,
 /*   640 */   349,  348,  347,  346, 1289,  343,  342,  341,  340,  339,
 /*   650 */   335,  334,  333,  332,  331,  330,  329,  120,   34,   32,
 /*   660 */    30,   29,   28, 1490, 1491, 1412, 1454,  102,   97,   96,
 /*   670 */    95,   94,   93,   92,   91,   90,   89, 1453, 1103, 1662,
 /*   680 */  1222,  292,  133, 1650, 1651, 1535, 1655, 1129, 1392,  120,
 /*   690 */   459, 1297, 1234, 1575, 1296, 1295,  254, 1411, 1126, 1106,
 /*   700 */  1107, 1294, 1152, 1153, 1154, 1155, 1156, 1157, 1158,  462,
 /*   710 */   484, 1166, 1167, 1168, 1169, 1170, 1171, 1591,  483, 1225,
 /*   720 */  1139,  305,  313,  451,  448,  445, 1293,  364, 1189,   34,
 /*   730 */    32,   30,   29,   28,  466, 1292, 1546,  295, 1546, 1546,
 /*   740 */  1546, 1177,  315, 1409,  534,  120, 1546, 1126,  316,  200,
 /*   750 */   104, 1222,  121, 1411,  455, 1603, 1367,  233,   74, 1576,
 /*   760 */   469, 1578, 1579,  465,  290,  486,  483,  254, 1643,  231,
 /*   770 */   449, 1546,  275, 1639,  130, 1406,  483, 1111,  884, 1190,
 /*   780 */  1546, 1560,  147,  452,  164, 1527,  199,  162,  102, 1575,
 /*   790 */   176, 1409,  428, 1670,  384,  415, 1556, 1563, 1562, 1189,
 /*   800 */  1195, 1409,  461,  196, 1650,  444,  184,  443,  486,  166,
 /*   810 */  1705, 1181,  165, 1591,  168,  170,  412,  167,  169,  511,
 /*   820 */   448,   43,  252,  135,  483, 1328, 1323, 1702,  110,  410,
 /*   830 */   466, 1341,  424,  480, 1546,   25,  280, 1184, 1185, 1186,
 /*   840 */  1187, 1188, 1192, 1193, 1194,   72, 1114,  401,  403, 1409,
 /*   850 */  1190, 1603,    9,    8,   74, 1576,  469, 1578, 1579,  465,
 /*   860 */  1321,  486,   42,  187, 1643,  483, 1248,  189,  275, 1639,
 /*   870 */   130, 1195, 1284, 1285,  481,   35,   50,   49,  325, 1197,
 /*   880 */  1110,  141,  406,  400,  399,  433,  319,  193,  398, 1671,
 /*   890 */  1409,  101,  395, 1575,  383,  394,  393,  392,  260, 1449,
 /*   900 */   311, 1673,  307,  303,  138,  456,   25,  280, 1184, 1185,
 /*   910 */  1186, 1187, 1188, 1192, 1193, 1194,  483, 1591,   35,   35,
 /*   920 */   446, 1592, 1159, 1059,  467,  217,  206,  108,  202,  109,
 /*   930 */   208,  475,  453,  214,  466,  136,    2, 1124, 1546,  110,
 /*   940 */  1575, 1409,   42,  967,  491,  300,  226,  109,  995, 1113,
 /*   950 */   110,  999,  111,  109, 1006, 1603, 1004,  112,   74, 1576,
 /*   960 */   469, 1578, 1579,  465, 1591,  486,   69,  936, 1643,  909,
 /*   970 */   304,  467,  275, 1639, 1717,  261,   65, 1072,  222,  353,
 /*   980 */   259,  466, 1338, 1700,  338, 1546, 1488,  910,  143,  345,
 /*   990 */   352,  354,  358, 1133,  359,  148,  360, 1132,  361,  151,
 /*  1000 */   362, 1131, 1603,  154,  363,   74, 1576,  469, 1578, 1579,
 /*  1010 */   465,   53,  486,  366,  157, 1643, 1130,  385,  387,  275,
 /*  1020 */  1639, 1717, 1399,  161, 1395,  163,  114,   78, 1575,  115,
 /*  1030 */  1661, 1108, 1397, 1393,  541,  540,  539,  297,  116,  538,
 /*  1040 */   537,  536,  106,  531,  530,  529,  528,  527,  526,  525,
 /*  1050 */   524,  113, 1591,  269,  117, 1531,  416,  174,  420,  467,
 /*  1060 */   223,  177,  224,  179,  425,  426,  417,  182, 1129,  466,
 /*  1070 */   434, 1684,  473, 1546,    5, 1575, 1674,  185, 1683,  449,
 /*  1080 */   431, 1664,  188,  274,  127,  437,  442,  194,  430,    4,
 /*  1090 */  1603, 1222,  103,  240, 1576,  469, 1578, 1579,  465, 1591,
 /*  1100 */   486, 1128,  195, 1701, 1658,   37,  467,  457,  276, 1720,
 /*  1110 */   454,   16, 1624,  192, 1497,  471,  466,  472,  284, 1705,
 /*  1120 */  1546,  477,  476, 1496,  201,   64,  478,  210, 1575,  212,
 /*  1130 */   225, 1410,  135,  564,   62,  219, 1702, 1603,  126, 1575,
 /*  1140 */    75, 1576,  469, 1578, 1579,  465, 1382,  486,  228,  489,
 /*  1150 */  1643,  271, 1591,  234,  458, 1639,  241,   44,  235,  467,
 /*  1160 */   230, 1540,  232, 1591, 1539,  299, 1536,  302,  301,  466,
 /*  1170 */   467, 1096, 1097, 1546,  139,  306, 1534,  308,  310,  309,
 /*  1180 */   466, 1533,  312, 1532, 1546,  314, 1517,  140,  317,  318,
 /*  1190 */  1603, 1075, 1074,  124, 1576,  469, 1578, 1579,  465, 1575,
 /*  1200 */   486, 1603, 1511, 1510,   75, 1576,  469, 1578, 1579,  465,
 /*  1210 */   323,  486,  324, 1509, 1643,  107, 1042, 1575, 1508, 1640,
 /*  1220 */  1481, 1480, 1479, 1591, 1478, 1477, 1476, 1475, 1474, 1473,
 /*  1230 */   467, 1472, 1471, 1470, 1469, 1468, 1467,  450, 1718, 1466,
 /*  1240 */   466, 1591, 1465, 1464, 1546, 1463, 1462,  429,  467, 1461,
 /*  1250 */  1575, 1460, 1459, 1458, 1457, 1456, 1455, 1340,  466, 1044,
 /*  1260 */  1525, 1603, 1546, 1519,  249, 1576,  469, 1578, 1579,  465,
 /*  1270 */  1503,  486, 1494,  153, 1591,   77,  367, 1335,  371, 1603,
 /*  1280 */  1575,  467,  124, 1576,  469, 1578, 1579,  465, 1388,  486,
 /*  1290 */   369,  466,  903, 1339,  405, 1546, 1337,  368,  279, 1333,
 /*  1300 */   372,  373,  376,  375, 1591,  377, 1331,  379, 1320,  413,
 /*  1310 */  1575,  464, 1603, 1319,  380,  249, 1576,  469, 1578, 1579,
 /*  1320 */   465,  466,  486,  172,  381, 1546,  408, 1719, 1316, 1390,
 /*  1330 */   160,  402, 1010, 1009, 1591,  935,  934,  171, 1389,  933,
 /*  1340 */   932,  467, 1603,  532,  534,  248, 1576,  469, 1578, 1579,
 /*  1350 */   465,  466,  486,  929, 1616, 1546,  928,  927,  281, 1329,
 /*  1360 */  1324,  266,   46, 1575,  267,   45,  404, 1322,  268,  407,
 /*  1370 */  1315,  409, 1603, 1314, 1575,  249, 1576,  469, 1578, 1579,
 /*  1380 */   465, 1524,  486,  411,   76, 1082, 1518, 1591,  418, 1502,
 /*  1390 */  1501, 1493,    3,   57,  467,  178,  181,   13, 1591,  118,
 /*  1400 */    35, 1566,   40,  191,  466,  467,   47,  419, 1546,  125,
 /*  1410 */   183,  283,   14,   38,  186,  466,   11, 1247,  190, 1546,
 /*  1420 */  1270,   20,   21, 1269, 1240, 1603,  197,   58,  249, 1576,
 /*  1430 */   469, 1578, 1579,  465, 1575,  486, 1603, 1219,   39,  236,
 /*  1440 */  1576,  469, 1578, 1579,  465, 1218,  486,  134, 1275, 1575,
 /*  1450 */    15,  277, 1274, 1273,  278,    8, 1182,   17, 1591, 1147,
 /*  1460 */   137,  204,  468,  474, 1492,  467, 1161,   27,  211, 1160,
 /*  1470 */    10,   18, 1118, 1591,   19,  466,  205, 1245,  207, 1546,
 /*  1480 */   467,  209,   60,   61, 1606,  213, 1163,   65,  973,  490,
 /*  1490 */   466, 1565,  216,  485, 1546,   41, 1603,  996,  291,  243,
 /*  1500 */  1576,  469, 1578, 1579,  465,  488,  486,  492,  494, 1575,
 /*  1510 */   993, 1603,  495,  497,  245, 1576,  469, 1578, 1579,  465,
 /*  1520 */  1575,  486,  990,  984,  500,  498,  503,  501,  988,  982,
 /*  1530 */   504,  987,  510, 1591,   66,   67,  986, 1005,  985, 1575,
 /*  1540 */   467,   68, 1003, 1002, 1591, 1001,  901,  519,  942,  521,
 /*  1550 */   466,  467,  218,  923, 1546,  922,  921,  920,  919,  918,
 /*  1560 */   917,  466,  916, 1591,  939, 1546,  937,  913,  912, 1575,
 /*  1570 */   467, 1603, 1336,  911,  237, 1576,  469, 1578, 1579,  465,
 /*  1580 */   466,  486, 1603,  543, 1546,  246, 1576,  469, 1578, 1579,
 /*  1590 */   465,  908,  486, 1591,  907,  906,  542,  544, 1334,  546,
 /*  1600 */   467, 1603,  547,  548,  238, 1576,  469, 1578, 1579,  465,
 /*  1610 */   466,  486, 1332,  550, 1546,  551,  552, 1330,  554,  555,
 /*  1620 */   556, 1318, 1575,  558,  559, 1317, 1313,  562,  563,  567,
 /*  1630 */  1104, 1603,  229, 1575,  247, 1576,  469, 1578, 1579,  465,
 /*  1640 */   566,  486, 1288, 1288, 1288, 1288, 1591, 1288, 1288, 1288,
 /*  1650 */  1288, 1288, 1288,  467, 1288, 1288, 1288, 1591, 1288, 1288,
 /*  1660 */  1288, 1288, 1288,  466,  467, 1288, 1288, 1546, 1288, 1288,
 /*  1670 */  1288, 1288, 1288, 1288,  466, 1288, 1288, 1288, 1546, 1288,
 /*  1680 */  1288, 1288, 1288, 1288, 1603, 1288, 1288,  239, 1576,  469,
 /*  1690 */  1578, 1579,  465, 1575,  486, 1603, 1288, 1288, 1587, 1576,
 /*  1700 */   469, 1578, 1579,  465, 1288,  486, 1288, 1288, 1575, 1288,
 /*  1710 */  1288, 1288, 1288, 1288, 1288, 1288, 1288, 1591, 1288, 1288,
 /*  1720 */  1288, 1288, 1288, 1288,  467, 1288, 1288, 1288, 1288, 1288,
 /*  1730 */  1288, 1288, 1591, 1288,  466, 1288, 1288, 1288, 1546,  467,
 /*  1740 */  1288, 1288, 1288, 1288, 1288, 1288, 1288, 1288, 1288,  466,
 /*  1750 */  1288, 1288, 1288, 1546, 1288, 1603, 1288, 1288, 1586, 1576,
 /*  1760 */   469, 1578, 1579,  465, 1288,  486, 1288, 1288, 1575, 1288,
 /*  1770 */  1603, 1288, 1288, 1585, 1576,  469, 1578, 1579,  465, 1575,
 /*  1780 */   486, 1288, 1288, 1288, 1288, 1288, 1288, 1288, 1288, 1288,
 /*  1790 */  1288, 1288, 1591, 1288, 1288, 1288, 1288, 1288, 1575,  467,
 /*  1800 */  1288, 1288, 1288, 1591, 1288, 1288, 1288, 1288, 1288,  466,
 /*  1810 */   467, 1288, 1288, 1546, 1288, 1288, 1288, 1288, 1288, 1288,
 /*  1820 */   466, 1288, 1591, 1288, 1546, 1288, 1288, 1288, 1575,  467,
 /*  1830 */  1603, 1288, 1288,  257, 1576,  469, 1578, 1579,  465,  466,
 /*  1840 */   486, 1603, 1288, 1546,  256, 1576,  469, 1578, 1579,  465,
 /*  1850 */  1288,  486, 1591, 1288, 1288, 1288, 1288, 1288, 1288,  467,
 /*  1860 */  1603, 1288, 1288,  258, 1576,  469, 1578, 1579,  465,  466,
 /*  1870 */   486,  159, 1288, 1546,  128, 1288,  289,  288, 1288, 1288,
 /*  1880 */   382, 1575,  378,  374,  370,  158, 1116, 1288, 1288, 1288,
 /*  1890 */  1603, 1288, 1288,  255, 1576,  469, 1578, 1579,  465, 1288,
 /*  1900 */   486, 1288, 1109, 1102, 1288, 1591, 1288, 1288, 1288, 1288,
 /*  1910 */    55, 1288,  467,  156, 1288, 1288, 1288, 1288, 1288, 1100,
 /*  1920 */  1108, 1288,  466, 1288, 1288, 1288, 1546, 1288, 1288, 1288,
 /*  1930 */  1288, 1288, 1288, 1288, 1288, 1288, 1288, 1108, 1288, 1288,
 /*  1940 */  1288, 1288, 1288, 1603, 1288, 1288,  242, 1576,  469, 1578,
 /*  1950 */  1579,  465, 1288,  486, 1288, 1288, 1288, 1288, 1288, 1288,
 /*  1960 */   487, 1288, 1288, 1288, 1288, 1288, 1288, 1288, 1288, 1288,
 /*  1970 */  1288, 1112,  155, 1288,  150, 1288,  152,  565, 1288, 1288,
 /*  1980 */  1288, 1288, 1288, 1288, 1288, 1288, 1288, 1288, 1101, 1288,
 /*  1990 */  1288, 1288, 1288, 1288, 1288, 1288,  149, 1288, 1288, 1288,
 /*  2000 */  1288, 1288, 1288, 1288, 1288, 1288, 1288, 1288, 1288, 1288,
 /*  2010 */  1288, 1288, 1288, 1288, 1117, 1288, 1288, 1288, 1288, 1288,
 /*  2020 */  1288, 1288, 1288, 1288, 1288, 1288, 1288, 1288, 1288, 1288,
 /*  2030 */  1288, 1103, 1288, 1288, 1288, 1120, 1288, 1288, 1288, 1288,
 /*  2040 */  1288, 1288, 1288, 1288, 1288, 1288,  484, 1166, 1167, 1288,
 /*  2050 */  1288, 1288, 1106, 1107,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   234,  279,  325,  275,  258,  240,  278,  310,  311,  281,
 /*    10 */   262,  265,   12,   13,  249,  338,  294,  295,  296,  342,
 /*    20 */    20,  240,   22,    2,  258,  243,  234,  279,  306,  247,
 /*    30 */   265,  265,   20,   12,   13,   14,   15,   16,   38,  240,
 /*    40 */   231,  275,  294,  295,  296,  279,  265,  301,  249,   20,
 /*    50 */    50,   12,   13,   14,  306,  256,   56,  234,    0,   20,
 /*    60 */    20,   22,  296,   49,  265,  299,  300,  301,  302,  303,
 /*    70 */   304,  279,  306,   73,   67,  309,  258,   38,  267,  313,
 /*    80 */   314,  258,  264,   20,  303,  274,  275,  269,  265,   50,
 /*    90 */    20,   20,  325,   22,  285,   56,   96,    4,  275,  318,
 /*   100 */   319,  320,  279,  322,    2,  338,   20,  107,  285,  342,
 /*   110 */    20,   40,   73,   73,   12,   13,   14,   15,   16,  296,
 /*   120 */   113,  114,  299,  300,  301,  302,  303,  304,    0,  306,
 /*   130 */    49,  233,  309,  235,  325,   96,  313,  314,  297,   12,
 /*   140 */    13,   14,   15,   16,   86,   20,  107,  338,  325,   21,
 /*   150 */   150,  342,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   160 */    32,  338,  321,  105,  106,  342,  108,  109,  110,  159,
 /*   170 */   160,  171,  172,  163,  174,  175,  176,  177,  178,  179,
 /*   180 */   180,  181,  182,  183,  184,  185,  186,  187,  188,  150,
 /*   190 */    87,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   200 */    97,  201,   99,  100,  101,  102,  103,  104,   20,  139,
 /*   210 */   171,  172,   35,  174,  175,  176,  177,  178,  179,  180,
 /*   220 */   181,  182,  183,  184,  185,  186,  187,  188,   12,   13,
 /*   230 */   201,  285,  240,  234,    0,  246,   20,  248,   22,   21,
 /*   240 */   171,  201,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   250 */    32,  234,  133,   76,   38,   78,   79,  258,   81,  258,
 /*   260 */   137,   73,  270,   86,  265,  264,   50,   12,   13,  142,
 /*   270 */   269,  325,   56,  154,  275,   20,  240,   22,  279,  210,
 /*   280 */   211,  212,  213,  214,  338,  149,  109,  151,  342,   73,
 /*   290 */    14,   15,   16,   38,  201,  296,  279,  201,  299,  300,
 /*   300 */   301,  302,  303,  304,  305,  306,  307,  308,  189,  234,
 /*   310 */    86,   56,   96,  234,  234,   12,   13,   14,   15,   16,
 /*   320 */    86,  285,  240,  107,   12,   13,   14,  240,   73,  206,
 /*   330 */   207,  249,   20,  109,   22,  258,  249,  201,  258,  105,
 /*   340 */   106,  264,  108,  109,  110,  265,  269,  265,  297,  222,
 /*   350 */    38,   96,  265,   73,  279,  275,  257,   84,  279,  279,
 /*   360 */     0,  325,  107,   12,   13,   85,  150,  268,   56,  237,
 /*   370 */   238,   20,  321,   22,  338,  234,  296,   74,  342,  299,
 /*   380 */   300,  301,  302,  303,  304,   73,  306,  171,  172,   38,
 /*   390 */   174,  175,  176,  177,  178,  179,  180,  181,  182,  183,
 /*   400 */   184,  185,  186,  187,  188,  150,  234,   56,   96,   49,
 /*   410 */    12,   13,   14,   15,   16,  244,  245,  337,  234,  107,
 /*   420 */   279,   56,  244,  245,   73,  234,  171,  172,  242,  174,
 /*   430 */   175,  176,  177,  178,  179,  180,  181,  182,  183,  184,
 /*   440 */   185,  186,  187,  188,    1,    2,  242,   96,   47,  263,
 /*   450 */   288,  279,   52,   53,   19,  259,  201,   57,  107,  255,
 /*   460 */    60,   61,  150,  279,   64,   65,   66,  263,   33,  259,
 /*   470 */   279,   36,   74,   72,  234,  234,   75,   42,  265,   44,
 /*   480 */    45,   46,   47,  171,  172,  272,  174,  175,  176,  177,
 /*   490 */   178,  179,  180,  181,  182,  183,  184,  185,  186,  187,
 /*   500 */   188,  150,   12,   13,   14,   15,   16,   72,  250,    3,
 /*   510 */    75,   12,   13,   14,   15,   16,  258,   74,  240,  279,
 /*   520 */   279,    4,  171,  172,  266,  174,  175,  176,  177,  178,
 /*   530 */   179,  180,  181,  182,  183,  184,  185,  186,  187,  188,
 /*   540 */    12,   13,   18,  265,   20,  110,  239,  234,   20,   72,
 /*   550 */    22,   27,  161,  162,   30,  240,  275,   80,  239,   38,
 /*   560 */   240,    0,  281,   39,  249,  240,   38,  260,  285,  249,
 /*   570 */   135,  258,  253,  138,  249,  234,  256,   56,  265,  260,
 /*   580 */   265,  303,  259,   86,   56,  265,  234,  234,  275,  234,
 /*   590 */   265,  156,  279,  158,   43,  317,  318,  319,  320,  297,
 /*   600 */   322,   73,  105,  106,  240,  108,  109,  110,  325,  296,
 /*   610 */    49,  235,  299,  300,  301,  302,  303,  304,  141,  306,
 /*   620 */   279,  338,  309,  321,   96,  342,  313,  314,  315,  265,
 /*   630 */   251,  279,  279,  254,  279,  107,  112,  324,  139,  115,
 /*   640 */   116,  117,  118,  119,    0,  121,  122,  123,  124,  125,
 /*   650 */   126,  127,  128,  129,  130,  131,  132,  258,   12,   13,
 /*   660 */    14,   15,   16,  274,  275,  266,  258,  303,   24,   25,
 /*   670 */    26,   27,   28,   29,   30,   31,   32,  269,  150,  199,
 /*   680 */   200,  250,  318,  319,  320,    0,  322,   20,  259,  258,
 /*   690 */    50,  234,   14,  234,  234,  234,   50,  266,   20,  171,
 /*   700 */   172,  234,  174,  175,  176,  177,  178,  179,  180,  181,
 /*   710 */   182,  183,  184,  185,  186,  187,  188,  258,  240,  202,
 /*   720 */    74,   36,  145,  217,  265,  240,  234,  249,   82,   12,
 /*   730 */    13,   14,   15,   16,  275,  234,  279,  250,  279,  279,
 /*   740 */   279,   14,  165,  265,   70,  258,  279,   20,   74,  345,
 /*   750 */   265,  200,   18,  266,   70,  296,  247,   23,  299,  300,
 /*   760 */   301,  302,  303,  304,  262,  306,  240,   50,  309,   35,
 /*   770 */   285,  279,  313,  314,  315,  249,  240,   38,   22,  133,
 /*   780 */   279,  279,   48,   70,   77,  249,  327,   80,  303,  234,
 /*   790 */   259,  265,  333,  334,   38,  292,  294,  295,  296,   82,
 /*   800 */   154,  265,  259,  318,  319,  320,  139,  322,  306,   77,
 /*   810 */   325,  171,   80,  258,   77,   77,   21,   80,   80,  259,
 /*   820 */   265,  139,  140,  338,  240,    0,    0,  342,   70,   34,
 /*   830 */   275,    0,   74,  249,  279,  189,  190,  191,  192,  193,
 /*   840 */   194,  195,  196,  197,  198,  111,  107,   22,   22,  265,
 /*   850 */   133,  296,    1,    2,  299,  300,  301,  302,  303,  304,
 /*   860 */     0,  306,   70,   70,  309,  240,   74,   74,  313,  314,
 /*   870 */   315,  154,  186,  187,  249,   70,  142,  143,  144,   74,
 /*   880 */    38,  147,   22,   52,   53,  336,  152,  330,   57,  334,
 /*   890 */   265,   60,   61,  234,  237,   64,   65,   66,  164,  268,
 /*   900 */   166,  298,  168,  169,  170,  221,  189,  190,  191,  192,
 /*   910 */   193,  194,  195,  196,  197,  198,  240,  258,   70,   70,
 /*   920 */   323,  258,   74,   74,  265,  249,   70,   70,  339,   70,
 /*   930 */    74,   74,  219,   74,  275,  201,  326,   20,  279,   70,
 /*   940 */   234,  265,   70,   74,   70,  240,   74,   70,   74,  107,
 /*   950 */    70,   74,   70,   70,   74,  296,   74,   74,  299,  300,
 /*   960 */   301,  302,  303,  304,  258,  306,   73,   38,  309,   38,
 /*   970 */    36,  265,  313,  314,  315,  244,   83,  148,  286,  133,
 /*   980 */   293,  275,    0,  324,  240,  279,  240,   56,  120,  273,
 /*   990 */   271,  271,  240,   20,  290,  242,  275,   20,  283,  242,
 /*  1000 */   265,   20,  296,  242,  276,  299,  300,  301,  302,  303,
 /*  1010 */   304,  242,  306,  240,  242,  309,   20,  236,  258,  313,
 /*  1020 */   314,  315,  258,  258,  258,  258,  258,  240,  234,  258,
 /*  1030 */   324,   56,  258,  258,   52,   53,   54,   55,  258,   57,
 /*  1040 */    58,   59,   60,   61,   62,   63,   64,   65,   66,   67,
 /*  1050 */    68,   69,  258,  236,  258,  279,  157,  239,  275,  265,
 /*  1060 */   290,  239,  283,  239,  265,  276,  289,  239,   20,  275,
 /*  1070 */   209,  335,  208,  279,  216,  234,  298,  280,  335,  285,
 /*  1080 */   279,  332,  280,  279,  329,  279,  215,  328,  204,  203,
 /*  1090 */   296,  200,  265,  299,  300,  301,  302,  303,  304,  258,
 /*  1100 */   306,   20,  316,  341,  297,  120,  265,  220,  223,  346,
 /*  1110 */   218,   73,  312,  331,  280,  279,  275,  279,  279,  325,
 /*  1120 */   279,  277,  136,  280,  340,   73,  276,  265,  234,  239,
 /*  1130 */   254,  265,  338,  236,  239,  239,  342,  296,  291,  234,
 /*  1140 */   299,  300,  301,  302,  303,  304,  248,  306,  240,  261,
 /*  1150 */   309,  284,  258,  252,  313,  314,  252,  287,  252,  265,
 /*  1160 */   241,    0,  232,  258,    0,   64,    0,  167,   38,  275,
 /*  1170 */   265,   38,   38,  279,   38,  167,    0,   38,  167,   38,
 /*  1180 */   275,    0,   38,    0,  279,   38,    0,   73,  154,  153,
 /*  1190 */   296,  107,  150,  299,  300,  301,  302,  303,  304,  234,
 /*  1200 */   306,  296,    0,    0,  299,  300,  301,  302,  303,  304,
 /*  1210 */   146,  306,  145,    0,  309,  120,   85,  234,    0,  314,
 /*  1220 */     0,    0,    0,  258,    0,    0,    0,    0,    0,    0,
 /*  1230 */   265,    0,    0,    0,    0,    0,    0,  343,  344,    0,
 /*  1240 */   275,  258,    0,    0,  279,    0,    0,  282,  265,    0,
 /*  1250 */   234,    0,    0,    0,    0,    0,    0,    0,  275,   22,
 /*  1260 */     0,  296,  279,    0,  299,  300,  301,  302,  303,  304,
 /*  1270 */     0,  306,    0,   43,  258,   82,   38,    0,   38,  296,
 /*  1280 */   234,  265,  299,  300,  301,  302,  303,  304,    0,  306,
 /*  1290 */    43,  275,   51,    0,    4,  279,    0,   36,  282,    0,
 /*  1300 */    36,   43,   36,   38,  258,   43,    0,   38,    0,   19,
 /*  1310 */   234,  265,  296,    0,   36,  299,  300,  301,  302,  303,
 /*  1320 */   304,  275,  306,   33,   43,  279,   36,  344,    0,    0,
 /*  1330 */    80,   41,   38,   22,  258,   38,   38,   47,    0,   38,
 /*  1340 */    38,  265,  296,   70,   70,  299,  300,  301,  302,  303,
 /*  1350 */   304,  275,  306,   38,  308,  279,   38,   38,  282,    0,
 /*  1360 */     0,   22,   72,  234,   22,   75,   39,    0,   22,   38,
 /*  1370 */     0,   22,  296,    0,  234,  299,  300,  301,  302,  303,
 /*  1380 */   304,    0,  306,   22,   20,   38,    0,  258,   22,    0,
 /*  1390 */     0,    0,   70,   73,  265,  136,   43,  205,  258,  155,
 /*  1400 */    70,   85,   70,   70,  275,  265,  139,  139,  279,   73,
 /*  1410 */   134,  282,  205,  199,   74,  275,  205,   74,   73,  279,
 /*  1420 */    38,   73,   70,   38,   74,  296,   85,   73,  299,  300,
 /*  1430 */   301,  302,  303,  304,  234,  306,  296,   74,   70,  299,
 /*  1440 */   300,  301,  302,  303,  304,   74,  306,   85,   74,  234,
 /*  1450 */    70,   38,   38,   38,   38,    2,  171,   70,  258,   22,
 /*  1460 */    85,   85,  173,  137,    0,  265,   74,   73,   43,   74,
 /*  1470 */    73,   73,   22,  258,   73,  275,   74,   74,   73,  279,
 /*  1480 */   265,   73,   73,   73,   73,  134,   74,   83,   22,   38,
 /*  1490 */   275,   85,   85,   73,  279,   73,  296,   74,   38,  299,
 /*  1500 */   300,  301,  302,  303,  304,   84,  306,   73,   38,  234,
 /*  1510 */    74,  296,   73,   38,  299,  300,  301,  302,  303,  304,
 /*  1520 */   234,  306,   74,   74,   38,   73,   38,   73,   98,   74,
 /*  1530 */    73,   98,   86,  258,   73,   73,   98,   38,   98,  234,
 /*  1540 */   265,   73,  107,   38,  258,   22,   51,   50,   56,   71,
 /*  1550 */   275,  265,   70,   38,  279,   38,   38,   38,   38,   22,
 /*  1560 */    38,  275,   38,  258,   56,  279,   38,   38,   38,  234,
 /*  1570 */   265,  296,    0,   38,  299,  300,  301,  302,  303,  304,
 /*  1580 */   275,  306,  296,   36,  279,  299,  300,  301,  302,  303,
 /*  1590 */   304,   38,  306,  258,   38,   38,   38,   43,    0,   38,
 /*  1600 */   265,  296,   36,   43,  299,  300,  301,  302,  303,  304,
 /*  1610 */   275,  306,    0,   38,  279,   36,   43,    0,   38,   36,
 /*  1620 */    43,    0,  234,   38,   37,    0,    0,   22,   21,   20,
 /*  1630 */    22,  296,   22,  234,  299,  300,  301,  302,  303,  304,
 /*  1640 */    21,  306,  347,  347,  347,  347,  258,  347,  347,  347,
 /*  1650 */   347,  347,  347,  265,  347,  347,  347,  258,  347,  347,
 /*  1660 */   347,  347,  347,  275,  265,  347,  347,  279,  347,  347,
 /*  1670 */   347,  347,  347,  347,  275,  347,  347,  347,  279,  347,
 /*  1680 */   347,  347,  347,  347,  296,  347,  347,  299,  300,  301,
 /*  1690 */   302,  303,  304,  234,  306,  296,  347,  347,  299,  300,
 /*  1700 */   301,  302,  303,  304,  347,  306,  347,  347,  234,  347,
 /*  1710 */   347,  347,  347,  347,  347,  347,  347,  258,  347,  347,
 /*  1720 */   347,  347,  347,  347,  265,  347,  347,  347,  347,  347,
 /*  1730 */   347,  347,  258,  347,  275,  347,  347,  347,  279,  265,
 /*  1740 */   347,  347,  347,  347,  347,  347,  347,  347,  347,  275,
 /*  1750 */   347,  347,  347,  279,  347,  296,  347,  347,  299,  300,
 /*  1760 */   301,  302,  303,  304,  347,  306,  347,  347,  234,  347,
 /*  1770 */   296,  347,  347,  299,  300,  301,  302,  303,  304,  234,
 /*  1780 */   306,  347,  347,  347,  347,  347,  347,  347,  347,  347,
 /*  1790 */   347,  347,  258,  347,  347,  347,  347,  347,  234,  265,
 /*  1800 */   347,  347,  347,  258,  347,  347,  347,  347,  347,  275,
 /*  1810 */   265,  347,  347,  279,  347,  347,  347,  347,  347,  347,
 /*  1820 */   275,  347,  258,  347,  279,  347,  347,  347,  234,  265,
 /*  1830 */   296,  347,  347,  299,  300,  301,  302,  303,  304,  275,
 /*  1840 */   306,  296,  347,  279,  299,  300,  301,  302,  303,  304,
 /*  1850 */   347,  306,  258,  347,  347,  347,  347,  347,  347,  265,
 /*  1860 */   296,  347,  347,  299,  300,  301,  302,  303,  304,  275,
 /*  1870 */   306,   33,  347,  279,   36,  347,   12,   13,  347,  347,
 /*  1880 */    42,  234,   44,   45,   46,   47,   22,  347,  347,  347,
 /*  1890 */   296,  347,  347,  299,  300,  301,  302,  303,  304,  347,
 /*  1900 */   306,  347,   38,   22,  347,  258,  347,  347,  347,  347,
 /*  1910 */    72,  347,  265,   75,  347,  347,  347,  347,  347,   38,
 /*  1920 */    56,  347,  275,  347,  347,  347,  279,  347,  347,  347,
 /*  1930 */   347,  347,  347,  347,  347,  347,  347,   56,  347,  347,
 /*  1940 */   347,  347,  347,  296,  347,  347,  299,  300,  301,  302,
 /*  1950 */   303,  304,  347,  306,  347,  347,  347,  347,  347,  347,
 /*  1960 */    96,  347,  347,  347,  347,  347,  347,  347,  347,  347,
 /*  1970 */   347,  107,  134,  347,  136,  347,  138,   96,  347,  347,
 /*  1980 */   347,  347,  347,  347,  347,  347,  347,  347,  107,  347,
 /*  1990 */   347,  347,  347,  347,  347,  347,  158,  347,  347,  347,
 /*  2000 */   347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
 /*  2010 */   347,  347,  347,  347,  150,  347,  347,  347,  347,  347,
 /*  2020 */   347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
 /*  2030 */   347,  150,  347,  347,  347,  171,  347,  347,  347,  347,
 /*  2040 */   347,  347,  347,  347,  347,  347,  182,  183,  184,  347,
 /*  2050 */   347,  347,  171,  172,  347,  347,  347,  347,  347,  347,
 /*  2060 */   347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
 /*  2070 */   347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
 /*  2080 */   347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
 /*  2090 */   347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
 /*  2100 */   347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
 /*  2110 */   347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
 /*  2120 */   347,  347,  347,  347,  347,  347,  347,  347,  347,  347,
 /*  2130 */   347,  347,  347,  347,  347,
};
#define YY_SHIFT_COUNT    (568)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1881)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   734,    0,   39,  216,  216,  216,  216,  255,  216,  216,
 /*    10 */   312,  351,  528,  351,  351,  351,  351,  351,  351,  351,
 /*    20 */   351,  351,  351,  351,  351,  351,  351,  351,  351,  351,
 /*    30 */   351,  351,  351,  351,  351,  351,   40,  188,  188,  188,
 /*    40 */  1864, 1864, 1864,   29,  136,   12,   12,   96,   93,   12,
 /*    50 */    12,   12,   12,   12,   12,   14,   12,   63,   86,   96,
 /*    60 */    90,   63,   12,   12,   63,   12,   63,   63,   90,   63,
 /*    70 */    12,   81,  524,  646,  717,  717,  218, 1881,  400, 1881,
 /*    80 */  1881, 1881, 1881, 1881, 1881, 1881, 1881, 1881, 1881, 1881,
 /*    90 */  1881, 1881, 1881, 1881, 1881, 1881, 1881, 1881,  177,   71,
 /*   100 */   360,  521,   70,   70,   70,  561,  521,  125,   90,   63,
 /*   110 */    63,   90,  273,  365,  103,  103,  103,  103,  103,  103,
 /*   120 */   103,  435,  128,  831,  127,   69,   10,  123,  756,  224,
 /*   130 */   667,  480,  551,  480,  678,  506,  517,  727,  917,  934,
 /*   140 */   929,  829,  917,  917,  868,  846,  846,  917,  973,   14,
 /*   150 */    90,  977,   14,  125,  981,   14,   14,  917,   14,  996,
 /*   160 */    63,   63,   63,   63,   63,   63,   63,   63,   63,   63,
 /*   170 */    63,  917,  996,  975,  973,   81,  899,   90,   81,  977,
 /*   180 */    81,  125,  981,   81, 1048,  861,  864,  975,  861,  864,
 /*   190 */   975,  975,  858,  871,  884,  886,  891,  125, 1081,  985,
 /*   200 */   885,  887,  892, 1038,   63,  864,  975,  975,  864,  975,
 /*   210 */   986,  125,  981,   81,  273,   81,  125, 1052,  365,  917,
 /*   220 */    81,  996, 2054, 2054, 2054, 2054, 2054, 2054, 2054, 2054,
 /*   230 */   982, 1838,  644, 1290,   58,  234,  303,   21,  102,  499,
 /*   240 */   398,  497,  490,  490,  490,  490,  490,  490,  490,  490,
 /*   250 */   401,    7,  477,  443,  119,  276,  276,  276,  276,  685,
 /*   260 */   577,  674,  707,  732,  737,  738,  825,  826,  860,  795,
 /*   270 */   391,  682,  758,  792,  793,  851,  686,  713,  684,  805,
 /*   280 */   640,  848,  280,  849,  856,  857,  859,  869,  739,  842,
 /*   290 */   872,  874,  877,  880,  882,  883,  893,  931, 1161, 1164,
 /*   300 */  1101, 1166, 1130, 1000, 1133, 1134, 1136, 1008, 1176, 1139,
 /*   310 */  1141, 1011, 1181, 1144, 1183, 1147, 1186, 1114, 1034, 1036,
 /*   320 */  1084, 1042, 1202, 1203, 1064, 1067, 1213, 1218, 1131, 1220,
 /*   330 */  1221, 1222, 1224, 1225, 1226, 1227, 1228, 1229, 1231, 1232,
 /*   340 */  1233, 1234, 1235, 1236, 1239, 1242, 1095, 1243, 1245, 1246,
 /*   350 */  1249, 1251, 1252, 1237, 1253, 1254, 1255, 1256, 1257, 1260,
 /*   360 */  1263, 1270, 1272, 1230, 1288, 1241, 1293, 1296, 1238, 1261,
 /*   370 */  1247, 1277, 1240, 1264, 1258, 1299, 1265, 1266, 1262, 1306,
 /*   380 */  1269, 1278, 1281, 1308, 1313, 1328, 1329, 1193, 1250, 1294,
 /*   390 */  1311, 1338, 1297, 1298, 1301, 1302, 1273, 1274, 1315, 1318,
 /*   400 */  1319, 1359, 1339, 1360, 1342, 1327, 1367, 1346, 1331, 1370,
 /*   410 */  1349, 1373, 1361, 1364, 1381, 1267, 1347, 1386, 1244, 1366,
 /*   420 */  1268, 1259, 1389, 1390, 1391, 1320, 1353, 1276, 1322, 1330,
 /*   430 */  1192, 1340, 1332, 1343, 1336, 1345, 1348, 1350, 1333, 1316,
 /*   440 */  1354, 1352, 1207, 1363, 1371, 1341, 1214, 1368, 1362, 1374,
 /*   450 */  1380, 1211, 1382, 1385, 1413, 1414, 1415, 1416, 1453, 1285,
 /*   460 */  1387, 1392, 1394, 1395, 1375, 1397, 1398, 1376, 1437, 1289,
 /*   470 */  1401, 1402, 1403, 1405, 1408, 1326, 1409, 1464, 1425, 1351,
 /*   480 */  1410, 1404, 1406, 1407, 1411, 1412, 1420, 1450, 1422, 1421,
 /*   490 */  1423, 1451, 1460, 1434, 1436, 1470, 1439, 1448, 1475, 1452,
 /*   500 */  1449, 1486, 1454, 1455, 1488, 1457, 1430, 1433, 1438, 1440,
 /*   510 */  1466, 1446, 1461, 1462, 1499, 1468, 1435, 1505, 1523, 1495,
 /*   520 */  1497, 1492, 1478, 1482, 1515, 1517, 1518, 1519, 1520, 1537,
 /*   530 */  1522, 1524, 1508, 1273, 1528, 1274, 1529, 1530, 1535, 1553,
 /*   540 */  1556, 1557, 1572, 1558, 1547, 1554, 1598, 1561, 1566, 1560,
 /*   550 */  1612, 1575, 1579, 1573, 1617, 1580, 1583, 1577, 1621, 1585,
 /*   560 */  1587, 1625, 1626, 1605, 1607, 1608, 1610, 1619, 1609,
};
#define YY_REDUCE_COUNT (229)
#define YY_REDUCE_MIN   (-323)
#define YY_REDUCE_MAX   (1647)
static const short yy_reduce_ofst[] = {
 /*     0 */  -191, -177,  459,  555,  313,  659,  706,  794, -234,  841,
 /*    10 */    -1,  894,  905,  965,   80,  983, 1016, 1046, 1076, 1129,
 /*    20 */  1140, 1200, 1215, 1275, 1286, 1305, 1335, 1388, 1399, 1459,
 /*    30 */  1474, 1534, 1545, 1564, 1594, 1647,  485,  278, -219,  364,
 /*    40 */  -252,  502, -278,   36,  -54, -201,  320,  283, -323, -235,
 /*    50 */    82,  315,  325,  478,  526,  204,  536, -182, -254, -233,
 /*    60 */  -272,  258,  584,  625,    1,  676,  431,   77, -189,  487,
 /*    70 */    87,  319,   -8, -303, -303, -303, -102, -208, -218,   17,
 /*    80 */    75,   79,  141,  172,  184,  191,  240,  241,  341,  352,
 /*    90 */   353,  355,  457,  460,  461,  467,  492,  501,   99,  132,
 /*   100 */   186,  171, -159,   51,  302,  307,  178,  213,  281,  399,
 /*   110 */   408,  389,  379,  -11,  196,  210,  323,  429,  531,  543,
 /*   120 */   560,  162,  376,  509,  404,  549,  503,  557,  657,  631,
 /*   130 */   603,  597,  597,  597,  663,  589,  610,  663,  705,  687,
 /*   140 */   731,  692,  744,  746,  716,  719,  720,  752,  704,  753,
 /*   150 */   721,  715,  757,  735,  728,  761,  769,  773,  772,  781,
 /*   160 */   760,  764,  765,  766,  767,  768,  771,  774,  775,  780,
 /*   170 */   796,  787,  817,  776,  770,  818,  777,  783,  822,  779,
 /*   180 */   824,  799,  789,  828,  778,  736,  797,  801,  743,  802,
 /*   190 */   804,  806,  749,  782,  755,  759,  597,  827,  807,  786,
 /*   200 */   763,  762,  784,  800,  663,  834,  836,  838,  843,  839,
 /*   210 */   844,  862,  850,  890,  876,  895,  866,  888,  898,  908,
 /*   220 */   896,  897,  870,  847,  867,  901,  904,  906,  919,  930,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*    10 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*    20 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*    30 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*    40 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*    50 */  1286, 1286, 1286, 1286, 1286, 1345, 1286, 1286, 1286, 1286,
 /*    60 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*    70 */  1286, 1343, 1482, 1286, 1645, 1286, 1286, 1286, 1286, 1286,
 /*    80 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*    90 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   100 */  1345, 1286, 1656, 1656, 1656, 1343, 1286, 1286, 1286, 1286,
 /*   110 */  1286, 1286, 1438, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   120 */  1286, 1520, 1286, 1286, 1721, 1286, 1526, 1680, 1286, 1391,
 /*   130 */  1672, 1648, 1662, 1649, 1286, 1706, 1665, 1286, 1286, 1286,
 /*   140 */  1286, 1512, 1286, 1286, 1487, 1484, 1484, 1286, 1286, 1345,
 /*   150 */  1286, 1286, 1345, 1286, 1286, 1345, 1345, 1286, 1345, 1286,
 /*   160 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   170 */  1286, 1286, 1286, 1286, 1286, 1343, 1522, 1286, 1343, 1286,
 /*   180 */  1343, 1286, 1286, 1343, 1286, 1687, 1685, 1286, 1687, 1685,
 /*   190 */  1286, 1286, 1699, 1695, 1678, 1676, 1662, 1286, 1286, 1286,
 /*   200 */  1724, 1712, 1708, 1286, 1286, 1685, 1286, 1286, 1685, 1286,
 /*   210 */  1495, 1286, 1286, 1343, 1286, 1343, 1286, 1407, 1286, 1286,
 /*   220 */  1343, 1286, 1514, 1528, 1504, 1441, 1441, 1441, 1346, 1291,
 /*   230 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   240 */  1286, 1403, 1590, 1698, 1697, 1621, 1620, 1619, 1617, 1589,
 /*   250 */  1286, 1286, 1286, 1286, 1286, 1583, 1584, 1582, 1581, 1286,
 /*   260 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   270 */  1286, 1286, 1286, 1286, 1286, 1646, 1286, 1709, 1713, 1286,
 /*   280 */  1286, 1286, 1567, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   290 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   300 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   310 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   320 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   330 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   340 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   350 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   360 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   370 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   380 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   390 */  1286, 1286, 1286, 1286, 1286, 1286, 1372, 1371, 1286, 1286,
 /*   400 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   410 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   420 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1669, 1679,
 /*   430 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1567,
 /*   440 */  1286, 1696, 1286, 1655, 1651, 1286, 1286, 1647, 1286, 1286,
 /*   450 */  1707, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1641, 1286,
 /*   460 */  1614, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1577,
 /*   470 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   480 */  1286, 1286, 1566, 1286, 1605, 1286, 1286, 1286, 1286, 1286,
 /*   490 */  1286, 1286, 1286, 1435, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   500 */  1286, 1286, 1286, 1286, 1286, 1286, 1420, 1418, 1417, 1416,
 /*   510 */  1286, 1413, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   520 */  1286, 1286, 1286, 1365, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   530 */  1286, 1286, 1286, 1356, 1286, 1355, 1286, 1286, 1286, 1286,
 /*   540 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   550 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
 /*   560 */  1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286, 1286,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*  PRIVILEGE => nothing */
    0,  /*       DROP => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*         ON => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*       DAYS => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*      DELAY => nothing */
    0,  /* FILE_FACTOR => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*       FROM => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FULLTEXT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*     SCHEMA => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /*      MERGE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /*      COUNT => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*      GROUP => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  224,  /*  NK_BITNOT => ID */
  224,  /*     INSERT => ID */
  224,  /*     VALUES => ID */
  224,  /*     IMPORT => ID */
  224,  /*    NK_SEMI => ID */
  224,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "DNODE",
  /*   37 */ "PORT",
  /*   38 */ "NK_INTEGER",
  /*   39 */ "DNODES",
  /*   40 */ "NK_IPTOKEN",
  /*   41 */ "LOCAL",
  /*   42 */ "QNODE",
  /*   43 */ "ON",
  /*   44 */ "BNODE",
  /*   45 */ "SNODE",
  /*   46 */ "MNODE",
  /*   47 */ "DATABASE",
  /*   48 */ "USE",
  /*   49 */ "IF",
  /*   50 */ "NOT",
  /*   51 */ "EXISTS",
  /*   52 */ "BUFFER",
  /*   53 */ "CACHELAST",
  /*   54 */ "COMP",
  /*   55 */ "DAYS",
  /*   56 */ "NK_VARIABLE",
  /*   57 */ "FSYNC",
  /*   58 */ "MAXROWS",
  /*   59 */ "MINROWS",
  /*   60 */ "KEEP",
  /*   61 */ "PAGES",
  /*   62 */ "PAGESIZE",
  /*   63 */ "PRECISION",
  /*   64 */ "REPLICA",
  /*   65 */ "STRICT",
  /*   66 */ "WAL",
  /*   67 */ "VGROUPS",
  /*   68 */ "SINGLE_STABLE",
  /*   69 */ "RETENTIONS",
  /*   70 */ "NK_COMMA",
  /*   71 */ "NK_COLON",
  /*   72 */ "TABLE",
  /*   73 */ "NK_LP",
  /*   74 */ "NK_RP",
  /*   75 */ "STABLE",
  /*   76 */ "ADD",
  /*   77 */ "COLUMN",
  /*   78 */ "MODIFY",
  /*   79 */ "RENAME",
  /*   80 */ "TAG",
  /*   81 */ "SET",
  /*   82 */ "NK_EQ",
  /*   83 */ "USING",
  /*   84 */ "TAGS",
  /*   85 */ "NK_DOT",
  /*   86 */ "COMMENT",
  /*   87 */ "BOOL",
  /*   88 */ "TINYINT",
  /*   89 */ "SMALLINT",
  /*   90 */ "INT",
  /*   91 */ "INTEGER",
  /*   92 */ "BIGINT",
  /*   93 */ "FLOAT",
  /*   94 */ "DOUBLE",
  /*   95 */ "BINARY",
  /*   96 */ "TIMESTAMP",
  /*   97 */ "NCHAR",
  /*   98 */ "UNSIGNED",
  /*   99 */ "JSON",
  /*  100 */ "VARCHAR",
  /*  101 */ "MEDIUMBLOB",
  /*  102 */ "BLOB",
  /*  103 */ "VARBINARY",
  /*  104 */ "DECIMAL",
  /*  105 */ "DELAY",
  /*  106 */ "FILE_FACTOR",
  /*  107 */ "NK_FLOAT",
  /*  108 */ "ROLLUP",
  /*  109 */ "TTL",
  /*  110 */ "SMA",
  /*  111 */ "SHOW",
  /*  112 */ "DATABASES",
  /*  113 */ "TABLES",
  /*  114 */ "STABLES",
  /*  115 */ "MNODES",
  /*  116 */ "MODULES",
  /*  117 */ "QNODES",
  /*  118 */ "FUNCTIONS",
  /*  119 */ "INDEXES",
  /*  120 */ "FROM",
  /*  121 */ "ACCOUNTS",
  /*  122 */ "APPS",
  /*  123 */ "CONNECTIONS",
  /*  124 */ "LICENCE",
  /*  125 */ "GRANTS",
  /*  126 */ "QUERIES",
  /*  127 */ "SCORES",
  /*  128 */ "TOPICS",
  /*  129 */ "VARIABLES",
  /*  130 */ "BNODES",
  /*  131 */ "SNODES",
  /*  132 */ "CLUSTER",
  /*  133 */ "LIKE",
  /*  134 */ "INDEX",
  /*  135 */ "FULLTEXT",
  /*  136 */ "FUNCTION",
  /*  137 */ "INTERVAL",
  /*  138 */ "TOPIC",
  /*  139 */ "AS",
  /*  140 */ "WITH",
  /*  141 */ "SCHEMA",
  /*  142 */ "DESC",
  /*  143 */ "DESCRIBE",
  /*  144 */ "RESET",
  /*  145 */ "QUERY",
  /*  146 */ "CACHE",
  /*  147 */ "EXPLAIN",
  /*  148 */ "ANALYZE",
  /*  149 */ "VERBOSE",
  /*  150 */ "NK_BOOL",
  /*  151 */ "RATIO",
  /*  152 */ "COMPACT",
  /*  153 */ "VNODES",
  /*  154 */ "IN",
  /*  155 */ "OUTPUTTYPE",
  /*  156 */ "AGGREGATE",
  /*  157 */ "BUFSIZE",
  /*  158 */ "STREAM",
  /*  159 */ "INTO",
  /*  160 */ "TRIGGER",
  /*  161 */ "AT_ONCE",
  /*  162 */ "WINDOW_CLOSE",
  /*  163 */ "WATERMARK",
  /*  164 */ "KILL",
  /*  165 */ "CONNECTION",
  /*  166 */ "MERGE",
  /*  167 */ "VGROUP",
  /*  168 */ "REDISTRIBUTE",
  /*  169 */ "SPLIT",
  /*  170 */ "SYNCDB",
  /*  171 */ "NULL",
  /*  172 */ "NK_QUESTION",
  /*  173 */ "NK_ARROW",
  /*  174 */ "ROWTS",
  /*  175 */ "TBNAME",
  /*  176 */ "QSTARTTS",
  /*  177 */ "QENDTS",
  /*  178 */ "WSTARTTS",
  /*  179 */ "WENDTS",
  /*  180 */ "WDURATION",
  /*  181 */ "CAST",
  /*  182 */ "NOW",
  /*  183 */ "TODAY",
  /*  184 */ "TIMEZONE",
  /*  185 */ "COUNT",
  /*  186 */ "FIRST",
  /*  187 */ "LAST",
  /*  188 */ "LAST_ROW",
  /*  189 */ "BETWEEN",
  /*  190 */ "IS",
  /*  191 */ "NK_LT",
  /*  192 */ "NK_GT",
  /*  193 */ "NK_LE",
  /*  194 */ "NK_GE",
  /*  195 */ "NK_NE",
  /*  196 */ "MATCH",
  /*  197 */ "NMATCH",
  /*  198 */ "CONTAINS",
  /*  199 */ "JOIN",
  /*  200 */ "INNER",
  /*  201 */ "SELECT",
  /*  202 */ "DISTINCT",
  /*  203 */ "WHERE",
  /*  204 */ "PARTITION",
  /*  205 */ "BY",
  /*  206 */ "SESSION",
  /*  207 */ "STATE_WINDOW",
  /*  208 */ "SLIDING",
  /*  209 */ "FILL",
  /*  210 */ "VALUE",
  /*  211 */ "NONE",
  /*  212 */ "PREV",
  /*  213 */ "LINEAR",
  /*  214 */ "NEXT",
  /*  215 */ "GROUP",
  /*  216 */ "HAVING",
  /*  217 */ "ORDER",
  /*  218 */ "SLIMIT",
  /*  219 */ "SOFFSET",
  /*  220 */ "LIMIT",
  /*  221 */ "OFFSET",
  /*  222 */ "ASC",
  /*  223 */ "NULLS",
  /*  224 */ "ID",
  /*  225 */ "NK_BITNOT",
  /*  226 */ "INSERT",
  /*  227 */ "VALUES",
  /*  228 */ "IMPORT",
  /*  229 */ "NK_SEMI",
  /*  230 */ "FILE",
  /*  231 */ "cmd",
  /*  232 */ "account_options",
  /*  233 */ "alter_account_options",
  /*  234 */ "literal",
  /*  235 */ "alter_account_option",
  /*  236 */ "user_name",
  /*  237 */ "dnode_endpoint",
  /*  238 */ "dnode_host_name",
  /*  239 */ "not_exists_opt",
  /*  240 */ "db_name",
  /*  241 */ "db_options",
  /*  242 */ "exists_opt",
  /*  243 */ "alter_db_options",
  /*  244 */ "integer_list",
  /*  245 */ "variable_list",
  /*  246 */ "retention_list",
  /*  247 */ "alter_db_option",
  /*  248 */ "retention",
  /*  249 */ "full_table_name",
  /*  250 */ "column_def_list",
  /*  251 */ "tags_def_opt",
  /*  252 */ "table_options",
  /*  253 */ "multi_create_clause",
  /*  254 */ "tags_def",
  /*  255 */ "multi_drop_clause",
  /*  256 */ "alter_table_clause",
  /*  257 */ "alter_table_options",
  /*  258 */ "column_name",
  /*  259 */ "type_name",
  /*  260 */ "create_subtable_clause",
  /*  261 */ "specific_tags_opt",
  /*  262 */ "literal_list",
  /*  263 */ "drop_table_clause",
  /*  264 */ "col_name_list",
  /*  265 */ "table_name",
  /*  266 */ "column_def",
  /*  267 */ "func_name_list",
  /*  268 */ "alter_table_option",
  /*  269 */ "col_name",
  /*  270 */ "db_name_cond_opt",
  /*  271 */ "like_pattern_opt",
  /*  272 */ "table_name_cond",
  /*  273 */ "from_db_opt",
  /*  274 */ "func_name",
  /*  275 */ "function_name",
  /*  276 */ "index_name",
  /*  277 */ "index_options",
  /*  278 */ "func_list",
  /*  279 */ "duration_literal",
  /*  280 */ "sliding_opt",
  /*  281 */ "func",
  /*  282 */ "expression_list",
  /*  283 */ "topic_name",
  /*  284 */ "topic_options",
  /*  285 */ "query_expression",
  /*  286 */ "analyze_opt",
  /*  287 */ "explain_options",
  /*  288 */ "agg_func_opt",
  /*  289 */ "bufsize_opt",
  /*  290 */ "stream_name",
  /*  291 */ "stream_options",
  /*  292 */ "into_opt",
  /*  293 */ "dnode_list",
  /*  294 */ "signed",
  /*  295 */ "signed_literal",
  /*  296 */ "literal_func",
  /*  297 */ "table_alias",
  /*  298 */ "column_alias",
  /*  299 */ "expression",
  /*  300 */ "pseudo_column",
  /*  301 */ "column_reference",
  /*  302 */ "function_expression",
  /*  303 */ "subquery",
  /*  304 */ "star_func",
  /*  305 */ "star_func_para_list",
  /*  306 */ "noarg_func",
  /*  307 */ "other_para_list",
  /*  308 */ "star_func_para",
  /*  309 */ "predicate",
  /*  310 */ "compare_op",
  /*  311 */ "in_op",
  /*  312 */ "in_predicate_value",
  /*  313 */ "boolean_value_expression",
  /*  314 */ "boolean_primary",
  /*  315 */ "common_expression",
  /*  316 */ "from_clause",
  /*  317 */ "table_reference_list",
  /*  318 */ "table_reference",
  /*  319 */ "table_primary",
  /*  320 */ "joined_table",
  /*  321 */ "alias_opt",
  /*  322 */ "parenthesized_joined_table",
  /*  323 */ "join_type",
  /*  324 */ "search_condition",
  /*  325 */ "query_specification",
  /*  326 */ "set_quantifier_opt",
  /*  327 */ "select_list",
  /*  328 */ "where_clause_opt",
  /*  329 */ "partition_by_clause_opt",
  /*  330 */ "twindow_clause_opt",
  /*  331 */ "group_by_clause_opt",
  /*  332 */ "having_clause_opt",
  /*  333 */ "select_sublist",
  /*  334 */ "select_item",
  /*  335 */ "fill_opt",
  /*  336 */ "fill_mode",
  /*  337 */ "group_by_list",
  /*  338 */ "query_expression_body",
  /*  339 */ "order_by_clause_opt",
  /*  340 */ "slimit_clause_opt",
  /*  341 */ "limit_clause_opt",
  /*  342 */ "query_primary",
  /*  343 */ "sort_specification_list",
  /*  344 */ "sort_specification",
  /*  345 */ "ordering_specification_opt",
  /*  346 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  29 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  30 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  31 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  32 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  33 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  34 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  35 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  36 */ "dnode_endpoint ::= NK_STRING",
 /*  37 */ "dnode_host_name ::= NK_ID",
 /*  38 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  39 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  40 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  41 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  42 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  43 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  45 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  46 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  47 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  48 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  49 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  50 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  51 */ "cmd ::= USE db_name",
 /*  52 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  53 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  54 */ "not_exists_opt ::=",
 /*  55 */ "exists_opt ::= IF EXISTS",
 /*  56 */ "exists_opt ::=",
 /*  57 */ "db_options ::=",
 /*  58 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  59 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  60 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  61 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  62 */ "db_options ::= db_options DAYS NK_VARIABLE",
 /*  63 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  64 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  65 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  66 */ "db_options ::= db_options KEEP integer_list",
 /*  67 */ "db_options ::= db_options KEEP variable_list",
 /*  68 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  69 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  70 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  71 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  72 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  73 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  74 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  75 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  76 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  77 */ "alter_db_options ::= alter_db_option",
 /*  78 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  79 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  80 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  81 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  82 */ "alter_db_option ::= KEEP integer_list",
 /*  83 */ "alter_db_option ::= KEEP variable_list",
 /*  84 */ "alter_db_option ::= PAGES NK_INTEGER",
 /*  85 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  86 */ "alter_db_option ::= STRICT NK_INTEGER",
 /*  87 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  88 */ "integer_list ::= NK_INTEGER",
 /*  89 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /*  90 */ "variable_list ::= NK_VARIABLE",
 /*  91 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /*  92 */ "retention_list ::= retention",
 /*  93 */ "retention_list ::= retention_list NK_COMMA retention",
 /*  94 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /*  95 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /*  96 */ "cmd ::= CREATE TABLE multi_create_clause",
 /*  97 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /*  98 */ "cmd ::= DROP TABLE multi_drop_clause",
 /*  99 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 100 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 101 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 102 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 103 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 104 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 105 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 106 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 107 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 108 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 109 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 110 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 111 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal",
 /* 112 */ "multi_create_clause ::= create_subtable_clause",
 /* 113 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 114 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options",
 /* 115 */ "multi_drop_clause ::= drop_table_clause",
 /* 116 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 117 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 118 */ "specific_tags_opt ::=",
 /* 119 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 120 */ "full_table_name ::= table_name",
 /* 121 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 122 */ "column_def_list ::= column_def",
 /* 123 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 124 */ "column_def ::= column_name type_name",
 /* 125 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 126 */ "type_name ::= BOOL",
 /* 127 */ "type_name ::= TINYINT",
 /* 128 */ "type_name ::= SMALLINT",
 /* 129 */ "type_name ::= INT",
 /* 130 */ "type_name ::= INTEGER",
 /* 131 */ "type_name ::= BIGINT",
 /* 132 */ "type_name ::= FLOAT",
 /* 133 */ "type_name ::= DOUBLE",
 /* 134 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 135 */ "type_name ::= TIMESTAMP",
 /* 136 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 137 */ "type_name ::= TINYINT UNSIGNED",
 /* 138 */ "type_name ::= SMALLINT UNSIGNED",
 /* 139 */ "type_name ::= INT UNSIGNED",
 /* 140 */ "type_name ::= BIGINT UNSIGNED",
 /* 141 */ "type_name ::= JSON",
 /* 142 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 143 */ "type_name ::= MEDIUMBLOB",
 /* 144 */ "type_name ::= BLOB",
 /* 145 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 146 */ "type_name ::= DECIMAL",
 /* 147 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 149 */ "tags_def_opt ::=",
 /* 150 */ "tags_def_opt ::= tags_def",
 /* 151 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 152 */ "table_options ::=",
 /* 153 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 154 */ "table_options ::= table_options DELAY NK_INTEGER",
 /* 155 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 156 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 157 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 158 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 159 */ "alter_table_options ::= alter_table_option",
 /* 160 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 161 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 162 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 163 */ "col_name_list ::= col_name",
 /* 164 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 165 */ "col_name ::= column_name",
 /* 166 */ "cmd ::= SHOW DNODES",
 /* 167 */ "cmd ::= SHOW USERS",
 /* 168 */ "cmd ::= SHOW DATABASES",
 /* 169 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 170 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 171 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 172 */ "cmd ::= SHOW MNODES",
 /* 173 */ "cmd ::= SHOW MODULES",
 /* 174 */ "cmd ::= SHOW QNODES",
 /* 175 */ "cmd ::= SHOW FUNCTIONS",
 /* 176 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 177 */ "cmd ::= SHOW STREAMS",
 /* 178 */ "cmd ::= SHOW ACCOUNTS",
 /* 179 */ "cmd ::= SHOW APPS",
 /* 180 */ "cmd ::= SHOW CONNECTIONS",
 /* 181 */ "cmd ::= SHOW LICENCE",
 /* 182 */ "cmd ::= SHOW GRANTS",
 /* 183 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 184 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 185 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 186 */ "cmd ::= SHOW QUERIES",
 /* 187 */ "cmd ::= SHOW SCORES",
 /* 188 */ "cmd ::= SHOW TOPICS",
 /* 189 */ "cmd ::= SHOW VARIABLES",
 /* 190 */ "cmd ::= SHOW BNODES",
 /* 191 */ "cmd ::= SHOW SNODES",
 /* 192 */ "cmd ::= SHOW CLUSTER",
 /* 193 */ "db_name_cond_opt ::=",
 /* 194 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 195 */ "like_pattern_opt ::=",
 /* 196 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 197 */ "table_name_cond ::= table_name",
 /* 198 */ "from_db_opt ::=",
 /* 199 */ "from_db_opt ::= FROM db_name",
 /* 200 */ "func_name_list ::= func_name",
 /* 201 */ "func_name_list ::= func_name_list NK_COMMA func_name",
 /* 202 */ "func_name ::= function_name",
 /* 203 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 204 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 205 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 206 */ "index_options ::=",
 /* 207 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 208 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 209 */ "func_list ::= func",
 /* 210 */ "func_list ::= func_list NK_COMMA func",
 /* 211 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 212 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS query_expression",
 /* 213 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS db_name",
 /* 214 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 215 */ "topic_options ::=",
 /* 216 */ "topic_options ::= topic_options WITH TABLE",
 /* 217 */ "topic_options ::= topic_options WITH SCHEMA",
 /* 218 */ "topic_options ::= topic_options WITH TAG",
 /* 219 */ "cmd ::= DESC full_table_name",
 /* 220 */ "cmd ::= DESCRIBE full_table_name",
 /* 221 */ "cmd ::= RESET QUERY CACHE",
 /* 222 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 223 */ "analyze_opt ::=",
 /* 224 */ "analyze_opt ::= ANALYZE",
 /* 225 */ "explain_options ::=",
 /* 226 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 227 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 228 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 229 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 230 */ "cmd ::= DROP FUNCTION function_name",
 /* 231 */ "agg_func_opt ::=",
 /* 232 */ "agg_func_opt ::= AGGREGATE",
 /* 233 */ "bufsize_opt ::=",
 /* 234 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 235 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 236 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 237 */ "into_opt ::=",
 /* 238 */ "into_opt ::= INTO full_table_name",
 /* 239 */ "stream_options ::=",
 /* 240 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 241 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 242 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 243 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 244 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 245 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 246 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 247 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 248 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 249 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 250 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 251 */ "cmd ::= query_expression",
 /* 252 */ "literal ::= NK_INTEGER",
 /* 253 */ "literal ::= NK_FLOAT",
 /* 254 */ "literal ::= NK_STRING",
 /* 255 */ "literal ::= NK_BOOL",
 /* 256 */ "literal ::= TIMESTAMP NK_STRING",
 /* 257 */ "literal ::= duration_literal",
 /* 258 */ "literal ::= NULL",
 /* 259 */ "literal ::= NK_QUESTION",
 /* 260 */ "duration_literal ::= NK_VARIABLE",
 /* 261 */ "signed ::= NK_INTEGER",
 /* 262 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 263 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 264 */ "signed ::= NK_FLOAT",
 /* 265 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 266 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 267 */ "signed_literal ::= signed",
 /* 268 */ "signed_literal ::= NK_STRING",
 /* 269 */ "signed_literal ::= NK_BOOL",
 /* 270 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 271 */ "signed_literal ::= duration_literal",
 /* 272 */ "signed_literal ::= NULL",
 /* 273 */ "signed_literal ::= literal_func",
 /* 274 */ "literal_list ::= signed_literal",
 /* 275 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 276 */ "db_name ::= NK_ID",
 /* 277 */ "table_name ::= NK_ID",
 /* 278 */ "column_name ::= NK_ID",
 /* 279 */ "function_name ::= NK_ID",
 /* 280 */ "table_alias ::= NK_ID",
 /* 281 */ "column_alias ::= NK_ID",
 /* 282 */ "user_name ::= NK_ID",
 /* 283 */ "index_name ::= NK_ID",
 /* 284 */ "topic_name ::= NK_ID",
 /* 285 */ "stream_name ::= NK_ID",
 /* 286 */ "expression ::= literal",
 /* 287 */ "expression ::= pseudo_column",
 /* 288 */ "expression ::= column_reference",
 /* 289 */ "expression ::= function_expression",
 /* 290 */ "expression ::= subquery",
 /* 291 */ "expression ::= NK_LP expression NK_RP",
 /* 292 */ "expression ::= NK_PLUS expression",
 /* 293 */ "expression ::= NK_MINUS expression",
 /* 294 */ "expression ::= expression NK_PLUS expression",
 /* 295 */ "expression ::= expression NK_MINUS expression",
 /* 296 */ "expression ::= expression NK_STAR expression",
 /* 297 */ "expression ::= expression NK_SLASH expression",
 /* 298 */ "expression ::= expression NK_REM expression",
 /* 299 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 300 */ "expression_list ::= expression",
 /* 301 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 302 */ "column_reference ::= column_name",
 /* 303 */ "column_reference ::= table_name NK_DOT column_name",
 /* 304 */ "pseudo_column ::= ROWTS",
 /* 305 */ "pseudo_column ::= TBNAME",
 /* 306 */ "pseudo_column ::= QSTARTTS",
 /* 307 */ "pseudo_column ::= QENDTS",
 /* 308 */ "pseudo_column ::= WSTARTTS",
 /* 309 */ "pseudo_column ::= WENDTS",
 /* 310 */ "pseudo_column ::= WDURATION",
 /* 311 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 312 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 313 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 314 */ "function_expression ::= literal_func",
 /* 315 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 316 */ "literal_func ::= NOW",
 /* 317 */ "noarg_func ::= NOW",
 /* 318 */ "noarg_func ::= TODAY",
 /* 319 */ "noarg_func ::= TIMEZONE",
 /* 320 */ "star_func ::= COUNT",
 /* 321 */ "star_func ::= FIRST",
 /* 322 */ "star_func ::= LAST",
 /* 323 */ "star_func ::= LAST_ROW",
 /* 324 */ "star_func_para_list ::= NK_STAR",
 /* 325 */ "star_func_para_list ::= other_para_list",
 /* 326 */ "other_para_list ::= star_func_para",
 /* 327 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 328 */ "star_func_para ::= expression",
 /* 329 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 330 */ "predicate ::= expression compare_op expression",
 /* 331 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 332 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 333 */ "predicate ::= expression IS NULL",
 /* 334 */ "predicate ::= expression IS NOT NULL",
 /* 335 */ "predicate ::= expression in_op in_predicate_value",
 /* 336 */ "compare_op ::= NK_LT",
 /* 337 */ "compare_op ::= NK_GT",
 /* 338 */ "compare_op ::= NK_LE",
 /* 339 */ "compare_op ::= NK_GE",
 /* 340 */ "compare_op ::= NK_NE",
 /* 341 */ "compare_op ::= NK_EQ",
 /* 342 */ "compare_op ::= LIKE",
 /* 343 */ "compare_op ::= NOT LIKE",
 /* 344 */ "compare_op ::= MATCH",
 /* 345 */ "compare_op ::= NMATCH",
 /* 346 */ "compare_op ::= CONTAINS",
 /* 347 */ "in_op ::= IN",
 /* 348 */ "in_op ::= NOT IN",
 /* 349 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 350 */ "boolean_value_expression ::= boolean_primary",
 /* 351 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 352 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 353 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 354 */ "boolean_primary ::= predicate",
 /* 355 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 356 */ "common_expression ::= expression",
 /* 357 */ "common_expression ::= boolean_value_expression",
 /* 358 */ "from_clause ::= FROM table_reference_list",
 /* 359 */ "table_reference_list ::= table_reference",
 /* 360 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 361 */ "table_reference ::= table_primary",
 /* 362 */ "table_reference ::= joined_table",
 /* 363 */ "table_primary ::= table_name alias_opt",
 /* 364 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 365 */ "table_primary ::= subquery alias_opt",
 /* 366 */ "table_primary ::= parenthesized_joined_table",
 /* 367 */ "alias_opt ::=",
 /* 368 */ "alias_opt ::= table_alias",
 /* 369 */ "alias_opt ::= AS table_alias",
 /* 370 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 371 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 372 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 373 */ "join_type ::=",
 /* 374 */ "join_type ::= INNER",
 /* 375 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 376 */ "set_quantifier_opt ::=",
 /* 377 */ "set_quantifier_opt ::= DISTINCT",
 /* 378 */ "set_quantifier_opt ::= ALL",
 /* 379 */ "select_list ::= NK_STAR",
 /* 380 */ "select_list ::= select_sublist",
 /* 381 */ "select_sublist ::= select_item",
 /* 382 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 383 */ "select_item ::= common_expression",
 /* 384 */ "select_item ::= common_expression column_alias",
 /* 385 */ "select_item ::= common_expression AS column_alias",
 /* 386 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 387 */ "where_clause_opt ::=",
 /* 388 */ "where_clause_opt ::= WHERE search_condition",
 /* 389 */ "partition_by_clause_opt ::=",
 /* 390 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 391 */ "twindow_clause_opt ::=",
 /* 392 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 393 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 394 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 395 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 396 */ "sliding_opt ::=",
 /* 397 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 398 */ "fill_opt ::=",
 /* 399 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 400 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 401 */ "fill_mode ::= NONE",
 /* 402 */ "fill_mode ::= PREV",
 /* 403 */ "fill_mode ::= NULL",
 /* 404 */ "fill_mode ::= LINEAR",
 /* 405 */ "fill_mode ::= NEXT",
 /* 406 */ "group_by_clause_opt ::=",
 /* 407 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 408 */ "group_by_list ::= expression",
 /* 409 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 410 */ "having_clause_opt ::=",
 /* 411 */ "having_clause_opt ::= HAVING search_condition",
 /* 412 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 413 */ "query_expression_body ::= query_primary",
 /* 414 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 415 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 416 */ "query_primary ::= query_specification",
 /* 417 */ "order_by_clause_opt ::=",
 /* 418 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 419 */ "slimit_clause_opt ::=",
 /* 420 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 421 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 422 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 423 */ "limit_clause_opt ::=",
 /* 424 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 425 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 426 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 427 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 428 */ "search_condition ::= common_expression",
 /* 429 */ "sort_specification_list ::= sort_specification",
 /* 430 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 431 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 432 */ "ordering_specification_opt ::=",
 /* 433 */ "ordering_specification_opt ::= ASC",
 /* 434 */ "ordering_specification_opt ::= DESC",
 /* 435 */ "null_ordering_opt ::=",
 /* 436 */ "null_ordering_opt ::= NULLS FIRST",
 /* 437 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 231: /* cmd */
    case 234: /* literal */
    case 241: /* db_options */
    case 243: /* alter_db_options */
    case 248: /* retention */
    case 249: /* full_table_name */
    case 252: /* table_options */
    case 256: /* alter_table_clause */
    case 257: /* alter_table_options */
    case 260: /* create_subtable_clause */
    case 263: /* drop_table_clause */
    case 266: /* column_def */
    case 269: /* col_name */
    case 270: /* db_name_cond_opt */
    case 271: /* like_pattern_opt */
    case 272: /* table_name_cond */
    case 273: /* from_db_opt */
    case 274: /* func_name */
    case 277: /* index_options */
    case 279: /* duration_literal */
    case 280: /* sliding_opt */
    case 281: /* func */
    case 284: /* topic_options */
    case 285: /* query_expression */
    case 287: /* explain_options */
    case 291: /* stream_options */
    case 292: /* into_opt */
    case 294: /* signed */
    case 295: /* signed_literal */
    case 296: /* literal_func */
    case 299: /* expression */
    case 300: /* pseudo_column */
    case 301: /* column_reference */
    case 302: /* function_expression */
    case 303: /* subquery */
    case 308: /* star_func_para */
    case 309: /* predicate */
    case 312: /* in_predicate_value */
    case 313: /* boolean_value_expression */
    case 314: /* boolean_primary */
    case 315: /* common_expression */
    case 316: /* from_clause */
    case 317: /* table_reference_list */
    case 318: /* table_reference */
    case 319: /* table_primary */
    case 320: /* joined_table */
    case 322: /* parenthesized_joined_table */
    case 324: /* search_condition */
    case 325: /* query_specification */
    case 328: /* where_clause_opt */
    case 330: /* twindow_clause_opt */
    case 332: /* having_clause_opt */
    case 334: /* select_item */
    case 335: /* fill_opt */
    case 338: /* query_expression_body */
    case 340: /* slimit_clause_opt */
    case 341: /* limit_clause_opt */
    case 342: /* query_primary */
    case 344: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy662)); 
}
      break;
    case 232: /* account_options */
    case 233: /* alter_account_options */
    case 235: /* alter_account_option */
    case 289: /* bufsize_opt */
{
 
}
      break;
    case 236: /* user_name */
    case 237: /* dnode_endpoint */
    case 238: /* dnode_host_name */
    case 240: /* db_name */
    case 258: /* column_name */
    case 265: /* table_name */
    case 275: /* function_name */
    case 276: /* index_name */
    case 283: /* topic_name */
    case 290: /* stream_name */
    case 297: /* table_alias */
    case 298: /* column_alias */
    case 304: /* star_func */
    case 306: /* noarg_func */
    case 321: /* alias_opt */
{
 
}
      break;
    case 239: /* not_exists_opt */
    case 242: /* exists_opt */
    case 286: /* analyze_opt */
    case 288: /* agg_func_opt */
    case 326: /* set_quantifier_opt */
{
 
}
      break;
    case 244: /* integer_list */
    case 245: /* variable_list */
    case 246: /* retention_list */
    case 250: /* column_def_list */
    case 251: /* tags_def_opt */
    case 253: /* multi_create_clause */
    case 254: /* tags_def */
    case 255: /* multi_drop_clause */
    case 261: /* specific_tags_opt */
    case 262: /* literal_list */
    case 264: /* col_name_list */
    case 267: /* func_name_list */
    case 278: /* func_list */
    case 282: /* expression_list */
    case 293: /* dnode_list */
    case 305: /* star_func_para_list */
    case 307: /* other_para_list */
    case 327: /* select_list */
    case 329: /* partition_by_clause_opt */
    case 331: /* group_by_clause_opt */
    case 333: /* select_sublist */
    case 337: /* group_by_list */
    case 339: /* order_by_clause_opt */
    case 343: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy568)); 
}
      break;
    case 247: /* alter_db_option */
    case 268: /* alter_table_option */
{
 
}
      break;
    case 259: /* type_name */
{
 
}
      break;
    case 310: /* compare_op */
    case 311: /* in_op */
{
 
}
      break;
    case 323: /* join_type */
{
 
}
      break;
    case 336: /* fill_mode */
{
 
}
      break;
    case 345: /* ordering_specification_opt */
{
 
}
      break;
    case 346: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  231,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  231,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  232,    0 }, /* (2) account_options ::= */
  {  232,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  232,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  232,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  232,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  232,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  232,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  232,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  232,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  232,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  233,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  233,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  235,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  235,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  235,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  235,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  235,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  235,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  235,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  235,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  235,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  235,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  231,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  231,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  231,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  231,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  231,   -3 }, /* (28) cmd ::= CREATE DNODE dnode_endpoint */
  {  231,   -5 }, /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  231,   -3 }, /* (30) cmd ::= DROP DNODE NK_INTEGER */
  {  231,   -3 }, /* (31) cmd ::= DROP DNODE dnode_endpoint */
  {  231,   -4 }, /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  231,   -5 }, /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  231,   -4 }, /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
  {  231,   -5 }, /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  237,   -1 }, /* (36) dnode_endpoint ::= NK_STRING */
  {  238,   -1 }, /* (37) dnode_host_name ::= NK_ID */
  {  238,   -1 }, /* (38) dnode_host_name ::= NK_IPTOKEN */
  {  231,   -3 }, /* (39) cmd ::= ALTER LOCAL NK_STRING */
  {  231,   -4 }, /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  231,   -5 }, /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (43) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (44) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (45) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (46) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (47) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (48) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  231,   -5 }, /* (49) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  231,   -4 }, /* (50) cmd ::= DROP DATABASE exists_opt db_name */
  {  231,   -2 }, /* (51) cmd ::= USE db_name */
  {  231,   -4 }, /* (52) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  239,   -3 }, /* (53) not_exists_opt ::= IF NOT EXISTS */
  {  239,    0 }, /* (54) not_exists_opt ::= */
  {  242,   -2 }, /* (55) exists_opt ::= IF EXISTS */
  {  242,    0 }, /* (56) exists_opt ::= */
  {  241,    0 }, /* (57) db_options ::= */
  {  241,   -3 }, /* (58) db_options ::= db_options BUFFER NK_INTEGER */
  {  241,   -3 }, /* (59) db_options ::= db_options CACHELAST NK_INTEGER */
  {  241,   -3 }, /* (60) db_options ::= db_options COMP NK_INTEGER */
  {  241,   -3 }, /* (61) db_options ::= db_options DAYS NK_INTEGER */
  {  241,   -3 }, /* (62) db_options ::= db_options DAYS NK_VARIABLE */
  {  241,   -3 }, /* (63) db_options ::= db_options FSYNC NK_INTEGER */
  {  241,   -3 }, /* (64) db_options ::= db_options MAXROWS NK_INTEGER */
  {  241,   -3 }, /* (65) db_options ::= db_options MINROWS NK_INTEGER */
  {  241,   -3 }, /* (66) db_options ::= db_options KEEP integer_list */
  {  241,   -3 }, /* (67) db_options ::= db_options KEEP variable_list */
  {  241,   -3 }, /* (68) db_options ::= db_options PAGES NK_INTEGER */
  {  241,   -3 }, /* (69) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  241,   -3 }, /* (70) db_options ::= db_options PRECISION NK_STRING */
  {  241,   -3 }, /* (71) db_options ::= db_options REPLICA NK_INTEGER */
  {  241,   -3 }, /* (72) db_options ::= db_options STRICT NK_INTEGER */
  {  241,   -3 }, /* (73) db_options ::= db_options WAL NK_INTEGER */
  {  241,   -3 }, /* (74) db_options ::= db_options VGROUPS NK_INTEGER */
  {  241,   -3 }, /* (75) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  241,   -3 }, /* (76) db_options ::= db_options RETENTIONS retention_list */
  {  243,   -1 }, /* (77) alter_db_options ::= alter_db_option */
  {  243,   -2 }, /* (78) alter_db_options ::= alter_db_options alter_db_option */
  {  247,   -2 }, /* (79) alter_db_option ::= BUFFER NK_INTEGER */
  {  247,   -2 }, /* (80) alter_db_option ::= CACHELAST NK_INTEGER */
  {  247,   -2 }, /* (81) alter_db_option ::= FSYNC NK_INTEGER */
  {  247,   -2 }, /* (82) alter_db_option ::= KEEP integer_list */
  {  247,   -2 }, /* (83) alter_db_option ::= KEEP variable_list */
  {  247,   -2 }, /* (84) alter_db_option ::= PAGES NK_INTEGER */
  {  247,   -2 }, /* (85) alter_db_option ::= REPLICA NK_INTEGER */
  {  247,   -2 }, /* (86) alter_db_option ::= STRICT NK_INTEGER */
  {  247,   -2 }, /* (87) alter_db_option ::= WAL NK_INTEGER */
  {  244,   -1 }, /* (88) integer_list ::= NK_INTEGER */
  {  244,   -3 }, /* (89) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  245,   -1 }, /* (90) variable_list ::= NK_VARIABLE */
  {  245,   -3 }, /* (91) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  246,   -1 }, /* (92) retention_list ::= retention */
  {  246,   -3 }, /* (93) retention_list ::= retention_list NK_COMMA retention */
  {  248,   -3 }, /* (94) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  231,   -9 }, /* (95) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  231,   -3 }, /* (96) cmd ::= CREATE TABLE multi_create_clause */
  {  231,   -9 }, /* (97) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  231,   -3 }, /* (98) cmd ::= DROP TABLE multi_drop_clause */
  {  231,   -4 }, /* (99) cmd ::= DROP STABLE exists_opt full_table_name */
  {  231,   -3 }, /* (100) cmd ::= ALTER TABLE alter_table_clause */
  {  231,   -3 }, /* (101) cmd ::= ALTER STABLE alter_table_clause */
  {  256,   -2 }, /* (102) alter_table_clause ::= full_table_name alter_table_options */
  {  256,   -5 }, /* (103) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  256,   -4 }, /* (104) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  256,   -5 }, /* (105) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  256,   -5 }, /* (106) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  256,   -5 }, /* (107) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  256,   -4 }, /* (108) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  256,   -5 }, /* (109) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  256,   -5 }, /* (110) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  256,   -6 }, /* (111) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
  {  253,   -1 }, /* (112) multi_create_clause ::= create_subtable_clause */
  {  253,   -2 }, /* (113) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  260,  -10 }, /* (114) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
  {  255,   -1 }, /* (115) multi_drop_clause ::= drop_table_clause */
  {  255,   -2 }, /* (116) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  263,   -2 }, /* (117) drop_table_clause ::= exists_opt full_table_name */
  {  261,    0 }, /* (118) specific_tags_opt ::= */
  {  261,   -3 }, /* (119) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  249,   -1 }, /* (120) full_table_name ::= table_name */
  {  249,   -3 }, /* (121) full_table_name ::= db_name NK_DOT table_name */
  {  250,   -1 }, /* (122) column_def_list ::= column_def */
  {  250,   -3 }, /* (123) column_def_list ::= column_def_list NK_COMMA column_def */
  {  266,   -2 }, /* (124) column_def ::= column_name type_name */
  {  266,   -4 }, /* (125) column_def ::= column_name type_name COMMENT NK_STRING */
  {  259,   -1 }, /* (126) type_name ::= BOOL */
  {  259,   -1 }, /* (127) type_name ::= TINYINT */
  {  259,   -1 }, /* (128) type_name ::= SMALLINT */
  {  259,   -1 }, /* (129) type_name ::= INT */
  {  259,   -1 }, /* (130) type_name ::= INTEGER */
  {  259,   -1 }, /* (131) type_name ::= BIGINT */
  {  259,   -1 }, /* (132) type_name ::= FLOAT */
  {  259,   -1 }, /* (133) type_name ::= DOUBLE */
  {  259,   -4 }, /* (134) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  259,   -1 }, /* (135) type_name ::= TIMESTAMP */
  {  259,   -4 }, /* (136) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  259,   -2 }, /* (137) type_name ::= TINYINT UNSIGNED */
  {  259,   -2 }, /* (138) type_name ::= SMALLINT UNSIGNED */
  {  259,   -2 }, /* (139) type_name ::= INT UNSIGNED */
  {  259,   -2 }, /* (140) type_name ::= BIGINT UNSIGNED */
  {  259,   -1 }, /* (141) type_name ::= JSON */
  {  259,   -4 }, /* (142) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  259,   -1 }, /* (143) type_name ::= MEDIUMBLOB */
  {  259,   -1 }, /* (144) type_name ::= BLOB */
  {  259,   -4 }, /* (145) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  259,   -1 }, /* (146) type_name ::= DECIMAL */
  {  259,   -4 }, /* (147) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  259,   -6 }, /* (148) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  251,    0 }, /* (149) tags_def_opt ::= */
  {  251,   -1 }, /* (150) tags_def_opt ::= tags_def */
  {  254,   -4 }, /* (151) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  252,    0 }, /* (152) table_options ::= */
  {  252,   -3 }, /* (153) table_options ::= table_options COMMENT NK_STRING */
  {  252,   -3 }, /* (154) table_options ::= table_options DELAY NK_INTEGER */
  {  252,   -3 }, /* (155) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  252,   -5 }, /* (156) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  252,   -3 }, /* (157) table_options ::= table_options TTL NK_INTEGER */
  {  252,   -5 }, /* (158) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  257,   -1 }, /* (159) alter_table_options ::= alter_table_option */
  {  257,   -2 }, /* (160) alter_table_options ::= alter_table_options alter_table_option */
  {  268,   -2 }, /* (161) alter_table_option ::= COMMENT NK_STRING */
  {  268,   -2 }, /* (162) alter_table_option ::= TTL NK_INTEGER */
  {  264,   -1 }, /* (163) col_name_list ::= col_name */
  {  264,   -3 }, /* (164) col_name_list ::= col_name_list NK_COMMA col_name */
  {  269,   -1 }, /* (165) col_name ::= column_name */
  {  231,   -2 }, /* (166) cmd ::= SHOW DNODES */
  {  231,   -2 }, /* (167) cmd ::= SHOW USERS */
  {  231,   -2 }, /* (168) cmd ::= SHOW DATABASES */
  {  231,   -4 }, /* (169) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  231,   -4 }, /* (170) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  231,   -3 }, /* (171) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  231,   -2 }, /* (172) cmd ::= SHOW MNODES */
  {  231,   -2 }, /* (173) cmd ::= SHOW MODULES */
  {  231,   -2 }, /* (174) cmd ::= SHOW QNODES */
  {  231,   -2 }, /* (175) cmd ::= SHOW FUNCTIONS */
  {  231,   -5 }, /* (176) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  231,   -2 }, /* (177) cmd ::= SHOW STREAMS */
  {  231,   -2 }, /* (178) cmd ::= SHOW ACCOUNTS */
  {  231,   -2 }, /* (179) cmd ::= SHOW APPS */
  {  231,   -2 }, /* (180) cmd ::= SHOW CONNECTIONS */
  {  231,   -2 }, /* (181) cmd ::= SHOW LICENCE */
  {  231,   -2 }, /* (182) cmd ::= SHOW GRANTS */
  {  231,   -4 }, /* (183) cmd ::= SHOW CREATE DATABASE db_name */
  {  231,   -4 }, /* (184) cmd ::= SHOW CREATE TABLE full_table_name */
  {  231,   -4 }, /* (185) cmd ::= SHOW CREATE STABLE full_table_name */
  {  231,   -2 }, /* (186) cmd ::= SHOW QUERIES */
  {  231,   -2 }, /* (187) cmd ::= SHOW SCORES */
  {  231,   -2 }, /* (188) cmd ::= SHOW TOPICS */
  {  231,   -2 }, /* (189) cmd ::= SHOW VARIABLES */
  {  231,   -2 }, /* (190) cmd ::= SHOW BNODES */
  {  231,   -2 }, /* (191) cmd ::= SHOW SNODES */
  {  231,   -2 }, /* (192) cmd ::= SHOW CLUSTER */
  {  270,    0 }, /* (193) db_name_cond_opt ::= */
  {  270,   -2 }, /* (194) db_name_cond_opt ::= db_name NK_DOT */
  {  271,    0 }, /* (195) like_pattern_opt ::= */
  {  271,   -2 }, /* (196) like_pattern_opt ::= LIKE NK_STRING */
  {  272,   -1 }, /* (197) table_name_cond ::= table_name */
  {  273,    0 }, /* (198) from_db_opt ::= */
  {  273,   -2 }, /* (199) from_db_opt ::= FROM db_name */
  {  267,   -1 }, /* (200) func_name_list ::= func_name */
  {  267,   -3 }, /* (201) func_name_list ::= func_name_list NK_COMMA func_name */
  {  274,   -1 }, /* (202) func_name ::= function_name */
  {  231,   -8 }, /* (203) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  231,  -10 }, /* (204) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  231,   -6 }, /* (205) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  277,    0 }, /* (206) index_options ::= */
  {  277,   -9 }, /* (207) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  277,  -11 }, /* (208) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  278,   -1 }, /* (209) func_list ::= func */
  {  278,   -3 }, /* (210) func_list ::= func_list NK_COMMA func */
  {  281,   -4 }, /* (211) func ::= function_name NK_LP expression_list NK_RP */
  {  231,   -7 }, /* (212) cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS query_expression */
  {  231,   -7 }, /* (213) cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS db_name */
  {  231,   -4 }, /* (214) cmd ::= DROP TOPIC exists_opt topic_name */
  {  284,    0 }, /* (215) topic_options ::= */
  {  284,   -3 }, /* (216) topic_options ::= topic_options WITH TABLE */
  {  284,   -3 }, /* (217) topic_options ::= topic_options WITH SCHEMA */
  {  284,   -3 }, /* (218) topic_options ::= topic_options WITH TAG */
  {  231,   -2 }, /* (219) cmd ::= DESC full_table_name */
  {  231,   -2 }, /* (220) cmd ::= DESCRIBE full_table_name */
  {  231,   -3 }, /* (221) cmd ::= RESET QUERY CACHE */
  {  231,   -4 }, /* (222) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  286,    0 }, /* (223) analyze_opt ::= */
  {  286,   -1 }, /* (224) analyze_opt ::= ANALYZE */
  {  287,    0 }, /* (225) explain_options ::= */
  {  287,   -3 }, /* (226) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  287,   -3 }, /* (227) explain_options ::= explain_options RATIO NK_FLOAT */
  {  231,   -6 }, /* (228) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  231,  -10 }, /* (229) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  231,   -3 }, /* (230) cmd ::= DROP FUNCTION function_name */
  {  288,    0 }, /* (231) agg_func_opt ::= */
  {  288,   -1 }, /* (232) agg_func_opt ::= AGGREGATE */
  {  289,    0 }, /* (233) bufsize_opt ::= */
  {  289,   -2 }, /* (234) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  231,   -8 }, /* (235) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  231,   -4 }, /* (236) cmd ::= DROP STREAM exists_opt stream_name */
  {  292,    0 }, /* (237) into_opt ::= */
  {  292,   -2 }, /* (238) into_opt ::= INTO full_table_name */
  {  291,    0 }, /* (239) stream_options ::= */
  {  291,   -3 }, /* (240) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  291,   -3 }, /* (241) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  291,   -3 }, /* (242) stream_options ::= stream_options WATERMARK duration_literal */
  {  231,   -3 }, /* (243) cmd ::= KILL CONNECTION NK_INTEGER */
  {  231,   -3 }, /* (244) cmd ::= KILL QUERY NK_INTEGER */
  {  231,   -4 }, /* (245) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  231,   -4 }, /* (246) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  231,   -3 }, /* (247) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  293,   -2 }, /* (248) dnode_list ::= DNODE NK_INTEGER */
  {  293,   -3 }, /* (249) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  231,   -3 }, /* (250) cmd ::= SYNCDB db_name REPLICA */
  {  231,   -1 }, /* (251) cmd ::= query_expression */
  {  234,   -1 }, /* (252) literal ::= NK_INTEGER */
  {  234,   -1 }, /* (253) literal ::= NK_FLOAT */
  {  234,   -1 }, /* (254) literal ::= NK_STRING */
  {  234,   -1 }, /* (255) literal ::= NK_BOOL */
  {  234,   -2 }, /* (256) literal ::= TIMESTAMP NK_STRING */
  {  234,   -1 }, /* (257) literal ::= duration_literal */
  {  234,   -1 }, /* (258) literal ::= NULL */
  {  234,   -1 }, /* (259) literal ::= NK_QUESTION */
  {  279,   -1 }, /* (260) duration_literal ::= NK_VARIABLE */
  {  294,   -1 }, /* (261) signed ::= NK_INTEGER */
  {  294,   -2 }, /* (262) signed ::= NK_PLUS NK_INTEGER */
  {  294,   -2 }, /* (263) signed ::= NK_MINUS NK_INTEGER */
  {  294,   -1 }, /* (264) signed ::= NK_FLOAT */
  {  294,   -2 }, /* (265) signed ::= NK_PLUS NK_FLOAT */
  {  294,   -2 }, /* (266) signed ::= NK_MINUS NK_FLOAT */
  {  295,   -1 }, /* (267) signed_literal ::= signed */
  {  295,   -1 }, /* (268) signed_literal ::= NK_STRING */
  {  295,   -1 }, /* (269) signed_literal ::= NK_BOOL */
  {  295,   -2 }, /* (270) signed_literal ::= TIMESTAMP NK_STRING */
  {  295,   -1 }, /* (271) signed_literal ::= duration_literal */
  {  295,   -1 }, /* (272) signed_literal ::= NULL */
  {  295,   -1 }, /* (273) signed_literal ::= literal_func */
  {  262,   -1 }, /* (274) literal_list ::= signed_literal */
  {  262,   -3 }, /* (275) literal_list ::= literal_list NK_COMMA signed_literal */
  {  240,   -1 }, /* (276) db_name ::= NK_ID */
  {  265,   -1 }, /* (277) table_name ::= NK_ID */
  {  258,   -1 }, /* (278) column_name ::= NK_ID */
  {  275,   -1 }, /* (279) function_name ::= NK_ID */
  {  297,   -1 }, /* (280) table_alias ::= NK_ID */
  {  298,   -1 }, /* (281) column_alias ::= NK_ID */
  {  236,   -1 }, /* (282) user_name ::= NK_ID */
  {  276,   -1 }, /* (283) index_name ::= NK_ID */
  {  283,   -1 }, /* (284) topic_name ::= NK_ID */
  {  290,   -1 }, /* (285) stream_name ::= NK_ID */
  {  299,   -1 }, /* (286) expression ::= literal */
  {  299,   -1 }, /* (287) expression ::= pseudo_column */
  {  299,   -1 }, /* (288) expression ::= column_reference */
  {  299,   -1 }, /* (289) expression ::= function_expression */
  {  299,   -1 }, /* (290) expression ::= subquery */
  {  299,   -3 }, /* (291) expression ::= NK_LP expression NK_RP */
  {  299,   -2 }, /* (292) expression ::= NK_PLUS expression */
  {  299,   -2 }, /* (293) expression ::= NK_MINUS expression */
  {  299,   -3 }, /* (294) expression ::= expression NK_PLUS expression */
  {  299,   -3 }, /* (295) expression ::= expression NK_MINUS expression */
  {  299,   -3 }, /* (296) expression ::= expression NK_STAR expression */
  {  299,   -3 }, /* (297) expression ::= expression NK_SLASH expression */
  {  299,   -3 }, /* (298) expression ::= expression NK_REM expression */
  {  299,   -3 }, /* (299) expression ::= column_reference NK_ARROW NK_STRING */
  {  282,   -1 }, /* (300) expression_list ::= expression */
  {  282,   -3 }, /* (301) expression_list ::= expression_list NK_COMMA expression */
  {  301,   -1 }, /* (302) column_reference ::= column_name */
  {  301,   -3 }, /* (303) column_reference ::= table_name NK_DOT column_name */
  {  300,   -1 }, /* (304) pseudo_column ::= ROWTS */
  {  300,   -1 }, /* (305) pseudo_column ::= TBNAME */
  {  300,   -1 }, /* (306) pseudo_column ::= QSTARTTS */
  {  300,   -1 }, /* (307) pseudo_column ::= QENDTS */
  {  300,   -1 }, /* (308) pseudo_column ::= WSTARTTS */
  {  300,   -1 }, /* (309) pseudo_column ::= WENDTS */
  {  300,   -1 }, /* (310) pseudo_column ::= WDURATION */
  {  302,   -4 }, /* (311) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  302,   -4 }, /* (312) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  302,   -6 }, /* (313) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  302,   -1 }, /* (314) function_expression ::= literal_func */
  {  296,   -3 }, /* (315) literal_func ::= noarg_func NK_LP NK_RP */
  {  296,   -1 }, /* (316) literal_func ::= NOW */
  {  306,   -1 }, /* (317) noarg_func ::= NOW */
  {  306,   -1 }, /* (318) noarg_func ::= TODAY */
  {  306,   -1 }, /* (319) noarg_func ::= TIMEZONE */
  {  304,   -1 }, /* (320) star_func ::= COUNT */
  {  304,   -1 }, /* (321) star_func ::= FIRST */
  {  304,   -1 }, /* (322) star_func ::= LAST */
  {  304,   -1 }, /* (323) star_func ::= LAST_ROW */
  {  305,   -1 }, /* (324) star_func_para_list ::= NK_STAR */
  {  305,   -1 }, /* (325) star_func_para_list ::= other_para_list */
  {  307,   -1 }, /* (326) other_para_list ::= star_func_para */
  {  307,   -3 }, /* (327) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  308,   -1 }, /* (328) star_func_para ::= expression */
  {  308,   -3 }, /* (329) star_func_para ::= table_name NK_DOT NK_STAR */
  {  309,   -3 }, /* (330) predicate ::= expression compare_op expression */
  {  309,   -5 }, /* (331) predicate ::= expression BETWEEN expression AND expression */
  {  309,   -6 }, /* (332) predicate ::= expression NOT BETWEEN expression AND expression */
  {  309,   -3 }, /* (333) predicate ::= expression IS NULL */
  {  309,   -4 }, /* (334) predicate ::= expression IS NOT NULL */
  {  309,   -3 }, /* (335) predicate ::= expression in_op in_predicate_value */
  {  310,   -1 }, /* (336) compare_op ::= NK_LT */
  {  310,   -1 }, /* (337) compare_op ::= NK_GT */
  {  310,   -1 }, /* (338) compare_op ::= NK_LE */
  {  310,   -1 }, /* (339) compare_op ::= NK_GE */
  {  310,   -1 }, /* (340) compare_op ::= NK_NE */
  {  310,   -1 }, /* (341) compare_op ::= NK_EQ */
  {  310,   -1 }, /* (342) compare_op ::= LIKE */
  {  310,   -2 }, /* (343) compare_op ::= NOT LIKE */
  {  310,   -1 }, /* (344) compare_op ::= MATCH */
  {  310,   -1 }, /* (345) compare_op ::= NMATCH */
  {  310,   -1 }, /* (346) compare_op ::= CONTAINS */
  {  311,   -1 }, /* (347) in_op ::= IN */
  {  311,   -2 }, /* (348) in_op ::= NOT IN */
  {  312,   -3 }, /* (349) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  313,   -1 }, /* (350) boolean_value_expression ::= boolean_primary */
  {  313,   -2 }, /* (351) boolean_value_expression ::= NOT boolean_primary */
  {  313,   -3 }, /* (352) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  313,   -3 }, /* (353) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  314,   -1 }, /* (354) boolean_primary ::= predicate */
  {  314,   -3 }, /* (355) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  315,   -1 }, /* (356) common_expression ::= expression */
  {  315,   -1 }, /* (357) common_expression ::= boolean_value_expression */
  {  316,   -2 }, /* (358) from_clause ::= FROM table_reference_list */
  {  317,   -1 }, /* (359) table_reference_list ::= table_reference */
  {  317,   -3 }, /* (360) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  318,   -1 }, /* (361) table_reference ::= table_primary */
  {  318,   -1 }, /* (362) table_reference ::= joined_table */
  {  319,   -2 }, /* (363) table_primary ::= table_name alias_opt */
  {  319,   -4 }, /* (364) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  319,   -2 }, /* (365) table_primary ::= subquery alias_opt */
  {  319,   -1 }, /* (366) table_primary ::= parenthesized_joined_table */
  {  321,    0 }, /* (367) alias_opt ::= */
  {  321,   -1 }, /* (368) alias_opt ::= table_alias */
  {  321,   -2 }, /* (369) alias_opt ::= AS table_alias */
  {  322,   -3 }, /* (370) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  322,   -3 }, /* (371) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  320,   -6 }, /* (372) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  323,    0 }, /* (373) join_type ::= */
  {  323,   -1 }, /* (374) join_type ::= INNER */
  {  325,   -9 }, /* (375) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  326,    0 }, /* (376) set_quantifier_opt ::= */
  {  326,   -1 }, /* (377) set_quantifier_opt ::= DISTINCT */
  {  326,   -1 }, /* (378) set_quantifier_opt ::= ALL */
  {  327,   -1 }, /* (379) select_list ::= NK_STAR */
  {  327,   -1 }, /* (380) select_list ::= select_sublist */
  {  333,   -1 }, /* (381) select_sublist ::= select_item */
  {  333,   -3 }, /* (382) select_sublist ::= select_sublist NK_COMMA select_item */
  {  334,   -1 }, /* (383) select_item ::= common_expression */
  {  334,   -2 }, /* (384) select_item ::= common_expression column_alias */
  {  334,   -3 }, /* (385) select_item ::= common_expression AS column_alias */
  {  334,   -3 }, /* (386) select_item ::= table_name NK_DOT NK_STAR */
  {  328,    0 }, /* (387) where_clause_opt ::= */
  {  328,   -2 }, /* (388) where_clause_opt ::= WHERE search_condition */
  {  329,    0 }, /* (389) partition_by_clause_opt ::= */
  {  329,   -3 }, /* (390) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  330,    0 }, /* (391) twindow_clause_opt ::= */
  {  330,   -6 }, /* (392) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  330,   -4 }, /* (393) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  330,   -6 }, /* (394) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  330,   -8 }, /* (395) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  280,    0 }, /* (396) sliding_opt ::= */
  {  280,   -4 }, /* (397) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  335,    0 }, /* (398) fill_opt ::= */
  {  335,   -4 }, /* (399) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  335,   -6 }, /* (400) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  336,   -1 }, /* (401) fill_mode ::= NONE */
  {  336,   -1 }, /* (402) fill_mode ::= PREV */
  {  336,   -1 }, /* (403) fill_mode ::= NULL */
  {  336,   -1 }, /* (404) fill_mode ::= LINEAR */
  {  336,   -1 }, /* (405) fill_mode ::= NEXT */
  {  331,    0 }, /* (406) group_by_clause_opt ::= */
  {  331,   -3 }, /* (407) group_by_clause_opt ::= GROUP BY group_by_list */
  {  337,   -1 }, /* (408) group_by_list ::= expression */
  {  337,   -3 }, /* (409) group_by_list ::= group_by_list NK_COMMA expression */
  {  332,    0 }, /* (410) having_clause_opt ::= */
  {  332,   -2 }, /* (411) having_clause_opt ::= HAVING search_condition */
  {  285,   -4 }, /* (412) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  338,   -1 }, /* (413) query_expression_body ::= query_primary */
  {  338,   -4 }, /* (414) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  338,   -3 }, /* (415) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  342,   -1 }, /* (416) query_primary ::= query_specification */
  {  339,    0 }, /* (417) order_by_clause_opt ::= */
  {  339,   -3 }, /* (418) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  340,    0 }, /* (419) slimit_clause_opt ::= */
  {  340,   -2 }, /* (420) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  340,   -4 }, /* (421) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  340,   -4 }, /* (422) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  341,    0 }, /* (423) limit_clause_opt ::= */
  {  341,   -2 }, /* (424) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  341,   -4 }, /* (425) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  341,   -4 }, /* (426) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  303,   -3 }, /* (427) subquery ::= NK_LP query_expression NK_RP */
  {  324,   -1 }, /* (428) search_condition ::= common_expression */
  {  343,   -1 }, /* (429) sort_specification_list ::= sort_specification */
  {  343,   -3 }, /* (430) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  344,   -3 }, /* (431) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  345,    0 }, /* (432) ordering_specification_opt ::= */
  {  345,   -1 }, /* (433) ordering_specification_opt ::= ASC */
  {  345,   -1 }, /* (434) ordering_specification_opt ::= DESC */
  {  346,    0 }, /* (435) null_ordering_opt ::= */
  {  346,   -2 }, /* (436) null_ordering_opt ::= NULLS FIRST */
  {  346,   -2 }, /* (437) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,232,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,233,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,232,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,234,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,235,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,233,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,235,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,234,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy555, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy555, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy555, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy555); }
        break;
      case 28: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy555, NULL); }
        break;
      case 29: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy555, &yymsp[0].minor.yy0); }
        break;
      case 30: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 31: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy555); }
        break;
      case 32: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 33: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 34: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 35: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 36: /* dnode_endpoint ::= NK_STRING */
      case 37: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==37);
      case 38: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==38);
      case 276: /* db_name ::= NK_ID */ yytestcase(yyruleno==276);
      case 277: /* table_name ::= NK_ID */ yytestcase(yyruleno==277);
      case 278: /* column_name ::= NK_ID */ yytestcase(yyruleno==278);
      case 279: /* function_name ::= NK_ID */ yytestcase(yyruleno==279);
      case 280: /* table_alias ::= NK_ID */ yytestcase(yyruleno==280);
      case 281: /* column_alias ::= NK_ID */ yytestcase(yyruleno==281);
      case 282: /* user_name ::= NK_ID */ yytestcase(yyruleno==282);
      case 283: /* index_name ::= NK_ID */ yytestcase(yyruleno==283);
      case 284: /* topic_name ::= NK_ID */ yytestcase(yyruleno==284);
      case 285: /* stream_name ::= NK_ID */ yytestcase(yyruleno==285);
      case 317: /* noarg_func ::= NOW */ yytestcase(yyruleno==317);
      case 318: /* noarg_func ::= TODAY */ yytestcase(yyruleno==318);
      case 319: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==319);
      case 320: /* star_func ::= COUNT */ yytestcase(yyruleno==320);
      case 321: /* star_func ::= FIRST */ yytestcase(yyruleno==321);
      case 322: /* star_func ::= LAST */ yytestcase(yyruleno==322);
      case 323: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==323);
{ yylhsminor.yy555 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy555 = yylhsminor.yy555;
        break;
      case 39: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 40: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 42: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 46: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy617, &yymsp[-1].minor.yy555, yymsp[0].minor.yy662); }
        break;
      case 50: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy617, &yymsp[0].minor.yy555); }
        break;
      case 51: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy555); }
        break;
      case 52: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy555, yymsp[0].minor.yy662); }
        break;
      case 53: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy617 = true; }
        break;
      case 54: /* not_exists_opt ::= */
      case 56: /* exists_opt ::= */ yytestcase(yyruleno==56);
      case 223: /* analyze_opt ::= */ yytestcase(yyruleno==223);
      case 231: /* agg_func_opt ::= */ yytestcase(yyruleno==231);
      case 376: /* set_quantifier_opt ::= */ yytestcase(yyruleno==376);
{ yymsp[1].minor.yy617 = false; }
        break;
      case 55: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy617 = true; }
        break;
      case 57: /* db_options ::= */
{ yymsp[1].minor.yy662 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 58: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy662 = setDatabaseOption(pCxt, yymsp[-2].minor.yy662, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 59: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy662 = setDatabaseOption(pCxt, yymsp[-2].minor.yy662, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 60: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy662 = setDatabaseOption(pCxt, yymsp[-2].minor.yy662, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 61: /* db_options ::= db_options DAYS NK_INTEGER */
      case 62: /* db_options ::= db_options DAYS NK_VARIABLE */ yytestcase(yyruleno==62);
{ yylhsminor.yy662 = setDatabaseOption(pCxt, yymsp[-2].minor.yy662, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 63: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy662 = setDatabaseOption(pCxt, yymsp[-2].minor.yy662, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 64: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy662 = setDatabaseOption(pCxt, yymsp[-2].minor.yy662, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 65: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy662 = setDatabaseOption(pCxt, yymsp[-2].minor.yy662, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 66: /* db_options ::= db_options KEEP integer_list */
      case 67: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==67);
{ yylhsminor.yy662 = setDatabaseOption(pCxt, yymsp[-2].minor.yy662, DB_OPTION_KEEP, yymsp[0].minor.yy568); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 68: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy662 = setDatabaseOption(pCxt, yymsp[-2].minor.yy662, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 69: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy662 = setDatabaseOption(pCxt, yymsp[-2].minor.yy662, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 70: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy662 = setDatabaseOption(pCxt, yymsp[-2].minor.yy662, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 71: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy662 = setDatabaseOption(pCxt, yymsp[-2].minor.yy662, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 72: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy662 = setDatabaseOption(pCxt, yymsp[-2].minor.yy662, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 73: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy662 = setDatabaseOption(pCxt, yymsp[-2].minor.yy662, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 74: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy662 = setDatabaseOption(pCxt, yymsp[-2].minor.yy662, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 75: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy662 = setDatabaseOption(pCxt, yymsp[-2].minor.yy662, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 76: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy662 = setDatabaseOption(pCxt, yymsp[-2].minor.yy662, DB_OPTION_RETENTIONS, yymsp[0].minor.yy568); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 77: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy662 = createAlterDatabaseOptions(pCxt); yylhsminor.yy662 = setAlterDatabaseOption(pCxt, yylhsminor.yy662, &yymsp[0].minor.yy475); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 78: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy662 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy662, &yymsp[0].minor.yy475); }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 79: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy475.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy475.val = yymsp[0].minor.yy0; }
        break;
      case 80: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy475.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy475.val = yymsp[0].minor.yy0; }
        break;
      case 81: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy475.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy475.val = yymsp[0].minor.yy0; }
        break;
      case 82: /* alter_db_option ::= KEEP integer_list */
      case 83: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==83);
{ yymsp[-1].minor.yy475.type = DB_OPTION_KEEP; yymsp[-1].minor.yy475.pList = yymsp[0].minor.yy568; }
        break;
      case 84: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy475.type = DB_OPTION_PAGES; yymsp[-1].minor.yy475.val = yymsp[0].minor.yy0; }
        break;
      case 85: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy475.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy475.val = yymsp[0].minor.yy0; }
        break;
      case 86: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy475.type = DB_OPTION_STRICT; yymsp[-1].minor.yy475.val = yymsp[0].minor.yy0; }
        break;
      case 87: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy475.type = DB_OPTION_WAL; yymsp[-1].minor.yy475.val = yymsp[0].minor.yy0; }
        break;
      case 88: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy568 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy568 = yylhsminor.yy568;
        break;
      case 89: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 249: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==249);
{ yylhsminor.yy568 = addNodeToList(pCxt, yymsp[-2].minor.yy568, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy568 = yylhsminor.yy568;
        break;
      case 90: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy568 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy568 = yylhsminor.yy568;
        break;
      case 91: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy568 = addNodeToList(pCxt, yymsp[-2].minor.yy568, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy568 = yylhsminor.yy568;
        break;
      case 92: /* retention_list ::= retention */
      case 112: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==112);
      case 115: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==115);
      case 122: /* column_def_list ::= column_def */ yytestcase(yyruleno==122);
      case 163: /* col_name_list ::= col_name */ yytestcase(yyruleno==163);
      case 200: /* func_name_list ::= func_name */ yytestcase(yyruleno==200);
      case 209: /* func_list ::= func */ yytestcase(yyruleno==209);
      case 274: /* literal_list ::= signed_literal */ yytestcase(yyruleno==274);
      case 326: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==326);
      case 381: /* select_sublist ::= select_item */ yytestcase(yyruleno==381);
      case 429: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==429);
{ yylhsminor.yy568 = createNodeList(pCxt, yymsp[0].minor.yy662); }
  yymsp[0].minor.yy568 = yylhsminor.yy568;
        break;
      case 93: /* retention_list ::= retention_list NK_COMMA retention */
      case 123: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==123);
      case 164: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==164);
      case 201: /* func_name_list ::= func_name_list NK_COMMA func_name */ yytestcase(yyruleno==201);
      case 210: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==210);
      case 275: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==275);
      case 327: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==327);
      case 382: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==382);
      case 430: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==430);
{ yylhsminor.yy568 = addNodeToList(pCxt, yymsp[-2].minor.yy568, yymsp[0].minor.yy662); }
  yymsp[-2].minor.yy568 = yylhsminor.yy568;
        break;
      case 94: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy662 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 95: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 97: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==97);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy617, yymsp[-5].minor.yy662, yymsp[-3].minor.yy568, yymsp[-1].minor.yy568, yymsp[0].minor.yy662); }
        break;
      case 96: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy568); }
        break;
      case 98: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy568); }
        break;
      case 99: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy617, yymsp[0].minor.yy662); }
        break;
      case 100: /* cmd ::= ALTER TABLE alter_table_clause */
      case 101: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==101);
      case 251: /* cmd ::= query_expression */ yytestcase(yyruleno==251);
{ pCxt->pRootNode = yymsp[0].minor.yy662; }
        break;
      case 102: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy662 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy662, yymsp[0].minor.yy662); }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 103: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy662 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy662, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy555, yymsp[0].minor.yy156); }
  yymsp[-4].minor.yy662 = yylhsminor.yy662;
        break;
      case 104: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy662 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy662, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy555); }
  yymsp[-3].minor.yy662 = yylhsminor.yy662;
        break;
      case 105: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy662 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy662, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy555, yymsp[0].minor.yy156); }
  yymsp[-4].minor.yy662 = yylhsminor.yy662;
        break;
      case 106: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy662 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy662, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy555, &yymsp[0].minor.yy555); }
  yymsp[-4].minor.yy662 = yylhsminor.yy662;
        break;
      case 107: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy662 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy662, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy555, yymsp[0].minor.yy156); }
  yymsp[-4].minor.yy662 = yylhsminor.yy662;
        break;
      case 108: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy662 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy662, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy555); }
  yymsp[-3].minor.yy662 = yylhsminor.yy662;
        break;
      case 109: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy662 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy662, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy555, yymsp[0].minor.yy156); }
  yymsp[-4].minor.yy662 = yylhsminor.yy662;
        break;
      case 110: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy662 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy662, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy555, &yymsp[0].minor.yy555); }
  yymsp[-4].minor.yy662 = yylhsminor.yy662;
        break;
      case 111: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
{ yylhsminor.yy662 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy662, &yymsp[-2].minor.yy555, yymsp[0].minor.yy662); }
  yymsp[-5].minor.yy662 = yylhsminor.yy662;
        break;
      case 113: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 116: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==116);
{ yylhsminor.yy568 = addNodeToList(pCxt, yymsp[-1].minor.yy568, yymsp[0].minor.yy662); }
  yymsp[-1].minor.yy568 = yylhsminor.yy568;
        break;
      case 114: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
{ yylhsminor.yy662 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy617, yymsp[-8].minor.yy662, yymsp[-6].minor.yy662, yymsp[-5].minor.yy568, yymsp[-2].minor.yy568, yymsp[0].minor.yy662); }
  yymsp[-9].minor.yy662 = yylhsminor.yy662;
        break;
      case 117: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy662 = createDropTableClause(pCxt, yymsp[-1].minor.yy617, yymsp[0].minor.yy662); }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 118: /* specific_tags_opt ::= */
      case 149: /* tags_def_opt ::= */ yytestcase(yyruleno==149);
      case 389: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==389);
      case 406: /* group_by_clause_opt ::= */ yytestcase(yyruleno==406);
      case 417: /* order_by_clause_opt ::= */ yytestcase(yyruleno==417);
{ yymsp[1].minor.yy568 = NULL; }
        break;
      case 119: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy568 = yymsp[-1].minor.yy568; }
        break;
      case 120: /* full_table_name ::= table_name */
{ yylhsminor.yy662 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy555, NULL); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 121: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy662 = createRealTableNode(pCxt, &yymsp[-2].minor.yy555, &yymsp[0].minor.yy555, NULL); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 124: /* column_def ::= column_name type_name */
{ yylhsminor.yy662 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy555, yymsp[0].minor.yy156, NULL); }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 125: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy662 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy555, yymsp[-2].minor.yy156, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy662 = yylhsminor.yy662;
        break;
      case 126: /* type_name ::= BOOL */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 127: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 128: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 129: /* type_name ::= INT */
      case 130: /* type_name ::= INTEGER */ yytestcase(yyruleno==130);
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 131: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 132: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 133: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 134: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy156 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 135: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 136: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy156 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 137: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy156 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 138: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy156 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 139: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy156 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 140: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy156 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 141: /* type_name ::= JSON */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 142: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy156 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 143: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 144: /* type_name ::= BLOB */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 145: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy156 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 146: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy156 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 147: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy156 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 148: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy156 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 150: /* tags_def_opt ::= tags_def */
      case 325: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==325);
      case 380: /* select_list ::= select_sublist */ yytestcase(yyruleno==380);
{ yylhsminor.yy568 = yymsp[0].minor.yy568; }
  yymsp[0].minor.yy568 = yylhsminor.yy568;
        break;
      case 151: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy568 = yymsp[-1].minor.yy568; }
        break;
      case 152: /* table_options ::= */
{ yymsp[1].minor.yy662 = createDefaultTableOptions(pCxt); }
        break;
      case 153: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy662 = setTableOption(pCxt, yymsp[-2].minor.yy662, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 154: /* table_options ::= table_options DELAY NK_INTEGER */
{ yylhsminor.yy662 = setTableOption(pCxt, yymsp[-2].minor.yy662, TABLE_OPTION_DELAY, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 155: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ yylhsminor.yy662 = setTableOption(pCxt, yymsp[-2].minor.yy662, TABLE_OPTION_FILE_FACTOR, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 156: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ yylhsminor.yy662 = setTableOption(pCxt, yymsp[-4].minor.yy662, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy568); }
  yymsp[-4].minor.yy662 = yylhsminor.yy662;
        break;
      case 157: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy662 = setTableOption(pCxt, yymsp[-2].minor.yy662, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 158: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy662 = setTableOption(pCxt, yymsp[-4].minor.yy662, TABLE_OPTION_SMA, yymsp[-1].minor.yy568); }
  yymsp[-4].minor.yy662 = yylhsminor.yy662;
        break;
      case 159: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy662 = createAlterTableOptions(pCxt); yylhsminor.yy662 = setTableOption(pCxt, yylhsminor.yy662, yymsp[0].minor.yy475.type, &yymsp[0].minor.yy475.val); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 160: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy662 = setTableOption(pCxt, yymsp[-1].minor.yy662, yymsp[0].minor.yy475.type, &yymsp[0].minor.yy475.val); }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 161: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy475.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy475.val = yymsp[0].minor.yy0; }
        break;
      case 162: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy475.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy475.val = yymsp[0].minor.yy0; }
        break;
      case 165: /* col_name ::= column_name */
{ yylhsminor.yy662 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy555); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 166: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 167: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 168: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 169: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy662, yymsp[0].minor.yy662); }
        break;
      case 170: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy662, yymsp[0].minor.yy662); }
        break;
      case 171: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy662, NULL); }
        break;
      case 172: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 173: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 174: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 175: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 176: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy662, yymsp[0].minor.yy662); }
        break;
      case 177: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 178: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 179: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 180: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 181: /* cmd ::= SHOW LICENCE */
      case 182: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==182);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 183: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy555); }
        break;
      case 184: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy662); }
        break;
      case 185: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy662); }
        break;
      case 186: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 187: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 188: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 189: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 190: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT, NULL, NULL); }
        break;
      case 191: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT, NULL, NULL); }
        break;
      case 192: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT, NULL, NULL); }
        break;
      case 193: /* db_name_cond_opt ::= */
      case 198: /* from_db_opt ::= */ yytestcase(yyruleno==198);
{ yymsp[1].minor.yy662 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 194: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy555); }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 195: /* like_pattern_opt ::= */
      case 206: /* index_options ::= */ yytestcase(yyruleno==206);
      case 237: /* into_opt ::= */ yytestcase(yyruleno==237);
      case 387: /* where_clause_opt ::= */ yytestcase(yyruleno==387);
      case 391: /* twindow_clause_opt ::= */ yytestcase(yyruleno==391);
      case 396: /* sliding_opt ::= */ yytestcase(yyruleno==396);
      case 398: /* fill_opt ::= */ yytestcase(yyruleno==398);
      case 410: /* having_clause_opt ::= */ yytestcase(yyruleno==410);
      case 419: /* slimit_clause_opt ::= */ yytestcase(yyruleno==419);
      case 423: /* limit_clause_opt ::= */ yytestcase(yyruleno==423);
{ yymsp[1].minor.yy662 = NULL; }
        break;
      case 196: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 197: /* table_name_cond ::= table_name */
{ yylhsminor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy555); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 199: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy555); }
        break;
      case 202: /* func_name ::= function_name */
{ yylhsminor.yy662 = createFunctionNode(pCxt, &yymsp[0].minor.yy555, NULL); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 203: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy617, &yymsp[-3].minor.yy555, &yymsp[-1].minor.yy555, NULL, yymsp[0].minor.yy662); }
        break;
      case 204: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy617, &yymsp[-5].minor.yy555, &yymsp[-3].minor.yy555, yymsp[-1].minor.yy568, NULL); }
        break;
      case 205: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy617, &yymsp[-2].minor.yy555, &yymsp[0].minor.yy555); }
        break;
      case 207: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy662 = createIndexOption(pCxt, yymsp[-6].minor.yy568, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), NULL, yymsp[0].minor.yy662); }
        break;
      case 208: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy662 = createIndexOption(pCxt, yymsp[-8].minor.yy568, releaseRawExprNode(pCxt, yymsp[-4].minor.yy662), releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), yymsp[0].minor.yy662); }
        break;
      case 211: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy662 = createFunctionNode(pCxt, &yymsp[-3].minor.yy555, yymsp[-1].minor.yy568); }
  yymsp[-3].minor.yy662 = yylhsminor.yy662;
        break;
      case 212: /* cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy617, &yymsp[-3].minor.yy555, yymsp[0].minor.yy662, NULL, yymsp[-2].minor.yy662); }
        break;
      case 213: /* cmd ::= CREATE TOPIC not_exists_opt topic_name topic_options AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy617, &yymsp[-3].minor.yy555, NULL, &yymsp[0].minor.yy555, yymsp[-2].minor.yy662); }
        break;
      case 214: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy617, &yymsp[0].minor.yy555); }
        break;
      case 215: /* topic_options ::= */
{ yymsp[1].minor.yy662 = createTopicOptions(pCxt); }
        break;
      case 216: /* topic_options ::= topic_options WITH TABLE */
{ ((STopicOptions*)yymsp[-2].minor.yy662)->withTable = true; yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 217: /* topic_options ::= topic_options WITH SCHEMA */
{ ((STopicOptions*)yymsp[-2].minor.yy662)->withSchema = true; yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 218: /* topic_options ::= topic_options WITH TAG */
{ ((STopicOptions*)yymsp[-2].minor.yy662)->withTag = true; yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 219: /* cmd ::= DESC full_table_name */
      case 220: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==220);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy662); }
        break;
      case 221: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 222: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy617, yymsp[-1].minor.yy662, yymsp[0].minor.yy662); }
        break;
      case 224: /* analyze_opt ::= ANALYZE */
      case 232: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==232);
      case 377: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==377);
{ yymsp[0].minor.yy617 = true; }
        break;
      case 225: /* explain_options ::= */
{ yymsp[1].minor.yy662 = createDefaultExplainOptions(pCxt); }
        break;
      case 226: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy662 = setExplainVerbose(pCxt, yymsp[-2].minor.yy662, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 227: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy662 = setExplainRatio(pCxt, yymsp[-2].minor.yy662, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 228: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy568); }
        break;
      case 229: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy617, yymsp[-8].minor.yy617, &yymsp[-5].minor.yy555, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy156, yymsp[0].minor.yy610); }
        break;
      case 230: /* cmd ::= DROP FUNCTION function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, &yymsp[0].minor.yy555); }
        break;
      case 233: /* bufsize_opt ::= */
{ yymsp[1].minor.yy610 = 0; }
        break;
      case 234: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy610 = strtol(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 235: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy617, &yymsp[-4].minor.yy555, yymsp[-2].minor.yy662, yymsp[-3].minor.yy662, yymsp[0].minor.yy662); }
        break;
      case 236: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy617, &yymsp[0].minor.yy555); }
        break;
      case 238: /* into_opt ::= INTO full_table_name */
      case 358: /* from_clause ::= FROM table_reference_list */ yytestcase(yyruleno==358);
      case 388: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==388);
      case 411: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==411);
{ yymsp[-1].minor.yy662 = yymsp[0].minor.yy662; }
        break;
      case 239: /* stream_options ::= */
{ yymsp[1].minor.yy662 = createStreamOptions(pCxt); }
        break;
      case 240: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy662)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 241: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy662)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 242: /* stream_options ::= stream_options WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy662)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy662); yylhsminor.yy662 = yymsp[-2].minor.yy662; }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 243: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 244: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 245: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 246: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy568); }
        break;
      case 247: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 248: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy568 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 250: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy555); }
        break;
      case 252: /* literal ::= NK_INTEGER */
{ yylhsminor.yy662 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 253: /* literal ::= NK_FLOAT */
{ yylhsminor.yy662 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 254: /* literal ::= NK_STRING */
{ yylhsminor.yy662 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 255: /* literal ::= NK_BOOL */
{ yylhsminor.yy662 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 256: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 257: /* literal ::= duration_literal */
      case 267: /* signed_literal ::= signed */ yytestcase(yyruleno==267);
      case 286: /* expression ::= literal */ yytestcase(yyruleno==286);
      case 287: /* expression ::= pseudo_column */ yytestcase(yyruleno==287);
      case 288: /* expression ::= column_reference */ yytestcase(yyruleno==288);
      case 289: /* expression ::= function_expression */ yytestcase(yyruleno==289);
      case 290: /* expression ::= subquery */ yytestcase(yyruleno==290);
      case 314: /* function_expression ::= literal_func */ yytestcase(yyruleno==314);
      case 350: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==350);
      case 354: /* boolean_primary ::= predicate */ yytestcase(yyruleno==354);
      case 356: /* common_expression ::= expression */ yytestcase(yyruleno==356);
      case 357: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==357);
      case 359: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==359);
      case 361: /* table_reference ::= table_primary */ yytestcase(yyruleno==361);
      case 362: /* table_reference ::= joined_table */ yytestcase(yyruleno==362);
      case 366: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==366);
      case 413: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==413);
      case 416: /* query_primary ::= query_specification */ yytestcase(yyruleno==416);
{ yylhsminor.yy662 = yymsp[0].minor.yy662; }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 258: /* literal ::= NULL */
{ yylhsminor.yy662 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 259: /* literal ::= NK_QUESTION */
{ yylhsminor.yy662 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 260: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy662 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 261: /* signed ::= NK_INTEGER */
{ yylhsminor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 262: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 263: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 264: /* signed ::= NK_FLOAT */
{ yylhsminor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 265: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 266: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 268: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 269: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 270: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 271: /* signed_literal ::= duration_literal */
      case 273: /* signed_literal ::= literal_func */ yytestcase(yyruleno==273);
      case 328: /* star_func_para ::= expression */ yytestcase(yyruleno==328);
      case 383: /* select_item ::= common_expression */ yytestcase(yyruleno==383);
      case 428: /* search_condition ::= common_expression */ yytestcase(yyruleno==428);
{ yylhsminor.yy662 = releaseRawExprNode(pCxt, yymsp[0].minor.yy662); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 272: /* signed_literal ::= NULL */
{ yymsp[0].minor.yy662 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL); }
        break;
      case 291: /* expression ::= NK_LP expression NK_RP */
      case 355: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==355);
{ yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy662)); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 292: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy662));
                                                                                  }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 293: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy662), NULL));
                                                                                  }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 294: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy662);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), releaseRawExprNode(pCxt, yymsp[0].minor.yy662))); 
                                                                                  }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 295: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy662);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), releaseRawExprNode(pCxt, yymsp[0].minor.yy662))); 
                                                                                  }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 296: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy662);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), releaseRawExprNode(pCxt, yymsp[0].minor.yy662))); 
                                                                                  }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 297: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy662);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), releaseRawExprNode(pCxt, yymsp[0].minor.yy662))); 
                                                                                  }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 298: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy662);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), releaseRawExprNode(pCxt, yymsp[0].minor.yy662))); 
                                                                                  }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 299: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 300: /* expression_list ::= expression */
{ yylhsminor.yy568 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy662)); }
  yymsp[0].minor.yy568 = yylhsminor.yy568;
        break;
      case 301: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy568 = addNodeToList(pCxt, yymsp[-2].minor.yy568, releaseRawExprNode(pCxt, yymsp[0].minor.yy662)); }
  yymsp[-2].minor.yy568 = yylhsminor.yy568;
        break;
      case 302: /* column_reference ::= column_name */
{ yylhsminor.yy662 = createRawExprNode(pCxt, &yymsp[0].minor.yy555, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy555)); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 303: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy555, &yymsp[0].minor.yy555, createColumnNode(pCxt, &yymsp[-2].minor.yy555, &yymsp[0].minor.yy555)); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 304: /* pseudo_column ::= ROWTS */
      case 305: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==305);
      case 306: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==306);
      case 307: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==307);
      case 308: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==308);
      case 309: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==309);
      case 310: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==310);
      case 316: /* literal_func ::= NOW */ yytestcase(yyruleno==316);
{ yylhsminor.yy662 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy662 = yylhsminor.yy662;
        break;
      case 311: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 312: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==312);
{ yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy555, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy555, yymsp[-1].minor.yy568)); }
  yymsp[-3].minor.yy662 = yylhsminor.yy662;
        break;
      case 313: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy662), yymsp[-1].minor.yy156)); }
  yymsp[-5].minor.yy662 = yylhsminor.yy662;
        break;
      case 315: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy555, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy555, NULL)); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 324: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy568 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy568 = yylhsminor.yy568;
        break;
      case 329: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 386: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==386);
{ yylhsminor.yy662 = createColumnNode(pCxt, &yymsp[-2].minor.yy555, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 330: /* predicate ::= expression compare_op expression */
      case 335: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==335);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy662);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy304, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), releaseRawExprNode(pCxt, yymsp[0].minor.yy662)));
                                                                                  }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 331: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy662);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy662), releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), releaseRawExprNode(pCxt, yymsp[0].minor.yy662)));
                                                                                  }
  yymsp[-4].minor.yy662 = yylhsminor.yy662;
        break;
      case 332: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy662);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy662), releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), releaseRawExprNode(pCxt, yymsp[0].minor.yy662)));
                                                                                  }
  yymsp[-5].minor.yy662 = yylhsminor.yy662;
        break;
      case 333: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), NULL));
                                                                                  }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 334: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy662), NULL));
                                                                                  }
  yymsp[-3].minor.yy662 = yylhsminor.yy662;
        break;
      case 336: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy304 = OP_TYPE_LOWER_THAN; }
        break;
      case 337: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy304 = OP_TYPE_GREATER_THAN; }
        break;
      case 338: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy304 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 339: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy304 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 340: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy304 = OP_TYPE_NOT_EQUAL; }
        break;
      case 341: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy304 = OP_TYPE_EQUAL; }
        break;
      case 342: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy304 = OP_TYPE_LIKE; }
        break;
      case 343: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy304 = OP_TYPE_NOT_LIKE; }
        break;
      case 344: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy304 = OP_TYPE_MATCH; }
        break;
      case 345: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy304 = OP_TYPE_NMATCH; }
        break;
      case 346: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy304 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 347: /* in_op ::= IN */
{ yymsp[0].minor.yy304 = OP_TYPE_IN; }
        break;
      case 348: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy304 = OP_TYPE_NOT_IN; }
        break;
      case 349: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy568)); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 351: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy662), NULL));
                                                                                  }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 352: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy662);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), releaseRawExprNode(pCxt, yymsp[0].minor.yy662)));
                                                                                  }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 353: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy662);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy662);
                                                                                    yylhsminor.yy662 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), releaseRawExprNode(pCxt, yymsp[0].minor.yy662)));
                                                                                  }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 360: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy662 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy662, yymsp[0].minor.yy662, NULL); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 363: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy662 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy555, &yymsp[0].minor.yy555); }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 364: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy662 = createRealTableNode(pCxt, &yymsp[-3].minor.yy555, &yymsp[-1].minor.yy555, &yymsp[0].minor.yy555); }
  yymsp[-3].minor.yy662 = yylhsminor.yy662;
        break;
      case 365: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy662 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy662), &yymsp[0].minor.yy555); }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 367: /* alias_opt ::= */
{ yymsp[1].minor.yy555 = nil_token;  }
        break;
      case 368: /* alias_opt ::= table_alias */
{ yylhsminor.yy555 = yymsp[0].minor.yy555; }
  yymsp[0].minor.yy555 = yylhsminor.yy555;
        break;
      case 369: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy555 = yymsp[0].minor.yy555; }
        break;
      case 370: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 371: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==371);
{ yymsp[-2].minor.yy662 = yymsp[-1].minor.yy662; }
        break;
      case 372: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy662 = createJoinTableNode(pCxt, yymsp[-4].minor.yy84, yymsp[-5].minor.yy662, yymsp[-2].minor.yy662, yymsp[0].minor.yy662); }
  yymsp[-5].minor.yy662 = yylhsminor.yy662;
        break;
      case 373: /* join_type ::= */
{ yymsp[1].minor.yy84 = JOIN_TYPE_INNER; }
        break;
      case 374: /* join_type ::= INNER */
{ yymsp[0].minor.yy84 = JOIN_TYPE_INNER; }
        break;
      case 375: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy662 = createSelectStmt(pCxt, yymsp[-7].minor.yy617, yymsp[-6].minor.yy568, yymsp[-5].minor.yy662);
                                                                                    yymsp[-8].minor.yy662 = addWhereClause(pCxt, yymsp[-8].minor.yy662, yymsp[-4].minor.yy662);
                                                                                    yymsp[-8].minor.yy662 = addPartitionByClause(pCxt, yymsp[-8].minor.yy662, yymsp[-3].minor.yy568);
                                                                                    yymsp[-8].minor.yy662 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy662, yymsp[-2].minor.yy662);
                                                                                    yymsp[-8].minor.yy662 = addGroupByClause(pCxt, yymsp[-8].minor.yy662, yymsp[-1].minor.yy568);
                                                                                    yymsp[-8].minor.yy662 = addHavingClause(pCxt, yymsp[-8].minor.yy662, yymsp[0].minor.yy662);
                                                                                  }
        break;
      case 378: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy617 = false; }
        break;
      case 379: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy568 = NULL; }
        break;
      case 384: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy662 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy662), &yymsp[0].minor.yy555); }
  yymsp[-1].minor.yy662 = yylhsminor.yy662;
        break;
      case 385: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy662 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), &yymsp[0].minor.yy555); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 390: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 407: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==407);
      case 418: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==418);
{ yymsp[-2].minor.yy568 = yymsp[0].minor.yy568; }
        break;
      case 392: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy662 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy662), releaseRawExprNode(pCxt, yymsp[-1].minor.yy662)); }
        break;
      case 393: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy662 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy662)); }
        break;
      case 394: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy662 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy662), NULL, yymsp[-1].minor.yy662, yymsp[0].minor.yy662); }
        break;
      case 395: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy662 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy662), releaseRawExprNode(pCxt, yymsp[-3].minor.yy662), yymsp[-1].minor.yy662, yymsp[0].minor.yy662); }
        break;
      case 397: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy662 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy662); }
        break;
      case 399: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy662 = createFillNode(pCxt, yymsp[-1].minor.yy284, NULL); }
        break;
      case 400: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy662 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy568)); }
        break;
      case 401: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy284 = FILL_MODE_NONE; }
        break;
      case 402: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy284 = FILL_MODE_PREV; }
        break;
      case 403: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy284 = FILL_MODE_NULL; }
        break;
      case 404: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy284 = FILL_MODE_LINEAR; }
        break;
      case 405: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy284 = FILL_MODE_NEXT; }
        break;
      case 408: /* group_by_list ::= expression */
{ yylhsminor.yy568 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy662))); }
  yymsp[0].minor.yy568 = yylhsminor.yy568;
        break;
      case 409: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy568 = addNodeToList(pCxt, yymsp[-2].minor.yy568, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy662))); }
  yymsp[-2].minor.yy568 = yylhsminor.yy568;
        break;
      case 412: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy662 = addOrderByClause(pCxt, yymsp[-3].minor.yy662, yymsp[-2].minor.yy568);
                                                                                    yylhsminor.yy662 = addSlimitClause(pCxt, yylhsminor.yy662, yymsp[-1].minor.yy662);
                                                                                    yylhsminor.yy662 = addLimitClause(pCxt, yylhsminor.yy662, yymsp[0].minor.yy662);
                                                                                  }
  yymsp[-3].minor.yy662 = yylhsminor.yy662;
        break;
      case 414: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy662 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy662, yymsp[0].minor.yy662); }
  yymsp[-3].minor.yy662 = yylhsminor.yy662;
        break;
      case 415: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy662 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy662, yymsp[0].minor.yy662); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 420: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 424: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==424);
{ yymsp[-1].minor.yy662 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 421: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 425: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==425);
{ yymsp[-3].minor.yy662 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 422: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 426: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==426);
{ yymsp[-3].minor.yy662 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 427: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy662 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy662); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 431: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy662 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy662), yymsp[-1].minor.yy272, yymsp[0].minor.yy181); }
  yymsp[-2].minor.yy662 = yylhsminor.yy662;
        break;
      case 432: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy272 = ORDER_ASC; }
        break;
      case 433: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy272 = ORDER_ASC; }
        break;
      case 434: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy272 = ORDER_DESC; }
        break;
      case 435: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy181 = NULL_ORDER_DEFAULT; }
        break;
      case 436: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy181 = NULL_ORDER_FIRST; }
        break;
      case 437: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy181 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (pCxt->valid) {
    if(TOKEN.z) {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
    pCxt->valid = false;
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
