/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 429
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  int32_t yy46;
  SNode* yy80;
  int64_t yy129;
  SDataType yy136;
  EOperatorType yy194;
  SToken yy239;
  SAlterOption yy299;
  EOrder yy422;
  EFillMode yy426;
  int8_t yy509;
  SNodeList* yy574;
  EJoinType yy750;
  ENullOrder yy763;
  bool yy845;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             674
#define YYNRULE              495
#define YYNTOKEN             308
#define YY_MAX_SHIFT         673
#define YY_MIN_SHIFTREDUCE   983
#define YY_MAX_SHIFTREDUCE   1477
#define YY_ERROR_ACTION      1478
#define YY_ACCEPT_ACTION     1479
#define YY_NO_ACTION         1480
#define YY_MIN_REDUCE        1481
#define YY_MAX_REDUCE        1975
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2464)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   436,  379,  437, 1516, 1809,   91,  516,  444, 1616,  437,
 /*    10 */  1516, 1614,   39,   37,  553,   64,   30,  260,  124, 1793,
 /*    20 */   340, 1953, 1278,   33,   32, 1016, 1617,   40,   38,   36,
 /*    30 */    35,   34, 1827, 1354, 1952, 1276,  385,  148, 1950, 1493,
 /*    40 */   582, 1953,  127, 1789, 1795, 1779, 1953,  581,   40,   38,
 /*    50 */    36,   35,   34,  556,  164,  575, 1349,  517, 1950,  164,
 /*    60 */   558,   14,  558, 1950,  326, 1020, 1021, 1725, 1284, 1543,
 /*    70 */  1841, 1304,   74,  303,   94, 1810,  584, 1812, 1813,  580,
 /*    80 */   125,  575, 1504,  173, 1887,  122,  217,  345,  306, 1883,
 /*    90 */  1670, 1672,    1,  556, 1620,  250, 1895,  552,   63,  551,
 /*   100 */  1953,  107, 1953,   63,  106,  105,  104,  103,  102,  101,
 /*   110 */   100,   99,   98,  166,  670,  166,  453, 1950,   71, 1950,
 /*   120 */  1421,   70,   63, 1779,   78,   42, 1303, 1303, 1356, 1357,
 /*   130 */    11,   10,  647,  646,  645,  644,  350, 1503,  643,  642,
 /*   140 */   128,  637,  636,  635,  634,  633,  632,  631,  139,  627,
 /*   150 */   626,  625,  349,  348,  622,  621,  620,  619,  618,  530,
 /*   160 */   500,   33,   32,  196, 1481,   40,   38,   36,   35,   34,
 /*   170 */    55,  223,  224,  498, 1279,  496, 1277,  152, 1779, 1175,
 /*   180 */  1176, 1474,  470,  466,  462,  458,  195, 1625,  116,  115,
 /*   190 */   114,  113,  112,  111,  110,  109,  108, 1282, 1283,   63,
 /*   200 */  1331, 1332, 1334, 1335, 1336, 1337, 1338, 1339,  577,  573,
 /*   210 */  1347, 1348, 1350, 1351, 1352, 1353, 1355, 1358,   39,   37,
 /*   220 */  1417,   75, 1390,  302,  193, 1301,  340,   84, 1278, 1809,
 /*   230 */   305,  167,  415,  520, 1953,  427,  353,  167,  530, 1354,
 /*   240 */   542, 1276,  167, 1677, 1798,  553, 1448,  165, 1618,  169,
 /*   250 */   328, 1950,  400, 1677,  428, 1793,  402, 1827, 1953, 1675,
 /*   260 */   344,  167, 1349, 1304,  167,  582, 1625,   14, 1473, 1675,
 /*   270 */  1779, 1951,  581,  127, 1284, 1950, 1953,   33,   32, 1789,
 /*   280 */  1795,   40,   38,   36,   35,   34, 1797,  192,  186,  164,
 /*   290 */   191,  575,   49, 1950,  449, 1841,  393, 1793,    2,   95,
 /*   300 */  1810,  584, 1812, 1813,  580, 1303,  575, 1333,  389, 1887,
 /*   310 */   184,  125,   22,  331, 1883, 1966,  556,  548,  543,  158,
 /*   320 */   670, 1789, 1795,  329, 1921,  555,  160, 1895, 1896, 1724,
 /*   330 */  1900,  300, 1664,  575, 1356, 1357,  426, 1479,  167,  421,
 /*   340 */   420,  419,  418,  417,  414,  413,  412,  411,  410,  406,
 /*   350 */   405,  404,  403,  397,  396,  395,  394, 1522,  391,  390,
 /*   360 */   314, 1902, 1133,  606,  605,  604, 1137,  603, 1139, 1140,
 /*   370 */   602, 1142,  599,  530, 1148,  596, 1150, 1151,  593,  590,
 /*   380 */  1279,  327, 1277,  317,  383, 1899,   33,   32,   43,  146,
 /*   390 */    40,   38,   36,   35,   34,  150,  355,  547, 1627, 1584,
 /*   400 */  1033, 1625, 1032, 1282, 1283,  665, 1331, 1332, 1334, 1335,
 /*   410 */  1336, 1337, 1338, 1339,  577,  573, 1347, 1348, 1350, 1351,
 /*   420 */  1352, 1353, 1355, 1358,   39,   37, 1809,  491, 1671, 1672,
 /*   430 */  1034,  167,  340, 1723, 1278,  300, 1953, 1302,   36,   35,
 /*   440 */    34,  318,  501,  316,  315, 1354,  476, 1276, 1677,  164,
 /*   450 */   478, 1305,  222, 1950, 1827,  312,  209, 1602,  486,  485,
 /*   460 */  1364, 1603,  582,  617, 1675,  123, 1303, 1779, 1349,  581,
 /*   470 */   494, 1428,  477,   14,  488,  481,  484,   26,  343,  208,
 /*   480 */  1284,  480,  558,   33,   32,  346,  146,   40,   38,   36,
 /*   490 */    35,   34, 1841,  146,    7, 1627,   94, 1810,  584, 1812,
 /*   500 */  1813,  580, 1627,  575,    2,  609, 1887, 1378,  553,  530,
 /*   510 */   306, 1883, 1258, 1259,   58,  435, 1953,   57,  439, 1502,
 /*   520 */   117,  453, 1953,  147, 1827,   63,  670,  474,  278,  165,
 /*   530 */  1809, 1501,  546, 1950,  374,  164,  127, 1625,   28, 1950,
 /*   540 */  1356, 1357,  276,   60,   33,   32,   59, 1284,   40,   38,
 /*   550 */    36,   35,   34,  376,  372,  337,  336, 1500, 1827,  530,
 /*   560 */  1779,  615,  180,  432,  430, 1292,  582, 1728,  545,   27,
 /*   570 */   117, 1779, 1779,  581,  125,  517, 1354,  479, 1285, 1383,
 /*   580 */   137,  136,  612,  611,  610, 1726, 1279, 1625, 1277,  161,
 /*   590 */  1895, 1896,  252, 1900,  629, 1499, 1841,   63, 1779, 1349,
 /*   600 */   149, 1810,  584, 1812, 1813,  580,  378,  575,  377, 1282,
 /*   610 */  1283, 1284, 1331, 1332, 1334, 1335, 1336, 1337, 1338, 1339,
 /*   620 */   577,  573, 1347, 1348, 1350, 1351, 1352, 1353, 1355, 1358,
 /*   630 */    39,   37, 1902, 1278, 1498,   93, 1779, 1497,  340,  630,
 /*   640 */  1278, 1597,  441, 1601,  559, 1967, 1276, 1333, 1301, 1610,
 /*   650 */  1033, 1354, 1032, 1276,   33,   32, 1898,  570,   40,   38,
 /*   660 */    36,   35,   34, 1546,  167,  472,  443,  352, 1612,  439,
 /*   670 */  1496,   68,   67,  382, 1349, 1779,  171, 1608, 1779, 1284,
 /*   680 */  1034,  210, 1495,   33,   32, 1410, 1284,   40,   38,   36,
 /*   690 */    35,   34,  301,  530, 1809,  370,   74,  368,  364,  360,
 /*   700 */   357,  354, 1492,  617,  384, 1020, 1021, 1953,   33,   32,
 /*   710 */     8, 1779,   40,   38,   36,   35,   34, 1293, 1621, 1288,
 /*   720 */   164, 1625, 1827, 1779, 1950,  670,  213,  486,  485, 1491,
 /*   730 */   557, 1490,  670,  502,  123, 1779,  167,  581,   76,  305,
 /*   740 */  1296, 1298,  520, 1779,  481,  484, 1356, 1357, 1489, 1095,
 /*   750 */   480, 1902,  573, 1347, 1348, 1350, 1351, 1352, 1353, 1438,
 /*   760 */  1841,  307, 1907, 1410,   95, 1810,  584, 1812, 1813,  580,
 /*   770 */  1779,  575, 1779, 1953, 1887, 1897,  615, 1718,  331, 1883,
 /*   780 */   159, 1414, 1097,  483,  482, 1279,  164, 1277,  172, 1779,
 /*   790 */  1950,  478, 1279, 1316, 1277,  137,  136,  612,  611,  610,
 /*   800 */  1914, 1376,  539, 1436, 1437, 1439, 1440,  145, 1282, 1283,
 /*   810 */  1488, 1809, 1487,  477, 1486, 1282, 1283, 1306, 1331, 1332,
 /*   820 */  1334, 1335, 1336, 1337, 1338, 1339,  577,  573, 1347, 1348,
 /*   830 */  1350, 1351, 1352, 1353, 1355, 1358,   39,   37, 1359, 1827,
 /*   840 */  1482,  146,  422,  509,  340, 1060, 1278,  582, 1485,  167,
 /*   850 */  1628, 1779, 1779, 1779,  581, 1779, 1377, 1354, 1484, 1276,
 /*   860 */  1677,  107, 1718,   61,  106,  105,  104,  103,  102,  101,
 /*   870 */   100,   99,   98,  175,  641,  639, 1676, 1841, 1061, 1303,
 /*   880 */  1349,   96, 1810,  584, 1812, 1813,  580,  613,  575, 1779,
 /*   890 */  1668, 1887, 1284,   44,    4, 1886, 1883,  177,  176, 1779,
 /*   900 */   614,   33,   32, 1668, 1797,   40,   38,   36,   35,   34,
 /*   910 */   272,  135,  576, 1655, 1809, 1793,    9, 1766,   29,  338,
 /*   920 */  1371, 1372, 1373, 1374, 1375, 1379, 1380, 1381, 1382,   33,
 /*   930 */    32, 1809,  530,   40,   38,   36,   35,   34,  670, 1789,
 /*   940 */  1795,  335, 1827,  392,  562,  530,  608,  324, 1533,  386,
 /*   950 */   582,  575, 1356, 1357,  307, 1779,  407,  581,  232, 1827,
 /*   960 */  1625,   54,  387,  201,  362,  203,  199,  582,  202, 1494,
 /*   970 */   487,  530, 1779, 1625,  581,   53,  513,   11,   10,  530,
 /*   980 */  1841,  216,  408,  565,  294, 1810,  584, 1812, 1813,  580,
 /*   990 */   451,  575,  553,  205, 1376, 1528,  204, 1841, 1279, 1625,
 /*  1000 */  1277,   96, 1810,  584, 1812, 1813,  580, 1625,  575, 1413,
 /*  1010 */   207, 1887,   41,  206, 1316,  569, 1883,  489,  255,   77,
 /*  1020 */   127, 1282, 1283, 1526, 1331, 1332, 1334, 1335, 1336, 1337,
 /*  1030 */  1338, 1339,  577,  573, 1347, 1348, 1350, 1351, 1352, 1353,
 /*  1040 */  1355, 1358,   39,   37,  530,  492,  221, 1585,  530, 1377,
 /*  1050 */   340,  131, 1278,  134,  673,  452,  530, 1287,  125, 1622,
 /*  1060 */  1333,  471, 1229, 1354, 1809, 1276, 1286,  503,  267, 1476,
 /*  1070 */  1477,  540, 1625,  162, 1895, 1896, 1625, 1900,  571, 1800,
 /*  1080 */   623,  135,  156,   51, 1625,   90, 1349,  663,  659,  655,
 /*  1090 */   651,  265, 1827, 1600,  244,   87,  225,  531, 1284,  530,
 /*  1100 */   582,  523, 1079,  229, 1809, 1779,  236,  581,  560, 1828,
 /*  1110 */   510,   29,  338, 1371, 1372, 1373, 1374, 1375, 1379, 1380,
 /*  1120 */  1381, 1382,    9,   41,  624, 1802,   92, 1625,  351,  230,
 /*  1130 */  1841, 1126, 1827, 1435,  294, 1810,  584, 1812, 1813,  580,
 /*  1140 */   557,  575, 1665,   51,  670, 1779, 1077,  581, 1517,   41,
 /*  1150 */   588,  563,  530, 1917,  530,  530,  239,  530, 1356, 1357,
 /*  1160 */   554,  134,  527,  514,  249,  227,  526,  254,  528,  257,
 /*  1170 */  1841,  135,  259,  271,   95, 1810,  584, 1812, 1813,  580,
 /*  1180 */  1625,  575, 1625, 1625, 1887, 1625,    3,    5,  331, 1883,
 /*  1190 */   159,  356,  566, 1384,  361,  219,  313,  615, 1290, 1340,
 /*  1200 */  1154,  530,  163,  119, 1279,  134, 1277, 1289, 1245,  174,
 /*  1210 */  1913, 1158,  529, 1252, 1368,  212,  137,  136,  612,  611,
 /*  1220 */   610, 1165,  268,  388, 1301,  409, 1720, 1282, 1283, 1625,
 /*  1230 */  1331, 1332, 1334, 1335, 1336, 1337, 1338, 1339,  577,  573,
 /*  1240 */  1347, 1348, 1350, 1351, 1352, 1353, 1355, 1358,   39,   37,
 /*  1250 */  1809,  530,  530, 1163,  416,  138,  340,  424, 1278,  423,
 /*  1260 */   425,  429,  261,  347,  431,  433, 1307, 1309,  434, 1354,
 /*  1270 */   442, 1276,  445,  183,  446,  185, 1308,  447, 1827, 1625,
 /*  1280 */  1625, 1310,  188,  448,  450,  190,  582,   72,   73,  454,
 /*  1290 */   194, 1779, 1349,  581,  473,  475,  118, 1615,  304,  198,
 /*  1300 */  1611, 1759,  200,  269, 1284,  140,  504,  141,  211,  505,
 /*  1310 */  1809, 1613, 1609,  142,  143,  214, 1841,  511,  218,  515,
 /*  1320 */    95, 1810,  584, 1812, 1813,  580,  553,  575,    2,  538,
 /*  1330 */  1887,  524,  508,   81,  331, 1883, 1966,  323, 1827,   83,
 /*  1340 */   518,  132, 1758, 1730,  521, 1944,  582, 1306,  133,  525,
 /*  1350 */   670, 1779, 1626,  581,  127,  270,  325, 1928,  534,  541,
 /*  1360 */  1918,  536,    6,  234, 1356, 1357,  537,  330,  544, 1909,
 /*  1370 */   550,  535,  533,  238,  558,  532, 1841, 1305, 1410,  126,
 /*  1380 */    95, 1810,  584, 1812, 1813,  580,  567,  575,  564,   48,
 /*  1390 */  1887,  332,  125,  246,  331, 1883, 1966, 1927,  243,  248,
 /*  1400 */  1903,   85,  586, 1669, 1598, 1906,  247,  250, 1895,  552,
 /*  1410 */  1279,  551, 1277, 1868, 1953,  153,  273,  264,  666,  667,
 /*  1420 */    52,  669,  299,  286,  275,  245, 1809,  164,  296, 1773,
 /*  1430 */   277, 1950,  295, 1282, 1283,   65, 1331, 1332, 1334, 1335,
 /*  1440 */  1336, 1337, 1338, 1339,  577,  573, 1347, 1348, 1350, 1351,
 /*  1450 */  1352, 1353, 1355, 1358, 1827, 1969, 1772, 1949, 1771,  253,
 /*  1460 */  1770,  256,  582,   66,  561,  568,  258, 1779, 1767,  581,
 /*  1470 */   359,  358, 1270, 1271,  170,  363, 1765,  365,  366,  367,
 /*  1480 */  1764,  369,  558, 1763,  371, 1762,  373, 1809, 1761,  375,
 /*  1490 */  1248, 1741, 1841, 1247, 1740,  380,  285, 1810,  584, 1812,
 /*  1500 */  1813,  580,  381,  575, 1739, 1738, 1713, 1217, 1712, 1711,
 /*  1510 */  1710,  129, 1709, 1708,   69, 1827, 1707, 1706, 1705, 1704,
 /*  1520 */  1703,  398, 1953,  582,  399, 1702,  401, 1701, 1779, 1700,
 /*  1530 */   581, 1699, 1698, 1697, 1696,  166, 1695, 1694, 1693, 1950,
 /*  1540 */  1692, 1691, 1690,  558, 1809, 1689, 1688, 1687, 1686,  130,
 /*  1550 */  1685, 1684, 1683, 1841,  178, 1547,  179,  285, 1810,  584,
 /*  1560 */  1812, 1813,  580, 1682,  575, 1219, 1681, 1680, 1679, 1678,
 /*  1570 */  1809, 1548, 1827, 1545, 1513, 1023,  438,  181,  120, 1022,
 /*  1580 */   579, 1512, 1754, 1953, 1748, 1779, 1737,  581,  189, 1736,
 /*  1590 */  1722, 1604,  157, 1544, 1542,  121,  164,  182, 1827,  440,
 /*  1600 */  1950,  187, 1540, 1538, 1536,  455,  582,  456, 1525, 1524,
 /*  1610 */  1841, 1779,  459,  581,  293, 1810,  584, 1812, 1813,  580,
 /*  1620 */   578,  575,  572, 1859,  457,  460, 1053,  461, 1809, 1509,
 /*  1630 */   463,  465,  467, 1606,  464,  469, 1841, 1168, 1605,   97,
 /*  1640 */    96, 1810,  584, 1812, 1813,  580, 1809,  575,  468, 1169,
 /*  1650 */  1887, 1094, 1093,  638,  640, 1884, 1827, 1090,  197,   50,
 /*  1660 */  1089, 1088, 1534,  319,  582, 1529,  320,  490, 1527, 1779,
 /*  1670 */   321,  581,  493, 1508, 1827, 1507, 1506,  495,  497,  499,
 /*  1680 */  1753, 1254,  582,   56, 1747,  506,  215, 1779,  144,  581,
 /*  1690 */  1735, 1733, 1734, 1732, 1841, 1731, 1809,   15,  289, 1810,
 /*  1700 */   584, 1812, 1813,  580, 1262,  575,  220,  519, 1729, 1721,
 /*  1710 */    80,   45, 1841,  226,   87,   41,  149, 1810,  584, 1812,
 /*  1720 */  1813,  580, 1809,  575, 1827,  231,   79,   82,   23,   47,
 /*  1730 */    16,  241,  579,  507,   17,  522,  549, 1779,  512,  581,
 /*  1740 */   322, 1462, 1450,  233,  242,  235, 1809, 1432,  237, 1800,
 /*  1750 */  1827, 1434,  151,  240,   25,  339,  228, 1427,  582,   24,
 /*  1760 */   251, 1968, 1841, 1779,   46,  581,  293, 1810,  584, 1812,
 /*  1770 */  1813,  580, 1799,  575, 1827, 1860, 1407,   86,  154,  341,
 /*  1780 */  1406,   18,  582, 1461,  333, 1466, 1465, 1779, 1841,  581,
 /*  1790 */  1467,  334,  294, 1810,  584, 1812, 1813,  580, 1456,  575,
 /*  1800 */    10, 1294,   19, 1369, 1809, 1844,  155,  168, 1344,  574,
 /*  1810 */  1324, 1342, 1841, 1341,   31,   13,  294, 1810,  584, 1812,
 /*  1820 */  1813,  580,   12,  575, 1155,   20,  583,   21,  585,  587,
 /*  1830 */   342,  589, 1827, 1152,  591,  592,  594, 1149,  595,  597,
 /*  1840 */   582,  600, 1132, 1147,  598, 1779, 1143,  581, 1141,  601,
 /*  1850 */  1146, 1164, 1145, 1144,   88, 1809,   89,   62,  607, 1160,
 /*  1860 */   262, 1085, 1051,  616, 1084, 1809, 1083, 1082, 1081, 1080,
 /*  1870 */  1841, 1078,  628, 1076,  279, 1810,  584, 1812, 1813,  580,
 /*  1880 */  1075,  575, 1074, 1827, 1072,  263, 1101, 1071, 1070, 1069,
 /*  1890 */  1068,  582, 1067, 1827, 1066, 1098, 1779, 1096,  581, 1063,
 /*  1900 */  1062,  582, 1059, 1057, 1058, 1056, 1779, 1541,  581,  648,
 /*  1910 */   649,  650, 1539,  652,  654, 1537,  658,  656, 1809, 1535,
 /*  1920 */   653, 1841,  660,  657,  662,  280, 1810,  584, 1812, 1813,
 /*  1930 */   580, 1841,  575,  661, 1809,  281, 1810,  584, 1812, 1813,
 /*  1940 */   580, 1523,  575,  664, 1013, 1505, 1827,  266,  668, 1480,
 /*  1950 */  1280,  274,  671,  672,  582, 1480, 1480, 1480, 1809, 1779,
 /*  1960 */  1480,  581, 1827, 1480, 1480, 1480, 1480, 1480, 1480, 1480,
 /*  1970 */   582, 1480, 1480, 1480, 1480, 1779, 1480,  581, 1480, 1480,
 /*  1980 */  1480, 1480, 1480, 1480, 1841, 1480, 1827, 1480,  288, 1810,
 /*  1990 */   584, 1812, 1813,  580,  582,  575, 1480, 1480, 1480, 1779,
 /*  2000 */  1841,  581, 1480, 1480,  290, 1810,  584, 1812, 1813,  580,
 /*  2010 */  1809,  575, 1480, 1480, 1480, 1480, 1480, 1480, 1480, 1480,
 /*  2020 */  1480, 1480, 1480, 1480, 1841, 1480, 1480, 1480,  282, 1810,
 /*  2030 */   584, 1812, 1813,  580, 1809,  575, 1480, 1480, 1827, 1480,
 /*  2040 */  1480, 1480, 1480, 1480, 1480, 1480,  582, 1480, 1480, 1480,
 /*  2050 */  1480, 1779, 1480,  581, 1480, 1480, 1480, 1480, 1809, 1480,
 /*  2060 */  1480, 1480, 1827, 1480, 1480, 1480, 1480, 1480, 1480, 1480,
 /*  2070 */   582, 1480, 1480, 1480, 1809, 1779, 1841,  581, 1480, 1480,
 /*  2080 */   291, 1810,  584, 1812, 1813,  580, 1827,  575, 1480, 1480,
 /*  2090 */  1480, 1480, 1480, 1480,  582, 1480, 1480, 1480, 1480, 1779,
 /*  2100 */  1841,  581, 1827, 1480,  283, 1810,  584, 1812, 1813,  580,
 /*  2110 */   582,  575, 1480, 1480, 1480, 1779, 1480,  581, 1480, 1480,
 /*  2120 */  1480, 1480, 1480, 1480, 1841, 1480, 1480, 1480,  292, 1810,
 /*  2130 */   584, 1812, 1813,  580, 1480,  575, 1480, 1480, 1480, 1480,
 /*  2140 */  1841, 1480, 1480, 1480,  284, 1810,  584, 1812, 1813,  580,
 /*  2150 */  1480,  575, 1809, 1480, 1480, 1480, 1480, 1480, 1480, 1480,
 /*  2160 */  1480, 1480, 1480, 1480, 1480, 1480, 1480, 1480, 1480, 1480,
 /*  2170 */  1480, 1480, 1480, 1480, 1480, 1480, 1480, 1480, 1480, 1480,
 /*  2180 */  1827, 1480, 1480, 1480, 1480, 1480, 1480, 1480,  582, 1480,
 /*  2190 */  1480, 1480, 1480, 1779, 1480,  581, 1480, 1480, 1480, 1480,
 /*  2200 */  1480, 1480, 1480, 1809, 1480, 1480, 1480, 1480, 1480, 1480,
 /*  2210 */  1480, 1480, 1480, 1809, 1480, 1480, 1480, 1480, 1841, 1480,
 /*  2220 */  1480, 1480,  297, 1810,  584, 1812, 1813,  580, 1480,  575,
 /*  2230 */  1480, 1827, 1480, 1480, 1480, 1480, 1480, 1480, 1480,  582,
 /*  2240 */  1480, 1827, 1480, 1480, 1779, 1480,  581, 1480, 1480,  582,
 /*  2250 */  1480, 1480, 1480, 1480, 1779, 1480,  581, 1480, 1480, 1480,
 /*  2260 */  1480, 1480, 1480, 1480, 1480, 1480, 1809, 1480, 1480, 1841,
 /*  2270 */  1480, 1480, 1480,  298, 1810,  584, 1812, 1813,  580, 1841,
 /*  2280 */   575, 1480, 1809, 1821, 1810,  584, 1812, 1813,  580, 1480,
 /*  2290 */   575, 1480, 1480, 1480, 1827, 1480, 1480, 1480, 1480, 1480,
 /*  2300 */  1480, 1480,  582, 1480, 1480, 1480, 1809, 1779, 1480,  581,
 /*  2310 */  1827, 1480, 1480, 1480, 1480, 1480, 1480, 1480,  582, 1480,
 /*  2320 */  1480, 1480, 1809, 1779, 1480,  581, 1480, 1480, 1480, 1480,
 /*  2330 */  1480, 1480, 1841, 1480, 1827, 1480, 1820, 1810,  584, 1812,
 /*  2340 */  1813,  580,  582,  575, 1480, 1480, 1809, 1779, 1841,  581,
 /*  2350 */  1827, 1480, 1819, 1810,  584, 1812, 1813,  580,  582,  575,
 /*  2360 */  1480, 1480, 1480, 1779, 1480,  581, 1480, 1480, 1480, 1480,
 /*  2370 */  1809, 1480, 1841, 1480, 1827, 1480,  310, 1810,  584, 1812,
 /*  2380 */  1813,  580,  582,  575, 1480, 1480, 1809, 1779, 1841,  581,
 /*  2390 */  1480, 1480,  309, 1810,  584, 1812, 1813,  580, 1827,  575,
 /*  2400 */  1480, 1480, 1480, 1480, 1480, 1480,  582, 1480, 1480, 1480,
 /*  2410 */  1480, 1779, 1841,  581, 1827, 1480,  311, 1810,  584, 1812,
 /*  2420 */  1813,  580,  582,  575, 1480, 1480, 1480, 1779, 1480,  581,
 /*  2430 */  1480, 1480, 1480, 1480, 1480, 1480, 1841, 1480, 1480, 1480,
 /*  2440 */   308, 1810,  584, 1812, 1813,  580, 1480,  575, 1480, 1480,
 /*  2450 */  1480, 1480, 1841, 1480, 1480, 1480,  287, 1810,  584, 1812,
 /*  2460 */  1813,  580, 1480,  575,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   315,  367,  317,  318,  311,  321,  367,  315,  341,  317,
 /*    10 */   318,  340,   12,   13,  319,    4,  392,  393,  334,  352,
 /*    20 */    20,  407,   22,    8,    9,    4,  342,   12,   13,   14,
 /*    30 */    15,   16,  339,   33,  420,   35,  319,  310,  424,  312,
 /*    40 */   347,  407,  347,  376,  377,  352,  407,  354,   12,   13,
 /*    50 */    14,   15,   16,   20,  420,  388,   56,  354,  424,  420,
 /*    60 */   367,   61,  367,  424,  361,   44,   45,  364,   68,    0,
 /*    70 */   377,   20,  323,  356,  381,  382,  383,  384,  385,  386,
 /*    80 */   385,  388,  311,   56,  391,  336,   56,  350,  395,  396,
 /*    90 */   353,  354,   92,   20,  345,  400,  401,  402,   92,  404,
 /*   100 */   407,   21,  407,   92,   24,   25,   26,   27,   28,   29,
 /*   110 */    30,   31,   32,  420,  114,  420,   60,  424,   91,  424,
 /*   120 */    14,   94,   92,  352,   94,   92,   20,   20,  128,  129,
 /*   130 */     1,    2,   63,   64,   65,   66,   67,  311,   69,   70,
 /*   140 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   150 */    81,   82,   83,   84,   85,   86,   87,   88,   89,  319,
 /*   160 */    21,    8,    9,   33,    0,   12,   13,   14,   15,   16,
 /*   170 */   330,  123,  124,   34,  174,   36,  176,   47,  352,  128,
 /*   180 */   129,  166,   52,   53,   54,   55,   56,  347,   24,   25,
 /*   190 */    26,   27,   28,   29,   30,   31,   32,  197,  198,   92,
 /*   200 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,   12,   13,
 /*   220 */    14,   91,   93,   18,   94,   20,   20,  321,   22,  311,
 /*   230 */   182,  231,   27,  185,  407,   30,  367,  231,  319,   33,
 /*   240 */   159,   35,  231,  339,  341,  319,   93,  420,  342,  330,
 /*   250 */   346,  424,   47,  339,   49,  352,   51,  339,  407,  355,
 /*   260 */   346,  231,   56,   20,  231,  347,  347,   61,  253,  355,
 /*   270 */   352,  420,  354,  347,   68,  424,  407,    8,    9,  376,
 /*   280 */   377,   12,   13,   14,   15,   16,  341,  157,  158,  420,
 /*   290 */   160,  388,   92,  424,  164,  377,   91,  352,   92,  381,
 /*   300 */   382,  383,  384,  385,  386,   20,  388,  201,  103,  391,
 /*   310 */   180,  385,   43,  395,  396,  397,   20,  236,  237,  338,
 /*   320 */   114,  376,  377,  378,  406,  399,  400,  401,  402,  363,
 /*   330 */   404,  365,  351,  388,  128,  129,  131,  308,  231,  134,
 /*   340 */   135,  136,  137,  138,  139,  140,  141,  142,  143,  144,
 /*   350 */   145,  146,  147,  148,  149,  150,  151,    0,  153,  154,
 /*   360 */   155,  379,  105,  106,  107,  108,  109,  110,  111,  112,
 /*   370 */   113,  114,  115,  319,  117,  118,  119,  120,  121,  122,
 /*   380 */   174,  331,  176,   37,  330,  403,    8,    9,   92,  339,
 /*   390 */    12,   13,   14,   15,   16,  324,  367,   20,  348,  328,
 /*   400 */    20,  347,   22,  197,  198,   48,  200,  201,  202,  203,
 /*   410 */   204,  205,  206,  207,  208,  209,  210,  211,  212,  213,
 /*   420 */   214,  215,  216,  217,   12,   13,  311,    4,  353,  354,
 /*   430 */    50,  231,   20,  363,   22,  365,  407,   20,   14,   15,
 /*   440 */    16,   95,   19,   97,   98,   33,  100,   35,  339,  420,
 /*   450 */   104,   20,  123,  424,  339,  346,   33,    0,   64,   65,
 /*   460 */    14,    0,  347,   60,  355,   71,   20,  352,   56,  354,
 /*   470 */    47,   93,  126,   61,   51,   81,   82,    2,  331,   56,
 /*   480 */    68,   87,  367,    8,    9,  331,  339,   12,   13,   14,
 /*   490 */    15,   16,  377,  339,   39,  348,  381,  382,  383,  384,
 /*   500 */   385,  386,  348,  388,   92,  103,  391,  156,  319,  319,
 /*   510 */   395,  396,  183,  184,   91,  316,  407,   94,  319,  311,
 /*   520 */   330,   60,  407,   18,  339,   92,  114,  337,   23,  420,
 /*   530 */   311,  311,  347,  424,  169,  420,  347,  347,    2,  424,
 /*   540 */   128,  129,   37,   38,    8,    9,   41,   68,   12,   13,
 /*   550 */    14,   15,   16,  188,  189,   12,   13,  311,  339,  319,
 /*   560 */   352,  104,   57,   58,   59,   22,  347,    0,  383,  218,
 /*   570 */   330,  352,  352,  354,  385,  354,   33,  337,   35,  228,
 /*   580 */   123,  124,  125,  126,  127,  364,  174,  347,  176,  400,
 /*   590 */   401,  402,  161,  404,   68,  311,  377,   92,  352,   56,
 /*   600 */   381,  382,  383,  384,  385,  386,  173,  388,  175,  197,
 /*   610 */   198,   68,  200,  201,  202,  203,  204,  205,  206,  207,
 /*   620 */   208,  209,  210,  211,  212,  213,  214,  215,  216,  217,
 /*   630 */    12,   13,  379,   22,  311,  130,  352,  311,   20,  327,
 /*   640 */    22,  329,   14,    0,  425,  426,   35,  201,   20,  340,
 /*   650 */    20,   33,   22,   35,    8,    9,  403,  114,   12,   13,
 /*   660 */    14,   15,   16,    0,  231,   35,  316,  367,  340,  319,
 /*   670 */   311,  166,  167,  168,   56,  352,  171,  340,  352,   68,
 /*   680 */    50,  124,  311,    8,    9,  230,   68,   12,   13,   14,
 /*   690 */    15,   16,  187,  319,  311,  190,  323,  192,  193,  194,
 /*   700 */   195,  196,  311,   60,  330,   44,   45,  407,    8,    9,
 /*   710 */    92,  352,   12,   13,   14,   15,   16,  174,  345,  176,
 /*   720 */   420,  347,  339,  352,  424,  114,  340,   64,   65,  311,
 /*   730 */   347,  311,  114,  367,   71,  352,  231,  354,  181,  182,
 /*   740 */   197,  198,  185,  352,   81,   82,  128,  129,  311,   35,
 /*   750 */    87,  379,  209,  210,  211,  212,  213,  214,  215,  197,
 /*   760 */   377,   61,  229,  230,  381,  382,  383,  384,  385,  386,
 /*   770 */   352,  388,  352,  407,  391,  403,  104,  347,  395,  396,
 /*   780 */   397,    4,   68,  325,  326,  174,  420,  176,  358,  352,
 /*   790 */   424,  104,  174,   93,  176,  123,  124,  125,  126,  127,
 /*   800 */   417,  101,  240,  241,  242,  243,  244,  161,  197,  198,
 /*   810 */   311,  311,  311,  126,  311,  197,  198,   20,  200,  201,
 /*   820 */   202,  203,  204,  205,  206,  207,  208,  209,  210,  211,
 /*   830 */   212,  213,  214,  215,  216,  217,   12,   13,   14,  339,
 /*   840 */     0,  339,   77,  371,   20,   35,   22,  347,  311,  231,
 /*   850 */   348,  352,  352,  352,  354,  352,  156,   33,  311,   35,
 /*   860 */   339,   21,  347,    3,   24,   25,   26,   27,   28,   29,
 /*   870 */    30,   31,   32,  358,  325,  326,  355,  377,   68,   20,
 /*   880 */    56,  381,  382,  383,  384,  385,  386,  349,  388,  352,
 /*   890 */   352,  391,   68,   42,   43,  395,  396,  132,  133,  352,
 /*   900 */   349,    8,    9,  352,  341,   12,   13,   14,   15,   16,
 /*   910 */   332,   43,  340,  335,  311,  352,   92,    0,  218,  219,
 /*   920 */   220,  221,  222,  223,  224,  225,  226,  227,  228,    8,
 /*   930 */     9,  311,  319,   12,   13,   14,   15,   16,  114,  376,
 /*   940 */   377,  378,  339,  330,   43,  319,  340,  344,    0,   22,
 /*   950 */   347,  388,  128,  129,   61,  352,  330,  354,  161,  339,
 /*   960 */   347,   93,   35,   96,   47,   96,   99,  347,   99,  312,
 /*   970 */    22,  319,  352,  347,  354,  161,  162,    1,    2,  319,
 /*   980 */   377,   56,  330,   43,  381,  382,  383,  384,  385,  386,
 /*   990 */   330,  388,  319,   96,  101,    0,   99,  377,  174,  347,
 /*  1000 */   176,  381,  382,  383,  384,  385,  386,  347,  388,  232,
 /*  1010 */    96,  391,   43,   99,   93,  395,  396,   22,  427,   94,
 /*  1020 */   347,  197,  198,    0,  200,  201,  202,  203,  204,  205,
 /*  1030 */   206,  207,  208,  209,  210,  211,  212,  213,  214,  215,
 /*  1040 */   216,  217,   12,   13,  319,   22,   43,  328,  319,  156,
 /*  1050 */    20,   43,   22,   43,   19,  330,  319,   35,  385,  330,
 /*  1060 */   201,  320,   93,   33,  311,   35,   35,  330,   33,  128,
 /*  1070 */   129,  418,  347,  400,  401,  402,  347,  404,   61,   46,
 /*  1080 */    13,   43,   47,   43,  347,   92,   56,   52,   53,   54,
 /*  1090 */    55,   56,  339,    0,  414,  102,   93,  344,   68,  319,
 /*  1100 */   347,   93,   35,   93,  311,  352,   43,  354,  248,  339,
 /*  1110 */   330,  218,  219,  220,  221,  222,  223,  224,  225,  226,
 /*  1120 */   227,  228,   92,   43,   13,   92,   91,  347,  320,   94,
 /*  1130 */   377,   93,  339,   93,  381,  382,  383,  384,  385,  386,
 /*  1140 */   347,  388,  351,   43,  114,  352,   35,  354,  318,   43,
 /*  1150 */    43,  250,  319,  380,  319,  319,   93,  319,  128,  129,
 /*  1160 */   405,   43,  127,  330,  398,  330,  330,  421,  330,  421,
 /*  1170 */   377,   43,  421,   93,  381,  382,  383,  384,  385,  386,
 /*  1180 */   347,  388,  347,  347,  391,  347,  408,  233,  395,  396,
 /*  1190 */   397,  375,  252,   93,   47,  160,  374,  104,  176,   93,
 /*  1200 */    93,  319,  409,   43,  174,   43,  176,  176,  172,   42,
 /*  1210 */   417,   93,  330,  178,  197,  180,  123,  124,  125,  126,
 /*  1220 */   127,   93,  369,  359,   20,  319,  319,  197,  198,  347,
 /*  1230 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*  1240 */   210,  211,  212,  213,  214,  215,  216,  217,   12,   13,
 /*  1250 */   311,  319,  319,   93,  359,   93,   20,  156,   22,  357,
 /*  1260 */   357,  319,  330,  330,  319,  319,   20,   20,  313,   33,
 /*  1270 */   313,   35,  373,  323,  354,  323,   20,  366,  339,  347,
 /*  1280 */   347,   20,  323,  368,  366,  323,  347,  323,  323,  319,
 /*  1290 */   323,  352,   56,  354,  313,  339,  319,  339,  313,  339,
 /*  1300 */   339,  352,  339,  373,   68,  339,  179,  339,  321,  372,
 /*  1310 */   311,  339,  339,  339,  339,  321,  377,  319,  321,  319,
 /*  1320 */   381,  382,  383,  384,  385,  386,  319,  388,   92,  238,
 /*  1330 */   391,  158,  354,  321,  395,  396,  397,  366,  339,  321,
 /*  1340 */   352,  362,  352,  352,  352,  406,  347,   20,  362,  360,
 /*  1350 */   114,  352,  347,  354,  347,  335,  352,  413,  352,  239,
 /*  1360 */   380,  352,  245,  362,  128,  129,  352,  352,  352,  416,
 /*  1370 */   165,  247,  246,  362,  367,  234,  377,   20,  230,  347,
 /*  1380 */   381,  382,  383,  384,  385,  386,  251,  388,  249,   92,
 /*  1390 */   391,  254,  385,  411,  395,  396,  397,  413,  415,  375,
 /*  1400 */   379,   92,  343,  352,  329,  406,  410,  400,  401,  402,
 /*  1410 */   174,  404,  176,  394,  407,  413,  319,  321,   36,  314,
 /*  1420 */   370,  313,  365,  333,  322,  412,  311,  420,  333,    0,
 /*  1430 */   309,  424,  333,  197,  198,  181,  200,  201,  202,  203,
 /*  1440 */   204,  205,  206,  207,  208,  209,  210,  211,  212,  213,
 /*  1450 */   214,  215,  216,  217,  339,  428,    0,  423,    0,  422,
 /*  1460 */     0,  422,  347,   42,  423,  423,  422,  352,    0,  354,
 /*  1470 */   191,   35,   35,   35,   35,  191,    0,   35,   35,  191,
 /*  1480 */     0,  191,  367,    0,   35,    0,   22,  311,    0,   35,
 /*  1490 */   176,    0,  377,  174,    0,  170,  381,  382,  383,  384,
 /*  1500 */   385,  386,  169,  388,    0,    0,    0,   46,    0,    0,
 /*  1510 */     0,   42,    0,    0,  152,  339,    0,    0,    0,    0,
 /*  1520 */     0,  147,  407,  347,   35,    0,  147,    0,  352,    0,
 /*  1530 */   354,    0,    0,    0,    0,  420,    0,    0,    0,  424,
 /*  1540 */     0,    0,    0,  367,  311,    0,    0,    0,    0,   42,
 /*  1550 */     0,    0,    0,  377,   56,    0,   56,  381,  382,  383,
 /*  1560 */   384,  385,  386,    0,  388,   22,    0,    0,    0,    0,
 /*  1570 */   311,    0,  339,    0,    0,   14,   46,   42,   39,   14,
 /*  1580 */   347,    0,    0,  407,    0,  352,    0,  354,  165,    0,
 /*  1590 */     0,    0,   43,    0,    0,   39,  420,   40,  339,   46,
 /*  1600 */   424,   39,    0,    0,    0,   35,  347,   47,    0,    0,
 /*  1610 */   377,  352,   35,  354,  381,  382,  383,  384,  385,  386,
 /*  1620 */   387,  388,  389,  390,   39,   47,   62,   39,  311,    0,
 /*  1630 */    35,   39,   35,    0,   47,   39,  377,   22,    0,   20,
 /*  1640 */   381,  382,  383,  384,  385,  386,  311,  388,   47,   35,
 /*  1650 */   391,   35,   35,   43,   43,  396,  339,   35,   99,  101,
 /*  1660 */    35,   22,    0,   22,  347,    0,   22,   49,    0,  352,
 /*  1670 */    22,  354,   35,    0,  339,    0,    0,   35,   35,   22,
 /*  1680 */     0,   35,  347,  161,    0,   22,  158,  352,  177,  354,
 /*  1690 */     0,    0,    0,    0,  377,    0,  311,   92,  381,  382,
 /*  1700 */   383,  384,  385,  386,   35,  388,   93,  186,    0,    0,
 /*  1710 */    39,  229,  377,   92,  102,   43,  381,  382,  383,  384,
 /*  1720 */   385,  386,  311,  388,  339,   46,   92,   92,   92,   43,
 /*  1730 */   235,   43,  347,  161,  235,  159,  419,  352,  163,  354,
 /*  1740 */   161,   35,   93,   92,   46,   93,  311,   93,   92,   46,
 /*  1750 */   339,   93,   92,   92,   43,  344,  157,   93,  347,   92,
 /*  1760 */    46,  426,  377,  352,   43,  354,  381,  382,  383,  384,
 /*  1770 */   385,  386,   46,  388,  339,  390,   93,   92,   46,  344,
 /*  1780 */    93,   43,  347,   35,   35,   35,   35,  352,  377,  354,
 /*  1790 */    93,   35,  381,  382,  383,  384,  385,  386,   93,  388,
 /*  1800 */     2,   22,   43,  197,  311,   92,   46,   46,   93,   92,
 /*  1810 */    22,   93,  377,   93,   92,  235,  381,  382,  383,  384,
 /*  1820 */   385,  386,   92,  388,   93,   92,  199,   92,  103,   35,
 /*  1830 */    35,   92,  339,   93,   35,   92,   35,   93,   92,   35,
 /*  1840 */   347,   35,   22,  116,   92,  352,   93,  354,   93,   92,
 /*  1850 */   116,   35,  116,  116,   92,  311,   92,   92,  104,   22,
 /*  1860 */    43,   35,   62,   61,   35,  311,   35,   35,   35,   35,
 /*  1870 */   377,   35,   90,   35,  381,  382,  383,  384,  385,  386,
 /*  1880 */    35,  388,   35,  339,   35,   43,   68,   35,   22,   35,
 /*  1890 */    22,  347,   35,  339,   35,   68,  352,   35,  354,   35,
 /*  1900 */    35,  347,   35,   22,   35,   35,  352,    0,  354,   35,
 /*  1910 */    47,   39,    0,   35,   39,    0,   39,   35,  311,    0,
 /*  1920 */    47,  377,   35,   47,   39,  381,  382,  383,  384,  385,
 /*  1930 */   386,  377,  388,   47,  311,  381,  382,  383,  384,  385,
 /*  1940 */   386,    0,  388,   35,   35,    0,  339,   22,   21,  429,
 /*  1950 */    22,   22,   21,   20,  347,  429,  429,  429,  311,  352,
 /*  1960 */   429,  354,  339,  429,  429,  429,  429,  429,  429,  429,
 /*  1970 */   347,  429,  429,  429,  429,  352,  429,  354,  429,  429,
 /*  1980 */   429,  429,  429,  429,  377,  429,  339,  429,  381,  382,
 /*  1990 */   383,  384,  385,  386,  347,  388,  429,  429,  429,  352,
 /*  2000 */   377,  354,  429,  429,  381,  382,  383,  384,  385,  386,
 /*  2010 */   311,  388,  429,  429,  429,  429,  429,  429,  429,  429,
 /*  2020 */   429,  429,  429,  429,  377,  429,  429,  429,  381,  382,
 /*  2030 */   383,  384,  385,  386,  311,  388,  429,  429,  339,  429,
 /*  2040 */   429,  429,  429,  429,  429,  429,  347,  429,  429,  429,
 /*  2050 */   429,  352,  429,  354,  429,  429,  429,  429,  311,  429,
 /*  2060 */   429,  429,  339,  429,  429,  429,  429,  429,  429,  429,
 /*  2070 */   347,  429,  429,  429,  311,  352,  377,  354,  429,  429,
 /*  2080 */   381,  382,  383,  384,  385,  386,  339,  388,  429,  429,
 /*  2090 */   429,  429,  429,  429,  347,  429,  429,  429,  429,  352,
 /*  2100 */   377,  354,  339,  429,  381,  382,  383,  384,  385,  386,
 /*  2110 */   347,  388,  429,  429,  429,  352,  429,  354,  429,  429,
 /*  2120 */   429,  429,  429,  429,  377,  429,  429,  429,  381,  382,
 /*  2130 */   383,  384,  385,  386,  429,  388,  429,  429,  429,  429,
 /*  2140 */   377,  429,  429,  429,  381,  382,  383,  384,  385,  386,
 /*  2150 */   429,  388,  311,  429,  429,  429,  429,  429,  429,  429,
 /*  2160 */   429,  429,  429,  429,  429,  429,  429,  429,  429,  429,
 /*  2170 */   429,  429,  429,  429,  429,  429,  429,  429,  429,  429,
 /*  2180 */   339,  429,  429,  429,  429,  429,  429,  429,  347,  429,
 /*  2190 */   429,  429,  429,  352,  429,  354,  429,  429,  429,  429,
 /*  2200 */   429,  429,  429,  311,  429,  429,  429,  429,  429,  429,
 /*  2210 */   429,  429,  429,  311,  429,  429,  429,  429,  377,  429,
 /*  2220 */   429,  429,  381,  382,  383,  384,  385,  386,  429,  388,
 /*  2230 */   429,  339,  429,  429,  429,  429,  429,  429,  429,  347,
 /*  2240 */   429,  339,  429,  429,  352,  429,  354,  429,  429,  347,
 /*  2250 */   429,  429,  429,  429,  352,  429,  354,  429,  429,  429,
 /*  2260 */   429,  429,  429,  429,  429,  429,  311,  429,  429,  377,
 /*  2270 */   429,  429,  429,  381,  382,  383,  384,  385,  386,  377,
 /*  2280 */   388,  429,  311,  381,  382,  383,  384,  385,  386,  429,
 /*  2290 */   388,  429,  429,  429,  339,  429,  429,  429,  429,  429,
 /*  2300 */   429,  429,  347,  429,  429,  429,  311,  352,  429,  354,
 /*  2310 */   339,  429,  429,  429,  429,  429,  429,  429,  347,  429,
 /*  2320 */   429,  429,  311,  352,  429,  354,  429,  429,  429,  429,
 /*  2330 */   429,  429,  377,  429,  339,  429,  381,  382,  383,  384,
 /*  2340 */   385,  386,  347,  388,  429,  429,  311,  352,  377,  354,
 /*  2350 */   339,  429,  381,  382,  383,  384,  385,  386,  347,  388,
 /*  2360 */   429,  429,  429,  352,  429,  354,  429,  429,  429,  429,
 /*  2370 */   311,  429,  377,  429,  339,  429,  381,  382,  383,  384,
 /*  2380 */   385,  386,  347,  388,  429,  429,  311,  352,  377,  354,
 /*  2390 */   429,  429,  381,  382,  383,  384,  385,  386,  339,  388,
 /*  2400 */   429,  429,  429,  429,  429,  429,  347,  429,  429,  429,
 /*  2410 */   429,  352,  377,  354,  339,  429,  381,  382,  383,  384,
 /*  2420 */   385,  386,  347,  388,  429,  429,  429,  352,  429,  354,
 /*  2430 */   429,  429,  429,  429,  429,  429,  377,  429,  429,  429,
 /*  2440 */   381,  382,  383,  384,  385,  386,  429,  388,  429,  429,
 /*  2450 */   429,  429,  377,  429,  429,  429,  381,  382,  383,  384,
 /*  2460 */   385,  386,  429,  388,
};
#define YY_SHIFT_COUNT    (673)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1945)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   505,    0,    0,  206,  206,  412,  412,  412,  618,  618,
 /*    10 */   412,  412,  824, 1030, 1236, 1030, 1030, 1030, 1030, 1030,
 /*    20 */  1030, 1030, 1030, 1030, 1030, 1030, 1030, 1030, 1030, 1030,
 /*    30 */  1030, 1030, 1030, 1030, 1030, 1030, 1030, 1030, 1030, 1030,
 /*    40 */  1030, 1030,   33,   33,  296,  296,  296,  543,  543,  107,
 /*    50 */   543,  543,  433,   30,    6,  200,    6,   73,   73,   21,
 /*    60 */    21,   11,   51,    6,    6,   73,   73,   73,   73,   73,
 /*    70 */    73,   73,   73,   73,   73,   56,   73,   73,   73,  243,
 /*    80 */    73,   73,  285,   73,   73,  285,  377,   73,  285,  285,
 /*    90 */   285,   73,  403,  205,  700,  893,  893,   80,  611,  611,
 /*   100 */   611,  611,  611,  611,  611,  611,  611,  611,  611,  611,
 /*   110 */   611,  611,  611,  611,  611,  611,  611,  346,  394,   51,
 /*   120 */   628,  628,  461,  714,  643,  431,  431,  431,  714,  417,
 /*   130 */   417,  243,  567,  567,  285,  285,  479,  479,  402,  526,
 /*   140 */   257,  257,  257,  257,  257,  257,  257, 1035,  840,   15,
 /*   150 */   663,  562,  630,   81,  106,  446,  380,  661,  687,  797,
 /*   160 */   533,  455,  533,  851,  860,  860,  860,  777,  859,  954,
 /*   170 */  1147, 1036, 1167, 1204, 1204, 1167, 1101, 1101, 1204, 1204,
 /*   180 */  1204, 1246, 1246, 1247,   56,  243,   56, 1256, 1261,   56,
 /*   190 */  1256,   56,   56,   56, 1204,   56, 1246,  285,  285,  285,
 /*   200 */   285,  285,  285,  285,  285,  285,  285,  285, 1204, 1246,
 /*   210 */   479, 1247,  403, 1127,  243,  403, 1204, 1204, 1256,  403,
 /*   220 */  1091,  479,  479,  479,  479, 1091,  479, 1173,  403,  402,
 /*   230 */   403,  417, 1327,  479, 1120, 1091,  479,  479, 1120, 1091,
 /*   240 */   479,  479,  285, 1117, 1205, 1120, 1124, 1126, 1141,  954,
 /*   250 */  1148,  417, 1357, 1135, 1139, 1137, 1135, 1139, 1135, 1139,
 /*   260 */  1297, 1309,  479,  526, 1204,  403, 1382, 1246, 2464, 2464,
 /*   270 */  2464, 2464, 2464, 2464, 2464,   69,  130,  164,  423,  153,
 /*   280 */   269,  378,  475,  536,  646,  921,  457,  675,  675,  675,
 /*   290 */   675,  675,  675,  675,  675, 1093,  672,   36,   36,  557,
 /*   300 */    48,  365,   27,  765,  139,  329,  129,  351,  424,  424,
 /*   310 */   424,  424,  868,  917,  927,  867,  869,  897,  914,  948,
 /*   320 */   995, 1023,  925,  814,  969, 1003, 1008, 1010, 1038, 1040,
 /*   330 */  1063,  976,  941,  901,  940, 1100, 1022, 1031, 1017, 1106,
 /*   340 */  1033, 1080, 1107, 1118, 1128, 1160, 1162,  993, 1067, 1111,
 /*   350 */   810,  357, 1429, 1456, 1254, 1458, 1460, 1421, 1468, 1436,
 /*   360 */  1279, 1437, 1438, 1439, 1284, 1476, 1442, 1443, 1288, 1480,
 /*   370 */  1290, 1483, 1449, 1485, 1464, 1488, 1454, 1314, 1319, 1491,
 /*   380 */  1494, 1325, 1333, 1504, 1505, 1461, 1506, 1508, 1509, 1469,
 /*   390 */  1510, 1512, 1513, 1362, 1516, 1517, 1518, 1519, 1520, 1374,
 /*   400 */  1489, 1525, 1379, 1527, 1529, 1531, 1532, 1533, 1534, 1536,
 /*   410 */  1537, 1538, 1540, 1541, 1542, 1545, 1546, 1507, 1547, 1548,
 /*   420 */  1550, 1551, 1552, 1563, 1543, 1566, 1567, 1568, 1569, 1571,
 /*   430 */  1498, 1555, 1500, 1573, 1574, 1535, 1539, 1549, 1561, 1530,
 /*   440 */  1565, 1553, 1581, 1557, 1556, 1582, 1584, 1586, 1562, 1423,
 /*   450 */  1589, 1590, 1591, 1564, 1593, 1594, 1570, 1560, 1585, 1602,
 /*   460 */  1577, 1578, 1588, 1603, 1595, 1587, 1592, 1604, 1597, 1601,
 /*   470 */  1596, 1608, 1609, 1629, 1633, 1558, 1559, 1614, 1615, 1638,
 /*   480 */  1616, 1617, 1610, 1611, 1622, 1625, 1639, 1662, 1641, 1665,
 /*   490 */  1644, 1618, 1668, 1648, 1637, 1673, 1642, 1675, 1643, 1676,
 /*   500 */  1657, 1619, 1680, 1522, 1646, 1684, 1511, 1663, 1572, 1528,
 /*   510 */  1690, 1691, 1579, 1575, 1692, 1693, 1695, 1605, 1613, 1669,
 /*   520 */  1521, 1708, 1621, 1576, 1634, 1709, 1671, 1599, 1635, 1612,
 /*   530 */  1679, 1672, 1495, 1636, 1649, 1651, 1652, 1654, 1656, 1686,
 /*   540 */  1658, 1660, 1661, 1667, 1664, 1688, 1698, 1703, 1685, 1711,
 /*   550 */  1499, 1683, 1687, 1714, 1482, 1721, 1726, 1732, 1697, 1738,
 /*   560 */  1580, 1705, 1706, 1748, 1749, 1750, 1751, 1756, 1705, 1798,
 /*   570 */  1779, 1606, 1759, 1713, 1715, 1717, 1718, 1722, 1720, 1760,
 /*   580 */  1730, 1733, 1761, 1788, 1627, 1735, 1725, 1731, 1794, 1795,
 /*   590 */  1739, 1740, 1799, 1743, 1744, 1801, 1746, 1753, 1804, 1752,
 /*   600 */  1755, 1806, 1757, 1727, 1734, 1736, 1737, 1820, 1754, 1762,
 /*   610 */  1764, 1816, 1765, 1817, 1817, 1837, 1800, 1802, 1826, 1829,
 /*   620 */  1831, 1832, 1833, 1834, 1836, 1838, 1845, 1847, 1818, 1782,
 /*   630 */  1842, 1849, 1852, 1866, 1854, 1868, 1857, 1859, 1827, 1610,
 /*   640 */  1862, 1611, 1864, 1865, 1867, 1869, 1881, 1870, 1907, 1874,
 /*   650 */  1863, 1872, 1912, 1878, 1873, 1875, 1915, 1882, 1876, 1877,
 /*   660 */  1919, 1887, 1886, 1885, 1941, 1908, 1909, 1945, 1925, 1927,
 /*   670 */  1928, 1929, 1931, 1933,
};
#define YY_REDUCE_COUNT (274)
#define YY_REDUCE_MIN   (-386)
#define YY_REDUCE_MAX   (2075)
static const short yy_reduce_ofst[] = {
 /*     0 */    29, -307,  115,  793,  383,  -82,  939,  999, 1115, 1176,
 /*    10 */   500,  620, 1233,  219, 1259,  603,  753, 1317, 1335, 1385,
 /*    20 */  1411, 1435, 1493, 1544, 1554, 1607, 1623, 1647, 1699, 1723,
 /*    30 */  1747, 1763, 1841, 1892, 1902, 1955, 1971, 1995, 2011, 2035,
 /*    40 */  2059, 2075, -305, 1007,  -74,  189,  673,  -55,  563,  109,
 /*    50 */  -333,  -97, -366, -361, -131,  300,  366,  190,  240, -315,
 /*    60 */  -308, -386, -263, -173, -149, -160,  -81,   54,  374,  613,
 /*    70 */   626,  652,  660,  725,  729, -251,  737,  780,  833, -297,
 /*    80 */   835,  836,   50,  838,  882,  -96,  185,  932,  147,  -86,
 /*    90 */   154,  933, -316, -283, -376, -376, -376, -273, -229, -174,
 /*   100 */   208,  220,  246,  284,  323,  326,  359,  371,  391,  418,
 /*   110 */   420,  437,  499,  501,  503,  537,  547,  -19,   71,   75,
 /*   120 */   199,  350,  373,  458,  -94,  -18,  253,  372,  549,  430,
 /*   130 */   515,  221,  -34,   70,  502,  521,  538,  551,  578,  312,
 /*   140 */  -329,  309,  328,  337,  386,  572,  606,  472,  657,  591,
 /*   150 */   719,  653,  741,  680,  770,  770,  808,  830,  791,  773,
 /*   160 */   755,  755,  755,  766,  746,  748,  751,  778,  770,  816,
 /*   170 */   822,  853,  864,  906,  907,  895,  902,  903,  942,  945,
 /*   180 */   946,  955,  957,  899,  950,  920,  952,  911,  915,  959,
 /*   190 */   918,  962,  964,  965,  970,  967,  981,  956,  958,  960,
 /*   200 */   961,  963,  966,  968,  972,  973,  974,  975,  977,  985,
 /*   210 */   949,  930,  987,  937,  978,  994,  998, 1000,  971,  997,
 /*   220 */   979,  988,  990,  991,  992,  986, 1004,  989, 1012, 1020,
 /*   230 */  1018, 1005,  980, 1006,  944, 1001, 1009, 1014,  984, 1011,
 /*   240 */  1015, 1016,  770,  953,  983, 1002, 1013,  982,  996, 1024,
 /*   250 */   755, 1032, 1021, 1034, 1037, 1027, 1041, 1039, 1042, 1044,
 /*   260 */  1019, 1059, 1051, 1075, 1097, 1096, 1105, 1108, 1050, 1057,
 /*   270 */  1090, 1095, 1099, 1102, 1121,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*    10 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*    20 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*    30 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*    40 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*    50 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*    60 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*    70 */  1478, 1478, 1478, 1478, 1478, 1552, 1478, 1478, 1478, 1478,
 /*    80 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*    90 */  1478, 1478, 1550, 1714, 1478, 1889, 1478, 1478, 1478, 1478,
 /*   100 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   110 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   120 */  1478, 1478, 1552, 1478, 1550, 1901, 1901, 1901, 1478, 1478,
 /*   130 */  1478, 1478, 1755, 1755, 1478, 1478, 1478, 1478, 1654, 1478,
 /*   140 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1749, 1478, 1970,
 /*   150 */  1478, 1478, 1478, 1924, 1478, 1478, 1478, 1478, 1607, 1916,
 /*   160 */  1893, 1907, 1894, 1891, 1955, 1955, 1955, 1910, 1478, 1920,
 /*   170 */  1478, 1742, 1719, 1478, 1478, 1719, 1716, 1716, 1478, 1478,
 /*   180 */  1478, 1478, 1478, 1478, 1552, 1478, 1552, 1478, 1478, 1552,
 /*   190 */  1478, 1552, 1552, 1552, 1478, 1552, 1478, 1478, 1478, 1478,
 /*   200 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   210 */  1478, 1478, 1550, 1751, 1478, 1550, 1478, 1478, 1478, 1550,
 /*   220 */  1929, 1478, 1478, 1478, 1478, 1929, 1478, 1478, 1550, 1478,
 /*   230 */  1550, 1478, 1478, 1478, 1931, 1929, 1478, 1478, 1931, 1929,
 /*   240 */  1478, 1478, 1478, 1943, 1939, 1931, 1947, 1945, 1922, 1920,
 /*   250 */  1907, 1478, 1478, 1961, 1957, 1973, 1961, 1957, 1961, 1957,
 /*   260 */  1478, 1623, 1478, 1478, 1478, 1550, 1510, 1478, 1744, 1755,
 /*   270 */  1657, 1657, 1657, 1553, 1483, 1478, 1478, 1478, 1478, 1478,
 /*   280 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1826, 1942, 1941,
 /*   290 */  1865, 1864, 1863, 1861, 1825, 1478, 1619, 1824, 1823, 1478,
 /*   300 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1817, 1818,
 /*   310 */  1816, 1815, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   320 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   330 */  1478, 1890, 1478, 1958, 1962, 1478, 1478, 1478, 1478, 1478,
 /*   340 */  1801, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   350 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   360 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   370 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   380 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   390 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   400 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   410 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   420 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   430 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1515, 1478, 1478,
 /*   440 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   450 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   460 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   470 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   480 */  1478, 1478, 1590, 1589, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   490 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   500 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   510 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   520 */  1478, 1759, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   530 */  1478, 1923, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   540 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1801, 1478, 1940,
 /*   550 */  1478, 1900, 1896, 1478, 1478, 1892, 1800, 1478, 1478, 1956,
 /*   560 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1885,
 /*   570 */  1478, 1478, 1858, 1843, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   580 */  1478, 1478, 1478, 1478, 1811, 1478, 1478, 1478, 1478, 1478,
 /*   590 */  1651, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   600 */  1478, 1478, 1478, 1636, 1634, 1633, 1632, 1478, 1629, 1478,
 /*   610 */  1478, 1478, 1478, 1660, 1659, 1478, 1478, 1478, 1478, 1478,
 /*   620 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   630 */  1571, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1563,
 /*   640 */  1478, 1562, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   650 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   660 */  1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478, 1478,
 /*   670 */  1478, 1478, 1478, 1478,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* SST_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  255,  /*      AFTER => ABORT */
  255,  /*     ATTACH => ABORT */
  255,  /*     BEFORE => ABORT */
  255,  /*      BEGIN => ABORT */
  255,  /*     BITAND => ABORT */
  255,  /*     BITNOT => ABORT */
  255,  /*      BITOR => ABORT */
  255,  /*     BLOCKS => ABORT */
  255,  /*     CHANGE => ABORT */
  255,  /*      COMMA => ABORT */
  255,  /*    COMPACT => ABORT */
  255,  /*     CONCAT => ABORT */
  255,  /*   CONFLICT => ABORT */
  255,  /*       COPY => ABORT */
  255,  /*   DEFERRED => ABORT */
  255,  /* DELIMITERS => ABORT */
  255,  /*     DETACH => ABORT */
  255,  /*     DIVIDE => ABORT */
  255,  /*        DOT => ABORT */
  255,  /*       EACH => ABORT */
  255,  /*        END => ABORT */
  255,  /*       FAIL => ABORT */
  255,  /*       FILE => ABORT */
  255,  /*        FOR => ABORT */
  255,  /*       GLOB => ABORT */
  255,  /*         ID => ABORT */
  255,  /*  IMMEDIATE => ABORT */
  255,  /*     IMPORT => ABORT */
  255,  /*  INITIALLY => ABORT */
  255,  /*    INSTEAD => ABORT */
  255,  /*     ISNULL => ABORT */
  255,  /*        KEY => ABORT */
  255,  /*  NK_BITNOT => ABORT */
  255,  /*    NK_SEMI => ABORT */
  255,  /*    NOTNULL => ABORT */
  255,  /*         OF => ABORT */
  255,  /*       PLUS => ABORT */
  255,  /*  PRIVILEGE => ABORT */
  255,  /*      RAISE => ABORT */
  255,  /*    REPLACE => ABORT */
  255,  /*   RESTRICT => ABORT */
  255,  /*        ROW => ABORT */
  255,  /*       SEMI => ABORT */
  255,  /*       STAR => ABORT */
  255,  /*  STATEMENT => ABORT */
  255,  /*     STRING => ABORT */
  255,  /*      TIMES => ABORT */
  255,  /*     UPDATE => ABORT */
  255,  /*     VALUES => ABORT */
  255,  /*   VARIABLE => ABORT */
  255,  /*       VIEW => ABORT */
  255,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "TRIM",
  /*   60 */ "IF",
  /*   61 */ "NOT",
  /*   62 */ "EXISTS",
  /*   63 */ "BUFFER",
  /*   64 */ "CACHEMODEL",
  /*   65 */ "CACHESIZE",
  /*   66 */ "COMP",
  /*   67 */ "DURATION",
  /*   68 */ "NK_VARIABLE",
  /*   69 */ "MAXROWS",
  /*   70 */ "MINROWS",
  /*   71 */ "KEEP",
  /*   72 */ "PAGES",
  /*   73 */ "PAGESIZE",
  /*   74 */ "PRECISION",
  /*   75 */ "REPLICA",
  /*   76 */ "STRICT",
  /*   77 */ "VGROUPS",
  /*   78 */ "SINGLE_STABLE",
  /*   79 */ "RETENTIONS",
  /*   80 */ "SCHEMALESS",
  /*   81 */ "WAL_LEVEL",
  /*   82 */ "WAL_FSYNC_PERIOD",
  /*   83 */ "WAL_RETENTION_PERIOD",
  /*   84 */ "WAL_RETENTION_SIZE",
  /*   85 */ "WAL_ROLL_PERIOD",
  /*   86 */ "WAL_SEGMENT_SIZE",
  /*   87 */ "SST_TRIGGER",
  /*   88 */ "TABLE_PREFIX",
  /*   89 */ "TABLE_SUFFIX",
  /*   90 */ "NK_COLON",
  /*   91 */ "TABLE",
  /*   92 */ "NK_LP",
  /*   93 */ "NK_RP",
  /*   94 */ "STABLE",
  /*   95 */ "ADD",
  /*   96 */ "COLUMN",
  /*   97 */ "MODIFY",
  /*   98 */ "RENAME",
  /*   99 */ "TAG",
  /*  100 */ "SET",
  /*  101 */ "NK_EQ",
  /*  102 */ "USING",
  /*  103 */ "TAGS",
  /*  104 */ "COMMENT",
  /*  105 */ "BOOL",
  /*  106 */ "TINYINT",
  /*  107 */ "SMALLINT",
  /*  108 */ "INT",
  /*  109 */ "INTEGER",
  /*  110 */ "BIGINT",
  /*  111 */ "FLOAT",
  /*  112 */ "DOUBLE",
  /*  113 */ "BINARY",
  /*  114 */ "TIMESTAMP",
  /*  115 */ "NCHAR",
  /*  116 */ "UNSIGNED",
  /*  117 */ "JSON",
  /*  118 */ "VARCHAR",
  /*  119 */ "MEDIUMBLOB",
  /*  120 */ "BLOB",
  /*  121 */ "VARBINARY",
  /*  122 */ "DECIMAL",
  /*  123 */ "MAX_DELAY",
  /*  124 */ "WATERMARK",
  /*  125 */ "ROLLUP",
  /*  126 */ "TTL",
  /*  127 */ "SMA",
  /*  128 */ "FIRST",
  /*  129 */ "LAST",
  /*  130 */ "SHOW",
  /*  131 */ "DATABASES",
  /*  132 */ "TABLES",
  /*  133 */ "STABLES",
  /*  134 */ "MNODES",
  /*  135 */ "MODULES",
  /*  136 */ "QNODES",
  /*  137 */ "FUNCTIONS",
  /*  138 */ "INDEXES",
  /*  139 */ "ACCOUNTS",
  /*  140 */ "APPS",
  /*  141 */ "CONNECTIONS",
  /*  142 */ "LICENCES",
  /*  143 */ "GRANTS",
  /*  144 */ "QUERIES",
  /*  145 */ "SCORES",
  /*  146 */ "TOPICS",
  /*  147 */ "VARIABLES",
  /*  148 */ "BNODES",
  /*  149 */ "SNODES",
  /*  150 */ "CLUSTER",
  /*  151 */ "TRANSACTIONS",
  /*  152 */ "DISTRIBUTED",
  /*  153 */ "CONSUMERS",
  /*  154 */ "SUBSCRIPTIONS",
  /*  155 */ "VNODES",
  /*  156 */ "LIKE",
  /*  157 */ "INDEX",
  /*  158 */ "FUNCTION",
  /*  159 */ "INTERVAL",
  /*  160 */ "TOPIC",
  /*  161 */ "AS",
  /*  162 */ "WITH",
  /*  163 */ "META",
  /*  164 */ "CONSUMER",
  /*  165 */ "GROUP",
  /*  166 */ "DESC",
  /*  167 */ "DESCRIBE",
  /*  168 */ "RESET",
  /*  169 */ "QUERY",
  /*  170 */ "CACHE",
  /*  171 */ "EXPLAIN",
  /*  172 */ "ANALYZE",
  /*  173 */ "VERBOSE",
  /*  174 */ "NK_BOOL",
  /*  175 */ "RATIO",
  /*  176 */ "NK_FLOAT",
  /*  177 */ "OUTPUTTYPE",
  /*  178 */ "AGGREGATE",
  /*  179 */ "BUFSIZE",
  /*  180 */ "STREAM",
  /*  181 */ "INTO",
  /*  182 */ "TRIGGER",
  /*  183 */ "AT_ONCE",
  /*  184 */ "WINDOW_CLOSE",
  /*  185 */ "IGNORE",
  /*  186 */ "EXPIRED",
  /*  187 */ "KILL",
  /*  188 */ "CONNECTION",
  /*  189 */ "TRANSACTION",
  /*  190 */ "BALANCE",
  /*  191 */ "VGROUP",
  /*  192 */ "MERGE",
  /*  193 */ "REDISTRIBUTE",
  /*  194 */ "SPLIT",
  /*  195 */ "DELETE",
  /*  196 */ "INSERT",
  /*  197 */ "NULL",
  /*  198 */ "NK_QUESTION",
  /*  199 */ "NK_ARROW",
  /*  200 */ "ROWTS",
  /*  201 */ "TBNAME",
  /*  202 */ "QSTART",
  /*  203 */ "QEND",
  /*  204 */ "QDURATION",
  /*  205 */ "WSTART",
  /*  206 */ "WEND",
  /*  207 */ "WDURATION",
  /*  208 */ "CAST",
  /*  209 */ "NOW",
  /*  210 */ "TODAY",
  /*  211 */ "TIMEZONE",
  /*  212 */ "CLIENT_VERSION",
  /*  213 */ "SERVER_VERSION",
  /*  214 */ "SERVER_STATUS",
  /*  215 */ "CURRENT_USER",
  /*  216 */ "COUNT",
  /*  217 */ "LAST_ROW",
  /*  218 */ "BETWEEN",
  /*  219 */ "IS",
  /*  220 */ "NK_LT",
  /*  221 */ "NK_GT",
  /*  222 */ "NK_LE",
  /*  223 */ "NK_GE",
  /*  224 */ "NK_NE",
  /*  225 */ "MATCH",
  /*  226 */ "NMATCH",
  /*  227 */ "CONTAINS",
  /*  228 */ "IN",
  /*  229 */ "JOIN",
  /*  230 */ "INNER",
  /*  231 */ "SELECT",
  /*  232 */ "DISTINCT",
  /*  233 */ "WHERE",
  /*  234 */ "PARTITION",
  /*  235 */ "BY",
  /*  236 */ "SESSION",
  /*  237 */ "STATE_WINDOW",
  /*  238 */ "SLIDING",
  /*  239 */ "FILL",
  /*  240 */ "VALUE",
  /*  241 */ "NONE",
  /*  242 */ "PREV",
  /*  243 */ "LINEAR",
  /*  244 */ "NEXT",
  /*  245 */ "HAVING",
  /*  246 */ "RANGE",
  /*  247 */ "EVERY",
  /*  248 */ "ORDER",
  /*  249 */ "SLIMIT",
  /*  250 */ "SOFFSET",
  /*  251 */ "LIMIT",
  /*  252 */ "OFFSET",
  /*  253 */ "ASC",
  /*  254 */ "NULLS",
  /*  255 */ "ABORT",
  /*  256 */ "AFTER",
  /*  257 */ "ATTACH",
  /*  258 */ "BEFORE",
  /*  259 */ "BEGIN",
  /*  260 */ "BITAND",
  /*  261 */ "BITNOT",
  /*  262 */ "BITOR",
  /*  263 */ "BLOCKS",
  /*  264 */ "CHANGE",
  /*  265 */ "COMMA",
  /*  266 */ "COMPACT",
  /*  267 */ "CONCAT",
  /*  268 */ "CONFLICT",
  /*  269 */ "COPY",
  /*  270 */ "DEFERRED",
  /*  271 */ "DELIMITERS",
  /*  272 */ "DETACH",
  /*  273 */ "DIVIDE",
  /*  274 */ "DOT",
  /*  275 */ "EACH",
  /*  276 */ "END",
  /*  277 */ "FAIL",
  /*  278 */ "FILE",
  /*  279 */ "FOR",
  /*  280 */ "GLOB",
  /*  281 */ "ID",
  /*  282 */ "IMMEDIATE",
  /*  283 */ "IMPORT",
  /*  284 */ "INITIALLY",
  /*  285 */ "INSTEAD",
  /*  286 */ "ISNULL",
  /*  287 */ "KEY",
  /*  288 */ "NK_BITNOT",
  /*  289 */ "NK_SEMI",
  /*  290 */ "NOTNULL",
  /*  291 */ "OF",
  /*  292 */ "PLUS",
  /*  293 */ "PRIVILEGE",
  /*  294 */ "RAISE",
  /*  295 */ "REPLACE",
  /*  296 */ "RESTRICT",
  /*  297 */ "ROW",
  /*  298 */ "SEMI",
  /*  299 */ "STAR",
  /*  300 */ "STATEMENT",
  /*  301 */ "STRING",
  /*  302 */ "TIMES",
  /*  303 */ "UPDATE",
  /*  304 */ "VALUES",
  /*  305 */ "VARIABLE",
  /*  306 */ "VIEW",
  /*  307 */ "WAL",
  /*  308 */ "cmd",
  /*  309 */ "account_options",
  /*  310 */ "alter_account_options",
  /*  311 */ "literal",
  /*  312 */ "alter_account_option",
  /*  313 */ "user_name",
  /*  314 */ "sysinfo_opt",
  /*  315 */ "privileges",
  /*  316 */ "priv_level",
  /*  317 */ "priv_type_list",
  /*  318 */ "priv_type",
  /*  319 */ "db_name",
  /*  320 */ "dnode_endpoint",
  /*  321 */ "not_exists_opt",
  /*  322 */ "db_options",
  /*  323 */ "exists_opt",
  /*  324 */ "alter_db_options",
  /*  325 */ "integer_list",
  /*  326 */ "variable_list",
  /*  327 */ "retention_list",
  /*  328 */ "alter_db_option",
  /*  329 */ "retention",
  /*  330 */ "full_table_name",
  /*  331 */ "column_def_list",
  /*  332 */ "tags_def_opt",
  /*  333 */ "table_options",
  /*  334 */ "multi_create_clause",
  /*  335 */ "tags_def",
  /*  336 */ "multi_drop_clause",
  /*  337 */ "alter_table_clause",
  /*  338 */ "alter_table_options",
  /*  339 */ "column_name",
  /*  340 */ "type_name",
  /*  341 */ "signed_literal",
  /*  342 */ "create_subtable_clause",
  /*  343 */ "specific_cols_opt",
  /*  344 */ "expression_list",
  /*  345 */ "drop_table_clause",
  /*  346 */ "col_name_list",
  /*  347 */ "table_name",
  /*  348 */ "column_def",
  /*  349 */ "duration_list",
  /*  350 */ "rollup_func_list",
  /*  351 */ "alter_table_option",
  /*  352 */ "duration_literal",
  /*  353 */ "rollup_func_name",
  /*  354 */ "function_name",
  /*  355 */ "col_name",
  /*  356 */ "db_name_cond_opt",
  /*  357 */ "like_pattern_opt",
  /*  358 */ "table_name_cond",
  /*  359 */ "from_db_opt",
  /*  360 */ "index_options",
  /*  361 */ "func_list",
  /*  362 */ "sliding_opt",
  /*  363 */ "sma_stream_opt",
  /*  364 */ "func",
  /*  365 */ "stream_options",
  /*  366 */ "topic_name",
  /*  367 */ "query_expression",
  /*  368 */ "cgroup_name",
  /*  369 */ "analyze_opt",
  /*  370 */ "explain_options",
  /*  371 */ "agg_func_opt",
  /*  372 */ "bufsize_opt",
  /*  373 */ "stream_name",
  /*  374 */ "dnode_list",
  /*  375 */ "where_clause_opt",
  /*  376 */ "signed",
  /*  377 */ "literal_func",
  /*  378 */ "literal_list",
  /*  379 */ "table_alias",
  /*  380 */ "column_alias",
  /*  381 */ "expression",
  /*  382 */ "pseudo_column",
  /*  383 */ "column_reference",
  /*  384 */ "function_expression",
  /*  385 */ "subquery",
  /*  386 */ "star_func",
  /*  387 */ "star_func_para_list",
  /*  388 */ "noarg_func",
  /*  389 */ "other_para_list",
  /*  390 */ "star_func_para",
  /*  391 */ "predicate",
  /*  392 */ "compare_op",
  /*  393 */ "in_op",
  /*  394 */ "in_predicate_value",
  /*  395 */ "boolean_value_expression",
  /*  396 */ "boolean_primary",
  /*  397 */ "common_expression",
  /*  398 */ "from_clause_opt",
  /*  399 */ "table_reference_list",
  /*  400 */ "table_reference",
  /*  401 */ "table_primary",
  /*  402 */ "joined_table",
  /*  403 */ "alias_opt",
  /*  404 */ "parenthesized_joined_table",
  /*  405 */ "join_type",
  /*  406 */ "search_condition",
  /*  407 */ "query_specification",
  /*  408 */ "set_quantifier_opt",
  /*  409 */ "select_list",
  /*  410 */ "partition_by_clause_opt",
  /*  411 */ "range_opt",
  /*  412 */ "every_opt",
  /*  413 */ "fill_opt",
  /*  414 */ "twindow_clause_opt",
  /*  415 */ "group_by_clause_opt",
  /*  416 */ "having_clause_opt",
  /*  417 */ "select_item",
  /*  418 */ "fill_mode",
  /*  419 */ "group_by_list",
  /*  420 */ "query_expression_body",
  /*  421 */ "order_by_clause_opt",
  /*  422 */ "slimit_clause_opt",
  /*  423 */ "limit_clause_opt",
  /*  424 */ "query_primary",
  /*  425 */ "sort_specification_list",
  /*  426 */ "sort_specification",
  /*  427 */ "ordering_specification_opt",
  /*  428 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "cmd ::= TRIM DATABASE db_name",
 /*  68 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  69 */ "not_exists_opt ::=",
 /*  70 */ "exists_opt ::= IF EXISTS",
 /*  71 */ "exists_opt ::=",
 /*  72 */ "db_options ::=",
 /*  73 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  75 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  76 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  78 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  79 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  80 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options KEEP integer_list",
 /*  82 */ "db_options ::= db_options KEEP variable_list",
 /*  83 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  84 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  85 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  86 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  87 */ "db_options ::= db_options STRICT NK_STRING",
 /*  88 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  89 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  90 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  91 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  92 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  93 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  94 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  95 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 100 */ "db_options ::= db_options SST_TRIGGER NK_INTEGER",
 /* 101 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 102 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 103 */ "alter_db_options ::= alter_db_option",
 /* 104 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 105 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 106 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 107 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 108 */ "alter_db_option ::= KEEP integer_list",
 /* 109 */ "alter_db_option ::= KEEP variable_list",
 /* 110 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 111 */ "alter_db_option ::= SST_TRIGGER NK_INTEGER",
 /* 112 */ "integer_list ::= NK_INTEGER",
 /* 113 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 114 */ "variable_list ::= NK_VARIABLE",
 /* 115 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 116 */ "retention_list ::= retention",
 /* 117 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 118 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 119 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 120 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 121 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 122 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 123 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 124 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 125 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 126 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 127 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 128 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 129 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 130 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 131 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 132 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 133 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 134 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 135 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 136 */ "multi_create_clause ::= create_subtable_clause",
 /* 137 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 138 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 139 */ "multi_drop_clause ::= drop_table_clause",
 /* 140 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 141 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 142 */ "specific_cols_opt ::=",
 /* 143 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 144 */ "full_table_name ::= table_name",
 /* 145 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 146 */ "column_def_list ::= column_def",
 /* 147 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 148 */ "column_def ::= column_name type_name",
 /* 149 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 150 */ "type_name ::= BOOL",
 /* 151 */ "type_name ::= TINYINT",
 /* 152 */ "type_name ::= SMALLINT",
 /* 153 */ "type_name ::= INT",
 /* 154 */ "type_name ::= INTEGER",
 /* 155 */ "type_name ::= BIGINT",
 /* 156 */ "type_name ::= FLOAT",
 /* 157 */ "type_name ::= DOUBLE",
 /* 158 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 159 */ "type_name ::= TIMESTAMP",
 /* 160 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 161 */ "type_name ::= TINYINT UNSIGNED",
 /* 162 */ "type_name ::= SMALLINT UNSIGNED",
 /* 163 */ "type_name ::= INT UNSIGNED",
 /* 164 */ "type_name ::= BIGINT UNSIGNED",
 /* 165 */ "type_name ::= JSON",
 /* 166 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 167 */ "type_name ::= MEDIUMBLOB",
 /* 168 */ "type_name ::= BLOB",
 /* 169 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= DECIMAL",
 /* 171 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 172 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 173 */ "tags_def_opt ::=",
 /* 174 */ "tags_def_opt ::= tags_def",
 /* 175 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 176 */ "table_options ::=",
 /* 177 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 178 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 179 */ "table_options ::= table_options WATERMARK duration_list",
 /* 180 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 181 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 182 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 183 */ "alter_table_options ::= alter_table_option",
 /* 184 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 185 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 186 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 187 */ "duration_list ::= duration_literal",
 /* 188 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 189 */ "rollup_func_list ::= rollup_func_name",
 /* 190 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 191 */ "rollup_func_name ::= function_name",
 /* 192 */ "rollup_func_name ::= FIRST",
 /* 193 */ "rollup_func_name ::= LAST",
 /* 194 */ "col_name_list ::= col_name",
 /* 195 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 196 */ "col_name ::= column_name",
 /* 197 */ "cmd ::= SHOW DNODES",
 /* 198 */ "cmd ::= SHOW USERS",
 /* 199 */ "cmd ::= SHOW DATABASES",
 /* 200 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 201 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 202 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 203 */ "cmd ::= SHOW MNODES",
 /* 204 */ "cmd ::= SHOW MODULES",
 /* 205 */ "cmd ::= SHOW QNODES",
 /* 206 */ "cmd ::= SHOW FUNCTIONS",
 /* 207 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 208 */ "cmd ::= SHOW STREAMS",
 /* 209 */ "cmd ::= SHOW ACCOUNTS",
 /* 210 */ "cmd ::= SHOW APPS",
 /* 211 */ "cmd ::= SHOW CONNECTIONS",
 /* 212 */ "cmd ::= SHOW LICENCES",
 /* 213 */ "cmd ::= SHOW GRANTS",
 /* 214 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 215 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 216 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 217 */ "cmd ::= SHOW QUERIES",
 /* 218 */ "cmd ::= SHOW SCORES",
 /* 219 */ "cmd ::= SHOW TOPICS",
 /* 220 */ "cmd ::= SHOW VARIABLES",
 /* 221 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 222 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 223 */ "cmd ::= SHOW BNODES",
 /* 224 */ "cmd ::= SHOW SNODES",
 /* 225 */ "cmd ::= SHOW CLUSTER",
 /* 226 */ "cmd ::= SHOW TRANSACTIONS",
 /* 227 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 228 */ "cmd ::= SHOW CONSUMERS",
 /* 229 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 230 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 231 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 232 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 233 */ "db_name_cond_opt ::=",
 /* 234 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 235 */ "like_pattern_opt ::=",
 /* 236 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 237 */ "table_name_cond ::= table_name",
 /* 238 */ "from_db_opt ::=",
 /* 239 */ "from_db_opt ::= FROM db_name",
 /* 240 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 241 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 242 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 243 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 244 */ "func_list ::= func",
 /* 245 */ "func_list ::= func_list NK_COMMA func",
 /* 246 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 247 */ "sma_stream_opt ::=",
 /* 248 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 249 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 250 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 251 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 252 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 253 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 254 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 255 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 256 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 257 */ "cmd ::= DESC full_table_name",
 /* 258 */ "cmd ::= DESCRIBE full_table_name",
 /* 259 */ "cmd ::= RESET QUERY CACHE",
 /* 260 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 261 */ "analyze_opt ::=",
 /* 262 */ "analyze_opt ::= ANALYZE",
 /* 263 */ "explain_options ::=",
 /* 264 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 265 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 266 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 267 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 268 */ "agg_func_opt ::=",
 /* 269 */ "agg_func_opt ::= AGGREGATE",
 /* 270 */ "bufsize_opt ::=",
 /* 271 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 272 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name AS query_expression",
 /* 273 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 274 */ "stream_options ::=",
 /* 275 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 276 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 277 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 278 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 279 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 280 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 281 */ "cmd ::= KILL QUERY NK_STRING",
 /* 282 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 283 */ "cmd ::= BALANCE VGROUP",
 /* 284 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 285 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 286 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 287 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 288 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 289 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 290 */ "cmd ::= query_expression",
 /* 291 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression",
 /* 292 */ "cmd ::= INSERT INTO full_table_name query_expression",
 /* 293 */ "literal ::= NK_INTEGER",
 /* 294 */ "literal ::= NK_FLOAT",
 /* 295 */ "literal ::= NK_STRING",
 /* 296 */ "literal ::= NK_BOOL",
 /* 297 */ "literal ::= TIMESTAMP NK_STRING",
 /* 298 */ "literal ::= duration_literal",
 /* 299 */ "literal ::= NULL",
 /* 300 */ "literal ::= NK_QUESTION",
 /* 301 */ "duration_literal ::= NK_VARIABLE",
 /* 302 */ "signed ::= NK_INTEGER",
 /* 303 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 304 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 305 */ "signed ::= NK_FLOAT",
 /* 306 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 307 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 308 */ "signed_literal ::= signed",
 /* 309 */ "signed_literal ::= NK_STRING",
 /* 310 */ "signed_literal ::= NK_BOOL",
 /* 311 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 312 */ "signed_literal ::= duration_literal",
 /* 313 */ "signed_literal ::= NULL",
 /* 314 */ "signed_literal ::= literal_func",
 /* 315 */ "signed_literal ::= NK_QUESTION",
 /* 316 */ "literal_list ::= signed_literal",
 /* 317 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 318 */ "db_name ::= NK_ID",
 /* 319 */ "table_name ::= NK_ID",
 /* 320 */ "column_name ::= NK_ID",
 /* 321 */ "function_name ::= NK_ID",
 /* 322 */ "table_alias ::= NK_ID",
 /* 323 */ "column_alias ::= NK_ID",
 /* 324 */ "user_name ::= NK_ID",
 /* 325 */ "topic_name ::= NK_ID",
 /* 326 */ "stream_name ::= NK_ID",
 /* 327 */ "cgroup_name ::= NK_ID",
 /* 328 */ "expression ::= literal",
 /* 329 */ "expression ::= pseudo_column",
 /* 330 */ "expression ::= column_reference",
 /* 331 */ "expression ::= function_expression",
 /* 332 */ "expression ::= subquery",
 /* 333 */ "expression ::= NK_LP expression NK_RP",
 /* 334 */ "expression ::= NK_PLUS expression",
 /* 335 */ "expression ::= NK_MINUS expression",
 /* 336 */ "expression ::= expression NK_PLUS expression",
 /* 337 */ "expression ::= expression NK_MINUS expression",
 /* 338 */ "expression ::= expression NK_STAR expression",
 /* 339 */ "expression ::= expression NK_SLASH expression",
 /* 340 */ "expression ::= expression NK_REM expression",
 /* 341 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 342 */ "expression ::= expression NK_BITAND expression",
 /* 343 */ "expression ::= expression NK_BITOR expression",
 /* 344 */ "expression_list ::= expression",
 /* 345 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 346 */ "column_reference ::= column_name",
 /* 347 */ "column_reference ::= table_name NK_DOT column_name",
 /* 348 */ "pseudo_column ::= ROWTS",
 /* 349 */ "pseudo_column ::= TBNAME",
 /* 350 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 351 */ "pseudo_column ::= QSTART",
 /* 352 */ "pseudo_column ::= QEND",
 /* 353 */ "pseudo_column ::= QDURATION",
 /* 354 */ "pseudo_column ::= WSTART",
 /* 355 */ "pseudo_column ::= WEND",
 /* 356 */ "pseudo_column ::= WDURATION",
 /* 357 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 358 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 359 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 360 */ "function_expression ::= literal_func",
 /* 361 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 362 */ "literal_func ::= NOW",
 /* 363 */ "noarg_func ::= NOW",
 /* 364 */ "noarg_func ::= TODAY",
 /* 365 */ "noarg_func ::= TIMEZONE",
 /* 366 */ "noarg_func ::= DATABASE",
 /* 367 */ "noarg_func ::= CLIENT_VERSION",
 /* 368 */ "noarg_func ::= SERVER_VERSION",
 /* 369 */ "noarg_func ::= SERVER_STATUS",
 /* 370 */ "noarg_func ::= CURRENT_USER",
 /* 371 */ "noarg_func ::= USER",
 /* 372 */ "star_func ::= COUNT",
 /* 373 */ "star_func ::= FIRST",
 /* 374 */ "star_func ::= LAST",
 /* 375 */ "star_func ::= LAST_ROW",
 /* 376 */ "star_func_para_list ::= NK_STAR",
 /* 377 */ "star_func_para_list ::= other_para_list",
 /* 378 */ "other_para_list ::= star_func_para",
 /* 379 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 380 */ "star_func_para ::= expression",
 /* 381 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 382 */ "predicate ::= expression compare_op expression",
 /* 383 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 384 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 385 */ "predicate ::= expression IS NULL",
 /* 386 */ "predicate ::= expression IS NOT NULL",
 /* 387 */ "predicate ::= expression in_op in_predicate_value",
 /* 388 */ "compare_op ::= NK_LT",
 /* 389 */ "compare_op ::= NK_GT",
 /* 390 */ "compare_op ::= NK_LE",
 /* 391 */ "compare_op ::= NK_GE",
 /* 392 */ "compare_op ::= NK_NE",
 /* 393 */ "compare_op ::= NK_EQ",
 /* 394 */ "compare_op ::= LIKE",
 /* 395 */ "compare_op ::= NOT LIKE",
 /* 396 */ "compare_op ::= MATCH",
 /* 397 */ "compare_op ::= NMATCH",
 /* 398 */ "compare_op ::= CONTAINS",
 /* 399 */ "in_op ::= IN",
 /* 400 */ "in_op ::= NOT IN",
 /* 401 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 402 */ "boolean_value_expression ::= boolean_primary",
 /* 403 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 404 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 405 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 406 */ "boolean_primary ::= predicate",
 /* 407 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 408 */ "common_expression ::= expression",
 /* 409 */ "common_expression ::= boolean_value_expression",
 /* 410 */ "from_clause_opt ::=",
 /* 411 */ "from_clause_opt ::= FROM table_reference_list",
 /* 412 */ "table_reference_list ::= table_reference",
 /* 413 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 414 */ "table_reference ::= table_primary",
 /* 415 */ "table_reference ::= joined_table",
 /* 416 */ "table_primary ::= table_name alias_opt",
 /* 417 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 418 */ "table_primary ::= subquery alias_opt",
 /* 419 */ "table_primary ::= parenthesized_joined_table",
 /* 420 */ "alias_opt ::=",
 /* 421 */ "alias_opt ::= table_alias",
 /* 422 */ "alias_opt ::= AS table_alias",
 /* 423 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 424 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 425 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 426 */ "join_type ::=",
 /* 427 */ "join_type ::= INNER",
 /* 428 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 429 */ "set_quantifier_opt ::=",
 /* 430 */ "set_quantifier_opt ::= DISTINCT",
 /* 431 */ "set_quantifier_opt ::= ALL",
 /* 432 */ "select_list ::= select_item",
 /* 433 */ "select_list ::= select_list NK_COMMA select_item",
 /* 434 */ "select_item ::= NK_STAR",
 /* 435 */ "select_item ::= common_expression",
 /* 436 */ "select_item ::= common_expression column_alias",
 /* 437 */ "select_item ::= common_expression AS column_alias",
 /* 438 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 439 */ "where_clause_opt ::=",
 /* 440 */ "where_clause_opt ::= WHERE search_condition",
 /* 441 */ "partition_by_clause_opt ::=",
 /* 442 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 443 */ "twindow_clause_opt ::=",
 /* 444 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 445 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 446 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 447 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 448 */ "sliding_opt ::=",
 /* 449 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 450 */ "fill_opt ::=",
 /* 451 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 452 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 453 */ "fill_mode ::= NONE",
 /* 454 */ "fill_mode ::= PREV",
 /* 455 */ "fill_mode ::= NULL",
 /* 456 */ "fill_mode ::= LINEAR",
 /* 457 */ "fill_mode ::= NEXT",
 /* 458 */ "group_by_clause_opt ::=",
 /* 459 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 460 */ "group_by_list ::= expression",
 /* 461 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 462 */ "having_clause_opt ::=",
 /* 463 */ "having_clause_opt ::= HAVING search_condition",
 /* 464 */ "range_opt ::=",
 /* 465 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 466 */ "every_opt ::=",
 /* 467 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 468 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 469 */ "query_expression_body ::= query_primary",
 /* 470 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 471 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 472 */ "query_primary ::= query_specification",
 /* 473 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 474 */ "order_by_clause_opt ::=",
 /* 475 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 476 */ "slimit_clause_opt ::=",
 /* 477 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 478 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 479 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 480 */ "limit_clause_opt ::=",
 /* 481 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 482 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 483 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 484 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 485 */ "search_condition ::= common_expression",
 /* 486 */ "sort_specification_list ::= sort_specification",
 /* 487 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 488 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 489 */ "ordering_specification_opt ::=",
 /* 490 */ "ordering_specification_opt ::= ASC",
 /* 491 */ "ordering_specification_opt ::= DESC",
 /* 492 */ "null_ordering_opt ::=",
 /* 493 */ "null_ordering_opt ::= NULLS FIRST",
 /* 494 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 308: /* cmd */
    case 311: /* literal */
    case 322: /* db_options */
    case 324: /* alter_db_options */
    case 329: /* retention */
    case 330: /* full_table_name */
    case 333: /* table_options */
    case 337: /* alter_table_clause */
    case 338: /* alter_table_options */
    case 341: /* signed_literal */
    case 342: /* create_subtable_clause */
    case 345: /* drop_table_clause */
    case 348: /* column_def */
    case 352: /* duration_literal */
    case 353: /* rollup_func_name */
    case 355: /* col_name */
    case 356: /* db_name_cond_opt */
    case 357: /* like_pattern_opt */
    case 358: /* table_name_cond */
    case 359: /* from_db_opt */
    case 360: /* index_options */
    case 362: /* sliding_opt */
    case 363: /* sma_stream_opt */
    case 364: /* func */
    case 365: /* stream_options */
    case 367: /* query_expression */
    case 370: /* explain_options */
    case 375: /* where_clause_opt */
    case 376: /* signed */
    case 377: /* literal_func */
    case 381: /* expression */
    case 382: /* pseudo_column */
    case 383: /* column_reference */
    case 384: /* function_expression */
    case 385: /* subquery */
    case 390: /* star_func_para */
    case 391: /* predicate */
    case 394: /* in_predicate_value */
    case 395: /* boolean_value_expression */
    case 396: /* boolean_primary */
    case 397: /* common_expression */
    case 398: /* from_clause_opt */
    case 399: /* table_reference_list */
    case 400: /* table_reference */
    case 401: /* table_primary */
    case 402: /* joined_table */
    case 404: /* parenthesized_joined_table */
    case 406: /* search_condition */
    case 407: /* query_specification */
    case 411: /* range_opt */
    case 412: /* every_opt */
    case 413: /* fill_opt */
    case 414: /* twindow_clause_opt */
    case 416: /* having_clause_opt */
    case 417: /* select_item */
    case 420: /* query_expression_body */
    case 422: /* slimit_clause_opt */
    case 423: /* limit_clause_opt */
    case 424: /* query_primary */
    case 426: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy80)); 
}
      break;
    case 309: /* account_options */
    case 310: /* alter_account_options */
    case 312: /* alter_account_option */
    case 372: /* bufsize_opt */
{
 
}
      break;
    case 313: /* user_name */
    case 316: /* priv_level */
    case 319: /* db_name */
    case 320: /* dnode_endpoint */
    case 339: /* column_name */
    case 347: /* table_name */
    case 354: /* function_name */
    case 366: /* topic_name */
    case 368: /* cgroup_name */
    case 373: /* stream_name */
    case 379: /* table_alias */
    case 380: /* column_alias */
    case 386: /* star_func */
    case 388: /* noarg_func */
    case 403: /* alias_opt */
{
 
}
      break;
    case 314: /* sysinfo_opt */
{
 
}
      break;
    case 315: /* privileges */
    case 317: /* priv_type_list */
    case 318: /* priv_type */
{
 
}
      break;
    case 321: /* not_exists_opt */
    case 323: /* exists_opt */
    case 369: /* analyze_opt */
    case 371: /* agg_func_opt */
    case 408: /* set_quantifier_opt */
{
 
}
      break;
    case 325: /* integer_list */
    case 326: /* variable_list */
    case 327: /* retention_list */
    case 331: /* column_def_list */
    case 332: /* tags_def_opt */
    case 334: /* multi_create_clause */
    case 335: /* tags_def */
    case 336: /* multi_drop_clause */
    case 343: /* specific_cols_opt */
    case 344: /* expression_list */
    case 346: /* col_name_list */
    case 349: /* duration_list */
    case 350: /* rollup_func_list */
    case 361: /* func_list */
    case 374: /* dnode_list */
    case 378: /* literal_list */
    case 387: /* star_func_para_list */
    case 389: /* other_para_list */
    case 409: /* select_list */
    case 410: /* partition_by_clause_opt */
    case 415: /* group_by_clause_opt */
    case 419: /* group_by_list */
    case 421: /* order_by_clause_opt */
    case 425: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy574)); 
}
      break;
    case 328: /* alter_db_option */
    case 351: /* alter_table_option */
{
 
}
      break;
    case 340: /* type_name */
{
 
}
      break;
    case 392: /* compare_op */
    case 393: /* in_op */
{
 
}
      break;
    case 405: /* join_type */
{
 
}
      break;
    case 418: /* fill_mode */
{
 
}
      break;
    case 427: /* ordering_specification_opt */
{
 
}
      break;
    case 428: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  308,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  308,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  309,    0 }, /* (2) account_options ::= */
  {  309,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  309,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  309,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  309,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  309,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  309,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  309,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  309,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  309,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  310,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  310,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  312,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  312,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  312,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  312,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  312,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  312,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  312,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  312,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  312,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  312,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  308,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  308,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  308,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  308,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  308,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  314,    0 }, /* (29) sysinfo_opt ::= */
  {  314,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  308,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  308,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  315,   -1 }, /* (33) privileges ::= ALL */
  {  315,   -1 }, /* (34) privileges ::= priv_type_list */
  {  317,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  317,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  318,   -1 }, /* (37) priv_type ::= READ */
  {  318,   -1 }, /* (38) priv_type ::= WRITE */
  {  316,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  316,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  308,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  308,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  308,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  308,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  308,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  308,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  308,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  308,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  320,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  320,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  320,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  308,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  308,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  308,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  308,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  308,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  308,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  308,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  308,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  308,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  308,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  308,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  308,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  308,   -2 }, /* (64) cmd ::= USE db_name */
  {  308,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  308,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  308,   -3 }, /* (67) cmd ::= TRIM DATABASE db_name */
  {  321,   -3 }, /* (68) not_exists_opt ::= IF NOT EXISTS */
  {  321,    0 }, /* (69) not_exists_opt ::= */
  {  323,   -2 }, /* (70) exists_opt ::= IF EXISTS */
  {  323,    0 }, /* (71) exists_opt ::= */
  {  322,    0 }, /* (72) db_options ::= */
  {  322,   -3 }, /* (73) db_options ::= db_options BUFFER NK_INTEGER */
  {  322,   -3 }, /* (74) db_options ::= db_options CACHEMODEL NK_STRING */
  {  322,   -3 }, /* (75) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  322,   -3 }, /* (76) db_options ::= db_options COMP NK_INTEGER */
  {  322,   -3 }, /* (77) db_options ::= db_options DURATION NK_INTEGER */
  {  322,   -3 }, /* (78) db_options ::= db_options DURATION NK_VARIABLE */
  {  322,   -3 }, /* (79) db_options ::= db_options MAXROWS NK_INTEGER */
  {  322,   -3 }, /* (80) db_options ::= db_options MINROWS NK_INTEGER */
  {  322,   -3 }, /* (81) db_options ::= db_options KEEP integer_list */
  {  322,   -3 }, /* (82) db_options ::= db_options KEEP variable_list */
  {  322,   -3 }, /* (83) db_options ::= db_options PAGES NK_INTEGER */
  {  322,   -3 }, /* (84) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  322,   -3 }, /* (85) db_options ::= db_options PRECISION NK_STRING */
  {  322,   -3 }, /* (86) db_options ::= db_options REPLICA NK_INTEGER */
  {  322,   -3 }, /* (87) db_options ::= db_options STRICT NK_STRING */
  {  322,   -3 }, /* (88) db_options ::= db_options VGROUPS NK_INTEGER */
  {  322,   -3 }, /* (89) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  322,   -3 }, /* (90) db_options ::= db_options RETENTIONS retention_list */
  {  322,   -3 }, /* (91) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  322,   -3 }, /* (92) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  322,   -3 }, /* (93) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  322,   -3 }, /* (94) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  322,   -4 }, /* (95) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  322,   -3 }, /* (96) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  322,   -4 }, /* (97) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  322,   -3 }, /* (98) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  322,   -3 }, /* (99) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  322,   -3 }, /* (100) db_options ::= db_options SST_TRIGGER NK_INTEGER */
  {  322,   -3 }, /* (101) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  322,   -3 }, /* (102) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  324,   -1 }, /* (103) alter_db_options ::= alter_db_option */
  {  324,   -2 }, /* (104) alter_db_options ::= alter_db_options alter_db_option */
  {  328,   -2 }, /* (105) alter_db_option ::= CACHEMODEL NK_STRING */
  {  328,   -2 }, /* (106) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  328,   -2 }, /* (107) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  328,   -2 }, /* (108) alter_db_option ::= KEEP integer_list */
  {  328,   -2 }, /* (109) alter_db_option ::= KEEP variable_list */
  {  328,   -2 }, /* (110) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  328,   -2 }, /* (111) alter_db_option ::= SST_TRIGGER NK_INTEGER */
  {  325,   -1 }, /* (112) integer_list ::= NK_INTEGER */
  {  325,   -3 }, /* (113) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  326,   -1 }, /* (114) variable_list ::= NK_VARIABLE */
  {  326,   -3 }, /* (115) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  327,   -1 }, /* (116) retention_list ::= retention */
  {  327,   -3 }, /* (117) retention_list ::= retention_list NK_COMMA retention */
  {  329,   -3 }, /* (118) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  308,   -9 }, /* (119) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  308,   -3 }, /* (120) cmd ::= CREATE TABLE multi_create_clause */
  {  308,   -9 }, /* (121) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  308,   -3 }, /* (122) cmd ::= DROP TABLE multi_drop_clause */
  {  308,   -4 }, /* (123) cmd ::= DROP STABLE exists_opt full_table_name */
  {  308,   -3 }, /* (124) cmd ::= ALTER TABLE alter_table_clause */
  {  308,   -3 }, /* (125) cmd ::= ALTER STABLE alter_table_clause */
  {  337,   -2 }, /* (126) alter_table_clause ::= full_table_name alter_table_options */
  {  337,   -5 }, /* (127) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  337,   -4 }, /* (128) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  337,   -5 }, /* (129) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  337,   -5 }, /* (130) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  337,   -5 }, /* (131) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  337,   -4 }, /* (132) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  337,   -5 }, /* (133) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  337,   -5 }, /* (134) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  337,   -6 }, /* (135) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  334,   -1 }, /* (136) multi_create_clause ::= create_subtable_clause */
  {  334,   -2 }, /* (137) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  342,  -10 }, /* (138) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  336,   -1 }, /* (139) multi_drop_clause ::= drop_table_clause */
  {  336,   -2 }, /* (140) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  345,   -2 }, /* (141) drop_table_clause ::= exists_opt full_table_name */
  {  343,    0 }, /* (142) specific_cols_opt ::= */
  {  343,   -3 }, /* (143) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  330,   -1 }, /* (144) full_table_name ::= table_name */
  {  330,   -3 }, /* (145) full_table_name ::= db_name NK_DOT table_name */
  {  331,   -1 }, /* (146) column_def_list ::= column_def */
  {  331,   -3 }, /* (147) column_def_list ::= column_def_list NK_COMMA column_def */
  {  348,   -2 }, /* (148) column_def ::= column_name type_name */
  {  348,   -4 }, /* (149) column_def ::= column_name type_name COMMENT NK_STRING */
  {  340,   -1 }, /* (150) type_name ::= BOOL */
  {  340,   -1 }, /* (151) type_name ::= TINYINT */
  {  340,   -1 }, /* (152) type_name ::= SMALLINT */
  {  340,   -1 }, /* (153) type_name ::= INT */
  {  340,   -1 }, /* (154) type_name ::= INTEGER */
  {  340,   -1 }, /* (155) type_name ::= BIGINT */
  {  340,   -1 }, /* (156) type_name ::= FLOAT */
  {  340,   -1 }, /* (157) type_name ::= DOUBLE */
  {  340,   -4 }, /* (158) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  340,   -1 }, /* (159) type_name ::= TIMESTAMP */
  {  340,   -4 }, /* (160) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  340,   -2 }, /* (161) type_name ::= TINYINT UNSIGNED */
  {  340,   -2 }, /* (162) type_name ::= SMALLINT UNSIGNED */
  {  340,   -2 }, /* (163) type_name ::= INT UNSIGNED */
  {  340,   -2 }, /* (164) type_name ::= BIGINT UNSIGNED */
  {  340,   -1 }, /* (165) type_name ::= JSON */
  {  340,   -4 }, /* (166) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  340,   -1 }, /* (167) type_name ::= MEDIUMBLOB */
  {  340,   -1 }, /* (168) type_name ::= BLOB */
  {  340,   -4 }, /* (169) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  340,   -1 }, /* (170) type_name ::= DECIMAL */
  {  340,   -4 }, /* (171) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  340,   -6 }, /* (172) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  332,    0 }, /* (173) tags_def_opt ::= */
  {  332,   -1 }, /* (174) tags_def_opt ::= tags_def */
  {  335,   -4 }, /* (175) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  333,    0 }, /* (176) table_options ::= */
  {  333,   -3 }, /* (177) table_options ::= table_options COMMENT NK_STRING */
  {  333,   -3 }, /* (178) table_options ::= table_options MAX_DELAY duration_list */
  {  333,   -3 }, /* (179) table_options ::= table_options WATERMARK duration_list */
  {  333,   -5 }, /* (180) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  333,   -3 }, /* (181) table_options ::= table_options TTL NK_INTEGER */
  {  333,   -5 }, /* (182) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  338,   -1 }, /* (183) alter_table_options ::= alter_table_option */
  {  338,   -2 }, /* (184) alter_table_options ::= alter_table_options alter_table_option */
  {  351,   -2 }, /* (185) alter_table_option ::= COMMENT NK_STRING */
  {  351,   -2 }, /* (186) alter_table_option ::= TTL NK_INTEGER */
  {  349,   -1 }, /* (187) duration_list ::= duration_literal */
  {  349,   -3 }, /* (188) duration_list ::= duration_list NK_COMMA duration_literal */
  {  350,   -1 }, /* (189) rollup_func_list ::= rollup_func_name */
  {  350,   -3 }, /* (190) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  353,   -1 }, /* (191) rollup_func_name ::= function_name */
  {  353,   -1 }, /* (192) rollup_func_name ::= FIRST */
  {  353,   -1 }, /* (193) rollup_func_name ::= LAST */
  {  346,   -1 }, /* (194) col_name_list ::= col_name */
  {  346,   -3 }, /* (195) col_name_list ::= col_name_list NK_COMMA col_name */
  {  355,   -1 }, /* (196) col_name ::= column_name */
  {  308,   -2 }, /* (197) cmd ::= SHOW DNODES */
  {  308,   -2 }, /* (198) cmd ::= SHOW USERS */
  {  308,   -2 }, /* (199) cmd ::= SHOW DATABASES */
  {  308,   -4 }, /* (200) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  308,   -4 }, /* (201) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  308,   -3 }, /* (202) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  308,   -2 }, /* (203) cmd ::= SHOW MNODES */
  {  308,   -2 }, /* (204) cmd ::= SHOW MODULES */
  {  308,   -2 }, /* (205) cmd ::= SHOW QNODES */
  {  308,   -2 }, /* (206) cmd ::= SHOW FUNCTIONS */
  {  308,   -5 }, /* (207) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  308,   -2 }, /* (208) cmd ::= SHOW STREAMS */
  {  308,   -2 }, /* (209) cmd ::= SHOW ACCOUNTS */
  {  308,   -2 }, /* (210) cmd ::= SHOW APPS */
  {  308,   -2 }, /* (211) cmd ::= SHOW CONNECTIONS */
  {  308,   -2 }, /* (212) cmd ::= SHOW LICENCES */
  {  308,   -2 }, /* (213) cmd ::= SHOW GRANTS */
  {  308,   -4 }, /* (214) cmd ::= SHOW CREATE DATABASE db_name */
  {  308,   -4 }, /* (215) cmd ::= SHOW CREATE TABLE full_table_name */
  {  308,   -4 }, /* (216) cmd ::= SHOW CREATE STABLE full_table_name */
  {  308,   -2 }, /* (217) cmd ::= SHOW QUERIES */
  {  308,   -2 }, /* (218) cmd ::= SHOW SCORES */
  {  308,   -2 }, /* (219) cmd ::= SHOW TOPICS */
  {  308,   -2 }, /* (220) cmd ::= SHOW VARIABLES */
  {  308,   -3 }, /* (221) cmd ::= SHOW LOCAL VARIABLES */
  {  308,   -4 }, /* (222) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  308,   -2 }, /* (223) cmd ::= SHOW BNODES */
  {  308,   -2 }, /* (224) cmd ::= SHOW SNODES */
  {  308,   -2 }, /* (225) cmd ::= SHOW CLUSTER */
  {  308,   -2 }, /* (226) cmd ::= SHOW TRANSACTIONS */
  {  308,   -4 }, /* (227) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  308,   -2 }, /* (228) cmd ::= SHOW CONSUMERS */
  {  308,   -2 }, /* (229) cmd ::= SHOW SUBSCRIPTIONS */
  {  308,   -5 }, /* (230) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  308,   -3 }, /* (231) cmd ::= SHOW VNODES NK_INTEGER */
  {  308,   -3 }, /* (232) cmd ::= SHOW VNODES NK_STRING */
  {  356,    0 }, /* (233) db_name_cond_opt ::= */
  {  356,   -2 }, /* (234) db_name_cond_opt ::= db_name NK_DOT */
  {  357,    0 }, /* (235) like_pattern_opt ::= */
  {  357,   -2 }, /* (236) like_pattern_opt ::= LIKE NK_STRING */
  {  358,   -1 }, /* (237) table_name_cond ::= table_name */
  {  359,    0 }, /* (238) from_db_opt ::= */
  {  359,   -2 }, /* (239) from_db_opt ::= FROM db_name */
  {  308,   -8 }, /* (240) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  308,   -4 }, /* (241) cmd ::= DROP INDEX exists_opt full_table_name */
  {  360,  -10 }, /* (242) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  360,  -12 }, /* (243) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  361,   -1 }, /* (244) func_list ::= func */
  {  361,   -3 }, /* (245) func_list ::= func_list NK_COMMA func */
  {  364,   -4 }, /* (246) func ::= function_name NK_LP expression_list NK_RP */
  {  363,    0 }, /* (247) sma_stream_opt ::= */
  {  363,   -3 }, /* (248) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  363,   -3 }, /* (249) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  308,   -6 }, /* (250) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  308,   -7 }, /* (251) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  308,   -9 }, /* (252) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  308,   -7 }, /* (253) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  308,   -9 }, /* (254) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  308,   -4 }, /* (255) cmd ::= DROP TOPIC exists_opt topic_name */
  {  308,   -7 }, /* (256) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  308,   -2 }, /* (257) cmd ::= DESC full_table_name */
  {  308,   -2 }, /* (258) cmd ::= DESCRIBE full_table_name */
  {  308,   -3 }, /* (259) cmd ::= RESET QUERY CACHE */
  {  308,   -4 }, /* (260) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  369,    0 }, /* (261) analyze_opt ::= */
  {  369,   -1 }, /* (262) analyze_opt ::= ANALYZE */
  {  370,    0 }, /* (263) explain_options ::= */
  {  370,   -3 }, /* (264) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  370,   -3 }, /* (265) explain_options ::= explain_options RATIO NK_FLOAT */
  {  308,  -10 }, /* (266) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  308,   -4 }, /* (267) cmd ::= DROP FUNCTION exists_opt function_name */
  {  371,    0 }, /* (268) agg_func_opt ::= */
  {  371,   -1 }, /* (269) agg_func_opt ::= AGGREGATE */
  {  372,    0 }, /* (270) bufsize_opt ::= */
  {  372,   -2 }, /* (271) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  308,   -9 }, /* (272) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name AS query_expression */
  {  308,   -4 }, /* (273) cmd ::= DROP STREAM exists_opt stream_name */
  {  365,    0 }, /* (274) stream_options ::= */
  {  365,   -3 }, /* (275) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  365,   -3 }, /* (276) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  365,   -4 }, /* (277) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  365,   -3 }, /* (278) stream_options ::= stream_options WATERMARK duration_literal */
  {  365,   -4 }, /* (279) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  308,   -3 }, /* (280) cmd ::= KILL CONNECTION NK_INTEGER */
  {  308,   -3 }, /* (281) cmd ::= KILL QUERY NK_STRING */
  {  308,   -3 }, /* (282) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  308,   -2 }, /* (283) cmd ::= BALANCE VGROUP */
  {  308,   -4 }, /* (284) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  308,   -4 }, /* (285) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  308,   -3 }, /* (286) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  374,   -2 }, /* (287) dnode_list ::= DNODE NK_INTEGER */
  {  374,   -3 }, /* (288) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  308,   -4 }, /* (289) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  308,   -1 }, /* (290) cmd ::= query_expression */
  {  308,   -7 }, /* (291) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression */
  {  308,   -4 }, /* (292) cmd ::= INSERT INTO full_table_name query_expression */
  {  311,   -1 }, /* (293) literal ::= NK_INTEGER */
  {  311,   -1 }, /* (294) literal ::= NK_FLOAT */
  {  311,   -1 }, /* (295) literal ::= NK_STRING */
  {  311,   -1 }, /* (296) literal ::= NK_BOOL */
  {  311,   -2 }, /* (297) literal ::= TIMESTAMP NK_STRING */
  {  311,   -1 }, /* (298) literal ::= duration_literal */
  {  311,   -1 }, /* (299) literal ::= NULL */
  {  311,   -1 }, /* (300) literal ::= NK_QUESTION */
  {  352,   -1 }, /* (301) duration_literal ::= NK_VARIABLE */
  {  376,   -1 }, /* (302) signed ::= NK_INTEGER */
  {  376,   -2 }, /* (303) signed ::= NK_PLUS NK_INTEGER */
  {  376,   -2 }, /* (304) signed ::= NK_MINUS NK_INTEGER */
  {  376,   -1 }, /* (305) signed ::= NK_FLOAT */
  {  376,   -2 }, /* (306) signed ::= NK_PLUS NK_FLOAT */
  {  376,   -2 }, /* (307) signed ::= NK_MINUS NK_FLOAT */
  {  341,   -1 }, /* (308) signed_literal ::= signed */
  {  341,   -1 }, /* (309) signed_literal ::= NK_STRING */
  {  341,   -1 }, /* (310) signed_literal ::= NK_BOOL */
  {  341,   -2 }, /* (311) signed_literal ::= TIMESTAMP NK_STRING */
  {  341,   -1 }, /* (312) signed_literal ::= duration_literal */
  {  341,   -1 }, /* (313) signed_literal ::= NULL */
  {  341,   -1 }, /* (314) signed_literal ::= literal_func */
  {  341,   -1 }, /* (315) signed_literal ::= NK_QUESTION */
  {  378,   -1 }, /* (316) literal_list ::= signed_literal */
  {  378,   -3 }, /* (317) literal_list ::= literal_list NK_COMMA signed_literal */
  {  319,   -1 }, /* (318) db_name ::= NK_ID */
  {  347,   -1 }, /* (319) table_name ::= NK_ID */
  {  339,   -1 }, /* (320) column_name ::= NK_ID */
  {  354,   -1 }, /* (321) function_name ::= NK_ID */
  {  379,   -1 }, /* (322) table_alias ::= NK_ID */
  {  380,   -1 }, /* (323) column_alias ::= NK_ID */
  {  313,   -1 }, /* (324) user_name ::= NK_ID */
  {  366,   -1 }, /* (325) topic_name ::= NK_ID */
  {  373,   -1 }, /* (326) stream_name ::= NK_ID */
  {  368,   -1 }, /* (327) cgroup_name ::= NK_ID */
  {  381,   -1 }, /* (328) expression ::= literal */
  {  381,   -1 }, /* (329) expression ::= pseudo_column */
  {  381,   -1 }, /* (330) expression ::= column_reference */
  {  381,   -1 }, /* (331) expression ::= function_expression */
  {  381,   -1 }, /* (332) expression ::= subquery */
  {  381,   -3 }, /* (333) expression ::= NK_LP expression NK_RP */
  {  381,   -2 }, /* (334) expression ::= NK_PLUS expression */
  {  381,   -2 }, /* (335) expression ::= NK_MINUS expression */
  {  381,   -3 }, /* (336) expression ::= expression NK_PLUS expression */
  {  381,   -3 }, /* (337) expression ::= expression NK_MINUS expression */
  {  381,   -3 }, /* (338) expression ::= expression NK_STAR expression */
  {  381,   -3 }, /* (339) expression ::= expression NK_SLASH expression */
  {  381,   -3 }, /* (340) expression ::= expression NK_REM expression */
  {  381,   -3 }, /* (341) expression ::= column_reference NK_ARROW NK_STRING */
  {  381,   -3 }, /* (342) expression ::= expression NK_BITAND expression */
  {  381,   -3 }, /* (343) expression ::= expression NK_BITOR expression */
  {  344,   -1 }, /* (344) expression_list ::= expression */
  {  344,   -3 }, /* (345) expression_list ::= expression_list NK_COMMA expression */
  {  383,   -1 }, /* (346) column_reference ::= column_name */
  {  383,   -3 }, /* (347) column_reference ::= table_name NK_DOT column_name */
  {  382,   -1 }, /* (348) pseudo_column ::= ROWTS */
  {  382,   -1 }, /* (349) pseudo_column ::= TBNAME */
  {  382,   -3 }, /* (350) pseudo_column ::= table_name NK_DOT TBNAME */
  {  382,   -1 }, /* (351) pseudo_column ::= QSTART */
  {  382,   -1 }, /* (352) pseudo_column ::= QEND */
  {  382,   -1 }, /* (353) pseudo_column ::= QDURATION */
  {  382,   -1 }, /* (354) pseudo_column ::= WSTART */
  {  382,   -1 }, /* (355) pseudo_column ::= WEND */
  {  382,   -1 }, /* (356) pseudo_column ::= WDURATION */
  {  384,   -4 }, /* (357) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  384,   -4 }, /* (358) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  384,   -6 }, /* (359) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  384,   -1 }, /* (360) function_expression ::= literal_func */
  {  377,   -3 }, /* (361) literal_func ::= noarg_func NK_LP NK_RP */
  {  377,   -1 }, /* (362) literal_func ::= NOW */
  {  388,   -1 }, /* (363) noarg_func ::= NOW */
  {  388,   -1 }, /* (364) noarg_func ::= TODAY */
  {  388,   -1 }, /* (365) noarg_func ::= TIMEZONE */
  {  388,   -1 }, /* (366) noarg_func ::= DATABASE */
  {  388,   -1 }, /* (367) noarg_func ::= CLIENT_VERSION */
  {  388,   -1 }, /* (368) noarg_func ::= SERVER_VERSION */
  {  388,   -1 }, /* (369) noarg_func ::= SERVER_STATUS */
  {  388,   -1 }, /* (370) noarg_func ::= CURRENT_USER */
  {  388,   -1 }, /* (371) noarg_func ::= USER */
  {  386,   -1 }, /* (372) star_func ::= COUNT */
  {  386,   -1 }, /* (373) star_func ::= FIRST */
  {  386,   -1 }, /* (374) star_func ::= LAST */
  {  386,   -1 }, /* (375) star_func ::= LAST_ROW */
  {  387,   -1 }, /* (376) star_func_para_list ::= NK_STAR */
  {  387,   -1 }, /* (377) star_func_para_list ::= other_para_list */
  {  389,   -1 }, /* (378) other_para_list ::= star_func_para */
  {  389,   -3 }, /* (379) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  390,   -1 }, /* (380) star_func_para ::= expression */
  {  390,   -3 }, /* (381) star_func_para ::= table_name NK_DOT NK_STAR */
  {  391,   -3 }, /* (382) predicate ::= expression compare_op expression */
  {  391,   -5 }, /* (383) predicate ::= expression BETWEEN expression AND expression */
  {  391,   -6 }, /* (384) predicate ::= expression NOT BETWEEN expression AND expression */
  {  391,   -3 }, /* (385) predicate ::= expression IS NULL */
  {  391,   -4 }, /* (386) predicate ::= expression IS NOT NULL */
  {  391,   -3 }, /* (387) predicate ::= expression in_op in_predicate_value */
  {  392,   -1 }, /* (388) compare_op ::= NK_LT */
  {  392,   -1 }, /* (389) compare_op ::= NK_GT */
  {  392,   -1 }, /* (390) compare_op ::= NK_LE */
  {  392,   -1 }, /* (391) compare_op ::= NK_GE */
  {  392,   -1 }, /* (392) compare_op ::= NK_NE */
  {  392,   -1 }, /* (393) compare_op ::= NK_EQ */
  {  392,   -1 }, /* (394) compare_op ::= LIKE */
  {  392,   -2 }, /* (395) compare_op ::= NOT LIKE */
  {  392,   -1 }, /* (396) compare_op ::= MATCH */
  {  392,   -1 }, /* (397) compare_op ::= NMATCH */
  {  392,   -1 }, /* (398) compare_op ::= CONTAINS */
  {  393,   -1 }, /* (399) in_op ::= IN */
  {  393,   -2 }, /* (400) in_op ::= NOT IN */
  {  394,   -3 }, /* (401) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  395,   -1 }, /* (402) boolean_value_expression ::= boolean_primary */
  {  395,   -2 }, /* (403) boolean_value_expression ::= NOT boolean_primary */
  {  395,   -3 }, /* (404) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  395,   -3 }, /* (405) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  396,   -1 }, /* (406) boolean_primary ::= predicate */
  {  396,   -3 }, /* (407) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  397,   -1 }, /* (408) common_expression ::= expression */
  {  397,   -1 }, /* (409) common_expression ::= boolean_value_expression */
  {  398,    0 }, /* (410) from_clause_opt ::= */
  {  398,   -2 }, /* (411) from_clause_opt ::= FROM table_reference_list */
  {  399,   -1 }, /* (412) table_reference_list ::= table_reference */
  {  399,   -3 }, /* (413) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  400,   -1 }, /* (414) table_reference ::= table_primary */
  {  400,   -1 }, /* (415) table_reference ::= joined_table */
  {  401,   -2 }, /* (416) table_primary ::= table_name alias_opt */
  {  401,   -4 }, /* (417) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  401,   -2 }, /* (418) table_primary ::= subquery alias_opt */
  {  401,   -1 }, /* (419) table_primary ::= parenthesized_joined_table */
  {  403,    0 }, /* (420) alias_opt ::= */
  {  403,   -1 }, /* (421) alias_opt ::= table_alias */
  {  403,   -2 }, /* (422) alias_opt ::= AS table_alias */
  {  404,   -3 }, /* (423) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  404,   -3 }, /* (424) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  402,   -6 }, /* (425) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  405,    0 }, /* (426) join_type ::= */
  {  405,   -1 }, /* (427) join_type ::= INNER */
  {  407,  -12 }, /* (428) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  408,    0 }, /* (429) set_quantifier_opt ::= */
  {  408,   -1 }, /* (430) set_quantifier_opt ::= DISTINCT */
  {  408,   -1 }, /* (431) set_quantifier_opt ::= ALL */
  {  409,   -1 }, /* (432) select_list ::= select_item */
  {  409,   -3 }, /* (433) select_list ::= select_list NK_COMMA select_item */
  {  417,   -1 }, /* (434) select_item ::= NK_STAR */
  {  417,   -1 }, /* (435) select_item ::= common_expression */
  {  417,   -2 }, /* (436) select_item ::= common_expression column_alias */
  {  417,   -3 }, /* (437) select_item ::= common_expression AS column_alias */
  {  417,   -3 }, /* (438) select_item ::= table_name NK_DOT NK_STAR */
  {  375,    0 }, /* (439) where_clause_opt ::= */
  {  375,   -2 }, /* (440) where_clause_opt ::= WHERE search_condition */
  {  410,    0 }, /* (441) partition_by_clause_opt ::= */
  {  410,   -3 }, /* (442) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  414,    0 }, /* (443) twindow_clause_opt ::= */
  {  414,   -6 }, /* (444) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  414,   -4 }, /* (445) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  414,   -6 }, /* (446) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  414,   -8 }, /* (447) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  362,    0 }, /* (448) sliding_opt ::= */
  {  362,   -4 }, /* (449) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  413,    0 }, /* (450) fill_opt ::= */
  {  413,   -4 }, /* (451) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  413,   -6 }, /* (452) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  418,   -1 }, /* (453) fill_mode ::= NONE */
  {  418,   -1 }, /* (454) fill_mode ::= PREV */
  {  418,   -1 }, /* (455) fill_mode ::= NULL */
  {  418,   -1 }, /* (456) fill_mode ::= LINEAR */
  {  418,   -1 }, /* (457) fill_mode ::= NEXT */
  {  415,    0 }, /* (458) group_by_clause_opt ::= */
  {  415,   -3 }, /* (459) group_by_clause_opt ::= GROUP BY group_by_list */
  {  419,   -1 }, /* (460) group_by_list ::= expression */
  {  419,   -3 }, /* (461) group_by_list ::= group_by_list NK_COMMA expression */
  {  416,    0 }, /* (462) having_clause_opt ::= */
  {  416,   -2 }, /* (463) having_clause_opt ::= HAVING search_condition */
  {  411,    0 }, /* (464) range_opt ::= */
  {  411,   -6 }, /* (465) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  412,    0 }, /* (466) every_opt ::= */
  {  412,   -4 }, /* (467) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  367,   -4 }, /* (468) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  420,   -1 }, /* (469) query_expression_body ::= query_primary */
  {  420,   -4 }, /* (470) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  420,   -3 }, /* (471) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  424,   -1 }, /* (472) query_primary ::= query_specification */
  {  424,   -6 }, /* (473) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  421,    0 }, /* (474) order_by_clause_opt ::= */
  {  421,   -3 }, /* (475) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  422,    0 }, /* (476) slimit_clause_opt ::= */
  {  422,   -2 }, /* (477) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  422,   -4 }, /* (478) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  422,   -4 }, /* (479) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  423,    0 }, /* (480) limit_clause_opt ::= */
  {  423,   -2 }, /* (481) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  423,   -4 }, /* (482) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  423,   -4 }, /* (483) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  385,   -3 }, /* (484) subquery ::= NK_LP query_expression NK_RP */
  {  406,   -1 }, /* (485) search_condition ::= common_expression */
  {  425,   -1 }, /* (486) sort_specification_list ::= sort_specification */
  {  425,   -3 }, /* (487) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  426,   -3 }, /* (488) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  427,    0 }, /* (489) ordering_specification_opt ::= */
  {  427,   -1 }, /* (490) ordering_specification_opt ::= ASC */
  {  427,   -1 }, /* (491) ordering_specification_opt ::= DESC */
  {  428,    0 }, /* (492) null_ordering_opt ::= */
  {  428,   -2 }, /* (493) null_ordering_opt ::= NULLS FIRST */
  {  428,   -2 }, /* (494) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,309,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,310,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,309,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,311,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,312,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,310,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,312,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,311,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy239, &yymsp[-1].minor.yy0, yymsp[0].minor.yy509); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy239, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy239, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy239, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy239); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy509 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy509 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy129, &yymsp[-2].minor.yy239, &yymsp[0].minor.yy239); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy129, &yymsp[-2].minor.yy239, &yymsp[0].minor.yy239); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy129 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy129 = yymsp[0].minor.yy129; }
  yymsp[0].minor.yy129 = yylhsminor.yy129;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy129 = yymsp[-2].minor.yy129 | yymsp[0].minor.yy129; }
  yymsp[-2].minor.yy129 = yylhsminor.yy129;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy129 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy129 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy239 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy239 = yylhsminor.yy239;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy239 = yymsp[-2].minor.yy239; }
  yymsp[-2].minor.yy239 = yylhsminor.yy239;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy239, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy239, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy239); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 318: /* db_name ::= NK_ID */ yytestcase(yyruleno==318);
      case 319: /* table_name ::= NK_ID */ yytestcase(yyruleno==319);
      case 320: /* column_name ::= NK_ID */ yytestcase(yyruleno==320);
      case 321: /* function_name ::= NK_ID */ yytestcase(yyruleno==321);
      case 322: /* table_alias ::= NK_ID */ yytestcase(yyruleno==322);
      case 323: /* column_alias ::= NK_ID */ yytestcase(yyruleno==323);
      case 324: /* user_name ::= NK_ID */ yytestcase(yyruleno==324);
      case 325: /* topic_name ::= NK_ID */ yytestcase(yyruleno==325);
      case 326: /* stream_name ::= NK_ID */ yytestcase(yyruleno==326);
      case 327: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==327);
      case 363: /* noarg_func ::= NOW */ yytestcase(yyruleno==363);
      case 364: /* noarg_func ::= TODAY */ yytestcase(yyruleno==364);
      case 365: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==365);
      case 366: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==366);
      case 367: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==367);
      case 368: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==368);
      case 369: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==369);
      case 370: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==370);
      case 371: /* noarg_func ::= USER */ yytestcase(yyruleno==371);
      case 372: /* star_func ::= COUNT */ yytestcase(yyruleno==372);
      case 373: /* star_func ::= FIRST */ yytestcase(yyruleno==373);
      case 374: /* star_func ::= LAST */ yytestcase(yyruleno==374);
      case 375: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==375);
{ yylhsminor.yy239 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy239 = yylhsminor.yy239;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy845, &yymsp[-1].minor.yy239, yymsp[0].minor.yy80); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy845, &yymsp[0].minor.yy239); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy239); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy239, yymsp[0].minor.yy80); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy239); }
        break;
      case 67: /* cmd ::= TRIM DATABASE db_name */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[0].minor.yy239); }
        break;
      case 68: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy845 = true; }
        break;
      case 69: /* not_exists_opt ::= */
      case 71: /* exists_opt ::= */ yytestcase(yyruleno==71);
      case 261: /* analyze_opt ::= */ yytestcase(yyruleno==261);
      case 268: /* agg_func_opt ::= */ yytestcase(yyruleno==268);
      case 429: /* set_quantifier_opt ::= */ yytestcase(yyruleno==429);
{ yymsp[1].minor.yy845 = false; }
        break;
      case 70: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy845 = true; }
        break;
      case 72: /* db_options ::= */
{ yymsp[1].minor.yy80 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 73: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 74: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 75: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 76: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 77: /* db_options ::= db_options DURATION NK_INTEGER */
      case 78: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==78);
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 79: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 80: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 81: /* db_options ::= db_options KEEP integer_list */
      case 82: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==82);
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_KEEP, yymsp[0].minor.yy574); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 83: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 84: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 85: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 86: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 87: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 88: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 89: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 90: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_RETENTIONS, yymsp[0].minor.yy574); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 91: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 92: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 93: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 94: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 95: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-3].minor.yy80, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy80 = yylhsminor.yy80;
        break;
      case 96: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 97: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-3].minor.yy80, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy80 = yylhsminor.yy80;
        break;
      case 98: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 99: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 100: /* db_options ::= db_options SST_TRIGGER NK_INTEGER */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_SST_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 101: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 102: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy80 = setDatabaseOption(pCxt, yymsp[-2].minor.yy80, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 103: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy80 = createAlterDatabaseOptions(pCxt); yylhsminor.yy80 = setAlterDatabaseOption(pCxt, yylhsminor.yy80, &yymsp[0].minor.yy299); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 104: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy80 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy80, &yymsp[0].minor.yy299); }
  yymsp[-1].minor.yy80 = yylhsminor.yy80;
        break;
      case 105: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy299.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy299.val = yymsp[0].minor.yy0; }
        break;
      case 106: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy299.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy299.val = yymsp[0].minor.yy0; }
        break;
      case 107: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy299.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy299.val = yymsp[0].minor.yy0; }
        break;
      case 108: /* alter_db_option ::= KEEP integer_list */
      case 109: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==109);
{ yymsp[-1].minor.yy299.type = DB_OPTION_KEEP; yymsp[-1].minor.yy299.pList = yymsp[0].minor.yy574; }
        break;
      case 110: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy299.type = DB_OPTION_WAL; yymsp[-1].minor.yy299.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= SST_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy299.type = DB_OPTION_SST_TRIGGER; yymsp[-1].minor.yy299.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy574 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy574 = yylhsminor.yy574;
        break;
      case 113: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 288: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==288);
{ yylhsminor.yy574 = addNodeToList(pCxt, yymsp[-2].minor.yy574, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy574 = yylhsminor.yy574;
        break;
      case 114: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy574 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy574 = yylhsminor.yy574;
        break;
      case 115: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy574 = addNodeToList(pCxt, yymsp[-2].minor.yy574, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy574 = yylhsminor.yy574;
        break;
      case 116: /* retention_list ::= retention */
      case 136: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==136);
      case 139: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==139);
      case 146: /* column_def_list ::= column_def */ yytestcase(yyruleno==146);
      case 189: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==189);
      case 194: /* col_name_list ::= col_name */ yytestcase(yyruleno==194);
      case 244: /* func_list ::= func */ yytestcase(yyruleno==244);
      case 316: /* literal_list ::= signed_literal */ yytestcase(yyruleno==316);
      case 378: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==378);
      case 432: /* select_list ::= select_item */ yytestcase(yyruleno==432);
      case 486: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==486);
{ yylhsminor.yy574 = createNodeList(pCxt, yymsp[0].minor.yy80); }
  yymsp[0].minor.yy574 = yylhsminor.yy574;
        break;
      case 117: /* retention_list ::= retention_list NK_COMMA retention */
      case 147: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==147);
      case 190: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==190);
      case 195: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==195);
      case 245: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==245);
      case 317: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==317);
      case 379: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==379);
      case 433: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==433);
      case 487: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==487);
{ yylhsminor.yy574 = addNodeToList(pCxt, yymsp[-2].minor.yy574, yymsp[0].minor.yy80); }
  yymsp[-2].minor.yy574 = yylhsminor.yy574;
        break;
      case 118: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy80 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 119: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 121: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==121);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy845, yymsp[-5].minor.yy80, yymsp[-3].minor.yy574, yymsp[-1].minor.yy574, yymsp[0].minor.yy80); }
        break;
      case 120: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy574); }
        break;
      case 122: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy574); }
        break;
      case 123: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy845, yymsp[0].minor.yy80); }
        break;
      case 124: /* cmd ::= ALTER TABLE alter_table_clause */
      case 290: /* cmd ::= query_expression */ yytestcase(yyruleno==290);
{ pCxt->pRootNode = yymsp[0].minor.yy80; }
        break;
      case 125: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy80); }
        break;
      case 126: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy80 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy80, yymsp[0].minor.yy80); }
  yymsp[-1].minor.yy80 = yylhsminor.yy80;
        break;
      case 127: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy80 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy80, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy239, yymsp[0].minor.yy136); }
  yymsp[-4].minor.yy80 = yylhsminor.yy80;
        break;
      case 128: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy80 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy80, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy239); }
  yymsp[-3].minor.yy80 = yylhsminor.yy80;
        break;
      case 129: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy80 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy80, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy239, yymsp[0].minor.yy136); }
  yymsp[-4].minor.yy80 = yylhsminor.yy80;
        break;
      case 130: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy80 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy80, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy239, &yymsp[0].minor.yy239); }
  yymsp[-4].minor.yy80 = yylhsminor.yy80;
        break;
      case 131: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy80 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy80, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy239, yymsp[0].minor.yy136); }
  yymsp[-4].minor.yy80 = yylhsminor.yy80;
        break;
      case 132: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy80 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy80, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy239); }
  yymsp[-3].minor.yy80 = yylhsminor.yy80;
        break;
      case 133: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy80 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy80, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy239, yymsp[0].minor.yy136); }
  yymsp[-4].minor.yy80 = yylhsminor.yy80;
        break;
      case 134: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy80 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy80, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy239, &yymsp[0].minor.yy239); }
  yymsp[-4].minor.yy80 = yylhsminor.yy80;
        break;
      case 135: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy80 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy80, &yymsp[-2].minor.yy239, yymsp[0].minor.yy80); }
  yymsp[-5].minor.yy80 = yylhsminor.yy80;
        break;
      case 137: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 140: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==140);
{ yylhsminor.yy574 = addNodeToList(pCxt, yymsp[-1].minor.yy574, yymsp[0].minor.yy80); }
  yymsp[-1].minor.yy574 = yylhsminor.yy574;
        break;
      case 138: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy80 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy845, yymsp[-8].minor.yy80, yymsp[-6].minor.yy80, yymsp[-5].minor.yy574, yymsp[-2].minor.yy574, yymsp[0].minor.yy80); }
  yymsp[-9].minor.yy80 = yylhsminor.yy80;
        break;
      case 141: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy80 = createDropTableClause(pCxt, yymsp[-1].minor.yy845, yymsp[0].minor.yy80); }
  yymsp[-1].minor.yy80 = yylhsminor.yy80;
        break;
      case 142: /* specific_cols_opt ::= */
      case 173: /* tags_def_opt ::= */ yytestcase(yyruleno==173);
      case 441: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==441);
      case 458: /* group_by_clause_opt ::= */ yytestcase(yyruleno==458);
      case 474: /* order_by_clause_opt ::= */ yytestcase(yyruleno==474);
{ yymsp[1].minor.yy574 = NULL; }
        break;
      case 143: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy574 = yymsp[-1].minor.yy574; }
        break;
      case 144: /* full_table_name ::= table_name */
{ yylhsminor.yy80 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy239, NULL); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 145: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy80 = createRealTableNode(pCxt, &yymsp[-2].minor.yy239, &yymsp[0].minor.yy239, NULL); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 148: /* column_def ::= column_name type_name */
{ yylhsminor.yy80 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy239, yymsp[0].minor.yy136, NULL); }
  yymsp[-1].minor.yy80 = yylhsminor.yy80;
        break;
      case 149: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy80 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy239, yymsp[-2].minor.yy136, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy80 = yylhsminor.yy80;
        break;
      case 150: /* type_name ::= BOOL */
{ yymsp[0].minor.yy136 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 151: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy136 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 152: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy136 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 153: /* type_name ::= INT */
      case 154: /* type_name ::= INTEGER */ yytestcase(yyruleno==154);
{ yymsp[0].minor.yy136 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 155: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy136 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 156: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy136 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 157: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy136 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 158: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy136 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 159: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy136 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 160: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy136 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 161: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy136 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 162: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy136 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 163: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy136 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 164: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy136 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 165: /* type_name ::= JSON */
{ yymsp[0].minor.yy136 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 166: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy136 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 167: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy136 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 168: /* type_name ::= BLOB */
{ yymsp[0].minor.yy136 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 169: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy136 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy136 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 171: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy136 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 172: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy136 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 174: /* tags_def_opt ::= tags_def */
      case 377: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==377);
{ yylhsminor.yy574 = yymsp[0].minor.yy574; }
  yymsp[0].minor.yy574 = yylhsminor.yy574;
        break;
      case 175: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy574 = yymsp[-1].minor.yy574; }
        break;
      case 176: /* table_options ::= */
{ yymsp[1].minor.yy80 = createDefaultTableOptions(pCxt); }
        break;
      case 177: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy80 = setTableOption(pCxt, yymsp[-2].minor.yy80, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 178: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy80 = setTableOption(pCxt, yymsp[-2].minor.yy80, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy574); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 179: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy80 = setTableOption(pCxt, yymsp[-2].minor.yy80, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy574); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 180: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy80 = setTableOption(pCxt, yymsp[-4].minor.yy80, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy574); }
  yymsp[-4].minor.yy80 = yylhsminor.yy80;
        break;
      case 181: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy80 = setTableOption(pCxt, yymsp[-2].minor.yy80, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 182: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy80 = setTableOption(pCxt, yymsp[-4].minor.yy80, TABLE_OPTION_SMA, yymsp[-1].minor.yy574); }
  yymsp[-4].minor.yy80 = yylhsminor.yy80;
        break;
      case 183: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy80 = createAlterTableOptions(pCxt); yylhsminor.yy80 = setTableOption(pCxt, yylhsminor.yy80, yymsp[0].minor.yy299.type, &yymsp[0].minor.yy299.val); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 184: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy80 = setTableOption(pCxt, yymsp[-1].minor.yy80, yymsp[0].minor.yy299.type, &yymsp[0].minor.yy299.val); }
  yymsp[-1].minor.yy80 = yylhsminor.yy80;
        break;
      case 185: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy299.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy299.val = yymsp[0].minor.yy0; }
        break;
      case 186: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy299.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy299.val = yymsp[0].minor.yy0; }
        break;
      case 187: /* duration_list ::= duration_literal */
      case 344: /* expression_list ::= expression */ yytestcase(yyruleno==344);
{ yylhsminor.yy574 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy80)); }
  yymsp[0].minor.yy574 = yylhsminor.yy574;
        break;
      case 188: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 345: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==345);
{ yylhsminor.yy574 = addNodeToList(pCxt, yymsp[-2].minor.yy574, releaseRawExprNode(pCxt, yymsp[0].minor.yy80)); }
  yymsp[-2].minor.yy574 = yylhsminor.yy574;
        break;
      case 191: /* rollup_func_name ::= function_name */
{ yylhsminor.yy80 = createFunctionNode(pCxt, &yymsp[0].minor.yy239, NULL); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 192: /* rollup_func_name ::= FIRST */
      case 193: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==193);
{ yylhsminor.yy80 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 196: /* col_name ::= column_name */
{ yylhsminor.yy80 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy239); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 197: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 198: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 199: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 200: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy80, yymsp[0].minor.yy80, OP_TYPE_LIKE); }
        break;
      case 201: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy80, yymsp[0].minor.yy80, OP_TYPE_LIKE); }
        break;
      case 202: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy80, NULL, OP_TYPE_LIKE); }
        break;
      case 203: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 204: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 205: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 206: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 207: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy80, yymsp[-1].minor.yy80, OP_TYPE_EQUAL); }
        break;
      case 208: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 209: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 210: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 211: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 212: /* cmd ::= SHOW LICENCES */
      case 213: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==213);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 214: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy239); }
        break;
      case 215: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy80); }
        break;
      case 216: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy80); }
        break;
      case 217: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 218: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 219: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 220: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 221: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 222: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 223: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 224: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 225: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 226: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 227: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy80); }
        break;
      case 228: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 229: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 230: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy80, yymsp[-1].minor.yy80, OP_TYPE_EQUAL); }
        break;
      case 231: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 232: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 233: /* db_name_cond_opt ::= */
      case 238: /* from_db_opt ::= */ yytestcase(yyruleno==238);
{ yymsp[1].minor.yy80 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 234: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy80 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy239); }
  yymsp[-1].minor.yy80 = yylhsminor.yy80;
        break;
      case 235: /* like_pattern_opt ::= */
      case 410: /* from_clause_opt ::= */ yytestcase(yyruleno==410);
      case 439: /* where_clause_opt ::= */ yytestcase(yyruleno==439);
      case 443: /* twindow_clause_opt ::= */ yytestcase(yyruleno==443);
      case 448: /* sliding_opt ::= */ yytestcase(yyruleno==448);
      case 450: /* fill_opt ::= */ yytestcase(yyruleno==450);
      case 462: /* having_clause_opt ::= */ yytestcase(yyruleno==462);
      case 464: /* range_opt ::= */ yytestcase(yyruleno==464);
      case 466: /* every_opt ::= */ yytestcase(yyruleno==466);
      case 476: /* slimit_clause_opt ::= */ yytestcase(yyruleno==476);
      case 480: /* limit_clause_opt ::= */ yytestcase(yyruleno==480);
{ yymsp[1].minor.yy80 = NULL; }
        break;
      case 236: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy80 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 237: /* table_name_cond ::= table_name */
{ yylhsminor.yy80 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy239); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 239: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy80 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy239); }
        break;
      case 240: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy845, yymsp[-3].minor.yy80, yymsp[-1].minor.yy80, NULL, yymsp[0].minor.yy80); }
        break;
      case 241: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy845, yymsp[0].minor.yy80); }
        break;
      case 242: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy80 = createIndexOption(pCxt, yymsp[-7].minor.yy574, releaseRawExprNode(pCxt, yymsp[-3].minor.yy80), NULL, yymsp[-1].minor.yy80, yymsp[0].minor.yy80); }
        break;
      case 243: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy80 = createIndexOption(pCxt, yymsp[-9].minor.yy574, releaseRawExprNode(pCxt, yymsp[-5].minor.yy80), releaseRawExprNode(pCxt, yymsp[-3].minor.yy80), yymsp[-1].minor.yy80, yymsp[0].minor.yy80); }
        break;
      case 246: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy80 = createFunctionNode(pCxt, &yymsp[-3].minor.yy239, yymsp[-1].minor.yy574); }
  yymsp[-3].minor.yy80 = yylhsminor.yy80;
        break;
      case 247: /* sma_stream_opt ::= */
      case 274: /* stream_options ::= */ yytestcase(yyruleno==274);
{ yymsp[1].minor.yy80 = createStreamOptions(pCxt); }
        break;
      case 248: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 278: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==278);
{ ((SStreamOptions*)yymsp[-2].minor.yy80)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy80); yylhsminor.yy80 = yymsp[-2].minor.yy80; }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 249: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy80)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy80); yylhsminor.yy80 = yymsp[-2].minor.yy80; }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 250: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy845, &yymsp[-2].minor.yy239, yymsp[0].minor.yy80); }
        break;
      case 251: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy845, &yymsp[-3].minor.yy239, &yymsp[0].minor.yy239, false); }
        break;
      case 252: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy845, &yymsp[-5].minor.yy239, &yymsp[0].minor.yy239, true); }
        break;
      case 253: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy845, &yymsp[-3].minor.yy239, yymsp[0].minor.yy80, false); }
        break;
      case 254: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy845, &yymsp[-5].minor.yy239, yymsp[0].minor.yy80, true); }
        break;
      case 255: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy845, &yymsp[0].minor.yy239); }
        break;
      case 256: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy845, &yymsp[-2].minor.yy239, &yymsp[0].minor.yy239); }
        break;
      case 257: /* cmd ::= DESC full_table_name */
      case 258: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==258);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy80); }
        break;
      case 259: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 260: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy845, yymsp[-1].minor.yy80, yymsp[0].minor.yy80); }
        break;
      case 262: /* analyze_opt ::= ANALYZE */
      case 269: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==269);
      case 430: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==430);
{ yymsp[0].minor.yy845 = true; }
        break;
      case 263: /* explain_options ::= */
{ yymsp[1].minor.yy80 = createDefaultExplainOptions(pCxt); }
        break;
      case 264: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy80 = setExplainVerbose(pCxt, yymsp[-2].minor.yy80, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 265: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy80 = setExplainRatio(pCxt, yymsp[-2].minor.yy80, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 266: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy845, yymsp[-8].minor.yy845, &yymsp[-5].minor.yy239, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy136, yymsp[0].minor.yy46); }
        break;
      case 267: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy845, &yymsp[0].minor.yy239); }
        break;
      case 270: /* bufsize_opt ::= */
{ yymsp[1].minor.yy46 = 0; }
        break;
      case 271: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy46 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 272: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-6].minor.yy845, &yymsp[-5].minor.yy239, yymsp[-2].minor.yy80, yymsp[-4].minor.yy80, yymsp[0].minor.yy80); }
        break;
      case 273: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy845, &yymsp[0].minor.yy239); }
        break;
      case 275: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy80)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy80 = yymsp[-2].minor.yy80; }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 276: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy80)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy80 = yymsp[-2].minor.yy80; }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 277: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy80)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy80)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy80); yylhsminor.yy80 = yymsp[-3].minor.yy80; }
  yymsp[-3].minor.yy80 = yylhsminor.yy80;
        break;
      case 279: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy80)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy80 = yymsp[-3].minor.yy80; }
  yymsp[-3].minor.yy80 = yylhsminor.yy80;
        break;
      case 280: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 281: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 282: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 283: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 284: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 285: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy574); }
        break;
      case 286: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 287: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy574 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 289: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy80, yymsp[0].minor.yy80); }
        break;
      case 291: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy80, yymsp[-2].minor.yy574, yymsp[0].minor.yy80); }
        break;
      case 292: /* cmd ::= INSERT INTO full_table_name query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy80, NULL, yymsp[0].minor.yy80); }
        break;
      case 293: /* literal ::= NK_INTEGER */
{ yylhsminor.yy80 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 294: /* literal ::= NK_FLOAT */
{ yylhsminor.yy80 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 295: /* literal ::= NK_STRING */
{ yylhsminor.yy80 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 296: /* literal ::= NK_BOOL */
{ yylhsminor.yy80 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 297: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy80 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy80 = yylhsminor.yy80;
        break;
      case 298: /* literal ::= duration_literal */
      case 308: /* signed_literal ::= signed */ yytestcase(yyruleno==308);
      case 328: /* expression ::= literal */ yytestcase(yyruleno==328);
      case 329: /* expression ::= pseudo_column */ yytestcase(yyruleno==329);
      case 330: /* expression ::= column_reference */ yytestcase(yyruleno==330);
      case 331: /* expression ::= function_expression */ yytestcase(yyruleno==331);
      case 332: /* expression ::= subquery */ yytestcase(yyruleno==332);
      case 360: /* function_expression ::= literal_func */ yytestcase(yyruleno==360);
      case 402: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==402);
      case 406: /* boolean_primary ::= predicate */ yytestcase(yyruleno==406);
      case 408: /* common_expression ::= expression */ yytestcase(yyruleno==408);
      case 409: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==409);
      case 412: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==412);
      case 414: /* table_reference ::= table_primary */ yytestcase(yyruleno==414);
      case 415: /* table_reference ::= joined_table */ yytestcase(yyruleno==415);
      case 419: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==419);
      case 469: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==469);
      case 472: /* query_primary ::= query_specification */ yytestcase(yyruleno==472);
{ yylhsminor.yy80 = yymsp[0].minor.yy80; }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 299: /* literal ::= NULL */
{ yylhsminor.yy80 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 300: /* literal ::= NK_QUESTION */
{ yylhsminor.yy80 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 301: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy80 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 302: /* signed ::= NK_INTEGER */
{ yylhsminor.yy80 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 303: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy80 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 304: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy80 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy80 = yylhsminor.yy80;
        break;
      case 305: /* signed ::= NK_FLOAT */
{ yylhsminor.yy80 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 306: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy80 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 307: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy80 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy80 = yylhsminor.yy80;
        break;
      case 309: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy80 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 310: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy80 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 311: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy80 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 312: /* signed_literal ::= duration_literal */
      case 314: /* signed_literal ::= literal_func */ yytestcase(yyruleno==314);
      case 380: /* star_func_para ::= expression */ yytestcase(yyruleno==380);
      case 435: /* select_item ::= common_expression */ yytestcase(yyruleno==435);
      case 485: /* search_condition ::= common_expression */ yytestcase(yyruleno==485);
{ yylhsminor.yy80 = releaseRawExprNode(pCxt, yymsp[0].minor.yy80); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 313: /* signed_literal ::= NULL */
{ yylhsminor.yy80 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 315: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy80 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 333: /* expression ::= NK_LP expression NK_RP */
      case 407: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==407);
{ yylhsminor.yy80 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy80)); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 334: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy80);
                                                                                    yylhsminor.yy80 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy80));
                                                                                  }
  yymsp[-1].minor.yy80 = yylhsminor.yy80;
        break;
      case 335: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy80);
                                                                                    yylhsminor.yy80 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy80), NULL));
                                                                                  }
  yymsp[-1].minor.yy80 = yylhsminor.yy80;
        break;
      case 336: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy80);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy80);
                                                                                    yylhsminor.yy80 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy80), releaseRawExprNode(pCxt, yymsp[0].minor.yy80))); 
                                                                                  }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 337: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy80);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy80);
                                                                                    yylhsminor.yy80 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy80), releaseRawExprNode(pCxt, yymsp[0].minor.yy80))); 
                                                                                  }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 338: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy80);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy80);
                                                                                    yylhsminor.yy80 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy80), releaseRawExprNode(pCxt, yymsp[0].minor.yy80))); 
                                                                                  }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 339: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy80);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy80);
                                                                                    yylhsminor.yy80 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy80), releaseRawExprNode(pCxt, yymsp[0].minor.yy80))); 
                                                                                  }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 340: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy80);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy80);
                                                                                    yylhsminor.yy80 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy80), releaseRawExprNode(pCxt, yymsp[0].minor.yy80)));
                                                                                  }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 341: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy80);
                                                                                    yylhsminor.yy80 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy80), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 342: /* expression ::= expression NK_BITAND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy80);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy80);
                                                                                    yylhsminor.yy80 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy80), releaseRawExprNode(pCxt, yymsp[0].minor.yy80)));
                                                                                  }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 343: /* expression ::= expression NK_BITOR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy80);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy80);
                                                                                    yylhsminor.yy80 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy80), releaseRawExprNode(pCxt, yymsp[0].minor.yy80)));
                                                                                  }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 346: /* column_reference ::= column_name */
{ yylhsminor.yy80 = createRawExprNode(pCxt, &yymsp[0].minor.yy239, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy239)); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 347: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy80 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy239, &yymsp[0].minor.yy239, createColumnNode(pCxt, &yymsp[-2].minor.yy239, &yymsp[0].minor.yy239)); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 348: /* pseudo_column ::= ROWTS */
      case 349: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==349);
      case 351: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==351);
      case 352: /* pseudo_column ::= QEND */ yytestcase(yyruleno==352);
      case 353: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==353);
      case 354: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==354);
      case 355: /* pseudo_column ::= WEND */ yytestcase(yyruleno==355);
      case 356: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==356);
      case 362: /* literal_func ::= NOW */ yytestcase(yyruleno==362);
{ yylhsminor.yy80 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 350: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy80 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy239, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy239)))); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 357: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 358: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==358);
{ yylhsminor.yy80 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy239, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy239, yymsp[-1].minor.yy574)); }
  yymsp[-3].minor.yy80 = yylhsminor.yy80;
        break;
      case 359: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy80 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy80), yymsp[-1].minor.yy136)); }
  yymsp[-5].minor.yy80 = yylhsminor.yy80;
        break;
      case 361: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy80 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy239, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy239, NULL)); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 376: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy574 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy574 = yylhsminor.yy574;
        break;
      case 381: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 438: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==438);
{ yylhsminor.yy80 = createColumnNode(pCxt, &yymsp[-2].minor.yy239, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 382: /* predicate ::= expression compare_op expression */
      case 387: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==387);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy80);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy80);
                                                                                    yylhsminor.yy80 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy194, releaseRawExprNode(pCxt, yymsp[-2].minor.yy80), releaseRawExprNode(pCxt, yymsp[0].minor.yy80)));
                                                                                  }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 383: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy80);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy80);
                                                                                    yylhsminor.yy80 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy80), releaseRawExprNode(pCxt, yymsp[-2].minor.yy80), releaseRawExprNode(pCxt, yymsp[0].minor.yy80)));
                                                                                  }
  yymsp[-4].minor.yy80 = yylhsminor.yy80;
        break;
      case 384: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy80);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy80);
                                                                                    yylhsminor.yy80 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy80), releaseRawExprNode(pCxt, yymsp[-2].minor.yy80), releaseRawExprNode(pCxt, yymsp[0].minor.yy80)));
                                                                                  }
  yymsp[-5].minor.yy80 = yylhsminor.yy80;
        break;
      case 385: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy80);
                                                                                    yylhsminor.yy80 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy80), NULL));
                                                                                  }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 386: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy80);
                                                                                    yylhsminor.yy80 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy80), NULL));
                                                                                  }
  yymsp[-3].minor.yy80 = yylhsminor.yy80;
        break;
      case 388: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy194 = OP_TYPE_LOWER_THAN; }
        break;
      case 389: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy194 = OP_TYPE_GREATER_THAN; }
        break;
      case 390: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy194 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 391: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy194 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 392: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy194 = OP_TYPE_NOT_EQUAL; }
        break;
      case 393: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy194 = OP_TYPE_EQUAL; }
        break;
      case 394: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy194 = OP_TYPE_LIKE; }
        break;
      case 395: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy194 = OP_TYPE_NOT_LIKE; }
        break;
      case 396: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy194 = OP_TYPE_MATCH; }
        break;
      case 397: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy194 = OP_TYPE_NMATCH; }
        break;
      case 398: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy194 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 399: /* in_op ::= IN */
{ yymsp[0].minor.yy194 = OP_TYPE_IN; }
        break;
      case 400: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy194 = OP_TYPE_NOT_IN; }
        break;
      case 401: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy80 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy574)); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 403: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy80);
                                                                                    yylhsminor.yy80 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy80), NULL));
                                                                                  }
  yymsp[-1].minor.yy80 = yylhsminor.yy80;
        break;
      case 404: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy80);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy80);
                                                                                    yylhsminor.yy80 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy80), releaseRawExprNode(pCxt, yymsp[0].minor.yy80)));
                                                                                  }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 405: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy80);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy80);
                                                                                    yylhsminor.yy80 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy80), releaseRawExprNode(pCxt, yymsp[0].minor.yy80)));
                                                                                  }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 411: /* from_clause_opt ::= FROM table_reference_list */
      case 440: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==440);
      case 463: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==463);
{ yymsp[-1].minor.yy80 = yymsp[0].minor.yy80; }
        break;
      case 413: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy80 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy80, yymsp[0].minor.yy80, NULL); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 416: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy80 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy239, &yymsp[0].minor.yy239); }
  yymsp[-1].minor.yy80 = yylhsminor.yy80;
        break;
      case 417: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy80 = createRealTableNode(pCxt, &yymsp[-3].minor.yy239, &yymsp[-1].minor.yy239, &yymsp[0].minor.yy239); }
  yymsp[-3].minor.yy80 = yylhsminor.yy80;
        break;
      case 418: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy80 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy80), &yymsp[0].minor.yy239); }
  yymsp[-1].minor.yy80 = yylhsminor.yy80;
        break;
      case 420: /* alias_opt ::= */
{ yymsp[1].minor.yy239 = nil_token;  }
        break;
      case 421: /* alias_opt ::= table_alias */
{ yylhsminor.yy239 = yymsp[0].minor.yy239; }
  yymsp[0].minor.yy239 = yylhsminor.yy239;
        break;
      case 422: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy239 = yymsp[0].minor.yy239; }
        break;
      case 423: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 424: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==424);
{ yymsp[-2].minor.yy80 = yymsp[-1].minor.yy80; }
        break;
      case 425: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy80 = createJoinTableNode(pCxt, yymsp[-4].minor.yy750, yymsp[-5].minor.yy80, yymsp[-2].minor.yy80, yymsp[0].minor.yy80); }
  yymsp[-5].minor.yy80 = yylhsminor.yy80;
        break;
      case 426: /* join_type ::= */
{ yymsp[1].minor.yy750 = JOIN_TYPE_INNER; }
        break;
      case 427: /* join_type ::= INNER */
{ yymsp[0].minor.yy750 = JOIN_TYPE_INNER; }
        break;
      case 428: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy80 = createSelectStmt(pCxt, yymsp[-10].minor.yy845, yymsp[-9].minor.yy574, yymsp[-8].minor.yy80);
                                                                                    yymsp[-11].minor.yy80 = addWhereClause(pCxt, yymsp[-11].minor.yy80, yymsp[-7].minor.yy80);
                                                                                    yymsp[-11].minor.yy80 = addPartitionByClause(pCxt, yymsp[-11].minor.yy80, yymsp[-6].minor.yy574);
                                                                                    yymsp[-11].minor.yy80 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy80, yymsp[-2].minor.yy80);
                                                                                    yymsp[-11].minor.yy80 = addGroupByClause(pCxt, yymsp[-11].minor.yy80, yymsp[-1].minor.yy574);
                                                                                    yymsp[-11].minor.yy80 = addHavingClause(pCxt, yymsp[-11].minor.yy80, yymsp[0].minor.yy80);
                                                                                    yymsp[-11].minor.yy80 = addRangeClause(pCxt, yymsp[-11].minor.yy80, yymsp[-5].minor.yy80);
                                                                                    yymsp[-11].minor.yy80 = addEveryClause(pCxt, yymsp[-11].minor.yy80, yymsp[-4].minor.yy80);
                                                                                    yymsp[-11].minor.yy80 = addFillClause(pCxt, yymsp[-11].minor.yy80, yymsp[-3].minor.yy80);
                                                                                  }
        break;
      case 431: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy845 = false; }
        break;
      case 434: /* select_item ::= NK_STAR */
{ yylhsminor.yy80 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy80 = yylhsminor.yy80;
        break;
      case 436: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy80 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy80), &yymsp[0].minor.yy239); }
  yymsp[-1].minor.yy80 = yylhsminor.yy80;
        break;
      case 437: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy80 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy80), &yymsp[0].minor.yy239); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 442: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 459: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==459);
      case 475: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==475);
{ yymsp[-2].minor.yy574 = yymsp[0].minor.yy574; }
        break;
      case 444: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy80 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy80), releaseRawExprNode(pCxt, yymsp[-1].minor.yy80)); }
        break;
      case 445: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy80 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy80)); }
        break;
      case 446: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy80 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy80), NULL, yymsp[-1].minor.yy80, yymsp[0].minor.yy80); }
        break;
      case 447: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy80 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy80), releaseRawExprNode(pCxt, yymsp[-3].minor.yy80), yymsp[-1].minor.yy80, yymsp[0].minor.yy80); }
        break;
      case 449: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 467: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==467);
{ yymsp[-3].minor.yy80 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy80); }
        break;
      case 451: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy80 = createFillNode(pCxt, yymsp[-1].minor.yy426, NULL); }
        break;
      case 452: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy80 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy574)); }
        break;
      case 453: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy426 = FILL_MODE_NONE; }
        break;
      case 454: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy426 = FILL_MODE_PREV; }
        break;
      case 455: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy426 = FILL_MODE_NULL; }
        break;
      case 456: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy426 = FILL_MODE_LINEAR; }
        break;
      case 457: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy426 = FILL_MODE_NEXT; }
        break;
      case 460: /* group_by_list ::= expression */
{ yylhsminor.yy574 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy80))); }
  yymsp[0].minor.yy574 = yylhsminor.yy574;
        break;
      case 461: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy574 = addNodeToList(pCxt, yymsp[-2].minor.yy574, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy80))); }
  yymsp[-2].minor.yy574 = yylhsminor.yy574;
        break;
      case 465: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy80 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy80), releaseRawExprNode(pCxt, yymsp[-1].minor.yy80)); }
        break;
      case 468: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy80 = addOrderByClause(pCxt, yymsp[-3].minor.yy80, yymsp[-2].minor.yy574);
                                                                                    yylhsminor.yy80 = addSlimitClause(pCxt, yylhsminor.yy80, yymsp[-1].minor.yy80);
                                                                                    yylhsminor.yy80 = addLimitClause(pCxt, yylhsminor.yy80, yymsp[0].minor.yy80);
                                                                                  }
  yymsp[-3].minor.yy80 = yylhsminor.yy80;
        break;
      case 470: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy80 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy80, yymsp[0].minor.yy80); }
  yymsp[-3].minor.yy80 = yylhsminor.yy80;
        break;
      case 471: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy80 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy80, yymsp[0].minor.yy80); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 473: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ 
                                                                                    yymsp[-5].minor.yy80 = addOrderByClause(pCxt, yymsp[-4].minor.yy80, yymsp[-3].minor.yy574);
                                                                                    yymsp[-5].minor.yy80 = addSlimitClause(pCxt, yymsp[-5].minor.yy80, yymsp[-2].minor.yy80);
                                                                                    yymsp[-5].minor.yy80 = addLimitClause(pCxt, yymsp[-5].minor.yy80, yymsp[-1].minor.yy80);
                                                                                  }
        break;
      case 477: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 481: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==481);
{ yymsp[-1].minor.yy80 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 478: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 482: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==482);
{ yymsp[-3].minor.yy80 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 479: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 483: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==483);
{ yymsp[-3].minor.yy80 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 484: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy80 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy80); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 488: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy80 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy80), yymsp[-1].minor.yy422, yymsp[0].minor.yy763); }
  yymsp[-2].minor.yy80 = yylhsminor.yy80;
        break;
      case 489: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy422 = ORDER_ASC; }
        break;
      case 490: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy422 = ORDER_ASC; }
        break;
      case 491: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy422 = ORDER_DESC; }
        break;
      case 492: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy763 = NULL_ORDER_DEFAULT; }
        break;
      case 493: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy763 = NULL_ORDER_FIRST; }
        break;
      case 494: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy763 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
