/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 364
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SToken yy57;
  EOrder yy162;
  EJoinType yy204;
  SAlterOption yy221;
  int32_t yy228;
  EFillMode yy270;
  EOperatorType yy324;
  int64_t yy389;
  SNode* yy392;
  SDataType yy448;
  bool yy481;
  ENullOrder yy529;
  SNodeList* yy600;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             636
#define YYNRULE              464
#define YYNTOKEN             242
#define YY_MAX_SHIFT         635
#define YY_MIN_SHIFTREDUCE   928
#define YY_MAX_SHIFTREDUCE   1391
#define YY_ERROR_ACTION      1392
#define YY_ACCEPT_ACTION     1393
#define YY_NO_ACTION         1394
#define YY_MIN_REDUCE        1395
#define YY_MAX_REDUCE        1858
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2123)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1688, 1836, 1515,  309,  407, 1688,  408, 1427,  326, 1393,
 /*    10 */   137, 1685,   37,   35, 1483, 1835, 1685, 1701,  412, 1833,
 /*    20 */   318,  551, 1201,  551, 1223,   38,   36,   34,   33,   32,
 /*    30 */   325,  324,  109,  415,  109,  408, 1427, 1681, 1687,  446,
 /*    40 */  1215,  451, 1681, 1687, 1717,   30,  240, 1199,  554, 1526,
 /*    50 */  1784, 1526,  535,  554,   22,  551,  550, 1671,   14,  534,
 /*    60 */    37,   35, 1328,  322, 1207, 1208,  157,  335,  318, 1701,
 /*    70 */  1201,  134,  515,  365, 1781,   38,   36,   34,   33,   32,
 /*    80 */  1528,    1, 1207, 1526, 1730,   67,  550,   85, 1702,  537,
 /*    90 */  1704, 1705,  533,   58,  554, 1199, 1717, 1770,  113,   76,
 /*   100 */   371,  292, 1766,  632,  514,  551,   14, 1521, 1836, 1671,
 /*   110 */  1418,  534, 1207, 1836, 1836,  538,  369, 1270, 1271,  958,
 /*   120 */  1519,  555,  152,  465,  550, 1622, 1833,  154,  152,    2,
 /*   130 */   425, 1833, 1833, 1526,  206,   82, 1730,  290,  473,   86,
 /*   140 */  1702,  537, 1704, 1705,  533, 1362,  554,   40,  118, 1770,
 /*   150 */  1671,  632,  198,  311, 1766,  148, 1518,  962,  963, 1202,
 /*   160 */    58, 1200,   70,  328,  468, 1270, 1271,  232,   56,  462,
 /*   170 */   364,  134,  363, 1226,  197,  490, 1797, 1216,  330, 1211,
 /*   180 */  1528, 1571, 1573, 1205, 1206,   41, 1252, 1253, 1255, 1256,
 /*   190 */  1257, 1258, 1259,  530,  552, 1267, 1268, 1269, 1272,   53,
 /*   200 */  1225, 1219,   52, 1572, 1573,   26,   59, 1202, 1836, 1200,
 /*   210 */   505,  155,  552, 1267, 1268,   38,   36,   34,   33,   32,
 /*   220 */    37,   35,  153,  155, 1417, 1701, 1833,  397,  318,   67,
 /*   230 */  1201, 1205, 1206,  302, 1252, 1253, 1255, 1256, 1257, 1258,
 /*   240 */  1259,  530,  552, 1267, 1268, 1269, 1272,  511, 1717,  460,
 /*   250 */   459, 1522, 1717,  484,  458, 1199,  504,  114,  455, 1659,
 /*   260 */   535,  454,  453,  452, 1671, 1671,   14,  534,   37,   35,
 /*   270 */  1107, 1108, 1207,  166,  165,  117,  318,  155, 1201, 1292,
 /*   280 */   515, 1504,  303,   58,  301,  300,  356,  448,   58,    2,
 /*   290 */   155,  450, 1730,  503, 1836,   85, 1702,  537, 1704, 1705,
 /*   300 */   533, 1297,  554, 1199,  344, 1770,  358,  354,  152,  292,
 /*   310 */  1766,  632, 1833,  449,  115,   38,   36,   34,   33,   32,
 /*   320 */  1207, 1836,  136, 1517, 1407, 1270, 1271, 1502,  513,  149,
 /*   330 */  1777, 1778, 1327, 1782, 1685,  152,   27,    8,  425, 1833,
 /*   340 */  1065,  577,  576,  575, 1069,  574, 1071, 1072,  573, 1074,
 /*   350 */   570, 1396, 1080,  567, 1082, 1083,  564,  561,   81,  632,
 /*   360 */  1681, 1687,   38,   36,   34,   33,   32, 1202,   78, 1200,
 /*   370 */  1352,  554,   99, 1270, 1271,   98,   97,   96,   95,   94,
 /*   380 */    93,   92,   91,   90,  588, 1342,   38,   36,   34,   33,
 /*   390 */    32, 1205, 1206,  517, 1252, 1253, 1255, 1256, 1257, 1258,
 /*   400 */  1259,  530,  552, 1267, 1268, 1269, 1272,  497, 1350, 1351,
 /*   410 */  1353, 1354,  975,  155,  974, 1202,   99, 1200,  155,   98,
 /*   420 */    97,   96,   95,   94,   93,   92,   91,   90,   37,   35,
 /*   430 */  1273,  406,  414, 1701,  410,  410,  318,  162, 1201, 1205,
 /*   440 */  1206,  976, 1252, 1253, 1255, 1256, 1257, 1258, 1259,  530,
 /*   450 */   552, 1267, 1268, 1269, 1272,   38,   36,   34,   33,   32,
 /*   460 */  1717,  474,   65, 1199, 1836,   64, 1027,  155,  535,  975,
 /*   470 */   199,  974, 1578, 1671, 1416,  534,   37,   35, 1834,  308,
 /*   480 */  1207, 1454, 1833, 1029,  318, 1784, 1201,  592, 1576, 1498,
 /*   490 */    38,   36,   34,   33,   32, 1415,  444,    9,  976,  500,
 /*   500 */  1730, 1388, 1836,   87, 1702,  537, 1704, 1705,  533, 1780,
 /*   510 */   554, 1199,  200, 1770, 1671, 1226,  152, 1769, 1766,  632,
 /*   520 */  1833,  538,  133, 1578,  147, 1239,   69,  291, 1207,  321,
 /*   530 */   323, 1621,  588, 1270, 1271, 1671,  293, 1565, 1414, 1576,
 /*   540 */  1326,  610,  609,  608,  333,    9,  607,  606,  605,  119,
 /*   550 */   600,  599,  598,  597,  596,  595,  594,  593,  127,  589,
 /*   560 */  1239, 1395,   38,   36,   34,   33,   32,  632, 1290,  506,
 /*   570 */   501, 1183, 1184, 1227, 1335, 1202, 1413, 1200, 1671, 1412,
 /*   580 */  1225, 1270, 1271, 1387,   28,  108,  107,  106,  105,  104,
 /*   590 */   103,  102,  101,  100,   38,   36,   34,   33,   32, 1205,
 /*   600 */  1206, 1411, 1252, 1253, 1255, 1256, 1257, 1258, 1259,  530,
 /*   610 */   552, 1267, 1268, 1269, 1272,  551, 1671, 1578,  134, 1671,
 /*   620 */  1291, 1224,  331, 1202,  329, 1200,  370, 1529, 1278, 1410,
 /*   630 */   134,  457,  456, 1576, 1225, 1207,   37,   35, 1457, 1528,
 /*   640 */  1228, 1671, 1296, 1526,  318, 1503, 1201, 1205, 1206,  527,
 /*   650 */  1252, 1253, 1255, 1256, 1257, 1258, 1259,  530,  552, 1267,
 /*   660 */  1268, 1269, 1272,   11,   10,   34,   33,   32, 1784, 1671,
 /*   670 */   580, 1199,   38,   36,   34,   33,   32,   29,  316, 1285,
 /*   680 */  1286, 1287, 1288, 1289, 1293, 1294, 1295,  584, 1207,  511,
 /*   690 */  1569, 1689, 1779,  604,  602, 1409,    7,  551,  460,  459,
 /*   700 */   586,  231, 1685,  458,  551,    2,  114,  455,  372,  450,
 /*   710 */   454,  453,  452, 1406, 1578,  382, 1225,  117,  293,  125,
 /*   720 */   124,  583,  582,  581,  289, 1526, 1223,  632, 1681, 1687,
 /*   730 */  1577,  449, 1526,  390,  551, 1671,  402,  515,  586,  554,
 /*   740 */   585, 1270, 1271, 1569, 1304,  383,  135, 1254, 1405, 1404,
 /*   750 */  1290,  269,  263, 1671,  403, 1556,  115,  125,  124,  583,
 /*   760 */   582,  581, 1526,  267,   55, 1403,  551,   54,  212,  551,
 /*   770 */   551,  229, 1777,  510, 1282,  509,  551,  424, 1836, 1612,
 /*   780 */  1523, 1648,  522, 1202,  167, 1200,  373,  253, 1671, 1671,
 /*   790 */   164,  591,  154,  519, 1526,  551, 1833, 1526, 1526,  962,
 /*   800 */   963, 1254, 1291, 1511, 1526, 1671,  482, 1205, 1206,   58,
 /*   810 */  1252, 1253, 1255, 1256, 1257, 1258, 1259,  530,  552, 1267,
 /*   820 */  1268, 1269, 1272, 1526, 1296, 1513,  401, 1789, 1323,  396,
 /*   830 */   395,  394,  393,  392,  389,  388,  387,  386,  385,  381,
 /*   840 */   380,  379,  378,  377,  376,  375,  374,   84, 1402, 1509,
 /*   850 */   190, 1701, 1201,  188,  203, 1401, 1400, 1399, 1398,   29,
 /*   860 */   316, 1285, 1286, 1287, 1288, 1289, 1293, 1294, 1295, 1323,
 /*   870 */   603,  192,  194,  196,  191,  193,  195, 1199, 1717,   62,
 /*   880 */    61,  368,  529, 1254,  161,  999,  514, 1501, 1671,  551,
 /*   890 */   362, 1671, 1701,  534, 1207, 1671, 1671, 1671, 1671,  472,
 /*   900 */   548,  288, 1000,  123,  352,   48,  350,  346,  342,  158,
 /*   910 */   337,  359,  470,  216,   11,   10, 1210, 1526, 1730, 1717,
 /*   920 */  1209,   86, 1702,  537, 1704, 1705,  533,  535,  554,  551,
 /*   930 */  1444, 1770, 1671,  632,  534,  311, 1766,  148,   39,  155,
 /*   940 */   549, 1390, 1391,  579,  486,   39, 1349, 1433,  481,   39,
 /*   950 */  1408, 1484,  461, 1439,  218, 1691,  235, 1526, 1798, 1730,
 /*   960 */   551, 1437,   86, 1702,  537, 1704, 1705,  533,  242,  554,
 /*   970 */  1701,  332, 1770,  523,  121,  463,  311, 1766, 1849, 1298,
 /*   980 */   586,  122,  520,  466,  123,  498, 1260, 1804, 1526, 1202,
 /*   990 */  1156, 1200, 1693,  628,  475,  443, 1701, 1717,  223,  125,
 /*  1000 */   124,  583,  582,  581, 1718,  535,  334, 1428,   48,  244,
 /*  1010 */  1671,  559,  534, 1205, 1206,  543, 1800,  122,  123,  110,
 /*  1020 */   122, 1566,  250, 1717,  512, 1058,    3,  234,  237,  239,
 /*  1030 */  1213,  535,    5,  336, 1212, 1223, 1671, 1730,  534,  343,
 /*  1040 */    86, 1702,  537, 1704, 1705,  533,  339,  554, 1701,  262,
 /*  1050 */  1770, 1027, 1086,  298,  311, 1766, 1849, 1701, 1090, 1097,
 /*  1060 */  1095,  126,  299, 1730, 1167, 1827,   86, 1702,  537, 1704,
 /*  1070 */  1705,  533,  259,  554,  384, 1717, 1770, 1614,  163,  399,
 /*  1080 */   311, 1766, 1849,  535, 1717,  391,  398,  400, 1671,  404,
 /*  1090 */   534, 1788,  535, 1229,  405,  413, 1232, 1671,  416,  534,
 /*  1100 */   170,  417,  172,  515, 1231,  418, 1701, 1233,  419,  175,
 /*  1110 */   421,  177,  515,  422, 1230, 1730,  423,  426,  278, 1702,
 /*  1120 */   537, 1704, 1705,  533, 1730,  554,  180,  278, 1702,  537,
 /*  1130 */  1704, 1705,  533, 1717,  554,   66,  183,  445,  447, 1516,
 /*  1140 */   187,  535,  307, 1512, 1836,   89, 1671, 1701,  534,  189,
 /*  1150 */   201,  260,  476, 1836,  128,  129, 1514, 1510,  154, 1653,
 /*  1160 */   130,  131, 1833,  477,  204, 1701, 1652,  152,  483,  207,
 /*  1170 */  1228, 1833,  487, 1730, 1717,  485,   87, 1702,  537, 1704,
 /*  1180 */  1705,  533,  532,  554,  488,  480, 1770, 1671,  210,  534,
 /*  1190 */   526, 1766, 1717,  499,  494,  214, 1811,  496,  541, 1810,
 /*  1200 */   535,  217,  310,  502, 1791, 1671,    6,  534, 1801,  508,
 /*  1210 */   495,  492,  222,  493, 1730, 1323, 1701,  286, 1702,  537,
 /*  1220 */  1704, 1705,  533,  531,  554,  528, 1742, 1227,  116,  227,
 /*  1230 */    42,  524, 1730,  142,  635,  138, 1702,  537, 1704, 1705,
 /*  1240 */   533, 1785,  554, 1717,  312,  226,  224,  521,  258,   18,
 /*  1250 */  1620,  535, 1619,  228,  539,  544, 1671, 1751,  534,  225,
 /*  1260 */   145, 1832,  545,  233,  246,  546,  626,  622,  618,  614,
 /*  1270 */   257,  540, 1527,  320,  248,  261,   75, 1701,   77,  557,
 /*  1280 */   516, 1850,  518, 1730,  525, 1852,   87, 1702,  537, 1704,
 /*  1290 */  1705,  533,  236,  554, 1701,   83, 1770, 1570,  251,  238,
 /*  1300 */   264, 1767, 1499,  631, 1717,  256,  141,  511,  270,   49,
 /*  1310 */   279,  271,  535,  266,  268, 1665, 1664, 1671,   60,  534,
 /*  1320 */  1663, 1717,  338, 1660,  340,  341, 1194, 1195,  159,  535,
 /*  1330 */   491,  547,  345, 1658, 1671,  117,  534,  347,  348,  349,
 /*  1340 */  1657,  351, 1656,  353, 1730, 1701,  355,  287, 1702,  537,
 /*  1350 */  1704, 1705,  533, 1655,  554,  515, 1654,  357, 1638,  489,
 /*  1360 */   360, 1730,  208,  361,  282, 1702,  537, 1704, 1705,  533,
 /*  1370 */   160,  554, 1717,  511,  115, 1170, 1632, 1169, 1631,  366,
 /*  1380 */   535, 1175,  367,  202, 1630, 1671, 1629,  534, 1142,  229,
 /*  1390 */  1777,  510, 1607,  509,   63, 1606, 1836, 1605, 1604, 1701,
 /*  1400 */  1603,  117, 1602,  507, 1601, 1600, 1599, 1598, 1701, 1597,
 /*  1410 */   152, 1596, 1730, 1595, 1833,  138, 1702,  537, 1704, 1705,
 /*  1420 */   533, 1594,  554, 1593, 1592, 1591, 1717, 1590, 1589,  120,
 /*  1430 */  1588, 1587, 1586, 1585,  535, 1717, 1144, 1582, 1581, 1671,
 /*  1440 */   115,  534, 1584,  532, 1583, 1580, 1579, 1456, 1671, 1424,
 /*  1450 */   534,  146,  315,  111,  965,  150, 1777, 1778,  168, 1782,
 /*  1460 */  1423, 1851, 1701,  409,  964, 1646, 1730,  169, 1640,  287,
 /*  1470 */  1702,  537, 1704, 1705,  533, 1730,  554,  511,  286, 1702,
 /*  1480 */   537, 1704, 1705,  533, 1628,  554,  176, 1743,  112, 1717,
 /*  1490 */  1627,  174,  411, 1617,  179, 1505, 1455,  535,  993, 1453,
 /*  1500 */   185,  429, 1671,  427,  534,  117,  428, 1451,  433, 1449,
 /*  1510 */   431,  432,  140, 1701,  437,  317,  435,  436,  442,  438,
 /*  1520 */   434,  430,  184, 1447,  440,  439,  441, 1701, 1436, 1730,
 /*  1530 */  1435, 1422,  287, 1702,  537, 1704, 1705,  533, 1101,  554,
 /*  1540 */  1717, 1507,   47,  186,  115, 1506, 1100,   68,  535, 1026,
 /*  1550 */   182, 1025, 1024, 1671, 1717,  534,  601, 1023,  603,  151,
 /*  1560 */  1777, 1778,  535, 1782, 1445, 1020,  319, 1671, 1019,  534,
 /*  1570 */   304, 1440, 1018,  305,  464, 1438,  306, 1421,  469,  467,
 /*  1580 */  1730, 1420, 1701,  287, 1702,  537, 1704, 1705,  533,  471,
 /*  1590 */   554, 1701,   88, 1645, 1730, 1639, 1177,  272, 1702,  537,
 /*  1600 */  1704, 1705,  533, 1626,  554, 1701,   51,  478,  132, 1717,
 /*  1610 */   181, 1625,  173, 1624,  178,  205,  420,  535, 1717, 1616,
 /*  1620 */    71,  479, 1671,   50,  534,  209,  535,    4,  211, 1364,
 /*  1630 */    39, 1671, 1717,  534,   23,  171,  221,   15,  213,   45,
 /*  1640 */   535,  215, 1348,  139,  219, 1671,   24,  534, 1341, 1730,
 /*  1650 */   220, 1691,  273, 1702,  537, 1704, 1705,  533, 1730,  554,
 /*  1660 */    72,  274, 1702,  537, 1704, 1705,  533,   25,  554, 1320,
 /*  1670 */    44,  230, 1730, 1319,   16,  281, 1702,  537, 1704, 1705,
 /*  1680 */   533, 1701,  554,   43,  143,   17, 1381, 1370, 1376, 1375,
 /*  1690 */   313,   13, 1380, 1379,  314,   10, 1283,   19, 1701,  144,
 /*  1700 */  1262,   31, 1247, 1261,   12,   20,  156, 1701, 1717,   21,
 /*  1710 */  1615,  243,  536,  241, 1346,  245,  535,   73,  247,  542,
 /*  1720 */    74, 1671, 1690,  534,   78, 1717,  249,  252, 1217, 1733,
 /*  1730 */   556, 1264,  553,  535, 1717,   46,  558,  327, 1671, 1087,
 /*  1740 */   534,  560,  535, 1084,  562,  563,  565, 1671, 1730,  534,
 /*  1750 */  1081,  283, 1702,  537, 1704, 1705,  533,  566,  554, 1701,
 /*  1760 */   568, 1075,  571,  569, 1079, 1730, 1073,  572,  275, 1702,
 /*  1770 */   537, 1704, 1705,  533, 1730,  554, 1078,  284, 1702,  537,
 /*  1780 */  1704, 1705,  533, 1701,  554, 1064, 1717,  578,   79,   80,
 /*  1790 */  1077, 1096, 1076,   57,  535,  254, 1092,  991,  587, 1671,
 /*  1800 */  1701,  534, 1015, 1033,  590,  255, 1013, 1012, 1011, 1010,
 /*  1810 */  1717, 1008, 1009, 1007, 1006, 1030, 1028, 1003,  535, 1002,
 /*  1820 */  1001, 1452,  998, 1671,  997,  534, 1730, 1717,  996,  276,
 /*  1830 */  1702,  537, 1704, 1705,  533,  535,  554,  611,  612,  613,
 /*  1840 */  1671, 1450,  534,  615,  616,  617, 1448,  621,  619,  620,
 /*  1850 */  1730, 1701, 1446,  285, 1702,  537, 1704, 1705,  533,  623,
 /*  1860 */   554,  624, 1701,  625, 1434,  627, 1419, 1730,  634,  629,
 /*  1870 */   277, 1702,  537, 1704, 1705,  533,  630,  554, 1717, 1203,
 /*  1880 */   265,  633, 1394, 1394, 1394, 1394,  535, 1394, 1394, 1717,
 /*  1890 */  1394, 1671, 1394,  534, 1394, 1394, 1394,  535, 1394, 1394,
 /*  1900 */  1394, 1394, 1671, 1701,  534, 1394, 1394, 1394, 1394, 1394,
 /*  1910 */  1394, 1394, 1394, 1394, 1701, 1394, 1394, 1394, 1730, 1394,
 /*  1920 */  1394, 1713, 1702,  537, 1704, 1705,  533, 1394,  554, 1730,
 /*  1930 */  1717, 1394, 1712, 1702,  537, 1704, 1705,  533,  535,  554,
 /*  1940 */  1394, 1717, 1394, 1671, 1394,  534, 1394, 1394, 1394,  535,
 /*  1950 */  1394, 1394, 1394, 1394, 1671, 1394,  534, 1394, 1394, 1394,
 /*  1960 */  1394, 1394, 1394, 1394, 1394, 1394, 1394, 1701, 1394, 1394,
 /*  1970 */  1730, 1394, 1394, 1711, 1702,  537, 1704, 1705,  533, 1701,
 /*  1980 */   554, 1730, 1394, 1394,  296, 1702,  537, 1704, 1705,  533,
 /*  1990 */  1394,  554, 1394, 1701, 1717, 1394, 1394, 1394, 1394, 1394,
 /*  2000 */  1394, 1394,  535, 1394, 1394, 1394, 1717, 1671, 1394,  534,
 /*  2010 */  1394, 1394, 1394, 1394,  535, 1394, 1394, 1394, 1394, 1671,
 /*  2020 */  1717,  534, 1394, 1394, 1394, 1394, 1394, 1394,  535, 1394,
 /*  2030 */  1394, 1394, 1394, 1671, 1730,  534, 1394,  295, 1702,  537,
 /*  2040 */  1704, 1705,  533, 1394,  554, 1701, 1730, 1394, 1394,  297,
 /*  2050 */  1702,  537, 1704, 1705,  533, 1394,  554, 1394, 1394, 1394,
 /*  2060 */  1730, 1394, 1394,  294, 1702,  537, 1704, 1705,  533, 1394,
 /*  2070 */   554, 1394, 1717, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
 /*  2080 */   535, 1394, 1394, 1394, 1394, 1671, 1394,  534, 1394, 1394,
 /*  2090 */  1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
 /*  2100 */  1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394, 1394,
 /*  2110 */  1394, 1394, 1730, 1394, 1394,  280, 1702,  537, 1704, 1705,
 /*  2120 */   533, 1394,  554,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   274,  341,  273,  277,  248,  274,  250,  251,  277,  242,
 /*    10 */   257,  285,   12,   13,  261,  355,  285,  245,   14,  359,
 /*    20 */    20,  252,   22,  252,   20,   12,   13,   14,   15,   16,
 /*    30 */    12,   13,  263,  248,  263,  250,  251,  311,  312,  270,
 /*    40 */    22,  270,  311,  312,  272,  326,  327,   47,  322,  280,
 /*    50 */   313,  280,  280,  322,   41,  252,   20,  285,   58,  287,
 /*    60 */    12,   13,   14,  264,   64,   47,  263,  300,   20,  245,
 /*    70 */    22,  272,  300,  300,  337,   12,   13,   14,   15,   16,
 /*    80 */   281,   81,   64,  280,  312,  256,   20,  315,  316,  317,
 /*    90 */   318,  319,  320,   81,  322,   47,  272,  325,  269,  254,
 /*   100 */   252,  329,  330,  103,  280,  252,   58,  278,  341,  285,
 /*   110 */   245,  287,   64,  341,  341,  287,  263,  117,  118,    4,
 /*   120 */   275,  103,  355,    4,   20,  297,  359,  355,  355,   81,
 /*   130 */    57,  359,  359,  280,   55,  254,  312,  289,   19,  315,
 /*   140 */   316,  317,  318,  319,  320,   82,  322,   81,  267,  325,
 /*   150 */   285,  103,   33,  329,  330,  331,  275,   42,   43,  159,
 /*   160 */    81,  161,   83,  264,   45,  117,  118,  343,    3,   50,
 /*   170 */   158,  272,  160,   20,   55,  351,  352,  159,  283,  161,
 /*   180 */   281,  286,  287,  183,  184,   81,  186,  187,  188,  189,
 /*   190 */   190,  191,  192,  193,  194,  195,  196,  197,  198,   80,
 /*   200 */    20,  183,   83,  286,  287,    2,    4,  159,  341,  161,
 /*   210 */    20,  211,  194,  195,  196,   12,   13,   14,   15,   16,
 /*   220 */    12,   13,  355,  211,  245,  245,  359,   75,   20,  256,
 /*   230 */    22,  183,  184,   35,  186,  187,  188,  189,  190,  191,
 /*   240 */   192,  193,  194,  195,  196,  197,  198,  252,  272,   60,
 /*   250 */    61,  278,  272,  300,   65,   47,  280,   68,   69,    0,
 /*   260 */   280,   72,   73,   74,  285,  285,   58,  287,   12,   13,
 /*   270 */   117,  118,   64,  121,  122,  280,   20,  211,   22,  142,
 /*   280 */   300,    0,   84,   81,   86,   87,  154,   89,   81,   81,
 /*   290 */   211,   93,  312,  317,  341,  315,  316,  317,  318,  319,
 /*   300 */   320,  164,  322,   47,   45,  325,  174,  175,  355,  329,
 /*   310 */   330,  103,  359,  115,  319,   12,   13,   14,   15,   16,
 /*   320 */    64,  341,  244,  274,  246,  117,  118,    0,  333,  334,
 /*   330 */   335,  336,    4,  338,  285,  355,  199,   81,   57,  359,
 /*   340 */    94,   95,   96,   97,   98,   99,  100,  101,  102,  103,
 /*   350 */   104,    0,  106,  107,  108,  109,  110,  111,   81,  103,
 /*   360 */   311,  312,   12,   13,   14,   15,   16,  159,   91,  161,
 /*   370 */   183,  322,   21,  117,  118,   24,   25,   26,   27,   28,
 /*   380 */    29,   30,   31,   32,   57,   82,   12,   13,   14,   15,
 /*   390 */    16,  183,  184,  228,  186,  187,  188,  189,  190,  191,
 /*   400 */   192,  193,  194,  195,  196,  197,  198,  220,  221,  222,
 /*   410 */   223,  224,   20,  211,   22,  159,   21,  161,  211,   24,
 /*   420 */    25,   26,   27,   28,   29,   30,   31,   32,   12,   13,
 /*   430 */    14,  249,  249,  245,  252,  252,   20,   55,   22,  183,
 /*   440 */   184,   49,  186,  187,  188,  189,  190,  191,  192,  193,
 /*   450 */   194,  195,  196,  197,  198,   12,   13,   14,   15,   16,
 /*   460 */   272,  300,   80,   47,  341,   83,   47,  211,  280,   20,
 /*   470 */   113,   22,  272,  285,  245,  287,   12,   13,  355,  279,
 /*   480 */    64,    0,  359,   64,   20,  313,   22,  260,  288,  262,
 /*   490 */    12,   13,   14,   15,   16,  245,   47,   81,   49,  146,
 /*   500 */   312,  151,  341,  315,  316,  317,  318,  319,  320,  337,
 /*   510 */   322,   47,  112,  325,  285,   20,  355,  329,  330,  103,
 /*   520 */   359,  287,  148,  272,  271,   82,  169,  170,   64,  295,
 /*   530 */   279,  297,   57,  117,  118,  285,   58,  284,  245,  288,
 /*   540 */   212,   60,   61,   62,   63,   81,   65,   66,   67,   68,
 /*   550 */    69,   70,   71,   72,   73,   74,   75,   76,   77,   78,
 /*   560 */    82,    0,   12,   13,   14,   15,   16,  103,   90,  216,
 /*   570 */   217,  171,  172,   20,   14,  159,  245,  161,  285,  245,
 /*   580 */    20,  117,  118,  233,    2,   24,   25,   26,   27,   28,
 /*   590 */    29,   30,   31,   32,   12,   13,   14,   15,   16,  183,
 /*   600 */   184,  245,  186,  187,  188,  189,  190,  191,  192,  193,
 /*   610 */   194,  195,  196,  197,  198,  252,  285,  272,  272,  285,
 /*   620 */   142,   20,  264,  159,  279,  161,  263,  281,   14,  245,
 /*   630 */   272,  258,  259,  288,   20,   64,   12,   13,    0,  281,
 /*   640 */    20,  285,  164,  280,   20,    0,   22,  183,  184,   58,
 /*   650 */   186,  187,  188,  189,  190,  191,  192,  193,  194,  195,
 /*   660 */   196,  197,  198,    1,    2,   14,   15,   16,  313,  285,
 /*   670 */    92,   47,   12,   13,   14,   15,   16,  199,  200,  201,
 /*   680 */   202,  203,  204,  205,  206,  207,  208,  282,   64,  252,
 /*   690 */   285,  274,  337,  258,  259,  245,   37,  252,   60,   61,
 /*   700 */    93,  148,  285,   65,  252,   81,   68,   69,  263,   93,
 /*   710 */    72,   73,   74,  245,  272,  263,   20,  280,   58,  112,
 /*   720 */   113,  114,  115,  116,   18,  280,   20,  103,  311,  312,
 /*   730 */   288,  115,  280,   27,  252,  285,   30,  300,   93,  322,
 /*   740 */   282,  117,  118,  285,   82,  263,   18,  187,  245,  245,
 /*   750 */    90,   23,  265,  285,   48,  268,  319,  112,  113,  114,
 /*   760 */   115,  116,  280,   35,   36,  245,  252,   39,  148,  252,
 /*   770 */   252,  334,  335,  336,  183,  338,  252,  263,  341,  280,
 /*   780 */   263,  263,   41,  159,   56,  161,   80,  263,  285,  285,
 /*   790 */   291,   64,  355,   41,  280,  252,  359,  280,  280,   42,
 /*   800 */    43,  187,  142,  273,  280,  285,  263,  183,  184,   81,
 /*   810 */   186,  187,  188,  189,  190,  191,  192,  193,  194,  195,
 /*   820 */   196,  197,  198,  280,  164,  273,  120,  209,  210,  123,
 /*   830 */   124,  125,  126,  127,  128,  129,  130,  131,  132,  133,
 /*   840 */   134,  135,  136,  137,  138,  139,  140,  119,  245,  273,
 /*   850 */    85,  245,   22,   88,  273,  245,  245,  245,  245,  199,
 /*   860 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  210,
 /*   870 */    41,   85,   85,   85,   88,   88,   88,   47,  272,  151,
 /*   880 */   152,  153,  273,  187,  156,   47,  280,    0,  285,  252,
 /*   890 */   162,  285,  245,  287,   64,  285,  285,  285,  285,   21,
 /*   900 */   263,  173,   64,   41,  176,   41,  178,  179,  180,  181,
 /*   910 */   182,   82,   34,   41,    1,    2,   47,  280,  312,  272,
 /*   920 */    47,  315,  316,  317,  318,  319,  320,  280,  322,  252,
 /*   930 */     0,  325,  285,  103,  287,  329,  330,  331,   41,  211,
 /*   940 */   263,  117,  118,  273,   82,   41,   82,    0,  304,   41,
 /*   950 */   246,  261,   22,    0,   82,   44,  362,  280,  352,  312,
 /*   960 */   252,    0,  315,  316,  317,  318,  319,  320,   41,  322,
 /*   970 */   245,  263,  325,  232,   41,   22,  329,  330,  331,   82,
 /*   980 */    93,   41,  230,   22,   41,  353,   82,  340,  280,  159,
 /*   990 */    82,  161,   81,   46,  308,  253,  245,  272,  348,  112,
 /*  1000 */   113,  114,  115,  116,  272,  280,  253,  251,   41,   82,
 /*  1010 */   285,   41,  287,  183,  184,   82,  314,   41,   41,   41,
 /*  1020 */    41,  284,   82,  272,  339,   82,  342,  356,  356,  356,
 /*  1030 */   161,  280,  213,  310,  161,   20,  285,  312,  287,   45,
 /*  1040 */   315,  316,  317,  318,  319,  320,  252,  322,  245,   82,
 /*  1050 */   325,   47,   82,  309,  329,  330,  331,  245,   82,   82,
 /*  1060 */    82,   82,  258,  312,  157,  340,  315,  316,  317,  318,
 /*  1070 */   319,  320,  302,  322,  252,  272,  325,  252,   40,  142,
 /*  1080 */   329,  330,  331,  280,  272,  292,  290,  290,  285,  252,
 /*  1090 */   287,  340,  280,   20,  247,  247,   20,  285,  306,  287,
 /*  1100 */   256,  287,  256,  300,   20,  299,  245,   20,  301,  256,
 /*  1110 */   299,  256,  300,  280,   20,  312,  293,  252,  315,  316,
 /*  1120 */   317,  318,  319,  320,  312,  322,  256,  315,  316,  317,
 /*  1130 */   318,  319,  320,  272,  322,  256,  256,  247,  272,  272,
 /*  1140 */   272,  280,  247,  272,  341,  252,  285,  245,  287,  272,
 /*  1150 */   254,  306,  167,  341,  272,  272,  272,  272,  355,  285,
 /*  1160 */   272,  272,  359,  305,  254,  245,  285,  355,  252,  254,
 /*  1170 */    20,  359,  280,  312,  272,  299,  315,  316,  317,  318,
 /*  1180 */   319,  320,  280,  322,  293,  287,  325,  285,  254,  287,
 /*  1190 */   329,  330,  272,  219,  285,  296,  347,  285,  218,  347,
 /*  1200 */   280,  296,  285,  285,  350,  285,  225,  287,  314,  150,
 /*  1210 */   227,  214,  349,  226,  312,  210,  245,  315,  316,  317,
 /*  1220 */   318,  319,  320,  321,  322,  323,  324,   20,  280,  310,
 /*  1230 */    40,  231,  312,  347,   19,  315,  316,  317,  318,  319,
 /*  1240 */   320,  313,  322,  272,  234,  344,  346,  229,   33,   81,
 /*  1250 */   296,  280,  296,  332,  285,  145,  285,  328,  287,  345,
 /*  1260 */    45,  358,  294,  357,  280,  293,   51,   52,   53,   54,
 /*  1270 */    55,  285,  280,  285,  254,  268,  254,  245,   81,  276,
 /*  1280 */   360,  361,  358,  312,  358,  363,  315,  316,  317,  318,
 /*  1290 */   319,  320,  357,  322,  245,   80,  325,  285,   83,  357,
 /*  1300 */   252,  330,  262,  247,  272,  254,  307,  252,  266,  303,
 /*  1310 */   266,  266,  280,  255,  243,    0,    0,  285,   40,  287,
 /*  1320 */     0,  272,   72,    0,   47,  177,   47,   47,   47,  280,
 /*  1330 */   298,  116,  177,    0,  285,  280,  287,   47,   47,  177,
 /*  1340 */     0,  177,    0,   47,  312,  245,   22,  315,  316,  317,
 /*  1350 */   318,  319,  320,    0,  322,  300,    0,   47,    0,  144,
 /*  1360 */   164,  312,  147,  163,  315,  316,  317,  318,  319,  320,
 /*  1370 */    81,  322,  272,  252,  319,  161,    0,  159,    0,  155,
 /*  1380 */   280,  166,  154,  168,    0,  285,    0,  287,   44,  334,
 /*  1390 */   335,  336,    0,  338,  141,    0,  341,    0,    0,  245,
 /*  1400 */     0,  280,    0,  354,    0,    0,    0,    0,  245,    0,
 /*  1410 */   355,    0,  312,    0,  359,  315,  316,  317,  318,  319,
 /*  1420 */   320,    0,  322,    0,    0,    0,  272,    0,    0,   40,
 /*  1430 */     0,    0,    0,    0,  280,  272,   22,    0,    0,  285,
 /*  1440 */   319,  287,    0,  280,    0,    0,    0,    0,  285,    0,
 /*  1450 */   287,   41,  298,   37,   14,  334,  335,  336,   40,  338,
 /*  1460 */     0,  361,  245,   44,   14,    0,  312,   38,    0,  315,
 /*  1470 */   316,  317,  318,  319,  320,  312,  322,  252,  315,  316,
 /*  1480 */   317,  318,  319,  320,    0,  322,  150,  324,   37,  272,
 /*  1490 */     0,   37,   44,    0,   37,    0,    0,  280,   59,    0,
 /*  1500 */    33,   37,  285,   47,  287,  280,   45,    0,   37,    0,
 /*  1510 */    47,   45,   45,  245,   37,  298,   47,   45,   51,   52,
 /*  1520 */    53,   54,   55,    0,   45,   47,   37,  245,    0,  312,
 /*  1530 */     0,    0,  315,  316,  317,  318,  319,  320,   47,  322,
 /*  1540 */   272,    0,   90,   88,  319,    0,   22,   80,  280,   47,
 /*  1550 */    83,   47,   47,  285,  272,  287,   41,   47,   41,  334,
 /*  1560 */   335,  336,  280,  338,    0,   47,  298,  285,   47,  287,
 /*  1570 */    22,    0,   47,   22,   48,    0,   22,    0,   22,   47,
 /*  1580 */   312,    0,  245,  315,  316,  317,  318,  319,  320,   22,
 /*  1590 */   322,  245,   20,    0,  312,    0,   47,  315,  316,  317,
 /*  1600 */   318,  319,  320,    0,  322,  245,  148,   22,  165,  272,
 /*  1610 */   143,    0,  145,    0,  147,  145,  149,  280,  272,    0,
 /*  1620 */    81,  148,  285,  148,  287,   37,  280,   41,  143,   82,
 /*  1630 */    41,  285,  272,  287,   81,  168,   44,  215,   81,   41,
 /*  1640 */   280,   82,   82,   81,   81,  285,   81,  287,   82,  312,
 /*  1650 */    41,   44,  315,  316,  317,  318,  319,  320,  312,  322,
 /*  1660 */    81,  315,  316,  317,  318,  319,  320,   41,  322,   82,
 /*  1670 */    41,   44,  312,   82,  215,  315,  316,  317,  318,  319,
 /*  1680 */   320,  245,  322,  209,   44,   41,   82,   82,   47,   47,
 /*  1690 */    47,  215,   47,   47,   47,    2,  183,   41,  245,   44,
 /*  1700 */    82,   81,   22,   82,   81,   81,   44,  245,  272,   81,
 /*  1710 */     0,   81,  185,   82,   82,   81,  280,   81,   37,  146,
 /*  1720 */    81,  285,   44,  287,   91,  272,  143,   44,   22,   81,
 /*  1730 */    92,   82,   81,  280,  272,   81,   47,   47,  285,   82,
 /*  1740 */   287,   81,  280,   82,   47,   81,   47,  285,  312,  287,
 /*  1750 */    82,  315,  316,  317,  318,  319,  320,   81,  322,  245,
 /*  1760 */    47,   82,   47,   81,  105,  312,   82,   81,  315,  316,
 /*  1770 */   317,  318,  319,  320,  312,  322,  105,  315,  316,  317,
 /*  1780 */   318,  319,  320,  245,  322,   22,  272,   93,   81,   81,
 /*  1790 */   105,   47,  105,   81,  280,   41,   22,   59,   58,  285,
 /*  1800 */   245,  287,   47,   64,   79,   41,   47,   47,   47,   47,
 /*  1810 */   272,   22,   47,   47,   47,   64,   47,   47,  280,   47,
 /*  1820 */    47,    0,   47,  285,   47,  287,  312,  272,   47,  315,
 /*  1830 */   316,  317,  318,  319,  320,  280,  322,   47,   45,   37,
 /*  1840 */   285,    0,  287,   47,   45,   37,    0,   37,   47,   45,
 /*  1850 */   312,  245,    0,  315,  316,  317,  318,  319,  320,   47,
 /*  1860 */   322,   45,  245,   37,    0,   47,    0,  312,   20,   22,
 /*  1870 */   315,  316,  317,  318,  319,  320,   21,  322,  272,   22,
 /*  1880 */    22,   21,  364,  364,  364,  364,  280,  364,  364,  272,
 /*  1890 */   364,  285,  364,  287,  364,  364,  364,  280,  364,  364,
 /*  1900 */   364,  364,  285,  245,  287,  364,  364,  364,  364,  364,
 /*  1910 */   364,  364,  364,  364,  245,  364,  364,  364,  312,  364,
 /*  1920 */   364,  315,  316,  317,  318,  319,  320,  364,  322,  312,
 /*  1930 */   272,  364,  315,  316,  317,  318,  319,  320,  280,  322,
 /*  1940 */   364,  272,  364,  285,  364,  287,  364,  364,  364,  280,
 /*  1950 */   364,  364,  364,  364,  285,  364,  287,  364,  364,  364,
 /*  1960 */   364,  364,  364,  364,  364,  364,  364,  245,  364,  364,
 /*  1970 */   312,  364,  364,  315,  316,  317,  318,  319,  320,  245,
 /*  1980 */   322,  312,  364,  364,  315,  316,  317,  318,  319,  320,
 /*  1990 */   364,  322,  364,  245,  272,  364,  364,  364,  364,  364,
 /*  2000 */   364,  364,  280,  364,  364,  364,  272,  285,  364,  287,
 /*  2010 */   364,  364,  364,  364,  280,  364,  364,  364,  364,  285,
 /*  2020 */   272,  287,  364,  364,  364,  364,  364,  364,  280,  364,
 /*  2030 */   364,  364,  364,  285,  312,  287,  364,  315,  316,  317,
 /*  2040 */   318,  319,  320,  364,  322,  245,  312,  364,  364,  315,
 /*  2050 */   316,  317,  318,  319,  320,  364,  322,  364,  364,  364,
 /*  2060 */   312,  364,  364,  315,  316,  317,  318,  319,  320,  364,
 /*  2070 */   322,  364,  272,  364,  364,  364,  364,  364,  364,  364,
 /*  2080 */   280,  364,  364,  364,  364,  285,  364,  287,  364,  364,
 /*  2090 */   364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
 /*  2100 */   364,  364,  364,  364,  364,  364,  364,  364,  364,  364,
 /*  2110 */   364,  364,  312,  364,  364,  315,  316,  317,  318,  319,
 /*  2120 */   320,  364,  322,  364,
};
#define YY_SHIFT_COUNT    (635)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1866)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   728,    0,    0,   48,  208,  208,  208,  208,  256,  256,
 /*    10 */   208,  208,  416,  464,  624,  464,  464,  464,  464,  464,
 /*    20 */   464,  464,  464,  464,  464,  464,  464,  464,  464,  464,
 /*    30 */   464,  464,  464,  464,  464,  464,  464,  464,  464,  464,
 /*    40 */    66,   66,  104,  104,  104,   18,   18,   18,   18,   12,
 /*    50 */    79,  207,   36,   36,  115,  115,  202,  153,  207,  207,
 /*    60 */    36,   36,   36,   36,   36,   36,   36,   36,   73,   36,
 /*    70 */    36,  180,  190,  495,  180,   36,   36,  180,   36,  180,
 /*    80 */   180,  180,   36,  475,  706,  478,  660,  660,  395,  189,
 /*    90 */   830,  830,  830,  830,  830,  830,  830,  830,  830,  830,
 /*   100 */   830,  830,  830,  830,  830,  830,  830,  830,  830,  198,
 /*   110 */   153,    4,    4,  281,  419,  553,  553,  553,  327,  419,
 /*   120 */   601,  495,  180,  180,  571,  571,  578,  727,  246,  246,
 /*   130 */   246,  246,  246,  246,  246, 1215,  351,  638,  350,  187,
 /*   140 */   449,  357,  353,  560,  614,  392,  757,  616,  620,  618,
 /*   150 */   659,  618,  165,  165,  165,  328,  696,  819, 1015,  994,
 /*   160 */  1004,  907, 1015, 1015, 1038,  937,  937, 1015, 1073, 1073,
 /*   170 */  1076,   73,  495,   73, 1084, 1087,   73, 1084,   73,  601,
 /*   180 */  1094,   73,   73, 1015,   73, 1073,  180,  180,  180,  180,
 /*   190 */   180,  180,  180,  180,  180,  180,  180, 1015, 1073,  571,
 /*   200 */   571, 1076,  475,  985,  495,  475, 1015, 1084,  475,  601,
 /*   210 */  1094,  475, 1150,  571,  974,  980,  571,  974,  980,  571,
 /*   220 */   571,  180,  981, 1059,  974,  983,  987,  997,  819, 1005,
 /*   230 */   601, 1207, 1190, 1000, 1018, 1010, 1000, 1018, 1000, 1018,
 /*   240 */  1168,  980,  571,  571,  980,  571, 1110,  601, 1094,  475,
 /*   250 */   578,  475,  601, 1197,  571,  727, 1015,  475, 1073, 2123,
 /*   260 */  2123, 2123, 2123, 2123, 2123, 2123,  481, 1467,  561,  119,
 /*   270 */   645,  887,   63,   13,  303,  203,  582,  374,  443,  607,
 /*   280 */   550,  550,  550,  550,  550,  550,  550,  550,  132,  382,
 /*   290 */   152,  400,  662,  137,  651,  651,  651,  651,  259,  829,
 /*   300 */   765,  786,  787,  788,  930,  953,  961,  878,  862,  864,
 /*   310 */   872,  913,  824,  752,  741,  897,  591,  904,  911,  908,
 /*   320 */   927,  933,  940,  943,  869,  873,  967,  970,  976,  977,
 /*   330 */   978,  979,  277,  838,  947, 1315, 1316, 1278, 1320, 1250,
 /*   340 */  1323, 1277, 1148, 1279, 1280, 1281, 1155, 1333, 1290, 1291,
 /*   350 */  1162, 1340, 1164, 1342, 1296, 1353, 1324, 1356, 1310, 1358,
 /*   360 */  1289, 1196, 1200, 1214, 1218, 1376, 1378, 1224, 1228, 1384,
 /*   370 */  1386, 1344, 1392, 1253, 1395, 1397, 1398, 1400, 1402, 1404,
 /*   380 */  1405, 1406, 1407, 1409, 1411, 1413, 1421, 1423, 1424, 1425,
 /*   390 */  1427, 1428, 1389, 1430, 1431, 1432, 1433, 1442, 1444, 1414,
 /*   400 */  1437, 1438, 1445, 1446, 1447, 1449, 1418, 1416, 1410, 1440,
 /*   410 */  1419, 1450, 1448, 1460, 1429, 1451, 1465, 1468, 1484, 1454,
 /*   420 */  1336, 1490, 1493, 1457, 1495, 1439, 1496, 1499, 1456, 1461,
 /*   430 */  1464, 1507, 1463, 1466, 1471, 1509, 1469, 1472, 1477, 1523,
 /*   440 */  1478, 1479, 1489, 1528, 1530, 1531, 1541, 1452, 1455, 1491,
 /*   450 */  1524, 1545, 1502, 1504, 1505, 1510, 1515, 1517, 1518, 1521,
 /*   460 */  1525, 1564, 1548, 1571, 1551, 1526, 1575, 1554, 1532, 1577,
 /*   470 */  1556, 1581, 1567, 1572, 1593, 1458, 1549, 1595, 1443, 1585,
 /*   480 */  1473, 1470, 1603, 1611, 1613, 1475, 1619, 1539, 1588, 1485,
 /*   490 */  1586, 1589, 1422, 1553, 1547, 1557, 1559, 1598, 1560, 1562,
 /*   500 */  1563, 1565, 1566, 1609, 1592, 1607, 1579, 1626, 1459, 1587,
 /*   510 */  1591, 1627, 1474, 1629, 1640, 1604, 1644, 1476, 1605, 1641,
 /*   520 */  1642, 1643, 1645, 1646, 1647, 1605, 1693, 1513, 1656, 1618,
 /*   530 */  1620, 1621, 1655, 1623, 1624, 1662, 1680, 1527, 1628, 1631,
 /*   540 */  1632, 1630, 1634, 1573, 1636, 1710, 1681, 1583, 1639, 1633,
 /*   550 */  1678, 1683, 1648, 1649, 1651, 1706, 1654, 1638, 1657, 1689,
 /*   560 */  1690, 1660, 1661, 1697, 1664, 1668, 1699, 1676, 1679, 1713,
 /*   570 */  1682, 1684, 1715, 1686, 1659, 1671, 1685, 1687, 1763, 1694,
 /*   580 */  1707, 1708, 1744, 1712, 1754, 1754, 1774, 1738, 1740, 1755,
 /*   590 */  1739, 1725, 1764, 1759, 1760, 1761, 1762, 1765, 1789, 1766,
 /*   600 */  1767, 1751, 1515, 1769, 1517, 1770, 1772, 1773, 1775, 1777,
 /*   610 */  1781, 1821, 1790, 1793, 1802, 1841, 1796, 1799, 1808, 1846,
 /*   620 */  1801, 1804, 1810, 1852, 1812, 1816, 1826, 1864, 1818, 1866,
 /*   630 */  1847, 1855, 1857, 1858, 1860, 1848,
};
#define YY_REDUCE_COUNT (265)
#define YY_REDUCE_MIN   (-340)
#define YY_REDUCE_MAX   (1800)
static const short yy_reduce_ofst[] = {
 /*     0 */  -233, -228,  -20, -176,  606,  647,  725,  751,  803,  812,
 /*    10 */   188,  861,  902,  920,  971, 1032, 1049, 1100, 1154, 1163,
 /*    20 */  1217, 1268, 1282, 1337, 1346, 1360, 1436, 1453, 1462, 1514,
 /*    30 */  1538, 1555, 1606, 1617, 1658, 1669, 1722, 1734, 1748, 1800,
 /*    40 */   437, 1055,   -5, 1121, 1225, -274, -269,   49,  417, -227,
 /*    50 */   -47,  161, -231, -229, -244, -215, -340, -105, -133,  123,
 /*    60 */  -197, -147,  363,  445,  452,  482,  514,  517, -171,  518,
 /*    70 */   543,  200,  -24,  234, -201,  637,  677,  251,  524, -101,
 /*    80 */   345,  358,  708, -119, -152, -281, -281, -281,   78, -247,
 /*    90 */  -135,  -21,  229,  250,  293,  331,  334,  356,  384,  450,
 /*   100 */   468,  503,  504,  520,  603,  610,  611,  612,  613,  253,
 /*   110 */   -83,  182,  183,  -27,  373, -263,  172,  355, -155,  435,
 /*   120 */   499, -172,  346,  442,  405,  458,  487,  227, -271,  530,
 /*   130 */   552,  576,  581,  609,  670,  644,  704,  690,  594,  632,
 /*   140 */   742,  686,  650,  732,  732,  753,  756,  737,  702,  685,
 /*   150 */   685,  685,  671,  672,  673,  684,  732,  723,  794,  744,
 /*   160 */   804,  770,  822,  825,  793,  796,  797,  837,  847,  848,
 /*   170 */   792,  844,  814,  846,  806,  807,  853,  811,  855,  833,
 /*   180 */   823,  870,  879,  865,  880,  890,  866,  867,  868,  871,
 /*   190 */   877,  882,  883,  884,  885,  888,  889,  893,  895,  874,
 /*   200 */   881,  845,  896,  858,  898,  910,  916,  876,  915,  892,
 /*   210 */   891,  934,  894,  909,  849,  899,  912,  852,  905,  917,
 /*   220 */   918,  732,  854,  863,  886,  900,  914,  901,  919,  685,
 /*   230 */   948,  928,  921,  903,  906,  922,  924,  935,  926,  942,
 /*   240 */   929,  954,  969,  986,  956,  988,  968,  984,  972, 1020,
 /*   250 */  1007, 1022,  992, 1003, 1012, 1040, 1048, 1051, 1056, 1006,
 /*   260 */   999, 1042, 1044, 1045, 1058, 1071,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*    10 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*    20 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*    30 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*    40 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*    50 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*    60 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1461, 1392,
 /*    70 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*    80 */  1392, 1392, 1392, 1459, 1608, 1392, 1772, 1392, 1392, 1392,
 /*    90 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   100 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   110 */  1392, 1392, 1392, 1461, 1392, 1783, 1783, 1783, 1459, 1392,
 /*   120 */  1392, 1392, 1392, 1392, 1392, 1392, 1555, 1392, 1392, 1392,
 /*   130 */  1392, 1392, 1392, 1392, 1392, 1641, 1392, 1392, 1853, 1392,
 /*   140 */  1392, 1647, 1807, 1392, 1392, 1392, 1392, 1508, 1799, 1775,
 /*   150 */  1789, 1776, 1838, 1838, 1838, 1792, 1392, 1803, 1392, 1392,
 /*   160 */  1392, 1633, 1392, 1392, 1613, 1610, 1610, 1392, 1392, 1392,
 /*   170 */  1392, 1461, 1392, 1461, 1392, 1392, 1461, 1392, 1461, 1392,
 /*   180 */  1392, 1461, 1461, 1392, 1461, 1392, 1392, 1392, 1392, 1392,
 /*   190 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   200 */  1392, 1392, 1459, 1643, 1392, 1459, 1392, 1392, 1459, 1392,
 /*   210 */  1392, 1459, 1392, 1392, 1814, 1812, 1392, 1814, 1812, 1392,
 /*   220 */  1392, 1392, 1826, 1822, 1814, 1830, 1828, 1805, 1803, 1789,
 /*   230 */  1392, 1392, 1392, 1844, 1840, 1856, 1844, 1840, 1844, 1840,
 /*   240 */  1392, 1812, 1392, 1392, 1812, 1392, 1618, 1392, 1392, 1459,
 /*   250 */  1392, 1459, 1392, 1524, 1392, 1392, 1392, 1459, 1392, 1635,
 /*   260 */  1649, 1558, 1558, 1558, 1462, 1397, 1392, 1392, 1392, 1392,
 /*   270 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1520,
 /*   280 */  1716, 1825, 1824, 1748, 1747, 1746, 1744, 1715, 1392, 1392,
 /*   290 */  1392, 1392, 1392, 1392, 1709, 1710, 1708, 1707, 1392, 1392,
 /*   300 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   310 */  1392, 1773, 1392, 1841, 1845, 1392, 1392, 1392, 1692, 1392,
 /*   320 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   330 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   340 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   350 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   360 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   370 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   380 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   390 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   400 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1426, 1392,
 /*   410 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   420 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   430 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   440 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   450 */  1392, 1392, 1392, 1392, 1392, 1392, 1489, 1488, 1392, 1392,
 /*   460 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   470 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   480 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   490 */  1796, 1806, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   500 */  1392, 1392, 1392, 1392, 1392, 1692, 1392, 1823, 1392, 1782,
 /*   510 */  1778, 1392, 1392, 1774, 1392, 1392, 1839, 1392, 1392, 1392,
 /*   520 */  1392, 1392, 1392, 1392, 1392, 1392, 1768, 1392, 1741, 1392,
 /*   530 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1703, 1392, 1392,
 /*   540 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   550 */  1691, 1392, 1732, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   560 */  1392, 1552, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   570 */  1392, 1392, 1392, 1392, 1537, 1535, 1534, 1533, 1392, 1530,
 /*   580 */  1392, 1392, 1392, 1392, 1561, 1560, 1392, 1392, 1392, 1392,
 /*   590 */  1392, 1392, 1481, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   600 */  1392, 1392, 1472, 1392, 1471, 1392, 1392, 1392, 1392, 1392,
 /*   610 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   620 */  1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392, 1392,
 /*   630 */  1392, 1392, 1392, 1392, 1392, 1392,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*  PRIVILEGE => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FULLTEXT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*     DELETE => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  235,  /*  NK_BITNOT => ID */
  235,  /*     INSERT => ID */
  235,  /*     VALUES => ID */
  235,  /*     IMPORT => ID */
  235,  /*    NK_SEMI => ID */
  235,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "GRANT",
  /*   37 */ "ON",
  /*   38 */ "TO",
  /*   39 */ "REVOKE",
  /*   40 */ "FROM",
  /*   41 */ "NK_COMMA",
  /*   42 */ "READ",
  /*   43 */ "WRITE",
  /*   44 */ "NK_DOT",
  /*   45 */ "DNODE",
  /*   46 */ "PORT",
  /*   47 */ "NK_INTEGER",
  /*   48 */ "DNODES",
  /*   49 */ "NK_IPTOKEN",
  /*   50 */ "LOCAL",
  /*   51 */ "QNODE",
  /*   52 */ "BNODE",
  /*   53 */ "SNODE",
  /*   54 */ "MNODE",
  /*   55 */ "DATABASE",
  /*   56 */ "USE",
  /*   57 */ "IF",
  /*   58 */ "NOT",
  /*   59 */ "EXISTS",
  /*   60 */ "BUFFER",
  /*   61 */ "CACHELAST",
  /*   62 */ "COMP",
  /*   63 */ "DURATION",
  /*   64 */ "NK_VARIABLE",
  /*   65 */ "FSYNC",
  /*   66 */ "MAXROWS",
  /*   67 */ "MINROWS",
  /*   68 */ "KEEP",
  /*   69 */ "PAGES",
  /*   70 */ "PAGESIZE",
  /*   71 */ "PRECISION",
  /*   72 */ "REPLICA",
  /*   73 */ "STRICT",
  /*   74 */ "WAL",
  /*   75 */ "VGROUPS",
  /*   76 */ "SINGLE_STABLE",
  /*   77 */ "RETENTIONS",
  /*   78 */ "SCHEMALESS",
  /*   79 */ "NK_COLON",
  /*   80 */ "TABLE",
  /*   81 */ "NK_LP",
  /*   82 */ "NK_RP",
  /*   83 */ "STABLE",
  /*   84 */ "ADD",
  /*   85 */ "COLUMN",
  /*   86 */ "MODIFY",
  /*   87 */ "RENAME",
  /*   88 */ "TAG",
  /*   89 */ "SET",
  /*   90 */ "NK_EQ",
  /*   91 */ "USING",
  /*   92 */ "TAGS",
  /*   93 */ "COMMENT",
  /*   94 */ "BOOL",
  /*   95 */ "TINYINT",
  /*   96 */ "SMALLINT",
  /*   97 */ "INT",
  /*   98 */ "INTEGER",
  /*   99 */ "BIGINT",
  /*  100 */ "FLOAT",
  /*  101 */ "DOUBLE",
  /*  102 */ "BINARY",
  /*  103 */ "TIMESTAMP",
  /*  104 */ "NCHAR",
  /*  105 */ "UNSIGNED",
  /*  106 */ "JSON",
  /*  107 */ "VARCHAR",
  /*  108 */ "MEDIUMBLOB",
  /*  109 */ "BLOB",
  /*  110 */ "VARBINARY",
  /*  111 */ "DECIMAL",
  /*  112 */ "MAX_DELAY",
  /*  113 */ "WATERMARK",
  /*  114 */ "ROLLUP",
  /*  115 */ "TTL",
  /*  116 */ "SMA",
  /*  117 */ "FIRST",
  /*  118 */ "LAST",
  /*  119 */ "SHOW",
  /*  120 */ "DATABASES",
  /*  121 */ "TABLES",
  /*  122 */ "STABLES",
  /*  123 */ "MNODES",
  /*  124 */ "MODULES",
  /*  125 */ "QNODES",
  /*  126 */ "FUNCTIONS",
  /*  127 */ "INDEXES",
  /*  128 */ "ACCOUNTS",
  /*  129 */ "APPS",
  /*  130 */ "CONNECTIONS",
  /*  131 */ "LICENCE",
  /*  132 */ "GRANTS",
  /*  133 */ "QUERIES",
  /*  134 */ "SCORES",
  /*  135 */ "TOPICS",
  /*  136 */ "VARIABLES",
  /*  137 */ "BNODES",
  /*  138 */ "SNODES",
  /*  139 */ "CLUSTER",
  /*  140 */ "TRANSACTIONS",
  /*  141 */ "DISTRIBUTED",
  /*  142 */ "LIKE",
  /*  143 */ "INDEX",
  /*  144 */ "FULLTEXT",
  /*  145 */ "FUNCTION",
  /*  146 */ "INTERVAL",
  /*  147 */ "TOPIC",
  /*  148 */ "AS",
  /*  149 */ "CONSUMER",
  /*  150 */ "GROUP",
  /*  151 */ "DESC",
  /*  152 */ "DESCRIBE",
  /*  153 */ "RESET",
  /*  154 */ "QUERY",
  /*  155 */ "CACHE",
  /*  156 */ "EXPLAIN",
  /*  157 */ "ANALYZE",
  /*  158 */ "VERBOSE",
  /*  159 */ "NK_BOOL",
  /*  160 */ "RATIO",
  /*  161 */ "NK_FLOAT",
  /*  162 */ "COMPACT",
  /*  163 */ "VNODES",
  /*  164 */ "IN",
  /*  165 */ "OUTPUTTYPE",
  /*  166 */ "AGGREGATE",
  /*  167 */ "BUFSIZE",
  /*  168 */ "STREAM",
  /*  169 */ "INTO",
  /*  170 */ "TRIGGER",
  /*  171 */ "AT_ONCE",
  /*  172 */ "WINDOW_CLOSE",
  /*  173 */ "KILL",
  /*  174 */ "CONNECTION",
  /*  175 */ "TRANSACTION",
  /*  176 */ "BALANCE",
  /*  177 */ "VGROUP",
  /*  178 */ "MERGE",
  /*  179 */ "REDISTRIBUTE",
  /*  180 */ "SPLIT",
  /*  181 */ "SYNCDB",
  /*  182 */ "DELETE",
  /*  183 */ "NULL",
  /*  184 */ "NK_QUESTION",
  /*  185 */ "NK_ARROW",
  /*  186 */ "ROWTS",
  /*  187 */ "TBNAME",
  /*  188 */ "QSTARTTS",
  /*  189 */ "QENDTS",
  /*  190 */ "WSTARTTS",
  /*  191 */ "WENDTS",
  /*  192 */ "WDURATION",
  /*  193 */ "CAST",
  /*  194 */ "NOW",
  /*  195 */ "TODAY",
  /*  196 */ "TIMEZONE",
  /*  197 */ "COUNT",
  /*  198 */ "LAST_ROW",
  /*  199 */ "BETWEEN",
  /*  200 */ "IS",
  /*  201 */ "NK_LT",
  /*  202 */ "NK_GT",
  /*  203 */ "NK_LE",
  /*  204 */ "NK_GE",
  /*  205 */ "NK_NE",
  /*  206 */ "MATCH",
  /*  207 */ "NMATCH",
  /*  208 */ "CONTAINS",
  /*  209 */ "JOIN",
  /*  210 */ "INNER",
  /*  211 */ "SELECT",
  /*  212 */ "DISTINCT",
  /*  213 */ "WHERE",
  /*  214 */ "PARTITION",
  /*  215 */ "BY",
  /*  216 */ "SESSION",
  /*  217 */ "STATE_WINDOW",
  /*  218 */ "SLIDING",
  /*  219 */ "FILL",
  /*  220 */ "VALUE",
  /*  221 */ "NONE",
  /*  222 */ "PREV",
  /*  223 */ "LINEAR",
  /*  224 */ "NEXT",
  /*  225 */ "HAVING",
  /*  226 */ "RANGE",
  /*  227 */ "EVERY",
  /*  228 */ "ORDER",
  /*  229 */ "SLIMIT",
  /*  230 */ "SOFFSET",
  /*  231 */ "LIMIT",
  /*  232 */ "OFFSET",
  /*  233 */ "ASC",
  /*  234 */ "NULLS",
  /*  235 */ "ID",
  /*  236 */ "NK_BITNOT",
  /*  237 */ "INSERT",
  /*  238 */ "VALUES",
  /*  239 */ "IMPORT",
  /*  240 */ "NK_SEMI",
  /*  241 */ "FILE",
  /*  242 */ "cmd",
  /*  243 */ "account_options",
  /*  244 */ "alter_account_options",
  /*  245 */ "literal",
  /*  246 */ "alter_account_option",
  /*  247 */ "user_name",
  /*  248 */ "privileges",
  /*  249 */ "priv_level",
  /*  250 */ "priv_type_list",
  /*  251 */ "priv_type",
  /*  252 */ "db_name",
  /*  253 */ "dnode_endpoint",
  /*  254 */ "not_exists_opt",
  /*  255 */ "db_options",
  /*  256 */ "exists_opt",
  /*  257 */ "alter_db_options",
  /*  258 */ "integer_list",
  /*  259 */ "variable_list",
  /*  260 */ "retention_list",
  /*  261 */ "alter_db_option",
  /*  262 */ "retention",
  /*  263 */ "full_table_name",
  /*  264 */ "column_def_list",
  /*  265 */ "tags_def_opt",
  /*  266 */ "table_options",
  /*  267 */ "multi_create_clause",
  /*  268 */ "tags_def",
  /*  269 */ "multi_drop_clause",
  /*  270 */ "alter_table_clause",
  /*  271 */ "alter_table_options",
  /*  272 */ "column_name",
  /*  273 */ "type_name",
  /*  274 */ "signed_literal",
  /*  275 */ "create_subtable_clause",
  /*  276 */ "specific_tags_opt",
  /*  277 */ "literal_list",
  /*  278 */ "drop_table_clause",
  /*  279 */ "col_name_list",
  /*  280 */ "table_name",
  /*  281 */ "column_def",
  /*  282 */ "duration_list",
  /*  283 */ "rollup_func_list",
  /*  284 */ "alter_table_option",
  /*  285 */ "duration_literal",
  /*  286 */ "rollup_func_name",
  /*  287 */ "function_name",
  /*  288 */ "col_name",
  /*  289 */ "db_name_cond_opt",
  /*  290 */ "like_pattern_opt",
  /*  291 */ "table_name_cond",
  /*  292 */ "from_db_opt",
  /*  293 */ "index_name",
  /*  294 */ "index_options",
  /*  295 */ "func_list",
  /*  296 */ "sliding_opt",
  /*  297 */ "func",
  /*  298 */ "expression_list",
  /*  299 */ "topic_name",
  /*  300 */ "query_expression",
  /*  301 */ "cgroup_name",
  /*  302 */ "analyze_opt",
  /*  303 */ "explain_options",
  /*  304 */ "agg_func_opt",
  /*  305 */ "bufsize_opt",
  /*  306 */ "stream_name",
  /*  307 */ "stream_options",
  /*  308 */ "into_opt",
  /*  309 */ "dnode_list",
  /*  310 */ "where_clause_opt",
  /*  311 */ "signed",
  /*  312 */ "literal_func",
  /*  313 */ "table_alias",
  /*  314 */ "column_alias",
  /*  315 */ "expression",
  /*  316 */ "pseudo_column",
  /*  317 */ "column_reference",
  /*  318 */ "function_expression",
  /*  319 */ "subquery",
  /*  320 */ "star_func",
  /*  321 */ "star_func_para_list",
  /*  322 */ "noarg_func",
  /*  323 */ "other_para_list",
  /*  324 */ "star_func_para",
  /*  325 */ "predicate",
  /*  326 */ "compare_op",
  /*  327 */ "in_op",
  /*  328 */ "in_predicate_value",
  /*  329 */ "boolean_value_expression",
  /*  330 */ "boolean_primary",
  /*  331 */ "common_expression",
  /*  332 */ "from_clause",
  /*  333 */ "table_reference_list",
  /*  334 */ "table_reference",
  /*  335 */ "table_primary",
  /*  336 */ "joined_table",
  /*  337 */ "alias_opt",
  /*  338 */ "parenthesized_joined_table",
  /*  339 */ "join_type",
  /*  340 */ "search_condition",
  /*  341 */ "query_specification",
  /*  342 */ "set_quantifier_opt",
  /*  343 */ "select_list",
  /*  344 */ "partition_by_clause_opt",
  /*  345 */ "range_opt",
  /*  346 */ "every_opt",
  /*  347 */ "fill_opt",
  /*  348 */ "twindow_clause_opt",
  /*  349 */ "group_by_clause_opt",
  /*  350 */ "having_clause_opt",
  /*  351 */ "select_sublist",
  /*  352 */ "select_item",
  /*  353 */ "fill_mode",
  /*  354 */ "group_by_list",
  /*  355 */ "query_expression_body",
  /*  356 */ "order_by_clause_opt",
  /*  357 */ "slimit_clause_opt",
  /*  358 */ "limit_clause_opt",
  /*  359 */ "query_primary",
  /*  360 */ "sort_specification_list",
  /*  361 */ "sort_specification",
  /*  362 */ "ordering_specification_opt",
  /*  363 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  29 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  30 */ "privileges ::= ALL",
 /*  31 */ "privileges ::= priv_type_list",
 /*  32 */ "priv_type_list ::= priv_type",
 /*  33 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  34 */ "priv_type ::= READ",
 /*  35 */ "priv_type ::= WRITE",
 /*  36 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  37 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  38 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  39 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  40 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  41 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  42 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  43 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  44 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  45 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  46 */ "dnode_endpoint ::= NK_STRING",
 /*  47 */ "dnode_endpoint ::= NK_ID",
 /*  48 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  49 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  50 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  51 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  52 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  53 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  54 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  60 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  61 */ "cmd ::= USE db_name",
 /*  62 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  63 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  64 */ "not_exists_opt ::=",
 /*  65 */ "exists_opt ::= IF EXISTS",
 /*  66 */ "exists_opt ::=",
 /*  67 */ "db_options ::=",
 /*  68 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  69 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  70 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  71 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  72 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  73 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  74 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  75 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  76 */ "db_options ::= db_options KEEP integer_list",
 /*  77 */ "db_options ::= db_options KEEP variable_list",
 /*  78 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  79 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  81 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  82 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  83 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  84 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  85 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  86 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  87 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  88 */ "alter_db_options ::= alter_db_option",
 /*  89 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  90 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  91 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  92 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  93 */ "alter_db_option ::= KEEP integer_list",
 /*  94 */ "alter_db_option ::= KEEP variable_list",
 /*  95 */ "alter_db_option ::= PAGES NK_INTEGER",
 /*  96 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  97 */ "alter_db_option ::= STRICT NK_INTEGER",
 /*  98 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  99 */ "integer_list ::= NK_INTEGER",
 /* 100 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 101 */ "variable_list ::= NK_VARIABLE",
 /* 102 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 103 */ "retention_list ::= retention",
 /* 104 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 105 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 106 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 107 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 108 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 109 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 110 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 111 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 112 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 113 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 114 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 115 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 116 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 117 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 118 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 119 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 120 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 121 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 122 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 123 */ "multi_create_clause ::= create_subtable_clause",
 /* 124 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 125 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options",
 /* 126 */ "multi_drop_clause ::= drop_table_clause",
 /* 127 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 128 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 129 */ "specific_tags_opt ::=",
 /* 130 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 131 */ "full_table_name ::= table_name",
 /* 132 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 133 */ "column_def_list ::= column_def",
 /* 134 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 135 */ "column_def ::= column_name type_name",
 /* 136 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 137 */ "type_name ::= BOOL",
 /* 138 */ "type_name ::= TINYINT",
 /* 139 */ "type_name ::= SMALLINT",
 /* 140 */ "type_name ::= INT",
 /* 141 */ "type_name ::= INTEGER",
 /* 142 */ "type_name ::= BIGINT",
 /* 143 */ "type_name ::= FLOAT",
 /* 144 */ "type_name ::= DOUBLE",
 /* 145 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 146 */ "type_name ::= TIMESTAMP",
 /* 147 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= TINYINT UNSIGNED",
 /* 149 */ "type_name ::= SMALLINT UNSIGNED",
 /* 150 */ "type_name ::= INT UNSIGNED",
 /* 151 */ "type_name ::= BIGINT UNSIGNED",
 /* 152 */ "type_name ::= JSON",
 /* 153 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 154 */ "type_name ::= MEDIUMBLOB",
 /* 155 */ "type_name ::= BLOB",
 /* 156 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= DECIMAL",
 /* 158 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 159 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 160 */ "tags_def_opt ::=",
 /* 161 */ "tags_def_opt ::= tags_def",
 /* 162 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 163 */ "table_options ::=",
 /* 164 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 165 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 166 */ "table_options ::= table_options WATERMARK duration_list",
 /* 167 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 168 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 169 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 170 */ "alter_table_options ::= alter_table_option",
 /* 171 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 172 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 173 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 174 */ "duration_list ::= duration_literal",
 /* 175 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 176 */ "rollup_func_list ::= rollup_func_name",
 /* 177 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 178 */ "rollup_func_name ::= function_name",
 /* 179 */ "rollup_func_name ::= FIRST",
 /* 180 */ "rollup_func_name ::= LAST",
 /* 181 */ "col_name_list ::= col_name",
 /* 182 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 183 */ "col_name ::= column_name",
 /* 184 */ "cmd ::= SHOW DNODES",
 /* 185 */ "cmd ::= SHOW USERS",
 /* 186 */ "cmd ::= SHOW DATABASES",
 /* 187 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 188 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 189 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 190 */ "cmd ::= SHOW MNODES",
 /* 191 */ "cmd ::= SHOW MODULES",
 /* 192 */ "cmd ::= SHOW QNODES",
 /* 193 */ "cmd ::= SHOW FUNCTIONS",
 /* 194 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 195 */ "cmd ::= SHOW STREAMS",
 /* 196 */ "cmd ::= SHOW ACCOUNTS",
 /* 197 */ "cmd ::= SHOW APPS",
 /* 198 */ "cmd ::= SHOW CONNECTIONS",
 /* 199 */ "cmd ::= SHOW LICENCE",
 /* 200 */ "cmd ::= SHOW GRANTS",
 /* 201 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 202 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 203 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 204 */ "cmd ::= SHOW QUERIES",
 /* 205 */ "cmd ::= SHOW SCORES",
 /* 206 */ "cmd ::= SHOW TOPICS",
 /* 207 */ "cmd ::= SHOW VARIABLES",
 /* 208 */ "cmd ::= SHOW BNODES",
 /* 209 */ "cmd ::= SHOW SNODES",
 /* 210 */ "cmd ::= SHOW CLUSTER",
 /* 211 */ "cmd ::= SHOW TRANSACTIONS",
 /* 212 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 213 */ "db_name_cond_opt ::=",
 /* 214 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 215 */ "like_pattern_opt ::=",
 /* 216 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 217 */ "table_name_cond ::= table_name",
 /* 218 */ "from_db_opt ::=",
 /* 219 */ "from_db_opt ::= FROM db_name",
 /* 220 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 221 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 222 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 223 */ "index_options ::=",
 /* 224 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 225 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 226 */ "func_list ::= func",
 /* 227 */ "func_list ::= func_list NK_COMMA func",
 /* 228 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 229 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 230 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 231 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 232 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 233 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 234 */ "cmd ::= DESC full_table_name",
 /* 235 */ "cmd ::= DESCRIBE full_table_name",
 /* 236 */ "cmd ::= RESET QUERY CACHE",
 /* 237 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 238 */ "analyze_opt ::=",
 /* 239 */ "analyze_opt ::= ANALYZE",
 /* 240 */ "explain_options ::=",
 /* 241 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 242 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 243 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 244 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 245 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 246 */ "agg_func_opt ::=",
 /* 247 */ "agg_func_opt ::= AGGREGATE",
 /* 248 */ "bufsize_opt ::=",
 /* 249 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 250 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 251 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 252 */ "into_opt ::=",
 /* 253 */ "into_opt ::= INTO full_table_name",
 /* 254 */ "stream_options ::=",
 /* 255 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 256 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 257 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 258 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 259 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 260 */ "cmd ::= KILL QUERY NK_STRING",
 /* 261 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 262 */ "cmd ::= BALANCE VGROUP",
 /* 263 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 264 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 265 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 266 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 267 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 268 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 269 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 270 */ "cmd ::= query_expression",
 /* 271 */ "literal ::= NK_INTEGER",
 /* 272 */ "literal ::= NK_FLOAT",
 /* 273 */ "literal ::= NK_STRING",
 /* 274 */ "literal ::= NK_BOOL",
 /* 275 */ "literal ::= TIMESTAMP NK_STRING",
 /* 276 */ "literal ::= duration_literal",
 /* 277 */ "literal ::= NULL",
 /* 278 */ "literal ::= NK_QUESTION",
 /* 279 */ "duration_literal ::= NK_VARIABLE",
 /* 280 */ "signed ::= NK_INTEGER",
 /* 281 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 282 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 283 */ "signed ::= NK_FLOAT",
 /* 284 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 285 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 286 */ "signed_literal ::= signed",
 /* 287 */ "signed_literal ::= NK_STRING",
 /* 288 */ "signed_literal ::= NK_BOOL",
 /* 289 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 290 */ "signed_literal ::= duration_literal",
 /* 291 */ "signed_literal ::= NULL",
 /* 292 */ "signed_literal ::= literal_func",
 /* 293 */ "literal_list ::= signed_literal",
 /* 294 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 295 */ "db_name ::= NK_ID",
 /* 296 */ "table_name ::= NK_ID",
 /* 297 */ "column_name ::= NK_ID",
 /* 298 */ "function_name ::= NK_ID",
 /* 299 */ "table_alias ::= NK_ID",
 /* 300 */ "column_alias ::= NK_ID",
 /* 301 */ "user_name ::= NK_ID",
 /* 302 */ "index_name ::= NK_ID",
 /* 303 */ "topic_name ::= NK_ID",
 /* 304 */ "stream_name ::= NK_ID",
 /* 305 */ "cgroup_name ::= NK_ID",
 /* 306 */ "expression ::= literal",
 /* 307 */ "expression ::= pseudo_column",
 /* 308 */ "expression ::= column_reference",
 /* 309 */ "expression ::= function_expression",
 /* 310 */ "expression ::= subquery",
 /* 311 */ "expression ::= NK_LP expression NK_RP",
 /* 312 */ "expression ::= NK_PLUS expression",
 /* 313 */ "expression ::= NK_MINUS expression",
 /* 314 */ "expression ::= expression NK_PLUS expression",
 /* 315 */ "expression ::= expression NK_MINUS expression",
 /* 316 */ "expression ::= expression NK_STAR expression",
 /* 317 */ "expression ::= expression NK_SLASH expression",
 /* 318 */ "expression ::= expression NK_REM expression",
 /* 319 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 320 */ "expression_list ::= expression",
 /* 321 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 322 */ "column_reference ::= column_name",
 /* 323 */ "column_reference ::= table_name NK_DOT column_name",
 /* 324 */ "pseudo_column ::= ROWTS",
 /* 325 */ "pseudo_column ::= TBNAME",
 /* 326 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 327 */ "pseudo_column ::= QSTARTTS",
 /* 328 */ "pseudo_column ::= QENDTS",
 /* 329 */ "pseudo_column ::= WSTARTTS",
 /* 330 */ "pseudo_column ::= WENDTS",
 /* 331 */ "pseudo_column ::= WDURATION",
 /* 332 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 333 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 334 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 335 */ "function_expression ::= literal_func",
 /* 336 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 337 */ "literal_func ::= NOW",
 /* 338 */ "noarg_func ::= NOW",
 /* 339 */ "noarg_func ::= TODAY",
 /* 340 */ "noarg_func ::= TIMEZONE",
 /* 341 */ "star_func ::= COUNT",
 /* 342 */ "star_func ::= FIRST",
 /* 343 */ "star_func ::= LAST",
 /* 344 */ "star_func ::= LAST_ROW",
 /* 345 */ "star_func_para_list ::= NK_STAR",
 /* 346 */ "star_func_para_list ::= other_para_list",
 /* 347 */ "other_para_list ::= star_func_para",
 /* 348 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 349 */ "star_func_para ::= expression",
 /* 350 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 351 */ "predicate ::= expression compare_op expression",
 /* 352 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 353 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 354 */ "predicate ::= expression IS NULL",
 /* 355 */ "predicate ::= expression IS NOT NULL",
 /* 356 */ "predicate ::= expression in_op in_predicate_value",
 /* 357 */ "compare_op ::= NK_LT",
 /* 358 */ "compare_op ::= NK_GT",
 /* 359 */ "compare_op ::= NK_LE",
 /* 360 */ "compare_op ::= NK_GE",
 /* 361 */ "compare_op ::= NK_NE",
 /* 362 */ "compare_op ::= NK_EQ",
 /* 363 */ "compare_op ::= LIKE",
 /* 364 */ "compare_op ::= NOT LIKE",
 /* 365 */ "compare_op ::= MATCH",
 /* 366 */ "compare_op ::= NMATCH",
 /* 367 */ "compare_op ::= CONTAINS",
 /* 368 */ "in_op ::= IN",
 /* 369 */ "in_op ::= NOT IN",
 /* 370 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 371 */ "boolean_value_expression ::= boolean_primary",
 /* 372 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 373 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 374 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 375 */ "boolean_primary ::= predicate",
 /* 376 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 377 */ "common_expression ::= expression",
 /* 378 */ "common_expression ::= boolean_value_expression",
 /* 379 */ "from_clause ::= FROM table_reference_list",
 /* 380 */ "table_reference_list ::= table_reference",
 /* 381 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 382 */ "table_reference ::= table_primary",
 /* 383 */ "table_reference ::= joined_table",
 /* 384 */ "table_primary ::= table_name alias_opt",
 /* 385 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 386 */ "table_primary ::= subquery alias_opt",
 /* 387 */ "table_primary ::= parenthesized_joined_table",
 /* 388 */ "alias_opt ::=",
 /* 389 */ "alias_opt ::= table_alias",
 /* 390 */ "alias_opt ::= AS table_alias",
 /* 391 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 392 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 393 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 394 */ "join_type ::=",
 /* 395 */ "join_type ::= INNER",
 /* 396 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 397 */ "set_quantifier_opt ::=",
 /* 398 */ "set_quantifier_opt ::= DISTINCT",
 /* 399 */ "set_quantifier_opt ::= ALL",
 /* 400 */ "select_list ::= NK_STAR",
 /* 401 */ "select_list ::= select_sublist",
 /* 402 */ "select_sublist ::= select_item",
 /* 403 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 404 */ "select_item ::= common_expression",
 /* 405 */ "select_item ::= common_expression column_alias",
 /* 406 */ "select_item ::= common_expression AS column_alias",
 /* 407 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 408 */ "where_clause_opt ::=",
 /* 409 */ "where_clause_opt ::= WHERE search_condition",
 /* 410 */ "partition_by_clause_opt ::=",
 /* 411 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 412 */ "twindow_clause_opt ::=",
 /* 413 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 414 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 415 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 416 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 417 */ "sliding_opt ::=",
 /* 418 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 419 */ "fill_opt ::=",
 /* 420 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 421 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 422 */ "fill_mode ::= NONE",
 /* 423 */ "fill_mode ::= PREV",
 /* 424 */ "fill_mode ::= NULL",
 /* 425 */ "fill_mode ::= LINEAR",
 /* 426 */ "fill_mode ::= NEXT",
 /* 427 */ "group_by_clause_opt ::=",
 /* 428 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 429 */ "group_by_list ::= expression",
 /* 430 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 431 */ "having_clause_opt ::=",
 /* 432 */ "having_clause_opt ::= HAVING search_condition",
 /* 433 */ "range_opt ::=",
 /* 434 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 435 */ "every_opt ::=",
 /* 436 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 437 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 438 */ "query_expression_body ::= query_primary",
 /* 439 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 440 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 441 */ "query_primary ::= query_specification",
 /* 442 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 443 */ "order_by_clause_opt ::=",
 /* 444 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 445 */ "slimit_clause_opt ::=",
 /* 446 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 447 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 448 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 449 */ "limit_clause_opt ::=",
 /* 450 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 451 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 452 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 453 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 454 */ "search_condition ::= common_expression",
 /* 455 */ "sort_specification_list ::= sort_specification",
 /* 456 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 457 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 458 */ "ordering_specification_opt ::=",
 /* 459 */ "ordering_specification_opt ::= ASC",
 /* 460 */ "ordering_specification_opt ::= DESC",
 /* 461 */ "null_ordering_opt ::=",
 /* 462 */ "null_ordering_opt ::= NULLS FIRST",
 /* 463 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 242: /* cmd */
    case 245: /* literal */
    case 255: /* db_options */
    case 257: /* alter_db_options */
    case 262: /* retention */
    case 263: /* full_table_name */
    case 266: /* table_options */
    case 270: /* alter_table_clause */
    case 271: /* alter_table_options */
    case 274: /* signed_literal */
    case 275: /* create_subtable_clause */
    case 278: /* drop_table_clause */
    case 281: /* column_def */
    case 285: /* duration_literal */
    case 286: /* rollup_func_name */
    case 288: /* col_name */
    case 289: /* db_name_cond_opt */
    case 290: /* like_pattern_opt */
    case 291: /* table_name_cond */
    case 292: /* from_db_opt */
    case 294: /* index_options */
    case 296: /* sliding_opt */
    case 297: /* func */
    case 300: /* query_expression */
    case 303: /* explain_options */
    case 307: /* stream_options */
    case 308: /* into_opt */
    case 310: /* where_clause_opt */
    case 311: /* signed */
    case 312: /* literal_func */
    case 315: /* expression */
    case 316: /* pseudo_column */
    case 317: /* column_reference */
    case 318: /* function_expression */
    case 319: /* subquery */
    case 324: /* star_func_para */
    case 325: /* predicate */
    case 328: /* in_predicate_value */
    case 329: /* boolean_value_expression */
    case 330: /* boolean_primary */
    case 331: /* common_expression */
    case 332: /* from_clause */
    case 333: /* table_reference_list */
    case 334: /* table_reference */
    case 335: /* table_primary */
    case 336: /* joined_table */
    case 338: /* parenthesized_joined_table */
    case 340: /* search_condition */
    case 341: /* query_specification */
    case 345: /* range_opt */
    case 346: /* every_opt */
    case 347: /* fill_opt */
    case 348: /* twindow_clause_opt */
    case 350: /* having_clause_opt */
    case 352: /* select_item */
    case 355: /* query_expression_body */
    case 357: /* slimit_clause_opt */
    case 358: /* limit_clause_opt */
    case 359: /* query_primary */
    case 361: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy392)); 
}
      break;
    case 243: /* account_options */
    case 244: /* alter_account_options */
    case 246: /* alter_account_option */
    case 305: /* bufsize_opt */
{
 
}
      break;
    case 247: /* user_name */
    case 249: /* priv_level */
    case 252: /* db_name */
    case 253: /* dnode_endpoint */
    case 272: /* column_name */
    case 280: /* table_name */
    case 287: /* function_name */
    case 293: /* index_name */
    case 299: /* topic_name */
    case 301: /* cgroup_name */
    case 306: /* stream_name */
    case 313: /* table_alias */
    case 314: /* column_alias */
    case 320: /* star_func */
    case 322: /* noarg_func */
    case 337: /* alias_opt */
{
 
}
      break;
    case 248: /* privileges */
    case 250: /* priv_type_list */
    case 251: /* priv_type */
{
 
}
      break;
    case 254: /* not_exists_opt */
    case 256: /* exists_opt */
    case 302: /* analyze_opt */
    case 304: /* agg_func_opt */
    case 342: /* set_quantifier_opt */
{
 
}
      break;
    case 258: /* integer_list */
    case 259: /* variable_list */
    case 260: /* retention_list */
    case 264: /* column_def_list */
    case 265: /* tags_def_opt */
    case 267: /* multi_create_clause */
    case 268: /* tags_def */
    case 269: /* multi_drop_clause */
    case 276: /* specific_tags_opt */
    case 277: /* literal_list */
    case 279: /* col_name_list */
    case 282: /* duration_list */
    case 283: /* rollup_func_list */
    case 295: /* func_list */
    case 298: /* expression_list */
    case 309: /* dnode_list */
    case 321: /* star_func_para_list */
    case 323: /* other_para_list */
    case 343: /* select_list */
    case 344: /* partition_by_clause_opt */
    case 349: /* group_by_clause_opt */
    case 351: /* select_sublist */
    case 354: /* group_by_list */
    case 356: /* order_by_clause_opt */
    case 360: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy600)); 
}
      break;
    case 261: /* alter_db_option */
    case 284: /* alter_table_option */
{
 
}
      break;
    case 273: /* type_name */
{
 
}
      break;
    case 326: /* compare_op */
    case 327: /* in_op */
{
 
}
      break;
    case 339: /* join_type */
{
 
}
      break;
    case 353: /* fill_mode */
{
 
}
      break;
    case 362: /* ordering_specification_opt */
{
 
}
      break;
    case 363: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  242,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  242,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  243,    0 }, /* (2) account_options ::= */
  {  243,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  243,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  243,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  243,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  243,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  243,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  243,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  243,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  243,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  244,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  244,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  246,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  246,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  246,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  246,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  246,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  246,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  246,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  246,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  246,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  246,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  242,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  242,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  242,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  242,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  242,   -6 }, /* (28) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  242,   -6 }, /* (29) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  248,   -1 }, /* (30) privileges ::= ALL */
  {  248,   -1 }, /* (31) privileges ::= priv_type_list */
  {  250,   -1 }, /* (32) priv_type_list ::= priv_type */
  {  250,   -3 }, /* (33) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  251,   -1 }, /* (34) priv_type ::= READ */
  {  251,   -1 }, /* (35) priv_type ::= WRITE */
  {  249,   -3 }, /* (36) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  249,   -3 }, /* (37) priv_level ::= db_name NK_DOT NK_STAR */
  {  242,   -3 }, /* (38) cmd ::= CREATE DNODE dnode_endpoint */
  {  242,   -5 }, /* (39) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  242,   -3 }, /* (40) cmd ::= DROP DNODE NK_INTEGER */
  {  242,   -3 }, /* (41) cmd ::= DROP DNODE dnode_endpoint */
  {  242,   -4 }, /* (42) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  242,   -5 }, /* (43) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  242,   -4 }, /* (44) cmd ::= ALTER ALL DNODES NK_STRING */
  {  242,   -5 }, /* (45) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  253,   -1 }, /* (46) dnode_endpoint ::= NK_STRING */
  {  253,   -1 }, /* (47) dnode_endpoint ::= NK_ID */
  {  253,   -1 }, /* (48) dnode_endpoint ::= NK_IPTOKEN */
  {  242,   -3 }, /* (49) cmd ::= ALTER LOCAL NK_STRING */
  {  242,   -4 }, /* (50) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  242,   -5 }, /* (51) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  242,   -5 }, /* (52) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  242,   -5 }, /* (53) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  242,   -5 }, /* (54) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  242,   -5 }, /* (55) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  242,   -5 }, /* (56) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  242,   -5 }, /* (57) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  242,   -5 }, /* (58) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  242,   -5 }, /* (59) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  242,   -4 }, /* (60) cmd ::= DROP DATABASE exists_opt db_name */
  {  242,   -2 }, /* (61) cmd ::= USE db_name */
  {  242,   -4 }, /* (62) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  254,   -3 }, /* (63) not_exists_opt ::= IF NOT EXISTS */
  {  254,    0 }, /* (64) not_exists_opt ::= */
  {  256,   -2 }, /* (65) exists_opt ::= IF EXISTS */
  {  256,    0 }, /* (66) exists_opt ::= */
  {  255,    0 }, /* (67) db_options ::= */
  {  255,   -3 }, /* (68) db_options ::= db_options BUFFER NK_INTEGER */
  {  255,   -3 }, /* (69) db_options ::= db_options CACHELAST NK_INTEGER */
  {  255,   -3 }, /* (70) db_options ::= db_options COMP NK_INTEGER */
  {  255,   -3 }, /* (71) db_options ::= db_options DURATION NK_INTEGER */
  {  255,   -3 }, /* (72) db_options ::= db_options DURATION NK_VARIABLE */
  {  255,   -3 }, /* (73) db_options ::= db_options FSYNC NK_INTEGER */
  {  255,   -3 }, /* (74) db_options ::= db_options MAXROWS NK_INTEGER */
  {  255,   -3 }, /* (75) db_options ::= db_options MINROWS NK_INTEGER */
  {  255,   -3 }, /* (76) db_options ::= db_options KEEP integer_list */
  {  255,   -3 }, /* (77) db_options ::= db_options KEEP variable_list */
  {  255,   -3 }, /* (78) db_options ::= db_options PAGES NK_INTEGER */
  {  255,   -3 }, /* (79) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  255,   -3 }, /* (80) db_options ::= db_options PRECISION NK_STRING */
  {  255,   -3 }, /* (81) db_options ::= db_options REPLICA NK_INTEGER */
  {  255,   -3 }, /* (82) db_options ::= db_options STRICT NK_INTEGER */
  {  255,   -3 }, /* (83) db_options ::= db_options WAL NK_INTEGER */
  {  255,   -3 }, /* (84) db_options ::= db_options VGROUPS NK_INTEGER */
  {  255,   -3 }, /* (85) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  255,   -3 }, /* (86) db_options ::= db_options RETENTIONS retention_list */
  {  255,   -3 }, /* (87) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  257,   -1 }, /* (88) alter_db_options ::= alter_db_option */
  {  257,   -2 }, /* (89) alter_db_options ::= alter_db_options alter_db_option */
  {  261,   -2 }, /* (90) alter_db_option ::= BUFFER NK_INTEGER */
  {  261,   -2 }, /* (91) alter_db_option ::= CACHELAST NK_INTEGER */
  {  261,   -2 }, /* (92) alter_db_option ::= FSYNC NK_INTEGER */
  {  261,   -2 }, /* (93) alter_db_option ::= KEEP integer_list */
  {  261,   -2 }, /* (94) alter_db_option ::= KEEP variable_list */
  {  261,   -2 }, /* (95) alter_db_option ::= PAGES NK_INTEGER */
  {  261,   -2 }, /* (96) alter_db_option ::= REPLICA NK_INTEGER */
  {  261,   -2 }, /* (97) alter_db_option ::= STRICT NK_INTEGER */
  {  261,   -2 }, /* (98) alter_db_option ::= WAL NK_INTEGER */
  {  258,   -1 }, /* (99) integer_list ::= NK_INTEGER */
  {  258,   -3 }, /* (100) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  259,   -1 }, /* (101) variable_list ::= NK_VARIABLE */
  {  259,   -3 }, /* (102) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  260,   -1 }, /* (103) retention_list ::= retention */
  {  260,   -3 }, /* (104) retention_list ::= retention_list NK_COMMA retention */
  {  262,   -3 }, /* (105) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  242,   -9 }, /* (106) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  242,   -3 }, /* (107) cmd ::= CREATE TABLE multi_create_clause */
  {  242,   -9 }, /* (108) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  242,   -3 }, /* (109) cmd ::= DROP TABLE multi_drop_clause */
  {  242,   -4 }, /* (110) cmd ::= DROP STABLE exists_opt full_table_name */
  {  242,   -3 }, /* (111) cmd ::= ALTER TABLE alter_table_clause */
  {  242,   -3 }, /* (112) cmd ::= ALTER STABLE alter_table_clause */
  {  270,   -2 }, /* (113) alter_table_clause ::= full_table_name alter_table_options */
  {  270,   -5 }, /* (114) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  270,   -4 }, /* (115) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  270,   -5 }, /* (116) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  270,   -5 }, /* (117) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  270,   -5 }, /* (118) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  270,   -4 }, /* (119) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  270,   -5 }, /* (120) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  270,   -5 }, /* (121) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  270,   -6 }, /* (122) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  267,   -1 }, /* (123) multi_create_clause ::= create_subtable_clause */
  {  267,   -2 }, /* (124) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  275,  -10 }, /* (125) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
  {  269,   -1 }, /* (126) multi_drop_clause ::= drop_table_clause */
  {  269,   -2 }, /* (127) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  278,   -2 }, /* (128) drop_table_clause ::= exists_opt full_table_name */
  {  276,    0 }, /* (129) specific_tags_opt ::= */
  {  276,   -3 }, /* (130) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  263,   -1 }, /* (131) full_table_name ::= table_name */
  {  263,   -3 }, /* (132) full_table_name ::= db_name NK_DOT table_name */
  {  264,   -1 }, /* (133) column_def_list ::= column_def */
  {  264,   -3 }, /* (134) column_def_list ::= column_def_list NK_COMMA column_def */
  {  281,   -2 }, /* (135) column_def ::= column_name type_name */
  {  281,   -4 }, /* (136) column_def ::= column_name type_name COMMENT NK_STRING */
  {  273,   -1 }, /* (137) type_name ::= BOOL */
  {  273,   -1 }, /* (138) type_name ::= TINYINT */
  {  273,   -1 }, /* (139) type_name ::= SMALLINT */
  {  273,   -1 }, /* (140) type_name ::= INT */
  {  273,   -1 }, /* (141) type_name ::= INTEGER */
  {  273,   -1 }, /* (142) type_name ::= BIGINT */
  {  273,   -1 }, /* (143) type_name ::= FLOAT */
  {  273,   -1 }, /* (144) type_name ::= DOUBLE */
  {  273,   -4 }, /* (145) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  273,   -1 }, /* (146) type_name ::= TIMESTAMP */
  {  273,   -4 }, /* (147) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  273,   -2 }, /* (148) type_name ::= TINYINT UNSIGNED */
  {  273,   -2 }, /* (149) type_name ::= SMALLINT UNSIGNED */
  {  273,   -2 }, /* (150) type_name ::= INT UNSIGNED */
  {  273,   -2 }, /* (151) type_name ::= BIGINT UNSIGNED */
  {  273,   -1 }, /* (152) type_name ::= JSON */
  {  273,   -4 }, /* (153) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  273,   -1 }, /* (154) type_name ::= MEDIUMBLOB */
  {  273,   -1 }, /* (155) type_name ::= BLOB */
  {  273,   -4 }, /* (156) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  273,   -1 }, /* (157) type_name ::= DECIMAL */
  {  273,   -4 }, /* (158) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  273,   -6 }, /* (159) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  265,    0 }, /* (160) tags_def_opt ::= */
  {  265,   -1 }, /* (161) tags_def_opt ::= tags_def */
  {  268,   -4 }, /* (162) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  266,    0 }, /* (163) table_options ::= */
  {  266,   -3 }, /* (164) table_options ::= table_options COMMENT NK_STRING */
  {  266,   -3 }, /* (165) table_options ::= table_options MAX_DELAY duration_list */
  {  266,   -3 }, /* (166) table_options ::= table_options WATERMARK duration_list */
  {  266,   -5 }, /* (167) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  266,   -3 }, /* (168) table_options ::= table_options TTL NK_INTEGER */
  {  266,   -5 }, /* (169) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  271,   -1 }, /* (170) alter_table_options ::= alter_table_option */
  {  271,   -2 }, /* (171) alter_table_options ::= alter_table_options alter_table_option */
  {  284,   -2 }, /* (172) alter_table_option ::= COMMENT NK_STRING */
  {  284,   -2 }, /* (173) alter_table_option ::= TTL NK_INTEGER */
  {  282,   -1 }, /* (174) duration_list ::= duration_literal */
  {  282,   -3 }, /* (175) duration_list ::= duration_list NK_COMMA duration_literal */
  {  283,   -1 }, /* (176) rollup_func_list ::= rollup_func_name */
  {  283,   -3 }, /* (177) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  286,   -1 }, /* (178) rollup_func_name ::= function_name */
  {  286,   -1 }, /* (179) rollup_func_name ::= FIRST */
  {  286,   -1 }, /* (180) rollup_func_name ::= LAST */
  {  279,   -1 }, /* (181) col_name_list ::= col_name */
  {  279,   -3 }, /* (182) col_name_list ::= col_name_list NK_COMMA col_name */
  {  288,   -1 }, /* (183) col_name ::= column_name */
  {  242,   -2 }, /* (184) cmd ::= SHOW DNODES */
  {  242,   -2 }, /* (185) cmd ::= SHOW USERS */
  {  242,   -2 }, /* (186) cmd ::= SHOW DATABASES */
  {  242,   -4 }, /* (187) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  242,   -4 }, /* (188) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  242,   -3 }, /* (189) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  242,   -2 }, /* (190) cmd ::= SHOW MNODES */
  {  242,   -2 }, /* (191) cmd ::= SHOW MODULES */
  {  242,   -2 }, /* (192) cmd ::= SHOW QNODES */
  {  242,   -2 }, /* (193) cmd ::= SHOW FUNCTIONS */
  {  242,   -5 }, /* (194) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  242,   -2 }, /* (195) cmd ::= SHOW STREAMS */
  {  242,   -2 }, /* (196) cmd ::= SHOW ACCOUNTS */
  {  242,   -2 }, /* (197) cmd ::= SHOW APPS */
  {  242,   -2 }, /* (198) cmd ::= SHOW CONNECTIONS */
  {  242,   -2 }, /* (199) cmd ::= SHOW LICENCE */
  {  242,   -2 }, /* (200) cmd ::= SHOW GRANTS */
  {  242,   -4 }, /* (201) cmd ::= SHOW CREATE DATABASE db_name */
  {  242,   -4 }, /* (202) cmd ::= SHOW CREATE TABLE full_table_name */
  {  242,   -4 }, /* (203) cmd ::= SHOW CREATE STABLE full_table_name */
  {  242,   -2 }, /* (204) cmd ::= SHOW QUERIES */
  {  242,   -2 }, /* (205) cmd ::= SHOW SCORES */
  {  242,   -2 }, /* (206) cmd ::= SHOW TOPICS */
  {  242,   -2 }, /* (207) cmd ::= SHOW VARIABLES */
  {  242,   -2 }, /* (208) cmd ::= SHOW BNODES */
  {  242,   -2 }, /* (209) cmd ::= SHOW SNODES */
  {  242,   -2 }, /* (210) cmd ::= SHOW CLUSTER */
  {  242,   -2 }, /* (211) cmd ::= SHOW TRANSACTIONS */
  {  242,   -4 }, /* (212) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  289,    0 }, /* (213) db_name_cond_opt ::= */
  {  289,   -2 }, /* (214) db_name_cond_opt ::= db_name NK_DOT */
  {  290,    0 }, /* (215) like_pattern_opt ::= */
  {  290,   -2 }, /* (216) like_pattern_opt ::= LIKE NK_STRING */
  {  291,   -1 }, /* (217) table_name_cond ::= table_name */
  {  292,    0 }, /* (218) from_db_opt ::= */
  {  292,   -2 }, /* (219) from_db_opt ::= FROM db_name */
  {  242,   -8 }, /* (220) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  242,  -10 }, /* (221) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  242,   -6 }, /* (222) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  294,    0 }, /* (223) index_options ::= */
  {  294,   -9 }, /* (224) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  294,  -11 }, /* (225) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  295,   -1 }, /* (226) func_list ::= func */
  {  295,   -3 }, /* (227) func_list ::= func_list NK_COMMA func */
  {  297,   -4 }, /* (228) func ::= function_name NK_LP expression_list NK_RP */
  {  242,   -6 }, /* (229) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  242,   -7 }, /* (230) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  242,   -7 }, /* (231) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  242,   -4 }, /* (232) cmd ::= DROP TOPIC exists_opt topic_name */
  {  242,   -7 }, /* (233) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  242,   -2 }, /* (234) cmd ::= DESC full_table_name */
  {  242,   -2 }, /* (235) cmd ::= DESCRIBE full_table_name */
  {  242,   -3 }, /* (236) cmd ::= RESET QUERY CACHE */
  {  242,   -4 }, /* (237) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  302,    0 }, /* (238) analyze_opt ::= */
  {  302,   -1 }, /* (239) analyze_opt ::= ANALYZE */
  {  303,    0 }, /* (240) explain_options ::= */
  {  303,   -3 }, /* (241) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  303,   -3 }, /* (242) explain_options ::= explain_options RATIO NK_FLOAT */
  {  242,   -6 }, /* (243) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  242,  -10 }, /* (244) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  242,   -4 }, /* (245) cmd ::= DROP FUNCTION exists_opt function_name */
  {  304,    0 }, /* (246) agg_func_opt ::= */
  {  304,   -1 }, /* (247) agg_func_opt ::= AGGREGATE */
  {  305,    0 }, /* (248) bufsize_opt ::= */
  {  305,   -2 }, /* (249) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  242,   -8 }, /* (250) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  242,   -4 }, /* (251) cmd ::= DROP STREAM exists_opt stream_name */
  {  308,    0 }, /* (252) into_opt ::= */
  {  308,   -2 }, /* (253) into_opt ::= INTO full_table_name */
  {  307,    0 }, /* (254) stream_options ::= */
  {  307,   -3 }, /* (255) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  307,   -3 }, /* (256) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  307,   -4 }, /* (257) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  307,   -3 }, /* (258) stream_options ::= stream_options WATERMARK duration_literal */
  {  242,   -3 }, /* (259) cmd ::= KILL CONNECTION NK_INTEGER */
  {  242,   -3 }, /* (260) cmd ::= KILL QUERY NK_STRING */
  {  242,   -3 }, /* (261) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  242,   -2 }, /* (262) cmd ::= BALANCE VGROUP */
  {  242,   -4 }, /* (263) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  242,   -4 }, /* (264) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  242,   -3 }, /* (265) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  309,   -2 }, /* (266) dnode_list ::= DNODE NK_INTEGER */
  {  309,   -3 }, /* (267) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  242,   -3 }, /* (268) cmd ::= SYNCDB db_name REPLICA */
  {  242,   -4 }, /* (269) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  242,   -1 }, /* (270) cmd ::= query_expression */
  {  245,   -1 }, /* (271) literal ::= NK_INTEGER */
  {  245,   -1 }, /* (272) literal ::= NK_FLOAT */
  {  245,   -1 }, /* (273) literal ::= NK_STRING */
  {  245,   -1 }, /* (274) literal ::= NK_BOOL */
  {  245,   -2 }, /* (275) literal ::= TIMESTAMP NK_STRING */
  {  245,   -1 }, /* (276) literal ::= duration_literal */
  {  245,   -1 }, /* (277) literal ::= NULL */
  {  245,   -1 }, /* (278) literal ::= NK_QUESTION */
  {  285,   -1 }, /* (279) duration_literal ::= NK_VARIABLE */
  {  311,   -1 }, /* (280) signed ::= NK_INTEGER */
  {  311,   -2 }, /* (281) signed ::= NK_PLUS NK_INTEGER */
  {  311,   -2 }, /* (282) signed ::= NK_MINUS NK_INTEGER */
  {  311,   -1 }, /* (283) signed ::= NK_FLOAT */
  {  311,   -2 }, /* (284) signed ::= NK_PLUS NK_FLOAT */
  {  311,   -2 }, /* (285) signed ::= NK_MINUS NK_FLOAT */
  {  274,   -1 }, /* (286) signed_literal ::= signed */
  {  274,   -1 }, /* (287) signed_literal ::= NK_STRING */
  {  274,   -1 }, /* (288) signed_literal ::= NK_BOOL */
  {  274,   -2 }, /* (289) signed_literal ::= TIMESTAMP NK_STRING */
  {  274,   -1 }, /* (290) signed_literal ::= duration_literal */
  {  274,   -1 }, /* (291) signed_literal ::= NULL */
  {  274,   -1 }, /* (292) signed_literal ::= literal_func */
  {  277,   -1 }, /* (293) literal_list ::= signed_literal */
  {  277,   -3 }, /* (294) literal_list ::= literal_list NK_COMMA signed_literal */
  {  252,   -1 }, /* (295) db_name ::= NK_ID */
  {  280,   -1 }, /* (296) table_name ::= NK_ID */
  {  272,   -1 }, /* (297) column_name ::= NK_ID */
  {  287,   -1 }, /* (298) function_name ::= NK_ID */
  {  313,   -1 }, /* (299) table_alias ::= NK_ID */
  {  314,   -1 }, /* (300) column_alias ::= NK_ID */
  {  247,   -1 }, /* (301) user_name ::= NK_ID */
  {  293,   -1 }, /* (302) index_name ::= NK_ID */
  {  299,   -1 }, /* (303) topic_name ::= NK_ID */
  {  306,   -1 }, /* (304) stream_name ::= NK_ID */
  {  301,   -1 }, /* (305) cgroup_name ::= NK_ID */
  {  315,   -1 }, /* (306) expression ::= literal */
  {  315,   -1 }, /* (307) expression ::= pseudo_column */
  {  315,   -1 }, /* (308) expression ::= column_reference */
  {  315,   -1 }, /* (309) expression ::= function_expression */
  {  315,   -1 }, /* (310) expression ::= subquery */
  {  315,   -3 }, /* (311) expression ::= NK_LP expression NK_RP */
  {  315,   -2 }, /* (312) expression ::= NK_PLUS expression */
  {  315,   -2 }, /* (313) expression ::= NK_MINUS expression */
  {  315,   -3 }, /* (314) expression ::= expression NK_PLUS expression */
  {  315,   -3 }, /* (315) expression ::= expression NK_MINUS expression */
  {  315,   -3 }, /* (316) expression ::= expression NK_STAR expression */
  {  315,   -3 }, /* (317) expression ::= expression NK_SLASH expression */
  {  315,   -3 }, /* (318) expression ::= expression NK_REM expression */
  {  315,   -3 }, /* (319) expression ::= column_reference NK_ARROW NK_STRING */
  {  298,   -1 }, /* (320) expression_list ::= expression */
  {  298,   -3 }, /* (321) expression_list ::= expression_list NK_COMMA expression */
  {  317,   -1 }, /* (322) column_reference ::= column_name */
  {  317,   -3 }, /* (323) column_reference ::= table_name NK_DOT column_name */
  {  316,   -1 }, /* (324) pseudo_column ::= ROWTS */
  {  316,   -1 }, /* (325) pseudo_column ::= TBNAME */
  {  316,   -3 }, /* (326) pseudo_column ::= table_name NK_DOT TBNAME */
  {  316,   -1 }, /* (327) pseudo_column ::= QSTARTTS */
  {  316,   -1 }, /* (328) pseudo_column ::= QENDTS */
  {  316,   -1 }, /* (329) pseudo_column ::= WSTARTTS */
  {  316,   -1 }, /* (330) pseudo_column ::= WENDTS */
  {  316,   -1 }, /* (331) pseudo_column ::= WDURATION */
  {  318,   -4 }, /* (332) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  318,   -4 }, /* (333) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  318,   -6 }, /* (334) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  318,   -1 }, /* (335) function_expression ::= literal_func */
  {  312,   -3 }, /* (336) literal_func ::= noarg_func NK_LP NK_RP */
  {  312,   -1 }, /* (337) literal_func ::= NOW */
  {  322,   -1 }, /* (338) noarg_func ::= NOW */
  {  322,   -1 }, /* (339) noarg_func ::= TODAY */
  {  322,   -1 }, /* (340) noarg_func ::= TIMEZONE */
  {  320,   -1 }, /* (341) star_func ::= COUNT */
  {  320,   -1 }, /* (342) star_func ::= FIRST */
  {  320,   -1 }, /* (343) star_func ::= LAST */
  {  320,   -1 }, /* (344) star_func ::= LAST_ROW */
  {  321,   -1 }, /* (345) star_func_para_list ::= NK_STAR */
  {  321,   -1 }, /* (346) star_func_para_list ::= other_para_list */
  {  323,   -1 }, /* (347) other_para_list ::= star_func_para */
  {  323,   -3 }, /* (348) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  324,   -1 }, /* (349) star_func_para ::= expression */
  {  324,   -3 }, /* (350) star_func_para ::= table_name NK_DOT NK_STAR */
  {  325,   -3 }, /* (351) predicate ::= expression compare_op expression */
  {  325,   -5 }, /* (352) predicate ::= expression BETWEEN expression AND expression */
  {  325,   -6 }, /* (353) predicate ::= expression NOT BETWEEN expression AND expression */
  {  325,   -3 }, /* (354) predicate ::= expression IS NULL */
  {  325,   -4 }, /* (355) predicate ::= expression IS NOT NULL */
  {  325,   -3 }, /* (356) predicate ::= expression in_op in_predicate_value */
  {  326,   -1 }, /* (357) compare_op ::= NK_LT */
  {  326,   -1 }, /* (358) compare_op ::= NK_GT */
  {  326,   -1 }, /* (359) compare_op ::= NK_LE */
  {  326,   -1 }, /* (360) compare_op ::= NK_GE */
  {  326,   -1 }, /* (361) compare_op ::= NK_NE */
  {  326,   -1 }, /* (362) compare_op ::= NK_EQ */
  {  326,   -1 }, /* (363) compare_op ::= LIKE */
  {  326,   -2 }, /* (364) compare_op ::= NOT LIKE */
  {  326,   -1 }, /* (365) compare_op ::= MATCH */
  {  326,   -1 }, /* (366) compare_op ::= NMATCH */
  {  326,   -1 }, /* (367) compare_op ::= CONTAINS */
  {  327,   -1 }, /* (368) in_op ::= IN */
  {  327,   -2 }, /* (369) in_op ::= NOT IN */
  {  328,   -3 }, /* (370) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  329,   -1 }, /* (371) boolean_value_expression ::= boolean_primary */
  {  329,   -2 }, /* (372) boolean_value_expression ::= NOT boolean_primary */
  {  329,   -3 }, /* (373) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  329,   -3 }, /* (374) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  330,   -1 }, /* (375) boolean_primary ::= predicate */
  {  330,   -3 }, /* (376) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  331,   -1 }, /* (377) common_expression ::= expression */
  {  331,   -1 }, /* (378) common_expression ::= boolean_value_expression */
  {  332,   -2 }, /* (379) from_clause ::= FROM table_reference_list */
  {  333,   -1 }, /* (380) table_reference_list ::= table_reference */
  {  333,   -3 }, /* (381) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  334,   -1 }, /* (382) table_reference ::= table_primary */
  {  334,   -1 }, /* (383) table_reference ::= joined_table */
  {  335,   -2 }, /* (384) table_primary ::= table_name alias_opt */
  {  335,   -4 }, /* (385) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  335,   -2 }, /* (386) table_primary ::= subquery alias_opt */
  {  335,   -1 }, /* (387) table_primary ::= parenthesized_joined_table */
  {  337,    0 }, /* (388) alias_opt ::= */
  {  337,   -1 }, /* (389) alias_opt ::= table_alias */
  {  337,   -2 }, /* (390) alias_opt ::= AS table_alias */
  {  338,   -3 }, /* (391) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  338,   -3 }, /* (392) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  336,   -6 }, /* (393) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  339,    0 }, /* (394) join_type ::= */
  {  339,   -1 }, /* (395) join_type ::= INNER */
  {  341,  -12 }, /* (396) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  342,    0 }, /* (397) set_quantifier_opt ::= */
  {  342,   -1 }, /* (398) set_quantifier_opt ::= DISTINCT */
  {  342,   -1 }, /* (399) set_quantifier_opt ::= ALL */
  {  343,   -1 }, /* (400) select_list ::= NK_STAR */
  {  343,   -1 }, /* (401) select_list ::= select_sublist */
  {  351,   -1 }, /* (402) select_sublist ::= select_item */
  {  351,   -3 }, /* (403) select_sublist ::= select_sublist NK_COMMA select_item */
  {  352,   -1 }, /* (404) select_item ::= common_expression */
  {  352,   -2 }, /* (405) select_item ::= common_expression column_alias */
  {  352,   -3 }, /* (406) select_item ::= common_expression AS column_alias */
  {  352,   -3 }, /* (407) select_item ::= table_name NK_DOT NK_STAR */
  {  310,    0 }, /* (408) where_clause_opt ::= */
  {  310,   -2 }, /* (409) where_clause_opt ::= WHERE search_condition */
  {  344,    0 }, /* (410) partition_by_clause_opt ::= */
  {  344,   -3 }, /* (411) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  348,    0 }, /* (412) twindow_clause_opt ::= */
  {  348,   -6 }, /* (413) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  348,   -4 }, /* (414) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  348,   -6 }, /* (415) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  348,   -8 }, /* (416) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  296,    0 }, /* (417) sliding_opt ::= */
  {  296,   -4 }, /* (418) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  347,    0 }, /* (419) fill_opt ::= */
  {  347,   -4 }, /* (420) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  347,   -6 }, /* (421) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  353,   -1 }, /* (422) fill_mode ::= NONE */
  {  353,   -1 }, /* (423) fill_mode ::= PREV */
  {  353,   -1 }, /* (424) fill_mode ::= NULL */
  {  353,   -1 }, /* (425) fill_mode ::= LINEAR */
  {  353,   -1 }, /* (426) fill_mode ::= NEXT */
  {  349,    0 }, /* (427) group_by_clause_opt ::= */
  {  349,   -3 }, /* (428) group_by_clause_opt ::= GROUP BY group_by_list */
  {  354,   -1 }, /* (429) group_by_list ::= expression */
  {  354,   -3 }, /* (430) group_by_list ::= group_by_list NK_COMMA expression */
  {  350,    0 }, /* (431) having_clause_opt ::= */
  {  350,   -2 }, /* (432) having_clause_opt ::= HAVING search_condition */
  {  345,    0 }, /* (433) range_opt ::= */
  {  345,   -6 }, /* (434) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  346,    0 }, /* (435) every_opt ::= */
  {  346,   -4 }, /* (436) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  300,   -4 }, /* (437) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  355,   -1 }, /* (438) query_expression_body ::= query_primary */
  {  355,   -4 }, /* (439) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  355,   -3 }, /* (440) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  359,   -1 }, /* (441) query_primary ::= query_specification */
  {  359,   -6 }, /* (442) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  356,    0 }, /* (443) order_by_clause_opt ::= */
  {  356,   -3 }, /* (444) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  357,    0 }, /* (445) slimit_clause_opt ::= */
  {  357,   -2 }, /* (446) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  357,   -4 }, /* (447) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  357,   -4 }, /* (448) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  358,    0 }, /* (449) limit_clause_opt ::= */
  {  358,   -2 }, /* (450) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  358,   -4 }, /* (451) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  358,   -4 }, /* (452) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  319,   -3 }, /* (453) subquery ::= NK_LP query_expression NK_RP */
  {  340,   -1 }, /* (454) search_condition ::= common_expression */
  {  360,   -1 }, /* (455) sort_specification_list ::= sort_specification */
  {  360,   -3 }, /* (456) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  361,   -3 }, /* (457) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  362,    0 }, /* (458) ordering_specification_opt ::= */
  {  362,   -1 }, /* (459) ordering_specification_opt ::= ASC */
  {  362,   -1 }, /* (460) ordering_specification_opt ::= DESC */
  {  363,    0 }, /* (461) null_ordering_opt ::= */
  {  363,   -2 }, /* (462) null_ordering_opt ::= NULLS FIRST */
  {  363,   -2 }, /* (463) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,243,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,244,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,243,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,245,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,246,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,244,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,246,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,245,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy57, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy57, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy57); }
        break;
      case 28: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy389, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy57); }
        break;
      case 29: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy389, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy57); }
        break;
      case 30: /* privileges ::= ALL */
{ yymsp[0].minor.yy389 = PRIVILEGE_TYPE_ALL; }
        break;
      case 31: /* privileges ::= priv_type_list */
      case 32: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==32);
{ yylhsminor.yy389 = yymsp[0].minor.yy389; }
  yymsp[0].minor.yy389 = yylhsminor.yy389;
        break;
      case 33: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy389 = yymsp[-2].minor.yy389 | yymsp[0].minor.yy389; }
  yymsp[-2].minor.yy389 = yylhsminor.yy389;
        break;
      case 34: /* priv_type ::= READ */
{ yymsp[0].minor.yy389 = PRIVILEGE_TYPE_READ; }
        break;
      case 35: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy389 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 36: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy57 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy57 = yylhsminor.yy57;
        break;
      case 37: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy57 = yymsp[-2].minor.yy57; }
  yymsp[-2].minor.yy57 = yylhsminor.yy57;
        break;
      case 38: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy57, NULL); }
        break;
      case 39: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy0); }
        break;
      case 40: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy57); }
        break;
      case 42: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 43: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 45: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 46: /* dnode_endpoint ::= NK_STRING */
      case 47: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==47);
      case 48: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==48);
      case 295: /* db_name ::= NK_ID */ yytestcase(yyruleno==295);
      case 296: /* table_name ::= NK_ID */ yytestcase(yyruleno==296);
      case 297: /* column_name ::= NK_ID */ yytestcase(yyruleno==297);
      case 298: /* function_name ::= NK_ID */ yytestcase(yyruleno==298);
      case 299: /* table_alias ::= NK_ID */ yytestcase(yyruleno==299);
      case 300: /* column_alias ::= NK_ID */ yytestcase(yyruleno==300);
      case 301: /* user_name ::= NK_ID */ yytestcase(yyruleno==301);
      case 302: /* index_name ::= NK_ID */ yytestcase(yyruleno==302);
      case 303: /* topic_name ::= NK_ID */ yytestcase(yyruleno==303);
      case 304: /* stream_name ::= NK_ID */ yytestcase(yyruleno==304);
      case 305: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==305);
      case 338: /* noarg_func ::= NOW */ yytestcase(yyruleno==338);
      case 339: /* noarg_func ::= TODAY */ yytestcase(yyruleno==339);
      case 340: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==340);
      case 341: /* star_func ::= COUNT */ yytestcase(yyruleno==341);
      case 342: /* star_func ::= FIRST */ yytestcase(yyruleno==342);
      case 343: /* star_func ::= LAST */ yytestcase(yyruleno==343);
      case 344: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==344);
{ yylhsminor.yy57 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy57 = yylhsminor.yy57;
        break;
      case 49: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 52: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 53: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy481, &yymsp[-1].minor.yy57, yymsp[0].minor.yy392); }
        break;
      case 60: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy481, &yymsp[0].minor.yy57); }
        break;
      case 61: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy57); }
        break;
      case 62: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy57, yymsp[0].minor.yy392); }
        break;
      case 63: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy481 = true; }
        break;
      case 64: /* not_exists_opt ::= */
      case 66: /* exists_opt ::= */ yytestcase(yyruleno==66);
      case 238: /* analyze_opt ::= */ yytestcase(yyruleno==238);
      case 246: /* agg_func_opt ::= */ yytestcase(yyruleno==246);
      case 397: /* set_quantifier_opt ::= */ yytestcase(yyruleno==397);
{ yymsp[1].minor.yy481 = false; }
        break;
      case 65: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy481 = true; }
        break;
      case 67: /* db_options ::= */
{ yymsp[1].minor.yy392 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 68: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 69: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 70: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 71: /* db_options ::= db_options DURATION NK_INTEGER */
      case 72: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==72);
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 73: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 74: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 75: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 76: /* db_options ::= db_options KEEP integer_list */
      case 77: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==77);
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_KEEP, yymsp[0].minor.yy600); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 78: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 79: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 80: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 81: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 82: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 83: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 84: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 85: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 86: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_RETENTIONS, yymsp[0].minor.yy600); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 87: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy392 = setDatabaseOption(pCxt, yymsp[-2].minor.yy392, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 88: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy392 = createAlterDatabaseOptions(pCxt); yylhsminor.yy392 = setAlterDatabaseOption(pCxt, yylhsminor.yy392, &yymsp[0].minor.yy221); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 89: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy392 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy392, &yymsp[0].minor.yy221); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 90: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy221.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy221.val = yymsp[0].minor.yy0; }
        break;
      case 91: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy221.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy221.val = yymsp[0].minor.yy0; }
        break;
      case 92: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy221.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy221.val = yymsp[0].minor.yy0; }
        break;
      case 93: /* alter_db_option ::= KEEP integer_list */
      case 94: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==94);
{ yymsp[-1].minor.yy221.type = DB_OPTION_KEEP; yymsp[-1].minor.yy221.pList = yymsp[0].minor.yy600; }
        break;
      case 95: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy221.type = DB_OPTION_PAGES; yymsp[-1].minor.yy221.val = yymsp[0].minor.yy0; }
        break;
      case 96: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy221.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy221.val = yymsp[0].minor.yy0; }
        break;
      case 97: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy221.type = DB_OPTION_STRICT; yymsp[-1].minor.yy221.val = yymsp[0].minor.yy0; }
        break;
      case 98: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy221.type = DB_OPTION_WAL; yymsp[-1].minor.yy221.val = yymsp[0].minor.yy0; }
        break;
      case 99: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy600 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 100: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 267: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==267);
{ yylhsminor.yy600 = addNodeToList(pCxt, yymsp[-2].minor.yy600, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 101: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy600 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 102: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy600 = addNodeToList(pCxt, yymsp[-2].minor.yy600, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 103: /* retention_list ::= retention */
      case 123: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==123);
      case 126: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==126);
      case 133: /* column_def_list ::= column_def */ yytestcase(yyruleno==133);
      case 176: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==176);
      case 181: /* col_name_list ::= col_name */ yytestcase(yyruleno==181);
      case 226: /* func_list ::= func */ yytestcase(yyruleno==226);
      case 293: /* literal_list ::= signed_literal */ yytestcase(yyruleno==293);
      case 347: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==347);
      case 402: /* select_sublist ::= select_item */ yytestcase(yyruleno==402);
      case 455: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==455);
{ yylhsminor.yy600 = createNodeList(pCxt, yymsp[0].minor.yy392); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 104: /* retention_list ::= retention_list NK_COMMA retention */
      case 134: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==134);
      case 177: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==177);
      case 182: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==182);
      case 227: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==227);
      case 294: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==294);
      case 348: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==348);
      case 403: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==403);
      case 456: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==456);
{ yylhsminor.yy600 = addNodeToList(pCxt, yymsp[-2].minor.yy600, yymsp[0].minor.yy392); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 105: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy392 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 106: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 108: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==108);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy481, yymsp[-5].minor.yy392, yymsp[-3].minor.yy600, yymsp[-1].minor.yy600, yymsp[0].minor.yy392); }
        break;
      case 107: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy600); }
        break;
      case 109: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy600); }
        break;
      case 110: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy481, yymsp[0].minor.yy392); }
        break;
      case 111: /* cmd ::= ALTER TABLE alter_table_clause */
      case 112: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==112);
      case 270: /* cmd ::= query_expression */ yytestcase(yyruleno==270);
{ pCxt->pRootNode = yymsp[0].minor.yy392; }
        break;
      case 113: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy392 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 114: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy392 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy57, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 115: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy392 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy392, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy57); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 116: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy392 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy57, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 117: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy392 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy57, &yymsp[0].minor.yy57); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 118: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy392 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy57, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 119: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy392 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy392, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy57); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 120: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy392 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy57, yymsp[0].minor.yy448); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 121: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy392 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy392, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy57, &yymsp[0].minor.yy57); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 122: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy392 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy392, &yymsp[-2].minor.yy57, yymsp[0].minor.yy392); }
  yymsp[-5].minor.yy392 = yylhsminor.yy392;
        break;
      case 124: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 127: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==127);
{ yylhsminor.yy600 = addNodeToList(pCxt, yymsp[-1].minor.yy600, yymsp[0].minor.yy392); }
  yymsp[-1].minor.yy600 = yylhsminor.yy600;
        break;
      case 125: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
{ yylhsminor.yy392 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy481, yymsp[-8].minor.yy392, yymsp[-6].minor.yy392, yymsp[-5].minor.yy600, yymsp[-2].minor.yy600, yymsp[0].minor.yy392); }
  yymsp[-9].minor.yy392 = yylhsminor.yy392;
        break;
      case 128: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy392 = createDropTableClause(pCxt, yymsp[-1].minor.yy481, yymsp[0].minor.yy392); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 129: /* specific_tags_opt ::= */
      case 160: /* tags_def_opt ::= */ yytestcase(yyruleno==160);
      case 410: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==410);
      case 427: /* group_by_clause_opt ::= */ yytestcase(yyruleno==427);
      case 443: /* order_by_clause_opt ::= */ yytestcase(yyruleno==443);
{ yymsp[1].minor.yy600 = NULL; }
        break;
      case 130: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy600 = yymsp[-1].minor.yy600; }
        break;
      case 131: /* full_table_name ::= table_name */
{ yylhsminor.yy392 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy57, NULL); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 132: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy392 = createRealTableNode(pCxt, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy57, NULL); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 135: /* column_def ::= column_name type_name */
{ yylhsminor.yy392 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy57, yymsp[0].minor.yy448, NULL); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 136: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy392 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy57, yymsp[-2].minor.yy448, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 137: /* type_name ::= BOOL */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 138: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 139: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 140: /* type_name ::= INT */
      case 141: /* type_name ::= INTEGER */ yytestcase(yyruleno==141);
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 142: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 143: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 144: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 145: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 146: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 147: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 148: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 149: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 150: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 151: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy448 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 152: /* type_name ::= JSON */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 153: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 154: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 155: /* type_name ::= BLOB */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 156: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy448 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 158: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy448 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 159: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy448 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 161: /* tags_def_opt ::= tags_def */
      case 346: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==346);
      case 401: /* select_list ::= select_sublist */ yytestcase(yyruleno==401);
{ yylhsminor.yy600 = yymsp[0].minor.yy600; }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 162: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy600 = yymsp[-1].minor.yy600; }
        break;
      case 163: /* table_options ::= */
{ yymsp[1].minor.yy392 = createDefaultTableOptions(pCxt); }
        break;
      case 164: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy392 = setTableOption(pCxt, yymsp[-2].minor.yy392, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 165: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy392 = setTableOption(pCxt, yymsp[-2].minor.yy392, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy600); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 166: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy392 = setTableOption(pCxt, yymsp[-2].minor.yy392, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy600); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 167: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy392 = setTableOption(pCxt, yymsp[-4].minor.yy392, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy600); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 168: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy392 = setTableOption(pCxt, yymsp[-2].minor.yy392, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 169: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy392 = setTableOption(pCxt, yymsp[-4].minor.yy392, TABLE_OPTION_SMA, yymsp[-1].minor.yy600); }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 170: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy392 = createAlterTableOptions(pCxt); yylhsminor.yy392 = setTableOption(pCxt, yylhsminor.yy392, yymsp[0].minor.yy221.type, &yymsp[0].minor.yy221.val); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 171: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy392 = setTableOption(pCxt, yymsp[-1].minor.yy392, yymsp[0].minor.yy221.type, &yymsp[0].minor.yy221.val); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 172: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy221.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy221.val = yymsp[0].minor.yy0; }
        break;
      case 173: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy221.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy221.val = yymsp[0].minor.yy0; }
        break;
      case 174: /* duration_list ::= duration_literal */
      case 320: /* expression_list ::= expression */ yytestcase(yyruleno==320);
{ yylhsminor.yy600 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy392)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 175: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 321: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==321);
{ yylhsminor.yy600 = addNodeToList(pCxt, yymsp[-2].minor.yy600, releaseRawExprNode(pCxt, yymsp[0].minor.yy392)); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 178: /* rollup_func_name ::= function_name */
{ yylhsminor.yy392 = createFunctionNode(pCxt, &yymsp[0].minor.yy57, NULL); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 179: /* rollup_func_name ::= FIRST */
      case 180: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==180);
{ yylhsminor.yy392 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 183: /* col_name ::= column_name */
{ yylhsminor.yy392 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy57); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 184: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 185: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 186: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 187: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy392, yymsp[0].minor.yy392, OP_TYPE_LIKE); }
        break;
      case 188: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy392, yymsp[0].minor.yy392, OP_TYPE_LIKE); }
        break;
      case 189: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy392, NULL, OP_TYPE_LIKE); }
        break;
      case 190: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 191: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 192: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 193: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 194: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy392, yymsp[-1].minor.yy392, OP_TYPE_EQUAL); }
        break;
      case 195: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 196: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 197: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 198: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 199: /* cmd ::= SHOW LICENCE */
      case 200: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==200);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT); }
        break;
      case 201: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy57); }
        break;
      case 202: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy392); }
        break;
      case 203: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy392); }
        break;
      case 204: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 205: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 206: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 207: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT); }
        break;
      case 208: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 209: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 210: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 211: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 212: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy392); }
        break;
      case 213: /* db_name_cond_opt ::= */
      case 218: /* from_db_opt ::= */ yytestcase(yyruleno==218);
{ yymsp[1].minor.yy392 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 214: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy57); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 215: /* like_pattern_opt ::= */
      case 223: /* index_options ::= */ yytestcase(yyruleno==223);
      case 252: /* into_opt ::= */ yytestcase(yyruleno==252);
      case 408: /* where_clause_opt ::= */ yytestcase(yyruleno==408);
      case 412: /* twindow_clause_opt ::= */ yytestcase(yyruleno==412);
      case 417: /* sliding_opt ::= */ yytestcase(yyruleno==417);
      case 419: /* fill_opt ::= */ yytestcase(yyruleno==419);
      case 431: /* having_clause_opt ::= */ yytestcase(yyruleno==431);
      case 433: /* range_opt ::= */ yytestcase(yyruleno==433);
      case 435: /* every_opt ::= */ yytestcase(yyruleno==435);
      case 445: /* slimit_clause_opt ::= */ yytestcase(yyruleno==445);
      case 449: /* limit_clause_opt ::= */ yytestcase(yyruleno==449);
{ yymsp[1].minor.yy392 = NULL; }
        break;
      case 216: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 217: /* table_name_cond ::= table_name */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy57); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 219: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy57); }
        break;
      case 220: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy481, &yymsp[-3].minor.yy57, &yymsp[-1].minor.yy57, NULL, yymsp[0].minor.yy392); }
        break;
      case 221: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy481, &yymsp[-5].minor.yy57, &yymsp[-3].minor.yy57, yymsp[-1].minor.yy600, NULL); }
        break;
      case 222: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy481, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy57); }
        break;
      case 224: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy392 = createIndexOption(pCxt, yymsp[-6].minor.yy600, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), NULL, yymsp[0].minor.yy392); }
        break;
      case 225: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy392 = createIndexOption(pCxt, yymsp[-8].minor.yy600, releaseRawExprNode(pCxt, yymsp[-4].minor.yy392), releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), yymsp[0].minor.yy392); }
        break;
      case 228: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy392 = createFunctionNode(pCxt, &yymsp[-3].minor.yy57, yymsp[-1].minor.yy600); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 229: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy481, &yymsp[-2].minor.yy57, yymsp[0].minor.yy392, NULL, NULL); }
        break;
      case 230: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy481, &yymsp[-3].minor.yy57, NULL, &yymsp[0].minor.yy57, NULL); }
        break;
      case 231: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy481, &yymsp[-3].minor.yy57, NULL, NULL, yymsp[0].minor.yy392); }
        break;
      case 232: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy481, &yymsp[0].minor.yy57); }
        break;
      case 233: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy481, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy57); }
        break;
      case 234: /* cmd ::= DESC full_table_name */
      case 235: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==235);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy392); }
        break;
      case 236: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 237: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy481, yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 239: /* analyze_opt ::= ANALYZE */
      case 247: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==247);
      case 398: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==398);
{ yymsp[0].minor.yy481 = true; }
        break;
      case 240: /* explain_options ::= */
{ yymsp[1].minor.yy392 = createDefaultExplainOptions(pCxt); }
        break;
      case 241: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy392 = setExplainVerbose(pCxt, yymsp[-2].minor.yy392, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 242: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy392 = setExplainRatio(pCxt, yymsp[-2].minor.yy392, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 243: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy600); }
        break;
      case 244: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy481, yymsp[-8].minor.yy481, &yymsp[-5].minor.yy57, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy448, yymsp[0].minor.yy228); }
        break;
      case 245: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy481, &yymsp[0].minor.yy57); }
        break;
      case 248: /* bufsize_opt ::= */
{ yymsp[1].minor.yy228 = 0; }
        break;
      case 249: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy228 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 250: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy481, &yymsp[-4].minor.yy57, yymsp[-2].minor.yy392, yymsp[-3].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 251: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy481, &yymsp[0].minor.yy57); }
        break;
      case 253: /* into_opt ::= INTO full_table_name */
      case 379: /* from_clause ::= FROM table_reference_list */ yytestcase(yyruleno==379);
      case 409: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==409);
      case 432: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==432);
{ yymsp[-1].minor.yy392 = yymsp[0].minor.yy392; }
        break;
      case 254: /* stream_options ::= */
{ yymsp[1].minor.yy392 = createStreamOptions(pCxt); }
        break;
      case 255: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy392)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 256: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy392)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 257: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy392)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy392)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy392); yylhsminor.yy392 = yymsp[-3].minor.yy392; }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 258: /* stream_options ::= stream_options WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy392)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy392); yylhsminor.yy392 = yymsp[-2].minor.yy392; }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 259: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 260: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 261: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 262: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 263: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 264: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy600); }
        break;
      case 265: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 266: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy600 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 268: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy57); }
        break;
      case 269: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 271: /* literal ::= NK_INTEGER */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 272: /* literal ::= NK_FLOAT */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 273: /* literal ::= NK_STRING */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 274: /* literal ::= NK_BOOL */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 275: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 276: /* literal ::= duration_literal */
      case 286: /* signed_literal ::= signed */ yytestcase(yyruleno==286);
      case 306: /* expression ::= literal */ yytestcase(yyruleno==306);
      case 307: /* expression ::= pseudo_column */ yytestcase(yyruleno==307);
      case 308: /* expression ::= column_reference */ yytestcase(yyruleno==308);
      case 309: /* expression ::= function_expression */ yytestcase(yyruleno==309);
      case 310: /* expression ::= subquery */ yytestcase(yyruleno==310);
      case 335: /* function_expression ::= literal_func */ yytestcase(yyruleno==335);
      case 371: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==371);
      case 375: /* boolean_primary ::= predicate */ yytestcase(yyruleno==375);
      case 377: /* common_expression ::= expression */ yytestcase(yyruleno==377);
      case 378: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==378);
      case 380: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==380);
      case 382: /* table_reference ::= table_primary */ yytestcase(yyruleno==382);
      case 383: /* table_reference ::= joined_table */ yytestcase(yyruleno==383);
      case 387: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==387);
      case 438: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==438);
      case 441: /* query_primary ::= query_specification */ yytestcase(yyruleno==441);
{ yylhsminor.yy392 = yymsp[0].minor.yy392; }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 277: /* literal ::= NULL */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 278: /* literal ::= NK_QUESTION */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 279: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 280: /* signed ::= NK_INTEGER */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 281: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 282: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 283: /* signed ::= NK_FLOAT */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 284: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 285: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 287: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 288: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 289: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 290: /* signed_literal ::= duration_literal */
      case 292: /* signed_literal ::= literal_func */ yytestcase(yyruleno==292);
      case 349: /* star_func_para ::= expression */ yytestcase(yyruleno==349);
      case 404: /* select_item ::= common_expression */ yytestcase(yyruleno==404);
      case 454: /* search_condition ::= common_expression */ yytestcase(yyruleno==454);
{ yylhsminor.yy392 = releaseRawExprNode(pCxt, yymsp[0].minor.yy392); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 291: /* signed_literal ::= NULL */
{ yylhsminor.yy392 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 311: /* expression ::= NK_LP expression NK_RP */
      case 376: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==376);
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy392)); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 312: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy392));
                                                                                  }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 313: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy392), NULL));
                                                                                  }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 314: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); 
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 315: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); 
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 316: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); 
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 317: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); 
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 318: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 319: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 322: /* column_reference ::= column_name */
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy57, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy57)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 323: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy57, createColumnNode(pCxt, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy57)); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 324: /* pseudo_column ::= ROWTS */
      case 325: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==325);
      case 327: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==327);
      case 328: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==328);
      case 329: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==329);
      case 330: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==330);
      case 331: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==331);
      case 337: /* literal_func ::= NOW */ yytestcase(yyruleno==337);
{ yylhsminor.yy392 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy392 = yylhsminor.yy392;
        break;
      case 326: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy57)))); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 332: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 333: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==333);
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy57, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy57, yymsp[-1].minor.yy600)); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 334: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), yymsp[-1].minor.yy448)); }
  yymsp[-5].minor.yy392 = yylhsminor.yy392;
        break;
      case 336: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy57, NULL)); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 345: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy600 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 350: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 407: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==407);
{ yylhsminor.yy392 = createColumnNode(pCxt, &yymsp[-2].minor.yy57, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 351: /* predicate ::= expression compare_op expression */
      case 356: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==356);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy324, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 352: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy392), releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-4].minor.yy392 = yylhsminor.yy392;
        break;
      case 353: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy392), releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-5].minor.yy392 = yylhsminor.yy392;
        break;
      case 354: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), NULL));
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 355: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), NULL));
                                                                                  }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 357: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy324 = OP_TYPE_LOWER_THAN; }
        break;
      case 358: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy324 = OP_TYPE_GREATER_THAN; }
        break;
      case 359: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy324 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 360: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy324 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 361: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy324 = OP_TYPE_NOT_EQUAL; }
        break;
      case 362: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy324 = OP_TYPE_EQUAL; }
        break;
      case 363: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy324 = OP_TYPE_LIKE; }
        break;
      case 364: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy324 = OP_TYPE_NOT_LIKE; }
        break;
      case 365: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy324 = OP_TYPE_MATCH; }
        break;
      case 366: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy324 = OP_TYPE_NMATCH; }
        break;
      case 367: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy324 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 368: /* in_op ::= IN */
{ yymsp[0].minor.yy324 = OP_TYPE_IN; }
        break;
      case 369: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy324 = OP_TYPE_NOT_IN; }
        break;
      case 370: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy600)); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 372: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy392), NULL));
                                                                                  }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 373: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 374: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy392);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy392);
                                                                                    yylhsminor.yy392 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), releaseRawExprNode(pCxt, yymsp[0].minor.yy392)));
                                                                                  }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 381: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy392 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy392, yymsp[0].minor.yy392, NULL); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 384: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy392 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy57, &yymsp[0].minor.yy57); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 385: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy392 = createRealTableNode(pCxt, &yymsp[-3].minor.yy57, &yymsp[-1].minor.yy57, &yymsp[0].minor.yy57); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 386: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy392 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy392), &yymsp[0].minor.yy57); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 388: /* alias_opt ::= */
{ yymsp[1].minor.yy57 = nil_token;  }
        break;
      case 389: /* alias_opt ::= table_alias */
{ yylhsminor.yy57 = yymsp[0].minor.yy57; }
  yymsp[0].minor.yy57 = yylhsminor.yy57;
        break;
      case 390: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy57 = yymsp[0].minor.yy57; }
        break;
      case 391: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 392: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==392);
{ yymsp[-2].minor.yy392 = yymsp[-1].minor.yy392; }
        break;
      case 393: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy392 = createJoinTableNode(pCxt, yymsp[-4].minor.yy204, yymsp[-5].minor.yy392, yymsp[-2].minor.yy392, yymsp[0].minor.yy392); }
  yymsp[-5].minor.yy392 = yylhsminor.yy392;
        break;
      case 394: /* join_type ::= */
{ yymsp[1].minor.yy204 = JOIN_TYPE_INNER; }
        break;
      case 395: /* join_type ::= INNER */
{ yymsp[0].minor.yy204 = JOIN_TYPE_INNER; }
        break;
      case 396: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy392 = createSelectStmt(pCxt, yymsp[-10].minor.yy481, yymsp[-9].minor.yy600, yymsp[-8].minor.yy392);
                                                                                    yymsp[-11].minor.yy392 = addWhereClause(pCxt, yymsp[-11].minor.yy392, yymsp[-7].minor.yy392);
                                                                                    yymsp[-11].minor.yy392 = addPartitionByClause(pCxt, yymsp[-11].minor.yy392, yymsp[-6].minor.yy600);
                                                                                    yymsp[-11].minor.yy392 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy392, yymsp[-2].minor.yy392);
                                                                                    yymsp[-11].minor.yy392 = addGroupByClause(pCxt, yymsp[-11].minor.yy392, yymsp[-1].minor.yy600);
                                                                                    yymsp[-11].minor.yy392 = addHavingClause(pCxt, yymsp[-11].minor.yy392, yymsp[0].minor.yy392);
                                                                                    yymsp[-11].minor.yy392 = addRangeClause(pCxt, yymsp[-11].minor.yy392, yymsp[-5].minor.yy392);
                                                                                    yymsp[-11].minor.yy392 = addEveryClause(pCxt, yymsp[-11].minor.yy392, yymsp[-4].minor.yy392);
                                                                                    yymsp[-11].minor.yy392 = addFillClause(pCxt, yymsp[-11].minor.yy392, yymsp[-3].minor.yy392);
                                                                                  }
        break;
      case 399: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy481 = false; }
        break;
      case 400: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy600 = NULL; }
        break;
      case 405: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy392 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy392), &yymsp[0].minor.yy57); }
  yymsp[-1].minor.yy392 = yylhsminor.yy392;
        break;
      case 406: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy392 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), &yymsp[0].minor.yy57); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 411: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 428: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==428);
      case 444: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==444);
{ yymsp[-2].minor.yy600 = yymsp[0].minor.yy600; }
        break;
      case 413: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy392 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), releaseRawExprNode(pCxt, yymsp[-1].minor.yy392)); }
        break;
      case 414: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy392 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy392)); }
        break;
      case 415: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy392 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), NULL, yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 416: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy392 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy392), releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), yymsp[-1].minor.yy392, yymsp[0].minor.yy392); }
        break;
      case 418: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 436: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==436);
{ yymsp[-3].minor.yy392 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy392); }
        break;
      case 420: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy392 = createFillNode(pCxt, yymsp[-1].minor.yy270, NULL); }
        break;
      case 421: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy392 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy600)); }
        break;
      case 422: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy270 = FILL_MODE_NONE; }
        break;
      case 423: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy270 = FILL_MODE_PREV; }
        break;
      case 424: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy270 = FILL_MODE_NULL; }
        break;
      case 425: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy270 = FILL_MODE_LINEAR; }
        break;
      case 426: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy270 = FILL_MODE_NEXT; }
        break;
      case 429: /* group_by_list ::= expression */
{ yylhsminor.yy600 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); }
  yymsp[0].minor.yy600 = yylhsminor.yy600;
        break;
      case 430: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy600 = addNodeToList(pCxt, yymsp[-2].minor.yy600, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy392))); }
  yymsp[-2].minor.yy600 = yylhsminor.yy600;
        break;
      case 434: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy392 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy392), releaseRawExprNode(pCxt, yymsp[-1].minor.yy392)); }
        break;
      case 437: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy392 = addOrderByClause(pCxt, yymsp[-3].minor.yy392, yymsp[-2].minor.yy600);
                                                                                    yylhsminor.yy392 = addSlimitClause(pCxt, yylhsminor.yy392, yymsp[-1].minor.yy392);
                                                                                    yylhsminor.yy392 = addLimitClause(pCxt, yylhsminor.yy392, yymsp[0].minor.yy392);
                                                                                  }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 439: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy392 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy392, yymsp[0].minor.yy392); }
  yymsp[-3].minor.yy392 = yylhsminor.yy392;
        break;
      case 440: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy392 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy392, yymsp[0].minor.yy392); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 442: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ yymsp[-5].minor.yy392 = yymsp[-4].minor.yy392; }
  yy_destructor(yypParser,356,&yymsp[-3].minor);
  yy_destructor(yypParser,357,&yymsp[-2].minor);
  yy_destructor(yypParser,358,&yymsp[-1].minor);
        break;
      case 446: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 450: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==450);
{ yymsp[-1].minor.yy392 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 447: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 451: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==451);
{ yymsp[-3].minor.yy392 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 448: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 452: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==452);
{ yymsp[-3].minor.yy392 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 453: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy392 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy392); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 457: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy392 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy392), yymsp[-1].minor.yy162, yymsp[0].minor.yy529); }
  yymsp[-2].minor.yy392 = yylhsminor.yy392;
        break;
      case 458: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy162 = ORDER_ASC; }
        break;
      case 459: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy162 = ORDER_ASC; }
        break;
      case 460: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy162 = ORDER_DESC; }
        break;
      case 461: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy529 = NULL_ORDER_DEFAULT; }
        break;
      case 462: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy529 = NULL_ORDER_FIRST; }
        break;
      case 463: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy529 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
