/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 333
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SAlterOption yy11;
  int32_t yy100;
  EJoinType yy162;
  EOperatorType yy218;
  EOrder yy326;
  SDataType yy430;
  SNode* yy452;
  SNodeList* yy478;
  SToken yy479;
  EFillMode yy540;
  ENullOrder yy595;
  bool yy659;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYNSTATE             568
#define YYNRULE              432
#define YYNTOKEN             219
#define YY_MAX_SHIFT         567
#define YY_MIN_SHIFTREDUCE   842
#define YY_MAX_SHIFTREDUCE   1273
#define YY_ERROR_ACTION      1274
#define YY_ACCEPT_ACTION     1275
#define YY_NO_ACTION         1276
#define YY_MIN_REDUCE        1277
#define YY_MAX_REDUCE        1708
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1929)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1388, 1687, 1386, 1561,  268,   26,  203,  323,  482, 1275,
 /*    10 */   469, 1547,   33,   31, 1686, 1561, 1490,   77, 1685, 1300,
 /*    20 */   277, 1547, 1095,  285,  380, 1543, 1550, 1577,   34,   32,
 /*    30 */    30,   29,   28, 1397,  466, 1543, 1549,  248, 1093, 1577,
 /*    40 */  1547,  481,   53,  417,  465, 1533,  466,  441, 1533, 1116,
 /*    50 */    12,   33,   31, 1216, 1543, 1549,  465, 1101,  481,  277,
 /*    60 */  1533, 1095,  293, 1393, 1533,  445,  125, 1562,  468, 1564,
 /*    70 */  1565,  464,  104,  459,    1,  482,  359, 1093,   72, 1562,
 /*    80 */   468, 1564, 1565,  464,  321,  459, 1375,  418, 1626,   12,
 /*    90 */   482, 1230,  249, 1622,  124,   36, 1101,  564, 1355,   77,
 /*   100 */  1397, 1687,   33,   31, 1687,  123,  387, 1289,  102, 1094,
 /*   110 */   277, 1701, 1095,    1,  136, 1397, 1373,  136, 1685, 1118,
 /*   120 */    22, 1685,  443,  132, 1633, 1634, 1687, 1638, 1093, 1278,
 /*   130 */    34,   32,   30,   29,   28,  359,  564, 1329, 1446,  136,
 /*   140 */    12,  560,  559, 1685,  267, 1577, 1096, 1101, 1094, 1444,
 /*   150 */    87,  127,  466,   86,   85,   84,   83,   82,   81,   80,
 /*   160 */    79,   78, 1438,  469,    1,  518,  280, 1099, 1100, 1489,
 /*   170 */  1144, 1145, 1146, 1147, 1148, 1149, 1150,  461, 1155, 1156,
 /*   180 */  1157, 1158, 1159, 1160,   53, 1096,  434,  564,  431,  395,
 /*   190 */   316,  389,  315, 1299,  481,  394,  137,   99,  101, 1094,
 /*   200 */   390,  388, 1298,  391, 1640, 1392, 1099, 1100,  878, 1144,
 /*   210 */  1145, 1146, 1147, 1148, 1149, 1150,  461, 1155, 1156, 1157,
 /*   220 */  1158, 1159, 1160,  100,  378,  137,  441,  383, 1637,   33,
 /*   230 */    31,   34,   32,   30,   29,   28, 1096,  277, 1533, 1095,
 /*   240 */   930,  137,   34,   32,   30,   29,   28, 1533,   36,  386,
 /*   250 */   137,  104, 1522,  436,  432, 1093,  441, 1099, 1100,  932,
 /*   260 */  1144, 1145, 1146, 1147, 1148, 1149, 1150,  461, 1155, 1156,
 /*   270 */  1157, 1158, 1159, 1160, 1101,   33,   31, 1161,   55,  266,
 /*   280 */   250,  104,  174,  277,  435, 1095, 1326,  102,  300,   87,
 /*   290 */  1297,    7,   86,   85,   84,   83,   82,   81,   80,   79,
 /*   300 */    78, 1093,  133, 1633, 1634, 1131, 1638,  281,    9,    8,
 /*   310 */   395, 1120,  389, 1178,  564,  121,  394,  102, 1119,  101,
 /*   320 */  1101,  390,  388, 1399,  391,  317, 1094, 1240,   30,   29,
 /*   330 */    28,  260,  134, 1633, 1634, 1533, 1638,    7,  540,  539,
 /*   340 */   538,  537,  292, 1117,  536,  535,  534,  107,  529,  528,
 /*   350 */   527,  526,  525,  524,  523,  522,  114,  100,  385,  384,
 /*   360 */   564,  383, 1179, 1096, 1687,  428, 1238, 1239, 1241, 1242,
 /*   370 */   137,  225, 1094,  261, 1427,  259,  258,  136,  382, 1296,
 /*   380 */  1184, 1685, 1192,  386, 1099, 1100,  448, 1144, 1145, 1146,
 /*   390 */  1147, 1148, 1149, 1150,  461, 1155, 1156, 1157, 1158, 1159,
 /*   400 */  1160,  449,   33,   31,   34,   32,   30,   29,   28, 1096,
 /*   410 */   277,   69, 1095,  137,   25,  275, 1173, 1174, 1175, 1176,
 /*   420 */  1177, 1181, 1182, 1183, 1533,  105,  143,  409, 1093,  198,
 /*   430 */  1099, 1100, 1389, 1144, 1145, 1146, 1147, 1148, 1149, 1150,
 /*   440 */   461, 1155, 1156, 1157, 1158, 1159, 1160, 1101,   33,   31,
 /*   450 */   284,  283,   51, 1215,  288,   50,  277, 1446, 1095,   24,
 /*   460 */  1109, 1480, 1482,  282,    7,  400, 1687, 1446, 1444,   34,
 /*   470 */    32,   30,   29,   28, 1093,  482, 1102, 1295, 1481,  136,
 /*   480 */   408, 1640,  287, 1685,  322,  532,  879,  564,  878,  311,
 /*   490 */   121,  393,  392, 1101,  173, 1101,  345,  403, 1399, 1094,
 /*   500 */  1397, 1294,  397,    6, 1293, 1636,  880,  521,  172, 1369,
 /*   510 */     1,  968,  505,  504,  503,  972,  502,  974,  975,  501,
 /*   520 */   977,  498, 1533,  983,  495,  985,  986,  492,  489,  247,
 /*   530 */   120, 1116,  290,  564,   45,  483, 1096,   44,  338,  518,
 /*   540 */   121,  350,  147,  146,  450, 1094, 1533, 1105, 1399, 1533,
 /*   550 */   351,   34,   32,   30,   29,   28, 1292, 1099, 1100, 1640,
 /*   560 */  1144, 1145, 1146, 1147, 1148, 1149, 1150,  461, 1155, 1156,
 /*   570 */  1157, 1158, 1159, 1160,   34,   32,   30,   29,   28, 1180,
 /*   580 */  1291,  508, 1096, 1635, 1110,  515,  514,  533,  531,  250,
 /*   590 */    34,   32,   30,   29,   28,  447, 1121, 1185,    9,    8,
 /*   600 */    62, 1533, 1288, 1099, 1100, 1113, 1144, 1145, 1146, 1147,
 /*   610 */  1148, 1149, 1150,  461, 1155, 1156, 1157, 1158, 1159, 1160,
 /*   620 */  1561, 1390, 1178,  349,  520, 1533,  344,  343,  342,  341,
 /*   630 */   340,   23,  337,  336,  335,  334,  333,  329,  328,  327,
 /*   640 */   326,  325,  324,  482, 1577,  482, 1214, 1533,  482,  567,
 /*   650 */   121,  444,  330, 1131,  331, 1211, 1446,  358, 1400, 1645,
 /*   660 */  1211,  465,  289,  221, 1287, 1533,   98, 1444, 1397,  482,
 /*   670 */  1397, 1179,  556, 1397,  552,  548,  544,  220, 1394, 1081,
 /*   680 */  1082, 1446,  416,   73, 1562,  468, 1564, 1565,  464, 1184,
 /*   690 */   459,  482, 1445, 1626, 1397,  482, 1290,  270, 1622,  131,
 /*   700 */   291, 1270, 1286,   70, 1514, 1285,  215,  452, 1477, 1533,
 /*   710 */  1561,  199,  482,  482,  184,  145, 1397,  424, 1653, 1382,
 /*   720 */  1397,  479,  480,   25,  275, 1173, 1174, 1175, 1176, 1177,
 /*   730 */  1181, 1182, 1183, 1223, 1577, 1316,  478, 1397, 1397, 1118,
 /*   740 */   482,  444,  165,  308,  456,  163, 1284, 1533, 1283,  217,
 /*   750 */  1533,  465, 1282, 1281, 1166, 1533, 1280,  396,  407,  200,
 /*   760 */  1118, 1384,  310,  167,  423, 1397,  166,  180, 1561,  169,
 /*   770 */  1380,  405,  168,   73, 1562,  468, 1564, 1565,  464, 1269,
 /*   780 */   459,  429, 1073, 1626,  176, 1311,   68,  270, 1622,  131,
 /*   790 */  1277, 1533, 1577, 1533, 1272, 1273,   64, 1533, 1533,  466,
 /*   800 */   171, 1533, 1309,  170,  177,  460,  507,  398, 1654,  465,
 /*   810 */  1356, 1439,  410, 1533,   96,   95,   94,   93,   92,   91,
 /*   820 */    90,   89,   88,  112,  401,   47, 1561,  420,  377, 1237,
 /*   830 */  1554,   73, 1562,  468, 1564, 1565,  464,  193,  459,  187,
 /*   840 */  1656, 1626, 1552,  189,   35,  270, 1622, 1699, 1186,  442,
 /*   850 */  1577,   35,  453,  122,  904, 1151, 1660,  466,  231,   35,
 /*   860 */   206, 1170, 1104, 1056,  208, 1578,  160,  465, 1103,  130,
 /*   870 */   229, 1533,  109,  905,  202,  376,  474,  372,  368,  364,
 /*   880 */   159,  110,    2,  148, 1561,  214, 1116,  295,  299,   73,
 /*   890 */  1562,  468, 1564, 1565,  464,  255,  459,  112,  930, 1626,
 /*   900 */   257,  961, 1065,  270, 1622, 1699,   54,   47, 1577,  157,
 /*   910 */   222,  956,  332,  487, 1683,  466,  110,  989,  111,  112,
 /*   920 */   993, 1479, 1000,  999,  110,  465,  144,  339,  113, 1533,
 /*   930 */   347,  346,  348, 1107,  352,  353, 1125,  149,  354, 1106,
 /*   940 */  1561, 1124,  355,  152, 1123,  356,   71,   73, 1562,  468,
 /*   950 */  1564, 1565,  464, 1561,  459,  155,   52, 1626,  360,  357,
 /*   960 */  1122,  270, 1622, 1699, 1577,  379,  156,  381,  151,  158,
 /*   970 */   153,  466, 1644, 1387,   49,   48,  320, 1577,  142,  162,
 /*   980 */  1383,  465,  164,  314,  463, 1533,  265,  150,  115,  116,
 /*   990 */   445, 1561, 1385, 1381,  465,  256,  117,  306, 1533,  302,
 /*  1000 */   298,  139,   97,  238, 1562,  468, 1564, 1565,  464,  441,
 /*  1010 */   459,  118, 1101,  175,  411, 1577,  245, 1562,  468, 1564,
 /*  1020 */  1565,  464,  466,  459, 1518, 1599,  223,  412,  421, 1687,
 /*  1030 */   415,  137,  465, 1121,  104,  419, 1533, 1657,  179,  182,
 /*  1040 */   422,  430,  136,  472, 1667,  185, 1685,  188,  438, 1561,
 /*  1050 */   427,  269,    5,  445,   74, 1562,  468, 1564, 1565,  464,
 /*  1060 */   433,  459,  426, 1647, 1626, 1666,    4, 1211, 1625, 1622,
 /*  1070 */   102,  103,  192, 1577,  129,  194, 1120, 1641,   37, 1561,
 /*  1080 */   466,   16,  271,  451,  195,  196, 1633,  440,  454,  439,
 /*  1090 */   465, 1488, 1687, 1684, 1533, 1702,  201, 1607,  470,  471,
 /*  1100 */   224,  475, 1487, 1577,  210,  136,  279,  212,  476, 1685,
 /*  1110 */   463,   61,   74, 1562,  468, 1564, 1565,  464,  477,  459,
 /*  1120 */   465,   63, 1626,  485, 1533, 1370,  455, 1622, 1561, 1398,
 /*  1130 */   226,  219,  563,   43,  128,  232,  233, 1561,  228, 1095,
 /*  1140 */   230, 1527,  245, 1562,  468, 1564, 1565,  464,  462,  459,
 /*  1150 */   457, 1598, 1577, 1526,  294, 1093, 1523,  296,  297,  466,
 /*  1160 */  1089, 1577, 1090,  140,  301, 1521,  303,  304,  466,  465,
 /*  1170 */   307,  305, 1520, 1533, 1101, 1561, 1519,  309,  465, 1504,
 /*  1180 */   141,  312, 1533,  313, 1068, 1067, 1498, 1561, 1497,  318,
 /*  1190 */   319,  125, 1562,  468, 1564, 1565,  464, 1496,  459, 1577,
 /*  1200 */    74, 1562,  468, 1564, 1565,  464,  466,  459, 1495, 1472,
 /*  1210 */  1626, 1577, 1039, 1471,  564, 1623,  465, 1470,  466, 1469,
 /*  1220 */  1533,  108, 1456,  425, 1468, 1467, 1094, 1466,  465, 1465,
 /*  1230 */  1464, 1463, 1533, 1462, 1461,  446, 1700, 1460,  246, 1562,
 /*  1240 */   468, 1564, 1565,  464, 1459,  459, 1561, 1458, 1457, 1455,
 /*  1250 */   241, 1562,  468, 1564, 1565,  464, 1454,  459, 1453, 1561,
 /*  1260 */  1452, 1451, 1041, 1096, 1450, 1449, 1448, 1447, 1328, 1512,
 /*  1270 */  1577,  154, 1376, 1327,  897, 1325,  361,  466, 1506, 1494,
 /*  1280 */  1485,  362,  363, 1577, 1099, 1100, 1323,  465,  437,  365,
 /*  1290 */   466, 1533, 1321,  366,  276,  367,  371,  369,  370, 1319,
 /*  1300 */   465,  373, 1308, 1307, 1533, 1304,  374,  274, 1378,  246,
 /*  1310 */  1562,  468, 1564, 1565,  464,   76,  459, 1561, 1005,  375,
 /*  1320 */  1008, 1377,  246, 1562,  468, 1564, 1565,  464,  929,  459,
 /*  1330 */  1317,  161,  928, 1561,  262,  927,  926, 1312,  923,  263,
 /*  1340 */  1310, 1577,  922, 1303,  264, 1561,  399,  402,  466,  404,
 /*  1350 */  1302,  406,  530,   75,  532, 1511,   46, 1577,  465, 1505,
 /*  1360 */   413, 1075, 1533,  119,  466,  278, 1493, 1492, 1484, 1577,
 /*  1370 */   186,  178,   38,  414,  465,  181,  466,    3, 1533, 1374,
 /*  1380 */   246, 1562,  468, 1564, 1565,  464,  465,  459,   56,   35,
 /*  1390 */  1533,   13, 1561,   40, 1236,   41,  234, 1562,  468, 1564,
 /*  1400 */  1565,  464,  126,  459,   14, 1561, 1229,  183,  240, 1562,
 /*  1410 */   468, 1564, 1565,  464, 1208,  459, 1577,  191,  190,   20,
 /*  1420 */  1552,   57,   21,  466,   39,   15,   11, 1207,  197, 1577,
 /*  1430 */    58, 1263, 1258,  465,  135, 1257,  466, 1533, 1372,  272,
 /*  1440 */   106, 1262, 1261, 1561,  513,  273,  465,    8,   17, 1154,
 /*  1450 */  1533, 1171,  458, 1139,   27,  242, 1562,  468, 1564, 1565,
 /*  1460 */   464, 1153,  459, 1152,  205,   10,  516, 1577,  235, 1562,
 /*  1470 */   468, 1564, 1565,  464,  466,  459,  138, 1234,  204,   18,
 /*  1480 */   467, 1483,   19,  207,  465,  512,  511,  510, 1533,  509,
 /*  1490 */   209,   59,  211, 1561,  213,   60,  473,   64, 1551,  106,
 /*  1500 */   216, 1111,   42,  513,  484,  990,  243, 1562,  468, 1564,
 /*  1510 */  1565,  464,  486,  459,  286,  488,  490, 1577,  987,  984,
 /*  1520 */   491,  493,  494, 1561,  466,  516,  978,  496,  497,  499,
 /*  1530 */   976,  500,  982,  967,  465,  981,  980,  506, 1533,  979,
 /*  1540 */    65, 1002,   66,   67,  512,  511,  510, 1577,  509,  995,
 /*  1550 */   998, 1001,  895,  936,  466,  517,  236, 1562,  468, 1564,
 /*  1560 */  1565,  464,  519,  459,  465,  911,  218,  918, 1533,  917,
 /*  1570 */   916, 1561,  915,  914,  913,  912,  933,  931,  908,  907,
 /*  1580 */  1561,  543,  906,  903,  902,  901,  244, 1562,  468, 1564,
 /*  1590 */  1565,  464,  900,  459, 1324, 1577,  541,  542, 1322,  546,
 /*  1600 */   545, 1320,  466,  547, 1577,  549,  550,  551, 1318,  553,
 /*  1610 */   554,  466,  465, 1306,  557,  555, 1533,  558, 1305, 1301,
 /*  1620 */   562,  465,  561,  566, 1097, 1533,  227,  565, 1561, 1276,
 /*  1630 */  1276, 1276, 1276, 1276,  237, 1562,  468, 1564, 1565,  464,
 /*  1640 */  1276,  459, 1276, 1573, 1562,  468, 1564, 1565,  464, 1276,
 /*  1650 */   459, 1276, 1577, 1276, 1276, 1276, 1561, 1276, 1276,  466,
 /*  1660 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,  465,
 /*  1670 */  1276, 1276, 1276, 1533, 1276, 1276, 1276, 1276, 1276, 1276,
 /*  1680 */  1577, 1276, 1276, 1276, 1276, 1276, 1276,  466, 1276, 1276,
 /*  1690 */  1276, 1572, 1562,  468, 1564, 1565,  464,  465,  459, 1276,
 /*  1700 */  1276, 1533, 1276, 1276, 1276, 1276, 1276, 1561, 1276, 1276,
 /*  1710 */  1276, 1276, 1276, 1276, 1276, 1276, 1561, 1276, 1276, 1571,
 /*  1720 */  1562,  468, 1564, 1565,  464, 1276,  459, 1276, 1276, 1276,
 /*  1730 */  1276, 1577, 1276, 1276, 1276, 1276, 1276, 1276,  466, 1276,
 /*  1740 */  1577, 1276, 1276, 1276, 1276, 1276, 1276,  466,  465, 1276,
 /*  1750 */  1276, 1276, 1533, 1276, 1276, 1276, 1276,  465, 1276, 1276,
 /*  1760 */  1276, 1533, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*  1770 */   253, 1562,  468, 1564, 1565,  464, 1276,  459, 1276,  252,
 /*  1780 */  1562,  468, 1564, 1565,  464, 1276,  459, 1561, 1276, 1276,
 /*  1790 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*  1800 */  1276, 1276, 1276, 1561, 1276, 1276, 1276, 1276, 1276, 1276,
 /*  1810 */  1276, 1577, 1276, 1276, 1276, 1276, 1276, 1276,  466, 1276,
 /*  1820 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1577,  465, 1276,
 /*  1830 */  1276, 1276, 1533, 1276,  466, 1276, 1276, 1276, 1276, 1276,
 /*  1840 */  1276, 1276, 1276, 1276,  465, 1276, 1276, 1276, 1533, 1276,
 /*  1850 */   254, 1562,  468, 1564, 1565,  464, 1276,  459, 1561, 1276,
 /*  1860 */  1276, 1276, 1276, 1276, 1276, 1276,  251, 1562,  468, 1564,
 /*  1870 */  1565,  464, 1276,  459, 1276, 1276, 1276, 1276, 1276, 1276,
 /*  1880 */  1276, 1276, 1577, 1276, 1276, 1276, 1276, 1276, 1276,  466,
 /*  1890 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,  465,
 /*  1900 */  1276, 1276, 1276, 1533, 1276, 1276, 1276, 1276, 1276, 1276,
 /*  1910 */  1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276, 1276,
 /*  1920 */  1276,  239, 1562,  468, 1564, 1565,  464, 1276,  459,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   222,  311,  247,  222,  250,  296,  297,  228,  228,  219,
 /*    10 */   263,  267,   12,   13,  324,  222,  269,  237,  328,  222,
 /*    20 */    20,  267,   22,  250,  244,  281,  282,  246,   12,   13,
 /*    30 */    14,   15,   16,  253,  253,  281,  282,  258,   38,  246,
 /*    40 */   267,   20,  230,  228,  263,  267,  253,  228,  267,   20,
 /*    50 */    50,   12,   13,   14,  281,  282,  263,   57,   20,   20,
 /*    60 */   267,   22,  272,  251,  267,  272,  285,  286,  287,  288,
 /*    70 */   289,  290,  253,  292,   74,  228,   49,   38,  285,  286,
 /*    80 */   287,  288,  289,  290,  237,  292,    0,  272,  295,   50,
 /*    90 */   228,   75,  299,  300,  231,   74,   57,   97,  235,  237,
 /*   100 */   253,  311,   12,   13,  311,  221,  244,  223,  289,  109,
 /*   110 */    20,  330,   22,   74,  324,  253,    0,  324,  328,   20,
 /*   120 */     2,  328,  303,  304,  305,  306,  311,  308,   38,    0,
 /*   130 */    12,   13,   14,   15,   16,   49,   97,    0,  246,  324,
 /*   140 */    50,  225,  226,  328,  252,  246,  146,   57,  109,  257,
 /*   150 */    21,  245,  253,   24,   25,   26,   27,   28,   29,   30,
 /*   160 */    31,   32,  256,  263,   74,   49,  266,  167,  168,  269,
 /*   170 */   170,  171,  172,  173,  174,  175,  176,  177,  178,  179,
 /*   180 */   180,  181,  182,  183,  230,  146,  287,   97,  136,   52,
 /*   190 */   145,   54,  147,  222,   20,   58,  196,  243,   61,  109,
 /*   200 */    63,   64,  222,   66,  283,  251,  167,  168,   22,  170,
 /*   210 */   171,  172,  173,  174,  175,  176,  177,  178,  179,  180,
 /*   220 */   181,  182,  183,   61,   38,  196,  228,   65,  307,   12,
 /*   230 */    13,   12,   13,   14,   15,   16,  146,   20,  267,   22,
 /*   240 */    38,  196,   12,   13,   14,   15,   16,  267,   74,   87,
 /*   250 */   196,  253,    0,  201,  202,   38,  228,  167,  168,   57,
 /*   260 */   170,  171,  172,  173,  174,  175,  176,  177,  178,  179,
 /*   270 */   180,  181,  182,  183,   57,   12,   13,   14,  155,  156,
 /*   280 */    50,  253,  159,   20,   20,   22,    0,  289,   36,   21,
 /*   290 */   222,   74,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   300 */    32,   38,  304,  305,  306,   75,  308,  238,    1,    2,
 /*   310 */    52,   20,   54,   83,   97,  246,   58,  289,   20,   61,
 /*   320 */    57,   63,   64,  254,   66,  272,  109,  167,   14,   15,
 /*   330 */    16,   35,  304,  305,  306,  267,  308,   74,   52,   53,
 /*   340 */    54,   55,   56,   20,   58,   59,   60,   61,   62,   63,
 /*   350 */    64,   65,   66,   67,   68,   69,   70,   61,  232,  233,
 /*   360 */    97,   65,  132,  146,  311,  205,  206,  207,  208,  209,
 /*   370 */   196,  239,  109,   77,  242,   79,   80,  324,   82,  222,
 /*   380 */   150,  328,   75,   87,  167,  168,    3,  170,  171,  172,
 /*   390 */   173,  174,  175,  176,  177,  178,  179,  180,  181,  182,
 /*   400 */   183,   71,   12,   13,   12,   13,   14,   15,   16,  146,
 /*   410 */    20,  227,   22,  196,  184,  185,  186,  187,  188,  189,
 /*   420 */   190,  191,  192,  193,  267,  241,   47,  272,   38,  138,
 /*   430 */   167,  168,  248,  170,  171,  172,  173,  174,  175,  176,
 /*   440 */   177,  178,  179,  180,  181,  182,  183,   57,   12,   13,
 /*   450 */    12,   13,   73,    4,  255,   76,   20,  246,   22,    2,
 /*   460 */    22,  262,  263,  252,   74,    4,  311,  246,  257,   12,
 /*   470 */    13,   14,   15,   16,   38,  228,   38,  222,  257,  324,
 /*   480 */    19,  283,  238,  328,  237,   71,   20,   97,   22,   75,
 /*   490 */   246,  232,  233,   57,   33,   57,   67,   36,  254,  109,
 /*   500 */   253,  222,   41,   43,  222,  307,   40,  234,   47,  236,
 /*   510 */    74,   88,   89,   90,   91,   92,   93,   94,   95,   96,
 /*   520 */    97,   98,  267,  100,  101,  102,  103,  104,  105,   18,
 /*   530 */   138,   20,  238,   97,   73,   97,  146,   76,   27,   49,
 /*   540 */   246,   30,  113,  114,  214,  109,  267,  109,  254,  267,
 /*   550 */    39,   12,   13,   14,   15,   16,  222,  167,  168,  283,
 /*   560 */   170,  171,  172,  173,  174,  175,  176,  177,  178,  179,
 /*   570 */   180,  181,  182,  183,   12,   13,   14,   15,   16,  132,
 /*   580 */   222,   85,  146,  307,  146,  232,  233,  232,  233,   50,
 /*   590 */    12,   13,   14,   15,   16,  212,   20,  150,    1,    2,
 /*   600 */   227,  267,  222,  167,  168,  167,  170,  171,  172,  173,
 /*   610 */   174,  175,  176,  177,  178,  179,  180,  181,  182,  183,
 /*   620 */   222,  248,   83,  112,   57,  267,  115,  116,  117,  118,
 /*   630 */   119,  184,  121,  122,  123,  124,  125,  126,  127,  128,
 /*   640 */   129,  130,  131,  228,  246,  228,  197,  267,  228,   19,
 /*   650 */   246,  253,  237,   75,  237,  195,  246,  237,  254,  194,
 /*   660 */   195,  263,  252,   33,  222,  267,   36,  257,  253,  228,
 /*   670 */   253,  132,   42,  253,   44,   45,   46,   47,  237,  157,
 /*   680 */   158,  246,  275,  285,  286,  287,  288,  289,  290,  150,
 /*   690 */   292,  228,  257,  295,  253,  228,  223,  299,  300,  301,
 /*   700 */   237,  139,  222,   73,  237,  222,   76,   71,  253,  267,
 /*   710 */   222,  313,  228,  228,  138,  260,  253,  319,  320,  247,
 /*   720 */   253,  237,  237,  184,  185,  186,  187,  188,  189,  190,
 /*   730 */   191,  192,  193,   14,  246,    0,  106,  253,  253,   20,
 /*   740 */   228,  253,   78,  142,   50,   81,  222,  267,  222,  237,
 /*   750 */   267,  263,  222,  222,   14,  267,  222,   22,   21,  331,
 /*   760 */    20,  247,  161,   78,  134,  253,   81,  137,  222,   78,
 /*   770 */   247,   34,   81,  285,  286,  287,  288,  289,  290,  217,
 /*   780 */   292,  322,  152,  295,  154,    0,   74,  299,  300,  301,
 /*   790 */     0,  267,  246,  267,  181,  182,   84,  267,  267,  253,
 /*   800 */    78,  267,    0,   81,  247,  247,  247,   22,  320,  263,
 /*   810 */   235,  256,  279,  267,   24,   25,   26,   27,   28,   29,
 /*   820 */    30,   31,   32,   71,   22,   71,  222,   75,  225,   75,
 /*   830 */    74,  285,  286,  287,  288,  289,  290,  316,  292,   71,
 /*   840 */   284,  295,   86,   75,   71,  299,  300,  301,   75,  309,
 /*   850 */   246,   71,  216,   18,   38,   75,  310,  253,   23,   71,
 /*   860 */    71,  167,   38,   75,   75,  246,   33,  263,   38,   36,
 /*   870 */    35,  267,   71,   57,  325,   42,   75,   44,   45,   46,
 /*   880 */    47,   71,  312,   48,  222,   75,   20,  228,   36,  285,
 /*   890 */   286,  287,  288,  289,  290,  280,  292,   71,   38,  295,
 /*   900 */   232,   75,  144,  299,  300,  301,   73,   71,  246,   76,
 /*   910 */   273,   75,  228,   71,  310,  253,   71,   75,   71,   71,
 /*   920 */    75,  228,   75,   75,   71,  263,  120,  261,   75,  267,
 /*   930 */   132,  259,  259,  109,  228,  277,   20,  230,  263,  109,
 /*   940 */   222,   20,  271,  230,   20,  253,  111,  285,  286,  287,
 /*   950 */   288,  289,  290,  222,  292,  230,  230,  295,  228,  264,
 /*   960 */    20,  299,  300,  301,  246,  224,  133,  246,  135,  230,
 /*   970 */   137,  253,  310,  246,  139,  140,  141,  246,  143,  246,
 /*   980 */   246,  263,  246,  148,  253,  267,  224,  154,  246,  246,
 /*   990 */   272,  222,  246,  246,  263,  160,  246,  162,  267,  164,
 /*  1000 */   165,  166,  228,  285,  286,  287,  288,  289,  290,  228,
 /*  1010 */   292,  246,   57,  227,  153,  246,  285,  286,  287,  288,
 /*  1020 */   289,  290,  253,  292,  267,  294,  277,  276,  253,  311,
 /*  1030 */   263,  196,  263,   20,  253,  271,  267,  284,  227,  227,
 /*  1040 */   264,  204,  324,  203,  321,  268,  328,  268,  210,  222,
 /*  1050 */   267,  267,  211,  272,  285,  286,  287,  288,  289,  290,
 /*  1060 */   267,  292,  199,  318,  295,  321,  198,  195,  299,  300,
 /*  1070 */   289,  253,  317,  246,  315,  314,   20,  283,  120,  222,
 /*  1080 */   253,   74,  218,  213,  302,  304,  305,  306,  215,  308,
 /*  1090 */   263,  268,  311,  327,  267,  332,  326,  298,  267,  267,
 /*  1100 */   242,  135,  268,  246,  253,  324,  267,  227,  265,  328,
 /*  1110 */   253,  227,  285,  286,  287,  288,  289,  290,  264,  292,
 /*  1120 */   263,   74,  295,  249,  267,  236,  299,  300,  222,  253,
 /*  1130 */   228,  227,  224,  274,  278,  240,  240,  222,  229,   22,
 /*  1140 */   220,    0,  285,  286,  287,  288,  289,  290,  291,  292,
 /*  1150 */   293,  294,  246,    0,   64,   38,    0,   38,  163,  253,
 /*  1160 */    38,  246,   38,   38,  163,    0,   38,   38,  253,  263,
 /*  1170 */    38,  163,    0,  267,   57,  222,    0,   38,  263,    0,
 /*  1180 */    74,  150,  267,  149,  109,  146,    0,  222,    0,   53,
 /*  1190 */   142,  285,  286,  287,  288,  289,  290,    0,  292,  246,
 /*  1200 */   285,  286,  287,  288,  289,  290,  253,  292,    0,    0,
 /*  1210 */   295,  246,   86,    0,   97,  300,  263,    0,  253,    0,
 /*  1220 */   267,  120,    0,  270,    0,    0,  109,    0,  263,    0,
 /*  1230 */     0,    0,  267,    0,    0,  329,  330,    0,  285,  286,
 /*  1240 */   287,  288,  289,  290,    0,  292,  222,    0,    0,    0,
 /*  1250 */   285,  286,  287,  288,  289,  290,    0,  292,    0,  222,
 /*  1260 */     0,    0,   22,  146,    0,    0,    0,    0,    0,    0,
 /*  1270 */   246,   43,    0,    0,   51,    0,   38,  253,    0,    0,
 /*  1280 */     0,   36,   43,  246,  167,  168,    0,  263,  323,   38,
 /*  1290 */   253,  267,    0,   36,  270,   43,   43,   38,   36,    0,
 /*  1300 */   263,   38,    0,    0,  267,    0,   36,  270,    0,  285,
 /*  1310 */   286,  287,  288,  289,  290,   83,  292,  222,   22,   43,
 /*  1320 */    38,    0,  285,  286,  287,  288,  289,  290,   38,  292,
 /*  1330 */     0,   81,   38,  222,   22,   38,   38,    0,   38,   22,
 /*  1340 */     0,  246,   38,    0,   22,  222,   39,   38,  253,   22,
 /*  1350 */     0,   22,   71,   20,   71,    0,  138,  246,  263,    0,
 /*  1360 */    22,   38,  267,  151,  253,  270,    0,    0,    0,  246,
 /*  1370 */    75,  135,  194,  138,  263,   43,  253,   71,  267,    0,
 /*  1380 */   285,  286,  287,  288,  289,  290,  263,  292,   74,   71,
 /*  1390 */   267,  200,  222,  138,   75,   71,  285,  286,  287,  288,
 /*  1400 */   289,  290,   74,  292,  200,  222,   75,  133,  285,  286,
 /*  1410 */   287,  288,  289,  290,   75,  292,  246,   71,   74,   74,
 /*  1420 */    86,   74,   71,  253,   71,   71,  200,   75,   86,  246,
 /*  1430 */     4,   75,   38,  263,   86,   38,  253,  267,    0,   38,
 /*  1440 */    61,   38,   38,  222,   65,   38,  263,    2,   71,   75,
 /*  1450 */   267,  167,   74,   22,   74,  285,  286,  287,  288,  289,
 /*  1460 */   290,   75,  292,   75,   75,   74,   87,  246,  285,  286,
 /*  1470 */   287,  288,  289,  290,  253,  292,   86,   75,   86,   74,
 /*  1480 */   169,    0,   74,   74,  263,  106,  107,  108,  267,  110,
 /*  1490 */    74,   74,   43,  222,  133,   74,  136,   84,   86,   61,
 /*  1500 */    86,   22,   74,   65,   85,   75,  285,  286,  287,  288,
 /*  1510 */   289,  290,   38,  292,   38,   74,   38,  246,   75,   75,
 /*  1520 */    74,   38,   74,  222,  253,   87,   75,   38,   74,   38,
 /*  1530 */    75,   74,   99,   22,  263,   99,   99,   87,  267,   99,
 /*  1540 */    74,   38,   74,   74,  106,  107,  108,  246,  110,   22,
 /*  1550 */    38,  109,   51,   57,  253,   50,  285,  286,  287,  288,
 /*  1560 */   289,  290,   72,  292,  263,   22,   71,   38,  267,   38,
 /*  1570 */    38,  222,   38,   38,   38,   38,   57,   38,   38,   38,
 /*  1580 */   222,   43,   38,   38,   38,   38,  285,  286,  287,  288,
 /*  1590 */   289,  290,   38,  292,    0,  246,   38,   36,    0,   36,
 /*  1600 */    38,    0,  253,   43,  246,   38,   36,   43,    0,   38,
 /*  1610 */    36,  253,  263,    0,   38,   43,  267,   37,    0,    0,
 /*  1620 */    21,  263,   22,   20,   22,  267,   22,   21,  222,  333,
 /*  1630 */   333,  333,  333,  333,  285,  286,  287,  288,  289,  290,
 /*  1640 */   333,  292,  333,  285,  286,  287,  288,  289,  290,  333,
 /*  1650 */   292,  333,  246,  333,  333,  333,  222,  333,  333,  253,
 /*  1660 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  263,
 /*  1670 */   333,  333,  333,  267,  333,  333,  333,  333,  333,  333,
 /*  1680 */   246,  333,  333,  333,  333,  333,  333,  253,  333,  333,
 /*  1690 */   333,  285,  286,  287,  288,  289,  290,  263,  292,  333,
 /*  1700 */   333,  267,  333,  333,  333,  333,  333,  222,  333,  333,
 /*  1710 */   333,  333,  333,  333,  333,  333,  222,  333,  333,  285,
 /*  1720 */   286,  287,  288,  289,  290,  333,  292,  333,  333,  333,
 /*  1730 */   333,  246,  333,  333,  333,  333,  333,  333,  253,  333,
 /*  1740 */   246,  333,  333,  333,  333,  333,  333,  253,  263,  333,
 /*  1750 */   333,  333,  267,  333,  333,  333,  333,  263,  333,  333,
 /*  1760 */   333,  267,  333,  333,  333,  333,  333,  333,  333,  333,
 /*  1770 */   285,  286,  287,  288,  289,  290,  333,  292,  333,  285,
 /*  1780 */   286,  287,  288,  289,  290,  333,  292,  222,  333,  333,
 /*  1790 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*  1800 */   333,  333,  333,  222,  333,  333,  333,  333,  333,  333,
 /*  1810 */   333,  246,  333,  333,  333,  333,  333,  333,  253,  333,
 /*  1820 */   333,  333,  333,  333,  333,  333,  333,  246,  263,  333,
 /*  1830 */   333,  333,  267,  333,  253,  333,  333,  333,  333,  333,
 /*  1840 */   333,  333,  333,  333,  263,  333,  333,  333,  267,  333,
 /*  1850 */   285,  286,  287,  288,  289,  290,  333,  292,  222,  333,
 /*  1860 */   333,  333,  333,  333,  333,  333,  285,  286,  287,  288,
 /*  1870 */   289,  290,  333,  292,  333,  333,  333,  333,  333,  333,
 /*  1880 */   333,  333,  246,  333,  333,  333,  333,  333,  333,  253,
 /*  1890 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  263,
 /*  1900 */   333,  333,  333,  267,  333,  333,  333,  333,  333,  333,
 /*  1910 */   333,  333,  333,  333,  333,  333,  333,  333,  333,  333,
 /*  1920 */   333,  285,  286,  287,  288,  289,  290,  333,  292,
};
#define YY_SHIFT_COUNT    (567)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1619)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   835,    0,   39,   90,   90,   90,   90,  217,   90,   90,
 /*    10 */   263,  390,  436,  390,  390,  390,  390,  390,  390,  390,
 /*    20 */   390,  390,  390,  390,  390,  390,  390,  390,  390,  390,
 /*    30 */   390,  390,  390,  390,  390,  390,  174,   21,   21,   21,
 /*    40 */    29,  438,  438,   45,   38,   38,   54,  438,   38,   38,
 /*    50 */    38,   38,   38,   38,   27,   38,   99,  264,   54,  298,
 /*    60 */    99,   38,   38,   99,   38,   99,  298,   99,   99,   38,
 /*    70 */   490,  511,  230,  539,  539,  268, 1117,  296, 1117, 1117,
 /*    80 */  1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117, 1117,
 /*    90 */  1117, 1117, 1117, 1117, 1117, 1117, 1117,  258,  466,   86,
 /*   100 */   202,  202,  291,  291,  291,  116,  202,  202,  323,  298,
 /*   110 */    99,   99,   99,  496,  567,  423,  423,  423,  423,  423,
 /*   120 */   423,  423,  630,  129,  137,  562,  160,  162,  123,   52,
 /*   130 */   186,  576,  465,  460,  465,  719,  383,  449,  740,  866,
 /*   140 */   852,  860,  758,  866,  866,  806,  798,  798,  866,  916,
 /*   150 */    27,  298,  921,   27,  323,  924,   27,   27,  866,   27,
 /*   160 */   940,   99,   99,   99,   99,   99,   99,   99,   99,   99,
 /*   170 */    99,   99,  866,  940,  955,  916,  490,  861,  298,  921,
 /*   180 */   490,  323,  924,  490, 1013,  837,  840,  955,  837,  840,
 /*   190 */   955,  955,  841,  838,  863,  868,  872,  323, 1056,  958,
 /*   200 */   864,  873,  870, 1007,   99,  840,  955,  955,  840,  955,
 /*   210 */   966,  323,  924,  490,  496,  490,  323, 1047,  567,  866,
 /*   220 */   490,  940, 1929, 1929, 1929, 1929, 1929, 1929,  286,  833,
 /*   230 */   790,  461, 1379, 1438,   16,  118,  457,  392,  578,  219,
 /*   240 */   219,  219,  219,  219,  219,  219,  219,  379,  429,  307,
 /*   250 */   447,  314,  314,  314,  314,  252,  601,  414,  664,  685,
 /*   260 */   691,  722,  735,  785,  802,  737,  522,  752,  754,  768,
 /*   270 */   597,  613,  330,  636,  773,  694,  780,  756,  788,  789,
 /*   280 */   801,  810,  826,  824,  830,  836,  842,  845,  847,  848,
 /*   290 */   853,  712,  816, 1141, 1153, 1090, 1156, 1119,  995, 1122,
 /*   300 */  1124, 1125, 1001, 1165, 1128, 1129, 1008, 1172, 1132, 1176,
 /*   310 */  1139, 1179, 1106, 1031, 1034, 1075, 1039, 1186, 1188, 1136,
 /*   320 */  1048, 1197, 1208, 1126, 1209, 1213, 1217, 1219, 1224, 1225,
 /*   330 */  1227, 1229, 1230, 1231, 1233, 1234, 1237, 1244, 1247, 1248,
 /*   340 */  1101, 1222, 1249, 1256, 1258, 1260, 1261, 1240, 1264, 1265,
 /*   350 */  1266, 1267, 1268, 1269, 1278, 1279, 1280, 1228, 1272, 1223,
 /*   360 */  1273, 1275, 1238, 1245, 1239, 1286, 1251, 1257, 1252, 1292,
 /*   370 */  1259, 1262, 1253, 1299, 1263, 1270, 1276, 1302, 1303, 1305,
 /*   380 */  1308, 1232, 1250, 1282, 1281, 1283, 1296, 1321, 1290, 1294,
 /*   390 */  1297, 1298, 1281, 1283, 1300, 1304, 1330, 1312, 1337, 1317,
 /*   400 */  1307, 1340, 1322, 1309, 1343, 1327, 1350, 1329, 1333, 1355,
 /*   410 */  1218, 1323, 1359, 1212, 1338, 1235, 1236, 1366, 1367, 1255,
 /*   420 */  1368, 1314, 1332, 1274, 1306, 1318, 1191, 1295, 1324, 1319,
 /*   430 */  1328, 1344, 1345, 1331, 1346, 1334, 1347, 1351, 1204, 1339,
 /*   440 */  1352, 1342, 1178, 1353, 1348, 1356, 1354, 1226, 1426, 1394,
 /*   450 */  1397, 1401, 1403, 1404, 1407, 1445, 1284, 1377, 1374, 1378,
 /*   460 */  1386, 1380, 1388, 1390, 1391, 1405, 1392, 1431, 1311, 1408,
 /*   470 */  1389, 1402, 1409, 1416, 1360, 1417, 1481, 1449, 1361, 1421,
 /*   480 */  1413, 1412, 1414, 1479, 1428, 1419, 1430, 1474, 1476, 1441,
 /*   490 */  1443, 1478, 1446, 1444, 1483, 1448, 1451, 1489, 1454, 1455,
 /*   500 */  1491, 1457, 1433, 1436, 1437, 1440, 1511, 1450, 1466, 1503,
 /*   510 */  1442, 1468, 1469, 1512, 1281, 1283, 1527, 1501, 1505, 1496,
 /*   520 */  1490, 1495, 1529, 1531, 1532, 1534, 1535, 1536, 1537, 1543,
 /*   530 */  1519, 1281, 1539, 1283, 1540, 1541, 1544, 1545, 1546, 1547,
 /*   540 */  1554, 1594, 1558, 1561, 1538, 1598, 1562, 1563, 1560, 1601,
 /*   550 */  1567, 1570, 1564, 1608, 1571, 1574, 1572, 1613, 1576, 1580,
 /*   560 */  1618, 1619, 1600, 1599, 1602, 1604, 1606, 1603,
};
#define YY_REDUCE_COUNT (227)
#define YY_REDUCE_MIN   (-310)
#define YY_REDUCE_MAX   (1636)
static const short yy_reduce_ofst[] = {
 /*     0 */  -210, -207,  398,  488,  546,  604,  662,  718,  769,  827,
 /*    10 */   857,  906,  915,  953,  965, -219, 1037,  731, 1024, 1095,
 /*    20 */  1111, 1123, 1170, 1183, 1221, 1271, 1301, 1349, 1358, 1406,
 /*    30 */  1434, 1485, 1494, 1565, 1581, 1636,  781, -181,   -2,   28,
 /*    40 */  -185, -246, -227,   53, -220, -138,  155, -256, -153,  247,
 /*    50 */   415,  417,  420,  441,  -46,  467, -108, -101, -310, -100,
 /*    60 */    69,  484,  485,  211,  512,  244,  199,  410,  294,  463,
 /*    70 */   184, -221, -291, -291, -291, -116, -222,  -94, -203,  -29,
 /*    80 */   -20,   68,  157,  255,  279,  282,  334,  358,  380,  442,
 /*    90 */   480,  483,  524,  526,  530,  531,  534, -137,  -84, -188,
 /*   100 */   126,  259,  -79,  198,  276,  373,  353,  355,  455, -253,
 /*   110 */   404,  221,  435,  132,  273, -245,  472,  514,  523,  557,
 /*   120 */   558,  559,  407,  473,  575,  428,  459,  555,  533,  521,
 /*   130 */   603,  556,  540,  540,  540,  619,  549,  570,  619,  659,
 /*   140 */   615,  668,  637,  684,  693,  666,  672,  673,  706,  658,
 /*   150 */   707,  675,  671,  713,  692,  695,  725,  726,  730,  739,
 /*   160 */   741,  721,  727,  733,  734,  736,  742,  743,  746,  747,
 /*   170 */   750,  765,  774,  762,  757,  749,  786,  751,  767,  764,
 /*   180 */   811,  775,  776,  812,  753,  723,  777,  783,  744,  779,
 /*   190 */   784,  793,  745,  755,  759,  761,  540,  818,  794,  782,
 /*   200 */   763,  766,  770,  799,  619,  823,  831,  832,  834,  839,
 /*   210 */   843,  851,  854,  880,  858,  884,  876,  874,  889,  902,
 /*   220 */   904,  908,  859,  856,  895,  896,  909,  920,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*    10 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*    20 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*    30 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*    40 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*    50 */  1274, 1274, 1274, 1274, 1333, 1274, 1274, 1274, 1274, 1274,
 /*    60 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*    70 */  1331, 1473, 1274, 1628, 1274, 1274, 1274, 1274, 1274, 1274,
 /*    80 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*    90 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1333,
 /*   100 */  1274, 1274, 1639, 1639, 1639, 1331, 1274, 1274, 1274, 1274,
 /*   110 */  1274, 1274, 1274, 1426, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   120 */  1274, 1274, 1507, 1274, 1274, 1703, 1274, 1379, 1513, 1663,
 /*   130 */  1274, 1655, 1631, 1645, 1632, 1274, 1688, 1648, 1274, 1274,
 /*   140 */  1274, 1274, 1499, 1274, 1274, 1478, 1475, 1475, 1274, 1274,
 /*   150 */  1333, 1274, 1274, 1333, 1274, 1274, 1333, 1333, 1274, 1333,
 /*   160 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   170 */  1274, 1274, 1274, 1274, 1274, 1274, 1331, 1509, 1274, 1274,
 /*   180 */  1331, 1274, 1274, 1331, 1274, 1670, 1668, 1274, 1670, 1668,
 /*   190 */  1274, 1274, 1682, 1678, 1661, 1659, 1645, 1274, 1274, 1274,
 /*   200 */  1706, 1694, 1690, 1274, 1274, 1668, 1274, 1274, 1668, 1274,
 /*   210 */  1486, 1274, 1274, 1331, 1274, 1331, 1274, 1395, 1274, 1274,
 /*   220 */  1331, 1274, 1501, 1515, 1429, 1429, 1334, 1279, 1274, 1274,
 /*   230 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1576,
 /*   240 */  1681, 1680, 1604, 1603, 1602, 1600, 1575, 1274, 1274, 1274,
 /*   250 */  1274, 1569, 1570, 1568, 1567, 1274, 1274, 1274, 1274, 1274,
 /*   260 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   270 */  1629, 1274, 1691, 1695, 1274, 1274, 1274, 1553, 1274, 1274,
 /*   280 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   290 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   300 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   310 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   320 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   330 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   340 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   350 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   360 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   370 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   380 */  1274, 1274, 1274, 1274, 1442, 1441, 1274, 1274, 1274, 1274,
 /*   390 */  1274, 1274, 1360, 1359, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   400 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   410 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   420 */  1274, 1274, 1274, 1274, 1652, 1662, 1274, 1274, 1274, 1274,
 /*   430 */  1274, 1274, 1274, 1274, 1274, 1553, 1274, 1679, 1274, 1638,
 /*   440 */  1634, 1274, 1274, 1630, 1274, 1274, 1689, 1274, 1274, 1274,
 /*   450 */  1274, 1274, 1274, 1274, 1274, 1624, 1274, 1597, 1274, 1274,
 /*   460 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1563, 1274,
 /*   470 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   480 */  1274, 1552, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1423,
 /*   490 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   500 */  1274, 1274, 1408, 1406, 1405, 1404, 1274, 1401, 1274, 1274,
 /*   510 */  1274, 1274, 1274, 1274, 1432, 1431, 1274, 1274, 1274, 1274,
 /*   520 */  1274, 1354, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   530 */  1274, 1345, 1274, 1344, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   540 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   550 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
 /*   560 */  1274, 1274, 1274, 1274, 1274, 1274, 1274, 1274,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "DNODE",
  /*   37 */ "PORT",
  /*   38 */ "NK_INTEGER",
  /*   39 */ "DNODES",
  /*   40 */ "NK_IPTOKEN",
  /*   41 */ "LOCAL",
  /*   42 */ "QNODE",
  /*   43 */ "ON",
  /*   44 */ "BNODE",
  /*   45 */ "SNODE",
  /*   46 */ "MNODE",
  /*   47 */ "DATABASE",
  /*   48 */ "USE",
  /*   49 */ "IF",
  /*   50 */ "NOT",
  /*   51 */ "EXISTS",
  /*   52 */ "BLOCKS",
  /*   53 */ "CACHE",
  /*   54 */ "CACHELAST",
  /*   55 */ "COMP",
  /*   56 */ "DAYS",
  /*   57 */ "NK_VARIABLE",
  /*   58 */ "FSYNC",
  /*   59 */ "MAXROWS",
  /*   60 */ "MINROWS",
  /*   61 */ "KEEP",
  /*   62 */ "PRECISION",
  /*   63 */ "QUORUM",
  /*   64 */ "REPLICA",
  /*   65 */ "TTL",
  /*   66 */ "WAL",
  /*   67 */ "VGROUPS",
  /*   68 */ "SINGLE_STABLE",
  /*   69 */ "STREAM_MODE",
  /*   70 */ "RETENTIONS",
  /*   71 */ "NK_COMMA",
  /*   72 */ "NK_COLON",
  /*   73 */ "TABLE",
  /*   74 */ "NK_LP",
  /*   75 */ "NK_RP",
  /*   76 */ "STABLE",
  /*   77 */ "ADD",
  /*   78 */ "COLUMN",
  /*   79 */ "MODIFY",
  /*   80 */ "RENAME",
  /*   81 */ "TAG",
  /*   82 */ "SET",
  /*   83 */ "NK_EQ",
  /*   84 */ "USING",
  /*   85 */ "TAGS",
  /*   86 */ "NK_DOT",
  /*   87 */ "COMMENT",
  /*   88 */ "BOOL",
  /*   89 */ "TINYINT",
  /*   90 */ "SMALLINT",
  /*   91 */ "INT",
  /*   92 */ "INTEGER",
  /*   93 */ "BIGINT",
  /*   94 */ "FLOAT",
  /*   95 */ "DOUBLE",
  /*   96 */ "BINARY",
  /*   97 */ "TIMESTAMP",
  /*   98 */ "NCHAR",
  /*   99 */ "UNSIGNED",
  /*  100 */ "JSON",
  /*  101 */ "VARCHAR",
  /*  102 */ "MEDIUMBLOB",
  /*  103 */ "BLOB",
  /*  104 */ "VARBINARY",
  /*  105 */ "DECIMAL",
  /*  106 */ "SMA",
  /*  107 */ "ROLLUP",
  /*  108 */ "FILE_FACTOR",
  /*  109 */ "NK_FLOAT",
  /*  110 */ "DELAY",
  /*  111 */ "SHOW",
  /*  112 */ "DATABASES",
  /*  113 */ "TABLES",
  /*  114 */ "STABLES",
  /*  115 */ "MNODES",
  /*  116 */ "MODULES",
  /*  117 */ "QNODES",
  /*  118 */ "FUNCTIONS",
  /*  119 */ "INDEXES",
  /*  120 */ "FROM",
  /*  121 */ "ACCOUNTS",
  /*  122 */ "APPS",
  /*  123 */ "CONNECTIONS",
  /*  124 */ "LICENCE",
  /*  125 */ "GRANTS",
  /*  126 */ "QUERIES",
  /*  127 */ "SCORES",
  /*  128 */ "TOPICS",
  /*  129 */ "VARIABLES",
  /*  130 */ "BNODES",
  /*  131 */ "SNODES",
  /*  132 */ "LIKE",
  /*  133 */ "INDEX",
  /*  134 */ "FULLTEXT",
  /*  135 */ "FUNCTION",
  /*  136 */ "INTERVAL",
  /*  137 */ "TOPIC",
  /*  138 */ "AS",
  /*  139 */ "DESC",
  /*  140 */ "DESCRIBE",
  /*  141 */ "RESET",
  /*  142 */ "QUERY",
  /*  143 */ "EXPLAIN",
  /*  144 */ "ANALYZE",
  /*  145 */ "VERBOSE",
  /*  146 */ "NK_BOOL",
  /*  147 */ "RATIO",
  /*  148 */ "COMPACT",
  /*  149 */ "VNODES",
  /*  150 */ "IN",
  /*  151 */ "OUTPUTTYPE",
  /*  152 */ "AGGREGATE",
  /*  153 */ "BUFSIZE",
  /*  154 */ "STREAM",
  /*  155 */ "INTO",
  /*  156 */ "TRIGGER",
  /*  157 */ "AT_ONCE",
  /*  158 */ "WINDOW_CLOSE",
  /*  159 */ "WATERMARK",
  /*  160 */ "KILL",
  /*  161 */ "CONNECTION",
  /*  162 */ "MERGE",
  /*  163 */ "VGROUP",
  /*  164 */ "REDISTRIBUTE",
  /*  165 */ "SPLIT",
  /*  166 */ "SYNCDB",
  /*  167 */ "NULL",
  /*  168 */ "NK_QUESTION",
  /*  169 */ "NK_ARROW",
  /*  170 */ "ROWTS",
  /*  171 */ "TBNAME",
  /*  172 */ "QSTARTTS",
  /*  173 */ "QENDTS",
  /*  174 */ "WSTARTTS",
  /*  175 */ "WENDTS",
  /*  176 */ "WDURATION",
  /*  177 */ "CAST",
  /*  178 */ "NOW",
  /*  179 */ "TODAY",
  /*  180 */ "COUNT",
  /*  181 */ "FIRST",
  /*  182 */ "LAST",
  /*  183 */ "LAST_ROW",
  /*  184 */ "BETWEEN",
  /*  185 */ "IS",
  /*  186 */ "NK_LT",
  /*  187 */ "NK_GT",
  /*  188 */ "NK_LE",
  /*  189 */ "NK_GE",
  /*  190 */ "NK_NE",
  /*  191 */ "MATCH",
  /*  192 */ "NMATCH",
  /*  193 */ "CONTAINS",
  /*  194 */ "JOIN",
  /*  195 */ "INNER",
  /*  196 */ "SELECT",
  /*  197 */ "DISTINCT",
  /*  198 */ "WHERE",
  /*  199 */ "PARTITION",
  /*  200 */ "BY",
  /*  201 */ "SESSION",
  /*  202 */ "STATE_WINDOW",
  /*  203 */ "SLIDING",
  /*  204 */ "FILL",
  /*  205 */ "VALUE",
  /*  206 */ "NONE",
  /*  207 */ "PREV",
  /*  208 */ "LINEAR",
  /*  209 */ "NEXT",
  /*  210 */ "GROUP",
  /*  211 */ "HAVING",
  /*  212 */ "ORDER",
  /*  213 */ "SLIMIT",
  /*  214 */ "SOFFSET",
  /*  215 */ "LIMIT",
  /*  216 */ "OFFSET",
  /*  217 */ "ASC",
  /*  218 */ "NULLS",
  /*  219 */ "cmd",
  /*  220 */ "account_options",
  /*  221 */ "alter_account_options",
  /*  222 */ "literal",
  /*  223 */ "alter_account_option",
  /*  224 */ "user_name",
  /*  225 */ "dnode_endpoint",
  /*  226 */ "dnode_host_name",
  /*  227 */ "not_exists_opt",
  /*  228 */ "db_name",
  /*  229 */ "db_options",
  /*  230 */ "exists_opt",
  /*  231 */ "alter_db_options",
  /*  232 */ "integer_list",
  /*  233 */ "variable_list",
  /*  234 */ "retention_list",
  /*  235 */ "alter_db_option",
  /*  236 */ "retention",
  /*  237 */ "full_table_name",
  /*  238 */ "column_def_list",
  /*  239 */ "tags_def_opt",
  /*  240 */ "table_options",
  /*  241 */ "multi_create_clause",
  /*  242 */ "tags_def",
  /*  243 */ "multi_drop_clause",
  /*  244 */ "alter_table_clause",
  /*  245 */ "alter_table_options",
  /*  246 */ "column_name",
  /*  247 */ "type_name",
  /*  248 */ "create_subtable_clause",
  /*  249 */ "specific_tags_opt",
  /*  250 */ "literal_list",
  /*  251 */ "drop_table_clause",
  /*  252 */ "col_name_list",
  /*  253 */ "table_name",
  /*  254 */ "column_def",
  /*  255 */ "func_name_list",
  /*  256 */ "alter_table_option",
  /*  257 */ "col_name",
  /*  258 */ "db_name_cond_opt",
  /*  259 */ "like_pattern_opt",
  /*  260 */ "table_name_cond",
  /*  261 */ "from_db_opt",
  /*  262 */ "func_name",
  /*  263 */ "function_name",
  /*  264 */ "index_name",
  /*  265 */ "index_options",
  /*  266 */ "func_list",
  /*  267 */ "duration_literal",
  /*  268 */ "sliding_opt",
  /*  269 */ "func",
  /*  270 */ "expression_list",
  /*  271 */ "topic_name",
  /*  272 */ "query_expression",
  /*  273 */ "analyze_opt",
  /*  274 */ "explain_options",
  /*  275 */ "agg_func_opt",
  /*  276 */ "bufsize_opt",
  /*  277 */ "stream_name",
  /*  278 */ "stream_options",
  /*  279 */ "into_opt",
  /*  280 */ "dnode_list",
  /*  281 */ "signed",
  /*  282 */ "signed_literal",
  /*  283 */ "table_alias",
  /*  284 */ "column_alias",
  /*  285 */ "expression",
  /*  286 */ "pseudo_column",
  /*  287 */ "column_reference",
  /*  288 */ "function_expression",
  /*  289 */ "subquery",
  /*  290 */ "star_func",
  /*  291 */ "star_func_para_list",
  /*  292 */ "noarg_func",
  /*  293 */ "other_para_list",
  /*  294 */ "star_func_para",
  /*  295 */ "predicate",
  /*  296 */ "compare_op",
  /*  297 */ "in_op",
  /*  298 */ "in_predicate_value",
  /*  299 */ "boolean_value_expression",
  /*  300 */ "boolean_primary",
  /*  301 */ "common_expression",
  /*  302 */ "from_clause",
  /*  303 */ "table_reference_list",
  /*  304 */ "table_reference",
  /*  305 */ "table_primary",
  /*  306 */ "joined_table",
  /*  307 */ "alias_opt",
  /*  308 */ "parenthesized_joined_table",
  /*  309 */ "join_type",
  /*  310 */ "search_condition",
  /*  311 */ "query_specification",
  /*  312 */ "set_quantifier_opt",
  /*  313 */ "select_list",
  /*  314 */ "where_clause_opt",
  /*  315 */ "partition_by_clause_opt",
  /*  316 */ "twindow_clause_opt",
  /*  317 */ "group_by_clause_opt",
  /*  318 */ "having_clause_opt",
  /*  319 */ "select_sublist",
  /*  320 */ "select_item",
  /*  321 */ "fill_opt",
  /*  322 */ "fill_mode",
  /*  323 */ "group_by_list",
  /*  324 */ "query_expression_body",
  /*  325 */ "order_by_clause_opt",
  /*  326 */ "slimit_clause_opt",
  /*  327 */ "limit_clause_opt",
  /*  328 */ "query_primary",
  /*  329 */ "sort_specification_list",
  /*  330 */ "sort_specification",
  /*  331 */ "ordering_specification_opt",
  /*  332 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  29 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  30 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  31 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  32 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  33 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  34 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  35 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  36 */ "dnode_endpoint ::= NK_STRING",
 /*  37 */ "dnode_host_name ::= NK_ID",
 /*  38 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  39 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  40 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  41 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  42 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  43 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  45 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  46 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  47 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  48 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  49 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  50 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  51 */ "cmd ::= USE db_name",
 /*  52 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  53 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  54 */ "not_exists_opt ::=",
 /*  55 */ "exists_opt ::= IF EXISTS",
 /*  56 */ "exists_opt ::=",
 /*  57 */ "db_options ::=",
 /*  58 */ "db_options ::= db_options BLOCKS NK_INTEGER",
 /*  59 */ "db_options ::= db_options CACHE NK_INTEGER",
 /*  60 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  61 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  62 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  63 */ "db_options ::= db_options DAYS NK_VARIABLE",
 /*  64 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  65 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  66 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  67 */ "db_options ::= db_options KEEP integer_list",
 /*  68 */ "db_options ::= db_options KEEP variable_list",
 /*  69 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  70 */ "db_options ::= db_options QUORUM NK_INTEGER",
 /*  71 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  72 */ "db_options ::= db_options TTL NK_INTEGER",
 /*  73 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  74 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  75 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  76 */ "db_options ::= db_options STREAM_MODE NK_INTEGER",
 /*  77 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  78 */ "alter_db_options ::= alter_db_option",
 /*  79 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  80 */ "alter_db_option ::= BLOCKS NK_INTEGER",
 /*  81 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  82 */ "alter_db_option ::= KEEP integer_list",
 /*  83 */ "alter_db_option ::= KEEP variable_list",
 /*  84 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  85 */ "alter_db_option ::= QUORUM NK_INTEGER",
 /*  86 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  87 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  88 */ "integer_list ::= NK_INTEGER",
 /*  89 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /*  90 */ "variable_list ::= NK_VARIABLE",
 /*  91 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /*  92 */ "retention_list ::= retention",
 /*  93 */ "retention_list ::= retention_list NK_COMMA retention",
 /*  94 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /*  95 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /*  96 */ "cmd ::= CREATE TABLE multi_create_clause",
 /*  97 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /*  98 */ "cmd ::= DROP TABLE multi_drop_clause",
 /*  99 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 100 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 101 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 102 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 103 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 104 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 105 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 106 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 107 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 108 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 109 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 110 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 111 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal",
 /* 112 */ "multi_create_clause ::= create_subtable_clause",
 /* 113 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 114 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP",
 /* 115 */ "multi_drop_clause ::= drop_table_clause",
 /* 116 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 117 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 118 */ "specific_tags_opt ::=",
 /* 119 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 120 */ "full_table_name ::= table_name",
 /* 121 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 122 */ "column_def_list ::= column_def",
 /* 123 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 124 */ "column_def ::= column_name type_name",
 /* 125 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 126 */ "type_name ::= BOOL",
 /* 127 */ "type_name ::= TINYINT",
 /* 128 */ "type_name ::= SMALLINT",
 /* 129 */ "type_name ::= INT",
 /* 130 */ "type_name ::= INTEGER",
 /* 131 */ "type_name ::= BIGINT",
 /* 132 */ "type_name ::= FLOAT",
 /* 133 */ "type_name ::= DOUBLE",
 /* 134 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 135 */ "type_name ::= TIMESTAMP",
 /* 136 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 137 */ "type_name ::= TINYINT UNSIGNED",
 /* 138 */ "type_name ::= SMALLINT UNSIGNED",
 /* 139 */ "type_name ::= INT UNSIGNED",
 /* 140 */ "type_name ::= BIGINT UNSIGNED",
 /* 141 */ "type_name ::= JSON",
 /* 142 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 143 */ "type_name ::= MEDIUMBLOB",
 /* 144 */ "type_name ::= BLOB",
 /* 145 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 146 */ "type_name ::= DECIMAL",
 /* 147 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 149 */ "tags_def_opt ::=",
 /* 150 */ "tags_def_opt ::= tags_def",
 /* 151 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 152 */ "table_options ::=",
 /* 153 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 154 */ "table_options ::= table_options KEEP integer_list",
 /* 155 */ "table_options ::= table_options KEEP variable_list",
 /* 156 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 157 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 158 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 159 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 160 */ "table_options ::= table_options DELAY NK_INTEGER",
 /* 161 */ "alter_table_options ::= alter_table_option",
 /* 162 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 163 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 164 */ "alter_table_option ::= KEEP integer_list",
 /* 165 */ "alter_table_option ::= KEEP variable_list",
 /* 166 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 167 */ "col_name_list ::= col_name",
 /* 168 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 169 */ "col_name ::= column_name",
 /* 170 */ "cmd ::= SHOW DNODES",
 /* 171 */ "cmd ::= SHOW USERS",
 /* 172 */ "cmd ::= SHOW DATABASES",
 /* 173 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 174 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 175 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 176 */ "cmd ::= SHOW MNODES",
 /* 177 */ "cmd ::= SHOW MODULES",
 /* 178 */ "cmd ::= SHOW QNODES",
 /* 179 */ "cmd ::= SHOW FUNCTIONS",
 /* 180 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 181 */ "cmd ::= SHOW STREAMS",
 /* 182 */ "cmd ::= SHOW ACCOUNTS",
 /* 183 */ "cmd ::= SHOW APPS",
 /* 184 */ "cmd ::= SHOW CONNECTIONS",
 /* 185 */ "cmd ::= SHOW LICENCE",
 /* 186 */ "cmd ::= SHOW GRANTS",
 /* 187 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 188 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 189 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 190 */ "cmd ::= SHOW QUERIES",
 /* 191 */ "cmd ::= SHOW SCORES",
 /* 192 */ "cmd ::= SHOW TOPICS",
 /* 193 */ "cmd ::= SHOW VARIABLES",
 /* 194 */ "cmd ::= SHOW BNODES",
 /* 195 */ "cmd ::= SHOW SNODES",
 /* 196 */ "db_name_cond_opt ::=",
 /* 197 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 198 */ "like_pattern_opt ::=",
 /* 199 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 200 */ "table_name_cond ::= table_name",
 /* 201 */ "from_db_opt ::=",
 /* 202 */ "from_db_opt ::= FROM db_name",
 /* 203 */ "func_name_list ::= func_name",
 /* 204 */ "func_name_list ::= func_name_list NK_COMMA col_name",
 /* 205 */ "func_name ::= function_name",
 /* 206 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 207 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 208 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 209 */ "index_options ::=",
 /* 210 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 211 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 212 */ "func_list ::= func",
 /* 213 */ "func_list ::= func_list NK_COMMA func",
 /* 214 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 215 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 216 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name",
 /* 217 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 218 */ "cmd ::= DESC full_table_name",
 /* 219 */ "cmd ::= DESCRIBE full_table_name",
 /* 220 */ "cmd ::= RESET QUERY CACHE",
 /* 221 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 222 */ "analyze_opt ::=",
 /* 223 */ "analyze_opt ::= ANALYZE",
 /* 224 */ "explain_options ::=",
 /* 225 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 226 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 227 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 228 */ "cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 229 */ "cmd ::= DROP FUNCTION function_name",
 /* 230 */ "agg_func_opt ::=",
 /* 231 */ "agg_func_opt ::= AGGREGATE",
 /* 232 */ "bufsize_opt ::=",
 /* 233 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 234 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 235 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 236 */ "into_opt ::=",
 /* 237 */ "into_opt ::= INTO full_table_name",
 /* 238 */ "stream_options ::=",
 /* 239 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 240 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 241 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 242 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 243 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 244 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 245 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 246 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 247 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 248 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 249 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 250 */ "cmd ::= query_expression",
 /* 251 */ "literal ::= NK_INTEGER",
 /* 252 */ "literal ::= NK_FLOAT",
 /* 253 */ "literal ::= NK_STRING",
 /* 254 */ "literal ::= NK_BOOL",
 /* 255 */ "literal ::= TIMESTAMP NK_STRING",
 /* 256 */ "literal ::= duration_literal",
 /* 257 */ "literal ::= NULL",
 /* 258 */ "literal ::= NK_QUESTION",
 /* 259 */ "duration_literal ::= NK_VARIABLE",
 /* 260 */ "signed ::= NK_INTEGER",
 /* 261 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 262 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 263 */ "signed ::= NK_FLOAT",
 /* 264 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 265 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 266 */ "signed_literal ::= signed",
 /* 267 */ "signed_literal ::= NK_STRING",
 /* 268 */ "signed_literal ::= NK_BOOL",
 /* 269 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 270 */ "signed_literal ::= duration_literal",
 /* 271 */ "signed_literal ::= NULL",
 /* 272 */ "literal_list ::= signed_literal",
 /* 273 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 274 */ "db_name ::= NK_ID",
 /* 275 */ "table_name ::= NK_ID",
 /* 276 */ "column_name ::= NK_ID",
 /* 277 */ "function_name ::= NK_ID",
 /* 278 */ "table_alias ::= NK_ID",
 /* 279 */ "column_alias ::= NK_ID",
 /* 280 */ "user_name ::= NK_ID",
 /* 281 */ "index_name ::= NK_ID",
 /* 282 */ "topic_name ::= NK_ID",
 /* 283 */ "stream_name ::= NK_ID",
 /* 284 */ "expression ::= literal",
 /* 285 */ "expression ::= pseudo_column",
 /* 286 */ "expression ::= column_reference",
 /* 287 */ "expression ::= function_expression",
 /* 288 */ "expression ::= subquery",
 /* 289 */ "expression ::= NK_LP expression NK_RP",
 /* 290 */ "expression ::= NK_PLUS expression",
 /* 291 */ "expression ::= NK_MINUS expression",
 /* 292 */ "expression ::= expression NK_PLUS expression",
 /* 293 */ "expression ::= expression NK_MINUS expression",
 /* 294 */ "expression ::= expression NK_STAR expression",
 /* 295 */ "expression ::= expression NK_SLASH expression",
 /* 296 */ "expression ::= expression NK_REM expression",
 /* 297 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 298 */ "expression_list ::= expression",
 /* 299 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 300 */ "column_reference ::= column_name",
 /* 301 */ "column_reference ::= table_name NK_DOT column_name",
 /* 302 */ "pseudo_column ::= ROWTS",
 /* 303 */ "pseudo_column ::= TBNAME",
 /* 304 */ "pseudo_column ::= QSTARTTS",
 /* 305 */ "pseudo_column ::= QENDTS",
 /* 306 */ "pseudo_column ::= WSTARTTS",
 /* 307 */ "pseudo_column ::= WENDTS",
 /* 308 */ "pseudo_column ::= WDURATION",
 /* 309 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 310 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 311 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 312 */ "function_expression ::= noarg_func NK_LP NK_RP",
 /* 313 */ "noarg_func ::= NOW",
 /* 314 */ "noarg_func ::= TODAY",
 /* 315 */ "star_func ::= COUNT",
 /* 316 */ "star_func ::= FIRST",
 /* 317 */ "star_func ::= LAST",
 /* 318 */ "star_func ::= LAST_ROW",
 /* 319 */ "star_func_para_list ::= NK_STAR",
 /* 320 */ "star_func_para_list ::= other_para_list",
 /* 321 */ "other_para_list ::= star_func_para",
 /* 322 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 323 */ "star_func_para ::= expression",
 /* 324 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 325 */ "predicate ::= expression compare_op expression",
 /* 326 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 327 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 328 */ "predicate ::= expression IS NULL",
 /* 329 */ "predicate ::= expression IS NOT NULL",
 /* 330 */ "predicate ::= expression in_op in_predicate_value",
 /* 331 */ "compare_op ::= NK_LT",
 /* 332 */ "compare_op ::= NK_GT",
 /* 333 */ "compare_op ::= NK_LE",
 /* 334 */ "compare_op ::= NK_GE",
 /* 335 */ "compare_op ::= NK_NE",
 /* 336 */ "compare_op ::= NK_EQ",
 /* 337 */ "compare_op ::= LIKE",
 /* 338 */ "compare_op ::= NOT LIKE",
 /* 339 */ "compare_op ::= MATCH",
 /* 340 */ "compare_op ::= NMATCH",
 /* 341 */ "compare_op ::= CONTAINS",
 /* 342 */ "in_op ::= IN",
 /* 343 */ "in_op ::= NOT IN",
 /* 344 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 345 */ "boolean_value_expression ::= boolean_primary",
 /* 346 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 347 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 348 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 349 */ "boolean_primary ::= predicate",
 /* 350 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 351 */ "common_expression ::= expression",
 /* 352 */ "common_expression ::= boolean_value_expression",
 /* 353 */ "from_clause ::= FROM table_reference_list",
 /* 354 */ "table_reference_list ::= table_reference",
 /* 355 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 356 */ "table_reference ::= table_primary",
 /* 357 */ "table_reference ::= joined_table",
 /* 358 */ "table_primary ::= table_name alias_opt",
 /* 359 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 360 */ "table_primary ::= subquery alias_opt",
 /* 361 */ "table_primary ::= parenthesized_joined_table",
 /* 362 */ "alias_opt ::=",
 /* 363 */ "alias_opt ::= table_alias",
 /* 364 */ "alias_opt ::= AS table_alias",
 /* 365 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 366 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 367 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 368 */ "join_type ::=",
 /* 369 */ "join_type ::= INNER",
 /* 370 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 371 */ "set_quantifier_opt ::=",
 /* 372 */ "set_quantifier_opt ::= DISTINCT",
 /* 373 */ "set_quantifier_opt ::= ALL",
 /* 374 */ "select_list ::= NK_STAR",
 /* 375 */ "select_list ::= select_sublist",
 /* 376 */ "select_sublist ::= select_item",
 /* 377 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 378 */ "select_item ::= common_expression",
 /* 379 */ "select_item ::= common_expression column_alias",
 /* 380 */ "select_item ::= common_expression AS column_alias",
 /* 381 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 382 */ "where_clause_opt ::=",
 /* 383 */ "where_clause_opt ::= WHERE search_condition",
 /* 384 */ "partition_by_clause_opt ::=",
 /* 385 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 386 */ "twindow_clause_opt ::=",
 /* 387 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 388 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 389 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 390 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 391 */ "sliding_opt ::=",
 /* 392 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 393 */ "fill_opt ::=",
 /* 394 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 395 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 396 */ "fill_mode ::= NONE",
 /* 397 */ "fill_mode ::= PREV",
 /* 398 */ "fill_mode ::= NULL",
 /* 399 */ "fill_mode ::= LINEAR",
 /* 400 */ "fill_mode ::= NEXT",
 /* 401 */ "group_by_clause_opt ::=",
 /* 402 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 403 */ "group_by_list ::= expression",
 /* 404 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 405 */ "having_clause_opt ::=",
 /* 406 */ "having_clause_opt ::= HAVING search_condition",
 /* 407 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 408 */ "query_expression_body ::= query_primary",
 /* 409 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 410 */ "query_primary ::= query_specification",
 /* 411 */ "order_by_clause_opt ::=",
 /* 412 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 413 */ "slimit_clause_opt ::=",
 /* 414 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 415 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 416 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 417 */ "limit_clause_opt ::=",
 /* 418 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 419 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 420 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 421 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 422 */ "search_condition ::= common_expression",
 /* 423 */ "sort_specification_list ::= sort_specification",
 /* 424 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 425 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 426 */ "ordering_specification_opt ::=",
 /* 427 */ "ordering_specification_opt ::= ASC",
 /* 428 */ "ordering_specification_opt ::= DESC",
 /* 429 */ "null_ordering_opt ::=",
 /* 430 */ "null_ordering_opt ::= NULLS FIRST",
 /* 431 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 219: /* cmd */
    case 222: /* literal */
    case 229: /* db_options */
    case 231: /* alter_db_options */
    case 236: /* retention */
    case 237: /* full_table_name */
    case 240: /* table_options */
    case 244: /* alter_table_clause */
    case 245: /* alter_table_options */
    case 248: /* create_subtable_clause */
    case 251: /* drop_table_clause */
    case 254: /* column_def */
    case 257: /* col_name */
    case 258: /* db_name_cond_opt */
    case 259: /* like_pattern_opt */
    case 260: /* table_name_cond */
    case 261: /* from_db_opt */
    case 262: /* func_name */
    case 265: /* index_options */
    case 267: /* duration_literal */
    case 268: /* sliding_opt */
    case 269: /* func */
    case 272: /* query_expression */
    case 274: /* explain_options */
    case 278: /* stream_options */
    case 279: /* into_opt */
    case 281: /* signed */
    case 282: /* signed_literal */
    case 285: /* expression */
    case 286: /* pseudo_column */
    case 287: /* column_reference */
    case 288: /* function_expression */
    case 289: /* subquery */
    case 294: /* star_func_para */
    case 295: /* predicate */
    case 298: /* in_predicate_value */
    case 299: /* boolean_value_expression */
    case 300: /* boolean_primary */
    case 301: /* common_expression */
    case 302: /* from_clause */
    case 303: /* table_reference_list */
    case 304: /* table_reference */
    case 305: /* table_primary */
    case 306: /* joined_table */
    case 308: /* parenthesized_joined_table */
    case 310: /* search_condition */
    case 311: /* query_specification */
    case 314: /* where_clause_opt */
    case 316: /* twindow_clause_opt */
    case 318: /* having_clause_opt */
    case 320: /* select_item */
    case 321: /* fill_opt */
    case 324: /* query_expression_body */
    case 326: /* slimit_clause_opt */
    case 327: /* limit_clause_opt */
    case 328: /* query_primary */
    case 330: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy452)); 
}
      break;
    case 220: /* account_options */
    case 221: /* alter_account_options */
    case 223: /* alter_account_option */
    case 276: /* bufsize_opt */
{
 
}
      break;
    case 224: /* user_name */
    case 225: /* dnode_endpoint */
    case 226: /* dnode_host_name */
    case 228: /* db_name */
    case 246: /* column_name */
    case 253: /* table_name */
    case 263: /* function_name */
    case 264: /* index_name */
    case 271: /* topic_name */
    case 277: /* stream_name */
    case 283: /* table_alias */
    case 284: /* column_alias */
    case 290: /* star_func */
    case 292: /* noarg_func */
    case 307: /* alias_opt */
{
 
}
      break;
    case 227: /* not_exists_opt */
    case 230: /* exists_opt */
    case 273: /* analyze_opt */
    case 275: /* agg_func_opt */
    case 312: /* set_quantifier_opt */
{
 
}
      break;
    case 232: /* integer_list */
    case 233: /* variable_list */
    case 234: /* retention_list */
    case 238: /* column_def_list */
    case 239: /* tags_def_opt */
    case 241: /* multi_create_clause */
    case 242: /* tags_def */
    case 243: /* multi_drop_clause */
    case 249: /* specific_tags_opt */
    case 250: /* literal_list */
    case 252: /* col_name_list */
    case 255: /* func_name_list */
    case 266: /* func_list */
    case 270: /* expression_list */
    case 280: /* dnode_list */
    case 291: /* star_func_para_list */
    case 293: /* other_para_list */
    case 313: /* select_list */
    case 315: /* partition_by_clause_opt */
    case 317: /* group_by_clause_opt */
    case 319: /* select_sublist */
    case 323: /* group_by_list */
    case 325: /* order_by_clause_opt */
    case 329: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy478)); 
}
      break;
    case 235: /* alter_db_option */
    case 256: /* alter_table_option */
{
 
}
      break;
    case 247: /* type_name */
{
 
}
      break;
    case 296: /* compare_op */
    case 297: /* in_op */
{
 
}
      break;
    case 309: /* join_type */
{
 
}
      break;
    case 322: /* fill_mode */
{
 
}
      break;
    case 331: /* ordering_specification_opt */
{
 
}
      break;
    case 332: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  219,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  219,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  220,    0 }, /* (2) account_options ::= */
  {  220,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  220,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  220,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  220,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  220,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  220,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  220,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  220,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  220,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  221,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  221,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  223,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  223,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  223,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  223,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  223,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  223,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  223,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  223,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  223,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  223,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  219,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  219,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  219,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  219,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  219,   -3 }, /* (28) cmd ::= CREATE DNODE dnode_endpoint */
  {  219,   -5 }, /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  219,   -3 }, /* (30) cmd ::= DROP DNODE NK_INTEGER */
  {  219,   -3 }, /* (31) cmd ::= DROP DNODE dnode_endpoint */
  {  219,   -4 }, /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  219,   -5 }, /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  219,   -4 }, /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
  {  219,   -5 }, /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  225,   -1 }, /* (36) dnode_endpoint ::= NK_STRING */
  {  226,   -1 }, /* (37) dnode_host_name ::= NK_ID */
  {  226,   -1 }, /* (38) dnode_host_name ::= NK_IPTOKEN */
  {  219,   -3 }, /* (39) cmd ::= ALTER LOCAL NK_STRING */
  {  219,   -4 }, /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  219,   -5 }, /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  219,   -5 }, /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  219,   -5 }, /* (43) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  219,   -5 }, /* (44) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  219,   -5 }, /* (45) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  219,   -5 }, /* (46) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  219,   -5 }, /* (47) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  219,   -5 }, /* (48) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  219,   -5 }, /* (49) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  219,   -4 }, /* (50) cmd ::= DROP DATABASE exists_opt db_name */
  {  219,   -2 }, /* (51) cmd ::= USE db_name */
  {  219,   -4 }, /* (52) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  227,   -3 }, /* (53) not_exists_opt ::= IF NOT EXISTS */
  {  227,    0 }, /* (54) not_exists_opt ::= */
  {  230,   -2 }, /* (55) exists_opt ::= IF EXISTS */
  {  230,    0 }, /* (56) exists_opt ::= */
  {  229,    0 }, /* (57) db_options ::= */
  {  229,   -3 }, /* (58) db_options ::= db_options BLOCKS NK_INTEGER */
  {  229,   -3 }, /* (59) db_options ::= db_options CACHE NK_INTEGER */
  {  229,   -3 }, /* (60) db_options ::= db_options CACHELAST NK_INTEGER */
  {  229,   -3 }, /* (61) db_options ::= db_options COMP NK_INTEGER */
  {  229,   -3 }, /* (62) db_options ::= db_options DAYS NK_INTEGER */
  {  229,   -3 }, /* (63) db_options ::= db_options DAYS NK_VARIABLE */
  {  229,   -3 }, /* (64) db_options ::= db_options FSYNC NK_INTEGER */
  {  229,   -3 }, /* (65) db_options ::= db_options MAXROWS NK_INTEGER */
  {  229,   -3 }, /* (66) db_options ::= db_options MINROWS NK_INTEGER */
  {  229,   -3 }, /* (67) db_options ::= db_options KEEP integer_list */
  {  229,   -3 }, /* (68) db_options ::= db_options KEEP variable_list */
  {  229,   -3 }, /* (69) db_options ::= db_options PRECISION NK_STRING */
  {  229,   -3 }, /* (70) db_options ::= db_options QUORUM NK_INTEGER */
  {  229,   -3 }, /* (71) db_options ::= db_options REPLICA NK_INTEGER */
  {  229,   -3 }, /* (72) db_options ::= db_options TTL NK_INTEGER */
  {  229,   -3 }, /* (73) db_options ::= db_options WAL NK_INTEGER */
  {  229,   -3 }, /* (74) db_options ::= db_options VGROUPS NK_INTEGER */
  {  229,   -3 }, /* (75) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  229,   -3 }, /* (76) db_options ::= db_options STREAM_MODE NK_INTEGER */
  {  229,   -3 }, /* (77) db_options ::= db_options RETENTIONS retention_list */
  {  231,   -1 }, /* (78) alter_db_options ::= alter_db_option */
  {  231,   -2 }, /* (79) alter_db_options ::= alter_db_options alter_db_option */
  {  235,   -2 }, /* (80) alter_db_option ::= BLOCKS NK_INTEGER */
  {  235,   -2 }, /* (81) alter_db_option ::= FSYNC NK_INTEGER */
  {  235,   -2 }, /* (82) alter_db_option ::= KEEP integer_list */
  {  235,   -2 }, /* (83) alter_db_option ::= KEEP variable_list */
  {  235,   -2 }, /* (84) alter_db_option ::= WAL NK_INTEGER */
  {  235,   -2 }, /* (85) alter_db_option ::= QUORUM NK_INTEGER */
  {  235,   -2 }, /* (86) alter_db_option ::= CACHELAST NK_INTEGER */
  {  235,   -2 }, /* (87) alter_db_option ::= REPLICA NK_INTEGER */
  {  232,   -1 }, /* (88) integer_list ::= NK_INTEGER */
  {  232,   -3 }, /* (89) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  233,   -1 }, /* (90) variable_list ::= NK_VARIABLE */
  {  233,   -3 }, /* (91) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  234,   -1 }, /* (92) retention_list ::= retention */
  {  234,   -3 }, /* (93) retention_list ::= retention_list NK_COMMA retention */
  {  236,   -3 }, /* (94) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  219,   -9 }, /* (95) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  219,   -3 }, /* (96) cmd ::= CREATE TABLE multi_create_clause */
  {  219,   -9 }, /* (97) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  219,   -3 }, /* (98) cmd ::= DROP TABLE multi_drop_clause */
  {  219,   -4 }, /* (99) cmd ::= DROP STABLE exists_opt full_table_name */
  {  219,   -3 }, /* (100) cmd ::= ALTER TABLE alter_table_clause */
  {  219,   -3 }, /* (101) cmd ::= ALTER STABLE alter_table_clause */
  {  244,   -2 }, /* (102) alter_table_clause ::= full_table_name alter_table_options */
  {  244,   -5 }, /* (103) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  244,   -4 }, /* (104) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  244,   -5 }, /* (105) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  244,   -5 }, /* (106) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  244,   -5 }, /* (107) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  244,   -4 }, /* (108) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  244,   -5 }, /* (109) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  244,   -5 }, /* (110) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  244,   -6 }, /* (111) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
  {  241,   -1 }, /* (112) multi_create_clause ::= create_subtable_clause */
  {  241,   -2 }, /* (113) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  248,   -9 }, /* (114) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
  {  243,   -1 }, /* (115) multi_drop_clause ::= drop_table_clause */
  {  243,   -2 }, /* (116) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  251,   -2 }, /* (117) drop_table_clause ::= exists_opt full_table_name */
  {  249,    0 }, /* (118) specific_tags_opt ::= */
  {  249,   -3 }, /* (119) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  237,   -1 }, /* (120) full_table_name ::= table_name */
  {  237,   -3 }, /* (121) full_table_name ::= db_name NK_DOT table_name */
  {  238,   -1 }, /* (122) column_def_list ::= column_def */
  {  238,   -3 }, /* (123) column_def_list ::= column_def_list NK_COMMA column_def */
  {  254,   -2 }, /* (124) column_def ::= column_name type_name */
  {  254,   -4 }, /* (125) column_def ::= column_name type_name COMMENT NK_STRING */
  {  247,   -1 }, /* (126) type_name ::= BOOL */
  {  247,   -1 }, /* (127) type_name ::= TINYINT */
  {  247,   -1 }, /* (128) type_name ::= SMALLINT */
  {  247,   -1 }, /* (129) type_name ::= INT */
  {  247,   -1 }, /* (130) type_name ::= INTEGER */
  {  247,   -1 }, /* (131) type_name ::= BIGINT */
  {  247,   -1 }, /* (132) type_name ::= FLOAT */
  {  247,   -1 }, /* (133) type_name ::= DOUBLE */
  {  247,   -4 }, /* (134) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  247,   -1 }, /* (135) type_name ::= TIMESTAMP */
  {  247,   -4 }, /* (136) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  247,   -2 }, /* (137) type_name ::= TINYINT UNSIGNED */
  {  247,   -2 }, /* (138) type_name ::= SMALLINT UNSIGNED */
  {  247,   -2 }, /* (139) type_name ::= INT UNSIGNED */
  {  247,   -2 }, /* (140) type_name ::= BIGINT UNSIGNED */
  {  247,   -1 }, /* (141) type_name ::= JSON */
  {  247,   -4 }, /* (142) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  247,   -1 }, /* (143) type_name ::= MEDIUMBLOB */
  {  247,   -1 }, /* (144) type_name ::= BLOB */
  {  247,   -4 }, /* (145) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  247,   -1 }, /* (146) type_name ::= DECIMAL */
  {  247,   -4 }, /* (147) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  247,   -6 }, /* (148) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  239,    0 }, /* (149) tags_def_opt ::= */
  {  239,   -1 }, /* (150) tags_def_opt ::= tags_def */
  {  242,   -4 }, /* (151) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  240,    0 }, /* (152) table_options ::= */
  {  240,   -3 }, /* (153) table_options ::= table_options COMMENT NK_STRING */
  {  240,   -3 }, /* (154) table_options ::= table_options KEEP integer_list */
  {  240,   -3 }, /* (155) table_options ::= table_options KEEP variable_list */
  {  240,   -3 }, /* (156) table_options ::= table_options TTL NK_INTEGER */
  {  240,   -5 }, /* (157) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  240,   -5 }, /* (158) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  240,   -3 }, /* (159) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  240,   -3 }, /* (160) table_options ::= table_options DELAY NK_INTEGER */
  {  245,   -1 }, /* (161) alter_table_options ::= alter_table_option */
  {  245,   -2 }, /* (162) alter_table_options ::= alter_table_options alter_table_option */
  {  256,   -2 }, /* (163) alter_table_option ::= COMMENT NK_STRING */
  {  256,   -2 }, /* (164) alter_table_option ::= KEEP integer_list */
  {  256,   -2 }, /* (165) alter_table_option ::= KEEP variable_list */
  {  256,   -2 }, /* (166) alter_table_option ::= TTL NK_INTEGER */
  {  252,   -1 }, /* (167) col_name_list ::= col_name */
  {  252,   -3 }, /* (168) col_name_list ::= col_name_list NK_COMMA col_name */
  {  257,   -1 }, /* (169) col_name ::= column_name */
  {  219,   -2 }, /* (170) cmd ::= SHOW DNODES */
  {  219,   -2 }, /* (171) cmd ::= SHOW USERS */
  {  219,   -2 }, /* (172) cmd ::= SHOW DATABASES */
  {  219,   -4 }, /* (173) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  219,   -4 }, /* (174) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  219,   -3 }, /* (175) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  219,   -2 }, /* (176) cmd ::= SHOW MNODES */
  {  219,   -2 }, /* (177) cmd ::= SHOW MODULES */
  {  219,   -2 }, /* (178) cmd ::= SHOW QNODES */
  {  219,   -2 }, /* (179) cmd ::= SHOW FUNCTIONS */
  {  219,   -5 }, /* (180) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  219,   -2 }, /* (181) cmd ::= SHOW STREAMS */
  {  219,   -2 }, /* (182) cmd ::= SHOW ACCOUNTS */
  {  219,   -2 }, /* (183) cmd ::= SHOW APPS */
  {  219,   -2 }, /* (184) cmd ::= SHOW CONNECTIONS */
  {  219,   -2 }, /* (185) cmd ::= SHOW LICENCE */
  {  219,   -2 }, /* (186) cmd ::= SHOW GRANTS */
  {  219,   -4 }, /* (187) cmd ::= SHOW CREATE DATABASE db_name */
  {  219,   -4 }, /* (188) cmd ::= SHOW CREATE TABLE full_table_name */
  {  219,   -4 }, /* (189) cmd ::= SHOW CREATE STABLE full_table_name */
  {  219,   -2 }, /* (190) cmd ::= SHOW QUERIES */
  {  219,   -2 }, /* (191) cmd ::= SHOW SCORES */
  {  219,   -2 }, /* (192) cmd ::= SHOW TOPICS */
  {  219,   -2 }, /* (193) cmd ::= SHOW VARIABLES */
  {  219,   -2 }, /* (194) cmd ::= SHOW BNODES */
  {  219,   -2 }, /* (195) cmd ::= SHOW SNODES */
  {  258,    0 }, /* (196) db_name_cond_opt ::= */
  {  258,   -2 }, /* (197) db_name_cond_opt ::= db_name NK_DOT */
  {  259,    0 }, /* (198) like_pattern_opt ::= */
  {  259,   -2 }, /* (199) like_pattern_opt ::= LIKE NK_STRING */
  {  260,   -1 }, /* (200) table_name_cond ::= table_name */
  {  261,    0 }, /* (201) from_db_opt ::= */
  {  261,   -2 }, /* (202) from_db_opt ::= FROM db_name */
  {  255,   -1 }, /* (203) func_name_list ::= func_name */
  {  255,   -3 }, /* (204) func_name_list ::= func_name_list NK_COMMA col_name */
  {  262,   -1 }, /* (205) func_name ::= function_name */
  {  219,   -8 }, /* (206) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  219,  -10 }, /* (207) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  219,   -6 }, /* (208) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  265,    0 }, /* (209) index_options ::= */
  {  265,   -9 }, /* (210) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  265,  -11 }, /* (211) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  266,   -1 }, /* (212) func_list ::= func */
  {  266,   -3 }, /* (213) func_list ::= func_list NK_COMMA func */
  {  269,   -4 }, /* (214) func ::= function_name NK_LP expression_list NK_RP */
  {  219,   -6 }, /* (215) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  219,   -6 }, /* (216) cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
  {  219,   -4 }, /* (217) cmd ::= DROP TOPIC exists_opt topic_name */
  {  219,   -2 }, /* (218) cmd ::= DESC full_table_name */
  {  219,   -2 }, /* (219) cmd ::= DESCRIBE full_table_name */
  {  219,   -3 }, /* (220) cmd ::= RESET QUERY CACHE */
  {  219,   -4 }, /* (221) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  273,    0 }, /* (222) analyze_opt ::= */
  {  273,   -1 }, /* (223) analyze_opt ::= ANALYZE */
  {  274,    0 }, /* (224) explain_options ::= */
  {  274,   -3 }, /* (225) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  274,   -3 }, /* (226) explain_options ::= explain_options RATIO NK_FLOAT */
  {  219,   -6 }, /* (227) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  219,   -9 }, /* (228) cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  219,   -3 }, /* (229) cmd ::= DROP FUNCTION function_name */
  {  275,    0 }, /* (230) agg_func_opt ::= */
  {  275,   -1 }, /* (231) agg_func_opt ::= AGGREGATE */
  {  276,    0 }, /* (232) bufsize_opt ::= */
  {  276,   -2 }, /* (233) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  219,   -8 }, /* (234) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  219,   -4 }, /* (235) cmd ::= DROP STREAM exists_opt stream_name */
  {  279,    0 }, /* (236) into_opt ::= */
  {  279,   -2 }, /* (237) into_opt ::= INTO full_table_name */
  {  278,    0 }, /* (238) stream_options ::= */
  {  278,   -3 }, /* (239) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  278,   -3 }, /* (240) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  278,   -3 }, /* (241) stream_options ::= stream_options WATERMARK duration_literal */
  {  219,   -3 }, /* (242) cmd ::= KILL CONNECTION NK_INTEGER */
  {  219,   -3 }, /* (243) cmd ::= KILL QUERY NK_INTEGER */
  {  219,   -4 }, /* (244) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  219,   -4 }, /* (245) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  219,   -3 }, /* (246) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  280,   -2 }, /* (247) dnode_list ::= DNODE NK_INTEGER */
  {  280,   -3 }, /* (248) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  219,   -3 }, /* (249) cmd ::= SYNCDB db_name REPLICA */
  {  219,   -1 }, /* (250) cmd ::= query_expression */
  {  222,   -1 }, /* (251) literal ::= NK_INTEGER */
  {  222,   -1 }, /* (252) literal ::= NK_FLOAT */
  {  222,   -1 }, /* (253) literal ::= NK_STRING */
  {  222,   -1 }, /* (254) literal ::= NK_BOOL */
  {  222,   -2 }, /* (255) literal ::= TIMESTAMP NK_STRING */
  {  222,   -1 }, /* (256) literal ::= duration_literal */
  {  222,   -1 }, /* (257) literal ::= NULL */
  {  222,   -1 }, /* (258) literal ::= NK_QUESTION */
  {  267,   -1 }, /* (259) duration_literal ::= NK_VARIABLE */
  {  281,   -1 }, /* (260) signed ::= NK_INTEGER */
  {  281,   -2 }, /* (261) signed ::= NK_PLUS NK_INTEGER */
  {  281,   -2 }, /* (262) signed ::= NK_MINUS NK_INTEGER */
  {  281,   -1 }, /* (263) signed ::= NK_FLOAT */
  {  281,   -2 }, /* (264) signed ::= NK_PLUS NK_FLOAT */
  {  281,   -2 }, /* (265) signed ::= NK_MINUS NK_FLOAT */
  {  282,   -1 }, /* (266) signed_literal ::= signed */
  {  282,   -1 }, /* (267) signed_literal ::= NK_STRING */
  {  282,   -1 }, /* (268) signed_literal ::= NK_BOOL */
  {  282,   -2 }, /* (269) signed_literal ::= TIMESTAMP NK_STRING */
  {  282,   -1 }, /* (270) signed_literal ::= duration_literal */
  {  282,   -1 }, /* (271) signed_literal ::= NULL */
  {  250,   -1 }, /* (272) literal_list ::= signed_literal */
  {  250,   -3 }, /* (273) literal_list ::= literal_list NK_COMMA signed_literal */
  {  228,   -1 }, /* (274) db_name ::= NK_ID */
  {  253,   -1 }, /* (275) table_name ::= NK_ID */
  {  246,   -1 }, /* (276) column_name ::= NK_ID */
  {  263,   -1 }, /* (277) function_name ::= NK_ID */
  {  283,   -1 }, /* (278) table_alias ::= NK_ID */
  {  284,   -1 }, /* (279) column_alias ::= NK_ID */
  {  224,   -1 }, /* (280) user_name ::= NK_ID */
  {  264,   -1 }, /* (281) index_name ::= NK_ID */
  {  271,   -1 }, /* (282) topic_name ::= NK_ID */
  {  277,   -1 }, /* (283) stream_name ::= NK_ID */
  {  285,   -1 }, /* (284) expression ::= literal */
  {  285,   -1 }, /* (285) expression ::= pseudo_column */
  {  285,   -1 }, /* (286) expression ::= column_reference */
  {  285,   -1 }, /* (287) expression ::= function_expression */
  {  285,   -1 }, /* (288) expression ::= subquery */
  {  285,   -3 }, /* (289) expression ::= NK_LP expression NK_RP */
  {  285,   -2 }, /* (290) expression ::= NK_PLUS expression */
  {  285,   -2 }, /* (291) expression ::= NK_MINUS expression */
  {  285,   -3 }, /* (292) expression ::= expression NK_PLUS expression */
  {  285,   -3 }, /* (293) expression ::= expression NK_MINUS expression */
  {  285,   -3 }, /* (294) expression ::= expression NK_STAR expression */
  {  285,   -3 }, /* (295) expression ::= expression NK_SLASH expression */
  {  285,   -3 }, /* (296) expression ::= expression NK_REM expression */
  {  285,   -3 }, /* (297) expression ::= column_reference NK_ARROW NK_STRING */
  {  270,   -1 }, /* (298) expression_list ::= expression */
  {  270,   -3 }, /* (299) expression_list ::= expression_list NK_COMMA expression */
  {  287,   -1 }, /* (300) column_reference ::= column_name */
  {  287,   -3 }, /* (301) column_reference ::= table_name NK_DOT column_name */
  {  286,   -1 }, /* (302) pseudo_column ::= ROWTS */
  {  286,   -1 }, /* (303) pseudo_column ::= TBNAME */
  {  286,   -1 }, /* (304) pseudo_column ::= QSTARTTS */
  {  286,   -1 }, /* (305) pseudo_column ::= QENDTS */
  {  286,   -1 }, /* (306) pseudo_column ::= WSTARTTS */
  {  286,   -1 }, /* (307) pseudo_column ::= WENDTS */
  {  286,   -1 }, /* (308) pseudo_column ::= WDURATION */
  {  288,   -4 }, /* (309) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  288,   -4 }, /* (310) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  288,   -6 }, /* (311) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  288,   -3 }, /* (312) function_expression ::= noarg_func NK_LP NK_RP */
  {  292,   -1 }, /* (313) noarg_func ::= NOW */
  {  292,   -1 }, /* (314) noarg_func ::= TODAY */
  {  290,   -1 }, /* (315) star_func ::= COUNT */
  {  290,   -1 }, /* (316) star_func ::= FIRST */
  {  290,   -1 }, /* (317) star_func ::= LAST */
  {  290,   -1 }, /* (318) star_func ::= LAST_ROW */
  {  291,   -1 }, /* (319) star_func_para_list ::= NK_STAR */
  {  291,   -1 }, /* (320) star_func_para_list ::= other_para_list */
  {  293,   -1 }, /* (321) other_para_list ::= star_func_para */
  {  293,   -3 }, /* (322) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  294,   -1 }, /* (323) star_func_para ::= expression */
  {  294,   -3 }, /* (324) star_func_para ::= table_name NK_DOT NK_STAR */
  {  295,   -3 }, /* (325) predicate ::= expression compare_op expression */
  {  295,   -5 }, /* (326) predicate ::= expression BETWEEN expression AND expression */
  {  295,   -6 }, /* (327) predicate ::= expression NOT BETWEEN expression AND expression */
  {  295,   -3 }, /* (328) predicate ::= expression IS NULL */
  {  295,   -4 }, /* (329) predicate ::= expression IS NOT NULL */
  {  295,   -3 }, /* (330) predicate ::= expression in_op in_predicate_value */
  {  296,   -1 }, /* (331) compare_op ::= NK_LT */
  {  296,   -1 }, /* (332) compare_op ::= NK_GT */
  {  296,   -1 }, /* (333) compare_op ::= NK_LE */
  {  296,   -1 }, /* (334) compare_op ::= NK_GE */
  {  296,   -1 }, /* (335) compare_op ::= NK_NE */
  {  296,   -1 }, /* (336) compare_op ::= NK_EQ */
  {  296,   -1 }, /* (337) compare_op ::= LIKE */
  {  296,   -2 }, /* (338) compare_op ::= NOT LIKE */
  {  296,   -1 }, /* (339) compare_op ::= MATCH */
  {  296,   -1 }, /* (340) compare_op ::= NMATCH */
  {  296,   -1 }, /* (341) compare_op ::= CONTAINS */
  {  297,   -1 }, /* (342) in_op ::= IN */
  {  297,   -2 }, /* (343) in_op ::= NOT IN */
  {  298,   -3 }, /* (344) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  299,   -1 }, /* (345) boolean_value_expression ::= boolean_primary */
  {  299,   -2 }, /* (346) boolean_value_expression ::= NOT boolean_primary */
  {  299,   -3 }, /* (347) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  299,   -3 }, /* (348) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  300,   -1 }, /* (349) boolean_primary ::= predicate */
  {  300,   -3 }, /* (350) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  301,   -1 }, /* (351) common_expression ::= expression */
  {  301,   -1 }, /* (352) common_expression ::= boolean_value_expression */
  {  302,   -2 }, /* (353) from_clause ::= FROM table_reference_list */
  {  303,   -1 }, /* (354) table_reference_list ::= table_reference */
  {  303,   -3 }, /* (355) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  304,   -1 }, /* (356) table_reference ::= table_primary */
  {  304,   -1 }, /* (357) table_reference ::= joined_table */
  {  305,   -2 }, /* (358) table_primary ::= table_name alias_opt */
  {  305,   -4 }, /* (359) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  305,   -2 }, /* (360) table_primary ::= subquery alias_opt */
  {  305,   -1 }, /* (361) table_primary ::= parenthesized_joined_table */
  {  307,    0 }, /* (362) alias_opt ::= */
  {  307,   -1 }, /* (363) alias_opt ::= table_alias */
  {  307,   -2 }, /* (364) alias_opt ::= AS table_alias */
  {  308,   -3 }, /* (365) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  308,   -3 }, /* (366) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  306,   -6 }, /* (367) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  309,    0 }, /* (368) join_type ::= */
  {  309,   -1 }, /* (369) join_type ::= INNER */
  {  311,   -9 }, /* (370) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  312,    0 }, /* (371) set_quantifier_opt ::= */
  {  312,   -1 }, /* (372) set_quantifier_opt ::= DISTINCT */
  {  312,   -1 }, /* (373) set_quantifier_opt ::= ALL */
  {  313,   -1 }, /* (374) select_list ::= NK_STAR */
  {  313,   -1 }, /* (375) select_list ::= select_sublist */
  {  319,   -1 }, /* (376) select_sublist ::= select_item */
  {  319,   -3 }, /* (377) select_sublist ::= select_sublist NK_COMMA select_item */
  {  320,   -1 }, /* (378) select_item ::= common_expression */
  {  320,   -2 }, /* (379) select_item ::= common_expression column_alias */
  {  320,   -3 }, /* (380) select_item ::= common_expression AS column_alias */
  {  320,   -3 }, /* (381) select_item ::= table_name NK_DOT NK_STAR */
  {  314,    0 }, /* (382) where_clause_opt ::= */
  {  314,   -2 }, /* (383) where_clause_opt ::= WHERE search_condition */
  {  315,    0 }, /* (384) partition_by_clause_opt ::= */
  {  315,   -3 }, /* (385) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  316,    0 }, /* (386) twindow_clause_opt ::= */
  {  316,   -6 }, /* (387) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  316,   -4 }, /* (388) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  316,   -6 }, /* (389) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  316,   -8 }, /* (390) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  268,    0 }, /* (391) sliding_opt ::= */
  {  268,   -4 }, /* (392) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  321,    0 }, /* (393) fill_opt ::= */
  {  321,   -4 }, /* (394) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  321,   -6 }, /* (395) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  322,   -1 }, /* (396) fill_mode ::= NONE */
  {  322,   -1 }, /* (397) fill_mode ::= PREV */
  {  322,   -1 }, /* (398) fill_mode ::= NULL */
  {  322,   -1 }, /* (399) fill_mode ::= LINEAR */
  {  322,   -1 }, /* (400) fill_mode ::= NEXT */
  {  317,    0 }, /* (401) group_by_clause_opt ::= */
  {  317,   -3 }, /* (402) group_by_clause_opt ::= GROUP BY group_by_list */
  {  323,   -1 }, /* (403) group_by_list ::= expression */
  {  323,   -3 }, /* (404) group_by_list ::= group_by_list NK_COMMA expression */
  {  318,    0 }, /* (405) having_clause_opt ::= */
  {  318,   -2 }, /* (406) having_clause_opt ::= HAVING search_condition */
  {  272,   -4 }, /* (407) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  324,   -1 }, /* (408) query_expression_body ::= query_primary */
  {  324,   -4 }, /* (409) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  328,   -1 }, /* (410) query_primary ::= query_specification */
  {  325,    0 }, /* (411) order_by_clause_opt ::= */
  {  325,   -3 }, /* (412) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  326,    0 }, /* (413) slimit_clause_opt ::= */
  {  326,   -2 }, /* (414) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  326,   -4 }, /* (415) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  326,   -4 }, /* (416) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  327,    0 }, /* (417) limit_clause_opt ::= */
  {  327,   -2 }, /* (418) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  327,   -4 }, /* (419) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  327,   -4 }, /* (420) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  289,   -3 }, /* (421) subquery ::= NK_LP query_expression NK_RP */
  {  310,   -1 }, /* (422) search_condition ::= common_expression */
  {  329,   -1 }, /* (423) sort_specification_list ::= sort_specification */
  {  329,   -3 }, /* (424) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  330,   -3 }, /* (425) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  331,    0 }, /* (426) ordering_specification_opt ::= */
  {  331,   -1 }, /* (427) ordering_specification_opt ::= ASC */
  {  331,   -1 }, /* (428) ordering_specification_opt ::= DESC */
  {  332,    0 }, /* (429) null_ordering_opt ::= */
  {  332,   -2 }, /* (430) null_ordering_opt ::= NULLS FIRST */
  {  332,   -2 }, /* (431) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,220,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,221,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,220,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,222,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,223,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,221,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,223,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,222,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy479, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy479, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy479, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy479); }
        break;
      case 28: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy479, NULL); }
        break;
      case 29: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy479, &yymsp[0].minor.yy0); }
        break;
      case 30: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 31: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy479); }
        break;
      case 32: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 33: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 34: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 35: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 36: /* dnode_endpoint ::= NK_STRING */
      case 37: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==37);
      case 38: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==38);
      case 274: /* db_name ::= NK_ID */ yytestcase(yyruleno==274);
      case 275: /* table_name ::= NK_ID */ yytestcase(yyruleno==275);
      case 276: /* column_name ::= NK_ID */ yytestcase(yyruleno==276);
      case 277: /* function_name ::= NK_ID */ yytestcase(yyruleno==277);
      case 278: /* table_alias ::= NK_ID */ yytestcase(yyruleno==278);
      case 279: /* column_alias ::= NK_ID */ yytestcase(yyruleno==279);
      case 280: /* user_name ::= NK_ID */ yytestcase(yyruleno==280);
      case 281: /* index_name ::= NK_ID */ yytestcase(yyruleno==281);
      case 282: /* topic_name ::= NK_ID */ yytestcase(yyruleno==282);
      case 283: /* stream_name ::= NK_ID */ yytestcase(yyruleno==283);
      case 313: /* noarg_func ::= NOW */ yytestcase(yyruleno==313);
      case 314: /* noarg_func ::= TODAY */ yytestcase(yyruleno==314);
      case 315: /* star_func ::= COUNT */ yytestcase(yyruleno==315);
      case 316: /* star_func ::= FIRST */ yytestcase(yyruleno==316);
      case 317: /* star_func ::= LAST */ yytestcase(yyruleno==317);
      case 318: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==318);
{ yylhsminor.yy479 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy479 = yylhsminor.yy479;
        break;
      case 39: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 40: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 42: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 46: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy659, &yymsp[-1].minor.yy479, yymsp[0].minor.yy452); }
        break;
      case 50: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy659, &yymsp[0].minor.yy479); }
        break;
      case 51: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy479); }
        break;
      case 52: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy479, yymsp[0].minor.yy452); }
        break;
      case 53: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy659 = true; }
        break;
      case 54: /* not_exists_opt ::= */
      case 56: /* exists_opt ::= */ yytestcase(yyruleno==56);
      case 222: /* analyze_opt ::= */ yytestcase(yyruleno==222);
      case 230: /* agg_func_opt ::= */ yytestcase(yyruleno==230);
      case 371: /* set_quantifier_opt ::= */ yytestcase(yyruleno==371);
{ yymsp[1].minor.yy659 = false; }
        break;
      case 55: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy659 = true; }
        break;
      case 57: /* db_options ::= */
{ yymsp[1].minor.yy452 = createDatabaseOptions(pCxt); }
        break;
      case 58: /* db_options ::= db_options BLOCKS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy452)->pNumOfBlocks = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 59: /* db_options ::= db_options CACHE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy452)->pCacheBlockSize = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 60: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy452)->pCachelast = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 61: /* db_options ::= db_options COMP NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy452)->pCompressionLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 62: /* db_options ::= db_options DAYS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy452)->pDaysPerFile = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 63: /* db_options ::= db_options DAYS NK_VARIABLE */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy452)->pDaysPerFile = (SValueNode*)createDurationValueNode(pCxt, &yymsp[0].minor.yy0); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 64: /* db_options ::= db_options FSYNC NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy452)->pFsyncPeriod = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 65: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy452)->pMaxRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 66: /* db_options ::= db_options MINROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy452)->pMinRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 67: /* db_options ::= db_options KEEP integer_list */
      case 68: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==68);
{ ((SDatabaseOptions*)yymsp[-2].minor.yy452)->pKeep = yymsp[0].minor.yy478; yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 69: /* db_options ::= db_options PRECISION NK_STRING */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy452)->pPrecision = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 70: /* db_options ::= db_options QUORUM NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy452)->pQuorum = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 71: /* db_options ::= db_options REPLICA NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy452)->pReplica = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 72: /* db_options ::= db_options TTL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy452)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 73: /* db_options ::= db_options WAL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy452)->pWalLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 74: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy452)->pNumOfVgroups = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 75: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy452)->pSingleStable = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 76: /* db_options ::= db_options STREAM_MODE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy452)->pStreamMode = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 77: /* db_options ::= db_options RETENTIONS retention_list */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy452)->pRetentions = yymsp[0].minor.yy478; yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 78: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy452 = createDatabaseOptions(pCxt); yylhsminor.yy452 = setDatabaseAlterOption(pCxt, yylhsminor.yy452, &yymsp[0].minor.yy11); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 79: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy452 = setDatabaseAlterOption(pCxt, yymsp[-1].minor.yy452, &yymsp[0].minor.yy11); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 80: /* alter_db_option ::= BLOCKS NK_INTEGER */
{ yymsp[-1].minor.yy11.type = DB_OPTION_BLOCKS; yymsp[-1].minor.yy11.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 81: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy11.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy11.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 82: /* alter_db_option ::= KEEP integer_list */
      case 83: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==83);
{ yymsp[-1].minor.yy11.type = DB_OPTION_KEEP; yymsp[-1].minor.yy11.pList = yymsp[0].minor.yy478; }
        break;
      case 84: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy11.type = DB_OPTION_WAL; yymsp[-1].minor.yy11.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 85: /* alter_db_option ::= QUORUM NK_INTEGER */
{ yymsp[-1].minor.yy11.type = DB_OPTION_QUORUM; yymsp[-1].minor.yy11.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 86: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy11.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy11.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 87: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy11.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy11.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 88: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy478 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy478 = yylhsminor.yy478;
        break;
      case 89: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 248: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==248);
{ yylhsminor.yy478 = addNodeToList(pCxt, yymsp[-2].minor.yy478, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy478 = yylhsminor.yy478;
        break;
      case 90: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy478 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy478 = yylhsminor.yy478;
        break;
      case 91: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy478 = addNodeToList(pCxt, yymsp[-2].minor.yy478, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy478 = yylhsminor.yy478;
        break;
      case 92: /* retention_list ::= retention */
      case 112: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==112);
      case 115: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==115);
      case 122: /* column_def_list ::= column_def */ yytestcase(yyruleno==122);
      case 167: /* col_name_list ::= col_name */ yytestcase(yyruleno==167);
      case 203: /* func_name_list ::= func_name */ yytestcase(yyruleno==203);
      case 212: /* func_list ::= func */ yytestcase(yyruleno==212);
      case 272: /* literal_list ::= signed_literal */ yytestcase(yyruleno==272);
      case 321: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==321);
      case 376: /* select_sublist ::= select_item */ yytestcase(yyruleno==376);
      case 423: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==423);
{ yylhsminor.yy478 = createNodeList(pCxt, yymsp[0].minor.yy452); }
  yymsp[0].minor.yy478 = yylhsminor.yy478;
        break;
      case 93: /* retention_list ::= retention_list NK_COMMA retention */
      case 123: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==123);
      case 168: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==168);
      case 204: /* func_name_list ::= func_name_list NK_COMMA col_name */ yytestcase(yyruleno==204);
      case 213: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==213);
      case 273: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==273);
      case 322: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==322);
      case 377: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==377);
      case 424: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==424);
{ yylhsminor.yy478 = addNodeToList(pCxt, yymsp[-2].minor.yy478, yymsp[0].minor.yy452); }
  yymsp[-2].minor.yy478 = yylhsminor.yy478;
        break;
      case 94: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy452 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 95: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 97: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==97);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy659, yymsp[-5].minor.yy452, yymsp[-3].minor.yy478, yymsp[-1].minor.yy478, yymsp[0].minor.yy452); }
        break;
      case 96: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy478); }
        break;
      case 98: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy478); }
        break;
      case 99: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy659, yymsp[0].minor.yy452); }
        break;
      case 100: /* cmd ::= ALTER TABLE alter_table_clause */
      case 101: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==101);
      case 250: /* cmd ::= query_expression */ yytestcase(yyruleno==250);
{ pCxt->pRootNode = yymsp[0].minor.yy452; }
        break;
      case 102: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy452 = createAlterTableOption(pCxt, yymsp[-1].minor.yy452, yymsp[0].minor.yy452); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 103: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy452 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy452, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy479, yymsp[0].minor.yy430); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 104: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy452 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy452, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy479); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 105: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy452 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy452, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy479, yymsp[0].minor.yy430); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 106: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy452 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy452, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy479, &yymsp[0].minor.yy479); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 107: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy452 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy452, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy479, yymsp[0].minor.yy430); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 108: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy452 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy452, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy479); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 109: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy452 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy452, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy479, yymsp[0].minor.yy430); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 110: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy452 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy452, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy479, &yymsp[0].minor.yy479); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 111: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
{ yylhsminor.yy452 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy452, &yymsp[-2].minor.yy479, yymsp[0].minor.yy452); }
  yymsp[-5].minor.yy452 = yylhsminor.yy452;
        break;
      case 113: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 116: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==116);
{ yylhsminor.yy478 = addNodeToList(pCxt, yymsp[-1].minor.yy478, yymsp[0].minor.yy452); }
  yymsp[-1].minor.yy478 = yylhsminor.yy478;
        break;
      case 114: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
{ yylhsminor.yy452 = createCreateSubTableClause(pCxt, yymsp[-8].minor.yy659, yymsp[-7].minor.yy452, yymsp[-5].minor.yy452, yymsp[-4].minor.yy478, yymsp[-1].minor.yy478); }
  yymsp[-8].minor.yy452 = yylhsminor.yy452;
        break;
      case 117: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy452 = createDropTableClause(pCxt, yymsp[-1].minor.yy659, yymsp[0].minor.yy452); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 118: /* specific_tags_opt ::= */
      case 149: /* tags_def_opt ::= */ yytestcase(yyruleno==149);
      case 384: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==384);
      case 401: /* group_by_clause_opt ::= */ yytestcase(yyruleno==401);
      case 411: /* order_by_clause_opt ::= */ yytestcase(yyruleno==411);
{ yymsp[1].minor.yy478 = NULL; }
        break;
      case 119: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy478 = yymsp[-1].minor.yy478; }
        break;
      case 120: /* full_table_name ::= table_name */
{ yylhsminor.yy452 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy479, NULL); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 121: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy452 = createRealTableNode(pCxt, &yymsp[-2].minor.yy479, &yymsp[0].minor.yy479, NULL); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 124: /* column_def ::= column_name type_name */
{ yylhsminor.yy452 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy479, yymsp[0].minor.yy430, NULL); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 125: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy452 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy479, yymsp[-2].minor.yy430, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 126: /* type_name ::= BOOL */
{ yymsp[0].minor.yy430 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 127: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy430 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 128: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy430 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 129: /* type_name ::= INT */
      case 130: /* type_name ::= INTEGER */ yytestcase(yyruleno==130);
{ yymsp[0].minor.yy430 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 131: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy430 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 132: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy430 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 133: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy430 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 134: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy430 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 135: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy430 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 136: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy430 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 137: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy430 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 138: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy430 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 139: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy430 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 140: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy430 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 141: /* type_name ::= JSON */
{ yymsp[0].minor.yy430 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 142: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy430 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 143: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy430 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 144: /* type_name ::= BLOB */
{ yymsp[0].minor.yy430 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 145: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy430 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 146: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy430 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 147: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy430 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 148: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy430 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 150: /* tags_def_opt ::= tags_def */
      case 320: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==320);
      case 375: /* select_list ::= select_sublist */ yytestcase(yyruleno==375);
{ yylhsminor.yy478 = yymsp[0].minor.yy478; }
  yymsp[0].minor.yy478 = yylhsminor.yy478;
        break;
      case 151: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy478 = yymsp[-1].minor.yy478; }
        break;
      case 152: /* table_options ::= */
{ yymsp[1].minor.yy452 = createTableOptions(pCxt); }
        break;
      case 153: /* table_options ::= table_options COMMENT NK_STRING */
{ ((STableOptions*)yymsp[-2].minor.yy452)->pComments = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 154: /* table_options ::= table_options KEEP integer_list */
      case 155: /* table_options ::= table_options KEEP variable_list */ yytestcase(yyruleno==155);
{ ((STableOptions*)yymsp[-2].minor.yy452)->pKeep = yymsp[0].minor.yy478; yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 156: /* table_options ::= table_options TTL NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy452)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 157: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy452)->pSma = yymsp[-1].minor.yy478; yylhsminor.yy452 = yymsp[-4].minor.yy452; }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 158: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy452)->pFuncs = yymsp[-1].minor.yy478; yylhsminor.yy452 = yymsp[-4].minor.yy452; }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 159: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ ((STableOptions*)yymsp[-2].minor.yy452)->pFilesFactor = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 160: /* table_options ::= table_options DELAY NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy452)->pDelay = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 161: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy452 = createTableOptions(pCxt); yylhsminor.yy452 = setTableAlterOption(pCxt, yylhsminor.yy452, &yymsp[0].minor.yy11); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 162: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy452 = setTableAlterOption(pCxt, yymsp[-1].minor.yy452, &yymsp[0].minor.yy11); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 163: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy11.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy11.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 164: /* alter_table_option ::= KEEP integer_list */
      case 165: /* alter_table_option ::= KEEP variable_list */ yytestcase(yyruleno==165);
{ yymsp[-1].minor.yy11.type = TABLE_OPTION_KEEP; yymsp[-1].minor.yy11.pList = yymsp[0].minor.yy478; }
        break;
      case 166: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy11.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy11.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 169: /* col_name ::= column_name */
{ yylhsminor.yy452 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy479); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 170: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 171: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 172: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 173: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 174: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 175: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy452, NULL); }
        break;
      case 176: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 177: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 178: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 179: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 180: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 181: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 182: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 183: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 184: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 185: /* cmd ::= SHOW LICENCE */
      case 186: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==186);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 187: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy479); }
        break;
      case 188: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy452); }
        break;
      case 189: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy452); }
        break;
      case 190: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 191: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 192: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 193: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 194: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT, NULL, NULL); }
        break;
      case 195: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT, NULL, NULL); }
        break;
      case 196: /* db_name_cond_opt ::= */
      case 201: /* from_db_opt ::= */ yytestcase(yyruleno==201);
{ yymsp[1].minor.yy452 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 197: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy479); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 198: /* like_pattern_opt ::= */
      case 209: /* index_options ::= */ yytestcase(yyruleno==209);
      case 236: /* into_opt ::= */ yytestcase(yyruleno==236);
      case 382: /* where_clause_opt ::= */ yytestcase(yyruleno==382);
      case 386: /* twindow_clause_opt ::= */ yytestcase(yyruleno==386);
      case 391: /* sliding_opt ::= */ yytestcase(yyruleno==391);
      case 393: /* fill_opt ::= */ yytestcase(yyruleno==393);
      case 405: /* having_clause_opt ::= */ yytestcase(yyruleno==405);
      case 413: /* slimit_clause_opt ::= */ yytestcase(yyruleno==413);
      case 417: /* limit_clause_opt ::= */ yytestcase(yyruleno==417);
{ yymsp[1].minor.yy452 = NULL; }
        break;
      case 199: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 200: /* table_name_cond ::= table_name */
{ yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy479); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 202: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy479); }
        break;
      case 205: /* func_name ::= function_name */
{ yylhsminor.yy452 = createFunctionNode(pCxt, &yymsp[0].minor.yy479, NULL); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 206: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy659, &yymsp[-3].minor.yy479, &yymsp[-1].minor.yy479, NULL, yymsp[0].minor.yy452); }
        break;
      case 207: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy659, &yymsp[-5].minor.yy479, &yymsp[-3].minor.yy479, yymsp[-1].minor.yy478, NULL); }
        break;
      case 208: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy659, &yymsp[-2].minor.yy479, &yymsp[0].minor.yy479); }
        break;
      case 210: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy452 = createIndexOption(pCxt, yymsp[-6].minor.yy478, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), NULL, yymsp[0].minor.yy452); }
        break;
      case 211: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy452 = createIndexOption(pCxt, yymsp[-8].minor.yy478, releaseRawExprNode(pCxt, yymsp[-4].minor.yy452), releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), yymsp[0].minor.yy452); }
        break;
      case 214: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy452 = createFunctionNode(pCxt, &yymsp[-3].minor.yy479, yymsp[-1].minor.yy478); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 215: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy659, &yymsp[-2].minor.yy479, yymsp[0].minor.yy452, NULL); }
        break;
      case 216: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy659, &yymsp[-2].minor.yy479, NULL, &yymsp[0].minor.yy479); }
        break;
      case 217: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy659, &yymsp[0].minor.yy479); }
        break;
      case 218: /* cmd ::= DESC full_table_name */
      case 219: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==219);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy452); }
        break;
      case 220: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 221: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy659, yymsp[-1].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 223: /* analyze_opt ::= ANALYZE */
      case 231: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==231);
      case 372: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==372);
{ yymsp[0].minor.yy659 = true; }
        break;
      case 224: /* explain_options ::= */
{ yymsp[1].minor.yy452 = createDefaultExplainOptions(pCxt); }
        break;
      case 225: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy452 = setExplainVerbose(pCxt, yymsp[-2].minor.yy452, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 226: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy452 = setExplainRatio(pCxt, yymsp[-2].minor.yy452, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 227: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy478); }
        break;
      case 228: /* cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy659, &yymsp[-5].minor.yy479, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy430, yymsp[0].minor.yy100); }
        break;
      case 229: /* cmd ::= DROP FUNCTION function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, &yymsp[0].minor.yy479); }
        break;
      case 232: /* bufsize_opt ::= */
{ yymsp[1].minor.yy100 = 0; }
        break;
      case 233: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy100 = strtol(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 234: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy659, &yymsp[-4].minor.yy479, yymsp[-3].minor.yy452, yymsp[-2].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 235: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy659, &yymsp[0].minor.yy479); }
        break;
      case 237: /* into_opt ::= INTO full_table_name */
      case 353: /* from_clause ::= FROM table_reference_list */ yytestcase(yyruleno==353);
      case 383: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==383);
      case 406: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==406);
{ yymsp[-1].minor.yy452 = yymsp[0].minor.yy452; }
        break;
      case 238: /* stream_options ::= */
{ yymsp[1].minor.yy452 = createStreamOptions(pCxt); }
        break;
      case 239: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy452)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 240: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy452)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 241: /* stream_options ::= stream_options WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy452)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy452); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 242: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 243: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 244: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 245: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy478); }
        break;
      case 246: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 247: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy478 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 249: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy479); }
        break;
      case 251: /* literal ::= NK_INTEGER */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 252: /* literal ::= NK_FLOAT */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 253: /* literal ::= NK_STRING */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 254: /* literal ::= NK_BOOL */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 255: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 256: /* literal ::= duration_literal */
      case 266: /* signed_literal ::= signed */ yytestcase(yyruleno==266);
      case 284: /* expression ::= literal */ yytestcase(yyruleno==284);
      case 285: /* expression ::= pseudo_column */ yytestcase(yyruleno==285);
      case 286: /* expression ::= column_reference */ yytestcase(yyruleno==286);
      case 287: /* expression ::= function_expression */ yytestcase(yyruleno==287);
      case 288: /* expression ::= subquery */ yytestcase(yyruleno==288);
      case 345: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==345);
      case 349: /* boolean_primary ::= predicate */ yytestcase(yyruleno==349);
      case 351: /* common_expression ::= expression */ yytestcase(yyruleno==351);
      case 352: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==352);
      case 354: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==354);
      case 356: /* table_reference ::= table_primary */ yytestcase(yyruleno==356);
      case 357: /* table_reference ::= joined_table */ yytestcase(yyruleno==357);
      case 361: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==361);
      case 408: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==408);
      case 410: /* query_primary ::= query_specification */ yytestcase(yyruleno==410);
{ yylhsminor.yy452 = yymsp[0].minor.yy452; }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 257: /* literal ::= NULL */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 258: /* literal ::= NK_QUESTION */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 259: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 260: /* signed ::= NK_INTEGER */
{ yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 261: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 262: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 263: /* signed ::= NK_FLOAT */
{ yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 264: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 265: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 267: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 268: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 269: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 270: /* signed_literal ::= duration_literal */
      case 323: /* star_func_para ::= expression */ yytestcase(yyruleno==323);
      case 378: /* select_item ::= common_expression */ yytestcase(yyruleno==378);
      case 422: /* search_condition ::= common_expression */ yytestcase(yyruleno==422);
{ yylhsminor.yy452 = releaseRawExprNode(pCxt, yymsp[0].minor.yy452); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 271: /* signed_literal ::= NULL */
{ yymsp[0].minor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL); }
        break;
      case 289: /* expression ::= NK_LP expression NK_RP */
      case 350: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==350);
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy452)); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 290: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy452));
                                                                                  }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 291: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy452), NULL));
                                                                                  }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 292: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452))); 
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 293: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452))); 
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 294: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452))); 
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 295: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452))); 
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 296: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452))); 
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 297: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 298: /* expression_list ::= expression */
{ yylhsminor.yy478 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy452)); }
  yymsp[0].minor.yy478 = yylhsminor.yy478;
        break;
      case 299: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy478 = addNodeToList(pCxt, yymsp[-2].minor.yy478, releaseRawExprNode(pCxt, yymsp[0].minor.yy452)); }
  yymsp[-2].minor.yy478 = yylhsminor.yy478;
        break;
      case 300: /* column_reference ::= column_name */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy479, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy479)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 301: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy479, &yymsp[0].minor.yy479, createColumnNode(pCxt, &yymsp[-2].minor.yy479, &yymsp[0].minor.yy479)); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 302: /* pseudo_column ::= ROWTS */
      case 303: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==303);
      case 304: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==304);
      case 305: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==305);
      case 306: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==306);
      case 307: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==307);
      case 308: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==308);
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 309: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 310: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==310);
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy479, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy479, yymsp[-1].minor.yy478)); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 311: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), yymsp[-1].minor.yy430)); }
  yymsp[-5].minor.yy452 = yylhsminor.yy452;
        break;
      case 312: /* function_expression ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy479, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy479, NULL)); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 319: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy478 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy478 = yylhsminor.yy478;
        break;
      case 324: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 381: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==381);
{ yylhsminor.yy452 = createColumnNode(pCxt, &yymsp[-2].minor.yy479, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 325: /* predicate ::= expression compare_op expression */
      case 330: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==330);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy218, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)));
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 326: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy452), releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)));
                                                                                  }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 327: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[-5].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)));
                                                                                  }
  yymsp[-5].minor.yy452 = yylhsminor.yy452;
        break;
      case 328: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), NULL));
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 329: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), NULL));
                                                                                  }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 331: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy218 = OP_TYPE_LOWER_THAN; }
        break;
      case 332: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy218 = OP_TYPE_GREATER_THAN; }
        break;
      case 333: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy218 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 334: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy218 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 335: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy218 = OP_TYPE_NOT_EQUAL; }
        break;
      case 336: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy218 = OP_TYPE_EQUAL; }
        break;
      case 337: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy218 = OP_TYPE_LIKE; }
        break;
      case 338: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy218 = OP_TYPE_NOT_LIKE; }
        break;
      case 339: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy218 = OP_TYPE_MATCH; }
        break;
      case 340: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy218 = OP_TYPE_NMATCH; }
        break;
      case 341: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy218 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 342: /* in_op ::= IN */
{ yymsp[0].minor.yy218 = OP_TYPE_IN; }
        break;
      case 343: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy218 = OP_TYPE_NOT_IN; }
        break;
      case 344: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy478)); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 346: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy452), NULL));
                                                                                  }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 347: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)));
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 348: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)));
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 355: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy452 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy452, yymsp[0].minor.yy452, NULL); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 358: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy452 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy479, &yymsp[0].minor.yy479); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 359: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy452 = createRealTableNode(pCxt, &yymsp[-3].minor.yy479, &yymsp[-1].minor.yy479, &yymsp[0].minor.yy479); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 360: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy452 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy452), &yymsp[0].minor.yy479); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 362: /* alias_opt ::= */
{ yymsp[1].minor.yy479 = nil_token;  }
        break;
      case 363: /* alias_opt ::= table_alias */
{ yylhsminor.yy479 = yymsp[0].minor.yy479; }
  yymsp[0].minor.yy479 = yylhsminor.yy479;
        break;
      case 364: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy479 = yymsp[0].minor.yy479; }
        break;
      case 365: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 366: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==366);
{ yymsp[-2].minor.yy452 = yymsp[-1].minor.yy452; }
        break;
      case 367: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy452 = createJoinTableNode(pCxt, yymsp[-4].minor.yy162, yymsp[-5].minor.yy452, yymsp[-2].minor.yy452, yymsp[0].minor.yy452); }
  yymsp[-5].minor.yy452 = yylhsminor.yy452;
        break;
      case 368: /* join_type ::= */
{ yymsp[1].minor.yy162 = JOIN_TYPE_INNER; }
        break;
      case 369: /* join_type ::= INNER */
{ yymsp[0].minor.yy162 = JOIN_TYPE_INNER; }
        break;
      case 370: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy452 = createSelectStmt(pCxt, yymsp[-7].minor.yy659, yymsp[-6].minor.yy478, yymsp[-5].minor.yy452);
                                                                                    yymsp[-8].minor.yy452 = addWhereClause(pCxt, yymsp[-8].minor.yy452, yymsp[-4].minor.yy452);
                                                                                    yymsp[-8].minor.yy452 = addPartitionByClause(pCxt, yymsp[-8].minor.yy452, yymsp[-3].minor.yy478);
                                                                                    yymsp[-8].minor.yy452 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy452, yymsp[-2].minor.yy452);
                                                                                    yymsp[-8].minor.yy452 = addGroupByClause(pCxt, yymsp[-8].minor.yy452, yymsp[-1].minor.yy478);
                                                                                    yymsp[-8].minor.yy452 = addHavingClause(pCxt, yymsp[-8].minor.yy452, yymsp[0].minor.yy452);
                                                                                  }
        break;
      case 373: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy659 = false; }
        break;
      case 374: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy478 = NULL; }
        break;
      case 379: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy452 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy452), &yymsp[0].minor.yy479); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 380: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy452 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), &yymsp[0].minor.yy479); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 385: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 402: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==402);
      case 412: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==412);
{ yymsp[-2].minor.yy478 = yymsp[0].minor.yy478; }
        break;
      case 387: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy452 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), releaseRawExprNode(pCxt, yymsp[-1].minor.yy452)); }
        break;
      case 388: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy452 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy452)); }
        break;
      case 389: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy452 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), NULL, yymsp[-1].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 390: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy452 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy452), releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), yymsp[-1].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 392: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy452 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy452); }
        break;
      case 394: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy452 = createFillNode(pCxt, yymsp[-1].minor.yy540, NULL); }
        break;
      case 395: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy452 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy478)); }
        break;
      case 396: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy540 = FILL_MODE_NONE; }
        break;
      case 397: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy540 = FILL_MODE_PREV; }
        break;
      case 398: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy540 = FILL_MODE_NULL; }
        break;
      case 399: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy540 = FILL_MODE_LINEAR; }
        break;
      case 400: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy540 = FILL_MODE_NEXT; }
        break;
      case 403: /* group_by_list ::= expression */
{ yylhsminor.yy478 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy452))); }
  yymsp[0].minor.yy478 = yylhsminor.yy478;
        break;
      case 404: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy478 = addNodeToList(pCxt, yymsp[-2].minor.yy478, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy452))); }
  yymsp[-2].minor.yy478 = yylhsminor.yy478;
        break;
      case 407: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy452 = addOrderByClause(pCxt, yymsp[-3].minor.yy452, yymsp[-2].minor.yy478);
                                                                                    yylhsminor.yy452 = addSlimitClause(pCxt, yylhsminor.yy452, yymsp[-1].minor.yy452);
                                                                                    yylhsminor.yy452 = addLimitClause(pCxt, yylhsminor.yy452, yymsp[0].minor.yy452);
                                                                                  }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 409: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy452 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy452, yymsp[0].minor.yy452); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 414: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 418: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==418);
{ yymsp[-1].minor.yy452 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 415: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 419: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==419);
{ yymsp[-3].minor.yy452 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 416: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 420: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==420);
{ yymsp[-3].minor.yy452 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 421: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy452); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 425: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy452 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), yymsp[-1].minor.yy326, yymsp[0].minor.yy595); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 426: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy326 = ORDER_ASC; }
        break;
      case 427: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy326 = ORDER_ASC; }
        break;
      case 428: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy326 = ORDER_DESC; }
        break;
      case 429: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy595 = NULL_ORDER_DEFAULT; }
        break;
      case 430: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy595 = NULL_ORDER_FIRST; }
        break;
      case 431: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy595 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (pCxt->valid) {
    if(TOKEN.z) {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
    pCxt->valid = false;
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
