# 基本概念

## 物联网典型场景

在典型的物联网、车联网、运维监测场景中，往往有多种不同类型的数据采集设备，采集一个到多个不同的物理量。而同一种采集设备类型，往往又有多个具体的采集设备分布在不同的地点。大数据处理系统就是要将各种采集的数据汇总，然后进行计算和分析。对于同一类设备，其采集的数据类似如下的表格：

| Device ID |  Time Stamp   | Value 1 | Value 2 | Value 3 | Tag 1 | Tag 2 |
| :-------: | :-----------: | :-----: | :-----: | :-----: | :---: | :---: |
|   D1001   | 1538548685000 |  10.3   |   219   |  0.31   |  Red  | Tesla |
|   D1002   | 1538548684000 |  10.2   |   220   |  0.23   | Blue  |  BMW  |
|   D1003   | 1538548686500 |  11.5   |   221   |  0.35   | Black | Honda |
|   D1004   | 1538548685500 |  13.4   |   223   |  0.29   |  Red  | Volvo |
|   D1001   | 1538548695000 |  12.6   |   218   |  0.33   |  Red  | Tesla |
|   D1004   | 1538548696600 |  11.8   |   221   |  0.28   | Black | Honda |


每一条记录都有设备 ID，时间戳，采集的物理量，还有与每个设备相关的静态标签。每个设备是受外界的触发，或按照设定的周期采集数据。采集的数据点是时序的，是一个数据流。

**数据特征**

除时序特征外，仔细研究发现，物联网、车联网、运维监测类数据还具有很多其他明显的特征。

1. 数据是结构化的；
2. 数据极少有更新或删除操作；
3. 无需传统数据库的事务处理；
4. 相对互联网应用，写多读少；
5. 流量平稳，根据设备数量和采集频次，可以预测出来；
6. 用户关注的是一段时间的趋势，而不是某一特点时间点的值；
7. 数据是有保留期限的；
8. 数据的查询分析一定是基于时间段和地理区域的；
9. 除存储查询外，还往往需要各种统计和实时计算操作；
10. 数据量巨大，一天采集的数据就可以超过 100 亿条。

充分利用上述特征，TDengine 采取了一特殊的优化的存储和计算设计来处理时序数据，能将系统处理能力显著提高。

## 数据采集点

持续按照预设频率生成数据的软件或硬件设备称为数据采集点。TDengine中推荐一个数据采集点生成的数据存储在对应的一个或若干个表中。采集点产生的数据通常是包括时间戳、测量值、标签等必要信息构成的元组。

## 采集量

数据采集点生成的具有时间、测量值、标签的元组信息。除了时间戳、标签信息以外的测量值称为采集量。

## 标签

表的结构化描述信息，以一维数组形式存在。标签模式需要在创建超级表的时候指定，后续可动态调整。只有基于超级表创建的子表才具有标签。标签信息的内容首次创建子表的时候指定，并可按需调整。可以看到，TDengine中标签信息是表级别，而不是记录级别。

## 数据库

 TDengine中数据库与普通数据库管理系统中的数据库语义和行为相同，但是结合应用需求增加了若干配置参数用以控制其行为。

## 超级表

超级表（Super Table, STable）是TDengine中一个重要的概念。超级表是面向相同数据模式的数据表，提供（数据+标签）模式管理和查询处理的逻辑抽象。通常将基于超级表创建的表称为该超级表的子表，并在系统内部建立逻辑关联。超级表与（基于其创建的）子表的关系体现在以下几个方面：

超级表的子表共享其数据模式和标签模式。因此，不能通过子表调整数据或标签的模式。对于超级表的数据模式修改立即对所有的子表生效。

超级表自身不能存储任何数据或标签信息。因此，不能向一个超级表写入数据，只能将数据写入子表中。

针对超级表的查询，将所有子表中的数据视为一个整体数据集进行处理。但是可以直接发起针对某个或若干个子表的查询，此时查询请求将该子表视为一个普通的表进行处理。

## 表

一系列二维数组的集合，用来代表和储存数据对象之间的关系，由纵向的列和横向的行组成。TDengine中的表与普通数据库中的表没有差别。

但是，对于通过超级表创建的子表，还具有额外的标签数据信息。不能针对某个子表调整数据模式。每个子表具有与其关联的标签数据，并可按需调整内容。但是模式调整必须要通过超级表模式调整来完成。

使用TDengine存储和管理物联网数据的时候，推荐使用一个子表存储一个数据采集点生成的数据，而使用超级表用来代表一组相同类型的数据采集点的集合。
