/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 480
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  STokenPair yy57;
  EFillMode yy294;
  EOperatorType yy380;
  ENullOrder yy457;
  int8_t yy503;
  EOrder yy578;
  int32_t yy580;
  SAlterOption yy605;
  SNodeList* yy664;
  int64_t yy669;
  SDataType yy784;
  EJoinType yy852;
  bool yy857;
  SNode* yy872;
  SToken yy929;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             772
#define YYNRULE              587
#define YYNTOKEN             333
#define YY_MAX_SHIFT         771
#define YY_MIN_SHIFTREDUCE   1147
#define YY_MAX_SHIFTREDUCE   1733
#define YY_ERROR_ACTION      1734
#define YY_ACCEPT_ACTION     1735
#define YY_NO_ACTION         1736
#define YY_MIN_REDUCE        1737
#define YY_MAX_REDUCE        2323
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (3028)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  2135, 2025,  511, 2004,  403,  512, 1773, 1952, 1954, 1896,
 /*    10 */   682, 2025,   48,   46, 1661, 1738, 2023,  652,   34,  168,
 /*    20 */   398, 1749, 1510,  391,   41,   40, 2022,  652,   47,   45,
 /*    30 */    44,   43,   42, 1591, 1806, 1508,  123, 2153, 1535,  122,
 /*    40 */   121,  120,  119,  118,  117,  116,  115,  114,  199, 2103,
 /*    50 */   392,  681, 1202, 1202, 1201, 1201,   41,   40,  165, 1586,
 /*    60 */    47,   45,   44,   43,   42,   19, 1909,  233, 1538, 1735,
 /*    70 */   528,  123, 1516, 2238,  122,  121,  120,  119,  118,  117,
 /*    80 */   116,  115,  114, 2134, 1203, 1203, 2170,  665, 1907,  169,
 /*    90 */  2136,  685, 2138, 2139,  680,   66,  675,  768,  664, 2235,
 /*   100 */    15,  745,  744,  743,  742,  410,  191,  741,  740,  144,
 /*   110 */   735,  734,  733,  732,  731,  730,  729,  157,  725,  724,
 /*   120 */   723,  409,  408,  720,  719,  718,  175,  174,  203,  604,
 /*   130 */  2260,  519, 1331,  182,  512, 1773, 1593, 1594,  665, 1907,
 /*   140 */   413, 1536,  444,   62,  412, 1946,  443, 1322,  707,  706,
 /*   150 */   705, 1326,  704, 1328, 1329,  703,  700,  133, 1337,  697,
 /*   160 */  1339, 1340,  694,  691,  549, 1535, 1566, 1576,   84,  664,
 /*   170 */  1959,   83, 1592, 1595,  650,   41,   40,  363,   51,   47,
 /*   180 */    45,   44,   43,   42,  101, 1957, 1511,  603, 1509,  603,
 /*   190 */  2294,   62, 2294,  294,  295,   41,   40,  623,  293,   47,
 /*   200 */    45,   44,   43,   42, 1286, 2300,  186, 2300,  186, 1900,
 /*   210 */  2295,  629, 2295,  629,  640,  140,  262, 1285, 1514, 1515,
 /*   220 */   664, 1565, 1568, 1569, 1570, 1571, 1572, 1573, 1574, 1575,
 /*   230 */   677,  673, 1584, 1585, 1587, 1588, 1589, 1590,    2,   48,
 /*   240 */    46, 1989,  665, 1907,  348, 1622, 1533,  398,  628, 1510,
 /*   250 */   450, 2294,  357,  481,  665, 1907,  495, 1365, 1366,  494,
 /*   260 */  1591,  133, 1508,  717, 2135,  234,  627,  186,  554, 2113,
 /*   270 */   622, 2295,  629,   57,  679,  464,  516,  496, 1737,  497,
 /*   280 */   466,  172,  513, 1898,   38,  303, 1586,  545,  541,  537,
 /*   290 */   533,  231,   19, 2117,  345, 1534, 1620, 2153,  189, 1516,
 /*   300 */    51, 2153,  132,  131,  130,  129,  128,  127,  126,  125,
 /*   310 */   124, 1420, 1421, 2103,  432,  681,  282, 2231,  639,  590,
 /*   320 */   134,  638,   35, 2294,  768,  366, 1180,   15,   52, 1188,
 /*   330 */  2119,   88, 1627,  189,  229, 1534, 1510,  454,  627,  186,
 /*   340 */   675,  434,  430, 2295,  629, 1730,  189, 2134, 1537, 1508,
 /*   350 */  2170,  621, 1621,  339, 2136,  685, 2138, 2139,  680,  678,
 /*   360 */   675,  666, 2188, 1593, 1594, 1182,  492, 1185, 1186,  486,
 /*   370 */   485,  484,  483,  480,  479,  478,  477,  476,  472,  471,
 /*   380 */   470,  469,  347,  461,  460,  459, 1516,  456,  455,  364,
 /*   390 */    44,   43,   42, 1566, 1576, 1760,  468, 2299,  166, 1592,
 /*   400 */  1595,  228,  222,  323,  628,  467,  227, 2294,  524,  640,
 /*   410 */   140,  768,  249, 1511, 1537, 1509,  248,  321,   73,  563,
 /*   420 */   562,   72,  627,  186, 1953, 1954,  220, 2295,  629,   37,
 /*   430 */   396, 1615, 1616, 1617, 1618, 1619, 1623, 1624, 1625, 1626,
 /*   440 */   214,  507,  505,  502, 2103, 1514, 1515, 1729, 1565, 1568,
 /*   450 */  1569, 1570, 1571, 1572, 1573, 1574, 1575,  677,  673, 1584,
 /*   460 */  1585, 1587, 1588, 1589, 1590,    2,   12,   48,   46,   47,
 /*   470 */    45,   44,   43,   42, 1535,  398,   90, 1510, 1290,  352,
 /*   480 */    62, 2238,  377,  189,  583,  567,  566,  565, 1591, 2135,
 /*   490 */  1508, 1289,  557,  137,  561, 1723,  284, 1689,  560,  682,
 /*   500 */  1511,   62, 1509,  559,  564,  373,  372, 2234,  179,  558,
 /*   510 */   642,  184, 2231, 2232, 1586,  138, 2236,  216,  109, 1759,
 /*   520 */    19,  514,  167, 1780,  665, 1907, 2153, 1516,  365, 2008,
 /*   530 */  1848,  218, 1514, 1515,  618,  514, 2124, 1780, 2103,   12,
 /*   540 */   681,   10, 2113,  448,  615,  614, 1687, 1688, 1690, 1691,
 /*   550 */  1692,  602,  768,  499,   62,   15, 2122,  401,   81,   80,
 /*   560 */   447, 2135,  284,  198, 2004,  165, 2117,  646, 2103,   12,
 /*   570 */   250,  682, 2134, 1909, 1275, 2170,  439,  437,  170, 2136,
 /*   580 */   685, 2138, 2139,  680, 2068,  675,  442,  346,  441, 2126,
 /*   590 */   428, 1593, 1594,  426,  422,  418,  415,  440, 2153,  142,
 /*   600 */    41,   40, 2194, 2119,   47,   45,   44,   43,   42,  201,
 /*   610 */  2103, 1277,  681,  675,  603,  665, 1907, 2294,  440,  651,
 /*   620 */  1516, 1566, 1576,  624,  619,  612, 1758, 1592, 1595,  630,
 /*   630 */  2315,  251, 2300,  186,  449,  189,   30, 2295,  629, 1481,
 /*   640 */  1482, 1511, 1884, 1509, 2134, 1809,  581, 2170,  665, 1907,
 /*   650 */   110, 2136,  685, 2138, 2139,  680,  189,  675, 2096,  579,
 /*   660 */   143,  577,  150, 2194, 2223,  739,  737,  458,  394, 2219,
 /*   670 */   526,   55, 2018, 1514, 1515, 2103, 1565, 1568, 1569, 1570,
 /*   680 */  1571, 1572, 1573, 1574, 1575,  677,  673, 1584, 1585, 1587,
 /*   690 */  1588, 1589, 1590,    2,   48,   46, 1596,  665, 1907,  651,
 /*   700 */  2135, 1232,  398, 2299, 1510,  603, 2294, 1757, 2294,  189,
 /*   710 */   643, 1756,  567,  566,  565, 1591,  644, 1508, 1755,  557,
 /*   720 */   137,  561, 2298, 2300,  186,  560, 2295, 2297, 2295,  629,
 /*   730 */   559,  564,  373,  372,  665, 1907,  558, 2153, 1233,   41,
 /*   740 */    40, 1586, 1665,   47,   45,   44,   43,   42, 1535, 2103,
 /*   750 */   649,  681, 2018,  473, 1516,  667, 2103, 2195,   41,   40,
 /*   760 */  2103,  632,   47,   45,   44,   43,   42, 2103,  665, 1907,
 /*   770 */   285,  715,  155,  154,  712,  711,  710,  152, 1601,  768,
 /*   780 */   665, 1907,   49, 2134, 1535,  179, 2170,  474, 2135,  110,
 /*   790 */  2136,  685, 2138, 2139,  680,  572,  675,  708,  682,  527,
 /*   800 */  1782,  183, 1959, 2223,  407,  406, 2009,  394, 2219,  378,
 /*   810 */   582,   62, 2299,   93, 1538, 2294, 2238, 1957, 1593, 1594,
 /*   820 */   188, 1882,  665, 1907,  247, 2153,  709, 1517, 2249, 1950,
 /*   830 */   727, 2298, 1700,  640,  140, 2295, 2296, 2103, 1883,  681,
 /*   840 */   575, 1904, 2233,   87, 1892,  569, 1959,   87, 1566, 1576,
 /*   850 */   246, 1677,   36,  388, 1592, 1595,  665, 1907,   41,   40,
 /*   860 */   367, 1957,   47,   45,   44,   43,   42, 2086, 1511, 1902,
 /*   870 */  1509, 2134,  651, 1903, 2170,  252, 1538,  110, 2136,  685,
 /*   880 */  2138, 2139,  680, 1754,  675,  259,  640,  140, 2004, 2314,
 /*   890 */    70, 2223, 1753,   69, 1567,  394, 2219,   14,   13, 2097,
 /*   900 */  1514, 1515,  717, 1565, 1568, 1569, 1570, 1571, 1572, 1573,
 /*   910 */  1574, 1575,  677,  673, 1584, 1585, 1587, 1588, 1589, 1590,
 /*   920 */     2,   48,   46,  660, 2135, 2018,  665, 1907, 1959,  398,
 /*   930 */  1567, 1510, 2103,  205,  643,  185, 2231, 2232, 1752,  138,
 /*   940 */  2236, 2103, 1591, 1958, 1508,  599,  603, 2135, 2298, 2294,
 /*   950 */   715,  155,  154,  712,  711,  710,  152,  682,  669, 2257,
 /*   960 */  2195, 2153,  200,  401, 2300,  186,  189, 1658, 1586, 2295,
 /*   970 */   629,  162, 1751, 2103,  107,  681,  665, 1907,  379, 1909,
 /*   980 */  1520, 1516,  665, 1907, 2153,    9, 1957, 2103,  187, 2231,
 /*   990 */  2232,  141,  138, 2236,  633,  648, 2103, 1634,  681, 1899,
 /*  1000 */  1748,  298,  370,  404,  665, 1907,  768, 2134,  553,   49,
 /*  1010 */  2170,  165,  552,  110, 2136,  685, 2138, 2139,  680, 1909,
 /*  1020 */   675, 2103,  588,  662,  261,  183, 1894, 2223, 1747,  488,
 /*  1030 */  2134,  394, 2219, 2170, 1536, 1890,  110, 2136,  685, 2138,
 /*  1040 */  2139,  680, 2113,  675,  713, 1593, 1594, 1950, 2314, 2103,
 /*  1050 */  2223, 1746, 2250,  635,  394, 2219, 2121,   41,   40,  665,
 /*  1060 */  1907,   47,   45,   44,   43,   42, 2117, 1911,  371,  603,
 /*  1070 */   369,  368, 2294,  551, 2135, 1566, 1576, 2103,  663,  427,
 /*  1080 */  1745, 1592, 1595,  165,  682, 1535, 2270, 2300,  186,  207,
 /*  1090 */   206, 1910, 2295,  629,  553, 1511,  317, 1509,  552, 1936,
 /*  1100 */  2103,   41,   40, 2119,  395,   47,   45,   44,   43,   42,
 /*  1110 */  1744, 2153,  487,  675,  715,  155,  154,  712,  711,  710,
 /*  1120 */   152,  728,  256, 2103, 1869,  681,  676, 1514, 1515, 2103,
 /*  1130 */  1565, 1568, 1569, 1570, 1571, 1572, 1573, 1574, 1575,  677,
 /*  1140 */   673, 1584, 1585, 1587, 1588, 1589, 1590,    2,   48,   46,
 /*  1150 */  1437, 1438,  714, 1185, 1186, 1950,  398, 2134, 1510, 2103,
 /*  1160 */  2170, 1743, 2135,  110, 2136,  685, 2138, 2139,  680, 1591,
 /*  1170 */   675, 1508,  682, 1959,  610, 2314, 1742, 2223,  665, 1907,
 /*  1180 */   393,  394, 2219, 1959,  153, 1741, 1436, 1439, 1957, 1740,
 /*  1190 */   402, 2135, 2243, 1654,   54, 1586,    3,  304, 1957, 2153,
 /*  1200 */  1654,  682,  451, 2288,  665, 1907, 1885,  146, 1516,  135,
 /*  1210 */  2103, 2103, 2089,  681,  585,  452,  584,  164,   74, 1657,
 /*  1220 */   631,  239,  555,  405,  237, 2103,  241,  556, 2153,  240,
 /*  1230 */  1849, 1567,  243,  768, 2103,  242,   15, 1796, 2103,  672,
 /*  1240 */  2103,   56,  681,  245, 1273, 2134,  244,  153, 2170, 1271,
 /*  1250 */   148,  110, 2136,  685, 2138, 2139,  680, 1789,  675,  568,
 /*  1260 */  1519,  420, 1783, 2314, 1787, 2223,  153,   82,   50,  394,
 /*  1270 */  2219,   50, 1593, 1594, 2134,  260,  266, 2170,  153,  570,
 /*  1280 */   110, 2136,  685, 2138, 2139,  680,  573,  675,  636, 1732,
 /*  1290 */  1733,   50, 2314, 1518, 2223,  291,  407,  406,  394, 2219,
 /*  1300 */    14,   13, 1566, 1576, 1476,  106, 1524, 1750, 1592, 1595,
 /*  1310 */  2263,  616,  763,  279, 1847,  103,  721, 1591,   91, 1517,
 /*  1320 */    71,  151, 1511, 1479, 1509, 1686,  153,   64, 1685,   50,
 /*  1330 */   232,   50,  689,  268,  151,  647,  153,  136, 1251,  151,
 /*  1340 */  1846,  273, 2154, 1586,  411, 2013, 1774, 1779, 1434, 2253,
 /*  1350 */  1947,  641,  296,  281, 1514, 1515, 1516, 1565, 1568, 1569,
 /*  1360 */  1570, 1571, 1572, 1573, 1574, 1575,  677,  673, 1584, 1585,
 /*  1370 */  1587, 1588, 1589, 1590,    2, 2135,  722,  657,  300,  278,
 /*  1380 */     1,  671,    5, 1316, 1628,  682, 1577, 2242,  316, 1343,
 /*  1390 */   419, 1347, 1612, 1354, 1352,  414,  156,  361, 1249, 1541,
 /*  1400 */   436,  435,  193,  194,  438,  196,  311, 1457,  204,  453,
 /*  1410 */  1538, 2014, 2153, 1522,  457,  490,  462, 1533,  475, 2006,
 /*  1420 */   482,  489,  491,  500, 2103,  501,  681,  498,  208,  209,
 /*  1430 */   503,  504,  211,  506,  508, 1539,  509,    4,  510,  517,
 /*  1440 */   520,  518, 1536,  219,  521,  221, 1521, 1540, 1542,  522,
 /*  1450 */   523,  525, 1205,  224,  548,  529,  226,  587, 2134,   85,
 /*  1460 */  2077, 2170,   86,  546,  110, 2136,  685, 2138, 2139,  680,
 /*  1470 */  1525,  675, 1520,  230, 2135,  112, 2314,  547, 2223,  351,
 /*  1480 */  2074,  589,  394, 2219,  682,  550,  149, 1897,  236,  593,
 /*  1490 */  2073, 1893,  238,   89,  158,  312,  159, 2135,  253, 1895,
 /*  1500 */   592,  257, 1528, 1530, 1891,  160,  161,  682, 1464,  594,
 /*  1510 */   617, 2153,  600, 2269, 2268,  673, 1584, 1585, 1587, 1588,
 /*  1520 */  1589, 1590,  255, 2103,  597,  681,  655,  607,    8, 2254,
 /*  1530 */  2264,  613, 2245,  383, 2153,  626,  620,  173,  274,  598,
 /*  1540 */   272,  608,  606,  264,  267,  277, 2103,  605,  681,  275,
 /*  1550 */   637,  276,  384,  139, 2293,  634, 1654, 2134,  280, 2317,
 /*  1560 */  2170, 1537,  645,  110, 2136,  685, 2138, 2139,  680, 2239,
 /*  1570 */   675,  286,   96,  387, 1543, 2198, 2019, 2223,  653,  313,
 /*  1580 */  2134,  394, 2219, 2170,  654, 2135,  110, 2136,  685, 2138,
 /*  1590 */  2139,  680,  314,  675,  658,  682, 2033,  591, 2196,  659,
 /*  1600 */  2223,   61,  315, 2032,  394, 2219,   98, 1908, 2204,  102,
 /*  1610 */   100, 2135,  687, 2031,  390,  771, 1951, 1870,  318,  307,
 /*  1620 */   764,  682, 2153, 2095,  342,  765,   53,  327, 2094,  310,
 /*  1630 */   320,  353,  767,  341, 2103,  322,  681,  354, 2093,   78,
 /*  1640 */  2090,  331,  416,  417, 1501,  178, 1502,  192, 2153,  421,
 /*  1650 */  2088,  761,  757,  753,  749,  308,  423,  424,  425, 2135,
 /*  1660 */  2103,  362,  681, 2087, 2085,  429, 2084,  431, 2134,  682,
 /*  1670 */  2083, 2170,  433, 1492,  110, 2136,  685, 2138, 2139,  680,
 /*  1680 */  2064,  675,  195, 2063,  197, 1460,  668,   79, 2223, 1459,
 /*  1690 */  2045, 2044,  394, 2219, 2134,  108, 2153, 2170,  301, 2043,
 /*  1700 */   111, 2136,  685, 2138, 2139,  680,  445,  675, 2103,  446,
 /*  1710 */   681, 2042, 2041, 1997, 2223, 1411, 1996, 1994, 2222, 2219,
 /*  1720 */   145, 1993, 2135, 1992, 1995, 1991, 1990, 1988, 1987, 1986,
 /*  1730 */   661,  202,  682,  463, 1985,  465, 1999, 1984, 1983, 1982,
 /*  1740 */  1981, 1980, 2134, 1979, 1978, 2170, 1977, 1976,  111, 2136,
 /*  1750 */   685, 2138, 2139,  680, 1975,  675, 1974, 1973, 1972, 2153,
 /*  1760 */  1971, 1970, 2223,  493,  147,  288,  670, 2219, 1969, 1968,
 /*  1770 */   287, 2103, 1967,  681, 1998, 1966, 1965, 1413, 1964, 1963,
 /*  1780 */  1962, 1961, 1960,  349, 1287, 1812, 1291, 1283, 1811,  210,
 /*  1790 */   254,  212, 1810,  350, 1808, 1769, 2123,  180,   76, 1768,
 /*  1800 */  1187,  213, 2062, 2052,   77,  683,  217, 2135, 2170,  215,
 /*  1810 */  2040,  111, 2136,  685, 2138, 2139,  680,  682,  675,  225,
 /*  1820 */   181, 2039,  223, 2017,  515, 2223,  530, 1803,  534,  356,
 /*  1830 */  2219, 1886, 1807, 1805, 1801,  532, 1225,  536,  531,  535,
 /*  1840 */  2135,  538, 1799,  540, 2153, 1786,  539,  542,  544,  543,
 /*  1850 */   682, 1785, 1765, 1888, 1359, 1887, 2103,   63,  681, 1358,
 /*  1860 */  1274,  736,  738, 1272, 1270, 1269, 1797, 1790, 1261, 1788,
 /*  1870 */  1268, 2135,  374, 1267, 1266, 1263,  375, 2153,  235, 1262,
 /*  1880 */   376,  682, 1260,  574, 1764, 1763, 1762,  571,  113, 2103,
 /*  1890 */  2134,  681,  576, 2170,  578,  580,  111, 2136,  685, 2138,
 /*  1900 */  2139,  680, 2135,  675, 2061, 1486, 1488, 1485, 2153, 1490,
 /*  1910 */  2223,   29,  682,  381,   67, 2220, 1466, 1468,   58, 2051,
 /*  1920 */  2103,  595,  681, 2134, 1470, 2038, 2170, 2036,   17,  169,
 /*  1930 */  2136,  685, 2138, 2139,  680, 2135,  675, 2299,   20, 2153,
 /*  1940 */   163,    6,   65,   31,  382,  682,    7,   21,  271,   22,
 /*  1950 */  1702, 2103,  596,  681, 2134,  380,  263, 2170,  609,  611,
 /*  1960 */   340, 2136,  685, 2138, 2139,  680,  265,  675,  270, 2124,
 /*  1970 */  2261,  258, 2153,   33,   23, 1684,  171,  269,   32,   92,
 /*  1980 */   601, 1676,   24, 1722, 2103, 2134,  681, 1717, 2170, 1723,
 /*  1990 */  1716,  340, 2136,  685, 2138, 2139,  680, 2135,  675,  385,
 /*  2000 */  1721, 1720,  386, 1651,  283,  176,   60,  682, 1650, 2037,
 /*  2010 */  2035, 2034, 2135, 2016,   94,   95,  289,   25, 2134,  290,
 /*  2020 */   292, 2170,  682,  297,  333, 2136,  685, 2138, 2139,  680,
 /*  2030 */    68,  675, 1682, 2135, 2153,  656, 2015,   97,  103,  302,
 /*  2040 */    99,   26, 1603,  679,  299, 1602, 2103,   13,  681, 2153,
 /*  2050 */  1526, 2173,  177,   11,  389, 1581,  674, 1558,  688,  190,
 /*  2060 */  1579, 2103,  400,  681, 1578,  692,   18,  625,   59, 1550,
 /*  2070 */  2153,   39,   16,   27,   28,  695, 1344,  690,  693, 1613,
 /*  2080 */  2134,  686, 2103, 2170,  681, 1341,  170, 2136,  685, 2138,
 /*  2090 */  2139,  680, 1338,  675,  696, 2134, 1332,  698, 2170, 2135,
 /*  2100 */   699,  340, 2136,  685, 2138, 2139,  680,  684,  675,  682,
 /*  2110 */   701, 1336, 1335,  305, 1353, 1330, 2134,  702, 1334, 2170,
 /*  2120 */   104, 1333,  339, 2136,  685, 2138, 2139,  680, 1349,  675,
 /*  2130 */  1223, 2189,  105,   75, 1255,  716, 2153, 1254, 2316, 1253,
 /*  2140 */  1252,  397,  726, 1250, 1248, 1247, 1246,  306, 2103, 1281,
 /*  2150 */   681, 1244, 1243, 1242, 1241, 1240, 1239, 1238, 1278, 1276,
 /*  2160 */  1235, 1234, 2135, 1231, 1230, 1229, 1228, 1804,  746,  748,
 /*  2170 */  1802,  750,  682,  754,  752, 1800,  747, 2135,  756, 1798,
 /*  2180 */   758,  760, 2134,  751, 1784, 2170,  755,  682,  340, 2136,
 /*  2190 */   685, 2138, 2139,  680,  762,  675,  759, 1177, 1761, 2153,
 /*  2200 */   309,  766,  770, 1512,  399,  319,  769, 1736, 1736, 1736,
 /*  2210 */  1736, 2103, 1736,  681, 2153, 1736, 1736, 1736, 1736, 1736,
 /*  2220 */  1736, 1736, 1736, 1736, 1736, 1736, 2103, 2135,  681, 1736,
 /*  2230 */  1736, 1736, 1736, 1736, 1736, 1736, 1736,  682, 1736, 1736,
 /*  2240 */  1736, 1736, 1736, 1736, 1736, 2134, 1736, 2135, 2170, 1736,
 /*  2250 */  1736,  340, 2136,  685, 2138, 2139,  680,  682,  675, 1736,
 /*  2260 */   586, 1736, 1736, 2170, 2153, 1736,  335, 2136,  685, 2138,
 /*  2270 */  2139,  680, 1736,  675, 1736, 1736, 2103, 1736,  681, 1736,
 /*  2280 */  1736, 1736, 1736, 1736, 2153, 1736, 1736, 1736, 1736, 1736,
 /*  2290 */  1736, 1736, 1736, 1736, 1736, 1736, 2103, 2135,  681, 1736,
 /*  2300 */  1736, 1736, 1736, 1736, 1736, 1736, 1736,  682, 1736, 1736,
 /*  2310 */  2134, 1736, 1736, 2170, 1736, 1736,  324, 2136,  685, 2138,
 /*  2320 */  2139,  680, 2135,  675, 1736, 1736, 1736, 1736, 1736, 1736,
 /*  2330 */  2134, 1736,  682, 2170, 2153, 1736,  325, 2136,  685, 2138,
 /*  2340 */  2139,  680, 1736,  675, 1736, 1736, 2103, 1736,  681, 1736,
 /*  2350 */  1736, 1736, 1736, 1736, 1736, 2135, 1736, 1736, 1736, 2153,
 /*  2360 */  1736, 1736, 1736, 1736, 1736,  682, 1736, 1736, 1736, 1736,
 /*  2370 */  1736, 2103, 1736,  681, 1736, 1736, 1736, 1736, 1736, 1736,
 /*  2380 */  2134, 1736, 1736, 2170, 1736, 2135,  326, 2136,  685, 2138,
 /*  2390 */  2139,  680, 2153,  675, 1736,  682, 1736, 1736, 1736, 1736,
 /*  2400 */  1736, 1736, 1736, 1736, 2103, 2134,  681, 1736, 2170, 1736,
 /*  2410 */  1736,  332, 2136,  685, 2138, 2139,  680, 1736,  675, 1736,
 /*  2420 */  1736, 2135, 2153, 1736, 1736, 1736, 1736, 1736, 1736, 1736,
 /*  2430 */  1736,  682, 1736, 1736, 2103, 1736,  681, 1736, 2134, 1736,
 /*  2440 */  1736, 2170, 1736, 2135,  336, 2136,  685, 2138, 2139,  680,
 /*  2450 */  1736,  675, 1736,  682, 1736, 1736, 1736, 1736, 2153, 1736,
 /*  2460 */  1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736, 2134, 1736,
 /*  2470 */  2103, 2170,  681, 1736,  328, 2136,  685, 2138, 2139,  680,
 /*  2480 */  2153,  675, 1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736,
 /*  2490 */  1736, 1736, 2103, 1736,  681, 1736, 1736, 1736, 1736, 1736,
 /*  2500 */  1736, 1736, 1736, 1736, 2134, 1736, 1736, 2170, 1736, 2135,
 /*  2510 */   337, 2136,  685, 2138, 2139,  680, 1736,  675, 1736,  682,
 /*  2520 */  1736, 1736, 1736, 1736, 1736, 1736, 2134, 1736, 2135, 2170,
 /*  2530 */  1736, 1736,  329, 2136,  685, 2138, 2139,  680,  682,  675,
 /*  2540 */  1736, 1736, 1736, 1736, 1736, 1736, 2153, 1736, 1736, 1736,
 /*  2550 */  1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736, 2103, 1736,
 /*  2560 */   681, 1736, 1736, 1736, 1736, 2153, 1736, 1736, 1736, 1736,
 /*  2570 */  1736, 1736, 1736, 1736, 1736, 1736, 1736, 2103, 1736,  681,
 /*  2580 */  1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736,
 /*  2590 */  1736, 1736, 2134, 1736, 2135, 2170, 1736, 1736,  338, 2136,
 /*  2600 */   685, 2138, 2139,  680,  682,  675, 1736, 1736, 1736, 1736,
 /*  2610 */  1736, 2134, 1736, 2135, 2170, 1736, 1736,  330, 2136,  685,
 /*  2620 */  2138, 2139,  680,  682,  675, 1736, 1736, 1736, 1736, 1736,
 /*  2630 */  1736, 2153, 1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736,
 /*  2640 */  1736, 1736, 1736, 2103, 2135,  681, 1736, 1736, 1736, 1736,
 /*  2650 */  2153, 1736, 1736, 1736,  682, 1736, 1736, 1736, 1736, 1736,
 /*  2660 */  1736, 1736, 2103, 1736,  681, 1736, 1736, 1736, 1736, 1736,
 /*  2670 */  1736, 1736, 1736, 1736, 1736, 1736, 1736, 2134, 1736, 1736,
 /*  2680 */  2170, 2153, 1736,  343, 2136,  685, 2138, 2139,  680, 1736,
 /*  2690 */   675, 1736, 1736, 2103, 1736,  681, 2134, 1736, 1736, 2170,
 /*  2700 */  1736, 1736,  344, 2136,  685, 2138, 2139,  680, 2135,  675,
 /*  2710 */  1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736,  682, 1736,
 /*  2720 */  1736, 1736, 1736, 1736, 1736, 1736, 1736, 2134, 1736, 2135,
 /*  2730 */  2170, 1736, 1736, 2147, 2136,  685, 2138, 2139,  680,  682,
 /*  2740 */   675, 1736, 1736, 1736, 1736, 2153, 1736, 1736, 1736, 1736,
 /*  2750 */  1736, 1736, 1736, 1736, 1736, 1736, 1736, 2103, 2135,  681,
 /*  2760 */  1736, 1736, 1736, 1736, 1736, 1736, 2153, 1736,  682, 1736,
 /*  2770 */  1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736, 2103, 1736,
 /*  2780 */   681, 1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736,
 /*  2790 */  1736, 2134, 1736, 1736, 2170, 2153, 1736, 2146, 2136,  685,
 /*  2800 */  2138, 2139,  680, 1736,  675, 1736, 1736, 2103, 1736,  681,
 /*  2810 */  1736, 1736, 2134, 1736, 1736, 2170, 2135, 1736, 2145, 2136,
 /*  2820 */   685, 2138, 2139,  680, 1736,  675,  682, 1736, 1736, 1736,
 /*  2830 */  1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736,
 /*  2840 */  1736, 2134, 1736, 1736, 2170, 1736, 2135,  358, 2136,  685,
 /*  2850 */  2138, 2139,  680, 2153,  675, 1736,  682, 1736, 1736, 1736,
 /*  2860 */  1736, 1736, 1736, 1736, 1736, 2103, 2135,  681, 1736, 1736,
 /*  2870 */  1736, 1736, 1736, 1736, 1736, 1736,  682, 1736, 1736, 1736,
 /*  2880 */  1736, 1736, 1736, 2153, 1736, 1736, 1736, 1736, 1736, 1736,
 /*  2890 */  1736, 1736, 1736, 1736, 1736, 2103, 1736,  681, 1736, 2134,
 /*  2900 */  1736, 1736, 2170, 2153, 1736,  359, 2136,  685, 2138, 2139,
 /*  2910 */   680, 1736,  675, 1736, 2135, 2103, 1736,  681, 1736, 1736,
 /*  2920 */  1736, 1736, 1736, 1736,  682, 1736, 1736, 1736, 1736, 2134,
 /*  2930 */  1736, 2135, 2170, 1736, 1736,  355, 2136,  685, 2138, 2139,
 /*  2940 */   680,  682,  675, 1736, 1736, 1736, 1736, 1736, 1736, 2134,
 /*  2950 */  1736, 2153, 2170, 1736, 1736,  360, 2136,  685, 2138, 2139,
 /*  2960 */   680, 1736,  675, 2103, 1736,  681, 1736, 1736, 2153, 1736,
 /*  2970 */  1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736, 1736,
 /*  2980 */  2103, 1736,  681, 1736, 1736, 1736, 1736, 1736, 1736, 1736,
 /*  2990 */  1736, 1736, 1736, 1736, 1736, 1736, 1736,  683, 1736, 1736,
 /*  3000 */  2170, 1736, 1736,  335, 2136,  685, 2138, 2139,  680, 1736,
 /*  3010 */   675, 1736, 1736, 1736, 2134, 1736, 1736, 2170, 1736, 1736,
 /*  3020 */   334, 2136,  685, 2138, 2139,  680, 1736,  675,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   336,  387,  340,  346,  383,  343,  344,  386,  387,  374,
 /*    10 */   346,  387,   12,   13,   14,    0,  402,  403,    2,  335,
 /*    20 */    20,  337,   22,  399,    8,    9,  402,  403,   12,   13,
 /*    30 */    14,   15,   16,   33,    0,   35,   21,  373,   20,   24,
 /*    40 */    25,   26,   27,   28,   29,   30,   31,   32,  391,  385,
 /*    50 */   365,  387,   20,   20,   22,   22,    8,    9,  373,   59,
 /*    60 */    12,   13,   14,   15,   16,   65,  381,   35,   20,  333,
 /*    70 */    64,   21,   72,  424,   24,   25,   26,   27,   28,   29,
 /*    80 */    30,   31,   32,  419,   52,   52,  422,  345,  346,  425,
 /*    90 */   426,  427,  428,  429,  430,    4,  432,   97,   20,  450,
 /*   100 */   100,   67,   68,   69,   70,   71,  364,   73,   74,   75,
 /*   110 */    76,   77,   78,   79,   80,   81,   82,   83,   84,   85,
 /*   120 */    86,   87,   88,   89,   90,   91,   92,   93,   59,  465,
 /*   130 */   466,  340,   97,  372,  343,  344,  136,  137,  345,  346,
 /*   140 */   404,   20,  404,  100,  408,  384,  408,  112,  113,  114,
 /*   150 */   115,  116,  117,  118,  119,  120,  121,  364,  123,  124,
 /*   160 */   125,  126,  127,  128,  371,   20,  166,  167,   99,   20,
 /*   170 */   373,  102,  172,  173,   20,    8,    9,  380,  100,   12,
 /*   180 */    13,   14,   15,   16,  351,  388,  186,  451,  188,  451,
 /*   190 */   454,  100,  454,  130,  131,    8,    9,   20,  135,   12,
 /*   200 */    13,   14,   15,   16,   22,  469,  470,  469,  470,  376,
 /*   210 */   474,  475,  474,  475,  345,  346,  168,   35,  218,  219,
 /*   220 */    20,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */   230,  231,  232,  233,  234,  235,  236,  237,  238,   12,
 /*   240 */    13,    0,  345,  346,   18,  165,   20,   20,  451,   22,
 /*   250 */   345,  454,   65,   27,  345,  346,   30,  136,  137,   33,
 /*   260 */    33,  364,   35,   64,  336,   33,  469,  470,  371,  361,
 /*   270 */   346,  474,  475,  364,  346,   49,   14,   51,    0,   97,
 /*   280 */    54,   49,   20,  375,  440,  441,   59,   55,   56,   57,
 /*   290 */    58,   59,   65,  385,  389,   20,  109,  373,  255,   72,
 /*   300 */   100,  373,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   310 */    32,  166,  167,  385,  181,  387,  447,  448,  449,  111,
 /*   320 */   451,  452,  242,  454,   97,   99,    4,  100,  100,   14,
 /*   330 */   422,   99,  252,  255,  102,   20,   22,  111,  469,  470,
 /*   340 */   432,  208,  209,  474,  475,  178,  255,  419,   20,   35,
 /*   350 */   422,  427,  165,  425,  426,  427,  428,  429,  430,  431,
 /*   360 */   432,  433,  434,  136,  137,   43,  140,   45,   46,  143,
 /*   370 */   144,  145,  146,  147,  148,  149,  150,  151,  152,  153,
 /*   380 */   154,  155,  156,  157,  158,  159,   72,  161,  162,  163,
 /*   390 */    14,   15,   16,  166,  167,  336,  155,    3,   18,  172,
 /*   400 */   173,  169,  170,   23,  451,  164,  174,  454,  176,  345,
 /*   410 */   346,   97,  131,  186,   20,  188,  135,   37,   38,  358,
 /*   420 */   359,   41,  469,  470,  386,  387,  194,  474,  475,  242,
 /*   430 */   243,  244,  245,  246,  247,  248,  249,  250,  251,  252,
 /*   440 */    60,   61,   62,   63,  385,  218,  219,  280,  221,  222,
 /*   450 */   223,  224,  225,  226,  227,  228,  229,  230,  231,  232,
 /*   460 */   233,  234,  235,  236,  237,  238,  239,   12,   13,   12,
 /*   470 */    13,   14,   15,   16,   20,   20,  195,   22,   22,  198,
 /*   480 */   100,  424,  201,  255,  203,   67,   68,   69,   33,  336,
 /*   490 */    35,   35,   74,   75,   76,  101,  168,  218,   80,  346,
 /*   500 */   186,  100,  188,   85,   86,   87,   88,  450,  373,   91,
 /*   510 */   446,  447,  448,  449,   59,  451,  452,  341,  138,  336,
 /*   520 */    65,  345,  354,  347,  345,  346,  373,   72,  393,  394,
 /*   530 */   362,  341,  218,  219,  171,  345,   47,  347,  385,  239,
 /*   540 */   387,  241,  361,  364,  265,  266,  267,  268,  269,  270,
 /*   550 */   271,   48,   97,   97,  100,  100,  375,  365,  178,  179,
 /*   560 */   180,  336,  168,  183,  346,  373,  385,  404,  385,  239,
 /*   570 */   130,  346,  419,  381,   35,  422,  196,  197,  425,  426,
 /*   580 */   427,  428,  429,  430,  369,  432,  185,  207,  187,  100,
 /*   590 */   210,  136,  137,  213,  214,  215,  216,  217,  373,  435,
 /*   600 */     8,    9,  438,  422,   12,   13,   14,   15,   16,  391,
 /*   610 */   385,   72,  387,  432,  451,  345,  346,  454,  217,  345,
 /*   620 */    72,  166,  167,  260,  261,  262,  336,  172,  173,  476,
 /*   630 */   477,  416,  469,  470,  364,  255,   44,  474,  475,  199,
 /*   640 */   200,  186,    0,  188,  419,    0,   21,  422,  345,  346,
 /*   650 */   425,  426,  427,  428,  429,  430,  255,  432,  404,   34,
 /*   660 */   435,   36,  437,  438,  439,  358,  359,  364,  443,  444,
 /*   670 */   396,  168,  398,  218,  219,  385,  221,  222,  223,  224,
 /*   680 */   225,  226,  227,  228,  229,  230,  231,  232,  233,  234,
 /*   690 */   235,  236,  237,  238,   12,   13,   14,  345,  346,  345,
 /*   700 */   336,   35,   20,  451,   22,  451,  454,  336,  454,  255,
 /*   710 */   346,  336,   67,   68,   69,   33,  364,   35,  336,   74,
 /*   720 */    75,   76,  470,  469,  470,   80,  474,  475,  474,  475,
 /*   730 */    85,   86,   87,   88,  345,  346,   91,  373,   72,    8,
 /*   740 */     9,   59,   14,   12,   13,   14,   15,   16,   20,  385,
 /*   750 */   396,  387,  398,  364,   72,  436,  385,  438,    8,    9,
 /*   760 */   385,   44,   12,   13,   14,   15,   16,  385,  345,  346,
 /*   770 */    59,  129,  130,  131,  132,  133,  134,  135,   14,   97,
 /*   780 */   345,  346,  100,  419,   20,  373,  422,  364,  336,  425,
 /*   790 */   426,  427,  428,  429,  430,    4,  432,  111,  346,  364,
 /*   800 */   348,  437,  373,  439,   12,   13,  394,  443,  444,  380,
 /*   810 */    19,  100,  451,  102,   20,  454,  424,  388,  136,  137,
 /*   820 */   456,    0,  345,  346,   33,  373,  382,   35,  464,  385,
 /*   830 */    72,  470,  101,  345,  346,  474,  475,  385,    0,  387,
 /*   840 */    49,  364,  450,  353,  374,   54,  373,  353,  166,  167,
 /*   850 */    59,  101,    2,  380,  172,  173,  345,  346,    8,    9,
 /*   860 */   370,  388,   12,   13,   14,   15,   16,    0,  186,  379,
 /*   870 */   188,  419,  345,  379,  422,  364,   20,  425,  426,  427,
 /*   880 */   428,  429,  430,  336,  432,  409,  345,  346,  346,  437,
 /*   890 */    99,  439,  336,  102,  166,  443,  444,    1,    2,  404,
 /*   900 */   218,  219,   64,  221,  222,  223,  224,  225,  226,  227,
 /*   910 */   228,  229,  230,  231,  232,  233,  234,  235,  236,  237,
 /*   920 */   238,   12,   13,  396,  336,  398,  345,  346,  373,   20,
 /*   930 */   166,   22,  385,  391,  346,  447,  448,  449,  336,  451,
 /*   940 */   452,  385,   33,  388,   35,  364,  451,  336,    3,  454,
 /*   950 */   129,  130,  131,  132,  133,  134,  135,  346,  436,  348,
 /*   960 */   438,  373,  168,  365,  469,  470,  255,    4,   59,  474,
 /*   970 */   475,  373,  336,  385,  351,  387,  345,  346,  380,  381,
 /*   980 */   188,   72,  345,  346,  373,   39,  388,  385,  447,  448,
 /*   990 */   449,  368,  451,  452,  277,  364,  385,  101,  387,  376,
 /*  1000 */   336,  364,   37,  365,  345,  346,   97,  419,  129,  100,
 /*  1010 */   422,  373,  133,  425,  426,  427,  428,  429,  430,  381,
 /*  1020 */   432,  385,  404,  364,  168,  437,  374,  439,  336,   81,
 /*  1030 */   419,  443,  444,  422,   20,  374,  425,  426,  427,  428,
 /*  1040 */   429,  430,  361,  432,  382,  136,  137,  385,  437,  385,
 /*  1050 */   439,  336,  464,   44,  443,  444,  375,    8,    9,  345,
 /*  1060 */   346,   12,   13,   14,   15,   16,  385,  374,  103,  451,
 /*  1070 */   105,  106,  454,  108,  336,  166,  167,  385,  364,  212,
 /*  1080 */   336,  172,  173,  373,  346,   20,  348,  469,  470,  141,
 /*  1090 */   142,  381,  474,  475,  129,  186,  366,  188,  133,  369,
 /*  1100 */   385,    8,    9,  422,  423,   12,   13,   14,   15,   16,
 /*  1110 */   336,  373,  164,  432,  129,  130,  131,  132,  133,  134,
 /*  1120 */   135,  360,  374,  385,  363,  387,  374,  218,  219,  385,
 /*  1130 */   221,  222,  223,  224,  225,  226,  227,  228,  229,  230,
 /*  1140 */   231,  232,  233,  234,  235,  236,  237,  238,   12,   13,
 /*  1150 */   136,  137,  382,   45,   46,  385,   20,  419,   22,  385,
 /*  1160 */   422,  336,  336,  425,  426,  427,  428,  429,  430,   33,
 /*  1170 */   432,   35,  346,  373,  348,  437,  336,  439,  345,  346,
 /*  1180 */   380,  443,  444,  373,   44,  336,  172,  173,  388,  336,
 /*  1190 */   380,  336,  253,  254,   42,   59,   44,  364,  388,  373,
 /*  1200 */   254,  346,   22,  348,  345,  346,    0,   42,   72,   44,
 /*  1210 */   385,  385,    0,  387,  202,   35,  204,  168,  111,  256,
 /*  1220 */   275,  104,   13,  364,  107,  385,  104,   13,  373,  107,
 /*  1230 */   362,  166,  104,   97,  385,  107,  100,    0,  385,   65,
 /*  1240 */   385,  101,  387,  104,   35,  419,  107,   44,  422,   35,
 /*  1250 */    44,  425,  426,  427,  428,  429,  430,    0,  432,   22,
 /*  1260 */    35,   49,    0,  437,    0,  439,   44,  160,   44,  443,
 /*  1270 */   444,   44,  136,  137,  419,   59,   44,  422,   44,   22,
 /*  1280 */   425,  426,  427,  428,  429,  430,   22,  432,  279,  136,
 /*  1290 */   137,   44,  437,   35,  439,   44,   12,   13,  443,  444,
 /*  1300 */     1,    2,  166,  167,  101,  100,   22,  337,  172,  173,
 /*  1310 */   395,  467,   50,  478,  361,  110,   13,   33,  102,   35,
 /*  1320 */    44,   44,  186,  101,  188,  101,   44,   44,  101,   44,
 /*  1330 */   349,   44,   44,  101,   44,  101,   44,   44,   35,   44,
 /*  1340 */   361,  461,  373,   59,  349,  395,  344,  346,  101,  395,
 /*  1350 */   384,  453,  101,  471,  218,  219,   72,  221,  222,  223,
 /*  1360 */   224,  225,  226,  227,  228,  229,  230,  231,  232,  233,
 /*  1370 */   234,  235,  236,  237,  238,  336,   13,  101,  101,  445,
 /*  1380 */   455,   97,  257,  101,  101,  346,  101,  348,  101,  101,
 /*  1390 */    49,  101,  218,  101,  101,  421,  101,  420,   35,   20,
 /*  1400 */   413,  201,  418,  353,  413,  353,  406,  184,   42,  392,
 /*  1410 */    20,  395,  373,  188,  392,  165,  390,   20,  345,  345,
 /*  1420 */   392,  390,  390,   98,  385,  357,  387,   96,  356,  345,
 /*  1430 */    95,  355,  345,  345,  345,   20,  338,   48,  342,  338,
 /*  1440 */   413,  342,   20,  353,  387,  353,  188,   20,   20,  347,
 /*  1450 */   405,  347,   53,  353,  338,  345,  353,  205,  419,  353,
 /*  1460 */   385,  422,  353,  350,  425,  426,  427,  428,  429,  430,
 /*  1470 */   186,  432,  188,  353,  336,  345,  437,  350,  439,  338,
 /*  1480 */   385,  417,  443,  444,  346,  373,  415,  373,  373,  192,
 /*  1490 */   385,  373,  373,  100,  373,  413,  373,  336,  351,  373,
 /*  1500 */   191,  351,  218,  219,  373,  373,  373,  346,  190,  412,
 /*  1510 */   264,  373,  345,  460,  460,  231,  232,  233,  234,  235,
 /*  1520 */   236,  237,  411,  385,  387,  387,  263,  385,  272,  395,
 /*  1530 */   395,  385,  463,  385,  373,  177,  385,  460,  459,  410,
 /*  1540 */   462,  274,  273,  400,  400,  421,  385,  258,  387,  458,
 /*  1550 */   278,  457,  281,  346,  473,  276,  254,  419,  472,  479,
 /*  1560 */   422,   20,  345,  425,  426,  427,  428,  429,  430,  424,
 /*  1570 */   432,  351,  351,  347,   20,  437,  398,  439,  385,  400,
 /*  1580 */   419,  443,  444,  422,  385,  336,  425,  426,  427,  428,
 /*  1590 */   429,  430,  400,  432,  170,  346,  385,    1,  437,  397,
 /*  1600 */   439,  100,  369,  385,  443,  444,  351,  346,  442,  100,
 /*  1610 */   351,  336,  377,  385,  385,   19,  385,  363,  345,  351,
 /*  1620 */    36,  346,  373,    0,  414,  339,  407,  367,    0,   33,
 /*  1630 */   352,  401,  338,  367,  385,  334,  387,  401,    0,   42,
 /*  1640 */     0,  367,   35,  211,   35,   49,   35,   35,  373,  211,
 /*  1650 */     0,   55,   56,   57,   58,   59,   35,   35,  211,  336,
 /*  1660 */   385,  211,  387,    0,    0,   35,    0,   22,  419,  346,
 /*  1670 */     0,  422,   35,  206,  425,  426,  427,  428,  429,  430,
 /*  1680 */     0,  432,  194,    0,  194,  188,  437,  195,  439,  186,
 /*  1690 */     0,    0,  443,  444,  419,   99,  373,  422,  102,    0,
 /*  1700 */   425,  426,  427,  428,  429,  430,  182,  432,  385,  181,
 /*  1710 */   387,    0,    0,    0,  439,   47,    0,    0,  443,  444,
 /*  1720 */    42,    0,  336,    0,    0,    0,    0,    0,    0,    0,
 /*  1730 */   134,  155,  346,   35,    0,  155,    0,    0,    0,    0,
 /*  1740 */     0,    0,  419,    0,    0,  422,    0,    0,  425,  426,
 /*  1750 */   427,  428,  429,  430,    0,  432,    0,    0,    0,  373,
 /*  1760 */     0,    0,  439,  139,   42,  169,  443,  444,    0,    0,
 /*  1770 */   174,  385,    0,  387,    0,    0,    0,   22,    0,    0,
 /*  1780 */     0,    0,    0,   48,   22,    0,   22,   35,    0,   59,
 /*  1790 */   194,   59,    0,   48,    0,    0,   47,   44,   39,    0,
 /*  1800 */    14,   59,    0,    0,   39,  419,   40,  336,  422,   42,
 /*  1810 */     0,  425,  426,  427,  428,  429,  430,  346,  432,  177,
 /*  1820 */    47,    0,   39,    0,   47,  439,   35,    0,   35,  443,
 /*  1830 */   444,    0,    0,    0,    0,   39,   66,   39,   49,   49,
 /*  1840 */   336,   35,    0,   39,  373,    0,   49,   35,   39,   49,
 /*  1850 */   346,    0,    0,    0,   35,    0,  385,  109,  387,   22,
 /*  1860 */    35,   44,   44,   35,   35,   35,    0,    0,   22,    0,
 /*  1870 */    35,  336,   22,   35,   35,   35,   22,  373,  107,   35,
 /*  1880 */    22,  346,   35,   35,    0,    0,    0,   51,   20,  385,
 /*  1890 */   419,  387,   35,  422,   35,   22,  425,  426,  427,  428,
 /*  1900 */   429,  430,  336,  432,    0,   35,   35,   35,  373,  101,
 /*  1910 */   439,  100,  346,  378,  100,  444,   35,   22,  168,    0,
 /*  1920 */   385,   22,  387,  419,  193,    0,  422,    0,  259,  425,
 /*  1930 */   426,  427,  428,  429,  430,  336,  432,    3,   44,  373,
 /*  1940 */   189,   48,    3,  100,  378,  346,   48,   44,   47,   44,
 /*  1950 */   101,  385,  168,  387,  419,  168,  100,  422,   98,   96,
 /*  1960 */   425,  426,  427,  428,  429,  430,  101,  432,   44,   47,
 /*  1970 */   466,  170,  373,   44,  259,  101,  100,  100,  100,  100,
 /*  1980 */   175,  101,   44,  101,  385,  419,  387,   35,  422,  101,
 /*  1990 */    35,  425,  426,  427,  428,  429,  430,  336,  432,   35,
 /*  2000 */    35,   35,   35,  101,   47,   47,   44,  346,  101,    0,
 /*  2010 */     0,    0,  336,    0,  100,   39,   47,  100,  419,  101,
 /*  2020 */   100,  422,  346,  100,  425,  426,  427,  428,  429,  430,
 /*  2030 */   100,  432,  101,  336,  373,  171,    0,   39,  110,   47,
 /*  2040 */   100,   44,   98,  346,  169,   98,  385,    2,  387,  373,
 /*  2050 */    22,  100,   47,  240,  378,  101,  100,   22,   35,   47,
 /*  2060 */   101,  385,   35,  387,  101,   35,  259,  468,  253,  101,
 /*  2070 */   373,  100,  100,  100,  100,   35,  101,  100,  100,  218,
 /*  2080 */   419,  111,  385,  422,  387,  101,  425,  426,  427,  428,
 /*  2090 */   429,  430,  101,  432,  100,  419,  101,   35,  422,  336,
 /*  2100 */   100,  425,  426,  427,  428,  429,  430,  220,  432,  346,
 /*  2110 */    35,  122,  122,   44,   35,  101,  419,  100,  122,  422,
 /*  2120 */   100,  122,  425,  426,  427,  428,  429,  430,   22,  432,
 /*  2130 */    66,  434,  100,  100,   35,   65,  373,   35,  477,   35,
 /*  2140 */    35,  378,   94,   35,   35,   35,   35,   44,  385,   72,
 /*  2150 */   387,   35,   35,   35,   22,   35,   35,   35,   72,   35,
 /*  2160 */    35,   35,  336,   35,   35,   22,   35,    0,   35,   39,
 /*  2170 */     0,   35,  346,   35,   39,    0,   49,  336,   39,    0,
 /*  2180 */    35,   39,  419,   49,    0,  422,   49,  346,  425,  426,
 /*  2190 */   427,  428,  429,  430,   35,  432,   49,   35,    0,  373,
 /*  2200 */    22,   21,   20,   22,  378,   22,   21,  480,  480,  480,
 /*  2210 */   480,  385,  480,  387,  373,  480,  480,  480,  480,  480,
 /*  2220 */   480,  480,  480,  480,  480,  480,  385,  336,  387,  480,
 /*  2230 */   480,  480,  480,  480,  480,  480,  480,  346,  480,  480,
 /*  2240 */   480,  480,  480,  480,  480,  419,  480,  336,  422,  480,
 /*  2250 */   480,  425,  426,  427,  428,  429,  430,  346,  432,  480,
 /*  2260 */   419,  480,  480,  422,  373,  480,  425,  426,  427,  428,
 /*  2270 */   429,  430,  480,  432,  480,  480,  385,  480,  387,  480,
 /*  2280 */   480,  480,  480,  480,  373,  480,  480,  480,  480,  480,
 /*  2290 */   480,  480,  480,  480,  480,  480,  385,  336,  387,  480,
 /*  2300 */   480,  480,  480,  480,  480,  480,  480,  346,  480,  480,
 /*  2310 */   419,  480,  480,  422,  480,  480,  425,  426,  427,  428,
 /*  2320 */   429,  430,  336,  432,  480,  480,  480,  480,  480,  480,
 /*  2330 */   419,  480,  346,  422,  373,  480,  425,  426,  427,  428,
 /*  2340 */   429,  430,  480,  432,  480,  480,  385,  480,  387,  480,
 /*  2350 */   480,  480,  480,  480,  480,  336,  480,  480,  480,  373,
 /*  2360 */   480,  480,  480,  480,  480,  346,  480,  480,  480,  480,
 /*  2370 */   480,  385,  480,  387,  480,  480,  480,  480,  480,  480,
 /*  2380 */   419,  480,  480,  422,  480,  336,  425,  426,  427,  428,
 /*  2390 */   429,  430,  373,  432,  480,  346,  480,  480,  480,  480,
 /*  2400 */   480,  480,  480,  480,  385,  419,  387,  480,  422,  480,
 /*  2410 */   480,  425,  426,  427,  428,  429,  430,  480,  432,  480,
 /*  2420 */   480,  336,  373,  480,  480,  480,  480,  480,  480,  480,
 /*  2430 */   480,  346,  480,  480,  385,  480,  387,  480,  419,  480,
 /*  2440 */   480,  422,  480,  336,  425,  426,  427,  428,  429,  430,
 /*  2450 */   480,  432,  480,  346,  480,  480,  480,  480,  373,  480,
 /*  2460 */   480,  480,  480,  480,  480,  480,  480,  480,  419,  480,
 /*  2470 */   385,  422,  387,  480,  425,  426,  427,  428,  429,  430,
 /*  2480 */   373,  432,  480,  480,  480,  480,  480,  480,  480,  480,
 /*  2490 */   480,  480,  385,  480,  387,  480,  480,  480,  480,  480,
 /*  2500 */   480,  480,  480,  480,  419,  480,  480,  422,  480,  336,
 /*  2510 */   425,  426,  427,  428,  429,  430,  480,  432,  480,  346,
 /*  2520 */   480,  480,  480,  480,  480,  480,  419,  480,  336,  422,
 /*  2530 */   480,  480,  425,  426,  427,  428,  429,  430,  346,  432,
 /*  2540 */   480,  480,  480,  480,  480,  480,  373,  480,  480,  480,
 /*  2550 */   480,  480,  480,  480,  480,  480,  480,  480,  385,  480,
 /*  2560 */   387,  480,  480,  480,  480,  373,  480,  480,  480,  480,
 /*  2570 */   480,  480,  480,  480,  480,  480,  480,  385,  480,  387,
 /*  2580 */   480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
 /*  2590 */   480,  480,  419,  480,  336,  422,  480,  480,  425,  426,
 /*  2600 */   427,  428,  429,  430,  346,  432,  480,  480,  480,  480,
 /*  2610 */   480,  419,  480,  336,  422,  480,  480,  425,  426,  427,
 /*  2620 */   428,  429,  430,  346,  432,  480,  480,  480,  480,  480,
 /*  2630 */   480,  373,  480,  480,  480,  480,  480,  480,  480,  480,
 /*  2640 */   480,  480,  480,  385,  336,  387,  480,  480,  480,  480,
 /*  2650 */   373,  480,  480,  480,  346,  480,  480,  480,  480,  480,
 /*  2660 */   480,  480,  385,  480,  387,  480,  480,  480,  480,  480,
 /*  2670 */   480,  480,  480,  480,  480,  480,  480,  419,  480,  480,
 /*  2680 */   422,  373,  480,  425,  426,  427,  428,  429,  430,  480,
 /*  2690 */   432,  480,  480,  385,  480,  387,  419,  480,  480,  422,
 /*  2700 */   480,  480,  425,  426,  427,  428,  429,  430,  336,  432,
 /*  2710 */   480,  480,  480,  480,  480,  480,  480,  480,  346,  480,
 /*  2720 */   480,  480,  480,  480,  480,  480,  480,  419,  480,  336,
 /*  2730 */   422,  480,  480,  425,  426,  427,  428,  429,  430,  346,
 /*  2740 */   432,  480,  480,  480,  480,  373,  480,  480,  480,  480,
 /*  2750 */   480,  480,  480,  480,  480,  480,  480,  385,  336,  387,
 /*  2760 */   480,  480,  480,  480,  480,  480,  373,  480,  346,  480,
 /*  2770 */   480,  480,  480,  480,  480,  480,  480,  480,  385,  480,
 /*  2780 */   387,  480,  480,  480,  480,  480,  480,  480,  480,  480,
 /*  2790 */   480,  419,  480,  480,  422,  373,  480,  425,  426,  427,
 /*  2800 */   428,  429,  430,  480,  432,  480,  480,  385,  480,  387,
 /*  2810 */   480,  480,  419,  480,  480,  422,  336,  480,  425,  426,
 /*  2820 */   427,  428,  429,  430,  480,  432,  346,  480,  480,  480,
 /*  2830 */   480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
 /*  2840 */   480,  419,  480,  480,  422,  480,  336,  425,  426,  427,
 /*  2850 */   428,  429,  430,  373,  432,  480,  346,  480,  480,  480,
 /*  2860 */   480,  480,  480,  480,  480,  385,  336,  387,  480,  480,
 /*  2870 */   480,  480,  480,  480,  480,  480,  346,  480,  480,  480,
 /*  2880 */   480,  480,  480,  373,  480,  480,  480,  480,  480,  480,
 /*  2890 */   480,  480,  480,  480,  480,  385,  480,  387,  480,  419,
 /*  2900 */   480,  480,  422,  373,  480,  425,  426,  427,  428,  429,
 /*  2910 */   430,  480,  432,  480,  336,  385,  480,  387,  480,  480,
 /*  2920 */   480,  480,  480,  480,  346,  480,  480,  480,  480,  419,
 /*  2930 */   480,  336,  422,  480,  480,  425,  426,  427,  428,  429,
 /*  2940 */   430,  346,  432,  480,  480,  480,  480,  480,  480,  419,
 /*  2950 */   480,  373,  422,  480,  480,  425,  426,  427,  428,  429,
 /*  2960 */   430,  480,  432,  385,  480,  387,  480,  480,  373,  480,
 /*  2970 */   480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
 /*  2980 */   385,  480,  387,  480,  480,  480,  480,  480,  480,  480,
 /*  2990 */   480,  480,  480,  480,  480,  480,  480,  419,  480,  480,
 /*  3000 */   422,  480,  480,  425,  426,  427,  428,  429,  430,  480,
 /*  3010 */   432,  480,  480,  480,  419,  480,  480,  422,  480,  480,
 /*  3020 */   425,  426,  427,  428,  429,  430,  480,  432,
};
#define YY_SHIFT_COUNT    (771)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2198)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   380,    0,  227,    0,  455,  455,  455,  455,  455,  455,
 /*    10 */   455,  455,  455,  455,  455,  455,  682,  909,  909, 1136,
 /*    20 */   909,  909,  909,  909,  909,  909,  909,  909,  909,  909,
 /*    30 */   909,  909,  909,  909,  909,  909,  909,  909,  909,  909,
 /*    40 */   909,  909,  909,  909,  909,  909,  909,  909,  909,  909,
 /*    50 */   909,   78,  454,  401,  200,  711,   43,  228,   43,  200,
 /*    60 */   200, 1284,   43, 1284, 1284,   91,   43,   18, 1014,  149,
 /*    70 */   149, 1014,  322,  322,  145,  121,  262,  262,  149,  149,
 /*    80 */   149,  149,  149,  149,  149,  154,  149,  149,    6,   18,
 /*    90 */   149,  149,  177,  149,   18,  149,  154,  149,  154,   18,
 /*   100 */   149,  149,   18,  149,   18,   18,   18,  149,  199,  226,
 /*   110 */   187,  187,  418,   50,  314,  314,  314,  314,  314,  314,
 /*   120 */   314,  314,  314,  314,  314,  314,  314,  314,  314,  314,
 /*   130 */   314,  314,  314,  965,  394,  145,  121,  539,  328,  328,
 /*   140 */   328,  838,  300,  300,  539,  275,  275,  275,    6,  208,
 /*   150 */   330,   18,  548,   18,  548,  548,  686,  758,   35,   35,
 /*   160 */    35,   35,   35,   35,   35,   35, 1596,  645,   15,   48,
 /*   170 */   167,  279,   32,  363,  792,  792,  728,  764,   33,  794,
 /*   180 */  1108,  315,  879,  856,  939,  946,  945,  939, 1152,  963,
 /*   190 */  1065, 1125, 1341, 1379, 1200,    6, 1379,    6, 1223, 1366,
 /*   200 */  1390, 1366, 1250, 1397, 1397, 1366, 1250, 1250, 1325, 1331,
 /*   210 */  1397, 1335, 1397, 1397, 1397, 1415, 1389, 1415, 1389, 1379,
 /*   220 */     6, 1422,    6, 1427, 1428,    6, 1427,    6,    6,    6,
 /*   230 */  1397,    6, 1399, 1399, 1415,   18,   18,   18,   18,   18,
 /*   240 */    18,   18,   18,   18,   18,   18, 1397, 1415,  548,  548,
 /*   250 */   548, 1252, 1393, 1379,  199, 1297, 1309, 1422,  199, 1318,
 /*   260 */  1397, 1390, 1390,  548, 1246, 1263,  548, 1246, 1263,  548,
 /*   270 */   548,   18, 1256, 1358, 1246, 1267, 1269, 1289, 1125, 1271,
 /*   280 */  1272, 1279, 1302,  275, 1541, 1397, 1427,  199,  199, 1554,
 /*   290 */  1263,  548,  548,  548,  548,  548, 1263,  548, 1424,  199,
 /*   300 */   686,  199,  275, 1501, 1509,  548,  758, 1397,  199, 1584,
 /*   310 */  1415, 3028, 3028, 3028, 3028, 3028, 3028, 3028, 3028, 3028,
 /*   320 */    34,  232,  278,  791,  731,  592,  750,  642,   16,  850,
 /*   330 */  1049,  821, 1093, 1093, 1093, 1093, 1093, 1093, 1093, 1093,
 /*   340 */  1093,  985,  281,  457,  457,  948,  133,  241,   69,  182,
 /*   350 */   456,  625,  440,   63,   63,  376,  896,   80,  376,  376,
 /*   360 */   376, 1212,  867, 1140, 1180, 1165, 1107, 1206, 1117, 1122,
 /*   370 */  1128, 1139, 1209, 1214, 1237, 1257, 1264, 1012, 1203, 1222,
 /*   380 */  1216, 1224, 1227, 1232, 1153,  717, 1009,  503, 1234, 1247,
 /*   390 */  1251, 1276, 1277, 1282, 1299, 1283, 1174, 1285,  489, 1287,
 /*   400 */  1288, 1290, 1292, 1293, 1295, 1205, 1225, 1258, 1303, 1363,
 /*   410 */   666, 1262, 1623, 1628, 1638, 1597, 1640, 1607, 1432, 1609,
 /*   420 */  1611, 1612, 1438, 1650, 1621, 1622, 1447, 1663, 1450, 1664,
 /*   430 */  1630, 1666, 1645, 1670, 1637, 1467, 1680, 1488, 1683, 1490,
 /*   440 */  1492, 1497, 1503, 1690, 1691, 1699, 1524, 1528, 1711, 1712,
 /*   450 */  1668, 1713, 1716, 1717, 1678, 1721, 1723, 1724, 1725, 1726,
 /*   460 */  1727, 1728, 1729, 1576, 1698, 1734, 1580, 1736, 1737, 1738,
 /*   470 */  1739, 1740, 1741, 1743, 1744, 1746, 1747, 1754, 1756, 1757,
 /*   480 */  1758, 1760, 1761, 1722, 1768, 1769, 1772, 1774, 1775, 1776,
 /*   490 */  1755, 1778, 1779, 1780, 1624, 1781, 1782, 1762, 1735, 1764,
 /*   500 */  1745, 1785, 1730, 1752, 1788, 1732, 1792, 1742, 1794, 1795,
 /*   510 */  1767, 1759, 1753, 1749, 1773, 1786, 1777, 1799, 1766, 1765,
 /*   520 */  1802, 1803, 1810, 1783, 1642, 1821, 1823, 1831, 1770, 1832,
 /*   530 */  1833, 1791, 1789, 1796, 1827, 1793, 1790, 1798, 1834, 1806,
 /*   540 */  1797, 1804, 1842, 1812, 1800, 1809, 1845, 1851, 1852, 1853,
 /*   550 */  1748, 1771, 1819, 1837, 1855, 1825, 1828, 1829, 1830, 1835,
 /*   560 */  1838, 1839, 1817, 1818, 1840, 1844, 1846, 1847, 1866, 1850,
 /*   570 */  1867, 1854, 1836, 1869, 1858, 1848, 1884, 1857, 1885, 1859,
 /*   580 */  1886, 1873, 1868, 1870, 1871, 1872, 1808, 1811, 1904, 1750,
 /*   590 */  1814, 1731, 1881, 1895, 1919, 1751, 1899, 1784, 1801, 1925,
 /*   600 */  1927, 1787, 1805, 1934, 1894, 1669, 1843, 1849, 1856, 1893,
 /*   610 */  1860, 1898, 1863, 1865, 1903, 1905, 1874, 1876, 1877, 1878,
 /*   620 */  1880, 1924, 1901, 1922, 1879, 1929, 1715, 1882, 1888, 1939,
 /*   630 */  1938, 1807, 1952, 1955, 1964, 1965, 1966, 1967, 1902, 1907,
 /*   640 */  1957, 1815, 1962, 1958, 2009, 2010, 2011, 2013, 1914, 1976,
 /*   650 */  1749, 1969, 1917, 1918, 1931, 1920, 1923, 1864, 1930, 2036,
 /*   660 */  1998, 1875, 1940, 1928, 1749, 1992, 1997, 1944, 1813, 1947,
 /*   670 */  2045, 2028, 1861, 1951, 1954, 1956, 1959, 1971, 1963, 2005,
 /*   680 */  1972, 1973, 2012, 1968, 2035, 1887, 1974, 1970, 1975, 2023,
 /*   690 */  2027, 1977, 1984, 2030, 1978, 1991, 2040, 1994, 1995, 2062,
 /*   700 */  2000, 2014, 2075, 2017, 1989, 1990, 1996, 1999, 2020, 2069,
 /*   710 */  2032, 2079, 2033, 2069, 2069, 2106, 2064, 2070, 2099, 2102,
 /*   720 */  2104, 2105, 2108, 2109, 2110, 2111, 2077, 2048, 2103, 2116,
 /*   730 */  2117, 2118, 2132, 2120, 2121, 2122, 2086, 1817, 2124, 1818,
 /*   740 */  2125, 2126, 2128, 2129, 2143, 2131, 2167, 2133, 2127, 2130,
 /*   750 */  2170, 2136, 2134, 2135, 2175, 2138, 2137, 2139, 2179, 2145,
 /*   760 */  2147, 2142, 2184, 2159, 2162, 2198, 2178, 2180, 2181, 2183,
 /*   770 */  2185, 2182,
};
#define YY_REDUCE_COUNT (319)
#define YY_REDUCE_MIN   (-386)
#define YY_REDUCE_MAX   (2595)
static const short yy_reduce_ofst[] = {
 /*     0 */  -264,  364,  225,  588,  452,  611,  738,  826,  855, 1039,
 /*    10 */  1138, 1161, 1249, 1275, 1323, 1386,  -72, -336,  153, 1471,
 /*    20 */  1504, 1535, 1566, 1599, 1661, 1676, 1697, 1763, 1826, 1841,
 /*    30 */  1891, 1911, 1961, 1986, 2019, 2049, 2085, 2107, 2173, 2192,
 /*    40 */  2258, 2277, 2308, 2372, 2393, 2422, 2480, 2510, 2530, 2578,
 /*    50 */  2595, -131, -203, -262,   64,  163,  254,  495,  618,  488,
 /*    60 */   541,  681,  -47,  -92,  181,  252,  361,  598, -376, -207,
 /*    70 */  -103, -386, -338, -209,  135, -379,  176,  190, -258,  -91,
 /*    80 */   179,  270,  303,  389,  423,  274,  435,  477,  490,  429,
 /*    90 */   511,  581,  -76,  352,  473,  631,  354,  637,  527, -315,
 /*   100 */   659,  714,  800,  833,  192,  810,  638,  859,  623,  -95,
 /*   110 */  -156, -156,  168, -316,   59,  183,  290,  371,  375,  382,
 /*   120 */   547,  556,  602,  636,  664,  692,  715,  744,  774,  825,
 /*   130 */   840,  849,  853, -239, -351,  412,   38,   61, -351,   57,
 /*   140 */   392, -167,  319,  522,  307, -343,  218,  542,  494,  215,
 /*   150 */   164,  710,  444,  555,  662,  770,  730,  761, -365,  470,
 /*   160 */   652,  661,  693,  748,  752,  693,  476,  868,  970,  915,
 /*   170 */   835,  844,  981,  880,  953,  979,  969,  969,  995,  950,
 /*   180 */  1002, 1001,  966,  954,  898,  898,  882,  898,  934,  925,
 /*   190 */   969,  974,  977,  987,  984, 1050,  991, 1052, 1000, 1017,
 /*   200 */  1016, 1022, 1026, 1073, 1074, 1028, 1031, 1032, 1068, 1072,
 /*   210 */  1084, 1076, 1087, 1088, 1089, 1098, 1096, 1101, 1099, 1027,
 /*   220 */  1090, 1057, 1092, 1102, 1045, 1100, 1104, 1103, 1106, 1109,
 /*   230 */  1110, 1120, 1113, 1127, 1116, 1112, 1114, 1115, 1118, 1119,
 /*   240 */  1121, 1123, 1126, 1131, 1132, 1133, 1130, 1141, 1075, 1095,
 /*   250 */  1105, 1064, 1071, 1082, 1147, 1097, 1111, 1137, 1150, 1129,
 /*   260 */  1167, 1134, 1135, 1142, 1053, 1143, 1146, 1054, 1144, 1148,
 /*   270 */  1151,  969, 1069, 1078, 1077, 1079, 1091, 1094, 1124, 1080,
 /*   280 */  1081, 1086,  898, 1207, 1145, 1217, 1226, 1220, 1221, 1178,
 /*   290 */  1179, 1193, 1199, 1211, 1218, 1228, 1192, 1229, 1202, 1255,
 /*   300 */  1233, 1259, 1261, 1166, 1235, 1231, 1254, 1273, 1268, 1286,
 /*   310 */  1294, 1219, 1210, 1230, 1236, 1260, 1266, 1274, 1278, 1301,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*    10 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*    20 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*    30 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*    40 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*    50 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*    60 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*    70 */  1734, 1734, 1734, 1734, 2007, 1734, 1734, 1734, 1734, 1734,
 /*    80 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1816, 1734,
 /*    90 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   100 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1814, 2000,
 /*   110 */  2225, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   120 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   130 */  1734, 1734, 1734, 1734, 2237, 1734, 1734, 1734, 2237, 2237,
 /*   140 */  2237, 1814, 2197, 2197, 1734, 1734, 1734, 1734, 1816, 2067,
 /*   150 */  1734, 1734, 1734, 1734, 1734, 1734, 1935, 1734, 1734, 1734,
 /*   160 */  1734, 1734, 1959, 1734, 1734, 1734, 2059, 1734, 1734, 2262,
 /*   170 */  2318, 1734, 1734, 2265, 1734, 1734, 1734, 1734, 1734, 2012,
 /*   180 */  1734, 1734, 1889, 2252, 2229, 2243, 2302, 2230, 2227, 2246,
 /*   190 */  1734, 2256, 1734, 1734, 2081, 1816, 1734, 1816, 2046, 2005,
 /*   200 */  1734, 2005, 2002, 1734, 1734, 2005, 2002, 2002, 1878, 1874,
 /*   210 */  1734, 1872, 1734, 1734, 1734, 1734, 1781, 1734, 1781, 1734,
 /*   220 */  1816, 1734, 1816, 1734, 1734, 1816, 1734, 1816, 1816, 1816,
 /*   230 */  1734, 1816, 1794, 1794, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   240 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   250 */  1734, 2079, 2065, 1734, 1814, 2057, 2055, 1734, 1814, 2053,
 /*   260 */  1734, 1734, 1734, 1734, 2273, 2271, 1734, 2273, 2271, 1734,
 /*   270 */  1734, 1734, 2287, 2283, 2273, 2291, 2289, 2258, 2256, 2321,
 /*   280 */  2308, 2304, 2243, 1734, 1734, 1734, 1734, 1814, 1814, 1734,
 /*   290 */  2271, 1734, 1734, 1734, 1734, 1734, 2271, 1734, 1734, 1814,
 /*   300 */  1734, 1814, 1734, 1734, 1905, 1734, 1734, 1734, 1814, 1766,
 /*   310 */  1734, 2048, 2070, 2030, 2030, 1938, 1938, 1938, 1817, 1739,
 /*   320 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   330 */  1734, 1734, 2286, 2285, 2152, 1734, 2201, 2200, 2199, 2190,
 /*   340 */  2151, 1901, 1734, 2150, 2149, 1734, 1734, 1734, 1734, 1734,
 /*   350 */  1734, 1734, 1734, 2021, 2020, 2143, 1734, 1734, 2144, 2142,
 /*   360 */  2141, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   370 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   380 */  1734, 1734, 1734, 1734, 1734, 2305, 2309, 1734, 1734, 1734,
 /*   390 */  1734, 1734, 1734, 1734, 2226, 1734, 1734, 1734, 2125, 1734,
 /*   400 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   410 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   420 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   430 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   440 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   450 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   460 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   470 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   480 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   490 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   500 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   510 */  1734, 1734, 1771, 2130, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   520 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   530 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   540 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   550 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   560 */  1734, 1734, 1855, 1854, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   570 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   580 */  1734, 1734, 1734, 1734, 1734, 1734, 2134, 1734, 1734, 1734,
 /*   590 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   600 */  1734, 1734, 1734, 2301, 2259, 1734, 1734, 1734, 1734, 1734,
 /*   610 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   620 */  1734, 1734, 1734, 2125, 1734, 2284, 1734, 1734, 2299, 1734,
 /*   630 */  2303, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 2236, 2232,
 /*   640 */  1734, 1734, 2228, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   650 */  2133, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   660 */  1734, 1734, 1734, 1734, 2124, 1734, 2187, 1734, 1734, 1734,
 /*   670 */  2221, 1734, 1734, 2172, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   680 */  1734, 1734, 1734, 2134, 1734, 2137, 1734, 1734, 1734, 1734,
 /*   690 */  1734, 1932, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   700 */  1734, 1734, 1734, 1734, 1917, 1915, 1914, 1913, 1734, 1945,
 /*   710 */  1734, 1734, 1734, 1941, 1940, 1734, 1734, 1734, 1734, 1734,
 /*   720 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1835, 1734,
 /*   730 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1827, 1734, 1826,
 /*   740 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   750 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   760 */  1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734, 1734,
 /*   770 */  1734, 1734,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*       WITH => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      START => nothing */
    0,  /*  TIMESTAMP => nothing */
  282,  /*        END => ABORT */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*   LANGUAGE => nothing */
    0,  /*    REPLACE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*      PAUSE => nothing */
    0,  /*     RESUME => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*  UNTREATED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*     LEADER => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  282,  /*      AFTER => ABORT */
  282,  /*     ATTACH => ABORT */
  282,  /*     BEFORE => ABORT */
  282,  /*      BEGIN => ABORT */
  282,  /*     BITAND => ABORT */
  282,  /*     BITNOT => ABORT */
  282,  /*      BITOR => ABORT */
  282,  /*     BLOCKS => ABORT */
  282,  /*     CHANGE => ABORT */
  282,  /*      COMMA => ABORT */
  282,  /*     CONCAT => ABORT */
  282,  /*   CONFLICT => ABORT */
  282,  /*       COPY => ABORT */
  282,  /*   DEFERRED => ABORT */
  282,  /* DELIMITERS => ABORT */
  282,  /*     DETACH => ABORT */
  282,  /*     DIVIDE => ABORT */
  282,  /*        DOT => ABORT */
  282,  /*       EACH => ABORT */
  282,  /*       FAIL => ABORT */
  282,  /*       FILE => ABORT */
  282,  /*        FOR => ABORT */
  282,  /*       GLOB => ABORT */
  282,  /*         ID => ABORT */
  282,  /*  IMMEDIATE => ABORT */
  282,  /*     IMPORT => ABORT */
  282,  /*  INITIALLY => ABORT */
  282,  /*    INSTEAD => ABORT */
  282,  /*     ISNULL => ABORT */
  282,  /*        KEY => ABORT */
  282,  /*    MODULES => ABORT */
  282,  /*  NK_BITNOT => ABORT */
  282,  /*    NK_SEMI => ABORT */
  282,  /*    NOTNULL => ABORT */
  282,  /*         OF => ABORT */
  282,  /*       PLUS => ABORT */
  282,  /*  PRIVILEGE => ABORT */
  282,  /*      RAISE => ABORT */
  282,  /*   RESTRICT => ABORT */
  282,  /*        ROW => ABORT */
  282,  /*       SEMI => ABORT */
  282,  /*       STAR => ABORT */
  282,  /*  STATEMENT => ABORT */
  282,  /*     STRICT => ABORT */
  282,  /*     STRING => ABORT */
  282,  /*      TIMES => ABORT */
  282,  /*     VALUES => ABORT */
  282,  /*   VARIABLE => ABORT */
  282,  /*       VIEW => ABORT */
  282,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "WITH",
  /*   49 */ "DNODE",
  /*   50 */ "PORT",
  /*   51 */ "DNODES",
  /*   52 */ "NK_IPTOKEN",
  /*   53 */ "FORCE",
  /*   54 */ "LOCAL",
  /*   55 */ "QNODE",
  /*   56 */ "BNODE",
  /*   57 */ "SNODE",
  /*   58 */ "MNODE",
  /*   59 */ "DATABASE",
  /*   60 */ "USE",
  /*   61 */ "FLUSH",
  /*   62 */ "TRIM",
  /*   63 */ "COMPACT",
  /*   64 */ "IF",
  /*   65 */ "NOT",
  /*   66 */ "EXISTS",
  /*   67 */ "BUFFER",
  /*   68 */ "CACHEMODEL",
  /*   69 */ "CACHESIZE",
  /*   70 */ "COMP",
  /*   71 */ "DURATION",
  /*   72 */ "NK_VARIABLE",
  /*   73 */ "MAXROWS",
  /*   74 */ "MINROWS",
  /*   75 */ "KEEP",
  /*   76 */ "PAGES",
  /*   77 */ "PAGESIZE",
  /*   78 */ "TSDB_PAGESIZE",
  /*   79 */ "PRECISION",
  /*   80 */ "REPLICA",
  /*   81 */ "VGROUPS",
  /*   82 */ "SINGLE_STABLE",
  /*   83 */ "RETENTIONS",
  /*   84 */ "SCHEMALESS",
  /*   85 */ "WAL_LEVEL",
  /*   86 */ "WAL_FSYNC_PERIOD",
  /*   87 */ "WAL_RETENTION_PERIOD",
  /*   88 */ "WAL_RETENTION_SIZE",
  /*   89 */ "WAL_ROLL_PERIOD",
  /*   90 */ "WAL_SEGMENT_SIZE",
  /*   91 */ "STT_TRIGGER",
  /*   92 */ "TABLE_PREFIX",
  /*   93 */ "TABLE_SUFFIX",
  /*   94 */ "NK_COLON",
  /*   95 */ "MAX_SPEED",
  /*   96 */ "START",
  /*   97 */ "TIMESTAMP",
  /*   98 */ "END",
  /*   99 */ "TABLE",
  /*  100 */ "NK_LP",
  /*  101 */ "NK_RP",
  /*  102 */ "STABLE",
  /*  103 */ "ADD",
  /*  104 */ "COLUMN",
  /*  105 */ "MODIFY",
  /*  106 */ "RENAME",
  /*  107 */ "TAG",
  /*  108 */ "SET",
  /*  109 */ "NK_EQ",
  /*  110 */ "USING",
  /*  111 */ "TAGS",
  /*  112 */ "BOOL",
  /*  113 */ "TINYINT",
  /*  114 */ "SMALLINT",
  /*  115 */ "INT",
  /*  116 */ "INTEGER",
  /*  117 */ "BIGINT",
  /*  118 */ "FLOAT",
  /*  119 */ "DOUBLE",
  /*  120 */ "BINARY",
  /*  121 */ "NCHAR",
  /*  122 */ "UNSIGNED",
  /*  123 */ "JSON",
  /*  124 */ "VARCHAR",
  /*  125 */ "MEDIUMBLOB",
  /*  126 */ "BLOB",
  /*  127 */ "VARBINARY",
  /*  128 */ "DECIMAL",
  /*  129 */ "COMMENT",
  /*  130 */ "MAX_DELAY",
  /*  131 */ "WATERMARK",
  /*  132 */ "ROLLUP",
  /*  133 */ "TTL",
  /*  134 */ "SMA",
  /*  135 */ "DELETE_MARK",
  /*  136 */ "FIRST",
  /*  137 */ "LAST",
  /*  138 */ "SHOW",
  /*  139 */ "PRIVILEGES",
  /*  140 */ "DATABASES",
  /*  141 */ "TABLES",
  /*  142 */ "STABLES",
  /*  143 */ "MNODES",
  /*  144 */ "QNODES",
  /*  145 */ "FUNCTIONS",
  /*  146 */ "INDEXES",
  /*  147 */ "ACCOUNTS",
  /*  148 */ "APPS",
  /*  149 */ "CONNECTIONS",
  /*  150 */ "LICENCES",
  /*  151 */ "GRANTS",
  /*  152 */ "QUERIES",
  /*  153 */ "SCORES",
  /*  154 */ "TOPICS",
  /*  155 */ "VARIABLES",
  /*  156 */ "CLUSTER",
  /*  157 */ "BNODES",
  /*  158 */ "SNODES",
  /*  159 */ "TRANSACTIONS",
  /*  160 */ "DISTRIBUTED",
  /*  161 */ "CONSUMERS",
  /*  162 */ "SUBSCRIPTIONS",
  /*  163 */ "VNODES",
  /*  164 */ "ALIVE",
  /*  165 */ "LIKE",
  /*  166 */ "TBNAME",
  /*  167 */ "QTAGS",
  /*  168 */ "AS",
  /*  169 */ "INDEX",
  /*  170 */ "FUNCTION",
  /*  171 */ "INTERVAL",
  /*  172 */ "COUNT",
  /*  173 */ "LAST_ROW",
  /*  174 */ "TOPIC",
  /*  175 */ "META",
  /*  176 */ "CONSUMER",
  /*  177 */ "GROUP",
  /*  178 */ "DESC",
  /*  179 */ "DESCRIBE",
  /*  180 */ "RESET",
  /*  181 */ "QUERY",
  /*  182 */ "CACHE",
  /*  183 */ "EXPLAIN",
  /*  184 */ "ANALYZE",
  /*  185 */ "VERBOSE",
  /*  186 */ "NK_BOOL",
  /*  187 */ "RATIO",
  /*  188 */ "NK_FLOAT",
  /*  189 */ "OUTPUTTYPE",
  /*  190 */ "AGGREGATE",
  /*  191 */ "BUFSIZE",
  /*  192 */ "LANGUAGE",
  /*  193 */ "REPLACE",
  /*  194 */ "STREAM",
  /*  195 */ "INTO",
  /*  196 */ "PAUSE",
  /*  197 */ "RESUME",
  /*  198 */ "TRIGGER",
  /*  199 */ "AT_ONCE",
  /*  200 */ "WINDOW_CLOSE",
  /*  201 */ "IGNORE",
  /*  202 */ "EXPIRED",
  /*  203 */ "FILL_HISTORY",
  /*  204 */ "UPDATE",
  /*  205 */ "SUBTABLE",
  /*  206 */ "UNTREATED",
  /*  207 */ "KILL",
  /*  208 */ "CONNECTION",
  /*  209 */ "TRANSACTION",
  /*  210 */ "BALANCE",
  /*  211 */ "VGROUP",
  /*  212 */ "LEADER",
  /*  213 */ "MERGE",
  /*  214 */ "REDISTRIBUTE",
  /*  215 */ "SPLIT",
  /*  216 */ "DELETE",
  /*  217 */ "INSERT",
  /*  218 */ "NULL",
  /*  219 */ "NK_QUESTION",
  /*  220 */ "NK_ARROW",
  /*  221 */ "ROWTS",
  /*  222 */ "QSTART",
  /*  223 */ "QEND",
  /*  224 */ "QDURATION",
  /*  225 */ "WSTART",
  /*  226 */ "WEND",
  /*  227 */ "WDURATION",
  /*  228 */ "IROWTS",
  /*  229 */ "ISFILLED",
  /*  230 */ "CAST",
  /*  231 */ "NOW",
  /*  232 */ "TODAY",
  /*  233 */ "TIMEZONE",
  /*  234 */ "CLIENT_VERSION",
  /*  235 */ "SERVER_VERSION",
  /*  236 */ "SERVER_STATUS",
  /*  237 */ "CURRENT_USER",
  /*  238 */ "CASE",
  /*  239 */ "WHEN",
  /*  240 */ "THEN",
  /*  241 */ "ELSE",
  /*  242 */ "BETWEEN",
  /*  243 */ "IS",
  /*  244 */ "NK_LT",
  /*  245 */ "NK_GT",
  /*  246 */ "NK_LE",
  /*  247 */ "NK_GE",
  /*  248 */ "NK_NE",
  /*  249 */ "MATCH",
  /*  250 */ "NMATCH",
  /*  251 */ "CONTAINS",
  /*  252 */ "IN",
  /*  253 */ "JOIN",
  /*  254 */ "INNER",
  /*  255 */ "SELECT",
  /*  256 */ "DISTINCT",
  /*  257 */ "WHERE",
  /*  258 */ "PARTITION",
  /*  259 */ "BY",
  /*  260 */ "SESSION",
  /*  261 */ "STATE_WINDOW",
  /*  262 */ "EVENT_WINDOW",
  /*  263 */ "SLIDING",
  /*  264 */ "FILL",
  /*  265 */ "VALUE",
  /*  266 */ "VALUE_F",
  /*  267 */ "NONE",
  /*  268 */ "PREV",
  /*  269 */ "NULL_F",
  /*  270 */ "LINEAR",
  /*  271 */ "NEXT",
  /*  272 */ "HAVING",
  /*  273 */ "RANGE",
  /*  274 */ "EVERY",
  /*  275 */ "ORDER",
  /*  276 */ "SLIMIT",
  /*  277 */ "SOFFSET",
  /*  278 */ "LIMIT",
  /*  279 */ "OFFSET",
  /*  280 */ "ASC",
  /*  281 */ "NULLS",
  /*  282 */ "ABORT",
  /*  283 */ "AFTER",
  /*  284 */ "ATTACH",
  /*  285 */ "BEFORE",
  /*  286 */ "BEGIN",
  /*  287 */ "BITAND",
  /*  288 */ "BITNOT",
  /*  289 */ "BITOR",
  /*  290 */ "BLOCKS",
  /*  291 */ "CHANGE",
  /*  292 */ "COMMA",
  /*  293 */ "CONCAT",
  /*  294 */ "CONFLICT",
  /*  295 */ "COPY",
  /*  296 */ "DEFERRED",
  /*  297 */ "DELIMITERS",
  /*  298 */ "DETACH",
  /*  299 */ "DIVIDE",
  /*  300 */ "DOT",
  /*  301 */ "EACH",
  /*  302 */ "FAIL",
  /*  303 */ "FILE",
  /*  304 */ "FOR",
  /*  305 */ "GLOB",
  /*  306 */ "ID",
  /*  307 */ "IMMEDIATE",
  /*  308 */ "IMPORT",
  /*  309 */ "INITIALLY",
  /*  310 */ "INSTEAD",
  /*  311 */ "ISNULL",
  /*  312 */ "KEY",
  /*  313 */ "MODULES",
  /*  314 */ "NK_BITNOT",
  /*  315 */ "NK_SEMI",
  /*  316 */ "NOTNULL",
  /*  317 */ "OF",
  /*  318 */ "PLUS",
  /*  319 */ "PRIVILEGE",
  /*  320 */ "RAISE",
  /*  321 */ "RESTRICT",
  /*  322 */ "ROW",
  /*  323 */ "SEMI",
  /*  324 */ "STAR",
  /*  325 */ "STATEMENT",
  /*  326 */ "STRICT",
  /*  327 */ "STRING",
  /*  328 */ "TIMES",
  /*  329 */ "VALUES",
  /*  330 */ "VARIABLE",
  /*  331 */ "VIEW",
  /*  332 */ "WAL",
  /*  333 */ "cmd",
  /*  334 */ "account_options",
  /*  335 */ "alter_account_options",
  /*  336 */ "literal",
  /*  337 */ "alter_account_option",
  /*  338 */ "user_name",
  /*  339 */ "sysinfo_opt",
  /*  340 */ "privileges",
  /*  341 */ "priv_level",
  /*  342 */ "with_opt",
  /*  343 */ "priv_type_list",
  /*  344 */ "priv_type",
  /*  345 */ "db_name",
  /*  346 */ "table_name",
  /*  347 */ "topic_name",
  /*  348 */ "search_condition",
  /*  349 */ "dnode_endpoint",
  /*  350 */ "force_opt",
  /*  351 */ "not_exists_opt",
  /*  352 */ "db_options",
  /*  353 */ "exists_opt",
  /*  354 */ "alter_db_options",
  /*  355 */ "speed_opt",
  /*  356 */ "start_opt",
  /*  357 */ "end_opt",
  /*  358 */ "integer_list",
  /*  359 */ "variable_list",
  /*  360 */ "retention_list",
  /*  361 */ "signed",
  /*  362 */ "alter_db_option",
  /*  363 */ "retention",
  /*  364 */ "full_table_name",
  /*  365 */ "column_def_list",
  /*  366 */ "tags_def_opt",
  /*  367 */ "table_options",
  /*  368 */ "multi_create_clause",
  /*  369 */ "tags_def",
  /*  370 */ "multi_drop_clause",
  /*  371 */ "alter_table_clause",
  /*  372 */ "alter_table_options",
  /*  373 */ "column_name",
  /*  374 */ "type_name",
  /*  375 */ "signed_literal",
  /*  376 */ "create_subtable_clause",
  /*  377 */ "specific_cols_opt",
  /*  378 */ "expression_list",
  /*  379 */ "drop_table_clause",
  /*  380 */ "col_name_list",
  /*  381 */ "column_def",
  /*  382 */ "duration_list",
  /*  383 */ "rollup_func_list",
  /*  384 */ "alter_table_option",
  /*  385 */ "duration_literal",
  /*  386 */ "rollup_func_name",
  /*  387 */ "function_name",
  /*  388 */ "col_name",
  /*  389 */ "db_name_cond_opt",
  /*  390 */ "like_pattern_opt",
  /*  391 */ "table_name_cond",
  /*  392 */ "from_db_opt",
  /*  393 */ "tag_list_opt",
  /*  394 */ "tag_item",
  /*  395 */ "column_alias",
  /*  396 */ "full_index_name",
  /*  397 */ "index_options",
  /*  398 */ "index_name",
  /*  399 */ "func_list",
  /*  400 */ "sliding_opt",
  /*  401 */ "sma_stream_opt",
  /*  402 */ "func",
  /*  403 */ "sma_func_name",
  /*  404 */ "query_or_subquery",
  /*  405 */ "cgroup_name",
  /*  406 */ "analyze_opt",
  /*  407 */ "explain_options",
  /*  408 */ "insert_query",
  /*  409 */ "or_replace_opt",
  /*  410 */ "agg_func_opt",
  /*  411 */ "bufsize_opt",
  /*  412 */ "language_opt",
  /*  413 */ "stream_name",
  /*  414 */ "stream_options",
  /*  415 */ "col_list_opt",
  /*  416 */ "tag_def_or_ref_opt",
  /*  417 */ "subtable_opt",
  /*  418 */ "ignore_opt",
  /*  419 */ "expression",
  /*  420 */ "dnode_list",
  /*  421 */ "where_clause_opt",
  /*  422 */ "literal_func",
  /*  423 */ "literal_list",
  /*  424 */ "table_alias",
  /*  425 */ "expr_or_subquery",
  /*  426 */ "pseudo_column",
  /*  427 */ "column_reference",
  /*  428 */ "function_expression",
  /*  429 */ "case_when_expression",
  /*  430 */ "star_func",
  /*  431 */ "star_func_para_list",
  /*  432 */ "noarg_func",
  /*  433 */ "other_para_list",
  /*  434 */ "star_func_para",
  /*  435 */ "when_then_list",
  /*  436 */ "case_when_else_opt",
  /*  437 */ "common_expression",
  /*  438 */ "when_then_expr",
  /*  439 */ "predicate",
  /*  440 */ "compare_op",
  /*  441 */ "in_op",
  /*  442 */ "in_predicate_value",
  /*  443 */ "boolean_value_expression",
  /*  444 */ "boolean_primary",
  /*  445 */ "from_clause_opt",
  /*  446 */ "table_reference_list",
  /*  447 */ "table_reference",
  /*  448 */ "table_primary",
  /*  449 */ "joined_table",
  /*  450 */ "alias_opt",
  /*  451 */ "subquery",
  /*  452 */ "parenthesized_joined_table",
  /*  453 */ "join_type",
  /*  454 */ "query_specification",
  /*  455 */ "set_quantifier_opt",
  /*  456 */ "select_list",
  /*  457 */ "partition_by_clause_opt",
  /*  458 */ "range_opt",
  /*  459 */ "every_opt",
  /*  460 */ "fill_opt",
  /*  461 */ "twindow_clause_opt",
  /*  462 */ "group_by_clause_opt",
  /*  463 */ "having_clause_opt",
  /*  464 */ "select_item",
  /*  465 */ "partition_list",
  /*  466 */ "partition_item",
  /*  467 */ "fill_mode",
  /*  468 */ "group_by_list",
  /*  469 */ "query_expression",
  /*  470 */ "query_simple",
  /*  471 */ "order_by_clause_opt",
  /*  472 */ "slimit_clause_opt",
  /*  473 */ "limit_clause_opt",
  /*  474 */ "union_query_expression",
  /*  475 */ "query_simple_or_subquery",
  /*  476 */ "sort_specification_list",
  /*  477 */ "sort_specification",
  /*  478 */ "ordering_specification_opt",
  /*  479 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level with_opt TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= db_name NK_DOT table_name",
 /*  43 */ "priv_level ::= topic_name",
 /*  44 */ "with_opt ::=",
 /*  45 */ "with_opt ::= WITH search_condition",
 /*  46 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  47 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  48 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  49 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  50 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  51 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  52 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  53 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  54 */ "dnode_endpoint ::= NK_STRING",
 /*  55 */ "dnode_endpoint ::= NK_ID",
 /*  56 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  57 */ "force_opt ::=",
 /*  58 */ "force_opt ::= FORCE",
 /*  59 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  60 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  61 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  67 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  68 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  69 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  70 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  71 */ "cmd ::= USE db_name",
 /*  72 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  73 */ "cmd ::= FLUSH DATABASE db_name",
 /*  74 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  75 */ "cmd ::= COMPACT DATABASE db_name start_opt end_opt",
 /*  76 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  77 */ "not_exists_opt ::=",
 /*  78 */ "exists_opt ::= IF EXISTS",
 /*  79 */ "exists_opt ::=",
 /*  80 */ "db_options ::=",
 /*  81 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  82 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  83 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  84 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  85 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  86 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  87 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  88 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  89 */ "db_options ::= db_options KEEP integer_list",
 /*  90 */ "db_options ::= db_options KEEP variable_list",
 /*  91 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  92 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  93 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  94 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  95 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  96 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  97 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  98 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  99 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 106 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 107 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 108 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 109 */ "db_options ::= db_options TABLE_PREFIX signed",
 /* 110 */ "db_options ::= db_options TABLE_SUFFIX signed",
 /* 111 */ "alter_db_options ::= alter_db_option",
 /* 112 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 113 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 114 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 115 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 116 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 117 */ "alter_db_option ::= KEEP integer_list",
 /* 118 */ "alter_db_option ::= KEEP variable_list",
 /* 119 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 120 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 121 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 122 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 123 */ "alter_db_option ::= MINROWS NK_INTEGER",
 /* 124 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER",
 /* 125 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 126 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER",
 /* 127 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 128 */ "integer_list ::= NK_INTEGER",
 /* 129 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 130 */ "variable_list ::= NK_VARIABLE",
 /* 131 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 132 */ "retention_list ::= retention",
 /* 133 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 134 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 135 */ "speed_opt ::=",
 /* 136 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 137 */ "start_opt ::=",
 /* 138 */ "start_opt ::= START WITH NK_INTEGER",
 /* 139 */ "start_opt ::= START WITH NK_STRING",
 /* 140 */ "start_opt ::= START WITH TIMESTAMP NK_STRING",
 /* 141 */ "end_opt ::=",
 /* 142 */ "end_opt ::= END WITH NK_INTEGER",
 /* 143 */ "end_opt ::= END WITH NK_STRING",
 /* 144 */ "end_opt ::= END WITH TIMESTAMP NK_STRING",
 /* 145 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 146 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 147 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 148 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 149 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 150 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 151 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 152 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 153 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 154 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 155 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 156 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 157 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 158 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 159 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 160 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 161 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 162 */ "multi_create_clause ::= create_subtable_clause",
 /* 163 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 164 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 165 */ "multi_drop_clause ::= drop_table_clause",
 /* 166 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 167 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 168 */ "specific_cols_opt ::=",
 /* 169 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 170 */ "full_table_name ::= table_name",
 /* 171 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 172 */ "column_def_list ::= column_def",
 /* 173 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 174 */ "column_def ::= column_name type_name",
 /* 175 */ "type_name ::= BOOL",
 /* 176 */ "type_name ::= TINYINT",
 /* 177 */ "type_name ::= SMALLINT",
 /* 178 */ "type_name ::= INT",
 /* 179 */ "type_name ::= INTEGER",
 /* 180 */ "type_name ::= BIGINT",
 /* 181 */ "type_name ::= FLOAT",
 /* 182 */ "type_name ::= DOUBLE",
 /* 183 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 184 */ "type_name ::= TIMESTAMP",
 /* 185 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 186 */ "type_name ::= TINYINT UNSIGNED",
 /* 187 */ "type_name ::= SMALLINT UNSIGNED",
 /* 188 */ "type_name ::= INT UNSIGNED",
 /* 189 */ "type_name ::= BIGINT UNSIGNED",
 /* 190 */ "type_name ::= JSON",
 /* 191 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 192 */ "type_name ::= MEDIUMBLOB",
 /* 193 */ "type_name ::= BLOB",
 /* 194 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 195 */ "type_name ::= DECIMAL",
 /* 196 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 197 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 198 */ "tags_def_opt ::=",
 /* 199 */ "tags_def_opt ::= tags_def",
 /* 200 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 201 */ "table_options ::=",
 /* 202 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 203 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 204 */ "table_options ::= table_options WATERMARK duration_list",
 /* 205 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 206 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 207 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 208 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 209 */ "alter_table_options ::= alter_table_option",
 /* 210 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 211 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 212 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 213 */ "duration_list ::= duration_literal",
 /* 214 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 215 */ "rollup_func_list ::= rollup_func_name",
 /* 216 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 217 */ "rollup_func_name ::= function_name",
 /* 218 */ "rollup_func_name ::= FIRST",
 /* 219 */ "rollup_func_name ::= LAST",
 /* 220 */ "col_name_list ::= col_name",
 /* 221 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 222 */ "col_name ::= column_name",
 /* 223 */ "cmd ::= SHOW DNODES",
 /* 224 */ "cmd ::= SHOW USERS",
 /* 225 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 226 */ "cmd ::= SHOW DATABASES",
 /* 227 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 228 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 229 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 230 */ "cmd ::= SHOW MNODES",
 /* 231 */ "cmd ::= SHOW QNODES",
 /* 232 */ "cmd ::= SHOW FUNCTIONS",
 /* 233 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 234 */ "cmd ::= SHOW STREAMS",
 /* 235 */ "cmd ::= SHOW ACCOUNTS",
 /* 236 */ "cmd ::= SHOW APPS",
 /* 237 */ "cmd ::= SHOW CONNECTIONS",
 /* 238 */ "cmd ::= SHOW LICENCES",
 /* 239 */ "cmd ::= SHOW GRANTS",
 /* 240 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 241 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 242 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 243 */ "cmd ::= SHOW QUERIES",
 /* 244 */ "cmd ::= SHOW SCORES",
 /* 245 */ "cmd ::= SHOW TOPICS",
 /* 246 */ "cmd ::= SHOW VARIABLES",
 /* 247 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 248 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 249 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 250 */ "cmd ::= SHOW BNODES",
 /* 251 */ "cmd ::= SHOW SNODES",
 /* 252 */ "cmd ::= SHOW CLUSTER",
 /* 253 */ "cmd ::= SHOW TRANSACTIONS",
 /* 254 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 255 */ "cmd ::= SHOW CONSUMERS",
 /* 256 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 257 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 258 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 259 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 260 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 261 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 262 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 263 */ "db_name_cond_opt ::=",
 /* 264 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 265 */ "like_pattern_opt ::=",
 /* 266 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 267 */ "table_name_cond ::= table_name",
 /* 268 */ "from_db_opt ::=",
 /* 269 */ "from_db_opt ::= FROM db_name",
 /* 270 */ "tag_list_opt ::=",
 /* 271 */ "tag_list_opt ::= tag_item",
 /* 272 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 273 */ "tag_item ::= TBNAME",
 /* 274 */ "tag_item ::= QTAGS",
 /* 275 */ "tag_item ::= column_name",
 /* 276 */ "tag_item ::= column_name column_alias",
 /* 277 */ "tag_item ::= column_name AS column_alias",
 /* 278 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 279 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 280 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 281 */ "full_index_name ::= index_name",
 /* 282 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 283 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 284 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 285 */ "func_list ::= func",
 /* 286 */ "func_list ::= func_list NK_COMMA func",
 /* 287 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 288 */ "sma_func_name ::= function_name",
 /* 289 */ "sma_func_name ::= COUNT",
 /* 290 */ "sma_func_name ::= FIRST",
 /* 291 */ "sma_func_name ::= LAST",
 /* 292 */ "sma_func_name ::= LAST_ROW",
 /* 293 */ "sma_stream_opt ::=",
 /* 294 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 295 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 296 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 297 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 298 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 299 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 300 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 301 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 302 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 303 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 304 */ "cmd ::= DESC full_table_name",
 /* 305 */ "cmd ::= DESCRIBE full_table_name",
 /* 306 */ "cmd ::= RESET QUERY CACHE",
 /* 307 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 308 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 309 */ "analyze_opt ::=",
 /* 310 */ "analyze_opt ::= ANALYZE",
 /* 311 */ "explain_options ::=",
 /* 312 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 313 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 314 */ "cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt",
 /* 315 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 316 */ "agg_func_opt ::=",
 /* 317 */ "agg_func_opt ::= AGGREGATE",
 /* 318 */ "bufsize_opt ::=",
 /* 319 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 320 */ "language_opt ::=",
 /* 321 */ "language_opt ::= LANGUAGE NK_STRING",
 /* 322 */ "or_replace_opt ::=",
 /* 323 */ "or_replace_opt ::= OR REPLACE",
 /* 324 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 325 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 326 */ "cmd ::= PAUSE STREAM exists_opt stream_name",
 /* 327 */ "cmd ::= RESUME STREAM exists_opt ignore_opt stream_name",
 /* 328 */ "col_list_opt ::=",
 /* 329 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 330 */ "tag_def_or_ref_opt ::=",
 /* 331 */ "tag_def_or_ref_opt ::= tags_def",
 /* 332 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 333 */ "stream_options ::=",
 /* 334 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 335 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 336 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 337 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 338 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 339 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 340 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 341 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 342 */ "subtable_opt ::=",
 /* 343 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 344 */ "ignore_opt ::=",
 /* 345 */ "ignore_opt ::= IGNORE UNTREATED",
 /* 346 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 347 */ "cmd ::= KILL QUERY NK_STRING",
 /* 348 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 349 */ "cmd ::= BALANCE VGROUP",
 /* 350 */ "cmd ::= BALANCE VGROUP LEADER",
 /* 351 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 352 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 353 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 354 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 355 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 356 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 357 */ "cmd ::= query_or_subquery",
 /* 358 */ "cmd ::= insert_query",
 /* 359 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 360 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 361 */ "literal ::= NK_INTEGER",
 /* 362 */ "literal ::= NK_FLOAT",
 /* 363 */ "literal ::= NK_STRING",
 /* 364 */ "literal ::= NK_BOOL",
 /* 365 */ "literal ::= TIMESTAMP NK_STRING",
 /* 366 */ "literal ::= duration_literal",
 /* 367 */ "literal ::= NULL",
 /* 368 */ "literal ::= NK_QUESTION",
 /* 369 */ "duration_literal ::= NK_VARIABLE",
 /* 370 */ "signed ::= NK_INTEGER",
 /* 371 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 372 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 373 */ "signed ::= NK_FLOAT",
 /* 374 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 375 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 376 */ "signed_literal ::= signed",
 /* 377 */ "signed_literal ::= NK_STRING",
 /* 378 */ "signed_literal ::= NK_BOOL",
 /* 379 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 380 */ "signed_literal ::= duration_literal",
 /* 381 */ "signed_literal ::= NULL",
 /* 382 */ "signed_literal ::= literal_func",
 /* 383 */ "signed_literal ::= NK_QUESTION",
 /* 384 */ "literal_list ::= signed_literal",
 /* 385 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 386 */ "db_name ::= NK_ID",
 /* 387 */ "table_name ::= NK_ID",
 /* 388 */ "column_name ::= NK_ID",
 /* 389 */ "function_name ::= NK_ID",
 /* 390 */ "table_alias ::= NK_ID",
 /* 391 */ "column_alias ::= NK_ID",
 /* 392 */ "user_name ::= NK_ID",
 /* 393 */ "topic_name ::= NK_ID",
 /* 394 */ "stream_name ::= NK_ID",
 /* 395 */ "cgroup_name ::= NK_ID",
 /* 396 */ "index_name ::= NK_ID",
 /* 397 */ "expr_or_subquery ::= expression",
 /* 398 */ "expression ::= literal",
 /* 399 */ "expression ::= pseudo_column",
 /* 400 */ "expression ::= column_reference",
 /* 401 */ "expression ::= function_expression",
 /* 402 */ "expression ::= case_when_expression",
 /* 403 */ "expression ::= NK_LP expression NK_RP",
 /* 404 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 405 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 406 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 407 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 408 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 409 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 410 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 411 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 412 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 413 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 414 */ "expression_list ::= expr_or_subquery",
 /* 415 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 416 */ "column_reference ::= column_name",
 /* 417 */ "column_reference ::= table_name NK_DOT column_name",
 /* 418 */ "pseudo_column ::= ROWTS",
 /* 419 */ "pseudo_column ::= TBNAME",
 /* 420 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 421 */ "pseudo_column ::= QSTART",
 /* 422 */ "pseudo_column ::= QEND",
 /* 423 */ "pseudo_column ::= QDURATION",
 /* 424 */ "pseudo_column ::= WSTART",
 /* 425 */ "pseudo_column ::= WEND",
 /* 426 */ "pseudo_column ::= WDURATION",
 /* 427 */ "pseudo_column ::= IROWTS",
 /* 428 */ "pseudo_column ::= ISFILLED",
 /* 429 */ "pseudo_column ::= QTAGS",
 /* 430 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 431 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 432 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 433 */ "function_expression ::= literal_func",
 /* 434 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 435 */ "literal_func ::= NOW",
 /* 436 */ "noarg_func ::= NOW",
 /* 437 */ "noarg_func ::= TODAY",
 /* 438 */ "noarg_func ::= TIMEZONE",
 /* 439 */ "noarg_func ::= DATABASE",
 /* 440 */ "noarg_func ::= CLIENT_VERSION",
 /* 441 */ "noarg_func ::= SERVER_VERSION",
 /* 442 */ "noarg_func ::= SERVER_STATUS",
 /* 443 */ "noarg_func ::= CURRENT_USER",
 /* 444 */ "noarg_func ::= USER",
 /* 445 */ "star_func ::= COUNT",
 /* 446 */ "star_func ::= FIRST",
 /* 447 */ "star_func ::= LAST",
 /* 448 */ "star_func ::= LAST_ROW",
 /* 449 */ "star_func_para_list ::= NK_STAR",
 /* 450 */ "star_func_para_list ::= other_para_list",
 /* 451 */ "other_para_list ::= star_func_para",
 /* 452 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 453 */ "star_func_para ::= expr_or_subquery",
 /* 454 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 455 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 456 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 457 */ "when_then_list ::= when_then_expr",
 /* 458 */ "when_then_list ::= when_then_list when_then_expr",
 /* 459 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 460 */ "case_when_else_opt ::=",
 /* 461 */ "case_when_else_opt ::= ELSE common_expression",
 /* 462 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 463 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 464 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 465 */ "predicate ::= expr_or_subquery IS NULL",
 /* 466 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 467 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 468 */ "compare_op ::= NK_LT",
 /* 469 */ "compare_op ::= NK_GT",
 /* 470 */ "compare_op ::= NK_LE",
 /* 471 */ "compare_op ::= NK_GE",
 /* 472 */ "compare_op ::= NK_NE",
 /* 473 */ "compare_op ::= NK_EQ",
 /* 474 */ "compare_op ::= LIKE",
 /* 475 */ "compare_op ::= NOT LIKE",
 /* 476 */ "compare_op ::= MATCH",
 /* 477 */ "compare_op ::= NMATCH",
 /* 478 */ "compare_op ::= CONTAINS",
 /* 479 */ "in_op ::= IN",
 /* 480 */ "in_op ::= NOT IN",
 /* 481 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 482 */ "boolean_value_expression ::= boolean_primary",
 /* 483 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 484 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 485 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 486 */ "boolean_primary ::= predicate",
 /* 487 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 488 */ "common_expression ::= expr_or_subquery",
 /* 489 */ "common_expression ::= boolean_value_expression",
 /* 490 */ "from_clause_opt ::=",
 /* 491 */ "from_clause_opt ::= FROM table_reference_list",
 /* 492 */ "table_reference_list ::= table_reference",
 /* 493 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 494 */ "table_reference ::= table_primary",
 /* 495 */ "table_reference ::= joined_table",
 /* 496 */ "table_primary ::= table_name alias_opt",
 /* 497 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 498 */ "table_primary ::= subquery alias_opt",
 /* 499 */ "table_primary ::= parenthesized_joined_table",
 /* 500 */ "alias_opt ::=",
 /* 501 */ "alias_opt ::= table_alias",
 /* 502 */ "alias_opt ::= AS table_alias",
 /* 503 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 504 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 505 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 506 */ "join_type ::=",
 /* 507 */ "join_type ::= INNER",
 /* 508 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 509 */ "set_quantifier_opt ::=",
 /* 510 */ "set_quantifier_opt ::= DISTINCT",
 /* 511 */ "set_quantifier_opt ::= ALL",
 /* 512 */ "select_list ::= select_item",
 /* 513 */ "select_list ::= select_list NK_COMMA select_item",
 /* 514 */ "select_item ::= NK_STAR",
 /* 515 */ "select_item ::= common_expression",
 /* 516 */ "select_item ::= common_expression column_alias",
 /* 517 */ "select_item ::= common_expression AS column_alias",
 /* 518 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 519 */ "where_clause_opt ::=",
 /* 520 */ "where_clause_opt ::= WHERE search_condition",
 /* 521 */ "partition_by_clause_opt ::=",
 /* 522 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 523 */ "partition_list ::= partition_item",
 /* 524 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 525 */ "partition_item ::= expr_or_subquery",
 /* 526 */ "partition_item ::= expr_or_subquery column_alias",
 /* 527 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 528 */ "twindow_clause_opt ::=",
 /* 529 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 530 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 531 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 532 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 533 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 534 */ "sliding_opt ::=",
 /* 535 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 536 */ "fill_opt ::=",
 /* 537 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 538 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP",
 /* 539 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP",
 /* 540 */ "fill_mode ::= NONE",
 /* 541 */ "fill_mode ::= PREV",
 /* 542 */ "fill_mode ::= NULL",
 /* 543 */ "fill_mode ::= NULL_F",
 /* 544 */ "fill_mode ::= LINEAR",
 /* 545 */ "fill_mode ::= NEXT",
 /* 546 */ "group_by_clause_opt ::=",
 /* 547 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 548 */ "group_by_list ::= expr_or_subquery",
 /* 549 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 550 */ "having_clause_opt ::=",
 /* 551 */ "having_clause_opt ::= HAVING search_condition",
 /* 552 */ "range_opt ::=",
 /* 553 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 554 */ "every_opt ::=",
 /* 555 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 556 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 557 */ "query_simple ::= query_specification",
 /* 558 */ "query_simple ::= union_query_expression",
 /* 559 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 560 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 561 */ "query_simple_or_subquery ::= query_simple",
 /* 562 */ "query_simple_or_subquery ::= subquery",
 /* 563 */ "query_or_subquery ::= query_expression",
 /* 564 */ "query_or_subquery ::= subquery",
 /* 565 */ "order_by_clause_opt ::=",
 /* 566 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 567 */ "slimit_clause_opt ::=",
 /* 568 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 569 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 570 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 571 */ "limit_clause_opt ::=",
 /* 572 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 573 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 574 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 575 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 576 */ "subquery ::= NK_LP subquery NK_RP",
 /* 577 */ "search_condition ::= common_expression",
 /* 578 */ "sort_specification_list ::= sort_specification",
 /* 579 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 580 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 581 */ "ordering_specification_opt ::=",
 /* 582 */ "ordering_specification_opt ::= ASC",
 /* 583 */ "ordering_specification_opt ::= DESC",
 /* 584 */ "null_ordering_opt ::=",
 /* 585 */ "null_ordering_opt ::= NULLS FIRST",
 /* 586 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 333: /* cmd */
    case 336: /* literal */
    case 342: /* with_opt */
    case 348: /* search_condition */
    case 352: /* db_options */
    case 354: /* alter_db_options */
    case 356: /* start_opt */
    case 357: /* end_opt */
    case 361: /* signed */
    case 363: /* retention */
    case 364: /* full_table_name */
    case 367: /* table_options */
    case 371: /* alter_table_clause */
    case 372: /* alter_table_options */
    case 375: /* signed_literal */
    case 376: /* create_subtable_clause */
    case 379: /* drop_table_clause */
    case 381: /* column_def */
    case 385: /* duration_literal */
    case 386: /* rollup_func_name */
    case 388: /* col_name */
    case 389: /* db_name_cond_opt */
    case 390: /* like_pattern_opt */
    case 391: /* table_name_cond */
    case 392: /* from_db_opt */
    case 394: /* tag_item */
    case 396: /* full_index_name */
    case 397: /* index_options */
    case 400: /* sliding_opt */
    case 401: /* sma_stream_opt */
    case 402: /* func */
    case 404: /* query_or_subquery */
    case 407: /* explain_options */
    case 408: /* insert_query */
    case 414: /* stream_options */
    case 417: /* subtable_opt */
    case 419: /* expression */
    case 421: /* where_clause_opt */
    case 422: /* literal_func */
    case 425: /* expr_or_subquery */
    case 426: /* pseudo_column */
    case 427: /* column_reference */
    case 428: /* function_expression */
    case 429: /* case_when_expression */
    case 434: /* star_func_para */
    case 436: /* case_when_else_opt */
    case 437: /* common_expression */
    case 438: /* when_then_expr */
    case 439: /* predicate */
    case 442: /* in_predicate_value */
    case 443: /* boolean_value_expression */
    case 444: /* boolean_primary */
    case 445: /* from_clause_opt */
    case 446: /* table_reference_list */
    case 447: /* table_reference */
    case 448: /* table_primary */
    case 449: /* joined_table */
    case 451: /* subquery */
    case 452: /* parenthesized_joined_table */
    case 454: /* query_specification */
    case 458: /* range_opt */
    case 459: /* every_opt */
    case 460: /* fill_opt */
    case 461: /* twindow_clause_opt */
    case 463: /* having_clause_opt */
    case 464: /* select_item */
    case 466: /* partition_item */
    case 469: /* query_expression */
    case 470: /* query_simple */
    case 472: /* slimit_clause_opt */
    case 473: /* limit_clause_opt */
    case 474: /* union_query_expression */
    case 475: /* query_simple_or_subquery */
    case 477: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy872)); 
}
      break;
    case 334: /* account_options */
    case 335: /* alter_account_options */
    case 337: /* alter_account_option */
    case 355: /* speed_opt */
    case 411: /* bufsize_opt */
{
 
}
      break;
    case 338: /* user_name */
    case 345: /* db_name */
    case 346: /* table_name */
    case 347: /* topic_name */
    case 349: /* dnode_endpoint */
    case 373: /* column_name */
    case 387: /* function_name */
    case 395: /* column_alias */
    case 398: /* index_name */
    case 403: /* sma_func_name */
    case 405: /* cgroup_name */
    case 412: /* language_opt */
    case 413: /* stream_name */
    case 424: /* table_alias */
    case 430: /* star_func */
    case 432: /* noarg_func */
    case 450: /* alias_opt */
{
 
}
      break;
    case 339: /* sysinfo_opt */
{
 
}
      break;
    case 340: /* privileges */
    case 343: /* priv_type_list */
    case 344: /* priv_type */
{
 
}
      break;
    case 341: /* priv_level */
{
 
}
      break;
    case 350: /* force_opt */
    case 351: /* not_exists_opt */
    case 353: /* exists_opt */
    case 406: /* analyze_opt */
    case 409: /* or_replace_opt */
    case 410: /* agg_func_opt */
    case 418: /* ignore_opt */
    case 455: /* set_quantifier_opt */
{
 
}
      break;
    case 358: /* integer_list */
    case 359: /* variable_list */
    case 360: /* retention_list */
    case 365: /* column_def_list */
    case 366: /* tags_def_opt */
    case 368: /* multi_create_clause */
    case 369: /* tags_def */
    case 370: /* multi_drop_clause */
    case 377: /* specific_cols_opt */
    case 378: /* expression_list */
    case 380: /* col_name_list */
    case 382: /* duration_list */
    case 383: /* rollup_func_list */
    case 393: /* tag_list_opt */
    case 399: /* func_list */
    case 415: /* col_list_opt */
    case 416: /* tag_def_or_ref_opt */
    case 420: /* dnode_list */
    case 423: /* literal_list */
    case 431: /* star_func_para_list */
    case 433: /* other_para_list */
    case 435: /* when_then_list */
    case 456: /* select_list */
    case 457: /* partition_by_clause_opt */
    case 462: /* group_by_clause_opt */
    case 465: /* partition_list */
    case 468: /* group_by_list */
    case 471: /* order_by_clause_opt */
    case 476: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy664)); 
}
      break;
    case 362: /* alter_db_option */
    case 384: /* alter_table_option */
{
 
}
      break;
    case 374: /* type_name */
{
 
}
      break;
    case 440: /* compare_op */
    case 441: /* in_op */
{
 
}
      break;
    case 453: /* join_type */
{
 
}
      break;
    case 467: /* fill_mode */
{
 
}
      break;
    case 478: /* ordering_specification_opt */
{
 
}
      break;
    case 479: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  333,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  333,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  334,    0 }, /* (2) account_options ::= */
  {  334,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  334,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  334,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  334,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  334,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  334,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  334,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  334,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  334,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  335,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  335,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  337,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  337,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  337,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  337,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  337,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  337,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  337,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  337,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  337,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  337,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  333,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  333,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  333,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  333,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  333,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  339,    0 }, /* (29) sysinfo_opt ::= */
  {  339,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  333,   -7 }, /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
  {  333,   -7 }, /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
  {  340,   -1 }, /* (33) privileges ::= ALL */
  {  340,   -1 }, /* (34) privileges ::= priv_type_list */
  {  340,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  343,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  343,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  344,   -1 }, /* (38) priv_type ::= READ */
  {  344,   -1 }, /* (39) priv_type ::= WRITE */
  {  341,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  341,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  341,   -3 }, /* (42) priv_level ::= db_name NK_DOT table_name */
  {  341,   -1 }, /* (43) priv_level ::= topic_name */
  {  342,    0 }, /* (44) with_opt ::= */
  {  342,   -2 }, /* (45) with_opt ::= WITH search_condition */
  {  333,   -3 }, /* (46) cmd ::= CREATE DNODE dnode_endpoint */
  {  333,   -5 }, /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  333,   -4 }, /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  333,   -4 }, /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  333,   -4 }, /* (50) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  333,   -5 }, /* (51) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  333,   -4 }, /* (52) cmd ::= ALTER ALL DNODES NK_STRING */
  {  333,   -5 }, /* (53) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  349,   -1 }, /* (54) dnode_endpoint ::= NK_STRING */
  {  349,   -1 }, /* (55) dnode_endpoint ::= NK_ID */
  {  349,   -1 }, /* (56) dnode_endpoint ::= NK_IPTOKEN */
  {  350,    0 }, /* (57) force_opt ::= */
  {  350,   -1 }, /* (58) force_opt ::= FORCE */
  {  333,   -3 }, /* (59) cmd ::= ALTER LOCAL NK_STRING */
  {  333,   -4 }, /* (60) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  333,   -5 }, /* (61) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  333,   -5 }, /* (62) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  333,   -5 }, /* (63) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  333,   -5 }, /* (64) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  333,   -5 }, /* (65) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  333,   -5 }, /* (66) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  333,   -5 }, /* (67) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  333,   -5 }, /* (68) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  333,   -5 }, /* (69) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  333,   -4 }, /* (70) cmd ::= DROP DATABASE exists_opt db_name */
  {  333,   -2 }, /* (71) cmd ::= USE db_name */
  {  333,   -4 }, /* (72) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  333,   -3 }, /* (73) cmd ::= FLUSH DATABASE db_name */
  {  333,   -4 }, /* (74) cmd ::= TRIM DATABASE db_name speed_opt */
  {  333,   -5 }, /* (75) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
  {  351,   -3 }, /* (76) not_exists_opt ::= IF NOT EXISTS */
  {  351,    0 }, /* (77) not_exists_opt ::= */
  {  353,   -2 }, /* (78) exists_opt ::= IF EXISTS */
  {  353,    0 }, /* (79) exists_opt ::= */
  {  352,    0 }, /* (80) db_options ::= */
  {  352,   -3 }, /* (81) db_options ::= db_options BUFFER NK_INTEGER */
  {  352,   -3 }, /* (82) db_options ::= db_options CACHEMODEL NK_STRING */
  {  352,   -3 }, /* (83) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  352,   -3 }, /* (84) db_options ::= db_options COMP NK_INTEGER */
  {  352,   -3 }, /* (85) db_options ::= db_options DURATION NK_INTEGER */
  {  352,   -3 }, /* (86) db_options ::= db_options DURATION NK_VARIABLE */
  {  352,   -3 }, /* (87) db_options ::= db_options MAXROWS NK_INTEGER */
  {  352,   -3 }, /* (88) db_options ::= db_options MINROWS NK_INTEGER */
  {  352,   -3 }, /* (89) db_options ::= db_options KEEP integer_list */
  {  352,   -3 }, /* (90) db_options ::= db_options KEEP variable_list */
  {  352,   -3 }, /* (91) db_options ::= db_options PAGES NK_INTEGER */
  {  352,   -3 }, /* (92) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  352,   -3 }, /* (93) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  352,   -3 }, /* (94) db_options ::= db_options PRECISION NK_STRING */
  {  352,   -3 }, /* (95) db_options ::= db_options REPLICA NK_INTEGER */
  {  352,   -3 }, /* (96) db_options ::= db_options VGROUPS NK_INTEGER */
  {  352,   -3 }, /* (97) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  352,   -3 }, /* (98) db_options ::= db_options RETENTIONS retention_list */
  {  352,   -3 }, /* (99) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  352,   -3 }, /* (100) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  352,   -3 }, /* (101) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  352,   -3 }, /* (102) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  352,   -4 }, /* (103) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  352,   -3 }, /* (104) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  352,   -4 }, /* (105) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  352,   -3 }, /* (106) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  352,   -3 }, /* (107) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  352,   -3 }, /* (108) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  352,   -3 }, /* (109) db_options ::= db_options TABLE_PREFIX signed */
  {  352,   -3 }, /* (110) db_options ::= db_options TABLE_SUFFIX signed */
  {  354,   -1 }, /* (111) alter_db_options ::= alter_db_option */
  {  354,   -2 }, /* (112) alter_db_options ::= alter_db_options alter_db_option */
  {  362,   -2 }, /* (113) alter_db_option ::= BUFFER NK_INTEGER */
  {  362,   -2 }, /* (114) alter_db_option ::= CACHEMODEL NK_STRING */
  {  362,   -2 }, /* (115) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  362,   -2 }, /* (116) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  362,   -2 }, /* (117) alter_db_option ::= KEEP integer_list */
  {  362,   -2 }, /* (118) alter_db_option ::= KEEP variable_list */
  {  362,   -2 }, /* (119) alter_db_option ::= PAGES NK_INTEGER */
  {  362,   -2 }, /* (120) alter_db_option ::= REPLICA NK_INTEGER */
  {  362,   -2 }, /* (121) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  362,   -2 }, /* (122) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  362,   -2 }, /* (123) alter_db_option ::= MINROWS NK_INTEGER */
  {  362,   -2 }, /* (124) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
  {  362,   -3 }, /* (125) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  362,   -2 }, /* (126) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
  {  362,   -3 }, /* (127) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  358,   -1 }, /* (128) integer_list ::= NK_INTEGER */
  {  358,   -3 }, /* (129) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  359,   -1 }, /* (130) variable_list ::= NK_VARIABLE */
  {  359,   -3 }, /* (131) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  360,   -1 }, /* (132) retention_list ::= retention */
  {  360,   -3 }, /* (133) retention_list ::= retention_list NK_COMMA retention */
  {  363,   -3 }, /* (134) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  355,    0 }, /* (135) speed_opt ::= */
  {  355,   -2 }, /* (136) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  356,    0 }, /* (137) start_opt ::= */
  {  356,   -3 }, /* (138) start_opt ::= START WITH NK_INTEGER */
  {  356,   -3 }, /* (139) start_opt ::= START WITH NK_STRING */
  {  356,   -4 }, /* (140) start_opt ::= START WITH TIMESTAMP NK_STRING */
  {  357,    0 }, /* (141) end_opt ::= */
  {  357,   -3 }, /* (142) end_opt ::= END WITH NK_INTEGER */
  {  357,   -3 }, /* (143) end_opt ::= END WITH NK_STRING */
  {  357,   -4 }, /* (144) end_opt ::= END WITH TIMESTAMP NK_STRING */
  {  333,   -9 }, /* (145) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  333,   -3 }, /* (146) cmd ::= CREATE TABLE multi_create_clause */
  {  333,   -9 }, /* (147) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  333,   -3 }, /* (148) cmd ::= DROP TABLE multi_drop_clause */
  {  333,   -4 }, /* (149) cmd ::= DROP STABLE exists_opt full_table_name */
  {  333,   -3 }, /* (150) cmd ::= ALTER TABLE alter_table_clause */
  {  333,   -3 }, /* (151) cmd ::= ALTER STABLE alter_table_clause */
  {  371,   -2 }, /* (152) alter_table_clause ::= full_table_name alter_table_options */
  {  371,   -5 }, /* (153) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  371,   -4 }, /* (154) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  371,   -5 }, /* (155) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  371,   -5 }, /* (156) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  371,   -5 }, /* (157) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  371,   -4 }, /* (158) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  371,   -5 }, /* (159) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  371,   -5 }, /* (160) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  371,   -6 }, /* (161) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  368,   -1 }, /* (162) multi_create_clause ::= create_subtable_clause */
  {  368,   -2 }, /* (163) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  376,  -10 }, /* (164) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  370,   -1 }, /* (165) multi_drop_clause ::= drop_table_clause */
  {  370,   -3 }, /* (166) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
  {  379,   -2 }, /* (167) drop_table_clause ::= exists_opt full_table_name */
  {  377,    0 }, /* (168) specific_cols_opt ::= */
  {  377,   -3 }, /* (169) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  364,   -1 }, /* (170) full_table_name ::= table_name */
  {  364,   -3 }, /* (171) full_table_name ::= db_name NK_DOT table_name */
  {  365,   -1 }, /* (172) column_def_list ::= column_def */
  {  365,   -3 }, /* (173) column_def_list ::= column_def_list NK_COMMA column_def */
  {  381,   -2 }, /* (174) column_def ::= column_name type_name */
  {  374,   -1 }, /* (175) type_name ::= BOOL */
  {  374,   -1 }, /* (176) type_name ::= TINYINT */
  {  374,   -1 }, /* (177) type_name ::= SMALLINT */
  {  374,   -1 }, /* (178) type_name ::= INT */
  {  374,   -1 }, /* (179) type_name ::= INTEGER */
  {  374,   -1 }, /* (180) type_name ::= BIGINT */
  {  374,   -1 }, /* (181) type_name ::= FLOAT */
  {  374,   -1 }, /* (182) type_name ::= DOUBLE */
  {  374,   -4 }, /* (183) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  374,   -1 }, /* (184) type_name ::= TIMESTAMP */
  {  374,   -4 }, /* (185) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  374,   -2 }, /* (186) type_name ::= TINYINT UNSIGNED */
  {  374,   -2 }, /* (187) type_name ::= SMALLINT UNSIGNED */
  {  374,   -2 }, /* (188) type_name ::= INT UNSIGNED */
  {  374,   -2 }, /* (189) type_name ::= BIGINT UNSIGNED */
  {  374,   -1 }, /* (190) type_name ::= JSON */
  {  374,   -4 }, /* (191) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  374,   -1 }, /* (192) type_name ::= MEDIUMBLOB */
  {  374,   -1 }, /* (193) type_name ::= BLOB */
  {  374,   -4 }, /* (194) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  374,   -1 }, /* (195) type_name ::= DECIMAL */
  {  374,   -4 }, /* (196) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  374,   -6 }, /* (197) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  366,    0 }, /* (198) tags_def_opt ::= */
  {  366,   -1 }, /* (199) tags_def_opt ::= tags_def */
  {  369,   -4 }, /* (200) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  367,    0 }, /* (201) table_options ::= */
  {  367,   -3 }, /* (202) table_options ::= table_options COMMENT NK_STRING */
  {  367,   -3 }, /* (203) table_options ::= table_options MAX_DELAY duration_list */
  {  367,   -3 }, /* (204) table_options ::= table_options WATERMARK duration_list */
  {  367,   -5 }, /* (205) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  367,   -3 }, /* (206) table_options ::= table_options TTL NK_INTEGER */
  {  367,   -5 }, /* (207) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  367,   -3 }, /* (208) table_options ::= table_options DELETE_MARK duration_list */
  {  372,   -1 }, /* (209) alter_table_options ::= alter_table_option */
  {  372,   -2 }, /* (210) alter_table_options ::= alter_table_options alter_table_option */
  {  384,   -2 }, /* (211) alter_table_option ::= COMMENT NK_STRING */
  {  384,   -2 }, /* (212) alter_table_option ::= TTL NK_INTEGER */
  {  382,   -1 }, /* (213) duration_list ::= duration_literal */
  {  382,   -3 }, /* (214) duration_list ::= duration_list NK_COMMA duration_literal */
  {  383,   -1 }, /* (215) rollup_func_list ::= rollup_func_name */
  {  383,   -3 }, /* (216) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  386,   -1 }, /* (217) rollup_func_name ::= function_name */
  {  386,   -1 }, /* (218) rollup_func_name ::= FIRST */
  {  386,   -1 }, /* (219) rollup_func_name ::= LAST */
  {  380,   -1 }, /* (220) col_name_list ::= col_name */
  {  380,   -3 }, /* (221) col_name_list ::= col_name_list NK_COMMA col_name */
  {  388,   -1 }, /* (222) col_name ::= column_name */
  {  333,   -2 }, /* (223) cmd ::= SHOW DNODES */
  {  333,   -2 }, /* (224) cmd ::= SHOW USERS */
  {  333,   -3 }, /* (225) cmd ::= SHOW USER PRIVILEGES */
  {  333,   -2 }, /* (226) cmd ::= SHOW DATABASES */
  {  333,   -4 }, /* (227) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  333,   -4 }, /* (228) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  333,   -3 }, /* (229) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  333,   -2 }, /* (230) cmd ::= SHOW MNODES */
  {  333,   -2 }, /* (231) cmd ::= SHOW QNODES */
  {  333,   -2 }, /* (232) cmd ::= SHOW FUNCTIONS */
  {  333,   -5 }, /* (233) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  333,   -2 }, /* (234) cmd ::= SHOW STREAMS */
  {  333,   -2 }, /* (235) cmd ::= SHOW ACCOUNTS */
  {  333,   -2 }, /* (236) cmd ::= SHOW APPS */
  {  333,   -2 }, /* (237) cmd ::= SHOW CONNECTIONS */
  {  333,   -2 }, /* (238) cmd ::= SHOW LICENCES */
  {  333,   -2 }, /* (239) cmd ::= SHOW GRANTS */
  {  333,   -4 }, /* (240) cmd ::= SHOW CREATE DATABASE db_name */
  {  333,   -4 }, /* (241) cmd ::= SHOW CREATE TABLE full_table_name */
  {  333,   -4 }, /* (242) cmd ::= SHOW CREATE STABLE full_table_name */
  {  333,   -2 }, /* (243) cmd ::= SHOW QUERIES */
  {  333,   -2 }, /* (244) cmd ::= SHOW SCORES */
  {  333,   -2 }, /* (245) cmd ::= SHOW TOPICS */
  {  333,   -2 }, /* (246) cmd ::= SHOW VARIABLES */
  {  333,   -3 }, /* (247) cmd ::= SHOW CLUSTER VARIABLES */
  {  333,   -3 }, /* (248) cmd ::= SHOW LOCAL VARIABLES */
  {  333,   -5 }, /* (249) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  333,   -2 }, /* (250) cmd ::= SHOW BNODES */
  {  333,   -2 }, /* (251) cmd ::= SHOW SNODES */
  {  333,   -2 }, /* (252) cmd ::= SHOW CLUSTER */
  {  333,   -2 }, /* (253) cmd ::= SHOW TRANSACTIONS */
  {  333,   -4 }, /* (254) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  333,   -2 }, /* (255) cmd ::= SHOW CONSUMERS */
  {  333,   -2 }, /* (256) cmd ::= SHOW SUBSCRIPTIONS */
  {  333,   -5 }, /* (257) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  333,   -7 }, /* (258) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  333,   -3 }, /* (259) cmd ::= SHOW VNODES NK_INTEGER */
  {  333,   -3 }, /* (260) cmd ::= SHOW VNODES NK_STRING */
  {  333,   -3 }, /* (261) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  333,   -3 }, /* (262) cmd ::= SHOW CLUSTER ALIVE */
  {  389,    0 }, /* (263) db_name_cond_opt ::= */
  {  389,   -2 }, /* (264) db_name_cond_opt ::= db_name NK_DOT */
  {  390,    0 }, /* (265) like_pattern_opt ::= */
  {  390,   -2 }, /* (266) like_pattern_opt ::= LIKE NK_STRING */
  {  391,   -1 }, /* (267) table_name_cond ::= table_name */
  {  392,    0 }, /* (268) from_db_opt ::= */
  {  392,   -2 }, /* (269) from_db_opt ::= FROM db_name */
  {  393,    0 }, /* (270) tag_list_opt ::= */
  {  393,   -1 }, /* (271) tag_list_opt ::= tag_item */
  {  393,   -3 }, /* (272) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  394,   -1 }, /* (273) tag_item ::= TBNAME */
  {  394,   -1 }, /* (274) tag_item ::= QTAGS */
  {  394,   -1 }, /* (275) tag_item ::= column_name */
  {  394,   -2 }, /* (276) tag_item ::= column_name column_alias */
  {  394,   -3 }, /* (277) tag_item ::= column_name AS column_alias */
  {  333,   -8 }, /* (278) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  333,   -9 }, /* (279) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  333,   -4 }, /* (280) cmd ::= DROP INDEX exists_opt full_index_name */
  {  396,   -1 }, /* (281) full_index_name ::= index_name */
  {  396,   -3 }, /* (282) full_index_name ::= db_name NK_DOT index_name */
  {  397,  -10 }, /* (283) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  397,  -12 }, /* (284) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  399,   -1 }, /* (285) func_list ::= func */
  {  399,   -3 }, /* (286) func_list ::= func_list NK_COMMA func */
  {  402,   -4 }, /* (287) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  403,   -1 }, /* (288) sma_func_name ::= function_name */
  {  403,   -1 }, /* (289) sma_func_name ::= COUNT */
  {  403,   -1 }, /* (290) sma_func_name ::= FIRST */
  {  403,   -1 }, /* (291) sma_func_name ::= LAST */
  {  403,   -1 }, /* (292) sma_func_name ::= LAST_ROW */
  {  401,    0 }, /* (293) sma_stream_opt ::= */
  {  401,   -3 }, /* (294) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  401,   -3 }, /* (295) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  401,   -3 }, /* (296) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  333,   -6 }, /* (297) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  333,   -7 }, /* (298) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  333,   -9 }, /* (299) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  333,   -7 }, /* (300) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  333,   -9 }, /* (301) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  333,   -4 }, /* (302) cmd ::= DROP TOPIC exists_opt topic_name */
  {  333,   -7 }, /* (303) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  333,   -2 }, /* (304) cmd ::= DESC full_table_name */
  {  333,   -2 }, /* (305) cmd ::= DESCRIBE full_table_name */
  {  333,   -3 }, /* (306) cmd ::= RESET QUERY CACHE */
  {  333,   -4 }, /* (307) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  333,   -4 }, /* (308) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
  {  406,    0 }, /* (309) analyze_opt ::= */
  {  406,   -1 }, /* (310) analyze_opt ::= ANALYZE */
  {  407,    0 }, /* (311) explain_options ::= */
  {  407,   -3 }, /* (312) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  407,   -3 }, /* (313) explain_options ::= explain_options RATIO NK_FLOAT */
  {  333,  -12 }, /* (314) cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
  {  333,   -4 }, /* (315) cmd ::= DROP FUNCTION exists_opt function_name */
  {  410,    0 }, /* (316) agg_func_opt ::= */
  {  410,   -1 }, /* (317) agg_func_opt ::= AGGREGATE */
  {  411,    0 }, /* (318) bufsize_opt ::= */
  {  411,   -2 }, /* (319) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  412,    0 }, /* (320) language_opt ::= */
  {  412,   -2 }, /* (321) language_opt ::= LANGUAGE NK_STRING */
  {  409,    0 }, /* (322) or_replace_opt ::= */
  {  409,   -2 }, /* (323) or_replace_opt ::= OR REPLACE */
  {  333,  -12 }, /* (324) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
  {  333,   -4 }, /* (325) cmd ::= DROP STREAM exists_opt stream_name */
  {  333,   -4 }, /* (326) cmd ::= PAUSE STREAM exists_opt stream_name */
  {  333,   -5 }, /* (327) cmd ::= RESUME STREAM exists_opt ignore_opt stream_name */
  {  415,    0 }, /* (328) col_list_opt ::= */
  {  415,   -3 }, /* (329) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  416,    0 }, /* (330) tag_def_or_ref_opt ::= */
  {  416,   -1 }, /* (331) tag_def_or_ref_opt ::= tags_def */
  {  416,   -4 }, /* (332) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
  {  414,    0 }, /* (333) stream_options ::= */
  {  414,   -3 }, /* (334) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  414,   -3 }, /* (335) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  414,   -4 }, /* (336) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  414,   -3 }, /* (337) stream_options ::= stream_options WATERMARK duration_literal */
  {  414,   -4 }, /* (338) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  414,   -3 }, /* (339) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  414,   -3 }, /* (340) stream_options ::= stream_options DELETE_MARK duration_literal */
  {  414,   -4 }, /* (341) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
  {  417,    0 }, /* (342) subtable_opt ::= */
  {  417,   -4 }, /* (343) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  418,    0 }, /* (344) ignore_opt ::= */
  {  418,   -2 }, /* (345) ignore_opt ::= IGNORE UNTREATED */
  {  333,   -3 }, /* (346) cmd ::= KILL CONNECTION NK_INTEGER */
  {  333,   -3 }, /* (347) cmd ::= KILL QUERY NK_STRING */
  {  333,   -3 }, /* (348) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  333,   -2 }, /* (349) cmd ::= BALANCE VGROUP */
  {  333,   -3 }, /* (350) cmd ::= BALANCE VGROUP LEADER */
  {  333,   -4 }, /* (351) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  333,   -4 }, /* (352) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  333,   -3 }, /* (353) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  420,   -2 }, /* (354) dnode_list ::= DNODE NK_INTEGER */
  {  420,   -3 }, /* (355) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  333,   -4 }, /* (356) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  333,   -1 }, /* (357) cmd ::= query_or_subquery */
  {  333,   -1 }, /* (358) cmd ::= insert_query */
  {  408,   -7 }, /* (359) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  408,   -4 }, /* (360) insert_query ::= INSERT INTO full_table_name query_or_subquery */
  {  336,   -1 }, /* (361) literal ::= NK_INTEGER */
  {  336,   -1 }, /* (362) literal ::= NK_FLOAT */
  {  336,   -1 }, /* (363) literal ::= NK_STRING */
  {  336,   -1 }, /* (364) literal ::= NK_BOOL */
  {  336,   -2 }, /* (365) literal ::= TIMESTAMP NK_STRING */
  {  336,   -1 }, /* (366) literal ::= duration_literal */
  {  336,   -1 }, /* (367) literal ::= NULL */
  {  336,   -1 }, /* (368) literal ::= NK_QUESTION */
  {  385,   -1 }, /* (369) duration_literal ::= NK_VARIABLE */
  {  361,   -1 }, /* (370) signed ::= NK_INTEGER */
  {  361,   -2 }, /* (371) signed ::= NK_PLUS NK_INTEGER */
  {  361,   -2 }, /* (372) signed ::= NK_MINUS NK_INTEGER */
  {  361,   -1 }, /* (373) signed ::= NK_FLOAT */
  {  361,   -2 }, /* (374) signed ::= NK_PLUS NK_FLOAT */
  {  361,   -2 }, /* (375) signed ::= NK_MINUS NK_FLOAT */
  {  375,   -1 }, /* (376) signed_literal ::= signed */
  {  375,   -1 }, /* (377) signed_literal ::= NK_STRING */
  {  375,   -1 }, /* (378) signed_literal ::= NK_BOOL */
  {  375,   -2 }, /* (379) signed_literal ::= TIMESTAMP NK_STRING */
  {  375,   -1 }, /* (380) signed_literal ::= duration_literal */
  {  375,   -1 }, /* (381) signed_literal ::= NULL */
  {  375,   -1 }, /* (382) signed_literal ::= literal_func */
  {  375,   -1 }, /* (383) signed_literal ::= NK_QUESTION */
  {  423,   -1 }, /* (384) literal_list ::= signed_literal */
  {  423,   -3 }, /* (385) literal_list ::= literal_list NK_COMMA signed_literal */
  {  345,   -1 }, /* (386) db_name ::= NK_ID */
  {  346,   -1 }, /* (387) table_name ::= NK_ID */
  {  373,   -1 }, /* (388) column_name ::= NK_ID */
  {  387,   -1 }, /* (389) function_name ::= NK_ID */
  {  424,   -1 }, /* (390) table_alias ::= NK_ID */
  {  395,   -1 }, /* (391) column_alias ::= NK_ID */
  {  338,   -1 }, /* (392) user_name ::= NK_ID */
  {  347,   -1 }, /* (393) topic_name ::= NK_ID */
  {  413,   -1 }, /* (394) stream_name ::= NK_ID */
  {  405,   -1 }, /* (395) cgroup_name ::= NK_ID */
  {  398,   -1 }, /* (396) index_name ::= NK_ID */
  {  425,   -1 }, /* (397) expr_or_subquery ::= expression */
  {  419,   -1 }, /* (398) expression ::= literal */
  {  419,   -1 }, /* (399) expression ::= pseudo_column */
  {  419,   -1 }, /* (400) expression ::= column_reference */
  {  419,   -1 }, /* (401) expression ::= function_expression */
  {  419,   -1 }, /* (402) expression ::= case_when_expression */
  {  419,   -3 }, /* (403) expression ::= NK_LP expression NK_RP */
  {  419,   -2 }, /* (404) expression ::= NK_PLUS expr_or_subquery */
  {  419,   -2 }, /* (405) expression ::= NK_MINUS expr_or_subquery */
  {  419,   -3 }, /* (406) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  419,   -3 }, /* (407) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  419,   -3 }, /* (408) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  419,   -3 }, /* (409) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  419,   -3 }, /* (410) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  419,   -3 }, /* (411) expression ::= column_reference NK_ARROW NK_STRING */
  {  419,   -3 }, /* (412) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  419,   -3 }, /* (413) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  378,   -1 }, /* (414) expression_list ::= expr_or_subquery */
  {  378,   -3 }, /* (415) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  427,   -1 }, /* (416) column_reference ::= column_name */
  {  427,   -3 }, /* (417) column_reference ::= table_name NK_DOT column_name */
  {  426,   -1 }, /* (418) pseudo_column ::= ROWTS */
  {  426,   -1 }, /* (419) pseudo_column ::= TBNAME */
  {  426,   -3 }, /* (420) pseudo_column ::= table_name NK_DOT TBNAME */
  {  426,   -1 }, /* (421) pseudo_column ::= QSTART */
  {  426,   -1 }, /* (422) pseudo_column ::= QEND */
  {  426,   -1 }, /* (423) pseudo_column ::= QDURATION */
  {  426,   -1 }, /* (424) pseudo_column ::= WSTART */
  {  426,   -1 }, /* (425) pseudo_column ::= WEND */
  {  426,   -1 }, /* (426) pseudo_column ::= WDURATION */
  {  426,   -1 }, /* (427) pseudo_column ::= IROWTS */
  {  426,   -1 }, /* (428) pseudo_column ::= ISFILLED */
  {  426,   -1 }, /* (429) pseudo_column ::= QTAGS */
  {  428,   -4 }, /* (430) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  428,   -4 }, /* (431) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  428,   -6 }, /* (432) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  428,   -1 }, /* (433) function_expression ::= literal_func */
  {  422,   -3 }, /* (434) literal_func ::= noarg_func NK_LP NK_RP */
  {  422,   -1 }, /* (435) literal_func ::= NOW */
  {  432,   -1 }, /* (436) noarg_func ::= NOW */
  {  432,   -1 }, /* (437) noarg_func ::= TODAY */
  {  432,   -1 }, /* (438) noarg_func ::= TIMEZONE */
  {  432,   -1 }, /* (439) noarg_func ::= DATABASE */
  {  432,   -1 }, /* (440) noarg_func ::= CLIENT_VERSION */
  {  432,   -1 }, /* (441) noarg_func ::= SERVER_VERSION */
  {  432,   -1 }, /* (442) noarg_func ::= SERVER_STATUS */
  {  432,   -1 }, /* (443) noarg_func ::= CURRENT_USER */
  {  432,   -1 }, /* (444) noarg_func ::= USER */
  {  430,   -1 }, /* (445) star_func ::= COUNT */
  {  430,   -1 }, /* (446) star_func ::= FIRST */
  {  430,   -1 }, /* (447) star_func ::= LAST */
  {  430,   -1 }, /* (448) star_func ::= LAST_ROW */
  {  431,   -1 }, /* (449) star_func_para_list ::= NK_STAR */
  {  431,   -1 }, /* (450) star_func_para_list ::= other_para_list */
  {  433,   -1 }, /* (451) other_para_list ::= star_func_para */
  {  433,   -3 }, /* (452) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  434,   -1 }, /* (453) star_func_para ::= expr_or_subquery */
  {  434,   -3 }, /* (454) star_func_para ::= table_name NK_DOT NK_STAR */
  {  429,   -4 }, /* (455) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  429,   -5 }, /* (456) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  435,   -1 }, /* (457) when_then_list ::= when_then_expr */
  {  435,   -2 }, /* (458) when_then_list ::= when_then_list when_then_expr */
  {  438,   -4 }, /* (459) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  436,    0 }, /* (460) case_when_else_opt ::= */
  {  436,   -2 }, /* (461) case_when_else_opt ::= ELSE common_expression */
  {  439,   -3 }, /* (462) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  439,   -5 }, /* (463) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  439,   -6 }, /* (464) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  439,   -3 }, /* (465) predicate ::= expr_or_subquery IS NULL */
  {  439,   -4 }, /* (466) predicate ::= expr_or_subquery IS NOT NULL */
  {  439,   -3 }, /* (467) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  440,   -1 }, /* (468) compare_op ::= NK_LT */
  {  440,   -1 }, /* (469) compare_op ::= NK_GT */
  {  440,   -1 }, /* (470) compare_op ::= NK_LE */
  {  440,   -1 }, /* (471) compare_op ::= NK_GE */
  {  440,   -1 }, /* (472) compare_op ::= NK_NE */
  {  440,   -1 }, /* (473) compare_op ::= NK_EQ */
  {  440,   -1 }, /* (474) compare_op ::= LIKE */
  {  440,   -2 }, /* (475) compare_op ::= NOT LIKE */
  {  440,   -1 }, /* (476) compare_op ::= MATCH */
  {  440,   -1 }, /* (477) compare_op ::= NMATCH */
  {  440,   -1 }, /* (478) compare_op ::= CONTAINS */
  {  441,   -1 }, /* (479) in_op ::= IN */
  {  441,   -2 }, /* (480) in_op ::= NOT IN */
  {  442,   -3 }, /* (481) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  443,   -1 }, /* (482) boolean_value_expression ::= boolean_primary */
  {  443,   -2 }, /* (483) boolean_value_expression ::= NOT boolean_primary */
  {  443,   -3 }, /* (484) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  443,   -3 }, /* (485) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  444,   -1 }, /* (486) boolean_primary ::= predicate */
  {  444,   -3 }, /* (487) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  437,   -1 }, /* (488) common_expression ::= expr_or_subquery */
  {  437,   -1 }, /* (489) common_expression ::= boolean_value_expression */
  {  445,    0 }, /* (490) from_clause_opt ::= */
  {  445,   -2 }, /* (491) from_clause_opt ::= FROM table_reference_list */
  {  446,   -1 }, /* (492) table_reference_list ::= table_reference */
  {  446,   -3 }, /* (493) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  447,   -1 }, /* (494) table_reference ::= table_primary */
  {  447,   -1 }, /* (495) table_reference ::= joined_table */
  {  448,   -2 }, /* (496) table_primary ::= table_name alias_opt */
  {  448,   -4 }, /* (497) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  448,   -2 }, /* (498) table_primary ::= subquery alias_opt */
  {  448,   -1 }, /* (499) table_primary ::= parenthesized_joined_table */
  {  450,    0 }, /* (500) alias_opt ::= */
  {  450,   -1 }, /* (501) alias_opt ::= table_alias */
  {  450,   -2 }, /* (502) alias_opt ::= AS table_alias */
  {  452,   -3 }, /* (503) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  452,   -3 }, /* (504) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  449,   -6 }, /* (505) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  453,    0 }, /* (506) join_type ::= */
  {  453,   -1 }, /* (507) join_type ::= INNER */
  {  454,  -12 }, /* (508) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  455,    0 }, /* (509) set_quantifier_opt ::= */
  {  455,   -1 }, /* (510) set_quantifier_opt ::= DISTINCT */
  {  455,   -1 }, /* (511) set_quantifier_opt ::= ALL */
  {  456,   -1 }, /* (512) select_list ::= select_item */
  {  456,   -3 }, /* (513) select_list ::= select_list NK_COMMA select_item */
  {  464,   -1 }, /* (514) select_item ::= NK_STAR */
  {  464,   -1 }, /* (515) select_item ::= common_expression */
  {  464,   -2 }, /* (516) select_item ::= common_expression column_alias */
  {  464,   -3 }, /* (517) select_item ::= common_expression AS column_alias */
  {  464,   -3 }, /* (518) select_item ::= table_name NK_DOT NK_STAR */
  {  421,    0 }, /* (519) where_clause_opt ::= */
  {  421,   -2 }, /* (520) where_clause_opt ::= WHERE search_condition */
  {  457,    0 }, /* (521) partition_by_clause_opt ::= */
  {  457,   -3 }, /* (522) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  465,   -1 }, /* (523) partition_list ::= partition_item */
  {  465,   -3 }, /* (524) partition_list ::= partition_list NK_COMMA partition_item */
  {  466,   -1 }, /* (525) partition_item ::= expr_or_subquery */
  {  466,   -2 }, /* (526) partition_item ::= expr_or_subquery column_alias */
  {  466,   -3 }, /* (527) partition_item ::= expr_or_subquery AS column_alias */
  {  461,    0 }, /* (528) twindow_clause_opt ::= */
  {  461,   -6 }, /* (529) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  461,   -4 }, /* (530) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  461,   -6 }, /* (531) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  461,   -8 }, /* (532) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  461,   -7 }, /* (533) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  400,    0 }, /* (534) sliding_opt ::= */
  {  400,   -4 }, /* (535) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  460,    0 }, /* (536) fill_opt ::= */
  {  460,   -4 }, /* (537) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  460,   -6 }, /* (538) fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
  {  460,   -6 }, /* (539) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
  {  467,   -1 }, /* (540) fill_mode ::= NONE */
  {  467,   -1 }, /* (541) fill_mode ::= PREV */
  {  467,   -1 }, /* (542) fill_mode ::= NULL */
  {  467,   -1 }, /* (543) fill_mode ::= NULL_F */
  {  467,   -1 }, /* (544) fill_mode ::= LINEAR */
  {  467,   -1 }, /* (545) fill_mode ::= NEXT */
  {  462,    0 }, /* (546) group_by_clause_opt ::= */
  {  462,   -3 }, /* (547) group_by_clause_opt ::= GROUP BY group_by_list */
  {  468,   -1 }, /* (548) group_by_list ::= expr_or_subquery */
  {  468,   -3 }, /* (549) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  463,    0 }, /* (550) having_clause_opt ::= */
  {  463,   -2 }, /* (551) having_clause_opt ::= HAVING search_condition */
  {  458,    0 }, /* (552) range_opt ::= */
  {  458,   -6 }, /* (553) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  459,    0 }, /* (554) every_opt ::= */
  {  459,   -4 }, /* (555) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  469,   -4 }, /* (556) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  470,   -1 }, /* (557) query_simple ::= query_specification */
  {  470,   -1 }, /* (558) query_simple ::= union_query_expression */
  {  474,   -4 }, /* (559) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  474,   -3 }, /* (560) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  475,   -1 }, /* (561) query_simple_or_subquery ::= query_simple */
  {  475,   -1 }, /* (562) query_simple_or_subquery ::= subquery */
  {  404,   -1 }, /* (563) query_or_subquery ::= query_expression */
  {  404,   -1 }, /* (564) query_or_subquery ::= subquery */
  {  471,    0 }, /* (565) order_by_clause_opt ::= */
  {  471,   -3 }, /* (566) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  472,    0 }, /* (567) slimit_clause_opt ::= */
  {  472,   -2 }, /* (568) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  472,   -4 }, /* (569) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  472,   -4 }, /* (570) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  473,    0 }, /* (571) limit_clause_opt ::= */
  {  473,   -2 }, /* (572) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  473,   -4 }, /* (573) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  473,   -4 }, /* (574) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  451,   -3 }, /* (575) subquery ::= NK_LP query_expression NK_RP */
  {  451,   -3 }, /* (576) subquery ::= NK_LP subquery NK_RP */
  {  348,   -1 }, /* (577) search_condition ::= common_expression */
  {  476,   -1 }, /* (578) sort_specification_list ::= sort_specification */
  {  476,   -3 }, /* (579) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  477,   -3 }, /* (580) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  478,    0 }, /* (581) ordering_specification_opt ::= */
  {  478,   -1 }, /* (582) ordering_specification_opt ::= ASC */
  {  478,   -1 }, /* (583) ordering_specification_opt ::= DESC */
  {  479,    0 }, /* (584) null_ordering_opt ::= */
  {  479,   -2 }, /* (585) null_ordering_opt ::= NULLS FIRST */
  {  479,   -2 }, /* (586) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,334,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,335,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,334,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,336,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,337,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,335,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,337,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,336,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy929, &yymsp[-1].minor.yy0, yymsp[0].minor.yy503); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy929, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy929, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy929, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy929); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy503 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy503 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-5].minor.yy669, &yymsp[-3].minor.yy57, &yymsp[0].minor.yy929, yymsp[-2].minor.yy872); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-5].minor.yy669, &yymsp[-3].minor.yy57, &yymsp[0].minor.yy929, yymsp[-2].minor.yy872); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy669 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy669 = yymsp[0].minor.yy669; }
  yymsp[0].minor.yy669 = yylhsminor.yy669;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy669 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy669 = yymsp[-2].minor.yy669 | yymsp[0].minor.yy669; }
  yymsp[-2].minor.yy669 = yylhsminor.yy669;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy669 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy669 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy57.first = yymsp[-2].minor.yy0; yylhsminor.yy57.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy57 = yylhsminor.yy57;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy57.first = yymsp[-2].minor.yy929; yylhsminor.yy57.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy57 = yylhsminor.yy57;
        break;
      case 42: /* priv_level ::= db_name NK_DOT table_name */
{ yylhsminor.yy57.first = yymsp[-2].minor.yy929; yylhsminor.yy57.second = yymsp[0].minor.yy929; }
  yymsp[-2].minor.yy57 = yylhsminor.yy57;
        break;
      case 43: /* priv_level ::= topic_name */
{ yylhsminor.yy57.first = yymsp[0].minor.yy929; yylhsminor.yy57.second = nil_token; }
  yymsp[0].minor.yy57 = yylhsminor.yy57;
        break;
      case 44: /* with_opt ::= */
      case 137: /* start_opt ::= */ yytestcase(yyruleno==137);
      case 141: /* end_opt ::= */ yytestcase(yyruleno==141);
      case 265: /* like_pattern_opt ::= */ yytestcase(yyruleno==265);
      case 342: /* subtable_opt ::= */ yytestcase(yyruleno==342);
      case 460: /* case_when_else_opt ::= */ yytestcase(yyruleno==460);
      case 490: /* from_clause_opt ::= */ yytestcase(yyruleno==490);
      case 519: /* where_clause_opt ::= */ yytestcase(yyruleno==519);
      case 528: /* twindow_clause_opt ::= */ yytestcase(yyruleno==528);
      case 534: /* sliding_opt ::= */ yytestcase(yyruleno==534);
      case 536: /* fill_opt ::= */ yytestcase(yyruleno==536);
      case 550: /* having_clause_opt ::= */ yytestcase(yyruleno==550);
      case 552: /* range_opt ::= */ yytestcase(yyruleno==552);
      case 554: /* every_opt ::= */ yytestcase(yyruleno==554);
      case 567: /* slimit_clause_opt ::= */ yytestcase(yyruleno==567);
      case 571: /* limit_clause_opt ::= */ yytestcase(yyruleno==571);
{ yymsp[1].minor.yy872 = NULL; }
        break;
      case 45: /* with_opt ::= WITH search_condition */
      case 491: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==491);
      case 520: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==520);
      case 551: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==551);
{ yymsp[-1].minor.yy872 = yymsp[0].minor.yy872; }
        break;
      case 46: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy929, NULL); }
        break;
      case 47: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy929, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy857); }
        break;
      case 49: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy929, yymsp[0].minor.yy857); }
        break;
      case 50: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 51: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 52: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* dnode_endpoint ::= NK_STRING */
      case 55: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==55);
      case 56: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==56);
      case 289: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==289);
      case 290: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==290);
      case 291: /* sma_func_name ::= LAST */ yytestcase(yyruleno==291);
      case 292: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==292);
      case 386: /* db_name ::= NK_ID */ yytestcase(yyruleno==386);
      case 387: /* table_name ::= NK_ID */ yytestcase(yyruleno==387);
      case 388: /* column_name ::= NK_ID */ yytestcase(yyruleno==388);
      case 389: /* function_name ::= NK_ID */ yytestcase(yyruleno==389);
      case 390: /* table_alias ::= NK_ID */ yytestcase(yyruleno==390);
      case 391: /* column_alias ::= NK_ID */ yytestcase(yyruleno==391);
      case 392: /* user_name ::= NK_ID */ yytestcase(yyruleno==392);
      case 393: /* topic_name ::= NK_ID */ yytestcase(yyruleno==393);
      case 394: /* stream_name ::= NK_ID */ yytestcase(yyruleno==394);
      case 395: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==395);
      case 396: /* index_name ::= NK_ID */ yytestcase(yyruleno==396);
      case 436: /* noarg_func ::= NOW */ yytestcase(yyruleno==436);
      case 437: /* noarg_func ::= TODAY */ yytestcase(yyruleno==437);
      case 438: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==438);
      case 439: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==439);
      case 440: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==440);
      case 441: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==441);
      case 442: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==442);
      case 443: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==443);
      case 444: /* noarg_func ::= USER */ yytestcase(yyruleno==444);
      case 445: /* star_func ::= COUNT */ yytestcase(yyruleno==445);
      case 446: /* star_func ::= FIRST */ yytestcase(yyruleno==446);
      case 447: /* star_func ::= LAST */ yytestcase(yyruleno==447);
      case 448: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==448);
{ yylhsminor.yy929 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy929 = yylhsminor.yy929;
        break;
      case 57: /* force_opt ::= */
      case 77: /* not_exists_opt ::= */ yytestcase(yyruleno==77);
      case 79: /* exists_opt ::= */ yytestcase(yyruleno==79);
      case 309: /* analyze_opt ::= */ yytestcase(yyruleno==309);
      case 316: /* agg_func_opt ::= */ yytestcase(yyruleno==316);
      case 322: /* or_replace_opt ::= */ yytestcase(yyruleno==322);
      case 344: /* ignore_opt ::= */ yytestcase(yyruleno==344);
      case 509: /* set_quantifier_opt ::= */ yytestcase(yyruleno==509);
{ yymsp[1].minor.yy857 = false; }
        break;
      case 58: /* force_opt ::= FORCE */
      case 310: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==310);
      case 317: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==317);
      case 510: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==510);
{ yymsp[0].minor.yy857 = true; }
        break;
      case 59: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 60: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 67: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 68: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 69: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy857, &yymsp[-1].minor.yy929, yymsp[0].minor.yy872); }
        break;
      case 70: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy857, &yymsp[0].minor.yy929); }
        break;
      case 71: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy929); }
        break;
      case 72: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy929, yymsp[0].minor.yy872); }
        break;
      case 73: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy929); }
        break;
      case 74: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy929, yymsp[0].minor.yy580); }
        break;
      case 75: /* cmd ::= COMPACT DATABASE db_name start_opt end_opt */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[-2].minor.yy929, yymsp[-1].minor.yy872, yymsp[0].minor.yy872); }
        break;
      case 76: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy857 = true; }
        break;
      case 78: /* exists_opt ::= IF EXISTS */
      case 323: /* or_replace_opt ::= OR REPLACE */ yytestcase(yyruleno==323);
      case 345: /* ignore_opt ::= IGNORE UNTREATED */ yytestcase(yyruleno==345);
{ yymsp[-1].minor.yy857 = true; }
        break;
      case 80: /* db_options ::= */
{ yymsp[1].minor.yy872 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 81: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 82: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 83: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 84: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 85: /* db_options ::= db_options DURATION NK_INTEGER */
      case 86: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==86);
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 87: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 88: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 89: /* db_options ::= db_options KEEP integer_list */
      case 90: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==90);
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_KEEP, yymsp[0].minor.yy664); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 91: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 92: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 93: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 94: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 95: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 96: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 97: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 98: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_RETENTIONS, yymsp[0].minor.yy664); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 99: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 100: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 101: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 103: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-3].minor.yy872, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy872 = yylhsminor.yy872;
        break;
      case 104: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 105: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-3].minor.yy872, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy872 = yylhsminor.yy872;
        break;
      case 106: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 107: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 108: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 109: /* db_options ::= db_options TABLE_PREFIX signed */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_TABLE_PREFIX, yymsp[0].minor.yy872); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 110: /* db_options ::= db_options TABLE_SUFFIX signed */
{ yylhsminor.yy872 = setDatabaseOption(pCxt, yymsp[-2].minor.yy872, DB_OPTION_TABLE_SUFFIX, yymsp[0].minor.yy872); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 111: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy872 = createAlterDatabaseOptions(pCxt); yylhsminor.yy872 = setAlterDatabaseOption(pCxt, yylhsminor.yy872, &yymsp[0].minor.yy605); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 112: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy872 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy872, &yymsp[0].minor.yy605); }
  yymsp[-1].minor.yy872 = yylhsminor.yy872;
        break;
      case 113: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy605.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 115: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= KEEP integer_list */
      case 118: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==118);
{ yymsp[-1].minor.yy605.type = DB_OPTION_KEEP; yymsp[-1].minor.yy605.pList = yymsp[0].minor.yy664; }
        break;
      case 119: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_PAGES; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 121: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_WAL; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 122: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 123: /* alter_db_option ::= MINROWS NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_MINROWS; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 124: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 125: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy605.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-2].minor.yy605.val = t;
                                                                                  }
        break;
      case 126: /* alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 127: /* alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy605.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-2].minor.yy605.val = t;
                                                                                  }
        break;
      case 128: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy664 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy664 = yylhsminor.yy664;
        break;
      case 129: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 355: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==355);
{ yylhsminor.yy664 = addNodeToList(pCxt, yymsp[-2].minor.yy664, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy664 = yylhsminor.yy664;
        break;
      case 130: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy664 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy664 = yylhsminor.yy664;
        break;
      case 131: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy664 = addNodeToList(pCxt, yymsp[-2].minor.yy664, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy664 = yylhsminor.yy664;
        break;
      case 132: /* retention_list ::= retention */
      case 162: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==162);
      case 165: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==165);
      case 172: /* column_def_list ::= column_def */ yytestcase(yyruleno==172);
      case 215: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==215);
      case 220: /* col_name_list ::= col_name */ yytestcase(yyruleno==220);
      case 271: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==271);
      case 285: /* func_list ::= func */ yytestcase(yyruleno==285);
      case 384: /* literal_list ::= signed_literal */ yytestcase(yyruleno==384);
      case 451: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==451);
      case 457: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==457);
      case 512: /* select_list ::= select_item */ yytestcase(yyruleno==512);
      case 523: /* partition_list ::= partition_item */ yytestcase(yyruleno==523);
      case 578: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==578);
{ yylhsminor.yy664 = createNodeList(pCxt, yymsp[0].minor.yy872); }
  yymsp[0].minor.yy664 = yylhsminor.yy664;
        break;
      case 133: /* retention_list ::= retention_list NK_COMMA retention */
      case 166: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==166);
      case 173: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==173);
      case 216: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==216);
      case 221: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==221);
      case 272: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==272);
      case 286: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==286);
      case 385: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==385);
      case 452: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==452);
      case 513: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==513);
      case 524: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==524);
      case 579: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==579);
{ yylhsminor.yy664 = addNodeToList(pCxt, yymsp[-2].minor.yy664, yymsp[0].minor.yy872); }
  yymsp[-2].minor.yy664 = yylhsminor.yy664;
        break;
      case 134: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy872 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 135: /* speed_opt ::= */
      case 318: /* bufsize_opt ::= */ yytestcase(yyruleno==318);
{ yymsp[1].minor.yy580 = 0; }
        break;
      case 136: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 319: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==319);
{ yymsp[-1].minor.yy580 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 138: /* start_opt ::= START WITH NK_INTEGER */
      case 142: /* end_opt ::= END WITH NK_INTEGER */ yytestcase(yyruleno==142);
{ yymsp[-2].minor.yy872 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 139: /* start_opt ::= START WITH NK_STRING */
      case 143: /* end_opt ::= END WITH NK_STRING */ yytestcase(yyruleno==143);
{ yymsp[-2].minor.yy872 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 140: /* start_opt ::= START WITH TIMESTAMP NK_STRING */
      case 144: /* end_opt ::= END WITH TIMESTAMP NK_STRING */ yytestcase(yyruleno==144);
{ yymsp[-3].minor.yy872 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 145: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 147: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==147);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy857, yymsp[-5].minor.yy872, yymsp[-3].minor.yy664, yymsp[-1].minor.yy664, yymsp[0].minor.yy872); }
        break;
      case 146: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy664); }
        break;
      case 148: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy664); }
        break;
      case 149: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy857, yymsp[0].minor.yy872); }
        break;
      case 150: /* cmd ::= ALTER TABLE alter_table_clause */
      case 357: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==357);
      case 358: /* cmd ::= insert_query */ yytestcase(yyruleno==358);
{ pCxt->pRootNode = yymsp[0].minor.yy872; }
        break;
      case 151: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy872); }
        break;
      case 152: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy872 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy872, yymsp[0].minor.yy872); }
  yymsp[-1].minor.yy872 = yylhsminor.yy872;
        break;
      case 153: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy872 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy872, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy929, yymsp[0].minor.yy784); }
  yymsp[-4].minor.yy872 = yylhsminor.yy872;
        break;
      case 154: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy872 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy872, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy929); }
  yymsp[-3].minor.yy872 = yylhsminor.yy872;
        break;
      case 155: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy872 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy872, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy929, yymsp[0].minor.yy784); }
  yymsp[-4].minor.yy872 = yylhsminor.yy872;
        break;
      case 156: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy872 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy872, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy929, &yymsp[0].minor.yy929); }
  yymsp[-4].minor.yy872 = yylhsminor.yy872;
        break;
      case 157: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy872 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy872, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy929, yymsp[0].minor.yy784); }
  yymsp[-4].minor.yy872 = yylhsminor.yy872;
        break;
      case 158: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy872 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy872, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy929); }
  yymsp[-3].minor.yy872 = yylhsminor.yy872;
        break;
      case 159: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy872 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy872, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy929, yymsp[0].minor.yy784); }
  yymsp[-4].minor.yy872 = yylhsminor.yy872;
        break;
      case 160: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy872 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy872, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy929, &yymsp[0].minor.yy929); }
  yymsp[-4].minor.yy872 = yylhsminor.yy872;
        break;
      case 161: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy872 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy872, &yymsp[-2].minor.yy929, yymsp[0].minor.yy872); }
  yymsp[-5].minor.yy872 = yylhsminor.yy872;
        break;
      case 163: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 458: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==458);
{ yylhsminor.yy664 = addNodeToList(pCxt, yymsp[-1].minor.yy664, yymsp[0].minor.yy872); }
  yymsp[-1].minor.yy664 = yylhsminor.yy664;
        break;
      case 164: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy872 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy857, yymsp[-8].minor.yy872, yymsp[-6].minor.yy872, yymsp[-5].minor.yy664, yymsp[-2].minor.yy664, yymsp[0].minor.yy872); }
  yymsp[-9].minor.yy872 = yylhsminor.yy872;
        break;
      case 167: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy872 = createDropTableClause(pCxt, yymsp[-1].minor.yy857, yymsp[0].minor.yy872); }
  yymsp[-1].minor.yy872 = yylhsminor.yy872;
        break;
      case 168: /* specific_cols_opt ::= */
      case 198: /* tags_def_opt ::= */ yytestcase(yyruleno==198);
      case 270: /* tag_list_opt ::= */ yytestcase(yyruleno==270);
      case 328: /* col_list_opt ::= */ yytestcase(yyruleno==328);
      case 330: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==330);
      case 521: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==521);
      case 546: /* group_by_clause_opt ::= */ yytestcase(yyruleno==546);
      case 565: /* order_by_clause_opt ::= */ yytestcase(yyruleno==565);
{ yymsp[1].minor.yy664 = NULL; }
        break;
      case 169: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 329: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==329);
{ yymsp[-2].minor.yy664 = yymsp[-1].minor.yy664; }
        break;
      case 170: /* full_table_name ::= table_name */
{ yylhsminor.yy872 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy929, NULL); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 171: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy872 = createRealTableNode(pCxt, &yymsp[-2].minor.yy929, &yymsp[0].minor.yy929, NULL); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 174: /* column_def ::= column_name type_name */
{ yylhsminor.yy872 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy929, yymsp[0].minor.yy784, NULL); }
  yymsp[-1].minor.yy872 = yylhsminor.yy872;
        break;
      case 175: /* type_name ::= BOOL */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 176: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 177: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 178: /* type_name ::= INT */
      case 179: /* type_name ::= INTEGER */ yytestcase(yyruleno==179);
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 180: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 181: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 182: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 183: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy784 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 184: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 185: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy784 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 186: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy784 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 187: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy784 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 188: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy784 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 189: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy784 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 190: /* type_name ::= JSON */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 191: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy784 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 192: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 193: /* type_name ::= BLOB */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 194: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy784 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 195: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy784 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 196: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy784 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 197: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy784 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 199: /* tags_def_opt ::= tags_def */
      case 331: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==331);
      case 450: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==450);
{ yylhsminor.yy664 = yymsp[0].minor.yy664; }
  yymsp[0].minor.yy664 = yylhsminor.yy664;
        break;
      case 200: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 332: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==332);
{ yymsp[-3].minor.yy664 = yymsp[-1].minor.yy664; }
        break;
      case 201: /* table_options ::= */
{ yymsp[1].minor.yy872 = createDefaultTableOptions(pCxt); }
        break;
      case 202: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy872 = setTableOption(pCxt, yymsp[-2].minor.yy872, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 203: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy872 = setTableOption(pCxt, yymsp[-2].minor.yy872, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy664); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 204: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy872 = setTableOption(pCxt, yymsp[-2].minor.yy872, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy664); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 205: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy872 = setTableOption(pCxt, yymsp[-4].minor.yy872, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy664); }
  yymsp[-4].minor.yy872 = yylhsminor.yy872;
        break;
      case 206: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy872 = setTableOption(pCxt, yymsp[-2].minor.yy872, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 207: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy872 = setTableOption(pCxt, yymsp[-4].minor.yy872, TABLE_OPTION_SMA, yymsp[-1].minor.yy664); }
  yymsp[-4].minor.yy872 = yylhsminor.yy872;
        break;
      case 208: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy872 = setTableOption(pCxt, yymsp[-2].minor.yy872, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy664); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 209: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy872 = createAlterTableOptions(pCxt); yylhsminor.yy872 = setTableOption(pCxt, yylhsminor.yy872, yymsp[0].minor.yy605.type, &yymsp[0].minor.yy605.val); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 210: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy872 = setTableOption(pCxt, yymsp[-1].minor.yy872, yymsp[0].minor.yy605.type, &yymsp[0].minor.yy605.val); }
  yymsp[-1].minor.yy872 = yylhsminor.yy872;
        break;
      case 211: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy605.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 212: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy605.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 213: /* duration_list ::= duration_literal */
      case 414: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==414);
{ yylhsminor.yy664 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy872)); }
  yymsp[0].minor.yy664 = yylhsminor.yy664;
        break;
      case 214: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 415: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==415);
{ yylhsminor.yy664 = addNodeToList(pCxt, yymsp[-2].minor.yy664, releaseRawExprNode(pCxt, yymsp[0].minor.yy872)); }
  yymsp[-2].minor.yy664 = yylhsminor.yy664;
        break;
      case 217: /* rollup_func_name ::= function_name */
{ yylhsminor.yy872 = createFunctionNode(pCxt, &yymsp[0].minor.yy929, NULL); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 218: /* rollup_func_name ::= FIRST */
      case 219: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==219);
      case 274: /* tag_item ::= QTAGS */ yytestcase(yyruleno==274);
{ yylhsminor.yy872 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 222: /* col_name ::= column_name */
      case 275: /* tag_item ::= column_name */ yytestcase(yyruleno==275);
{ yylhsminor.yy872 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy929); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 223: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 224: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 225: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 226: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 227: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy872, yymsp[0].minor.yy872, OP_TYPE_LIKE); }
        break;
      case 228: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy872, yymsp[0].minor.yy872, OP_TYPE_LIKE); }
        break;
      case 229: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy872, NULL, OP_TYPE_LIKE); }
        break;
      case 230: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 231: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 232: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 233: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy872, yymsp[-1].minor.yy872, OP_TYPE_EQUAL); }
        break;
      case 234: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 235: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 236: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 237: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 238: /* cmd ::= SHOW LICENCES */
      case 239: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==239);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 240: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy929); }
        break;
      case 241: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy872); }
        break;
      case 242: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy872); }
        break;
      case 243: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 244: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 245: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 246: /* cmd ::= SHOW VARIABLES */
      case 247: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==247);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 248: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 249: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy872); }
        break;
      case 250: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 251: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 252: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 253: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 254: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy872); }
        break;
      case 255: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 256: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 257: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy872, yymsp[-1].minor.yy872, OP_TYPE_EQUAL); }
        break;
      case 258: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy872, yymsp[0].minor.yy872, yymsp[-3].minor.yy664); }
        break;
      case 259: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 260: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 261: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy872,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 262: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 263: /* db_name_cond_opt ::= */
      case 268: /* from_db_opt ::= */ yytestcase(yyruleno==268);
{ yymsp[1].minor.yy872 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 264: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy872 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy929); }
  yymsp[-1].minor.yy872 = yylhsminor.yy872;
        break;
      case 266: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy872 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 267: /* table_name_cond ::= table_name */
{ yylhsminor.yy872 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy929); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 269: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy872 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy929); }
        break;
      case 273: /* tag_item ::= TBNAME */
{ yylhsminor.yy872 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 276: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy872 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy929), &yymsp[0].minor.yy929); }
  yymsp[-1].minor.yy872 = yylhsminor.yy872;
        break;
      case 277: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy872 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy929), &yymsp[0].minor.yy929); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 278: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy857, yymsp[-3].minor.yy872, yymsp[-1].minor.yy872, NULL, yymsp[0].minor.yy872); }
        break;
      case 279: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy857, yymsp[-5].minor.yy872, yymsp[-3].minor.yy872, yymsp[-1].minor.yy664, NULL); }
        break;
      case 280: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy857, yymsp[0].minor.yy872); }
        break;
      case 281: /* full_index_name ::= index_name */
{ yylhsminor.yy872 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy929); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 282: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy872 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy929, &yymsp[0].minor.yy929); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 283: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy872 = createIndexOption(pCxt, yymsp[-7].minor.yy664, releaseRawExprNode(pCxt, yymsp[-3].minor.yy872), NULL, yymsp[-1].minor.yy872, yymsp[0].minor.yy872); }
        break;
      case 284: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy872 = createIndexOption(pCxt, yymsp[-9].minor.yy664, releaseRawExprNode(pCxt, yymsp[-5].minor.yy872), releaseRawExprNode(pCxt, yymsp[-3].minor.yy872), yymsp[-1].minor.yy872, yymsp[0].minor.yy872); }
        break;
      case 287: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy872 = createFunctionNode(pCxt, &yymsp[-3].minor.yy929, yymsp[-1].minor.yy664); }
  yymsp[-3].minor.yy872 = yylhsminor.yy872;
        break;
      case 288: /* sma_func_name ::= function_name */
      case 501: /* alias_opt ::= table_alias */ yytestcase(yyruleno==501);
{ yylhsminor.yy929 = yymsp[0].minor.yy929; }
  yymsp[0].minor.yy929 = yylhsminor.yy929;
        break;
      case 293: /* sma_stream_opt ::= */
      case 333: /* stream_options ::= */ yytestcase(yyruleno==333);
{ yymsp[1].minor.yy872 = createStreamOptions(pCxt); }
        break;
      case 294: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy872)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy872); yylhsminor.yy872 = yymsp[-2].minor.yy872; }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 295: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy872)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy872); yylhsminor.yy872 = yymsp[-2].minor.yy872; }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 296: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy872)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy872); yylhsminor.yy872 = yymsp[-2].minor.yy872; }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 297: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy857, &yymsp[-2].minor.yy929, yymsp[0].minor.yy872); }
        break;
      case 298: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy857, &yymsp[-3].minor.yy929, &yymsp[0].minor.yy929, false); }
        break;
      case 299: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy857, &yymsp[-5].minor.yy929, &yymsp[0].minor.yy929, true); }
        break;
      case 300: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy857, &yymsp[-3].minor.yy929, yymsp[0].minor.yy872, false); }
        break;
      case 301: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy857, &yymsp[-5].minor.yy929, yymsp[0].minor.yy872, true); }
        break;
      case 302: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy857, &yymsp[0].minor.yy929); }
        break;
      case 303: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy857, &yymsp[-2].minor.yy929, &yymsp[0].minor.yy929); }
        break;
      case 304: /* cmd ::= DESC full_table_name */
      case 305: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==305);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy872); }
        break;
      case 306: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 307: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 308: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==308);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy857, yymsp[-1].minor.yy872, yymsp[0].minor.yy872); }
        break;
      case 311: /* explain_options ::= */
{ yymsp[1].minor.yy872 = createDefaultExplainOptions(pCxt); }
        break;
      case 312: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy872 = setExplainVerbose(pCxt, yymsp[-2].minor.yy872, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 313: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy872 = setExplainRatio(pCxt, yymsp[-2].minor.yy872, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 314: /* cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy857, yymsp[-9].minor.yy857, &yymsp[-6].minor.yy929, &yymsp[-4].minor.yy0, yymsp[-2].minor.yy784, yymsp[-1].minor.yy580, &yymsp[0].minor.yy929, yymsp[-10].minor.yy857); }
        break;
      case 315: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy857, &yymsp[0].minor.yy929); }
        break;
      case 320: /* language_opt ::= */
{ yymsp[1].minor.yy929 = nil_token; }
        break;
      case 321: /* language_opt ::= LANGUAGE NK_STRING */
{ yymsp[-1].minor.yy929 = yymsp[0].minor.yy0; }
        break;
      case 324: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy857, &yymsp[-8].minor.yy929, yymsp[-5].minor.yy872, yymsp[-7].minor.yy872, yymsp[-3].minor.yy664, yymsp[-2].minor.yy872, yymsp[0].minor.yy872, yymsp[-4].minor.yy664); }
        break;
      case 325: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy857, &yymsp[0].minor.yy929); }
        break;
      case 326: /* cmd ::= PAUSE STREAM exists_opt stream_name */
{ pCxt->pRootNode = createPauseStreamStmt(pCxt, yymsp[-1].minor.yy857, &yymsp[0].minor.yy929); }
        break;
      case 327: /* cmd ::= RESUME STREAM exists_opt ignore_opt stream_name */
{ pCxt->pRootNode = createResumeStreamStmt(pCxt, yymsp[-2].minor.yy857, yymsp[-1].minor.yy857, &yymsp[0].minor.yy929); }
        break;
      case 334: /* stream_options ::= stream_options TRIGGER AT_ONCE */
      case 335: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */ yytestcase(yyruleno==335);
{ yylhsminor.yy872 = setStreamOptions(pCxt, yymsp[-2].minor.yy872, SOPT_TRIGGER_TYPE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 336: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ yylhsminor.yy872 = setStreamOptions(pCxt, yymsp[-3].minor.yy872, SOPT_TRIGGER_TYPE_SET, &yymsp[-1].minor.yy0, releaseRawExprNode(pCxt, yymsp[0].minor.yy872)); }
  yymsp[-3].minor.yy872 = yylhsminor.yy872;
        break;
      case 337: /* stream_options ::= stream_options WATERMARK duration_literal */
{ yylhsminor.yy872 = setStreamOptions(pCxt, yymsp[-2].minor.yy872, SOPT_WATERMARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy872)); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 338: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ yylhsminor.yy872 = setStreamOptions(pCxt, yymsp[-3].minor.yy872, SOPT_IGNORE_EXPIRED_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy872 = yylhsminor.yy872;
        break;
      case 339: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ yylhsminor.yy872 = setStreamOptions(pCxt, yymsp[-2].minor.yy872, SOPT_FILL_HISTORY_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 340: /* stream_options ::= stream_options DELETE_MARK duration_literal */
{ yylhsminor.yy872 = setStreamOptions(pCxt, yymsp[-2].minor.yy872, SOPT_DELETE_MARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy872)); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 341: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ yylhsminor.yy872 = setStreamOptions(pCxt, yymsp[-3].minor.yy872, SOPT_IGNORE_UPDATE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy872 = yylhsminor.yy872;
        break;
      case 343: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 535: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==535);
      case 555: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==555);
{ yymsp[-3].minor.yy872 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy872); }
        break;
      case 346: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 347: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 348: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 349: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 350: /* cmd ::= BALANCE VGROUP LEADER */
{ pCxt->pRootNode = createBalanceVgroupLeaderStmt(pCxt); }
        break;
      case 351: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 352: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy664); }
        break;
      case 353: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 354: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy664 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 356: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy872, yymsp[0].minor.yy872); }
        break;
      case 359: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy872 = createInsertStmt(pCxt, yymsp[-4].minor.yy872, yymsp[-2].minor.yy664, yymsp[0].minor.yy872); }
        break;
      case 360: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy872 = createInsertStmt(pCxt, yymsp[-1].minor.yy872, NULL, yymsp[0].minor.yy872); }
        break;
      case 361: /* literal ::= NK_INTEGER */
{ yylhsminor.yy872 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 362: /* literal ::= NK_FLOAT */
{ yylhsminor.yy872 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 363: /* literal ::= NK_STRING */
{ yylhsminor.yy872 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 364: /* literal ::= NK_BOOL */
{ yylhsminor.yy872 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 365: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy872 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy872 = yylhsminor.yy872;
        break;
      case 366: /* literal ::= duration_literal */
      case 376: /* signed_literal ::= signed */ yytestcase(yyruleno==376);
      case 397: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==397);
      case 398: /* expression ::= literal */ yytestcase(yyruleno==398);
      case 399: /* expression ::= pseudo_column */ yytestcase(yyruleno==399);
      case 400: /* expression ::= column_reference */ yytestcase(yyruleno==400);
      case 401: /* expression ::= function_expression */ yytestcase(yyruleno==401);
      case 402: /* expression ::= case_when_expression */ yytestcase(yyruleno==402);
      case 433: /* function_expression ::= literal_func */ yytestcase(yyruleno==433);
      case 482: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==482);
      case 486: /* boolean_primary ::= predicate */ yytestcase(yyruleno==486);
      case 488: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==488);
      case 489: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==489);
      case 492: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==492);
      case 494: /* table_reference ::= table_primary */ yytestcase(yyruleno==494);
      case 495: /* table_reference ::= joined_table */ yytestcase(yyruleno==495);
      case 499: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==499);
      case 557: /* query_simple ::= query_specification */ yytestcase(yyruleno==557);
      case 558: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==558);
      case 561: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==561);
      case 563: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==563);
{ yylhsminor.yy872 = yymsp[0].minor.yy872; }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 367: /* literal ::= NULL */
{ yylhsminor.yy872 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 368: /* literal ::= NK_QUESTION */
{ yylhsminor.yy872 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 369: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy872 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 370: /* signed ::= NK_INTEGER */
{ yylhsminor.yy872 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 371: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy872 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 372: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy872 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy872 = yylhsminor.yy872;
        break;
      case 373: /* signed ::= NK_FLOAT */
{ yylhsminor.yy872 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 374: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy872 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 375: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy872 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy872 = yylhsminor.yy872;
        break;
      case 377: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy872 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 378: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy872 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 379: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy872 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 380: /* signed_literal ::= duration_literal */
      case 382: /* signed_literal ::= literal_func */ yytestcase(yyruleno==382);
      case 453: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==453);
      case 515: /* select_item ::= common_expression */ yytestcase(yyruleno==515);
      case 525: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==525);
      case 562: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==562);
      case 564: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==564);
      case 577: /* search_condition ::= common_expression */ yytestcase(yyruleno==577);
{ yylhsminor.yy872 = releaseRawExprNode(pCxt, yymsp[0].minor.yy872); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 381: /* signed_literal ::= NULL */
{ yylhsminor.yy872 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 383: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy872 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 403: /* expression ::= NK_LP expression NK_RP */
      case 487: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==487);
      case 576: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==576);
{ yylhsminor.yy872 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy872)); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 404: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy872);
                                                                                    yylhsminor.yy872 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy872));
                                                                                  }
  yymsp[-1].minor.yy872 = yylhsminor.yy872;
        break;
      case 405: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy872);
                                                                                    yylhsminor.yy872 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy872), NULL));
                                                                                  }
  yymsp[-1].minor.yy872 = yylhsminor.yy872;
        break;
      case 406: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy872);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy872);
                                                                                    yylhsminor.yy872 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy872), releaseRawExprNode(pCxt, yymsp[0].minor.yy872))); 
                                                                                  }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 407: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy872);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy872);
                                                                                    yylhsminor.yy872 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy872), releaseRawExprNode(pCxt, yymsp[0].minor.yy872))); 
                                                                                  }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 408: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy872);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy872);
                                                                                    yylhsminor.yy872 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy872), releaseRawExprNode(pCxt, yymsp[0].minor.yy872))); 
                                                                                  }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 409: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy872);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy872);
                                                                                    yylhsminor.yy872 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy872), releaseRawExprNode(pCxt, yymsp[0].minor.yy872))); 
                                                                                  }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 410: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy872);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy872);
                                                                                    yylhsminor.yy872 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy872), releaseRawExprNode(pCxt, yymsp[0].minor.yy872)));
                                                                                  }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 411: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy872);
                                                                                    yylhsminor.yy872 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy872), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 412: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy872);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy872);
                                                                                    yylhsminor.yy872 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy872), releaseRawExprNode(pCxt, yymsp[0].minor.yy872)));
                                                                                  }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 413: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy872);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy872);
                                                                                    yylhsminor.yy872 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy872), releaseRawExprNode(pCxt, yymsp[0].minor.yy872)));
                                                                                  }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 416: /* column_reference ::= column_name */
{ yylhsminor.yy872 = createRawExprNode(pCxt, &yymsp[0].minor.yy929, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy929)); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 417: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy872 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy929, &yymsp[0].minor.yy929, createColumnNode(pCxt, &yymsp[-2].minor.yy929, &yymsp[0].minor.yy929)); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 418: /* pseudo_column ::= ROWTS */
      case 419: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==419);
      case 421: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==421);
      case 422: /* pseudo_column ::= QEND */ yytestcase(yyruleno==422);
      case 423: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==423);
      case 424: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==424);
      case 425: /* pseudo_column ::= WEND */ yytestcase(yyruleno==425);
      case 426: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==426);
      case 427: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==427);
      case 428: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==428);
      case 429: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==429);
      case 435: /* literal_func ::= NOW */ yytestcase(yyruleno==435);
{ yylhsminor.yy872 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 420: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy872 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy929, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy929)))); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 430: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 431: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==431);
{ yylhsminor.yy872 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy929, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy929, yymsp[-1].minor.yy664)); }
  yymsp[-3].minor.yy872 = yylhsminor.yy872;
        break;
      case 432: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy872 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy872), yymsp[-1].minor.yy784)); }
  yymsp[-5].minor.yy872 = yylhsminor.yy872;
        break;
      case 434: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy872 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy929, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy929, NULL)); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 449: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy664 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy664 = yylhsminor.yy664;
        break;
      case 454: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 518: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==518);
{ yylhsminor.yy872 = createColumnNode(pCxt, &yymsp[-2].minor.yy929, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 455: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy872 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy664, yymsp[-1].minor.yy872)); }
  yymsp[-3].minor.yy872 = yylhsminor.yy872;
        break;
      case 456: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy872 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy872), yymsp[-2].minor.yy664, yymsp[-1].minor.yy872)); }
  yymsp[-4].minor.yy872 = yylhsminor.yy872;
        break;
      case 459: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy872 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy872), releaseRawExprNode(pCxt, yymsp[0].minor.yy872)); }
        break;
      case 461: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy872 = releaseRawExprNode(pCxt, yymsp[0].minor.yy872); }
        break;
      case 462: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 467: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==467);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy872);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy872);
                                                                                    yylhsminor.yy872 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy380, releaseRawExprNode(pCxt, yymsp[-2].minor.yy872), releaseRawExprNode(pCxt, yymsp[0].minor.yy872)));
                                                                                  }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 463: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy872);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy872);
                                                                                    yylhsminor.yy872 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy872), releaseRawExprNode(pCxt, yymsp[-2].minor.yy872), releaseRawExprNode(pCxt, yymsp[0].minor.yy872)));
                                                                                  }
  yymsp[-4].minor.yy872 = yylhsminor.yy872;
        break;
      case 464: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy872);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy872);
                                                                                    yylhsminor.yy872 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy872), releaseRawExprNode(pCxt, yymsp[-2].minor.yy872), releaseRawExprNode(pCxt, yymsp[0].minor.yy872)));
                                                                                  }
  yymsp[-5].minor.yy872 = yylhsminor.yy872;
        break;
      case 465: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy872);
                                                                                    yylhsminor.yy872 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy872), NULL));
                                                                                  }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 466: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy872);
                                                                                    yylhsminor.yy872 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy872), NULL));
                                                                                  }
  yymsp[-3].minor.yy872 = yylhsminor.yy872;
        break;
      case 468: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy380 = OP_TYPE_LOWER_THAN; }
        break;
      case 469: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy380 = OP_TYPE_GREATER_THAN; }
        break;
      case 470: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy380 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 471: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy380 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 472: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy380 = OP_TYPE_NOT_EQUAL; }
        break;
      case 473: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy380 = OP_TYPE_EQUAL; }
        break;
      case 474: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy380 = OP_TYPE_LIKE; }
        break;
      case 475: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy380 = OP_TYPE_NOT_LIKE; }
        break;
      case 476: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy380 = OP_TYPE_MATCH; }
        break;
      case 477: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy380 = OP_TYPE_NMATCH; }
        break;
      case 478: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy380 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 479: /* in_op ::= IN */
{ yymsp[0].minor.yy380 = OP_TYPE_IN; }
        break;
      case 480: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy380 = OP_TYPE_NOT_IN; }
        break;
      case 481: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy872 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy664)); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 483: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy872);
                                                                                    yylhsminor.yy872 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy872), NULL));
                                                                                  }
  yymsp[-1].minor.yy872 = yylhsminor.yy872;
        break;
      case 484: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy872);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy872);
                                                                                    yylhsminor.yy872 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy872), releaseRawExprNode(pCxt, yymsp[0].minor.yy872)));
                                                                                  }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 485: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy872);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy872);
                                                                                    yylhsminor.yy872 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy872), releaseRawExprNode(pCxt, yymsp[0].minor.yy872)));
                                                                                  }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 493: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy872 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy872, yymsp[0].minor.yy872, NULL); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 496: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy872 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy929, &yymsp[0].minor.yy929); }
  yymsp[-1].minor.yy872 = yylhsminor.yy872;
        break;
      case 497: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy872 = createRealTableNode(pCxt, &yymsp[-3].minor.yy929, &yymsp[-1].minor.yy929, &yymsp[0].minor.yy929); }
  yymsp[-3].minor.yy872 = yylhsminor.yy872;
        break;
      case 498: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy872 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy872), &yymsp[0].minor.yy929); }
  yymsp[-1].minor.yy872 = yylhsminor.yy872;
        break;
      case 500: /* alias_opt ::= */
{ yymsp[1].minor.yy929 = nil_token;  }
        break;
      case 502: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy929 = yymsp[0].minor.yy929; }
        break;
      case 503: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 504: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==504);
{ yymsp[-2].minor.yy872 = yymsp[-1].minor.yy872; }
        break;
      case 505: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy872 = createJoinTableNode(pCxt, yymsp[-4].minor.yy852, yymsp[-5].minor.yy872, yymsp[-2].minor.yy872, yymsp[0].minor.yy872); }
  yymsp[-5].minor.yy872 = yylhsminor.yy872;
        break;
      case 506: /* join_type ::= */
{ yymsp[1].minor.yy852 = JOIN_TYPE_INNER; }
        break;
      case 507: /* join_type ::= INNER */
{ yymsp[0].minor.yy852 = JOIN_TYPE_INNER; }
        break;
      case 508: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy872 = createSelectStmt(pCxt, yymsp[-10].minor.yy857, yymsp[-9].minor.yy664, yymsp[-8].minor.yy872);
                                                                                    yymsp[-11].minor.yy872 = addWhereClause(pCxt, yymsp[-11].minor.yy872, yymsp[-7].minor.yy872);
                                                                                    yymsp[-11].minor.yy872 = addPartitionByClause(pCxt, yymsp[-11].minor.yy872, yymsp[-6].minor.yy664);
                                                                                    yymsp[-11].minor.yy872 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy872, yymsp[-2].minor.yy872);
                                                                                    yymsp[-11].minor.yy872 = addGroupByClause(pCxt, yymsp[-11].minor.yy872, yymsp[-1].minor.yy664);
                                                                                    yymsp[-11].minor.yy872 = addHavingClause(pCxt, yymsp[-11].minor.yy872, yymsp[0].minor.yy872);
                                                                                    yymsp[-11].minor.yy872 = addRangeClause(pCxt, yymsp[-11].minor.yy872, yymsp[-5].minor.yy872);
                                                                                    yymsp[-11].minor.yy872 = addEveryClause(pCxt, yymsp[-11].minor.yy872, yymsp[-4].minor.yy872);
                                                                                    yymsp[-11].minor.yy872 = addFillClause(pCxt, yymsp[-11].minor.yy872, yymsp[-3].minor.yy872);
                                                                                  }
        break;
      case 511: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy857 = false; }
        break;
      case 514: /* select_item ::= NK_STAR */
{ yylhsminor.yy872 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy872 = yylhsminor.yy872;
        break;
      case 516: /* select_item ::= common_expression column_alias */
      case 526: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==526);
{ yylhsminor.yy872 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy872), &yymsp[0].minor.yy929); }
  yymsp[-1].minor.yy872 = yylhsminor.yy872;
        break;
      case 517: /* select_item ::= common_expression AS column_alias */
      case 527: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==527);
{ yylhsminor.yy872 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy872), &yymsp[0].minor.yy929); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 522: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 547: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==547);
      case 566: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==566);
{ yymsp[-2].minor.yy664 = yymsp[0].minor.yy664; }
        break;
      case 529: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy872 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy872), releaseRawExprNode(pCxt, yymsp[-1].minor.yy872)); }
        break;
      case 530: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy872 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy872)); }
        break;
      case 531: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy872 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy872), NULL, yymsp[-1].minor.yy872, yymsp[0].minor.yy872); }
        break;
      case 532: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy872 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy872), releaseRawExprNode(pCxt, yymsp[-3].minor.yy872), yymsp[-1].minor.yy872, yymsp[0].minor.yy872); }
        break;
      case 533: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy872 = createEventWindowNode(pCxt, yymsp[-3].minor.yy872, yymsp[0].minor.yy872); }
        break;
      case 537: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy872 = createFillNode(pCxt, yymsp[-1].minor.yy294, NULL); }
        break;
      case 538: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
{ yymsp[-5].minor.yy872 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy664)); }
        break;
      case 539: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
{ yymsp[-5].minor.yy872 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy664)); }
        break;
      case 540: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy294 = FILL_MODE_NONE; }
        break;
      case 541: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy294 = FILL_MODE_PREV; }
        break;
      case 542: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy294 = FILL_MODE_NULL; }
        break;
      case 543: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy294 = FILL_MODE_NULL_F; }
        break;
      case 544: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy294 = FILL_MODE_LINEAR; }
        break;
      case 545: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy294 = FILL_MODE_NEXT; }
        break;
      case 548: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy664 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy872))); }
  yymsp[0].minor.yy664 = yylhsminor.yy664;
        break;
      case 549: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy664 = addNodeToList(pCxt, yymsp[-2].minor.yy664, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy872))); }
  yymsp[-2].minor.yy664 = yylhsminor.yy664;
        break;
      case 553: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy872 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy872), releaseRawExprNode(pCxt, yymsp[-1].minor.yy872)); }
        break;
      case 556: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy872 = addOrderByClause(pCxt, yymsp[-3].minor.yy872, yymsp[-2].minor.yy664);
                                                                                    yylhsminor.yy872 = addSlimitClause(pCxt, yylhsminor.yy872, yymsp[-1].minor.yy872);
                                                                                    yylhsminor.yy872 = addLimitClause(pCxt, yylhsminor.yy872, yymsp[0].minor.yy872);
                                                                                  }
  yymsp[-3].minor.yy872 = yylhsminor.yy872;
        break;
      case 559: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy872 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy872, yymsp[0].minor.yy872); }
  yymsp[-3].minor.yy872 = yylhsminor.yy872;
        break;
      case 560: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy872 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy872, yymsp[0].minor.yy872); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 568: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 572: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==572);
{ yymsp[-1].minor.yy872 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 569: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 573: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==573);
{ yymsp[-3].minor.yy872 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 570: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 574: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==574);
{ yymsp[-3].minor.yy872 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 575: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy872 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy872); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 580: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy872 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy872), yymsp[-1].minor.yy578, yymsp[0].minor.yy457); }
  yymsp[-2].minor.yy872 = yylhsminor.yy872;
        break;
      case 581: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy578 = ORDER_ASC; }
        break;
      case 582: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy578 = ORDER_ASC; }
        break;
      case 583: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy578 = ORDER_DESC; }
        break;
      case 584: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy457 = NULL_ORDER_DEFAULT; }
        break;
      case 585: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy457 = NULL_ORDER_FIRST; }
        break;
      case 586: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy457 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
