/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 430
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  int64_t yy49;
  SDataType yy84;
  EFillMode yy134;
  SToken yy149;
  EOrder yy158;
  int32_t yy160;
  SNode* yy312;
  EOperatorType yy320;
  int8_t yy363;
  SAlterOption yy405;
  ENullOrder yy417;
  bool yy497;
  SNodeList* yy824;
  EJoinType yy832;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             675
#define YYNRULE              496
#define YYNTOKEN             309
#define YY_MAX_SHIFT         674
#define YY_MIN_SHIFTREDUCE   985
#define YY_MAX_SHIFTREDUCE   1480
#define YY_ERROR_ACTION      1481
#define YY_ACCEPT_ACTION     1482
#define YY_NO_ACTION         1483
#define YY_MIN_REDUCE        1484
#define YY_MAX_REDUCE        1979
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2512)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   436, 1813,  437, 1519,  444,  345,  437, 1519, 1674, 1676,
 /*    10 */    33,   32,   39,   37,   40,   38,   36,   35,   34, 1620,
 /*    20 */   340,  530, 1281, 1801,   40,   38,   36,   35,   34, 1831,
 /*    30 */  1797, 1681,  117, 1357, 1797, 1279, 1770,  582,  312,  474,
 /*    40 */    30,  260, 1783, 1525,  581,  385,  148, 1679, 1496, 1629,
 /*    50 */  1035, 1813, 1034, 1801, 1793, 1799, 1352,  558, 1793, 1799,
 /*    60 */   329,   14, 1675, 1676, 1797,  472,  575, 1845, 1287, 1546,
 /*    70 */   575,   94, 1814,  584, 1816, 1817,  580, 1485,  575, 1831,
 /*    80 */  1036, 1891,  303,  362, 1802,  306, 1887,  582, 1793, 1799,
 /*    90 */   335,  666, 1783,    1,  581, 1797, 1451, 1957,  107, 1957,
 /*   100 */   575,  106,  105,  104,  103,  102,  101,  100,   99,   98,
 /*   110 */   166, 1681,  165, 1307, 1954,  671, 1954, 1845,  328, 1793,
 /*   120 */  1799,  149, 1814,  584, 1816, 1817,  580, 1679,  575, 1359,
 /*   130 */  1360,  575,  648,  647,  646,  645,  350, 1607,  644,  643,
 /*   140 */   128,  638,  637,  636,  635,  634,  633,  632,  631,  139,
 /*   150 */   627,  626,  625,  349,  348,  622,  621,  620,  619,  618,
 /*   160 */    36,   35,   34,   33,   32,  559, 1971,   40,   38,   36,
 /*   170 */    35,   34,  556,  556, 1306, 1282,  556, 1280, 1136,  606,
 /*   180 */   605,  604, 1140,  603, 1142, 1143,  602, 1145,  599,   63,
 /*   190 */  1151,  596, 1153, 1154,  593,  590,  453,  453, 1285, 1286,
 /*   200 */   553, 1334, 1335, 1337, 1338, 1339, 1340, 1341, 1342,  577,
 /*   210 */   573, 1350, 1351, 1353, 1354, 1355, 1356, 1358, 1361,   39,
 /*   220 */    37, 1420, 1178, 1179, 1307, 1831,  500,  340,  127, 1281,
 /*   230 */    33,   32,  167,  546,   40,   38,   36,   35,   34,  498,
 /*   240 */  1357,  496, 1279,  486,  485,   43,   42,   63,  558,  107,
 /*   250 */   123,  379,  106,  105,  104,  103,  102,  101,  100,   99,
 /*   260 */    98,  481,  484, 1352,  491,   22,  125,  480,   14,  545,
 /*   270 */   378,   84,  377, 1018, 1813, 1287,   39,   37,  530,  501,
 /*   280 */  1417,  250, 1899,  552,  340,  551, 1281,  478, 1957,  117,
 /*   290 */  1813, 1957, 1622,  209,    7,  327,  479, 1357, 1507, 1279,
 /*   300 */     2,  166, 1831,  146,  164, 1954, 1629,  494, 1954,  477,
 /*   310 */   582,  488, 1631, 1022, 1023, 1783,  208,  581, 1831,  150,
 /*   320 */  1352, 1957,  671, 1588,  435,   14,  579,  439,  167, 1441,
 /*   330 */   558, 1783, 1287,  581, 1956,  422, 1359, 1360, 1954, 1783,
 /*   340 */  1845,  135,  173,  517,   94, 1814,  584, 1816, 1817,  580,
 /*   350 */   326,  575,   58, 1729, 1891,   57, 1845,    2,  306, 1887,
 /*   360 */   293, 1814,  584, 1816, 1817,  580,  578,  575,  572, 1863,
 /*   370 */  1957, 1484,  539, 1439, 1440, 1442, 1443,  222,   71,  671,
 /*   380 */   146,   70, 1282,  164, 1280,  167,  167, 1954, 1506, 1632,
 /*   390 */   177,  176,   54, 1359, 1360,  116,  115,  114,  113,  112,
 /*   400 */   111,  110,  109,  108,   63, 1285, 1286, 1098, 1334, 1335,
 /*   410 */  1337, 1338, 1339, 1340, 1341, 1342,  577,  573, 1350, 1351,
 /*   420 */  1353, 1354, 1355, 1356, 1358, 1361,   33,   32, 1681, 1783,
 /*   430 */    40,   38,   36,   35,   34,  344,   26, 1261, 1262, 1282,
 /*   440 */  1100, 1280,   33,   32, 1679,   28,   40,   38,   36,   35,
 /*   450 */    34,   33,   32,  217,  562,   40,   38,   36,   35,   34,
 /*   460 */  1813,  317, 1285, 1286,  542, 1334, 1335, 1337, 1338, 1339,
 /*   470 */  1340, 1341, 1342,  577,  573, 1350, 1351, 1353, 1354, 1355,
 /*   480 */  1356, 1358, 1361,   39,   37,  302, 1413, 1304, 1831,  530,
 /*   490 */    63,  340,   78, 1281,  415,  210,  557,  427,  223,  224,
 /*   500 */    55, 1783, 1957,  581, 1357, 1308, 1279,  441,  516, 1416,
 /*   510 */   353, 1957, 1431, 1304,  400,  165,  428, 1629,  402, 1954,
 /*   520 */   318,   49,  316,  315, 1955,  476, 1845, 1352, 1954,  478,
 /*   530 */    95, 1814,  584, 1816, 1817,  580, 1722,  575, 1306, 1287,
 /*   540 */  1891,  548,  543,  167,  331, 1887,  159,  172, 1957, 1281,
 /*   550 */  1957,  477,   76,  305,  674,   64,  520,  305,  163,  393,
 /*   560 */   520,  164, 1279,  164,    8, 1954, 1917, 1954,  267,  553,
 /*   570 */   547,  389,  158,   33,   32,  343,  346,   40,   38,   36,
 /*   580 */    35,   34,  156,  146,  146, 1668,  671,  664,  660,  656,
 /*   590 */   652,  265, 1631, 1631, 1482, 1287, 1035,  127, 1034,  426,
 /*   600 */  1359, 1360,  421,  420,  419,  418,  417,  414,  413,  412,
 /*   610 */   411,  410,  406,  405,  404,  403,  397,  396,  395,  394,
 /*   620 */  1505,  391,  390,  314,  617, 1424, 1036,   92, 1367,  167,
 /*   630 */   230, 1306,   33,   32, 1306,  125,   40,   38,   36,   35,
 /*   640 */    34, 1305,  671, 1381,   63,  615, 1282,  252, 1280,  555,
 /*   650 */   160, 1899, 1900,  355, 1904,  352,   11,   10,  483,  482,
 /*   660 */   167, 1783,  563,  527,  137,  136,  612,  611,  610, 1285,
 /*   670 */  1286, 1732, 1334, 1335, 1337, 1338, 1339, 1340, 1341, 1342,
 /*   680 */   577,  573, 1350, 1351, 1353, 1354, 1355, 1356, 1358, 1361,
 /*   690 */    39,   37, 1362, 1957, 1287, 1957,  219,  502,  340,  374,
 /*   700 */  1281,   74, 1282,  167, 1280,   27,  164,   74,  164,   91,
 /*   710 */  1954, 1357, 1954, 1279, 1255, 1386,  212, 1504,  376,  372,
 /*   720 */   122, 1605,  124, 1625, 1813, 1285, 1286, 1722, 1503, 1624,
 /*   730 */  1621, 1502, 1477,  530, 1352,   33,   32, 1957,  175,   40,
 /*   740 */    38,   36,   35,   34,  169,  530, 1287,   39,   37, 1393,
 /*   750 */   164,  530, 1831, 1549, 1954,  340,  383, 1281, 1783, 1501,
 /*   760 */   582, 1629,  384,  443,  553, 1783,  439,  581, 1357, 1783,
 /*   770 */  1279,    9, 1783, 1629,  530,  642,  640,  517,  530, 1629,
 /*   780 */   558,  617,   61,  167, 1306,  392,  145, 1730, 1500,  407,
 /*   790 */  1845, 1352,  127,  671,  285, 1814,  584, 1816, 1817,  580,
 /*   800 */  1783,  575, 1629, 1287,  337,  336, 1629, 1359, 1360,  609,
 /*   810 */  1499,  530,  530, 1336, 1295,  530, 1336,  486,  485, 1476,
 /*   820 */  1957, 1319,  408,  451,  123, 1357,  452, 1288,    9, 1783,
 /*   830 */   125,  530, 1498,  166, 1495,  481,  484, 1954,  629, 1629,
 /*   840 */  1629,  480, 1626, 1629, 1309,  161, 1899, 1900, 1352, 1904,
 /*   850 */   671, 1783, 1728, 1282,  300, 1280,  630, 1618, 1601, 1629,
 /*   860 */  1287,   90,   33,   32, 1359, 1360,   40,   38,   36,   35,
 /*   870 */    34,   87, 1727, 1783,  300, 1783, 1285, 1286, 1494, 1334,
 /*   880 */  1335, 1337, 1338, 1339, 1340, 1341, 1342,  577,  573, 1350,
 /*   890 */  1351, 1353, 1354, 1355, 1356, 1358, 1361,  530,  530,  553,
 /*   900 */   530,  201,  530,  530,  199, 1906,  509,  570,  347,  503,
 /*   910 */  1282,  510, 1280,  514,  227,  307, 1614, 1493,  613, 1783,
 /*   920 */  1492, 1672, 1491, 1022, 1023, 1629, 1629,  127, 1629, 1903,
 /*   930 */  1629, 1629, 1490, 1285, 1286, 1489, 1334, 1335, 1337, 1338,
 /*   940 */  1339, 1340, 1341, 1342,  577,  573, 1350, 1351, 1353, 1354,
 /*   950 */  1355, 1356, 1358, 1361,   39,   37, 1379,  530, 1783,  530,
 /*   960 */  1616, 1783,  340, 1783, 1281,  125, 1336, 1296,  526, 1291,
 /*   970 */   528, 1911, 1413, 1783,  196, 1357, 1783, 1279, 1488, 1487,
 /*   980 */   162, 1899, 1900, 1606, 1904, 1629,  232, 1629,  152, 1813,
 /*   990 */  1299, 1301, 1906,  470,  466,  462,  458,  195, 1352, 1681,
 /*  1000 */    44,    4,  573, 1350, 1351, 1353, 1354, 1355, 1356, 1604,
 /*  1010 */  1287, 1380,  530,  530,  386, 1680, 1902, 1831,  614, 1783,
 /*  1020 */  1783, 1672,  324,  529,  261,  582, 1906,  387,  560,  147,
 /*  1030 */  1783,  565,  581,   75,  278,    2,  193,  571,   33,   32,
 /*  1040 */  1629, 1629,   40,   38,   36,   35,   34,   41,  276,   60,
 /*  1050 */  1901,  272,   59,  203, 1659, 1845,  202,  671,  216,  294,
 /*  1060 */  1814,  584, 1816, 1817,  580,  221,  575,  131,  180,  432,
 /*  1070 */   430, 1359, 1360,   29,  338, 1374, 1375, 1376, 1377, 1378,
 /*  1080 */  1382, 1383, 1384, 1385,  205, 1290,  207,  204,  615,  206,
 /*  1090 */  1536,  307,   53,  513,   11,   10, 1289,   77, 1232,  192,
 /*  1100 */   186, 1531,  191, 1529,   63, 1589,  449,  137,  136,  612,
 /*  1110 */   611,  610,  487,  134,  615,  135,  225, 1282,  523, 1280,
 /*  1120 */    51,  236,  184,  489, 1319,  492, 1479, 1480, 1804, 1612,
 /*  1130 */    51,   41, 1379,  137,  136,  612,  611,  610,   41,  588,
 /*  1140 */  1285, 1286,   93, 1334, 1335, 1337, 1338, 1339, 1340, 1341,
 /*  1150 */  1342,  577,  573, 1350, 1351, 1353, 1354, 1355, 1356, 1358,
 /*  1160 */  1361,  134,  135,  119,  229,  134, 1129, 1062,  213,  623,
 /*  1170 */   624, 1438,  239,  576, 1371, 1806,  608, 1497,   68,   67,
 /*  1180 */   382, 1387, 1343,  171,  255,  540,  471, 1380,  244,  271,
 /*  1190 */  1157, 1082, 1080, 1832, 1813,  351, 1520, 1669, 1921,  301,
 /*  1200 */  1063,  554,  370,  254,  368,  364,  360,  357,  354,  249,
 /*  1210 */     3,  257, 1161, 1168, 1166,  259,  138,  356,    5,  361,
 /*  1220 */  1248,  313, 1831,  174, 1304,  268,  388, 1293,  409, 1724,
 /*  1230 */   557,  416,  424,  423,  425, 1783,  429,  581, 1292,  431,
 /*  1240 */   433,  566, 1310,  167, 1312,  434,  442, 1813,  183,   29,
 /*  1250 */   338, 1374, 1375, 1376, 1377, 1378, 1382, 1383, 1384, 1385,
 /*  1260 */  1845,  445,  446,  185,   95, 1814,  584, 1816, 1817,  580,
 /*  1270 */  1311,  575,  447, 1313, 1891, 1831,  188,  450,  331, 1887,
 /*  1280 */   159,  448,  473,  582,  190,   72,   73, 1813, 1783,  454,
 /*  1290 */   581,  194,  269,  475, 1619,  198,  304, 1615,  118,  200,
 /*  1300 */  1918, 1763,  211,  140,  141, 1617, 1613,  504,  214,  505,
 /*  1310 */   142, 1813,  143, 1845,  511, 1831,  515,   95, 1814,  584,
 /*  1320 */  1816, 1817,  580,  582,  575,  218,  508, 1891, 1783,  524,
 /*  1330 */   581,  331, 1887, 1970,  518,   81,  538,  132, 1762, 1831,
 /*  1340 */   323,   83, 1925, 1734,  521, 1309,  270,  582,  325, 1630,
 /*  1350 */   541, 1813, 1783, 1845,  581,    6,  133,  279, 1814,  584,
 /*  1360 */  1816, 1817,  580, 1932,  575,  534,  525,  536,  537,  234,
 /*  1370 */   238,  330,  550,  544,  535,  533,  532, 1845, 1413, 1831,
 /*  1380 */   126,   95, 1814,  584, 1816, 1817,  580,  582,  575, 1922,
 /*  1390 */   245, 1891, 1783, 1931,  581,  331, 1887, 1970,  567, 1308,
 /*  1400 */   564,  248,   48,  332, 1813,   85, 1948, 1907,  586, 1673,
 /*  1410 */  1602,  273,  667,   52,  668, 1913,  243, 1845,  670,  299,
 /*  1420 */   264,   95, 1814,  584, 1816, 1817,  580,  277,  575,  246,
 /*  1430 */   153, 1891, 1831, 1872,  247,  331, 1887, 1970,  275,  286,
 /*  1440 */   582,  296,  295, 1777,  253, 1783, 1910,  581, 1776, 1775,
 /*  1450 */  1953,   65, 1774,  561, 1813,  568,  256, 1973,  258,   66,
 /*  1460 */   558, 1771,  358,  359, 1273, 1274,  170,  363, 1769,  365,
 /*  1470 */  1845, 1813,  366,  367,  285, 1814,  584, 1816, 1817,  580,
 /*  1480 */  1768,  575, 1831,  369, 1767,  371, 1766,  373, 1765,  375,
 /*  1490 */   582, 1251, 1250, 1745, 1744, 1783,  381,  581,  380, 1831,
 /*  1500 */  1957, 1743, 1742, 1220, 1717, 1716, 1715,  582,  129, 1714,
 /*  1510 */  1713, 1712, 1783,  164,  581,   69, 1711, 1954, 1710, 1709,
 /*  1520 */  1845, 1813,  398, 1706,   96, 1814,  584, 1816, 1817,  580,
 /*  1530 */  1708,  575, 1707,  399, 1891,  401, 1705, 1845, 1890, 1887,
 /*  1540 */  1704,   96, 1814,  584, 1816, 1817,  580, 1703,  575, 1831,
 /*  1550 */  1702, 1891, 1701, 1700, 1699,  569, 1887,  582, 1698, 1697,
 /*  1560 */  1696, 1695, 1783, 1694,  581, 1693, 1692,  130, 1691, 1813,
 /*  1570 */  1690, 1689, 1688, 1687, 1686, 1685, 1684, 1222, 1683, 1813,
 /*  1580 */   178, 1550,  179, 1548, 1516,  181,  182, 1845, 1682, 1551,
 /*  1590 */   120,   96, 1814,  584, 1816, 1817,  580, 1831,  575,  157,
 /*  1600 */  1025, 1891,  531,  438, 1024,  582, 1888, 1831,  440, 1515,
 /*  1610 */  1783, 1758,  581, 1752, 1741,  582,  121,  189,  187, 1740,
 /*  1620 */  1783, 1726,  581, 1608, 1547, 1545, 1055, 1543,  455,  456,
 /*  1630 */  1813,  459,  460,  457,  461, 1845, 1541,  463,  464,  294,
 /*  1640 */  1814,  584, 1816, 1817,  580, 1845,  575,  465, 1539,  289,
 /*  1650 */  1814,  584, 1816, 1817,  580,  467,  575,  468, 1831, 1171,
 /*  1660 */  1609,  469, 1528, 1527, 1512, 1610,  582, 1172, 1097,   50,
 /*  1670 */  1096, 1783,  639,  581,  641, 1093, 1092, 1091, 1537,  319,
 /*  1680 */  1532, 1530,  493,  320, 1511,  495, 1510,  549,  490,  321,
 /*  1690 */  1813,  497, 1509,  499,   97, 1757, 1845,  197, 1751,   56,
 /*  1700 */   149, 1814,  584, 1816, 1817,  580,  144,  575, 1813,  506,
 /*  1710 */  1257,  507, 1739, 1737, 1738, 1736, 1735, 1265, 1831,   15,
 /*  1720 */   519, 1733,  220,  226, 1725,  231,  579,   79,  215,   80,
 /*  1730 */    45, 1783,   41,  581,   47,   82, 1831,   23,  233,   16,
 /*  1740 */  1453,  339,  241,  235,  582, 1972,   87,  522, 1435, 1783,
 /*  1750 */   242,  581, 1437, 1804,   25, 1465, 1845,  228, 1813,  237,
 /*  1760 */   293, 1814,  584, 1816, 1817,  580,  322,  575,  251, 1864,
 /*  1770 */   512, 1430,   46, 1803, 1845,   17,  151,  154,  294, 1814,
 /*  1780 */   584, 1816, 1817,  580, 1813,  575, 1831,  240,   18,   24,
 /*  1790 */    86,  341, 1464,  333,  582, 1410, 1409, 1470, 1469, 1783,
 /*  1800 */  1459,  581, 1468,  334,   10, 1297,  155,   19, 1813, 1327,
 /*  1810 */  1372, 1848, 1831,  587,  585,  168,  583, 1347,  574,   31,
 /*  1820 */   582,  342, 1345,   12, 1845, 1783, 1344,  581,  294, 1814,
 /*  1830 */   584, 1816, 1817,  580, 1813,  575, 1831,   13, 1158,   20,
 /*  1840 */    21,  589,  591, 1155,  582,  592,  594, 1152,  595, 1783,
 /*  1850 */  1845,  581,  597,  600,  280, 1814,  584, 1816, 1817,  580,
 /*  1860 */  1146,  575, 1831,  598, 1135, 1144,  601, 1150, 1149,   88,
 /*  1870 */   582, 1148, 1167, 1147, 1845, 1783,  262,  581,  281, 1814,
 /*  1880 */   584, 1816, 1817,  580,  607,  575,   89,   62, 1163, 1053,
 /*  1890 */   616, 1088, 1813, 1087, 1086, 1085, 1084, 1083, 1081, 1079,
 /*  1900 */  1845,  628, 1078, 1077,  288, 1814,  584, 1816, 1817,  580,
 /*  1910 */  1813,  575,  553, 1104,  263, 1075, 1074, 1073, 1072, 1071,
 /*  1920 */  1831, 1070, 1069, 1068, 1099, 1101, 1065, 1064,  582, 1061,
 /*  1930 */  1059, 1060, 1544, 1783, 1058,  581,  649,  650, 1831,  651,
 /*  1940 */   127, 1542,  653,  655, 1540,  654,  582,  657,  659,  658,
 /*  1950 */  1538, 1783,  661,  581,  663, 1526, 1508,  662, 1845,  665,
 /*  1960 */   558, 1015,  290, 1814,  584, 1816, 1817,  580,  266,  575,
 /*  1970 */   669, 1813, 1483, 1283,  274,  672, 1845,  673,  125, 1483,
 /*  1980 */   282, 1814,  584, 1816, 1817,  580, 1483,  575, 1483, 1483,
 /*  1990 */  1483, 1483, 1483,  250, 1899,  552, 1483,  551, 1483, 1831,
 /*  2000 */  1957, 1483, 1483, 1483, 1483, 1483, 1483,  582, 1483, 1483,
 /*  2010 */  1483, 1483, 1783,  164,  581, 1483, 1483, 1954, 1483, 1483,
 /*  2020 */  1483, 1813, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
 /*  2030 */  1483, 1813, 1483, 1483, 1483, 1483, 1483, 1845, 1483, 1483,
 /*  2040 */  1483,  291, 1814,  584, 1816, 1817,  580, 1483,  575, 1831,
 /*  2050 */  1483, 1483, 1483, 1483, 1483, 1483, 1483,  582, 1483, 1831,
 /*  2060 */  1483, 1483, 1783, 1483,  581, 1483, 1483,  582, 1483, 1483,
 /*  2070 */  1483, 1813, 1783, 1483,  581, 1483, 1483, 1483, 1483, 1483,
 /*  2080 */  1483, 1483, 1483, 1483, 1483, 1483, 1483, 1845, 1483, 1483,
 /*  2090 */  1483,  283, 1814,  584, 1816, 1817,  580, 1845,  575, 1831,
 /*  2100 */  1483,  292, 1814,  584, 1816, 1817,  580,  582,  575, 1483,
 /*  2110 */  1483, 1483, 1783, 1483,  581, 1483, 1483, 1483, 1483, 1483,
 /*  2120 */  1483, 1813, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
 /*  2130 */  1483, 1483, 1483, 1813, 1483, 1483, 1483, 1845, 1483, 1483,
 /*  2140 */  1483,  284, 1814,  584, 1816, 1817,  580, 1813,  575, 1831,
 /*  2150 */  1483, 1483, 1483, 1483, 1483, 1483, 1483,  582, 1483, 1483,
 /*  2160 */  1483, 1831, 1783, 1483,  581, 1483, 1483, 1483, 1483,  582,
 /*  2170 */  1483, 1483, 1483, 1483, 1783, 1831,  581, 1483, 1483, 1483,
 /*  2180 */  1483, 1483, 1483,  582, 1483, 1483, 1483, 1845, 1783, 1483,
 /*  2190 */   581,  297, 1814,  584, 1816, 1817,  580, 1483,  575, 1845,
 /*  2200 */  1483, 1483, 1483,  298, 1814,  584, 1816, 1817,  580, 1483,
 /*  2210 */   575, 1483, 1483, 1845, 1483, 1483, 1483, 1825, 1814,  584,
 /*  2220 */  1816, 1817,  580, 1813,  575, 1483, 1483, 1483, 1483, 1483,
 /*  2230 */  1483, 1483, 1483, 1813, 1483, 1483, 1483, 1483, 1483, 1483,
 /*  2240 */  1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
 /*  2250 */  1483, 1831, 1483, 1483, 1483, 1483, 1483, 1483, 1483,  582,
 /*  2260 */  1483, 1831, 1483, 1483, 1783, 1483,  581, 1483, 1483,  582,
 /*  2270 */  1483, 1483, 1483, 1483, 1783, 1483,  581, 1483, 1483, 1483,
 /*  2280 */  1483, 1483, 1483, 1483, 1813, 1483, 1483, 1483, 1483, 1845,
 /*  2290 */  1483, 1483, 1483, 1824, 1814,  584, 1816, 1817,  580, 1845,
 /*  2300 */   575, 1483, 1483, 1823, 1814,  584, 1816, 1817,  580, 1483,
 /*  2310 */   575, 1483, 1831, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
 /*  2320 */   582, 1483, 1483, 1483, 1483, 1783, 1483,  581, 1483, 1483,
 /*  2330 */  1483, 1483, 1483, 1483, 1813, 1483, 1483, 1483, 1483, 1483,
 /*  2340 */  1483, 1483, 1483, 1483, 1813, 1483, 1483, 1483, 1483, 1483,
 /*  2350 */  1845, 1483, 1483, 1483,  310, 1814,  584, 1816, 1817,  580,
 /*  2360 */  1483,  575, 1831, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
 /*  2370 */   582, 1483, 1831, 1483, 1483, 1783, 1483,  581, 1483, 1483,
 /*  2380 */   582, 1483, 1483, 1483, 1813, 1783, 1483,  581, 1483, 1483,
 /*  2390 */  1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
 /*  2400 */  1845, 1483, 1483, 1483,  309, 1814,  584, 1816, 1817,  580,
 /*  2410 */  1845,  575, 1831, 1483,  311, 1814,  584, 1816, 1817,  580,
 /*  2420 */   582,  575, 1483, 1483, 1483, 1783, 1483,  581, 1483, 1483,
 /*  2430 */  1483, 1483, 1483, 1483, 1813, 1483, 1483, 1483, 1483, 1483,
 /*  2440 */  1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
 /*  2450 */  1845, 1483, 1483, 1483,  308, 1814,  584, 1816, 1817,  580,
 /*  2460 */  1483,  575, 1831, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
 /*  2470 */   582, 1483, 1483, 1483, 1483, 1783, 1483,  581, 1483, 1483,
 /*  2480 */  1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
 /*  2490 */  1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483, 1483,
 /*  2500 */  1845, 1483, 1483, 1483,  287, 1814,  584, 1816, 1817,  580,
 /*  2510 */  1483,  575,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   316,  312,  318,  319,  316,  351,  318,  319,  354,  355,
 /*    10 */     8,    9,   12,   13,   12,   13,   14,   15,   16,  342,
 /*    20 */    20,  320,   22,  342,   12,   13,   14,   15,   16,  340,
 /*    30 */   353,  340,  331,   33,  353,   35,    0,  348,  347,  338,
 /*    40 */   393,  394,  353,    0,  355,  320,  311,  356,  313,  348,
 /*    50 */    20,  312,   22,  342,  377,  378,   56,  368,  377,  378,
 /*    60 */   379,   61,  354,  355,  353,   35,  389,  378,   68,    0,
 /*    70 */   389,  382,  383,  384,  385,  386,  387,    0,  389,  340,
 /*    80 */    50,  392,  357,   47,  342,  396,  397,  348,  377,  378,
 /*    90 */   379,   48,  353,   93,  355,  353,   94,  408,   21,  408,
 /*   100 */   389,   24,   25,   26,   27,   28,   29,   30,   31,   32,
 /*   110 */   421,  340,  421,   20,  425,  115,  425,  378,  347,  377,
 /*   120 */   378,  382,  383,  384,  385,  386,  387,  356,  389,  129,
 /*   130 */   130,  389,   63,   64,   65,   66,   67,    0,   69,   70,
 /*   140 */    71,   72,   73,   74,   75,   76,   77,   78,   79,   80,
 /*   150 */    81,   82,   83,   84,   85,   86,   87,   88,   89,   90,
 /*   160 */    14,   15,   16,    8,    9,  426,  427,   12,   13,   14,
 /*   170 */    15,   16,   20,   20,   20,  175,   20,  177,  106,  107,
 /*   180 */   108,  109,  110,  111,  112,  113,  114,  115,  116,   93,
 /*   190 */   118,  119,  120,  121,  122,  123,   60,   60,  198,  199,
 /*   200 */   320,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,   12,
 /*   220 */    13,   14,  129,  130,   20,  340,   21,   20,  348,   22,
 /*   230 */     8,    9,  232,  348,   12,   13,   14,   15,   16,   34,
 /*   240 */    33,   36,   35,   64,   65,   93,   93,   93,  368,   21,
 /*   250 */    71,  368,   24,   25,   26,   27,   28,   29,   30,   31,
 /*   260 */    32,   82,   83,   56,    4,   43,  386,   88,   61,  384,
 /*   270 */   174,  322,  176,    4,  312,   68,   12,   13,  320,   19,
 /*   280 */     4,  401,  402,  403,   20,  405,   22,  105,  408,  331,
 /*   290 */   312,  408,  343,   33,   39,  332,  338,   33,  312,   35,
 /*   300 */    93,  421,  340,  340,  421,  425,  348,   47,  425,  127,
 /*   310 */   348,   51,  349,   44,   45,  353,   56,  355,  340,  325,
 /*   320 */    56,  408,  115,  329,  317,   61,  348,  320,  232,  198,
 /*   330 */   368,  353,   68,  355,  421,   78,  129,  130,  425,  353,
 /*   340 */   378,   43,   56,  355,  382,  383,  384,  385,  386,  387,
 /*   350 */   362,  389,   92,  365,  392,   95,  378,   93,  396,  397,
 /*   360 */   382,  383,  384,  385,  386,  387,  388,  389,  390,  391,
 /*   370 */   408,    0,  241,  242,  243,  244,  245,  124,   92,  115,
 /*   380 */   340,   95,  175,  421,  177,  232,  232,  425,  312,  349,
 /*   390 */   133,  134,   94,  129,  130,   24,   25,   26,   27,   28,
 /*   400 */    29,   30,   31,   32,   93,  198,  199,   35,  201,  202,
 /*   410 */   203,  204,  205,  206,  207,  208,  209,  210,  211,  212,
 /*   420 */   213,  214,  215,  216,  217,  218,    8,    9,  340,  353,
 /*   430 */    12,   13,   14,   15,   16,  347,    2,  184,  185,  175,
 /*   440 */    68,  177,    8,    9,  356,    2,   12,   13,   14,   15,
 /*   450 */    16,    8,    9,   56,   43,   12,   13,   14,   15,   16,
 /*   460 */   312,   37,  198,  199,  160,  201,  202,  203,  204,  205,
 /*   470 */   206,  207,  208,  209,  210,  211,  212,  213,  214,  215,
 /*   480 */   216,  217,  218,   12,   13,   18,  231,   20,  340,  320,
 /*   490 */    93,   20,   95,   22,   27,  125,  348,   30,  124,  125,
 /*   500 */   331,  353,  408,  355,   33,   20,   35,   14,  368,  233,
 /*   510 */   368,  408,   94,   20,   47,  421,   49,  348,   51,  425,
 /*   520 */    96,   93,   98,   99,  421,  101,  378,   56,  425,  105,
 /*   530 */   382,  383,  384,  385,  386,  387,  348,  389,   20,   68,
 /*   540 */   392,  237,  238,  232,  396,  397,  398,  359,  408,   22,
 /*   550 */   408,  127,  182,  183,   19,    4,  186,  183,  410,   92,
 /*   560 */   186,  421,   35,  421,   93,  425,  418,  425,   33,  320,
 /*   570 */    20,  104,  339,    8,    9,  332,  332,   12,   13,   14,
 /*   580 */    15,   16,   47,  340,  340,  352,  115,   52,   53,   54,
 /*   590 */    55,   56,  349,  349,  309,   68,   20,  348,   22,  132,
 /*   600 */   129,  130,  135,  136,  137,  138,  139,  140,  141,  142,
 /*   610 */   143,  144,  145,  146,  147,  148,  149,  150,  151,  152,
 /*   620 */   312,  154,  155,  156,   60,   14,   50,   92,   14,  232,
 /*   630 */    95,   20,    8,    9,   20,  386,   12,   13,   14,   15,
 /*   640 */    16,   20,  115,  157,   93,  105,  175,  162,  177,  400,
 /*   650 */   401,  402,  403,  368,  405,  368,    1,    2,  326,  327,
 /*   660 */   232,  353,  251,  128,  124,  125,  126,  127,  128,  198,
 /*   670 */   199,    0,  201,  202,  203,  204,  205,  206,  207,  208,
 /*   680 */   209,  210,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   690 */    12,   13,   14,  408,   68,  408,  161,  368,   20,  170,
 /*   700 */    22,  324,  175,  232,  177,  219,  421,  324,  421,  322,
 /*   710 */   425,   33,  425,   35,  179,  229,  181,  312,  189,  190,
 /*   720 */   337,    0,  335,  346,  312,  198,  199,  348,  312,  346,
 /*   730 */   343,  312,  167,  320,   56,    8,    9,  408,  359,   12,
 /*   740 */    13,   14,   15,   16,  331,  320,   68,   12,   13,   94,
 /*   750 */   421,  320,  340,    0,  425,   20,  331,   22,  353,  312,
 /*   760 */   348,  348,  331,  317,  320,  353,  320,  355,   33,  353,
 /*   770 */    35,   93,  353,  348,  320,  326,  327,  355,  320,  348,
 /*   780 */   368,   60,    3,  232,   20,  331,  162,  365,  312,  331,
 /*   790 */   378,   56,  348,  115,  382,  383,  384,  385,  386,  387,
 /*   800 */   353,  389,  348,   68,   12,   13,  348,  129,  130,  104,
 /*   810 */   312,  320,  320,  202,   22,  320,  202,   64,   65,  254,
 /*   820 */   408,   94,  331,  331,   71,   33,  331,   35,   93,  353,
 /*   830 */   386,  320,  312,  421,  312,   82,   83,  425,   68,  348,
 /*   840 */   348,   88,  331,  348,   20,  401,  402,  403,   56,  405,
 /*   850 */   115,  353,  364,  175,  366,  177,  328,  341,  330,  348,
 /*   860 */    68,   93,    8,    9,  129,  130,   12,   13,   14,   15,
 /*   870 */    16,  103,  364,  353,  366,  353,  198,  199,  312,  201,
 /*   880 */   202,  203,  204,  205,  206,  207,  208,  209,  210,  211,
 /*   890 */   212,  213,  214,  215,  216,  217,  218,  320,  320,  320,
 /*   900 */   320,   97,  320,  320,  100,  380,  372,  115,  331,  331,
 /*   910 */   175,  331,  177,  331,  331,   61,  341,  312,  350,  353,
 /*   920 */   312,  353,  312,   44,   45,  348,  348,  348,  348,  404,
 /*   930 */   348,  348,  312,  198,  199,  312,  201,  202,  203,  204,
 /*   940 */   205,  206,  207,  208,  209,  210,  211,  212,  213,  214,
 /*   950 */   215,  216,  217,  218,   12,   13,  102,  320,  353,  320,
 /*   960 */   341,  353,   20,  353,   22,  386,  202,  175,  331,  177,
 /*   970 */   331,  230,  231,  353,   33,   33,  353,   35,  312,  312,
 /*   980 */   401,  402,  403,    0,  405,  348,  162,  348,   47,  312,
 /*   990 */   198,  199,  380,   52,   53,   54,   55,   56,   56,  340,
 /*  1000 */    42,   43,  210,  211,  212,  213,  214,  215,  216,    0,
 /*  1010 */    68,  157,  320,  320,   22,  356,  404,  340,  350,  353,
 /*  1020 */   353,  353,  345,  331,  331,  348,  380,   35,  249,   18,
 /*  1030 */   353,   43,  355,   92,   23,   93,   95,   61,    8,    9,
 /*  1040 */   348,  348,   12,   13,   14,   15,   16,   43,   37,   38,
 /*  1050 */   404,  333,   41,   97,  336,  378,  100,  115,   56,  382,
 /*  1060 */   383,  384,  385,  386,  387,   43,  389,   43,   57,   58,
 /*  1070 */    59,  129,  130,  219,  220,  221,  222,  223,  224,  225,
 /*  1080 */   226,  227,  228,  229,   97,   35,   97,  100,  105,  100,
 /*  1090 */     0,   61,  162,  163,    1,    2,   35,   95,   94,  158,
 /*  1100 */   159,    0,  161,    0,   93,  329,  165,  124,  125,  126,
 /*  1110 */   127,  128,   22,   43,  105,   43,   94,  175,   94,  177,
 /*  1120 */    43,   43,  181,   22,   94,   22,  129,  130,   46,  341,
 /*  1130 */    43,   43,  102,  124,  125,  126,  127,  128,   43,   43,
 /*  1140 */   198,  199,  131,  201,  202,  203,  204,  205,  206,  207,
 /*  1150 */   208,  209,  210,  211,  212,  213,  214,  215,  216,  217,
 /*  1160 */   218,   43,   43,   43,   94,   43,   94,   35,  341,   13,
 /*  1170 */    13,   94,   94,  341,  198,   93,  341,  313,  167,  168,
 /*  1180 */   169,   94,   94,  172,  428,  419,  321,  157,  415,   94,
 /*  1190 */    94,   35,   35,  340,  312,  321,  319,  352,  381,  188,
 /*  1200 */    68,  406,  191,  422,  193,  194,  195,  196,  197,  399,
 /*  1210 */   409,  422,   94,   94,   94,  422,   94,  376,  234,   47,
 /*  1220 */   173,  375,  340,   42,   20,  370,  360,  177,  320,  320,
 /*  1230 */   348,  360,  157,  358,  358,  353,  320,  355,  177,  320,
 /*  1240 */   320,  253,   20,  232,   20,  314,  314,  312,  324,  219,
 /*  1250 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*  1260 */   378,  374,  355,  324,  382,  383,  384,  385,  386,  387,
 /*  1270 */    20,  389,  367,   20,  392,  340,  324,  367,  396,  397,
 /*  1280 */   398,  369,  314,  348,  324,  324,  324,  312,  353,  320,
 /*  1290 */   355,  324,  374,  340,  340,  340,  314,  340,  320,  340,
 /*  1300 */   418,  353,  322,  340,  340,  340,  340,  180,  322,  373,
 /*  1310 */   340,  312,  340,  378,  320,  340,  320,  382,  383,  384,
 /*  1320 */   385,  386,  387,  348,  389,  322,  355,  392,  353,  159,
 /*  1330 */   355,  396,  397,  398,  353,  322,  239,  363,  353,  340,
 /*  1340 */   367,  322,  407,  353,  353,   20,  336,  348,  353,  348,
 /*  1350 */   240,  312,  353,  378,  355,  246,  363,  382,  383,  384,
 /*  1360 */   385,  386,  387,  414,  389,  353,  361,  353,  353,  363,
 /*  1370 */   363,  353,  166,  353,  248,  247,  235,  378,  231,  340,
 /*  1380 */   348,  382,  383,  384,  385,  386,  387,  348,  389,  381,
 /*  1390 */   413,  392,  353,  414,  355,  396,  397,  398,  252,   20,
 /*  1400 */   250,  376,   93,  255,  312,   93,  407,  380,  344,  353,
 /*  1410 */   330,  320,   36,  371,  315,  417,  416,  378,  314,  366,
 /*  1420 */   322,  382,  383,  384,  385,  386,  387,  310,  389,  412,
 /*  1430 */   414,  392,  340,  395,  411,  396,  397,  398,  323,  334,
 /*  1440 */   348,  334,  334,    0,  423,  353,  407,  355,    0,    0,
 /*  1450 */   424,  182,    0,  424,  312,  424,  423,  429,  423,   42,
 /*  1460 */   368,    0,   35,  192,   35,   35,   35,  192,    0,   35,
 /*  1470 */   378,  312,   35,  192,  382,  383,  384,  385,  386,  387,
 /*  1480 */     0,  389,  340,  192,    0,   35,    0,   22,    0,   35,
 /*  1490 */   348,  177,  175,    0,    0,  353,  170,  355,  171,  340,
 /*  1500 */   408,    0,    0,   46,    0,    0,    0,  348,   42,    0,
 /*  1510 */     0,    0,  353,  421,  355,  153,    0,  425,    0,    0,
 /*  1520 */   378,  312,  148,    0,  382,  383,  384,  385,  386,  387,
 /*  1530 */     0,  389,    0,   35,  392,  148,    0,  378,  396,  397,
 /*  1540 */     0,  382,  383,  384,  385,  386,  387,    0,  389,  340,
 /*  1550 */     0,  392,    0,    0,    0,  396,  397,  348,    0,    0,
 /*  1560 */     0,    0,  353,    0,  355,    0,    0,   42,    0,  312,
 /*  1570 */     0,    0,    0,    0,    0,    0,    0,   22,    0,  312,
 /*  1580 */    56,    0,   56,    0,    0,   42,   40,  378,    0,    0,
 /*  1590 */    39,  382,  383,  384,  385,  386,  387,  340,  389,   43,
 /*  1600 */    14,  392,  345,   46,   14,  348,  397,  340,   46,    0,
 /*  1610 */   353,    0,  355,    0,    0,  348,   39,  166,   39,    0,
 /*  1620 */   353,    0,  355,    0,    0,    0,   62,    0,   35,   47,
 /*  1630 */   312,   35,   47,   39,   39,  378,    0,   35,   47,  382,
 /*  1640 */   383,  384,  385,  386,  387,  378,  389,   39,    0,  382,
 /*  1650 */   383,  384,  385,  386,  387,   35,  389,   47,  340,   22,
 /*  1660 */     0,   39,    0,    0,    0,    0,  348,   35,   35,  102,
 /*  1670 */    35,  353,   43,  355,   43,   35,   35,   22,    0,   22,
 /*  1680 */     0,    0,   35,   22,    0,   35,    0,  420,   49,   22,
 /*  1690 */   312,   35,    0,   22,   20,    0,  378,  100,    0,  162,
 /*  1700 */   382,  383,  384,  385,  386,  387,  178,  389,  312,   22,
 /*  1710 */    35,  162,    0,    0,    0,    0,    0,   35,  340,   93,
 /*  1720 */   187,    0,   94,   93,    0,   46,  348,   93,  159,   39,
 /*  1730 */   230,  353,   43,  355,   43,   93,  340,   93,   93,  236,
 /*  1740 */    94,  345,   43,   94,  348,  427,  103,  160,   94,  353,
 /*  1750 */    46,  355,   94,   46,   43,   35,  378,  158,  312,   93,
 /*  1760 */   382,  383,  384,  385,  386,  387,  162,  389,   46,  391,
 /*  1770 */   164,   94,   43,   46,  378,  236,   93,   46,  382,  383,
 /*  1780 */   384,  385,  386,  387,  312,  389,  340,   93,   43,   93,
 /*  1790 */    93,  345,   35,   35,  348,   94,   94,   94,   35,  353,
 /*  1800 */    94,  355,   35,   35,    2,   22,   46,   43,  312,   22,
 /*  1810 */   198,   93,  340,   35,  104,   46,  200,   94,   93,   93,
 /*  1820 */   348,   35,   94,   93,  378,  353,   94,  355,  382,  383,
 /*  1830 */   384,  385,  386,  387,  312,  389,  340,  236,   94,   93,
 /*  1840 */    93,   93,   35,   94,  348,   93,   35,   94,   93,  353,
 /*  1850 */   378,  355,   35,   35,  382,  383,  384,  385,  386,  387,
 /*  1860 */    94,  389,  340,   93,   22,   94,   93,  117,  117,   93,
 /*  1870 */   348,  117,   35,  117,  378,  353,   43,  355,  382,  383,
 /*  1880 */   384,  385,  386,  387,  105,  389,   93,   93,   22,   62,
 /*  1890 */    61,   35,  312,   35,   35,   35,   35,   35,   35,   35,
 /*  1900 */   378,   91,   35,   35,  382,  383,  384,  385,  386,  387,
 /*  1910 */   312,  389,  320,   68,   43,   35,   35,   22,   35,   22,
 /*  1920 */   340,   35,   35,   35,   35,   68,   35,   35,  348,   35,
 /*  1930 */    22,   35,    0,  353,   35,  355,   35,   47,  340,   39,
 /*  1940 */   348,    0,   35,   39,    0,   47,  348,   35,   39,   47,
 /*  1950 */     0,  353,   35,  355,   39,    0,    0,   47,  378,   35,
 /*  1960 */   368,   35,  382,  383,  384,  385,  386,  387,   22,  389,
 /*  1970 */    21,  312,  430,   22,   22,   21,  378,   20,  386,  430,
 /*  1980 */   382,  383,  384,  385,  386,  387,  430,  389,  430,  430,
 /*  1990 */   430,  430,  430,  401,  402,  403,  430,  405,  430,  340,
 /*  2000 */   408,  430,  430,  430,  430,  430,  430,  348,  430,  430,
 /*  2010 */   430,  430,  353,  421,  355,  430,  430,  425,  430,  430,
 /*  2020 */   430,  312,  430,  430,  430,  430,  430,  430,  430,  430,
 /*  2030 */   430,  312,  430,  430,  430,  430,  430,  378,  430,  430,
 /*  2040 */   430,  382,  383,  384,  385,  386,  387,  430,  389,  340,
 /*  2050 */   430,  430,  430,  430,  430,  430,  430,  348,  430,  340,
 /*  2060 */   430,  430,  353,  430,  355,  430,  430,  348,  430,  430,
 /*  2070 */   430,  312,  353,  430,  355,  430,  430,  430,  430,  430,
 /*  2080 */   430,  430,  430,  430,  430,  430,  430,  378,  430,  430,
 /*  2090 */   430,  382,  383,  384,  385,  386,  387,  378,  389,  340,
 /*  2100 */   430,  382,  383,  384,  385,  386,  387,  348,  389,  430,
 /*  2110 */   430,  430,  353,  430,  355,  430,  430,  430,  430,  430,
 /*  2120 */   430,  312,  430,  430,  430,  430,  430,  430,  430,  430,
 /*  2130 */   430,  430,  430,  312,  430,  430,  430,  378,  430,  430,
 /*  2140 */   430,  382,  383,  384,  385,  386,  387,  312,  389,  340,
 /*  2150 */   430,  430,  430,  430,  430,  430,  430,  348,  430,  430,
 /*  2160 */   430,  340,  353,  430,  355,  430,  430,  430,  430,  348,
 /*  2170 */   430,  430,  430,  430,  353,  340,  355,  430,  430,  430,
 /*  2180 */   430,  430,  430,  348,  430,  430,  430,  378,  353,  430,
 /*  2190 */   355,  382,  383,  384,  385,  386,  387,  430,  389,  378,
 /*  2200 */   430,  430,  430,  382,  383,  384,  385,  386,  387,  430,
 /*  2210 */   389,  430,  430,  378,  430,  430,  430,  382,  383,  384,
 /*  2220 */   385,  386,  387,  312,  389,  430,  430,  430,  430,  430,
 /*  2230 */   430,  430,  430,  312,  430,  430,  430,  430,  430,  430,
 /*  2240 */   430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
 /*  2250 */   430,  340,  430,  430,  430,  430,  430,  430,  430,  348,
 /*  2260 */   430,  340,  430,  430,  353,  430,  355,  430,  430,  348,
 /*  2270 */   430,  430,  430,  430,  353,  430,  355,  430,  430,  430,
 /*  2280 */   430,  430,  430,  430,  312,  430,  430,  430,  430,  378,
 /*  2290 */   430,  430,  430,  382,  383,  384,  385,  386,  387,  378,
 /*  2300 */   389,  430,  430,  382,  383,  384,  385,  386,  387,  430,
 /*  2310 */   389,  430,  340,  430,  430,  430,  430,  430,  430,  430,
 /*  2320 */   348,  430,  430,  430,  430,  353,  430,  355,  430,  430,
 /*  2330 */   430,  430,  430,  430,  312,  430,  430,  430,  430,  430,
 /*  2340 */   430,  430,  430,  430,  312,  430,  430,  430,  430,  430,
 /*  2350 */   378,  430,  430,  430,  382,  383,  384,  385,  386,  387,
 /*  2360 */   430,  389,  340,  430,  430,  430,  430,  430,  430,  430,
 /*  2370 */   348,  430,  340,  430,  430,  353,  430,  355,  430,  430,
 /*  2380 */   348,  430,  430,  430,  312,  353,  430,  355,  430,  430,
 /*  2390 */   430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
 /*  2400 */   378,  430,  430,  430,  382,  383,  384,  385,  386,  387,
 /*  2410 */   378,  389,  340,  430,  382,  383,  384,  385,  386,  387,
 /*  2420 */   348,  389,  430,  430,  430,  353,  430,  355,  430,  430,
 /*  2430 */   430,  430,  430,  430,  312,  430,  430,  430,  430,  430,
 /*  2440 */   430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
 /*  2450 */   378,  430,  430,  430,  382,  383,  384,  385,  386,  387,
 /*  2460 */   430,  389,  340,  430,  430,  430,  430,  430,  430,  430,
 /*  2470 */   348,  430,  430,  430,  430,  353,  430,  355,  430,  430,
 /*  2480 */   430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
 /*  2490 */   430,  430,  430,  430,  430,  430,  430,  430,  430,  430,
 /*  2500 */   378,  430,  430,  430,  382,  383,  384,  385,  386,  387,
 /*  2510 */   430,  389,
};
#define YY_SHIFT_COUNT    (674)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1957)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1011,    0,    0,  207,  207,  264,  264,  264,  471,  471,
 /*    10 */   264,  264,  678,  735,  942,  735,  735,  735,  735,  735,
 /*    20 */   735,  735,  735,  735,  735,  735,  735,  735,  735,  735,
 /*    30 */   735,  735,  735,  735,  735,  735,  735,  735,  735,  735,
 /*    40 */   735,  735,  153,  153,  152,  152,  152,  792,  792,  154,
 /*    50 */   792,  792,   96,  397,  311,  428,  311,  156,  156,  269,
 /*    60 */   269,  551,   93,  311,  311,  156,  156,  156,  156,  156,
 /*    70 */   156,  156,  156,  156,  156,  136,  156,  156,  156,  204,
 /*    80 */   156,  156,  518,  156,  156,  518,  550,  156,  518,  518,
 /*    90 */   518,  156,  564,  467, 1030,  854,  854,  228,  527,  527,
 /*   100 */   527,  527,  527,  527,  527,  527,  527,  527,  527,  527,
 /*   110 */   527,  527,  527,  527,  527,  527,  527,  424,  179,   93,
 /*   120 */   493,  493,  137,  372,  721,  485,  485,  485,  372,  621,
 /*   130 */   621,  204,  671,  671,  518,  518,  626,  626,  705,  770,
 /*   140 */    72,   72,   72,   72,   72,   72,   72,  535,   77,  565,
 /*   150 */   753,  131,   30,  304,  611,  614,  576,  879,  182,  824,
 /*   160 */   741,  255,  741,  958,  779,  779,  779,  276,  764,  984,
 /*   170 */  1172, 1047, 1181, 1204, 1204, 1181, 1075, 1075, 1204, 1204,
 /*   180 */  1204, 1222, 1222, 1224,  136,  204,  136, 1250, 1253,  136,
 /*   190 */  1250,  136,  136,  136, 1204,  136, 1222,  518,  518,  518,
 /*   200 */   518,  518,  518,  518,  518,  518,  518,  518, 1204, 1222,
 /*   210 */   626, 1224,  564, 1127,  204,  564, 1204, 1204, 1250,  564,
 /*   220 */  1097,  626,  626,  626,  626, 1097,  626, 1170,  564,  705,
 /*   230 */   564,  621, 1325,  626, 1110, 1097,  626,  626, 1110, 1097,
 /*   240 */   626,  626,  518, 1109, 1206, 1110, 1126, 1128, 1141,  984,
 /*   250 */  1147,  621, 1379, 1146, 1150, 1148, 1146, 1150, 1146, 1150,
 /*   260 */  1309, 1312,  626,  770, 1204,  564, 1376, 1222, 2512, 2512,
 /*   270 */  2512, 2512, 2512, 2512, 2512,   69,  941,  371,  260,    2,
 /*   280 */   222,  418,  434,  443,  624,  727,  983,  155,  155,  155,
 /*   290 */   155,  155,  155,  155,  155, 1009,  540,   12,   12,  370,
 /*   300 */   374,  529,  286,  257,  205,  253,  655,  486,  146,  146,
 /*   310 */   146,  146,  298,   36,  992,  804,  956,  987,  989, 1090,
 /*   320 */  1101, 1103, 1002,  930, 1004, 1022, 1024, 1070, 1072, 1077,
 /*   330 */  1078, 1093,  997,  411,  988, 1087, 1050, 1061,  976, 1088,
 /*   340 */  1082, 1095, 1096, 1118, 1119, 1120, 1122,  768, 1156, 1157,
 /*   350 */  1132,   43, 1443, 1448, 1269, 1449, 1452, 1417, 1461, 1427,
 /*   360 */  1271, 1429, 1430, 1431, 1275, 1468, 1434, 1437, 1281, 1480,
 /*   370 */  1291, 1484, 1450, 1486, 1465, 1488, 1454, 1314, 1317, 1493,
 /*   380 */  1494, 1327, 1326, 1501, 1502, 1457, 1504, 1505, 1506, 1466,
 /*   390 */  1509, 1510, 1511, 1362, 1516, 1518, 1519, 1530, 1532, 1374,
 /*   400 */  1498, 1523, 1387, 1536, 1540, 1547, 1550, 1552, 1553, 1554,
 /*   410 */  1558, 1559, 1560, 1561, 1563, 1565, 1566, 1525, 1568, 1570,
 /*   420 */  1571, 1572, 1573, 1574, 1555, 1575, 1576, 1578, 1588, 1589,
 /*   430 */  1524, 1581, 1526, 1583, 1584, 1543, 1551, 1556, 1586, 1557,
 /*   440 */  1590, 1562, 1609, 1546, 1577, 1611, 1613, 1614, 1579, 1451,
 /*   450 */  1619, 1621, 1623, 1564, 1624, 1625, 1593, 1582, 1594, 1627,
 /*   460 */  1596, 1585, 1595, 1636, 1602, 1591, 1608, 1648, 1620, 1610,
 /*   470 */  1622, 1662, 1663, 1664, 1665, 1567, 1597, 1632, 1637, 1660,
 /*   480 */  1633, 1635, 1629, 1631, 1640, 1641, 1655, 1678, 1657, 1680,
 /*   490 */  1661, 1639, 1681, 1667, 1647, 1684, 1650, 1686, 1656, 1692,
 /*   500 */  1671, 1674, 1695, 1537, 1675, 1698, 1528, 1687, 1549, 1569,
 /*   510 */  1712, 1713, 1604, 1606, 1714, 1715, 1716, 1626, 1628, 1682,
 /*   520 */  1533, 1721, 1630, 1587, 1634, 1724, 1690, 1599, 1642, 1643,
 /*   530 */  1679, 1689, 1503, 1644, 1646, 1645, 1649, 1654, 1666, 1691,
 /*   540 */  1658, 1683, 1694, 1696, 1677, 1699, 1704, 1707, 1697, 1711,
 /*   550 */  1539, 1701, 1702, 1722, 1500, 1729, 1727, 1731, 1703, 1745,
 /*   560 */  1601, 1706, 1720, 1757, 1758, 1763, 1767, 1768, 1706, 1802,
 /*   570 */  1783, 1612, 1764, 1718, 1723, 1725, 1728, 1726, 1732, 1760,
 /*   580 */  1730, 1746, 1769, 1787, 1616, 1747, 1710, 1744, 1778, 1786,
 /*   590 */  1748, 1749, 1807, 1752, 1753, 1811, 1755, 1766, 1817, 1770,
 /*   600 */  1771, 1818, 1773, 1750, 1751, 1754, 1756, 1842, 1779, 1776,
 /*   610 */  1793, 1837, 1794, 1833, 1833, 1866, 1827, 1829, 1856, 1858,
 /*   620 */  1859, 1860, 1861, 1862, 1863, 1864, 1867, 1868, 1845, 1810,
 /*   630 */  1871, 1880, 1881, 1895, 1883, 1897, 1886, 1887, 1888, 1857,
 /*   640 */  1629, 1889, 1631, 1891, 1892, 1894, 1896, 1908, 1899, 1932,
 /*   650 */  1901, 1890, 1900, 1941, 1907, 1898, 1904, 1944, 1912, 1902,
 /*   660 */  1909, 1950, 1917, 1910, 1915, 1955, 1924, 1926, 1956, 1946,
 /*   670 */  1949, 1951, 1952, 1954, 1957,
};
#define YY_REDUCE_COUNT (274)
#define YY_REDUCE_MIN   (-353)
#define YY_REDUCE_MAX   (2122)
static const short yy_reduce_ofst[] = {
 /*     0 */   285, -311,  -38,  148,  882,  935,  999, 1039,  412, 1092,
 /*    10 */  1142, 1159,  -22, -261, 1209,  677, 1257, 1267, 1318, 1378,
 /*    20 */  1396, 1446,  975, 1472, 1496, 1522, 1580, 1598, 1659, 1709,
 /*    30 */  1719, 1759, 1809, 1821, 1835, 1911, 1921, 1972, 2022, 2032,
 /*    40 */  2072, 2122, -120, 1592,  249,  444,  579, -319, -289, -309,
 /*    50 */  -323, -258, -117,  140,  142,  287,  329, -299,  -42, -316,
 /*    60 */  -312,  -87, -346,   94,  103,  169,  413,  425,  431,  454,
 /*    70 */   458,  491,  492,  495,  511,  383,  578,  580,  582,  -12,
 /*    80 */   583,  637,  -37,  639,  692, -229, -115,  693,  243,   88,
 /*    90 */   244,  577,  387, -275, -353, -353, -353, -265,  -14,   76,
 /*   100 */   308,  405,  416,  419,  447,  476,  498,  520,  522,  566,
 /*   110 */   605,  608,  610,  620,  623,  666,  667,  233,   -6, -292,
 /*   120 */     7,  446,  377,  332,  -51,  525,  612,  646,  449,  188,
 /*   130 */   379,  422,  488,  508,   40,  659,  568,  668,  718,  528,
 /*   140 */   516,  575,  619,  788,  827,  832,  835,  534,  864,  756,
 /*   150 */   776,  766,  865,  773,  853,  853,  874,  877,  845,  817,
 /*   160 */   795,  795,  795,  810,  781,  789,  793,  801,  853,  841,
 /*   170 */   846,  855,  866,  908,  909,  871,  875,  876,  916,  919,
 /*   180 */   920,  931,  932,  887,  924,  907,  939,  905,  912,  952,
 /*   190 */   910,  960,  961,  962,  969,  967,  968,  953,  954,  955,
 /*   200 */   957,  959,  963,  964,  965,  966,  970,  972,  978,  982,
 /*   210 */   948,  918,  980,  936,  971,  986,  994,  996,  973, 1003,
 /*   220 */   974,  981,  985,  990,  991,  993,  995, 1005, 1013, 1010,
 /*   230 */  1019, 1001, 1008, 1012,  949, 1006, 1014, 1015,  979, 1007,
 /*   240 */  1018, 1020,  853,  998, 1000, 1016,  977, 1017, 1023, 1025,
 /*   250 */   795, 1032, 1027, 1026, 1021, 1028, 1029, 1033, 1031, 1035,
 /*   260 */  1038, 1064, 1056, 1080, 1091, 1098, 1099, 1104, 1042, 1053,
 /*   270 */  1105, 1107, 1108, 1115, 1117,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*    10 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*    20 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*    30 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*    40 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*    50 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*    60 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*    70 */  1481, 1481, 1481, 1481, 1481, 1555, 1481, 1481, 1481, 1481,
 /*    80 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*    90 */  1481, 1481, 1553, 1718, 1481, 1893, 1481, 1481, 1481, 1481,
 /*   100 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   110 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   120 */  1481, 1481, 1555, 1481, 1553, 1905, 1905, 1905, 1481, 1481,
 /*   130 */  1481, 1481, 1759, 1759, 1481, 1481, 1481, 1481, 1658, 1481,
 /*   140 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1753, 1481, 1974,
 /*   150 */  1481, 1481, 1481, 1928, 1481, 1481, 1481, 1481, 1611, 1920,
 /*   160 */  1897, 1911, 1898, 1895, 1959, 1959, 1959, 1914, 1481, 1924,
 /*   170 */  1481, 1746, 1723, 1481, 1481, 1723, 1720, 1720, 1481, 1481,
 /*   180 */  1481, 1481, 1481, 1481, 1555, 1481, 1555, 1481, 1481, 1555,
 /*   190 */  1481, 1555, 1555, 1555, 1481, 1555, 1481, 1481, 1481, 1481,
 /*   200 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   210 */  1481, 1481, 1553, 1755, 1481, 1553, 1481, 1481, 1481, 1553,
 /*   220 */  1933, 1481, 1481, 1481, 1481, 1933, 1481, 1481, 1553, 1481,
 /*   230 */  1553, 1481, 1481, 1481, 1935, 1933, 1481, 1481, 1935, 1933,
 /*   240 */  1481, 1481, 1481, 1947, 1943, 1935, 1951, 1949, 1926, 1924,
 /*   250 */  1911, 1481, 1481, 1965, 1961, 1977, 1965, 1961, 1965, 1961,
 /*   260 */  1481, 1627, 1481, 1481, 1481, 1553, 1513, 1481, 1748, 1759,
 /*   270 */  1661, 1661, 1661, 1556, 1486, 1481, 1481, 1481, 1481, 1481,
 /*   280 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1830, 1946, 1945,
 /*   290 */  1869, 1868, 1867, 1865, 1829, 1481, 1623, 1828, 1827, 1481,
 /*   300 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1821, 1822,
 /*   310 */  1820, 1819, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   320 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   330 */  1481, 1894, 1481, 1962, 1966, 1481, 1481, 1481, 1481, 1481,
 /*   340 */  1805, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   350 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   360 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   370 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   380 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   390 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   400 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   410 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   420 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   430 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1518, 1481, 1481,
 /*   440 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   450 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   460 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   470 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   480 */  1481, 1481, 1594, 1593, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   490 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   500 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   510 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   520 */  1481, 1763, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   530 */  1481, 1927, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   540 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1805, 1481, 1944,
 /*   550 */  1481, 1904, 1900, 1481, 1481, 1896, 1804, 1481, 1481, 1960,
 /*   560 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1889,
 /*   570 */  1481, 1481, 1862, 1847, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   580 */  1481, 1481, 1481, 1481, 1815, 1481, 1481, 1481, 1481, 1481,
 /*   590 */  1655, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   600 */  1481, 1481, 1481, 1640, 1638, 1637, 1636, 1481, 1633, 1481,
 /*   610 */  1481, 1481, 1481, 1664, 1663, 1481, 1481, 1481, 1481, 1481,
 /*   620 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   630 */  1575, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   640 */  1566, 1481, 1565, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   650 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   660 */  1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481, 1481,
 /*   670 */  1481, 1481, 1481, 1481, 1481,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  256,  /*      AFTER => ABORT */
  256,  /*     ATTACH => ABORT */
  256,  /*     BEFORE => ABORT */
  256,  /*      BEGIN => ABORT */
  256,  /*     BITAND => ABORT */
  256,  /*     BITNOT => ABORT */
  256,  /*      BITOR => ABORT */
  256,  /*     BLOCKS => ABORT */
  256,  /*     CHANGE => ABORT */
  256,  /*      COMMA => ABORT */
  256,  /*    COMPACT => ABORT */
  256,  /*     CONCAT => ABORT */
  256,  /*   CONFLICT => ABORT */
  256,  /*       COPY => ABORT */
  256,  /*   DEFERRED => ABORT */
  256,  /* DELIMITERS => ABORT */
  256,  /*     DETACH => ABORT */
  256,  /*     DIVIDE => ABORT */
  256,  /*        DOT => ABORT */
  256,  /*       EACH => ABORT */
  256,  /*        END => ABORT */
  256,  /*       FAIL => ABORT */
  256,  /*       FILE => ABORT */
  256,  /*        FOR => ABORT */
  256,  /*       GLOB => ABORT */
  256,  /*         ID => ABORT */
  256,  /*  IMMEDIATE => ABORT */
  256,  /*     IMPORT => ABORT */
  256,  /*  INITIALLY => ABORT */
  256,  /*    INSTEAD => ABORT */
  256,  /*     ISNULL => ABORT */
  256,  /*        KEY => ABORT */
  256,  /*  NK_BITNOT => ABORT */
  256,  /*    NK_SEMI => ABORT */
  256,  /*    NOTNULL => ABORT */
  256,  /*         OF => ABORT */
  256,  /*       PLUS => ABORT */
  256,  /*  PRIVILEGE => ABORT */
  256,  /*      RAISE => ABORT */
  256,  /*    REPLACE => ABORT */
  256,  /*   RESTRICT => ABORT */
  256,  /*        ROW => ABORT */
  256,  /*       SEMI => ABORT */
  256,  /*       STAR => ABORT */
  256,  /*  STATEMENT => ABORT */
  256,  /*     STRING => ABORT */
  256,  /*      TIMES => ABORT */
  256,  /*     UPDATE => ABORT */
  256,  /*     VALUES => ABORT */
  256,  /*   VARIABLE => ABORT */
  256,  /*       VIEW => ABORT */
  256,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "TRIM",
  /*   60 */ "IF",
  /*   61 */ "NOT",
  /*   62 */ "EXISTS",
  /*   63 */ "BUFFER",
  /*   64 */ "CACHEMODEL",
  /*   65 */ "CACHESIZE",
  /*   66 */ "COMP",
  /*   67 */ "DURATION",
  /*   68 */ "NK_VARIABLE",
  /*   69 */ "MAXROWS",
  /*   70 */ "MINROWS",
  /*   71 */ "KEEP",
  /*   72 */ "PAGES",
  /*   73 */ "PAGESIZE",
  /*   74 */ "TSDB_PAGESIZE",
  /*   75 */ "PRECISION",
  /*   76 */ "REPLICA",
  /*   77 */ "STRICT",
  /*   78 */ "VGROUPS",
  /*   79 */ "SINGLE_STABLE",
  /*   80 */ "RETENTIONS",
  /*   81 */ "SCHEMALESS",
  /*   82 */ "WAL_LEVEL",
  /*   83 */ "WAL_FSYNC_PERIOD",
  /*   84 */ "WAL_RETENTION_PERIOD",
  /*   85 */ "WAL_RETENTION_SIZE",
  /*   86 */ "WAL_ROLL_PERIOD",
  /*   87 */ "WAL_SEGMENT_SIZE",
  /*   88 */ "STT_TRIGGER",
  /*   89 */ "TABLE_PREFIX",
  /*   90 */ "TABLE_SUFFIX",
  /*   91 */ "NK_COLON",
  /*   92 */ "TABLE",
  /*   93 */ "NK_LP",
  /*   94 */ "NK_RP",
  /*   95 */ "STABLE",
  /*   96 */ "ADD",
  /*   97 */ "COLUMN",
  /*   98 */ "MODIFY",
  /*   99 */ "RENAME",
  /*  100 */ "TAG",
  /*  101 */ "SET",
  /*  102 */ "NK_EQ",
  /*  103 */ "USING",
  /*  104 */ "TAGS",
  /*  105 */ "COMMENT",
  /*  106 */ "BOOL",
  /*  107 */ "TINYINT",
  /*  108 */ "SMALLINT",
  /*  109 */ "INT",
  /*  110 */ "INTEGER",
  /*  111 */ "BIGINT",
  /*  112 */ "FLOAT",
  /*  113 */ "DOUBLE",
  /*  114 */ "BINARY",
  /*  115 */ "TIMESTAMP",
  /*  116 */ "NCHAR",
  /*  117 */ "UNSIGNED",
  /*  118 */ "JSON",
  /*  119 */ "VARCHAR",
  /*  120 */ "MEDIUMBLOB",
  /*  121 */ "BLOB",
  /*  122 */ "VARBINARY",
  /*  123 */ "DECIMAL",
  /*  124 */ "MAX_DELAY",
  /*  125 */ "WATERMARK",
  /*  126 */ "ROLLUP",
  /*  127 */ "TTL",
  /*  128 */ "SMA",
  /*  129 */ "FIRST",
  /*  130 */ "LAST",
  /*  131 */ "SHOW",
  /*  132 */ "DATABASES",
  /*  133 */ "TABLES",
  /*  134 */ "STABLES",
  /*  135 */ "MNODES",
  /*  136 */ "MODULES",
  /*  137 */ "QNODES",
  /*  138 */ "FUNCTIONS",
  /*  139 */ "INDEXES",
  /*  140 */ "ACCOUNTS",
  /*  141 */ "APPS",
  /*  142 */ "CONNECTIONS",
  /*  143 */ "LICENCES",
  /*  144 */ "GRANTS",
  /*  145 */ "QUERIES",
  /*  146 */ "SCORES",
  /*  147 */ "TOPICS",
  /*  148 */ "VARIABLES",
  /*  149 */ "BNODES",
  /*  150 */ "SNODES",
  /*  151 */ "CLUSTER",
  /*  152 */ "TRANSACTIONS",
  /*  153 */ "DISTRIBUTED",
  /*  154 */ "CONSUMERS",
  /*  155 */ "SUBSCRIPTIONS",
  /*  156 */ "VNODES",
  /*  157 */ "LIKE",
  /*  158 */ "INDEX",
  /*  159 */ "FUNCTION",
  /*  160 */ "INTERVAL",
  /*  161 */ "TOPIC",
  /*  162 */ "AS",
  /*  163 */ "WITH",
  /*  164 */ "META",
  /*  165 */ "CONSUMER",
  /*  166 */ "GROUP",
  /*  167 */ "DESC",
  /*  168 */ "DESCRIBE",
  /*  169 */ "RESET",
  /*  170 */ "QUERY",
  /*  171 */ "CACHE",
  /*  172 */ "EXPLAIN",
  /*  173 */ "ANALYZE",
  /*  174 */ "VERBOSE",
  /*  175 */ "NK_BOOL",
  /*  176 */ "RATIO",
  /*  177 */ "NK_FLOAT",
  /*  178 */ "OUTPUTTYPE",
  /*  179 */ "AGGREGATE",
  /*  180 */ "BUFSIZE",
  /*  181 */ "STREAM",
  /*  182 */ "INTO",
  /*  183 */ "TRIGGER",
  /*  184 */ "AT_ONCE",
  /*  185 */ "WINDOW_CLOSE",
  /*  186 */ "IGNORE",
  /*  187 */ "EXPIRED",
  /*  188 */ "KILL",
  /*  189 */ "CONNECTION",
  /*  190 */ "TRANSACTION",
  /*  191 */ "BALANCE",
  /*  192 */ "VGROUP",
  /*  193 */ "MERGE",
  /*  194 */ "REDISTRIBUTE",
  /*  195 */ "SPLIT",
  /*  196 */ "DELETE",
  /*  197 */ "INSERT",
  /*  198 */ "NULL",
  /*  199 */ "NK_QUESTION",
  /*  200 */ "NK_ARROW",
  /*  201 */ "ROWTS",
  /*  202 */ "TBNAME",
  /*  203 */ "QSTART",
  /*  204 */ "QEND",
  /*  205 */ "QDURATION",
  /*  206 */ "WSTART",
  /*  207 */ "WEND",
  /*  208 */ "WDURATION",
  /*  209 */ "CAST",
  /*  210 */ "NOW",
  /*  211 */ "TODAY",
  /*  212 */ "TIMEZONE",
  /*  213 */ "CLIENT_VERSION",
  /*  214 */ "SERVER_VERSION",
  /*  215 */ "SERVER_STATUS",
  /*  216 */ "CURRENT_USER",
  /*  217 */ "COUNT",
  /*  218 */ "LAST_ROW",
  /*  219 */ "BETWEEN",
  /*  220 */ "IS",
  /*  221 */ "NK_LT",
  /*  222 */ "NK_GT",
  /*  223 */ "NK_LE",
  /*  224 */ "NK_GE",
  /*  225 */ "NK_NE",
  /*  226 */ "MATCH",
  /*  227 */ "NMATCH",
  /*  228 */ "CONTAINS",
  /*  229 */ "IN",
  /*  230 */ "JOIN",
  /*  231 */ "INNER",
  /*  232 */ "SELECT",
  /*  233 */ "DISTINCT",
  /*  234 */ "WHERE",
  /*  235 */ "PARTITION",
  /*  236 */ "BY",
  /*  237 */ "SESSION",
  /*  238 */ "STATE_WINDOW",
  /*  239 */ "SLIDING",
  /*  240 */ "FILL",
  /*  241 */ "VALUE",
  /*  242 */ "NONE",
  /*  243 */ "PREV",
  /*  244 */ "LINEAR",
  /*  245 */ "NEXT",
  /*  246 */ "HAVING",
  /*  247 */ "RANGE",
  /*  248 */ "EVERY",
  /*  249 */ "ORDER",
  /*  250 */ "SLIMIT",
  /*  251 */ "SOFFSET",
  /*  252 */ "LIMIT",
  /*  253 */ "OFFSET",
  /*  254 */ "ASC",
  /*  255 */ "NULLS",
  /*  256 */ "ABORT",
  /*  257 */ "AFTER",
  /*  258 */ "ATTACH",
  /*  259 */ "BEFORE",
  /*  260 */ "BEGIN",
  /*  261 */ "BITAND",
  /*  262 */ "BITNOT",
  /*  263 */ "BITOR",
  /*  264 */ "BLOCKS",
  /*  265 */ "CHANGE",
  /*  266 */ "COMMA",
  /*  267 */ "COMPACT",
  /*  268 */ "CONCAT",
  /*  269 */ "CONFLICT",
  /*  270 */ "COPY",
  /*  271 */ "DEFERRED",
  /*  272 */ "DELIMITERS",
  /*  273 */ "DETACH",
  /*  274 */ "DIVIDE",
  /*  275 */ "DOT",
  /*  276 */ "EACH",
  /*  277 */ "END",
  /*  278 */ "FAIL",
  /*  279 */ "FILE",
  /*  280 */ "FOR",
  /*  281 */ "GLOB",
  /*  282 */ "ID",
  /*  283 */ "IMMEDIATE",
  /*  284 */ "IMPORT",
  /*  285 */ "INITIALLY",
  /*  286 */ "INSTEAD",
  /*  287 */ "ISNULL",
  /*  288 */ "KEY",
  /*  289 */ "NK_BITNOT",
  /*  290 */ "NK_SEMI",
  /*  291 */ "NOTNULL",
  /*  292 */ "OF",
  /*  293 */ "PLUS",
  /*  294 */ "PRIVILEGE",
  /*  295 */ "RAISE",
  /*  296 */ "REPLACE",
  /*  297 */ "RESTRICT",
  /*  298 */ "ROW",
  /*  299 */ "SEMI",
  /*  300 */ "STAR",
  /*  301 */ "STATEMENT",
  /*  302 */ "STRING",
  /*  303 */ "TIMES",
  /*  304 */ "UPDATE",
  /*  305 */ "VALUES",
  /*  306 */ "VARIABLE",
  /*  307 */ "VIEW",
  /*  308 */ "WAL",
  /*  309 */ "cmd",
  /*  310 */ "account_options",
  /*  311 */ "alter_account_options",
  /*  312 */ "literal",
  /*  313 */ "alter_account_option",
  /*  314 */ "user_name",
  /*  315 */ "sysinfo_opt",
  /*  316 */ "privileges",
  /*  317 */ "priv_level",
  /*  318 */ "priv_type_list",
  /*  319 */ "priv_type",
  /*  320 */ "db_name",
  /*  321 */ "dnode_endpoint",
  /*  322 */ "not_exists_opt",
  /*  323 */ "db_options",
  /*  324 */ "exists_opt",
  /*  325 */ "alter_db_options",
  /*  326 */ "integer_list",
  /*  327 */ "variable_list",
  /*  328 */ "retention_list",
  /*  329 */ "alter_db_option",
  /*  330 */ "retention",
  /*  331 */ "full_table_name",
  /*  332 */ "column_def_list",
  /*  333 */ "tags_def_opt",
  /*  334 */ "table_options",
  /*  335 */ "multi_create_clause",
  /*  336 */ "tags_def",
  /*  337 */ "multi_drop_clause",
  /*  338 */ "alter_table_clause",
  /*  339 */ "alter_table_options",
  /*  340 */ "column_name",
  /*  341 */ "type_name",
  /*  342 */ "signed_literal",
  /*  343 */ "create_subtable_clause",
  /*  344 */ "specific_cols_opt",
  /*  345 */ "expression_list",
  /*  346 */ "drop_table_clause",
  /*  347 */ "col_name_list",
  /*  348 */ "table_name",
  /*  349 */ "column_def",
  /*  350 */ "duration_list",
  /*  351 */ "rollup_func_list",
  /*  352 */ "alter_table_option",
  /*  353 */ "duration_literal",
  /*  354 */ "rollup_func_name",
  /*  355 */ "function_name",
  /*  356 */ "col_name",
  /*  357 */ "db_name_cond_opt",
  /*  358 */ "like_pattern_opt",
  /*  359 */ "table_name_cond",
  /*  360 */ "from_db_opt",
  /*  361 */ "index_options",
  /*  362 */ "func_list",
  /*  363 */ "sliding_opt",
  /*  364 */ "sma_stream_opt",
  /*  365 */ "func",
  /*  366 */ "stream_options",
  /*  367 */ "topic_name",
  /*  368 */ "query_expression",
  /*  369 */ "cgroup_name",
  /*  370 */ "analyze_opt",
  /*  371 */ "explain_options",
  /*  372 */ "agg_func_opt",
  /*  373 */ "bufsize_opt",
  /*  374 */ "stream_name",
  /*  375 */ "dnode_list",
  /*  376 */ "where_clause_opt",
  /*  377 */ "signed",
  /*  378 */ "literal_func",
  /*  379 */ "literal_list",
  /*  380 */ "table_alias",
  /*  381 */ "column_alias",
  /*  382 */ "expression",
  /*  383 */ "pseudo_column",
  /*  384 */ "column_reference",
  /*  385 */ "function_expression",
  /*  386 */ "subquery",
  /*  387 */ "star_func",
  /*  388 */ "star_func_para_list",
  /*  389 */ "noarg_func",
  /*  390 */ "other_para_list",
  /*  391 */ "star_func_para",
  /*  392 */ "predicate",
  /*  393 */ "compare_op",
  /*  394 */ "in_op",
  /*  395 */ "in_predicate_value",
  /*  396 */ "boolean_value_expression",
  /*  397 */ "boolean_primary",
  /*  398 */ "common_expression",
  /*  399 */ "from_clause_opt",
  /*  400 */ "table_reference_list",
  /*  401 */ "table_reference",
  /*  402 */ "table_primary",
  /*  403 */ "joined_table",
  /*  404 */ "alias_opt",
  /*  405 */ "parenthesized_joined_table",
  /*  406 */ "join_type",
  /*  407 */ "search_condition",
  /*  408 */ "query_specification",
  /*  409 */ "set_quantifier_opt",
  /*  410 */ "select_list",
  /*  411 */ "partition_by_clause_opt",
  /*  412 */ "range_opt",
  /*  413 */ "every_opt",
  /*  414 */ "fill_opt",
  /*  415 */ "twindow_clause_opt",
  /*  416 */ "group_by_clause_opt",
  /*  417 */ "having_clause_opt",
  /*  418 */ "select_item",
  /*  419 */ "fill_mode",
  /*  420 */ "group_by_list",
  /*  421 */ "query_expression_body",
  /*  422 */ "order_by_clause_opt",
  /*  423 */ "slimit_clause_opt",
  /*  424 */ "limit_clause_opt",
  /*  425 */ "query_primary",
  /*  426 */ "sort_specification_list",
  /*  427 */ "sort_specification",
  /*  428 */ "ordering_specification_opt",
  /*  429 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "cmd ::= TRIM DATABASE db_name",
 /*  68 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  69 */ "not_exists_opt ::=",
 /*  70 */ "exists_opt ::= IF EXISTS",
 /*  71 */ "exists_opt ::=",
 /*  72 */ "db_options ::=",
 /*  73 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  75 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  76 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  78 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  79 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  80 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options KEEP integer_list",
 /*  82 */ "db_options ::= db_options KEEP variable_list",
 /*  83 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  84 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  85 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  86 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  87 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  88 */ "db_options ::= db_options STRICT NK_STRING",
 /*  89 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  90 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  91 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  92 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  93 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  94 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  95 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 102 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 103 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 104 */ "alter_db_options ::= alter_db_option",
 /* 105 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 106 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 107 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 108 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 109 */ "alter_db_option ::= KEEP integer_list",
 /* 110 */ "alter_db_option ::= KEEP variable_list",
 /* 111 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 112 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 113 */ "integer_list ::= NK_INTEGER",
 /* 114 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 115 */ "variable_list ::= NK_VARIABLE",
 /* 116 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 117 */ "retention_list ::= retention",
 /* 118 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 119 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 120 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 121 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 122 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 123 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 124 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 125 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 126 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 127 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 128 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 129 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 130 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 131 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 132 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 133 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 134 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 135 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 136 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 137 */ "multi_create_clause ::= create_subtable_clause",
 /* 138 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 139 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 140 */ "multi_drop_clause ::= drop_table_clause",
 /* 141 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 142 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 143 */ "specific_cols_opt ::=",
 /* 144 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 145 */ "full_table_name ::= table_name",
 /* 146 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 147 */ "column_def_list ::= column_def",
 /* 148 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 149 */ "column_def ::= column_name type_name",
 /* 150 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 151 */ "type_name ::= BOOL",
 /* 152 */ "type_name ::= TINYINT",
 /* 153 */ "type_name ::= SMALLINT",
 /* 154 */ "type_name ::= INT",
 /* 155 */ "type_name ::= INTEGER",
 /* 156 */ "type_name ::= BIGINT",
 /* 157 */ "type_name ::= FLOAT",
 /* 158 */ "type_name ::= DOUBLE",
 /* 159 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 160 */ "type_name ::= TIMESTAMP",
 /* 161 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 162 */ "type_name ::= TINYINT UNSIGNED",
 /* 163 */ "type_name ::= SMALLINT UNSIGNED",
 /* 164 */ "type_name ::= INT UNSIGNED",
 /* 165 */ "type_name ::= BIGINT UNSIGNED",
 /* 166 */ "type_name ::= JSON",
 /* 167 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= MEDIUMBLOB",
 /* 169 */ "type_name ::= BLOB",
 /* 170 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 171 */ "type_name ::= DECIMAL",
 /* 172 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 173 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 174 */ "tags_def_opt ::=",
 /* 175 */ "tags_def_opt ::= tags_def",
 /* 176 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 177 */ "table_options ::=",
 /* 178 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 179 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 180 */ "table_options ::= table_options WATERMARK duration_list",
 /* 181 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 182 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 183 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 184 */ "alter_table_options ::= alter_table_option",
 /* 185 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 186 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 187 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 188 */ "duration_list ::= duration_literal",
 /* 189 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 190 */ "rollup_func_list ::= rollup_func_name",
 /* 191 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 192 */ "rollup_func_name ::= function_name",
 /* 193 */ "rollup_func_name ::= FIRST",
 /* 194 */ "rollup_func_name ::= LAST",
 /* 195 */ "col_name_list ::= col_name",
 /* 196 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 197 */ "col_name ::= column_name",
 /* 198 */ "cmd ::= SHOW DNODES",
 /* 199 */ "cmd ::= SHOW USERS",
 /* 200 */ "cmd ::= SHOW DATABASES",
 /* 201 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 202 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 203 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 204 */ "cmd ::= SHOW MNODES",
 /* 205 */ "cmd ::= SHOW MODULES",
 /* 206 */ "cmd ::= SHOW QNODES",
 /* 207 */ "cmd ::= SHOW FUNCTIONS",
 /* 208 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 209 */ "cmd ::= SHOW STREAMS",
 /* 210 */ "cmd ::= SHOW ACCOUNTS",
 /* 211 */ "cmd ::= SHOW APPS",
 /* 212 */ "cmd ::= SHOW CONNECTIONS",
 /* 213 */ "cmd ::= SHOW LICENCES",
 /* 214 */ "cmd ::= SHOW GRANTS",
 /* 215 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 216 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 217 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 218 */ "cmd ::= SHOW QUERIES",
 /* 219 */ "cmd ::= SHOW SCORES",
 /* 220 */ "cmd ::= SHOW TOPICS",
 /* 221 */ "cmd ::= SHOW VARIABLES",
 /* 222 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 223 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 224 */ "cmd ::= SHOW BNODES",
 /* 225 */ "cmd ::= SHOW SNODES",
 /* 226 */ "cmd ::= SHOW CLUSTER",
 /* 227 */ "cmd ::= SHOW TRANSACTIONS",
 /* 228 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 229 */ "cmd ::= SHOW CONSUMERS",
 /* 230 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 231 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 232 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 233 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 234 */ "db_name_cond_opt ::=",
 /* 235 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 236 */ "like_pattern_opt ::=",
 /* 237 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 238 */ "table_name_cond ::= table_name",
 /* 239 */ "from_db_opt ::=",
 /* 240 */ "from_db_opt ::= FROM db_name",
 /* 241 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 242 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 243 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 244 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 245 */ "func_list ::= func",
 /* 246 */ "func_list ::= func_list NK_COMMA func",
 /* 247 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 248 */ "sma_stream_opt ::=",
 /* 249 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 250 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 251 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 252 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 253 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 254 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 255 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 256 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 257 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 258 */ "cmd ::= DESC full_table_name",
 /* 259 */ "cmd ::= DESCRIBE full_table_name",
 /* 260 */ "cmd ::= RESET QUERY CACHE",
 /* 261 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 262 */ "analyze_opt ::=",
 /* 263 */ "analyze_opt ::= ANALYZE",
 /* 264 */ "explain_options ::=",
 /* 265 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 266 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 267 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 268 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 269 */ "agg_func_opt ::=",
 /* 270 */ "agg_func_opt ::= AGGREGATE",
 /* 271 */ "bufsize_opt ::=",
 /* 272 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 273 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name AS query_expression",
 /* 274 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 275 */ "stream_options ::=",
 /* 276 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 277 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 278 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 279 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 280 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 281 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 282 */ "cmd ::= KILL QUERY NK_STRING",
 /* 283 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 284 */ "cmd ::= BALANCE VGROUP",
 /* 285 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 286 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 287 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 288 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 289 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 290 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 291 */ "cmd ::= query_expression",
 /* 292 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression",
 /* 293 */ "cmd ::= INSERT INTO full_table_name query_expression",
 /* 294 */ "literal ::= NK_INTEGER",
 /* 295 */ "literal ::= NK_FLOAT",
 /* 296 */ "literal ::= NK_STRING",
 /* 297 */ "literal ::= NK_BOOL",
 /* 298 */ "literal ::= TIMESTAMP NK_STRING",
 /* 299 */ "literal ::= duration_literal",
 /* 300 */ "literal ::= NULL",
 /* 301 */ "literal ::= NK_QUESTION",
 /* 302 */ "duration_literal ::= NK_VARIABLE",
 /* 303 */ "signed ::= NK_INTEGER",
 /* 304 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 305 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 306 */ "signed ::= NK_FLOAT",
 /* 307 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 308 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 309 */ "signed_literal ::= signed",
 /* 310 */ "signed_literal ::= NK_STRING",
 /* 311 */ "signed_literal ::= NK_BOOL",
 /* 312 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 313 */ "signed_literal ::= duration_literal",
 /* 314 */ "signed_literal ::= NULL",
 /* 315 */ "signed_literal ::= literal_func",
 /* 316 */ "signed_literal ::= NK_QUESTION",
 /* 317 */ "literal_list ::= signed_literal",
 /* 318 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 319 */ "db_name ::= NK_ID",
 /* 320 */ "table_name ::= NK_ID",
 /* 321 */ "column_name ::= NK_ID",
 /* 322 */ "function_name ::= NK_ID",
 /* 323 */ "table_alias ::= NK_ID",
 /* 324 */ "column_alias ::= NK_ID",
 /* 325 */ "user_name ::= NK_ID",
 /* 326 */ "topic_name ::= NK_ID",
 /* 327 */ "stream_name ::= NK_ID",
 /* 328 */ "cgroup_name ::= NK_ID",
 /* 329 */ "expression ::= literal",
 /* 330 */ "expression ::= pseudo_column",
 /* 331 */ "expression ::= column_reference",
 /* 332 */ "expression ::= function_expression",
 /* 333 */ "expression ::= subquery",
 /* 334 */ "expression ::= NK_LP expression NK_RP",
 /* 335 */ "expression ::= NK_PLUS expression",
 /* 336 */ "expression ::= NK_MINUS expression",
 /* 337 */ "expression ::= expression NK_PLUS expression",
 /* 338 */ "expression ::= expression NK_MINUS expression",
 /* 339 */ "expression ::= expression NK_STAR expression",
 /* 340 */ "expression ::= expression NK_SLASH expression",
 /* 341 */ "expression ::= expression NK_REM expression",
 /* 342 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 343 */ "expression ::= expression NK_BITAND expression",
 /* 344 */ "expression ::= expression NK_BITOR expression",
 /* 345 */ "expression_list ::= expression",
 /* 346 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 347 */ "column_reference ::= column_name",
 /* 348 */ "column_reference ::= table_name NK_DOT column_name",
 /* 349 */ "pseudo_column ::= ROWTS",
 /* 350 */ "pseudo_column ::= TBNAME",
 /* 351 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 352 */ "pseudo_column ::= QSTART",
 /* 353 */ "pseudo_column ::= QEND",
 /* 354 */ "pseudo_column ::= QDURATION",
 /* 355 */ "pseudo_column ::= WSTART",
 /* 356 */ "pseudo_column ::= WEND",
 /* 357 */ "pseudo_column ::= WDURATION",
 /* 358 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 359 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 360 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 361 */ "function_expression ::= literal_func",
 /* 362 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 363 */ "literal_func ::= NOW",
 /* 364 */ "noarg_func ::= NOW",
 /* 365 */ "noarg_func ::= TODAY",
 /* 366 */ "noarg_func ::= TIMEZONE",
 /* 367 */ "noarg_func ::= DATABASE",
 /* 368 */ "noarg_func ::= CLIENT_VERSION",
 /* 369 */ "noarg_func ::= SERVER_VERSION",
 /* 370 */ "noarg_func ::= SERVER_STATUS",
 /* 371 */ "noarg_func ::= CURRENT_USER",
 /* 372 */ "noarg_func ::= USER",
 /* 373 */ "star_func ::= COUNT",
 /* 374 */ "star_func ::= FIRST",
 /* 375 */ "star_func ::= LAST",
 /* 376 */ "star_func ::= LAST_ROW",
 /* 377 */ "star_func_para_list ::= NK_STAR",
 /* 378 */ "star_func_para_list ::= other_para_list",
 /* 379 */ "other_para_list ::= star_func_para",
 /* 380 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 381 */ "star_func_para ::= expression",
 /* 382 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 383 */ "predicate ::= expression compare_op expression",
 /* 384 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 385 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 386 */ "predicate ::= expression IS NULL",
 /* 387 */ "predicate ::= expression IS NOT NULL",
 /* 388 */ "predicate ::= expression in_op in_predicate_value",
 /* 389 */ "compare_op ::= NK_LT",
 /* 390 */ "compare_op ::= NK_GT",
 /* 391 */ "compare_op ::= NK_LE",
 /* 392 */ "compare_op ::= NK_GE",
 /* 393 */ "compare_op ::= NK_NE",
 /* 394 */ "compare_op ::= NK_EQ",
 /* 395 */ "compare_op ::= LIKE",
 /* 396 */ "compare_op ::= NOT LIKE",
 /* 397 */ "compare_op ::= MATCH",
 /* 398 */ "compare_op ::= NMATCH",
 /* 399 */ "compare_op ::= CONTAINS",
 /* 400 */ "in_op ::= IN",
 /* 401 */ "in_op ::= NOT IN",
 /* 402 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 403 */ "boolean_value_expression ::= boolean_primary",
 /* 404 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 405 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 406 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 407 */ "boolean_primary ::= predicate",
 /* 408 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 409 */ "common_expression ::= expression",
 /* 410 */ "common_expression ::= boolean_value_expression",
 /* 411 */ "from_clause_opt ::=",
 /* 412 */ "from_clause_opt ::= FROM table_reference_list",
 /* 413 */ "table_reference_list ::= table_reference",
 /* 414 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 415 */ "table_reference ::= table_primary",
 /* 416 */ "table_reference ::= joined_table",
 /* 417 */ "table_primary ::= table_name alias_opt",
 /* 418 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 419 */ "table_primary ::= subquery alias_opt",
 /* 420 */ "table_primary ::= parenthesized_joined_table",
 /* 421 */ "alias_opt ::=",
 /* 422 */ "alias_opt ::= table_alias",
 /* 423 */ "alias_opt ::= AS table_alias",
 /* 424 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 425 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 426 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 427 */ "join_type ::=",
 /* 428 */ "join_type ::= INNER",
 /* 429 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 430 */ "set_quantifier_opt ::=",
 /* 431 */ "set_quantifier_opt ::= DISTINCT",
 /* 432 */ "set_quantifier_opt ::= ALL",
 /* 433 */ "select_list ::= select_item",
 /* 434 */ "select_list ::= select_list NK_COMMA select_item",
 /* 435 */ "select_item ::= NK_STAR",
 /* 436 */ "select_item ::= common_expression",
 /* 437 */ "select_item ::= common_expression column_alias",
 /* 438 */ "select_item ::= common_expression AS column_alias",
 /* 439 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 440 */ "where_clause_opt ::=",
 /* 441 */ "where_clause_opt ::= WHERE search_condition",
 /* 442 */ "partition_by_clause_opt ::=",
 /* 443 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 444 */ "twindow_clause_opt ::=",
 /* 445 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 446 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 447 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 448 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 449 */ "sliding_opt ::=",
 /* 450 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 451 */ "fill_opt ::=",
 /* 452 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 453 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 454 */ "fill_mode ::= NONE",
 /* 455 */ "fill_mode ::= PREV",
 /* 456 */ "fill_mode ::= NULL",
 /* 457 */ "fill_mode ::= LINEAR",
 /* 458 */ "fill_mode ::= NEXT",
 /* 459 */ "group_by_clause_opt ::=",
 /* 460 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 461 */ "group_by_list ::= expression",
 /* 462 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 463 */ "having_clause_opt ::=",
 /* 464 */ "having_clause_opt ::= HAVING search_condition",
 /* 465 */ "range_opt ::=",
 /* 466 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 467 */ "every_opt ::=",
 /* 468 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 469 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 470 */ "query_expression_body ::= query_primary",
 /* 471 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 472 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 473 */ "query_primary ::= query_specification",
 /* 474 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 475 */ "order_by_clause_opt ::=",
 /* 476 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 477 */ "slimit_clause_opt ::=",
 /* 478 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 479 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 480 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 481 */ "limit_clause_opt ::=",
 /* 482 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 483 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 484 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 485 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 486 */ "search_condition ::= common_expression",
 /* 487 */ "sort_specification_list ::= sort_specification",
 /* 488 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 489 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 490 */ "ordering_specification_opt ::=",
 /* 491 */ "ordering_specification_opt ::= ASC",
 /* 492 */ "ordering_specification_opt ::= DESC",
 /* 493 */ "null_ordering_opt ::=",
 /* 494 */ "null_ordering_opt ::= NULLS FIRST",
 /* 495 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 309: /* cmd */
    case 312: /* literal */
    case 323: /* db_options */
    case 325: /* alter_db_options */
    case 330: /* retention */
    case 331: /* full_table_name */
    case 334: /* table_options */
    case 338: /* alter_table_clause */
    case 339: /* alter_table_options */
    case 342: /* signed_literal */
    case 343: /* create_subtable_clause */
    case 346: /* drop_table_clause */
    case 349: /* column_def */
    case 353: /* duration_literal */
    case 354: /* rollup_func_name */
    case 356: /* col_name */
    case 357: /* db_name_cond_opt */
    case 358: /* like_pattern_opt */
    case 359: /* table_name_cond */
    case 360: /* from_db_opt */
    case 361: /* index_options */
    case 363: /* sliding_opt */
    case 364: /* sma_stream_opt */
    case 365: /* func */
    case 366: /* stream_options */
    case 368: /* query_expression */
    case 371: /* explain_options */
    case 376: /* where_clause_opt */
    case 377: /* signed */
    case 378: /* literal_func */
    case 382: /* expression */
    case 383: /* pseudo_column */
    case 384: /* column_reference */
    case 385: /* function_expression */
    case 386: /* subquery */
    case 391: /* star_func_para */
    case 392: /* predicate */
    case 395: /* in_predicate_value */
    case 396: /* boolean_value_expression */
    case 397: /* boolean_primary */
    case 398: /* common_expression */
    case 399: /* from_clause_opt */
    case 400: /* table_reference_list */
    case 401: /* table_reference */
    case 402: /* table_primary */
    case 403: /* joined_table */
    case 405: /* parenthesized_joined_table */
    case 407: /* search_condition */
    case 408: /* query_specification */
    case 412: /* range_opt */
    case 413: /* every_opt */
    case 414: /* fill_opt */
    case 415: /* twindow_clause_opt */
    case 417: /* having_clause_opt */
    case 418: /* select_item */
    case 421: /* query_expression_body */
    case 423: /* slimit_clause_opt */
    case 424: /* limit_clause_opt */
    case 425: /* query_primary */
    case 427: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy312)); 
}
      break;
    case 310: /* account_options */
    case 311: /* alter_account_options */
    case 313: /* alter_account_option */
    case 373: /* bufsize_opt */
{
 
}
      break;
    case 314: /* user_name */
    case 317: /* priv_level */
    case 320: /* db_name */
    case 321: /* dnode_endpoint */
    case 340: /* column_name */
    case 348: /* table_name */
    case 355: /* function_name */
    case 367: /* topic_name */
    case 369: /* cgroup_name */
    case 374: /* stream_name */
    case 380: /* table_alias */
    case 381: /* column_alias */
    case 387: /* star_func */
    case 389: /* noarg_func */
    case 404: /* alias_opt */
{
 
}
      break;
    case 315: /* sysinfo_opt */
{
 
}
      break;
    case 316: /* privileges */
    case 318: /* priv_type_list */
    case 319: /* priv_type */
{
 
}
      break;
    case 322: /* not_exists_opt */
    case 324: /* exists_opt */
    case 370: /* analyze_opt */
    case 372: /* agg_func_opt */
    case 409: /* set_quantifier_opt */
{
 
}
      break;
    case 326: /* integer_list */
    case 327: /* variable_list */
    case 328: /* retention_list */
    case 332: /* column_def_list */
    case 333: /* tags_def_opt */
    case 335: /* multi_create_clause */
    case 336: /* tags_def */
    case 337: /* multi_drop_clause */
    case 344: /* specific_cols_opt */
    case 345: /* expression_list */
    case 347: /* col_name_list */
    case 350: /* duration_list */
    case 351: /* rollup_func_list */
    case 362: /* func_list */
    case 375: /* dnode_list */
    case 379: /* literal_list */
    case 388: /* star_func_para_list */
    case 390: /* other_para_list */
    case 410: /* select_list */
    case 411: /* partition_by_clause_opt */
    case 416: /* group_by_clause_opt */
    case 420: /* group_by_list */
    case 422: /* order_by_clause_opt */
    case 426: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy824)); 
}
      break;
    case 329: /* alter_db_option */
    case 352: /* alter_table_option */
{
 
}
      break;
    case 341: /* type_name */
{
 
}
      break;
    case 393: /* compare_op */
    case 394: /* in_op */
{
 
}
      break;
    case 406: /* join_type */
{
 
}
      break;
    case 419: /* fill_mode */
{
 
}
      break;
    case 428: /* ordering_specification_opt */
{
 
}
      break;
    case 429: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  309,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  309,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  310,    0 }, /* (2) account_options ::= */
  {  310,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  310,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  310,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  310,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  310,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  310,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  310,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  310,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  310,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  311,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  311,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  313,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  313,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  313,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  313,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  313,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  313,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  313,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  313,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  313,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  313,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  309,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  309,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  309,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  309,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  309,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  315,    0 }, /* (29) sysinfo_opt ::= */
  {  315,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  309,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  309,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  316,   -1 }, /* (33) privileges ::= ALL */
  {  316,   -1 }, /* (34) privileges ::= priv_type_list */
  {  318,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  318,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  319,   -1 }, /* (37) priv_type ::= READ */
  {  319,   -1 }, /* (38) priv_type ::= WRITE */
  {  317,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  317,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  309,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  309,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  309,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  309,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  309,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  309,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  309,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  309,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  321,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  321,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  321,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  309,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  309,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  309,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  309,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  309,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  309,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  309,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  309,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  309,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  309,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  309,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  309,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  309,   -2 }, /* (64) cmd ::= USE db_name */
  {  309,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  309,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  309,   -3 }, /* (67) cmd ::= TRIM DATABASE db_name */
  {  322,   -3 }, /* (68) not_exists_opt ::= IF NOT EXISTS */
  {  322,    0 }, /* (69) not_exists_opt ::= */
  {  324,   -2 }, /* (70) exists_opt ::= IF EXISTS */
  {  324,    0 }, /* (71) exists_opt ::= */
  {  323,    0 }, /* (72) db_options ::= */
  {  323,   -3 }, /* (73) db_options ::= db_options BUFFER NK_INTEGER */
  {  323,   -3 }, /* (74) db_options ::= db_options CACHEMODEL NK_STRING */
  {  323,   -3 }, /* (75) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  323,   -3 }, /* (76) db_options ::= db_options COMP NK_INTEGER */
  {  323,   -3 }, /* (77) db_options ::= db_options DURATION NK_INTEGER */
  {  323,   -3 }, /* (78) db_options ::= db_options DURATION NK_VARIABLE */
  {  323,   -3 }, /* (79) db_options ::= db_options MAXROWS NK_INTEGER */
  {  323,   -3 }, /* (80) db_options ::= db_options MINROWS NK_INTEGER */
  {  323,   -3 }, /* (81) db_options ::= db_options KEEP integer_list */
  {  323,   -3 }, /* (82) db_options ::= db_options KEEP variable_list */
  {  323,   -3 }, /* (83) db_options ::= db_options PAGES NK_INTEGER */
  {  323,   -3 }, /* (84) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  323,   -3 }, /* (85) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  323,   -3 }, /* (86) db_options ::= db_options PRECISION NK_STRING */
  {  323,   -3 }, /* (87) db_options ::= db_options REPLICA NK_INTEGER */
  {  323,   -3 }, /* (88) db_options ::= db_options STRICT NK_STRING */
  {  323,   -3 }, /* (89) db_options ::= db_options VGROUPS NK_INTEGER */
  {  323,   -3 }, /* (90) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  323,   -3 }, /* (91) db_options ::= db_options RETENTIONS retention_list */
  {  323,   -3 }, /* (92) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  323,   -3 }, /* (93) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  323,   -3 }, /* (94) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  323,   -3 }, /* (95) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  323,   -4 }, /* (96) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  323,   -3 }, /* (97) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  323,   -4 }, /* (98) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  323,   -3 }, /* (99) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  323,   -3 }, /* (100) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  323,   -3 }, /* (101) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  323,   -3 }, /* (102) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  323,   -3 }, /* (103) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  325,   -1 }, /* (104) alter_db_options ::= alter_db_option */
  {  325,   -2 }, /* (105) alter_db_options ::= alter_db_options alter_db_option */
  {  329,   -2 }, /* (106) alter_db_option ::= CACHEMODEL NK_STRING */
  {  329,   -2 }, /* (107) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  329,   -2 }, /* (108) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  329,   -2 }, /* (109) alter_db_option ::= KEEP integer_list */
  {  329,   -2 }, /* (110) alter_db_option ::= KEEP variable_list */
  {  329,   -2 }, /* (111) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  329,   -2 }, /* (112) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  326,   -1 }, /* (113) integer_list ::= NK_INTEGER */
  {  326,   -3 }, /* (114) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  327,   -1 }, /* (115) variable_list ::= NK_VARIABLE */
  {  327,   -3 }, /* (116) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  328,   -1 }, /* (117) retention_list ::= retention */
  {  328,   -3 }, /* (118) retention_list ::= retention_list NK_COMMA retention */
  {  330,   -3 }, /* (119) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  309,   -9 }, /* (120) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  309,   -3 }, /* (121) cmd ::= CREATE TABLE multi_create_clause */
  {  309,   -9 }, /* (122) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  309,   -3 }, /* (123) cmd ::= DROP TABLE multi_drop_clause */
  {  309,   -4 }, /* (124) cmd ::= DROP STABLE exists_opt full_table_name */
  {  309,   -3 }, /* (125) cmd ::= ALTER TABLE alter_table_clause */
  {  309,   -3 }, /* (126) cmd ::= ALTER STABLE alter_table_clause */
  {  338,   -2 }, /* (127) alter_table_clause ::= full_table_name alter_table_options */
  {  338,   -5 }, /* (128) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  338,   -4 }, /* (129) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  338,   -5 }, /* (130) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  338,   -5 }, /* (131) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  338,   -5 }, /* (132) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  338,   -4 }, /* (133) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  338,   -5 }, /* (134) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  338,   -5 }, /* (135) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  338,   -6 }, /* (136) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  335,   -1 }, /* (137) multi_create_clause ::= create_subtable_clause */
  {  335,   -2 }, /* (138) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  343,  -10 }, /* (139) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  337,   -1 }, /* (140) multi_drop_clause ::= drop_table_clause */
  {  337,   -2 }, /* (141) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  346,   -2 }, /* (142) drop_table_clause ::= exists_opt full_table_name */
  {  344,    0 }, /* (143) specific_cols_opt ::= */
  {  344,   -3 }, /* (144) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  331,   -1 }, /* (145) full_table_name ::= table_name */
  {  331,   -3 }, /* (146) full_table_name ::= db_name NK_DOT table_name */
  {  332,   -1 }, /* (147) column_def_list ::= column_def */
  {  332,   -3 }, /* (148) column_def_list ::= column_def_list NK_COMMA column_def */
  {  349,   -2 }, /* (149) column_def ::= column_name type_name */
  {  349,   -4 }, /* (150) column_def ::= column_name type_name COMMENT NK_STRING */
  {  341,   -1 }, /* (151) type_name ::= BOOL */
  {  341,   -1 }, /* (152) type_name ::= TINYINT */
  {  341,   -1 }, /* (153) type_name ::= SMALLINT */
  {  341,   -1 }, /* (154) type_name ::= INT */
  {  341,   -1 }, /* (155) type_name ::= INTEGER */
  {  341,   -1 }, /* (156) type_name ::= BIGINT */
  {  341,   -1 }, /* (157) type_name ::= FLOAT */
  {  341,   -1 }, /* (158) type_name ::= DOUBLE */
  {  341,   -4 }, /* (159) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  341,   -1 }, /* (160) type_name ::= TIMESTAMP */
  {  341,   -4 }, /* (161) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  341,   -2 }, /* (162) type_name ::= TINYINT UNSIGNED */
  {  341,   -2 }, /* (163) type_name ::= SMALLINT UNSIGNED */
  {  341,   -2 }, /* (164) type_name ::= INT UNSIGNED */
  {  341,   -2 }, /* (165) type_name ::= BIGINT UNSIGNED */
  {  341,   -1 }, /* (166) type_name ::= JSON */
  {  341,   -4 }, /* (167) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  341,   -1 }, /* (168) type_name ::= MEDIUMBLOB */
  {  341,   -1 }, /* (169) type_name ::= BLOB */
  {  341,   -4 }, /* (170) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  341,   -1 }, /* (171) type_name ::= DECIMAL */
  {  341,   -4 }, /* (172) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  341,   -6 }, /* (173) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  333,    0 }, /* (174) tags_def_opt ::= */
  {  333,   -1 }, /* (175) tags_def_opt ::= tags_def */
  {  336,   -4 }, /* (176) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  334,    0 }, /* (177) table_options ::= */
  {  334,   -3 }, /* (178) table_options ::= table_options COMMENT NK_STRING */
  {  334,   -3 }, /* (179) table_options ::= table_options MAX_DELAY duration_list */
  {  334,   -3 }, /* (180) table_options ::= table_options WATERMARK duration_list */
  {  334,   -5 }, /* (181) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  334,   -3 }, /* (182) table_options ::= table_options TTL NK_INTEGER */
  {  334,   -5 }, /* (183) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  339,   -1 }, /* (184) alter_table_options ::= alter_table_option */
  {  339,   -2 }, /* (185) alter_table_options ::= alter_table_options alter_table_option */
  {  352,   -2 }, /* (186) alter_table_option ::= COMMENT NK_STRING */
  {  352,   -2 }, /* (187) alter_table_option ::= TTL NK_INTEGER */
  {  350,   -1 }, /* (188) duration_list ::= duration_literal */
  {  350,   -3 }, /* (189) duration_list ::= duration_list NK_COMMA duration_literal */
  {  351,   -1 }, /* (190) rollup_func_list ::= rollup_func_name */
  {  351,   -3 }, /* (191) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  354,   -1 }, /* (192) rollup_func_name ::= function_name */
  {  354,   -1 }, /* (193) rollup_func_name ::= FIRST */
  {  354,   -1 }, /* (194) rollup_func_name ::= LAST */
  {  347,   -1 }, /* (195) col_name_list ::= col_name */
  {  347,   -3 }, /* (196) col_name_list ::= col_name_list NK_COMMA col_name */
  {  356,   -1 }, /* (197) col_name ::= column_name */
  {  309,   -2 }, /* (198) cmd ::= SHOW DNODES */
  {  309,   -2 }, /* (199) cmd ::= SHOW USERS */
  {  309,   -2 }, /* (200) cmd ::= SHOW DATABASES */
  {  309,   -4 }, /* (201) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  309,   -4 }, /* (202) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  309,   -3 }, /* (203) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  309,   -2 }, /* (204) cmd ::= SHOW MNODES */
  {  309,   -2 }, /* (205) cmd ::= SHOW MODULES */
  {  309,   -2 }, /* (206) cmd ::= SHOW QNODES */
  {  309,   -2 }, /* (207) cmd ::= SHOW FUNCTIONS */
  {  309,   -5 }, /* (208) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  309,   -2 }, /* (209) cmd ::= SHOW STREAMS */
  {  309,   -2 }, /* (210) cmd ::= SHOW ACCOUNTS */
  {  309,   -2 }, /* (211) cmd ::= SHOW APPS */
  {  309,   -2 }, /* (212) cmd ::= SHOW CONNECTIONS */
  {  309,   -2 }, /* (213) cmd ::= SHOW LICENCES */
  {  309,   -2 }, /* (214) cmd ::= SHOW GRANTS */
  {  309,   -4 }, /* (215) cmd ::= SHOW CREATE DATABASE db_name */
  {  309,   -4 }, /* (216) cmd ::= SHOW CREATE TABLE full_table_name */
  {  309,   -4 }, /* (217) cmd ::= SHOW CREATE STABLE full_table_name */
  {  309,   -2 }, /* (218) cmd ::= SHOW QUERIES */
  {  309,   -2 }, /* (219) cmd ::= SHOW SCORES */
  {  309,   -2 }, /* (220) cmd ::= SHOW TOPICS */
  {  309,   -2 }, /* (221) cmd ::= SHOW VARIABLES */
  {  309,   -3 }, /* (222) cmd ::= SHOW LOCAL VARIABLES */
  {  309,   -4 }, /* (223) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  309,   -2 }, /* (224) cmd ::= SHOW BNODES */
  {  309,   -2 }, /* (225) cmd ::= SHOW SNODES */
  {  309,   -2 }, /* (226) cmd ::= SHOW CLUSTER */
  {  309,   -2 }, /* (227) cmd ::= SHOW TRANSACTIONS */
  {  309,   -4 }, /* (228) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  309,   -2 }, /* (229) cmd ::= SHOW CONSUMERS */
  {  309,   -2 }, /* (230) cmd ::= SHOW SUBSCRIPTIONS */
  {  309,   -5 }, /* (231) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  309,   -3 }, /* (232) cmd ::= SHOW VNODES NK_INTEGER */
  {  309,   -3 }, /* (233) cmd ::= SHOW VNODES NK_STRING */
  {  357,    0 }, /* (234) db_name_cond_opt ::= */
  {  357,   -2 }, /* (235) db_name_cond_opt ::= db_name NK_DOT */
  {  358,    0 }, /* (236) like_pattern_opt ::= */
  {  358,   -2 }, /* (237) like_pattern_opt ::= LIKE NK_STRING */
  {  359,   -1 }, /* (238) table_name_cond ::= table_name */
  {  360,    0 }, /* (239) from_db_opt ::= */
  {  360,   -2 }, /* (240) from_db_opt ::= FROM db_name */
  {  309,   -8 }, /* (241) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  309,   -4 }, /* (242) cmd ::= DROP INDEX exists_opt full_table_name */
  {  361,  -10 }, /* (243) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  361,  -12 }, /* (244) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  362,   -1 }, /* (245) func_list ::= func */
  {  362,   -3 }, /* (246) func_list ::= func_list NK_COMMA func */
  {  365,   -4 }, /* (247) func ::= function_name NK_LP expression_list NK_RP */
  {  364,    0 }, /* (248) sma_stream_opt ::= */
  {  364,   -3 }, /* (249) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  364,   -3 }, /* (250) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  309,   -6 }, /* (251) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  309,   -7 }, /* (252) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  309,   -9 }, /* (253) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  309,   -7 }, /* (254) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  309,   -9 }, /* (255) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  309,   -4 }, /* (256) cmd ::= DROP TOPIC exists_opt topic_name */
  {  309,   -7 }, /* (257) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  309,   -2 }, /* (258) cmd ::= DESC full_table_name */
  {  309,   -2 }, /* (259) cmd ::= DESCRIBE full_table_name */
  {  309,   -3 }, /* (260) cmd ::= RESET QUERY CACHE */
  {  309,   -4 }, /* (261) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  370,    0 }, /* (262) analyze_opt ::= */
  {  370,   -1 }, /* (263) analyze_opt ::= ANALYZE */
  {  371,    0 }, /* (264) explain_options ::= */
  {  371,   -3 }, /* (265) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  371,   -3 }, /* (266) explain_options ::= explain_options RATIO NK_FLOAT */
  {  309,  -10 }, /* (267) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  309,   -4 }, /* (268) cmd ::= DROP FUNCTION exists_opt function_name */
  {  372,    0 }, /* (269) agg_func_opt ::= */
  {  372,   -1 }, /* (270) agg_func_opt ::= AGGREGATE */
  {  373,    0 }, /* (271) bufsize_opt ::= */
  {  373,   -2 }, /* (272) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  309,   -9 }, /* (273) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name AS query_expression */
  {  309,   -4 }, /* (274) cmd ::= DROP STREAM exists_opt stream_name */
  {  366,    0 }, /* (275) stream_options ::= */
  {  366,   -3 }, /* (276) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  366,   -3 }, /* (277) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  366,   -4 }, /* (278) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  366,   -3 }, /* (279) stream_options ::= stream_options WATERMARK duration_literal */
  {  366,   -4 }, /* (280) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  309,   -3 }, /* (281) cmd ::= KILL CONNECTION NK_INTEGER */
  {  309,   -3 }, /* (282) cmd ::= KILL QUERY NK_STRING */
  {  309,   -3 }, /* (283) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  309,   -2 }, /* (284) cmd ::= BALANCE VGROUP */
  {  309,   -4 }, /* (285) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  309,   -4 }, /* (286) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  309,   -3 }, /* (287) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  375,   -2 }, /* (288) dnode_list ::= DNODE NK_INTEGER */
  {  375,   -3 }, /* (289) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  309,   -4 }, /* (290) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  309,   -1 }, /* (291) cmd ::= query_expression */
  {  309,   -7 }, /* (292) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression */
  {  309,   -4 }, /* (293) cmd ::= INSERT INTO full_table_name query_expression */
  {  312,   -1 }, /* (294) literal ::= NK_INTEGER */
  {  312,   -1 }, /* (295) literal ::= NK_FLOAT */
  {  312,   -1 }, /* (296) literal ::= NK_STRING */
  {  312,   -1 }, /* (297) literal ::= NK_BOOL */
  {  312,   -2 }, /* (298) literal ::= TIMESTAMP NK_STRING */
  {  312,   -1 }, /* (299) literal ::= duration_literal */
  {  312,   -1 }, /* (300) literal ::= NULL */
  {  312,   -1 }, /* (301) literal ::= NK_QUESTION */
  {  353,   -1 }, /* (302) duration_literal ::= NK_VARIABLE */
  {  377,   -1 }, /* (303) signed ::= NK_INTEGER */
  {  377,   -2 }, /* (304) signed ::= NK_PLUS NK_INTEGER */
  {  377,   -2 }, /* (305) signed ::= NK_MINUS NK_INTEGER */
  {  377,   -1 }, /* (306) signed ::= NK_FLOAT */
  {  377,   -2 }, /* (307) signed ::= NK_PLUS NK_FLOAT */
  {  377,   -2 }, /* (308) signed ::= NK_MINUS NK_FLOAT */
  {  342,   -1 }, /* (309) signed_literal ::= signed */
  {  342,   -1 }, /* (310) signed_literal ::= NK_STRING */
  {  342,   -1 }, /* (311) signed_literal ::= NK_BOOL */
  {  342,   -2 }, /* (312) signed_literal ::= TIMESTAMP NK_STRING */
  {  342,   -1 }, /* (313) signed_literal ::= duration_literal */
  {  342,   -1 }, /* (314) signed_literal ::= NULL */
  {  342,   -1 }, /* (315) signed_literal ::= literal_func */
  {  342,   -1 }, /* (316) signed_literal ::= NK_QUESTION */
  {  379,   -1 }, /* (317) literal_list ::= signed_literal */
  {  379,   -3 }, /* (318) literal_list ::= literal_list NK_COMMA signed_literal */
  {  320,   -1 }, /* (319) db_name ::= NK_ID */
  {  348,   -1 }, /* (320) table_name ::= NK_ID */
  {  340,   -1 }, /* (321) column_name ::= NK_ID */
  {  355,   -1 }, /* (322) function_name ::= NK_ID */
  {  380,   -1 }, /* (323) table_alias ::= NK_ID */
  {  381,   -1 }, /* (324) column_alias ::= NK_ID */
  {  314,   -1 }, /* (325) user_name ::= NK_ID */
  {  367,   -1 }, /* (326) topic_name ::= NK_ID */
  {  374,   -1 }, /* (327) stream_name ::= NK_ID */
  {  369,   -1 }, /* (328) cgroup_name ::= NK_ID */
  {  382,   -1 }, /* (329) expression ::= literal */
  {  382,   -1 }, /* (330) expression ::= pseudo_column */
  {  382,   -1 }, /* (331) expression ::= column_reference */
  {  382,   -1 }, /* (332) expression ::= function_expression */
  {  382,   -1 }, /* (333) expression ::= subquery */
  {  382,   -3 }, /* (334) expression ::= NK_LP expression NK_RP */
  {  382,   -2 }, /* (335) expression ::= NK_PLUS expression */
  {  382,   -2 }, /* (336) expression ::= NK_MINUS expression */
  {  382,   -3 }, /* (337) expression ::= expression NK_PLUS expression */
  {  382,   -3 }, /* (338) expression ::= expression NK_MINUS expression */
  {  382,   -3 }, /* (339) expression ::= expression NK_STAR expression */
  {  382,   -3 }, /* (340) expression ::= expression NK_SLASH expression */
  {  382,   -3 }, /* (341) expression ::= expression NK_REM expression */
  {  382,   -3 }, /* (342) expression ::= column_reference NK_ARROW NK_STRING */
  {  382,   -3 }, /* (343) expression ::= expression NK_BITAND expression */
  {  382,   -3 }, /* (344) expression ::= expression NK_BITOR expression */
  {  345,   -1 }, /* (345) expression_list ::= expression */
  {  345,   -3 }, /* (346) expression_list ::= expression_list NK_COMMA expression */
  {  384,   -1 }, /* (347) column_reference ::= column_name */
  {  384,   -3 }, /* (348) column_reference ::= table_name NK_DOT column_name */
  {  383,   -1 }, /* (349) pseudo_column ::= ROWTS */
  {  383,   -1 }, /* (350) pseudo_column ::= TBNAME */
  {  383,   -3 }, /* (351) pseudo_column ::= table_name NK_DOT TBNAME */
  {  383,   -1 }, /* (352) pseudo_column ::= QSTART */
  {  383,   -1 }, /* (353) pseudo_column ::= QEND */
  {  383,   -1 }, /* (354) pseudo_column ::= QDURATION */
  {  383,   -1 }, /* (355) pseudo_column ::= WSTART */
  {  383,   -1 }, /* (356) pseudo_column ::= WEND */
  {  383,   -1 }, /* (357) pseudo_column ::= WDURATION */
  {  385,   -4 }, /* (358) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  385,   -4 }, /* (359) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  385,   -6 }, /* (360) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  385,   -1 }, /* (361) function_expression ::= literal_func */
  {  378,   -3 }, /* (362) literal_func ::= noarg_func NK_LP NK_RP */
  {  378,   -1 }, /* (363) literal_func ::= NOW */
  {  389,   -1 }, /* (364) noarg_func ::= NOW */
  {  389,   -1 }, /* (365) noarg_func ::= TODAY */
  {  389,   -1 }, /* (366) noarg_func ::= TIMEZONE */
  {  389,   -1 }, /* (367) noarg_func ::= DATABASE */
  {  389,   -1 }, /* (368) noarg_func ::= CLIENT_VERSION */
  {  389,   -1 }, /* (369) noarg_func ::= SERVER_VERSION */
  {  389,   -1 }, /* (370) noarg_func ::= SERVER_STATUS */
  {  389,   -1 }, /* (371) noarg_func ::= CURRENT_USER */
  {  389,   -1 }, /* (372) noarg_func ::= USER */
  {  387,   -1 }, /* (373) star_func ::= COUNT */
  {  387,   -1 }, /* (374) star_func ::= FIRST */
  {  387,   -1 }, /* (375) star_func ::= LAST */
  {  387,   -1 }, /* (376) star_func ::= LAST_ROW */
  {  388,   -1 }, /* (377) star_func_para_list ::= NK_STAR */
  {  388,   -1 }, /* (378) star_func_para_list ::= other_para_list */
  {  390,   -1 }, /* (379) other_para_list ::= star_func_para */
  {  390,   -3 }, /* (380) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  391,   -1 }, /* (381) star_func_para ::= expression */
  {  391,   -3 }, /* (382) star_func_para ::= table_name NK_DOT NK_STAR */
  {  392,   -3 }, /* (383) predicate ::= expression compare_op expression */
  {  392,   -5 }, /* (384) predicate ::= expression BETWEEN expression AND expression */
  {  392,   -6 }, /* (385) predicate ::= expression NOT BETWEEN expression AND expression */
  {  392,   -3 }, /* (386) predicate ::= expression IS NULL */
  {  392,   -4 }, /* (387) predicate ::= expression IS NOT NULL */
  {  392,   -3 }, /* (388) predicate ::= expression in_op in_predicate_value */
  {  393,   -1 }, /* (389) compare_op ::= NK_LT */
  {  393,   -1 }, /* (390) compare_op ::= NK_GT */
  {  393,   -1 }, /* (391) compare_op ::= NK_LE */
  {  393,   -1 }, /* (392) compare_op ::= NK_GE */
  {  393,   -1 }, /* (393) compare_op ::= NK_NE */
  {  393,   -1 }, /* (394) compare_op ::= NK_EQ */
  {  393,   -1 }, /* (395) compare_op ::= LIKE */
  {  393,   -2 }, /* (396) compare_op ::= NOT LIKE */
  {  393,   -1 }, /* (397) compare_op ::= MATCH */
  {  393,   -1 }, /* (398) compare_op ::= NMATCH */
  {  393,   -1 }, /* (399) compare_op ::= CONTAINS */
  {  394,   -1 }, /* (400) in_op ::= IN */
  {  394,   -2 }, /* (401) in_op ::= NOT IN */
  {  395,   -3 }, /* (402) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  396,   -1 }, /* (403) boolean_value_expression ::= boolean_primary */
  {  396,   -2 }, /* (404) boolean_value_expression ::= NOT boolean_primary */
  {  396,   -3 }, /* (405) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  396,   -3 }, /* (406) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  397,   -1 }, /* (407) boolean_primary ::= predicate */
  {  397,   -3 }, /* (408) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  398,   -1 }, /* (409) common_expression ::= expression */
  {  398,   -1 }, /* (410) common_expression ::= boolean_value_expression */
  {  399,    0 }, /* (411) from_clause_opt ::= */
  {  399,   -2 }, /* (412) from_clause_opt ::= FROM table_reference_list */
  {  400,   -1 }, /* (413) table_reference_list ::= table_reference */
  {  400,   -3 }, /* (414) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  401,   -1 }, /* (415) table_reference ::= table_primary */
  {  401,   -1 }, /* (416) table_reference ::= joined_table */
  {  402,   -2 }, /* (417) table_primary ::= table_name alias_opt */
  {  402,   -4 }, /* (418) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  402,   -2 }, /* (419) table_primary ::= subquery alias_opt */
  {  402,   -1 }, /* (420) table_primary ::= parenthesized_joined_table */
  {  404,    0 }, /* (421) alias_opt ::= */
  {  404,   -1 }, /* (422) alias_opt ::= table_alias */
  {  404,   -2 }, /* (423) alias_opt ::= AS table_alias */
  {  405,   -3 }, /* (424) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  405,   -3 }, /* (425) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  403,   -6 }, /* (426) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  406,    0 }, /* (427) join_type ::= */
  {  406,   -1 }, /* (428) join_type ::= INNER */
  {  408,  -12 }, /* (429) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  409,    0 }, /* (430) set_quantifier_opt ::= */
  {  409,   -1 }, /* (431) set_quantifier_opt ::= DISTINCT */
  {  409,   -1 }, /* (432) set_quantifier_opt ::= ALL */
  {  410,   -1 }, /* (433) select_list ::= select_item */
  {  410,   -3 }, /* (434) select_list ::= select_list NK_COMMA select_item */
  {  418,   -1 }, /* (435) select_item ::= NK_STAR */
  {  418,   -1 }, /* (436) select_item ::= common_expression */
  {  418,   -2 }, /* (437) select_item ::= common_expression column_alias */
  {  418,   -3 }, /* (438) select_item ::= common_expression AS column_alias */
  {  418,   -3 }, /* (439) select_item ::= table_name NK_DOT NK_STAR */
  {  376,    0 }, /* (440) where_clause_opt ::= */
  {  376,   -2 }, /* (441) where_clause_opt ::= WHERE search_condition */
  {  411,    0 }, /* (442) partition_by_clause_opt ::= */
  {  411,   -3 }, /* (443) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  415,    0 }, /* (444) twindow_clause_opt ::= */
  {  415,   -6 }, /* (445) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  415,   -4 }, /* (446) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  415,   -6 }, /* (447) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  415,   -8 }, /* (448) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  363,    0 }, /* (449) sliding_opt ::= */
  {  363,   -4 }, /* (450) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  414,    0 }, /* (451) fill_opt ::= */
  {  414,   -4 }, /* (452) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  414,   -6 }, /* (453) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  419,   -1 }, /* (454) fill_mode ::= NONE */
  {  419,   -1 }, /* (455) fill_mode ::= PREV */
  {  419,   -1 }, /* (456) fill_mode ::= NULL */
  {  419,   -1 }, /* (457) fill_mode ::= LINEAR */
  {  419,   -1 }, /* (458) fill_mode ::= NEXT */
  {  416,    0 }, /* (459) group_by_clause_opt ::= */
  {  416,   -3 }, /* (460) group_by_clause_opt ::= GROUP BY group_by_list */
  {  420,   -1 }, /* (461) group_by_list ::= expression */
  {  420,   -3 }, /* (462) group_by_list ::= group_by_list NK_COMMA expression */
  {  417,    0 }, /* (463) having_clause_opt ::= */
  {  417,   -2 }, /* (464) having_clause_opt ::= HAVING search_condition */
  {  412,    0 }, /* (465) range_opt ::= */
  {  412,   -6 }, /* (466) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  413,    0 }, /* (467) every_opt ::= */
  {  413,   -4 }, /* (468) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  368,   -4 }, /* (469) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  421,   -1 }, /* (470) query_expression_body ::= query_primary */
  {  421,   -4 }, /* (471) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  421,   -3 }, /* (472) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  425,   -1 }, /* (473) query_primary ::= query_specification */
  {  425,   -6 }, /* (474) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  422,    0 }, /* (475) order_by_clause_opt ::= */
  {  422,   -3 }, /* (476) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  423,    0 }, /* (477) slimit_clause_opt ::= */
  {  423,   -2 }, /* (478) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  423,   -4 }, /* (479) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  423,   -4 }, /* (480) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  424,    0 }, /* (481) limit_clause_opt ::= */
  {  424,   -2 }, /* (482) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  424,   -4 }, /* (483) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  424,   -4 }, /* (484) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  386,   -3 }, /* (485) subquery ::= NK_LP query_expression NK_RP */
  {  407,   -1 }, /* (486) search_condition ::= common_expression */
  {  426,   -1 }, /* (487) sort_specification_list ::= sort_specification */
  {  426,   -3 }, /* (488) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  427,   -3 }, /* (489) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  428,    0 }, /* (490) ordering_specification_opt ::= */
  {  428,   -1 }, /* (491) ordering_specification_opt ::= ASC */
  {  428,   -1 }, /* (492) ordering_specification_opt ::= DESC */
  {  429,    0 }, /* (493) null_ordering_opt ::= */
  {  429,   -2 }, /* (494) null_ordering_opt ::= NULLS FIRST */
  {  429,   -2 }, /* (495) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,310,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,311,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,310,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,312,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,313,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,311,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,313,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,312,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy149, &yymsp[-1].minor.yy0, yymsp[0].minor.yy363); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy149, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy149, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy149, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy149); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy363 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy363 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy49, &yymsp[-2].minor.yy149, &yymsp[0].minor.yy149); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy49, &yymsp[-2].minor.yy149, &yymsp[0].minor.yy149); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy49 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy49 = yymsp[0].minor.yy49; }
  yymsp[0].minor.yy49 = yylhsminor.yy49;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy49 = yymsp[-2].minor.yy49 | yymsp[0].minor.yy49; }
  yymsp[-2].minor.yy49 = yylhsminor.yy49;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy49 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy49 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy149 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy149 = yylhsminor.yy149;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy149 = yymsp[-2].minor.yy149; }
  yymsp[-2].minor.yy149 = yylhsminor.yy149;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy149, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy149, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy149); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 319: /* db_name ::= NK_ID */ yytestcase(yyruleno==319);
      case 320: /* table_name ::= NK_ID */ yytestcase(yyruleno==320);
      case 321: /* column_name ::= NK_ID */ yytestcase(yyruleno==321);
      case 322: /* function_name ::= NK_ID */ yytestcase(yyruleno==322);
      case 323: /* table_alias ::= NK_ID */ yytestcase(yyruleno==323);
      case 324: /* column_alias ::= NK_ID */ yytestcase(yyruleno==324);
      case 325: /* user_name ::= NK_ID */ yytestcase(yyruleno==325);
      case 326: /* topic_name ::= NK_ID */ yytestcase(yyruleno==326);
      case 327: /* stream_name ::= NK_ID */ yytestcase(yyruleno==327);
      case 328: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==328);
      case 364: /* noarg_func ::= NOW */ yytestcase(yyruleno==364);
      case 365: /* noarg_func ::= TODAY */ yytestcase(yyruleno==365);
      case 366: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==366);
      case 367: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==367);
      case 368: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==368);
      case 369: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==369);
      case 370: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==370);
      case 371: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==371);
      case 372: /* noarg_func ::= USER */ yytestcase(yyruleno==372);
      case 373: /* star_func ::= COUNT */ yytestcase(yyruleno==373);
      case 374: /* star_func ::= FIRST */ yytestcase(yyruleno==374);
      case 375: /* star_func ::= LAST */ yytestcase(yyruleno==375);
      case 376: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==376);
{ yylhsminor.yy149 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy149 = yylhsminor.yy149;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy497, &yymsp[-1].minor.yy149, yymsp[0].minor.yy312); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy497, &yymsp[0].minor.yy149); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy149); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy149, yymsp[0].minor.yy312); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy149); }
        break;
      case 67: /* cmd ::= TRIM DATABASE db_name */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[0].minor.yy149); }
        break;
      case 68: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy497 = true; }
        break;
      case 69: /* not_exists_opt ::= */
      case 71: /* exists_opt ::= */ yytestcase(yyruleno==71);
      case 262: /* analyze_opt ::= */ yytestcase(yyruleno==262);
      case 269: /* agg_func_opt ::= */ yytestcase(yyruleno==269);
      case 430: /* set_quantifier_opt ::= */ yytestcase(yyruleno==430);
{ yymsp[1].minor.yy497 = false; }
        break;
      case 70: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy497 = true; }
        break;
      case 72: /* db_options ::= */
{ yymsp[1].minor.yy312 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 73: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 74: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 75: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 76: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 77: /* db_options ::= db_options DURATION NK_INTEGER */
      case 78: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==78);
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 79: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 80: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 81: /* db_options ::= db_options KEEP integer_list */
      case 82: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==82);
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_KEEP, yymsp[0].minor.yy824); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 83: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 84: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 85: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 86: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 87: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 88: /* db_options ::= db_options STRICT NK_STRING */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 89: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 90: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 91: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_RETENTIONS, yymsp[0].minor.yy824); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 92: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 93: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 94: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 95: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 96: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-3].minor.yy312, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy312 = yylhsminor.yy312;
        break;
      case 97: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-3].minor.yy312, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy312 = yylhsminor.yy312;
        break;
      case 99: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 100: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 101: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 102: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 103: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy312 = setDatabaseOption(pCxt, yymsp[-2].minor.yy312, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 104: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy312 = createAlterDatabaseOptions(pCxt); yylhsminor.yy312 = setAlterDatabaseOption(pCxt, yylhsminor.yy312, &yymsp[0].minor.yy405); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 105: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy312 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy312, &yymsp[0].minor.yy405); }
  yymsp[-1].minor.yy312 = yylhsminor.yy312;
        break;
      case 106: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy405.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy405.val = yymsp[0].minor.yy0; }
        break;
      case 107: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy405.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy405.val = yymsp[0].minor.yy0; }
        break;
      case 108: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy405.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy405.val = yymsp[0].minor.yy0; }
        break;
      case 109: /* alter_db_option ::= KEEP integer_list */
      case 110: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==110);
{ yymsp[-1].minor.yy405.type = DB_OPTION_KEEP; yymsp[-1].minor.yy405.pList = yymsp[0].minor.yy824; }
        break;
      case 111: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy405.type = DB_OPTION_WAL; yymsp[-1].minor.yy405.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy405.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy405.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy824 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy824 = yylhsminor.yy824;
        break;
      case 114: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 289: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==289);
{ yylhsminor.yy824 = addNodeToList(pCxt, yymsp[-2].minor.yy824, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy824 = yylhsminor.yy824;
        break;
      case 115: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy824 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy824 = yylhsminor.yy824;
        break;
      case 116: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy824 = addNodeToList(pCxt, yymsp[-2].minor.yy824, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy824 = yylhsminor.yy824;
        break;
      case 117: /* retention_list ::= retention */
      case 137: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==137);
      case 140: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==140);
      case 147: /* column_def_list ::= column_def */ yytestcase(yyruleno==147);
      case 190: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==190);
      case 195: /* col_name_list ::= col_name */ yytestcase(yyruleno==195);
      case 245: /* func_list ::= func */ yytestcase(yyruleno==245);
      case 317: /* literal_list ::= signed_literal */ yytestcase(yyruleno==317);
      case 379: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==379);
      case 433: /* select_list ::= select_item */ yytestcase(yyruleno==433);
      case 487: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==487);
{ yylhsminor.yy824 = createNodeList(pCxt, yymsp[0].minor.yy312); }
  yymsp[0].minor.yy824 = yylhsminor.yy824;
        break;
      case 118: /* retention_list ::= retention_list NK_COMMA retention */
      case 148: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==148);
      case 191: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==191);
      case 196: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==196);
      case 246: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==246);
      case 318: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==318);
      case 380: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==380);
      case 434: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==434);
      case 488: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==488);
{ yylhsminor.yy824 = addNodeToList(pCxt, yymsp[-2].minor.yy824, yymsp[0].minor.yy312); }
  yymsp[-2].minor.yy824 = yylhsminor.yy824;
        break;
      case 119: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy312 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 120: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 122: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==122);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy497, yymsp[-5].minor.yy312, yymsp[-3].minor.yy824, yymsp[-1].minor.yy824, yymsp[0].minor.yy312); }
        break;
      case 121: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy824); }
        break;
      case 123: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy824); }
        break;
      case 124: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy497, yymsp[0].minor.yy312); }
        break;
      case 125: /* cmd ::= ALTER TABLE alter_table_clause */
      case 291: /* cmd ::= query_expression */ yytestcase(yyruleno==291);
{ pCxt->pRootNode = yymsp[0].minor.yy312; }
        break;
      case 126: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy312); }
        break;
      case 127: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy312 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy312, yymsp[0].minor.yy312); }
  yymsp[-1].minor.yy312 = yylhsminor.yy312;
        break;
      case 128: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy312 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy312, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy149, yymsp[0].minor.yy84); }
  yymsp[-4].minor.yy312 = yylhsminor.yy312;
        break;
      case 129: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy312 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy312, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy149); }
  yymsp[-3].minor.yy312 = yylhsminor.yy312;
        break;
      case 130: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy312 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy312, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy149, yymsp[0].minor.yy84); }
  yymsp[-4].minor.yy312 = yylhsminor.yy312;
        break;
      case 131: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy312 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy312, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy149, &yymsp[0].minor.yy149); }
  yymsp[-4].minor.yy312 = yylhsminor.yy312;
        break;
      case 132: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy312 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy312, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy149, yymsp[0].minor.yy84); }
  yymsp[-4].minor.yy312 = yylhsminor.yy312;
        break;
      case 133: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy312 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy312, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy149); }
  yymsp[-3].minor.yy312 = yylhsminor.yy312;
        break;
      case 134: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy312 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy312, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy149, yymsp[0].minor.yy84); }
  yymsp[-4].minor.yy312 = yylhsminor.yy312;
        break;
      case 135: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy312 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy312, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy149, &yymsp[0].minor.yy149); }
  yymsp[-4].minor.yy312 = yylhsminor.yy312;
        break;
      case 136: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy312 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy312, &yymsp[-2].minor.yy149, yymsp[0].minor.yy312); }
  yymsp[-5].minor.yy312 = yylhsminor.yy312;
        break;
      case 138: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 141: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==141);
{ yylhsminor.yy824 = addNodeToList(pCxt, yymsp[-1].minor.yy824, yymsp[0].minor.yy312); }
  yymsp[-1].minor.yy824 = yylhsminor.yy824;
        break;
      case 139: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy312 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy497, yymsp[-8].minor.yy312, yymsp[-6].minor.yy312, yymsp[-5].minor.yy824, yymsp[-2].minor.yy824, yymsp[0].minor.yy312); }
  yymsp[-9].minor.yy312 = yylhsminor.yy312;
        break;
      case 142: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy312 = createDropTableClause(pCxt, yymsp[-1].minor.yy497, yymsp[0].minor.yy312); }
  yymsp[-1].minor.yy312 = yylhsminor.yy312;
        break;
      case 143: /* specific_cols_opt ::= */
      case 174: /* tags_def_opt ::= */ yytestcase(yyruleno==174);
      case 442: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==442);
      case 459: /* group_by_clause_opt ::= */ yytestcase(yyruleno==459);
      case 475: /* order_by_clause_opt ::= */ yytestcase(yyruleno==475);
{ yymsp[1].minor.yy824 = NULL; }
        break;
      case 144: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy824 = yymsp[-1].minor.yy824; }
        break;
      case 145: /* full_table_name ::= table_name */
{ yylhsminor.yy312 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy149, NULL); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 146: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy312 = createRealTableNode(pCxt, &yymsp[-2].minor.yy149, &yymsp[0].minor.yy149, NULL); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 149: /* column_def ::= column_name type_name */
{ yylhsminor.yy312 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy149, yymsp[0].minor.yy84, NULL); }
  yymsp[-1].minor.yy312 = yylhsminor.yy312;
        break;
      case 150: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy312 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy149, yymsp[-2].minor.yy84, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy312 = yylhsminor.yy312;
        break;
      case 151: /* type_name ::= BOOL */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 152: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 153: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 154: /* type_name ::= INT */
      case 155: /* type_name ::= INTEGER */ yytestcase(yyruleno==155);
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 156: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 157: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 158: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 159: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy84 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 160: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 161: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy84 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 162: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy84 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 163: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy84 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 164: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy84 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 165: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy84 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 166: /* type_name ::= JSON */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 167: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy84 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 169: /* type_name ::= BLOB */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 170: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy84 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 171: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy84 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 172: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy84 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 173: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy84 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 175: /* tags_def_opt ::= tags_def */
      case 378: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==378);
{ yylhsminor.yy824 = yymsp[0].minor.yy824; }
  yymsp[0].minor.yy824 = yylhsminor.yy824;
        break;
      case 176: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy824 = yymsp[-1].minor.yy824; }
        break;
      case 177: /* table_options ::= */
{ yymsp[1].minor.yy312 = createDefaultTableOptions(pCxt); }
        break;
      case 178: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy312 = setTableOption(pCxt, yymsp[-2].minor.yy312, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 179: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy312 = setTableOption(pCxt, yymsp[-2].minor.yy312, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy824); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 180: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy312 = setTableOption(pCxt, yymsp[-2].minor.yy312, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy824); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 181: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy312 = setTableOption(pCxt, yymsp[-4].minor.yy312, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy824); }
  yymsp[-4].minor.yy312 = yylhsminor.yy312;
        break;
      case 182: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy312 = setTableOption(pCxt, yymsp[-2].minor.yy312, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 183: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy312 = setTableOption(pCxt, yymsp[-4].minor.yy312, TABLE_OPTION_SMA, yymsp[-1].minor.yy824); }
  yymsp[-4].minor.yy312 = yylhsminor.yy312;
        break;
      case 184: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy312 = createAlterTableOptions(pCxt); yylhsminor.yy312 = setTableOption(pCxt, yylhsminor.yy312, yymsp[0].minor.yy405.type, &yymsp[0].minor.yy405.val); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 185: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy312 = setTableOption(pCxt, yymsp[-1].minor.yy312, yymsp[0].minor.yy405.type, &yymsp[0].minor.yy405.val); }
  yymsp[-1].minor.yy312 = yylhsminor.yy312;
        break;
      case 186: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy405.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy405.val = yymsp[0].minor.yy0; }
        break;
      case 187: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy405.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy405.val = yymsp[0].minor.yy0; }
        break;
      case 188: /* duration_list ::= duration_literal */
      case 345: /* expression_list ::= expression */ yytestcase(yyruleno==345);
{ yylhsminor.yy824 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy312)); }
  yymsp[0].minor.yy824 = yylhsminor.yy824;
        break;
      case 189: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 346: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==346);
{ yylhsminor.yy824 = addNodeToList(pCxt, yymsp[-2].minor.yy824, releaseRawExprNode(pCxt, yymsp[0].minor.yy312)); }
  yymsp[-2].minor.yy824 = yylhsminor.yy824;
        break;
      case 192: /* rollup_func_name ::= function_name */
{ yylhsminor.yy312 = createFunctionNode(pCxt, &yymsp[0].minor.yy149, NULL); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 193: /* rollup_func_name ::= FIRST */
      case 194: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==194);
{ yylhsminor.yy312 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 197: /* col_name ::= column_name */
{ yylhsminor.yy312 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy149); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 198: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 199: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 200: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 201: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy312, yymsp[0].minor.yy312, OP_TYPE_LIKE); }
        break;
      case 202: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy312, yymsp[0].minor.yy312, OP_TYPE_LIKE); }
        break;
      case 203: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy312, NULL, OP_TYPE_LIKE); }
        break;
      case 204: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 205: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 206: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 207: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 208: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy312, yymsp[-1].minor.yy312, OP_TYPE_EQUAL); }
        break;
      case 209: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 210: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 211: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 212: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 213: /* cmd ::= SHOW LICENCES */
      case 214: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==214);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 215: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy149); }
        break;
      case 216: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy312); }
        break;
      case 217: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy312); }
        break;
      case 218: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 219: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 220: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 221: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 222: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 223: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 224: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 225: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 226: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 227: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 228: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy312); }
        break;
      case 229: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 230: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 231: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy312, yymsp[-1].minor.yy312, OP_TYPE_EQUAL); }
        break;
      case 232: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 233: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 234: /* db_name_cond_opt ::= */
      case 239: /* from_db_opt ::= */ yytestcase(yyruleno==239);
{ yymsp[1].minor.yy312 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 235: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy312 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy149); }
  yymsp[-1].minor.yy312 = yylhsminor.yy312;
        break;
      case 236: /* like_pattern_opt ::= */
      case 411: /* from_clause_opt ::= */ yytestcase(yyruleno==411);
      case 440: /* where_clause_opt ::= */ yytestcase(yyruleno==440);
      case 444: /* twindow_clause_opt ::= */ yytestcase(yyruleno==444);
      case 449: /* sliding_opt ::= */ yytestcase(yyruleno==449);
      case 451: /* fill_opt ::= */ yytestcase(yyruleno==451);
      case 463: /* having_clause_opt ::= */ yytestcase(yyruleno==463);
      case 465: /* range_opt ::= */ yytestcase(yyruleno==465);
      case 467: /* every_opt ::= */ yytestcase(yyruleno==467);
      case 477: /* slimit_clause_opt ::= */ yytestcase(yyruleno==477);
      case 481: /* limit_clause_opt ::= */ yytestcase(yyruleno==481);
{ yymsp[1].minor.yy312 = NULL; }
        break;
      case 237: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy312 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 238: /* table_name_cond ::= table_name */
{ yylhsminor.yy312 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy149); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 240: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy312 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy149); }
        break;
      case 241: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy497, yymsp[-3].minor.yy312, yymsp[-1].minor.yy312, NULL, yymsp[0].minor.yy312); }
        break;
      case 242: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy497, yymsp[0].minor.yy312); }
        break;
      case 243: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy312 = createIndexOption(pCxt, yymsp[-7].minor.yy824, releaseRawExprNode(pCxt, yymsp[-3].minor.yy312), NULL, yymsp[-1].minor.yy312, yymsp[0].minor.yy312); }
        break;
      case 244: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy312 = createIndexOption(pCxt, yymsp[-9].minor.yy824, releaseRawExprNode(pCxt, yymsp[-5].minor.yy312), releaseRawExprNode(pCxt, yymsp[-3].minor.yy312), yymsp[-1].minor.yy312, yymsp[0].minor.yy312); }
        break;
      case 247: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy312 = createFunctionNode(pCxt, &yymsp[-3].minor.yy149, yymsp[-1].minor.yy824); }
  yymsp[-3].minor.yy312 = yylhsminor.yy312;
        break;
      case 248: /* sma_stream_opt ::= */
      case 275: /* stream_options ::= */ yytestcase(yyruleno==275);
{ yymsp[1].minor.yy312 = createStreamOptions(pCxt); }
        break;
      case 249: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 279: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==279);
{ ((SStreamOptions*)yymsp[-2].minor.yy312)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy312); yylhsminor.yy312 = yymsp[-2].minor.yy312; }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 250: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy312)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy312); yylhsminor.yy312 = yymsp[-2].minor.yy312; }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 251: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy497, &yymsp[-2].minor.yy149, yymsp[0].minor.yy312); }
        break;
      case 252: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy497, &yymsp[-3].minor.yy149, &yymsp[0].minor.yy149, false); }
        break;
      case 253: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy497, &yymsp[-5].minor.yy149, &yymsp[0].minor.yy149, true); }
        break;
      case 254: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy497, &yymsp[-3].minor.yy149, yymsp[0].minor.yy312, false); }
        break;
      case 255: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy497, &yymsp[-5].minor.yy149, yymsp[0].minor.yy312, true); }
        break;
      case 256: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy497, &yymsp[0].minor.yy149); }
        break;
      case 257: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy497, &yymsp[-2].minor.yy149, &yymsp[0].minor.yy149); }
        break;
      case 258: /* cmd ::= DESC full_table_name */
      case 259: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==259);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy312); }
        break;
      case 260: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 261: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy497, yymsp[-1].minor.yy312, yymsp[0].minor.yy312); }
        break;
      case 263: /* analyze_opt ::= ANALYZE */
      case 270: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==270);
      case 431: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==431);
{ yymsp[0].minor.yy497 = true; }
        break;
      case 264: /* explain_options ::= */
{ yymsp[1].minor.yy312 = createDefaultExplainOptions(pCxt); }
        break;
      case 265: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy312 = setExplainVerbose(pCxt, yymsp[-2].minor.yy312, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 266: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy312 = setExplainRatio(pCxt, yymsp[-2].minor.yy312, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 267: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy497, yymsp[-8].minor.yy497, &yymsp[-5].minor.yy149, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy84, yymsp[0].minor.yy160); }
        break;
      case 268: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy497, &yymsp[0].minor.yy149); }
        break;
      case 271: /* bufsize_opt ::= */
{ yymsp[1].minor.yy160 = 0; }
        break;
      case 272: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy160 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 273: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-6].minor.yy497, &yymsp[-5].minor.yy149, yymsp[-2].minor.yy312, yymsp[-4].minor.yy312, yymsp[0].minor.yy312); }
        break;
      case 274: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy497, &yymsp[0].minor.yy149); }
        break;
      case 276: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy312)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy312 = yymsp[-2].minor.yy312; }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 277: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy312)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy312 = yymsp[-2].minor.yy312; }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 278: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy312)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy312)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy312); yylhsminor.yy312 = yymsp[-3].minor.yy312; }
  yymsp[-3].minor.yy312 = yylhsminor.yy312;
        break;
      case 280: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy312)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy312 = yymsp[-3].minor.yy312; }
  yymsp[-3].minor.yy312 = yylhsminor.yy312;
        break;
      case 281: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 282: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 283: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 284: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 285: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 286: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy824); }
        break;
      case 287: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 288: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy824 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 290: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy312, yymsp[0].minor.yy312); }
        break;
      case 292: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy312, yymsp[-2].minor.yy824, yymsp[0].minor.yy312); }
        break;
      case 293: /* cmd ::= INSERT INTO full_table_name query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy312, NULL, yymsp[0].minor.yy312); }
        break;
      case 294: /* literal ::= NK_INTEGER */
{ yylhsminor.yy312 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 295: /* literal ::= NK_FLOAT */
{ yylhsminor.yy312 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 296: /* literal ::= NK_STRING */
{ yylhsminor.yy312 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 297: /* literal ::= NK_BOOL */
{ yylhsminor.yy312 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 298: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy312 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy312 = yylhsminor.yy312;
        break;
      case 299: /* literal ::= duration_literal */
      case 309: /* signed_literal ::= signed */ yytestcase(yyruleno==309);
      case 329: /* expression ::= literal */ yytestcase(yyruleno==329);
      case 330: /* expression ::= pseudo_column */ yytestcase(yyruleno==330);
      case 331: /* expression ::= column_reference */ yytestcase(yyruleno==331);
      case 332: /* expression ::= function_expression */ yytestcase(yyruleno==332);
      case 333: /* expression ::= subquery */ yytestcase(yyruleno==333);
      case 361: /* function_expression ::= literal_func */ yytestcase(yyruleno==361);
      case 403: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==403);
      case 407: /* boolean_primary ::= predicate */ yytestcase(yyruleno==407);
      case 409: /* common_expression ::= expression */ yytestcase(yyruleno==409);
      case 410: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==410);
      case 413: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==413);
      case 415: /* table_reference ::= table_primary */ yytestcase(yyruleno==415);
      case 416: /* table_reference ::= joined_table */ yytestcase(yyruleno==416);
      case 420: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==420);
      case 470: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==470);
      case 473: /* query_primary ::= query_specification */ yytestcase(yyruleno==473);
{ yylhsminor.yy312 = yymsp[0].minor.yy312; }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 300: /* literal ::= NULL */
{ yylhsminor.yy312 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 301: /* literal ::= NK_QUESTION */
{ yylhsminor.yy312 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 302: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy312 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 303: /* signed ::= NK_INTEGER */
{ yylhsminor.yy312 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 304: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy312 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 305: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy312 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy312 = yylhsminor.yy312;
        break;
      case 306: /* signed ::= NK_FLOAT */
{ yylhsminor.yy312 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 307: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy312 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 308: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy312 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy312 = yylhsminor.yy312;
        break;
      case 310: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy312 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 311: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy312 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 312: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy312 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 313: /* signed_literal ::= duration_literal */
      case 315: /* signed_literal ::= literal_func */ yytestcase(yyruleno==315);
      case 381: /* star_func_para ::= expression */ yytestcase(yyruleno==381);
      case 436: /* select_item ::= common_expression */ yytestcase(yyruleno==436);
      case 486: /* search_condition ::= common_expression */ yytestcase(yyruleno==486);
{ yylhsminor.yy312 = releaseRawExprNode(pCxt, yymsp[0].minor.yy312); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 314: /* signed_literal ::= NULL */
{ yylhsminor.yy312 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 316: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy312 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 334: /* expression ::= NK_LP expression NK_RP */
      case 408: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==408);
{ yylhsminor.yy312 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy312)); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 335: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy312);
                                                                                    yylhsminor.yy312 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy312));
                                                                                  }
  yymsp[-1].minor.yy312 = yylhsminor.yy312;
        break;
      case 336: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy312);
                                                                                    yylhsminor.yy312 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy312), NULL));
                                                                                  }
  yymsp[-1].minor.yy312 = yylhsminor.yy312;
        break;
      case 337: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy312);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy312);
                                                                                    yylhsminor.yy312 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy312), releaseRawExprNode(pCxt, yymsp[0].minor.yy312))); 
                                                                                  }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 338: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy312);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy312);
                                                                                    yylhsminor.yy312 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy312), releaseRawExprNode(pCxt, yymsp[0].minor.yy312))); 
                                                                                  }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 339: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy312);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy312);
                                                                                    yylhsminor.yy312 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy312), releaseRawExprNode(pCxt, yymsp[0].minor.yy312))); 
                                                                                  }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 340: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy312);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy312);
                                                                                    yylhsminor.yy312 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy312), releaseRawExprNode(pCxt, yymsp[0].minor.yy312))); 
                                                                                  }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 341: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy312);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy312);
                                                                                    yylhsminor.yy312 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy312), releaseRawExprNode(pCxt, yymsp[0].minor.yy312)));
                                                                                  }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 342: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy312);
                                                                                    yylhsminor.yy312 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy312), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 343: /* expression ::= expression NK_BITAND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy312);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy312);
                                                                                    yylhsminor.yy312 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy312), releaseRawExprNode(pCxt, yymsp[0].minor.yy312)));
                                                                                  }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 344: /* expression ::= expression NK_BITOR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy312);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy312);
                                                                                    yylhsminor.yy312 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy312), releaseRawExprNode(pCxt, yymsp[0].minor.yy312)));
                                                                                  }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 347: /* column_reference ::= column_name */
{ yylhsminor.yy312 = createRawExprNode(pCxt, &yymsp[0].minor.yy149, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy149)); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 348: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy312 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy149, &yymsp[0].minor.yy149, createColumnNode(pCxt, &yymsp[-2].minor.yy149, &yymsp[0].minor.yy149)); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 349: /* pseudo_column ::= ROWTS */
      case 350: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==350);
      case 352: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==352);
      case 353: /* pseudo_column ::= QEND */ yytestcase(yyruleno==353);
      case 354: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==354);
      case 355: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==355);
      case 356: /* pseudo_column ::= WEND */ yytestcase(yyruleno==356);
      case 357: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==357);
      case 363: /* literal_func ::= NOW */ yytestcase(yyruleno==363);
{ yylhsminor.yy312 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 351: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy312 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy149, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy149)))); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 358: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 359: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==359);
{ yylhsminor.yy312 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy149, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy149, yymsp[-1].minor.yy824)); }
  yymsp[-3].minor.yy312 = yylhsminor.yy312;
        break;
      case 360: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy312 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy312), yymsp[-1].minor.yy84)); }
  yymsp[-5].minor.yy312 = yylhsminor.yy312;
        break;
      case 362: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy312 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy149, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy149, NULL)); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 377: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy824 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy824 = yylhsminor.yy824;
        break;
      case 382: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 439: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==439);
{ yylhsminor.yy312 = createColumnNode(pCxt, &yymsp[-2].minor.yy149, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 383: /* predicate ::= expression compare_op expression */
      case 388: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==388);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy312);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy312);
                                                                                    yylhsminor.yy312 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy320, releaseRawExprNode(pCxt, yymsp[-2].minor.yy312), releaseRawExprNode(pCxt, yymsp[0].minor.yy312)));
                                                                                  }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 384: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy312);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy312);
                                                                                    yylhsminor.yy312 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy312), releaseRawExprNode(pCxt, yymsp[-2].minor.yy312), releaseRawExprNode(pCxt, yymsp[0].minor.yy312)));
                                                                                  }
  yymsp[-4].minor.yy312 = yylhsminor.yy312;
        break;
      case 385: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy312);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy312);
                                                                                    yylhsminor.yy312 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy312), releaseRawExprNode(pCxt, yymsp[-2].minor.yy312), releaseRawExprNode(pCxt, yymsp[0].minor.yy312)));
                                                                                  }
  yymsp[-5].minor.yy312 = yylhsminor.yy312;
        break;
      case 386: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy312);
                                                                                    yylhsminor.yy312 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy312), NULL));
                                                                                  }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 387: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy312);
                                                                                    yylhsminor.yy312 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy312), NULL));
                                                                                  }
  yymsp[-3].minor.yy312 = yylhsminor.yy312;
        break;
      case 389: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy320 = OP_TYPE_LOWER_THAN; }
        break;
      case 390: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy320 = OP_TYPE_GREATER_THAN; }
        break;
      case 391: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy320 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 392: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy320 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 393: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy320 = OP_TYPE_NOT_EQUAL; }
        break;
      case 394: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy320 = OP_TYPE_EQUAL; }
        break;
      case 395: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy320 = OP_TYPE_LIKE; }
        break;
      case 396: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy320 = OP_TYPE_NOT_LIKE; }
        break;
      case 397: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy320 = OP_TYPE_MATCH; }
        break;
      case 398: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy320 = OP_TYPE_NMATCH; }
        break;
      case 399: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy320 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 400: /* in_op ::= IN */
{ yymsp[0].minor.yy320 = OP_TYPE_IN; }
        break;
      case 401: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy320 = OP_TYPE_NOT_IN; }
        break;
      case 402: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy312 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy824)); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 404: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy312);
                                                                                    yylhsminor.yy312 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy312), NULL));
                                                                                  }
  yymsp[-1].minor.yy312 = yylhsminor.yy312;
        break;
      case 405: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy312);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy312);
                                                                                    yylhsminor.yy312 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy312), releaseRawExprNode(pCxt, yymsp[0].minor.yy312)));
                                                                                  }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 406: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy312);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy312);
                                                                                    yylhsminor.yy312 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy312), releaseRawExprNode(pCxt, yymsp[0].minor.yy312)));
                                                                                  }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 412: /* from_clause_opt ::= FROM table_reference_list */
      case 441: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==441);
      case 464: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==464);
{ yymsp[-1].minor.yy312 = yymsp[0].minor.yy312; }
        break;
      case 414: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy312 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy312, yymsp[0].minor.yy312, NULL); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 417: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy312 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy149, &yymsp[0].minor.yy149); }
  yymsp[-1].minor.yy312 = yylhsminor.yy312;
        break;
      case 418: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy312 = createRealTableNode(pCxt, &yymsp[-3].minor.yy149, &yymsp[-1].minor.yy149, &yymsp[0].minor.yy149); }
  yymsp[-3].minor.yy312 = yylhsminor.yy312;
        break;
      case 419: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy312 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy312), &yymsp[0].minor.yy149); }
  yymsp[-1].minor.yy312 = yylhsminor.yy312;
        break;
      case 421: /* alias_opt ::= */
{ yymsp[1].minor.yy149 = nil_token;  }
        break;
      case 422: /* alias_opt ::= table_alias */
{ yylhsminor.yy149 = yymsp[0].minor.yy149; }
  yymsp[0].minor.yy149 = yylhsminor.yy149;
        break;
      case 423: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy149 = yymsp[0].minor.yy149; }
        break;
      case 424: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 425: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==425);
{ yymsp[-2].minor.yy312 = yymsp[-1].minor.yy312; }
        break;
      case 426: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy312 = createJoinTableNode(pCxt, yymsp[-4].minor.yy832, yymsp[-5].minor.yy312, yymsp[-2].minor.yy312, yymsp[0].minor.yy312); }
  yymsp[-5].minor.yy312 = yylhsminor.yy312;
        break;
      case 427: /* join_type ::= */
{ yymsp[1].minor.yy832 = JOIN_TYPE_INNER; }
        break;
      case 428: /* join_type ::= INNER */
{ yymsp[0].minor.yy832 = JOIN_TYPE_INNER; }
        break;
      case 429: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy312 = createSelectStmt(pCxt, yymsp[-10].minor.yy497, yymsp[-9].minor.yy824, yymsp[-8].minor.yy312);
                                                                                    yymsp[-11].minor.yy312 = addWhereClause(pCxt, yymsp[-11].minor.yy312, yymsp[-7].minor.yy312);
                                                                                    yymsp[-11].minor.yy312 = addPartitionByClause(pCxt, yymsp[-11].minor.yy312, yymsp[-6].minor.yy824);
                                                                                    yymsp[-11].minor.yy312 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy312, yymsp[-2].minor.yy312);
                                                                                    yymsp[-11].minor.yy312 = addGroupByClause(pCxt, yymsp[-11].minor.yy312, yymsp[-1].minor.yy824);
                                                                                    yymsp[-11].minor.yy312 = addHavingClause(pCxt, yymsp[-11].minor.yy312, yymsp[0].minor.yy312);
                                                                                    yymsp[-11].minor.yy312 = addRangeClause(pCxt, yymsp[-11].minor.yy312, yymsp[-5].minor.yy312);
                                                                                    yymsp[-11].minor.yy312 = addEveryClause(pCxt, yymsp[-11].minor.yy312, yymsp[-4].minor.yy312);
                                                                                    yymsp[-11].minor.yy312 = addFillClause(pCxt, yymsp[-11].minor.yy312, yymsp[-3].minor.yy312);
                                                                                  }
        break;
      case 432: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy497 = false; }
        break;
      case 435: /* select_item ::= NK_STAR */
{ yylhsminor.yy312 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy312 = yylhsminor.yy312;
        break;
      case 437: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy312 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy312), &yymsp[0].minor.yy149); }
  yymsp[-1].minor.yy312 = yylhsminor.yy312;
        break;
      case 438: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy312 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy312), &yymsp[0].minor.yy149); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 443: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 460: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==460);
      case 476: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==476);
{ yymsp[-2].minor.yy824 = yymsp[0].minor.yy824; }
        break;
      case 445: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy312 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy312), releaseRawExprNode(pCxt, yymsp[-1].minor.yy312)); }
        break;
      case 446: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy312 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy312)); }
        break;
      case 447: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy312 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy312), NULL, yymsp[-1].minor.yy312, yymsp[0].minor.yy312); }
        break;
      case 448: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy312 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy312), releaseRawExprNode(pCxt, yymsp[-3].minor.yy312), yymsp[-1].minor.yy312, yymsp[0].minor.yy312); }
        break;
      case 450: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 468: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==468);
{ yymsp[-3].minor.yy312 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy312); }
        break;
      case 452: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy312 = createFillNode(pCxt, yymsp[-1].minor.yy134, NULL); }
        break;
      case 453: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy312 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy824)); }
        break;
      case 454: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy134 = FILL_MODE_NONE; }
        break;
      case 455: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy134 = FILL_MODE_PREV; }
        break;
      case 456: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy134 = FILL_MODE_NULL; }
        break;
      case 457: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy134 = FILL_MODE_LINEAR; }
        break;
      case 458: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy134 = FILL_MODE_NEXT; }
        break;
      case 461: /* group_by_list ::= expression */
{ yylhsminor.yy824 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy312))); }
  yymsp[0].minor.yy824 = yylhsminor.yy824;
        break;
      case 462: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy824 = addNodeToList(pCxt, yymsp[-2].minor.yy824, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy312))); }
  yymsp[-2].minor.yy824 = yylhsminor.yy824;
        break;
      case 466: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy312 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy312), releaseRawExprNode(pCxt, yymsp[-1].minor.yy312)); }
        break;
      case 469: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy312 = addOrderByClause(pCxt, yymsp[-3].minor.yy312, yymsp[-2].minor.yy824);
                                                                                    yylhsminor.yy312 = addSlimitClause(pCxt, yylhsminor.yy312, yymsp[-1].minor.yy312);
                                                                                    yylhsminor.yy312 = addLimitClause(pCxt, yylhsminor.yy312, yymsp[0].minor.yy312);
                                                                                  }
  yymsp[-3].minor.yy312 = yylhsminor.yy312;
        break;
      case 471: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy312 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy312, yymsp[0].minor.yy312); }
  yymsp[-3].minor.yy312 = yylhsminor.yy312;
        break;
      case 472: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy312 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy312, yymsp[0].minor.yy312); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 474: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ 
                                                                                    yymsp[-5].minor.yy312 = addOrderByClause(pCxt, yymsp[-4].minor.yy312, yymsp[-3].minor.yy824);
                                                                                    yymsp[-5].minor.yy312 = addSlimitClause(pCxt, yymsp[-5].minor.yy312, yymsp[-2].minor.yy312);
                                                                                    yymsp[-5].minor.yy312 = addLimitClause(pCxt, yymsp[-5].minor.yy312, yymsp[-1].minor.yy312);
                                                                                  }
        break;
      case 478: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 482: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==482);
{ yymsp[-1].minor.yy312 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 479: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 483: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==483);
{ yymsp[-3].minor.yy312 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 480: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 484: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==484);
{ yymsp[-3].minor.yy312 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 485: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy312 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy312); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 489: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy312 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy312), yymsp[-1].minor.yy158, yymsp[0].minor.yy417); }
  yymsp[-2].minor.yy312 = yylhsminor.yy312;
        break;
      case 490: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy158 = ORDER_ASC; }
        break;
      case 491: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy158 = ORDER_ASC; }
        break;
      case 492: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy158 = ORDER_DESC; }
        break;
      case 493: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy417 = NULL_ORDER_DEFAULT; }
        break;
      case 494: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy417 = NULL_ORDER_FIRST; }
        break;
      case 495: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy417 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
