/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 377
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SToken yy5;
  EJoinType yy74;
  SNodeList* yy210;
  EFillMode yy270;
  int64_t yy311;
  SAlterOption yy351;
  bool yy403;
  EOperatorType yy428;
  int32_t yy462;
  ENullOrder yy477;
  int8_t yy535;
  SDataType yy552;
  EOrder yy553;
  SNode* yy652;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             663
#define YYNRULE              487
#define YYNTOKEN             254
#define YY_MAX_SHIFT         662
#define YY_MIN_SHIFTREDUCE   966
#define YY_MAX_SHIFTREDUCE   1452
#define YY_ERROR_ACTION      1453
#define YY_ACCEPT_ACTION     1454
#define YY_NO_ACTION         1455
#define YY_MIN_REDUCE        1456
#define YY_MAX_REDUCE        1942
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2436)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   430, 1920,  431, 1491,  438,   71,  431, 1491,  514,   62,
 /*    10 */  1645, 1693,   39,   37, 1919,  549,  323,  325, 1917, 1690,
 /*    20 */   337,   86, 1254, 1457,   33,   32, 1643, 1589,   40,   38,
 /*    30 */    36,   35,   34, 1329,  119, 1252, 1777,   40,   38,   36,
 /*    40 */    35,   34, 1585,  122,  103, 1734,  549,  102,  101,  100,
 /*    50 */    99,   98,   97,   96,   95,   94, 1324,  526,  549,   22,
 /*    60 */    14, 1016,  342, 1015, 1795, 1638, 1640, 1260,  113,  142,
 /*    70 */  1795, 1468,  578,   79,  122,  468,  466, 1747,  542,  577,
 /*    80 */    39,   37, 1392,  120,    1, 1593,  122,   61,  337,   61,
 /*    90 */  1254, 1017,  358,  554, 1586,  554,  379,  551,  155, 1862,
 /*   100 */  1863, 1329, 1867, 1252, 1808, 1479,  659, 1521,   89, 1778,
 /*   110 */   580, 1780, 1781,  576,  120,  571,  541,  552, 1854,  552,
 /*   120 */  1331, 1332,  304, 1850, 1324, 1478,  120,  526,   14,  249,
 /*   130 */  1862,  548, 1456,  547, 1920, 1260, 1920, 1920,  164,   30,
 /*   140 */   259,  156, 1862, 1863, 1777, 1867, 1747,  161,  447,  161,
 /*   150 */   159, 1917,    2, 1917, 1917, 1593,  112,  111,  110,  109,
 /*   160 */   108,  107,  106,  105,  104, 1255, 1747, 1253, 1279,  483,
 /*   170 */   482,  481, 1795, 1920,  659,  480,  220,  221,  118,  477,
 /*   180 */   578,   43,  476,  475,  474, 1747,  160,  577, 1331, 1332,
 /*   190 */  1917,  429, 1258, 1259,  433, 1307, 1308, 1310, 1311, 1312,
 /*   200 */  1313, 1314,  573,  569, 1322, 1323, 1325, 1326, 1327, 1328,
 /*   210 */  1330, 1333, 1808, 1413, 1278,  538,   90, 1778,  580, 1780,
 /*   220 */  1781,  576, 1279,  571,  162, 1454, 1854,  162,  552,  162,
 /*   230 */   328, 1850, 1933, 1255,  314, 1253,   61,  303,  140,  143,
 /*   240 */   516, 1888,  999, 1549,   33,   32, 1645, 1596,   40,   38,
 /*   250 */    36,   35,   34,  341,  535, 1411, 1412, 1414, 1415, 1477,
 /*   260 */  1258, 1259, 1643, 1307, 1308, 1310, 1311, 1312, 1313, 1314,
 /*   270 */   573,  569, 1322, 1323, 1325, 1326, 1327, 1328, 1330, 1333,
 /*   280 */    39,   37, 1003, 1004,  315,  349,  313,  312,  337,  470,
 /*   290 */  1254, 1777,   42,  472,  544,  539,  305, 1353,   11,   10,
 /*   300 */  1747, 1329,  103, 1252,  153,  102,  101,  100,   99,   98,
 /*   310 */    97,   96,   95,   94,  385,  471,  378, 1632,  377, 1795,
 /*   320 */  1358, 1292, 1151, 1152, 1324, 1278, 1920,  553,   14, 1351,
 /*   330 */  1639, 1640, 1747,  437,  577, 1260,  433,   39,   37,  159,
 /*   340 */   483,  482,  481, 1917, 1920,  337,  480, 1254, 1518,  118,
 /*   350 */   477,  301,    2,  476,  475,  474,  605, 1918, 1329, 1808,
 /*   360 */  1252, 1917,   27,   90, 1778,  580, 1780, 1781,  576,  435,
 /*   370 */   571,   71,  370, 1854,  659, 1276,  162,  328, 1850,  154,
 /*   380 */  1396, 1324, 1365, 1352,  117, 1016, 1278, 1015, 1331, 1332,
 /*   390 */  1309,  158, 1260, 1588,  372,  368,  543,   33,   32, 1880,
 /*   400 */  1571,   40,   38,   36,   35,   34, 1357,  479,  478,    8,
 /*   410 */   636,  635,  634,  633,  345, 1017,  632,  631,  630,  123,
 /*   420 */   625,  624,  623,  622,  621,  620,  619,  618,  133,  614,
 /*   430 */   324,  659,  162, 1255,  561, 1253,   33,   32,  140,  613,
 /*   440 */    40,   38,   36,   35,   34, 1331, 1332, 1595,   29,  335,
 /*   450 */  1346, 1347, 1348, 1349, 1350, 1354, 1355, 1356, 1280,  447,
 /*   460 */  1258, 1259, 1476, 1307, 1308, 1310, 1311, 1312, 1313, 1314,
 /*   470 */   573,  569, 1322, 1323, 1325, 1326, 1327, 1328, 1330, 1333,
 /*   480 */    33,   32,  214,  526,   40,   38,   36,   35,   34,  170,
 /*   490 */  1255,  207, 1253,  219,  165, 1281,  340,   36,   35,   34,
 /*   500 */    59,   33,   32, 1747,  140,   40,   38,   36,   35,   34,
 /*   510 */    61, 1593,   75, 1595,  629,  627,   69, 1258, 1259,   68,
 /*   520 */  1307, 1308, 1310, 1311, 1312, 1313, 1314,  573,  569, 1322,
 /*   530 */  1323, 1325, 1326, 1327, 1328, 1330, 1333,   39,   37, 1334,
 /*   540 */  1689,  139,  298, 1475,  343,  337, 1777, 1254, 1277,  162,
 /*   550 */    73,  303,  140,  305,  516, 1234, 1235, 1423, 1329,  418,
 /*   560 */  1252, 1595, 1309, 1109,  602,  601,  600, 1113,  599, 1115,
 /*   570 */  1116,  598, 1118,  595, 1795, 1124,  592, 1126, 1127,  589,
 /*   580 */   586, 1324,  578,  488, 1747, 1449, 1351, 1747,  526,  577,
 /*   590 */   251,  472, 1260, 1474,   39,   37, 1683, 1254,  498,  383,
 /*   600 */    44,    4,  337,  554, 1254,  174,  173,  172, 1260,    9,
 /*   610 */  1252, 1071,  206,  471, 1808, 1329, 1593, 1252,   89, 1778,
 /*   620 */   580, 1780, 1781,  576,  497,  571,  491,  231, 1854, 1473,
 /*   630 */   485,  659,  304, 1850, 1747,  205,  562,  495, 1324,  493,
 /*   640 */  1352,   26, 1260, 1073, 1920, 1331, 1332,   33,   32, 1260,
 /*   650 */   162,   40,   38,   36,   35,   34, 1569,  159, 1869, 1472,
 /*   660 */  1471, 1917,   56, 1357,  611,   55,    9, 1869,  558,  526,
 /*   670 */  1747,   33,   32, 1645, 1448,   40,   38,   36,   35,   34,
 /*   680 */   384,  659, 1866,  131,  130,  608,  607,  606,  659, 1644,
 /*   690 */  1255, 1865, 1253, 1003, 1004, 1869,  513, 1593, 1470,    7,
 /*   700 */  1747, 1747, 1331, 1332, 1570,   29,  335, 1346, 1347, 1348,
 /*   710 */  1349, 1350, 1354, 1355, 1356,  613, 1582, 1258, 1259, 1864,
 /*   720 */  1307, 1308, 1310, 1311, 1312, 1313, 1314,  573,  569, 1322,
 /*   730 */  1323, 1325, 1326, 1327, 1328, 1330, 1333, 1920,  556, 1747,
 /*   740 */  1255, 1688, 1253,  298,  617,   28, 1565, 1255, 1403, 1253,
 /*   750 */   159,   33,   32,  514, 1917,   40,   38,   36,   35,   34,
 /*   760 */   347, 1874, 1385,  616, 1691,   33,   32, 1258, 1259,   40,
 /*   770 */    38,   36,   35,   34, 1258, 1259,  213, 1307, 1308, 1310,
 /*   780 */  1311, 1312, 1313, 1314,  573,  569, 1322, 1323, 1325, 1326,
 /*   790 */  1327, 1328, 1330, 1333,   39,   37,  300, 1578, 1276, 1467,
 /*   800 */   611, 1920,  337, 1777, 1254,  411,   74,  609,  423, 1466,
 /*   810 */  1636, 1508, 1389,  526,  159, 1329,  499, 1252, 1917,  131,
 /*   820 */   130,  608,  607,  606,  388,  396, 1465,  424, 1464,  398,
 /*   830 */  1339, 1795,  610,  484,  271, 1636, 1278, 1623, 1324,  578,
 /*   840 */  1747, 1593, 1292, 1568, 1747,  526,  577,   33,   32, 1260,
 /*   850 */  1747,   40,   38,   36,   35,   34,  113, 1920,  549,   52,
 /*   860 */   510,  389,  198,  473, 1263,  196,    2, 1747,  559, 1747,
 /*   870 */   159, 1808, 1580, 1593, 1917,   90, 1778,  580, 1780, 1781,
 /*   880 */   576, 1463,  571, 1385, 1462, 1854,  122, 1461,  659,  328,
 /*   890 */  1850, 1933, 1460, 1459,  200,   11,   10,  199, 1262, 1576,
 /*   900 */  1911,  422, 1331, 1332,  417,  416,  415,  414,  413,  410,
 /*   910 */   409,  408,  407,  406,  402,  401,  400,  399,  393,  392,
 /*   920 */   391,  390, 1747,  387,  386, 1747,  120,  526, 1747,  526,
 /*   930 */   628,  141, 1042, 1747, 1747,  526,  277,  526,  403,  611,
 /*   940 */   404,  157, 1862, 1863,  567, 1867,  446, 1255, 1590, 1253,
 /*   950 */   275,   58, 1451, 1452,   57, 1593,  506, 1593,  131,  130,
 /*   960 */   608,  607,  606, 1593, 1043, 1593, 1777,  210,  572,  604,
 /*   970 */   176,  426,  373,   41, 1258, 1259,  549, 1307, 1308, 1310,
 /*   980 */  1311, 1312, 1313, 1314,  573,  569, 1322, 1323, 1325, 1326,
 /*   990 */  1327, 1328, 1330, 1333, 1795,  526, 1266,   61,  202,  526,
 /*  1000 */   526,  201,  553,  526,  122,  204, 1722, 1747,  203,  577,
 /*  1010 */   507,  511, 1309, 1584,  524, 1202,  218, 1469, 1764, 1550,
 /*  1020 */   254,  526,  500, 1593, 1761,  554,  465, 1593, 1593, 1761,
 /*  1030 */  1265, 1593,  525, 1388, 1808,   88,  526, 1777,   90, 1778,
 /*  1040 */   580, 1780, 1781,  576,  120,  571, 1503,  260, 1854, 1593,
 /*  1050 */  1757, 1763,  328, 1850,  154, 1757, 1763,  326,  222,  249,
 /*  1060 */  1862,  548,  571,  547, 1593, 1795, 1920,  571,  486, 1501,
 /*  1070 */    66,   65,  382,  578, 1881,  169, 1343,   85, 1747,  159,
 /*  1080 */   577,  376,  536, 1917, 1767,  334,  333,   82,  125,  243,
 /*  1090 */   128,  489, 1796,  129,  299, 1268,   50,  366, 1492,  364,
 /*  1100 */   360,  356,  166,  351,  348, 1808, 1329, 1764, 1261,   90,
 /*  1110 */  1778,  580, 1780, 1781,  576, 1765,  571,  235, 1761, 1854,
 /*  1120 */   526, 1633, 1769,  328, 1850, 1933, 1761, 1497,   41, 1324,
 /*  1130 */   519,  344,  228, 1777, 1873, 1102,  346,  162, 1410,   50,
 /*  1140 */  1260,   41, 1884,  584, 1757, 1763,  332,  128, 1593,  129,
 /*  1150 */   114,  128, 1757, 1763,  550,  248,  571,  253,  256,  238,
 /*  1160 */   258, 1795,   80,   53,  571,    5,    3,  350, 1276,  578,
 /*  1170 */   270,  353,  357,  310, 1747,  654,  577, 1071,  311,  566,
 /*  1180 */  1218, 1359,  267, 1315,  405, 1130, 1685,  171,  412, 1134,
 /*  1190 */   554, 1141, 1139,  132, 1777,  420,  419,  425,  421,  427,
 /*  1200 */   428, 1808, 1282,  436, 1285,  284, 1778,  580, 1780, 1781,
 /*  1210 */   576,  439,  571, 1284,  179,  440,  181,  441, 1286,  184,
 /*  1220 */   442,  444, 1795,  186, 1283,  188,  445,   70,  448,  191,
 /*  1230 */   578, 1920,  268,  467,  469, 1747, 1583,  577, 1269,  302,
 /*  1240 */  1264,   93,  195,  501,  161,  208, 1579, 1777, 1917,  197,
 /*  1250 */   134,  554,  135, 1581, 1577,  136,  137, 1727,  211,  502,
 /*  1260 */   508,  512, 1808,  534,  215, 1272,  284, 1778,  580, 1780,
 /*  1270 */  1781,  576,  505,  571,  226, 1795,  569, 1322, 1323, 1325,
 /*  1280 */  1326, 1327, 1328,  578,  126,  515, 1726, 1695, 1747,  520,
 /*  1290 */   577,  127, 1920,  521,  320,  224,  517,  322,  522, 1777,
 /*  1300 */   269,   78, 1594, 1281,  530,  159,  532, 1885,  537, 1917,
 /*  1310 */   233,  533,  237, 1895, 1894, 1808,  327,    6,  540,   91,
 /*  1320 */  1778,  580, 1780, 1781,  576,  546,  571, 1795,  531, 1854,
 /*  1330 */  1876,  529,  528, 1853, 1850,  578, 1385,  247,  148, 1280,
 /*  1340 */  1747,  563,  577,  246,  244,  121,  242,   48, 1870,  329,
 /*  1350 */   582,  272, 1777,  245,  560, 1637, 1566,  263,  655,  656,
 /*  1360 */   658,   51,  285,  147, 1741, 1835, 1777, 1808,  295,  276,
 /*  1370 */   252,   91, 1778,  580, 1780, 1781,  576,   63,  571,  274,
 /*  1380 */  1795, 1854, 1916,  557, 1740,  565, 1850,  564,  575,  294,
 /*  1390 */  1739, 1936,  255, 1747, 1795,  577,  257,   64, 1738,  352,
 /*  1400 */  1735,  354,  578,  355, 1246, 1247,  167, 1747,  359,  577,
 /*  1410 */  1733,  361,  362,  363, 1732,  365, 1731,  367, 1730, 1777,
 /*  1420 */  1808,  369, 1729,  371,  292, 1778,  580, 1780, 1781,  576,
 /*  1430 */   574,  571,  568, 1826, 1808, 1712,  168, 1777,  144, 1778,
 /*  1440 */   580, 1780, 1781,  576,  375,  571,  374, 1795, 1221, 1706,
 /*  1450 */  1220, 1705,  380,  381, 1704,  578, 1703, 1190, 1678, 1677,
 /*  1460 */  1747, 1676,  577, 1675,   67, 1795, 1674, 1673, 1672, 1671,
 /*  1470 */   321,  394,  395,  578, 1670,  397, 1669, 1668, 1747, 1667,
 /*  1480 */   577, 1666,  555, 1934, 1665, 1664, 1663, 1808, 1662, 1777,
 /*  1490 */  1661,   91, 1778,  580, 1780, 1781,  576, 1660,  571, 1659,
 /*  1500 */  1658, 1854, 1657, 1656,  124, 1808, 1851, 1655, 1654,  293,
 /*  1510 */  1778,  580, 1780, 1781,  576, 1653,  571, 1795, 1192, 1649,
 /*  1520 */  1648, 1647,  527, 1652, 1651,  578, 1650, 1646, 1522,  175,
 /*  1530 */  1747, 1777,  577, 1520, 1488,  177, 1006,  115,  152, 1005,
 /*  1540 */  1487, 1777, 1720, 1714, 1702,  178, 1701,  432,  116,  183,
 /*  1550 */   434,  185, 1687, 1572, 1519, 1517,  451, 1808,  450, 1795,
 /*  1560 */  1515,  293, 1778,  580, 1780, 1781,  576,  578,  571, 1795,
 /*  1570 */   449,  453, 1747, 1035,  577, 1513,  454,  578,  455,  458,
 /*  1580 */   457, 1511, 1747,  461,  577,  462,  459, 1500,  463, 1499,
 /*  1590 */  1484, 1777, 1574, 1145, 1144, 1573, 1070, 1069, 1068, 1808,
 /*  1600 */  1067, 1064,  626,  288, 1778,  580, 1780, 1781,  576, 1808,
 /*  1610 */   571,  628, 1063,  144, 1778,  580, 1780, 1781,  576, 1795,
 /*  1620 */   571, 1062,  194,   49, 1509,  316, 1061,  575, 1504,  317,
 /*  1630 */  1502,  487, 1747,  318,  577, 1483,  490,  492, 1482,  494,
 /*  1640 */  1481,  545,  496, 1777, 1719,   92, 1713, 1228,  503,  138,
 /*  1650 */  1700, 1698, 1699, 1697, 1696,   15, 1694,  223, 1935, 1808,
 /*  1660 */  1777,  217,  212,  292, 1778,  580, 1780, 1781,  576, 1238,
 /*  1670 */   571, 1795, 1827, 1686,   82,  225,  336,   76,   77,  578,
 /*  1680 */   230,   16,   41,   23, 1747,   47,  577,  241, 1795,   54,
 /*  1690 */  1425,  234,  232,  338, 1407,  509,  578,  236,  240,  227,
 /*  1700 */  1409, 1747,  504,  577, 1402,  145,  239,  518,  319, 1767,
 /*  1710 */    25, 1808, 1382,  662, 1381,  293, 1778,  580, 1780, 1781,
 /*  1720 */   576,   24,  571,  250,   46, 1766,   18,  266, 1808,   81,
 /*  1730 */   149, 1437,  293, 1778,  580, 1780, 1781,  576,   45,  571,
 /*  1740 */  1436,  151,   17, 1442, 1431,  193,  652,  648,  644,  640,
 /*  1750 */   264, 1777,  330, 1441, 1440,  331,   10, 1270,   19,  146,
 /*  1760 */  1811, 1300, 1344, 1777,  464,  460,  456,  452,  192,  150,
 /*  1770 */  1319,  570,  163, 1317,   31, 1777, 1316,   87,  579, 1795,
 /*  1780 */   229,   12,   20,   21,  581, 1131,  583,  578,  339, 1128,
 /*  1790 */   585, 1795, 1747,  587,  577,   72, 1125,   13,  190,  578,
 /*  1800 */   588,  590,  593, 1795, 1747,  591,  577, 1119,  594,  596,
 /*  1810 */  1117,  578,  597,  523, 1108, 1123, 1747, 1122,  577, 1808,
 /*  1820 */  1140, 1121, 1120,  278, 1778,  580, 1780, 1781,  576,   83,
 /*  1830 */   571, 1808,  603,   84,   60,  279, 1778,  580, 1780, 1781,
 /*  1840 */   576,  261,  571, 1808, 1136,  216,  612,  280, 1778,  580,
 /*  1850 */  1780, 1781,  576, 1058,  571, 1033, 1077, 1777,  615,  262,
 /*  1860 */   189,  182, 1056,  187, 1055, 1054, 1226,  443,  209, 1053,
 /*  1870 */  1052, 1777, 1051, 1050, 1049, 1074, 1516, 1072, 1046, 1045,
 /*  1880 */  1044, 1041, 1040, 1039, 1038, 1795,  180,  637, 1514, 1512,
 /*  1890 */   639,  641,  643,  578,  645, 1510,  649,  647, 1747, 1795,
 /*  1900 */   577,  638,  642,  651,  646, 1498,  653,  578,  996,  650,
 /*  1910 */  1480,  657, 1747,  265,  577, 1256,  273,  660,  661, 1455,
 /*  1920 */  1455, 1777, 1455, 1455, 1455, 1808, 1455, 1455, 1455,  287,
 /*  1930 */  1778,  580, 1780, 1781,  576, 1455,  571, 1777, 1455, 1808,
 /*  1940 */  1455, 1455, 1455,  289, 1778,  580, 1780, 1781,  576, 1795,
 /*  1950 */   571, 1455, 1455, 1455, 1455, 1455, 1455,  578, 1455, 1455,
 /*  1960 */  1455, 1455, 1747, 1455,  577, 1795, 1455, 1455, 1455, 1455,
 /*  1970 */  1455, 1455, 1455,  578, 1455, 1455, 1455, 1455, 1747, 1455,
 /*  1980 */   577, 1455, 1455, 1455, 1455, 1455, 1455, 1455, 1455, 1808,
 /*  1990 */  1777, 1455, 1455,  281, 1778,  580, 1780, 1781,  576, 1455,
 /*  2000 */   571, 1455, 1455, 1455, 1777, 1808, 1455, 1455, 1455,  290,
 /*  2010 */  1778,  580, 1780, 1781,  576, 1455,  571, 1455, 1795, 1455,
 /*  2020 */  1455, 1455, 1455, 1455, 1455, 1455,  578, 1455, 1455, 1455,
 /*  2030 */  1455, 1747, 1795,  577, 1455, 1455, 1455, 1455, 1455, 1455,
 /*  2040 */   578, 1455, 1455, 1455, 1455, 1747, 1455,  577, 1455, 1455,
 /*  2050 */  1455, 1455, 1455, 1455, 1455, 1455, 1777, 1455, 1808, 1455,
 /*  2060 */  1455, 1455,  282, 1778,  580, 1780, 1781,  576, 1455,  571,
 /*  2070 */  1455, 1455, 1808, 1455, 1777, 1455,  291, 1778,  580, 1780,
 /*  2080 */  1781,  576, 1455,  571, 1795, 1455, 1455, 1455, 1455, 1455,
 /*  2090 */  1455, 1455,  578, 1455, 1455, 1455, 1455, 1747, 1777,  577,
 /*  2100 */  1455, 1455, 1795, 1455, 1455, 1455, 1455, 1455, 1455, 1455,
 /*  2110 */   578, 1455, 1455, 1455, 1455, 1747, 1455,  577, 1455, 1455,
 /*  2120 */  1455, 1455, 1455, 1455, 1808, 1455, 1795, 1455,  283, 1778,
 /*  2130 */   580, 1780, 1781,  576,  578,  571, 1455, 1455, 1455, 1747,
 /*  2140 */  1455,  577, 1808, 1455, 1455, 1455,  296, 1778,  580, 1780,
 /*  2150 */  1781,  576, 1455,  571, 1455, 1455, 1777, 1455, 1455, 1455,
 /*  2160 */  1455, 1455, 1455, 1455, 1455, 1455, 1808, 1455, 1455, 1455,
 /*  2170 */   297, 1778,  580, 1780, 1781,  576, 1455,  571, 1455, 1777,
 /*  2180 */  1455, 1455, 1455, 1455, 1795, 1455, 1455, 1455, 1455, 1455,
 /*  2190 */  1455, 1455,  578, 1455, 1455, 1455, 1455, 1747, 1455,  577,
 /*  2200 */  1455, 1455, 1455, 1455, 1455, 1455, 1455, 1795, 1455, 1455,
 /*  2210 */  1455, 1455, 1455, 1455, 1455,  578, 1455, 1455, 1455, 1455,
 /*  2220 */  1747, 1455,  577, 1455, 1808, 1455, 1455, 1455, 1789, 1778,
 /*  2230 */   580, 1780, 1781,  576, 1455,  571, 1777, 1455, 1455, 1455,
 /*  2240 */  1455, 1455, 1455, 1455, 1455, 1455, 1455, 1808, 1777, 1455,
 /*  2250 */  1455, 1788, 1778,  580, 1780, 1781,  576, 1455,  571, 1455,
 /*  2260 */  1455, 1455, 1777, 1455, 1795, 1455, 1455, 1455, 1455, 1455,
 /*  2270 */  1455, 1455,  578, 1455, 1455, 1455, 1795, 1747, 1455,  577,
 /*  2280 */  1455, 1455, 1455, 1455,  578, 1455, 1455, 1455, 1455, 1747,
 /*  2290 */  1795,  577, 1455, 1455, 1455, 1455, 1455, 1455,  578, 1455,
 /*  2300 */  1455, 1455, 1455, 1747, 1808,  577, 1455, 1455, 1787, 1778,
 /*  2310 */   580, 1780, 1781,  576, 1777,  571, 1808, 1455, 1455, 1455,
 /*  2320 */   308, 1778,  580, 1780, 1781,  576, 1455,  571, 1455, 1455,
 /*  2330 */  1808, 1455, 1777, 1455,  307, 1778,  580, 1780, 1781,  576,
 /*  2340 */  1455,  571, 1795, 1455, 1455, 1455, 1455, 1455, 1455, 1455,
 /*  2350 */   578, 1455, 1455, 1455, 1455, 1747, 1777,  577, 1455, 1455,
 /*  2360 */  1795, 1455, 1455, 1455, 1455, 1455, 1455, 1455,  578, 1455,
 /*  2370 */  1455, 1455, 1455, 1747, 1455,  577, 1455, 1455, 1455, 1455,
 /*  2380 */  1455, 1455, 1808, 1455, 1795, 1455,  309, 1778,  580, 1780,
 /*  2390 */  1781,  576,  578,  571, 1455, 1455, 1455, 1747, 1455,  577,
 /*  2400 */  1808, 1455, 1455, 1455,  306, 1778,  580, 1780, 1781,  576,
 /*  2410 */  1455,  571, 1455, 1455, 1455, 1455, 1455, 1455, 1455, 1455,
 /*  2420 */  1455, 1455, 1455, 1455, 1808, 1455, 1455, 1455,  286, 1778,
 /*  2430 */   580, 1780, 1781,  576, 1455,  571,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   261,  355,  263,  264,  261,  269,  263,  264,  300,    4,
 /*    10 */   285,    0,   12,   13,  368,  265,  308,  292,  372,  311,
 /*    20 */    20,  267,   22,    0,    8,    9,  301,  291,   12,   13,
 /*    30 */    14,   15,   16,   33,  280,   35,  257,   12,   13,   14,
 /*    40 */    15,   16,  288,  293,   21,    0,  265,   24,   25,   26,
 /*    50 */    27,   28,   29,   30,   31,   32,   56,  265,  265,   43,
 /*    60 */    60,   20,  296,   22,  285,  299,  300,   67,  276,  256,
 /*    70 */   285,  258,  293,  267,  293,  283,   35,  298,  293,  300,
 /*    80 */    12,   13,   14,  333,   84,  293,  293,   84,   20,   84,
 /*    90 */    22,   50,   47,  314,  288,  314,  314,  347,  348,  349,
 /*   100 */   350,   33,  352,   35,  325,  257,  106,    0,  329,  330,
 /*   110 */   331,  332,  333,  334,  333,  336,  331,   20,  339,   20,
 /*   120 */   120,  121,  343,  344,   56,  257,  333,  265,   60,  348,
 /*   130 */   349,  350,    0,  352,  355,   67,  355,  355,  276,  340,
 /*   140 */   341,  348,  349,  350,  257,  352,  298,  368,   59,  368,
 /*   150 */   368,  372,   84,  372,  372,  293,   24,   25,   26,   27,
 /*   160 */    28,   29,   30,   31,   32,  165,  298,  167,   20,   62,
 /*   170 */    63,   64,  285,  355,  106,   68,  115,  116,   71,   72,
 /*   180 */   293,   84,   75,   76,   77,  298,  368,  300,  120,  121,
 /*   190 */   372,  262,  192,  193,  265,  195,  196,  197,  198,  199,
 /*   200 */   200,  201,  202,  203,  204,  205,  206,  207,  208,  209,
 /*   210 */   210,  211,  325,  192,   20,  150,  329,  330,  331,  332,
 /*   220 */   333,  334,   20,  336,  224,  254,  339,  224,   20,  224,
 /*   230 */   343,  344,  345,  165,   37,  167,   84,  176,  285,  270,
 /*   240 */   179,  354,    4,  274,    8,    9,  285,  294,   12,   13,
 /*   250 */    14,   15,   16,  292,  233,  234,  235,  236,  237,  257,
 /*   260 */   192,  193,  301,  195,  196,  197,  198,  199,  200,  201,
 /*   270 */   202,  203,  204,  205,  206,  207,  208,  209,  210,  211,
 /*   280 */    12,   13,   44,   45,   87,  314,   89,   90,   20,   92,
 /*   290 */    22,  257,   84,   96,  229,  230,   60,  147,    1,    2,
 /*   300 */   298,   33,   21,   35,  284,   24,   25,   26,   27,   28,
 /*   310 */    29,   30,   31,   32,  265,  118,  164,  297,  166,  285,
 /*   320 */   170,   85,  120,  121,   56,   20,  355,  293,   60,   93,
 /*   330 */   299,  300,  298,  262,  300,   67,  265,   12,   13,  368,
 /*   340 */    62,   63,   64,  372,  355,   20,   68,   22,    0,   71,
 /*   350 */    72,  302,   84,   75,   76,   77,   95,  368,   33,  325,
 /*   360 */    35,  372,  212,  329,  330,  331,  332,  333,  334,   14,
 /*   370 */   336,  269,  160,  339,  106,   20,  224,  343,  344,  345,
 /*   380 */    14,   56,   85,  147,  282,   20,   20,   22,  120,  121,
 /*   390 */   196,  357,   67,  291,  182,  183,   20,    8,    9,  365,
 /*   400 */     0,   12,   13,   14,   15,   16,  170,  271,  272,   84,
 /*   410 */    62,   63,   64,   65,   66,   50,   68,   69,   70,   71,
 /*   420 */    72,   73,   74,   75,   76,   77,   78,   79,   80,   81,
 /*   430 */   277,  106,  224,  165,   43,  167,    8,    9,  285,   59,
 /*   440 */    12,   13,   14,   15,   16,  120,  121,  294,  212,  213,
 /*   450 */   214,  215,  216,  217,  218,  219,  220,  221,   20,   59,
 /*   460 */   192,  193,  257,  195,  196,  197,  198,  199,  200,  201,
 /*   470 */   202,  203,  204,  205,  206,  207,  208,  209,  210,  211,
 /*   480 */     8,    9,   56,  265,   12,   13,   14,   15,   16,   56,
 /*   490 */   165,  116,  167,  115,  276,   20,  277,   14,   15,   16,
 /*   500 */     3,    8,    9,  298,  285,   12,   13,   14,   15,   16,
 /*   510 */    84,  293,   86,  294,  271,  272,   83,  192,  193,   86,
 /*   520 */   195,  196,  197,  198,  199,  200,  201,  202,  203,  204,
 /*   530 */   205,  206,  207,  208,  209,  210,  211,   12,   13,   14,
 /*   540 */   310,  152,  312,  257,  277,   20,  257,   22,   20,  224,
 /*   550 */   175,  176,  285,   60,  179,  177,  178,   85,   33,   78,
 /*   560 */    35,  294,  196,   97,   98,   99,  100,  101,  102,  103,
 /*   570 */   104,  105,  106,  107,  285,  109,  110,  111,  112,  113,
 /*   580 */   114,   56,  293,    4,  298,  157,   93,  298,  265,  300,
 /*   590 */   152,   96,   67,  257,   12,   13,  293,   22,   19,  276,
 /*   600 */    42,   43,   20,  314,   22,  124,  125,  304,   67,   84,
 /*   610 */    35,   35,   33,  118,  325,   33,  293,   35,  329,  330,
 /*   620 */   331,  332,  333,  334,   21,  336,   47,  152,  339,  257,
 /*   630 */    51,  106,  343,  344,  298,   56,  245,   34,   56,   36,
 /*   640 */   147,    2,   67,   67,  355,  120,  121,    8,    9,   67,
 /*   650 */   224,   12,   13,   14,   15,   16,    0,  368,  327,  257,
 /*   660 */   257,  372,   83,  170,   96,   86,   84,  327,   43,  265,
 /*   670 */   298,    8,    9,  285,  246,   12,   13,   14,   15,   16,
 /*   680 */   276,  106,  351,  115,  116,  117,  118,  119,  106,  301,
 /*   690 */   165,  351,  167,   44,   45,  327,  314,  293,  257,   39,
 /*   700 */   298,  298,  120,  121,    0,  212,  213,  214,  215,  216,
 /*   710 */   217,  218,  219,  220,  221,   59,  286,  192,  193,  351,
 /*   720 */   195,  196,  197,  198,  199,  200,  201,  202,  203,  204,
 /*   730 */   205,  206,  207,  208,  209,  210,  211,  355,  241,  298,
 /*   740 */   165,  310,  167,  312,  273,    2,  275,  165,   85,  167,
 /*   750 */   368,    8,    9,  300,  372,   12,   13,   14,   15,   16,
 /*   760 */   314,  222,  223,   67,  311,    8,    9,  192,  193,   12,
 /*   770 */    13,   14,   15,   16,  192,  193,   56,  195,  196,  197,
 /*   780 */   198,  199,  200,  201,  202,  203,  204,  205,  206,  207,
 /*   790 */   208,  209,  210,  211,   12,   13,   18,  286,   20,  257,
 /*   800 */    96,  355,   20,  257,   22,   27,   86,  295,   30,  257,
 /*   810 */   298,    0,    4,  265,  368,   33,  314,   35,  372,  115,
 /*   820 */   116,  117,  118,  119,  276,   47,  257,   49,  257,   51,
 /*   830 */    14,  285,  295,   22,  278,  298,   20,  281,   56,  293,
 /*   840 */   298,  293,   85,    0,  298,  265,  300,    8,    9,   67,
 /*   850 */   298,   12,   13,   14,   15,   16,  276,  355,  265,  152,
 /*   860 */   153,   83,   88,  283,   35,   91,   84,  298,  243,  298,
 /*   870 */   368,  325,  286,  293,  372,  329,  330,  331,  332,  333,
 /*   880 */   334,  257,  336,  223,  257,  339,  293,  257,  106,  343,
 /*   890 */   344,  345,  257,  257,   88,    1,    2,   91,   35,  286,
 /*   900 */   354,  123,  120,  121,  126,  127,  128,  129,  130,  131,
 /*   910 */   132,  133,  134,  135,  136,  137,  138,  139,  140,  141,
 /*   920 */   142,  143,  298,  145,  146,  298,  333,  265,  298,  265,
 /*   930 */    43,   18,   35,  298,  298,  265,   23,  265,  276,   96,
 /*   940 */   276,  348,  349,  350,   60,  352,  276,  165,  276,  167,
 /*   950 */    37,   38,  120,  121,   41,  293,  318,  293,  115,  116,
 /*   960 */   117,  118,  119,  293,   67,  293,  257,  286,  286,  286,
 /*   970 */    57,   58,   85,   43,  192,  193,  265,  195,  196,  197,
 /*   980 */   198,  199,  200,  201,  202,  203,  204,  205,  206,  207,
 /*   990 */   208,  209,  210,  211,  285,  265,  167,   84,   88,  265,
 /*  1000 */   265,   91,  293,  265,  293,   88,  276,  298,   91,  300,
 /*  1010 */   276,  276,  196,  287,  276,   85,   43,  258,  287,  274,
 /*  1020 */   375,  265,  321,  293,  298,  314,  266,  293,  293,  298,
 /*  1030 */   167,  293,  276,  225,  325,  122,  265,  257,  329,  330,
 /*  1040 */   331,  332,  333,  334,  333,  336,    0,  276,  339,  293,
 /*  1050 */   324,  325,  343,  344,  345,  324,  325,  326,   85,  348,
 /*  1060 */   349,  350,  336,  352,  293,  285,  355,  336,   22,    0,
 /*  1070 */   157,  158,  159,  293,  365,  162,  192,   84,  298,  368,
 /*  1080 */   300,  168,  366,  372,   46,   12,   13,   94,   43,  362,
 /*  1090 */    43,   22,  285,   43,  181,   22,   43,  184,  264,  186,
 /*  1100 */   187,  188,  189,  190,  191,  325,   33,  287,   35,  329,
 /*  1110 */   330,  331,  332,  333,  334,  287,  336,   43,  298,  339,
 /*  1120 */   265,  297,   84,  343,  344,  345,  298,    0,   43,   56,
 /*  1130 */    85,  276,   85,  257,  354,   85,  266,  224,   85,   43,
 /*  1140 */    67,   43,  328,   43,  324,  325,  326,   43,  293,   43,
 /*  1150 */    43,   43,  324,  325,  353,  346,  336,  369,  369,   85,
 /*  1160 */   369,  285,   84,  289,  336,  226,  356,  323,   20,  293,
 /*  1170 */    85,  265,   47,  322,  298,   48,  300,   35,  271,  106,
 /*  1180 */   163,   85,  316,   85,  265,   85,  265,   42,  305,   85,
 /*  1190 */   314,   85,   85,   85,  257,  147,  303,  265,  303,  265,
 /*  1200 */   259,  325,   20,  259,   20,  329,  330,  331,  332,  333,
 /*  1210 */   334,  320,  336,   20,  269,  300,  269,  313,   20,  269,
 /*  1220 */   315,  313,  285,  269,   20,  269,  306,  269,  265,  269,
 /*  1230 */   293,  355,  320,  259,  285,  298,  285,  300,  165,  259,
 /*  1240 */   167,  265,  285,  173,  368,  267,  285,  257,  372,  285,
 /*  1250 */   285,  314,  285,  285,  285,  285,  285,  298,  267,  319,
 /*  1260 */   265,  265,  325,  231,  267,  192,  329,  330,  331,  332,
 /*  1270 */   333,  334,  300,  336,  267,  285,  203,  204,  205,  206,
 /*  1280 */   207,  208,  209,  293,  309,  298,  298,  298,  298,  149,
 /*  1290 */   300,  309,  355,  307,  313,  293,  298,  298,  306,  257,
 /*  1300 */   281,  267,  293,   20,  298,  368,  298,  328,  232,  372,
 /*  1310 */   309,  298,  309,  361,  361,  325,  298,  238,  298,  329,
 /*  1320 */   330,  331,  332,  333,  334,  156,  336,  285,  240,  339,
 /*  1330 */   364,  239,  227,  343,  344,  293,  223,  323,  361,   20,
 /*  1340 */   298,  244,  300,  358,  360,  293,  363,   84,  327,  247,
 /*  1350 */   289,  265,  257,  359,  242,  298,  275,  267,   36,  260,
 /*  1360 */   259,  317,  279,  312,    0,  342,  257,  325,  279,  255,
 /*  1370 */   370,  329,  330,  331,  332,  333,  334,  175,  336,  268,
 /*  1380 */   285,  339,  371,  371,    0,  343,  344,  371,  293,  279,
 /*  1390 */     0,  376,  370,  298,  285,  300,  370,   42,    0,   75,
 /*  1400 */     0,   35,  293,  185,   35,   35,   35,  298,  185,  300,
 /*  1410 */     0,   35,   35,  185,    0,  185,    0,   35,    0,  257,
 /*  1420 */   325,   22,    0,   35,  329,  330,  331,  332,  333,  334,
 /*  1430 */   335,  336,  337,  338,  325,    0,   84,  257,  329,  330,
 /*  1440 */   331,  332,  333,  334,  169,  336,  170,  285,  167,    0,
 /*  1450 */   165,    0,  161,  160,    0,  293,    0,   46,    0,    0,
 /*  1460 */   298,    0,  300,    0,  144,  285,    0,    0,    0,    0,
 /*  1470 */   290,  139,   35,  293,    0,  139,    0,    0,  298,    0,
 /*  1480 */   300,    0,  373,  374,    0,    0,    0,  325,    0,  257,
 /*  1490 */     0,  329,  330,  331,  332,  333,  334,    0,  336,    0,
 /*  1500 */     0,  339,    0,    0,   42,  325,  344,    0,    0,  329,
 /*  1510 */   330,  331,  332,  333,  334,    0,  336,  285,   22,    0,
 /*  1520 */     0,    0,  290,    0,    0,  293,    0,    0,    0,   56,
 /*  1530 */   298,  257,  300,    0,    0,   42,   14,   39,   43,   14,
 /*  1540 */     0,  257,    0,    0,    0,   40,    0,   46,   39,   39,
 /*  1550 */    46,  156,    0,    0,    0,    0,   39,  325,   47,  285,
 /*  1560 */     0,  329,  330,  331,  332,  333,  334,  293,  336,  285,
 /*  1570 */    35,   35,  298,   61,  300,    0,   47,  293,   39,   47,
 /*  1580 */    35,    0,  298,   35,  300,   47,   39,    0,   39,    0,
 /*  1590 */     0,  257,    0,   35,   22,    0,   35,   35,   35,  325,
 /*  1600 */    35,   35,   43,  329,  330,  331,  332,  333,  334,  325,
 /*  1610 */   336,   43,   35,  329,  330,  331,  332,  333,  334,  285,
 /*  1620 */   336,   35,   91,   93,    0,   22,   35,  293,    0,   22,
 /*  1630 */     0,   49,  298,   22,  300,    0,   35,   35,    0,   35,
 /*  1640 */     0,  367,   22,  257,    0,   20,    0,   35,   22,  171,
 /*  1650 */     0,    0,    0,    0,    0,   84,    0,   84,  374,  325,
 /*  1660 */   257,   85,  149,  329,  330,  331,  332,  333,  334,  180,
 /*  1670 */   336,  285,  338,    0,   94,   39,  290,   84,   84,  293,
 /*  1680 */    46,  228,   43,   84,  298,   43,  300,   46,  285,  152,
 /*  1690 */    85,   85,   84,  290,   85,  154,  293,   84,   43,  148,
 /*  1700 */    85,  298,  152,  300,   85,   84,   84,  150,  152,   46,
 /*  1710 */    43,  325,   85,   19,   85,  329,  330,  331,  332,  333,
 /*  1720 */   334,   84,  336,   46,   43,   46,   43,   33,  325,   84,
 /*  1730 */    46,   35,  329,  330,  331,  332,  333,  334,  222,  336,
 /*  1740 */    35,   47,  228,   85,   85,   33,   52,   53,   54,   55,
 /*  1750 */    56,  257,   35,   35,   35,   35,    2,   22,   43,   47,
 /*  1760 */    84,   22,  192,  257,   52,   53,   54,   55,   56,   46,
 /*  1770 */    85,   84,   46,   85,   84,  257,   85,   83,  194,  285,
 /*  1780 */    86,   84,   84,   84,   95,   85,   35,  293,   35,   85,
 /*  1790 */    84,  285,  298,   35,  300,   83,   85,  228,   86,  293,
 /*  1800 */    84,   35,   35,  285,  298,   84,  300,   85,   84,   35,
 /*  1810 */    85,  293,   84,  119,   22,  108,  298,  108,  300,  325,
 /*  1820 */    35,  108,  108,  329,  330,  331,  332,  333,  334,   84,
 /*  1830 */   336,  325,   96,   84,   84,  329,  330,  331,  332,  333,
 /*  1840 */   334,   43,  336,  325,   22,  151,   60,  329,  330,  331,
 /*  1850 */   332,  333,  334,   35,  336,   61,   67,  257,   82,   43,
 /*  1860 */   148,  149,   35,  151,   35,   35,  172,  155,  174,   35,
 /*  1870 */    35,  257,   22,   35,   35,   67,    0,   35,   35,   35,
 /*  1880 */    35,   35,   35,   35,   35,  285,  174,   35,    0,    0,
 /*  1890 */    39,   35,   39,  293,   35,    0,   35,   39,  298,  285,
 /*  1900 */   300,   47,   47,   39,   47,    0,   35,  293,   35,   47,
 /*  1910 */     0,   21,  298,   22,  300,   22,   22,   21,   20,  377,
 /*  1920 */   377,  257,  377,  377,  377,  325,  377,  377,  377,  329,
 /*  1930 */   330,  331,  332,  333,  334,  377,  336,  257,  377,  325,
 /*  1940 */   377,  377,  377,  329,  330,  331,  332,  333,  334,  285,
 /*  1950 */   336,  377,  377,  377,  377,  377,  377,  293,  377,  377,
 /*  1960 */   377,  377,  298,  377,  300,  285,  377,  377,  377,  377,
 /*  1970 */   377,  377,  377,  293,  377,  377,  377,  377,  298,  377,
 /*  1980 */   300,  377,  377,  377,  377,  377,  377,  377,  377,  325,
 /*  1990 */   257,  377,  377,  329,  330,  331,  332,  333,  334,  377,
 /*  2000 */   336,  377,  377,  377,  257,  325,  377,  377,  377,  329,
 /*  2010 */   330,  331,  332,  333,  334,  377,  336,  377,  285,  377,
 /*  2020 */   377,  377,  377,  377,  377,  377,  293,  377,  377,  377,
 /*  2030 */   377,  298,  285,  300,  377,  377,  377,  377,  377,  377,
 /*  2040 */   293,  377,  377,  377,  377,  298,  377,  300,  377,  377,
 /*  2050 */   377,  377,  377,  377,  377,  377,  257,  377,  325,  377,
 /*  2060 */   377,  377,  329,  330,  331,  332,  333,  334,  377,  336,
 /*  2070 */   377,  377,  325,  377,  257,  377,  329,  330,  331,  332,
 /*  2080 */   333,  334,  377,  336,  285,  377,  377,  377,  377,  377,
 /*  2090 */   377,  377,  293,  377,  377,  377,  377,  298,  257,  300,
 /*  2100 */   377,  377,  285,  377,  377,  377,  377,  377,  377,  377,
 /*  2110 */   293,  377,  377,  377,  377,  298,  377,  300,  377,  377,
 /*  2120 */   377,  377,  377,  377,  325,  377,  285,  377,  329,  330,
 /*  2130 */   331,  332,  333,  334,  293,  336,  377,  377,  377,  298,
 /*  2140 */   377,  300,  325,  377,  377,  377,  329,  330,  331,  332,
 /*  2150 */   333,  334,  377,  336,  377,  377,  257,  377,  377,  377,
 /*  2160 */   377,  377,  377,  377,  377,  377,  325,  377,  377,  377,
 /*  2170 */   329,  330,  331,  332,  333,  334,  377,  336,  377,  257,
 /*  2180 */   377,  377,  377,  377,  285,  377,  377,  377,  377,  377,
 /*  2190 */   377,  377,  293,  377,  377,  377,  377,  298,  377,  300,
 /*  2200 */   377,  377,  377,  377,  377,  377,  377,  285,  377,  377,
 /*  2210 */   377,  377,  377,  377,  377,  293,  377,  377,  377,  377,
 /*  2220 */   298,  377,  300,  377,  325,  377,  377,  377,  329,  330,
 /*  2230 */   331,  332,  333,  334,  377,  336,  257,  377,  377,  377,
 /*  2240 */   377,  377,  377,  377,  377,  377,  377,  325,  257,  377,
 /*  2250 */   377,  329,  330,  331,  332,  333,  334,  377,  336,  377,
 /*  2260 */   377,  377,  257,  377,  285,  377,  377,  377,  377,  377,
 /*  2270 */   377,  377,  293,  377,  377,  377,  285,  298,  377,  300,
 /*  2280 */   377,  377,  377,  377,  293,  377,  377,  377,  377,  298,
 /*  2290 */   285,  300,  377,  377,  377,  377,  377,  377,  293,  377,
 /*  2300 */   377,  377,  377,  298,  325,  300,  377,  377,  329,  330,
 /*  2310 */   331,  332,  333,  334,  257,  336,  325,  377,  377,  377,
 /*  2320 */   329,  330,  331,  332,  333,  334,  377,  336,  377,  377,
 /*  2330 */   325,  377,  257,  377,  329,  330,  331,  332,  333,  334,
 /*  2340 */   377,  336,  285,  377,  377,  377,  377,  377,  377,  377,
 /*  2350 */   293,  377,  377,  377,  377,  298,  257,  300,  377,  377,
 /*  2360 */   285,  377,  377,  377,  377,  377,  377,  377,  293,  377,
 /*  2370 */   377,  377,  377,  298,  377,  300,  377,  377,  377,  377,
 /*  2380 */   377,  377,  325,  377,  285,  377,  329,  330,  331,  332,
 /*  2390 */   333,  334,  293,  336,  377,  377,  377,  298,  377,  300,
 /*  2400 */   325,  377,  377,  377,  329,  330,  331,  332,  333,  334,
 /*  2410 */   377,  336,  377,  377,  377,  377,  377,  377,  377,  377,
 /*  2420 */   377,  377,  377,  377,  325,  377,  377,  377,  329,  330,
 /*  2430 */   331,  332,  333,  334,  377,  336,
};
#define YY_SHIFT_COUNT    (662)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1910)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   913,    0,    0,   68,   68,  268,  268,  268,  325,  325,
 /*    10 */   268,  268,  525,  582,  782,  582,  582,  582,  582,  582,
 /*    20 */   582,  582,  582,  582,  582,  582,  582,  582,  582,  582,
 /*    30 */   582,  582,  582,  582,  582,  582,  582,  582,  582,  582,
 /*    40 */   582,  582,  208,  208,   97,   97,   97, 1073, 1073, 1073,
 /*    50 */  1073,  152,  426,    3,    3,   99,   99,  238,  238,    5,
 /*    60 */   202,    3,    3,   99,   99,   99,   99,   99,   99,   99,
 /*    70 */    99,   99,   89,   99,   99,   99,  148,  305,   99,   99,
 /*    80 */   305,  376,   99,  305,  305,  305,   99,  380,  778,  236,
 /*    90 */   493,  493,  281,  278,  575,  575,  575,  575,  575,  575,
 /*   100 */   575,  575,  575,  575,  575,  575,  575,  575,  575,  575,
 /*   110 */   575,  575,  575,  197,  202,  355,  355,  400,  576,  656,
 /*   120 */   438,  438,  438,  576,  528,  148,   11,   11,  305,  305,
 /*   130 */   541,  541,  261,  696,  466,  466,  466,  466,  466,  466,
 /*   140 */   466, 1694,   23,  107,  428,   21,   41,  375,   65,  366,
 /*   150 */   816,  365,  649,  495,  475,  539,  660,  539,  558,  497,
 /*   160 */   497,  497,  808,  194, 1078,  939, 1148, 1125, 1142, 1017,
 /*   170 */  1148, 1148, 1145, 1048, 1048, 1148, 1148, 1182, 1182, 1184,
 /*   180 */    89,  148,   89, 1193, 1198,   89, 1193,   89, 1204,   89,
 /*   190 */    89, 1148,   89, 1182,  305,  305,  305,  305,  305,  305,
 /*   200 */   305,  305,  305,  305,  305, 1148, 1182,  541, 1184,  380,
 /*   210 */  1070,  148,  380, 1148, 1148, 1193,  380, 1032,  541,  541,
 /*   220 */   541,  541, 1032,  541, 1140,  528, 1204,  380,  261,  380,
 /*   230 */   528, 1283,  541, 1076, 1032,  541,  541, 1076, 1032,  541,
 /*   240 */   541,  305, 1079, 1169, 1076, 1088, 1092, 1105,  939, 1113,
 /*   250 */   528, 1319, 1097, 1112, 1102, 1097, 1112, 1097, 1112, 1263,
 /*   260 */  1078,  541,  696, 1148,  380, 1322, 1182, 2436, 2436, 2436,
 /*   270 */  2436, 2436, 2436, 2436,  348, 1712,  132,  579,  472,   16,
 /*   280 */   663,  639,  743,  389,  757,  704,  839,  839,  839,  839,
 /*   290 */   839,  839,  839,  839,  843,  568,   25,   25,   61,  212,
 /*   300 */   433,  481,  603,  378,  297,  150,  483,  483,  483,  483,
 /*   310 */    45,  887,  774,  806,  910,  917,  811, 1046, 1069,  720,
 /*   320 */   707,  930,  973, 1045, 1047, 1050, 1053, 1074,  894,  832,
 /*   330 */   625,  391, 1096,  829,  863,  884, 1098, 1038, 1085, 1100,
 /*   340 */  1104, 1106, 1107, 1108,  993,  897, 1127, 1364, 1202, 1384,
 /*   350 */  1390, 1355, 1398, 1324, 1400, 1366, 1218, 1369, 1370, 1371,
 /*   360 */  1223, 1410, 1376, 1377, 1228, 1414, 1230, 1416, 1382, 1418,
 /*   370 */  1399, 1422, 1388, 1435, 1352, 1276, 1275, 1281, 1285, 1449,
 /*   380 */  1451, 1291, 1293, 1454, 1456, 1411, 1458, 1459, 1461, 1320,
 /*   390 */  1463, 1466, 1467, 1468, 1469, 1332, 1437, 1474, 1336, 1476,
 /*   400 */  1477, 1479, 1481, 1484, 1485, 1486, 1488, 1490, 1497, 1499,
 /*   410 */  1500, 1502, 1503, 1462, 1507, 1508, 1515, 1523, 1524, 1526,
 /*   420 */  1496, 1519, 1520, 1521, 1527, 1528, 1473, 1533, 1534, 1493,
 /*   430 */  1498, 1495, 1522, 1501, 1525, 1504, 1540, 1505, 1509, 1542,
 /*   440 */  1543, 1544, 1510, 1395, 1546, 1552, 1553, 1512, 1554, 1555,
 /*   450 */  1535, 1511, 1517, 1560, 1536, 1529, 1539, 1575, 1545, 1532,
 /*   460 */  1547, 1581, 1548, 1538, 1549, 1587, 1589, 1590, 1592, 1530,
 /*   470 */  1531, 1558, 1572, 1595, 1561, 1562, 1563, 1565, 1559, 1568,
 /*   480 */  1566, 1577, 1586, 1591, 1624, 1603, 1628, 1607, 1582, 1630,
 /*   490 */  1611, 1601, 1635, 1602, 1638, 1604, 1640, 1620, 1625, 1644,
 /*   500 */  1537, 1612, 1646, 1478, 1626, 1550, 1513, 1650, 1651, 1556,
 /*   510 */  1541, 1652, 1653, 1654, 1571, 1576, 1489, 1656, 1573, 1557,
 /*   520 */  1593, 1673, 1636, 1551, 1594, 1580, 1634, 1639, 1453, 1599,
 /*   530 */  1605, 1608, 1606, 1609, 1613, 1642, 1615, 1621, 1622, 1637,
 /*   540 */  1619, 1655, 1641, 1663, 1645, 1667, 1514, 1627, 1629, 1677,
 /*   550 */  1516, 1681, 1679, 1684, 1658, 1683, 1569, 1659, 1696, 1705,
 /*   560 */  1717, 1718, 1719, 1720, 1659, 1754, 1735, 1570, 1715, 1676,
 /*   570 */  1685, 1687, 1688, 1690, 1691, 1723, 1697, 1698, 1726, 1739,
 /*   580 */  1584, 1699, 1689, 1700, 1751, 1753, 1706, 1704, 1758, 1716,
 /*   590 */  1711, 1766, 1721, 1722, 1767, 1724, 1725, 1774, 1728, 1707,
 /*   600 */  1709, 1713, 1714, 1792, 1736, 1745, 1749, 1785, 1750, 1798,
 /*   610 */  1798, 1822, 1794, 1786, 1818, 1789, 1776, 1816, 1827, 1829,
 /*   620 */  1830, 1834, 1835, 1850, 1838, 1839, 1808, 1559, 1842, 1568,
 /*   630 */  1843, 1844, 1845, 1846, 1847, 1848, 1849, 1876, 1852, 1854,
 /*   640 */  1851, 1888, 1856, 1855, 1853, 1889, 1859, 1857, 1858, 1895,
 /*   650 */  1861, 1862, 1864, 1905, 1871, 1873, 1910, 1891, 1890, 1893,
 /*   660 */  1894, 1896, 1898,
};
#define YY_REDUCE_COUNT (273)
#define YY_REDUCE_MIN   (-354)
#define YY_REDUCE_MAX   (2099)
static const short yy_reduce_ofst[] = {
 /*     0 */   -29, -221,  289,   34,  709, -113,  546,  780,  876,  937,
 /*    10 */   990, 1042, 1095, 1109, 1162, 1180, 1232, 1274, 1284, 1334,
 /*    20 */  1386, 1403, 1494, 1506, 1518, 1600, 1614, 1664, 1680, 1733,
 /*    30 */  1747, 1799, 1817, 1841, 1899, 1922, 1979, 1991, 2005, 2057,
 /*    40 */  2075, 2099, -219,  711, -250, -207,  593,  731,  820,  726,
 /*    50 */   828, -218,  382,  446,  502, -208,  580, -261, -257, -354,
 /*    60 */  -234, -182,  -11, -138,  218,  323,  404,  548,  662,  664,
 /*    70 */   670,  672,  102,  730,  734,  735, -292,  153,  738,  756,
 /*    80 */  -275, -215,  771,  219,  -39,  267,  855, -246,   49, -201,
 /*    90 */  -201, -201, -187,  -31, -152, -132,    2,  205,  286,  336,
 /*   100 */   372,  402,  403,  441,  542,  552,  569,  571,  624,  627,
 /*   110 */   630,  635,  636,   20,   31,  -71,   71, -264,  136, -194,
 /*   120 */   331,  340,  368,  243,  303,  453,  230,  431,  -47,  388,
 /*   130 */   512,  537,  556,  471,  430,  511,  586,  613,  681,  682,
 /*   140 */   683,  638,  759,  745,  645,  716,  760,  701,  727,  807,
 /*   150 */   807,  870,  834,  824,  814,  801,  801,  801,  809,  788,
 /*   160 */   789,  791,  810,  807,  874,  844,  906,  851,  907,  866,
 /*   170 */   919,  921,  883,  893,  895,  932,  934,  941,  944,  891,
 /*   180 */   945,  915,  947,  904,  905,  950,  908,  954,  920,  956,
 /*   190 */   958,  963,  960,  974,  949,  951,  957,  961,  964,  965,
 /*   200 */   967,  968,  969,  970,  971,  976,  980,  959,  912,  978,
 /*   210 */   940,  972,  991,  995,  996,  981,  997,  975,  987,  988,
 /*   220 */   989,  998,  982,  999,  986, 1002,  992, 1007, 1019, 1034,
 /*   230 */  1009,  979, 1006,  952, 1001, 1008, 1013,  953, 1003, 1018,
 /*   240 */  1020,  807,  966,  983,  977,  984,  994,  985, 1014,  801,
 /*   250 */  1052, 1021, 1011, 1000, 1015, 1012, 1022, 1016, 1026, 1023,
 /*   260 */  1061, 1057, 1081, 1086, 1090, 1099, 1101, 1044, 1051, 1083,
 /*   270 */  1089, 1110, 1111, 1114,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*    10 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*    20 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*    30 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*    40 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*    50 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*    60 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*    70 */  1453, 1453, 1526, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*    80 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1524, 1679, 1453,
 /*    90 */  1856, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   100 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   110 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1526, 1453, 1524,
 /*   120 */  1868, 1868, 1868, 1453, 1453, 1453, 1723, 1723, 1453, 1453,
 /*   130 */  1453, 1453, 1622, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   140 */  1453, 1715, 1453, 1453, 1937, 1453, 1453, 1721, 1891, 1453,
 /*   150 */  1453, 1453, 1453, 1575, 1883, 1860, 1874, 1861, 1858, 1922,
 /*   160 */  1922, 1922, 1877, 1453, 1591, 1887, 1453, 1453, 1453, 1707,
 /*   170 */  1453, 1453, 1684, 1681, 1681, 1453, 1453, 1453, 1453, 1453,
 /*   180 */  1526, 1453, 1526, 1453, 1453, 1526, 1453, 1526, 1453, 1526,
 /*   190 */  1526, 1453, 1526, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   200 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1524,
 /*   210 */  1717, 1453, 1524, 1453, 1453, 1453, 1524, 1896, 1453, 1453,
 /*   220 */  1453, 1453, 1896, 1453, 1453, 1453, 1453, 1524, 1453, 1524,
 /*   230 */  1453, 1453, 1453, 1898, 1896, 1453, 1453, 1898, 1896, 1453,
 /*   240 */  1453, 1453, 1910, 1906, 1898, 1914, 1912, 1889, 1887, 1874,
 /*   250 */  1453, 1453, 1928, 1924, 1940, 1928, 1924, 1928, 1924, 1453,
 /*   260 */  1591, 1453, 1453, 1453, 1524, 1485, 1453, 1709, 1723, 1625,
 /*   270 */  1625, 1625, 1527, 1458, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   280 */  1453, 1453, 1453, 1453, 1453, 1453, 1794, 1909, 1908, 1832,
 /*   290 */  1831, 1830, 1828, 1793, 1453, 1587, 1792, 1791, 1453, 1453,
 /*   300 */  1453, 1453, 1453, 1453, 1453, 1453, 1785, 1786, 1784, 1783,
 /*   310 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   320 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1857, 1453,
 /*   330 */  1925, 1929, 1453, 1453, 1453, 1453, 1453, 1768, 1453, 1453,
 /*   340 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   350 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   360 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   370 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   380 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   390 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   400 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   410 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   420 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   430 */  1453, 1490, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   440 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   450 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   460 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   470 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1556, 1555,
 /*   480 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   490 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   500 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   510 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1727, 1453, 1453,
 /*   520 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1890, 1453, 1453,
 /*   530 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   540 */  1453, 1453, 1453, 1768, 1453, 1907, 1453, 1867, 1863, 1453,
 /*   550 */  1453, 1859, 1767, 1453, 1453, 1923, 1453, 1453, 1453, 1453,
 /*   560 */  1453, 1453, 1453, 1453, 1453, 1852, 1453, 1453, 1825, 1810,
 /*   570 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   580 */  1779, 1453, 1453, 1453, 1453, 1453, 1619, 1453, 1453, 1453,
 /*   590 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1604,
 /*   600 */  1602, 1601, 1600, 1453, 1597, 1453, 1453, 1453, 1453, 1628,
 /*   610 */  1627, 1453, 1453, 1453, 1453, 1453, 1453, 1547, 1453, 1453,
 /*   620 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1538, 1453, 1537,
 /*   630 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   640 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   650 */  1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453, 1453,
 /*   660 */  1453, 1453, 1453,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /* CACHELASTSIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  248,  /*  NK_BITNOT => ID */
  248,  /*     VALUES => ID */
  248,  /*     IMPORT => ID */
  248,  /*    NK_SEMI => ID */
  248,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "NK_COMMA",
  /*   44 */ "READ",
  /*   45 */ "WRITE",
  /*   46 */ "NK_DOT",
  /*   47 */ "DNODE",
  /*   48 */ "PORT",
  /*   49 */ "DNODES",
  /*   50 */ "NK_IPTOKEN",
  /*   51 */ "LOCAL",
  /*   52 */ "QNODE",
  /*   53 */ "BNODE",
  /*   54 */ "SNODE",
  /*   55 */ "MNODE",
  /*   56 */ "DATABASE",
  /*   57 */ "USE",
  /*   58 */ "FLUSH",
  /*   59 */ "IF",
  /*   60 */ "NOT",
  /*   61 */ "EXISTS",
  /*   62 */ "BUFFER",
  /*   63 */ "CACHELAST",
  /*   64 */ "CACHELASTSIZE",
  /*   65 */ "COMP",
  /*   66 */ "DURATION",
  /*   67 */ "NK_VARIABLE",
  /*   68 */ "FSYNC",
  /*   69 */ "MAXROWS",
  /*   70 */ "MINROWS",
  /*   71 */ "KEEP",
  /*   72 */ "PAGES",
  /*   73 */ "PAGESIZE",
  /*   74 */ "PRECISION",
  /*   75 */ "REPLICA",
  /*   76 */ "STRICT",
  /*   77 */ "WAL",
  /*   78 */ "VGROUPS",
  /*   79 */ "SINGLE_STABLE",
  /*   80 */ "RETENTIONS",
  /*   81 */ "SCHEMALESS",
  /*   82 */ "NK_COLON",
  /*   83 */ "TABLE",
  /*   84 */ "NK_LP",
  /*   85 */ "NK_RP",
  /*   86 */ "STABLE",
  /*   87 */ "ADD",
  /*   88 */ "COLUMN",
  /*   89 */ "MODIFY",
  /*   90 */ "RENAME",
  /*   91 */ "TAG",
  /*   92 */ "SET",
  /*   93 */ "NK_EQ",
  /*   94 */ "USING",
  /*   95 */ "TAGS",
  /*   96 */ "COMMENT",
  /*   97 */ "BOOL",
  /*   98 */ "TINYINT",
  /*   99 */ "SMALLINT",
  /*  100 */ "INT",
  /*  101 */ "INTEGER",
  /*  102 */ "BIGINT",
  /*  103 */ "FLOAT",
  /*  104 */ "DOUBLE",
  /*  105 */ "BINARY",
  /*  106 */ "TIMESTAMP",
  /*  107 */ "NCHAR",
  /*  108 */ "UNSIGNED",
  /*  109 */ "JSON",
  /*  110 */ "VARCHAR",
  /*  111 */ "MEDIUMBLOB",
  /*  112 */ "BLOB",
  /*  113 */ "VARBINARY",
  /*  114 */ "DECIMAL",
  /*  115 */ "MAX_DELAY",
  /*  116 */ "WATERMARK",
  /*  117 */ "ROLLUP",
  /*  118 */ "TTL",
  /*  119 */ "SMA",
  /*  120 */ "FIRST",
  /*  121 */ "LAST",
  /*  122 */ "SHOW",
  /*  123 */ "DATABASES",
  /*  124 */ "TABLES",
  /*  125 */ "STABLES",
  /*  126 */ "MNODES",
  /*  127 */ "MODULES",
  /*  128 */ "QNODES",
  /*  129 */ "FUNCTIONS",
  /*  130 */ "INDEXES",
  /*  131 */ "ACCOUNTS",
  /*  132 */ "APPS",
  /*  133 */ "CONNECTIONS",
  /*  134 */ "LICENCE",
  /*  135 */ "GRANTS",
  /*  136 */ "QUERIES",
  /*  137 */ "SCORES",
  /*  138 */ "TOPICS",
  /*  139 */ "VARIABLES",
  /*  140 */ "BNODES",
  /*  141 */ "SNODES",
  /*  142 */ "CLUSTER",
  /*  143 */ "TRANSACTIONS",
  /*  144 */ "DISTRIBUTED",
  /*  145 */ "CONSUMERS",
  /*  146 */ "SUBSCRIPTIONS",
  /*  147 */ "LIKE",
  /*  148 */ "INDEX",
  /*  149 */ "FUNCTION",
  /*  150 */ "INTERVAL",
  /*  151 */ "TOPIC",
  /*  152 */ "AS",
  /*  153 */ "WITH",
  /*  154 */ "META",
  /*  155 */ "CONSUMER",
  /*  156 */ "GROUP",
  /*  157 */ "DESC",
  /*  158 */ "DESCRIBE",
  /*  159 */ "RESET",
  /*  160 */ "QUERY",
  /*  161 */ "CACHE",
  /*  162 */ "EXPLAIN",
  /*  163 */ "ANALYZE",
  /*  164 */ "VERBOSE",
  /*  165 */ "NK_BOOL",
  /*  166 */ "RATIO",
  /*  167 */ "NK_FLOAT",
  /*  168 */ "COMPACT",
  /*  169 */ "VNODES",
  /*  170 */ "IN",
  /*  171 */ "OUTPUTTYPE",
  /*  172 */ "AGGREGATE",
  /*  173 */ "BUFSIZE",
  /*  174 */ "STREAM",
  /*  175 */ "INTO",
  /*  176 */ "TRIGGER",
  /*  177 */ "AT_ONCE",
  /*  178 */ "WINDOW_CLOSE",
  /*  179 */ "IGNORE",
  /*  180 */ "EXPIRED",
  /*  181 */ "KILL",
  /*  182 */ "CONNECTION",
  /*  183 */ "TRANSACTION",
  /*  184 */ "BALANCE",
  /*  185 */ "VGROUP",
  /*  186 */ "MERGE",
  /*  187 */ "REDISTRIBUTE",
  /*  188 */ "SPLIT",
  /*  189 */ "SYNCDB",
  /*  190 */ "DELETE",
  /*  191 */ "INSERT",
  /*  192 */ "NULL",
  /*  193 */ "NK_QUESTION",
  /*  194 */ "NK_ARROW",
  /*  195 */ "ROWTS",
  /*  196 */ "TBNAME",
  /*  197 */ "QSTARTTS",
  /*  198 */ "QENDTS",
  /*  199 */ "WSTARTTS",
  /*  200 */ "WENDTS",
  /*  201 */ "WDURATION",
  /*  202 */ "CAST",
  /*  203 */ "NOW",
  /*  204 */ "TODAY",
  /*  205 */ "TIMEZONE",
  /*  206 */ "CLIENT_VERSION",
  /*  207 */ "SERVER_VERSION",
  /*  208 */ "SERVER_STATUS",
  /*  209 */ "CURRENT_USER",
  /*  210 */ "COUNT",
  /*  211 */ "LAST_ROW",
  /*  212 */ "BETWEEN",
  /*  213 */ "IS",
  /*  214 */ "NK_LT",
  /*  215 */ "NK_GT",
  /*  216 */ "NK_LE",
  /*  217 */ "NK_GE",
  /*  218 */ "NK_NE",
  /*  219 */ "MATCH",
  /*  220 */ "NMATCH",
  /*  221 */ "CONTAINS",
  /*  222 */ "JOIN",
  /*  223 */ "INNER",
  /*  224 */ "SELECT",
  /*  225 */ "DISTINCT",
  /*  226 */ "WHERE",
  /*  227 */ "PARTITION",
  /*  228 */ "BY",
  /*  229 */ "SESSION",
  /*  230 */ "STATE_WINDOW",
  /*  231 */ "SLIDING",
  /*  232 */ "FILL",
  /*  233 */ "VALUE",
  /*  234 */ "NONE",
  /*  235 */ "PREV",
  /*  236 */ "LINEAR",
  /*  237 */ "NEXT",
  /*  238 */ "HAVING",
  /*  239 */ "RANGE",
  /*  240 */ "EVERY",
  /*  241 */ "ORDER",
  /*  242 */ "SLIMIT",
  /*  243 */ "SOFFSET",
  /*  244 */ "LIMIT",
  /*  245 */ "OFFSET",
  /*  246 */ "ASC",
  /*  247 */ "NULLS",
  /*  248 */ "ID",
  /*  249 */ "NK_BITNOT",
  /*  250 */ "VALUES",
  /*  251 */ "IMPORT",
  /*  252 */ "NK_SEMI",
  /*  253 */ "FILE",
  /*  254 */ "cmd",
  /*  255 */ "account_options",
  /*  256 */ "alter_account_options",
  /*  257 */ "literal",
  /*  258 */ "alter_account_option",
  /*  259 */ "user_name",
  /*  260 */ "sysinfo_opt",
  /*  261 */ "privileges",
  /*  262 */ "priv_level",
  /*  263 */ "priv_type_list",
  /*  264 */ "priv_type",
  /*  265 */ "db_name",
  /*  266 */ "dnode_endpoint",
  /*  267 */ "not_exists_opt",
  /*  268 */ "db_options",
  /*  269 */ "exists_opt",
  /*  270 */ "alter_db_options",
  /*  271 */ "integer_list",
  /*  272 */ "variable_list",
  /*  273 */ "retention_list",
  /*  274 */ "alter_db_option",
  /*  275 */ "retention",
  /*  276 */ "full_table_name",
  /*  277 */ "column_def_list",
  /*  278 */ "tags_def_opt",
  /*  279 */ "table_options",
  /*  280 */ "multi_create_clause",
  /*  281 */ "tags_def",
  /*  282 */ "multi_drop_clause",
  /*  283 */ "alter_table_clause",
  /*  284 */ "alter_table_options",
  /*  285 */ "column_name",
  /*  286 */ "type_name",
  /*  287 */ "signed_literal",
  /*  288 */ "create_subtable_clause",
  /*  289 */ "specific_cols_opt",
  /*  290 */ "expression_list",
  /*  291 */ "drop_table_clause",
  /*  292 */ "col_name_list",
  /*  293 */ "table_name",
  /*  294 */ "column_def",
  /*  295 */ "duration_list",
  /*  296 */ "rollup_func_list",
  /*  297 */ "alter_table_option",
  /*  298 */ "duration_literal",
  /*  299 */ "rollup_func_name",
  /*  300 */ "function_name",
  /*  301 */ "col_name",
  /*  302 */ "db_name_cond_opt",
  /*  303 */ "like_pattern_opt",
  /*  304 */ "table_name_cond",
  /*  305 */ "from_db_opt",
  /*  306 */ "index_name",
  /*  307 */ "index_options",
  /*  308 */ "func_list",
  /*  309 */ "sliding_opt",
  /*  310 */ "sma_stream_opt",
  /*  311 */ "func",
  /*  312 */ "stream_options",
  /*  313 */ "topic_name",
  /*  314 */ "query_expression",
  /*  315 */ "cgroup_name",
  /*  316 */ "analyze_opt",
  /*  317 */ "explain_options",
  /*  318 */ "agg_func_opt",
  /*  319 */ "bufsize_opt",
  /*  320 */ "stream_name",
  /*  321 */ "into_opt",
  /*  322 */ "dnode_list",
  /*  323 */ "where_clause_opt",
  /*  324 */ "signed",
  /*  325 */ "literal_func",
  /*  326 */ "literal_list",
  /*  327 */ "table_alias",
  /*  328 */ "column_alias",
  /*  329 */ "expression",
  /*  330 */ "pseudo_column",
  /*  331 */ "column_reference",
  /*  332 */ "function_expression",
  /*  333 */ "subquery",
  /*  334 */ "star_func",
  /*  335 */ "star_func_para_list",
  /*  336 */ "noarg_func",
  /*  337 */ "other_para_list",
  /*  338 */ "star_func_para",
  /*  339 */ "predicate",
  /*  340 */ "compare_op",
  /*  341 */ "in_op",
  /*  342 */ "in_predicate_value",
  /*  343 */ "boolean_value_expression",
  /*  344 */ "boolean_primary",
  /*  345 */ "common_expression",
  /*  346 */ "from_clause_opt",
  /*  347 */ "table_reference_list",
  /*  348 */ "table_reference",
  /*  349 */ "table_primary",
  /*  350 */ "joined_table",
  /*  351 */ "alias_opt",
  /*  352 */ "parenthesized_joined_table",
  /*  353 */ "join_type",
  /*  354 */ "search_condition",
  /*  355 */ "query_specification",
  /*  356 */ "set_quantifier_opt",
  /*  357 */ "select_list",
  /*  358 */ "partition_by_clause_opt",
  /*  359 */ "range_opt",
  /*  360 */ "every_opt",
  /*  361 */ "fill_opt",
  /*  362 */ "twindow_clause_opt",
  /*  363 */ "group_by_clause_opt",
  /*  364 */ "having_clause_opt",
  /*  365 */ "select_item",
  /*  366 */ "fill_mode",
  /*  367 */ "group_by_list",
  /*  368 */ "query_expression_body",
  /*  369 */ "order_by_clause_opt",
  /*  370 */ "slimit_clause_opt",
  /*  371 */ "limit_clause_opt",
  /*  372 */ "query_primary",
  /*  373 */ "sort_specification_list",
  /*  374 */ "sort_specification",
  /*  375 */ "ordering_specification_opt",
  /*  376 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "priv_type_list ::= priv_type",
 /*  36 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  37 */ "priv_type ::= READ",
 /*  38 */ "priv_type ::= WRITE",
 /*  39 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  40 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  41 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  42 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  43 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  45 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  46 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  47 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  48 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  49 */ "dnode_endpoint ::= NK_STRING",
 /*  50 */ "dnode_endpoint ::= NK_ID",
 /*  51 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  52 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  53 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  54 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  63 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  64 */ "cmd ::= USE db_name",
 /*  65 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  66 */ "cmd ::= FLUSH DATABASE db_name",
 /*  67 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  68 */ "not_exists_opt ::=",
 /*  69 */ "exists_opt ::= IF EXISTS",
 /*  70 */ "exists_opt ::=",
 /*  71 */ "db_options ::=",
 /*  72 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  73 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  74 */ "db_options ::= db_options CACHELASTSIZE NK_INTEGER",
 /*  75 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  76 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  77 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  78 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  79 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  80 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  81 */ "db_options ::= db_options KEEP integer_list",
 /*  82 */ "db_options ::= db_options KEEP variable_list",
 /*  83 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  84 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  85 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  86 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  87 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  88 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  89 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  90 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  91 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  92 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  93 */ "alter_db_options ::= alter_db_option",
 /*  94 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  95 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  96 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  97 */ "alter_db_option ::= CACHELASTSIZE NK_INTEGER",
 /*  98 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  99 */ "alter_db_option ::= KEEP integer_list",
 /* 100 */ "alter_db_option ::= KEEP variable_list",
 /* 101 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 102 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 103 */ "alter_db_option ::= STRICT NK_INTEGER",
 /* 104 */ "alter_db_option ::= WAL NK_INTEGER",
 /* 105 */ "integer_list ::= NK_INTEGER",
 /* 106 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 107 */ "variable_list ::= NK_VARIABLE",
 /* 108 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 109 */ "retention_list ::= retention",
 /* 110 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 111 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 112 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 113 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 114 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 115 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 116 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 117 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 118 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 119 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 120 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 121 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 122 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 123 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 124 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 125 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 126 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 127 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 128 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 129 */ "multi_create_clause ::= create_subtable_clause",
 /* 130 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 131 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 132 */ "multi_drop_clause ::= drop_table_clause",
 /* 133 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 134 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 135 */ "specific_cols_opt ::=",
 /* 136 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 137 */ "full_table_name ::= table_name",
 /* 138 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 139 */ "column_def_list ::= column_def",
 /* 140 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 141 */ "column_def ::= column_name type_name",
 /* 142 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 143 */ "type_name ::= BOOL",
 /* 144 */ "type_name ::= TINYINT",
 /* 145 */ "type_name ::= SMALLINT",
 /* 146 */ "type_name ::= INT",
 /* 147 */ "type_name ::= INTEGER",
 /* 148 */ "type_name ::= BIGINT",
 /* 149 */ "type_name ::= FLOAT",
 /* 150 */ "type_name ::= DOUBLE",
 /* 151 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 152 */ "type_name ::= TIMESTAMP",
 /* 153 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 154 */ "type_name ::= TINYINT UNSIGNED",
 /* 155 */ "type_name ::= SMALLINT UNSIGNED",
 /* 156 */ "type_name ::= INT UNSIGNED",
 /* 157 */ "type_name ::= BIGINT UNSIGNED",
 /* 158 */ "type_name ::= JSON",
 /* 159 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 160 */ "type_name ::= MEDIUMBLOB",
 /* 161 */ "type_name ::= BLOB",
 /* 162 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 163 */ "type_name ::= DECIMAL",
 /* 164 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 165 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 166 */ "tags_def_opt ::=",
 /* 167 */ "tags_def_opt ::= tags_def",
 /* 168 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 169 */ "table_options ::=",
 /* 170 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 171 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 172 */ "table_options ::= table_options WATERMARK duration_list",
 /* 173 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 174 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 175 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 176 */ "alter_table_options ::= alter_table_option",
 /* 177 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 178 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 179 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 180 */ "duration_list ::= duration_literal",
 /* 181 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 182 */ "rollup_func_list ::= rollup_func_name",
 /* 183 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 184 */ "rollup_func_name ::= function_name",
 /* 185 */ "rollup_func_name ::= FIRST",
 /* 186 */ "rollup_func_name ::= LAST",
 /* 187 */ "col_name_list ::= col_name",
 /* 188 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 189 */ "col_name ::= column_name",
 /* 190 */ "cmd ::= SHOW DNODES",
 /* 191 */ "cmd ::= SHOW USERS",
 /* 192 */ "cmd ::= SHOW DATABASES",
 /* 193 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 194 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 195 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 196 */ "cmd ::= SHOW MNODES",
 /* 197 */ "cmd ::= SHOW MODULES",
 /* 198 */ "cmd ::= SHOW QNODES",
 /* 199 */ "cmd ::= SHOW FUNCTIONS",
 /* 200 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 201 */ "cmd ::= SHOW STREAMS",
 /* 202 */ "cmd ::= SHOW ACCOUNTS",
 /* 203 */ "cmd ::= SHOW APPS",
 /* 204 */ "cmd ::= SHOW CONNECTIONS",
 /* 205 */ "cmd ::= SHOW LICENCE",
 /* 206 */ "cmd ::= SHOW GRANTS",
 /* 207 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 208 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 209 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 210 */ "cmd ::= SHOW QUERIES",
 /* 211 */ "cmd ::= SHOW SCORES",
 /* 212 */ "cmd ::= SHOW TOPICS",
 /* 213 */ "cmd ::= SHOW VARIABLES",
 /* 214 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 215 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES",
 /* 216 */ "cmd ::= SHOW BNODES",
 /* 217 */ "cmd ::= SHOW SNODES",
 /* 218 */ "cmd ::= SHOW CLUSTER",
 /* 219 */ "cmd ::= SHOW TRANSACTIONS",
 /* 220 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 221 */ "cmd ::= SHOW CONSUMERS",
 /* 222 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 223 */ "db_name_cond_opt ::=",
 /* 224 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 225 */ "like_pattern_opt ::=",
 /* 226 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 227 */ "table_name_cond ::= table_name",
 /* 228 */ "from_db_opt ::=",
 /* 229 */ "from_db_opt ::= FROM db_name",
 /* 230 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 231 */ "cmd ::= DROP INDEX exists_opt index_name",
 /* 232 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 233 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 234 */ "func_list ::= func",
 /* 235 */ "func_list ::= func_list NK_COMMA func",
 /* 236 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 237 */ "sma_stream_opt ::=",
 /* 238 */ "sma_stream_opt ::= stream_options WATERMARK duration_literal",
 /* 239 */ "sma_stream_opt ::= stream_options MAX_DELAY duration_literal",
 /* 240 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 241 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 242 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 243 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 244 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 245 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 246 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 247 */ "cmd ::= DESC full_table_name",
 /* 248 */ "cmd ::= DESCRIBE full_table_name",
 /* 249 */ "cmd ::= RESET QUERY CACHE",
 /* 250 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 251 */ "analyze_opt ::=",
 /* 252 */ "analyze_opt ::= ANALYZE",
 /* 253 */ "explain_options ::=",
 /* 254 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 255 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 256 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 257 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 258 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 259 */ "agg_func_opt ::=",
 /* 260 */ "agg_func_opt ::= AGGREGATE",
 /* 261 */ "bufsize_opt ::=",
 /* 262 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 263 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 264 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 265 */ "into_opt ::=",
 /* 266 */ "into_opt ::= INTO full_table_name",
 /* 267 */ "stream_options ::=",
 /* 268 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 269 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 270 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 271 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 272 */ "stream_options ::= stream_options IGNORE EXPIRED",
 /* 273 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 274 */ "cmd ::= KILL QUERY NK_STRING",
 /* 275 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 276 */ "cmd ::= BALANCE VGROUP",
 /* 277 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 278 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 279 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 280 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 281 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 282 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 283 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 284 */ "cmd ::= query_expression",
 /* 285 */ "cmd ::= INSERT INTO full_table_name specific_cols_opt query_expression",
 /* 286 */ "literal ::= NK_INTEGER",
 /* 287 */ "literal ::= NK_FLOAT",
 /* 288 */ "literal ::= NK_STRING",
 /* 289 */ "literal ::= NK_BOOL",
 /* 290 */ "literal ::= TIMESTAMP NK_STRING",
 /* 291 */ "literal ::= duration_literal",
 /* 292 */ "literal ::= NULL",
 /* 293 */ "literal ::= NK_QUESTION",
 /* 294 */ "duration_literal ::= NK_VARIABLE",
 /* 295 */ "signed ::= NK_INTEGER",
 /* 296 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 297 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 298 */ "signed ::= NK_FLOAT",
 /* 299 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 300 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 301 */ "signed_literal ::= signed",
 /* 302 */ "signed_literal ::= NK_STRING",
 /* 303 */ "signed_literal ::= NK_BOOL",
 /* 304 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 305 */ "signed_literal ::= duration_literal",
 /* 306 */ "signed_literal ::= NULL",
 /* 307 */ "signed_literal ::= literal_func",
 /* 308 */ "literal_list ::= signed_literal",
 /* 309 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 310 */ "db_name ::= NK_ID",
 /* 311 */ "table_name ::= NK_ID",
 /* 312 */ "column_name ::= NK_ID",
 /* 313 */ "function_name ::= NK_ID",
 /* 314 */ "table_alias ::= NK_ID",
 /* 315 */ "column_alias ::= NK_ID",
 /* 316 */ "user_name ::= NK_ID",
 /* 317 */ "index_name ::= NK_ID",
 /* 318 */ "topic_name ::= NK_ID",
 /* 319 */ "stream_name ::= NK_ID",
 /* 320 */ "cgroup_name ::= NK_ID",
 /* 321 */ "expression ::= literal",
 /* 322 */ "expression ::= pseudo_column",
 /* 323 */ "expression ::= column_reference",
 /* 324 */ "expression ::= function_expression",
 /* 325 */ "expression ::= subquery",
 /* 326 */ "expression ::= NK_LP expression NK_RP",
 /* 327 */ "expression ::= NK_PLUS expression",
 /* 328 */ "expression ::= NK_MINUS expression",
 /* 329 */ "expression ::= expression NK_PLUS expression",
 /* 330 */ "expression ::= expression NK_MINUS expression",
 /* 331 */ "expression ::= expression NK_STAR expression",
 /* 332 */ "expression ::= expression NK_SLASH expression",
 /* 333 */ "expression ::= expression NK_REM expression",
 /* 334 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 335 */ "expression ::= expression NK_BITAND expression",
 /* 336 */ "expression ::= expression NK_BITOR expression",
 /* 337 */ "expression_list ::= expression",
 /* 338 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 339 */ "column_reference ::= column_name",
 /* 340 */ "column_reference ::= table_name NK_DOT column_name",
 /* 341 */ "pseudo_column ::= ROWTS",
 /* 342 */ "pseudo_column ::= TBNAME",
 /* 343 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 344 */ "pseudo_column ::= QSTARTTS",
 /* 345 */ "pseudo_column ::= QENDTS",
 /* 346 */ "pseudo_column ::= WSTARTTS",
 /* 347 */ "pseudo_column ::= WENDTS",
 /* 348 */ "pseudo_column ::= WDURATION",
 /* 349 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 350 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 351 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 352 */ "function_expression ::= literal_func",
 /* 353 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 354 */ "literal_func ::= NOW",
 /* 355 */ "noarg_func ::= NOW",
 /* 356 */ "noarg_func ::= TODAY",
 /* 357 */ "noarg_func ::= TIMEZONE",
 /* 358 */ "noarg_func ::= DATABASE",
 /* 359 */ "noarg_func ::= CLIENT_VERSION",
 /* 360 */ "noarg_func ::= SERVER_VERSION",
 /* 361 */ "noarg_func ::= SERVER_STATUS",
 /* 362 */ "noarg_func ::= CURRENT_USER",
 /* 363 */ "noarg_func ::= USER",
 /* 364 */ "star_func ::= COUNT",
 /* 365 */ "star_func ::= FIRST",
 /* 366 */ "star_func ::= LAST",
 /* 367 */ "star_func ::= LAST_ROW",
 /* 368 */ "star_func_para_list ::= NK_STAR",
 /* 369 */ "star_func_para_list ::= other_para_list",
 /* 370 */ "other_para_list ::= star_func_para",
 /* 371 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 372 */ "star_func_para ::= expression",
 /* 373 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 374 */ "predicate ::= expression compare_op expression",
 /* 375 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 376 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 377 */ "predicate ::= expression IS NULL",
 /* 378 */ "predicate ::= expression IS NOT NULL",
 /* 379 */ "predicate ::= expression in_op in_predicate_value",
 /* 380 */ "compare_op ::= NK_LT",
 /* 381 */ "compare_op ::= NK_GT",
 /* 382 */ "compare_op ::= NK_LE",
 /* 383 */ "compare_op ::= NK_GE",
 /* 384 */ "compare_op ::= NK_NE",
 /* 385 */ "compare_op ::= NK_EQ",
 /* 386 */ "compare_op ::= LIKE",
 /* 387 */ "compare_op ::= NOT LIKE",
 /* 388 */ "compare_op ::= MATCH",
 /* 389 */ "compare_op ::= NMATCH",
 /* 390 */ "compare_op ::= CONTAINS",
 /* 391 */ "in_op ::= IN",
 /* 392 */ "in_op ::= NOT IN",
 /* 393 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 394 */ "boolean_value_expression ::= boolean_primary",
 /* 395 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 396 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 397 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 398 */ "boolean_primary ::= predicate",
 /* 399 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 400 */ "common_expression ::= expression",
 /* 401 */ "common_expression ::= boolean_value_expression",
 /* 402 */ "from_clause_opt ::=",
 /* 403 */ "from_clause_opt ::= FROM table_reference_list",
 /* 404 */ "table_reference_list ::= table_reference",
 /* 405 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 406 */ "table_reference ::= table_primary",
 /* 407 */ "table_reference ::= joined_table",
 /* 408 */ "table_primary ::= table_name alias_opt",
 /* 409 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 410 */ "table_primary ::= subquery alias_opt",
 /* 411 */ "table_primary ::= parenthesized_joined_table",
 /* 412 */ "alias_opt ::=",
 /* 413 */ "alias_opt ::= table_alias",
 /* 414 */ "alias_opt ::= AS table_alias",
 /* 415 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 416 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 417 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 418 */ "join_type ::=",
 /* 419 */ "join_type ::= INNER",
 /* 420 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 421 */ "set_quantifier_opt ::=",
 /* 422 */ "set_quantifier_opt ::= DISTINCT",
 /* 423 */ "set_quantifier_opt ::= ALL",
 /* 424 */ "select_list ::= select_item",
 /* 425 */ "select_list ::= select_list NK_COMMA select_item",
 /* 426 */ "select_item ::= NK_STAR",
 /* 427 */ "select_item ::= common_expression",
 /* 428 */ "select_item ::= common_expression column_alias",
 /* 429 */ "select_item ::= common_expression AS column_alias",
 /* 430 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 431 */ "where_clause_opt ::=",
 /* 432 */ "where_clause_opt ::= WHERE search_condition",
 /* 433 */ "partition_by_clause_opt ::=",
 /* 434 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 435 */ "twindow_clause_opt ::=",
 /* 436 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 437 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 438 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 439 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 440 */ "sliding_opt ::=",
 /* 441 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 442 */ "fill_opt ::=",
 /* 443 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 444 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 445 */ "fill_mode ::= NONE",
 /* 446 */ "fill_mode ::= PREV",
 /* 447 */ "fill_mode ::= NULL",
 /* 448 */ "fill_mode ::= LINEAR",
 /* 449 */ "fill_mode ::= NEXT",
 /* 450 */ "group_by_clause_opt ::=",
 /* 451 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 452 */ "group_by_list ::= expression",
 /* 453 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 454 */ "having_clause_opt ::=",
 /* 455 */ "having_clause_opt ::= HAVING search_condition",
 /* 456 */ "range_opt ::=",
 /* 457 */ "range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP",
 /* 458 */ "every_opt ::=",
 /* 459 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 460 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 461 */ "query_expression_body ::= query_primary",
 /* 462 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 463 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 464 */ "query_primary ::= query_specification",
 /* 465 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 466 */ "order_by_clause_opt ::=",
 /* 467 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 468 */ "slimit_clause_opt ::=",
 /* 469 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 470 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 471 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 472 */ "limit_clause_opt ::=",
 /* 473 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 474 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 475 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 476 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 477 */ "search_condition ::= common_expression",
 /* 478 */ "sort_specification_list ::= sort_specification",
 /* 479 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 480 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 481 */ "ordering_specification_opt ::=",
 /* 482 */ "ordering_specification_opt ::= ASC",
 /* 483 */ "ordering_specification_opt ::= DESC",
 /* 484 */ "null_ordering_opt ::=",
 /* 485 */ "null_ordering_opt ::= NULLS FIRST",
 /* 486 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 254: /* cmd */
    case 257: /* literal */
    case 268: /* db_options */
    case 270: /* alter_db_options */
    case 275: /* retention */
    case 276: /* full_table_name */
    case 279: /* table_options */
    case 283: /* alter_table_clause */
    case 284: /* alter_table_options */
    case 287: /* signed_literal */
    case 288: /* create_subtable_clause */
    case 291: /* drop_table_clause */
    case 294: /* column_def */
    case 298: /* duration_literal */
    case 299: /* rollup_func_name */
    case 301: /* col_name */
    case 302: /* db_name_cond_opt */
    case 303: /* like_pattern_opt */
    case 304: /* table_name_cond */
    case 305: /* from_db_opt */
    case 307: /* index_options */
    case 309: /* sliding_opt */
    case 310: /* sma_stream_opt */
    case 311: /* func */
    case 312: /* stream_options */
    case 314: /* query_expression */
    case 317: /* explain_options */
    case 321: /* into_opt */
    case 323: /* where_clause_opt */
    case 324: /* signed */
    case 325: /* literal_func */
    case 329: /* expression */
    case 330: /* pseudo_column */
    case 331: /* column_reference */
    case 332: /* function_expression */
    case 333: /* subquery */
    case 338: /* star_func_para */
    case 339: /* predicate */
    case 342: /* in_predicate_value */
    case 343: /* boolean_value_expression */
    case 344: /* boolean_primary */
    case 345: /* common_expression */
    case 346: /* from_clause_opt */
    case 347: /* table_reference_list */
    case 348: /* table_reference */
    case 349: /* table_primary */
    case 350: /* joined_table */
    case 352: /* parenthesized_joined_table */
    case 354: /* search_condition */
    case 355: /* query_specification */
    case 359: /* range_opt */
    case 360: /* every_opt */
    case 361: /* fill_opt */
    case 362: /* twindow_clause_opt */
    case 364: /* having_clause_opt */
    case 365: /* select_item */
    case 368: /* query_expression_body */
    case 370: /* slimit_clause_opt */
    case 371: /* limit_clause_opt */
    case 372: /* query_primary */
    case 374: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy652)); 
}
      break;
    case 255: /* account_options */
    case 256: /* alter_account_options */
    case 258: /* alter_account_option */
    case 319: /* bufsize_opt */
{
 
}
      break;
    case 259: /* user_name */
    case 262: /* priv_level */
    case 265: /* db_name */
    case 266: /* dnode_endpoint */
    case 285: /* column_name */
    case 293: /* table_name */
    case 300: /* function_name */
    case 306: /* index_name */
    case 313: /* topic_name */
    case 315: /* cgroup_name */
    case 320: /* stream_name */
    case 327: /* table_alias */
    case 328: /* column_alias */
    case 334: /* star_func */
    case 336: /* noarg_func */
    case 351: /* alias_opt */
{
 
}
      break;
    case 260: /* sysinfo_opt */
{
 
}
      break;
    case 261: /* privileges */
    case 263: /* priv_type_list */
    case 264: /* priv_type */
{
 
}
      break;
    case 267: /* not_exists_opt */
    case 269: /* exists_opt */
    case 316: /* analyze_opt */
    case 318: /* agg_func_opt */
    case 356: /* set_quantifier_opt */
{
 
}
      break;
    case 271: /* integer_list */
    case 272: /* variable_list */
    case 273: /* retention_list */
    case 277: /* column_def_list */
    case 278: /* tags_def_opt */
    case 280: /* multi_create_clause */
    case 281: /* tags_def */
    case 282: /* multi_drop_clause */
    case 289: /* specific_cols_opt */
    case 290: /* expression_list */
    case 292: /* col_name_list */
    case 295: /* duration_list */
    case 296: /* rollup_func_list */
    case 308: /* func_list */
    case 322: /* dnode_list */
    case 326: /* literal_list */
    case 335: /* star_func_para_list */
    case 337: /* other_para_list */
    case 357: /* select_list */
    case 358: /* partition_by_clause_opt */
    case 363: /* group_by_clause_opt */
    case 367: /* group_by_list */
    case 369: /* order_by_clause_opt */
    case 373: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy210)); 
}
      break;
    case 274: /* alter_db_option */
    case 297: /* alter_table_option */
{
 
}
      break;
    case 286: /* type_name */
{
 
}
      break;
    case 340: /* compare_op */
    case 341: /* in_op */
{
 
}
      break;
    case 353: /* join_type */
{
 
}
      break;
    case 366: /* fill_mode */
{
 
}
      break;
    case 375: /* ordering_specification_opt */
{
 
}
      break;
    case 376: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  254,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  254,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  255,    0 }, /* (2) account_options ::= */
  {  255,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  255,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  255,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  255,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  255,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  255,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  255,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  255,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  255,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  256,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  256,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  258,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  258,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  258,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  258,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  258,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  258,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  258,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  258,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  258,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  258,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  254,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  254,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  254,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  254,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  254,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  260,    0 }, /* (29) sysinfo_opt ::= */
  {  260,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  254,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  254,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  261,   -1 }, /* (33) privileges ::= ALL */
  {  261,   -1 }, /* (34) privileges ::= priv_type_list */
  {  263,   -1 }, /* (35) priv_type_list ::= priv_type */
  {  263,   -3 }, /* (36) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  264,   -1 }, /* (37) priv_type ::= READ */
  {  264,   -1 }, /* (38) priv_type ::= WRITE */
  {  262,   -3 }, /* (39) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  262,   -3 }, /* (40) priv_level ::= db_name NK_DOT NK_STAR */
  {  254,   -3 }, /* (41) cmd ::= CREATE DNODE dnode_endpoint */
  {  254,   -5 }, /* (42) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  254,   -3 }, /* (43) cmd ::= DROP DNODE NK_INTEGER */
  {  254,   -3 }, /* (44) cmd ::= DROP DNODE dnode_endpoint */
  {  254,   -4 }, /* (45) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  254,   -5 }, /* (46) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  254,   -4 }, /* (47) cmd ::= ALTER ALL DNODES NK_STRING */
  {  254,   -5 }, /* (48) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  266,   -1 }, /* (49) dnode_endpoint ::= NK_STRING */
  {  266,   -1 }, /* (50) dnode_endpoint ::= NK_ID */
  {  266,   -1 }, /* (51) dnode_endpoint ::= NK_IPTOKEN */
  {  254,   -3 }, /* (52) cmd ::= ALTER LOCAL NK_STRING */
  {  254,   -4 }, /* (53) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  254,   -5 }, /* (54) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  254,   -5 }, /* (55) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  254,   -5 }, /* (56) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  254,   -5 }, /* (57) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  254,   -5 }, /* (58) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  254,   -5 }, /* (59) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  254,   -5 }, /* (60) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  254,   -5 }, /* (61) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  254,   -5 }, /* (62) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  254,   -4 }, /* (63) cmd ::= DROP DATABASE exists_opt db_name */
  {  254,   -2 }, /* (64) cmd ::= USE db_name */
  {  254,   -4 }, /* (65) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  254,   -3 }, /* (66) cmd ::= FLUSH DATABASE db_name */
  {  267,   -3 }, /* (67) not_exists_opt ::= IF NOT EXISTS */
  {  267,    0 }, /* (68) not_exists_opt ::= */
  {  269,   -2 }, /* (69) exists_opt ::= IF EXISTS */
  {  269,    0 }, /* (70) exists_opt ::= */
  {  268,    0 }, /* (71) db_options ::= */
  {  268,   -3 }, /* (72) db_options ::= db_options BUFFER NK_INTEGER */
  {  268,   -3 }, /* (73) db_options ::= db_options CACHELAST NK_INTEGER */
  {  268,   -3 }, /* (74) db_options ::= db_options CACHELASTSIZE NK_INTEGER */
  {  268,   -3 }, /* (75) db_options ::= db_options COMP NK_INTEGER */
  {  268,   -3 }, /* (76) db_options ::= db_options DURATION NK_INTEGER */
  {  268,   -3 }, /* (77) db_options ::= db_options DURATION NK_VARIABLE */
  {  268,   -3 }, /* (78) db_options ::= db_options FSYNC NK_INTEGER */
  {  268,   -3 }, /* (79) db_options ::= db_options MAXROWS NK_INTEGER */
  {  268,   -3 }, /* (80) db_options ::= db_options MINROWS NK_INTEGER */
  {  268,   -3 }, /* (81) db_options ::= db_options KEEP integer_list */
  {  268,   -3 }, /* (82) db_options ::= db_options KEEP variable_list */
  {  268,   -3 }, /* (83) db_options ::= db_options PAGES NK_INTEGER */
  {  268,   -3 }, /* (84) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  268,   -3 }, /* (85) db_options ::= db_options PRECISION NK_STRING */
  {  268,   -3 }, /* (86) db_options ::= db_options REPLICA NK_INTEGER */
  {  268,   -3 }, /* (87) db_options ::= db_options STRICT NK_INTEGER */
  {  268,   -3 }, /* (88) db_options ::= db_options WAL NK_INTEGER */
  {  268,   -3 }, /* (89) db_options ::= db_options VGROUPS NK_INTEGER */
  {  268,   -3 }, /* (90) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  268,   -3 }, /* (91) db_options ::= db_options RETENTIONS retention_list */
  {  268,   -3 }, /* (92) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  270,   -1 }, /* (93) alter_db_options ::= alter_db_option */
  {  270,   -2 }, /* (94) alter_db_options ::= alter_db_options alter_db_option */
  {  274,   -2 }, /* (95) alter_db_option ::= BUFFER NK_INTEGER */
  {  274,   -2 }, /* (96) alter_db_option ::= CACHELAST NK_INTEGER */
  {  274,   -2 }, /* (97) alter_db_option ::= CACHELASTSIZE NK_INTEGER */
  {  274,   -2 }, /* (98) alter_db_option ::= FSYNC NK_INTEGER */
  {  274,   -2 }, /* (99) alter_db_option ::= KEEP integer_list */
  {  274,   -2 }, /* (100) alter_db_option ::= KEEP variable_list */
  {  274,   -2 }, /* (101) alter_db_option ::= PAGES NK_INTEGER */
  {  274,   -2 }, /* (102) alter_db_option ::= REPLICA NK_INTEGER */
  {  274,   -2 }, /* (103) alter_db_option ::= STRICT NK_INTEGER */
  {  274,   -2 }, /* (104) alter_db_option ::= WAL NK_INTEGER */
  {  271,   -1 }, /* (105) integer_list ::= NK_INTEGER */
  {  271,   -3 }, /* (106) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  272,   -1 }, /* (107) variable_list ::= NK_VARIABLE */
  {  272,   -3 }, /* (108) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  273,   -1 }, /* (109) retention_list ::= retention */
  {  273,   -3 }, /* (110) retention_list ::= retention_list NK_COMMA retention */
  {  275,   -3 }, /* (111) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  254,   -9 }, /* (112) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  254,   -3 }, /* (113) cmd ::= CREATE TABLE multi_create_clause */
  {  254,   -9 }, /* (114) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  254,   -3 }, /* (115) cmd ::= DROP TABLE multi_drop_clause */
  {  254,   -4 }, /* (116) cmd ::= DROP STABLE exists_opt full_table_name */
  {  254,   -3 }, /* (117) cmd ::= ALTER TABLE alter_table_clause */
  {  254,   -3 }, /* (118) cmd ::= ALTER STABLE alter_table_clause */
  {  283,   -2 }, /* (119) alter_table_clause ::= full_table_name alter_table_options */
  {  283,   -5 }, /* (120) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  283,   -4 }, /* (121) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  283,   -5 }, /* (122) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  283,   -5 }, /* (123) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  283,   -5 }, /* (124) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  283,   -4 }, /* (125) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  283,   -5 }, /* (126) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  283,   -5 }, /* (127) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  283,   -6 }, /* (128) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  280,   -1 }, /* (129) multi_create_clause ::= create_subtable_clause */
  {  280,   -2 }, /* (130) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  288,  -10 }, /* (131) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  282,   -1 }, /* (132) multi_drop_clause ::= drop_table_clause */
  {  282,   -2 }, /* (133) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  291,   -2 }, /* (134) drop_table_clause ::= exists_opt full_table_name */
  {  289,    0 }, /* (135) specific_cols_opt ::= */
  {  289,   -3 }, /* (136) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  276,   -1 }, /* (137) full_table_name ::= table_name */
  {  276,   -3 }, /* (138) full_table_name ::= db_name NK_DOT table_name */
  {  277,   -1 }, /* (139) column_def_list ::= column_def */
  {  277,   -3 }, /* (140) column_def_list ::= column_def_list NK_COMMA column_def */
  {  294,   -2 }, /* (141) column_def ::= column_name type_name */
  {  294,   -4 }, /* (142) column_def ::= column_name type_name COMMENT NK_STRING */
  {  286,   -1 }, /* (143) type_name ::= BOOL */
  {  286,   -1 }, /* (144) type_name ::= TINYINT */
  {  286,   -1 }, /* (145) type_name ::= SMALLINT */
  {  286,   -1 }, /* (146) type_name ::= INT */
  {  286,   -1 }, /* (147) type_name ::= INTEGER */
  {  286,   -1 }, /* (148) type_name ::= BIGINT */
  {  286,   -1 }, /* (149) type_name ::= FLOAT */
  {  286,   -1 }, /* (150) type_name ::= DOUBLE */
  {  286,   -4 }, /* (151) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  286,   -1 }, /* (152) type_name ::= TIMESTAMP */
  {  286,   -4 }, /* (153) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  286,   -2 }, /* (154) type_name ::= TINYINT UNSIGNED */
  {  286,   -2 }, /* (155) type_name ::= SMALLINT UNSIGNED */
  {  286,   -2 }, /* (156) type_name ::= INT UNSIGNED */
  {  286,   -2 }, /* (157) type_name ::= BIGINT UNSIGNED */
  {  286,   -1 }, /* (158) type_name ::= JSON */
  {  286,   -4 }, /* (159) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  286,   -1 }, /* (160) type_name ::= MEDIUMBLOB */
  {  286,   -1 }, /* (161) type_name ::= BLOB */
  {  286,   -4 }, /* (162) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  286,   -1 }, /* (163) type_name ::= DECIMAL */
  {  286,   -4 }, /* (164) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  286,   -6 }, /* (165) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  278,    0 }, /* (166) tags_def_opt ::= */
  {  278,   -1 }, /* (167) tags_def_opt ::= tags_def */
  {  281,   -4 }, /* (168) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  279,    0 }, /* (169) table_options ::= */
  {  279,   -3 }, /* (170) table_options ::= table_options COMMENT NK_STRING */
  {  279,   -3 }, /* (171) table_options ::= table_options MAX_DELAY duration_list */
  {  279,   -3 }, /* (172) table_options ::= table_options WATERMARK duration_list */
  {  279,   -5 }, /* (173) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  279,   -3 }, /* (174) table_options ::= table_options TTL NK_INTEGER */
  {  279,   -5 }, /* (175) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  284,   -1 }, /* (176) alter_table_options ::= alter_table_option */
  {  284,   -2 }, /* (177) alter_table_options ::= alter_table_options alter_table_option */
  {  297,   -2 }, /* (178) alter_table_option ::= COMMENT NK_STRING */
  {  297,   -2 }, /* (179) alter_table_option ::= TTL NK_INTEGER */
  {  295,   -1 }, /* (180) duration_list ::= duration_literal */
  {  295,   -3 }, /* (181) duration_list ::= duration_list NK_COMMA duration_literal */
  {  296,   -1 }, /* (182) rollup_func_list ::= rollup_func_name */
  {  296,   -3 }, /* (183) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  299,   -1 }, /* (184) rollup_func_name ::= function_name */
  {  299,   -1 }, /* (185) rollup_func_name ::= FIRST */
  {  299,   -1 }, /* (186) rollup_func_name ::= LAST */
  {  292,   -1 }, /* (187) col_name_list ::= col_name */
  {  292,   -3 }, /* (188) col_name_list ::= col_name_list NK_COMMA col_name */
  {  301,   -1 }, /* (189) col_name ::= column_name */
  {  254,   -2 }, /* (190) cmd ::= SHOW DNODES */
  {  254,   -2 }, /* (191) cmd ::= SHOW USERS */
  {  254,   -2 }, /* (192) cmd ::= SHOW DATABASES */
  {  254,   -4 }, /* (193) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  254,   -4 }, /* (194) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  254,   -3 }, /* (195) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  254,   -2 }, /* (196) cmd ::= SHOW MNODES */
  {  254,   -2 }, /* (197) cmd ::= SHOW MODULES */
  {  254,   -2 }, /* (198) cmd ::= SHOW QNODES */
  {  254,   -2 }, /* (199) cmd ::= SHOW FUNCTIONS */
  {  254,   -5 }, /* (200) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  254,   -2 }, /* (201) cmd ::= SHOW STREAMS */
  {  254,   -2 }, /* (202) cmd ::= SHOW ACCOUNTS */
  {  254,   -2 }, /* (203) cmd ::= SHOW APPS */
  {  254,   -2 }, /* (204) cmd ::= SHOW CONNECTIONS */
  {  254,   -2 }, /* (205) cmd ::= SHOW LICENCE */
  {  254,   -2 }, /* (206) cmd ::= SHOW GRANTS */
  {  254,   -4 }, /* (207) cmd ::= SHOW CREATE DATABASE db_name */
  {  254,   -4 }, /* (208) cmd ::= SHOW CREATE TABLE full_table_name */
  {  254,   -4 }, /* (209) cmd ::= SHOW CREATE STABLE full_table_name */
  {  254,   -2 }, /* (210) cmd ::= SHOW QUERIES */
  {  254,   -2 }, /* (211) cmd ::= SHOW SCORES */
  {  254,   -2 }, /* (212) cmd ::= SHOW TOPICS */
  {  254,   -2 }, /* (213) cmd ::= SHOW VARIABLES */
  {  254,   -3 }, /* (214) cmd ::= SHOW LOCAL VARIABLES */
  {  254,   -4 }, /* (215) cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
  {  254,   -2 }, /* (216) cmd ::= SHOW BNODES */
  {  254,   -2 }, /* (217) cmd ::= SHOW SNODES */
  {  254,   -2 }, /* (218) cmd ::= SHOW CLUSTER */
  {  254,   -2 }, /* (219) cmd ::= SHOW TRANSACTIONS */
  {  254,   -4 }, /* (220) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  254,   -2 }, /* (221) cmd ::= SHOW CONSUMERS */
  {  254,   -2 }, /* (222) cmd ::= SHOW SUBSCRIPTIONS */
  {  302,    0 }, /* (223) db_name_cond_opt ::= */
  {  302,   -2 }, /* (224) db_name_cond_opt ::= db_name NK_DOT */
  {  303,    0 }, /* (225) like_pattern_opt ::= */
  {  303,   -2 }, /* (226) like_pattern_opt ::= LIKE NK_STRING */
  {  304,   -1 }, /* (227) table_name_cond ::= table_name */
  {  305,    0 }, /* (228) from_db_opt ::= */
  {  305,   -2 }, /* (229) from_db_opt ::= FROM db_name */
  {  254,   -8 }, /* (230) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  254,   -4 }, /* (231) cmd ::= DROP INDEX exists_opt index_name */
  {  307,  -10 }, /* (232) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  307,  -12 }, /* (233) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  308,   -1 }, /* (234) func_list ::= func */
  {  308,   -3 }, /* (235) func_list ::= func_list NK_COMMA func */
  {  311,   -4 }, /* (236) func ::= function_name NK_LP expression_list NK_RP */
  {  310,    0 }, /* (237) sma_stream_opt ::= */
  {  310,   -3 }, /* (238) sma_stream_opt ::= stream_options WATERMARK duration_literal */
  {  310,   -3 }, /* (239) sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
  {  254,   -6 }, /* (240) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  254,   -7 }, /* (241) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  254,   -9 }, /* (242) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  254,   -7 }, /* (243) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  254,   -9 }, /* (244) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  254,   -4 }, /* (245) cmd ::= DROP TOPIC exists_opt topic_name */
  {  254,   -7 }, /* (246) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  254,   -2 }, /* (247) cmd ::= DESC full_table_name */
  {  254,   -2 }, /* (248) cmd ::= DESCRIBE full_table_name */
  {  254,   -3 }, /* (249) cmd ::= RESET QUERY CACHE */
  {  254,   -4 }, /* (250) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  316,    0 }, /* (251) analyze_opt ::= */
  {  316,   -1 }, /* (252) analyze_opt ::= ANALYZE */
  {  317,    0 }, /* (253) explain_options ::= */
  {  317,   -3 }, /* (254) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  317,   -3 }, /* (255) explain_options ::= explain_options RATIO NK_FLOAT */
  {  254,   -6 }, /* (256) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  254,  -10 }, /* (257) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  254,   -4 }, /* (258) cmd ::= DROP FUNCTION exists_opt function_name */
  {  318,    0 }, /* (259) agg_func_opt ::= */
  {  318,   -1 }, /* (260) agg_func_opt ::= AGGREGATE */
  {  319,    0 }, /* (261) bufsize_opt ::= */
  {  319,   -2 }, /* (262) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  254,   -8 }, /* (263) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  254,   -4 }, /* (264) cmd ::= DROP STREAM exists_opt stream_name */
  {  321,    0 }, /* (265) into_opt ::= */
  {  321,   -2 }, /* (266) into_opt ::= INTO full_table_name */
  {  312,    0 }, /* (267) stream_options ::= */
  {  312,   -3 }, /* (268) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  312,   -3 }, /* (269) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  312,   -4 }, /* (270) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  312,   -3 }, /* (271) stream_options ::= stream_options WATERMARK duration_literal */
  {  312,   -3 }, /* (272) stream_options ::= stream_options IGNORE EXPIRED */
  {  254,   -3 }, /* (273) cmd ::= KILL CONNECTION NK_INTEGER */
  {  254,   -3 }, /* (274) cmd ::= KILL QUERY NK_STRING */
  {  254,   -3 }, /* (275) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  254,   -2 }, /* (276) cmd ::= BALANCE VGROUP */
  {  254,   -4 }, /* (277) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  254,   -4 }, /* (278) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  254,   -3 }, /* (279) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  322,   -2 }, /* (280) dnode_list ::= DNODE NK_INTEGER */
  {  322,   -3 }, /* (281) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  254,   -3 }, /* (282) cmd ::= SYNCDB db_name REPLICA */
  {  254,   -4 }, /* (283) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  254,   -1 }, /* (284) cmd ::= query_expression */
  {  254,   -5 }, /* (285) cmd ::= INSERT INTO full_table_name specific_cols_opt query_expression */
  {  257,   -1 }, /* (286) literal ::= NK_INTEGER */
  {  257,   -1 }, /* (287) literal ::= NK_FLOAT */
  {  257,   -1 }, /* (288) literal ::= NK_STRING */
  {  257,   -1 }, /* (289) literal ::= NK_BOOL */
  {  257,   -2 }, /* (290) literal ::= TIMESTAMP NK_STRING */
  {  257,   -1 }, /* (291) literal ::= duration_literal */
  {  257,   -1 }, /* (292) literal ::= NULL */
  {  257,   -1 }, /* (293) literal ::= NK_QUESTION */
  {  298,   -1 }, /* (294) duration_literal ::= NK_VARIABLE */
  {  324,   -1 }, /* (295) signed ::= NK_INTEGER */
  {  324,   -2 }, /* (296) signed ::= NK_PLUS NK_INTEGER */
  {  324,   -2 }, /* (297) signed ::= NK_MINUS NK_INTEGER */
  {  324,   -1 }, /* (298) signed ::= NK_FLOAT */
  {  324,   -2 }, /* (299) signed ::= NK_PLUS NK_FLOAT */
  {  324,   -2 }, /* (300) signed ::= NK_MINUS NK_FLOAT */
  {  287,   -1 }, /* (301) signed_literal ::= signed */
  {  287,   -1 }, /* (302) signed_literal ::= NK_STRING */
  {  287,   -1 }, /* (303) signed_literal ::= NK_BOOL */
  {  287,   -2 }, /* (304) signed_literal ::= TIMESTAMP NK_STRING */
  {  287,   -1 }, /* (305) signed_literal ::= duration_literal */
  {  287,   -1 }, /* (306) signed_literal ::= NULL */
  {  287,   -1 }, /* (307) signed_literal ::= literal_func */
  {  326,   -1 }, /* (308) literal_list ::= signed_literal */
  {  326,   -3 }, /* (309) literal_list ::= literal_list NK_COMMA signed_literal */
  {  265,   -1 }, /* (310) db_name ::= NK_ID */
  {  293,   -1 }, /* (311) table_name ::= NK_ID */
  {  285,   -1 }, /* (312) column_name ::= NK_ID */
  {  300,   -1 }, /* (313) function_name ::= NK_ID */
  {  327,   -1 }, /* (314) table_alias ::= NK_ID */
  {  328,   -1 }, /* (315) column_alias ::= NK_ID */
  {  259,   -1 }, /* (316) user_name ::= NK_ID */
  {  306,   -1 }, /* (317) index_name ::= NK_ID */
  {  313,   -1 }, /* (318) topic_name ::= NK_ID */
  {  320,   -1 }, /* (319) stream_name ::= NK_ID */
  {  315,   -1 }, /* (320) cgroup_name ::= NK_ID */
  {  329,   -1 }, /* (321) expression ::= literal */
  {  329,   -1 }, /* (322) expression ::= pseudo_column */
  {  329,   -1 }, /* (323) expression ::= column_reference */
  {  329,   -1 }, /* (324) expression ::= function_expression */
  {  329,   -1 }, /* (325) expression ::= subquery */
  {  329,   -3 }, /* (326) expression ::= NK_LP expression NK_RP */
  {  329,   -2 }, /* (327) expression ::= NK_PLUS expression */
  {  329,   -2 }, /* (328) expression ::= NK_MINUS expression */
  {  329,   -3 }, /* (329) expression ::= expression NK_PLUS expression */
  {  329,   -3 }, /* (330) expression ::= expression NK_MINUS expression */
  {  329,   -3 }, /* (331) expression ::= expression NK_STAR expression */
  {  329,   -3 }, /* (332) expression ::= expression NK_SLASH expression */
  {  329,   -3 }, /* (333) expression ::= expression NK_REM expression */
  {  329,   -3 }, /* (334) expression ::= column_reference NK_ARROW NK_STRING */
  {  329,   -3 }, /* (335) expression ::= expression NK_BITAND expression */
  {  329,   -3 }, /* (336) expression ::= expression NK_BITOR expression */
  {  290,   -1 }, /* (337) expression_list ::= expression */
  {  290,   -3 }, /* (338) expression_list ::= expression_list NK_COMMA expression */
  {  331,   -1 }, /* (339) column_reference ::= column_name */
  {  331,   -3 }, /* (340) column_reference ::= table_name NK_DOT column_name */
  {  330,   -1 }, /* (341) pseudo_column ::= ROWTS */
  {  330,   -1 }, /* (342) pseudo_column ::= TBNAME */
  {  330,   -3 }, /* (343) pseudo_column ::= table_name NK_DOT TBNAME */
  {  330,   -1 }, /* (344) pseudo_column ::= QSTARTTS */
  {  330,   -1 }, /* (345) pseudo_column ::= QENDTS */
  {  330,   -1 }, /* (346) pseudo_column ::= WSTARTTS */
  {  330,   -1 }, /* (347) pseudo_column ::= WENDTS */
  {  330,   -1 }, /* (348) pseudo_column ::= WDURATION */
  {  332,   -4 }, /* (349) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  332,   -4 }, /* (350) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  332,   -6 }, /* (351) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  332,   -1 }, /* (352) function_expression ::= literal_func */
  {  325,   -3 }, /* (353) literal_func ::= noarg_func NK_LP NK_RP */
  {  325,   -1 }, /* (354) literal_func ::= NOW */
  {  336,   -1 }, /* (355) noarg_func ::= NOW */
  {  336,   -1 }, /* (356) noarg_func ::= TODAY */
  {  336,   -1 }, /* (357) noarg_func ::= TIMEZONE */
  {  336,   -1 }, /* (358) noarg_func ::= DATABASE */
  {  336,   -1 }, /* (359) noarg_func ::= CLIENT_VERSION */
  {  336,   -1 }, /* (360) noarg_func ::= SERVER_VERSION */
  {  336,   -1 }, /* (361) noarg_func ::= SERVER_STATUS */
  {  336,   -1 }, /* (362) noarg_func ::= CURRENT_USER */
  {  336,   -1 }, /* (363) noarg_func ::= USER */
  {  334,   -1 }, /* (364) star_func ::= COUNT */
  {  334,   -1 }, /* (365) star_func ::= FIRST */
  {  334,   -1 }, /* (366) star_func ::= LAST */
  {  334,   -1 }, /* (367) star_func ::= LAST_ROW */
  {  335,   -1 }, /* (368) star_func_para_list ::= NK_STAR */
  {  335,   -1 }, /* (369) star_func_para_list ::= other_para_list */
  {  337,   -1 }, /* (370) other_para_list ::= star_func_para */
  {  337,   -3 }, /* (371) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  338,   -1 }, /* (372) star_func_para ::= expression */
  {  338,   -3 }, /* (373) star_func_para ::= table_name NK_DOT NK_STAR */
  {  339,   -3 }, /* (374) predicate ::= expression compare_op expression */
  {  339,   -5 }, /* (375) predicate ::= expression BETWEEN expression AND expression */
  {  339,   -6 }, /* (376) predicate ::= expression NOT BETWEEN expression AND expression */
  {  339,   -3 }, /* (377) predicate ::= expression IS NULL */
  {  339,   -4 }, /* (378) predicate ::= expression IS NOT NULL */
  {  339,   -3 }, /* (379) predicate ::= expression in_op in_predicate_value */
  {  340,   -1 }, /* (380) compare_op ::= NK_LT */
  {  340,   -1 }, /* (381) compare_op ::= NK_GT */
  {  340,   -1 }, /* (382) compare_op ::= NK_LE */
  {  340,   -1 }, /* (383) compare_op ::= NK_GE */
  {  340,   -1 }, /* (384) compare_op ::= NK_NE */
  {  340,   -1 }, /* (385) compare_op ::= NK_EQ */
  {  340,   -1 }, /* (386) compare_op ::= LIKE */
  {  340,   -2 }, /* (387) compare_op ::= NOT LIKE */
  {  340,   -1 }, /* (388) compare_op ::= MATCH */
  {  340,   -1 }, /* (389) compare_op ::= NMATCH */
  {  340,   -1 }, /* (390) compare_op ::= CONTAINS */
  {  341,   -1 }, /* (391) in_op ::= IN */
  {  341,   -2 }, /* (392) in_op ::= NOT IN */
  {  342,   -3 }, /* (393) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  343,   -1 }, /* (394) boolean_value_expression ::= boolean_primary */
  {  343,   -2 }, /* (395) boolean_value_expression ::= NOT boolean_primary */
  {  343,   -3 }, /* (396) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  343,   -3 }, /* (397) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  344,   -1 }, /* (398) boolean_primary ::= predicate */
  {  344,   -3 }, /* (399) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  345,   -1 }, /* (400) common_expression ::= expression */
  {  345,   -1 }, /* (401) common_expression ::= boolean_value_expression */
  {  346,    0 }, /* (402) from_clause_opt ::= */
  {  346,   -2 }, /* (403) from_clause_opt ::= FROM table_reference_list */
  {  347,   -1 }, /* (404) table_reference_list ::= table_reference */
  {  347,   -3 }, /* (405) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  348,   -1 }, /* (406) table_reference ::= table_primary */
  {  348,   -1 }, /* (407) table_reference ::= joined_table */
  {  349,   -2 }, /* (408) table_primary ::= table_name alias_opt */
  {  349,   -4 }, /* (409) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  349,   -2 }, /* (410) table_primary ::= subquery alias_opt */
  {  349,   -1 }, /* (411) table_primary ::= parenthesized_joined_table */
  {  351,    0 }, /* (412) alias_opt ::= */
  {  351,   -1 }, /* (413) alias_opt ::= table_alias */
  {  351,   -2 }, /* (414) alias_opt ::= AS table_alias */
  {  352,   -3 }, /* (415) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  352,   -3 }, /* (416) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  350,   -6 }, /* (417) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  353,    0 }, /* (418) join_type ::= */
  {  353,   -1 }, /* (419) join_type ::= INNER */
  {  355,  -12 }, /* (420) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  356,    0 }, /* (421) set_quantifier_opt ::= */
  {  356,   -1 }, /* (422) set_quantifier_opt ::= DISTINCT */
  {  356,   -1 }, /* (423) set_quantifier_opt ::= ALL */
  {  357,   -1 }, /* (424) select_list ::= select_item */
  {  357,   -3 }, /* (425) select_list ::= select_list NK_COMMA select_item */
  {  365,   -1 }, /* (426) select_item ::= NK_STAR */
  {  365,   -1 }, /* (427) select_item ::= common_expression */
  {  365,   -2 }, /* (428) select_item ::= common_expression column_alias */
  {  365,   -3 }, /* (429) select_item ::= common_expression AS column_alias */
  {  365,   -3 }, /* (430) select_item ::= table_name NK_DOT NK_STAR */
  {  323,    0 }, /* (431) where_clause_opt ::= */
  {  323,   -2 }, /* (432) where_clause_opt ::= WHERE search_condition */
  {  358,    0 }, /* (433) partition_by_clause_opt ::= */
  {  358,   -3 }, /* (434) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  362,    0 }, /* (435) twindow_clause_opt ::= */
  {  362,   -6 }, /* (436) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  362,   -4 }, /* (437) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  362,   -6 }, /* (438) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  362,   -8 }, /* (439) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  309,    0 }, /* (440) sliding_opt ::= */
  {  309,   -4 }, /* (441) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  361,    0 }, /* (442) fill_opt ::= */
  {  361,   -4 }, /* (443) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  361,   -6 }, /* (444) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  366,   -1 }, /* (445) fill_mode ::= NONE */
  {  366,   -1 }, /* (446) fill_mode ::= PREV */
  {  366,   -1 }, /* (447) fill_mode ::= NULL */
  {  366,   -1 }, /* (448) fill_mode ::= LINEAR */
  {  366,   -1 }, /* (449) fill_mode ::= NEXT */
  {  363,    0 }, /* (450) group_by_clause_opt ::= */
  {  363,   -3 }, /* (451) group_by_clause_opt ::= GROUP BY group_by_list */
  {  367,   -1 }, /* (452) group_by_list ::= expression */
  {  367,   -3 }, /* (453) group_by_list ::= group_by_list NK_COMMA expression */
  {  364,    0 }, /* (454) having_clause_opt ::= */
  {  364,   -2 }, /* (455) having_clause_opt ::= HAVING search_condition */
  {  359,    0 }, /* (456) range_opt ::= */
  {  359,   -6 }, /* (457) range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
  {  360,    0 }, /* (458) every_opt ::= */
  {  360,   -4 }, /* (459) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  314,   -4 }, /* (460) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  368,   -1 }, /* (461) query_expression_body ::= query_primary */
  {  368,   -4 }, /* (462) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  368,   -3 }, /* (463) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  372,   -1 }, /* (464) query_primary ::= query_specification */
  {  372,   -6 }, /* (465) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  369,    0 }, /* (466) order_by_clause_opt ::= */
  {  369,   -3 }, /* (467) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  370,    0 }, /* (468) slimit_clause_opt ::= */
  {  370,   -2 }, /* (469) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  370,   -4 }, /* (470) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  370,   -4 }, /* (471) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  371,    0 }, /* (472) limit_clause_opt ::= */
  {  371,   -2 }, /* (473) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  371,   -4 }, /* (474) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  371,   -4 }, /* (475) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  333,   -3 }, /* (476) subquery ::= NK_LP query_expression NK_RP */
  {  354,   -1 }, /* (477) search_condition ::= common_expression */
  {  373,   -1 }, /* (478) sort_specification_list ::= sort_specification */
  {  373,   -3 }, /* (479) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  374,   -3 }, /* (480) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  375,    0 }, /* (481) ordering_specification_opt ::= */
  {  375,   -1 }, /* (482) ordering_specification_opt ::= ASC */
  {  375,   -1 }, /* (483) ordering_specification_opt ::= DESC */
  {  376,    0 }, /* (484) null_ordering_opt ::= */
  {  376,   -2 }, /* (485) null_ordering_opt ::= NULLS FIRST */
  {  376,   -2 }, /* (486) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,255,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,256,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,255,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,257,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,258,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,256,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,258,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,257,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy5, &yymsp[-1].minor.yy0, yymsp[0].minor.yy535); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy5, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy5, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy5, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy5); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy535 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy535 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy311, &yymsp[-2].minor.yy5, &yymsp[0].minor.yy5); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy311, &yymsp[-2].minor.yy5, &yymsp[0].minor.yy5); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy311 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 35: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==35);
{ yylhsminor.yy311 = yymsp[0].minor.yy311; }
  yymsp[0].minor.yy311 = yylhsminor.yy311;
        break;
      case 36: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy311 = yymsp[-2].minor.yy311 | yymsp[0].minor.yy311; }
  yymsp[-2].minor.yy311 = yylhsminor.yy311;
        break;
      case 37: /* priv_type ::= READ */
{ yymsp[0].minor.yy311 = PRIVILEGE_TYPE_READ; }
        break;
      case 38: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy311 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 39: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy5 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy5 = yylhsminor.yy5;
        break;
      case 40: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy5 = yymsp[-2].minor.yy5; }
  yymsp[-2].minor.yy5 = yylhsminor.yy5;
        break;
      case 41: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy5, NULL); }
        break;
      case 42: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy5, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy5); }
        break;
      case 45: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 46: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* dnode_endpoint ::= NK_STRING */
      case 50: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==50);
      case 51: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==51);
      case 310: /* db_name ::= NK_ID */ yytestcase(yyruleno==310);
      case 311: /* table_name ::= NK_ID */ yytestcase(yyruleno==311);
      case 312: /* column_name ::= NK_ID */ yytestcase(yyruleno==312);
      case 313: /* function_name ::= NK_ID */ yytestcase(yyruleno==313);
      case 314: /* table_alias ::= NK_ID */ yytestcase(yyruleno==314);
      case 315: /* column_alias ::= NK_ID */ yytestcase(yyruleno==315);
      case 316: /* user_name ::= NK_ID */ yytestcase(yyruleno==316);
      case 317: /* index_name ::= NK_ID */ yytestcase(yyruleno==317);
      case 318: /* topic_name ::= NK_ID */ yytestcase(yyruleno==318);
      case 319: /* stream_name ::= NK_ID */ yytestcase(yyruleno==319);
      case 320: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==320);
      case 355: /* noarg_func ::= NOW */ yytestcase(yyruleno==355);
      case 356: /* noarg_func ::= TODAY */ yytestcase(yyruleno==356);
      case 357: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==357);
      case 358: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==358);
      case 359: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==359);
      case 360: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==360);
      case 361: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==361);
      case 362: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==362);
      case 363: /* noarg_func ::= USER */ yytestcase(yyruleno==363);
      case 364: /* star_func ::= COUNT */ yytestcase(yyruleno==364);
      case 365: /* star_func ::= FIRST */ yytestcase(yyruleno==365);
      case 366: /* star_func ::= LAST */ yytestcase(yyruleno==366);
      case 367: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==367);
{ yylhsminor.yy5 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy5 = yylhsminor.yy5;
        break;
      case 52: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy403, &yymsp[-1].minor.yy5, yymsp[0].minor.yy652); }
        break;
      case 63: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy403, &yymsp[0].minor.yy5); }
        break;
      case 64: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy5); }
        break;
      case 65: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy5, yymsp[0].minor.yy652); }
        break;
      case 66: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy5); }
        break;
      case 67: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy403 = true; }
        break;
      case 68: /* not_exists_opt ::= */
      case 70: /* exists_opt ::= */ yytestcase(yyruleno==70);
      case 251: /* analyze_opt ::= */ yytestcase(yyruleno==251);
      case 259: /* agg_func_opt ::= */ yytestcase(yyruleno==259);
      case 421: /* set_quantifier_opt ::= */ yytestcase(yyruleno==421);
{ yymsp[1].minor.yy403 = false; }
        break;
      case 69: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy403 = true; }
        break;
      case 71: /* db_options ::= */
{ yymsp[1].minor.yy652 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 72: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 73: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 74: /* db_options ::= db_options CACHELASTSIZE NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_CACHELASTSIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 75: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 76: /* db_options ::= db_options DURATION NK_INTEGER */
      case 77: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==77);
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 78: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 79: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 80: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 81: /* db_options ::= db_options KEEP integer_list */
      case 82: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==82);
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_KEEP, yymsp[0].minor.yy210); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 83: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 84: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 85: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 86: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 87: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 88: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 89: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 90: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 91: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_RETENTIONS, yymsp[0].minor.yy210); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 92: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy652 = setDatabaseOption(pCxt, yymsp[-2].minor.yy652, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 93: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy652 = createAlterDatabaseOptions(pCxt); yylhsminor.yy652 = setAlterDatabaseOption(pCxt, yylhsminor.yy652, &yymsp[0].minor.yy351); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 94: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy652 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy652, &yymsp[0].minor.yy351); }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 95: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy351.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy351.val = yymsp[0].minor.yy0; }
        break;
      case 96: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy351.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy351.val = yymsp[0].minor.yy0; }
        break;
      case 97: /* alter_db_option ::= CACHELASTSIZE NK_INTEGER */
{ yymsp[-1].minor.yy351.type = DB_OPTION_CACHELASTSIZE; yymsp[-1].minor.yy351.val = yymsp[0].minor.yy0; }
        break;
      case 98: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy351.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy351.val = yymsp[0].minor.yy0; }
        break;
      case 99: /* alter_db_option ::= KEEP integer_list */
      case 100: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==100);
{ yymsp[-1].minor.yy351.type = DB_OPTION_KEEP; yymsp[-1].minor.yy351.pList = yymsp[0].minor.yy210; }
        break;
      case 101: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy351.type = DB_OPTION_PAGES; yymsp[-1].minor.yy351.val = yymsp[0].minor.yy0; }
        break;
      case 102: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy351.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy351.val = yymsp[0].minor.yy0; }
        break;
      case 103: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy351.type = DB_OPTION_STRICT; yymsp[-1].minor.yy351.val = yymsp[0].minor.yy0; }
        break;
      case 104: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy351.type = DB_OPTION_WAL; yymsp[-1].minor.yy351.val = yymsp[0].minor.yy0; }
        break;
      case 105: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy210 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy210 = yylhsminor.yy210;
        break;
      case 106: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 281: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==281);
{ yylhsminor.yy210 = addNodeToList(pCxt, yymsp[-2].minor.yy210, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy210 = yylhsminor.yy210;
        break;
      case 107: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy210 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy210 = yylhsminor.yy210;
        break;
      case 108: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy210 = addNodeToList(pCxt, yymsp[-2].minor.yy210, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy210 = yylhsminor.yy210;
        break;
      case 109: /* retention_list ::= retention */
      case 129: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==129);
      case 132: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==132);
      case 139: /* column_def_list ::= column_def */ yytestcase(yyruleno==139);
      case 182: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==182);
      case 187: /* col_name_list ::= col_name */ yytestcase(yyruleno==187);
      case 234: /* func_list ::= func */ yytestcase(yyruleno==234);
      case 308: /* literal_list ::= signed_literal */ yytestcase(yyruleno==308);
      case 370: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==370);
      case 424: /* select_list ::= select_item */ yytestcase(yyruleno==424);
      case 478: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==478);
{ yylhsminor.yy210 = createNodeList(pCxt, yymsp[0].minor.yy652); }
  yymsp[0].minor.yy210 = yylhsminor.yy210;
        break;
      case 110: /* retention_list ::= retention_list NK_COMMA retention */
      case 140: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==140);
      case 183: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==183);
      case 188: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==188);
      case 235: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==235);
      case 309: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==309);
      case 371: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==371);
      case 425: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==425);
      case 479: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==479);
{ yylhsminor.yy210 = addNodeToList(pCxt, yymsp[-2].minor.yy210, yymsp[0].minor.yy652); }
  yymsp[-2].minor.yy210 = yylhsminor.yy210;
        break;
      case 111: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy652 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 112: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 114: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==114);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy403, yymsp[-5].minor.yy652, yymsp[-3].minor.yy210, yymsp[-1].minor.yy210, yymsp[0].minor.yy652); }
        break;
      case 113: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy210); }
        break;
      case 115: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy210); }
        break;
      case 116: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy403, yymsp[0].minor.yy652); }
        break;
      case 117: /* cmd ::= ALTER TABLE alter_table_clause */
      case 284: /* cmd ::= query_expression */ yytestcase(yyruleno==284);
{ pCxt->pRootNode = yymsp[0].minor.yy652; }
        break;
      case 118: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy652); }
        break;
      case 119: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy652 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy652, yymsp[0].minor.yy652); }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 120: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy652 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy652, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy5, yymsp[0].minor.yy552); }
  yymsp[-4].minor.yy652 = yylhsminor.yy652;
        break;
      case 121: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy652 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy652, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy5); }
  yymsp[-3].minor.yy652 = yylhsminor.yy652;
        break;
      case 122: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy652 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy652, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy5, yymsp[0].minor.yy552); }
  yymsp[-4].minor.yy652 = yylhsminor.yy652;
        break;
      case 123: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy652 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy652, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy5, &yymsp[0].minor.yy5); }
  yymsp[-4].minor.yy652 = yylhsminor.yy652;
        break;
      case 124: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy652 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy652, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy5, yymsp[0].minor.yy552); }
  yymsp[-4].minor.yy652 = yylhsminor.yy652;
        break;
      case 125: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy652 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy652, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy5); }
  yymsp[-3].minor.yy652 = yylhsminor.yy652;
        break;
      case 126: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy652 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy652, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy5, yymsp[0].minor.yy552); }
  yymsp[-4].minor.yy652 = yylhsminor.yy652;
        break;
      case 127: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy652 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy652, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy5, &yymsp[0].minor.yy5); }
  yymsp[-4].minor.yy652 = yylhsminor.yy652;
        break;
      case 128: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy652 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy652, &yymsp[-2].minor.yy5, yymsp[0].minor.yy652); }
  yymsp[-5].minor.yy652 = yylhsminor.yy652;
        break;
      case 130: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 133: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==133);
{ yylhsminor.yy210 = addNodeToList(pCxt, yymsp[-1].minor.yy210, yymsp[0].minor.yy652); }
  yymsp[-1].minor.yy210 = yylhsminor.yy210;
        break;
      case 131: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy652 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy403, yymsp[-8].minor.yy652, yymsp[-6].minor.yy652, yymsp[-5].minor.yy210, yymsp[-2].minor.yy210, yymsp[0].minor.yy652); }
  yymsp[-9].minor.yy652 = yylhsminor.yy652;
        break;
      case 134: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy652 = createDropTableClause(pCxt, yymsp[-1].minor.yy403, yymsp[0].minor.yy652); }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 135: /* specific_cols_opt ::= */
      case 166: /* tags_def_opt ::= */ yytestcase(yyruleno==166);
      case 433: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==433);
      case 450: /* group_by_clause_opt ::= */ yytestcase(yyruleno==450);
      case 466: /* order_by_clause_opt ::= */ yytestcase(yyruleno==466);
{ yymsp[1].minor.yy210 = NULL; }
        break;
      case 136: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy210 = yymsp[-1].minor.yy210; }
        break;
      case 137: /* full_table_name ::= table_name */
{ yylhsminor.yy652 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy5, NULL); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 138: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy652 = createRealTableNode(pCxt, &yymsp[-2].minor.yy5, &yymsp[0].minor.yy5, NULL); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 141: /* column_def ::= column_name type_name */
{ yylhsminor.yy652 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy5, yymsp[0].minor.yy552, NULL); }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 142: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy652 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy5, yymsp[-2].minor.yy552, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy652 = yylhsminor.yy652;
        break;
      case 143: /* type_name ::= BOOL */
{ yymsp[0].minor.yy552 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 144: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy552 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 145: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy552 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 146: /* type_name ::= INT */
      case 147: /* type_name ::= INTEGER */ yytestcase(yyruleno==147);
{ yymsp[0].minor.yy552 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 148: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy552 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 149: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy552 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 150: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy552 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 151: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy552 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 152: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy552 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 153: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy552 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 154: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy552 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 155: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy552 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 156: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy552 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 157: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy552 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 158: /* type_name ::= JSON */
{ yymsp[0].minor.yy552 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 159: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy552 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 160: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy552 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 161: /* type_name ::= BLOB */
{ yymsp[0].minor.yy552 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 162: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy552 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 163: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy552 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 164: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy552 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 165: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy552 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 167: /* tags_def_opt ::= tags_def */
      case 369: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==369);
{ yylhsminor.yy210 = yymsp[0].minor.yy210; }
  yymsp[0].minor.yy210 = yylhsminor.yy210;
        break;
      case 168: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy210 = yymsp[-1].minor.yy210; }
        break;
      case 169: /* table_options ::= */
{ yymsp[1].minor.yy652 = createDefaultTableOptions(pCxt); }
        break;
      case 170: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy652 = setTableOption(pCxt, yymsp[-2].minor.yy652, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 171: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy652 = setTableOption(pCxt, yymsp[-2].minor.yy652, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy210); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 172: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy652 = setTableOption(pCxt, yymsp[-2].minor.yy652, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy210); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 173: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy652 = setTableOption(pCxt, yymsp[-4].minor.yy652, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy210); }
  yymsp[-4].minor.yy652 = yylhsminor.yy652;
        break;
      case 174: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy652 = setTableOption(pCxt, yymsp[-2].minor.yy652, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 175: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy652 = setTableOption(pCxt, yymsp[-4].minor.yy652, TABLE_OPTION_SMA, yymsp[-1].minor.yy210); }
  yymsp[-4].minor.yy652 = yylhsminor.yy652;
        break;
      case 176: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy652 = createAlterTableOptions(pCxt); yylhsminor.yy652 = setTableOption(pCxt, yylhsminor.yy652, yymsp[0].minor.yy351.type, &yymsp[0].minor.yy351.val); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 177: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy652 = setTableOption(pCxt, yymsp[-1].minor.yy652, yymsp[0].minor.yy351.type, &yymsp[0].minor.yy351.val); }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 178: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy351.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy351.val = yymsp[0].minor.yy0; }
        break;
      case 179: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy351.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy351.val = yymsp[0].minor.yy0; }
        break;
      case 180: /* duration_list ::= duration_literal */
      case 337: /* expression_list ::= expression */ yytestcase(yyruleno==337);
{ yylhsminor.yy210 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy652)); }
  yymsp[0].minor.yy210 = yylhsminor.yy210;
        break;
      case 181: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 338: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==338);
{ yylhsminor.yy210 = addNodeToList(pCxt, yymsp[-2].minor.yy210, releaseRawExprNode(pCxt, yymsp[0].minor.yy652)); }
  yymsp[-2].minor.yy210 = yylhsminor.yy210;
        break;
      case 184: /* rollup_func_name ::= function_name */
{ yylhsminor.yy652 = createFunctionNode(pCxt, &yymsp[0].minor.yy5, NULL); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 185: /* rollup_func_name ::= FIRST */
      case 186: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==186);
{ yylhsminor.yy652 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 189: /* col_name ::= column_name */
{ yylhsminor.yy652 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy5); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 190: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 191: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 192: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 193: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy652, yymsp[0].minor.yy652, OP_TYPE_LIKE); }
        break;
      case 194: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy652, yymsp[0].minor.yy652, OP_TYPE_LIKE); }
        break;
      case 195: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy652, NULL, OP_TYPE_LIKE); }
        break;
      case 196: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 197: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT); }
        break;
      case 198: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 199: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 200: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy652, yymsp[-1].minor.yy652, OP_TYPE_EQUAL); }
        break;
      case 201: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 202: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 203: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 204: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 205: /* cmd ::= SHOW LICENCE */
      case 206: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==206);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT); }
        break;
      case 207: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy5); }
        break;
      case 208: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy652); }
        break;
      case 209: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy652); }
        break;
      case 210: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 211: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 212: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 213: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 214: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 215: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-1].minor.yy0)); }
        break;
      case 216: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 217: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 218: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 219: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 220: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy652); }
        break;
      case 221: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 222: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 223: /* db_name_cond_opt ::= */
      case 228: /* from_db_opt ::= */ yytestcase(yyruleno==228);
{ yymsp[1].minor.yy652 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 224: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy5); }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 225: /* like_pattern_opt ::= */
      case 265: /* into_opt ::= */ yytestcase(yyruleno==265);
      case 402: /* from_clause_opt ::= */ yytestcase(yyruleno==402);
      case 431: /* where_clause_opt ::= */ yytestcase(yyruleno==431);
      case 435: /* twindow_clause_opt ::= */ yytestcase(yyruleno==435);
      case 440: /* sliding_opt ::= */ yytestcase(yyruleno==440);
      case 442: /* fill_opt ::= */ yytestcase(yyruleno==442);
      case 454: /* having_clause_opt ::= */ yytestcase(yyruleno==454);
      case 456: /* range_opt ::= */ yytestcase(yyruleno==456);
      case 458: /* every_opt ::= */ yytestcase(yyruleno==458);
      case 468: /* slimit_clause_opt ::= */ yytestcase(yyruleno==468);
      case 472: /* limit_clause_opt ::= */ yytestcase(yyruleno==472);
{ yymsp[1].minor.yy652 = NULL; }
        break;
      case 226: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 227: /* table_name_cond ::= table_name */
{ yylhsminor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy5); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 229: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy5); }
        break;
      case 230: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy403, &yymsp[-3].minor.yy5, &yymsp[-1].minor.yy5, NULL, yymsp[0].minor.yy652); }
        break;
      case 231: /* cmd ::= DROP INDEX exists_opt index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy403, &yymsp[0].minor.yy5); }
        break;
      case 232: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy652 = createIndexOption(pCxt, yymsp[-7].minor.yy210, releaseRawExprNode(pCxt, yymsp[-3].minor.yy652), NULL, yymsp[-1].minor.yy652, yymsp[0].minor.yy652); }
        break;
      case 233: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy652 = createIndexOption(pCxt, yymsp[-9].minor.yy210, releaseRawExprNode(pCxt, yymsp[-5].minor.yy652), releaseRawExprNode(pCxt, yymsp[-3].minor.yy652), yymsp[-1].minor.yy652, yymsp[0].minor.yy652); }
        break;
      case 236: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy652 = createFunctionNode(pCxt, &yymsp[-3].minor.yy5, yymsp[-1].minor.yy210); }
  yymsp[-3].minor.yy652 = yylhsminor.yy652;
        break;
      case 237: /* sma_stream_opt ::= */
      case 267: /* stream_options ::= */ yytestcase(yyruleno==267);
{ yymsp[1].minor.yy652 = createStreamOptions(pCxt); }
        break;
      case 238: /* sma_stream_opt ::= stream_options WATERMARK duration_literal */
      case 271: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==271);
{ ((SStreamOptions*)yymsp[-2].minor.yy652)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy652); yylhsminor.yy652 = yymsp[-2].minor.yy652; }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 239: /* sma_stream_opt ::= stream_options MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy652)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy652); yylhsminor.yy652 = yymsp[-2].minor.yy652; }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 240: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy403, &yymsp[-2].minor.yy5, yymsp[0].minor.yy652); }
        break;
      case 241: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy403, &yymsp[-3].minor.yy5, &yymsp[0].minor.yy5, false); }
        break;
      case 242: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy403, &yymsp[-5].minor.yy5, &yymsp[0].minor.yy5, true); }
        break;
      case 243: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy403, &yymsp[-3].minor.yy5, yymsp[0].minor.yy652, false); }
        break;
      case 244: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy403, &yymsp[-5].minor.yy5, yymsp[0].minor.yy652, true); }
        break;
      case 245: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy403, &yymsp[0].minor.yy5); }
        break;
      case 246: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy403, &yymsp[-2].minor.yy5, &yymsp[0].minor.yy5); }
        break;
      case 247: /* cmd ::= DESC full_table_name */
      case 248: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==248);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy652); }
        break;
      case 249: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 250: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy403, yymsp[-1].minor.yy652, yymsp[0].minor.yy652); }
        break;
      case 252: /* analyze_opt ::= ANALYZE */
      case 260: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==260);
      case 422: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==422);
{ yymsp[0].minor.yy403 = true; }
        break;
      case 253: /* explain_options ::= */
{ yymsp[1].minor.yy652 = createDefaultExplainOptions(pCxt); }
        break;
      case 254: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy652 = setExplainVerbose(pCxt, yymsp[-2].minor.yy652, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 255: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy652 = setExplainRatio(pCxt, yymsp[-2].minor.yy652, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 256: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy210); }
        break;
      case 257: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy403, yymsp[-8].minor.yy403, &yymsp[-5].minor.yy5, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy552, yymsp[0].minor.yy462); }
        break;
      case 258: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy403, &yymsp[0].minor.yy5); }
        break;
      case 261: /* bufsize_opt ::= */
{ yymsp[1].minor.yy462 = 0; }
        break;
      case 262: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy462 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 263: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy403, &yymsp[-4].minor.yy5, yymsp[-2].minor.yy652, yymsp[-3].minor.yy652, yymsp[0].minor.yy652); }
        break;
      case 264: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy403, &yymsp[0].minor.yy5); }
        break;
      case 266: /* into_opt ::= INTO full_table_name */
      case 403: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==403);
      case 432: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==432);
      case 455: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==455);
{ yymsp[-1].minor.yy652 = yymsp[0].minor.yy652; }
        break;
      case 268: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy652)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy652 = yymsp[-2].minor.yy652; }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 269: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy652)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy652 = yymsp[-2].minor.yy652; }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 270: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy652)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy652)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy652); yylhsminor.yy652 = yymsp[-3].minor.yy652; }
  yymsp[-3].minor.yy652 = yylhsminor.yy652;
        break;
      case 272: /* stream_options ::= stream_options IGNORE EXPIRED */
{ ((SStreamOptions*)yymsp[-2].minor.yy652)->ignoreExpired = true; yylhsminor.yy652 = yymsp[-2].minor.yy652; }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 273: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 274: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 275: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 276: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 277: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 278: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy210); }
        break;
      case 279: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 280: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy210 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 282: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy5); }
        break;
      case 283: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy652, yymsp[0].minor.yy652); }
        break;
      case 285: /* cmd ::= INSERT INTO full_table_name specific_cols_opt query_expression */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-2].minor.yy652, yymsp[-1].minor.yy210, yymsp[0].minor.yy652); }
        break;
      case 286: /* literal ::= NK_INTEGER */
{ yylhsminor.yy652 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 287: /* literal ::= NK_FLOAT */
{ yylhsminor.yy652 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 288: /* literal ::= NK_STRING */
{ yylhsminor.yy652 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 289: /* literal ::= NK_BOOL */
{ yylhsminor.yy652 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 290: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 291: /* literal ::= duration_literal */
      case 301: /* signed_literal ::= signed */ yytestcase(yyruleno==301);
      case 321: /* expression ::= literal */ yytestcase(yyruleno==321);
      case 322: /* expression ::= pseudo_column */ yytestcase(yyruleno==322);
      case 323: /* expression ::= column_reference */ yytestcase(yyruleno==323);
      case 324: /* expression ::= function_expression */ yytestcase(yyruleno==324);
      case 325: /* expression ::= subquery */ yytestcase(yyruleno==325);
      case 352: /* function_expression ::= literal_func */ yytestcase(yyruleno==352);
      case 394: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==394);
      case 398: /* boolean_primary ::= predicate */ yytestcase(yyruleno==398);
      case 400: /* common_expression ::= expression */ yytestcase(yyruleno==400);
      case 401: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==401);
      case 404: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==404);
      case 406: /* table_reference ::= table_primary */ yytestcase(yyruleno==406);
      case 407: /* table_reference ::= joined_table */ yytestcase(yyruleno==407);
      case 411: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==411);
      case 461: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==461);
      case 464: /* query_primary ::= query_specification */ yytestcase(yyruleno==464);
{ yylhsminor.yy652 = yymsp[0].minor.yy652; }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 292: /* literal ::= NULL */
{ yylhsminor.yy652 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 293: /* literal ::= NK_QUESTION */
{ yylhsminor.yy652 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 294: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy652 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 295: /* signed ::= NK_INTEGER */
{ yylhsminor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 296: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 297: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 298: /* signed ::= NK_FLOAT */
{ yylhsminor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 299: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 300: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 302: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 303: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 304: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 305: /* signed_literal ::= duration_literal */
      case 307: /* signed_literal ::= literal_func */ yytestcase(yyruleno==307);
      case 372: /* star_func_para ::= expression */ yytestcase(yyruleno==372);
      case 427: /* select_item ::= common_expression */ yytestcase(yyruleno==427);
      case 477: /* search_condition ::= common_expression */ yytestcase(yyruleno==477);
{ yylhsminor.yy652 = releaseRawExprNode(pCxt, yymsp[0].minor.yy652); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 306: /* signed_literal ::= NULL */
{ yylhsminor.yy652 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 326: /* expression ::= NK_LP expression NK_RP */
      case 399: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==399);
{ yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy652)); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 327: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy652));
                                                                                  }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 328: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy652), NULL));
                                                                                  }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 329: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652))); 
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 330: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652))); 
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 331: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652))); 
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 332: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652))); 
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 333: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652)));
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 334: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 335: /* expression ::= expression NK_BITAND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652)));
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 336: /* expression ::= expression NK_BITOR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652)));
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 339: /* column_reference ::= column_name */
{ yylhsminor.yy652 = createRawExprNode(pCxt, &yymsp[0].minor.yy5, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy5)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 340: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy5, &yymsp[0].minor.yy5, createColumnNode(pCxt, &yymsp[-2].minor.yy5, &yymsp[0].minor.yy5)); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 341: /* pseudo_column ::= ROWTS */
      case 342: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==342);
      case 344: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==344);
      case 345: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==345);
      case 346: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==346);
      case 347: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==347);
      case 348: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==348);
      case 354: /* literal_func ::= NOW */ yytestcase(yyruleno==354);
{ yylhsminor.yy652 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 343: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy5, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy5)))); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 349: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 350: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==350);
{ yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy5, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy5, yymsp[-1].minor.yy210)); }
  yymsp[-3].minor.yy652 = yylhsminor.yy652;
        break;
      case 351: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy652), yymsp[-1].minor.yy552)); }
  yymsp[-5].minor.yy652 = yylhsminor.yy652;
        break;
      case 353: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy5, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy5, NULL)); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 368: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy210 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy210 = yylhsminor.yy210;
        break;
      case 373: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 430: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==430);
{ yylhsminor.yy652 = createColumnNode(pCxt, &yymsp[-2].minor.yy5, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 374: /* predicate ::= expression compare_op expression */
      case 379: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==379);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy428, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652)));
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 375: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy652), releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652)));
                                                                                  }
  yymsp[-4].minor.yy652 = yylhsminor.yy652;
        break;
      case 376: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy652), releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652)));
                                                                                  }
  yymsp[-5].minor.yy652 = yylhsminor.yy652;
        break;
      case 377: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), NULL));
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 378: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy652), NULL));
                                                                                  }
  yymsp[-3].minor.yy652 = yylhsminor.yy652;
        break;
      case 380: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy428 = OP_TYPE_LOWER_THAN; }
        break;
      case 381: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy428 = OP_TYPE_GREATER_THAN; }
        break;
      case 382: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy428 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 383: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy428 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 384: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy428 = OP_TYPE_NOT_EQUAL; }
        break;
      case 385: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy428 = OP_TYPE_EQUAL; }
        break;
      case 386: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy428 = OP_TYPE_LIKE; }
        break;
      case 387: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy428 = OP_TYPE_NOT_LIKE; }
        break;
      case 388: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy428 = OP_TYPE_MATCH; }
        break;
      case 389: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy428 = OP_TYPE_NMATCH; }
        break;
      case 390: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy428 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 391: /* in_op ::= IN */
{ yymsp[0].minor.yy428 = OP_TYPE_IN; }
        break;
      case 392: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy428 = OP_TYPE_NOT_IN; }
        break;
      case 393: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy210)); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 395: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy652), NULL));
                                                                                  }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 396: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652)));
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 397: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy652);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy652);
                                                                                    yylhsminor.yy652 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), releaseRawExprNode(pCxt, yymsp[0].minor.yy652)));
                                                                                  }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 405: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy652 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy652, yymsp[0].minor.yy652, NULL); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 408: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy652 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy5, &yymsp[0].minor.yy5); }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 409: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy652 = createRealTableNode(pCxt, &yymsp[-3].minor.yy5, &yymsp[-1].minor.yy5, &yymsp[0].minor.yy5); }
  yymsp[-3].minor.yy652 = yylhsminor.yy652;
        break;
      case 410: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy652 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy652), &yymsp[0].minor.yy5); }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 412: /* alias_opt ::= */
{ yymsp[1].minor.yy5 = nil_token;  }
        break;
      case 413: /* alias_opt ::= table_alias */
{ yylhsminor.yy5 = yymsp[0].minor.yy5; }
  yymsp[0].minor.yy5 = yylhsminor.yy5;
        break;
      case 414: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy5 = yymsp[0].minor.yy5; }
        break;
      case 415: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 416: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==416);
{ yymsp[-2].minor.yy652 = yymsp[-1].minor.yy652; }
        break;
      case 417: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy652 = createJoinTableNode(pCxt, yymsp[-4].minor.yy74, yymsp[-5].minor.yy652, yymsp[-2].minor.yy652, yymsp[0].minor.yy652); }
  yymsp[-5].minor.yy652 = yylhsminor.yy652;
        break;
      case 418: /* join_type ::= */
{ yymsp[1].minor.yy74 = JOIN_TYPE_INNER; }
        break;
      case 419: /* join_type ::= INNER */
{ yymsp[0].minor.yy74 = JOIN_TYPE_INNER; }
        break;
      case 420: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy652 = createSelectStmt(pCxt, yymsp[-10].minor.yy403, yymsp[-9].minor.yy210, yymsp[-8].minor.yy652);
                                                                                    yymsp[-11].minor.yy652 = addWhereClause(pCxt, yymsp[-11].minor.yy652, yymsp[-7].minor.yy652);
                                                                                    yymsp[-11].minor.yy652 = addPartitionByClause(pCxt, yymsp[-11].minor.yy652, yymsp[-6].minor.yy210);
                                                                                    yymsp[-11].minor.yy652 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy652, yymsp[-2].minor.yy652);
                                                                                    yymsp[-11].minor.yy652 = addGroupByClause(pCxt, yymsp[-11].minor.yy652, yymsp[-1].minor.yy210);
                                                                                    yymsp[-11].minor.yy652 = addHavingClause(pCxt, yymsp[-11].minor.yy652, yymsp[0].minor.yy652);
                                                                                    yymsp[-11].minor.yy652 = addRangeClause(pCxt, yymsp[-11].minor.yy652, yymsp[-5].minor.yy652);
                                                                                    yymsp[-11].minor.yy652 = addEveryClause(pCxt, yymsp[-11].minor.yy652, yymsp[-4].minor.yy652);
                                                                                    yymsp[-11].minor.yy652 = addFillClause(pCxt, yymsp[-11].minor.yy652, yymsp[-3].minor.yy652);
                                                                                  }
        break;
      case 423: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy403 = false; }
        break;
      case 426: /* select_item ::= NK_STAR */
{ yylhsminor.yy652 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy652 = yylhsminor.yy652;
        break;
      case 428: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy652 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy652), &yymsp[0].minor.yy5); }
  yymsp[-1].minor.yy652 = yylhsminor.yy652;
        break;
      case 429: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy652 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), &yymsp[0].minor.yy5); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 434: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 451: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==451);
      case 467: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==467);
{ yymsp[-2].minor.yy210 = yymsp[0].minor.yy210; }
        break;
      case 436: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy652 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy652), releaseRawExprNode(pCxt, yymsp[-1].minor.yy652)); }
        break;
      case 437: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy652 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy652)); }
        break;
      case 438: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy652 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy652), NULL, yymsp[-1].minor.yy652, yymsp[0].minor.yy652); }
        break;
      case 439: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy652 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy652), releaseRawExprNode(pCxt, yymsp[-3].minor.yy652), yymsp[-1].minor.yy652, yymsp[0].minor.yy652); }
        break;
      case 441: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
      case 459: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==459);
{ yymsp[-3].minor.yy652 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy652); }
        break;
      case 443: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy652 = createFillNode(pCxt, yymsp[-1].minor.yy270, NULL); }
        break;
      case 444: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy652 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy210)); }
        break;
      case 445: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy270 = FILL_MODE_NONE; }
        break;
      case 446: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy270 = FILL_MODE_PREV; }
        break;
      case 447: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy270 = FILL_MODE_NULL; }
        break;
      case 448: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy270 = FILL_MODE_LINEAR; }
        break;
      case 449: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy270 = FILL_MODE_NEXT; }
        break;
      case 452: /* group_by_list ::= expression */
{ yylhsminor.yy210 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy652))); }
  yymsp[0].minor.yy210 = yylhsminor.yy210;
        break;
      case 453: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy210 = addNodeToList(pCxt, yymsp[-2].minor.yy210, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy652))); }
  yymsp[-2].minor.yy210 = yylhsminor.yy210;
        break;
      case 457: /* range_opt ::= RANGE NK_LP expression NK_COMMA expression NK_RP */
{ yymsp[-5].minor.yy652 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy652), releaseRawExprNode(pCxt, yymsp[-1].minor.yy652)); }
        break;
      case 460: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy652 = addOrderByClause(pCxt, yymsp[-3].minor.yy652, yymsp[-2].minor.yy210);
                                                                                    yylhsminor.yy652 = addSlimitClause(pCxt, yylhsminor.yy652, yymsp[-1].minor.yy652);
                                                                                    yylhsminor.yy652 = addLimitClause(pCxt, yylhsminor.yy652, yymsp[0].minor.yy652);
                                                                                  }
  yymsp[-3].minor.yy652 = yylhsminor.yy652;
        break;
      case 462: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy652 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy652, yymsp[0].minor.yy652); }
  yymsp[-3].minor.yy652 = yylhsminor.yy652;
        break;
      case 463: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy652 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy652, yymsp[0].minor.yy652); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 465: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ yymsp[-5].minor.yy652 = yymsp[-4].minor.yy652; }
  yy_destructor(yypParser,369,&yymsp[-3].minor);
  yy_destructor(yypParser,370,&yymsp[-2].minor);
  yy_destructor(yypParser,371,&yymsp[-1].minor);
        break;
      case 469: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 473: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==473);
{ yymsp[-1].minor.yy652 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 470: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 474: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==474);
{ yymsp[-3].minor.yy652 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 471: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 475: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==475);
{ yymsp[-3].minor.yy652 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 476: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy652 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy652); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 480: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy652 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy652), yymsp[-1].minor.yy553, yymsp[0].minor.yy477); }
  yymsp[-2].minor.yy652 = yylhsminor.yy652;
        break;
      case 481: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy553 = ORDER_ASC; }
        break;
      case 482: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy553 = ORDER_ASC; }
        break;
      case 483: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy553 = ORDER_DESC; }
        break;
      case 484: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy477 = NULL_ORDER_DEFAULT; }
        break;
      case 485: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy477 = NULL_ORDER_FIRST; }
        break;
      case 486: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy477 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
