/*
 * Copyright (c) 2019 TAOS Data, Inc. <jhtao@taosdata.com>
 *
 * This program is free software: you can use, redistribute, and/or modify
 * it under the terms of the GNU Affero General Public License, version 3
 * or later ("AGPL"), as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef TDENGINE_HEAP_H
#define TDENGINE_HEAP_H

#ifdef __cplusplus
extern "C" {
#endif

#include "os.h"

struct HeapNode;

/* Return non-zero if a < b. */
typedef int (*HeapCompareFn)(const struct HeapNode* a, const struct HeapNode* b);

typedef struct HeapNode {
  struct HeapNode* left;
  struct HeapNode* right;
  struct HeapNode* parent;
} HeapNode;

/* A binary min heap.  The usual properties hold: the root is the lowest
 * element in the set, the height of the tree is at most log2(nodes) and
 * it's always a complete binary tree.
 *
 */
typedef struct {
  HeapNode* min;
  size_t nelts;
  HeapCompareFn compFn;  
} Heap;


Heap* heapCreate(HeapCompareFn fn);

void heapDestroy(Heap *heap);

HeapNode* heapMin(const Heap* heap);

void heapInsert(Heap* heap, HeapNode* node);

void heapRemove(Heap* heap, struct HeapNode* node);

void heapDequeue(Heap* heap);

size_t heapSize(Heap *heap);

#ifdef __cplusplus
}
#endif

#endif  // TDENGINE_HASH_H
