/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 277
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EFillMode yy6;
  EJoinType yy10;
  SNode* yy46;
  SToken yy95;
  SAlterOption yy145;
  bool yy151;
  SNodeList* yy194;
  int32_t yy202;
  ENullOrder yy273;
  EOperatorType yy292;
  SDataType yy400;
  EOrder yy456;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYNSTATE             445
#define YYNRULE              357
#define YYNTOKEN             179
#define YY_MAX_SHIFT         444
#define YY_MIN_SHIFTREDUCE   691
#define YY_MAX_SHIFTREDUCE   1047
#define YY_ERROR_ACTION      1048
#define YY_ACCEPT_ACTION     1049
#define YY_NO_ACTION         1050
#define YY_MIN_REDUCE        1051
#define YY_MAX_REDUCE        1407
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1352)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1264,  344,   24,  174,  363,  363,  258,  243, 1260, 1267,
 /*    10 */  1230, 1231,   31,   29,   27,   26,   25, 1277,  376,  376,
 /*    20 */     9,    8,   95,   69,   69,   31,   29,   27,   26,   25,
 /*    30 */   293,  299,  344, 1386,  108,   62, 1063, 1293,  376, 1154,
 /*    40 */  1154,  348, 1145,  262,  360,   96,  120,  217, 1094,  251,
 /*    50 */  1384,   93, 1146,   95,  362,  375, 1221, 1223, 1251, 1154,
 /*    60 */   217,  167, 1332,  343,  112,  342, 1097,   46, 1386,  923,
 /*    70 */    65, 1278, 1279, 1282, 1325, 1194,   92,  953,  233, 1321,
 /*    80 */  1398,  120,   93, 1251, 1149, 1384,  109, 1121,  966, 1359,
 /*    90 */   953,  346,  116, 1332, 1333,  272, 1337,  429,  428,  427,
 /*   100 */   426,  425,  424,  423,  422,  421,  420,  419,  418,  417,
 /*   110 */   416,  415,  414,  413,  412,  305,  954,  300,  375, 1293,
 /*   120 */   304, 1132,  908,  303, 1049,  301,  360,   80,  302,  954,
 /*   130 */    79,   78,   77,   76,   75,   74,   73,   72,   71,  317,
 /*   140 */   126,  125,   23,  238,  948,  949,  950,  951,  952,  956,
 /*   150 */   957,  958,  315,  375,  334,   23,  238,  948,  949,  950,
 /*   160 */   951,  952,  956,  957,  958, 1277,   12,  284,   31,   29,
 /*   170 */    27,   26,   25,  255,  800,  399,  398,  397,  804,  396,
 /*   180 */   806,  807,  395,  809,  392, 1293,  815,  389,  817,  818,
 /*   190 */   386,  383,  360,   31,   29,   27,   26,   25,  231, 1201,
 /*   200 */  1386,   12,  362, 1074,   30,   28, 1251,  257, 1277,  256,
 /*   210 */  1222,  348,  240,  120,  888, 1264, 1386, 1384,   64, 1278,
 /*   220 */  1279, 1282, 1325, 1260, 1266,  923,  216, 1321, 1293, 1385,
 /*   230 */   886,   46,  121, 1384,  912,  347,  333,  376, 1386,   11,
 /*   240 */   247,  246,  263,  297, 1251,  362, 1218,  296, 1150, 1251,
 /*   250 */   901,  120,  121,  124, 1277, 1384,  121, 1073, 1154,  284,
 /*   260 */     1,   65, 1278, 1279, 1282, 1325,  894,  376,  298,  233,
 /*   270 */  1321,  115,  283,  264, 1293,  339,  335,   30,   28,  990,
 /*   280 */   248,  360,  910,  170,  441,  240,    6,  888, 1154,  326,
 /*   290 */  1352,  362,   30,   28, 1293, 1251,  887, 1264, 1251,  215,
 /*   300 */   240,  360,  888,  886, 1044, 1260, 1266,   66, 1278, 1279,
 /*   310 */  1282, 1325,   11, 1052, 1072, 1324, 1321, 1339,  886, 1014,
 /*   320 */   377,  913,  889,  319,  892,  893,  206,   11,  936,  337,
 /*   330 */   437,  436,  897,    1,   80, 1336,  169,   79,   78,   77,
 /*   340 */    76,   75,   74,   73,   72,   71,  121, 1130,    1, 1051,
 /*   350 */   330, 1012, 1013, 1015, 1016, 1251, 1043,  441,  902, 1071,
 /*   360 */   905,  893,  376,  320, 1070, 1277,  376, 1151,  989,  887,
 /*   370 */  1271,  373,  441,   89,   88,   87,   86,   85,   84,   83,
 /*   380 */    82,   81, 1269, 1154,  887, 1293,  107, 1154, 1277,  338,
 /*   390 */  1386, 1069,  347,  411, 1157,  889,  985,  892,  893,  206,
 /*   400 */  1251,  936,  362,  120,  351, 1251, 1251, 1384, 1293,  121,
 /*   410 */   889, 1277,  892,  893,  206,  360,  936,  727,   65, 1278,
 /*   420 */  1279, 1282, 1325,  155, 1201,  362,  233, 1321,  115, 1251,
 /*   430 */   230, 1293, 1251,  291,  344, 1199, 1339,  728,  360,  727,
 /*   440 */  1068,   65, 1278, 1279, 1282, 1325,   55, 1353,  362,  233,
 /*   450 */  1321, 1398, 1251,  355, 1335,   95,  955,  729, 1067, 1339,
 /*   460 */  1382,   30,   28, 1147,   65, 1278, 1279, 1282, 1325,  240,
 /*   470 */  1277,  888,  233, 1321, 1398, 1131,  911, 1334,   30,   28,
 /*   480 */   361, 1251,   21, 1343,   93,  411,  240,  886,  888,  909,
 /*   490 */  1293,  959,   30,   28,  117, 1332, 1333,  360, 1337, 1251,
 /*   500 */   240, 1066,  888,  194,  886,  244, 1184,  362, 1065,  376,
 /*   510 */  1062, 1251,  141,  107,  374,  139,  348,    7,  886,  988,
 /*   520 */  1061, 1156,  402,  207, 1278, 1279, 1282,  322,  224, 1201,
 /*   530 */  1154, 1064,  408, 1060,    7,  245,  407,   30,   28,  101,
 /*   540 */  1199,  441, 1251, 1386, 1201,  240,  356,  888,    7, 1251,
 /*   550 */   297, 1251,   61,  887,  296, 1200,  120,  409,  441,  997,
 /*   560 */  1384, 1251,   57,  886,  225,  910,  223,  222, 1277,  295,
 /*   570 */   887,  350,  441, 1143, 1251,  298,  406,  405,  404,  889,
 /*   580 */   403,  892,  893,  206,  887,  936, 1139,  376, 1293, 1344,
 /*   590 */   985, 1277,  188,    1,  359,  360,  889, 1141,  892,  893,
 /*   600 */   206,  143,  936,  121,  142,  362,    9,    8, 1154, 1251,
 /*   610 */   889, 1293,  892,  893,  206,  376,  936,  441,  360,  250,
 /*   620 */   254,   66, 1278, 1279, 1282, 1325, 1137,  107,  362,  887,
 /*   630 */  1322, 1201, 1251,  199, 1059, 1156, 1154,  252,  201,   27,
 /*   640 */    26,   25, 1199, 1277,   66, 1278, 1279, 1282, 1325, 1277,
 /*   650 */   200,  344,  358, 1321, 1277,  889,  896,  892,  893,  206,
 /*   660 */   127,  936,  935, 1293,  937,  938,  939,  940,  941, 1293,
 /*   670 */   360, 1011,   95, 1058, 1293, 1251,  360, 1057, 1056,  945,
 /*   680 */   362,  360, 1055,   42, 1251,  145,  362, 1054,  144,  147,
 /*   690 */  1251,  362,  146,  239, 1122, 1251,  110, 1278, 1279, 1282,
 /*   700 */  1277,   93,  211, 1278, 1279, 1282, 1277,  110, 1278, 1279,
 /*   710 */  1282,  118, 1332, 1333, 1251, 1337,  253,  352, 1251, 1251,
 /*   720 */  1293,   67,  899, 1251,  107,  171, 1293,  360, 1251, 1090,
 /*   730 */  1277,  401, 1156,  360,  349, 1399,  888,  362,   44,   43,
 /*   740 */   261, 1251,  122,  362,  327,  331, 1400, 1251, 1046, 1047,
 /*   750 */  1293,  306,  886,  211, 1278, 1279, 1282,  360, 1085,  210,
 /*   760 */  1278, 1279, 1282,  908, 1195,  160,  960,  362, 1277,  121,
 /*   770 */   265, 1251, 1083,  277,  237,  895,  164,  158,   32,  444,
 /*   780 */   308,  290,  278,  211, 1278, 1279, 1282,   20, 1293, 1355,
 /*   790 */   345,  340, 1294,  191,  311,  360,   91,   31,   29,   27,
 /*   800 */    26,   25,  433,   22,  190,  362,  441,  920,  353, 1251,
 /*   810 */   173, 1277,  241,   31,   29,   27,   26,   25,  887,   32,
 /*   820 */   872,  211, 1278, 1279, 1282,  179,    2,   63,  368,  881,
 /*   830 */   186, 1293,   32,  185,  908,  192, 1220,  177,  360,  793,
 /*   840 */    98,  898, 1277,  123,  889,   99,  892,  893,  362,  266,
 /*   850 */   276,  101, 1251,  271,  270,  269,  268,  267,  788,  273,
 /*   860 */   274,  372, 1293,  821,  209, 1278, 1279, 1282,  825,  360,
 /*   870 */    42,  275,  831, 1277,  279,  381,  916,  280,  325,  362,
 /*   880 */    99,  151, 1277, 1251,  100,  128,   31,   29,   27,   26,
 /*   890 */    25,  830,  281, 1293,  102,  212, 1278, 1279, 1282,  915,
 /*   900 */   360,  282, 1293,  101, 1277,  131,   99,   45,  285,  360,
 /*   910 */   362,  134,  914, 1277, 1251,  294,  292,  229, 1144,  362,
 /*   920 */   138, 1140,   90, 1251, 1293,  140,  204, 1278, 1279, 1282,
 /*   930 */   321,  360,  103, 1293, 1129,  213, 1278, 1279, 1282,  150,
 /*   940 */   360,  362,  104, 1277, 1142, 1251,  324, 1138,  105,  106,
 /*   950 */   362, 1277,  153,  913, 1251,  332,  366,  205, 1278, 1279,
 /*   960 */  1282, 1356,  323, 1293, 1366,  156,  214, 1278, 1279, 1282,
 /*   970 */   360, 1293,  329,  893, 1277, 1365,    5,  305,  360,  300,
 /*   980 */   362,  159,  304,  341, 1251,  303,  232,  301,  362,  336,
 /*   990 */   302,  408, 1251,  328, 1293,  407, 1290, 1278, 1279, 1282,
 /*  1000 */   163,  360,    4,  985, 1289, 1278, 1279, 1282,  912,  113,
 /*  1010 */  1346,  362,  165, 1277,   94, 1251,  409, 1340,   33,  166,
 /*  1020 */   234, 1277,  357,  354,   17, 1307, 1229, 1288, 1278, 1279,
 /*  1030 */  1282, 1401,  172, 1293,  364,  406,  405,  404, 1383,  403,
 /*  1040 */   360, 1293,  365,  242, 1277, 1228,  369,  370,  360,  371,
 /*  1050 */   362,  181, 1277,  183, 1251,  310,  193, 1155,  362,   54,
 /*  1060 */    56,  195, 1251,  189, 1293,  379,  220, 1278, 1279, 1282,
 /*  1070 */   318,  360, 1293,  440,  219, 1278, 1279, 1282,  202,  360,
 /*  1080 */   203,  362,  197, 1277,  149, 1251,  198,  313, 1245,  362,
 /*  1090 */   884,   39,  307, 1251,  883,  148, 1239,  221, 1278, 1279,
 /*  1100 */  1282, 1238,  259, 1293,  260,  218, 1278, 1279, 1282, 1237,
 /*  1110 */   360, 1236,  855, 1213, 1212,   97, 1211, 1210,   41,  136,
 /*  1120 */   362,   40,  114, 1209, 1251, 1208, 1207, 1206,  289,  857,
 /*  1130 */   135, 1205, 1204, 1203, 1202, 1096,  208, 1278, 1279, 1282,
 /*  1140 */  1235, 1226,  130, 1133, 1095,  740, 1093,  288,  286, 1082,
 /*  1150 */  1081,  287, 1078,   47, 1135,   70,  133,  137,  838,  837,
 /*  1160 */   836, 1134,  768, 1091,  226, 1086,  767,  766,  765,  227,
 /*  1170 */  1084, 1077, 1076,  228,  764,  763,   68,  314,  309,  316,
 /*  1180 */  1234, 1233,   36,  312, 1225,  154,   48,    3,   14,   32,
 /*  1190 */   111,  152,   15,   37,   34,   10,   51,    8,  946,  367,
 /*  1200 */   162,  184,  832,  132, 1224, 1050, 1050,  129, 1050, 1050,
 /*  1210 */  1050, 1050, 1050, 1050, 1050, 1050, 1050, 1032, 1050, 1050,
 /*  1220 */  1031,  235,  157, 1036, 1035,  236, 1050, 1010,  161, 1050,
 /*  1230 */   903, 1004,   49,  182, 1050, 1003,   50, 1050,  982, 1269,
 /*  1240 */  1050,  829,  981, 1050, 1050, 1037, 1050, 1050,   19, 1050,
 /*  1250 */  1050, 1050, 1050, 1050,  168, 1050,   35,  119,  921,   16,
 /*  1260 */   176,   13,   18,  380,  249, 1008,  178,  180,  175,   52,
 /*  1270 */    53,  384,  387, 1050, 1050,   57, 1092,  390, 1050, 1050,
 /*  1280 */  1268,  393,  799, 1050, 1050,  187,   38, 1050,  827,  760,
 /*  1290 */   738,  822,  382,  752,  438, 1050, 1050,  819,  816,  385,
 /*  1300 */   378,  810,  833,  828,  388,  391,  759,  758,  757,  808,
 /*  1310 */   410,  756, 1080, 1079,  394,  430,  755,  814, 1075,  754,
 /*  1320 */   753,  751,  439,  442,  750,  749,  435,   58,  748,   59,
 /*  1330 */    60,  747,  746,  890,  432,  443,  745,  744,  743,  431,
 /*  1340 */   400,  196,  434,  813, 1050, 1050, 1050, 1050, 1050,  812,
 /*  1350 */  1050,  811,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   223,  188,  240,  241,  219,  219,  228,  222,  231,  232,
 /*    10 */   225,  225,   12,   13,   14,   15,   16,  182,  188,  188,
 /*    20 */     1,    2,  209,  193,  193,   12,   13,   14,   15,   16,
 /*    30 */   200,  200,  188,  255,  181,  187,  183,  202,  188,  209,
 /*    40 */   209,  228,  182,  193,  209,  197,  268,   47,    0,  211,
 /*    50 */   272,  238,  204,  209,  219,   20,  218,  219,  223,  209,
 /*    60 */    47,  248,  249,  250,  201,  252,    0,  190,  255,   69,
 /*    70 */   235,  236,  237,  238,  239,  212,  199,   77,  243,  244,
 /*    80 */   245,  268,  238,  223,  207,  272,  191,  192,   69,  254,
 /*    90 */    77,  247,  248,  249,  250,   63,  252,   49,   50,   51,
 /*   100 */    52,   53,   54,   55,   56,   57,   58,   59,   60,   61,
 /*   110 */    62,   63,   64,   65,   66,   49,  116,   51,   20,  202,
 /*   120 */    54,    0,   20,   57,  179,   59,  209,   21,   62,  116,
 /*   130 */    24,   25,   26,   27,   28,   29,   30,   31,   32,   21,
 /*   140 */   108,  109,  142,  143,  144,  145,  146,  147,  148,  149,
 /*   150 */   150,  151,   34,   20,  237,  142,  143,  144,  145,  146,
 /*   160 */   147,  148,  149,  150,  151,  182,   68,   46,   12,   13,
 /*   170 */    14,   15,   16,  228,   83,   84,   85,   86,   87,   88,
 /*   180 */    89,   90,   91,   92,   93,  202,   95,   96,   97,   98,
 /*   190 */    99,  100,  209,   12,   13,   14,   15,   16,  206,  202,
 /*   200 */   255,   68,  219,  182,   12,   13,  223,  129,  182,  131,
 /*   210 */   213,  228,   20,  268,   22,  223,  255,  272,  235,  236,
 /*   220 */   237,  238,  239,  231,  232,   69,  243,  244,  202,  268,
 /*   230 */    38,  190,  154,  272,   20,  209,  120,  188,  255,   47,
 /*   240 */    12,   13,  193,   57,  223,  219,  209,   61,  207,  223,
 /*   250 */    22,  268,  154,  216,  182,  272,  154,  182,  209,   46,
 /*   260 */    68,  235,  236,  237,  238,  239,   38,  188,   82,  243,
 /*   270 */   244,  245,  193,  188,  202,  159,  160,   12,   13,   14,
 /*   280 */   206,  209,   20,  257,   92,   20,   43,   22,  209,  263,
 /*   290 */   264,  219,   12,   13,  202,  223,  104,  223,  223,  214,
 /*   300 */    20,  209,   22,   38,  123,  231,  232,  235,  236,  237,
 /*   310 */   238,  239,   47,    0,  182,  243,  244,  233,   38,  132,
 /*   320 */    92,   20,  130,  188,  132,  133,  134,   47,  136,  237,
 /*   330 */   185,  186,  104,   68,   21,  251,  122,   24,   25,   26,
 /*   340 */    27,   28,   29,   30,   31,   32,  154,    0,   68,    0,
 /*   350 */   163,  164,  165,  166,  167,  223,  175,   92,  130,  182,
 /*   360 */   132,  133,  188,  228,  182,  182,  188,  193,    4,  104,
 /*   370 */    68,  193,   92,   24,   25,   26,   27,   28,   29,   30,
 /*   380 */    31,   32,   80,  209,  104,  202,  202,  209,  182,   20,
 /*   390 */   255,  182,  209,   46,  210,  130,  153,  132,  133,  134,
 /*   400 */   223,  136,  219,  268,    3,  223,  223,  272,  202,  154,
 /*   410 */   130,  182,  132,  133,  134,  209,  136,   22,  235,  236,
 /*   420 */   237,  238,  239,  122,  202,  219,  243,  244,  245,  223,
 /*   430 */   208,  202,  223,   38,  188,  213,  233,   20,  209,   22,
 /*   440 */   182,  235,  236,  237,  238,  239,  187,  264,  219,  243,
 /*   450 */   244,  245,  223,   81,  251,  209,  116,   40,  182,  233,
 /*   460 */   254,   12,   13,  204,  235,  236,  237,  238,  239,   20,
 /*   470 */   182,   22,  243,  244,  245,    0,   20,  251,   12,   13,
 /*   480 */    14,  223,  142,  254,  238,   46,   20,   38,   22,   20,
 /*   490 */   202,  151,   12,   13,  248,  249,  250,  209,  252,  223,
 /*   500 */    20,  182,   22,  195,   38,  194,  198,  219,  182,  188,
 /*   510 */   182,  223,   72,  202,  193,   75,  228,   68,   38,  155,
 /*   520 */   182,  210,   79,  235,  236,  237,  238,   69,   35,  202,
 /*   530 */   209,  183,   57,  182,   68,  208,   61,   12,   13,   81,
 /*   540 */   213,   92,  223,  255,  202,   20,  174,   22,   68,  223,
 /*   550 */    57,  223,   68,  104,   61,  213,  268,   82,   92,   14,
 /*   560 */   272,  223,   78,   38,   71,   20,   73,   74,  182,   76,
 /*   570 */   104,  170,   92,  203,  223,   82,  101,  102,  103,  130,
 /*   580 */   105,  132,  133,  134,  104,  136,  203,  188,  202,  152,
 /*   590 */   153,  182,  193,   68,   47,  209,  130,  203,  132,  133,
 /*   600 */   134,   72,  136,  154,   75,  219,    1,    2,  209,  223,
 /*   610 */   130,  202,  132,  133,  134,  188,  136,   92,  209,  194,
 /*   620 */   193,  235,  236,  237,  238,  239,  203,  202,  219,  104,
 /*   630 */   244,  202,  223,   18,  182,  210,  209,  208,   23,   14,
 /*   640 */    15,   16,  213,  182,  235,  236,  237,  238,  239,  182,
 /*   650 */    35,  188,  243,  244,  182,  130,   38,  132,  133,  134,
 /*   660 */    45,  136,  135,  202,  137,  138,  139,  140,  141,  202,
 /*   670 */   209,   69,  209,  182,  202,  223,  209,  182,  182,  132,
 /*   680 */   219,  209,  182,   81,  223,   72,  219,  182,   75,   72,
 /*   690 */   223,  219,   75,  226,  192,  223,  235,  236,  237,  238,
 /*   700 */   182,  238,  235,  236,  237,  238,  182,  235,  236,  237,
 /*   710 */   238,  248,  249,  250,  223,  252,  194,   81,  223,  223,
 /*   720 */   202,  106,  104,  223,  202,  275,  202,  209,  223,    0,
 /*   730 */   182,  203,  210,  209,  273,  274,   22,  219,  123,  124,
 /*   740 */   125,  223,  127,  219,  226,  266,  274,  223,  177,  178,
 /*   750 */   202,   22,   38,  235,  236,  237,  238,  209,    0,  235,
 /*   760 */   236,  237,  238,   20,  212,   69,   69,  219,  182,  154,
 /*   770 */    27,  223,    0,   30,  226,   38,  260,   81,   81,   19,
 /*   780 */    22,  185,   39,  235,  236,  237,  238,    2,  202,  234,
 /*   790 */   253,  267,  202,   33,   22,  209,   36,   12,   13,   14,
 /*   800 */    15,   16,   42,    2,   44,  219,   92,   69,  172,  223,
 /*   810 */   269,  182,  226,   12,   13,   14,   15,   16,  104,   81,
 /*   820 */    69,  235,  236,  237,  238,   69,  256,   67,   69,  128,
 /*   830 */    70,  202,   81,   69,   20,  229,  188,   81,  209,   69,
 /*   840 */    81,  104,  182,  115,  130,   81,  132,  133,  219,  217,
 /*   850 */   107,   81,  223,  110,  111,  112,  113,  114,   69,  215,
 /*   860 */   116,  101,  202,   69,  235,  236,  237,  238,   69,  209,
 /*   870 */    81,  215,   69,  182,  188,   81,   20,  227,  118,  219,
 /*   880 */    81,  121,  182,  223,   81,  190,   12,   13,   14,   15,
 /*   890 */    16,   69,  209,  202,   69,  235,  236,  237,  238,   20,
 /*   900 */   209,  220,  202,   81,  182,  190,   81,  190,  188,  209,
 /*   910 */   219,  190,   20,  182,  223,  202,  184,  184,  202,  219,
 /*   920 */   202,  202,  188,  223,  202,  202,  235,  236,  237,  238,
 /*   930 */   227,  209,  202,  202,    0,  235,  236,  237,  238,  187,
 /*   940 */   209,  219,  202,  182,  202,  223,  220,  202,  202,  202,
 /*   950 */   219,  182,  187,   20,  223,  162,  161,  235,  236,  237,
 /*   960 */   238,  234,  209,  202,  265,  224,  235,  236,  237,  238,
 /*   970 */   209,  202,  223,  133,  182,  265,  169,   49,  209,   51,
 /*   980 */   219,  224,   54,  168,  223,   57,  223,   59,  219,  223,
 /*   990 */    62,   57,  223,  157,  202,   61,  235,  236,  237,  238,
 /*  1000 */   261,  209,  156,  153,  235,  236,  237,  238,   20,  259,
 /*  1010 */   262,  219,  258,  182,  209,  223,   82,  233,  115,  246,
 /*  1020 */   176,  182,  173,  171,   68,  242,  224,  235,  236,  237,
 /*  1030 */   238,  276,  270,  202,  223,  101,  102,  103,  271,  105,
 /*  1040 */   209,  202,  223,  223,  182,  224,  119,  221,  209,  220,
 /*  1050 */   219,  209,  182,  187,  223,    4,  198,  209,  219,  187,
 /*  1060 */    68,  188,  223,  187,  202,  205,  235,  236,  237,  238,
 /*  1070 */    19,  209,  202,  184,  235,  236,  237,  238,  196,  209,
 /*  1080 */   196,  219,  189,  182,   33,  223,  180,   36,    0,  219,
 /*  1090 */   104,  230,   41,  223,  130,   44,    0,  235,  236,  237,
 /*  1100 */   238,    0,   50,  202,  126,  235,  236,  237,  238,    0,
 /*  1110 */   209,    0,   80,    0,    0,  115,    0,    0,   67,   33,
 /*  1120 */   219,   70,   36,    0,  223,    0,    0,    0,   42,   22,
 /*  1130 */    44,    0,    0,    0,    0,    0,  235,  236,  237,  238,
 /*  1140 */     0,    0,   43,    0,    0,   48,    0,   43,   38,    0,
 /*  1150 */     0,   36,    0,   67,    0,   77,   70,   75,   38,   38,
 /*  1160 */    22,    0,   38,    0,   22,    0,   38,   38,   38,   22,
 /*  1170 */     0,    0,    0,   22,   38,   38,   20,   22,   39,   22,
 /*  1180 */     0,    0,  122,   38,    0,  117,   68,   81,  158,   81,
 /*  1190 */    68,   43,  158,   81,  152,  158,    4,    2,  132,  120,
 /*  1200 */    81,  117,  104,  117,    0,  277,  277,  121,  277,  277,
 /*  1210 */   277,  277,  277,  277,  277,  277,  277,   38,  277,  277,
 /*  1220 */    38,   38,   69,   38,   38,   38,  277,   69,   68,  277,
 /*  1230 */    22,   69,   68,   43,  277,   69,   68,  277,   69,   80,
 /*  1240 */   277,   38,   69,  277,  277,   69,  277,  277,   81,  277,
 /*  1250 */   277,  277,  277,  277,   80,  277,   81,   80,   69,   81,
 /*  1260 */    69,   68,   68,   38,   38,   69,   68,   68,   80,   68,
 /*  1270 */    68,   38,   38,  277,  277,   78,    0,   38,  277,  277,
 /*  1280 */    80,   38,   22,  277,  277,   80,   68,  277,   22,   22,
 /*  1290 */    48,   69,   68,   22,   22,  277,  277,   69,   69,   68,
 /*  1300 */    79,   69,   38,   38,   68,   68,   38,   38,   38,   69,
 /*  1310 */    47,   38,    0,    0,   68,   38,   38,   94,    0,   38,
 /*  1320 */    38,   38,   21,   21,   38,   38,   37,   68,   38,   68,
 /*  1330 */    68,   38,   38,   22,   43,   20,   38,   38,   38,   36,
 /*  1340 */    82,   22,   38,   94,  277,  277,  277,  277,  277,   94,
 /*  1350 */   277,   94,  277,  277,  277,  277,  277,  277,  277,  277,
 /*  1360 */   277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
 /*  1370 */   277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
 /*  1380 */   277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
 /*  1390 */   277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
 /*  1400 */   277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
 /*  1410 */   277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
 /*  1420 */   277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
 /*  1430 */   277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
 /*  1440 */   277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
 /*  1450 */   277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
 /*  1460 */   277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
 /*  1470 */   277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
 /*  1480 */   277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
 /*  1490 */   277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
 /*  1500 */   277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
 /*  1510 */   277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
 /*  1520 */   277,  277,  277,  277,  277,  277,  277,  277,  277,  277,
 /*  1530 */   277,
};
#define YY_SHIFT_COUNT    (444)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1319)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   615,  192,  265,  280,  280,  280,  280,  449,  280,  280,
 /*    10 */   480,  525,   98,  466,  480,  480,  480,  480,  480,  480,
 /*    20 */   480,  480,  480,  480,  480,  480,  480,  480,  480,  480,
 /*    30 */   480,  480,  480,  133,  133,  133,  102,  228,  228,   78,
 /*    40 */    35,   35,  228,   35,   35,   35,   35,  213,  262,  369,
 /*    50 */   369,  255,  456,  262,   35,   35,  262,   35,  262,  456,
 /*    60 */   262,  262,   35,  439,    0,   13,   13,  743,  106,  493,
 /*    70 */   714,  714,  714,  714,  714,  714,  714,  714,  714,  714,
 /*    80 */   714,  714,  714,  714,  714,  714,  714,  714,  714,  714,
 /*    90 */   928,  417,  121,  214,  214,  214,  347,  469,  456,  262,
 /*   100 */   262,  262,  443,   91,   91,   91,   91,   91,  313,   66,
 /*   110 */   181,  187,  186,  116,  395,  301,  437,  243,  437,  545,
 /*   120 */   401,  364,  701,  814,  728,  744,  744,  814,  856,  213,
 /*   130 */   469,  879,  213,  213,  814,  213,  892,  262,  262,  262,
 /*   140 */   262,  262,  262,  262,  262,  262,  262,  262,  814,  892,
 /*   150 */   856,  439,  469,  879,  439,  933,  793,  795,  840,  793,
 /*   160 */   795,  840,  840,  807,  815,  836,  846,  850,  469,  988,
 /*   170 */   903,  844,  849,  852,  956,  262,  795,  840,  840,  795,
 /*   180 */   840,  927,  469,  879,  439,  443,  439,  469,  992,  814,
 /*   190 */   439,  892, 1352, 1352, 1352, 1352, 1352,   48,  349,  760,
 /*   200 */  1086, 1051,  475,  934,  785,  801,  527,  156,  874,  874,
 /*   210 */   874,  874,  874,  874,  874,   32,   19,  340,  625,  625,
 /*   220 */   625,  625,  440,  529,  613,  617,  729,  758,  772,  118,
 /*   230 */   458,  602,  696,  605,  571,  636,  372,  697,  547,  738,
 /*   240 */   302,  751,  756,  759,  764,  770,  618,  737,  789,  794,
 /*   250 */   799,  803,  822,  825,  484, 1088,  986,  964, 1096, 1101,
 /*   260 */  1052,  978, 1109, 1111, 1032, 1113, 1114, 1000, 1116, 1117,
 /*   270 */  1123, 1125, 1126, 1127, 1107, 1131, 1132, 1133, 1134, 1135,
 /*   280 */  1140, 1141, 1099, 1143, 1097, 1144, 1146, 1110, 1115, 1104,
 /*   290 */  1149, 1150, 1152, 1154, 1078, 1082, 1120, 1121, 1138, 1161,
 /*   300 */  1124, 1128, 1129, 1130, 1136, 1137, 1163, 1142, 1165, 1147,
 /*   310 */  1139, 1170, 1151, 1145, 1171, 1155, 1172, 1157, 1156, 1180,
 /*   320 */  1181, 1060, 1184, 1118, 1148, 1068, 1106, 1108, 1030, 1153,
 /*   330 */  1112, 1158, 1122, 1160, 1162, 1164, 1166, 1119, 1159, 1168,
 /*   340 */  1167, 1034, 1169, 1173, 1174, 1042, 1175, 1177, 1176, 1178,
 /*   350 */  1037, 1192, 1179, 1182, 1183, 1185, 1186, 1187, 1195, 1066,
 /*   360 */  1188, 1189, 1193, 1194, 1191, 1196, 1198, 1199, 1079, 1201,
 /*   370 */  1204, 1190, 1084, 1202, 1197, 1200, 1205, 1208, 1218, 1221,
 /*   380 */  1222, 1225, 1226, 1224, 1228, 1233, 1231, 1229, 1234, 1236,
 /*   390 */  1232, 1239, 1237, 1240, 1243, 1246, 1223, 1249, 1255, 1257,
 /*   400 */  1260, 1258, 1259, 1264, 1098, 1261, 1262, 1203, 1265, 1266,
 /*   410 */  1242, 1263, 1267, 1268, 1269, 1270, 1273, 1278, 1281, 1282,
 /*   420 */  1271, 1283, 1286, 1287, 1290, 1293, 1294, 1298, 1299, 1300,
 /*   430 */  1276, 1277, 1303, 1291, 1312, 1304, 1289, 1313, 1318, 1272,
 /*   440 */  1301, 1311, 1319, 1302, 1315,
};
#define YY_REDUCE_COUNT (196)
#define YY_REDUCE_MIN   (-238)
#define YY_REDUCE_MAX   (906)
static const short yy_reduce_ofst[] = {
 /*     0 */   -55,  -17,   26,  183, -165,  206,  229,  288,   72,  409,
 /*    10 */   461,  386, -187,  467,  518,  524,  472,  548,  586,  629,
 /*    20 */   660,  691,  700,  722,  731,  761,  769,  792,  831,  839,
 /*    30 */   862,  870,  901, -156,  246,  463,  135,   -8,   74, -222,
 /*    40 */  -170, -169, -223, -150,   49,   79,  174, -123,  222,  -83,
 /*    50 */    92,  -39, -215,  311,  178,  321,  327,  399,  425, -162,
 /*    60 */   429,  522,  427, -152, -238, -238, -238,   85, -147, -137,
 /*    70 */  -140,   21,   75,  132,  177,  182,  209,  258,  276,  319,
 /*    80 */   326,  328,  338,  351,  452,  491,  495,  496,  500,  505,
 /*    90 */  -105,  145,   41,   84,  203,  226,  259,   37, -214,  184,
 /*   100 */    -3,  342,  308,  370,  383,  394,  423,  528,  348,  502,
 /*   110 */   450,  479,  552,  516,  596,  555,  537,  537,  537,  590,
 /*   120 */   541,  570,  606,  648,  632,  644,  656,  686,  650,  695,
 /*   130 */   683,  681,  715,  717,  720,  721,  732,  713,  716,  718,
 /*   140 */   719,  723,  730,  740,  742,  745,  746,  747,  734,  733,
 /*   150 */   703,  752,  753,  726,  765,  727,  699,  741,  749,  710,
 /*   160 */   757,  763,  766,  748,  739,  750,  754,  537,  805,  784,
 /*   170 */   773,  755,  767,  762,  783,  590,  802,  811,  819,  821,
 /*   180 */   820,  826,  842,  829,  866,  858,  872,  848,  860,  873,
 /*   190 */   876,  889,  861,  882,  884,  893,  906,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*    10 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*    20 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*    30 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*    40 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1101, 1048, 1048,
 /*    50 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*    60 */  1048, 1048, 1048, 1099, 1048, 1327, 1048, 1214, 1048, 1048,
 /*    70 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*    80 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*    90 */  1048, 1048, 1101, 1338, 1338, 1338, 1099, 1048, 1048, 1048,
 /*   100 */  1048, 1048, 1183, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*   110 */  1402, 1048, 1136, 1362, 1048, 1354, 1330, 1344, 1331, 1048,
 /*   120 */  1387, 1347, 1240, 1048, 1219, 1216, 1216, 1048, 1048, 1101,
 /*   130 */  1048, 1048, 1101, 1101, 1048, 1101, 1048, 1048, 1048, 1048,
 /*   140 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*   150 */  1048, 1099, 1048, 1048, 1099, 1048, 1369, 1367, 1048, 1369,
 /*   160 */  1367, 1048, 1048, 1381, 1377, 1360, 1358, 1344, 1048, 1048,
 /*   170 */  1048, 1405, 1393, 1389, 1048, 1048, 1367, 1048, 1048, 1367,
 /*   180 */  1048, 1227, 1048, 1048, 1099, 1048, 1099, 1048, 1152, 1048,
 /*   190 */  1099, 1048, 1242, 1186, 1186, 1102, 1053, 1048, 1048, 1048,
 /*   200 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1292, 1380,
 /*   210 */  1379, 1291, 1304, 1303, 1302, 1048, 1048, 1048, 1286, 1287,
 /*   220 */  1285, 1284, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*   230 */  1048, 1048, 1048, 1328, 1048, 1390, 1394, 1048, 1048, 1048,
 /*   240 */  1270, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*   250 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*   260 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*   270 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*   280 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*   290 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*   300 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*   310 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*   320 */  1048, 1048, 1048, 1048, 1048, 1048, 1351, 1361, 1048, 1048,
 /*   330 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1270, 1048,
 /*   340 */  1378, 1048, 1337, 1333, 1048, 1048, 1329, 1048, 1048, 1388,
 /*   350 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1323, 1048,
 /*   360 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*   370 */  1048, 1048, 1048, 1048, 1048, 1269, 1048, 1048, 1048, 1048,
 /*   380 */  1048, 1048, 1048, 1180, 1048, 1048, 1048, 1048, 1048, 1048,
 /*   390 */  1048, 1048, 1048, 1048, 1048, 1048, 1165, 1163, 1162, 1161,
 /*   400 */  1048, 1158, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*   410 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*   420 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*   430 */  1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048, 1048,
 /*   440 */  1048, 1048, 1048, 1048, 1048,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "DNODE",
  /*   37 */ "PORT",
  /*   38 */ "NK_INTEGER",
  /*   39 */ "DNODES",
  /*   40 */ "NK_IPTOKEN",
  /*   41 */ "LOCAL",
  /*   42 */ "QNODE",
  /*   43 */ "ON",
  /*   44 */ "DATABASE",
  /*   45 */ "USE",
  /*   46 */ "IF",
  /*   47 */ "NOT",
  /*   48 */ "EXISTS",
  /*   49 */ "BLOCKS",
  /*   50 */ "CACHE",
  /*   51 */ "CACHELAST",
  /*   52 */ "COMP",
  /*   53 */ "DAYS",
  /*   54 */ "FSYNC",
  /*   55 */ "MAXROWS",
  /*   56 */ "MINROWS",
  /*   57 */ "KEEP",
  /*   58 */ "PRECISION",
  /*   59 */ "QUORUM",
  /*   60 */ "REPLICA",
  /*   61 */ "TTL",
  /*   62 */ "WAL",
  /*   63 */ "VGROUPS",
  /*   64 */ "SINGLE_STABLE",
  /*   65 */ "STREAM_MODE",
  /*   66 */ "RETENTIONS",
  /*   67 */ "TABLE",
  /*   68 */ "NK_LP",
  /*   69 */ "NK_RP",
  /*   70 */ "STABLE",
  /*   71 */ "ADD",
  /*   72 */ "COLUMN",
  /*   73 */ "MODIFY",
  /*   74 */ "RENAME",
  /*   75 */ "TAG",
  /*   76 */ "SET",
  /*   77 */ "NK_EQ",
  /*   78 */ "USING",
  /*   79 */ "TAGS",
  /*   80 */ "NK_DOT",
  /*   81 */ "NK_COMMA",
  /*   82 */ "COMMENT",
  /*   83 */ "BOOL",
  /*   84 */ "TINYINT",
  /*   85 */ "SMALLINT",
  /*   86 */ "INT",
  /*   87 */ "INTEGER",
  /*   88 */ "BIGINT",
  /*   89 */ "FLOAT",
  /*   90 */ "DOUBLE",
  /*   91 */ "BINARY",
  /*   92 */ "TIMESTAMP",
  /*   93 */ "NCHAR",
  /*   94 */ "UNSIGNED",
  /*   95 */ "JSON",
  /*   96 */ "VARCHAR",
  /*   97 */ "MEDIUMBLOB",
  /*   98 */ "BLOB",
  /*   99 */ "VARBINARY",
  /*  100 */ "DECIMAL",
  /*  101 */ "SMA",
  /*  102 */ "ROLLUP",
  /*  103 */ "FILE_FACTOR",
  /*  104 */ "NK_FLOAT",
  /*  105 */ "DELAY",
  /*  106 */ "SHOW",
  /*  107 */ "DATABASES",
  /*  108 */ "TABLES",
  /*  109 */ "STABLES",
  /*  110 */ "MNODES",
  /*  111 */ "MODULES",
  /*  112 */ "QNODES",
  /*  113 */ "FUNCTIONS",
  /*  114 */ "INDEXES",
  /*  115 */ "FROM",
  /*  116 */ "LIKE",
  /*  117 */ "INDEX",
  /*  118 */ "FULLTEXT",
  /*  119 */ "FUNCTION",
  /*  120 */ "INTERVAL",
  /*  121 */ "TOPIC",
  /*  122 */ "AS",
  /*  123 */ "DESC",
  /*  124 */ "DESCRIBE",
  /*  125 */ "RESET",
  /*  126 */ "QUERY",
  /*  127 */ "EXPLAIN",
  /*  128 */ "ANALYZE",
  /*  129 */ "VERBOSE",
  /*  130 */ "NK_BOOL",
  /*  131 */ "RATIO",
  /*  132 */ "NULL",
  /*  133 */ "NK_VARIABLE",
  /*  134 */ "NK_UNDERLINE",
  /*  135 */ "ROWTS",
  /*  136 */ "TBNAME",
  /*  137 */ "QSTARTTS",
  /*  138 */ "QENDTS",
  /*  139 */ "WSTARTTS",
  /*  140 */ "WENDTS",
  /*  141 */ "WDURATION",
  /*  142 */ "BETWEEN",
  /*  143 */ "IS",
  /*  144 */ "NK_LT",
  /*  145 */ "NK_GT",
  /*  146 */ "NK_LE",
  /*  147 */ "NK_GE",
  /*  148 */ "NK_NE",
  /*  149 */ "MATCH",
  /*  150 */ "NMATCH",
  /*  151 */ "IN",
  /*  152 */ "JOIN",
  /*  153 */ "INNER",
  /*  154 */ "SELECT",
  /*  155 */ "DISTINCT",
  /*  156 */ "WHERE",
  /*  157 */ "PARTITION",
  /*  158 */ "BY",
  /*  159 */ "SESSION",
  /*  160 */ "STATE_WINDOW",
  /*  161 */ "SLIDING",
  /*  162 */ "FILL",
  /*  163 */ "VALUE",
  /*  164 */ "NONE",
  /*  165 */ "PREV",
  /*  166 */ "LINEAR",
  /*  167 */ "NEXT",
  /*  168 */ "GROUP",
  /*  169 */ "HAVING",
  /*  170 */ "ORDER",
  /*  171 */ "SLIMIT",
  /*  172 */ "SOFFSET",
  /*  173 */ "LIMIT",
  /*  174 */ "OFFSET",
  /*  175 */ "ASC",
  /*  176 */ "NULLS",
  /*  177 */ "FIRST",
  /*  178 */ "LAST",
  /*  179 */ "cmd",
  /*  180 */ "account_options",
  /*  181 */ "alter_account_options",
  /*  182 */ "literal",
  /*  183 */ "alter_account_option",
  /*  184 */ "user_name",
  /*  185 */ "dnode_endpoint",
  /*  186 */ "dnode_host_name",
  /*  187 */ "not_exists_opt",
  /*  188 */ "db_name",
  /*  189 */ "db_options",
  /*  190 */ "exists_opt",
  /*  191 */ "alter_db_options",
  /*  192 */ "alter_db_option",
  /*  193 */ "full_table_name",
  /*  194 */ "column_def_list",
  /*  195 */ "tags_def_opt",
  /*  196 */ "table_options",
  /*  197 */ "multi_create_clause",
  /*  198 */ "tags_def",
  /*  199 */ "multi_drop_clause",
  /*  200 */ "alter_table_clause",
  /*  201 */ "alter_table_options",
  /*  202 */ "column_name",
  /*  203 */ "type_name",
  /*  204 */ "create_subtable_clause",
  /*  205 */ "specific_tags_opt",
  /*  206 */ "literal_list",
  /*  207 */ "drop_table_clause",
  /*  208 */ "col_name_list",
  /*  209 */ "table_name",
  /*  210 */ "column_def",
  /*  211 */ "func_name_list",
  /*  212 */ "alter_table_option",
  /*  213 */ "col_name",
  /*  214 */ "db_name_cond_opt",
  /*  215 */ "like_pattern_opt",
  /*  216 */ "table_name_cond",
  /*  217 */ "from_db_opt",
  /*  218 */ "func_name",
  /*  219 */ "function_name",
  /*  220 */ "index_name",
  /*  221 */ "index_options",
  /*  222 */ "func_list",
  /*  223 */ "duration_literal",
  /*  224 */ "sliding_opt",
  /*  225 */ "func",
  /*  226 */ "expression_list",
  /*  227 */ "topic_name",
  /*  228 */ "query_expression",
  /*  229 */ "analyze_opt",
  /*  230 */ "explain_options",
  /*  231 */ "signed",
  /*  232 */ "signed_literal",
  /*  233 */ "table_alias",
  /*  234 */ "column_alias",
  /*  235 */ "expression",
  /*  236 */ "pseudo_column",
  /*  237 */ "column_reference",
  /*  238 */ "subquery",
  /*  239 */ "predicate",
  /*  240 */ "compare_op",
  /*  241 */ "in_op",
  /*  242 */ "in_predicate_value",
  /*  243 */ "boolean_value_expression",
  /*  244 */ "boolean_primary",
  /*  245 */ "common_expression",
  /*  246 */ "from_clause",
  /*  247 */ "table_reference_list",
  /*  248 */ "table_reference",
  /*  249 */ "table_primary",
  /*  250 */ "joined_table",
  /*  251 */ "alias_opt",
  /*  252 */ "parenthesized_joined_table",
  /*  253 */ "join_type",
  /*  254 */ "search_condition",
  /*  255 */ "query_specification",
  /*  256 */ "set_quantifier_opt",
  /*  257 */ "select_list",
  /*  258 */ "where_clause_opt",
  /*  259 */ "partition_by_clause_opt",
  /*  260 */ "twindow_clause_opt",
  /*  261 */ "group_by_clause_opt",
  /*  262 */ "having_clause_opt",
  /*  263 */ "select_sublist",
  /*  264 */ "select_item",
  /*  265 */ "fill_opt",
  /*  266 */ "fill_mode",
  /*  267 */ "group_by_list",
  /*  268 */ "query_expression_body",
  /*  269 */ "order_by_clause_opt",
  /*  270 */ "slimit_clause_opt",
  /*  271 */ "limit_clause_opt",
  /*  272 */ "query_primary",
  /*  273 */ "sort_specification_list",
  /*  274 */ "sort_specification",
  /*  275 */ "ordering_specification_opt",
  /*  276 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  29 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  30 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  31 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  32 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  33 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  34 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  35 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  36 */ "dnode_endpoint ::= NK_STRING",
 /*  37 */ "dnode_host_name ::= NK_ID",
 /*  38 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  39 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  40 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  41 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  42 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  43 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  44 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  45 */ "cmd ::= USE db_name",
 /*  46 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  47 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  48 */ "not_exists_opt ::=",
 /*  49 */ "exists_opt ::= IF EXISTS",
 /*  50 */ "exists_opt ::=",
 /*  51 */ "db_options ::=",
 /*  52 */ "db_options ::= db_options BLOCKS NK_INTEGER",
 /*  53 */ "db_options ::= db_options CACHE NK_INTEGER",
 /*  54 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  55 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  56 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  57 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  58 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  59 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  60 */ "db_options ::= db_options KEEP NK_INTEGER",
 /*  61 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  62 */ "db_options ::= db_options QUORUM NK_INTEGER",
 /*  63 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  64 */ "db_options ::= db_options TTL NK_INTEGER",
 /*  65 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  66 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  67 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  68 */ "db_options ::= db_options STREAM_MODE NK_INTEGER",
 /*  69 */ "db_options ::= db_options RETENTIONS NK_STRING",
 /*  70 */ "alter_db_options ::= alter_db_option",
 /*  71 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  72 */ "alter_db_option ::= BLOCKS NK_INTEGER",
 /*  73 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  74 */ "alter_db_option ::= KEEP NK_INTEGER",
 /*  75 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  76 */ "alter_db_option ::= QUORUM NK_INTEGER",
 /*  77 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  78 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /*  79 */ "cmd ::= CREATE TABLE multi_create_clause",
 /*  80 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /*  81 */ "cmd ::= DROP TABLE multi_drop_clause",
 /*  82 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /*  83 */ "cmd ::= ALTER TABLE alter_table_clause",
 /*  84 */ "cmd ::= ALTER STABLE alter_table_clause",
 /*  85 */ "alter_table_clause ::= full_table_name alter_table_options",
 /*  86 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /*  87 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /*  88 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /*  89 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /*  90 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /*  91 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /*  92 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /*  93 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /*  94 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal",
 /*  95 */ "multi_create_clause ::= create_subtable_clause",
 /*  96 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /*  97 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP",
 /*  98 */ "multi_drop_clause ::= drop_table_clause",
 /*  99 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 100 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 101 */ "specific_tags_opt ::=",
 /* 102 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 103 */ "full_table_name ::= table_name",
 /* 104 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 105 */ "column_def_list ::= column_def",
 /* 106 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 107 */ "column_def ::= column_name type_name",
 /* 108 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 109 */ "type_name ::= BOOL",
 /* 110 */ "type_name ::= TINYINT",
 /* 111 */ "type_name ::= SMALLINT",
 /* 112 */ "type_name ::= INT",
 /* 113 */ "type_name ::= INTEGER",
 /* 114 */ "type_name ::= BIGINT",
 /* 115 */ "type_name ::= FLOAT",
 /* 116 */ "type_name ::= DOUBLE",
 /* 117 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 118 */ "type_name ::= TIMESTAMP",
 /* 119 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 120 */ "type_name ::= TINYINT UNSIGNED",
 /* 121 */ "type_name ::= SMALLINT UNSIGNED",
 /* 122 */ "type_name ::= INT UNSIGNED",
 /* 123 */ "type_name ::= BIGINT UNSIGNED",
 /* 124 */ "type_name ::= JSON",
 /* 125 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 126 */ "type_name ::= MEDIUMBLOB",
 /* 127 */ "type_name ::= BLOB",
 /* 128 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 129 */ "type_name ::= DECIMAL",
 /* 130 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 131 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 132 */ "tags_def_opt ::=",
 /* 133 */ "tags_def_opt ::= tags_def",
 /* 134 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 135 */ "table_options ::=",
 /* 136 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 137 */ "table_options ::= table_options KEEP NK_INTEGER",
 /* 138 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 139 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 140 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 141 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 142 */ "table_options ::= table_options DELAY NK_INTEGER",
 /* 143 */ "alter_table_options ::= alter_table_option",
 /* 144 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 145 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 146 */ "alter_table_option ::= KEEP NK_INTEGER",
 /* 147 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 148 */ "col_name_list ::= col_name",
 /* 149 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 150 */ "col_name ::= column_name",
 /* 151 */ "cmd ::= SHOW DNODES",
 /* 152 */ "cmd ::= SHOW USERS",
 /* 153 */ "cmd ::= SHOW DATABASES",
 /* 154 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 155 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 156 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 157 */ "cmd ::= SHOW MNODES",
 /* 158 */ "cmd ::= SHOW MODULES",
 /* 159 */ "cmd ::= SHOW QNODES",
 /* 160 */ "cmd ::= SHOW FUNCTIONS",
 /* 161 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 162 */ "cmd ::= SHOW STREAMS",
 /* 163 */ "db_name_cond_opt ::=",
 /* 164 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 165 */ "like_pattern_opt ::=",
 /* 166 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 167 */ "table_name_cond ::= table_name",
 /* 168 */ "from_db_opt ::=",
 /* 169 */ "from_db_opt ::= FROM db_name",
 /* 170 */ "func_name_list ::= func_name",
 /* 171 */ "func_name_list ::= func_name_list NK_COMMA col_name",
 /* 172 */ "func_name ::= function_name",
 /* 173 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 174 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 175 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 176 */ "index_options ::=",
 /* 177 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 178 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 179 */ "func_list ::= func",
 /* 180 */ "func_list ::= func_list NK_COMMA func",
 /* 181 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 182 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 183 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name",
 /* 184 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 185 */ "cmd ::= DESC full_table_name",
 /* 186 */ "cmd ::= DESCRIBE full_table_name",
 /* 187 */ "cmd ::= RESET QUERY CACHE",
 /* 188 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 189 */ "analyze_opt ::=",
 /* 190 */ "analyze_opt ::= ANALYZE",
 /* 191 */ "explain_options ::=",
 /* 192 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 193 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 194 */ "cmd ::= query_expression",
 /* 195 */ "literal ::= NK_INTEGER",
 /* 196 */ "literal ::= NK_FLOAT",
 /* 197 */ "literal ::= NK_STRING",
 /* 198 */ "literal ::= NK_BOOL",
 /* 199 */ "literal ::= TIMESTAMP NK_STRING",
 /* 200 */ "literal ::= duration_literal",
 /* 201 */ "literal ::= NULL",
 /* 202 */ "duration_literal ::= NK_VARIABLE",
 /* 203 */ "signed ::= NK_INTEGER",
 /* 204 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 205 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 206 */ "signed ::= NK_FLOAT",
 /* 207 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 208 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 209 */ "signed_literal ::= signed",
 /* 210 */ "signed_literal ::= NK_STRING",
 /* 211 */ "signed_literal ::= NK_BOOL",
 /* 212 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 213 */ "signed_literal ::= duration_literal",
 /* 214 */ "signed_literal ::= NULL",
 /* 215 */ "literal_list ::= signed_literal",
 /* 216 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 217 */ "db_name ::= NK_ID",
 /* 218 */ "table_name ::= NK_ID",
 /* 219 */ "column_name ::= NK_ID",
 /* 220 */ "function_name ::= NK_ID",
 /* 221 */ "table_alias ::= NK_ID",
 /* 222 */ "column_alias ::= NK_ID",
 /* 223 */ "user_name ::= NK_ID",
 /* 224 */ "index_name ::= NK_ID",
 /* 225 */ "topic_name ::= NK_ID",
 /* 226 */ "expression ::= literal",
 /* 227 */ "expression ::= pseudo_column",
 /* 228 */ "expression ::= column_reference",
 /* 229 */ "expression ::= function_name NK_LP expression_list NK_RP",
 /* 230 */ "expression ::= function_name NK_LP NK_STAR NK_RP",
 /* 231 */ "expression ::= subquery",
 /* 232 */ "expression ::= NK_LP expression NK_RP",
 /* 233 */ "expression ::= NK_PLUS expression",
 /* 234 */ "expression ::= NK_MINUS expression",
 /* 235 */ "expression ::= expression NK_PLUS expression",
 /* 236 */ "expression ::= expression NK_MINUS expression",
 /* 237 */ "expression ::= expression NK_STAR expression",
 /* 238 */ "expression ::= expression NK_SLASH expression",
 /* 239 */ "expression ::= expression NK_REM expression",
 /* 240 */ "expression_list ::= expression",
 /* 241 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 242 */ "column_reference ::= column_name",
 /* 243 */ "column_reference ::= table_name NK_DOT column_name",
 /* 244 */ "pseudo_column ::= NK_UNDERLINE ROWTS",
 /* 245 */ "pseudo_column ::= TBNAME",
 /* 246 */ "pseudo_column ::= NK_UNDERLINE QSTARTTS",
 /* 247 */ "pseudo_column ::= NK_UNDERLINE QENDTS",
 /* 248 */ "pseudo_column ::= NK_UNDERLINE WSTARTTS",
 /* 249 */ "pseudo_column ::= NK_UNDERLINE WENDTS",
 /* 250 */ "pseudo_column ::= NK_UNDERLINE WDURATION",
 /* 251 */ "predicate ::= expression compare_op expression",
 /* 252 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 253 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 254 */ "predicate ::= expression IS NULL",
 /* 255 */ "predicate ::= expression IS NOT NULL",
 /* 256 */ "predicate ::= expression in_op in_predicate_value",
 /* 257 */ "compare_op ::= NK_LT",
 /* 258 */ "compare_op ::= NK_GT",
 /* 259 */ "compare_op ::= NK_LE",
 /* 260 */ "compare_op ::= NK_GE",
 /* 261 */ "compare_op ::= NK_NE",
 /* 262 */ "compare_op ::= NK_EQ",
 /* 263 */ "compare_op ::= LIKE",
 /* 264 */ "compare_op ::= NOT LIKE",
 /* 265 */ "compare_op ::= MATCH",
 /* 266 */ "compare_op ::= NMATCH",
 /* 267 */ "in_op ::= IN",
 /* 268 */ "in_op ::= NOT IN",
 /* 269 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 270 */ "boolean_value_expression ::= boolean_primary",
 /* 271 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 272 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 273 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 274 */ "boolean_primary ::= predicate",
 /* 275 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 276 */ "common_expression ::= expression",
 /* 277 */ "common_expression ::= boolean_value_expression",
 /* 278 */ "from_clause ::= FROM table_reference_list",
 /* 279 */ "table_reference_list ::= table_reference",
 /* 280 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 281 */ "table_reference ::= table_primary",
 /* 282 */ "table_reference ::= joined_table",
 /* 283 */ "table_primary ::= table_name alias_opt",
 /* 284 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 285 */ "table_primary ::= subquery alias_opt",
 /* 286 */ "table_primary ::= parenthesized_joined_table",
 /* 287 */ "alias_opt ::=",
 /* 288 */ "alias_opt ::= table_alias",
 /* 289 */ "alias_opt ::= AS table_alias",
 /* 290 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 291 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 292 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 293 */ "join_type ::=",
 /* 294 */ "join_type ::= INNER",
 /* 295 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 296 */ "set_quantifier_opt ::=",
 /* 297 */ "set_quantifier_opt ::= DISTINCT",
 /* 298 */ "set_quantifier_opt ::= ALL",
 /* 299 */ "select_list ::= NK_STAR",
 /* 300 */ "select_list ::= select_sublist",
 /* 301 */ "select_sublist ::= select_item",
 /* 302 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 303 */ "select_item ::= common_expression",
 /* 304 */ "select_item ::= common_expression column_alias",
 /* 305 */ "select_item ::= common_expression AS column_alias",
 /* 306 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 307 */ "where_clause_opt ::=",
 /* 308 */ "where_clause_opt ::= WHERE search_condition",
 /* 309 */ "partition_by_clause_opt ::=",
 /* 310 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 311 */ "twindow_clause_opt ::=",
 /* 312 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 313 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP column_reference NK_RP",
 /* 314 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 315 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 316 */ "sliding_opt ::=",
 /* 317 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 318 */ "fill_opt ::=",
 /* 319 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 320 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 321 */ "fill_mode ::= NONE",
 /* 322 */ "fill_mode ::= PREV",
 /* 323 */ "fill_mode ::= NULL",
 /* 324 */ "fill_mode ::= LINEAR",
 /* 325 */ "fill_mode ::= NEXT",
 /* 326 */ "group_by_clause_opt ::=",
 /* 327 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 328 */ "group_by_list ::= expression",
 /* 329 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 330 */ "having_clause_opt ::=",
 /* 331 */ "having_clause_opt ::= HAVING search_condition",
 /* 332 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 333 */ "query_expression_body ::= query_primary",
 /* 334 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 335 */ "query_primary ::= query_specification",
 /* 336 */ "order_by_clause_opt ::=",
 /* 337 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 338 */ "slimit_clause_opt ::=",
 /* 339 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 340 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 341 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 342 */ "limit_clause_opt ::=",
 /* 343 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 344 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 345 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 346 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 347 */ "search_condition ::= common_expression",
 /* 348 */ "sort_specification_list ::= sort_specification",
 /* 349 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 350 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 351 */ "ordering_specification_opt ::=",
 /* 352 */ "ordering_specification_opt ::= ASC",
 /* 353 */ "ordering_specification_opt ::= DESC",
 /* 354 */ "null_ordering_opt ::=",
 /* 355 */ "null_ordering_opt ::= NULLS FIRST",
 /* 356 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 179: /* cmd */
    case 182: /* literal */
    case 189: /* db_options */
    case 191: /* alter_db_options */
    case 193: /* full_table_name */
    case 196: /* table_options */
    case 200: /* alter_table_clause */
    case 201: /* alter_table_options */
    case 204: /* create_subtable_clause */
    case 207: /* drop_table_clause */
    case 210: /* column_def */
    case 213: /* col_name */
    case 214: /* db_name_cond_opt */
    case 215: /* like_pattern_opt */
    case 216: /* table_name_cond */
    case 217: /* from_db_opt */
    case 218: /* func_name */
    case 221: /* index_options */
    case 223: /* duration_literal */
    case 224: /* sliding_opt */
    case 225: /* func */
    case 228: /* query_expression */
    case 230: /* explain_options */
    case 231: /* signed */
    case 232: /* signed_literal */
    case 235: /* expression */
    case 236: /* pseudo_column */
    case 237: /* column_reference */
    case 238: /* subquery */
    case 239: /* predicate */
    case 242: /* in_predicate_value */
    case 243: /* boolean_value_expression */
    case 244: /* boolean_primary */
    case 245: /* common_expression */
    case 246: /* from_clause */
    case 247: /* table_reference_list */
    case 248: /* table_reference */
    case 249: /* table_primary */
    case 250: /* joined_table */
    case 252: /* parenthesized_joined_table */
    case 254: /* search_condition */
    case 255: /* query_specification */
    case 258: /* where_clause_opt */
    case 260: /* twindow_clause_opt */
    case 262: /* having_clause_opt */
    case 264: /* select_item */
    case 265: /* fill_opt */
    case 268: /* query_expression_body */
    case 270: /* slimit_clause_opt */
    case 271: /* limit_clause_opt */
    case 272: /* query_primary */
    case 274: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy46)); 
}
      break;
    case 180: /* account_options */
    case 181: /* alter_account_options */
    case 183: /* alter_account_option */
{
 
}
      break;
    case 184: /* user_name */
    case 185: /* dnode_endpoint */
    case 186: /* dnode_host_name */
    case 188: /* db_name */
    case 202: /* column_name */
    case 209: /* table_name */
    case 219: /* function_name */
    case 220: /* index_name */
    case 227: /* topic_name */
    case 233: /* table_alias */
    case 234: /* column_alias */
    case 251: /* alias_opt */
{
 
}
      break;
    case 187: /* not_exists_opt */
    case 190: /* exists_opt */
    case 229: /* analyze_opt */
    case 256: /* set_quantifier_opt */
{
 
}
      break;
    case 192: /* alter_db_option */
    case 212: /* alter_table_option */
{
 
}
      break;
    case 194: /* column_def_list */
    case 195: /* tags_def_opt */
    case 197: /* multi_create_clause */
    case 198: /* tags_def */
    case 199: /* multi_drop_clause */
    case 205: /* specific_tags_opt */
    case 206: /* literal_list */
    case 208: /* col_name_list */
    case 211: /* func_name_list */
    case 222: /* func_list */
    case 226: /* expression_list */
    case 257: /* select_list */
    case 259: /* partition_by_clause_opt */
    case 261: /* group_by_clause_opt */
    case 263: /* select_sublist */
    case 267: /* group_by_list */
    case 269: /* order_by_clause_opt */
    case 273: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy194)); 
}
      break;
    case 203: /* type_name */
{
 
}
      break;
    case 240: /* compare_op */
    case 241: /* in_op */
{
 
}
      break;
    case 253: /* join_type */
{
 
}
      break;
    case 266: /* fill_mode */
{
 
}
      break;
    case 275: /* ordering_specification_opt */
{
 
}
      break;
    case 276: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  179,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  179,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  180,    0 }, /* (2) account_options ::= */
  {  180,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  180,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  180,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  180,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  180,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  180,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  180,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  180,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  180,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  181,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  181,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  183,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  183,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  183,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  183,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  183,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  183,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  183,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  183,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  183,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  183,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  179,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  179,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  179,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  179,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  179,   -3 }, /* (28) cmd ::= CREATE DNODE dnode_endpoint */
  {  179,   -5 }, /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  179,   -3 }, /* (30) cmd ::= DROP DNODE NK_INTEGER */
  {  179,   -3 }, /* (31) cmd ::= DROP DNODE dnode_endpoint */
  {  179,   -4 }, /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  179,   -5 }, /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  179,   -4 }, /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
  {  179,   -5 }, /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  185,   -1 }, /* (36) dnode_endpoint ::= NK_STRING */
  {  186,   -1 }, /* (37) dnode_host_name ::= NK_ID */
  {  186,   -1 }, /* (38) dnode_host_name ::= NK_IPTOKEN */
  {  179,   -3 }, /* (39) cmd ::= ALTER LOCAL NK_STRING */
  {  179,   -4 }, /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  179,   -5 }, /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  179,   -5 }, /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  179,   -5 }, /* (43) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  179,   -4 }, /* (44) cmd ::= DROP DATABASE exists_opt db_name */
  {  179,   -2 }, /* (45) cmd ::= USE db_name */
  {  179,   -4 }, /* (46) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  187,   -3 }, /* (47) not_exists_opt ::= IF NOT EXISTS */
  {  187,    0 }, /* (48) not_exists_opt ::= */
  {  190,   -2 }, /* (49) exists_opt ::= IF EXISTS */
  {  190,    0 }, /* (50) exists_opt ::= */
  {  189,    0 }, /* (51) db_options ::= */
  {  189,   -3 }, /* (52) db_options ::= db_options BLOCKS NK_INTEGER */
  {  189,   -3 }, /* (53) db_options ::= db_options CACHE NK_INTEGER */
  {  189,   -3 }, /* (54) db_options ::= db_options CACHELAST NK_INTEGER */
  {  189,   -3 }, /* (55) db_options ::= db_options COMP NK_INTEGER */
  {  189,   -3 }, /* (56) db_options ::= db_options DAYS NK_INTEGER */
  {  189,   -3 }, /* (57) db_options ::= db_options FSYNC NK_INTEGER */
  {  189,   -3 }, /* (58) db_options ::= db_options MAXROWS NK_INTEGER */
  {  189,   -3 }, /* (59) db_options ::= db_options MINROWS NK_INTEGER */
  {  189,   -3 }, /* (60) db_options ::= db_options KEEP NK_INTEGER */
  {  189,   -3 }, /* (61) db_options ::= db_options PRECISION NK_STRING */
  {  189,   -3 }, /* (62) db_options ::= db_options QUORUM NK_INTEGER */
  {  189,   -3 }, /* (63) db_options ::= db_options REPLICA NK_INTEGER */
  {  189,   -3 }, /* (64) db_options ::= db_options TTL NK_INTEGER */
  {  189,   -3 }, /* (65) db_options ::= db_options WAL NK_INTEGER */
  {  189,   -3 }, /* (66) db_options ::= db_options VGROUPS NK_INTEGER */
  {  189,   -3 }, /* (67) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  189,   -3 }, /* (68) db_options ::= db_options STREAM_MODE NK_INTEGER */
  {  189,   -3 }, /* (69) db_options ::= db_options RETENTIONS NK_STRING */
  {  191,   -1 }, /* (70) alter_db_options ::= alter_db_option */
  {  191,   -2 }, /* (71) alter_db_options ::= alter_db_options alter_db_option */
  {  192,   -2 }, /* (72) alter_db_option ::= BLOCKS NK_INTEGER */
  {  192,   -2 }, /* (73) alter_db_option ::= FSYNC NK_INTEGER */
  {  192,   -2 }, /* (74) alter_db_option ::= KEEP NK_INTEGER */
  {  192,   -2 }, /* (75) alter_db_option ::= WAL NK_INTEGER */
  {  192,   -2 }, /* (76) alter_db_option ::= QUORUM NK_INTEGER */
  {  192,   -2 }, /* (77) alter_db_option ::= CACHELAST NK_INTEGER */
  {  179,   -9 }, /* (78) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  179,   -3 }, /* (79) cmd ::= CREATE TABLE multi_create_clause */
  {  179,   -9 }, /* (80) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  179,   -3 }, /* (81) cmd ::= DROP TABLE multi_drop_clause */
  {  179,   -4 }, /* (82) cmd ::= DROP STABLE exists_opt full_table_name */
  {  179,   -3 }, /* (83) cmd ::= ALTER TABLE alter_table_clause */
  {  179,   -3 }, /* (84) cmd ::= ALTER STABLE alter_table_clause */
  {  200,   -2 }, /* (85) alter_table_clause ::= full_table_name alter_table_options */
  {  200,   -5 }, /* (86) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  200,   -4 }, /* (87) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  200,   -5 }, /* (88) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  200,   -5 }, /* (89) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  200,   -5 }, /* (90) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  200,   -4 }, /* (91) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  200,   -5 }, /* (92) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  200,   -5 }, /* (93) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  200,   -6 }, /* (94) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
  {  197,   -1 }, /* (95) multi_create_clause ::= create_subtable_clause */
  {  197,   -2 }, /* (96) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  204,   -9 }, /* (97) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
  {  199,   -1 }, /* (98) multi_drop_clause ::= drop_table_clause */
  {  199,   -2 }, /* (99) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  207,   -2 }, /* (100) drop_table_clause ::= exists_opt full_table_name */
  {  205,    0 }, /* (101) specific_tags_opt ::= */
  {  205,   -3 }, /* (102) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  193,   -1 }, /* (103) full_table_name ::= table_name */
  {  193,   -3 }, /* (104) full_table_name ::= db_name NK_DOT table_name */
  {  194,   -1 }, /* (105) column_def_list ::= column_def */
  {  194,   -3 }, /* (106) column_def_list ::= column_def_list NK_COMMA column_def */
  {  210,   -2 }, /* (107) column_def ::= column_name type_name */
  {  210,   -4 }, /* (108) column_def ::= column_name type_name COMMENT NK_STRING */
  {  203,   -1 }, /* (109) type_name ::= BOOL */
  {  203,   -1 }, /* (110) type_name ::= TINYINT */
  {  203,   -1 }, /* (111) type_name ::= SMALLINT */
  {  203,   -1 }, /* (112) type_name ::= INT */
  {  203,   -1 }, /* (113) type_name ::= INTEGER */
  {  203,   -1 }, /* (114) type_name ::= BIGINT */
  {  203,   -1 }, /* (115) type_name ::= FLOAT */
  {  203,   -1 }, /* (116) type_name ::= DOUBLE */
  {  203,   -4 }, /* (117) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  203,   -1 }, /* (118) type_name ::= TIMESTAMP */
  {  203,   -4 }, /* (119) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  203,   -2 }, /* (120) type_name ::= TINYINT UNSIGNED */
  {  203,   -2 }, /* (121) type_name ::= SMALLINT UNSIGNED */
  {  203,   -2 }, /* (122) type_name ::= INT UNSIGNED */
  {  203,   -2 }, /* (123) type_name ::= BIGINT UNSIGNED */
  {  203,   -1 }, /* (124) type_name ::= JSON */
  {  203,   -4 }, /* (125) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  203,   -1 }, /* (126) type_name ::= MEDIUMBLOB */
  {  203,   -1 }, /* (127) type_name ::= BLOB */
  {  203,   -4 }, /* (128) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  203,   -1 }, /* (129) type_name ::= DECIMAL */
  {  203,   -4 }, /* (130) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  203,   -6 }, /* (131) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  195,    0 }, /* (132) tags_def_opt ::= */
  {  195,   -1 }, /* (133) tags_def_opt ::= tags_def */
  {  198,   -4 }, /* (134) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  196,    0 }, /* (135) table_options ::= */
  {  196,   -3 }, /* (136) table_options ::= table_options COMMENT NK_STRING */
  {  196,   -3 }, /* (137) table_options ::= table_options KEEP NK_INTEGER */
  {  196,   -3 }, /* (138) table_options ::= table_options TTL NK_INTEGER */
  {  196,   -5 }, /* (139) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  196,   -5 }, /* (140) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
  {  196,   -3 }, /* (141) table_options ::= table_options FILE_FACTOR NK_FLOAT */
  {  196,   -3 }, /* (142) table_options ::= table_options DELAY NK_INTEGER */
  {  201,   -1 }, /* (143) alter_table_options ::= alter_table_option */
  {  201,   -2 }, /* (144) alter_table_options ::= alter_table_options alter_table_option */
  {  212,   -2 }, /* (145) alter_table_option ::= COMMENT NK_STRING */
  {  212,   -2 }, /* (146) alter_table_option ::= KEEP NK_INTEGER */
  {  212,   -2 }, /* (147) alter_table_option ::= TTL NK_INTEGER */
  {  208,   -1 }, /* (148) col_name_list ::= col_name */
  {  208,   -3 }, /* (149) col_name_list ::= col_name_list NK_COMMA col_name */
  {  213,   -1 }, /* (150) col_name ::= column_name */
  {  179,   -2 }, /* (151) cmd ::= SHOW DNODES */
  {  179,   -2 }, /* (152) cmd ::= SHOW USERS */
  {  179,   -2 }, /* (153) cmd ::= SHOW DATABASES */
  {  179,   -4 }, /* (154) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  179,   -4 }, /* (155) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  179,   -3 }, /* (156) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  179,   -2 }, /* (157) cmd ::= SHOW MNODES */
  {  179,   -2 }, /* (158) cmd ::= SHOW MODULES */
  {  179,   -2 }, /* (159) cmd ::= SHOW QNODES */
  {  179,   -2 }, /* (160) cmd ::= SHOW FUNCTIONS */
  {  179,   -5 }, /* (161) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  179,   -2 }, /* (162) cmd ::= SHOW STREAMS */
  {  214,    0 }, /* (163) db_name_cond_opt ::= */
  {  214,   -2 }, /* (164) db_name_cond_opt ::= db_name NK_DOT */
  {  215,    0 }, /* (165) like_pattern_opt ::= */
  {  215,   -2 }, /* (166) like_pattern_opt ::= LIKE NK_STRING */
  {  216,   -1 }, /* (167) table_name_cond ::= table_name */
  {  217,    0 }, /* (168) from_db_opt ::= */
  {  217,   -2 }, /* (169) from_db_opt ::= FROM db_name */
  {  211,   -1 }, /* (170) func_name_list ::= func_name */
  {  211,   -3 }, /* (171) func_name_list ::= func_name_list NK_COMMA col_name */
  {  218,   -1 }, /* (172) func_name ::= function_name */
  {  179,   -8 }, /* (173) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  179,  -10 }, /* (174) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  179,   -6 }, /* (175) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  221,    0 }, /* (176) index_options ::= */
  {  221,   -9 }, /* (177) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  221,  -11 }, /* (178) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  222,   -1 }, /* (179) func_list ::= func */
  {  222,   -3 }, /* (180) func_list ::= func_list NK_COMMA func */
  {  225,   -4 }, /* (181) func ::= function_name NK_LP expression_list NK_RP */
  {  179,   -6 }, /* (182) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  179,   -6 }, /* (183) cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
  {  179,   -4 }, /* (184) cmd ::= DROP TOPIC exists_opt topic_name */
  {  179,   -2 }, /* (185) cmd ::= DESC full_table_name */
  {  179,   -2 }, /* (186) cmd ::= DESCRIBE full_table_name */
  {  179,   -3 }, /* (187) cmd ::= RESET QUERY CACHE */
  {  179,   -4 }, /* (188) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  229,    0 }, /* (189) analyze_opt ::= */
  {  229,   -1 }, /* (190) analyze_opt ::= ANALYZE */
  {  230,    0 }, /* (191) explain_options ::= */
  {  230,   -3 }, /* (192) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  230,   -3 }, /* (193) explain_options ::= explain_options RATIO NK_FLOAT */
  {  179,   -1 }, /* (194) cmd ::= query_expression */
  {  182,   -1 }, /* (195) literal ::= NK_INTEGER */
  {  182,   -1 }, /* (196) literal ::= NK_FLOAT */
  {  182,   -1 }, /* (197) literal ::= NK_STRING */
  {  182,   -1 }, /* (198) literal ::= NK_BOOL */
  {  182,   -2 }, /* (199) literal ::= TIMESTAMP NK_STRING */
  {  182,   -1 }, /* (200) literal ::= duration_literal */
  {  182,   -1 }, /* (201) literal ::= NULL */
  {  223,   -1 }, /* (202) duration_literal ::= NK_VARIABLE */
  {  231,   -1 }, /* (203) signed ::= NK_INTEGER */
  {  231,   -2 }, /* (204) signed ::= NK_PLUS NK_INTEGER */
  {  231,   -2 }, /* (205) signed ::= NK_MINUS NK_INTEGER */
  {  231,   -1 }, /* (206) signed ::= NK_FLOAT */
  {  231,   -2 }, /* (207) signed ::= NK_PLUS NK_FLOAT */
  {  231,   -2 }, /* (208) signed ::= NK_MINUS NK_FLOAT */
  {  232,   -1 }, /* (209) signed_literal ::= signed */
  {  232,   -1 }, /* (210) signed_literal ::= NK_STRING */
  {  232,   -1 }, /* (211) signed_literal ::= NK_BOOL */
  {  232,   -2 }, /* (212) signed_literal ::= TIMESTAMP NK_STRING */
  {  232,   -1 }, /* (213) signed_literal ::= duration_literal */
  {  232,   -1 }, /* (214) signed_literal ::= NULL */
  {  206,   -1 }, /* (215) literal_list ::= signed_literal */
  {  206,   -3 }, /* (216) literal_list ::= literal_list NK_COMMA signed_literal */
  {  188,   -1 }, /* (217) db_name ::= NK_ID */
  {  209,   -1 }, /* (218) table_name ::= NK_ID */
  {  202,   -1 }, /* (219) column_name ::= NK_ID */
  {  219,   -1 }, /* (220) function_name ::= NK_ID */
  {  233,   -1 }, /* (221) table_alias ::= NK_ID */
  {  234,   -1 }, /* (222) column_alias ::= NK_ID */
  {  184,   -1 }, /* (223) user_name ::= NK_ID */
  {  220,   -1 }, /* (224) index_name ::= NK_ID */
  {  227,   -1 }, /* (225) topic_name ::= NK_ID */
  {  235,   -1 }, /* (226) expression ::= literal */
  {  235,   -1 }, /* (227) expression ::= pseudo_column */
  {  235,   -1 }, /* (228) expression ::= column_reference */
  {  235,   -4 }, /* (229) expression ::= function_name NK_LP expression_list NK_RP */
  {  235,   -4 }, /* (230) expression ::= function_name NK_LP NK_STAR NK_RP */
  {  235,   -1 }, /* (231) expression ::= subquery */
  {  235,   -3 }, /* (232) expression ::= NK_LP expression NK_RP */
  {  235,   -2 }, /* (233) expression ::= NK_PLUS expression */
  {  235,   -2 }, /* (234) expression ::= NK_MINUS expression */
  {  235,   -3 }, /* (235) expression ::= expression NK_PLUS expression */
  {  235,   -3 }, /* (236) expression ::= expression NK_MINUS expression */
  {  235,   -3 }, /* (237) expression ::= expression NK_STAR expression */
  {  235,   -3 }, /* (238) expression ::= expression NK_SLASH expression */
  {  235,   -3 }, /* (239) expression ::= expression NK_REM expression */
  {  226,   -1 }, /* (240) expression_list ::= expression */
  {  226,   -3 }, /* (241) expression_list ::= expression_list NK_COMMA expression */
  {  237,   -1 }, /* (242) column_reference ::= column_name */
  {  237,   -3 }, /* (243) column_reference ::= table_name NK_DOT column_name */
  {  236,   -2 }, /* (244) pseudo_column ::= NK_UNDERLINE ROWTS */
  {  236,   -1 }, /* (245) pseudo_column ::= TBNAME */
  {  236,   -2 }, /* (246) pseudo_column ::= NK_UNDERLINE QSTARTTS */
  {  236,   -2 }, /* (247) pseudo_column ::= NK_UNDERLINE QENDTS */
  {  236,   -2 }, /* (248) pseudo_column ::= NK_UNDERLINE WSTARTTS */
  {  236,   -2 }, /* (249) pseudo_column ::= NK_UNDERLINE WENDTS */
  {  236,   -2 }, /* (250) pseudo_column ::= NK_UNDERLINE WDURATION */
  {  239,   -3 }, /* (251) predicate ::= expression compare_op expression */
  {  239,   -5 }, /* (252) predicate ::= expression BETWEEN expression AND expression */
  {  239,   -6 }, /* (253) predicate ::= expression NOT BETWEEN expression AND expression */
  {  239,   -3 }, /* (254) predicate ::= expression IS NULL */
  {  239,   -4 }, /* (255) predicate ::= expression IS NOT NULL */
  {  239,   -3 }, /* (256) predicate ::= expression in_op in_predicate_value */
  {  240,   -1 }, /* (257) compare_op ::= NK_LT */
  {  240,   -1 }, /* (258) compare_op ::= NK_GT */
  {  240,   -1 }, /* (259) compare_op ::= NK_LE */
  {  240,   -1 }, /* (260) compare_op ::= NK_GE */
  {  240,   -1 }, /* (261) compare_op ::= NK_NE */
  {  240,   -1 }, /* (262) compare_op ::= NK_EQ */
  {  240,   -1 }, /* (263) compare_op ::= LIKE */
  {  240,   -2 }, /* (264) compare_op ::= NOT LIKE */
  {  240,   -1 }, /* (265) compare_op ::= MATCH */
  {  240,   -1 }, /* (266) compare_op ::= NMATCH */
  {  241,   -1 }, /* (267) in_op ::= IN */
  {  241,   -2 }, /* (268) in_op ::= NOT IN */
  {  242,   -3 }, /* (269) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  243,   -1 }, /* (270) boolean_value_expression ::= boolean_primary */
  {  243,   -2 }, /* (271) boolean_value_expression ::= NOT boolean_primary */
  {  243,   -3 }, /* (272) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  243,   -3 }, /* (273) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  244,   -1 }, /* (274) boolean_primary ::= predicate */
  {  244,   -3 }, /* (275) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  245,   -1 }, /* (276) common_expression ::= expression */
  {  245,   -1 }, /* (277) common_expression ::= boolean_value_expression */
  {  246,   -2 }, /* (278) from_clause ::= FROM table_reference_list */
  {  247,   -1 }, /* (279) table_reference_list ::= table_reference */
  {  247,   -3 }, /* (280) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  248,   -1 }, /* (281) table_reference ::= table_primary */
  {  248,   -1 }, /* (282) table_reference ::= joined_table */
  {  249,   -2 }, /* (283) table_primary ::= table_name alias_opt */
  {  249,   -4 }, /* (284) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  249,   -2 }, /* (285) table_primary ::= subquery alias_opt */
  {  249,   -1 }, /* (286) table_primary ::= parenthesized_joined_table */
  {  251,    0 }, /* (287) alias_opt ::= */
  {  251,   -1 }, /* (288) alias_opt ::= table_alias */
  {  251,   -2 }, /* (289) alias_opt ::= AS table_alias */
  {  252,   -3 }, /* (290) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  252,   -3 }, /* (291) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  250,   -6 }, /* (292) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  253,    0 }, /* (293) join_type ::= */
  {  253,   -1 }, /* (294) join_type ::= INNER */
  {  255,   -9 }, /* (295) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  256,    0 }, /* (296) set_quantifier_opt ::= */
  {  256,   -1 }, /* (297) set_quantifier_opt ::= DISTINCT */
  {  256,   -1 }, /* (298) set_quantifier_opt ::= ALL */
  {  257,   -1 }, /* (299) select_list ::= NK_STAR */
  {  257,   -1 }, /* (300) select_list ::= select_sublist */
  {  263,   -1 }, /* (301) select_sublist ::= select_item */
  {  263,   -3 }, /* (302) select_sublist ::= select_sublist NK_COMMA select_item */
  {  264,   -1 }, /* (303) select_item ::= common_expression */
  {  264,   -2 }, /* (304) select_item ::= common_expression column_alias */
  {  264,   -3 }, /* (305) select_item ::= common_expression AS column_alias */
  {  264,   -3 }, /* (306) select_item ::= table_name NK_DOT NK_STAR */
  {  258,    0 }, /* (307) where_clause_opt ::= */
  {  258,   -2 }, /* (308) where_clause_opt ::= WHERE search_condition */
  {  259,    0 }, /* (309) partition_by_clause_opt ::= */
  {  259,   -3 }, /* (310) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  260,    0 }, /* (311) twindow_clause_opt ::= */
  {  260,   -6 }, /* (312) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  260,   -4 }, /* (313) twindow_clause_opt ::= STATE_WINDOW NK_LP column_reference NK_RP */
  {  260,   -6 }, /* (314) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  260,   -8 }, /* (315) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  224,    0 }, /* (316) sliding_opt ::= */
  {  224,   -4 }, /* (317) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  265,    0 }, /* (318) fill_opt ::= */
  {  265,   -4 }, /* (319) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  265,   -6 }, /* (320) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  266,   -1 }, /* (321) fill_mode ::= NONE */
  {  266,   -1 }, /* (322) fill_mode ::= PREV */
  {  266,   -1 }, /* (323) fill_mode ::= NULL */
  {  266,   -1 }, /* (324) fill_mode ::= LINEAR */
  {  266,   -1 }, /* (325) fill_mode ::= NEXT */
  {  261,    0 }, /* (326) group_by_clause_opt ::= */
  {  261,   -3 }, /* (327) group_by_clause_opt ::= GROUP BY group_by_list */
  {  267,   -1 }, /* (328) group_by_list ::= expression */
  {  267,   -3 }, /* (329) group_by_list ::= group_by_list NK_COMMA expression */
  {  262,    0 }, /* (330) having_clause_opt ::= */
  {  262,   -2 }, /* (331) having_clause_opt ::= HAVING search_condition */
  {  228,   -4 }, /* (332) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  268,   -1 }, /* (333) query_expression_body ::= query_primary */
  {  268,   -4 }, /* (334) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  272,   -1 }, /* (335) query_primary ::= query_specification */
  {  269,    0 }, /* (336) order_by_clause_opt ::= */
  {  269,   -3 }, /* (337) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  270,    0 }, /* (338) slimit_clause_opt ::= */
  {  270,   -2 }, /* (339) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  270,   -4 }, /* (340) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  270,   -4 }, /* (341) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  271,    0 }, /* (342) limit_clause_opt ::= */
  {  271,   -2 }, /* (343) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  271,   -4 }, /* (344) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  271,   -4 }, /* (345) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  238,   -3 }, /* (346) subquery ::= NK_LP query_expression NK_RP */
  {  254,   -1 }, /* (347) search_condition ::= common_expression */
  {  273,   -1 }, /* (348) sort_specification_list ::= sort_specification */
  {  273,   -3 }, /* (349) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  274,   -3 }, /* (350) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  275,    0 }, /* (351) ordering_specification_opt ::= */
  {  275,   -1 }, /* (352) ordering_specification_opt ::= ASC */
  {  275,   -1 }, /* (353) ordering_specification_opt ::= DESC */
  {  276,    0 }, /* (354) null_ordering_opt ::= */
  {  276,   -2 }, /* (355) null_ordering_opt ::= NULLS FIRST */
  {  276,   -2 }, /* (356) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,180,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,181,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,180,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,182,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,183,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,181,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,183,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,182,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy95, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy95, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy95, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy95); }
        break;
      case 28: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy95, NULL); }
        break;
      case 29: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy95, &yymsp[0].minor.yy0); }
        break;
      case 30: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 31: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy95); }
        break;
      case 32: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 33: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 34: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 35: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 36: /* dnode_endpoint ::= NK_STRING */
      case 37: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==37);
      case 38: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==38);
      case 217: /* db_name ::= NK_ID */ yytestcase(yyruleno==217);
      case 218: /* table_name ::= NK_ID */ yytestcase(yyruleno==218);
      case 219: /* column_name ::= NK_ID */ yytestcase(yyruleno==219);
      case 220: /* function_name ::= NK_ID */ yytestcase(yyruleno==220);
      case 221: /* table_alias ::= NK_ID */ yytestcase(yyruleno==221);
      case 222: /* column_alias ::= NK_ID */ yytestcase(yyruleno==222);
      case 223: /* user_name ::= NK_ID */ yytestcase(yyruleno==223);
      case 224: /* index_name ::= NK_ID */ yytestcase(yyruleno==224);
      case 225: /* topic_name ::= NK_ID */ yytestcase(yyruleno==225);
{ yylhsminor.yy95 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy95 = yylhsminor.yy95;
        break;
      case 39: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 40: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateQnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 42: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropQnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy151, &yymsp[-1].minor.yy95, yymsp[0].minor.yy46); }
        break;
      case 44: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy151, &yymsp[0].minor.yy95); }
        break;
      case 45: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy95); }
        break;
      case 46: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy95, yymsp[0].minor.yy46); }
        break;
      case 47: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy151 = true; }
        break;
      case 48: /* not_exists_opt ::= */
      case 50: /* exists_opt ::= */ yytestcase(yyruleno==50);
      case 189: /* analyze_opt ::= */ yytestcase(yyruleno==189);
      case 296: /* set_quantifier_opt ::= */ yytestcase(yyruleno==296);
{ yymsp[1].minor.yy151 = false; }
        break;
      case 49: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy151 = true; }
        break;
      case 51: /* db_options ::= */
{ yymsp[1].minor.yy46 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 52: /* db_options ::= db_options BLOCKS NK_INTEGER */
{ yylhsminor.yy46 = setDatabaseOption(pCxt, yymsp[-2].minor.yy46, DB_OPTION_BLOCKS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 53: /* db_options ::= db_options CACHE NK_INTEGER */
{ yylhsminor.yy46 = setDatabaseOption(pCxt, yymsp[-2].minor.yy46, DB_OPTION_CACHE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 54: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy46 = setDatabaseOption(pCxt, yymsp[-2].minor.yy46, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 55: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy46 = setDatabaseOption(pCxt, yymsp[-2].minor.yy46, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 56: /* db_options ::= db_options DAYS NK_INTEGER */
{ yylhsminor.yy46 = setDatabaseOption(pCxt, yymsp[-2].minor.yy46, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 57: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy46 = setDatabaseOption(pCxt, yymsp[-2].minor.yy46, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 58: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy46 = setDatabaseOption(pCxt, yymsp[-2].minor.yy46, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 59: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy46 = setDatabaseOption(pCxt, yymsp[-2].minor.yy46, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 60: /* db_options ::= db_options KEEP NK_INTEGER */
{ yylhsminor.yy46 = setDatabaseOption(pCxt, yymsp[-2].minor.yy46, DB_OPTION_KEEP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 61: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy46 = setDatabaseOption(pCxt, yymsp[-2].minor.yy46, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 62: /* db_options ::= db_options QUORUM NK_INTEGER */
{ yylhsminor.yy46 = setDatabaseOption(pCxt, yymsp[-2].minor.yy46, DB_OPTION_QUORUM, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 63: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy46 = setDatabaseOption(pCxt, yymsp[-2].minor.yy46, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 64: /* db_options ::= db_options TTL NK_INTEGER */
{ yylhsminor.yy46 = setDatabaseOption(pCxt, yymsp[-2].minor.yy46, DB_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 65: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy46 = setDatabaseOption(pCxt, yymsp[-2].minor.yy46, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 66: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy46 = setDatabaseOption(pCxt, yymsp[-2].minor.yy46, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 67: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy46 = setDatabaseOption(pCxt, yymsp[-2].minor.yy46, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 68: /* db_options ::= db_options STREAM_MODE NK_INTEGER */
{ yylhsminor.yy46 = setDatabaseOption(pCxt, yymsp[-2].minor.yy46, DB_OPTION_STREAM_MODE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 69: /* db_options ::= db_options RETENTIONS NK_STRING */
{ yylhsminor.yy46 = setDatabaseOption(pCxt, yymsp[-2].minor.yy46, DB_OPTION_RETENTIONS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 70: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy46 = createDefaultAlterDatabaseOptions(pCxt); yylhsminor.yy46 = setDatabaseOption(pCxt, yylhsminor.yy46, yymsp[0].minor.yy145.type, &yymsp[0].minor.yy145.val); }
  yymsp[0].minor.yy46 = yylhsminor.yy46;
        break;
      case 71: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy46 = setDatabaseOption(pCxt, yymsp[-1].minor.yy46, yymsp[0].minor.yy145.type, &yymsp[0].minor.yy145.val); }
  yymsp[-1].minor.yy46 = yylhsminor.yy46;
        break;
      case 72: /* alter_db_option ::= BLOCKS NK_INTEGER */
{ yymsp[-1].minor.yy145.type = DB_OPTION_BLOCKS; yymsp[-1].minor.yy145.val = yymsp[0].minor.yy0; }
        break;
      case 73: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy145.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy145.val = yymsp[0].minor.yy0; }
        break;
      case 74: /* alter_db_option ::= KEEP NK_INTEGER */
{ yymsp[-1].minor.yy145.type = DB_OPTION_KEEP; yymsp[-1].minor.yy145.val = yymsp[0].minor.yy0; }
        break;
      case 75: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy145.type = DB_OPTION_WAL; yymsp[-1].minor.yy145.val = yymsp[0].minor.yy0; }
        break;
      case 76: /* alter_db_option ::= QUORUM NK_INTEGER */
{ yymsp[-1].minor.yy145.type = DB_OPTION_QUORUM; yymsp[-1].minor.yy145.val = yymsp[0].minor.yy0; }
        break;
      case 77: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy145.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy145.val = yymsp[0].minor.yy0; }
        break;
      case 78: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 80: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==80);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy151, yymsp[-5].minor.yy46, yymsp[-3].minor.yy194, yymsp[-1].minor.yy194, yymsp[0].minor.yy46); }
        break;
      case 79: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy194); }
        break;
      case 81: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy194); }
        break;
      case 82: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy151, yymsp[0].minor.yy46); }
        break;
      case 83: /* cmd ::= ALTER TABLE alter_table_clause */
      case 84: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==84);
      case 194: /* cmd ::= query_expression */ yytestcase(yyruleno==194);
{ pCxt->pRootNode = yymsp[0].minor.yy46; }
        break;
      case 85: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy46 = createAlterTableOption(pCxt, yymsp[-1].minor.yy46, yymsp[0].minor.yy46); }
  yymsp[-1].minor.yy46 = yylhsminor.yy46;
        break;
      case 86: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy46 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy46, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy95, yymsp[0].minor.yy400); }
  yymsp[-4].minor.yy46 = yylhsminor.yy46;
        break;
      case 87: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy46 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy46, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy95); }
  yymsp[-3].minor.yy46 = yylhsminor.yy46;
        break;
      case 88: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy46 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy46, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy95, yymsp[0].minor.yy400); }
  yymsp[-4].minor.yy46 = yylhsminor.yy46;
        break;
      case 89: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy46 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy46, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy95, &yymsp[0].minor.yy95); }
  yymsp[-4].minor.yy46 = yylhsminor.yy46;
        break;
      case 90: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy46 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy46, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy95, yymsp[0].minor.yy400); }
  yymsp[-4].minor.yy46 = yylhsminor.yy46;
        break;
      case 91: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy46 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy46, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy95); }
  yymsp[-3].minor.yy46 = yylhsminor.yy46;
        break;
      case 92: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy46 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy46, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy95, yymsp[0].minor.yy400); }
  yymsp[-4].minor.yy46 = yylhsminor.yy46;
        break;
      case 93: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy46 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy46, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy95, &yymsp[0].minor.yy95); }
  yymsp[-4].minor.yy46 = yylhsminor.yy46;
        break;
      case 94: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
{ yylhsminor.yy46 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy46, &yymsp[-2].minor.yy95, yymsp[0].minor.yy46); }
  yymsp[-5].minor.yy46 = yylhsminor.yy46;
        break;
      case 95: /* multi_create_clause ::= create_subtable_clause */
      case 98: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==98);
      case 105: /* column_def_list ::= column_def */ yytestcase(yyruleno==105);
      case 148: /* col_name_list ::= col_name */ yytestcase(yyruleno==148);
      case 170: /* func_name_list ::= func_name */ yytestcase(yyruleno==170);
      case 179: /* func_list ::= func */ yytestcase(yyruleno==179);
      case 215: /* literal_list ::= signed_literal */ yytestcase(yyruleno==215);
      case 301: /* select_sublist ::= select_item */ yytestcase(yyruleno==301);
      case 348: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==348);
{ yylhsminor.yy194 = createNodeList(pCxt, yymsp[0].minor.yy46); }
  yymsp[0].minor.yy194 = yylhsminor.yy194;
        break;
      case 96: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 99: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==99);
{ yylhsminor.yy194 = addNodeToList(pCxt, yymsp[-1].minor.yy194, yymsp[0].minor.yy46); }
  yymsp[-1].minor.yy194 = yylhsminor.yy194;
        break;
      case 97: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
{ yylhsminor.yy46 = createCreateSubTableClause(pCxt, yymsp[-8].minor.yy151, yymsp[-7].minor.yy46, yymsp[-5].minor.yy46, yymsp[-4].minor.yy194, yymsp[-1].minor.yy194); }
  yymsp[-8].minor.yy46 = yylhsminor.yy46;
        break;
      case 100: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy46 = createDropTableClause(pCxt, yymsp[-1].minor.yy151, yymsp[0].minor.yy46); }
  yymsp[-1].minor.yy46 = yylhsminor.yy46;
        break;
      case 101: /* specific_tags_opt ::= */
      case 132: /* tags_def_opt ::= */ yytestcase(yyruleno==132);
      case 309: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==309);
      case 326: /* group_by_clause_opt ::= */ yytestcase(yyruleno==326);
      case 336: /* order_by_clause_opt ::= */ yytestcase(yyruleno==336);
{ yymsp[1].minor.yy194 = NULL; }
        break;
      case 102: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy194 = yymsp[-1].minor.yy194; }
        break;
      case 103: /* full_table_name ::= table_name */
{ yylhsminor.yy46 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy95, NULL); }
  yymsp[0].minor.yy46 = yylhsminor.yy46;
        break;
      case 104: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy46 = createRealTableNode(pCxt, &yymsp[-2].minor.yy95, &yymsp[0].minor.yy95, NULL); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 106: /* column_def_list ::= column_def_list NK_COMMA column_def */
      case 149: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==149);
      case 171: /* func_name_list ::= func_name_list NK_COMMA col_name */ yytestcase(yyruleno==171);
      case 180: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==180);
      case 216: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==216);
      case 302: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==302);
      case 349: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==349);
{ yylhsminor.yy194 = addNodeToList(pCxt, yymsp[-2].minor.yy194, yymsp[0].minor.yy46); }
  yymsp[-2].minor.yy194 = yylhsminor.yy194;
        break;
      case 107: /* column_def ::= column_name type_name */
{ yylhsminor.yy46 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy95, yymsp[0].minor.yy400, NULL); }
  yymsp[-1].minor.yy46 = yylhsminor.yy46;
        break;
      case 108: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy46 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy95, yymsp[-2].minor.yy400, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy46 = yylhsminor.yy46;
        break;
      case 109: /* type_name ::= BOOL */
{ yymsp[0].minor.yy400 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 110: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy400 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 111: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy400 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 112: /* type_name ::= INT */
      case 113: /* type_name ::= INTEGER */ yytestcase(yyruleno==113);
{ yymsp[0].minor.yy400 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 114: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy400 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 115: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy400 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 116: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy400 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 117: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy400 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 118: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy400 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 119: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy400 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 120: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy400 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 121: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy400 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 122: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy400 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 123: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy400 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 124: /* type_name ::= JSON */
{ yymsp[0].minor.yy400 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 125: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy400 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 126: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy400 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 127: /* type_name ::= BLOB */
{ yymsp[0].minor.yy400 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 128: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy400 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 129: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy400 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 130: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy400 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 131: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy400 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 133: /* tags_def_opt ::= tags_def */
      case 300: /* select_list ::= select_sublist */ yytestcase(yyruleno==300);
{ yylhsminor.yy194 = yymsp[0].minor.yy194; }
  yymsp[0].minor.yy194 = yylhsminor.yy194;
        break;
      case 134: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy194 = yymsp[-1].minor.yy194; }
        break;
      case 135: /* table_options ::= */
{ yymsp[1].minor.yy46 = createDefaultTableOptions(pCxt); }
        break;
      case 136: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy46 = setTableOption(pCxt, yymsp[-2].minor.yy46, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 137: /* table_options ::= table_options KEEP NK_INTEGER */
{ yylhsminor.yy46 = setTableOption(pCxt, yymsp[-2].minor.yy46, TABLE_OPTION_KEEP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 138: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy46 = setTableOption(pCxt, yymsp[-2].minor.yy46, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 139: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy46 = setTableSmaOption(pCxt, yymsp[-4].minor.yy46, yymsp[-1].minor.yy194); }
  yymsp[-4].minor.yy46 = yylhsminor.yy46;
        break;
      case 140: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ yylhsminor.yy46 = setTableRollupOption(pCxt, yymsp[-4].minor.yy46, yymsp[-1].minor.yy194); }
  yymsp[-4].minor.yy46 = yylhsminor.yy46;
        break;
      case 141: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ yylhsminor.yy46 = setTableOption(pCxt, yymsp[-2].minor.yy46, TABLE_OPTION_FILE_FACTOR, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 142: /* table_options ::= table_options DELAY NK_INTEGER */
{ yylhsminor.yy46 = setTableOption(pCxt, yymsp[-2].minor.yy46, TABLE_OPTION_DELAY, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 143: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy46 = createDefaultAlterTableOptions(pCxt); yylhsminor.yy46 = setTableOption(pCxt, yylhsminor.yy46, yymsp[0].minor.yy145.type, &yymsp[0].minor.yy145.val); }
  yymsp[0].minor.yy46 = yylhsminor.yy46;
        break;
      case 144: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy46 = setTableOption(pCxt, yymsp[-1].minor.yy46, yymsp[0].minor.yy145.type, &yymsp[0].minor.yy145.val); }
  yymsp[-1].minor.yy46 = yylhsminor.yy46;
        break;
      case 145: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy145.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy145.val = yymsp[0].minor.yy0; }
        break;
      case 146: /* alter_table_option ::= KEEP NK_INTEGER */
{ yymsp[-1].minor.yy145.type = TABLE_OPTION_KEEP; yymsp[-1].minor.yy145.val = yymsp[0].minor.yy0; }
        break;
      case 147: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy145.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy145.val = yymsp[0].minor.yy0; }
        break;
      case 150: /* col_name ::= column_name */
{ yylhsminor.yy46 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy95); }
  yymsp[0].minor.yy46 = yylhsminor.yy46;
        break;
      case 151: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 152: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 153: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 154: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy46, yymsp[0].minor.yy46); }
        break;
      case 155: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy46, yymsp[0].minor.yy46); }
        break;
      case 156: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy46, NULL); }
        break;
      case 157: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 158: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 159: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 160: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 161: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy46, yymsp[0].minor.yy46); }
        break;
      case 162: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 163: /* db_name_cond_opt ::= */
      case 168: /* from_db_opt ::= */ yytestcase(yyruleno==168);
{ yymsp[1].minor.yy46 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 164: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy46 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy95); }
  yymsp[-1].minor.yy46 = yylhsminor.yy46;
        break;
      case 165: /* like_pattern_opt ::= */
      case 176: /* index_options ::= */ yytestcase(yyruleno==176);
      case 307: /* where_clause_opt ::= */ yytestcase(yyruleno==307);
      case 311: /* twindow_clause_opt ::= */ yytestcase(yyruleno==311);
      case 316: /* sliding_opt ::= */ yytestcase(yyruleno==316);
      case 318: /* fill_opt ::= */ yytestcase(yyruleno==318);
      case 330: /* having_clause_opt ::= */ yytestcase(yyruleno==330);
      case 338: /* slimit_clause_opt ::= */ yytestcase(yyruleno==338);
      case 342: /* limit_clause_opt ::= */ yytestcase(yyruleno==342);
{ yymsp[1].minor.yy46 = NULL; }
        break;
      case 166: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy46 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 167: /* table_name_cond ::= table_name */
{ yylhsminor.yy46 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy95); }
  yymsp[0].minor.yy46 = yylhsminor.yy46;
        break;
      case 169: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy46 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy95); }
        break;
      case 172: /* func_name ::= function_name */
{ yylhsminor.yy46 = createFunctionNode(pCxt, &yymsp[0].minor.yy95, NULL); }
  yymsp[0].minor.yy46 = yylhsminor.yy46;
        break;
      case 173: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy151, &yymsp[-3].minor.yy95, &yymsp[-1].minor.yy95, NULL, yymsp[0].minor.yy46); }
        break;
      case 174: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy151, &yymsp[-5].minor.yy95, &yymsp[-3].minor.yy95, yymsp[-1].minor.yy194, NULL); }
        break;
      case 175: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy151, &yymsp[-2].minor.yy95, &yymsp[0].minor.yy95); }
        break;
      case 177: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy46 = createIndexOption(pCxt, yymsp[-6].minor.yy194, releaseRawExprNode(pCxt, yymsp[-2].minor.yy46), NULL, yymsp[0].minor.yy46); }
        break;
      case 178: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy46 = createIndexOption(pCxt, yymsp[-8].minor.yy194, releaseRawExprNode(pCxt, yymsp[-4].minor.yy46), releaseRawExprNode(pCxt, yymsp[-2].minor.yy46), yymsp[0].minor.yy46); }
        break;
      case 181: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy46 = createFunctionNode(pCxt, &yymsp[-3].minor.yy95, yymsp[-1].minor.yy194); }
  yymsp[-3].minor.yy46 = yylhsminor.yy46;
        break;
      case 182: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy151, &yymsp[-2].minor.yy95, yymsp[0].minor.yy46, NULL); }
        break;
      case 183: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy151, &yymsp[-2].minor.yy95, NULL, &yymsp[0].minor.yy95); }
        break;
      case 184: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy151, &yymsp[0].minor.yy95); }
        break;
      case 185: /* cmd ::= DESC full_table_name */
      case 186: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==186);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy46); }
        break;
      case 187: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 188: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy151, yymsp[-1].minor.yy46, yymsp[0].minor.yy46); }
        break;
      case 190: /* analyze_opt ::= ANALYZE */
      case 297: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==297);
{ yymsp[0].minor.yy151 = true; }
        break;
      case 191: /* explain_options ::= */
{ yymsp[1].minor.yy46 = createDefaultExplainOptions(pCxt); }
        break;
      case 192: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy46 = setExplainVerbose(pCxt, yymsp[-2].minor.yy46, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 193: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy46 = setExplainRatio(pCxt, yymsp[-2].minor.yy46, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 195: /* literal ::= NK_INTEGER */
{ yylhsminor.yy46 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy46 = yylhsminor.yy46;
        break;
      case 196: /* literal ::= NK_FLOAT */
{ yylhsminor.yy46 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy46 = yylhsminor.yy46;
        break;
      case 197: /* literal ::= NK_STRING */
{ yylhsminor.yy46 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy46 = yylhsminor.yy46;
        break;
      case 198: /* literal ::= NK_BOOL */
{ yylhsminor.yy46 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy46 = yylhsminor.yy46;
        break;
      case 199: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy46 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy46 = yylhsminor.yy46;
        break;
      case 200: /* literal ::= duration_literal */
      case 209: /* signed_literal ::= signed */ yytestcase(yyruleno==209);
      case 226: /* expression ::= literal */ yytestcase(yyruleno==226);
      case 227: /* expression ::= pseudo_column */ yytestcase(yyruleno==227);
      case 228: /* expression ::= column_reference */ yytestcase(yyruleno==228);
      case 231: /* expression ::= subquery */ yytestcase(yyruleno==231);
      case 270: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==270);
      case 274: /* boolean_primary ::= predicate */ yytestcase(yyruleno==274);
      case 276: /* common_expression ::= expression */ yytestcase(yyruleno==276);
      case 277: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==277);
      case 279: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==279);
      case 281: /* table_reference ::= table_primary */ yytestcase(yyruleno==281);
      case 282: /* table_reference ::= joined_table */ yytestcase(yyruleno==282);
      case 286: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==286);
      case 333: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==333);
      case 335: /* query_primary ::= query_specification */ yytestcase(yyruleno==335);
{ yylhsminor.yy46 = yymsp[0].minor.yy46; }
  yymsp[0].minor.yy46 = yylhsminor.yy46;
        break;
      case 201: /* literal ::= NULL */
{ yylhsminor.yy46 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL)); }
  yymsp[0].minor.yy46 = yylhsminor.yy46;
        break;
      case 202: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy46 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy46 = yylhsminor.yy46;
        break;
      case 203: /* signed ::= NK_INTEGER */
{ yylhsminor.yy46 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy46 = yylhsminor.yy46;
        break;
      case 204: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy46 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 205: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy46 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy46 = yylhsminor.yy46;
        break;
      case 206: /* signed ::= NK_FLOAT */
{ yylhsminor.yy46 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy46 = yylhsminor.yy46;
        break;
      case 207: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy46 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 208: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy46 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy46 = yylhsminor.yy46;
        break;
      case 210: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy46 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy46 = yylhsminor.yy46;
        break;
      case 211: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy46 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy46 = yylhsminor.yy46;
        break;
      case 212: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy46 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 213: /* signed_literal ::= duration_literal */
      case 347: /* search_condition ::= common_expression */ yytestcase(yyruleno==347);
{ yylhsminor.yy46 = releaseRawExprNode(pCxt, yymsp[0].minor.yy46); }
  yymsp[0].minor.yy46 = yylhsminor.yy46;
        break;
      case 214: /* signed_literal ::= NULL */
{ yymsp[0].minor.yy46 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL); }
        break;
      case 229: /* expression ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy46 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy95, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy95, yymsp[-1].minor.yy194)); }
  yymsp[-3].minor.yy46 = yylhsminor.yy46;
        break;
      case 230: /* expression ::= function_name NK_LP NK_STAR NK_RP */
{ yylhsminor.yy46 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy95, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy95, createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy0)))); }
  yymsp[-3].minor.yy46 = yylhsminor.yy46;
        break;
      case 232: /* expression ::= NK_LP expression NK_RP */
      case 275: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==275);
{ yylhsminor.yy46 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy46)); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 233: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy46);
                                                                                    yylhsminor.yy46 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy46));
                                                                                  }
  yymsp[-1].minor.yy46 = yylhsminor.yy46;
        break;
      case 234: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy46);
                                                                                    yylhsminor.yy46 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[0].minor.yy46), NULL));
                                                                                  }
  yymsp[-1].minor.yy46 = yylhsminor.yy46;
        break;
      case 235: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy46);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy46);
                                                                                    yylhsminor.yy46 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy46), releaseRawExprNode(pCxt, yymsp[0].minor.yy46))); 
                                                                                  }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 236: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy46);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy46);
                                                                                    yylhsminor.yy46 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy46), releaseRawExprNode(pCxt, yymsp[0].minor.yy46))); 
                                                                                  }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 237: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy46);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy46);
                                                                                    yylhsminor.yy46 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy46), releaseRawExprNode(pCxt, yymsp[0].minor.yy46))); 
                                                                                  }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 238: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy46);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy46);
                                                                                    yylhsminor.yy46 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy46), releaseRawExprNode(pCxt, yymsp[0].minor.yy46))); 
                                                                                  }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 239: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy46);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy46);
                                                                                    yylhsminor.yy46 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy46), releaseRawExprNode(pCxt, yymsp[0].minor.yy46))); 
                                                                                  }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 240: /* expression_list ::= expression */
{ yylhsminor.yy194 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy46)); }
  yymsp[0].minor.yy194 = yylhsminor.yy194;
        break;
      case 241: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy194 = addNodeToList(pCxt, yymsp[-2].minor.yy194, releaseRawExprNode(pCxt, yymsp[0].minor.yy46)); }
  yymsp[-2].minor.yy194 = yylhsminor.yy194;
        break;
      case 242: /* column_reference ::= column_name */
{ yylhsminor.yy46 = createRawExprNode(pCxt, &yymsp[0].minor.yy95, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy95)); }
  yymsp[0].minor.yy46 = yylhsminor.yy46;
        break;
      case 243: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy46 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy95, &yymsp[0].minor.yy95, createColumnNode(pCxt, &yymsp[-2].minor.yy95, &yymsp[0].minor.yy95)); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 244: /* pseudo_column ::= NK_UNDERLINE ROWTS */
      case 246: /* pseudo_column ::= NK_UNDERLINE QSTARTTS */ yytestcase(yyruleno==246);
      case 247: /* pseudo_column ::= NK_UNDERLINE QENDTS */ yytestcase(yyruleno==247);
      case 248: /* pseudo_column ::= NK_UNDERLINE WSTARTTS */ yytestcase(yyruleno==248);
      case 249: /* pseudo_column ::= NK_UNDERLINE WENDTS */ yytestcase(yyruleno==249);
      case 250: /* pseudo_column ::= NK_UNDERLINE WDURATION */ yytestcase(yyruleno==250);
{
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy46 = createRawExprNode(pCxt, &t, createFunctionNode(pCxt, &t, NULL));
                                                                                  }
  yymsp[-1].minor.yy46 = yylhsminor.yy46;
        break;
      case 245: /* pseudo_column ::= TBNAME */
{ yylhsminor.yy46 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy46 = yylhsminor.yy46;
        break;
      case 251: /* predicate ::= expression compare_op expression */
      case 256: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==256);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy46);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy46);
                                                                                    yylhsminor.yy46 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy292, releaseRawExprNode(pCxt, yymsp[-2].minor.yy46), releaseRawExprNode(pCxt, yymsp[0].minor.yy46)));
                                                                                  }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 252: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy46);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy46);
                                                                                    yylhsminor.yy46 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy46), releaseRawExprNode(pCxt, yymsp[-2].minor.yy46), releaseRawExprNode(pCxt, yymsp[0].minor.yy46)));
                                                                                  }
  yymsp[-4].minor.yy46 = yylhsminor.yy46;
        break;
      case 253: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy46);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy46);
                                                                                    yylhsminor.yy46 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy46), releaseRawExprNode(pCxt, yymsp[-5].minor.yy46), releaseRawExprNode(pCxt, yymsp[0].minor.yy46)));
                                                                                  }
  yymsp[-5].minor.yy46 = yylhsminor.yy46;
        break;
      case 254: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy46);
                                                                                    yylhsminor.yy46 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy46), NULL));
                                                                                  }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 255: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy46);
                                                                                    yylhsminor.yy46 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy46), NULL));
                                                                                  }
  yymsp[-3].minor.yy46 = yylhsminor.yy46;
        break;
      case 257: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy292 = OP_TYPE_LOWER_THAN; }
        break;
      case 258: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy292 = OP_TYPE_GREATER_THAN; }
        break;
      case 259: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy292 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 260: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy292 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 261: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy292 = OP_TYPE_NOT_EQUAL; }
        break;
      case 262: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy292 = OP_TYPE_EQUAL; }
        break;
      case 263: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy292 = OP_TYPE_LIKE; }
        break;
      case 264: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy292 = OP_TYPE_NOT_LIKE; }
        break;
      case 265: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy292 = OP_TYPE_MATCH; }
        break;
      case 266: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy292 = OP_TYPE_NMATCH; }
        break;
      case 267: /* in_op ::= IN */
{ yymsp[0].minor.yy292 = OP_TYPE_IN; }
        break;
      case 268: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy292 = OP_TYPE_NOT_IN; }
        break;
      case 269: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy46 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy194)); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 271: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy46);
                                                                                    yylhsminor.yy46 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy46), NULL));
                                                                                  }
  yymsp[-1].minor.yy46 = yylhsminor.yy46;
        break;
      case 272: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy46);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy46);
                                                                                    yylhsminor.yy46 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy46), releaseRawExprNode(pCxt, yymsp[0].minor.yy46)));
                                                                                  }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 273: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy46);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy46);
                                                                                    yylhsminor.yy46 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy46), releaseRawExprNode(pCxt, yymsp[0].minor.yy46)));
                                                                                  }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 278: /* from_clause ::= FROM table_reference_list */
      case 308: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==308);
      case 331: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==331);
{ yymsp[-1].minor.yy46 = yymsp[0].minor.yy46; }
        break;
      case 280: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy46 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy46, yymsp[0].minor.yy46, NULL); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 283: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy46 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy95, &yymsp[0].minor.yy95); }
  yymsp[-1].minor.yy46 = yylhsminor.yy46;
        break;
      case 284: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy46 = createRealTableNode(pCxt, &yymsp[-3].minor.yy95, &yymsp[-1].minor.yy95, &yymsp[0].minor.yy95); }
  yymsp[-3].minor.yy46 = yylhsminor.yy46;
        break;
      case 285: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy46 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy46), &yymsp[0].minor.yy95); }
  yymsp[-1].minor.yy46 = yylhsminor.yy46;
        break;
      case 287: /* alias_opt ::= */
{ yymsp[1].minor.yy95 = nil_token;  }
        break;
      case 288: /* alias_opt ::= table_alias */
{ yylhsminor.yy95 = yymsp[0].minor.yy95; }
  yymsp[0].minor.yy95 = yylhsminor.yy95;
        break;
      case 289: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy95 = yymsp[0].minor.yy95; }
        break;
      case 290: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 291: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==291);
{ yymsp[-2].minor.yy46 = yymsp[-1].minor.yy46; }
        break;
      case 292: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy46 = createJoinTableNode(pCxt, yymsp[-4].minor.yy10, yymsp[-5].minor.yy46, yymsp[-2].minor.yy46, yymsp[0].minor.yy46); }
  yymsp[-5].minor.yy46 = yylhsminor.yy46;
        break;
      case 293: /* join_type ::= */
{ yymsp[1].minor.yy10 = JOIN_TYPE_INNER; }
        break;
      case 294: /* join_type ::= INNER */
{ yymsp[0].minor.yy10 = JOIN_TYPE_INNER; }
        break;
      case 295: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy46 = createSelectStmt(pCxt, yymsp[-7].minor.yy151, yymsp[-6].minor.yy194, yymsp[-5].minor.yy46);
                                                                                    yymsp[-8].minor.yy46 = addWhereClause(pCxt, yymsp[-8].minor.yy46, yymsp[-4].minor.yy46);
                                                                                    yymsp[-8].minor.yy46 = addPartitionByClause(pCxt, yymsp[-8].minor.yy46, yymsp[-3].minor.yy194);
                                                                                    yymsp[-8].minor.yy46 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy46, yymsp[-2].minor.yy46);
                                                                                    yymsp[-8].minor.yy46 = addGroupByClause(pCxt, yymsp[-8].minor.yy46, yymsp[-1].minor.yy194);
                                                                                    yymsp[-8].minor.yy46 = addHavingClause(pCxt, yymsp[-8].minor.yy46, yymsp[0].minor.yy46);
                                                                                  }
        break;
      case 298: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy151 = false; }
        break;
      case 299: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy194 = NULL; }
        break;
      case 303: /* select_item ::= common_expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy46);
                                                                                    yylhsminor.yy46 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy46), &t);
                                                                                  }
  yymsp[0].minor.yy46 = yylhsminor.yy46;
        break;
      case 304: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy46 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy46), &yymsp[0].minor.yy95); }
  yymsp[-1].minor.yy46 = yylhsminor.yy46;
        break;
      case 305: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy46 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy46), &yymsp[0].minor.yy95); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 306: /* select_item ::= table_name NK_DOT NK_STAR */
{ yylhsminor.yy46 = createColumnNode(pCxt, &yymsp[-2].minor.yy95, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 310: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 327: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==327);
      case 337: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==337);
{ yymsp[-2].minor.yy194 = yymsp[0].minor.yy194; }
        break;
      case 312: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy46 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy46), releaseRawExprNode(pCxt, yymsp[-1].minor.yy46)); }
        break;
      case 313: /* twindow_clause_opt ::= STATE_WINDOW NK_LP column_reference NK_RP */
{ yymsp[-3].minor.yy46 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy46)); }
        break;
      case 314: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy46 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy46), NULL, yymsp[-1].minor.yy46, yymsp[0].minor.yy46); }
        break;
      case 315: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy46 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy46), releaseRawExprNode(pCxt, yymsp[-3].minor.yy46), yymsp[-1].minor.yy46, yymsp[0].minor.yy46); }
        break;
      case 317: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy46 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy46); }
        break;
      case 319: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy46 = createFillNode(pCxt, yymsp[-1].minor.yy6, NULL); }
        break;
      case 320: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy46 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy194)); }
        break;
      case 321: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy6 = FILL_MODE_NONE; }
        break;
      case 322: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy6 = FILL_MODE_PREV; }
        break;
      case 323: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy6 = FILL_MODE_NULL; }
        break;
      case 324: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy6 = FILL_MODE_LINEAR; }
        break;
      case 325: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy6 = FILL_MODE_NEXT; }
        break;
      case 328: /* group_by_list ::= expression */
{ yylhsminor.yy194 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy46))); }
  yymsp[0].minor.yy194 = yylhsminor.yy194;
        break;
      case 329: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy194 = addNodeToList(pCxt, yymsp[-2].minor.yy194, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy46))); }
  yymsp[-2].minor.yy194 = yylhsminor.yy194;
        break;
      case 332: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy46 = addOrderByClause(pCxt, yymsp[-3].minor.yy46, yymsp[-2].minor.yy194);
                                                                                    yylhsminor.yy46 = addSlimitClause(pCxt, yylhsminor.yy46, yymsp[-1].minor.yy46);
                                                                                    yylhsminor.yy46 = addLimitClause(pCxt, yylhsminor.yy46, yymsp[0].minor.yy46);
                                                                                  }
  yymsp[-3].minor.yy46 = yylhsminor.yy46;
        break;
      case 334: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy46 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy46, yymsp[0].minor.yy46); }
  yymsp[-3].minor.yy46 = yylhsminor.yy46;
        break;
      case 339: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 343: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==343);
{ yymsp[-1].minor.yy46 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 340: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 344: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==344);
{ yymsp[-3].minor.yy46 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 341: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 345: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==345);
{ yymsp[-3].minor.yy46 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 346: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy46 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy46); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 350: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy46 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy46), yymsp[-1].minor.yy456, yymsp[0].minor.yy273); }
  yymsp[-2].minor.yy46 = yylhsminor.yy46;
        break;
      case 351: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy456 = ORDER_ASC; }
        break;
      case 352: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy456 = ORDER_ASC; }
        break;
      case 353: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy456 = ORDER_DESC; }
        break;
      case 354: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy273 = NULL_ORDER_DEFAULT; }
        break;
      case 355: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy273 = NULL_ORDER_FIRST; }
        break;
      case 356: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy273 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (pCxt->valid) {
    if(TOKEN.z) {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
    pCxt->valid = false;
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
