/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 487
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EJoinType yy140;
  SDataType yy310;
  STokenPair yy347;
  EOperatorType yy354;
  SAlterOption yy365;
  SToken yy371;
  ENullOrder yy399;
  int32_t yy416;
  SNode* yy452;
  int8_t yy475;
  bool yy667;
  EOrder yy690;
  int64_t yy729;
  SNodeList* yy812;
  EFillMode yy844;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             800
#define YYNRULE              600
#define YYNRULE_WITH_ACTION  600
#define YYNTOKEN             338
#define YY_MAX_SHIFT         799
#define YY_MIN_SHIFTREDUCE   1180
#define YY_MAX_SHIFTREDUCE   1779
#define YY_ERROR_ACTION      1780
#define YY_ACCEPT_ACTION     1781
#define YY_NO_ACTION         1782
#define YY_MIN_REDUCE        1783
#define YY_MAX_REDUCE        2382
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2858)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  2126, 2193, 2171, 2082,  221,  690, 1960, 2154,  537, 1949,
 /*    10 */  1826,  670,   48,   46, 1706,  394, 2179, 1213, 2079,  677,
 /*    20 */   401, 2358, 1555,   41,   40,  135, 2175,   47,   45,   44,
 /*    30 */    43,   42,  574, 1636,  453, 1553, 2171,  539, 1582, 2211,
 /*    40 */    41,   40, 1781,  536,   47,   45,   44,   43,   42,  254,
 /*    50 */  1951, 2161, 1945,  706,  630,  531, 1215, 2353, 1218, 1219,
 /*    60 */  2175,  181, 1631,  529, 2177,  398,  525,  521,   19, 1238,
 /*    70 */    66, 1237, 2359,  188,  700, 1561,   30, 2354,  656,  348,
 /*    80 */   689,  369, 2065,  361,  140,  690, 1960, 2192, 1580, 2228,
 /*    90 */   667,  144,  112, 2194,  710, 2196, 2197,  705, 2177,  700,
 /*   100 */   796,  168, 1239,   15,  185,  135, 2281,  103,  700, 1901,
 /*   110 */   397, 2277,  579,  497, 2082,  416,   48,   46,  690, 1960,
 /*   120 */   415,  689, 1769,  190,  401,  264, 1555, 1665, 1371, 2080,
 /*   130 */   677, 2307, 1953, 1580,   38,  306, 1746, 1636,  193, 1553,
 /*   140 */  1638, 1639, 1806, 1362,  735,  734,  733, 1366,  732, 1368,
 /*   150 */  1369,  731,  728, 1805, 1377,  725, 1379, 1380,  722,  719,
 /*   160 */   716,  184,  630,   51,  655, 2353, 1631, 2353,   94,   62,
 /*   170 */  1611, 1621,   19, 2000,  212,  211, 1637, 1640,  675, 1561,
 /*   180 */  2359,  188,  654,  188, 1666, 2354,  656, 2354,  656, 2296,
 /*   190 */   288, 1556, 2161, 1554,  286, 2289,  666,  496,  136,  665,
 /*   200 */   169, 2353, 1795, 2161,  796,   41,   40,   15, 2193,   47,
 /*   210 */    45,   44,   43,   42,   62, 2293,  654,  188,  707, 1315,
 /*   220 */   435, 2354,  656, 1559, 1560, 1783, 1610, 1613, 1614, 1615,
 /*   230 */  1616, 1617, 1618, 1619, 1620,  702,  698, 1629, 1630, 1632,
 /*   240 */  1633, 1634, 1635,    2, 1638, 1639, 2211,  437,  433,  134,
 /*   250 */   133,  132,  131,  130,  129,  128,  127,  126, 2161, 1317,
 /*   260 */   706, 1784,   37,  399, 1660, 1661, 1662, 1663, 1664, 1668,
 /*   270 */  1669, 1670, 1671,  534, 1611, 1621,  535, 1819,  551, 1580,
 /*   280 */  1637, 1640,  125, 1464, 1465,  124,  123,  122,  121,  120,
 /*   290 */   119,  118,  117,  116, 2192, 1556, 2228, 1554,  645,  112,
 /*   300 */  2194,  710, 2196, 2197,  705,  650,  700, 2044,  395,  147,
 /*   310 */  1580,  151, 2252, 2281, 1581, 2193,  166,  397, 2277, 1238,
 /*   320 */   191, 1237,  667,  144, 1962,  670,  191, 1559, 1560, 1703,
 /*   330 */  1610, 1613, 1614, 1615, 1616, 1617, 1618, 1619, 1620,  702,
 /*   340 */   698, 1629, 1630, 1632, 1633, 1634, 1635,    2,   12,   48,
 /*   350 */    46,  745, 1239, 2211, 2013,  410,  409,  401, 2182, 1555,
 /*   360 */  2358,  367,   62, 2353,  181, 2161, 1582,  706,  615, 2011,
 /*   370 */  1636,  191, 1553,  592,  591,  590,  690, 1960, 1562, 2357,
 /*   380 */   582,  141,  586, 2354, 2356, 2066,  585,  649,  651,  646,
 /*   390 */   639,  584,  589,  377,  376,  146,   56,  583, 2252, 1631,
 /*   400 */   252, 2192,  629, 2228,  251,   19,  112, 2194,  710, 2196,
 /*   410 */  2197,  705, 1561,  700, 2184, 2211,  297,  298,  185,  542,
 /*   420 */  2281,  296,  535, 1819,  397, 2277,  187, 2289, 2290, 2193,
 /*   430 */   142, 2294, 1221,  655, 1406, 1407, 2353,  796, 1579,  707,
 /*   440 */    15, 1828,   41,   40, 1272, 2308,   47,   45,   44,   43,
 /*   450 */    42,  654,  188,   48,   46, 1641, 2354,  656,  223, 2193,
 /*   460 */  1612,  401,  537, 1555, 1826,   93,  475, 2211,  356,  707,
 /*   470 */   648,  381,  166,  608, 1636,  474, 1553, 1638, 1639, 2161,
 /*   480 */  1963,  706, 2358,  125, 1273, 2353,  124,  123,  122,  121,
 /*   490 */   120,  119,  118,  117,  116, 2013,   62, 2211, 1804,  667,
 /*   500 */   144, 2357,  382, 1631,   12, 2354, 2355, 1611, 1621, 2161,
 /*   510 */  2011,  706,  109, 1637, 1640, 2192, 1561, 2228,  288,  191,
 /*   520 */   112, 2194,  710, 2196, 2197,  705,   60,  700, 1556,  145,
 /*   530 */  1554,  578, 2373,  627, 2281,  577, 1565, 1952,  397, 2277,
 /*   540 */  1710,  796,  690, 1960,   49, 2192, 1580, 2228, 2161, 2193,
 /*   550 */   170, 2194,  710, 2196, 2197,  705,   12,  700,   10,  707,
 /*   560 */  1559, 1560,  451, 1610, 1613, 1614, 1615, 1616, 1617, 1618,
 /*   570 */  1619, 1620,  702,  698, 1629, 1630, 1632, 1633, 1634, 1635,
 /*   580 */     2, 1638, 1639,  445, 1326,  444, 1702, 2211,   41,   40,
 /*   590 */   631, 2318,   47,   45,   44,   43,   42, 1325, 2296, 2161,
 /*   600 */  1583,  706,  669,  186, 2289, 2290,  165,  142, 2294, 1561,
 /*   610 */  1803, 1611, 1621,  690, 1960,  443,  406, 1637, 1640, 2006,
 /*   620 */  2008,   41,   40,  404, 2292,   47,   45,   44,   43,   42,
 /*   630 */  2296,  163, 1556,  452, 1554, 2192,  676, 2228,  383, 1962,
 /*   640 */   112, 2194,  710, 2196, 2197,  705, 2011,  700,  253,  689,
 /*   650 */   447, 2193, 2256,  191, 2281,  446, 2291, 2155,  397, 2277,
 /*   660 */  2161,  707,  506, 2315, 1559, 1560,  154, 1610, 1613, 1614,
 /*   670 */  1615, 1616, 1617, 1618, 1619, 1620,  702,  698, 1629, 1630,
 /*   680 */  1632, 1633, 1634, 1635,    2,   48,   46, 1937,  549, 2211,
 /*   690 */  2075,  457, 2061,  401,  755, 1555, 1612,  630,  667,  144,
 /*   700 */  2353, 2161, 2013,  706,  630, 1936, 1636, 2353, 1553,  391,
 /*   710 */    47,   45,   44,   43,   42, 2359,  188, 2011, 1526, 1527,
 /*   720 */  2354,  656, 2359,  188,  463, 2061,   55, 2354,  656,   14,
 /*   730 */    13, 1734,   51,  690, 1960, 1631, 1947, 2192,  202, 2228,
 /*   740 */   597,  676,  112, 2194,  710, 2196, 2197,  705, 1561,  700,
 /*   750 */   690, 1960,  266,  465, 2373,  607, 2281, 1862,   41,   40,
 /*   760 */   397, 2277,   47,   45,   44,   43,   42, 2193, 1802,  250,
 /*   770 */   480,  205,  745,  796,  690, 1960,   49,  704,  642,  641,
 /*   780 */  1732, 1733, 1735, 1736, 1737,  600,  490, 2061, 2357,   48,
 /*   790 */    46, 1935,  594,  674,  481, 2075, 1776,  401,  249, 1555,
 /*   800 */   404, 1581,  189, 2289, 2290, 2211,  142, 2294,  166,  692,
 /*   810 */  1636, 2253, 1553, 1638, 1639, 1846, 1962, 2161, 2161,  706,
 /*   820 */   743,  156,  155,  740,  739,  738,  153,  592,  591,  590,
 /*   830 */  2007, 2008, 1679,  210,  582,  141,  586,  593,   70, 1631,
 /*   840 */   585,   69,   52, 1611, 1621,  584,  589,  377,  376, 1637,
 /*   850 */  1640,  583, 1561, 2192, 1745, 2228, 1241, 1242,  342, 2194,
 /*   860 */   710, 2196, 2197,  705, 1556,  700, 1554, 2247,   41,   40,
 /*   870 */  1801, 1943,   47,   45,   44,   43,   42,  796,  570,  569,
 /*   880 */    15, 2193,  743,  156,  155,  740,  739,  738,  153, 1800,
 /*   890 */   613,  707,  207, 2328, 1799, 1964, 1559, 1560, 1775, 1610,
 /*   900 */  1613, 1614, 1615, 1616, 1617, 1618, 1619, 1620,  702,  698,
 /*   910 */  1629, 1630, 1632, 1633, 1634, 1635,    2, 1638, 1639, 2211,
 /*   920 */  2161, 1481, 1482,  606,  743,  156,  155,  740,  739,  738,
 /*   930 */   153, 2161,   86,  706, 2013,   85,  604,  630,  602, 2161,
 /*   940 */  2353,  396,  690, 1960, 2161,  690, 1960, 1611, 1621, 2011,
 /*   950 */   736,  690, 1960, 1637, 1640, 2359,  188, 1480, 1483,  259,
 /*   960 */  2354,  656,  550,  737, 1722, 1957, 2004, 2192, 1556, 2228,
 /*   970 */  1554,  255,  112, 2194,  710, 2196, 2197,  705,    9,  700,
 /*   980 */   588,  587,   34, 2147, 2373, 1330, 2281,  676,   41,   40,
 /*   990 */   397, 2277,   47,   45,   44,   43,   42, 1798, 1329,  191,
 /*  1000 */  1559, 1560, 1859, 1610, 1613, 1614, 1615, 1616, 1617, 1618,
 /*  1010 */  1619, 1620,  702,  698, 1629, 1630, 1632, 1633, 1634, 1635,
 /*  1020 */     2, 1646,  352,  167, 1578,  690, 1960, 1580,  327,  690,
 /*  1030 */  1960,  488,  423,   90,  504,  572,  571,  503, 2171,  685,
 /*  1040 */   407, 2075,  324,   73, 2144,  263,   72, 2161,  166,  673,
 /*  1050 */   371, 2013, 2180,  471,  671,  505, 1962,  349,  405, 1955,
 /*  1060 */   473,  701, 2175,  508, 1797,  658, 2011, 1794,  219,  516,
 /*  1070 */   514,  511,  773,  772,  771,  770,  413, 1938,  769,  768,
 /*  1080 */   148,  763,  762,  761,  760,  759,  758,  757,  158,  753,
 /*  1090 */   752,  751,  412,  411,  748,  747,  746,  176,  175, 1583,
 /*  1100 */  2177,  630,  690, 1960, 2353, 1583,  370,  237,   62,  374,
 /*  1110 */   700,   44,   43,   42, 2161,  690, 1960, 2161,  459, 2359,
 /*  1120 */   188,  149,  301,  173, 2354,  656,  690, 1960,  262,  690,
 /*  1130 */  1960,  568,  564,  560,  556,  687,  236, 1793,  662,  694,
 /*  1140 */  1667, 2253,  767,  765, 1792, 1791,  688,  111,  501,  307,
 /*  1150 */  1790,  495,  494,  493,  492,  487,  486,  485,  484,  483,
 /*  1160 */   479,  478,  477,  476,  351,  468,  467,  466,  659,  461,
 /*  1170 */   460,  368,  690, 1960, 2301, 1699,   91, 1612,  375,  234,
 /*  1180 */   373,  372, 1837,  576,   90, 1789, 1788, 2161,   81,   80,
 /*  1190 */   450, 2193,  408,  200, 2161, 2161, 1787, 2013, 1699,  741,
 /*  1200 */  2161,  707, 2004,  637,  595,  578,  442,  440, 1786,  577,
 /*  1210 */  1956,  742, 2012,  320, 2004, 1902, 1990,  350,   35,   54,
 /*  1220 */   431,    3, 2193,  429,  425,  421,  418,  443, 1672, 2211,
 /*  1230 */   756,  454,  707, 1922, 2346, 2161, 2161, 1218, 1219,  154,
 /*  1240 */    83, 2161,  137,  706,  455,   74, 2161,  233,  227,  580,
 /*  1250 */   242,  203, 2193,  240,  232,  547,  244,  265, 2161,  243,
 /*  1260 */  2211,  430,  707,  246, 2300,  191,  245,  248,  154,  581,
 /*  1270 */   247, 1313, 2161,  225,  706, 1835,   50, 2192,  610, 2228,
 /*  1280 */   609,   50,  112, 2194,  710, 2196, 2197,  705,  697,  700,
 /*  1290 */  2211, 1311, 1778, 1779, 2373,   84, 2281,  598, 1796, 1521,
 /*  1300 */   397, 2277, 2161,  643,  706, 1564,  270,  154, 2192,  108,
 /*  1310 */  2228, 2321,  283,  112, 2194,  710, 2196, 2197,  705,  105,
 /*  1320 */   700,   50,  294, 1563, 1555, 2373,   71, 2281, 1524,  152,
 /*  1330 */   154,  397, 2277,   14,   13,   64, 1731, 1553, 2192,   50,
 /*  1340 */  2228, 1730, 2193,  112, 2194,  710, 2196, 2197,  705,   50,
 /*  1350 */   700, 1829,  707,  410,  409, 2373,  277, 2281,   36,  714,
 /*  1360 */   139,  397, 2277, 1569,   41,   40,  272,  672,   47,   45,
 /*  1370 */    44,   43,   42, 2193, 1636, 1900, 1562, 1561,  663,  152,
 /*  1380 */  2211, 1478,  299,  707,  154,  749,  682, 1899, 2212,  303,
 /*  1390 */  1356,  750, 2161,  138,  706, 1673,  384,  152, 2070, 1622,
 /*  1400 */   414,  791,  796, 1631, 1820, 1825,  660, 1291, 2001,  319,
 /*  1410 */  2193, 2211, 2311, 1289,  668,  285, 1561,  282,  422, 1384,
 /*  1420 */   707,    1,  417, 2161,    5,  706,  365, 1586, 2192,  438,
 /*  1430 */  2228, 1502,  196,  112, 2194,  710, 2196, 2197,  705, 1388,
 /*  1440 */   700,  696,  439, 1657, 1395, 2254,  441, 2281, 2211,  195,
 /*  1450 */   198,  397, 2277, 1393,  314, 1579,  456,  157,  209, 2192,
 /*  1460 */  2161, 2228,  706, 1567,  112, 2194,  710, 2196, 2197,  705,
 /*  1470 */  1583,  700,  462,  458,  469,  499,  693, 2071, 2281,  464,
 /*  1480 */  1578, 1566,  397, 2277,  482,  491,  489, 2063,  498,  500,
 /*  1490 */   509,  510,  507, 1556,  213, 1554, 2192,  214, 2228, 2193,
 /*  1500 */   512,  113, 2194,  710, 2196, 2197,  705,  513,  700,  707,
 /*  1510 */  1584,  216,  532,  515,  517, 2281,    4,  533,  540, 2280,
 /*  1520 */  2277,  541,  543, 1581,  224, 1559, 1560,  226, 1585,  544,
 /*  1530 */   545, 1587, 1570,  546, 1565,  229,  548, 2211,  231,   88,
 /*  1540 */    89,  552,  235,  573,  355,  575, 1950,  114, 2193, 2161,
 /*  1550 */   239,  706, 1946,  612,  614,   92,  150,  618,  707,  315,
 /*  1560 */   256,  619,  617, 2135, 1573, 1575,  241,  159,  160, 1948,
 /*  1570 */   258,  260, 1944,  161, 2193,  162, 2132,  698, 1629, 1630,
 /*  1580 */  1632, 1633, 1634, 1635,  704, 2192, 2211, 2228,  625, 1509,
 /*  1590 */   113, 2194,  710, 2196, 2197,  705, 2131,  700, 2161,  644,
 /*  1600 */   706,  622,  634,    8, 2281, 2312, 2327,  680,  695, 2277,
 /*  1610 */   640, 2322, 2211,  387,  624, 2326,  647,  623,  268,  271,
 /*  1620 */  2303,  653,  276,  635, 2161, 2193,  706,  632,  633,  281,
 /*  1630 */  2376,  388, 1699,  661,  708,  707, 2228,  664, 2193,  113,
 /*  1640 */  2194,  710, 2196, 2197,  705,  143,  700, 1582,  707,  289,
 /*  1650 */   178, 1588,  278, 2281, 2076,  316,   98,  360, 2277, 2297,
 /*  1660 */  2192,  317, 2228, 2211,  678,  342, 2194,  710, 2196, 2197,
 /*  1670 */   705,  703,  700,  691, 2246, 2161, 2211,  706,  679,  683,
 /*  1680 */  2090,  279,  174,  684, 2089,  280,  100, 2193, 2161,  318,
 /*  1690 */   706, 2088,  393,  102,   61, 2262,  104,  707, 2352, 1961,
 /*  1700 */   712, 2005, 1923,  792, 2193,  284,  793,  321,  795, 2153,
 /*  1710 */   357, 2192,  310, 2228,  707,  358,  171, 2194,  710, 2196,
 /*  1720 */  2197,  705,   53,  700, 2192, 2211, 2228,  325,  323,  113,
 /*  1730 */  2194,  710, 2196, 2197,  705,  345,  700, 2161, 2152,  706,
 /*  1740 */   330,  344, 2211, 2281,  334, 2151,   78,  385, 2278, 2148,
 /*  1750 */   419,  420, 1546, 2193, 2161, 1547,  706,  194,  424, 2146,
 /*  1760 */   426,  427,  428,  707, 2145,  366, 2143,  657, 2374,  432,
 /*  1770 */  2142, 2141,  434, 2192,  436, 2228, 1537, 2193,  170, 2194,
 /*  1780 */   710, 2196, 2197,  705, 2122,  700,  197,  707, 2121,  199,
 /*  1790 */  2192, 2211, 2228, 1505,   79,  343, 2194,  710, 2196, 2197,
 /*  1800 */   705, 1504,  700, 2161, 2193,  706, 2103, 2102, 2101,  448,
 /*  1810 */   449, 2100, 2099, 2054,  707, 2211, 1455, 2053, 2050, 2319,
 /*  1820 */   386,  201, 2049,   82, 2193, 2048, 2047, 2161, 2052,  706,
 /*  1830 */   204, 2051, 2046, 2045,  707, 2043, 2042, 2041,  206, 2192,
 /*  1840 */   470, 2228, 2211, 2040,  336, 2194,  710, 2196, 2197,  705,
 /*  1850 */   472,  700, 2056, 2039, 2161, 2038,  706, 2037, 2036, 2035,
 /*  1860 */  2034, 2033, 2211, 2192, 2032, 2228, 2031,  392,  343, 2194,
 /*  1870 */   710, 2196, 2197,  705, 2161,  700,  706,  208, 2024, 2023,
 /*  1880 */    87, 2022, 2021, 2055, 2020, 2019,  215,  652, 2030, 2029,
 /*  1890 */  2192, 2193, 2228, 2028, 2027,  171, 2194,  710, 2196, 2197,
 /*  1900 */   705,  707,  700, 2026, 2025, 2018, 2017, 2016, 1457, 2015,
 /*  1910 */  2192,  502, 2228, 2014, 1327,  343, 2194,  710, 2196, 2197,
 /*  1920 */   705, 2193,  700,  353,  354, 1865, 1323, 1864, 1863, 2211,
 /*  1930 */  1331,  707,  217,  218,  400, 1861, 1858,  520, 1857,  519,
 /*  1940 */   524, 2161, 1850,  706,  523,  518,  522, 2375,  527,  526,
 /*  1950 */  1839,  528,  530, 1815, 1220,   76, 1814,  220, 2120, 2211,
 /*  1960 */  2110,   77,  182,  222,  402, 2098, 2181,  183,  538,  228,
 /*  1970 */  2097, 2161,  230,  706,  553,  554,  555, 2192, 2074, 2228,
 /*  1980 */  2193, 1939,  343, 2194,  710, 2196, 2197,  705,  616,  700,
 /*  1990 */   707, 1860, 1856, 1265, 1854,  558,  557, 1852,  559,  561,
 /*  2000 */   562,  563, 1849,  565,  566,  567,  799, 2192, 1834, 2228,
 /*  2010 */  1832, 1833,  343, 2194,  710, 2196, 2197,  705, 2211,  700,
 /*  2020 */   313, 1831, 1811, 1941, 1940, 1400, 1399,  764, 1314,  766,
 /*  2030 */  2161, 1312,  706, 1310, 1309, 1308,  180, 1847, 1307, 1301,
 /*  2040 */  1306,   63,  238, 1838,  789,  785,  781,  777, 1303,  311,
 /*  2050 */  1302, 1300,  378, 2193,  379, 1836,  380,  596, 1810, 1809,
 /*  2060 */   599,  601,  603,  707, 1808, 2119,  611,  605, 2228,  115,
 /*  2070 */  1531,  338, 2194,  710, 2196, 2197,  705, 1533,  700, 1530,
 /*  2080 */  1535, 1511,   29,   67, 2193, 1515, 2109, 2096, 1513,  110,
 /*  2090 */   164, 2211,  304,  620,  707, 2095, 2358,   20,   17, 1748,
 /*  2100 */     6,   21,   65, 2161,   31,  706,   57,  261,    7,  626,
 /*  2110 */   275,  638,  267,  621,   22, 1490, 1489,  274,  269, 2193,
 /*  2120 */   636,  172, 2211,  628, 1729,  686, 2182,   33,   24,  707,
 /*  2130 */    58,  273,   32,   23, 2161, 1721,  706, 1768,   18, 2192,
 /*  2140 */  1769, 2228,   95, 1763,  328, 2194,  710, 2196, 2197,  705,
 /*  2150 */  1762,  700,  389, 1767, 1766,  390, 2193, 2211,  287,  177,
 /*  2160 */   291, 2094, 2073,  292,   97, 1696,  707,  290,   59, 2161,
 /*  2170 */  2192,  706, 2228, 1695, 2072,  326, 2194,  710, 2196, 2197,
 /*  2180 */   705, 2193,  700,   96,   25,  295,  257,   99,  105,  293,
 /*  2190 */   305,  707, 1727,  300, 2211,   68,   26,  101, 1648,   11,
 /*  2200 */    13, 1647, 1571,  179, 2231, 2192, 2161, 2228,  706, 1658,
 /*  2210 */   329, 2194,  710, 2196, 2197,  705,  681,  700, 2193, 2211,
 /*  2220 */   302, 1603,  192,  711,  713, 1626, 1624,  403,  707,  699,
 /*  2230 */    39, 2161, 1623,  706,   16,   27,  717, 1595,   28,  720,
 /*  2240 */  1385,  715, 2192, 2193, 2228, 1382, 1381,  335, 2194,  710,
 /*  2250 */  2196, 2197,  705,  707,  700, 1378, 2211,  718,  721,  723,
 /*  2260 */   724,  726, 1372,  709, 1370,  729,  727, 2192, 2161, 2228,
 /*  2270 */   706,  730,  339, 2194,  710, 2196, 2197,  705, 1376,  700,
 /*  2280 */   106, 2211,  308, 1394, 1375, 1390,  107,   75, 1263, 1374,
 /*  2290 */  1373,  744, 1295, 2161, 1294,  706, 1293, 1292,  309, 1290,
 /*  2300 */  1288, 1287, 1286, 1321, 2192,  754, 2228, 1284, 1283,  331,
 /*  2310 */  2194,  710, 2196, 2197,  705, 2193,  700, 1282, 1281, 1280,
 /*  2320 */  1279, 1278, 1318, 1316, 1275,  707, 1274, 1271, 1270, 2192,
 /*  2330 */  2193, 2228, 1269, 1268,  340, 2194,  710, 2196, 2197,  705,
 /*  2340 */   707,  700, 1855,  774,  775,  776, 1853,  778, 2193,  779,
 /*  2350 */  1851,  782,  780, 2211,  783, 1848,  784,  786,  707,  788,
 /*  2360 */  1830,  790, 1210,  787, 1807, 2161,  312,  706, 2211,  794,
 /*  2370 */  1782, 1557,  798,  322,  797, 1782, 1782, 1782, 1782, 1782,
 /*  2380 */  2161, 1782,  706, 1782, 1782, 1782, 2211, 1782, 1782, 1782,
 /*  2390 */  1782, 1782, 1782, 1782, 1782, 2193, 1782, 1782, 2161, 1782,
 /*  2400 */   706, 2192, 1782, 2228, 1782,  707,  332, 2194,  710, 2196,
 /*  2410 */  2197,  705, 1782,  700, 1782, 1782, 2192, 2193, 2228, 1782,
 /*  2420 */  1782,  341, 2194,  710, 2196, 2197,  705,  707,  700, 1782,
 /*  2430 */  1782, 1782, 1782, 2211, 2192, 1782, 2228, 1782, 1782,  333,
 /*  2440 */  2194,  710, 2196, 2197,  705, 2161,  700,  706, 1782, 1782,
 /*  2450 */  1782, 1782, 1782, 1782, 1782, 2211, 1782, 1782, 1782, 1782,
 /*  2460 */  1782, 1782, 1782, 1782, 2193, 1782, 1782, 2161, 1782,  706,
 /*  2470 */  1782, 1782, 1782, 1782,  707, 1782, 1782, 1782, 1782, 1782,
 /*  2480 */  1782, 2192, 1782, 2228, 1782, 1782,  346, 2194,  710, 2196,
 /*  2490 */  2197,  705, 1782,  700, 1782, 1782, 1782, 1782, 1782, 1782,
 /*  2500 */  1782, 1782, 2211, 2192, 1782, 2228, 1782, 1782,  347, 2194,
 /*  2510 */   710, 2196, 2197,  705, 2161,  700,  706, 1782, 1782, 1782,
 /*  2520 */  1782, 1782, 1782, 2193, 1782, 1782, 1782, 1782, 1782, 1782,
 /*  2530 */  1782, 1782, 1782,  707, 1782, 1782, 2193, 1782, 1782, 1782,
 /*  2540 */  1782, 1782, 1782, 1782, 1782, 1782,  707, 1782, 1782, 1782,
 /*  2550 */  2192, 1782, 2228, 2193, 1782, 2205, 2194,  710, 2196, 2197,
 /*  2560 */   705, 2211,  700,  707, 1782, 1782, 1782, 1782, 1782, 1782,
 /*  2570 */  1782, 1782, 1782, 2161, 2211,  706, 1782, 1782, 1782, 1782,
 /*  2580 */  1782, 1782, 1782, 1782, 1782, 2193, 2161, 1782,  706, 1782,
 /*  2590 */  1782, 2211, 1782, 1782, 1782,  707, 1782, 1782, 1782, 1782,
 /*  2600 */  1782, 1782, 1782, 2161, 1782,  706, 1782, 1782, 1782, 2192,
 /*  2610 */  1782, 2228, 1782, 1782, 2204, 2194,  710, 2196, 2197,  705,
 /*  2620 */  1782,  700, 2192, 2211, 2228, 1782, 1782, 2203, 2194,  710,
 /*  2630 */  2196, 2197,  705, 1782,  700, 2161, 1782,  706, 1782, 2192,
 /*  2640 */  1782, 2228, 1782, 1782,  362, 2194,  710, 2196, 2197,  705,
 /*  2650 */  1782,  700, 2193, 1782, 1782, 1782, 1782, 1782, 1782, 1782,
 /*  2660 */  1782, 1782,  707, 1782, 1782, 1782, 1782, 1782, 1782, 1782,
 /*  2670 */  1782, 2192, 2193, 2228, 1782, 1782,  363, 2194,  710, 2196,
 /*  2680 */  2197,  705,  707,  700, 1782, 1782, 1782, 1782, 1782, 1782,
 /*  2690 */  2211, 1782, 1782, 1782, 1782, 1782, 1782, 1782, 1782, 1782,
 /*  2700 */  1782, 1782, 2161, 1782,  706, 1782, 1782, 1782, 1782, 1782,
 /*  2710 */  2211, 1782, 1782, 1782, 1782, 1782, 1782, 1782, 1782, 1782,
 /*  2720 */  1782, 1782, 2161, 1782,  706, 1782, 1782, 1782, 1782, 1782,
 /*  2730 */  1782, 1782, 1782, 1782, 1782, 1782, 1782, 1782, 2192, 1782,
 /*  2740 */  2228, 1782, 2193,  359, 2194,  710, 2196, 2197,  705, 1782,
 /*  2750 */   700, 1782,  707, 1782, 1782, 1782, 1782, 1782, 2192, 2193,
 /*  2760 */  2228, 1782, 1782,  364, 2194,  710, 2196, 2197,  705,  707,
 /*  2770 */   700, 1782, 1782, 1782, 1782, 1782, 1782, 1782, 1782, 1782,
 /*  2780 */  2211, 1782, 1782, 1782, 1782, 1782, 1782, 1782, 1782, 1782,
 /*  2790 */  1782, 1782, 2161, 1782,  706, 1782, 1782, 2211, 1782, 1782,
 /*  2800 */  1782, 1782, 1782, 1782, 1782, 1782, 1782, 1782, 1782, 2161,
 /*  2810 */  1782,  706, 1782, 1782, 1782, 1782, 1782, 1782, 1782, 1782,
 /*  2820 */  1782, 1782, 1782, 1782, 1782, 1782, 1782, 1782,  708, 1782,
 /*  2830 */  2228, 1782, 1782,  338, 2194,  710, 2196, 2197,  705, 1782,
 /*  2840 */   700, 1782, 1782, 1782, 1782, 2192, 1782, 2228, 1782, 1782,
 /*  2850 */   337, 2194,  710, 2196, 2197,  705, 1782,  700,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   375,  341,  367,  393,  346,  350,  351,  411,  350,  380,
 /*    10 */   352,  351,   12,   13,   14,  405,  381,    4,  408,  409,
 /*    20 */    20,    3,   22,    8,    9,  370,  391,   12,   13,   14,
 /*    30 */    15,   16,  377,   33,  350,   35,  367,   14,   20,  379,
 /*    40 */     8,    9,  338,   20,   12,   13,   14,   15,   16,  424,
 /*    50 */   381,  391,  380,  393,  458,   49,   43,  461,   45,   46,
 /*    60 */   391,  379,   62,   57,  429,  430,   60,   61,   68,   20,
 /*    70 */     4,   22,  476,  477,  439,   75,   44,  481,  482,  395,
 /*    80 */    20,  399,  400,   68,   35,  350,  351,  427,   20,  429,
 /*    90 */   350,  351,  432,  433,  434,  435,  436,  437,  429,  439,
 /*   100 */   100,  360,   53,  103,  444,  370,  446,  357,  439,  368,
 /*   110 */   450,  451,  377,   84,  393,  411,   12,   13,  350,  351,
 /*   120 */   416,   20,  104,  463,   20,   62,   22,  112,  100,  408,
 /*   130 */   409,  471,  382,   20,  447,  448,  104,   33,  370,   35,
 /*   140 */   140,  141,  341,  115,  116,  117,  118,  119,  120,  121,
 /*   150 */   122,  123,  124,  341,  126,  127,  128,  129,  130,  131,
 /*   160 */   132,  378,  458,  103,  458,  461,   62,  461,  105,  103,
 /*   170 */   170,  171,   68,  390,  145,  146,  176,  177,   20,   75,
 /*   180 */   476,  477,  476,  477,  169,  481,  482,  481,  482,  431,
 /*   190 */   172,  191,  391,  193,  454,  455,  456,  168,  458,  459,
 /*   200 */   340,  461,  342,  391,  100,    8,    9,  103,  341,   12,
 /*   210 */    13,   14,   15,   16,  103,  457,  476,  477,  351,   35,
 /*   220 */   186,  481,  482,  223,  224,    0,  226,  227,  228,  229,
 /*   230 */   230,  231,  232,  233,  234,  235,  236,  237,  238,  239,
 /*   240 */   240,  241,  242,  243,  140,  141,  379,  213,  214,   24,
 /*   250 */    25,   26,   27,   28,   29,   30,   31,   32,  391,   75,
 /*   260 */   393,    0,  247,  248,  249,  250,  251,  252,  253,  254,
 /*   270 */   255,  256,  257,  345,  170,  171,  348,  349,   67,   20,
 /*   280 */   176,  177,   21,  170,  171,   24,   25,   26,   27,   28,
 /*   290 */    29,   30,   31,   32,  427,  191,  429,  193,  175,  432,
 /*   300 */   433,  434,  435,  436,  437,   20,  439,    0,  371,  442,
 /*   310 */    20,  444,  445,  446,   20,  341,  379,  450,  451,   20,
 /*   320 */   260,   22,  350,  351,  387,  351,  260,  223,  224,    4,
 /*   330 */   226,  227,  228,  229,  230,  231,  232,  233,  234,  235,
 /*   340 */   236,  237,  238,  239,  240,  241,  242,  243,  244,   12,
 /*   350 */    13,   67,   53,  379,  379,   12,   13,   20,   47,   22,
 /*   360 */   458,  386,  103,  461,  379,  391,   20,  393,  114,  394,
 /*   370 */    33,  260,   35,   70,   71,   72,  350,  351,   35,  477,
 /*   380 */    77,   78,   79,  481,  482,  400,   83,  351,  265,  266,
 /*   390 */   267,   88,   89,   90,   91,  442,  370,   94,  445,   62,
 /*   400 */   135,  427,   48,  429,  139,   68,  432,  433,  434,  435,
 /*   410 */   436,  437,   75,  439,  103,  379,  134,  135,  444,  345,
 /*   420 */   446,  139,  348,  349,  450,  451,  454,  455,  456,  341,
 /*   430 */   458,  459,   14,  458,  140,  141,  461,  100,   20,  351,
 /*   440 */   103,  353,    8,    9,   35,  471,   12,   13,   14,   15,
 /*   450 */    16,  476,  477,   12,   13,   14,  481,  482,  346,  341,
 /*   460 */   170,   20,  350,   22,  352,  200,  159,  379,  203,  351,
 /*   470 */   434,  206,  379,  208,   33,  168,   35,  140,  141,  391,
 /*   480 */   387,  393,  458,   21,   75,  461,   24,   25,   26,   27,
 /*   490 */    28,   29,   30,   31,   32,  379,  103,  379,  341,  350,
 /*   500 */   351,  477,  386,   62,  244,  481,  482,  170,  171,  391,
 /*   510 */   394,  393,  357,  176,  177,  427,   75,  429,  172,  260,
 /*   520 */   432,  433,  434,  435,  436,  437,  172,  439,  191,  374,
 /*   530 */   193,  133,  444,  179,  446,  137,  193,  382,  450,  451,
 /*   540 */    14,  100,  350,  351,  103,  427,   20,  429,  391,  341,
 /*   550 */   432,  433,  434,  435,  436,  437,  244,  439,  246,  351,
 /*   560 */   223,  224,  370,  226,  227,  228,  229,  230,  231,  232,
 /*   570 */   233,  234,  235,  236,  237,  238,  239,  240,  241,  242,
 /*   580 */   243,  140,  141,  190,   22,  192,  261,  379,    8,    9,
 /*   590 */   472,  473,   12,   13,   14,   15,   16,   35,  431,  391,
 /*   600 */    20,  393,  453,  454,  455,  456,  172,  458,  459,   75,
 /*   610 */   341,  170,  171,  350,  351,  222,  389,  176,  177,  392,
 /*   620 */   393,    8,    9,  371,  457,   12,   13,   14,   15,   16,
 /*   630 */   431,  379,  191,  370,  193,  427,  350,  429,  386,  387,
 /*   640 */   432,  433,  434,  435,  436,  437,  394,  439,  134,   20,
 /*   650 */   411,  341,  444,  260,  446,  416,  457,  411,  450,  451,
 /*   660 */   391,  351,  100,  353,  223,  224,   44,  226,  227,  228,
 /*   670 */   229,  230,  231,  232,  233,  234,  235,  236,  237,  238,
 /*   680 */   239,  240,  241,  242,  243,   12,   13,    0,  402,  379,
 /*   690 */   404,  350,  351,   20,   75,   22,  170,  458,  350,  351,
 /*   700 */   461,  391,  379,  393,  458,    0,   33,  461,   35,  386,
 /*   710 */    12,   13,   14,   15,   16,  476,  477,  394,  204,  205,
 /*   720 */   481,  482,  476,  477,  350,  351,  104,  481,  482,    1,
 /*   730 */     2,  223,  103,  350,  351,   62,  380,  427,  397,  429,
 /*   740 */     4,  350,  432,  433,  434,  435,  436,  437,   75,  439,
 /*   750 */   350,  351,  172,  370,  444,   19,  446,    0,    8,    9,
 /*   760 */   450,  451,   12,   13,   14,   15,   16,  341,  341,   33,
 /*   770 */   370,  397,   67,  100,  350,  351,  103,  351,  270,  271,
 /*   780 */   272,  273,  274,  275,  276,   49,  350,  351,    3,   12,
 /*   790 */    13,    0,   56,  402,  370,  404,  183,   20,   62,   22,
 /*   800 */   371,   20,  454,  455,  456,  379,  458,  459,  379,  443,
 /*   810 */    33,  445,   35,  140,  141,    0,  387,  391,  391,  393,
 /*   820 */   133,  134,  135,  136,  137,  138,  139,   70,   71,   72,
 /*   830 */   392,  393,  104,  397,   77,   78,   79,   22,  102,   62,
 /*   840 */    83,  105,  103,  170,  171,   88,   89,   90,   91,  176,
 /*   850 */   177,   94,   75,  427,  104,  429,   54,   55,  432,  433,
 /*   860 */   434,  435,  436,  437,  191,  439,  193,  441,    8,    9,
 /*   870 */   341,  380,   12,   13,   14,   15,   16,  100,  355,  356,
 /*   880 */   103,  341,  133,  134,  135,  136,  137,  138,  139,  341,
 /*   890 */   411,  351,   62,  353,  341,  380,  223,  224,  285,  226,
 /*   900 */   227,  228,  229,  230,  231,  232,  233,  234,  235,  236,
 /*   910 */   237,  238,  239,  240,  241,  242,  243,  140,  141,  379,
 /*   920 */   391,  140,  141,   21,  133,  134,  135,  136,  137,  138,
 /*   930 */   139,  391,  102,  393,  379,  105,   34,  458,   36,  391,
 /*   940 */   461,  386,  350,  351,  391,  350,  351,  170,  171,  394,
 /*   950 */   114,  350,  351,  176,  177,  476,  477,  176,  177,  380,
 /*   960 */   481,  482,  370,  388,  104,  370,  391,  427,  191,  429,
 /*   970 */   193,  370,  432,  433,  434,  435,  436,  437,   39,  439,
 /*   980 */   364,  365,    2,    0,  444,   22,  446,  350,    8,    9,
 /*   990 */   450,  451,   12,   13,   14,   15,   16,  341,   35,  260,
 /*  1000 */   223,  224,    0,  226,  227,  228,  229,  230,  231,  232,
 /*  1010 */   233,  234,  235,  236,  237,  238,  239,  240,  241,  242,
 /*  1020 */   243,   14,   18,   18,   20,  350,  351,   20,   23,  350,
 /*  1030 */   351,   27,   49,  359,   30,  355,  356,   33,  367,  402,
 /*  1040 */   371,  404,   37,   38,    0,  370,   41,  391,  379,  370,
 /*  1050 */   376,  379,  381,   49,  411,   51,  387,   52,  386,  385,
 /*  1060 */    56,  380,  391,  100,  341,  280,  394,  341,   63,   64,
 /*  1070 */    65,   66,   70,   71,   72,   73,   74,    0,   76,   77,
 /*  1080 */    78,   79,   80,   81,   82,   83,   84,   85,   86,   87,
 /*  1090 */    88,   89,   90,   91,   92,   93,   94,   95,   96,   20,
 /*  1100 */   429,  458,  350,  351,  461,   20,  102,   33,  103,   37,
 /*  1110 */   439,   14,   15,   16,  391,  350,  351,  391,  114,  476,
 /*  1120 */   477,   44,  370,   49,  481,  482,  350,  351,  417,  350,
 /*  1130 */   351,   57,   58,   59,   60,  370,   62,  341,   44,  443,
 /*  1140 */   169,  445,  364,  365,  341,  341,  370,  142,  144,  370,
 /*  1150 */   341,  147,  148,  149,  150,  151,  152,  153,  154,  155,
 /*  1160 */   156,  157,  158,  159,  160,  161,  162,  163,   44,  165,
 /*  1170 */   166,  167,  350,  351,  258,  259,  102,  170,  106,  105,
 /*  1180 */   108,  109,    0,  111,  359,  341,  341,  391,  183,  184,
 /*  1190 */   185,  341,  370,  188,  391,  391,  341,  379,  259,  388,
 /*  1200 */   391,  351,  391,  353,   22,  133,  201,  202,  341,  137,
 /*  1210 */   385,  388,  394,  372,  391,  368,  375,  212,  247,   42,
 /*  1220 */   215,   44,  341,  218,  219,  220,  221,  222,  257,  379,
 /*  1230 */   366,   22,  351,  369,  353,  391,  391,   45,   46,   44,
 /*  1240 */    42,  391,   44,  393,   35,  114,  391,  173,  174,   13,
 /*  1250 */   107,  172,  341,  110,  180,  181,  107,  172,  391,  110,
 /*  1260 */   379,  217,  351,  107,  353,  260,  110,  107,   44,   13,
 /*  1270 */   110,   35,  391,  199,  393,    0,   44,  427,  207,  429,
 /*  1280 */   209,   44,  432,  433,  434,  435,  436,  437,   68,  439,
 /*  1290 */   379,   35,  140,  141,  444,  164,  446,   22,  342,  104,
 /*  1300 */   450,  451,  391,  474,  393,   35,   44,   44,  427,  103,
 /*  1310 */   429,  401,  485,  432,  433,  434,  435,  436,  437,  113,
 /*  1320 */   439,   44,   44,   35,   22,  444,   44,  446,  104,   44,
 /*  1330 */    44,  450,  451,    1,    2,   44,  104,   35,  427,   44,
 /*  1340 */   429,  104,  341,  432,  433,  434,  435,  436,  437,   44,
 /*  1350 */   439,    0,  351,   12,   13,  444,  468,  446,    2,   44,
 /*  1360 */   354,  450,  451,   22,    8,    9,  104,  104,   12,   13,
 /*  1370 */    14,   15,   16,  341,   33,  367,   35,   75,  284,   44,
 /*  1380 */   379,  104,  104,  351,   44,   13,  104,  367,  379,  104,
 /*  1390 */   104,   13,  391,   44,  393,  104,  410,   44,  401,  104,
 /*  1400 */   354,   50,  100,   62,  349,  351,  282,   35,  390,  104,
 /*  1410 */   341,  379,  401,   35,  460,  478,   75,  452,   49,  104,
 /*  1420 */   351,  462,  412,  391,  262,  393,  428,   20,  427,  206,
 /*  1430 */   429,  189,  359,  432,  433,  434,  435,  436,  437,  104,
 /*  1440 */   439,  100,  421,  223,  104,  444,  421,  446,  379,  426,
 /*  1450 */   359,  450,  451,  104,  414,   20,  351,  104,   42,  427,
 /*  1460 */   391,  429,  393,  193,  432,  433,  434,  435,  436,  437,
 /*  1470 */    20,  439,  351,  398,  396,  169,  444,  401,  446,  398,
 /*  1480 */    20,  193,  450,  451,  350,  398,  351,  350,  396,  396,
 /*  1490 */   101,  363,   99,  191,  362,  193,  427,  350,  429,  341,
 /*  1500 */    98,  432,  433,  434,  435,  436,  437,  361,  439,  351,
 /*  1510 */    20,  350,  343,  350,  350,  446,   48,  347,  343,  450,
 /*  1520 */   451,  347,  421,   20,  359,  223,  224,  359,   20,  393,
 /*  1530 */   352,   20,  191,  413,  193,  359,  352,  379,  359,  359,
 /*  1540 */   359,  350,  359,  343,  343,  379,  379,  350,  341,  391,
 /*  1550 */   379,  393,  379,  210,  425,  103,  423,  197,  351,  421,
 /*  1560 */   357,  420,  196,  391,  223,  224,  379,  379,  379,  379,
 /*  1570 */   419,  357,  379,  379,  341,  379,  391,  236,  237,  238,
 /*  1580 */   239,  240,  241,  242,  351,  427,  379,  429,  350,  195,
 /*  1590 */   432,  433,  434,  435,  436,  437,  391,  439,  391,  269,
 /*  1600 */   393,  393,  391,  277,  446,  401,  467,  268,  450,  451,
 /*  1610 */   391,  401,  379,  391,  412,  467,  391,  418,  406,  406,
 /*  1620 */   470,  182,  469,  279,  391,  341,  393,  263,  278,  412,
 /*  1630 */   486,  286,  259,  281,  427,  351,  429,  283,  341,  432,
 /*  1640 */   433,  434,  435,  436,  437,  351,  439,   20,  351,  357,
 /*  1650 */   352,   20,  466,  446,  404,  406,  357,  450,  451,  431,
 /*  1660 */   427,  406,  429,  379,  391,  432,  433,  434,  435,  436,
 /*  1670 */   437,  438,  439,  440,  441,  391,  379,  393,  391,  174,
 /*  1680 */   391,  465,  467,  403,  391,  464,  357,  341,  391,  375,
 /*  1690 */   393,  391,  391,  357,  103,  449,  103,  351,  480,  351,
 /*  1700 */   383,  391,  369,   36,  341,  479,  344,  350,  343,    0,
 /*  1710 */   407,  427,  357,  429,  351,  407,  432,  433,  434,  435,
 /*  1720 */   436,  437,  415,  439,  427,  379,  429,  339,  358,  432,
 /*  1730 */   433,  434,  435,  436,  437,  422,  439,  391,    0,  393,
 /*  1740 */   373,  373,  379,  446,  373,    0,   42,  384,  451,    0,
 /*  1750 */    35,  216,   35,  341,  391,   35,  393,   35,  216,    0,
 /*  1760 */    35,   35,  216,  351,    0,  216,    0,  483,  484,   35,
 /*  1770 */     0,    0,   22,  427,   35,  429,  211,  341,  432,  433,
 /*  1780 */   434,  435,  436,  437,    0,  439,  199,  351,    0,  199,
 /*  1790 */   427,  379,  429,  193,  200,  432,  433,  434,  435,  436,
 /*  1800 */   437,  191,  439,  391,  341,  393,    0,    0,    0,  187,
 /*  1810 */   186,    0,    0,    0,  351,  379,   47,    0,    0,  473,
 /*  1820 */   384,   47,    0,   42,  341,    0,    0,  391,    0,  393,
 /*  1830 */    47,    0,    0,    0,  351,    0,    0,    0,  159,  427,
 /*  1840 */    35,  429,  379,    0,  432,  433,  434,  435,  436,  437,
 /*  1850 */   159,  439,    0,    0,  391,    0,  393,    0,    0,    0,
 /*  1860 */     0,    0,  379,  427,    0,  429,    0,  384,  432,  433,
 /*  1870 */   434,  435,  436,  437,  391,  439,  393,   47,    0,    0,
 /*  1880 */    42,    0,    0,    0,    0,    0,   62,  475,    0,    0,
 /*  1890 */   427,  341,  429,    0,    0,  432,  433,  434,  435,  436,
 /*  1900 */   437,  351,  439,    0,    0,    0,    0,    0,   22,    0,
 /*  1910 */   427,  143,  429,    0,   22,  432,  433,  434,  435,  436,
 /*  1920 */   437,  341,  439,   48,   48,    0,   35,    0,    0,  379,
 /*  1930 */    22,  351,   62,   62,  384,    0,    0,   39,    0,   49,
 /*  1940 */    39,  391,    0,  393,   49,   35,   35,  484,   49,   35,
 /*  1950 */     0,   39,   35,    0,   14,   39,    0,   42,    0,  379,
 /*  1960 */     0,   39,   44,   40,  384,    0,   47,   47,   47,   39,
 /*  1970 */     0,  391,  182,  393,   35,   49,   39,  427,    0,  429,
 /*  1980 */   341,    0,  432,  433,  434,  435,  436,  437,    1,  439,
 /*  1990 */   351,    0,    0,   69,    0,   49,   35,    0,   39,   35,
 /*  2000 */    49,   39,    0,   35,   49,   39,   19,  427,    0,  429,
 /*  2010 */     0,    0,  432,  433,  434,  435,  436,  437,  379,  439,
 /*  2020 */    33,    0,    0,    0,    0,   35,   22,   44,   35,   44,
 /*  2030 */   391,   35,  393,   35,   35,   35,   49,    0,   35,   22,
 /*  2040 */    35,  112,  110,    0,   57,   58,   59,   60,   35,   62,
 /*  2050 */    35,   35,   22,  341,   22,    0,   22,   51,    0,    0,
 /*  2060 */    35,   35,   35,  351,    0,    0,  427,   22,  429,   20,
 /*  2070 */    35,  432,  433,  434,  435,  436,  437,   35,  439,   35,
 /*  2080 */   104,   35,  103,  103,  341,  198,    0,    0,   22,  102,
 /*  2090 */   194,  379,  105,   22,  351,    0,    3,   44,  264,  104,
 /*  2100 */    48,   44,    3,  391,  103,  393,  172,  174,   48,  178,
 /*  2110 */    47,   99,  103,  172,   44,  172,  172,   44,  104,  341,
 /*  2120 */   101,  103,  379,  178,  104,  138,   47,   44,   44,  351,
 /*  2130 */   258,  103,  103,  264,  391,  104,  393,  104,  264,  427,
 /*  2140 */   104,  429,  103,   35,  432,  433,  434,  435,  436,  437,
 /*  2150 */    35,  439,   35,   35,   35,   35,  341,  379,   47,   47,
 /*  2160 */   173,    0,    0,   47,   39,  104,  351,  180,   44,  391,
 /*  2170 */   427,  393,  429,  104,    0,  432,  433,  434,  435,  436,
 /*  2180 */   437,  341,  439,  103,  103,  103,  199,   39,  113,  104,
 /*  2190 */    47,  351,  104,  103,  379,  103,   44,  103,  101,  245,
 /*  2200 */     2,  101,   22,   47,  103,  427,  391,  429,  393,  223,
 /*  2210 */   432,  433,  434,  435,  436,  437,  175,  439,  341,  379,
 /*  2220 */   173,   22,   47,  114,   35,  104,  104,   35,  351,  103,
 /*  2230 */   103,  391,  104,  393,  103,  103,   35,  104,  103,   35,
 /*  2240 */   104,  103,  427,  341,  429,  104,  104,  432,  433,  434,
 /*  2250 */   435,  436,  437,  351,  439,  104,  379,  103,  103,   35,
 /*  2260 */   103,   35,  104,  225,  104,   35,  103,  427,  391,  429,
 /*  2270 */   393,  103,  432,  433,  434,  435,  436,  437,  125,  439,
 /*  2280 */   103,  379,   44,   35,  125,   22,  103,  103,   69,  125,
 /*  2290 */   125,   68,   35,  391,   35,  393,   35,   35,   44,   35,
 /*  2300 */    35,   35,   35,   75,  427,   97,  429,   35,   35,  432,
 /*  2310 */   433,  434,  435,  436,  437,  341,  439,   35,   22,   35,
 /*  2320 */    35,   35,   75,   35,   35,  351,   35,   35,   35,  427,
 /*  2330 */   341,  429,   22,   35,  432,  433,  434,  435,  436,  437,
 /*  2340 */   351,  439,    0,   35,   49,   39,    0,   35,  341,   49,
 /*  2350 */     0,   35,   39,  379,   49,    0,   39,   35,  351,   39,
 /*  2360 */     0,   35,   35,   49,    0,  391,   22,  393,  379,   21,
 /*  2370 */   487,   22,   20,   22,   21,  487,  487,  487,  487,  487,
 /*  2380 */   391,  487,  393,  487,  487,  487,  379,  487,  487,  487,
 /*  2390 */   487,  487,  487,  487,  487,  341,  487,  487,  391,  487,
 /*  2400 */   393,  427,  487,  429,  487,  351,  432,  433,  434,  435,
 /*  2410 */   436,  437,  487,  439,  487,  487,  427,  341,  429,  487,
 /*  2420 */   487,  432,  433,  434,  435,  436,  437,  351,  439,  487,
 /*  2430 */   487,  487,  487,  379,  427,  487,  429,  487,  487,  432,
 /*  2440 */   433,  434,  435,  436,  437,  391,  439,  393,  487,  487,
 /*  2450 */   487,  487,  487,  487,  487,  379,  487,  487,  487,  487,
 /*  2460 */   487,  487,  487,  487,  341,  487,  487,  391,  487,  393,
 /*  2470 */   487,  487,  487,  487,  351,  487,  487,  487,  487,  487,
 /*  2480 */   487,  427,  487,  429,  487,  487,  432,  433,  434,  435,
 /*  2490 */   436,  437,  487,  439,  487,  487,  487,  487,  487,  487,
 /*  2500 */   487,  487,  379,  427,  487,  429,  487,  487,  432,  433,
 /*  2510 */   434,  435,  436,  437,  391,  439,  393,  487,  487,  487,
 /*  2520 */   487,  487,  487,  341,  487,  487,  487,  487,  487,  487,
 /*  2530 */   487,  487,  487,  351,  487,  487,  341,  487,  487,  487,
 /*  2540 */   487,  487,  487,  487,  487,  487,  351,  487,  487,  487,
 /*  2550 */   427,  487,  429,  341,  487,  432,  433,  434,  435,  436,
 /*  2560 */   437,  379,  439,  351,  487,  487,  487,  487,  487,  487,
 /*  2570 */   487,  487,  487,  391,  379,  393,  487,  487,  487,  487,
 /*  2580 */   487,  487,  487,  487,  487,  341,  391,  487,  393,  487,
 /*  2590 */   487,  379,  487,  487,  487,  351,  487,  487,  487,  487,
 /*  2600 */   487,  487,  487,  391,  487,  393,  487,  487,  487,  427,
 /*  2610 */   487,  429,  487,  487,  432,  433,  434,  435,  436,  437,
 /*  2620 */   487,  439,  427,  379,  429,  487,  487,  432,  433,  434,
 /*  2630 */   435,  436,  437,  487,  439,  391,  487,  393,  487,  427,
 /*  2640 */   487,  429,  487,  487,  432,  433,  434,  435,  436,  437,
 /*  2650 */   487,  439,  341,  487,  487,  487,  487,  487,  487,  487,
 /*  2660 */   487,  487,  351,  487,  487,  487,  487,  487,  487,  487,
 /*  2670 */   487,  427,  341,  429,  487,  487,  432,  433,  434,  435,
 /*  2680 */   436,  437,  351,  439,  487,  487,  487,  487,  487,  487,
 /*  2690 */   379,  487,  487,  487,  487,  487,  487,  487,  487,  487,
 /*  2700 */   487,  487,  391,  487,  393,  487,  487,  487,  487,  487,
 /*  2710 */   379,  487,  487,  487,  487,  487,  487,  487,  487,  487,
 /*  2720 */   487,  487,  391,  487,  393,  487,  487,  487,  487,  487,
 /*  2730 */   487,  487,  487,  487,  487,  487,  487,  487,  427,  487,
 /*  2740 */   429,  487,  341,  432,  433,  434,  435,  436,  437,  487,
 /*  2750 */   439,  487,  351,  487,  487,  487,  487,  487,  427,  341,
 /*  2760 */   429,  487,  487,  432,  433,  434,  435,  436,  437,  351,
 /*  2770 */   439,  487,  487,  487,  487,  487,  487,  487,  487,  487,
 /*  2780 */   379,  487,  487,  487,  487,  487,  487,  487,  487,  487,
 /*  2790 */   487,  487,  391,  487,  393,  487,  487,  379,  487,  487,
 /*  2800 */   487,  487,  487,  487,  487,  487,  487,  487,  487,  391,
 /*  2810 */   487,  393,  487,  487,  487,  487,  487,  487,  487,  487,
 /*  2820 */   487,  487,  487,  487,  487,  487,  487,  487,  427,  487,
 /*  2830 */   429,  487,  487,  432,  433,  434,  435,  436,  437,  487,
 /*  2840 */   439,  487,  487,  487,  487,  427,  487,  429,  487,  487,
 /*  2850 */   432,  433,  434,  435,  436,  437,  487,  439,  338,  338,
 /*  2860 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  2870 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  2880 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  2890 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  2900 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  2910 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  2920 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  2930 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  2940 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  2950 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  2960 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  2970 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  2980 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  2990 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  3000 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  3010 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  3020 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  3030 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  3040 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  3050 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  3060 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  3070 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  3080 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  3090 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  3100 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  3110 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  3120 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  3130 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  3140 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  3150 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  3160 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  3170 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  3180 */   338,  338,  338,  338,  338,  338,  338,  338,  338,  338,
 /*  3190 */   338,  338,  338,  338,  338,  338,
};
#define YY_SHIFT_COUNT    (799)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2364)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */  1005,    0,  104,    0,  337,  337,  337,  337,  337,  337,
 /*    10 */   337,  337,  337,  337,  337,  337,  441,  673,  673,  777,
 /*    20 */   673,  673,  673,  673,  673,  673,  673,  673,  673,  673,
 /*    30 */   673,  673,  673,  673,  673,  673,  673,  673,  673,  673,
 /*    40 */   673,  673,  673,  673,  673,  673,  673,  673,  673,  673,
 /*    50 */   673,   60,  259,  393,  629,  111,  739,  111,  629,  629,
 /*    60 */   111, 1341,  111, 1341, 1341,   66,  111,   68,  781,  101,
 /*    70 */   101,  781,   13,   13,  113,  294,   23,   23,  101,  101,
 /*    80 */   101,  101,  101,  101,  101,  101,  101,  101,  158,  101,
 /*    90 */   101,  211,   68,  101,  101,  285,   68,  101,  158,  101,
 /*   100 */   158,   68,  101,  101,   68,  101,   68,   68,   68,  101,
 /*   110 */   284, 1004,   15,   15,  303,  462, 1302, 1302, 1302, 1302,
 /*   120 */  1302, 1302, 1302, 1302, 1302, 1302, 1302, 1302, 1302, 1302,
 /*   130 */  1302, 1302, 1302, 1302, 1302, 1072,   18,  113,  294,  802,
 /*   140 */   802,  184,  346,  346,  346,  705,  312,  312,  184,  211,
 /*   150 */   254,  260,   68,  534,   68,  534,  534,  836,  619,   28,
 /*   160 */    28,   28,   28,   28,   28,   28,   28, 1987,  757,  261,
 /*   170 */   580,  613,  508,   49,  123,  343,  343,  526,  354, 1007,
 /*   180 */   299, 1079, 1192,  418,  398, 1085,  916,  939,  785,  916,
 /*   190 */  1177,  325,  290, 1162, 1369, 1407, 1223,  211, 1407,  211,
 /*   200 */  1242, 1435, 1416, 1450, 1435, 1416, 1306, 1460, 1435, 1460,
 /*   210 */  1416, 1306, 1306, 1389, 1393, 1460, 1402, 1460, 1460, 1460,
 /*   220 */  1490, 1468, 1490, 1468, 1407,  211, 1503,  211, 1508, 1511,
 /*   230 */   211, 1508,  211,  211,  211, 1460,  211, 1490,   68,   68,
 /*   240 */    68,   68,   68,   68,   68,   68,   68,   68,   68, 1460,
 /*   250 */  1490,  534,  534,  534, 1343, 1452, 1407,  284, 1360, 1366,
 /*   260 */  1503,  284, 1394, 1162, 1460, 1450, 1450,  534, 1330, 1339,
 /*   270 */   534, 1330, 1339,  534,  534,   68, 1326, 1439, 1330, 1344,
 /*   280 */  1350, 1364, 1162, 1345, 1354, 1352, 1373, 1435, 1627, 1508,
 /*   290 */   284,  284, 1631, 1339,  534,  534,  534,  534,  534, 1339,
 /*   300 */   534, 1505,  284,  836,  284, 1435, 1591, 1593,  534,  619,
 /*   310 */  1460,  284, 1667, 1490, 2858, 2858, 2858, 2858, 2858, 2858,
 /*   320 */  2858, 2858, 2858, 1002, 1074,  225,   32,  736,  750,  860,
 /*   330 */   687,  980, 1356,  434,  791,  197,  197,  197,  197,  197,
 /*   340 */   197,  197,  197,  197,  749,  265,  698,  698,   29,    6,
 /*   350 */    34,  307,  830,  562,  963,  902,  514,  282,  282, 1097,
 /*   360 */   728,  971, 1097, 1097, 1097,  983, 1044,  622, 1209, 1198,
 /*   370 */  1131, 1077, 1143, 1149, 1156, 1160, 1236, 1256,  815, 1182,
 /*   380 */  1275, 1071, 1195, 1224,   63, 1232, 1237, 1262, 1152, 1124,
 /*   390 */  1094, 1263, 1277, 1278, 1282, 1285, 1286, 1332, 1291, 1220,
 /*   400 */  1295,  311, 1305, 1315, 1335, 1340, 1349, 1353, 1206, 1270,
 /*   410 */  1288, 1372, 1378,  409, 1351, 1709, 1738, 1745, 1704, 1749,
 /*   420 */  1715, 1535, 1717, 1720, 1722, 1542, 1759, 1725, 1726, 1546,
 /*   430 */  1764, 1549, 1766, 1734, 1770, 1750, 1771, 1739, 1565, 1784,
 /*   440 */  1587, 1788, 1590, 1594, 1600, 1610, 1806, 1807, 1808, 1622,
 /*   450 */  1624, 1811, 1812, 1769, 1813, 1817, 1818, 1774, 1822, 1781,
 /*   460 */  1825, 1826, 1828, 1783, 1831, 1832, 1833, 1835, 1836, 1837,
 /*   470 */  1679, 1805, 1843, 1691, 1852, 1853, 1855, 1857, 1858, 1859,
 /*   480 */  1860, 1861, 1864, 1866, 1888, 1889, 1893, 1894, 1903, 1904,
 /*   490 */  1830, 1878, 1838, 1879, 1881, 1882, 1883, 1884, 1885, 1886,
 /*   500 */  1905, 1906, 1907, 1768, 1909, 1913, 1892, 1875, 1908, 1876,
 /*   510 */  1925, 1824, 1891, 1927, 1870, 1928, 1871, 1935, 1936, 1910,
 /*   520 */  1890, 1898, 1938, 1911, 1895, 1901, 1942, 1914, 1899, 1912,
 /*   530 */  1950, 1917, 1953, 1915, 1916, 1918, 1919, 1920, 1940, 1921,
 /*   540 */  1956, 1923, 1922, 1958, 1960, 1965, 1930, 1790, 1970, 1978,
 /*   550 */  1981, 1924, 1991, 1992, 1939, 1926, 1937, 1994, 1961, 1946,
 /*   560 */  1959, 1997, 1964, 1951, 1962, 2002, 1968, 1955, 1966, 2008,
 /*   570 */  2010, 2011, 2021, 2022, 2023, 1929, 1932, 1990, 2004, 2024,
 /*   580 */  1993, 1996, 1998, 1999, 2000, 2003, 2005, 1983, 1985, 2013,
 /*   590 */  2015, 2017, 2016, 2037, 2030, 2043, 2032, 2006, 2055, 2034,
 /*   600 */  2025, 2058, 2026, 2059, 2027, 2064, 2045, 2049, 2035, 2042,
 /*   610 */  2044, 1976, 1979, 2065, 1934, 1980, 1887, 2046, 2066, 2086,
 /*   620 */  1896, 2071, 1941, 1933, 2087, 2095, 1943, 1931, 1944, 1945,
 /*   630 */  2093, 2053, 1834, 2001, 1995, 2009, 2052, 2019, 2060, 2012,
 /*   640 */  2014, 2057, 2070, 2020, 2018, 2028, 2029, 2031, 2073, 2063,
 /*   650 */  2079, 2039, 2083, 1869, 2033, 2036, 2099, 2084, 1874, 2108,
 /*   660 */  2115, 2117, 2118, 2119, 2120, 2061, 2069, 2111, 1872, 2124,
 /*   670 */  2112, 2161, 2162, 2080, 2125, 1919, 2116, 2081, 2085, 2088,
 /*   680 */  2082, 2090, 2041, 2092, 2174, 2148, 2047, 2094, 2075, 1919,
 /*   690 */  2143, 2152, 2097, 1954, 2100, 2198, 2180, 1986, 2101, 2121,
 /*   700 */  2126, 2122, 2127, 2128, 2156, 2131, 2132, 2175, 2133, 2199,
 /*   710 */  2038, 2135, 2109, 2136, 2189, 2192, 2138, 2141, 2201, 2154,
 /*   720 */  2142, 2204, 2155, 2151, 2224, 2157, 2158, 2226, 2163, 2160,
 /*   730 */  2230, 2168, 2153, 2159, 2164, 2165, 2177, 2238, 2183, 2248,
 /*   740 */  2184, 2238, 2238, 2263, 2219, 2223, 2257, 2259, 2261, 2262,
 /*   750 */  2264, 2265, 2266, 2267, 2228, 2208, 2254, 2272, 2273, 2282,
 /*   760 */  2296, 2284, 2285, 2286, 2247, 1983, 2288, 1985, 2289, 2291,
 /*   770 */  2292, 2293, 2310, 2298, 2342, 2308, 2295, 2306, 2346, 2312,
 /*   780 */  2300, 2313, 2350, 2316, 2305, 2317, 2355, 2322, 2314, 2320,
 /*   790 */  2360, 2326, 2327, 2364, 2344, 2348, 2349, 2351, 2353, 2352,
};
#define YY_REDUCE_COUNT (322)
#define YY_REDUCE_MIN   (-404)
#define YY_REDUCE_MAX   (2418)
static const short yy_reduce_ofst[] = {
 /*     0 */  -296, -340, -133,  -26,   88,  310,  540,  850,  881,  911,
 /*    10 */   208, 1001, 1032, 1069, 1158, 1207, 1233,  118, 1284, 1297,
 /*    20 */  1346, 1363, 1436, 1412, 1463, 1483,  426, 1550, 1580, 1639,
 /*    30 */  1712, 1743, 1778, 1815, 1840, 1877, 1902, 1974, 1989, 2007,
 /*    40 */  2054, 2076, 2123, 2182, 2195, 2212, 2244, 2311, 2331, 2401,
 /*    50 */  2418, -260,  -25,  239,  149, -404,  246,  479,  -28,  348,
 /*    60 */   643, -365, -294, -331,  671,  -98,   24,  252, -390, -345,
 /*    70 */  -265, -279,  -72,   74, -318,  227, -342,  112, -232,   26,
 /*    80 */   192,  263,  341,  374,  383,  400,  424,  436,  286,  592,
 /*    90 */   595,  674,  116,  601,  675,   36,  323,  679,  391,  752,
 /*   100 */   637,  -63,  765,  776,  555,  779,  429,  672,  669,  822,
 /*   110 */   155, -316, -313, -313, -259, -140, -199, -188,  157,  269,
 /*   120 */   427,  529,  548,  553,  656,  723,  726,  796,  803,  804,
 /*   130 */   809,  844,  845,  855,  867, -217, -242,  -15,  438,  523,
 /*   140 */   680,  616, -242,  167,  199, -250,  366,  696,  778,  825,
 /*   150 */  -375,  -47,   93,  575,  818,  811,  823,  841,  864, -371,
 /*   160 */  -328,  356,  491,  515,  579,  681,  515,  711,  847,  956,
 /*   170 */   910,  827,  829, 1006,  888, 1008, 1020, 1009,  986, 1009,
 /*   180 */  1046,  997, 1055, 1054, 1018, 1011,  954,  954,  937,  954,
 /*   190 */   965,  959, 1009, 1010,  998, 1021, 1023, 1073, 1025, 1091,
 /*   200 */  1040, 1105, 1075, 1076, 1121, 1081, 1078, 1134, 1135, 1137,
 /*   210 */  1087, 1092, 1093, 1128, 1132, 1147, 1146, 1161, 1163, 1164,
 /*   220 */  1169, 1170, 1175, 1174, 1101, 1165, 1136, 1168, 1178, 1120,
 /*   230 */  1176, 1184, 1179, 1180, 1181, 1191, 1183, 1200, 1166, 1167,
 /*   240 */  1171, 1173, 1187, 1188, 1189, 1190, 1193, 1194, 1196, 1197,
 /*   250 */  1201, 1172, 1185, 1205, 1129, 1133, 1138, 1203, 1141, 1151,
 /*   260 */  1208, 1214, 1199, 1202, 1238, 1204, 1210, 1211, 1139, 1212,
 /*   270 */  1219, 1148, 1213, 1222, 1225, 1009, 1150, 1153, 1215, 1186,
 /*   280 */  1216, 1221, 1217, 1144, 1218, 1226,  954, 1294, 1228, 1298,
 /*   290 */  1292, 1299, 1250, 1249, 1273, 1287, 1289, 1293, 1300, 1255,
 /*   300 */  1301, 1280, 1329, 1314, 1336, 1348, 1246, 1317, 1310, 1333,
 /*   310 */  1357, 1355, 1362, 1365, 1307, 1313, 1303, 1308, 1367, 1368,
 /*   320 */  1371, 1370, 1388,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*    10 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*    20 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*    30 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*    40 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*    50 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*    60 */  2091, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*    70 */  1780, 1780, 1780, 1780, 2064, 1780, 1780, 1780, 1780, 1780,
 /*    80 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*    90 */  1780, 1869, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   100 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   110 */  1867, 2057, 2283, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   120 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   130 */  1780, 1780, 1780, 1780, 1780, 1780, 2295, 1780, 1780, 1843,
 /*   140 */  1843, 1780, 2295, 2295, 2295, 1867, 2255, 2255, 1780, 1869,
 /*   150 */  2125, 1780, 1780, 1780, 1780, 1780, 1780, 1989, 1780, 1780,
 /*   160 */  1780, 1780, 1780, 2013, 1780, 1780, 1780, 2117, 1780, 1780,
 /*   170 */  2320, 2377, 1780, 1780, 2323, 1780, 1780, 1780, 1780, 1780,
 /*   180 */  1780, 2069, 1780, 1780, 1942, 2310, 2287, 2301, 2361, 2288,
 /*   190 */  2285, 2304, 1780, 2314, 1780, 1780, 2139, 1869, 1780, 1869,
 /*   200 */  2104, 1780, 2062, 1780, 1780, 2062, 2059, 1780, 1780, 1780,
 /*   210 */  2062, 2059, 2059, 1931, 1927, 1780, 1925, 1780, 1780, 1780,
 /*   220 */  1780, 1827, 1780, 1827, 1780, 1869, 1780, 1869, 1780, 1780,
 /*   230 */  1869, 1780, 1869, 1869, 1869, 1780, 1869, 1780, 1780, 1780,
 /*   240 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   250 */  1780, 1780, 1780, 1780, 2137, 2123, 1780, 1867, 2115, 2113,
 /*   260 */  1780, 1867, 2111, 2314, 1780, 1780, 1780, 1780, 2331, 2329,
 /*   270 */  1780, 2331, 2329, 1780, 1780, 1780, 2345, 2341, 2331, 2350,
 /*   280 */  2347, 2316, 2314, 2380, 2367, 2363, 2301, 1780, 1780, 1780,
 /*   290 */  1867, 1867, 1780, 2329, 1780, 1780, 1780, 1780, 1780, 2329,
 /*   300 */  1780, 1780, 1867, 1780, 1867, 1780, 1780, 1958, 1780, 1780,
 /*   310 */  1780, 1867, 1812, 1780, 2106, 2128, 2087, 2087, 1992, 1992,
 /*   320 */  1992, 1870, 1785, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   330 */  1780, 1780, 1780, 1780, 1780, 2344, 2343, 2210, 1780, 2259,
 /*   340 */  2258, 2257, 2248, 2209, 1954, 1780, 2208, 2207, 1780, 1780,
 /*   350 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 2078, 2077, 2201,
 /*   360 */  1780, 1780, 2202, 2200, 2199, 1780, 1780, 1780, 1780, 1780,
 /*   370 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   380 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 2364,
 /*   390 */  2368, 1780, 1780, 1780, 1780, 1780, 1780, 2284, 1780, 1780,
 /*   400 */  1780, 2183, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   410 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   420 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   430 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   440 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   450 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   460 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   470 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   480 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   490 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   500 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   510 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   520 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   530 */  1780, 1780, 1780, 1780, 1780, 1817, 2188, 1780, 1780, 1780,
 /*   540 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   550 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   560 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   570 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   580 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1908, 1907, 1780,
 /*   590 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   600 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   610 */  1780, 2192, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   620 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   630 */  2360, 2317, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   640 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   650 */  2183, 1780, 2342, 1780, 1780, 2358, 1780, 2362, 1780, 1780,
 /*   660 */  1780, 1780, 1780, 1780, 1780, 2294, 2290, 1780, 1780, 2286,
 /*   670 */  1780, 1780, 1780, 1780, 1780, 2191, 1780, 1780, 1780, 1780,
 /*   680 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 2182,
 /*   690 */  1780, 2245, 1780, 1780, 1780, 2279, 1780, 1780, 2230, 1780,
 /*   700 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 2192, 1780,
 /*   710 */  2195, 1780, 1780, 1780, 1780, 1780, 1986, 1780, 1780, 1780,
 /*   720 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   730 */  1780, 1780, 1970, 1968, 1967, 1966, 1780, 1999, 1780, 1780,
 /*   740 */  1780, 1995, 1994, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   750 */  1780, 1780, 1780, 1780, 1780, 1780, 1888, 1780, 1780, 1780,
 /*   760 */  1780, 1780, 1780, 1780, 1780, 1880, 1780, 1879, 1780, 1780,
 /*   770 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   780 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
 /*   790 */  1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780, 1780,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*       WITH => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /*    RESTORE => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*     UNSAFE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*      VNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      START => nothing */
    0,  /*  TIMESTAMP => nothing */
  287,  /*        END => ABORT */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*   GEOMETRY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*       META => nothing */
    0,  /*       ONLY => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*   LANGUAGE => nothing */
    0,  /*    REPLACE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*      PAUSE => nothing */
    0,  /*     RESUME => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*  UNTREATED => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*     LEADER => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  287,  /*      AFTER => ABORT */
  287,  /*     ATTACH => ABORT */
  287,  /*     BEFORE => ABORT */
  287,  /*      BEGIN => ABORT */
  287,  /*     BITAND => ABORT */
  287,  /*     BITNOT => ABORT */
  287,  /*      BITOR => ABORT */
  287,  /*     BLOCKS => ABORT */
  287,  /*     CHANGE => ABORT */
  287,  /*      COMMA => ABORT */
  287,  /*     CONCAT => ABORT */
  287,  /*   CONFLICT => ABORT */
  287,  /*       COPY => ABORT */
  287,  /*   DEFERRED => ABORT */
  287,  /* DELIMITERS => ABORT */
  287,  /*     DETACH => ABORT */
  287,  /*     DIVIDE => ABORT */
  287,  /*        DOT => ABORT */
  287,  /*       EACH => ABORT */
  287,  /*       FAIL => ABORT */
  287,  /*       FILE => ABORT */
  287,  /*        FOR => ABORT */
  287,  /*       GLOB => ABORT */
  287,  /*         ID => ABORT */
  287,  /*  IMMEDIATE => ABORT */
  287,  /*     IMPORT => ABORT */
  287,  /*  INITIALLY => ABORT */
  287,  /*    INSTEAD => ABORT */
  287,  /*     ISNULL => ABORT */
  287,  /*        KEY => ABORT */
  287,  /*    MODULES => ABORT */
  287,  /*  NK_BITNOT => ABORT */
  287,  /*    NK_SEMI => ABORT */
  287,  /*    NOTNULL => ABORT */
  287,  /*         OF => ABORT */
  287,  /*       PLUS => ABORT */
  287,  /*  PRIVILEGE => ABORT */
  287,  /*      RAISE => ABORT */
  287,  /*   RESTRICT => ABORT */
  287,  /*        ROW => ABORT */
  287,  /*       SEMI => ABORT */
  287,  /*       STAR => ABORT */
  287,  /*  STATEMENT => ABORT */
  287,  /*     STRICT => ABORT */
  287,  /*     STRING => ABORT */
  287,  /*      TIMES => ABORT */
  287,  /*     VALUES => ABORT */
  287,  /*   VARIABLE => ABORT */
  287,  /*       VIEW => ABORT */
  287,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "WITH",
  /*   49 */ "DNODE",
  /*   50 */ "PORT",
  /*   51 */ "DNODES",
  /*   52 */ "RESTORE",
  /*   53 */ "NK_IPTOKEN",
  /*   54 */ "FORCE",
  /*   55 */ "UNSAFE",
  /*   56 */ "LOCAL",
  /*   57 */ "QNODE",
  /*   58 */ "BNODE",
  /*   59 */ "SNODE",
  /*   60 */ "MNODE",
  /*   61 */ "VNODE",
  /*   62 */ "DATABASE",
  /*   63 */ "USE",
  /*   64 */ "FLUSH",
  /*   65 */ "TRIM",
  /*   66 */ "COMPACT",
  /*   67 */ "IF",
  /*   68 */ "NOT",
  /*   69 */ "EXISTS",
  /*   70 */ "BUFFER",
  /*   71 */ "CACHEMODEL",
  /*   72 */ "CACHESIZE",
  /*   73 */ "COMP",
  /*   74 */ "DURATION",
  /*   75 */ "NK_VARIABLE",
  /*   76 */ "MAXROWS",
  /*   77 */ "MINROWS",
  /*   78 */ "KEEP",
  /*   79 */ "PAGES",
  /*   80 */ "PAGESIZE",
  /*   81 */ "TSDB_PAGESIZE",
  /*   82 */ "PRECISION",
  /*   83 */ "REPLICA",
  /*   84 */ "VGROUPS",
  /*   85 */ "SINGLE_STABLE",
  /*   86 */ "RETENTIONS",
  /*   87 */ "SCHEMALESS",
  /*   88 */ "WAL_LEVEL",
  /*   89 */ "WAL_FSYNC_PERIOD",
  /*   90 */ "WAL_RETENTION_PERIOD",
  /*   91 */ "WAL_RETENTION_SIZE",
  /*   92 */ "WAL_ROLL_PERIOD",
  /*   93 */ "WAL_SEGMENT_SIZE",
  /*   94 */ "STT_TRIGGER",
  /*   95 */ "TABLE_PREFIX",
  /*   96 */ "TABLE_SUFFIX",
  /*   97 */ "NK_COLON",
  /*   98 */ "MAX_SPEED",
  /*   99 */ "START",
  /*  100 */ "TIMESTAMP",
  /*  101 */ "END",
  /*  102 */ "TABLE",
  /*  103 */ "NK_LP",
  /*  104 */ "NK_RP",
  /*  105 */ "STABLE",
  /*  106 */ "ADD",
  /*  107 */ "COLUMN",
  /*  108 */ "MODIFY",
  /*  109 */ "RENAME",
  /*  110 */ "TAG",
  /*  111 */ "SET",
  /*  112 */ "NK_EQ",
  /*  113 */ "USING",
  /*  114 */ "TAGS",
  /*  115 */ "BOOL",
  /*  116 */ "TINYINT",
  /*  117 */ "SMALLINT",
  /*  118 */ "INT",
  /*  119 */ "INTEGER",
  /*  120 */ "BIGINT",
  /*  121 */ "FLOAT",
  /*  122 */ "DOUBLE",
  /*  123 */ "BINARY",
  /*  124 */ "NCHAR",
  /*  125 */ "UNSIGNED",
  /*  126 */ "JSON",
  /*  127 */ "VARCHAR",
  /*  128 */ "MEDIUMBLOB",
  /*  129 */ "BLOB",
  /*  130 */ "VARBINARY",
  /*  131 */ "GEOMETRY",
  /*  132 */ "DECIMAL",
  /*  133 */ "COMMENT",
  /*  134 */ "MAX_DELAY",
  /*  135 */ "WATERMARK",
  /*  136 */ "ROLLUP",
  /*  137 */ "TTL",
  /*  138 */ "SMA",
  /*  139 */ "DELETE_MARK",
  /*  140 */ "FIRST",
  /*  141 */ "LAST",
  /*  142 */ "SHOW",
  /*  143 */ "PRIVILEGES",
  /*  144 */ "DATABASES",
  /*  145 */ "TABLES",
  /*  146 */ "STABLES",
  /*  147 */ "MNODES",
  /*  148 */ "QNODES",
  /*  149 */ "FUNCTIONS",
  /*  150 */ "INDEXES",
  /*  151 */ "ACCOUNTS",
  /*  152 */ "APPS",
  /*  153 */ "CONNECTIONS",
  /*  154 */ "LICENCES",
  /*  155 */ "GRANTS",
  /*  156 */ "QUERIES",
  /*  157 */ "SCORES",
  /*  158 */ "TOPICS",
  /*  159 */ "VARIABLES",
  /*  160 */ "CLUSTER",
  /*  161 */ "BNODES",
  /*  162 */ "SNODES",
  /*  163 */ "TRANSACTIONS",
  /*  164 */ "DISTRIBUTED",
  /*  165 */ "CONSUMERS",
  /*  166 */ "SUBSCRIPTIONS",
  /*  167 */ "VNODES",
  /*  168 */ "ALIVE",
  /*  169 */ "LIKE",
  /*  170 */ "TBNAME",
  /*  171 */ "QTAGS",
  /*  172 */ "AS",
  /*  173 */ "INDEX",
  /*  174 */ "FUNCTION",
  /*  175 */ "INTERVAL",
  /*  176 */ "COUNT",
  /*  177 */ "LAST_ROW",
  /*  178 */ "META",
  /*  179 */ "ONLY",
  /*  180 */ "TOPIC",
  /*  181 */ "CONSUMER",
  /*  182 */ "GROUP",
  /*  183 */ "DESC",
  /*  184 */ "DESCRIBE",
  /*  185 */ "RESET",
  /*  186 */ "QUERY",
  /*  187 */ "CACHE",
  /*  188 */ "EXPLAIN",
  /*  189 */ "ANALYZE",
  /*  190 */ "VERBOSE",
  /*  191 */ "NK_BOOL",
  /*  192 */ "RATIO",
  /*  193 */ "NK_FLOAT",
  /*  194 */ "OUTPUTTYPE",
  /*  195 */ "AGGREGATE",
  /*  196 */ "BUFSIZE",
  /*  197 */ "LANGUAGE",
  /*  198 */ "REPLACE",
  /*  199 */ "STREAM",
  /*  200 */ "INTO",
  /*  201 */ "PAUSE",
  /*  202 */ "RESUME",
  /*  203 */ "TRIGGER",
  /*  204 */ "AT_ONCE",
  /*  205 */ "WINDOW_CLOSE",
  /*  206 */ "IGNORE",
  /*  207 */ "EXPIRED",
  /*  208 */ "FILL_HISTORY",
  /*  209 */ "UPDATE",
  /*  210 */ "SUBTABLE",
  /*  211 */ "UNTREATED",
  /*  212 */ "KILL",
  /*  213 */ "CONNECTION",
  /*  214 */ "TRANSACTION",
  /*  215 */ "BALANCE",
  /*  216 */ "VGROUP",
  /*  217 */ "LEADER",
  /*  218 */ "MERGE",
  /*  219 */ "REDISTRIBUTE",
  /*  220 */ "SPLIT",
  /*  221 */ "DELETE",
  /*  222 */ "INSERT",
  /*  223 */ "NULL",
  /*  224 */ "NK_QUESTION",
  /*  225 */ "NK_ARROW",
  /*  226 */ "ROWTS",
  /*  227 */ "QSTART",
  /*  228 */ "QEND",
  /*  229 */ "QDURATION",
  /*  230 */ "WSTART",
  /*  231 */ "WEND",
  /*  232 */ "WDURATION",
  /*  233 */ "IROWTS",
  /*  234 */ "ISFILLED",
  /*  235 */ "CAST",
  /*  236 */ "NOW",
  /*  237 */ "TODAY",
  /*  238 */ "TIMEZONE",
  /*  239 */ "CLIENT_VERSION",
  /*  240 */ "SERVER_VERSION",
  /*  241 */ "SERVER_STATUS",
  /*  242 */ "CURRENT_USER",
  /*  243 */ "CASE",
  /*  244 */ "WHEN",
  /*  245 */ "THEN",
  /*  246 */ "ELSE",
  /*  247 */ "BETWEEN",
  /*  248 */ "IS",
  /*  249 */ "NK_LT",
  /*  250 */ "NK_GT",
  /*  251 */ "NK_LE",
  /*  252 */ "NK_GE",
  /*  253 */ "NK_NE",
  /*  254 */ "MATCH",
  /*  255 */ "NMATCH",
  /*  256 */ "CONTAINS",
  /*  257 */ "IN",
  /*  258 */ "JOIN",
  /*  259 */ "INNER",
  /*  260 */ "SELECT",
  /*  261 */ "DISTINCT",
  /*  262 */ "WHERE",
  /*  263 */ "PARTITION",
  /*  264 */ "BY",
  /*  265 */ "SESSION",
  /*  266 */ "STATE_WINDOW",
  /*  267 */ "EVENT_WINDOW",
  /*  268 */ "SLIDING",
  /*  269 */ "FILL",
  /*  270 */ "VALUE",
  /*  271 */ "VALUE_F",
  /*  272 */ "NONE",
  /*  273 */ "PREV",
  /*  274 */ "NULL_F",
  /*  275 */ "LINEAR",
  /*  276 */ "NEXT",
  /*  277 */ "HAVING",
  /*  278 */ "RANGE",
  /*  279 */ "EVERY",
  /*  280 */ "ORDER",
  /*  281 */ "SLIMIT",
  /*  282 */ "SOFFSET",
  /*  283 */ "LIMIT",
  /*  284 */ "OFFSET",
  /*  285 */ "ASC",
  /*  286 */ "NULLS",
  /*  287 */ "ABORT",
  /*  288 */ "AFTER",
  /*  289 */ "ATTACH",
  /*  290 */ "BEFORE",
  /*  291 */ "BEGIN",
  /*  292 */ "BITAND",
  /*  293 */ "BITNOT",
  /*  294 */ "BITOR",
  /*  295 */ "BLOCKS",
  /*  296 */ "CHANGE",
  /*  297 */ "COMMA",
  /*  298 */ "CONCAT",
  /*  299 */ "CONFLICT",
  /*  300 */ "COPY",
  /*  301 */ "DEFERRED",
  /*  302 */ "DELIMITERS",
  /*  303 */ "DETACH",
  /*  304 */ "DIVIDE",
  /*  305 */ "DOT",
  /*  306 */ "EACH",
  /*  307 */ "FAIL",
  /*  308 */ "FILE",
  /*  309 */ "FOR",
  /*  310 */ "GLOB",
  /*  311 */ "ID",
  /*  312 */ "IMMEDIATE",
  /*  313 */ "IMPORT",
  /*  314 */ "INITIALLY",
  /*  315 */ "INSTEAD",
  /*  316 */ "ISNULL",
  /*  317 */ "KEY",
  /*  318 */ "MODULES",
  /*  319 */ "NK_BITNOT",
  /*  320 */ "NK_SEMI",
  /*  321 */ "NOTNULL",
  /*  322 */ "OF",
  /*  323 */ "PLUS",
  /*  324 */ "PRIVILEGE",
  /*  325 */ "RAISE",
  /*  326 */ "RESTRICT",
  /*  327 */ "ROW",
  /*  328 */ "SEMI",
  /*  329 */ "STAR",
  /*  330 */ "STATEMENT",
  /*  331 */ "STRICT",
  /*  332 */ "STRING",
  /*  333 */ "TIMES",
  /*  334 */ "VALUES",
  /*  335 */ "VARIABLE",
  /*  336 */ "VIEW",
  /*  337 */ "WAL",
  /*  338 */ "cmd",
  /*  339 */ "account_options",
  /*  340 */ "alter_account_options",
  /*  341 */ "literal",
  /*  342 */ "alter_account_option",
  /*  343 */ "user_name",
  /*  344 */ "sysinfo_opt",
  /*  345 */ "privileges",
  /*  346 */ "priv_level",
  /*  347 */ "with_opt",
  /*  348 */ "priv_type_list",
  /*  349 */ "priv_type",
  /*  350 */ "db_name",
  /*  351 */ "table_name",
  /*  352 */ "topic_name",
  /*  353 */ "search_condition",
  /*  354 */ "dnode_endpoint",
  /*  355 */ "force_opt",
  /*  356 */ "unsafe_opt",
  /*  357 */ "not_exists_opt",
  /*  358 */ "db_options",
  /*  359 */ "exists_opt",
  /*  360 */ "alter_db_options",
  /*  361 */ "speed_opt",
  /*  362 */ "start_opt",
  /*  363 */ "end_opt",
  /*  364 */ "integer_list",
  /*  365 */ "variable_list",
  /*  366 */ "retention_list",
  /*  367 */ "signed",
  /*  368 */ "alter_db_option",
  /*  369 */ "retention",
  /*  370 */ "full_table_name",
  /*  371 */ "column_def_list",
  /*  372 */ "tags_def_opt",
  /*  373 */ "table_options",
  /*  374 */ "multi_create_clause",
  /*  375 */ "tags_def",
  /*  376 */ "multi_drop_clause",
  /*  377 */ "alter_table_clause",
  /*  378 */ "alter_table_options",
  /*  379 */ "column_name",
  /*  380 */ "type_name",
  /*  381 */ "signed_literal",
  /*  382 */ "create_subtable_clause",
  /*  383 */ "specific_cols_opt",
  /*  384 */ "expression_list",
  /*  385 */ "drop_table_clause",
  /*  386 */ "col_name_list",
  /*  387 */ "column_def",
  /*  388 */ "duration_list",
  /*  389 */ "rollup_func_list",
  /*  390 */ "alter_table_option",
  /*  391 */ "duration_literal",
  /*  392 */ "rollup_func_name",
  /*  393 */ "function_name",
  /*  394 */ "col_name",
  /*  395 */ "db_name_cond_opt",
  /*  396 */ "like_pattern_opt",
  /*  397 */ "table_name_cond",
  /*  398 */ "from_db_opt",
  /*  399 */ "tag_list_opt",
  /*  400 */ "tag_item",
  /*  401 */ "column_alias",
  /*  402 */ "full_index_name",
  /*  403 */ "index_options",
  /*  404 */ "index_name",
  /*  405 */ "func_list",
  /*  406 */ "sliding_opt",
  /*  407 */ "sma_stream_opt",
  /*  408 */ "func",
  /*  409 */ "sma_func_name",
  /*  410 */ "with_meta",
  /*  411 */ "query_or_subquery",
  /*  412 */ "where_clause_opt",
  /*  413 */ "cgroup_name",
  /*  414 */ "analyze_opt",
  /*  415 */ "explain_options",
  /*  416 */ "insert_query",
  /*  417 */ "or_replace_opt",
  /*  418 */ "agg_func_opt",
  /*  419 */ "bufsize_opt",
  /*  420 */ "language_opt",
  /*  421 */ "stream_name",
  /*  422 */ "stream_options",
  /*  423 */ "col_list_opt",
  /*  424 */ "tag_def_or_ref_opt",
  /*  425 */ "subtable_opt",
  /*  426 */ "ignore_opt",
  /*  427 */ "expression",
  /*  428 */ "dnode_list",
  /*  429 */ "literal_func",
  /*  430 */ "literal_list",
  /*  431 */ "table_alias",
  /*  432 */ "expr_or_subquery",
  /*  433 */ "pseudo_column",
  /*  434 */ "column_reference",
  /*  435 */ "function_expression",
  /*  436 */ "case_when_expression",
  /*  437 */ "star_func",
  /*  438 */ "star_func_para_list",
  /*  439 */ "noarg_func",
  /*  440 */ "other_para_list",
  /*  441 */ "star_func_para",
  /*  442 */ "when_then_list",
  /*  443 */ "case_when_else_opt",
  /*  444 */ "common_expression",
  /*  445 */ "when_then_expr",
  /*  446 */ "predicate",
  /*  447 */ "compare_op",
  /*  448 */ "in_op",
  /*  449 */ "in_predicate_value",
  /*  450 */ "boolean_value_expression",
  /*  451 */ "boolean_primary",
  /*  452 */ "from_clause_opt",
  /*  453 */ "table_reference_list",
  /*  454 */ "table_reference",
  /*  455 */ "table_primary",
  /*  456 */ "joined_table",
  /*  457 */ "alias_opt",
  /*  458 */ "subquery",
  /*  459 */ "parenthesized_joined_table",
  /*  460 */ "join_type",
  /*  461 */ "query_specification",
  /*  462 */ "set_quantifier_opt",
  /*  463 */ "select_list",
  /*  464 */ "partition_by_clause_opt",
  /*  465 */ "range_opt",
  /*  466 */ "every_opt",
  /*  467 */ "fill_opt",
  /*  468 */ "twindow_clause_opt",
  /*  469 */ "group_by_clause_opt",
  /*  470 */ "having_clause_opt",
  /*  471 */ "select_item",
  /*  472 */ "partition_list",
  /*  473 */ "partition_item",
  /*  474 */ "fill_mode",
  /*  475 */ "group_by_list",
  /*  476 */ "query_expression",
  /*  477 */ "query_simple",
  /*  478 */ "order_by_clause_opt",
  /*  479 */ "slimit_clause_opt",
  /*  480 */ "limit_clause_opt",
  /*  481 */ "union_query_expression",
  /*  482 */ "query_simple_or_subquery",
  /*  483 */ "sort_specification_list",
  /*  484 */ "sort_specification",
  /*  485 */ "ordering_specification_opt",
  /*  486 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level with_opt TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= db_name NK_DOT table_name",
 /*  43 */ "priv_level ::= topic_name",
 /*  44 */ "with_opt ::=",
 /*  45 */ "with_opt ::= WITH search_condition",
 /*  46 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  47 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  48 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  49 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  50 */ "cmd ::= DROP DNODE NK_INTEGER unsafe_opt",
 /*  51 */ "cmd ::= DROP DNODE dnode_endpoint unsafe_opt",
 /*  52 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  53 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  54 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  55 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  56 */ "cmd ::= RESTORE DNODE NK_INTEGER",
 /*  57 */ "dnode_endpoint ::= NK_STRING",
 /*  58 */ "dnode_endpoint ::= NK_ID",
 /*  59 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  60 */ "force_opt ::=",
 /*  61 */ "force_opt ::= FORCE",
 /*  62 */ "unsafe_opt ::= UNSAFE",
 /*  63 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  64 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  65 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  67 */ "cmd ::= RESTORE QNODE ON DNODE NK_INTEGER",
 /*  68 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  69 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  70 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  71 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  72 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  73 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  74 */ "cmd ::= RESTORE MNODE ON DNODE NK_INTEGER",
 /*  75 */ "cmd ::= RESTORE VNODE ON DNODE NK_INTEGER",
 /*  76 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  77 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  78 */ "cmd ::= USE db_name",
 /*  79 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  80 */ "cmd ::= FLUSH DATABASE db_name",
 /*  81 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  82 */ "cmd ::= COMPACT DATABASE db_name start_opt end_opt",
 /*  83 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  84 */ "not_exists_opt ::=",
 /*  85 */ "exists_opt ::= IF EXISTS",
 /*  86 */ "exists_opt ::=",
 /*  87 */ "db_options ::=",
 /*  88 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  89 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  90 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  91 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  92 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  93 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  94 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  95 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  96 */ "db_options ::= db_options KEEP integer_list",
 /*  97 */ "db_options ::= db_options KEEP variable_list",
 /*  98 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  99 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /* 100 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options PRECISION NK_STRING",
 /* 102 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /* 103 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /* 104 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /* 105 */ "db_options ::= db_options RETENTIONS retention_list",
 /* 106 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /* 107 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /* 108 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /* 109 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 110 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 111 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 112 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 113 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 114 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 115 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 116 */ "db_options ::= db_options TABLE_PREFIX signed",
 /* 117 */ "db_options ::= db_options TABLE_SUFFIX signed",
 /* 118 */ "alter_db_options ::= alter_db_option",
 /* 119 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 120 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 121 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 122 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 123 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 124 */ "alter_db_option ::= KEEP integer_list",
 /* 125 */ "alter_db_option ::= KEEP variable_list",
 /* 126 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 127 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 128 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 129 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 130 */ "alter_db_option ::= MINROWS NK_INTEGER",
 /* 131 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER",
 /* 132 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 133 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER",
 /* 134 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 135 */ "integer_list ::= NK_INTEGER",
 /* 136 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 137 */ "variable_list ::= NK_VARIABLE",
 /* 138 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 139 */ "retention_list ::= retention",
 /* 140 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 141 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 142 */ "speed_opt ::=",
 /* 143 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 144 */ "start_opt ::=",
 /* 145 */ "start_opt ::= START WITH NK_INTEGER",
 /* 146 */ "start_opt ::= START WITH NK_STRING",
 /* 147 */ "start_opt ::= START WITH TIMESTAMP NK_STRING",
 /* 148 */ "end_opt ::=",
 /* 149 */ "end_opt ::= END WITH NK_INTEGER",
 /* 150 */ "end_opt ::= END WITH NK_STRING",
 /* 151 */ "end_opt ::= END WITH TIMESTAMP NK_STRING",
 /* 152 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 153 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 154 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 155 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 156 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 157 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 158 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 159 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 160 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 161 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 162 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 163 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 164 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 165 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 166 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 167 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 168 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 169 */ "multi_create_clause ::= create_subtable_clause",
 /* 170 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 171 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 172 */ "multi_drop_clause ::= drop_table_clause",
 /* 173 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 174 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 175 */ "specific_cols_opt ::=",
 /* 176 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 177 */ "full_table_name ::= table_name",
 /* 178 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 179 */ "column_def_list ::= column_def",
 /* 180 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 181 */ "column_def ::= column_name type_name",
 /* 182 */ "type_name ::= BOOL",
 /* 183 */ "type_name ::= TINYINT",
 /* 184 */ "type_name ::= SMALLINT",
 /* 185 */ "type_name ::= INT",
 /* 186 */ "type_name ::= INTEGER",
 /* 187 */ "type_name ::= BIGINT",
 /* 188 */ "type_name ::= FLOAT",
 /* 189 */ "type_name ::= DOUBLE",
 /* 190 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 191 */ "type_name ::= TIMESTAMP",
 /* 192 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 193 */ "type_name ::= TINYINT UNSIGNED",
 /* 194 */ "type_name ::= SMALLINT UNSIGNED",
 /* 195 */ "type_name ::= INT UNSIGNED",
 /* 196 */ "type_name ::= BIGINT UNSIGNED",
 /* 197 */ "type_name ::= JSON",
 /* 198 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 199 */ "type_name ::= MEDIUMBLOB",
 /* 200 */ "type_name ::= BLOB",
 /* 201 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 202 */ "type_name ::= GEOMETRY NK_LP NK_INTEGER NK_RP",
 /* 203 */ "type_name ::= DECIMAL",
 /* 204 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 205 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 206 */ "tags_def_opt ::=",
 /* 207 */ "tags_def_opt ::= tags_def",
 /* 208 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 209 */ "table_options ::=",
 /* 210 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 211 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 212 */ "table_options ::= table_options WATERMARK duration_list",
 /* 213 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 214 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 215 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 216 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 217 */ "alter_table_options ::= alter_table_option",
 /* 218 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 219 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 220 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 221 */ "duration_list ::= duration_literal",
 /* 222 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 223 */ "rollup_func_list ::= rollup_func_name",
 /* 224 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 225 */ "rollup_func_name ::= function_name",
 /* 226 */ "rollup_func_name ::= FIRST",
 /* 227 */ "rollup_func_name ::= LAST",
 /* 228 */ "col_name_list ::= col_name",
 /* 229 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 230 */ "col_name ::= column_name",
 /* 231 */ "cmd ::= SHOW DNODES",
 /* 232 */ "cmd ::= SHOW USERS",
 /* 233 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 234 */ "cmd ::= SHOW DATABASES",
 /* 235 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 236 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 237 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 238 */ "cmd ::= SHOW MNODES",
 /* 239 */ "cmd ::= SHOW QNODES",
 /* 240 */ "cmd ::= SHOW FUNCTIONS",
 /* 241 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 242 */ "cmd ::= SHOW INDEXES FROM db_name NK_DOT table_name",
 /* 243 */ "cmd ::= SHOW STREAMS",
 /* 244 */ "cmd ::= SHOW ACCOUNTS",
 /* 245 */ "cmd ::= SHOW APPS",
 /* 246 */ "cmd ::= SHOW CONNECTIONS",
 /* 247 */ "cmd ::= SHOW LICENCES",
 /* 248 */ "cmd ::= SHOW GRANTS",
 /* 249 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 250 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 251 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 252 */ "cmd ::= SHOW QUERIES",
 /* 253 */ "cmd ::= SHOW SCORES",
 /* 254 */ "cmd ::= SHOW TOPICS",
 /* 255 */ "cmd ::= SHOW VARIABLES",
 /* 256 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 257 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 258 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 259 */ "cmd ::= SHOW BNODES",
 /* 260 */ "cmd ::= SHOW SNODES",
 /* 261 */ "cmd ::= SHOW CLUSTER",
 /* 262 */ "cmd ::= SHOW TRANSACTIONS",
 /* 263 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 264 */ "cmd ::= SHOW CONSUMERS",
 /* 265 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 266 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 267 */ "cmd ::= SHOW TAGS FROM db_name NK_DOT table_name",
 /* 268 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 269 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM db_name NK_DOT table_name",
 /* 270 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 271 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 272 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 273 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 274 */ "db_name_cond_opt ::=",
 /* 275 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 276 */ "like_pattern_opt ::=",
 /* 277 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 278 */ "table_name_cond ::= table_name",
 /* 279 */ "from_db_opt ::=",
 /* 280 */ "from_db_opt ::= FROM db_name",
 /* 281 */ "tag_list_opt ::=",
 /* 282 */ "tag_list_opt ::= tag_item",
 /* 283 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 284 */ "tag_item ::= TBNAME",
 /* 285 */ "tag_item ::= QTAGS",
 /* 286 */ "tag_item ::= column_name",
 /* 287 */ "tag_item ::= column_name column_alias",
 /* 288 */ "tag_item ::= column_name AS column_alias",
 /* 289 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 290 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 291 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 292 */ "full_index_name ::= index_name",
 /* 293 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 294 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 295 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 296 */ "func_list ::= func",
 /* 297 */ "func_list ::= func_list NK_COMMA func",
 /* 298 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 299 */ "sma_func_name ::= function_name",
 /* 300 */ "sma_func_name ::= COUNT",
 /* 301 */ "sma_func_name ::= FIRST",
 /* 302 */ "sma_func_name ::= LAST",
 /* 303 */ "sma_func_name ::= LAST_ROW",
 /* 304 */ "sma_stream_opt ::=",
 /* 305 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 306 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 307 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 308 */ "with_meta ::= AS",
 /* 309 */ "with_meta ::= WITH META AS",
 /* 310 */ "with_meta ::= ONLY META AS",
 /* 311 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 312 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name with_meta DATABASE db_name",
 /* 313 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name with_meta STABLE full_table_name where_clause_opt",
 /* 314 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 315 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 316 */ "cmd ::= DESC full_table_name",
 /* 317 */ "cmd ::= DESCRIBE full_table_name",
 /* 318 */ "cmd ::= RESET QUERY CACHE",
 /* 319 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 320 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 321 */ "analyze_opt ::=",
 /* 322 */ "analyze_opt ::= ANALYZE",
 /* 323 */ "explain_options ::=",
 /* 324 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 325 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 326 */ "cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt",
 /* 327 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 328 */ "agg_func_opt ::=",
 /* 329 */ "agg_func_opt ::= AGGREGATE",
 /* 330 */ "bufsize_opt ::=",
 /* 331 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 332 */ "language_opt ::=",
 /* 333 */ "language_opt ::= LANGUAGE NK_STRING",
 /* 334 */ "or_replace_opt ::=",
 /* 335 */ "or_replace_opt ::= OR REPLACE",
 /* 336 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 337 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 338 */ "cmd ::= PAUSE STREAM exists_opt stream_name",
 /* 339 */ "cmd ::= RESUME STREAM exists_opt ignore_opt stream_name",
 /* 340 */ "col_list_opt ::=",
 /* 341 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 342 */ "tag_def_or_ref_opt ::=",
 /* 343 */ "tag_def_or_ref_opt ::= tags_def",
 /* 344 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 345 */ "stream_options ::=",
 /* 346 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 347 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 348 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 349 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 350 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 351 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 352 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 353 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 354 */ "subtable_opt ::=",
 /* 355 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 356 */ "ignore_opt ::=",
 /* 357 */ "ignore_opt ::= IGNORE UNTREATED",
 /* 358 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 359 */ "cmd ::= KILL QUERY NK_STRING",
 /* 360 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 361 */ "cmd ::= BALANCE VGROUP",
 /* 362 */ "cmd ::= BALANCE VGROUP LEADER",
 /* 363 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 364 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 365 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 366 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 367 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 368 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 369 */ "cmd ::= query_or_subquery",
 /* 370 */ "cmd ::= insert_query",
 /* 371 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 372 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 373 */ "literal ::= NK_INTEGER",
 /* 374 */ "literal ::= NK_FLOAT",
 /* 375 */ "literal ::= NK_STRING",
 /* 376 */ "literal ::= NK_BOOL",
 /* 377 */ "literal ::= TIMESTAMP NK_STRING",
 /* 378 */ "literal ::= duration_literal",
 /* 379 */ "literal ::= NULL",
 /* 380 */ "literal ::= NK_QUESTION",
 /* 381 */ "duration_literal ::= NK_VARIABLE",
 /* 382 */ "signed ::= NK_INTEGER",
 /* 383 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 384 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 385 */ "signed ::= NK_FLOAT",
 /* 386 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 387 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 388 */ "signed_literal ::= signed",
 /* 389 */ "signed_literal ::= NK_STRING",
 /* 390 */ "signed_literal ::= NK_BOOL",
 /* 391 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 392 */ "signed_literal ::= duration_literal",
 /* 393 */ "signed_literal ::= NULL",
 /* 394 */ "signed_literal ::= literal_func",
 /* 395 */ "signed_literal ::= NK_QUESTION",
 /* 396 */ "literal_list ::= signed_literal",
 /* 397 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 398 */ "db_name ::= NK_ID",
 /* 399 */ "table_name ::= NK_ID",
 /* 400 */ "column_name ::= NK_ID",
 /* 401 */ "function_name ::= NK_ID",
 /* 402 */ "table_alias ::= NK_ID",
 /* 403 */ "column_alias ::= NK_ID",
 /* 404 */ "user_name ::= NK_ID",
 /* 405 */ "topic_name ::= NK_ID",
 /* 406 */ "stream_name ::= NK_ID",
 /* 407 */ "cgroup_name ::= NK_ID",
 /* 408 */ "index_name ::= NK_ID",
 /* 409 */ "expr_or_subquery ::= expression",
 /* 410 */ "expression ::= literal",
 /* 411 */ "expression ::= pseudo_column",
 /* 412 */ "expression ::= column_reference",
 /* 413 */ "expression ::= function_expression",
 /* 414 */ "expression ::= case_when_expression",
 /* 415 */ "expression ::= NK_LP expression NK_RP",
 /* 416 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 417 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 418 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 419 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 420 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 421 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 422 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 423 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 424 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 425 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 426 */ "expression_list ::= expr_or_subquery",
 /* 427 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 428 */ "column_reference ::= column_name",
 /* 429 */ "column_reference ::= table_name NK_DOT column_name",
 /* 430 */ "pseudo_column ::= ROWTS",
 /* 431 */ "pseudo_column ::= TBNAME",
 /* 432 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 433 */ "pseudo_column ::= QSTART",
 /* 434 */ "pseudo_column ::= QEND",
 /* 435 */ "pseudo_column ::= QDURATION",
 /* 436 */ "pseudo_column ::= WSTART",
 /* 437 */ "pseudo_column ::= WEND",
 /* 438 */ "pseudo_column ::= WDURATION",
 /* 439 */ "pseudo_column ::= IROWTS",
 /* 440 */ "pseudo_column ::= ISFILLED",
 /* 441 */ "pseudo_column ::= QTAGS",
 /* 442 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 443 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 444 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 445 */ "function_expression ::= literal_func",
 /* 446 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 447 */ "literal_func ::= NOW",
 /* 448 */ "noarg_func ::= NOW",
 /* 449 */ "noarg_func ::= TODAY",
 /* 450 */ "noarg_func ::= TIMEZONE",
 /* 451 */ "noarg_func ::= DATABASE",
 /* 452 */ "noarg_func ::= CLIENT_VERSION",
 /* 453 */ "noarg_func ::= SERVER_VERSION",
 /* 454 */ "noarg_func ::= SERVER_STATUS",
 /* 455 */ "noarg_func ::= CURRENT_USER",
 /* 456 */ "noarg_func ::= USER",
 /* 457 */ "star_func ::= COUNT",
 /* 458 */ "star_func ::= FIRST",
 /* 459 */ "star_func ::= LAST",
 /* 460 */ "star_func ::= LAST_ROW",
 /* 461 */ "star_func_para_list ::= NK_STAR",
 /* 462 */ "star_func_para_list ::= other_para_list",
 /* 463 */ "other_para_list ::= star_func_para",
 /* 464 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 465 */ "star_func_para ::= expr_or_subquery",
 /* 466 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 467 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 468 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 469 */ "when_then_list ::= when_then_expr",
 /* 470 */ "when_then_list ::= when_then_list when_then_expr",
 /* 471 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 472 */ "case_when_else_opt ::=",
 /* 473 */ "case_when_else_opt ::= ELSE common_expression",
 /* 474 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 475 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 476 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 477 */ "predicate ::= expr_or_subquery IS NULL",
 /* 478 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 479 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 480 */ "compare_op ::= NK_LT",
 /* 481 */ "compare_op ::= NK_GT",
 /* 482 */ "compare_op ::= NK_LE",
 /* 483 */ "compare_op ::= NK_GE",
 /* 484 */ "compare_op ::= NK_NE",
 /* 485 */ "compare_op ::= NK_EQ",
 /* 486 */ "compare_op ::= LIKE",
 /* 487 */ "compare_op ::= NOT LIKE",
 /* 488 */ "compare_op ::= MATCH",
 /* 489 */ "compare_op ::= NMATCH",
 /* 490 */ "compare_op ::= CONTAINS",
 /* 491 */ "in_op ::= IN",
 /* 492 */ "in_op ::= NOT IN",
 /* 493 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 494 */ "boolean_value_expression ::= boolean_primary",
 /* 495 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 496 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 497 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 498 */ "boolean_primary ::= predicate",
 /* 499 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 500 */ "common_expression ::= expr_or_subquery",
 /* 501 */ "common_expression ::= boolean_value_expression",
 /* 502 */ "from_clause_opt ::=",
 /* 503 */ "from_clause_opt ::= FROM table_reference_list",
 /* 504 */ "table_reference_list ::= table_reference",
 /* 505 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 506 */ "table_reference ::= table_primary",
 /* 507 */ "table_reference ::= joined_table",
 /* 508 */ "table_primary ::= table_name alias_opt",
 /* 509 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 510 */ "table_primary ::= subquery alias_opt",
 /* 511 */ "table_primary ::= parenthesized_joined_table",
 /* 512 */ "alias_opt ::=",
 /* 513 */ "alias_opt ::= table_alias",
 /* 514 */ "alias_opt ::= AS table_alias",
 /* 515 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 516 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 517 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 518 */ "join_type ::=",
 /* 519 */ "join_type ::= INNER",
 /* 520 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 521 */ "set_quantifier_opt ::=",
 /* 522 */ "set_quantifier_opt ::= DISTINCT",
 /* 523 */ "set_quantifier_opt ::= ALL",
 /* 524 */ "select_list ::= select_item",
 /* 525 */ "select_list ::= select_list NK_COMMA select_item",
 /* 526 */ "select_item ::= NK_STAR",
 /* 527 */ "select_item ::= common_expression",
 /* 528 */ "select_item ::= common_expression column_alias",
 /* 529 */ "select_item ::= common_expression AS column_alias",
 /* 530 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 531 */ "where_clause_opt ::=",
 /* 532 */ "where_clause_opt ::= WHERE search_condition",
 /* 533 */ "partition_by_clause_opt ::=",
 /* 534 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 535 */ "partition_list ::= partition_item",
 /* 536 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 537 */ "partition_item ::= expr_or_subquery",
 /* 538 */ "partition_item ::= expr_or_subquery column_alias",
 /* 539 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 540 */ "twindow_clause_opt ::=",
 /* 541 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 542 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 543 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 544 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 545 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 546 */ "sliding_opt ::=",
 /* 547 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 548 */ "fill_opt ::=",
 /* 549 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 550 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP",
 /* 551 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP",
 /* 552 */ "fill_mode ::= NONE",
 /* 553 */ "fill_mode ::= PREV",
 /* 554 */ "fill_mode ::= NULL",
 /* 555 */ "fill_mode ::= NULL_F",
 /* 556 */ "fill_mode ::= LINEAR",
 /* 557 */ "fill_mode ::= NEXT",
 /* 558 */ "group_by_clause_opt ::=",
 /* 559 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 560 */ "group_by_list ::= expr_or_subquery",
 /* 561 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 562 */ "having_clause_opt ::=",
 /* 563 */ "having_clause_opt ::= HAVING search_condition",
 /* 564 */ "range_opt ::=",
 /* 565 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 566 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_RP",
 /* 567 */ "every_opt ::=",
 /* 568 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 569 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 570 */ "query_simple ::= query_specification",
 /* 571 */ "query_simple ::= union_query_expression",
 /* 572 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 573 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 574 */ "query_simple_or_subquery ::= query_simple",
 /* 575 */ "query_simple_or_subquery ::= subquery",
 /* 576 */ "query_or_subquery ::= query_expression",
 /* 577 */ "query_or_subquery ::= subquery",
 /* 578 */ "order_by_clause_opt ::=",
 /* 579 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 580 */ "slimit_clause_opt ::=",
 /* 581 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 582 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 583 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 584 */ "limit_clause_opt ::=",
 /* 585 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 586 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 587 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 588 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 589 */ "subquery ::= NK_LP subquery NK_RP",
 /* 590 */ "search_condition ::= common_expression",
 /* 591 */ "sort_specification_list ::= sort_specification",
 /* 592 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 593 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 594 */ "ordering_specification_opt ::=",
 /* 595 */ "ordering_specification_opt ::= ASC",
 /* 596 */ "ordering_specification_opt ::= DESC",
 /* 597 */ "null_ordering_opt ::=",
 /* 598 */ "null_ordering_opt ::= NULLS FIRST",
 /* 599 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 338: /* cmd */
    case 341: /* literal */
    case 347: /* with_opt */
    case 353: /* search_condition */
    case 358: /* db_options */
    case 360: /* alter_db_options */
    case 362: /* start_opt */
    case 363: /* end_opt */
    case 367: /* signed */
    case 369: /* retention */
    case 370: /* full_table_name */
    case 373: /* table_options */
    case 377: /* alter_table_clause */
    case 378: /* alter_table_options */
    case 381: /* signed_literal */
    case 382: /* create_subtable_clause */
    case 385: /* drop_table_clause */
    case 387: /* column_def */
    case 391: /* duration_literal */
    case 392: /* rollup_func_name */
    case 394: /* col_name */
    case 395: /* db_name_cond_opt */
    case 396: /* like_pattern_opt */
    case 397: /* table_name_cond */
    case 398: /* from_db_opt */
    case 400: /* tag_item */
    case 402: /* full_index_name */
    case 403: /* index_options */
    case 406: /* sliding_opt */
    case 407: /* sma_stream_opt */
    case 408: /* func */
    case 411: /* query_or_subquery */
    case 412: /* where_clause_opt */
    case 415: /* explain_options */
    case 416: /* insert_query */
    case 422: /* stream_options */
    case 425: /* subtable_opt */
    case 427: /* expression */
    case 429: /* literal_func */
    case 432: /* expr_or_subquery */
    case 433: /* pseudo_column */
    case 434: /* column_reference */
    case 435: /* function_expression */
    case 436: /* case_when_expression */
    case 441: /* star_func_para */
    case 443: /* case_when_else_opt */
    case 444: /* common_expression */
    case 445: /* when_then_expr */
    case 446: /* predicate */
    case 449: /* in_predicate_value */
    case 450: /* boolean_value_expression */
    case 451: /* boolean_primary */
    case 452: /* from_clause_opt */
    case 453: /* table_reference_list */
    case 454: /* table_reference */
    case 455: /* table_primary */
    case 456: /* joined_table */
    case 458: /* subquery */
    case 459: /* parenthesized_joined_table */
    case 461: /* query_specification */
    case 465: /* range_opt */
    case 466: /* every_opt */
    case 467: /* fill_opt */
    case 468: /* twindow_clause_opt */
    case 470: /* having_clause_opt */
    case 471: /* select_item */
    case 473: /* partition_item */
    case 476: /* query_expression */
    case 477: /* query_simple */
    case 479: /* slimit_clause_opt */
    case 480: /* limit_clause_opt */
    case 481: /* union_query_expression */
    case 482: /* query_simple_or_subquery */
    case 484: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy452)); 
}
      break;
    case 339: /* account_options */
    case 340: /* alter_account_options */
    case 342: /* alter_account_option */
    case 361: /* speed_opt */
    case 410: /* with_meta */
    case 419: /* bufsize_opt */
{
 
}
      break;
    case 343: /* user_name */
    case 350: /* db_name */
    case 351: /* table_name */
    case 352: /* topic_name */
    case 354: /* dnode_endpoint */
    case 379: /* column_name */
    case 393: /* function_name */
    case 401: /* column_alias */
    case 404: /* index_name */
    case 409: /* sma_func_name */
    case 413: /* cgroup_name */
    case 420: /* language_opt */
    case 421: /* stream_name */
    case 431: /* table_alias */
    case 437: /* star_func */
    case 439: /* noarg_func */
    case 457: /* alias_opt */
{
 
}
      break;
    case 344: /* sysinfo_opt */
{
 
}
      break;
    case 345: /* privileges */
    case 348: /* priv_type_list */
    case 349: /* priv_type */
{
 
}
      break;
    case 346: /* priv_level */
{
 
}
      break;
    case 355: /* force_opt */
    case 356: /* unsafe_opt */
    case 357: /* not_exists_opt */
    case 359: /* exists_opt */
    case 414: /* analyze_opt */
    case 417: /* or_replace_opt */
    case 418: /* agg_func_opt */
    case 426: /* ignore_opt */
    case 462: /* set_quantifier_opt */
{
 
}
      break;
    case 364: /* integer_list */
    case 365: /* variable_list */
    case 366: /* retention_list */
    case 371: /* column_def_list */
    case 372: /* tags_def_opt */
    case 374: /* multi_create_clause */
    case 375: /* tags_def */
    case 376: /* multi_drop_clause */
    case 383: /* specific_cols_opt */
    case 384: /* expression_list */
    case 386: /* col_name_list */
    case 388: /* duration_list */
    case 389: /* rollup_func_list */
    case 399: /* tag_list_opt */
    case 405: /* func_list */
    case 423: /* col_list_opt */
    case 424: /* tag_def_or_ref_opt */
    case 428: /* dnode_list */
    case 430: /* literal_list */
    case 438: /* star_func_para_list */
    case 440: /* other_para_list */
    case 442: /* when_then_list */
    case 463: /* select_list */
    case 464: /* partition_by_clause_opt */
    case 469: /* group_by_clause_opt */
    case 472: /* partition_list */
    case 475: /* group_by_list */
    case 478: /* order_by_clause_opt */
    case 483: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy812)); 
}
      break;
    case 368: /* alter_db_option */
    case 390: /* alter_table_option */
{
 
}
      break;
    case 380: /* type_name */
{
 
}
      break;
    case 447: /* compare_op */
    case 448: /* in_op */
{
 
}
      break;
    case 460: /* join_type */
{
 
}
      break;
    case 474: /* fill_mode */
{
 
}
      break;
    case 485: /* ordering_specification_opt */
{
 
}
      break;
    case 486: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<sizeof(yy_action)/sizeof(yy_action[0]) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
   338,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   338,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
   339,  /* (2) account_options ::= */
   339,  /* (3) account_options ::= account_options PPS literal */
   339,  /* (4) account_options ::= account_options TSERIES literal */
   339,  /* (5) account_options ::= account_options STORAGE literal */
   339,  /* (6) account_options ::= account_options STREAMS literal */
   339,  /* (7) account_options ::= account_options QTIME literal */
   339,  /* (8) account_options ::= account_options DBS literal */
   339,  /* (9) account_options ::= account_options USERS literal */
   339,  /* (10) account_options ::= account_options CONNS literal */
   339,  /* (11) account_options ::= account_options STATE literal */
   340,  /* (12) alter_account_options ::= alter_account_option */
   340,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   342,  /* (14) alter_account_option ::= PASS literal */
   342,  /* (15) alter_account_option ::= PPS literal */
   342,  /* (16) alter_account_option ::= TSERIES literal */
   342,  /* (17) alter_account_option ::= STORAGE literal */
   342,  /* (18) alter_account_option ::= STREAMS literal */
   342,  /* (19) alter_account_option ::= QTIME literal */
   342,  /* (20) alter_account_option ::= DBS literal */
   342,  /* (21) alter_account_option ::= USERS literal */
   342,  /* (22) alter_account_option ::= CONNS literal */
   342,  /* (23) alter_account_option ::= STATE literal */
   338,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   338,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   338,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   338,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   338,  /* (28) cmd ::= DROP USER user_name */
   344,  /* (29) sysinfo_opt ::= */
   344,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   338,  /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
   338,  /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
   345,  /* (33) privileges ::= ALL */
   345,  /* (34) privileges ::= priv_type_list */
   345,  /* (35) privileges ::= SUBSCRIBE */
   348,  /* (36) priv_type_list ::= priv_type */
   348,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   349,  /* (38) priv_type ::= READ */
   349,  /* (39) priv_type ::= WRITE */
   346,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   346,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   346,  /* (42) priv_level ::= db_name NK_DOT table_name */
   346,  /* (43) priv_level ::= topic_name */
   347,  /* (44) with_opt ::= */
   347,  /* (45) with_opt ::= WITH search_condition */
   338,  /* (46) cmd ::= CREATE DNODE dnode_endpoint */
   338,  /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   338,  /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
   338,  /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
   338,  /* (50) cmd ::= DROP DNODE NK_INTEGER unsafe_opt */
   338,  /* (51) cmd ::= DROP DNODE dnode_endpoint unsafe_opt */
   338,  /* (52) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   338,  /* (53) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   338,  /* (54) cmd ::= ALTER ALL DNODES NK_STRING */
   338,  /* (55) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   338,  /* (56) cmd ::= RESTORE DNODE NK_INTEGER */
   354,  /* (57) dnode_endpoint ::= NK_STRING */
   354,  /* (58) dnode_endpoint ::= NK_ID */
   354,  /* (59) dnode_endpoint ::= NK_IPTOKEN */
   355,  /* (60) force_opt ::= */
   355,  /* (61) force_opt ::= FORCE */
   356,  /* (62) unsafe_opt ::= UNSAFE */
   338,  /* (63) cmd ::= ALTER LOCAL NK_STRING */
   338,  /* (64) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   338,  /* (65) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   338,  /* (66) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   338,  /* (67) cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
   338,  /* (68) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   338,  /* (69) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   338,  /* (70) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   338,  /* (71) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   338,  /* (72) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   338,  /* (73) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   338,  /* (74) cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
   338,  /* (75) cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
   338,  /* (76) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   338,  /* (77) cmd ::= DROP DATABASE exists_opt db_name */
   338,  /* (78) cmd ::= USE db_name */
   338,  /* (79) cmd ::= ALTER DATABASE db_name alter_db_options */
   338,  /* (80) cmd ::= FLUSH DATABASE db_name */
   338,  /* (81) cmd ::= TRIM DATABASE db_name speed_opt */
   338,  /* (82) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
   357,  /* (83) not_exists_opt ::= IF NOT EXISTS */
   357,  /* (84) not_exists_opt ::= */
   359,  /* (85) exists_opt ::= IF EXISTS */
   359,  /* (86) exists_opt ::= */
   358,  /* (87) db_options ::= */
   358,  /* (88) db_options ::= db_options BUFFER NK_INTEGER */
   358,  /* (89) db_options ::= db_options CACHEMODEL NK_STRING */
   358,  /* (90) db_options ::= db_options CACHESIZE NK_INTEGER */
   358,  /* (91) db_options ::= db_options COMP NK_INTEGER */
   358,  /* (92) db_options ::= db_options DURATION NK_INTEGER */
   358,  /* (93) db_options ::= db_options DURATION NK_VARIABLE */
   358,  /* (94) db_options ::= db_options MAXROWS NK_INTEGER */
   358,  /* (95) db_options ::= db_options MINROWS NK_INTEGER */
   358,  /* (96) db_options ::= db_options KEEP integer_list */
   358,  /* (97) db_options ::= db_options KEEP variable_list */
   358,  /* (98) db_options ::= db_options PAGES NK_INTEGER */
   358,  /* (99) db_options ::= db_options PAGESIZE NK_INTEGER */
   358,  /* (100) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   358,  /* (101) db_options ::= db_options PRECISION NK_STRING */
   358,  /* (102) db_options ::= db_options REPLICA NK_INTEGER */
   358,  /* (103) db_options ::= db_options VGROUPS NK_INTEGER */
   358,  /* (104) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   358,  /* (105) db_options ::= db_options RETENTIONS retention_list */
   358,  /* (106) db_options ::= db_options SCHEMALESS NK_INTEGER */
   358,  /* (107) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   358,  /* (108) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   358,  /* (109) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   358,  /* (110) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   358,  /* (111) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   358,  /* (112) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   358,  /* (113) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   358,  /* (114) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   358,  /* (115) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   358,  /* (116) db_options ::= db_options TABLE_PREFIX signed */
   358,  /* (117) db_options ::= db_options TABLE_SUFFIX signed */
   360,  /* (118) alter_db_options ::= alter_db_option */
   360,  /* (119) alter_db_options ::= alter_db_options alter_db_option */
   368,  /* (120) alter_db_option ::= BUFFER NK_INTEGER */
   368,  /* (121) alter_db_option ::= CACHEMODEL NK_STRING */
   368,  /* (122) alter_db_option ::= CACHESIZE NK_INTEGER */
   368,  /* (123) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   368,  /* (124) alter_db_option ::= KEEP integer_list */
   368,  /* (125) alter_db_option ::= KEEP variable_list */
   368,  /* (126) alter_db_option ::= PAGES NK_INTEGER */
   368,  /* (127) alter_db_option ::= REPLICA NK_INTEGER */
   368,  /* (128) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   368,  /* (129) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   368,  /* (130) alter_db_option ::= MINROWS NK_INTEGER */
   368,  /* (131) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
   368,  /* (132) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   368,  /* (133) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
   368,  /* (134) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   364,  /* (135) integer_list ::= NK_INTEGER */
   364,  /* (136) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   365,  /* (137) variable_list ::= NK_VARIABLE */
   365,  /* (138) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   366,  /* (139) retention_list ::= retention */
   366,  /* (140) retention_list ::= retention_list NK_COMMA retention */
   369,  /* (141) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
   361,  /* (142) speed_opt ::= */
   361,  /* (143) speed_opt ::= MAX_SPEED NK_INTEGER */
   362,  /* (144) start_opt ::= */
   362,  /* (145) start_opt ::= START WITH NK_INTEGER */
   362,  /* (146) start_opt ::= START WITH NK_STRING */
   362,  /* (147) start_opt ::= START WITH TIMESTAMP NK_STRING */
   363,  /* (148) end_opt ::= */
   363,  /* (149) end_opt ::= END WITH NK_INTEGER */
   363,  /* (150) end_opt ::= END WITH NK_STRING */
   363,  /* (151) end_opt ::= END WITH TIMESTAMP NK_STRING */
   338,  /* (152) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   338,  /* (153) cmd ::= CREATE TABLE multi_create_clause */
   338,  /* (154) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   338,  /* (155) cmd ::= DROP TABLE multi_drop_clause */
   338,  /* (156) cmd ::= DROP STABLE exists_opt full_table_name */
   338,  /* (157) cmd ::= ALTER TABLE alter_table_clause */
   338,  /* (158) cmd ::= ALTER STABLE alter_table_clause */
   377,  /* (159) alter_table_clause ::= full_table_name alter_table_options */
   377,  /* (160) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   377,  /* (161) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   377,  /* (162) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   377,  /* (163) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   377,  /* (164) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   377,  /* (165) alter_table_clause ::= full_table_name DROP TAG column_name */
   377,  /* (166) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   377,  /* (167) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   377,  /* (168) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   374,  /* (169) multi_create_clause ::= create_subtable_clause */
   374,  /* (170) multi_create_clause ::= multi_create_clause create_subtable_clause */
   382,  /* (171) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   376,  /* (172) multi_drop_clause ::= drop_table_clause */
   376,  /* (173) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
   385,  /* (174) drop_table_clause ::= exists_opt full_table_name */
   383,  /* (175) specific_cols_opt ::= */
   383,  /* (176) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   370,  /* (177) full_table_name ::= table_name */
   370,  /* (178) full_table_name ::= db_name NK_DOT table_name */
   371,  /* (179) column_def_list ::= column_def */
   371,  /* (180) column_def_list ::= column_def_list NK_COMMA column_def */
   387,  /* (181) column_def ::= column_name type_name */
   380,  /* (182) type_name ::= BOOL */
   380,  /* (183) type_name ::= TINYINT */
   380,  /* (184) type_name ::= SMALLINT */
   380,  /* (185) type_name ::= INT */
   380,  /* (186) type_name ::= INTEGER */
   380,  /* (187) type_name ::= BIGINT */
   380,  /* (188) type_name ::= FLOAT */
   380,  /* (189) type_name ::= DOUBLE */
   380,  /* (190) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   380,  /* (191) type_name ::= TIMESTAMP */
   380,  /* (192) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   380,  /* (193) type_name ::= TINYINT UNSIGNED */
   380,  /* (194) type_name ::= SMALLINT UNSIGNED */
   380,  /* (195) type_name ::= INT UNSIGNED */
   380,  /* (196) type_name ::= BIGINT UNSIGNED */
   380,  /* (197) type_name ::= JSON */
   380,  /* (198) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   380,  /* (199) type_name ::= MEDIUMBLOB */
   380,  /* (200) type_name ::= BLOB */
   380,  /* (201) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   380,  /* (202) type_name ::= GEOMETRY NK_LP NK_INTEGER NK_RP */
   380,  /* (203) type_name ::= DECIMAL */
   380,  /* (204) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   380,  /* (205) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
   372,  /* (206) tags_def_opt ::= */
   372,  /* (207) tags_def_opt ::= tags_def */
   375,  /* (208) tags_def ::= TAGS NK_LP column_def_list NK_RP */
   373,  /* (209) table_options ::= */
   373,  /* (210) table_options ::= table_options COMMENT NK_STRING */
   373,  /* (211) table_options ::= table_options MAX_DELAY duration_list */
   373,  /* (212) table_options ::= table_options WATERMARK duration_list */
   373,  /* (213) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   373,  /* (214) table_options ::= table_options TTL NK_INTEGER */
   373,  /* (215) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   373,  /* (216) table_options ::= table_options DELETE_MARK duration_list */
   378,  /* (217) alter_table_options ::= alter_table_option */
   378,  /* (218) alter_table_options ::= alter_table_options alter_table_option */
   390,  /* (219) alter_table_option ::= COMMENT NK_STRING */
   390,  /* (220) alter_table_option ::= TTL NK_INTEGER */
   388,  /* (221) duration_list ::= duration_literal */
   388,  /* (222) duration_list ::= duration_list NK_COMMA duration_literal */
   389,  /* (223) rollup_func_list ::= rollup_func_name */
   389,  /* (224) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   392,  /* (225) rollup_func_name ::= function_name */
   392,  /* (226) rollup_func_name ::= FIRST */
   392,  /* (227) rollup_func_name ::= LAST */
   386,  /* (228) col_name_list ::= col_name */
   386,  /* (229) col_name_list ::= col_name_list NK_COMMA col_name */
   394,  /* (230) col_name ::= column_name */
   338,  /* (231) cmd ::= SHOW DNODES */
   338,  /* (232) cmd ::= SHOW USERS */
   338,  /* (233) cmd ::= SHOW USER PRIVILEGES */
   338,  /* (234) cmd ::= SHOW DATABASES */
   338,  /* (235) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   338,  /* (236) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   338,  /* (237) cmd ::= SHOW db_name_cond_opt VGROUPS */
   338,  /* (238) cmd ::= SHOW MNODES */
   338,  /* (239) cmd ::= SHOW QNODES */
   338,  /* (240) cmd ::= SHOW FUNCTIONS */
   338,  /* (241) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   338,  /* (242) cmd ::= SHOW INDEXES FROM db_name NK_DOT table_name */
   338,  /* (243) cmd ::= SHOW STREAMS */
   338,  /* (244) cmd ::= SHOW ACCOUNTS */
   338,  /* (245) cmd ::= SHOW APPS */
   338,  /* (246) cmd ::= SHOW CONNECTIONS */
   338,  /* (247) cmd ::= SHOW LICENCES */
   338,  /* (248) cmd ::= SHOW GRANTS */
   338,  /* (249) cmd ::= SHOW CREATE DATABASE db_name */
   338,  /* (250) cmd ::= SHOW CREATE TABLE full_table_name */
   338,  /* (251) cmd ::= SHOW CREATE STABLE full_table_name */
   338,  /* (252) cmd ::= SHOW QUERIES */
   338,  /* (253) cmd ::= SHOW SCORES */
   338,  /* (254) cmd ::= SHOW TOPICS */
   338,  /* (255) cmd ::= SHOW VARIABLES */
   338,  /* (256) cmd ::= SHOW CLUSTER VARIABLES */
   338,  /* (257) cmd ::= SHOW LOCAL VARIABLES */
   338,  /* (258) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   338,  /* (259) cmd ::= SHOW BNODES */
   338,  /* (260) cmd ::= SHOW SNODES */
   338,  /* (261) cmd ::= SHOW CLUSTER */
   338,  /* (262) cmd ::= SHOW TRANSACTIONS */
   338,  /* (263) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   338,  /* (264) cmd ::= SHOW CONSUMERS */
   338,  /* (265) cmd ::= SHOW SUBSCRIPTIONS */
   338,  /* (266) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   338,  /* (267) cmd ::= SHOW TAGS FROM db_name NK_DOT table_name */
   338,  /* (268) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   338,  /* (269) cmd ::= SHOW TABLE TAGS tag_list_opt FROM db_name NK_DOT table_name */
   338,  /* (270) cmd ::= SHOW VNODES NK_INTEGER */
   338,  /* (271) cmd ::= SHOW VNODES NK_STRING */
   338,  /* (272) cmd ::= SHOW db_name_cond_opt ALIVE */
   338,  /* (273) cmd ::= SHOW CLUSTER ALIVE */
   395,  /* (274) db_name_cond_opt ::= */
   395,  /* (275) db_name_cond_opt ::= db_name NK_DOT */
   396,  /* (276) like_pattern_opt ::= */
   396,  /* (277) like_pattern_opt ::= LIKE NK_STRING */
   397,  /* (278) table_name_cond ::= table_name */
   398,  /* (279) from_db_opt ::= */
   398,  /* (280) from_db_opt ::= FROM db_name */
   399,  /* (281) tag_list_opt ::= */
   399,  /* (282) tag_list_opt ::= tag_item */
   399,  /* (283) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   400,  /* (284) tag_item ::= TBNAME */
   400,  /* (285) tag_item ::= QTAGS */
   400,  /* (286) tag_item ::= column_name */
   400,  /* (287) tag_item ::= column_name column_alias */
   400,  /* (288) tag_item ::= column_name AS column_alias */
   338,  /* (289) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
   338,  /* (290) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
   338,  /* (291) cmd ::= DROP INDEX exists_opt full_index_name */
   402,  /* (292) full_index_name ::= index_name */
   402,  /* (293) full_index_name ::= db_name NK_DOT index_name */
   403,  /* (294) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
   403,  /* (295) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   405,  /* (296) func_list ::= func */
   405,  /* (297) func_list ::= func_list NK_COMMA func */
   408,  /* (298) func ::= sma_func_name NK_LP expression_list NK_RP */
   409,  /* (299) sma_func_name ::= function_name */
   409,  /* (300) sma_func_name ::= COUNT */
   409,  /* (301) sma_func_name ::= FIRST */
   409,  /* (302) sma_func_name ::= LAST */
   409,  /* (303) sma_func_name ::= LAST_ROW */
   407,  /* (304) sma_stream_opt ::= */
   407,  /* (305) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   407,  /* (306) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   407,  /* (307) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   410,  /* (308) with_meta ::= AS */
   410,  /* (309) with_meta ::= WITH META AS */
   410,  /* (310) with_meta ::= ONLY META AS */
   338,  /* (311) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   338,  /* (312) cmd ::= CREATE TOPIC not_exists_opt topic_name with_meta DATABASE db_name */
   338,  /* (313) cmd ::= CREATE TOPIC not_exists_opt topic_name with_meta STABLE full_table_name where_clause_opt */
   338,  /* (314) cmd ::= DROP TOPIC exists_opt topic_name */
   338,  /* (315) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   338,  /* (316) cmd ::= DESC full_table_name */
   338,  /* (317) cmd ::= DESCRIBE full_table_name */
   338,  /* (318) cmd ::= RESET QUERY CACHE */
   338,  /* (319) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   338,  /* (320) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
   414,  /* (321) analyze_opt ::= */
   414,  /* (322) analyze_opt ::= ANALYZE */
   415,  /* (323) explain_options ::= */
   415,  /* (324) explain_options ::= explain_options VERBOSE NK_BOOL */
   415,  /* (325) explain_options ::= explain_options RATIO NK_FLOAT */
   338,  /* (326) cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
   338,  /* (327) cmd ::= DROP FUNCTION exists_opt function_name */
   418,  /* (328) agg_func_opt ::= */
   418,  /* (329) agg_func_opt ::= AGGREGATE */
   419,  /* (330) bufsize_opt ::= */
   419,  /* (331) bufsize_opt ::= BUFSIZE NK_INTEGER */
   420,  /* (332) language_opt ::= */
   420,  /* (333) language_opt ::= LANGUAGE NK_STRING */
   417,  /* (334) or_replace_opt ::= */
   417,  /* (335) or_replace_opt ::= OR REPLACE */
   338,  /* (336) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
   338,  /* (337) cmd ::= DROP STREAM exists_opt stream_name */
   338,  /* (338) cmd ::= PAUSE STREAM exists_opt stream_name */
   338,  /* (339) cmd ::= RESUME STREAM exists_opt ignore_opt stream_name */
   423,  /* (340) col_list_opt ::= */
   423,  /* (341) col_list_opt ::= NK_LP col_name_list NK_RP */
   424,  /* (342) tag_def_or_ref_opt ::= */
   424,  /* (343) tag_def_or_ref_opt ::= tags_def */
   424,  /* (344) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
   422,  /* (345) stream_options ::= */
   422,  /* (346) stream_options ::= stream_options TRIGGER AT_ONCE */
   422,  /* (347) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   422,  /* (348) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   422,  /* (349) stream_options ::= stream_options WATERMARK duration_literal */
   422,  /* (350) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   422,  /* (351) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   422,  /* (352) stream_options ::= stream_options DELETE_MARK duration_literal */
   422,  /* (353) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
   425,  /* (354) subtable_opt ::= */
   425,  /* (355) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
   426,  /* (356) ignore_opt ::= */
   426,  /* (357) ignore_opt ::= IGNORE UNTREATED */
   338,  /* (358) cmd ::= KILL CONNECTION NK_INTEGER */
   338,  /* (359) cmd ::= KILL QUERY NK_STRING */
   338,  /* (360) cmd ::= KILL TRANSACTION NK_INTEGER */
   338,  /* (361) cmd ::= BALANCE VGROUP */
   338,  /* (362) cmd ::= BALANCE VGROUP LEADER */
   338,  /* (363) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   338,  /* (364) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   338,  /* (365) cmd ::= SPLIT VGROUP NK_INTEGER */
   428,  /* (366) dnode_list ::= DNODE NK_INTEGER */
   428,  /* (367) dnode_list ::= dnode_list DNODE NK_INTEGER */
   338,  /* (368) cmd ::= DELETE FROM full_table_name where_clause_opt */
   338,  /* (369) cmd ::= query_or_subquery */
   338,  /* (370) cmd ::= insert_query */
   416,  /* (371) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   416,  /* (372) insert_query ::= INSERT INTO full_table_name query_or_subquery */
   341,  /* (373) literal ::= NK_INTEGER */
   341,  /* (374) literal ::= NK_FLOAT */
   341,  /* (375) literal ::= NK_STRING */
   341,  /* (376) literal ::= NK_BOOL */
   341,  /* (377) literal ::= TIMESTAMP NK_STRING */
   341,  /* (378) literal ::= duration_literal */
   341,  /* (379) literal ::= NULL */
   341,  /* (380) literal ::= NK_QUESTION */
   391,  /* (381) duration_literal ::= NK_VARIABLE */
   367,  /* (382) signed ::= NK_INTEGER */
   367,  /* (383) signed ::= NK_PLUS NK_INTEGER */
   367,  /* (384) signed ::= NK_MINUS NK_INTEGER */
   367,  /* (385) signed ::= NK_FLOAT */
   367,  /* (386) signed ::= NK_PLUS NK_FLOAT */
   367,  /* (387) signed ::= NK_MINUS NK_FLOAT */
   381,  /* (388) signed_literal ::= signed */
   381,  /* (389) signed_literal ::= NK_STRING */
   381,  /* (390) signed_literal ::= NK_BOOL */
   381,  /* (391) signed_literal ::= TIMESTAMP NK_STRING */
   381,  /* (392) signed_literal ::= duration_literal */
   381,  /* (393) signed_literal ::= NULL */
   381,  /* (394) signed_literal ::= literal_func */
   381,  /* (395) signed_literal ::= NK_QUESTION */
   430,  /* (396) literal_list ::= signed_literal */
   430,  /* (397) literal_list ::= literal_list NK_COMMA signed_literal */
   350,  /* (398) db_name ::= NK_ID */
   351,  /* (399) table_name ::= NK_ID */
   379,  /* (400) column_name ::= NK_ID */
   393,  /* (401) function_name ::= NK_ID */
   431,  /* (402) table_alias ::= NK_ID */
   401,  /* (403) column_alias ::= NK_ID */
   343,  /* (404) user_name ::= NK_ID */
   352,  /* (405) topic_name ::= NK_ID */
   421,  /* (406) stream_name ::= NK_ID */
   413,  /* (407) cgroup_name ::= NK_ID */
   404,  /* (408) index_name ::= NK_ID */
   432,  /* (409) expr_or_subquery ::= expression */
   427,  /* (410) expression ::= literal */
   427,  /* (411) expression ::= pseudo_column */
   427,  /* (412) expression ::= column_reference */
   427,  /* (413) expression ::= function_expression */
   427,  /* (414) expression ::= case_when_expression */
   427,  /* (415) expression ::= NK_LP expression NK_RP */
   427,  /* (416) expression ::= NK_PLUS expr_or_subquery */
   427,  /* (417) expression ::= NK_MINUS expr_or_subquery */
   427,  /* (418) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   427,  /* (419) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   427,  /* (420) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   427,  /* (421) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   427,  /* (422) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   427,  /* (423) expression ::= column_reference NK_ARROW NK_STRING */
   427,  /* (424) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   427,  /* (425) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   384,  /* (426) expression_list ::= expr_or_subquery */
   384,  /* (427) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   434,  /* (428) column_reference ::= column_name */
   434,  /* (429) column_reference ::= table_name NK_DOT column_name */
   433,  /* (430) pseudo_column ::= ROWTS */
   433,  /* (431) pseudo_column ::= TBNAME */
   433,  /* (432) pseudo_column ::= table_name NK_DOT TBNAME */
   433,  /* (433) pseudo_column ::= QSTART */
   433,  /* (434) pseudo_column ::= QEND */
   433,  /* (435) pseudo_column ::= QDURATION */
   433,  /* (436) pseudo_column ::= WSTART */
   433,  /* (437) pseudo_column ::= WEND */
   433,  /* (438) pseudo_column ::= WDURATION */
   433,  /* (439) pseudo_column ::= IROWTS */
   433,  /* (440) pseudo_column ::= ISFILLED */
   433,  /* (441) pseudo_column ::= QTAGS */
   435,  /* (442) function_expression ::= function_name NK_LP expression_list NK_RP */
   435,  /* (443) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   435,  /* (444) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   435,  /* (445) function_expression ::= literal_func */
   429,  /* (446) literal_func ::= noarg_func NK_LP NK_RP */
   429,  /* (447) literal_func ::= NOW */
   439,  /* (448) noarg_func ::= NOW */
   439,  /* (449) noarg_func ::= TODAY */
   439,  /* (450) noarg_func ::= TIMEZONE */
   439,  /* (451) noarg_func ::= DATABASE */
   439,  /* (452) noarg_func ::= CLIENT_VERSION */
   439,  /* (453) noarg_func ::= SERVER_VERSION */
   439,  /* (454) noarg_func ::= SERVER_STATUS */
   439,  /* (455) noarg_func ::= CURRENT_USER */
   439,  /* (456) noarg_func ::= USER */
   437,  /* (457) star_func ::= COUNT */
   437,  /* (458) star_func ::= FIRST */
   437,  /* (459) star_func ::= LAST */
   437,  /* (460) star_func ::= LAST_ROW */
   438,  /* (461) star_func_para_list ::= NK_STAR */
   438,  /* (462) star_func_para_list ::= other_para_list */
   440,  /* (463) other_para_list ::= star_func_para */
   440,  /* (464) other_para_list ::= other_para_list NK_COMMA star_func_para */
   441,  /* (465) star_func_para ::= expr_or_subquery */
   441,  /* (466) star_func_para ::= table_name NK_DOT NK_STAR */
   436,  /* (467) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   436,  /* (468) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   442,  /* (469) when_then_list ::= when_then_expr */
   442,  /* (470) when_then_list ::= when_then_list when_then_expr */
   445,  /* (471) when_then_expr ::= WHEN common_expression THEN common_expression */
   443,  /* (472) case_when_else_opt ::= */
   443,  /* (473) case_when_else_opt ::= ELSE common_expression */
   446,  /* (474) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   446,  /* (475) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   446,  /* (476) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   446,  /* (477) predicate ::= expr_or_subquery IS NULL */
   446,  /* (478) predicate ::= expr_or_subquery IS NOT NULL */
   446,  /* (479) predicate ::= expr_or_subquery in_op in_predicate_value */
   447,  /* (480) compare_op ::= NK_LT */
   447,  /* (481) compare_op ::= NK_GT */
   447,  /* (482) compare_op ::= NK_LE */
   447,  /* (483) compare_op ::= NK_GE */
   447,  /* (484) compare_op ::= NK_NE */
   447,  /* (485) compare_op ::= NK_EQ */
   447,  /* (486) compare_op ::= LIKE */
   447,  /* (487) compare_op ::= NOT LIKE */
   447,  /* (488) compare_op ::= MATCH */
   447,  /* (489) compare_op ::= NMATCH */
   447,  /* (490) compare_op ::= CONTAINS */
   448,  /* (491) in_op ::= IN */
   448,  /* (492) in_op ::= NOT IN */
   449,  /* (493) in_predicate_value ::= NK_LP literal_list NK_RP */
   450,  /* (494) boolean_value_expression ::= boolean_primary */
   450,  /* (495) boolean_value_expression ::= NOT boolean_primary */
   450,  /* (496) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   450,  /* (497) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   451,  /* (498) boolean_primary ::= predicate */
   451,  /* (499) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   444,  /* (500) common_expression ::= expr_or_subquery */
   444,  /* (501) common_expression ::= boolean_value_expression */
   452,  /* (502) from_clause_opt ::= */
   452,  /* (503) from_clause_opt ::= FROM table_reference_list */
   453,  /* (504) table_reference_list ::= table_reference */
   453,  /* (505) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   454,  /* (506) table_reference ::= table_primary */
   454,  /* (507) table_reference ::= joined_table */
   455,  /* (508) table_primary ::= table_name alias_opt */
   455,  /* (509) table_primary ::= db_name NK_DOT table_name alias_opt */
   455,  /* (510) table_primary ::= subquery alias_opt */
   455,  /* (511) table_primary ::= parenthesized_joined_table */
   457,  /* (512) alias_opt ::= */
   457,  /* (513) alias_opt ::= table_alias */
   457,  /* (514) alias_opt ::= AS table_alias */
   459,  /* (515) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   459,  /* (516) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   456,  /* (517) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
   460,  /* (518) join_type ::= */
   460,  /* (519) join_type ::= INNER */
   461,  /* (520) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
   462,  /* (521) set_quantifier_opt ::= */
   462,  /* (522) set_quantifier_opt ::= DISTINCT */
   462,  /* (523) set_quantifier_opt ::= ALL */
   463,  /* (524) select_list ::= select_item */
   463,  /* (525) select_list ::= select_list NK_COMMA select_item */
   471,  /* (526) select_item ::= NK_STAR */
   471,  /* (527) select_item ::= common_expression */
   471,  /* (528) select_item ::= common_expression column_alias */
   471,  /* (529) select_item ::= common_expression AS column_alias */
   471,  /* (530) select_item ::= table_name NK_DOT NK_STAR */
   412,  /* (531) where_clause_opt ::= */
   412,  /* (532) where_clause_opt ::= WHERE search_condition */
   464,  /* (533) partition_by_clause_opt ::= */
   464,  /* (534) partition_by_clause_opt ::= PARTITION BY partition_list */
   472,  /* (535) partition_list ::= partition_item */
   472,  /* (536) partition_list ::= partition_list NK_COMMA partition_item */
   473,  /* (537) partition_item ::= expr_or_subquery */
   473,  /* (538) partition_item ::= expr_or_subquery column_alias */
   473,  /* (539) partition_item ::= expr_or_subquery AS column_alias */
   468,  /* (540) twindow_clause_opt ::= */
   468,  /* (541) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   468,  /* (542) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   468,  /* (543) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   468,  /* (544) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   468,  /* (545) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
   406,  /* (546) sliding_opt ::= */
   406,  /* (547) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
   467,  /* (548) fill_opt ::= */
   467,  /* (549) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   467,  /* (550) fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
   467,  /* (551) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
   474,  /* (552) fill_mode ::= NONE */
   474,  /* (553) fill_mode ::= PREV */
   474,  /* (554) fill_mode ::= NULL */
   474,  /* (555) fill_mode ::= NULL_F */
   474,  /* (556) fill_mode ::= LINEAR */
   474,  /* (557) fill_mode ::= NEXT */
   469,  /* (558) group_by_clause_opt ::= */
   469,  /* (559) group_by_clause_opt ::= GROUP BY group_by_list */
   475,  /* (560) group_by_list ::= expr_or_subquery */
   475,  /* (561) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
   470,  /* (562) having_clause_opt ::= */
   470,  /* (563) having_clause_opt ::= HAVING search_condition */
   465,  /* (564) range_opt ::= */
   465,  /* (565) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
   465,  /* (566) range_opt ::= RANGE NK_LP expr_or_subquery NK_RP */
   466,  /* (567) every_opt ::= */
   466,  /* (568) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   476,  /* (569) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   477,  /* (570) query_simple ::= query_specification */
   477,  /* (571) query_simple ::= union_query_expression */
   481,  /* (572) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   481,  /* (573) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   482,  /* (574) query_simple_or_subquery ::= query_simple */
   482,  /* (575) query_simple_or_subquery ::= subquery */
   411,  /* (576) query_or_subquery ::= query_expression */
   411,  /* (577) query_or_subquery ::= subquery */
   478,  /* (578) order_by_clause_opt ::= */
   478,  /* (579) order_by_clause_opt ::= ORDER BY sort_specification_list */
   479,  /* (580) slimit_clause_opt ::= */
   479,  /* (581) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   479,  /* (582) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   479,  /* (583) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   480,  /* (584) limit_clause_opt ::= */
   480,  /* (585) limit_clause_opt ::= LIMIT NK_INTEGER */
   480,  /* (586) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   480,  /* (587) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   458,  /* (588) subquery ::= NK_LP query_expression NK_RP */
   458,  /* (589) subquery ::= NK_LP subquery NK_RP */
   353,  /* (590) search_condition ::= common_expression */
   483,  /* (591) sort_specification_list ::= sort_specification */
   483,  /* (592) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   484,  /* (593) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
   485,  /* (594) ordering_specification_opt ::= */
   485,  /* (595) ordering_specification_opt ::= ASC */
   485,  /* (596) ordering_specification_opt ::= DESC */
   486,  /* (597) null_ordering_opt ::= */
   486,  /* (598) null_ordering_opt ::= NULLS FIRST */
   486,  /* (599) null_ordering_opt ::= NULLS LAST */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -6,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   -4,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
    0,  /* (2) account_options ::= */
   -3,  /* (3) account_options ::= account_options PPS literal */
   -3,  /* (4) account_options ::= account_options TSERIES literal */
   -3,  /* (5) account_options ::= account_options STORAGE literal */
   -3,  /* (6) account_options ::= account_options STREAMS literal */
   -3,  /* (7) account_options ::= account_options QTIME literal */
   -3,  /* (8) account_options ::= account_options DBS literal */
   -3,  /* (9) account_options ::= account_options USERS literal */
   -3,  /* (10) account_options ::= account_options CONNS literal */
   -3,  /* (11) account_options ::= account_options STATE literal */
   -1,  /* (12) alter_account_options ::= alter_account_option */
   -2,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   -2,  /* (14) alter_account_option ::= PASS literal */
   -2,  /* (15) alter_account_option ::= PPS literal */
   -2,  /* (16) alter_account_option ::= TSERIES literal */
   -2,  /* (17) alter_account_option ::= STORAGE literal */
   -2,  /* (18) alter_account_option ::= STREAMS literal */
   -2,  /* (19) alter_account_option ::= QTIME literal */
   -2,  /* (20) alter_account_option ::= DBS literal */
   -2,  /* (21) alter_account_option ::= USERS literal */
   -2,  /* (22) alter_account_option ::= CONNS literal */
   -2,  /* (23) alter_account_option ::= STATE literal */
   -6,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
   -5,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   -5,  /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
   -5,  /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
   -3,  /* (28) cmd ::= DROP USER user_name */
    0,  /* (29) sysinfo_opt ::= */
   -2,  /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
   -7,  /* (31) cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
   -7,  /* (32) cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
   -1,  /* (33) privileges ::= ALL */
   -1,  /* (34) privileges ::= priv_type_list */
   -1,  /* (35) privileges ::= SUBSCRIBE */
   -1,  /* (36) priv_type_list ::= priv_type */
   -3,  /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
   -1,  /* (38) priv_type ::= READ */
   -1,  /* (39) priv_type ::= WRITE */
   -3,  /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
   -3,  /* (41) priv_level ::= db_name NK_DOT NK_STAR */
   -3,  /* (42) priv_level ::= db_name NK_DOT table_name */
   -1,  /* (43) priv_level ::= topic_name */
    0,  /* (44) with_opt ::= */
   -2,  /* (45) with_opt ::= WITH search_condition */
   -3,  /* (46) cmd ::= CREATE DNODE dnode_endpoint */
   -5,  /* (47) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
   -4,  /* (48) cmd ::= DROP DNODE NK_INTEGER force_opt */
   -4,  /* (49) cmd ::= DROP DNODE dnode_endpoint force_opt */
   -4,  /* (50) cmd ::= DROP DNODE NK_INTEGER unsafe_opt */
   -4,  /* (51) cmd ::= DROP DNODE dnode_endpoint unsafe_opt */
   -4,  /* (52) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   -5,  /* (53) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   -4,  /* (54) cmd ::= ALTER ALL DNODES NK_STRING */
   -5,  /* (55) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   -3,  /* (56) cmd ::= RESTORE DNODE NK_INTEGER */
   -1,  /* (57) dnode_endpoint ::= NK_STRING */
   -1,  /* (58) dnode_endpoint ::= NK_ID */
   -1,  /* (59) dnode_endpoint ::= NK_IPTOKEN */
    0,  /* (60) force_opt ::= */
   -1,  /* (61) force_opt ::= FORCE */
   -1,  /* (62) unsafe_opt ::= UNSAFE */
   -3,  /* (63) cmd ::= ALTER LOCAL NK_STRING */
   -4,  /* (64) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   -5,  /* (65) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   -5,  /* (66) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   -5,  /* (67) cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
   -5,  /* (68) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   -5,  /* (69) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   -5,  /* (70) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   -5,  /* (71) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   -5,  /* (72) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   -5,  /* (73) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   -5,  /* (74) cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
   -5,  /* (75) cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
   -5,  /* (76) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   -4,  /* (77) cmd ::= DROP DATABASE exists_opt db_name */
   -2,  /* (78) cmd ::= USE db_name */
   -4,  /* (79) cmd ::= ALTER DATABASE db_name alter_db_options */
   -3,  /* (80) cmd ::= FLUSH DATABASE db_name */
   -4,  /* (81) cmd ::= TRIM DATABASE db_name speed_opt */
   -5,  /* (82) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
   -3,  /* (83) not_exists_opt ::= IF NOT EXISTS */
    0,  /* (84) not_exists_opt ::= */
   -2,  /* (85) exists_opt ::= IF EXISTS */
    0,  /* (86) exists_opt ::= */
    0,  /* (87) db_options ::= */
   -3,  /* (88) db_options ::= db_options BUFFER NK_INTEGER */
   -3,  /* (89) db_options ::= db_options CACHEMODEL NK_STRING */
   -3,  /* (90) db_options ::= db_options CACHESIZE NK_INTEGER */
   -3,  /* (91) db_options ::= db_options COMP NK_INTEGER */
   -3,  /* (92) db_options ::= db_options DURATION NK_INTEGER */
   -3,  /* (93) db_options ::= db_options DURATION NK_VARIABLE */
   -3,  /* (94) db_options ::= db_options MAXROWS NK_INTEGER */
   -3,  /* (95) db_options ::= db_options MINROWS NK_INTEGER */
   -3,  /* (96) db_options ::= db_options KEEP integer_list */
   -3,  /* (97) db_options ::= db_options KEEP variable_list */
   -3,  /* (98) db_options ::= db_options PAGES NK_INTEGER */
   -3,  /* (99) db_options ::= db_options PAGESIZE NK_INTEGER */
   -3,  /* (100) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
   -3,  /* (101) db_options ::= db_options PRECISION NK_STRING */
   -3,  /* (102) db_options ::= db_options REPLICA NK_INTEGER */
   -3,  /* (103) db_options ::= db_options VGROUPS NK_INTEGER */
   -3,  /* (104) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   -3,  /* (105) db_options ::= db_options RETENTIONS retention_list */
   -3,  /* (106) db_options ::= db_options SCHEMALESS NK_INTEGER */
   -3,  /* (107) db_options ::= db_options WAL_LEVEL NK_INTEGER */
   -3,  /* (108) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
   -3,  /* (109) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
   -4,  /* (110) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -3,  /* (111) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
   -4,  /* (112) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -3,  /* (113) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
   -3,  /* (114) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
   -3,  /* (115) db_options ::= db_options STT_TRIGGER NK_INTEGER */
   -3,  /* (116) db_options ::= db_options TABLE_PREFIX signed */
   -3,  /* (117) db_options ::= db_options TABLE_SUFFIX signed */
   -1,  /* (118) alter_db_options ::= alter_db_option */
   -2,  /* (119) alter_db_options ::= alter_db_options alter_db_option */
   -2,  /* (120) alter_db_option ::= BUFFER NK_INTEGER */
   -2,  /* (121) alter_db_option ::= CACHEMODEL NK_STRING */
   -2,  /* (122) alter_db_option ::= CACHESIZE NK_INTEGER */
   -2,  /* (123) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
   -2,  /* (124) alter_db_option ::= KEEP integer_list */
   -2,  /* (125) alter_db_option ::= KEEP variable_list */
   -2,  /* (126) alter_db_option ::= PAGES NK_INTEGER */
   -2,  /* (127) alter_db_option ::= REPLICA NK_INTEGER */
   -2,  /* (128) alter_db_option ::= WAL_LEVEL NK_INTEGER */
   -2,  /* (129) alter_db_option ::= STT_TRIGGER NK_INTEGER */
   -2,  /* (130) alter_db_option ::= MINROWS NK_INTEGER */
   -2,  /* (131) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
   -3,  /* (132) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
   -2,  /* (133) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
   -3,  /* (134) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
   -1,  /* (135) integer_list ::= NK_INTEGER */
   -3,  /* (136) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   -1,  /* (137) variable_list ::= NK_VARIABLE */
   -3,  /* (138) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   -1,  /* (139) retention_list ::= retention */
   -3,  /* (140) retention_list ::= retention_list NK_COMMA retention */
   -3,  /* (141) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
    0,  /* (142) speed_opt ::= */
   -2,  /* (143) speed_opt ::= MAX_SPEED NK_INTEGER */
    0,  /* (144) start_opt ::= */
   -3,  /* (145) start_opt ::= START WITH NK_INTEGER */
   -3,  /* (146) start_opt ::= START WITH NK_STRING */
   -4,  /* (147) start_opt ::= START WITH TIMESTAMP NK_STRING */
    0,  /* (148) end_opt ::= */
   -3,  /* (149) end_opt ::= END WITH NK_INTEGER */
   -3,  /* (150) end_opt ::= END WITH NK_STRING */
   -4,  /* (151) end_opt ::= END WITH TIMESTAMP NK_STRING */
   -9,  /* (152) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   -3,  /* (153) cmd ::= CREATE TABLE multi_create_clause */
   -9,  /* (154) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   -3,  /* (155) cmd ::= DROP TABLE multi_drop_clause */
   -4,  /* (156) cmd ::= DROP STABLE exists_opt full_table_name */
   -3,  /* (157) cmd ::= ALTER TABLE alter_table_clause */
   -3,  /* (158) cmd ::= ALTER STABLE alter_table_clause */
   -2,  /* (159) alter_table_clause ::= full_table_name alter_table_options */
   -5,  /* (160) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   -4,  /* (161) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   -5,  /* (162) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   -5,  /* (163) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   -5,  /* (164) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   -4,  /* (165) alter_table_clause ::= full_table_name DROP TAG column_name */
   -5,  /* (166) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   -5,  /* (167) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   -6,  /* (168) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
   -1,  /* (169) multi_create_clause ::= create_subtable_clause */
   -2,  /* (170) multi_create_clause ::= multi_create_clause create_subtable_clause */
  -10,  /* (171) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
   -1,  /* (172) multi_drop_clause ::= drop_table_clause */
   -3,  /* (173) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
   -2,  /* (174) drop_table_clause ::= exists_opt full_table_name */
    0,  /* (175) specific_cols_opt ::= */
   -3,  /* (176) specific_cols_opt ::= NK_LP col_name_list NK_RP */
   -1,  /* (177) full_table_name ::= table_name */
   -3,  /* (178) full_table_name ::= db_name NK_DOT table_name */
   -1,  /* (179) column_def_list ::= column_def */
   -3,  /* (180) column_def_list ::= column_def_list NK_COMMA column_def */
   -2,  /* (181) column_def ::= column_name type_name */
   -1,  /* (182) type_name ::= BOOL */
   -1,  /* (183) type_name ::= TINYINT */
   -1,  /* (184) type_name ::= SMALLINT */
   -1,  /* (185) type_name ::= INT */
   -1,  /* (186) type_name ::= INTEGER */
   -1,  /* (187) type_name ::= BIGINT */
   -1,  /* (188) type_name ::= FLOAT */
   -1,  /* (189) type_name ::= DOUBLE */
   -4,  /* (190) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (191) type_name ::= TIMESTAMP */
   -4,  /* (192) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   -2,  /* (193) type_name ::= TINYINT UNSIGNED */
   -2,  /* (194) type_name ::= SMALLINT UNSIGNED */
   -2,  /* (195) type_name ::= INT UNSIGNED */
   -2,  /* (196) type_name ::= BIGINT UNSIGNED */
   -1,  /* (197) type_name ::= JSON */
   -4,  /* (198) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   -1,  /* (199) type_name ::= MEDIUMBLOB */
   -1,  /* (200) type_name ::= BLOB */
   -4,  /* (201) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   -4,  /* (202) type_name ::= GEOMETRY NK_LP NK_INTEGER NK_RP */
   -1,  /* (203) type_name ::= DECIMAL */
   -4,  /* (204) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   -6,  /* (205) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
    0,  /* (206) tags_def_opt ::= */
   -1,  /* (207) tags_def_opt ::= tags_def */
   -4,  /* (208) tags_def ::= TAGS NK_LP column_def_list NK_RP */
    0,  /* (209) table_options ::= */
   -3,  /* (210) table_options ::= table_options COMMENT NK_STRING */
   -3,  /* (211) table_options ::= table_options MAX_DELAY duration_list */
   -3,  /* (212) table_options ::= table_options WATERMARK duration_list */
   -5,  /* (213) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
   -3,  /* (214) table_options ::= table_options TTL NK_INTEGER */
   -5,  /* (215) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   -3,  /* (216) table_options ::= table_options DELETE_MARK duration_list */
   -1,  /* (217) alter_table_options ::= alter_table_option */
   -2,  /* (218) alter_table_options ::= alter_table_options alter_table_option */
   -2,  /* (219) alter_table_option ::= COMMENT NK_STRING */
   -2,  /* (220) alter_table_option ::= TTL NK_INTEGER */
   -1,  /* (221) duration_list ::= duration_literal */
   -3,  /* (222) duration_list ::= duration_list NK_COMMA duration_literal */
   -1,  /* (223) rollup_func_list ::= rollup_func_name */
   -3,  /* (224) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
   -1,  /* (225) rollup_func_name ::= function_name */
   -1,  /* (226) rollup_func_name ::= FIRST */
   -1,  /* (227) rollup_func_name ::= LAST */
   -1,  /* (228) col_name_list ::= col_name */
   -3,  /* (229) col_name_list ::= col_name_list NK_COMMA col_name */
   -1,  /* (230) col_name ::= column_name */
   -2,  /* (231) cmd ::= SHOW DNODES */
   -2,  /* (232) cmd ::= SHOW USERS */
   -3,  /* (233) cmd ::= SHOW USER PRIVILEGES */
   -2,  /* (234) cmd ::= SHOW DATABASES */
   -4,  /* (235) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   -4,  /* (236) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   -3,  /* (237) cmd ::= SHOW db_name_cond_opt VGROUPS */
   -2,  /* (238) cmd ::= SHOW MNODES */
   -2,  /* (239) cmd ::= SHOW QNODES */
   -2,  /* (240) cmd ::= SHOW FUNCTIONS */
   -5,  /* (241) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   -6,  /* (242) cmd ::= SHOW INDEXES FROM db_name NK_DOT table_name */
   -2,  /* (243) cmd ::= SHOW STREAMS */
   -2,  /* (244) cmd ::= SHOW ACCOUNTS */
   -2,  /* (245) cmd ::= SHOW APPS */
   -2,  /* (246) cmd ::= SHOW CONNECTIONS */
   -2,  /* (247) cmd ::= SHOW LICENCES */
   -2,  /* (248) cmd ::= SHOW GRANTS */
   -4,  /* (249) cmd ::= SHOW CREATE DATABASE db_name */
   -4,  /* (250) cmd ::= SHOW CREATE TABLE full_table_name */
   -4,  /* (251) cmd ::= SHOW CREATE STABLE full_table_name */
   -2,  /* (252) cmd ::= SHOW QUERIES */
   -2,  /* (253) cmd ::= SHOW SCORES */
   -2,  /* (254) cmd ::= SHOW TOPICS */
   -2,  /* (255) cmd ::= SHOW VARIABLES */
   -3,  /* (256) cmd ::= SHOW CLUSTER VARIABLES */
   -3,  /* (257) cmd ::= SHOW LOCAL VARIABLES */
   -5,  /* (258) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
   -2,  /* (259) cmd ::= SHOW BNODES */
   -2,  /* (260) cmd ::= SHOW SNODES */
   -2,  /* (261) cmd ::= SHOW CLUSTER */
   -2,  /* (262) cmd ::= SHOW TRANSACTIONS */
   -4,  /* (263) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
   -2,  /* (264) cmd ::= SHOW CONSUMERS */
   -2,  /* (265) cmd ::= SHOW SUBSCRIPTIONS */
   -5,  /* (266) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
   -6,  /* (267) cmd ::= SHOW TAGS FROM db_name NK_DOT table_name */
   -7,  /* (268) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
   -8,  /* (269) cmd ::= SHOW TABLE TAGS tag_list_opt FROM db_name NK_DOT table_name */
   -3,  /* (270) cmd ::= SHOW VNODES NK_INTEGER */
   -3,  /* (271) cmd ::= SHOW VNODES NK_STRING */
   -3,  /* (272) cmd ::= SHOW db_name_cond_opt ALIVE */
   -3,  /* (273) cmd ::= SHOW CLUSTER ALIVE */
    0,  /* (274) db_name_cond_opt ::= */
   -2,  /* (275) db_name_cond_opt ::= db_name NK_DOT */
    0,  /* (276) like_pattern_opt ::= */
   -2,  /* (277) like_pattern_opt ::= LIKE NK_STRING */
   -1,  /* (278) table_name_cond ::= table_name */
    0,  /* (279) from_db_opt ::= */
   -2,  /* (280) from_db_opt ::= FROM db_name */
    0,  /* (281) tag_list_opt ::= */
   -1,  /* (282) tag_list_opt ::= tag_item */
   -3,  /* (283) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
   -1,  /* (284) tag_item ::= TBNAME */
   -1,  /* (285) tag_item ::= QTAGS */
   -1,  /* (286) tag_item ::= column_name */
   -2,  /* (287) tag_item ::= column_name column_alias */
   -3,  /* (288) tag_item ::= column_name AS column_alias */
   -8,  /* (289) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
   -9,  /* (290) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
   -4,  /* (291) cmd ::= DROP INDEX exists_opt full_index_name */
   -1,  /* (292) full_index_name ::= index_name */
   -3,  /* (293) full_index_name ::= db_name NK_DOT index_name */
  -10,  /* (294) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  -12,  /* (295) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
   -1,  /* (296) func_list ::= func */
   -3,  /* (297) func_list ::= func_list NK_COMMA func */
   -4,  /* (298) func ::= sma_func_name NK_LP expression_list NK_RP */
   -1,  /* (299) sma_func_name ::= function_name */
   -1,  /* (300) sma_func_name ::= COUNT */
   -1,  /* (301) sma_func_name ::= FIRST */
   -1,  /* (302) sma_func_name ::= LAST */
   -1,  /* (303) sma_func_name ::= LAST_ROW */
    0,  /* (304) sma_stream_opt ::= */
   -3,  /* (305) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
   -3,  /* (306) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
   -3,  /* (307) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
   -1,  /* (308) with_meta ::= AS */
   -3,  /* (309) with_meta ::= WITH META AS */
   -3,  /* (310) with_meta ::= ONLY META AS */
   -6,  /* (311) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
   -7,  /* (312) cmd ::= CREATE TOPIC not_exists_opt topic_name with_meta DATABASE db_name */
   -8,  /* (313) cmd ::= CREATE TOPIC not_exists_opt topic_name with_meta STABLE full_table_name where_clause_opt */
   -4,  /* (314) cmd ::= DROP TOPIC exists_opt topic_name */
   -7,  /* (315) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
   -2,  /* (316) cmd ::= DESC full_table_name */
   -2,  /* (317) cmd ::= DESCRIBE full_table_name */
   -3,  /* (318) cmd ::= RESET QUERY CACHE */
   -4,  /* (319) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
   -4,  /* (320) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
    0,  /* (321) analyze_opt ::= */
   -1,  /* (322) analyze_opt ::= ANALYZE */
    0,  /* (323) explain_options ::= */
   -3,  /* (324) explain_options ::= explain_options VERBOSE NK_BOOL */
   -3,  /* (325) explain_options ::= explain_options RATIO NK_FLOAT */
  -12,  /* (326) cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
   -4,  /* (327) cmd ::= DROP FUNCTION exists_opt function_name */
    0,  /* (328) agg_func_opt ::= */
   -1,  /* (329) agg_func_opt ::= AGGREGATE */
    0,  /* (330) bufsize_opt ::= */
   -2,  /* (331) bufsize_opt ::= BUFSIZE NK_INTEGER */
    0,  /* (332) language_opt ::= */
   -2,  /* (333) language_opt ::= LANGUAGE NK_STRING */
    0,  /* (334) or_replace_opt ::= */
   -2,  /* (335) or_replace_opt ::= OR REPLACE */
  -12,  /* (336) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
   -4,  /* (337) cmd ::= DROP STREAM exists_opt stream_name */
   -4,  /* (338) cmd ::= PAUSE STREAM exists_opt stream_name */
   -5,  /* (339) cmd ::= RESUME STREAM exists_opt ignore_opt stream_name */
    0,  /* (340) col_list_opt ::= */
   -3,  /* (341) col_list_opt ::= NK_LP col_name_list NK_RP */
    0,  /* (342) tag_def_or_ref_opt ::= */
   -1,  /* (343) tag_def_or_ref_opt ::= tags_def */
   -4,  /* (344) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
    0,  /* (345) stream_options ::= */
   -3,  /* (346) stream_options ::= stream_options TRIGGER AT_ONCE */
   -3,  /* (347) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
   -4,  /* (348) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
   -3,  /* (349) stream_options ::= stream_options WATERMARK duration_literal */
   -4,  /* (350) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
   -3,  /* (351) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
   -3,  /* (352) stream_options ::= stream_options DELETE_MARK duration_literal */
   -4,  /* (353) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
    0,  /* (354) subtable_opt ::= */
   -4,  /* (355) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
    0,  /* (356) ignore_opt ::= */
   -2,  /* (357) ignore_opt ::= IGNORE UNTREATED */
   -3,  /* (358) cmd ::= KILL CONNECTION NK_INTEGER */
   -3,  /* (359) cmd ::= KILL QUERY NK_STRING */
   -3,  /* (360) cmd ::= KILL TRANSACTION NK_INTEGER */
   -2,  /* (361) cmd ::= BALANCE VGROUP */
   -3,  /* (362) cmd ::= BALANCE VGROUP LEADER */
   -4,  /* (363) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   -4,  /* (364) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   -3,  /* (365) cmd ::= SPLIT VGROUP NK_INTEGER */
   -2,  /* (366) dnode_list ::= DNODE NK_INTEGER */
   -3,  /* (367) dnode_list ::= dnode_list DNODE NK_INTEGER */
   -4,  /* (368) cmd ::= DELETE FROM full_table_name where_clause_opt */
   -1,  /* (369) cmd ::= query_or_subquery */
   -1,  /* (370) cmd ::= insert_query */
   -7,  /* (371) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
   -4,  /* (372) insert_query ::= INSERT INTO full_table_name query_or_subquery */
   -1,  /* (373) literal ::= NK_INTEGER */
   -1,  /* (374) literal ::= NK_FLOAT */
   -1,  /* (375) literal ::= NK_STRING */
   -1,  /* (376) literal ::= NK_BOOL */
   -2,  /* (377) literal ::= TIMESTAMP NK_STRING */
   -1,  /* (378) literal ::= duration_literal */
   -1,  /* (379) literal ::= NULL */
   -1,  /* (380) literal ::= NK_QUESTION */
   -1,  /* (381) duration_literal ::= NK_VARIABLE */
   -1,  /* (382) signed ::= NK_INTEGER */
   -2,  /* (383) signed ::= NK_PLUS NK_INTEGER */
   -2,  /* (384) signed ::= NK_MINUS NK_INTEGER */
   -1,  /* (385) signed ::= NK_FLOAT */
   -2,  /* (386) signed ::= NK_PLUS NK_FLOAT */
   -2,  /* (387) signed ::= NK_MINUS NK_FLOAT */
   -1,  /* (388) signed_literal ::= signed */
   -1,  /* (389) signed_literal ::= NK_STRING */
   -1,  /* (390) signed_literal ::= NK_BOOL */
   -2,  /* (391) signed_literal ::= TIMESTAMP NK_STRING */
   -1,  /* (392) signed_literal ::= duration_literal */
   -1,  /* (393) signed_literal ::= NULL */
   -1,  /* (394) signed_literal ::= literal_func */
   -1,  /* (395) signed_literal ::= NK_QUESTION */
   -1,  /* (396) literal_list ::= signed_literal */
   -3,  /* (397) literal_list ::= literal_list NK_COMMA signed_literal */
   -1,  /* (398) db_name ::= NK_ID */
   -1,  /* (399) table_name ::= NK_ID */
   -1,  /* (400) column_name ::= NK_ID */
   -1,  /* (401) function_name ::= NK_ID */
   -1,  /* (402) table_alias ::= NK_ID */
   -1,  /* (403) column_alias ::= NK_ID */
   -1,  /* (404) user_name ::= NK_ID */
   -1,  /* (405) topic_name ::= NK_ID */
   -1,  /* (406) stream_name ::= NK_ID */
   -1,  /* (407) cgroup_name ::= NK_ID */
   -1,  /* (408) index_name ::= NK_ID */
   -1,  /* (409) expr_or_subquery ::= expression */
   -1,  /* (410) expression ::= literal */
   -1,  /* (411) expression ::= pseudo_column */
   -1,  /* (412) expression ::= column_reference */
   -1,  /* (413) expression ::= function_expression */
   -1,  /* (414) expression ::= case_when_expression */
   -3,  /* (415) expression ::= NK_LP expression NK_RP */
   -2,  /* (416) expression ::= NK_PLUS expr_or_subquery */
   -2,  /* (417) expression ::= NK_MINUS expr_or_subquery */
   -3,  /* (418) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
   -3,  /* (419) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
   -3,  /* (420) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
   -3,  /* (421) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
   -3,  /* (422) expression ::= expr_or_subquery NK_REM expr_or_subquery */
   -3,  /* (423) expression ::= column_reference NK_ARROW NK_STRING */
   -3,  /* (424) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
   -3,  /* (425) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
   -1,  /* (426) expression_list ::= expr_or_subquery */
   -3,  /* (427) expression_list ::= expression_list NK_COMMA expr_or_subquery */
   -1,  /* (428) column_reference ::= column_name */
   -3,  /* (429) column_reference ::= table_name NK_DOT column_name */
   -1,  /* (430) pseudo_column ::= ROWTS */
   -1,  /* (431) pseudo_column ::= TBNAME */
   -3,  /* (432) pseudo_column ::= table_name NK_DOT TBNAME */
   -1,  /* (433) pseudo_column ::= QSTART */
   -1,  /* (434) pseudo_column ::= QEND */
   -1,  /* (435) pseudo_column ::= QDURATION */
   -1,  /* (436) pseudo_column ::= WSTART */
   -1,  /* (437) pseudo_column ::= WEND */
   -1,  /* (438) pseudo_column ::= WDURATION */
   -1,  /* (439) pseudo_column ::= IROWTS */
   -1,  /* (440) pseudo_column ::= ISFILLED */
   -1,  /* (441) pseudo_column ::= QTAGS */
   -4,  /* (442) function_expression ::= function_name NK_LP expression_list NK_RP */
   -4,  /* (443) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
   -6,  /* (444) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
   -1,  /* (445) function_expression ::= literal_func */
   -3,  /* (446) literal_func ::= noarg_func NK_LP NK_RP */
   -1,  /* (447) literal_func ::= NOW */
   -1,  /* (448) noarg_func ::= NOW */
   -1,  /* (449) noarg_func ::= TODAY */
   -1,  /* (450) noarg_func ::= TIMEZONE */
   -1,  /* (451) noarg_func ::= DATABASE */
   -1,  /* (452) noarg_func ::= CLIENT_VERSION */
   -1,  /* (453) noarg_func ::= SERVER_VERSION */
   -1,  /* (454) noarg_func ::= SERVER_STATUS */
   -1,  /* (455) noarg_func ::= CURRENT_USER */
   -1,  /* (456) noarg_func ::= USER */
   -1,  /* (457) star_func ::= COUNT */
   -1,  /* (458) star_func ::= FIRST */
   -1,  /* (459) star_func ::= LAST */
   -1,  /* (460) star_func ::= LAST_ROW */
   -1,  /* (461) star_func_para_list ::= NK_STAR */
   -1,  /* (462) star_func_para_list ::= other_para_list */
   -1,  /* (463) other_para_list ::= star_func_para */
   -3,  /* (464) other_para_list ::= other_para_list NK_COMMA star_func_para */
   -1,  /* (465) star_func_para ::= expr_or_subquery */
   -3,  /* (466) star_func_para ::= table_name NK_DOT NK_STAR */
   -4,  /* (467) case_when_expression ::= CASE when_then_list case_when_else_opt END */
   -5,  /* (468) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
   -1,  /* (469) when_then_list ::= when_then_expr */
   -2,  /* (470) when_then_list ::= when_then_list when_then_expr */
   -4,  /* (471) when_then_expr ::= WHEN common_expression THEN common_expression */
    0,  /* (472) case_when_else_opt ::= */
   -2,  /* (473) case_when_else_opt ::= ELSE common_expression */
   -3,  /* (474) predicate ::= expr_or_subquery compare_op expr_or_subquery */
   -5,  /* (475) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
   -6,  /* (476) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
   -3,  /* (477) predicate ::= expr_or_subquery IS NULL */
   -4,  /* (478) predicate ::= expr_or_subquery IS NOT NULL */
   -3,  /* (479) predicate ::= expr_or_subquery in_op in_predicate_value */
   -1,  /* (480) compare_op ::= NK_LT */
   -1,  /* (481) compare_op ::= NK_GT */
   -1,  /* (482) compare_op ::= NK_LE */
   -1,  /* (483) compare_op ::= NK_GE */
   -1,  /* (484) compare_op ::= NK_NE */
   -1,  /* (485) compare_op ::= NK_EQ */
   -1,  /* (486) compare_op ::= LIKE */
   -2,  /* (487) compare_op ::= NOT LIKE */
   -1,  /* (488) compare_op ::= MATCH */
   -1,  /* (489) compare_op ::= NMATCH */
   -1,  /* (490) compare_op ::= CONTAINS */
   -1,  /* (491) in_op ::= IN */
   -2,  /* (492) in_op ::= NOT IN */
   -3,  /* (493) in_predicate_value ::= NK_LP literal_list NK_RP */
   -1,  /* (494) boolean_value_expression ::= boolean_primary */
   -2,  /* (495) boolean_value_expression ::= NOT boolean_primary */
   -3,  /* (496) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   -3,  /* (497) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   -1,  /* (498) boolean_primary ::= predicate */
   -3,  /* (499) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   -1,  /* (500) common_expression ::= expr_or_subquery */
   -1,  /* (501) common_expression ::= boolean_value_expression */
    0,  /* (502) from_clause_opt ::= */
   -2,  /* (503) from_clause_opt ::= FROM table_reference_list */
   -1,  /* (504) table_reference_list ::= table_reference */
   -3,  /* (505) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   -1,  /* (506) table_reference ::= table_primary */
   -1,  /* (507) table_reference ::= joined_table */
   -2,  /* (508) table_primary ::= table_name alias_opt */
   -4,  /* (509) table_primary ::= db_name NK_DOT table_name alias_opt */
   -2,  /* (510) table_primary ::= subquery alias_opt */
   -1,  /* (511) table_primary ::= parenthesized_joined_table */
    0,  /* (512) alias_opt ::= */
   -1,  /* (513) alias_opt ::= table_alias */
   -2,  /* (514) alias_opt ::= AS table_alias */
   -3,  /* (515) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   -3,  /* (516) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   -6,  /* (517) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
    0,  /* (518) join_type ::= */
   -1,  /* (519) join_type ::= INNER */
  -12,  /* (520) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
    0,  /* (521) set_quantifier_opt ::= */
   -1,  /* (522) set_quantifier_opt ::= DISTINCT */
   -1,  /* (523) set_quantifier_opt ::= ALL */
   -1,  /* (524) select_list ::= select_item */
   -3,  /* (525) select_list ::= select_list NK_COMMA select_item */
   -1,  /* (526) select_item ::= NK_STAR */
   -1,  /* (527) select_item ::= common_expression */
   -2,  /* (528) select_item ::= common_expression column_alias */
   -3,  /* (529) select_item ::= common_expression AS column_alias */
   -3,  /* (530) select_item ::= table_name NK_DOT NK_STAR */
    0,  /* (531) where_clause_opt ::= */
   -2,  /* (532) where_clause_opt ::= WHERE search_condition */
    0,  /* (533) partition_by_clause_opt ::= */
   -3,  /* (534) partition_by_clause_opt ::= PARTITION BY partition_list */
   -1,  /* (535) partition_list ::= partition_item */
   -3,  /* (536) partition_list ::= partition_list NK_COMMA partition_item */
   -1,  /* (537) partition_item ::= expr_or_subquery */
   -2,  /* (538) partition_item ::= expr_or_subquery column_alias */
   -3,  /* (539) partition_item ::= expr_or_subquery AS column_alias */
    0,  /* (540) twindow_clause_opt ::= */
   -6,  /* (541) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   -4,  /* (542) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
   -6,  /* (543) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   -8,  /* (544) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   -7,  /* (545) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
    0,  /* (546) sliding_opt ::= */
   -4,  /* (547) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
    0,  /* (548) fill_opt ::= */
   -4,  /* (549) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   -6,  /* (550) fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
   -6,  /* (551) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
   -1,  /* (552) fill_mode ::= NONE */
   -1,  /* (553) fill_mode ::= PREV */
   -1,  /* (554) fill_mode ::= NULL */
   -1,  /* (555) fill_mode ::= NULL_F */
   -1,  /* (556) fill_mode ::= LINEAR */
   -1,  /* (557) fill_mode ::= NEXT */
    0,  /* (558) group_by_clause_opt ::= */
   -3,  /* (559) group_by_clause_opt ::= GROUP BY group_by_list */
   -1,  /* (560) group_by_list ::= expr_or_subquery */
   -3,  /* (561) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
    0,  /* (562) having_clause_opt ::= */
   -2,  /* (563) having_clause_opt ::= HAVING search_condition */
    0,  /* (564) range_opt ::= */
   -6,  /* (565) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
   -4,  /* (566) range_opt ::= RANGE NK_LP expr_or_subquery NK_RP */
    0,  /* (567) every_opt ::= */
   -4,  /* (568) every_opt ::= EVERY NK_LP duration_literal NK_RP */
   -4,  /* (569) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
   -1,  /* (570) query_simple ::= query_specification */
   -1,  /* (571) query_simple ::= union_query_expression */
   -4,  /* (572) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
   -3,  /* (573) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
   -1,  /* (574) query_simple_or_subquery ::= query_simple */
   -1,  /* (575) query_simple_or_subquery ::= subquery */
   -1,  /* (576) query_or_subquery ::= query_expression */
   -1,  /* (577) query_or_subquery ::= subquery */
    0,  /* (578) order_by_clause_opt ::= */
   -3,  /* (579) order_by_clause_opt ::= ORDER BY sort_specification_list */
    0,  /* (580) slimit_clause_opt ::= */
   -2,  /* (581) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   -4,  /* (582) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   -4,  /* (583) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
    0,  /* (584) limit_clause_opt ::= */
   -2,  /* (585) limit_clause_opt ::= LIMIT NK_INTEGER */
   -4,  /* (586) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   -4,  /* (587) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   -3,  /* (588) subquery ::= NK_LP query_expression NK_RP */
   -3,  /* (589) subquery ::= NK_LP subquery NK_RP */
   -1,  /* (590) search_condition ::= common_expression */
   -1,  /* (591) sort_specification_list ::= sort_specification */
   -3,  /* (592) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   -3,  /* (593) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
    0,  /* (594) ordering_specification_opt ::= */
   -1,  /* (595) ordering_specification_opt ::= ASC */
   -1,  /* (596) ordering_specification_opt ::= DESC */
    0,  /* (597) null_ordering_opt ::= */
   -2,  /* (598) null_ordering_opt ::= NULLS FIRST */
   -2,  /* (599) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfoNRhs[yyruleno];
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
        yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,339,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,340,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,339,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,341,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,342,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,340,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,342,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,341,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy371, &yymsp[-1].minor.yy0, yymsp[0].minor.yy475); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy371, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy371, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy371, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy371); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy475 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy475 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level with_opt TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-5].minor.yy729, &yymsp[-3].minor.yy347, &yymsp[0].minor.yy371, yymsp[-2].minor.yy452); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level with_opt FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-5].minor.yy729, &yymsp[-3].minor.yy347, &yymsp[0].minor.yy371, yymsp[-2].minor.yy452); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy729 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy729 = yymsp[0].minor.yy729; }
  yymsp[0].minor.yy729 = yylhsminor.yy729;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy729 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy729 = yymsp[-2].minor.yy729 | yymsp[0].minor.yy729; }
  yymsp[-2].minor.yy729 = yylhsminor.yy729;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy729 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy729 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy347.first = yymsp[-2].minor.yy0; yylhsminor.yy347.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy347 = yylhsminor.yy347;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy347.first = yymsp[-2].minor.yy371; yylhsminor.yy347.second = yymsp[0].minor.yy0; }
  yymsp[-2].minor.yy347 = yylhsminor.yy347;
        break;
      case 42: /* priv_level ::= db_name NK_DOT table_name */
{ yylhsminor.yy347.first = yymsp[-2].minor.yy371; yylhsminor.yy347.second = yymsp[0].minor.yy371; }
  yymsp[-2].minor.yy347 = yylhsminor.yy347;
        break;
      case 43: /* priv_level ::= topic_name */
{ yylhsminor.yy347.first = yymsp[0].minor.yy371; yylhsminor.yy347.second = nil_token; }
  yymsp[0].minor.yy347 = yylhsminor.yy347;
        break;
      case 44: /* with_opt ::= */
      case 144: /* start_opt ::= */ yytestcase(yyruleno==144);
      case 148: /* end_opt ::= */ yytestcase(yyruleno==148);
      case 276: /* like_pattern_opt ::= */ yytestcase(yyruleno==276);
      case 354: /* subtable_opt ::= */ yytestcase(yyruleno==354);
      case 472: /* case_when_else_opt ::= */ yytestcase(yyruleno==472);
      case 502: /* from_clause_opt ::= */ yytestcase(yyruleno==502);
      case 531: /* where_clause_opt ::= */ yytestcase(yyruleno==531);
      case 540: /* twindow_clause_opt ::= */ yytestcase(yyruleno==540);
      case 546: /* sliding_opt ::= */ yytestcase(yyruleno==546);
      case 548: /* fill_opt ::= */ yytestcase(yyruleno==548);
      case 562: /* having_clause_opt ::= */ yytestcase(yyruleno==562);
      case 564: /* range_opt ::= */ yytestcase(yyruleno==564);
      case 567: /* every_opt ::= */ yytestcase(yyruleno==567);
      case 580: /* slimit_clause_opt ::= */ yytestcase(yyruleno==580);
      case 584: /* limit_clause_opt ::= */ yytestcase(yyruleno==584);
{ yymsp[1].minor.yy452 = NULL; }
        break;
      case 45: /* with_opt ::= WITH search_condition */
      case 503: /* from_clause_opt ::= FROM table_reference_list */ yytestcase(yyruleno==503);
      case 532: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==532);
      case 563: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==563);
{ yymsp[-1].minor.yy452 = yymsp[0].minor.yy452; }
        break;
      case 46: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy371, NULL); }
        break;
      case 47: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy371, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy667, false); }
        break;
      case 49: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy371, yymsp[0].minor.yy667, false); }
        break;
      case 50: /* cmd ::= DROP DNODE NK_INTEGER unsafe_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, false, yymsp[0].minor.yy667); }
        break;
      case 51: /* cmd ::= DROP DNODE dnode_endpoint unsafe_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy371, false, yymsp[0].minor.yy667); }
        break;
      case 52: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 53: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 55: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= RESTORE DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_DNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* dnode_endpoint ::= NK_STRING */
      case 58: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==58);
      case 59: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==59);
      case 300: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==300);
      case 301: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==301);
      case 302: /* sma_func_name ::= LAST */ yytestcase(yyruleno==302);
      case 303: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==303);
      case 398: /* db_name ::= NK_ID */ yytestcase(yyruleno==398);
      case 399: /* table_name ::= NK_ID */ yytestcase(yyruleno==399);
      case 400: /* column_name ::= NK_ID */ yytestcase(yyruleno==400);
      case 401: /* function_name ::= NK_ID */ yytestcase(yyruleno==401);
      case 402: /* table_alias ::= NK_ID */ yytestcase(yyruleno==402);
      case 403: /* column_alias ::= NK_ID */ yytestcase(yyruleno==403);
      case 404: /* user_name ::= NK_ID */ yytestcase(yyruleno==404);
      case 405: /* topic_name ::= NK_ID */ yytestcase(yyruleno==405);
      case 406: /* stream_name ::= NK_ID */ yytestcase(yyruleno==406);
      case 407: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==407);
      case 408: /* index_name ::= NK_ID */ yytestcase(yyruleno==408);
      case 448: /* noarg_func ::= NOW */ yytestcase(yyruleno==448);
      case 449: /* noarg_func ::= TODAY */ yytestcase(yyruleno==449);
      case 450: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==450);
      case 451: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==451);
      case 452: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==452);
      case 453: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==453);
      case 454: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==454);
      case 455: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==455);
      case 456: /* noarg_func ::= USER */ yytestcase(yyruleno==456);
      case 457: /* star_func ::= COUNT */ yytestcase(yyruleno==457);
      case 458: /* star_func ::= FIRST */ yytestcase(yyruleno==458);
      case 459: /* star_func ::= LAST */ yytestcase(yyruleno==459);
      case 460: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==460);
{ yylhsminor.yy371 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy371 = yylhsminor.yy371;
        break;
      case 60: /* force_opt ::= */
      case 84: /* not_exists_opt ::= */ yytestcase(yyruleno==84);
      case 86: /* exists_opt ::= */ yytestcase(yyruleno==86);
      case 321: /* analyze_opt ::= */ yytestcase(yyruleno==321);
      case 328: /* agg_func_opt ::= */ yytestcase(yyruleno==328);
      case 334: /* or_replace_opt ::= */ yytestcase(yyruleno==334);
      case 356: /* ignore_opt ::= */ yytestcase(yyruleno==356);
      case 521: /* set_quantifier_opt ::= */ yytestcase(yyruleno==521);
{ yymsp[1].minor.yy667 = false; }
        break;
      case 61: /* force_opt ::= FORCE */
      case 62: /* unsafe_opt ::= UNSAFE */ yytestcase(yyruleno==62);
      case 322: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==322);
      case 329: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==329);
      case 522: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==522);
{ yymsp[0].minor.yy667 = true; }
        break;
      case 63: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 64: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 67: /* cmd ::= RESTORE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 68: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 69: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 70: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 71: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 72: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 73: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 74: /* cmd ::= RESTORE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 75: /* cmd ::= RESTORE VNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createRestoreComponentNodeStmt(pCxt, QUERY_NODE_RESTORE_VNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 76: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy667, &yymsp[-1].minor.yy371, yymsp[0].minor.yy452); }
        break;
      case 77: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy667, &yymsp[0].minor.yy371); }
        break;
      case 78: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy371); }
        break;
      case 79: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy371, yymsp[0].minor.yy452); }
        break;
      case 80: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy371); }
        break;
      case 81: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy371, yymsp[0].minor.yy416); }
        break;
      case 82: /* cmd ::= COMPACT DATABASE db_name start_opt end_opt */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[-2].minor.yy371, yymsp[-1].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 83: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy667 = true; }
        break;
      case 85: /* exists_opt ::= IF EXISTS */
      case 335: /* or_replace_opt ::= OR REPLACE */ yytestcase(yyruleno==335);
      case 357: /* ignore_opt ::= IGNORE UNTREATED */ yytestcase(yyruleno==357);
{ yymsp[-1].minor.yy667 = true; }
        break;
      case 87: /* db_options ::= */
{ yymsp[1].minor.yy452 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 88: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 89: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 90: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 91: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 92: /* db_options ::= db_options DURATION NK_INTEGER */
      case 93: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==93);
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 94: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 95: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 96: /* db_options ::= db_options KEEP integer_list */
      case 97: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==97);
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_KEEP, yymsp[0].minor.yy812); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 98: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 99: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 100: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 101: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 102: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 103: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 104: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 105: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_RETENTIONS, yymsp[0].minor.yy812); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 106: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 107: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 108: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 109: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 110: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-3].minor.yy452, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 111: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 112: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-3].minor.yy452, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 113: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 114: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 115: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 116: /* db_options ::= db_options TABLE_PREFIX signed */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_TABLE_PREFIX, yymsp[0].minor.yy452); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 117: /* db_options ::= db_options TABLE_SUFFIX signed */
{ yylhsminor.yy452 = setDatabaseOption(pCxt, yymsp[-2].minor.yy452, DB_OPTION_TABLE_SUFFIX, yymsp[0].minor.yy452); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 118: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy452 = createAlterDatabaseOptions(pCxt); yylhsminor.yy452 = setAlterDatabaseOption(pCxt, yylhsminor.yy452, &yymsp[0].minor.yy365); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 119: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy452 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy452, &yymsp[0].minor.yy365); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 120: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy365.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy365.val = yymsp[0].minor.yy0; }
        break;
      case 121: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy365.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy365.val = yymsp[0].minor.yy0; }
        break;
      case 122: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy365.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy365.val = yymsp[0].minor.yy0; }
        break;
      case 123: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy365.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy365.val = yymsp[0].minor.yy0; }
        break;
      case 124: /* alter_db_option ::= KEEP integer_list */
      case 125: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==125);
{ yymsp[-1].minor.yy365.type = DB_OPTION_KEEP; yymsp[-1].minor.yy365.pList = yymsp[0].minor.yy812; }
        break;
      case 126: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy365.type = DB_OPTION_PAGES; yymsp[-1].minor.yy365.val = yymsp[0].minor.yy0; }
        break;
      case 127: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy365.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy365.val = yymsp[0].minor.yy0; }
        break;
      case 128: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy365.type = DB_OPTION_WAL; yymsp[-1].minor.yy365.val = yymsp[0].minor.yy0; }
        break;
      case 129: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy365.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy365.val = yymsp[0].minor.yy0; }
        break;
      case 130: /* alter_db_option ::= MINROWS NK_INTEGER */
{ yymsp[-1].minor.yy365.type = DB_OPTION_MINROWS; yymsp[-1].minor.yy365.val = yymsp[0].minor.yy0; }
        break;
      case 131: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy365.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-1].minor.yy365.val = yymsp[0].minor.yy0; }
        break;
      case 132: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy365.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-2].minor.yy365.val = t;
                                                                                  }
        break;
      case 133: /* alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
{ yymsp[-1].minor.yy365.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-1].minor.yy365.val = yymsp[0].minor.yy0; }
        break;
      case 134: /* alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy365.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-2].minor.yy365.val = t;
                                                                                  }
        break;
      case 135: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy812 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 136: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 367: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==367);
{ yylhsminor.yy812 = addNodeToList(pCxt, yymsp[-2].minor.yy812, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 137: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy812 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 138: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy812 = addNodeToList(pCxt, yymsp[-2].minor.yy812, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 139: /* retention_list ::= retention */
      case 169: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==169);
      case 172: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==172);
      case 179: /* column_def_list ::= column_def */ yytestcase(yyruleno==179);
      case 223: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==223);
      case 228: /* col_name_list ::= col_name */ yytestcase(yyruleno==228);
      case 282: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==282);
      case 296: /* func_list ::= func */ yytestcase(yyruleno==296);
      case 396: /* literal_list ::= signed_literal */ yytestcase(yyruleno==396);
      case 463: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==463);
      case 469: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==469);
      case 524: /* select_list ::= select_item */ yytestcase(yyruleno==524);
      case 535: /* partition_list ::= partition_item */ yytestcase(yyruleno==535);
      case 591: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==591);
{ yylhsminor.yy812 = createNodeList(pCxt, yymsp[0].minor.yy452); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 140: /* retention_list ::= retention_list NK_COMMA retention */
      case 173: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==173);
      case 180: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==180);
      case 224: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==224);
      case 229: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==229);
      case 283: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==283);
      case 297: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==297);
      case 397: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==397);
      case 464: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==464);
      case 525: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==525);
      case 536: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==536);
      case 592: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==592);
{ yylhsminor.yy812 = addNodeToList(pCxt, yymsp[-2].minor.yy812, yymsp[0].minor.yy452); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 141: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy452 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 142: /* speed_opt ::= */
      case 330: /* bufsize_opt ::= */ yytestcase(yyruleno==330);
{ yymsp[1].minor.yy416 = 0; }
        break;
      case 143: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 331: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==331);
{ yymsp[-1].minor.yy416 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 145: /* start_opt ::= START WITH NK_INTEGER */
      case 149: /* end_opt ::= END WITH NK_INTEGER */ yytestcase(yyruleno==149);
{ yymsp[-2].minor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 146: /* start_opt ::= START WITH NK_STRING */
      case 150: /* end_opt ::= END WITH NK_STRING */ yytestcase(yyruleno==150);
{ yymsp[-2].minor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 147: /* start_opt ::= START WITH TIMESTAMP NK_STRING */
      case 151: /* end_opt ::= END WITH TIMESTAMP NK_STRING */ yytestcase(yyruleno==151);
{ yymsp[-3].minor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 152: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 154: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==154);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy667, yymsp[-5].minor.yy452, yymsp[-3].minor.yy812, yymsp[-1].minor.yy812, yymsp[0].minor.yy452); }
        break;
      case 153: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy812); }
        break;
      case 155: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy812); }
        break;
      case 156: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy667, yymsp[0].minor.yy452); }
        break;
      case 157: /* cmd ::= ALTER TABLE alter_table_clause */
      case 369: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==369);
      case 370: /* cmd ::= insert_query */ yytestcase(yyruleno==370);
{ pCxt->pRootNode = yymsp[0].minor.yy452; }
        break;
      case 158: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy452); }
        break;
      case 159: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy452 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy452, yymsp[0].minor.yy452); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 160: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy452 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy452, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy371, yymsp[0].minor.yy310); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 161: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy452 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy452, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy371); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 162: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy452 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy452, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy371, yymsp[0].minor.yy310); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 163: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy452 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy452, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy371, &yymsp[0].minor.yy371); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 164: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy452 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy452, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy371, yymsp[0].minor.yy310); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 165: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy452 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy452, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy371); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 166: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy452 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy452, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy371, yymsp[0].minor.yy310); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 167: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy452 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy452, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy371, &yymsp[0].minor.yy371); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 168: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy452 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy452, &yymsp[-2].minor.yy371, yymsp[0].minor.yy452); }
  yymsp[-5].minor.yy452 = yylhsminor.yy452;
        break;
      case 170: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 470: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==470);
{ yylhsminor.yy812 = addNodeToList(pCxt, yymsp[-1].minor.yy812, yymsp[0].minor.yy452); }
  yymsp[-1].minor.yy812 = yylhsminor.yy812;
        break;
      case 171: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy452 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy667, yymsp[-8].minor.yy452, yymsp[-6].minor.yy452, yymsp[-5].minor.yy812, yymsp[-2].minor.yy812, yymsp[0].minor.yy452); }
  yymsp[-9].minor.yy452 = yylhsminor.yy452;
        break;
      case 174: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy452 = createDropTableClause(pCxt, yymsp[-1].minor.yy667, yymsp[0].minor.yy452); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 175: /* specific_cols_opt ::= */
      case 206: /* tags_def_opt ::= */ yytestcase(yyruleno==206);
      case 281: /* tag_list_opt ::= */ yytestcase(yyruleno==281);
      case 340: /* col_list_opt ::= */ yytestcase(yyruleno==340);
      case 342: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==342);
      case 533: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==533);
      case 558: /* group_by_clause_opt ::= */ yytestcase(yyruleno==558);
      case 578: /* order_by_clause_opt ::= */ yytestcase(yyruleno==578);
{ yymsp[1].minor.yy812 = NULL; }
        break;
      case 176: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 341: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==341);
{ yymsp[-2].minor.yy812 = yymsp[-1].minor.yy812; }
        break;
      case 177: /* full_table_name ::= table_name */
{ yylhsminor.yy452 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy371, NULL); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 178: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy452 = createRealTableNode(pCxt, &yymsp[-2].minor.yy371, &yymsp[0].minor.yy371, NULL); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 181: /* column_def ::= column_name type_name */
{ yylhsminor.yy452 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy371, yymsp[0].minor.yy310, NULL); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 182: /* type_name ::= BOOL */
{ yymsp[0].minor.yy310 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 183: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy310 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 184: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy310 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 185: /* type_name ::= INT */
      case 186: /* type_name ::= INTEGER */ yytestcase(yyruleno==186);
{ yymsp[0].minor.yy310 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 187: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy310 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 188: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy310 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 189: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy310 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 190: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy310 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 191: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy310 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 192: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy310 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 193: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy310 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 194: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy310 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 195: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy310 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 196: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy310 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 197: /* type_name ::= JSON */
{ yymsp[0].minor.yy310 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 198: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy310 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 199: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy310 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 200: /* type_name ::= BLOB */
{ yymsp[0].minor.yy310 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 201: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy310 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 202: /* type_name ::= GEOMETRY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy310 = createVarLenDataType(TSDB_DATA_TYPE_GEOMETRY, &yymsp[-1].minor.yy0); }
        break;
      case 203: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy310 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 204: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy310 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 205: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy310 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 207: /* tags_def_opt ::= tags_def */
      case 343: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==343);
      case 462: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==462);
{ yylhsminor.yy812 = yymsp[0].minor.yy812; }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 208: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 344: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==344);
{ yymsp[-3].minor.yy812 = yymsp[-1].minor.yy812; }
        break;
      case 209: /* table_options ::= */
{ yymsp[1].minor.yy452 = createDefaultTableOptions(pCxt); }
        break;
      case 210: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy452 = setTableOption(pCxt, yymsp[-2].minor.yy452, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 211: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy452 = setTableOption(pCxt, yymsp[-2].minor.yy452, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy812); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 212: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy452 = setTableOption(pCxt, yymsp[-2].minor.yy452, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy812); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 213: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy452 = setTableOption(pCxt, yymsp[-4].minor.yy452, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy812); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 214: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy452 = setTableOption(pCxt, yymsp[-2].minor.yy452, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 215: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy452 = setTableOption(pCxt, yymsp[-4].minor.yy452, TABLE_OPTION_SMA, yymsp[-1].minor.yy812); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 216: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy452 = setTableOption(pCxt, yymsp[-2].minor.yy452, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy812); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 217: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy452 = createAlterTableOptions(pCxt); yylhsminor.yy452 = setTableOption(pCxt, yylhsminor.yy452, yymsp[0].minor.yy365.type, &yymsp[0].minor.yy365.val); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 218: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy452 = setTableOption(pCxt, yymsp[-1].minor.yy452, yymsp[0].minor.yy365.type, &yymsp[0].minor.yy365.val); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 219: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy365.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy365.val = yymsp[0].minor.yy0; }
        break;
      case 220: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy365.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy365.val = yymsp[0].minor.yy0; }
        break;
      case 221: /* duration_list ::= duration_literal */
      case 426: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==426);
{ yylhsminor.yy812 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy452)); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 222: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 427: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==427);
{ yylhsminor.yy812 = addNodeToList(pCxt, yymsp[-2].minor.yy812, releaseRawExprNode(pCxt, yymsp[0].minor.yy452)); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 225: /* rollup_func_name ::= function_name */
{ yylhsminor.yy452 = createFunctionNode(pCxt, &yymsp[0].minor.yy371, NULL); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 226: /* rollup_func_name ::= FIRST */
      case 227: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==227);
      case 285: /* tag_item ::= QTAGS */ yytestcase(yyruleno==285);
{ yylhsminor.yy452 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 230: /* col_name ::= column_name */
      case 286: /* tag_item ::= column_name */ yytestcase(yyruleno==286);
{ yylhsminor.yy452 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy371); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 231: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 232: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 233: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 234: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 235: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy452, yymsp[0].minor.yy452, OP_TYPE_LIKE); }
        break;
      case 236: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy452, yymsp[0].minor.yy452, OP_TYPE_LIKE); }
        break;
      case 237: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy452, NULL, OP_TYPE_LIKE); }
        break;
      case 238: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 239: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 240: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 241: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy452, yymsp[-1].minor.yy452, OP_TYPE_EQUAL); }
        break;
      case 242: /* cmd ::= SHOW INDEXES FROM db_name NK_DOT table_name */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, createIdentifierValueNode(pCxt, &yymsp[-2].minor.yy371), createIdentifierValueNode(pCxt, &yymsp[0].minor.yy371), OP_TYPE_EQUAL); }
        break;
      case 243: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 244: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 245: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 246: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 247: /* cmd ::= SHOW LICENCES */
      case 248: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==248);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 249: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy371); }
        break;
      case 250: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy452); }
        break;
      case 251: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy452); }
        break;
      case 252: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 253: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 254: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 255: /* cmd ::= SHOW VARIABLES */
      case 256: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==256);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 257: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 258: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy452); }
        break;
      case 259: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 260: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 261: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 262: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 263: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy452); }
        break;
      case 264: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 265: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 266: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy452, yymsp[-1].minor.yy452, OP_TYPE_EQUAL); }
        break;
      case 267: /* cmd ::= SHOW TAGS FROM db_name NK_DOT table_name */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, createIdentifierValueNode(pCxt, &yymsp[-2].minor.yy371), createIdentifierValueNode(pCxt, &yymsp[0].minor.yy371), OP_TYPE_EQUAL); }
        break;
      case 268: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy452, yymsp[0].minor.yy452, yymsp[-3].minor.yy812); }
        break;
      case 269: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM db_name NK_DOT table_name */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, createIdentifierValueNode(pCxt, &yymsp[0].minor.yy371), createIdentifierValueNode(pCxt, &yymsp[-2].minor.yy371), yymsp[-4].minor.yy812); }
        break;
      case 270: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 271: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 272: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy452,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 273: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 274: /* db_name_cond_opt ::= */
      case 279: /* from_db_opt ::= */ yytestcase(yyruleno==279);
{ yymsp[1].minor.yy452 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 275: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy452 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy371); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 277: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 278: /* table_name_cond ::= table_name */
{ yylhsminor.yy452 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy371); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 280: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy452 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy371); }
        break;
      case 284: /* tag_item ::= TBNAME */
{ yylhsminor.yy452 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 287: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy452 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy371), &yymsp[0].minor.yy371); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 288: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy452 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy371), &yymsp[0].minor.yy371); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 289: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy667, yymsp[-3].minor.yy452, yymsp[-1].minor.yy452, NULL, yymsp[0].minor.yy452); }
        break;
      case 290: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy667, yymsp[-5].minor.yy452, yymsp[-3].minor.yy452, yymsp[-1].minor.yy812, NULL); }
        break;
      case 291: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy667, yymsp[0].minor.yy452); }
        break;
      case 292: /* full_index_name ::= index_name */
{ yylhsminor.yy452 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy371); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 293: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy452 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy371, &yymsp[0].minor.yy371); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 294: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy452 = createIndexOption(pCxt, yymsp[-7].minor.yy812, releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), NULL, yymsp[-1].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 295: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy452 = createIndexOption(pCxt, yymsp[-9].minor.yy812, releaseRawExprNode(pCxt, yymsp[-5].minor.yy452), releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), yymsp[-1].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 298: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy452 = createFunctionNode(pCxt, &yymsp[-3].minor.yy371, yymsp[-1].minor.yy812); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 299: /* sma_func_name ::= function_name */
      case 513: /* alias_opt ::= table_alias */ yytestcase(yyruleno==513);
{ yylhsminor.yy371 = yymsp[0].minor.yy371; }
  yymsp[0].minor.yy371 = yylhsminor.yy371;
        break;
      case 304: /* sma_stream_opt ::= */
      case 345: /* stream_options ::= */ yytestcase(yyruleno==345);
{ yymsp[1].minor.yy452 = createStreamOptions(pCxt); }
        break;
      case 305: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy452)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy452); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 306: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy452)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy452); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 307: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy452)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy452); yylhsminor.yy452 = yymsp[-2].minor.yy452; }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 308: /* with_meta ::= AS */
{ yymsp[0].minor.yy416 = 0; }
        break;
      case 309: /* with_meta ::= WITH META AS */
{ yymsp[-2].minor.yy416 = 1; }
        break;
      case 310: /* with_meta ::= ONLY META AS */
{ yymsp[-2].minor.yy416 = 2; }
        break;
      case 311: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy667, &yymsp[-2].minor.yy371, yymsp[0].minor.yy452); }
        break;
      case 312: /* cmd ::= CREATE TOPIC not_exists_opt topic_name with_meta DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy667, &yymsp[-3].minor.yy371, &yymsp[0].minor.yy371, yymsp[-2].minor.yy416); }
        break;
      case 313: /* cmd ::= CREATE TOPIC not_exists_opt topic_name with_meta STABLE full_table_name where_clause_opt */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-5].minor.yy667, &yymsp[-4].minor.yy371, yymsp[-1].minor.yy452, yymsp[-3].minor.yy416, yymsp[0].minor.yy452); }
        break;
      case 314: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy667, &yymsp[0].minor.yy371); }
        break;
      case 315: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy667, &yymsp[-2].minor.yy371, &yymsp[0].minor.yy371); }
        break;
      case 316: /* cmd ::= DESC full_table_name */
      case 317: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==317);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy452); }
        break;
      case 318: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 319: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 320: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==320);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy667, yymsp[-1].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 323: /* explain_options ::= */
{ yymsp[1].minor.yy452 = createDefaultExplainOptions(pCxt); }
        break;
      case 324: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy452 = setExplainVerbose(pCxt, yymsp[-2].minor.yy452, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 325: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy452 = setExplainRatio(pCxt, yymsp[-2].minor.yy452, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 326: /* cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy667, yymsp[-9].minor.yy667, &yymsp[-6].minor.yy371, &yymsp[-4].minor.yy0, yymsp[-2].minor.yy310, yymsp[-1].minor.yy416, &yymsp[0].minor.yy371, yymsp[-10].minor.yy667); }
        break;
      case 327: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy667, &yymsp[0].minor.yy371); }
        break;
      case 332: /* language_opt ::= */
{ yymsp[1].minor.yy371 = nil_token; }
        break;
      case 333: /* language_opt ::= LANGUAGE NK_STRING */
{ yymsp[-1].minor.yy371 = yymsp[0].minor.yy0; }
        break;
      case 336: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy667, &yymsp[-8].minor.yy371, yymsp[-5].minor.yy452, yymsp[-7].minor.yy452, yymsp[-3].minor.yy812, yymsp[-2].minor.yy452, yymsp[0].minor.yy452, yymsp[-4].minor.yy812); }
        break;
      case 337: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy667, &yymsp[0].minor.yy371); }
        break;
      case 338: /* cmd ::= PAUSE STREAM exists_opt stream_name */
{ pCxt->pRootNode = createPauseStreamStmt(pCxt, yymsp[-1].minor.yy667, &yymsp[0].minor.yy371); }
        break;
      case 339: /* cmd ::= RESUME STREAM exists_opt ignore_opt stream_name */
{ pCxt->pRootNode = createResumeStreamStmt(pCxt, yymsp[-2].minor.yy667, yymsp[-1].minor.yy667, &yymsp[0].minor.yy371); }
        break;
      case 346: /* stream_options ::= stream_options TRIGGER AT_ONCE */
      case 347: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */ yytestcase(yyruleno==347);
{ yylhsminor.yy452 = setStreamOptions(pCxt, yymsp[-2].minor.yy452, SOPT_TRIGGER_TYPE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 348: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ yylhsminor.yy452 = setStreamOptions(pCxt, yymsp[-3].minor.yy452, SOPT_TRIGGER_TYPE_SET, &yymsp[-1].minor.yy0, releaseRawExprNode(pCxt, yymsp[0].minor.yy452)); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 349: /* stream_options ::= stream_options WATERMARK duration_literal */
{ yylhsminor.yy452 = setStreamOptions(pCxt, yymsp[-2].minor.yy452, SOPT_WATERMARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy452)); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 350: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ yylhsminor.yy452 = setStreamOptions(pCxt, yymsp[-3].minor.yy452, SOPT_IGNORE_EXPIRED_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 351: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ yylhsminor.yy452 = setStreamOptions(pCxt, yymsp[-2].minor.yy452, SOPT_FILL_HISTORY_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 352: /* stream_options ::= stream_options DELETE_MARK duration_literal */
{ yylhsminor.yy452 = setStreamOptions(pCxt, yymsp[-2].minor.yy452, SOPT_DELETE_MARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy452)); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 353: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ yylhsminor.yy452 = setStreamOptions(pCxt, yymsp[-3].minor.yy452, SOPT_IGNORE_UPDATE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 355: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 547: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==547);
      case 568: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==568);
{ yymsp[-3].minor.yy452 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy452); }
        break;
      case 358: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 359: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 360: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 361: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 362: /* cmd ::= BALANCE VGROUP LEADER */
{ pCxt->pRootNode = createBalanceVgroupLeaderStmt(pCxt); }
        break;
      case 363: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 364: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy812); }
        break;
      case 365: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 366: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy812 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 368: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 371: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy452 = createInsertStmt(pCxt, yymsp[-4].minor.yy452, yymsp[-2].minor.yy812, yymsp[0].minor.yy452); }
        break;
      case 372: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy452 = createInsertStmt(pCxt, yymsp[-1].minor.yy452, NULL, yymsp[0].minor.yy452); }
        break;
      case 373: /* literal ::= NK_INTEGER */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 374: /* literal ::= NK_FLOAT */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 375: /* literal ::= NK_STRING */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 376: /* literal ::= NK_BOOL */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 377: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 378: /* literal ::= duration_literal */
      case 388: /* signed_literal ::= signed */ yytestcase(yyruleno==388);
      case 409: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==409);
      case 410: /* expression ::= literal */ yytestcase(yyruleno==410);
      case 411: /* expression ::= pseudo_column */ yytestcase(yyruleno==411);
      case 412: /* expression ::= column_reference */ yytestcase(yyruleno==412);
      case 413: /* expression ::= function_expression */ yytestcase(yyruleno==413);
      case 414: /* expression ::= case_when_expression */ yytestcase(yyruleno==414);
      case 445: /* function_expression ::= literal_func */ yytestcase(yyruleno==445);
      case 494: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==494);
      case 498: /* boolean_primary ::= predicate */ yytestcase(yyruleno==498);
      case 500: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==500);
      case 501: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==501);
      case 504: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==504);
      case 506: /* table_reference ::= table_primary */ yytestcase(yyruleno==506);
      case 507: /* table_reference ::= joined_table */ yytestcase(yyruleno==507);
      case 511: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==511);
      case 570: /* query_simple ::= query_specification */ yytestcase(yyruleno==570);
      case 571: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==571);
      case 574: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==574);
      case 576: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==576);
{ yylhsminor.yy452 = yymsp[0].minor.yy452; }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 379: /* literal ::= NULL */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 380: /* literal ::= NK_QUESTION */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 381: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 382: /* signed ::= NK_INTEGER */
{ yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 383: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 384: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 385: /* signed ::= NK_FLOAT */
{ yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 386: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 387: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 389: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 390: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 391: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 392: /* signed_literal ::= duration_literal */
      case 394: /* signed_literal ::= literal_func */ yytestcase(yyruleno==394);
      case 465: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==465);
      case 527: /* select_item ::= common_expression */ yytestcase(yyruleno==527);
      case 537: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==537);
      case 575: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==575);
      case 577: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==577);
      case 590: /* search_condition ::= common_expression */ yytestcase(yyruleno==590);
{ yylhsminor.yy452 = releaseRawExprNode(pCxt, yymsp[0].minor.yy452); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 393: /* signed_literal ::= NULL */
{ yylhsminor.yy452 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 395: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy452 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 415: /* expression ::= NK_LP expression NK_RP */
      case 499: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==499);
      case 589: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==589);
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy452)); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 416: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy452));
                                                                                  }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 417: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy452), NULL));
                                                                                  }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 418: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452))); 
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 419: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452))); 
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 420: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452))); 
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 421: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452))); 
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 422: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)));
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 423: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 424: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)));
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 425: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)));
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 428: /* column_reference ::= column_name */
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy371, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy371)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 429: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy371, &yymsp[0].minor.yy371, createColumnNode(pCxt, &yymsp[-2].minor.yy371, &yymsp[0].minor.yy371)); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 430: /* pseudo_column ::= ROWTS */
      case 431: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==431);
      case 433: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==433);
      case 434: /* pseudo_column ::= QEND */ yytestcase(yyruleno==434);
      case 435: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==435);
      case 436: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==436);
      case 437: /* pseudo_column ::= WEND */ yytestcase(yyruleno==437);
      case 438: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==438);
      case 439: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==439);
      case 440: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==440);
      case 441: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==441);
      case 447: /* literal_func ::= NOW */ yytestcase(yyruleno==447);
{ yylhsminor.yy452 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 432: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy371, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy371)))); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 442: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 443: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==443);
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy371, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy371, yymsp[-1].minor.yy812)); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 444: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), yymsp[-1].minor.yy310)); }
  yymsp[-5].minor.yy452 = yylhsminor.yy452;
        break;
      case 446: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy371, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy371, NULL)); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 461: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy812 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 466: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 530: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==530);
{ yylhsminor.yy452 = createColumnNode(pCxt, &yymsp[-2].minor.yy371, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 467: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy812, yymsp[-1].minor.yy452)); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 468: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), yymsp[-2].minor.yy812, yymsp[-1].minor.yy452)); }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 471: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy452 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)); }
        break;
      case 473: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy452 = releaseRawExprNode(pCxt, yymsp[0].minor.yy452); }
        break;
      case 474: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 479: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==479);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy354, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)));
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 475: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy452), releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)));
                                                                                  }
  yymsp[-4].minor.yy452 = yylhsminor.yy452;
        break;
      case 476: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy452), releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)));
                                                                                  }
  yymsp[-5].minor.yy452 = yylhsminor.yy452;
        break;
      case 477: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), NULL));
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 478: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), NULL));
                                                                                  }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 480: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy354 = OP_TYPE_LOWER_THAN; }
        break;
      case 481: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy354 = OP_TYPE_GREATER_THAN; }
        break;
      case 482: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy354 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 483: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy354 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 484: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy354 = OP_TYPE_NOT_EQUAL; }
        break;
      case 485: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy354 = OP_TYPE_EQUAL; }
        break;
      case 486: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy354 = OP_TYPE_LIKE; }
        break;
      case 487: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy354 = OP_TYPE_NOT_LIKE; }
        break;
      case 488: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy354 = OP_TYPE_MATCH; }
        break;
      case 489: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy354 = OP_TYPE_NMATCH; }
        break;
      case 490: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy354 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 491: /* in_op ::= IN */
{ yymsp[0].minor.yy354 = OP_TYPE_IN; }
        break;
      case 492: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy354 = OP_TYPE_NOT_IN; }
        break;
      case 493: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy812)); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 495: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy452), NULL));
                                                                                  }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 496: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)));
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 497: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy452);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy452);
                                                                                    yylhsminor.yy452 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), releaseRawExprNode(pCxt, yymsp[0].minor.yy452)));
                                                                                  }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 505: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy452 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy452, yymsp[0].minor.yy452, NULL); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 508: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy452 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy371, &yymsp[0].minor.yy371); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 509: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy452 = createRealTableNode(pCxt, &yymsp[-3].minor.yy371, &yymsp[-1].minor.yy371, &yymsp[0].minor.yy371); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 510: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy452 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy452), &yymsp[0].minor.yy371); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 512: /* alias_opt ::= */
{ yymsp[1].minor.yy371 = nil_token;  }
        break;
      case 514: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy371 = yymsp[0].minor.yy371; }
        break;
      case 515: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 516: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==516);
{ yymsp[-2].minor.yy452 = yymsp[-1].minor.yy452; }
        break;
      case 517: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy452 = createJoinTableNode(pCxt, yymsp[-4].minor.yy140, yymsp[-5].minor.yy452, yymsp[-2].minor.yy452, yymsp[0].minor.yy452); }
  yymsp[-5].minor.yy452 = yylhsminor.yy452;
        break;
      case 518: /* join_type ::= */
{ yymsp[1].minor.yy140 = JOIN_TYPE_INNER; }
        break;
      case 519: /* join_type ::= INNER */
{ yymsp[0].minor.yy140 = JOIN_TYPE_INNER; }
        break;
      case 520: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy452 = createSelectStmt(pCxt, yymsp[-10].minor.yy667, yymsp[-9].minor.yy812, yymsp[-8].minor.yy452);
                                                                                    yymsp[-11].minor.yy452 = addWhereClause(pCxt, yymsp[-11].minor.yy452, yymsp[-7].minor.yy452);
                                                                                    yymsp[-11].minor.yy452 = addPartitionByClause(pCxt, yymsp[-11].minor.yy452, yymsp[-6].minor.yy812);
                                                                                    yymsp[-11].minor.yy452 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy452, yymsp[-2].minor.yy452);
                                                                                    yymsp[-11].minor.yy452 = addGroupByClause(pCxt, yymsp[-11].minor.yy452, yymsp[-1].minor.yy812);
                                                                                    yymsp[-11].minor.yy452 = addHavingClause(pCxt, yymsp[-11].minor.yy452, yymsp[0].minor.yy452);
                                                                                    yymsp[-11].minor.yy452 = addRangeClause(pCxt, yymsp[-11].minor.yy452, yymsp[-5].minor.yy452);
                                                                                    yymsp[-11].minor.yy452 = addEveryClause(pCxt, yymsp[-11].minor.yy452, yymsp[-4].minor.yy452);
                                                                                    yymsp[-11].minor.yy452 = addFillClause(pCxt, yymsp[-11].minor.yy452, yymsp[-3].minor.yy452);
                                                                                  }
        break;
      case 523: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy667 = false; }
        break;
      case 526: /* select_item ::= NK_STAR */
{ yylhsminor.yy452 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy452 = yylhsminor.yy452;
        break;
      case 528: /* select_item ::= common_expression column_alias */
      case 538: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==538);
{ yylhsminor.yy452 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy452), &yymsp[0].minor.yy371); }
  yymsp[-1].minor.yy452 = yylhsminor.yy452;
        break;
      case 529: /* select_item ::= common_expression AS column_alias */
      case 539: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==539);
{ yylhsminor.yy452 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), &yymsp[0].minor.yy371); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 534: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 559: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==559);
      case 579: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==579);
{ yymsp[-2].minor.yy812 = yymsp[0].minor.yy812; }
        break;
      case 541: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy452 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), releaseRawExprNode(pCxt, yymsp[-1].minor.yy452)); }
        break;
      case 542: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy452 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy452)); }
        break;
      case 543: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy452 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), NULL, yymsp[-1].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 544: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy452 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy452), releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), yymsp[-1].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 545: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy452 = createEventWindowNode(pCxt, yymsp[-3].minor.yy452, yymsp[0].minor.yy452); }
        break;
      case 549: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy452 = createFillNode(pCxt, yymsp[-1].minor.yy844, NULL); }
        break;
      case 550: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA expression_list NK_RP */
{ yymsp[-5].minor.yy452 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy812)); }
        break;
      case 551: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA expression_list NK_RP */
{ yymsp[-5].minor.yy452 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy812)); }
        break;
      case 552: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy844 = FILL_MODE_NONE; }
        break;
      case 553: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy844 = FILL_MODE_PREV; }
        break;
      case 554: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy844 = FILL_MODE_NULL; }
        break;
      case 555: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy844 = FILL_MODE_NULL_F; }
        break;
      case 556: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy844 = FILL_MODE_LINEAR; }
        break;
      case 557: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy844 = FILL_MODE_NEXT; }
        break;
      case 560: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy812 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy452))); }
  yymsp[0].minor.yy812 = yylhsminor.yy812;
        break;
      case 561: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy812 = addNodeToList(pCxt, yymsp[-2].minor.yy812, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy452))); }
  yymsp[-2].minor.yy812 = yylhsminor.yy812;
        break;
      case 565: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy452 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy452), releaseRawExprNode(pCxt, yymsp[-1].minor.yy452)); }
        break;
      case 566: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy452 = createInterpTimePoint(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy452)); }
        break;
      case 569: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy452 = addOrderByClause(pCxt, yymsp[-3].minor.yy452, yymsp[-2].minor.yy812);
                                                                                    yylhsminor.yy452 = addSlimitClause(pCxt, yylhsminor.yy452, yymsp[-1].minor.yy452);
                                                                                    yylhsminor.yy452 = addLimitClause(pCxt, yylhsminor.yy452, yymsp[0].minor.yy452);
                                                                                  }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 572: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy452 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy452, yymsp[0].minor.yy452); }
  yymsp[-3].minor.yy452 = yylhsminor.yy452;
        break;
      case 573: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy452 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy452, yymsp[0].minor.yy452); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 581: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 585: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==585);
{ yymsp[-1].minor.yy452 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 582: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 586: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==586);
{ yymsp[-3].minor.yy452 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 583: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 587: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==587);
{ yymsp[-3].minor.yy452 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 588: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy452 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy452); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 593: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy452 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy452), yymsp[-1].minor.yy690, yymsp[0].minor.yy399); }
  yymsp[-2].minor.yy452 = yylhsminor.yy452;
        break;
      case 594: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy690 = ORDER_ASC; }
        break;
      case 595: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy690 = ORDER_ASC; }
        break;
      case 596: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy690 = ORDER_DESC; }
        break;
      case 597: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy399 = NULL_ORDER_DEFAULT; }
        break;
      case 598: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy399 = NULL_ORDER_FIRST; }
        break;
      case 599: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy399 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
