/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 313
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  SToken yy21;
  bool yy173;
  EOrder yy256;
  EFillMode yy268;
  SDataType yy288;
  SAlterOption yy289;
  EJoinType yy440;
  EOperatorType yy468;
  SNodeList* yy476;
  ENullOrder yy525;
  SNode* yy564;
  int32_t yy620;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYNSTATE             547
#define YYNRULE              409
#define YYNRULE_WITH_ACTION  409
#define YYNTOKEN             207
#define YY_MAX_SHIFT         546
#define YY_MIN_SHIFTREDUCE   806
#define YY_MAX_SHIFTREDUCE   1214
#define YY_ERROR_ACTION      1215
#define YY_ACCEPT_ACTION     1216
#define YY_NO_ACTION         1217
#define YY_MIN_REDUCE        1218
#define YY_MAX_REDUCE        1626
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (1529)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */    25,  194, 1478, 1327,  257,  449, 1494,  462,  269,  312,
 /*    10 */   277, 1427,   30,   28, 1474, 1481,  310, 1418, 1420, 1454,
 /*    20 */   266, 1478, 1050,  274,  429,   32,   31,   29,   27,   26,
 /*    30 */  1511,   21, 1338, 1474, 1480,  306,  461,  445, 1048,  238,
 /*    40 */  1478,   32,   31,   29,   27,   26, 1072,  448,   23,  100,
 /*    50 */    11, 1465, 1474, 1480, 1494,  289,  433, 1055,   32,   31,
 /*    60 */    29,   27,   26,   30,   28, 1157, 1605,  228, 1495, 1496,
 /*    70 */  1500,  266,  216, 1050,    1, 1368,   30,   28, 1511,  131,
 /*    80 */  1558,  137,   98, 1603,  266,  445, 1050, 1605, 1171, 1048,
 /*    90 */    52,  431,  127, 1551, 1552,  448, 1556,  543, 1555, 1465,
 /*   100 */   131,   11, 1048,   96, 1603, 1073, 1216,   50, 1055, 1049,
 /*   110 */    49, 1333,  380,  379,   11,   70, 1495, 1496, 1500, 1544,
 /*   120 */   461, 1055,  347, 1543, 1540,    1, 1219,  932,  485,  484,
 /*   130 */   483,  936,  482,  938,  939,  481,  941,  478,    1,  947,
 /*   140 */   475,  949,  950,  472,  469, 1051,  488,   84,  543, 1329,
 /*   150 */    83,   82,   81,   80,   79,   78,   77,   76,   75,  282,
 /*   160 */  1049,  543, 1054, 1074, 1075, 1101, 1102, 1103, 1104, 1105,
 /*   170 */  1106, 1107, 1108, 1049,   12, 1050,  462, 1070,  164,   30,
 /*   180 */    28,  117,  371, 1230,  132,  311,  382,  266,  376, 1050,
 /*   190 */  1605, 1048,  381,  405, 1465,   97, 1051,  377,  375,  157,
 /*   200 */   378, 1338,  155,  131,  373, 1048,  305, 1603,  304, 1051,
 /*   210 */  1055,  396,  461, 1054, 1074, 1075, 1101, 1102, 1103, 1104,
 /*   220 */  1105, 1106, 1107, 1108, 1055,  419, 1054, 1074, 1075, 1101,
 /*   230 */  1102, 1103, 1104, 1105, 1106, 1107, 1108,  406,  462, 1181,
 /*   240 */   132,    7, 1605,   30,   28,  447,  132,   72, 1074, 1075,
 /*   250 */   543,  266,  462, 1050,  368,  131,  894,   30,   28, 1603,
 /*   260 */  1076,  319, 1049, 1338,  543,  266,   12, 1050, 1605, 1048,
 /*   270 */   416, 1179, 1180, 1182, 1183,  896, 1049, 1338,   52,  424,
 /*   280 */   420,  131, 1494, 1048,  132, 1603,   84, 1605, 1055,   83,
 /*   290 */    82,   81,   80,   79,   78,   77,   76,   75, 1051, 1334,
 /*   300 */  1604,  333, 1055,   65, 1603,    7, 1511,   32,   31,   29,
 /*   310 */    27,   26, 1051,  445, 1511, 1054,  118,  101, 1241,    7,
 /*   320 */  1296,  445,  423,  448, 1330, 1494, 1316, 1465,  543, 1054,
 /*   330 */  1074, 1075, 1101, 1102, 1103, 1104, 1105, 1106, 1107, 1108,
 /*   340 */  1049,  132,  543,  119, 1495, 1496, 1500,  141,  140, 1511,
 /*   350 */   237,  132, 1070,  422, 1049,  462,  445,  122,  497,  326,
 /*   360 */   462, 1558,  338, 1465,  320, 1071,  448,  429, 1378,  346,
 /*   370 */  1465,  339, 1385,  265, 1240,  347, 1051,  189,  256, 1554,
 /*   380 */  1338,  434, 1618, 1383,   59, 1338,  229, 1495, 1496, 1500,
 /*   390 */  1051,  499,  100, 1054, 1074, 1075, 1101, 1102, 1103, 1104,
 /*   400 */  1105, 1106, 1107, 1108,  843, 1331,  842, 1054, 1074, 1075,
 /*   410 */  1101, 1102, 1103, 1104, 1105, 1106, 1107, 1108,  462, 1465,
 /*   420 */    30,   28, 1385, 1385,  844,   98, 1239, 1335,  266,  271,
 /*   430 */  1050, 1267,  114, 1419, 1383,  128, 1551, 1552, 1415, 1556,
 /*   440 */    29,   27,   26, 1338,  337,  139, 1048,  332,  331,  330,
 /*   450 */   329,  328, 1485,  325,  324,  323,  322,  318,  317,  316,
 /*   460 */   315,  314,  313,  462, 1483, 1055,   32,   31,   29,   27,
 /*   470 */    26, 1465,  459,  539,  538,   32,   31,   29,   27,   26,
 /*   480 */   250, 1323,    1,  519,  518,  517,  516,  281, 1338,  515,
 /*   490 */   514,  513,  102,  508,  507,  506,  505,  504,  503,  502,
 /*   500 */   501,  108, 1494,  462,  241,  543,  164,  511,  115,  462,
 /*   510 */   371,  300,   72,  241,  449,  270, 1341, 1049,  460,  374,
 /*   520 */  1428, 1325,  251,  115,  249,  248, 1511,  370, 1338, 1089,
 /*   530 */  1218, 1340,  373,  445, 1338,  842,  276, 1120,   32,   31,
 /*   540 */    29,   27,   26,  448,  115,  404, 1120, 1465,    9,    8,
 /*   550 */  1558,  366, 1340, 1051,   93,   92,   91,   90,   89,   88,
 /*   560 */    87,   86,   85,  225, 1495, 1496, 1500, 1314, 1553, 1122,
 /*   570 */  1054, 1074, 1075, 1101, 1102, 1103, 1104, 1105, 1106, 1107,
 /*   580 */  1108,  387, 1164,  279,  462, 1121, 1385, 1126, 1072,  462,
 /*   590 */   116,  115,  278,  208, 1121,  222,  395, 1383,  280, 1340,
 /*   600 */  1238, 1089,  868, 1125, 1237,    6, 1236,  220, 1270, 1338,
 /*   610 */   166,   22, 1125,  390, 1338, 1385,  497,  500,  384, 1310,
 /*   620 */   142,  869, 1133, 1494,  165, 1235, 1384,   24,  264, 1115,
 /*   630 */  1116, 1117, 1118, 1119, 1123, 1124,   24,  264, 1115, 1116,
 /*   640 */  1117, 1118, 1119, 1123, 1124, 1465, 1077, 1511, 1156, 1465,
 /*   650 */    42, 1465, 1234,   41,  445,   32,   31,   29,   27,   26,
 /*   660 */   382, 1233,  376,  106,  448, 1321,  381,  408, 1465,   97,
 /*   670 */  1465,  377,  375,  433,  378,  512,  510, 1494, 1232, 1229,
 /*   680 */  1228, 1227,  436,   67,   68, 1495, 1496, 1500, 1544, 1226,
 /*   690 */   273,  272,  240, 1540,  394,    9,    8, 1465, 1225, 1224,
 /*   700 */  1063, 1511, 1563, 1152, 1605, 1223, 1465,  392,  432, 1222,
 /*   710 */    48,   47,  309, 1221,  136,  297, 1056,  131,  448,  303,
 /*   720 */   437, 1603, 1465, 1465, 1465, 1465, 1465,  246, 1494,  295,
 /*   730 */   299,  291,  287,  133, 1465, 1055,  440,  444,   69, 1495,
 /*   740 */  1496, 1500, 1544, 1465, 1465, 1152,  259, 1540,  126,  169,
 /*   750 */  1465,  546, 1511,   44, 1465, 1231,  132, 1178, 1465,  432,
 /*   760 */   190,  159,  446,  175,  158,  213,  412, 1571,   95,  448,
 /*   770 */    64, 1494, 1257, 1465,  535,  463,  531,  527,  523,  212,
 /*   780 */    61,  161,  163, 1494,  160,  162,  487, 1059, 1252,   69,
 /*   790 */  1495, 1496, 1500, 1544,  383, 1511, 1494,  259, 1540,  126,
 /*   800 */  1250, 1297,  445, 1213, 1214,   66,  417, 1511,  206,  191,
 /*   810 */   385,  342,  448,  178,  445,   33, 1465,  180, 1572, 1127,
 /*   820 */  1511,  403,  388, 1064,  448, 1379,   33,  445, 1465, 1155,
 /*   830 */  1085, 1494,  231, 1495, 1496, 1500,  184,  448,  458, 1058,
 /*   840 */  1067, 1465,  365, 1494,   69, 1495, 1496, 1500, 1544, 1112,
 /*   850 */  1574,  438,  259, 1540, 1617, 1511, 1512,   70, 1495, 1496,
 /*   860 */  1500, 1544,  445, 1578,  430,  411, 1541, 1511,  171,  441,
 /*   870 */  1057,  193,  448, 1070,  445,    2, 1465,   33,  284,  435,
 /*   880 */   245, 1017,  197, 1034,  448,  168,  199,   94, 1465,  894,
 /*   890 */   247,  454,   69, 1495, 1496, 1500, 1544, 1026,  214,  288,
 /*   900 */   259, 1540, 1617, 1494,   69, 1495, 1496, 1500, 1544,  138,
 /*   910 */  1061, 1601,  259, 1540, 1617,  104,  321,  152,  429,  205,
 /*   920 */   125,  106, 1417, 1562,  327,  925,  364, 1511,  360,  356,
 /*   930 */   352,  151,   44,  467,  445,  335,  920,  953,  104, 1494,
 /*   940 */   340, 1060,  957,  100,  448,  334,  336, 1081, 1465,  341,
 /*   950 */  1494, 1080,   32,   31,   29,   27,   26,   53,  344,  144,
 /*   960 */   149, 1079,  433, 1511,   70, 1495, 1496, 1500, 1544,  343,
 /*   970 */   445,  345,  443, 1540, 1511,  105,   98,  147,   51,  963,
 /*   980 */   448,  445,  348,  429, 1465,  106,  187, 1551,  428,  962,
 /*   990 */   427,  448,  104, 1605,  150, 1465,  107, 1078,  413,  367,
 /*  1000 */   232, 1495, 1496, 1500, 1494,  369,  131, 1328,  100, 1494,
 /*  1010 */  1603,  233, 1495, 1496, 1500,  154,  148, 1324,  121,  156,
 /*  1020 */   145,   74,  372,  397,  109,  110, 1326, 1322, 1511,  111,
 /*  1030 */   112,  255,  425, 1511,  398,  445,  407,  143, 1494,  399,
 /*  1040 */   445,   98,  400, 1077,  170,  448,  173,  418,  409, 1465,
 /*  1050 */   448,  129, 1551, 1552, 1465, 1556, 1575,  263, 1585,  452,
 /*  1060 */   410, 1055, 1511, 1584, 1494,  119, 1495, 1496, 1500,  445,
 /*  1070 */   233, 1495, 1496, 1500,  176,  415,    5,  179, 1211,  448,
 /*  1080 */   258,  421, 1565, 1465,  426,  414,  267,   99, 1511,    4,
 /*  1090 */  1076, 1152, 1559,  124,  183,  445,   34,  185,  260,  233,
 /*  1100 */  1495, 1496, 1500,  442, 1619,  448, 1494,  439,   17, 1465,
 /*  1110 */   456, 1494,  186, 1526, 1426,  450,  192, 1494,  455, 1602,
 /*  1120 */   451, 1620, 1425,  201,  268,  234, 1495, 1496, 1500,  215,
 /*  1130 */  1511,  457,  203,   58, 1339, 1511,   60,  445,  217,  465,
 /*  1140 */   494, 1511,  445, 1311,  211, 1210,  542,  448,  445, 1315,
 /*  1150 */    40, 1465,  448,  223,  224,  219, 1465, 1459,  448, 1494,
 /*  1160 */   221, 1458, 1465,  283, 1455,  285,  286,  226, 1495, 1496,
 /*  1170 */  1500, 1494,  235, 1495, 1496, 1500, 1044, 1045,  227, 1495,
 /*  1180 */  1496, 1500,  134, 1511, 1494,  290, 1453, 1452,  292,  293,
 /*  1190 */   445,  294,  296, 1451,  298, 1511, 1442,  135,  301,  302,
 /*  1200 */   448, 1313,  445, 1029, 1465, 1028, 1436, 1435, 1511,  308,
 /*  1210 */   209,  307,  448, 1494,  493,  445, 1465, 1434, 1433, 1000,
 /*  1220 */   236, 1495, 1496, 1500, 1410,  448, 1409, 1408, 1407, 1465,
 /*  1230 */  1406, 1405, 1508, 1495, 1496, 1500,  495, 1511, 1404, 1494,
 /*  1240 */  1403, 1402, 1401, 1400,  445, 1507, 1495, 1496, 1500, 1399,
 /*  1250 */  1398, 1397, 1396, 1395,  448,  492,  491,  490, 1465,  489,
 /*  1260 */   103, 1394,  209, 1511, 1393, 1494,  493, 1392, 1391, 1390,
 /*  1270 */   445, 1389, 1388, 1494,  243, 1495, 1496, 1500, 1002, 1387,
 /*  1280 */   448, 1386, 1269, 1450, 1465, 1444, 1432, 1423,  495, 1511,
 /*  1290 */   146, 1317, 1268, 1266,  350,  861,  445, 1511,  349, 1494,
 /*  1300 */  1506, 1495, 1496, 1500,  445,  351,  448,  492,  491,  490,
 /*  1310 */  1465,  489, 1264,  353,  448, 1262,  354,  355, 1465,  359,
 /*  1320 */  1260,  363,  357, 1511,  358,  362,  244, 1495, 1496, 1500,
 /*  1330 */   445, 1249,  361, 1248,  242, 1495, 1496, 1500, 1245, 1319,
 /*  1340 */   448, 1494,   73,  970, 1465,  968,  153, 1318,  511,  893,
 /*  1350 */  1258,  892,  891, 1253,  890,  887,  886,  252,  253, 1251,
 /*  1360 */   239, 1495, 1496, 1500,  386, 1511,  509,  254,  389, 1244,
 /*  1370 */   391, 1243,  445,  393,   71, 1449,   43,  167, 1036, 1443,
 /*  1380 */   401, 1431,  448,  113, 1430,  402, 1465, 1422,  123,  172,
 /*  1390 */    14,   15,   37,   54, 1483,  174,  177,    3,   33,   38,
 /*  1400 */   182,   35,  230, 1495, 1496, 1500,   56, 1177,  120,   10,
 /*  1410 */   188,  181, 1199,    8,   20,   19, 1198, 1170,   55, 1113,
 /*  1420 */   261, 1203, 1421, 1202, 1149,  453,   36, 1148,  262,  202,
 /*  1430 */   204,   16, 1204,  466, 1065,  275,  470, 1087, 1086,   13,
 /*  1440 */    18,  198,  130,  196,  473, 1175,  200,  195,   61,  931,
 /*  1450 */    45,   57,  476,  479,  965,  959,  875,  540,  961, 1482,
 /*  1460 */   541,  544,   39,  882,  881,  468,  207,  954,  951,  948,
 /*  1470 */   471, 1265,  859,  474,  464,  942,  940,  477,  480,  496,
 /*  1480 */   900,  880,  879,  878,  877,  876,  895,   62,  897,  872,
 /*  1490 */   871,  870,   46,   63,  867,  866,  498,  486,  865,  210,
 /*  1500 */  1263,  864,  520,  521,  946,  525,  945,  944,  943,  522,
 /*  1510 */   524,  526, 1261,  528,  529, 1259,  530,  532,  533,  534,
 /*  1520 */  1247,  536,  537, 1246, 1242, 1052,  964,  218,  545,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   276,  277,  255,  235,  238,  251,  210,  216,  254,  216,
 /*    10 */   243,  257,   12,   13,  267,  268,  225,  250,  251,    0,
 /*    20 */    20,  255,   22,  238,  216,   12,   13,   14,   15,   16,
 /*    30 */   234,    2,  241,  267,  268,  260,   20,  241,   38,  246,
 /*    40 */   255,   12,   13,   14,   15,   16,   20,  251,    2,  241,
 /*    50 */    50,  255,  267,  268,  210,   36,  260,   57,   12,   13,
 /*    60 */    14,   15,   16,   12,   13,   14,  291,  271,  272,  273,
 /*    70 */   274,   20,  227,   22,   74,  230,   12,   13,  234,  304,
 /*    80 */   269,   47,  274,  308,   20,  241,   22,  291,   75,   38,
 /*    90 */   218,  283,  284,  285,  286,  251,  288,   97,  287,  255,
 /*   100 */   304,   50,   38,  231,  308,   20,  207,   73,   57,  109,
 /*   110 */    76,  239,  220,  221,   50,  271,  272,  273,  274,  275,
 /*   120 */    20,   57,   49,  279,  280,   74,    0,   88,   89,   90,
 /*   130 */    91,   92,   93,   94,   95,   96,   97,   98,   74,  100,
 /*   140 */   101,  102,  103,  104,  105,  145,   85,   21,   97,  210,
 /*   150 */    24,   25,   26,   27,   28,   29,   30,   31,   32,  260,
 /*   160 */   109,   97,  162,  163,  164,  165,  166,  167,  168,  169,
 /*   170 */   170,  171,  172,  109,   74,   22,  216,   20,   61,   12,
 /*   180 */    13,  209,   65,  211,  184,  225,   52,   20,   54,   22,
 /*   190 */   291,   38,   58,  216,  255,   61,  145,   63,   64,   78,
 /*   200 */    66,  241,   81,  304,   87,   38,  144,  308,  146,  145,
 /*   210 */    57,  260,   20,  162,  163,  164,  165,  166,  167,  168,
 /*   220 */   169,  170,  171,  172,   57,  135,  162,  163,  164,  165,
 /*   230 */   166,  167,  168,  169,  170,  171,  172,  260,  216,  162,
 /*   240 */   184,   74,  291,   12,   13,   14,  184,  225,  163,  164,
 /*   250 */    97,   20,  216,   22,  232,  304,   38,   12,   13,  308,
 /*   260 */    20,  225,  109,  241,   97,   20,   74,   22,  291,   38,
 /*   270 */   193,  194,  195,  196,  197,   57,  109,  241,  218,  189,
 /*   280 */   190,  304,  210,   38,  184,  308,   21,  291,   57,   24,
 /*   290 */    25,   26,   27,   28,   29,   30,   31,   32,  145,  239,
 /*   300 */   304,   67,   57,  215,  308,   74,  234,   12,   13,   14,
 /*   310 */    15,   16,  145,  241,  234,  162,  219,  229,  210,   74,
 /*   320 */   223,  241,   20,  251,  236,  210,    0,  255,   97,  162,
 /*   330 */   163,  164,  165,  166,  167,  168,  169,  170,  171,  172,
 /*   340 */   109,  184,   97,  271,  272,  273,  274,  113,  114,  234,
 /*   350 */    18,  184,   20,  273,  109,  216,  241,  233,   49,   27,
 /*   360 */   216,  269,   30,  255,  225,   20,  251,  216,  244,  225,
 /*   370 */   255,   39,  234,  258,  210,   49,  145,  137,  240,  287,
 /*   380 */   241,  309,  310,  245,  215,  241,  271,  272,  273,  274,
 /*   390 */   145,   57,  241,  162,  163,  164,  165,  166,  167,  168,
 /*   400 */   169,  170,  171,  172,   20,  236,   22,  162,  163,  164,
 /*   410 */   165,  166,  167,  168,  169,  170,  171,  172,  216,  255,
 /*   420 */    12,   13,  234,  234,   40,  274,  210,  225,   20,  240,
 /*   430 */    22,    0,  137,  245,  245,  284,  285,  286,  241,  288,
 /*   440 */    14,   15,   16,  241,  112,  248,   38,  115,  116,  117,
 /*   450 */   118,  119,   74,  121,  122,  123,  124,  125,  126,  127,
 /*   460 */   128,  129,  130,  216,   86,   57,   12,   13,   14,   15,
 /*   470 */    16,  255,  225,  213,  214,   12,   13,   14,   15,   16,
 /*   480 */    35,  235,   74,   52,   53,   54,   55,   56,  241,   58,
 /*   490 */    59,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   500 */    69,   70,  210,  216,   50,   97,   61,   71,  234,  216,
 /*   510 */    65,   75,  225,   50,  251,  226,  242,  109,  225,  232,
 /*   520 */   257,  235,   77,  234,   79,   80,  234,   82,  241,   75,
 /*   530 */     0,  242,   87,  241,  241,   22,  226,   83,   12,   13,
 /*   540 */    14,   15,   16,  251,  234,  263,   83,  255,    1,    2,
 /*   550 */   269,   38,  242,  145,   24,   25,   26,   27,   28,   29,
 /*   560 */    30,   31,   32,  271,  272,  273,  274,    0,  287,  131,
 /*   570 */   162,  163,  164,  165,  166,  167,  168,  169,  170,  171,
 /*   580 */   172,    4,   14,  226,  216,  131,  234,  149,   20,  216,
 /*   590 */    18,  234,  240,  225,  131,   23,   19,  245,  225,  242,
 /*   600 */   210,   75,   38,  149,  210,   43,  210,   35,    0,  241,
 /*   610 */    33,  173,  149,   36,  241,  234,   49,  222,   41,  224,
 /*   620 */    48,   57,   75,  210,   47,  210,  245,  173,  174,  175,
 /*   630 */   176,  177,  178,  179,  180,  181,  173,  174,  175,  176,
 /*   640 */   177,  178,  179,  180,  181,  255,   20,  234,    4,  255,
 /*   650 */    73,  255,  210,   76,  241,   12,   13,   14,   15,   16,
 /*   660 */    52,  210,   54,   71,  251,  235,   58,   75,  255,   61,
 /*   670 */   255,   63,   64,  260,   66,  220,  221,  210,  210,  210,
 /*   680 */   210,  210,    3,  111,  271,  272,  273,  274,  275,  210,
 /*   690 */    12,   13,  279,  280,   21,    1,    2,  255,  210,  210,
 /*   700 */    22,  234,  182,  183,  291,  210,  255,   34,  241,  210,
 /*   710 */   138,  139,  140,  210,  142,  141,   38,  304,  251,  147,
 /*   720 */    71,  308,  255,  255,  255,  255,  255,  155,  210,  157,
 /*   730 */   156,  159,  160,  161,  255,   57,   71,   50,  271,  272,
 /*   740 */   273,  274,  275,  255,  255,  183,  279,  280,  281,  235,
 /*   750 */   255,   19,  234,   71,  255,  211,  184,   75,  255,  241,
 /*   760 */   293,   78,  235,  137,   81,   33,  299,  300,   36,  251,
 /*   770 */    74,  210,    0,  255,   42,   97,   44,   45,   46,   47,
 /*   780 */    84,   78,   78,  210,   81,   81,  235,  109,    0,  271,
 /*   790 */   272,  273,  274,  275,   22,  234,  210,  279,  280,  281,
 /*   800 */     0,  223,  241,  163,  164,   73,  302,  234,   76,  311,
 /*   810 */    22,  251,  251,   71,  241,   71,  255,   75,  300,   75,
 /*   820 */   234,  251,   22,  145,  251,  244,   71,  241,  255,  185,
 /*   830 */    75,  210,  271,  272,  273,  274,  296,  251,  106,   38,
 /*   840 */   162,  255,  213,  210,  271,  272,  273,  274,  275,  162,
 /*   850 */   270,  202,  279,  280,  281,  234,  234,  271,  272,  273,
 /*   860 */   274,  275,  241,  290,  289,  133,  280,  234,  136,  204,
 /*   870 */    38,  305,  251,   20,  241,  292,  255,   71,  216,  200,
 /*   880 */   266,   75,   71,  151,  251,  153,   75,   71,  255,   38,
 /*   890 */   220,   75,  271,  272,  273,  274,  275,  143,  261,   36,
 /*   900 */   279,  280,  281,  210,  271,  272,  273,  274,  275,  120,
 /*   910 */   109,  290,  279,  280,  281,   71,  216,   33,  216,   75,
 /*   920 */    36,   71,  216,  290,  249,   75,   42,  234,   44,   45,
 /*   930 */    46,   47,   71,   71,  241,  131,   75,   75,   71,  210,
 /*   940 */   216,  109,   75,  241,  251,  247,  247,   20,  255,  265,
 /*   950 */   210,   20,   12,   13,   14,   15,   16,   73,  241,  218,
 /*   960 */    76,   20,  260,  234,  271,  272,  273,  274,  275,  259,
 /*   970 */   241,  252,  279,  280,  234,   71,  274,  218,  218,   75,
 /*   980 */   251,  241,  216,  216,  255,   71,  284,  285,  286,   75,
 /*   990 */   288,  251,   71,  291,  218,  255,   75,   20,  258,  212,
 /*  1000 */   271,  272,  273,  274,  210,  234,  304,  234,  241,  210,
 /*  1010 */   308,  271,  272,  273,  274,  234,  132,  234,  134,  234,
 /*  1020 */   136,  216,  220,  241,  234,  234,  234,  234,  234,  234,
 /*  1030 */   234,  212,  303,  234,  265,  241,  259,  153,  210,  152,
 /*  1040 */   241,  274,  264,   20,  215,  251,  215,  192,  241,  255,
 /*  1050 */   251,  284,  285,  286,  255,  288,  270,  258,  301,  191,
 /*  1060 */   252,   57,  234,  301,  210,  271,  272,  273,  274,  241,
 /*  1070 */   271,  272,  273,  274,  256,  255,  199,  256,  138,  251,
 /*  1080 */   255,  255,  298,  255,  198,  187,  258,  241,  234,  186,
 /*  1090 */    20,  183,  269,  295,  297,  241,  120,  294,  206,  271,
 /*  1100 */   272,  273,  274,  203,  310,  251,  210,  201,   74,  255,
 /*  1110 */   253,  210,  282,  278,  256,  255,  306,  210,  134,  307,
 /*  1120 */   255,  312,  256,  241,  255,  271,  272,  273,  274,  230,
 /*  1130 */   234,  252,  215,  215,  241,  234,   74,  241,  216,  237,
 /*  1140 */   220,  234,  241,  224,  215,  205,  212,  251,  241,    0,
 /*  1150 */   262,  255,  251,  228,  228,  217,  255,    0,  251,  210,
 /*  1160 */   208,    0,  255,   64,    0,   38,  158,  271,  272,  273,
 /*  1170 */   274,  210,  271,  272,  273,  274,   38,   38,  271,  272,
 /*  1180 */   273,  274,   38,  234,  210,  158,    0,    0,   38,   38,
 /*  1190 */   241,  158,   38,    0,   38,  234,    0,   74,  149,  148,
 /*  1200 */   251,    0,  241,  109,  255,  145,    0,    0,  234,  141,
 /*  1210 */    61,   53,  251,  210,   65,  241,  255,    0,    0,   86,
 /*  1220 */   271,  272,  273,  274,    0,  251,    0,    0,    0,  255,
 /*  1230 */     0,    0,  271,  272,  273,  274,   87,  234,    0,  210,
 /*  1240 */     0,    0,    0,    0,  241,  271,  272,  273,  274,    0,
 /*  1250 */     0,    0,    0,    0,  251,  106,  107,  108,  255,  110,
 /*  1260 */   120,    0,   61,  234,    0,  210,   65,    0,    0,    0,
 /*  1270 */   241,    0,    0,  210,  271,  272,  273,  274,   22,    0,
 /*  1280 */   251,    0,    0,    0,  255,    0,    0,    0,   87,  234,
 /*  1290 */    43,    0,    0,    0,   36,   51,  241,  234,   38,  210,
 /*  1300 */   271,  272,  273,  274,  241,   43,  251,  106,  107,  108,
 /*  1310 */   255,  110,    0,   38,  251,    0,   36,   43,  255,   43,
 /*  1320 */     0,   43,   38,  234,   36,   36,  271,  272,  273,  274,
 /*  1330 */   241,    0,   38,    0,  271,  272,  273,  274,    0,    0,
 /*  1340 */   251,  210,   83,   38,  255,   22,   81,    0,   71,   38,
 /*  1350 */     0,   38,   38,    0,   38,   38,   38,   22,   22,    0,
 /*  1360 */   271,  272,  273,  274,   39,  234,   71,   22,   38,    0,
 /*  1370 */    22,    0,  241,   22,   20,    0,  137,  154,   38,    0,
 /*  1380 */    22,    0,  251,  150,    0,  137,  255,    0,  134,   43,
 /*  1390 */   188,  188,  137,   74,   86,  132,   75,   71,   71,   71,
 /*  1400 */    71,  182,  271,  272,  273,  274,    4,   75,   74,  188,
 /*  1410 */    86,   74,   38,    2,   71,   74,   38,   75,   74,  162,
 /*  1420 */    38,   38,    0,   38,   75,  135,   71,   75,   38,   43,
 /*  1430 */   132,   71,   75,   38,   22,   38,   38,   75,   75,   74,
 /*  1440 */    74,   74,   86,   75,   38,   75,   74,   86,   84,   22,
 /*  1450 */    74,   74,   38,   38,   38,   22,   22,   22,   38,   86,
 /*  1460 */    21,   21,   74,   38,   38,   74,   86,   75,   75,   75,
 /*  1470 */    74,    0,   51,   74,   85,   75,   75,   74,   74,   50,
 /*  1480 */    57,   38,   38,   38,   38,   38,   38,   74,   57,   38,
 /*  1490 */    38,   38,   74,   74,   38,   38,   72,   87,   38,   71,
 /*  1500 */     0,   38,   38,   36,   99,   36,   99,   99,   99,   43,
 /*  1510 */    38,   43,    0,   38,   36,    0,   43,   38,   36,   43,
 /*  1520 */     0,   38,   37,    0,    0,   22,  109,   22,   20,  313,
 /*  1530 */   313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
 /*  1540 */   313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
 /*  1550 */   313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
 /*  1560 */   313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
 /*  1570 */   313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
 /*  1580 */   313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
 /*  1590 */   313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
 /*  1600 */   313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
 /*  1610 */   313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
 /*  1620 */   313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
 /*  1630 */   313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
 /*  1640 */   313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
 /*  1650 */   313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
 /*  1660 */   313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
 /*  1670 */   313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
 /*  1680 */   313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
 /*  1690 */   313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
 /*  1700 */   313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
 /*  1710 */   313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
 /*  1720 */   313,  313,  313,  313,  313,  313,  313,  313,  313,  313,
 /*  1730 */   313,  313,  313,  313,  313,  313,
};
#define YY_SHIFT_COUNT    (546)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1524)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   572,    0,   51,   64,   64,   64,   64,  167,   64,   64,
 /*    10 */   245,  408,  100,  231,  245,  245,  245,  245,  245,  245,
 /*    20 */   245,  245,  245,  245,  245,  245,  245,  245,  245,  245,
 /*    30 */   245,  245,  245,  245,  192,  192,  192,  157,  678,  678,
 /*    40 */    62,   16,   16,   56,  678,   85,   85,   16,   16,   16,
 /*    50 */    16,   16,   16,   73,   26,  302,   56,   26,   16,   16,
 /*    60 */    26,   16,   26,   26,   26,   16,  309,  332,  454,  463,
 /*    70 */   463,  265,  445,  153,  134,  153,  153,  153,  153,  153,
 /*    80 */   153,  153,  153,  153,  153,  153,  153,  153,  153,  153,
 /*    90 */   153,  153,  153,  153,   85,  384,  326,  218,  240,  240,
 /*   100 */   240,  567,  218,  345,   26,   26,   26,   61,  334,   39,
 /*   110 */    39,   39,   39,   39,   39,   39,  732,  126,  608,  940,
 /*   120 */    77,   85,  117,   85,   90,  513,  626,  520,  562,  520,
 /*   130 */   568,  679,  644,  853,  863,  851,  754,  853,  853,  789,
 /*   140 */   804,  804,  853,  927,  931,   73,  345,  941,   73,   73,
 /*   150 */   853,   73,  977,   26,   26,   26,   26,   26,   26,   26,
 /*   160 */    26,   26,   26,   26,  851,  853,  977,  345,  927,  887,
 /*   170 */   931,  309,  345,  941,  309, 1023,  855,  868, 1004,  855,
 /*   180 */   868, 1004, 1004,  877,  886,  898,  903,  908,  345, 1070,
 /*   190 */   976,  892,  900,  906, 1034,   26,  868, 1004, 1004,  868,
 /*   200 */  1004,  984,  345,  941,  309,   61,  309,  345, 1062,  851,
 /*   210 */   334,  853,  309,  977, 1529, 1529, 1529, 1529, 1529,  431,
 /*   220 */   884,  530,  577, 1149, 1201,   13,   29,   46,  526,  295,
 /*   230 */   643,  643,  643,  643,  643,  643,  643,   34,  234,  426,
 /*   240 */   547,  438,  426,  426,  426,   19,  574,  436,  121,  683,
 /*   250 */   703,  704,  772,  788,  800,  673,  592,  682,  742,  694,
 /*   260 */   640,  649,  665,  744,  687,  755,  378,  806,  811,  816,
 /*   270 */   844,  850,  801,  832,  861,  862,  867,  904,  914,  921,
 /*   280 */   696,  564, 1157, 1161, 1099, 1164, 1127, 1008, 1138, 1139,
 /*   290 */  1144, 1027, 1186, 1150, 1151, 1033, 1187, 1154, 1193, 1156,
 /*   300 */  1196, 1123, 1049, 1051, 1094, 1060, 1206, 1207, 1158, 1068,
 /*   310 */  1217, 1218, 1133, 1224, 1226, 1227, 1228, 1230, 1231, 1238,
 /*   320 */  1240, 1241, 1242, 1243, 1249, 1250, 1251, 1252, 1140, 1253,
 /*   330 */  1261, 1264, 1267, 1268, 1269, 1256, 1271, 1272, 1279, 1281,
 /*   340 */  1282, 1283, 1285, 1286, 1287, 1247, 1291, 1244, 1292, 1293,
 /*   350 */  1260, 1258, 1262, 1312, 1275, 1280, 1274, 1315, 1284, 1288,
 /*   360 */  1276, 1320, 1294, 1289, 1278, 1331, 1333, 1338, 1339, 1259,
 /*   370 */  1265, 1305, 1277, 1323, 1347, 1311, 1313, 1314, 1316, 1295,
 /*   380 */  1277, 1317, 1318, 1350, 1335, 1353, 1336, 1325, 1359, 1345,
 /*   390 */  1330, 1369, 1348, 1371, 1351, 1354, 1375, 1239, 1223, 1340,
 /*   400 */  1379, 1233, 1358, 1248, 1254, 1381, 1384, 1255, 1387, 1319,
 /*   410 */  1346, 1263, 1326, 1327, 1202, 1321, 1328, 1332, 1334, 1337,
 /*   420 */  1341, 1342, 1329, 1308, 1344, 1343, 1203, 1349, 1352, 1324,
 /*   430 */  1219, 1355, 1356, 1357, 1360, 1221, 1402, 1374, 1378, 1382,
 /*   440 */  1383, 1385, 1390, 1411, 1257, 1361, 1362, 1363, 1365, 1366,
 /*   450 */  1368, 1370, 1367, 1372, 1290, 1376, 1422, 1386, 1298, 1377,
 /*   460 */  1364, 1373, 1380, 1412, 1388, 1389, 1392, 1395, 1397, 1391,
 /*   470 */  1393, 1398, 1396, 1394, 1406, 1399, 1400, 1414, 1403, 1401,
 /*   480 */  1415, 1404, 1405, 1407, 1408, 1409, 1427, 1410, 1413, 1416,
 /*   490 */  1417, 1418, 1419, 1420, 1277, 1433, 1421, 1429, 1423, 1424,
 /*   500 */  1428, 1425, 1426, 1443, 1444, 1445, 1446, 1447, 1434, 1431,
 /*   510 */  1295, 1448, 1277, 1451, 1452, 1453, 1456, 1457, 1460, 1463,
 /*   520 */  1471, 1464, 1467, 1466, 1500, 1472, 1469, 1468, 1512, 1475,
 /*   530 */  1478, 1473, 1515, 1479, 1482, 1476, 1520, 1483, 1485, 1523,
 /*   540 */  1524, 1435, 1439, 1503, 1505, 1440, 1508,
};
#define YY_REDUCE_COUNT (218)
#define YY_REDUCE_MIN   (-276)
#define YY_REDUCE_MAX   (1131)
static const short yy_reduce_ofst[] = {
 /*     0 */  -101,  413,  467,  518,  573,  621,  633, -204, -156,  693,
 /*    10 */    72,  586,  702,  115,  740,  729,  794,  799,  828,  292,
 /*    20 */   561,  854,  896,  901,  907,  949,  961,  974, 1003, 1029,
 /*    30 */  1055, 1063, 1089, 1131, -192,  151,  767,  -23, -234, -215,
 /*    40 */  -225,   22,  287,  -49, -253, -246, -233, -209,  -40,   36,
 /*    50 */   139,  144,  202, -128,  138,   80,   -4,  289,  247,  293,
 /*    60 */   189,  368,  310,  352,  357,  373,   88, -207, -276, -276,
 /*    70 */  -276,  -28,  124,  -61,   97,  108,  164,  216,  390,  394,
 /*    80 */   396,  415,  442,  451,  468,  469,  470,  471,  479,  488,
 /*    90 */   489,  495,  499,  503,  263,  260,   60, -108, -189,   92,
 /*   100 */   281,  169,  455,  197,  274,  188,  381, -155,  395, -232,
 /*   110 */   246,  286,  430,  514,  527,  551,  282,  544,  578,  498,
 /*   120 */   504,  560,  581,  570,  540,  629,  580,  575,  575,  575,
 /*   130 */   622,  566,  583,  662,  614,  670,  637,  700,  706,  675,
 /*   140 */   698,  699,  724,  684,  710,  741,  717,  719,  759,  760,
 /*   150 */   766,  776,  787,  771,  773,  781,  783,  785,  790,  791,
 /*   160 */   792,  793,  795,  796,  802,  805,  819,  782,  769,  778,
 /*   170 */   777,  829,  807,  808,  831,  786,  757,  818,  820,  762,
 /*   180 */   821,  825,  826,  784,  797,  798,  803,  575,  846,  823,
 /*   190 */   830,  809,  812,  810,  835,  622,  858,  860,  865,  866,
 /*   200 */   869,  857,  882,  879,  917,  899,  918,  893,  902,  920,
 /*   210 */   919,  922,  929,  934,  888,  925,  926,  938,  952,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*    10 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*    20 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*    30 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*    40 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*    50 */  1215, 1215, 1215, 1274, 1215, 1215, 1215, 1215, 1215, 1215,
 /*    60 */  1215, 1215, 1215, 1215, 1215, 1215, 1272, 1411, 1215, 1546,
 /*    70 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*    80 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*    90 */  1215, 1215, 1215, 1215, 1215, 1215, 1274, 1215, 1557, 1557,
 /*   100 */  1557, 1272, 1215, 1215, 1215, 1215, 1215, 1367, 1215, 1215,
 /*   110 */  1215, 1215, 1215, 1215, 1215, 1215, 1445, 1215, 1215, 1621,
 /*   120 */  1215, 1215, 1320, 1215, 1581, 1215, 1573, 1549, 1563, 1550,
 /*   130 */  1215, 1606, 1566, 1215, 1215, 1215, 1437, 1215, 1215, 1416,
 /*   140 */  1413, 1413, 1215, 1215, 1215, 1274, 1215, 1215, 1274, 1274,
 /*   150 */  1215, 1274, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   160 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1447,
 /*   170 */  1215, 1272, 1215, 1215, 1272, 1215, 1588, 1586, 1215, 1588,
 /*   180 */  1586, 1215, 1215, 1600, 1596, 1579, 1577, 1563, 1215, 1215,
 /*   190 */  1215, 1624, 1612, 1608, 1215, 1215, 1586, 1215, 1215, 1586,
 /*   200 */  1215, 1424, 1215, 1215, 1272, 1215, 1272, 1215, 1336, 1215,
 /*   210 */  1215, 1215, 1272, 1215, 1439, 1370, 1370, 1275, 1220, 1215,
 /*   220 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1509,
 /*   230 */  1510, 1599, 1598, 1509, 1523, 1522, 1521, 1215, 1215, 1504,
 /*   240 */  1215, 1215, 1505, 1503, 1502, 1215, 1215, 1215, 1215, 1215,
 /*   250 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1547,
 /*   260 */  1215, 1609, 1613, 1215, 1215, 1215, 1484, 1215, 1215, 1215,
 /*   270 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   280 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   290 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   300 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   310 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   320 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   330 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   340 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   350 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   360 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   370 */  1215, 1215, 1381, 1215, 1215, 1215, 1215, 1215, 1215, 1301,
 /*   380 */  1300, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   390 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   400 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   410 */  1215, 1215, 1570, 1580, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   420 */  1215, 1215, 1215, 1484, 1215, 1597, 1215, 1556, 1552, 1215,
 /*   430 */  1215, 1548, 1215, 1215, 1607, 1215, 1215, 1215, 1215, 1215,
 /*   440 */  1215, 1215, 1215, 1542, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   450 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   460 */  1215, 1483, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1364,
 /*   470 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   480 */  1215, 1215, 1349, 1347, 1346, 1345, 1215, 1342, 1215, 1215,
 /*   490 */  1215, 1215, 1215, 1215, 1372, 1215, 1215, 1215, 1215, 1215,
 /*   500 */  1295, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   510 */  1286, 1215, 1285, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   520 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   530 */  1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215, 1215,
 /*   540 */  1215, 1215, 1215, 1215, 1215, 1215, 1215,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "DNODE",
  /*   37 */ "PORT",
  /*   38 */ "NK_INTEGER",
  /*   39 */ "DNODES",
  /*   40 */ "NK_IPTOKEN",
  /*   41 */ "LOCAL",
  /*   42 */ "QNODE",
  /*   43 */ "ON",
  /*   44 */ "BNODE",
  /*   45 */ "SNODE",
  /*   46 */ "MNODE",
  /*   47 */ "DATABASE",
  /*   48 */ "USE",
  /*   49 */ "IF",
  /*   50 */ "NOT",
  /*   51 */ "EXISTS",
  /*   52 */ "BLOCKS",
  /*   53 */ "CACHE",
  /*   54 */ "CACHELAST",
  /*   55 */ "COMP",
  /*   56 */ "DAYS",
  /*   57 */ "NK_VARIABLE",
  /*   58 */ "FSYNC",
  /*   59 */ "MAXROWS",
  /*   60 */ "MINROWS",
  /*   61 */ "KEEP",
  /*   62 */ "PRECISION",
  /*   63 */ "QUORUM",
  /*   64 */ "REPLICA",
  /*   65 */ "TTL",
  /*   66 */ "WAL",
  /*   67 */ "VGROUPS",
  /*   68 */ "SINGLE_STABLE",
  /*   69 */ "STREAM_MODE",
  /*   70 */ "RETENTIONS",
  /*   71 */ "NK_COMMA",
  /*   72 */ "NK_COLON",
  /*   73 */ "TABLE",
  /*   74 */ "NK_LP",
  /*   75 */ "NK_RP",
  /*   76 */ "STABLE",
  /*   77 */ "ADD",
  /*   78 */ "COLUMN",
  /*   79 */ "MODIFY",
  /*   80 */ "RENAME",
  /*   81 */ "TAG",
  /*   82 */ "SET",
  /*   83 */ "NK_EQ",
  /*   84 */ "USING",
  /*   85 */ "TAGS",
  /*   86 */ "NK_DOT",
  /*   87 */ "COMMENT",
  /*   88 */ "BOOL",
  /*   89 */ "TINYINT",
  /*   90 */ "SMALLINT",
  /*   91 */ "INT",
  /*   92 */ "INTEGER",
  /*   93 */ "BIGINT",
  /*   94 */ "FLOAT",
  /*   95 */ "DOUBLE",
  /*   96 */ "BINARY",
  /*   97 */ "TIMESTAMP",
  /*   98 */ "NCHAR",
  /*   99 */ "UNSIGNED",
  /*  100 */ "JSON",
  /*  101 */ "VARCHAR",
  /*  102 */ "MEDIUMBLOB",
  /*  103 */ "BLOB",
  /*  104 */ "VARBINARY",
  /*  105 */ "DECIMAL",
  /*  106 */ "SMA",
  /*  107 */ "ROLLUP",
  /*  108 */ "FILE_FACTOR",
  /*  109 */ "NK_FLOAT",
  /*  110 */ "DELAY",
  /*  111 */ "SHOW",
  /*  112 */ "DATABASES",
  /*  113 */ "TABLES",
  /*  114 */ "STABLES",
  /*  115 */ "MNODES",
  /*  116 */ "MODULES",
  /*  117 */ "QNODES",
  /*  118 */ "FUNCTIONS",
  /*  119 */ "INDEXES",
  /*  120 */ "FROM",
  /*  121 */ "ACCOUNTS",
  /*  122 */ "APPS",
  /*  123 */ "CONNECTIONS",
  /*  124 */ "LICENCE",
  /*  125 */ "QUERIES",
  /*  126 */ "SCORES",
  /*  127 */ "TOPICS",
  /*  128 */ "VARIABLES",
  /*  129 */ "BNODES",
  /*  130 */ "SNODES",
  /*  131 */ "LIKE",
  /*  132 */ "INDEX",
  /*  133 */ "FULLTEXT",
  /*  134 */ "FUNCTION",
  /*  135 */ "INTERVAL",
  /*  136 */ "TOPIC",
  /*  137 */ "AS",
  /*  138 */ "DESC",
  /*  139 */ "DESCRIBE",
  /*  140 */ "RESET",
  /*  141 */ "QUERY",
  /*  142 */ "EXPLAIN",
  /*  143 */ "ANALYZE",
  /*  144 */ "VERBOSE",
  /*  145 */ "NK_BOOL",
  /*  146 */ "RATIO",
  /*  147 */ "COMPACT",
  /*  148 */ "VNODES",
  /*  149 */ "IN",
  /*  150 */ "OUTPUTTYPE",
  /*  151 */ "AGGREGATE",
  /*  152 */ "BUFSIZE",
  /*  153 */ "STREAM",
  /*  154 */ "INTO",
  /*  155 */ "KILL",
  /*  156 */ "CONNECTION",
  /*  157 */ "MERGE",
  /*  158 */ "VGROUP",
  /*  159 */ "REDISTRIBUTE",
  /*  160 */ "SPLIT",
  /*  161 */ "SYNCDB",
  /*  162 */ "NULL",
  /*  163 */ "FIRST",
  /*  164 */ "LAST",
  /*  165 */ "NOW",
  /*  166 */ "ROWTS",
  /*  167 */ "TBNAME",
  /*  168 */ "QSTARTTS",
  /*  169 */ "QENDTS",
  /*  170 */ "WSTARTTS",
  /*  171 */ "WENDTS",
  /*  172 */ "WDURATION",
  /*  173 */ "BETWEEN",
  /*  174 */ "IS",
  /*  175 */ "NK_LT",
  /*  176 */ "NK_GT",
  /*  177 */ "NK_LE",
  /*  178 */ "NK_GE",
  /*  179 */ "NK_NE",
  /*  180 */ "MATCH",
  /*  181 */ "NMATCH",
  /*  182 */ "JOIN",
  /*  183 */ "INNER",
  /*  184 */ "SELECT",
  /*  185 */ "DISTINCT",
  /*  186 */ "WHERE",
  /*  187 */ "PARTITION",
  /*  188 */ "BY",
  /*  189 */ "SESSION",
  /*  190 */ "STATE_WINDOW",
  /*  191 */ "SLIDING",
  /*  192 */ "FILL",
  /*  193 */ "VALUE",
  /*  194 */ "NONE",
  /*  195 */ "PREV",
  /*  196 */ "LINEAR",
  /*  197 */ "NEXT",
  /*  198 */ "GROUP",
  /*  199 */ "HAVING",
  /*  200 */ "ORDER",
  /*  201 */ "SLIMIT",
  /*  202 */ "SOFFSET",
  /*  203 */ "LIMIT",
  /*  204 */ "OFFSET",
  /*  205 */ "ASC",
  /*  206 */ "NULLS",
  /*  207 */ "cmd",
  /*  208 */ "account_options",
  /*  209 */ "alter_account_options",
  /*  210 */ "literal",
  /*  211 */ "alter_account_option",
  /*  212 */ "user_name",
  /*  213 */ "dnode_endpoint",
  /*  214 */ "dnode_host_name",
  /*  215 */ "not_exists_opt",
  /*  216 */ "db_name",
  /*  217 */ "db_options",
  /*  218 */ "exists_opt",
  /*  219 */ "alter_db_options",
  /*  220 */ "integer_list",
  /*  221 */ "variable_list",
  /*  222 */ "retention_list",
  /*  223 */ "alter_db_option",
  /*  224 */ "retention",
  /*  225 */ "full_table_name",
  /*  226 */ "column_def_list",
  /*  227 */ "tags_def_opt",
  /*  228 */ "table_options",
  /*  229 */ "multi_create_clause",
  /*  230 */ "tags_def",
  /*  231 */ "multi_drop_clause",
  /*  232 */ "alter_table_clause",
  /*  233 */ "alter_table_options",
  /*  234 */ "column_name",
  /*  235 */ "type_name",
  /*  236 */ "create_subtable_clause",
  /*  237 */ "specific_tags_opt",
  /*  238 */ "literal_list",
  /*  239 */ "drop_table_clause",
  /*  240 */ "col_name_list",
  /*  241 */ "table_name",
  /*  242 */ "column_def",
  /*  243 */ "func_name_list",
  /*  244 */ "alter_table_option",
  /*  245 */ "col_name",
  /*  246 */ "db_name_cond_opt",
  /*  247 */ "like_pattern_opt",
  /*  248 */ "table_name_cond",
  /*  249 */ "from_db_opt",
  /*  250 */ "func_name",
  /*  251 */ "function_name",
  /*  252 */ "index_name",
  /*  253 */ "index_options",
  /*  254 */ "func_list",
  /*  255 */ "duration_literal",
  /*  256 */ "sliding_opt",
  /*  257 */ "func",
  /*  258 */ "expression_list",
  /*  259 */ "topic_name",
  /*  260 */ "query_expression",
  /*  261 */ "analyze_opt",
  /*  262 */ "explain_options",
  /*  263 */ "agg_func_opt",
  /*  264 */ "bufsize_opt",
  /*  265 */ "stream_name",
  /*  266 */ "dnode_list",
  /*  267 */ "signed",
  /*  268 */ "signed_literal",
  /*  269 */ "table_alias",
  /*  270 */ "column_alias",
  /*  271 */ "expression",
  /*  272 */ "pseudo_column",
  /*  273 */ "column_reference",
  /*  274 */ "subquery",
  /*  275 */ "predicate",
  /*  276 */ "compare_op",
  /*  277 */ "in_op",
  /*  278 */ "in_predicate_value",
  /*  279 */ "boolean_value_expression",
  /*  280 */ "boolean_primary",
  /*  281 */ "common_expression",
  /*  282 */ "from_clause",
  /*  283 */ "table_reference_list",
  /*  284 */ "table_reference",
  /*  285 */ "table_primary",
  /*  286 */ "joined_table",
  /*  287 */ "alias_opt",
  /*  288 */ "parenthesized_joined_table",
  /*  289 */ "join_type",
  /*  290 */ "search_condition",
  /*  291 */ "query_specification",
  /*  292 */ "set_quantifier_opt",
  /*  293 */ "select_list",
  /*  294 */ "where_clause_opt",
  /*  295 */ "partition_by_clause_opt",
  /*  296 */ "twindow_clause_opt",
  /*  297 */ "group_by_clause_opt",
  /*  298 */ "having_clause_opt",
  /*  299 */ "select_sublist",
  /*  300 */ "select_item",
  /*  301 */ "fill_opt",
  /*  302 */ "fill_mode",
  /*  303 */ "group_by_list",
  /*  304 */ "query_expression_body",
  /*  305 */ "order_by_clause_opt",
  /*  306 */ "slimit_clause_opt",
  /*  307 */ "limit_clause_opt",
  /*  308 */ "query_primary",
  /*  309 */ "sort_specification_list",
  /*  310 */ "sort_specification",
  /*  311 */ "ordering_specification_opt",
  /*  312 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  29 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  30 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  31 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  32 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  33 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  34 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  35 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  36 */ "dnode_endpoint ::= NK_STRING",
 /*  37 */ "dnode_host_name ::= NK_ID",
 /*  38 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  39 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  40 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  41 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  42 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  43 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  44 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  45 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  46 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  47 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  48 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  49 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  50 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  51 */ "cmd ::= USE db_name",
 /*  52 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  53 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  54 */ "not_exists_opt ::=",
 /*  55 */ "exists_opt ::= IF EXISTS",
 /*  56 */ "exists_opt ::=",
 /*  57 */ "db_options ::=",
 /*  58 */ "db_options ::= db_options BLOCKS NK_INTEGER",
 /*  59 */ "db_options ::= db_options CACHE NK_INTEGER",
 /*  60 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  61 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  62 */ "db_options ::= db_options DAYS NK_INTEGER",
 /*  63 */ "db_options ::= db_options DAYS NK_VARIABLE",
 /*  64 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  65 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  66 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  67 */ "db_options ::= db_options KEEP integer_list",
 /*  68 */ "db_options ::= db_options KEEP variable_list",
 /*  69 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  70 */ "db_options ::= db_options QUORUM NK_INTEGER",
 /*  71 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  72 */ "db_options ::= db_options TTL NK_INTEGER",
 /*  73 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  74 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  75 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  76 */ "db_options ::= db_options STREAM_MODE NK_INTEGER",
 /*  77 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  78 */ "alter_db_options ::= alter_db_option",
 /*  79 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  80 */ "alter_db_option ::= BLOCKS NK_INTEGER",
 /*  81 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  82 */ "alter_db_option ::= KEEP integer_list",
 /*  83 */ "alter_db_option ::= KEEP variable_list",
 /*  84 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  85 */ "alter_db_option ::= QUORUM NK_INTEGER",
 /*  86 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  87 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  88 */ "integer_list ::= NK_INTEGER",
 /*  89 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /*  90 */ "variable_list ::= NK_VARIABLE",
 /*  91 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /*  92 */ "retention_list ::= retention",
 /*  93 */ "retention_list ::= retention_list NK_COMMA retention",
 /*  94 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /*  95 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /*  96 */ "cmd ::= CREATE TABLE multi_create_clause",
 /*  97 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /*  98 */ "cmd ::= DROP TABLE multi_drop_clause",
 /*  99 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 100 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 101 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 102 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 103 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 104 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 105 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 106 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 107 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 108 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 109 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 110 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 111 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal",
 /* 112 */ "multi_create_clause ::= create_subtable_clause",
 /* 113 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 114 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP",
 /* 115 */ "multi_drop_clause ::= drop_table_clause",
 /* 116 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 117 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 118 */ "specific_tags_opt ::=",
 /* 119 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 120 */ "full_table_name ::= table_name",
 /* 121 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 122 */ "column_def_list ::= column_def",
 /* 123 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 124 */ "column_def ::= column_name type_name",
 /* 125 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 126 */ "type_name ::= BOOL",
 /* 127 */ "type_name ::= TINYINT",
 /* 128 */ "type_name ::= SMALLINT",
 /* 129 */ "type_name ::= INT",
 /* 130 */ "type_name ::= INTEGER",
 /* 131 */ "type_name ::= BIGINT",
 /* 132 */ "type_name ::= FLOAT",
 /* 133 */ "type_name ::= DOUBLE",
 /* 134 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 135 */ "type_name ::= TIMESTAMP",
 /* 136 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 137 */ "type_name ::= TINYINT UNSIGNED",
 /* 138 */ "type_name ::= SMALLINT UNSIGNED",
 /* 139 */ "type_name ::= INT UNSIGNED",
 /* 140 */ "type_name ::= BIGINT UNSIGNED",
 /* 141 */ "type_name ::= JSON",
 /* 142 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 143 */ "type_name ::= MEDIUMBLOB",
 /* 144 */ "type_name ::= BLOB",
 /* 145 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 146 */ "type_name ::= DECIMAL",
 /* 147 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 149 */ "tags_def_opt ::=",
 /* 150 */ "tags_def_opt ::= tags_def",
 /* 151 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 152 */ "table_options ::=",
 /* 153 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 154 */ "table_options ::= table_options KEEP integer_list",
 /* 155 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 156 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 157 */ "table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP",
 /* 158 */ "table_options ::= table_options FILE_FACTOR NK_FLOAT",
 /* 159 */ "table_options ::= table_options DELAY NK_INTEGER",
 /* 160 */ "alter_table_options ::= alter_table_option",
 /* 161 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 162 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 163 */ "alter_table_option ::= KEEP integer_list",
 /* 164 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 165 */ "col_name_list ::= col_name",
 /* 166 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 167 */ "col_name ::= column_name",
 /* 168 */ "cmd ::= SHOW DNODES",
 /* 169 */ "cmd ::= SHOW USERS",
 /* 170 */ "cmd ::= SHOW DATABASES",
 /* 171 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 172 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 173 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 174 */ "cmd ::= SHOW MNODES",
 /* 175 */ "cmd ::= SHOW MODULES",
 /* 176 */ "cmd ::= SHOW QNODES",
 /* 177 */ "cmd ::= SHOW FUNCTIONS",
 /* 178 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 179 */ "cmd ::= SHOW STREAMS",
 /* 180 */ "cmd ::= SHOW ACCOUNTS",
 /* 181 */ "cmd ::= SHOW APPS",
 /* 182 */ "cmd ::= SHOW CONNECTIONS",
 /* 183 */ "cmd ::= SHOW LICENCE",
 /* 184 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 185 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 186 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 187 */ "cmd ::= SHOW QUERIES",
 /* 188 */ "cmd ::= SHOW SCORES",
 /* 189 */ "cmd ::= SHOW TOPICS",
 /* 190 */ "cmd ::= SHOW VARIABLES",
 /* 191 */ "cmd ::= SHOW BNODES",
 /* 192 */ "cmd ::= SHOW SNODES",
 /* 193 */ "db_name_cond_opt ::=",
 /* 194 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 195 */ "like_pattern_opt ::=",
 /* 196 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 197 */ "table_name_cond ::= table_name",
 /* 198 */ "from_db_opt ::=",
 /* 199 */ "from_db_opt ::= FROM db_name",
 /* 200 */ "func_name_list ::= func_name",
 /* 201 */ "func_name_list ::= func_name_list NK_COMMA col_name",
 /* 202 */ "func_name ::= function_name",
 /* 203 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 204 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 205 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 206 */ "index_options ::=",
 /* 207 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 208 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 209 */ "func_list ::= func",
 /* 210 */ "func_list ::= func_list NK_COMMA func",
 /* 211 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 212 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 213 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name",
 /* 214 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 215 */ "cmd ::= DESC full_table_name",
 /* 216 */ "cmd ::= DESCRIBE full_table_name",
 /* 217 */ "cmd ::= RESET QUERY CACHE",
 /* 218 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 219 */ "analyze_opt ::=",
 /* 220 */ "analyze_opt ::= ANALYZE",
 /* 221 */ "explain_options ::=",
 /* 222 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 223 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 224 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 225 */ "cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 226 */ "cmd ::= DROP FUNCTION function_name",
 /* 227 */ "agg_func_opt ::=",
 /* 228 */ "agg_func_opt ::= AGGREGATE",
 /* 229 */ "bufsize_opt ::=",
 /* 230 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 231 */ "cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression",
 /* 232 */ "cmd ::= DROP STREAM stream_name",
 /* 233 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 234 */ "cmd ::= KILL QUERY NK_INTEGER",
 /* 235 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 236 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 237 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 238 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 239 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 240 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 241 */ "cmd ::= query_expression",
 /* 242 */ "literal ::= NK_INTEGER",
 /* 243 */ "literal ::= NK_FLOAT",
 /* 244 */ "literal ::= NK_STRING",
 /* 245 */ "literal ::= NK_BOOL",
 /* 246 */ "literal ::= TIMESTAMP NK_STRING",
 /* 247 */ "literal ::= duration_literal",
 /* 248 */ "literal ::= NULL",
 /* 249 */ "duration_literal ::= NK_VARIABLE",
 /* 250 */ "signed ::= NK_INTEGER",
 /* 251 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 252 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 253 */ "signed ::= NK_FLOAT",
 /* 254 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 255 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 256 */ "signed_literal ::= signed",
 /* 257 */ "signed_literal ::= NK_STRING",
 /* 258 */ "signed_literal ::= NK_BOOL",
 /* 259 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 260 */ "signed_literal ::= duration_literal",
 /* 261 */ "signed_literal ::= NULL",
 /* 262 */ "literal_list ::= signed_literal",
 /* 263 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 264 */ "db_name ::= NK_ID",
 /* 265 */ "table_name ::= NK_ID",
 /* 266 */ "column_name ::= NK_ID",
 /* 267 */ "function_name ::= NK_ID",
 /* 268 */ "function_name ::= FIRST",
 /* 269 */ "function_name ::= LAST",
 /* 270 */ "table_alias ::= NK_ID",
 /* 271 */ "column_alias ::= NK_ID",
 /* 272 */ "user_name ::= NK_ID",
 /* 273 */ "index_name ::= NK_ID",
 /* 274 */ "topic_name ::= NK_ID",
 /* 275 */ "stream_name ::= NK_ID",
 /* 276 */ "expression ::= literal",
 /* 277 */ "expression ::= pseudo_column",
 /* 278 */ "expression ::= column_reference",
 /* 279 */ "expression ::= function_name NK_LP expression_list NK_RP",
 /* 280 */ "expression ::= function_name NK_LP NK_STAR NK_RP",
 /* 281 */ "expression ::= function_name NK_LP expression AS type_name NK_RP",
 /* 282 */ "expression ::= subquery",
 /* 283 */ "expression ::= NK_LP expression NK_RP",
 /* 284 */ "expression ::= NK_PLUS expression",
 /* 285 */ "expression ::= NK_MINUS expression",
 /* 286 */ "expression ::= expression NK_PLUS expression",
 /* 287 */ "expression ::= expression NK_MINUS expression",
 /* 288 */ "expression ::= expression NK_STAR expression",
 /* 289 */ "expression ::= expression NK_SLASH expression",
 /* 290 */ "expression ::= expression NK_REM expression",
 /* 291 */ "expression_list ::= expression",
 /* 292 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 293 */ "column_reference ::= column_name",
 /* 294 */ "column_reference ::= table_name NK_DOT column_name",
 /* 295 */ "pseudo_column ::= NOW",
 /* 296 */ "pseudo_column ::= ROWTS",
 /* 297 */ "pseudo_column ::= TBNAME",
 /* 298 */ "pseudo_column ::= QSTARTTS",
 /* 299 */ "pseudo_column ::= QENDTS",
 /* 300 */ "pseudo_column ::= WSTARTTS",
 /* 301 */ "pseudo_column ::= WENDTS",
 /* 302 */ "pseudo_column ::= WDURATION",
 /* 303 */ "predicate ::= expression compare_op expression",
 /* 304 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 305 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 306 */ "predicate ::= expression IS NULL",
 /* 307 */ "predicate ::= expression IS NOT NULL",
 /* 308 */ "predicate ::= expression in_op in_predicate_value",
 /* 309 */ "compare_op ::= NK_LT",
 /* 310 */ "compare_op ::= NK_GT",
 /* 311 */ "compare_op ::= NK_LE",
 /* 312 */ "compare_op ::= NK_GE",
 /* 313 */ "compare_op ::= NK_NE",
 /* 314 */ "compare_op ::= NK_EQ",
 /* 315 */ "compare_op ::= LIKE",
 /* 316 */ "compare_op ::= NOT LIKE",
 /* 317 */ "compare_op ::= MATCH",
 /* 318 */ "compare_op ::= NMATCH",
 /* 319 */ "in_op ::= IN",
 /* 320 */ "in_op ::= NOT IN",
 /* 321 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 322 */ "boolean_value_expression ::= boolean_primary",
 /* 323 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 324 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 325 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 326 */ "boolean_primary ::= predicate",
 /* 327 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 328 */ "common_expression ::= expression",
 /* 329 */ "common_expression ::= boolean_value_expression",
 /* 330 */ "from_clause ::= FROM table_reference_list",
 /* 331 */ "table_reference_list ::= table_reference",
 /* 332 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 333 */ "table_reference ::= table_primary",
 /* 334 */ "table_reference ::= joined_table",
 /* 335 */ "table_primary ::= table_name alias_opt",
 /* 336 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 337 */ "table_primary ::= subquery alias_opt",
 /* 338 */ "table_primary ::= parenthesized_joined_table",
 /* 339 */ "alias_opt ::=",
 /* 340 */ "alias_opt ::= table_alias",
 /* 341 */ "alias_opt ::= AS table_alias",
 /* 342 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 343 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 344 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 345 */ "join_type ::=",
 /* 346 */ "join_type ::= INNER",
 /* 347 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 348 */ "set_quantifier_opt ::=",
 /* 349 */ "set_quantifier_opt ::= DISTINCT",
 /* 350 */ "set_quantifier_opt ::= ALL",
 /* 351 */ "select_list ::= NK_STAR",
 /* 352 */ "select_list ::= select_sublist",
 /* 353 */ "select_sublist ::= select_item",
 /* 354 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 355 */ "select_item ::= common_expression",
 /* 356 */ "select_item ::= common_expression column_alias",
 /* 357 */ "select_item ::= common_expression AS column_alias",
 /* 358 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 359 */ "where_clause_opt ::=",
 /* 360 */ "where_clause_opt ::= WHERE search_condition",
 /* 361 */ "partition_by_clause_opt ::=",
 /* 362 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 363 */ "twindow_clause_opt ::=",
 /* 364 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 365 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 366 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 367 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 368 */ "sliding_opt ::=",
 /* 369 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 370 */ "fill_opt ::=",
 /* 371 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 372 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 373 */ "fill_mode ::= NONE",
 /* 374 */ "fill_mode ::= PREV",
 /* 375 */ "fill_mode ::= NULL",
 /* 376 */ "fill_mode ::= LINEAR",
 /* 377 */ "fill_mode ::= NEXT",
 /* 378 */ "group_by_clause_opt ::=",
 /* 379 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 380 */ "group_by_list ::= expression",
 /* 381 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 382 */ "having_clause_opt ::=",
 /* 383 */ "having_clause_opt ::= HAVING search_condition",
 /* 384 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 385 */ "query_expression_body ::= query_primary",
 /* 386 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 387 */ "query_primary ::= query_specification",
 /* 388 */ "order_by_clause_opt ::=",
 /* 389 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 390 */ "slimit_clause_opt ::=",
 /* 391 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 392 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 393 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 394 */ "limit_clause_opt ::=",
 /* 395 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 396 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 397 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 398 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 399 */ "search_condition ::= common_expression",
 /* 400 */ "sort_specification_list ::= sort_specification",
 /* 401 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 402 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 403 */ "ordering_specification_opt ::=",
 /* 404 */ "ordering_specification_opt ::= ASC",
 /* 405 */ "ordering_specification_opt ::= DESC",
 /* 406 */ "null_ordering_opt ::=",
 /* 407 */ "null_ordering_opt ::= NULLS FIRST",
 /* 408 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 207: /* cmd */
    case 210: /* literal */
    case 217: /* db_options */
    case 219: /* alter_db_options */
    case 224: /* retention */
    case 225: /* full_table_name */
    case 228: /* table_options */
    case 232: /* alter_table_clause */
    case 233: /* alter_table_options */
    case 236: /* create_subtable_clause */
    case 239: /* drop_table_clause */
    case 242: /* column_def */
    case 245: /* col_name */
    case 246: /* db_name_cond_opt */
    case 247: /* like_pattern_opt */
    case 248: /* table_name_cond */
    case 249: /* from_db_opt */
    case 250: /* func_name */
    case 253: /* index_options */
    case 255: /* duration_literal */
    case 256: /* sliding_opt */
    case 257: /* func */
    case 260: /* query_expression */
    case 262: /* explain_options */
    case 267: /* signed */
    case 268: /* signed_literal */
    case 271: /* expression */
    case 272: /* pseudo_column */
    case 273: /* column_reference */
    case 274: /* subquery */
    case 275: /* predicate */
    case 278: /* in_predicate_value */
    case 279: /* boolean_value_expression */
    case 280: /* boolean_primary */
    case 281: /* common_expression */
    case 282: /* from_clause */
    case 283: /* table_reference_list */
    case 284: /* table_reference */
    case 285: /* table_primary */
    case 286: /* joined_table */
    case 288: /* parenthesized_joined_table */
    case 290: /* search_condition */
    case 291: /* query_specification */
    case 294: /* where_clause_opt */
    case 296: /* twindow_clause_opt */
    case 298: /* having_clause_opt */
    case 300: /* select_item */
    case 301: /* fill_opt */
    case 304: /* query_expression_body */
    case 306: /* slimit_clause_opt */
    case 307: /* limit_clause_opt */
    case 308: /* query_primary */
    case 310: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy564)); 
}
      break;
    case 208: /* account_options */
    case 209: /* alter_account_options */
    case 211: /* alter_account_option */
    case 264: /* bufsize_opt */
{
 
}
      break;
    case 212: /* user_name */
    case 213: /* dnode_endpoint */
    case 214: /* dnode_host_name */
    case 216: /* db_name */
    case 234: /* column_name */
    case 241: /* table_name */
    case 251: /* function_name */
    case 252: /* index_name */
    case 259: /* topic_name */
    case 265: /* stream_name */
    case 269: /* table_alias */
    case 270: /* column_alias */
    case 287: /* alias_opt */
{
 
}
      break;
    case 215: /* not_exists_opt */
    case 218: /* exists_opt */
    case 261: /* analyze_opt */
    case 263: /* agg_func_opt */
    case 292: /* set_quantifier_opt */
{
 
}
      break;
    case 220: /* integer_list */
    case 221: /* variable_list */
    case 222: /* retention_list */
    case 226: /* column_def_list */
    case 227: /* tags_def_opt */
    case 229: /* multi_create_clause */
    case 230: /* tags_def */
    case 231: /* multi_drop_clause */
    case 237: /* specific_tags_opt */
    case 238: /* literal_list */
    case 240: /* col_name_list */
    case 243: /* func_name_list */
    case 254: /* func_list */
    case 258: /* expression_list */
    case 266: /* dnode_list */
    case 293: /* select_list */
    case 295: /* partition_by_clause_opt */
    case 297: /* group_by_clause_opt */
    case 299: /* select_sublist */
    case 303: /* group_by_list */
    case 305: /* order_by_clause_opt */
    case 309: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy476)); 
}
      break;
    case 223: /* alter_db_option */
    case 244: /* alter_table_option */
{
 
}
      break;
    case 235: /* type_name */
{
 
}
      break;
    case 276: /* compare_op */
    case 277: /* in_op */
{
 
}
      break;
    case 289: /* join_type */
{
 
}
      break;
    case 302: /* fill_mode */
{
 
}
      break;
    case 311: /* ordering_specification_opt */
{
 
}
      break;
    case 312: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    assert( i<=YY_ACTTAB_COUNT );
    assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD );
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    assert( i<(int)YY_NLOOKAHEAD );
    if( yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      assert( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0]) );
      iFallback = yyFallback[iLookAhead];
      if( iFallback!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        assert( j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) );
        if( yy_lookahead[j]==YYWILDCARD && iLookAhead>0 ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      assert( i>=0 && i<sizeof(yy_action)/sizeof(yy_action[0]) );
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* For rule J, yyRuleInfoLhs[J] contains the symbol on the left-hand side
** of that rule */
static const YYCODETYPE yyRuleInfoLhs[] = {
   207,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   207,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
   208,  /* (2) account_options ::= */
   208,  /* (3) account_options ::= account_options PPS literal */
   208,  /* (4) account_options ::= account_options TSERIES literal */
   208,  /* (5) account_options ::= account_options STORAGE literal */
   208,  /* (6) account_options ::= account_options STREAMS literal */
   208,  /* (7) account_options ::= account_options QTIME literal */
   208,  /* (8) account_options ::= account_options DBS literal */
   208,  /* (9) account_options ::= account_options USERS literal */
   208,  /* (10) account_options ::= account_options CONNS literal */
   208,  /* (11) account_options ::= account_options STATE literal */
   209,  /* (12) alter_account_options ::= alter_account_option */
   209,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   211,  /* (14) alter_account_option ::= PASS literal */
   211,  /* (15) alter_account_option ::= PPS literal */
   211,  /* (16) alter_account_option ::= TSERIES literal */
   211,  /* (17) alter_account_option ::= STORAGE literal */
   211,  /* (18) alter_account_option ::= STREAMS literal */
   211,  /* (19) alter_account_option ::= QTIME literal */
   211,  /* (20) alter_account_option ::= DBS literal */
   211,  /* (21) alter_account_option ::= USERS literal */
   211,  /* (22) alter_account_option ::= CONNS literal */
   211,  /* (23) alter_account_option ::= STATE literal */
   207,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
   207,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   207,  /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
   207,  /* (27) cmd ::= DROP USER user_name */
   207,  /* (28) cmd ::= CREATE DNODE dnode_endpoint */
   207,  /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
   207,  /* (30) cmd ::= DROP DNODE NK_INTEGER */
   207,  /* (31) cmd ::= DROP DNODE dnode_endpoint */
   207,  /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   207,  /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   207,  /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
   207,  /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   213,  /* (36) dnode_endpoint ::= NK_STRING */
   214,  /* (37) dnode_host_name ::= NK_ID */
   214,  /* (38) dnode_host_name ::= NK_IPTOKEN */
   207,  /* (39) cmd ::= ALTER LOCAL NK_STRING */
   207,  /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   207,  /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   207,  /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   207,  /* (43) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   207,  /* (44) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   207,  /* (45) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   207,  /* (46) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   207,  /* (47) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   207,  /* (48) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   207,  /* (49) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   207,  /* (50) cmd ::= DROP DATABASE exists_opt db_name */
   207,  /* (51) cmd ::= USE db_name */
   207,  /* (52) cmd ::= ALTER DATABASE db_name alter_db_options */
   215,  /* (53) not_exists_opt ::= IF NOT EXISTS */
   215,  /* (54) not_exists_opt ::= */
   218,  /* (55) exists_opt ::= IF EXISTS */
   218,  /* (56) exists_opt ::= */
   217,  /* (57) db_options ::= */
   217,  /* (58) db_options ::= db_options BLOCKS NK_INTEGER */
   217,  /* (59) db_options ::= db_options CACHE NK_INTEGER */
   217,  /* (60) db_options ::= db_options CACHELAST NK_INTEGER */
   217,  /* (61) db_options ::= db_options COMP NK_INTEGER */
   217,  /* (62) db_options ::= db_options DAYS NK_INTEGER */
   217,  /* (63) db_options ::= db_options DAYS NK_VARIABLE */
   217,  /* (64) db_options ::= db_options FSYNC NK_INTEGER */
   217,  /* (65) db_options ::= db_options MAXROWS NK_INTEGER */
   217,  /* (66) db_options ::= db_options MINROWS NK_INTEGER */
   217,  /* (67) db_options ::= db_options KEEP integer_list */
   217,  /* (68) db_options ::= db_options KEEP variable_list */
   217,  /* (69) db_options ::= db_options PRECISION NK_STRING */
   217,  /* (70) db_options ::= db_options QUORUM NK_INTEGER */
   217,  /* (71) db_options ::= db_options REPLICA NK_INTEGER */
   217,  /* (72) db_options ::= db_options TTL NK_INTEGER */
   217,  /* (73) db_options ::= db_options WAL NK_INTEGER */
   217,  /* (74) db_options ::= db_options VGROUPS NK_INTEGER */
   217,  /* (75) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   217,  /* (76) db_options ::= db_options STREAM_MODE NK_INTEGER */
   217,  /* (77) db_options ::= db_options RETENTIONS retention_list */
   219,  /* (78) alter_db_options ::= alter_db_option */
   219,  /* (79) alter_db_options ::= alter_db_options alter_db_option */
   223,  /* (80) alter_db_option ::= BLOCKS NK_INTEGER */
   223,  /* (81) alter_db_option ::= FSYNC NK_INTEGER */
   223,  /* (82) alter_db_option ::= KEEP integer_list */
   223,  /* (83) alter_db_option ::= KEEP variable_list */
   223,  /* (84) alter_db_option ::= WAL NK_INTEGER */
   223,  /* (85) alter_db_option ::= QUORUM NK_INTEGER */
   223,  /* (86) alter_db_option ::= CACHELAST NK_INTEGER */
   223,  /* (87) alter_db_option ::= REPLICA NK_INTEGER */
   220,  /* (88) integer_list ::= NK_INTEGER */
   220,  /* (89) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   221,  /* (90) variable_list ::= NK_VARIABLE */
   221,  /* (91) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   222,  /* (92) retention_list ::= retention */
   222,  /* (93) retention_list ::= retention_list NK_COMMA retention */
   224,  /* (94) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
   207,  /* (95) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   207,  /* (96) cmd ::= CREATE TABLE multi_create_clause */
   207,  /* (97) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   207,  /* (98) cmd ::= DROP TABLE multi_drop_clause */
   207,  /* (99) cmd ::= DROP STABLE exists_opt full_table_name */
   207,  /* (100) cmd ::= ALTER TABLE alter_table_clause */
   207,  /* (101) cmd ::= ALTER STABLE alter_table_clause */
   232,  /* (102) alter_table_clause ::= full_table_name alter_table_options */
   232,  /* (103) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   232,  /* (104) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   232,  /* (105) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   232,  /* (106) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   232,  /* (107) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   232,  /* (108) alter_table_clause ::= full_table_name DROP TAG column_name */
   232,  /* (109) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   232,  /* (110) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   232,  /* (111) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
   229,  /* (112) multi_create_clause ::= create_subtable_clause */
   229,  /* (113) multi_create_clause ::= multi_create_clause create_subtable_clause */
   236,  /* (114) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
   231,  /* (115) multi_drop_clause ::= drop_table_clause */
   231,  /* (116) multi_drop_clause ::= multi_drop_clause drop_table_clause */
   239,  /* (117) drop_table_clause ::= exists_opt full_table_name */
   237,  /* (118) specific_tags_opt ::= */
   237,  /* (119) specific_tags_opt ::= NK_LP col_name_list NK_RP */
   225,  /* (120) full_table_name ::= table_name */
   225,  /* (121) full_table_name ::= db_name NK_DOT table_name */
   226,  /* (122) column_def_list ::= column_def */
   226,  /* (123) column_def_list ::= column_def_list NK_COMMA column_def */
   242,  /* (124) column_def ::= column_name type_name */
   242,  /* (125) column_def ::= column_name type_name COMMENT NK_STRING */
   235,  /* (126) type_name ::= BOOL */
   235,  /* (127) type_name ::= TINYINT */
   235,  /* (128) type_name ::= SMALLINT */
   235,  /* (129) type_name ::= INT */
   235,  /* (130) type_name ::= INTEGER */
   235,  /* (131) type_name ::= BIGINT */
   235,  /* (132) type_name ::= FLOAT */
   235,  /* (133) type_name ::= DOUBLE */
   235,  /* (134) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   235,  /* (135) type_name ::= TIMESTAMP */
   235,  /* (136) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   235,  /* (137) type_name ::= TINYINT UNSIGNED */
   235,  /* (138) type_name ::= SMALLINT UNSIGNED */
   235,  /* (139) type_name ::= INT UNSIGNED */
   235,  /* (140) type_name ::= BIGINT UNSIGNED */
   235,  /* (141) type_name ::= JSON */
   235,  /* (142) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   235,  /* (143) type_name ::= MEDIUMBLOB */
   235,  /* (144) type_name ::= BLOB */
   235,  /* (145) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   235,  /* (146) type_name ::= DECIMAL */
   235,  /* (147) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   235,  /* (148) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
   227,  /* (149) tags_def_opt ::= */
   227,  /* (150) tags_def_opt ::= tags_def */
   230,  /* (151) tags_def ::= TAGS NK_LP column_def_list NK_RP */
   228,  /* (152) table_options ::= */
   228,  /* (153) table_options ::= table_options COMMENT NK_STRING */
   228,  /* (154) table_options ::= table_options KEEP integer_list */
   228,  /* (155) table_options ::= table_options TTL NK_INTEGER */
   228,  /* (156) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   228,  /* (157) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
   228,  /* (158) table_options ::= table_options FILE_FACTOR NK_FLOAT */
   228,  /* (159) table_options ::= table_options DELAY NK_INTEGER */
   233,  /* (160) alter_table_options ::= alter_table_option */
   233,  /* (161) alter_table_options ::= alter_table_options alter_table_option */
   244,  /* (162) alter_table_option ::= COMMENT NK_STRING */
   244,  /* (163) alter_table_option ::= KEEP integer_list */
   244,  /* (164) alter_table_option ::= TTL NK_INTEGER */
   240,  /* (165) col_name_list ::= col_name */
   240,  /* (166) col_name_list ::= col_name_list NK_COMMA col_name */
   245,  /* (167) col_name ::= column_name */
   207,  /* (168) cmd ::= SHOW DNODES */
   207,  /* (169) cmd ::= SHOW USERS */
   207,  /* (170) cmd ::= SHOW DATABASES */
   207,  /* (171) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   207,  /* (172) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   207,  /* (173) cmd ::= SHOW db_name_cond_opt VGROUPS */
   207,  /* (174) cmd ::= SHOW MNODES */
   207,  /* (175) cmd ::= SHOW MODULES */
   207,  /* (176) cmd ::= SHOW QNODES */
   207,  /* (177) cmd ::= SHOW FUNCTIONS */
   207,  /* (178) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   207,  /* (179) cmd ::= SHOW STREAMS */
   207,  /* (180) cmd ::= SHOW ACCOUNTS */
   207,  /* (181) cmd ::= SHOW APPS */
   207,  /* (182) cmd ::= SHOW CONNECTIONS */
   207,  /* (183) cmd ::= SHOW LICENCE */
   207,  /* (184) cmd ::= SHOW CREATE DATABASE db_name */
   207,  /* (185) cmd ::= SHOW CREATE TABLE full_table_name */
   207,  /* (186) cmd ::= SHOW CREATE STABLE full_table_name */
   207,  /* (187) cmd ::= SHOW QUERIES */
   207,  /* (188) cmd ::= SHOW SCORES */
   207,  /* (189) cmd ::= SHOW TOPICS */
   207,  /* (190) cmd ::= SHOW VARIABLES */
   207,  /* (191) cmd ::= SHOW BNODES */
   207,  /* (192) cmd ::= SHOW SNODES */
   246,  /* (193) db_name_cond_opt ::= */
   246,  /* (194) db_name_cond_opt ::= db_name NK_DOT */
   247,  /* (195) like_pattern_opt ::= */
   247,  /* (196) like_pattern_opt ::= LIKE NK_STRING */
   248,  /* (197) table_name_cond ::= table_name */
   249,  /* (198) from_db_opt ::= */
   249,  /* (199) from_db_opt ::= FROM db_name */
   243,  /* (200) func_name_list ::= func_name */
   243,  /* (201) func_name_list ::= func_name_list NK_COMMA col_name */
   250,  /* (202) func_name ::= function_name */
   207,  /* (203) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
   207,  /* (204) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
   207,  /* (205) cmd ::= DROP INDEX exists_opt index_name ON table_name */
   253,  /* (206) index_options ::= */
   253,  /* (207) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
   253,  /* (208) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
   254,  /* (209) func_list ::= func */
   254,  /* (210) func_list ::= func_list NK_COMMA func */
   257,  /* (211) func ::= function_name NK_LP expression_list NK_RP */
   207,  /* (212) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
   207,  /* (213) cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
   207,  /* (214) cmd ::= DROP TOPIC exists_opt topic_name */
   207,  /* (215) cmd ::= DESC full_table_name */
   207,  /* (216) cmd ::= DESCRIBE full_table_name */
   207,  /* (217) cmd ::= RESET QUERY CACHE */
   207,  /* (218) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
   261,  /* (219) analyze_opt ::= */
   261,  /* (220) analyze_opt ::= ANALYZE */
   262,  /* (221) explain_options ::= */
   262,  /* (222) explain_options ::= explain_options VERBOSE NK_BOOL */
   262,  /* (223) explain_options ::= explain_options RATIO NK_FLOAT */
   207,  /* (224) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
   207,  /* (225) cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
   207,  /* (226) cmd ::= DROP FUNCTION function_name */
   263,  /* (227) agg_func_opt ::= */
   263,  /* (228) agg_func_opt ::= AGGREGATE */
   264,  /* (229) bufsize_opt ::= */
   264,  /* (230) bufsize_opt ::= BUFSIZE NK_INTEGER */
   207,  /* (231) cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression */
   207,  /* (232) cmd ::= DROP STREAM stream_name */
   207,  /* (233) cmd ::= KILL CONNECTION NK_INTEGER */
   207,  /* (234) cmd ::= KILL QUERY NK_INTEGER */
   207,  /* (235) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   207,  /* (236) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   207,  /* (237) cmd ::= SPLIT VGROUP NK_INTEGER */
   266,  /* (238) dnode_list ::= DNODE NK_INTEGER */
   266,  /* (239) dnode_list ::= dnode_list DNODE NK_INTEGER */
   207,  /* (240) cmd ::= SYNCDB db_name REPLICA */
   207,  /* (241) cmd ::= query_expression */
   210,  /* (242) literal ::= NK_INTEGER */
   210,  /* (243) literal ::= NK_FLOAT */
   210,  /* (244) literal ::= NK_STRING */
   210,  /* (245) literal ::= NK_BOOL */
   210,  /* (246) literal ::= TIMESTAMP NK_STRING */
   210,  /* (247) literal ::= duration_literal */
   210,  /* (248) literal ::= NULL */
   255,  /* (249) duration_literal ::= NK_VARIABLE */
   267,  /* (250) signed ::= NK_INTEGER */
   267,  /* (251) signed ::= NK_PLUS NK_INTEGER */
   267,  /* (252) signed ::= NK_MINUS NK_INTEGER */
   267,  /* (253) signed ::= NK_FLOAT */
   267,  /* (254) signed ::= NK_PLUS NK_FLOAT */
   267,  /* (255) signed ::= NK_MINUS NK_FLOAT */
   268,  /* (256) signed_literal ::= signed */
   268,  /* (257) signed_literal ::= NK_STRING */
   268,  /* (258) signed_literal ::= NK_BOOL */
   268,  /* (259) signed_literal ::= TIMESTAMP NK_STRING */
   268,  /* (260) signed_literal ::= duration_literal */
   268,  /* (261) signed_literal ::= NULL */
   238,  /* (262) literal_list ::= signed_literal */
   238,  /* (263) literal_list ::= literal_list NK_COMMA signed_literal */
   216,  /* (264) db_name ::= NK_ID */
   241,  /* (265) table_name ::= NK_ID */
   234,  /* (266) column_name ::= NK_ID */
   251,  /* (267) function_name ::= NK_ID */
   251,  /* (268) function_name ::= FIRST */
   251,  /* (269) function_name ::= LAST */
   269,  /* (270) table_alias ::= NK_ID */
   270,  /* (271) column_alias ::= NK_ID */
   212,  /* (272) user_name ::= NK_ID */
   252,  /* (273) index_name ::= NK_ID */
   259,  /* (274) topic_name ::= NK_ID */
   265,  /* (275) stream_name ::= NK_ID */
   271,  /* (276) expression ::= literal */
   271,  /* (277) expression ::= pseudo_column */
   271,  /* (278) expression ::= column_reference */
   271,  /* (279) expression ::= function_name NK_LP expression_list NK_RP */
   271,  /* (280) expression ::= function_name NK_LP NK_STAR NK_RP */
   271,  /* (281) expression ::= function_name NK_LP expression AS type_name NK_RP */
   271,  /* (282) expression ::= subquery */
   271,  /* (283) expression ::= NK_LP expression NK_RP */
   271,  /* (284) expression ::= NK_PLUS expression */
   271,  /* (285) expression ::= NK_MINUS expression */
   271,  /* (286) expression ::= expression NK_PLUS expression */
   271,  /* (287) expression ::= expression NK_MINUS expression */
   271,  /* (288) expression ::= expression NK_STAR expression */
   271,  /* (289) expression ::= expression NK_SLASH expression */
   271,  /* (290) expression ::= expression NK_REM expression */
   258,  /* (291) expression_list ::= expression */
   258,  /* (292) expression_list ::= expression_list NK_COMMA expression */
   273,  /* (293) column_reference ::= column_name */
   273,  /* (294) column_reference ::= table_name NK_DOT column_name */
   272,  /* (295) pseudo_column ::= NOW */
   272,  /* (296) pseudo_column ::= ROWTS */
   272,  /* (297) pseudo_column ::= TBNAME */
   272,  /* (298) pseudo_column ::= QSTARTTS */
   272,  /* (299) pseudo_column ::= QENDTS */
   272,  /* (300) pseudo_column ::= WSTARTTS */
   272,  /* (301) pseudo_column ::= WENDTS */
   272,  /* (302) pseudo_column ::= WDURATION */
   275,  /* (303) predicate ::= expression compare_op expression */
   275,  /* (304) predicate ::= expression BETWEEN expression AND expression */
   275,  /* (305) predicate ::= expression NOT BETWEEN expression AND expression */
   275,  /* (306) predicate ::= expression IS NULL */
   275,  /* (307) predicate ::= expression IS NOT NULL */
   275,  /* (308) predicate ::= expression in_op in_predicate_value */
   276,  /* (309) compare_op ::= NK_LT */
   276,  /* (310) compare_op ::= NK_GT */
   276,  /* (311) compare_op ::= NK_LE */
   276,  /* (312) compare_op ::= NK_GE */
   276,  /* (313) compare_op ::= NK_NE */
   276,  /* (314) compare_op ::= NK_EQ */
   276,  /* (315) compare_op ::= LIKE */
   276,  /* (316) compare_op ::= NOT LIKE */
   276,  /* (317) compare_op ::= MATCH */
   276,  /* (318) compare_op ::= NMATCH */
   277,  /* (319) in_op ::= IN */
   277,  /* (320) in_op ::= NOT IN */
   278,  /* (321) in_predicate_value ::= NK_LP expression_list NK_RP */
   279,  /* (322) boolean_value_expression ::= boolean_primary */
   279,  /* (323) boolean_value_expression ::= NOT boolean_primary */
   279,  /* (324) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   279,  /* (325) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   280,  /* (326) boolean_primary ::= predicate */
   280,  /* (327) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   281,  /* (328) common_expression ::= expression */
   281,  /* (329) common_expression ::= boolean_value_expression */
   282,  /* (330) from_clause ::= FROM table_reference_list */
   283,  /* (331) table_reference_list ::= table_reference */
   283,  /* (332) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   284,  /* (333) table_reference ::= table_primary */
   284,  /* (334) table_reference ::= joined_table */
   285,  /* (335) table_primary ::= table_name alias_opt */
   285,  /* (336) table_primary ::= db_name NK_DOT table_name alias_opt */
   285,  /* (337) table_primary ::= subquery alias_opt */
   285,  /* (338) table_primary ::= parenthesized_joined_table */
   287,  /* (339) alias_opt ::= */
   287,  /* (340) alias_opt ::= table_alias */
   287,  /* (341) alias_opt ::= AS table_alias */
   288,  /* (342) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   288,  /* (343) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   286,  /* (344) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
   289,  /* (345) join_type ::= */
   289,  /* (346) join_type ::= INNER */
   291,  /* (347) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
   292,  /* (348) set_quantifier_opt ::= */
   292,  /* (349) set_quantifier_opt ::= DISTINCT */
   292,  /* (350) set_quantifier_opt ::= ALL */
   293,  /* (351) select_list ::= NK_STAR */
   293,  /* (352) select_list ::= select_sublist */
   299,  /* (353) select_sublist ::= select_item */
   299,  /* (354) select_sublist ::= select_sublist NK_COMMA select_item */
   300,  /* (355) select_item ::= common_expression */
   300,  /* (356) select_item ::= common_expression column_alias */
   300,  /* (357) select_item ::= common_expression AS column_alias */
   300,  /* (358) select_item ::= table_name NK_DOT NK_STAR */
   294,  /* (359) where_clause_opt ::= */
   294,  /* (360) where_clause_opt ::= WHERE search_condition */
   295,  /* (361) partition_by_clause_opt ::= */
   295,  /* (362) partition_by_clause_opt ::= PARTITION BY expression_list */
   296,  /* (363) twindow_clause_opt ::= */
   296,  /* (364) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   296,  /* (365) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
   296,  /* (366) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   296,  /* (367) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
   256,  /* (368) sliding_opt ::= */
   256,  /* (369) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
   301,  /* (370) fill_opt ::= */
   301,  /* (371) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   301,  /* (372) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
   302,  /* (373) fill_mode ::= NONE */
   302,  /* (374) fill_mode ::= PREV */
   302,  /* (375) fill_mode ::= NULL */
   302,  /* (376) fill_mode ::= LINEAR */
   302,  /* (377) fill_mode ::= NEXT */
   297,  /* (378) group_by_clause_opt ::= */
   297,  /* (379) group_by_clause_opt ::= GROUP BY group_by_list */
   303,  /* (380) group_by_list ::= expression */
   303,  /* (381) group_by_list ::= group_by_list NK_COMMA expression */
   298,  /* (382) having_clause_opt ::= */
   298,  /* (383) having_clause_opt ::= HAVING search_condition */
   260,  /* (384) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
   304,  /* (385) query_expression_body ::= query_primary */
   304,  /* (386) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
   308,  /* (387) query_primary ::= query_specification */
   305,  /* (388) order_by_clause_opt ::= */
   305,  /* (389) order_by_clause_opt ::= ORDER BY sort_specification_list */
   306,  /* (390) slimit_clause_opt ::= */
   306,  /* (391) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   306,  /* (392) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   306,  /* (393) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   307,  /* (394) limit_clause_opt ::= */
   307,  /* (395) limit_clause_opt ::= LIMIT NK_INTEGER */
   307,  /* (396) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   307,  /* (397) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   274,  /* (398) subquery ::= NK_LP query_expression NK_RP */
   290,  /* (399) search_condition ::= common_expression */
   309,  /* (400) sort_specification_list ::= sort_specification */
   309,  /* (401) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   310,  /* (402) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
   311,  /* (403) ordering_specification_opt ::= */
   311,  /* (404) ordering_specification_opt ::= ASC */
   311,  /* (405) ordering_specification_opt ::= DESC */
   312,  /* (406) null_ordering_opt ::= */
   312,  /* (407) null_ordering_opt ::= NULLS FIRST */
   312,  /* (408) null_ordering_opt ::= NULLS LAST */
};

/* For rule J, yyRuleInfoNRhs[J] contains the negative of the number
** of symbols on the right-hand side of that rule. */
static const signed char yyRuleInfoNRhs[] = {
   -6,  /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
   -4,  /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
    0,  /* (2) account_options ::= */
   -3,  /* (3) account_options ::= account_options PPS literal */
   -3,  /* (4) account_options ::= account_options TSERIES literal */
   -3,  /* (5) account_options ::= account_options STORAGE literal */
   -3,  /* (6) account_options ::= account_options STREAMS literal */
   -3,  /* (7) account_options ::= account_options QTIME literal */
   -3,  /* (8) account_options ::= account_options DBS literal */
   -3,  /* (9) account_options ::= account_options USERS literal */
   -3,  /* (10) account_options ::= account_options CONNS literal */
   -3,  /* (11) account_options ::= account_options STATE literal */
   -1,  /* (12) alter_account_options ::= alter_account_option */
   -2,  /* (13) alter_account_options ::= alter_account_options alter_account_option */
   -2,  /* (14) alter_account_option ::= PASS literal */
   -2,  /* (15) alter_account_option ::= PPS literal */
   -2,  /* (16) alter_account_option ::= TSERIES literal */
   -2,  /* (17) alter_account_option ::= STORAGE literal */
   -2,  /* (18) alter_account_option ::= STREAMS literal */
   -2,  /* (19) alter_account_option ::= QTIME literal */
   -2,  /* (20) alter_account_option ::= DBS literal */
   -2,  /* (21) alter_account_option ::= USERS literal */
   -2,  /* (22) alter_account_option ::= CONNS literal */
   -2,  /* (23) alter_account_option ::= STATE literal */
   -5,  /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
   -5,  /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
   -5,  /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
   -3,  /* (27) cmd ::= DROP USER user_name */
   -3,  /* (28) cmd ::= CREATE DNODE dnode_endpoint */
   -5,  /* (29) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
   -3,  /* (30) cmd ::= DROP DNODE NK_INTEGER */
   -3,  /* (31) cmd ::= DROP DNODE dnode_endpoint */
   -4,  /* (32) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
   -5,  /* (33) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
   -4,  /* (34) cmd ::= ALTER ALL DNODES NK_STRING */
   -5,  /* (35) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
   -1,  /* (36) dnode_endpoint ::= NK_STRING */
   -1,  /* (37) dnode_host_name ::= NK_ID */
   -1,  /* (38) dnode_host_name ::= NK_IPTOKEN */
   -3,  /* (39) cmd ::= ALTER LOCAL NK_STRING */
   -4,  /* (40) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
   -5,  /* (41) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
   -5,  /* (42) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
   -5,  /* (43) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
   -5,  /* (44) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
   -5,  /* (45) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
   -5,  /* (46) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
   -5,  /* (47) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
   -5,  /* (48) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
   -5,  /* (49) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
   -4,  /* (50) cmd ::= DROP DATABASE exists_opt db_name */
   -2,  /* (51) cmd ::= USE db_name */
   -4,  /* (52) cmd ::= ALTER DATABASE db_name alter_db_options */
   -3,  /* (53) not_exists_opt ::= IF NOT EXISTS */
    0,  /* (54) not_exists_opt ::= */
   -2,  /* (55) exists_opt ::= IF EXISTS */
    0,  /* (56) exists_opt ::= */
    0,  /* (57) db_options ::= */
   -3,  /* (58) db_options ::= db_options BLOCKS NK_INTEGER */
   -3,  /* (59) db_options ::= db_options CACHE NK_INTEGER */
   -3,  /* (60) db_options ::= db_options CACHELAST NK_INTEGER */
   -3,  /* (61) db_options ::= db_options COMP NK_INTEGER */
   -3,  /* (62) db_options ::= db_options DAYS NK_INTEGER */
   -3,  /* (63) db_options ::= db_options DAYS NK_VARIABLE */
   -3,  /* (64) db_options ::= db_options FSYNC NK_INTEGER */
   -3,  /* (65) db_options ::= db_options MAXROWS NK_INTEGER */
   -3,  /* (66) db_options ::= db_options MINROWS NK_INTEGER */
   -3,  /* (67) db_options ::= db_options KEEP integer_list */
   -3,  /* (68) db_options ::= db_options KEEP variable_list */
   -3,  /* (69) db_options ::= db_options PRECISION NK_STRING */
   -3,  /* (70) db_options ::= db_options QUORUM NK_INTEGER */
   -3,  /* (71) db_options ::= db_options REPLICA NK_INTEGER */
   -3,  /* (72) db_options ::= db_options TTL NK_INTEGER */
   -3,  /* (73) db_options ::= db_options WAL NK_INTEGER */
   -3,  /* (74) db_options ::= db_options VGROUPS NK_INTEGER */
   -3,  /* (75) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
   -3,  /* (76) db_options ::= db_options STREAM_MODE NK_INTEGER */
   -3,  /* (77) db_options ::= db_options RETENTIONS retention_list */
   -1,  /* (78) alter_db_options ::= alter_db_option */
   -2,  /* (79) alter_db_options ::= alter_db_options alter_db_option */
   -2,  /* (80) alter_db_option ::= BLOCKS NK_INTEGER */
   -2,  /* (81) alter_db_option ::= FSYNC NK_INTEGER */
   -2,  /* (82) alter_db_option ::= KEEP integer_list */
   -2,  /* (83) alter_db_option ::= KEEP variable_list */
   -2,  /* (84) alter_db_option ::= WAL NK_INTEGER */
   -2,  /* (85) alter_db_option ::= QUORUM NK_INTEGER */
   -2,  /* (86) alter_db_option ::= CACHELAST NK_INTEGER */
   -2,  /* (87) alter_db_option ::= REPLICA NK_INTEGER */
   -1,  /* (88) integer_list ::= NK_INTEGER */
   -3,  /* (89) integer_list ::= integer_list NK_COMMA NK_INTEGER */
   -1,  /* (90) variable_list ::= NK_VARIABLE */
   -3,  /* (91) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
   -1,  /* (92) retention_list ::= retention */
   -3,  /* (93) retention_list ::= retention_list NK_COMMA retention */
   -3,  /* (94) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
   -9,  /* (95) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
   -3,  /* (96) cmd ::= CREATE TABLE multi_create_clause */
   -9,  /* (97) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
   -3,  /* (98) cmd ::= DROP TABLE multi_drop_clause */
   -4,  /* (99) cmd ::= DROP STABLE exists_opt full_table_name */
   -3,  /* (100) cmd ::= ALTER TABLE alter_table_clause */
   -3,  /* (101) cmd ::= ALTER STABLE alter_table_clause */
   -2,  /* (102) alter_table_clause ::= full_table_name alter_table_options */
   -5,  /* (103) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
   -4,  /* (104) alter_table_clause ::= full_table_name DROP COLUMN column_name */
   -5,  /* (105) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
   -5,  /* (106) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
   -5,  /* (107) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
   -4,  /* (108) alter_table_clause ::= full_table_name DROP TAG column_name */
   -5,  /* (109) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
   -5,  /* (110) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
   -6,  /* (111) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
   -1,  /* (112) multi_create_clause ::= create_subtable_clause */
   -2,  /* (113) multi_create_clause ::= multi_create_clause create_subtable_clause */
   -9,  /* (114) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
   -1,  /* (115) multi_drop_clause ::= drop_table_clause */
   -2,  /* (116) multi_drop_clause ::= multi_drop_clause drop_table_clause */
   -2,  /* (117) drop_table_clause ::= exists_opt full_table_name */
    0,  /* (118) specific_tags_opt ::= */
   -3,  /* (119) specific_tags_opt ::= NK_LP col_name_list NK_RP */
   -1,  /* (120) full_table_name ::= table_name */
   -3,  /* (121) full_table_name ::= db_name NK_DOT table_name */
   -1,  /* (122) column_def_list ::= column_def */
   -3,  /* (123) column_def_list ::= column_def_list NK_COMMA column_def */
   -2,  /* (124) column_def ::= column_name type_name */
   -4,  /* (125) column_def ::= column_name type_name COMMENT NK_STRING */
   -1,  /* (126) type_name ::= BOOL */
   -1,  /* (127) type_name ::= TINYINT */
   -1,  /* (128) type_name ::= SMALLINT */
   -1,  /* (129) type_name ::= INT */
   -1,  /* (130) type_name ::= INTEGER */
   -1,  /* (131) type_name ::= BIGINT */
   -1,  /* (132) type_name ::= FLOAT */
   -1,  /* (133) type_name ::= DOUBLE */
   -4,  /* (134) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (135) type_name ::= TIMESTAMP */
   -4,  /* (136) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
   -2,  /* (137) type_name ::= TINYINT UNSIGNED */
   -2,  /* (138) type_name ::= SMALLINT UNSIGNED */
   -2,  /* (139) type_name ::= INT UNSIGNED */
   -2,  /* (140) type_name ::= BIGINT UNSIGNED */
   -1,  /* (141) type_name ::= JSON */
   -4,  /* (142) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
   -1,  /* (143) type_name ::= MEDIUMBLOB */
   -1,  /* (144) type_name ::= BLOB */
   -4,  /* (145) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
   -1,  /* (146) type_name ::= DECIMAL */
   -4,  /* (147) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
   -6,  /* (148) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
    0,  /* (149) tags_def_opt ::= */
   -1,  /* (150) tags_def_opt ::= tags_def */
   -4,  /* (151) tags_def ::= TAGS NK_LP column_def_list NK_RP */
    0,  /* (152) table_options ::= */
   -3,  /* (153) table_options ::= table_options COMMENT NK_STRING */
   -3,  /* (154) table_options ::= table_options KEEP integer_list */
   -3,  /* (155) table_options ::= table_options TTL NK_INTEGER */
   -5,  /* (156) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
   -5,  /* (157) table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
   -3,  /* (158) table_options ::= table_options FILE_FACTOR NK_FLOAT */
   -3,  /* (159) table_options ::= table_options DELAY NK_INTEGER */
   -1,  /* (160) alter_table_options ::= alter_table_option */
   -2,  /* (161) alter_table_options ::= alter_table_options alter_table_option */
   -2,  /* (162) alter_table_option ::= COMMENT NK_STRING */
   -2,  /* (163) alter_table_option ::= KEEP integer_list */
   -2,  /* (164) alter_table_option ::= TTL NK_INTEGER */
   -1,  /* (165) col_name_list ::= col_name */
   -3,  /* (166) col_name_list ::= col_name_list NK_COMMA col_name */
   -1,  /* (167) col_name ::= column_name */
   -2,  /* (168) cmd ::= SHOW DNODES */
   -2,  /* (169) cmd ::= SHOW USERS */
   -2,  /* (170) cmd ::= SHOW DATABASES */
   -4,  /* (171) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
   -4,  /* (172) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
   -3,  /* (173) cmd ::= SHOW db_name_cond_opt VGROUPS */
   -2,  /* (174) cmd ::= SHOW MNODES */
   -2,  /* (175) cmd ::= SHOW MODULES */
   -2,  /* (176) cmd ::= SHOW QNODES */
   -2,  /* (177) cmd ::= SHOW FUNCTIONS */
   -5,  /* (178) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
   -2,  /* (179) cmd ::= SHOW STREAMS */
   -2,  /* (180) cmd ::= SHOW ACCOUNTS */
   -2,  /* (181) cmd ::= SHOW APPS */
   -2,  /* (182) cmd ::= SHOW CONNECTIONS */
   -2,  /* (183) cmd ::= SHOW LICENCE */
   -4,  /* (184) cmd ::= SHOW CREATE DATABASE db_name */
   -4,  /* (185) cmd ::= SHOW CREATE TABLE full_table_name */
   -4,  /* (186) cmd ::= SHOW CREATE STABLE full_table_name */
   -2,  /* (187) cmd ::= SHOW QUERIES */
   -2,  /* (188) cmd ::= SHOW SCORES */
   -2,  /* (189) cmd ::= SHOW TOPICS */
   -2,  /* (190) cmd ::= SHOW VARIABLES */
   -2,  /* (191) cmd ::= SHOW BNODES */
   -2,  /* (192) cmd ::= SHOW SNODES */
    0,  /* (193) db_name_cond_opt ::= */
   -2,  /* (194) db_name_cond_opt ::= db_name NK_DOT */
    0,  /* (195) like_pattern_opt ::= */
   -2,  /* (196) like_pattern_opt ::= LIKE NK_STRING */
   -1,  /* (197) table_name_cond ::= table_name */
    0,  /* (198) from_db_opt ::= */
   -2,  /* (199) from_db_opt ::= FROM db_name */
   -1,  /* (200) func_name_list ::= func_name */
   -3,  /* (201) func_name_list ::= func_name_list NK_COMMA col_name */
   -1,  /* (202) func_name ::= function_name */
   -8,  /* (203) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  -10,  /* (204) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
   -6,  /* (205) cmd ::= DROP INDEX exists_opt index_name ON table_name */
    0,  /* (206) index_options ::= */
   -9,  /* (207) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  -11,  /* (208) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
   -1,  /* (209) func_list ::= func */
   -3,  /* (210) func_list ::= func_list NK_COMMA func */
   -4,  /* (211) func ::= function_name NK_LP expression_list NK_RP */
   -6,  /* (212) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
   -6,  /* (213) cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
   -4,  /* (214) cmd ::= DROP TOPIC exists_opt topic_name */
   -2,  /* (215) cmd ::= DESC full_table_name */
   -2,  /* (216) cmd ::= DESCRIBE full_table_name */
   -3,  /* (217) cmd ::= RESET QUERY CACHE */
   -4,  /* (218) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
    0,  /* (219) analyze_opt ::= */
   -1,  /* (220) analyze_opt ::= ANALYZE */
    0,  /* (221) explain_options ::= */
   -3,  /* (222) explain_options ::= explain_options VERBOSE NK_BOOL */
   -3,  /* (223) explain_options ::= explain_options RATIO NK_FLOAT */
   -6,  /* (224) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
   -9,  /* (225) cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
   -3,  /* (226) cmd ::= DROP FUNCTION function_name */
    0,  /* (227) agg_func_opt ::= */
   -1,  /* (228) agg_func_opt ::= AGGREGATE */
    0,  /* (229) bufsize_opt ::= */
   -2,  /* (230) bufsize_opt ::= BUFSIZE NK_INTEGER */
   -7,  /* (231) cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression */
   -3,  /* (232) cmd ::= DROP STREAM stream_name */
   -3,  /* (233) cmd ::= KILL CONNECTION NK_INTEGER */
   -3,  /* (234) cmd ::= KILL QUERY NK_INTEGER */
   -4,  /* (235) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
   -4,  /* (236) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
   -3,  /* (237) cmd ::= SPLIT VGROUP NK_INTEGER */
   -2,  /* (238) dnode_list ::= DNODE NK_INTEGER */
   -3,  /* (239) dnode_list ::= dnode_list DNODE NK_INTEGER */
   -3,  /* (240) cmd ::= SYNCDB db_name REPLICA */
   -1,  /* (241) cmd ::= query_expression */
   -1,  /* (242) literal ::= NK_INTEGER */
   -1,  /* (243) literal ::= NK_FLOAT */
   -1,  /* (244) literal ::= NK_STRING */
   -1,  /* (245) literal ::= NK_BOOL */
   -2,  /* (246) literal ::= TIMESTAMP NK_STRING */
   -1,  /* (247) literal ::= duration_literal */
   -1,  /* (248) literal ::= NULL */
   -1,  /* (249) duration_literal ::= NK_VARIABLE */
   -1,  /* (250) signed ::= NK_INTEGER */
   -2,  /* (251) signed ::= NK_PLUS NK_INTEGER */
   -2,  /* (252) signed ::= NK_MINUS NK_INTEGER */
   -1,  /* (253) signed ::= NK_FLOAT */
   -2,  /* (254) signed ::= NK_PLUS NK_FLOAT */
   -2,  /* (255) signed ::= NK_MINUS NK_FLOAT */
   -1,  /* (256) signed_literal ::= signed */
   -1,  /* (257) signed_literal ::= NK_STRING */
   -1,  /* (258) signed_literal ::= NK_BOOL */
   -2,  /* (259) signed_literal ::= TIMESTAMP NK_STRING */
   -1,  /* (260) signed_literal ::= duration_literal */
   -1,  /* (261) signed_literal ::= NULL */
   -1,  /* (262) literal_list ::= signed_literal */
   -3,  /* (263) literal_list ::= literal_list NK_COMMA signed_literal */
   -1,  /* (264) db_name ::= NK_ID */
   -1,  /* (265) table_name ::= NK_ID */
   -1,  /* (266) column_name ::= NK_ID */
   -1,  /* (267) function_name ::= NK_ID */
   -1,  /* (268) function_name ::= FIRST */
   -1,  /* (269) function_name ::= LAST */
   -1,  /* (270) table_alias ::= NK_ID */
   -1,  /* (271) column_alias ::= NK_ID */
   -1,  /* (272) user_name ::= NK_ID */
   -1,  /* (273) index_name ::= NK_ID */
   -1,  /* (274) topic_name ::= NK_ID */
   -1,  /* (275) stream_name ::= NK_ID */
   -1,  /* (276) expression ::= literal */
   -1,  /* (277) expression ::= pseudo_column */
   -1,  /* (278) expression ::= column_reference */
   -4,  /* (279) expression ::= function_name NK_LP expression_list NK_RP */
   -4,  /* (280) expression ::= function_name NK_LP NK_STAR NK_RP */
   -6,  /* (281) expression ::= function_name NK_LP expression AS type_name NK_RP */
   -1,  /* (282) expression ::= subquery */
   -3,  /* (283) expression ::= NK_LP expression NK_RP */
   -2,  /* (284) expression ::= NK_PLUS expression */
   -2,  /* (285) expression ::= NK_MINUS expression */
   -3,  /* (286) expression ::= expression NK_PLUS expression */
   -3,  /* (287) expression ::= expression NK_MINUS expression */
   -3,  /* (288) expression ::= expression NK_STAR expression */
   -3,  /* (289) expression ::= expression NK_SLASH expression */
   -3,  /* (290) expression ::= expression NK_REM expression */
   -1,  /* (291) expression_list ::= expression */
   -3,  /* (292) expression_list ::= expression_list NK_COMMA expression */
   -1,  /* (293) column_reference ::= column_name */
   -3,  /* (294) column_reference ::= table_name NK_DOT column_name */
   -1,  /* (295) pseudo_column ::= NOW */
   -1,  /* (296) pseudo_column ::= ROWTS */
   -1,  /* (297) pseudo_column ::= TBNAME */
   -1,  /* (298) pseudo_column ::= QSTARTTS */
   -1,  /* (299) pseudo_column ::= QENDTS */
   -1,  /* (300) pseudo_column ::= WSTARTTS */
   -1,  /* (301) pseudo_column ::= WENDTS */
   -1,  /* (302) pseudo_column ::= WDURATION */
   -3,  /* (303) predicate ::= expression compare_op expression */
   -5,  /* (304) predicate ::= expression BETWEEN expression AND expression */
   -6,  /* (305) predicate ::= expression NOT BETWEEN expression AND expression */
   -3,  /* (306) predicate ::= expression IS NULL */
   -4,  /* (307) predicate ::= expression IS NOT NULL */
   -3,  /* (308) predicate ::= expression in_op in_predicate_value */
   -1,  /* (309) compare_op ::= NK_LT */
   -1,  /* (310) compare_op ::= NK_GT */
   -1,  /* (311) compare_op ::= NK_LE */
   -1,  /* (312) compare_op ::= NK_GE */
   -1,  /* (313) compare_op ::= NK_NE */
   -1,  /* (314) compare_op ::= NK_EQ */
   -1,  /* (315) compare_op ::= LIKE */
   -2,  /* (316) compare_op ::= NOT LIKE */
   -1,  /* (317) compare_op ::= MATCH */
   -1,  /* (318) compare_op ::= NMATCH */
   -1,  /* (319) in_op ::= IN */
   -2,  /* (320) in_op ::= NOT IN */
   -3,  /* (321) in_predicate_value ::= NK_LP expression_list NK_RP */
   -1,  /* (322) boolean_value_expression ::= boolean_primary */
   -2,  /* (323) boolean_value_expression ::= NOT boolean_primary */
   -3,  /* (324) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
   -3,  /* (325) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
   -1,  /* (326) boolean_primary ::= predicate */
   -3,  /* (327) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
   -1,  /* (328) common_expression ::= expression */
   -1,  /* (329) common_expression ::= boolean_value_expression */
   -2,  /* (330) from_clause ::= FROM table_reference_list */
   -1,  /* (331) table_reference_list ::= table_reference */
   -3,  /* (332) table_reference_list ::= table_reference_list NK_COMMA table_reference */
   -1,  /* (333) table_reference ::= table_primary */
   -1,  /* (334) table_reference ::= joined_table */
   -2,  /* (335) table_primary ::= table_name alias_opt */
   -4,  /* (336) table_primary ::= db_name NK_DOT table_name alias_opt */
   -2,  /* (337) table_primary ::= subquery alias_opt */
   -1,  /* (338) table_primary ::= parenthesized_joined_table */
    0,  /* (339) alias_opt ::= */
   -1,  /* (340) alias_opt ::= table_alias */
   -2,  /* (341) alias_opt ::= AS table_alias */
   -3,  /* (342) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
   -3,  /* (343) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
   -6,  /* (344) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
    0,  /* (345) join_type ::= */
   -1,  /* (346) join_type ::= INNER */
   -9,  /* (347) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
    0,  /* (348) set_quantifier_opt ::= */
   -1,  /* (349) set_quantifier_opt ::= DISTINCT */
   -1,  /* (350) set_quantifier_opt ::= ALL */
   -1,  /* (351) select_list ::= NK_STAR */
   -1,  /* (352) select_list ::= select_sublist */
   -1,  /* (353) select_sublist ::= select_item */
   -3,  /* (354) select_sublist ::= select_sublist NK_COMMA select_item */
   -1,  /* (355) select_item ::= common_expression */
   -2,  /* (356) select_item ::= common_expression column_alias */
   -3,  /* (357) select_item ::= common_expression AS column_alias */
   -3,  /* (358) select_item ::= table_name NK_DOT NK_STAR */
    0,  /* (359) where_clause_opt ::= */
   -2,  /* (360) where_clause_opt ::= WHERE search_condition */
    0,  /* (361) partition_by_clause_opt ::= */
   -3,  /* (362) partition_by_clause_opt ::= PARTITION BY expression_list */
    0,  /* (363) twindow_clause_opt ::= */
   -6,  /* (364) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
   -4,  /* (365) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
   -6,  /* (366) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
   -8,  /* (367) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
    0,  /* (368) sliding_opt ::= */
   -4,  /* (369) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
    0,  /* (370) fill_opt ::= */
   -4,  /* (371) fill_opt ::= FILL NK_LP fill_mode NK_RP */
   -6,  /* (372) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
   -1,  /* (373) fill_mode ::= NONE */
   -1,  /* (374) fill_mode ::= PREV */
   -1,  /* (375) fill_mode ::= NULL */
   -1,  /* (376) fill_mode ::= LINEAR */
   -1,  /* (377) fill_mode ::= NEXT */
    0,  /* (378) group_by_clause_opt ::= */
   -3,  /* (379) group_by_clause_opt ::= GROUP BY group_by_list */
   -1,  /* (380) group_by_list ::= expression */
   -3,  /* (381) group_by_list ::= group_by_list NK_COMMA expression */
    0,  /* (382) having_clause_opt ::= */
   -2,  /* (383) having_clause_opt ::= HAVING search_condition */
   -4,  /* (384) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
   -1,  /* (385) query_expression_body ::= query_primary */
   -4,  /* (386) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
   -1,  /* (387) query_primary ::= query_specification */
    0,  /* (388) order_by_clause_opt ::= */
   -3,  /* (389) order_by_clause_opt ::= ORDER BY sort_specification_list */
    0,  /* (390) slimit_clause_opt ::= */
   -2,  /* (391) slimit_clause_opt ::= SLIMIT NK_INTEGER */
   -4,  /* (392) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
   -4,  /* (393) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
    0,  /* (394) limit_clause_opt ::= */
   -2,  /* (395) limit_clause_opt ::= LIMIT NK_INTEGER */
   -4,  /* (396) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
   -4,  /* (397) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
   -3,  /* (398) subquery ::= NK_LP query_expression NK_RP */
   -1,  /* (399) search_condition ::= common_expression */
   -1,  /* (400) sort_specification_list ::= sort_specification */
   -3,  /* (401) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
   -3,  /* (402) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
    0,  /* (403) ordering_specification_opt ::= */
   -1,  /* (404) ordering_specification_opt ::= ASC */
   -1,  /* (405) ordering_specification_opt ::= DESC */
    0,  /* (406) null_ordering_opt ::= */
   -2,  /* (407) null_ordering_opt ::= NULLS FIRST */
   -2,  /* (408) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfoNRhs[yyruleno];
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s, pop back to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action",
        yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s]%s.\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno],
        yyruleno<YYNRULE_WITH_ACTION ? "" : " without external action");
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfoNRhs[yyruleno]==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,208,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,209,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,208,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,210,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,211,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,209,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,211,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,210,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy21, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy21, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy21, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy21); }
        break;
      case 28: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy21, NULL); }
        break;
      case 29: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy21, &yymsp[0].minor.yy0); }
        break;
      case 30: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 31: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy21); }
        break;
      case 32: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 33: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 34: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 35: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 36: /* dnode_endpoint ::= NK_STRING */
      case 37: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==37);
      case 38: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==38);
      case 264: /* db_name ::= NK_ID */ yytestcase(yyruleno==264);
      case 265: /* table_name ::= NK_ID */ yytestcase(yyruleno==265);
      case 266: /* column_name ::= NK_ID */ yytestcase(yyruleno==266);
      case 267: /* function_name ::= NK_ID */ yytestcase(yyruleno==267);
      case 268: /* function_name ::= FIRST */ yytestcase(yyruleno==268);
      case 269: /* function_name ::= LAST */ yytestcase(yyruleno==269);
      case 270: /* table_alias ::= NK_ID */ yytestcase(yyruleno==270);
      case 271: /* column_alias ::= NK_ID */ yytestcase(yyruleno==271);
      case 272: /* user_name ::= NK_ID */ yytestcase(yyruleno==272);
      case 273: /* index_name ::= NK_ID */ yytestcase(yyruleno==273);
      case 274: /* topic_name ::= NK_ID */ yytestcase(yyruleno==274);
      case 275: /* stream_name ::= NK_ID */ yytestcase(yyruleno==275);
{ yylhsminor.yy21 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy21 = yylhsminor.yy21;
        break;
      case 39: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 40: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 42: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 43: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 46: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 47: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 48: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy173, &yymsp[-1].minor.yy21, yymsp[0].minor.yy564); }
        break;
      case 50: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy173, &yymsp[0].minor.yy21); }
        break;
      case 51: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy21); }
        break;
      case 52: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy21, yymsp[0].minor.yy564); }
        break;
      case 53: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy173 = true; }
        break;
      case 54: /* not_exists_opt ::= */
      case 56: /* exists_opt ::= */ yytestcase(yyruleno==56);
      case 219: /* analyze_opt ::= */ yytestcase(yyruleno==219);
      case 227: /* agg_func_opt ::= */ yytestcase(yyruleno==227);
      case 348: /* set_quantifier_opt ::= */ yytestcase(yyruleno==348);
{ yymsp[1].minor.yy173 = false; }
        break;
      case 55: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy173 = true; }
        break;
      case 57: /* db_options ::= */
{ yymsp[1].minor.yy564 = createDatabaseOptions(pCxt); }
        break;
      case 58: /* db_options ::= db_options BLOCKS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy564)->pNumOfBlocks = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 59: /* db_options ::= db_options CACHE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy564)->pCacheBlockSize = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 60: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy564)->pCachelast = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 61: /* db_options ::= db_options COMP NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy564)->pCompressionLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 62: /* db_options ::= db_options DAYS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy564)->pDaysPerFile = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 63: /* db_options ::= db_options DAYS NK_VARIABLE */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy564)->pDaysPerFile = (SValueNode*)createDurationValueNode(pCxt, &yymsp[0].minor.yy0); yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 64: /* db_options ::= db_options FSYNC NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy564)->pFsyncPeriod = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 65: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy564)->pMaxRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 66: /* db_options ::= db_options MINROWS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy564)->pMinRowsPerBlock = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 67: /* db_options ::= db_options KEEP integer_list */
      case 68: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==68);
{ ((SDatabaseOptions*)yymsp[-2].minor.yy564)->pKeep = yymsp[0].minor.yy476; yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 69: /* db_options ::= db_options PRECISION NK_STRING */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy564)->pPrecision = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 70: /* db_options ::= db_options QUORUM NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy564)->pQuorum = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 71: /* db_options ::= db_options REPLICA NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy564)->pReplica = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 72: /* db_options ::= db_options TTL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy564)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 73: /* db_options ::= db_options WAL NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy564)->pWalLevel = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 74: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy564)->pNumOfVgroups = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 75: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy564)->pSingleStable = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 76: /* db_options ::= db_options STREAM_MODE NK_INTEGER */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy564)->pStreamMode = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 77: /* db_options ::= db_options RETENTIONS retention_list */
{ ((SDatabaseOptions*)yymsp[-2].minor.yy564)->pRetentions = yymsp[0].minor.yy476; yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 78: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy564 = createDatabaseOptions(pCxt); yylhsminor.yy564 = setDatabaseAlterOption(pCxt, yylhsminor.yy564, &yymsp[0].minor.yy289); }
  yymsp[0].minor.yy564 = yylhsminor.yy564;
        break;
      case 79: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy564 = setDatabaseAlterOption(pCxt, yymsp[-1].minor.yy564, &yymsp[0].minor.yy289); }
  yymsp[-1].minor.yy564 = yylhsminor.yy564;
        break;
      case 80: /* alter_db_option ::= BLOCKS NK_INTEGER */
{ yymsp[-1].minor.yy289.type = DB_OPTION_BLOCKS; yymsp[-1].minor.yy289.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 81: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy289.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy289.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 82: /* alter_db_option ::= KEEP integer_list */
      case 83: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==83);
{ yymsp[-1].minor.yy289.type = DB_OPTION_KEEP; yymsp[-1].minor.yy289.pList = yymsp[0].minor.yy476; }
        break;
      case 84: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy289.type = DB_OPTION_WAL; yymsp[-1].minor.yy289.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 85: /* alter_db_option ::= QUORUM NK_INTEGER */
{ yymsp[-1].minor.yy289.type = DB_OPTION_QUORUM; yymsp[-1].minor.yy289.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 86: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy289.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy289.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 87: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy289.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy289.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 88: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy476 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 89: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 239: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==239);
{ yylhsminor.yy476 = addNodeToList(pCxt, yymsp[-2].minor.yy476, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 90: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy476 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 91: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy476 = addNodeToList(pCxt, yymsp[-2].minor.yy476, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 92: /* retention_list ::= retention */
      case 112: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==112);
      case 115: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==115);
      case 122: /* column_def_list ::= column_def */ yytestcase(yyruleno==122);
      case 165: /* col_name_list ::= col_name */ yytestcase(yyruleno==165);
      case 200: /* func_name_list ::= func_name */ yytestcase(yyruleno==200);
      case 209: /* func_list ::= func */ yytestcase(yyruleno==209);
      case 262: /* literal_list ::= signed_literal */ yytestcase(yyruleno==262);
      case 353: /* select_sublist ::= select_item */ yytestcase(yyruleno==353);
      case 400: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==400);
{ yylhsminor.yy476 = createNodeList(pCxt, yymsp[0].minor.yy564); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 93: /* retention_list ::= retention_list NK_COMMA retention */
      case 123: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==123);
      case 166: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==166);
      case 201: /* func_name_list ::= func_name_list NK_COMMA col_name */ yytestcase(yyruleno==201);
      case 210: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==210);
      case 263: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==263);
      case 354: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==354);
      case 401: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==401);
{ yylhsminor.yy476 = addNodeToList(pCxt, yymsp[-2].minor.yy476, yymsp[0].minor.yy564); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 94: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy564 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 95: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 97: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==97);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy173, yymsp[-5].minor.yy564, yymsp[-3].minor.yy476, yymsp[-1].minor.yy476, yymsp[0].minor.yy564); }
        break;
      case 96: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy476); }
        break;
      case 98: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy476); }
        break;
      case 99: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy173, yymsp[0].minor.yy564); }
        break;
      case 100: /* cmd ::= ALTER TABLE alter_table_clause */
      case 101: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==101);
      case 241: /* cmd ::= query_expression */ yytestcase(yyruleno==241);
{ pCxt->pRootNode = yymsp[0].minor.yy564; }
        break;
      case 102: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy564 = createAlterTableOption(pCxt, yymsp[-1].minor.yy564, yymsp[0].minor.yy564); }
  yymsp[-1].minor.yy564 = yylhsminor.yy564;
        break;
      case 103: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy564 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy564, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy21, yymsp[0].minor.yy288); }
  yymsp[-4].minor.yy564 = yylhsminor.yy564;
        break;
      case 104: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy564 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy564, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy21); }
  yymsp[-3].minor.yy564 = yylhsminor.yy564;
        break;
      case 105: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy564 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy564, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy21, yymsp[0].minor.yy288); }
  yymsp[-4].minor.yy564 = yylhsminor.yy564;
        break;
      case 106: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy564 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy564, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy21, &yymsp[0].minor.yy21); }
  yymsp[-4].minor.yy564 = yylhsminor.yy564;
        break;
      case 107: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy564 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy564, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy21, yymsp[0].minor.yy288); }
  yymsp[-4].minor.yy564 = yylhsminor.yy564;
        break;
      case 108: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy564 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy564, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy21); }
  yymsp[-3].minor.yy564 = yylhsminor.yy564;
        break;
      case 109: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy564 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy564, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy21, yymsp[0].minor.yy288); }
  yymsp[-4].minor.yy564 = yylhsminor.yy564;
        break;
      case 110: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy564 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy564, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy21, &yymsp[0].minor.yy21); }
  yymsp[-4].minor.yy564 = yylhsminor.yy564;
        break;
      case 111: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ literal */
{ yylhsminor.yy564 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy564, &yymsp[-2].minor.yy21, yymsp[0].minor.yy564); }
  yymsp[-5].minor.yy564 = yylhsminor.yy564;
        break;
      case 113: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 116: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==116);
{ yylhsminor.yy476 = addNodeToList(pCxt, yymsp[-1].minor.yy476, yymsp[0].minor.yy564); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 114: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP */
{ yylhsminor.yy564 = createCreateSubTableClause(pCxt, yymsp[-8].minor.yy173, yymsp[-7].minor.yy564, yymsp[-5].minor.yy564, yymsp[-4].minor.yy476, yymsp[-1].minor.yy476); }
  yymsp[-8].minor.yy564 = yylhsminor.yy564;
        break;
      case 117: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy564 = createDropTableClause(pCxt, yymsp[-1].minor.yy173, yymsp[0].minor.yy564); }
  yymsp[-1].minor.yy564 = yylhsminor.yy564;
        break;
      case 118: /* specific_tags_opt ::= */
      case 149: /* tags_def_opt ::= */ yytestcase(yyruleno==149);
      case 361: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==361);
      case 378: /* group_by_clause_opt ::= */ yytestcase(yyruleno==378);
      case 388: /* order_by_clause_opt ::= */ yytestcase(yyruleno==388);
{ yymsp[1].minor.yy476 = NULL; }
        break;
      case 119: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy476 = yymsp[-1].minor.yy476; }
        break;
      case 120: /* full_table_name ::= table_name */
{ yylhsminor.yy564 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy21, NULL); }
  yymsp[0].minor.yy564 = yylhsminor.yy564;
        break;
      case 121: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy564 = createRealTableNode(pCxt, &yymsp[-2].minor.yy21, &yymsp[0].minor.yy21, NULL); }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 124: /* column_def ::= column_name type_name */
{ yylhsminor.yy564 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy21, yymsp[0].minor.yy288, NULL); }
  yymsp[-1].minor.yy564 = yylhsminor.yy564;
        break;
      case 125: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy564 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy21, yymsp[-2].minor.yy288, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy564 = yylhsminor.yy564;
        break;
      case 126: /* type_name ::= BOOL */
{ yymsp[0].minor.yy288 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 127: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy288 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 128: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy288 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 129: /* type_name ::= INT */
      case 130: /* type_name ::= INTEGER */ yytestcase(yyruleno==130);
{ yymsp[0].minor.yy288 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 131: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy288 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 132: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy288 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 133: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy288 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 134: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy288 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 135: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy288 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 136: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy288 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 137: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy288 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 138: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy288 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 139: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy288 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 140: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy288 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 141: /* type_name ::= JSON */
{ yymsp[0].minor.yy288 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 142: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy288 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 143: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy288 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 144: /* type_name ::= BLOB */
{ yymsp[0].minor.yy288 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 145: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy288 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 146: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy288 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 147: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy288 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 148: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy288 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 150: /* tags_def_opt ::= tags_def */
      case 352: /* select_list ::= select_sublist */ yytestcase(yyruleno==352);
{ yylhsminor.yy476 = yymsp[0].minor.yy476; }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 151: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy476 = yymsp[-1].minor.yy476; }
        break;
      case 152: /* table_options ::= */
{ yymsp[1].minor.yy564 = createTableOptions(pCxt); }
        break;
      case 153: /* table_options ::= table_options COMMENT NK_STRING */
{ ((STableOptions*)yymsp[-2].minor.yy564)->pComments = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 154: /* table_options ::= table_options KEEP integer_list */
{ ((STableOptions*)yymsp[-2].minor.yy564)->pKeep = yymsp[0].minor.yy476; yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 155: /* table_options ::= table_options TTL NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy564)->pTtl = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 156: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy564)->pSma = yymsp[-1].minor.yy476; yylhsminor.yy564 = yymsp[-4].minor.yy564; }
  yymsp[-4].minor.yy564 = yylhsminor.yy564;
        break;
      case 157: /* table_options ::= table_options ROLLUP NK_LP func_name_list NK_RP */
{ ((STableOptions*)yymsp[-4].minor.yy564)->pFuncs = yymsp[-1].minor.yy476; yylhsminor.yy564 = yymsp[-4].minor.yy564; }
  yymsp[-4].minor.yy564 = yylhsminor.yy564;
        break;
      case 158: /* table_options ::= table_options FILE_FACTOR NK_FLOAT */
{ ((STableOptions*)yymsp[-2].minor.yy564)->pFilesFactor = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 159: /* table_options ::= table_options DELAY NK_INTEGER */
{ ((STableOptions*)yymsp[-2].minor.yy564)->pDelay = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); yylhsminor.yy564 = yymsp[-2].minor.yy564; }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 160: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy564 = createTableOptions(pCxt); yylhsminor.yy564 = setTableAlterOption(pCxt, yylhsminor.yy564, &yymsp[0].minor.yy289); }
  yymsp[0].minor.yy564 = yylhsminor.yy564;
        break;
      case 161: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy564 = setTableAlterOption(pCxt, yymsp[-1].minor.yy564, &yymsp[0].minor.yy289); }
  yymsp[-1].minor.yy564 = yylhsminor.yy564;
        break;
      case 162: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy289.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy289.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 163: /* alter_table_option ::= KEEP integer_list */
{ yymsp[-1].minor.yy289.type = TABLE_OPTION_KEEP; yymsp[-1].minor.yy289.pList = yymsp[0].minor.yy476; }
        break;
      case 164: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy289.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy289.pVal = (SValueNode*)createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 167: /* col_name ::= column_name */
{ yylhsminor.yy564 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy21); }
  yymsp[0].minor.yy564 = yylhsminor.yy564;
        break;
      case 168: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 169: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 170: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 171: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy564, yymsp[0].minor.yy564); }
        break;
      case 172: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy564, yymsp[0].minor.yy564); }
        break;
      case 173: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy564, NULL); }
        break;
      case 174: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 175: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 176: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 177: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 178: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy564, yymsp[0].minor.yy564); }
        break;
      case 179: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 180: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->valid = false; generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 181: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 182: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 183: /* cmd ::= SHOW LICENCE */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 184: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy21); }
        break;
      case 185: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy564); }
        break;
      case 186: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy564); }
        break;
      case 187: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 188: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 189: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 190: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 191: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT, NULL, NULL); }
        break;
      case 192: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT, NULL, NULL); }
        break;
      case 193: /* db_name_cond_opt ::= */
      case 198: /* from_db_opt ::= */ yytestcase(yyruleno==198);
{ yymsp[1].minor.yy564 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 194: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy564 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy21); }
  yymsp[-1].minor.yy564 = yylhsminor.yy564;
        break;
      case 195: /* like_pattern_opt ::= */
      case 206: /* index_options ::= */ yytestcase(yyruleno==206);
      case 359: /* where_clause_opt ::= */ yytestcase(yyruleno==359);
      case 363: /* twindow_clause_opt ::= */ yytestcase(yyruleno==363);
      case 368: /* sliding_opt ::= */ yytestcase(yyruleno==368);
      case 370: /* fill_opt ::= */ yytestcase(yyruleno==370);
      case 382: /* having_clause_opt ::= */ yytestcase(yyruleno==382);
      case 390: /* slimit_clause_opt ::= */ yytestcase(yyruleno==390);
      case 394: /* limit_clause_opt ::= */ yytestcase(yyruleno==394);
{ yymsp[1].minor.yy564 = NULL; }
        break;
      case 196: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy564 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 197: /* table_name_cond ::= table_name */
{ yylhsminor.yy564 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy21); }
  yymsp[0].minor.yy564 = yylhsminor.yy564;
        break;
      case 199: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy564 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy21); }
        break;
      case 202: /* func_name ::= function_name */
{ yylhsminor.yy564 = createFunctionNode(pCxt, &yymsp[0].minor.yy21, NULL); }
  yymsp[0].minor.yy564 = yylhsminor.yy564;
        break;
      case 203: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy173, &yymsp[-3].minor.yy21, &yymsp[-1].minor.yy21, NULL, yymsp[0].minor.yy564); }
        break;
      case 204: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy173, &yymsp[-5].minor.yy21, &yymsp[-3].minor.yy21, yymsp[-1].minor.yy476, NULL); }
        break;
      case 205: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy173, &yymsp[-2].minor.yy21, &yymsp[0].minor.yy21); }
        break;
      case 207: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy564 = createIndexOption(pCxt, yymsp[-6].minor.yy476, releaseRawExprNode(pCxt, yymsp[-2].minor.yy564), NULL, yymsp[0].minor.yy564); }
        break;
      case 208: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy564 = createIndexOption(pCxt, yymsp[-8].minor.yy476, releaseRawExprNode(pCxt, yymsp[-4].minor.yy564), releaseRawExprNode(pCxt, yymsp[-2].minor.yy564), yymsp[0].minor.yy564); }
        break;
      case 211: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy564 = createFunctionNode(pCxt, &yymsp[-3].minor.yy21, yymsp[-1].minor.yy476); }
  yymsp[-3].minor.yy564 = yylhsminor.yy564;
        break;
      case 212: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy173, &yymsp[-2].minor.yy21, yymsp[0].minor.yy564, NULL); }
        break;
      case 213: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy173, &yymsp[-2].minor.yy21, NULL, &yymsp[0].minor.yy21); }
        break;
      case 214: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy173, &yymsp[0].minor.yy21); }
        break;
      case 215: /* cmd ::= DESC full_table_name */
      case 216: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==216);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy564); }
        break;
      case 217: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 218: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy173, yymsp[-1].minor.yy564, yymsp[0].minor.yy564); }
        break;
      case 220: /* analyze_opt ::= ANALYZE */
      case 228: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==228);
      case 349: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==349);
{ yymsp[0].minor.yy173 = true; }
        break;
      case 221: /* explain_options ::= */
{ yymsp[1].minor.yy564 = createDefaultExplainOptions(pCxt); }
        break;
      case 222: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy564 = setExplainVerbose(pCxt, yymsp[-2].minor.yy564, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 223: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy564 = setExplainRatio(pCxt, yymsp[-2].minor.yy564, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 224: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy476); }
        break;
      case 225: /* cmd ::= CREATE agg_func_opt FUNCTION function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy173, &yymsp[-5].minor.yy21, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy288, yymsp[0].minor.yy620); }
        break;
      case 226: /* cmd ::= DROP FUNCTION function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, &yymsp[0].minor.yy21); }
        break;
      case 229: /* bufsize_opt ::= */
{ yymsp[1].minor.yy620 = 0; }
        break;
      case 230: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy620 = strtol(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 231: /* cmd ::= CREATE STREAM stream_name INTO table_name AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, &yymsp[-4].minor.yy21, &yymsp[-2].minor.yy21, yymsp[0].minor.yy564); }
        break;
      case 232: /* cmd ::= DROP STREAM stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, &yymsp[0].minor.yy21); }
        break;
      case 233: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 234: /* cmd ::= KILL QUERY NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_QUERY_STMT, &yymsp[0].minor.yy0); }
        break;
      case 235: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 236: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy476); }
        break;
      case 237: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 238: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy476 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 240: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy21); }
        break;
      case 242: /* literal ::= NK_INTEGER */
{ yylhsminor.yy564 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy564 = yylhsminor.yy564;
        break;
      case 243: /* literal ::= NK_FLOAT */
{ yylhsminor.yy564 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy564 = yylhsminor.yy564;
        break;
      case 244: /* literal ::= NK_STRING */
{ yylhsminor.yy564 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy564 = yylhsminor.yy564;
        break;
      case 245: /* literal ::= NK_BOOL */
{ yylhsminor.yy564 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy564 = yylhsminor.yy564;
        break;
      case 246: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy564 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy564 = yylhsminor.yy564;
        break;
      case 247: /* literal ::= duration_literal */
      case 256: /* signed_literal ::= signed */ yytestcase(yyruleno==256);
      case 276: /* expression ::= literal */ yytestcase(yyruleno==276);
      case 277: /* expression ::= pseudo_column */ yytestcase(yyruleno==277);
      case 278: /* expression ::= column_reference */ yytestcase(yyruleno==278);
      case 282: /* expression ::= subquery */ yytestcase(yyruleno==282);
      case 322: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==322);
      case 326: /* boolean_primary ::= predicate */ yytestcase(yyruleno==326);
      case 328: /* common_expression ::= expression */ yytestcase(yyruleno==328);
      case 329: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==329);
      case 331: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==331);
      case 333: /* table_reference ::= table_primary */ yytestcase(yyruleno==333);
      case 334: /* table_reference ::= joined_table */ yytestcase(yyruleno==334);
      case 338: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==338);
      case 385: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==385);
      case 387: /* query_primary ::= query_specification */ yytestcase(yyruleno==387);
{ yylhsminor.yy564 = yymsp[0].minor.yy564; }
  yymsp[0].minor.yy564 = yylhsminor.yy564;
        break;
      case 248: /* literal ::= NULL */
{ yylhsminor.yy564 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL)); }
  yymsp[0].minor.yy564 = yylhsminor.yy564;
        break;
      case 249: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy564 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy564 = yylhsminor.yy564;
        break;
      case 250: /* signed ::= NK_INTEGER */
{ yylhsminor.yy564 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy564 = yylhsminor.yy564;
        break;
      case 251: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy564 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 252: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy564 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy564 = yylhsminor.yy564;
        break;
      case 253: /* signed ::= NK_FLOAT */
{ yylhsminor.yy564 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy564 = yylhsminor.yy564;
        break;
      case 254: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy564 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 255: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy564 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy564 = yylhsminor.yy564;
        break;
      case 257: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy564 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy564 = yylhsminor.yy564;
        break;
      case 258: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy564 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy564 = yylhsminor.yy564;
        break;
      case 259: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy564 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 260: /* signed_literal ::= duration_literal */
      case 355: /* select_item ::= common_expression */ yytestcase(yyruleno==355);
      case 399: /* search_condition ::= common_expression */ yytestcase(yyruleno==399);
{ yylhsminor.yy564 = releaseRawExprNode(pCxt, yymsp[0].minor.yy564); }
  yymsp[0].minor.yy564 = yylhsminor.yy564;
        break;
      case 261: /* signed_literal ::= NULL */
{ yymsp[0].minor.yy564 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, NULL); }
        break;
      case 279: /* expression ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy564 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy21, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy21, yymsp[-1].minor.yy476)); }
  yymsp[-3].minor.yy564 = yylhsminor.yy564;
        break;
      case 280: /* expression ::= function_name NK_LP NK_STAR NK_RP */
{ yylhsminor.yy564 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy21, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy21, createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy0)))); }
  yymsp[-3].minor.yy564 = yylhsminor.yy564;
        break;
      case 281: /* expression ::= function_name NK_LP expression AS type_name NK_RP */
{
                                                                                    SNodeList *p = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy564));
                                                                                    p = addValueNodeFromTypeToList(pCxt, yymsp[-1].minor.yy288, p);
                                                                                    yylhsminor.yy564 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy21, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-5].minor.yy21, p));
                                                                                  }
  yymsp[-5].minor.yy564 = yylhsminor.yy564;
        break;
      case 283: /* expression ::= NK_LP expression NK_RP */
      case 327: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==327);
{ yylhsminor.yy564 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy564)); }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 284: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy564);
                                                                                    yylhsminor.yy564 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy564));
                                                                                  }
  yymsp[-1].minor.yy564 = yylhsminor.yy564;
        break;
      case 285: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy564);
                                                                                    yylhsminor.yy564 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy564), NULL));
                                                                                  }
  yymsp[-1].minor.yy564 = yylhsminor.yy564;
        break;
      case 286: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy564);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy564);
                                                                                    yylhsminor.yy564 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy564), releaseRawExprNode(pCxt, yymsp[0].minor.yy564))); 
                                                                                  }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 287: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy564);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy564);
                                                                                    yylhsminor.yy564 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy564), releaseRawExprNode(pCxt, yymsp[0].minor.yy564))); 
                                                                                  }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 288: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy564);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy564);
                                                                                    yylhsminor.yy564 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy564), releaseRawExprNode(pCxt, yymsp[0].minor.yy564))); 
                                                                                  }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 289: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy564);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy564);
                                                                                    yylhsminor.yy564 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy564), releaseRawExprNode(pCxt, yymsp[0].minor.yy564))); 
                                                                                  }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 290: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy564);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy564);
                                                                                    yylhsminor.yy564 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MOD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy564), releaseRawExprNode(pCxt, yymsp[0].minor.yy564))); 
                                                                                  }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 291: /* expression_list ::= expression */
{ yylhsminor.yy476 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy564)); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 292: /* expression_list ::= expression_list NK_COMMA expression */
{ yylhsminor.yy476 = addNodeToList(pCxt, yymsp[-2].minor.yy476, releaseRawExprNode(pCxt, yymsp[0].minor.yy564)); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 293: /* column_reference ::= column_name */
{ yylhsminor.yy564 = createRawExprNode(pCxt, &yymsp[0].minor.yy21, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy21)); }
  yymsp[0].minor.yy564 = yylhsminor.yy564;
        break;
      case 294: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy564 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy21, &yymsp[0].minor.yy21, createColumnNode(pCxt, &yymsp[-2].minor.yy21, &yymsp[0].minor.yy21)); }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 295: /* pseudo_column ::= NOW */
      case 296: /* pseudo_column ::= ROWTS */ yytestcase(yyruleno==296);
      case 297: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==297);
      case 298: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==298);
      case 299: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==299);
      case 300: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==300);
      case 301: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==301);
      case 302: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==302);
{ yylhsminor.yy564 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy564 = yylhsminor.yy564;
        break;
      case 303: /* predicate ::= expression compare_op expression */
      case 308: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==308);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy564);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy564);
                                                                                    yylhsminor.yy564 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy468, releaseRawExprNode(pCxt, yymsp[-2].minor.yy564), releaseRawExprNode(pCxt, yymsp[0].minor.yy564)));
                                                                                  }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 304: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy564);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy564);
                                                                                    yylhsminor.yy564 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy564), releaseRawExprNode(pCxt, yymsp[-2].minor.yy564), releaseRawExprNode(pCxt, yymsp[0].minor.yy564)));
                                                                                  }
  yymsp[-4].minor.yy564 = yylhsminor.yy564;
        break;
      case 305: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy564);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy564);
                                                                                    yylhsminor.yy564 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy564), releaseRawExprNode(pCxt, yymsp[-5].minor.yy564), releaseRawExprNode(pCxt, yymsp[0].minor.yy564)));
                                                                                  }
  yymsp[-5].minor.yy564 = yylhsminor.yy564;
        break;
      case 306: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy564);
                                                                                    yylhsminor.yy564 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy564), NULL));
                                                                                  }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 307: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy564);
                                                                                    yylhsminor.yy564 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy564), NULL));
                                                                                  }
  yymsp[-3].minor.yy564 = yylhsminor.yy564;
        break;
      case 309: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy468 = OP_TYPE_LOWER_THAN; }
        break;
      case 310: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy468 = OP_TYPE_GREATER_THAN; }
        break;
      case 311: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy468 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 312: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy468 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 313: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy468 = OP_TYPE_NOT_EQUAL; }
        break;
      case 314: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy468 = OP_TYPE_EQUAL; }
        break;
      case 315: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy468 = OP_TYPE_LIKE; }
        break;
      case 316: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy468 = OP_TYPE_NOT_LIKE; }
        break;
      case 317: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy468 = OP_TYPE_MATCH; }
        break;
      case 318: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy468 = OP_TYPE_NMATCH; }
        break;
      case 319: /* in_op ::= IN */
{ yymsp[0].minor.yy468 = OP_TYPE_IN; }
        break;
      case 320: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy468 = OP_TYPE_NOT_IN; }
        break;
      case 321: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy564 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy476)); }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 323: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy564);
                                                                                    yylhsminor.yy564 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy564), NULL));
                                                                                  }
  yymsp[-1].minor.yy564 = yylhsminor.yy564;
        break;
      case 324: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy564);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy564);
                                                                                    yylhsminor.yy564 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy564), releaseRawExprNode(pCxt, yymsp[0].minor.yy564)));
                                                                                  }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 325: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy564);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy564);
                                                                                    yylhsminor.yy564 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy564), releaseRawExprNode(pCxt, yymsp[0].minor.yy564)));
                                                                                  }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 330: /* from_clause ::= FROM table_reference_list */
      case 360: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==360);
      case 383: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==383);
{ yymsp[-1].minor.yy564 = yymsp[0].minor.yy564; }
        break;
      case 332: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy564 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy564, yymsp[0].minor.yy564, NULL); }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 335: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy564 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy21, &yymsp[0].minor.yy21); }
  yymsp[-1].minor.yy564 = yylhsminor.yy564;
        break;
      case 336: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy564 = createRealTableNode(pCxt, &yymsp[-3].minor.yy21, &yymsp[-1].minor.yy21, &yymsp[0].minor.yy21); }
  yymsp[-3].minor.yy564 = yylhsminor.yy564;
        break;
      case 337: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy564 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy564), &yymsp[0].minor.yy21); }
  yymsp[-1].minor.yy564 = yylhsminor.yy564;
        break;
      case 339: /* alias_opt ::= */
{ yymsp[1].minor.yy21 = nil_token;  }
        break;
      case 340: /* alias_opt ::= table_alias */
{ yylhsminor.yy21 = yymsp[0].minor.yy21; }
  yymsp[0].minor.yy21 = yylhsminor.yy21;
        break;
      case 341: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy21 = yymsp[0].minor.yy21; }
        break;
      case 342: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 343: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==343);
{ yymsp[-2].minor.yy564 = yymsp[-1].minor.yy564; }
        break;
      case 344: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy564 = createJoinTableNode(pCxt, yymsp[-4].minor.yy440, yymsp[-5].minor.yy564, yymsp[-2].minor.yy564, yymsp[0].minor.yy564); }
  yymsp[-5].minor.yy564 = yylhsminor.yy564;
        break;
      case 345: /* join_type ::= */
{ yymsp[1].minor.yy440 = JOIN_TYPE_INNER; }
        break;
      case 346: /* join_type ::= INNER */
{ yymsp[0].minor.yy440 = JOIN_TYPE_INNER; }
        break;
      case 347: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy564 = createSelectStmt(pCxt, yymsp[-7].minor.yy173, yymsp[-6].minor.yy476, yymsp[-5].minor.yy564);
                                                                                    yymsp[-8].minor.yy564 = addWhereClause(pCxt, yymsp[-8].minor.yy564, yymsp[-4].minor.yy564);
                                                                                    yymsp[-8].minor.yy564 = addPartitionByClause(pCxt, yymsp[-8].minor.yy564, yymsp[-3].minor.yy476);
                                                                                    yymsp[-8].minor.yy564 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy564, yymsp[-2].minor.yy564);
                                                                                    yymsp[-8].minor.yy564 = addGroupByClause(pCxt, yymsp[-8].minor.yy564, yymsp[-1].minor.yy476);
                                                                                    yymsp[-8].minor.yy564 = addHavingClause(pCxt, yymsp[-8].minor.yy564, yymsp[0].minor.yy564);
                                                                                  }
        break;
      case 350: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy173 = false; }
        break;
      case 351: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy476 = NULL; }
        break;
      case 356: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy564 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy564), &yymsp[0].minor.yy21); }
  yymsp[-1].minor.yy564 = yylhsminor.yy564;
        break;
      case 357: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy564 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy564), &yymsp[0].minor.yy21); }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 358: /* select_item ::= table_name NK_DOT NK_STAR */
{ yylhsminor.yy564 = createColumnNode(pCxt, &yymsp[-2].minor.yy21, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 362: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 379: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==379);
      case 389: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==389);
{ yymsp[-2].minor.yy476 = yymsp[0].minor.yy476; }
        break;
      case 364: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy564 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy564), releaseRawExprNode(pCxt, yymsp[-1].minor.yy564)); }
        break;
      case 365: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy564 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy564)); }
        break;
      case 366: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy564 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy564), NULL, yymsp[-1].minor.yy564, yymsp[0].minor.yy564); }
        break;
      case 367: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy564 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy564), releaseRawExprNode(pCxt, yymsp[-3].minor.yy564), yymsp[-1].minor.yy564, yymsp[0].minor.yy564); }
        break;
      case 369: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy564 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy564); }
        break;
      case 371: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy564 = createFillNode(pCxt, yymsp[-1].minor.yy268, NULL); }
        break;
      case 372: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy564 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy476)); }
        break;
      case 373: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy268 = FILL_MODE_NONE; }
        break;
      case 374: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy268 = FILL_MODE_PREV; }
        break;
      case 375: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy268 = FILL_MODE_NULL; }
        break;
      case 376: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy268 = FILL_MODE_LINEAR; }
        break;
      case 377: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy268 = FILL_MODE_NEXT; }
        break;
      case 380: /* group_by_list ::= expression */
{ yylhsminor.yy476 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy564))); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 381: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy476 = addNodeToList(pCxt, yymsp[-2].minor.yy476, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy564))); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 384: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy564 = addOrderByClause(pCxt, yymsp[-3].minor.yy564, yymsp[-2].minor.yy476);
                                                                                    yylhsminor.yy564 = addSlimitClause(pCxt, yylhsminor.yy564, yymsp[-1].minor.yy564);
                                                                                    yylhsminor.yy564 = addLimitClause(pCxt, yylhsminor.yy564, yymsp[0].minor.yy564);
                                                                                  }
  yymsp[-3].minor.yy564 = yylhsminor.yy564;
        break;
      case 386: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy564 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy564, yymsp[0].minor.yy564); }
  yymsp[-3].minor.yy564 = yylhsminor.yy564;
        break;
      case 391: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 395: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==395);
{ yymsp[-1].minor.yy564 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 392: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 396: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==396);
{ yymsp[-3].minor.yy564 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 393: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 397: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==397);
{ yymsp[-3].minor.yy564 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 398: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy564 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy564); }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 402: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy564 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy564), yymsp[-1].minor.yy256, yymsp[0].minor.yy525); }
  yymsp[-2].minor.yy564 = yylhsminor.yy564;
        break;
      case 403: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy256 = ORDER_ASC; }
        break;
      case 404: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy256 = ORDER_ASC; }
        break;
      case 405: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy256 = ORDER_DESC; }
        break;
      case 406: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy525 = NULL_ORDER_DEFAULT; }
        break;
      case 407: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy525 = NULL_ORDER_FIRST; }
        break;
      case 408: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy525 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfoLhs)/sizeof(yyRuleInfoLhs[0]) );
  yygoto = yyRuleInfoLhs[yyruleno];
  yysize = yyRuleInfoNRhs[yyruleno];
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (pCxt->valid) {
    if(TOKEN.z) {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
    pCxt->valid = false;
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  assert( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) );
  return yyFallback[iToken];
#else
  (void)iToken;
  return 0;
#endif
}
