###################################################################
#           Copyright (c) 2021 by TAOS Technologies, Inc.
#                     All rights reserved.
#
#  This file is proprietary and confidential to TAOS Technologies.
#  No part of this file may be reproduced, stored, transmitted,
#  disclosed or used in any form or by any means other than as
#  expressly provided by the written permission from Jianhui Tao
#
###################################################################

# -*- coding: utf-8 -*-

import sys
from util.log import *
from util.cases import *
from util.sql import *


class TDTestCase:
    def caseDescription(self):
        '''
        case1<Ganlin Zhao>: [TD-11220]<feature>: time related functions
        '''
        return

    def init(self, conn, logSql):
        tdLog.debug("start to execute %s" % __file__)
        tdSql.init(conn.cursor(), logSql)

    def getBuildPath(self):
        selfPath = os.path.dirname(os.path.realpath(__file__))

        if ("community" in selfPath):
            projPath = selfPath[:selfPath.find("community")]
        else:
            projPath = selfPath[:selfPath.find("tests")]

        for root, dirs, files in os.walk(projPath):
            if ("taosd" in files):
                rootRealPath = os.path.dirname(os.path.realpath(root))
                if ("packaging" not in rootRealPath):
                    buildPath = root[:len(root) - len("/build/bin")]
                    break
        return buildPath

    def getCurrentTime(self, optr = None, delta = None):
        curTime = datetime.datetime.now()
        if optr is not None:
            if delta is not None:
                if optr == '+':
                    curTime = curTime + delta
                elif optr == '-':
                    curTime = curTime - delta
                else:
                    print("invalid oprands")
                    return
        return curTime.strftime("%Y-%m-%d %H:%M:%S")

    def checkTimestampEqual(self, elm, expect_elm):
        caller = inspect.getframeinfo(inspect.stack()[1][0])
        if len(elm) == len(expect_elm):
            delta = abs(int(elm[-1]) - int(expect_elm[-1]))
            if delta == 1: #ignore 1 second diff
                new_elm = expect_elm[0:-1] + elm[-1]
            elif delta == 9: #case 1:59 - 2:00
                if abs(int(elm[-2]) - int(expect_elm[-2])) == 5 and abs(int(elm[-4]) - int(expect_elm[-4])) == 1:
                    new_elm = elm
                elif abs(int(elm[-2]) - int(expect_elm[-2])) == 1 and abs(int(elm[-4]) - int(expect_elm[-4])) == 0:
                    new_elm = elm
                else:
                    new_elm = expect_elm;
            else:
                new_elm = expect_elm;
            if elm == new_elm:
                tdLog.info("sql:%s, elm:%s == expect_elm:%s" % (tdSql.sql, elm, new_elm))
            else:
                args = (caller.filename, caller.lineno, tdSql.sql, elm, new_elm)
                tdLog.exit("%s(%d) failed: sql:%s, elm:%s != expect_elm:%s" % args)
        else:
            args = (caller.filename, caller.lineno, tdSql.sql, elm, expect_elm)
            tdLog.exit("%s(%d) failed: sql:%s, elm:%s != expect_elm:%s" % args)

    def trimDecimal(self, ts_str):
        index = ts_str.find(".")
        if index == -1:
            return ts_str
        else:
            return ts_str[:index]

    def run(self):
        print("running {}".format(__file__))

        #Prepare data
        #db precision "ms"
        tdSql.execute("drop database if exists db_m")
        tdSql.execute("create database if not exists db_m")
        tdSql.execute('use db_m')

        tdSql.execute("create stable stb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb using stb tags ('2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        #db precision "us"
        tdSql.execute("drop database if exists db_u")
        tdSql.execute("create database if not exists db_u precision 'us'")
        tdSql.execute('use db_u')

        tdSql.execute("create stable stb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb using stb tags ('2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        #db precision "ns"
        tdSql.execute("drop database if exists db_n")
        tdSql.execute("create database if not exists db_n precision 'ns'")
        tdSql.execute('use db_n')

        tdSql.execute("create stable stb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb using stb tags ('2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        tdSql.execute("insert into tb values ('2022-02-02 02:00:00', '2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        #execute query
        print("============== STEP 1: select now()  ================== ")

        # db precision "ms"
        tdSql.execute('use db_m')

        tdSql.query("select now() from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        #now() plus timeunit
        tdSql.query("select now() + 1b from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 1b from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 1b from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() + 1u from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 1u from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 1u from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() + 1a from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 1a from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 1a from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() + 1s from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(seconds = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 1s from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(seconds = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 1s from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(seconds = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() + 1m from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(minutes = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 1m from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(minutes = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 1m from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(minutes = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() + 1h from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(hours = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 1h from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(hours = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 1h from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(hours = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() + 1d from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(days = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 1d from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(days = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 1d from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(days = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() + 1w from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(weeks = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 1w from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(weeks = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 1w from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(weeks = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        #now() minus timeunit
        tdSql.query("select now() - 1b from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 1b from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 1b from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() - 1u from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 1u from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 1u from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() - 1a from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 1a from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 1a from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() - 1s from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(seconds = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 1s from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(seconds = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 1s from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(seconds = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() - 1m from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(minutes = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 1m from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(minutes = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 1m from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(minutes = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() - 1h from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(hours = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 1h from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(hours = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 1h from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(hours = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() - 1d from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(days = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 1d from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(days = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 1d from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(days = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() - 1w from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(weeks = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 1w from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(weeks = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 1w from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(weeks = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        #now() mixed airthmetic with timeunit
        tdSql.query("select now() + 2h + 15m + 30s from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(hours = 2, minutes = 15, seconds = 30))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 2h + 15m + 30s from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(hours = 2, minutes = 15, seconds = 30))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 2h + 15m + 30s from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(hours = 2, minutes = 15, seconds = 30))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() - 2h - 15m - 30s from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(hours = 2, minutes = 15, seconds = 30))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 2h - 15m - 30s from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(hours = 2, minutes = 15, seconds = 30))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 2h - 15m - 30s from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(hours = 2, minutes = 15, seconds = 30))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() - 2w + 2d + 2h - 15m + 30s from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(weeks = -2, days = +2, hours = 2, minutes = -15, seconds = 30))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 2w + 2d + 2h - 15m + 30s from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(weeks = -2, days = +2, hours = 2, minutes = -15, seconds = 30))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 2w + 2d + 2h - 15m + 30s from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(weeks = -2, days = +2, hours = 2, minutes = -15, seconds = 30))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() - 30s - 31s + 30m + 31m - 23h - 2h from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(days = -1, seconds = -1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 30s - 31s + 30m + 31m - 23h - 2h from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(days = -1, seconds = -1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 30s - 31s + 30m + 31m - 23h - 2h from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(days = -1, seconds = -1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() + 7w + 7d + 24h + 60m + 60s + 1000a from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(weeks = 8, days = 1, hours = 1, minutes = 1, seconds = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 7w + 7d + 24h + 60m + 60s + 1000a from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(weeks = 8, days = 1, hours = 1, minutes = 1, seconds = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 7w + 7d + 24h + 60m + 60s + 1000a from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('+', datetime.timedelta(weeks = 8, days = 1, hours = 1, minutes = 1, seconds = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() - 7w - 7d - 24h - 60m - 60s - 1000a from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(weeks = 8, days = 1, hours = 1, minutes = 1, seconds = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 7w - 7d - 24h - 60m - 60s - 1000a from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(weeks = 8, days = 1, hours = 1, minutes = 1, seconds = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 7w - 7d - 24h - 60m - 60s - 1000a from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(weeks = 8, days = 1, hours = 1, minutes = 1, seconds = 1))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() - 1w + 7d - 1h + 60m - 1s + 1000a from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 1w + 7d - 1h + 60m - 1s + 1000a from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() - 1w + 7d - 1h + 60m - 1s + 1000a from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() + 1w - 7d + 1h - 60m + 1s - 1000a from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 1w - 7d + 1h - 60m + 1s - 1000a from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 1w - 7d + 1h - 60m + 1s - 1000a from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() + 1w + -7d + 1h + -60m + 1s + -1000a from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 1w + -7d + 1h + -60m + 1s + -1000a from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 1w + -7d + 1h + -60m + 1s + -1000a from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() + 15d + 15w + 15s + 15m + 15h - 30s - 30m - 30d - 30w - 30h from tb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(weeks = 15, days = 15, hours = 15, minutes = 15, seconds = 15))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 15d + 15w + 15s + 15m + 15h - 30s - 30m - 30d - 30w - 30h from ctb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(weeks = 15, days = 15, hours = 15, minutes = 15, seconds = 15))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() + 15d + 15w + 15s + 15m + 15h - 30s - 30m - 30d - 30w - 30h from stb")
        tdSql.checkRows(1)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime('-', datetime.timedelta(weeks = 15, days = 15, hours = 15, minutes = 15, seconds = 15))
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        #TODO: now in the intermidiate position not working yet calloc failure
        #tdSql.query("select 1w + -7d + 1h + now() -60m + 1s + -1000a from tb")
        #tdSql.checkRows(1)
        #res = tdSql.getData(0, 0)
        #now = self.getCurrentTime()
        #self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        #now(), col
        tdSql.query("select now(),col_bigint from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, 1)
        tdSql.query("select now(),col_bigint from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, 1)
        tdSql.query("select now(),col_bigint from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, 1)

        tdSql.query("select now(),col_bool from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, True)
        tdSql.query("select now(),col_bool from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, True)
        tdSql.query("select now(),col_bool from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, True)

        tdSql.query("select now(),col_float from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select now(),col_float from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select now(),col_float from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, 1.0)

        tdSql.query("select now(),col_binary from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, "abc")
        tdSql.query("select now(),col_binary from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, "abc")
        tdSql.query("select now(),col_binary from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, "abc")

        tdSql.query("select ts, col_smallint, col_float, now(), col_binary, col_timestamp from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(6)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(0, 2, 1.0)
        res = tdSql.getData(0, 3)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 4, "abc")
        res = tdSql.getData(0, 5)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select ts, col_smallint, col_float, now(), col_binary, col_timestamp from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(6)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(0, 2, 1.0)
        res = tdSql.getData(0, 3)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 4, "abc")
        res = tdSql.getData(0, 5)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select ts, col_smallint, col_float, now(), col_binary, col_timestamp from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(6)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.checkData(0, 1, 1)
        tdSql.checkData(0, 2, 1.0)
        res = tdSql.getData(0, 3)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 4, "abc")
        res = tdSql.getData(0, 5)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")

        #now(), tag
        tdSql.query("select now(),tag_bigint from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, 1)
        tdSql.query("select now(),tag_bigint from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, 1)

        tdSql.query("select now(),tag_bool from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, True)
        tdSql.query("select now(),tag_bool from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, True)

        tdSql.query("select now(),tag_float from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select now(),tag_float from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, 1.0)

        tdSql.query("select now(),tag_binary from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, "abc")
        tdSql.query("select now(),tag_binary from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, "abc")

        tdSql.query("select tag_smallint, tag_float, now(), tag_binary, tag_timestamp from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1.0)
        res = tdSql.getData(0, 2)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 3, "abc")
        res = tdSql.getData(0, 4)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select tag_smallint, tag_float, now(), tag_binary, tag_timestamp from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(0, 1, 1.0)
        res = tdSql.getData(0, 2)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 3, "abc")
        res = tdSql.getData(0, 4)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")

        #now(),tbname
        tdSql.query("select now(),tbname from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, "tb")
        tdSql.query("select now(),tbname from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, "ctb")
        tdSql.query("select now(),tbname from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, "ctb")

        #now(),_c0/_C0
        tdSql.query("select now(),_c0 from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select now(),_c0 from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        tdSql.query("select now(),_c0 from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")

        tdSql.query("select _C0,now() from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(0, 1)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select _C0,now() from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(0, 1)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select _C0,now() from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(str(res), "2022-02-02 02:00:00")
        res = tdSql.getData(0, 1)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        #now(),func()
        #can only be used with scalar functions together
        tdSql.query("select now(),ceil(col_bigint) from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, 1)
        tdSql.query("select now(),ceil(col_bigint) from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, 1)
        tdSql.query("select now(),ceil(col_bigint) from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, 1)

        tdSql.query("select now(),round(col_float) from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select now(),round(col_float) from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select now(),round(col_float) from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, 1.0)

        tdSql.query("select now(),floor(1.5) from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select now(),floor(1.5) from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, 1.0)
        tdSql.query("select now(),floor(1.5) from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.checkData(0, 1, 1.0)

        tdSql.query("select abs(-1),now() from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        res = tdSql.getData(0, 1)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select abs(-1),now() from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        res = tdSql.getData(0, 1)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select abs(-1),now() from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 1)
        res = tdSql.getData(0, 1)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select pow(2,2),now() from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 4.0)
        res = tdSql.getData(0, 1)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select pow(2,2),now() from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 4.0)
        res = tdSql.getData(0, 1)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select pow(2,2),now() from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        tdSql.checkData(0, 0, 4.0)
        res = tdSql.getData(0, 1)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        #now(),now()
        tdSql.query("select now(),now(),now() from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(3)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 2)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now(),now(),now() from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(3)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 2)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now(),now(),now() from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(3)
        res = tdSql.getData(0, 0)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 2)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        #now(),constant
        tdSql.query("select 123,123.0,true,'123',now() from tb")
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 123)
        tdSql.checkData(0, 1, 123.0)
        tdSql.checkData(0, 2, True)
        tdSql.checkData(0, 3, '123')
        res = tdSql.getData(0, 4)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select 123,123.0,true,'123',now() from ctb")
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 123)
        tdSql.checkData(0, 1, 123.0)
        tdSql.checkData(0, 2, True)
        tdSql.checkData(0, 3, '123')
        res = tdSql.getData(0, 4)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select 123,123.0,true,'123',now() from stb")
        tdSql.checkRows(1)
        tdSql.checkCols(5)
        tdSql.checkData(0, 0, 123)
        tdSql.checkData(0, 1, 123.0)
        tdSql.checkData(0, 2, True)
        tdSql.checkData(0, 3, '123')
        res = tdSql.getData(0, 4)
        now = self.getCurrentTime()
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        #insert some more data
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:01', '2022-02-02 02:00:01', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:01', '2022-02-02 02:00:01', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values ('2022-02-02 02:00:02', '2022-02-02 02:00:02', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into tb values ('2022-02-02 02:00:02', '2022-02-02 02:00:02', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")

        #order by
        tdSql.query("select now() from tb order by ts")
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() from ctb order by ts")
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() from stb order by ts")
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() from tb order by ts desc")
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() from ctb order by ts desc")
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() from stb order by ts desc")
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        #limit/offset
        tdSql.query("select now() from tb limit 2")
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() from ctb limit 2")
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() from stb limit 2")
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() from tb limit 2 offset 1")
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() from ctb limit 2 offset 1")
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() from stb limit 2 offset 1")
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query("select now() from tb limit 1,2")
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() from ctb limit 1,2")
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query("select now() from stb limit 1,2")
        tdSql.checkRows(2)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        #join
        tdSql.execute("create stable stb1 (col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb1 using stb1 tags (now, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb1 (col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb1 values ('2022-01-01 00:00:00', -9, -9, -9, -9, -9.5, -9.5, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb1 values ('2022-01-01 00:00:01', -1, -1, -1, -1, -1.5, -1.5, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb1 values ('2022-01-01 00:00:02', 1, 1, 1, 1, 1.5, 1.5, true, 'abc', 'abc');")

        tdSql.execute("insert into tb1 values ('2022-01-01 00:00:00', -9, -9, -9, -9, -9.5, -9.5, true, 'abc', 'abc');")
        tdSql.execute("insert into tb1 values ('2022-01-01 00:00:01', -1, -1, -1, -1, -1.5, -1.5, true, 'abc', 'abc');")
        tdSql.execute("insert into tb1 values ('2022-01-01 00:00:02', 1, 1, 1, 1, 1.5, 1.5, true, 'abc', 'abc');")

        tdSql.execute("create stable stb2 (col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb2 using stb2 tags (now, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb2 (col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into ctb2 values ('2022-01-01 00:00:00', -9, -9, -9, -9, -9.5, -9.5, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb2 values ('2022-01-01 00:00:01', -1, -1, -1, -1, -1.5, -1.5, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb2 values ('2022-01-01 00:00:02', 1, 1, 1, 1, 1.5, 1.5, true, 'abc', 'abc');")

        tdSql.execute("insert into tb2 values ('2022-01-01 00:00:00', -9, -9, -9, -9, -9.5, -9.5, true, 'abc', 'abc');")
        tdSql.execute("insert into tb2 values ('2022-01-01 00:00:01', -1, -1, -1, -1, -1.5, -1.5, true, 'abc', 'abc');")
        tdSql.execute("insert into tb2 values ('2022-01-01 00:00:02', 1, 1, 1, 1, 1.5, 1.5, true, 'abc', 'abc');")

        tdSql.query('select now() from tb1, tb2 where tb1.col_timestamp = tb2.col_timestamp');
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query('select now() from ctb1, ctb2 where ctb1.col_timestamp = ctb2.col_timestamp');
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query('select now() from stb1, stb2 where stb1.col_timestamp = stb2.col_timestamp and stb1.tag_int = stb2.tag_int');
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        #union all
        tdSql.query('select now() from tb1 union all select now() from tb2')
        tdSql.checkRows(6)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(3, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(4, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(5, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select now() from ctb1 union all select now() from ctb2')
        tdSql.checkRows(6)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(3, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(4, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(5, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select now() from stb1 union all select now() from stb2')
        tdSql.checkRows(6)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(3, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(4, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(5, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        #nested query
        tdSql.query('select now() from (select * from tb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select now() from (select * from ctb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select now() from (select * from stb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query('select now() from (select col_int as val from tb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select now() from (select col_int as val from ctb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select now() from (select col_int as val from stb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query('select * from (select now() from tb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select * from (select now() from ctb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select * from (select now() from stb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query('select _c0 from (select now() from tb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select _c0 from (select now() from ctb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select _c0 from (select now() from stb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.query('select now() from (select now() from tb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select now() from (select now() from ctb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select now() from (select now() from stb)')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(1, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(2, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        print("============== STEP 2: where now()  ================== ")
        tdSql.query('select col_int from tb where ts < now()')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from ctb where ts < now()')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from stb where ts < now()')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        tdSql.query('select col_int from tb where ts < now() + 1w')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from ctb where ts < now() + 1w')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from stb where ts < now() + 1w')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        tdSql.query('select col_int from tb where ts < now() + 10d')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from ctb where ts < now() + 10d')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from stb where ts < now() + 10d')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        tdSql.query('select col_int from tb where ts < now() + 12h')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from ctb where ts < now() + 12h')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from stb where ts < now() + 12h')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        tdSql.query('select col_int from tb where ts < now() + 30m')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from ctb where ts < now() + 30m')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from stb where ts < now() + 30m')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        tdSql.query('select col_int from tb where ts < now() + 80s')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from ctb where ts < now() + 80s')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from stb where ts < now() + 80s')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        tdSql.query('select col_int from tb where ts < now() + 100a')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from ctb where ts < now() + 100a')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from stb where ts < now() + 100a')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        tdSql.query('select col_int from tb where ts < now() + 100u')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from ctb where ts < now() + 100u')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from stb where ts < now() + 100u')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        tdSql.query('select col_int from tb where ts < now() + 100b')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from ctb where ts < now() + 100b')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from stb where ts < now() + 100b')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        tdSql.query('select col_int from tb where ts > now()')
        tdSql.checkRows(0)
        tdSql.query('select col_int from ctb where ts > now()')
        tdSql.checkRows(0)
        tdSql.query('select col_int from stb where ts > now()')
        tdSql.checkRows(0)

        tdSql.query('select col_int from tb where col_timestamp > now() - 520w')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from ctb where col_timestamp > now() - 520w')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from stb where col_timestamp > now() - 520w')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        tdSql.query('select col_int from tb where col_timestamp > now() - 3650d')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from ctb where col_timestamp > now() - 3650d')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from stb where col_timestamp > now() - 3650d')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)


        tdSql.query('select col_int from tb where col_timestamp > now() - 87600h')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from ctb where col_timestamp > now() - 87600h')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from stb where col_timestamp > now() - 87600h')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        tdSql.query('select col_int from tb where col_timestamp > now() - 5256000m')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from ctb where col_timestamp > now() - 5256000m')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from stb where col_timestamp > now() - 5256000m')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        tdSql.query('select col_int from tb where col_timestamp > now() - 315360000s')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from ctb where col_timestamp > now() - 315360000s')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from stb where col_timestamp > now() - 315360000s')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        tdSql.query('select col_int from tb where col_timestamp > now() - 315360000000a')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from ctb where col_timestamp > now() - 315360000000a')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from stb where col_timestamp > now() - 315360000000a')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        tdSql.query('select col_int from tb where col_timestamp > now() - 520w -1d -1m -1s -1a -1u -1b')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from ctb where col_timestamp > now() - 520w -1d -1m -1s -1a -1u -1b')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)
        tdSql.query('select col_int from stb where col_timestamp > now() - 520w -1d -1m -1s -1a -1u -1b')
        tdSql.checkRows(3)
        tdSql.checkCols(1)
        tdSql.checkData(0, 0, 1)
        tdSql.checkData(1, 0, 1)
        tdSql.checkData(2, 0, 1)

        print("============== STEP 3: insert now()  ================== ")
        tdSql.execute("insert into tb values (now(), now(), 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values (now(), now(), 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.query('select last(ts),last(col_timestamp) from tb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from ctb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from stb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime()
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.execute("insert into tb values (now() + 10s, now() + 10s, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values (now() + 10s, now() + 10s, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.query('select last(ts),last(col_timestamp) from tb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('+', datetime.timedelta(seconds = 10))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from ctb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('+', datetime.timedelta(seconds = 10))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from stb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('+', datetime.timedelta(seconds = 10))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.execute("insert into tb values (now() + 10m, now() + 10m, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values (now() + 10m, now() + 10m, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.query('select last(ts),last(col_timestamp) from tb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('+', datetime.timedelta(minutes = 10))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from ctb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('+', datetime.timedelta(minutes = 10))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from stb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('+', datetime.timedelta(minutes = 10))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.execute("insert into tb values (now() + 10h, now() + 10h, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values (now() + 10h, now() + 10h, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.query('select last(ts),last(col_timestamp) from tb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('+', datetime.timedelta(hours = 10))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from ctb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('+', datetime.timedelta(hours = 10))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from stb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('+', datetime.timedelta(hours = 10))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.execute("insert into tb values (now() + 5d, now() + 5d, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values (now() + 5d, now() + 5d, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.query('select last(ts),last(col_timestamp) from tb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('+', datetime.timedelta(days = 5))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from ctb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('+', datetime.timedelta(days = 5))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from stb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('+', datetime.timedelta(days = 5))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.execute("insert into tb values (now() + 1w, now() + 1w, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values (now() + 1w, now() + 1w, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.query('select last(ts),last(col_timestamp) from tb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('+', datetime.timedelta(weeks = 1))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from ctb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('+', datetime.timedelta(weeks = 1))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from stb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('+', datetime.timedelta(weeks = 1))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.execute("drop database if exists db_m")
        tdSql.execute("create database if not exists db_m")
        tdSql.execute('use db_m')

        tdSql.execute("create stable stb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10)) \
                       tags(tag_timestamp timestamp, tag_tinyint tinyint, tag_smallint smallint, tag_int int, tag_bigint bigint, tag_float float, tag_double double, tag_bool bool, tag_binary binary(10), tag_nchar nchar(10));")
        tdSql.execute("create table ctb using stb tags ('2022-02-02 02:00:00', 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("create table tb (ts timestamp, col_timestamp timestamp, col_tinyint tinyint, col_smallint smallint, col_int int, col_bigint bigint, col_float float, col_double double, col_bool bool, col_binary binary(10), col_nchar nchar(10));")

        tdSql.execute("insert into tb values (now() - 1w, now() - 1w, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values (now() - 1w, now() - 1w, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.query('select last(ts),last(col_timestamp) from tb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('-', datetime.timedelta(weeks = 1))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from ctb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('-', datetime.timedelta(weeks = 1))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from stb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('-', datetime.timedelta(weeks = 1))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.execute("insert into tb values (now() - 5d, now() - 5d, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values (now() - 5d, now() - 5d, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.query('select last(ts),last(col_timestamp) from tb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('-', datetime.timedelta(days = 5))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from ctb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('-', datetime.timedelta(days = 5))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from stb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('-', datetime.timedelta(days = 5))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.execute("insert into tb values (now() - 10h, now() - 10h, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values (now() - 10h, now() - 10h, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.query('select last(ts),last(col_timestamp) from tb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('-', datetime.timedelta(hours = 10))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from ctb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('-', datetime.timedelta(hours = 10))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from stb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('-', datetime.timedelta(hours = 10))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.execute("insert into tb values (now() - 10m, now() - 10m, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values (now() - 10m, now() - 10m, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.query('select last(ts),last(col_timestamp) from tb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('-', datetime.timedelta(minutes = 10))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from ctb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('-', datetime.timedelta(minutes = 10))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from stb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('-', datetime.timedelta(minutes = 10))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        tdSql.execute("insert into tb values (now() - 10s, now() - 10s, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.execute("insert into ctb values (now() - 10s, now() - 10s, 1, 1, 1, 1, 1.0, 1.0, true, 'abc', 'abc');")
        tdSql.query('select last(ts),last(col_timestamp) from tb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('-', datetime.timedelta(seconds = 10))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from ctb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('-', datetime.timedelta(seconds = 10))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        tdSql.query('select last(ts),last(col_timestamp) from stb')
        tdSql.checkRows(1)
        tdSql.checkCols(2)
        now = self.getCurrentTime('-', datetime.timedelta(seconds = 10))
        res = tdSql.getData(0, 0)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)
        res = tdSql.getData(0, 1)
        self.checkTimestampEqual(self.trimDecimal(str(res)), now)

        ##ERROR CASES
        #param
        tdSql.error("select now(1) from tb")
        tdSql.error("select now(1) from ctb")
        tdSql.error("select now(1) from stb")
        tdSql.error("select now(1.0) from tb")
        tdSql.error("select now(1.0) from ctb")
        tdSql.error("select now(1.0) from stb")
        tdSql.error("select now(\"abc\") from tb")
        tdSql.error("select now(\"abc\") from ctb")
        tdSql.error("select now(\"abc\") from stb")
        tdSql.error("select now('abc') from tb")
        tdSql.error("select now('abc') from ctb")
        tdSql.error("select now('abc') from stb")
        tdSql.error("select now(now) from tb")
        tdSql.error("select now(now) from ctb")
        tdSql.error("select now(now) from stb")
        tdSql.error("select now(*) from tb")
        tdSql.error("select now(*) from ctb")
        tdSql.error("select now(*) from stb")
        tdSql.error("select now(_c0) from tb")
        tdSql.error("select now(_c0) from ctb")
        tdSql.error("select now(_c0) from stb")
        tdSql.error("select now(_C0) from tb")
        tdSql.error("select now(_C0) from ctb")
        tdSql.error("select now(_C0) from stb")
        tdSql.error("select now(tbname) from tb")
        tdSql.error("select now(tbname) from ctb")
        tdSql.error("select now(tbname) from stb")
        tdSql.error("select now(ts) from tb")
        tdSql.error("select now(ts) from ctb")
        tdSql.error("select now(ts) from stb")
        tdSql.error("select now(col_timestamp) from tb")
        tdSql.error("select now(col_timestamp) from ctb")
        tdSql.error("select now(col_timestamp) from stb")
        tdSql.error("select now(col_bigint) from tb")
        tdSql.error("select now(col_bigint) from ctb")
        tdSql.error("select now(col_bigint) from stb")
        tdSql.error("select now(col_double) from tb")
        tdSql.error("select now(col_double) from ctb")
        tdSql.error("select now(col_double) from stb")
        tdSql.error("select now(col_bool) from tb")
        tdSql.error("select now(col_bool) from ctb")
        tdSql.error("select now(col_bool) from stb")
        tdSql.error("select now(col_binary) from tb")
        tdSql.error("select now(col_binary) from ctb")
        tdSql.error("select now(col_binary) from stb")
        tdSql.error("select now(tag_timestamp) from tb")
        tdSql.error("select now(tag_timestamp) from ctb")
        tdSql.error("select now(tag_timestamp) from stb")
        tdSql.error("select now(tag_bigint) from tb")
        tdSql.error("select now(tag_bigint) from ctb")
        tdSql.error("select now(tag_bigint) from stb")
        tdSql.error("select now(tag_double) from tb")
        tdSql.error("select now(tag_double) from ctb")
        tdSql.error("select now(tag_double) from stb")
        tdSql.error("select now(tag_bool) from tb")
        tdSql.error("select now(tag_bool) from ctb")
        tdSql.error("select now(tag_bool) from stb")
        tdSql.error("select now(tag_binary) from tb")
        tdSql.error("select now(tag_binary) from ctb")
        tdSql.error("select now(tag_binary) from stb")
        tdSql.error("select now(1,'abc',col_bigint) from tb")
        tdSql.error("select now(1,'abc',col_bigint) from ctb")
        tdSql.error("select now(1,'abc',col_bigint) from stb")

        #distinct
        tdSql.error("select distinct now() from tb")
        tdSql.error("select distinct now() from ctb")
        tdSql.error("select distinct now() from stb")

        #arithmetic
        tdSql.error("select now() + count(*) from tb")
        tdSql.error("select now() + count(*) from ctb")
        tdSql.error("select now() + count(*) from stb")
        tdSql.error("select now() + avg(col_timestamp) from tb")
        tdSql.error("select now() + avg(col_timestamp) from ctb")
        tdSql.error("select now() + avg(col_timestamp) from stb")
        tdSql.error("select now() + sum(col_int) from tb")
        tdSql.error("select now() + sum(col_int) from ctb")
        tdSql.error("select now() + sum(col_int) from stb")

        tdSql.error("select now() + max(col_timestamp) from tb")
        tdSql.error("select now() + max(col_timestamp) from ctb")
        tdSql.error("select now() + max(col_timestamp) from stb")
        tdSql.error("select now() + first(col_timestamp) from tb")
        tdSql.error("select now() + first(col_timestamp) from ctb")
        tdSql.error("select now() + first(col_timestamp) from stb")
        tdSql.error("select now() + top(col_timestamp, 1) from tb")
        tdSql.error("select now() + top(col_timestamp, 1) from ctb")
        tdSql.error("select now() + top(col_timestamp, 1) from stb")

        #tdSql.error("select now() + ceil(col_timestamp) from tb")
        #tdSql.error("select now() + ceil(col_timestamp) from ctb")
        #tdSql.error("select now() + ceil(col_timestamp) from stb")
        tdSql.error("select now() + floor(col_int) from tb")
        tdSql.error("select now() + floor(col_int) from ctb")
        tdSql.error("select now() + floor(col_int) from stb")
        tdSql.error("select now() + round(1.5) from tb")
        tdSql.error("select now() + round(1.5) from ctb")
        tdSql.error("select now() + round(1.5) from stb")
        tdSql.error("select now() + diff(col_timestamp) from tb")
        tdSql.error("select now() + diff(col_timestamp) from ctb")
        tdSql.error("select now() + diff(col_timestamp) from stb")

        tdSql.error("select now() + 1 from tb")
        tdSql.error("select now() + 1 from ctb")
        tdSql.error("select now() + 1 from stb")
        tdSql.error("select now() + 1.5 from tb")
        tdSql.error("select now() + 1.5 from ctb")
        tdSql.error("select now() + 1.5 from stb")
        #tdSql.error("select now() + true from tb")
        #tdSql.error("select now() + true from ctb")
        #tdSql.error("select now() + true from stb")
        tdSql.error("select now() + 'abc' from tb")
        tdSql.error("select now() + 'abc' from ctb")
        tdSql.error("select now() + 'abc' from stb")
        tdSql.error("select now() + abc from tb")
        tdSql.error("select now() + abc from ctb")
        tdSql.error("select now() + abc from stb")

        #tdSql.error("select now() + ts from tb")
        #tdSql.error("select now() + ts from ctb")
        #tdSql.error("select now() + ts from stb")
        #tdSql.error("select now() + col_timestamp from tb")
        #tdSql.error("select now() + col_timestamp from ctb")
        #tdSql.error("select now() + col_timestamp from stb")
        tdSql.error("select now() + col_tinyint from tb")
        tdSql.error("select now() + col_tinyint from ctb")
        tdSql.error("select now() + col_tinyint from stb")
        tdSql.error("select now() + col_smallint from tb")
        tdSql.error("select now() + col_smallint from ctb")
        tdSql.error("select now() + col_smallint from stb")
        tdSql.error("select now() + col_int from tb")
        tdSql.error("select now() + col_int from ctb")
        tdSql.error("select now() + col_int from stb")
        tdSql.error("select now() + col_bigint from tb")
        tdSql.error("select now() + col_bigint from ctb")
        tdSql.error("select now() + col_bigint from stb")
        tdSql.error("select now() + col_bool from tb")
        tdSql.error("select now() + col_bool from ctb")
        tdSql.error("select now() + col_bool from stb")
        tdSql.error("select now() + col_float from tb")
        tdSql.error("select now() + col_float from ctb")
        tdSql.error("select now() + col_float from stb")
        tdSql.error("select now() + col_double from tb")
        tdSql.error("select now() + col_double from ctb")
        tdSql.error("select now() + col_double from stb")
        tdSql.error("select now() + col_binary from tb")
        tdSql.error("select now() + col_binary from ctb")
        tdSql.error("select now() + col_binary from stb")
        tdSql.error("select now() + col_nchar from tb")
        tdSql.error("select now() + col_nchar from ctb")
        tdSql.error("select now() + col_nchar from stb")

        tdSql.error("select now() + tag_timestamp from tb")
        tdSql.error("select now() + tag_timestamp from ctb")
        tdSql.error("select now() + tag_timestamp from stb")
        tdSql.error("select now() + tag_tinyint from tb")
        tdSql.error("select now() + tag_tinyint from ctb")
        tdSql.error("select now() + tag_tinyint from stb")
        tdSql.error("select now() + tag_smallint from tb")
        tdSql.error("select now() + tag_smallint from ctb")
        tdSql.error("select now() + tag_smallint from stb")
        tdSql.error("select now() + tag_int from tb")
        tdSql.error("select now() + tag_int from ctb")
        tdSql.error("select now() + tag_int from stb")
        tdSql.error("select now() + tag_bigint from tb")
        tdSql.error("select now() + tag_bigint from ctb")
        tdSql.error("select now() + tag_bigint from stb")
        tdSql.error("select now() + tag_bool from tb")
        tdSql.error("select now() + tag_bool from ctb")
        tdSql.error("select now() + tag_bool from stb")
        tdSql.error("select now() + tag_float from tb")
        tdSql.error("select now() + tag_float from ctb")
        tdSql.error("select now() + tag_float from stb")
        tdSql.error("select now() + tag_double from tb")
        tdSql.error("select now() + tag_double from ctb")
        tdSql.error("select now() + tag_double from stb")
        tdSql.error("select now() + tag_binary from tb")
        tdSql.error("select now() + tag_binary from ctb")
        tdSql.error("select now() + tag_binary from stb")
        tdSql.error("select now() + tag_nchar from tb")
        tdSql.error("select now() + tag_nchar from ctb")
        tdSql.error("select now() + tag_nchar from stb")

        tdSql.error("select now() + 0.5b from tb")
        tdSql.error("select now() + 0.5b from ctb")
        tdSql.error("select now() + 0.5b from stb")
        tdSql.error("select now() + 1.5u from tb")
        tdSql.error("select now() + 1.5u from ctb")
        tdSql.error("select now() + 1.5u from stb")
        tdSql.error("select now() + 2.5a from tb")
        tdSql.error("select now() + 2.5a from ctb")
        tdSql.error("select now() + 2.5a from stb")
        tdSql.error("select now() + 3.5s from tb")
        tdSql.error("select now() + 3.5s from ctb")
        tdSql.error("select now() + 3.5s from stb")
        tdSql.error("select now() + 4.5m from tb")
        tdSql.error("select now() + 4.5m from ctb")
        tdSql.error("select now() + 4.5m from stb")
        tdSql.error("select now() + 5.5h from tb")
        tdSql.error("select now() + 5.5h from ctb")
        tdSql.error("select now() + 5.5h from stb")
        tdSql.error("select now() + 6.5d from tb")
        tdSql.error("select now() + 6.5d from ctb")
        tdSql.error("select now() + 6.5d from stb")
        tdSql.error("select now() + 7.5w from tb")
        tdSql.error("select now() + 7.5w from ctb")
        tdSql.error("select now() + 7.5w from stb")

        tdSql.error("select now() - 0.5b from tb")
        tdSql.error("select now() - 0.5b from ctb")
        tdSql.error("select now() - 0.5b from stb")
        tdSql.error("select now() - 1.5u from tb")
        tdSql.error("select now() - 1.5u from ctb")
        tdSql.error("select now() - 1.5u from stb")
        tdSql.error("select now() - 2.5a from tb")
        tdSql.error("select now() - 2.5a from ctb")
        tdSql.error("select now() - 2.5a from stb")
        tdSql.error("select now() - 3.5s from tb")
        tdSql.error("select now() - 3.5s from ctb")
        tdSql.error("select now() - 3.5s from stb")
        tdSql.error("select now() - 4.5m from tb")
        tdSql.error("select now() - 4.5m from ctb")
        tdSql.error("select now() - 4.5m from stb")
        tdSql.error("select now() - 5.5h from tb")
        tdSql.error("select now() - 5.5h from ctb")
        tdSql.error("select now() - 5.5h from stb")
        tdSql.error("select now() - 6.5d from tb")
        tdSql.error("select now() - 6.5d from ctb")
        tdSql.error("select now() - 6.5d from stb")
        tdSql.error("select now() - 7.5w from tb")
        tdSql.error("select now() - 7.5w from ctb")
        tdSql.error("select now() - 7.5w from stb")

        tdSql.error("select now() * 1d from tb")
        tdSql.error("select now() * 1d from ctb")
        tdSql.error("select now() * 1d from stb")
        tdSql.error("select now() / 5m from tb")
        tdSql.error("select now() / 5m from ctb")
        tdSql.error("select now() / 5m from stb")
        tdSql.error("select now() % 10h from tb")
        tdSql.error("select now() % 10h from ctb")
        tdSql.error("select now() % 10h from stb")
        tdSql.error("select now() + 1a * 60b from tb")
        tdSql.error("select now() + 1a * 60b from ctb")
        tdSql.error("select now() + 1a * 60b from stb")
        tdSql.error("select now() + 1s * 60 from tb")
        tdSql.error("select now() + 1s * 60 from ctb")
        tdSql.error("select now() + 1s * 60 from stb")

        #now(), func()
        tdSql.error("select now(),count(*) from tb")
        tdSql.error("select now(),count(*) from ctb")
        tdSql.error("select now(),count(*) from stb")
        tdSql.error("select now(),avg(col_timestamp) from tb")
        tdSql.error("select now(),avg(col_timestamp) from ctb")
        tdSql.error("select now(),avg(col_timestamp) from stb")
        tdSql.error("select now(),sum(col_int) from tb")
        tdSql.error("select now(),sum(col_int) from ctb")
        tdSql.error("select now(),sum(col_int) from stb")

        tdSql.error("select now(),max(col_timestamp) from tb")
        tdSql.error("select now(),max(col_timestamp) from ctb")
        tdSql.error("select now(),max(col_timestamp) from stb")
        tdSql.error("select now(),first(col_timestamp) from tb")
        tdSql.error("select now(),first(col_timestamp) from ctb")
        tdSql.error("select now(),first(col_timestamp) from stb")
        tdSql.error("select now(),top(col_timestamp, 1) from tb")
        tdSql.error("select now(),top(col_timestamp, 1) from ctb")
        tdSql.error("select now(),top(col_timestamp, 1) from stb")

        #session
        tdSql.error("select now() from tb session(ts, 1d)")
        tdSql.error("select now() from ctb session(ts, 1h)")
        tdSql.error("select now() from stb session(ts, 1m)")

        #state_window
        tdSql.error('select now() from tb state_window(col_timestamp);')
        tdSql.error('select now() from tb state_window(col_tinyint);')
        tdSql.error('select now() from tb state_window(col_smallint);')
        tdSql.error('select now() from tb state_window(col_int);')
        tdSql.error('select now() from tb state_window(col_bigint);')
        tdSql.error('select now() from tb state_window(col_bool);')
        tdSql.error('select now() from tb state_window(col_float);')
        tdSql.error('select now() from tb state_window(col_double);')
        tdSql.error('select now() from tb state_window(col_binary);')
        tdSql.error('select now() from tb state_window(col_nchar);')

        #interval/sliding
        tdSql.error('select now() from tb interval(1y)')
        tdSql.error('select now() from tb interval(1n)')
        tdSql.error('select now() from tb interval(1w)')
        tdSql.error('select now() from tb interval(1d)')
        tdSql.error('select now() from tb interval(1h)')
        tdSql.error('select now() from tb interval(1s)')
        tdSql.error('select now() from tb interval(1y) sliding(1y)')
        tdSql.error('select now() from tb interval(1n) sliding(1n)')
        tdSql.error('select now() from tb interval(1w) sliding(1w)')
        tdSql.error('select now() from tb interval(1d) sliding(1d)')
        tdSql.error('select now() from tb interval(1h) sliding(1h)')
        tdSql.error('select now() from tb interval(1s) sliding(1s)')

        #group by
        tdSql.error('select now() from stb group by ts;')
        tdSql.error('select now() from stb group by col_tinyint;')
        tdSql.error('select now() from stb group by col_smallint;')
        tdSql.error('select now() from stb group by col_int;')
        tdSql.error('select now() from stb group by col_bigint;')
        tdSql.error('select now() from stb group by col_bool;')
        tdSql.error('select now() from stb group by col_float;')
        tdSql.error('select now() from stb group by col_double;')
        tdSql.error('select now() from stb group by col_binary;')
        tdSql.error('select now() from stb group by col_nchar;')

        tdSql.error('select now() from stb group by tag_tinyint;')
        tdSql.error('select now() from stb group by tag_smallint;')
        tdSql.error('select now() from stb group by tag_int;')
        tdSql.error('select now() from stb group by tag_bigint;')
        tdSql.error('select now() from stb group by tag_bool;')
        tdSql.error('select now() from stb group by tag_float;')
        tdSql.error('select now() from stb group by tag_double;')
        tdSql.error('select now() from stb group by tag_binary;')
        tdSql.error('select now() from stb group by tag_nchar;')

        tdSql.error('select now() from stb group by tbname;')

        tdSql.error('select now() from stb group by tag_tinyint,col_tinyint;')
        tdSql.error('select now() from stb group by tag_smallint,col_smallint;')
        tdSql.error('select now() from stb group by tag_int,col_int;')
        tdSql.error('select now() from stb group by tag_bigint,col_bigint;')
        tdSql.error('select now() from stb group by tag_bool,col_bool;')
        tdSql.error('select now() from stb group by tag_float,col_float;')
        tdSql.error('select now() from stb group by tag_double,col_double;')
        tdSql.error('select now() from stb group by tag_binary,col_binary;')
        tdSql.error('select now() from stb group by tag_nchar,col_nchar;')

        #order by
        tdSql.error('select now() from stb order by col_tinyint;')
        tdSql.error('select now() from stb order by col_tinyint desc;')
        tdSql.error('select now() from stb order by col_smallint;')
        tdSql.error('select now() from stb order by col_smallint desc;')
        tdSql.error('select now() from stb order by col_int;')
        tdSql.error('select now() from stb order by col_int desc;')
        tdSql.error('select now() from stb order by col_bigint;')
        tdSql.error('select now() from stb order by col_bigint desc;')
        tdSql.error('select now() from stb order by col_bool;')
        tdSql.error('select now() from stb order by col_bool desc;')
        tdSql.error('select now() from stb order by col_float;')
        tdSql.error('select now() from stb order by col_float desc;')
        tdSql.error('select now() from stb order by col_double;')
        tdSql.error('select now() from stb order by col_double desc;')
        tdSql.error('select now() from stb order by col_double;')
        tdSql.error('select now() from stb order by col_double desc;')

        tdSql.error('select now() from stb order by tag_timestamp;')
        tdSql.error('select now() from stb order by tag_timestamp desc;')
        tdSql.error('select now() from stb order by tag_tinyint;')
        tdSql.error('select now() from stb order by tag_tinyint desc;')
        tdSql.error('select now() from stb order by tag_smallint;')
        tdSql.error('select now() from stb order by tag_smallint desc;')
        tdSql.error('select now() from stb order by tag_int;')
        tdSql.error('select now() from stb order by tag_int desc;')
        tdSql.error('select now() from stb order by tag_bigint;')
        tdSql.error('select now() from stb order by tag_bigint desc;')
        tdSql.error('select now() from stb order by tag_bool;')
        tdSql.error('select now() from stb order by tag_bool desc;')
        tdSql.error('select now() from stb order by tag_float;')
        tdSql.error('select now() from stb order by tag_float desc;')
        tdSql.error('select now() from stb order by tag_double;')
        tdSql.error('select now() from stb order by tag_double desc;')
        tdSql.error('select now() from stb order by tag_double;')
        tdSql.error('select now() from stb order by tag_double desc;')

        tdSql.error('select now() from stb order by tbname;')
        tdSql.error('select now() from stb order by tbname desc;')

        tdSql.error('select now() from stb order by tag_timestamp,col_timestamp;')
        tdSql.error('select now() from stb order by tag_timestamp,col_timestamp desc;')
        tdSql.error('select now() from stb order by tag_tinyint,col_timestamp;')
        tdSql.error('select now() from stb order by tag_tinyint,col_timestamp desc;')
        tdSql.error('select now() from stb order by tag_smallint,col_timestamp;')
        tdSql.error('select now() from stb order by tag_smallint,col_timestamp desc;')
        tdSql.error('select now() from stb order by tag_int,col_timestamp;')
        tdSql.error('select now() from stb order by tag_int,col_timestamp desc;')
        tdSql.error('select now() from stb order by tag_bigint,col_timestamp;')
        tdSql.error('select now() from stb order by tag_bigint,col_timestamp desc;')
        tdSql.error('select now() from stb order by tag_bool,col_timestamp;')
        tdSql.error('select now() from stb order by tag_bool,col_timestamp desc;')
        tdSql.error('select now() from stb order by tag_float,col_timestamp;')
        tdSql.error('select now() from stb order by tag_float,col_timestamp desc;')
        tdSql.error('select now() from stb order by tag_double,col_timestamp;')
        tdSql.error('select now() from stb order by tag_double,col_timestamp desc;')
        tdSql.error('select now() from stb order by tag_double,col_timestamp;')
        tdSql.error('select now() from stb order by tag_double,col_timestamp desc;')

        tdSql.execute('drop database db_m')
        tdSql.execute('drop database db_u')
        tdSql.execute('drop database db_n')

    def stop(self):
        tdSql.close()
        tdLog.success("%s successfully executed" % __file__)


tdCases.addWindows(__file__, TDTestCase())
tdCases.addLinux(__file__, TDTestCase())
