/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 473
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOperatorType yy62;
  SToken yy63;
  EOrder yy158;
  SNodeList* yy222;
  SAlterOption yy233;
  int32_t yy332;
  int64_t yy393;
  EJoinType yy574;
  bool yy669;
  ENullOrder yy675;
  SDataType yy686;
  int8_t yy707;
  EFillMode yy822;
  SNode* yy828;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             753
#define YYNRULE              573
#define YYNTOKEN             329
#define YY_MAX_SHIFT         752
#define YY_MIN_SHIFTREDUCE   1119
#define YY_MAX_SHIFTREDUCE   1691
#define YY_ERROR_ACTION      1692
#define YY_ACCEPT_ACTION     1693
#define YY_NO_ACTION         1694
#define YY_MIN_REDUCE        1695
#define YY_MAX_REDUCE        2267
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2833)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  2065, 2243, 1976,  167, 2079, 2238,  491,  377,  492, 1731,
 /*    10 */  1803, 2061,   45,   43, 1619,  164, 1976, 1974,  629, 2065,
 /*    20 */   385, 2242, 1468,  617, 1859, 2239, 2241, 2079,  376, 1493,
 /*    30 */  2061, 1973,  629, 1549,  166, 1466, 1707, 2097, 1848,   44,
 /*    40 */    42,   41,   40,   39,  641,  620, 2057, 2063,  366, 2061,
 /*    50 */  2047,  500,  658,  492, 1731,  388,  139,  652, 1544,  176,
 /*    60 */  2097, 1493, 1910,  161,   18, 2057, 2063,  367,  659,  350,
 /*    70 */   364, 1474, 1859, 2047,  178,  658,  652,  497, 1908, 1908,
 /*    80 */   352, 1959, 2078,  493, 2057, 2063, 2114, 1897,  641,  109,
 /*    90 */  2080,  662, 2082, 2083,  657,  652,  652,  749,   35,  291,
 /*   100 */    14,  179,  617, 2167,  627, 2078,  430,  379, 2163, 2114,
 /*   110 */    45,   43,  168, 2080,  662, 2082, 2083,  657,  385,  652,
 /*   120 */  1468,  184,  270, 2175,  616, 1764,  133,  615, 2066, 2193,
 /*   130 */  2238, 1549, 1171, 1466, 1170,  139, 1551, 1552,  490, 2061,
 /*   140 */   605,  495, 1737, 1623, 2238,  604,  182,  222,  333, 1493,
 /*   150 */  2239,  606, 1695,  581, 2204, 1152, 1544, 1834,  141,  604,
 /*   160 */   182, 2138,   18, 1172, 2239,  606, 1524, 1534,   48, 1474,
 /*   170 */  1761,  509, 1550, 1553, 2057, 2063,  131,  130,  129,  128,
 /*   180 */   127,  126,  125,  124,  123,  652, 1469,  641, 1467,  176,
 /*   190 */    61,  545,  544,  543, 1154,  749, 1157, 1158,   14,  136,
 /*   200 */   539,  181, 2175, 2176,  538,  137, 2180, 1385, 1386,  537,
 /*   210 */   542, 1960,  468, 1472, 1473,  536, 1523, 1526, 1527, 1528,
 /*   220 */  1529, 1530, 1531, 1532, 1533,  654,  650, 1542, 1543, 1545,
 /*   230 */  1546, 1547, 1548,    2, 1551, 1552,  726,  725,  724,  723,
 /*   240 */   395,  600,  722,  721,  143,  716,  715,  714,  713,  712,
 /*   250 */   711,  710,  156,  706,  705,  704,  394,  393,  701,  700,
 /*   260 */   699,  698,  697, 1616, 1524, 1534,  595,   48,  696,  694,
 /*   270 */  1550, 1553,  122,  198,  197,  121,  120,  119,  118,  117,
 /*   280 */   116,  115,  114,  113, 1469,  694, 1467,  154,  153,  691,
 /*   290 */   690,  689,  151,   38,   37, 1525,  467,   44,   42,   41,
 /*   300 */    40,   39, 1492,  154,  153,  691,  690,  689,  151, 1693,
 /*   310 */  2182, 1472, 1473,  273, 1523, 1526, 1527, 1528, 1529, 1530,
 /*   320 */  1531, 1532, 1533,  654,  650, 1542, 1543, 1545, 1546, 1547,
 /*   330 */  1548,    2,   11,   45,   43,  390, 2179, 2097, 1903, 1905,
 /*   340 */   185,  385, 1296, 1468,  499,  599,   49,  495, 1737,  345,
 /*   350 */   601,  596,  589, 1940, 1549,   61, 1466,   92, 1287,  684,
 /*   360 */   683,  682, 1291,  681, 1293, 1294,  680,  677,   86, 1302,
 /*   370 */   674, 1304, 1305,  671,  668, 1696,   31,  398, 2079, 1544,
 /*   380 */   568,  397,   38,   37,   65,   18,   44,   42,   41,   40,
 /*   390 */    39,  598, 1474, 1853, 1578,  628,  122, 1494,   11,  121,
 /*   400 */   120,  119,  118,  117,  116,  115,  114,  113,   38,   37,
 /*   410 */   628, 2097,   44,   42,   41,   40,   39,  185,  749,  656,
 /*   420 */  1496,   14,  642,  580, 2047, 1474,  658, 2238,   11, 1910,
 /*   430 */     9,   45,   43, 1554,  628,  687,  363, 2015,  187,  385,
 /*   440 */  1250, 1468, 2244,  182,  507, 1908, 1969, 2239,  606, 1718,
 /*   450 */  1579, 1647, 1549, 1249, 1466, 1857, 2078, 1551, 1552,  626,
 /*   460 */  2114, 1969, 2243,  327, 2080,  662, 2082, 2083,  657,  655,
 /*   470 */   652,  643, 2132,  545,  544,  543, 1239, 1544,  617, 1495,
 /*   480 */    61,  136,  539,  637,  240, 1969,  538, 1524, 1534, 2242,
 /*   490 */  1474,  537,  542, 1550, 1553, 2047,  185,  536,  592,  591,
 /*   500 */  1645, 1646, 1648, 1649, 1650,  185,  708, 1469,  448, 1467,
 /*   510 */  1615,  139, 1241, 1330, 1331,  477,  749,  447,  152,   46,
 /*   520 */   541,  540,   34,  383, 1573, 1574, 1575, 1576, 1577, 1581,
 /*   530 */  1582, 1583, 1584, 1495, 1472, 1473,  575, 1523, 1526, 1527,
 /*   540 */  1528, 1529, 1530, 1531, 1532, 1533,  654,  650, 1542, 1543,
 /*   550 */  1545, 1546, 1547, 1548,    2, 1551, 1552,   38,   37, 1846,
 /*   560 */  1681,   44,   42,   41,   40,   39,   38,   37,  250, 1717,
 /*   570 */    44,   42,   41,   40,   39,   53,  619,  180, 2175, 2176,
 /*   580 */  2079,  137, 2180,  642,  605, 1524, 1534, 1708, 2238,   38,
 /*   590 */    37, 1550, 1553,   44,   42,   41,   40,   39, 2243,  132,
 /*   600 */  1842,  642, 2238,  604,  182, 1469,  530, 1467, 2239,  606,
 /*   610 */  1716, 1493,  644, 2097, 2139, 2047, 1857,  132, 2242,  239,
 /*   620 */  2068,  659, 2239, 2240,  535,   27, 2047,  272,  658,  646,
 /*   630 */   185, 2139, 1472, 1473, 1857, 1523, 1526, 1527, 1528, 1529,
 /*   640 */  1530, 1531, 1532, 1533,  654,  650, 1542, 1543, 1545, 1546,
 /*   650 */  1547, 1548,    2,   45,   43,   86, 2047, 2079, 2078, 1658,
 /*   660 */   424,  385, 2114, 1468,  423,  109, 2080,  662, 2082, 2083,
 /*   670 */   657,  354,  652, 2070, 1549,  142, 1466,  149, 2138, 2167,
 /*   680 */  1852,  272, 1580,  379, 2163, 1442, 1443, 1468,   38,   37,
 /*   690 */  2097,   61,   44,   42,   41,   40,   39, 1910,  659, 1544,
 /*   700 */  1466,  617, 2182, 2047,  373,  658,  580,  642,   33,  709,
 /*   710 */  2238, 1819, 1474, 1908,   38,   37, 1904, 1905,   44,   42,
 /*   720 */    41,   40,   39,   54, 1844, 2244,  182, 1688, 2178,  238,
 /*   730 */  2239,  606,  642,  237,  139, 2078, 1474,  642,  749, 2114,
 /*   740 */  1857,   46,  169, 2080,  662, 2082, 2083,  657,  621,  652,
 /*   750 */   357,   45,   43,  428,   32, 1171,  608, 1170,  388,  385,
 /*   760 */  1910, 1468,  749,  391, 1585, 1857,  164,  378,  282,  283,
 /*   770 */  1857,  164, 1549,  281, 1466, 1859, 1908, 1551, 1552, 1835,
 /*   780 */  1859, 1635, 1715,   38,   37, 1832, 1172,   44,   42,   41,
 /*   790 */    40,   39,   89,  340,  607, 2259,  362, 1544,  561, 2079,
 /*   800 */   183, 2175, 2176, 1714,  137, 2180,  106, 1524, 1534, 2182,
 /*   810 */  1474,  720,  718, 1550, 1553,  642,  358,  534,  356,  355,
 /*   820 */   417,  532,  140,  147, 1687,  534, 1910, 1469, 2047, 1467,
 /*   830 */  1849,  429, 2097,  389,    8, 2177,  749,  559,  533,   14,
 /*   840 */   659,  185, 1908,  419,  415, 2047,  533,  658, 1857, 2047,
 /*   850 */   557, 1469,  555, 1467, 1472, 1473, 1713, 1523, 1526, 1527,
 /*   860 */  1528, 1529, 1530, 1531, 1532, 1533,  654,  650, 1542, 1543,
 /*   870 */  1545, 1546, 1547, 1548,    2, 1551, 1552, 2078, 1472, 1473,
 /*   880 */   623, 2114,   13,   12,  110, 2080,  662, 2082, 2083,  657,
 /*   890 */   100,  652, 1496, 1559,   41,   40,   39,  694, 2167, 1493,
 /*   900 */   105, 1712, 2047, 2164,  164, 1524, 1534,  642,  642, 1494,
 /*   910 */   102, 1550, 1553, 1860, 1850,  154,  153,  691,  690,  689,
 /*   920 */   151, 1910, 1496,  438,  453, 1469,  580, 1467,   38,   37,
 /*   930 */  2238, 1804,   44,   42,   41,   40,   39, 1909, 1955,  688,
 /*   940 */  1857, 1857, 1901,  163, 1711, 2244,  182, 2047, 1833,  190,
 /*   950 */  2239,  606, 1472, 1473,   73, 1523, 1526, 1527, 1528, 1529,
 /*   960 */  1530, 1531, 1532, 1533,  654,  650, 1542, 1543, 1545, 1546,
 /*   970 */  1547, 1548,    2,   61,  336,  165, 1491, 2040,  382,  381,
 /*   980 */   311, 1955, 1592,  461, 1254,  550,  475, 2079, 1482,  474,
 /*   990 */  2047, 1955,  192,  305,  309,   72, 1887, 1253,   71, 1549,
 /*  1000 */   560, 1475,  196,   81,  444,  194,  476, 1710,  431,  446,
 /*  1010 */  1709,  696,  692,  609,  236, 1901,  205,  487,  485,  482,
 /*  1020 */  2097,  432, 1706,  580, 1544, 1402, 1403, 2238,  659,  553,
 /*  1030 */  1157, 1158, 1705, 2047,  547,  658, 1840, 1474,  642,  235,
 /*  1040 */   191, 1704, 2244,  182, 1612, 1525,   83, 2239,  606,   82,
 /*  1050 */   248, 1703, 1702, 2047,  625,  353, 2047,   61,  422,  479,
 /*  1060 */   421, 1401, 1404,  648, 1493, 2078,  612,  434, 2047, 2114,
 /*  1070 */   249, 1857,  109, 2080,  662, 2082, 2083,  657, 2047,  652,
 /*  1080 */    69, 1701, 2065,   68, 2142,  420, 2167, 2047, 1700,  693,
 /*  1090 */   379, 2163, 1901, 2061,   90,  108,  472, 2047, 2047,  466,
 /*  1100 */   465,  464,  463,  460,  459,  458,  457,  456,  452,  451,
 /*  1110 */   450,  449,  335,  441,  440,  439,  642,  436,  435,  351,
 /*  1120 */   686,  228,  642,  185,  226, 1699,  642, 2047, 2057, 2063,
 /*  1130 */   380,  642,  392, 2033, 2047,   80,   79,  427,  454,  652,
 /*  1140 */   189, 2079,  508, 2187, 1612,  642,   51, 1854,    3, 1857,
 /*  1150 */  1477,  145, 1483,  134, 1478, 1857,  649,  642,  245, 1857,
 /*  1160 */   334,  241, 1751,  413, 1857,  411,  407,  403,  400,  420,
 /*  1170 */   642, 2047, 2079,  576, 2097,  563,  653,  562, 1857, 1486,
 /*  1180 */  1488,  405,  620,  267,  546,  152,  286, 2047,  642,  658,
 /*  1190 */  1857, 1476,  650, 1542, 1543, 1545, 1546, 1547, 1548,  642,
 /*  1200 */  1698,  642, 1744, 1857,  639, 2097,  230,  185,  152,  229,
 /*  1210 */  1525,  232, 2207,  659,  231,  640,   63,  292, 2047, 2078,
 /*  1220 */   658, 1857, 2079, 2114,  548, 1742,  109, 2080,  662, 2082,
 /*  1230 */  2083,  657, 1857,  652, 1857,   63,   47,  254,  179, 2079,
 /*  1240 */  2167,  610, 1437,  579,  379, 2163, 2047,  551,  234,  152,
 /*  1250 */  2078,  233,   13,   12, 2114, 2097,   47,  109, 2080,  662,
 /*  1260 */  2082, 2083,  657,  659,  652, 1440, 2194, 1738, 2047, 2258,
 /*  1270 */   658, 2167, 2097, 1644,  593,  379, 2163,  279, 1690, 1691,
 /*  1280 */   659,  221,   70,  261,  150, 2047, 2201,  658, 2098,  152,
 /*  1290 */  1732,   63, 1643, 1535,  256,  396,  613,   47,  666, 2079,
 /*  1300 */  2078,  150,  152, 1480, 2114, 1570,  624,  168, 2080,  662,
 /*  1310 */  2082, 2083,  657, 1399,  652,   52,  744, 2078, 1964, 2079,
 /*  1320 */  1898, 2114,  135,  150,  109, 2080,  662, 2082, 2083,  657,
 /*  1330 */  2197,  652, 2097, 1201,  284,  702, 2258,  752, 2167,  634,
 /*  1340 */   659,  288,  379, 2163, 1479, 2047, 1280,  658, 1586, 2205,
 /*  1350 */   618,  298, 2097, 2214,  304, 1308,  703, 1220, 1312, 1319,
 /*  1360 */   659,  269,  266,    1,    4, 2047,  175,  658,  404, 1202,
 /*  1370 */   399,  349,  742,  738,  734,  730,  296, 2078, 1218, 1317,
 /*  1380 */   155, 2114, 1422,  299,  109, 2080,  662, 2082, 2083,  657,
 /*  1390 */   195,  652,  433, 1496, 1965,  437, 2258, 2078, 2167,  470,
 /*  1400 */  1491, 2114,  379, 2163,  109, 2080,  662, 2082, 2083,  657,
 /*  1410 */   442,  652,  455,  587, 1957,  462, 2258,  107, 2167,  469,
 /*  1420 */   289,  471,  379, 2163,  480,  481,  478,  199, 2079,  200,
 /*  1430 */   483,  484, 2041, 2232,  202,  223, 1497,  486,  488,  489,
 /*  1440 */   498, 1499,  501, 1494,  502,  208,  210, 1498, 2079,  503,
 /*  1450 */   171, 1500,  638,  504,  506, 1174,  526,  522,  518,  514,
 /*  1460 */   220, 2097,  510,  213,  215,   84,   85,  219,  527,  659,
 /*  1470 */   528,  529,  112,  339, 2047,  531,  658,  565,  580, 1847,
 /*  1480 */   567, 2097, 2238,   88,  148,  300,  570,  276,  225,  659,
 /*  1490 */   242, 1843,  275,  227, 2047,  157,  658, 2244,  182,  158,
 /*  1500 */  1845,   87, 2239,  606,  218, 1841, 2078, 2024, 1429, 2021,
 /*  1510 */  2114,  243,  569,  109, 2080,  662, 2082, 2083,  657,  159,
 /*  1520 */   652, 2020, 2079,  160,  246, 2258, 2078, 2167,  571,  574,
 /*  1530 */  2114,  379, 2163,  109, 2080,  662, 2082, 2083,  657,  244,
 /*  1540 */   652,  577, 2186, 2198,  584, 2140, 2079, 2167, 2208,  594,
 /*  1550 */   632,  379, 2163,  590, 2213, 2097,  252,  368,  255,  597,
 /*  1560 */     7,  603,  582,  659, 2212,  585,  611,  583, 2047,  265,
 /*  1570 */   658,  217,  211,  369,  614, 2261,  216, 1612,  505, 2097,
 /*  1580 */   138, 1495,  622, 2183,  372,  274, 1501,  659,   95,  301,
 /*  1590 */  1970,  630, 2047,  260,  658,  209, 2079,  631, 1984,  263,
 /*  1600 */  2078, 2189,  264,  172, 2114,  566, 1983,  109, 2080,  662,
 /*  1610 */  2082, 2083,  657, 2079,  652, 1982,  302, 2237,  268,  645,
 /*  1620 */   262, 2167,  635,  303, 2078,  379, 2163,  375, 2114, 2097,
 /*  1630 */    97,  110, 2080,  662, 2082, 2083,  657,  659,  652, 1858,
 /*  1640 */   636,   60, 2047, 2148,  658, 2167, 2097,   99,  101, 2166,
 /*  1650 */  2163,  580,  664,  306,  659, 2238,  295, 1820, 1902, 2047,
 /*  1660 */   745,  658,  746,  748,  341,   50,  330,  342,  308,  315,
 /*  1670 */  2244,  182,  310, 2079, 2078, 2239,  606, 2039, 2114, 2038,
 /*  1680 */  2037,  321, 2080,  662, 2082, 2083,  657,   77,  652,  329,
 /*  1690 */  2034, 2078,  319, 2079,  401, 2114,  402, 1459,  110, 2080,
 /*  1700 */   662, 2082, 2083,  657, 1460,  652, 2097,  188,  406, 2032,
 /*  1710 */   408,  409, 2167,  410,  659, 2031,  647, 2163,  412, 2047,
 /*  1720 */  2030,  658,  414, 2029,  416,  602, 2097, 2028,  418,   78,
 /*  1730 */  1425, 1424, 1996, 1995,  659, 1994,  425,  426, 1993, 2047,
 /*  1740 */  1992,  658, 1376, 1948, 1947, 1945,  144, 1944, 1943, 1946,
 /*  1750 */  1942,  660, 1941, 1939, 1938, 2114, 2079, 1937,  110, 2080,
 /*  1760 */   662, 2082, 2083,  657,  193,  652,  443, 1936,  445, 1950,
 /*  1770 */  1935, 2078, 2167, 1934, 1933, 2114,  344, 2163,  169, 2080,
 /*  1780 */   662, 2082, 2083,  657,  146,  652, 1932, 1931, 1930, 2097,
 /*  1790 */  1929, 1928, 1927, 1926,  374, 1925, 1924,  659, 1923, 1922,
 /*  1800 */  1921, 1920, 2047, 1919,  658, 1918, 1949, 1917, 1916, 1915,
 /*  1810 */  1914, 1378, 1913,  473, 2079, 1912, 1911,  337,  338, 1251,
 /*  1820 */  1767,  201, 1766,  203, 1255, 1765,  204, 1763, 1727, 1247,
 /*  1830 */  2067, 2260, 1160, 1159, 2078, 1726, 2011, 2003, 2114, 2079,
 /*  1840 */  1991,  328, 2080,  662, 2082, 2083,  657, 2097,  652, 1990,
 /*  1850 */   214,  494,   75,  206, 1968,  656, 1836, 1762,  177, 1760,
 /*  1860 */  2047,  207,  658,   76,  496,  212,  511, 1758,  513,  515,
 /*  1870 */  1756,  517, 2097,  519, 1754, 1741, 1740,  384,  512,  523,
 /*  1880 */   659,  516,  521, 1723, 1838, 2047,  525,  658, 1194,  520,
 /*  1890 */    62, 1323, 2078,  524, 1837, 1324, 2114, 1238, 1237,  327,
 /*  1900 */  2080,  662, 2082, 2083,  657, 1752,  652, 1236, 2133,  717,
 /*  1910 */   719, 1230, 2079, 1235, 1232, 1231, 1229, 2078,  359, 1745,
 /*  1920 */   360, 2114,  361,  549,  328, 2080,  662, 2082, 2083,  657,
 /*  1930 */  1743,  652,  552, 2079, 1722, 1721,  554,  556, 1720,  558,
 /*  1940 */   111, 1447, 1449, 1446, 2010, 2097,  224, 1451,   26, 1431,
 /*  1950 */   386,   66, 2002,  659, 1433,  162, 1989, 1987, 2047,  572,
 /*  1960 */   658, 2243, 2079,  259,   16,   19, 2097,   58,   59,  258,
 /*  1970 */    20,   30,   64, 2068,  659,   21, 1675,   28,   17, 2047,
 /*  1980 */  1674,  658,  251, 2079,    5,  586, 1660,    6,  588,  370,
 /*  1990 */  2078,  253,   57, 1642, 2114, 2097, 1634,  328, 2080,  662,
 /*  2000 */  2082, 2083,  657,  659,  652, 1680, 1679, 1678, 2047,  170,
 /*  2010 */   658,  564,  257,   29,  371, 2114, 2097,  271,  323, 2080,
 /*  2020 */   662, 2082, 2083,  657,  659,  652,   55,  578,   91, 2047,
 /*  2030 */  1681,  658,  573, 2079, 1609,  173, 1988, 1608,  247,  365,
 /*  2040 */  2078, 1986, 1985, 1967, 2114,   94,   93,  312, 2080,  662,
 /*  2050 */  2082, 2083,  657,   22,  652,  277,  278,  633, 2079,   96,
 /*  2060 */  1640, 2078,  280,  285,   67, 2114, 2097, 1966,  313, 2080,
 /*  2070 */   662, 2082, 2083,  657,  659,  652,   98,  102,  290, 2047,
 /*  2080 */   287,  658,   23, 1561, 1560,   12, 1484, 2117,   10,  663,
 /*  2090 */  1539, 2097,  651, 2079, 1537,   36,  174,   15,   56,  659,
 /*  2100 */  1536,   24,  186, 1508, 2047,   25,  658, 1516, 1309,  665,
 /*  2110 */   667, 2078, 1571,  387, 1306, 2114, 2079,  669,  314, 2080,
 /*  2120 */   662, 2082, 2083,  657,  670,  652, 2097, 1303,  672,  673,
 /*  2130 */   661, 1297,  675,  676,  659, 1295, 2078,  678, 1301, 2047,
 /*  2140 */  2114,  658, 1300,  320, 2080,  662, 2082, 2083,  657, 2097,
 /*  2150 */   652,  679, 1286,  103,  293, 1299,  685,  659, 1298, 1318,
 /*  2160 */   104,   74, 2047, 1314,  658, 1192, 1226,  695, 1225, 1224,
 /*  2170 */  1223, 2078, 1222, 1221, 2079, 2114, 1245, 1219,  324, 2080,
 /*  2180 */   662, 2082, 2083,  657, 1217,  652, 1216, 1215,  707,  294,
 /*  2190 */  1213, 1212, 1211, 2079, 2078, 1210, 1209, 1208, 2114, 1207,
 /*  2200 */  1242,  316, 2080,  662, 2082, 2083,  657, 2097,  652, 1240,
 /*  2210 */  1198, 1204, 1203, 1200, 1199,  659, 1197, 1759,  727,  728,
 /*  2220 */  2047,  729,  658, 1757,  731,  733, 2097, 1755,  732,  735,
 /*  2230 */   737, 1753,  736,  739,  659,  740,  741, 1739,  743, 2047,
 /*  2240 */  1149,  658, 1719,  297, 1470,  747,  751,  307, 1694,  750,
 /*  2250 */  1694, 1694, 2078, 1694, 2079, 1694, 2114, 1694, 1694,  325,
 /*  2260 */  2080,  662, 2082, 2083,  657, 1694,  652, 1694, 1694, 1694,
 /*  2270 */  1694, 2078, 1694, 1694, 1694, 2114, 1694, 1694,  317, 2080,
 /*  2280 */   662, 2082, 2083,  657, 1694,  652, 1694, 2097, 1694, 1694,
 /*  2290 */  1694, 1694, 1694, 1694, 1694,  659, 1694, 1694, 1694, 1694,
 /*  2300 */  2047, 1694,  658, 1694, 1694, 1694, 1694, 1694, 1694, 1694,
 /*  2310 */  1694, 1694, 2079, 1694, 1694, 1694, 1694, 1694, 1694, 1694,
 /*  2320 */  1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694, 2079, 1694,
 /*  2330 */  1694, 1694, 2078, 1694, 1694, 1694, 2114, 1694, 1694,  326,
 /*  2340 */  2080,  662, 2082, 2083,  657, 2097,  652, 1694, 1694, 1694,
 /*  2350 */  1694, 1694, 1694,  659, 1694, 1694, 1694, 1694, 2047, 1694,
 /*  2360 */   658, 2097, 1694, 1694, 1694, 1694, 1694, 1694, 1694,  659,
 /*  2370 */  1694, 1694, 1694, 1694, 2047, 1694,  658, 1694, 1694, 1694,
 /*  2380 */  1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694,
 /*  2390 */  2078, 2079, 1694, 1694, 2114, 1694, 1694,  318, 2080,  662,
 /*  2400 */  2082, 2083,  657, 1694,  652, 1694, 2078, 2079, 1694, 1694,
 /*  2410 */  2114, 1694, 1694,  331, 2080,  662, 2082, 2083,  657, 1694,
 /*  2420 */   652, 1694, 1694, 1694, 2097, 1694, 2079, 1694, 1694, 1694,
 /*  2430 */  1694, 1694,  659, 1694, 1694, 1694, 1694, 2047, 1694,  658,
 /*  2440 */  2097, 1694, 1694, 1694, 1694, 1694, 1694, 1694,  659, 1694,
 /*  2450 */  1694, 1694, 1694, 2047, 1694,  658, 1694, 1694, 1694, 2097,
 /*  2460 */  1694, 1694, 1694, 1694, 1694, 1694, 1694,  659, 1694, 2078,
 /*  2470 */  1694, 1694, 2047, 2114,  658, 1694,  332, 2080,  662, 2082,
 /*  2480 */  2083,  657, 1694,  652, 1694, 2078, 1694, 1694, 1694, 2114,
 /*  2490 */  2079, 1694, 2091, 2080,  662, 2082, 2083,  657, 1694,  652,
 /*  2500 */  1694, 1694, 1694, 1694, 2078, 1694, 1694, 2079, 2114, 1694,
 /*  2510 */  1694, 2090, 2080,  662, 2082, 2083,  657, 1694,  652, 1694,
 /*  2520 */  1694, 1694, 1694, 2097, 1694, 1694, 1694, 1694, 1694, 1694,
 /*  2530 */  1694,  659, 1694, 1694, 1694, 1694, 2047, 1694,  658, 1694,
 /*  2540 */  2097, 1694, 1694, 1694, 1694, 1694, 1694, 1694,  659, 1694,
 /*  2550 */  1694, 1694, 1694, 2047, 1694,  658, 1694, 1694, 1694, 1694,
 /*  2560 */  1694, 1694, 1694, 1694, 1694, 1694, 1694, 2079, 2078, 1694,
 /*  2570 */  1694, 1694, 2114, 1694, 1694, 2089, 2080,  662, 2082, 2083,
 /*  2580 */   657, 1694,  652, 1694, 1694, 2078, 1694, 2079, 1694, 2114,
 /*  2590 */  1694, 1694,  346, 2080,  662, 2082, 2083,  657, 1694,  652,
 /*  2600 */  2097, 1694, 1694, 1694, 1694, 1694, 1694, 1694,  659, 1694,
 /*  2610 */  1694, 1694, 1694, 2047, 1694,  658, 1694, 1694, 1694, 1694,
 /*  2620 */  2097, 1694, 1694, 1694, 1694, 1694, 1694, 1694,  659, 1694,
 /*  2630 */  1694, 1694, 1694, 2047, 1694,  658, 1694, 1694, 1694, 1694,
 /*  2640 */  1694, 1694, 1694, 1694, 1694, 2078, 1694, 1694, 1694, 2114,
 /*  2650 */  1694, 1694,  347, 2080,  662, 2082, 2083,  657, 1694,  652,
 /*  2660 */  1694, 2079, 1694, 1694, 1694, 2078, 1694, 1694, 1694, 2114,
 /*  2670 */  1694, 1694,  343, 2080,  662, 2082, 2083,  657, 2079,  652,
 /*  2680 */  1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694,
 /*  2690 */  1694, 1694, 1694, 1694, 2097, 1694, 1694, 1694, 1694, 1694,
 /*  2700 */  1694, 1694,  659, 1694, 1694, 1694, 1694, 2047, 1694,  658,
 /*  2710 */  1694, 2097, 1694, 1694, 1694, 1694, 1694, 1694, 1694,  659,
 /*  2720 */  1694, 1694, 1694, 1694, 2047, 1694,  658, 1694, 1694, 1694,
 /*  2730 */  1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694, 2078,
 /*  2740 */  2079, 1694, 1694, 2114, 1694, 1694,  348, 2080,  662, 2082,
 /*  2750 */  2083,  657, 1694,  652, 1694, 1694,  660, 1694, 1694, 1694,
 /*  2760 */  2114, 1694, 1694,  323, 2080,  662, 2082, 2083,  657, 1694,
 /*  2770 */   652, 1694, 1694, 2097, 1694, 1694, 1694, 1694, 1694, 1694,
 /*  2780 */  1694,  659, 1694, 1694, 1694, 1694, 2047, 1694,  658, 1694,
 /*  2790 */  1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694,
 /*  2800 */  1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694,
 /*  2810 */  1694, 1694, 1694, 1694, 1694, 1694, 1694, 1694, 2078, 1694,
 /*  2820 */  1694, 1694, 2114, 1694, 1694,  322, 2080,  662, 2082, 2083,
 /*  2830 */   657, 1694,  652,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   367,  443,  380,  347,  332,  447,  336,  357,  338,  339,
 /*    10 */   354,  378,   12,   13,   14,  365,  380,  395,  396,  367,
 /*    20 */    20,  463,   22,  340,  374,  467,  468,  332,  392,   20,
 /*    30 */   378,  395,  396,   33,  331,   35,  333,  365,  367,   12,
 /*    40 */    13,   14,   15,   16,   20,  373,  413,  414,  415,  378,
 /*    50 */   378,  336,  380,  338,  339,  357,  373,  424,   58,  365,
 /*    60 */   365,   20,  365,  365,   64,  413,  414,  415,  373,  372,
 /*    70 */   372,   71,  374,  378,  364,  380,  424,   14,  381,  381,
 /*    80 */   386,  387,  410,   20,  413,  414,  414,  377,   20,  417,
 /*    90 */   418,  419,  420,  421,  422,  424,  424,   97,  432,  433,
 /*   100 */   100,  429,  340,  431,   20,  410,  340,  435,  436,  414,
 /*   110 */    12,   13,  417,  418,  419,  420,  421,  422,   20,  424,
 /*   120 */    22,  449,  439,  440,  441,    0,  443,  444,  367,  457,
 /*   130 */   447,   33,   20,   35,   22,  373,  136,  137,  337,  378,
 /*   140 */   443,  340,  341,   14,  447,  462,  463,   35,  382,   20,
 /*   150 */   467,  468,    0,  458,  459,    4,   58,    0,  427,  462,
 /*   160 */   463,  430,   64,   51,  467,  468,  166,  167,  100,   71,
 /*   170 */     0,   63,  172,  173,  413,  414,   24,   25,   26,   27,
 /*   180 */    28,   29,   30,   31,   32,  424,  186,   20,  188,  365,
 /*   190 */   100,   66,   67,   68,   43,   97,   45,   46,  100,   74,
 /*   200 */    75,  439,  440,  441,   79,  443,  444,  166,  167,   84,
 /*   210 */    85,  387,   80,  213,  214,   90,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */   230,  231,  232,  233,  136,  137,   66,   67,   68,   69,
 /*   240 */    70,   20,   72,   73,   74,   75,   76,   77,   78,   79,
 /*   250 */    80,   81,   82,   83,   84,   85,   86,   87,   88,   89,
 /*   260 */    90,   91,   92,    4,  166,  167,  171,  100,   63,  112,
 /*   270 */   172,  173,   21,  141,  142,   24,   25,   26,   27,   28,
 /*   280 */    29,   30,   31,   32,  186,  112,  188,  130,  131,  132,
 /*   290 */   133,  134,  135,    8,    9,  166,  164,   12,   13,   14,
 /*   300 */    15,   16,   20,  130,  131,  132,  133,  134,  135,  329,
 /*   310 */   416,  213,  214,   58,  216,  217,  218,  219,  220,  221,
 /*   320 */   222,  223,  224,  225,  226,  227,  228,  229,  230,  231,
 /*   330 */   232,  233,  234,   12,   13,  376,  442,  365,  379,  380,
 /*   340 */   250,   20,   97,   22,  337,  373,  100,  340,  341,   64,
 /*   350 */   255,  256,  257,    0,   33,  100,   35,  102,  113,  114,
 /*   360 */   115,  116,  117,  118,  119,  120,  121,  122,  346,  124,
 /*   370 */   125,  126,  127,  128,  129,    0,    2,  397,  332,   58,
 /*   380 */   111,  401,    8,    9,    4,   64,   12,   13,   14,   15,
 /*   390 */    16,  419,   71,  371,  109,  340,   21,   20,  234,   24,
 /*   400 */    25,   26,   27,   28,   29,   30,   31,   32,    8,    9,
 /*   410 */   340,  365,   12,   13,   14,   15,   16,  250,   97,  373,
 /*   420 */    20,  100,  340,  443,  378,   71,  380,  447,  234,  365,
 /*   430 */   236,   12,   13,   14,  340,  111,  372,  361,  356,   20,
 /*   440 */    22,   22,  462,  463,  389,  381,  391,  467,  468,  332,
 /*   450 */   165,  213,   33,   35,   35,  373,  410,  136,  137,  389,
 /*   460 */   414,  391,    3,  417,  418,  419,  420,  421,  422,  423,
 /*   470 */   424,  425,  426,   66,   67,   68,   35,   58,  340,   20,
 /*   480 */   100,   74,   75,  389,  408,  391,   79,  166,  167,    3,
 /*   490 */    71,   84,   85,  172,  173,  378,  250,   90,  260,  261,
 /*   500 */   262,  263,  264,  265,  266,  250,   71,  186,  155,  188,
 /*   510 */   251,  373,   71,  136,  137,   97,   97,  164,   44,  100,
 /*   520 */   351,  352,  237,  238,  239,  240,  241,  242,  243,  244,
 /*   530 */   245,  246,  247,   20,  213,  214,  402,  216,  217,  218,
 /*   540 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*   550 */   229,  230,  231,  232,  233,  136,  137,    8,    9,  366,
 /*   560 */   101,   12,   13,   14,   15,   16,    8,    9,  168,  332,
 /*   570 */    12,   13,   14,   15,   16,  101,  438,  439,  440,  441,
 /*   580 */   332,  443,  444,  340,  443,  166,  167,  333,  447,    8,
 /*   590 */     9,  172,  173,   12,   13,   14,   15,   16,  443,  356,
 /*   600 */   366,  340,  447,  462,  463,  186,  363,  188,  467,  468,
 /*   610 */   332,   20,  428,  365,  430,  378,  373,  356,  463,  130,
 /*   620 */    47,  373,  467,  468,  363,   44,  378,  168,  380,  428,
 /*   630 */   250,  430,  213,  214,  373,  216,  217,  218,  219,  220,
 /*   640 */   221,  222,  223,  224,  225,  226,  227,  228,  229,  230,
 /*   650 */   231,  232,  233,   12,   13,  346,  378,  332,  410,  101,
 /*   660 */   397,   20,  414,   22,  401,  417,  418,  419,  420,  421,
 /*   670 */   422,  362,  424,  100,   33,  427,   35,  429,  430,  431,
 /*   680 */   371,  168,  165,  435,  436,  196,  197,   22,    8,    9,
 /*   690 */   365,  100,   12,   13,   14,   15,   16,  365,  373,   58,
 /*   700 */    35,  340,  416,  378,  372,  380,  443,  340,    2,  353,
 /*   710 */   447,  355,   71,  381,    8,    9,  379,  380,   12,   13,
 /*   720 */    14,   15,   16,  356,  366,  462,  463,  178,  442,  131,
 /*   730 */   467,  468,  340,  135,  373,  410,   71,  340,   97,  414,
 /*   740 */   373,  100,  417,  418,  419,  420,  421,  422,  356,  424,
 /*   750 */    37,   12,   13,  356,  237,   20,  270,   22,  357,   20,
 /*   760 */   365,   22,   97,  357,  247,  373,  365,  372,  130,  131,
 /*   770 */   373,  365,   33,  135,   35,  374,  381,  136,  137,    0,
 /*   780 */   374,  101,  332,    8,    9,    0,   51,   12,   13,   14,
 /*   790 */    15,   16,  194,  195,  469,  470,  198,   58,  200,  332,
 /*   800 */   439,  440,  441,  332,  443,  444,  344,  166,  167,  416,
 /*   810 */    71,  351,  352,  172,  173,  340,  103,  112,  105,  106,
 /*   820 */   181,  108,  360,   44,  275,  112,  365,  186,  378,  188,
 /*   830 */   368,  356,  365,  372,   39,  442,   97,   21,  133,  100,
 /*   840 */   373,  250,  381,  204,  205,  378,  133,  380,  373,  378,
 /*   850 */    34,  186,   36,  188,  213,  214,  332,  216,  217,  218,
 /*   860 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*   870 */   229,  230,  231,  232,  233,  136,  137,  410,  213,  214,
 /*   880 */   397,  414,    1,    2,  417,  418,  419,  420,  421,  422,
 /*   890 */   344,  424,   20,   14,   14,   15,   16,  112,  431,   20,
 /*   900 */   100,  332,  378,  436,  365,  166,  167,  340,  340,   20,
 /*   910 */   110,  172,  173,  374,  368,  130,  131,  132,  133,  134,
 /*   920 */   135,  365,   20,  356,  356,  186,  443,  188,    8,    9,
 /*   930 */   447,  354,   12,   13,   14,   15,   16,  381,  373,  375,
 /*   940 */   373,  373,  378,  168,  332,  462,  463,  378,    0,  384,
 /*   950 */   467,  468,  213,  214,  111,  216,  217,  218,  219,  220,
 /*   960 */   221,  222,  223,  224,  225,  226,  227,  228,  229,  230,
 /*   970 */   231,  232,  233,  100,   18,   18,   20,  397,   12,   13,
 /*   980 */    23,  373,  101,   27,   22,    4,   30,  332,   22,   33,
 /*   990 */   378,  373,  384,  358,   37,   38,  361,   35,   41,   33,
 /*  1000 */    19,   35,  384,  160,   48,   58,   50,  332,   22,   53,
 /*  1010 */   332,   63,  375,   44,   33,  378,   59,   60,   61,   62,
 /*  1020 */   365,   35,  332,  443,   58,  136,  137,  447,  373,   48,
 /*  1030 */    45,   46,  332,  378,   53,  380,  366,   71,  340,   58,
 /*  1040 */   168,  332,  462,  463,  249,  166,   99,  467,  468,  102,
 /*  1050 */    58,  332,  332,  378,  356,   99,  378,  100,  185,   97,
 /*  1060 */   187,  172,  173,   97,   20,  410,   44,  111,  378,  414,
 /*  1070 */   168,  373,  417,  418,  419,  420,  421,  422,  378,  424,
 /*  1080 */    99,  332,  367,  102,  429,  212,  431,  378,  332,  375,
 /*  1090 */   435,  436,  378,  378,  102,  138,  140,  378,  378,  143,
 /*  1100 */   144,  145,  146,  147,  148,  149,  150,  151,  152,  153,
 /*  1110 */   154,  155,  156,  157,  158,  159,  340,  161,  162,  163,
 /*  1120 */   366,  104,  340,  250,  107,  332,  340,  378,  413,  414,
 /*  1130 */   415,  340,  356,    0,  378,  178,  179,  180,  356,  424,
 /*  1140 */   183,  332,  356,  248,  249,  340,   42,  356,   44,  373,
 /*  1150 */    35,   42,  186,   44,  188,  373,   64,  340,  366,  373,
 /*  1160 */   203,  356,    0,  206,  373,  208,  209,  210,  211,  212,
 /*  1170 */   340,  378,  332,  356,  365,  199,  366,  201,  373,  213,
 /*  1180 */   214,   48,  373,  471,   22,   44,  356,  378,  340,  380,
 /*  1190 */   373,   35,  226,  227,  228,  229,  230,  231,  232,  340,
 /*  1200 */   332,  340,    0,  373,  356,  365,  104,  250,   44,  107,
 /*  1210 */   166,  104,  388,  373,  107,  356,   44,  356,  378,  410,
 /*  1220 */   380,  373,  332,  414,   22,    0,  417,  418,  419,  420,
 /*  1230 */   421,  422,  373,  424,  373,   44,   44,   44,  429,  332,
 /*  1240 */   431,  272,  101,   96,  435,  436,  378,   22,  104,   44,
 /*  1250 */   410,  107,    1,    2,  414,  365,   44,  417,  418,  419,
 /*  1260 */   420,  421,  422,  373,  424,  101,  457,    0,  378,  429,
 /*  1270 */   380,  431,  365,  101,  460,  435,  436,   44,  136,  137,
 /*  1280 */   373,  342,   44,  454,   44,  378,  446,  380,  365,   44,
 /*  1290 */   339,   44,  101,  101,  101,  342,  274,   44,   44,  332,
 /*  1300 */   410,   44,   44,  188,  414,  213,  101,  417,  418,  419,
 /*  1310 */   420,  421,  422,  101,  424,  168,   49,  410,  388,  332,
 /*  1320 */   377,  414,   44,   44,  417,  418,  419,  420,  421,  422,
 /*  1330 */   388,  424,  365,   35,  101,   13,  429,   19,  431,  101,
 /*  1340 */   373,  101,  435,  436,  188,  378,  101,  380,  101,  459,
 /*  1350 */   445,   33,  365,  446,  101,  101,   13,   35,  101,  101,
 /*  1360 */   373,  464,  437,  448,  252,  378,   48,  380,   48,   71,
 /*  1370 */   412,  411,   54,   55,   56,   57,   58,  410,   35,  101,
 /*  1380 */   101,  414,  184,  399,  417,  418,  419,  420,  421,  422,
 /*  1390 */    42,  424,  385,   20,  388,  385,  429,  410,  431,  165,
 /*  1400 */    20,  414,  435,  436,  417,  418,  419,  420,  421,  422,
 /*  1410 */   383,  424,  340,  446,  340,  385,  429,   99,  431,  383,
 /*  1420 */   102,  383,  435,  436,   98,  350,   95,  349,  332,  340,
 /*  1430 */    94,  348,  397,  446,  340,   33,   20,  340,  340,  334,
 /*  1440 */   334,   20,  405,   20,  380,  346,  346,   20,  332,  341,
 /*  1450 */    48,   20,  134,  398,  341,   52,   54,   55,   56,   57,
 /*  1460 */    58,  365,  340,  346,  346,  346,  346,  346,  343,  373,
 /*  1470 */   343,  334,  340,  334,  378,  365,  380,  202,  443,  365,
 /*  1480 */   409,  365,  447,  100,  407,  405,  192,  169,  365,  373,
 /*  1490 */   344,  365,  174,  365,  378,  365,  380,  462,  463,  365,
 /*  1500 */   365,   99,  467,  468,  102,  365,  410,  378,  190,  378,
 /*  1510 */   414,  193,  191,  417,  418,  419,  420,  421,  422,  365,
 /*  1520 */   424,  378,  332,  365,  344,  429,  410,  431,  404,  380,
 /*  1530 */   414,  435,  436,  417,  418,  419,  420,  421,  422,  403,
 /*  1540 */   424,  340,  446,  388,  378,  429,  332,  431,  388,  259,
 /*  1550 */   258,  435,  436,  378,  453,  365,  393,  378,  393,  378,
 /*  1560 */   267,  177,  253,  373,  453,  269,  271,  268,  378,  412,
 /*  1570 */   380,  169,  170,  276,  273,  472,  174,  249,  176,  365,
 /*  1580 */   373,   20,  340,  416,  341,  344,   20,  373,  344,  393,
 /*  1590 */   391,  378,  378,  455,  380,  193,  332,  378,  378,  451,
 /*  1600 */   410,  456,  450,  453,  414,  397,  378,  417,  418,  419,
 /*  1610 */   420,  421,  422,  332,  424,  378,  393,  466,  465,  429,
 /*  1620 */   452,  431,  170,  361,  410,  435,  436,  378,  414,  365,
 /*  1630 */   344,  417,  418,  419,  420,  421,  422,  373,  424,  373,
 /*  1640 */   390,  100,  378,  434,  380,  431,  365,  344,  100,  435,
 /*  1650 */   436,  443,  369,  340,  373,  447,  344,  355,  378,  378,
 /*  1660 */    36,  380,  335,  334,  394,  400,  406,  394,  345,  359,
 /*  1670 */   462,  463,  330,  332,  410,  467,  468,    0,  414,    0,
 /*  1680 */     0,  417,  418,  419,  420,  421,  422,   42,  424,  359,
 /*  1690 */     0,  410,  359,  332,   35,  414,  207,   35,  417,  418,
 /*  1700 */   419,  420,  421,  422,   35,  424,  365,   35,  207,    0,
 /*  1710 */    35,   35,  431,  207,  373,    0,  435,  436,  207,  378,
 /*  1720 */     0,  380,   35,    0,   22,  461,  365,    0,   35,  194,
 /*  1730 */   188,  186,    0,    0,  373,    0,  182,  181,    0,  378,
 /*  1740 */     0,  380,   47,    0,    0,    0,   42,    0,    0,    0,
 /*  1750 */     0,  410,    0,    0,    0,  414,  332,    0,  417,  418,
 /*  1760 */   419,  420,  421,  422,  155,  424,   35,    0,  155,    0,
 /*  1770 */     0,  410,  431,    0,    0,  414,  435,  436,  417,  418,
 /*  1780 */   419,  420,  421,  422,   42,  424,    0,    0,    0,  365,
 /*  1790 */     0,    0,    0,    0,  370,    0,    0,  373,    0,    0,
 /*  1800 */     0,    0,  378,    0,  380,    0,    0,    0,    0,    0,
 /*  1810 */     0,   22,    0,  139,  332,    0,    0,   96,   96,   22,
 /*  1820 */     0,   58,    0,   58,   22,    0,   58,    0,    0,   35,
 /*  1830 */    47,  470,   14,   14,  410,    0,    0,    0,  414,  332,
 /*  1840 */     0,  417,  418,  419,  420,  421,  422,  365,  424,    0,
 /*  1850 */   177,   47,   39,   42,    0,  373,    0,    0,   44,    0,
 /*  1860 */   378,   40,  380,   39,   47,   39,   35,    0,   39,   35,
 /*  1870 */     0,   39,  365,   35,    0,    0,    0,  370,   48,   35,
 /*  1880 */   373,   48,   39,    0,    0,  378,   39,  380,   65,   48,
 /*  1890 */   109,   22,  410,   48,    0,   35,  414,   35,   35,  417,
 /*  1900 */   418,  419,  420,  421,  422,    0,  424,   35,  426,   44,
 /*  1910 */    44,   22,  332,   35,   35,   35,   35,  410,   22,    0,
 /*  1920 */    22,  414,   22,   50,  417,  418,  419,  420,  421,  422,
 /*  1930 */     0,  424,   35,  332,    0,    0,   35,   35,    0,   22,
 /*  1940 */    20,   35,   35,   35,    0,  365,  107,  101,  100,   35,
 /*  1950 */   370,  100,    0,  373,   22,  189,    0,    0,  378,   22,
 /*  1960 */   380,    3,  332,   47,  254,   44,  365,   44,   44,   44,
 /*  1970 */   254,   44,    3,   47,  373,   44,   35,  100,  254,  378,
 /*  1980 */    35,  380,  100,  332,   96,   98,  101,   96,   95,   35,
 /*  1990 */   410,  101,   44,  101,  414,  365,  101,  417,  418,  419,
 /*  2000 */   420,  421,  422,  373,  424,  101,   35,   35,  378,  100,
 /*  2010 */   380,  410,  100,  100,   35,  414,  365,   47,  417,  418,
 /*  2020 */   419,  420,  421,  422,  373,  424,  168,  175,  100,  378,
 /*  2030 */   101,  380,  168,  332,  101,   47,    0,  101,  170,  168,
 /*  2040 */   410,    0,    0,    0,  414,   39,  100,  417,  418,  419,
 /*  2050 */   420,  421,  422,  100,  424,   47,  101,  171,  332,   39,
 /*  2060 */   101,  410,  100,  100,  100,  414,  365,    0,  417,  418,
 /*  2070 */   419,  420,  421,  422,  373,  424,  100,  110,   47,  378,
 /*  2080 */   169,  380,   44,   98,   98,    2,   22,  100,  235,  111,
 /*  2090 */   101,  365,  100,  332,  101,  100,   47,  100,  248,  373,
 /*  2100 */   101,  100,   47,  101,  378,  100,  380,   22,  101,   35,
 /*  2110 */   100,  410,  213,   35,  101,  414,  332,   35,  417,  418,
 /*  2120 */   419,  420,  421,  422,  100,  424,  365,  101,   35,  100,
 /*  2130 */   215,  101,   35,  100,  373,  101,  410,   35,  123,  378,
 /*  2140 */   414,  380,  123,  417,  418,  419,  420,  421,  422,  365,
 /*  2150 */   424,  100,   22,  100,   44,  123,  112,  373,  123,   35,
 /*  2160 */   100,  100,  378,   22,  380,   65,   35,   64,   35,   35,
 /*  2170 */    35,  410,   35,   35,  332,  414,   71,   35,  417,  418,
 /*  2180 */   419,  420,  421,  422,   35,  424,   35,   35,   93,   44,
 /*  2190 */    35,   35,   35,  332,  410,   22,   35,   35,  414,   35,
 /*  2200 */    71,  417,  418,  419,  420,  421,  422,  365,  424,   35,
 /*  2210 */    22,   35,   35,   35,   35,  373,   35,    0,   35,   48,
 /*  2220 */   378,   39,  380,    0,   35,   39,  365,    0,   48,   35,
 /*  2230 */    39,    0,   48,   35,  373,   48,   39,    0,   35,  378,
 /*  2240 */    35,  380,    0,   22,   22,   21,   20,   22,  473,   21,
 /*  2250 */   473,  473,  410,  473,  332,  473,  414,  473,  473,  417,
 /*  2260 */   418,  419,  420,  421,  422,  473,  424,  473,  473,  473,
 /*  2270 */   473,  410,  473,  473,  473,  414,  473,  473,  417,  418,
 /*  2280 */   419,  420,  421,  422,  473,  424,  473,  365,  473,  473,
 /*  2290 */   473,  473,  473,  473,  473,  373,  473,  473,  473,  473,
 /*  2300 */   378,  473,  380,  473,  473,  473,  473,  473,  473,  473,
 /*  2310 */   473,  473,  332,  473,  473,  473,  473,  473,  473,  473,
 /*  2320 */   473,  473,  473,  473,  473,  473,  473,  473,  332,  473,
 /*  2330 */   473,  473,  410,  473,  473,  473,  414,  473,  473,  417,
 /*  2340 */   418,  419,  420,  421,  422,  365,  424,  473,  473,  473,
 /*  2350 */   473,  473,  473,  373,  473,  473,  473,  473,  378,  473,
 /*  2360 */   380,  365,  473,  473,  473,  473,  473,  473,  473,  373,
 /*  2370 */   473,  473,  473,  473,  378,  473,  380,  473,  473,  473,
 /*  2380 */   473,  473,  473,  473,  473,  473,  473,  473,  473,  473,
 /*  2390 */   410,  332,  473,  473,  414,  473,  473,  417,  418,  419,
 /*  2400 */   420,  421,  422,  473,  424,  473,  410,  332,  473,  473,
 /*  2410 */   414,  473,  473,  417,  418,  419,  420,  421,  422,  473,
 /*  2420 */   424,  473,  473,  473,  365,  473,  332,  473,  473,  473,
 /*  2430 */   473,  473,  373,  473,  473,  473,  473,  378,  473,  380,
 /*  2440 */   365,  473,  473,  473,  473,  473,  473,  473,  373,  473,
 /*  2450 */   473,  473,  473,  378,  473,  380,  473,  473,  473,  365,
 /*  2460 */   473,  473,  473,  473,  473,  473,  473,  373,  473,  410,
 /*  2470 */   473,  473,  378,  414,  380,  473,  417,  418,  419,  420,
 /*  2480 */   421,  422,  473,  424,  473,  410,  473,  473,  473,  414,
 /*  2490 */   332,  473,  417,  418,  419,  420,  421,  422,  473,  424,
 /*  2500 */   473,  473,  473,  473,  410,  473,  473,  332,  414,  473,
 /*  2510 */   473,  417,  418,  419,  420,  421,  422,  473,  424,  473,
 /*  2520 */   473,  473,  473,  365,  473,  473,  473,  473,  473,  473,
 /*  2530 */   473,  373,  473,  473,  473,  473,  378,  473,  380,  473,
 /*  2540 */   365,  473,  473,  473,  473,  473,  473,  473,  373,  473,
 /*  2550 */   473,  473,  473,  378,  473,  380,  473,  473,  473,  473,
 /*  2560 */   473,  473,  473,  473,  473,  473,  473,  332,  410,  473,
 /*  2570 */   473,  473,  414,  473,  473,  417,  418,  419,  420,  421,
 /*  2580 */   422,  473,  424,  473,  473,  410,  473,  332,  473,  414,
 /*  2590 */   473,  473,  417,  418,  419,  420,  421,  422,  473,  424,
 /*  2600 */   365,  473,  473,  473,  473,  473,  473,  473,  373,  473,
 /*  2610 */   473,  473,  473,  378,  473,  380,  473,  473,  473,  473,
 /*  2620 */   365,  473,  473,  473,  473,  473,  473,  473,  373,  473,
 /*  2630 */   473,  473,  473,  378,  473,  380,  473,  473,  473,  473,
 /*  2640 */   473,  473,  473,  473,  473,  410,  473,  473,  473,  414,
 /*  2650 */   473,  473,  417,  418,  419,  420,  421,  422,  473,  424,
 /*  2660 */   473,  332,  473,  473,  473,  410,  473,  473,  473,  414,
 /*  2670 */   473,  473,  417,  418,  419,  420,  421,  422,  332,  424,
 /*  2680 */   473,  473,  473,  473,  473,  473,  473,  473,  473,  473,
 /*  2690 */   473,  473,  473,  473,  365,  473,  473,  473,  473,  473,
 /*  2700 */   473,  473,  373,  473,  473,  473,  473,  378,  473,  380,
 /*  2710 */   473,  365,  473,  473,  473,  473,  473,  473,  473,  373,
 /*  2720 */   473,  473,  473,  473,  378,  473,  380,  473,  473,  473,
 /*  2730 */   473,  473,  473,  473,  473,  473,  473,  473,  473,  410,
 /*  2740 */   332,  473,  473,  414,  473,  473,  417,  418,  419,  420,
 /*  2750 */   421,  422,  473,  424,  473,  473,  410,  473,  473,  473,
 /*  2760 */   414,  473,  473,  417,  418,  419,  420,  421,  422,  473,
 /*  2770 */   424,  473,  473,  365,  473,  473,  473,  473,  473,  473,
 /*  2780 */   473,  373,  473,  473,  473,  473,  378,  473,  380,  473,
 /*  2790 */   473,  473,  473,  473,  473,  473,  473,  473,  473,  473,
 /*  2800 */   473,  473,  473,  473,  473,  473,  473,  473,  473,  473,
 /*  2810 */   473,  473,  473,  473,  473,  473,  473,  473,  410,  473,
 /*  2820 */   473,  473,  414,  473,  473,  417,  418,  419,  420,  421,
 /*  2830 */   422,  473,  424,
};
#define YY_SHIFT_COUNT    (752)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2242)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   957,    0,   98,    0,  321,  321,  321,  321,  321,  321,
 /*    10 */   321,  321,  321,  321,  321,  419,  641,  641,  739,  641,
 /*    20 */   641,  641,  641,  641,  641,  641,  641,  641,  641,  641,
 /*    30 */   641,  641,  641,  641,  641,  641,  641,  641,  641,  641,
 /*    40 */   641,  641,  641,  641,  641,  641,  641,  641,  167,  591,
 /*    50 */   873,   68,  255,   90,  246,   90,   68,   68,  966,  966,
 /*    60 */   966,   90,  966,  966,  380,   90,    9,  889,   24,   24,
 /*    70 */   889,  151,  151,   41,  377,   63,   63,   24,   24,   24,
 /*    80 */    24,   24,   24,   24,   84,   24,   24,  108,    9,   24,
 /*    90 */    24,  221,   24,    9,   24,   84,   24,   84,    9,   24,
 /*   100 */    24,    9,   24,    9,    9,    9,   24,  205,  956,  285,
 /*   110 */   285,  251,  407,  665,  665,  665,  665,  665,  665,  665,
 /*   120 */   665,  665,  665,  665,  665,  665,  665,  665,  665,  665,
 /*   130 */   665,  665,  713,  459,   41,  377,  441,  513,  513,  513,
 /*   140 */   948,  194,  194,  441,  282,  282,  282,  108,  269,  164,
 /*   150 */     9,  354,    9,  354,  354,  324,  435,  245,  245,  245,
 /*   160 */   245,  245,  245,  245,  245, 1318,  375,  125,  400,  549,
 /*   170 */   238,  112,   95,  129,  879,  735,  872,  985,  705,  902,
 /*   180 */   895,  795,  486,  895, 1104,  259, 1044, 1112, 1320, 1198,
 /*   190 */  1348, 1373, 1348, 1234, 1380, 1380, 1348, 1234, 1234, 1326,
 /*   200 */  1331, 1380, 1336, 1380, 1380, 1380, 1416, 1416, 1421,  108,
 /*   210 */  1423,  108, 1427, 1431,  108, 1427,  108,  108,  108, 1380,
 /*   220 */   108, 1403, 1403, 1416,    9,    9,    9,    9,    9,    9,
 /*   230 */     9,    9,    9,    9,    9, 1380, 1416,  354,  354,  354,
 /*   240 */  1275, 1383, 1421,  205, 1294, 1321, 1423,  205, 1380, 1373,
 /*   250 */  1373,  354, 1290, 1292,  354, 1290, 1292,  354,  354,    9,
 /*   260 */  1293, 1384, 1290, 1296, 1299, 1309, 1112, 1297, 1301, 1295,
 /*   270 */  1328,  282, 1561, 1380, 1427,  205,  205, 1566, 1292,  354,
 /*   280 */   354,  354,  354,  354, 1292,  354, 1452,  205,  324,  205,
 /*   290 */   282, 1541, 1548,  354,  435, 1380,  205, 1624, 1416, 2833,
 /*   300 */  2833, 2833, 2833, 2833, 2833, 2833, 2833, 2833,  170, 1402,
 /*   310 */   152,  981,  558,  581,  680,  157,  374,  706,  775,  785,
 /*   320 */   920,  920,  920,  920,  920,  920,  920,  920,  920,  173,
 /*   330 */   598,   27,   27,  132,  639,  353,  947,  418,  962,  816,
 /*   340 */   489,  638,  638,  880,  881,  517,  880,  880,  880, 1133,
 /*   350 */   474,  986, 1109,  843,  779, 1017, 1102, 1107, 1144, 1162,
 /*   360 */  1202, 1225,  976, 1141, 1164,  992, 1172, 1191, 1193, 1142,
 /*   370 */   969, 1022, 1147, 1205, 1212, 1233, 1238, 1240, 1245, 1251,
 /*   380 */  1247, 1115, 1156, 1092, 1192,  573, 1253, 1254, 1257, 1258,
 /*   390 */  1278, 1279,  800, 1322, 1343, 1298, 1267, 1677, 1679, 1680,
 /*   400 */  1645, 1690, 1659, 1489, 1662, 1669, 1672, 1501, 1709, 1675,
 /*   410 */  1676, 1506, 1715, 1511, 1720, 1687, 1723, 1702, 1727, 1693,
 /*   420 */  1535, 1542, 1545, 1732, 1733, 1735, 1554, 1556, 1738, 1740,
 /*   430 */  1695, 1743, 1744, 1745, 1704, 1747, 1748, 1749, 1750, 1752,
 /*   440 */  1753, 1754, 1757, 1609, 1731, 1767, 1613, 1769, 1770, 1773,
 /*   450 */  1774, 1786, 1787, 1788, 1790, 1791, 1792, 1793, 1795, 1796,
 /*   460 */  1798, 1799, 1800, 1742, 1801, 1803, 1805, 1806, 1807, 1808,
 /*   470 */  1789, 1809, 1810, 1812, 1674, 1815, 1816, 1797, 1721, 1802,
 /*   480 */  1722, 1820, 1763, 1794, 1822, 1765, 1825, 1768, 1827, 1828,
 /*   490 */  1811, 1813, 1814, 1783, 1818, 1804, 1819, 1817, 1835, 1821,
 /*   500 */  1824, 1836, 1837, 1840, 1826, 1673, 1849, 1854, 1856, 1823,
 /*   510 */  1857, 1859, 1831, 1830, 1829, 1867, 1834, 1833, 1832, 1870,
 /*   520 */  1838, 1841, 1843, 1874, 1844, 1845, 1847, 1875, 1876, 1883,
 /*   530 */  1884, 1781, 1839, 1860, 1869, 1894, 1862, 1863, 1872, 1878,
 /*   540 */  1865, 1866, 1879, 1880, 1889, 1881, 1905, 1896, 1919, 1898,
 /*   550 */  1873, 1930, 1900, 1897, 1934, 1901, 1935, 1902, 1938, 1917,
 /*   560 */  1920, 1906, 1907, 1908, 1846, 1848, 1944, 1858, 1851, 1914,
 /*   570 */  1932, 1952, 1766, 1937, 1864, 1868, 1956, 1957, 1871, 1852,
 /*   580 */  1958, 1921, 1710, 1877, 1885, 1882, 1888, 1887, 1891, 1893,
 /*   590 */  1890, 1923, 1924, 1892, 1909, 1912, 1913, 1895, 1925, 1916,
 /*   600 */  1926, 1928, 1927, 1716, 1904, 1929, 1969, 1931, 1724, 1941,
 /*   610 */  1945, 1954, 1971, 1972, 1979, 1933, 1936, 1970, 1850, 1948,
 /*   620 */  1988, 2036, 2041, 2042, 2043, 1946, 2006, 1783, 2008, 1953,
 /*   630 */  1955, 1959, 1962, 1963, 1886, 1964, 2067, 2020, 1911, 1976,
 /*   640 */  1967, 1783, 2031, 2038, 1985, 1853, 1986, 2083, 2064, 1899,
 /*   650 */  1987, 1989, 1992, 1993, 1995, 1999, 2049, 1997, 2001, 2055,
 /*   660 */  2002, 2085, 1915, 2005, 1978, 2007, 2074, 2078, 2010, 2013,
 /*   670 */  2082, 2024, 2026, 2093, 2029, 2030, 2097, 2033, 2034, 2102,
 /*   680 */  2051, 2015, 2019, 2032, 2035, 2130, 2044, 2053, 2110, 2060,
 /*   690 */  2124, 2061, 2110, 2110, 2141, 2100, 2103, 2131, 2133, 2134,
 /*   700 */  2135, 2137, 2138, 2142, 2149, 2151, 2152, 2105, 2095, 2145,
 /*   710 */  2155, 2156, 2157, 2173, 2161, 2162, 2164, 2129, 1865, 2174,
 /*   720 */  1866, 2176, 2177, 2178, 2179, 2188, 2181, 2217, 2183, 2171,
 /*   730 */  2182, 2223, 2189, 2180, 2186, 2227, 2194, 2184, 2191, 2231,
 /*   740 */  2198, 2187, 2197, 2237, 2203, 2205, 2242, 2221, 2224, 2222,
 /*   750 */  2225, 2228, 2226,
};
#define YY_REDUCE_COUNT (307)
#define YY_REDUCE_MIN   (-442)
#define YY_REDUCE_MAX   (2408)
static const short yy_reduce_ofst[] = {
 /*     0 */   -20, -328,  248,  809,  840,  907,  967,  987, 1096,  655,
 /*    10 */  1116, 1190, 1214, 1281, 1341,   46, -305,  325,  467,  890,
 /*    20 */  1264, 1361, 1424, 1482, 1507, 1580, 1601, 1630, 1651, 1701,
 /*    30 */  1726, 1761, 1784, 1842, 1861, 1922, 1980, 1996, 2059, 2075,
 /*    40 */  2094, 2158, 2175, 2235, 2255, 2329, 2346, 2408, -317, -303,
 /*    50 */   263,  138,  483,  580, 1035, 1208, -238,  361, -367, -348,
 /*    60 */   715,  141, -329, -239, -442,  155, -302, -364,  243,  261,
 /*    70 */  -378, -330, -285, -306,  -41, -199,    7,   82,  367,  397,
 /*    80 */   475,  567,  568,  782,   55,  786,  791,  309,   64,  805,
 /*    90 */   817,  -28,  392,  332,  698,   70,  830,   94, -350,  848,
 /*   100 */   859,  395,  861,  401,  461,  406,  776,  462, -234, -334,
 /*   110 */  -334, -297, -344,  117,  237,  278,  450,  471,  524,  569,
 /*   120 */   612,  675,  678,  690,  700,  709,  719,  720,  749,  756,
 /*   130 */   793,  868, -290, -106, -176,  337,  169, -106,  286,  393,
 /*   140 */   546,  184,  201,  460,  565,  608,  618,   22,   76, -269,
 /*   150 */   539,  564,  556,  637,  714,  635,  356,  193,  234,  358,
 /*   160 */   670,  754,  792,  810,  754,  134,  254,  577,  824,  712,
 /*   170 */   814,  939,  829,  923,  923,  953,  930,  951,  943,  942,
 /*   180 */   905,  905,  897,  905,  925,  915,  923,  958,  960,  984,
 /*   190 */  1007, 1006, 1010, 1027, 1072, 1074, 1030, 1036, 1038, 1075,
 /*   200 */  1078, 1089, 1083, 1094, 1097, 1098, 1105, 1106, 1037, 1099,
 /*   210 */  1064, 1100, 1108, 1055, 1117, 1113, 1118, 1119, 1120, 1122,
 /*   220 */  1121, 1125, 1127, 1137, 1110, 1114, 1123, 1126, 1128, 1130,
 /*   230 */  1134, 1135, 1140, 1154, 1158, 1132, 1139, 1129, 1131, 1143,
 /*   240 */  1071, 1077, 1080, 1146, 1124, 1136, 1149, 1180, 1201, 1155,
 /*   250 */  1160, 1166, 1101, 1163, 1175, 1111, 1165, 1179, 1181,  923,
 /*   260 */  1145, 1138, 1150, 1168, 1148, 1152, 1157, 1103, 1151, 1153,
 /*   270 */   905, 1207, 1167, 1242, 1243, 1241, 1244, 1199, 1196, 1213,
 /*   280 */  1219, 1220, 1228, 1237, 1223, 1249, 1250, 1286, 1262, 1303,
 /*   290 */  1266, 1209, 1283, 1280, 1302, 1313, 1312, 1327, 1329, 1265,
 /*   300 */  1260, 1270, 1273, 1310, 1330, 1333, 1323, 1342,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*    10 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*    20 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*    30 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*    40 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*    50 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*    60 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*    70 */  1692, 1692, 1692, 1958, 1692, 1692, 1692, 1692, 1692, 1692,
 /*    80 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1771, 1692, 1692,
 /*    90 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   100 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1769, 1951, 2169,
 /*   110 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   120 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   130 */  1692, 1692, 1692, 2181, 1692, 1692, 1692, 2181, 2181, 2181,
 /*   140 */  1769, 2141, 2141, 1692, 1692, 1692, 1692, 1771, 2014, 1692,
 /*   150 */  1692, 1692, 1692, 1692, 1692, 1886, 1692, 1692, 1692, 1692,
 /*   160 */  1692, 1910, 1692, 1692, 1692, 2004, 1692, 1692, 2206, 2262,
 /*   170 */  1692, 1692, 2209, 1692, 1692, 1692, 1963, 1692, 1839, 2196,
 /*   180 */  2173, 2187, 2246, 2174, 2171, 2190, 1692, 2200, 1692, 1997,
 /*   190 */  1956, 1692, 1956, 1953, 1692, 1692, 1956, 1953, 1953, 1828,
 /*   200 */  1824, 1692, 1822, 1692, 1692, 1692, 1692, 1692, 1692, 1771,
 /*   210 */  1692, 1771, 1692, 1692, 1771, 1692, 1771, 1771, 1771, 1692,
 /*   220 */  1771, 1749, 1749, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   230 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   240 */  2026, 2012, 1692, 1769, 2008, 2006, 1692, 1769, 1692, 1692,
 /*   250 */  1692, 1692, 2217, 2215, 1692, 2217, 2215, 1692, 1692, 1692,
 /*   260 */  2231, 2227, 2217, 2235, 2233, 2202, 2200, 2265, 2252, 2248,
 /*   270 */  2187, 1692, 1692, 1692, 1692, 1769, 1769, 1692, 2215, 1692,
 /*   280 */  1692, 1692, 1692, 1692, 2215, 1692, 1692, 1769, 1692, 1769,
 /*   290 */  1692, 1692, 1855, 1692, 1692, 1692, 1769, 1724, 1692, 1999,
 /*   300 */  2017, 1981, 1981, 1889, 1889, 1889, 1772, 1697, 1692, 1692,
 /*   310 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   320 */  2230, 2229, 2096, 1692, 2145, 2144, 2143, 2134, 2095, 1851,
 /*   330 */  1692, 2094, 2093, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   340 */  1692, 1972, 1971, 2087, 1692, 1692, 2088, 2086, 2085, 1692,
 /*   350 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   360 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   370 */  2249, 2253, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 2170,
 /*   380 */  1692, 1692, 1692, 1692, 1692, 2069, 1692, 1692, 1692, 1692,
 /*   390 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   400 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   410 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   420 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   430 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   440 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   450 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   460 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   470 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   480 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   490 */  1692, 1692, 1729, 2074, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   500 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   510 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   520 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   530 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   540 */  1810, 1809, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   550 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   560 */  1692, 1692, 1692, 1692, 2078, 1692, 1692, 1692, 1692, 1692,
 /*   570 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   580 */  2245, 2203, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   590 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   600 */  2069, 1692, 2228, 1692, 1692, 2243, 1692, 2247, 1692, 1692,
 /*   610 */  1692, 1692, 1692, 1692, 1692, 2180, 2176, 1692, 1692, 2172,
 /*   620 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 2077, 1692, 1692,
 /*   630 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   640 */  1692, 2068, 1692, 2131, 1692, 1692, 1692, 2165, 1692, 1692,
 /*   650 */  2116, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   660 */  2078, 1692, 2081, 1692, 1692, 1692, 1692, 1692, 1883, 1692,
 /*   670 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   680 */  1692, 1868, 1866, 1865, 1864, 1692, 1861, 1692, 1896, 1692,
 /*   690 */  1692, 1692, 1892, 1891, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   700 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1790,
 /*   710 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1782, 1692,
 /*   720 */  1781, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   730 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   740 */  1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692, 1692,
 /*   750 */  1692, 1692, 1692,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      START => nothing */
    0,  /*       WITH => nothing */
    0,  /*  TIMESTAMP => nothing */
  277,  /*        END => ABORT */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*   LANGUAGE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  277,  /*      AFTER => ABORT */
  277,  /*     ATTACH => ABORT */
  277,  /*     BEFORE => ABORT */
  277,  /*      BEGIN => ABORT */
  277,  /*     BITAND => ABORT */
  277,  /*     BITNOT => ABORT */
  277,  /*      BITOR => ABORT */
  277,  /*     BLOCKS => ABORT */
  277,  /*     CHANGE => ABORT */
  277,  /*      COMMA => ABORT */
  277,  /*     CONCAT => ABORT */
  277,  /*   CONFLICT => ABORT */
  277,  /*       COPY => ABORT */
  277,  /*   DEFERRED => ABORT */
  277,  /* DELIMITERS => ABORT */
  277,  /*     DETACH => ABORT */
  277,  /*     DIVIDE => ABORT */
  277,  /*        DOT => ABORT */
  277,  /*       EACH => ABORT */
  277,  /*       FAIL => ABORT */
  277,  /*       FILE => ABORT */
  277,  /*        FOR => ABORT */
  277,  /*       GLOB => ABORT */
  277,  /*         ID => ABORT */
  277,  /*  IMMEDIATE => ABORT */
  277,  /*     IMPORT => ABORT */
  277,  /*  INITIALLY => ABORT */
  277,  /*    INSTEAD => ABORT */
  277,  /*     ISNULL => ABORT */
  277,  /*        KEY => ABORT */
  277,  /*    MODULES => ABORT */
  277,  /*  NK_BITNOT => ABORT */
  277,  /*    NK_SEMI => ABORT */
  277,  /*    NOTNULL => ABORT */
  277,  /*         OF => ABORT */
  277,  /*       PLUS => ABORT */
  277,  /*  PRIVILEGE => ABORT */
  277,  /*      RAISE => ABORT */
  277,  /*    REPLACE => ABORT */
  277,  /*   RESTRICT => ABORT */
  277,  /*        ROW => ABORT */
  277,  /*       SEMI => ABORT */
  277,  /*       STAR => ABORT */
  277,  /*  STATEMENT => ABORT */
  277,  /*     STRICT => ABORT */
  277,  /*     STRING => ABORT */
  277,  /*      TIMES => ABORT */
  277,  /*     VALUES => ABORT */
  277,  /*   VARIABLE => ABORT */
  277,  /*       VIEW => ABORT */
  277,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "COMPACT",
  /*   63 */ "IF",
  /*   64 */ "NOT",
  /*   65 */ "EXISTS",
  /*   66 */ "BUFFER",
  /*   67 */ "CACHEMODEL",
  /*   68 */ "CACHESIZE",
  /*   69 */ "COMP",
  /*   70 */ "DURATION",
  /*   71 */ "NK_VARIABLE",
  /*   72 */ "MAXROWS",
  /*   73 */ "MINROWS",
  /*   74 */ "KEEP",
  /*   75 */ "PAGES",
  /*   76 */ "PAGESIZE",
  /*   77 */ "TSDB_PAGESIZE",
  /*   78 */ "PRECISION",
  /*   79 */ "REPLICA",
  /*   80 */ "VGROUPS",
  /*   81 */ "SINGLE_STABLE",
  /*   82 */ "RETENTIONS",
  /*   83 */ "SCHEMALESS",
  /*   84 */ "WAL_LEVEL",
  /*   85 */ "WAL_FSYNC_PERIOD",
  /*   86 */ "WAL_RETENTION_PERIOD",
  /*   87 */ "WAL_RETENTION_SIZE",
  /*   88 */ "WAL_ROLL_PERIOD",
  /*   89 */ "WAL_SEGMENT_SIZE",
  /*   90 */ "STT_TRIGGER",
  /*   91 */ "TABLE_PREFIX",
  /*   92 */ "TABLE_SUFFIX",
  /*   93 */ "NK_COLON",
  /*   94 */ "MAX_SPEED",
  /*   95 */ "START",
  /*   96 */ "WITH",
  /*   97 */ "TIMESTAMP",
  /*   98 */ "END",
  /*   99 */ "TABLE",
  /*  100 */ "NK_LP",
  /*  101 */ "NK_RP",
  /*  102 */ "STABLE",
  /*  103 */ "ADD",
  /*  104 */ "COLUMN",
  /*  105 */ "MODIFY",
  /*  106 */ "RENAME",
  /*  107 */ "TAG",
  /*  108 */ "SET",
  /*  109 */ "NK_EQ",
  /*  110 */ "USING",
  /*  111 */ "TAGS",
  /*  112 */ "COMMENT",
  /*  113 */ "BOOL",
  /*  114 */ "TINYINT",
  /*  115 */ "SMALLINT",
  /*  116 */ "INT",
  /*  117 */ "INTEGER",
  /*  118 */ "BIGINT",
  /*  119 */ "FLOAT",
  /*  120 */ "DOUBLE",
  /*  121 */ "BINARY",
  /*  122 */ "NCHAR",
  /*  123 */ "UNSIGNED",
  /*  124 */ "JSON",
  /*  125 */ "VARCHAR",
  /*  126 */ "MEDIUMBLOB",
  /*  127 */ "BLOB",
  /*  128 */ "VARBINARY",
  /*  129 */ "DECIMAL",
  /*  130 */ "MAX_DELAY",
  /*  131 */ "WATERMARK",
  /*  132 */ "ROLLUP",
  /*  133 */ "TTL",
  /*  134 */ "SMA",
  /*  135 */ "DELETE_MARK",
  /*  136 */ "FIRST",
  /*  137 */ "LAST",
  /*  138 */ "SHOW",
  /*  139 */ "PRIVILEGES",
  /*  140 */ "DATABASES",
  /*  141 */ "TABLES",
  /*  142 */ "STABLES",
  /*  143 */ "MNODES",
  /*  144 */ "QNODES",
  /*  145 */ "FUNCTIONS",
  /*  146 */ "INDEXES",
  /*  147 */ "ACCOUNTS",
  /*  148 */ "APPS",
  /*  149 */ "CONNECTIONS",
  /*  150 */ "LICENCES",
  /*  151 */ "GRANTS",
  /*  152 */ "QUERIES",
  /*  153 */ "SCORES",
  /*  154 */ "TOPICS",
  /*  155 */ "VARIABLES",
  /*  156 */ "CLUSTER",
  /*  157 */ "BNODES",
  /*  158 */ "SNODES",
  /*  159 */ "TRANSACTIONS",
  /*  160 */ "DISTRIBUTED",
  /*  161 */ "CONSUMERS",
  /*  162 */ "SUBSCRIPTIONS",
  /*  163 */ "VNODES",
  /*  164 */ "ALIVE",
  /*  165 */ "LIKE",
  /*  166 */ "TBNAME",
  /*  167 */ "QTAGS",
  /*  168 */ "AS",
  /*  169 */ "INDEX",
  /*  170 */ "FUNCTION",
  /*  171 */ "INTERVAL",
  /*  172 */ "COUNT",
  /*  173 */ "LAST_ROW",
  /*  174 */ "TOPIC",
  /*  175 */ "META",
  /*  176 */ "CONSUMER",
  /*  177 */ "GROUP",
  /*  178 */ "DESC",
  /*  179 */ "DESCRIBE",
  /*  180 */ "RESET",
  /*  181 */ "QUERY",
  /*  182 */ "CACHE",
  /*  183 */ "EXPLAIN",
  /*  184 */ "ANALYZE",
  /*  185 */ "VERBOSE",
  /*  186 */ "NK_BOOL",
  /*  187 */ "RATIO",
  /*  188 */ "NK_FLOAT",
  /*  189 */ "OUTPUTTYPE",
  /*  190 */ "AGGREGATE",
  /*  191 */ "BUFSIZE",
  /*  192 */ "LANGUAGE",
  /*  193 */ "STREAM",
  /*  194 */ "INTO",
  /*  195 */ "TRIGGER",
  /*  196 */ "AT_ONCE",
  /*  197 */ "WINDOW_CLOSE",
  /*  198 */ "IGNORE",
  /*  199 */ "EXPIRED",
  /*  200 */ "FILL_HISTORY",
  /*  201 */ "UPDATE",
  /*  202 */ "SUBTABLE",
  /*  203 */ "KILL",
  /*  204 */ "CONNECTION",
  /*  205 */ "TRANSACTION",
  /*  206 */ "BALANCE",
  /*  207 */ "VGROUP",
  /*  208 */ "MERGE",
  /*  209 */ "REDISTRIBUTE",
  /*  210 */ "SPLIT",
  /*  211 */ "DELETE",
  /*  212 */ "INSERT",
  /*  213 */ "NULL",
  /*  214 */ "NK_QUESTION",
  /*  215 */ "NK_ARROW",
  /*  216 */ "ROWTS",
  /*  217 */ "QSTART",
  /*  218 */ "QEND",
  /*  219 */ "QDURATION",
  /*  220 */ "WSTART",
  /*  221 */ "WEND",
  /*  222 */ "WDURATION",
  /*  223 */ "IROWTS",
  /*  224 */ "ISFILLED",
  /*  225 */ "CAST",
  /*  226 */ "NOW",
  /*  227 */ "TODAY",
  /*  228 */ "TIMEZONE",
  /*  229 */ "CLIENT_VERSION",
  /*  230 */ "SERVER_VERSION",
  /*  231 */ "SERVER_STATUS",
  /*  232 */ "CURRENT_USER",
  /*  233 */ "CASE",
  /*  234 */ "WHEN",
  /*  235 */ "THEN",
  /*  236 */ "ELSE",
  /*  237 */ "BETWEEN",
  /*  238 */ "IS",
  /*  239 */ "NK_LT",
  /*  240 */ "NK_GT",
  /*  241 */ "NK_LE",
  /*  242 */ "NK_GE",
  /*  243 */ "NK_NE",
  /*  244 */ "MATCH",
  /*  245 */ "NMATCH",
  /*  246 */ "CONTAINS",
  /*  247 */ "IN",
  /*  248 */ "JOIN",
  /*  249 */ "INNER",
  /*  250 */ "SELECT",
  /*  251 */ "DISTINCT",
  /*  252 */ "WHERE",
  /*  253 */ "PARTITION",
  /*  254 */ "BY",
  /*  255 */ "SESSION",
  /*  256 */ "STATE_WINDOW",
  /*  257 */ "EVENT_WINDOW",
  /*  258 */ "SLIDING",
  /*  259 */ "FILL",
  /*  260 */ "VALUE",
  /*  261 */ "VALUE_F",
  /*  262 */ "NONE",
  /*  263 */ "PREV",
  /*  264 */ "NULL_F",
  /*  265 */ "LINEAR",
  /*  266 */ "NEXT",
  /*  267 */ "HAVING",
  /*  268 */ "RANGE",
  /*  269 */ "EVERY",
  /*  270 */ "ORDER",
  /*  271 */ "SLIMIT",
  /*  272 */ "SOFFSET",
  /*  273 */ "LIMIT",
  /*  274 */ "OFFSET",
  /*  275 */ "ASC",
  /*  276 */ "NULLS",
  /*  277 */ "ABORT",
  /*  278 */ "AFTER",
  /*  279 */ "ATTACH",
  /*  280 */ "BEFORE",
  /*  281 */ "BEGIN",
  /*  282 */ "BITAND",
  /*  283 */ "BITNOT",
  /*  284 */ "BITOR",
  /*  285 */ "BLOCKS",
  /*  286 */ "CHANGE",
  /*  287 */ "COMMA",
  /*  288 */ "CONCAT",
  /*  289 */ "CONFLICT",
  /*  290 */ "COPY",
  /*  291 */ "DEFERRED",
  /*  292 */ "DELIMITERS",
  /*  293 */ "DETACH",
  /*  294 */ "DIVIDE",
  /*  295 */ "DOT",
  /*  296 */ "EACH",
  /*  297 */ "FAIL",
  /*  298 */ "FILE",
  /*  299 */ "FOR",
  /*  300 */ "GLOB",
  /*  301 */ "ID",
  /*  302 */ "IMMEDIATE",
  /*  303 */ "IMPORT",
  /*  304 */ "INITIALLY",
  /*  305 */ "INSTEAD",
  /*  306 */ "ISNULL",
  /*  307 */ "KEY",
  /*  308 */ "MODULES",
  /*  309 */ "NK_BITNOT",
  /*  310 */ "NK_SEMI",
  /*  311 */ "NOTNULL",
  /*  312 */ "OF",
  /*  313 */ "PLUS",
  /*  314 */ "PRIVILEGE",
  /*  315 */ "RAISE",
  /*  316 */ "REPLACE",
  /*  317 */ "RESTRICT",
  /*  318 */ "ROW",
  /*  319 */ "SEMI",
  /*  320 */ "STAR",
  /*  321 */ "STATEMENT",
  /*  322 */ "STRICT",
  /*  323 */ "STRING",
  /*  324 */ "TIMES",
  /*  325 */ "VALUES",
  /*  326 */ "VARIABLE",
  /*  327 */ "VIEW",
  /*  328 */ "WAL",
  /*  329 */ "cmd",
  /*  330 */ "account_options",
  /*  331 */ "alter_account_options",
  /*  332 */ "literal",
  /*  333 */ "alter_account_option",
  /*  334 */ "user_name",
  /*  335 */ "sysinfo_opt",
  /*  336 */ "privileges",
  /*  337 */ "priv_level",
  /*  338 */ "priv_type_list",
  /*  339 */ "priv_type",
  /*  340 */ "db_name",
  /*  341 */ "topic_name",
  /*  342 */ "dnode_endpoint",
  /*  343 */ "force_opt",
  /*  344 */ "not_exists_opt",
  /*  345 */ "db_options",
  /*  346 */ "exists_opt",
  /*  347 */ "alter_db_options",
  /*  348 */ "speed_opt",
  /*  349 */ "start_opt",
  /*  350 */ "end_opt",
  /*  351 */ "integer_list",
  /*  352 */ "variable_list",
  /*  353 */ "retention_list",
  /*  354 */ "alter_db_option",
  /*  355 */ "retention",
  /*  356 */ "full_table_name",
  /*  357 */ "column_def_list",
  /*  358 */ "tags_def_opt",
  /*  359 */ "table_options",
  /*  360 */ "multi_create_clause",
  /*  361 */ "tags_def",
  /*  362 */ "multi_drop_clause",
  /*  363 */ "alter_table_clause",
  /*  364 */ "alter_table_options",
  /*  365 */ "column_name",
  /*  366 */ "type_name",
  /*  367 */ "signed_literal",
  /*  368 */ "create_subtable_clause",
  /*  369 */ "specific_cols_opt",
  /*  370 */ "expression_list",
  /*  371 */ "drop_table_clause",
  /*  372 */ "col_name_list",
  /*  373 */ "table_name",
  /*  374 */ "column_def",
  /*  375 */ "duration_list",
  /*  376 */ "rollup_func_list",
  /*  377 */ "alter_table_option",
  /*  378 */ "duration_literal",
  /*  379 */ "rollup_func_name",
  /*  380 */ "function_name",
  /*  381 */ "col_name",
  /*  382 */ "db_name_cond_opt",
  /*  383 */ "like_pattern_opt",
  /*  384 */ "table_name_cond",
  /*  385 */ "from_db_opt",
  /*  386 */ "tag_list_opt",
  /*  387 */ "tag_item",
  /*  388 */ "column_alias",
  /*  389 */ "full_index_name",
  /*  390 */ "index_options",
  /*  391 */ "index_name",
  /*  392 */ "func_list",
  /*  393 */ "sliding_opt",
  /*  394 */ "sma_stream_opt",
  /*  395 */ "func",
  /*  396 */ "sma_func_name",
  /*  397 */ "query_or_subquery",
  /*  398 */ "cgroup_name",
  /*  399 */ "analyze_opt",
  /*  400 */ "explain_options",
  /*  401 */ "insert_query",
  /*  402 */ "agg_func_opt",
  /*  403 */ "bufsize_opt",
  /*  404 */ "language_opt",
  /*  405 */ "stream_name",
  /*  406 */ "stream_options",
  /*  407 */ "col_list_opt",
  /*  408 */ "tag_def_or_ref_opt",
  /*  409 */ "subtable_opt",
  /*  410 */ "expression",
  /*  411 */ "dnode_list",
  /*  412 */ "where_clause_opt",
  /*  413 */ "signed",
  /*  414 */ "literal_func",
  /*  415 */ "literal_list",
  /*  416 */ "table_alias",
  /*  417 */ "expr_or_subquery",
  /*  418 */ "pseudo_column",
  /*  419 */ "column_reference",
  /*  420 */ "function_expression",
  /*  421 */ "case_when_expression",
  /*  422 */ "star_func",
  /*  423 */ "star_func_para_list",
  /*  424 */ "noarg_func",
  /*  425 */ "other_para_list",
  /*  426 */ "star_func_para",
  /*  427 */ "when_then_list",
  /*  428 */ "case_when_else_opt",
  /*  429 */ "common_expression",
  /*  430 */ "when_then_expr",
  /*  431 */ "predicate",
  /*  432 */ "compare_op",
  /*  433 */ "in_op",
  /*  434 */ "in_predicate_value",
  /*  435 */ "boolean_value_expression",
  /*  436 */ "boolean_primary",
  /*  437 */ "from_clause_opt",
  /*  438 */ "table_reference_list",
  /*  439 */ "table_reference",
  /*  440 */ "table_primary",
  /*  441 */ "joined_table",
  /*  442 */ "alias_opt",
  /*  443 */ "subquery",
  /*  444 */ "parenthesized_joined_table",
  /*  445 */ "join_type",
  /*  446 */ "search_condition",
  /*  447 */ "query_specification",
  /*  448 */ "set_quantifier_opt",
  /*  449 */ "select_list",
  /*  450 */ "partition_by_clause_opt",
  /*  451 */ "range_opt",
  /*  452 */ "every_opt",
  /*  453 */ "fill_opt",
  /*  454 */ "twindow_clause_opt",
  /*  455 */ "group_by_clause_opt",
  /*  456 */ "having_clause_opt",
  /*  457 */ "select_item",
  /*  458 */ "partition_list",
  /*  459 */ "partition_item",
  /*  460 */ "fill_mode",
  /*  461 */ "group_by_list",
  /*  462 */ "query_expression",
  /*  463 */ "query_simple",
  /*  464 */ "order_by_clause_opt",
  /*  465 */ "slimit_clause_opt",
  /*  466 */ "limit_clause_opt",
  /*  467 */ "union_query_expression",
  /*  468 */ "query_simple_or_subquery",
  /*  469 */ "sort_specification_list",
  /*  470 */ "sort_specification",
  /*  471 */ "ordering_specification_opt",
  /*  472 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "cmd ::= COMPACT DATABASE db_name start_opt end_opt",
 /*  73 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  74 */ "not_exists_opt ::=",
 /*  75 */ "exists_opt ::= IF EXISTS",
 /*  76 */ "exists_opt ::=",
 /*  77 */ "db_options ::=",
 /*  78 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  79 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  80 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  81 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  83 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  84 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  86 */ "db_options ::= db_options KEEP integer_list",
 /*  87 */ "db_options ::= db_options KEEP variable_list",
 /*  88 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  89 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  91 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  92 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  93 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  94 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  95 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  96 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 107 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 108 */ "alter_db_options ::= alter_db_option",
 /* 109 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 110 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 111 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 112 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 113 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 114 */ "alter_db_option ::= KEEP integer_list",
 /* 115 */ "alter_db_option ::= KEEP variable_list",
 /* 116 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 117 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 118 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 119 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 120 */ "integer_list ::= NK_INTEGER",
 /* 121 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 122 */ "variable_list ::= NK_VARIABLE",
 /* 123 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 124 */ "retention_list ::= retention",
 /* 125 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 126 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 127 */ "speed_opt ::=",
 /* 128 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 129 */ "start_opt ::=",
 /* 130 */ "start_opt ::= START WITH NK_INTEGER",
 /* 131 */ "start_opt ::= START WITH NK_STRING",
 /* 132 */ "start_opt ::= START WITH TIMESTAMP NK_STRING",
 /* 133 */ "end_opt ::=",
 /* 134 */ "end_opt ::= END WITH NK_INTEGER",
 /* 135 */ "end_opt ::= END WITH NK_STRING",
 /* 136 */ "end_opt ::= END WITH TIMESTAMP NK_STRING",
 /* 137 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 138 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 139 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 140 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 141 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 142 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 143 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 144 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 145 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 146 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 147 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 148 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 149 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 150 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 151 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 152 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 153 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 154 */ "multi_create_clause ::= create_subtable_clause",
 /* 155 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 156 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 157 */ "multi_drop_clause ::= drop_table_clause",
 /* 158 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 159 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 160 */ "specific_cols_opt ::=",
 /* 161 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 162 */ "full_table_name ::= table_name",
 /* 163 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 164 */ "column_def_list ::= column_def",
 /* 165 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 166 */ "column_def ::= column_name type_name",
 /* 167 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 168 */ "type_name ::= BOOL",
 /* 169 */ "type_name ::= TINYINT",
 /* 170 */ "type_name ::= SMALLINT",
 /* 171 */ "type_name ::= INT",
 /* 172 */ "type_name ::= INTEGER",
 /* 173 */ "type_name ::= BIGINT",
 /* 174 */ "type_name ::= FLOAT",
 /* 175 */ "type_name ::= DOUBLE",
 /* 176 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 177 */ "type_name ::= TIMESTAMP",
 /* 178 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= TINYINT UNSIGNED",
 /* 180 */ "type_name ::= SMALLINT UNSIGNED",
 /* 181 */ "type_name ::= INT UNSIGNED",
 /* 182 */ "type_name ::= BIGINT UNSIGNED",
 /* 183 */ "type_name ::= JSON",
 /* 184 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 185 */ "type_name ::= MEDIUMBLOB",
 /* 186 */ "type_name ::= BLOB",
 /* 187 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 188 */ "type_name ::= DECIMAL",
 /* 189 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 190 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 191 */ "tags_def_opt ::=",
 /* 192 */ "tags_def_opt ::= tags_def",
 /* 193 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 194 */ "table_options ::=",
 /* 195 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 196 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 197 */ "table_options ::= table_options WATERMARK duration_list",
 /* 198 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 199 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 200 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 201 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 202 */ "alter_table_options ::= alter_table_option",
 /* 203 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 204 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 205 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 206 */ "duration_list ::= duration_literal",
 /* 207 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 208 */ "rollup_func_list ::= rollup_func_name",
 /* 209 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 210 */ "rollup_func_name ::= function_name",
 /* 211 */ "rollup_func_name ::= FIRST",
 /* 212 */ "rollup_func_name ::= LAST",
 /* 213 */ "col_name_list ::= col_name",
 /* 214 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 215 */ "col_name ::= column_name",
 /* 216 */ "cmd ::= SHOW DNODES",
 /* 217 */ "cmd ::= SHOW USERS",
 /* 218 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 219 */ "cmd ::= SHOW DATABASES",
 /* 220 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 221 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 222 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 223 */ "cmd ::= SHOW MNODES",
 /* 224 */ "cmd ::= SHOW QNODES",
 /* 225 */ "cmd ::= SHOW FUNCTIONS",
 /* 226 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 227 */ "cmd ::= SHOW STREAMS",
 /* 228 */ "cmd ::= SHOW ACCOUNTS",
 /* 229 */ "cmd ::= SHOW APPS",
 /* 230 */ "cmd ::= SHOW CONNECTIONS",
 /* 231 */ "cmd ::= SHOW LICENCES",
 /* 232 */ "cmd ::= SHOW GRANTS",
 /* 233 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 234 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 235 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 236 */ "cmd ::= SHOW QUERIES",
 /* 237 */ "cmd ::= SHOW SCORES",
 /* 238 */ "cmd ::= SHOW TOPICS",
 /* 239 */ "cmd ::= SHOW VARIABLES",
 /* 240 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 241 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 242 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 243 */ "cmd ::= SHOW BNODES",
 /* 244 */ "cmd ::= SHOW SNODES",
 /* 245 */ "cmd ::= SHOW CLUSTER",
 /* 246 */ "cmd ::= SHOW TRANSACTIONS",
 /* 247 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 248 */ "cmd ::= SHOW CONSUMERS",
 /* 249 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 250 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 251 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 252 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 253 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 254 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 255 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 256 */ "db_name_cond_opt ::=",
 /* 257 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 258 */ "like_pattern_opt ::=",
 /* 259 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 260 */ "table_name_cond ::= table_name",
 /* 261 */ "from_db_opt ::=",
 /* 262 */ "from_db_opt ::= FROM db_name",
 /* 263 */ "tag_list_opt ::=",
 /* 264 */ "tag_list_opt ::= tag_item",
 /* 265 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 266 */ "tag_item ::= TBNAME",
 /* 267 */ "tag_item ::= QTAGS",
 /* 268 */ "tag_item ::= column_name",
 /* 269 */ "tag_item ::= column_name column_alias",
 /* 270 */ "tag_item ::= column_name AS column_alias",
 /* 271 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 272 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 273 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 274 */ "full_index_name ::= index_name",
 /* 275 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 276 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 277 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 278 */ "func_list ::= func",
 /* 279 */ "func_list ::= func_list NK_COMMA func",
 /* 280 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 281 */ "sma_func_name ::= function_name",
 /* 282 */ "sma_func_name ::= COUNT",
 /* 283 */ "sma_func_name ::= FIRST",
 /* 284 */ "sma_func_name ::= LAST",
 /* 285 */ "sma_func_name ::= LAST_ROW",
 /* 286 */ "sma_stream_opt ::=",
 /* 287 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 288 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 289 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 290 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 291 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 292 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 293 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 294 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 295 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 296 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 297 */ "cmd ::= DESC full_table_name",
 /* 298 */ "cmd ::= DESCRIBE full_table_name",
 /* 299 */ "cmd ::= RESET QUERY CACHE",
 /* 300 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 301 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 302 */ "analyze_opt ::=",
 /* 303 */ "analyze_opt ::= ANALYZE",
 /* 304 */ "explain_options ::=",
 /* 305 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 306 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 307 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt",
 /* 308 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 309 */ "agg_func_opt ::=",
 /* 310 */ "agg_func_opt ::= AGGREGATE",
 /* 311 */ "bufsize_opt ::=",
 /* 312 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 313 */ "language_opt ::=",
 /* 314 */ "language_opt ::= LANGUAGE NK_STRING",
 /* 315 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 316 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 317 */ "col_list_opt ::=",
 /* 318 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 319 */ "tag_def_or_ref_opt ::=",
 /* 320 */ "tag_def_or_ref_opt ::= tags_def",
 /* 321 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 322 */ "stream_options ::=",
 /* 323 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 324 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 325 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 326 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 327 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 328 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 329 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 330 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 331 */ "subtable_opt ::=",
 /* 332 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 333 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 334 */ "cmd ::= KILL QUERY NK_STRING",
 /* 335 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 336 */ "cmd ::= BALANCE VGROUP",
 /* 337 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 338 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 339 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 340 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 341 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 342 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 343 */ "cmd ::= query_or_subquery",
 /* 344 */ "cmd ::= insert_query",
 /* 345 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 346 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 347 */ "literal ::= NK_INTEGER",
 /* 348 */ "literal ::= NK_FLOAT",
 /* 349 */ "literal ::= NK_STRING",
 /* 350 */ "literal ::= NK_BOOL",
 /* 351 */ "literal ::= TIMESTAMP NK_STRING",
 /* 352 */ "literal ::= duration_literal",
 /* 353 */ "literal ::= NULL",
 /* 354 */ "literal ::= NK_QUESTION",
 /* 355 */ "duration_literal ::= NK_VARIABLE",
 /* 356 */ "signed ::= NK_INTEGER",
 /* 357 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 358 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 359 */ "signed ::= NK_FLOAT",
 /* 360 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 361 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 362 */ "signed_literal ::= signed",
 /* 363 */ "signed_literal ::= NK_STRING",
 /* 364 */ "signed_literal ::= NK_BOOL",
 /* 365 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 366 */ "signed_literal ::= duration_literal",
 /* 367 */ "signed_literal ::= NULL",
 /* 368 */ "signed_literal ::= literal_func",
 /* 369 */ "signed_literal ::= NK_QUESTION",
 /* 370 */ "literal_list ::= signed_literal",
 /* 371 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 372 */ "db_name ::= NK_ID",
 /* 373 */ "table_name ::= NK_ID",
 /* 374 */ "column_name ::= NK_ID",
 /* 375 */ "function_name ::= NK_ID",
 /* 376 */ "table_alias ::= NK_ID",
 /* 377 */ "column_alias ::= NK_ID",
 /* 378 */ "user_name ::= NK_ID",
 /* 379 */ "topic_name ::= NK_ID",
 /* 380 */ "stream_name ::= NK_ID",
 /* 381 */ "cgroup_name ::= NK_ID",
 /* 382 */ "index_name ::= NK_ID",
 /* 383 */ "expr_or_subquery ::= expression",
 /* 384 */ "expression ::= literal",
 /* 385 */ "expression ::= pseudo_column",
 /* 386 */ "expression ::= column_reference",
 /* 387 */ "expression ::= function_expression",
 /* 388 */ "expression ::= case_when_expression",
 /* 389 */ "expression ::= NK_LP expression NK_RP",
 /* 390 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 391 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 392 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 393 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 394 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 395 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 396 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 397 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 398 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 399 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 400 */ "expression_list ::= expr_or_subquery",
 /* 401 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 402 */ "column_reference ::= column_name",
 /* 403 */ "column_reference ::= table_name NK_DOT column_name",
 /* 404 */ "pseudo_column ::= ROWTS",
 /* 405 */ "pseudo_column ::= TBNAME",
 /* 406 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 407 */ "pseudo_column ::= QSTART",
 /* 408 */ "pseudo_column ::= QEND",
 /* 409 */ "pseudo_column ::= QDURATION",
 /* 410 */ "pseudo_column ::= WSTART",
 /* 411 */ "pseudo_column ::= WEND",
 /* 412 */ "pseudo_column ::= WDURATION",
 /* 413 */ "pseudo_column ::= IROWTS",
 /* 414 */ "pseudo_column ::= ISFILLED",
 /* 415 */ "pseudo_column ::= QTAGS",
 /* 416 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 417 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 418 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 419 */ "function_expression ::= literal_func",
 /* 420 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 421 */ "literal_func ::= NOW",
 /* 422 */ "noarg_func ::= NOW",
 /* 423 */ "noarg_func ::= TODAY",
 /* 424 */ "noarg_func ::= TIMEZONE",
 /* 425 */ "noarg_func ::= DATABASE",
 /* 426 */ "noarg_func ::= CLIENT_VERSION",
 /* 427 */ "noarg_func ::= SERVER_VERSION",
 /* 428 */ "noarg_func ::= SERVER_STATUS",
 /* 429 */ "noarg_func ::= CURRENT_USER",
 /* 430 */ "noarg_func ::= USER",
 /* 431 */ "star_func ::= COUNT",
 /* 432 */ "star_func ::= FIRST",
 /* 433 */ "star_func ::= LAST",
 /* 434 */ "star_func ::= LAST_ROW",
 /* 435 */ "star_func_para_list ::= NK_STAR",
 /* 436 */ "star_func_para_list ::= other_para_list",
 /* 437 */ "other_para_list ::= star_func_para",
 /* 438 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 439 */ "star_func_para ::= expr_or_subquery",
 /* 440 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 441 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 442 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 443 */ "when_then_list ::= when_then_expr",
 /* 444 */ "when_then_list ::= when_then_list when_then_expr",
 /* 445 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 446 */ "case_when_else_opt ::=",
 /* 447 */ "case_when_else_opt ::= ELSE common_expression",
 /* 448 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 449 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 450 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 451 */ "predicate ::= expr_or_subquery IS NULL",
 /* 452 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 453 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 454 */ "compare_op ::= NK_LT",
 /* 455 */ "compare_op ::= NK_GT",
 /* 456 */ "compare_op ::= NK_LE",
 /* 457 */ "compare_op ::= NK_GE",
 /* 458 */ "compare_op ::= NK_NE",
 /* 459 */ "compare_op ::= NK_EQ",
 /* 460 */ "compare_op ::= LIKE",
 /* 461 */ "compare_op ::= NOT LIKE",
 /* 462 */ "compare_op ::= MATCH",
 /* 463 */ "compare_op ::= NMATCH",
 /* 464 */ "compare_op ::= CONTAINS",
 /* 465 */ "in_op ::= IN",
 /* 466 */ "in_op ::= NOT IN",
 /* 467 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 468 */ "boolean_value_expression ::= boolean_primary",
 /* 469 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 470 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 471 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 472 */ "boolean_primary ::= predicate",
 /* 473 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 474 */ "common_expression ::= expr_or_subquery",
 /* 475 */ "common_expression ::= boolean_value_expression",
 /* 476 */ "from_clause_opt ::=",
 /* 477 */ "from_clause_opt ::= FROM table_reference_list",
 /* 478 */ "table_reference_list ::= table_reference",
 /* 479 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 480 */ "table_reference ::= table_primary",
 /* 481 */ "table_reference ::= joined_table",
 /* 482 */ "table_primary ::= table_name alias_opt",
 /* 483 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 484 */ "table_primary ::= subquery alias_opt",
 /* 485 */ "table_primary ::= parenthesized_joined_table",
 /* 486 */ "alias_opt ::=",
 /* 487 */ "alias_opt ::= table_alias",
 /* 488 */ "alias_opt ::= AS table_alias",
 /* 489 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 490 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 491 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 492 */ "join_type ::=",
 /* 493 */ "join_type ::= INNER",
 /* 494 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 495 */ "set_quantifier_opt ::=",
 /* 496 */ "set_quantifier_opt ::= DISTINCT",
 /* 497 */ "set_quantifier_opt ::= ALL",
 /* 498 */ "select_list ::= select_item",
 /* 499 */ "select_list ::= select_list NK_COMMA select_item",
 /* 500 */ "select_item ::= NK_STAR",
 /* 501 */ "select_item ::= common_expression",
 /* 502 */ "select_item ::= common_expression column_alias",
 /* 503 */ "select_item ::= common_expression AS column_alias",
 /* 504 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 505 */ "where_clause_opt ::=",
 /* 506 */ "where_clause_opt ::= WHERE search_condition",
 /* 507 */ "partition_by_clause_opt ::=",
 /* 508 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 509 */ "partition_list ::= partition_item",
 /* 510 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 511 */ "partition_item ::= expr_or_subquery",
 /* 512 */ "partition_item ::= expr_or_subquery column_alias",
 /* 513 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 514 */ "twindow_clause_opt ::=",
 /* 515 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 516 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 517 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 518 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 519 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 520 */ "sliding_opt ::=",
 /* 521 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 522 */ "fill_opt ::=",
 /* 523 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 524 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 525 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP",
 /* 526 */ "fill_mode ::= NONE",
 /* 527 */ "fill_mode ::= PREV",
 /* 528 */ "fill_mode ::= NULL",
 /* 529 */ "fill_mode ::= NULL_F",
 /* 530 */ "fill_mode ::= LINEAR",
 /* 531 */ "fill_mode ::= NEXT",
 /* 532 */ "group_by_clause_opt ::=",
 /* 533 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 534 */ "group_by_list ::= expr_or_subquery",
 /* 535 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 536 */ "having_clause_opt ::=",
 /* 537 */ "having_clause_opt ::= HAVING search_condition",
 /* 538 */ "range_opt ::=",
 /* 539 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 540 */ "every_opt ::=",
 /* 541 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 542 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 543 */ "query_simple ::= query_specification",
 /* 544 */ "query_simple ::= union_query_expression",
 /* 545 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 546 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 547 */ "query_simple_or_subquery ::= query_simple",
 /* 548 */ "query_simple_or_subquery ::= subquery",
 /* 549 */ "query_or_subquery ::= query_expression",
 /* 550 */ "query_or_subquery ::= subquery",
 /* 551 */ "order_by_clause_opt ::=",
 /* 552 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 553 */ "slimit_clause_opt ::=",
 /* 554 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 555 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 556 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 557 */ "limit_clause_opt ::=",
 /* 558 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 559 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 560 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 561 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 562 */ "subquery ::= NK_LP subquery NK_RP",
 /* 563 */ "search_condition ::= common_expression",
 /* 564 */ "sort_specification_list ::= sort_specification",
 /* 565 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 566 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 567 */ "ordering_specification_opt ::=",
 /* 568 */ "ordering_specification_opt ::= ASC",
 /* 569 */ "ordering_specification_opt ::= DESC",
 /* 570 */ "null_ordering_opt ::=",
 /* 571 */ "null_ordering_opt ::= NULLS FIRST",
 /* 572 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 329: /* cmd */
    case 332: /* literal */
    case 345: /* db_options */
    case 347: /* alter_db_options */
    case 349: /* start_opt */
    case 350: /* end_opt */
    case 355: /* retention */
    case 356: /* full_table_name */
    case 359: /* table_options */
    case 363: /* alter_table_clause */
    case 364: /* alter_table_options */
    case 367: /* signed_literal */
    case 368: /* create_subtable_clause */
    case 371: /* drop_table_clause */
    case 374: /* column_def */
    case 378: /* duration_literal */
    case 379: /* rollup_func_name */
    case 381: /* col_name */
    case 382: /* db_name_cond_opt */
    case 383: /* like_pattern_opt */
    case 384: /* table_name_cond */
    case 385: /* from_db_opt */
    case 387: /* tag_item */
    case 389: /* full_index_name */
    case 390: /* index_options */
    case 393: /* sliding_opt */
    case 394: /* sma_stream_opt */
    case 395: /* func */
    case 397: /* query_or_subquery */
    case 400: /* explain_options */
    case 401: /* insert_query */
    case 406: /* stream_options */
    case 409: /* subtable_opt */
    case 410: /* expression */
    case 412: /* where_clause_opt */
    case 413: /* signed */
    case 414: /* literal_func */
    case 417: /* expr_or_subquery */
    case 418: /* pseudo_column */
    case 419: /* column_reference */
    case 420: /* function_expression */
    case 421: /* case_when_expression */
    case 426: /* star_func_para */
    case 428: /* case_when_else_opt */
    case 429: /* common_expression */
    case 430: /* when_then_expr */
    case 431: /* predicate */
    case 434: /* in_predicate_value */
    case 435: /* boolean_value_expression */
    case 436: /* boolean_primary */
    case 437: /* from_clause_opt */
    case 438: /* table_reference_list */
    case 439: /* table_reference */
    case 440: /* table_primary */
    case 441: /* joined_table */
    case 443: /* subquery */
    case 444: /* parenthesized_joined_table */
    case 446: /* search_condition */
    case 447: /* query_specification */
    case 451: /* range_opt */
    case 452: /* every_opt */
    case 453: /* fill_opt */
    case 454: /* twindow_clause_opt */
    case 456: /* having_clause_opt */
    case 457: /* select_item */
    case 459: /* partition_item */
    case 462: /* query_expression */
    case 463: /* query_simple */
    case 465: /* slimit_clause_opt */
    case 466: /* limit_clause_opt */
    case 467: /* union_query_expression */
    case 468: /* query_simple_or_subquery */
    case 470: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy828)); 
}
      break;
    case 330: /* account_options */
    case 331: /* alter_account_options */
    case 333: /* alter_account_option */
    case 348: /* speed_opt */
    case 403: /* bufsize_opt */
{
 
}
      break;
    case 334: /* user_name */
    case 337: /* priv_level */
    case 340: /* db_name */
    case 341: /* topic_name */
    case 342: /* dnode_endpoint */
    case 365: /* column_name */
    case 373: /* table_name */
    case 380: /* function_name */
    case 388: /* column_alias */
    case 391: /* index_name */
    case 396: /* sma_func_name */
    case 398: /* cgroup_name */
    case 404: /* language_opt */
    case 405: /* stream_name */
    case 416: /* table_alias */
    case 422: /* star_func */
    case 424: /* noarg_func */
    case 442: /* alias_opt */
{
 
}
      break;
    case 335: /* sysinfo_opt */
{
 
}
      break;
    case 336: /* privileges */
    case 338: /* priv_type_list */
    case 339: /* priv_type */
{
 
}
      break;
    case 343: /* force_opt */
    case 344: /* not_exists_opt */
    case 346: /* exists_opt */
    case 399: /* analyze_opt */
    case 402: /* agg_func_opt */
    case 448: /* set_quantifier_opt */
{
 
}
      break;
    case 351: /* integer_list */
    case 352: /* variable_list */
    case 353: /* retention_list */
    case 357: /* column_def_list */
    case 358: /* tags_def_opt */
    case 360: /* multi_create_clause */
    case 361: /* tags_def */
    case 362: /* multi_drop_clause */
    case 369: /* specific_cols_opt */
    case 370: /* expression_list */
    case 372: /* col_name_list */
    case 375: /* duration_list */
    case 376: /* rollup_func_list */
    case 386: /* tag_list_opt */
    case 392: /* func_list */
    case 407: /* col_list_opt */
    case 408: /* tag_def_or_ref_opt */
    case 411: /* dnode_list */
    case 415: /* literal_list */
    case 423: /* star_func_para_list */
    case 425: /* other_para_list */
    case 427: /* when_then_list */
    case 449: /* select_list */
    case 450: /* partition_by_clause_opt */
    case 455: /* group_by_clause_opt */
    case 458: /* partition_list */
    case 461: /* group_by_list */
    case 464: /* order_by_clause_opt */
    case 469: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy222)); 
}
      break;
    case 354: /* alter_db_option */
    case 377: /* alter_table_option */
{
 
}
      break;
    case 366: /* type_name */
{
 
}
      break;
    case 432: /* compare_op */
    case 433: /* in_op */
{
 
}
      break;
    case 445: /* join_type */
{
 
}
      break;
    case 460: /* fill_mode */
{
 
}
      break;
    case 471: /* ordering_specification_opt */
{
 
}
      break;
    case 472: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  329,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  329,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  330,    0 }, /* (2) account_options ::= */
  {  330,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  330,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  330,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  330,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  330,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  330,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  330,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  330,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  330,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  331,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  331,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  333,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  333,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  333,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  333,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  333,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  333,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  333,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  333,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  333,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  333,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  329,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  329,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  329,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  329,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  329,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  335,    0 }, /* (29) sysinfo_opt ::= */
  {  335,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  329,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  329,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  336,   -1 }, /* (33) privileges ::= ALL */
  {  336,   -1 }, /* (34) privileges ::= priv_type_list */
  {  336,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  338,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  338,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  339,   -1 }, /* (38) priv_type ::= READ */
  {  339,   -1 }, /* (39) priv_type ::= WRITE */
  {  337,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  337,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  337,   -1 }, /* (42) priv_level ::= topic_name */
  {  329,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  329,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  329,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  329,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  329,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  329,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  329,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  329,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  342,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  342,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  342,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  343,    0 }, /* (54) force_opt ::= */
  {  343,   -1 }, /* (55) force_opt ::= FORCE */
  {  329,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  329,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  329,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  329,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  329,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  329,   -2 }, /* (68) cmd ::= USE db_name */
  {  329,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  329,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  329,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  329,   -5 }, /* (72) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
  {  344,   -3 }, /* (73) not_exists_opt ::= IF NOT EXISTS */
  {  344,    0 }, /* (74) not_exists_opt ::= */
  {  346,   -2 }, /* (75) exists_opt ::= IF EXISTS */
  {  346,    0 }, /* (76) exists_opt ::= */
  {  345,    0 }, /* (77) db_options ::= */
  {  345,   -3 }, /* (78) db_options ::= db_options BUFFER NK_INTEGER */
  {  345,   -3 }, /* (79) db_options ::= db_options CACHEMODEL NK_STRING */
  {  345,   -3 }, /* (80) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  345,   -3 }, /* (81) db_options ::= db_options COMP NK_INTEGER */
  {  345,   -3 }, /* (82) db_options ::= db_options DURATION NK_INTEGER */
  {  345,   -3 }, /* (83) db_options ::= db_options DURATION NK_VARIABLE */
  {  345,   -3 }, /* (84) db_options ::= db_options MAXROWS NK_INTEGER */
  {  345,   -3 }, /* (85) db_options ::= db_options MINROWS NK_INTEGER */
  {  345,   -3 }, /* (86) db_options ::= db_options KEEP integer_list */
  {  345,   -3 }, /* (87) db_options ::= db_options KEEP variable_list */
  {  345,   -3 }, /* (88) db_options ::= db_options PAGES NK_INTEGER */
  {  345,   -3 }, /* (89) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  345,   -3 }, /* (90) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  345,   -3 }, /* (91) db_options ::= db_options PRECISION NK_STRING */
  {  345,   -3 }, /* (92) db_options ::= db_options REPLICA NK_INTEGER */
  {  345,   -3 }, /* (93) db_options ::= db_options VGROUPS NK_INTEGER */
  {  345,   -3 }, /* (94) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  345,   -3 }, /* (95) db_options ::= db_options RETENTIONS retention_list */
  {  345,   -3 }, /* (96) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  345,   -3 }, /* (97) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  345,   -3 }, /* (98) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  345,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  345,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  345,   -3 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  345,   -4 }, /* (102) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  345,   -3 }, /* (103) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  345,   -3 }, /* (104) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  345,   -3 }, /* (105) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  345,   -3 }, /* (106) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  345,   -3 }, /* (107) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  347,   -1 }, /* (108) alter_db_options ::= alter_db_option */
  {  347,   -2 }, /* (109) alter_db_options ::= alter_db_options alter_db_option */
  {  354,   -2 }, /* (110) alter_db_option ::= BUFFER NK_INTEGER */
  {  354,   -2 }, /* (111) alter_db_option ::= CACHEMODEL NK_STRING */
  {  354,   -2 }, /* (112) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  354,   -2 }, /* (113) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  354,   -2 }, /* (114) alter_db_option ::= KEEP integer_list */
  {  354,   -2 }, /* (115) alter_db_option ::= KEEP variable_list */
  {  354,   -2 }, /* (116) alter_db_option ::= PAGES NK_INTEGER */
  {  354,   -2 }, /* (117) alter_db_option ::= REPLICA NK_INTEGER */
  {  354,   -2 }, /* (118) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  354,   -2 }, /* (119) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  351,   -1 }, /* (120) integer_list ::= NK_INTEGER */
  {  351,   -3 }, /* (121) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  352,   -1 }, /* (122) variable_list ::= NK_VARIABLE */
  {  352,   -3 }, /* (123) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  353,   -1 }, /* (124) retention_list ::= retention */
  {  353,   -3 }, /* (125) retention_list ::= retention_list NK_COMMA retention */
  {  355,   -3 }, /* (126) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  348,    0 }, /* (127) speed_opt ::= */
  {  348,   -2 }, /* (128) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  349,    0 }, /* (129) start_opt ::= */
  {  349,   -3 }, /* (130) start_opt ::= START WITH NK_INTEGER */
  {  349,   -3 }, /* (131) start_opt ::= START WITH NK_STRING */
  {  349,   -4 }, /* (132) start_opt ::= START WITH TIMESTAMP NK_STRING */
  {  350,    0 }, /* (133) end_opt ::= */
  {  350,   -3 }, /* (134) end_opt ::= END WITH NK_INTEGER */
  {  350,   -3 }, /* (135) end_opt ::= END WITH NK_STRING */
  {  350,   -4 }, /* (136) end_opt ::= END WITH TIMESTAMP NK_STRING */
  {  329,   -9 }, /* (137) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  329,   -3 }, /* (138) cmd ::= CREATE TABLE multi_create_clause */
  {  329,   -9 }, /* (139) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  329,   -3 }, /* (140) cmd ::= DROP TABLE multi_drop_clause */
  {  329,   -4 }, /* (141) cmd ::= DROP STABLE exists_opt full_table_name */
  {  329,   -3 }, /* (142) cmd ::= ALTER TABLE alter_table_clause */
  {  329,   -3 }, /* (143) cmd ::= ALTER STABLE alter_table_clause */
  {  363,   -2 }, /* (144) alter_table_clause ::= full_table_name alter_table_options */
  {  363,   -5 }, /* (145) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  363,   -4 }, /* (146) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  363,   -5 }, /* (147) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  363,   -5 }, /* (148) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  363,   -5 }, /* (149) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  363,   -4 }, /* (150) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  363,   -5 }, /* (151) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  363,   -5 }, /* (152) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  363,   -6 }, /* (153) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  360,   -1 }, /* (154) multi_create_clause ::= create_subtable_clause */
  {  360,   -2 }, /* (155) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  368,  -10 }, /* (156) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  362,   -1 }, /* (157) multi_drop_clause ::= drop_table_clause */
  {  362,   -3 }, /* (158) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
  {  371,   -2 }, /* (159) drop_table_clause ::= exists_opt full_table_name */
  {  369,    0 }, /* (160) specific_cols_opt ::= */
  {  369,   -3 }, /* (161) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  356,   -1 }, /* (162) full_table_name ::= table_name */
  {  356,   -3 }, /* (163) full_table_name ::= db_name NK_DOT table_name */
  {  357,   -1 }, /* (164) column_def_list ::= column_def */
  {  357,   -3 }, /* (165) column_def_list ::= column_def_list NK_COMMA column_def */
  {  374,   -2 }, /* (166) column_def ::= column_name type_name */
  {  374,   -4 }, /* (167) column_def ::= column_name type_name COMMENT NK_STRING */
  {  366,   -1 }, /* (168) type_name ::= BOOL */
  {  366,   -1 }, /* (169) type_name ::= TINYINT */
  {  366,   -1 }, /* (170) type_name ::= SMALLINT */
  {  366,   -1 }, /* (171) type_name ::= INT */
  {  366,   -1 }, /* (172) type_name ::= INTEGER */
  {  366,   -1 }, /* (173) type_name ::= BIGINT */
  {  366,   -1 }, /* (174) type_name ::= FLOAT */
  {  366,   -1 }, /* (175) type_name ::= DOUBLE */
  {  366,   -4 }, /* (176) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  366,   -1 }, /* (177) type_name ::= TIMESTAMP */
  {  366,   -4 }, /* (178) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  366,   -2 }, /* (179) type_name ::= TINYINT UNSIGNED */
  {  366,   -2 }, /* (180) type_name ::= SMALLINT UNSIGNED */
  {  366,   -2 }, /* (181) type_name ::= INT UNSIGNED */
  {  366,   -2 }, /* (182) type_name ::= BIGINT UNSIGNED */
  {  366,   -1 }, /* (183) type_name ::= JSON */
  {  366,   -4 }, /* (184) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  366,   -1 }, /* (185) type_name ::= MEDIUMBLOB */
  {  366,   -1 }, /* (186) type_name ::= BLOB */
  {  366,   -4 }, /* (187) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  366,   -1 }, /* (188) type_name ::= DECIMAL */
  {  366,   -4 }, /* (189) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  366,   -6 }, /* (190) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  358,    0 }, /* (191) tags_def_opt ::= */
  {  358,   -1 }, /* (192) tags_def_opt ::= tags_def */
  {  361,   -4 }, /* (193) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  359,    0 }, /* (194) table_options ::= */
  {  359,   -3 }, /* (195) table_options ::= table_options COMMENT NK_STRING */
  {  359,   -3 }, /* (196) table_options ::= table_options MAX_DELAY duration_list */
  {  359,   -3 }, /* (197) table_options ::= table_options WATERMARK duration_list */
  {  359,   -5 }, /* (198) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  359,   -3 }, /* (199) table_options ::= table_options TTL NK_INTEGER */
  {  359,   -5 }, /* (200) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  359,   -3 }, /* (201) table_options ::= table_options DELETE_MARK duration_list */
  {  364,   -1 }, /* (202) alter_table_options ::= alter_table_option */
  {  364,   -2 }, /* (203) alter_table_options ::= alter_table_options alter_table_option */
  {  377,   -2 }, /* (204) alter_table_option ::= COMMENT NK_STRING */
  {  377,   -2 }, /* (205) alter_table_option ::= TTL NK_INTEGER */
  {  375,   -1 }, /* (206) duration_list ::= duration_literal */
  {  375,   -3 }, /* (207) duration_list ::= duration_list NK_COMMA duration_literal */
  {  376,   -1 }, /* (208) rollup_func_list ::= rollup_func_name */
  {  376,   -3 }, /* (209) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  379,   -1 }, /* (210) rollup_func_name ::= function_name */
  {  379,   -1 }, /* (211) rollup_func_name ::= FIRST */
  {  379,   -1 }, /* (212) rollup_func_name ::= LAST */
  {  372,   -1 }, /* (213) col_name_list ::= col_name */
  {  372,   -3 }, /* (214) col_name_list ::= col_name_list NK_COMMA col_name */
  {  381,   -1 }, /* (215) col_name ::= column_name */
  {  329,   -2 }, /* (216) cmd ::= SHOW DNODES */
  {  329,   -2 }, /* (217) cmd ::= SHOW USERS */
  {  329,   -3 }, /* (218) cmd ::= SHOW USER PRIVILEGES */
  {  329,   -2 }, /* (219) cmd ::= SHOW DATABASES */
  {  329,   -4 }, /* (220) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  329,   -4 }, /* (221) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  329,   -3 }, /* (222) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  329,   -2 }, /* (223) cmd ::= SHOW MNODES */
  {  329,   -2 }, /* (224) cmd ::= SHOW QNODES */
  {  329,   -2 }, /* (225) cmd ::= SHOW FUNCTIONS */
  {  329,   -5 }, /* (226) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  329,   -2 }, /* (227) cmd ::= SHOW STREAMS */
  {  329,   -2 }, /* (228) cmd ::= SHOW ACCOUNTS */
  {  329,   -2 }, /* (229) cmd ::= SHOW APPS */
  {  329,   -2 }, /* (230) cmd ::= SHOW CONNECTIONS */
  {  329,   -2 }, /* (231) cmd ::= SHOW LICENCES */
  {  329,   -2 }, /* (232) cmd ::= SHOW GRANTS */
  {  329,   -4 }, /* (233) cmd ::= SHOW CREATE DATABASE db_name */
  {  329,   -4 }, /* (234) cmd ::= SHOW CREATE TABLE full_table_name */
  {  329,   -4 }, /* (235) cmd ::= SHOW CREATE STABLE full_table_name */
  {  329,   -2 }, /* (236) cmd ::= SHOW QUERIES */
  {  329,   -2 }, /* (237) cmd ::= SHOW SCORES */
  {  329,   -2 }, /* (238) cmd ::= SHOW TOPICS */
  {  329,   -2 }, /* (239) cmd ::= SHOW VARIABLES */
  {  329,   -3 }, /* (240) cmd ::= SHOW CLUSTER VARIABLES */
  {  329,   -3 }, /* (241) cmd ::= SHOW LOCAL VARIABLES */
  {  329,   -5 }, /* (242) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  329,   -2 }, /* (243) cmd ::= SHOW BNODES */
  {  329,   -2 }, /* (244) cmd ::= SHOW SNODES */
  {  329,   -2 }, /* (245) cmd ::= SHOW CLUSTER */
  {  329,   -2 }, /* (246) cmd ::= SHOW TRANSACTIONS */
  {  329,   -4 }, /* (247) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  329,   -2 }, /* (248) cmd ::= SHOW CONSUMERS */
  {  329,   -2 }, /* (249) cmd ::= SHOW SUBSCRIPTIONS */
  {  329,   -5 }, /* (250) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  329,   -7 }, /* (251) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  329,   -3 }, /* (252) cmd ::= SHOW VNODES NK_INTEGER */
  {  329,   -3 }, /* (253) cmd ::= SHOW VNODES NK_STRING */
  {  329,   -3 }, /* (254) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  329,   -3 }, /* (255) cmd ::= SHOW CLUSTER ALIVE */
  {  382,    0 }, /* (256) db_name_cond_opt ::= */
  {  382,   -2 }, /* (257) db_name_cond_opt ::= db_name NK_DOT */
  {  383,    0 }, /* (258) like_pattern_opt ::= */
  {  383,   -2 }, /* (259) like_pattern_opt ::= LIKE NK_STRING */
  {  384,   -1 }, /* (260) table_name_cond ::= table_name */
  {  385,    0 }, /* (261) from_db_opt ::= */
  {  385,   -2 }, /* (262) from_db_opt ::= FROM db_name */
  {  386,    0 }, /* (263) tag_list_opt ::= */
  {  386,   -1 }, /* (264) tag_list_opt ::= tag_item */
  {  386,   -3 }, /* (265) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  387,   -1 }, /* (266) tag_item ::= TBNAME */
  {  387,   -1 }, /* (267) tag_item ::= QTAGS */
  {  387,   -1 }, /* (268) tag_item ::= column_name */
  {  387,   -2 }, /* (269) tag_item ::= column_name column_alias */
  {  387,   -3 }, /* (270) tag_item ::= column_name AS column_alias */
  {  329,   -8 }, /* (271) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  329,   -9 }, /* (272) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  329,   -4 }, /* (273) cmd ::= DROP INDEX exists_opt full_index_name */
  {  389,   -1 }, /* (274) full_index_name ::= index_name */
  {  389,   -3 }, /* (275) full_index_name ::= db_name NK_DOT index_name */
  {  390,  -10 }, /* (276) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  390,  -12 }, /* (277) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  392,   -1 }, /* (278) func_list ::= func */
  {  392,   -3 }, /* (279) func_list ::= func_list NK_COMMA func */
  {  395,   -4 }, /* (280) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  396,   -1 }, /* (281) sma_func_name ::= function_name */
  {  396,   -1 }, /* (282) sma_func_name ::= COUNT */
  {  396,   -1 }, /* (283) sma_func_name ::= FIRST */
  {  396,   -1 }, /* (284) sma_func_name ::= LAST */
  {  396,   -1 }, /* (285) sma_func_name ::= LAST_ROW */
  {  394,    0 }, /* (286) sma_stream_opt ::= */
  {  394,   -3 }, /* (287) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  394,   -3 }, /* (288) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  394,   -3 }, /* (289) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  329,   -6 }, /* (290) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  329,   -7 }, /* (291) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  329,   -9 }, /* (292) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  329,   -7 }, /* (293) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  329,   -9 }, /* (294) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  329,   -4 }, /* (295) cmd ::= DROP TOPIC exists_opt topic_name */
  {  329,   -7 }, /* (296) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  329,   -2 }, /* (297) cmd ::= DESC full_table_name */
  {  329,   -2 }, /* (298) cmd ::= DESCRIBE full_table_name */
  {  329,   -3 }, /* (299) cmd ::= RESET QUERY CACHE */
  {  329,   -4 }, /* (300) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  329,   -4 }, /* (301) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
  {  399,    0 }, /* (302) analyze_opt ::= */
  {  399,   -1 }, /* (303) analyze_opt ::= ANALYZE */
  {  400,    0 }, /* (304) explain_options ::= */
  {  400,   -3 }, /* (305) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  400,   -3 }, /* (306) explain_options ::= explain_options RATIO NK_FLOAT */
  {  329,  -11 }, /* (307) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
  {  329,   -4 }, /* (308) cmd ::= DROP FUNCTION exists_opt function_name */
  {  402,    0 }, /* (309) agg_func_opt ::= */
  {  402,   -1 }, /* (310) agg_func_opt ::= AGGREGATE */
  {  403,    0 }, /* (311) bufsize_opt ::= */
  {  403,   -2 }, /* (312) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  404,    0 }, /* (313) language_opt ::= */
  {  404,   -2 }, /* (314) language_opt ::= LANGUAGE NK_STRING */
  {  329,  -12 }, /* (315) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
  {  329,   -4 }, /* (316) cmd ::= DROP STREAM exists_opt stream_name */
  {  407,    0 }, /* (317) col_list_opt ::= */
  {  407,   -3 }, /* (318) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  408,    0 }, /* (319) tag_def_or_ref_opt ::= */
  {  408,   -1 }, /* (320) tag_def_or_ref_opt ::= tags_def */
  {  408,   -4 }, /* (321) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
  {  406,    0 }, /* (322) stream_options ::= */
  {  406,   -3 }, /* (323) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  406,   -3 }, /* (324) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  406,   -4 }, /* (325) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  406,   -3 }, /* (326) stream_options ::= stream_options WATERMARK duration_literal */
  {  406,   -4 }, /* (327) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  406,   -3 }, /* (328) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  406,   -3 }, /* (329) stream_options ::= stream_options DELETE_MARK duration_literal */
  {  406,   -4 }, /* (330) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
  {  409,    0 }, /* (331) subtable_opt ::= */
  {  409,   -4 }, /* (332) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  329,   -3 }, /* (333) cmd ::= KILL CONNECTION NK_INTEGER */
  {  329,   -3 }, /* (334) cmd ::= KILL QUERY NK_STRING */
  {  329,   -3 }, /* (335) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  329,   -2 }, /* (336) cmd ::= BALANCE VGROUP */
  {  329,   -4 }, /* (337) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  329,   -4 }, /* (338) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  329,   -3 }, /* (339) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  411,   -2 }, /* (340) dnode_list ::= DNODE NK_INTEGER */
  {  411,   -3 }, /* (341) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  329,   -4 }, /* (342) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  329,   -1 }, /* (343) cmd ::= query_or_subquery */
  {  329,   -1 }, /* (344) cmd ::= insert_query */
  {  401,   -7 }, /* (345) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  401,   -4 }, /* (346) insert_query ::= INSERT INTO full_table_name query_or_subquery */
  {  332,   -1 }, /* (347) literal ::= NK_INTEGER */
  {  332,   -1 }, /* (348) literal ::= NK_FLOAT */
  {  332,   -1 }, /* (349) literal ::= NK_STRING */
  {  332,   -1 }, /* (350) literal ::= NK_BOOL */
  {  332,   -2 }, /* (351) literal ::= TIMESTAMP NK_STRING */
  {  332,   -1 }, /* (352) literal ::= duration_literal */
  {  332,   -1 }, /* (353) literal ::= NULL */
  {  332,   -1 }, /* (354) literal ::= NK_QUESTION */
  {  378,   -1 }, /* (355) duration_literal ::= NK_VARIABLE */
  {  413,   -1 }, /* (356) signed ::= NK_INTEGER */
  {  413,   -2 }, /* (357) signed ::= NK_PLUS NK_INTEGER */
  {  413,   -2 }, /* (358) signed ::= NK_MINUS NK_INTEGER */
  {  413,   -1 }, /* (359) signed ::= NK_FLOAT */
  {  413,   -2 }, /* (360) signed ::= NK_PLUS NK_FLOAT */
  {  413,   -2 }, /* (361) signed ::= NK_MINUS NK_FLOAT */
  {  367,   -1 }, /* (362) signed_literal ::= signed */
  {  367,   -1 }, /* (363) signed_literal ::= NK_STRING */
  {  367,   -1 }, /* (364) signed_literal ::= NK_BOOL */
  {  367,   -2 }, /* (365) signed_literal ::= TIMESTAMP NK_STRING */
  {  367,   -1 }, /* (366) signed_literal ::= duration_literal */
  {  367,   -1 }, /* (367) signed_literal ::= NULL */
  {  367,   -1 }, /* (368) signed_literal ::= literal_func */
  {  367,   -1 }, /* (369) signed_literal ::= NK_QUESTION */
  {  415,   -1 }, /* (370) literal_list ::= signed_literal */
  {  415,   -3 }, /* (371) literal_list ::= literal_list NK_COMMA signed_literal */
  {  340,   -1 }, /* (372) db_name ::= NK_ID */
  {  373,   -1 }, /* (373) table_name ::= NK_ID */
  {  365,   -1 }, /* (374) column_name ::= NK_ID */
  {  380,   -1 }, /* (375) function_name ::= NK_ID */
  {  416,   -1 }, /* (376) table_alias ::= NK_ID */
  {  388,   -1 }, /* (377) column_alias ::= NK_ID */
  {  334,   -1 }, /* (378) user_name ::= NK_ID */
  {  341,   -1 }, /* (379) topic_name ::= NK_ID */
  {  405,   -1 }, /* (380) stream_name ::= NK_ID */
  {  398,   -1 }, /* (381) cgroup_name ::= NK_ID */
  {  391,   -1 }, /* (382) index_name ::= NK_ID */
  {  417,   -1 }, /* (383) expr_or_subquery ::= expression */
  {  410,   -1 }, /* (384) expression ::= literal */
  {  410,   -1 }, /* (385) expression ::= pseudo_column */
  {  410,   -1 }, /* (386) expression ::= column_reference */
  {  410,   -1 }, /* (387) expression ::= function_expression */
  {  410,   -1 }, /* (388) expression ::= case_when_expression */
  {  410,   -3 }, /* (389) expression ::= NK_LP expression NK_RP */
  {  410,   -2 }, /* (390) expression ::= NK_PLUS expr_or_subquery */
  {  410,   -2 }, /* (391) expression ::= NK_MINUS expr_or_subquery */
  {  410,   -3 }, /* (392) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  410,   -3 }, /* (393) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  410,   -3 }, /* (394) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  410,   -3 }, /* (395) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  410,   -3 }, /* (396) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  410,   -3 }, /* (397) expression ::= column_reference NK_ARROW NK_STRING */
  {  410,   -3 }, /* (398) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  410,   -3 }, /* (399) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  370,   -1 }, /* (400) expression_list ::= expr_or_subquery */
  {  370,   -3 }, /* (401) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  419,   -1 }, /* (402) column_reference ::= column_name */
  {  419,   -3 }, /* (403) column_reference ::= table_name NK_DOT column_name */
  {  418,   -1 }, /* (404) pseudo_column ::= ROWTS */
  {  418,   -1 }, /* (405) pseudo_column ::= TBNAME */
  {  418,   -3 }, /* (406) pseudo_column ::= table_name NK_DOT TBNAME */
  {  418,   -1 }, /* (407) pseudo_column ::= QSTART */
  {  418,   -1 }, /* (408) pseudo_column ::= QEND */
  {  418,   -1 }, /* (409) pseudo_column ::= QDURATION */
  {  418,   -1 }, /* (410) pseudo_column ::= WSTART */
  {  418,   -1 }, /* (411) pseudo_column ::= WEND */
  {  418,   -1 }, /* (412) pseudo_column ::= WDURATION */
  {  418,   -1 }, /* (413) pseudo_column ::= IROWTS */
  {  418,   -1 }, /* (414) pseudo_column ::= ISFILLED */
  {  418,   -1 }, /* (415) pseudo_column ::= QTAGS */
  {  420,   -4 }, /* (416) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  420,   -4 }, /* (417) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  420,   -6 }, /* (418) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  420,   -1 }, /* (419) function_expression ::= literal_func */
  {  414,   -3 }, /* (420) literal_func ::= noarg_func NK_LP NK_RP */
  {  414,   -1 }, /* (421) literal_func ::= NOW */
  {  424,   -1 }, /* (422) noarg_func ::= NOW */
  {  424,   -1 }, /* (423) noarg_func ::= TODAY */
  {  424,   -1 }, /* (424) noarg_func ::= TIMEZONE */
  {  424,   -1 }, /* (425) noarg_func ::= DATABASE */
  {  424,   -1 }, /* (426) noarg_func ::= CLIENT_VERSION */
  {  424,   -1 }, /* (427) noarg_func ::= SERVER_VERSION */
  {  424,   -1 }, /* (428) noarg_func ::= SERVER_STATUS */
  {  424,   -1 }, /* (429) noarg_func ::= CURRENT_USER */
  {  424,   -1 }, /* (430) noarg_func ::= USER */
  {  422,   -1 }, /* (431) star_func ::= COUNT */
  {  422,   -1 }, /* (432) star_func ::= FIRST */
  {  422,   -1 }, /* (433) star_func ::= LAST */
  {  422,   -1 }, /* (434) star_func ::= LAST_ROW */
  {  423,   -1 }, /* (435) star_func_para_list ::= NK_STAR */
  {  423,   -1 }, /* (436) star_func_para_list ::= other_para_list */
  {  425,   -1 }, /* (437) other_para_list ::= star_func_para */
  {  425,   -3 }, /* (438) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  426,   -1 }, /* (439) star_func_para ::= expr_or_subquery */
  {  426,   -3 }, /* (440) star_func_para ::= table_name NK_DOT NK_STAR */
  {  421,   -4 }, /* (441) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  421,   -5 }, /* (442) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  427,   -1 }, /* (443) when_then_list ::= when_then_expr */
  {  427,   -2 }, /* (444) when_then_list ::= when_then_list when_then_expr */
  {  430,   -4 }, /* (445) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  428,    0 }, /* (446) case_when_else_opt ::= */
  {  428,   -2 }, /* (447) case_when_else_opt ::= ELSE common_expression */
  {  431,   -3 }, /* (448) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  431,   -5 }, /* (449) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  431,   -6 }, /* (450) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  431,   -3 }, /* (451) predicate ::= expr_or_subquery IS NULL */
  {  431,   -4 }, /* (452) predicate ::= expr_or_subquery IS NOT NULL */
  {  431,   -3 }, /* (453) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  432,   -1 }, /* (454) compare_op ::= NK_LT */
  {  432,   -1 }, /* (455) compare_op ::= NK_GT */
  {  432,   -1 }, /* (456) compare_op ::= NK_LE */
  {  432,   -1 }, /* (457) compare_op ::= NK_GE */
  {  432,   -1 }, /* (458) compare_op ::= NK_NE */
  {  432,   -1 }, /* (459) compare_op ::= NK_EQ */
  {  432,   -1 }, /* (460) compare_op ::= LIKE */
  {  432,   -2 }, /* (461) compare_op ::= NOT LIKE */
  {  432,   -1 }, /* (462) compare_op ::= MATCH */
  {  432,   -1 }, /* (463) compare_op ::= NMATCH */
  {  432,   -1 }, /* (464) compare_op ::= CONTAINS */
  {  433,   -1 }, /* (465) in_op ::= IN */
  {  433,   -2 }, /* (466) in_op ::= NOT IN */
  {  434,   -3 }, /* (467) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  435,   -1 }, /* (468) boolean_value_expression ::= boolean_primary */
  {  435,   -2 }, /* (469) boolean_value_expression ::= NOT boolean_primary */
  {  435,   -3 }, /* (470) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  435,   -3 }, /* (471) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  436,   -1 }, /* (472) boolean_primary ::= predicate */
  {  436,   -3 }, /* (473) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  429,   -1 }, /* (474) common_expression ::= expr_or_subquery */
  {  429,   -1 }, /* (475) common_expression ::= boolean_value_expression */
  {  437,    0 }, /* (476) from_clause_opt ::= */
  {  437,   -2 }, /* (477) from_clause_opt ::= FROM table_reference_list */
  {  438,   -1 }, /* (478) table_reference_list ::= table_reference */
  {  438,   -3 }, /* (479) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  439,   -1 }, /* (480) table_reference ::= table_primary */
  {  439,   -1 }, /* (481) table_reference ::= joined_table */
  {  440,   -2 }, /* (482) table_primary ::= table_name alias_opt */
  {  440,   -4 }, /* (483) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  440,   -2 }, /* (484) table_primary ::= subquery alias_opt */
  {  440,   -1 }, /* (485) table_primary ::= parenthesized_joined_table */
  {  442,    0 }, /* (486) alias_opt ::= */
  {  442,   -1 }, /* (487) alias_opt ::= table_alias */
  {  442,   -2 }, /* (488) alias_opt ::= AS table_alias */
  {  444,   -3 }, /* (489) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  444,   -3 }, /* (490) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  441,   -6 }, /* (491) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  445,    0 }, /* (492) join_type ::= */
  {  445,   -1 }, /* (493) join_type ::= INNER */
  {  447,  -12 }, /* (494) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  448,    0 }, /* (495) set_quantifier_opt ::= */
  {  448,   -1 }, /* (496) set_quantifier_opt ::= DISTINCT */
  {  448,   -1 }, /* (497) set_quantifier_opt ::= ALL */
  {  449,   -1 }, /* (498) select_list ::= select_item */
  {  449,   -3 }, /* (499) select_list ::= select_list NK_COMMA select_item */
  {  457,   -1 }, /* (500) select_item ::= NK_STAR */
  {  457,   -1 }, /* (501) select_item ::= common_expression */
  {  457,   -2 }, /* (502) select_item ::= common_expression column_alias */
  {  457,   -3 }, /* (503) select_item ::= common_expression AS column_alias */
  {  457,   -3 }, /* (504) select_item ::= table_name NK_DOT NK_STAR */
  {  412,    0 }, /* (505) where_clause_opt ::= */
  {  412,   -2 }, /* (506) where_clause_opt ::= WHERE search_condition */
  {  450,    0 }, /* (507) partition_by_clause_opt ::= */
  {  450,   -3 }, /* (508) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  458,   -1 }, /* (509) partition_list ::= partition_item */
  {  458,   -3 }, /* (510) partition_list ::= partition_list NK_COMMA partition_item */
  {  459,   -1 }, /* (511) partition_item ::= expr_or_subquery */
  {  459,   -2 }, /* (512) partition_item ::= expr_or_subquery column_alias */
  {  459,   -3 }, /* (513) partition_item ::= expr_or_subquery AS column_alias */
  {  454,    0 }, /* (514) twindow_clause_opt ::= */
  {  454,   -6 }, /* (515) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  454,   -4 }, /* (516) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  454,   -6 }, /* (517) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  454,   -8 }, /* (518) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  454,   -7 }, /* (519) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  393,    0 }, /* (520) sliding_opt ::= */
  {  393,   -4 }, /* (521) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  453,    0 }, /* (522) fill_opt ::= */
  {  453,   -4 }, /* (523) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  453,   -6 }, /* (524) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  453,   -6 }, /* (525) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
  {  460,   -1 }, /* (526) fill_mode ::= NONE */
  {  460,   -1 }, /* (527) fill_mode ::= PREV */
  {  460,   -1 }, /* (528) fill_mode ::= NULL */
  {  460,   -1 }, /* (529) fill_mode ::= NULL_F */
  {  460,   -1 }, /* (530) fill_mode ::= LINEAR */
  {  460,   -1 }, /* (531) fill_mode ::= NEXT */
  {  455,    0 }, /* (532) group_by_clause_opt ::= */
  {  455,   -3 }, /* (533) group_by_clause_opt ::= GROUP BY group_by_list */
  {  461,   -1 }, /* (534) group_by_list ::= expr_or_subquery */
  {  461,   -3 }, /* (535) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  456,    0 }, /* (536) having_clause_opt ::= */
  {  456,   -2 }, /* (537) having_clause_opt ::= HAVING search_condition */
  {  451,    0 }, /* (538) range_opt ::= */
  {  451,   -6 }, /* (539) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  452,    0 }, /* (540) every_opt ::= */
  {  452,   -4 }, /* (541) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  462,   -4 }, /* (542) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  463,   -1 }, /* (543) query_simple ::= query_specification */
  {  463,   -1 }, /* (544) query_simple ::= union_query_expression */
  {  467,   -4 }, /* (545) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  467,   -3 }, /* (546) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  468,   -1 }, /* (547) query_simple_or_subquery ::= query_simple */
  {  468,   -1 }, /* (548) query_simple_or_subquery ::= subquery */
  {  397,   -1 }, /* (549) query_or_subquery ::= query_expression */
  {  397,   -1 }, /* (550) query_or_subquery ::= subquery */
  {  464,    0 }, /* (551) order_by_clause_opt ::= */
  {  464,   -3 }, /* (552) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  465,    0 }, /* (553) slimit_clause_opt ::= */
  {  465,   -2 }, /* (554) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  465,   -4 }, /* (555) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  465,   -4 }, /* (556) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  466,    0 }, /* (557) limit_clause_opt ::= */
  {  466,   -2 }, /* (558) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  466,   -4 }, /* (559) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  466,   -4 }, /* (560) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  443,   -3 }, /* (561) subquery ::= NK_LP query_expression NK_RP */
  {  443,   -3 }, /* (562) subquery ::= NK_LP subquery NK_RP */
  {  446,   -1 }, /* (563) search_condition ::= common_expression */
  {  469,   -1 }, /* (564) sort_specification_list ::= sort_specification */
  {  469,   -3 }, /* (565) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  470,   -3 }, /* (566) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  471,    0 }, /* (567) ordering_specification_opt ::= */
  {  471,   -1 }, /* (568) ordering_specification_opt ::= ASC */
  {  471,   -1 }, /* (569) ordering_specification_opt ::= DESC */
  {  472,    0 }, /* (570) null_ordering_opt ::= */
  {  472,   -2 }, /* (571) null_ordering_opt ::= NULLS FIRST */
  {  472,   -2 }, /* (572) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,330,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,331,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,330,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,332,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,333,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,331,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,333,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,332,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy63, &yymsp[-1].minor.yy0, yymsp[0].minor.yy707); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy63, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy63, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy63, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy63); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy707 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy707 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy393, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy63); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy393, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy63); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy393 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy393 = yymsp[0].minor.yy393; }
  yymsp[0].minor.yy393 = yylhsminor.yy393;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy393 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy393 = yymsp[-2].minor.yy393 | yymsp[0].minor.yy393; }
  yymsp[-2].minor.yy393 = yylhsminor.yy393;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy393 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy393 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy63 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy63 = yylhsminor.yy63;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy63 = yymsp[-2].minor.yy63; }
  yymsp[-2].minor.yy63 = yylhsminor.yy63;
        break;
      case 42: /* priv_level ::= topic_name */
      case 281: /* sma_func_name ::= function_name */ yytestcase(yyruleno==281);
      case 487: /* alias_opt ::= table_alias */ yytestcase(yyruleno==487);
{ yylhsminor.yy63 = yymsp[0].minor.yy63; }
  yymsp[0].minor.yy63 = yylhsminor.yy63;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy63, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy669); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy63, yymsp[0].minor.yy669); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 282: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==282);
      case 283: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==283);
      case 284: /* sma_func_name ::= LAST */ yytestcase(yyruleno==284);
      case 285: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==285);
      case 372: /* db_name ::= NK_ID */ yytestcase(yyruleno==372);
      case 373: /* table_name ::= NK_ID */ yytestcase(yyruleno==373);
      case 374: /* column_name ::= NK_ID */ yytestcase(yyruleno==374);
      case 375: /* function_name ::= NK_ID */ yytestcase(yyruleno==375);
      case 376: /* table_alias ::= NK_ID */ yytestcase(yyruleno==376);
      case 377: /* column_alias ::= NK_ID */ yytestcase(yyruleno==377);
      case 378: /* user_name ::= NK_ID */ yytestcase(yyruleno==378);
      case 379: /* topic_name ::= NK_ID */ yytestcase(yyruleno==379);
      case 380: /* stream_name ::= NK_ID */ yytestcase(yyruleno==380);
      case 381: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==381);
      case 382: /* index_name ::= NK_ID */ yytestcase(yyruleno==382);
      case 422: /* noarg_func ::= NOW */ yytestcase(yyruleno==422);
      case 423: /* noarg_func ::= TODAY */ yytestcase(yyruleno==423);
      case 424: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==424);
      case 425: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==425);
      case 426: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==426);
      case 427: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==427);
      case 428: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==428);
      case 429: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==429);
      case 430: /* noarg_func ::= USER */ yytestcase(yyruleno==430);
      case 431: /* star_func ::= COUNT */ yytestcase(yyruleno==431);
      case 432: /* star_func ::= FIRST */ yytestcase(yyruleno==432);
      case 433: /* star_func ::= LAST */ yytestcase(yyruleno==433);
      case 434: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==434);
{ yylhsminor.yy63 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy63 = yylhsminor.yy63;
        break;
      case 54: /* force_opt ::= */
      case 74: /* not_exists_opt ::= */ yytestcase(yyruleno==74);
      case 76: /* exists_opt ::= */ yytestcase(yyruleno==76);
      case 302: /* analyze_opt ::= */ yytestcase(yyruleno==302);
      case 309: /* agg_func_opt ::= */ yytestcase(yyruleno==309);
      case 495: /* set_quantifier_opt ::= */ yytestcase(yyruleno==495);
{ yymsp[1].minor.yy669 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 303: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==303);
      case 310: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==310);
      case 496: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==496);
{ yymsp[0].minor.yy669 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy669, &yymsp[-1].minor.yy63, yymsp[0].minor.yy828); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy669, &yymsp[0].minor.yy63); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy63); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy63, yymsp[0].minor.yy828); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy63); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy63, yymsp[0].minor.yy332); }
        break;
      case 72: /* cmd ::= COMPACT DATABASE db_name start_opt end_opt */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[-2].minor.yy63, yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 73: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy669 = true; }
        break;
      case 75: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy669 = true; }
        break;
      case 77: /* db_options ::= */
{ yymsp[1].minor.yy828 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 78: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 79: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 80: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 81: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 82: /* db_options ::= db_options DURATION NK_INTEGER */
      case 83: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==83);
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 84: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 85: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 86: /* db_options ::= db_options KEEP integer_list */
      case 87: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==87);
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_KEEP, yymsp[0].minor.yy222); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 88: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 89: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 90: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 91: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 92: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 93: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 94: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 95: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_RETENTIONS, yymsp[0].minor.yy222); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 96: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 97: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 98: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-3].minor.yy828, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-3].minor.yy828, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 103: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 104: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 105: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 106: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 107: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy828 = setDatabaseOption(pCxt, yymsp[-2].minor.yy828, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 108: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy828 = createAlterDatabaseOptions(pCxt); yylhsminor.yy828 = setAlterDatabaseOption(pCxt, yylhsminor.yy828, &yymsp[0].minor.yy233); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 109: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy828 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy828, &yymsp[0].minor.yy233); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 110: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy233.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= KEEP integer_list */
      case 115: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==115);
{ yymsp[-1].minor.yy233.type = DB_OPTION_KEEP; yymsp[-1].minor.yy233.pList = yymsp[0].minor.yy222; }
        break;
      case 116: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_PAGES; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_WAL; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy233.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy222 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy222 = yylhsminor.yy222;
        break;
      case 121: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 341: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==341);
{ yylhsminor.yy222 = addNodeToList(pCxt, yymsp[-2].minor.yy222, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy222 = yylhsminor.yy222;
        break;
      case 122: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy222 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy222 = yylhsminor.yy222;
        break;
      case 123: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy222 = addNodeToList(pCxt, yymsp[-2].minor.yy222, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy222 = yylhsminor.yy222;
        break;
      case 124: /* retention_list ::= retention */
      case 154: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==154);
      case 157: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==157);
      case 164: /* column_def_list ::= column_def */ yytestcase(yyruleno==164);
      case 208: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==208);
      case 213: /* col_name_list ::= col_name */ yytestcase(yyruleno==213);
      case 264: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==264);
      case 278: /* func_list ::= func */ yytestcase(yyruleno==278);
      case 370: /* literal_list ::= signed_literal */ yytestcase(yyruleno==370);
      case 437: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==437);
      case 443: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==443);
      case 498: /* select_list ::= select_item */ yytestcase(yyruleno==498);
      case 509: /* partition_list ::= partition_item */ yytestcase(yyruleno==509);
      case 564: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==564);
{ yylhsminor.yy222 = createNodeList(pCxt, yymsp[0].minor.yy828); }
  yymsp[0].minor.yy222 = yylhsminor.yy222;
        break;
      case 125: /* retention_list ::= retention_list NK_COMMA retention */
      case 158: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==158);
      case 165: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==165);
      case 209: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==209);
      case 214: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==214);
      case 265: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==265);
      case 279: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==279);
      case 371: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==371);
      case 438: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==438);
      case 499: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==499);
      case 510: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==510);
      case 565: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==565);
{ yylhsminor.yy222 = addNodeToList(pCxt, yymsp[-2].minor.yy222, yymsp[0].minor.yy828); }
  yymsp[-2].minor.yy222 = yylhsminor.yy222;
        break;
      case 126: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy828 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 127: /* speed_opt ::= */
      case 311: /* bufsize_opt ::= */ yytestcase(yyruleno==311);
{ yymsp[1].minor.yy332 = 0; }
        break;
      case 128: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 312: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==312);
{ yymsp[-1].minor.yy332 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 129: /* start_opt ::= */
      case 133: /* end_opt ::= */ yytestcase(yyruleno==133);
      case 258: /* like_pattern_opt ::= */ yytestcase(yyruleno==258);
      case 331: /* subtable_opt ::= */ yytestcase(yyruleno==331);
      case 446: /* case_when_else_opt ::= */ yytestcase(yyruleno==446);
      case 476: /* from_clause_opt ::= */ yytestcase(yyruleno==476);
      case 505: /* where_clause_opt ::= */ yytestcase(yyruleno==505);
      case 514: /* twindow_clause_opt ::= */ yytestcase(yyruleno==514);
      case 520: /* sliding_opt ::= */ yytestcase(yyruleno==520);
      case 522: /* fill_opt ::= */ yytestcase(yyruleno==522);
      case 536: /* having_clause_opt ::= */ yytestcase(yyruleno==536);
      case 538: /* range_opt ::= */ yytestcase(yyruleno==538);
      case 540: /* every_opt ::= */ yytestcase(yyruleno==540);
      case 553: /* slimit_clause_opt ::= */ yytestcase(yyruleno==553);
      case 557: /* limit_clause_opt ::= */ yytestcase(yyruleno==557);
{ yymsp[1].minor.yy828 = NULL; }
        break;
      case 130: /* start_opt ::= START WITH NK_INTEGER */
      case 134: /* end_opt ::= END WITH NK_INTEGER */ yytestcase(yyruleno==134);
{ yymsp[-2].minor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 131: /* start_opt ::= START WITH NK_STRING */
      case 135: /* end_opt ::= END WITH NK_STRING */ yytestcase(yyruleno==135);
{ yymsp[-2].minor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 132: /* start_opt ::= START WITH TIMESTAMP NK_STRING */
      case 136: /* end_opt ::= END WITH TIMESTAMP NK_STRING */ yytestcase(yyruleno==136);
{ yymsp[-3].minor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 137: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 139: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==139);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy669, yymsp[-5].minor.yy828, yymsp[-3].minor.yy222, yymsp[-1].minor.yy222, yymsp[0].minor.yy828); }
        break;
      case 138: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy222); }
        break;
      case 140: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy222); }
        break;
      case 141: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy669, yymsp[0].minor.yy828); }
        break;
      case 142: /* cmd ::= ALTER TABLE alter_table_clause */
      case 343: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==343);
      case 344: /* cmd ::= insert_query */ yytestcase(yyruleno==344);
{ pCxt->pRootNode = yymsp[0].minor.yy828; }
        break;
      case 143: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy828); }
        break;
      case 144: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy828 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 145: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy828 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy828, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy63, yymsp[0].minor.yy686); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 146: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy828 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy828, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy63); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 147: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy828 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy828, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy63, yymsp[0].minor.yy686); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 148: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy828 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy828, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy63, &yymsp[0].minor.yy63); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 149: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy828 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy828, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy63, yymsp[0].minor.yy686); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 150: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy828 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy828, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy63); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 151: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy828 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy828, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy63, yymsp[0].minor.yy686); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 152: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy828 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy828, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy63, &yymsp[0].minor.yy63); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 153: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy828 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy828, &yymsp[-2].minor.yy63, yymsp[0].minor.yy828); }
  yymsp[-5].minor.yy828 = yylhsminor.yy828;
        break;
      case 155: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 444: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==444);
{ yylhsminor.yy222 = addNodeToList(pCxt, yymsp[-1].minor.yy222, yymsp[0].minor.yy828); }
  yymsp[-1].minor.yy222 = yylhsminor.yy222;
        break;
      case 156: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy828 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy669, yymsp[-8].minor.yy828, yymsp[-6].minor.yy828, yymsp[-5].minor.yy222, yymsp[-2].minor.yy222, yymsp[0].minor.yy828); }
  yymsp[-9].minor.yy828 = yylhsminor.yy828;
        break;
      case 159: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy828 = createDropTableClause(pCxt, yymsp[-1].minor.yy669, yymsp[0].minor.yy828); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 160: /* specific_cols_opt ::= */
      case 191: /* tags_def_opt ::= */ yytestcase(yyruleno==191);
      case 263: /* tag_list_opt ::= */ yytestcase(yyruleno==263);
      case 317: /* col_list_opt ::= */ yytestcase(yyruleno==317);
      case 319: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==319);
      case 507: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==507);
      case 532: /* group_by_clause_opt ::= */ yytestcase(yyruleno==532);
      case 551: /* order_by_clause_opt ::= */ yytestcase(yyruleno==551);
{ yymsp[1].minor.yy222 = NULL; }
        break;
      case 161: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 318: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==318);
{ yymsp[-2].minor.yy222 = yymsp[-1].minor.yy222; }
        break;
      case 162: /* full_table_name ::= table_name */
{ yylhsminor.yy828 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy63, NULL); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 163: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy828 = createRealTableNode(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy63, NULL); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 166: /* column_def ::= column_name type_name */
{ yylhsminor.yy828 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy63, yymsp[0].minor.yy686, NULL); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 167: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy828 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy63, yymsp[-2].minor.yy686, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 168: /* type_name ::= BOOL */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 169: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 170: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 171: /* type_name ::= INT */
      case 172: /* type_name ::= INTEGER */ yytestcase(yyruleno==172);
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 173: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 174: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 175: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 176: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy686 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 177: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 178: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy686 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 179: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy686 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 180: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy686 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 181: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy686 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 182: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy686 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 183: /* type_name ::= JSON */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 184: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy686 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 185: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 186: /* type_name ::= BLOB */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 187: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy686 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 188: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy686 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 189: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy686 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 190: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy686 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 192: /* tags_def_opt ::= tags_def */
      case 320: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==320);
      case 436: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==436);
{ yylhsminor.yy222 = yymsp[0].minor.yy222; }
  yymsp[0].minor.yy222 = yylhsminor.yy222;
        break;
      case 193: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 321: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==321);
{ yymsp[-3].minor.yy222 = yymsp[-1].minor.yy222; }
        break;
      case 194: /* table_options ::= */
{ yymsp[1].minor.yy828 = createDefaultTableOptions(pCxt); }
        break;
      case 195: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-2].minor.yy828, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 196: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-2].minor.yy828, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy222); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 197: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-2].minor.yy828, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy222); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 198: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-4].minor.yy828, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy222); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 199: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-2].minor.yy828, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 200: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-4].minor.yy828, TABLE_OPTION_SMA, yymsp[-1].minor.yy222); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 201: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-2].minor.yy828, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy222); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 202: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy828 = createAlterTableOptions(pCxt); yylhsminor.yy828 = setTableOption(pCxt, yylhsminor.yy828, yymsp[0].minor.yy233.type, &yymsp[0].minor.yy233.val); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 203: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy828 = setTableOption(pCxt, yymsp[-1].minor.yy828, yymsp[0].minor.yy233.type, &yymsp[0].minor.yy233.val); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 204: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy233.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 205: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy233.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy233.val = yymsp[0].minor.yy0; }
        break;
      case 206: /* duration_list ::= duration_literal */
      case 400: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==400);
{ yylhsminor.yy222 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy828)); }
  yymsp[0].minor.yy222 = yylhsminor.yy222;
        break;
      case 207: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 401: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==401);
{ yylhsminor.yy222 = addNodeToList(pCxt, yymsp[-2].minor.yy222, releaseRawExprNode(pCxt, yymsp[0].minor.yy828)); }
  yymsp[-2].minor.yy222 = yylhsminor.yy222;
        break;
      case 210: /* rollup_func_name ::= function_name */
{ yylhsminor.yy828 = createFunctionNode(pCxt, &yymsp[0].minor.yy63, NULL); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 211: /* rollup_func_name ::= FIRST */
      case 212: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==212);
      case 267: /* tag_item ::= QTAGS */ yytestcase(yyruleno==267);
{ yylhsminor.yy828 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 215: /* col_name ::= column_name */
      case 268: /* tag_item ::= column_name */ yytestcase(yyruleno==268);
{ yylhsminor.yy828 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy63); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 216: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 217: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 218: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 219: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 220: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy828, yymsp[0].minor.yy828, OP_TYPE_LIKE); }
        break;
      case 221: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy828, yymsp[0].minor.yy828, OP_TYPE_LIKE); }
        break;
      case 222: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy828, NULL, OP_TYPE_LIKE); }
        break;
      case 223: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 224: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 225: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 226: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy828, yymsp[-1].minor.yy828, OP_TYPE_EQUAL); }
        break;
      case 227: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 228: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 229: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 230: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 231: /* cmd ::= SHOW LICENCES */
      case 232: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==232);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 233: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy63); }
        break;
      case 234: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy828); }
        break;
      case 235: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy828); }
        break;
      case 236: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 237: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 238: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 239: /* cmd ::= SHOW VARIABLES */
      case 240: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==240);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 241: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 242: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy828); }
        break;
      case 243: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 244: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 245: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 246: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 247: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy828); }
        break;
      case 248: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 249: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 250: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy828, yymsp[-1].minor.yy828, OP_TYPE_EQUAL); }
        break;
      case 251: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy828, yymsp[0].minor.yy828, yymsp[-3].minor.yy222); }
        break;
      case 252: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 253: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 254: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy828,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 255: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 256: /* db_name_cond_opt ::= */
      case 261: /* from_db_opt ::= */ yytestcase(yyruleno==261);
{ yymsp[1].minor.yy828 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 257: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy828 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy63); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 259: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 260: /* table_name_cond ::= table_name */
{ yylhsminor.yy828 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy63); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 262: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy828 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy63); }
        break;
      case 266: /* tag_item ::= TBNAME */
{ yylhsminor.yy828 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 269: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy828 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy63), &yymsp[0].minor.yy63); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 270: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy828 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy63), &yymsp[0].minor.yy63); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 271: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy669, yymsp[-3].minor.yy828, yymsp[-1].minor.yy828, NULL, yymsp[0].minor.yy828); }
        break;
      case 272: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy669, yymsp[-5].minor.yy828, yymsp[-3].minor.yy828, yymsp[-1].minor.yy222, NULL); }
        break;
      case 273: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy669, yymsp[0].minor.yy828); }
        break;
      case 274: /* full_index_name ::= index_name */
{ yylhsminor.yy828 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy63); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 275: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy828 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy63); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 276: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy828 = createIndexOption(pCxt, yymsp[-7].minor.yy222, releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), NULL, yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 277: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy828 = createIndexOption(pCxt, yymsp[-9].minor.yy222, releaseRawExprNode(pCxt, yymsp[-5].minor.yy828), releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 280: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy828 = createFunctionNode(pCxt, &yymsp[-3].minor.yy63, yymsp[-1].minor.yy222); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 286: /* sma_stream_opt ::= */
      case 322: /* stream_options ::= */ yytestcase(yyruleno==322);
{ yymsp[1].minor.yy828 = createStreamOptions(pCxt); }
        break;
      case 287: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy828)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy828); yylhsminor.yy828 = yymsp[-2].minor.yy828; }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 288: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy828)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy828); yylhsminor.yy828 = yymsp[-2].minor.yy828; }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 289: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy828)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy828); yylhsminor.yy828 = yymsp[-2].minor.yy828; }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 290: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy669, &yymsp[-2].minor.yy63, yymsp[0].minor.yy828); }
        break;
      case 291: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy669, &yymsp[-3].minor.yy63, &yymsp[0].minor.yy63, false); }
        break;
      case 292: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy669, &yymsp[-5].minor.yy63, &yymsp[0].minor.yy63, true); }
        break;
      case 293: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy669, &yymsp[-3].minor.yy63, yymsp[0].minor.yy828, false); }
        break;
      case 294: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy669, &yymsp[-5].minor.yy63, yymsp[0].minor.yy828, true); }
        break;
      case 295: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy669, &yymsp[0].minor.yy63); }
        break;
      case 296: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy669, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy63); }
        break;
      case 297: /* cmd ::= DESC full_table_name */
      case 298: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==298);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy828); }
        break;
      case 299: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 300: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 301: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==301);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy669, yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 304: /* explain_options ::= */
{ yymsp[1].minor.yy828 = createDefaultExplainOptions(pCxt); }
        break;
      case 305: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy828 = setExplainVerbose(pCxt, yymsp[-2].minor.yy828, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 306: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy828 = setExplainRatio(pCxt, yymsp[-2].minor.yy828, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 307: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy669, yymsp[-9].minor.yy669, &yymsp[-6].minor.yy63, &yymsp[-4].minor.yy0, yymsp[-2].minor.yy686, yymsp[-1].minor.yy332, &yymsp[0].minor.yy63); }
        break;
      case 308: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy669, &yymsp[0].minor.yy63); }
        break;
      case 313: /* language_opt ::= */
{ yymsp[1].minor.yy63 = nil_token; }
        break;
      case 314: /* language_opt ::= LANGUAGE NK_STRING */
{ yymsp[-1].minor.yy63 = yymsp[0].minor.yy0; }
        break;
      case 315: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy669, &yymsp[-8].minor.yy63, yymsp[-5].minor.yy828, yymsp[-7].minor.yy828, yymsp[-3].minor.yy222, yymsp[-2].minor.yy828, yymsp[0].minor.yy828, yymsp[-4].minor.yy222); }
        break;
      case 316: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy669, &yymsp[0].minor.yy63); }
        break;
      case 323: /* stream_options ::= stream_options TRIGGER AT_ONCE */
      case 324: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */ yytestcase(yyruleno==324);
{ yylhsminor.yy828 = setStreamOptions(pCxt, yymsp[-2].minor.yy828, SOPT_TRIGGER_TYPE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 325: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ yylhsminor.yy828 = setStreamOptions(pCxt, yymsp[-3].minor.yy828, SOPT_TRIGGER_TYPE_SET, &yymsp[-1].minor.yy0, releaseRawExprNode(pCxt, yymsp[0].minor.yy828)); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 326: /* stream_options ::= stream_options WATERMARK duration_literal */
{ yylhsminor.yy828 = setStreamOptions(pCxt, yymsp[-2].minor.yy828, SOPT_WATERMARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy828)); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 327: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ yylhsminor.yy828 = setStreamOptions(pCxt, yymsp[-3].minor.yy828, SOPT_IGNORE_EXPIRED_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 328: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ yylhsminor.yy828 = setStreamOptions(pCxt, yymsp[-2].minor.yy828, SOPT_FILL_HISTORY_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 329: /* stream_options ::= stream_options DELETE_MARK duration_literal */
{ yylhsminor.yy828 = setStreamOptions(pCxt, yymsp[-2].minor.yy828, SOPT_DELETE_MARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy828)); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 330: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ yylhsminor.yy828 = setStreamOptions(pCxt, yymsp[-3].minor.yy828, SOPT_IGNORE_UPDATE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 332: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 521: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==521);
      case 541: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==541);
{ yymsp[-3].minor.yy828 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy828); }
        break;
      case 333: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 334: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 335: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 336: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 337: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 338: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy222); }
        break;
      case 339: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 340: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy222 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 342: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 345: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy828 = createInsertStmt(pCxt, yymsp[-4].minor.yy828, yymsp[-2].minor.yy222, yymsp[0].minor.yy828); }
        break;
      case 346: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy828 = createInsertStmt(pCxt, yymsp[-1].minor.yy828, NULL, yymsp[0].minor.yy828); }
        break;
      case 347: /* literal ::= NK_INTEGER */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 348: /* literal ::= NK_FLOAT */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 349: /* literal ::= NK_STRING */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 350: /* literal ::= NK_BOOL */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 351: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 352: /* literal ::= duration_literal */
      case 362: /* signed_literal ::= signed */ yytestcase(yyruleno==362);
      case 383: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==383);
      case 384: /* expression ::= literal */ yytestcase(yyruleno==384);
      case 385: /* expression ::= pseudo_column */ yytestcase(yyruleno==385);
      case 386: /* expression ::= column_reference */ yytestcase(yyruleno==386);
      case 387: /* expression ::= function_expression */ yytestcase(yyruleno==387);
      case 388: /* expression ::= case_when_expression */ yytestcase(yyruleno==388);
      case 419: /* function_expression ::= literal_func */ yytestcase(yyruleno==419);
      case 468: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==468);
      case 472: /* boolean_primary ::= predicate */ yytestcase(yyruleno==472);
      case 474: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==474);
      case 475: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==475);
      case 478: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==478);
      case 480: /* table_reference ::= table_primary */ yytestcase(yyruleno==480);
      case 481: /* table_reference ::= joined_table */ yytestcase(yyruleno==481);
      case 485: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==485);
      case 543: /* query_simple ::= query_specification */ yytestcase(yyruleno==543);
      case 544: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==544);
      case 547: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==547);
      case 549: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==549);
{ yylhsminor.yy828 = yymsp[0].minor.yy828; }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 353: /* literal ::= NULL */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 354: /* literal ::= NK_QUESTION */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 355: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 356: /* signed ::= NK_INTEGER */
{ yylhsminor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 357: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 358: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 359: /* signed ::= NK_FLOAT */
{ yylhsminor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 360: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 361: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 363: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 364: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 365: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 366: /* signed_literal ::= duration_literal */
      case 368: /* signed_literal ::= literal_func */ yytestcase(yyruleno==368);
      case 439: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==439);
      case 501: /* select_item ::= common_expression */ yytestcase(yyruleno==501);
      case 511: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==511);
      case 548: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==548);
      case 550: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==550);
      case 563: /* search_condition ::= common_expression */ yytestcase(yyruleno==563);
{ yylhsminor.yy828 = releaseRawExprNode(pCxt, yymsp[0].minor.yy828); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 367: /* signed_literal ::= NULL */
{ yylhsminor.yy828 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 369: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy828 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 389: /* expression ::= NK_LP expression NK_RP */
      case 473: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==473);
      case 562: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==562);
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy828)); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 390: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy828));
                                                                                  }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 391: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy828), NULL));
                                                                                  }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 392: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828))); 
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 393: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828))); 
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 394: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828))); 
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 395: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828))); 
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 396: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 397: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 398: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 399: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 402: /* column_reference ::= column_name */
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy63, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy63)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 403: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy63, createColumnNode(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy63)); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 404: /* pseudo_column ::= ROWTS */
      case 405: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==405);
      case 407: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==407);
      case 408: /* pseudo_column ::= QEND */ yytestcase(yyruleno==408);
      case 409: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==409);
      case 410: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==410);
      case 411: /* pseudo_column ::= WEND */ yytestcase(yyruleno==411);
      case 412: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==412);
      case 413: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==413);
      case 414: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==414);
      case 415: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==415);
      case 421: /* literal_func ::= NOW */ yytestcase(yyruleno==421);
{ yylhsminor.yy828 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 406: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy63)))); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 416: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 417: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==417);
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy63, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy63, yymsp[-1].minor.yy222)); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 418: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), yymsp[-1].minor.yy686)); }
  yymsp[-5].minor.yy828 = yylhsminor.yy828;
        break;
      case 420: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy63, NULL)); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 435: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy222 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy222 = yylhsminor.yy222;
        break;
      case 440: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 504: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==504);
{ yylhsminor.yy828 = createColumnNode(pCxt, &yymsp[-2].minor.yy63, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 441: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy222, yymsp[-1].minor.yy828)); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 442: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), yymsp[-2].minor.yy222, yymsp[-1].minor.yy828)); }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 445: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy828 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)); }
        break;
      case 447: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy828 = releaseRawExprNode(pCxt, yymsp[0].minor.yy828); }
        break;
      case 448: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 453: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==453);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy62, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 449: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy828), releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-4].minor.yy828 = yylhsminor.yy828;
        break;
      case 450: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy828), releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-5].minor.yy828 = yylhsminor.yy828;
        break;
      case 451: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), NULL));
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 452: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), NULL));
                                                                                  }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 454: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy62 = OP_TYPE_LOWER_THAN; }
        break;
      case 455: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy62 = OP_TYPE_GREATER_THAN; }
        break;
      case 456: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy62 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 457: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy62 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 458: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy62 = OP_TYPE_NOT_EQUAL; }
        break;
      case 459: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy62 = OP_TYPE_EQUAL; }
        break;
      case 460: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy62 = OP_TYPE_LIKE; }
        break;
      case 461: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy62 = OP_TYPE_NOT_LIKE; }
        break;
      case 462: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy62 = OP_TYPE_MATCH; }
        break;
      case 463: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy62 = OP_TYPE_NMATCH; }
        break;
      case 464: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy62 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 465: /* in_op ::= IN */
{ yymsp[0].minor.yy62 = OP_TYPE_IN; }
        break;
      case 466: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy62 = OP_TYPE_NOT_IN; }
        break;
      case 467: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy222)); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 469: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy828), NULL));
                                                                                  }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 470: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 471: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy828);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy828);
                                                                                    yylhsminor.yy828 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), releaseRawExprNode(pCxt, yymsp[0].minor.yy828)));
                                                                                  }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 477: /* from_clause_opt ::= FROM table_reference_list */
      case 506: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==506);
      case 537: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==537);
{ yymsp[-1].minor.yy828 = yymsp[0].minor.yy828; }
        break;
      case 479: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy828 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy828, yymsp[0].minor.yy828, NULL); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 482: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy828 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy63, &yymsp[0].minor.yy63); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 483: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy828 = createRealTableNode(pCxt, &yymsp[-3].minor.yy63, &yymsp[-1].minor.yy63, &yymsp[0].minor.yy63); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 484: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy828 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy828), &yymsp[0].minor.yy63); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 486: /* alias_opt ::= */
{ yymsp[1].minor.yy63 = nil_token;  }
        break;
      case 488: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy63 = yymsp[0].minor.yy63; }
        break;
      case 489: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 490: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==490);
{ yymsp[-2].minor.yy828 = yymsp[-1].minor.yy828; }
        break;
      case 491: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy828 = createJoinTableNode(pCxt, yymsp[-4].minor.yy574, yymsp[-5].minor.yy828, yymsp[-2].minor.yy828, yymsp[0].minor.yy828); }
  yymsp[-5].minor.yy828 = yylhsminor.yy828;
        break;
      case 492: /* join_type ::= */
{ yymsp[1].minor.yy574 = JOIN_TYPE_INNER; }
        break;
      case 493: /* join_type ::= INNER */
{ yymsp[0].minor.yy574 = JOIN_TYPE_INNER; }
        break;
      case 494: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy828 = createSelectStmt(pCxt, yymsp[-10].minor.yy669, yymsp[-9].minor.yy222, yymsp[-8].minor.yy828);
                                                                                    yymsp[-11].minor.yy828 = addWhereClause(pCxt, yymsp[-11].minor.yy828, yymsp[-7].minor.yy828);
                                                                                    yymsp[-11].minor.yy828 = addPartitionByClause(pCxt, yymsp[-11].minor.yy828, yymsp[-6].minor.yy222);
                                                                                    yymsp[-11].minor.yy828 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy828, yymsp[-2].minor.yy828);
                                                                                    yymsp[-11].minor.yy828 = addGroupByClause(pCxt, yymsp[-11].minor.yy828, yymsp[-1].minor.yy222);
                                                                                    yymsp[-11].minor.yy828 = addHavingClause(pCxt, yymsp[-11].minor.yy828, yymsp[0].minor.yy828);
                                                                                    yymsp[-11].minor.yy828 = addRangeClause(pCxt, yymsp[-11].minor.yy828, yymsp[-5].minor.yy828);
                                                                                    yymsp[-11].minor.yy828 = addEveryClause(pCxt, yymsp[-11].minor.yy828, yymsp[-4].minor.yy828);
                                                                                    yymsp[-11].minor.yy828 = addFillClause(pCxt, yymsp[-11].minor.yy828, yymsp[-3].minor.yy828);
                                                                                  }
        break;
      case 497: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy669 = false; }
        break;
      case 500: /* select_item ::= NK_STAR */
{ yylhsminor.yy828 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy828 = yylhsminor.yy828;
        break;
      case 502: /* select_item ::= common_expression column_alias */
      case 512: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==512);
{ yylhsminor.yy828 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy828), &yymsp[0].minor.yy63); }
  yymsp[-1].minor.yy828 = yylhsminor.yy828;
        break;
      case 503: /* select_item ::= common_expression AS column_alias */
      case 513: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==513);
{ yylhsminor.yy828 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), &yymsp[0].minor.yy63); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 508: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 533: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==533);
      case 552: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==552);
{ yymsp[-2].minor.yy222 = yymsp[0].minor.yy222; }
        break;
      case 515: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy828 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), releaseRawExprNode(pCxt, yymsp[-1].minor.yy828)); }
        break;
      case 516: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy828 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy828)); }
        break;
      case 517: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy828 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), NULL, yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 518: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy828 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy828), releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), yymsp[-1].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 519: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy828 = createEventWindowNode(pCxt, yymsp[-3].minor.yy828, yymsp[0].minor.yy828); }
        break;
      case 523: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy828 = createFillNode(pCxt, yymsp[-1].minor.yy822, NULL); }
        break;
      case 524: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy828 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy222)); }
        break;
      case 525: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy828 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy222)); }
        break;
      case 526: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy822 = FILL_MODE_NONE; }
        break;
      case 527: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy822 = FILL_MODE_PREV; }
        break;
      case 528: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy822 = FILL_MODE_NULL; }
        break;
      case 529: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy822 = FILL_MODE_NULL_F; }
        break;
      case 530: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy822 = FILL_MODE_LINEAR; }
        break;
      case 531: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy822 = FILL_MODE_NEXT; }
        break;
      case 534: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy222 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy828))); }
  yymsp[0].minor.yy222 = yylhsminor.yy222;
        break;
      case 535: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy222 = addNodeToList(pCxt, yymsp[-2].minor.yy222, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy828))); }
  yymsp[-2].minor.yy222 = yylhsminor.yy222;
        break;
      case 539: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy828 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy828), releaseRawExprNode(pCxt, yymsp[-1].minor.yy828)); }
        break;
      case 542: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy828 = addOrderByClause(pCxt, yymsp[-3].minor.yy828, yymsp[-2].minor.yy222);
                                                                                    yylhsminor.yy828 = addSlimitClause(pCxt, yylhsminor.yy828, yymsp[-1].minor.yy828);
                                                                                    yylhsminor.yy828 = addLimitClause(pCxt, yylhsminor.yy828, yymsp[0].minor.yy828);
                                                                                  }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 545: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy828 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy828, yymsp[0].minor.yy828); }
  yymsp[-3].minor.yy828 = yylhsminor.yy828;
        break;
      case 546: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy828 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy828, yymsp[0].minor.yy828); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 554: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 558: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==558);
{ yymsp[-1].minor.yy828 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 555: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 559: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==559);
{ yymsp[-3].minor.yy828 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 556: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 560: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==560);
{ yymsp[-3].minor.yy828 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 561: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy828 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy828); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 566: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy828 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy828), yymsp[-1].minor.yy158, yymsp[0].minor.yy675); }
  yymsp[-2].minor.yy828 = yylhsminor.yy828;
        break;
      case 567: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy158 = ORDER_ASC; }
        break;
      case 568: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy158 = ORDER_ASC; }
        break;
      case 569: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy158 = ORDER_DESC; }
        break;
      case 570: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy675 = NULL_ORDER_DEFAULT; }
        break;
      case 571: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy675 = NULL_ORDER_FIRST; }
        break;
      case 572: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy675 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
