/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 475
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EOrder yy88;
  EFillMode yy94;
  SToken yy129;
  SDataType yy184;
  SNodeList* yy274;
  int32_t yy310;
  bool yy337;
  int8_t yy353;
  int64_t yy359;
  EOperatorType yy440;
  SAlterOption yy595;
  SNode* yy712;
  ENullOrder yy907;
  EJoinType yy912;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             761
#define YYNRULE              581
#define YYNTOKEN             330
#define YY_MAX_SHIFT         760
#define YY_MIN_SHIFTREDUCE   1133
#define YY_MAX_SHIFTREDUCE   1713
#define YY_ERROR_ACTION      1714
#define YY_ACCEPT_ACTION     1715
#define YY_NO_ACTION         1716
#define YY_MIN_REDUCE        1717
#define YY_MAX_REDUCE        2297
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (3096)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */  1873, 2109, 2003,  428, 1875, 1869,  631,  427, 2096,  167,
 /*    10 */   650, 1729,   45,   43, 1641, 2091,  176, 2001,  637, 2091,
 /*    20 */   389,  613, 1490,   38,   37, 2268,  187,   44,   42,   41,
 /*    30 */    40,   39, 1937, 1571, 2127, 1488, 1783,  354, 1986,  367,
 /*    40 */   612,  182,  664, 1884,  106, 2269,  614, 2077, 1935,  666,
 /*    50 */   588, 2087, 2093,  588, 2268, 2087, 2093, 2268, 1566, 1517,
 /*    60 */   140, 2273,  660,  178,   18, 2268,  660, 2003, 1876, 2274,
 /*    70 */   182, 1496, 2274,  182, 2269,  614, 1924, 2269,  614,  380,
 /*    80 */  2108, 2272, 2000,  637, 2144, 2269, 2271,  328, 2110,  670,
 /*    90 */  2112, 2113,  665,  663,  660,  651, 2162,  757, 1258,  649,
 /*   100 */    14,  501,  734,  733,  732,  731,  399,  497,  730,  729,
 /*   110 */   143,  724,  723,  722,  721,  720,  719,  718,  156,  714,
 /*   120 */   713,  712,  398,  397,  709,  708,  707,  706,  705, 1515,
 /*   130 */   495, 1315,  496, 1753, 1260,  122, 1573, 1574,  121,  120,
 /*   140 */   119,  118,  117,  116,  115,  114,  113, 1306,  692,  691,
 /*   150 */   690, 1310,  689, 1312, 1313,  688,  685,  649, 1321,  682,
 /*   160 */  1323, 1324,  679,  676,  650,   61, 1546, 1556, 2273,  649,
 /*   170 */    38,   37, 1572, 1575,   44,   42,   41,   40,   39,   48,
 /*   180 */   132,  504, 1937,  496, 1753, 1517, 1491,  534, 1489,  352,
 /*   190 */  1515,   35,  292, 1710,  635,   38,   37, 1884, 1935,   44,
 /*   200 */    42,   41,   40,   39,  238,   38,   37,  273,  237,   44,
 /*   210 */    42,   41,   40,   39, 2109, 1494, 1495, 1518, 1545, 1548,
 /*   220 */  1549, 1550, 1551, 1552, 1553, 1554, 1555,  662,  658, 1564,
 /*   230 */  1565, 1567, 1568, 1569, 1570,    2,   45,   43,  166,  513,
 /*   240 */   636,  337,  625, 1513,  389, 1825, 1490, 2127, 1740,   48,
 /*   250 */   465,  346, 1739,  479,  625,  628,  478, 1571, 2044, 1488,
 /*   260 */  2077,  613,  666, 1680, 2070, 2268, 1703,   49,   89,  341,
 /*   270 */    61,  448,  366,  480,  568,  139,  450, 1516,  434, 2095,
 /*   280 */   612,  182, 1566,   13,   12, 2269,  614,  139,   18,  511,
 /*   290 */  2091, 1996, 1709, 2108, 2077, 1496, 1600, 2144, 2077,  608,
 /*   300 */   109, 2110,  670, 2112, 2113,  665,  240,  660, 1185,  274,
 /*   310 */  1184,  588,  179,   86, 2197, 2268, 2109,  185,  383, 2193,
 /*   320 */   334,  757,  355,  222,   14,   86, 2087, 2093,  370,  356,
 /*   330 */  2274,  182,  184,  273,  438, 2269,  614,  660, 1879, 1186,
 /*   340 */  2223,  627,  180, 2205, 2206, 1862,  137, 2210, 1516, 2127,
 /*   350 */  1880,   61, 1601,   92,  181, 2205, 2206,  667,  137, 2210,
 /*   360 */  1573, 1574, 2077,  476,  666,  251,  470,  469,  468,  467,
 /*   370 */   464,  463,  462,  461,  460,  456,  455,  454,  453,  336,
 /*   380 */   445,  444,  443, 1614,  440,  439,  353, 1931, 1932,  147,
 /*   390 */  1546, 1556, 1738, 1349, 1350, 2108, 1572, 1575,  566, 2144,
 /*   400 */   392,  185,  109, 2110,  670, 2112, 2113,  665,  161,  660,
 /*   410 */  1491,  564, 1489,  562, 2172,  368, 2197, 1886,  603,  185,
 /*   420 */   383, 2193,  185,  652, 1935, 2169,   34,  387, 1595, 1596,
 /*   430 */  1597, 1598, 1599, 1603, 1604, 1605, 1606,  625, 2077, 1494,
 /*   440 */  1495,  704, 1545, 1548, 1549, 1550, 1551, 1552, 1553, 1554,
 /*   450 */  1555,  662,  658, 1564, 1565, 1567, 1568, 1569, 1570,    2,
 /*   460 */    11,   45,   43,  394, 1421, 1422, 1930, 1932, 1514,  389,
 /*   470 */   139, 1490,  552,  551,  550, 1669,  548,  547, 1982,  542,
 /*   480 */   136,  546, 1571,  239, 1488,  545, 1737,  223, 2109,  190,
 /*   490 */   544,  549,  362,  361,  494, 1515,  543,  499, 1759, 1967,
 /*   500 */  1420, 1423,  171,  185,  609,  604,  597, 1566,  530,  526,
 /*   510 */   522,  518,  220,   18,   44,   42,   41,   40,   39,  650,
 /*   520 */  1496, 2127,  600,  599, 1667, 1668, 1670, 1671, 1672,  667,
 /*   530 */   100,  636, 2077,   65, 2077,   54,  666,  271, 2205,  624,
 /*   540 */   503,  133,  623,  499, 1759, 2268,  757,   61, 1937,   14,
 /*   550 */  1463, 1464, 1884,   87, 1877,  377,  218, 1645,  728,  726,
 /*   560 */   612,  182, 2127, 1515, 1935, 2269,  614, 2108,  165, 1718,
 /*   570 */   607, 2144, 1786,  312,  169, 2110,  670, 2112, 2113,  665,
 /*   580 */   634,  660, 1996, 2272,  702, 1573, 1574,  310,   72,  421,
 /*   590 */   122,   71, 1861,  121,  120,  119,  118,  117,  116,  115,
 /*   600 */   114,  113,  154,  153,  699,  698,  697,  151,  575,  205,
 /*   610 */   491,  489,  486,  423,  419, 1546, 1556,  606,   41,   40,
 /*   620 */    39, 1572, 1575,  217,  211,   11,  615, 2289,  216,   61,
 /*   630 */   509,  538,  426,  176,  425, 1491,  381, 1489,  552,  551,
 /*   640 */   550, 1404, 1405,  636,  164,  542,  136,  546,  209, 2095,
 /*   650 */    61,  545,  537, 1886,  452, 1987,  544,  549,  362,  361,
 /*   660 */  2091,  424,  543,  451, 1494, 1495, 1496, 1545, 1548, 1549,
 /*   670 */  1550, 1551, 1552, 1553, 1554, 1555,  662,  658, 1564, 1565,
 /*   680 */  1567, 1568, 1569, 1570,    2,   45,   43, 1576,  108, 1717,
 /*   690 */  1736, 1735,  645,  389, 1996, 1490, 2087, 2093,  371,  185,
 /*   700 */    11, 2109,    9, 1715,  702, 1871, 1571,  660, 1488, 1547,
 /*   710 */  1185, 1166, 1184,  131,  130,  129,  128,  127,  126,  125,
 /*   720 */   124,  123,  154,  153,  699,  698,  697,  151,   80,   79,
 /*   730 */   431, 1566,  650,  189, 2127,  650, 2077, 2077, 1171, 1172,
 /*   740 */  1734, 1186,  667,  650, 1496,  695,  472, 2077,  132,  666,
 /*   750 */  1168,  432, 1171, 1172,  335,  539, 1269,  417,  716,  433,
 /*   760 */   415,  411,  407,  404,  424, 1884, 2095, 1937, 1884, 1268,
 /*   770 */   757,  402, 1490,   46,  382,  401, 1884, 2091, 1860, 2109,
 /*   780 */  2108,  185, 2098, 1935, 2144, 1488, 2077,  109, 2110,  670,
 /*   790 */  2112, 2113,  665,  654,  660, 2169, 1867,  142, 1581,  149,
 /*   800 */  2168, 2197,  185,  650, 1515,  383, 2193,  198,  197, 1573,
 /*   810 */  1574,  625, 2127, 2087, 2093,  384, 1937,  164,  588,  442,
 /*   820 */   667, 1496, 2268,  393,  660, 2077, 1887,  666,  283,  284,
 /*   830 */   471,  481, 1935,  282,  194, 2100, 1884, 2274,  182, 1546,
 /*   840 */  1556,  704, 2269,  614,  139, 1572, 1575,  757,  650,   38,
 /*   850 */    37, 1518,  616,   44,   42,   41,   40,   39, 2108, 1491,
 /*   860 */  1273, 1489, 2144,  392,  457,  109, 2110,  670, 2112, 2113,
 /*   870 */   665,  164,  660, 1272, 1733,   83, 1515, 2170,   82, 2197,
 /*   880 */  1886, 1884, 1732,  383, 2193,   27, 2071, 1602, 1494, 1495,
 /*   890 */  1638, 1545, 1548, 1549, 1550, 1551, 1552, 1553, 1554, 1555,
 /*   900 */   662,  658, 1564, 1565, 1567, 1568, 1569, 1570,    2,   45,
 /*   910 */    43,  183, 2205, 2206,  395,  137, 2210,  389,  650, 1490,
 /*   920 */  2077, 2109,  164,  248, 2217, 1634,  650, 1731, 2077,   73,
 /*   930 */  1571, 1886, 1488,  588,  458,  483, 1491, 2268, 1489,   38,
 /*   940 */    37,  557,  512,   44,   42,   41,   40,   39, 2212,  694,
 /*   950 */  1547, 1884, 2274,  182, 2127, 1566,  567, 2269,  614, 1884,
 /*   960 */  1728,   32,  628, 2212, 2060, 1494, 1495, 2077, 1496,  666,
 /*   970 */   236, 1607, 1727, 2077, 2209,   38,   37, 1982,   81,   44,
 /*   980 */    42,   41,   40,   39,  717,  560, 1846,  650,  192, 2208,
 /*   990 */   554, 1726,    8,  152,  757,  235, 1725,   46, 1724,  191,
 /*  1000 */  2108, 1518, 1723, 1881, 2144, 2109, 2077,  109, 2110,  670,
 /*  1010 */  2112, 2113,  665, 1722,  660, 1721, 1720,   31, 2077,  179,
 /*  1020 */  1884, 2197, 1547,   38,   37,  383, 2193,   44,   42,   41,
 /*  1030 */    40,   39, 1657, 1573, 1574, 1859,   69, 2077, 2127,   68,
 /*  1040 */   141,  650, 2077, 2168, 2077, 1982,  667, 2224, 2077,  650,
 /*  1050 */    53, 2077, 1937,  666,  435, 2212,  196,  241,   51, 2077,
 /*  1060 */     3, 2077, 2077, 1546, 1556,  584,   33,  436, 1936, 1572,
 /*  1070 */  1575,  650,   38,   37, 1884,  617,   44,   42,   41,   40,
 /*  1080 */    39, 2207, 1884, 1491, 2108, 1489,  696,  629, 2144, 1928,
 /*  1090 */  2063,  109, 2110,  670, 2112, 2113,  665,  700,  660,  701,
 /*  1100 */  1928,  620, 1928,  653, 1884, 2197,  152, 2109,  306,  383,
 /*  1110 */  2193, 1914, 1494, 1495,  540, 1545, 1548, 1549, 1550, 1551,
 /*  1120 */  1552, 1553, 1554, 1555,  662,  658, 1564, 1565, 1567, 1568,
 /*  1130 */  1569, 1570,    2,   45,   43,  163, 1256,  587,  409, 1637,
 /*  1140 */  2127,  389,  650, 1490,  570,  650,  569,  702,  667,  250,
 /*  1150 */   145,  152,  134, 2077, 1571,  666, 1488,  228,  633,  573,
 /*  1160 */   226,  287,  245, 1458,  661,  154,  153,  699,  698,  697,
 /*  1170 */   151,  230,  359,  416,  229, 1884,   38,   37, 1884, 1566,
 /*  1180 */    44,   42,   41,   40,   39,  232, 2108,  650,  231,  249,
 /*  1190 */  2144,   63, 1496,  109, 2110,  670, 2112, 2113,  665,  650,
 /*  1200 */   660,  650, 1826,  647, 1634, 2288,  588, 2197, 1461,   52,
 /*  1210 */  2268,  383, 2193, 2109, 1499,  648,   63,  293,  757,  650,
 /*  1220 */  1884,   14, 2231, 1773,  234, 2274,  182,  233, 1766,  255,
 /*  1230 */  2269,  614, 1884,   90, 1884,  396, 2109, 1498,  360,  105,
 /*  1240 */   358,  357, 1764,  536,  541,  553, 2127,  538, 1666,  102,
 /*  1250 */   555, 2273, 1884,  152,  667, 2268, 1730, 1573, 1574, 2077,
 /*  1260 */  2237,  666, 1712, 1713,  558,  268, 1254,  710,  537, 2127,
 /*  1270 */   601, 2272,  657, 1665,   47, 2269, 2270,  667,  280,   13,
 /*  1280 */    12,   70, 2077,  221,  666,  262,  257, 1546, 1556, 1234,
 /*  1290 */  2128,  400, 2108, 1572, 1575, 1991, 2144, 1754, 1215,  110,
 /*  1300 */  2110,  670, 2112, 2113,  665,  618,  660, 1491,  150, 1489,
 /*  1310 */   632,  152, 1925, 2197,   63, 2108,   47, 2196, 2193, 2144,
 /*  1320 */    47,  674,  168, 2110,  670, 2112, 2113,  665, 2109,  660,
 /*  1330 */  2227, 1418,  150,  621, 1216,  285, 1494, 1495,  642, 1545,
 /*  1340 */  1548, 1549, 1550, 1551, 1552, 1553, 1554, 1555,  662,  658,
 /*  1350 */  1564, 1565, 1567, 1568, 1569, 1570,    2,  711,  626,  270,
 /*  1360 */   267, 2127,    1,  589, 2234,  289,    4, 1502, 1299,  667,
 /*  1370 */   152, 1608,  135, 1557, 2077,  403,  666,  305, 1327, 1232,
 /*  1380 */   150, 1760,  408,  350, 1441,  300,  437,  195, 1518, 1331,
 /*  1390 */  1501, 1992,  441,  446,  474,  459, 1513, 1984, 2109,  466,
 /*  1400 */   484,  473,  475,  485,  482,  199,  487, 2108,  488,  200,
 /*  1410 */   202, 2144,  490,  492,  109, 2110,  670, 2112, 2113,  665,
 /*  1420 */  1519,  660,  493, 1592,  502, 1521, 2288, 1338, 2197, 1336,
 /*  1430 */   752, 2127,  383, 2193,  505,  208, 1516,  155,  210,  667,
 /*  1440 */  1520,  506,  507, 2244, 2077, 1522,  666,  508,  510, 2109,
 /*  1450 */   213,  215,   84, 1188,  514,  531,   85,  219,  532,  533,
 /*  1460 */   535, 1874,  225, 1870,  227,  157,  111,  340,  158,  572,
 /*  1470 */    88, 2053, 2050,  578,  574,  148,  579, 2108,  242,  244,
 /*  1480 */   301, 2144, 2127, 1872,  109, 2110,  670, 2112, 2113,  665,
 /*  1490 */   667,  660,  577, 1868,  159, 2077, 2288,  666, 2197,  386,
 /*  1500 */   385, 2049,  383, 2193,  160,  246, 1448,  585, 2228, 1504,
 /*  1510 */   582,  602, 2238,  595,    7,  592, 2243,  640,  611,  583,
 /*  1520 */  1571,  598, 1497,  372, 2109,  605,  593,  373, 2108,  591,
 /*  1530 */  2242,  253, 2144,  261,  256,  109, 2110,  670, 2112, 2113,
 /*  1540 */   665, 2219,  660,  622,  590, 1566, 2267, 2288,  619, 2197,
 /*  1550 */  1634, 2291,  269,  383, 2193,  138, 1517, 2127, 1496,  266,
 /*  1560 */   630, 2213,  376,  275, 2262,  667,   95, 1523, 1997,  302,
 /*  1570 */  2077,  638,  666,  172,  639, 2011, 2010, 2009,  303,  643,
 /*  1580 */   379,  644,   60,  264,  656,   97,  304, 1885,  263,   99,
 /*  1590 */  2178, 1929,  101,  265, 1847,  672,  296,  307,  753,  342,
 /*  1600 */    50,  754,  331, 2108,  756,  343,  316, 2144,  330,  576,
 /*  1610 */   109, 2110,  670, 2112, 2113,  665,  311,  660,  320,  309,
 /*  1620 */  2069, 2068, 2288, 2067, 2197,   77, 2064,  760,  383, 2193,
 /*  1630 */   405,  406, 1481, 1482,  188,  410, 2062,  412,  413, 2216,
 /*  1640 */   414,  299, 2061, 2109,  351, 2059,  418, 2058, 2057,  420,
 /*  1650 */   422,   78, 1444, 1443, 2023, 2022,  175, 2021,  429,  430,
 /*  1660 */  2020, 2019,  750,  746,  742,  738,  297, 1975, 1974, 1395,
 /*  1670 */  1972,  144, 1971, 1505, 1970, 1500, 2127,  193,  447, 1963,
 /*  1680 */   449, 1977, 1962, 1961,  667, 1973, 1969, 1968, 1966, 2077,
 /*  1690 */  1965,  666, 1964, 1960, 1959, 1958, 1957, 1956, 1955, 1954,
 /*  1700 */  1953, 1952, 1508, 1510, 1951, 1950, 1949,  107, 2109, 1948,
 /*  1710 */   290,  146, 1947, 1946, 1945,  658, 1564, 1565, 1567, 1568,
 /*  1720 */  1569, 1570, 2108, 1976, 1944, 1943, 2144, 1942, 1941,  110,
 /*  1730 */  2110,  670, 2112, 2113,  665, 1940,  660, 1397, 1939,  477,
 /*  1740 */  1938, 2127,  646, 2197, 1270,  338,  339,  655, 2193,  667,
 /*  1750 */  1789, 1274, 1266, 1788, 2077, 1787,  666, 1785, 1749,   75,
 /*  1760 */   201,  206,  177, 2097, 1748,  203,  204, 2040, 1174,   76,
 /*  1770 */  1173, 2030, 2018, 2109,  207,  212, 2017,  277,  498,  500,
 /*  1780 */  1995, 1863,  276,  214, 1784, 1782, 1208,  668,  517,  516,
 /*  1790 */  1780, 2144,  520, 1778,  110, 2110,  670, 2112, 2113,  665,
 /*  1800 */   515,  660,  243,  519,  523,  521, 2127,  524, 2197,  525,
 /*  1810 */  1776,  528,  345, 2193,  667, 1763,  529,  527, 1762, 2077,
 /*  1820 */  1745,  666, 1865, 1343, 2109, 1342, 1864, 1257, 1244, 1255,
 /*  1830 */   725, 1253, 1252, 1251, 1250,   62, 1249, 1246, 1774, 1245,
 /*  1840 */   224,  363, 1243, 2109,  727, 1767,  364, 1765,  559,  365,
 /*  1850 */  1744,  561, 2108, 1743, 1742,  556, 2144, 2127,  563,  110,
 /*  1860 */  2110,  670, 2112, 2113,  665,  667,  660, 1468,  565,  112,
 /*  1870 */  2077, 1470,  666, 2197, 1467,   26, 2127, 2039, 2194, 1472,
 /*  1880 */  1452, 2029, 1454,   66,  667,  580, 1450, 2016, 2014, 2077,
 /*  1890 */    16,  666, 2273,   20,   64,   17,   19, 2015, 2013,  162,
 /*  1900 */    58,   59, 1697, 2108,  596,   55,  259, 2144,   28,  247,
 /*  1910 */   168, 2110,  670, 2112, 2113,  665,  581,  660, 2109,  369,
 /*  1920 */   586,  252, 2108,  260,    5, 2098, 2144,  594,   30,  322,
 /*  1930 */  2110,  670, 2112, 2113,  665, 1682,  660, 2109,    6,   21,
 /*  1940 */  1696,  254, 1664,  170,  258,  374, 1701, 1700,   29,  375,
 /*  1950 */   272, 2127, 2235,   57,  173, 2012, 1656, 1994,  641,  667,
 /*  1960 */    91,   56, 1702,   94, 2077, 1703,  666, 1631,  278, 1630,
 /*  1970 */  2127,   93,   22,  610,  279,  378, 1662, 1993,  667,  281,
 /*  1980 */   286,   96,   67, 2077,  102,  666,  288,  291,   23,   10,
 /*  1990 */    12, 1583,   98, 1506, 1582, 1561,  174, 2108,  186, 2147,
 /*  2000 */   659, 2144, 1559, 1558,  169, 2110,  670, 2112, 2113,  665,
 /*  2010 */  2109,  660, 1538,   36,  673,   15, 2108,   24,  391, 1530,
 /*  2020 */  2144,  677,   25,  329, 2110,  670, 2112, 2113,  665, 1593,
 /*  2030 */   660,  671, 1328,  675,  680, 1325, 2109,  678,  683, 1322,
 /*  2040 */  1316,  681,  686, 2127, 1314,  684,  687,  669, 1320, 1319,
 /*  2050 */  1318,  664, 1317, 1305,  103,  294, 2077, 2290,  666,  693,
 /*  2060 */   104, 1337,   74, 1333, 1240, 1206,  703, 1239, 1238, 2127,
 /*  2070 */  1237, 1236, 1264, 1235,  388, 1233, 1224,  667, 1231, 1230,
 /*  2080 */  1229, 1227, 2077,  295,  666,  715, 1226, 1225, 1223, 2108,
 /*  2090 */  1222, 1221, 1261, 2144, 1259, 1218,  328, 2110,  670, 2112,
 /*  2100 */  2113,  665, 1217,  660, 1214, 2163, 1213, 2109, 1212, 1211,
 /*  2110 */  1781,  735,  736, 1779,  737, 2108,  739,  741,  740, 2144,
 /*  2120 */  1777,  744,  329, 2110,  670, 2112, 2113,  665, 2109,  660,
 /*  2130 */   743,  745, 1775,  748,  747,  749, 1761,  751, 1163, 1741,
 /*  2140 */  2127,  298,  755,  759, 1492,  390,  308,  758,  667, 1716,
 /*  2150 */  1716, 1716, 1716, 2077, 1716,  666, 1716, 1716, 2109, 1716,
 /*  2160 */  1716, 2127, 1716, 1716, 1716, 1716, 1716, 1716, 1716,  667,
 /*  2170 */  1716, 1716, 1716, 1716, 2077, 1716,  666, 1716, 1716, 1716,
 /*  2180 */  1716, 1716, 1716, 1716, 1716, 1716, 2108, 1716, 1716, 1716,
 /*  2190 */  2144, 2127, 1716,  329, 2110,  670, 2112, 2113,  665,  667,
 /*  2200 */   660, 1716, 1716, 1716, 2077, 1716,  666,  571, 1716, 1716,
 /*  2210 */  1716, 2144, 1716, 1716,  324, 2110,  670, 2112, 2113,  665,
 /*  2220 */  1716,  660, 1716, 2109, 1716, 1716, 1716, 1716, 1716, 1716,
 /*  2230 */  1716, 1716, 1716, 1716, 1716, 1716, 1716, 2108, 1716, 1716,
 /*  2240 */  1716, 2144, 1716, 1716,  313, 2110,  670, 2112, 2113,  665,
 /*  2250 */  1716,  660, 2109, 1716, 1716, 1716, 2127, 1716, 1716, 1716,
 /*  2260 */  1716, 1716, 1716, 1716,  667, 1716, 1716, 1716, 1716, 2077,
 /*  2270 */  1716,  666, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716,
 /*  2280 */  1716, 1716, 1716, 1716, 1716, 2127, 2109, 1716, 1716, 1716,
 /*  2290 */  1716, 1716, 1716,  667, 1716, 1716, 1716, 1716, 2077, 1716,
 /*  2300 */   666, 1716, 2108, 1716, 1716, 1716, 2144, 1716, 1716,  314,
 /*  2310 */  2110,  670, 2112, 2113,  665, 1716,  660, 1716, 1716, 2127,
 /*  2320 */  1716, 1716, 1716, 1716, 1716, 1716, 1716,  667, 1716, 1716,
 /*  2330 */  1716, 2108, 2077, 1716,  666, 2144, 1716, 1716,  315, 2110,
 /*  2340 */   670, 2112, 2113,  665, 1716,  660, 1716, 1716, 1716, 1716,
 /*  2350 */  2109, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716,
 /*  2360 */  1716, 1716, 1716, 1716, 1716, 2108, 1716, 1716, 1716, 2144,
 /*  2370 */  2109, 1716,  321, 2110,  670, 2112, 2113,  665, 1716,  660,
 /*  2380 */  1716, 1716, 1716, 2127, 1716, 1716, 1716, 1716, 1716, 1716,
 /*  2390 */  1716,  667, 1716, 1716, 1716, 1716, 2077, 1716,  666, 1716,
 /*  2400 */  1716, 1716, 1716, 2127, 1716, 1716, 1716, 1716, 1716, 1716,
 /*  2410 */  1716,  667, 1716, 1716, 1716, 1716, 2077, 1716,  666, 1716,
 /*  2420 */  1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 2108,
 /*  2430 */  1716, 2109, 1716, 2144, 1716, 1716,  325, 2110,  670, 2112,
 /*  2440 */  2113,  665, 1716,  660, 1716, 1716, 1716, 1716, 1716, 2108,
 /*  2450 */  1716, 1716, 1716, 2144, 1716, 1716,  317, 2110,  670, 2112,
 /*  2460 */  2113,  665, 1716,  660, 2127, 1716, 1716, 1716, 1716, 1716,
 /*  2470 */  1716, 1716,  667, 1716, 1716, 1716, 1716, 2077, 1716,  666,
 /*  2480 */  1716, 1716, 2109, 1716, 1716, 1716, 1716, 1716, 1716, 1716,
 /*  2490 */  1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716,
 /*  2500 */  1716, 1716, 1716, 2109, 1716, 1716, 1716, 1716, 1716, 1716,
 /*  2510 */  2108, 1716, 1716, 1716, 2144, 2127, 1716,  326, 2110,  670,
 /*  2520 */  2112, 2113,  665,  667,  660, 1716, 1716, 1716, 2077, 1716,
 /*  2530 */   666, 1716, 1716, 2109, 1716, 1716, 2127, 1716, 1716, 1716,
 /*  2540 */  1716, 1716, 1716, 1716,  667, 1716, 1716, 1716, 1716, 2077,
 /*  2550 */  1716,  666, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716,
 /*  2560 */  1716, 2108, 1716, 1716, 1716, 2144, 2127, 1716,  318, 2110,
 /*  2570 */   670, 2112, 2113,  665,  667,  660, 1716, 1716, 1716, 2077,
 /*  2580 */  1716,  666, 2108, 1716, 1716, 1716, 2144, 1716, 1716,  327,
 /*  2590 */  2110,  670, 2112, 2113,  665, 1716,  660, 1716, 2109, 1716,
 /*  2600 */  1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716,
 /*  2610 */  1716, 1716, 2108, 1716, 1716, 1716, 2144, 1716, 1716,  319,
 /*  2620 */  2110,  670, 2112, 2113,  665, 1716,  660, 2109, 1716, 1716,
 /*  2630 */  1716, 2127, 1716, 1716, 1716, 1716, 1716, 1716, 1716,  667,
 /*  2640 */  1716, 1716, 1716, 1716, 2077, 1716,  666, 1716, 1716, 1716,
 /*  2650 */  1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716,
 /*  2660 */  2127, 2109, 1716, 1716, 1716, 1716, 1716, 1716,  667, 1716,
 /*  2670 */  1716, 1716, 1716, 2077, 1716,  666, 1716, 2108, 1716, 1716,
 /*  2680 */  1716, 2144, 1716, 1716,  332, 2110,  670, 2112, 2113,  665,
 /*  2690 */  1716,  660, 1716, 1716, 2127, 1716, 1716, 1716, 1716, 1716,
 /*  2700 */  1716, 1716,  667, 1716, 1716, 1716, 2108, 2077, 1716,  666,
 /*  2710 */  2144, 1716, 1716,  333, 2110,  670, 2112, 2113,  665, 1716,
 /*  2720 */   660, 1716, 1716, 1716, 1716, 2109, 1716, 1716, 1716, 1716,
 /*  2730 */  1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716,
 /*  2740 */  2108, 1716, 1716, 1716, 2144, 2109, 1716, 2121, 2110,  670,
 /*  2750 */  2112, 2113,  665, 1716,  660, 1716, 1716, 1716, 2127, 1716,
 /*  2760 */  1716, 1716, 1716, 1716, 1716, 1716,  667, 1716, 1716, 1716,
 /*  2770 */  1716, 2077, 1716,  666, 1716, 1716, 1716, 1716, 2127, 1716,
 /*  2780 */  1716, 1716, 1716, 1716, 1716, 1716,  667, 1716, 1716, 1716,
 /*  2790 */  1716, 2077, 1716,  666, 1716, 1716, 1716, 1716, 1716, 1716,
 /*  2800 */  1716, 1716, 1716, 1716, 2108, 1716, 2109, 1716, 2144, 1716,
 /*  2810 */  1716, 2120, 2110,  670, 2112, 2113,  665, 1716,  660, 1716,
 /*  2820 */  1716, 1716, 1716, 1716, 2108, 1716, 1716, 1716, 2144, 1716,
 /*  2830 */  1716, 2119, 2110,  670, 2112, 2113,  665, 1716,  660, 2127,
 /*  2840 */  1716, 1716, 1716, 1716, 1716, 1716, 1716,  667, 1716, 1716,
 /*  2850 */  1716, 1716, 2077, 1716,  666, 1716, 1716, 2109, 1716, 1716,
 /*  2860 */  1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716,
 /*  2870 */  1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 2109, 1716,
 /*  2880 */  1716, 1716, 1716, 1716, 1716, 2108, 1716, 1716, 1716, 2144,
 /*  2890 */  2127, 1716,  347, 2110,  670, 2112, 2113,  665,  667,  660,
 /*  2900 */  1716, 1716, 1716, 2077, 1716,  666, 1716, 1716, 2109, 1716,
 /*  2910 */  1716, 2127, 1716, 1716, 1716, 1716, 1716, 1716, 1716,  667,
 /*  2920 */  1716, 1716, 1716, 1716, 2077, 1716,  666, 1716, 1716, 1716,
 /*  2930 */  1716, 1716, 1716, 1716, 1716, 1716, 2108, 1716, 1716, 1716,
 /*  2940 */  2144, 2127, 1716,  348, 2110,  670, 2112, 2113,  665,  667,
 /*  2950 */   660, 1716, 1716, 1716, 2077, 1716,  666, 2108, 1716, 1716,
 /*  2960 */  1716, 2144, 1716, 1716,  344, 2110,  670, 2112, 2113,  665,
 /*  2970 */  1716,  660, 1716, 2109, 1716, 1716, 1716, 1716, 1716, 1716,
 /*  2980 */  1716, 1716, 1716, 1716, 1716, 1716, 1716, 2108, 1716, 1716,
 /*  2990 */  1716, 2144, 1716, 1716,  349, 2110,  670, 2112, 2113,  665,
 /*  3000 */  1716,  660, 2109, 1716, 1716, 1716, 2127, 1716, 1716, 1716,
 /*  3010 */  1716, 1716, 1716, 1716,  667, 1716, 1716, 1716, 1716, 2077,
 /*  3020 */  1716,  666, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716,
 /*  3030 */  1716, 1716, 1716, 1716, 1716, 2127, 1716, 1716, 1716, 1716,
 /*  3040 */  1716, 1716, 1716,  667, 1716, 1716, 1716, 1716, 2077, 1716,
 /*  3050 */   666, 1716,  668, 1716, 1716, 1716, 2144, 1716, 1716,  324,
 /*  3060 */  2110,  670, 2112, 2113,  665, 1716,  660, 1716, 1716, 1716,
 /*  3070 */  1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716, 1716,
 /*  3080 */  1716, 2108, 1716, 1716, 1716, 2144, 1716, 1716,  323, 2110,
 /*  3090 */   670, 2112, 2113,  665, 1716,  660,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   367,  333,  381,  398,  368,  367,  398,  402,  368,  332,
 /*    10 */   341,  334,   12,   13,   14,  379,  366,  396,  397,  379,
 /*    20 */    20,  445,   22,    8,    9,  449,  357,   12,   13,   14,
 /*    30 */    15,   16,  366,   33,  366,   35,    0,  387,  388,  373,
 /*    40 */   464,  465,  374,  374,  345,  469,  470,  379,  382,  381,
 /*    50 */   445,  415,  416,  445,  449,  415,  416,  449,   58,   20,
 /*    60 */   361,  445,  426,  365,   64,  449,  426,  381,  369,  464,
 /*    70 */   465,   71,  464,  465,  469,  470,  378,  469,  470,  393,
 /*    80 */   412,  465,  396,  397,  416,  469,  470,  419,  420,  421,
 /*    90 */   422,  423,  424,  425,  426,  427,  428,   97,   35,   20,
 /*   100 */   100,   14,   66,   67,   68,   69,   70,   20,   72,   73,
 /*   110 */    74,   75,   76,   77,   78,   79,   80,   81,   82,   83,
 /*   120 */    84,   85,   86,   87,   88,   89,   90,   91,   92,   20,
 /*   130 */   337,   97,  339,  340,   71,   21,  136,  137,   24,   25,
 /*   140 */    26,   27,   28,   29,   30,   31,   32,  113,  114,  115,
 /*   150 */   116,  117,  118,  119,  120,  121,  122,   20,  124,  125,
 /*   160 */   126,  127,  128,  129,  341,  100,  166,  167,    3,   20,
 /*   170 */     8,    9,  172,  173,   12,   13,   14,   15,   16,  100,
 /*   180 */   357,  337,  366,  339,  340,   20,  186,  364,  188,  373,
 /*   190 */    20,  434,  435,  178,   20,    8,    9,  374,  382,   12,
 /*   200 */    13,   14,   15,   16,  131,    8,    9,  168,  135,   12,
 /*   210 */    13,   14,   15,   16,  333,  215,  216,   20,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,  228,  229,
 /*   230 */   230,  231,  232,  233,  234,  235,   12,   13,  348,   63,
 /*   240 */   341,   18,  341,   20,   20,  355,   22,  366,  333,  100,
 /*   250 */    27,   64,  333,   30,  341,  374,   33,   33,  362,   35,
 /*   260 */   379,  445,  381,  101,  398,  449,  101,  100,  195,  196,
 /*   270 */   100,   48,  199,   50,  201,  374,   53,   20,  341,  368,
 /*   280 */   464,  465,   58,    1,    2,  469,  470,  374,   64,  390,
 /*   290 */   379,  392,  277,  412,  379,   71,  109,  416,  379,   20,
 /*   300 */   419,  420,  421,  422,  423,  424,  410,  426,   20,   58,
 /*   310 */    22,  445,  431,  347,  433,  449,  333,  252,  437,  438,
 /*   320 */   383,   97,   99,   35,  100,  347,  415,  416,  417,  363,
 /*   330 */   464,  465,  451,  168,  111,  469,  470,  426,  372,   51,
 /*   340 */   459,  440,  441,  442,  443,    0,  445,  446,   20,  366,
 /*   350 */   372,  100,  165,  102,  441,  442,  443,  374,  445,  446,
 /*   360 */   136,  137,  379,  140,  381,  168,  143,  144,  145,  146,
 /*   370 */   147,  148,  149,  150,  151,  152,  153,  154,  155,  156,
 /*   380 */   157,  158,  159,  101,  161,  162,  163,  380,  381,   44,
 /*   390 */   166,  167,  333,  136,  137,  412,  172,  173,   21,  416,
 /*   400 */   358,  252,  419,  420,  421,  422,  423,  424,  366,  426,
 /*   410 */   186,   34,  188,   36,  431,  373,  433,  375,  171,  252,
 /*   420 */   437,  438,  252,  430,  382,  432,  239,  240,  241,  242,
 /*   430 */   243,  244,  245,  246,  247,  248,  249,  341,  379,  215,
 /*   440 */   216,   63,  218,  219,  220,  221,  222,  223,  224,  225,
 /*   450 */   226,  227,  228,  229,  230,  231,  232,  233,  234,  235,
 /*   460 */   236,   12,   13,  377,  136,  137,  380,  381,   20,   20,
 /*   470 */   374,   22,   66,   67,   68,  215,  352,  353,  374,   73,
 /*   480 */    74,   75,   33,  130,   35,   79,  333,   33,  333,  385,
 /*   490 */    84,   85,   86,   87,  338,   20,   90,  341,  342,    0,
 /*   500 */   172,  173,   48,  252,  257,  258,  259,   58,   54,   55,
 /*   510 */    56,   57,   58,   64,   12,   13,   14,   15,   16,  341,
 /*   520 */    71,  366,  262,  263,  264,  265,  266,  267,  268,  374,
 /*   530 */   345,  341,  379,    4,  379,  357,  381,  441,  442,  443,
 /*   540 */   338,  445,  446,  341,  342,  449,   97,  100,  366,  100,
 /*   550 */   197,  198,  374,   99,  369,  373,  102,   14,  352,  353,
 /*   560 */   464,  465,  366,   20,  382,  469,  470,  412,   18,    0,
 /*   570 */   374,  416,    0,   23,  419,  420,  421,  422,  423,  424,
 /*   580 */   390,  426,  392,    3,  112,  136,  137,   37,   38,  181,
 /*   590 */    21,   41,    0,   24,   25,   26,   27,   28,   29,   30,
 /*   600 */    31,   32,  130,  131,  132,  133,  134,  135,  111,   59,
 /*   610 */    60,   61,   62,  205,  206,  166,  167,  421,   14,   15,
 /*   620 */    16,  172,  173,  169,  170,  236,  471,  472,  174,  100,
 /*   630 */   176,  112,  185,  366,  187,  186,  358,  188,   66,   67,
 /*   640 */    68,  166,  167,  341,  366,   73,   74,   75,  194,  368,
 /*   650 */   100,   79,  133,  375,  155,  388,   84,   85,   86,   87,
 /*   660 */   379,  214,   90,  164,  215,  216,   71,  218,  219,  220,
 /*   670 */   221,  222,  223,  224,  225,  226,  227,  228,  229,  230,
 /*   680 */   231,  232,  233,  234,  235,   12,   13,   14,  138,    0,
 /*   690 */   333,  333,  390,   20,  392,   22,  415,  416,  417,  252,
 /*   700 */   236,  333,  238,  330,  112,  367,   33,  426,   35,  166,
 /*   710 */    20,    4,   22,   24,   25,   26,   27,   28,   29,   30,
 /*   720 */    31,   32,  130,  131,  132,  133,  134,  135,  178,  179,
 /*   730 */   180,   58,  341,  183,  366,  341,  379,  379,   45,   46,
 /*   740 */   333,   51,  374,  341,   71,  111,   80,  379,  357,  381,
 /*   750 */    43,  357,   45,   46,  204,  364,   22,  207,   71,  357,
 /*   760 */   210,  211,  212,  213,  214,  374,  368,  366,  374,   35,
 /*   770 */    97,  398,   22,  100,  373,  402,  374,  379,    0,  333,
 /*   780 */   412,  252,   47,  382,  416,   35,  379,  419,  420,  421,
 /*   790 */   422,  423,  424,  430,  426,  432,  367,  429,   14,  431,
 /*   800 */   432,  433,  252,  341,   20,  437,  438,  141,  142,  136,
 /*   810 */   137,  341,  366,  415,  416,  417,  366,  366,  445,  357,
 /*   820 */   374,   71,  449,  373,  426,  379,  375,  381,  130,  131,
 /*   830 */   164,   97,  382,  135,   58,  100,  374,  464,  465,  166,
 /*   840 */   167,   63,  469,  470,  374,  172,  173,   97,  341,    8,
 /*   850 */     9,   20,  272,   12,   13,   14,   15,   16,  412,  186,
 /*   860 */    22,  188,  416,  358,  357,  419,  420,  421,  422,  423,
 /*   870 */   424,  366,  426,   35,  333,   99,   20,  431,  102,  433,
 /*   880 */   375,  374,  333,  437,  438,   44,  398,  165,  215,  216,
 /*   890 */     4,  218,  219,  220,  221,  222,  223,  224,  225,  226,
 /*   900 */   227,  228,  229,  230,  231,  232,  233,  234,  235,   12,
 /*   910 */    13,  441,  442,  443,  358,  445,  446,   20,  341,   22,
 /*   920 */   379,  333,  366,  403,  250,  251,  341,  333,  379,  111,
 /*   930 */    33,  375,   35,  445,  357,   97,  186,  449,  188,    8,
 /*   940 */     9,    4,  357,   12,   13,   14,   15,   16,  418,  367,
 /*   950 */   166,  374,  464,  465,  366,   58,   19,  469,  470,  374,
 /*   960 */   333,  239,  374,  418,    0,  215,  216,  379,   71,  381,
 /*   970 */    33,  249,  333,  379,  444,    8,    9,  374,  160,   12,
 /*   980 */    13,   14,   15,   16,  354,   48,  356,  341,  385,  444,
 /*   990 */    53,  333,   39,   44,   97,   58,  333,  100,  333,  168,
 /*  1000 */   412,   20,  333,  357,  416,  333,  379,  419,  420,  421,
 /*  1010 */   422,  423,  424,  333,  426,  333,  333,    2,  379,  431,
 /*  1020 */   374,  433,  166,    8,    9,  437,  438,   12,   13,   14,
 /*  1030 */    15,   16,  101,  136,  137,    0,   99,  379,  366,  102,
 /*  1040 */   429,  341,  379,  432,  379,  374,  374,  459,  379,  341,
 /*  1050 */   101,  379,  366,  381,   22,  418,  385,  357,   42,  379,
 /*  1060 */    44,  379,  379,  166,  167,  357,    2,   35,  382,  172,
 /*  1070 */   173,  341,    8,    9,  374,   44,   12,   13,   14,   15,
 /*  1080 */    16,  444,  374,  186,  412,  188,  376,  357,  416,  379,
 /*  1090 */     0,  419,  420,  421,  422,  423,  424,  376,  426,  376,
 /*  1100 */   379,   44,  379,  431,  374,  433,   44,  333,  359,  437,
 /*  1110 */   438,  362,  215,  216,   13,  218,  219,  220,  221,  222,
 /*  1120 */   223,  224,  225,  226,  227,  228,  229,  230,  231,  232,
 /*  1130 */   233,  234,  235,   12,   13,  168,   35,   96,   48,  253,
 /*  1140 */   366,   20,  341,   22,  200,  341,  202,  112,  374,  168,
 /*  1150 */    42,   44,   44,  379,   33,  381,   35,  104,  357,  398,
 /*  1160 */   107,  357,  367,  101,  367,  130,  131,  132,  133,  134,
 /*  1170 */   135,  104,   37,  209,  107,  374,    8,    9,  374,   58,
 /*  1180 */    12,   13,   14,   15,   16,  104,  412,  341,  107,   58,
 /*  1190 */   416,   44,   71,  419,  420,  421,  422,  423,  424,  341,
 /*  1200 */   426,  341,  355,  357,  251,  431,  445,  433,  101,  168,
 /*  1210 */   449,  437,  438,  333,   35,  357,   44,  357,   97,  341,
 /*  1220 */   374,  100,  448,    0,  104,  464,  465,  107,    0,   44,
 /*  1230 */   469,  470,  374,  102,  374,  357,  333,   35,  103,  100,
 /*  1240 */   105,  106,    0,  108,   13,   22,  366,  112,  101,  110,
 /*  1250 */    22,  445,  374,   44,  374,  449,  334,  136,  137,  379,
 /*  1260 */   389,  381,  136,  137,   22,  473,   35,   13,  133,  366,
 /*  1270 */   462,  465,   64,  101,   44,  469,  470,  374,   44,    1,
 /*  1280 */     2,   44,  379,  343,  381,  456,  101,  166,  167,   35,
 /*  1290 */   366,  343,  412,  172,  173,  389,  416,  340,   35,  419,
 /*  1300 */   420,  421,  422,  423,  424,  274,  426,  186,   44,  188,
 /*  1310 */   101,   44,  378,  433,   44,  412,   44,  437,  438,  416,
 /*  1320 */    44,   44,  419,  420,  421,  422,  423,  424,  333,  426,
 /*  1330 */   389,  101,   44,  276,   71,  101,  215,  216,  101,  218,
 /*  1340 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  228,
 /*  1350 */   229,  230,  231,  232,  233,  234,  235,   13,  447,  466,
 /*  1360 */   439,  366,  450,  460,  461,  101,  254,  188,  101,  374,
 /*  1370 */    44,  101,   44,  101,  379,  414,  381,  101,  101,   35,
 /*  1380 */    44,    0,   48,  413,  184,  400,  386,   42,   20,  101,
 /*  1390 */   188,  389,  386,  384,  165,  341,   20,  341,  333,  386,
 /*  1400 */    98,  384,  384,  351,   95,  350,   94,  412,  349,  341,
 /*  1410 */   341,  416,  341,  341,  419,  420,  421,  422,  423,  424,
 /*  1420 */    20,  426,  335,  215,  335,   20,  431,  101,  433,  101,
 /*  1430 */    49,  366,  437,  438,  407,  347,   20,  101,  347,  374,
 /*  1440 */    20,  381,  342,  448,  379,   20,  381,  399,  342,  333,
 /*  1450 */   347,  347,  347,   52,  341,  344,  347,  347,  344,  335,
 /*  1460 */   366,  366,  366,  366,  366,  366,  341,  335,  366,  203,
 /*  1470 */   100,  379,  379,  192,  411,  409,  406,  412,  345,  405,
 /*  1480 */   407,  416,  366,  366,  419,  420,  421,  422,  423,  424,
 /*  1490 */   374,  426,  191,  366,  366,  379,  431,  381,  433,   12,
 /*  1500 */    13,  379,  437,  438,  366,  345,  190,  341,  389,   22,
 /*  1510 */   381,  261,  389,  448,  269,  379,  455,  260,  177,  404,
 /*  1520 */    33,  379,   35,  379,  333,  379,  271,  278,  412,  270,
 /*  1530 */   455,  394,  416,  457,  394,  419,  420,  421,  422,  423,
 /*  1540 */   424,  458,  426,  275,  255,   58,  468,  431,  273,  433,
 /*  1550 */   251,  474,  467,  437,  438,  374,   20,  366,   71,  414,
 /*  1560 */   341,  418,  342,  345,  448,  374,  345,   20,  392,  394,
 /*  1570 */   379,  379,  381,  455,  379,  379,  379,  379,  394,  170,
 /*  1580 */   379,  391,  100,  453,   97,  345,  362,  374,  454,  345,
 /*  1590 */   436,  379,  100,  452,  356,  370,  345,  341,   36,  395,
 /*  1600 */   401,  336,  408,  412,  335,  395,  360,  416,  360,    1,
 /*  1610 */   419,  420,  421,  422,  423,  424,  331,  426,  360,  346,
 /*  1620 */     0,    0,  431,    0,  433,   42,    0,   19,  437,  438,
 /*  1630 */    35,  208,   35,   35,   35,  208,    0,   35,   35,  448,
 /*  1640 */   208,   33,    0,  333,  208,    0,   35,    0,    0,   22,
 /*  1650 */    35,  195,  188,  186,    0,    0,   48,    0,  182,  181,
 /*  1660 */     0,    0,   54,   55,   56,   57,   58,    0,    0,   47,
 /*  1670 */     0,   42,    0,  186,    0,  188,  366,  155,   35,    0,
 /*  1680 */   155,    0,    0,    0,  374,    0,    0,    0,    0,  379,
 /*  1690 */     0,  381,    0,    0,    0,    0,    0,    0,    0,    0,
 /*  1700 */     0,    0,  215,  216,    0,    0,    0,   99,  333,    0,
 /*  1710 */   102,   42,    0,    0,    0,  228,  229,  230,  231,  232,
 /*  1720 */   233,  234,  412,    0,    0,    0,  416,    0,    0,  419,
 /*  1730 */   420,  421,  422,  423,  424,    0,  426,   22,    0,  139,
 /*  1740 */     0,  366,  134,  433,   22,   96,   96,  437,  438,  374,
 /*  1750 */     0,   22,   35,    0,  379,    0,  381,    0,    0,   39,
 /*  1760 */    58,   42,   44,   47,    0,   58,   58,    0,   14,   39,
 /*  1770 */    14,    0,    0,  333,   40,   39,    0,  169,   47,   47,
 /*  1780 */     0,    0,  174,  177,    0,    0,   65,  412,   39,   48,
 /*  1790 */     0,  416,   48,    0,  419,  420,  421,  422,  423,  424,
 /*  1800 */    35,  426,  194,   35,   35,   39,  366,   48,  433,   39,
 /*  1810 */     0,   48,  437,  438,  374,    0,   39,   35,    0,  379,
 /*  1820 */     0,  381,    0,   35,  333,   22,    0,   35,   22,   35,
 /*  1830 */    44,   35,   35,   35,   35,  109,   35,   35,    0,   35,
 /*  1840 */   107,   22,   35,  333,   44,    0,   22,    0,   35,   22,
 /*  1850 */     0,   35,  412,    0,    0,   50,  416,  366,   35,  419,
 /*  1860 */   420,  421,  422,  423,  424,  374,  426,   35,   22,   20,
 /*  1870 */   379,   35,  381,  433,   35,  100,  366,    0,  438,  101,
 /*  1880 */    22,    0,  193,  100,  374,   22,   35,    0,    0,  379,
 /*  1890 */   256,  381,    3,  256,    3,  256,   44,    0,    0,  189,
 /*  1900 */    44,   44,   35,  412,   95,  168,   44,  416,  100,  170,
 /*  1910 */   419,  420,  421,  422,  423,  424,  168,  426,  333,  168,
 /*  1920 */   175,  100,  412,   47,   96,   47,  416,   98,   44,  419,
 /*  1930 */   420,  421,  422,  423,  424,  101,  426,  333,   96,   44,
 /*  1940 */    35,  101,  101,  100,  100,   35,   35,   35,  100,   35,
 /*  1950 */    47,  366,  461,   44,   47,    0,  101,    0,  171,  374,
 /*  1960 */   100,  250,  101,   39,  379,  101,  381,  101,   47,  101,
 /*  1970 */   366,  100,  100,  463,  101,  371,  101,    0,  374,  100,
 /*  1980 */   100,   39,  100,  379,  110,  381,  169,   47,   44,  237,
 /*  1990 */     2,   98,  100,   22,   98,  101,   47,  412,   47,  100,
 /*  2000 */   100,  416,  101,  101,  419,  420,  421,  422,  423,  424,
 /*  2010 */   333,  426,   22,  100,   35,  100,  412,  100,   35,  101,
 /*  2020 */   416,   35,  100,  419,  420,  421,  422,  423,  424,  215,
 /*  2030 */   426,  111,  101,  100,   35,  101,  333,  100,   35,  101,
 /*  2040 */   101,  100,   35,  366,  101,  100,  100,  217,  123,  123,
 /*  2050 */   123,  374,  123,   22,  100,   44,  379,  472,  381,  112,
 /*  2060 */   100,   35,  100,   22,   35,   65,   64,   35,   35,  366,
 /*  2070 */    35,   35,   71,   35,  371,   35,   22,  374,   35,   35,
 /*  2080 */    35,   35,  379,   44,  381,   93,   35,   35,   35,  412,
 /*  2090 */    35,   35,   71,  416,   35,   35,  419,  420,  421,  422,
 /*  2100 */   423,  424,   35,  426,   35,  428,   35,  333,   22,   35,
 /*  2110 */     0,   35,   48,    0,   39,  412,   35,   39,   48,  416,
 /*  2120 */     0,   48,  419,  420,  421,  422,  423,  424,  333,  426,
 /*  2130 */    35,   39,    0,   48,   35,   39,    0,   35,   35,    0,
 /*  2140 */   366,   22,   21,   20,   22,  371,   22,   21,  374,  475,
 /*  2150 */   475,  475,  475,  379,  475,  381,  475,  475,  333,  475,
 /*  2160 */   475,  366,  475,  475,  475,  475,  475,  475,  475,  374,
 /*  2170 */   475,  475,  475,  475,  379,  475,  381,  475,  475,  475,
 /*  2180 */   475,  475,  475,  475,  475,  475,  412,  475,  475,  475,
 /*  2190 */   416,  366,  475,  419,  420,  421,  422,  423,  424,  374,
 /*  2200 */   426,  475,  475,  475,  379,  475,  381,  412,  475,  475,
 /*  2210 */   475,  416,  475,  475,  419,  420,  421,  422,  423,  424,
 /*  2220 */   475,  426,  475,  333,  475,  475,  475,  475,  475,  475,
 /*  2230 */   475,  475,  475,  475,  475,  475,  475,  412,  475,  475,
 /*  2240 */   475,  416,  475,  475,  419,  420,  421,  422,  423,  424,
 /*  2250 */   475,  426,  333,  475,  475,  475,  366,  475,  475,  475,
 /*  2260 */   475,  475,  475,  475,  374,  475,  475,  475,  475,  379,
 /*  2270 */   475,  381,  475,  475,  475,  475,  475,  475,  475,  475,
 /*  2280 */   475,  475,  475,  475,  475,  366,  333,  475,  475,  475,
 /*  2290 */   475,  475,  475,  374,  475,  475,  475,  475,  379,  475,
 /*  2300 */   381,  475,  412,  475,  475,  475,  416,  475,  475,  419,
 /*  2310 */   420,  421,  422,  423,  424,  475,  426,  475,  475,  366,
 /*  2320 */   475,  475,  475,  475,  475,  475,  475,  374,  475,  475,
 /*  2330 */   475,  412,  379,  475,  381,  416,  475,  475,  419,  420,
 /*  2340 */   421,  422,  423,  424,  475,  426,  475,  475,  475,  475,
 /*  2350 */   333,  475,  475,  475,  475,  475,  475,  475,  475,  475,
 /*  2360 */   475,  475,  475,  475,  475,  412,  475,  475,  475,  416,
 /*  2370 */   333,  475,  419,  420,  421,  422,  423,  424,  475,  426,
 /*  2380 */   475,  475,  475,  366,  475,  475,  475,  475,  475,  475,
 /*  2390 */   475,  374,  475,  475,  475,  475,  379,  475,  381,  475,
 /*  2400 */   475,  475,  475,  366,  475,  475,  475,  475,  475,  475,
 /*  2410 */   475,  374,  475,  475,  475,  475,  379,  475,  381,  475,
 /*  2420 */   475,  475,  475,  475,  475,  475,  475,  475,  475,  412,
 /*  2430 */   475,  333,  475,  416,  475,  475,  419,  420,  421,  422,
 /*  2440 */   423,  424,  475,  426,  475,  475,  475,  475,  475,  412,
 /*  2450 */   475,  475,  475,  416,  475,  475,  419,  420,  421,  422,
 /*  2460 */   423,  424,  475,  426,  366,  475,  475,  475,  475,  475,
 /*  2470 */   475,  475,  374,  475,  475,  475,  475,  379,  475,  381,
 /*  2480 */   475,  475,  333,  475,  475,  475,  475,  475,  475,  475,
 /*  2490 */   475,  475,  475,  475,  475,  475,  475,  475,  475,  475,
 /*  2500 */   475,  475,  475,  333,  475,  475,  475,  475,  475,  475,
 /*  2510 */   412,  475,  475,  475,  416,  366,  475,  419,  420,  421,
 /*  2520 */   422,  423,  424,  374,  426,  475,  475,  475,  379,  475,
 /*  2530 */   381,  475,  475,  333,  475,  475,  366,  475,  475,  475,
 /*  2540 */   475,  475,  475,  475,  374,  475,  475,  475,  475,  379,
 /*  2550 */   475,  381,  475,  475,  475,  475,  475,  475,  475,  475,
 /*  2560 */   475,  412,  475,  475,  475,  416,  366,  475,  419,  420,
 /*  2570 */   421,  422,  423,  424,  374,  426,  475,  475,  475,  379,
 /*  2580 */   475,  381,  412,  475,  475,  475,  416,  475,  475,  419,
 /*  2590 */   420,  421,  422,  423,  424,  475,  426,  475,  333,  475,
 /*  2600 */   475,  475,  475,  475,  475,  475,  475,  475,  475,  475,
 /*  2610 */   475,  475,  412,  475,  475,  475,  416,  475,  475,  419,
 /*  2620 */   420,  421,  422,  423,  424,  475,  426,  333,  475,  475,
 /*  2630 */   475,  366,  475,  475,  475,  475,  475,  475,  475,  374,
 /*  2640 */   475,  475,  475,  475,  379,  475,  381,  475,  475,  475,
 /*  2650 */   475,  475,  475,  475,  475,  475,  475,  475,  475,  475,
 /*  2660 */   366,  333,  475,  475,  475,  475,  475,  475,  374,  475,
 /*  2670 */   475,  475,  475,  379,  475,  381,  475,  412,  475,  475,
 /*  2680 */   475,  416,  475,  475,  419,  420,  421,  422,  423,  424,
 /*  2690 */   475,  426,  475,  475,  366,  475,  475,  475,  475,  475,
 /*  2700 */   475,  475,  374,  475,  475,  475,  412,  379,  475,  381,
 /*  2710 */   416,  475,  475,  419,  420,  421,  422,  423,  424,  475,
 /*  2720 */   426,  475,  475,  475,  475,  333,  475,  475,  475,  475,
 /*  2730 */   475,  475,  475,  475,  475,  475,  475,  475,  475,  475,
 /*  2740 */   412,  475,  475,  475,  416,  333,  475,  419,  420,  421,
 /*  2750 */   422,  423,  424,  475,  426,  475,  475,  475,  366,  475,
 /*  2760 */   475,  475,  475,  475,  475,  475,  374,  475,  475,  475,
 /*  2770 */   475,  379,  475,  381,  475,  475,  475,  475,  366,  475,
 /*  2780 */   475,  475,  475,  475,  475,  475,  374,  475,  475,  475,
 /*  2790 */   475,  379,  475,  381,  475,  475,  475,  475,  475,  475,
 /*  2800 */   475,  475,  475,  475,  412,  475,  333,  475,  416,  475,
 /*  2810 */   475,  419,  420,  421,  422,  423,  424,  475,  426,  475,
 /*  2820 */   475,  475,  475,  475,  412,  475,  475,  475,  416,  475,
 /*  2830 */   475,  419,  420,  421,  422,  423,  424,  475,  426,  366,
 /*  2840 */   475,  475,  475,  475,  475,  475,  475,  374,  475,  475,
 /*  2850 */   475,  475,  379,  475,  381,  475,  475,  333,  475,  475,
 /*  2860 */   475,  475,  475,  475,  475,  475,  475,  475,  475,  475,
 /*  2870 */   475,  475,  475,  475,  475,  475,  475,  475,  333,  475,
 /*  2880 */   475,  475,  475,  475,  475,  412,  475,  475,  475,  416,
 /*  2890 */   366,  475,  419,  420,  421,  422,  423,  424,  374,  426,
 /*  2900 */   475,  475,  475,  379,  475,  381,  475,  475,  333,  475,
 /*  2910 */   475,  366,  475,  475,  475,  475,  475,  475,  475,  374,
 /*  2920 */   475,  475,  475,  475,  379,  475,  381,  475,  475,  475,
 /*  2930 */   475,  475,  475,  475,  475,  475,  412,  475,  475,  475,
 /*  2940 */   416,  366,  475,  419,  420,  421,  422,  423,  424,  374,
 /*  2950 */   426,  475,  475,  475,  379,  475,  381,  412,  475,  475,
 /*  2960 */   475,  416,  475,  475,  419,  420,  421,  422,  423,  424,
 /*  2970 */   475,  426,  475,  333,  475,  475,  475,  475,  475,  475,
 /*  2980 */   475,  475,  475,  475,  475,  475,  475,  412,  475,  475,
 /*  2990 */   475,  416,  475,  475,  419,  420,  421,  422,  423,  424,
 /*  3000 */   475,  426,  333,  475,  475,  475,  366,  475,  475,  475,
 /*  3010 */   475,  475,  475,  475,  374,  475,  475,  475,  475,  379,
 /*  3020 */   475,  381,  475,  475,  475,  475,  475,  475,  475,  475,
 /*  3030 */   475,  475,  475,  475,  475,  366,  475,  475,  475,  475,
 /*  3040 */   475,  475,  475,  374,  475,  475,  475,  475,  379,  475,
 /*  3050 */   381,  475,  412,  475,  475,  475,  416,  475,  475,  419,
 /*  3060 */   420,  421,  422,  423,  424,  475,  426,  475,  475,  475,
 /*  3070 */   475,  475,  475,  475,  475,  475,  475,  475,  475,  475,
 /*  3080 */   475,  412,  475,  475,  475,  416,  475,  475,  419,  420,
 /*  3090 */   421,  422,  423,  424,  475,  426,
};
#define YY_SHIFT_COUNT    (760)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2139)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   550,    0,  224,    0,  449,  449,  449,  449,  449,  449,
 /*    10 */   449,  449,  449,  449,  449,  673,  897,  897, 1121,  897,
 /*    20 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*    30 */   897,  897,  897,  897,  897,  897,  897,  897,  897,  897,
 /*    40 */   897,  897,  897,  897,  897,  897,  897,  897,  149,  170,
 /*    50 */   447,   79,  251,   65,  167,   65,   79,   79, 1487, 1487,
 /*    60 */  1487,   65, 1487, 1487,  529,   65,  109,  328,  137,  137,
 /*    70 */   328,  707,  707,  475,  257,   87,   87,  137,  137,  137,
 /*    80 */   137,  137,  137,  137,  174,  137,  137,  176,  109,  137,
 /*    90 */   137,  279,  137,  109,  137,  174,  137,  174,  109,  137,
 /*   100 */   137,  109,  137,  109,  109,  109,  137,  378,  223,  187,
 /*   110 */   187,  406,  114,  750,  750,  750,  750,  750,  750,  750,
 /*   120 */   750,  750,  750,  750,  750,  750,  750,  750,  750,  750,
 /*   130 */   750,  750, 1135,  165,  475,  257,   63,   39,   39,   39,
 /*   140 */   778,  464,  464,   63,  448,  448,  448,  176,  497,  389,
 /*   150 */   109,  595,  109,  595,  595,  634,  687,   34,   34,   34,
 /*   160 */    34,   34,   34,   34,   34, 1608,  572,  569,  197,   15,
 /*   170 */   260,  288,  247,  543,  784,  690,  831,  693,  519,  981,
 /*   180 */   674,  953,  580,  674, 1016,  886,  856, 1112, 1334, 1200,
 /*   190 */  1345, 1368, 1345, 1229, 1376, 1376, 1345, 1229, 1229, 1302,
 /*   200 */  1309, 1376, 1312, 1376, 1376, 1376, 1400, 1400, 1405,  176,
 /*   210 */  1416,  176, 1420, 1425,  176, 1420,  176,  176,  176, 1376,
 /*   220 */   176, 1401, 1401, 1400,  109,  109,  109,  109,  109,  109,
 /*   230 */   109,  109,  109,  109,  109, 1376, 1400,  595,  595,  595,
 /*   240 */  1266, 1370, 1405,  378, 1281, 1301, 1416,  378, 1316, 1376,
 /*   250 */  1368, 1368,  595, 1250, 1257,  595, 1250, 1257,  595,  595,
 /*   260 */   109, 1245, 1341, 1250, 1255, 1259, 1289, 1112, 1249, 1268,
 /*   270 */  1275, 1299,  448, 1536, 1376, 1420,  378,  378, 1547, 1257,
 /*   280 */   595,  595,  595,  595,  595, 1257,  595, 1409,  378,  634,
 /*   290 */   378,  448, 1482, 1492,  595,  687, 1376,  378, 1562, 1400,
 /*   300 */  3096, 3096, 3096, 3096, 3096, 3096, 3096, 3096, 3096,   36,
 /*   310 */   454,  689,  937,  162,  841,  931,  592, 1015, 1064,  967,
 /*   320 */  1035, 1168, 1168, 1168, 1168, 1168, 1168, 1168, 1168, 1168,
 /*   330 */   472,   73,  502,  502,  666,  408,  499,  776,  734,  838,
 /*   340 */   377,  353,  698,  698,  604,  282,  722,  604,  604,  604,
 /*   350 */  1090,  964,  949, 1032, 1108,  818,  345, 1053, 1067, 1081,
 /*   360 */  1120, 1101, 1231, 1223, 1228, 1242,  944, 1062, 1107, 1131,
 /*   370 */  1147, 1172, 1185, 1126, 1031, 1057, 1041, 1209, 1230, 1234,
 /*   380 */  1237, 1264, 1267, 1278, 1270, 1179, 1202, 1208, 1272,  735,
 /*   390 */  1276, 1277, 1288, 1326, 1328, 1336, 1139, 1254, 1344, 1263,
 /*   400 */  1381, 1620, 1621, 1623, 1583, 1626, 1595, 1423, 1597, 1598,
 /*   410 */  1599, 1427, 1636, 1602, 1603, 1432, 1642, 1436, 1645, 1611,
 /*   420 */  1647, 1627, 1648, 1615, 1456, 1464, 1467, 1654, 1655, 1657,
 /*   430 */  1476, 1478, 1660, 1661, 1622, 1667, 1668, 1670, 1629, 1672,
 /*   440 */  1674, 1685, 1686, 1687, 1688, 1690, 1692, 1522, 1643, 1679,
 /*   450 */  1525, 1681, 1682, 1683, 1693, 1694, 1695, 1696, 1697, 1698,
 /*   460 */  1699, 1700, 1701, 1704, 1705, 1706, 1709, 1669, 1712, 1713,
 /*   470 */  1714, 1723, 1724, 1725, 1715, 1727, 1728, 1735, 1600, 1738,
 /*   480 */  1740, 1722, 1649, 1729, 1650, 1750, 1702, 1717, 1753, 1707,
 /*   490 */  1755, 1708, 1757, 1758, 1719, 1720, 1718, 1716, 1754, 1731,
 /*   500 */  1756, 1732, 1764, 1734, 1730, 1767, 1771, 1772, 1736, 1606,
 /*   510 */  1776, 1780, 1781, 1721, 1784, 1785, 1765, 1741, 1749, 1790,
 /*   520 */  1768, 1744, 1766, 1793, 1769, 1759, 1770, 1810, 1782, 1763,
 /*   530 */  1777, 1815, 1818, 1820, 1822, 1726, 1733, 1788, 1803, 1826,
 /*   540 */  1792, 1794, 1796, 1797, 1798, 1799, 1801, 1786, 1800, 1802,
 /*   550 */  1804, 1806, 1807, 1838, 1819, 1845, 1824, 1805, 1847, 1827,
 /*   560 */  1813, 1850, 1816, 1853, 1823, 1854, 1846, 1849, 1832, 1836,
 /*   570 */  1839, 1778, 1775, 1877, 1737, 1783, 1689, 1851, 1858, 1881,
 /*   580 */  1710, 1863, 1748, 1739, 1887, 1888, 1751, 1745, 1889, 1852,
 /*   590 */  1634, 1808, 1834, 1821, 1828, 1829, 1842, 1809, 1840, 1856,
 /*   600 */  1857, 1841, 1843, 1844, 1848, 1855, 1862, 1876, 1878, 1860,
 /*   610 */  1884, 1637, 1861, 1864, 1891, 1895, 1639, 1867, 1905, 1910,
 /*   620 */  1911, 1912, 1914, 1866, 1868, 1903, 1711, 1909, 1907, 1897,
 /*   630 */  1898, 1955, 1957, 1871, 1924, 1716, 1921, 1872, 1873, 1875,
 /*   640 */  1879, 1880, 1787, 1882, 1977, 1942, 1817, 1892, 1874, 1716,
 /*   650 */  1940, 1944, 1893, 1752, 1896, 1988, 1971, 1814, 1899, 1894,
 /*   660 */  1900, 1901, 1913, 1902, 1949, 1915, 1917, 1951, 1918, 1990,
 /*   670 */  1830, 1922, 1920, 1931, 1979, 1983, 1933, 1934, 1986, 1937,
 /*   680 */  1938, 1999, 1941, 1939, 2003, 1945, 1943, 2007, 1946, 1925,
 /*   690 */  1926, 1927, 1929, 2031, 1947, 1954, 2011, 1960, 2026, 1962,
 /*   700 */  2011, 2011, 2041, 2000, 2002, 2029, 2032, 2033, 2035, 2036,
 /*   710 */  2038, 2040, 2043, 2044, 2045, 2001, 1992, 2039, 2046, 2051,
 /*   720 */  2052, 2054, 2053, 2055, 2056, 2021, 1786, 2059, 1800, 2060,
 /*   730 */  2067, 2069, 2071, 2086, 2074, 2110, 2076, 2064, 2075, 2113,
 /*   740 */  2081, 2070, 2078, 2120, 2095, 2073, 2092, 2132, 2099, 2085,
 /*   750 */  2096, 2136, 2102, 2103, 2139, 2119, 2121, 2122, 2124, 2126,
 /*   760 */  2123,
};
#define YY_REDUCE_COUNT (308)
#define YY_REDUCE_MIN   (-424)
#define YY_REDUCE_MAX   (2669)
static const short yy_reduce_ofst[] = {
 /*     0 */   373, -119,  368,  588,  774,  995, 1065, 1116, 1191,  -17,
 /*    10 */   446,  672,  880, 1310, 1375, -332,  903,  155, 1440, 1491,
 /*    20 */  1510, 1585, 1604, 1677, 1703, 1774, 1795, 1825, 1890, 1919,
 /*    30 */  1953, 2017, 2037, 2098, 2149, 2170, 2200, 2265, 2294, 2328,
 /*    40 */  2392, 2412, 2473, 2524, 2545, 2575, 2640, 2669,   96, -184,
 /*    50 */  -395,  -99, -392, -134,  488,  761,  -87,  470,  -89,  281,
 /*    60 */   398, -424, -364, -360, -384,  806,   42, -314, -177,  391,
 /*    70 */  -379, -207, -156, -350,   86,  156,  202, -331,  178,  394,
 /*    80 */   402,  462,  507,  577, -101,  585,  646,  -34, -334,  700,
 /*    90 */   708,  196,  730,  182,  801,  190,  804,  302,  278,  846,
 /*   100 */   858,  401,  860,  505,  450,  556,  878, -301,  -63, -243,
 /*   110 */  -243, -110, -323,  -85,  -81,   59,  153,  357,  358,  407,
 /*   120 */   541,  549,  594,  627,  639,  658,  663,  665,  669,  680,
 /*   130 */   682,  683, -302,  530,  267,    7,  124,  530,  545,  637,
 /*   140 */   185,   -7,  363,  206,  104,  603,  671,  -22, -104,  611,
 /*   150 */   451,  710,  686,  721,  723,  749,  630, -367, -362,  338,
 /*   160 */   429,  582,  795,  797,  582,  520,  847,  922,  871,  792,
 /*   170 */   808,  940,  829,  924,  924,  948,  906,  957,  934,  941,
 /*   180 */   911,  911,  893,  911,  921,  912,  924,  961,  970,  985,
 /*   190 */  1000, 1002, 1006, 1009, 1054, 1056, 1013, 1017, 1018, 1052,
 /*   200 */  1055, 1068, 1059, 1069, 1071, 1072, 1087, 1089, 1027, 1088,
 /*   210 */  1060, 1091, 1100, 1048, 1103, 1106, 1104, 1105, 1109, 1113,
 /*   220 */  1110, 1111, 1114, 1124, 1094, 1095, 1096, 1097, 1098, 1099,
 /*   230 */  1102, 1117, 1127, 1128, 1138, 1125, 1132, 1092, 1093, 1122,
 /*   240 */  1063, 1066, 1073, 1133, 1070, 1074, 1129, 1160, 1115, 1166,
 /*   250 */  1119, 1123, 1136, 1061, 1137, 1142, 1075, 1140, 1144, 1146,
 /*   260 */   924, 1083, 1076, 1118, 1134, 1130, 1141, 1145, 1077, 1078,
 /*   270 */  1085,  911, 1181, 1143, 1219, 1220, 1218, 1221, 1176, 1175,
 /*   280 */  1192, 1195, 1196, 1197, 1198, 1184, 1201, 1190, 1240, 1224,
 /*   290 */  1244, 1213, 1154, 1225, 1212, 1238, 1256, 1251, 1265, 1269,
 /*   300 */  1199, 1194, 1204, 1210, 1246, 1248, 1258, 1273, 1285,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*    10 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*    20 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*    30 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*    40 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*    50 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*    60 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*    70 */  1714, 1714, 1714, 1985, 1714, 1714, 1714, 1714, 1714, 1714,
 /*    80 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1793, 1714, 1714,
 /*    90 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   100 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1791, 1978, 2199,
 /*   110 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   120 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   130 */  1714, 1714, 1714, 2211, 1714, 1714, 1714, 2211, 2211, 2211,
 /*   140 */  1791, 2171, 2171, 1714, 1714, 1714, 1714, 1793, 2043, 1714,
 /*   150 */  1714, 1714, 1714, 1714, 1714, 1913, 1714, 1714, 1714, 1714,
 /*   160 */  1714, 1937, 1714, 1714, 1714, 2037, 1714, 1714, 2236, 2292,
 /*   170 */  1714, 1714, 2239, 1714, 1714, 1714, 1990, 1714, 1866, 2226,
 /*   180 */  2203, 2217, 2276, 2204, 2201, 2220, 1714, 2230, 1714, 2024,
 /*   190 */  1983, 1714, 1983, 1980, 1714, 1714, 1983, 1980, 1980, 1855,
 /*   200 */  1851, 1714, 1849, 1714, 1714, 1714, 1714, 1714, 1714, 1793,
 /*   210 */  1714, 1793, 1714, 1714, 1793, 1714, 1793, 1793, 1793, 1714,
 /*   220 */  1793, 1771, 1771, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   230 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   240 */  2055, 2041, 1714, 1791, 2035, 2033, 1714, 1791, 2031, 1714,
 /*   250 */  1714, 1714, 1714, 2247, 2245, 1714, 2247, 2245, 1714, 1714,
 /*   260 */  1714, 2261, 2257, 2247, 2265, 2263, 2232, 2230, 2295, 2282,
 /*   270 */  2278, 2217, 1714, 1714, 1714, 1714, 1791, 1791, 1714, 2245,
 /*   280 */  1714, 1714, 1714, 1714, 1714, 2245, 1714, 1714, 1791, 1714,
 /*   290 */  1791, 1714, 1714, 1882, 1714, 1714, 1714, 1791, 1746, 1714,
 /*   300 */  2026, 2046, 2008, 2008, 1916, 1916, 1916, 1794, 1719, 1714,
 /*   310 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   320 */  1714, 2260, 2259, 2126, 1714, 2175, 2174, 2173, 2164, 2125,
 /*   330 */  1878, 1714, 2124, 2123, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   340 */  1714, 1714, 1999, 1998, 2117, 1714, 1714, 2118, 2116, 2115,
 /*   350 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   360 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   370 */  1714, 1714, 1714, 1714, 2279, 2283, 1714, 1714, 1714, 1714,
 /*   380 */  1714, 1714, 1714, 2200, 1714, 1714, 1714, 1714, 1714, 2099,
 /*   390 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   400 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   410 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   420 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   430 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   440 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   450 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   460 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   470 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   480 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   490 */  1714, 1714, 1714, 1714, 1714, 1714, 1751, 2104, 1714, 1714,
 /*   500 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   510 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   520 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   530 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   540 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1832, 1831, 1714,
 /*   550 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   560 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   570 */  1714, 2108, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   580 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 2275, 2233,
 /*   590 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   600 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 2099, 1714,
 /*   610 */  2258, 1714, 1714, 2273, 1714, 2277, 1714, 1714, 1714, 1714,
 /*   620 */  1714, 1714, 1714, 2210, 2206, 1714, 1714, 2202, 1714, 1714,
 /*   630 */  1714, 1714, 1714, 1714, 1714, 2107, 1714, 1714, 1714, 1714,
 /*   640 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 2098,
 /*   650 */  1714, 2161, 1714, 1714, 1714, 2195, 1714, 1714, 2146, 1714,
 /*   660 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 2108, 1714,
 /*   670 */  2111, 1714, 1714, 1714, 1714, 1714, 1910, 1714, 1714, 1714,
 /*   680 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1895,
 /*   690 */  1893, 1892, 1891, 1714, 1888, 1714, 1923, 1714, 1714, 1714,
 /*   700 */  1919, 1918, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   710 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1812, 1714, 1714,
 /*   720 */  1714, 1714, 1714, 1714, 1714, 1714, 1804, 1714, 1803, 1714,
 /*   730 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   740 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   750 */  1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714, 1714,
 /*   760 */  1714,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      START => nothing */
    0,  /*       WITH => nothing */
    0,  /*  TIMESTAMP => nothing */
  279,  /*        END => ABORT */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*      ALIVE => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*   LANGUAGE => nothing */
    0,  /*    REPLACE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*     UPDATE => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*     LEADER => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*    VALUE_F => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     NULL_F => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  279,  /*      AFTER => ABORT */
  279,  /*     ATTACH => ABORT */
  279,  /*     BEFORE => ABORT */
  279,  /*      BEGIN => ABORT */
  279,  /*     BITAND => ABORT */
  279,  /*     BITNOT => ABORT */
  279,  /*      BITOR => ABORT */
  279,  /*     BLOCKS => ABORT */
  279,  /*     CHANGE => ABORT */
  279,  /*      COMMA => ABORT */
  279,  /*     CONCAT => ABORT */
  279,  /*   CONFLICT => ABORT */
  279,  /*       COPY => ABORT */
  279,  /*   DEFERRED => ABORT */
  279,  /* DELIMITERS => ABORT */
  279,  /*     DETACH => ABORT */
  279,  /*     DIVIDE => ABORT */
  279,  /*        DOT => ABORT */
  279,  /*       EACH => ABORT */
  279,  /*       FAIL => ABORT */
  279,  /*       FILE => ABORT */
  279,  /*        FOR => ABORT */
  279,  /*       GLOB => ABORT */
  279,  /*         ID => ABORT */
  279,  /*  IMMEDIATE => ABORT */
  279,  /*     IMPORT => ABORT */
  279,  /*  INITIALLY => ABORT */
  279,  /*    INSTEAD => ABORT */
  279,  /*     ISNULL => ABORT */
  279,  /*        KEY => ABORT */
  279,  /*    MODULES => ABORT */
  279,  /*  NK_BITNOT => ABORT */
  279,  /*    NK_SEMI => ABORT */
  279,  /*    NOTNULL => ABORT */
  279,  /*         OF => ABORT */
  279,  /*       PLUS => ABORT */
  279,  /*  PRIVILEGE => ABORT */
  279,  /*      RAISE => ABORT */
  279,  /*   RESTRICT => ABORT */
  279,  /*        ROW => ABORT */
  279,  /*       SEMI => ABORT */
  279,  /*       STAR => ABORT */
  279,  /*  STATEMENT => ABORT */
  279,  /*     STRICT => ABORT */
  279,  /*     STRING => ABORT */
  279,  /*      TIMES => ABORT */
  279,  /*     VALUES => ABORT */
  279,  /*   VARIABLE => ABORT */
  279,  /*       VIEW => ABORT */
  279,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "COMPACT",
  /*   63 */ "IF",
  /*   64 */ "NOT",
  /*   65 */ "EXISTS",
  /*   66 */ "BUFFER",
  /*   67 */ "CACHEMODEL",
  /*   68 */ "CACHESIZE",
  /*   69 */ "COMP",
  /*   70 */ "DURATION",
  /*   71 */ "NK_VARIABLE",
  /*   72 */ "MAXROWS",
  /*   73 */ "MINROWS",
  /*   74 */ "KEEP",
  /*   75 */ "PAGES",
  /*   76 */ "PAGESIZE",
  /*   77 */ "TSDB_PAGESIZE",
  /*   78 */ "PRECISION",
  /*   79 */ "REPLICA",
  /*   80 */ "VGROUPS",
  /*   81 */ "SINGLE_STABLE",
  /*   82 */ "RETENTIONS",
  /*   83 */ "SCHEMALESS",
  /*   84 */ "WAL_LEVEL",
  /*   85 */ "WAL_FSYNC_PERIOD",
  /*   86 */ "WAL_RETENTION_PERIOD",
  /*   87 */ "WAL_RETENTION_SIZE",
  /*   88 */ "WAL_ROLL_PERIOD",
  /*   89 */ "WAL_SEGMENT_SIZE",
  /*   90 */ "STT_TRIGGER",
  /*   91 */ "TABLE_PREFIX",
  /*   92 */ "TABLE_SUFFIX",
  /*   93 */ "NK_COLON",
  /*   94 */ "MAX_SPEED",
  /*   95 */ "START",
  /*   96 */ "WITH",
  /*   97 */ "TIMESTAMP",
  /*   98 */ "END",
  /*   99 */ "TABLE",
  /*  100 */ "NK_LP",
  /*  101 */ "NK_RP",
  /*  102 */ "STABLE",
  /*  103 */ "ADD",
  /*  104 */ "COLUMN",
  /*  105 */ "MODIFY",
  /*  106 */ "RENAME",
  /*  107 */ "TAG",
  /*  108 */ "SET",
  /*  109 */ "NK_EQ",
  /*  110 */ "USING",
  /*  111 */ "TAGS",
  /*  112 */ "COMMENT",
  /*  113 */ "BOOL",
  /*  114 */ "TINYINT",
  /*  115 */ "SMALLINT",
  /*  116 */ "INT",
  /*  117 */ "INTEGER",
  /*  118 */ "BIGINT",
  /*  119 */ "FLOAT",
  /*  120 */ "DOUBLE",
  /*  121 */ "BINARY",
  /*  122 */ "NCHAR",
  /*  123 */ "UNSIGNED",
  /*  124 */ "JSON",
  /*  125 */ "VARCHAR",
  /*  126 */ "MEDIUMBLOB",
  /*  127 */ "BLOB",
  /*  128 */ "VARBINARY",
  /*  129 */ "DECIMAL",
  /*  130 */ "MAX_DELAY",
  /*  131 */ "WATERMARK",
  /*  132 */ "ROLLUP",
  /*  133 */ "TTL",
  /*  134 */ "SMA",
  /*  135 */ "DELETE_MARK",
  /*  136 */ "FIRST",
  /*  137 */ "LAST",
  /*  138 */ "SHOW",
  /*  139 */ "PRIVILEGES",
  /*  140 */ "DATABASES",
  /*  141 */ "TABLES",
  /*  142 */ "STABLES",
  /*  143 */ "MNODES",
  /*  144 */ "QNODES",
  /*  145 */ "FUNCTIONS",
  /*  146 */ "INDEXES",
  /*  147 */ "ACCOUNTS",
  /*  148 */ "APPS",
  /*  149 */ "CONNECTIONS",
  /*  150 */ "LICENCES",
  /*  151 */ "GRANTS",
  /*  152 */ "QUERIES",
  /*  153 */ "SCORES",
  /*  154 */ "TOPICS",
  /*  155 */ "VARIABLES",
  /*  156 */ "CLUSTER",
  /*  157 */ "BNODES",
  /*  158 */ "SNODES",
  /*  159 */ "TRANSACTIONS",
  /*  160 */ "DISTRIBUTED",
  /*  161 */ "CONSUMERS",
  /*  162 */ "SUBSCRIPTIONS",
  /*  163 */ "VNODES",
  /*  164 */ "ALIVE",
  /*  165 */ "LIKE",
  /*  166 */ "TBNAME",
  /*  167 */ "QTAGS",
  /*  168 */ "AS",
  /*  169 */ "INDEX",
  /*  170 */ "FUNCTION",
  /*  171 */ "INTERVAL",
  /*  172 */ "COUNT",
  /*  173 */ "LAST_ROW",
  /*  174 */ "TOPIC",
  /*  175 */ "META",
  /*  176 */ "CONSUMER",
  /*  177 */ "GROUP",
  /*  178 */ "DESC",
  /*  179 */ "DESCRIBE",
  /*  180 */ "RESET",
  /*  181 */ "QUERY",
  /*  182 */ "CACHE",
  /*  183 */ "EXPLAIN",
  /*  184 */ "ANALYZE",
  /*  185 */ "VERBOSE",
  /*  186 */ "NK_BOOL",
  /*  187 */ "RATIO",
  /*  188 */ "NK_FLOAT",
  /*  189 */ "OUTPUTTYPE",
  /*  190 */ "AGGREGATE",
  /*  191 */ "BUFSIZE",
  /*  192 */ "LANGUAGE",
  /*  193 */ "REPLACE",
  /*  194 */ "STREAM",
  /*  195 */ "INTO",
  /*  196 */ "TRIGGER",
  /*  197 */ "AT_ONCE",
  /*  198 */ "WINDOW_CLOSE",
  /*  199 */ "IGNORE",
  /*  200 */ "EXPIRED",
  /*  201 */ "FILL_HISTORY",
  /*  202 */ "UPDATE",
  /*  203 */ "SUBTABLE",
  /*  204 */ "KILL",
  /*  205 */ "CONNECTION",
  /*  206 */ "TRANSACTION",
  /*  207 */ "BALANCE",
  /*  208 */ "VGROUP",
  /*  209 */ "LEADER",
  /*  210 */ "MERGE",
  /*  211 */ "REDISTRIBUTE",
  /*  212 */ "SPLIT",
  /*  213 */ "DELETE",
  /*  214 */ "INSERT",
  /*  215 */ "NULL",
  /*  216 */ "NK_QUESTION",
  /*  217 */ "NK_ARROW",
  /*  218 */ "ROWTS",
  /*  219 */ "QSTART",
  /*  220 */ "QEND",
  /*  221 */ "QDURATION",
  /*  222 */ "WSTART",
  /*  223 */ "WEND",
  /*  224 */ "WDURATION",
  /*  225 */ "IROWTS",
  /*  226 */ "ISFILLED",
  /*  227 */ "CAST",
  /*  228 */ "NOW",
  /*  229 */ "TODAY",
  /*  230 */ "TIMEZONE",
  /*  231 */ "CLIENT_VERSION",
  /*  232 */ "SERVER_VERSION",
  /*  233 */ "SERVER_STATUS",
  /*  234 */ "CURRENT_USER",
  /*  235 */ "CASE",
  /*  236 */ "WHEN",
  /*  237 */ "THEN",
  /*  238 */ "ELSE",
  /*  239 */ "BETWEEN",
  /*  240 */ "IS",
  /*  241 */ "NK_LT",
  /*  242 */ "NK_GT",
  /*  243 */ "NK_LE",
  /*  244 */ "NK_GE",
  /*  245 */ "NK_NE",
  /*  246 */ "MATCH",
  /*  247 */ "NMATCH",
  /*  248 */ "CONTAINS",
  /*  249 */ "IN",
  /*  250 */ "JOIN",
  /*  251 */ "INNER",
  /*  252 */ "SELECT",
  /*  253 */ "DISTINCT",
  /*  254 */ "WHERE",
  /*  255 */ "PARTITION",
  /*  256 */ "BY",
  /*  257 */ "SESSION",
  /*  258 */ "STATE_WINDOW",
  /*  259 */ "EVENT_WINDOW",
  /*  260 */ "SLIDING",
  /*  261 */ "FILL",
  /*  262 */ "VALUE",
  /*  263 */ "VALUE_F",
  /*  264 */ "NONE",
  /*  265 */ "PREV",
  /*  266 */ "NULL_F",
  /*  267 */ "LINEAR",
  /*  268 */ "NEXT",
  /*  269 */ "HAVING",
  /*  270 */ "RANGE",
  /*  271 */ "EVERY",
  /*  272 */ "ORDER",
  /*  273 */ "SLIMIT",
  /*  274 */ "SOFFSET",
  /*  275 */ "LIMIT",
  /*  276 */ "OFFSET",
  /*  277 */ "ASC",
  /*  278 */ "NULLS",
  /*  279 */ "ABORT",
  /*  280 */ "AFTER",
  /*  281 */ "ATTACH",
  /*  282 */ "BEFORE",
  /*  283 */ "BEGIN",
  /*  284 */ "BITAND",
  /*  285 */ "BITNOT",
  /*  286 */ "BITOR",
  /*  287 */ "BLOCKS",
  /*  288 */ "CHANGE",
  /*  289 */ "COMMA",
  /*  290 */ "CONCAT",
  /*  291 */ "CONFLICT",
  /*  292 */ "COPY",
  /*  293 */ "DEFERRED",
  /*  294 */ "DELIMITERS",
  /*  295 */ "DETACH",
  /*  296 */ "DIVIDE",
  /*  297 */ "DOT",
  /*  298 */ "EACH",
  /*  299 */ "FAIL",
  /*  300 */ "FILE",
  /*  301 */ "FOR",
  /*  302 */ "GLOB",
  /*  303 */ "ID",
  /*  304 */ "IMMEDIATE",
  /*  305 */ "IMPORT",
  /*  306 */ "INITIALLY",
  /*  307 */ "INSTEAD",
  /*  308 */ "ISNULL",
  /*  309 */ "KEY",
  /*  310 */ "MODULES",
  /*  311 */ "NK_BITNOT",
  /*  312 */ "NK_SEMI",
  /*  313 */ "NOTNULL",
  /*  314 */ "OF",
  /*  315 */ "PLUS",
  /*  316 */ "PRIVILEGE",
  /*  317 */ "RAISE",
  /*  318 */ "RESTRICT",
  /*  319 */ "ROW",
  /*  320 */ "SEMI",
  /*  321 */ "STAR",
  /*  322 */ "STATEMENT",
  /*  323 */ "STRICT",
  /*  324 */ "STRING",
  /*  325 */ "TIMES",
  /*  326 */ "VALUES",
  /*  327 */ "VARIABLE",
  /*  328 */ "VIEW",
  /*  329 */ "WAL",
  /*  330 */ "cmd",
  /*  331 */ "account_options",
  /*  332 */ "alter_account_options",
  /*  333 */ "literal",
  /*  334 */ "alter_account_option",
  /*  335 */ "user_name",
  /*  336 */ "sysinfo_opt",
  /*  337 */ "privileges",
  /*  338 */ "priv_level",
  /*  339 */ "priv_type_list",
  /*  340 */ "priv_type",
  /*  341 */ "db_name",
  /*  342 */ "topic_name",
  /*  343 */ "dnode_endpoint",
  /*  344 */ "force_opt",
  /*  345 */ "not_exists_opt",
  /*  346 */ "db_options",
  /*  347 */ "exists_opt",
  /*  348 */ "alter_db_options",
  /*  349 */ "speed_opt",
  /*  350 */ "start_opt",
  /*  351 */ "end_opt",
  /*  352 */ "integer_list",
  /*  353 */ "variable_list",
  /*  354 */ "retention_list",
  /*  355 */ "alter_db_option",
  /*  356 */ "retention",
  /*  357 */ "full_table_name",
  /*  358 */ "column_def_list",
  /*  359 */ "tags_def_opt",
  /*  360 */ "table_options",
  /*  361 */ "multi_create_clause",
  /*  362 */ "tags_def",
  /*  363 */ "multi_drop_clause",
  /*  364 */ "alter_table_clause",
  /*  365 */ "alter_table_options",
  /*  366 */ "column_name",
  /*  367 */ "type_name",
  /*  368 */ "signed_literal",
  /*  369 */ "create_subtable_clause",
  /*  370 */ "specific_cols_opt",
  /*  371 */ "expression_list",
  /*  372 */ "drop_table_clause",
  /*  373 */ "col_name_list",
  /*  374 */ "table_name",
  /*  375 */ "column_def",
  /*  376 */ "duration_list",
  /*  377 */ "rollup_func_list",
  /*  378 */ "alter_table_option",
  /*  379 */ "duration_literal",
  /*  380 */ "rollup_func_name",
  /*  381 */ "function_name",
  /*  382 */ "col_name",
  /*  383 */ "db_name_cond_opt",
  /*  384 */ "like_pattern_opt",
  /*  385 */ "table_name_cond",
  /*  386 */ "from_db_opt",
  /*  387 */ "tag_list_opt",
  /*  388 */ "tag_item",
  /*  389 */ "column_alias",
  /*  390 */ "full_index_name",
  /*  391 */ "index_options",
  /*  392 */ "index_name",
  /*  393 */ "func_list",
  /*  394 */ "sliding_opt",
  /*  395 */ "sma_stream_opt",
  /*  396 */ "func",
  /*  397 */ "sma_func_name",
  /*  398 */ "query_or_subquery",
  /*  399 */ "cgroup_name",
  /*  400 */ "analyze_opt",
  /*  401 */ "explain_options",
  /*  402 */ "insert_query",
  /*  403 */ "or_replace_opt",
  /*  404 */ "agg_func_opt",
  /*  405 */ "bufsize_opt",
  /*  406 */ "language_opt",
  /*  407 */ "stream_name",
  /*  408 */ "stream_options",
  /*  409 */ "col_list_opt",
  /*  410 */ "tag_def_or_ref_opt",
  /*  411 */ "subtable_opt",
  /*  412 */ "expression",
  /*  413 */ "dnode_list",
  /*  414 */ "where_clause_opt",
  /*  415 */ "signed",
  /*  416 */ "literal_func",
  /*  417 */ "literal_list",
  /*  418 */ "table_alias",
  /*  419 */ "expr_or_subquery",
  /*  420 */ "pseudo_column",
  /*  421 */ "column_reference",
  /*  422 */ "function_expression",
  /*  423 */ "case_when_expression",
  /*  424 */ "star_func",
  /*  425 */ "star_func_para_list",
  /*  426 */ "noarg_func",
  /*  427 */ "other_para_list",
  /*  428 */ "star_func_para",
  /*  429 */ "when_then_list",
  /*  430 */ "case_when_else_opt",
  /*  431 */ "common_expression",
  /*  432 */ "when_then_expr",
  /*  433 */ "predicate",
  /*  434 */ "compare_op",
  /*  435 */ "in_op",
  /*  436 */ "in_predicate_value",
  /*  437 */ "boolean_value_expression",
  /*  438 */ "boolean_primary",
  /*  439 */ "from_clause_opt",
  /*  440 */ "table_reference_list",
  /*  441 */ "table_reference",
  /*  442 */ "table_primary",
  /*  443 */ "joined_table",
  /*  444 */ "alias_opt",
  /*  445 */ "subquery",
  /*  446 */ "parenthesized_joined_table",
  /*  447 */ "join_type",
  /*  448 */ "search_condition",
  /*  449 */ "query_specification",
  /*  450 */ "set_quantifier_opt",
  /*  451 */ "select_list",
  /*  452 */ "partition_by_clause_opt",
  /*  453 */ "range_opt",
  /*  454 */ "every_opt",
  /*  455 */ "fill_opt",
  /*  456 */ "twindow_clause_opt",
  /*  457 */ "group_by_clause_opt",
  /*  458 */ "having_clause_opt",
  /*  459 */ "select_item",
  /*  460 */ "partition_list",
  /*  461 */ "partition_item",
  /*  462 */ "fill_mode",
  /*  463 */ "group_by_list",
  /*  464 */ "query_expression",
  /*  465 */ "query_simple",
  /*  466 */ "order_by_clause_opt",
  /*  467 */ "slimit_clause_opt",
  /*  468 */ "limit_clause_opt",
  /*  469 */ "union_query_expression",
  /*  470 */ "query_simple_or_subquery",
  /*  471 */ "sort_specification_list",
  /*  472 */ "sort_specification",
  /*  473 */ "ordering_specification_opt",
  /*  474 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "cmd ::= COMPACT DATABASE db_name start_opt end_opt",
 /*  73 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  74 */ "not_exists_opt ::=",
 /*  75 */ "exists_opt ::= IF EXISTS",
 /*  76 */ "exists_opt ::=",
 /*  77 */ "db_options ::=",
 /*  78 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  79 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  80 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  81 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  83 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  84 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  86 */ "db_options ::= db_options KEEP integer_list",
 /*  87 */ "db_options ::= db_options KEEP variable_list",
 /*  88 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  89 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  91 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  92 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  93 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  94 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  95 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  96 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 104 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 105 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 107 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 108 */ "alter_db_options ::= alter_db_option",
 /* 109 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 110 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 111 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 112 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 113 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 114 */ "alter_db_option ::= KEEP integer_list",
 /* 115 */ "alter_db_option ::= KEEP variable_list",
 /* 116 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 117 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 118 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 119 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 120 */ "alter_db_option ::= MINROWS NK_INTEGER",
 /* 121 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER",
 /* 122 */ "alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 123 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER",
 /* 124 */ "alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 125 */ "integer_list ::= NK_INTEGER",
 /* 126 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 127 */ "variable_list ::= NK_VARIABLE",
 /* 128 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 129 */ "retention_list ::= retention",
 /* 130 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 131 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 132 */ "speed_opt ::=",
 /* 133 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 134 */ "start_opt ::=",
 /* 135 */ "start_opt ::= START WITH NK_INTEGER",
 /* 136 */ "start_opt ::= START WITH NK_STRING",
 /* 137 */ "start_opt ::= START WITH TIMESTAMP NK_STRING",
 /* 138 */ "end_opt ::=",
 /* 139 */ "end_opt ::= END WITH NK_INTEGER",
 /* 140 */ "end_opt ::= END WITH NK_STRING",
 /* 141 */ "end_opt ::= END WITH TIMESTAMP NK_STRING",
 /* 142 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 143 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 144 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 145 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 146 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 147 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 148 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 149 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 150 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 151 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 152 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 153 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 154 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 155 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 156 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 157 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 158 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 159 */ "multi_create_clause ::= create_subtable_clause",
 /* 160 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 161 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 162 */ "multi_drop_clause ::= drop_table_clause",
 /* 163 */ "multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause",
 /* 164 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 165 */ "specific_cols_opt ::=",
 /* 166 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 167 */ "full_table_name ::= table_name",
 /* 168 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 169 */ "column_def_list ::= column_def",
 /* 170 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 171 */ "column_def ::= column_name type_name",
 /* 172 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 173 */ "type_name ::= BOOL",
 /* 174 */ "type_name ::= TINYINT",
 /* 175 */ "type_name ::= SMALLINT",
 /* 176 */ "type_name ::= INT",
 /* 177 */ "type_name ::= INTEGER",
 /* 178 */ "type_name ::= BIGINT",
 /* 179 */ "type_name ::= FLOAT",
 /* 180 */ "type_name ::= DOUBLE",
 /* 181 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 182 */ "type_name ::= TIMESTAMP",
 /* 183 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 184 */ "type_name ::= TINYINT UNSIGNED",
 /* 185 */ "type_name ::= SMALLINT UNSIGNED",
 /* 186 */ "type_name ::= INT UNSIGNED",
 /* 187 */ "type_name ::= BIGINT UNSIGNED",
 /* 188 */ "type_name ::= JSON",
 /* 189 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 190 */ "type_name ::= MEDIUMBLOB",
 /* 191 */ "type_name ::= BLOB",
 /* 192 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 193 */ "type_name ::= DECIMAL",
 /* 194 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 195 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 196 */ "tags_def_opt ::=",
 /* 197 */ "tags_def_opt ::= tags_def",
 /* 198 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 199 */ "table_options ::=",
 /* 200 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 201 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 202 */ "table_options ::= table_options WATERMARK duration_list",
 /* 203 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 204 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 205 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 206 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 207 */ "alter_table_options ::= alter_table_option",
 /* 208 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 209 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 210 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 211 */ "duration_list ::= duration_literal",
 /* 212 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 213 */ "rollup_func_list ::= rollup_func_name",
 /* 214 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 215 */ "rollup_func_name ::= function_name",
 /* 216 */ "rollup_func_name ::= FIRST",
 /* 217 */ "rollup_func_name ::= LAST",
 /* 218 */ "col_name_list ::= col_name",
 /* 219 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 220 */ "col_name ::= column_name",
 /* 221 */ "cmd ::= SHOW DNODES",
 /* 222 */ "cmd ::= SHOW USERS",
 /* 223 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 224 */ "cmd ::= SHOW DATABASES",
 /* 225 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 226 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 227 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 228 */ "cmd ::= SHOW MNODES",
 /* 229 */ "cmd ::= SHOW QNODES",
 /* 230 */ "cmd ::= SHOW FUNCTIONS",
 /* 231 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 232 */ "cmd ::= SHOW STREAMS",
 /* 233 */ "cmd ::= SHOW ACCOUNTS",
 /* 234 */ "cmd ::= SHOW APPS",
 /* 235 */ "cmd ::= SHOW CONNECTIONS",
 /* 236 */ "cmd ::= SHOW LICENCES",
 /* 237 */ "cmd ::= SHOW GRANTS",
 /* 238 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 239 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 240 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 241 */ "cmd ::= SHOW QUERIES",
 /* 242 */ "cmd ::= SHOW SCORES",
 /* 243 */ "cmd ::= SHOW TOPICS",
 /* 244 */ "cmd ::= SHOW VARIABLES",
 /* 245 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 246 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 247 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 248 */ "cmd ::= SHOW BNODES",
 /* 249 */ "cmd ::= SHOW SNODES",
 /* 250 */ "cmd ::= SHOW CLUSTER",
 /* 251 */ "cmd ::= SHOW TRANSACTIONS",
 /* 252 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 253 */ "cmd ::= SHOW CONSUMERS",
 /* 254 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 255 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 256 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 257 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 258 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 259 */ "cmd ::= SHOW db_name_cond_opt ALIVE",
 /* 260 */ "cmd ::= SHOW CLUSTER ALIVE",
 /* 261 */ "db_name_cond_opt ::=",
 /* 262 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 263 */ "like_pattern_opt ::=",
 /* 264 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 265 */ "table_name_cond ::= table_name",
 /* 266 */ "from_db_opt ::=",
 /* 267 */ "from_db_opt ::= FROM db_name",
 /* 268 */ "tag_list_opt ::=",
 /* 269 */ "tag_list_opt ::= tag_item",
 /* 270 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 271 */ "tag_item ::= TBNAME",
 /* 272 */ "tag_item ::= QTAGS",
 /* 273 */ "tag_item ::= column_name",
 /* 274 */ "tag_item ::= column_name column_alias",
 /* 275 */ "tag_item ::= column_name AS column_alias",
 /* 276 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options",
 /* 277 */ "cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 278 */ "cmd ::= DROP INDEX exists_opt full_index_name",
 /* 279 */ "full_index_name ::= index_name",
 /* 280 */ "full_index_name ::= db_name NK_DOT index_name",
 /* 281 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 282 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 283 */ "func_list ::= func",
 /* 284 */ "func_list ::= func_list NK_COMMA func",
 /* 285 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 286 */ "sma_func_name ::= function_name",
 /* 287 */ "sma_func_name ::= COUNT",
 /* 288 */ "sma_func_name ::= FIRST",
 /* 289 */ "sma_func_name ::= LAST",
 /* 290 */ "sma_func_name ::= LAST_ROW",
 /* 291 */ "sma_stream_opt ::=",
 /* 292 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 293 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 294 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 295 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 296 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 297 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 298 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 299 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 300 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 301 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 302 */ "cmd ::= DESC full_table_name",
 /* 303 */ "cmd ::= DESCRIBE full_table_name",
 /* 304 */ "cmd ::= RESET QUERY CACHE",
 /* 305 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 306 */ "cmd ::= EXPLAIN analyze_opt explain_options insert_query",
 /* 307 */ "analyze_opt ::=",
 /* 308 */ "analyze_opt ::= ANALYZE",
 /* 309 */ "explain_options ::=",
 /* 310 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 311 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 312 */ "cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt",
 /* 313 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 314 */ "agg_func_opt ::=",
 /* 315 */ "agg_func_opt ::= AGGREGATE",
 /* 316 */ "bufsize_opt ::=",
 /* 317 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 318 */ "language_opt ::=",
 /* 319 */ "language_opt ::= LANGUAGE NK_STRING",
 /* 320 */ "or_replace_opt ::=",
 /* 321 */ "or_replace_opt ::= OR REPLACE",
 /* 322 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery",
 /* 323 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 324 */ "col_list_opt ::=",
 /* 325 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 326 */ "tag_def_or_ref_opt ::=",
 /* 327 */ "tag_def_or_ref_opt ::= tags_def",
 /* 328 */ "tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP",
 /* 329 */ "stream_options ::=",
 /* 330 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 331 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 332 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 333 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 334 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 335 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 336 */ "stream_options ::= stream_options DELETE_MARK duration_literal",
 /* 337 */ "stream_options ::= stream_options IGNORE UPDATE NK_INTEGER",
 /* 338 */ "subtable_opt ::=",
 /* 339 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 340 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 341 */ "cmd ::= KILL QUERY NK_STRING",
 /* 342 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 343 */ "cmd ::= BALANCE VGROUP",
 /* 344 */ "cmd ::= BALANCE VGROUP LEADER",
 /* 345 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 346 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 347 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 348 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 349 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 350 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 351 */ "cmd ::= query_or_subquery",
 /* 352 */ "cmd ::= insert_query",
 /* 353 */ "insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 354 */ "insert_query ::= INSERT INTO full_table_name query_or_subquery",
 /* 355 */ "literal ::= NK_INTEGER",
 /* 356 */ "literal ::= NK_FLOAT",
 /* 357 */ "literal ::= NK_STRING",
 /* 358 */ "literal ::= NK_BOOL",
 /* 359 */ "literal ::= TIMESTAMP NK_STRING",
 /* 360 */ "literal ::= duration_literal",
 /* 361 */ "literal ::= NULL",
 /* 362 */ "literal ::= NK_QUESTION",
 /* 363 */ "duration_literal ::= NK_VARIABLE",
 /* 364 */ "signed ::= NK_INTEGER",
 /* 365 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 366 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 367 */ "signed ::= NK_FLOAT",
 /* 368 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 369 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 370 */ "signed_literal ::= signed",
 /* 371 */ "signed_literal ::= NK_STRING",
 /* 372 */ "signed_literal ::= NK_BOOL",
 /* 373 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 374 */ "signed_literal ::= duration_literal",
 /* 375 */ "signed_literal ::= NULL",
 /* 376 */ "signed_literal ::= literal_func",
 /* 377 */ "signed_literal ::= NK_QUESTION",
 /* 378 */ "literal_list ::= signed_literal",
 /* 379 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 380 */ "db_name ::= NK_ID",
 /* 381 */ "table_name ::= NK_ID",
 /* 382 */ "column_name ::= NK_ID",
 /* 383 */ "function_name ::= NK_ID",
 /* 384 */ "table_alias ::= NK_ID",
 /* 385 */ "column_alias ::= NK_ID",
 /* 386 */ "user_name ::= NK_ID",
 /* 387 */ "topic_name ::= NK_ID",
 /* 388 */ "stream_name ::= NK_ID",
 /* 389 */ "cgroup_name ::= NK_ID",
 /* 390 */ "index_name ::= NK_ID",
 /* 391 */ "expr_or_subquery ::= expression",
 /* 392 */ "expression ::= literal",
 /* 393 */ "expression ::= pseudo_column",
 /* 394 */ "expression ::= column_reference",
 /* 395 */ "expression ::= function_expression",
 /* 396 */ "expression ::= case_when_expression",
 /* 397 */ "expression ::= NK_LP expression NK_RP",
 /* 398 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 399 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 400 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 401 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 402 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 403 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 404 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 405 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 406 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 407 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 408 */ "expression_list ::= expr_or_subquery",
 /* 409 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 410 */ "column_reference ::= column_name",
 /* 411 */ "column_reference ::= table_name NK_DOT column_name",
 /* 412 */ "pseudo_column ::= ROWTS",
 /* 413 */ "pseudo_column ::= TBNAME",
 /* 414 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 415 */ "pseudo_column ::= QSTART",
 /* 416 */ "pseudo_column ::= QEND",
 /* 417 */ "pseudo_column ::= QDURATION",
 /* 418 */ "pseudo_column ::= WSTART",
 /* 419 */ "pseudo_column ::= WEND",
 /* 420 */ "pseudo_column ::= WDURATION",
 /* 421 */ "pseudo_column ::= IROWTS",
 /* 422 */ "pseudo_column ::= ISFILLED",
 /* 423 */ "pseudo_column ::= QTAGS",
 /* 424 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 425 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 426 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 427 */ "function_expression ::= literal_func",
 /* 428 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 429 */ "literal_func ::= NOW",
 /* 430 */ "noarg_func ::= NOW",
 /* 431 */ "noarg_func ::= TODAY",
 /* 432 */ "noarg_func ::= TIMEZONE",
 /* 433 */ "noarg_func ::= DATABASE",
 /* 434 */ "noarg_func ::= CLIENT_VERSION",
 /* 435 */ "noarg_func ::= SERVER_VERSION",
 /* 436 */ "noarg_func ::= SERVER_STATUS",
 /* 437 */ "noarg_func ::= CURRENT_USER",
 /* 438 */ "noarg_func ::= USER",
 /* 439 */ "star_func ::= COUNT",
 /* 440 */ "star_func ::= FIRST",
 /* 441 */ "star_func ::= LAST",
 /* 442 */ "star_func ::= LAST_ROW",
 /* 443 */ "star_func_para_list ::= NK_STAR",
 /* 444 */ "star_func_para_list ::= other_para_list",
 /* 445 */ "other_para_list ::= star_func_para",
 /* 446 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 447 */ "star_func_para ::= expr_or_subquery",
 /* 448 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 449 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 450 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 451 */ "when_then_list ::= when_then_expr",
 /* 452 */ "when_then_list ::= when_then_list when_then_expr",
 /* 453 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 454 */ "case_when_else_opt ::=",
 /* 455 */ "case_when_else_opt ::= ELSE common_expression",
 /* 456 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 457 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 458 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 459 */ "predicate ::= expr_or_subquery IS NULL",
 /* 460 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 461 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 462 */ "compare_op ::= NK_LT",
 /* 463 */ "compare_op ::= NK_GT",
 /* 464 */ "compare_op ::= NK_LE",
 /* 465 */ "compare_op ::= NK_GE",
 /* 466 */ "compare_op ::= NK_NE",
 /* 467 */ "compare_op ::= NK_EQ",
 /* 468 */ "compare_op ::= LIKE",
 /* 469 */ "compare_op ::= NOT LIKE",
 /* 470 */ "compare_op ::= MATCH",
 /* 471 */ "compare_op ::= NMATCH",
 /* 472 */ "compare_op ::= CONTAINS",
 /* 473 */ "in_op ::= IN",
 /* 474 */ "in_op ::= NOT IN",
 /* 475 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 476 */ "boolean_value_expression ::= boolean_primary",
 /* 477 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 478 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 479 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 480 */ "boolean_primary ::= predicate",
 /* 481 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 482 */ "common_expression ::= expr_or_subquery",
 /* 483 */ "common_expression ::= boolean_value_expression",
 /* 484 */ "from_clause_opt ::=",
 /* 485 */ "from_clause_opt ::= FROM table_reference_list",
 /* 486 */ "table_reference_list ::= table_reference",
 /* 487 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 488 */ "table_reference ::= table_primary",
 /* 489 */ "table_reference ::= joined_table",
 /* 490 */ "table_primary ::= table_name alias_opt",
 /* 491 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 492 */ "table_primary ::= subquery alias_opt",
 /* 493 */ "table_primary ::= parenthesized_joined_table",
 /* 494 */ "alias_opt ::=",
 /* 495 */ "alias_opt ::= table_alias",
 /* 496 */ "alias_opt ::= AS table_alias",
 /* 497 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 498 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 499 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 500 */ "join_type ::=",
 /* 501 */ "join_type ::= INNER",
 /* 502 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 503 */ "set_quantifier_opt ::=",
 /* 504 */ "set_quantifier_opt ::= DISTINCT",
 /* 505 */ "set_quantifier_opt ::= ALL",
 /* 506 */ "select_list ::= select_item",
 /* 507 */ "select_list ::= select_list NK_COMMA select_item",
 /* 508 */ "select_item ::= NK_STAR",
 /* 509 */ "select_item ::= common_expression",
 /* 510 */ "select_item ::= common_expression column_alias",
 /* 511 */ "select_item ::= common_expression AS column_alias",
 /* 512 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 513 */ "where_clause_opt ::=",
 /* 514 */ "where_clause_opt ::= WHERE search_condition",
 /* 515 */ "partition_by_clause_opt ::=",
 /* 516 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 517 */ "partition_list ::= partition_item",
 /* 518 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 519 */ "partition_item ::= expr_or_subquery",
 /* 520 */ "partition_item ::= expr_or_subquery column_alias",
 /* 521 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 522 */ "twindow_clause_opt ::=",
 /* 523 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 524 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 525 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 526 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 527 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 528 */ "sliding_opt ::=",
 /* 529 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 530 */ "fill_opt ::=",
 /* 531 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 532 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 533 */ "fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP",
 /* 534 */ "fill_mode ::= NONE",
 /* 535 */ "fill_mode ::= PREV",
 /* 536 */ "fill_mode ::= NULL",
 /* 537 */ "fill_mode ::= NULL_F",
 /* 538 */ "fill_mode ::= LINEAR",
 /* 539 */ "fill_mode ::= NEXT",
 /* 540 */ "group_by_clause_opt ::=",
 /* 541 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 542 */ "group_by_list ::= expr_or_subquery",
 /* 543 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 544 */ "having_clause_opt ::=",
 /* 545 */ "having_clause_opt ::= HAVING search_condition",
 /* 546 */ "range_opt ::=",
 /* 547 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 548 */ "every_opt ::=",
 /* 549 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 550 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 551 */ "query_simple ::= query_specification",
 /* 552 */ "query_simple ::= union_query_expression",
 /* 553 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 554 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 555 */ "query_simple_or_subquery ::= query_simple",
 /* 556 */ "query_simple_or_subquery ::= subquery",
 /* 557 */ "query_or_subquery ::= query_expression",
 /* 558 */ "query_or_subquery ::= subquery",
 /* 559 */ "order_by_clause_opt ::=",
 /* 560 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 561 */ "slimit_clause_opt ::=",
 /* 562 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 563 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 564 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 565 */ "limit_clause_opt ::=",
 /* 566 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 567 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 568 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 569 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 570 */ "subquery ::= NK_LP subquery NK_RP",
 /* 571 */ "search_condition ::= common_expression",
 /* 572 */ "sort_specification_list ::= sort_specification",
 /* 573 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 574 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 575 */ "ordering_specification_opt ::=",
 /* 576 */ "ordering_specification_opt ::= ASC",
 /* 577 */ "ordering_specification_opt ::= DESC",
 /* 578 */ "null_ordering_opt ::=",
 /* 579 */ "null_ordering_opt ::= NULLS FIRST",
 /* 580 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 330: /* cmd */
    case 333: /* literal */
    case 346: /* db_options */
    case 348: /* alter_db_options */
    case 350: /* start_opt */
    case 351: /* end_opt */
    case 356: /* retention */
    case 357: /* full_table_name */
    case 360: /* table_options */
    case 364: /* alter_table_clause */
    case 365: /* alter_table_options */
    case 368: /* signed_literal */
    case 369: /* create_subtable_clause */
    case 372: /* drop_table_clause */
    case 375: /* column_def */
    case 379: /* duration_literal */
    case 380: /* rollup_func_name */
    case 382: /* col_name */
    case 383: /* db_name_cond_opt */
    case 384: /* like_pattern_opt */
    case 385: /* table_name_cond */
    case 386: /* from_db_opt */
    case 388: /* tag_item */
    case 390: /* full_index_name */
    case 391: /* index_options */
    case 394: /* sliding_opt */
    case 395: /* sma_stream_opt */
    case 396: /* func */
    case 398: /* query_or_subquery */
    case 401: /* explain_options */
    case 402: /* insert_query */
    case 408: /* stream_options */
    case 411: /* subtable_opt */
    case 412: /* expression */
    case 414: /* where_clause_opt */
    case 415: /* signed */
    case 416: /* literal_func */
    case 419: /* expr_or_subquery */
    case 420: /* pseudo_column */
    case 421: /* column_reference */
    case 422: /* function_expression */
    case 423: /* case_when_expression */
    case 428: /* star_func_para */
    case 430: /* case_when_else_opt */
    case 431: /* common_expression */
    case 432: /* when_then_expr */
    case 433: /* predicate */
    case 436: /* in_predicate_value */
    case 437: /* boolean_value_expression */
    case 438: /* boolean_primary */
    case 439: /* from_clause_opt */
    case 440: /* table_reference_list */
    case 441: /* table_reference */
    case 442: /* table_primary */
    case 443: /* joined_table */
    case 445: /* subquery */
    case 446: /* parenthesized_joined_table */
    case 448: /* search_condition */
    case 449: /* query_specification */
    case 453: /* range_opt */
    case 454: /* every_opt */
    case 455: /* fill_opt */
    case 456: /* twindow_clause_opt */
    case 458: /* having_clause_opt */
    case 459: /* select_item */
    case 461: /* partition_item */
    case 464: /* query_expression */
    case 465: /* query_simple */
    case 467: /* slimit_clause_opt */
    case 468: /* limit_clause_opt */
    case 469: /* union_query_expression */
    case 470: /* query_simple_or_subquery */
    case 472: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy712)); 
}
      break;
    case 331: /* account_options */
    case 332: /* alter_account_options */
    case 334: /* alter_account_option */
    case 349: /* speed_opt */
    case 405: /* bufsize_opt */
{
 
}
      break;
    case 335: /* user_name */
    case 338: /* priv_level */
    case 341: /* db_name */
    case 342: /* topic_name */
    case 343: /* dnode_endpoint */
    case 366: /* column_name */
    case 374: /* table_name */
    case 381: /* function_name */
    case 389: /* column_alias */
    case 392: /* index_name */
    case 397: /* sma_func_name */
    case 399: /* cgroup_name */
    case 406: /* language_opt */
    case 407: /* stream_name */
    case 418: /* table_alias */
    case 424: /* star_func */
    case 426: /* noarg_func */
    case 444: /* alias_opt */
{
 
}
      break;
    case 336: /* sysinfo_opt */
{
 
}
      break;
    case 337: /* privileges */
    case 339: /* priv_type_list */
    case 340: /* priv_type */
{
 
}
      break;
    case 344: /* force_opt */
    case 345: /* not_exists_opt */
    case 347: /* exists_opt */
    case 400: /* analyze_opt */
    case 403: /* or_replace_opt */
    case 404: /* agg_func_opt */
    case 450: /* set_quantifier_opt */
{
 
}
      break;
    case 352: /* integer_list */
    case 353: /* variable_list */
    case 354: /* retention_list */
    case 358: /* column_def_list */
    case 359: /* tags_def_opt */
    case 361: /* multi_create_clause */
    case 362: /* tags_def */
    case 363: /* multi_drop_clause */
    case 370: /* specific_cols_opt */
    case 371: /* expression_list */
    case 373: /* col_name_list */
    case 376: /* duration_list */
    case 377: /* rollup_func_list */
    case 387: /* tag_list_opt */
    case 393: /* func_list */
    case 409: /* col_list_opt */
    case 410: /* tag_def_or_ref_opt */
    case 413: /* dnode_list */
    case 417: /* literal_list */
    case 425: /* star_func_para_list */
    case 427: /* other_para_list */
    case 429: /* when_then_list */
    case 451: /* select_list */
    case 452: /* partition_by_clause_opt */
    case 457: /* group_by_clause_opt */
    case 460: /* partition_list */
    case 463: /* group_by_list */
    case 466: /* order_by_clause_opt */
    case 471: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy274)); 
}
      break;
    case 355: /* alter_db_option */
    case 378: /* alter_table_option */
{
 
}
      break;
    case 367: /* type_name */
{
 
}
      break;
    case 434: /* compare_op */
    case 435: /* in_op */
{
 
}
      break;
    case 447: /* join_type */
{
 
}
      break;
    case 462: /* fill_mode */
{
 
}
      break;
    case 473: /* ordering_specification_opt */
{
 
}
      break;
    case 474: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  330,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  330,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  331,    0 }, /* (2) account_options ::= */
  {  331,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  331,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  331,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  331,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  331,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  331,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  331,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  331,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  331,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  332,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  332,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  334,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  334,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  334,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  334,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  334,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  334,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  334,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  334,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  334,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  334,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  330,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  330,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  330,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  330,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  330,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  336,    0 }, /* (29) sysinfo_opt ::= */
  {  336,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  330,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  330,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  337,   -1 }, /* (33) privileges ::= ALL */
  {  337,   -1 }, /* (34) privileges ::= priv_type_list */
  {  337,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  339,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  339,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  340,   -1 }, /* (38) priv_type ::= READ */
  {  340,   -1 }, /* (39) priv_type ::= WRITE */
  {  338,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  338,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  338,   -1 }, /* (42) priv_level ::= topic_name */
  {  330,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  330,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  330,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  330,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  330,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  330,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  330,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  330,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  343,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  343,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  343,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  344,    0 }, /* (54) force_opt ::= */
  {  344,   -1 }, /* (55) force_opt ::= FORCE */
  {  330,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  330,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  330,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  330,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  330,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  330,   -2 }, /* (68) cmd ::= USE db_name */
  {  330,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  330,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  330,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  330,   -5 }, /* (72) cmd ::= COMPACT DATABASE db_name start_opt end_opt */
  {  345,   -3 }, /* (73) not_exists_opt ::= IF NOT EXISTS */
  {  345,    0 }, /* (74) not_exists_opt ::= */
  {  347,   -2 }, /* (75) exists_opt ::= IF EXISTS */
  {  347,    0 }, /* (76) exists_opt ::= */
  {  346,    0 }, /* (77) db_options ::= */
  {  346,   -3 }, /* (78) db_options ::= db_options BUFFER NK_INTEGER */
  {  346,   -3 }, /* (79) db_options ::= db_options CACHEMODEL NK_STRING */
  {  346,   -3 }, /* (80) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  346,   -3 }, /* (81) db_options ::= db_options COMP NK_INTEGER */
  {  346,   -3 }, /* (82) db_options ::= db_options DURATION NK_INTEGER */
  {  346,   -3 }, /* (83) db_options ::= db_options DURATION NK_VARIABLE */
  {  346,   -3 }, /* (84) db_options ::= db_options MAXROWS NK_INTEGER */
  {  346,   -3 }, /* (85) db_options ::= db_options MINROWS NK_INTEGER */
  {  346,   -3 }, /* (86) db_options ::= db_options KEEP integer_list */
  {  346,   -3 }, /* (87) db_options ::= db_options KEEP variable_list */
  {  346,   -3 }, /* (88) db_options ::= db_options PAGES NK_INTEGER */
  {  346,   -3 }, /* (89) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  346,   -3 }, /* (90) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  346,   -3 }, /* (91) db_options ::= db_options PRECISION NK_STRING */
  {  346,   -3 }, /* (92) db_options ::= db_options REPLICA NK_INTEGER */
  {  346,   -3 }, /* (93) db_options ::= db_options VGROUPS NK_INTEGER */
  {  346,   -3 }, /* (94) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  346,   -3 }, /* (95) db_options ::= db_options RETENTIONS retention_list */
  {  346,   -3 }, /* (96) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  346,   -3 }, /* (97) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  346,   -3 }, /* (98) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  346,   -3 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  346,   -4 }, /* (100) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  346,   -3 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  346,   -4 }, /* (102) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  346,   -3 }, /* (103) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  346,   -3 }, /* (104) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  346,   -3 }, /* (105) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  346,   -3 }, /* (106) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  346,   -3 }, /* (107) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  348,   -1 }, /* (108) alter_db_options ::= alter_db_option */
  {  348,   -2 }, /* (109) alter_db_options ::= alter_db_options alter_db_option */
  {  355,   -2 }, /* (110) alter_db_option ::= BUFFER NK_INTEGER */
  {  355,   -2 }, /* (111) alter_db_option ::= CACHEMODEL NK_STRING */
  {  355,   -2 }, /* (112) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  355,   -2 }, /* (113) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  355,   -2 }, /* (114) alter_db_option ::= KEEP integer_list */
  {  355,   -2 }, /* (115) alter_db_option ::= KEEP variable_list */
  {  355,   -2 }, /* (116) alter_db_option ::= PAGES NK_INTEGER */
  {  355,   -2 }, /* (117) alter_db_option ::= REPLICA NK_INTEGER */
  {  355,   -2 }, /* (118) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  355,   -2 }, /* (119) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  355,   -2 }, /* (120) alter_db_option ::= MINROWS NK_INTEGER */
  {  355,   -2 }, /* (121) alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
  {  355,   -3 }, /* (122) alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  355,   -2 }, /* (123) alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
  {  355,   -3 }, /* (124) alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  352,   -1 }, /* (125) integer_list ::= NK_INTEGER */
  {  352,   -3 }, /* (126) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  353,   -1 }, /* (127) variable_list ::= NK_VARIABLE */
  {  353,   -3 }, /* (128) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  354,   -1 }, /* (129) retention_list ::= retention */
  {  354,   -3 }, /* (130) retention_list ::= retention_list NK_COMMA retention */
  {  356,   -3 }, /* (131) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  349,    0 }, /* (132) speed_opt ::= */
  {  349,   -2 }, /* (133) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  350,    0 }, /* (134) start_opt ::= */
  {  350,   -3 }, /* (135) start_opt ::= START WITH NK_INTEGER */
  {  350,   -3 }, /* (136) start_opt ::= START WITH NK_STRING */
  {  350,   -4 }, /* (137) start_opt ::= START WITH TIMESTAMP NK_STRING */
  {  351,    0 }, /* (138) end_opt ::= */
  {  351,   -3 }, /* (139) end_opt ::= END WITH NK_INTEGER */
  {  351,   -3 }, /* (140) end_opt ::= END WITH NK_STRING */
  {  351,   -4 }, /* (141) end_opt ::= END WITH TIMESTAMP NK_STRING */
  {  330,   -9 }, /* (142) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  330,   -3 }, /* (143) cmd ::= CREATE TABLE multi_create_clause */
  {  330,   -9 }, /* (144) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  330,   -3 }, /* (145) cmd ::= DROP TABLE multi_drop_clause */
  {  330,   -4 }, /* (146) cmd ::= DROP STABLE exists_opt full_table_name */
  {  330,   -3 }, /* (147) cmd ::= ALTER TABLE alter_table_clause */
  {  330,   -3 }, /* (148) cmd ::= ALTER STABLE alter_table_clause */
  {  364,   -2 }, /* (149) alter_table_clause ::= full_table_name alter_table_options */
  {  364,   -5 }, /* (150) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  364,   -4 }, /* (151) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  364,   -5 }, /* (152) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  364,   -5 }, /* (153) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  364,   -5 }, /* (154) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  364,   -4 }, /* (155) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  364,   -5 }, /* (156) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  364,   -5 }, /* (157) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  364,   -6 }, /* (158) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  361,   -1 }, /* (159) multi_create_clause ::= create_subtable_clause */
  {  361,   -2 }, /* (160) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  369,  -10 }, /* (161) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  363,   -1 }, /* (162) multi_drop_clause ::= drop_table_clause */
  {  363,   -3 }, /* (163) multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */
  {  372,   -2 }, /* (164) drop_table_clause ::= exists_opt full_table_name */
  {  370,    0 }, /* (165) specific_cols_opt ::= */
  {  370,   -3 }, /* (166) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  357,   -1 }, /* (167) full_table_name ::= table_name */
  {  357,   -3 }, /* (168) full_table_name ::= db_name NK_DOT table_name */
  {  358,   -1 }, /* (169) column_def_list ::= column_def */
  {  358,   -3 }, /* (170) column_def_list ::= column_def_list NK_COMMA column_def */
  {  375,   -2 }, /* (171) column_def ::= column_name type_name */
  {  375,   -4 }, /* (172) column_def ::= column_name type_name COMMENT NK_STRING */
  {  367,   -1 }, /* (173) type_name ::= BOOL */
  {  367,   -1 }, /* (174) type_name ::= TINYINT */
  {  367,   -1 }, /* (175) type_name ::= SMALLINT */
  {  367,   -1 }, /* (176) type_name ::= INT */
  {  367,   -1 }, /* (177) type_name ::= INTEGER */
  {  367,   -1 }, /* (178) type_name ::= BIGINT */
  {  367,   -1 }, /* (179) type_name ::= FLOAT */
  {  367,   -1 }, /* (180) type_name ::= DOUBLE */
  {  367,   -4 }, /* (181) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  367,   -1 }, /* (182) type_name ::= TIMESTAMP */
  {  367,   -4 }, /* (183) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  367,   -2 }, /* (184) type_name ::= TINYINT UNSIGNED */
  {  367,   -2 }, /* (185) type_name ::= SMALLINT UNSIGNED */
  {  367,   -2 }, /* (186) type_name ::= INT UNSIGNED */
  {  367,   -2 }, /* (187) type_name ::= BIGINT UNSIGNED */
  {  367,   -1 }, /* (188) type_name ::= JSON */
  {  367,   -4 }, /* (189) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  367,   -1 }, /* (190) type_name ::= MEDIUMBLOB */
  {  367,   -1 }, /* (191) type_name ::= BLOB */
  {  367,   -4 }, /* (192) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  367,   -1 }, /* (193) type_name ::= DECIMAL */
  {  367,   -4 }, /* (194) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  367,   -6 }, /* (195) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  359,    0 }, /* (196) tags_def_opt ::= */
  {  359,   -1 }, /* (197) tags_def_opt ::= tags_def */
  {  362,   -4 }, /* (198) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  360,    0 }, /* (199) table_options ::= */
  {  360,   -3 }, /* (200) table_options ::= table_options COMMENT NK_STRING */
  {  360,   -3 }, /* (201) table_options ::= table_options MAX_DELAY duration_list */
  {  360,   -3 }, /* (202) table_options ::= table_options WATERMARK duration_list */
  {  360,   -5 }, /* (203) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  360,   -3 }, /* (204) table_options ::= table_options TTL NK_INTEGER */
  {  360,   -5 }, /* (205) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  360,   -3 }, /* (206) table_options ::= table_options DELETE_MARK duration_list */
  {  365,   -1 }, /* (207) alter_table_options ::= alter_table_option */
  {  365,   -2 }, /* (208) alter_table_options ::= alter_table_options alter_table_option */
  {  378,   -2 }, /* (209) alter_table_option ::= COMMENT NK_STRING */
  {  378,   -2 }, /* (210) alter_table_option ::= TTL NK_INTEGER */
  {  376,   -1 }, /* (211) duration_list ::= duration_literal */
  {  376,   -3 }, /* (212) duration_list ::= duration_list NK_COMMA duration_literal */
  {  377,   -1 }, /* (213) rollup_func_list ::= rollup_func_name */
  {  377,   -3 }, /* (214) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  380,   -1 }, /* (215) rollup_func_name ::= function_name */
  {  380,   -1 }, /* (216) rollup_func_name ::= FIRST */
  {  380,   -1 }, /* (217) rollup_func_name ::= LAST */
  {  373,   -1 }, /* (218) col_name_list ::= col_name */
  {  373,   -3 }, /* (219) col_name_list ::= col_name_list NK_COMMA col_name */
  {  382,   -1 }, /* (220) col_name ::= column_name */
  {  330,   -2 }, /* (221) cmd ::= SHOW DNODES */
  {  330,   -2 }, /* (222) cmd ::= SHOW USERS */
  {  330,   -3 }, /* (223) cmd ::= SHOW USER PRIVILEGES */
  {  330,   -2 }, /* (224) cmd ::= SHOW DATABASES */
  {  330,   -4 }, /* (225) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  330,   -4 }, /* (226) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  330,   -3 }, /* (227) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  330,   -2 }, /* (228) cmd ::= SHOW MNODES */
  {  330,   -2 }, /* (229) cmd ::= SHOW QNODES */
  {  330,   -2 }, /* (230) cmd ::= SHOW FUNCTIONS */
  {  330,   -5 }, /* (231) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  330,   -2 }, /* (232) cmd ::= SHOW STREAMS */
  {  330,   -2 }, /* (233) cmd ::= SHOW ACCOUNTS */
  {  330,   -2 }, /* (234) cmd ::= SHOW APPS */
  {  330,   -2 }, /* (235) cmd ::= SHOW CONNECTIONS */
  {  330,   -2 }, /* (236) cmd ::= SHOW LICENCES */
  {  330,   -2 }, /* (237) cmd ::= SHOW GRANTS */
  {  330,   -4 }, /* (238) cmd ::= SHOW CREATE DATABASE db_name */
  {  330,   -4 }, /* (239) cmd ::= SHOW CREATE TABLE full_table_name */
  {  330,   -4 }, /* (240) cmd ::= SHOW CREATE STABLE full_table_name */
  {  330,   -2 }, /* (241) cmd ::= SHOW QUERIES */
  {  330,   -2 }, /* (242) cmd ::= SHOW SCORES */
  {  330,   -2 }, /* (243) cmd ::= SHOW TOPICS */
  {  330,   -2 }, /* (244) cmd ::= SHOW VARIABLES */
  {  330,   -3 }, /* (245) cmd ::= SHOW CLUSTER VARIABLES */
  {  330,   -3 }, /* (246) cmd ::= SHOW LOCAL VARIABLES */
  {  330,   -5 }, /* (247) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  330,   -2 }, /* (248) cmd ::= SHOW BNODES */
  {  330,   -2 }, /* (249) cmd ::= SHOW SNODES */
  {  330,   -2 }, /* (250) cmd ::= SHOW CLUSTER */
  {  330,   -2 }, /* (251) cmd ::= SHOW TRANSACTIONS */
  {  330,   -4 }, /* (252) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  330,   -2 }, /* (253) cmd ::= SHOW CONSUMERS */
  {  330,   -2 }, /* (254) cmd ::= SHOW SUBSCRIPTIONS */
  {  330,   -5 }, /* (255) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  330,   -7 }, /* (256) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  330,   -3 }, /* (257) cmd ::= SHOW VNODES NK_INTEGER */
  {  330,   -3 }, /* (258) cmd ::= SHOW VNODES NK_STRING */
  {  330,   -3 }, /* (259) cmd ::= SHOW db_name_cond_opt ALIVE */
  {  330,   -3 }, /* (260) cmd ::= SHOW CLUSTER ALIVE */
  {  383,    0 }, /* (261) db_name_cond_opt ::= */
  {  383,   -2 }, /* (262) db_name_cond_opt ::= db_name NK_DOT */
  {  384,    0 }, /* (263) like_pattern_opt ::= */
  {  384,   -2 }, /* (264) like_pattern_opt ::= LIKE NK_STRING */
  {  385,   -1 }, /* (265) table_name_cond ::= table_name */
  {  386,    0 }, /* (266) from_db_opt ::= */
  {  386,   -2 }, /* (267) from_db_opt ::= FROM db_name */
  {  387,    0 }, /* (268) tag_list_opt ::= */
  {  387,   -1 }, /* (269) tag_list_opt ::= tag_item */
  {  387,   -3 }, /* (270) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  388,   -1 }, /* (271) tag_item ::= TBNAME */
  {  388,   -1 }, /* (272) tag_item ::= QTAGS */
  {  388,   -1 }, /* (273) tag_item ::= column_name */
  {  388,   -2 }, /* (274) tag_item ::= column_name column_alias */
  {  388,   -3 }, /* (275) tag_item ::= column_name AS column_alias */
  {  330,   -8 }, /* (276) cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
  {  330,   -9 }, /* (277) cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
  {  330,   -4 }, /* (278) cmd ::= DROP INDEX exists_opt full_index_name */
  {  390,   -1 }, /* (279) full_index_name ::= index_name */
  {  390,   -3 }, /* (280) full_index_name ::= db_name NK_DOT index_name */
  {  391,  -10 }, /* (281) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  391,  -12 }, /* (282) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  393,   -1 }, /* (283) func_list ::= func */
  {  393,   -3 }, /* (284) func_list ::= func_list NK_COMMA func */
  {  396,   -4 }, /* (285) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  397,   -1 }, /* (286) sma_func_name ::= function_name */
  {  397,   -1 }, /* (287) sma_func_name ::= COUNT */
  {  397,   -1 }, /* (288) sma_func_name ::= FIRST */
  {  397,   -1 }, /* (289) sma_func_name ::= LAST */
  {  397,   -1 }, /* (290) sma_func_name ::= LAST_ROW */
  {  395,    0 }, /* (291) sma_stream_opt ::= */
  {  395,   -3 }, /* (292) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  395,   -3 }, /* (293) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  395,   -3 }, /* (294) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  330,   -6 }, /* (295) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  330,   -7 }, /* (296) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  330,   -9 }, /* (297) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  330,   -7 }, /* (298) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  330,   -9 }, /* (299) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  330,   -4 }, /* (300) cmd ::= DROP TOPIC exists_opt topic_name */
  {  330,   -7 }, /* (301) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  330,   -2 }, /* (302) cmd ::= DESC full_table_name */
  {  330,   -2 }, /* (303) cmd ::= DESCRIBE full_table_name */
  {  330,   -3 }, /* (304) cmd ::= RESET QUERY CACHE */
  {  330,   -4 }, /* (305) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  330,   -4 }, /* (306) cmd ::= EXPLAIN analyze_opt explain_options insert_query */
  {  400,    0 }, /* (307) analyze_opt ::= */
  {  400,   -1 }, /* (308) analyze_opt ::= ANALYZE */
  {  401,    0 }, /* (309) explain_options ::= */
  {  401,   -3 }, /* (310) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  401,   -3 }, /* (311) explain_options ::= explain_options RATIO NK_FLOAT */
  {  330,  -12 }, /* (312) cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
  {  330,   -4 }, /* (313) cmd ::= DROP FUNCTION exists_opt function_name */
  {  404,    0 }, /* (314) agg_func_opt ::= */
  {  404,   -1 }, /* (315) agg_func_opt ::= AGGREGATE */
  {  405,    0 }, /* (316) bufsize_opt ::= */
  {  405,   -2 }, /* (317) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  406,    0 }, /* (318) language_opt ::= */
  {  406,   -2 }, /* (319) language_opt ::= LANGUAGE NK_STRING */
  {  403,    0 }, /* (320) or_replace_opt ::= */
  {  403,   -2 }, /* (321) or_replace_opt ::= OR REPLACE */
  {  330,  -12 }, /* (322) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
  {  330,   -4 }, /* (323) cmd ::= DROP STREAM exists_opt stream_name */
  {  409,    0 }, /* (324) col_list_opt ::= */
  {  409,   -3 }, /* (325) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  410,    0 }, /* (326) tag_def_or_ref_opt ::= */
  {  410,   -1 }, /* (327) tag_def_or_ref_opt ::= tags_def */
  {  410,   -4 }, /* (328) tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */
  {  408,    0 }, /* (329) stream_options ::= */
  {  408,   -3 }, /* (330) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  408,   -3 }, /* (331) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  408,   -4 }, /* (332) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  408,   -3 }, /* (333) stream_options ::= stream_options WATERMARK duration_literal */
  {  408,   -4 }, /* (334) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  408,   -3 }, /* (335) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  408,   -3 }, /* (336) stream_options ::= stream_options DELETE_MARK duration_literal */
  {  408,   -4 }, /* (337) stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
  {  411,    0 }, /* (338) subtable_opt ::= */
  {  411,   -4 }, /* (339) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  330,   -3 }, /* (340) cmd ::= KILL CONNECTION NK_INTEGER */
  {  330,   -3 }, /* (341) cmd ::= KILL QUERY NK_STRING */
  {  330,   -3 }, /* (342) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  330,   -2 }, /* (343) cmd ::= BALANCE VGROUP */
  {  330,   -3 }, /* (344) cmd ::= BALANCE VGROUP LEADER */
  {  330,   -4 }, /* (345) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  330,   -4 }, /* (346) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  330,   -3 }, /* (347) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  413,   -2 }, /* (348) dnode_list ::= DNODE NK_INTEGER */
  {  413,   -3 }, /* (349) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  330,   -4 }, /* (350) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  330,   -1 }, /* (351) cmd ::= query_or_subquery */
  {  330,   -1 }, /* (352) cmd ::= insert_query */
  {  402,   -7 }, /* (353) insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  402,   -4 }, /* (354) insert_query ::= INSERT INTO full_table_name query_or_subquery */
  {  333,   -1 }, /* (355) literal ::= NK_INTEGER */
  {  333,   -1 }, /* (356) literal ::= NK_FLOAT */
  {  333,   -1 }, /* (357) literal ::= NK_STRING */
  {  333,   -1 }, /* (358) literal ::= NK_BOOL */
  {  333,   -2 }, /* (359) literal ::= TIMESTAMP NK_STRING */
  {  333,   -1 }, /* (360) literal ::= duration_literal */
  {  333,   -1 }, /* (361) literal ::= NULL */
  {  333,   -1 }, /* (362) literal ::= NK_QUESTION */
  {  379,   -1 }, /* (363) duration_literal ::= NK_VARIABLE */
  {  415,   -1 }, /* (364) signed ::= NK_INTEGER */
  {  415,   -2 }, /* (365) signed ::= NK_PLUS NK_INTEGER */
  {  415,   -2 }, /* (366) signed ::= NK_MINUS NK_INTEGER */
  {  415,   -1 }, /* (367) signed ::= NK_FLOAT */
  {  415,   -2 }, /* (368) signed ::= NK_PLUS NK_FLOAT */
  {  415,   -2 }, /* (369) signed ::= NK_MINUS NK_FLOAT */
  {  368,   -1 }, /* (370) signed_literal ::= signed */
  {  368,   -1 }, /* (371) signed_literal ::= NK_STRING */
  {  368,   -1 }, /* (372) signed_literal ::= NK_BOOL */
  {  368,   -2 }, /* (373) signed_literal ::= TIMESTAMP NK_STRING */
  {  368,   -1 }, /* (374) signed_literal ::= duration_literal */
  {  368,   -1 }, /* (375) signed_literal ::= NULL */
  {  368,   -1 }, /* (376) signed_literal ::= literal_func */
  {  368,   -1 }, /* (377) signed_literal ::= NK_QUESTION */
  {  417,   -1 }, /* (378) literal_list ::= signed_literal */
  {  417,   -3 }, /* (379) literal_list ::= literal_list NK_COMMA signed_literal */
  {  341,   -1 }, /* (380) db_name ::= NK_ID */
  {  374,   -1 }, /* (381) table_name ::= NK_ID */
  {  366,   -1 }, /* (382) column_name ::= NK_ID */
  {  381,   -1 }, /* (383) function_name ::= NK_ID */
  {  418,   -1 }, /* (384) table_alias ::= NK_ID */
  {  389,   -1 }, /* (385) column_alias ::= NK_ID */
  {  335,   -1 }, /* (386) user_name ::= NK_ID */
  {  342,   -1 }, /* (387) topic_name ::= NK_ID */
  {  407,   -1 }, /* (388) stream_name ::= NK_ID */
  {  399,   -1 }, /* (389) cgroup_name ::= NK_ID */
  {  392,   -1 }, /* (390) index_name ::= NK_ID */
  {  419,   -1 }, /* (391) expr_or_subquery ::= expression */
  {  412,   -1 }, /* (392) expression ::= literal */
  {  412,   -1 }, /* (393) expression ::= pseudo_column */
  {  412,   -1 }, /* (394) expression ::= column_reference */
  {  412,   -1 }, /* (395) expression ::= function_expression */
  {  412,   -1 }, /* (396) expression ::= case_when_expression */
  {  412,   -3 }, /* (397) expression ::= NK_LP expression NK_RP */
  {  412,   -2 }, /* (398) expression ::= NK_PLUS expr_or_subquery */
  {  412,   -2 }, /* (399) expression ::= NK_MINUS expr_or_subquery */
  {  412,   -3 }, /* (400) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  412,   -3 }, /* (401) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  412,   -3 }, /* (402) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  412,   -3 }, /* (403) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  412,   -3 }, /* (404) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  412,   -3 }, /* (405) expression ::= column_reference NK_ARROW NK_STRING */
  {  412,   -3 }, /* (406) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  412,   -3 }, /* (407) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  371,   -1 }, /* (408) expression_list ::= expr_or_subquery */
  {  371,   -3 }, /* (409) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  421,   -1 }, /* (410) column_reference ::= column_name */
  {  421,   -3 }, /* (411) column_reference ::= table_name NK_DOT column_name */
  {  420,   -1 }, /* (412) pseudo_column ::= ROWTS */
  {  420,   -1 }, /* (413) pseudo_column ::= TBNAME */
  {  420,   -3 }, /* (414) pseudo_column ::= table_name NK_DOT TBNAME */
  {  420,   -1 }, /* (415) pseudo_column ::= QSTART */
  {  420,   -1 }, /* (416) pseudo_column ::= QEND */
  {  420,   -1 }, /* (417) pseudo_column ::= QDURATION */
  {  420,   -1 }, /* (418) pseudo_column ::= WSTART */
  {  420,   -1 }, /* (419) pseudo_column ::= WEND */
  {  420,   -1 }, /* (420) pseudo_column ::= WDURATION */
  {  420,   -1 }, /* (421) pseudo_column ::= IROWTS */
  {  420,   -1 }, /* (422) pseudo_column ::= ISFILLED */
  {  420,   -1 }, /* (423) pseudo_column ::= QTAGS */
  {  422,   -4 }, /* (424) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  422,   -4 }, /* (425) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  422,   -6 }, /* (426) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  422,   -1 }, /* (427) function_expression ::= literal_func */
  {  416,   -3 }, /* (428) literal_func ::= noarg_func NK_LP NK_RP */
  {  416,   -1 }, /* (429) literal_func ::= NOW */
  {  426,   -1 }, /* (430) noarg_func ::= NOW */
  {  426,   -1 }, /* (431) noarg_func ::= TODAY */
  {  426,   -1 }, /* (432) noarg_func ::= TIMEZONE */
  {  426,   -1 }, /* (433) noarg_func ::= DATABASE */
  {  426,   -1 }, /* (434) noarg_func ::= CLIENT_VERSION */
  {  426,   -1 }, /* (435) noarg_func ::= SERVER_VERSION */
  {  426,   -1 }, /* (436) noarg_func ::= SERVER_STATUS */
  {  426,   -1 }, /* (437) noarg_func ::= CURRENT_USER */
  {  426,   -1 }, /* (438) noarg_func ::= USER */
  {  424,   -1 }, /* (439) star_func ::= COUNT */
  {  424,   -1 }, /* (440) star_func ::= FIRST */
  {  424,   -1 }, /* (441) star_func ::= LAST */
  {  424,   -1 }, /* (442) star_func ::= LAST_ROW */
  {  425,   -1 }, /* (443) star_func_para_list ::= NK_STAR */
  {  425,   -1 }, /* (444) star_func_para_list ::= other_para_list */
  {  427,   -1 }, /* (445) other_para_list ::= star_func_para */
  {  427,   -3 }, /* (446) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  428,   -1 }, /* (447) star_func_para ::= expr_or_subquery */
  {  428,   -3 }, /* (448) star_func_para ::= table_name NK_DOT NK_STAR */
  {  423,   -4 }, /* (449) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  423,   -5 }, /* (450) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  429,   -1 }, /* (451) when_then_list ::= when_then_expr */
  {  429,   -2 }, /* (452) when_then_list ::= when_then_list when_then_expr */
  {  432,   -4 }, /* (453) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  430,    0 }, /* (454) case_when_else_opt ::= */
  {  430,   -2 }, /* (455) case_when_else_opt ::= ELSE common_expression */
  {  433,   -3 }, /* (456) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  433,   -5 }, /* (457) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  433,   -6 }, /* (458) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  433,   -3 }, /* (459) predicate ::= expr_or_subquery IS NULL */
  {  433,   -4 }, /* (460) predicate ::= expr_or_subquery IS NOT NULL */
  {  433,   -3 }, /* (461) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  434,   -1 }, /* (462) compare_op ::= NK_LT */
  {  434,   -1 }, /* (463) compare_op ::= NK_GT */
  {  434,   -1 }, /* (464) compare_op ::= NK_LE */
  {  434,   -1 }, /* (465) compare_op ::= NK_GE */
  {  434,   -1 }, /* (466) compare_op ::= NK_NE */
  {  434,   -1 }, /* (467) compare_op ::= NK_EQ */
  {  434,   -1 }, /* (468) compare_op ::= LIKE */
  {  434,   -2 }, /* (469) compare_op ::= NOT LIKE */
  {  434,   -1 }, /* (470) compare_op ::= MATCH */
  {  434,   -1 }, /* (471) compare_op ::= NMATCH */
  {  434,   -1 }, /* (472) compare_op ::= CONTAINS */
  {  435,   -1 }, /* (473) in_op ::= IN */
  {  435,   -2 }, /* (474) in_op ::= NOT IN */
  {  436,   -3 }, /* (475) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  437,   -1 }, /* (476) boolean_value_expression ::= boolean_primary */
  {  437,   -2 }, /* (477) boolean_value_expression ::= NOT boolean_primary */
  {  437,   -3 }, /* (478) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  437,   -3 }, /* (479) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  438,   -1 }, /* (480) boolean_primary ::= predicate */
  {  438,   -3 }, /* (481) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  431,   -1 }, /* (482) common_expression ::= expr_or_subquery */
  {  431,   -1 }, /* (483) common_expression ::= boolean_value_expression */
  {  439,    0 }, /* (484) from_clause_opt ::= */
  {  439,   -2 }, /* (485) from_clause_opt ::= FROM table_reference_list */
  {  440,   -1 }, /* (486) table_reference_list ::= table_reference */
  {  440,   -3 }, /* (487) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  441,   -1 }, /* (488) table_reference ::= table_primary */
  {  441,   -1 }, /* (489) table_reference ::= joined_table */
  {  442,   -2 }, /* (490) table_primary ::= table_name alias_opt */
  {  442,   -4 }, /* (491) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  442,   -2 }, /* (492) table_primary ::= subquery alias_opt */
  {  442,   -1 }, /* (493) table_primary ::= parenthesized_joined_table */
  {  444,    0 }, /* (494) alias_opt ::= */
  {  444,   -1 }, /* (495) alias_opt ::= table_alias */
  {  444,   -2 }, /* (496) alias_opt ::= AS table_alias */
  {  446,   -3 }, /* (497) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  446,   -3 }, /* (498) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  443,   -6 }, /* (499) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  447,    0 }, /* (500) join_type ::= */
  {  447,   -1 }, /* (501) join_type ::= INNER */
  {  449,  -12 }, /* (502) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  450,    0 }, /* (503) set_quantifier_opt ::= */
  {  450,   -1 }, /* (504) set_quantifier_opt ::= DISTINCT */
  {  450,   -1 }, /* (505) set_quantifier_opt ::= ALL */
  {  451,   -1 }, /* (506) select_list ::= select_item */
  {  451,   -3 }, /* (507) select_list ::= select_list NK_COMMA select_item */
  {  459,   -1 }, /* (508) select_item ::= NK_STAR */
  {  459,   -1 }, /* (509) select_item ::= common_expression */
  {  459,   -2 }, /* (510) select_item ::= common_expression column_alias */
  {  459,   -3 }, /* (511) select_item ::= common_expression AS column_alias */
  {  459,   -3 }, /* (512) select_item ::= table_name NK_DOT NK_STAR */
  {  414,    0 }, /* (513) where_clause_opt ::= */
  {  414,   -2 }, /* (514) where_clause_opt ::= WHERE search_condition */
  {  452,    0 }, /* (515) partition_by_clause_opt ::= */
  {  452,   -3 }, /* (516) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  460,   -1 }, /* (517) partition_list ::= partition_item */
  {  460,   -3 }, /* (518) partition_list ::= partition_list NK_COMMA partition_item */
  {  461,   -1 }, /* (519) partition_item ::= expr_or_subquery */
  {  461,   -2 }, /* (520) partition_item ::= expr_or_subquery column_alias */
  {  461,   -3 }, /* (521) partition_item ::= expr_or_subquery AS column_alias */
  {  456,    0 }, /* (522) twindow_clause_opt ::= */
  {  456,   -6 }, /* (523) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  456,   -4 }, /* (524) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  456,   -6 }, /* (525) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  456,   -8 }, /* (526) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  456,   -7 }, /* (527) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  394,    0 }, /* (528) sliding_opt ::= */
  {  394,   -4 }, /* (529) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  455,    0 }, /* (530) fill_opt ::= */
  {  455,   -4 }, /* (531) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  455,   -6 }, /* (532) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  455,   -6 }, /* (533) fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
  {  462,   -1 }, /* (534) fill_mode ::= NONE */
  {  462,   -1 }, /* (535) fill_mode ::= PREV */
  {  462,   -1 }, /* (536) fill_mode ::= NULL */
  {  462,   -1 }, /* (537) fill_mode ::= NULL_F */
  {  462,   -1 }, /* (538) fill_mode ::= LINEAR */
  {  462,   -1 }, /* (539) fill_mode ::= NEXT */
  {  457,    0 }, /* (540) group_by_clause_opt ::= */
  {  457,   -3 }, /* (541) group_by_clause_opt ::= GROUP BY group_by_list */
  {  463,   -1 }, /* (542) group_by_list ::= expr_or_subquery */
  {  463,   -3 }, /* (543) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  458,    0 }, /* (544) having_clause_opt ::= */
  {  458,   -2 }, /* (545) having_clause_opt ::= HAVING search_condition */
  {  453,    0 }, /* (546) range_opt ::= */
  {  453,   -6 }, /* (547) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  454,    0 }, /* (548) every_opt ::= */
  {  454,   -4 }, /* (549) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  464,   -4 }, /* (550) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  465,   -1 }, /* (551) query_simple ::= query_specification */
  {  465,   -1 }, /* (552) query_simple ::= union_query_expression */
  {  469,   -4 }, /* (553) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  469,   -3 }, /* (554) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  470,   -1 }, /* (555) query_simple_or_subquery ::= query_simple */
  {  470,   -1 }, /* (556) query_simple_or_subquery ::= subquery */
  {  398,   -1 }, /* (557) query_or_subquery ::= query_expression */
  {  398,   -1 }, /* (558) query_or_subquery ::= subquery */
  {  466,    0 }, /* (559) order_by_clause_opt ::= */
  {  466,   -3 }, /* (560) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  467,    0 }, /* (561) slimit_clause_opt ::= */
  {  467,   -2 }, /* (562) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  467,   -4 }, /* (563) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  467,   -4 }, /* (564) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  468,    0 }, /* (565) limit_clause_opt ::= */
  {  468,   -2 }, /* (566) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  468,   -4 }, /* (567) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  468,   -4 }, /* (568) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  445,   -3 }, /* (569) subquery ::= NK_LP query_expression NK_RP */
  {  445,   -3 }, /* (570) subquery ::= NK_LP subquery NK_RP */
  {  448,   -1 }, /* (571) search_condition ::= common_expression */
  {  471,   -1 }, /* (572) sort_specification_list ::= sort_specification */
  {  471,   -3 }, /* (573) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  472,   -3 }, /* (574) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  473,    0 }, /* (575) ordering_specification_opt ::= */
  {  473,   -1 }, /* (576) ordering_specification_opt ::= ASC */
  {  473,   -1 }, /* (577) ordering_specification_opt ::= DESC */
  {  474,    0 }, /* (578) null_ordering_opt ::= */
  {  474,   -2 }, /* (579) null_ordering_opt ::= NULLS FIRST */
  {  474,   -2 }, /* (580) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,331,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,332,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,331,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,333,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,334,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,332,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,334,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,333,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy129, &yymsp[-1].minor.yy0, yymsp[0].minor.yy353); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy129, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy129, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy129, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy353 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy353 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy359, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy129); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy359, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy129); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy359 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy359 = yymsp[0].minor.yy359; }
  yymsp[0].minor.yy359 = yylhsminor.yy359;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy359 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy359 = yymsp[-2].minor.yy359 | yymsp[0].minor.yy359; }
  yymsp[-2].minor.yy359 = yylhsminor.yy359;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy359 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy359 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy129 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy129 = yylhsminor.yy129;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy129 = yymsp[-2].minor.yy129; }
  yymsp[-2].minor.yy129 = yylhsminor.yy129;
        break;
      case 42: /* priv_level ::= topic_name */
      case 286: /* sma_func_name ::= function_name */ yytestcase(yyruleno==286);
      case 495: /* alias_opt ::= table_alias */ yytestcase(yyruleno==495);
{ yylhsminor.yy129 = yymsp[0].minor.yy129; }
  yymsp[0].minor.yy129 = yylhsminor.yy129;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy129, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy337); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy129, yymsp[0].minor.yy337); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 287: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==287);
      case 288: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==288);
      case 289: /* sma_func_name ::= LAST */ yytestcase(yyruleno==289);
      case 290: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==290);
      case 380: /* db_name ::= NK_ID */ yytestcase(yyruleno==380);
      case 381: /* table_name ::= NK_ID */ yytestcase(yyruleno==381);
      case 382: /* column_name ::= NK_ID */ yytestcase(yyruleno==382);
      case 383: /* function_name ::= NK_ID */ yytestcase(yyruleno==383);
      case 384: /* table_alias ::= NK_ID */ yytestcase(yyruleno==384);
      case 385: /* column_alias ::= NK_ID */ yytestcase(yyruleno==385);
      case 386: /* user_name ::= NK_ID */ yytestcase(yyruleno==386);
      case 387: /* topic_name ::= NK_ID */ yytestcase(yyruleno==387);
      case 388: /* stream_name ::= NK_ID */ yytestcase(yyruleno==388);
      case 389: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==389);
      case 390: /* index_name ::= NK_ID */ yytestcase(yyruleno==390);
      case 430: /* noarg_func ::= NOW */ yytestcase(yyruleno==430);
      case 431: /* noarg_func ::= TODAY */ yytestcase(yyruleno==431);
      case 432: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==432);
      case 433: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==433);
      case 434: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==434);
      case 435: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==435);
      case 436: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==436);
      case 437: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==437);
      case 438: /* noarg_func ::= USER */ yytestcase(yyruleno==438);
      case 439: /* star_func ::= COUNT */ yytestcase(yyruleno==439);
      case 440: /* star_func ::= FIRST */ yytestcase(yyruleno==440);
      case 441: /* star_func ::= LAST */ yytestcase(yyruleno==441);
      case 442: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==442);
{ yylhsminor.yy129 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy129 = yylhsminor.yy129;
        break;
      case 54: /* force_opt ::= */
      case 74: /* not_exists_opt ::= */ yytestcase(yyruleno==74);
      case 76: /* exists_opt ::= */ yytestcase(yyruleno==76);
      case 307: /* analyze_opt ::= */ yytestcase(yyruleno==307);
      case 314: /* agg_func_opt ::= */ yytestcase(yyruleno==314);
      case 320: /* or_replace_opt ::= */ yytestcase(yyruleno==320);
      case 503: /* set_quantifier_opt ::= */ yytestcase(yyruleno==503);
{ yymsp[1].minor.yy337 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 308: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==308);
      case 315: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==315);
      case 504: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==504);
{ yymsp[0].minor.yy337 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy337, &yymsp[-1].minor.yy129, yymsp[0].minor.yy712); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy337, &yymsp[0].minor.yy129); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy129, yymsp[0].minor.yy712); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy129, yymsp[0].minor.yy310); }
        break;
      case 72: /* cmd ::= COMPACT DATABASE db_name start_opt end_opt */
{ pCxt->pRootNode = createCompactStmt(pCxt, &yymsp[-2].minor.yy129, yymsp[-1].minor.yy712, yymsp[0].minor.yy712); }
        break;
      case 73: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy337 = true; }
        break;
      case 75: /* exists_opt ::= IF EXISTS */
      case 321: /* or_replace_opt ::= OR REPLACE */ yytestcase(yyruleno==321);
{ yymsp[-1].minor.yy337 = true; }
        break;
      case 77: /* db_options ::= */
{ yymsp[1].minor.yy712 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 78: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 79: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 80: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 81: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 82: /* db_options ::= db_options DURATION NK_INTEGER */
      case 83: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==83);
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 84: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 85: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 86: /* db_options ::= db_options KEEP integer_list */
      case 87: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==87);
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_KEEP, yymsp[0].minor.yy274); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 88: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 89: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 90: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 91: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 92: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 93: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 94: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 95: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_RETENTIONS, yymsp[0].minor.yy274); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 96: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 97: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 98: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-3].minor.yy712, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 102: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-3].minor.yy712, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 103: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 104: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 105: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 106: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 107: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy712 = setDatabaseOption(pCxt, yymsp[-2].minor.yy712, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 108: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy712 = createAlterDatabaseOptions(pCxt); yylhsminor.yy712 = setAlterDatabaseOption(pCxt, yylhsminor.yy712, &yymsp[0].minor.yy595); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 109: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy712 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy712, &yymsp[0].minor.yy595); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 110: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy595.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy595.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy595.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy595.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy595.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy595.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy595.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy595.val = yymsp[0].minor.yy0; }
        break;
      case 114: /* alter_db_option ::= KEEP integer_list */
      case 115: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==115);
{ yymsp[-1].minor.yy595.type = DB_OPTION_KEEP; yymsp[-1].minor.yy595.pList = yymsp[0].minor.yy274; }
        break;
      case 116: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy595.type = DB_OPTION_PAGES; yymsp[-1].minor.yy595.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy595.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy595.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy595.type = DB_OPTION_WAL; yymsp[-1].minor.yy595.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy595.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy595.val = yymsp[0].minor.yy0; }
        break;
      case 120: /* alter_db_option ::= MINROWS NK_INTEGER */
{ yymsp[-1].minor.yy595.type = DB_OPTION_MINROWS; yymsp[-1].minor.yy595.val = yymsp[0].minor.yy0; }
        break;
      case 121: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy595.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-1].minor.yy595.val = yymsp[0].minor.yy0; }
        break;
      case 122: /* alter_db_option ::= WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy595.type = DB_OPTION_WAL_RETENTION_PERIOD; yymsp[-2].minor.yy595.val = t;
                                                                                  }
        break;
      case 123: /* alter_db_option ::= WAL_RETENTION_SIZE NK_INTEGER */
{ yymsp[-1].minor.yy595.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-1].minor.yy595.val = yymsp[0].minor.yy0; }
        break;
      case 124: /* alter_db_option ::= WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yymsp[-2].minor.yy595.type = DB_OPTION_WAL_RETENTION_SIZE; yymsp[-2].minor.yy595.val = t;
                                                                                  }
        break;
      case 125: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy274 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy274 = yylhsminor.yy274;
        break;
      case 126: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 349: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==349);
{ yylhsminor.yy274 = addNodeToList(pCxt, yymsp[-2].minor.yy274, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy274 = yylhsminor.yy274;
        break;
      case 127: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy274 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy274 = yylhsminor.yy274;
        break;
      case 128: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy274 = addNodeToList(pCxt, yymsp[-2].minor.yy274, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy274 = yylhsminor.yy274;
        break;
      case 129: /* retention_list ::= retention */
      case 159: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==159);
      case 162: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==162);
      case 169: /* column_def_list ::= column_def */ yytestcase(yyruleno==169);
      case 213: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==213);
      case 218: /* col_name_list ::= col_name */ yytestcase(yyruleno==218);
      case 269: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==269);
      case 283: /* func_list ::= func */ yytestcase(yyruleno==283);
      case 378: /* literal_list ::= signed_literal */ yytestcase(yyruleno==378);
      case 445: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==445);
      case 451: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==451);
      case 506: /* select_list ::= select_item */ yytestcase(yyruleno==506);
      case 517: /* partition_list ::= partition_item */ yytestcase(yyruleno==517);
      case 572: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==572);
{ yylhsminor.yy274 = createNodeList(pCxt, yymsp[0].minor.yy712); }
  yymsp[0].minor.yy274 = yylhsminor.yy274;
        break;
      case 130: /* retention_list ::= retention_list NK_COMMA retention */
      case 163: /* multi_drop_clause ::= multi_drop_clause NK_COMMA drop_table_clause */ yytestcase(yyruleno==163);
      case 170: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==170);
      case 214: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==214);
      case 219: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==219);
      case 270: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==270);
      case 284: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==284);
      case 379: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==379);
      case 446: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==446);
      case 507: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==507);
      case 518: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==518);
      case 573: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==573);
{ yylhsminor.yy274 = addNodeToList(pCxt, yymsp[-2].minor.yy274, yymsp[0].minor.yy712); }
  yymsp[-2].minor.yy274 = yylhsminor.yy274;
        break;
      case 131: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy712 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 132: /* speed_opt ::= */
      case 316: /* bufsize_opt ::= */ yytestcase(yyruleno==316);
{ yymsp[1].minor.yy310 = 0; }
        break;
      case 133: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 317: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==317);
{ yymsp[-1].minor.yy310 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 134: /* start_opt ::= */
      case 138: /* end_opt ::= */ yytestcase(yyruleno==138);
      case 263: /* like_pattern_opt ::= */ yytestcase(yyruleno==263);
      case 338: /* subtable_opt ::= */ yytestcase(yyruleno==338);
      case 454: /* case_when_else_opt ::= */ yytestcase(yyruleno==454);
      case 484: /* from_clause_opt ::= */ yytestcase(yyruleno==484);
      case 513: /* where_clause_opt ::= */ yytestcase(yyruleno==513);
      case 522: /* twindow_clause_opt ::= */ yytestcase(yyruleno==522);
      case 528: /* sliding_opt ::= */ yytestcase(yyruleno==528);
      case 530: /* fill_opt ::= */ yytestcase(yyruleno==530);
      case 544: /* having_clause_opt ::= */ yytestcase(yyruleno==544);
      case 546: /* range_opt ::= */ yytestcase(yyruleno==546);
      case 548: /* every_opt ::= */ yytestcase(yyruleno==548);
      case 561: /* slimit_clause_opt ::= */ yytestcase(yyruleno==561);
      case 565: /* limit_clause_opt ::= */ yytestcase(yyruleno==565);
{ yymsp[1].minor.yy712 = NULL; }
        break;
      case 135: /* start_opt ::= START WITH NK_INTEGER */
      case 139: /* end_opt ::= END WITH NK_INTEGER */ yytestcase(yyruleno==139);
{ yymsp[-2].minor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 136: /* start_opt ::= START WITH NK_STRING */
      case 140: /* end_opt ::= END WITH NK_STRING */ yytestcase(yyruleno==140);
{ yymsp[-2].minor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 137: /* start_opt ::= START WITH TIMESTAMP NK_STRING */
      case 141: /* end_opt ::= END WITH TIMESTAMP NK_STRING */ yytestcase(yyruleno==141);
{ yymsp[-3].minor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 142: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 144: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==144);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy337, yymsp[-5].minor.yy712, yymsp[-3].minor.yy274, yymsp[-1].minor.yy274, yymsp[0].minor.yy712); }
        break;
      case 143: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy274); }
        break;
      case 145: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy274); }
        break;
      case 146: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy337, yymsp[0].minor.yy712); }
        break;
      case 147: /* cmd ::= ALTER TABLE alter_table_clause */
      case 351: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==351);
      case 352: /* cmd ::= insert_query */ yytestcase(yyruleno==352);
{ pCxt->pRootNode = yymsp[0].minor.yy712; }
        break;
      case 148: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy712); }
        break;
      case 149: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy712 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy712, yymsp[0].minor.yy712); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 150: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy712 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy712, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy129, yymsp[0].minor.yy184); }
  yymsp[-4].minor.yy712 = yylhsminor.yy712;
        break;
      case 151: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy712 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy712, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy129); }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 152: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy712 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy712, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy129, yymsp[0].minor.yy184); }
  yymsp[-4].minor.yy712 = yylhsminor.yy712;
        break;
      case 153: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy712 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy712, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy129, &yymsp[0].minor.yy129); }
  yymsp[-4].minor.yy712 = yylhsminor.yy712;
        break;
      case 154: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy712 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy712, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy129, yymsp[0].minor.yy184); }
  yymsp[-4].minor.yy712 = yylhsminor.yy712;
        break;
      case 155: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy712 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy712, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy129); }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 156: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy712 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy712, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy129, yymsp[0].minor.yy184); }
  yymsp[-4].minor.yy712 = yylhsminor.yy712;
        break;
      case 157: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy712 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy712, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy129, &yymsp[0].minor.yy129); }
  yymsp[-4].minor.yy712 = yylhsminor.yy712;
        break;
      case 158: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy712 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy712, &yymsp[-2].minor.yy129, yymsp[0].minor.yy712); }
  yymsp[-5].minor.yy712 = yylhsminor.yy712;
        break;
      case 160: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 452: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==452);
{ yylhsminor.yy274 = addNodeToList(pCxt, yymsp[-1].minor.yy274, yymsp[0].minor.yy712); }
  yymsp[-1].minor.yy274 = yylhsminor.yy274;
        break;
      case 161: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy712 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy337, yymsp[-8].minor.yy712, yymsp[-6].minor.yy712, yymsp[-5].minor.yy274, yymsp[-2].minor.yy274, yymsp[0].minor.yy712); }
  yymsp[-9].minor.yy712 = yylhsminor.yy712;
        break;
      case 164: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy712 = createDropTableClause(pCxt, yymsp[-1].minor.yy337, yymsp[0].minor.yy712); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 165: /* specific_cols_opt ::= */
      case 196: /* tags_def_opt ::= */ yytestcase(yyruleno==196);
      case 268: /* tag_list_opt ::= */ yytestcase(yyruleno==268);
      case 324: /* col_list_opt ::= */ yytestcase(yyruleno==324);
      case 326: /* tag_def_or_ref_opt ::= */ yytestcase(yyruleno==326);
      case 515: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==515);
      case 540: /* group_by_clause_opt ::= */ yytestcase(yyruleno==540);
      case 559: /* order_by_clause_opt ::= */ yytestcase(yyruleno==559);
{ yymsp[1].minor.yy274 = NULL; }
        break;
      case 166: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 325: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==325);
{ yymsp[-2].minor.yy274 = yymsp[-1].minor.yy274; }
        break;
      case 167: /* full_table_name ::= table_name */
{ yylhsminor.yy712 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy129, NULL); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 168: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy712 = createRealTableNode(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy129, NULL); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 171: /* column_def ::= column_name type_name */
{ yylhsminor.yy712 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy129, yymsp[0].minor.yy184, NULL); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 172: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy712 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy129, yymsp[-2].minor.yy184, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 173: /* type_name ::= BOOL */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 174: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 175: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 176: /* type_name ::= INT */
      case 177: /* type_name ::= INTEGER */ yytestcase(yyruleno==177);
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 178: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 179: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 180: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 181: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy184 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 182: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 183: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy184 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 184: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy184 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 185: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy184 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 186: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy184 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 187: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy184 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 188: /* type_name ::= JSON */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 189: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy184 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 190: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 191: /* type_name ::= BLOB */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 192: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy184 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 193: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy184 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 194: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy184 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 195: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy184 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 197: /* tags_def_opt ::= tags_def */
      case 327: /* tag_def_or_ref_opt ::= tags_def */ yytestcase(yyruleno==327);
      case 444: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==444);
{ yylhsminor.yy274 = yymsp[0].minor.yy274; }
  yymsp[0].minor.yy274 = yylhsminor.yy274;
        break;
      case 198: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
      case 328: /* tag_def_or_ref_opt ::= TAGS NK_LP col_name_list NK_RP */ yytestcase(yyruleno==328);
{ yymsp[-3].minor.yy274 = yymsp[-1].minor.yy274; }
        break;
      case 199: /* table_options ::= */
{ yymsp[1].minor.yy712 = createDefaultTableOptions(pCxt); }
        break;
      case 200: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy712 = setTableOption(pCxt, yymsp[-2].minor.yy712, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 201: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy712 = setTableOption(pCxt, yymsp[-2].minor.yy712, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy274); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 202: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy712 = setTableOption(pCxt, yymsp[-2].minor.yy712, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy274); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 203: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy712 = setTableOption(pCxt, yymsp[-4].minor.yy712, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy274); }
  yymsp[-4].minor.yy712 = yylhsminor.yy712;
        break;
      case 204: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy712 = setTableOption(pCxt, yymsp[-2].minor.yy712, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 205: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy712 = setTableOption(pCxt, yymsp[-4].minor.yy712, TABLE_OPTION_SMA, yymsp[-1].minor.yy274); }
  yymsp[-4].minor.yy712 = yylhsminor.yy712;
        break;
      case 206: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy712 = setTableOption(pCxt, yymsp[-2].minor.yy712, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy274); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 207: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy712 = createAlterTableOptions(pCxt); yylhsminor.yy712 = setTableOption(pCxt, yylhsminor.yy712, yymsp[0].minor.yy595.type, &yymsp[0].minor.yy595.val); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 208: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy712 = setTableOption(pCxt, yymsp[-1].minor.yy712, yymsp[0].minor.yy595.type, &yymsp[0].minor.yy595.val); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 209: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy595.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy595.val = yymsp[0].minor.yy0; }
        break;
      case 210: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy595.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy595.val = yymsp[0].minor.yy0; }
        break;
      case 211: /* duration_list ::= duration_literal */
      case 408: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==408);
{ yylhsminor.yy274 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy712)); }
  yymsp[0].minor.yy274 = yylhsminor.yy274;
        break;
      case 212: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 409: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==409);
{ yylhsminor.yy274 = addNodeToList(pCxt, yymsp[-2].minor.yy274, releaseRawExprNode(pCxt, yymsp[0].minor.yy712)); }
  yymsp[-2].minor.yy274 = yylhsminor.yy274;
        break;
      case 215: /* rollup_func_name ::= function_name */
{ yylhsminor.yy712 = createFunctionNode(pCxt, &yymsp[0].minor.yy129, NULL); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 216: /* rollup_func_name ::= FIRST */
      case 217: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==217);
      case 272: /* tag_item ::= QTAGS */ yytestcase(yyruleno==272);
{ yylhsminor.yy712 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 220: /* col_name ::= column_name */
      case 273: /* tag_item ::= column_name */ yytestcase(yyruleno==273);
{ yylhsminor.yy712 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy129); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 221: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 222: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 223: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 224: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 225: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy712, yymsp[0].minor.yy712, OP_TYPE_LIKE); }
        break;
      case 226: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy712, yymsp[0].minor.yy712, OP_TYPE_LIKE); }
        break;
      case 227: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy712, NULL, OP_TYPE_LIKE); }
        break;
      case 228: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 229: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 230: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 231: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy712, yymsp[-1].minor.yy712, OP_TYPE_EQUAL); }
        break;
      case 232: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 233: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 234: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 235: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 236: /* cmd ::= SHOW LICENCES */
      case 237: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==237);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 238: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 239: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy712); }
        break;
      case 240: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy712); }
        break;
      case 241: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 242: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 243: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 244: /* cmd ::= SHOW VARIABLES */
      case 245: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==245);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 246: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 247: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy712); }
        break;
      case 248: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 249: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 250: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 251: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 252: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy712); }
        break;
      case 253: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 254: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 255: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy712, yymsp[-1].minor.yy712, OP_TYPE_EQUAL); }
        break;
      case 256: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy712, yymsp[0].minor.yy712, yymsp[-3].minor.yy274); }
        break;
      case 257: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 258: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 259: /* cmd ::= SHOW db_name_cond_opt ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, yymsp[-1].minor.yy712,    QUERY_NODE_SHOW_DB_ALIVE_STMT); }
        break;
      case 260: /* cmd ::= SHOW CLUSTER ALIVE */
{ pCxt->pRootNode = createShowAliveStmt(pCxt, NULL, QUERY_NODE_SHOW_CLUSTER_ALIVE_STMT); }
        break;
      case 261: /* db_name_cond_opt ::= */
      case 266: /* from_db_opt ::= */ yytestcase(yyruleno==266);
{ yymsp[1].minor.yy712 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 262: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy712 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy129); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 264: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 265: /* table_name_cond ::= table_name */
{ yylhsminor.yy712 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy129); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 267: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy712 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy129); }
        break;
      case 271: /* tag_item ::= TBNAME */
{ yylhsminor.yy712 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 274: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy712 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy129), &yymsp[0].minor.yy129); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 275: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy712 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy129), &yymsp[0].minor.yy129); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 276: /* cmd ::= CREATE SMA INDEX not_exists_opt full_index_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy337, yymsp[-3].minor.yy712, yymsp[-1].minor.yy712, NULL, yymsp[0].minor.yy712); }
        break;
      case 277: /* cmd ::= CREATE INDEX not_exists_opt full_index_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy337, yymsp[-5].minor.yy712, yymsp[-3].minor.yy712, yymsp[-1].minor.yy274, NULL); }
        break;
      case 278: /* cmd ::= DROP INDEX exists_opt full_index_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy337, yymsp[0].minor.yy712); }
        break;
      case 279: /* full_index_name ::= index_name */
{ yylhsminor.yy712 = createRealTableNodeForIndexName(pCxt, NULL, &yymsp[0].minor.yy129); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 280: /* full_index_name ::= db_name NK_DOT index_name */
{ yylhsminor.yy712 = createRealTableNodeForIndexName(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy129); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 281: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy712 = createIndexOption(pCxt, yymsp[-7].minor.yy274, releaseRawExprNode(pCxt, yymsp[-3].minor.yy712), NULL, yymsp[-1].minor.yy712, yymsp[0].minor.yy712); }
        break;
      case 282: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy712 = createIndexOption(pCxt, yymsp[-9].minor.yy274, releaseRawExprNode(pCxt, yymsp[-5].minor.yy712), releaseRawExprNode(pCxt, yymsp[-3].minor.yy712), yymsp[-1].minor.yy712, yymsp[0].minor.yy712); }
        break;
      case 285: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy712 = createFunctionNode(pCxt, &yymsp[-3].minor.yy129, yymsp[-1].minor.yy274); }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 291: /* sma_stream_opt ::= */
      case 329: /* stream_options ::= */ yytestcase(yyruleno==329);
{ yymsp[1].minor.yy712 = createStreamOptions(pCxt); }
        break;
      case 292: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy712)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy712); yylhsminor.yy712 = yymsp[-2].minor.yy712; }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 293: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy712)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy712); yylhsminor.yy712 = yymsp[-2].minor.yy712; }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 294: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy712)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy712); yylhsminor.yy712 = yymsp[-2].minor.yy712; }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 295: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy337, &yymsp[-2].minor.yy129, yymsp[0].minor.yy712); }
        break;
      case 296: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy337, &yymsp[-3].minor.yy129, &yymsp[0].minor.yy129, false); }
        break;
      case 297: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy337, &yymsp[-5].minor.yy129, &yymsp[0].minor.yy129, true); }
        break;
      case 298: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy337, &yymsp[-3].minor.yy129, yymsp[0].minor.yy712, false); }
        break;
      case 299: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy337, &yymsp[-5].minor.yy129, yymsp[0].minor.yy712, true); }
        break;
      case 300: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy337, &yymsp[0].minor.yy129); }
        break;
      case 301: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy337, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy129); }
        break;
      case 302: /* cmd ::= DESC full_table_name */
      case 303: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==303);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy712); }
        break;
      case 304: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 305: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
      case 306: /* cmd ::= EXPLAIN analyze_opt explain_options insert_query */ yytestcase(yyruleno==306);
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy337, yymsp[-1].minor.yy712, yymsp[0].minor.yy712); }
        break;
      case 309: /* explain_options ::= */
{ yymsp[1].minor.yy712 = createDefaultExplainOptions(pCxt); }
        break;
      case 310: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy712 = setExplainVerbose(pCxt, yymsp[-2].minor.yy712, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 311: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy712 = setExplainRatio(pCxt, yymsp[-2].minor.yy712, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 312: /* cmd ::= CREATE or_replace_opt agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt language_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-7].minor.yy337, yymsp[-9].minor.yy337, &yymsp[-6].minor.yy129, &yymsp[-4].minor.yy0, yymsp[-2].minor.yy184, yymsp[-1].minor.yy310, &yymsp[0].minor.yy129, yymsp[-10].minor.yy337); }
        break;
      case 313: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy337, &yymsp[0].minor.yy129); }
        break;
      case 318: /* language_opt ::= */
{ yymsp[1].minor.yy129 = nil_token; }
        break;
      case 319: /* language_opt ::= LANGUAGE NK_STRING */
{ yymsp[-1].minor.yy129 = yymsp[0].minor.yy0; }
        break;
      case 322: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tag_def_or_ref_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy337, &yymsp[-8].minor.yy129, yymsp[-5].minor.yy712, yymsp[-7].minor.yy712, yymsp[-3].minor.yy274, yymsp[-2].minor.yy712, yymsp[0].minor.yy712, yymsp[-4].minor.yy274); }
        break;
      case 323: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy337, &yymsp[0].minor.yy129); }
        break;
      case 330: /* stream_options ::= stream_options TRIGGER AT_ONCE */
      case 331: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */ yytestcase(yyruleno==331);
{ yylhsminor.yy712 = setStreamOptions(pCxt, yymsp[-2].minor.yy712, SOPT_TRIGGER_TYPE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 332: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ yylhsminor.yy712 = setStreamOptions(pCxt, yymsp[-3].minor.yy712, SOPT_TRIGGER_TYPE_SET, &yymsp[-1].minor.yy0, releaseRawExprNode(pCxt, yymsp[0].minor.yy712)); }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 333: /* stream_options ::= stream_options WATERMARK duration_literal */
{ yylhsminor.yy712 = setStreamOptions(pCxt, yymsp[-2].minor.yy712, SOPT_WATERMARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy712)); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 334: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ yylhsminor.yy712 = setStreamOptions(pCxt, yymsp[-3].minor.yy712, SOPT_IGNORE_EXPIRED_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 335: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ yylhsminor.yy712 = setStreamOptions(pCxt, yymsp[-2].minor.yy712, SOPT_FILL_HISTORY_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 336: /* stream_options ::= stream_options DELETE_MARK duration_literal */
{ yylhsminor.yy712 = setStreamOptions(pCxt, yymsp[-2].minor.yy712, SOPT_DELETE_MARK_SET, NULL, releaseRawExprNode(pCxt, yymsp[0].minor.yy712)); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 337: /* stream_options ::= stream_options IGNORE UPDATE NK_INTEGER */
{ yylhsminor.yy712 = setStreamOptions(pCxt, yymsp[-3].minor.yy712, SOPT_IGNORE_UPDATE_SET, &yymsp[0].minor.yy0, NULL); }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 339: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 529: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==529);
      case 549: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==549);
{ yymsp[-3].minor.yy712 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy712); }
        break;
      case 340: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 341: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 342: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 343: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 344: /* cmd ::= BALANCE VGROUP LEADER */
{ pCxt->pRootNode = createBalanceVgroupLeaderStmt(pCxt); }
        break;
      case 345: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 346: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy274); }
        break;
      case 347: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 348: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy274 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 350: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy712, yymsp[0].minor.yy712); }
        break;
      case 353: /* insert_query ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ yymsp[-6].minor.yy712 = createInsertStmt(pCxt, yymsp[-4].minor.yy712, yymsp[-2].minor.yy274, yymsp[0].minor.yy712); }
        break;
      case 354: /* insert_query ::= INSERT INTO full_table_name query_or_subquery */
{ yymsp[-3].minor.yy712 = createInsertStmt(pCxt, yymsp[-1].minor.yy712, NULL, yymsp[0].minor.yy712); }
        break;
      case 355: /* literal ::= NK_INTEGER */
{ yylhsminor.yy712 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 356: /* literal ::= NK_FLOAT */
{ yylhsminor.yy712 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 357: /* literal ::= NK_STRING */
{ yylhsminor.yy712 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 358: /* literal ::= NK_BOOL */
{ yylhsminor.yy712 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 359: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 360: /* literal ::= duration_literal */
      case 370: /* signed_literal ::= signed */ yytestcase(yyruleno==370);
      case 391: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==391);
      case 392: /* expression ::= literal */ yytestcase(yyruleno==392);
      case 393: /* expression ::= pseudo_column */ yytestcase(yyruleno==393);
      case 394: /* expression ::= column_reference */ yytestcase(yyruleno==394);
      case 395: /* expression ::= function_expression */ yytestcase(yyruleno==395);
      case 396: /* expression ::= case_when_expression */ yytestcase(yyruleno==396);
      case 427: /* function_expression ::= literal_func */ yytestcase(yyruleno==427);
      case 476: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==476);
      case 480: /* boolean_primary ::= predicate */ yytestcase(yyruleno==480);
      case 482: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==482);
      case 483: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==483);
      case 486: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==486);
      case 488: /* table_reference ::= table_primary */ yytestcase(yyruleno==488);
      case 489: /* table_reference ::= joined_table */ yytestcase(yyruleno==489);
      case 493: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==493);
      case 551: /* query_simple ::= query_specification */ yytestcase(yyruleno==551);
      case 552: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==552);
      case 555: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==555);
      case 557: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==557);
{ yylhsminor.yy712 = yymsp[0].minor.yy712; }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 361: /* literal ::= NULL */
{ yylhsminor.yy712 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 362: /* literal ::= NK_QUESTION */
{ yylhsminor.yy712 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 363: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy712 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 364: /* signed ::= NK_INTEGER */
{ yylhsminor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 365: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 366: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 367: /* signed ::= NK_FLOAT */
{ yylhsminor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 368: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 369: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 371: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 372: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 373: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 374: /* signed_literal ::= duration_literal */
      case 376: /* signed_literal ::= literal_func */ yytestcase(yyruleno==376);
      case 447: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==447);
      case 509: /* select_item ::= common_expression */ yytestcase(yyruleno==509);
      case 519: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==519);
      case 556: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==556);
      case 558: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==558);
      case 571: /* search_condition ::= common_expression */ yytestcase(yyruleno==571);
{ yylhsminor.yy712 = releaseRawExprNode(pCxt, yymsp[0].minor.yy712); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 375: /* signed_literal ::= NULL */
{ yylhsminor.yy712 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 377: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy712 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 397: /* expression ::= NK_LP expression NK_RP */
      case 481: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==481);
      case 570: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==570);
{ yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy712)); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 398: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy712));
                                                                                  }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 399: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy712), NULL));
                                                                                  }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 400: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712))); 
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 401: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712))); 
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 402: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712))); 
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 403: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712))); 
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 404: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712)));
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 405: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 406: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712)));
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 407: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712)));
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 410: /* column_reference ::= column_name */
{ yylhsminor.yy712 = createRawExprNode(pCxt, &yymsp[0].minor.yy129, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy129)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 411: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy129, createColumnNode(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy129)); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 412: /* pseudo_column ::= ROWTS */
      case 413: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==413);
      case 415: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==415);
      case 416: /* pseudo_column ::= QEND */ yytestcase(yyruleno==416);
      case 417: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==417);
      case 418: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==418);
      case 419: /* pseudo_column ::= WEND */ yytestcase(yyruleno==419);
      case 420: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==420);
      case 421: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==421);
      case 422: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==422);
      case 423: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==423);
      case 429: /* literal_func ::= NOW */ yytestcase(yyruleno==429);
{ yylhsminor.yy712 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 414: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy129)))); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 424: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 425: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==425);
{ yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy129, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy129, yymsp[-1].minor.yy274)); }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 426: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy712), yymsp[-1].minor.yy184)); }
  yymsp[-5].minor.yy712 = yylhsminor.yy712;
        break;
      case 428: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy129, NULL)); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 443: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy274 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy274 = yylhsminor.yy274;
        break;
      case 448: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 512: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==512);
{ yylhsminor.yy712 = createColumnNode(pCxt, &yymsp[-2].minor.yy129, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 449: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy274, yymsp[-1].minor.yy712)); }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 450: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy712), yymsp[-2].minor.yy274, yymsp[-1].minor.yy712)); }
  yymsp[-4].minor.yy712 = yylhsminor.yy712;
        break;
      case 453: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy712 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712)); }
        break;
      case 455: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy712 = releaseRawExprNode(pCxt, yymsp[0].minor.yy712); }
        break;
      case 456: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 461: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==461);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy440, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712)));
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 457: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy712), releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712)));
                                                                                  }
  yymsp[-4].minor.yy712 = yylhsminor.yy712;
        break;
      case 458: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy712), releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712)));
                                                                                  }
  yymsp[-5].minor.yy712 = yylhsminor.yy712;
        break;
      case 459: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), NULL));
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 460: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy712), NULL));
                                                                                  }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 462: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy440 = OP_TYPE_LOWER_THAN; }
        break;
      case 463: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy440 = OP_TYPE_GREATER_THAN; }
        break;
      case 464: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy440 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 465: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy440 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 466: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy440 = OP_TYPE_NOT_EQUAL; }
        break;
      case 467: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy440 = OP_TYPE_EQUAL; }
        break;
      case 468: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy440 = OP_TYPE_LIKE; }
        break;
      case 469: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy440 = OP_TYPE_NOT_LIKE; }
        break;
      case 470: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy440 = OP_TYPE_MATCH; }
        break;
      case 471: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy440 = OP_TYPE_NMATCH; }
        break;
      case 472: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy440 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 473: /* in_op ::= IN */
{ yymsp[0].minor.yy440 = OP_TYPE_IN; }
        break;
      case 474: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy440 = OP_TYPE_NOT_IN; }
        break;
      case 475: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy274)); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 477: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy712), NULL));
                                                                                  }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 478: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712)));
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 479: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy712);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy712);
                                                                                    yylhsminor.yy712 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), releaseRawExprNode(pCxt, yymsp[0].minor.yy712)));
                                                                                  }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 485: /* from_clause_opt ::= FROM table_reference_list */
      case 514: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==514);
      case 545: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==545);
{ yymsp[-1].minor.yy712 = yymsp[0].minor.yy712; }
        break;
      case 487: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy712 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy712, yymsp[0].minor.yy712, NULL); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 490: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy712 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy129, &yymsp[0].minor.yy129); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 491: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy712 = createRealTableNode(pCxt, &yymsp[-3].minor.yy129, &yymsp[-1].minor.yy129, &yymsp[0].minor.yy129); }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 492: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy712 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy712), &yymsp[0].minor.yy129); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 494: /* alias_opt ::= */
{ yymsp[1].minor.yy129 = nil_token;  }
        break;
      case 496: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy129 = yymsp[0].minor.yy129; }
        break;
      case 497: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 498: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==498);
{ yymsp[-2].minor.yy712 = yymsp[-1].minor.yy712; }
        break;
      case 499: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy712 = createJoinTableNode(pCxt, yymsp[-4].minor.yy912, yymsp[-5].minor.yy712, yymsp[-2].minor.yy712, yymsp[0].minor.yy712); }
  yymsp[-5].minor.yy712 = yylhsminor.yy712;
        break;
      case 500: /* join_type ::= */
{ yymsp[1].minor.yy912 = JOIN_TYPE_INNER; }
        break;
      case 501: /* join_type ::= INNER */
{ yymsp[0].minor.yy912 = JOIN_TYPE_INNER; }
        break;
      case 502: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy712 = createSelectStmt(pCxt, yymsp[-10].minor.yy337, yymsp[-9].minor.yy274, yymsp[-8].minor.yy712);
                                                                                    yymsp[-11].minor.yy712 = addWhereClause(pCxt, yymsp[-11].minor.yy712, yymsp[-7].minor.yy712);
                                                                                    yymsp[-11].minor.yy712 = addPartitionByClause(pCxt, yymsp[-11].minor.yy712, yymsp[-6].minor.yy274);
                                                                                    yymsp[-11].minor.yy712 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy712, yymsp[-2].minor.yy712);
                                                                                    yymsp[-11].minor.yy712 = addGroupByClause(pCxt, yymsp[-11].minor.yy712, yymsp[-1].minor.yy274);
                                                                                    yymsp[-11].minor.yy712 = addHavingClause(pCxt, yymsp[-11].minor.yy712, yymsp[0].minor.yy712);
                                                                                    yymsp[-11].minor.yy712 = addRangeClause(pCxt, yymsp[-11].minor.yy712, yymsp[-5].minor.yy712);
                                                                                    yymsp[-11].minor.yy712 = addEveryClause(pCxt, yymsp[-11].minor.yy712, yymsp[-4].minor.yy712);
                                                                                    yymsp[-11].minor.yy712 = addFillClause(pCxt, yymsp[-11].minor.yy712, yymsp[-3].minor.yy712);
                                                                                  }
        break;
      case 505: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy337 = false; }
        break;
      case 508: /* select_item ::= NK_STAR */
{ yylhsminor.yy712 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy712 = yylhsminor.yy712;
        break;
      case 510: /* select_item ::= common_expression column_alias */
      case 520: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==520);
{ yylhsminor.yy712 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy712), &yymsp[0].minor.yy129); }
  yymsp[-1].minor.yy712 = yylhsminor.yy712;
        break;
      case 511: /* select_item ::= common_expression AS column_alias */
      case 521: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==521);
{ yylhsminor.yy712 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), &yymsp[0].minor.yy129); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 516: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 541: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==541);
      case 560: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==560);
{ yymsp[-2].minor.yy274 = yymsp[0].minor.yy274; }
        break;
      case 523: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy712 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy712), releaseRawExprNode(pCxt, yymsp[-1].minor.yy712)); }
        break;
      case 524: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy712 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy712)); }
        break;
      case 525: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy712 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy712), NULL, yymsp[-1].minor.yy712, yymsp[0].minor.yy712); }
        break;
      case 526: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy712 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy712), releaseRawExprNode(pCxt, yymsp[-3].minor.yy712), yymsp[-1].minor.yy712, yymsp[0].minor.yy712); }
        break;
      case 527: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy712 = createEventWindowNode(pCxt, yymsp[-3].minor.yy712, yymsp[0].minor.yy712); }
        break;
      case 531: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy712 = createFillNode(pCxt, yymsp[-1].minor.yy94, NULL); }
        break;
      case 532: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy712 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy274)); }
        break;
      case 533: /* fill_opt ::= FILL NK_LP VALUE_F NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy712 = createFillNode(pCxt, FILL_MODE_VALUE_F, createNodeListNode(pCxt, yymsp[-1].minor.yy274)); }
        break;
      case 534: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy94 = FILL_MODE_NONE; }
        break;
      case 535: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy94 = FILL_MODE_PREV; }
        break;
      case 536: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy94 = FILL_MODE_NULL; }
        break;
      case 537: /* fill_mode ::= NULL_F */
{ yymsp[0].minor.yy94 = FILL_MODE_NULL_F; }
        break;
      case 538: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy94 = FILL_MODE_LINEAR; }
        break;
      case 539: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy94 = FILL_MODE_NEXT; }
        break;
      case 542: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy274 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy712))); }
  yymsp[0].minor.yy274 = yylhsminor.yy274;
        break;
      case 543: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy274 = addNodeToList(pCxt, yymsp[-2].minor.yy274, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy712))); }
  yymsp[-2].minor.yy274 = yylhsminor.yy274;
        break;
      case 547: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy712 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy712), releaseRawExprNode(pCxt, yymsp[-1].minor.yy712)); }
        break;
      case 550: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy712 = addOrderByClause(pCxt, yymsp[-3].minor.yy712, yymsp[-2].minor.yy274);
                                                                                    yylhsminor.yy712 = addSlimitClause(pCxt, yylhsminor.yy712, yymsp[-1].minor.yy712);
                                                                                    yylhsminor.yy712 = addLimitClause(pCxt, yylhsminor.yy712, yymsp[0].minor.yy712);
                                                                                  }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 553: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy712 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy712, yymsp[0].minor.yy712); }
  yymsp[-3].minor.yy712 = yylhsminor.yy712;
        break;
      case 554: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy712 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy712, yymsp[0].minor.yy712); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 562: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 566: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==566);
{ yymsp[-1].minor.yy712 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 563: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 567: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==567);
{ yymsp[-3].minor.yy712 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 564: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 568: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==568);
{ yymsp[-3].minor.yy712 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 569: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy712 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy712); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 574: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy712 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy712), yymsp[-1].minor.yy88, yymsp[0].minor.yy907); }
  yymsp[-2].minor.yy712 = yylhsminor.yy712;
        break;
      case 575: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy88 = ORDER_ASC; }
        break;
      case 576: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy88 = ORDER_ASC; }
        break;
      case 577: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy88 = ORDER_DESC; }
        break;
      case 578: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy907 = NULL_ORDER_DEFAULT; }
        break;
      case 579: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy907 = NULL_ORDER_FIRST; }
        break;
      case 580: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy907 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
