/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 462
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  int8_t yy47;
  EOperatorType yy128;
  EJoinType yy288;
  SNodeList* yy376;
  SNode* yy476;
  int32_t yy508;
  SDataType yy532;
  EOrder yy554;
  EFillMode yy690;
  ENullOrder yy697;
  SToken yy701;
  bool yy845;
  SAlterOption yy893;
  int64_t yy921;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             725
#define YYNRULE              548
#define YYNTOKEN             325
#define YY_MAX_SHIFT         724
#define YY_MIN_SHIFTREDUCE   1073
#define YY_MAX_SHIFTREDUCE   1620
#define YY_ERROR_ACTION      1621
#define YY_ACCEPT_ACTION     1622
#define YY_NO_ACTION         1623
#define YY_MIN_REDUCE        1624
#define YY_MAX_REDUCE        2171
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2947)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */    35,  282, 1755, 1892,  579, 1892,  233, 2147, 2142, 1807,
 /*    10 */  1972, 2142,   45,   43, 1550,  361, 1890,  601, 1889,  601,
 /*    20 */   370, 1968, 1400,  578,  179,  613, 1768, 2146, 2143,  580,
 /*    30 */  1985, 2143, 2145, 1480, 1554, 1398,  468, 1968,  469, 1660,
 /*    40 */  1425,  613,   38,   37, 1972, 2088,   44,   42,   41,   40,
 /*    50 */    39, 1964, 1970,  352,  474, 1968,  409,  591, 1475, 1425,
 /*    60 */   470, 2003,  624,   18,  486, 1830, 1830, 1964, 1970,  594,
 /*    70 */  1406, 2085,  350,  337, 1954,   84,  630,  477,  624,  469,
 /*    80 */  1660, 1828, 1828,   45,   43, 1964, 1970,  365,  138,  134,
 /*    90 */  2147,  370,  163, 1400, 1636,   14,  624,  333, 1772,  555,
 /*   100 */    48, 1984, 2088, 2142, 1480, 2020, 1398, 1427,  107, 1986,
 /*   110 */   634, 1988, 1989,  629,   84,  624,  527,  721, 2148,  179,
 /*   120 */   176,  614, 2073, 2143,  580,  173,  364, 2069, 2084, 1475,
 /*   130 */   613,  537, 1482, 1483,   18,  130, 2003, 1773, 1509,  579,
 /*   140 */   181, 1406,  507, 2142,  573,  230,  340, 1877, 2099,  262,
 /*   150 */  2081,  590, 1777,  131,  589,  614, 1427, 2142,  578,  179,
 /*   160 */   530, 1455, 1465, 2143,  580,  524,   14, 1481, 1484,  130,
 /*   170 */   229,  375,  578,  179, 1823, 1825,  512, 2143,  580, 1873,
 /*   180 */   173, 1456, 1401, 1610, 1399,  572, 1777,  486,  721, 1106,
 /*   190 */   187,   38,   37,  232, 1510,   44,   42,   41,   40,   39,
 /*   200 */  1328, 1329, 1878, 1482, 1483,   48,   67, 1404, 1405,   66,
 /*   210 */  1454, 1457, 1458, 1459, 1460, 1461, 1462, 1463, 1464,  626,
 /*   220 */   622, 1473, 1474, 1476, 1477, 1478, 1479,    2, 1108,   64,
 /*   230 */  1111, 1112, 1455, 1465,   41,   40,   39,  120, 1481, 1484,
 /*   240 */   119,  118,  117,  116,  115,  114,  113,  112,  111,  164,
 /*   250 */   264,  345,  175, 1401, 1731, 1399,   38,   37, 1377, 1378,
 /*   260 */    44,   42,   41,   40,   39, 1817,   34,  368, 1504, 1505,
 /*   270 */  1506, 1507, 1508, 1512, 1513, 1514, 1515,  191, 1404, 1405,
 /*   280 */  1425, 1454, 1457, 1458, 1459, 1460, 1461, 1462, 1463, 1464,
 /*   290 */   626,  622, 1473, 1474, 1476, 1477, 1478, 1479,    2,  264,
 /*   300 */    11,   45,   43, 1693,   44,   42,   41,   40,   39,  370,
 /*   310 */  1754, 1400,  346,   81,  344,  343,   80,  509,  574, 1985,
 /*   320 */    60,  511, 1480, 1647, 1398, 1232,  656,  655,  654, 1236,
 /*   330 */   653, 1238, 1239,  652, 1241,  649, 1192, 1247,  646, 1249,
 /*   340 */  1250,  643,  640,  510, 1587,  467,  265, 1475,  472, 1666,
 /*   350 */  2003,  536,   18, 1824, 1825,  182, 1426, 1617,  631, 1406,
 /*   360 */  1125,    8, 1124, 1954,  534,  630,  532, 1954,  522,  521,
 /*   370 */   520, 1194,   45,   43, 1485,  216,  135,  516, 1424, 1425,
 /*   380 */   370,  515, 1400,   60,   14,   90,  514,  519, 2088, 1830,
 /*   390 */  1984, 1126,  513, 1480, 2020, 1398,  358,  107, 1986,  634,
 /*   400 */  1988, 1989,  629, 1985,  624, 1828,  721,  141, 2147,  147,
 /*   410 */  2044, 2073, 2142,   31, 2083,  364, 2069,  666, 1475,   38,
 /*   420 */    37, 1482, 1483,   44,   42,   41,   40,   39, 2146, 1753,
 /*   430 */  1406, 1941, 2143, 2144, 2003, 1624,  152,  151,  663,  662,
 /*   440 */   661,  149,  628,  273,  274,  518,  517, 1954,  272,  630,
 /*   450 */  1455, 1465, 1616,  569,   60,   46, 1481, 1484,  415,  129,
 /*   460 */   128,  127,  126,  125,  124,  123,  122,  121, 1275, 1276,
 /*   470 */   182, 1401,  476, 1399, 1984,  472, 1666,  721, 2020,  392,
 /*   480 */  1646,  318, 1986,  634, 1988, 1989,  629,  627,  624,  615,
 /*   490 */  2038,  668, 1482, 1483,  692,  690, 1404, 1405,  326, 1454,
 /*   500 */  1457, 1458, 1459, 1460, 1461, 1462, 1463, 1464,  626,  622,
 /*   510 */  1473, 1474, 1476, 1477, 1478, 1479,    2,  522,  521,  520,
 /*   520 */   614, 1455, 1465,  362, 1954,  135,  516, 1481, 1484, 1625,
 /*   530 */   515,  161, 1830,  182,   54,  514,  519,  575,  570,  564,
 /*   540 */  1779,  513, 1401,  404, 1399,   60, 1622,   98, 1829,  140,
 /*   550 */   120, 1777, 2044,  119,  118,  117,  116,  115,  114,  113,
 /*   560 */   112,  111, 1985,   60,  406,  402, 1543, 1404, 1405, 1770,
 /*   570 */  1454, 1457, 1458, 1459, 1460, 1461, 1462, 1463, 1464,  626,
 /*   580 */   622, 1473, 1474, 1476, 1477, 1478, 1479,    2,   45,   43,
 /*   590 */  1400, 1645,  616, 2003, 2045, 1125,  370, 1124, 1400,  660,
 /*   600 */   614,  631, 1821, 1398,  182,   49, 1954,  668,  630, 1480,
 /*   610 */   385, 1398,  659,  231,  184,   13,   12,   38,   37, 1985,
 /*   620 */  1830,   44,   42,   41,   40,   39, 1126,  363,   11, 1428,
 /*   630 */   591, 1777, 1830, 1984, 1475, 1954, 1828, 2020, 1406,  374,
 /*   640 */   312, 1986,  634, 1988, 1989,  629, 1406,  624, 1828,  408,
 /*   650 */  2003,  407,  614,  555, 1860, 2146,  614, 2142,  631,   45,
 /*   660 */    43,  138,   11, 1954,    9,  630,  413,  370, 1428, 1400,
 /*   670 */   414,   46, 2148,  179,  104,   87,  328, 2143,  580,  540,
 /*   680 */  1480,  538, 1398, 1777,  576,  721,  597, 1777,  139,  614,
 /*   690 */  1984, 1644, 1643,  721, 2020,  182, 1769,  108, 1986,  634,
 /*   700 */  1988, 1989,  629,  423,  624, 1475, 1752,  621, 1482, 1483,
 /*   710 */  1523, 2073, 1425,  182,  614, 2072, 2069, 1406,  416,  451,
 /*   720 */  1777,  593,  177, 2081, 2082, 1406,  136, 2086,  437,  555,
 /*   730 */  1642,  417,  614, 2142, 1511, 1954, 1954, 1455, 1465,  373,
 /*   740 */  1873, 1641,   14, 1481, 1484, 1777,  438,  161, 2148,  179,
 /*   750 */  1401,  189, 1399, 2143,  580,  182, 1779,  681, 1401, 1747,
 /*   760 */  1399,   38,   37, 1777,  721,   44,   42,   41,   40,   39,
 /*   770 */  1426, 1873,  242, 1640, 1954, 1404, 1405,  195,  194, 1482,
 /*   780 */  1483, 1547,  193, 1404, 1405, 1954, 1454, 1457, 1458, 1459,
 /*   790 */  1460, 1461, 1462, 1463, 1464,  626,  622, 1473, 1474, 1476,
 /*   800 */  1477, 1478, 1479,    2, 1639,  432,   32,  614, 1455, 1465,
 /*   810 */   325,  188, 1423,  666, 1481, 1484, 1516, 1954,  618,  445,
 /*   820 */  2045,  484,  458, 1766,  664,  457, 1577, 1821,   50, 1401,
 /*   830 */     3, 1399,  152,  151,  663,  662,  661,  149, 1777,  376,
 /*   840 */   429, 1428,  459,  161, 1490,  431,  680,  161, 1954, 1566,
 /*   850 */  1425, 1501, 1780, 1456, 1404, 1405, 1779, 1454, 1457, 1458,
 /*   860 */  1459, 1460, 1461, 1462, 1463, 1464,  626,  622, 1473, 1474,
 /*   870 */  1476, 1477, 1478, 1479,    2,  566, 1575, 1576, 1578, 1579,
 /*   880 */   162,  665, 1343, 1344, 1821,  302,  341, 1690,  614,   38,
 /*   890 */    37, 1111, 1112,   44,   42,   41,   40,   39,  419,  300,
 /*   900 */    70,   33,  485,   69,  586,  511,  296,   38,   37, 1807,
 /*   910 */   103,   44,   42,   41,   40,   39,  582, 1342, 1345, 1777,
 /*   920 */   100,  199,  464,  462,  144,   27,  132,  510,  455, 2093,
 /*   930 */  1543,  450,  449,  448,  447,  444,  443,  442,  441,  440,
 /*   940 */   436,  435,  434,  433,  342,  426,  425,  424, 1638,  421,
 /*   950 */   420,  339,  698,  697,  696,  695,  380,   60,  694,  693,
 /*   960 */   142,  688,  687,  686,  685,  684,  683,  682,  154,  678,
 /*   970 */   677,  676,  379,  378,  673,  672,  671,  670,  669,  614,
 /*   980 */   724,   38,   37,  150,  241,   44,   42,   41,   40,   39,
 /*   990 */  1635, 1456, 1954, 1774,  289,  150,  106,   38,   37, 1680,
 /*  1000 */  1985,   44,   42,   41,   40,   39,   71, 1732,  222,  172,
 /*  1010 */  1777,  220,  614, 1634,  614,  714,  710,  706,  702,  287,
 /*  1020 */  1762,  523,  583, 1546,  224, 1633,  234,  223,  551,  666,
 /*  1030 */   226, 2003, 1632,  225, 1954,   53,   78,   77,  412,  594,
 /*  1040 */  1764,  186, 1631, 1777, 1954, 1777,  630, 1375,  152,  151,
 /*  1050 */   663,  662,  661,  149, 1409,  105,   79, 1954,  280,  324,
 /*  1060 */   550, 1973,  400,  614,  398,  394,  390,  387,  384, 1954,
 /*  1070 */   614, 1984, 1968, 1985,  614, 2020, 1954,  595,  107, 1986,
 /*  1080 */   634, 1988, 1989,  629,  599,  624, 1954, 1637,  600, 1630,
 /*  1090 */   176,  610, 2073, 1985, 1777,  614,  364, 2069, 1673,  383,
 /*  1100 */   614, 1777, 1964, 1970, 2003, 1777, 1629,  182,  228,  277,
 /*  1110 */  2113,  227,  631,  624,  609, 1628, 1760, 1954, 2100,  630,
 /*  1120 */   525, 1671, 1619, 1620, 2003,  268, 1777,   52,  587,   62,
 /*  1130 */   267, 1777,  631, 1954,  554,  246,  160, 1954, 1627,  630,
 /*  1140 */   150,  237,  555,  528, 1984,   47, 2142, 1369, 2020,  236,
 /*  1150 */  1954,  107, 1986,  634, 1988, 1989,  629,  240,  624, 1954,
 /*  1160 */  1985, 2148,  179, 2162, 1984, 2073, 2143,  580, 2020,  364,
 /*  1170 */  2069,  107, 1986,  634, 1988, 1989,  629,  625,  624,  614,
 /*  1180 */  2107, 1574, 1954, 2162,  614, 2073,  382,  248, 1408,  364,
 /*  1190 */  2069, 2003,  598,  611,  614,  614,   88, 1340,  377,  631,
 /*  1200 */  2120,   13,   12, 1412, 1954,  658,  630,  259,  612,  283,
 /*  1210 */  1777,  567,  270,  367,  366, 1777, 1985,  215,   68, 1882,
 /*  1220 */   148,  381,  543, 1414,  150, 1777, 1777,   62,   47,  555,
 /*  1230 */    47, 1984,  591, 2142, 1480, 2020, 1407, 1667,  107, 1986,
 /*  1240 */   634, 1988, 1989,  629,  584,  624, 1154, 2003, 2148,  179,
 /*  1250 */  2162,  638, 2073, 2143,  580,  631,  364, 2069,  148, 1475,
 /*  1260 */  1954, 1985,  630,  138,  275,  555, 1975,  562,  150, 2142,
 /*  1270 */   606, 1406,  279,  591,  253,  133, 1225, 2004,  148, 1517,
 /*  1280 */  1466, 1155,  295, 1661, 2148,  179,  716, 1984, 1818, 2143,
 /*  1290 */   580, 2020, 2003,  674,  107, 1986,  634, 1988, 1989,  629,
 /*  1300 */   631,  624, 2103, 1253,  138, 1954, 2162,  630, 2073,  675,
 /*  1310 */  1257,  592,  364, 2069, 1977, 1173,  261,  258,  620,    4,
 /*  1320 */  1264,    1,  386, 2136,  178, 2081, 2082, 1262,  136, 2086,
 /*  1330 */   153, 1171, 1984,  391,  338, 1362, 2020, 1411,  290,  107,
 /*  1340 */  1986,  634, 1988, 1989,  629,  192,  624,  418, 1428, 1883,
 /*  1350 */   422, 2162,  453, 2073,  427, 1423,  439,  364, 2069, 1875,
 /*  1360 */  1985,  446,  452,  454,  460,  180, 2081, 2082, 2092,  136,
 /*  1370 */  2086,  461,  196,  463,  465, 1429,  466,  475, 1431,  478,
 /*  1380 */  1426,  202,  479, 1415,  204, 1410, 1430,  480, 1432,  483,
 /*  1390 */   481, 2003,  487,  207, 1128,  209,   82,   83,  504,  631,
 /*  1400 */   213,  505,  508,  506, 1954, 1931,  630, 1767, 1418, 1420,
 /*  1410 */   110,  327, 1930,  542,  544,   86,  219,  291,  146, 1763,
 /*  1420 */   221,  622, 1473, 1474, 1476, 1477, 1478, 1479,  155,  156,
 /*  1430 */  1765, 1984,  235, 1985, 1761, 2020,  157,  158,  107, 1986,
 /*  1440 */   634, 1988, 1989,  629,  545,  624,  238,  552, 2104, 2114,
 /*  1450 */  2048,  559, 2073, 1985,  549, 2119,  364, 2069,  546,  568,
 /*  1460 */   604,  244,  565,    7, 2003,  353, 2118,  247,  577,  571,
 /*  1470 */  2095,  560,  631,  252,  558,  255,  169, 1954,  557,  630,
 /*  1480 */   354,  585,  254,  256, 2003,  257, 2141, 2165,  588, 1543,
 /*  1490 */   137, 1427,  631, 2089,  596,  292,  357, 1954,  602,  630,
 /*  1500 */   266,   93,  603,  260, 1984, 1900, 1899, 1898, 2020, 1985,
 /*  1510 */   360,  107, 1986,  634, 1988, 1989,  629,  293,  624,  607,
 /*  1520 */   608,  294,   95, 2046, 1984, 2073,   59,   97, 2020,  364,
 /*  1530 */  2069,  107, 1986,  634, 1988, 1989,  629, 1778,  624, 2054,
 /*  1540 */  2003,   99,  636,  617, 1822, 2073, 1748,  717,  631,  364,
 /*  1550 */  2069,  297,  720, 1954,  718,  630,   51,  329,  286,  321,
 /*  1560 */  1948,  330,  306, 1947, 1985,  301,  320,  299,   75, 1946,
 /*  1570 */  1945, 1942,   76,  310,  388,  389, 1392, 1393,  185,  393,
 /*  1580 */  1984, 1940,  395,  396, 2020,  397, 1939,  108, 1986,  634,
 /*  1590 */  1988, 1989,  629,  399,  624, 2003,  401, 1937,  403, 1936,
 /*  1600 */   405, 2073, 1938,  631, 1365,  619, 2069, 1364, 1954, 1911,
 /*  1610 */   630, 1910,  410,  411, 1909, 1908, 1868, 1867, 1865, 1319,
 /*  1620 */  1985,  143, 1864, 1863, 1866, 1862, 1861, 1859, 1858, 1857,
 /*  1630 */   190, 1856,  430,  428, 1855,  632, 1985, 1854, 1853, 2020,
 /*  1640 */  1852, 1851,  108, 1986,  634, 1988, 1989,  629, 1850,  624,
 /*  1650 */  1849, 2003,  145, 1840, 1839, 1838, 2073, 1848, 1847,  631,
 /*  1660 */   332, 2069, 1846, 1845, 1954, 1844,  630, 2003, 1321, 1835,
 /*  1670 */  1834, 1833,  456, 1832, 1831,  631, 1843, 1842, 1841, 1837,
 /*  1680 */  1954, 1836,  630, 1695, 1200, 1694, 1692, 1656,  197,  200,
 /*  1690 */   198, 1984, 1974, 1655, 1114, 2020, 1113, 1985,  165, 1986,
 /*  1700 */   634, 1988, 1989,  629,  174,  624,   73, 1984,  471, 1924,
 /*  1710 */  1918, 2020,  201,  473,  166, 1986,  634, 1988, 1989,  629,
 /*  1720 */  1907,  624,  208,   74, 1906, 1886, 1756,  206, 2003,  488,
 /*  1730 */   490, 1687,  492, 1685,  494,  496,  631, 1691, 1689,  556,
 /*  1740 */  2110, 1954,  498,  630,  489, 1683,  493,  497,  500,  501,
 /*  1750 */   502, 1670, 1985, 1147, 1669, 1652, 1758, 1269, 1268, 1757,
 /*  1760 */    61,  218, 1191, 1190, 1183, 1189,  581, 2163, 1984, 1985,
 /*  1770 */  1188, 1681, 2020, 1674, 1185,  108, 1986,  634, 1988, 1989,
 /*  1780 */   629, 1184,  624, 2003,  689,  691,  347, 1182,  348, 2073,
 /*  1790 */  1672,  631,  349,  526, 2070,  529, 1954, 1651,  630, 1650,
 /*  1800 */  2003,  535,  531,  533, 1649,  109,  539, 1382,  631, 1381,
 /*  1810 */  1384,   26, 1923, 1954,   55,  630, 1371, 1917,  159, 1905,
 /*  1820 */   547, 1903,   19, 1984,   16, 2147,  563, 2020, 1589,  239,
 /*  1830 */   165, 1986,  634, 1988, 1989,  629,  561,  624, 1985,   28,
 /*  1840 */  1984,  251,  243,  167, 2020,  245,  553,  166, 1986,  634,
 /*  1850 */  1988, 1989,  629,  548,  624,  351,  249, 1985,   58, 1573,
 /*  1860 */    29, 1604,  250, 1975,   30, 1565,   63,   21,   20, 2003,
 /*  1870 */    89, 1603, 2111, 1609,  359,    5,    6,  631, 1610,  355,
 /*  1880 */  1608, 1607, 1954,  356,  630,   17,  263, 1540, 2003, 1539,
 /*  1890 */   170,   57, 1904, 1902, 1901, 1885,  628,   91,   92,  269,
 /*  1900 */  2164, 1954,   22,  630, 1571,  271,  276, 1884,   65, 1984,
 /*  1910 */    94,  100,  281, 2020,  278,   12,  319, 1986,  634, 1988,
 /*  1920 */  1989,  629,   96,  624, 1985,   23, 1416, 2023, 1984, 1470,
 /*  1930 */  1502, 1468, 2020,  623,   10,  318, 1986,  634, 1988, 1989,
 /*  1940 */   629, 1447,  624, 1492, 2039,   56,  605, 1491,   36,  171,
 /*  1950 */  1467,  217,   15,  183, 1231, 2003,   24,  635, 1439,   25,
 /*  1960 */   369,  637,  633,  631, 1254,  372,  168,  639, 1954, 1251,
 /*  1970 */   630,  641,  503,  499,  495,  491,  214,  642,  644, 1248,
 /*  1980 */  1985,  645,  647, 1242,  648,  650, 1240,  657, 1246, 1245,
 /*  1990 */   284,  651,  101, 1244,  102, 1984, 1985, 1243, 1263, 2020,
 /*  2000 */    72, 1259,  319, 1986,  634, 1988, 1989,  629, 1145,  624,
 /*  2010 */  1179, 2003,   85, 1178,  667,  212,  371, 1177, 1176,  631,
 /*  2020 */  1175, 1174, 1172, 1170, 1954, 1169,  630, 2003, 1168, 1198,
 /*  2030 */   679, 1166, 1163,  285, 1165,  631, 1164, 1162, 1161, 1160,
 /*  2040 */  1954, 1195,  630, 1193, 1157, 1151, 1156, 1153, 1152, 1150,
 /*  2050 */  1688, 1984,  699,  700,  701, 2020, 1686, 1985,  319, 1986,
 /*  2060 */   634, 1988, 1989,  629,  703,  624,  704,  541, 1684,  705,
 /*  2070 */   707, 2020,  708,  709,  314, 1986,  634, 1988, 1989,  629,
 /*  2080 */  1682,  624,  211,  205,  711,  712,  713,  210, 2003, 1668,
 /*  2090 */   482, 1648,  715,  288, 1103,  719,  631, 1402,  298,  722,
 /*  2100 */  1623, 1954,  723,  630, 1623, 1623,  203, 1623, 1623, 1623,
 /*  2110 */  1623, 1623, 1985, 1623, 1623, 1623, 1623, 1623, 1623, 1623,
 /*  2120 */  1623, 1623, 1623, 1623, 1623, 1623, 1623, 1623, 1984, 1985,
 /*  2130 */  1623, 1623, 2020, 1623, 1623,  303, 1986,  634, 1988, 1989,
 /*  2140 */   629, 1623,  624, 2003, 1623, 1623, 1623, 1623, 1623, 1623,
 /*  2150 */  1623,  631, 1623, 1623, 1623, 1623, 1954, 1623,  630, 1623,
 /*  2160 */  2003, 1623, 1623, 1623, 1623, 1623, 1623, 1623,  631, 1623,
 /*  2170 */  1623, 1623, 1623, 1954, 1623,  630, 1623, 1623, 1623, 1623,
 /*  2180 */  1623, 1623, 1623, 1984, 1623, 1623, 1985, 2020, 1623, 1623,
 /*  2190 */   304, 1986,  634, 1988, 1989,  629, 1623,  624, 1623, 1623,
 /*  2200 */  1984, 1623, 1623, 1985, 2020, 1623, 1623,  305, 1986,  634,
 /*  2210 */  1988, 1989,  629, 1623,  624, 1623, 1623, 2003, 1623, 1623,
 /*  2220 */  1623, 1623, 1623, 1623, 1623,  631, 1623, 1623, 1623, 1623,
 /*  2230 */  1954, 1623,  630, 1623, 2003, 1623, 1623, 1623, 1623, 1623,
 /*  2240 */  1623, 1623,  631, 1623, 1623, 1623, 1623, 1954, 1985,  630,
 /*  2250 */  1623, 1623, 1623, 1623, 1623, 1623, 1623, 1984, 1623, 1623,
 /*  2260 */  1623, 2020, 1623, 1623,  311, 1986,  634, 1988, 1989,  629,
 /*  2270 */  1623,  624, 1623, 1623, 1984, 1623, 1623, 1623, 2020, 2003,
 /*  2280 */  1623,  315, 1986,  634, 1988, 1989,  629,  631,  624, 1623,
 /*  2290 */  1623, 1623, 1954, 1623,  630, 1623, 1623, 1623, 1623, 1623,
 /*  2300 */  1623, 1623, 1623, 1623, 1623, 1623, 1623, 1623, 1623, 1985,
 /*  2310 */  1623, 1623, 1623, 1623, 1623, 1623, 1623, 1623, 1623, 1984,
 /*  2320 */  1623, 1623, 1623, 2020, 1623, 1985,  307, 1986,  634, 1988,
 /*  2330 */  1989,  629, 1623,  624, 1623, 1623, 1623, 1623, 1623, 1623,
 /*  2340 */  2003, 1623, 1623, 1623, 1623, 1623, 1623, 1623,  631, 1623,
 /*  2350 */  1623, 1623, 1623, 1954, 1623,  630, 2003, 1623, 1623, 1623,
 /*  2360 */  1623, 1623, 1623, 1623,  631, 1623, 1623, 1623, 1623, 1954,
 /*  2370 */  1623,  630, 1623, 1623, 1623, 1623, 1623, 1623, 1623, 1623,
 /*  2380 */  1984, 1623, 1623, 1623, 2020, 1623, 1985,  316, 1986,  634,
 /*  2390 */  1988, 1989,  629, 1623,  624, 1623, 1984, 1623, 1623, 1623,
 /*  2400 */  2020, 1623, 1623,  308, 1986,  634, 1988, 1989,  629, 1623,
 /*  2410 */   624, 1623, 1623, 1623, 1623, 1623, 1623, 2003, 1623, 1623,
 /*  2420 */  1623, 1623, 1623, 1623, 1623,  631, 1623, 1623, 1623, 1623,
 /*  2430 */  1954, 1623,  630, 1623, 1623, 1623, 1623, 1623, 1623, 1623,
 /*  2440 */  1623, 1985, 1623, 1623, 1623, 1623, 1623, 1623, 1623, 1623,
 /*  2450 */  1623, 1623, 1623, 1623, 1623, 1623, 1623, 1984, 1985, 1623,
 /*  2460 */  1623, 2020, 1623, 1623,  317, 1986,  634, 1988, 1989,  629,
 /*  2470 */  1623,  624, 2003, 1623, 1623, 1623, 1623, 1623, 1623, 1623,
 /*  2480 */   631, 1623, 1623, 1623, 1623, 1954, 1623,  630, 1623, 2003,
 /*  2490 */  1623, 1623, 1623, 1623, 1623, 1623, 1623,  631, 1623, 1623,
 /*  2500 */  1623, 1623, 1954, 1623,  630, 1623, 1623, 1623, 1623, 1623,
 /*  2510 */  1623, 1623, 1984, 1623, 1623, 1985, 2020, 1623, 1623,  309,
 /*  2520 */  1986,  634, 1988, 1989,  629, 1623,  624, 1623, 1623, 1984,
 /*  2530 */  1623, 1623, 1985, 2020, 1623, 1623,  322, 1986,  634, 1988,
 /*  2540 */  1989,  629, 1623,  624, 1623, 1623, 2003, 1623, 1623, 1623,
 /*  2550 */  1623, 1623, 1623, 1623,  631, 1623, 1623, 1623, 1623, 1954,
 /*  2560 */  1623,  630, 1623, 2003, 1623, 1623, 1623, 1623, 1623, 1623,
 /*  2570 */  1623,  631, 1623, 1623, 1623, 1623, 1954, 1985,  630, 1623,
 /*  2580 */  1623, 1623, 1623, 1623, 1623, 1623, 1984, 1623, 1623, 1623,
 /*  2590 */  2020, 1623, 1623,  323, 1986,  634, 1988, 1989,  629, 1623,
 /*  2600 */   624, 1623, 1623, 1984, 1623, 1623, 1623, 2020, 2003, 1623,
 /*  2610 */  1997, 1986,  634, 1988, 1989,  629,  631,  624, 1623, 1623,
 /*  2620 */  1623, 1954, 1623,  630, 1623, 1623, 1623, 1623, 1623, 1623,
 /*  2630 */  1623, 1623, 1623, 1623, 1623, 1623, 1623, 1623, 1985, 1623,
 /*  2640 */  1623, 1623, 1623, 1623, 1623, 1623, 1623, 1623, 1984, 1623,
 /*  2650 */  1623, 1623, 2020, 1623, 1985, 1996, 1986,  634, 1988, 1989,
 /*  2660 */   629, 1623,  624, 1623, 1623, 1623, 1623, 1623, 1623, 2003,
 /*  2670 */  1623, 1623, 1623, 1623, 1623, 1623, 1623,  631, 1623, 1623,
 /*  2680 */  1623, 1623, 1954, 1623,  630, 2003, 1623, 1623, 1623, 1623,
 /*  2690 */  1623, 1623, 1623,  631, 1623, 1623, 1623, 1623, 1954, 1623,
 /*  2700 */   630, 1623, 1623, 1623, 1623, 1623, 1623, 1623, 1623, 1984,
 /*  2710 */  1623, 1623, 1623, 2020, 1623, 1985, 1995, 1986,  634, 1988,
 /*  2720 */  1989,  629, 1623,  624, 1623, 1984, 1623, 1623, 1623, 2020,
 /*  2730 */  1623, 1623,  334, 1986,  634, 1988, 1989,  629, 1623,  624,
 /*  2740 */  1623, 1623, 1623, 1623, 1623, 1623, 2003, 1623, 1623, 1623,
 /*  2750 */  1623, 1623, 1623, 1623,  631, 1623, 1623, 1623, 1623, 1954,
 /*  2760 */  1623,  630, 1623, 1623, 1623, 1623, 1623, 1623, 1623, 1623,
 /*  2770 */  1985, 1623, 1623, 1623, 1623, 1623, 1623, 1623, 1623, 1623,
 /*  2780 */  1623, 1623, 1623, 1623, 1623, 1623, 1984, 1985, 1623, 1623,
 /*  2790 */  2020, 1623, 1623,  335, 1986,  634, 1988, 1989,  629, 1623,
 /*  2800 */   624, 2003, 1623, 1623, 1623, 1623, 1623, 1623, 1623,  631,
 /*  2810 */  1623, 1623, 1623, 1623, 1954, 1623,  630, 1623, 2003, 1623,
 /*  2820 */  1623, 1623, 1623, 1623, 1623, 1623,  631, 1623, 1623, 1623,
 /*  2830 */  1623, 1954, 1623,  630, 1623, 1623, 1623, 1623, 1623, 1623,
 /*  2840 */  1623, 1984, 1623, 1623, 1985, 2020, 1623, 1623,  331, 1986,
 /*  2850 */   634, 1988, 1989,  629, 1623,  624, 1623, 1623, 1984, 1623,
 /*  2860 */  1623, 1985, 2020, 1623, 1623,  336, 1986,  634, 1988, 1989,
 /*  2870 */   629, 1623,  624, 1623, 1623, 2003, 1623, 1623, 1623, 1623,
 /*  2880 */  1623, 1623, 1623,  631, 1623, 1623, 1623, 1623, 1954, 1623,
 /*  2890 */   630, 1623, 2003, 1623, 1623, 1623, 1623, 1623, 1623, 1623,
 /*  2900 */   631, 1623, 1623, 1623, 1623, 1954, 1623,  630, 1623, 1623,
 /*  2910 */  1623, 1623, 1623, 1623, 1623,  632, 1623, 1623, 1623, 2020,
 /*  2920 */  1623, 1623,  314, 1986,  634, 1988, 1989,  629, 1623,  624,
 /*  2930 */  1623, 1623, 1984, 1623, 1623, 1623, 2020, 1623, 1623,  313,
 /*  2940 */  1986,  634, 1988, 1989,  629, 1623,  624,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   421,  422,    0,  374,  432,  374,  352,  432,  436,  355,
 /*    10 */   361,  436,   12,   13,   14,  384,  387,  388,  387,  388,
 /*    20 */    20,  372,   22,  451,  452,   20,  361,  452,  456,  457,
 /*    30 */   328,  456,  457,   33,   14,   35,  332,  372,  334,  335,
 /*    40 */    20,   20,    8,    9,  361,  405,   12,   13,   14,   15,
 /*    50 */    16,  402,  403,  404,   14,  372,  389,  336,   58,   20,
 /*    60 */    20,  359,  413,   63,   62,  359,  359,  402,  403,  367,
 /*    70 */    70,  431,  366,  366,  372,  342,  374,  332,  413,  334,
 /*    80 */   335,  375,  375,   12,   13,  402,  403,  404,  367,  356,
 /*    90 */     3,   20,  327,   22,  329,   95,  413,   63,  365,  432,
 /*   100 */    95,  399,  405,  436,   33,  403,   35,   20,  406,  407,
 /*   110 */   408,  409,  410,  411,  342,  413,    4,  117,  451,  452,
 /*   120 */   418,  336,  420,  456,  457,  359,  424,  425,  431,   58,
 /*   130 */    20,   19,  132,  133,   63,  350,  359,  365,  104,  432,
 /*   140 */   438,   70,  357,  436,  367,   33,  380,  381,  446,  428,
 /*   150 */   429,  430,  367,  432,  433,  336,   20,  436,  451,  452,
 /*   160 */    48,  161,  162,  456,  457,   53,   95,  167,  168,  350,
 /*   170 */    58,  370,  451,  452,  373,  374,  357,  456,  457,  367,
 /*   180 */   359,  161,  182,   96,  184,  408,  367,   62,  117,    4,
 /*   190 */   378,    8,    9,  126,  160,   12,   13,   14,   15,   16,
 /*   200 */   161,  162,  381,  132,  133,   95,   94,  207,  208,   97,
 /*   210 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   220 */   220,  221,  222,  223,  224,  225,  226,  227,   43,    4,
 /*   230 */    45,   46,  161,  162,   14,   15,   16,   21,  167,  168,
 /*   240 */    24,   25,   26,   27,   28,   29,   30,   31,   32,  343,
 /*   250 */   163,   37,  358,  182,  348,  184,    8,    9,  191,  192,
 /*   260 */    12,   13,   14,   15,   16,  371,  232,  233,  234,  235,
 /*   270 */   236,  237,  238,  239,  240,  241,  242,   58,  207,  208,
 /*   280 */    20,  210,  211,  212,  213,  214,  215,  216,  217,  218,
 /*   290 */   219,  220,  221,  222,  223,  224,  225,  226,  227,  163,
 /*   300 */   229,   12,   13,    0,   12,   13,   14,   15,   16,   20,
 /*   310 */     0,   22,   98,   94,  100,  101,   97,  103,   20,  328,
 /*   320 */    95,  107,   33,  328,   35,  108,  109,  110,  111,  112,
 /*   330 */   113,  114,  115,  116,  117,  118,   35,  120,  121,  122,
 /*   340 */   123,  124,  125,  129,   96,  333,   58,   58,  336,  337,
 /*   350 */   359,   21,   63,  373,  374,  245,   20,  174,  367,   70,
 /*   360 */    20,   39,   22,  372,   34,  374,   36,  372,   65,   66,
 /*   370 */    67,   70,   12,   13,   14,   35,   73,   74,   20,   20,
 /*   380 */    20,   78,   22,   95,   95,   97,   83,   84,  405,  359,
 /*   390 */   399,   51,   89,   33,  403,   35,  366,  406,  407,  408,
 /*   400 */   409,  410,  411,  328,  413,  375,  117,  416,  432,  418,
 /*   410 */   419,  420,  436,    2,  431,  424,  425,  107,   58,    8,
 /*   420 */     9,  132,  133,   12,   13,   14,   15,   16,  452,    0,
 /*   430 */    70,    0,  456,  457,  359,    0,  126,  127,  128,  129,
 /*   440 */   130,  131,  367,  126,  127,  345,  346,  372,  131,  374,
 /*   450 */   161,  162,  269,  166,   95,   95,  167,  168,  336,   24,
 /*   460 */    25,   26,   27,   28,   29,   30,   31,   32,  132,  133,
 /*   470 */   245,  182,  333,  184,  399,  336,  337,  117,  403,   48,
 /*   480 */   328,  406,  407,  408,  409,  410,  411,  412,  413,  414,
 /*   490 */   415,   62,  132,  133,  345,  346,  207,  208,  376,  210,
 /*   500 */   211,  212,  213,  214,  215,  216,  217,  218,  219,  220,
 /*   510 */   221,  222,  223,  224,  225,  226,  227,   65,   66,   67,
 /*   520 */   336,  161,  162,  351,  372,   73,   74,  167,  168,    0,
 /*   530 */    78,  359,  359,  245,  350,   83,   84,  250,  251,  252,
 /*   540 */   368,   89,  182,  177,  184,   95,  325,  340,  375,  416,
 /*   550 */    21,  367,  419,   24,   25,   26,   27,   28,   29,   30,
 /*   560 */    31,   32,  328,   95,  198,  199,  244,  207,  208,  362,
 /*   570 */   210,  211,  212,  213,  214,  215,  216,  217,  218,  219,
 /*   580 */   220,  221,  222,  223,  224,  225,  226,  227,   12,   13,
 /*   590 */    22,  328,  417,  359,  419,   20,   20,   22,   22,  369,
 /*   600 */   336,  367,  372,   35,  245,   95,  372,   62,  374,   33,
 /*   610 */   389,   35,  106,  127,  350,    1,    2,    8,    9,  328,
 /*   620 */   359,   12,   13,   14,   15,   16,   51,  366,  229,   20,
 /*   630 */   336,  367,  359,  399,   58,  372,  375,  403,   70,  366,
 /*   640 */   406,  407,  408,  409,  410,  411,   70,  413,  375,  181,
 /*   650 */   359,  183,  336,  432,    0,    3,  336,  436,  367,   12,
 /*   660 */    13,  367,  229,  372,  231,  374,  350,   20,   20,   22,
 /*   670 */   350,   95,  451,  452,  340,  189,  190,  456,  457,  193,
 /*   680 */    33,  195,   35,  367,  450,  117,  389,  367,  354,  336,
 /*   690 */   399,  328,  328,  117,  403,  245,  362,  406,  407,  408,
 /*   700 */   409,  410,  411,  350,  413,   58,    0,   63,  132,  133,
 /*   710 */    96,  420,   20,  245,  336,  424,  425,   70,   22,   79,
 /*   720 */   367,  427,  428,  429,  430,   70,  432,  433,  350,  432,
 /*   730 */   328,   35,  336,  436,  160,  372,  372,  161,  162,  351,
 /*   740 */   367,  328,   95,  167,  168,  367,  350,  359,  451,  452,
 /*   750 */   182,  378,  184,  456,  457,  245,  368,  347,  182,  349,
 /*   760 */   184,    8,    9,  367,  117,   12,   13,   14,   15,   16,
 /*   770 */    20,  367,  163,  328,  372,  207,  208,  137,  138,  132,
 /*   780 */   133,    4,  378,  207,  208,  372,  210,  211,  212,  213,
 /*   790 */   214,  215,  216,  217,  218,  219,  220,  221,  222,  223,
 /*   800 */   224,  225,  226,  227,  328,  151,  232,  336,  161,  162,
 /*   810 */    18,  163,   20,  107,  167,  168,  242,  372,  417,   27,
 /*   820 */   419,  350,   30,  360,  369,   33,  207,  372,   42,  182,
 /*   830 */    44,  184,  126,  127,  128,  129,  130,  131,  367,  351,
 /*   840 */    48,   20,   50,  359,   14,   53,   70,  359,  372,   96,
 /*   850 */    20,  207,  368,  161,  207,  208,  368,  210,  211,  212,
 /*   860 */   213,  214,  215,  216,  217,  218,  219,  220,  221,  222,
 /*   870 */   223,  224,  225,  226,  227,  256,  257,  258,  259,  260,
 /*   880 */    18,  369,  132,  133,  372,   23,   94,    0,  336,    8,
 /*   890 */     9,   45,   46,   12,   13,   14,   15,   16,  106,   37,
 /*   900 */    38,    2,  350,   41,   44,  107,  352,    8,    9,  355,
 /*   910 */    95,   12,   13,   14,   15,   16,  264,  167,  168,  367,
 /*   920 */   105,   59,   60,   61,   42,   44,   44,  129,  136,  243,
 /*   930 */   244,  139,  140,  141,  142,  143,  144,  145,  146,  147,
 /*   940 */   148,  149,  150,  151,  152,  153,  154,  155,  328,  157,
 /*   950 */   158,  159,   65,   66,   67,   68,   69,   95,   71,   72,
 /*   960 */    73,   74,   75,   76,   77,   78,   79,   80,   81,   82,
 /*   970 */    83,   84,   85,   86,   87,   88,   89,   90,   91,  336,
 /*   980 */    19,    8,    9,   44,  163,   12,   13,   14,   15,   16,
 /*   990 */   328,  161,  372,  350,   33,   44,  134,    8,    9,    0,
 /*  1000 */   328,   12,   13,   14,   15,   16,  106,  348,   99,   48,
 /*  1010 */   367,  102,  336,  328,  336,   54,   55,   56,   57,   58,
 /*  1020 */   360,   22,   44,  246,   99,  328,  350,  102,  350,  107,
 /*  1030 */    99,  359,  328,  102,  372,   96,  174,  175,  176,  367,
 /*  1040 */   360,  179,  328,  367,  372,  367,  374,   96,  126,  127,
 /*  1050 */   128,  129,  130,  131,   35,   94,  156,  372,   97,  197,
 /*  1060 */   393,  361,  200,  336,  202,  203,  204,  205,  206,  372,
 /*  1070 */   336,  399,  372,  328,  336,  403,  372,  350,  406,  407,
 /*  1080 */   408,  409,  410,  411,  350,  413,  372,  329,  350,  328,
 /*  1090 */   418,  130,  420,  328,  367,  336,  424,  425,    0,  389,
 /*  1100 */   336,  367,  402,  403,  359,  367,  328,  245,   99,  350,
 /*  1110 */   382,  102,  367,  413,  350,  328,  360,  372,  446,  374,
 /*  1120 */    22,    0,  132,  133,  359,  164,  367,  163,  268,   44,
 /*  1130 */   169,  367,  367,  372,  170,   44,  163,  372,  328,  374,
 /*  1140 */    44,  360,  432,   22,  399,   44,  436,  186,  403,  188,
 /*  1150 */   372,  406,  407,  408,  409,  410,  411,   58,  413,  372,
 /*  1160 */   328,  451,  452,  418,  399,  420,  456,  457,  403,  424,
 /*  1170 */   425,  406,  407,  408,  409,  410,  411,  360,  413,  336,
 /*  1180 */   435,   96,  372,  418,  336,  420,  389,   96,   35,  424,
 /*  1190 */   425,  359,   96,  350,  336,  336,   97,   96,  350,  367,
 /*  1200 */   435,    1,    2,  184,  372,  360,  374,  460,  350,  350,
 /*  1210 */   367,  449,   44,   12,   13,  367,  328,  338,   44,  382,
 /*  1220 */    44,  338,  389,   22,   44,  367,  367,   44,   44,  432,
 /*  1230 */    44,  399,  336,  436,   33,  403,   35,    0,  406,  407,
 /*  1240 */   408,  409,  410,  411,  266,  413,   35,  359,  451,  452,
 /*  1250 */   418,   44,  420,  456,  457,  367,  424,  425,   44,   58,
 /*  1260 */   372,  328,  374,  367,   96,  432,   47,  435,   44,  436,
 /*  1270 */    96,   70,   96,  336,  443,   44,   96,  359,   44,   96,
 /*  1280 */    96,   70,   96,  335,  451,  452,   49,  399,  371,  456,
 /*  1290 */   457,  403,  359,   13,  406,  407,  408,  409,  410,  411,
 /*  1300 */   367,  413,  382,   96,  367,  372,  418,  374,  420,   13,
 /*  1310 */    96,  434,  424,  425,   95,   35,  453,  426,  117,  247,
 /*  1320 */    96,  437,  401,  435,  428,  429,  430,   96,  432,  433,
 /*  1330 */    96,   35,  399,   48,  400,  180,  403,  184,  391,  406,
 /*  1340 */   407,  408,  409,  410,  411,   42,  413,  379,   20,  382,
 /*  1350 */   379,  418,  160,  420,  377,   20,  336,  424,  425,  336,
 /*  1360 */   328,  379,  377,  377,   93,  428,  429,  430,  435,  432,
 /*  1370 */   433,  344,  336,  336,  336,   20,  330,  330,   20,  395,
 /*  1380 */    20,  342,  374,  182,  342,  184,   20,  337,   20,  337,
 /*  1390 */   390,  359,  336,  342,   52,  342,  342,  342,  339,  367,
 /*  1400 */   342,  339,  359,  330,  372,  372,  374,  359,  207,  208,
 /*  1410 */   336,  330,  372,  196,  398,   95,  359,  395,  397,  359,
 /*  1420 */   359,  220,  221,  222,  223,  224,  225,  226,  359,  359,
 /*  1430 */   359,  399,  340,  328,  359,  403,  359,  359,  406,  407,
 /*  1440 */   408,  409,  410,  411,  187,  413,  340,  336,  382,  382,
 /*  1450 */   418,  372,  420,  328,  374,  442,  424,  425,  394,  255,
 /*  1460 */   254,  385,  372,  261,  359,  372,  442,  385,  173,  372,
 /*  1470 */   445,  263,  367,  444,  262,  440,  442,  372,  248,  374,
 /*  1480 */   270,  265,  441,  439,  359,  401,  455,  461,  267,  244,
 /*  1490 */   367,   20,  367,  405,  336,  385,  337,  372,  372,  374,
 /*  1500 */   340,  340,  372,  454,  399,  372,  372,  372,  403,  328,
 /*  1510 */   372,  406,  407,  408,  409,  410,  411,  385,  413,  165,
 /*  1520 */   383,  355,  340,  418,  399,  420,   95,  340,  403,  424,
 /*  1530 */   425,  406,  407,  408,  409,  410,  411,  367,  413,  423,
 /*  1540 */   359,   95,  363,  418,  372,  420,  349,   36,  367,  424,
 /*  1550 */   425,  336,  330,  372,  331,  374,  392,  386,  340,  396,
 /*  1560 */     0,  386,  353,    0,  328,  326,  353,  341,  189,    0,
 /*  1570 */     0,    0,   42,  353,   35,  201,   35,   35,   35,  201,
 /*  1580 */   399,    0,   35,   35,  403,  201,    0,  406,  407,  408,
 /*  1590 */   409,  410,  411,  201,  413,  359,   35,    0,   22,    0,
 /*  1600 */    35,  420,    0,  367,  184,  424,  425,  182,  372,    0,
 /*  1610 */   374,    0,  178,  177,    0,    0,    0,    0,    0,   47,
 /*  1620 */   328,   42,    0,    0,    0,    0,    0,    0,    0,    0,
 /*  1630 */   151,    0,  151,   35,    0,  399,  328,    0,    0,  403,
 /*  1640 */     0,    0,  406,  407,  408,  409,  410,  411,    0,  413,
 /*  1650 */     0,  359,   42,    0,    0,    0,  420,    0,    0,  367,
 /*  1660 */   424,  425,    0,    0,  372,    0,  374,  359,   22,    0,
 /*  1670 */     0,    0,  135,    0,    0,  367,    0,    0,    0,    0,
 /*  1680 */   372,    0,  374,    0,   35,    0,    0,    0,   58,   42,
 /*  1690 */    58,  399,   47,    0,   14,  403,   14,  328,  406,  407,
 /*  1700 */   408,  409,  410,  411,   44,  413,   39,  399,   47,    0,
 /*  1710 */     0,  403,   40,   47,  406,  407,  408,  409,  410,  411,
 /*  1720 */     0,  413,  173,   39,    0,    0,    0,   39,  359,   35,
 /*  1730 */    39,    0,   35,    0,   39,   35,  367,    0,    0,  447,
 /*  1740 */   448,  372,   39,  374,   48,    0,   48,   48,   35,   48,
 /*  1750 */    39,    0,  328,   64,    0,    0,    0,   35,   22,    0,
 /*  1760 */   104,  102,   35,   35,   22,   35,  458,  459,  399,  328,
 /*  1770 */    35,    0,  403,    0,   35,  406,  407,  408,  409,  410,
 /*  1780 */   411,   35,  413,  359,   44,   44,   22,   35,   22,  420,
 /*  1790 */     0,  367,   22,   50,  425,   35,  372,    0,  374,    0,
 /*  1800 */   359,   22,   35,   35,    0,   20,  194,   35,  367,   35,
 /*  1810 */    96,   95,    0,  372,  163,  374,   35,    0,  185,    0,
 /*  1820 */    22,    0,   44,  399,  249,    3,  253,  403,   96,  165,
 /*  1830 */   406,  407,  408,  409,  410,  411,  228,  413,  328,   95,
 /*  1840 */   399,   47,   95,   95,  403,   96,  171,  406,  407,  408,
 /*  1850 */   409,  410,  411,  163,  413,  163,   95,  328,   44,   96,
 /*  1860 */    95,   35,   44,   47,   44,   96,    3,   44,  249,  359,
 /*  1870 */    95,   35,  448,   96,  364,  170,  170,  367,   96,   35,
 /*  1880 */    35,   35,  372,   35,  374,  249,   47,   96,  359,   96,
 /*  1890 */    47,   44,    0,    0,    0,    0,  367,   95,   39,   96,
 /*  1900 */   459,  372,   95,  374,   96,   95,   95,    0,   95,  399,
 /*  1910 */    39,  105,   47,  403,  164,    2,  406,  407,  408,  409,
 /*  1920 */   410,  411,   95,  413,  328,   44,   22,   95,  399,   96,
 /*  1930 */   207,   96,  403,   95,  230,  406,  407,  408,  409,  410,
 /*  1940 */   411,   22,  413,  228,  415,  243,  166,  228,   95,   47,
 /*  1950 */    96,   33,   95,   47,   22,  359,   95,  106,   96,   95,
 /*  1960 */   364,   35,  209,  367,   96,   35,   48,   95,  372,   96,
 /*  1970 */   374,   35,   54,   55,   56,   57,   58,   95,   35,   96,
 /*  1980 */   328,   95,   35,   96,   95,   35,   96,  107,  119,  119,
 /*  1990 */    44,   95,   95,  119,   95,  399,  328,  119,   35,  403,
 /*  2000 */    95,   22,  406,  407,  408,  409,  410,  411,   64,  413,
 /*  2010 */    35,  359,   94,   35,   63,   97,  364,   35,   35,  367,
 /*  2020 */    35,   35,   35,   35,  372,   35,  374,  359,   35,   70,
 /*  2030 */    92,   35,   22,   44,   35,  367,   35,   35,   35,   35,
 /*  2040 */   372,   70,  374,   35,   35,   22,   35,   35,   35,   35,
 /*  2050 */     0,  399,   35,   48,   39,  403,    0,  328,  406,  407,
 /*  2060 */   408,  409,  410,  411,   35,  413,   48,  399,    0,   39,
 /*  2070 */    35,  403,   48,   39,  406,  407,  408,  409,  410,  411,
 /*  2080 */     0,  413,  164,  165,   35,   48,   39,  169,  359,    0,
 /*  2090 */   172,    0,   35,   22,   35,   21,  367,   22,   22,   21,
 /*  2100 */   462,  372,   20,  374,  462,  462,  188,  462,  462,  462,
 /*  2110 */   462,  462,  328,  462,  462,  462,  462,  462,  462,  462,
 /*  2120 */   462,  462,  462,  462,  462,  462,  462,  462,  399,  328,
 /*  2130 */   462,  462,  403,  462,  462,  406,  407,  408,  409,  410,
 /*  2140 */   411,  462,  413,  359,  462,  462,  462,  462,  462,  462,
 /*  2150 */   462,  367,  462,  462,  462,  462,  372,  462,  374,  462,
 /*  2160 */   359,  462,  462,  462,  462,  462,  462,  462,  367,  462,
 /*  2170 */   462,  462,  462,  372,  462,  374,  462,  462,  462,  462,
 /*  2180 */   462,  462,  462,  399,  462,  462,  328,  403,  462,  462,
 /*  2190 */   406,  407,  408,  409,  410,  411,  462,  413,  462,  462,
 /*  2200 */   399,  462,  462,  328,  403,  462,  462,  406,  407,  408,
 /*  2210 */   409,  410,  411,  462,  413,  462,  462,  359,  462,  462,
 /*  2220 */   462,  462,  462,  462,  462,  367,  462,  462,  462,  462,
 /*  2230 */   372,  462,  374,  462,  359,  462,  462,  462,  462,  462,
 /*  2240 */   462,  462,  367,  462,  462,  462,  462,  372,  328,  374,
 /*  2250 */   462,  462,  462,  462,  462,  462,  462,  399,  462,  462,
 /*  2260 */   462,  403,  462,  462,  406,  407,  408,  409,  410,  411,
 /*  2270 */   462,  413,  462,  462,  399,  462,  462,  462,  403,  359,
 /*  2280 */   462,  406,  407,  408,  409,  410,  411,  367,  413,  462,
 /*  2290 */   462,  462,  372,  462,  374,  462,  462,  462,  462,  462,
 /*  2300 */   462,  462,  462,  462,  462,  462,  462,  462,  462,  328,
 /*  2310 */   462,  462,  462,  462,  462,  462,  462,  462,  462,  399,
 /*  2320 */   462,  462,  462,  403,  462,  328,  406,  407,  408,  409,
 /*  2330 */   410,  411,  462,  413,  462,  462,  462,  462,  462,  462,
 /*  2340 */   359,  462,  462,  462,  462,  462,  462,  462,  367,  462,
 /*  2350 */   462,  462,  462,  372,  462,  374,  359,  462,  462,  462,
 /*  2360 */   462,  462,  462,  462,  367,  462,  462,  462,  462,  372,
 /*  2370 */   462,  374,  462,  462,  462,  462,  462,  462,  462,  462,
 /*  2380 */   399,  462,  462,  462,  403,  462,  328,  406,  407,  408,
 /*  2390 */   409,  410,  411,  462,  413,  462,  399,  462,  462,  462,
 /*  2400 */   403,  462,  462,  406,  407,  408,  409,  410,  411,  462,
 /*  2410 */   413,  462,  462,  462,  462,  462,  462,  359,  462,  462,
 /*  2420 */   462,  462,  462,  462,  462,  367,  462,  462,  462,  462,
 /*  2430 */   372,  462,  374,  462,  462,  462,  462,  462,  462,  462,
 /*  2440 */   462,  328,  462,  462,  462,  462,  462,  462,  462,  462,
 /*  2450 */   462,  462,  462,  462,  462,  462,  462,  399,  328,  462,
 /*  2460 */   462,  403,  462,  462,  406,  407,  408,  409,  410,  411,
 /*  2470 */   462,  413,  359,  462,  462,  462,  462,  462,  462,  462,
 /*  2480 */   367,  462,  462,  462,  462,  372,  462,  374,  462,  359,
 /*  2490 */   462,  462,  462,  462,  462,  462,  462,  367,  462,  462,
 /*  2500 */   462,  462,  372,  462,  374,  462,  462,  462,  462,  462,
 /*  2510 */   462,  462,  399,  462,  462,  328,  403,  462,  462,  406,
 /*  2520 */   407,  408,  409,  410,  411,  462,  413,  462,  462,  399,
 /*  2530 */   462,  462,  328,  403,  462,  462,  406,  407,  408,  409,
 /*  2540 */   410,  411,  462,  413,  462,  462,  359,  462,  462,  462,
 /*  2550 */   462,  462,  462,  462,  367,  462,  462,  462,  462,  372,
 /*  2560 */   462,  374,  462,  359,  462,  462,  462,  462,  462,  462,
 /*  2570 */   462,  367,  462,  462,  462,  462,  372,  328,  374,  462,
 /*  2580 */   462,  462,  462,  462,  462,  462,  399,  462,  462,  462,
 /*  2590 */   403,  462,  462,  406,  407,  408,  409,  410,  411,  462,
 /*  2600 */   413,  462,  462,  399,  462,  462,  462,  403,  359,  462,
 /*  2610 */   406,  407,  408,  409,  410,  411,  367,  413,  462,  462,
 /*  2620 */   462,  372,  462,  374,  462,  462,  462,  462,  462,  462,
 /*  2630 */   462,  462,  462,  462,  462,  462,  462,  462,  328,  462,
 /*  2640 */   462,  462,  462,  462,  462,  462,  462,  462,  399,  462,
 /*  2650 */   462,  462,  403,  462,  328,  406,  407,  408,  409,  410,
 /*  2660 */   411,  462,  413,  462,  462,  462,  462,  462,  462,  359,
 /*  2670 */   462,  462,  462,  462,  462,  462,  462,  367,  462,  462,
 /*  2680 */   462,  462,  372,  462,  374,  359,  462,  462,  462,  462,
 /*  2690 */   462,  462,  462,  367,  462,  462,  462,  462,  372,  462,
 /*  2700 */   374,  462,  462,  462,  462,  462,  462,  462,  462,  399,
 /*  2710 */   462,  462,  462,  403,  462,  328,  406,  407,  408,  409,
 /*  2720 */   410,  411,  462,  413,  462,  399,  462,  462,  462,  403,
 /*  2730 */   462,  462,  406,  407,  408,  409,  410,  411,  462,  413,
 /*  2740 */   462,  462,  462,  462,  462,  462,  359,  462,  462,  462,
 /*  2750 */   462,  462,  462,  462,  367,  462,  462,  462,  462,  372,
 /*  2760 */   462,  374,  462,  462,  462,  462,  462,  462,  462,  462,
 /*  2770 */   328,  462,  462,  462,  462,  462,  462,  462,  462,  462,
 /*  2780 */   462,  462,  462,  462,  462,  462,  399,  328,  462,  462,
 /*  2790 */   403,  462,  462,  406,  407,  408,  409,  410,  411,  462,
 /*  2800 */   413,  359,  462,  462,  462,  462,  462,  462,  462,  367,
 /*  2810 */   462,  462,  462,  462,  372,  462,  374,  462,  359,  462,
 /*  2820 */   462,  462,  462,  462,  462,  462,  367,  462,  462,  462,
 /*  2830 */   462,  372,  462,  374,  462,  462,  462,  462,  462,  462,
 /*  2840 */   462,  399,  462,  462,  328,  403,  462,  462,  406,  407,
 /*  2850 */   408,  409,  410,  411,  462,  413,  462,  462,  399,  462,
 /*  2860 */   462,  328,  403,  462,  462,  406,  407,  408,  409,  410,
 /*  2870 */   411,  462,  413,  462,  462,  359,  462,  462,  462,  462,
 /*  2880 */   462,  462,  462,  367,  462,  462,  462,  462,  372,  462,
 /*  2890 */   374,  462,  359,  462,  462,  462,  462,  462,  462,  462,
 /*  2900 */   367,  462,  462,  462,  462,  372,  462,  374,  462,  462,
 /*  2910 */   462,  462,  462,  462,  462,  399,  462,  462,  462,  403,
 /*  2920 */   462,  462,  406,  407,  408,  409,  410,  411,  462,  413,
 /*  2930 */   462,  462,  399,  462,  462,  462,  403,  462,  462,  406,
 /*  2940 */   407,  408,  409,  410,  411,  462,  413,
};
#define YY_SHIFT_COUNT    (724)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (2091)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   862,    0,   71,    0,  289,  289,  289,  289,  289,  289,
 /*    10 */   289,  289,  289,  289,  289,  360,  576,  576,  647,  576,
 /*    20 */   576,  576,  576,  576,  576,  576,  576,  576,  576,  576,
 /*    30 */   576,  576,  576,  576,  576,  576,  576,  576,  576,  576,
 /*    40 */   576,  576,  576,  576,  576,  576,  576,  576,  110,  359,
 /*    50 */     5,  468,  288,  450,  510,  450,    5,    5, 1201, 1201,
 /*    60 */   450, 1201, 1201,  225,  450,  750,   21,   21,  750,  185,
 /*    70 */   185,   39,  336,   40,   40,   21,   21,   21,   21,   21,
 /*    80 */    21,   21,   21,   21,   21,  125,  260,   21,   21,  298,
 /*    90 */    21,  260,   21,   21,   21,   21,  260,   21,   21,  260,
 /*   100 */    21,  260,  260,  260,   21,  545,  792,   34,   34,  216,
 /*   110 */   452,  568,  568,  568,  568,  568,  568,  568,  568,  568,
 /*   120 */   568,  568,  568,  568,  568,  568,  568,  568,  568,  568,
 /*   130 */   214,   87,   39,  336,    2,  301,  136,  136,  136,  429,
 /*   140 */   433,  433,  301,  358,  358,  358,  506,  399,  260,  655,
 /*   150 */   260,  655,  655,  506,  776,  217,  217,  217,  217,  217,
 /*   160 */   217,  217,  961,  529,  303,  609,  183,  619,  340,  287,
 /*   170 */    20,  830,  575,  648,  846,  798,  821,  686,  322,  652,
 /*   180 */   686,  786,  777,  692, 1072, 1285, 1155, 1303, 1328, 1303,
 /*   190 */  1192, 1335, 1335, 1303, 1192, 1192, 1271, 1335, 1335, 1335,
 /*   200 */  1355, 1355, 1358,  125, 1360,  125, 1366, 1368,  125, 1366,
 /*   210 */   125,  125,  125, 1335,  125, 1342, 1342, 1355,  260,  260,
 /*   220 */   260,  260,  260,  260,  260,  260,  260,  260,  260, 1335,
 /*   230 */  1355,  655,  655, 1217, 1320, 1358,  545, 1257, 1360,  545,
 /*   240 */  1335, 1328, 1328,  655, 1204, 1206,  655, 1204, 1206,  655,
 /*   250 */   655,  260, 1202, 1295, 1204, 1208, 1212, 1230, 1072, 1210,
 /*   260 */  1221, 1216, 1245,  358, 1471, 1335, 1366,  545,  545, 1206,
 /*   270 */   655,  655,  655,  655,  655, 1206,  655, 1354,  545,  506,
 /*   280 */   545,  358, 1431, 1446,  655,  776, 1335,  545, 1511, 1355,
 /*   290 */  2947, 2947, 2947, 2947, 2947, 2947, 2947, 2947, 2947,  887,
 /*   300 */  1918,  435,  112,  248,  881,  753,  310,  411,  899,  973,
 /*   310 */   706,  989,  989,  989,  989,  989,  989,  989,  989,  989,
 /*   320 */   922,  486,  292,  292,  366,  219,  640,  330,   67,  317,
 /*   330 */   317,  220,  614,  574,  220,  220,  220,  939,  431,  696,
 /*   340 */   882,  900,  654,  909,  925,  931, 1009,  999, 1098, 1121,
 /*   350 */   951, 1099, 1085, 1091,  990,  978,  860,  964, 1096, 1101,
 /*   360 */  1168, 1174, 1176, 1180, 1200, 1183, 1019, 1153,  644, 1184,
 /*   370 */  1219, 1186, 1207, 1214, 1224, 1231, 1234,  815, 1280, 1296,
 /*   380 */  1211, 1237, 1560, 1563, 1379, 1569, 1570, 1530, 1571, 1539,
 /*   390 */  1374, 1541, 1542, 1543, 1378, 1581, 1547, 1548, 1384, 1586,
 /*   400 */  1392, 1602, 1561, 1597, 1576, 1599, 1565, 1420, 1425, 1609,
 /*   410 */  1611, 1434, 1436, 1614, 1615, 1572, 1616, 1617, 1618, 1579,
 /*   420 */  1622, 1623, 1624, 1625, 1626, 1627, 1628, 1629, 1479, 1598,
 /*   430 */  1631, 1481, 1634, 1637, 1638, 1640, 1641, 1648, 1650, 1657,
 /*   440 */  1658, 1662, 1663, 1665, 1676, 1677, 1678, 1610, 1653, 1654,
 /*   450 */  1655, 1679, 1681, 1646, 1669, 1670, 1671, 1537, 1673, 1674,
 /*   460 */  1649, 1683, 1630, 1685, 1632, 1686, 1687, 1647, 1667, 1660,
 /*   470 */  1645, 1680, 1661, 1682, 1666, 1693, 1672, 1684, 1709, 1710,
 /*   480 */  1720, 1688, 1549, 1724, 1725, 1726, 1689, 1737, 1738, 1694,
 /*   490 */  1696, 1691, 1731, 1697, 1698, 1695, 1733, 1700, 1699, 1703,
 /*   500 */  1745, 1713, 1701, 1711, 1751, 1754, 1755, 1756, 1656, 1659,
 /*   510 */  1722, 1736, 1759, 1727, 1728, 1730, 1735, 1740, 1741, 1739,
 /*   520 */  1746, 1742, 1752, 1771, 1764, 1773, 1766, 1743, 1790, 1770,
 /*   530 */  1760, 1797, 1767, 1799, 1768, 1804, 1779, 1785, 1772, 1774,
 /*   540 */  1612, 1714, 1716, 1812, 1651, 1781, 1817, 1633, 1798, 1690,
 /*   550 */  1664, 1819, 1821, 1692, 1675, 1822, 1778, 1575, 1744, 1732,
 /*   560 */  1747, 1705, 1608, 1706, 1573, 1749, 1814, 1763, 1748, 1761,
 /*   570 */  1765, 1769, 1818, 1794, 1816, 1775, 1820, 1619, 1777, 1782,
 /*   580 */  1863, 1823, 1636, 1826, 1836, 1844, 1845, 1846, 1848, 1791,
 /*   590 */  1793, 1839, 1702, 1847, 1843, 1892, 1893, 1894, 1895, 1802,
 /*   600 */  1859, 1807, 1803, 1808, 1810, 1811, 1780, 1813, 1907, 1871,
 /*   610 */  1750, 1827, 1806, 1645, 1865, 1881, 1715, 1704, 1719, 1913,
 /*   620 */  1904, 1723, 1832, 1833, 1838, 1835, 1853, 1854, 1902, 1857,
 /*   630 */  1861, 1906, 1862, 1919, 1753, 1864, 1851, 1868, 1926, 1930,
 /*   640 */  1872, 1873, 1936, 1882, 1883, 1943, 1886, 1887, 1947, 1889,
 /*   650 */  1890, 1950, 1896, 1869, 1870, 1874, 1878, 1932, 1880, 1897,
 /*   660 */  1946, 1899, 1963, 1905, 1946, 1946, 1979, 1944, 1951, 1975,
 /*   670 */  1978, 1982, 1983, 1985, 1986, 1987, 1988, 1990, 1993, 1959,
 /*   680 */  1938, 1989, 1996, 1999, 2001, 2010, 2002, 2003, 2004, 1971,
 /*   690 */  1740, 2008, 1741, 2009, 2011, 2012, 2013, 2023, 2014, 2050,
 /*   700 */  2017, 2005, 2015, 2056, 2029, 2018, 2030, 2068, 2035, 2024,
 /*   710 */  2034, 2080, 2049, 2037, 2047, 2089, 2057, 2059, 2091, 2071,
 /*   720 */  2074, 2075, 2076, 2078, 2082,
};
#define YY_REDUCE_COUNT (298)
#define YY_REDUCE_MIN   (-428)
#define YY_REDUCE_MAX   (2533)
static const short yy_reduce_ofst[] = {
 /*     0 */   221, -298,   -9,  672,  745,  765,  832,  888,  933, 1032,
 /*    10 */  1105, 1125,  291, 1181, 1236,   75, 1292, 1308, 1369, 1424,
 /*    20 */   234, 1441, 1510, 1529, 1596, 1652, 1668, 1729, 1784, 1801,
 /*    30 */  1858, 1875, 1920, 1981, 1997, 2058, 2113, 2130, 2187, 2204,
 /*    40 */  2249, 2310, 2326, 2387, 2442, 2459, 2516, 2533, -279, -293,
 /*    50 */   294, -333,  297,  710,  797,  833,  896,  937, -351, -317,
 /*    60 */  -428, -335,  700, -425,  -24, -369, -215, -181, -371, -296,
 /*    70 */  -255, -234, -199,   12,  139,  184,  264,  316,  320,  353,
 /*    80 */   378,  396,  471,  552,  643, -267, -294,  676,  678, -223,
 /*    90 */   727,   30,  734,  738,  759,  764,  172,  843,  858,  261,
 /*   100 */   859,  388,  273,  488,  848,  334,  122, -421, -421, -235,
 /*   110 */   -94,   -5,  152,  263,  363,  364,  402,  413,  445,  476,
 /*   120 */   620,  662,  685,  697,  704,  714,  761,  778,  787,  810,
 /*   130 */  -106, -360, -179,  -20, -228,  100, -360, -303,  -17,  207,
 /*   140 */   175,  401,  149, -188,  373,  404, -346,  133,  484,  230,
 /*   150 */   173,  455,  512,  554,  410,  463,  660,  680,  756,  781,
 /*   160 */   817,  845,  667,  758,  659,  728,  747,  762,  879,  831,
 /*   170 */   918,  918,  883,  837,  948,  917,  920,  877,  877,  863,
 /*   180 */   877,  891,  884,  918,  921,  934,  947,  968,  967,  971,
 /*   190 */   977, 1020, 1023,  982,  985,  986, 1027, 1036, 1037, 1038,
 /*   200 */  1046, 1047,  984, 1039, 1008, 1042, 1050, 1000, 1051, 1052,
 /*   210 */  1053, 1054, 1055, 1056, 1058, 1059, 1062, 1073, 1043, 1048,
 /*   220 */  1057, 1060, 1061, 1069, 1070, 1071, 1075, 1077, 1078, 1074,
 /*   230 */  1081, 1033, 1040, 1016, 1021, 1022, 1092, 1064, 1080, 1106,
 /*   240 */  1111, 1066, 1067, 1079, 1013, 1076, 1090, 1024, 1082, 1093,
 /*   250 */  1097,  918, 1025, 1029, 1034, 1041, 1035, 1044, 1084, 1026,
 /*   260 */  1031, 1049,  877, 1123, 1088, 1158, 1159, 1160, 1161, 1110,
 /*   270 */  1126, 1130, 1133, 1134, 1135, 1132, 1138, 1137, 1182, 1166,
 /*   280 */  1187, 1170, 1116, 1179, 1172, 1197, 1215, 1218, 1223, 1222,
 /*   290 */  1164, 1163, 1171, 1175, 1209, 1213, 1220, 1226, 1239,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*    10 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*    20 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*    30 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*    40 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*    50 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*    60 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*    70 */  1621, 1876, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*    80 */  1621, 1621, 1621, 1621, 1621, 1699, 1621, 1621, 1621, 1621,
 /*    90 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   100 */  1621, 1621, 1621, 1621, 1621, 1697, 1869, 2075, 1621, 1621,
 /*   110 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   120 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   130 */  1621, 2087, 1621, 1621, 1699, 1621, 2087, 2087, 2087, 1697,
 /*   140 */  2047, 2047, 1621, 1621, 1621, 1621, 1806, 1621, 1621, 1621,
 /*   150 */  1621, 1621, 1621, 1806, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   160 */  1621, 1621, 1919, 1621, 1621, 2112, 2166, 1621, 1621, 2115,
 /*   170 */  1621, 1621, 1621, 1881, 1621, 1759, 2102, 2079, 2093, 2150,
 /*   180 */  2080, 2077, 2096, 1621, 2106, 1621, 1912, 1874, 1621, 1874,
 /*   190 */  1871, 1621, 1621, 1874, 1871, 1871, 1750, 1621, 1621, 1621,
 /*   200 */  1621, 1621, 1621, 1699, 1621, 1699, 1621, 1621, 1699, 1621,
 /*   210 */  1699, 1699, 1699, 1621, 1699, 1678, 1678, 1621, 1621, 1621,
 /*   220 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   230 */  1621, 1621, 1621, 1934, 1925, 1621, 1697, 1921, 1621, 1697,
 /*   240 */  1621, 1621, 1621, 1621, 2123, 2121, 1621, 2123, 2121, 1621,
 /*   250 */  1621, 1621, 2135, 2131, 2123, 2139, 2137, 2108, 2106, 2169,
 /*   260 */  2156, 2152, 2093, 1621, 1621, 1621, 1621, 1697, 1697, 2121,
 /*   270 */  1621, 1621, 1621, 1621, 1621, 2121, 1621, 1621, 1697, 1621,
 /*   280 */  1697, 1621, 1621, 1775, 1621, 1621, 1621, 1697, 1653, 1621,
 /*   290 */  1914, 1927, 1897, 1897, 1809, 1809, 1809, 1700, 1626, 1621,
 /*   300 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   310 */  1621, 2134, 2133, 2002, 1621, 2051, 2050, 2049, 2040, 2001,
 /*   320 */  1771, 1621, 2000, 1999, 1621, 1621, 1621, 1621, 1621, 1888,
 /*   330 */  1887, 1993, 1621, 1621, 1994, 1992, 1991, 1621, 1621, 1621,
 /*   340 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   350 */  1621, 1621, 1621, 1621, 1621, 2153, 2157, 1621, 1621, 1621,
 /*   360 */  1621, 1621, 1621, 1621, 2076, 1621, 1621, 1621, 1621, 1621,
 /*   370 */  1976, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   380 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   390 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   400 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   410 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   420 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   430 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   440 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   450 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   460 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1658,
 /*   470 */  1981, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   480 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   490 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   500 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   510 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1738, 1737, 1621,
 /*   520 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   530 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   540 */  1621, 1984, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   550 */  1621, 1621, 1621, 1621, 1621, 2149, 2109, 1621, 1621, 1621,
 /*   560 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   570 */  1621, 1621, 1621, 1621, 1976, 1621, 2132, 1621, 1621, 2147,
 /*   580 */  1621, 2151, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 2086,
 /*   590 */  2082, 1621, 1621, 2078, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   600 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   610 */  1621, 1621, 1621, 1975, 1621, 2037, 1621, 1621, 1621, 2071,
 /*   620 */  1621, 1621, 2022, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   630 */  1621, 1621, 1984, 1621, 1987, 1621, 1621, 1621, 1621, 1621,
 /*   640 */  1803, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   650 */  1621, 1621, 1621, 1788, 1786, 1785, 1784, 1621, 1781, 1621,
 /*   660 */  1816, 1621, 1621, 1621, 1812, 1811, 1621, 1621, 1621, 1621,
 /*   670 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   680 */  1621, 1718, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   690 */  1710, 1621, 1709, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   700 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   710 */  1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621, 1621,
 /*   720 */  1621, 1621, 1621, 1621, 1621,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*     ENABLE => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*    SYSINFO => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*  SUBSCRIBE => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      FORCE => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*      FLUSH => nothing */
    0,  /*       TRIM => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /* CACHEMODEL => nothing */
    0,  /*  CACHESIZE => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /* TSDB_PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*  WAL_LEVEL => nothing */
    0,  /* WAL_FSYNC_PERIOD => nothing */
    0,  /* WAL_RETENTION_PERIOD => nothing */
    0,  /* WAL_RETENTION_SIZE => nothing */
    0,  /* WAL_ROLL_PERIOD => nothing */
    0,  /* WAL_SEGMENT_SIZE => nothing */
    0,  /* STT_TRIGGER => nothing */
    0,  /* TABLE_PREFIX => nothing */
    0,  /* TABLE_SUFFIX => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*  MAX_SPEED => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /* DELETE_MARK => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /* PRIVILEGES => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*   LICENCES => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /* DISTRIBUTED => nothing */
    0,  /*  CONSUMERS => nothing */
    0,  /* SUBSCRIPTIONS => nothing */
    0,  /*     VNODES => nothing */
    0,  /*       LIKE => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*      QTAGS => nothing */
    0,  /*         AS => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*       WITH => nothing */
    0,  /*       META => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*     IGNORE => nothing */
    0,  /*    EXPIRED => nothing */
    0,  /* FILL_HISTORY => nothing */
    0,  /*   SUBTABLE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     DELETE => nothing */
    0,  /*     INSERT => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     QSTART => nothing */
    0,  /*       QEND => nothing */
    0,  /*  QDURATION => nothing */
    0,  /*     WSTART => nothing */
    0,  /*       WEND => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*     IROWTS => nothing */
    0,  /*   ISFILLED => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /* CLIENT_VERSION => nothing */
    0,  /* SERVER_VERSION => nothing */
    0,  /* SERVER_STATUS => nothing */
    0,  /* CURRENT_USER => nothing */
    0,  /*       CASE => nothing */
  271,  /*        END => ABORT */
    0,  /*       WHEN => nothing */
    0,  /*       THEN => nothing */
    0,  /*       ELSE => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*         IN => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /* EVENT_WINDOW => nothing */
    0,  /*      START => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      RANGE => nothing */
    0,  /*      EVERY => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*      ABORT => nothing */
  271,  /*      AFTER => ABORT */
  271,  /*     ATTACH => ABORT */
  271,  /*     BEFORE => ABORT */
  271,  /*      BEGIN => ABORT */
  271,  /*     BITAND => ABORT */
  271,  /*     BITNOT => ABORT */
  271,  /*      BITOR => ABORT */
  271,  /*     BLOCKS => ABORT */
  271,  /*     CHANGE => ABORT */
  271,  /*      COMMA => ABORT */
  271,  /*    COMPACT => ABORT */
  271,  /*     CONCAT => ABORT */
  271,  /*   CONFLICT => ABORT */
  271,  /*       COPY => ABORT */
  271,  /*   DEFERRED => ABORT */
  271,  /* DELIMITERS => ABORT */
  271,  /*     DETACH => ABORT */
  271,  /*     DIVIDE => ABORT */
  271,  /*        DOT => ABORT */
  271,  /*       EACH => ABORT */
  271,  /*       FAIL => ABORT */
  271,  /*       FILE => ABORT */
  271,  /*        FOR => ABORT */
  271,  /*       GLOB => ABORT */
  271,  /*         ID => ABORT */
  271,  /*  IMMEDIATE => ABORT */
  271,  /*     IMPORT => ABORT */
  271,  /*  INITIALLY => ABORT */
  271,  /*    INSTEAD => ABORT */
  271,  /*     ISNULL => ABORT */
  271,  /*        KEY => ABORT */
  271,  /*    MODULES => ABORT */
  271,  /*  NK_BITNOT => ABORT */
  271,  /*    NK_SEMI => ABORT */
  271,  /*    NOTNULL => ABORT */
  271,  /*         OF => ABORT */
  271,  /*       PLUS => ABORT */
  271,  /*  PRIVILEGE => ABORT */
  271,  /*      RAISE => ABORT */
  271,  /*    REPLACE => ABORT */
  271,  /*   RESTRICT => ABORT */
  271,  /*        ROW => ABORT */
  271,  /*       SEMI => ABORT */
  271,  /*       STAR => ABORT */
  271,  /*  STATEMENT => ABORT */
  271,  /*     STRICT => ABORT */
  271,  /*     STRING => ABORT */
  271,  /*      TIMES => ABORT */
  271,  /*     UPDATE => ABORT */
  271,  /*     VALUES => ABORT */
  271,  /*   VARIABLE => ABORT */
  271,  /*       VIEW => ABORT */
  271,  /*        WAL => ABORT */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "ENABLE",
  /*   35 */ "NK_INTEGER",
  /*   36 */ "SYSINFO",
  /*   37 */ "DROP",
  /*   38 */ "GRANT",
  /*   39 */ "ON",
  /*   40 */ "TO",
  /*   41 */ "REVOKE",
  /*   42 */ "FROM",
  /*   43 */ "SUBSCRIBE",
  /*   44 */ "NK_COMMA",
  /*   45 */ "READ",
  /*   46 */ "WRITE",
  /*   47 */ "NK_DOT",
  /*   48 */ "DNODE",
  /*   49 */ "PORT",
  /*   50 */ "DNODES",
  /*   51 */ "NK_IPTOKEN",
  /*   52 */ "FORCE",
  /*   53 */ "LOCAL",
  /*   54 */ "QNODE",
  /*   55 */ "BNODE",
  /*   56 */ "SNODE",
  /*   57 */ "MNODE",
  /*   58 */ "DATABASE",
  /*   59 */ "USE",
  /*   60 */ "FLUSH",
  /*   61 */ "TRIM",
  /*   62 */ "IF",
  /*   63 */ "NOT",
  /*   64 */ "EXISTS",
  /*   65 */ "BUFFER",
  /*   66 */ "CACHEMODEL",
  /*   67 */ "CACHESIZE",
  /*   68 */ "COMP",
  /*   69 */ "DURATION",
  /*   70 */ "NK_VARIABLE",
  /*   71 */ "MAXROWS",
  /*   72 */ "MINROWS",
  /*   73 */ "KEEP",
  /*   74 */ "PAGES",
  /*   75 */ "PAGESIZE",
  /*   76 */ "TSDB_PAGESIZE",
  /*   77 */ "PRECISION",
  /*   78 */ "REPLICA",
  /*   79 */ "VGROUPS",
  /*   80 */ "SINGLE_STABLE",
  /*   81 */ "RETENTIONS",
  /*   82 */ "SCHEMALESS",
  /*   83 */ "WAL_LEVEL",
  /*   84 */ "WAL_FSYNC_PERIOD",
  /*   85 */ "WAL_RETENTION_PERIOD",
  /*   86 */ "WAL_RETENTION_SIZE",
  /*   87 */ "WAL_ROLL_PERIOD",
  /*   88 */ "WAL_SEGMENT_SIZE",
  /*   89 */ "STT_TRIGGER",
  /*   90 */ "TABLE_PREFIX",
  /*   91 */ "TABLE_SUFFIX",
  /*   92 */ "NK_COLON",
  /*   93 */ "MAX_SPEED",
  /*   94 */ "TABLE",
  /*   95 */ "NK_LP",
  /*   96 */ "NK_RP",
  /*   97 */ "STABLE",
  /*   98 */ "ADD",
  /*   99 */ "COLUMN",
  /*  100 */ "MODIFY",
  /*  101 */ "RENAME",
  /*  102 */ "TAG",
  /*  103 */ "SET",
  /*  104 */ "NK_EQ",
  /*  105 */ "USING",
  /*  106 */ "TAGS",
  /*  107 */ "COMMENT",
  /*  108 */ "BOOL",
  /*  109 */ "TINYINT",
  /*  110 */ "SMALLINT",
  /*  111 */ "INT",
  /*  112 */ "INTEGER",
  /*  113 */ "BIGINT",
  /*  114 */ "FLOAT",
  /*  115 */ "DOUBLE",
  /*  116 */ "BINARY",
  /*  117 */ "TIMESTAMP",
  /*  118 */ "NCHAR",
  /*  119 */ "UNSIGNED",
  /*  120 */ "JSON",
  /*  121 */ "VARCHAR",
  /*  122 */ "MEDIUMBLOB",
  /*  123 */ "BLOB",
  /*  124 */ "VARBINARY",
  /*  125 */ "DECIMAL",
  /*  126 */ "MAX_DELAY",
  /*  127 */ "WATERMARK",
  /*  128 */ "ROLLUP",
  /*  129 */ "TTL",
  /*  130 */ "SMA",
  /*  131 */ "DELETE_MARK",
  /*  132 */ "FIRST",
  /*  133 */ "LAST",
  /*  134 */ "SHOW",
  /*  135 */ "PRIVILEGES",
  /*  136 */ "DATABASES",
  /*  137 */ "TABLES",
  /*  138 */ "STABLES",
  /*  139 */ "MNODES",
  /*  140 */ "QNODES",
  /*  141 */ "FUNCTIONS",
  /*  142 */ "INDEXES",
  /*  143 */ "ACCOUNTS",
  /*  144 */ "APPS",
  /*  145 */ "CONNECTIONS",
  /*  146 */ "LICENCES",
  /*  147 */ "GRANTS",
  /*  148 */ "QUERIES",
  /*  149 */ "SCORES",
  /*  150 */ "TOPICS",
  /*  151 */ "VARIABLES",
  /*  152 */ "CLUSTER",
  /*  153 */ "BNODES",
  /*  154 */ "SNODES",
  /*  155 */ "TRANSACTIONS",
  /*  156 */ "DISTRIBUTED",
  /*  157 */ "CONSUMERS",
  /*  158 */ "SUBSCRIPTIONS",
  /*  159 */ "VNODES",
  /*  160 */ "LIKE",
  /*  161 */ "TBNAME",
  /*  162 */ "QTAGS",
  /*  163 */ "AS",
  /*  164 */ "INDEX",
  /*  165 */ "FUNCTION",
  /*  166 */ "INTERVAL",
  /*  167 */ "COUNT",
  /*  168 */ "LAST_ROW",
  /*  169 */ "TOPIC",
  /*  170 */ "WITH",
  /*  171 */ "META",
  /*  172 */ "CONSUMER",
  /*  173 */ "GROUP",
  /*  174 */ "DESC",
  /*  175 */ "DESCRIBE",
  /*  176 */ "RESET",
  /*  177 */ "QUERY",
  /*  178 */ "CACHE",
  /*  179 */ "EXPLAIN",
  /*  180 */ "ANALYZE",
  /*  181 */ "VERBOSE",
  /*  182 */ "NK_BOOL",
  /*  183 */ "RATIO",
  /*  184 */ "NK_FLOAT",
  /*  185 */ "OUTPUTTYPE",
  /*  186 */ "AGGREGATE",
  /*  187 */ "BUFSIZE",
  /*  188 */ "STREAM",
  /*  189 */ "INTO",
  /*  190 */ "TRIGGER",
  /*  191 */ "AT_ONCE",
  /*  192 */ "WINDOW_CLOSE",
  /*  193 */ "IGNORE",
  /*  194 */ "EXPIRED",
  /*  195 */ "FILL_HISTORY",
  /*  196 */ "SUBTABLE",
  /*  197 */ "KILL",
  /*  198 */ "CONNECTION",
  /*  199 */ "TRANSACTION",
  /*  200 */ "BALANCE",
  /*  201 */ "VGROUP",
  /*  202 */ "MERGE",
  /*  203 */ "REDISTRIBUTE",
  /*  204 */ "SPLIT",
  /*  205 */ "DELETE",
  /*  206 */ "INSERT",
  /*  207 */ "NULL",
  /*  208 */ "NK_QUESTION",
  /*  209 */ "NK_ARROW",
  /*  210 */ "ROWTS",
  /*  211 */ "QSTART",
  /*  212 */ "QEND",
  /*  213 */ "QDURATION",
  /*  214 */ "WSTART",
  /*  215 */ "WEND",
  /*  216 */ "WDURATION",
  /*  217 */ "IROWTS",
  /*  218 */ "ISFILLED",
  /*  219 */ "CAST",
  /*  220 */ "NOW",
  /*  221 */ "TODAY",
  /*  222 */ "TIMEZONE",
  /*  223 */ "CLIENT_VERSION",
  /*  224 */ "SERVER_VERSION",
  /*  225 */ "SERVER_STATUS",
  /*  226 */ "CURRENT_USER",
  /*  227 */ "CASE",
  /*  228 */ "END",
  /*  229 */ "WHEN",
  /*  230 */ "THEN",
  /*  231 */ "ELSE",
  /*  232 */ "BETWEEN",
  /*  233 */ "IS",
  /*  234 */ "NK_LT",
  /*  235 */ "NK_GT",
  /*  236 */ "NK_LE",
  /*  237 */ "NK_GE",
  /*  238 */ "NK_NE",
  /*  239 */ "MATCH",
  /*  240 */ "NMATCH",
  /*  241 */ "CONTAINS",
  /*  242 */ "IN",
  /*  243 */ "JOIN",
  /*  244 */ "INNER",
  /*  245 */ "SELECT",
  /*  246 */ "DISTINCT",
  /*  247 */ "WHERE",
  /*  248 */ "PARTITION",
  /*  249 */ "BY",
  /*  250 */ "SESSION",
  /*  251 */ "STATE_WINDOW",
  /*  252 */ "EVENT_WINDOW",
  /*  253 */ "START",
  /*  254 */ "SLIDING",
  /*  255 */ "FILL",
  /*  256 */ "VALUE",
  /*  257 */ "NONE",
  /*  258 */ "PREV",
  /*  259 */ "LINEAR",
  /*  260 */ "NEXT",
  /*  261 */ "HAVING",
  /*  262 */ "RANGE",
  /*  263 */ "EVERY",
  /*  264 */ "ORDER",
  /*  265 */ "SLIMIT",
  /*  266 */ "SOFFSET",
  /*  267 */ "LIMIT",
  /*  268 */ "OFFSET",
  /*  269 */ "ASC",
  /*  270 */ "NULLS",
  /*  271 */ "ABORT",
  /*  272 */ "AFTER",
  /*  273 */ "ATTACH",
  /*  274 */ "BEFORE",
  /*  275 */ "BEGIN",
  /*  276 */ "BITAND",
  /*  277 */ "BITNOT",
  /*  278 */ "BITOR",
  /*  279 */ "BLOCKS",
  /*  280 */ "CHANGE",
  /*  281 */ "COMMA",
  /*  282 */ "COMPACT",
  /*  283 */ "CONCAT",
  /*  284 */ "CONFLICT",
  /*  285 */ "COPY",
  /*  286 */ "DEFERRED",
  /*  287 */ "DELIMITERS",
  /*  288 */ "DETACH",
  /*  289 */ "DIVIDE",
  /*  290 */ "DOT",
  /*  291 */ "EACH",
  /*  292 */ "FAIL",
  /*  293 */ "FILE",
  /*  294 */ "FOR",
  /*  295 */ "GLOB",
  /*  296 */ "ID",
  /*  297 */ "IMMEDIATE",
  /*  298 */ "IMPORT",
  /*  299 */ "INITIALLY",
  /*  300 */ "INSTEAD",
  /*  301 */ "ISNULL",
  /*  302 */ "KEY",
  /*  303 */ "MODULES",
  /*  304 */ "NK_BITNOT",
  /*  305 */ "NK_SEMI",
  /*  306 */ "NOTNULL",
  /*  307 */ "OF",
  /*  308 */ "PLUS",
  /*  309 */ "PRIVILEGE",
  /*  310 */ "RAISE",
  /*  311 */ "REPLACE",
  /*  312 */ "RESTRICT",
  /*  313 */ "ROW",
  /*  314 */ "SEMI",
  /*  315 */ "STAR",
  /*  316 */ "STATEMENT",
  /*  317 */ "STRICT",
  /*  318 */ "STRING",
  /*  319 */ "TIMES",
  /*  320 */ "UPDATE",
  /*  321 */ "VALUES",
  /*  322 */ "VARIABLE",
  /*  323 */ "VIEW",
  /*  324 */ "WAL",
  /*  325 */ "cmd",
  /*  326 */ "account_options",
  /*  327 */ "alter_account_options",
  /*  328 */ "literal",
  /*  329 */ "alter_account_option",
  /*  330 */ "user_name",
  /*  331 */ "sysinfo_opt",
  /*  332 */ "privileges",
  /*  333 */ "priv_level",
  /*  334 */ "priv_type_list",
  /*  335 */ "priv_type",
  /*  336 */ "db_name",
  /*  337 */ "topic_name",
  /*  338 */ "dnode_endpoint",
  /*  339 */ "force_opt",
  /*  340 */ "not_exists_opt",
  /*  341 */ "db_options",
  /*  342 */ "exists_opt",
  /*  343 */ "alter_db_options",
  /*  344 */ "speed_opt",
  /*  345 */ "integer_list",
  /*  346 */ "variable_list",
  /*  347 */ "retention_list",
  /*  348 */ "alter_db_option",
  /*  349 */ "retention",
  /*  350 */ "full_table_name",
  /*  351 */ "column_def_list",
  /*  352 */ "tags_def_opt",
  /*  353 */ "table_options",
  /*  354 */ "multi_create_clause",
  /*  355 */ "tags_def",
  /*  356 */ "multi_drop_clause",
  /*  357 */ "alter_table_clause",
  /*  358 */ "alter_table_options",
  /*  359 */ "column_name",
  /*  360 */ "type_name",
  /*  361 */ "signed_literal",
  /*  362 */ "create_subtable_clause",
  /*  363 */ "specific_cols_opt",
  /*  364 */ "expression_list",
  /*  365 */ "drop_table_clause",
  /*  366 */ "col_name_list",
  /*  367 */ "table_name",
  /*  368 */ "column_def",
  /*  369 */ "duration_list",
  /*  370 */ "rollup_func_list",
  /*  371 */ "alter_table_option",
  /*  372 */ "duration_literal",
  /*  373 */ "rollup_func_name",
  /*  374 */ "function_name",
  /*  375 */ "col_name",
  /*  376 */ "db_name_cond_opt",
  /*  377 */ "like_pattern_opt",
  /*  378 */ "table_name_cond",
  /*  379 */ "from_db_opt",
  /*  380 */ "tag_list_opt",
  /*  381 */ "tag_item",
  /*  382 */ "column_alias",
  /*  383 */ "index_options",
  /*  384 */ "func_list",
  /*  385 */ "sliding_opt",
  /*  386 */ "sma_stream_opt",
  /*  387 */ "func",
  /*  388 */ "sma_func_name",
  /*  389 */ "query_or_subquery",
  /*  390 */ "cgroup_name",
  /*  391 */ "analyze_opt",
  /*  392 */ "explain_options",
  /*  393 */ "agg_func_opt",
  /*  394 */ "bufsize_opt",
  /*  395 */ "stream_name",
  /*  396 */ "stream_options",
  /*  397 */ "col_list_opt",
  /*  398 */ "subtable_opt",
  /*  399 */ "expression",
  /*  400 */ "dnode_list",
  /*  401 */ "where_clause_opt",
  /*  402 */ "signed",
  /*  403 */ "literal_func",
  /*  404 */ "literal_list",
  /*  405 */ "table_alias",
  /*  406 */ "expr_or_subquery",
  /*  407 */ "pseudo_column",
  /*  408 */ "column_reference",
  /*  409 */ "function_expression",
  /*  410 */ "case_when_expression",
  /*  411 */ "star_func",
  /*  412 */ "star_func_para_list",
  /*  413 */ "noarg_func",
  /*  414 */ "other_para_list",
  /*  415 */ "star_func_para",
  /*  416 */ "when_then_list",
  /*  417 */ "case_when_else_opt",
  /*  418 */ "common_expression",
  /*  419 */ "when_then_expr",
  /*  420 */ "predicate",
  /*  421 */ "compare_op",
  /*  422 */ "in_op",
  /*  423 */ "in_predicate_value",
  /*  424 */ "boolean_value_expression",
  /*  425 */ "boolean_primary",
  /*  426 */ "from_clause_opt",
  /*  427 */ "table_reference_list",
  /*  428 */ "table_reference",
  /*  429 */ "table_primary",
  /*  430 */ "joined_table",
  /*  431 */ "alias_opt",
  /*  432 */ "subquery",
  /*  433 */ "parenthesized_joined_table",
  /*  434 */ "join_type",
  /*  435 */ "search_condition",
  /*  436 */ "query_specification",
  /*  437 */ "set_quantifier_opt",
  /*  438 */ "select_list",
  /*  439 */ "partition_by_clause_opt",
  /*  440 */ "range_opt",
  /*  441 */ "every_opt",
  /*  442 */ "fill_opt",
  /*  443 */ "twindow_clause_opt",
  /*  444 */ "group_by_clause_opt",
  /*  445 */ "having_clause_opt",
  /*  446 */ "select_item",
  /*  447 */ "partition_list",
  /*  448 */ "partition_item",
  /*  449 */ "fill_mode",
  /*  450 */ "group_by_list",
  /*  451 */ "query_expression",
  /*  452 */ "query_simple",
  /*  453 */ "order_by_clause_opt",
  /*  454 */ "slimit_clause_opt",
  /*  455 */ "limit_clause_opt",
  /*  456 */ "union_query_expression",
  /*  457 */ "query_simple_or_subquery",
  /*  458 */ "sort_specification_list",
  /*  459 */ "sort_specification",
  /*  460 */ "ordering_specification_opt",
  /*  461 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name ENABLE NK_INTEGER",
 /*  27 */ "cmd ::= ALTER USER user_name SYSINFO NK_INTEGER",
 /*  28 */ "cmd ::= DROP USER user_name",
 /*  29 */ "sysinfo_opt ::=",
 /*  30 */ "sysinfo_opt ::= SYSINFO NK_INTEGER",
 /*  31 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  32 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  33 */ "privileges ::= ALL",
 /*  34 */ "privileges ::= priv_type_list",
 /*  35 */ "privileges ::= SUBSCRIBE",
 /*  36 */ "priv_type_list ::= priv_type",
 /*  37 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  38 */ "priv_type ::= READ",
 /*  39 */ "priv_type ::= WRITE",
 /*  40 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  41 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  42 */ "priv_level ::= topic_name",
 /*  43 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  44 */ "cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER",
 /*  45 */ "cmd ::= DROP DNODE NK_INTEGER force_opt",
 /*  46 */ "cmd ::= DROP DNODE dnode_endpoint force_opt",
 /*  47 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  48 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  49 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  50 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  51 */ "dnode_endpoint ::= NK_STRING",
 /*  52 */ "dnode_endpoint ::= NK_ID",
 /*  53 */ "dnode_endpoint ::= NK_IPTOKEN",
 /*  54 */ "force_opt ::=",
 /*  55 */ "force_opt ::= FORCE",
 /*  56 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  57 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  58 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  60 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  61 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  62 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  63 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  64 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  65 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  66 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  67 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  68 */ "cmd ::= USE db_name",
 /*  69 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  70 */ "cmd ::= FLUSH DATABASE db_name",
 /*  71 */ "cmd ::= TRIM DATABASE db_name speed_opt",
 /*  72 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  73 */ "not_exists_opt ::=",
 /*  74 */ "exists_opt ::= IF EXISTS",
 /*  75 */ "exists_opt ::=",
 /*  76 */ "db_options ::=",
 /*  77 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  78 */ "db_options ::= db_options CACHEMODEL NK_STRING",
 /*  79 */ "db_options ::= db_options CACHESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  81 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  82 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  83 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  84 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  85 */ "db_options ::= db_options KEEP integer_list",
 /*  86 */ "db_options ::= db_options KEEP variable_list",
 /*  87 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  88 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  89 */ "db_options ::= db_options TSDB_PAGESIZE NK_INTEGER",
 /*  90 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  91 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  92 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  93 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  94 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  95 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  96 */ "db_options ::= db_options WAL_LEVEL NK_INTEGER",
 /*  97 */ "db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER",
 /*  98 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER",
 /*  99 */ "db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER",
 /* 100 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER",
 /* 101 */ "db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER",
 /* 102 */ "db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER",
 /* 103 */ "db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER",
 /* 104 */ "db_options ::= db_options STT_TRIGGER NK_INTEGER",
 /* 105 */ "db_options ::= db_options TABLE_PREFIX NK_INTEGER",
 /* 106 */ "db_options ::= db_options TABLE_SUFFIX NK_INTEGER",
 /* 107 */ "alter_db_options ::= alter_db_option",
 /* 108 */ "alter_db_options ::= alter_db_options alter_db_option",
 /* 109 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /* 110 */ "alter_db_option ::= CACHEMODEL NK_STRING",
 /* 111 */ "alter_db_option ::= CACHESIZE NK_INTEGER",
 /* 112 */ "alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER",
 /* 113 */ "alter_db_option ::= KEEP integer_list",
 /* 114 */ "alter_db_option ::= KEEP variable_list",
 /* 115 */ "alter_db_option ::= PAGES NK_INTEGER",
 /* 116 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /* 117 */ "alter_db_option ::= WAL_LEVEL NK_INTEGER",
 /* 118 */ "alter_db_option ::= STT_TRIGGER NK_INTEGER",
 /* 119 */ "integer_list ::= NK_INTEGER",
 /* 120 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 121 */ "variable_list ::= NK_VARIABLE",
 /* 122 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 123 */ "retention_list ::= retention",
 /* 124 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 125 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 126 */ "speed_opt ::=",
 /* 127 */ "speed_opt ::= MAX_SPEED NK_INTEGER",
 /* 128 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 129 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 130 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 131 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 132 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 133 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 134 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 135 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 136 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 137 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 138 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 139 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 140 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 141 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 142 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 143 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 144 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 145 */ "multi_create_clause ::= create_subtable_clause",
 /* 146 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 147 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options",
 /* 148 */ "multi_drop_clause ::= drop_table_clause",
 /* 149 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 150 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 151 */ "specific_cols_opt ::=",
 /* 152 */ "specific_cols_opt ::= NK_LP col_name_list NK_RP",
 /* 153 */ "full_table_name ::= table_name",
 /* 154 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 155 */ "column_def_list ::= column_def",
 /* 156 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 157 */ "column_def ::= column_name type_name",
 /* 158 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 159 */ "type_name ::= BOOL",
 /* 160 */ "type_name ::= TINYINT",
 /* 161 */ "type_name ::= SMALLINT",
 /* 162 */ "type_name ::= INT",
 /* 163 */ "type_name ::= INTEGER",
 /* 164 */ "type_name ::= BIGINT",
 /* 165 */ "type_name ::= FLOAT",
 /* 166 */ "type_name ::= DOUBLE",
 /* 167 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 168 */ "type_name ::= TIMESTAMP",
 /* 169 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 170 */ "type_name ::= TINYINT UNSIGNED",
 /* 171 */ "type_name ::= SMALLINT UNSIGNED",
 /* 172 */ "type_name ::= INT UNSIGNED",
 /* 173 */ "type_name ::= BIGINT UNSIGNED",
 /* 174 */ "type_name ::= JSON",
 /* 175 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 176 */ "type_name ::= MEDIUMBLOB",
 /* 177 */ "type_name ::= BLOB",
 /* 178 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 179 */ "type_name ::= DECIMAL",
 /* 180 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 181 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 182 */ "tags_def_opt ::=",
 /* 183 */ "tags_def_opt ::= tags_def",
 /* 184 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 185 */ "table_options ::=",
 /* 186 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 187 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 188 */ "table_options ::= table_options WATERMARK duration_list",
 /* 189 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 190 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 191 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 192 */ "table_options ::= table_options DELETE_MARK duration_list",
 /* 193 */ "alter_table_options ::= alter_table_option",
 /* 194 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 195 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 196 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 197 */ "duration_list ::= duration_literal",
 /* 198 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 199 */ "rollup_func_list ::= rollup_func_name",
 /* 200 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 201 */ "rollup_func_name ::= function_name",
 /* 202 */ "rollup_func_name ::= FIRST",
 /* 203 */ "rollup_func_name ::= LAST",
 /* 204 */ "col_name_list ::= col_name",
 /* 205 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 206 */ "col_name ::= column_name",
 /* 207 */ "cmd ::= SHOW DNODES",
 /* 208 */ "cmd ::= SHOW USERS",
 /* 209 */ "cmd ::= SHOW USER PRIVILEGES",
 /* 210 */ "cmd ::= SHOW DATABASES",
 /* 211 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 212 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 213 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 214 */ "cmd ::= SHOW MNODES",
 /* 215 */ "cmd ::= SHOW QNODES",
 /* 216 */ "cmd ::= SHOW FUNCTIONS",
 /* 217 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 218 */ "cmd ::= SHOW STREAMS",
 /* 219 */ "cmd ::= SHOW ACCOUNTS",
 /* 220 */ "cmd ::= SHOW APPS",
 /* 221 */ "cmd ::= SHOW CONNECTIONS",
 /* 222 */ "cmd ::= SHOW LICENCES",
 /* 223 */ "cmd ::= SHOW GRANTS",
 /* 224 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 225 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 226 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 227 */ "cmd ::= SHOW QUERIES",
 /* 228 */ "cmd ::= SHOW SCORES",
 /* 229 */ "cmd ::= SHOW TOPICS",
 /* 230 */ "cmd ::= SHOW VARIABLES",
 /* 231 */ "cmd ::= SHOW CLUSTER VARIABLES",
 /* 232 */ "cmd ::= SHOW LOCAL VARIABLES",
 /* 233 */ "cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt",
 /* 234 */ "cmd ::= SHOW BNODES",
 /* 235 */ "cmd ::= SHOW SNODES",
 /* 236 */ "cmd ::= SHOW CLUSTER",
 /* 237 */ "cmd ::= SHOW TRANSACTIONS",
 /* 238 */ "cmd ::= SHOW TABLE DISTRIBUTED full_table_name",
 /* 239 */ "cmd ::= SHOW CONSUMERS",
 /* 240 */ "cmd ::= SHOW SUBSCRIPTIONS",
 /* 241 */ "cmd ::= SHOW TAGS FROM table_name_cond from_db_opt",
 /* 242 */ "cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt",
 /* 243 */ "cmd ::= SHOW VNODES NK_INTEGER",
 /* 244 */ "cmd ::= SHOW VNODES NK_STRING",
 /* 245 */ "db_name_cond_opt ::=",
 /* 246 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 247 */ "like_pattern_opt ::=",
 /* 248 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 249 */ "table_name_cond ::= table_name",
 /* 250 */ "from_db_opt ::=",
 /* 251 */ "from_db_opt ::= FROM db_name",
 /* 252 */ "tag_list_opt ::=",
 /* 253 */ "tag_list_opt ::= tag_item",
 /* 254 */ "tag_list_opt ::= tag_list_opt NK_COMMA tag_item",
 /* 255 */ "tag_item ::= TBNAME",
 /* 256 */ "tag_item ::= QTAGS",
 /* 257 */ "tag_item ::= column_name",
 /* 258 */ "tag_item ::= column_name column_alias",
 /* 259 */ "tag_item ::= column_name AS column_alias",
 /* 260 */ "cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options",
 /* 261 */ "cmd ::= CREATE INDEX not_exists_opt full_table_name ON full_table_name NK_LP col_name_list NK_RP",
 /* 262 */ "cmd ::= DROP INDEX exists_opt full_table_name",
 /* 263 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 264 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt",
 /* 265 */ "func_list ::= func",
 /* 266 */ "func_list ::= func_list NK_COMMA func",
 /* 267 */ "func ::= sma_func_name NK_LP expression_list NK_RP",
 /* 268 */ "sma_func_name ::= function_name",
 /* 269 */ "sma_func_name ::= COUNT",
 /* 270 */ "sma_func_name ::= FIRST",
 /* 271 */ "sma_func_name ::= LAST",
 /* 272 */ "sma_func_name ::= LAST_ROW",
 /* 273 */ "sma_stream_opt ::=",
 /* 274 */ "sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal",
 /* 275 */ "sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal",
 /* 276 */ "sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal",
 /* 277 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery",
 /* 278 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 279 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name",
 /* 280 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 281 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name",
 /* 282 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 283 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 284 */ "cmd ::= DESC full_table_name",
 /* 285 */ "cmd ::= DESCRIBE full_table_name",
 /* 286 */ "cmd ::= RESET QUERY CACHE",
 /* 287 */ "cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery",
 /* 288 */ "analyze_opt ::=",
 /* 289 */ "analyze_opt ::= ANALYZE",
 /* 290 */ "explain_options ::=",
 /* 291 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 292 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 293 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 294 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 295 */ "agg_func_opt ::=",
 /* 296 */ "agg_func_opt ::= AGGREGATE",
 /* 297 */ "bufsize_opt ::=",
 /* 298 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 299 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tags_def_opt subtable_opt AS query_or_subquery",
 /* 300 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 301 */ "col_list_opt ::=",
 /* 302 */ "col_list_opt ::= NK_LP col_name_list NK_RP",
 /* 303 */ "stream_options ::=",
 /* 304 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 305 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 306 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 307 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 308 */ "stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER",
 /* 309 */ "stream_options ::= stream_options FILL_HISTORY NK_INTEGER",
 /* 310 */ "subtable_opt ::=",
 /* 311 */ "subtable_opt ::= SUBTABLE NK_LP expression NK_RP",
 /* 312 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 313 */ "cmd ::= KILL QUERY NK_STRING",
 /* 314 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 315 */ "cmd ::= BALANCE VGROUP",
 /* 316 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 317 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 318 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 319 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 320 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 321 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 322 */ "cmd ::= query_or_subquery",
 /* 323 */ "cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery",
 /* 324 */ "cmd ::= INSERT INTO full_table_name query_or_subquery",
 /* 325 */ "literal ::= NK_INTEGER",
 /* 326 */ "literal ::= NK_FLOAT",
 /* 327 */ "literal ::= NK_STRING",
 /* 328 */ "literal ::= NK_BOOL",
 /* 329 */ "literal ::= TIMESTAMP NK_STRING",
 /* 330 */ "literal ::= duration_literal",
 /* 331 */ "literal ::= NULL",
 /* 332 */ "literal ::= NK_QUESTION",
 /* 333 */ "duration_literal ::= NK_VARIABLE",
 /* 334 */ "signed ::= NK_INTEGER",
 /* 335 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 336 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 337 */ "signed ::= NK_FLOAT",
 /* 338 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 339 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 340 */ "signed_literal ::= signed",
 /* 341 */ "signed_literal ::= NK_STRING",
 /* 342 */ "signed_literal ::= NK_BOOL",
 /* 343 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 344 */ "signed_literal ::= duration_literal",
 /* 345 */ "signed_literal ::= NULL",
 /* 346 */ "signed_literal ::= literal_func",
 /* 347 */ "signed_literal ::= NK_QUESTION",
 /* 348 */ "literal_list ::= signed_literal",
 /* 349 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 350 */ "db_name ::= NK_ID",
 /* 351 */ "table_name ::= NK_ID",
 /* 352 */ "column_name ::= NK_ID",
 /* 353 */ "function_name ::= NK_ID",
 /* 354 */ "table_alias ::= NK_ID",
 /* 355 */ "column_alias ::= NK_ID",
 /* 356 */ "user_name ::= NK_ID",
 /* 357 */ "topic_name ::= NK_ID",
 /* 358 */ "stream_name ::= NK_ID",
 /* 359 */ "cgroup_name ::= NK_ID",
 /* 360 */ "expr_or_subquery ::= expression",
 /* 361 */ "expression ::= literal",
 /* 362 */ "expression ::= pseudo_column",
 /* 363 */ "expression ::= column_reference",
 /* 364 */ "expression ::= function_expression",
 /* 365 */ "expression ::= case_when_expression",
 /* 366 */ "expression ::= NK_LP expression NK_RP",
 /* 367 */ "expression ::= NK_PLUS expr_or_subquery",
 /* 368 */ "expression ::= NK_MINUS expr_or_subquery",
 /* 369 */ "expression ::= expr_or_subquery NK_PLUS expr_or_subquery",
 /* 370 */ "expression ::= expr_or_subquery NK_MINUS expr_or_subquery",
 /* 371 */ "expression ::= expr_or_subquery NK_STAR expr_or_subquery",
 /* 372 */ "expression ::= expr_or_subquery NK_SLASH expr_or_subquery",
 /* 373 */ "expression ::= expr_or_subquery NK_REM expr_or_subquery",
 /* 374 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 375 */ "expression ::= expr_or_subquery NK_BITAND expr_or_subquery",
 /* 376 */ "expression ::= expr_or_subquery NK_BITOR expr_or_subquery",
 /* 377 */ "expression_list ::= expr_or_subquery",
 /* 378 */ "expression_list ::= expression_list NK_COMMA expr_or_subquery",
 /* 379 */ "column_reference ::= column_name",
 /* 380 */ "column_reference ::= table_name NK_DOT column_name",
 /* 381 */ "pseudo_column ::= ROWTS",
 /* 382 */ "pseudo_column ::= TBNAME",
 /* 383 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 384 */ "pseudo_column ::= QSTART",
 /* 385 */ "pseudo_column ::= QEND",
 /* 386 */ "pseudo_column ::= QDURATION",
 /* 387 */ "pseudo_column ::= WSTART",
 /* 388 */ "pseudo_column ::= WEND",
 /* 389 */ "pseudo_column ::= WDURATION",
 /* 390 */ "pseudo_column ::= IROWTS",
 /* 391 */ "pseudo_column ::= ISFILLED",
 /* 392 */ "pseudo_column ::= QTAGS",
 /* 393 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 394 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 395 */ "function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP",
 /* 396 */ "function_expression ::= literal_func",
 /* 397 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 398 */ "literal_func ::= NOW",
 /* 399 */ "noarg_func ::= NOW",
 /* 400 */ "noarg_func ::= TODAY",
 /* 401 */ "noarg_func ::= TIMEZONE",
 /* 402 */ "noarg_func ::= DATABASE",
 /* 403 */ "noarg_func ::= CLIENT_VERSION",
 /* 404 */ "noarg_func ::= SERVER_VERSION",
 /* 405 */ "noarg_func ::= SERVER_STATUS",
 /* 406 */ "noarg_func ::= CURRENT_USER",
 /* 407 */ "noarg_func ::= USER",
 /* 408 */ "star_func ::= COUNT",
 /* 409 */ "star_func ::= FIRST",
 /* 410 */ "star_func ::= LAST",
 /* 411 */ "star_func ::= LAST_ROW",
 /* 412 */ "star_func_para_list ::= NK_STAR",
 /* 413 */ "star_func_para_list ::= other_para_list",
 /* 414 */ "other_para_list ::= star_func_para",
 /* 415 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 416 */ "star_func_para ::= expr_or_subquery",
 /* 417 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 418 */ "case_when_expression ::= CASE when_then_list case_when_else_opt END",
 /* 419 */ "case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END",
 /* 420 */ "when_then_list ::= when_then_expr",
 /* 421 */ "when_then_list ::= when_then_list when_then_expr",
 /* 422 */ "when_then_expr ::= WHEN common_expression THEN common_expression",
 /* 423 */ "case_when_else_opt ::=",
 /* 424 */ "case_when_else_opt ::= ELSE common_expression",
 /* 425 */ "predicate ::= expr_or_subquery compare_op expr_or_subquery",
 /* 426 */ "predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 427 */ "predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery",
 /* 428 */ "predicate ::= expr_or_subquery IS NULL",
 /* 429 */ "predicate ::= expr_or_subquery IS NOT NULL",
 /* 430 */ "predicate ::= expr_or_subquery in_op in_predicate_value",
 /* 431 */ "compare_op ::= NK_LT",
 /* 432 */ "compare_op ::= NK_GT",
 /* 433 */ "compare_op ::= NK_LE",
 /* 434 */ "compare_op ::= NK_GE",
 /* 435 */ "compare_op ::= NK_NE",
 /* 436 */ "compare_op ::= NK_EQ",
 /* 437 */ "compare_op ::= LIKE",
 /* 438 */ "compare_op ::= NOT LIKE",
 /* 439 */ "compare_op ::= MATCH",
 /* 440 */ "compare_op ::= NMATCH",
 /* 441 */ "compare_op ::= CONTAINS",
 /* 442 */ "in_op ::= IN",
 /* 443 */ "in_op ::= NOT IN",
 /* 444 */ "in_predicate_value ::= NK_LP literal_list NK_RP",
 /* 445 */ "boolean_value_expression ::= boolean_primary",
 /* 446 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 447 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 448 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 449 */ "boolean_primary ::= predicate",
 /* 450 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 451 */ "common_expression ::= expr_or_subquery",
 /* 452 */ "common_expression ::= boolean_value_expression",
 /* 453 */ "from_clause_opt ::=",
 /* 454 */ "from_clause_opt ::= FROM table_reference_list",
 /* 455 */ "table_reference_list ::= table_reference",
 /* 456 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 457 */ "table_reference ::= table_primary",
 /* 458 */ "table_reference ::= joined_table",
 /* 459 */ "table_primary ::= table_name alias_opt",
 /* 460 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 461 */ "table_primary ::= subquery alias_opt",
 /* 462 */ "table_primary ::= parenthesized_joined_table",
 /* 463 */ "alias_opt ::=",
 /* 464 */ "alias_opt ::= table_alias",
 /* 465 */ "alias_opt ::= AS table_alias",
 /* 466 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 467 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 468 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 469 */ "join_type ::=",
 /* 470 */ "join_type ::= INNER",
 /* 471 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 472 */ "set_quantifier_opt ::=",
 /* 473 */ "set_quantifier_opt ::= DISTINCT",
 /* 474 */ "set_quantifier_opt ::= ALL",
 /* 475 */ "select_list ::= select_item",
 /* 476 */ "select_list ::= select_list NK_COMMA select_item",
 /* 477 */ "select_item ::= NK_STAR",
 /* 478 */ "select_item ::= common_expression",
 /* 479 */ "select_item ::= common_expression column_alias",
 /* 480 */ "select_item ::= common_expression AS column_alias",
 /* 481 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 482 */ "where_clause_opt ::=",
 /* 483 */ "where_clause_opt ::= WHERE search_condition",
 /* 484 */ "partition_by_clause_opt ::=",
 /* 485 */ "partition_by_clause_opt ::= PARTITION BY partition_list",
 /* 486 */ "partition_list ::= partition_item",
 /* 487 */ "partition_list ::= partition_list NK_COMMA partition_item",
 /* 488 */ "partition_item ::= expr_or_subquery",
 /* 489 */ "partition_item ::= expr_or_subquery column_alias",
 /* 490 */ "partition_item ::= expr_or_subquery AS column_alias",
 /* 491 */ "twindow_clause_opt ::=",
 /* 492 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 493 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP",
 /* 494 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 495 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 496 */ "twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition",
 /* 497 */ "sliding_opt ::=",
 /* 498 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 499 */ "fill_opt ::=",
 /* 500 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 501 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 502 */ "fill_mode ::= NONE",
 /* 503 */ "fill_mode ::= PREV",
 /* 504 */ "fill_mode ::= NULL",
 /* 505 */ "fill_mode ::= LINEAR",
 /* 506 */ "fill_mode ::= NEXT",
 /* 507 */ "group_by_clause_opt ::=",
 /* 508 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 509 */ "group_by_list ::= expr_or_subquery",
 /* 510 */ "group_by_list ::= group_by_list NK_COMMA expr_or_subquery",
 /* 511 */ "having_clause_opt ::=",
 /* 512 */ "having_clause_opt ::= HAVING search_condition",
 /* 513 */ "range_opt ::=",
 /* 514 */ "range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP",
 /* 515 */ "every_opt ::=",
 /* 516 */ "every_opt ::= EVERY NK_LP duration_literal NK_RP",
 /* 517 */ "query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 518 */ "query_simple ::= query_specification",
 /* 519 */ "query_simple ::= union_query_expression",
 /* 520 */ "union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery",
 /* 521 */ "union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery",
 /* 522 */ "query_simple_or_subquery ::= query_simple",
 /* 523 */ "query_simple_or_subquery ::= subquery",
 /* 524 */ "query_or_subquery ::= query_expression",
 /* 525 */ "query_or_subquery ::= subquery",
 /* 526 */ "order_by_clause_opt ::=",
 /* 527 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 528 */ "slimit_clause_opt ::=",
 /* 529 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 530 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 531 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 532 */ "limit_clause_opt ::=",
 /* 533 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 534 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 535 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 536 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 537 */ "subquery ::= NK_LP subquery NK_RP",
 /* 538 */ "search_condition ::= common_expression",
 /* 539 */ "sort_specification_list ::= sort_specification",
 /* 540 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 541 */ "sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt",
 /* 542 */ "ordering_specification_opt ::=",
 /* 543 */ "ordering_specification_opt ::= ASC",
 /* 544 */ "ordering_specification_opt ::= DESC",
 /* 545 */ "null_ordering_opt ::=",
 /* 546 */ "null_ordering_opt ::= NULLS FIRST",
 /* 547 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 325: /* cmd */
    case 328: /* literal */
    case 341: /* db_options */
    case 343: /* alter_db_options */
    case 349: /* retention */
    case 350: /* full_table_name */
    case 353: /* table_options */
    case 357: /* alter_table_clause */
    case 358: /* alter_table_options */
    case 361: /* signed_literal */
    case 362: /* create_subtable_clause */
    case 365: /* drop_table_clause */
    case 368: /* column_def */
    case 372: /* duration_literal */
    case 373: /* rollup_func_name */
    case 375: /* col_name */
    case 376: /* db_name_cond_opt */
    case 377: /* like_pattern_opt */
    case 378: /* table_name_cond */
    case 379: /* from_db_opt */
    case 381: /* tag_item */
    case 383: /* index_options */
    case 385: /* sliding_opt */
    case 386: /* sma_stream_opt */
    case 387: /* func */
    case 389: /* query_or_subquery */
    case 392: /* explain_options */
    case 396: /* stream_options */
    case 398: /* subtable_opt */
    case 399: /* expression */
    case 401: /* where_clause_opt */
    case 402: /* signed */
    case 403: /* literal_func */
    case 406: /* expr_or_subquery */
    case 407: /* pseudo_column */
    case 408: /* column_reference */
    case 409: /* function_expression */
    case 410: /* case_when_expression */
    case 415: /* star_func_para */
    case 417: /* case_when_else_opt */
    case 418: /* common_expression */
    case 419: /* when_then_expr */
    case 420: /* predicate */
    case 423: /* in_predicate_value */
    case 424: /* boolean_value_expression */
    case 425: /* boolean_primary */
    case 426: /* from_clause_opt */
    case 427: /* table_reference_list */
    case 428: /* table_reference */
    case 429: /* table_primary */
    case 430: /* joined_table */
    case 432: /* subquery */
    case 433: /* parenthesized_joined_table */
    case 435: /* search_condition */
    case 436: /* query_specification */
    case 440: /* range_opt */
    case 441: /* every_opt */
    case 442: /* fill_opt */
    case 443: /* twindow_clause_opt */
    case 445: /* having_clause_opt */
    case 446: /* select_item */
    case 448: /* partition_item */
    case 451: /* query_expression */
    case 452: /* query_simple */
    case 454: /* slimit_clause_opt */
    case 455: /* limit_clause_opt */
    case 456: /* union_query_expression */
    case 457: /* query_simple_or_subquery */
    case 459: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy476)); 
}
      break;
    case 326: /* account_options */
    case 327: /* alter_account_options */
    case 329: /* alter_account_option */
    case 344: /* speed_opt */
    case 394: /* bufsize_opt */
{
 
}
      break;
    case 330: /* user_name */
    case 333: /* priv_level */
    case 336: /* db_name */
    case 337: /* topic_name */
    case 338: /* dnode_endpoint */
    case 359: /* column_name */
    case 367: /* table_name */
    case 374: /* function_name */
    case 382: /* column_alias */
    case 388: /* sma_func_name */
    case 390: /* cgroup_name */
    case 395: /* stream_name */
    case 405: /* table_alias */
    case 411: /* star_func */
    case 413: /* noarg_func */
    case 431: /* alias_opt */
{
 
}
      break;
    case 331: /* sysinfo_opt */
{
 
}
      break;
    case 332: /* privileges */
    case 334: /* priv_type_list */
    case 335: /* priv_type */
{
 
}
      break;
    case 339: /* force_opt */
    case 340: /* not_exists_opt */
    case 342: /* exists_opt */
    case 391: /* analyze_opt */
    case 393: /* agg_func_opt */
    case 437: /* set_quantifier_opt */
{
 
}
      break;
    case 345: /* integer_list */
    case 346: /* variable_list */
    case 347: /* retention_list */
    case 351: /* column_def_list */
    case 352: /* tags_def_opt */
    case 354: /* multi_create_clause */
    case 355: /* tags_def */
    case 356: /* multi_drop_clause */
    case 363: /* specific_cols_opt */
    case 364: /* expression_list */
    case 366: /* col_name_list */
    case 369: /* duration_list */
    case 370: /* rollup_func_list */
    case 380: /* tag_list_opt */
    case 384: /* func_list */
    case 397: /* col_list_opt */
    case 400: /* dnode_list */
    case 404: /* literal_list */
    case 412: /* star_func_para_list */
    case 414: /* other_para_list */
    case 416: /* when_then_list */
    case 438: /* select_list */
    case 439: /* partition_by_clause_opt */
    case 444: /* group_by_clause_opt */
    case 447: /* partition_list */
    case 450: /* group_by_list */
    case 453: /* order_by_clause_opt */
    case 458: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy376)); 
}
      break;
    case 348: /* alter_db_option */
    case 371: /* alter_table_option */
{
 
}
      break;
    case 360: /* type_name */
{
 
}
      break;
    case 421: /* compare_op */
    case 422: /* in_op */
{
 
}
      break;
    case 434: /* join_type */
{
 
}
      break;
    case 449: /* fill_mode */
{
 
}
      break;
    case 460: /* ordering_specification_opt */
{
 
}
      break;
    case 461: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  325,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  325,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  326,    0 }, /* (2) account_options ::= */
  {  326,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  326,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  326,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  326,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  326,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  326,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  326,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  326,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  326,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  327,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  327,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  329,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  329,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  329,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  329,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  329,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  329,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  329,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  329,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  329,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  329,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  325,   -6 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
  {  325,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  325,   -5 }, /* (26) cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
  {  325,   -5 }, /* (27) cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
  {  325,   -3 }, /* (28) cmd ::= DROP USER user_name */
  {  331,    0 }, /* (29) sysinfo_opt ::= */
  {  331,   -2 }, /* (30) sysinfo_opt ::= SYSINFO NK_INTEGER */
  {  325,   -6 }, /* (31) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  325,   -6 }, /* (32) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  332,   -1 }, /* (33) privileges ::= ALL */
  {  332,   -1 }, /* (34) privileges ::= priv_type_list */
  {  332,   -1 }, /* (35) privileges ::= SUBSCRIBE */
  {  334,   -1 }, /* (36) priv_type_list ::= priv_type */
  {  334,   -3 }, /* (37) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  335,   -1 }, /* (38) priv_type ::= READ */
  {  335,   -1 }, /* (39) priv_type ::= WRITE */
  {  333,   -3 }, /* (40) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  333,   -3 }, /* (41) priv_level ::= db_name NK_DOT NK_STAR */
  {  333,   -1 }, /* (42) priv_level ::= topic_name */
  {  325,   -3 }, /* (43) cmd ::= CREATE DNODE dnode_endpoint */
  {  325,   -5 }, /* (44) cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
  {  325,   -4 }, /* (45) cmd ::= DROP DNODE NK_INTEGER force_opt */
  {  325,   -4 }, /* (46) cmd ::= DROP DNODE dnode_endpoint force_opt */
  {  325,   -4 }, /* (47) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  325,   -5 }, /* (48) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  325,   -4 }, /* (49) cmd ::= ALTER ALL DNODES NK_STRING */
  {  325,   -5 }, /* (50) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  338,   -1 }, /* (51) dnode_endpoint ::= NK_STRING */
  {  338,   -1 }, /* (52) dnode_endpoint ::= NK_ID */
  {  338,   -1 }, /* (53) dnode_endpoint ::= NK_IPTOKEN */
  {  339,    0 }, /* (54) force_opt ::= */
  {  339,   -1 }, /* (55) force_opt ::= FORCE */
  {  325,   -3 }, /* (56) cmd ::= ALTER LOCAL NK_STRING */
  {  325,   -4 }, /* (57) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  325,   -5 }, /* (58) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (59) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (60) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (61) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (62) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (63) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (64) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (65) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  325,   -5 }, /* (66) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  325,   -4 }, /* (67) cmd ::= DROP DATABASE exists_opt db_name */
  {  325,   -2 }, /* (68) cmd ::= USE db_name */
  {  325,   -4 }, /* (69) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  325,   -3 }, /* (70) cmd ::= FLUSH DATABASE db_name */
  {  325,   -4 }, /* (71) cmd ::= TRIM DATABASE db_name speed_opt */
  {  340,   -3 }, /* (72) not_exists_opt ::= IF NOT EXISTS */
  {  340,    0 }, /* (73) not_exists_opt ::= */
  {  342,   -2 }, /* (74) exists_opt ::= IF EXISTS */
  {  342,    0 }, /* (75) exists_opt ::= */
  {  341,    0 }, /* (76) db_options ::= */
  {  341,   -3 }, /* (77) db_options ::= db_options BUFFER NK_INTEGER */
  {  341,   -3 }, /* (78) db_options ::= db_options CACHEMODEL NK_STRING */
  {  341,   -3 }, /* (79) db_options ::= db_options CACHESIZE NK_INTEGER */
  {  341,   -3 }, /* (80) db_options ::= db_options COMP NK_INTEGER */
  {  341,   -3 }, /* (81) db_options ::= db_options DURATION NK_INTEGER */
  {  341,   -3 }, /* (82) db_options ::= db_options DURATION NK_VARIABLE */
  {  341,   -3 }, /* (83) db_options ::= db_options MAXROWS NK_INTEGER */
  {  341,   -3 }, /* (84) db_options ::= db_options MINROWS NK_INTEGER */
  {  341,   -3 }, /* (85) db_options ::= db_options KEEP integer_list */
  {  341,   -3 }, /* (86) db_options ::= db_options KEEP variable_list */
  {  341,   -3 }, /* (87) db_options ::= db_options PAGES NK_INTEGER */
  {  341,   -3 }, /* (88) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  341,   -3 }, /* (89) db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
  {  341,   -3 }, /* (90) db_options ::= db_options PRECISION NK_STRING */
  {  341,   -3 }, /* (91) db_options ::= db_options REPLICA NK_INTEGER */
  {  341,   -3 }, /* (92) db_options ::= db_options VGROUPS NK_INTEGER */
  {  341,   -3 }, /* (93) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  341,   -3 }, /* (94) db_options ::= db_options RETENTIONS retention_list */
  {  341,   -3 }, /* (95) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  341,   -3 }, /* (96) db_options ::= db_options WAL_LEVEL NK_INTEGER */
  {  341,   -3 }, /* (97) db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
  {  341,   -3 }, /* (98) db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
  {  341,   -4 }, /* (99) db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
  {  341,   -3 }, /* (100) db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
  {  341,   -4 }, /* (101) db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
  {  341,   -3 }, /* (102) db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
  {  341,   -3 }, /* (103) db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
  {  341,   -3 }, /* (104) db_options ::= db_options STT_TRIGGER NK_INTEGER */
  {  341,   -3 }, /* (105) db_options ::= db_options TABLE_PREFIX NK_INTEGER */
  {  341,   -3 }, /* (106) db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
  {  343,   -1 }, /* (107) alter_db_options ::= alter_db_option */
  {  343,   -2 }, /* (108) alter_db_options ::= alter_db_options alter_db_option */
  {  348,   -2 }, /* (109) alter_db_option ::= BUFFER NK_INTEGER */
  {  348,   -2 }, /* (110) alter_db_option ::= CACHEMODEL NK_STRING */
  {  348,   -2 }, /* (111) alter_db_option ::= CACHESIZE NK_INTEGER */
  {  348,   -2 }, /* (112) alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
  {  348,   -2 }, /* (113) alter_db_option ::= KEEP integer_list */
  {  348,   -2 }, /* (114) alter_db_option ::= KEEP variable_list */
  {  348,   -2 }, /* (115) alter_db_option ::= PAGES NK_INTEGER */
  {  348,   -2 }, /* (116) alter_db_option ::= REPLICA NK_INTEGER */
  {  348,   -2 }, /* (117) alter_db_option ::= WAL_LEVEL NK_INTEGER */
  {  348,   -2 }, /* (118) alter_db_option ::= STT_TRIGGER NK_INTEGER */
  {  345,   -1 }, /* (119) integer_list ::= NK_INTEGER */
  {  345,   -3 }, /* (120) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  346,   -1 }, /* (121) variable_list ::= NK_VARIABLE */
  {  346,   -3 }, /* (122) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  347,   -1 }, /* (123) retention_list ::= retention */
  {  347,   -3 }, /* (124) retention_list ::= retention_list NK_COMMA retention */
  {  349,   -3 }, /* (125) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  344,    0 }, /* (126) speed_opt ::= */
  {  344,   -2 }, /* (127) speed_opt ::= MAX_SPEED NK_INTEGER */
  {  325,   -9 }, /* (128) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  325,   -3 }, /* (129) cmd ::= CREATE TABLE multi_create_clause */
  {  325,   -9 }, /* (130) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  325,   -3 }, /* (131) cmd ::= DROP TABLE multi_drop_clause */
  {  325,   -4 }, /* (132) cmd ::= DROP STABLE exists_opt full_table_name */
  {  325,   -3 }, /* (133) cmd ::= ALTER TABLE alter_table_clause */
  {  325,   -3 }, /* (134) cmd ::= ALTER STABLE alter_table_clause */
  {  357,   -2 }, /* (135) alter_table_clause ::= full_table_name alter_table_options */
  {  357,   -5 }, /* (136) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  357,   -4 }, /* (137) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  357,   -5 }, /* (138) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  357,   -5 }, /* (139) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  357,   -5 }, /* (140) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  357,   -4 }, /* (141) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  357,   -5 }, /* (142) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  357,   -5 }, /* (143) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  357,   -6 }, /* (144) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  354,   -1 }, /* (145) multi_create_clause ::= create_subtable_clause */
  {  354,   -2 }, /* (146) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  362,  -10 }, /* (147) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
  {  356,   -1 }, /* (148) multi_drop_clause ::= drop_table_clause */
  {  356,   -2 }, /* (149) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  365,   -2 }, /* (150) drop_table_clause ::= exists_opt full_table_name */
  {  363,    0 }, /* (151) specific_cols_opt ::= */
  {  363,   -3 }, /* (152) specific_cols_opt ::= NK_LP col_name_list NK_RP */
  {  350,   -1 }, /* (153) full_table_name ::= table_name */
  {  350,   -3 }, /* (154) full_table_name ::= db_name NK_DOT table_name */
  {  351,   -1 }, /* (155) column_def_list ::= column_def */
  {  351,   -3 }, /* (156) column_def_list ::= column_def_list NK_COMMA column_def */
  {  368,   -2 }, /* (157) column_def ::= column_name type_name */
  {  368,   -4 }, /* (158) column_def ::= column_name type_name COMMENT NK_STRING */
  {  360,   -1 }, /* (159) type_name ::= BOOL */
  {  360,   -1 }, /* (160) type_name ::= TINYINT */
  {  360,   -1 }, /* (161) type_name ::= SMALLINT */
  {  360,   -1 }, /* (162) type_name ::= INT */
  {  360,   -1 }, /* (163) type_name ::= INTEGER */
  {  360,   -1 }, /* (164) type_name ::= BIGINT */
  {  360,   -1 }, /* (165) type_name ::= FLOAT */
  {  360,   -1 }, /* (166) type_name ::= DOUBLE */
  {  360,   -4 }, /* (167) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  360,   -1 }, /* (168) type_name ::= TIMESTAMP */
  {  360,   -4 }, /* (169) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  360,   -2 }, /* (170) type_name ::= TINYINT UNSIGNED */
  {  360,   -2 }, /* (171) type_name ::= SMALLINT UNSIGNED */
  {  360,   -2 }, /* (172) type_name ::= INT UNSIGNED */
  {  360,   -2 }, /* (173) type_name ::= BIGINT UNSIGNED */
  {  360,   -1 }, /* (174) type_name ::= JSON */
  {  360,   -4 }, /* (175) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  360,   -1 }, /* (176) type_name ::= MEDIUMBLOB */
  {  360,   -1 }, /* (177) type_name ::= BLOB */
  {  360,   -4 }, /* (178) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  360,   -1 }, /* (179) type_name ::= DECIMAL */
  {  360,   -4 }, /* (180) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  360,   -6 }, /* (181) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  352,    0 }, /* (182) tags_def_opt ::= */
  {  352,   -1 }, /* (183) tags_def_opt ::= tags_def */
  {  355,   -4 }, /* (184) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  353,    0 }, /* (185) table_options ::= */
  {  353,   -3 }, /* (186) table_options ::= table_options COMMENT NK_STRING */
  {  353,   -3 }, /* (187) table_options ::= table_options MAX_DELAY duration_list */
  {  353,   -3 }, /* (188) table_options ::= table_options WATERMARK duration_list */
  {  353,   -5 }, /* (189) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  353,   -3 }, /* (190) table_options ::= table_options TTL NK_INTEGER */
  {  353,   -5 }, /* (191) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  353,   -3 }, /* (192) table_options ::= table_options DELETE_MARK duration_list */
  {  358,   -1 }, /* (193) alter_table_options ::= alter_table_option */
  {  358,   -2 }, /* (194) alter_table_options ::= alter_table_options alter_table_option */
  {  371,   -2 }, /* (195) alter_table_option ::= COMMENT NK_STRING */
  {  371,   -2 }, /* (196) alter_table_option ::= TTL NK_INTEGER */
  {  369,   -1 }, /* (197) duration_list ::= duration_literal */
  {  369,   -3 }, /* (198) duration_list ::= duration_list NK_COMMA duration_literal */
  {  370,   -1 }, /* (199) rollup_func_list ::= rollup_func_name */
  {  370,   -3 }, /* (200) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  373,   -1 }, /* (201) rollup_func_name ::= function_name */
  {  373,   -1 }, /* (202) rollup_func_name ::= FIRST */
  {  373,   -1 }, /* (203) rollup_func_name ::= LAST */
  {  366,   -1 }, /* (204) col_name_list ::= col_name */
  {  366,   -3 }, /* (205) col_name_list ::= col_name_list NK_COMMA col_name */
  {  375,   -1 }, /* (206) col_name ::= column_name */
  {  325,   -2 }, /* (207) cmd ::= SHOW DNODES */
  {  325,   -2 }, /* (208) cmd ::= SHOW USERS */
  {  325,   -3 }, /* (209) cmd ::= SHOW USER PRIVILEGES */
  {  325,   -2 }, /* (210) cmd ::= SHOW DATABASES */
  {  325,   -4 }, /* (211) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  325,   -4 }, /* (212) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  325,   -3 }, /* (213) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  325,   -2 }, /* (214) cmd ::= SHOW MNODES */
  {  325,   -2 }, /* (215) cmd ::= SHOW QNODES */
  {  325,   -2 }, /* (216) cmd ::= SHOW FUNCTIONS */
  {  325,   -5 }, /* (217) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  325,   -2 }, /* (218) cmd ::= SHOW STREAMS */
  {  325,   -2 }, /* (219) cmd ::= SHOW ACCOUNTS */
  {  325,   -2 }, /* (220) cmd ::= SHOW APPS */
  {  325,   -2 }, /* (221) cmd ::= SHOW CONNECTIONS */
  {  325,   -2 }, /* (222) cmd ::= SHOW LICENCES */
  {  325,   -2 }, /* (223) cmd ::= SHOW GRANTS */
  {  325,   -4 }, /* (224) cmd ::= SHOW CREATE DATABASE db_name */
  {  325,   -4 }, /* (225) cmd ::= SHOW CREATE TABLE full_table_name */
  {  325,   -4 }, /* (226) cmd ::= SHOW CREATE STABLE full_table_name */
  {  325,   -2 }, /* (227) cmd ::= SHOW QUERIES */
  {  325,   -2 }, /* (228) cmd ::= SHOW SCORES */
  {  325,   -2 }, /* (229) cmd ::= SHOW TOPICS */
  {  325,   -2 }, /* (230) cmd ::= SHOW VARIABLES */
  {  325,   -3 }, /* (231) cmd ::= SHOW CLUSTER VARIABLES */
  {  325,   -3 }, /* (232) cmd ::= SHOW LOCAL VARIABLES */
  {  325,   -5 }, /* (233) cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
  {  325,   -2 }, /* (234) cmd ::= SHOW BNODES */
  {  325,   -2 }, /* (235) cmd ::= SHOW SNODES */
  {  325,   -2 }, /* (236) cmd ::= SHOW CLUSTER */
  {  325,   -2 }, /* (237) cmd ::= SHOW TRANSACTIONS */
  {  325,   -4 }, /* (238) cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
  {  325,   -2 }, /* (239) cmd ::= SHOW CONSUMERS */
  {  325,   -2 }, /* (240) cmd ::= SHOW SUBSCRIPTIONS */
  {  325,   -5 }, /* (241) cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
  {  325,   -7 }, /* (242) cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
  {  325,   -3 }, /* (243) cmd ::= SHOW VNODES NK_INTEGER */
  {  325,   -3 }, /* (244) cmd ::= SHOW VNODES NK_STRING */
  {  376,    0 }, /* (245) db_name_cond_opt ::= */
  {  376,   -2 }, /* (246) db_name_cond_opt ::= db_name NK_DOT */
  {  377,    0 }, /* (247) like_pattern_opt ::= */
  {  377,   -2 }, /* (248) like_pattern_opt ::= LIKE NK_STRING */
  {  378,   -1 }, /* (249) table_name_cond ::= table_name */
  {  379,    0 }, /* (250) from_db_opt ::= */
  {  379,   -2 }, /* (251) from_db_opt ::= FROM db_name */
  {  380,    0 }, /* (252) tag_list_opt ::= */
  {  380,   -1 }, /* (253) tag_list_opt ::= tag_item */
  {  380,   -3 }, /* (254) tag_list_opt ::= tag_list_opt NK_COMMA tag_item */
  {  381,   -1 }, /* (255) tag_item ::= TBNAME */
  {  381,   -1 }, /* (256) tag_item ::= QTAGS */
  {  381,   -1 }, /* (257) tag_item ::= column_name */
  {  381,   -2 }, /* (258) tag_item ::= column_name column_alias */
  {  381,   -3 }, /* (259) tag_item ::= column_name AS column_alias */
  {  325,   -8 }, /* (260) cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
  {  325,   -9 }, /* (261) cmd ::= CREATE INDEX not_exists_opt full_table_name ON full_table_name NK_LP col_name_list NK_RP */
  {  325,   -4 }, /* (262) cmd ::= DROP INDEX exists_opt full_table_name */
  {  383,  -10 }, /* (263) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
  {  383,  -12 }, /* (264) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
  {  384,   -1 }, /* (265) func_list ::= func */
  {  384,   -3 }, /* (266) func_list ::= func_list NK_COMMA func */
  {  387,   -4 }, /* (267) func ::= sma_func_name NK_LP expression_list NK_RP */
  {  388,   -1 }, /* (268) sma_func_name ::= function_name */
  {  388,   -1 }, /* (269) sma_func_name ::= COUNT */
  {  388,   -1 }, /* (270) sma_func_name ::= FIRST */
  {  388,   -1 }, /* (271) sma_func_name ::= LAST */
  {  388,   -1 }, /* (272) sma_func_name ::= LAST_ROW */
  {  386,    0 }, /* (273) sma_stream_opt ::= */
  {  386,   -3 }, /* (274) sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
  {  386,   -3 }, /* (275) sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
  {  386,   -3 }, /* (276) sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
  {  325,   -6 }, /* (277) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
  {  325,   -7 }, /* (278) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  325,   -9 }, /* (279) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
  {  325,   -7 }, /* (280) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  325,   -9 }, /* (281) cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
  {  325,   -4 }, /* (282) cmd ::= DROP TOPIC exists_opt topic_name */
  {  325,   -7 }, /* (283) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  325,   -2 }, /* (284) cmd ::= DESC full_table_name */
  {  325,   -2 }, /* (285) cmd ::= DESCRIBE full_table_name */
  {  325,   -3 }, /* (286) cmd ::= RESET QUERY CACHE */
  {  325,   -4 }, /* (287) cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
  {  391,    0 }, /* (288) analyze_opt ::= */
  {  391,   -1 }, /* (289) analyze_opt ::= ANALYZE */
  {  392,    0 }, /* (290) explain_options ::= */
  {  392,   -3 }, /* (291) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  392,   -3 }, /* (292) explain_options ::= explain_options RATIO NK_FLOAT */
  {  325,  -10 }, /* (293) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  325,   -4 }, /* (294) cmd ::= DROP FUNCTION exists_opt function_name */
  {  393,    0 }, /* (295) agg_func_opt ::= */
  {  393,   -1 }, /* (296) agg_func_opt ::= AGGREGATE */
  {  394,    0 }, /* (297) bufsize_opt ::= */
  {  394,   -2 }, /* (298) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  325,  -12 }, /* (299) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tags_def_opt subtable_opt AS query_or_subquery */
  {  325,   -4 }, /* (300) cmd ::= DROP STREAM exists_opt stream_name */
  {  397,    0 }, /* (301) col_list_opt ::= */
  {  397,   -3 }, /* (302) col_list_opt ::= NK_LP col_name_list NK_RP */
  {  396,    0 }, /* (303) stream_options ::= */
  {  396,   -3 }, /* (304) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  396,   -3 }, /* (305) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  396,   -4 }, /* (306) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  396,   -3 }, /* (307) stream_options ::= stream_options WATERMARK duration_literal */
  {  396,   -4 }, /* (308) stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
  {  396,   -3 }, /* (309) stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
  {  398,    0 }, /* (310) subtable_opt ::= */
  {  398,   -4 }, /* (311) subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
  {  325,   -3 }, /* (312) cmd ::= KILL CONNECTION NK_INTEGER */
  {  325,   -3 }, /* (313) cmd ::= KILL QUERY NK_STRING */
  {  325,   -3 }, /* (314) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  325,   -2 }, /* (315) cmd ::= BALANCE VGROUP */
  {  325,   -4 }, /* (316) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  325,   -4 }, /* (317) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  325,   -3 }, /* (318) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  400,   -2 }, /* (319) dnode_list ::= DNODE NK_INTEGER */
  {  400,   -3 }, /* (320) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  325,   -4 }, /* (321) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  325,   -1 }, /* (322) cmd ::= query_or_subquery */
  {  325,   -7 }, /* (323) cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
  {  325,   -4 }, /* (324) cmd ::= INSERT INTO full_table_name query_or_subquery */
  {  328,   -1 }, /* (325) literal ::= NK_INTEGER */
  {  328,   -1 }, /* (326) literal ::= NK_FLOAT */
  {  328,   -1 }, /* (327) literal ::= NK_STRING */
  {  328,   -1 }, /* (328) literal ::= NK_BOOL */
  {  328,   -2 }, /* (329) literal ::= TIMESTAMP NK_STRING */
  {  328,   -1 }, /* (330) literal ::= duration_literal */
  {  328,   -1 }, /* (331) literal ::= NULL */
  {  328,   -1 }, /* (332) literal ::= NK_QUESTION */
  {  372,   -1 }, /* (333) duration_literal ::= NK_VARIABLE */
  {  402,   -1 }, /* (334) signed ::= NK_INTEGER */
  {  402,   -2 }, /* (335) signed ::= NK_PLUS NK_INTEGER */
  {  402,   -2 }, /* (336) signed ::= NK_MINUS NK_INTEGER */
  {  402,   -1 }, /* (337) signed ::= NK_FLOAT */
  {  402,   -2 }, /* (338) signed ::= NK_PLUS NK_FLOAT */
  {  402,   -2 }, /* (339) signed ::= NK_MINUS NK_FLOAT */
  {  361,   -1 }, /* (340) signed_literal ::= signed */
  {  361,   -1 }, /* (341) signed_literal ::= NK_STRING */
  {  361,   -1 }, /* (342) signed_literal ::= NK_BOOL */
  {  361,   -2 }, /* (343) signed_literal ::= TIMESTAMP NK_STRING */
  {  361,   -1 }, /* (344) signed_literal ::= duration_literal */
  {  361,   -1 }, /* (345) signed_literal ::= NULL */
  {  361,   -1 }, /* (346) signed_literal ::= literal_func */
  {  361,   -1 }, /* (347) signed_literal ::= NK_QUESTION */
  {  404,   -1 }, /* (348) literal_list ::= signed_literal */
  {  404,   -3 }, /* (349) literal_list ::= literal_list NK_COMMA signed_literal */
  {  336,   -1 }, /* (350) db_name ::= NK_ID */
  {  367,   -1 }, /* (351) table_name ::= NK_ID */
  {  359,   -1 }, /* (352) column_name ::= NK_ID */
  {  374,   -1 }, /* (353) function_name ::= NK_ID */
  {  405,   -1 }, /* (354) table_alias ::= NK_ID */
  {  382,   -1 }, /* (355) column_alias ::= NK_ID */
  {  330,   -1 }, /* (356) user_name ::= NK_ID */
  {  337,   -1 }, /* (357) topic_name ::= NK_ID */
  {  395,   -1 }, /* (358) stream_name ::= NK_ID */
  {  390,   -1 }, /* (359) cgroup_name ::= NK_ID */
  {  406,   -1 }, /* (360) expr_or_subquery ::= expression */
  {  399,   -1 }, /* (361) expression ::= literal */
  {  399,   -1 }, /* (362) expression ::= pseudo_column */
  {  399,   -1 }, /* (363) expression ::= column_reference */
  {  399,   -1 }, /* (364) expression ::= function_expression */
  {  399,   -1 }, /* (365) expression ::= case_when_expression */
  {  399,   -3 }, /* (366) expression ::= NK_LP expression NK_RP */
  {  399,   -2 }, /* (367) expression ::= NK_PLUS expr_or_subquery */
  {  399,   -2 }, /* (368) expression ::= NK_MINUS expr_or_subquery */
  {  399,   -3 }, /* (369) expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
  {  399,   -3 }, /* (370) expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
  {  399,   -3 }, /* (371) expression ::= expr_or_subquery NK_STAR expr_or_subquery */
  {  399,   -3 }, /* (372) expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
  {  399,   -3 }, /* (373) expression ::= expr_or_subquery NK_REM expr_or_subquery */
  {  399,   -3 }, /* (374) expression ::= column_reference NK_ARROW NK_STRING */
  {  399,   -3 }, /* (375) expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
  {  399,   -3 }, /* (376) expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
  {  364,   -1 }, /* (377) expression_list ::= expr_or_subquery */
  {  364,   -3 }, /* (378) expression_list ::= expression_list NK_COMMA expr_or_subquery */
  {  408,   -1 }, /* (379) column_reference ::= column_name */
  {  408,   -3 }, /* (380) column_reference ::= table_name NK_DOT column_name */
  {  407,   -1 }, /* (381) pseudo_column ::= ROWTS */
  {  407,   -1 }, /* (382) pseudo_column ::= TBNAME */
  {  407,   -3 }, /* (383) pseudo_column ::= table_name NK_DOT TBNAME */
  {  407,   -1 }, /* (384) pseudo_column ::= QSTART */
  {  407,   -1 }, /* (385) pseudo_column ::= QEND */
  {  407,   -1 }, /* (386) pseudo_column ::= QDURATION */
  {  407,   -1 }, /* (387) pseudo_column ::= WSTART */
  {  407,   -1 }, /* (388) pseudo_column ::= WEND */
  {  407,   -1 }, /* (389) pseudo_column ::= WDURATION */
  {  407,   -1 }, /* (390) pseudo_column ::= IROWTS */
  {  407,   -1 }, /* (391) pseudo_column ::= ISFILLED */
  {  407,   -1 }, /* (392) pseudo_column ::= QTAGS */
  {  409,   -4 }, /* (393) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  409,   -4 }, /* (394) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  409,   -6 }, /* (395) function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
  {  409,   -1 }, /* (396) function_expression ::= literal_func */
  {  403,   -3 }, /* (397) literal_func ::= noarg_func NK_LP NK_RP */
  {  403,   -1 }, /* (398) literal_func ::= NOW */
  {  413,   -1 }, /* (399) noarg_func ::= NOW */
  {  413,   -1 }, /* (400) noarg_func ::= TODAY */
  {  413,   -1 }, /* (401) noarg_func ::= TIMEZONE */
  {  413,   -1 }, /* (402) noarg_func ::= DATABASE */
  {  413,   -1 }, /* (403) noarg_func ::= CLIENT_VERSION */
  {  413,   -1 }, /* (404) noarg_func ::= SERVER_VERSION */
  {  413,   -1 }, /* (405) noarg_func ::= SERVER_STATUS */
  {  413,   -1 }, /* (406) noarg_func ::= CURRENT_USER */
  {  413,   -1 }, /* (407) noarg_func ::= USER */
  {  411,   -1 }, /* (408) star_func ::= COUNT */
  {  411,   -1 }, /* (409) star_func ::= FIRST */
  {  411,   -1 }, /* (410) star_func ::= LAST */
  {  411,   -1 }, /* (411) star_func ::= LAST_ROW */
  {  412,   -1 }, /* (412) star_func_para_list ::= NK_STAR */
  {  412,   -1 }, /* (413) star_func_para_list ::= other_para_list */
  {  414,   -1 }, /* (414) other_para_list ::= star_func_para */
  {  414,   -3 }, /* (415) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  415,   -1 }, /* (416) star_func_para ::= expr_or_subquery */
  {  415,   -3 }, /* (417) star_func_para ::= table_name NK_DOT NK_STAR */
  {  410,   -4 }, /* (418) case_when_expression ::= CASE when_then_list case_when_else_opt END */
  {  410,   -5 }, /* (419) case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
  {  416,   -1 }, /* (420) when_then_list ::= when_then_expr */
  {  416,   -2 }, /* (421) when_then_list ::= when_then_list when_then_expr */
  {  419,   -4 }, /* (422) when_then_expr ::= WHEN common_expression THEN common_expression */
  {  417,    0 }, /* (423) case_when_else_opt ::= */
  {  417,   -2 }, /* (424) case_when_else_opt ::= ELSE common_expression */
  {  420,   -3 }, /* (425) predicate ::= expr_or_subquery compare_op expr_or_subquery */
  {  420,   -5 }, /* (426) predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
  {  420,   -6 }, /* (427) predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
  {  420,   -3 }, /* (428) predicate ::= expr_or_subquery IS NULL */
  {  420,   -4 }, /* (429) predicate ::= expr_or_subquery IS NOT NULL */
  {  420,   -3 }, /* (430) predicate ::= expr_or_subquery in_op in_predicate_value */
  {  421,   -1 }, /* (431) compare_op ::= NK_LT */
  {  421,   -1 }, /* (432) compare_op ::= NK_GT */
  {  421,   -1 }, /* (433) compare_op ::= NK_LE */
  {  421,   -1 }, /* (434) compare_op ::= NK_GE */
  {  421,   -1 }, /* (435) compare_op ::= NK_NE */
  {  421,   -1 }, /* (436) compare_op ::= NK_EQ */
  {  421,   -1 }, /* (437) compare_op ::= LIKE */
  {  421,   -2 }, /* (438) compare_op ::= NOT LIKE */
  {  421,   -1 }, /* (439) compare_op ::= MATCH */
  {  421,   -1 }, /* (440) compare_op ::= NMATCH */
  {  421,   -1 }, /* (441) compare_op ::= CONTAINS */
  {  422,   -1 }, /* (442) in_op ::= IN */
  {  422,   -2 }, /* (443) in_op ::= NOT IN */
  {  423,   -3 }, /* (444) in_predicate_value ::= NK_LP literal_list NK_RP */
  {  424,   -1 }, /* (445) boolean_value_expression ::= boolean_primary */
  {  424,   -2 }, /* (446) boolean_value_expression ::= NOT boolean_primary */
  {  424,   -3 }, /* (447) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  424,   -3 }, /* (448) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  425,   -1 }, /* (449) boolean_primary ::= predicate */
  {  425,   -3 }, /* (450) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  418,   -1 }, /* (451) common_expression ::= expr_or_subquery */
  {  418,   -1 }, /* (452) common_expression ::= boolean_value_expression */
  {  426,    0 }, /* (453) from_clause_opt ::= */
  {  426,   -2 }, /* (454) from_clause_opt ::= FROM table_reference_list */
  {  427,   -1 }, /* (455) table_reference_list ::= table_reference */
  {  427,   -3 }, /* (456) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  428,   -1 }, /* (457) table_reference ::= table_primary */
  {  428,   -1 }, /* (458) table_reference ::= joined_table */
  {  429,   -2 }, /* (459) table_primary ::= table_name alias_opt */
  {  429,   -4 }, /* (460) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  429,   -2 }, /* (461) table_primary ::= subquery alias_opt */
  {  429,   -1 }, /* (462) table_primary ::= parenthesized_joined_table */
  {  431,    0 }, /* (463) alias_opt ::= */
  {  431,   -1 }, /* (464) alias_opt ::= table_alias */
  {  431,   -2 }, /* (465) alias_opt ::= AS table_alias */
  {  433,   -3 }, /* (466) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  433,   -3 }, /* (467) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  430,   -6 }, /* (468) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  434,    0 }, /* (469) join_type ::= */
  {  434,   -1 }, /* (470) join_type ::= INNER */
  {  436,  -12 }, /* (471) query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  437,    0 }, /* (472) set_quantifier_opt ::= */
  {  437,   -1 }, /* (473) set_quantifier_opt ::= DISTINCT */
  {  437,   -1 }, /* (474) set_quantifier_opt ::= ALL */
  {  438,   -1 }, /* (475) select_list ::= select_item */
  {  438,   -3 }, /* (476) select_list ::= select_list NK_COMMA select_item */
  {  446,   -1 }, /* (477) select_item ::= NK_STAR */
  {  446,   -1 }, /* (478) select_item ::= common_expression */
  {  446,   -2 }, /* (479) select_item ::= common_expression column_alias */
  {  446,   -3 }, /* (480) select_item ::= common_expression AS column_alias */
  {  446,   -3 }, /* (481) select_item ::= table_name NK_DOT NK_STAR */
  {  401,    0 }, /* (482) where_clause_opt ::= */
  {  401,   -2 }, /* (483) where_clause_opt ::= WHERE search_condition */
  {  439,    0 }, /* (484) partition_by_clause_opt ::= */
  {  439,   -3 }, /* (485) partition_by_clause_opt ::= PARTITION BY partition_list */
  {  447,   -1 }, /* (486) partition_list ::= partition_item */
  {  447,   -3 }, /* (487) partition_list ::= partition_list NK_COMMA partition_item */
  {  448,   -1 }, /* (488) partition_item ::= expr_or_subquery */
  {  448,   -2 }, /* (489) partition_item ::= expr_or_subquery column_alias */
  {  448,   -3 }, /* (490) partition_item ::= expr_or_subquery AS column_alias */
  {  443,    0 }, /* (491) twindow_clause_opt ::= */
  {  443,   -6 }, /* (492) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  443,   -4 }, /* (493) twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
  {  443,   -6 }, /* (494) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  443,   -8 }, /* (495) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  443,   -7 }, /* (496) twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
  {  385,    0 }, /* (497) sliding_opt ::= */
  {  385,   -4 }, /* (498) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  442,    0 }, /* (499) fill_opt ::= */
  {  442,   -4 }, /* (500) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  442,   -6 }, /* (501) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  449,   -1 }, /* (502) fill_mode ::= NONE */
  {  449,   -1 }, /* (503) fill_mode ::= PREV */
  {  449,   -1 }, /* (504) fill_mode ::= NULL */
  {  449,   -1 }, /* (505) fill_mode ::= LINEAR */
  {  449,   -1 }, /* (506) fill_mode ::= NEXT */
  {  444,    0 }, /* (507) group_by_clause_opt ::= */
  {  444,   -3 }, /* (508) group_by_clause_opt ::= GROUP BY group_by_list */
  {  450,   -1 }, /* (509) group_by_list ::= expr_or_subquery */
  {  450,   -3 }, /* (510) group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
  {  445,    0 }, /* (511) having_clause_opt ::= */
  {  445,   -2 }, /* (512) having_clause_opt ::= HAVING search_condition */
  {  440,    0 }, /* (513) range_opt ::= */
  {  440,   -6 }, /* (514) range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
  {  441,    0 }, /* (515) every_opt ::= */
  {  441,   -4 }, /* (516) every_opt ::= EVERY NK_LP duration_literal NK_RP */
  {  451,   -4 }, /* (517) query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  452,   -1 }, /* (518) query_simple ::= query_specification */
  {  452,   -1 }, /* (519) query_simple ::= union_query_expression */
  {  456,   -4 }, /* (520) union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
  {  456,   -3 }, /* (521) union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
  {  457,   -1 }, /* (522) query_simple_or_subquery ::= query_simple */
  {  457,   -1 }, /* (523) query_simple_or_subquery ::= subquery */
  {  389,   -1 }, /* (524) query_or_subquery ::= query_expression */
  {  389,   -1 }, /* (525) query_or_subquery ::= subquery */
  {  453,    0 }, /* (526) order_by_clause_opt ::= */
  {  453,   -3 }, /* (527) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  454,    0 }, /* (528) slimit_clause_opt ::= */
  {  454,   -2 }, /* (529) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  454,   -4 }, /* (530) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  454,   -4 }, /* (531) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  455,    0 }, /* (532) limit_clause_opt ::= */
  {  455,   -2 }, /* (533) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  455,   -4 }, /* (534) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  455,   -4 }, /* (535) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  432,   -3 }, /* (536) subquery ::= NK_LP query_expression NK_RP */
  {  432,   -3 }, /* (537) subquery ::= NK_LP subquery NK_RP */
  {  435,   -1 }, /* (538) search_condition ::= common_expression */
  {  458,   -1 }, /* (539) sort_specification_list ::= sort_specification */
  {  458,   -3 }, /* (540) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  459,   -3 }, /* (541) sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
  {  460,    0 }, /* (542) ordering_specification_opt ::= */
  {  460,   -1 }, /* (543) ordering_specification_opt ::= ASC */
  {  460,   -1 }, /* (544) ordering_specification_opt ::= DESC */
  {  461,    0 }, /* (545) null_ordering_opt ::= */
  {  461,   -2 }, /* (546) null_ordering_opt ::= NULLS FIRST */
  {  461,   -2 }, /* (547) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,326,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,327,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,326,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,328,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,329,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,327,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,329,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,328,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING sysinfo_opt */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-3].minor.yy701, &yymsp[-1].minor.yy0, yymsp[0].minor.yy47); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy701, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name ENABLE NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy701, TSDB_ALTER_USER_ENABLE, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= ALTER USER user_name SYSINFO NK_INTEGER */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy701, TSDB_ALTER_USER_SYSINFO, &yymsp[0].minor.yy0); }
        break;
      case 28: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy701); }
        break;
      case 29: /* sysinfo_opt ::= */
{ yymsp[1].minor.yy47 = 1; }
        break;
      case 30: /* sysinfo_opt ::= SYSINFO NK_INTEGER */
{ yymsp[-1].minor.yy47 = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 31: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy921, &yymsp[-2].minor.yy701, &yymsp[0].minor.yy701); }
        break;
      case 32: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy921, &yymsp[-2].minor.yy701, &yymsp[0].minor.yy701); }
        break;
      case 33: /* privileges ::= ALL */
{ yymsp[0].minor.yy921 = PRIVILEGE_TYPE_ALL; }
        break;
      case 34: /* privileges ::= priv_type_list */
      case 36: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==36);
{ yylhsminor.yy921 = yymsp[0].minor.yy921; }
  yymsp[0].minor.yy921 = yylhsminor.yy921;
        break;
      case 35: /* privileges ::= SUBSCRIBE */
{ yymsp[0].minor.yy921 = PRIVILEGE_TYPE_SUBSCRIBE; }
        break;
      case 37: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy921 = yymsp[-2].minor.yy921 | yymsp[0].minor.yy921; }
  yymsp[-2].minor.yy921 = yylhsminor.yy921;
        break;
      case 38: /* priv_type ::= READ */
{ yymsp[0].minor.yy921 = PRIVILEGE_TYPE_READ; }
        break;
      case 39: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy921 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 40: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy701 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy701 = yylhsminor.yy701;
        break;
      case 41: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy701 = yymsp[-2].minor.yy701; }
  yymsp[-2].minor.yy701 = yylhsminor.yy701;
        break;
      case 42: /* priv_level ::= topic_name */
      case 268: /* sma_func_name ::= function_name */ yytestcase(yyruleno==268);
      case 464: /* alias_opt ::= table_alias */ yytestcase(yyruleno==464);
{ yylhsminor.yy701 = yymsp[0].minor.yy701; }
  yymsp[0].minor.yy701 = yylhsminor.yy701;
        break;
      case 43: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy701, NULL); }
        break;
      case 44: /* cmd ::= CREATE DNODE dnode_endpoint PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy701, &yymsp[0].minor.yy0); }
        break;
      case 45: /* cmd ::= DROP DNODE NK_INTEGER force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy845); }
        break;
      case 46: /* cmd ::= DROP DNODE dnode_endpoint force_opt */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[-1].minor.yy701, yymsp[0].minor.yy845); }
        break;
      case 47: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 48: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 49: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* dnode_endpoint ::= NK_STRING */
      case 52: /* dnode_endpoint ::= NK_ID */ yytestcase(yyruleno==52);
      case 53: /* dnode_endpoint ::= NK_IPTOKEN */ yytestcase(yyruleno==53);
      case 269: /* sma_func_name ::= COUNT */ yytestcase(yyruleno==269);
      case 270: /* sma_func_name ::= FIRST */ yytestcase(yyruleno==270);
      case 271: /* sma_func_name ::= LAST */ yytestcase(yyruleno==271);
      case 272: /* sma_func_name ::= LAST_ROW */ yytestcase(yyruleno==272);
      case 350: /* db_name ::= NK_ID */ yytestcase(yyruleno==350);
      case 351: /* table_name ::= NK_ID */ yytestcase(yyruleno==351);
      case 352: /* column_name ::= NK_ID */ yytestcase(yyruleno==352);
      case 353: /* function_name ::= NK_ID */ yytestcase(yyruleno==353);
      case 354: /* table_alias ::= NK_ID */ yytestcase(yyruleno==354);
      case 355: /* column_alias ::= NK_ID */ yytestcase(yyruleno==355);
      case 356: /* user_name ::= NK_ID */ yytestcase(yyruleno==356);
      case 357: /* topic_name ::= NK_ID */ yytestcase(yyruleno==357);
      case 358: /* stream_name ::= NK_ID */ yytestcase(yyruleno==358);
      case 359: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==359);
      case 399: /* noarg_func ::= NOW */ yytestcase(yyruleno==399);
      case 400: /* noarg_func ::= TODAY */ yytestcase(yyruleno==400);
      case 401: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==401);
      case 402: /* noarg_func ::= DATABASE */ yytestcase(yyruleno==402);
      case 403: /* noarg_func ::= CLIENT_VERSION */ yytestcase(yyruleno==403);
      case 404: /* noarg_func ::= SERVER_VERSION */ yytestcase(yyruleno==404);
      case 405: /* noarg_func ::= SERVER_STATUS */ yytestcase(yyruleno==405);
      case 406: /* noarg_func ::= CURRENT_USER */ yytestcase(yyruleno==406);
      case 407: /* noarg_func ::= USER */ yytestcase(yyruleno==407);
      case 408: /* star_func ::= COUNT */ yytestcase(yyruleno==408);
      case 409: /* star_func ::= FIRST */ yytestcase(yyruleno==409);
      case 410: /* star_func ::= LAST */ yytestcase(yyruleno==410);
      case 411: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==411);
{ yylhsminor.yy701 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy701 = yylhsminor.yy701;
        break;
      case 54: /* force_opt ::= */
      case 73: /* not_exists_opt ::= */ yytestcase(yyruleno==73);
      case 75: /* exists_opt ::= */ yytestcase(yyruleno==75);
      case 288: /* analyze_opt ::= */ yytestcase(yyruleno==288);
      case 295: /* agg_func_opt ::= */ yytestcase(yyruleno==295);
      case 472: /* set_quantifier_opt ::= */ yytestcase(yyruleno==472);
{ yymsp[1].minor.yy845 = false; }
        break;
      case 55: /* force_opt ::= FORCE */
      case 289: /* analyze_opt ::= ANALYZE */ yytestcase(yyruleno==289);
      case 296: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==296);
      case 473: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==473);
{ yymsp[0].minor.yy845 = true; }
        break;
      case 56: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 57: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 60: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 61: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 62: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 63: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 64: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 65: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 66: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy845, &yymsp[-1].minor.yy701, yymsp[0].minor.yy476); }
        break;
      case 67: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy845, &yymsp[0].minor.yy701); }
        break;
      case 68: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy701); }
        break;
      case 69: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy701, yymsp[0].minor.yy476); }
        break;
      case 70: /* cmd ::= FLUSH DATABASE db_name */
{ pCxt->pRootNode = createFlushDatabaseStmt(pCxt, &yymsp[0].minor.yy701); }
        break;
      case 71: /* cmd ::= TRIM DATABASE db_name speed_opt */
{ pCxt->pRootNode = createTrimDatabaseStmt(pCxt, &yymsp[-1].minor.yy701, yymsp[0].minor.yy508); }
        break;
      case 72: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy845 = true; }
        break;
      case 74: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy845 = true; }
        break;
      case 76: /* db_options ::= */
{ yymsp[1].minor.yy476 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 77: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 78: /* db_options ::= db_options CACHEMODEL NK_STRING */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_CACHEMODEL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 79: /* db_options ::= db_options CACHESIZE NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_CACHESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 80: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 81: /* db_options ::= db_options DURATION NK_INTEGER */
      case 82: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==82);
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 83: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 84: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 85: /* db_options ::= db_options KEEP integer_list */
      case 86: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==86);
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_KEEP, yymsp[0].minor.yy376); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 87: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 88: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 89: /* db_options ::= db_options TSDB_PAGESIZE NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_TSDB_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 90: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 91: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 92: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 93: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 94: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_RETENTIONS, yymsp[0].minor.yy376); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 95: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 96: /* db_options ::= db_options WAL_LEVEL NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 97: /* db_options ::= db_options WAL_FSYNC_PERIOD NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 98: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_WAL_RETENTION_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 99: /* db_options ::= db_options WAL_RETENTION_PERIOD NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-3].minor.yy476, DB_OPTION_WAL_RETENTION_PERIOD, &t);
                                                                                  }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 100: /* db_options ::= db_options WAL_RETENTION_SIZE NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_WAL_RETENTION_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 101: /* db_options ::= db_options WAL_RETENTION_SIZE NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-3].minor.yy476, DB_OPTION_WAL_RETENTION_SIZE, &t);
                                                                                  }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 102: /* db_options ::= db_options WAL_ROLL_PERIOD NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_WAL_ROLL_PERIOD, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 103: /* db_options ::= db_options WAL_SEGMENT_SIZE NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_WAL_SEGMENT_SIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 104: /* db_options ::= db_options STT_TRIGGER NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_STT_TRIGGER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 105: /* db_options ::= db_options TABLE_PREFIX NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_TABLE_PREFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 106: /* db_options ::= db_options TABLE_SUFFIX NK_INTEGER */
{ yylhsminor.yy476 = setDatabaseOption(pCxt, yymsp[-2].minor.yy476, DB_OPTION_TABLE_SUFFIX, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 107: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy476 = createAlterDatabaseOptions(pCxt); yylhsminor.yy476 = setAlterDatabaseOption(pCxt, yylhsminor.yy476, &yymsp[0].minor.yy893); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 108: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy476 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy476, &yymsp[0].minor.yy893); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 109: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy893.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy893.val = yymsp[0].minor.yy0; }
        break;
      case 110: /* alter_db_option ::= CACHEMODEL NK_STRING */
{ yymsp[-1].minor.yy893.type = DB_OPTION_CACHEMODEL; yymsp[-1].minor.yy893.val = yymsp[0].minor.yy0; }
        break;
      case 111: /* alter_db_option ::= CACHESIZE NK_INTEGER */
{ yymsp[-1].minor.yy893.type = DB_OPTION_CACHESIZE; yymsp[-1].minor.yy893.val = yymsp[0].minor.yy0; }
        break;
      case 112: /* alter_db_option ::= WAL_FSYNC_PERIOD NK_INTEGER */
{ yymsp[-1].minor.yy893.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy893.val = yymsp[0].minor.yy0; }
        break;
      case 113: /* alter_db_option ::= KEEP integer_list */
      case 114: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==114);
{ yymsp[-1].minor.yy893.type = DB_OPTION_KEEP; yymsp[-1].minor.yy893.pList = yymsp[0].minor.yy376; }
        break;
      case 115: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy893.type = DB_OPTION_PAGES; yymsp[-1].minor.yy893.val = yymsp[0].minor.yy0; }
        break;
      case 116: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy893.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy893.val = yymsp[0].minor.yy0; }
        break;
      case 117: /* alter_db_option ::= WAL_LEVEL NK_INTEGER */
{ yymsp[-1].minor.yy893.type = DB_OPTION_WAL; yymsp[-1].minor.yy893.val = yymsp[0].minor.yy0; }
        break;
      case 118: /* alter_db_option ::= STT_TRIGGER NK_INTEGER */
{ yymsp[-1].minor.yy893.type = DB_OPTION_STT_TRIGGER; yymsp[-1].minor.yy893.val = yymsp[0].minor.yy0; }
        break;
      case 119: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy376 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 120: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 320: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==320);
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-2].minor.yy376, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy376 = yylhsminor.yy376;
        break;
      case 121: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy376 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 122: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-2].minor.yy376, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy376 = yylhsminor.yy376;
        break;
      case 123: /* retention_list ::= retention */
      case 145: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==145);
      case 148: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==148);
      case 155: /* column_def_list ::= column_def */ yytestcase(yyruleno==155);
      case 199: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==199);
      case 204: /* col_name_list ::= col_name */ yytestcase(yyruleno==204);
      case 253: /* tag_list_opt ::= tag_item */ yytestcase(yyruleno==253);
      case 265: /* func_list ::= func */ yytestcase(yyruleno==265);
      case 348: /* literal_list ::= signed_literal */ yytestcase(yyruleno==348);
      case 414: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==414);
      case 420: /* when_then_list ::= when_then_expr */ yytestcase(yyruleno==420);
      case 475: /* select_list ::= select_item */ yytestcase(yyruleno==475);
      case 486: /* partition_list ::= partition_item */ yytestcase(yyruleno==486);
      case 539: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==539);
{ yylhsminor.yy376 = createNodeList(pCxt, yymsp[0].minor.yy476); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 124: /* retention_list ::= retention_list NK_COMMA retention */
      case 156: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==156);
      case 200: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==200);
      case 205: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==205);
      case 254: /* tag_list_opt ::= tag_list_opt NK_COMMA tag_item */ yytestcase(yyruleno==254);
      case 266: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==266);
      case 349: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==349);
      case 415: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==415);
      case 476: /* select_list ::= select_list NK_COMMA select_item */ yytestcase(yyruleno==476);
      case 487: /* partition_list ::= partition_list NK_COMMA partition_item */ yytestcase(yyruleno==487);
      case 540: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==540);
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-2].minor.yy376, yymsp[0].minor.yy476); }
  yymsp[-2].minor.yy376 = yylhsminor.yy376;
        break;
      case 125: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy476 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 126: /* speed_opt ::= */
      case 297: /* bufsize_opt ::= */ yytestcase(yyruleno==297);
{ yymsp[1].minor.yy508 = 0; }
        break;
      case 127: /* speed_opt ::= MAX_SPEED NK_INTEGER */
      case 298: /* bufsize_opt ::= BUFSIZE NK_INTEGER */ yytestcase(yyruleno==298);
{ yymsp[-1].minor.yy508 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 128: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 130: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==130);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy845, yymsp[-5].minor.yy476, yymsp[-3].minor.yy376, yymsp[-1].minor.yy376, yymsp[0].minor.yy476); }
        break;
      case 129: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy376); }
        break;
      case 131: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy376); }
        break;
      case 132: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy845, yymsp[0].minor.yy476); }
        break;
      case 133: /* cmd ::= ALTER TABLE alter_table_clause */
      case 322: /* cmd ::= query_or_subquery */ yytestcase(yyruleno==322);
{ pCxt->pRootNode = yymsp[0].minor.yy476; }
        break;
      case 134: /* cmd ::= ALTER STABLE alter_table_clause */
{ pCxt->pRootNode = setAlterSuperTableType(yymsp[0].minor.yy476); }
        break;
      case 135: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy476 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy476, yymsp[0].minor.yy476); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 136: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy476 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy476, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy701, yymsp[0].minor.yy532); }
  yymsp[-4].minor.yy476 = yylhsminor.yy476;
        break;
      case 137: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy476 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy476, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy701); }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 138: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy476 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy476, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy701, yymsp[0].minor.yy532); }
  yymsp[-4].minor.yy476 = yylhsminor.yy476;
        break;
      case 139: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy476 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy476, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy701, &yymsp[0].minor.yy701); }
  yymsp[-4].minor.yy476 = yylhsminor.yy476;
        break;
      case 140: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy476 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy476, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy701, yymsp[0].minor.yy532); }
  yymsp[-4].minor.yy476 = yylhsminor.yy476;
        break;
      case 141: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy476 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy476, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy701); }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 142: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy476 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy476, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy701, yymsp[0].minor.yy532); }
  yymsp[-4].minor.yy476 = yylhsminor.yy476;
        break;
      case 143: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy476 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy476, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy701, &yymsp[0].minor.yy701); }
  yymsp[-4].minor.yy476 = yylhsminor.yy476;
        break;
      case 144: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy476 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy476, &yymsp[-2].minor.yy701, yymsp[0].minor.yy476); }
  yymsp[-5].minor.yy476 = yylhsminor.yy476;
        break;
      case 146: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 149: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==149);
      case 421: /* when_then_list ::= when_then_list when_then_expr */ yytestcase(yyruleno==421);
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-1].minor.yy376, yymsp[0].minor.yy476); }
  yymsp[-1].minor.yy376 = yylhsminor.yy376;
        break;
      case 147: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_cols_opt TAGS NK_LP expression_list NK_RP table_options */
{ yylhsminor.yy476 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy845, yymsp[-8].minor.yy476, yymsp[-6].minor.yy476, yymsp[-5].minor.yy376, yymsp[-2].minor.yy376, yymsp[0].minor.yy476); }
  yymsp[-9].minor.yy476 = yylhsminor.yy476;
        break;
      case 150: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy476 = createDropTableClause(pCxt, yymsp[-1].minor.yy845, yymsp[0].minor.yy476); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 151: /* specific_cols_opt ::= */
      case 182: /* tags_def_opt ::= */ yytestcase(yyruleno==182);
      case 252: /* tag_list_opt ::= */ yytestcase(yyruleno==252);
      case 301: /* col_list_opt ::= */ yytestcase(yyruleno==301);
      case 484: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==484);
      case 507: /* group_by_clause_opt ::= */ yytestcase(yyruleno==507);
      case 526: /* order_by_clause_opt ::= */ yytestcase(yyruleno==526);
{ yymsp[1].minor.yy376 = NULL; }
        break;
      case 152: /* specific_cols_opt ::= NK_LP col_name_list NK_RP */
      case 302: /* col_list_opt ::= NK_LP col_name_list NK_RP */ yytestcase(yyruleno==302);
{ yymsp[-2].minor.yy376 = yymsp[-1].minor.yy376; }
        break;
      case 153: /* full_table_name ::= table_name */
{ yylhsminor.yy476 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy701, NULL); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 154: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy476 = createRealTableNode(pCxt, &yymsp[-2].minor.yy701, &yymsp[0].minor.yy701, NULL); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 157: /* column_def ::= column_name type_name */
{ yylhsminor.yy476 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy701, yymsp[0].minor.yy532, NULL); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 158: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy476 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy701, yymsp[-2].minor.yy532, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 159: /* type_name ::= BOOL */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 160: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 161: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 162: /* type_name ::= INT */
      case 163: /* type_name ::= INTEGER */ yytestcase(yyruleno==163);
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 164: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 165: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 166: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 167: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy532 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 168: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 169: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy532 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 170: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy532 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 171: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy532 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 172: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy532 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 173: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy532 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 174: /* type_name ::= JSON */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 175: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy532 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 176: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 177: /* type_name ::= BLOB */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 178: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy532 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 179: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy532 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 180: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy532 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 181: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy532 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 183: /* tags_def_opt ::= tags_def */
      case 413: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==413);
{ yylhsminor.yy376 = yymsp[0].minor.yy376; }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 184: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy376 = yymsp[-1].minor.yy376; }
        break;
      case 185: /* table_options ::= */
{ yymsp[1].minor.yy476 = createDefaultTableOptions(pCxt); }
        break;
      case 186: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy476 = setTableOption(pCxt, yymsp[-2].minor.yy476, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 187: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy476 = setTableOption(pCxt, yymsp[-2].minor.yy476, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy376); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 188: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy476 = setTableOption(pCxt, yymsp[-2].minor.yy476, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy376); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 189: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy476 = setTableOption(pCxt, yymsp[-4].minor.yy476, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy376); }
  yymsp[-4].minor.yy476 = yylhsminor.yy476;
        break;
      case 190: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy476 = setTableOption(pCxt, yymsp[-2].minor.yy476, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 191: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy476 = setTableOption(pCxt, yymsp[-4].minor.yy476, TABLE_OPTION_SMA, yymsp[-1].minor.yy376); }
  yymsp[-4].minor.yy476 = yylhsminor.yy476;
        break;
      case 192: /* table_options ::= table_options DELETE_MARK duration_list */
{ yylhsminor.yy476 = setTableOption(pCxt, yymsp[-2].minor.yy476, TABLE_OPTION_DELETE_MARK, yymsp[0].minor.yy376); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 193: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy476 = createAlterTableOptions(pCxt); yylhsminor.yy476 = setTableOption(pCxt, yylhsminor.yy476, yymsp[0].minor.yy893.type, &yymsp[0].minor.yy893.val); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 194: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy476 = setTableOption(pCxt, yymsp[-1].minor.yy476, yymsp[0].minor.yy893.type, &yymsp[0].minor.yy893.val); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 195: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy893.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy893.val = yymsp[0].minor.yy0; }
        break;
      case 196: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy893.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy893.val = yymsp[0].minor.yy0; }
        break;
      case 197: /* duration_list ::= duration_literal */
      case 377: /* expression_list ::= expr_or_subquery */ yytestcase(yyruleno==377);
{ yylhsminor.yy376 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy476)); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 198: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 378: /* expression_list ::= expression_list NK_COMMA expr_or_subquery */ yytestcase(yyruleno==378);
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-2].minor.yy376, releaseRawExprNode(pCxt, yymsp[0].minor.yy476)); }
  yymsp[-2].minor.yy376 = yylhsminor.yy376;
        break;
      case 201: /* rollup_func_name ::= function_name */
{ yylhsminor.yy476 = createFunctionNode(pCxt, &yymsp[0].minor.yy701, NULL); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 202: /* rollup_func_name ::= FIRST */
      case 203: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==203);
      case 256: /* tag_item ::= QTAGS */ yytestcase(yyruleno==256);
{ yylhsminor.yy476 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 206: /* col_name ::= column_name */
      case 257: /* tag_item ::= column_name */ yytestcase(yyruleno==257);
{ yylhsminor.yy476 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy701); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 207: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT); }
        break;
      case 208: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT); }
        break;
      case 209: /* cmd ::= SHOW USER PRIVILEGES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USER_PRIVILEGES_STMT); }
        break;
      case 210: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT); }
        break;
      case 211: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy476, yymsp[0].minor.yy476, OP_TYPE_LIKE); }
        break;
      case 212: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy476, yymsp[0].minor.yy476, OP_TYPE_LIKE); }
        break;
      case 213: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy476, NULL, OP_TYPE_LIKE); }
        break;
      case 214: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT); }
        break;
      case 215: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT); }
        break;
      case 216: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT); }
        break;
      case 217: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[0].minor.yy476, yymsp[-1].minor.yy476, OP_TYPE_EQUAL); }
        break;
      case 218: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT); }
        break;
      case 219: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 220: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT); }
        break;
      case 221: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT); }
        break;
      case 222: /* cmd ::= SHOW LICENCES */
      case 223: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==223);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCES_STMT); }
        break;
      case 224: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy701); }
        break;
      case 225: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy476); }
        break;
      case 226: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy476); }
        break;
      case 227: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT); }
        break;
      case 228: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT); }
        break;
      case 229: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT); }
        break;
      case 230: /* cmd ::= SHOW VARIABLES */
      case 231: /* cmd ::= SHOW CLUSTER VARIABLES */ yytestcase(yyruleno==231);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLES_STMT); }
        break;
      case 232: /* cmd ::= SHOW LOCAL VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LOCAL_VARIABLES_STMT); }
        break;
      case 233: /* cmd ::= SHOW DNODE NK_INTEGER VARIABLES like_pattern_opt */
{ pCxt->pRootNode = createShowDnodeVariablesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[-2].minor.yy0), yymsp[0].minor.yy476); }
        break;
      case 234: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT); }
        break;
      case 235: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT); }
        break;
      case 236: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT); }
        break;
      case 237: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT); }
        break;
      case 238: /* cmd ::= SHOW TABLE DISTRIBUTED full_table_name */
{ pCxt->pRootNode = createShowTableDistributedStmt(pCxt, yymsp[0].minor.yy476); }
        break;
      case 239: /* cmd ::= SHOW CONSUMERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONSUMERS_STMT); }
        break;
      case 240: /* cmd ::= SHOW SUBSCRIPTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SUBSCRIPTIONS_STMT); }
        break;
      case 241: /* cmd ::= SHOW TAGS FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmtWithCond(pCxt, QUERY_NODE_SHOW_TAGS_STMT, yymsp[0].minor.yy476, yymsp[-1].minor.yy476, OP_TYPE_EQUAL); }
        break;
      case 242: /* cmd ::= SHOW TABLE TAGS tag_list_opt FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowTableTagsStmt(pCxt, yymsp[-1].minor.yy476, yymsp[0].minor.yy476, yymsp[-3].minor.yy376); }
        break;
      case 243: /* cmd ::= SHOW VNODES NK_INTEGER */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0), NULL); }
        break;
      case 244: /* cmd ::= SHOW VNODES NK_STRING */
{ pCxt->pRootNode = createShowVnodesStmt(pCxt, NULL, createValueNode(pCxt, TSDB_DATA_TYPE_VARCHAR, &yymsp[0].minor.yy0)); }
        break;
      case 245: /* db_name_cond_opt ::= */
      case 250: /* from_db_opt ::= */ yytestcase(yyruleno==250);
{ yymsp[1].minor.yy476 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 246: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy476 = createIdentifierValueNode(pCxt, &yymsp[-1].minor.yy701); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 247: /* like_pattern_opt ::= */
      case 310: /* subtable_opt ::= */ yytestcase(yyruleno==310);
      case 423: /* case_when_else_opt ::= */ yytestcase(yyruleno==423);
      case 453: /* from_clause_opt ::= */ yytestcase(yyruleno==453);
      case 482: /* where_clause_opt ::= */ yytestcase(yyruleno==482);
      case 491: /* twindow_clause_opt ::= */ yytestcase(yyruleno==491);
      case 497: /* sliding_opt ::= */ yytestcase(yyruleno==497);
      case 499: /* fill_opt ::= */ yytestcase(yyruleno==499);
      case 511: /* having_clause_opt ::= */ yytestcase(yyruleno==511);
      case 513: /* range_opt ::= */ yytestcase(yyruleno==513);
      case 515: /* every_opt ::= */ yytestcase(yyruleno==515);
      case 528: /* slimit_clause_opt ::= */ yytestcase(yyruleno==528);
      case 532: /* limit_clause_opt ::= */ yytestcase(yyruleno==532);
{ yymsp[1].minor.yy476 = NULL; }
        break;
      case 248: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 249: /* table_name_cond ::= table_name */
{ yylhsminor.yy476 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy701); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 251: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy476 = createIdentifierValueNode(pCxt, &yymsp[0].minor.yy701); }
        break;
      case 255: /* tag_item ::= TBNAME */
{ yylhsminor.yy476 = setProjectionAlias(pCxt, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL), &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 258: /* tag_item ::= column_name column_alias */
{ yylhsminor.yy476 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-1].minor.yy701), &yymsp[0].minor.yy701); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 259: /* tag_item ::= column_name AS column_alias */
{ yylhsminor.yy476 = setProjectionAlias(pCxt, createColumnNode(pCxt, NULL, &yymsp[-2].minor.yy701), &yymsp[0].minor.yy701); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 260: /* cmd ::= CREATE SMA INDEX not_exists_opt full_table_name ON full_table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy845, yymsp[-3].minor.yy476, yymsp[-1].minor.yy476, NULL, yymsp[0].minor.yy476); }
        break;
      case 261: /* cmd ::= CREATE INDEX not_exists_opt full_table_name ON full_table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_NORMAL, yymsp[-6].minor.yy845, yymsp[-5].minor.yy476, yymsp[-3].minor.yy476, yymsp[-1].minor.yy376, NULL); }
        break;
      case 262: /* cmd ::= DROP INDEX exists_opt full_table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-1].minor.yy845, yymsp[0].minor.yy476); }
        break;
      case 263: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-9].minor.yy476 = createIndexOption(pCxt, yymsp[-7].minor.yy376, releaseRawExprNode(pCxt, yymsp[-3].minor.yy476), NULL, yymsp[-1].minor.yy476, yymsp[0].minor.yy476); }
        break;
      case 264: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt sma_stream_opt */
{ yymsp[-11].minor.yy476 = createIndexOption(pCxt, yymsp[-9].minor.yy376, releaseRawExprNode(pCxt, yymsp[-5].minor.yy476), releaseRawExprNode(pCxt, yymsp[-3].minor.yy476), yymsp[-1].minor.yy476, yymsp[0].minor.yy476); }
        break;
      case 267: /* func ::= sma_func_name NK_LP expression_list NK_RP */
{ yylhsminor.yy476 = createFunctionNode(pCxt, &yymsp[-3].minor.yy701, yymsp[-1].minor.yy376); }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 273: /* sma_stream_opt ::= */
      case 303: /* stream_options ::= */ yytestcase(yyruleno==303);
{ yymsp[1].minor.yy476 = createStreamOptions(pCxt); }
        break;
      case 274: /* sma_stream_opt ::= sma_stream_opt WATERMARK duration_literal */
      case 307: /* stream_options ::= stream_options WATERMARK duration_literal */ yytestcase(yyruleno==307);
{ ((SStreamOptions*)yymsp[-2].minor.yy476)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy476); yylhsminor.yy476 = yymsp[-2].minor.yy476; }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 275: /* sma_stream_opt ::= sma_stream_opt MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy476)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy476); yylhsminor.yy476 = yymsp[-2].minor.yy476; }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 276: /* sma_stream_opt ::= sma_stream_opt DELETE_MARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy476)->pDeleteMark = releaseRawExprNode(pCxt, yymsp[0].minor.yy476); yylhsminor.yy476 = yymsp[-2].minor.yy476; }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 277: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_or_subquery */
{ pCxt->pRootNode = createCreateTopicStmtUseQuery(pCxt, yymsp[-3].minor.yy845, &yymsp[-2].minor.yy701, yymsp[0].minor.yy476); }
        break;
      case 278: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-4].minor.yy845, &yymsp[-3].minor.yy701, &yymsp[0].minor.yy701, false); }
        break;
      case 279: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmtUseDb(pCxt, yymsp[-6].minor.yy845, &yymsp[-5].minor.yy701, &yymsp[0].minor.yy701, true); }
        break;
      case 280: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-4].minor.yy845, &yymsp[-3].minor.yy701, yymsp[0].minor.yy476, false); }
        break;
      case 281: /* cmd ::= CREATE TOPIC not_exists_opt topic_name WITH META AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmtUseTable(pCxt, yymsp[-6].minor.yy845, &yymsp[-5].minor.yy701, yymsp[0].minor.yy476, true); }
        break;
      case 282: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy845, &yymsp[0].minor.yy701); }
        break;
      case 283: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy845, &yymsp[-2].minor.yy701, &yymsp[0].minor.yy701); }
        break;
      case 284: /* cmd ::= DESC full_table_name */
      case 285: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==285);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy476); }
        break;
      case 286: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 287: /* cmd ::= EXPLAIN analyze_opt explain_options query_or_subquery */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy845, yymsp[-1].minor.yy476, yymsp[0].minor.yy476); }
        break;
      case 290: /* explain_options ::= */
{ yymsp[1].minor.yy476 = createDefaultExplainOptions(pCxt); }
        break;
      case 291: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy476 = setExplainVerbose(pCxt, yymsp[-2].minor.yy476, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 292: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy476 = setExplainRatio(pCxt, yymsp[-2].minor.yy476, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 293: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy845, yymsp[-8].minor.yy845, &yymsp[-5].minor.yy701, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy532, yymsp[0].minor.yy508); }
        break;
      case 294: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy845, &yymsp[0].minor.yy701); }
        break;
      case 299: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options INTO full_table_name col_list_opt tags_def_opt subtable_opt AS query_or_subquery */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-9].minor.yy845, &yymsp[-8].minor.yy701, yymsp[-5].minor.yy476, yymsp[-7].minor.yy476, yymsp[-3].minor.yy376, yymsp[-2].minor.yy476, yymsp[0].minor.yy476, yymsp[-4].minor.yy376); }
        break;
      case 300: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy845, &yymsp[0].minor.yy701); }
        break;
      case 304: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy476)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy476 = yymsp[-2].minor.yy476; }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 305: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy476)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy476 = yymsp[-2].minor.yy476; }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 306: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy476)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy476)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy476); yylhsminor.yy476 = yymsp[-3].minor.yy476; }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 308: /* stream_options ::= stream_options IGNORE EXPIRED NK_INTEGER */
{ ((SStreamOptions*)yymsp[-3].minor.yy476)->ignoreExpired = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy476 = yymsp[-3].minor.yy476; }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 309: /* stream_options ::= stream_options FILL_HISTORY NK_INTEGER */
{ ((SStreamOptions*)yymsp[-2].minor.yy476)->fillHistory = taosStr2Int8(yymsp[0].minor.yy0.z, NULL, 10); yylhsminor.yy476 = yymsp[-2].minor.yy476; }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 311: /* subtable_opt ::= SUBTABLE NK_LP expression NK_RP */
      case 498: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */ yytestcase(yyruleno==498);
      case 516: /* every_opt ::= EVERY NK_LP duration_literal NK_RP */ yytestcase(yyruleno==516);
{ yymsp[-3].minor.yy476 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy476); }
        break;
      case 312: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 313: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 314: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 315: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 316: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 317: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy376); }
        break;
      case 318: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 319: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy376 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 321: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy476, yymsp[0].minor.yy476); }
        break;
      case 323: /* cmd ::= INSERT INTO full_table_name NK_LP col_name_list NK_RP query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-4].minor.yy476, yymsp[-2].minor.yy376, yymsp[0].minor.yy476); }
        break;
      case 324: /* cmd ::= INSERT INTO full_table_name query_or_subquery */
{ pCxt->pRootNode = createInsertStmt(pCxt, yymsp[-1].minor.yy476, NULL, yymsp[0].minor.yy476); }
        break;
      case 325: /* literal ::= NK_INTEGER */
{ yylhsminor.yy476 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 326: /* literal ::= NK_FLOAT */
{ yylhsminor.yy476 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 327: /* literal ::= NK_STRING */
{ yylhsminor.yy476 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 328: /* literal ::= NK_BOOL */
{ yylhsminor.yy476 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 329: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 330: /* literal ::= duration_literal */
      case 340: /* signed_literal ::= signed */ yytestcase(yyruleno==340);
      case 360: /* expr_or_subquery ::= expression */ yytestcase(yyruleno==360);
      case 361: /* expression ::= literal */ yytestcase(yyruleno==361);
      case 362: /* expression ::= pseudo_column */ yytestcase(yyruleno==362);
      case 363: /* expression ::= column_reference */ yytestcase(yyruleno==363);
      case 364: /* expression ::= function_expression */ yytestcase(yyruleno==364);
      case 365: /* expression ::= case_when_expression */ yytestcase(yyruleno==365);
      case 396: /* function_expression ::= literal_func */ yytestcase(yyruleno==396);
      case 445: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==445);
      case 449: /* boolean_primary ::= predicate */ yytestcase(yyruleno==449);
      case 451: /* common_expression ::= expr_or_subquery */ yytestcase(yyruleno==451);
      case 452: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==452);
      case 455: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==455);
      case 457: /* table_reference ::= table_primary */ yytestcase(yyruleno==457);
      case 458: /* table_reference ::= joined_table */ yytestcase(yyruleno==458);
      case 462: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==462);
      case 518: /* query_simple ::= query_specification */ yytestcase(yyruleno==518);
      case 519: /* query_simple ::= union_query_expression */ yytestcase(yyruleno==519);
      case 522: /* query_simple_or_subquery ::= query_simple */ yytestcase(yyruleno==522);
      case 524: /* query_or_subquery ::= query_expression */ yytestcase(yyruleno==524);
{ yylhsminor.yy476 = yymsp[0].minor.yy476; }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 331: /* literal ::= NULL */
{ yylhsminor.yy476 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 332: /* literal ::= NK_QUESTION */
{ yylhsminor.yy476 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 333: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy476 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 334: /* signed ::= NK_INTEGER */
{ yylhsminor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 335: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_UBIGINT, &yymsp[0].minor.yy0); }
        break;
      case 336: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 337: /* signed ::= NK_FLOAT */
{ yylhsminor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 338: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 339: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 341: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 342: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 343: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 344: /* signed_literal ::= duration_literal */
      case 346: /* signed_literal ::= literal_func */ yytestcase(yyruleno==346);
      case 416: /* star_func_para ::= expr_or_subquery */ yytestcase(yyruleno==416);
      case 478: /* select_item ::= common_expression */ yytestcase(yyruleno==478);
      case 488: /* partition_item ::= expr_or_subquery */ yytestcase(yyruleno==488);
      case 523: /* query_simple_or_subquery ::= subquery */ yytestcase(yyruleno==523);
      case 525: /* query_or_subquery ::= subquery */ yytestcase(yyruleno==525);
      case 538: /* search_condition ::= common_expression */ yytestcase(yyruleno==538);
{ yylhsminor.yy476 = releaseRawExprNode(pCxt, yymsp[0].minor.yy476); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 345: /* signed_literal ::= NULL */
{ yylhsminor.yy476 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 347: /* signed_literal ::= NK_QUESTION */
{ yylhsminor.yy476 = createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 366: /* expression ::= NK_LP expression NK_RP */
      case 450: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==450);
      case 537: /* subquery ::= NK_LP subquery NK_RP */ yytestcase(yyruleno==537);
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy476)); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 367: /* expression ::= NK_PLUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy476));
                                                                                  }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 368: /* expression ::= NK_MINUS expr_or_subquery */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy476), NULL));
                                                                                  }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 369: /* expression ::= expr_or_subquery NK_PLUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476))); 
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 370: /* expression ::= expr_or_subquery NK_MINUS expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476))); 
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 371: /* expression ::= expr_or_subquery NK_STAR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476))); 
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 372: /* expression ::= expr_or_subquery NK_SLASH expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476))); 
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 373: /* expression ::= expr_or_subquery NK_REM expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476)));
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 374: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 375: /* expression ::= expr_or_subquery NK_BITAND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476)));
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 376: /* expression ::= expr_or_subquery NK_BITOR expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_BIT_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476)));
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 379: /* column_reference ::= column_name */
{ yylhsminor.yy476 = createRawExprNode(pCxt, &yymsp[0].minor.yy701, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy701)); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 380: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy701, &yymsp[0].minor.yy701, createColumnNode(pCxt, &yymsp[-2].minor.yy701, &yymsp[0].minor.yy701)); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 381: /* pseudo_column ::= ROWTS */
      case 382: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==382);
      case 384: /* pseudo_column ::= QSTART */ yytestcase(yyruleno==384);
      case 385: /* pseudo_column ::= QEND */ yytestcase(yyruleno==385);
      case 386: /* pseudo_column ::= QDURATION */ yytestcase(yyruleno==386);
      case 387: /* pseudo_column ::= WSTART */ yytestcase(yyruleno==387);
      case 388: /* pseudo_column ::= WEND */ yytestcase(yyruleno==388);
      case 389: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==389);
      case 390: /* pseudo_column ::= IROWTS */ yytestcase(yyruleno==390);
      case 391: /* pseudo_column ::= ISFILLED */ yytestcase(yyruleno==391);
      case 392: /* pseudo_column ::= QTAGS */ yytestcase(yyruleno==392);
      case 398: /* literal_func ::= NOW */ yytestcase(yyruleno==398);
{ yylhsminor.yy476 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 383: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy701, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy701)))); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 393: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 394: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==394);
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy701, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy701, yymsp[-1].minor.yy376)); }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 395: /* function_expression ::= CAST NK_LP expr_or_subquery AS type_name NK_RP */
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy476), yymsp[-1].minor.yy532)); }
  yymsp[-5].minor.yy476 = yylhsminor.yy476;
        break;
      case 397: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy701, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy701, NULL)); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 412: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy376 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 417: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 481: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==481);
{ yylhsminor.yy476 = createColumnNode(pCxt, &yymsp[-2].minor.yy701, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 418: /* case_when_expression ::= CASE when_then_list case_when_else_opt END */
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, NULL, yymsp[-2].minor.yy376, yymsp[-1].minor.yy476)); }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 419: /* case_when_expression ::= CASE common_expression when_then_list case_when_else_opt END */
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-4].minor.yy0, &yymsp[0].minor.yy0, createCaseWhenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy476), yymsp[-2].minor.yy376, yymsp[-1].minor.yy476)); }
  yymsp[-4].minor.yy476 = yylhsminor.yy476;
        break;
      case 422: /* when_then_expr ::= WHEN common_expression THEN common_expression */
{ yymsp[-3].minor.yy476 = createWhenThenNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476)); }
        break;
      case 424: /* case_when_else_opt ::= ELSE common_expression */
{ yymsp[-1].minor.yy476 = releaseRawExprNode(pCxt, yymsp[0].minor.yy476); }
        break;
      case 425: /* predicate ::= expr_or_subquery compare_op expr_or_subquery */
      case 430: /* predicate ::= expr_or_subquery in_op in_predicate_value */ yytestcase(yyruleno==430);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy128, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476)));
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 426: /* predicate ::= expr_or_subquery BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy476), releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476)));
                                                                                  }
  yymsp[-4].minor.yy476 = yylhsminor.yy476;
        break;
      case 427: /* predicate ::= expr_or_subquery NOT BETWEEN expr_or_subquery AND expr_or_subquery */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy476), releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476)));
                                                                                  }
  yymsp[-5].minor.yy476 = yylhsminor.yy476;
        break;
      case 428: /* predicate ::= expr_or_subquery IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), NULL));
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 429: /* predicate ::= expr_or_subquery IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy476), NULL));
                                                                                  }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 431: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy128 = OP_TYPE_LOWER_THAN; }
        break;
      case 432: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy128 = OP_TYPE_GREATER_THAN; }
        break;
      case 433: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy128 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 434: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy128 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 435: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy128 = OP_TYPE_NOT_EQUAL; }
        break;
      case 436: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy128 = OP_TYPE_EQUAL; }
        break;
      case 437: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy128 = OP_TYPE_LIKE; }
        break;
      case 438: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy128 = OP_TYPE_NOT_LIKE; }
        break;
      case 439: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy128 = OP_TYPE_MATCH; }
        break;
      case 440: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy128 = OP_TYPE_NMATCH; }
        break;
      case 441: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy128 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 442: /* in_op ::= IN */
{ yymsp[0].minor.yy128 = OP_TYPE_IN; }
        break;
      case 443: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy128 = OP_TYPE_NOT_IN; }
        break;
      case 444: /* in_predicate_value ::= NK_LP literal_list NK_RP */
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy376)); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 446: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy476), NULL));
                                                                                  }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 447: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476)));
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 448: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy476);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy476);
                                                                                    yylhsminor.yy476 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), releaseRawExprNode(pCxt, yymsp[0].minor.yy476)));
                                                                                  }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 454: /* from_clause_opt ::= FROM table_reference_list */
      case 483: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==483);
      case 512: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==512);
{ yymsp[-1].minor.yy476 = yymsp[0].minor.yy476; }
        break;
      case 456: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy476 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy476, yymsp[0].minor.yy476, NULL); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 459: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy476 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy701, &yymsp[0].minor.yy701); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 460: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy476 = createRealTableNode(pCxt, &yymsp[-3].minor.yy701, &yymsp[-1].minor.yy701, &yymsp[0].minor.yy701); }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 461: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy476 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy476), &yymsp[0].minor.yy701); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 463: /* alias_opt ::= */
{ yymsp[1].minor.yy701 = nil_token;  }
        break;
      case 465: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy701 = yymsp[0].minor.yy701; }
        break;
      case 466: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 467: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==467);
{ yymsp[-2].minor.yy476 = yymsp[-1].minor.yy476; }
        break;
      case 468: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy476 = createJoinTableNode(pCxt, yymsp[-4].minor.yy288, yymsp[-5].minor.yy476, yymsp[-2].minor.yy476, yymsp[0].minor.yy476); }
  yymsp[-5].minor.yy476 = yylhsminor.yy476;
        break;
      case 469: /* join_type ::= */
{ yymsp[1].minor.yy288 = JOIN_TYPE_INNER; }
        break;
      case 470: /* join_type ::= INNER */
{ yymsp[0].minor.yy288 = JOIN_TYPE_INNER; }
        break;
      case 471: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause_opt where_clause_opt partition_by_clause_opt range_opt every_opt fill_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-11].minor.yy476 = createSelectStmt(pCxt, yymsp[-10].minor.yy845, yymsp[-9].minor.yy376, yymsp[-8].minor.yy476);
                                                                                    yymsp[-11].minor.yy476 = addWhereClause(pCxt, yymsp[-11].minor.yy476, yymsp[-7].minor.yy476);
                                                                                    yymsp[-11].minor.yy476 = addPartitionByClause(pCxt, yymsp[-11].minor.yy476, yymsp[-6].minor.yy376);
                                                                                    yymsp[-11].minor.yy476 = addWindowClauseClause(pCxt, yymsp[-11].minor.yy476, yymsp[-2].minor.yy476);
                                                                                    yymsp[-11].minor.yy476 = addGroupByClause(pCxt, yymsp[-11].minor.yy476, yymsp[-1].minor.yy376);
                                                                                    yymsp[-11].minor.yy476 = addHavingClause(pCxt, yymsp[-11].minor.yy476, yymsp[0].minor.yy476);
                                                                                    yymsp[-11].minor.yy476 = addRangeClause(pCxt, yymsp[-11].minor.yy476, yymsp[-5].minor.yy476);
                                                                                    yymsp[-11].minor.yy476 = addEveryClause(pCxt, yymsp[-11].minor.yy476, yymsp[-4].minor.yy476);
                                                                                    yymsp[-11].minor.yy476 = addFillClause(pCxt, yymsp[-11].minor.yy476, yymsp[-3].minor.yy476);
                                                                                  }
        break;
      case 474: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy845 = false; }
        break;
      case 477: /* select_item ::= NK_STAR */
{ yylhsminor.yy476 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy476 = yylhsminor.yy476;
        break;
      case 479: /* select_item ::= common_expression column_alias */
      case 489: /* partition_item ::= expr_or_subquery column_alias */ yytestcase(yyruleno==489);
{ yylhsminor.yy476 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy476), &yymsp[0].minor.yy701); }
  yymsp[-1].minor.yy476 = yylhsminor.yy476;
        break;
      case 480: /* select_item ::= common_expression AS column_alias */
      case 490: /* partition_item ::= expr_or_subquery AS column_alias */ yytestcase(yyruleno==490);
{ yylhsminor.yy476 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), &yymsp[0].minor.yy701); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 485: /* partition_by_clause_opt ::= PARTITION BY partition_list */
      case 508: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==508);
      case 527: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==527);
{ yymsp[-2].minor.yy376 = yymsp[0].minor.yy376; }
        break;
      case 492: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy476 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy476), releaseRawExprNode(pCxt, yymsp[-1].minor.yy476)); }
        break;
      case 493: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expr_or_subquery NK_RP */
{ yymsp[-3].minor.yy476 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy476)); }
        break;
      case 494: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy476 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy476), NULL, yymsp[-1].minor.yy476, yymsp[0].minor.yy476); }
        break;
      case 495: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy476 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy476), releaseRawExprNode(pCxt, yymsp[-3].minor.yy476), yymsp[-1].minor.yy476, yymsp[0].minor.yy476); }
        break;
      case 496: /* twindow_clause_opt ::= EVENT_WINDOW START WITH search_condition END WITH search_condition */
{ yymsp[-6].minor.yy476 = createEventWindowNode(pCxt, yymsp[-3].minor.yy476, yymsp[0].minor.yy476); }
        break;
      case 500: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy476 = createFillNode(pCxt, yymsp[-1].minor.yy690, NULL); }
        break;
      case 501: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy476 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy376)); }
        break;
      case 502: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy690 = FILL_MODE_NONE; }
        break;
      case 503: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy690 = FILL_MODE_PREV; }
        break;
      case 504: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy690 = FILL_MODE_NULL; }
        break;
      case 505: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy690 = FILL_MODE_LINEAR; }
        break;
      case 506: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy690 = FILL_MODE_NEXT; }
        break;
      case 509: /* group_by_list ::= expr_or_subquery */
{ yylhsminor.yy376 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy476))); }
  yymsp[0].minor.yy376 = yylhsminor.yy376;
        break;
      case 510: /* group_by_list ::= group_by_list NK_COMMA expr_or_subquery */
{ yylhsminor.yy376 = addNodeToList(pCxt, yymsp[-2].minor.yy376, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy476))); }
  yymsp[-2].minor.yy376 = yylhsminor.yy376;
        break;
      case 514: /* range_opt ::= RANGE NK_LP expr_or_subquery NK_COMMA expr_or_subquery NK_RP */
{ yymsp[-5].minor.yy476 = createInterpTimeRange(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy476), releaseRawExprNode(pCxt, yymsp[-1].minor.yy476)); }
        break;
      case 517: /* query_expression ::= query_simple order_by_clause_opt slimit_clause_opt limit_clause_opt */
{
                                                                                    yylhsminor.yy476 = addOrderByClause(pCxt, yymsp[-3].minor.yy476, yymsp[-2].minor.yy376);
                                                                                    yylhsminor.yy476 = addSlimitClause(pCxt, yylhsminor.yy476, yymsp[-1].minor.yy476);
                                                                                    yylhsminor.yy476 = addLimitClause(pCxt, yylhsminor.yy476, yymsp[0].minor.yy476);
                                                                                  }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 520: /* union_query_expression ::= query_simple_or_subquery UNION ALL query_simple_or_subquery */
{ yylhsminor.yy476 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy476, yymsp[0].minor.yy476); }
  yymsp[-3].minor.yy476 = yylhsminor.yy476;
        break;
      case 521: /* union_query_expression ::= query_simple_or_subquery UNION query_simple_or_subquery */
{ yylhsminor.yy476 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy476, yymsp[0].minor.yy476); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 529: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 533: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==533);
{ yymsp[-1].minor.yy476 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 530: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 534: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==534);
{ yymsp[-3].minor.yy476 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 531: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 535: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==535);
{ yymsp[-3].minor.yy476 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 536: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy476 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy476); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 541: /* sort_specification ::= expr_or_subquery ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy476 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy476), yymsp[-1].minor.yy554, yymsp[0].minor.yy697); }
  yymsp[-2].minor.yy476 = yylhsminor.yy476;
        break;
      case 542: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy554 = ORDER_ASC; }
        break;
      case 543: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy554 = ORDER_ASC; }
        break;
      case 544: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy554 = ORDER_DESC; }
        break;
      case 545: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy697 = NULL_ORDER_DEFAULT; }
        break;
      case 546: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy697 = NULL_ORDER_FIRST; }
        break;
      case 547: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy697 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  } else if (TSDB_CODE_PAR_DB_NOT_SPECIFIED == pCxt->errCode && TK_NK_FLOAT == TOKEN.type) {
    pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
