/*
** 2000-05-29
**
** The author disclaims copyright to this source code.  In place of
** a legal notice, here is a blessing:
**
**    May you do good and not evil.
**    May you find forgiveness for yourself and forgive others.
**    May you share freely, never taking more than you give.
**
*************************************************************************
** Driver template for the LEMON parser generator.
**
** The "lemon" program processes an LALR(1) input grammar file, then uses
** this template to construct a parser.  The "lemon" program inserts text
** at each "%%" line.  Also, any "P-a-r-s-e" identifer prefix (without the
** interstitial "-" characters) contained in this template is changed into
** the value of the %name directive from the grammar.  Otherwise, the content
** of this template is copied straight through into the generate parser
** source file.
**
** The following is the concatenation of all %include directives from the
** input grammar file:
*/
#include <stdio.h>
#include <assert.h>
/************ Begin %include sections from the grammar ************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <stdbool.h>

#define ALLOW_FORBID_FUNC

#include "functionMgt.h"
#include "nodes.h"
#include "parToken.h"
#include "ttokendef.h"
#include "parAst.h"

#define YYSTACKDEPTH 0
/**************** End of %include directives **********************************/
/* These constants specify the various numeric values for terminal symbols
** in a format understandable to "makeheaders".  This section is blank unless
** "lemon" is run with the "-m" command-line option.
***************** Begin makeheaders token definitions *************************/
/**************** End makeheaders token definitions ***************************/

/* The next sections is a series of control #defines.
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used to store the integer codes
**                       that represent terminal and non-terminal symbols.
**                       "unsigned char" is used if there are fewer than
**                       256 symbols.  Larger types otherwise.
**    YYNOCODE           is a number of type YYCODETYPE that is not used for
**                       any terminal or nonterminal symbol.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       (also known as: "terminal symbols") have fall-back
**                       values which should be used if the original symbol
**                       would not parse.  This permits keywords to sometimes
**                       be used as identifiers, for example.
**    YYACTIONTYPE       is the data type used for "action codes" - numbers
**                       that indicate what to do in response to the next
**                       token.
**    ParseTOKENTYPE     is the data type used for minor type for terminal
**                       symbols.  Background: A "minor type" is a semantic
**                       value associated with a terminal or non-terminal
**                       symbols.  For example, for an "ID" terminal symbol,
**                       the minor type might be the name of the identifier.
**                       Each non-terminal can have a different minor type.
**                       Terminal symbols all have the same minor type, though.
**                       This macros defines the minor type for terminal 
**                       symbols.
**    YYMINORTYPE        is the data type used for all minor types.
**                       This is typically a union of many types, one of
**                       which is ParseTOKENTYPE.  The entry in the union
**                       for terminal symbols is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    ParseARG_SDECL     A static variable declaration for the %extra_argument
**    ParseARG_PDECL     A parameter declaration for the %extra_argument
**    ParseARG_PARAM     Code to pass %extra_argument as a subroutine parameter
**    ParseARG_STORE     Code to store %extra_argument into yypParser
**    ParseARG_FETCH     Code to extract %extra_argument from yypParser
**    ParseCTX_*         As ParseARG_ except for %extra_context
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYNTOKEN           Number of terminal symbols
**    YY_MAX_SHIFT       Maximum value for shift actions
**    YY_MIN_SHIFTREDUCE Minimum value for shift-reduce actions
**    YY_MAX_SHIFTREDUCE Maximum value for shift-reduce actions
**    YY_ERROR_ACTION    The yy_action[] code for syntax error
**    YY_ACCEPT_ACTION   The yy_action[] code for accept
**    YY_NO_ACTION       The yy_action[] code for no-op
**    YY_MIN_REDUCE      Minimum value for reduce actions
**    YY_MAX_REDUCE      Maximum value for reduce actions
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/************* Begin control #defines *****************************************/
#define YYCODETYPE unsigned short int
#define YYNOCODE 360
#define YYACTIONTYPE unsigned short int
#define ParseTOKENTYPE  SToken 
typedef union {
  int yyinit;
  ParseTOKENTYPE yy0;
  EFillMode yy54;
  int32_t yy100;
  bool yy137;
  int64_t yy189;
  SToken yy209;
  ENullOrder yy217;
  SDataType yy304;
  EOperatorType yy380;
  SNodeList* yy424;
  EOrder yy578;
  SAlterOption yy605;
  EJoinType yy612;
  SNode* yy632;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define ParseARG_SDECL  SAstCreateContext* pCxt ;
#define ParseARG_PDECL , SAstCreateContext* pCxt 
#define ParseARG_PARAM ,pCxt 
#define ParseARG_FETCH  SAstCreateContext* pCxt =yypParser->pCxt ;
#define ParseARG_STORE yypParser->pCxt =pCxt ;
#define ParseCTX_SDECL
#define ParseCTX_PDECL
#define ParseCTX_PARAM
#define ParseCTX_FETCH
#define ParseCTX_STORE
#define YYFALLBACK 1
#define YYNSTATE             623
#define YYNRULE              459
#define YYNTOKEN             239
#define YY_MAX_SHIFT         622
#define YY_MIN_SHIFTREDUCE   913
#define YY_MAX_SHIFTREDUCE   1371
#define YY_ERROR_ACTION      1372
#define YY_ACCEPT_ACTION     1373
#define YY_NO_ACTION         1374
#define YY_MIN_REDUCE        1375
#define YY_MAX_REDUCE        1833
/************* End control #defines *******************************************/
#define YY_NLOOKAHEAD ((int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])))

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.  
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N <= YY_MAX_SHIFT             Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   N between YY_MIN_SHIFTREDUCE       Shift to an arbitrary state then
**     and YY_MAX_SHIFTREDUCE           reduce by rule N-YY_MIN_SHIFTREDUCE.
**
**   N == YY_ERROR_ACTION               A syntax error has occurred.
**
**   N == YY_ACCEPT_ACTION              The parser accepts its input.
**
**   N == YY_NO_ACTION                  No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
**   N between YY_MIN_REDUCE            Reduce by rule N-YY_MIN_REDUCE
**     and YY_MAX_REDUCE
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as either:
**
**    (A)   N = yy_action[ yy_shift_ofst[S] + X ]
**    (B)   N = yy_default[S]
**
** The (A) formula is preferred.  The B formula is used instead if
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X.
**
** The formulas above are for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
**
*********** Begin parsing tables **********************************************/
#define YY_ACTTAB_COUNT (2186)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   361, 1680,  355, 1667,   28,  233,  300,  395, 1373,  396,
 /*    10 */  1407,  943,   35,   33, 1664, 1667, 1495,  496,  317,   57,
 /*    20 */   309,   24, 1185, 1558,   73,  403, 1664,  396, 1407, 1696,
 /*    30 */   299,   36,   34,   32,   31,   30, 1491,  520,  281, 1556,
 /*    40 */  1660, 1666, 1650, 1811,  519, 1499,  115, 1183,  535,  947,
 /*    50 */   948,  539, 1660, 1666,  134,  149, 1387,  500,   14, 1808,
 /*    60 */    35,   33, 1312,  539, 1191, 1434,  500,  325,  309, 1709,
 /*    70 */  1185,  203,   82, 1681,  522, 1683, 1684,  518,   26,  539,
 /*    80 */   321,    1, 1749, 1551, 1553,  113,  283, 1745,   36,   34,
 /*    90 */    32,   31,   30,  496, 1211, 1183,   56,   56, 1811,   67,
 /*   100 */   222, 1756,  495,  619,  494,  523,   14, 1811, 1811,   39,
 /*   110 */   151, 1398, 1191,  312, 1808, 1600,  496, 1254, 1255,  151,
 /*   120 */   149, 1397,  115, 1808, 1808,  595,  594,  593,  324,    2,
 /*   130 */   592,  591,  590,  117,  585,  584,  583,  582,  581,  580,
 /*   140 */   579,  578,  125,  574, 1437,  115,   36,   34,   32,   31,
 /*   150 */    30,  619, 1650,   36,   34,   32,   31,   30, 1186,  135,
 /*   160 */  1184,  113, 1650, 1463,   96, 1254, 1255,   95,   94,   93,
 /*   170 */    92,   91,   90,   89,   88,   87,  147, 1756, 1757,  577,
 /*   180 */  1761, 1478, 1189, 1190,  113, 1236, 1237, 1239, 1240, 1241,
 /*   190 */  1242, 1243,  515,  537, 1251, 1252, 1253, 1256,  498,  146,
 /*   200 */  1756, 1757,  535, 1761,  448,  447, 1186, 1696, 1184,  446,
 /*   210 */   152,  144,  112,  443,  196,  489,  442,  441,  440,   35,
 /*   220 */    33,  224,  496, 1326, 1545,  152,  152,  309, 1638, 1185,
 /*   230 */  1189, 1190, 1376, 1236, 1237, 1239, 1240, 1241, 1242, 1243,
 /*   240 */   515,  537, 1251, 1252, 1253, 1256,   36,   34,   32,   31,
 /*   250 */    30,  115,  488,   96, 1183, 1680,   95,   94,   93,   92,
 /*   260 */    91,   90,   89,   88,   87,   14, 1209,   35,   33,   66,
 /*   270 */   282, 1191, 1680,  334,  535,  309,  313, 1185,   36,   34,
 /*   280 */    32,   31,   30, 1696,  132,  316,  315, 1811,    2,  536,
 /*   290 */   113,  520,  536, 1508, 1484, 1199, 1650,  197,  519, 1810,
 /*   300 */  1696,  533, 1183, 1808,  154,  148, 1756, 1757,  520, 1761,
 /*   310 */   619,  500,  960, 1650,  959,  519, 1223, 1276, 1506, 1191,
 /*   320 */  1192, 1506, 1336, 1709, 1254, 1255,  269, 1681,  522, 1683,
 /*   330 */  1684,  518, 1210,  539,   56,   38,    8, 1191,  413, 1281,
 /*   340 */  1709,  961,  536,  136, 1681,  522, 1683, 1684,  518,  319,
 /*   350 */   539,  413, 1811, 1375,  359, 1167, 1168,  132,  619,  482,
 /*   360 */  1334, 1335, 1337, 1338,  151, 1186, 1508, 1184, 1808, 1552,
 /*   370 */  1553, 1506, 1254, 1255,   25,  460,  540,  105,  104,  103,
 /*   380 */   102,  101,  100,   99,   98,   97,  501, 1825,  458, 1189,
 /*   390 */  1190,  346, 1236, 1237, 1239, 1240, 1241, 1242, 1243,  515,
 /*   400 */   537, 1251, 1252, 1253, 1256,   56,  615,  614, 1811,  448,
 /*   410 */   447,  348,  344, 1186,  446, 1184, 1368,  112,  443,  472,
 /*   420 */   150,  442,  441,  440, 1808,  490,   35,   33, 1257, 1092,
 /*   430 */  1093, 1200,  394, 1195,  309,  398, 1185, 1189, 1190,  293,
 /*   440 */  1236, 1237, 1239, 1240, 1241, 1242, 1243,  515,  537, 1251,
 /*   450 */  1252, 1253, 1256,  462,  322, 1203,  402, 1811,  536,  398,
 /*   460 */  1811, 1183,  132,  152,  152,  152,  537, 1251, 1252, 1809,
 /*   470 */   360, 1508,  149, 1808,   35,   33, 1808, 1680, 1191,  400,
 /*   480 */   182,  354,  309,  353, 1185, 1207,  569, 1506,  294, 1549,
 /*   490 */   292,  291,  143,  436, 1811,    9, 1367,  438,  430,  426,
 /*   500 */   422,  418,  181,   11,   10, 1696,  149, 1558, 1311, 1183,
 /*   510 */  1808,   64,  536,  499,  314,  573,   64,  619, 1650,  437,
 /*   520 */   519, 1210, 1012, 1556,  370,  536, 1191,   65,  536,  111,
 /*   530 */   179, 1254, 1255, 1502,  152, 1482, 1185,  106, 1501, 1014,
 /*   540 */   106, 1506,   54,    9,  434, 1709, 1396,  439,   83, 1681,
 /*   550 */   522, 1683, 1684,  518, 1506,  539,  485, 1506, 1749,  536,
 /*   560 */   959, 1183,  302, 1745,  145,  619,   36,   34,   32,   31,
 /*   570 */    30,  371, 1186, 1208, 1184, 1497,  225,   79, 1191, 1254,
 /*   580 */  1255,  478, 1776,  385, 1288,  432, 1664, 1650, 1506,  178,
 /*   590 */   116,  170,  573,  175, 1763,  408, 1189, 1190, 1498, 1236,
 /*   600 */  1237, 1239, 1240, 1241, 1242, 1243,  515,  537, 1251, 1252,
 /*   610 */  1253, 1256, 1660, 1666,  168,  445,  444,  619, 1760, 1191,
 /*   620 */  1186, 1558, 1184,  539,  589,  587,  491,  486,  320,  163,
 /*   630 */   162,  576,  570,   35,   33, 1549, 1395, 1556,   32,   31,
 /*   640 */    30,  309,  571, 1185, 1189, 1190,  496, 1236, 1237, 1239,
 /*   650 */  1240, 1241, 1242, 1243,  515,  537, 1251, 1252, 1253, 1256,
 /*   660 */  1319,  123,  122,  568,  567,  566, 1209, 1262, 1183,  536,
 /*   670 */   536, 1394, 1186, 1209, 1184,  115,  536, 1650,  280,  565,
 /*   680 */  1207,  412, 1503, 1763,    7, 1191, 1209,  378, 1627, 1668,
 /*   690 */   390,  536,  469, 1393,  536,  500, 1189, 1190, 1506, 1506,
 /*   700 */  1664,  131,    2,  470,  133, 1506,  534, 1759,  391,  262,
 /*   710 */  1392,  504, 1650, 1391,  113, 1310,  536, 1493,  159, 1390,
 /*   720 */  1506,  260,   53, 1506,  619,   52, 1660, 1666,  246,  222,
 /*   730 */  1756,  495,  536,  494, 1650, 1389, 1811,  539, 1254, 1255,
 /*   740 */   523, 1386,  164,   62,  323, 1506,   61, 1763,  149, 1489,
 /*   750 */  1601, 1650, 1808, 1212, 1650,   36,   34,   32,   31,   30,
 /*   760 */  1650, 1506, 1591,  256,  502,  132, 1536,   56,  947,  948,
 /*   770 */  1388, 1758,  187,  161, 1509,  185, 1650, 1768, 1307, 1186,
 /*   780 */   389, 1184, 1650,  384,  383,  382,  381,  380,  377,  376,
 /*   790 */   375,  374,  373,  369,  368,  367,  366,  365,  364,  363,
 /*   800 */   362,  284, 1385, 1189, 1190,   81, 1236, 1237, 1239, 1240,
 /*   810 */  1241, 1242, 1243,  515,  537, 1251, 1252, 1253, 1256, 1384,
 /*   820 */   189, 1383,  438,  188,  507, 1223,  463,   36,   34,   32,
 /*   830 */    31,   30, 1238, 1274, 1382, 1558,   60,   59,  358, 1238,
 /*   840 */  1381,  158, 1680, 1650,  437, 1380, 1379,  352, 1378,  588,
 /*   850 */   191, 1557, 1238,  190,  193, 1424, 1307,  192,  279,  121,
 /*   860 */  1650,  342, 1650,  340,  336,  332,  155,  327,   11,   10,
 /*   870 */  1696, 1419,  512,  284, 1670, 1650, 1194,  449,  520, 1417,
 /*   880 */   209, 1650, 1193, 1650, 1275,  519, 1650, 1650,   46, 1650,
 /*   890 */   349,  212,   37,  451, 1680,   37,  152,  505,  500,   37,
 /*   900 */   474,  454, 1370, 1371,  200, 1274, 1280,  984,  514,  564,
 /*   910 */  1709, 1672,  483,   82, 1681,  522, 1683, 1684,  518,  235,
 /*   920 */   539,   78, 1696, 1749,  985,  219, 1464,  283, 1745, 1333,
 /*   930 */   499,   75,  214, 1282,  228, 1650, 1244,  519, 1697, 1811,
 /*   940 */  1140,   27,  307, 1269, 1270, 1271, 1272, 1273, 1277, 1278,
 /*   950 */  1279,  149,  119,  120, 1408, 1808, 1275,  121,  431, 1546,
 /*   960 */   237,   46, 1709, 1483, 1680,   83, 1681,  522, 1683, 1684,
 /*   970 */   518, 1481,  539, 1779,  227, 1749,  497,  230, 1280,  302,
 /*   980 */  1745,  145,  544,  120,  232,    3,  121,  107,  120, 1197,
 /*   990 */     5,  326, 1696,  528,  243, 1196, 1266, 1207, 1043, 1777,
 /*  1000 */   520,  329,  255,  333,  289, 1650, 1012,  519, 1151,  290,
 /*  1010 */   252,  372,  508,   27,  307, 1269, 1270, 1271, 1272, 1273,
 /*  1020 */  1277, 1278, 1279, 1071, 1075, 1593, 1680, 1082, 1080,  124,
 /*  1030 */   160,  379, 1709,  387,  386,   83, 1681,  522, 1683, 1684,
 /*  1040 */   518,  392,  539,  388, 1213, 1749,  393,  401, 1216,  302,
 /*  1050 */  1745, 1824, 1680,  404, 1696,  167,  571,  405,  169, 1215,
 /*  1060 */  1783,  406,  520, 1217,  571,  407,  172, 1650,  409,  519,
 /*  1070 */   174,  410, 1214,  411,  177,  123,  122,  568,  567,  566,
 /*  1080 */  1696,   63,  414,  123,  122,  568,  567,  566,  520,  433,
 /*  1090 */   180,  435, 1496, 1650, 1709,  519,  184,   83, 1681,  522,
 /*  1100 */  1683, 1684,  518,  253,  539,   86, 1680, 1749, 1492,  186,
 /*  1110 */   298,  302, 1745, 1824,  126, 1632,  127, 1631, 1494, 1490,
 /*  1120 */  1709,  198, 1806,   83, 1681,  522, 1683, 1684,  518,  128,
 /*  1130 */   539,  129,  464, 1749, 1696,  201,  471,  302, 1745, 1824,
 /*  1140 */   465,  204,  520,  207,  476, 1212,  475, 1650, 1767,  519,
 /*  1150 */   468,  484,  526, 1780,  473, 1790,  210,  481,  301, 1789,
 /*  1160 */   487,    6,  500,  493,  213,  480,  139, 1211, 1770,  218,
 /*  1170 */  1307,  220,  114,   40, 1709,  506,  509,  269, 1681,  522,
 /*  1180 */  1683, 1684,  518, 1764,  539, 1680,  303, 1827,   18, 1599,
 /*  1190 */   524,  525, 1050,  562,  561,  560, 1054,  559, 1056, 1057,
 /*  1200 */   558, 1059,  555, 1811, 1065,  552, 1067, 1068,  549,  546,
 /*  1210 */   221, 1680, 1730, 1696,  311,  149, 1598,  529,  530, 1808,
 /*  1220 */   531,  520,  239,  254,  241,   72, 1650, 1807,  519,  226,
 /*  1230 */    74, 1507,  257, 1550,  542,  503,  510,  229,  231, 1696,
 /*  1240 */  1479,  249,  618,  138,  259,  263,  270,  520,  264,  261,
 /*  1250 */  1644, 1643, 1650, 1709,  519,   47,   84, 1681,  522, 1683,
 /*  1260 */  1684,  518, 1680,  539,   58, 1642, 1749,  328, 1639,  330,
 /*  1270 */  1748, 1745,  331, 1178, 1179,  156,  335, 1637, 1680, 1709,
 /*  1280 */   337,  338,   84, 1681,  522, 1683, 1684,  518,  339,  539,
 /*  1290 */  1696,  341, 1749, 1636, 1635,  343,  511, 1745,  517, 1634,
 /*  1300 */   345, 1633,  347, 1650, 1617,  519, 1696,  350,  351, 1153,
 /*  1310 */  1154,  157, 1611, 1610,  520,  356,  357, 1609, 1608, 1650,
 /*  1320 */  1126,  519, 1586, 1585, 1584, 1583, 1582, 1581, 1580, 1579,
 /*  1330 */  1709, 1578, 1577,  277, 1681,  522, 1683, 1684,  518,  516,
 /*  1340 */   539,  513, 1721, 1576, 1575, 1574, 1709, 1573, 1572,   84,
 /*  1350 */  1681,  522, 1683, 1684,  518,  622,  539,  453, 1571, 1749,
 /*  1360 */  1570, 1569, 1568, 1567, 1746, 1566, 1680, 1565, 1564,  251,
 /*  1370 */   118, 1563,  461, 1128, 1562, 1561, 1560, 1559, 1436, 1404,
 /*  1380 */   142,  108, 1680,  109,  950,  397,  195,  611,  607,  603,
 /*  1390 */   599,  250,  165,  399, 1696,  949, 1403,  166,  456, 1625,
 /*  1400 */  1619,  110,  520,  450, 1607,  173,  171, 1650,  194,  519,
 /*  1410 */  1696, 1606, 1596, 1485,  978, 1435,   80,  176,  520,  244,
 /*  1420 */   479, 1433,  417, 1650, 1431,  519,  421, 1429,  416,  415,
 /*  1430 */   425,  419,  420,   51, 1709,  423,   50,  278, 1681,  522,
 /*  1440 */  1683, 1684,  518,  424,  539, 1680, 1427,  428,  427, 1416,
 /*  1450 */  1709,  429,  532,  273, 1681,  522, 1683, 1684,  518, 1415,
 /*  1460 */   539, 1402, 1487,   45, 1086, 1085, 1486, 1011, 1425, 1010,
 /*  1470 */  1009, 1680, 1008, 1696,  183,  586,  588, 1005, 1004,  477,
 /*  1480 */  1003,  520,  205, 1420,  452,  295, 1650,  296,  519,  297,
 /*  1490 */   492, 1418,  455, 1401, 1400,  457,  459,   85, 1624, 1696,
 /*  1500 */  1161, 1159, 1618,  199,  466, 1605,  130,  520, 1604, 1603,
 /*  1510 */   202, 1595, 1650, 1709,  519,  206,  136, 1681,  522, 1683,
 /*  1520 */  1684,  518, 1680,  539,   15,  306,    4,   37,   68,   43,
 /*  1530 */   211,  216, 1332, 1680,  208,  137,  215,   49,  467, 1709,
 /*  1540 */  1325,   48,  278, 1681,  522, 1683, 1684,  518,  217,  539,
 /*  1550 */  1696,   22,   69,   23, 1670,   42,   10, 1304,  517,  223,
 /*  1560 */  1826, 1696, 1303, 1650,   16,  519,  140,   17,   13,  520,
 /*  1570 */  1356, 1355,  304,   29, 1650, 1360,  519, 1361, 1350, 1359,
 /*  1580 */    41,  305, 1680,   19,  141, 1267, 1231,  308, 1246, 1245,
 /*  1590 */  1709,  153,  521,  277, 1681,  522, 1683, 1684,  518, 1680,
 /*  1600 */   539, 1709, 1722,  234,  278, 1681,  522, 1683, 1684,  518,
 /*  1610 */  1696,  539,   12, 1594,   20,  240,   21,  236,  520, 1330,
 /*  1620 */   238,  527,   70, 1650,   71,  519,  242, 1696, 1669,   75,
 /*  1630 */   245, 1712, 1201, 1049, 1248,  520,  310,  538,   44,  543,
 /*  1640 */  1650,  541,  519, 1072,  318, 1069,  545,  547,  548,  550,
 /*  1650 */  1709, 1066, 1680,  278, 1681,  522, 1683, 1684,  518, 1060,
 /*  1660 */   539, 1680,  551,  553,  554,  556,  557, 1709,  563, 1058,
 /*  1670 */   265, 1681,  522, 1683, 1684,  518, 1064,  539, 1063, 1062,
 /*  1680 */  1696, 1061,   76, 1081,   77,   55,  247, 1077,  520, 1696,
 /*  1690 */   976,  572,  993, 1650, 1000,  519, 1018,  520,  575,  248,
 /*  1700 */   998,  997, 1650,  996,  519, 1015,  995,  994,  992,  991,
 /*  1710 */  1013,  988, 1432,  987, 1680,  986,  983,  598,  982,  981,
 /*  1720 */  1709,  596,  597,  272, 1681,  522, 1683, 1684,  518, 1709,
 /*  1730 */   539, 1680,  274, 1681,  522, 1683, 1684,  518, 1430,  539,
 /*  1740 */   600,  601, 1696,  602, 1428,  604,  605,  606, 1426,  608,
 /*  1750 */   520,  610,  609, 1414,  613, 1650,  612,  519, 1413, 1696,
 /*  1760 */  1399,  616,  617, 1374, 1187,  258,  620,  520, 1374,  621,
 /*  1770 */  1374, 1374, 1650, 1374,  519, 1374, 1374, 1374, 1374, 1374,
 /*  1780 */  1374, 1374, 1709, 1374, 1374,  266, 1681,  522, 1683, 1684,
 /*  1790 */   518, 1374,  539, 1680, 1374, 1374, 1374, 1374, 1374, 1709,
 /*  1800 */  1374, 1374,  275, 1681,  522, 1683, 1684,  518, 1374,  539,
 /*  1810 */  1374, 1374, 1680, 1374, 1374, 1374, 1374, 1374, 1374, 1374,
 /*  1820 */  1374, 1696, 1374, 1374, 1374, 1374, 1374, 1374, 1374,  520,
 /*  1830 */  1374, 1374, 1374, 1374, 1650, 1374,  519, 1374, 1374, 1374,
 /*  1840 */  1696, 1374, 1374, 1374, 1374, 1374, 1374, 1374,  520, 1374,
 /*  1850 */  1374, 1374, 1374, 1650, 1374,  519, 1374, 1374, 1374, 1374,
 /*  1860 */  1374, 1709, 1374, 1374,  267, 1681,  522, 1683, 1684,  518,
 /*  1870 */  1680,  539, 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1680,
 /*  1880 */  1709, 1374, 1374,  276, 1681,  522, 1683, 1684,  518, 1374,
 /*  1890 */   539, 1374, 1374, 1680, 1374, 1374, 1374, 1374, 1696, 1374,
 /*  1900 */  1374, 1374, 1374, 1374, 1374, 1374,  520, 1696, 1374, 1374,
 /*  1910 */  1374, 1650, 1374,  519, 1374,  520, 1374, 1374, 1374, 1374,
 /*  1920 */  1650, 1696,  519, 1374, 1374, 1374, 1374, 1374, 1374,  520,
 /*  1930 */  1374, 1374, 1374, 1374, 1650, 1374,  519, 1374, 1709, 1374,
 /*  1940 */  1374,  268, 1681,  522, 1683, 1684,  518, 1709,  539, 1374,
 /*  1950 */  1692, 1681,  522, 1683, 1684,  518, 1374,  539, 1374, 1374,
 /*  1960 */  1374, 1709, 1374, 1680, 1691, 1681,  522, 1683, 1684,  518,
 /*  1970 */  1374,  539, 1680, 1374, 1374, 1374, 1374, 1374, 1374, 1374,
 /*  1980 */  1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374,
 /*  1990 */  1374, 1696, 1374, 1374, 1374, 1374, 1374, 1374, 1374,  520,
 /*  2000 */  1696, 1374, 1374, 1374, 1650, 1374,  519, 1374,  520, 1374,
 /*  2010 */  1374, 1374, 1374, 1650, 1374,  519, 1374, 1374, 1374, 1374,
 /*  2020 */  1374, 1374, 1374, 1374, 1374, 1680, 1374, 1374, 1374, 1374,
 /*  2030 */  1374, 1709, 1374, 1374, 1690, 1681,  522, 1683, 1684,  518,
 /*  2040 */  1709,  539, 1680,  287, 1681,  522, 1683, 1684,  518, 1374,
 /*  2050 */   539, 1374, 1374, 1696, 1374, 1374, 1374, 1374, 1374, 1374,
 /*  2060 */  1374,  520, 1374, 1374, 1374, 1374, 1650, 1374,  519, 1374,
 /*  2070 */  1696, 1374, 1374, 1374, 1374, 1374, 1374, 1374,  520, 1374,
 /*  2080 */  1374, 1374, 1374, 1650, 1374,  519, 1374, 1374, 1374, 1374,
 /*  2090 */  1374, 1680, 1374, 1709, 1374, 1374,  286, 1681,  522, 1683,
 /*  2100 */  1684,  518, 1374,  539, 1374, 1374, 1374, 1680, 1374, 1374,
 /*  2110 */  1709, 1374, 1374,  288, 1681,  522, 1683, 1684,  518, 1696,
 /*  2120 */   539, 1374, 1374, 1374, 1374, 1374, 1374,  520, 1374, 1374,
 /*  2130 */  1374, 1374, 1650, 1374,  519, 1696, 1374, 1374, 1374, 1374,
 /*  2140 */  1374, 1374, 1374,  520, 1374, 1374, 1374, 1374, 1650, 1374,
 /*  2150 */   519, 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1374, 1709,
 /*  2160 */  1374, 1374,  285, 1681,  522, 1683, 1684,  518, 1374,  539,
 /*  2170 */  1374, 1374, 1374, 1374, 1374, 1709, 1374, 1374,  271, 1681,
 /*  2180 */   522, 1683, 1684,  518, 1374,  539,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */   249,  242,  298,  272,  324,  325,  275,  245,  239,  247,
 /*    10 */   248,    4,   12,   13,  283,  272,  271,  249,  275,    4,
 /*    20 */    20,    2,   22,  270,  252,  245,  283,  247,  248,  270,
 /*    30 */   277,   12,   13,   14,   15,   16,  271,  278,  287,  286,
 /*    40 */   309,  310,  283,  339,  285,  273,  278,   47,   20,   42,
 /*    50 */    43,  320,  309,  310,  241,  351,  243,  298,   58,  355,
 /*    60 */    12,   13,   14,  320,   64,    0,  298,  298,   20,  310,
 /*    70 */    22,   55,  313,  314,  315,  316,  317,  318,    2,  320,
 /*    80 */   281,   81,  323,  284,  285,  317,  327,  328,   12,   13,
 /*    90 */    14,   15,   16,  249,   20,   47,   81,   81,  339,   83,
 /*   100 */   332,  333,  334,  103,  336,  285,   58,  339,  339,   81,
 /*   110 */   351,  242,   64,  293,  355,  295,  249,  117,  118,  351,
 /*   120 */   351,  242,  278,  355,  355,   60,   61,   62,   63,   81,
 /*   130 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   140 */    75,   76,   77,   78,    0,  278,   12,   13,   14,   15,
 /*   150 */    16,  103,  283,   12,   13,   14,   15,   16,  158,  255,
 /*   160 */   160,  317,  283,  259,   21,  117,  118,   24,   25,   26,
 /*   170 */    27,   28,   29,   30,   31,   32,  332,  333,  334,  258,
 /*   180 */   336,  260,  182,  183,  317,  185,  186,  187,  188,  189,
 /*   190 */   190,  191,  192,  193,  194,  195,  196,  197,  331,  332,
 /*   200 */   333,  334,   20,  336,   60,   61,  158,  270,  160,   65,
 /*   210 */   210,  269,   68,   69,  113,  278,   72,   73,   74,   12,
 /*   220 */    13,  147,  249,   82,  282,  210,  210,   20,    0,   22,
 /*   230 */   182,  183,    0,  185,  186,  187,  188,  189,  190,  191,
 /*   240 */   192,  193,  194,  195,  196,  197,   12,   13,   14,   15,
 /*   250 */    16,  278,  315,   21,   47,  242,   24,   25,   26,   27,
 /*   260 */    28,   29,   30,   31,   32,   58,   20,   12,   13,  168,
 /*   270 */   169,   64,  242,   45,   20,   20,  262,   22,   12,   13,
 /*   280 */    14,   15,   16,  270,  270,   12,   13,  339,   81,  249,
 /*   290 */   317,  278,  249,  279,    0,   22,  283,  112,  285,  351,
 /*   300 */   270,  261,   47,  355,  261,  332,  333,  334,  278,  336,
 /*   310 */   103,  298,   20,  283,   22,  285,   82,  141,  278,   64,
 /*   320 */    47,  278,  182,  310,  117,  118,  313,  314,  315,  316,
 /*   330 */   317,  318,   20,  320,   81,   81,   81,   64,   57,  163,
 /*   340 */   310,   49,  249,  313,  314,  315,  316,  317,  318,  262,
 /*   350 */   320,   57,  339,    0,  261,  170,  171,  270,  103,  219,
 /*   360 */   220,  221,  222,  223,  351,  158,  279,  160,  355,  284,
 /*   370 */   285,  278,  117,  118,  198,   21,  103,   24,   25,   26,
 /*   380 */    27,   28,   29,   30,   31,   32,  356,  357,   34,  182,
 /*   390 */   183,  153,  185,  186,  187,  188,  189,  190,  191,  192,
 /*   400 */   193,  194,  195,  196,  197,   81,  250,  251,  339,   60,
 /*   410 */    61,  173,  174,  158,   65,  160,  150,   68,   69,  298,
 /*   420 */   351,   72,   73,   74,  355,   20,   12,   13,   14,  117,
 /*   430 */   118,  158,  246,  160,   20,  249,   22,  182,  183,   35,
 /*   440 */   185,  186,  187,  188,  189,  190,  191,  192,  193,  194,
 /*   450 */   195,  196,  197,  298,  262,  182,  246,  339,  249,  249,
 /*   460 */   339,   47,  270,  210,  210,  210,  193,  194,  195,  351,
 /*   470 */   261,  279,  351,  355,   12,   13,  355,  242,   64,   14,
 /*   480 */    33,  157,   20,  159,   22,   20,  280,  278,   84,  283,
 /*   490 */    86,   87,   45,   89,  339,   81,  230,   93,   51,   52,
 /*   500 */    53,   54,   55,    1,    2,  270,  351,  270,    4,   47,
 /*   510 */   355,  254,  249,  278,  277,   57,  254,  103,  283,  115,
 /*   520 */   285,   20,   47,  286,  261,  249,   64,   80,  249,  267,
 /*   530 */    83,  117,  118,  276,  210,    0,   22,  261,  276,   64,
 /*   540 */   261,  278,    3,   81,  268,  310,  242,  268,  313,  314,
 /*   550 */   315,  316,  317,  318,  278,  320,  145,  278,  323,  249,
 /*   560 */    22,   47,  327,  328,  329,  103,   12,   13,   14,   15,
 /*   570 */    16,  261,  158,   20,  160,  272,  341,  252,   64,  117,
 /*   580 */   118,  346,  347,   75,   82,   47,  283,  283,  278,  142,
 /*   590 */   265,  144,   57,  146,  311,  148,  182,  183,  273,  185,
 /*   600 */   186,  187,  188,  189,  190,  191,  192,  193,  194,  195,
 /*   610 */   196,  197,  309,  310,  167,  256,  257,  103,  335,   64,
 /*   620 */   158,  270,  160,  320,  256,  257,  215,  216,  277,  121,
 /*   630 */   122,   64,  280,   12,   13,  283,  242,  286,   14,   15,
 /*   640 */    16,   20,   93,   22,  182,  183,  249,  185,  186,  187,
 /*   650 */   188,  189,  190,  191,  192,  193,  194,  195,  196,  197,
 /*   660 */    14,  112,  113,  114,  115,  116,   20,   14,   47,  249,
 /*   670 */   249,  242,  158,   20,  160,  278,  249,  283,   18,   92,
 /*   680 */    20,  261,  261,  311,   37,   64,   20,   27,  261,  272,
 /*   690 */    30,  249,  302,  242,  249,  298,  182,  183,  278,  278,
 /*   700 */   283,  147,   81,  261,   18,  278,  261,  335,   48,   23,
 /*   710 */   242,   41,  283,  242,  317,  211,  249,  271,   55,  242,
 /*   720 */   278,   35,   36,  278,  103,   39,  309,  310,  261,  332,
 /*   730 */   333,  334,  249,  336,  283,  242,  339,  320,  117,  118,
 /*   740 */   285,  242,   56,   80,  261,  278,   83,  311,  351,  271,
 /*   750 */   295,  283,  355,   20,  283,   12,   13,   14,   15,   16,
 /*   760 */   283,  278,  278,  263,  225,  270,  266,   81,   42,   43,
 /*   770 */   243,  335,   85,  289,  279,   88,  283,  208,  209,  158,
 /*   780 */   120,  160,  283,  123,  124,  125,  126,  127,  128,  129,
 /*   790 */   130,  131,  132,  133,  134,  135,  136,  137,  138,  139,
 /*   800 */   140,   58,  242,  182,  183,  119,  185,  186,  187,  188,
 /*   810 */   189,  190,  191,  192,  193,  194,  195,  196,  197,  242,
 /*   820 */    85,  242,   93,   88,   41,   82,  306,   12,   13,   14,
 /*   830 */    15,   16,  186,   90,  242,  270,  150,  151,  152,  186,
 /*   840 */   242,  155,  242,  283,  115,  242,  242,  161,  242,   41,
 /*   850 */    85,  286,  186,   88,   85,    0,  209,   88,  172,   41,
 /*   860 */   283,  175,  283,  177,  178,  179,  180,  181,    1,    2,
 /*   870 */   270,    0,   58,   58,   44,  283,   47,   22,  278,    0,
 /*   880 */   147,  283,   47,  283,  141,  285,  283,  283,   41,  283,
 /*   890 */    82,   41,   41,   22,  242,   41,  210,  227,  298,   41,
 /*   900 */    82,   22,  117,  118,  271,   90,  163,   47,  271,  271,
 /*   910 */   310,   81,  349,  313,  314,  315,  316,  317,  318,   41,
 /*   920 */   320,   81,  270,  323,   64,  343,  259,  327,  328,   82,
 /*   930 */   278,   91,   82,   82,  358,  283,   82,  285,  270,  339,
 /*   940 */    82,  198,  199,  200,  201,  202,  203,  204,  205,  206,
 /*   950 */   207,  351,   41,   41,  248,  355,  141,   41,  250,  282,
 /*   960 */    82,   41,  310,    0,  242,  313,  314,  315,  316,  317,
 /*   970 */   318,    0,  320,  312,  352,  323,  337,  352,  163,  327,
 /*   980 */   328,  329,   41,   41,  352,  340,   41,   41,   41,  160,
 /*   990 */   212,  308,  270,   82,   82,  160,  182,   20,   82,  347,
 /*  1000 */   278,  249,   82,   45,  307,  283,   47,  285,  156,  256,
 /*  1010 */   300,  249,  229,  198,  199,  200,  201,  202,  203,  204,
 /*  1020 */   205,  206,  207,   82,   82,  249,  242,   82,   82,   82,
 /*  1030 */    40,  290,  310,  141,  288,  313,  314,  315,  316,  317,
 /*  1040 */   318,  249,  320,  288,   20,  323,  244,  244,   20,  327,
 /*  1050 */   328,  329,  242,  304,  270,  254,   93,  285,  254,   20,
 /*  1060 */   338,  297,  278,   20,   93,  299,  254,  283,  297,  285,
 /*  1070 */   254,  278,   20,  291,  254,  112,  113,  114,  115,  116,
 /*  1080 */   270,  254,  249,  112,  113,  114,  115,  116,  278,  244,
 /*  1090 */   254,  270,  270,  283,  310,  285,  270,  313,  314,  315,
 /*  1100 */   316,  317,  318,  304,  320,  249,  242,  323,  270,  270,
 /*  1110 */   244,  327,  328,  329,  270,  283,  270,  283,  270,  270,
 /*  1120 */   310,  252,  338,  313,  314,  315,  316,  317,  318,  270,
 /*  1130 */   320,  270,  166,  323,  270,  252,  249,  327,  328,  329,
 /*  1140 */   303,  252,  278,  252,  291,   20,  278,  283,  338,  285,
 /*  1150 */   285,  218,  217,  312,  297,  348,  294,  283,  283,  348,
 /*  1160 */   283,  224,  298,  149,  294,  213,  342,   20,  345,  344,
 /*  1170 */   209,  308,  278,   40,  310,  226,  228,  313,  314,  315,
 /*  1180 */   316,  317,  318,  311,  320,  242,  231,  359,   81,  294,
 /*  1190 */   283,  283,   94,   95,   96,   97,   98,   99,  100,  101,
 /*  1200 */   102,  103,  104,  339,  106,  107,  108,  109,  110,  111,
 /*  1210 */   330,  242,  326,  270,  283,  351,  294,  144,  292,  355,
 /*  1220 */   291,  278,  278,  266,  252,  252,  283,  354,  285,  353,
 /*  1230 */    81,  278,  249,  283,  274,  354,  354,  353,  353,  270,
 /*  1240 */   260,  252,  244,  305,  253,  264,  264,  278,  264,  240,
 /*  1250 */     0,    0,  283,  310,  285,  301,  313,  314,  315,  316,
 /*  1260 */   317,  318,  242,  320,   40,    0,  323,   72,    0,   47,
 /*  1270 */   327,  328,  176,   47,   47,   47,  176,    0,  242,  310,
 /*  1280 */    47,   47,  313,  314,  315,  316,  317,  318,  176,  320,
 /*  1290 */   270,  176,  323,    0,    0,   47,  327,  328,  278,    0,
 /*  1300 */    22,    0,   47,  283,    0,  285,  270,  163,  162,  158,
 /*  1310 */   160,   81,    0,    0,  278,  154,  153,    0,    0,  283,
 /*  1320 */    44,  285,    0,    0,    0,    0,    0,    0,    0,    0,
 /*  1330 */   310,    0,    0,  313,  314,  315,  316,  317,  318,  319,
 /*  1340 */   320,  321,  322,    0,    0,    0,  310,    0,    0,  313,
 /*  1350 */   314,  315,  316,  317,  318,   19,  320,    4,    0,  323,
 /*  1360 */     0,    0,    0,    0,  328,    0,  242,    0,    0,   33,
 /*  1370 */    40,    0,   19,   22,    0,    0,    0,    0,    0,    0,
 /*  1380 */    41,   45,  242,   37,   14,   44,   33,   51,   52,   53,
 /*  1390 */    54,   55,   40,   44,  270,   14,    0,   38,   45,    0,
 /*  1400 */     0,   37,  278,   50,    0,  149,   37,  283,   55,  285,
 /*  1410 */   270,    0,    0,    0,   59,    0,   80,   37,  278,   83,
 /*  1420 */   296,    0,   37,  283,    0,  285,   37,    0,   45,   47,
 /*  1430 */    37,   47,   45,   80,  310,   47,   83,  313,  314,  315,
 /*  1440 */   316,  317,  318,   45,  320,  242,    0,   45,   47,    0,
 /*  1450 */   310,   37,  116,  313,  314,  315,  316,  317,  318,    0,
 /*  1460 */   320,    0,    0,   90,   47,   22,    0,   47,    0,   47,
 /*  1470 */    47,  242,   47,  270,   88,   41,   41,   47,   47,  143,
 /*  1480 */    47,  278,  146,    0,   48,   22,  283,   22,  285,   22,
 /*  1490 */   350,    0,   47,    0,    0,   22,   22,   20,    0,  270,
 /*  1500 */    47,  165,    0,  167,   22,    0,  164,  278,    0,    0,
 /*  1510 */   144,    0,  283,  310,  285,   37,  313,  314,  315,  316,
 /*  1520 */   317,  318,  242,  320,  214,  296,   41,   41,   81,   41,
 /*  1530 */    82,   41,   82,  242,  142,   81,   81,  147,  147,  310,
 /*  1540 */    82,  147,  313,  314,  315,  316,  317,  318,   44,  320,
 /*  1550 */   270,   81,   81,   41,   44,   41,    2,   82,  278,   44,
 /*  1560 */   357,  270,   82,  283,  214,  285,   44,   41,  214,  278,
 /*  1570 */    47,   47,   47,   81,  283,   47,  285,   82,   82,   47,
 /*  1580 */   208,   47,  242,   41,   44,  182,   22,  296,   82,   82,
 /*  1590 */   310,   44,  184,  313,  314,  315,  316,  317,  318,  242,
 /*  1600 */   320,  310,  322,   82,  313,  314,  315,  316,  317,  318,
 /*  1610 */   270,  320,   81,    0,   81,   37,   81,   81,  278,   82,
 /*  1620 */    81,  145,   81,  283,   81,  285,  142,  270,   44,   91,
 /*  1630 */    44,   81,   22,   22,   82,  278,  296,   81,   81,   47,
 /*  1640 */   283,   92,  285,   82,   47,   82,   81,   47,   81,   47,
 /*  1650 */   310,   82,  242,  313,  314,  315,  316,  317,  318,   82,
 /*  1660 */   320,  242,   81,   47,   81,   47,   81,  310,   93,   82,
 /*  1670 */   313,  314,  315,  316,  317,  318,  105,  320,  105,  105,
 /*  1680 */   270,  105,   81,   47,   81,   81,   41,   22,  278,  270,
 /*  1690 */    59,   58,   22,  283,   47,  285,   64,  278,   79,   41,
 /*  1700 */    47,   47,  283,   47,  285,   64,   47,   47,   47,   47,
 /*  1710 */    47,   47,    0,   47,  242,   47,   47,   37,   47,   47,
 /*  1720 */   310,   47,   45,  313,  314,  315,  316,  317,  318,  310,
 /*  1730 */   320,  242,  313,  314,  315,  316,  317,  318,    0,  320,
 /*  1740 */    47,   45,  270,   37,    0,   47,   45,   37,    0,   47,
 /*  1750 */   278,   37,   45,    0,   46,  283,   47,  285,    0,  270,
 /*  1760 */     0,   22,   21,  360,   22,   22,   21,  278,  360,   20,
 /*  1770 */   360,  360,  283,  360,  285,  360,  360,  360,  360,  360,
 /*  1780 */   360,  360,  310,  360,  360,  313,  314,  315,  316,  317,
 /*  1790 */   318,  360,  320,  242,  360,  360,  360,  360,  360,  310,
 /*  1800 */   360,  360,  313,  314,  315,  316,  317,  318,  360,  320,
 /*  1810 */   360,  360,  242,  360,  360,  360,  360,  360,  360,  360,
 /*  1820 */   360,  270,  360,  360,  360,  360,  360,  360,  360,  278,
 /*  1830 */   360,  360,  360,  360,  283,  360,  285,  360,  360,  360,
 /*  1840 */   270,  360,  360,  360,  360,  360,  360,  360,  278,  360,
 /*  1850 */   360,  360,  360,  283,  360,  285,  360,  360,  360,  360,
 /*  1860 */   360,  310,  360,  360,  313,  314,  315,  316,  317,  318,
 /*  1870 */   242,  320,  360,  360,  360,  360,  360,  360,  360,  242,
 /*  1880 */   310,  360,  360,  313,  314,  315,  316,  317,  318,  360,
 /*  1890 */   320,  360,  360,  242,  360,  360,  360,  360,  270,  360,
 /*  1900 */   360,  360,  360,  360,  360,  360,  278,  270,  360,  360,
 /*  1910 */   360,  283,  360,  285,  360,  278,  360,  360,  360,  360,
 /*  1920 */   283,  270,  285,  360,  360,  360,  360,  360,  360,  278,
 /*  1930 */   360,  360,  360,  360,  283,  360,  285,  360,  310,  360,
 /*  1940 */   360,  313,  314,  315,  316,  317,  318,  310,  320,  360,
 /*  1950 */   313,  314,  315,  316,  317,  318,  360,  320,  360,  360,
 /*  1960 */   360,  310,  360,  242,  313,  314,  315,  316,  317,  318,
 /*  1970 */   360,  320,  242,  360,  360,  360,  360,  360,  360,  360,
 /*  1980 */   360,  360,  360,  360,  360,  360,  360,  360,  360,  360,
 /*  1990 */   360,  270,  360,  360,  360,  360,  360,  360,  360,  278,
 /*  2000 */   270,  360,  360,  360,  283,  360,  285,  360,  278,  360,
 /*  2010 */   360,  360,  360,  283,  360,  285,  360,  360,  360,  360,
 /*  2020 */   360,  360,  360,  360,  360,  242,  360,  360,  360,  360,
 /*  2030 */   360,  310,  360,  360,  313,  314,  315,  316,  317,  318,
 /*  2040 */   310,  320,  242,  313,  314,  315,  316,  317,  318,  360,
 /*  2050 */   320,  360,  360,  270,  360,  360,  360,  360,  360,  360,
 /*  2060 */   360,  278,  360,  360,  360,  360,  283,  360,  285,  360,
 /*  2070 */   270,  360,  360,  360,  360,  360,  360,  360,  278,  360,
 /*  2080 */   360,  360,  360,  283,  360,  285,  360,  360,  360,  360,
 /*  2090 */   360,  242,  360,  310,  360,  360,  313,  314,  315,  316,
 /*  2100 */   317,  318,  360,  320,  360,  360,  360,  242,  360,  360,
 /*  2110 */   310,  360,  360,  313,  314,  315,  316,  317,  318,  270,
 /*  2120 */   320,  360,  360,  360,  360,  360,  360,  278,  360,  360,
 /*  2130 */   360,  360,  283,  360,  285,  270,  360,  360,  360,  360,
 /*  2140 */   360,  360,  360,  278,  360,  360,  360,  360,  283,  360,
 /*  2150 */   285,  360,  360,  360,  360,  360,  360,  360,  360,  310,
 /*  2160 */   360,  360,  313,  314,  315,  316,  317,  318,  360,  320,
 /*  2170 */   360,  360,  360,  360,  360,  310,  360,  360,  313,  314,
 /*  2180 */   315,  316,  317,  318,  360,  320,
};
#define YY_SHIFT_COUNT    (622)
#define YY_SHIFT_MIN      (0)
#define YY_SHIFT_MAX      (1760)
static const unsigned short int yy_shift_ofst[] = {
 /*     0 */   686,    0,    0,   48,  207,  207,  207,  207,  255,  255,
 /*    10 */   207,  207,  414,  462,  621,  462,  462,  462,  462,  462,
 /*    20 */   462,  462,  462,  462,  462,  462,  462,  462,  462,  462,
 /*    30 */   462,  462,  462,  462,  462,  462,  462,  462,  254,  254,
 /*    40 */    28,   28,   28,  273,  273,  273,  273,  324,   16,  253,
 /*    50 */   182,  182,    7,    7,   15,  312,  253,  253,  182,  182,
 /*    60 */   182,  182,  182,  182,  182,  281,  182,  182,  246,  405,
 /*    70 */   501,  246,  182,  182,  246,  182,  246,  246,  246,  182,
 /*    80 */   458,  660,  743,  815,  815,  143,  349,  514,  514,  514,
 /*    90 */   514,  514,  514,  514,  514,  514,  514,  514,  514,  514,
 /*   100 */   514,  514,  514,  514,  514,  514,  404,  312,  292,  465,
 /*   110 */   465,  294,  475,   74,   74,   74,  535,  475,  553,  501,
 /*   120 */   246,  246,  555,  555,  587,  567, 1098, 1098, 1098, 1098,
 /*   130 */  1098, 1098, 1098, 1336,  232,  144,  266,  140,  101,  411,
 /*   140 */   646,  653,  726,  538,  729,  733,  569,  647,  569,  539,
 /*   150 */   539,  539,  504,  666,  778,  977,  958,  959,  852,  977,
 /*   160 */   977,  990,  892,  892,  977, 1024, 1024, 1028,  281,  501,
 /*   170 */   281, 1039, 1043,  281, 1039,  281,  553, 1052,  281,  281,
 /*   180 */   977,  281, 1024,  246,  246,  246,  246,  246,  246,  246,
 /*   190 */   246,  246,  246,  246,  977, 1024,  555,  555, 1028,  458,
 /*   200 */   966,  501,  458,  977, 1039,  458,  553, 1052,  458, 1125,
 /*   210 */   933,  935,  555,  933,  935,  555,  555,  246,  937, 1014,
 /*   220 */   952,  778,  961,  553, 1147, 1133,  948,  949,  955,  948,
 /*   230 */   949,  948,  949, 1107,  935,  555,  555,  935,  555, 1073,
 /*   240 */   553, 1052,  458,  587,  458,  553, 1149,  555,  567,  977,
 /*   250 */   458, 1024, 2186, 2186, 2186, 2186, 2186, 2186, 2186,   65,
 /*   260 */   447,  353, 1353,  963,  971,  141,   19,   76,  554,  234,
 /*   270 */   549,  134,  134,  134,  134,  134,  134,  134,  134,  238,
 /*   280 */   663,  508,  185,  502,  176,  624,  624,  624,  624,  228,
 /*   290 */   808,  687,  735,  765,  769,  855,  871,  879,  354,  818,
 /*   300 */   847,  850,  867,  785,  670,  783,  851,  814,  854,  830,
 /*   310 */   858,  878,  911,  912,  916,  829,  835,  920,  941,  942,
 /*   320 */   945,  946,  947,  840,  860, 1250, 1251, 1224, 1265, 1195,
 /*   330 */  1268, 1222, 1096, 1226, 1227, 1228, 1100, 1277, 1233, 1234,
 /*   340 */  1112, 1293, 1115, 1294, 1248, 1299, 1278, 1301, 1255, 1304,
 /*   350 */  1230, 1144, 1146, 1150, 1151, 1312, 1313, 1161, 1163, 1317,
 /*   360 */  1318, 1276, 1322, 1323, 1324, 1325, 1326, 1327, 1328, 1329,
 /*   370 */  1331, 1332, 1343, 1344, 1345, 1347, 1348, 1358, 1360, 1361,
 /*   380 */  1330, 1362, 1363, 1365, 1367, 1368, 1371, 1351, 1374, 1375,
 /*   390 */  1376, 1377, 1378, 1379, 1352, 1346, 1339, 1370, 1341, 1381,
 /*   400 */  1349, 1396, 1359, 1364, 1399, 1400, 1404, 1369, 1256, 1411,
 /*   410 */  1412, 1380, 1413, 1355, 1415, 1421, 1382, 1383, 1385, 1424,
 /*   420 */  1384, 1387, 1389, 1427, 1388, 1398, 1393, 1446, 1401, 1402,
 /*   430 */  1414, 1449, 1459, 1461, 1462, 1373, 1386, 1417, 1443, 1466,
 /*   440 */  1420, 1422, 1423, 1425, 1434, 1435, 1430, 1431, 1433, 1468,
 /*   450 */  1463, 1483, 1465, 1436, 1491, 1467, 1445, 1493, 1473, 1494,
 /*   460 */  1474, 1477, 1498, 1390, 1453, 1502, 1342, 1482, 1391, 1366,
 /*   470 */  1505, 1508, 1509, 1394, 1511, 1447, 1478, 1392, 1485, 1486,
 /*   480 */  1310, 1448, 1488, 1450, 1454, 1455, 1470, 1458, 1490, 1504,
 /*   490 */  1510, 1471, 1512, 1350, 1475, 1480, 1515, 1372, 1514, 1522,
 /*   500 */  1495, 1526, 1354, 1496, 1523, 1524, 1525, 1528, 1532, 1534,
 /*   510 */  1496, 1554, 1403, 1542, 1506, 1492, 1507, 1540, 1531, 1533,
 /*   520 */  1547, 1564, 1408, 1535, 1521, 1537, 1536, 1539, 1476, 1541,
 /*   530 */  1613, 1578, 1484, 1543, 1538, 1584, 1586, 1550, 1552, 1556,
 /*   540 */  1610, 1557, 1549, 1561, 1592, 1597, 1565, 1563, 1600, 1567,
 /*   550 */  1569, 1602, 1581, 1577, 1616, 1583, 1587, 1618, 1585, 1571,
 /*   560 */  1573, 1574, 1576, 1611, 1575, 1601, 1603, 1636, 1604, 1645,
 /*   570 */  1645, 1665, 1631, 1633, 1647, 1632, 1619, 1658, 1653, 1654,
 /*   580 */  1656, 1659, 1660, 1670, 1661, 1662, 1641, 1434, 1663, 1435,
 /*   590 */  1664, 1666, 1668, 1669, 1671, 1672, 1712, 1674, 1677, 1680,
 /*   600 */  1738, 1693, 1696, 1706, 1744, 1698, 1701, 1710, 1748, 1702,
 /*   610 */  1707, 1714, 1753, 1709, 1708, 1758, 1760, 1739, 1741, 1742,
 /*   620 */  1743, 1745, 1749,
};
#define YY_REDUCE_COUNT (258)
#define YY_REDUCE_MIN   (-320)
#define YY_REDUCE_MAX   (1865)
static const short yy_reduce_ofst[] = {
 /*     0 */  -231, -241,  600,  235,  652,  722,  784,  810,   13,  864,
 /*    10 */   943,  969, 1020,   30, 1036, 1124, 1140, 1203, 1229, 1280,
 /*    20 */  1291, 1340, 1357, 1410, 1419, 1472, 1489, 1551, 1570, 1628,
 /*    30 */  1637, 1651, 1721, 1730, 1783, 1800, 1849, 1865, -232,  397,
 /*    40 */  -133, -156,  -27, -269, -257,  303,  417, -296,  121,  155,
 /*    50 */   276,  279, -238, -220,  -52, -201,   69,  118,   43,   93,
 /*    60 */   209,  263,  310,  420,  421,  262,  427,  442, -247,  -63,
 /*    70 */  -180,   14,   40,  445,  237,  467,   87,  351,  192,  483,
 /*    80 */   325, -249, -320, -320, -320, -187,  -96, -131, -121,  304,
 /*    90 */   394,  429,  451,  468,  471,  477,  493,  499,  560,  577,
 /*   100 */   579,  592,  598,  603,  604,  606,  -58,   85,  156,  186,
 /*   110 */   210,  257,  359,  283,  372,  436, -228,  368,  484,  455,
 /*   120 */   495,  565,  206,  352,  500,  -79, -255, -235,  446,  478,
 /*   130 */   633,  637,  638,  390,  527,  667,  576,  563,  520,  582,
 /*   140 */   668,  668,  706,  708,  677,  661,  639,  639,  639,  622,
 /*   150 */   625,  632,  645,  668,  683,  752,  697,  753,  710,  762,
 /*   160 */   776,  741,  746,  755,  792,  802,  803,  749,  801,  772,
 /*   170 */   804,  764,  766,  812,  771,  816,  793,  782,  820,  827,
 /*   180 */   833,  836,  845,  821,  822,  826,  838,  839,  844,  846,
 /*   190 */   848,  849,  859,  861,  856,  866,  832,  834,  799,  869,
 /*   200 */   837,  865,  883,  887,  857,  889,  868,  853,  891,  841,
 /*   210 */   807,  862,  874,  811,  870,  875,  877,  668,  823,  825,
 /*   220 */   824,  863,  639,  894,  872,  880,  873,  876,  828,  881,
 /*   230 */   884,  882,  885,  886,  895,  907,  908,  922,  931,  926,
 /*   240 */   944,  929,  972,  957,  973,  953,  960,  950,  980,  983,
 /*   250 */   989,  998,  954,  938,  981,  982,  984,  991, 1009,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*    10 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*    20 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*    30 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*    40 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*    50 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*    60 */  1372, 1372, 1372, 1372, 1372, 1441, 1372, 1372, 1372, 1372,
 /*    70 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*    80 */  1439, 1587, 1372, 1751, 1372, 1372, 1372, 1372, 1372, 1372,
 /*    90 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   100 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   110 */  1372, 1441, 1372, 1762, 1762, 1762, 1439, 1372, 1372, 1372,
 /*   120 */  1372, 1372, 1372, 1372, 1535, 1372, 1372, 1372, 1372, 1372,
 /*   130 */  1372, 1372, 1372, 1620, 1372, 1372, 1828, 1372, 1626, 1786,
 /*   140 */  1372, 1372, 1372, 1372, 1488, 1778, 1754, 1768, 1755, 1813,
 /*   150 */  1813, 1813, 1771, 1372, 1782, 1372, 1372, 1372, 1612, 1372,
 /*   160 */  1372, 1592, 1589, 1589, 1372, 1372, 1372, 1372, 1441, 1372,
 /*   170 */  1441, 1372, 1372, 1441, 1372, 1441, 1372, 1372, 1441, 1441,
 /*   180 */  1372, 1441, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   190 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1439,
 /*   200 */  1622, 1372, 1439, 1372, 1372, 1439, 1372, 1372, 1439, 1372,
 /*   210 */  1793, 1791, 1372, 1793, 1791, 1372, 1372, 1372, 1805, 1801,
 /*   220 */  1784, 1782, 1768, 1372, 1372, 1372, 1819, 1815, 1831, 1819,
 /*   230 */  1815, 1819, 1815, 1372, 1791, 1372, 1372, 1791, 1372, 1597,
 /*   240 */  1372, 1372, 1439, 1372, 1439, 1372, 1504, 1372, 1372, 1372,
 /*   250 */  1439, 1372, 1614, 1628, 1538, 1538, 1538, 1442, 1377, 1372,
 /*   260 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   270 */  1500, 1695, 1804, 1803, 1727, 1726, 1725, 1723, 1694, 1372,
 /*   280 */  1372, 1372, 1372, 1372, 1372, 1688, 1689, 1687, 1686, 1372,
 /*   290 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   300 */  1372, 1372, 1752, 1372, 1816, 1820, 1372, 1372, 1372, 1671,
 /*   310 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   320 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   330 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   340 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   350 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   360 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   370 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   380 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   390 */  1372, 1372, 1372, 1372, 1372, 1372, 1406, 1372, 1372, 1372,
 /*   400 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   410 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   420 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   430 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   440 */  1372, 1372, 1372, 1372, 1469, 1468, 1372, 1372, 1372, 1372,
 /*   450 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   460 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   470 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1775, 1785,
 /*   480 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   490 */  1671, 1372, 1802, 1372, 1761, 1757, 1372, 1372, 1753, 1372,
 /*   500 */  1372, 1814, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   510 */  1372, 1747, 1372, 1720, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   520 */  1372, 1372, 1682, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   530 */  1372, 1372, 1372, 1372, 1372, 1670, 1372, 1711, 1372, 1372,
 /*   540 */  1372, 1372, 1372, 1372, 1372, 1372, 1532, 1372, 1372, 1372,
 /*   550 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1517,
 /*   560 */  1515, 1514, 1513, 1372, 1510, 1372, 1372, 1372, 1372, 1541,
 /*   570 */  1540, 1372, 1372, 1372, 1372, 1372, 1372, 1461, 1372, 1372,
 /*   580 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1452, 1372, 1451,
 /*   590 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   600 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   610 */  1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372, 1372,
 /*   620 */  1372, 1372, 1372,
};
/********** End of lemon-generated parsing tables *****************************/

/* The next table maps tokens (terminal symbols) into fallback tokens.  
** If a construct like the following:
** 
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
**
** This feature can be used, for example, to cause some keywords in a language
** to revert to identifiers if they keyword does not apply in the context where
** it appears.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*         OR => nothing */
    0,  /*        AND => nothing */
    0,  /*      UNION => nothing */
    0,  /*        ALL => nothing */
    0,  /*      MINUS => nothing */
    0,  /*     EXCEPT => nothing */
    0,  /*  INTERSECT => nothing */
    0,  /*  NK_BITAND => nothing */
    0,  /*   NK_BITOR => nothing */
    0,  /*  NK_LSHIFT => nothing */
    0,  /*  NK_RSHIFT => nothing */
    0,  /*    NK_PLUS => nothing */
    0,  /*   NK_MINUS => nothing */
    0,  /*    NK_STAR => nothing */
    0,  /*   NK_SLASH => nothing */
    0,  /*     NK_REM => nothing */
    0,  /*  NK_CONCAT => nothing */
    0,  /*     CREATE => nothing */
    0,  /*    ACCOUNT => nothing */
    0,  /*      NK_ID => nothing */
    0,  /*       PASS => nothing */
    0,  /*  NK_STRING => nothing */
    0,  /*      ALTER => nothing */
    0,  /*        PPS => nothing */
    0,  /*    TSERIES => nothing */
    0,  /*    STORAGE => nothing */
    0,  /*    STREAMS => nothing */
    0,  /*      QTIME => nothing */
    0,  /*        DBS => nothing */
    0,  /*      USERS => nothing */
    0,  /*      CONNS => nothing */
    0,  /*      STATE => nothing */
    0,  /*       USER => nothing */
    0,  /*  PRIVILEGE => nothing */
    0,  /*       DROP => nothing */
    0,  /*      GRANT => nothing */
    0,  /*         ON => nothing */
    0,  /*         TO => nothing */
    0,  /*     REVOKE => nothing */
    0,  /*       FROM => nothing */
    0,  /*   NK_COMMA => nothing */
    0,  /*       READ => nothing */
    0,  /*      WRITE => nothing */
    0,  /*     NK_DOT => nothing */
    0,  /*      DNODE => nothing */
    0,  /*       PORT => nothing */
    0,  /* NK_INTEGER => nothing */
    0,  /*     DNODES => nothing */
    0,  /* NK_IPTOKEN => nothing */
    0,  /*      LOCAL => nothing */
    0,  /*      QNODE => nothing */
    0,  /*      BNODE => nothing */
    0,  /*      SNODE => nothing */
    0,  /*      MNODE => nothing */
    0,  /*   DATABASE => nothing */
    0,  /*        USE => nothing */
    0,  /*         IF => nothing */
    0,  /*        NOT => nothing */
    0,  /*     EXISTS => nothing */
    0,  /*     BUFFER => nothing */
    0,  /*  CACHELAST => nothing */
    0,  /*       COMP => nothing */
    0,  /*   DURATION => nothing */
    0,  /* NK_VARIABLE => nothing */
    0,  /*      FSYNC => nothing */
    0,  /*    MAXROWS => nothing */
    0,  /*    MINROWS => nothing */
    0,  /*       KEEP => nothing */
    0,  /*      PAGES => nothing */
    0,  /*   PAGESIZE => nothing */
    0,  /*  PRECISION => nothing */
    0,  /*    REPLICA => nothing */
    0,  /*     STRICT => nothing */
    0,  /*        WAL => nothing */
    0,  /*    VGROUPS => nothing */
    0,  /* SINGLE_STABLE => nothing */
    0,  /* RETENTIONS => nothing */
    0,  /* SCHEMALESS => nothing */
    0,  /*   NK_COLON => nothing */
    0,  /*      TABLE => nothing */
    0,  /*      NK_LP => nothing */
    0,  /*      NK_RP => nothing */
    0,  /*     STABLE => nothing */
    0,  /*        ADD => nothing */
    0,  /*     COLUMN => nothing */
    0,  /*     MODIFY => nothing */
    0,  /*     RENAME => nothing */
    0,  /*        TAG => nothing */
    0,  /*        SET => nothing */
    0,  /*      NK_EQ => nothing */
    0,  /*      USING => nothing */
    0,  /*       TAGS => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*       BOOL => nothing */
    0,  /*    TINYINT => nothing */
    0,  /*   SMALLINT => nothing */
    0,  /*        INT => nothing */
    0,  /*    INTEGER => nothing */
    0,  /*     BIGINT => nothing */
    0,  /*      FLOAT => nothing */
    0,  /*     DOUBLE => nothing */
    0,  /*     BINARY => nothing */
    0,  /*  TIMESTAMP => nothing */
    0,  /*      NCHAR => nothing */
    0,  /*   UNSIGNED => nothing */
    0,  /*       JSON => nothing */
    0,  /*    VARCHAR => nothing */
    0,  /* MEDIUMBLOB => nothing */
    0,  /*       BLOB => nothing */
    0,  /*  VARBINARY => nothing */
    0,  /*    DECIMAL => nothing */
    0,  /*  MAX_DELAY => nothing */
    0,  /*  WATERMARK => nothing */
    0,  /*     ROLLUP => nothing */
    0,  /*        TTL => nothing */
    0,  /*        SMA => nothing */
    0,  /*      FIRST => nothing */
    0,  /*       LAST => nothing */
    0,  /*       SHOW => nothing */
    0,  /*  DATABASES => nothing */
    0,  /*     TABLES => nothing */
    0,  /*    STABLES => nothing */
    0,  /*     MNODES => nothing */
    0,  /*    MODULES => nothing */
    0,  /*     QNODES => nothing */
    0,  /*  FUNCTIONS => nothing */
    0,  /*    INDEXES => nothing */
    0,  /*   ACCOUNTS => nothing */
    0,  /*       APPS => nothing */
    0,  /* CONNECTIONS => nothing */
    0,  /*    LICENCE => nothing */
    0,  /*     GRANTS => nothing */
    0,  /*    QUERIES => nothing */
    0,  /*     SCORES => nothing */
    0,  /*     TOPICS => nothing */
    0,  /*  VARIABLES => nothing */
    0,  /*     BNODES => nothing */
    0,  /*     SNODES => nothing */
    0,  /*    CLUSTER => nothing */
    0,  /* TRANSACTIONS => nothing */
    0,  /*       LIKE => nothing */
    0,  /*      INDEX => nothing */
    0,  /*   FULLTEXT => nothing */
    0,  /*   FUNCTION => nothing */
    0,  /*   INTERVAL => nothing */
    0,  /*      TOPIC => nothing */
    0,  /*         AS => nothing */
    0,  /*   CONSUMER => nothing */
    0,  /*      GROUP => nothing */
    0,  /*       DESC => nothing */
    0,  /*   DESCRIBE => nothing */
    0,  /*      RESET => nothing */
    0,  /*      QUERY => nothing */
    0,  /*      CACHE => nothing */
    0,  /*    EXPLAIN => nothing */
    0,  /*    ANALYZE => nothing */
    0,  /*    VERBOSE => nothing */
    0,  /*    NK_BOOL => nothing */
    0,  /*      RATIO => nothing */
    0,  /*   NK_FLOAT => nothing */
    0,  /*    COMPACT => nothing */
    0,  /*     VNODES => nothing */
    0,  /*         IN => nothing */
    0,  /* OUTPUTTYPE => nothing */
    0,  /*  AGGREGATE => nothing */
    0,  /*    BUFSIZE => nothing */
    0,  /*     STREAM => nothing */
    0,  /*       INTO => nothing */
    0,  /*    TRIGGER => nothing */
    0,  /*    AT_ONCE => nothing */
    0,  /* WINDOW_CLOSE => nothing */
    0,  /*       KILL => nothing */
    0,  /* CONNECTION => nothing */
    0,  /* TRANSACTION => nothing */
    0,  /*    BALANCE => nothing */
    0,  /*     VGROUP => nothing */
    0,  /*      MERGE => nothing */
    0,  /* REDISTRIBUTE => nothing */
    0,  /*      SPLIT => nothing */
    0,  /*     SYNCDB => nothing */
    0,  /*     DELETE => nothing */
    0,  /*       NULL => nothing */
    0,  /* NK_QUESTION => nothing */
    0,  /*   NK_ARROW => nothing */
    0,  /*      ROWTS => nothing */
    0,  /*     TBNAME => nothing */
    0,  /*   QSTARTTS => nothing */
    0,  /*     QENDTS => nothing */
    0,  /*   WSTARTTS => nothing */
    0,  /*     WENDTS => nothing */
    0,  /*  WDURATION => nothing */
    0,  /*       CAST => nothing */
    0,  /*        NOW => nothing */
    0,  /*      TODAY => nothing */
    0,  /*   TIMEZONE => nothing */
    0,  /*      COUNT => nothing */
    0,  /*   LAST_ROW => nothing */
    0,  /*    BETWEEN => nothing */
    0,  /*         IS => nothing */
    0,  /*      NK_LT => nothing */
    0,  /*      NK_GT => nothing */
    0,  /*      NK_LE => nothing */
    0,  /*      NK_GE => nothing */
    0,  /*      NK_NE => nothing */
    0,  /*      MATCH => nothing */
    0,  /*     NMATCH => nothing */
    0,  /*   CONTAINS => nothing */
    0,  /*       JOIN => nothing */
    0,  /*      INNER => nothing */
    0,  /*     SELECT => nothing */
    0,  /*   DISTINCT => nothing */
    0,  /*      WHERE => nothing */
    0,  /*  PARTITION => nothing */
    0,  /*         BY => nothing */
    0,  /*    SESSION => nothing */
    0,  /* STATE_WINDOW => nothing */
    0,  /*    SLIDING => nothing */
    0,  /*       FILL => nothing */
    0,  /*      VALUE => nothing */
    0,  /*       NONE => nothing */
    0,  /*       PREV => nothing */
    0,  /*     LINEAR => nothing */
    0,  /*       NEXT => nothing */
    0,  /*     HAVING => nothing */
    0,  /*      ORDER => nothing */
    0,  /*     SLIMIT => nothing */
    0,  /*    SOFFSET => nothing */
    0,  /*      LIMIT => nothing */
    0,  /*     OFFSET => nothing */
    0,  /*        ASC => nothing */
    0,  /*      NULLS => nothing */
    0,  /*         ID => nothing */
  232,  /*  NK_BITNOT => ID */
  232,  /*     INSERT => ID */
  232,  /*     VALUES => ID */
  232,  /*     IMPORT => ID */
  232,  /*    NK_SEMI => ID */
  232,  /*       FILE => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
**
** After the "shift" half of a SHIFTREDUCE action, the stateno field
** actually contains the reduce action for the second half of the
** SHIFTREDUCE.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number, or reduce action in SHIFTREDUCE */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  yyStackEntry *yytos;          /* Pointer to top element of the stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyhwm;                    /* High-water mark of the stack */
#endif
#ifndef YYNOERRORRECOVERY
  int yyerrcnt;                 /* Shifts left before out of the error */
#endif
  ParseARG_SDECL                /* A place to hold %extra_argument */
  ParseCTX_SDECL                /* A place to hold %extra_context */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
  yyStackEntry yystk0;          /* First stack entry */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
  yyStackEntry *yystackEnd;            /* Last entry in the stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

#ifndef NDEBUG
/* 
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL 
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void ParseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#if defined(YYCOVERAGE) || !defined(NDEBUG)
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = { 
  /*    0 */ "$",
  /*    1 */ "OR",
  /*    2 */ "AND",
  /*    3 */ "UNION",
  /*    4 */ "ALL",
  /*    5 */ "MINUS",
  /*    6 */ "EXCEPT",
  /*    7 */ "INTERSECT",
  /*    8 */ "NK_BITAND",
  /*    9 */ "NK_BITOR",
  /*   10 */ "NK_LSHIFT",
  /*   11 */ "NK_RSHIFT",
  /*   12 */ "NK_PLUS",
  /*   13 */ "NK_MINUS",
  /*   14 */ "NK_STAR",
  /*   15 */ "NK_SLASH",
  /*   16 */ "NK_REM",
  /*   17 */ "NK_CONCAT",
  /*   18 */ "CREATE",
  /*   19 */ "ACCOUNT",
  /*   20 */ "NK_ID",
  /*   21 */ "PASS",
  /*   22 */ "NK_STRING",
  /*   23 */ "ALTER",
  /*   24 */ "PPS",
  /*   25 */ "TSERIES",
  /*   26 */ "STORAGE",
  /*   27 */ "STREAMS",
  /*   28 */ "QTIME",
  /*   29 */ "DBS",
  /*   30 */ "USERS",
  /*   31 */ "CONNS",
  /*   32 */ "STATE",
  /*   33 */ "USER",
  /*   34 */ "PRIVILEGE",
  /*   35 */ "DROP",
  /*   36 */ "GRANT",
  /*   37 */ "ON",
  /*   38 */ "TO",
  /*   39 */ "REVOKE",
  /*   40 */ "FROM",
  /*   41 */ "NK_COMMA",
  /*   42 */ "READ",
  /*   43 */ "WRITE",
  /*   44 */ "NK_DOT",
  /*   45 */ "DNODE",
  /*   46 */ "PORT",
  /*   47 */ "NK_INTEGER",
  /*   48 */ "DNODES",
  /*   49 */ "NK_IPTOKEN",
  /*   50 */ "LOCAL",
  /*   51 */ "QNODE",
  /*   52 */ "BNODE",
  /*   53 */ "SNODE",
  /*   54 */ "MNODE",
  /*   55 */ "DATABASE",
  /*   56 */ "USE",
  /*   57 */ "IF",
  /*   58 */ "NOT",
  /*   59 */ "EXISTS",
  /*   60 */ "BUFFER",
  /*   61 */ "CACHELAST",
  /*   62 */ "COMP",
  /*   63 */ "DURATION",
  /*   64 */ "NK_VARIABLE",
  /*   65 */ "FSYNC",
  /*   66 */ "MAXROWS",
  /*   67 */ "MINROWS",
  /*   68 */ "KEEP",
  /*   69 */ "PAGES",
  /*   70 */ "PAGESIZE",
  /*   71 */ "PRECISION",
  /*   72 */ "REPLICA",
  /*   73 */ "STRICT",
  /*   74 */ "WAL",
  /*   75 */ "VGROUPS",
  /*   76 */ "SINGLE_STABLE",
  /*   77 */ "RETENTIONS",
  /*   78 */ "SCHEMALESS",
  /*   79 */ "NK_COLON",
  /*   80 */ "TABLE",
  /*   81 */ "NK_LP",
  /*   82 */ "NK_RP",
  /*   83 */ "STABLE",
  /*   84 */ "ADD",
  /*   85 */ "COLUMN",
  /*   86 */ "MODIFY",
  /*   87 */ "RENAME",
  /*   88 */ "TAG",
  /*   89 */ "SET",
  /*   90 */ "NK_EQ",
  /*   91 */ "USING",
  /*   92 */ "TAGS",
  /*   93 */ "COMMENT",
  /*   94 */ "BOOL",
  /*   95 */ "TINYINT",
  /*   96 */ "SMALLINT",
  /*   97 */ "INT",
  /*   98 */ "INTEGER",
  /*   99 */ "BIGINT",
  /*  100 */ "FLOAT",
  /*  101 */ "DOUBLE",
  /*  102 */ "BINARY",
  /*  103 */ "TIMESTAMP",
  /*  104 */ "NCHAR",
  /*  105 */ "UNSIGNED",
  /*  106 */ "JSON",
  /*  107 */ "VARCHAR",
  /*  108 */ "MEDIUMBLOB",
  /*  109 */ "BLOB",
  /*  110 */ "VARBINARY",
  /*  111 */ "DECIMAL",
  /*  112 */ "MAX_DELAY",
  /*  113 */ "WATERMARK",
  /*  114 */ "ROLLUP",
  /*  115 */ "TTL",
  /*  116 */ "SMA",
  /*  117 */ "FIRST",
  /*  118 */ "LAST",
  /*  119 */ "SHOW",
  /*  120 */ "DATABASES",
  /*  121 */ "TABLES",
  /*  122 */ "STABLES",
  /*  123 */ "MNODES",
  /*  124 */ "MODULES",
  /*  125 */ "QNODES",
  /*  126 */ "FUNCTIONS",
  /*  127 */ "INDEXES",
  /*  128 */ "ACCOUNTS",
  /*  129 */ "APPS",
  /*  130 */ "CONNECTIONS",
  /*  131 */ "LICENCE",
  /*  132 */ "GRANTS",
  /*  133 */ "QUERIES",
  /*  134 */ "SCORES",
  /*  135 */ "TOPICS",
  /*  136 */ "VARIABLES",
  /*  137 */ "BNODES",
  /*  138 */ "SNODES",
  /*  139 */ "CLUSTER",
  /*  140 */ "TRANSACTIONS",
  /*  141 */ "LIKE",
  /*  142 */ "INDEX",
  /*  143 */ "FULLTEXT",
  /*  144 */ "FUNCTION",
  /*  145 */ "INTERVAL",
  /*  146 */ "TOPIC",
  /*  147 */ "AS",
  /*  148 */ "CONSUMER",
  /*  149 */ "GROUP",
  /*  150 */ "DESC",
  /*  151 */ "DESCRIBE",
  /*  152 */ "RESET",
  /*  153 */ "QUERY",
  /*  154 */ "CACHE",
  /*  155 */ "EXPLAIN",
  /*  156 */ "ANALYZE",
  /*  157 */ "VERBOSE",
  /*  158 */ "NK_BOOL",
  /*  159 */ "RATIO",
  /*  160 */ "NK_FLOAT",
  /*  161 */ "COMPACT",
  /*  162 */ "VNODES",
  /*  163 */ "IN",
  /*  164 */ "OUTPUTTYPE",
  /*  165 */ "AGGREGATE",
  /*  166 */ "BUFSIZE",
  /*  167 */ "STREAM",
  /*  168 */ "INTO",
  /*  169 */ "TRIGGER",
  /*  170 */ "AT_ONCE",
  /*  171 */ "WINDOW_CLOSE",
  /*  172 */ "KILL",
  /*  173 */ "CONNECTION",
  /*  174 */ "TRANSACTION",
  /*  175 */ "BALANCE",
  /*  176 */ "VGROUP",
  /*  177 */ "MERGE",
  /*  178 */ "REDISTRIBUTE",
  /*  179 */ "SPLIT",
  /*  180 */ "SYNCDB",
  /*  181 */ "DELETE",
  /*  182 */ "NULL",
  /*  183 */ "NK_QUESTION",
  /*  184 */ "NK_ARROW",
  /*  185 */ "ROWTS",
  /*  186 */ "TBNAME",
  /*  187 */ "QSTARTTS",
  /*  188 */ "QENDTS",
  /*  189 */ "WSTARTTS",
  /*  190 */ "WENDTS",
  /*  191 */ "WDURATION",
  /*  192 */ "CAST",
  /*  193 */ "NOW",
  /*  194 */ "TODAY",
  /*  195 */ "TIMEZONE",
  /*  196 */ "COUNT",
  /*  197 */ "LAST_ROW",
  /*  198 */ "BETWEEN",
  /*  199 */ "IS",
  /*  200 */ "NK_LT",
  /*  201 */ "NK_GT",
  /*  202 */ "NK_LE",
  /*  203 */ "NK_GE",
  /*  204 */ "NK_NE",
  /*  205 */ "MATCH",
  /*  206 */ "NMATCH",
  /*  207 */ "CONTAINS",
  /*  208 */ "JOIN",
  /*  209 */ "INNER",
  /*  210 */ "SELECT",
  /*  211 */ "DISTINCT",
  /*  212 */ "WHERE",
  /*  213 */ "PARTITION",
  /*  214 */ "BY",
  /*  215 */ "SESSION",
  /*  216 */ "STATE_WINDOW",
  /*  217 */ "SLIDING",
  /*  218 */ "FILL",
  /*  219 */ "VALUE",
  /*  220 */ "NONE",
  /*  221 */ "PREV",
  /*  222 */ "LINEAR",
  /*  223 */ "NEXT",
  /*  224 */ "HAVING",
  /*  225 */ "ORDER",
  /*  226 */ "SLIMIT",
  /*  227 */ "SOFFSET",
  /*  228 */ "LIMIT",
  /*  229 */ "OFFSET",
  /*  230 */ "ASC",
  /*  231 */ "NULLS",
  /*  232 */ "ID",
  /*  233 */ "NK_BITNOT",
  /*  234 */ "INSERT",
  /*  235 */ "VALUES",
  /*  236 */ "IMPORT",
  /*  237 */ "NK_SEMI",
  /*  238 */ "FILE",
  /*  239 */ "cmd",
  /*  240 */ "account_options",
  /*  241 */ "alter_account_options",
  /*  242 */ "literal",
  /*  243 */ "alter_account_option",
  /*  244 */ "user_name",
  /*  245 */ "privileges",
  /*  246 */ "priv_level",
  /*  247 */ "priv_type_list",
  /*  248 */ "priv_type",
  /*  249 */ "db_name",
  /*  250 */ "dnode_endpoint",
  /*  251 */ "dnode_host_name",
  /*  252 */ "not_exists_opt",
  /*  253 */ "db_options",
  /*  254 */ "exists_opt",
  /*  255 */ "alter_db_options",
  /*  256 */ "integer_list",
  /*  257 */ "variable_list",
  /*  258 */ "retention_list",
  /*  259 */ "alter_db_option",
  /*  260 */ "retention",
  /*  261 */ "full_table_name",
  /*  262 */ "column_def_list",
  /*  263 */ "tags_def_opt",
  /*  264 */ "table_options",
  /*  265 */ "multi_create_clause",
  /*  266 */ "tags_def",
  /*  267 */ "multi_drop_clause",
  /*  268 */ "alter_table_clause",
  /*  269 */ "alter_table_options",
  /*  270 */ "column_name",
  /*  271 */ "type_name",
  /*  272 */ "signed_literal",
  /*  273 */ "create_subtable_clause",
  /*  274 */ "specific_tags_opt",
  /*  275 */ "literal_list",
  /*  276 */ "drop_table_clause",
  /*  277 */ "col_name_list",
  /*  278 */ "table_name",
  /*  279 */ "column_def",
  /*  280 */ "duration_list",
  /*  281 */ "rollup_func_list",
  /*  282 */ "alter_table_option",
  /*  283 */ "duration_literal",
  /*  284 */ "rollup_func_name",
  /*  285 */ "function_name",
  /*  286 */ "col_name",
  /*  287 */ "db_name_cond_opt",
  /*  288 */ "like_pattern_opt",
  /*  289 */ "table_name_cond",
  /*  290 */ "from_db_opt",
  /*  291 */ "index_name",
  /*  292 */ "index_options",
  /*  293 */ "func_list",
  /*  294 */ "sliding_opt",
  /*  295 */ "func",
  /*  296 */ "expression_list",
  /*  297 */ "topic_name",
  /*  298 */ "query_expression",
  /*  299 */ "cgroup_name",
  /*  300 */ "analyze_opt",
  /*  301 */ "explain_options",
  /*  302 */ "agg_func_opt",
  /*  303 */ "bufsize_opt",
  /*  304 */ "stream_name",
  /*  305 */ "stream_options",
  /*  306 */ "into_opt",
  /*  307 */ "dnode_list",
  /*  308 */ "where_clause_opt",
  /*  309 */ "signed",
  /*  310 */ "literal_func",
  /*  311 */ "table_alias",
  /*  312 */ "column_alias",
  /*  313 */ "expression",
  /*  314 */ "pseudo_column",
  /*  315 */ "column_reference",
  /*  316 */ "function_expression",
  /*  317 */ "subquery",
  /*  318 */ "star_func",
  /*  319 */ "star_func_para_list",
  /*  320 */ "noarg_func",
  /*  321 */ "other_para_list",
  /*  322 */ "star_func_para",
  /*  323 */ "predicate",
  /*  324 */ "compare_op",
  /*  325 */ "in_op",
  /*  326 */ "in_predicate_value",
  /*  327 */ "boolean_value_expression",
  /*  328 */ "boolean_primary",
  /*  329 */ "common_expression",
  /*  330 */ "from_clause",
  /*  331 */ "table_reference_list",
  /*  332 */ "table_reference",
  /*  333 */ "table_primary",
  /*  334 */ "joined_table",
  /*  335 */ "alias_opt",
  /*  336 */ "parenthesized_joined_table",
  /*  337 */ "join_type",
  /*  338 */ "search_condition",
  /*  339 */ "query_specification",
  /*  340 */ "set_quantifier_opt",
  /*  341 */ "select_list",
  /*  342 */ "partition_by_clause_opt",
  /*  343 */ "twindow_clause_opt",
  /*  344 */ "group_by_clause_opt",
  /*  345 */ "having_clause_opt",
  /*  346 */ "select_sublist",
  /*  347 */ "select_item",
  /*  348 */ "fill_opt",
  /*  349 */ "fill_mode",
  /*  350 */ "group_by_list",
  /*  351 */ "query_expression_body",
  /*  352 */ "order_by_clause_opt",
  /*  353 */ "slimit_clause_opt",
  /*  354 */ "limit_clause_opt",
  /*  355 */ "query_primary",
  /*  356 */ "sort_specification_list",
  /*  357 */ "sort_specification",
  /*  358 */ "ordering_specification_opt",
  /*  359 */ "null_ordering_opt",
};
#endif /* defined(YYCOVERAGE) || !defined(NDEBUG) */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options",
 /*   1 */ "cmd ::= ALTER ACCOUNT NK_ID alter_account_options",
 /*   2 */ "account_options ::=",
 /*   3 */ "account_options ::= account_options PPS literal",
 /*   4 */ "account_options ::= account_options TSERIES literal",
 /*   5 */ "account_options ::= account_options STORAGE literal",
 /*   6 */ "account_options ::= account_options STREAMS literal",
 /*   7 */ "account_options ::= account_options QTIME literal",
 /*   8 */ "account_options ::= account_options DBS literal",
 /*   9 */ "account_options ::= account_options USERS literal",
 /*  10 */ "account_options ::= account_options CONNS literal",
 /*  11 */ "account_options ::= account_options STATE literal",
 /*  12 */ "alter_account_options ::= alter_account_option",
 /*  13 */ "alter_account_options ::= alter_account_options alter_account_option",
 /*  14 */ "alter_account_option ::= PASS literal",
 /*  15 */ "alter_account_option ::= PPS literal",
 /*  16 */ "alter_account_option ::= TSERIES literal",
 /*  17 */ "alter_account_option ::= STORAGE literal",
 /*  18 */ "alter_account_option ::= STREAMS literal",
 /*  19 */ "alter_account_option ::= QTIME literal",
 /*  20 */ "alter_account_option ::= DBS literal",
 /*  21 */ "alter_account_option ::= USERS literal",
 /*  22 */ "alter_account_option ::= CONNS literal",
 /*  23 */ "alter_account_option ::= STATE literal",
 /*  24 */ "cmd ::= CREATE USER user_name PASS NK_STRING",
 /*  25 */ "cmd ::= ALTER USER user_name PASS NK_STRING",
 /*  26 */ "cmd ::= ALTER USER user_name PRIVILEGE NK_STRING",
 /*  27 */ "cmd ::= DROP USER user_name",
 /*  28 */ "cmd ::= GRANT privileges ON priv_level TO user_name",
 /*  29 */ "cmd ::= REVOKE privileges ON priv_level FROM user_name",
 /*  30 */ "privileges ::= ALL",
 /*  31 */ "privileges ::= priv_type_list",
 /*  32 */ "priv_type_list ::= priv_type",
 /*  33 */ "priv_type_list ::= priv_type_list NK_COMMA priv_type",
 /*  34 */ "priv_type ::= READ",
 /*  35 */ "priv_type ::= WRITE",
 /*  36 */ "priv_level ::= NK_STAR NK_DOT NK_STAR",
 /*  37 */ "priv_level ::= db_name NK_DOT NK_STAR",
 /*  38 */ "cmd ::= CREATE DNODE dnode_endpoint",
 /*  39 */ "cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER",
 /*  40 */ "cmd ::= DROP DNODE NK_INTEGER",
 /*  41 */ "cmd ::= DROP DNODE dnode_endpoint",
 /*  42 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING",
 /*  43 */ "cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING",
 /*  44 */ "cmd ::= ALTER ALL DNODES NK_STRING",
 /*  45 */ "cmd ::= ALTER ALL DNODES NK_STRING NK_STRING",
 /*  46 */ "dnode_endpoint ::= NK_STRING",
 /*  47 */ "dnode_host_name ::= NK_ID",
 /*  48 */ "dnode_host_name ::= NK_IPTOKEN",
 /*  49 */ "cmd ::= ALTER LOCAL NK_STRING",
 /*  50 */ "cmd ::= ALTER LOCAL NK_STRING NK_STRING",
 /*  51 */ "cmd ::= CREATE QNODE ON DNODE NK_INTEGER",
 /*  52 */ "cmd ::= DROP QNODE ON DNODE NK_INTEGER",
 /*  53 */ "cmd ::= CREATE BNODE ON DNODE NK_INTEGER",
 /*  54 */ "cmd ::= DROP BNODE ON DNODE NK_INTEGER",
 /*  55 */ "cmd ::= CREATE SNODE ON DNODE NK_INTEGER",
 /*  56 */ "cmd ::= DROP SNODE ON DNODE NK_INTEGER",
 /*  57 */ "cmd ::= CREATE MNODE ON DNODE NK_INTEGER",
 /*  58 */ "cmd ::= DROP MNODE ON DNODE NK_INTEGER",
 /*  59 */ "cmd ::= CREATE DATABASE not_exists_opt db_name db_options",
 /*  60 */ "cmd ::= DROP DATABASE exists_opt db_name",
 /*  61 */ "cmd ::= USE db_name",
 /*  62 */ "cmd ::= ALTER DATABASE db_name alter_db_options",
 /*  63 */ "not_exists_opt ::= IF NOT EXISTS",
 /*  64 */ "not_exists_opt ::=",
 /*  65 */ "exists_opt ::= IF EXISTS",
 /*  66 */ "exists_opt ::=",
 /*  67 */ "db_options ::=",
 /*  68 */ "db_options ::= db_options BUFFER NK_INTEGER",
 /*  69 */ "db_options ::= db_options CACHELAST NK_INTEGER",
 /*  70 */ "db_options ::= db_options COMP NK_INTEGER",
 /*  71 */ "db_options ::= db_options DURATION NK_INTEGER",
 /*  72 */ "db_options ::= db_options DURATION NK_VARIABLE",
 /*  73 */ "db_options ::= db_options FSYNC NK_INTEGER",
 /*  74 */ "db_options ::= db_options MAXROWS NK_INTEGER",
 /*  75 */ "db_options ::= db_options MINROWS NK_INTEGER",
 /*  76 */ "db_options ::= db_options KEEP integer_list",
 /*  77 */ "db_options ::= db_options KEEP variable_list",
 /*  78 */ "db_options ::= db_options PAGES NK_INTEGER",
 /*  79 */ "db_options ::= db_options PAGESIZE NK_INTEGER",
 /*  80 */ "db_options ::= db_options PRECISION NK_STRING",
 /*  81 */ "db_options ::= db_options REPLICA NK_INTEGER",
 /*  82 */ "db_options ::= db_options STRICT NK_INTEGER",
 /*  83 */ "db_options ::= db_options WAL NK_INTEGER",
 /*  84 */ "db_options ::= db_options VGROUPS NK_INTEGER",
 /*  85 */ "db_options ::= db_options SINGLE_STABLE NK_INTEGER",
 /*  86 */ "db_options ::= db_options RETENTIONS retention_list",
 /*  87 */ "db_options ::= db_options SCHEMALESS NK_INTEGER",
 /*  88 */ "alter_db_options ::= alter_db_option",
 /*  89 */ "alter_db_options ::= alter_db_options alter_db_option",
 /*  90 */ "alter_db_option ::= BUFFER NK_INTEGER",
 /*  91 */ "alter_db_option ::= CACHELAST NK_INTEGER",
 /*  92 */ "alter_db_option ::= FSYNC NK_INTEGER",
 /*  93 */ "alter_db_option ::= KEEP integer_list",
 /*  94 */ "alter_db_option ::= KEEP variable_list",
 /*  95 */ "alter_db_option ::= PAGES NK_INTEGER",
 /*  96 */ "alter_db_option ::= REPLICA NK_INTEGER",
 /*  97 */ "alter_db_option ::= STRICT NK_INTEGER",
 /*  98 */ "alter_db_option ::= WAL NK_INTEGER",
 /*  99 */ "integer_list ::= NK_INTEGER",
 /* 100 */ "integer_list ::= integer_list NK_COMMA NK_INTEGER",
 /* 101 */ "variable_list ::= NK_VARIABLE",
 /* 102 */ "variable_list ::= variable_list NK_COMMA NK_VARIABLE",
 /* 103 */ "retention_list ::= retention",
 /* 104 */ "retention_list ::= retention_list NK_COMMA retention",
 /* 105 */ "retention ::= NK_VARIABLE NK_COLON NK_VARIABLE",
 /* 106 */ "cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options",
 /* 107 */ "cmd ::= CREATE TABLE multi_create_clause",
 /* 108 */ "cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options",
 /* 109 */ "cmd ::= DROP TABLE multi_drop_clause",
 /* 110 */ "cmd ::= DROP STABLE exists_opt full_table_name",
 /* 111 */ "cmd ::= ALTER TABLE alter_table_clause",
 /* 112 */ "cmd ::= ALTER STABLE alter_table_clause",
 /* 113 */ "alter_table_clause ::= full_table_name alter_table_options",
 /* 114 */ "alter_table_clause ::= full_table_name ADD COLUMN column_name type_name",
 /* 115 */ "alter_table_clause ::= full_table_name DROP COLUMN column_name",
 /* 116 */ "alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name",
 /* 117 */ "alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name",
 /* 118 */ "alter_table_clause ::= full_table_name ADD TAG column_name type_name",
 /* 119 */ "alter_table_clause ::= full_table_name DROP TAG column_name",
 /* 120 */ "alter_table_clause ::= full_table_name MODIFY TAG column_name type_name",
 /* 121 */ "alter_table_clause ::= full_table_name RENAME TAG column_name column_name",
 /* 122 */ "alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal",
 /* 123 */ "multi_create_clause ::= create_subtable_clause",
 /* 124 */ "multi_create_clause ::= multi_create_clause create_subtable_clause",
 /* 125 */ "create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options",
 /* 126 */ "multi_drop_clause ::= drop_table_clause",
 /* 127 */ "multi_drop_clause ::= multi_drop_clause drop_table_clause",
 /* 128 */ "drop_table_clause ::= exists_opt full_table_name",
 /* 129 */ "specific_tags_opt ::=",
 /* 130 */ "specific_tags_opt ::= NK_LP col_name_list NK_RP",
 /* 131 */ "full_table_name ::= table_name",
 /* 132 */ "full_table_name ::= db_name NK_DOT table_name",
 /* 133 */ "column_def_list ::= column_def",
 /* 134 */ "column_def_list ::= column_def_list NK_COMMA column_def",
 /* 135 */ "column_def ::= column_name type_name",
 /* 136 */ "column_def ::= column_name type_name COMMENT NK_STRING",
 /* 137 */ "type_name ::= BOOL",
 /* 138 */ "type_name ::= TINYINT",
 /* 139 */ "type_name ::= SMALLINT",
 /* 140 */ "type_name ::= INT",
 /* 141 */ "type_name ::= INTEGER",
 /* 142 */ "type_name ::= BIGINT",
 /* 143 */ "type_name ::= FLOAT",
 /* 144 */ "type_name ::= DOUBLE",
 /* 145 */ "type_name ::= BINARY NK_LP NK_INTEGER NK_RP",
 /* 146 */ "type_name ::= TIMESTAMP",
 /* 147 */ "type_name ::= NCHAR NK_LP NK_INTEGER NK_RP",
 /* 148 */ "type_name ::= TINYINT UNSIGNED",
 /* 149 */ "type_name ::= SMALLINT UNSIGNED",
 /* 150 */ "type_name ::= INT UNSIGNED",
 /* 151 */ "type_name ::= BIGINT UNSIGNED",
 /* 152 */ "type_name ::= JSON",
 /* 153 */ "type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP",
 /* 154 */ "type_name ::= MEDIUMBLOB",
 /* 155 */ "type_name ::= BLOB",
 /* 156 */ "type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP",
 /* 157 */ "type_name ::= DECIMAL",
 /* 158 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP",
 /* 159 */ "type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP",
 /* 160 */ "tags_def_opt ::=",
 /* 161 */ "tags_def_opt ::= tags_def",
 /* 162 */ "tags_def ::= TAGS NK_LP column_def_list NK_RP",
 /* 163 */ "table_options ::=",
 /* 164 */ "table_options ::= table_options COMMENT NK_STRING",
 /* 165 */ "table_options ::= table_options MAX_DELAY duration_list",
 /* 166 */ "table_options ::= table_options WATERMARK duration_list",
 /* 167 */ "table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP",
 /* 168 */ "table_options ::= table_options TTL NK_INTEGER",
 /* 169 */ "table_options ::= table_options SMA NK_LP col_name_list NK_RP",
 /* 170 */ "alter_table_options ::= alter_table_option",
 /* 171 */ "alter_table_options ::= alter_table_options alter_table_option",
 /* 172 */ "alter_table_option ::= COMMENT NK_STRING",
 /* 173 */ "alter_table_option ::= TTL NK_INTEGER",
 /* 174 */ "duration_list ::= duration_literal",
 /* 175 */ "duration_list ::= duration_list NK_COMMA duration_literal",
 /* 176 */ "rollup_func_list ::= rollup_func_name",
 /* 177 */ "rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name",
 /* 178 */ "rollup_func_name ::= function_name",
 /* 179 */ "rollup_func_name ::= FIRST",
 /* 180 */ "rollup_func_name ::= LAST",
 /* 181 */ "col_name_list ::= col_name",
 /* 182 */ "col_name_list ::= col_name_list NK_COMMA col_name",
 /* 183 */ "col_name ::= column_name",
 /* 184 */ "cmd ::= SHOW DNODES",
 /* 185 */ "cmd ::= SHOW USERS",
 /* 186 */ "cmd ::= SHOW DATABASES",
 /* 187 */ "cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt",
 /* 188 */ "cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt",
 /* 189 */ "cmd ::= SHOW db_name_cond_opt VGROUPS",
 /* 190 */ "cmd ::= SHOW MNODES",
 /* 191 */ "cmd ::= SHOW MODULES",
 /* 192 */ "cmd ::= SHOW QNODES",
 /* 193 */ "cmd ::= SHOW FUNCTIONS",
 /* 194 */ "cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt",
 /* 195 */ "cmd ::= SHOW STREAMS",
 /* 196 */ "cmd ::= SHOW ACCOUNTS",
 /* 197 */ "cmd ::= SHOW APPS",
 /* 198 */ "cmd ::= SHOW CONNECTIONS",
 /* 199 */ "cmd ::= SHOW LICENCE",
 /* 200 */ "cmd ::= SHOW GRANTS",
 /* 201 */ "cmd ::= SHOW CREATE DATABASE db_name",
 /* 202 */ "cmd ::= SHOW CREATE TABLE full_table_name",
 /* 203 */ "cmd ::= SHOW CREATE STABLE full_table_name",
 /* 204 */ "cmd ::= SHOW QUERIES",
 /* 205 */ "cmd ::= SHOW SCORES",
 /* 206 */ "cmd ::= SHOW TOPICS",
 /* 207 */ "cmd ::= SHOW VARIABLES",
 /* 208 */ "cmd ::= SHOW BNODES",
 /* 209 */ "cmd ::= SHOW SNODES",
 /* 210 */ "cmd ::= SHOW CLUSTER",
 /* 211 */ "cmd ::= SHOW TRANSACTIONS",
 /* 212 */ "db_name_cond_opt ::=",
 /* 213 */ "db_name_cond_opt ::= db_name NK_DOT",
 /* 214 */ "like_pattern_opt ::=",
 /* 215 */ "like_pattern_opt ::= LIKE NK_STRING",
 /* 216 */ "table_name_cond ::= table_name",
 /* 217 */ "from_db_opt ::=",
 /* 218 */ "from_db_opt ::= FROM db_name",
 /* 219 */ "cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options",
 /* 220 */ "cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP",
 /* 221 */ "cmd ::= DROP INDEX exists_opt index_name ON table_name",
 /* 222 */ "index_options ::=",
 /* 223 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt",
 /* 224 */ "index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt",
 /* 225 */ "func_list ::= func",
 /* 226 */ "func_list ::= func_list NK_COMMA func",
 /* 227 */ "func ::= function_name NK_LP expression_list NK_RP",
 /* 228 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression",
 /* 229 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name",
 /* 230 */ "cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name",
 /* 231 */ "cmd ::= DROP TOPIC exists_opt topic_name",
 /* 232 */ "cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name",
 /* 233 */ "cmd ::= DESC full_table_name",
 /* 234 */ "cmd ::= DESCRIBE full_table_name",
 /* 235 */ "cmd ::= RESET QUERY CACHE",
 /* 236 */ "cmd ::= EXPLAIN analyze_opt explain_options query_expression",
 /* 237 */ "analyze_opt ::=",
 /* 238 */ "analyze_opt ::= ANALYZE",
 /* 239 */ "explain_options ::=",
 /* 240 */ "explain_options ::= explain_options VERBOSE NK_BOOL",
 /* 241 */ "explain_options ::= explain_options RATIO NK_FLOAT",
 /* 242 */ "cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP",
 /* 243 */ "cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt",
 /* 244 */ "cmd ::= DROP FUNCTION exists_opt function_name",
 /* 245 */ "agg_func_opt ::=",
 /* 246 */ "agg_func_opt ::= AGGREGATE",
 /* 247 */ "bufsize_opt ::=",
 /* 248 */ "bufsize_opt ::= BUFSIZE NK_INTEGER",
 /* 249 */ "cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression",
 /* 250 */ "cmd ::= DROP STREAM exists_opt stream_name",
 /* 251 */ "into_opt ::=",
 /* 252 */ "into_opt ::= INTO full_table_name",
 /* 253 */ "stream_options ::=",
 /* 254 */ "stream_options ::= stream_options TRIGGER AT_ONCE",
 /* 255 */ "stream_options ::= stream_options TRIGGER WINDOW_CLOSE",
 /* 256 */ "stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal",
 /* 257 */ "stream_options ::= stream_options WATERMARK duration_literal",
 /* 258 */ "cmd ::= KILL CONNECTION NK_INTEGER",
 /* 259 */ "cmd ::= KILL QUERY NK_STRING",
 /* 260 */ "cmd ::= KILL TRANSACTION NK_INTEGER",
 /* 261 */ "cmd ::= BALANCE VGROUP",
 /* 262 */ "cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER",
 /* 263 */ "cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list",
 /* 264 */ "cmd ::= SPLIT VGROUP NK_INTEGER",
 /* 265 */ "dnode_list ::= DNODE NK_INTEGER",
 /* 266 */ "dnode_list ::= dnode_list DNODE NK_INTEGER",
 /* 267 */ "cmd ::= SYNCDB db_name REPLICA",
 /* 268 */ "cmd ::= DELETE FROM full_table_name where_clause_opt",
 /* 269 */ "cmd ::= query_expression",
 /* 270 */ "literal ::= NK_INTEGER",
 /* 271 */ "literal ::= NK_FLOAT",
 /* 272 */ "literal ::= NK_STRING",
 /* 273 */ "literal ::= NK_BOOL",
 /* 274 */ "literal ::= TIMESTAMP NK_STRING",
 /* 275 */ "literal ::= duration_literal",
 /* 276 */ "literal ::= NULL",
 /* 277 */ "literal ::= NK_QUESTION",
 /* 278 */ "duration_literal ::= NK_VARIABLE",
 /* 279 */ "signed ::= NK_INTEGER",
 /* 280 */ "signed ::= NK_PLUS NK_INTEGER",
 /* 281 */ "signed ::= NK_MINUS NK_INTEGER",
 /* 282 */ "signed ::= NK_FLOAT",
 /* 283 */ "signed ::= NK_PLUS NK_FLOAT",
 /* 284 */ "signed ::= NK_MINUS NK_FLOAT",
 /* 285 */ "signed_literal ::= signed",
 /* 286 */ "signed_literal ::= NK_STRING",
 /* 287 */ "signed_literal ::= NK_BOOL",
 /* 288 */ "signed_literal ::= TIMESTAMP NK_STRING",
 /* 289 */ "signed_literal ::= duration_literal",
 /* 290 */ "signed_literal ::= NULL",
 /* 291 */ "signed_literal ::= literal_func",
 /* 292 */ "literal_list ::= signed_literal",
 /* 293 */ "literal_list ::= literal_list NK_COMMA signed_literal",
 /* 294 */ "db_name ::= NK_ID",
 /* 295 */ "table_name ::= NK_ID",
 /* 296 */ "column_name ::= NK_ID",
 /* 297 */ "function_name ::= NK_ID",
 /* 298 */ "table_alias ::= NK_ID",
 /* 299 */ "column_alias ::= NK_ID",
 /* 300 */ "user_name ::= NK_ID",
 /* 301 */ "index_name ::= NK_ID",
 /* 302 */ "topic_name ::= NK_ID",
 /* 303 */ "stream_name ::= NK_ID",
 /* 304 */ "cgroup_name ::= NK_ID",
 /* 305 */ "expression ::= literal",
 /* 306 */ "expression ::= pseudo_column",
 /* 307 */ "expression ::= column_reference",
 /* 308 */ "expression ::= function_expression",
 /* 309 */ "expression ::= subquery",
 /* 310 */ "expression ::= NK_LP expression NK_RP",
 /* 311 */ "expression ::= NK_PLUS expression",
 /* 312 */ "expression ::= NK_MINUS expression",
 /* 313 */ "expression ::= expression NK_PLUS expression",
 /* 314 */ "expression ::= expression NK_MINUS expression",
 /* 315 */ "expression ::= expression NK_STAR expression",
 /* 316 */ "expression ::= expression NK_SLASH expression",
 /* 317 */ "expression ::= expression NK_REM expression",
 /* 318 */ "expression ::= column_reference NK_ARROW NK_STRING",
 /* 319 */ "expression_list ::= expression",
 /* 320 */ "expression_list ::= expression_list NK_COMMA expression",
 /* 321 */ "column_reference ::= column_name",
 /* 322 */ "column_reference ::= table_name NK_DOT column_name",
 /* 323 */ "pseudo_column ::= ROWTS",
 /* 324 */ "pseudo_column ::= TBNAME",
 /* 325 */ "pseudo_column ::= table_name NK_DOT TBNAME",
 /* 326 */ "pseudo_column ::= QSTARTTS",
 /* 327 */ "pseudo_column ::= QENDTS",
 /* 328 */ "pseudo_column ::= WSTARTTS",
 /* 329 */ "pseudo_column ::= WENDTS",
 /* 330 */ "pseudo_column ::= WDURATION",
 /* 331 */ "function_expression ::= function_name NK_LP expression_list NK_RP",
 /* 332 */ "function_expression ::= star_func NK_LP star_func_para_list NK_RP",
 /* 333 */ "function_expression ::= CAST NK_LP expression AS type_name NK_RP",
 /* 334 */ "function_expression ::= literal_func",
 /* 335 */ "literal_func ::= noarg_func NK_LP NK_RP",
 /* 336 */ "literal_func ::= NOW",
 /* 337 */ "noarg_func ::= NOW",
 /* 338 */ "noarg_func ::= TODAY",
 /* 339 */ "noarg_func ::= TIMEZONE",
 /* 340 */ "star_func ::= COUNT",
 /* 341 */ "star_func ::= FIRST",
 /* 342 */ "star_func ::= LAST",
 /* 343 */ "star_func ::= LAST_ROW",
 /* 344 */ "star_func_para_list ::= NK_STAR",
 /* 345 */ "star_func_para_list ::= other_para_list",
 /* 346 */ "other_para_list ::= star_func_para",
 /* 347 */ "other_para_list ::= other_para_list NK_COMMA star_func_para",
 /* 348 */ "star_func_para ::= expression",
 /* 349 */ "star_func_para ::= table_name NK_DOT NK_STAR",
 /* 350 */ "predicate ::= expression compare_op expression",
 /* 351 */ "predicate ::= expression BETWEEN expression AND expression",
 /* 352 */ "predicate ::= expression NOT BETWEEN expression AND expression",
 /* 353 */ "predicate ::= expression IS NULL",
 /* 354 */ "predicate ::= expression IS NOT NULL",
 /* 355 */ "predicate ::= expression in_op in_predicate_value",
 /* 356 */ "compare_op ::= NK_LT",
 /* 357 */ "compare_op ::= NK_GT",
 /* 358 */ "compare_op ::= NK_LE",
 /* 359 */ "compare_op ::= NK_GE",
 /* 360 */ "compare_op ::= NK_NE",
 /* 361 */ "compare_op ::= NK_EQ",
 /* 362 */ "compare_op ::= LIKE",
 /* 363 */ "compare_op ::= NOT LIKE",
 /* 364 */ "compare_op ::= MATCH",
 /* 365 */ "compare_op ::= NMATCH",
 /* 366 */ "compare_op ::= CONTAINS",
 /* 367 */ "in_op ::= IN",
 /* 368 */ "in_op ::= NOT IN",
 /* 369 */ "in_predicate_value ::= NK_LP expression_list NK_RP",
 /* 370 */ "boolean_value_expression ::= boolean_primary",
 /* 371 */ "boolean_value_expression ::= NOT boolean_primary",
 /* 372 */ "boolean_value_expression ::= boolean_value_expression OR boolean_value_expression",
 /* 373 */ "boolean_value_expression ::= boolean_value_expression AND boolean_value_expression",
 /* 374 */ "boolean_primary ::= predicate",
 /* 375 */ "boolean_primary ::= NK_LP boolean_value_expression NK_RP",
 /* 376 */ "common_expression ::= expression",
 /* 377 */ "common_expression ::= boolean_value_expression",
 /* 378 */ "from_clause ::= FROM table_reference_list",
 /* 379 */ "table_reference_list ::= table_reference",
 /* 380 */ "table_reference_list ::= table_reference_list NK_COMMA table_reference",
 /* 381 */ "table_reference ::= table_primary",
 /* 382 */ "table_reference ::= joined_table",
 /* 383 */ "table_primary ::= table_name alias_opt",
 /* 384 */ "table_primary ::= db_name NK_DOT table_name alias_opt",
 /* 385 */ "table_primary ::= subquery alias_opt",
 /* 386 */ "table_primary ::= parenthesized_joined_table",
 /* 387 */ "alias_opt ::=",
 /* 388 */ "alias_opt ::= table_alias",
 /* 389 */ "alias_opt ::= AS table_alias",
 /* 390 */ "parenthesized_joined_table ::= NK_LP joined_table NK_RP",
 /* 391 */ "parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP",
 /* 392 */ "joined_table ::= table_reference join_type JOIN table_reference ON search_condition",
 /* 393 */ "join_type ::=",
 /* 394 */ "join_type ::= INNER",
 /* 395 */ "query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt",
 /* 396 */ "set_quantifier_opt ::=",
 /* 397 */ "set_quantifier_opt ::= DISTINCT",
 /* 398 */ "set_quantifier_opt ::= ALL",
 /* 399 */ "select_list ::= NK_STAR",
 /* 400 */ "select_list ::= select_sublist",
 /* 401 */ "select_sublist ::= select_item",
 /* 402 */ "select_sublist ::= select_sublist NK_COMMA select_item",
 /* 403 */ "select_item ::= common_expression",
 /* 404 */ "select_item ::= common_expression column_alias",
 /* 405 */ "select_item ::= common_expression AS column_alias",
 /* 406 */ "select_item ::= table_name NK_DOT NK_STAR",
 /* 407 */ "where_clause_opt ::=",
 /* 408 */ "where_clause_opt ::= WHERE search_condition",
 /* 409 */ "partition_by_clause_opt ::=",
 /* 410 */ "partition_by_clause_opt ::= PARTITION BY expression_list",
 /* 411 */ "twindow_clause_opt ::=",
 /* 412 */ "twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP",
 /* 413 */ "twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP",
 /* 414 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt",
 /* 415 */ "twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt",
 /* 416 */ "sliding_opt ::=",
 /* 417 */ "sliding_opt ::= SLIDING NK_LP duration_literal NK_RP",
 /* 418 */ "fill_opt ::=",
 /* 419 */ "fill_opt ::= FILL NK_LP fill_mode NK_RP",
 /* 420 */ "fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP",
 /* 421 */ "fill_mode ::= NONE",
 /* 422 */ "fill_mode ::= PREV",
 /* 423 */ "fill_mode ::= NULL",
 /* 424 */ "fill_mode ::= LINEAR",
 /* 425 */ "fill_mode ::= NEXT",
 /* 426 */ "group_by_clause_opt ::=",
 /* 427 */ "group_by_clause_opt ::= GROUP BY group_by_list",
 /* 428 */ "group_by_list ::= expression",
 /* 429 */ "group_by_list ::= group_by_list NK_COMMA expression",
 /* 430 */ "having_clause_opt ::=",
 /* 431 */ "having_clause_opt ::= HAVING search_condition",
 /* 432 */ "query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt",
 /* 433 */ "query_expression_body ::= query_primary",
 /* 434 */ "query_expression_body ::= query_expression_body UNION ALL query_expression_body",
 /* 435 */ "query_expression_body ::= query_expression_body UNION query_expression_body",
 /* 436 */ "query_primary ::= query_specification",
 /* 437 */ "query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP",
 /* 438 */ "order_by_clause_opt ::=",
 /* 439 */ "order_by_clause_opt ::= ORDER BY sort_specification_list",
 /* 440 */ "slimit_clause_opt ::=",
 /* 441 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER",
 /* 442 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER",
 /* 443 */ "slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 444 */ "limit_clause_opt ::=",
 /* 445 */ "limit_clause_opt ::= LIMIT NK_INTEGER",
 /* 446 */ "limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER",
 /* 447 */ "limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER",
 /* 448 */ "subquery ::= NK_LP query_expression NK_RP",
 /* 449 */ "search_condition ::= common_expression",
 /* 450 */ "sort_specification_list ::= sort_specification",
 /* 451 */ "sort_specification_list ::= sort_specification_list NK_COMMA sort_specification",
 /* 452 */ "sort_specification ::= expression ordering_specification_opt null_ordering_opt",
 /* 453 */ "ordering_specification_opt ::=",
 /* 454 */ "ordering_specification_opt ::= ASC",
 /* 455 */ "ordering_specification_opt ::= DESC",
 /* 456 */ "null_ordering_opt ::=",
 /* 457 */ "null_ordering_opt ::= NULLS FIRST",
 /* 458 */ "null_ordering_opt ::= NULLS LAST",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.  Return the number
** of errors.  Return 0 on success.
*/
static int yyGrowStack(yyParser *p){
  int newSize;
  int idx;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  idx = p->yytos ? (int)(p->yytos - p->yystack) : 0;
  if( p->yystack==&p->yystk0 ){
    pNew = malloc(newSize*sizeof(pNew[0]));
    if( pNew ) pNew[0] = p->yystk0;
  }else{
    pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  }
  if( pNew ){
    p->yystack = pNew;
    p->yytos = &p->yystack[idx];
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows from %d to %d entries.\n",
              yyTracePrompt, p->yystksz, newSize);
    }
#endif
    p->yystksz = newSize;
  }
  return pNew==0; 
}
#endif

/* Datatype of the argument to the memory allocated passed as the
** second argument to ParseAlloc() below.  This can be changed by
** putting an appropriate #define in the %include section of the input
** grammar.
*/
#ifndef YYMALLOCARGTYPE
# define YYMALLOCARGTYPE size_t
#endif

/* Initialize a new parser that has already been allocated.
*/
void ParseInit(void *yypRawParser ParseCTX_PDECL){
  yyParser *yypParser = (yyParser*)yypRawParser;
  ParseCTX_STORE
#ifdef YYTRACKMAXSTACKDEPTH
  yypParser->yyhwm = 0;
#endif
#if YYSTACKDEPTH<=0
  yypParser->yytos = NULL;
  yypParser->yystack = NULL;
  yypParser->yystksz = 0;
  if( yyGrowStack(yypParser) ){
    yypParser->yystack = &yypParser->yystk0;
    yypParser->yystksz = 1;
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  yypParser->yytos = yypParser->yystack;
  yypParser->yystack[0].stateno = 0;
  yypParser->yystack[0].major = 0;
#if YYSTACKDEPTH>0
  yypParser->yystackEnd = &yypParser->yystack[YYSTACKDEPTH-1];
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to Parse and ParseFree.
*/
void *ParseAlloc(void *(*mallocProc)(YYMALLOCARGTYPE) ParseCTX_PDECL){
  yyParser *yypParser;
  yypParser = (yyParser*)(*mallocProc)( (YYMALLOCARGTYPE)sizeof(yyParser) );
  if( yypParser ){
    ParseCTX_STORE
    ParseInit(yypParser ParseCTX_PARAM);
  }
  return (void*)yypParser;
}
#endif /* Parse_ENGINEALWAYSONSTACK */


/* The following function deletes the "minor type" or semantic value
** associated with a symbol.  The symbol can be either a terminal
** or nonterminal. "yymajor" is the symbol code, and "yypminor" is
** a pointer to the value to be deleted.  The code used to do the 
** deletions is derived from the %destructor and/or %token_destructor
** directives of the input grammar.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  ParseARG_FETCH
  ParseCTX_FETCH
  switch( yymajor ){
    /* Here is inserted the actions which take place when a
    ** terminal or non-terminal is destroyed.  This can happen
    ** when the symbol is popped from the stack during a
    ** reduce or during error processing or when a parser is 
    ** being destroyed before it is finished parsing.
    **
    ** Note: during a reduce, the only symbols destroyed are those
    ** which appear on the RHS of the rule, but which are *not* used
    ** inside the C code.
    */
/********* Begin destructor definitions ***************************************/
      /* Default NON-TERMINAL Destructor */
    case 239: /* cmd */
    case 242: /* literal */
    case 253: /* db_options */
    case 255: /* alter_db_options */
    case 260: /* retention */
    case 261: /* full_table_name */
    case 264: /* table_options */
    case 268: /* alter_table_clause */
    case 269: /* alter_table_options */
    case 272: /* signed_literal */
    case 273: /* create_subtable_clause */
    case 276: /* drop_table_clause */
    case 279: /* column_def */
    case 283: /* duration_literal */
    case 284: /* rollup_func_name */
    case 286: /* col_name */
    case 287: /* db_name_cond_opt */
    case 288: /* like_pattern_opt */
    case 289: /* table_name_cond */
    case 290: /* from_db_opt */
    case 292: /* index_options */
    case 294: /* sliding_opt */
    case 295: /* func */
    case 298: /* query_expression */
    case 301: /* explain_options */
    case 305: /* stream_options */
    case 306: /* into_opt */
    case 308: /* where_clause_opt */
    case 309: /* signed */
    case 310: /* literal_func */
    case 313: /* expression */
    case 314: /* pseudo_column */
    case 315: /* column_reference */
    case 316: /* function_expression */
    case 317: /* subquery */
    case 322: /* star_func_para */
    case 323: /* predicate */
    case 326: /* in_predicate_value */
    case 327: /* boolean_value_expression */
    case 328: /* boolean_primary */
    case 329: /* common_expression */
    case 330: /* from_clause */
    case 331: /* table_reference_list */
    case 332: /* table_reference */
    case 333: /* table_primary */
    case 334: /* joined_table */
    case 336: /* parenthesized_joined_table */
    case 338: /* search_condition */
    case 339: /* query_specification */
    case 343: /* twindow_clause_opt */
    case 345: /* having_clause_opt */
    case 347: /* select_item */
    case 348: /* fill_opt */
    case 351: /* query_expression_body */
    case 353: /* slimit_clause_opt */
    case 354: /* limit_clause_opt */
    case 355: /* query_primary */
    case 357: /* sort_specification */
{
 nodesDestroyNode((yypminor->yy632)); 
}
      break;
    case 240: /* account_options */
    case 241: /* alter_account_options */
    case 243: /* alter_account_option */
    case 303: /* bufsize_opt */
{
 
}
      break;
    case 244: /* user_name */
    case 246: /* priv_level */
    case 249: /* db_name */
    case 250: /* dnode_endpoint */
    case 251: /* dnode_host_name */
    case 270: /* column_name */
    case 278: /* table_name */
    case 285: /* function_name */
    case 291: /* index_name */
    case 297: /* topic_name */
    case 299: /* cgroup_name */
    case 304: /* stream_name */
    case 311: /* table_alias */
    case 312: /* column_alias */
    case 318: /* star_func */
    case 320: /* noarg_func */
    case 335: /* alias_opt */
{
 
}
      break;
    case 245: /* privileges */
    case 247: /* priv_type_list */
    case 248: /* priv_type */
{
 
}
      break;
    case 252: /* not_exists_opt */
    case 254: /* exists_opt */
    case 300: /* analyze_opt */
    case 302: /* agg_func_opt */
    case 340: /* set_quantifier_opt */
{
 
}
      break;
    case 256: /* integer_list */
    case 257: /* variable_list */
    case 258: /* retention_list */
    case 262: /* column_def_list */
    case 263: /* tags_def_opt */
    case 265: /* multi_create_clause */
    case 266: /* tags_def */
    case 267: /* multi_drop_clause */
    case 274: /* specific_tags_opt */
    case 275: /* literal_list */
    case 277: /* col_name_list */
    case 280: /* duration_list */
    case 281: /* rollup_func_list */
    case 293: /* func_list */
    case 296: /* expression_list */
    case 307: /* dnode_list */
    case 319: /* star_func_para_list */
    case 321: /* other_para_list */
    case 341: /* select_list */
    case 342: /* partition_by_clause_opt */
    case 344: /* group_by_clause_opt */
    case 346: /* select_sublist */
    case 350: /* group_by_list */
    case 352: /* order_by_clause_opt */
    case 356: /* sort_specification_list */
{
 nodesDestroyList((yypminor->yy424)); 
}
      break;
    case 259: /* alter_db_option */
    case 282: /* alter_table_option */
{
 
}
      break;
    case 271: /* type_name */
{
 
}
      break;
    case 324: /* compare_op */
    case 325: /* in_op */
{
 
}
      break;
    case 337: /* join_type */
{
 
}
      break;
    case 349: /* fill_mode */
{
 
}
      break;
    case 358: /* ordering_specification_opt */
{
 
}
      break;
    case 359: /* null_ordering_opt */
{
 
}
      break;
/********* End destructor definitions *****************************************/
    default:  break;   /* If no destructor action specified: do nothing */
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
*/
static void yy_pop_parser_stack(yyParser *pParser){
  yyStackEntry *yytos;
  assert( pParser->yytos!=0 );
  assert( pParser->yytos > pParser->yystack );
  yytos = pParser->yytos--;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yy_destructor(pParser, yytos->major, &yytos->minor);
}

/*
** Clear all secondary memory allocations from the parser
*/
void ParseFinalize(void *p){
  yyParser *pParser = (yyParser*)p;
  while( pParser->yytos>pParser->yystack ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  if( pParser->yystack!=&pParser->yystk0 ) free(pParser->yystack);
#endif
}

#ifndef Parse_ENGINEALWAYSONSTACK
/* 
** Deallocate and destroy a parser.  Destructors are called for
** all stack elements before shutting the parser down.
**
** If the YYPARSEFREENEVERNULL macro exists (for example because it
** is defined in a %include section of the input grammar) then it is
** assumed that the input pointer is never NULL.
*/
void ParseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
#ifndef YYPARSEFREENEVERNULL
  if( p==0 ) return;
#endif
  ParseFinalize(p);
  (*freeProc)(p);
}
#endif /* Parse_ENGINEALWAYSONSTACK */

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int ParseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyhwm;
}
#endif

/* This array of booleans keeps track of the parser statement
** coverage.  The element yycoverage[X][Y] is set when the parser
** is in state X and has a lookahead token Y.  In a well-tested
** systems, every element of this matrix should end up being set.
*/
#if defined(YYCOVERAGE)
static unsigned char yycoverage[YYNSTATE][YYNTOKEN];
#endif

/*
** Write into out a description of every state/lookahead combination that
**
**   (1)  has not been used by the parser, and
**   (2)  is not a syntax error.
**
** Return the number of missed state/lookahead combinations.
*/
#if defined(YYCOVERAGE)
int ParseCoverage(FILE *out){
  int stateno, iLookAhead, i;
  int nMissed = 0;
  for(stateno=0; stateno<YYNSTATE; stateno++){
    i = yy_shift_ofst[stateno];
    for(iLookAhead=0; iLookAhead<YYNTOKEN; iLookAhead++){
      if( yy_lookahead[i+iLookAhead]!=iLookAhead ) continue;
      if( yycoverage[stateno][iLookAhead]==0 ) nMissed++;
      if( out ){
        fprintf(out,"State %d lookahead %s %s\n", stateno,
                yyTokenName[iLookAhead],
                yycoverage[stateno][iLookAhead] ? "ok" : "missed");
      }
    }
  }
  return nMissed;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_shift_action(
  YYCODETYPE iLookAhead,    /* The look-ahead token */
  YYACTIONTYPE stateno      /* Current state number */
){
  int i;

  if( stateno>YY_MAX_SHIFT ) return stateno;
  assert( stateno <= YY_SHIFT_COUNT );
#if defined(YYCOVERAGE)
  yycoverage[stateno][iLookAhead] = 1;
#endif
  do{
    i = yy_shift_ofst[stateno];
    assert( i>=0 );
    /* assert( i+YYNTOKEN<=(int)YY_NLOOKAHEAD ); */
    assert( iLookAhead!=YYNOCODE );
    assert( iLookAhead < YYNTOKEN );
    i += iLookAhead;
    if( i>=YY_NLOOKAHEAD || yy_lookahead[i]!=iLookAhead ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0 ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        assert( yyFallback[iFallback]==0 ); /* Fallback loop must terminate */
        iLookAhead = iFallback;
        continue;
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if( 
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          j<(int)(sizeof(yy_lookahead)/sizeof(yy_lookahead[0])) &&
          yy_lookahead[j]==YYWILDCARD && iLookAhead>0
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead],
               yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
      return yy_default[stateno];
    }else{
      return yy_action[i];
    }
  }while(1);
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
*/
static YYACTIONTYPE yy_find_reduce_action(
  YYACTIONTYPE stateno,     /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser){
   ParseARG_FETCH
   ParseCTX_FETCH
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */
/******** Begin %stack_overflow code ******************************************/
/******** End %stack_overflow code ********************************************/
   ParseARG_STORE /* Suppress warning about unused %extra_argument var */
   ParseCTX_STORE
}

/*
** Print tracing information for a SHIFT action
*/
#ifndef NDEBUG
static void yyTraceShift(yyParser *yypParser, int yyNewState, const char *zTag){
  if( yyTraceFILE ){
    if( yyNewState<YYNSTATE ){
      fprintf(yyTraceFILE,"%s%s '%s', go to state %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState);
    }else{
      fprintf(yyTraceFILE,"%s%s '%s', pending reduce %d\n",
         yyTracePrompt, zTag, yyTokenName[yypParser->yytos->major],
         yyNewState - YY_MIN_REDUCE);
    }
  }
}
#else
# define yyTraceShift(X,Y,Z)
#endif

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  YYACTIONTYPE yyNewState,      /* The new state to shift in */
  YYCODETYPE yyMajor,           /* The major token to shift in */
  ParseTOKENTYPE yyMinor        /* The minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yytos++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
    yypParser->yyhwm++;
    assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack) );
  }
#endif
#if YYSTACKDEPTH>0 
  if( yypParser->yytos>yypParser->yystackEnd ){
    yypParser->yytos--;
    yyStackOverflow(yypParser);
    return;
  }
#else
  if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz] ){
    if( yyGrowStack(yypParser) ){
      yypParser->yytos--;
      yyStackOverflow(yypParser);
      return;
    }
  }
#endif
  if( yyNewState > YY_MAX_SHIFT ){
    yyNewState += YY_MIN_REDUCE - YY_MIN_SHIFTREDUCE;
  }
  yytos = yypParser->yytos;
  yytos->stateno = yyNewState;
  yytos->major = yyMajor;
  yytos->minor.yy0 = yyMinor;
  yyTraceShift(yypParser, yyNewState, "Shift");
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;       /* Symbol on the left-hand side of the rule */
  signed char nrhs;     /* Negative of the number of RHS symbols in the rule */
} yyRuleInfo[] = {
  {  239,   -6 }, /* (0) cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
  {  239,   -4 }, /* (1) cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
  {  240,    0 }, /* (2) account_options ::= */
  {  240,   -3 }, /* (3) account_options ::= account_options PPS literal */
  {  240,   -3 }, /* (4) account_options ::= account_options TSERIES literal */
  {  240,   -3 }, /* (5) account_options ::= account_options STORAGE literal */
  {  240,   -3 }, /* (6) account_options ::= account_options STREAMS literal */
  {  240,   -3 }, /* (7) account_options ::= account_options QTIME literal */
  {  240,   -3 }, /* (8) account_options ::= account_options DBS literal */
  {  240,   -3 }, /* (9) account_options ::= account_options USERS literal */
  {  240,   -3 }, /* (10) account_options ::= account_options CONNS literal */
  {  240,   -3 }, /* (11) account_options ::= account_options STATE literal */
  {  241,   -1 }, /* (12) alter_account_options ::= alter_account_option */
  {  241,   -2 }, /* (13) alter_account_options ::= alter_account_options alter_account_option */
  {  243,   -2 }, /* (14) alter_account_option ::= PASS literal */
  {  243,   -2 }, /* (15) alter_account_option ::= PPS literal */
  {  243,   -2 }, /* (16) alter_account_option ::= TSERIES literal */
  {  243,   -2 }, /* (17) alter_account_option ::= STORAGE literal */
  {  243,   -2 }, /* (18) alter_account_option ::= STREAMS literal */
  {  243,   -2 }, /* (19) alter_account_option ::= QTIME literal */
  {  243,   -2 }, /* (20) alter_account_option ::= DBS literal */
  {  243,   -2 }, /* (21) alter_account_option ::= USERS literal */
  {  243,   -2 }, /* (22) alter_account_option ::= CONNS literal */
  {  243,   -2 }, /* (23) alter_account_option ::= STATE literal */
  {  239,   -5 }, /* (24) cmd ::= CREATE USER user_name PASS NK_STRING */
  {  239,   -5 }, /* (25) cmd ::= ALTER USER user_name PASS NK_STRING */
  {  239,   -5 }, /* (26) cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
  {  239,   -3 }, /* (27) cmd ::= DROP USER user_name */
  {  239,   -6 }, /* (28) cmd ::= GRANT privileges ON priv_level TO user_name */
  {  239,   -6 }, /* (29) cmd ::= REVOKE privileges ON priv_level FROM user_name */
  {  245,   -1 }, /* (30) privileges ::= ALL */
  {  245,   -1 }, /* (31) privileges ::= priv_type_list */
  {  247,   -1 }, /* (32) priv_type_list ::= priv_type */
  {  247,   -3 }, /* (33) priv_type_list ::= priv_type_list NK_COMMA priv_type */
  {  248,   -1 }, /* (34) priv_type ::= READ */
  {  248,   -1 }, /* (35) priv_type ::= WRITE */
  {  246,   -3 }, /* (36) priv_level ::= NK_STAR NK_DOT NK_STAR */
  {  246,   -3 }, /* (37) priv_level ::= db_name NK_DOT NK_STAR */
  {  239,   -3 }, /* (38) cmd ::= CREATE DNODE dnode_endpoint */
  {  239,   -5 }, /* (39) cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
  {  239,   -3 }, /* (40) cmd ::= DROP DNODE NK_INTEGER */
  {  239,   -3 }, /* (41) cmd ::= DROP DNODE dnode_endpoint */
  {  239,   -4 }, /* (42) cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
  {  239,   -5 }, /* (43) cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
  {  239,   -4 }, /* (44) cmd ::= ALTER ALL DNODES NK_STRING */
  {  239,   -5 }, /* (45) cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
  {  250,   -1 }, /* (46) dnode_endpoint ::= NK_STRING */
  {  251,   -1 }, /* (47) dnode_host_name ::= NK_ID */
  {  251,   -1 }, /* (48) dnode_host_name ::= NK_IPTOKEN */
  {  239,   -3 }, /* (49) cmd ::= ALTER LOCAL NK_STRING */
  {  239,   -4 }, /* (50) cmd ::= ALTER LOCAL NK_STRING NK_STRING */
  {  239,   -5 }, /* (51) cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (52) cmd ::= DROP QNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (53) cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (54) cmd ::= DROP BNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (55) cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (56) cmd ::= DROP SNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (57) cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (58) cmd ::= DROP MNODE ON DNODE NK_INTEGER */
  {  239,   -5 }, /* (59) cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
  {  239,   -4 }, /* (60) cmd ::= DROP DATABASE exists_opt db_name */
  {  239,   -2 }, /* (61) cmd ::= USE db_name */
  {  239,   -4 }, /* (62) cmd ::= ALTER DATABASE db_name alter_db_options */
  {  252,   -3 }, /* (63) not_exists_opt ::= IF NOT EXISTS */
  {  252,    0 }, /* (64) not_exists_opt ::= */
  {  254,   -2 }, /* (65) exists_opt ::= IF EXISTS */
  {  254,    0 }, /* (66) exists_opt ::= */
  {  253,    0 }, /* (67) db_options ::= */
  {  253,   -3 }, /* (68) db_options ::= db_options BUFFER NK_INTEGER */
  {  253,   -3 }, /* (69) db_options ::= db_options CACHELAST NK_INTEGER */
  {  253,   -3 }, /* (70) db_options ::= db_options COMP NK_INTEGER */
  {  253,   -3 }, /* (71) db_options ::= db_options DURATION NK_INTEGER */
  {  253,   -3 }, /* (72) db_options ::= db_options DURATION NK_VARIABLE */
  {  253,   -3 }, /* (73) db_options ::= db_options FSYNC NK_INTEGER */
  {  253,   -3 }, /* (74) db_options ::= db_options MAXROWS NK_INTEGER */
  {  253,   -3 }, /* (75) db_options ::= db_options MINROWS NK_INTEGER */
  {  253,   -3 }, /* (76) db_options ::= db_options KEEP integer_list */
  {  253,   -3 }, /* (77) db_options ::= db_options KEEP variable_list */
  {  253,   -3 }, /* (78) db_options ::= db_options PAGES NK_INTEGER */
  {  253,   -3 }, /* (79) db_options ::= db_options PAGESIZE NK_INTEGER */
  {  253,   -3 }, /* (80) db_options ::= db_options PRECISION NK_STRING */
  {  253,   -3 }, /* (81) db_options ::= db_options REPLICA NK_INTEGER */
  {  253,   -3 }, /* (82) db_options ::= db_options STRICT NK_INTEGER */
  {  253,   -3 }, /* (83) db_options ::= db_options WAL NK_INTEGER */
  {  253,   -3 }, /* (84) db_options ::= db_options VGROUPS NK_INTEGER */
  {  253,   -3 }, /* (85) db_options ::= db_options SINGLE_STABLE NK_INTEGER */
  {  253,   -3 }, /* (86) db_options ::= db_options RETENTIONS retention_list */
  {  253,   -3 }, /* (87) db_options ::= db_options SCHEMALESS NK_INTEGER */
  {  255,   -1 }, /* (88) alter_db_options ::= alter_db_option */
  {  255,   -2 }, /* (89) alter_db_options ::= alter_db_options alter_db_option */
  {  259,   -2 }, /* (90) alter_db_option ::= BUFFER NK_INTEGER */
  {  259,   -2 }, /* (91) alter_db_option ::= CACHELAST NK_INTEGER */
  {  259,   -2 }, /* (92) alter_db_option ::= FSYNC NK_INTEGER */
  {  259,   -2 }, /* (93) alter_db_option ::= KEEP integer_list */
  {  259,   -2 }, /* (94) alter_db_option ::= KEEP variable_list */
  {  259,   -2 }, /* (95) alter_db_option ::= PAGES NK_INTEGER */
  {  259,   -2 }, /* (96) alter_db_option ::= REPLICA NK_INTEGER */
  {  259,   -2 }, /* (97) alter_db_option ::= STRICT NK_INTEGER */
  {  259,   -2 }, /* (98) alter_db_option ::= WAL NK_INTEGER */
  {  256,   -1 }, /* (99) integer_list ::= NK_INTEGER */
  {  256,   -3 }, /* (100) integer_list ::= integer_list NK_COMMA NK_INTEGER */
  {  257,   -1 }, /* (101) variable_list ::= NK_VARIABLE */
  {  257,   -3 }, /* (102) variable_list ::= variable_list NK_COMMA NK_VARIABLE */
  {  258,   -1 }, /* (103) retention_list ::= retention */
  {  258,   -3 }, /* (104) retention_list ::= retention_list NK_COMMA retention */
  {  260,   -3 }, /* (105) retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
  {  239,   -9 }, /* (106) cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
  {  239,   -3 }, /* (107) cmd ::= CREATE TABLE multi_create_clause */
  {  239,   -9 }, /* (108) cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */
  {  239,   -3 }, /* (109) cmd ::= DROP TABLE multi_drop_clause */
  {  239,   -4 }, /* (110) cmd ::= DROP STABLE exists_opt full_table_name */
  {  239,   -3 }, /* (111) cmd ::= ALTER TABLE alter_table_clause */
  {  239,   -3 }, /* (112) cmd ::= ALTER STABLE alter_table_clause */
  {  268,   -2 }, /* (113) alter_table_clause ::= full_table_name alter_table_options */
  {  268,   -5 }, /* (114) alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
  {  268,   -4 }, /* (115) alter_table_clause ::= full_table_name DROP COLUMN column_name */
  {  268,   -5 }, /* (116) alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
  {  268,   -5 }, /* (117) alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
  {  268,   -5 }, /* (118) alter_table_clause ::= full_table_name ADD TAG column_name type_name */
  {  268,   -4 }, /* (119) alter_table_clause ::= full_table_name DROP TAG column_name */
  {  268,   -5 }, /* (120) alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
  {  268,   -5 }, /* (121) alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
  {  268,   -6 }, /* (122) alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
  {  265,   -1 }, /* (123) multi_create_clause ::= create_subtable_clause */
  {  265,   -2 }, /* (124) multi_create_clause ::= multi_create_clause create_subtable_clause */
  {  273,  -10 }, /* (125) create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
  {  267,   -1 }, /* (126) multi_drop_clause ::= drop_table_clause */
  {  267,   -2 }, /* (127) multi_drop_clause ::= multi_drop_clause drop_table_clause */
  {  276,   -2 }, /* (128) drop_table_clause ::= exists_opt full_table_name */
  {  274,    0 }, /* (129) specific_tags_opt ::= */
  {  274,   -3 }, /* (130) specific_tags_opt ::= NK_LP col_name_list NK_RP */
  {  261,   -1 }, /* (131) full_table_name ::= table_name */
  {  261,   -3 }, /* (132) full_table_name ::= db_name NK_DOT table_name */
  {  262,   -1 }, /* (133) column_def_list ::= column_def */
  {  262,   -3 }, /* (134) column_def_list ::= column_def_list NK_COMMA column_def */
  {  279,   -2 }, /* (135) column_def ::= column_name type_name */
  {  279,   -4 }, /* (136) column_def ::= column_name type_name COMMENT NK_STRING */
  {  271,   -1 }, /* (137) type_name ::= BOOL */
  {  271,   -1 }, /* (138) type_name ::= TINYINT */
  {  271,   -1 }, /* (139) type_name ::= SMALLINT */
  {  271,   -1 }, /* (140) type_name ::= INT */
  {  271,   -1 }, /* (141) type_name ::= INTEGER */
  {  271,   -1 }, /* (142) type_name ::= BIGINT */
  {  271,   -1 }, /* (143) type_name ::= FLOAT */
  {  271,   -1 }, /* (144) type_name ::= DOUBLE */
  {  271,   -4 }, /* (145) type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
  {  271,   -1 }, /* (146) type_name ::= TIMESTAMP */
  {  271,   -4 }, /* (147) type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
  {  271,   -2 }, /* (148) type_name ::= TINYINT UNSIGNED */
  {  271,   -2 }, /* (149) type_name ::= SMALLINT UNSIGNED */
  {  271,   -2 }, /* (150) type_name ::= INT UNSIGNED */
  {  271,   -2 }, /* (151) type_name ::= BIGINT UNSIGNED */
  {  271,   -1 }, /* (152) type_name ::= JSON */
  {  271,   -4 }, /* (153) type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
  {  271,   -1 }, /* (154) type_name ::= MEDIUMBLOB */
  {  271,   -1 }, /* (155) type_name ::= BLOB */
  {  271,   -4 }, /* (156) type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
  {  271,   -1 }, /* (157) type_name ::= DECIMAL */
  {  271,   -4 }, /* (158) type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
  {  271,   -6 }, /* (159) type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
  {  263,    0 }, /* (160) tags_def_opt ::= */
  {  263,   -1 }, /* (161) tags_def_opt ::= tags_def */
  {  266,   -4 }, /* (162) tags_def ::= TAGS NK_LP column_def_list NK_RP */
  {  264,    0 }, /* (163) table_options ::= */
  {  264,   -3 }, /* (164) table_options ::= table_options COMMENT NK_STRING */
  {  264,   -3 }, /* (165) table_options ::= table_options MAX_DELAY duration_list */
  {  264,   -3 }, /* (166) table_options ::= table_options WATERMARK duration_list */
  {  264,   -5 }, /* (167) table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
  {  264,   -3 }, /* (168) table_options ::= table_options TTL NK_INTEGER */
  {  264,   -5 }, /* (169) table_options ::= table_options SMA NK_LP col_name_list NK_RP */
  {  269,   -1 }, /* (170) alter_table_options ::= alter_table_option */
  {  269,   -2 }, /* (171) alter_table_options ::= alter_table_options alter_table_option */
  {  282,   -2 }, /* (172) alter_table_option ::= COMMENT NK_STRING */
  {  282,   -2 }, /* (173) alter_table_option ::= TTL NK_INTEGER */
  {  280,   -1 }, /* (174) duration_list ::= duration_literal */
  {  280,   -3 }, /* (175) duration_list ::= duration_list NK_COMMA duration_literal */
  {  281,   -1 }, /* (176) rollup_func_list ::= rollup_func_name */
  {  281,   -3 }, /* (177) rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */
  {  284,   -1 }, /* (178) rollup_func_name ::= function_name */
  {  284,   -1 }, /* (179) rollup_func_name ::= FIRST */
  {  284,   -1 }, /* (180) rollup_func_name ::= LAST */
  {  277,   -1 }, /* (181) col_name_list ::= col_name */
  {  277,   -3 }, /* (182) col_name_list ::= col_name_list NK_COMMA col_name */
  {  286,   -1 }, /* (183) col_name ::= column_name */
  {  239,   -2 }, /* (184) cmd ::= SHOW DNODES */
  {  239,   -2 }, /* (185) cmd ::= SHOW USERS */
  {  239,   -2 }, /* (186) cmd ::= SHOW DATABASES */
  {  239,   -4 }, /* (187) cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
  {  239,   -4 }, /* (188) cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
  {  239,   -3 }, /* (189) cmd ::= SHOW db_name_cond_opt VGROUPS */
  {  239,   -2 }, /* (190) cmd ::= SHOW MNODES */
  {  239,   -2 }, /* (191) cmd ::= SHOW MODULES */
  {  239,   -2 }, /* (192) cmd ::= SHOW QNODES */
  {  239,   -2 }, /* (193) cmd ::= SHOW FUNCTIONS */
  {  239,   -5 }, /* (194) cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
  {  239,   -2 }, /* (195) cmd ::= SHOW STREAMS */
  {  239,   -2 }, /* (196) cmd ::= SHOW ACCOUNTS */
  {  239,   -2 }, /* (197) cmd ::= SHOW APPS */
  {  239,   -2 }, /* (198) cmd ::= SHOW CONNECTIONS */
  {  239,   -2 }, /* (199) cmd ::= SHOW LICENCE */
  {  239,   -2 }, /* (200) cmd ::= SHOW GRANTS */
  {  239,   -4 }, /* (201) cmd ::= SHOW CREATE DATABASE db_name */
  {  239,   -4 }, /* (202) cmd ::= SHOW CREATE TABLE full_table_name */
  {  239,   -4 }, /* (203) cmd ::= SHOW CREATE STABLE full_table_name */
  {  239,   -2 }, /* (204) cmd ::= SHOW QUERIES */
  {  239,   -2 }, /* (205) cmd ::= SHOW SCORES */
  {  239,   -2 }, /* (206) cmd ::= SHOW TOPICS */
  {  239,   -2 }, /* (207) cmd ::= SHOW VARIABLES */
  {  239,   -2 }, /* (208) cmd ::= SHOW BNODES */
  {  239,   -2 }, /* (209) cmd ::= SHOW SNODES */
  {  239,   -2 }, /* (210) cmd ::= SHOW CLUSTER */
  {  239,   -2 }, /* (211) cmd ::= SHOW TRANSACTIONS */
  {  287,    0 }, /* (212) db_name_cond_opt ::= */
  {  287,   -2 }, /* (213) db_name_cond_opt ::= db_name NK_DOT */
  {  288,    0 }, /* (214) like_pattern_opt ::= */
  {  288,   -2 }, /* (215) like_pattern_opt ::= LIKE NK_STRING */
  {  289,   -1 }, /* (216) table_name_cond ::= table_name */
  {  290,    0 }, /* (217) from_db_opt ::= */
  {  290,   -2 }, /* (218) from_db_opt ::= FROM db_name */
  {  239,   -8 }, /* (219) cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
  {  239,  -10 }, /* (220) cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
  {  239,   -6 }, /* (221) cmd ::= DROP INDEX exists_opt index_name ON table_name */
  {  292,    0 }, /* (222) index_options ::= */
  {  292,   -9 }, /* (223) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
  {  292,  -11 }, /* (224) index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
  {  293,   -1 }, /* (225) func_list ::= func */
  {  293,   -3 }, /* (226) func_list ::= func_list NK_COMMA func */
  {  295,   -4 }, /* (227) func ::= function_name NK_LP expression_list NK_RP */
  {  239,   -6 }, /* (228) cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
  {  239,   -7 }, /* (229) cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
  {  239,   -7 }, /* (230) cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
  {  239,   -4 }, /* (231) cmd ::= DROP TOPIC exists_opt topic_name */
  {  239,   -7 }, /* (232) cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
  {  239,   -2 }, /* (233) cmd ::= DESC full_table_name */
  {  239,   -2 }, /* (234) cmd ::= DESCRIBE full_table_name */
  {  239,   -3 }, /* (235) cmd ::= RESET QUERY CACHE */
  {  239,   -4 }, /* (236) cmd ::= EXPLAIN analyze_opt explain_options query_expression */
  {  300,    0 }, /* (237) analyze_opt ::= */
  {  300,   -1 }, /* (238) analyze_opt ::= ANALYZE */
  {  301,    0 }, /* (239) explain_options ::= */
  {  301,   -3 }, /* (240) explain_options ::= explain_options VERBOSE NK_BOOL */
  {  301,   -3 }, /* (241) explain_options ::= explain_options RATIO NK_FLOAT */
  {  239,   -6 }, /* (242) cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
  {  239,  -10 }, /* (243) cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
  {  239,   -4 }, /* (244) cmd ::= DROP FUNCTION exists_opt function_name */
  {  302,    0 }, /* (245) agg_func_opt ::= */
  {  302,   -1 }, /* (246) agg_func_opt ::= AGGREGATE */
  {  303,    0 }, /* (247) bufsize_opt ::= */
  {  303,   -2 }, /* (248) bufsize_opt ::= BUFSIZE NK_INTEGER */
  {  239,   -8 }, /* (249) cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
  {  239,   -4 }, /* (250) cmd ::= DROP STREAM exists_opt stream_name */
  {  306,    0 }, /* (251) into_opt ::= */
  {  306,   -2 }, /* (252) into_opt ::= INTO full_table_name */
  {  305,    0 }, /* (253) stream_options ::= */
  {  305,   -3 }, /* (254) stream_options ::= stream_options TRIGGER AT_ONCE */
  {  305,   -3 }, /* (255) stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
  {  305,   -4 }, /* (256) stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
  {  305,   -3 }, /* (257) stream_options ::= stream_options WATERMARK duration_literal */
  {  239,   -3 }, /* (258) cmd ::= KILL CONNECTION NK_INTEGER */
  {  239,   -3 }, /* (259) cmd ::= KILL QUERY NK_STRING */
  {  239,   -3 }, /* (260) cmd ::= KILL TRANSACTION NK_INTEGER */
  {  239,   -2 }, /* (261) cmd ::= BALANCE VGROUP */
  {  239,   -4 }, /* (262) cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
  {  239,   -4 }, /* (263) cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
  {  239,   -3 }, /* (264) cmd ::= SPLIT VGROUP NK_INTEGER */
  {  307,   -2 }, /* (265) dnode_list ::= DNODE NK_INTEGER */
  {  307,   -3 }, /* (266) dnode_list ::= dnode_list DNODE NK_INTEGER */
  {  239,   -3 }, /* (267) cmd ::= SYNCDB db_name REPLICA */
  {  239,   -4 }, /* (268) cmd ::= DELETE FROM full_table_name where_clause_opt */
  {  239,   -1 }, /* (269) cmd ::= query_expression */
  {  242,   -1 }, /* (270) literal ::= NK_INTEGER */
  {  242,   -1 }, /* (271) literal ::= NK_FLOAT */
  {  242,   -1 }, /* (272) literal ::= NK_STRING */
  {  242,   -1 }, /* (273) literal ::= NK_BOOL */
  {  242,   -2 }, /* (274) literal ::= TIMESTAMP NK_STRING */
  {  242,   -1 }, /* (275) literal ::= duration_literal */
  {  242,   -1 }, /* (276) literal ::= NULL */
  {  242,   -1 }, /* (277) literal ::= NK_QUESTION */
  {  283,   -1 }, /* (278) duration_literal ::= NK_VARIABLE */
  {  309,   -1 }, /* (279) signed ::= NK_INTEGER */
  {  309,   -2 }, /* (280) signed ::= NK_PLUS NK_INTEGER */
  {  309,   -2 }, /* (281) signed ::= NK_MINUS NK_INTEGER */
  {  309,   -1 }, /* (282) signed ::= NK_FLOAT */
  {  309,   -2 }, /* (283) signed ::= NK_PLUS NK_FLOAT */
  {  309,   -2 }, /* (284) signed ::= NK_MINUS NK_FLOAT */
  {  272,   -1 }, /* (285) signed_literal ::= signed */
  {  272,   -1 }, /* (286) signed_literal ::= NK_STRING */
  {  272,   -1 }, /* (287) signed_literal ::= NK_BOOL */
  {  272,   -2 }, /* (288) signed_literal ::= TIMESTAMP NK_STRING */
  {  272,   -1 }, /* (289) signed_literal ::= duration_literal */
  {  272,   -1 }, /* (290) signed_literal ::= NULL */
  {  272,   -1 }, /* (291) signed_literal ::= literal_func */
  {  275,   -1 }, /* (292) literal_list ::= signed_literal */
  {  275,   -3 }, /* (293) literal_list ::= literal_list NK_COMMA signed_literal */
  {  249,   -1 }, /* (294) db_name ::= NK_ID */
  {  278,   -1 }, /* (295) table_name ::= NK_ID */
  {  270,   -1 }, /* (296) column_name ::= NK_ID */
  {  285,   -1 }, /* (297) function_name ::= NK_ID */
  {  311,   -1 }, /* (298) table_alias ::= NK_ID */
  {  312,   -1 }, /* (299) column_alias ::= NK_ID */
  {  244,   -1 }, /* (300) user_name ::= NK_ID */
  {  291,   -1 }, /* (301) index_name ::= NK_ID */
  {  297,   -1 }, /* (302) topic_name ::= NK_ID */
  {  304,   -1 }, /* (303) stream_name ::= NK_ID */
  {  299,   -1 }, /* (304) cgroup_name ::= NK_ID */
  {  313,   -1 }, /* (305) expression ::= literal */
  {  313,   -1 }, /* (306) expression ::= pseudo_column */
  {  313,   -1 }, /* (307) expression ::= column_reference */
  {  313,   -1 }, /* (308) expression ::= function_expression */
  {  313,   -1 }, /* (309) expression ::= subquery */
  {  313,   -3 }, /* (310) expression ::= NK_LP expression NK_RP */
  {  313,   -2 }, /* (311) expression ::= NK_PLUS expression */
  {  313,   -2 }, /* (312) expression ::= NK_MINUS expression */
  {  313,   -3 }, /* (313) expression ::= expression NK_PLUS expression */
  {  313,   -3 }, /* (314) expression ::= expression NK_MINUS expression */
  {  313,   -3 }, /* (315) expression ::= expression NK_STAR expression */
  {  313,   -3 }, /* (316) expression ::= expression NK_SLASH expression */
  {  313,   -3 }, /* (317) expression ::= expression NK_REM expression */
  {  313,   -3 }, /* (318) expression ::= column_reference NK_ARROW NK_STRING */
  {  296,   -1 }, /* (319) expression_list ::= expression */
  {  296,   -3 }, /* (320) expression_list ::= expression_list NK_COMMA expression */
  {  315,   -1 }, /* (321) column_reference ::= column_name */
  {  315,   -3 }, /* (322) column_reference ::= table_name NK_DOT column_name */
  {  314,   -1 }, /* (323) pseudo_column ::= ROWTS */
  {  314,   -1 }, /* (324) pseudo_column ::= TBNAME */
  {  314,   -3 }, /* (325) pseudo_column ::= table_name NK_DOT TBNAME */
  {  314,   -1 }, /* (326) pseudo_column ::= QSTARTTS */
  {  314,   -1 }, /* (327) pseudo_column ::= QENDTS */
  {  314,   -1 }, /* (328) pseudo_column ::= WSTARTTS */
  {  314,   -1 }, /* (329) pseudo_column ::= WENDTS */
  {  314,   -1 }, /* (330) pseudo_column ::= WDURATION */
  {  316,   -4 }, /* (331) function_expression ::= function_name NK_LP expression_list NK_RP */
  {  316,   -4 }, /* (332) function_expression ::= star_func NK_LP star_func_para_list NK_RP */
  {  316,   -6 }, /* (333) function_expression ::= CAST NK_LP expression AS type_name NK_RP */
  {  316,   -1 }, /* (334) function_expression ::= literal_func */
  {  310,   -3 }, /* (335) literal_func ::= noarg_func NK_LP NK_RP */
  {  310,   -1 }, /* (336) literal_func ::= NOW */
  {  320,   -1 }, /* (337) noarg_func ::= NOW */
  {  320,   -1 }, /* (338) noarg_func ::= TODAY */
  {  320,   -1 }, /* (339) noarg_func ::= TIMEZONE */
  {  318,   -1 }, /* (340) star_func ::= COUNT */
  {  318,   -1 }, /* (341) star_func ::= FIRST */
  {  318,   -1 }, /* (342) star_func ::= LAST */
  {  318,   -1 }, /* (343) star_func ::= LAST_ROW */
  {  319,   -1 }, /* (344) star_func_para_list ::= NK_STAR */
  {  319,   -1 }, /* (345) star_func_para_list ::= other_para_list */
  {  321,   -1 }, /* (346) other_para_list ::= star_func_para */
  {  321,   -3 }, /* (347) other_para_list ::= other_para_list NK_COMMA star_func_para */
  {  322,   -1 }, /* (348) star_func_para ::= expression */
  {  322,   -3 }, /* (349) star_func_para ::= table_name NK_DOT NK_STAR */
  {  323,   -3 }, /* (350) predicate ::= expression compare_op expression */
  {  323,   -5 }, /* (351) predicate ::= expression BETWEEN expression AND expression */
  {  323,   -6 }, /* (352) predicate ::= expression NOT BETWEEN expression AND expression */
  {  323,   -3 }, /* (353) predicate ::= expression IS NULL */
  {  323,   -4 }, /* (354) predicate ::= expression IS NOT NULL */
  {  323,   -3 }, /* (355) predicate ::= expression in_op in_predicate_value */
  {  324,   -1 }, /* (356) compare_op ::= NK_LT */
  {  324,   -1 }, /* (357) compare_op ::= NK_GT */
  {  324,   -1 }, /* (358) compare_op ::= NK_LE */
  {  324,   -1 }, /* (359) compare_op ::= NK_GE */
  {  324,   -1 }, /* (360) compare_op ::= NK_NE */
  {  324,   -1 }, /* (361) compare_op ::= NK_EQ */
  {  324,   -1 }, /* (362) compare_op ::= LIKE */
  {  324,   -2 }, /* (363) compare_op ::= NOT LIKE */
  {  324,   -1 }, /* (364) compare_op ::= MATCH */
  {  324,   -1 }, /* (365) compare_op ::= NMATCH */
  {  324,   -1 }, /* (366) compare_op ::= CONTAINS */
  {  325,   -1 }, /* (367) in_op ::= IN */
  {  325,   -2 }, /* (368) in_op ::= NOT IN */
  {  326,   -3 }, /* (369) in_predicate_value ::= NK_LP expression_list NK_RP */
  {  327,   -1 }, /* (370) boolean_value_expression ::= boolean_primary */
  {  327,   -2 }, /* (371) boolean_value_expression ::= NOT boolean_primary */
  {  327,   -3 }, /* (372) boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
  {  327,   -3 }, /* (373) boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
  {  328,   -1 }, /* (374) boolean_primary ::= predicate */
  {  328,   -3 }, /* (375) boolean_primary ::= NK_LP boolean_value_expression NK_RP */
  {  329,   -1 }, /* (376) common_expression ::= expression */
  {  329,   -1 }, /* (377) common_expression ::= boolean_value_expression */
  {  330,   -2 }, /* (378) from_clause ::= FROM table_reference_list */
  {  331,   -1 }, /* (379) table_reference_list ::= table_reference */
  {  331,   -3 }, /* (380) table_reference_list ::= table_reference_list NK_COMMA table_reference */
  {  332,   -1 }, /* (381) table_reference ::= table_primary */
  {  332,   -1 }, /* (382) table_reference ::= joined_table */
  {  333,   -2 }, /* (383) table_primary ::= table_name alias_opt */
  {  333,   -4 }, /* (384) table_primary ::= db_name NK_DOT table_name alias_opt */
  {  333,   -2 }, /* (385) table_primary ::= subquery alias_opt */
  {  333,   -1 }, /* (386) table_primary ::= parenthesized_joined_table */
  {  335,    0 }, /* (387) alias_opt ::= */
  {  335,   -1 }, /* (388) alias_opt ::= table_alias */
  {  335,   -2 }, /* (389) alias_opt ::= AS table_alias */
  {  336,   -3 }, /* (390) parenthesized_joined_table ::= NK_LP joined_table NK_RP */
  {  336,   -3 }, /* (391) parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */
  {  334,   -6 }, /* (392) joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
  {  337,    0 }, /* (393) join_type ::= */
  {  337,   -1 }, /* (394) join_type ::= INNER */
  {  339,   -9 }, /* (395) query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
  {  340,    0 }, /* (396) set_quantifier_opt ::= */
  {  340,   -1 }, /* (397) set_quantifier_opt ::= DISTINCT */
  {  340,   -1 }, /* (398) set_quantifier_opt ::= ALL */
  {  341,   -1 }, /* (399) select_list ::= NK_STAR */
  {  341,   -1 }, /* (400) select_list ::= select_sublist */
  {  346,   -1 }, /* (401) select_sublist ::= select_item */
  {  346,   -3 }, /* (402) select_sublist ::= select_sublist NK_COMMA select_item */
  {  347,   -1 }, /* (403) select_item ::= common_expression */
  {  347,   -2 }, /* (404) select_item ::= common_expression column_alias */
  {  347,   -3 }, /* (405) select_item ::= common_expression AS column_alias */
  {  347,   -3 }, /* (406) select_item ::= table_name NK_DOT NK_STAR */
  {  308,    0 }, /* (407) where_clause_opt ::= */
  {  308,   -2 }, /* (408) where_clause_opt ::= WHERE search_condition */
  {  342,    0 }, /* (409) partition_by_clause_opt ::= */
  {  342,   -3 }, /* (410) partition_by_clause_opt ::= PARTITION BY expression_list */
  {  343,    0 }, /* (411) twindow_clause_opt ::= */
  {  343,   -6 }, /* (412) twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
  {  343,   -4 }, /* (413) twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
  {  343,   -6 }, /* (414) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
  {  343,   -8 }, /* (415) twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
  {  294,    0 }, /* (416) sliding_opt ::= */
  {  294,   -4 }, /* (417) sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
  {  348,    0 }, /* (418) fill_opt ::= */
  {  348,   -4 }, /* (419) fill_opt ::= FILL NK_LP fill_mode NK_RP */
  {  348,   -6 }, /* (420) fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
  {  349,   -1 }, /* (421) fill_mode ::= NONE */
  {  349,   -1 }, /* (422) fill_mode ::= PREV */
  {  349,   -1 }, /* (423) fill_mode ::= NULL */
  {  349,   -1 }, /* (424) fill_mode ::= LINEAR */
  {  349,   -1 }, /* (425) fill_mode ::= NEXT */
  {  344,    0 }, /* (426) group_by_clause_opt ::= */
  {  344,   -3 }, /* (427) group_by_clause_opt ::= GROUP BY group_by_list */
  {  350,   -1 }, /* (428) group_by_list ::= expression */
  {  350,   -3 }, /* (429) group_by_list ::= group_by_list NK_COMMA expression */
  {  345,    0 }, /* (430) having_clause_opt ::= */
  {  345,   -2 }, /* (431) having_clause_opt ::= HAVING search_condition */
  {  298,   -4 }, /* (432) query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
  {  351,   -1 }, /* (433) query_expression_body ::= query_primary */
  {  351,   -4 }, /* (434) query_expression_body ::= query_expression_body UNION ALL query_expression_body */
  {  351,   -3 }, /* (435) query_expression_body ::= query_expression_body UNION query_expression_body */
  {  355,   -1 }, /* (436) query_primary ::= query_specification */
  {  355,   -6 }, /* (437) query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
  {  352,    0 }, /* (438) order_by_clause_opt ::= */
  {  352,   -3 }, /* (439) order_by_clause_opt ::= ORDER BY sort_specification_list */
  {  353,    0 }, /* (440) slimit_clause_opt ::= */
  {  353,   -2 }, /* (441) slimit_clause_opt ::= SLIMIT NK_INTEGER */
  {  353,   -4 }, /* (442) slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
  {  353,   -4 }, /* (443) slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  354,    0 }, /* (444) limit_clause_opt ::= */
  {  354,   -2 }, /* (445) limit_clause_opt ::= LIMIT NK_INTEGER */
  {  354,   -4 }, /* (446) limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */
  {  354,   -4 }, /* (447) limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */
  {  317,   -3 }, /* (448) subquery ::= NK_LP query_expression NK_RP */
  {  338,   -1 }, /* (449) search_condition ::= common_expression */
  {  356,   -1 }, /* (450) sort_specification_list ::= sort_specification */
  {  356,   -3 }, /* (451) sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */
  {  357,   -3 }, /* (452) sort_specification ::= expression ordering_specification_opt null_ordering_opt */
  {  358,    0 }, /* (453) ordering_specification_opt ::= */
  {  358,   -1 }, /* (454) ordering_specification_opt ::= ASC */
  {  358,   -1 }, /* (455) ordering_specification_opt ::= DESC */
  {  359,    0 }, /* (456) null_ordering_opt ::= */
  {  359,   -2 }, /* (457) null_ordering_opt ::= NULLS FIRST */
  {  359,   -2 }, /* (458) null_ordering_opt ::= NULLS LAST */
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
**
** The yyLookahead and yyLookaheadToken parameters provide reduce actions
** access to the lookahead token (if any).  The yyLookahead will be YYNOCODE
** if the lookahead token has already been consumed.  As this procedure is
** only called from one place, optimizing compilers will in-line it, which
** means that the extra parameters have no performance impact.
*/
static YYACTIONTYPE yy_reduce(
  yyParser *yypParser,         /* The parser */
  unsigned int yyruleno,       /* Number of the rule by which to reduce */
  int yyLookahead,             /* Lookahead token, or YYNOCODE if none */
  ParseTOKENTYPE yyLookaheadToken  /* Value of the lookahead token */
  ParseCTX_PDECL                   /* %extra_context */
){
  int yygoto;                     /* The next state */
  YYACTIONTYPE yyact;             /* The next action */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  ParseARG_FETCH
  (void)yyLookahead;
  (void)yyLookaheadToken;
  yymsp = yypParser->yytos;
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    yysize = yyRuleInfo[yyruleno].nrhs;
    if( yysize ){
      fprintf(yyTraceFILE, "%sReduce %d [%s], go to state %d.\n",
        yyTracePrompt,
        yyruleno, yyRuleName[yyruleno], yymsp[yysize].stateno);
    }else{
      fprintf(yyTraceFILE, "%sReduce %d [%s].\n",
        yyTracePrompt, yyruleno, yyRuleName[yyruleno]);
    }
  }
#endif /* NDEBUG */

  /* Check that the stack is large enough to grow by a single entry
  ** if the RHS of the rule is empty.  This ensures that there is room
  ** enough on the stack to push the LHS value */
  if( yyRuleInfo[yyruleno].nrhs==0 ){
#ifdef YYTRACKMAXSTACKDEPTH
    if( (int)(yypParser->yytos - yypParser->yystack)>yypParser->yyhwm ){
      yypParser->yyhwm++;
      assert( yypParser->yyhwm == (int)(yypParser->yytos - yypParser->yystack));
    }
#endif
#if YYSTACKDEPTH>0 
    if( yypParser->yytos>=yypParser->yystackEnd ){
      yyStackOverflow(yypParser);
      /* The call to yyStackOverflow() above pops the stack until it is
      ** empty, causing the main parser loop to exit.  So the return value
      ** is never used and does not matter. */
      return 0;
    }
#else
    if( yypParser->yytos>=&yypParser->yystack[yypParser->yystksz-1] ){
      if( yyGrowStack(yypParser) ){
        yyStackOverflow(yypParser);
        /* The call to yyStackOverflow() above pops the stack until it is
        ** empty, causing the main parser loop to exit.  So the return value
        ** is never used and does not matter. */
        return 0;
      }
      yymsp = yypParser->yytos;
    }
#endif
  }

  switch( yyruleno ){
  /* Beginning here are the reduction cases.  A typical example
  ** follows:
  **   case 0:
  **  #line <lineno> <grammarfile>
  **     { ... }           // User supplied code
  **  #line <lineno> <thisfile>
  **     break;
  */
/********** Begin reduce actions **********************************************/
        YYMINORTYPE yylhsminor;
      case 0: /* cmd ::= CREATE ACCOUNT NK_ID PASS NK_STRING account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,240,&yymsp[0].minor);
        break;
      case 1: /* cmd ::= ALTER ACCOUNT NK_ID alter_account_options */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
  yy_destructor(yypParser,241,&yymsp[0].minor);
        break;
      case 2: /* account_options ::= */
{ }
        break;
      case 3: /* account_options ::= account_options PPS literal */
      case 4: /* account_options ::= account_options TSERIES literal */ yytestcase(yyruleno==4);
      case 5: /* account_options ::= account_options STORAGE literal */ yytestcase(yyruleno==5);
      case 6: /* account_options ::= account_options STREAMS literal */ yytestcase(yyruleno==6);
      case 7: /* account_options ::= account_options QTIME literal */ yytestcase(yyruleno==7);
      case 8: /* account_options ::= account_options DBS literal */ yytestcase(yyruleno==8);
      case 9: /* account_options ::= account_options USERS literal */ yytestcase(yyruleno==9);
      case 10: /* account_options ::= account_options CONNS literal */ yytestcase(yyruleno==10);
      case 11: /* account_options ::= account_options STATE literal */ yytestcase(yyruleno==11);
{  yy_destructor(yypParser,240,&yymsp[-2].minor);
{ }
  yy_destructor(yypParser,242,&yymsp[0].minor);
}
        break;
      case 12: /* alter_account_options ::= alter_account_option */
{  yy_destructor(yypParser,243,&yymsp[0].minor);
{ }
}
        break;
      case 13: /* alter_account_options ::= alter_account_options alter_account_option */
{  yy_destructor(yypParser,241,&yymsp[-1].minor);
{ }
  yy_destructor(yypParser,243,&yymsp[0].minor);
}
        break;
      case 14: /* alter_account_option ::= PASS literal */
      case 15: /* alter_account_option ::= PPS literal */ yytestcase(yyruleno==15);
      case 16: /* alter_account_option ::= TSERIES literal */ yytestcase(yyruleno==16);
      case 17: /* alter_account_option ::= STORAGE literal */ yytestcase(yyruleno==17);
      case 18: /* alter_account_option ::= STREAMS literal */ yytestcase(yyruleno==18);
      case 19: /* alter_account_option ::= QTIME literal */ yytestcase(yyruleno==19);
      case 20: /* alter_account_option ::= DBS literal */ yytestcase(yyruleno==20);
      case 21: /* alter_account_option ::= USERS literal */ yytestcase(yyruleno==21);
      case 22: /* alter_account_option ::= CONNS literal */ yytestcase(yyruleno==22);
      case 23: /* alter_account_option ::= STATE literal */ yytestcase(yyruleno==23);
{ }
  yy_destructor(yypParser,242,&yymsp[0].minor);
        break;
      case 24: /* cmd ::= CREATE USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createCreateUserStmt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0); }
        break;
      case 25: /* cmd ::= ALTER USER user_name PASS NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy209, TSDB_ALTER_USER_PASSWD, &yymsp[0].minor.yy0); }
        break;
      case 26: /* cmd ::= ALTER USER user_name PRIVILEGE NK_STRING */
{ pCxt->pRootNode = createAlterUserStmt(pCxt, &yymsp[-2].minor.yy209, TSDB_ALTER_USER_PRIVILEGES, &yymsp[0].minor.yy0); }
        break;
      case 27: /* cmd ::= DROP USER user_name */
{ pCxt->pRootNode = createDropUserStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 28: /* cmd ::= GRANT privileges ON priv_level TO user_name */
{ pCxt->pRootNode = createGrantStmt(pCxt, yymsp[-4].minor.yy189, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209); }
        break;
      case 29: /* cmd ::= REVOKE privileges ON priv_level FROM user_name */
{ pCxt->pRootNode = createRevokeStmt(pCxt, yymsp[-4].minor.yy189, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209); }
        break;
      case 30: /* privileges ::= ALL */
{ yymsp[0].minor.yy189 = PRIVILEGE_TYPE_ALL; }
        break;
      case 31: /* privileges ::= priv_type_list */
      case 32: /* priv_type_list ::= priv_type */ yytestcase(yyruleno==32);
{ yylhsminor.yy189 = yymsp[0].minor.yy189; }
  yymsp[0].minor.yy189 = yylhsminor.yy189;
        break;
      case 33: /* priv_type_list ::= priv_type_list NK_COMMA priv_type */
{ yylhsminor.yy189 = yymsp[-2].minor.yy189 | yymsp[0].minor.yy189; }
  yymsp[-2].minor.yy189 = yylhsminor.yy189;
        break;
      case 34: /* priv_type ::= READ */
{ yymsp[0].minor.yy189 = PRIVILEGE_TYPE_READ; }
        break;
      case 35: /* priv_type ::= WRITE */
{ yymsp[0].minor.yy189 = PRIVILEGE_TYPE_WRITE; }
        break;
      case 36: /* priv_level ::= NK_STAR NK_DOT NK_STAR */
{ yylhsminor.yy209 = yymsp[-2].minor.yy0; }
  yymsp[-2].minor.yy209 = yylhsminor.yy209;
        break;
      case 37: /* priv_level ::= db_name NK_DOT NK_STAR */
{ yylhsminor.yy209 = yymsp[-2].minor.yy209; }
  yymsp[-2].minor.yy209 = yylhsminor.yy209;
        break;
      case 38: /* cmd ::= CREATE DNODE dnode_endpoint */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[0].minor.yy209, NULL); }
        break;
      case 39: /* cmd ::= CREATE DNODE dnode_host_name PORT NK_INTEGER */
{ pCxt->pRootNode = createCreateDnodeStmt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0); }
        break;
      case 40: /* cmd ::= DROP DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 41: /* cmd ::= DROP DNODE dnode_endpoint */
{ pCxt->pRootNode = createDropDnodeStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 42: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, NULL); }
        break;
      case 43: /* cmd ::= ALTER DNODE NK_INTEGER NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, &yymsp[-2].minor.yy0, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 44: /* cmd ::= ALTER ALL DNODES NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[0].minor.yy0, NULL); }
        break;
      case 45: /* cmd ::= ALTER ALL DNODES NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterDnodeStmt(pCxt, NULL, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 46: /* dnode_endpoint ::= NK_STRING */
      case 47: /* dnode_host_name ::= NK_ID */ yytestcase(yyruleno==47);
      case 48: /* dnode_host_name ::= NK_IPTOKEN */ yytestcase(yyruleno==48);
      case 294: /* db_name ::= NK_ID */ yytestcase(yyruleno==294);
      case 295: /* table_name ::= NK_ID */ yytestcase(yyruleno==295);
      case 296: /* column_name ::= NK_ID */ yytestcase(yyruleno==296);
      case 297: /* function_name ::= NK_ID */ yytestcase(yyruleno==297);
      case 298: /* table_alias ::= NK_ID */ yytestcase(yyruleno==298);
      case 299: /* column_alias ::= NK_ID */ yytestcase(yyruleno==299);
      case 300: /* user_name ::= NK_ID */ yytestcase(yyruleno==300);
      case 301: /* index_name ::= NK_ID */ yytestcase(yyruleno==301);
      case 302: /* topic_name ::= NK_ID */ yytestcase(yyruleno==302);
      case 303: /* stream_name ::= NK_ID */ yytestcase(yyruleno==303);
      case 304: /* cgroup_name ::= NK_ID */ yytestcase(yyruleno==304);
      case 337: /* noarg_func ::= NOW */ yytestcase(yyruleno==337);
      case 338: /* noarg_func ::= TODAY */ yytestcase(yyruleno==338);
      case 339: /* noarg_func ::= TIMEZONE */ yytestcase(yyruleno==339);
      case 340: /* star_func ::= COUNT */ yytestcase(yyruleno==340);
      case 341: /* star_func ::= FIRST */ yytestcase(yyruleno==341);
      case 342: /* star_func ::= LAST */ yytestcase(yyruleno==342);
      case 343: /* star_func ::= LAST_ROW */ yytestcase(yyruleno==343);
{ yylhsminor.yy209 = yymsp[0].minor.yy0; }
  yymsp[0].minor.yy209 = yylhsminor.yy209;
        break;
      case 49: /* cmd ::= ALTER LOCAL NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 50: /* cmd ::= ALTER LOCAL NK_STRING NK_STRING */
{ pCxt->pRootNode = createAlterLocalStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 51: /* cmd ::= CREATE QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 52: /* cmd ::= DROP QNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_QNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 53: /* cmd ::= CREATE BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 54: /* cmd ::= DROP BNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_BNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 55: /* cmd ::= CREATE SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 56: /* cmd ::= DROP SNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_SNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 57: /* cmd ::= CREATE MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createCreateComponentNodeStmt(pCxt, QUERY_NODE_CREATE_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 58: /* cmd ::= DROP MNODE ON DNODE NK_INTEGER */
{ pCxt->pRootNode = createDropComponentNodeStmt(pCxt, QUERY_NODE_DROP_MNODE_STMT, &yymsp[0].minor.yy0); }
        break;
      case 59: /* cmd ::= CREATE DATABASE not_exists_opt db_name db_options */
{ pCxt->pRootNode = createCreateDatabaseStmt(pCxt, yymsp[-2].minor.yy137, &yymsp[-1].minor.yy209, yymsp[0].minor.yy632); }
        break;
      case 60: /* cmd ::= DROP DATABASE exists_opt db_name */
{ pCxt->pRootNode = createDropDatabaseStmt(pCxt, yymsp[-1].minor.yy137, &yymsp[0].minor.yy209); }
        break;
      case 61: /* cmd ::= USE db_name */
{ pCxt->pRootNode = createUseDatabaseStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 62: /* cmd ::= ALTER DATABASE db_name alter_db_options */
{ pCxt->pRootNode = createAlterDatabaseStmt(pCxt, &yymsp[-1].minor.yy209, yymsp[0].minor.yy632); }
        break;
      case 63: /* not_exists_opt ::= IF NOT EXISTS */
{ yymsp[-2].minor.yy137 = true; }
        break;
      case 64: /* not_exists_opt ::= */
      case 66: /* exists_opt ::= */ yytestcase(yyruleno==66);
      case 237: /* analyze_opt ::= */ yytestcase(yyruleno==237);
      case 245: /* agg_func_opt ::= */ yytestcase(yyruleno==245);
      case 396: /* set_quantifier_opt ::= */ yytestcase(yyruleno==396);
{ yymsp[1].minor.yy137 = false; }
        break;
      case 65: /* exists_opt ::= IF EXISTS */
{ yymsp[-1].minor.yy137 = true; }
        break;
      case 67: /* db_options ::= */
{ yymsp[1].minor.yy632 = createDefaultDatabaseOptions(pCxt); }
        break;
      case 68: /* db_options ::= db_options BUFFER NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_BUFFER, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 69: /* db_options ::= db_options CACHELAST NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_CACHELAST, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 70: /* db_options ::= db_options COMP NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_COMP, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 71: /* db_options ::= db_options DURATION NK_INTEGER */
      case 72: /* db_options ::= db_options DURATION NK_VARIABLE */ yytestcase(yyruleno==72);
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_DAYS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 73: /* db_options ::= db_options FSYNC NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_FSYNC, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 74: /* db_options ::= db_options MAXROWS NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_MAXROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 75: /* db_options ::= db_options MINROWS NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_MINROWS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 76: /* db_options ::= db_options KEEP integer_list */
      case 77: /* db_options ::= db_options KEEP variable_list */ yytestcase(yyruleno==77);
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_KEEP, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 78: /* db_options ::= db_options PAGES NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_PAGES, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 79: /* db_options ::= db_options PAGESIZE NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_PAGESIZE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 80: /* db_options ::= db_options PRECISION NK_STRING */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_PRECISION, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 81: /* db_options ::= db_options REPLICA NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_REPLICA, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 82: /* db_options ::= db_options STRICT NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_STRICT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 83: /* db_options ::= db_options WAL NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_WAL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 84: /* db_options ::= db_options VGROUPS NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_VGROUPS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 85: /* db_options ::= db_options SINGLE_STABLE NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_SINGLE_STABLE, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 86: /* db_options ::= db_options RETENTIONS retention_list */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_RETENTIONS, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 87: /* db_options ::= db_options SCHEMALESS NK_INTEGER */
{ yylhsminor.yy632 = setDatabaseOption(pCxt, yymsp[-2].minor.yy632, DB_OPTION_SCHEMALESS, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 88: /* alter_db_options ::= alter_db_option */
{ yylhsminor.yy632 = createAlterDatabaseOptions(pCxt); yylhsminor.yy632 = setAlterDatabaseOption(pCxt, yylhsminor.yy632, &yymsp[0].minor.yy605); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 89: /* alter_db_options ::= alter_db_options alter_db_option */
{ yylhsminor.yy632 = setAlterDatabaseOption(pCxt, yymsp[-1].minor.yy632, &yymsp[0].minor.yy605); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 90: /* alter_db_option ::= BUFFER NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_BUFFER; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 91: /* alter_db_option ::= CACHELAST NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_CACHELAST; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 92: /* alter_db_option ::= FSYNC NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_FSYNC; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 93: /* alter_db_option ::= KEEP integer_list */
      case 94: /* alter_db_option ::= KEEP variable_list */ yytestcase(yyruleno==94);
{ yymsp[-1].minor.yy605.type = DB_OPTION_KEEP; yymsp[-1].minor.yy605.pList = yymsp[0].minor.yy424; }
        break;
      case 95: /* alter_db_option ::= PAGES NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_PAGES; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 96: /* alter_db_option ::= REPLICA NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_REPLICA; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 97: /* alter_db_option ::= STRICT NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_STRICT; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 98: /* alter_db_option ::= WAL NK_INTEGER */
{ yymsp[-1].minor.yy605.type = DB_OPTION_WAL; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 99: /* integer_list ::= NK_INTEGER */
{ yylhsminor.yy424 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 100: /* integer_list ::= integer_list NK_COMMA NK_INTEGER */
      case 266: /* dnode_list ::= dnode_list DNODE NK_INTEGER */ yytestcase(yyruleno==266);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 101: /* variable_list ::= NK_VARIABLE */
{ yylhsminor.yy424 = createNodeList(pCxt, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 102: /* variable_list ::= variable_list NK_COMMA NK_VARIABLE */
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 103: /* retention_list ::= retention */
      case 123: /* multi_create_clause ::= create_subtable_clause */ yytestcase(yyruleno==123);
      case 126: /* multi_drop_clause ::= drop_table_clause */ yytestcase(yyruleno==126);
      case 133: /* column_def_list ::= column_def */ yytestcase(yyruleno==133);
      case 176: /* rollup_func_list ::= rollup_func_name */ yytestcase(yyruleno==176);
      case 181: /* col_name_list ::= col_name */ yytestcase(yyruleno==181);
      case 225: /* func_list ::= func */ yytestcase(yyruleno==225);
      case 292: /* literal_list ::= signed_literal */ yytestcase(yyruleno==292);
      case 346: /* other_para_list ::= star_func_para */ yytestcase(yyruleno==346);
      case 401: /* select_sublist ::= select_item */ yytestcase(yyruleno==401);
      case 450: /* sort_specification_list ::= sort_specification */ yytestcase(yyruleno==450);
{ yylhsminor.yy424 = createNodeList(pCxt, yymsp[0].minor.yy632); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 104: /* retention_list ::= retention_list NK_COMMA retention */
      case 134: /* column_def_list ::= column_def_list NK_COMMA column_def */ yytestcase(yyruleno==134);
      case 177: /* rollup_func_list ::= rollup_func_list NK_COMMA rollup_func_name */ yytestcase(yyruleno==177);
      case 182: /* col_name_list ::= col_name_list NK_COMMA col_name */ yytestcase(yyruleno==182);
      case 226: /* func_list ::= func_list NK_COMMA func */ yytestcase(yyruleno==226);
      case 293: /* literal_list ::= literal_list NK_COMMA signed_literal */ yytestcase(yyruleno==293);
      case 347: /* other_para_list ::= other_para_list NK_COMMA star_func_para */ yytestcase(yyruleno==347);
      case 402: /* select_sublist ::= select_sublist NK_COMMA select_item */ yytestcase(yyruleno==402);
      case 451: /* sort_specification_list ::= sort_specification_list NK_COMMA sort_specification */ yytestcase(yyruleno==451);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, yymsp[0].minor.yy632); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 105: /* retention ::= NK_VARIABLE NK_COLON NK_VARIABLE */
{ yylhsminor.yy632 = createNodeListNodeEx(pCxt, createDurationValueNode(pCxt, &yymsp[-2].minor.yy0), createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 106: /* cmd ::= CREATE TABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def_opt table_options */
      case 108: /* cmd ::= CREATE STABLE not_exists_opt full_table_name NK_LP column_def_list NK_RP tags_def table_options */ yytestcase(yyruleno==108);
{ pCxt->pRootNode = createCreateTableStmt(pCxt, yymsp[-6].minor.yy137, yymsp[-5].minor.yy632, yymsp[-3].minor.yy424, yymsp[-1].minor.yy424, yymsp[0].minor.yy632); }
        break;
      case 107: /* cmd ::= CREATE TABLE multi_create_clause */
{ pCxt->pRootNode = createCreateMultiTableStmt(pCxt, yymsp[0].minor.yy424); }
        break;
      case 109: /* cmd ::= DROP TABLE multi_drop_clause */
{ pCxt->pRootNode = createDropTableStmt(pCxt, yymsp[0].minor.yy424); }
        break;
      case 110: /* cmd ::= DROP STABLE exists_opt full_table_name */
{ pCxt->pRootNode = createDropSuperTableStmt(pCxt, yymsp[-1].minor.yy137, yymsp[0].minor.yy632); }
        break;
      case 111: /* cmd ::= ALTER TABLE alter_table_clause */
      case 112: /* cmd ::= ALTER STABLE alter_table_clause */ yytestcase(yyruleno==112);
      case 269: /* cmd ::= query_expression */ yytestcase(yyruleno==269);
{ pCxt->pRootNode = yymsp[0].minor.yy632; }
        break;
      case 113: /* alter_table_clause ::= full_table_name alter_table_options */
{ yylhsminor.yy632 = createAlterTableModifyOptions(pCxt, yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 114: /* alter_table_clause ::= full_table_name ADD COLUMN column_name type_name */
{ yylhsminor.yy632 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_ADD_COLUMN, &yymsp[-1].minor.yy209, yymsp[0].minor.yy304); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 115: /* alter_table_clause ::= full_table_name DROP COLUMN column_name */
{ yylhsminor.yy632 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy632, TSDB_ALTER_TABLE_DROP_COLUMN, &yymsp[0].minor.yy209); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 116: /* alter_table_clause ::= full_table_name MODIFY COLUMN column_name type_name */
{ yylhsminor.yy632 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_UPDATE_COLUMN_BYTES, &yymsp[-1].minor.yy209, yymsp[0].minor.yy304); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 117: /* alter_table_clause ::= full_table_name RENAME COLUMN column_name column_name */
{ yylhsminor.yy632 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_UPDATE_COLUMN_NAME, &yymsp[-1].minor.yy209, &yymsp[0].minor.yy209); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 118: /* alter_table_clause ::= full_table_name ADD TAG column_name type_name */
{ yylhsminor.yy632 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_ADD_TAG, &yymsp[-1].minor.yy209, yymsp[0].minor.yy304); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 119: /* alter_table_clause ::= full_table_name DROP TAG column_name */
{ yylhsminor.yy632 = createAlterTableDropCol(pCxt, yymsp[-3].minor.yy632, TSDB_ALTER_TABLE_DROP_TAG, &yymsp[0].minor.yy209); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 120: /* alter_table_clause ::= full_table_name MODIFY TAG column_name type_name */
{ yylhsminor.yy632 = createAlterTableAddModifyCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_UPDATE_TAG_BYTES, &yymsp[-1].minor.yy209, yymsp[0].minor.yy304); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 121: /* alter_table_clause ::= full_table_name RENAME TAG column_name column_name */
{ yylhsminor.yy632 = createAlterTableRenameCol(pCxt, yymsp[-4].minor.yy632, TSDB_ALTER_TABLE_UPDATE_TAG_NAME, &yymsp[-1].minor.yy209, &yymsp[0].minor.yy209); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 122: /* alter_table_clause ::= full_table_name SET TAG column_name NK_EQ signed_literal */
{ yylhsminor.yy632 = createAlterTableSetTag(pCxt, yymsp[-5].minor.yy632, &yymsp[-2].minor.yy209, yymsp[0].minor.yy632); }
  yymsp[-5].minor.yy632 = yylhsminor.yy632;
        break;
      case 124: /* multi_create_clause ::= multi_create_clause create_subtable_clause */
      case 127: /* multi_drop_clause ::= multi_drop_clause drop_table_clause */ yytestcase(yyruleno==127);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-1].minor.yy424, yymsp[0].minor.yy632); }
  yymsp[-1].minor.yy424 = yylhsminor.yy424;
        break;
      case 125: /* create_subtable_clause ::= not_exists_opt full_table_name USING full_table_name specific_tags_opt TAGS NK_LP literal_list NK_RP table_options */
{ yylhsminor.yy632 = createCreateSubTableClause(pCxt, yymsp[-9].minor.yy137, yymsp[-8].minor.yy632, yymsp[-6].minor.yy632, yymsp[-5].minor.yy424, yymsp[-2].minor.yy424, yymsp[0].minor.yy632); }
  yymsp[-9].minor.yy632 = yylhsminor.yy632;
        break;
      case 128: /* drop_table_clause ::= exists_opt full_table_name */
{ yylhsminor.yy632 = createDropTableClause(pCxt, yymsp[-1].minor.yy137, yymsp[0].minor.yy632); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 129: /* specific_tags_opt ::= */
      case 160: /* tags_def_opt ::= */ yytestcase(yyruleno==160);
      case 409: /* partition_by_clause_opt ::= */ yytestcase(yyruleno==409);
      case 426: /* group_by_clause_opt ::= */ yytestcase(yyruleno==426);
      case 438: /* order_by_clause_opt ::= */ yytestcase(yyruleno==438);
{ yymsp[1].minor.yy424 = NULL; }
        break;
      case 130: /* specific_tags_opt ::= NK_LP col_name_list NK_RP */
{ yymsp[-2].minor.yy424 = yymsp[-1].minor.yy424; }
        break;
      case 131: /* full_table_name ::= table_name */
{ yylhsminor.yy632 = createRealTableNode(pCxt, NULL, &yymsp[0].minor.yy209, NULL); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 132: /* full_table_name ::= db_name NK_DOT table_name */
{ yylhsminor.yy632 = createRealTableNode(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209, NULL); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 135: /* column_def ::= column_name type_name */
{ yylhsminor.yy632 = createColumnDefNode(pCxt, &yymsp[-1].minor.yy209, yymsp[0].minor.yy304, NULL); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 136: /* column_def ::= column_name type_name COMMENT NK_STRING */
{ yylhsminor.yy632 = createColumnDefNode(pCxt, &yymsp[-3].minor.yy209, yymsp[-2].minor.yy304, &yymsp[0].minor.yy0); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 137: /* type_name ::= BOOL */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_BOOL); }
        break;
      case 138: /* type_name ::= TINYINT */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_TINYINT); }
        break;
      case 139: /* type_name ::= SMALLINT */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_SMALLINT); }
        break;
      case 140: /* type_name ::= INT */
      case 141: /* type_name ::= INTEGER */ yytestcase(yyruleno==141);
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_INT); }
        break;
      case 142: /* type_name ::= BIGINT */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_BIGINT); }
        break;
      case 143: /* type_name ::= FLOAT */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_FLOAT); }
        break;
      case 144: /* type_name ::= DOUBLE */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_DOUBLE); }
        break;
      case 145: /* type_name ::= BINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createVarLenDataType(TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy0); }
        break;
      case 146: /* type_name ::= TIMESTAMP */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_TIMESTAMP); }
        break;
      case 147: /* type_name ::= NCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createVarLenDataType(TSDB_DATA_TYPE_NCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 148: /* type_name ::= TINYINT UNSIGNED */
{ yymsp[-1].minor.yy304 = createDataType(TSDB_DATA_TYPE_UTINYINT); }
        break;
      case 149: /* type_name ::= SMALLINT UNSIGNED */
{ yymsp[-1].minor.yy304 = createDataType(TSDB_DATA_TYPE_USMALLINT); }
        break;
      case 150: /* type_name ::= INT UNSIGNED */
{ yymsp[-1].minor.yy304 = createDataType(TSDB_DATA_TYPE_UINT); }
        break;
      case 151: /* type_name ::= BIGINT UNSIGNED */
{ yymsp[-1].minor.yy304 = createDataType(TSDB_DATA_TYPE_UBIGINT); }
        break;
      case 152: /* type_name ::= JSON */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_JSON); }
        break;
      case 153: /* type_name ::= VARCHAR NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createVarLenDataType(TSDB_DATA_TYPE_VARCHAR, &yymsp[-1].minor.yy0); }
        break;
      case 154: /* type_name ::= MEDIUMBLOB */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_MEDIUMBLOB); }
        break;
      case 155: /* type_name ::= BLOB */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_BLOB); }
        break;
      case 156: /* type_name ::= VARBINARY NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createVarLenDataType(TSDB_DATA_TYPE_VARBINARY, &yymsp[-1].minor.yy0); }
        break;
      case 157: /* type_name ::= DECIMAL */
{ yymsp[0].minor.yy304 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 158: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_RP */
{ yymsp[-3].minor.yy304 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 159: /* type_name ::= DECIMAL NK_LP NK_INTEGER NK_COMMA NK_INTEGER NK_RP */
{ yymsp[-5].minor.yy304 = createDataType(TSDB_DATA_TYPE_DECIMAL); }
        break;
      case 161: /* tags_def_opt ::= tags_def */
      case 345: /* star_func_para_list ::= other_para_list */ yytestcase(yyruleno==345);
      case 400: /* select_list ::= select_sublist */ yytestcase(yyruleno==400);
{ yylhsminor.yy424 = yymsp[0].minor.yy424; }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 162: /* tags_def ::= TAGS NK_LP column_def_list NK_RP */
{ yymsp[-3].minor.yy424 = yymsp[-1].minor.yy424; }
        break;
      case 163: /* table_options ::= */
{ yymsp[1].minor.yy632 = createDefaultTableOptions(pCxt); }
        break;
      case 164: /* table_options ::= table_options COMMENT NK_STRING */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-2].minor.yy632, TABLE_OPTION_COMMENT, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 165: /* table_options ::= table_options MAX_DELAY duration_list */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-2].minor.yy632, TABLE_OPTION_MAXDELAY, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 166: /* table_options ::= table_options WATERMARK duration_list */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-2].minor.yy632, TABLE_OPTION_WATERMARK, yymsp[0].minor.yy424); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 167: /* table_options ::= table_options ROLLUP NK_LP rollup_func_list NK_RP */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-4].minor.yy632, TABLE_OPTION_ROLLUP, yymsp[-1].minor.yy424); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 168: /* table_options ::= table_options TTL NK_INTEGER */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-2].minor.yy632, TABLE_OPTION_TTL, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 169: /* table_options ::= table_options SMA NK_LP col_name_list NK_RP */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-4].minor.yy632, TABLE_OPTION_SMA, yymsp[-1].minor.yy424); }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 170: /* alter_table_options ::= alter_table_option */
{ yylhsminor.yy632 = createAlterTableOptions(pCxt); yylhsminor.yy632 = setTableOption(pCxt, yylhsminor.yy632, yymsp[0].minor.yy605.type, &yymsp[0].minor.yy605.val); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 171: /* alter_table_options ::= alter_table_options alter_table_option */
{ yylhsminor.yy632 = setTableOption(pCxt, yymsp[-1].minor.yy632, yymsp[0].minor.yy605.type, &yymsp[0].minor.yy605.val); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 172: /* alter_table_option ::= COMMENT NK_STRING */
{ yymsp[-1].minor.yy605.type = TABLE_OPTION_COMMENT; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 173: /* alter_table_option ::= TTL NK_INTEGER */
{ yymsp[-1].minor.yy605.type = TABLE_OPTION_TTL; yymsp[-1].minor.yy605.val = yymsp[0].minor.yy0; }
        break;
      case 174: /* duration_list ::= duration_literal */
      case 319: /* expression_list ::= expression */ yytestcase(yyruleno==319);
{ yylhsminor.yy424 = createNodeList(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy632)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 175: /* duration_list ::= duration_list NK_COMMA duration_literal */
      case 320: /* expression_list ::= expression_list NK_COMMA expression */ yytestcase(yyruleno==320);
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, releaseRawExprNode(pCxt, yymsp[0].minor.yy632)); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 178: /* rollup_func_name ::= function_name */
{ yylhsminor.yy632 = createFunctionNode(pCxt, &yymsp[0].minor.yy209, NULL); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 179: /* rollup_func_name ::= FIRST */
      case 180: /* rollup_func_name ::= LAST */ yytestcase(yyruleno==180);
{ yylhsminor.yy632 = createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 183: /* col_name ::= column_name */
{ yylhsminor.yy632 = createColumnNode(pCxt, NULL, &yymsp[0].minor.yy209); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 184: /* cmd ::= SHOW DNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DNODES_STMT, NULL, NULL); }
        break;
      case 185: /* cmd ::= SHOW USERS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_USERS_STMT, NULL, NULL); }
        break;
      case 186: /* cmd ::= SHOW DATABASES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_DATABASES_STMT, NULL, NULL); }
        break;
      case 187: /* cmd ::= SHOW db_name_cond_opt TABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TABLES_STMT, yymsp[-2].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 188: /* cmd ::= SHOW db_name_cond_opt STABLES like_pattern_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STABLES_STMT, yymsp[-2].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 189: /* cmd ::= SHOW db_name_cond_opt VGROUPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VGROUPS_STMT, yymsp[-1].minor.yy632, NULL); }
        break;
      case 190: /* cmd ::= SHOW MNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MNODES_STMT, NULL, NULL); }
        break;
      case 191: /* cmd ::= SHOW MODULES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_MODULES_STMT, NULL, NULL); }
        break;
      case 192: /* cmd ::= SHOW QNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QNODES_STMT, NULL, NULL); }
        break;
      case 193: /* cmd ::= SHOW FUNCTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_FUNCTIONS_STMT, NULL, NULL); }
        break;
      case 194: /* cmd ::= SHOW INDEXES FROM table_name_cond from_db_opt */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_INDEXES_STMT, yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 195: /* cmd ::= SHOW STREAMS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_STREAMS_STMT, NULL, NULL); }
        break;
      case 196: /* cmd ::= SHOW ACCOUNTS */
{ pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_EXPRIE_STATEMENT); }
        break;
      case 197: /* cmd ::= SHOW APPS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_APPS_STMT, NULL, NULL); }
        break;
      case 198: /* cmd ::= SHOW CONNECTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CONNECTIONS_STMT, NULL, NULL); }
        break;
      case 199: /* cmd ::= SHOW LICENCE */
      case 200: /* cmd ::= SHOW GRANTS */ yytestcase(yyruleno==200);
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_LICENCE_STMT, NULL, NULL); }
        break;
      case 201: /* cmd ::= SHOW CREATE DATABASE db_name */
{ pCxt->pRootNode = createShowCreateDatabaseStmt(pCxt, &yymsp[0].minor.yy209); }
        break;
      case 202: /* cmd ::= SHOW CREATE TABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_TABLE_STMT, yymsp[0].minor.yy632); }
        break;
      case 203: /* cmd ::= SHOW CREATE STABLE full_table_name */
{ pCxt->pRootNode = createShowCreateTableStmt(pCxt, QUERY_NODE_SHOW_CREATE_STABLE_STMT, yymsp[0].minor.yy632); }
        break;
      case 204: /* cmd ::= SHOW QUERIES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_QUERIES_STMT, NULL, NULL); }
        break;
      case 205: /* cmd ::= SHOW SCORES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SCORES_STMT, NULL, NULL); }
        break;
      case 206: /* cmd ::= SHOW TOPICS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TOPICS_STMT, NULL, NULL); }
        break;
      case 207: /* cmd ::= SHOW VARIABLES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_VARIABLE_STMT, NULL, NULL); }
        break;
      case 208: /* cmd ::= SHOW BNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_BNODES_STMT, NULL, NULL); }
        break;
      case 209: /* cmd ::= SHOW SNODES */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_SNODES_STMT, NULL, NULL); }
        break;
      case 210: /* cmd ::= SHOW CLUSTER */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_CLUSTER_STMT, NULL, NULL); }
        break;
      case 211: /* cmd ::= SHOW TRANSACTIONS */
{ pCxt->pRootNode = createShowStmt(pCxt, QUERY_NODE_SHOW_TRANSACTIONS_STMT, NULL, NULL); }
        break;
      case 212: /* db_name_cond_opt ::= */
      case 217: /* from_db_opt ::= */ yytestcase(yyruleno==217);
{ yymsp[1].minor.yy632 = createDefaultDatabaseCondValue(pCxt); }
        break;
      case 213: /* db_name_cond_opt ::= db_name NK_DOT */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-1].minor.yy209); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 214: /* like_pattern_opt ::= */
      case 222: /* index_options ::= */ yytestcase(yyruleno==222);
      case 251: /* into_opt ::= */ yytestcase(yyruleno==251);
      case 407: /* where_clause_opt ::= */ yytestcase(yyruleno==407);
      case 411: /* twindow_clause_opt ::= */ yytestcase(yyruleno==411);
      case 416: /* sliding_opt ::= */ yytestcase(yyruleno==416);
      case 418: /* fill_opt ::= */ yytestcase(yyruleno==418);
      case 430: /* having_clause_opt ::= */ yytestcase(yyruleno==430);
      case 440: /* slimit_clause_opt ::= */ yytestcase(yyruleno==440);
      case 444: /* limit_clause_opt ::= */ yytestcase(yyruleno==444);
{ yymsp[1].minor.yy632 = NULL; }
        break;
      case 215: /* like_pattern_opt ::= LIKE NK_STRING */
{ yymsp[-1].minor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
        break;
      case 216: /* table_name_cond ::= table_name */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy209); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 218: /* from_db_opt ::= FROM db_name */
{ yymsp[-1].minor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy209); }
        break;
      case 219: /* cmd ::= CREATE SMA INDEX not_exists_opt index_name ON table_name index_options */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_SMA, yymsp[-4].minor.yy137, &yymsp[-3].minor.yy209, &yymsp[-1].minor.yy209, NULL, yymsp[0].minor.yy632); }
        break;
      case 220: /* cmd ::= CREATE FULLTEXT INDEX not_exists_opt index_name ON table_name NK_LP col_name_list NK_RP */
{ pCxt->pRootNode = createCreateIndexStmt(pCxt, INDEX_TYPE_FULLTEXT, yymsp[-6].minor.yy137, &yymsp[-5].minor.yy209, &yymsp[-3].minor.yy209, yymsp[-1].minor.yy424, NULL); }
        break;
      case 221: /* cmd ::= DROP INDEX exists_opt index_name ON table_name */
{ pCxt->pRootNode = createDropIndexStmt(pCxt, yymsp[-3].minor.yy137, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209); }
        break;
      case 223: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_RP sliding_opt */
{ yymsp[-8].minor.yy632 = createIndexOption(pCxt, yymsp[-6].minor.yy424, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), NULL, yymsp[0].minor.yy632); }
        break;
      case 224: /* index_options ::= FUNCTION NK_LP func_list NK_RP INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt */
{ yymsp[-10].minor.yy632 = createIndexOption(pCxt, yymsp[-8].minor.yy424, releaseRawExprNode(pCxt, yymsp[-4].minor.yy632), releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), yymsp[0].minor.yy632); }
        break;
      case 227: /* func ::= function_name NK_LP expression_list NK_RP */
{ yylhsminor.yy632 = createFunctionNode(pCxt, &yymsp[-3].minor.yy209, yymsp[-1].minor.yy424); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 228: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS query_expression */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-3].minor.yy137, &yymsp[-2].minor.yy209, yymsp[0].minor.yy632, NULL, NULL); }
        break;
      case 229: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS DATABASE db_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy137, &yymsp[-3].minor.yy209, NULL, &yymsp[0].minor.yy209, NULL); }
        break;
      case 230: /* cmd ::= CREATE TOPIC not_exists_opt topic_name AS STABLE full_table_name */
{ pCxt->pRootNode = createCreateTopicStmt(pCxt, yymsp[-4].minor.yy137, &yymsp[-3].minor.yy209, NULL, NULL, yymsp[0].minor.yy632); }
        break;
      case 231: /* cmd ::= DROP TOPIC exists_opt topic_name */
{ pCxt->pRootNode = createDropTopicStmt(pCxt, yymsp[-1].minor.yy137, &yymsp[0].minor.yy209); }
        break;
      case 232: /* cmd ::= DROP CONSUMER GROUP exists_opt cgroup_name ON topic_name */
{ pCxt->pRootNode = createDropCGroupStmt(pCxt, yymsp[-3].minor.yy137, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209); }
        break;
      case 233: /* cmd ::= DESC full_table_name */
      case 234: /* cmd ::= DESCRIBE full_table_name */ yytestcase(yyruleno==234);
{ pCxt->pRootNode = createDescribeStmt(pCxt, yymsp[0].minor.yy632); }
        break;
      case 235: /* cmd ::= RESET QUERY CACHE */
{ pCxt->pRootNode = createResetQueryCacheStmt(pCxt); }
        break;
      case 236: /* cmd ::= EXPLAIN analyze_opt explain_options query_expression */
{ pCxt->pRootNode = createExplainStmt(pCxt, yymsp[-2].minor.yy137, yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 238: /* analyze_opt ::= ANALYZE */
      case 246: /* agg_func_opt ::= AGGREGATE */ yytestcase(yyruleno==246);
      case 397: /* set_quantifier_opt ::= DISTINCT */ yytestcase(yyruleno==397);
{ yymsp[0].minor.yy137 = true; }
        break;
      case 239: /* explain_options ::= */
{ yymsp[1].minor.yy632 = createDefaultExplainOptions(pCxt); }
        break;
      case 240: /* explain_options ::= explain_options VERBOSE NK_BOOL */
{ yylhsminor.yy632 = setExplainVerbose(pCxt, yymsp[-2].minor.yy632, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 241: /* explain_options ::= explain_options RATIO NK_FLOAT */
{ yylhsminor.yy632 = setExplainRatio(pCxt, yymsp[-2].minor.yy632, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 242: /* cmd ::= COMPACT VNODES IN NK_LP integer_list NK_RP */
{ pCxt->pRootNode = createCompactStmt(pCxt, yymsp[-1].minor.yy424); }
        break;
      case 243: /* cmd ::= CREATE agg_func_opt FUNCTION not_exists_opt function_name AS NK_STRING OUTPUTTYPE type_name bufsize_opt */
{ pCxt->pRootNode = createCreateFunctionStmt(pCxt, yymsp[-6].minor.yy137, yymsp[-8].minor.yy137, &yymsp[-5].minor.yy209, &yymsp[-3].minor.yy0, yymsp[-1].minor.yy304, yymsp[0].minor.yy100); }
        break;
      case 244: /* cmd ::= DROP FUNCTION exists_opt function_name */
{ pCxt->pRootNode = createDropFunctionStmt(pCxt, yymsp[-1].minor.yy137, &yymsp[0].minor.yy209); }
        break;
      case 247: /* bufsize_opt ::= */
{ yymsp[1].minor.yy100 = 0; }
        break;
      case 248: /* bufsize_opt ::= BUFSIZE NK_INTEGER */
{ yymsp[-1].minor.yy100 = taosStr2Int32(yymsp[0].minor.yy0.z, NULL, 10); }
        break;
      case 249: /* cmd ::= CREATE STREAM not_exists_opt stream_name stream_options into_opt AS query_expression */
{ pCxt->pRootNode = createCreateStreamStmt(pCxt, yymsp[-5].minor.yy137, &yymsp[-4].minor.yy209, yymsp[-2].minor.yy632, yymsp[-3].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 250: /* cmd ::= DROP STREAM exists_opt stream_name */
{ pCxt->pRootNode = createDropStreamStmt(pCxt, yymsp[-1].minor.yy137, &yymsp[0].minor.yy209); }
        break;
      case 252: /* into_opt ::= INTO full_table_name */
      case 378: /* from_clause ::= FROM table_reference_list */ yytestcase(yyruleno==378);
      case 408: /* where_clause_opt ::= WHERE search_condition */ yytestcase(yyruleno==408);
      case 431: /* having_clause_opt ::= HAVING search_condition */ yytestcase(yyruleno==431);
{ yymsp[-1].minor.yy632 = yymsp[0].minor.yy632; }
        break;
      case 253: /* stream_options ::= */
{ yymsp[1].minor.yy632 = createStreamOptions(pCxt); }
        break;
      case 254: /* stream_options ::= stream_options TRIGGER AT_ONCE */
{ ((SStreamOptions*)yymsp[-2].minor.yy632)->triggerType = STREAM_TRIGGER_AT_ONCE; yylhsminor.yy632 = yymsp[-2].minor.yy632; }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 255: /* stream_options ::= stream_options TRIGGER WINDOW_CLOSE */
{ ((SStreamOptions*)yymsp[-2].minor.yy632)->triggerType = STREAM_TRIGGER_WINDOW_CLOSE; yylhsminor.yy632 = yymsp[-2].minor.yy632; }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 256: /* stream_options ::= stream_options TRIGGER MAX_DELAY duration_literal */
{ ((SStreamOptions*)yymsp[-3].minor.yy632)->triggerType = STREAM_TRIGGER_MAX_DELAY; ((SStreamOptions*)yymsp[-3].minor.yy632)->pDelay = releaseRawExprNode(pCxt, yymsp[0].minor.yy632); yylhsminor.yy632 = yymsp[-3].minor.yy632; }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 257: /* stream_options ::= stream_options WATERMARK duration_literal */
{ ((SStreamOptions*)yymsp[-2].minor.yy632)->pWatermark = releaseRawExprNode(pCxt, yymsp[0].minor.yy632); yylhsminor.yy632 = yymsp[-2].minor.yy632; }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 258: /* cmd ::= KILL CONNECTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_CONNECTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 259: /* cmd ::= KILL QUERY NK_STRING */
{ pCxt->pRootNode = createKillQueryStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 260: /* cmd ::= KILL TRANSACTION NK_INTEGER */
{ pCxt->pRootNode = createKillStmt(pCxt, QUERY_NODE_KILL_TRANSACTION_STMT, &yymsp[0].minor.yy0); }
        break;
      case 261: /* cmd ::= BALANCE VGROUP */
{ pCxt->pRootNode = createBalanceVgroupStmt(pCxt); }
        break;
      case 262: /* cmd ::= MERGE VGROUP NK_INTEGER NK_INTEGER */
{ pCxt->pRootNode = createMergeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 263: /* cmd ::= REDISTRIBUTE VGROUP NK_INTEGER dnode_list */
{ pCxt->pRootNode = createRedistributeVgroupStmt(pCxt, &yymsp[-1].minor.yy0, yymsp[0].minor.yy424); }
        break;
      case 264: /* cmd ::= SPLIT VGROUP NK_INTEGER */
{ pCxt->pRootNode = createSplitVgroupStmt(pCxt, &yymsp[0].minor.yy0); }
        break;
      case 265: /* dnode_list ::= DNODE NK_INTEGER */
{ yymsp[-1].minor.yy424 = createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
        break;
      case 267: /* cmd ::= SYNCDB db_name REPLICA */
{ pCxt->pRootNode = createSyncdbStmt(pCxt, &yymsp[-1].minor.yy209); }
        break;
      case 268: /* cmd ::= DELETE FROM full_table_name where_clause_opt */
{ pCxt->pRootNode = createDeleteStmt(pCxt, yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 270: /* literal ::= NK_INTEGER */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 271: /* literal ::= NK_FLOAT */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 272: /* literal ::= NK_STRING */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 273: /* literal ::= NK_BOOL */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 274: /* literal ::= TIMESTAMP NK_STRING */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0)); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 275: /* literal ::= duration_literal */
      case 285: /* signed_literal ::= signed */ yytestcase(yyruleno==285);
      case 305: /* expression ::= literal */ yytestcase(yyruleno==305);
      case 306: /* expression ::= pseudo_column */ yytestcase(yyruleno==306);
      case 307: /* expression ::= column_reference */ yytestcase(yyruleno==307);
      case 308: /* expression ::= function_expression */ yytestcase(yyruleno==308);
      case 309: /* expression ::= subquery */ yytestcase(yyruleno==309);
      case 334: /* function_expression ::= literal_func */ yytestcase(yyruleno==334);
      case 370: /* boolean_value_expression ::= boolean_primary */ yytestcase(yyruleno==370);
      case 374: /* boolean_primary ::= predicate */ yytestcase(yyruleno==374);
      case 376: /* common_expression ::= expression */ yytestcase(yyruleno==376);
      case 377: /* common_expression ::= boolean_value_expression */ yytestcase(yyruleno==377);
      case 379: /* table_reference_list ::= table_reference */ yytestcase(yyruleno==379);
      case 381: /* table_reference ::= table_primary */ yytestcase(yyruleno==381);
      case 382: /* table_reference ::= joined_table */ yytestcase(yyruleno==382);
      case 386: /* table_primary ::= parenthesized_joined_table */ yytestcase(yyruleno==386);
      case 433: /* query_expression_body ::= query_primary */ yytestcase(yyruleno==433);
      case 436: /* query_primary ::= query_specification */ yytestcase(yyruleno==436);
{ yylhsminor.yy632 = yymsp[0].minor.yy632; }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 276: /* literal ::= NULL */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 277: /* literal ::= NK_QUESTION */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createPlaceholderValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 278: /* duration_literal ::= NK_VARIABLE */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createDurationValueNode(pCxt, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 279: /* signed ::= NK_INTEGER */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 280: /* signed ::= NK_PLUS NK_INTEGER */
{ yymsp[-1].minor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &yymsp[0].minor.yy0); }
        break;
      case 281: /* signed ::= NK_MINUS NK_INTEGER */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BIGINT, &t);
                                                                                  }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 282: /* signed ::= NK_FLOAT */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 283: /* signed ::= NK_PLUS NK_FLOAT */
{ yymsp[-1].minor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &yymsp[0].minor.yy0); }
        break;
      case 284: /* signed ::= NK_MINUS NK_FLOAT */
{ 
                                                                                    SToken t = yymsp[-1].minor.yy0;
                                                                                    t.n = (yymsp[0].minor.yy0.z + yymsp[0].minor.yy0.n) - yymsp[-1].minor.yy0.z;
                                                                                    yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_DOUBLE, &t);
                                                                                  }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 286: /* signed_literal ::= NK_STRING */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 287: /* signed_literal ::= NK_BOOL */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_BOOL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 288: /* signed_literal ::= TIMESTAMP NK_STRING */
{ yymsp[-1].minor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_TIMESTAMP, &yymsp[0].minor.yy0); }
        break;
      case 289: /* signed_literal ::= duration_literal */
      case 291: /* signed_literal ::= literal_func */ yytestcase(yyruleno==291);
      case 348: /* star_func_para ::= expression */ yytestcase(yyruleno==348);
      case 403: /* select_item ::= common_expression */ yytestcase(yyruleno==403);
      case 449: /* search_condition ::= common_expression */ yytestcase(yyruleno==449);
{ yylhsminor.yy632 = releaseRawExprNode(pCxt, yymsp[0].minor.yy632); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 290: /* signed_literal ::= NULL */
{ yylhsminor.yy632 = createValueNode(pCxt, TSDB_DATA_TYPE_NULL, &yymsp[0].minor.yy0); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 310: /* expression ::= NK_LP expression NK_RP */
      case 375: /* boolean_primary ::= NK_LP boolean_value_expression NK_RP */ yytestcase(yyruleno==375);
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, releaseRawExprNode(pCxt, yymsp[-1].minor.yy632)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 311: /* expression ::= NK_PLUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, releaseRawExprNode(pCxt, yymsp[0].minor.yy632));
                                                                                  }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 312: /* expression ::= NK_MINUS expression */
{
                                                                                    SToken t = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &t, createOperatorNode(pCxt, OP_TYPE_MINUS, releaseRawExprNode(pCxt, yymsp[0].minor.yy632), NULL));
                                                                                  }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 313: /* expression ::= expression NK_PLUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_ADD, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); 
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 314: /* expression ::= expression NK_MINUS expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_SUB, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); 
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 315: /* expression ::= expression NK_STAR expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_MULTI, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); 
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 316: /* expression ::= expression NK_SLASH expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_DIV, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); 
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 317: /* expression ::= expression NK_REM expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, OP_TYPE_REM, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 318: /* expression ::= column_reference NK_ARROW NK_STRING */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_JSON_GET_VALUE, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[0].minor.yy0))); 
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 321: /* column_reference ::= column_name */
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy209, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy209)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 322: /* column_reference ::= table_name NK_DOT column_name */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209, createColumnNode(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy209)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 323: /* pseudo_column ::= ROWTS */
      case 324: /* pseudo_column ::= TBNAME */ yytestcase(yyruleno==324);
      case 326: /* pseudo_column ::= QSTARTTS */ yytestcase(yyruleno==326);
      case 327: /* pseudo_column ::= QENDTS */ yytestcase(yyruleno==327);
      case 328: /* pseudo_column ::= WSTARTTS */ yytestcase(yyruleno==328);
      case 329: /* pseudo_column ::= WENDTS */ yytestcase(yyruleno==329);
      case 330: /* pseudo_column ::= WDURATION */ yytestcase(yyruleno==330);
      case 336: /* literal_func ::= NOW */ yytestcase(yyruleno==336);
{ yylhsminor.yy632 = createRawExprNode(pCxt, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, NULL)); }
  yymsp[0].minor.yy632 = yylhsminor.yy632;
        break;
      case 325: /* pseudo_column ::= table_name NK_DOT TBNAME */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[0].minor.yy0, createNodeList(pCxt, createValueNode(pCxt, TSDB_DATA_TYPE_BINARY, &yymsp[-2].minor.yy209)))); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 331: /* function_expression ::= function_name NK_LP expression_list NK_RP */
      case 332: /* function_expression ::= star_func NK_LP star_func_para_list NK_RP */ yytestcase(yyruleno==332);
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-3].minor.yy209, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-3].minor.yy209, yymsp[-1].minor.yy424)); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 333: /* function_expression ::= CAST NK_LP expression AS type_name NK_RP */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-5].minor.yy0, &yymsp[0].minor.yy0, createCastFunctionNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy632), yymsp[-1].minor.yy304)); }
  yymsp[-5].minor.yy632 = yylhsminor.yy632;
        break;
      case 335: /* literal_func ::= noarg_func NK_LP NK_RP */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0, createFunctionNode(pCxt, &yymsp[-2].minor.yy209, NULL)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 344: /* star_func_para_list ::= NK_STAR */
{ yylhsminor.yy424 = createNodeList(pCxt, createColumnNode(pCxt, NULL, &yymsp[0].minor.yy0)); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 349: /* star_func_para ::= table_name NK_DOT NK_STAR */
      case 406: /* select_item ::= table_name NK_DOT NK_STAR */ yytestcase(yyruleno==406);
{ yylhsminor.yy632 = createColumnNode(pCxt, &yymsp[-2].minor.yy209, &yymsp[0].minor.yy0); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 350: /* predicate ::= expression compare_op expression */
      case 355: /* predicate ::= expression in_op in_predicate_value */ yytestcase(yyruleno==355);
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createOperatorNode(pCxt, yymsp[-1].minor.yy380, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 351: /* predicate ::= expression BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-4].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-4].minor.yy632), releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-4].minor.yy632 = yylhsminor.yy632;
        break;
      case 352: /* predicate ::= expression NOT BETWEEN expression AND expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-5].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createNotBetweenAnd(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy632), releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-5].minor.yy632 = yylhsminor.yy632;
        break;
      case 353: /* predicate ::= expression IS NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NULL, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), NULL));
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 354: /* predicate ::= expression IS NOT NULL */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-3].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &yymsp[0].minor.yy0, createOperatorNode(pCxt, OP_TYPE_IS_NOT_NULL, releaseRawExprNode(pCxt, yymsp[-3].minor.yy632), NULL));
                                                                                  }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 356: /* compare_op ::= NK_LT */
{ yymsp[0].minor.yy380 = OP_TYPE_LOWER_THAN; }
        break;
      case 357: /* compare_op ::= NK_GT */
{ yymsp[0].minor.yy380 = OP_TYPE_GREATER_THAN; }
        break;
      case 358: /* compare_op ::= NK_LE */
{ yymsp[0].minor.yy380 = OP_TYPE_LOWER_EQUAL; }
        break;
      case 359: /* compare_op ::= NK_GE */
{ yymsp[0].minor.yy380 = OP_TYPE_GREATER_EQUAL; }
        break;
      case 360: /* compare_op ::= NK_NE */
{ yymsp[0].minor.yy380 = OP_TYPE_NOT_EQUAL; }
        break;
      case 361: /* compare_op ::= NK_EQ */
{ yymsp[0].minor.yy380 = OP_TYPE_EQUAL; }
        break;
      case 362: /* compare_op ::= LIKE */
{ yymsp[0].minor.yy380 = OP_TYPE_LIKE; }
        break;
      case 363: /* compare_op ::= NOT LIKE */
{ yymsp[-1].minor.yy380 = OP_TYPE_NOT_LIKE; }
        break;
      case 364: /* compare_op ::= MATCH */
{ yymsp[0].minor.yy380 = OP_TYPE_MATCH; }
        break;
      case 365: /* compare_op ::= NMATCH */
{ yymsp[0].minor.yy380 = OP_TYPE_NMATCH; }
        break;
      case 366: /* compare_op ::= CONTAINS */
{ yymsp[0].minor.yy380 = OP_TYPE_JSON_CONTAINS; }
        break;
      case 367: /* in_op ::= IN */
{ yymsp[0].minor.yy380 = OP_TYPE_IN; }
        break;
      case 368: /* in_op ::= NOT IN */
{ yymsp[-1].minor.yy380 = OP_TYPE_NOT_IN; }
        break;
      case 369: /* in_predicate_value ::= NK_LP expression_list NK_RP */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, createNodeListNode(pCxt, yymsp[-1].minor.yy424)); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 371: /* boolean_value_expression ::= NOT boolean_primary */
{
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-1].minor.yy0, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_NOT, releaseRawExprNode(pCxt, yymsp[0].minor.yy632), NULL));
                                                                                  }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 372: /* boolean_value_expression ::= boolean_value_expression OR boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_OR, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 373: /* boolean_value_expression ::= boolean_value_expression AND boolean_value_expression */
{
                                                                                    SToken s = getTokenFromRawExprNode(pCxt, yymsp[-2].minor.yy632);
                                                                                    SToken e = getTokenFromRawExprNode(pCxt, yymsp[0].minor.yy632);
                                                                                    yylhsminor.yy632 = createRawExprNodeExt(pCxt, &s, &e, createLogicConditionNode(pCxt, LOGIC_COND_TYPE_AND, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), releaseRawExprNode(pCxt, yymsp[0].minor.yy632)));
                                                                                  }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 380: /* table_reference_list ::= table_reference_list NK_COMMA table_reference */
{ yylhsminor.yy632 = createJoinTableNode(pCxt, JOIN_TYPE_INNER, yymsp[-2].minor.yy632, yymsp[0].minor.yy632, NULL); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 383: /* table_primary ::= table_name alias_opt */
{ yylhsminor.yy632 = createRealTableNode(pCxt, NULL, &yymsp[-1].minor.yy209, &yymsp[0].minor.yy209); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 384: /* table_primary ::= db_name NK_DOT table_name alias_opt */
{ yylhsminor.yy632 = createRealTableNode(pCxt, &yymsp[-3].minor.yy209, &yymsp[-1].minor.yy209, &yymsp[0].minor.yy209); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 385: /* table_primary ::= subquery alias_opt */
{ yylhsminor.yy632 = createTempTableNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy632), &yymsp[0].minor.yy209); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 387: /* alias_opt ::= */
{ yymsp[1].minor.yy209 = nil_token;  }
        break;
      case 388: /* alias_opt ::= table_alias */
{ yylhsminor.yy209 = yymsp[0].minor.yy209; }
  yymsp[0].minor.yy209 = yylhsminor.yy209;
        break;
      case 389: /* alias_opt ::= AS table_alias */
{ yymsp[-1].minor.yy209 = yymsp[0].minor.yy209; }
        break;
      case 390: /* parenthesized_joined_table ::= NK_LP joined_table NK_RP */
      case 391: /* parenthesized_joined_table ::= NK_LP parenthesized_joined_table NK_RP */ yytestcase(yyruleno==391);
{ yymsp[-2].minor.yy632 = yymsp[-1].minor.yy632; }
        break;
      case 392: /* joined_table ::= table_reference join_type JOIN table_reference ON search_condition */
{ yylhsminor.yy632 = createJoinTableNode(pCxt, yymsp[-4].minor.yy612, yymsp[-5].minor.yy632, yymsp[-2].minor.yy632, yymsp[0].minor.yy632); }
  yymsp[-5].minor.yy632 = yylhsminor.yy632;
        break;
      case 393: /* join_type ::= */
{ yymsp[1].minor.yy612 = JOIN_TYPE_INNER; }
        break;
      case 394: /* join_type ::= INNER */
{ yymsp[0].minor.yy612 = JOIN_TYPE_INNER; }
        break;
      case 395: /* query_specification ::= SELECT set_quantifier_opt select_list from_clause where_clause_opt partition_by_clause_opt twindow_clause_opt group_by_clause_opt having_clause_opt */
{ 
                                                                                    yymsp[-8].minor.yy632 = createSelectStmt(pCxt, yymsp[-7].minor.yy137, yymsp[-6].minor.yy424, yymsp[-5].minor.yy632);
                                                                                    yymsp[-8].minor.yy632 = addWhereClause(pCxt, yymsp[-8].minor.yy632, yymsp[-4].minor.yy632);
                                                                                    yymsp[-8].minor.yy632 = addPartitionByClause(pCxt, yymsp[-8].minor.yy632, yymsp[-3].minor.yy424);
                                                                                    yymsp[-8].minor.yy632 = addWindowClauseClause(pCxt, yymsp[-8].minor.yy632, yymsp[-2].minor.yy632);
                                                                                    yymsp[-8].minor.yy632 = addGroupByClause(pCxt, yymsp[-8].minor.yy632, yymsp[-1].minor.yy424);
                                                                                    yymsp[-8].minor.yy632 = addHavingClause(pCxt, yymsp[-8].minor.yy632, yymsp[0].minor.yy632);
                                                                                  }
        break;
      case 398: /* set_quantifier_opt ::= ALL */
{ yymsp[0].minor.yy137 = false; }
        break;
      case 399: /* select_list ::= NK_STAR */
{ yymsp[0].minor.yy424 = NULL; }
        break;
      case 404: /* select_item ::= common_expression column_alias */
{ yylhsminor.yy632 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy632), &yymsp[0].minor.yy209); }
  yymsp[-1].minor.yy632 = yylhsminor.yy632;
        break;
      case 405: /* select_item ::= common_expression AS column_alias */
{ yylhsminor.yy632 = setProjectionAlias(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), &yymsp[0].minor.yy209); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 410: /* partition_by_clause_opt ::= PARTITION BY expression_list */
      case 427: /* group_by_clause_opt ::= GROUP BY group_by_list */ yytestcase(yyruleno==427);
      case 439: /* order_by_clause_opt ::= ORDER BY sort_specification_list */ yytestcase(yyruleno==439);
{ yymsp[-2].minor.yy424 = yymsp[0].minor.yy424; }
        break;
      case 412: /* twindow_clause_opt ::= SESSION NK_LP column_reference NK_COMMA duration_literal NK_RP */
{ yymsp[-5].minor.yy632 = createSessionWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy632), releaseRawExprNode(pCxt, yymsp[-1].minor.yy632)); }
        break;
      case 413: /* twindow_clause_opt ::= STATE_WINDOW NK_LP expression NK_RP */
{ yymsp[-3].minor.yy632 = createStateWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-1].minor.yy632)); }
        break;
      case 414: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-5].minor.yy632 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-3].minor.yy632), NULL, yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 415: /* twindow_clause_opt ::= INTERVAL NK_LP duration_literal NK_COMMA duration_literal NK_RP sliding_opt fill_opt */
{ yymsp[-7].minor.yy632 = createIntervalWindowNode(pCxt, releaseRawExprNode(pCxt, yymsp[-5].minor.yy632), releaseRawExprNode(pCxt, yymsp[-3].minor.yy632), yymsp[-1].minor.yy632, yymsp[0].minor.yy632); }
        break;
      case 417: /* sliding_opt ::= SLIDING NK_LP duration_literal NK_RP */
{ yymsp[-3].minor.yy632 = releaseRawExprNode(pCxt, yymsp[-1].minor.yy632); }
        break;
      case 419: /* fill_opt ::= FILL NK_LP fill_mode NK_RP */
{ yymsp[-3].minor.yy632 = createFillNode(pCxt, yymsp[-1].minor.yy54, NULL); }
        break;
      case 420: /* fill_opt ::= FILL NK_LP VALUE NK_COMMA literal_list NK_RP */
{ yymsp[-5].minor.yy632 = createFillNode(pCxt, FILL_MODE_VALUE, createNodeListNode(pCxt, yymsp[-1].minor.yy424)); }
        break;
      case 421: /* fill_mode ::= NONE */
{ yymsp[0].minor.yy54 = FILL_MODE_NONE; }
        break;
      case 422: /* fill_mode ::= PREV */
{ yymsp[0].minor.yy54 = FILL_MODE_PREV; }
        break;
      case 423: /* fill_mode ::= NULL */
{ yymsp[0].minor.yy54 = FILL_MODE_NULL; }
        break;
      case 424: /* fill_mode ::= LINEAR */
{ yymsp[0].minor.yy54 = FILL_MODE_LINEAR; }
        break;
      case 425: /* fill_mode ::= NEXT */
{ yymsp[0].minor.yy54 = FILL_MODE_NEXT; }
        break;
      case 428: /* group_by_list ::= expression */
{ yylhsminor.yy424 = createNodeList(pCxt, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); }
  yymsp[0].minor.yy424 = yylhsminor.yy424;
        break;
      case 429: /* group_by_list ::= group_by_list NK_COMMA expression */
{ yylhsminor.yy424 = addNodeToList(pCxt, yymsp[-2].minor.yy424, createGroupingSetNode(pCxt, releaseRawExprNode(pCxt, yymsp[0].minor.yy632))); }
  yymsp[-2].minor.yy424 = yylhsminor.yy424;
        break;
      case 432: /* query_expression ::= query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt */
{ 
                                                                                    yylhsminor.yy632 = addOrderByClause(pCxt, yymsp[-3].minor.yy632, yymsp[-2].minor.yy424);
                                                                                    yylhsminor.yy632 = addSlimitClause(pCxt, yylhsminor.yy632, yymsp[-1].minor.yy632);
                                                                                    yylhsminor.yy632 = addLimitClause(pCxt, yylhsminor.yy632, yymsp[0].minor.yy632);
                                                                                  }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 434: /* query_expression_body ::= query_expression_body UNION ALL query_expression_body */
{ yylhsminor.yy632 = createSetOperator(pCxt, SET_OP_TYPE_UNION_ALL, yymsp[-3].minor.yy632, yymsp[0].minor.yy632); }
  yymsp[-3].minor.yy632 = yylhsminor.yy632;
        break;
      case 435: /* query_expression_body ::= query_expression_body UNION query_expression_body */
{ yylhsminor.yy632 = createSetOperator(pCxt, SET_OP_TYPE_UNION, yymsp[-2].minor.yy632, yymsp[0].minor.yy632); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 437: /* query_primary ::= NK_LP query_expression_body order_by_clause_opt slimit_clause_opt limit_clause_opt NK_RP */
{ yymsp[-5].minor.yy632 = yymsp[-4].minor.yy632; }
  yy_destructor(yypParser,352,&yymsp[-3].minor);
  yy_destructor(yypParser,353,&yymsp[-2].minor);
  yy_destructor(yypParser,354,&yymsp[-1].minor);
        break;
      case 441: /* slimit_clause_opt ::= SLIMIT NK_INTEGER */
      case 445: /* limit_clause_opt ::= LIMIT NK_INTEGER */ yytestcase(yyruleno==445);
{ yymsp[-1].minor.yy632 = createLimitNode(pCxt, &yymsp[0].minor.yy0, NULL); }
        break;
      case 442: /* slimit_clause_opt ::= SLIMIT NK_INTEGER SOFFSET NK_INTEGER */
      case 446: /* limit_clause_opt ::= LIMIT NK_INTEGER OFFSET NK_INTEGER */ yytestcase(yyruleno==446);
{ yymsp[-3].minor.yy632 = createLimitNode(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0); }
        break;
      case 443: /* slimit_clause_opt ::= SLIMIT NK_INTEGER NK_COMMA NK_INTEGER */
      case 447: /* limit_clause_opt ::= LIMIT NK_INTEGER NK_COMMA NK_INTEGER */ yytestcase(yyruleno==447);
{ yymsp[-3].minor.yy632 = createLimitNode(pCxt, &yymsp[0].minor.yy0, &yymsp[-2].minor.yy0); }
        break;
      case 448: /* subquery ::= NK_LP query_expression NK_RP */
{ yylhsminor.yy632 = createRawExprNodeExt(pCxt, &yymsp[-2].minor.yy0, &yymsp[0].minor.yy0, yymsp[-1].minor.yy632); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 452: /* sort_specification ::= expression ordering_specification_opt null_ordering_opt */
{ yylhsminor.yy632 = createOrderByExprNode(pCxt, releaseRawExprNode(pCxt, yymsp[-2].minor.yy632), yymsp[-1].minor.yy578, yymsp[0].minor.yy217); }
  yymsp[-2].minor.yy632 = yylhsminor.yy632;
        break;
      case 453: /* ordering_specification_opt ::= */
{ yymsp[1].minor.yy578 = ORDER_ASC; }
        break;
      case 454: /* ordering_specification_opt ::= ASC */
{ yymsp[0].minor.yy578 = ORDER_ASC; }
        break;
      case 455: /* ordering_specification_opt ::= DESC */
{ yymsp[0].minor.yy578 = ORDER_DESC; }
        break;
      case 456: /* null_ordering_opt ::= */
{ yymsp[1].minor.yy217 = NULL_ORDER_DEFAULT; }
        break;
      case 457: /* null_ordering_opt ::= NULLS FIRST */
{ yymsp[-1].minor.yy217 = NULL_ORDER_FIRST; }
        break;
      case 458: /* null_ordering_opt ::= NULLS LAST */
{ yymsp[-1].minor.yy217 = NULL_ORDER_LAST; }
        break;
      default:
        break;
/********** End reduce actions ************************************************/
  };
  assert( yyruleno<sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0]) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;
  yyact = yy_find_reduce_action(yymsp[yysize].stateno,(YYCODETYPE)yygoto);

  /* There are no SHIFTREDUCE actions on nonterminals because the table
  ** generator has simplified them to pure REDUCE actions. */
  assert( !(yyact>YY_MAX_SHIFT && yyact<=YY_MAX_SHIFTREDUCE) );

  /* It is not possible for a REDUCE to be followed by an error */
  assert( yyact!=YY_ERROR_ACTION );

  yymsp += yysize+1;
  yypParser->yytos = yymsp;
  yymsp->stateno = (YYACTIONTYPE)yyact;
  yymsp->major = (YYCODETYPE)yygoto;
  yyTraceShift(yypParser, yyact, "... then shift");
  return yyact;
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yytos>yypParser->yystack ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
/************ Begin %parse_failure code ***************************************/
/************ End %parse_failure code *****************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  ParseTOKENTYPE yyminor         /* The minor type of the error token */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#define TOKEN yyminor
/************ Begin %syntax_error code ****************************************/

  if (TSDB_CODE_SUCCESS == pCxt->errCode) {
    if(TOKEN.z) {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_SYNTAX_ERROR, TOKEN.z);
    } else {
      pCxt->errCode = generateSyntaxErrMsg(&pCxt->msgBuf, TSDB_CODE_PAR_INCOMPLETE_SQL);
    }
  }
/************ End %syntax_error code ******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  ParseARG_FETCH
  ParseCTX_FETCH
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
#ifndef YYNOERRORRECOVERY
  yypParser->yyerrcnt = -1;
#endif
  assert( yypParser->yytos==yypParser->yystack );
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
/*********** Begin %parse_accept code *****************************************/
/*********** End %parse_accept code *******************************************/
  ParseARG_STORE /* Suppress warning about unused %extra_argument variable */
  ParseCTX_STORE
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "ParseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void Parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  ParseTOKENTYPE yyminor       /* The value for the token */
  ParseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  YYACTIONTYPE yyact;   /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser = (yyParser*)yyp;  /* The parser */
  ParseCTX_FETCH
  ParseARG_STORE

  assert( yypParser->yytos!=0 );
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif

  yyact = yypParser->yytos->stateno;
#ifndef NDEBUG
  if( yyTraceFILE ){
    if( yyact < YY_MIN_REDUCE ){
      fprintf(yyTraceFILE,"%sInput '%s' in state %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact);
    }else{
      fprintf(yyTraceFILE,"%sInput '%s' with pending reduce %d\n",
              yyTracePrompt,yyTokenName[yymajor],yyact-YY_MIN_REDUCE);
    }
  }
#endif

  do{
    assert( yyact==yypParser->yytos->stateno );
    yyact = yy_find_shift_action((YYCODETYPE)yymajor,yyact);
    if( yyact >= YY_MIN_REDUCE ){
      yyact = yy_reduce(yypParser,yyact-YY_MIN_REDUCE,yymajor,
                        yyminor ParseCTX_PARAM);
    }else if( yyact <= YY_MAX_SHIFTREDUCE ){
      yy_shift(yypParser,yyact,(YYCODETYPE)yymajor,yyminor);
#ifndef YYNOERRORRECOVERY
      yypParser->yyerrcnt--;
#endif
      break;
    }else if( yyact==YY_ACCEPT_ACTION ){
      yypParser->yytos--;
      yy_accept(yypParser);
      return;
    }else{
      assert( yyact == YY_ERROR_ACTION );
      yyminorunion.yy0 = yyminor;
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".  
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminor);
      }
      yymx = yypParser->yytos->major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor, &yyminorunion);
        yymajor = YYNOCODE;
      }else{
        while( yypParser->yytos >= yypParser->yystack
            && (yyact = yy_find_reduce_action(
                        yypParser->yytos->stateno,
                        YYERRORSYMBOL)) > YY_MAX_SHIFTREDUCE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yytos < yypParser->yystack || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
          yypParser->yyerrcnt = -1;
#endif
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          yy_shift(yypParser,yyact,YYERRORSYMBOL,yyminor);
        }
      }
      yypParser->yyerrcnt = 3;
      yyerrorhit = 1;
      if( yymajor==YYNOCODE ) break;
      yyact = yypParser->yytos->stateno;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor, yyminor);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      break;
#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor, yyminor);
      }
      yypParser->yyerrcnt = 3;
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
#ifndef YYNOERRORRECOVERY
        yypParser->yyerrcnt = -1;
#endif
      }
      break;
#endif
    }
  }while( yypParser->yytos>yypParser->yystack );
#ifndef NDEBUG
  if( yyTraceFILE ){
    yyStackEntry *i;
    char cDiv = '[';
    fprintf(yyTraceFILE,"%sReturn. Stack=",yyTracePrompt);
    for(i=&yypParser->yystack[1]; i<=yypParser->yytos; i++){
      fprintf(yyTraceFILE,"%c%s", cDiv, yyTokenName[i->major]);
      cDiv = ' ';
    }
    fprintf(yyTraceFILE,"]\n");
  }
#endif
  return;
}

/*
** Return the fallback token corresponding to canonical token iToken, or
** 0 if iToken has no fallback.
*/
int ParseFallback(int iToken){
#ifdef YYFALLBACK
  if( iToken<(int)(sizeof(yyFallback)/sizeof(yyFallback[0])) ){
    return yyFallback[iToken];
  }
#else
  (void)iToken;
#endif
  return 0;
}
